       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA140.                                        
       DATE-WRITTEN. APRIL 1985.                                        
      ***************************************************************** PCS00050
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** PCS00060
      **                     PRICE WATERHOUSE                        ** PCS00070
      **                1410 NORTH WESTSHORE BLVD                    ** PCS00080
      **                   TAMPA, FLORIDA  33607                     ** PCS00090
      **                      (813) 287-9200                         ** PCS00100
      **                                                             ** PCS00110
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------   ------------------------------------- **         
TP1670**  11/13/90     SB        CHANGED PARA 1050- TO PROCESS       **         
      **                         MULTIPLE END-RECORDS.               **         
TP1989**  12/10/90    PDB        CORRECTED REPORT PROBLEMS ACCORD-   **         
      **                         ING TO TPR #1989                    **         
      **  11/04/94    JTH        CORRECTED PROBLEMS ACCORDING TO     **         
      **                         CBK CHANGES AND FUNCTIONALITY OF    **         
      **                         PROGRAM FOR ENHANCEMENTS PCSCA141   **         
      **                         THRU PCSCA145                       **         
      **  07/24/95    TRC        MODIFIED PROGRAM TO WRITE TO NEW    **         
      **                         FILE LAYOUT OF FIORP20, PER TPR 5843**         
TP5310**   09/95      LMB        TPR 5310 - CREATE FILES FCSRP141    **         
TP5310**                         AND FCSRP142                        **         
TP1517**  10/19/95    LMB        WRITE RP142 ONLY IF MAJOR ACCOUNT.  **         
TP2079**  11/20/95    LMB        ADD CODE TO WRITE OUT COMPANY END   **         
TP2079**                         RECORDS FOR RP20, RP141, AND RP142. **         
      **  11/29/95     DW        ADDED CODE TO WRITE FCSRP149.       **         
      **  01/09/96     DW        ADDED CURSOR TO GET AMOUNT OF BILL  **         
      **                         ITEMS FOR PREVIOUS 12 MONTHS.       **         
TP2216**  01/09/96    LMB        MODIFY CODE TO PULL VALID ADDRESS   **         
TP2216**                         AND DATE INFORMATION FOR RPT FILES. **         
TP3467**  03/08/96    LMB        EXTRACT FOR RP149 NOT WORKING       **         
TP6064**  04/11/96    RAO        SOME OF TPR 6064 CHANGES            **         
PCR482**  03/05/97    MAD        CHANGED WS-CODE-REFUND-STATUS-DO    **         
      **                         REFERENCE TO WS-DEPOSIT-STATUS-CD-  **         
      **                         DO.                                 **         
T9841 **  04/08/97    EMM        ADDED CHECK FOR END OF FILE IN PARA **         
T9841 **                         2000-SETUP-PRINT.                   **         
T11059**  05/13/97    RAO        WHEN WS-FULL-NAME-CN-CALC IS SPACES **         
T11059**                         STRING FIRST NAME AND LAST NAME.    **         
T13255**  10/23/97    BAB        MODIFIED TO PROCESS ONLY WHEN THE   **         
      **                         RUN DATE IS EQUAL TO THE BE02 DATE. **         
T14153**  01/28/98    TQT        WRITE TO FCSRP141 ONLY WHEN THE     **         
      **                         ARREARS ARE GREATER THAN FIVE FOR   **         
      **                         60 AND 90 DAY.                      **         
TP7843**  02/18/98    AMG        - CHANGED 7110 PARA TO MORE QUICKLY **         
TP7843**                         AND EFFICIENTLY RETRIEVE ALL 3      **         
TP7843**                         PREVIOUS DATES OF INTEREST AT ONCE. **         
TP7843**                         - ALSO REMOVED THE 7120 AND 7130    **         
TP7843**                         PARAGRAPHS.                         **         
T16261**  05/07/98    AMG        CHANGED 1150 TO CALL 7100 TO CHECK  **         
T16261**                         IF ANY ANNIVERSARY ROWS EXIST IN    **         
T16261**                         CSS_BUDGET_HIST SO THAT NEWLY SET   **         
T16261**                         UP EPP ACCOUNTS DO NOT SHOW UP ON   **         
T16261**                         RP149 REPORT.                       **         
T17412**  08/18/98    JYL        CHANGED 1150- TO INCLUDE BILL CYCLE **         
T17412**                         IN THE RP149 FILE.                  **         
T18110**  10/12/98    MDJ        CHANGED 3500- DEPOSITS ON HAND      **         
      **                         OCCURENCES FROM 5 TO 15.            **         
T19529**  03/25/99    BM80034    Y2K CHANGES                         **         
T25175**  09/25/01    SR88592    CML 25175 ADDED PERFORM 8900-WRITE- **         
T25175**              SR88592    FCSRP20 PARA IF COMPANY NO CHANGED  **         
T25175**              SR88592    TO PRINT CO-END-REC IN FCSRP20      **         
T25176**  09/25/01    KS         COMPANY BREAK LOGIC IS PROPERLY     **         
T25176**                         HANDLED FOR FCSRP141                **         
T25613**  11/12/01    SK88120    COMPANY BREAK LOGIC IS PROPERLY     **         
T25613**                         HANDLED FOR FCSRP20                 **         
T27853**  12/10/02    COVANSYS   MODIFIED THE PROGRAM TO ACCOMODATE  **         
T27853**              CHENNAI    THE PPL'S 20, 60, 80, 90 AND 129    **         
T27853**                         AS UTILITY TYPES (FOR FCSRP141).    **         
T28615**  08/22/03    L FISHER   MODIFIED FIORP141 FILE FOR NEW      **         
T28615**                         60/90 DAY ARREARS FORMAT            **         
T28615**  09/29/03    SS82048    CHANGES TO CREATE A NEW FILE FCSRP806*         
T28615**                         TO BE USED BY PCSRP806 MONTHLY      **         
T28615**                         RECEIVABLE TYPE DELINQUENCY REPORT  **         
PRDFIX**  12/11/03    SR16861    ADDED DISPLAYS TO 7550 FOR PROD PROB**         
PRDFIX**                         ON 12-10-03.                        **         
T35434**  03/01/07    MC9546     REPLACED CSS_MODEL_SQL WITH SET     **         
T35434**                         STATEMENTS.                         **         
C30249**  01/30/08    SV82012    ENHANCEMENT TO 60/90 DAY ARREARS RPT**         
P00047**  01/30/08    VP94820    EPP TO BBP CHANGES.                 **         
P00097**  01/30/08    VP94820    INCREASED NO OF ALLOWED FORECASTED  **         
P00097**                         DNP'S AND CONTRACTS IN BILLING.     **         
A03354**  08/11/11    BD09555    ADD DEPOSIT AMOUNT AND GUARANTOR    **         
A03354**                         AMOUNTS TO OUTPUT FILE              **         
A03354**  08/12/11    BD09555    ENSURE THAT AT-COMPANY-NO IS        **         
A03354**                         POPULATED FOR SO THAT SEB           **         
A03354**                         DELINQUENCY VALUES CAN BE RETRIEVED **         
A03354**                         IN THE MAX DEPOSIT COPYBOOK.        **         
P00599**  05/09/12    AA97148    GET ARREARS, DISCONNECT & DISC EXECP**         
P00599**                         TN FIELDS FROM CSS_CREDIT_PROFILE   **         
P00599**                         TABLE INSTEAD OF BE00 FILE.         **         
A04243** 07/09/2012 NS75440      ADDED DATE FIELD IN CWS00308 CPYBK &**         
A04243**                         USED IT IN CPD00308 7055-SELECT-PARA.*         
A04243**                         ADDED A FLAG FOR BATCH CALLING PROG**          
A05091** 12/30/2015 RB19957    1)ADDED TBATMISC WHICH IS NOW NEEDED  **         
A05091**                         IN CPD00308 FOR SEB SEASONAL FLAG.   *         
A05091**                       2)PER ED, DELETE 'CBL ADV'.            *         
ACT362** 11/30/2016 AD7F921      REMOVED THE UNUSED OUTPUT FILE      **         
ACT362**                         FCSRP141.   APPL00005460             *         
      ******************************************************************        
      *****************************************************************         
       REMARKS.                                                         
                              PCSCA140 NARRATIVE                        
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES                
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TO-TOP-OF-PAGE.                       
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      *****************************************************************         
      **  SELECT STATEMENT FOR THE MANAGEMENT DELINQUENCY REVIEW RPT **         
      *****************************************************************         
      *                                                                         
       COPY CSSRP20.                                                            
      *                                                                         
      *****************************************************************         
      **  SELECT STATEMENT FOR THE SEQUENTIAL BILLING EXTRACT FILE   **         
      *****************************************************************         
      *                                                                         
       COPY CSSBE02.                                                            
      *                                                                         
       COPY CSSRP149.                                                           
      *                                                                         
T28615 COPY CSSRP806.                                                           
                                                                        
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
      *****************************************************************         
      **  FD STATEMENT FOR THE MANAGEMENT DELINQUENCY REVIEW REPORT  **         
      *****************************************************************         
      *                                                                         
       COPY CFDRP20.                                                            
      *                                                                         
      *****************************************************************         
      **   I/O AREA FOR THE MANAGEMENT DELINQUENCY REVIEW REPORT     **         
      *****************************************************************         
      *                                                                         
       COPY FIORP20.                                                            
      *                                                                         
      *****************************************************************         
      **  FD STATEMENT FOR THE SEQUENTIAL BILLING EXTRACT FILE       **         
      *****************************************************************         
      *                                                                         
       COPY CFDBE02.                                                            
      *                                                                         
      *****************************************************************         
      **  I/O AREA FOR THE SEQUENTIAL BILLING EXTRACT FILE           **         
      *****************************************************************         
      *                                                                         
       COPY FIOBE02.                                                            
      *                                                                         
       COPY CFDRP149.                                                           
       COPY FIORP149.                                                           
      *                                                                         
       COPY CFDRP806.                                                           
       COPY FIORP806.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA140'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(45)                        
           VALUE 'WORKING STORAGE FOR PCSCA140 STARTS HERE'.            
      *                                                                         
       01  WS-ABEND-AREA.                                               
           05  WS-ABEND-SPACE          PIC X         VALUE SPACE.       
           05  WS-ABEND-NUMERIC REDEFINES WS-ABEND-SPACE                
                                       PIC 9.                           
      *                                                                         
       01  WS-STATUS-AREA.                                              
           05  WS-FRP20-STATUS         PIC X(02)     VALUE '00'.        
               88 FRP20-SUCCESSFUL                   VALUE '00'.        
           05  WS-FRP149-STATUS        PIC X(02)     VALUE '00'.        
               88 FRP149-SUCCESSFUL                  VALUE '00'.        
           05  WS-FBE02-STATUS         PIC X(02)     VALUE '00'.        
               88 FBE02-SUCCESSFUL                   VALUE '00'.        
T28615     05  WS-FRP806-STATUS        PIC X(02)     VALUE '00'.        
T28615         88 FRP806-SUCCESSFUL                  VALUE '00'.        
      *                                                                         
      *****************************************************************         
      ** WS AREA FOR CHANGING DATES ON DATABASE FOR DISPLAY PURPOSES **         
      *****************************************************************         
      *                                                                         
       COPY CWS00004.                                                           
      *                                                                         
      *****************************************************************         
      **  THE WS AREA IS FOR CUSTOMER ACCOUNTING TENANT RECEIVABLE   **         
      **  HISTORY SEGMENT DATA BLOCK LAYOUT (TRH)                    **         
      *****************************************************************         
      *                                                                         
       COPY CWS00006.                                                           
      *                                                                         
      *****************************************************************         
      ** WS AREA COMPUTES 00, 30, 60, 90 DAY INTERVALS FROM CURR DATE**         
      *****************************************************************         
      *                                                                         
       COPY CWS00007.                                                           
      *                                                                         
      *****************************************************************         
      ** WS-CODES-DATA-PRESENT WORKING STORAGE                                  
      *****************************************************************         
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
      *****************************************************************         
      **         WS AREA FOR ABENDING                                **         
      *****************************************************************         
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      *****************************************************************         
      **         WS AREA TO REDUCE EMBEDDED BLANKS                   **         
      *****************************************************************         
      *                                                                         
       COPY CWS00011.                                                           
      *                                                                         
      *****************************************************************         
      **         WS AREA FOR DB2 AND CICS ERROR PROCESSING           **         
      *****************************************************************         
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      *****************************************************************         
      ** WS AREA FOR PAYMENT PRIORITY LEVELS OF ALL RECEIVABLE TYPES **         
      *****************************************************************         
      *                                                                         
       COPY CWS00041.                                                           
      *                                                                         
      *****************************************************************         
      ** WS AREA FOR MAXIMUM DEPOSIT CALUCLATION                     **         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      **      WS AREA IS THE LAYOUT FOR CUSTOMER BILL EXTRACT INFO   **         
      *****************************************************************         
      *                                                                         
      ** CWS10000 WAS SPLIT INTO CWS1000A & CWS1000B.                           
      *COPY CWS10000.                                                           
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
      *                                                                         
      *****************************************************************         
      **  THE WS AREA IS THE LAYOUT FOR CUSTOMER BILL EXTRACT INFO   **         
      *****************************************************************         
      *                                                                         
       COPY CWS10002.                                                           
      *                                                                         
      *****************************************************************         
      **WS AREA FOR INDEX & TABLE ERROR MESSAGES OF QSAM FILE FCSBE02**         
      *****************************************************************         
      *                                                                         
       COPY CWS10005.                                                           
      *                                                                         
      *****************************************************************         
      **           WS AREA FOR THE ABEND SWITCH                      **         
      *****************************************************************         
      *                                                                         
       COPY CWS09900.                                                   00010001
      *                                                                         
           EXEC SQL                                                     10510001
               INCLUDE SQLCA                                            10520001
           END-EXEC.                                                    10530001
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-END-OF-FCSBE02       PIC X(01)     VALUE 'N'.         
               88  END-OF-FCSBE02-FILE               VALUE 'Y'.         
           05  WS-REV-MONTH-FOUND      PIC X(01)     VALUE 'N'.         
               88  REVENUE-MONTH-IS-FOUND            VALUE 'Y'.         
T28615     05  WS-REBILL-FOUND         PIC X(01)     VALUE 'N'.         
T28615         88  REBILL-IS-FOUND                   VALUE 'Y'.         
           05  WS-QUALIFIES            PIC X(03)     VALUE 'NO '.       
               88  MAJOR-ACCOUNT-QUALIFIES           VALUE 'MAJ'.       
               88  ACCOUNT-QUALIFIES                 VALUE 'YES'.       
           05  WS-REC-TYPE             PIC X(03)     VALUE 'NO '.       
           05  WS-ACCOUNT-FOUND        PIC X(01)     VALUE 'Y'.         
               88  ACCOUNT-WAS-NOT-FOUND             VALUE 'N'.         
           05  WS-ON-DATE-NULL         PIC S9(04)    COMP VALUE ZERO.   
               88  ON-DATE-NULL                      VALUE -1.          
           05  WS-PRINT-FIRST-LINE     PIC X(03)     VALUE 'YES'.       
           05  WS-IS-NEW-ACCOUNT       PIC X(01)     VALUE 'N'.         
               88  ACCOUNT-IS-NEW                    VALUE 'Y'.         
           05  WS-END-REC-PROCESSED    PIC X(01)     VALUE 'N'.         
               88  END-REC-WAS-PROCESSED             VALUE 'Y'.         
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-SUB                  PIC S9(04)    COMP VALUE +0.     
           05  WS-RECEIVABLE-MAX       PIC 9(03)     VALUE 20.          
           05  WS-BRC-FUNC-ID-HOLD     PIC X(01).                       
COB305     05 WS-BLOCK-COUNTER        PIC S9(03) COMP-3 VALUE 0.            
           05  WS-PYMT-PRTY-HOLD       PIC 9(03)     VALUE ZERO.        
           05  WS-PROGRAM-DATE         PIC X(10)     VALUE SPACES.      
           05  WS-FBE02-ACT-REC-CNT    PIC S9(07)    COMP-3 VALUE ZERO. 
           05  WS-FBE02-END-REC-CNT    PIC S9(07)    COMP-3 VALUE ZERO. 
TP2216     05  WS-DEPOSIT-AMT          PIC S9(09)V99 COMP-3 VALUE 0.    
A03354     05  WS-DEPOSIT-ON-HAND-AMT  PIC S9(09)V99 COMP-3 VALUE 0.    
           05  WS-EXPOSURE-AMT         PIC S9(09)V99 VALUE 0.           
           05  WS-SECURITIES-AMT       PIC S9(09)V99 VALUE 0.           
           05  WS-BOND-AMT             PIC S9(09)V99 VALUE 0.           
           05  WS-GUARANTOR-AMT        PIC S9(09)V99 VALUE 0.           
A03354     05  RS-MIN-DEPOSIT-AMT      PIC S9(09)V99 VALUE 0.           
A03354     05  RS-RETURN-CODE          PIC S9(4)     COMP   VALUE 0.    
A03354     05  RS-RETURN-CODE-DISP     PIC S9(4)            VALUE 0.    
TP2216     05  WS-DEPOSIT-TYPE-CODE    PIC X(01).                       
           05  WS-CUR-DATE-BREAKDOWN   PIC X(10).                       
           05  WS-CUR-DATE-BREAKDOWN-RED                                
               REDEFINES WS-CUR-DATE-BREAKDOWN.                         
TP3467         10  WS-CUR-CCYY         PIC 9(04).                       
TP3467         10  WS-CUR-CC-YY-BREAKDOWN                               
TP3467             REDEFINES WS-CUR-CCYY.                               
                   15  WS-CUR-CC       PIC 9(02).                       
                   15  WS-CUR-YY       PIC 9(02).                       
               10  WS-DATE-DASH1       PIC X(01).                       
               10  WS-CUR-MM           PIC 9(02).                       
               10  WS-DATE-DASH2       PIC X(01).                       
               10  WS-CUR-DD           PIC 9(02).                       
           05  WS-DATE-YYMMDD          PIC S9(07).                      
           05  WS-DATE-YYMMDD-RED                                       
               REDEFINES WS-DATE-YYMMDD.                                
               10  FILLER              PIC X(01).                       
               10  WS-YMD-YY-MM        PIC 9(04).                       
               10  WS-YMD-YY-MM-BREAKDOWN                               
                   REDEFINES WS-YMD-YY-MM.                              
                   15  WS-YMD-YY       PIC 9(02).                       
                   15  WS-YMD-MM       PIC 9(02).                       
               10  WS-YMD-DD           PIC 9(02).                       
           05  WS-CURRENT-DATE-YYMMDD  PIC 9(09)     VALUE ZERO.        
           05  WS-CURRENT-DATE-RED                                      
               REDEFINES WS-CURRENT-DATE-YYMMDD.                        
               10  FILLER              PIC 9(01).                       
               10  WS-CURRENT-CC       PIC 9(02).                       
               10  WS-CURRENT-YY       PIC 9(02).                       
               10  WS-CURRENT-MM       PIC 9(02).                       
               10  WS-CURRENT-DD       PIC 9(02).                       
           05  WS-DATE-9-BREAKDOWN     PIC 9(09)     VALUE ZERO.        
           05  WS-DATE-9-RED                                            
               REDEFINES WS-DATE-9-BREAKDOWN.                           
               10  FILLER              PIC X(01).                       
               10  WS-DATE-9-CC        PIC X(02).                       
               10  WS-DATE-9-YY        PIC X(02).                       
               10  WS-DATE-9-MM        PIC X(02).                       
               10  WS-DATE-9-DD        PIC X(02).                       
           05  WS-CURRENT-JULIAN-DATE  PIC S9(10)    VALUE ZERO.        
           05  WS-DATE-NUM.                                             
               10  WS-DT-NUM-1         PIC 9(02).                       
               10  WS-DT-NUM-2         PIC 9(02).                       
               10  WS-DT-NUM-3         PIC 9(02).                       
           05  WS-DATE-NUMER REDEFINES WS-DATE-NUM                      
                                       PIC 9(06).                       
           05  WS-ANNIV-DATE           PIC 9(06).                       
COB305     05 WS-PREV-BILL-DATE        PIC S9(06)V COMP-3 VALUE 0.            
COB305     05 WS-HOLD-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.            
           05  WS-REV-MNTH-CNTR        PIC 9(02)     VALUE ZERO.        
           05  WS-FRP149-PREV-HIST     PIC S9(09)V99 COMP-3 VALUE ZERO. 
COB305     05 WS-CHECK-FIELD        PIC S9(05)V99 COMP-3 VALUE 0.            
COB305     05 WS-CHECK-FIELD-2        PIC S9(05)V99 COMP-3 VALUE 0.            
           05  WS-LINES-PRT-CHECK      PIC S9(03)    COMP-3 VALUE ZERO. 
           05  WS-LINE-COUNTER         PIC S9(03)    COMP-3 VALUE ZERO. 
           05  WS-PREVIOUS-FIELDS-TBL  PIC 9(03)     VALUE ZERO.        
           05  FILLER REDEFINES WS-PREVIOUS-FIELDS-TBL.                 
               10  WS-LOCAL-OFFICE-TBL PIC 9(03).                       
           05  WS-ACCT-NO              PIC X(13)     VALUE SPACES.      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.            
           05  WS-PREV-LOCAL-OFFICE    PIC X(03)     VALUE SPACES.      
TP5310     05  WS-PREV-COMPANY-NO      PIC X(02)     VALUE SPACES.      
           05  WS-PREV-FRP149-COMPANY-NO                                
                                       PIC X(02)     VALUE SPACES.      
           05  WS-HOUSE-NO-UNPK        PIC 9(05).                       
           05  WS-FCSRP20-REC-CNTR     PIC 9(07)     VALUE ZERO.        
T28615     05  WS-FCSRP806-REC-CNTR    PIC 9(07)     VALUE ZERO.        
           05  WS-FCSRP149-REC-CNTR    PIC 9(07)     VALUE ZERO.        
TP2079     05  WS-FCSRP20-CO-REC-CTR   PIC 9(07)     VALUE ZERO.        
T28615     05  WS-FCSRP806-CO-REC-CTR  PIC 9(07)     VALUE ZERO.        
           05  WS-FCSRP149-CO-REC-CTR  PIC 9(07)     VALUE ZERO.        
           05  WS-RPT1-LINE-SEQ-NO     PIC 9(05)     COMP-3 VALUE ZERO. 
           05  WS-RPT-SAVE-ACCT-NO     PIC 9(11)     VALUE ZERO.        
           05  WS-RPT-SAVE-TNT-NO      PIC 9(03)     VALUE ZERO.        
           05  WS-PCB-DBNAME.                                           
               10  FILLER              PIC X(05).                       
115603         10  WS-PCB-PART-NO      PIC 9(02)     VALUE ZERO.        
               10  FILLER              PIC X(01).                       
           05  WS-CUST-NAME            PIC X(50).                       
           05  WS-CUST-NAME-DET REDEFINES WS-CUST-NAME.                 
               10  WS-CUST-FNAME       PIC X(15).                       
               10  WS-CUST-MID-INIT    PIC X(15).                       
               10  WS-CUST-LNAME       PIC X(20).                       
T30249     05  WS-DATABASE                        PIC 9(1) VALUE ZERO.  
T30249         88  CSR-DATABASE                   VALUE 1.              
T30249         88  SEB-DATABASE                   VALUE 2.              
      *                                                                         
T11059 01 WS-INDEX                           PIC S9(8) COMP VALUE ZERO. 
T11059 01  WS-FROM.                                                     
T11059     10  WS-FROM-X                OCCURS 21 TIMES PIC X.          
T11059 01  WS-DELIMITER                 PIC X VALUE ';'.                
T11059 01  WS-CUST-LAST-NAME            PIC X(20) VALUE SPACES.         
T11059 01  WS-CUST-FIRST-NAME           PIC X(15) VALUE SPACES.         
T11059 01  WS-CUST-MIDDLE-NAME          PIC X(15) VALUE SPACES.         
       01  WS-ADDR-BREAKDOWN.                                           
           05  WS-HOUSE-NO             PIC X(05).                       
           05  FILLER                  PIC X(01)     VALUE SPACE.       
           05  WS-PREFIX1              PIC X(03).                       
           05  FILLER                  PIC X(01)     VALUE SPACE.       
           05  WS-PREFIX2              PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE SPACE.       
           05  WS-STREET-NAME          PIC X(16).                       
           05  FILLER                  PIC X(01)     VALUE SPACE.       
           05  WS-SUFFIX               PIC X(03).                       
           05  FILLER                  PIC X(01)     VALUE SPACE.       
           05  WS-LOC1                 PIC X(04).                       
           05  FILLER                  PIC X(01)     VALUE SPACE.       
           05  WS-LOC2                 PIC X(04).                       
      *                                                                         
       01  WS-CITY-STATE-BREAKDOWN.                                     
           05  WS-CITY                 PIC X(26).                       
           05  FILLER                  PIC X(01)     VALUE SPACE.       
           05  WS-STATE                PIC X(02).                       
      *                                                                         
       01  WS-ZIP-CODE-BREAKDOWN       PIC 9(09).                       
       01  WS-ZIP-CODE-BREAKDOWN-RED                                    
           REDEFINES WS-ZIP-CODE-BREAKDOWN.                             
           05  WS-ZIP-CODE-FIRST-5     PIC 9(05).                       
           05  WS-ZIP-CODE-LAST-4      PIC 9(04).                       
           05  WS-ZIP-CODE-LAST-4-RED                                   
               REDEFINES WS-ZIP-CODE-LAST-4                             
                                       PIC X(04).                       
      *                                                                         
       01  WS-ZIP-CODE-TABLE-KEY       PIC 9(10).                       
       01  WS-ZIP-CODE-TABLE-KEY-RED                                    
           REDEFINES WS-ZIP-CODE-TABLE-KEY.                             
           05  FILLER                  PIC 9(04).                       
           05  WS-ZIP-TABLE-KEY-FIRST-5                                 
                                       PIC 9(05).                       
           05  WS-ZIP-TABLE-KEY-ADD-ON PIC 9(01).                       
      *                                                                         
       01  WS-DATE-TIMETABLE.                                           
           05  WS-85-DAYS-AGO-DATE     PIC X(10).                       
           05  WS-55-DAYS-AGO-DATE     PIC X(10).                       
           05  WS-25-DAYS-AGO-DATE     PIC X(10).                       
           05  WS-DAY                  PIC S9(04) COMP.                 
           05  WS-TEMP-DATE            PIC X(10).                       
           05  WS-DATE-FOUND           PIC X(01) VALUE 'N'.             
           05  WS-DAYS-INDX            PIC 9(01).                       
           05  WS-HOLIDAY-EXISTS       PIC X(01).                       
               88   HOLIDAY-EXISTS               VALUE 'Y'.             
T16261     05  WS-ANNIVERSARY-EXISTS   PIC X(01).                       
T16261         88   ANNIVERSARY-EXISTS           VALUE 'Y'.             
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-AA                   PIC X(01)     VALUE 'A'.         
           05  WS-BB                   PIC X(01)     VALUE 'B'.         
           05  WS-D                    PIC X(01)     VALUE 'D'.         
           05  WS-E                    PIC X(01)     VALUE 'E'.         
           05  WS-F                    PIC X(01)     VALUE 'F'.         
           05  WS-G                    PIC X(01)     VALUE 'G'.         
           05  WS-H                    PIC X(01)     VALUE 'H'.         
           05  WS-I                    PIC X(01)     VALUE 'I'.         
           05  WS-J                    PIC X(01)     VALUE 'J'.         
           05  WS-K                    PIC X(01)     VALUE 'K'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-S                    PIC X(01)     VALUE 'S'.         
           05  WS-T                    PIC X(01)     VALUE 'T'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-Z                    PIC X(01)     VALUE 'Z'.         
           05  WS-YES                  PIC X(03)     VALUE 'YES'.       
           05  WS-MAJ                  PIC X(03)     VALUE 'MAJ'.       
           05  WS-NO                   PIC X(03)     VALUE 'NO '.       
           05  WS-TOT                  PIC X(03)     VALUE 'TOT'.       
           05  WS-ONE                  PIC X(01)     VALUE '1'.         
           05  WS-TWO                  PIC X(01)     VALUE '2'.         
T14153     05  WS-FIVE        PIC S9(09)V99 COMP-3   VALUE 5.00.        
           05  WS-1                    PIC X(01)     VALUE '1'.         
           05  WS-2                    PIC X(01)     VALUE '2'.         
           05  WS-0009                 PIC X(04)     VALUE '0009'.      
           05  WS-DATE-DASH1           PIC X(01)     VALUE '-'.         
           05  WS-DATE-DASH2           PIC X(01)     VALUE '-'.         
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSCA140'.  
                                                                        
T25176 01  WS-FLAGS.                                                    
T25613     05  WS-TEMP-FIORP20         PIC X(201)    VALUE SPACES.      
                                                                        
       01  WS-ACCUMULATORS.                                             
COB305     05 WS-00-DAY-UTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-30-DAY-UTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-60-DAY-UTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-90-DAY-UTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-00-DAY-NONUTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-30-DAY-NONUTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-60-DAY-NONUTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-90-DAY-NONUTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-00-DAY-PJS        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-30-DAY-PJS        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-60-DAY-PJS        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-90-DAY-PJS        PIC S9(09)V99 COMP-3 VALUE 0.            
C28615     05  WS-CONTRACT-MONEY.                                       
COB305         10 WS-00-DAY-CONTRACT        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.            
COB305         10 WS-30-DAY-CONTRACT        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.            
COB305         10 WS-60-DAY-CONTRACT        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.            
COB305         10 WS-90-DAY-CONTRACT        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.            
COB305     05 WS-FULL-BAL-UTL        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-FULL-BAL-NONUTL        PIC S9(09)V99 COMP-3 VALUE 0.           
COB305     05 WS-FULL-BAL-PJS        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-FULL-BAL-CNT        PIC S9(09)V99 COMP-3 VALUE 0.            
C28615     05  WS-ACCT-FULL-BAL        PIC S9(09)V99 COMP-3 VALUE 0.    
COB305     05 WS-00-DAY-TOT        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-30-DAY-TOT        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-60-DAY-TOT        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-90-DAY-TOT        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-ARREARS-TOT        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-00-DAY-DET        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-30-DAY-DET        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-60-DAY-DET        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-90-DAY-DET        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-BILLED-DET        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-30-DAY-BUD-TOT        PIC S9(09)V99 COMP-3 VALUE 0.            
COB305     05 WS-60-DAY-BUD-TOT        PIC S9(09)V99 COMP-3 VALUE 0.            
      *                                                                         
C28615 01  WS-REC-WRITTEN-FLAG        PIC X(01) VALUE 'N'.              
C28615     88  WS-REC-WRITTEN         VALUE 'Y'.                        
                                                                        
C28615 01  WS-CNT-TYPE                PIC X(01) VALUE SPACES.           
C28615 01  WS-CNT-FINISH-FLAG         PIC X(01) VALUE 'N'.              
C28615     88  WS-CNT-FINISH          VALUE 'Y'.                        
C28615 01  WS-CNT-IND                 PIC 9(02) VALUE ZEROS.            
C28615 01  WS-SB-INDEX               PIC 9(02) VALUE ZEROS.             
C28615 01  WS-SAVE-CNT-TYPE           PIC X(01) VALUE SPACES.           
C28615 01  WS-SAVE-DNP                PIC X(10) VALUE SPACES.           
C28615 01  WS-CRED-IND                PIC 9(02) VALUE ZEROS.            
C28615 01  GUARANTOR-IND              PIC S9(04) COMP.                  
A03354 01  DEPOSIT-IND                PIC S9(04) COMP.                  
                                                                        
C28615 01  WS-DOLLAR-LIMIT             PIC S9(09)V99 VALUE ZEROS.       
                                                                        
COB305 01 WS-HOLD-DEL-VALUE        PIC S9(4)V9(5) USAGE COMP-3 VALUE 0.     
                                                                        
      *****************************************************************         
      **      WS AREA IS FOR MISCELLANEOUS AND DATA INPUT            **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCSTALT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGTNTR                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
TP5310     EXEC SQL                                                             
TP5310         INCLUDE TBARTYPE                                                 
TP5310     END-EXEC.                                                            
      *                                                                         
TP2216     EXEC SQL                                                             
TP2216         INCLUDE TBDEPHND                                                 
TP2216     END-EXEC.                                                            
      *                                                                         
T11171     EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
A03354     EXEC SQL                                                             
A03354         INCLUDE TBUTLENV                                                 
A03354     END-EXEC.                                                            
A03354*                                                                         
A03354     EXEC SQL                                                             
A03354         INCLUDE TBLOCOFC                                                 
A03354     END-EXEC.                                                            
A03354*                                                                         
A03354     EXEC SQL                                                             
A03354         INCLUDE TBBILWDW                                                 
A03354     END-EXEC.                                                            
A03354*                                                                         
A03354     EXEC SQL                                                             
A03354         INCLUDE TBCSTPRM                                                 
A03354     END-EXEC.                                                            
A03354*                                                                         
A03354     EXEC SQL                                                             
A03354         INCLUDE TBRTCRTR                                                 
A03354     END-EXEC.                                                            
A03354*                                                                         
      *                                                                         
T11171     EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                         
T16261     EXEC SQL                                                             
T16261         INCLUDE TBBGTHST                                                 
T16261     END-EXEC.                                                            
                                                                        
C28165     EXEC SQL                                                             
C28615         INCLUDE TBCRPROF                                                 
C28615     END-EXEC.                                                            
                                                                        
C28165     EXEC SQL                                                             
C28615         INCLUDE TBREGPRF                                                 
C28615     END-EXEC.                                                            
                                                                        
C28615** DCLGEN FOR CSS_DELINQUENCY                                             
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
C28615** DCLGEN FOR CSS_MTRD_EVNRNMT                                            
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
A05091** DCLGEN FOR CSS_ACCT_MISC_INFO TA                                       
A05091     EXEC SQL                                                             
A05091        INCLUDE TBATMISC                                                  
A05091     END-EXEC.                                                            
A05091*                                                                         
A03354     EXEC SQL                                                     10510001
A03354         INCLUDE CWS00308                                                 
A03354     END-EXEC.                                                            
      *                                                                         
                                                                        
      *****************************************************************         
      **      DECLARE CURSOR FOR CSS_BILLING_HDR/CSS_BILLING_DET     **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
               DECLARE BI_BG_CRSR CURSOR FOR                            
               SELECT                                                   
                   BG.BILL_NO,                                          
                   AMT_BILL_ITEM                                        
               FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED),                   
                    CSS_BILLING_DET BG WITH(READUNCOMMITTED)                    
               WHERE BG.ACCOUNT_NO    = :WS-HOLD-ACCT-NO                
               AND BI.ACCOUNT_NO      =  BG.ACCOUNT_NO                  
               AND BI.BILL_NO         =  BG.BILL_NO                     
               AND CODE_BILL_ITM_TYPE = 'C'                             
               AND CODE_BILL_ITM_IND  = 'A'                             
               AND     REVENUE_MONTH  = :WS-PREV-BILL-DATE              
C30249         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BI_BG_CRSR CURSOR FOR                                    
MFA-TR*        SELECT                                                           
MFA-TR*            BG.BILL_NO,                                                  
MFA-TR*            AMT_BILL_ITEM                                                
MFA-TR*        FROM CSS_BILLING_HDR BI,                                         
MFA-TR*             CSS_BILLING_DET BG                                          
MFA-TR*        WHERE BG.ACCOUNT_NO    = :WS-HOLD-ACCT-NO                        
MFA-TR*        AND BI.ACCOUNT_NO      =  BG.ACCOUNT_NO                          
MFA-TR*        AND BI.BILL_NO         =  BG.BILL_NO                             
MFA-TR*        AND CODE_BILL_ITM_TYPE = 'C'                                     
MFA-TR*        AND CODE_BILL_ITM_IND  = 'A'                                     
MFA-TR*        AND     REVENUE_MONTH  = :WS-PREV-BILL-DATE                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **      DECLARE CURSOR FOR CSS_DEP_ON_HAND                     **         
      *****************************************************************         
      *                                                                         
TP2216     EXEC SQL                                                     
TP2216        DECLARE DEPONHND_CSR CURSOR FOR                           
TP2216          SELECT AMT_DEPOSIT                                      
TP2216           FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
TP2216          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                       
C30249          FOR READ ONLY                                   
TP2216     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DEPONHND_CSR CURSOR FOR                                   
MFA-TR*         SELECT AMT_DEPOSIT                                              
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
      *****************************************************************         
      **        I/O AREA FOR THE COMMON PARAMETER FILE 'A'           **         
      *****************************************************************         
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
      *****************************************************************         
      **          I/O AREA FOR THE VSAM CONTROL FILE                 **         
      *****************************************************************         
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
      *****************************************************************         
      **            WS AREA FOR BILL CYCLE INFORMATION               **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA140 ENDS HERE  '.            
      *                                                                         
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE.                                            **          
      **       CONTROLS THE MAIN PROCESS OF PROGRAM                 **          
      **                                                            **          
      ****************************************************************          
                                                                        
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 0500-PROCESS-BEGIN-REC        THRU 0500-EXIT.        
C28615     PERFORM 0700-GET-DELQ THRU 0700-EXIT.                        
           PERFORM 7000-READ-FCSBE02             THRU 7000-EXIT         
                  UNTIL E-FBE02-KEY-EREC NUMERIC                        
115603                 OR END-OF-FCSBE02-FILE.                          
           IF END-OF-FCSBE02-FILE                                       
115603         PERFORM 4100-WRITE-BEGIN-CONTROLS THRU 4100-EXIT         
115603         PERFORM 4200-WRITE-END-CONTROLS   THRU 4200-EXIT         
115603         DISPLAY '**    PCSCA140 INFORMATIONAL MSG    **'         
               DISPLAY '**        BE02 FILE IS EMPTY        **'         
115603         DISPLAY '**       NO RECORDS TO PROCESS      **'         
115603     ELSE                                                         
115603         MOVE E-FBE02-ACCOUNT-NO TO WS-ACCT-NO                    
TP2216                                    WS-ACCOUNT-NO                 
115603         MOVE E-FBE02-LOCAL-OFFICE                                
                                       TO WS-PREV-LOCAL-OFFICE          
TP5310         MOVE E-FBE02-COMPANY-NO TO WS-PREV-COMPANY-NO            
                                         WS-PREV-FRP149-COMPANY-NO      
A03354                                   AT-COMPANY-NO                  
115603         PERFORM 4100-WRITE-BEGIN-CONTROLS THRU 4100-EXIT         
115603         PERFORM 1000-MAIN-PROCESS         THRU 1000-EXIT         
115603                UNTIL END-OF-FCSBE02-FILE                         
ACT362         IF WS-FCSRP20-CO-REC-CTR  > ZEROES                       
TP2079             PERFORM 4300-WRITE-COMPANY-END-REC                   
                                                 THRU 4300-EXIT         
TP2079         END-IF                                                   
               IF WS-FCSRP149-CO-REC-CTR > ZEROES                       
                   PERFORM 4301-WRITE-FRP149-COMP-END-REC               
                                                 THRU 4301-EXIT         
               END-IF                                                   
TP2079         IF WS-FCSRP20-CO-REC-CTR > ZEROES                        
TP2079             PERFORM 8900-WRITE-FCSRP20    THRU 8900-EXIT         
TP2079             SUBTRACT 1 FROM WS-FCSRP20-REC-CNTR                  
TP2079         END-IF                                                   
T28615         IF  WS-FCSRP806-CO-REC-CTR > ZEROES                      
T28615             PERFORM 8920-WRITE-FCSRP806   THRU 8920-EXIT         
T28615             SUBTRACT 1 FROM WS-FCSRP806-REC-CNTR                 
T28615         END-IF                                                   
               IF WS-FCSRP149-CO-REC-CTR > ZEROES                       
                   PERFORM 8930-WRITE-FCSRP149   THRU 8930-EXIT         
                   SUBTRACT 1 FROM WS-FCSRP149-REC-CNTR                 
               END-IF                                                   
               PERFORM 4200-WRITE-END-CONTROLS   THRU 4200-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **       COMMON INITIALIZATION ROUTINE                        **          
      **                                                            **          
      ****************************************************************          
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSRP20-FILE                                     
                       FCSRP149-FILE                                    
T28615                 FCSRP806-FILE.                                   
      *                                                                         
           IF FRP20-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSRP20 OPEN.  STATUS IS '        
                        WS-FRP20-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
T28615     IF FRP806-SUCCESSFUL                                         
T28615         CONTINUE                                                 
T28615     ELSE                                                         
T28615         DISPLAY '0100-ERROR ON FCSRP806 OPEN. STATUS IS '        
T28615                  WS-FRP806-STATUS                                
T28615         PERFORM 9900-ABEND                THRU 9900-EXIT         
T28615     END-IF.                                                      
      *                                                                         
           IF FRP149-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSRP149 OPEN. STATUS IS '        
                        WS-FRP149-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                 TO FIORP20                       
                                          E-FRP149.                     
      *                                                                         
           OPEN INPUT FCSBE02-FILE.                                     
           IF FBE02-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**        PCSCA140 PROCESSING ERROR         **' 
               DISPLAY '**  OPEN ERROR OF FCSBE02 - PARAMETER FILE  **' 
               DISPLAY '**    FILE STATUS = ' WS-FBE02-STATUS           
               DISPLAY '**          PROCESSING TERMINATED           **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                 THRU 6240-EXIT         
               MOVE WS-FCA00-COMMON-DATE                                
                                       TO WS-INPUT-DATE                 
           END-IF.                                                      
      *                                                                         
           PERFORM 6241-GET-FCA00-BILL-CYCLES    THRU 6241-EXIT.        
      *                                                                         
           MOVE WS-INPUT-DATE          TO WS-CUR-DATE-BREAKDOWN.        
           MOVE WS-CUR-CC              TO WS-CURRENT-CC.                
           MOVE WS-CUR-YY              TO WS-YMD-YY                     
                                          WS-CURRENT-YY                 
                                          WS-DATE-YY.                   
           MOVE WS-CUR-MM              TO WS-YMD-MM                     
                                          WS-CURRENT-MM                 
                                          WS-DATE-MM.                   
           MOVE WS-CUR-DD              TO WS-YMD-DD                     
                                          WS-CURRENT-DD                 
                                          WS-DATE-DD.                   
           COMPUTE WS-CURRENT-JULIAN-DATE =                             
T19529         ((WS-CUR-CCYY * 365) + (WS-CUR-CCYY * .25)               
               + (WS-DAYS (WS-YMD-MM) + WS-YMD-DD)).                    
T19529     DIVIDE WS-CUR-CCYY BY 4 GIVING TALLY                         
A03354         REMAINDER WS-REMAINDER OF WS-COMPUTE-AR-DAYS.            
A03354     IF WS-REMAINDER OF WS-COMPUTE-AR-DAYS = 0                    
               IF WS-YMD-MM LESS THAN 3                                 
                   IF WS-YMD-DD LESS THAN 60                            
                       SUBTRACT 1 FROM WS-CURRENT-JULIAN-DATE           
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           MOVE WS-CUR-DATE-BREAKDOWN  TO WS-PROGRAM-DATE.              
TP7843     PERFORM 7110-DATE-XX-DAYS-AGO         THRU 7110-EXIT.        
      *                                                                         
TP2079     MOVE ZEROES                 TO WS-FCSRP20-REC-CNTR           
T28615                                    WS-FCSRP806-REC-CNTR          
TP2079                                    WS-FCSRP20-CO-REC-CTR         
T28615                                    WS-FCSRP806-CO-REC-CTR.       
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0500-PROCESS-BEGIN-REC                                   **          
      **       CHECKS FOR BEGINNING RECORD OF FCSBE02-FILE          **          
      **                                                            **          
      ****************************************************************          
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7000-READ-FCSBE02             THRU 7000-EXIT.        
           IF END-OF-FCSBE02-FILE                                       
               DISPLAY '**       PCSCA140 PROCESSING ERROR        **'   
               DISPLAY '**      FCSBE02 FILE IS NON-EXISTENT      **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           IF E-FBE02-KEY-BREC EQUAL LOW-VALUES                         
T13255         IF WS-INPUT-DATE EQUAL E-FBE02-CREATE-DATE-BREC          
                   CONTINUE                                             
T13255         ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**      FCSBE00 PROCESSING ERROR      **'   
                   DISPLAY '**  FILE CREATE DATE IS NOT EQUAL TO  **'   
                   DISPLAY '**       THE PROGRAM COMMON DATE      **'   
                   DISPLAY '**  ********************************  **'   
                   DISPLAY '**  FILE CREATE DATE IS: '                  
                                                E-FBE02-CREATE-DATE-BREC
                   DISPLAY '**  PROGRAM COMMON DATE IS: ' WS-INPUT-DATE 
                   DISPLAY '**        PROCESSING TERMINATED       **'   
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND                    THRU 9900-EXIT 
T13255         END-IF                                                   
           ELSE                                                         
               DISPLAY '**       PCSCA140 PROCESSING ERROR        **'   
               DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'   
               DISPLAY '**         PROCESSING TERMINATED          **'   
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C28615 0700-GET-DELQ.                                                   
C28615                                                                  
C28615     MOVE '01' TO C8-COMPANY-NO.                                  
C28615     MOVE 'PCSCA140' TO C8-DELINQ-CD.                             
C28615     PERFORM 7400-SELECT-DELINQUENCY THRU 7400-EXIT.              
C28615     MOVE  WS-HOLD-DEL-VALUE TO WS-DOLLAR-LIMIT.                  
C30249     MOVE 'DATABASE'         TO C8-DELINQ-CD.                     
C30249     PERFORM 7400-SELECT-DELINQUENCY THRU 7400-EXIT.              
C30249     MOVE  WS-HOLD-DEL-VALUE TO WS-DATABASE.                      
C28615                                                                  
C28615 0700-EXIT.                                                       
C28615     EXIT.                                                        
                                                                        
      ****************************************************************          
      **  CPD00052 MAIN MODULE:                                     **          
      **    609-INITIALIZE-FBE00-WS-AREA                            **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       COPY CPD00052.                                                           
      *                                                                         
      ****************************************************************          
      **  CPD00050 MAIN MODULE:                                     **          
      **    800-LOAD-FBE02-WS-AREA                                  **          
      **                                                            **          
      **  MODULES 810-830 LOADS THE INDIVIDUAL WS AREAS             **          
      ****************************************************************          
      *                                                                         
       COPY CPD00050.                                                           
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1000-MAIN-PROCESS                                        **          
      **       CONTROLS MAIN PROCESSING OF THE PROGRAM              **          
      **                                                            **          
      ****************************************************************          
       1000-MAIN-PROCESS.                                               
      *                                                                         
           PERFORM 0609-INITIALIZE-FBE00-WS-AREA THRU 0609-EXIT.        
           PERFORM 1050-LOAD-AN-ACCT-INTO-WS     THRU 1050-EXIT         
                  UNTIL ACCOUNT-IS-NEW OR END-OF-FCSBE02-FILE.          
           MOVE WS-N                   TO WS-IS-NEW-ACCOUNT.            
                                                                        
           PERFORM 1100-PROCESS-ACCOUNT-AT       THRU 1100-EXIT.        
           PERFORM 1150-PROCESS-FRP149-DATA      THRU 1150-EXIT.        
      *                                                                         
           IF WS-PREV-LOCAL-OFFICE NOT EQUAL E-FBE02-LOCAL-OFFICE       
               MOVE ZERO               TO WS-LINE-COUNTER               
           END-IF.                                                      
                                                                        
           MOVE E-FBE02-ACCOUNT-NO     TO WS-ACCT-NO                    
TP2216                                    WS-ACCOUNT-NO.                
           MOVE E-FBE02-LOCAL-OFFICE   TO WS-PREV-LOCAL-OFFICE.         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1050-LOAD-AN-ACCT-INTO-WS                                **          
      **       LOADS ACCOUNT DATA INTO WORKING STORAGE              **          
      **                                                            **          
      ****************************************************************          
       1050-LOAD-AN-ACCT-INTO-WS.                                       
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
TP1670         IF E-FBE02-KEY-EREC EQUAL HIGH-VALUES                    
TP1670             CONTINUE                                             
TP1670         ELSE                                                     
                   DISPLAY '**       PCSCA140 PROCESSING ERROR       **'
                   DISPLAY '**  LAST RECORD IS NOT A CONTROL RECORD  **'
                   DISPLAY '**         PROCESSING TERMINATED         **'
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
               END-IF                                                   
           ELSE                                                         
               IF E-FBE02-KEY-EREC EQUAL HIGH-VALUES                    
                 MOVE WS-Y           TO WS-END-REC-PROCESSED            
                 MOVE E-FBE02-RECORD-COUNT-EREC TO WS-FBE02-END-REC-CNT 
               ELSE                                                     
                   IF E-FBE02-LOCAL-OFFICE EQUAL WS-PREV-LOCAL-OFFICE   
                    AND E-FBE02-ACCOUNT-NO EQUAL WS-ACCT-NO             
                       PERFORM 0800-LOAD-FBE02-WS-AREA                  
                                                 THRU 0800-EXIT         
                   ELSE                                                 
                       MOVE WS-Y       TO WS-IS-NEW-ACCOUNT             
                       GO              TO 1050-EXIT                     
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FCSBE02             THRU 7000-EXIT.        
      *                                                                         
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PROCESS-ACCOUNT-AT                                  **          
      **    INITIALIZES WS FIELDS & PERFORMS PROCESS OF RECEIVABLES **          
      **                                                            **          
      ****************************************************************          
       1100-PROCESS-ACCOUNT-AT.                                         
      *                                                                         
           IF WS-TOTAL-AR-BALANCE-AT EQUAL ZERO                         
               GO                      TO 1100-EXIT                     
           END-IF.                                                      
      *                                                                         
           INITIALIZE FIORP20.                                          
           INITIALIZE E-FRP149.                                         
           INITIALIZE WS-ACCUMULATORS.                                  
           MOVE SPACES TO WS-SAVE-CNT-TYPE.                             
C28615     MOVE ZEROS TO WS-DEPOSIT-AMT, WS-SECURITIES-AMT,             
A03354                   WS-EXPOSURE-AMT WS-DEPOSIT-ON-HAND-AMT         
A03354                   GU-AMOUNT-GUARANTEED                           
      *                                                                         
           MOVE SPACES                 TO WS-BRC-FUNC-ID-HOLD.          
           PERFORM 1200-PROCESS-RECEIVABLES      THRU 1200-EXIT         
               VARYING WS-SUB FROM 1 BY 1                               
P00097             UNTIL WS-SUB GREATER THAN WS-AC-MAX-ENTRY OR         
                         WS-ACCOUNT-NO-AC (WS-SUB) EQUAL ZERO.          
      *                                                                         
           PERFORM 1300-CHECK-TOTALS             THRU 1300-EXIT.        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1150-PROCESS-FRP149-DATA                                  **          
      **      MAIN PROCESSING FOR FCSRP149-FILE                     **          
      **                                                            **          
      ****************************************************************          
       1150-PROCESS-FRP149-DATA.                                        
      *                                                                         
           INITIALIZE E-FRP149.                                         
      *                                                                         
TP3467*    IF E-FBE02-COMPANY-NO NOT EQUAL WS-PREV-FRP149-COMPANY-NO            
TP3467     IF WS-COMPANY-NO-AT NOT EQUAL WS-PREV-FRP149-COMPANY-NO      
               PERFORM 4301-WRITE-FRP149-COMP-END-REC THRU 4301-EXIT    
               PERFORM 8930-WRITE-FCSRP149            THRU 8930-EXIT    
               SUBTRACT 1 FROM WS-FCSRP149-REC-CNTR                     
               MOVE ZEROES             TO WS-FCSRP149-CO-REC-CTR        
               MOVE E-FBE02-COMPANY-NO TO WS-PREV-FRP149-COMPANY-NO     
           END-IF.                                                      
      *                                                                         
           PERFORM VARYING WS-AR-DATA-INDX FROM 1 BY 1                  
P00097         UNTIL WS-AR-DATA-INDX > WS-AC-MAX-ENTRY                  
TP3467*          OR (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 50             
TP3467*                   AND  WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 01)            
                 OR  WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 0      
               IF (WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) = 50       
                        AND  WS-ITEM-ID-AC (WS-AR-DATA-INDX) = 01)      
                   MOVE WS-ANNIVERSARY-DATE-BU                          
                                       TO WS-CUR-DATE-BREAKDOWN         
TP3467*****************************************************************         
TP3467* NEED TO SUBTRACT ONE YEAR DUE TO ANNIVERSARY DATE GETTING     *         
TP3467* UPDATED TO THE NEXT ANNIVERSARY AFTER CURRENT EPP ANNIVERSARY *         
TP3467* CALCULATIONS ARE COMPLETED (SCSCA112).                        *         
TP3467*****************************************************************         
TP3467             SUBTRACT 1 FROM WS-CUR-CCYY                          
TP3467*                                                                         
                   MOVE WS-CUR-CC      TO WS-DT-NUM-1                   
                   MOVE WS-CUR-YY      TO WS-DT-NUM-2                   
                   MOVE WS-CUR-MM      TO WS-DT-NUM-3                   
                   MOVE WS-DATE-NUMER  TO WS-ANNIV-DATE                 
                   MOVE WS-N           TO WS-REV-MONTH-FOUND            
                   PERFORM 1175-GET-REV-MONTH    THRU 1175-EXIT         
                       VARYING WS-BILLING-INDX FROM 1 BY 1              
                           UNTIL WS-BILLING-INDX > 30                   
                               OR REVENUE-MONTH-IS-FOUND                
                   IF REVENUE-MONTH-IS-FOUND                            
T16261                PERFORM 7100-GET-ANNIVERSARY-ROW   THRU 7100-EXIT 
T16261                IF ANNIVERSARY-EXISTS                             
                         SET WS-BILLING-INDX DOWN BY 1                  
                         PERFORM 1185-PREV-HISTORY THRU 1185-EXIT       
                         MOVE WS-FRP149-PREV-HIST                       
                                         TO E-FRP149-PREV-HIST          
                         MOVE ZERO       TO WS-FRP149-PREV-HIST         
                         MOVE WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX)  
                                         TO E-FRP149-CURR-BAL-UNPD      
T26290                   MOVE WS-COMPANY-NO-AT                          
                                         TO E-FRP149-COMPANY-NO         
                         MOVE WS-PREV-LOCAL-OFFICE                      
                                         TO E-FRP149-LOCAL-OFFICE       
                         MOVE WS-ACCT-NO TO E-FRP149-ACCOUNT-NO         
                         IF WS-ACCOUNT-NO-BU =                          
                           WS-ACCOUNT-NO-AC (WS-AR-DATA-INDX)        AND
                           WS-PYMT-PRIORITY-LVL-BU =                    
                           WS-PYMT-PRIORITY-LVL-AC (WS-AR-DATA-INDX) AND
                           WS-BP-ITEM-ID-BU =                           
                           WS-ITEM-ID-AC (WS-AR-DATA-INDX)              
                           MOVE WS-AMT-MO-PYMT-BU                       
                                       TO E-FRP149-PREV-BUD-PMNT        
                           MOVE WS-AMT-MO-PMT-NEW-BAL-FWD-CALC          
                                       TO E-FRP149-NEW-TOT-PMNT-AMT     
                           MOVE WS-AMT-MO-PYMT-NEW-CALC                 
                                       TO E-FRP149-NEW-BASE-PAY         
T17412                     MOVE WS-BILL-CYCLE-AT                        
T17412                                 TO E-FRP149-BILL-CYCLE           
                         END-IF                                         
                         PERFORM 1151-PROCESS-FRP149-NAME               
                                                   THRU 1151-EXIT       
                         MOVE WS-CUST-NAME                              
                                         TO E-FRP149-CUST-NAME          
                         PERFORM 8930-WRITE-FCSRP149                    
                                                   THRU 8930-EXIT       
T16261                END-IF                                            
                   END-IF                                               
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1151-PROCESS-FRP149-NAME                                  **          
      **      FORMATS CUSTOMER NAME BEFORE WRITING TO FILE          **          
      **                                                            **          
      ****************************************************************          
       1151-PROCESS-FRP149-NAME.                                        
      *                                                                         
           IF WS-NAME-FORMAT-CU-CALC EQUAL WS-B                         
               MOVE WS-FULL-NAME-CU-CALC                                
                                       TO WS-CUST-NAME                  
           ELSE                                                         
               MOVE SPACES             TO WS-EMB-INPUT                  
                                          WS-CMP-TABLE                  
                                          WS-CUST-NAME                  
               MOVE WS-FIRST-NAME-CU-CALC                               
                                       TO WS-CUST-FNAME                 
               MOVE WS-MIDDLE-NAME-CU-CALC                              
                                       TO WS-CUST-MID-INIT              
               MOVE WS-LAST-NAME-CU-CALC                                
                                       TO WS-CUST-LNAME                 
               MOVE WS-CUST-NAME-DET   TO WS-EMB-INPUT                  
               MOVE LENGTH OF WS-EMB-INPUT                              
                                       TO WS-EMB-LENG                   
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT       
               MOVE WS-CMP-TABLE       TO WS-CUST-NAME                  
           END-IF.                                                      
      *                                                                         
       1151-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1175-GET-REV-MONTH                                        **          
      **      FIND REVENUE MONTH TO MATCH ANNIVERSARY DATE          **          
      **                                                            **          
      ****************************************************************          
       1175-GET-REV-MONTH.                                              
      *                                                                         
           IF WS-ACCOUNT-NO-BG (WS-BILLING-INDX) EQUAL WS-ACCOUNT-NO-BI 
             AND WS-BILL-NO-BG (WS-BILLING-INDX) EQUAL WS-BILL-NO-BI    
             AND WS-REVENUE-MONTH-BG (WS-BILLING-INDX)                  
                                                 EQUAL WS-ANNIV-DATE    
               MOVE WS-Y               TO WS-REV-MONTH-FOUND            
           END-IF.                                                      
      *                                                                         
       1175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1185-PREV-HISTORY                                         **          
      **      GETS TOTAL OF BILL AMOUNTS FOR PREVIOUS 12 MONTHS     **          
      **                                                            **          
      ****************************************************************          
       1185-PREV-HISTORY.                                               
      *                                                                         
           MOVE 1                      TO WS-REV-MNTH-CNTR.             
           MOVE WS-ANNIV-DATE          TO WS-PREV-BILL-DATE.            
           MOVE WS-ACCOUNT-NO-BG (WS-BILLING-INDX)                      
                                       TO WS-HOLD-ACCT-NO.              
           PERFORM 7200-OPEN-BI-BG-CRSR          THRU 7200-EXIT.        
      *                                                                         
           PERFORM UNTIL WS-REV-MNTH-CNTR > 12                          
               PERFORM 7250-FETCH-BI-BG-CRSR     THRU 7250-EXIT         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   ADD BG-AMT-BILL-ITEM                                 
                                       TO WS-FRP149-PREV-HIST           
               ELSE                                                     
                   SUBTRACT 1 FROM WS-DT-NUM-3                          
                   IF WS-DT-NUM-3 EQUAL ZERO                            
                       MOVE 12     TO WS-DT-NUM-3                       
                       SUBTRACT 1 FROM WS-DT-NUM-2                      
                       IF WS-DT-NUM-2 EQUAL ZERO                        
                           SUBTRACT 1 FROM WS-DT-NUM-1                  
                       END-IF                                           
                   END-IF                                               
                   MOVE WS-DATE-NUMER  TO WS-PREV-BILL-DATE             
                   ADD 1               TO WS-REV-MNTH-CNTR              
               END-IF                                                   
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7300-CLOSE-BI-BG-CRSR         THRU 7300-EXIT.        
      *                                                                         
       1185-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1200-PROCESS-RECEIVABLES                                  **          
      **      PERFORM PROCESSING OF RECEIVABLE DATA                 **          
      **                                                            **          
      ****************************************************************          
       1200-PROCESS-RECEIVABLES.                                        
      *                                                                         
           MOVE WS-PYMT-PRIORITY-LVL-AC (WS-SUB)                        
ACT362                                 TO WS-PYMT-PRTY-LVL.             
                                                                        
T27853*    IF WS-UTL-PYMT-PRTY                                                  
T27853     IF WS-UTL-PYMT-PRTY-140                                      
               IF WS-AMT-TRAN-BALANCE-AC (WS-SUB) LESS THAN ZERO        
                   MOVE WS-AMT-TRAN-BALANCE-AC (WS-SUB)                 
                                       TO WS-AMT-AR-DAY-00-AC (WS-SUB)  
               END-IF                                                   
           END-IF.                                                      
                                                                        
      *                                                                         
C28615     IF WS-PYMT-PRTY-LVL = 100                                    
C28615        MOVE 'N' TO WS-CNT-FINISH-FLAG                            
C28615        PERFORM 2150-GET-CNT-TYPE THRU 2150-EXIT                  
C28615           VARYING WS-CNT-IND FROM 1 BY 1                         
P00097          UNTIL WS-CNT-IND > WS-CT-MAX-ENTRY OR WS-CNT-FINISH     
C28615        IF WS-CNT-TYPE NOT = WS-SAVE-CNT-TYPE                     
C28615           IF WS-SAVE-CNT-TYPE NOT = SPACES                       
LEF   * CONTRACTS ARE BEING PROCESSED SEPARATELY                                
C28615              IF WS-90-DAY-CONTRACT > WS-DOLLAR-LIMIT OR          
C28615                 WS-60-DAY-CONTRACT > WS-DOLLAR-LIMIT             
C28615*                INITIALIZE WS-CONTRACT-MONEY                             
C28615                 INITIALIZE WS-FULL-BAL-CNT                       
C28615              END-IF                                              
T28615              PERFORM 2220-PROCESS-RP806-CNT THRU 2220-EXIT       
T28615              INITIALIZE WS-CONTRACT-MONEY                        
C28615           END-IF                                                 
C28615           MOVE WS-CNT-TYPE TO WS-SAVE-CNT-TYPE                   
C28615        END-IF                                                    
C28615        ADD WS-AMT-TRAN-BALANCE-AC (WS-SUB) TO WS-FULL-BAL-CNT    
C28615     END-IF.                                                      
                                                                        
           PERFORM 1210-DETERMINE-AGING          THRU 1210-EXIT.        
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1210-DETERMINE-AGING                                      **          
      **                                                            **          
      ****************************************************************          
       1210-DETERMINE-AGING.                                            
      *                                                                         
C28615*    IF WS-PJS-PYMT-PRTY                                                  
C28615*        GO                      TO 1210-EXIT.                            
      *                                                                         
           IF WS-AMT-AR-DAY-90-AC (WS-SUB) NOT EQUAL ZERO               
               PERFORM 1211-PROCESS-90-DAY-MONEY THRU 1211-EXIT         
           END-IF.                                                      
           IF WS-AMT-AR-DAY-60-AC (WS-SUB) NOT EQUAL ZERO               
               PERFORM 1212-PROCESS-60-DAY-MONEY THRU 1212-EXIT         
           END-IF.                                                      
           IF WS-AMT-AR-DAY-30-AC (WS-SUB) NOT EQUAL ZERO               
               PERFORM 1213-PROCESS-30-DAY-MONEY THRU 1213-EXIT         
           END-IF.                                                      
           IF WS-AMT-AR-DAY-00-AC (WS-SUB) NOT EQUAL ZERO               
               PERFORM 1214-PROCESS-00-DAY-MONEY THRU 1214-EXIT         
           END-IF.                                                      
C28615*    IF WS-AMT-TRAN-BALANCE-AC(WS-SUB) NOT EQUAL ZERO                     
C28615*       PERFORM 1215-PROCESS-TRAN-BAL THRU 1215-EXIT                      
C28615*    END-IF.                                                              
C28615* CODE ADDED BY SS82048 TO CALCULATE ACCOUNT FULL BALANCE                 
C28615     IF  WS-AMT-TRAN-BALANCE-AC(WS-SUB) NOT EQUAL ZERO            
C28615     AND WS-PYMT-PRIORITY-LVL-AC (WS-SUB) >= 50                   
C28615         ADD WS-AMT-TRAN-BALANCE-AC(WS-SUB) TO WS-ACCT-FULL-BAL   
C28615     ELSE                                                         
C28615         ADD WS-AMT-AR-DAY-90-AC (WS-SUB)                         
C28615            ,WS-AMT-AR-DAY-60-AC (WS-SUB)                         
C28615            ,WS-AMT-AR-DAY-30-AC (WS-SUB)                         
C28615            ,WS-AMT-AR-DAY-00-AC (WS-SUB)                         
C28615            ,WS-AMT-UNUSED-CR-AC (WS-SUB)   TO WS-ACCT-FULL-BAL   
C28615     END-IF.                                                      
      *                                                                         
RS         IF WS-BUD-PYMT-PRTY                                          
RS             MOVE WS-60-DAY-DET      TO WS-60-DAY-BUD-TOT             
RS             MOVE WS-30-DAY-DET      TO WS-30-DAY-BUD-TOT             
RS         END-IF.                                                      
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1211-PROCESS-90-DAY-MONEY                                 **          
      **                                                            **          
      ****************************************************************          
       1211-PROCESS-90-DAY-MONEY.                                       
      *                                                                         
           IF WS-DATE-BILL-DAY-90-AT LESS THAN WS-85-DAYS-AGO-DATE      
               ADD WS-AMT-AR-DAY-90-AC (WS-SUB)                         
                                       TO WS-90-DAY-DET, WS-90-DAY-TOT  
           ELSE                                                         
              IF WS-DATE-BILL-DAY-90-AT LESS THAN WS-55-DAYS-AGO-DATE   
                 ADD WS-AMT-AR-DAY-90-AC (WS-SUB)                       
                                       TO WS-60-DAY-DET, WS-60-DAY-TOT  
            ELSE                                                        
              IF WS-DATE-BILL-DAY-90-AT LESS THAN WS-25-DAYS-AGO-DATE   
                 ADD WS-AMT-AR-DAY-90-AC (WS-SUB)                       
                                       TO WS-30-DAY-DET, WS-30-DAY-TOT  
              ELSE                                                      
                 ADD WS-AMT-AR-DAY-90-AC (WS-SUB)                       
                                       TO WS-00-DAY-DET, WS-00-DAY-TOT  
               END-IF                                                   
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1211-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1212-PROCESS-60-DAY-MONEY                                 **          
      **                                                            **          
      ****************************************************************          
       1212-PROCESS-60-DAY-MONEY.                                       
      *                                                                         
           IF WS-DATE-BILL-DAY-60-AT LESS THAN WS-55-DAYS-AGO-DATE      
               ADD WS-AMT-AR-DAY-60-AC (WS-SUB)                         
                                       TO WS-60-DAY-DET, WS-60-DAY-TOT  
           ELSE                                                         
             IF WS-DATE-BILL-DAY-60-AT LESS THAN WS-25-DAYS-AGO-DATE    
                ADD WS-AMT-AR-DAY-60-AC (WS-SUB)                        
                                       TO WS-30-DAY-DET, WS-30-DAY-TOT  
             ELSE                                                       
                ADD WS-AMT-AR-DAY-60-AC (WS-SUB)                        
                                       TO WS-00-DAY-DET, WS-00-DAY-TOT  
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       1212-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1213-PROCESS-30-DAY-MONEY                                 **          
      **                                                            **          
      ****************************************************************          
       1213-PROCESS-30-DAY-MONEY.                                       
      *                                                                         
           IF WS-DATE-BILL-DAY-30-AT LESS THAN WS-25-DAYS-AGO-DATE      
               ADD WS-AMT-AR-DAY-30-AC (WS-SUB)                         
                                       TO WS-30-DAY-DET,WS-30-DAY-TOT   
           ELSE                                                         
               ADD WS-AMT-AR-DAY-30-AC (WS-SUB)                         
                                       TO WS-00-DAY-DET, WS-00-DAY-TOT  
      *                                                                         
ACT362     END-IF.                                                      
       1213-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  1214-PROCESS-00-DAY-MONEY                                 **          
      **                                                            **          
      ****************************************************************          
       1214-PROCESS-00-DAY-MONEY.                                       
      *                                                                         
           ADD WS-AMT-AR-DAY-00-AC (WS-SUB)                             
                                       TO WS-00-DAY-DET, WS-00-DAY-TOT. 
      *                                                                         
       1214-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ****************************************************************          
      **                                                            **          
      **  1300-CHECK-TOTALS                                         **          
      **                                                            **          
      ****************************************************************          
       1300-CHECK-TOTALS.                                               
      *                                                                         
           ADD WS-30-DAY-TOT                                            
               WS-60-DAY-TOT                                            
               WS-90-DAY-TOT                                            
                   GIVING WS-ARREARS-TOT.                               
           EVALUATE TRUE                                                
              WHEN WS-CODE-MAJOR-ACCT-AT EQUAL WS-Y AND                 
                  (WS-30-DAY-TOT       GREATER ZERO OR                  
                   WS-60-DAY-TOT       GREATER ZERO OR                  
                   WS-90-DAY-TOT       GREATER ZERO)                    
                   MOVE WS-MAJ              TO WS-QUALIFIES             
              WHEN WS-STREET-NAME-DY (WS-FMTD-INDX)                     
                                         EQUAL 'MDSE ONLY'              
                   MOVE WS-NO               TO WS-QUALIFIES             
              WHEN WS-CODE-ACCT-STAT-AT                                 
                                     NOT EQUAL WS-A                     
                   MOVE WS-NO               TO WS-QUALIFIES             
              WHEN WS-90-DAY-TOT  GREATER THAN ZERO                     
                   MOVE WS-YES              TO WS-QUALIFIES             
              WHEN WS-60-DAY-TOT  GREATER THAN ZERO AND                 
                  (WS-ARREARS-TOT GREATER THAN 199.99 OR                
                   WS-CODE-EMPL-ACCT-CU  EQUAL WS-B)                    
                   MOVE WS-YES              TO WS-QUALIFIES             
              WHEN OTHER                                                
                   MOVE WS-NO               TO WS-QUALIFIES             
           END-EVALUATE.                                                
      *                                                                         
           IF ACCOUNT-QUALIFIES OR                                      
              MAJOR-ACCOUNT-QUALIFIES                                   
               PERFORM 2000-SETUP-PRINT          THRU 2000-EXIT         
           END-IF.                                                      
      *                                                                         
T28615*    IF  WS-ARREARS-TOT > ZERO                                            
T28615     IF  WS-CODE-ACCT-STAT-AT = 'A'                               
T28615         IF WS-COMPANY-NO-AT NOT EQUAL WS-PREV-COMPANY-NO         
T28615         AND NOT END-OF-FCSBE02-FILE                              
T28615             PERFORM 8920-WRITE-FCSRP806   THRU 8920-EXIT         
T28615             SUBTRACT 1 FROM WS-FCSRP806-REC-CNTR                 
T28615         END-IF                                                   
T28615         PERFORM 2200-FORMAT-MONTHLY-FILE THRU 2200-EXIT          
T28615     END-IF.                                                      
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2000-SETUP-PRINT                                         **          
      **       CONTROLS FORMATTING OF DATA FOR DETAIL LINES         **          
      **                                                            **          
      ****************************************************************          
       2000-SETUP-PRINT.                                                
      *                                                                         
           PERFORM 3500-CONTROL-INFO             THRU 3500-EXIT.        
      *                                                                         
TP2079     IF E-FBE02-COMPANY-NO NOT EQUAL WS-PREV-COMPANY-NO           
T9841        AND NOT END-OF-FCSBE02-FILE                                
T25613         MOVE FIORP20                      TO WS-TEMP-FIORP20     
TP2079         PERFORM 4300-WRITE-COMPANY-END-REC                       
                                                 THRU 4300-EXIT         
T25175         PERFORM 8900-WRITE-FCSRP20        THRU 8900-EXIT         
TP2079         SUBTRACT 1 FROM WS-FCSRP20-REC-CNTR                      
T25613         MOVE  WS-TEMP-FIORP20             TO FIORP20             
TP2079     END-IF.                                                      
      *                                                                         
T25613* WE ARE WRITING A RECORD INTO THE OUTPUT FILE AND                        
T25613* THE FILE COUNTERS ARE GETTING INITIALIZED SO MOVED                      
T25613* THIS CODE BELOW - TO WRITE AFTER INITIALIZINGMOVED                      
T25613*    IF MAJOR-ACCOUNT-QUALIFIES                                           
T25613*        PERFORM 8900-WRITE-FCSRP20        THRU 8900-EXIT                 
T25613*    END-IF.                                                              
      *                                                                         
      *                                                                         
TP2079     IF E-FBE02-COMPANY-NO NOT EQUAL WS-PREV-COMPANY-NO           
T9841        AND NOT END-OF-FCSBE02-FILE                                
TP2079         MOVE E-FBE02-COMPANY-NO TO WS-PREV-COMPANY-NO            
ACT362         MOVE ZEROES             TO WS-FCSRP20-CO-REC-CTR
           END-IF.        
      *                                                                         
           IF MAJOR-ACCOUNT-QUALIFIES                                   
               PERFORM 8900-WRITE-FCSRP20        THRU 8900-EXIT         
           END-IF.                                                      
      *                                                                         
      *                                                                         
T25176***-----//  T25176 STARTS == MOVED ABOVE                                  
T25176**   IF E-FBE02-COMPANY-NO NOT EQUAL WS-PREV-COMPANY-NO                   
T25176**     AND NOT END-OF-FCSBE02-FILE                                        
T25176**       MOVE E-FBE02-COMPANY-NO TO WS-PREV-COMPANY-NO                    
T25176**       MOVE ZEROES             TO WS-FCSRP20-CO-REC-CTR                 
T25176**                                  WS-FCSRP141-CO-REC-CTR.               
T25176***-----//  T25176 ENDS   == MOVED ABOVE                                  
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C28615                                                                  
C28615 2150-GET-CNT-TYPE.                                               
C28615                                                                  
C28615     IF WS-ACCOUNT-NO-CT(WS-CNT-IND) = ZEROS                      
C28615        MOVE 'Y' TO WS-CNT-FINISH-FLAG                            
C28615     ELSE                                                         
C28615       IF WS-ACCOUNT-NO-AC(WS-SUB) =                              
C28615                           WS-ACCOUNT-NO-CT(WS-CNT-IND)           
C28615          AND WS-PYMT-PRIORITY-LVL-AC(WS-SUB) =                   
C28615                           WS-PYMT-PRIORITY-LVL-CT(WS-CNT-IND)    
C28615          AND WS-ITEM-ID-AC(WS-SUB) =                             
C28615                           WS-CNT-ITEM-ID-CT(WS-CNT-IND)          
C28615          MOVE WS-CODE-CONTRACT-TYPE-CT(WS-CNT-IND)               
C28615                           TO WS-CNT-TYPE                         
C28615          MOVE 'Y' TO WS-CNT-FINISH-FLAG                          
C28615       END-IF                                                     
C28615     END-IF.                                                      
C28615                                                                  
C28615 2150-EXIT.                                                       
C28615     EXIT.                                                        
T28615                                                                  
T28615*                                                                         
T28615****************************************************************          
T28615**                                                            **          
T28615**   2200-FORMAT-MONTHLY-FILE                                 **          
ACT362**       CONTROLS PROCESSING FOR WRITING FCSRP806-FILE        **          
T28615**                                                            **          
T28615****************************************************************          
T28615 2200-FORMAT-MONTHLY-FILE.                                        
T28615*                                                                         
T28615     MOVE SPACES                 TO FIORP806.                     
T28615     MOVE WS-ACCT-NO             TO E-FRP806-ACCOUNT-NO           
T28615                                    LR-ACCOUNT-NO                 
T28615     MOVE SPACES                 TO LR-REG-GROUP-CD               
T28615     PERFORM 7640-GET-REG-PROFILE-INFO THRU 7640-EXIT             
T28615     MOVE WS-BILL-CYCLE-AT       TO E-FRP806-BILL-CYCLE           
T28615*CHECK IF ITS A CANCEL REBILL                                             
T28615     MOVE 'N'                    TO WS-REBILL-FOUND               
T28615                                                                  
T28615     PERFORM 2210-GET-REBILL THRU 2210-EXIT                       
T28615         VARYING WS-BILLING-INDX FROM 1 BY 1                      
T28615             UNTIL WS-BILLING-INDX > 30                           
T28615                 OR REBILL-IS-FOUND                               
T28615     IF  WS-90-DAY-UTL NOT EQUAL ZEROS OR                         
T28615         WS-60-DAY-UTL NOT EQUAL ZEROS OR                         
T28615         WS-30-DAY-UTL NOT EQUAL ZEROS OR                         
T28615         WS-00-DAY-UTL NOT EQUAL ZEROS                            
T28615         MOVE SPACES             TO FIORP806                      
T28615         MOVE WS-COMPANY-NO-AT   TO E-FRP806-COMPANY-NO           
T28615         MOVE WS-ACCT-NO         TO E-FRP806-ACCOUNT-NO           
T28615         MOVE WS-BILL-CYCLE-AT   TO E-FRP806-BILL-CYCLE           
T28615         MOVE LR-REG-GROUP-CD    TO E-FRP806-REG-GROUP-CD         
T28615         MOVE WS-REV-MTH-LST-NRML-AT                              
T28615                                 TO E-FRP806-REVENUE-MONTH        
T28615         IF  WS-REBILL-FOUND = 'Y'                                
T28615             MOVE 'Y'            TO E-FRP806-REBILL-IND           
T28615         ELSE                                                     
T28615             MOVE SPACES         TO E-FRP806-REBILL-IND           
T28615         END-IF                                                   
T28615         MOVE 'UTL'              TO E-FRP806-RECV-TYPE            
T28615         MOVE WS-90-DAY-UTL      TO E-FRP806-AR-DAY-90            
T28615         MOVE WS-60-DAY-UTL      TO E-FRP806-AR-DAY-60            
T28615         MOVE WS-30-DAY-UTL      TO E-FRP806-AR-DAY-30            
T28615         MOVE WS-00-DAY-UTL      TO E-FRP806-AR-DAY-00            
T28615         MOVE WS-SECURITIES-AMT  TO E-FRP806-SECURITY-AMT         
T28615         IF  WS-COMPANY-NO-AT = '26'                              
T28615             MOVE WS-LOCAL-OFFICE-AT TO E-FRP806-LOCAL-OFFICE     
T28615         END-IF                                                   
T28615         PERFORM 8920-WRITE-FCSRP806       THRU 8920-EXIT         
T28615     END-IF.                                                      
T28615                                                                  
T28615                                                                  
T28615     IF  WS-90-DAY-NONUTL NOT EQUAL ZEROS OR                      
T28615         WS-60-DAY-NONUTL NOT EQUAL ZEROS OR                      
T28615         WS-30-DAY-NONUTL NOT EQUAL ZEROS OR                      
T28615         WS-00-DAY-NONUTL NOT EQUAL ZEROS                         
T28615         MOVE SPACES             TO FIORP806                      
T28615         MOVE WS-COMPANY-NO-AT   TO E-FRP806-COMPANY-NO           
T28615         MOVE WS-ACCT-NO         TO E-FRP806-ACCOUNT-NO           
T28615         MOVE WS-BILL-CYCLE-AT   TO E-FRP806-BILL-CYCLE           
T28615         MOVE LR-REG-GROUP-CD    TO E-FRP806-REG-GROUP-CD         
T28615         MOVE WS-REV-MTH-LST-NRML-AT                              
T28615                                 TO E-FRP806-REVENUE-MONTH        
T28615         IF  WS-REBILL-FOUND = 'Y'                                
T28615             MOVE 'Y'            TO E-FRP806-REBILL-IND           
T28615         ELSE                                                     
T28615             MOVE SPACES         TO E-FRP806-REBILL-IND           
T28615         END-IF                                                   
T28615         MOVE 'NON'              TO E-FRP806-RECV-TYPE            
T28615         MOVE WS-90-DAY-NONUTL   TO E-FRP806-AR-DAY-90            
T28615         MOVE WS-60-DAY-NONUTL   TO E-FRP806-AR-DAY-60            
T28615         MOVE WS-30-DAY-NONUTL   TO E-FRP806-AR-DAY-30            
T28615         MOVE WS-00-DAY-NONUTL   TO E-FRP806-AR-DAY-00            
T28615         MOVE ZEROS              TO E-FRP806-SECURITY-AMT         
T28615         IF  WS-COMPANY-NO-AT = '26'                              
T28615             MOVE WS-LOCAL-OFFICE-AT TO E-FRP806-LOCAL-OFFICE     
T28615         END-IF                                                   
T28615         PERFORM 8920-WRITE-FCSRP806       THRU 8920-EXIT         
T28615     END-IF.                                                      
T28615                                                                  
T28615     IF  WS-90-DAY-PJS NOT EQUAL ZEROS OR                         
T28615         WS-60-DAY-PJS NOT EQUAL ZEROS OR                         
T28615         WS-30-DAY-PJS NOT EQUAL ZEROS OR                         
T28615         WS-00-DAY-PJS NOT EQUAL ZEROS                            
T28615         MOVE SPACES             TO FIORP806                      
T28615         MOVE WS-COMPANY-NO-AT   TO E-FRP806-COMPANY-NO           
T28615         MOVE WS-ACCT-NO         TO E-FRP806-ACCOUNT-NO           
T28615         MOVE WS-BILL-CYCLE-AT   TO E-FRP806-BILL-CYCLE           
T28615         MOVE LR-REG-GROUP-CD    TO E-FRP806-REG-GROUP-CD         
T28615         MOVE WS-REV-MTH-LST-NRML-AT                              
T28615                                 TO E-FRP806-REVENUE-MONTH        
T28615         IF  WS-REBILL-FOUND = 'Y'                                
T28615             MOVE 'Y'            TO E-FRP806-REBILL-IND           
T28615         ELSE                                                     
T28615             MOVE SPACES         TO E-FRP806-REBILL-IND           
T28615         END-IF                                                   
T28615*        MOVE 'PJS'              TO E-FRP806-RECV-TYPE                    
T28615         MOVE 'OTHR'             TO E-FRP806-RECV-TYPE            
T28615         MOVE WS-90-DAY-PJS      TO E-FRP806-AR-DAY-90            
T28615         MOVE WS-60-DAY-PJS      TO E-FRP806-AR-DAY-60            
T28615         MOVE WS-30-DAY-PJS      TO E-FRP806-AR-DAY-30            
T28615         MOVE WS-00-DAY-PJS      TO E-FRP806-AR-DAY-00            
T28615         MOVE ZEROS              TO E-FRP806-SECURITY-AMT         
T28615         IF  WS-COMPANY-NO-AT   = '26'                            
T28615             MOVE WS-LOCAL-OFFICE-AT TO E-FRP806-LOCAL-OFFICE     
T28615         END-IF                                                   
T28615         PERFORM 8920-WRITE-FCSRP806       THRU 8920-EXIT         
T28615     END-IF.                                                      
T28615                                                                  
T28615     IF  WS-90-DAY-CONTRACT NOT EQUAL ZEROS OR                    
T28615         WS-60-DAY-CONTRACT NOT EQUAL ZEROS OR                    
T28615         WS-30-DAY-CONTRACT NOT EQUAL ZEROS OR                    
T28615         WS-00-DAY-CONTRACT NOT EQUAL ZEROS                       
T28615         MOVE SPACES             TO FIORP806                      
T28615         MOVE WS-COMPANY-NO-AT   TO E-FRP806-COMPANY-NO           
T28615         MOVE WS-ACCT-NO         TO E-FRP806-ACCOUNT-NO           
T28615         MOVE WS-BILL-CYCLE-AT   TO E-FRP806-BILL-CYCLE           
T28615         MOVE LR-REG-GROUP-CD    TO E-FRP806-REG-GROUP-CD         
T28615         MOVE WS-REV-MTH-LST-NRML-AT                              
T28615                                 TO E-FRP806-REVENUE-MONTH        
T28615         IF  WS-REBILL-FOUND = 'Y'                                
T28615             MOVE 'Y'            TO E-FRP806-REBILL-IND           
T28615         ELSE                                                     
T28615             MOVE SPACES         TO E-FRP806-REBILL-IND           
T28615         END-IF                                                   
T28615         PERFORM 2230-GET-RECV-GROUP-TYPE THRU 2230-EXIT          
T28615         MOVE WS-90-DAY-CONTRACT TO E-FRP806-AR-DAY-90            
T28615         MOVE WS-60-DAY-CONTRACT TO E-FRP806-AR-DAY-60            
T28615         MOVE WS-30-DAY-CONTRACT TO E-FRP806-AR-DAY-30            
T28615         MOVE WS-00-DAY-CONTRACT TO E-FRP806-AR-DAY-00            
T28615         MOVE ZEROS              TO E-FRP806-SECURITY-AMT         
T28615         IF  WS-COMPANY-NO-AT   = '26'                            
T28615             MOVE WS-LOCAL-OFFICE-AT TO E-FRP806-LOCAL-OFFICE     
T28615         END-IF                                                   
T28615         PERFORM 8920-WRITE-FCSRP806       THRU 8920-EXIT         
T28615     END-IF.                                                      
T28615                                                                  
      *                                                                         
T28615 2200-EXIT.                                                       
T28615     EXIT.                                                        
T28615                                                                  
T28615****************************************************************          
T28615**                                                            **          
T28615**  2210-GET-REBILL.                                          **          
T28615**      FIND IF THE ACCOUNT WENT THROUGH CANCEL REBILL        **          
T28615**                                                            **          
T28615****************************************************************          
T28615 2210-GET-REBILL.                                                 
T28615*                                                                         
T28615     IF WS-ACCOUNT-NO-BG (WS-BILLING-INDX)  EQUAL WS-ACCOUNT-NO   
T28615     AND WS-REBILL-IND-BG (WS-BILLING-INDX) EQUAL 'Y'             
T28615     AND WS-REVENUE-MONTH-BG (WS-BILLING-INDX)                    
T28615                                   EQUAL WS-REV-MTH-LST-NRML-AT   
T28615         MOVE WS-Y               TO WS-REBILL-FOUND               
T28615     END-IF.                                                      
T28615*                                                                         
T28615 2210-EXIT.                                                       
T28615     EXIT.                                                        
T28615*                                                                         
T28615                                                                  
T28615 2220-PROCESS-RP806-CNT.                                          
T28615*                                                                         
T28615     IF  WS-90-DAY-CONTRACT NOT EQUAL ZEROS OR                    
T28615         WS-60-DAY-CONTRACT NOT EQUAL ZEROS OR                    
T28615         WS-30-DAY-CONTRACT NOT EQUAL ZEROS OR                    
T28615         WS-00-DAY-CONTRACT NOT EQUAL ZEROS                       
T28615         MOVE SPACES         TO FIORP806                          
T28615         PERFORM 2230-GET-RECV-GROUP-TYPE THRU 2230-EXIT          
T28615         MOVE SPACES         TO LR-REG-GROUP-CD                   
T28615         PERFORM 7640-GET-REG-PROFILE-INFO THRU 7640-EXIT         
T28615         MOVE WS-COMPANY-NO-AT TO E-FRP806-COMPANY-NO             
T28615         MOVE WS-ACCT-NO     TO E-FRP806-ACCOUNT-NO               
T28615         MOVE WS-BILL-CYCLE-AT TO E-FRP806-BILL-CYCLE             
T28615         MOVE LR-REG-GROUP-CD TO E-FRP806-REG-GROUP-CD            
T28615         MOVE WS-REV-MTH-LST-NRML-AT                              
T28615                                 TO E-FRP806-REVENUE-MONTH        
T28615*CHECK IF ITS A CANCEL REBILL                                             
T28615         MOVE 'N'            TO WS-REBILL-FOUND                   
T28615                                                                  
T28615         PERFORM 2210-GET-REBILL THRU 2210-EXIT                   
T28615             VARYING WS-BILLING-INDX FROM 1 BY 1                  
T28615                 UNTIL WS-BILLING-INDX > 30                       
T28615                     OR REBILL-IS-FOUND                           
T28615         IF WS-REBILL-FOUND = 'Y'                                 
T28615             MOVE 'Y'        TO E-FRP806-REBILL-IND               
T28615         ELSE                                                     
T28615             MOVE SPACES     TO E-FRP806-REBILL-IND               
T28615         END-IF                                                   
T28615         MOVE WS-90-DAY-CONTRACT TO E-FRP806-AR-DAY-90            
T28615         MOVE WS-60-DAY-CONTRACT TO E-FRP806-AR-DAY-60            
T28615         MOVE WS-30-DAY-CONTRACT TO E-FRP806-AR-DAY-30            
T28615         MOVE WS-00-DAY-CONTRACT TO E-FRP806-AR-DAY-00            
T28615         MOVE ZEROS          TO E-FRP806-SECURITY-AMT             
T28615         IF WS-COMPANY-NO-AT = '26'                               
T28615             MOVE WS-LOCAL-OFFICE-AT TO E-FRP806-LOCAL-OFFICE     
T28615         END-IF                                                   
T28615         PERFORM 8920-WRITE-FCSRP806   THRU 8920-EXIT             
T28615     END-IF.                                                      
T28615*                                                                         
T28615 2220-EXIT.                                                       
T28615     EXIT.                                                        
T28615*                                                                         
T28615 2230-GET-RECV-GROUP-TYPE.                                        
T28615*                                                                         
T28615     EVALUATE WS-SAVE-CNT-TYPE                                    
T28615        WHEN 'C'                                                  
T28615        WHEN 'D'                                                  
T28615        WHEN 'E'                                                  
T28615        WHEN 'G'                                                  
T28615        WHEN 'H'    MOVE 'SVCH' TO E-FRP806-RECV-TYPE             
T28615                                                                  
T28615        WHEN 'F'    MOVE 'SVC'  TO E-FRP806-RECV-TYPE             
T28615                                                                  
T28615        WHEN 'A'    MOVE 'EMP'  TO E-FRP806-RECV-TYPE             
T28615        WHEN 'B'    MOVE 'GMP'  TO E-FRP806-RECV-TYPE             
T28615        WHEN 'J'    MOVE 'EQP'  TO E-FRP806-RECV-TYPE             
T28615                                                                  
T28615        WHEN 'K'                                                  
T28615        WHEN 'L'                                                  
T28615        WHEN 'M'                                                  
T28615        WHEN 'N'    MOVE 'PSNC' TO E-FRP806-RECV-TYPE             
T28615                                                                  
T28615        WHEN OTHER  MOVE 'OTHR' TO E-FRP806-RECV-TYPE             
T28615                                                                  
T28615     END-EVALUATE.                                                
T28615                                                                  
T28615 2230-EXIT.                                                       
T28615     EXIT.                                                        
T28615*                                                                         
T11059******************************************************************        
T11059* 2510-PROCESS-FROM-STRING                                       *        
T11059*                                                                *        
T11059*     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *        
T11059*     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *        
T11059*                                                                *        
T11059******************************************************************        
T11059                                                                  
T11059 2510-PROCESS-FROM-STRING.                                        
T11059                                                                  
T11059     PERFORM                                                      
T11059         VARYING WS-INDEX FROM 21 BY -1                           
T11059           UNTIL WS-INDEX < 1                                     
T11059              OR WS-FROM-X (WS-INDEX) NOT = SPACE                 
T11059     END-PERFORM.                                                 
T11059     ADD 1             TO WS-INDEX.                               
T11059     MOVE WS-DELIMITER TO WS-FROM-X (WS-INDEX).                   
T11059                                                                  
T11059 2510-EXIT.                                                       
T11059     EXIT.                                                        
                                                                        
                                                                        
       3500-CONTROL-INFO.                                               
      *                                                                         
           MOVE WS-COMPANY-NO-AT       TO E-FRP20-COMPANY-NO            
                                          E-FRP149-COMPANY-NO.          
ACT369     MOVE WS-LOCAL-OFFICE-AT     TO E-FRP149-LOCAL-OFFICE.        
           MOVE WS-ACCT-NO             TO E-FRP20-ACCOUNT-NO            
                                          E-FRP149-ACCOUNT-NO.          
           IF  WS-FULL-NAME-CN-CALC = SPACES                            
               MOVE WS-FIRST-NAME-CN-CALC TO WS-FROM                    
               PERFORM 2510-PROCESS-FROM-STRING THRU 2510-EXIT          
               MOVE WS-FROM TO WS-CUST-FIRST-NAME                       
               MOVE WS-LAST-NAME-CN-CALC  TO WS-FROM                    
               PERFORM 2510-PROCESS-FROM-STRING THRU 2510-EXIT          
               MOVE WS-FROM TO WS-CUST-LAST-NAME                        
               IF WS-MIDDLE-NAME-CN-CALC NOT = SPACES                   
                  MOVE WS-MIDDLE-NAME-CN-CALC TO WS-FROM                
                  PERFORM 2510-PROCESS-FROM-STRING THRU 2510-EXIT       
                  MOVE WS-FROM TO WS-CUST-MIDDLE-NAME                   
               ELSE                                                     
                  MOVE WS-DELIMITER TO WS-CUST-MIDDLE-NAME              
               END-IF                                                   
               STRING WS-CUST-FIRST-NAME DELIMITED WS-DELIMITER ' '     
                      DELIMITED BY SIZE                                 
                      WS-CUST-MIDDLE-NAME DELIMITED WS-DELIMITER ' '    
                      DELIMITED BY SIZE                                 
                      WS-CUST-LAST-NAME DELIMITED WS-DELIMITER ' '      
                      DELIMITED BY SIZE INTO E-FRP20-NAME-CONTACT       
           ELSE                                                         
             MOVE WS-FULL-NAME-CN-CALC   TO E-FRP20-NAME-CONTACT        
           END-IF.                                                      
      *                                                                         
           ADD WS-90-DAY-DET                                            
               WS-60-DAY-DET                                            
               WS-30-DAY-DET                                            
               WS-00-DAY-DET                                            
                  GIVING WS-BILLED-DET.                                 
      *                                                                         
           MOVE WS-90-DAY-DET          TO E-FRP20-90-DAY-DETAIL.        
           MOVE WS-60-DAY-DET          TO E-FRP20-60-DAY-DETAIL.        
           MOVE WS-30-DAY-DET          TO E-FRP20-30-DAY-DETAIL.        
           MOVE WS-00-DAY-DET          TO E-FRP20-00-DAY-DETAIL.        
           MOVE WS-BILLED-DET          TO E-FRP20-TOTAL-DETAIL          
      *                                                                         
TP6064     MOVE WS-CODE-ACCT-STAT-AT   TO E-FRP20-ACCT-STATUS.          
      *                                                                         
           IF WS-NAME-FORMAT-CU-CALC EQUAL WS-B                         
               MOVE WS-FULL-NAME-CU-CALC                                
                                       TO WS-CUST-NAME                  
           ELSE                                                         
               MOVE SPACES             TO WS-EMB-INPUT                  
                                          WS-CMP-TABLE                  
                                          WS-CUST-NAME                  
               MOVE WS-FIRST-NAME-CU-CALC                               
                                       TO WS-CUST-FNAME                 
               MOVE WS-MIDDLE-NAME-CU-CALC                              
                                       TO WS-CUST-MID-INIT              
               MOVE WS-LAST-NAME-CU-CALC                                
                                       TO WS-CUST-LNAME                 
               MOVE WS-CUST-NAME-DET   TO WS-EMB-INPUT                  
               MOVE LENGTH OF WS-EMB-INPUT                              
                                       TO WS-EMB-LENG                   
               PERFORM 6010-REDUCE-EMBEDDED-SPACES                      
                                                 THRU 6010-EXIT         
               MOVE WS-CMP-TABLE       TO WS-CUST-NAME                  
           END-IF.                                                      
      *                                                                         
ACT369     MOVE WS-CUST-NAME           TO E-FRP20-CUST-NAME.            
ACT369     MOVE WS-LAST-PYMT-DATE-AT   TO E-FRP20-DATE-LAST-PAY.        
      *                                                                         
           SET WS-FMTD-INDX  UP BY -1.                                  
      *                                                                         
           PERFORM UNTIL WS-ADDRESS-ID-DY (WS-FMTD-INDX) EQUAL          
                         WS-ADDRESS-ID-PR                               
      *                                                                         
              SET WS-FMTD-INDX UP BY -1                                 
      *                                                                         
           END-PERFORM.                                                 
                                                                        
           MOVE SPACES             TO WS-CMP-TABLE.                     
      *                                                                         
           MOVE WS-HOUSE-NO-DY (WS-FMTD-INDX)                           
                                   TO WS-HOUSE-NO.                      
           MOVE WS-ADDR-PREFIX-1-DY (WS-FMTD-INDX)                      
                                   TO WS-PREFIX1.                       
           MOVE WS-ADDR-PREFIX-2-DY (WS-FMTD-INDX)                      
                                   TO WS-PREFIX2.                       
           MOVE WS-STREET-NAME-DY (WS-FMTD-INDX)                        
                                   TO WS-STREET-NAME.                   
           MOVE WS-STREET-SUFFIX-DY (WS-FMTD-INDX)                      
                                   TO WS-SUFFIX.                        
           MOVE WS-STREET-LOCATION-1-DY (WS-FMTD-INDX)                  
                                   TO WS-LOC1.                          
           MOVE WS-ADDR-BREAKDOWN                                       
                                   TO WS-EMB-INPUT.                     
           MOVE LENGTH OF WS-EMB-INPUT                                  
                                   TO WS-EMB-LENG.                      
           PERFORM 6010-REDUCE-EMBEDDED-SPACES         THRU 6010-EXIT.  
      *                                                                         
ACT369     MOVE WS-CMP-TABLE   TO E-FRP20-CUST-ADDR-STRT.               
      *                                                                         
           PERFORM 3900-DETERMINE-CITY-STATE           THRU 3900-EXIT.  
      *                                                                         
           MOVE WS-CITY-STATE-BREAKDOWN                                 
                                       TO WS-EMB-INPUT.                 
           MOVE LENGTH OF WS-EMB-INPUT                                  
                                       TO WS-EMB-LENG.                  
           PERFORM 6010-REDUCE-EMBEDDED-SPACES         THRU 6010-EXIT.  
      *                                                                         
           MOVE WS-CMP-TABLE           TO E-FRP20-CUST-CTY-STATE.       
                                                                        
      *                                                                         
           IF WS-LAST-PYMT-AMOUNT-AT NUMERIC                            
               MOVE WS-LAST-PYMT-AMOUNT-AT                              
                                       TO E-FRP20-AMT-LAST-PAY          
           ELSE                                                         
               MOVE 0                  TO E-FRP20-AMT-LAST-PAY          
           END-IF.                                                      
      *                                                                         
           MOVE WS-BILL-CYCLE-AT       TO RW-READ-CYCLE.                
      *                                                                         
           MOVE WS-REV-MTH-LST-NRML-AT TO RW-REVENUE-MONTH.             
      *                                                                         
           PERFORM 7550-GET-OPTIMUM-RD-DATE           THRU 7550-EXIT.   
      *                                                                         
T11171     MOVE RW-OPTIMUM-READ-DATE   TO WS-TEMP-DATE                  
                                                                        
           PERFORM 3510-GET-5-BUSINESS-DAYS-AGO                         
              VARYING WS-DAYS-INDX FROM 1 BY 1                          
                UNTIL WS-DAYS-INDX GREATER THAN 5.                      
      *                                                                         
           MOVE WS-TEMP-DATE           TO E-FRP20-DATE-LAST-BILL.       
      *                                                                         
A03354     PERFORM 7450-GET-DEP-ON-HAND THRU 7450-EXIT.                 
                                                                        
C28615     MOVE ZEROS TO WS-BOND-AMT.                                   
C28615     PERFORM VARYING WS-SB-INDEX FROM 1 BY 1                      
C28615             UNTIL WS-SB-INDEX GREATER THAN 10 OR                 
C28615                   WS-ACCOUNT-NO-SB (WS-SB-INDEX) EQUAL ZERO      
C28615             IF WS-CODE-BOND-TYPE-SB(WS-SB-INDEX)                 
C28615                                    = 'A' OR 'B'                  
C28615                ADD WS-AMT-BOND-SB(WS-SB-INDEX) TO WS-BOND-AMT    
C28615             END-IF                                               
C28615     END-PERFORM.                                                 
                                                                        
A03354     PERFORM 3600-GET-GUARANTOR-INFO THRU 3600-EXIT.              
      *                                                                         
C28615     COMPUTE WS-SECURITIES-AMT = WS-BOND-AMT                      
A03354                               + WS-DEPOSIT-ON-HAND-AMT           
A03354                               + WS-GUARANTOR-AMT.                
A03354     MOVE WS-INPUT-DATE      TO WS-DATE-CWS00308                  
A04243                                WS-TEMP-BATCH-DATE.               
A04243     MOVE 'Y'                TO WS-CALLING-BATCH-SW.              
A03354     MOVE 0                  TO WS-PREMISE-NO.                    
A03354     MOVE WS-BILL-CYCLE-AT   TO AT-BILL-CYCLE.                    
A03354     PERFORM 5650-GET-MAX-DEPOSIT THRU                            
A03354             5650-GET-MAX-DEPOSIT-EXIT.                           
      *                                                                         
C28615     MOVE WS-CODES-DATA-PRESENT-AT TO WS-CODES-DATA-PRESENT.      
C28615                                                                  
C28615                                                                  
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 3510-GET-5-BUSINESS-DAYS-AGO.                                  *        
      *                                                                *        
      *     CALLS SQL ROUTINES TO GET THE NEXT BUSINESS DAY            *        
      *                                                                *        
      ******************************************************************        
T11171 3510-GET-5-BUSINESS-DAYS-AGO.                                    
                                                                        
           MOVE WS-N TO WS-DATE-FOUND.                                  
           PERFORM 7094-GET-PREVIOUS-DAY THRU 7094-EXIT.                
           IF WS-DAY EQUAL 6                                            
              OR WS-DAY EQUAL ZEROES                                    
              PERFORM 3510A-GET-PREVIOUS-DATE THRU 3510A-EXIT           
                 UNTIL WS-DATE-FOUND EQUAL WS-Y                         
           ELSE                                                         
              MOVE WS-TEMP-DATE       TO J8-HOLIDAY-DT                  
              PERFORM 7095-SELECT-HOLIDAY THRU 7095-EXIT                
              IF HOLIDAY-EXISTS                                         
                 PERFORM 3510A-GET-PREVIOUS-DATE THRU 3510A-EXIT        
                    UNTIL WS-DATE-FOUND EQUAL WS-Y                      
              ELSE                                                      
                 MOVE WS-Y TO WS-DATE-FOUND                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       3510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14792919
       3510A-GET-PREVIOUS-DATE.                                         
                                                                        
           PERFORM 7094-GET-PREVIOUS-DAY THRU 7094-EXIT.                
           IF WS-DAY EQUAL 6                                            
              OR WS-DAY EQUAL ZEROES                                    
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TEMP-DATE       TO J8-HOLIDAY-DT                  
              PERFORM 7095-SELECT-HOLIDAY THRU 7095-EXIT                
              IF HOLIDAY-EXISTS                                         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE WS-Y TO WS-DATE-FOUND                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
       3510A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
C28615 3550-GET-DNP-DATE.                                               
C28615                                                                  
C28615     IF  WS-ACCOUNT-NO-CL(WS-CRED-IND) = WS-ACCOUNT-NO AND        
C28615        (WS-CODE-NOTICE-TYPE-CL(WS-CRED-IND) = 'D' OR 'G')        
C28615        IF (WS-SAVE-DNP = SPACES) OR                              
C28615           (WS-DATE-CREDIT-ACTION-CL(WS-CRED-IND) < WS-SAVE-DNP)  
C28615           MOVE WS-DATE-CREDIT-ACTION-CL(WS-CRED-IND)             
C28615                            TO WS-SAVE-DNP                        
C28615        END-IF                                                    
C28615     END-IF.                                                      
C28615                                                                  
C28615 3550-EXIT.                                                       
C28615     EXIT.                                                        
C28615                                                                  
C28615 3600-GET-GUARANTOR-INFO.                                         
C28615                                                                  
C28615      MOVE ZEROS TO WS-GUARANTOR-AMT                              
C28615      EXEC SQL                                                    
C28615          SELECT SUM(AMOUNT_GUARANTEED)                           
C28615            INTO :GU-AMOUNT-GUARANTEED :GUARANTOR-IND              
C28615            FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                      
C28615           WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                  
C28615             AND GUAR_STATUS_CD = :BILL-ACTIVE                    
C30249                                                           
C28615      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT SUM(AMOUNT_GUARANTEED)                                   
MFA-TR*           INTO :GU-AMOUNT-GUARANTEED:GUARANTOR-IND                      
MFA-TR*           FROM CSS_GUARANTOR                                            
MFA-TR*          WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                          
MFA-TR*            AND GUAR_STATUS_CD = :BILL-ACTIVE                            
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28615*                                                                         
C28615      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
C28615                                                                  
A03354      EVALUATE WS-ACTIVE-RETURN-CODE                              
A03354         WHEN SUCCESSFUL-CALL                                     
A03354             MOVE GU-AMOUNT-GUARANTEED TO WS-GUARANTOR-AMT        
A03354         WHEN NOT-FOUND                                           
A03354             CONTINUE                                             
A03354         WHEN OTHER                                               
A03354            DISPLAY '******************************************'  
A03354            DISPLAY '** CSS_GUARANTOR                          '  
A03354            DISPLAY '** 3600-GET-GUARANTOR-INFO                  '
A03354            DISPLAY '** SQLCODE    = ' SQLCODE                    
A03354            DISPLAY '** ACCOUNT NO = ' MN-ACCOUNT-NO              
A03354            DISPLAY '******************************************'  
A03354            PERFORM 9900-ABEND                THRU 9900-EXIT      
A03354      END-EVALUATE.                                               
                                                                        
       3600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3650-GET-METER-STATUS.                                           
                                                                        
           EXEC SQL                                                     
               SELECT CODE_METER_STATUS                                 
                 INTO :MN-CODE-METER-STATUS                             
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                        
C30249                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_METER_STATUS                                         
MFA-TR*          INTO :MN-CODE-METER-STATUS                                     
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*        WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811       
               CONTINUE                                                 
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE SPACES TO MN-CODE-METER-STATUS                   
               ELSE                                                     
                  DISPLAY '******************************************'  
                  DISPLAY '** CSS_MTRD_ENVRNMT                       '  
                  DISPLAY '** GET METER STATUS                     '    
                  DISPLAY '** 3650-CHECK-METER-STATUS                '  
                  DISPLAY '**      :  RC = ' SQLCODE                    
                  DISPLAY '** ACCOUNT NO = ' MN-ACCOUNT-NO              
                  DISPLAY '******************************************'  
                  PERFORM 9900-ABEND                THRU 9900-EXIT      
               END-IF                                                   
           END-IF.                                                      
                                                                        
       3650-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3700-SELECT-CREDIT-PROFILE.                                      
                                                                        
           EXEC SQL                                                     
              SELECT CZ.NON_UTL_ARRER_HIST,                             
                     CZ.NON_UTL_CR_HST_EX,                              
                     CZ.NON_UTL_CR_HST,                                 
P00599               CZ.ARREARS_HIST,                                   
P00599               CZ.DISCONNECT_HIST,                                
P00599               CZ.DISC_EXCEPTN_HIST                               
              INTO   :CZ-NON-UTL-ARRER-HIST,                            
                     :CZ-NON-UTL-CR-HST-EX,                             
                     :CZ-NON-UTL-CR-HST,                                
P00599               :CZ-ARREARS-HIST,                                  
P00599               :CZ-DISCONNECT-HIST,                               
P00599               :CZ-DISC-EXCEPTN-HIST                              
              FROM CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                  
              WHERE CZ.ACCOUNT_NO = :WS-ACCOUNT-NO                      
C30249                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CZ.NON_UTL_ARRER_HIST,                                     
MFA-TR*              CZ.NON_UTL_CR_HST_EX,                                      
MFA-TR*              CZ.NON_UTL_CR_HST,                                         
MFA-TR*              CZ.ARREARS_HIST,                                           
MFA-TR*              CZ.DISCONNECT_HIST,                                        
MFA-TR*              CZ.DISC_EXCEPTN_HIST                                       
MFA-TR*       INTO   :CZ-NON-UTL-ARRER-HIST,                                    
MFA-TR*              :CZ-NON-UTL-CR-HST-EX,                                     
MFA-TR*              :CZ-NON-UTL-CR-HST,                                        
MFA-TR*              :CZ-ARREARS-HIST,                                          
MFA-TR*              :CZ-DISCONNECT-HIST,                                       
MFA-TR*              :CZ-DISC-EXCEPTN-HIST                                      
MFA-TR*       FROM CSS_CREDIT_PROFILE CZ                                        
MFA-TR*       WHERE CZ.ACCOUNT_NO = :WS-ACCOUNT-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_CREDIT_PROFILE                     '      
              DISPLAY '** SELECT-CREDIT-PROFILE                '        
              DISPLAY '** 3700 :  RETURN CODE ERROR              '      
              DISPLAY '**      :  RC = ' SQLCODE                        
              DISPLAY '** ACCOUNT NO = ' WS-ACCOUNT-NO                  
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       3700-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **   3900-DETERMINE-CITY-STATE                                **          
      **       CONTROLS FORMATTING OF CITY, STATE, AND ZIP-CODE     **          
      **                                                            **          
      ****************************************************************          
       3900-DETERMINE-CITY-STATE.                                       
      *                                                                         
           MOVE SPACES                 TO WS-CMP-TABLE                  
                                          WS-EMB-INPUT.                 
           MOVE WS-ZIP-CODE-DY (WS-FMTD-INDX)                           
                                       TO WS-ZIP-CODE-FIRST-5.          
           MOVE WS-ZIP-CODE-PLUS-FOUR-DY (WS-FMTD-INDX)                 
                                       TO WS-ZIP-CODE-LAST-4.           
           MOVE WS-ZIP-CODE-FIRST-5    TO WS-ZIP-TABLE-KEY-FIRST-5      
                                          A4-ZIP-CODE.                  
           MOVE WS-ZIP-CODE-TOKEN-DY (WS-FMTD-INDX)                     
                                       TO WS-ZIP-TABLE-KEY-ADD-ON       
                                          A4-ZIP-CODE-TOKEN.            
           PERFORM 7500-SELECT-ZIP-CODE          THRU 7500-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE A4-TOWN            TO WS-CITY                       
               MOVE A4-STATE           TO WS-STATE                      
           ELSE                                                         
                MOVE SPACES            TO WS-CITY                       
                                          WS-STATE                      
           END-IF.                                                      
      *                                                                         
           SET WS-FMTD-INDX UP BY +1.                                   
      *                                                                         
       3900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       4100-WRITE-BEGIN-CONTROLS.                                       
      *                                                                         
           MOVE LOW-VALUES             TO E-FRP20-KEY-BREC              
T28615                                    E-FRP806-KEY-BREC             
                                          E-FRP149-KEY-BREC.            
           MOVE WS-PCB-PART-NO         TO E-FRP20-DB-PART-BREC          
T28615                                    E-FRP806-DB-PART-BREC         
                                          E-FRP149-DB-PART-BREC.        
           MOVE WS-INPUT-DATE          TO E-FRP20-CREATE-DATE-BREC      
T28615                                    E-FRP806-CREATE-DATE-BREC     
                                          E-FRP149-CREATE-DATE-BREC.    
      *                                                                         
           PERFORM 8900-WRITE-FCSRP20            THRU 8900-EXIT.        
T28615     PERFORM 8920-WRITE-FCSRP806           THRU 8920-EXIT.        
           PERFORM 8930-WRITE-FCSRP149           THRU 8930-EXIT.        
           SUBTRACT 1 FROM WS-FCSRP20-REC-CNTR                          
                           WS-FCSRP149-REC-CNTR                         
T28615                     WS-FCSRP806-REC-CNTR                         
TP2079                     WS-FCSRP20-CO-REC-CTR                        
                           WS-FCSRP149-CO-REC-CTR                       
T28615                     WS-FCSRP806-CO-REC-CTR.                      
           MOVE SPACES                 TO FIORP20                       
T28615                                    FIORP806                      
                                          E-FRP149.                     
      *                                                                         
       4100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4200-WRITE-END-CONTROLS                                  **          
      **       FORMATS END-OF-FILE CONTROL RECS FOR OUTPUT FILES    **          
      **                                                            **          
      ****************************************************************          
       4200-WRITE-END-CONTROLS.                                         
      *                                                                         
           MOVE SPACES                 TO FIORP20                       
T28615                                    FIORP806                      
                                          E-FRP149.                     
           MOVE HIGH-VALUES            TO E-FRP20-KEY-EREC              
T28615                                    E-FRP806-KEY-EREC             
                                          E-FRP149-KEY-EREC.            
           MOVE WS-PCB-PART-NO         TO E-FRP20-DB-PART-EREC          
T28615                                    E-FRP806-DB-PART-EREC         
                                          E-FRP149-CREATE-DB-PART-EREC. 
           MOVE WS-FCSRP20-REC-CNTR    TO E-FRP20-RECORD-COUNT-EREC.    
T28615     MOVE WS-FCSRP806-REC-CNTR   TO E-FRP806-RECORD-COUNT-EREC.   
           MOVE WS-FCSRP149-REC-CNTR   TO E-FRP149-RECORD-COUNT-EREC.   
      *                                                                         
           PERFORM 8900-WRITE-FCSRP20            THRU 8900-EXIT.        
T28615     PERFORM 8920-WRITE-FCSRP806           THRU 8920-EXIT.        
           PERFORM 8930-WRITE-FCSRP149           THRU 8930-EXIT.        
           SUBTRACT 1 FROM WS-FCSRP20-REC-CNTR                          
T28615                     WS-FCSRP806-REC-CNTR                         
                           WS-FCSRP149-REC-CNTR.                        
      *                                                                         
      *                                                                         
           IF WS-FBE02-ACT-REC-CNT EQUAL WS-FBE02-END-REC-CNT           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**         PCSCA140 PROCESSING ERROR        **' 
               DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **' 
               DISPLAY '**         CONTROL REC COUNT = '                
                                          WS-FBE02-END-REC-CNT          
               DISPLAY '**         ACTUAL  REC COUNT = '                
                                          WS-FBE02-ACT-REC-CNT          
               DISPLAY '**           PROCESSING TERMINATED          **' 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       4200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   4300-WRITE-COMPANY-END-REC                               **          
ACT369**     FORMATS COMP END RECS FOR FCSRP20                      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
TP2079 4300-WRITE-COMPANY-END-REC.                                      
           MOVE SPACES                 TO FIORP20                       
T28615                                    FIORP806.                     
      *                                                                         
TP2079     MOVE WS-PREV-COMPANY-NO     TO E-FRP20-CO-NO-KEY-EREC        
T28615                                    E-FRP806-CO-NO-KEY-EREC.      
      *                                                                         
TP2079     MOVE HIGH-VALUES            TO E-FRP20-CO-KEY-EREC           
T28615                                    E-FRP806-CO-KEY-EREC.         
      *                                                                         
TP2079     MOVE WS-FCSRP20-CO-REC-CTR  TO E-FRP20-CO-REC-COUNT-EREC.    
T28615     MOVE WS-FCSRP806-CO-REC-CTR TO E-FRP806-CO-REC-COUNT-EREC.   
TP2079     MOVE WS-PCB-PART-NO         TO E-FRP20-DB-PART-CO-EREC       
T28615                                    E-FRP806-CO-DB-PART-EREC.     
      *                                                                         
TP2079 4300-EXIT.                                                       
TP2079     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  4301-WRITE-FRP149-COMP-END-REC                            **          
      **      CREATE THE COMPANY END RECORD FOR FCSRP149-FILE       **          
      **                                                            **          
      ****************************************************************          
       4301-WRITE-FRP149-COMP-END-REC.                                  
      *                                                                         
           MOVE SPACES                 TO E-FRP149.                     
           MOVE WS-PREV-FRP149-COMPANY-NO                               
                                       TO E-FRP149-CO-NO-KEY-EREC.      
           MOVE HIGH-VALUES            TO E-FRP149-CO-KEY-EREC.         
           MOVE WS-FCSRP149-CO-REC-CTR TO E-FRP149-CO-REC-COUNT-EREC.   
           MOVE WS-PCB-PART-NO         TO E-FRP149-CO-DB-PART-EREC.     
      *                                                                         
       4301-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** CPD00004 MODULES:                                          **          
      **  6010-REDUCE-EMBEDDED-SPACES                               **          
      **  6011-COMPRESSION-ROUTINE                                  **          
      ****************************************************************          
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ****************************************************************          
      ** CPD00040 MODULES:                                          **          
      **  6240-GET-FCA00-COMMON-DATE                                **          
      ****************************************************************          
      *                                                                         
       COPY CPD00040.                                                           
      *                                                                         
      ****************************************************************          
      ** CPD00041 MODULES:                                          **          
      **  6241-GET-FCA00-BILL-CYCLES                                **          
      ****************************************************************          
      *                                                                         
       COPY CPD00041.                                                           
      *                                                                         
      ****************************************************************          
      ** CPD00037 MODULES:                                          **          
      **  6251-GET-FJC01-DATE                                       **          
      ****************************************************************          
      *                                                                         
       COPY CPD00037.                                                           
A03354****************************************************************          
A03354**  MAXIMUM DEPOSIT                                           **          
A03354****************************************************************          
A03354*                                                                         
A03354     EXEC SQL                                                             
A03354         INCLUDE CPD00308                                                 
A03354     END-EXEC.                                                            
A03354*                                                                         
A03354****************************************************************          
      **                                                            **          
      **   7000-READ-FCSBE02                                        **          
      **      READS THE INPUT FILE FCSBE02                          **          
      **                                                            **          
      ****************************************************************          
       7000-READ-FCSBE02.                                               
      *                                                                         
           READ FCSBE02-FILE                                            
               AT END                                                   
                     MOVE WS-Y TO WS-END-OF-FCSBE02.                    
      *                                                                         
      *                                                                         
           IF E-FBE02-KEY-BREC EQUAL LOW-VALUES                         
                                   OR HIGH-VALUES                       
                                   OR SPACES                            
                                   OR ZEROES                            
              OR END-OF-FCSBE02-FILE                                    
               CONTINUE                                                 
           ELSE                                                         
               ADD +1                  TO WS-FBE02-ACT-REC-CNT          
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7094-GET-PREVIOUS-DAY.                                    **          
      **                                                            **          
      ****************************************************************          
T11171 7094-GET-PREVIOUS-DAY.                                           
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-TEMP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DATE
              ) <> 0) OR (LEN(:WS-TEMP-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-TEMP-DATE
              ), CONVERT(DATE, :WS-TEMP-DATE) ) ),
              CIS.DAYS (DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-TEMP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DATE
              ) <> 0) OR (LEN(:WS-TEMP-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-TEMP-DATE
              ), CONVERT(DATE, :WS-TEMP-DATE) ) )) -  
T35434             (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-TEMP-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TEMP-DATE
              ) <> 0) OR (LEN(:WS-TEMP-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-TEMP-DATE
              ), CONVERT(DATE, :WS-TEMP-DATE) ) ))/7 * 7)
            INTO
              :WS-TEMP-DATE,
              :WS-DAY  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     15024604
MFA-TR*      SET :WS-TEMP-DATE = DATE(:WS-TEMP-DATE) - 1 DAYS                   
MFA-TR*         ,:WS-DAY       = DAYS (DATE(:WS-TEMP-DATE) - 1 DAYS) -          
MFA-TR*            (INTEGER(DAYS(DATE(:WS-TEMP-DATE) - 1 DAYS)/7) * 7)          
MFA-TR*    END-EXEC.                                                    15024620

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GET NEXT DAY DATE                    '        
              DISPLAY '** 7094 :  RETURN CODE ERROR              '      
              DISPLAY '**      :  RC = ' SQLCODE                        
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7094-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7095-SELECT-HOLIDAY.                                                  
      **                                                            **          
      ****************************************************************          
T11171 7095-SELECT-HOLIDAY.                                             
                                                                        
           MOVE 'N'    TO WS-HOLIDAY-EXISTS.                            
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT ('Y')                                     
                 INTO :WS-HOLIDAY-EXISTS                                
              FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                            
              WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                         
C30249                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15024669
MFA-TR*       SELECT DISTINCT ('Y')                                     15024670
MFA-TR*          INTO :WS-HOLIDAY-EXISTS                                15024671
MFA-TR*       FROM CSS_HOLIDAY                                          15024672
MFA-TR*       WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                         15024673
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    15024674

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** HOLIDAY     TABLE                      '      
              DISPLAY '** HOLIDAY DATE = ' J8-HOLIDAY-DT                
              DISPLAY '** 7095 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' SQLCODE                        
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7095-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15025204
      ****************************************************************          
      **                                                            **          
T16261**  7100-GET-ANNIVERSARY-ROW                                  **          
T16261**                                                            **          
T16261****************************************************************          
T16261 7100-GET-ANNIVERSARY-ROW.                                        
T16261                                                                  
T16261     MOVE 'N'               TO WS-ANNIVERSARY-EXISTS.             
T16261     MOVE WS-ACCT-NO        TO BH-ACCOUNT-NO.                     
T16261                                                                  
T16261     EXEC SQL                                                     
T16261        SELECT DISTINCT ('Y')                                     
T16261           INTO :WS-ANNIVERSARY-EXISTS                            
T16261        FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)                        
T16261        WHERE ACCOUNT_NO = :BH-ACCOUNT-NO                         
T16261          AND CHANGE_REASON = 'A'                                 
C30249                                                           
T16261     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15024669
MFA-TR*       SELECT DISTINCT ('Y')                                     15024670
MFA-TR*          INTO :WS-ANNIVERSARY-EXISTS                            15024671
MFA-TR*       FROM CSS_BUDGET_HIST                                      15024672
MFA-TR*       WHERE ACCOUNT_NO = :BH-ACCOUNT-NO                         15024673
MFA-TR*         AND CHANGE_REASON = 'A'                                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    15024674

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T16261                                                                  
T16261     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T16261     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T16261         NEXT SENTENCE                                            
T16261     ELSE                                                         
T16261        DISPLAY '******************************************'      
T16261        DISPLAY '** BUDGET HIST TABLE                      '      
T16261        DISPLAY '** ACCOUNT NO  = ' BH-ACCOUNT-NO                 
T16261        DISPLAY '** 7100 :  RETURN CODE ERROR - SELECT     '      
T16261        DISPLAY '**      :  RC = ' SQLCODE                        
T16261        DISPLAY '******************************************'      
T16261        PERFORM 9900-ABEND                THRU 9900-EXIT          
T16261     END-IF.                                                      
T16261                                                                  
T16261 7100-EXIT.                                                       
T16261     EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **  7110-DATE-XX-DAYS-AGO                                     **          
      **                                                            **          
      ****************************************************************          
       7110-DATE-XX-DAYS-AGO.                                           
      *                                                                         
           MOVE '7110'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
T35434     EXEC SQL                                                     
T35434       SELECT
              DATEADD( DAY, -85, IIF(TRY_CONVERT(DATE, :WS-PROGRAM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROGRAM-DATE
              ) <> 0) OR (LEN(:WS-PROGRAM-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROGRAM-DATE
              ), CONVERT(DATE, :WS-PROGRAM-DATE) ) ),
              DATEADD( DAY, -55, IIF(TRY_CONVERT(DATE, :WS-PROGRAM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROGRAM-DATE
              ) <> 0) OR (LEN(:WS-PROGRAM-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROGRAM-DATE
              ), CONVERT(DATE, :WS-PROGRAM-DATE) ) ),
              DATEADD( DAY, -25, IIF(TRY_CONVERT(DATE, :WS-PROGRAM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROGRAM-DATE
              ) <> 0) OR (LEN(:WS-PROGRAM-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROGRAM-DATE
              ), CONVERT(DATE, :WS-PROGRAM-DATE) ) )
            INTO
              :WS-85-DAYS-AGO-DATE,
              :WS-55-DAYS-AGO-DATE,
              :WS-25-DAYS-AGO-DATE
T35434     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-85-DAYS-AGO-DATE = DATE(:WS-PROGRAM-DATE) - 85 DAYS        
MFA-TR*         ,:WS-55-DAYS-AGO-DATE = DATE(:WS-PROGRAM-DATE) - 55 DAYS        
MFA-TR*         ,:WS-25-DAYS-AGO-DATE = DATE(:WS-PROGRAM-DATE) - 25 DAYS        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7110-DATE-XX-DAYS-AGO **'    
               DISPLAY '**         RETURN CODE = ' WS-ACTIVE-RETURN-CODE
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7200-OPEN-BI-BG-CRSR                                      **          
      **      OPEN BILLING HEADER-BILLING DETAIL CURSOR             **          
      **                                                            **          
      ****************************************************************          
       7200-OPEN-BI-BG-CRSR.                                            
      *                                                                         
           EXEC SQL                                                     
              OPEN  BI_BG_CRSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7200-OPEN-BI-BG-CRSR **'     
               DISPLAY '**         RETURN CODE = ' WS-ACTIVE-RETURN-CODE
               DISPLAY '**         PROCESSING TERMINATED        **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7250-FETCH-BI-BG-CRSR                                     **          
      **           FETCH BILL AMOUNT FROM CSS_BILLING_DET           **          
      **                                                            **          
      ****************************************************************          
       7250-FETCH-BI-BG-CRSR.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH BI_BG_CRSR                                         
               INTO  :BG-BILL-NO,                                       
                     :BG-AMT-BILL-ITEM                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7250-FETCH-BI-BG-CRSR **'    
               DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '**        ACCOUNT NO = ' WS-HOLD-ACCT-NO        
               DISPLAY '**        PROCESSING TERMINATED          **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7300-CLOSE-BI-BG-CRSR                                     **          
      **      CLOSE THE BILLING HEADER-BILLING DETAIL CURSOR        **          
      **                                                            **          
      ****************************************************************          
       7300-CLOSE-BI-BG-CRSR.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE BI_BG_CRSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7300-CLOSE-BI-BG-CRSR **'    
               DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
               DISPLAY '**        PROCESSING TERMINATED          **'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C28615 7400-SELECT-DELINQUENCY.                                         
C28615                                                                  
C28615     EXEC SQL                                                     
C28615       SELECT DELINQ_VALUE                                        
C28615         INTO :WS-HOLD-DEL-VALUE                                  
C28615         FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
C28615        WHERE DELINQ_CD    = :C8-DELINQ-CD                        
C28615          AND COMPANY_NO   = :C8-COMPANY-NO                       
C30249                                                           
C28615     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*        INTO :WS-HOLD-DEL-VALUE                                          
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD    = :C8-DELINQ-CD                                
MFA-TR*         AND COMPANY_NO   = :C8-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28615                                                                  
C28615     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C28615                                                                  
C28615     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C28615         CONTINUE                                                 
C28615     ELSE                                                         
C28615         DISPLAY '** SELECT ERROR IN 7400-SELECT-DELINQUENCY **'  
C28615         DISPLAY '**         RETURN CODE = ' WS-ACTIVE-RETURN-CODE
C28615         DISPLAY '**         PROCESSING TERMINATED        **'     
C28615         PERFORM 9900-ABEND                THRU 9900-EXIT         
C28615     END-IF.                                                      
C28615                                                                  
C28615 7400-EXIT.                                                       
C28615     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7450-GET-DEP-ON-HAND                                      **          
      **      ACCUMULATE THE AMOUNT OF DEPOSITS, IF ANY             **          
      **                                                            **          
      ****************************************************************          
A03354 7450-GET-DEP-ON-HAND.                                            
A03354     EXEC SQL                                                     
A03354         SELECT SUM(AMT_DEPOSIT)                                  
A03354           INTO :WS-DEPOSIT-ON-HAND-AMT :DEPOSIT-IND               
A03354           FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
A03354          WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                   
A03354                                                           
A03354     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :WS-DEPOSIT-ON-HAND-AMT:DEPOSIT-IND                       
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A03354     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A03354     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A03354         CONTINUE                                                 
A03354     ELSE                                                         
A03354         DISPLAY '** SELECT ERROR IN 7450-GET-DEP-ON-HAND    **'  
A03354         DISPLAY '**        RETURN CODE = ' WS-ACTIVE-RETURN-CODE 
A03354         DISPLAY '**        ACCOUNT NO = ' WS-HOLD-ACCT-NO        
A03354         DISPLAY '**        PROCESSING TERMINATED          **'    
A03354         PERFORM 9900-ABEND                THRU 9900-EXIT         
A03354     END-IF.                                                      
A03354 7450-EXIT.                                                       
A03354     EXIT.                                                        
      ****************************************************************          
      **                                                            **          
      **  7500-SELECT-ZIP-CODE                                      **          
      **                                                            **          
      ****************************************************************          
       7500-SELECT-ZIP-CODE.                                            
      *                                                                         
           MOVE '7500'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT TOWN,                                             
                      STATE                                             
               INTO :A4-TOWN,                                           
                    :A4-STATE                                           
               FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                          
               WHERE ZIP_CODE       = :A4-ZIP-CODE                      
                 AND ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                
C30249                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOWN,                                                     
MFA-TR*               STATE                                                     
MFA-TR*        INTO :A4-TOWN,                                                   
MFA-TR*             :A4-STATE                                                   
MFA-TR*        FROM CSS_ZIP_CODE                                                
MFA-TR*        WHERE ZIP_CODE       = :A4-ZIP-CODE                              
MFA-TR*          AND ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
FSW        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7500-SELECT-ZIP-CODE **'     
               DISPLAY '**         RETURN CODE = ' WS-ACTIVE-RETURN-CODE
               DISPLAY '**         PROCESSING TERMINATED        **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7550-GET-OPTIMUM-RD-DATE                                  **          
      **                                                            **          
      ****************************************************************          
       7550-GET-OPTIMUM-RD-DATE.                                        
      *                                                                         
           MOVE '7550'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT                                                   
                  OPTIMUM_READ_DATE                                     
               INTO                                                     
                  :RW-OPTIMUM-READ-DATE                                 
               FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                       
               WHERE READ_CYCLE     = :RW-READ-CYCLE                    
                 AND REVENUE_MONTH  = :RW-REVENUE-MONTH                 
C30249                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*           OPTIMUM_READ_DATE                                             
MFA-TR*        INTO                                                             
MFA-TR*           :RW-OPTIMUM-READ-DATE                                         
MFA-TR*        FROM CSS_READ_WINDOW                                             
MFA-TR*        WHERE READ_CYCLE     = :RW-READ-CYCLE                            
MFA-TR*          AND REVENUE_MONTH  = :RW-REVENUE-MONTH                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7550-GET-OPTIMUM-RD-DATE **' 
               DISPLAY '**         RETURN CODE = ' WS-ACTIVE-RETURN-CODE
               DISPLAY '**         PROCESSING TERMINATED        **'     
PRDFIX         DISPLAY 'RW READ-CYCLE = ' RW-READ-CYCLE                 
PRDFIX         DISPLAY 'RW REV MON    = ' RW-REVENUE-MONTH              
PRDFIX         DISPLAY 'ACCOUNT NO = '    WS-ACCT-NO                    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** CPD00038 MODULES:                                          **          
      **  7600-START-FCSJC01                                        **          
      **  7610-READ-FCSJC01                                         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** CPD00039 MODULES:                                          **          
      **  7620-START-FCSCA00                                        **          
      **  7621-READ-FCSCA00                                         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
C28615                                                                  
C28615******************************************************************        
C28615*                                                                *        
C28615*   7640-GET-REG-PROFILE-INFO.                                   *        
C28615*        FETCHES LR_REG_GROUP_CD                                 *        
C28615*                                                                *        
C28615******************************************************************        
C28615 7640-GET-REG-PROFILE-INFO.                                       
C28615*                                                                         
C28615     EXEC SQL                                                     
C28615         SELECT REG_GROUP_CD                                      
C28615           INTO :LR-REG-GROUP-CD                                  
C28615           FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
C28615          WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
C30249                                                           
C28615     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28615     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C28615     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C28615        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
C28615            MOVE '   ' TO LR-REG-GROUP-CD                         
C28615        END-IF                                                    
C28615     ELSE                                                         
C28615        DISPLAY '*******************************************'     
C28615        DISPLAY '***  PCSCA140 PROCESSING ERROR          ***'     
C28615        DISPLAY '***  PARA 7640-GET-REG-PROFILE-INFO     ***'     
C28615        DISPLAY '***  RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
C28615        DISPLAY '***  ACCOUNT NO = ' LR-ACCOUNT-NO                
C28615        DISPLAY '***  PROCESSING TERMINATED              ***'     
C28615        DISPLAY '*******************************************'     
C28615        PERFORM 9900-ABEND THRU 9900-EXIT                         
C28615     END-IF.                                                      
C28615     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C28615*                                                                         
C28615 7640-EXIT.                                                       
C28615     EXIT.                                                        
C28615*                                                                         
      *                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-WRITE-FCSRP00                                       **          
      **       WRITES THE DATA TO THE FILE FCSRP00                  **          
      **                                                            **          
      ****************************************************************          
       8900-WRITE-FCSRP20.                                              
      *                                                                         
           WRITE FIORP20.                                               
           IF FRP20-SUCCESSFUL                                          
               ADD 1                   TO WS-FCSRP20-REC-CNTR           
TP2079                                    WS-FCSRP20-CO-REC-CTR         
           ELSE                                                         
               DISPLAY  '8900-ERROR ON FCSRP20 WRITE. STATUS IS '       
                         WS-FRP20-STATUS                                
               PERFORM  9900-ABEND               THRU 9900-EXIT         
           END-IF.                                                      
      *    MOVE SPACES                 TO E-FRP20-DATA.                         
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T28615****************************************************************          
T28615**                                                            **          
T28615**   8920-WRITE-FCSRP806                                      **          
T28615**       WRITES THE DATA TO THE FILE FCSRP806                 **          
T28615**                                                            **          
T28615****************************************************************          
T28615                                                                  
T28615 8920-WRITE-FCSRP806.                                             
T28615*                                                                         
T28615     WRITE FIORP806.                                              
T28615     IF  FRP806-SUCCESSFUL                                        
T28615         ADD 1                   TO WS-FCSRP806-REC-CNTR          
T28615                                    WS-FCSRP806-CO-REC-CTR        
T28615     ELSE                                                         
ACT362         DISPLAY  '8920-ERROR ON FCSRP806 WRITE. STATUS IS '      
T28615                   WS-FRP806-STATUS                               
T28615         PERFORM  9900-ABEND               THRU 9900-EXIT         
T28615     END-IF.                                                      
T28615*                                                                         
T28615 8920-EXIT.                                                       
T28615     EXIT.                                                        
T28615*                                                                         
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  8930-WRITE-FCSRP149                                       **          
      **      WRITES DATA TO FCSRP149-FILE                          **          
      **                                                            **          
      ****************************************************************          
       8930-WRITE-FCSRP149.                                             
      *                                                                         
           WRITE E-FRP149.                                              
           IF FRP149-SUCCESSFUL                                         
               ADD 1                   TO WS-FCSRP149-REC-CNTR          
                                          WS-FCSRP149-CO-REC-CTR        
           ELSE                                                         
               DISPLAY '8930-ERROR ON FCSRP149 WRITE. STATUS IS '       
                        WS-FRP149-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBE02-FILE.                                          
           IF FBE02-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSCA140 PROCESSING ERROR        **'   
               DISPLAY '**  CLOSE ERROR FOR FCSBE02 - INPUT FILE  **'   
               DISPLAY '**       FILE STATUS = ' WS-FBE02-STATUS        
           END-IF.                                                      
      *                                                                         
ACT362     CLOSE FCSRP806-FILE                                          
                 FCSRP149-FILE                                          
                 FCSRP20-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
A03354*                                                                         
       COPY CPD0023B.                                                           
      ****************************************************************  08140000
      **    THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE           **  08150000
      ****************************************************************  08160000
      *                                                                         
           EXEC SQL                                                     08170000
               INCLUDE CPD09900                                         08180001
           END-EXEC.                                                    08190000
      ****************************************************************          
