       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA135.                                         
       AUTHOR.        MC95456.                                          
       DATE-WRITTEN.  MAR 2010.                                         
                                                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      **                  CUSTOMER SERVICE SYSTEM                    **         
      **                         DB2                                 **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       APPL      INITIALS           REASON              **         
      ** ======   =========   =========    ========================= **         
      ** 04/2010  APPL1292    MC95456        NEW PROGRAM             **         
      ** 06/2010  APPL1292    MC95456      CHANGED TEMP PULL CODE    **         
      **                                   FROM 'H' TO 'B'           **         
      ** 06/2010  APPL1292    MC95456      INITIALIZED 'BI' VARIABLES**         
      **                                   TO HANDLE NOT FOUND       **         
      **                                   CONDITION FOR AMT FIELDS  **         
      ** 04/2012  P00599      GV7A828      CHANGED TO PULL CREDIT    **         
      **                                   GROUP FROM CSS_ACCOUNT    **         
      **                                   MODIFIED TO UPDATE TABLE  **         
      **                                   CSS_CORR_MAIL_STAT IF BILL**         
      **                                   CREDIT DETAIL IS NOT      **         
      **                                   PRESENT IN BE00 FILE      **         
ACT171** 09/2015  APPL5136    RS7M249      WS-VAR AND WS-VAR-PER     **         
      **                                   IS ADDED TO OUTPUT FILE   **         
      **                                   FIOCA135.                 **         
ACT206** 10/2015  APPL5136    VIJAY        PULL LIGHT ONLY ACCOUNTS  **         
      **                                   INTO % TEMP PULL CODE WHEN**         
      **                                   ACCOUNT FINALED.          **         
ACT206** 10/30/15 APPL5136    VIJAY        FIX CODE TO AVOID -811    **         
      *****************************************************************         
      *****************************************************************         
      *                      PROGRAM NARRATIVE                        *         
      * THIS PROGRAM PROCESSES THE BE00 FILE TO IDENTIFY HIGH BILLED  *         
      * ACCOUNTS AND UPDATES THE 'AT RECORD' WITH TEMP BILL CODE 'B'  *         
      * AND WRITES AN OUTPUT FILE FOR REPORT                       *            
      *****************************************************************         
             REMARKS.                                                   
      *****************************************************************         
                    ---- BASIC SEQUENCE STRUCTURE ------                
               0000 - 0099     MAIN CONTROL PATH                        
               0100 - 0999     INITIALIZATION                           
               1000 - 1999     INPUT PROCESSING CONTROL PATH            
               2000 - 2999     OUTPUT PROCESSING CONTROL PATH           
               3000 - 4999     BATCH PROCESSING MODULES - NOT USED      
               5000 - 5999     COMMON PROGRAM MODULES                   
               6000 - 6999     COMMON SYSTEM MODULES                    
               7000 - 7999     INPUT MODULES                            
               8000 - 8999     OUTPUT MODULES                           
               9000 - 9799     TERMINATION MODULES                      
               9900 - 9999     ABEND/ABORT MODULES                      
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
           COPY CSSBE00.                                                        
           COPY CSSBE00 REPLACING FCSBE00-FILE BY FCSBE00A-FILE,                
                                  UT-S-FCSBE00 BY UT-S-FCSBE00A,                
                                  WS-FBE00-STATUS BY WS-FBE00A-STATUS.          
           SELECT FCSCA135-FILE                                         
              ASSIGN UT-S-FCSCA135                                      
              FILE STATUS IS WS-FCSCA135-STATUS.                        
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
           COPY CFDBE00.                                                        
           COPY FIOBE00.                                                        
           COPY CFDBE00 REPLACING FCSBE00-FILE  BY FCSBE00A-FILE.               
       01 FIOBE00A.                                                     
          02 FIOBE00A-DATA-REC.                                         
             05  E-FBE00A-SORT-KEY          PIC X(46).                  
             05  E-FBE00A-DATA              PIC X(500).                 
             05  E-FBE00A-SORT-SUM-FLD      PIC X(1).                   
P00599    02 FIOBE00A-END-REC REDEFINES FIOBE00A-DATA-REC.              
P00599       05  E-FBE00A-KEY-EREC          PIC X(46).                  
P00599       05  E-FBE00A-RECORD-COUNT-EREC PIC S9(09)  COMP-3.         
P00599       05  FILLER                     PIC X(496).                 
      *                                                                         
           COPY CFDCA135.                                                       
           COPY FIOCA135.                                                       
      *             WORKING-STORAGE SECTION FOR PCSCA135                        
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA135'.
MSQ017     COPY MFASQLM.
       01  WS-START                         PIC X(40)  VALUE            
                   'WORKING STORAGE FOR PCSCA135 STARTS HERE'.          
       01  WS-WORK-VARIABLES.                                           
           05 WS-PGRMNAME              PIC X(08)   VALUE 'PCSCA135'.    
           05 WS-JOB-PARM-COUNT        PIC 9(02)   VALUE 0.             
           05 WS-COMMON-DATE           PIC X(10)   VALUE SPACES.        
           05 WS-CURR-ACCOUNT-NO       PIC 9(13)   VALUE 0.             
P00599     05 WS-SYSTEM                PIC X(6)    VALUE 'SYSTEM'.      
P00599     05 WS-BE00-REC-CNTR         PIC S9(09)  COMP-3    VALUE 0.   
ACT171     05 WS-VAR                   PIC S9(9)V9(2) VALUE 0.          
ACT171     05 WS-VAR-PER               PIC S9(3).                       
       01  WS-CURR-ACCT-FIELDS.                                         
           05 WS-CODE-UTIL-TYPE        PIC X(01)   VALUE SPACE.         
           05 WS-GAS-RATE-PLAN         PIC X(03)   VALUE SPACES.        
           05 WS-ELEC-RATE-PLAN        PIC X(03)   VALUE SPACES.        
           05 WS-CURR-BILL-NO          PIC S9(9)   COMP VALUE 0.        
           05 WS-PREV-BILL-NO          PIC S9(9)   COMP VALUE 0.        
           05 WS-CURR-ELEC-AMT         PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05 WS-PREV-ELEC-AMT         PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05 WS-CURR-GAS-AMT          PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05 WS-PREV-GAS-AMT          PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05 WS-CURR-BILL-AMT         PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05 WS-PREV-BILL-AMT         PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05 WS-AMT-BILL-ITEM         PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05 WS-PREV-BILL-ITEM        PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05 WS-PERCENT-D             PIC S9(4)V9(2) COMP-3 VALUE 0.   
           05 WS-PERCENT-N             PIC S9(4)V9(2) COMP-3 VALUE 0.   
           05 WS-AR-BALANCE-LIMIT      PIC S9(07)V99  VALUE 0.          
           05 WS-OTHER-CHARGES-LIMIT   PIC S9(07)V99  VALUE 0.          
           05 WS-ELEC-LIMIT            PIC S9(07)V99  VALUE 0.          
           05 WS-GAS-LIMIT             PIC S9(07)V99  VALUE 0.          
           05 WS-CURR-BILL-LIMIT       PIC S9(07)V99  VALUE 0.          
           05 WS-PERCENT-PER           PIC 9(02)      VALUE 0.          
           05 WS-PARM-INDX             PIC 9(02)      VALUE 0.          
COB305     05 WS-PREV-OTHER-CHARGES        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-CURR-OTHER-CHARGES        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05 WS-PREV-REVENUE-MONTH    PIC X(06).                       
           05 WS-PREV-REVENUE-MONTH-N REDEFINES WS-PREV-REVENUE-MONTH.  
              10 WS-PREV-REV-YEAR      PIC 9(04).                       
              10 WS-PREV-REV-MONTH     PIC 9(02).                       
           05 WS-CURR-REVENUE-MONTH    PIC X(06).                       
           05 WS-CURR-REVENUE-MONTH-N REDEFINES WS-CURR-REVENUE-MONTH.  
              10 WS-CURR-REV-YEAR      PIC 9(04).                       
              10 WS-CURR-REV-MONTH     PIC 9(02).                       
      *                                                                         
           05 WS-FBE00-SORT-KEY.                                        
              10 WS-FBE00-COMPANY-NO   PIC X(2).                        
              10 WS-FBE00-LOCAL-OFFICE PIC 9(3).                        
              10 WS-FBE00-ACCOUNT-NO   PIC 9(13).                       
              10 WS-FBE00-TABLE-ID     PIC 9(4).                        
              10 WS-FBE00-PREMISE-NO   PIC 9(10).                       
              10 WS-FBE00-MST-ACCT-NO  PIC 9(13).                       
              10 WS-FBE00-MST-SUB-IND  PIC X(1).                        
           05 WS-FBE00-DATA            PIC X(500).                      
           05 WS-FBE00-SORT-SUM-FLD    PIC 9(01).                       
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-LIMITS-FOUND          PIC X(01) VALUE 'N'.             
              88 LIMITS-FOUND          VALUE 'Y'.                       
P00599     05 WS-BILL-CRED-DET-SW      PIC X(01).                       
P00599        88 BILL-CRED-DET-FOUND             VALUE 'Y'.             
P00599        88 BILL-CRED-DET-NOT-FOUND         VALUE 'N'.             
           05 WS-HIGH-BILL             PIC X(01) VALUE ' '.             
              88 AR-HIGH-BILL          VALUE 'A'.                       
              88 GAS-HIGH-BILL         VALUE 'G'.                       
              88 ELEC-HIGH-BILL        VALUE 'E'.                       
              88 OTHER-HIGH-BILL       VALUE 'O'.                       
           05 WS-Y                     PIC X(01) VALUE 'Y'.             
           05 WS-N                     PIC X(01) VALUE 'N'.             
       01  WS-FILE-VARIABLES.                                           
           05  WS-FBE00-STATUS         PIC X(02) VALUE '00'.            
               88 FCSBE00-SUCCESSFUL             VALUE '00'.            
               88 END-OF-REC                     VALUE '10'.            
           05  WS-FCSCA135-STATUS      PIC X(02) VALUE '00'.            
               88 FCSCA135-SUCCESSFUL            VALUE '00'.            
           05  WS-FBE00A-STATUS        PIC X(02) VALUE '00'.            
               88 FBE00A-SUCCESSFUL              VALUE '00'.            
                                                                        
       01  WS-JOB-PARM-TABLE.                                           
           05 WS-JOB-PARM-ROW OCCURS 10 TIMES.                          
              15 WS-PARM-ACCT           PIC  X(02).                     
              15 WS-PARM-ACCT-TYPE      PIC  X(01).                     
              15 WS-FILLER1             PIC  X(01).                     
              15 WS-PARM-ELEC           PIC  X(03).                     
              15 WS-PARM-ELEC-LIMIT     PIC  X(05).                     
              15 WS-FILLER2             PIC  X(01).                     
              15 WS-PARM-GAS            PIC  X(03).                     
              15 WS-PARM-GAS-LIMIT      PIC  X(05).                     
              15 WS-FILLER3             PIC  X(01).                     
              15 WS-PARM-CUR-BILL       PIC  X(03).                     
              15 WS-PARM-BILL-LIMIT     PIC  X(04).                     
              15 WS-FILLER4             PIC  X(01).                     
              15 WS-PARM-AR-OTHER       PIC  X(03).                     
              15 WS-PARM-AR-OTHER-LIMIT PIC  X(07).                     
              15 WS-FILLER5             PIC  X(01).                     
              15 WS-PARM-UNMET          PIC  X(03).                     
              15 WS-UNMET-LIMIT         PIC  X(04).                     
              15 WS-FILLER6             PIC  X(01).                     
              15 WS-PARM-PERCENTAGE     PIC  X(02).                     
              15 WS-PARM-PERCENT        PIC  X(02).                     
                                                                        
                                                                        
      *  CWS1000B CONTAINS BE00 RECORD LAYOUTS                                  
       COPY CWS1000B.                                                           
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
      ******************************************************************        
      *   CWS10005 CONTAINS INDEX/TABLE ERROR MESSAGES BE02            *        
      ******************************************************************        
       COPY CWS10005.                                                           
      ******************************************************************        
      *   ERROR MESSAGE COPYBOOK.                                      *        
      ******************************************************************        
       COPY CWS00303.                                                           
      *                                                                         
      ******* WS-ABEND-SWITCH *****************************************         
       COPY CWS09900.                                                           
      *                                                                         
      ******* WS-ABEND WORK AREA  *************************************         
       COPY CWS00010.                                                           
      *                                                                         
      ****************************************************************          
      *                DB2 TABLES INCLUDED IN PROGRAM                *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *               CSS_BILLING_DET BG                                        
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *               CSS_BILLING_HDR BI                                        
           EXEC SQL                                                             
               INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
      *               CSS_JOB_PARM G6                                           
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
P00599*               CSS_ACCOUNT  AT                                           
P00599     EXEC SQL                                                             
P00599         INCLUDE TBACCT                                                   
P00599     END-EXEC.                                                            
P00599*               CSS_CORR_MAIL_STAT MW                                     
P00599     EXEC SQL                                                             
P00599         INCLUDE TBMAILST                                                 
P00599     END-EXEC.                                                            
      *                                                                         
ACT206*****     CSS_UTIL_ENVRNMT UT                                             
ACT206     EXEC SQL                                                             
ACT206         INCLUDE TBUTLENV                                                 
ACT206     END-EXEC.                                                            
      *                                                                         
      **** CURSOR TO GET PREVOIOUS BILL AMOUNTS FOR  THE ACCOUNT                
      *                                                                         
           EXEC SQL                                                     
             DECLARE BG_CURSOR     CURSOR FOR                           
             SELECT  BG.CODE_UTIL_TYPE                                  
                    ,BG.AMT_BILL_ITEM                                   
                    ,BG.BILL_NO                                         
                    ,BG.CODE_DR_CR_CNSMPTN                              
                    ,CASE                                               
                     WHEN BG.REV_MTH_ORIG_BILL > 0                      
                        THEN BG.REV_MTH_ORIG_BILL                       
                        ELSE BG.REVENUE_MONTH                           
                        END                                             
             FROM    CSS_BILLING_DET  BG WITH(READUNCOMMITTED)                  
             WHERE   BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             
                AND  BG.CODE_BILL_CALC     IN ('A','S')                 
                AND  BG.CODE_BILL_ITM_TYPE = 'C'                        
                AND  BG.CODE_BILL_ITM_IND  = 'A'                        
                AND ((BG.REV_MTH_ORIG_BILL = 0 AND                      
                      BG.REVENUE_MONTH     = :BG-REVENUE-MONTH)         
                OR  (BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH          
                     AND BG.REVENUE_MONTH  > 0 ))                       
             FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE BG_CURSOR     CURSOR FOR                                   
MFA-TR*      SELECT  BG.CODE_UTIL_TYPE                                          
MFA-TR*             ,BG.AMT_BILL_ITEM                                           
MFA-TR*             ,BG.BILL_NO                                                 
MFA-TR*             ,BG.CODE_DR_CR_CNSMPTN                                      
MFA-TR*             ,CASE                                                       
MFA-TR*              WHEN BG.REV_MTH_ORIG_BILL > 0                              
MFA-TR*                 THEN BG.REV_MTH_ORIG_BILL                               
MFA-TR*                 ELSE BG.REVENUE_MONTH                                   
MFA-TR*                 END                                                     
MFA-TR*      FROM    CSS_BILLING_DET  BG                                        
MFA-TR*      WHERE   BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                     
MFA-TR*         AND  BG.CODE_BILL_CALC     IN ('A','S')                         
MFA-TR*         AND  BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*         AND  BG.CODE_BILL_ITM_IND  = 'A'                                
MFA-TR*         AND ((BG.REV_MTH_ORIG_BILL = 0 AND                              
MFA-TR*               BG.REVENUE_MONTH     = :BG-REVENUE-MONTH)                 
MFA-TR*         OR  (BG.REV_MTH_ORIG_BILL  = :BG-REVENUE-MONTH                  
MFA-TR*              AND BG.REVENUE_MONTH  > 0 ))                               
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
       01  WS-END                       PIC X(40)                       
           VALUE  'WORKING STORAGE FOR  PCSCA135  ENDS HERE'.           
      *****************************************************************         
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      *   0000-MAINLINE ..                                            *         
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                   *         
      *****************************************************************         
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-BE00-INPUT      THRU 1000-EXIT          
                   UNTIL END-OF-REC.                                    
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  0100-INITIALIZATION                                     *              
      *  COMMON INITIALIZATION ROUTINE                           *              
      ************************************************************              
                                                                        
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                          TO WS-ACTIVE-PARAGRAPH. 
P00599     INITIALIZE WS-BE00-REC-CNTR                                  
P00599                WS-CORR-MAIL-STAT-MW.                             
P00599     SET BILL-CRED-DET-NOT-FOUND          TO TRUE.                
                                                                        
      *    GETS PGRM RUN DATE /COMMON DATE TO VALIDATE INPUT FILE DATE          
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
                                                                        
           IF COMMON-DATE-NEEDED                                        
             PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT          
             MOVE    WS-FCA00-COMMON-DATE       TO   WS-INPUT-DATE      
           END-IF.                                                      
           DISPLAY '**  PROGRAM COMMON DATE IS: ' WS-INPUT-DATE         
                                                                        
           PERFORM 0120-OPEN-FILES              THRU 0120-EXIT.         
           PERFORM 0200-GET-PARM-DATA           THRU 0200-EXIT.         
           PERFORM 7100-READ-FCSBE00            THRU 7100-EXIT.         
           PERFORM 0500-PROCESS-BEGIN-REC       THRU 0500-EXIT.         
           MOVE    E-FBE00-CREATE-DATE-BREC     TO FIOCA135-CREATE-DATE.
           PERFORM 8500-WRITE-FCSCA135          THRU 8500-EXIT.         
      *  NEED TO WRITE FIRST RECORD INTO BE00 OUTPUTFILE                        
           MOVE    FIOBE00-DATA-REC             TO FIOBE00A-DATA-REC.   
           PERFORM 8400-WRITE-FIOBE00A          THRU 8400-EXIT.         
           PERFORM 7100-READ-FCSBE00            THRU 7100-EXIT.         
           MOVE    E-FBE00-ACCOUNT-NO           TO WS-CURR-ACCOUNT-NO.  
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 0120-OPEN-FILES.                                               *        
      * OPEN INPUT FILE FSCBE00 AND OPEN OUTFILES FSCCA135, FCSBE00A            
      ******************************************************************        
       0120-OPEN-FILES.                                                 
      *                                                                         
           MOVE '0120'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           OPEN INPUT FCSBE00-FILE.                                     
           IF FCSBE00-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSCA135 *************'             
              DISPLAY '** ERROR IN OPENING FCSBE00 FILE **'             
              DISPLAY '** PARAGRAPH - '    WS-ACTIVE-PARAGRAPH          
              DISPLAY '** FILE STATUS IS ' WS-FBE00-STATUS              
              DISPLAY '** ABENDING PROGRAM              **'             
              DISPLAY '************ PCSCA135 *************'             
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSCA135-FILE.                                   
           IF FCSCA135-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSCA135 *************'             
              DISPLAY '** ERROR IN OPENING FCSCA135 FILE **'            
              DISPLAY '** PARAGRAPH - '    WS-ACTIVE-PARAGRAPH          
              DISPLAY '** FILE STATUS IS ' WS-FCSCA135-STATUS           
              DISPLAY '** ABENDING PROGRAM              **'             
              DISPLAY '************ PCSCA135 *************'             
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSBE00A-FILE.                                   
           IF FBE00A-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSCA135 *************'             
              DISPLAY '** ERROR IN OPENING FCSBE00A FILE **'            
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
              DISPLAY '** FILE STATUS IS ' WS-FBE00A-STATUS             
              DISPLAY '** ABENDING PROGRAM              **'             
              DISPLAY '************ PCSCA135 *************'             
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * 0200-GET-PARM-DATA FROM CSS_JOB_PARM                          *         
      *****************************************************************         
       0200-GET-PARM-DATA.                                              
      *                                                                         
           MOVE '0200'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           MOVE WS-PGRMNAME                      TO   WS-PROGRAM.       
           MOVE WS-PARM                          TO   WS-COMMAND.       
           MOVE ZEROS                            TO   WS-SEQUENCE.      
           MOVE SPACES                           TO   WS-SYSIPT.        
           MOVE WS-KEY-AREA                      TO   E-FJC01-KEY.      
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT.        
           PERFORM UNTIL END-OF-SYSIPT                                  
             IF INPUT-ACTIVE                                            
                ADD           +1                 TO   WS-PARM-INDX      
                                                      WS-JOB-PARM-COUNT 
                MOVE WS-INPUT-DATA-BREAKDOWN     TO                     
                                         WS-JOB-PARM-ROW(WS-PARM-INDX)  
                                                                        
             END-IF                                                     
             DISPLAY WS-INPUT-DATA-BREAKDOWN                            
             PERFORM 7610-READ-FCSJC01           THRU 7610-EXIT         
           END-PERFORM.                                                 
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 0500-PROCESS-BEGIN-REC.                                       *         
      * PROCESS TO CHECK FILE CREATE DATE AND PROGRAM RUNDATE.        *         
      * PROGRAM WILL ABEND IF BOTH DONOT MATCH.                       *         
      *****************************************************************         
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           MOVE '0500'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           IF E-FBE00-KEY-BREC EQUAL LOW-VALUES                         
             IF WS-INPUT-DATE  EQUAL E-FBE00-CREATE-DATE-BREC           
                CONTINUE                                                
             ELSE                                                       
               DISPLAY '****************************************'       
               DISPLAY '**      FCSBE00 PROCESSING ERROR      **'       
               DISPLAY '**  FILE CREATE DATE IS NOT EQUAL TO  **'       
               DISPLAY '**       THE PROGRAM COMMON DATE      **'       
               DISPLAY '**  PARAGRAPH - ' WS-ACTIVE-PARAGRAPH           
               DISPLAY '**  ********************************  **'       
               DISPLAY '**  FILE CREATE DATE IS: '                      
                                                E-FBE00-CREATE-DATE-BREC
               DISPLAY '**  PROGRAM COMMON DATE IS: ' WS-INPUT-DATE     
               DISPLAY '**        PROCESSING TERMINATED       **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
             END-IF                                                     
           ELSE                                                         
             DISPLAY '********************************************'     
             DISPLAY '**       FCSBE00 PROCESSING ERROR         **'     
             DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'     
             DISPLAY '**         PROCESSING TERMINATED          **'     
             DISPLAY '********************************************'     
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *  1000-PROCESS-BE00-INPUT.                                               
      *  READS BE00 FILE AND LOADS 'AT','BG','BI' & 'CE' TO RESPECTIVE          
      *  WORKING STORAGE OF CWS1000B.                                           
      *  HOLDS 'AT' RECORD UNTIL THE HIGH BILL PROCESS IS COMPLETE AND          
      *  WRITES ALL OTHER RECORDS INTACT TO OUPUT FILE (COPY OF BE00)           
      *****************************************************************         
       1000-PROCESS-BE00-INPUT.                                         
      *                                                                         
           MOVE '1000'                          TO WS-ACTIVE-PARAGRAPH. 
                                                                        
           IF E-FBE00-ACCOUNT-NO     NOT EQUAL WS-CURR-ACCOUNT-NO       
              PERFORM 2000-HIGH-BILL-PROCESS    THRU 2000-EXIT          
              PERFORM 8300-WRITE-AT-RECORD         THRU 8300-EXIT       
P00599        IF BILL-CRED-DET-NOT-FOUND                                
P00599           PERFORM 2700-LOAD-CORR-MAIL-STAT                       
P00599                                          THRU 2700-EXIT          
P00599        END-IF                                                    
P00599        SET BILL-CRED-DET-NOT-FOUND       TO TRUE                 
           END-IF.                                                      
                                                                        
P00599     IF E-FBE00-KEY-EREC  NOT = HIGH-VALUES                       
P00599        ADD 1                             TO WS-BE00-REC-CNTR     
P00599     END-IF.                                                      
                                                                        
           EVALUATE E-FBE00-TABLE-ID                                    
      *    TABLE CSS_ACCOUNT AT                                                 
              WHEN 0300                                                 
                   INITIALIZE  WS-CURR-ACCT-FIELDS                      
                   MOVE E-FBE00-SORT-KEY        TO WS-FBE00-SORT-KEY    
                   MOVE E-FBE00-DATA            TO WS-ACCOUNT-AT        
P00599             MOVE WS-ACCOUNT-NO-AT        TO AT-ACCOUNT-NO        
P00599             PERFORM 7630-GET-CREDIT-GRP  THRU 7630-EXIT          
P00599             MOVE AT-CREDIT-GROUP         TO WS-CREDIT-GROUP-AT   
ACT206             IF WS-CODE-ACCT-STAT-AT = 'B'                        
ACT206                PERFORM 7640-LIGHT-ONLY-ACT-TEMP THRU 7640-EXIT   
ACT206                IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL    
ACT206                   MOVE '%' TO WS-CODE-TEMP-BILL-AT               
ACT206                   DISPLAY 'TEMP PULL CODE UPDATED '              
ACT206                    WS-CURR-ACCOUNT-NO ' RATE : ' UT-RATE-PLAN-NO 
ACT206                END-IF                                            
ACT206             END-IF                                               
                   MOVE E-FBE00-SORT-SUM-FLD    TO WS-FBE00-SORT-SUM-FLD
      *    TABLE CSS_CUST_STATS CE                                              
              WHEN 0600                                                 
                   MOVE E-FBE00-DATA            TO   WS-CUST-STATS-CE   
                   MOVE FIOBE00-DATA-REC        TO   FIOBE00A-DATA-REC  
                   PERFORM 8400-WRITE-FIOBE00A  THRU 8400-EXIT          
      *    TABLE CSS_BILLING_HDR BI                                             
              WHEN 1900                                                 
                   MOVE E-FBE00-DATA            TO   WS-BILLING-BI      
                   MOVE FIOBE00-DATA-REC        TO   FIOBE00A-DATA-REC  
                   PERFORM 8400-WRITE-FIOBE00A  THRU 8400-EXIT          
                   PERFORM 1500-PROCESS-BI-DATA THRU 1500-EXIT          
      *    TABLE CSS_BILLING_DET BG                                             
              WHEN 1910                                                 
                   MOVE E-FBE00-DATA            TO   WS-BILLING-BG      
                   MOVE FIOBE00-DATA-REC        TO   FIOBE00A-DATA-REC  
                   PERFORM 8400-WRITE-FIOBE00A  THRU 8400-EXIT          
                   PERFORM 1510-PROCESS-BG-DATA THRU 1510-EXIT          
P00599*    TABLE CSS_CORR_MAIL_STAT MW                                          
P00599        WHEN 6770                                                 
P00599             MOVE E-FBE00-DATA            TO WS-CORR-MAIL-STAT-MW 
P00599             MOVE FIOBE00-DATA-REC        TO   FIOBE00A-DATA-REC  
P00599             PERFORM 8400-WRITE-FIOBE00A  THRU 8400-EXIT          
P00599*    TABLE CSS_BILL_CRED_DET 1H                                           
P00599        WHEN 8000                                                 
P00599             SET BILL-CRED-DET-FOUND      TO TRUE                 
P00599             MOVE FIOBE00-DATA-REC        TO   FIOBE00A-DATA-REC  
P00599             PERFORM 8400-WRITE-FIOBE00A  THRU 8400-EXIT          
              WHEN OTHER                                                
P00599             IF E-FBE00-KEY-EREC  = HIGH-VALUES                   
P00599                MOVE WS-BE00-REC-CNTR      TO                     
P00599                                         E-FBE00-RECORD-COUNT-EREC
P00599                MOVE FIOBE00-END-REC       TO  FIOBE00A-END-REC   
P00599                PERFORM 8400-WRITE-FIOBE00A THRU 8400-EXIT        
P00599             ELSE                                                 
P00599                MOVE FIOBE00-DATA-REC      TO   FIOBE00A-DATA-REC 
P00599                PERFORM 8400-WRITE-FIOBE00A  THRU 8400-EXIT       
P00599             END-IF                                               
           END-EVALUATE.                                                
                                                                        
           MOVE E-FBE00-ACCOUNT-NO              TO   WS-CURR-ACCOUNT-NO.
           PERFORM 7100-READ-FCSBE00            THRU 7100-EXIT.         
                                                                        
           IF END-OF-REC                                                
              PERFORM 2000-HIGH-BILL-PROCESS    THRU 2000-EXIT          
P00599        IF BILL-CRED-DET-NOT-FOUND                                
P00599           PERFORM 2700-LOAD-CORR-MAIL-STAT                       
P00599                                          THRU 2700-EXIT          
P00599        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      *1500-PROCESS-BI-DATA.                                        *           
      *CURRENT TOTAL OTHER CHARGES IS TO BE MOVED TO WORKING STORAGE            
      ***************************************************************           
       1500-PROCESS-BI-DATA.                                            
      *                                                                         
           MOVE '1500'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           MOVE WS-TOT-OTHER-CHARGES-BI        TO WS-CURR-OTHER-CHARGES.
      *                                                                         
       1500-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      *1510-PROCESS-BG-DATA.                                        *           
      *PERFORMS 'A''C''A' CHECK FOR BG ROW AND CLACULATES THE TOTAL             
      *BILL AMOUNT AND VARIOUS IC AMOUNTS                                       
      ***************************************************************           
       1510-PROCESS-BG-DATA.                                            
      *                                                                         
           MOVE '1510'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           SET WS-BILLING-INDX TO 1.                                    
                                                                        
           IF WS-CODE-BILL-CALC-BG (WS-BILLING-INDX)    = 'A' OR 'S'    
              AND WS-CODE-BILL-ITM-TYPE-BG  (WS-BILLING-INDX) = 'C'     
              AND WS-CODE-BILL-ITM-IND-BG   (WS-BILLING-INDX) = 'A'     
                                                                        
                MOVE WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX)             
                                                TO WS-CODE-UTIL-TYPE    
                MOVE WS-BILL-NO-BG (WS-BILLING-INDX)                    
                                                TO WS-CURR-BILL-NO      
      * GET REVENUE MONTH IF REBILL ROW EXISTS                                  
                IF WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) IS NUMERIC 
                   AND WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX) > 0    
                   MOVE WS-REV-MTH-ORIG-BILL-BG (WS-BILLING-INDX)       
                                               TO  WS-CURR-REVENUE-MONTH
                ELSE                                                    
                   MOVE WS-REVENUE-MONTH-BG (WS-BILLING-INDX)           
                                               TO  WS-CURR-REVENUE-MONTH
                END-IF                                                  
                                                                        
                MOVE WS-AMT-BILL-ITEM-BG (WS-BILLING-INDX)              
                                                TO WS-AMT-BILL-ITEM     
      * ADJUSTMENT AMOUNT BASED ON CR OR DR.                                    
                IF WS-CODE-DR-CR-CNSMPTN-BG (WS-BILLING-INDX) = 'C'     
                   COMPUTE WS-AMT-BILL-ITEM = WS-AMT-BILL-ITEM * -1     
                END-IF                                                  
                                                                        
                ADD WS-AMT-BILL-ITEM            TO WS-CURR-BILL-AMT     
                                                                        
                EVALUATE WS-CODE-UTIL-TYPE                              
                  WHEN 'E'                                              
                       ADD  WS-AMT-BILL-ITEM    TO WS-CURR-ELEC-AMT     
                       MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)        
                                                TO WS-ELEC-RATE-PLAN    
                  WHEN 'G'                                              
                       ADD  WS-AMT-BILL-ITEM    TO WS-CURR-GAS-AMT      
                       MOVE WS-RATE-PLAN-NO-BG (WS-BILLING-INDX)        
                                                TO WS-GAS-RATE-PLAN     
                END-EVALUATE                                            
           END-IF.                                                      
      *                                                                         
       1510-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * 2000-HIGH-BILL-PROCESS.                                                 
      * PERFORMS THE CHECK BASED ON ACCOUNT TYPE TO DETERMINE THE               
      * HIGH BILL PROCESS. NON-UTIL ACCOUNTS WILL BE PROCESSED ON               
      * AR BALANCE. OTHER ACCOUNTS WILL BE PROCESSED ON  UTIL AMOUNTS           
      *****************************************************************         
       2000-HIGH-BILL-PROCESS.                                          
      *                                                                         
           MOVE '2000'                          TO WS-ACTIVE-PARAGRAPH. 
                                                                        
A01292     DISPLAY 'CURR PROCESSING ACCT#' WS-CURR-ACCOUNT-NO           
           MOVE WS-N                                 TO WS-LIMITS-FOUND 
                                                        WS-HIGH-BILL.   
           PERFORM 2100-GET-HIGH-BILL-LIMITS         THRU 2100-EXIT.    
           IF LIMITS-FOUND                                              
              IF WS-ACCOUNT-TYPE-CODE-AT = 'N'                          
                 PERFORM 2200-CHK-NON-UTIL-HIGH-BILL THRU 2200-EXIT     
              ELSE                                                      
                 PERFORM 2300-CHK-UTIL-HIGH-BILL     THRU 2300-EXIT     
              END-IF                                                    
           ELSE                                                         
                DISPLAY 'JOB PARM VALUES NOT AVAILABLE FOR '            
                      'ACCT TYPE : ' WS-ACCOUNT-TYPE-CODE-AT            
           END-IF.                                                      
                                                                        
           IF WS-HIGH-BILL = WS-N                                       
              CONTINUE                                                  
           ELSE                                                         
              IF WS-CODE-TEMP-BILL-AT  = 'A' OR ' '                     
A01292           MOVE    'B'                    TO WS-CODE-TEMP-BILL-AT 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *                                                                         
       2000-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      *2100-GET-HIGH-BILL-LIMITS.                                   *           
      *SEARCHES WS JOB PARM TABLE TO GET LIMITS BASED ON ACCOUNT TYPE           
      ***************************************************************           
       2100-GET-HIGH-BILL-LIMITS.                                       
      *                                                                         
           MOVE '2100'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           MOVE  1                             TO WS-PARM-INDX.         
           PERFORM UNTIL WS-PARM-INDX > WS-JOB-PARM-COUNT               
                                               OR LIMITS-FOUND          
              IF WS-PARM-ACCT-TYPE(WS-PARM-INDX)                        
                                              = WS-ACCOUNT-TYPE-CODE-AT 
                   MOVE WS-PARM-ELEC-LIMIT(WS-PARM-INDX)                
                                               TO WS-ELEC-LIMIT         
                   MOVE WS-PARM-GAS-LIMIT(WS-PARM-INDX)                 
                                               TO WS-GAS-LIMIT          
                   MOVE WS-PARM-BILL-LIMIT(WS-PARM-INDX)                
                                               TO WS-CURR-BILL-LIMIT    
                   IF WS-ACCOUNT-TYPE-CODE-AT = 'N'                     
                      MOVE WS-PARM-AR-OTHER-LIMIT   (WS-PARM-INDX)      
                                               TO WS-AR-BALANCE-LIMIT   
                   ELSE                                                 
                      MOVE WS-PARM-AR-OTHER-LIMIT   (WS-PARM-INDX)      
                                               TO WS-OTHER-CHARGES-LIMIT
                   END-IF                                               
                   MOVE WS-PARM-PERCENT (WS-PARM-INDX)                  
                                               TO WS-PERCENT-PER        
                   COMPUTE WS-PERCENT-D   = WS-PERCENT-PER / 100        
                   COMPUTE WS-PERCENT-N   = (1 + WS-PERCENT-D)          
                   MOVE  WS-Y                  TO WS-LIMITS-FOUND       
              END-IF                                                    
              ADD        +1                    TO WS-PARM-INDX          
           END-PERFORM.                                                 
      *                                                                         
       2100-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      *2200-CHK-NON-UTIL-HIGH-BILL.                               *             
      *ACCOUNTS WILL BE DETERMINED AS HIGH BILL IF AR BALANCE IS                
      *GREATER THAN AR BALANCE LIMIT WHICH IS FROM JOB_PARM                     
      ***************************************************************           
       2200-CHK-NON-UTIL-HIGH-BILL.                                     
      *                                                                         
           MOVE '2200'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           IF WS-TOTAL-AR-BALANCE-AT      >  WS-AR-BALANCE-LIMIT        
              MOVE    'A'                      TO WS-HIGH-BILL          
              PERFORM 2610-LOAD-FIOCA135-REC   THRU 2610-EXIT           
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      *2300-CHK-UTIL-HIGH-BILL.                               *                 
      *CURRENT UTIL AMOUNT IS COMPARED W.R.TO PREVIOUS UTIL AMOUNT              
      *PERCENTAGE AND UTIL LIMITS.                                              
      ***************************************************************           
       2300-CHK-UTIL-HIGH-BILL.                                         
      *                                                                         
           MOVE '2300'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           PERFORM 2400-GET-PREV-REVENUE-MONTH THRU 2400-EXIT.          
           PERFORM 2500-GET-PREV-BILL-AMTS     THRU 2500-EXIT.          
           MOVE    WS-ACCOUNT-NO-AT            TO BI-ACCOUNT-NO.        
           MOVE    WS-PREV-BILL-NO             TO BI-BILL-NO.           
A01292     INITIALIZE BI-TOT-OTHER-CHARGES.                             
           PERFORM 7500-PREV-TOT-OTHER-CHARGES THRU 7500-EXIT.          
           MOVE    BI-TOT-OTHER-CHARGES                                 
                                          TO WS-PREV-OTHER-CHARGES.     
           PERFORM 2600-HIGH-BILL-PROCESS      THRU 2600-EXIT.          
      *                                                                         
       2300-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      *2400-GET-PREV-REVENUE-MONTH.                                             
      *CALCULATES PREV REVENUE MONTH BY DEDUCTING ONE FROM CURRENT MONTH        
      *****************************************************************         
       2400-GET-PREV-REVENUE-MONTH.                                     
      *                                                                         
           MOVE '2400'                          TO WS-ACTIVE-PARAGRAPH. 
                                                                        
           COMPUTE WS-PREV-REV-MONTH    = WS-CURR-REV-MONTH - 1         
           IF WS-PREV-REV-MONTH = 0                                     
              COMPUTE WS-PREV-REV-MONTH = 12                            
              COMPUTE WS-PREV-REV-YEAR  = WS-CURR-REV-YEAR - 1          
           ELSE                                                         
              COMPUTE WS-PREV-REV-YEAR  = WS-CURR-REV-YEAR              
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      *2500-GET-PREV-BILL-AMTS.                                                 
      *FETCHES PREVIOUS BILL AMOUNTS                                            
      ***************************************************************           
       2500-GET-PREV-BILL-AMTS.                                         
      *                                                                         
            MOVE '2500'                       TO WS-ACTIVE-PARAGRAPH.   
                                                                        
A01292      INITIALIZE BG-AMT-BILL-ITEM.                                
            MOVE    WS-ACCOUNT-NO-AT              TO BG-ACCOUNT-NO.     
            MOVE    WS-PREV-REVENUE-MONTH         TO BG-REVENUE-MONTH.  
            PERFORM 7710-OPEN-BILLING-DET-CURSOR  THRU 7710-EXIT.       
            PERFORM 7720-FETCH-BILLING-DET-CURSOR THRU 7720-EXIT.       
            PERFORM 2510-PREVIOUS-BILL-AMT        THRU 2510-EXIT        
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
            PERFORM 7730-CLOSE-BILLING-DET-CURSOR THRU 7730-EXIT.       
      *                                                                         
       2500-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      *2510-PREVIOUS-BILL-AMT.                                                  
      ***************************************************************           
       2510-PREVIOUS-BILL-AMT.                                          
      *                                                                         
           MOVE '2510'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
           MOVE BG-BILL-NO                     TO WS-PREV-BILL-NO.      
                                                                        
           IF BG-CODE-DR-CR-CNSMPTN = 'C'                               
              COMPUTE WS-PREV-BILL-ITEM = BG-AMT-BILL-ITEM  * -1        
           ELSE                                                         
              MOVE BG-AMT-BILL-ITEM TO WS-PREV-BILL-ITEM                
           END-IF                                                       
                                                                        
           COMPUTE WS-PREV-BILL-AMT = WS-PREV-BILL-AMT    +             
                                                  WS-PREV-BILL-ITEM.    
           EVALUATE BG-CODE-UTIL-TYPE                                   
              WHEN 'E'                                                  
                    COMPUTE WS-PREV-ELEC-AMT =  WS-PREV-ELEC-AMT +      
                                                WS-PREV-BILL-ITEM       
              WHEN 'G'                                                  
                    COMPUTE WS-PREV-GAS-AMT  =  WS-PREV-GAS-AMT +       
                                                WS-PREV-BILL-ITEM       
            END-EVALUATE.                                               
                                                                        
            PERFORM 7720-FETCH-BILLING-DET-CURSOR THRU 7720-EXIT.       
      *                                                                         
       2510-EXIT.                                                       
            EXIT.                                                       
ACT171***************************************************************           
ACT171*2520-CALC-VARIANCE.                                                      
ACT171***************************************************************           
ACT171 2520-CALC-VARIANCE.                                              
ACT171*                                                                         
ACT171     MOVE '2520'                         TO WS-ACTIVE-PARAGRAPH.  
ACT171                                                                  
ACT171     COMPUTE  WS-VAR =  WS-CURR-BILL-AMT - WS-PREV-BILL-AMT.      
ACT171     IF WS-PREV-BILL-AMT > 0                                      
ACT171        COMPUTE WS-VAR-PER = ( WS-VAR / WS-PREV-BILL-AMT ) * 100  
ACT171     ELSE                                                         
ACT171        MOVE ZEROES                      TO  WS-VAR-PER           
ACT171     END-IF.                                                      
ACT171     MOVE WS-VAR                       TO FIOCA135-VAR.           
ACT171     MOVE WS-VAR-PER                   TO FIOCA135-VAR-PER.       
ACT171*                                                                         
ACT171 2520-EXIT.                                                       
ACT171      EXIT.                                                       
      ***************************************************************           
      *2600-HIGH-BILL-PROCESS.                                    *             
      *CURRENT AMOUNT IS GREATER THAN LIMIT, MOVES RESPECTIVE CODE TO           
      *HIGH BILL REASON AND LOADS OUT PUT RECORD.                               
      ***************************************************************           
       2600-HIGH-BILL-PROCESS.                                          
      *                                                                         
           MOVE '2600'                         TO WS-ACTIVE-PARAGRAPH.  
                                                                        
     *** EVEN IF GAS SERVICE IS NOT AVAILABLE BELOW CHECK WILL NOT FLAG         
     ***   THE ACCOUNT                                                          
           IF WS-CURR-GAS-AMT > WS-PREV-GAS-AMT * WS-PERCENT-N          
              IF WS-CURR-GAS-AMT > WS-GAS-LIMIT                         
                 MOVE    'G'                     TO   WS-HIGH-BILL      
                 PERFORM 2610-LOAD-FIOCA135-REC  THRU 2610-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CURR-ELEC-AMT > 0                                      
              IF WS-CURR-ELEC-AMT > WS-PREV-ELEC-AMT * WS-PERCENT-N     
                 IF WS-CURR-ELEC-AMT > WS-ELEC-LIMIT                    
                    MOVE    'E'                    TO   WS-HIGH-BILL    
                    PERFORM 2610-LOAD-FIOCA135-REC THRU 2610-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-CURR-OTHER-CHARGES  > WS-PREV-OTHER-CHARGES *          
                                        WS-PERCENT-N                    
              IF WS-CURR-OTHER-CHARGES > WS-OTHER-CHARGES-LIMIT         
                 MOVE    'O'                       TO   WS-HIGH-BILL    
                 PERFORM 2610-LOAD-FIOCA135-REC    THRU 2610-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2600-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      * 2610-LOAD-FIOCA135-REC.                                      *          
      * OUTPUT FILE USED TO GENERATE HIGH BILL REPORT                           
      ****************************************************************          
       2610-LOAD-FIOCA135-REC.                                          
      *                                                                         
           MOVE '2610'                       TO WS-ACTIVE-PARAGRAPH.    
                                                                        
           INITIALIZE FIOCA135-REC.                                     
           MOVE WS-ACCOUNT-NO-AT             TO FIOCA135-ACCOUNT-NO.    
           MOVE WS-COMPANY-NO-AT             TO FIOCA135-COMPANY-NO.    
           MOVE WS-ACCOUNT-TYPE-CODE-AT      TO                         
                                               FIOCA135-ACCT-TYPE-CODE. 
           EVALUATE WS-HIGH-BILL                                        
             WHEN 'G'                                                   
                     MOVE  'G'               TO FIOCA135-CODE-UTIL-TYPE 
                     MOVE  WS-GAS-RATE-PLAN  TO FIOCA135-RATE-PLAN-NO   
             WHEN 'E'                                                   
                     MOVE  'E'               TO FIOCA135-CODE-UTIL-TYPE 
                     MOVE  WS-ELEC-RATE-PLAN TO FIOCA135-RATE-PLAN-NO   
             WHEN OTHER                                                 
                     MOVE  ' '               TO FIOCA135-CODE-UTIL-TYPE 
                     MOVE  ' '               TO FIOCA135-RATE-PLAN-NO   
           END-EVALUATE.                                                
                                                                        
           IF   WS-REGULATED-CD-AT = '02'                               
                MOVE 'Y'                     TO FIOCA135-REGULATED-FLAG 
           ELSE                                                         
                MOVE 'N'                     TO FIOCA135-REGULATED-FLAG 
           END-IF.                                                      
           MOVE WS-BILL-CYCLE-AT             TO FIOCA135-BILL-CYCLE.    
           MOVE WS-CURR-BILL-NO              TO FIOCA135-BILL-NO        
           MOVE WS-CURR-BILL-AMT             TO FIOCA135-AMT-BILL-ITEM. 
           MOVE WS-PREV-BILL-AMT             TO FIOCA135-PREV-BILL-AMT. 
           MOVE WS-TOTAL-AR-BALANCE-AT       TO FIOCA135-TOTAL-AR-BAL.  
           MOVE WS-EBILL-REGISTER-IND-CE     TO FIOCA135-EBILL-REG-IND. 
           MOVE WS-CODES-DATA-PRESENT-AT (14:1) TO FIOCA135-DRAFT-IND.  
           MOVE WS-HIGH-BILL                 TO FIOCA135-HIGH-BILL-CODE.
           MOVE WS-SECURED-RATE-FL           TO FIOCA135-SECURED-RATE.  
ACT171     PERFORM 2520-CALC-VARIANCE        THRU 2520-EXIT.            
           PERFORM 8500-WRITE-FCSCA135       THRU 8500-EXIT.            
      *                                                                         
       2610-EXIT.                                                       
            EXIT.                                                       
                                                                        
P00599***************************************************************           
P00599*2700-LOAD-CORR-MAIL-STAT.                                    *           
P00599*LOAD CORR-MAIL-STAT TABLE WITH UPDATED TRACKING STATUS CODE  *           
P00599***************************************************************           
P00599 2700-LOAD-CORR-MAIL-STAT.                                        
P00599*                                                                         
P00599     MOVE '2700'                         TO WS-ACTIVE-PARAGRAPH.  
P00599                                                                  
P00599     MOVE WS-ACCOUNT-NO-MW               TO MW-ACCOUNT-NO         
P00599     MOVE WS-BARCODE-UNIQUE-ID-MW        TO MW-BARCODE-UNIQUE-ID  
P00599     MOVE WS-TRACKING-STATUS-CD-MW       TO MW-TRACKING-STATUS-CD.
P00599     MOVE 'S'                            TO                       
P00599                                       MW-TRACKING-STATUS-CD(1:1).
P00599     MOVE WS-SYSTEM                      TO MW-USER-ID.           
P00599     MOVE WS-PGRMNAME                    TO MW-APPL-PROGRAM-ID    
P00599     PERFORM 8200-UPDATE-CORR-MAIL-STAT  THRU 8200-EXIT.          
P00599     INITIALIZE WS-CORR-MAIL-STAT-MW.                             
P00599*                                                                         
P00599 2700-EXIT.                                                       
P00599      EXIT.                                                       
      ******************************************************************        
      *  READS FCSBE00 FILE FOR INPUT                                  *        
      ******************************************************************        
       7100-READ-FCSBE00.                                               
      *                                                                         
           MOVE '7100'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           READ FCSBE00-FILE                                            
                                                                        
           IF FCSBE00-SUCCESSFUL  OR  END-OF-REC                        
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '************ PCSCA135 ***************'          
               DISPLAY '** ERROR IN READING FCSBE00 FILE ****'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FBE00-STATUS             
               DISPLAY '** ABENDING PROGRAM              **'            
               DISPLAY '************ PCSCA135 ***************'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *  SELECT CSS_JOB_PARM TABLE                                 *            
      *  7600-, 7610-,7611- PARAGRAPHS                             *            
      ***************************************************************           
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
                                                                        
      *  7620-START-FCSCA00                                                     
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
                                                                        
      *  6251-GET-FJC01-DATE                                                    
       COPY CPD00037.                                                           
                                                                        
      *  6240-GET-FCA00-COMMON-DATE                                             
       COPY CPD00040.                                                           
      *                                                                         
      *****************************************************************         
      * 7500-PREV-TOT-OTHER-CHARGES                                             
      *****************************************************************         
       7500-PREV-TOT-OTHER-CHARGES.                                     
      *                                                                         
           MOVE '7500'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           EXEC SQL                                                     
              SELECT TOT_OTHER_CHARGES                                  
                INTO :BI-TOT-OTHER-CHARGES                              
                FROM CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
               WHERE BI.ACCOUNT_NO       = :BI-ACCOUNT-NO               
                AND  BI.BILL_NO          = :BI-BILL-NO                  
                AND  BI.CODE_BILL_STATUS IN ('I','C')                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TOT_OTHER_CHARGES                                          
MFA-TR*         INTO :BI-TOT-OTHER-CHARGES                                      
MFA-TR*         FROM CSS_BILLING_HDR BI                                         
MFA-TR*        WHERE BI.ACCOUNT_NO       = :BI-ACCOUNT-NO                       
MFA-TR*         AND  BI.BILL_NO          = :BI-BILL-NO                          
MFA-TR*         AND  BI.CODE_BILL_STATUS IN ('I','C')                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '7500-PREV-TOT-OTHER-CHARGES'                    
                       ' RETURN CODE    = '  WS-ACTIVE-RETURN-CODE      
                       ' ACCOUNT NO     = '  BI-ACCOUNT-NO              
                       ' PREV BILL NO   = '  BI-BILL-NO                 
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
P00599*****************************************************************         
P00599* 7630-GET-CREDIT-GRP.                                                    
P00599*****************************************************************         
P00599 7630-GET-CREDIT-GRP.                                             
P00599*                                                                         
P00599     MOVE '7630'                           TO WS-ACTIVE-PARAGRAPH.
P00599     MOVE SPACES                           TO AT-CREDIT-GROUP.    
P00599                                                                  
P00599     EXEC SQL                                                     
P00599        SELECT CREDIT_GROUP                                       
P00599          INTO :AT-CREDIT-GROUP                                   
P00599          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
P00599         WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO               
P00599                                                           
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CREDIT_GROUP                                               
MFA-TR*         INTO :AT-CREDIT-GROUP                                           
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599*                                                                         
P00599     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00599*                                                                         
P00599     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599         DISPLAY '7630-GET-CREDIT-GRP       '                     
P00599                 ' RETURN CODE    = '  WS-ACTIVE-RETURN-CODE      
P00599                 ' ACCOUNT NO     = '  AT-ACCOUNT-NO              
P00599         PERFORM 9900-ABEND            THRU 9900-EXIT             
P00599     END-IF.                                                      
P00599*                                                                         
P00599 7630-EXIT.                                                       
P00599     EXIT.                                                        
ACT206******************************************************************        
ACT206**  LIGHT ACCOUNT WITH NO CONSUMPTION                           **        
ACT206******************************************************************        
ACT206 7640-LIGHT-ONLY-ACT-TEMP.                                        
ACT206     MOVE '7640'                           TO WS-ACTIVE-PARAGRAPH.
ACT206                                                                  
ACT206     EXEC SQL                                                     
ACT206        SELECT TOP(1) UT.RATE_PLAN_NO                                    
ACT206          INTO :UT-RATE-PLAN-NO                                   
ACT206          FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
ACT206              ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
ACT206              ,CSS_BILLING_HDR  BI WITH(READUNCOMMITTED)                  
ACT206         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
ACT206           AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                      
ACT206           AND AT.ACCOUNT_NO = BI.ACCOUNT_NO                      
ACT206           AND BI.BILL_NO    =                                    
ACT206               (SELECT MAX(BI1.BILL_NO)                           
ACT206                  FROM CSS_BILLING_HDR BI1 WITH(READUNCOMMITTED)          
ACT206                 WHERE BI1.ACCOUNT_NO    = BI.ACCOUNT_NO          
ACT206                   AND BI1.DATE_BILLED  IS NOT NULL)              
ACT206           AND EXISTS                                             
ACT206               (SELECT '1'                                        
ACT206                  FROM CSS_CUST_PLAN  CP WITH(READUNCOMMITTED)            
ACT206                 WHERE UT.ACCOUNT_NO     = CP.ACCOUNT_NO          
ACT206                   AND UT.CODE_UTIL_TYPE = CP.CODE_UTIL_TYPE      
ACT206                   AND UT.IC_NO          = CP.IC_NO )             
ACT206           AND NOT EXISTS                                         
ACT206              (SELECT '1'                                         
ACT206                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)             
ACT206                    ,CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)            
ACT206              WHERE BG.ACCOUNT_NO = BI.ACCOUNT_NO                 
ACT206                AND BG.BILL_NO    = BI.BILL_NO                    
ACT206                AND BG.CODE_UTIL_TYPE IN ('E', 'G')               
ACT206                AND BG.ACCOUNT_NO         =  CX.ACCOUNT_NO        
ACT206                AND BG.IC_NO              =  CX.IC_NO             
ACT206                AND BG.CODE_UTIL_TYPE     =  CX.CODE_UTIL_TYPE    
ACT206                AND BG.BILL_NO            =  CX.BILL_NO           
ACT206                AND BG.BILL_ITEM_TIMESTMP =  CX.BILL_ITEM_TIMESTMP
ACT206                AND CX.NO_DAYS <> 0)                              
ACT206                                              
ACT206                                                           
ACT206     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RATE_PLAN_NO                                            
MFA-TR*         INTO :UT-RATE-PLAN-NO                                           
MFA-TR*         FROM CSS_ACCOUNT      AT                                        
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_BILLING_HDR  BI                                        
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*          AND AT.ACCOUNT_NO = UT.ACCOUNT_NO                              
MFA-TR*          AND AT.ACCOUNT_NO = BI.ACCOUNT_NO                              
MFA-TR*          AND BI.BILL_NO    =                                            
MFA-TR*              (SELECT MAX(BI1.BILL_NO)                                   
MFA-TR*                 FROM CSS_BILLING_HDR BI1                                
MFA-TR*                WHERE BI1.ACCOUNT_NO    = BI.ACCOUNT_NO                  
MFA-TR*                  AND BI1.DATE_BILLED  IS NOT NULL)                      
MFA-TR*          AND EXISTS                                                     
MFA-TR*              (SELECT '1'                                                
MFA-TR*                 FROM CSS_CUST_PLAN  CP                                  
MFA-TR*                WHERE UT.ACCOUNT_NO     = CP.ACCOUNT_NO                  
MFA-TR*                  AND UT.CODE_UTIL_TYPE = CP.CODE_UTIL_TYPE              
MFA-TR*                  AND UT.IC_NO          = CP.IC_NO )                     
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*             (SELECT '1'                                                 
MFA-TR*               FROM CSS_BILLING_DET BG                                   
MFA-TR*                   ,CSS_CNSMPTN_HIST CX                                  
MFA-TR*             WHERE BG.ACCOUNT_NO = BI.ACCOUNT_NO                         
MFA-TR*               AND BG.BILL_NO    = BI.BILL_NO                            
MFA-TR*               AND BG.CODE_UTIL_TYPE IN ('E', 'G')                       
MFA-TR*               AND BG.ACCOUNT_NO         =  CX.ACCOUNT_NO                
MFA-TR*               AND BG.IC_NO              =  CX.IC_NO                     
MFA-TR*               AND BG.CODE_UTIL_TYPE     =  CX.CODE_UTIL_TYPE            
MFA-TR*               AND BG.BILL_NO            =  CX.BILL_NO                   
MFA-TR*               AND BG.BILL_ITEM_TIMESTMP =  CX.BILL_ITEM_TIMESTMP        
MFA-TR*               AND CX.NO_DAYS <> 0)                                      
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT206                                                                  
ACT206     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
ACT206                                                                  
ACT206     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT206        CONTINUE                                                  
ACT206     ELSE                                                         
ACT206         DISPLAY '7640-LIGHT-ONLY-ACT-TEMP  '                     
ACT206                 ' RETURN CODE    = '  WS-ACTIVE-RETURN-CODE      
ACT206                 ' ACCOUNT NO     = '  AT-ACCOUNT-NO              
ACT206         PERFORM 9900-ABEND            THRU 9900-EXIT             
ACT206     END-IF.                                                      
ACT206                                                                  
ACT206 7640-EXIT.                                                       
ACT206      EXIT.                                                       
      ******************************************************************        
      **  OPEN CSS_BILLING_DET CURSOR                                 **        
      ******************************************************************        
      *                                                                         
       7710-OPEN-BILLING-DET-CURSOR.                                    
      *                                                                         
           MOVE '7710'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           EXEC SQL                                                     
               OPEN BG_CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '7710-OPEN-BILLING-DET-CURSOR'                   
                       ' RETURN CODE    = '  WS-ACTIVE-RETURN-CODE      
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH CSS_BILLING_DET CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7720-FETCH-BILLING-DET-CURSOR.                                   
      *                                                                         
           MOVE '7720'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           EXEC SQL                                                     
               FETCH BG_CURSOR                                          
               INTO :BG-CODE-UTIL-TYPE                                  
                   ,:BG-AMT-BILL-ITEM                                   
                   ,:BG-BILL-NO                                         
                   ,:BG-CODE-DR-CR-CNSMPTN                              
                   ,:BG-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '7720-FETCH-BILLING-DET-CURSOR'                  
                       ' RETURN CODE    = '  WS-ACTIVE-RETURN-CODE      
               DISPLAY 'BG-ACCOUNT-NO   = '  BG-ACCOUNT-NO              
               DISPLAY 'BG-BILL-NO      = '  BG-BILL-NO                 
               DISPLAY 'BG-REVENUE-MONTH ='  BG-REVENUE-MONTH           
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  CLOSE CSS_BILLING_DET CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7730-CLOSE-BILLING-DET-CURSOR.                                   
      *                                                                         
           MOVE '7730'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           EXEC SQL                                                     
               CLOSE BG_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '7730-CLOSE-BILLING-DET-CURSOR'                  
                       ' RETURN CODE    = '  WS-ACTIVE-RETURN-CODE      
               DISPLAY 'BG-ACCOUNT-NO   = '  BG-ACCOUNT-NO              
               DISPLAY 'BG-BILL-NO      = '  BG-BILL-NO                 
               DISPLAY 'BG-REVENUE-MONTH ='  BG-REVENUE-MONTH           
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
P00599* 8200-UPDATE-CORR-MAIL-STAT.                                 *           
P00599*****************************************************************         
P00599 8200-UPDATE-CORR-MAIL-STAT.                                      
P00599                                                                  
P00599     EXEC SQL                                                     
P00599         UPDATE CSS_CORR_MAIL_STAT                                
P00599            SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD      
P00599               ,LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()           
P00599               ,USER_ID             = :MW-USER-ID                 
P00599               ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID         
P00599            WHERE ACCOUNT_NO        = :MW-ACCOUNT-NO              
P00599              AND BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID       
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CORR_MAIL_STAT                                        
MFA-TR*           SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD              
MFA-TR*              ,LAST_UPDATE_TS      = CURRENT TIMESTAMP                   
MFA-TR*              ,USER_ID             = :MW-USER-ID                         
MFA-TR*              ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID                 
MFA-TR*           WHERE ACCOUNT_NO        = :MW-ACCOUNT-NO                      
MFA-TR*             AND BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00599        CONTINUE                                                  
P00599     ELSE                                                         
P00599        DISPLAY ' '                                               
P00599        DISPLAY '**8200-UPDATE-CORR-MAIL-STAT**'                  
P00599                ' RETURN CODE=' WS-ACTIVE-RETURN-CODE             
P00599        DISPLAY '**ACCOUNT #  : ' MW-ACCOUNT-NO                   
P00599        DISPLAY '**UNIQUE ID  : ' MW-BARCODE-UNIQUE-ID            
P00599        DISPLAY '**STATUS     : ' MW-TRACKING-STATUS-CD           
P00599        DISPLAY ' '                                               
P00599        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00599     END-IF.                                                      
P00599*                                                                         
P00599 8200-EXIT.                                                       
P00599     EXIT.                                                        
P00599*                                                                         
      *****************************************************************         
      * 8300-WRITE-AT-RECORD.                                         *         
      *****************************************************************         
       8300-WRITE-AT-RECORD.                                            
      *                                                                         
           MOVE '8300'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           MOVE  WS-FBE00-SORT-KEY          TO  E-FBE00A-SORT-KEY.      
           MOVE  WS-ACCOUNT-AT              TO  E-FBE00A-DATA.          
           MOVE  WS-FBE00-SORT-SUM-FLD      TO                          
                                            E-FBE00A-SORT-SUM-FLD.      
           PERFORM 8400-WRITE-FIOBE00A      THRU 8400-EXIT.             
                                                                        
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8400-WRITE-FIOBE00A.                                         *          
      *****************************************************************         
       8400-WRITE-FIOBE00A.                                             
      *                                                                         
           MOVE '8400'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           WRITE FIOBE00A.                                              
                                                                        
           IF  FBE00A-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY  '8400-ERROR ON FIOBE00A WRITE. STATUS IS '      
                         WS-FBE00A-STATUS                               
               PERFORM  9900-ABEND               THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
           INITIALIZE FIOBE00A-DATA-REC.                                
                                                                        
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 8500-WRITE-FCSCA135.                                          *         
      *****************************************************************         
       8500-WRITE-FCSCA135.                                             
      *                                                                         
           MOVE '8500'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           WRITE FIOCA135.                                              
                                                                        
           IF  FCSCA135-SUCCESSFUL                                      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY  '8500-ERROR ON FCSCA135 WRITE. STATUS IS '      
                         WS-FCSCA135-STATUS                             
               PERFORM  9900-ABEND               THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *   9000-TERMINATE.                                                       
      *                     CLOSES INPUT & OUTPUT FILES               *         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE '9000'                           TO WS-ACTIVE-PARAGRAPH.
                                                                        
           CLOSE FCSBE00-FILE.                                          
      *                                                                         
           IF FCSBE00-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSCA135 *************'             
              DISPLAY '** ERROR IN CLOSING FCSBE00 FILE **'             
              DISPLAY '** PARAGRAPH - '    WS-ACTIVE-PARAGRAPH          
              DISPLAY '** FILE STATUS IS ' WS-FBE00-STATUS              
              DISPLAY '** ABENDING PROGRAM              **'             
              DISPLAY '************ PCSCA135 *************'             
           END-IF.                                                      
      *                                                                         
           CLOSE FCSCA135-FILE.                                         
      *                                                                         
           IF FCSCA135-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSCA135 *************'             
              DISPLAY '** ERROR IN CLOSING FCSCA135 FILE **'            
              DISPLAY '** PARAGRAPH - '    WS-ACTIVE-PARAGRAPH          
              DISPLAY '** FILE STATUS IS ' WS-FCSCA135-STATUS           
              DISPLAY '** ABENDING PROGRAM              **'             
              DISPLAY '************ PCSCA135 *************'             
           END-IF.                                                      
      *                                                                         
           CLOSE FCSBE00A-FILE.                                         
      *                                                                         
           IF FBE00A-SUCCESSFUL                                         
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************ PCSCA135 *************'             
              DISPLAY '** ERROR IN CLOSING FCSBE00A FILE **'            
              DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH             
              DISPLAY '** FILE STATUS IS ' WS-FBE00A-STATUS             
              DISPLAY '** ABENDING PROGRAM              **'             
              DISPLAY '************ PCSCA135 *************'             
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE      *         
      * 9900-ABEND                                                    *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
