       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA130.                                      
COB303 DATE-WRITTEN.     SEP 18, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *-- THIS PROGRAM WILL REBUILD CSS_BLDR_NAME_TMP.               --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  09/18/2015    VK7L032     CONVERTED THE EAZYTRIVE PGM     --*        
ACT021*--                            CSR130 TO COBOL.                --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA130'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BLDR_NAME_TMP, 2M                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLDNAM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_BLDR_ADDR_XREF, X0                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLDADX                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUSTOMER, CU                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_NAME, DQ                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                             *           
       COPY CWS00010.                                                           
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-NAME-BLDN-NO           PIC X(100) VALUE SPACES.        
           05 WS-INSERT-COUNT           PIC 9(10)  VALUE ZEROES.        
      *                                                                         
       01 WS-SWITCHES.                                                  
           05 WS-BUILDER-STATUS         PIC X(01) VALUE 'N'.            
              88 NO-MORE-BUILDER-INFO             VALUE 'Y'.            
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-YES                    PIC X(01) VALUE 'Y'.            
      *                                                                         
      ******************************************************************        
      * THIS IS THE DRIVING CURSOR OF THIS PROGRAM FETCHING DETAILS    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DTLS_CSR CURSOR FOR                               
                SELECT DISTINCT                                         
                       CU.COMPANY_NO_ORIG,                              
                       X0.BLDR_CUST_NO,                                 
                       LTRIM(RTRIM(DQ.FULL_NAME)) + '-' + CIS.SUBSTR3$(
           CIS.DECIMAL2CHAR(X0.BLDR_CUST_NO), 2, 10)               
                  FROM CSS_BLDR_ADDR_XREF X0 WITH(READUNCOMMITTED),             
                       CSS_CUSTOMER CU WITH(READUNCOMMITTED),                   
                       CSS_NAME DQ WITH(READUNCOMMITTED)                        
                 WHERE CU.CUSTOMER_NO = X0.BLDR_CUST_NO                 
                   AND DQ.NAME_ID = CU.NAME_ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTLS_CSR CURSOR FOR                                       
MFA-TR*         SELECT DISTINCT                                                 
MFA-TR*                CU.COMPANY_NO_ORIG,                                      
MFA-TR*                X0.BLDR_CUST_NO,                                         
MFA-TR*                STRIP(DQ.FULL_NAME) || '-' ||                            
MFA-TR*                SUBSTR(CHAR(X0.BLDR_CUST_NO),2,10)                       
MFA-TR*           FROM CSS_BLDR_ADDR_XREF X0,                                   
MFA-TR*                CSS_CUSTOMER CU,                                         
MFA-TR*                CSS_NAME DQ                                              
MFA-TR*          WHERE CU.CUSTOMER_NO = X0.BLDR_CUST_NO                         
MFA-TR*            AND DQ.NAME_ID = CU.NAME_ID                                  
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 8000-DELETE-BLDR-NAME            THRU  8000-EXIT.    
           PERFORM 1000-PROCESS-CSR                 THRU  1000-EXIT.    
           PERFORM 9000-TERMINATE                   THRU  9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-PROCESS-CSR                                             **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-CSR.                                                
      *                                                                         
           PERFORM 7100-OPEN-DTLS-CSR               THRU  7100-EXIT.    
           PERFORM 7200-FETCH-DTLS-CSR              THRU  7200-EXIT.    
           PERFORM 2000-PROCESS-DTLS-CSR            THRU  2000-EXIT     
             UNTIL NO-MORE-BUILDER-INFO.                                
           DISPLAY 'ROWS INSERTED INTO TABLE CSS_BLDR_NAME_TMP:'        
                   WS-INSERT-COUNT.                                     
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS-CSR                                        **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS-CSR.                                           
      *                                                                         
           MOVE CU-COMPANY-NO-ORIG        TO 2M-COMPANY-NO.             
           MOVE X0-BLDR-CUST-NO           TO 2M-BLDR-CUST-NO.           
           MOVE WS-NAME-BLDN-NO           TO 2M-BLDR-NAME.              
           PERFORM 8100-INSERT-DTLS                 THRU 8100-EXIT.     
           PERFORM 7200-FETCH-DTLS-CSR              THRU 7200-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-DTLS-CSR.                                            *        
      ******************************************************************        
      *                                                                         
       7100-OPEN-DTLS-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN DTLS_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSCA130 ABORT ******'                  
              DISPLAY '**  7100-OPEN-DTLS-CSR      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-FETCH-DTLS-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7200-FETCH-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH DTLS_CSR                                            
               INTO :CU-COMPANY-NO-ORIG                                 
                   ,:X0-BLDR-CUST-NO                                    
                   ,:WS-NAME-BLDN-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES              TO WS-BUILDER-STATUS          
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******** PCSCA130 ABORT ******'                  
              DISPLAY '**  7200-FETCH-DTLS-CSR     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  CU.CUSTOMER_NO = ' CU-CUSTOMER-NO            
              DISPLAY '**  DQ.NAME_ID = ' DQ-NAME-ID                    
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-CLOSE-DTLS-CSR.                                           *        
      ******************************************************************        
      *                                                                         
       7300-CLOSE-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE DTLS_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSCA130 ABORT ******'                  
              DISPLAY '**  7300-CLOSE-DTLS-CSR     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED   **'                  
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8000-DELETE-BLDR-NAME                                       **        
      ******************************************************************        
      *                                                                         
       8000-DELETE-BLDR-NAME.                                           
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_BLDR_NAME_TMP                             
               WHERE BLDR_CUST_NO > 0                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSCA130 ABORT *****'                   
              DISPLAY '**  8000-DELETE-BLDR-NAME  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8100-INSERT-DTLS.                                           **        
      ******************************************************************        
      *                                                                         
        8100-INSERT-DTLS.                                               
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_BLDR_NAME_TMP                             
                     (                                                  
                      COMPANY_NO                                        
                     ,BLDR_NAME                                         
                     ,BLDR_CUST_NO                                      
                     )                                                  
              VALUES                                                    
                     (                                                  
                      :2M-COMPANY-NO                                    
                     ,:2M-BLDR-NAME                                     
                     ,:2M-BLDR-CUST-NO                                  
                     )                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD  +1                     TO WS-INSERT-COUNT            
           ELSE                                                         
              DISPLAY '******** PCSCA130 ABORT *****'                   
              DISPLAY '**8100-INSERT-DTLS         **'                   
              DISPLAY '**8500-INSERT-TRANS-HIST   **'                   
              DISPLAY '**RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '**PROCESSING TERMINATED    **'                   
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 9000-TERMINATE.                                              **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           PERFORM 7300-CLOSE-DTLS-CSR        THRU 7300-EXIT.           
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
