       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA129.                                          
       AUTHOR.       SJ94244.                                           
       DATE-WRITTEN. OCT 2009.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** EXTRACT A SAMPLE OF READY TO BILL SECURED / COMMERCIAL /     **        
      ** INDUSTRIAL ACCOUNTS AND ANY SPECIAL ACCOUNTS TO  USE FOR     **        
      ** REGRESSION AND WRITE TO OUTPUT FILE                          **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------  -------  ------                                     **        
AP1685** 10/2009  SJ94244  INITIAL IMPLEMENTATION.                    **        
AP1685** 06/2010  SJ94244  INCLUDED THE CHECK FOR MASTER ACCOUNT      **        
A02906** 11/2010  MC95456  PULL READY TO BILL ACCOUNTS WITH NON-EXPIRED*        
A02906**                   MASTER/DEPENDENT METER RELATIONSHIPS FROM  **        
A02906**                   CSS_UTL_BILL_REL                           **        
A04527** 07/2013  AS7C117  CHANGES TO CREATE OUTPUT FILE FCSCA129 WITH**        
A04527**          ACT101   80 BYTES                                   **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
      *--------------------*                                                    
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA129.                                                           
       COPY CSSCACTR.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA129.                                                           
       COPY FIOCA129.                                                           
       COPY CFDCACTR.                                                           
       COPY FIOCACTR.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA129'.
MSQ017     COPY MFASQLM.
      *-----------------------*                                                 
      *                                                                         
       01  WS-START                     PIC X(40)         VALUE         
                        'WORKING STORAGE FOR PCSCA129 STARTS HERE'.     
       01  WS-MISC.                                                     
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-WRITE-COUNT           PIC 9(07) VALUE ZEROS.          
           05  WS-RATE-COUNT            PIC 9(07) VALUE ZEROS.          
           05  WS-SPL-ACCT-COUNT        PIC 9(07) VALUE ZEROS.          
           05  WS-SPL-RATE-ACCT-COUNT   PIC 9(07) VALUE ZEROS.          
           05  WS-COMPANY-NO            PIC X(02) VALUE '01'.           
           05  WS-PREV-RATE             PIC X(03) VALUE SPACES.         
           05  WS-DELIMITER             PIC X(01) VALUE ','.            
           05  WS-INDEX                 PIC S9(04) COMP-3 VALUE +0.     
           05  WS-RECORD-COUNT          PIC S9(04) COMP   VALUE +0.     
A02906     05  WS-MASTER-COUNT          PIC S9(04) COMP   VALUE +0.     
           05  WS-OFF-CYL-ACCT-LIMIT    PIC S9(04) COMP VALUE +0.       
           05  WS-SPL-RATE-ACCT-LIMIT   PIC S9(04) COMP VALUE +0.       
A02906     05  WS-MST-MTR-ACCT-LIMIT    PIC S9(04) COMP VALUE +0.       
A02906     05  WS-DEP-REL-START-DT.                                     
A02906         10 WS-DEP-REL-START-YY   PIC X(04) VALUE SPACES.         
A02906         10 FILLER                PIC X(01) VALUE '-'.            
A02906         10 WS-DEP-REL-START-MM   PIC X(02) VALUE SPACES.         
A02906         10 FILLER                PIC X(01) VALUE '-'.            
A02906         10 WS-DEP-REL-START-DD   PIC X(02) VALUE '01'.           
A02906     05  WS-DEP-REL-END-DT.                                       
A02906         10 WS-DEP-REL-END-YY     PIC X(04) VALUE SPACES.         
A02906         10 FILLER                PIC X(01) VALUE '-'.            
A02906         10 WS-DEP-REL-END-MM     PIC X(02) VALUE SPACES.         
A02906         10 FILLER                PIC X(01) VALUE '-'.            
A02906         10 WS-DEP-REL-END-DD     PIC X(02) VALUE '28'.           
A02906     05  WS-ADDITIVE-STATELINE    PIC X(01) VALUE 'A'.            
           05  WS-PREV-CD-BILL-OFF-CYL  PIC X(01) VALUE SPACE.          
           05  WS-CSR-DATABASE          PIC X(03) VALUE 'CSR'.          
           05  WS-SEB-DATABASE          PIC X(03) VALUE 'SEB'.          
           05  WS-REGION                PIC X(04) VALUE SPACES.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
AP1685     05  WS-BILL-CYCLE-OPEN       PIC X(01) VALUE 'N'.            
AP1685     05  WS-MSTR-ACCT-BILL-CYCLE  PIC X(02) VALUE SPACES.         
AP1685     05  WS-REVENUE-MONTH-JP      PIC X(06).                      
           05  WS-FCA129-STATUS         PIC X(02) VALUE SPACES.         
               88 FIOCA129-SUCCESSFUL             VALUE '00'.           
           05  WS-FCACTR-STATUS         PIC X(02) VALUE SPACES.         
               88 FIOCACTR-SUCCESSFUL             VALUE '00'.           
           05  WS-DEL-FILENAME.                                         
               10  FILLER              PIC X(08) VALUE ' DELETE '.      
               10  WS-DEL-DBMS         PIC X(03).                       
               10  FILLER              PIC X(01) VALUE '.'.             
               10  WS-DEL-REGION       PIC X(04).                       
               10  FILLER              PIC X(04) VALUE '.CYC'.          
               10  WS-DEL-BILLCYC      PIC X(02).                       
               10  FILLER              PIC X(09) VALUE '.FCSCA129'.     
                                                                        
           05  WS-DEL-ACCTCOPY.                                         
               10  FILLER              PIC X(08) VALUE ' DELETE '.      
               10  WS-DEL-DBMS-ACCT    PIC X(03).                       
               10  FILLER              PIC X(01) VALUE '.'.             
               10  WS-DEL-REGION-ACCT  PIC X(04).                       
               10  FILLER              PIC X(04) VALUE '.CYC'.          
               10  WS-DEL-BILLCYC-ACCT PIC X(02).                       
               10  FILLER              PIC X(15) VALUE                  
                                                  '.CA129.ACCTCOPY'.    
                                                                        
           05  WS-DEL-FCSCA129.                                         
               10  FILLER              PIC X(08) VALUE ' DELETE '.      
               10  WS-DEL-DBMS-129     PIC X(03).                       
               10  FILLER              PIC X(01) VALUE '.'.             
               10  WS-DEL-REGION-129   PIC X(04).                       
               10  FILLER              PIC X(09) VALUE '.FCSCA129'.     
                                                                        
                                                                        
           05  WS-NEW-FILENAME.                                         
               10  FILLER              PIC X(09) VALUE                  
                                             ' NEWNAME('.               
               10  WS-NEW-DBMS         PIC X(03).                       
               10  FILLER              PIC X(01) VALUE '.'.             
               10  WS-NEW-REGION       PIC X(04).                       
               10  FILLER              PIC X(04) VALUE '.CYC'.          
               10  WS-NEW-BILLCYC      PIC X(02).                       
               10  FILLER              PIC X(10) VALUE '.FCSCA129)'.    
                                                                        
           05  WS-ALT-FILENAME.                                         
               10  FILLER              PIC X(07) VALUE ' ALTER '.       
               10  WS-ALT-DBMS         PIC X(03).                       
               10  FILLER              PIC X(01) VALUE '.'.             
               10  WS-ALT-REGION       PIC X(04).                       
               10  FILLER              PIC X(17) VALUE                  
                                              '.FCSCA129.SORT - '.      
                                                                        
           05  WS-NEW-ACCTCOPY.                                         
               10  FILLER              PIC X(09) VALUE                  
                                             ' NEWNAME('.               
               10  WS-NEW-DBMS-ACCT    PIC X(03).                       
               10  FILLER              PIC X(01) VALUE '.'.             
               10  WS-NEW-REGION-ACCT  PIC X(04).                       
               10  FILLER              PIC X(04) VALUE '.CYC'.          
               10  WS-NEW-BILLCYC-ACCT PIC X(02).                       
               10  FILLER              PIC X(16) VALUE                  
                                                 '.CA129.ACCTCOPY)'.    
           05  WS-ALT-ACCTCOPY.                                         
               10  FILLER              PIC X(07) VALUE ' ALTER '.       
               10  WS-ALT-DBMS-ACCT    PIC X(03).                       
               10  FILLER              PIC X(01) VALUE '.'.             
               10  WS-ALT-REGION-ACCT  PIC X(04).                       
               10  FILLER              PIC X(12) VALUE                  
                                              '.ACCTCOPY - '.           
      *                                                                         
       01  WS-MISC-ACCOUNT.                                             
           05  WS-PARSE-ACCT            PIC X(13) OCCURS 3 TIMES        
                                                          VALUE SPACES. 
       01  WS-MISC-RATE.                                                
           05  WS-PARSE-RATE            PIC X(03) OCCURS 5 TIMES        
                                                          VALUE SPACES. 
       01  WS-FLAGS.                                                    
           05  WS-ACCT-READY-TO-BILL    PIC X(01)         VALUE 'N'.    
               88 ACCT-READY-TO-BILL                      VALUE 'Y'.    
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-PROGRAM-NAME          PIC X(08) VALUE  'PCSCA129'.    
           05  WS-PGRMNAME              PIC X(08) VALUE  'PCSCA129'.    
                                                                        
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
                                                                        
      * ERROR MESSAGE COPYBOOK.                                                 
                                                                        
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
                                                                        
      * DB2 INCLUDES.                                                           
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00038                                                
           END-EXEC.                                                            
                                                                        
      *** BEWARE OF BELOW REDIFINITIONS, WHICH ARE LINK TO CWS00038             
                                                                        
       01  WS-OFF-CYL-ACCT REDEFINES WS-INPUT-DATA-BREAKDOWN.           
           10  WS-PARM-OFF-CYL-TEXT    PIC X(19).                       
               88  WS-OFF-CYL          VALUE 'NO-OF-OFF-CYL-ACCT='.     
           10  WS-NO-OFF-CYL-ACCT      PIC X(04).                       
           10  FILLER                  PIC X(57).                       
      *                                                                         
       01  WS-SPL-RTE-ACCT REDEFINES WS-INPUT-DATA-BREAKDOWN.           
           10  WS-PARM-SPL-RTE-TEXT    PIC X(19).                       
               88  WS-SPL-RTE          VALUE 'NO-OF-SPL-RTE-ACCT='.     
           10  WS-NO-SPL-RTE-ACCT      PIC X(04).                       
           10  FILLER                  PIC X(57).                       
      *                                                                         
A02906 01  WS-MST-MTR-ACCT REDEFINES WS-INPUT-DATA-BREAKDOWN.           
A02906     10  WS-MASTER-MTR-TEXT      PIC X(19).                       
A02906         88  WS-MST-MTR          VALUE 'NO-OF-MST-MTR-ACCT='.     
A02906     10  WS-NO-MST-MTR-ACCT      PIC X(04).                       
A02906     10  FILLER                  PIC X(57).                       
      *                                                                         
       01  WS-REGION       REDEFINES WS-INPUT-DATA-BREAKDOWN.           
           10  WS-PARM-REGION-TEXT     PIC X(07).                       
               88  WS-REG              VALUE 'REGION='.                 
           10  WS-REGION-TEXT          PIC X(04).                       
           10  FILLER                  PIC X(69).                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_ACCOUNT       - AT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BILL_WINDOW   - BN                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBBILWDW                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CODE_VALUE    - UV                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBCDVALU                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_OFF_CYCL_ACCT - OC                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBOFFCYL                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_UTIL_ENVRNMT  - UT                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      ******************************************************************        
      *  CSS_JOB_PARM      - G6                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_DELINQUENCY   - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
      *                                                                         
A02906******************************************************************        
A02906*  CSS_UTL_BILL_REL   - UR                                       *        
A02906******************************************************************        
A02906*                                                                         
A02906     EXEC SQL                                                             
A02906       INCLUDE TBUTLREL                                                   
A02906     END-EXEC.                                                            
      *                                                                         
      * DB2 CURSORS.                                                            
      *------------*                                                            
      *                                                                         
      ******************************************************************        
      *   BASE CURSOR TO GET ALL ACCOUNTS THAT ARE READY TO BILL  FOR  *        
      *   SECURED RATES                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE BASE_CSR CURSOR FOR                              
                SELECT AT.ACCOUNT_NO                                    
                      ,UT.RATE_PLAN_NO                                  
                      ,AT.BILL_CYCLE                                    
                  FROM CSS_ACCOUNT       AT WITH(READUNCOMMITTED)               
                      ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)               
                 WHERE AT.ACCOUNT_NO        = UT.ACCOUNT_NO             
                   AND AT.CODE_ACCT_STAT    = 'A'                       
                   AND AT.CODE_ACCT_BILLED  = 'R'                       
                   AND AT.BILL_CYCLE  IN                                
                           (SELECT BN.BILL_CYCLE                        
                              FROM CSS_BILL_WINDOW BN
                           WITH(READUNCOMMITTED)                   
                             WHERE BN.DATE_EXTRACT = 
              IIF(TRY_CONVERT(DATE, :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) ))  
                   AND UT.RATE_PLAN_NO IN                               
                           (SELECT RD.RATE_PLAN_NO                      
                              FROM CSS_RATE_PLAN_DESC RD
                           WITH(READUNCOMMITTED)                
                             WHERE RD.SECURED_RATE_FL = 'Y'             
                               AND RD.CODE_UTIL_TYPE  =                 
                                                  UT.CODE_UTIL_TYPE)    
                   AND AT.CODE_COMPANY_ACCT <> 'B'                      
                   AND AT.MST_SUB_ACCT_IND  = ' '                       
                 ORDER BY 2,1                                           
                   FOR READ ONLY                                
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE BASE_CSR CURSOR FOR                                      
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*               ,UT.RATE_PLAN_NO                                          
MFA-TR*               ,AT.BILL_CYCLE                                            
MFA-TR*           FROM CSS_ACCOUNT       AT                                     
MFA-TR*               ,CSS_UTIL_ENVRNMT  UT                                     
MFA-TR*          WHERE AT.ACCOUNT_NO        = UT.ACCOUNT_NO                     
MFA-TR*            AND AT.CODE_ACCT_STAT    = 'A'                               
MFA-TR*            AND AT.CODE_ACCT_BILLED  = 'R'                               
MFA-TR*            AND AT.BILL_CYCLE  IN                                        
MFA-TR*                    (SELECT BN.BILL_CYCLE                                
MFA-TR*                       FROM CSS_BILL_WINDOW BN                           
MFA-TR*                      WHERE BN.DATE_EXTRACT = :BN-DATE-EXTRACT)          
MFA-TR*            AND UT.RATE_PLAN_NO IN                                       
MFA-TR*                    (SELECT RD.RATE_PLAN_NO                              
MFA-TR*                       FROM CSS_RATE_PLAN_DESC RD                        
MFA-TR*                      WHERE RD.SECURED_RATE_FL = 'Y'                     
MFA-TR*                        AND RD.CODE_UTIL_TYPE  =                         
MFA-TR*                                           UT.CODE_UTIL_TYPE)            
MFA-TR*            AND AT.CODE_COMPANY_ACCT <> 'B'                              
MFA-TR*            AND AT.MST_SUB_ACCT_IND  = ' '                               
MFA-TR*          ORDER BY 2,1                                                   
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO GET ACCOUNTS WITH BILL OFF CYCLE CODE AS B,L,O,R   *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE OFF_CYCLE_CSR CURSOR FOR                         
                SELECT ACCOUNT_NO                                       
                      ,CODE_BILL_OFF_CYCL                               
                  FROM CSS_OFF_CYCL_ACCT WITH(READUNCOMMITTED)                  
                 WHERE CODE_BILL_OFF_CYCL IN ('B', 'L', 'O', 'R')       
                 ORDER BY CODE_BILL_OFF_CYCL ASC                        
                   FOR READ ONLY                                
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFF_CYCLE_CSR CURSOR FOR                                 
MFA-TR*         SELECT ACCOUNT_NO                                               
MFA-TR*               ,CODE_BILL_OFF_CYCL                                       
MFA-TR*           FROM CSS_OFF_CYCL_ACCT                                        
MFA-TR*          WHERE CODE_BILL_OFF_CYCL IN ('B', 'L', 'O', 'R')               
MFA-TR*          ORDER BY CODE_BILL_OFF_CYCL ASC                                
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO GET SPECIAL ACCOUNTS AND RATES FROM CSS_CODE_VALUE *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE CODE_VAL_CSR CURSOR FOR                          
                SELECT CODE_LONG_DESC                                   
                  FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                     
                 WHERE TABLE_NA   = :UV-TABLE-NA                        
                   AND PROGRAM_ID = :UV-PROGRAM-ID                      
                   AND COMPANY_NO = :UV-COMPANY-NO                      
                   AND COLUMN_NA  = :UV-COLUMN-NA                       
                   FOR READ ONLY                                
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CODE_VAL_CSR CURSOR FOR                                  
MFA-TR*         SELECT CODE_LONG_DESC                                           
MFA-TR*           FROM CSS_CODE_VALUE                                           
MFA-TR*          WHERE TABLE_NA   = :UV-TABLE-NA                                
MFA-TR*            AND PROGRAM_ID = :UV-PROGRAM-ID                              
MFA-TR*            AND COMPANY_NO = :UV-COMPANY-NO                              
MFA-TR*            AND COLUMN_NA  = :UV-COLUMN-NA                               
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO GET, READY TO BILL ACCOUNTS OF SPECIAL RATES       *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE RATE_CSR CURSOR FOR                              
                SELECT AT.ACCOUNT_NO                                    
                  FROM CSS_ACCOUNT       AT WITH(READUNCOMMITTED)               
                      ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)               
                 WHERE AT.ACCOUNT_NO        = UT.ACCOUNT_NO             
                   AND AT.CODE_ACCT_STAT    = 'A'                       
                   AND AT.CODE_ACCT_BILLED  = 'R'                       
                   AND AT.CODE_COMPANY_ACCT <> 'B'                      
                   AND AT.MST_SUB_ACCT_IND  = ' '                       
                   AND AT.BILL_CYCLE  IN                                
                           (SELECT BN.BILL_CYCLE                        
                              FROM CSS_BILL_WINDOW BN
                           WITH(READUNCOMMITTED)                   
                             WHERE BN.DATE_EXTRACT = 
              IIF(TRY_CONVERT(DATE, :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) ))  
                   AND UT.RATE_PLAN_NO      = :UT-RATE-PLAN-NO          
                   FOR READ ONLY                                
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_CSR CURSOR FOR                                      
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*           FROM CSS_ACCOUNT       AT                                     
MFA-TR*               ,CSS_UTIL_ENVRNMT  UT                                     
MFA-TR*          WHERE AT.ACCOUNT_NO        = UT.ACCOUNT_NO                     
MFA-TR*            AND AT.CODE_ACCT_STAT    = 'A'                               
MFA-TR*            AND AT.CODE_ACCT_BILLED  = 'R'                               
MFA-TR*            AND AT.CODE_COMPANY_ACCT <> 'B'                              
MFA-TR*            AND AT.MST_SUB_ACCT_IND  = ' '                               
MFA-TR*            AND AT.BILL_CYCLE  IN                                        
MFA-TR*                    (SELECT BN.BILL_CYCLE                                
MFA-TR*                       FROM CSS_BILL_WINDOW BN                           
MFA-TR*                      WHERE BN.DATE_EXTRACT = :BN-DATE-EXTRACT)          
MFA-TR*            AND UT.RATE_PLAN_NO      = :UT-RATE-PLAN-NO                  
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*          QUERYNO 7500                                                   
MFA-TR*    END-EXEC.                                                            
A02906******************************************************************        
A02906*   CURSOR TO GET  READY TO BILL MASTER ACCOUNTS        *                 
A02906******************************************************************        
A02906     EXEC SQL                                                     
A02906         DECLARE MASTER_CSR CURSOR FOR                            
A02906          SELECT DISTINCT(ACCOUNT_NO_MST)                         
A02906             FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)               
A02906                 ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
A02906            WHERE UR.DEP_REL_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )   
A02906              AND UR.DEP_REL_END_DT     >= IIF(TRY_CONVERT(DATE, 
                                                     :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )     
A02906              AND UR.CODE_RELATION_TYPE <> :WS-ADDITIVE-STATELINE 
A02906              AND AT.ACCOUNT_NO          = UR.ACCOUNT_NO_MST      
A02906              AND AT.CODE_ACCT_STAT      = 'A'                    
A02906              AND AT.CODE_ACCT_BILLED    = 'R'                    
A02906              AND AT.BILL_CYCLE  IN                               
A02906                  (SELECT BN.BILL_CYCLE                           
A02906                   FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)          
A02906                   WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) ))      
A02906            FOR READ ONLY                                 
A02906                                                      
A02906     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MASTER_CSR CURSOR FOR                                    
MFA-TR*         SELECT DISTINCT(ACCOUNT_NO_MST)                                 
MFA-TR*            FROM CSS_UTL_BILL_REL UR                                     
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*           WHERE UR.DEP_REL_START_DT   <= :UR-DEP-REL-START-DT           
MFA-TR*             AND UR.DEP_REL_END_DT     >= :UR-DEP-REL-END-DT             
MFA-TR*             AND UR.CODE_RELATION_TYPE <> :WS-ADDITIVE-STATELINE         
MFA-TR*             AND AT.ACCOUNT_NO          = UR.ACCOUNT_NO_MST              
MFA-TR*             AND AT.CODE_ACCT_STAT      = 'A'                            
MFA-TR*             AND AT.CODE_ACCT_BILLED    = 'R'                            
MFA-TR*             AND AT.BILL_CYCLE  IN                                       
MFA-TR*                 (SELECT BN.BILL_CYCLE                                   
MFA-TR*                  FROM CSS_BILL_WINDOW BN                                
MFA-TR*                  WHERE BN.DATE_EXTRACT = :BN-DATE-EXTRACT)              
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*          QUERYNO 7560                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
A02906******************************************************************        
A02906*   CURSOR TO GET  READY TO BILL DEPENDENT METER ACCOUNTS        *        
A02906******************************************************************        
A02906     EXEC SQL                                                     
A02906         DECLARE DEPENDENT_CSR CURSOR FOR                         
A02906          SELECT DISTINCT(ACCOUNT_NO_DEP)                         
A02906            FROM CSS_UTL_BILL_REL UR WITH(READUNCOMMITTED)                
A02906                ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
A02906           WHERE UR.ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST      
A02906             AND UR.DEP_REL_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                   :UR-DEP-REL-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-START-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-START-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-START-DT
              ), CONVERT(DATE, :UR-DEP-REL-START-DT) )    
A02906             AND UR.DEP_REL_END_DT     >= IIF(TRY_CONVERT(DATE, 
                                                     :UR-DEP-REL-END-DT
              ) IS NULL OR (PATINDEX('%.%', :UR-DEP-REL-END-DT
              ) <> 0) OR (LEN(:UR-DEP-REL-END-DT
              ) <> 10), CIS.CHAR2DATE(:UR-DEP-REL-END-DT
              ), CONVERT(DATE, :UR-DEP-REL-END-DT) )      
A02906           FOR READ ONLY                                  
A02906                                                      
A02906     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE DEPENDENT_CSR CURSOR FOR                                 
MFA-TR*         SELECT DISTINCT(ACCOUNT_NO_DEP)                                 
MFA-TR*           FROM CSS_UTL_BILL_REL UR                                      
MFA-TR*               ,CSS_ACCOUNT AT                                           
MFA-TR*          WHERE UR.ACCOUNT_NO_MST      = :UR-ACCOUNT-NO-MST              
MFA-TR*            AND UR.DEP_REL_START_DT   <= :UR-DEP-REL-START-DT            
MFA-TR*            AND UR.DEP_REL_END_DT     >= :UR-DEP-REL-END-DT              
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7580                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
                                                                        
       01  WS-END                          PIC X(40)      VALUE         
                       'WORKING STORAGE FOR PCSCA129 ENDS HERE  '.      
                                                                        
       PROCEDURE DIVISION.                                              
      *------------------*                                                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION         THRU  0100-EXIT.        
           PERFORM  1000-PROCESS-INPUT          THRU  1000-EXIT.        
           PERFORM  2000-PROCESS-OUTPUT         THRU  2000-EXIT.        
           PERFORM  9000-TERMINATE              THRU  9000-EXIT.        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      * OPEN OUTPUT FILE                                               *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSCA129-FILE.                                   
            IF NOT FIOCA129-SUCCESSFUL                                  
               DISPLAY '********** PCSCA129 ABORT  ************'        
               DISPLAY '**  0100-INITIALIZATION               *'        
               DISPLAY '**  ERROR OPENING FCSCA129            *'        
               DISPLAY '**  FILE STATUS = ' WS-FCA129-STATUS            
               DISPLAY '********** PCSCA129 ABORT  ************'        
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
            END-IF.                                                     
           OPEN OUTPUT FCSCACTR-FILE.                                   
            IF NOT FIOCACTR-SUCCESSFUL                                  
               DISPLAY '********** PCSCA129 ABORT  ************'        
               DISPLAY '**  0100-INITIALIZATION               *'        
               DISPLAY '**  ERROR OPENING FCSCACTR            *'        
               DISPLAY '**  FILE STATUS = ' WS-FCACTR-STATUS            
               DISPLAY '********** PCSCA129 ABORT  ************'        
               PERFORM 9900-ABEND     THRU 9900-EXIT                    
            END-IF.                                                     
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      * PERFORMS INPUT PROCESS                                         *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 6240-GET-FCA00-COMMON-DATE  THRU 6240-EXIT.          
           MOVE WS-FCA00-COMMON-DATE           TO BN-DATE-EXTRACT.      
                                                                        
AP1685* GET THE COMMON REVENUE MONTH                                            
AP1685     PERFORM 1050-GET-COMMON-REVENUE-MTH THRU 1050-EXIT.          
                                                                        
           PERFORM 7000-GET-BILL-CYCLE         THRU 7000-EXIT.          
           MOVE BN-BILL-CYCLE                  TO AT-BILL-CYCLE         
                                                  WS-NEW-BILLCYC        
                                                  WS-DEL-BILLCYC        
                                                  WS-DEL-BILLCYC-ACCT   
                                                  WS-NEW-BILLCYC-ACCT.  
                                                                        
           DISPLAY '*COMMON DATE  ' BN-DATE-EXTRACT.                    
           DISPLAY '*BILL CYCLE ' AT-BILL-CYCLE.                        
           MOVE  'DATABASE'                    TO C8-DELINQ-CD.         
           PERFORM 7700-GET-DATABASE           THRU 7700-EXIT.          
           IF C8-DELINQ-VALUE = 1                                       
              MOVE WS-CSR-DATABASE             TO WS-NEW-DBMS           
                                                  WS-DEL-DBMS           
                                                  WS-ALT-DBMS           
                                                  WS-DEL-DBMS-ACCT      
                                                  WS-DEL-DBMS-129       
                                                  WS-NEW-DBMS-ACCT      
                                                  WS-ALT-DBMS-ACCT      
           ELSE                                                         
              MOVE WS-SEB-DATABASE             TO WS-NEW-DBMS           
                                                  WS-DEL-DBMS           
                                                  WS-ALT-DBMS           
                                                  WS-DEL-DBMS-ACCT      
                                                  WS-DEL-DBMS-129       
                                                  WS-NEW-DBMS-ACCT      
                                                  WS-ALT-DBMS-ACCT      
           END-IF.                                                      
           MOVE 0                              TO C8-DELINQ-VALUE.      
                                                                        
      *SET THE DEFAULT LIMIT TO 5                                               
                                                                        
           MOVE 5 TO WS-OFF-CYL-ACCT-LIMIT                              
                     WS-SPL-RATE-ACCT-LIMIT                             
A02906               WS-MST-MTR-ACCT-LIMIT.                             
      *GET THE REGION AND LIMITS FOR THE SPECIAL RATE AND OFF CYL ACCT          
      *FROM CSS_JOB_PARM                                                        
                                                                        
           MOVE WS-PGRMNAME            TO WS-PROGRAM                    
           MOVE WS-PARM                TO WS-COMMAND                    
           MOVE ZEROES                 TO WS-SEQUENCE                   
           MOVE WS-KEY-AREA            TO E-FJC01-KEY                   
           PERFORM 7600-START-FCSJC01           THRU 7600-EXIT          
           PERFORM 7610-READ-FCSJC01            THRU 7610-EXIT          
           PERFORM 1100-GET-PARM-DATA           THRU 1100-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
AP1685******************************************************************        
AP1685*1050-GET-COMMON-REVENUE-MTH.                                    *        
AP1685*GETS THE COMMON REVENUE MONTH                                   *        
AP1685******************************************************************        
AP1685 1050-GET-COMMON-REVENUE-MTH.                                     
AP1685*                                                                         
AP1685* GET COMMON REVENUE MONTH                                                
AP1685     MOVE SPACES                   TO WS-SYSIPT.                  
AP1685     MOVE 'COMMON'                 TO WS-PROGRAM.                 
AP1685     MOVE WS-DATE                  TO WS-COMMAND.                 
AP1685     MOVE ZEROS                    TO WS-SEQUENCE.                
AP1685     MOVE WS-KEY-AREA              TO E-FJC01-KEY.                
AP1685                                                                  
AP1685     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
AP1685                                                                  
AP1685     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
AP1685         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
AP1685            OR  END-OF-SYSIPT.                                    
AP1685                                                                  
AP1685     EVALUATE TRUE                                                
AP1685        WHEN END-OF-SYSIPT                                        
AP1685           DISPLAY '*********************************'            
AP1685           DISPLAY '** 1050-GET-COMMON-REVENUE-MTH **'            
AP1685           DISPLAY '**  PCSCA129 PROCESSING ERROR  **'            
AP1685           DISPLAY '**    NO ACTIVE REVENUE MONTH  **'            
AP1685           DISPLAY '**     PROCESSING TERMINATED   **'            
AP1685           DISPLAY '*********************************'            
AP1685           PERFORM 9900-ABEND    THRU  9900-EXIT                  
AP1685        WHEN OTHER                                                
AP1685           PERFORM 7611-CLOSE    THRU 7611-EXIT                   
AP1685     END-EVALUATE.                                                
AP1685                                                                  
AP1685     MOVE WS-REVENUE-MONTH-PARM    TO WS-REVENUE-MONTH-JP.        
AP1685                                                                  
AP1685 1050-EXIT.                                                       
AP1685     EXIT.                                                        
AP1685*                                                                         
      ******************************************************************        
      *1100-GET-PARM-DATA                                              *        
      *GETS THE NO OF ACCTS LIMIT AND REGION DETAILS FROM JOB PARM     *        
      *****************************************************************         
       1100-GET-PARM-DATA.                                              
                                                                        
           PERFORM UNTIL END-OF-SYSIPT                                  
              IF INPUT-ACTIVE                                           
                 EVALUATE TRUE                                          
                    WHEN WS-OFF-CYL                                     
                      MOVE WS-NO-OFF-CYL-ACCT TO WS-OFF-CYL-ACCT-LIMIT  
                      MOVE SPACES             TO WS-PARM-OFF-CYL-TEXT   
                                                                        
                    WHEN WS-SPL-RTE                                     
                      MOVE WS-NO-SPL-RTE-ACCT TO WS-SPL-RATE-ACCT-LIMIT 
                      MOVE SPACES             TO WS-PARM-SPL-RTE-TEXT   
                                                                        
A02906              WHEN WS-MST-MTR                                     
A02906                MOVE WS-NO-MST-MTR-ACCT TO WS-MST-MTR-ACCT-LIMIT  
A02906                MOVE SPACES             TO WS-MASTER-MTR-TEXT     
                                                                        
                    WHEN WS-REG                                         
                      MOVE WS-REGION-TEXT     TO WS-DEL-REGION          
                                                 WS-NEW-REGION          
                                                 WS-ALT-REGION          
                                                 WS-DEL-REGION-ACCT     
                                                 WS-DEL-REGION-129      
                                                 WS-NEW-REGION-ACCT     
                                                 WS-ALT-REGION-ACCT     
                                                                        
                      MOVE SPACES             TO WS-PARM-REGION-TEXT    
                    WHEN OTHER                                          
                      CONTINUE                                          
                 END-EVALUATE                                           
              END-IF                                                    
              PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT           
           END-PERFORM.                                                 
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      * PERFORMS OUTPUT PROCESS                                        *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7100-OPEN-BASE-CURSOR       THRU 7100-EXIT.          
           PERFORM 7130-FETCH-BASE-CURSOR      THRU 7130-EXIT.          
           PERFORM 2100-PROCESS-BASE-CURSOR    THRU 2100-EXIT           
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
           PERFORM 7150-CLOSE-BASE-CURSOR      THRU 7150-EXIT.          
                                                                        
           IF WS-WRITE-COUNT > 0                                        
              DISPLAY '*SECURED RATES AND ACCOUNTS EXTRACTED*'          
           END-IF.                                                      
                                                                        
           PERFORM 7200-OPEN-OFF-CYL-CURSOR    THRU 7200-EXIT.          
           PERFORM 7230-FETCH-OFF-CYL-CURSOR   THRU 7230-EXIT.          
           PERFORM 2200-PROCESS-OFF-CYL-CURSOR THRU 2200-EXIT           
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
           PERFORM 7250-CLOSE-OFF-CYL-CURSOR   THRU 7250-EXIT.          
                                                                        
      * FOR SPECIAL ACCOUNTS                                                    
           PERFORM  2300-PROCESS-SPECIAL-ACCTS THRU 2300-EXIT.          
           IF WS-SPL-ACCT-COUNT > 0                                     
              DISPLAY '*SPECIAL ACCOUNTS EXTRACTED*'                    
           END-IF.                                                      
      * FOR SPECIAL RATES                                                       
           PERFORM  2600-PROCESS-SPECIAL-RATES THRU 2600-EXIT.          
           IF WS-SPL-RATE-ACCT-COUNT > 0                                
              DISPLAY '*ACCOUNTS OF SPECIAL RATES EXTRACTED*'           
           END-IF.                                                      
A02906* FOR MASTER/DEPENDENT METER RELATIONSHIP START AND END DATES             
A02906     MOVE WS-REVENUE-MONTH-JP(1:4)         TO WS-DEP-REL-START-YY 
A02906                                              WS-DEP-REL-END-YY.  
A02906     MOVE WS-REVENUE-MONTH-JP(5:2)         TO WS-DEP-REL-START-MM 
A02906                                              WS-DEP-REL-END-MM.  
A02906     MOVE WS-DEP-REL-START-DT              TO UR-DEP-REL-START-DT.
A02906     MOVE WS-DEP-REL-END-DT                TO UR-DEP-REL-END-DT.  
A02906* FOR MASTER METER ACCOUNTS                                               
A02906     PERFORM 7560-OPEN-MASTER-CURSOR       THRU 7560-EXIT.        
A02906     PERFORM 7565-FETCH-MASTER-CURSOR      THRU 7565-EXIT.        
A02906     PERFORM 2910-PROCESS-MASTER-CURSOR    THRU 2910-EXIT         
A02906              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
A02906     PERFORM 7570-CLOSE-MASTER-CURSOR      THRU 7570-EXIT.        
      *                                                                         
A02906     IF WS-MASTER-COUNT > 0                                       
A02906       DISPLAY '*NO.OF MASTER METER ACCOUNTS EXTRACTED* '         
A02906                                       WS-MASTER-COUNT            
A02906     END-IF.                                                      
      *                                                                         
           IF WS-WRITE-COUNT < 1                                        
              DISPLAY '*NO RECORDS FOUND MATCHING THE CRITERIA*'        
           END-IF.                                                      
                                                                        
           PERFORM 8100-WRITE-FIOCACTR         THRU 8100-EXIT.          
           DISPLAY '*TOTAL NUMBER OF RECORDS WRITTEN '                  
                                                 WS-WRITE-COUNT.        
                                                                        
           DISPLAY '*PCSCA129 SUCCESSFULLY COMPLETED*'.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-BASE-CURSOR                                       *        
      * PROCESS FETCH AND WRITES ACCOUNTS FOR EACH RATE PLAN           *        
      ******************************************************************        
       2100-PROCESS-BASE-CURSOR.                                        
                                                                        
           INITIALIZE  FIOCA129.                                        
           IF UT-RATE-PLAN-NO NOT = WS-PREV-RATE                        
              MOVE  UT-RATE-PLAN-NO       TO WS-PREV-RATE               
              MOVE 1                      TO WS-RATE-COUNT              
              MOVE AT-ACCOUNT-NO          TO E-FIOCA129-ACCOUNT-NO      
              PERFORM 8000-WRITE-FILE     THRU 8000-EXIT                
           ELSE                                                         
              IF WS-RATE-COUNT  = WS-SPL-RATE-ACCT-LIMIT                
                 CONTINUE                                               
              ELSE                                                      
                 ADD 1                    TO WS-RATE-COUNT              
                 MOVE AT-ACCOUNT-NO       TO E-FIOCA129-ACCOUNT-NO      
                 PERFORM 8000-WRITE-FILE  THRU 8000-EXIT                
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7130-FETCH-BASE-CURSOR THRU 7130-EXIT.               
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-OFF-CYL-CURSOR                                    *        
      * PERFORMS FETCH AND WRITE ACCOUNTS TO OUTPUT FILE BASED ON THE  *        
      * NUMBER OF ACCOUNT LIMIT GIVEN IN THE DELINQUENCY VALUE         *        
      ******************************************************************        
       2200-PROCESS-OFF-CYL-CURSOR.                                     
                                                                        
           INITIALIZE  FIOCA129.                                        
           IF OC-CODE-BILL-OFF-CYCL NOT = WS-PREV-CD-BILL-OFF-CYL       
              MOVE 1                     TO WS-RECORD-COUNT             
              MOVE OC-CODE-BILL-OFF-CYCL TO WS-PREV-CD-BILL-OFF-CYL     
              MOVE OC-ACCOUNT-NO         TO E-FIOCA129-ACCOUNT-NO       
              PERFORM 8000-WRITE-FILE    THRU 8000-EXIT                 
           ELSE                                                         
              IF WS-RECORD-COUNT = WS-OFF-CYL-ACCT-LIMIT                
                 CONTINUE                                               
              ELSE                                                      
                 ADD  1 TO WS-RECORD-COUNT                              
                 MOVE OC-ACCOUNT-NO      TO E-FIOCA129-ACCOUNT-NO       
                 PERFORM 8000-WRITE-FILE THRU 8000-EXIT                 
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7230-FETCH-OFF-CYL-CURSOR THRU 7230-EXIT.            
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-PROCESS-SPECIAL-ACCTS                                     *        
      * PROCESS FOR EXTRACTING AND WRITING SPECIAL ACCOUNTS            *        
      ******************************************************************        
       2300-PROCESS-SPECIAL-ACCTS.                                      
                                                                        
           MOVE 'XTRCT_ACCT_NO'                TO UV-TABLE-NA-TEXT      
                                                  UV-COLUMN-NA-TEXT.    
           MOVE +13                            TO UV-TABLE-NA-LEN       
                                                  UV-COLUMN-NA-LEN.     
           MOVE WS-PROGRAM-NAME                TO UV-PROGRAM-ID.        
           MOVE WS-COMPANY-NO                  TO UV-COMPANY-NO.        
           MOVE 0                              TO AT-ACCOUNT-NO         
           PERFORM 7300-OPEN-CODVAL-CURSOR     THRU 7300-EXIT.          
           PERFORM 7330-FETCH-CODVAL-CURSOR    THRU 7330-EXIT.          
           PERFORM 2400-PROCESS-BILL-ACCTS     THRU 2400-EXIT           
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
           PERFORM 7350-CLOSE-CODVAL-CURSOR    THRU 7350-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-PROCESS-BILL-ACCTS                                        *        
      * PERFORMS FETCH CODE VALUE CURSOR AND WRITE BILLED ACCOUNTS     *        
      ******************************************************************        
       2400-PROCESS-BILL-ACCTS.                                         
                                                                        
           INITIALIZE  WS-MISC-ACCOUNT                                  
                       WS-INDEX.                                        
           UNSTRING            UV-CODE-LONG-DESC-TEXT                   
           DELIMITED BY        WS-DELIMITER                             
           INTO                WS-PARSE-ACCT(1)                         
                               WS-PARSE-ACCT(2)                         
                               WS-PARSE-ACCT(3)                         
           PERFORM 2500-PARSE-BILL-ACCTS     THRU 2500-EXIT             
                 UNTIL  WS-INDEX = 3                                    
           MOVE SPACES                       TO UV-CODE-LONG-DESC-TEXT. 
           MOVE 0                            TO UV-CODE-LONG-DESC-LEN.  
           PERFORM 7330-FETCH-CODVAL-CURSOR  THRU 7330-EXIT.            
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2500-PARSE-BILL-ACCTS                                          *        
      * CHECKS WHETHER ACCOUNTS ARE FINAL BILLED AND WRITES TO OUTPUT  *        
      ******************************************************************        
       2500-PARSE-BILL-ACCTS.                                           
                                                                        
           INITIALIZE  FIOCA129.                                        
           MOVE 0                            TO AT-ACCOUNT-NO.          
           ADD 1  TO  WS-INDEX.                                         
           MOVE WS-PARSE-ACCT(WS-INDEX)      TO AT-ACCOUNT-NO.          
           IF WS-PARSE-ACCT(WS-INDEX)  > SPACES                         
AP1685        MOVE SPACES                    TO WS-MSTR-ACCT-BILL-CYCLE 
AP1685        MOVE WS-REVENUE-MONTH-JP       TO AT-REV-MTH-LST-NRML     
AP1685        PERFORM 7410-CHECK-FOR-MASTER-ACCT                        
AP1685                                          THRU 7410-EXIT          
AP1685        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
AP1685           MOVE WS-MSTR-ACCT-BILL-CYCLE                           
AP1685                                       TO BN-BILL-CYCLE           
AP1685           MOVE 'N'                    TO WS-BILL-CYCLE-OPEN      
AP1685           PERFORM 7420-CHECK-BILL-CYCLE-OPEN                     
AP1685                                          THRU 7420-EXIT          
AP1685           IF WS-BILL-CYCLE-OPEN = 'Y'                            
AP1685              MOVE WS-PARSE-ACCT(WS-INDEX)                        
AP1685                                       TO E-FIOCA129-ACCOUNT-NO   
AP1685              ADD 1                    TO WS-SPL-ACCT-COUNT       
AP1685              PERFORM 8000-WRITE-FILE     THRU 8000-EXIT          
AP1685           END-IF                                                 
AP1685        ELSE                                                      
AP1685           MOVE 'N'                    TO WS-ACCT-READY-TO-BILL   
AP1685           PERFORM 7400-CHECK-BILL-ACCTS  THRU 7400-EXIT          
AP1685           IF ACCT-READY-TO-BILL                                  
AP1685              MOVE WS-PARSE-ACCT(WS-INDEX)                        
AP1685                                       TO E-FIOCA129-ACCOUNT-NO   
AP1685              ADD 1 TO WS-SPL-ACCT-COUNT                          
AP1685              PERFORM 8000-WRITE-FILE     THRU 8000-EXIT          
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2600-PROCESS-SPECIAL-RATES                                     *        
      * PROCESS FOR GETTING SPECIAL RATES                              *        
      ******************************************************************        
       2600-PROCESS-SPECIAL-RATES.                                      
                                                                        
           MOVE 'XTRCT_RATE_PLAN'              TO UV-TABLE-NA-TEXT      
                                                  UV-COLUMN-NA-TEXT.    
           MOVE +15                            TO UV-TABLE-NA-LEN       
                                                  UV-COLUMN-NA-LEN.     
           MOVE WS-PROGRAM-NAME                TO UV-PROGRAM-ID.        
           MOVE WS-COMPANY-NO                  TO UV-COMPANY-NO.        
           MOVE 0                              TO AT-ACCOUNT-NO         
           PERFORM 7300-OPEN-CODVAL-CURSOR     THRU 7300-EXIT.          
           PERFORM 7330-FETCH-CODVAL-CURSOR    THRU 7330-EXIT.          
           PERFORM 2700-PROCESS-RATES-ACCTS    THRU 2700-EXIT           
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
           PERFORM 7350-CLOSE-CODVAL-CURSOR    THRU 7350-EXIT.          
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2700-PROCESS-RATES-ACCTS                                       *        
      * PROCESS FETCH CODE VALUE CURSOR TO GET SPECIAL RATES AND       *        
      * PROCESS ACCOUNTS FOR EACH RATE                                 *        
      ******************************************************************        
       2700-PROCESS-RATES-ACCTS.                                        
                                                                        
           INITIALIZE WS-MISC-RATE                                      
                      WS-INDEX.                                         
           UNSTRING            UV-CODE-LONG-DESC-TEXT                   
           DELIMITED BY        WS-DELIMITER                             
           INTO                WS-PARSE-RATE(1)                         
                               WS-PARSE-RATE(2)                         
                               WS-PARSE-RATE(3)                         
                               WS-PARSE-RATE(4)                         
                               WS-PARSE-RATE(5)                         
           PERFORM 2800-GET-RATES-ACCOUNTS   THRU 2800-EXIT             
                                         UNTIL  WS-INDEX = 5.           
           MOVE SPACES                       TO UV-CODE-LONG-DESC-TEXT. 
           MOVE 0                            TO UV-CODE-LONG-DESC-LEN.  
           PERFORM 7330-FETCH-CODVAL-CURSOR  THRU 7330-EXIT.            
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2800-GET-RATES-ACCOUNTS                                        *        
      * GETS ACCOUNTS FOR EACH OF SPECIAL RATES AND WRITES TO OUTPUT   *        
      ******************************************************************        
       2800-GET-RATES-ACCOUNTS.                                         
                                                                        
           MOVE SPACES                         TO UT-RATE-PLAN-NO.      
           MOVE 0                              TO WS-RECORD-COUNT.      
           ADD 1  TO  WS-INDEX.                                         
           MOVE WS-PARSE-RATE(WS-INDEX)        TO UT-RATE-PLAN-NO.      
                                                                        
           IF WS-PARSE-RATE(WS-INDEX)  > SPACES                         
              PERFORM 7500-OPEN-RATE-CURSOR    THRU 7500-EXIT           
              PERFORM 7530-FETCH-RATE-CURSOR   THRU 7530-EXIT           
              PERFORM 2900-PROCESS-RATE-CURSOR THRU 2900-EXIT           
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                
                    WS-RECORD-COUNT = WS-SPL-RATE-ACCT-LIMIT            
              PERFORM 7550-CLOSE-RATE-CURSOR   THRU 7550-EXIT           
           END-IF.                                                      
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2900-PROCESS-RATE-CURSOR                                       *        
      * PERFORMS FETCH AND WRITE ACCOUNTS TO OUTPUT FILE BASED ON THE  *        
      * NUMBER OF ACCOUNT LIMIT GIVEN IN THE DELINQUENCY VALUE         *        
      ******************************************************************        
       2900-PROCESS-RATE-CURSOR.                                        
                                                                        
           INITIALIZE  FIOCA129.                                        
                                                                        
           MOVE AT-ACCOUNT-NO                TO E-FIOCA129-ACCOUNT-NO.  
           ADD 1 TO WS-SPL-RATE-ACCT-COUNT                              
                    WS-RECORD-COUNT.                                    
           PERFORM 8000-WRITE-FILE           THRU 8000-EXIT.            
           MOVE 0                            TO AT-ACCOUNT-NO.          
           PERFORM 7530-FETCH-RATE-CURSOR    THRU 7530-EXIT.            
      *                                                                         
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02906******************************************************************        
A02906* 2910-PROCESS-MASTER-CURSOR                                     *        
A02906* PROCESS FETCH AND WRITES ACCOUNTS FOR MASTER METER ACCOUNTS    *        
A02906******************************************************************        
A02906 2910-PROCESS-MASTER-CURSOR.                                      
A02906                                                                  
A02906     INITIALIZE  FIOCA129.                                        
A02906                                                                  
A02906     IF WS-MASTER-COUNT  <  WS-MST-MTR-ACCT-LIMIT                 
A02906        MOVE UR-ACCOUNT-NO-MST     TO E-FIOCA129-ACCOUNT-NO       
A02906        ADD  +1                    TO WS-MASTER-COUNT             
A02906        PERFORM 8000-WRITE-FILE               THRU 8000-EXIT      
A02906        PERFORM 7580-OPEN-DEPENDENT-CURSOR    THRU 7580-EXIT      
A02906        PERFORM 7585-FETCH-DEPENDENT-CURSOR   THRU 7585-EXIT      
A02906        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A02906           PERFORM 2920-PROCESS-DEPENDENT-CURSOR THRU 2920-EXIT   
A02906                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
A02906        ELSE                                                      
A02906           DISPLAY 'DEPENDENT ACCOUNTS ARE NOT FOUND FOR'         
A02906                   'MASTER ACCOUNT:'  UR-ACCOUNT-NO-MST           
A02906           DISPLAY '* PROGRAM ABORTING...                  *'     
A02906           DISPLAY '********** PCSCA129  ABORT *************'     
A02906           PERFORM 9900-ABEND           THRU 9900-EXIT            
A02906        END-IF                                                    
A02906        PERFORM 7590-CLOSE-DEPENDENT-CURSOR   THRU 7590-EXIT      
A02906     ELSE                                                         
A02906        CONTINUE                                                  
A02906     END-IF.                                                      
      *                                                                         
A02906     PERFORM 7565-FETCH-MASTER-CURSOR         THRU 7565-EXIT.     
A02906                                                                  
A02906 2910-EXIT.                                                       
A02906     EXIT.                                                        
      *                                                                         
A02906******************************************************************        
A02906* 2920-PROCESS-DEPENDENT-CURSOR                                  *        
A02906* PROCESS FETCH AND WRITES ACCOUNTS FOR DEPENDENT METER ACCOUNTS *        
A02906******************************************************************        
A02906 2920-PROCESS-DEPENDENT-CURSOR.                                   
A02906                                                                  
A02906     INITIALIZE  FIOCA129.                                        
A02906     MOVE UR-ACCOUNT-NO-DEP              TO E-FIOCA129-ACCOUNT-NO.
A02906     PERFORM 8000-WRITE-FILE             THRU 8000-EXIT.          
      *                                                                         
A02906     PERFORM 7585-FETCH-DEPENDENT-CURSOR THRU 7585-EXIT.          
A02906                                                                  
A02906 2920-EXIT.                                                       
A02906     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  PARAGRAPH 6240-GET-FCA00-COMMON-DATE.                         *        
      ******************************************************************        
       COPY CPD00040.                                                           
                                                                        
      ******************************************************************        
      * 7000-GET-BILL-CYCLE                                            *        
      * GET BILL CYCLE                                                 *        
      ******************************************************************        
       7000-GET-BILL-CYCLE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) BILL_CYCLE                                        
                 INTO :BN-BILL-CYCLE                                    
                 FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                     
                WHERE DATE_EXTRACT   = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                 
                  AND CODE_BILL_COND = 'R'                              
                ORDER BY REVENUE_MONTH DESC, BILL_CYCLE DESC            
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BILL_CYCLE                                                
MFA-TR*          INTO :BN-BILL-CYCLE                                            
MFA-TR*          FROM CSS_BILL_WINDOW                                           
MFA-TR*         WHERE DATE_EXTRACT   = :BN-DATE-EXTRACT                         
MFA-TR*           AND CODE_BILL_COND = 'R'                                      
MFA-TR*         ORDER BY REVENUE_MONTH DESC, BILL_CYCLE DESC                    
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA129  ABORT **************'      
               DISPLAY '* 7000-GET-BILL-CYCLE                   *'      
               DISPLAY '* BILL_CYCLE = ' BN-BILL-CYCLE                  
               DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA129  ABORT **************'      
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-OPEN-BASE-CURSOR                                          *        
      * OPENS BASE CURSOR                                              *        
      ******************************************************************        
       7100-OPEN-BASE-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN BASE_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7100-OPEN-BASE-CURSOR               *'         
              DISPLAY '* DATE_EXTRACT   = ' BN-DATE-EXTRACT             
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7130-FETCH-BASE-CURSOR                                         *        
      * FETCH BASE CURSOR                                              *        
      ******************************************************************        
       7130-FETCH-BASE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  BASE_CSR                                         
                 INTO  :AT-ACCOUNT-NO                                   
                      ,:UT-RATE-PLAN-NO                                 
                      ,:AT-BILL-CYCLE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7130-FETCH-BASE-CURSOR              *'         
              DISPLAY '* DATE_EXTRACT   = ' BN-DATE-EXTRACT             
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-CLOSE-BASE-CURSOR                                         *        
      * CLOSE BASE CURSOR                                              *        
      ******************************************************************        
       7150-CLOSE-BASE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE BASE_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7150-CLOSE-BASE-CURSOR              *'         
              DISPLAY '* DATE_EXTRACT   = ' BN-DATE-EXTRACT             
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-OPEN-OFF-CYL-CURSOR                                       *        
      * OPENS OFF CYLCE  CURSOR                                        *        
      ******************************************************************        
       7200-OPEN-OFF-CYL-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN OFF_CYCLE_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7200-OPEN-OFF-CYL-CURSOR            *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7230-FETCH-OFF-CYL-CURSOR                                      *        
      * FETCH OFF CYCLE CURSOR                                         *        
      ******************************************************************        
       7230-FETCH-OFF-CYL-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                FETCH OFF_CYCLE_CSR                                     
                 INTO :OC-ACCOUNT-NO                                    
                     ,:OC-CODE-BILL-OFF-CYCL                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '*  7230-FETCH-OFF-CYL-CURSOR          *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7250-CLOSE-OFF-CYL-CURSOR                                      *        
      * CLOSE OFF CYLCLE CURSOR                                        *        
      ******************************************************************        
       7250-CLOSE-OFF-CYL-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE OFF_CYCLE_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7250-CLOSE-OFF-CYL-CURSOR           *'         
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-OPEN-CODVAL-CURSOR                                        *        
      * OPENS CODE VALUE CURSOR                                        *        
      ******************************************************************        
       7300-OPEN-CODVAL-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN CODE_VAL_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7300-OPEN-CODVAL-CURSOR             *'         
              DISPLAY '* TABLE_NA     = ' UV-TABLE-NA                   
              DISPLAY '* PROGRAM_ID   = ' UV-PROGRAM-ID                 
              DISPLAY '* COMPANY_NO   = ' UV-COMPANY-NO                 
              DISPLAY '* COLUMN_NA    = ' UV-COLUMN-NA                  
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7330-FETCH-CODVAL-CURSOR                                       *        
      * FETCH CODE VALUE CURSOR                                        *        
      ******************************************************************        
       7330-FETCH-CODVAL-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH  CODE_VAL_CSR                                      
                INTO :UV-CODE-LONG-DESC                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7330-FETCH-CODVAL-CURSOR            *'         
              DISPLAY '* TABLE_NA     = ' UV-TABLE-NA                   
              DISPLAY '* PROGRAM_ID   = ' UV-PROGRAM-ID                 
              DISPLAY '* COMPANY_NO   = ' UV-COMPANY-NO                 
              DISPLAY '* COLUMN_NA    = ' UV-COLUMN-NA                  
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7450-CLOSE-CODVAL-CURSOR                                       *        
      * CLOSE CODE VALUE CURSOR                                        *        
      ******************************************************************        
       7350-CLOSE-CODVAL-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE CODE_VAL_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7350-CLOSE-CODVAL-CURSOR            *'         
              DISPLAY '* TABLE_NA     = ' UV-TABLE-NA                   
              DISPLAY '* PROGRAM_ID   = ' UV-PROGRAM-ID                 
              DISPLAY '* COMPANY_NO   = ' UV-COMPANY-NO                 
              DISPLAY '* COLUMN_NA    = ' UV-COLUMN-NA                  
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-CHECK-BILL-ACCTS                                          *        
      * CHECKING  SPECIAL ACCOUNTS ARE READY TO BILL                   *        
      ******************************************************************        
       7400-CHECK-BILL-ACCTS.                                           
                                                                        
           EXEC SQL                                                     
               SELECT  'Y'                                              
                 INTO :WS-ACCT-READY-TO-BILL                            
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                 
                  AND CODE_ACCT_BILLED = 'R'                            
A02906                                                           
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO :WS-ACCT-READY-TO-BILL                                    
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                         
MFA-TR*           AND CODE_ACCT_BILLED = 'R'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA129  ABORT **************'      
               DISPLAY '* 7400-CHECK-BILL-ACCTS                 *'      
               DISPLAY '* ACCOUNT_NO = ' AT-ACCOUNT-NO                  
               DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '********** PCSCA129  ABORT **************'      
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
AP1685******************************************************************        
AP1685* 7410-CHECK-FOR-MASTER-ACCT.                                    *        
AP1685* CHECKING FOR MASTER ACCOUNT AND REVENUE MONTH LAST NORMAL IS   *        
AP1685* LESS THAN THE CURRENT REVENUE MONTH                            *        
AP1685******************************************************************        
AP1685 7410-CHECK-FOR-MASTER-ACCT.                                      
AP1685*                                                                         
AP1685     EXEC SQL                                                     
AP1685        SELECT BILL_CYCLE                                         
AP1685          INTO :WS-MSTR-ACCT-BILL-CYCLE                           
AP1685          FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
AP1685         WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                  
AP1685           AND MST_SUB_ACCT_IND = 'M'                             
AP1685           AND REV_MTH_LST_NRML < :AT-REV-MTH-LST-NRML            
A02906                                                           
A02906                                                      
AP1685     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BILL_CYCLE                                                 
MFA-TR*         INTO :WS-MSTR-ACCT-BILL-CYCLE                                   
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                          
MFA-TR*          AND MST_SUB_ACCT_IND = 'M'                                     
MFA-TR*          AND REV_MTH_LST_NRML < :AT-REV-MTH-LST-NRML                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7410                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

AP1685                                                                  
AP1685     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
AP1685                                                                  
AP1685     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
AP1685        CONTINUE                                                  
AP1685     ELSE                                                         
AP1685        DISPLAY '********** PCSCA129  ABORT **************'       
AP1685        DISPLAY '* 7410-CHECK-FOR-MASTER-ACCT            *'       
AP1685        DISPLAY '* ACCOUNT_NO = ' AT-ACCOUNT-NO                   
AP1685        DISPLAY '* REV_MTH_LST_NRML = ' AT-REV-MTH-LST-NRML       
AP1685        DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
AP1685        DISPLAY '* PROGRAM ABORTING...                   *'       
AP1685        DISPLAY '********** PCSCA129  ABORT **************'       
AP1685        PERFORM 9900-ABEND           THRU 9900-EXIT               
AP1685     END-IF.                                                      
AP1685*                                                                         
AP1685 7410-EXIT.                                                       
AP1685     EXIT.                                                        
AP1685*                                                                         
AP1685******************************************************************        
AP1685* 7420-CHECK-BILL-CYCLE-OPEN.                                    *        
AP1685* CHECKING  WHETHER THE BILL CYCLE FOR MASTER ACCOUNT IS OPEN    *        
AP1685* IN BILL WINDOW TABLE.                                          *        
AP1685******************************************************************        
AP1685 7420-CHECK-BILL-CYCLE-OPEN.                                      
AP1685*                                                                         
AP1685     EXEC SQL                                                     
AP1685        SELECT 'Y'                                                
AP1685          INTO :WS-BILL-CYCLE-OPEN                                
AP1685          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
AP1685         WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                    
AP1685           AND BILL_CYCLE   = :BN-BILL-CYCLE                      
A02906                                                           
A02906                                                      
AP1685     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-BILL-CYCLE-OPEN                                        
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT = :BN-DATE-EXTRACT                            
MFA-TR*          AND BILL_CYCLE   = :BN-BILL-CYCLE                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7420                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

AP1685*                                                                         
AP1685     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
AP1685                                                                  
AP1685     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
AP1685        CONTINUE                                                  
AP1685     ELSE                                                         
AP1685        DISPLAY '********** PCSCA129  ABORT **************'       
AP1685        DISPLAY '* 7420-CHECK-BILL-CYCLE-OPEN            *'       
AP1685        DISPLAY '* DATE_EXTRACT = ' BN-DATE-EXTRACT               
AP1685        DISPLAY '* BILL_CYCLE   = ' BN-BILL-CYCLE                 
AP1685        DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE    
AP1685        DISPLAY '* PROGRAM ABORTING...                   *'       
AP1685        DISPLAY '********** PCSCA129  ABORT **************'       
AP1685        PERFORM 9900-ABEND           THRU 9900-EXIT               
AP1685     END-IF.                                                      
AP1685                                                                  
AP1685 7420-EXIT.                                                       
AP1685     EXIT.                                                        
AP1685*                                                                         
      ******************************************************************        
      * 7500-OPEN-RATE-CURSOR                                          *        
      * OPENS RATE CURSOR                                              *        
      ******************************************************************        
       7500-OPEN-RATE-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN RATE_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7500-OPEN-RATE-CURSOR               *'         
              DISPLAY '* DATE_EXTRACT   = ' BN-DATE-EXTRACT             
              DISPLAY '* RATE_PLAN_NO = ' UT-RATE-PLAN-NO               
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7530-FETCH-RATE-CURSOR                                         *        
      * FETCH RATE CURSOR                                              *        
      ******************************************************************        
       7530-FETCH-RATE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  RATE_CSR                                         
                 INTO  :AT-ACCOUNT-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7530-FETCH-RATE-CURSOR              *'         
              DISPLAY '* DATE_EXTRACT   = ' BN-DATE-EXTRACT             
              DISPLAY '* RATE_PLAN_NO = ' UT-RATE-PLAN-NO               
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ***********'          
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7550-CLOSE-RATE-CURSOR                                         *        
      * CLOSE RATE CURSOR                                              *        
      ******************************************************************        
       7550-CLOSE-RATE-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE RATE_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              DISPLAY '* 7550-CLOSE-RATE-CURSOR              *'         
              DISPLAY '* DATE_EXTRACT   = ' BN-DATE-EXTRACT             
              DISPLAY '* RATE_PLAN_NO = ' UT-RATE-PLAN-NO               
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA129 ABORT  ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02906******************************************************************        
A02906* 7560-OPEN-MASTER-CURSOR                                        *        
A02906* OPENS MASTER CURSOR                                            *        
A02906******************************************************************        
A02906 7560-OPEN-MASTER-CURSOR.                                         
A02906                                                                  
A02906     EXEC SQL                                                     
A02906          OPEN MASTER_CSR                                         
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906                                                                  
A02906     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A02906                                                                  
A02906     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02906        CONTINUE                                                  
A02906     ELSE                                                         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        DISPLAY '* 7560-OPEN-MASTER-CURSOR                  *'    
A02906        DISPLAY '* DEP_REL_START_DT = ' UR-DEP-REL-START-DT       
A02906        DISPLAY '* DEP_REL_END_DT   = ' UR-DEP-REL-END-DT         
A02906        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02906        DISPLAY '* PROGRAM ABORTING...                 *'         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        PERFORM 9900-ABEND            THRU 9900-EXIT              
A02906     END-IF.                                                      
A02906                                                                  
A02906 7560-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
A02906******************************************************************        
A02906* 7565-FETCH-MASTER-CURSOR                                       *        
A02906* FETCH DEPENDENT CURSOR                                         *        
A02906******************************************************************        
A02906 7565-FETCH-MASTER-CURSOR.                                        
A02906                                                                  
A02906     EXEC SQL                                                     
A02906          FETCH  MASTER_CSR                                       
A02906           INTO  :UR-ACCOUNT-NO-MST                               
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906                                                                  
A02906     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A02906                                                                  
A02906     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02906        CONTINUE                                                  
A02906     ELSE                                                         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        DISPLAY '* 7565-FETCH-MASTER-CURSOR            *'         
A02906        DISPLAY '* DEP_REL_START_DT = ' UR-DEP-REL-START-DT       
A02906        DISPLAY '* DEP_REL_END_DT   = ' UR-DEP-REL-END-DT         
A02906        DISPLAY '* MASTER ACCOUNT   = ' UR-ACCOUNT-NO-MST         
A02906        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02906        DISPLAY '* PROGRAM ABORTING...                 *'         
A02906        DISPLAY '********** PCSCA129 ABORT  ***********'          
A02906        PERFORM 9900-ABEND             THRU 9900-EXIT             
A02906     END-IF.                                                      
A02906                                                                  
A02906 7565-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
A02906******************************************************************        
A02906* 7570-CLOSE-MASTER-CURSOR                                       *        
A02906* CLOSE MASTER CURSOR                                            *        
A02906******************************************************************        
A02906 7570-CLOSE-MASTER-CURSOR.                                        
A02906                                                                  
A02906     EXEC SQL                                                     
A02906         CLOSE MASTER_CSR                                         
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906                                                                  
A02906     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A02906                                                                  
A02906     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
A02906        CONTINUE                                                  
A02906     ELSE                                                         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        DISPLAY '* 7570-CLOSE-MASTER-CURSOR            *'         
A02906        DISPLAY '* DEP_REL_START_DT = ' UR-DEP-REL-START-DT       
A02906        DISPLAY '* DEP_REL_END_DT   = ' UR-DEP-REL-END-DT         
A02906        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02906        DISPLAY '* PROGRAM ABORTING...                 *'         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        PERFORM 9900-ABEND            THRU 9900-EXIT              
A02906     END-IF.                                                      
A02906                                                                  
A02906 7570-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
A02906******************************************************************        
A02906* 7580-OPEN-DEPENDENT-CURSOR                                     *        
A02906* OPENS DEPENDENT CURSOR                                         *        
A02906******************************************************************        
A02906 7580-OPEN-DEPENDENT-CURSOR.                                      
A02906                                                                  
A02906     EXEC SQL                                                     
A02906         OPEN DEPENDENT_CSR                                       
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906                                                                  
A02906     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A02906                                                                  
A02906     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02906        CONTINUE                                                  
A02906     ELSE                                                         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        DISPLAY '* 7580-OPEN-DEPENDENT-CURSOR               *'    
A02906        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02906        DISPLAY '* ACCOUNT_NO_MST   = ' UR-ACCOUNT-NO-MST         
A02906        DISPLAY '* DEP_REL_START_DT = ' UR-DEP-REL-START-DT       
A02906        DISPLAY '* DEP_REL_END_DT   = ' UR-DEP-REL-END-DT         
A02906        DISPLAY '* PROGRAM ABORTING...                 *'         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        PERFORM 9900-ABEND            THRU 9900-EXIT              
A02906     END-IF.                                                      
A02906                                                                  
A02906 7580-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
A02906******************************************************************        
A02906* 7585-FETCH-DEPENDENT-CURSOR                                    *        
A02906* FETCH DEPENDENT CURSOR                                         *        
A02906******************************************************************        
A02906 7585-FETCH-DEPENDENT-CURSOR.                                     
A02906                                                                  
A02906     EXEC SQL                                                     
A02906         FETCH  DEPENDENT_CSR                                     
A02906          INTO  :UR-ACCOUNT-NO-DEP                                
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906                                                                  
A02906     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
A02906                                                                  
A02906     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02906        CONTINUE                                                  
A02906     ELSE                                                         
A02906         DISPLAY '********** PCSCA129 ABORT  ************'        
A02906         DISPLAY '* 7585-FETCH-DEPENDENT-CURSOR         *'        
A02906         DISPLAY '* ACCOUNT_NO_MST   = ' UR-ACCOUNT-NO-MST        
A02906         DISPLAY '* DEP_REL_START_DT = ' UR-DEP-REL-START-DT      
A02906         DISPLAY '* DEP_REL_END_DT   = ' UR-DEP-REL-END-DT        
A02906         DISPLAY '* ACCOUNT_NO_DEP   = ' UR-ACCOUNT-NO-DEP        
A02906         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A02906         DISPLAY '* PROGRAM ABORTING...                 *'        
A02906         DISPLAY '********** PCSCA129 ABORT  ***********'         
A02906         PERFORM 9900-ABEND             THRU 9900-EXIT            
A02906     END-IF.                                                      
A02906                                                                  
A02906 7585-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
A02906******************************************************************        
A02906* 7590-CLOSE-DEPENDENT-CURSOR                                    *        
A02906* CLOSE DEPENDENT CURSOR                                         *        
A02906******************************************************************        
A02906 7590-CLOSE-DEPENDENT-CURSOR.                                     
A02906                                                                  
A02906     EXEC SQL                                                     
A02906         CLOSE DEPENDENT_CSR                                      
A02906     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02906                                                                  
A02906     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A02906                                                                  
A02906     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
A02906        CONTINUE                                                  
A02906     ELSE                                                         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        DISPLAY '* 7590-CLOSE-DEPENDENT-CURSOR         *'         
A02906        DISPLAY '* ACCOUNT_NO_MST   = ' UR-ACCOUNT-NO-MST         
A02906        DISPLAY '* DEP_REL_START_DT = ' UR-DEP-REL-START-DT       
A02906        DISPLAY '* DEP_REL_END_DT   = ' UR-DEP-REL-END-DT         
A02906        DISPLAY '* ACCOUNT_NO_DEP   = ' UR-ACCOUNT-NO-DEP         
A02906        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A02906        DISPLAY '* PROGRAM ABORTING...                 *'         
A02906        DISPLAY '********** PCSCA129 ABORT  ************'         
A02906        PERFORM 9900-ABEND            THRU 9900-EXIT              
A02906     END-IF.                                                      
A02906                                                                  
A02906 7590-EXIT.                                                       
A02906     EXIT.                                                        
A02906*                                                                         
      *****************************************************************         
      * CPD00038                                                      *         
      * 7600-START-FCSJC01                                            *         
      * 7610-READ-FCSJC01                                             *         
      * 7611-CLOSE                                                    *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CPD00039                                                       *        
      * 7620-START-FCSCA00                                             *        
      * 7621-READ-FCSCA00                                              *        
      * 7622-CLOSE-CA00-CSR                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7700-GET-DELINQ-CD                                             *        
      * GET DELINQUENCY CODE                                           *        
      ******************************************************************        
       7700-GET-DATABASE.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
                WHERE DELINQ_CD      = :C8-DELINQ-CD                    
                  AND COMPANY_NO     = '01'                             
                                                                 
A02906                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY                                           
MFA-TR*         WHERE DELINQ_CD      = :C8-DELINQ-CD                            
MFA-TR*           AND COMPANY_NO     = '01'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA129  ABORT **************'      
               DISPLAY '* 7700-GET-DATABASE                     *'      
               DISPLAY '* DELINQ_CD         : ' C8-DELINQ-CD            
               DISPLAY '* PROGRAM ABORTING...                   *'      
               DISPLAY '* SQLCODE IS        : ' WS-ACTIVE-RETURN-CODE   
               DISPLAY '********** PCSCA129  ABORT **************'      
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-WRITE-FILE                                                *        
      * WRITES OUTPUT FILE                                             *        
      ******************************************************************        
       8000-WRITE-FILE.                                                 
                                                                        
A04527     MOVE ';'                      TO        FILLER-1.            
A04527     MOVE SPACES                   TO        FILLER-2.            
           WRITE FIOCA129.                                              
           ADD 1  TO WS-WRITE-COUNT.                                    
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-WRITE-FIOCACTR                                            *        
      * WRITES OUTPUT FILE FOR IDCAMS                                  *        
      ******************************************************************        
       8100-WRITE-FIOCACTR.                                             
                                                                        
           MOVE SPACES                   TO E-FIOCACTR-PARAMETER.       
           MOVE WS-DEL-FILENAME          TO E-FIOCACTR-PARAMETER.       
           WRITE FIOCACTR.                                              
           MOVE SPACES                   TO E-FIOCACTR-PARAMETER.       
           MOVE WS-DEL-ACCTCOPY          TO E-FIOCACTR-PARAMETER.       
           WRITE FIOCACTR.                                              
           MOVE SPACES                   TO E-FIOCACTR-PARAMETER.       
           MOVE WS-DEL-FCSCA129          TO E-FIOCACTR-PARAMETER.       
           WRITE FIOCACTR.                                              
           MOVE SPACES                   TO E-FIOCACTR-PARAMETER.       
           MOVE ' SET MAXCC=0'           TO E-FIOCACTR-PARAMETER.       
           WRITE FIOCACTR.                                              
           MOVE SPACES                   TO E-FIOCACTR-PARAMETER.       
           MOVE WS-ALT-FILENAME          TO E-FIOCACTR-PARAMETER.       
           WRITE FIOCACTR.                                              
           MOVE SPACES                   TO E-FIOCACTR-PARAMETER.       
           MOVE WS-NEW-FILENAME          TO E-FIOCACTR-PARAMETER.       
           WRITE FIOCACTR.                                              
           MOVE SPACES                   TO E-FIOCACTR-PARAMETER.       
           MOVE WS-ALT-ACCTCOPY          TO E-FIOCACTR-PARAMETER.       
           WRITE FIOCACTR.                                              
           MOVE SPACES                   TO E-FIOCACTR-PARAMETER.       
           MOVE WS-NEW-ACCTCOPY          TO E-FIOCACTR-PARAMETER.       
           WRITE FIOCACTR.                                              
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      * PROGRAM TERMINATION                                            *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA129-FILE.                                         
           CLOSE FCSCACTR-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
      ********************** END OF THE PROGRAM ************************        
