       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA128.                                        
       DATE-WRITTEN.  NOV 1994.                                         
       REMARKS.                                                         
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INTIALS      REASON                              **         
      **    ____    _______      ______                              **         
      *****************************************************************         
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
           0000 - 0000     MAIN CONTROL PARAGRAPH                       
           ------------------------------------------------------------ 
           ---------- INITIAL PROCESSING  1 TIME ONLY ----------------- 
           0100 - 0100     INITIALIZATION, OPENS FILES                  
                               AND THE FCSCA09 FILE FROM THE GA DATABASE
           ------------------------------------------------------------ 
           -----------  MAIN PROCESSING ROUTINES  --------------------- 
           1000 - 1000     MAJOR PROCESSING LOOP                        
                               PROCESSES ALL GAM RECORDS                
           ------------------------------------------------------------ 
           ----------- UPDATE CALLS TO DATABASES  --------------------  
           8600 - 8700     UPDATE CALLS TO DATABASES                    
           ------------------------------------------------------------ 
           9901 - 9901     CONTROLLED ABEND                             
           -----------------------------------------------------------  
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.   IBM-370.                                      
       OBJECT-COMPUTER.   IBM-370.                                      
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
HPCCDM*    EJECT                                                                
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
HPCCDM*    EJECT                                                                
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA128'.
MSQ017     COPY MFASQLM.
       01  WS-MISC.                                                     
           05  WS-START                PIC X(40)                        
               VALUE 'WORKING STORAGE FOR PCSCA128 STARTS HERE'.        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBGLACCT                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE GL_ACCOUNT     CURSOR FOR                       
                SELECT                                                  
                   ACCT_BALANCE,                                        
                   BEGIN_ACCT_BALANCE,                                  
                   AMT_PER_DR_POSTED,                                   
                   AMT_PER_CR_POSTED                                    
                FROM CSS_GL_ACCOUNT                                     
                FOR UPDATE OF                                           
                    BEGIN_ACCT_BALANCE, AMT_PER_DR_POSTED,              
                    AMT_PER_CR_POSTED                                   
           END-EXEC.                                                    
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE             PIC X(02) VALUE SPACE.        
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC       PIC 99.                       
       01  WS-END                         PIC X(40)                     
           VALUE 'WORKING STORAGE FOR PCSCA128 ENDS HERE '.             
HPCCDM*    EJECT                                                                
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      *                                                               *         
      * 0000-MAINLINE                                                 *         
      *                                                               *         
      *****************************************************************         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 7100-OPEN-GL-ACCOUNT  THRU 7100-EXIT.                
           PERFORM 7110-FETCH-GL-ACCOUNT  THRU 7110-EXIT.               
           PERFORM 1000-CLEAR-DAILY-AMOUNTS THRU 1000-EXIT              
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
      *                                                                         
           STOP RUN.                                                    
      *****************************************************************         
      *                                                               *         
      *  0000-EXIT.                                                   *         
      *                                                               *         
      *****************************************************************         
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *  1000-CLEAR-DAILY-AMOUNTS.                                     *        
      *                                                                *        
      *     CLEAR DAILY DR/CR AMOUNTS ON THE GAM SEGMENTS.             *        
      *                                                                *        
      ******************************************************************        
       1000-CLEAR-DAILY-AMOUNTS.                                        
      *                                                                         
           IF (GL-AMT-PER-DR-POSTED  EQUAL 0)                           
               AND (GL-AMT-PER-CR-POSTED  EQUAL 0)                      
               PERFORM 7110-FETCH-GL-ACCOUNT THRU 7110-EXIT             
               GO TO 1000-EXIT                                          
           END-IF.                                                      
      *                                                                         
           MOVE GL-ACCT-BALANCE       TO GL-BEGIN-ACCT-BALANCE.         
           MOVE ZEROS                 TO GL-AMT-PER-DR-POSTED           
                                         GL-AMT-PER-CR-POSTED.          
      *                                                                         
           PERFORM 8100-UPDATE-GL-ACCOUNT THRU 8100-EXIT.               
      *                                                                         
           PERFORM 7110-FETCH-GL-ACCOUNT  THRU 7110-EXIT.               
      ****************************************************************          
      *                                                              *          
      * 1000-EXIT                                                    *          
      *                                                              *          
      ****************************************************************          
       1000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *****************************************************************         
      *                                                               *         
      * 7100-OPEN-GL-ACCOUNT                                          *         
      *                                                               *         
      *****************************************************************         
       7100-OPEN-GL-ACCOUNT.                                            
           EXEC SQL                                                     
                OPEN GL_ACCOUNT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7100' WS-ACTIVE-RETURN-CODE                     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      ***************************************************************           
      *                                                             *           
      * 7100-EXIT                                                   *           
      *                                                             *           
      ***************************************************************           
       7100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *                                                             *           
      * 7110-FETCH-GL-ACCOUNT                                       *           
      *                                                             *           
      ***************************************************************           
       7110-FETCH-GL-ACCOUNT.                                           
           EXEC SQL                                                     
                FETCH GL_ACCOUNT      INTO                              
                   :GL-ACCT-BALANCE,                                    
                   :GL-BEGIN-ACCT-BALANCE,                              
                   :GL-AMT-PER-DR-POSTED,                               
                   :GL-AMT-PER-CR-POSTED                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7110' WS-ACTIVE-RETURN-CODE                     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 7120-CLOSE-GL-ACCOUNT                                        *          
      *                                                              *          
      ****************************************************************          
       7120-CLOSE-GL-ACCOUNT.                                           
           EXEC SQL                                                     
                CLOSE GL_ACCOUNT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7120' WS-ACTIVE-RETURN-CODE                     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      ***************************************************************           
      *                                                             *           
      * 7120-EXIT                                                   *           
      *                                                             *           
      ***************************************************************           
       7120-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************           
      *                                                             *           
      * 8100-UPDATE-GL-ACCOUNT                                      *           
      *                                                             *           
      ***************************************************************           
       8100-UPDATE-GL-ACCOUNT.                                          
           EXEC SQL                                                     
                UPDATE CSS_GL_ACCOUNT                                   
                   SET  BEGIN_ACCT_BALANCE = :GL-BEGIN-ACCT-BALANCE,    
                        AMT_PER_DR_POSTED  = :GL-AMT-PER-DR-POSTED,     
                        AMT_PER_CR_POSTED  = :GL-AMT-PER-CR-POSTED      
                WHERE  CURRENT OF GL_ACCOUNT                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '8100' WS-ACTIVE-RETURN-CODE                     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      ****************************************************************          
      *                                                              *          
      * 8100-EXIT.                                                   *          
      *                                                              *          
      ****************************************************************          
       8100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 9000-TERMINATE                                               *          
      *                                                              *          
      ****************************************************************          
       9000-TERMINATE.                                                  
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
      ****************************************************************          
      *                                                              *          
      * 9000-EXIT                                                    *          
      *                                                              *          
      ****************************************************************          
       9000-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
             END-EXEC.                                                          
