       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA126.                                        
       DATE-WRITTEN.   OCT 1994.                                        
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ******              CUSTOMER SERVICE SYSTEM               *******         
      ******                        DB2                         *******         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS    REASON                               **         
      **  ========  ========    ===================================  **         
T10980**  05/08/97  CSS         ADD LOGIC TO ENSURE THAT CA126 CAN   **         
      **                        POST TO MULTIPLE REVENUE MONTHS      **         
T11109**  05/13/97  CSS         NOE CODE, FUNCTION CODE, BENE COST   **         
      **                        CENTER INCORRECTLY FORMATTED AS COMP3**         
      **                                                             **         
      **                                                             **         
T13673**  11/10/97  MKN         TO DISPLAY MORE INFORMATION ON ABEND **         
      **                                                             **         
PCR626**  04/22/98  KLP         CA126 INSERTS WORK QUEUE INTO        **         
      **                        CSS_WQ_ITEMS_MF WHEN FAILS ON INSERT **         
      **                        INTO GL_ENTRY_CRNT BECAUSE GL HASNT  **         
      **                        BEEN SET UP RATHER THAN ABENDING     **         
      **                   *   SPECIAL NOTE - POSTS TO SUBSTITUTE    **         
      **                       184.0026 IN PLACE OF BAD GL           **         
T20170** 08/12/99   CBSI       POPULATED PROGAM-NAME IN TO           **         
T20170**            MADRAS     WF-FREE-FORM-DATA-TEXT FIELD.         **         
T24236** 06/07/01   SS19371    CHANGED PERMITTABLE INVALID GL'S FROM **         
      **                       25 TO 50                              **         
T35434** 02/28/07   MC95456    REPLACED CSS_MODEL_SQL WITH SET       **         
T35434**                                             STATEMENTS      **         
P34908**                                                             **         
P34908** 05/27/08   RC41079    ADD PAGER LOGIC TO SEND EMAIL WHEN    **         
P34908**                       THE GL BALANCE IS >= 1 BILLION OR <=  **         
P34908**                       -1 BILLION.                           **         
P34908**                                                             **         
A04880** 03/18/14   MR7E794    REMOVED THE WQ MESSAGE CREATION.      **         
A04880** ACT069                                                      **         
A05460** 07/06/16   HA7A338    RECOMPILING FOR CA09 COPYBOOKK CHANGES**         
A05460**                       AND COMMENTED OUT UNWANTED CODES      **         
      *****************************************************************         
      *                 GA UPDATE PCSCA126                                      
      * SUMMERIZED DAILY JOURNALS (CA09) CREATED IN PROGRAM PCSCA123            
      * ARE POSTED TO THE GENERAL LEDGER DATA BASE.  ALL ACCOUNTS               
      * HAVE BEEN VALIDATED/ADJUSTED AND POSTING IS A MANY TO ONE               
      * APPLICATION.  UPON AN INVALID ACCOUNT THE PROGRAM TERMINATES.           
      * NO REPORTS ARE PRODUCED                                                 
       REMARKS.                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      * USES FILES                                                              
      *     FCSCA09 - A KSDS FILE CONSISTING OF SUMMARY JOURNALS                
      *     FCSJC01 - A KSDS FILE, USED FOR PARM DATA INPUT                     
      *     FCSCA00 - A KSDS FILE, USED TO OBTAIN THE PROCESSING DATE           
      *     FCSCA10 - DLI GA01 GENERAL ACCOUNTING DATA BASE                     
      * CHECKS THE JOURNAL RECORDS.                                             
      * UPDATES THE APPROPRIATE G/L DATABASE SEGMENTS.                          
      * CREATES FIVE REPORTS.                                                   
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
           0000 - 0000     MAIN CONTROL PARAGRAPH                       
           ------------------------------------------------------------ 
           ---------- INITIAL PROCESSING  1 TIME ONLY ----------------- 
           0100 - 0100     INITIALIZATION, OPENS FILES                  
           0200 - 0200     LOADS CORRECT TABLE NUMBERS                  
           0500 - 0520     LOADS GENERAL LEDGER TABLES, GL CONTROL TABLE
                               AND THE FCSCA09 FILE FROM THE GA DATABASE
           ------------------------------------------------------------ 
           -----------  MAIN PROCESSING ROUTINES  --------------------- 
           1000 - 1000     MAJOR PROCESSING LOOP                        
                               CONTROLS PROCESSING ACCORDING TO TYPE OF 
                               CA07 RECORD READ                         
           ------------------------------------------------------------ 
           2000 - 2001     JRNL CHANGE CHECK - CHECKS FOR LEGITIMATE    
                               CHANGE AND INITIATES THE REQUIRED        
                               PROCESSING BASED ON THE CHANGE           
           ------------------------------------------------------------ 
           ----------- PROCESSES G/L DISK WORK FILE (FCSCA09) --------- 
           2100 - 2100     CONTROLS TRANSFER FROM THE G/L TABLES        
                            TO G/L DISK WORK (FCSCA09 FILE)             
               2110 - 2122      TRANSFERS INDIVIDUAL G/L TABLES         
                                   TO THE G/L DISK WORK FILE            
           ------------------------------------------------------------ 
           2200 - 2200     READS G/L DISK WORK, DETERMINES IF GA NEEDS  
                               TO BE UPDATED (5000)                     
           2500 - 2510     CONTROLS SEQUENTIAL PROCESSING OF G/L DISK   
                            WORK, PRINTS CGGLE-REPORT (8300)            
           ------------------------------------------------------------ 
           ----------- UPDATES 'GA' DATABASE  ------------------------- 
           5000 - 5000     UPDATES 'GAM' SEGMENT                        
               5010 - 5011     UPDATES 'GTH' SEGMENTS                   
               5020 - 5021     UPDATES 'GTE' SEGMENTS                   
               5030 - 5031     CREATES NEW FCSCA07 RECORD               
           ------------------------------------------------------------ 
           ----------- LOADS GL TRAN WORK AREA ------------------------ 
           5100 - 5100     LOADS THE GL TRAN WORK AREA WHICH IS USED    
                            IN UPDATING GA (5000)                       
           ------------------------------------------------------------ 
           ----------- JRNL HISTORY MERGE ----------------------------- 
           5500 - 5510     MERGES TODAYS ACTIVITY WITH PREVIOUS JRNLS   
                            FROM INPUT TAPE, WRITING TO THE OUTPUT TAPE 
           ------------------------------------------------------------ 
           ----------- WASH BUCKET CLEARING --------------------------- 
           6000 - 6000     CONTROLS CLEARING ROUTINE                    
               6100 - 6100     COMPARES BATCH TABLES TO FCSCA08 RECORD  
               6200 - 6200     COMPARES CASH TABLES TO FCSCA08 RECORD   
               6300 - 6300     READS FCSCA08 SEQUENTIALLY, COMPARING    
                                TOM TOTALS TO JRNL TOTALS               
               6400 - 6400     CREATES ERROR MESSAGE FOR WASH ERRORS    
           ------------------------------------------------------------ 
           ----------- INQUIRY CALLS TO DATABASES  -------------------- 
           7000 - 7510     INQUIRY CALLS TO DATABASE                    
           ------------------------------------------------------------ 
           ----------- READ INPUT PARAMETERS -------------------------- 
           7700 - 7710     READ INPUT PARAMETERS                        
           ------------------------------------------------------------ 
           ----------- REPORT PRINTING -------------------------------- 
           8000 - 8070     PRINTS DAILY TRANSACTION  JOURNAL            
           8100 - 8150     PRINTS GEN-LED TRANSACTION JOURNAL           
           8200 - 8221     PRINTS CASH DRAWER RECONCILIATION            
           ------------------------------------------------------------ 
           8222 - 8222     DISABLES TERMINALS                           
           ------------------------------------------------------------ 
           8300 - 8321     PRINTS CSS... GENERATED GEN-LED ENTRIES      
           8400 - 8420     PRINTS GEN-LED ACTIVITY SUMMARY              
           ------------------------------------------------------------ 
           8430 - 8430     UPDATES GAM SEGMENT                          
           ------------------------------------------------------------ 
           8450 - 8495     UPDATE G/L CONTROL TABLES                    
           8500 - 8520     PRINTS GEN-LED ACTIVITY CONDENSED SUMMARY    
           ------------------------------------------------------------ 
           ----------- UPDATE CALLS TO DATABASES  --------------------  
           8600 - 8700     UPDATE CALLS TO DATABASES                    
           -----------------------------------------------------------  
           8900 - 8910     WRITE PROGRAM INFORMATION LINES              
           -----------------------------------------------------------  
           9901 - 9901     CONTROLLED ABEND                             
           -----------------------------------------------------------  
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.   IBM-370.                                      
       OBJECT-COMPUTER.   IBM-370.                                      
      *                                                                         
       SPECIAL-NAMES.     C01 IS TOP-OF-PAGE.                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
P34908     SELECT FCSMA126-FILE  ASSIGN  UT-S-FCSMA126                  
P34908            FILE STATUS IS WS-FCS126-STATUS.                      
      *                                                                         
       COPY CSSCA09.                                                            
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
P34908 FD  FCSMA126-FILE                                                
P34908     BLOCK CONTAINS  0 RECORDS                                    
P34908     RECORD CONTAINS 80 CHARACTERS                                
P34908     RECORDING MODE  IS F                                         
P34908     LABEL RECORDS   ARE STANDARD.                                
      *                                                                         
P34908 01  FCSMA126-REC                PIC X(80).                       
      *                                                                         
       COPY CFDCA09.                                                            
       COPY FIOCA09.                                                            
      *                                                                         
HPCCDM*    EJECT                                                                
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA126'.
MSQ017     COPY MFASQLM.
       01   WS-START                PIC X(40)                           
               VALUE 'WORKING STORAGE FOR PCSCA126 STARTS HERE'.        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBGLENT                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBGLACCT                                                
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBGLMNTH                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
       01  WS-FCA09-STATUS                   PIC XX.                    
           88  FCA09-SUCCESSFUL         VALUE '00'.                     
      *                                                                         
34908  01  WS-FCS126-STATUS                   PIC XX.                   
34908      88  FCS126-SUCCESSFUL         VALUE '00'.                    
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-D                    PIC X(01)   VALUE 'D'.           
           05  WS-E                    PIC X(01)   VALUE 'E'.           
           05  WS-N                    PIC X(01)   VALUE 'N'.           
           05  WS-S                    PIC X(01)   VALUE 'S'.           
           05  WS-Y                    PIC X(01)   VALUE 'Y'.           
           05  WS-1                    PIC 9(01)   VALUE 1.             
           05  WS-GA01                 PIC X(04)   VALUE 'GA01'.        
           05  WS-YES                  PIC X(03)   VALUE 'YES'.         
           05  WS-NO                   PIC X(02)   VALUE 'NO'.          
           05  WS-999999S              PIC 9(11)   VALUE 99999999999.   
           05  WS-201                  PIC 9(05)   VALUE 00201.         
      *                                                                         
       01  WS-DATE-TEMP.                                                
           05  WS-DAT-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DAT-DD               PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-DAT-YY               PIC X(02).                       
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DATABASE             PIC 9(01)    VALUE ZERO.         
               88  CSR-DATABASE                     VALUE 1.            
               88  SEB-DATABASE                     VALUE 2.            
           05  WS-KEY-GL-ACCOUNT-NO       PIC 9(03)V9(04).              
           05  WS-KEY-GL-LOC-OFFICE-CODE  PIC X(03).                    
T10980     05  WS-KEY-REVENUE-MNTH        PIC 9(06).                    
           05  WS-WAS-GL-NUMBER-FOUND     PIC X(01) VALUE 'Y'.          
               88  WS-GL-NUMBER-NOT-IN-GA           VALUE 'N'.          
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA126'.      
           05  MSG-CUST-TRANS             PIC X(15)                     
               VALUE 'CUST-TRANS'.                                      
           05  WS-PARAMETER-BREAKDOWN.                                  
               10  FILLER                PIC X(07)    VALUE 'TAPEIN='.  
               10  WS-TAPE-PARAMETER     PIC X(03).                     
           05  WS-LOC-OFF-TABLE-NUM              PIC X(03).             
           05  WS-LOC-OFF-TABLE-NUM-RED                                 
               REDEFINES WS-LOC-OFF-TABLE-NUM    PIC X(03).             
           05  WS-GEN-LED-TABLE-NUM              PIC 9(04).             
           05  WS-GEN-LED-TABLE-NUM-RED                                 
               REDEFINES WS-GEN-LED-TABLE-NUM    PIC X(04).             
           05  WS-TERM-LOC-TABLE-NUM             PIC 9(04).             
           05  WS-TERM-LOC-TABLE-NUM-RED                                
               REDEFINES WS-TERM-LOC-TABLE-NUM   PIC 9(04).             
           05  WS-CUR-DATE-MDY.                                         
               10  WS-CUR-CC                     PIC 9(02).             
               10  WS-CUR-YY                     PIC 9(02).             
               10  FILLER                        PIC X(01).             
               10  WS-CUR-MM                     PIC 9(02).             
               10  FILLER                        PIC X(01).             
               10  WS-CUR-DD                     PIC 9(02).             
           05  WS-CURRENT-DATE-YMD.                                     
               10  WS-YMD-CC                  PIC 9(02).                
               10  WS-YMD-YY                  PIC 9(02).                
               10  FILLER                     PIC X(01) VALUE '-'.      
               10  WS-YMD-MM                  PIC 9(02).                
               10  FILLER                     PIC X(01) VALUE '-'.      
               10  WS-YMD-DD                  PIC 9(02).                
P34908     05  WS-FCSMA126-STATUS      PIC X(02).                       
P34908         88  FCSMA126-SUCCESSFUL              VALUE '00'.         
      *                                                                         
P34908     05  WS-FIRST-READ-FLAG      PIC X(01)    VALUE 'Y'.          
P34908         88  WS-FIRST-READ                    VALUE 'Y'.          
A04880     05  WS-SUBSTITUTE-GL       PIC 9(03)V9(04) VALUE 184.0026.   
      *                                                                         
       01  WS-ACCTNG-PER-DATE-CYM             PIC 9(06).                
       01  WS-ACCTNG-PER-DATE-CYM-RED REDEFINES                         
           WS-ACCTNG-PER-DATE-CYM.                                      
           05  WS-ACCTNG-PER-DATE-CYM-CC      PIC 9(02).                
           05  WS-ACCTNG-PER-DATE-CYM-YY      PIC 9(02).                
           05  WS-ACCTNG-PER-DATE-CYM-MM      PIC 9(02).                
PCR626 01  WS-VARIABLE-CNT.                                             
PCR626     05  WS-GLE-INSERT-RETURN   PIC S9(09) VALUE +0.              
PCR626     05  RS-RETURN-CODE         PIC S9(09) VALUE +0.              
PCR626     05  RS-RETURN-CODE-DISP    PIC +Z(04).                       
PCR626     05  WS-INVALID-GL-CNT          PIC 9(07) COMP-3 VALUE 0.     
PCR626 01  WS-SUBST-GL-SWITCH         PIC X(1).                         
PCR626     88  WS-DONT-SUBST-GL                 VALUE 'N'.              
PCR626     88  WS-USE-SUBST-GL                  VALUE 'Y'.              
PCR626                                                                  
      *                                                                         
       COPY CWS09900.                                                           
PCR626 COPY CWS00010.                                                           
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
       COPY FIOCA00.                                                            
       COPY FIOJC01.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00039                                                
           END-EXEC.                                                            
       COPY CWS00303.                                                           
      *                                                                         
       01  PROGRAM-NAME              PIC X(8)      VALUE 'PCSCA126'.    
       01  WS-VSAM-FILE-STATUS.                                         
           05  WS-SUCCESSFUL         PIC X(02)  VALUE '00'.             
           05  WS-END-OF-FILE        PIC X(02)  VALUE '10'.             
       01  WS-ZERO-RECORD-CA07                 PIC X(25)   VALUE SPACES.
       01  WS-ZERO-RECORD-CA08.                                         
           10  WS-ACTIVITY-TYPE-FCSCA08        PIC X(01)   VALUE SPACES.
           10  WS-ACTIVITY-SOURCE-FCSCA08.                              
               15  WS-ACT-LOC-OFF-CSCA08    PIC X(03).                  
               15  WS-ACT-ID-FCSCA08        PIC X(06)      VALUE SPACES.
       01  WS-ZERO-RECORD-CA09.                                         
           05  FILLER               PIC X(05)      VALUE SPACES.        
           05  FILLER               PIC S9(3)V9(4) COMP-3 VALUE ZEROES. 
           05  FILLER               PIC X(04)      VALUE SPACES.        
           05  FILLER               PIC S9(06)     COMP-3 VALUE ZEROS.  
           05  FILLER               PIC X(01)      VALUE SPACES.        
           05  FILLER               PIC S9(5)      COMP-3 VALUE ZEROES. 
       01  WS-RECORD-ID-BREAKDOWN      PIC S9(11).                      
       01  WS-RECORD-ID-BREAKDOWN-RED                                   
           REDEFINES WS-RECORD-ID-BREAKDOWN.                            
           05  FILLER                  PIC 9(01).                       
           05  WS-RECORD-ID-LOC-NO     PIC X(03).                       
           05  WS-RECORD-ID-ACCT-NO    PIC 9(07).                       
       01  WS-GL-HOLD-DR               PIC 9(03)V9(04).                 
       01  WS-GL-HOLD-DR-RED                                            
           REDEFINES WS-GL-HOLD-DR.                                     
           05  WS-GL-HOLD-DR-MAJOR          PIC 9(03).                  
           05  WS-GL-HOLD-DR-MINOR          PIC 9(04).                  
       01  WS-GL-HOLD-CR               PIC 9(03)V9(04).                 
       01  WS-GL-HOLD-CR-RED                                            
           REDEFINES WS-GL-HOLD-CR.                                     
           05  WS-GL-HOLD-CR-MAJOR          PIC 9(03).                  
           05  WS-GL-HOLD-CR-MINOR          PIC 9(04).                  
       01  WS-GL-NO-BREAKDOWN          PIC 9(07)V9(04).                 
       01  WS-GL-NO-BREAKDOWN-RED                                       
           REDEFINES WS-GL-NO-BREAKDOWN.                                
           05  FILLER                       PIC X(01).                  
           05  WS-GL-NO-BREAKDOWN-LOC-OFF   PIC X(03).                  
           05  WS-GL-NO-BREAKDOWN-MAJOR     PIC 9(03).                  
           05  WS-GL-NO-BREAKDOWN-MINOR     PIC 9(04).                  
       01  WS-GL-NO-LOC-OFF-BREAKDOWN-RED                               
           REDEFINES WS-GL-NO-BREAKDOWN.                                
           05  FILLER                       PIC X(01).                  
           05  WS-GL-NO-MAJOR-RED           PIC 9(03).                  
           05  WS-GL-NO-MINOR-RED           PIC 9(04).                  
           05  WS-GL-NO-LOC-OFF-RED         PIC X(03).                  
       01  WS-GL-MAJOR-MINOR-BREAKDOWN.                                 
           05  WS-GL-NO-MAJOR-M-M           PIC 9(03).                  
           05  WS-GL-NO-MINOR-M-M           PIC 9(04).                  
       01  WS-GL-MAJOR-MINOR                                            
           REDEFINES WS-GL-MAJOR-MINOR-BREAKDOWN    PIC 9(03)V9(04).    
       01  WS-GL-TRAN.                                                  
           05  WS-JRNL-SORT-ID-GL-TRAN         PIC X(01).               
           05  WS-RECORD-ID-GL-TRAN.                                    
COB305         10 WS-GL-ACCT-NO-GL-TRAN        PIC S9(11) COMP-3 
COB305           VALUE 0.     
               10  WS-ACCT-NO-FILLER-GL-TRAN   PIC X(03).               
           05  WS-TRAN-DATE-GL-TRAN            PIC X(10).               
COB305     05 WS-TRAN-TIME-GL-TRAN        PIC S9(07) COMP-3 VALUE 0.     
           05  WS-CODE-TERMINAL-TRAN-GL-TRAN   PIC X(04).               
COB305     05 WS-JRNL-TRAN-APPL-NO-GL-TRAN        PIC S9(03) COMP-3 
COB305       VALUE 0.     
COB305     05 WS-DUP-CONTROL-KEY-GL-TRAN        PIC S9(03) COMP-3 
COB305       VALUE 0.     
COB305     05 WS-DATE-LAST-ACTION-GL-TRAN        PIC S9(07) COMP-3 
COB305       VALUE 0.     
           05  WS-CODE-ENTRY-SOURCE-GL-TRAN    PIC X(01).               
           05  WS-OPER-ID-GL-TRAN              PIC X(06).               
           05  WS-BATCH-SEND-LOC-GL-TRAN       PIC X(03).               
           05  WS-ENTRY-LOC-OFF-GL-TRAN        PIC X(03).               
           05  WS-TRANS-ERRORS-GL-TRAN         PIC X(07).               
           05  WS-GL-WORK-ORDER-NO             PIC X(07).               
           05  WS-GL-WORK-ORDER-CLASS          PIC X(01).               
           05  WS-GL-CODE-PUB-AUTH             PIC X(01).               
T11109     05  WS-GL-BENE-COST-CENTER          PIC X(03).               
T11109     05  WS-GL-COST-CENTER               PIC X(03).               
T11109     05  WS-GL-NOE-CODE                  PIC X(03).               
           05  WS-GL-CODE-PROP-UNIT            PIC X(02).               
COB305     05 WS-GL-QUANTITY-ENTERED        PIC S9(05)V9 COMP-3 VALUE 0.     
           05  WS-GL-CODE-UNIT-OF-MEASURE      PIC X(02).               
           05  WS-GL-CODE-FUNCTION             PIC X(04).               
           05  WS-GL-COMPANY-NO                PIC X(02).               
      *                                                                         
PCR287     05  WS-GL-REV-DISTRICT-CD           PIC X(03).               
           05  WS-USER-DEFINED-AREA-GL-TRAN.                            
COB305         10 WS-GL-TRAN-JRNL-FORMAT-NO        PIC S9(05) COMP-3 
COB305           VALUE 0.  
               10  WS-GL-TRAN-CASH-DRAWER-USED    PIC X(01).            
COB305         10 WS-GL-TRAN-AMT-ENTERED        PIC S9(11)V99 COMP-3 
COB305           VALUE 0. 
COB305         10 WS-GL-TRAN-AMT-POSTED        PIC S9(11)V99 COMP-3 
COB305           VALUE 0. 
               10  WS-GL-TRAN-CODE-DR-CR          PIC X(01).            
COB305         10 WS-GL-TRAN-ACCTING-PERIOD        PIC S9(09) COMP-3 
COB305           VALUE 0.  
               10  WS-GL-TRAN-CODE-JRNL-ENT-SRCE  PIC X(01).            
COB305         10 WS-GL-TRAN-JRNL-ENT-NO        PIC S9(09) COMP-3 
COB305           VALUE 0.  
COB305         10 WS-GL-TRAN-OFF-SET-GL-NO        PIC S9(4)V9(5) COMP-3 
COB305           VALUE 0.
COB305         10 WS-GL-TRAN-RESP-ID        PIC S9(09) COMP-3 VALUE 0.  
               10  WS-GL-TRAN-CODE-REF-NO-TYPE    PIC X(01).            
               10  WS-GL-TRAN-REF-NO              PIC X(15).            
               10  WS-GL-TRAN-REF-NO-RED                                
                   REDEFINES WS-GL-TRAN-REF-NO.                         
                   15  WS-GL-TRAN-ACCT-NO         PIC 9(11).            
                   15  FILLER                     PIC X(01).            
                   15  WS-GL-TRAN-TENANT-NO       PIC 9(03).            
               10  WS-GL-TRAN-TRAN-DESCRIPTION    PIC X(25).            
               10  WS-GL-TRAN-CODE-REG-TYPE       PIC X(01).            
COB305         10 WS-GL-TRAN-REG-NO        PIC S9(07) COMP-3 VALUE 0.  
COB305         10 WS-GL-TRAN-CHECK-NO        PIC S9(07) COMP-3 VALUE 0.  
COB305         10 WS-GL-TRAN-CHECK-ISSUE-DATE        PIC S9(09) COMP-3 
COB305           VALUE 0.  
               10  FILLER                         PIC X(10).            
       01  WS-PENDING-MSG             PIC X(55)        VALUE SPACES.    
       01  WS-PENDING-DESC.                                             
           05  FILLER                 PIC X(13)        VALUE SPACES.    
           05  WS-PENDING-DESC-DATA   PIC X(15)        VALUE SPACES.    
           05  WS-PENDING-DESC-CODE   PIC X(01).                        
      *  *  *  *  *   *  *   *   *  *  *  *  *  *   *  *  *  *  *  *  *         
      *   THE FOLLOWING WORKING-STORAGE AREAS ARE USED PRIMARILY DURING         
      * THE PROCESS OF CUSTOMER ACCOUNTING JOURNALS (SORT KEY A)                
      * WHEN ADDING GENERAL LEDGER DEBIT AND CREDIT VALUES TO EITHER            
      * A WORKING STORAGE TABLE OR TO GEN-LED-DISK-WORK.                        
      *                                                                         
      *  *  *  *  *   *  *   *   *  *  *  *  *  *   *  *  *  *  *  *  *         
       01  WS-HOLD-AREAS.                                               
           05  WS-GL12-KEY                  PIC 9(03)V9(04).            
           05  WS-GL12-KEY-RED REDEFINES WS-GL12-KEY.                   
               10  WS-GL1-KEY               PIC 9(03).                  
               10  WS-GL2-KEY               PIC 9(04).                  
           05  WS-SPECIAL-GL-DR-SAVE        PIC 9(03)V9(04).            
           05  WS-HOLD-GL-NO                PIC 9(03)V9(04)  VALUE ZERO.
           05  WS-HOLD-GL-NO-RED                                        
               REDEFINES WS-HOLD-GL-NO      PIC 9(07).                  
           05  WS-HOLD-GL-NO-MAJOR-MINOR                                
               REDEFINES WS-HOLD-GL-NO.                                 
               10  WS-HOLD-GL-NO-MAJOR      PIC 9(03).                  
               10  WS-HOLD-GL-NO-MINOR      PIC 9(04).                  
           05  WS-LOC-OFF-GL-NO-KEY         PIC 9(11).                  
           05  WS-LOC-OFF-GL-NO-BREAKDOWN                               
               REDEFINES WS-LOC-OFF-GL-NO-KEY.                          
               10  FILLER                  PIC X(01).                   
               10  WS-LOC-OFF-NO-KEY       PIC X(03).                   
               10  WS-GL-NO-KEY            PIC 9(03)V9(04).             
               10  FILLER                  REDEFINES                    
                   WS-GL-NO-KEY.                                        
                   15  WS-GL-NO-MAJOR-KEY      PIC 9(03).               
                   15  WS-GL-NO-MINOR-KEY      PIC 9(04).               
           05  WS-GL-NO-MMD                  PIC 9(11).                 
           05  WS-GL-NO-MMD-RED                                         
               REDEFINES WS-GL-NO-MMD.                                  
               10  FILLER                    PIC X(01).                 
               10  WS-GL-NO-M-MAJOR          PIC 9(03).                 
               10  WS-GL-NO-M-MINOR          PIC 9(04).                 
               10  WS-GL-NO-D-LOC-OFF        PIC X(03).                 
           05  WS-IS-THIS-THE-FIRST-CA09-REC  PIC X(01)  VALUE 'N'.     
               88  WS-THIS-IS-THE-FIRST-CA09-REC            VALUE 'Y'.  
           05  WS-LAST-SEQ-CA09-REC           PIC X(01)  VALUE 'N'.     
               88  WS-THIS-IS-LAST-SEQ-CA09-REC             VALUE 'Y'.  
           05  WS-GL-DR-AMT-POSTED       PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-GL-CR-AMT-POSTED       PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-KEY-LOC-OFF-CODE           PIC X(03).                 
           05  WS-KEY-COMPANY-NO             PIC X(02).                 
       01  WS-STATUS-KEY-ERROR-LINE.                                    
           05  FILLER                        PIC X(07)                  
               VALUE '*******'.                                         
           05  P-STATUS-KEY-ERROR-MSG        PIC X(24).                 
           05  FILLER                        PIC X(15)                  
               VALUE '  STATUS KEY = '.                                 
           05  P-STATUS-KEY                  PIC X(02).                 
           05  FILLER                        PIC X(22)                  
               VALUE '   PARAGRAPH NUMBER = '.                          
           05  P-PARAGRAPH-NUMBER            PIC 9(04).                 
           05  FILLER                        PIC X(58)     VALUE SPACES.
      *                                                                         
       01  WS-PROGRAM-INFO-LINE.                                        
           05  FILLER                        PIC X(10)                  
               VALUE '**********'.                                      
           05  P-ABEND-MESSAGE               PIC X(122).                
       COPY CJF00105.                                                           
       COPY CJF00201.                                                           
       01  WS-END                         PIC X(40)                     
           VALUE 'WORKING STORAGE FOR PCSCA126 ENDS HERE '.             
HPCCDM*    EJECT                                                                
      *                                                                         
P34908 01  MAILHEAD-1.                                                  
P34908     05  FILLER                    PIC X(22) VALUE                
P34908         'HELO DOMAIN:     SCANA'.                                
      *                                                                         
P34908 01  MAILHEAD-2.                                                  
P34908     05  FILLER                    PIC X(14) VALUE                
P34908         'MAIL FROM:   <'.                                        
P34908     05  MAIL2-JOB-NAME            PIC X(07).                     
P34908     05  FILLER                    PIC X(20) VALUE                
P34908         '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                         
P34908 01  MAILHEAD-3.                                                  
P34908     05  FILLER                    PIC X(45) VALUE                
P34908         'RCPT TO:     <CISFINANCIALCONTROLS.SCANA.COM>'.         
      *                                                                         
P34908 01  MAILHEAD-4.                                                  
P34908     05  FILLER                    PIC X(04) VALUE                
P34908         'DATA'.                                                  
      *                                                                         
P34908 01  MAILHEAD-5.                                                  
P34908     05  FILLER                    PIC X(18) VALUE                
P34908         'FROM: CSR PAGING <'.                                    
P34908     05  MAIL5-JOB-NAME            PIC X(07).                     
P34908     05  FILLER                    PIC X(20) VALUE                
P34908         '@SCEGJES2.SCANA.COM>'.                                  
      *                                                                         
P34908 01  MAILHEAD-6.                                                  
P34908     05  FILLER                    PIC X(38) VALUE                
P34908         'TO:   <CISFINANCIALCONTROLS.SCANA.COM>'.                
      *                                                                         
                                                                        
P34908 01  MAILHEAD-7.                                                  
P34908     05  FILLER                    PIC X(10) VALUE                
P34908         'SUBJECT:  '.                                            
P34908     05  MAIL7-SUBJECT             PIC X(30).                     
      *                                                                         
                                                                        
P34908 01  MAILHEAD-8.                                                  
P34908     05  FILLER                    PIC X(80) VALUE SPACES.        
      *                                                                         
                                                                        
P34908 01  MAILHEAD-9.                                                  
P34908     05  MAIL9-MESSAGE             PIC X(80).                     
      *                                                                         
P34908 01  MAILHEAD-10.                                                 
P34908     05  FILLER                    PIC X(05) VALUE 'LOCAL'.       
P34908     05  FILLER                    PIC X(04) VALUE SPACES.        
P34908     05  FILLER                    PIC X(07) VALUE 'REVENUE'.     
P34908     05  FILLER                    PIC X(06) VALUE SPACES.        
P34908     05  FILLER                    PIC X(03) VALUE 'G/L'.         
P34908     05  FILLER                    PIC X(10) VALUE SPACES.        
P34908     05  FILLER                    PIC X(05) VALUE 'DEBIT'.       
P34908     05  FILLER                    PIC X(12) VALUE SPACES.        
P34908     05  FILLER                    PIC X(06) VALUE 'CREDIT'.      
P34908     05  FILLER                    PIC X(08) VALUE SPACES.        
P34908     05  FILLER                    PIC X(02) VALUE 'GL'.          
      *                                                                         
                                                                        
P34908 01  MAILHEAD-11.                                                 
P34908     05  FILLER                    PIC X(06) VALUE 'OFFICE'.      
P34908     05  FILLER                    PIC X(04) VALUE SPACES.        
P34908     05  FILLER                    PIC X(05) VALUE 'MONTH'.       
P34908     05  FILLER                    PIC X(07) VALUE SPACES.        
P34908     05  FILLER                    PIC X(02) VALUE 'NO'.          
P34908     05  FILLER                    PIC X(12) VALUE SPACES.        
P34908     05  FILLER                    PIC X(03) VALUE 'AMT'.         
P34908     05  FILLER                    PIC X(15) VALUE SPACES.        
P34908     05  FILLER                    PIC X(03) VALUE 'AMT'.         
P34908     05  FILLER                    PIC X(08) VALUE SPACES.        
P34908     05  FILLER                    PIC X(07) VALUE 'BALANCE'.     
      *                                                                         
                                                                        
P34908 01  MAIL-DETAIL.                                                 
P34908     05  FILLER                    PIC X(01) VALUE SPACES.        
P34908     05  MAIL-LOCAL-OFFICE         PIC X(03).                     
P34908     05  FILLER                    PIC X(06) VALUE SPACES.        
P34908     05  MAIL-REVENUE-MTH          PIC 9(06).                     
P34908     05  FILLER                    PIC X(03) VALUE SPACES.        
P34908     05  MAIL-GL-REC               PIC 9(03)V9(04).               
P34908     05  FILLER                    PIC X(03) VALUE SPACES.        
P34908     05  MAIL-DEB-AMT              PIC -(9)9.9(2).                
P34908     05  FILLER                    PIC X(03) VALUE SPACES.        
P34908     05  MAIL-CRED-AMT             PIC -(9)9.9(2).                
P34908     05  FILLER                    PIC X(03) VALUE SPACES.        
P34908     05  MAIL-GL-BALANCE           PIC -(9)9.9(2).                
      *                                                                         
P34908 01  WS-MAIL-GL-ACCT-BAL           PIC S9(10)V99.                 
P34908 01  WS-MAIL-GL-ACCT-AMT           PIC S9(10)V99.                 
      *                                                                         
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      *                                                               *         
      * 0000-MAINLINE                                                 *         
      *                                                               *         
      *****************************************************************         
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
HEMA3 *    PERFORM 7070-POSITION-FCSCA09    THRU 7070-EXIT.                     
      *                                                                         
           PERFORM 2200-READ-FCSCA09-SEQ    THRU 2200-EXIT              
               UNTIL WS-THIS-IS-LAST-SEQ-CA09-REC.                      
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           DISPLAY 'PCSCA126 COMPLETED'.                                
           STOP RUN.                                                    
      *****************************************************************         
      *                                                               *         
      * 0000-EXIT.                                                    *         
      *                                                               *         
      *****************************************************************         
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *****************************************************************         
      *                                                               *         
      * 0100-INITIALIZATION                                           *         
      *                                                               *         
      *****************************************************************         
       0100-INITIALIZATION.                                             
           OPEN INPUT FCSCA09-FILE.                                     
           IF WS-FCA09-STATUS NOT = '00'                                
               MOVE 'ERROR.  STATUS KEY 9 IS ' TO P-STATUS-KEY-ERROR-MSG
               MOVE WS-FCA09-STATUS TO P-STATUS-KEY                     
               MOVE WS-STATUS-KEY-ERROR-LINE TO P-ABEND-MESSAGE         
               DISPLAY WS-PROGRAM-INFO-LINE                             
               PERFORM 9900-ABEND        THRU 9900-EXIT                 
               STOP RUN                                                 
           END-IF.                                                      
      *                                                                         
           MOVE 'DATABASE'                    TO C8-DELINQ-CD           
           MOVE '01'                          TO C8-COMPANY-NO          
           PERFORM 6500-GET-DATABASE          THRU 6500-EXIT.           
           MOVE C8-DELINQ-VALUE               TO WS-DATABASE            
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
           IF COMMON-DATE-NEEDED                                        
             OR WS-INPUT-DATE EQUAL '9999-99-99'                        
              PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT       
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE            
           END-IF.                                                      
           MOVE WS-INPUT-DATE TO WS-CUR-DATE-MDY.                       
           MOVE WS-CUR-DD TO WS-YMD-DD.                                 
           MOVE WS-CUR-MM TO WS-YMD-MM.                                 
           MOVE WS-CUR-YY TO WS-YMD-YY.                                 
           MOVE WS-CUR-CC TO WS-YMD-CC.                                 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  2200-READ-FCSCA09-SEQ.                                        *        
      *       READS THE GEN-LED DISK WORK FILE SEQUENTIALLY,  AND      *        
      *   CHECKS TO SEE IF THERE WAS ANY ACTIVITY. IF SO THIS PARAGRAPH*        
      *   DETERMINES WHETHER 1 OR 2 GTE'S NEED TO BE CREATED DEPENDING *        
      *   ON THE JRNL ACTIVITY, THEN IT STARTS THE PROCESS BY WHICH    *        
      *   THE GA DATABASE IS UPDATED.                                  *        
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       2200-READ-FCSCA09-SEQ.                                           
           PERFORM 7080-READ-NEXT-FCSCA09     THRU 7080-EXIT.           
           IF WS-THIS-IS-LAST-SEQ-CA09-REC                              
              PERFORM 5000-UPDATE-GL THRU 5000-EXIT                     
               GO TO 2200-EXIT                                          
           END-IF.                                                      
           IF E-FCA09-KEY-EREC EQUAL HIGH-VALUES                        
               GO TO 2200-EXIT                                          
           END-IF.                                                      
           IF (E-FCA09-JRNL-ACTIVITY-DR EQUAL ZERO)                     
               AND (E-FCA09-JRNL-ACTIVITY-CR EQUAL ZERO)                
               GO TO 2200-EXIT                                          
           END-IF.                                                      
           IF E-FCA09-GL-ACCT-NO NOT EQUAL WS-KEY-GL-ACCOUNT-NO         
              OR E-FCA09-LOCAL-OFFICE NOT EQUAL WS-KEY-LOC-OFF-CODE     
              OR E-FCA09-COMPANY-NO NOT EQUAL WS-KEY-COMPANY-NO         
T10980        OR E-FCA09-REVENUE-MONTH NOT EQUAL WS-KEY-REVENUE-MNTH    
              PERFORM 5000-UPDATE-GL THRU 5000-EXIT                     
              INITIALIZE WS-GL-DR-AMT-POSTED                            
                         WS-GL-CR-AMT-POSTED                            
              MOVE E-FCA09-GL-ACCT-NO TO WS-KEY-GL-ACCOUNT-NO           
              MOVE E-FCA09-LOCAL-OFFICE TO WS-KEY-LOC-OFF-CODE          
              MOVE E-FCA09-COMPANY-NO TO WS-KEY-COMPANY-NO              
T10980        MOVE E-FCA09-REVENUE-MONTH TO WS-KEY-REVENUE-MNTH         
           END-IF.                                                      
           IF E-FCA09-RECORD-TYPE = 'A'                                 
               PERFORM 5100-LOAD-GL-TRAN-WORK-AREA THRU 5100-EXIT       
           ELSE                                                         
               PERFORM 5110-LOAD-ARM-TRAN-WORK-AREA THRU 5110-EXIT      
           END-IF.                                                      
           MOVE E-FCA09-REVENUE-MONTH TO WS-ACCTNG-PER-DATE-CYM.        
           MOVE E-FCA09-COMPANY-NO TO WS-GL-COMPANY-NO.                 
           MOVE E-FCA09-LOCAL-OFFICE TO WS-LOC-OFF-NO-KEY.              
           MOVE E-FCA09-GL-ACCT-NO TO WS-GL-NO-KEY.                     
           MOVE E-FCA09-FUNCTION-CODE TO WS-GL-CODE-FUNCTION.           
           MOVE WS-LOC-OFF-NO-KEY TO WS-GL-NO-D-LOC-OFF.                
           MOVE WS-GL-NO-MAJOR-KEY TO WS-GL-NO-M-MAJOR.                 
           MOVE WS-GL-NO-MINOR-KEY TO WS-GL-NO-M-MINOR.                 
           MOVE WS-GL-NO-MMD TO WS-GL-ACCT-NO-GL-TRAN.                  
           MOVE SPACES TO WS-ACCT-NO-FILLER-GL-TRAN.                    
           MOVE MSG-CUST-TRANS TO WS-GL-TRAN-REF-NO.                    
           IF E-FCA09-JRNL-ACTIVITY-DR EQUAL ZERO                       
              CONTINUE                                                  
           ELSE                                                         
              ADD E-FCA09-JRNL-ACTIVITY-DR TO WS-GL-DR-AMT-POSTED       
              MOVE E-FCA09-JRNL-ACTIVITY-DR TO WS-GL-TRAN-AMT-POSTED    
              MOVE WS-D                     TO WS-GL-TRAN-CODE-DR-CR    
              PERFORM 5020-CREATE-GL-ENTRY-CRNT THRU 5020-EXIT          
           END-IF.                                                      
           IF E-FCA09-JRNL-ACTIVITY-CR EQUAL ZERO                       
              CONTINUE                                                  
           ELSE                                                         
              ADD E-FCA09-JRNL-ACTIVITY-CR TO WS-GL-CR-AMT-POSTED       
              MOVE E-FCA09-JRNL-ACTIVITY-CR TO WS-GL-TRAN-AMT-POSTED    
              MOVE WS-C                     TO WS-GL-TRAN-CODE-DR-CR    
              PERFORM 5020-CREATE-GL-ENTRY-CRNT THRU 5020-EXIT          
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 2200-EXIT.                                                    *         
      *                                                               *         
      *****************************************************************         
       2200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HPCCDM*    EJECT                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  5000-UPDATE-GL-TRAIL-BALANCE.                                 *        
      *       THIS SECTION OF PARAGRAPHS UPDATE THE GA DATABASE.       *        
      *  *                                                                      
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       5000-UPDATE-GL.                                                  
           MOVE WS-YES                TO WS-WAS-GL-NUMBER-FOUND.        
           MOVE WS-GL-ACCT-NO-GL-TRAN TO WS-GL-NO-MMD.                  
           MOVE WS-GL-NO-D-LOC-OFF    TO GL-LOCAL-OFFICE.               
           MOVE WS-KEY-COMPANY-NO     TO GL-COMPANY-NO.                 
           MOVE WS-GL-NO-M-MAJOR      TO WS-GL-NO-MAJOR-KEY WS-GL1-KEY. 
           MOVE WS-GL-NO-M-MINOR      TO WS-GL-NO-MINOR-KEY WS-GL2-KEY. 
           MOVE WS-GL12-KEY       TO GL-GL-ACCT-NO.                     
           PERFORM 7100-SELECT-GL-ACCT-REF  THRU 7100-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-NO TO WS-WAS-GL-NUMBER-FOUND                     
               GO TO 5000-EXIT                                          
           END-IF.                                                      
      *                                                                         
           MOVE GL-DATE-LAST-TRANS TO WS-DATE-LAST-ACTION-GL-TRAN.      
      *                                                                         
P34908     MOVE ZEROS              TO WS-MAIL-GL-ACCT-AMT               
P34908                                WS-MAIL-GL-ACCT-BAL.              
P34908     MOVE GL-ACCT-BALANCE    TO MAIL-GL-BALANCE                   
P34908                                WS-MAIL-GL-ACCT-BAL.              
P34908     COMPUTE WS-MAIL-GL-ACCT-AMT = (WS-MAIL-GL-ACCT-BAL +         
P34908            WS-GL-DR-AMT-POSTED) - WS-GL-CR-AMT-POSTED.           
      *                                                                         
           ADD WS-GL-DR-AMT-POSTED TO GL-AMT-PER-DR-POSTED              
                                                GL-ACCT-BALANCE.        
           ADD WS-GL-CR-AMT-POSTED TO GL-AMT-PER-CR-POSTED.             
           SUBTRACT WS-GL-CR-AMT-POSTED FROM GL-ACCT-BALANCE.           
      *                                                                         
P34908     IF (WS-MAIL-GL-ACCT-AMT >= 1000000000) OR                    
P34908        (WS-MAIL-GL-ACCT-AMT <= -1000000000)                      
P34908       IF WS-FIRST-READ                                           
P34908          OPEN OUTPUT FCSMA126-FILE                               
P34908          PERFORM 8300-WRITE-MAIL-HEADING THRU 8300-EXIT          
P34908          MOVE 'N' TO WS-FIRST-READ-FLAG                          
P34908          MOVE +03 TO RETURN-CODE                                 
P34908       END-IF                                                     
P34908       MOVE WS-GL-NO-D-LOC-OFF        TO MAIL-LOCAL-OFFICE        
P34908       MOVE WS-KEY-REVENUE-MNTH       TO MAIL-REVENUE-MTH         
P34908       MOVE WS-GL12-KEY               TO MAIL-GL-REC              
P34908       MOVE WS-GL-DR-AMT-POSTED       TO MAIL-DEB-AMT             
P34908       MOVE WS-GL-CR-AMT-POSTED       TO MAIL-CRED-AMT            
P34908       WRITE FCSMA126-REC FROM MAIL-DETAIL                        
P34908     END-IF.                                                      
      *                                                                         
           MOVE WS-CURRENT-DATE-YMD          TO GL-DATE-LAST-TRANS.     
           PERFORM 8600-UPDATE-GL-ACCT-REF      THRU 8600-EXIT.         
      *                                                                         
           PERFORM 5010-UPDATE-GL-MNTHLY-TOT THRU 5010-EXIT.            
      *****************************************************************         
      *                                                               *         
      * 5000-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       5000-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  5010-UDATE-GL-MNTHLY-TOT.                                     *        
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       5010-UPDATE-GL-MNTHLY-TOT.                                       
           MOVE WS-LOC-OFF-NO-KEY     TO GY-LOCAL-OFFICE.               
           MOVE WS-KEY-COMPANY-NO     TO GY-COMPANY-NO.                 
           MOVE WS-GL12-KEY           TO GY-GL-ACCT-NO.                 
           MOVE WS-ACCTNG-PER-DATE-CYM TO GY-ACCTING-PERIOD.            
           PERFORM 7200-SELECT-GL-MONTHLY-TOTAL THRU 7200-EXIT.         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               MOVE ZEROS TO GY-MNTH-DR-AMT                             
                             GY-MNTH-CR-AMT                             
           END-IF.                                                      
      *                                                                         
           IF GY-MNTH-DR-AMT     NUMERIC                                
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE ZEROS TO GY-MNTH-DR-AMT                             
           END-IF.                                                      
      *                                                                         
           IF GY-MNTH-CR-AMT     NUMERIC                                
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE ZEROS TO GY-MNTH-CR-AMT                             
           END-IF.                                                      
      *                                                                         
           ADD WS-GL-DR-AMT-POSTED TO GY-MNTH-DR-AMT.                   
           ADD WS-GL-CR-AMT-POSTED TO GY-MNTH-CR-AMT.                   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 8610-UPDATE-GL-MONTHLY-TOTAL  THRU 8610-EXIT     
           ELSE                                                         
               MOVE WS-N TO GY-PERIOD-CLOSED-IND                        
               PERFORM 8620-INSERT-GL-MONTHLY-TOTAL  THRU 8620-EXIT     
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      *  5010-EXIT                                                    *         
      *                                                               *         
      *****************************************************************         
       5010-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  5020-CREATE-GL-ENTRY-CRNT.                                    *        
      *       THIS PARAGRAPH CREATES THE GE ENTRY     TO CORRESSPOND   *        
      *   TO THE JRNL ACTIVITY FOR THIS ACCOUNT.  THIS PARAGRAPH IS    *        
      *   PROCESSED EITHER ONCE OR TWICE DEPENDING ON HOW MANY GE'S    *        
      *   ARE REQUIRED.                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       5020-CREATE-GL-ENTRY-CRNT.                                       
           MOVE WS-CURRENT-DATE-YMD           TO GE-DATE-TRAN-ENTRY.    
           MOVE WS-ACCTNG-PER-DATE-CYM        TO GE-ACCT-PERIOD-AFFCTD. 
           MOVE WS-LOC-OFF-NO-KEY             TO GE-LOCAL-OFFICE.       
           MOVE WS-GL-NO-KEY                  TO GE-GL-ACCT-NO.         
           MOVE WS-GL-COST-CENTER             TO GE-COST-CENTER.        
           MOVE WS-GL-TRAN-CODE-JRNL-ENT-SRCE TO GE-TRAN-ENTRY-SRCE.    
           MOVE WS-GL-TRAN-JRNL-ENT-NO        TO GE-TRAN-ENTRY-VCHR-NO. 
           MOVE WS-GL-TRAN-AMT-POSTED         TO GE-AMT-TRAN-ENTRY.     
           MOVE WS-GL-TRAN-CODE-DR-CR         TO GE-GL-CNTRL-DR-CR.     
      *    MOVE WS-GL-TRAN-OFF-SET-GL-NO      TO GE-GL-OFFSET-ACCT-NO.          
      *    MOVE WS-GL-TRAN-RESP-ID            TO GE-RESP-ID.                    
      *    MOVE WS-GL-TRAN-CODE-REF-NO-TYPE   TO GE-CODE-REF-NO-TYPE.           
           MOVE WS-GL-TRAN-TRAN-DESCRIPTION   TO GE-TRAN-DESC.          
      *    MOVE WS-GL-TRAN-CODE-REG-TYPE      TO GE-CODE-REG-TYPE.              
      *    MOVE WS-GL-TRAN-REG-NO             TO GE-REGISTER-NO.                
      *    MOVE WS-GL-TRAN-CHECK-NO           TO GE-CHECK-NO.                   
      *    MOVE WS-GL-TRAN-CHECK-ISSUE-DATE   TO GE-DATE-CHECK-ISSUED.          
           MOVE WS-GL-CODE-PUB-AUTH           TO GE-PUB-AUTH-CD.        
           MOVE WS-GL-BENE-COST-CENTER                                  
                                 TO GE-BENEFIT-COST-CNTR.               
           MOVE WS-GL-NOE-CODE                TO GE-NOE-CODE.           
           MOVE WS-GL-CODE-PROP-UNIT TO GE-PROPERTY-UNIT-CD.            
           MOVE WS-GL-QUANTITY-ENTERED        TO GE-QUANTITY-ENTERED.   
           MOVE WS-GL-CODE-UNIT-OF-MEASURE   TO GE-UNIT-OF-MEASURE-CD.  
           MOVE WS-GL-CODE-FUNCTION           TO GE-FUNCTION-CODE.      
           MOVE WS-GL-COMPANY-NO              TO GE-COMPANY-NO.         
           MOVE WS-GL-WORK-ORDER-NO           TO GE-WORK-ORDER-NO.      
           MOVE WS-GL-WORK-ORDER-CLASS        TO GE-WORK-ORDER-TYPE.    
PCR287     MOVE WS-GL-REV-DISTRICT-CD         TO GE-REV-DISTRICT-CD.    
           PERFORM 8630-INSERT-GL-ENTRY-CRNT THRU 8630-EXIT.            
PCR626     IF WS-USE-SUBST-GL                                           
PCR626        MOVE WS-SUBSTITUTE-GL TO GE-GL-ACCT-NO                    
PCR626        PERFORM 8630-INSERT-GL-ENTRY-CRNT THRU 8630-EXIT          
PCR626        MOVE WS-NO TO WS-SUBST-GL-SWITCH                          
      *                                                                         
PCR626        MOVE WS-SUBSTITUTE-GL TO WS-GL12-KEY                      
PCR626        MOVE WS-GL1-KEY       TO WS-GL-NO-M-MAJOR                 
PCR626        MOVE WS-GL2-KEY       TO WS-GL-NO-M-MINOR                 
PCR626        MOVE WS-SUBSTITUTE-GL TO WS-KEY-GL-ACCOUNT-NO             
PCR626        MOVE WS-SUBSTITUTE-GL TO WS-GL-NO-KEY                     
PCR626        MOVE WS-LOC-OFF-NO-KEY TO WS-GL-NO-D-LOC-OFF              
T16325        MOVE WS-GL-NO-MMD TO WS-GL-ACCT-NO-GL-TRAN                
PCR626     END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS                
               PERFORM 5021-ELIMINATE-DUP-GTE THRU 5021-EXIT            
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL    
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 5020-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       5020-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 5021-ELIMINATE-DUP-GTE                                        *         
      *                                                               *         
      *****************************************************************         
       5021-ELIMINATE-DUP-GTE.                                          
           PERFORM 8630-INSERT-GL-ENTRY-CRNT THRU 8630-EXIT.            
PCR626     IF WS-USE-SUBST-GL                                           
PCR626        MOVE WS-SUBSTITUTE-GL TO GE-GL-ACCT-NO                    
PCR626        MOVE WS-NO            TO WS-SUBST-GL-SWITCH               
PCR626        PERFORM 8630-INSERT-GL-ENTRY-CRNT THRU 8630-EXIT          
PCR626     END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 5021-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       5021-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 5100-LOAD-GL-TRAN-WORK-AREA                                   *         
      *                                                               *         
      *****************************************************************         
       5100-LOAD-GL-TRAN-WORK-AREA.                                     
           MOVE WS-1                  TO WS-JRNL-SORT-ID-GL-TRAN.       
           MOVE WS-CURRENT-DATE-YMD   TO WS-TRAN-DATE-GL-TRAN.          
           MOVE WS-999999S            TO WS-TRAN-TIME-GL-TRAN.          
           MOVE WS-GA01               TO WS-CODE-TERMINAL-TRAN-GL-TRAN. 
           MOVE WS-1                  TO WS-JRNL-TRAN-APPL-NO-GL-TRAN.  
           MOVE ZEROS                 TO WS-DUP-CONTROL-KEY-GL-TRAN.    
           MOVE ZEROS                 TO WS-DATE-LAST-ACTION-GL-TRAN.   
           MOVE WS-S                  TO WS-CODE-ENTRY-SOURCE-GL-TRAN.  
           MOVE SPACES                TO WS-OPER-ID-GL-TRAN.            
           MOVE ZEROS                 TO WS-BATCH-SEND-LOC-GL-TRAN      
                                         WS-ENTRY-LOC-OFF-GL-TRAN.      
           MOVE SPACES                TO WS-TRANS-ERRORS-GL-TRAN.       
           MOVE WS-201                TO WS-GL-TRAN-JRNL-FORMAT-NO.     
           MOVE SPACES                TO WS-GL-TRAN-CASH-DRAWER-USED.   
           MOVE ZEROS                 TO WS-GL-TRAN-AMT-ENTERED         
                                         WS-GL-TRAN-AMT-POSTED.         
           MOVE SPACES                TO WS-GL-TRAN-CODE-DR-CR.         
           MOVE WS-ACCTNG-PER-DATE-CYM TO WS-GL-TRAN-ACCTING-PERIOD.    
           MOVE WS-E                  TO WS-GL-TRAN-CODE-JRNL-ENT-SRCE. 
           MOVE ZEROS                 TO WS-GL-TRAN-JRNL-ENT-NO.        
           MOVE ZEROS                 TO WS-GL-TRAN-OFF-SET-GL-NO       
                                         WS-GL-TRAN-RESP-ID.            
           MOVE WS-E                  TO WS-GL-TRAN-CODE-REF-NO-TYPE.   
           MOVE SPACES                TO WS-GL-TRAN-REF-NO.             
           MOVE SPACES                TO WS-GL-TRAN-TRAN-DESCRIPTION    
                                         WS-GL-TRAN-CODE-REG-TYPE.      
           MOVE ZEROS                 TO WS-GL-TRAN-REG-NO              
                                         WS-GL-TRAN-CHECK-NO            
                                         WS-GL-TRAN-CHECK-ISSUE-DATE.   
           MOVE SPACES                TO WS-GL-CODE-PUB-AUTH            
                                         WS-GL-CODE-PROP-UNIT           
                                         WS-GL-CODE-UNIT-OF-MEASURE     
                                         WS-GL-WORK-ORDER-NO            
T11109                                   WS-GL-NOE-CODE                 
T11109                                   WS-GL-COST-CENTER              
T11109                                   WS-GL-BENE-COST-CENTER         
                                         WS-GL-WORK-ORDER-CLASS.        
           MOVE ZEROES                TO WS-GL-REV-DISTRICT-CD          
PCR287                                   WS-GL-QUANTITY-ENTERED.        
      *****************************************************************         
      *                                                               *         
      * 5100-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       5100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ****************************************************************          
      *                                                              *          
      * 5110-LOAD-ARM-TRAN-WORK-AREA                                 *          
      *                                                              *          
      ****************************************************************          
       5110-LOAD-ARM-TRAN-WORK-AREA.                                    
           MOVE E-FCA09-TRAN-DATA TO CJF00105.                          
           MOVE WS-CURRENT-DATE-YMD   TO WS-TRAN-DATE-GL-TRAN.          
           MOVE WS-999999S            TO WS-TRAN-TIME-GL-TRAN.          
           MOVE WS-GA01               TO WS-CODE-TERMINAL-TRAN-GL-TRAN. 
           MOVE WS-105-JRNL-FORMAT-NO TO WS-GL-TRAN-JRNL-FORMAT-NO.     
           MOVE WS-105-CASH-DRAWER-USED TO WS-GL-TRAN-CASH-DRAWER-USED. 
           MOVE WS-105-AMOUNT-ENTERED TO WS-GL-TRAN-AMT-ENTERED.        
           MOVE WS-105-AMT-POSTED     TO WS-GL-TRAN-AMT-POSTED.         
           MOVE WS-105-CODE-PUB-AUTHORITY TO WS-GL-CODE-PUB-AUTH.       
           MOVE WS-105-BENE-COST-CENTER TO WS-GL-BENE-COST-CENTER.      
           MOVE WS-105-COST-CENTER TO WS-GL-COST-CENTER.                
           MOVE WS-105-NATURE-OF-EXPENDITURE TO WS-GL-NOE-CODE.         
           MOVE WS-105-CODE-PROPERTY-UNIT TO WS-GL-CODE-PROP-UNIT.      
           MOVE WS-105-QUANTITY-ENTERED TO WS-GL-QUANTITY-ENTERED.      
           MOVE WS-105-CODE-UNIT-OF-MEASURE TO                          
                                         WS-GL-CODE-UNIT-OF-MEASURE.    
           MOVE WS-105-CODE-WORK-ORDER-NO TO WS-GL-WORK-ORDER-NO.       
           MOVE WS-105-CODE-WORK-ORDER-CLASS                            
                                      TO WS-GL-WORK-ORDER-CLASS.        
PCR287     MOVE WS-105-CODE-REVENUE-DISTRICT TO WS-GL-REV-DISTRICT-CD.  
           MOVE WS-GA01               TO WS-CODE-TERMINAL-TRAN-GL-TRAN. 
           MOVE WS-1                  TO WS-JRNL-TRAN-APPL-NO-GL-TRAN.  
           MOVE ZEROS                 TO WS-DUP-CONTROL-KEY-GL-TRAN.    
           MOVE ZEROS                 TO WS-DATE-LAST-ACTION-GL-TRAN.   
           MOVE WS-S                  TO WS-CODE-ENTRY-SOURCE-GL-TRAN.  
           MOVE SPACES                TO WS-OPER-ID-GL-TRAN.            
           MOVE ZEROS                 TO WS-BATCH-SEND-LOC-GL-TRAN      
                                         WS-ENTRY-LOC-OFF-GL-TRAN.      
           MOVE SPACES                TO WS-TRANS-ERRORS-GL-TRAN.       
           MOVE SPACES                TO WS-GL-TRAN-CODE-DR-CR.         
           MOVE WS-ACCTNG-PER-DATE-CYM TO WS-GL-TRAN-ACCTING-PERIOD.    
           MOVE WS-E                  TO WS-GL-TRAN-CODE-JRNL-ENT-SRCE. 
           MOVE ZEROS                 TO WS-GL-TRAN-JRNL-ENT-NO.        
           MOVE ZEROS                 TO WS-GL-TRAN-OFF-SET-GL-NO       
                                         WS-GL-TRAN-RESP-ID.            
           MOVE WS-E                  TO WS-GL-TRAN-CODE-REF-NO-TYPE.   
           MOVE SPACES                TO WS-GL-TRAN-REF-NO.             
           MOVE SPACES                TO WS-GL-TRAN-TRAN-DESCRIPTION    
                                         WS-GL-TRAN-CODE-REG-TYPE.      
           MOVE ZEROS                 TO WS-GL-TRAN-REG-NO              
                                         WS-GL-TRAN-CHECK-NO            
                                         WS-GL-TRAN-CHECK-ISSUE-DATE.   
      ****************************************************************          
      *                                                              *          
      * 5110-EXIT.                                                   *          
      *                                                              *          
      ****************************************************************          
       5110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 6500-GET-DATABASE.                                            *         
      *     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
      *****************************************************************         
      *                                                                         
       6500-GET-DATABASE.                                               
      *                                                                         
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
               AND  COMPANY_NO = :C8-COMPANY-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE C8-DELINQ-VALUE          TO WS-DATABASE             
           ELSE                                                         
               MOVE '6500' TO WS-ACTIVE-PARAGRAPH                       
               DISPLAY '*** ABEND IN PARA 6500 ***'                     
               DISPLAY '*** SQLCODE = ' SQLCODE                         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       6500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00040                                                 
           END-EXEC.                                                            
       COPY CPD00037.                                                           
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *                                                              *          
      * 7070-POSITION-FCSCA09                                        *          
      *                                                              *          
      ****************************************************************          
HEMA3 *7070-POSITION-FCSCA09.                                                   
HEMA3 *    MOVE WS-ZERO-RECORD-CA09  TO E-FCA09-KEY.                            
HEMA3 *                                                                         
HEMA3 *    READ FCSCA09-FILE.                                                   
HEMA3 *    IF FCA09-SUCCESSFUL                                                  
HEMA3 *       NEXT SENTENCE                                                     
HEMA3 *    ELSE                                                                 
HEMA3 *       MOVE '**** READ ERROR - CA09' TO P-STATUS-KEY-ERROR-MSG           
HEMA3 *       MOVE WS-FCA09-STATUS TO P-STATUS-KEY                              
HEMA3 *       MOVE 7070 TO P-PARAGRAPH-NUMBER                                   
HEMA3 *       PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE  THRU 8910-EXIT            
HEMA3 *    END-IF.                                                              
HEMA3 *    MOVE E-FCA09-GL-ACCT-NO TO WS-KEY-GL-ACCOUNT-NO.                     
HEMA3 *    MOVE E-FCA09-LOCAL-OFFICE TO WS-KEY-LOC-OFF-CODE.                    
HEMA3 *    MOVE E-FCA09-COMPANY-NO TO WS-KEY-COMPANY-NO.                        
HEMA3 *                                                                         
HEMA3 *****************************************************************         
HEMA3 *                                                               *         
HEMA3 * 7070-EXIT                                                     *         
HEMA3 *                                                               *         
HEMA3 *****************************************************************         
HEMA3 *7070-EXIT.                                                               
HEMA3 *    EXIT.                                                                
      *****************************************************************         
      *                                                               *         
      * 7080-READ-NEXT-FCSCA09                                        *         
      *                                                               *         
      *****************************************************************         
       7080-READ-NEXT-FCSCA09.                                          
           READ FCSCA09-FILE NEXT RECORD.                               
           IF WS-FCA09-STATUS EQUAL '00'                                
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-FCA09-STATUS EQUAL '10'                             
                  MOVE WS-YES TO WS-LAST-SEQ-CA09-REC                   
                  GO TO 7080-EXIT                                       
              ELSE                                                      
               MOVE '**** READ  ERROR - CA09 ' TO P-STATUS-KEY-ERROR-MSG
               MOVE WS-FCA09-STATUS TO P-STATUS-KEY                     
               MOVE 2200 TO P-PARAGRAPH-NUMBER                          
               PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT    
              END-IF                                                    
           END-IF.                                                      
           IF  WS-KEY-GL-ACCOUNT-NO        EQUAL ZEROES  AND            
               WS-KEY-LOC-OFF-CODE         EQUAL SPACES  AND            
               WS-KEY-COMPANY-NO           EQUAL SPACES                 
               MOVE E-FCA09-GL-ACCT-NO        TO WS-KEY-GL-ACCOUNT-NO   
               MOVE E-FCA09-LOCAL-OFFICE      TO WS-KEY-LOC-OFF-CODE    
               MOVE E-FCA09-COMPANY-NO        TO WS-KEY-COMPANY-NO      
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 7080-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       7080-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      ****************************************************************          
      *                                                              *          
      * 7100-SELECT-GL-ACCT-REF                                      *          
      *                                                              *          
      ****************************************************************          
       7100-SELECT-GL-ACCT-REF.                                         
           EXEC SQL                                                     
                SELECT                                                  
                   ACCT_BALANCE,                                        
                   AMT_PER_DR_POSTED,                                   
                   AMT_PER_CR_POSTED,                                   
                   DATE_LAST_TRANS                                      
                INTO                                                    
                   :GL-ACCT-BALANCE,                                    
                   :GL-AMT-PER-DR-POSTED,                               
                   :GL-AMT-PER-CR-POSTED,                               
                   :GL-DATE-LAST-TRANS                                  
                FROM CSS_GL_ACCOUNT                                     
                WHERE  GL_ACCT_NO    = :GL-GL-ACCT-NO    AND            
                       LOCAL_OFFICE = :GL-LOCAL-OFFICE   AND            
                       COMPANY_NO   = :GL-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
T13673         DISPLAY '** 7100-SELECT-GL-ACCT-REF'                     
T13673         DISPLAY '** COMPANY = ' GL-COMPANY-NO                    
T13673                 ' LOCAL OFFICE = ' GL-LOCAL-OFFICE               
T13673                 'GL ACCT NO = ' GL-GL-ACCT-NO                    
T13673         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
T13673         PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 7100-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       7100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      *7200-SELECT-GL_MNTHLY-TOT                                      *         
      *                                                               *         
      *****************************************************************         
       7200-SELECT-GL-MONTHLY-TOTAL.                                    
           EXEC SQL                                                     
                SELECT                                                  
                   MNTH_DR_AMT, MNTH_CR_AMT                             
                INTO                                                    
                   :GY-MNTH-DR-AMT, :GY-MNTH-CR-AMT                     
              FROM CSS_GL_MNTHLY_TOT                                    
              WHERE  GL_ACCT_NO     = :GY-GL-ACCT-NO    AND             
                     COMPANY_NO     = :GY-COMPANY-NO    AND             
                     LOCAL_OFFICE   = :GY-LOCAL-OFFICE  AND             
                     ACCTING_PERIOD = :GY-ACCTING-PERIOD                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
T13673         DISPLAY '** 7200-SELECT-GL-MONTHLY-TOTAL'                
T13673         DISPLAY '** COMPANY = ' GY-COMPANY-NO                    
T13673                 ' LOCAL OFFICE = ' GY-LOCAL-OFFICE               
T13673                 'GL ACCT NO = ' GY-GL-ACCT-NO                    
T13673                 ' ACCTING PERIOD = ' GY-ACCTING-PERIOD           
T13673         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
T13673         PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 7200-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       7200-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
P34908* 8300-WRITE MAIL HEADING                                      *          
P34908*                                                              *          
P34908****************************************************************          
P34908*                                                                         
P34908 8300-WRITE-MAIL-HEADING.                                         
      *                                                                         
P34908     MOVE SPACES TO MAIL7-SUBJECT.                                
P34908     MOVE WS-YMD-YY              TO WS-DAT-YY.                    
P34908     MOVE WS-YMD-MM              TO WS-DAT-MM.                    
P34908     MOVE WS-YMD-DD              TO WS-DAT-DD.                    
P34908     IF CSR-DATABASE                                              
P34908        STRING 'CSRP GL TRUNCATION ' DELIMITED BY SIZE,           
P34908               WS-DATE-TEMP DELIMITED BY SIZE,                    
P34908               INTO MAIL7-SUBJECT                                 
P34908        MOVE 'CSRC126' TO MAIL2-JOB-NAME                          
P34908     ELSE                                                         
P34908        STRING 'SEBP GL TRUNCATION ' DELIMITED BY SIZE,           
P34908               WS-DATE-TEMP DELIMITED BY SIZE,                    
P34908               INTO MAIL7-SUBJECT                                 
P34908        MOVE 'SEBC126' TO MAIL2-JOB-NAME                          
P34908     END-IF.                                                      
P34908     WRITE FCSMA126-REC FROM MAILHEAD-1.                          
P34908                                                                  
P34908     WRITE FCSMA126-REC FROM MAILHEAD-2.                          
P34908                                                                  
P34908     WRITE FCSMA126-REC FROM MAILHEAD-3.                          
P34908     WRITE FCSMA126-REC FROM MAILHEAD-4.                          
P34908                                                                  
P34908     WRITE FCSMA126-REC FROM MAILHEAD-6.                          
P34908     WRITE FCSMA126-REC FROM MAILHEAD-7.                          
P34908     WRITE FCSMA126-REC FROM MAILHEAD-8.                          
P34908     WRITE FCSMA126-REC FROM MAILHEAD-10.                         
P34908     WRITE FCSMA126-REC FROM MAILHEAD-11.                         
P34908     WRITE FCSMA126-REC FROM MAILHEAD-8.                          
      *                                                                         
P34908 8300-EXIT.                                                       
P34908     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                              *          
      * 8600-UPDATE-GL-TRIAL-BALANCE                                 *          
      *                                                              *          
      ****************************************************************          
       8600-UPDATE-GL-ACCT-REF.                                         
           EXEC SQL                                                     
                UPDATE CSS_GL_ACCOUNT                                   
                   SET  ACCT_BALANCE       = :GL-ACCT-BALANCE,          
                        AMT_PER_DR_POSTED  = :GL-AMT-PER-DR-POSTED,     
                        AMT_PER_CR_POSTED  = :GL-AMT-PER-CR-POSTED,     
                        DATE_LAST_TRANS    = IIF(TRY_CONVERT(DATE, 
                                                    :GL-DATE-LAST-TRANS
              ) IS NULL OR (PATINDEX('%.%', :GL-DATE-LAST-TRANS
              ) <> 0) OR (LEN(:GL-DATE-LAST-TRANS
              ) <> 10), CIS.CHAR2DATE(:GL-DATE-LAST-TRANS
              ), CONVERT(DATE, :GL-DATE-LAST-TRANS) )        
                WHERE  GL_ACCT_NO    = :GL-GL-ACCT-NO    AND            
                       LOCAL_OFFICE  = :GL-LOCAL-OFFICE  AND            
                       COMPANY_NO    = :GL-COMPANY-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_GL_ACCOUNT                                           
MFA-TR*            SET  ACCT_BALANCE       = :GL-ACCT-BALANCE,                  
MFA-TR*                 AMT_PER_DR_POSTED  = :GL-AMT-PER-DR-POSTED,             
MFA-TR*                 AMT_PER_CR_POSTED  = :GL-AMT-PER-CR-POSTED,             
MFA-TR*                 DATE_LAST_TRANS    = :GL-DATE-LAST-TRANS                
MFA-TR*         WHERE  GL_ACCT_NO    = :GL-GL-ACCT-NO    AND                    
MFA-TR*                LOCAL_OFFICE  = :GL-LOCAL-OFFICE  AND                    
MFA-TR*                COMPANY_NO    = :GL-COMPANY-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
T13673         DISPLAY '** 8600-UPDATE-GL-ACCT-REF'                     
T13673         DISPLAY '** COMPANY = ' GL-COMPANY-NO                    
T13673                 ' LOCAL OFFICE = ' GL-LOCAL-OFFICE               
T13673                 'GL ACCT NO = ' GL-GL-ACCT-NO                    
T13673         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
T13673         PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 8600-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       8600-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 8610-UDPATE-GL-MONTHLY-TOTAL                                  *         
      *                                                               *         
      *****************************************************************         
       8610-UPDATE-GL-MONTHLY-TOTAL.                                    
           EXEC SQL                                                     
                UPDATE  CSS_GL_MNTHLY_TOT                               
                SET  MNTH_DR_AMT  =  :GY-MNTH-DR-AMT,                   
                     MNTH_CR_AMT  =  :GY-MNTH-CR-AMT                    
              WHERE  GL_ACCT_NO    = :GY-GL-ACCT-NO    AND              
                     COMPANY_NO    = :GY-COMPANY-NO    AND              
                     LOCAL_OFFICE  = :GY-LOCAL-OFFICE  AND              
                     ACCTING_PERIOD = :GY-ACCTING-PERIOD                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
T13673         DISPLAY '** 8610-UPDATE-GL-MONTHLY-TOTAL'                
T13673         DISPLAY '** COMPANY = ' GY-COMPANY-NO                    
T13673                 ' LOCAL OFFICE = ' GY-LOCAL-OFFICE               
T13673                 'GL ACCT NO = ' GY-GL-ACCT-NO                    
T13673                 'ACCTING PERIOD = ' GY-ACCTING-PERIOD            
T13673         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
T13673         PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 8610-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       8610-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * 8620-INSERT-GL-MONTHLY-TOTAL                                 *          
      *                                                              *          
      ****************************************************************          
       8620-INSERT-GL-MONTHLY-TOTAL.                                    
           EXEC SQL                                                     
                INSERT INTO CSS_GL_MNTHLY_TOT                           
                (GL_ACCT_NO,                                            
                 LOCAL_OFFICE,                                          
                 COMPANY_NO,                                            
                 ACCTING_PERIOD,                                        
                 MNTH_DR_AMT,                                           
                 MNTH_CR_AMT,                                           
                 PERIOD_CLOSED_IND)                                     
                VALUES                                                  
                (:GY-GL-ACCT-NO,                                        
                 :GY-LOCAL-OFFICE,                                      
                 :GY-COMPANY-NO,                                        
                 :GY-ACCTING-PERIOD,                                    
                 :GY-MNTH-DR-AMT,                                       
                 :GY-MNTH-CR-AMT,                                       
                 :GY-PERIOD-CLOSED-IND)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
T13673         DISPLAY '** 8620-INSERT-GL-MONTHLY-TOTAL'                
T13673         DISPLAY '** COMPANY = ' GY-COMPANY-NO                    
T13673                 ' LOCAL OFFICE = ' GY-LOCAL-OFFICE               
T13673                 'GL ACCT NO = ' GY-GL-ACCT-NO                    
T13673                 'ACCTING PERIOD = ' GY-ACCTING-PERIOD            
T13673         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
T13673         PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *****************************************************************         
      *                                                               *         
      * 8620-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       8620-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 8630-INSERT-GL-ENTRY-CRNT                                     *         
      *                                                               *         
      *****************************************************************         
       8630-INSERT-GL-ENTRY-CRNT.                                       
           EXEC SQL                                                     
T35434          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :GE-ENTRY-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :GE-ENTRY-NO  =  CURRENT TIMESTAMP                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T35434          MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                  
                IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL       
                   NEXT SENTENCE                                        
                ELSE                                                    
T35434             DISPLAY 'CURRENT TIMESTAMP '                         
T35434             DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE        
T35434             PERFORM 9900-ABEND THRU 9900-EXIT                    
T35434          END-IF.                                                 
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_GL_ENTRY_CRNT                           
                (DATE_TRAN_ENTRY,                                       
                 ACCT_PERIOD_AFFCTD,                                    
                 GL_ACCT_NO,                                            
                 ENTRY_NO,                                              
                 TRAN_ENTRY_SRCE,                                       
                 TRAN_ENTRY_VCHR_NO,                                    
                 GL_CNTRL_DR_CR,                                        
                 AMT_TRAN_ENTRY,                                        
                 TRAN_DESC,                                             
                 WORK_ORDER_NO,                                         
                 NOE_CODE,                                              
                 COST_CODE_TYPE,                                        
                 PROPERTY_UNIT_CD,                                      
                 BENEFIT_COST_CNTR,                                     
                 PUB_AUTH_CD,                                           
                 QUANTITY_ENTERED,                                      
                 UNIT_OF_MEASURE_CD,                                    
                 FUNCTION_CODE,                                         
                 OFST_LOC_OFCE,                                         
                 COMPANY_NO,                                            
                 WORK_ORDER_TYPE,                                       
                 COST_CENTER,                                           
PCR287           REV_DISTRICT_CD,                                       
                 LOCAL_OFFICE)                                          
                VALUES                                                  
                (IIF(TRY_CONVERT(DATE, :GE-DATE-TRAN-ENTRY
              ) IS NULL OR (PATINDEX('%.%', :GE-DATE-TRAN-ENTRY
              ) <> 0) OR (LEN(:GE-DATE-TRAN-ENTRY
              ) <> 10), CIS.CHAR2DATE(:GE-DATE-TRAN-ENTRY
              ), CONVERT(DATE, :GE-DATE-TRAN-ENTRY) ),                         
                 :GE-ACCT-PERIOD-AFFCTD,                                
                 :GE-GL-ACCT-NO,                                        
                 CIS.CHAR2TIMESTAMP(:GE-ENTRY-NO),                              
                 :GE-TRAN-ENTRY-SRCE,                                   
                 :GE-TRAN-ENTRY-VCHR-NO,                                
                 :GE-GL-CNTRL-DR-CR,                                    
                 :GE-AMT-TRAN-ENTRY,                                    
                 :GE-TRAN-DESC,                                         
                 :GE-WORK-ORDER-NO,                                     
                 :GE-NOE-CODE,                                          
                 :GE-COST-CODE-TYPE,                                    
                 :GE-PROPERTY-UNIT-CD,                                  
                 :GE-BENEFIT-COST-CNTR,                                 
                 :GE-PUB-AUTH-CD,                                       
                 :GE-QUANTITY-ENTERED,                                  
                 :GE-UNIT-OF-MEASURE-CD,                                
                 :GE-FUNCTION-CODE,                                     
                 :GE-OFST-LOC-OFCE,                                     
                 :GE-COMPANY-NO,                                        
                 :GE-WORK-ORDER-TYPE,                                   
                 :GE-COST-CENTER,                                       
PCR287           :GE-REV-DISTRICT-CD,                                   
                 :GE-LOCAL-OFFICE)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_GL_ENTRY_CRNT                                   
MFA-TR*         (DATE_TRAN_ENTRY,                                               
MFA-TR*          ACCT_PERIOD_AFFCTD,                                            
MFA-TR*          GL_ACCT_NO,                                                    
MFA-TR*          ENTRY_NO,                                                      
MFA-TR*          TRAN_ENTRY_SRCE,                                               
MFA-TR*          TRAN_ENTRY_VCHR_NO,                                            
MFA-TR*          GL_CNTRL_DR_CR,                                                
MFA-TR*          AMT_TRAN_ENTRY,                                                
MFA-TR*          TRAN_DESC,                                                     
MFA-TR*          WORK_ORDER_NO,                                                 
MFA-TR*          NOE_CODE,                                                      
MFA-TR*          COST_CODE_TYPE,                                                
MFA-TR*          PROPERTY_UNIT_CD,                                              
MFA-TR*          BENEFIT_COST_CNTR,                                             
MFA-TR*          PUB_AUTH_CD,                                                   
MFA-TR*          QUANTITY_ENTERED,                                              
MFA-TR*          UNIT_OF_MEASURE_CD,                                            
MFA-TR*          FUNCTION_CODE,                                                 
MFA-TR*          OFST_LOC_OFCE,                                                 
MFA-TR*          COMPANY_NO,                                                    
MFA-TR*          WORK_ORDER_TYPE,                                               
MFA-TR*          COST_CENTER,                                                   
MFA-TR*          REV_DISTRICT_CD,                                               
MFA-TR*          LOCAL_OFFICE)                                                  
MFA-TR*         VALUES                                                          
MFA-TR*         (:GE-DATE-TRAN-ENTRY,                                           
MFA-TR*          :GE-ACCT-PERIOD-AFFCTD,                                        
MFA-TR*          :GE-GL-ACCT-NO,                                                
MFA-TR*          :GE-ENTRY-NO,                                                  
MFA-TR*          :GE-TRAN-ENTRY-SRCE,                                           
MFA-TR*          :GE-TRAN-ENTRY-VCHR-NO,                                        
MFA-TR*          :GE-GL-CNTRL-DR-CR,                                            
MFA-TR*          :GE-AMT-TRAN-ENTRY,                                            
MFA-TR*          :GE-TRAN-DESC,                                                 
MFA-TR*          :GE-WORK-ORDER-NO,                                             
MFA-TR*          :GE-NOE-CODE,                                                  
MFA-TR*          :GE-COST-CODE-TYPE,                                            
MFA-TR*          :GE-PROPERTY-UNIT-CD,                                          
MFA-TR*          :GE-BENEFIT-COST-CNTR,                                         
MFA-TR*          :GE-PUB-AUTH-CD,                                               
MFA-TR*          :GE-QUANTITY-ENTERED,                                          
MFA-TR*          :GE-UNIT-OF-MEASURE-CD,                                        
MFA-TR*          :GE-FUNCTION-CODE,                                             
MFA-TR*          :GE-OFST-LOC-OFCE,                                             
MFA-TR*          :GE-COMPANY-NO,                                                
MFA-TR*          :GE-WORK-ORDER-TYPE,                                           
MFA-TR*          :GE-COST-CENTER,                                               
MFA-TR*          :GE-REV-DISTRICT-CD,                                           
MFA-TR*          :GE-LOCAL-OFFICE)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           WS-GLE-INSERT-RETURN.                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR ALREADY-EXISTS                                       
              NEXT SENTENCE                                             
           ELSE                                                         
PCR626         PERFORM 8890-COUNT-VALID  THRU 8890-EXIT                 
           END-IF.                                                      
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8630-EXIT                                                     *         
      *                                                               *         
      *****************************************************************         
       8630-EXIT.                                                       
           EXIT.                                                        
PCR626****************************************************************          
PCR626*                                                              *          
A04880* 8890-COUNT-VALID                                             *          
A04880*     TO VALID THE INVALID GL COUNT FOR AVOID THE ABEND.       *          
PCR626*                                                              *          
PCR626****************************************************************          
      *                                                                         
A04880 8890-COUNT-VALID.                                                
      *                                                                         
           ADD 1                      TO  WS-INVALID-GL-CNT.            
           MOVE WS-YES                TO  WS-SUBST-GL-SWITCH.           
      *                                                                         
ABEND **************************************************************            
ABEND * WS-INVALID-GL-CNT # CHANGED FROM 10 TO 25 ON 6/9/99        *            
ABEND *   TO AVOID ABEND                                           *            
ABEND **************************************************************            
T23246     IF WS-INVALID-GL-CNT > 50                                    
             DISPLAY '**********************************************'   
             DISPLAY '*  THE NUMBER OF INVALID GL #S HAS EXCEEDED  *'   
             DISPLAY '*  TWENTY-FIVE.  THERE MAY BE A PROBLEM      *'   
             DISPLAY '*        WITH THE GL ACCOUNT TABLE.          *'   
             DISPLAY '*    TERMINATING PROCESSING IN PARA 8895     *'   
             DISPLAY '**********************************************'   
             PERFORM 9900-ABEND                THRU 9900-EXIT           
           END-IF.                                                      
PCR626     IF GE-GL-ACCT-NO EQUAL WS-SUBSTITUTE-GL AND                  
PCR626        WS-GLE-INSERT-RETURN NOT EQUAL TO SUCCESSFUL-CALL         
PCR626         DISPLAY '****************************'                   
PCR626         DISPLAY '** TERMINATING PROCESSING **'                   
PCR626         DISPLAY '** SUBSTITUTE GL#184.0026 **'                   
PCR626         DISPLAY '** IS NOT CORRECTLY SETUP **'                   
PCR626         DISPLAY '**  ATTEMPT TO INSERT IT  **'                   
PCR626         DISPLAY '**  INTO GL_ENTRY_CRNT    **'                   
PCR626         DISPLAY '**  FAILED ON SQLCODE:' WS-GLE-INSERT-RETURN    
PCR626         DISPLAY '****************************'                   
EMERFX         DISPLAY '** ACCOUNT NO ' GE-GL-ACCT-NO                   
EMERFX         DISPLAY '** LOCAL OFFICE ' GE-LOCAL-OFFICE               
EMERFX         DISPLAY '** COMPANY NO ' GE-COMPANY-NO                   
PCR626         PERFORM 9900-ABEND THRU 9900-EXIT                        
PCR626     END-IF.                                                      
      *                                                                         
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8910-PRINT-STATUS-KEY-ERR-LINE                                *         
      *                                                               *         
      *****************************************************************         
       8910-PRINT-STATUS-KEY-ERR-LINE.                                  
           DISPLAY 'VSAM STATUS ERROR - ' WS-STATUS-KEY-ERROR-LINE      
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      ****************************************************************          
      *                                                              *          
      * 8910-EXIT                                                    *          
      *                                                              *          
      ****************************************************************          
       8910-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ****************************************************************          
      *                                                              *          
      * 9000-TERMINATE                                               *          
      *                                                              *          
      ****************************************************************          
       9000-TERMINATE.                                                  
           CLOSE FCSCA09-FILE                                           
P34908           FCSMA126-FILE.                                         
      ****************************************************************          
      *                                                              *          
      * 9000-EXIT                                                    *          
      *                                                              *          
      ****************************************************************          
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *                                                              *          
      * INCLUDE USED FOR ABEND SITUATIONS                            *          
      *                                                              *          
      ****************************************************************          
            COPY CPD0023B.                                                      
            EXEC SQL                                                            
              INCLUDE CPD09900                                                  
            END-EXEC.                                                           
