       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA125.                                         
       DATE-WRITTEN.  DEC 2016.                                         
       DATE-COMPILED.                                                   
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **   THIS PROGRAM LOADS NEW TABLE CSS_RPT_GL_EXT     FROM       **        
      **   THE FCSCA07 FILE WHICH IS DAILY JOURNAL FILE.BEFORE INSERT **        
      **   DELETE 10 DAYS OLD RECORD FROM SAME TABLE.                 **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     ACCOUNT PROCESSING CONTROL PATH       **        
      **        2000 - 2999     COMMON PROGRAM MODULES                **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     NOT USED                              **        
      **        7000 - 7999     OUTPUT MODULES                        **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      *****************************************************************         
      **    DATE    INITIALS    REASON                               **         
      **    ====    ========    ======                               **         
      **  12/10/16  MR7E794     NEW CODE                             **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      * USES FILES                                                              
      *     FCSCA07 - A ESDS FILE CONSISTING OF THAT DAYS INDIRECT 'TO'         
      *               ACTIVITY.'INDIRECT'JOURNALS REQUIRING GA POSTING*         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSCA07.                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA07.                                                            
       COPY FIOCA07.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA125'.
MSQ017     COPY MFASQLM.
      *                                                                         
           COPY CWS09900.                                                       
           COPY CWS00303.                                                       
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBDELQ                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBRPTGLT                                                
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-START                  PIC X(40)                      
               VALUE 'WORKING STORAGE FOR PCSCA125 STARTS HERE'.        
           05  WS-PCB-SAVE-AREA          PIC X(75)  VALUE SPACES.       
           05  PROGRAM-NAME              PIC X(08)  VALUE 'PCSCA125'.   
           05  WS-PGRMNAME               PIC X(08)  VALUE 'PCSCA125'.   
           05  WS-END-OF-CA07            PIC X      VALUE 'N'.          
               88  END-OF-CA07                      VALUE 'Y'.          
           05  WS-FCA07-STATUS           PIC X(02).                     
               88  FCA07-SUCCESSFUL          VALUE '00'.                
           05  WS-FCA07-RECORD-CNT       PIC S9(9)  VALUE ZERO.         
           05  WS-INSERT-RPT-GLXT-CNT    PIC S9(9)  VALUE ZERO.         
           05  WS-CURRENT-TS             PIC X(26).                     
           05  WS-CURRENT-DATE           PIC X(10).                     
           05  WS-OLD-DATE               PIC X(10).                     
           05  WS-DEFAULT-DATE           PIC X(10) VALUE '0001-01-01'.  
           05  WS-DEFAULT-TIME           PIC X(08) VALUE '01.01.01'.    
           05  WS-Y                      PIC X(01)  VALUE 'Y'.          
           05  WS-1                      PIC 9(01)  VALUE 1.            
           05  WS-101                    PIC 9(05)  VALUE 00101.        
           05  WS-102                    PIC 9(05)  VALUE 00102.        
           05  WS-103                    PIC 9(05)  VALUE 00103.        
           05  WS-104                    PIC 9(05)  VALUE 00104.        
           05  WS-105                    PIC 9(05)  VALUE 00105.        
      *                                                                         
       01  WS-STATUS-KEY-ERROR-LINE.                                    
           05  FILLER                        PIC X(01)                  
               VALUE '*'.                                               
           05  WS-STATUS-KEY-ERROR-MSG       PIC X(30).                 
           05  FILLER                        PIC X(15)                  
               VALUE '  STATUS KEY = '.                                 
           05  WS-STATUS-KEY                 PIC X(02).                 
           05  FILLER                        PIC X(22)                  
               VALUE '   PARAGRAPH NUMBER = '.                          
           05  WS-PARAGRAPH-NUMBER           PIC 9(04).                 
           05  FILLER                        PIC X(58)     VALUE SPACES.
      *                                                                         
       01  WS-PROGRAM-INFO-LINE.                                        
           05  FILLER                        PIC X(10)                  
               VALUE '**********'.                                      
           05  WS-ABEND-MESSAGE               PIC X(122).               
       COPY CJF00101.                                                           
       COPY CJF00102.                                                           
       COPY CJF00103.                                                           
       COPY CJF00104.                                                           
       COPY CJF00105.                                                           
       COPY CJF0010X.                                                           
      * THIS INCLUDE IS RENAMED FOR UNIQUE DEFINITION OF ABEND-FUNCTION         
      * AND INCLUDED COPYBOOK CWS00010.                                         
       01  ABEND-FUNCTION-1.                                            
           05  WS-ABEND-SPACE             PIC X(02) VALUE SPACE.        
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC       PIC 99.                       
       01  WS-END                         PIC X(40)                     
           VALUE 'WORKING STORAGE FOR PCSCA125 ENDS HERE '.             
HPCCDM*    EJECT                                                                
       PROCEDURE DIVISION.                                              
      ****************************************************************          
      **                                                            **          
      **  0000-MAINLINE                                             **          
      **      CONTROLS MAIN PROCESSING OF PROGRAM                   **          
      **                                                            **          
      ****************************************************************          
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION  THRU 0100-EXIT.                 
           PERFORM 1000-PROCESS-ACCOUNT THRU 1000-EXIT.                 
           DISPLAY ' READ FCA07 RECORD CNT '  WS-FCA07-RECORD-CNT.      
           DISPLAY ' INSERT RPT GLXT CNT '    WS-INSERT-RPT-GLXT-CNT.   
           DISPLAY ' E-FCA07-END-RECORD-CNT ' E-FCA07-END-RECORD-CNT.   
           PERFORM 9000-TERMINATE       THRU 9000-EXIT.                 
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  0100-INITIALIZATION                                       **          
      **      COMMON INITIALIZATION ROUTINE                         **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '0100'                   TO WS-ACTIVE-PARAGRAPH.        
           PERFORM 0150-OPEN-FILES                                      
              THRU 0150-EXIT.                                           
                                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  0150-OPEN-FILES                                           **          
      **                                                            **          
      ****************************************************************          
       0150-OPEN-FILES.                                                 
      *                                                                         
           MOVE '0150'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           OPEN INPUT  FCSCA07-FILE.                                    
           IF FCA07-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'ERROR.  STATUS KEY 7 IS '                          
                                        TO WS-STATUS-KEY-ERROR-MSG      
               MOVE WS-FCA07-STATUS     TO WS-STATUS-KEY                
               MOVE WS-ACTIVE-PARAGRAPH TO WS-PARAGRAPH-NUMBER          
               MOVE WS-STATUS-KEY-ERROR-LINE TO WS-ABEND-MESSAGE        
               PERFORM 8900-PRINT-PROGRAM-INFO-LINE THRU 8900-EXIT      
               PERFORM 9900-ABEND THROUGH 9900-EXIT                     
           END-IF.                                                      
                                                                        
       0150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1000-PROCESS-ACCOUNT                                      **          
      **      READ INPUT BE90 FILE AND WRITE ROWS TO CSS_PNDNG_CARD_**          
      **      CSS_PNDNG_CARD_PMT TABLE                              **          
      ****************************************************************          
       1000-PROCESS-ACCOUNT.                                            
      *                                                                         
           MOVE '1000'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 7000-GET-OLD-DATE            THRU 7000-EXIT.         
      *                                                                         
           PERFORM 7050-DELETE-OLD-REC-GLEXT    THRU 7050-EXIT.         
      *                                                                         
           PERFORM 7100-READ-FCSCA07            THRU 7100-EXIT.         
      *                                                                         
           PERFORM UNTIL END-OF-CA07                                    
              PERFORM 2000-FCA07-JRNL-FORMAT    THRU 2000-EXIT          
              PERFORM 7100-READ-FCSCA07         THRU 7100-EXIT          
           END-PERFORM                                                  
           .                                                            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1900-PROCESS-END-REC                                      **          
      **                                                            **          
      ****************************************************************          
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FCA07-RECORD-CNT.                         
           IF WS-FCA07-RECORD-CNT = E-FCA07-END-RECORD-CNT              
               MOVE WS-Y   TO WS-END-OF-CA07                            
           ELSE                                                         
              DISPLAY '***********************************************' 
              DISPLAY ' PROGRAM PCSCA125 RECORD COUNT DOES '            
                      ' NOT = FCA07 CONTROL RECORD COUNT'               
              DISPLAY '* PCSCA125 REC COUNT = ' WS-FCA07-RECORD-CNT     
              DISPLAY '* CONTROL REC COUNT  = ' E-FCA07-END-RECORD-CNT  
              DISPLAY '*            PROCESSING    TERMINATED         *' 
              DISPLAY '***********************************************' 
              PERFORM 9900-ABEND  THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  2000-FCA07-JRNL-FORMAT                                    **          
      **      FORMATS DATA FOR CSS_RPT_GL_EXT                       **          
      **                                                            **          
      ****************************************************************          
       2000-FCA07-JRNL-FORMAT.                                          
      *                                                                         
           MOVE '2000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
      *                                                                         
           IF E-FCA07-JRNL-FORMAT-NO IS NUMERIC                         
               EVALUATE E-FCA07-JRNL-FORMAT-NO                          
                 WHEN WS-101                                            
                      PERFORM 2011-ANALYZE-101-JOURNALS THRU 2011-EXIT  
                 WHEN WS-102                                            
                      PERFORM 2012-ANALYZE-102-JOURNALS THRU 2012-EXIT  
                 WHEN WS-103                                            
                      PERFORM 2013-ANALYZE-103-JOURNALS THRU 2013-EXIT  
                 WHEN WS-104                                            
                      PERFORM 2014-ANALYZE-104-JOURNALS THRU 2014-EXIT  
                 WHEN WS-105                                            
                      PERFORM 2015-ANALYZE-105-JOURNALS THRU 2015-EXIT  
                 WHEN OTHER                                             
                      CONTINUE                                          
               END-EVALUATE                                             
           ELSE                                                         
               CONTINUE                                                 
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  2011-ANALYZE-101-JOURNALS                                 **          
      **                                                            **          
      ****************************************************************          
       2011-ANALYZE-101-JOURNALS.                                       
      *                                                                         
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00101.                  
           IF WS-101-AMOUNT-ENTERED IS NUMERIC                          
              MOVE WS-101-AMOUNT-ENTERED  TO WS-10X-AMOUNT-ENTERED      
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-AMOUNT-ENTERED
           END-IF.     
           IF WS-101-AMT-POSTED     IS NUMERIC                          
              MOVE WS-101-AMT-POSTED      TO WS-10X-AMT-POSTED          
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-AMT-POSTED
           END-IF.         
           IF WS-101-ACCT-GEN-LED-DR IS NUMERIC                         
              MOVE WS-101-ACCT-GEN-LED-DR TO WS-10X-ACCT-GEN-LED-DR     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-GEN-LED-DR
           END-IF.    
           IF WS-101-ACCT-GEN-LED-CR IS NUMERIC                         
              MOVE WS-101-ACCT-GEN-LED-CR TO WS-10X-ACCT-GEN-LED-CR     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-GEN-LED-CR
           END-IF.    
           IF WS-101-AR-AGE         = LOW-VALUES                        
              MOVE SPACES                 TO WS-10X-AR-AGE              
           ELSE                                                         
              MOVE WS-101-AR-AGE          TO WS-10X-AR-AGE
           END-IF.             
           IF WS-101-DATE-AR-BILLED = SPACES OR ZEROS OR LOW-VALUES     
              MOVE WS-DEFAULT-DATE        TO WS-10X-DATE-AR-BILLED      
           ELSE                                                         
              MOVE WS-101-DATE-AR-BILLED  TO WS-10X-DATE-AR-BILLED
           END-IF.     
           IF WS-101-ITEM-ID-NO IS NUMERIC                              
              MOVE WS-101-ITEM-ID-NO      TO WS-10X-ITEM-ID-NO          
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ITEM-ID-NO
           END-IF.         
           IF WS-101-ACCT-END-AR-BAL IS NUMERIC                         
              MOVE WS-101-ACCT-END-AR-BAL TO WS-10X-ACCT-END-AR-BAL     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-END-AR-BAL
           END-IF.    
           IF WS-101-REVENUE-MONTH   IS NUMERIC                         
              MOVE WS-101-REVENUE-MONTH   TO WS-10X-REVENUE-MONTH       
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-REVENUE-MONTH
           END-IF.      
           IF WS-101-CODE-REVENUE-DISTRICT = LOW-VALUE                  
              MOVE SPACES              TO WS-10X-CODE-REVENUE-DISTRICT  
           ELSE                                                         
              MOVE WS-101-CODE-REVENUE-DISTRICT                         
                                       TO WS-10X-CODE-REVENUE-DISTRICT
           END-IF. 
           IF WS-101-CODE-COMPANY-ACCT = LOW-VALUES                     
              MOVE SPACES                 TO WS-10X-CODE-COMPANY-ACCT   
           ELSE                                                         
              MOVE WS-101-CODE-COMPANY-ACCT TO WS-10X-CODE-COMPANY-ACCT
           END-IF.
           IF WS-101-CODE-ACCOUNT-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-ACCOUNT-STATUS    
           ELSE                                                         
           MOVE WS-101-CODE-ACCOUNT-STATUS                              
                                       TO WS-10X-CODE-ACCOUNT-STATUS
           END-IF.   
           IF WS-101-CODE-PREMISE-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-PREMISE-STATUS    
           ELSE                                                         
           MOVE WS-101-CODE-PREMISE-STATUS                              
                                       TO WS-10X-CODE-PREMISE-STATUS
           END-IF.   
      *                                                                         
           PERFORM 3000-F070X-MOVE-RGLEXT THRU 3000-EXIT.               
           PERFORM 8200-INSERT-RPT-GL-EXT THRU 8200-EXIT.               
      *                                                                         
       2011-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  2012-ANALYZE-102-JOURNALS                                 **          
      **                                                            **          
      ****************************************************************          
       2012-ANALYZE-102-JOURNALS.                                       
      *                                                                         
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00102.                  
           IF WS-102-AMOUNT-ENTERED IS NUMERIC                          
              MOVE WS-102-AMOUNT-ENTERED  TO WS-10X-AMOUNT-ENTERED      
           ELSE                                                         
              MOVE  ZEROS                 TO WS-10X-AMOUNT-ENTERED
           END-IF.     
           IF WS-102-AMT-POSTED     IS NUMERIC                          
              MOVE WS-102-AMT-POSTED      TO WS-10X-AMT-POSTED          
           ELSE                                                         
              MOVE  ZEROS                 TO WS-10X-AMT-POSTED
           END-IF.         
           IF WS-102-ACCT-GEN-LED-DR IS NUMERIC                         
              MOVE WS-102-ACCT-GEN-LED-DR TO WS-10X-ACCT-GEN-LED-DR     
           ELSE                                                         
              MOVE  ZEROS                 TO WS-10X-ACCT-GEN-LED-DR
           END-IF.    
           IF WS-102-ACCT-GEN-LED-CR IS NUMERIC                         
              MOVE WS-102-ACCT-GEN-LED-CR TO WS-10X-ACCT-GEN-LED-CR     
           ELSE                                                         
              MOVE  ZEROS                 TO WS-10X-ACCT-GEN-LED-CR
           END-IF.    
           IF WS-102-AR-AGE         = LOW-VALUES                        
              MOVE SPACES                 TO WS-10X-AR-AGE              
           ELSE                                                         
              MOVE WS-102-AR-AGE          TO WS-10X-AR-AGE
           END-IF.             
           IF WS-102-DATE-AR-BILLED = SPACES OR ZEROS OR LOW-VALUES     
              MOVE WS-DEFAULT-DATE        TO WS-10X-DATE-AR-BILLED      
           ELSE                                                         
              MOVE WS-102-DATE-AR-BILLED  TO WS-10X-DATE-AR-BILLED
           END-IF.     
           IF WS-102-ITEM-ID-NO IS NUMERIC                              
              MOVE WS-102-ITEM-ID-NO      TO WS-10X-ITEM-ID-NO          
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ITEM-ID-NO
           END-IF.         
           IF WS-102-ACCT-END-AR-BAL IS NUMERIC                         
              MOVE WS-102-ACCT-END-AR-BAL TO WS-10X-ACCT-END-AR-BAL     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-END-AR-BAL
           END-IF.    
           IF WS-102-REVENUE-MONTH   IS NUMERIC                         
              MOVE WS-102-REVENUE-MONTH   TO WS-10X-REVENUE-MONTH       
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-REVENUE-MONTH
           END-IF.      
           IF WS-102-CODE-REVENUE-DISTRICT = LOW-VALUE                  
              MOVE SPACES              TO WS-10X-CODE-REVENUE-DISTRICT  
           ELSE                                                         
              MOVE WS-102-CODE-REVENUE-DISTRICT                         
                                       TO WS-10X-CODE-REVENUE-DISTRICT
           END-IF. 
           IF WS-102-CODE-COMPANY-ACCT = LOW-VALUES                     
              MOVE SPACES                 TO WS-10X-CODE-COMPANY-ACCT   
           ELSE                                                         
              MOVE WS-102-CODE-COMPANY-ACCT TO WS-10X-CODE-COMPANY-ACCT
           END-IF.
           IF WS-102-CODE-ACCOUNT-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-ACCOUNT-STATUS    
           ELSE                                                         
           MOVE WS-102-CODE-ACCOUNT-STATUS                              
                                       TO WS-10X-CODE-ACCOUNT-STATUS
           END-IF.   
           IF WS-102-CODE-PREMISE-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-PREMISE-STATUS    
           ELSE                                                         
           MOVE WS-102-CODE-PREMISE-STATUS                              
                                       TO WS-10X-CODE-PREMISE-STATUS
           END-IF.   
      *                                                                         
           PERFORM 3000-F070X-MOVE-RGLEXT THRU 3000-EXIT.               
           PERFORM 8200-INSERT-RPT-GL-EXT THRU 8200-EXIT.               
      *                                                                         
       2012-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  2013-ANALYZE-103-JOURNALS                                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2013-ANALYZE-103-JOURNALS.                                       
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00103.                  
           IF WS-103-AMOUNT-ENTERED IS NUMERIC                          
              MOVE WS-103-AMOUNT-ENTERED  TO WS-10X-AMOUNT-ENTERED      
           ELSE                                                         
              MOVE  ZEROS                 TO WS-10X-AMOUNT-ENTERED
           END-IF.     
           IF WS-103-AMT-POSTED     IS NUMERIC                          
              MOVE WS-103-AMT-POSTED      TO WS-10X-AMT-POSTED          
           ELSE                                                         
              MOVE  ZEROS                 TO WS-10X-AMT-POSTED
           END-IF.         
           IF WS-103-ACCT-GEN-LED-DR IS NUMERIC                         
              MOVE WS-103-ACCT-GEN-LED-DR TO WS-10X-ACCT-GEN-LED-DR     
           ELSE                                                         
              MOVE  ZEROS                 TO WS-10X-ACCT-GEN-LED-DR
           END-IF.    
           IF WS-103-ACCT-GEN-LED-CR IS NUMERIC                         
              MOVE WS-103-ACCT-GEN-LED-CR TO WS-10X-ACCT-GEN-LED-CR     
           ELSE                                                         
              MOVE  ZEROS                 TO WS-10X-ACCT-GEN-LED-CR
           END-IF.    
           IF WS-103-AR-AGE         = LOW-VALUES                        
              MOVE SPACES                 TO WS-10X-AR-AGE              
           ELSE                                                         
              MOVE WS-103-AR-AGE          TO WS-10X-AR-AGE
           END-IF.             
           IF WS-103-DATE-AR-BILLED = SPACES OR ZEROS OR LOW-VALUES     
              MOVE WS-DEFAULT-DATE        TO WS-10X-DATE-AR-BILLED      
           ELSE                                                         
              MOVE WS-103-DATE-AR-BILLED  TO WS-10X-DATE-AR-BILLED
           END-IF.     
           IF WS-103-ITEM-ID-NO IS NUMERIC                              
              MOVE WS-103-ITEM-ID-NO      TO WS-10X-ITEM-ID-NO          
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ITEM-ID-NO
           END-IF.         
           IF WS-103-ACCT-END-AR-BAL IS NUMERIC                         
              MOVE WS-103-ACCT-END-AR-BAL TO WS-10X-ACCT-END-AR-BAL     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-END-AR-BAL
           END-IF.    
           IF WS-103-REVENUE-MONTH   IS NUMERIC                         
              MOVE WS-103-REVENUE-MONTH   TO WS-10X-REVENUE-MONTH       
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-REVENUE-MONTH
           END-IF.      
           IF WS-103-CODE-REVENUE-DISTRICT = LOW-VALUE                  
              MOVE SPACES              TO WS-10X-CODE-REVENUE-DISTRICT  
           ELSE                                                         
              MOVE WS-103-CODE-REVENUE-DISTRICT                         
                                       TO WS-10X-CODE-REVENUE-DISTRICT
           END-IF. 
           IF WS-103-CODE-COMPANY-ACCT = LOW-VALUES                     
              MOVE SPACES                 TO WS-10X-CODE-COMPANY-ACCT   
           ELSE                                                         
              MOVE WS-103-CODE-COMPANY-ACCT TO WS-10X-CODE-COMPANY-ACCT
           END-IF.
           IF WS-103-CODE-ACCT-STATUS = LOW-VALUES                      
              MOVE SPACES              TO WS-10X-CODE-ACCOUNT-STATUS    
           ELSE                                                         
           MOVE WS-103-CODE-ACCT-STATUS                                 
                                       TO WS-10X-CODE-ACCOUNT-STATUS
           END-IF.   
           IF WS-103-CODE-PREMISE-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-PREMISE-STATUS    
           ELSE                                                         
           MOVE WS-103-CODE-PREMISE-STATUS                              
                                       TO WS-10X-CODE-PREMISE-STATUS
           END-IF.   
      *                                                                         
           PERFORM 3000-F070X-MOVE-RGLEXT THRU 3000-EXIT.               
           PERFORM 8200-INSERT-RPT-GL-EXT THRU 8200-EXIT.               
      *                                                                         
       2013-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  2014-ANALYZE-104-JOURNALS                                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2014-ANALYZE-104-JOURNALS.                                       
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00104.                  
           IF WS-104-AMOUNT-ENTERED IS NUMERIC                          
              MOVE WS-104-AMOUNT-ENTERED  TO WS-10X-AMOUNT-ENTERED      
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-AMOUNT-ENTERED
           END-IF.     
           IF WS-104-AMT-POSTED     IS NUMERIC                          
              MOVE WS-104-AMT-POSTED      TO WS-10X-AMT-POSTED          
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-AMT-POSTED
           END-IF.         
           IF WS-104-ACCT-GEN-LED-DR IS NUMERIC                         
              MOVE WS-104-ACCT-GEN-LED-DR TO WS-10X-ACCT-GEN-LED-DR     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-GEN-LED-DR
           END-IF.    
           IF WS-104-ACCT-GEN-LED-CR IS NUMERIC                         
              MOVE WS-104-ACCT-GEN-LED-CR TO WS-10X-ACCT-GEN-LED-CR     
           ELSE                                                         
              MOVE ZEROS                 TO WS-10X-ACCT-GEN-LED-CR
           END-IF.     
           IF WS-104-AR-AGE         = LOW-VALUES                        
              MOVE SPACES                 TO WS-10X-AR-AGE              
           ELSE                                                         
              MOVE WS-104-AR-AGE          TO WS-10X-AR-AGE
           END-IF.             
           IF WS-104-DATE-AR-BILLED = SPACES OR ZEROS OR LOW-VALUES     
              MOVE WS-DEFAULT-DATE        TO WS-10X-DATE-AR-BILLED      
           ELSE                                                         
              MOVE WS-104-DATE-AR-BILLED  TO WS-10X-DATE-AR-BILLED
           END-IF.     
           IF WS-104-ITEM-ID-NO IS NUMERIC                              
              MOVE WS-104-ITEM-ID-NO      TO WS-10X-ITEM-ID-NO          
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ITEM-ID-NO
           END-IF.         
           IF WS-104-ACCT-END-AR-BAL IS NUMERIC                         
              MOVE WS-104-ACCT-END-AR-BAL TO WS-10X-ACCT-END-AR-BAL     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-END-AR-BAL
           END-IF.    
           IF WS-104-REVENUE-MONTH   IS NUMERIC                         
              MOVE WS-104-REVENUE-MONTH   TO WS-10X-REVENUE-MONTH       
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-REVENUE-MONTH
           END-IF.      
           IF WS-104-CODE-REVENUE-DISTRICT = LOW-VALUE                  
              MOVE SPACES              TO WS-10X-CODE-REVENUE-DISTRICT  
           ELSE                                                         
              MOVE WS-104-CODE-REVENUE-DISTRICT                         
                                       TO WS-10X-CODE-REVENUE-DISTRICT
           END-IF. 
           IF WS-104-CODE-COMPANY-ACCT = LOW-VALUES                     
              MOVE SPACES                 TO WS-10X-CODE-COMPANY-ACCT   
           ELSE                                                         
              MOVE WS-104-CODE-COMPANY-ACCT TO WS-10X-CODE-COMPANY-ACCT
           END-IF.
           IF WS-104-CODE-ACCOUNT-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-ACCOUNT-STATUS    
           ELSE                                                         
           MOVE WS-104-CODE-ACCOUNT-STATUS                              
                                       TO WS-10X-CODE-ACCOUNT-STATUS
           END-IF.   
           IF WS-104-CODE-PREMISE-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-PREMISE-STATUS    
           ELSE                                                         
           MOVE WS-104-CODE-PREMISE-STATUS                              
                                       TO WS-10X-CODE-PREMISE-STATUS
           END-IF.   
      *                                                                         
           PERFORM 3000-F070X-MOVE-RGLEXT THRU 3000-EXIT.               
           PERFORM 8200-INSERT-RPT-GL-EXT THRU 8200-EXIT.               
      *                                                                         
       2014-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  2015-ANALYZE-105-JOURNALS                                 **          
      **                                                            **          
      ****************************************************************          
       2015-ANALYZE-105-JOURNALS.                                       
      *                                                                         
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00105.                  
           IF WS-105-AMOUNT-ENTERED IS NUMERIC                          
              MOVE WS-105-AMOUNT-ENTERED  TO WS-10X-AMOUNT-ENTERED      
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-AMOUNT-ENTERED
           END-IF.     
           IF WS-105-AMT-POSTED     IS NUMERIC                          
              MOVE WS-105-AMT-POSTED      TO WS-10X-AMT-POSTED          
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-AMT-POSTED
           END-IF.         
           IF WS-105-ACCT-GEN-LED-DR IS NUMERIC                         
              MOVE WS-105-ACCT-GEN-LED-DR TO WS-10X-ACCT-GEN-LED-DR     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-GEN-LED-DR
           END-IF.    
           IF WS-105-ACCT-GEN-LED-CR IS NUMERIC                         
              MOVE WS-105-ACCT-GEN-LED-CR TO WS-10X-ACCT-GEN-LED-CR     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-GEN-LED-CR
           END-IF.    
           IF WS-105-AR-AGE         = LOW-VALUES                        
              MOVE SPACES                 TO WS-10X-AR-AGE              
           ELSE                                                         
              MOVE WS-105-AR-AGE          TO WS-10X-AR-AGE
           END-IF.             
           IF WS-105-DATE-AR-BILLED = SPACES OR ZEROS OR LOW-VALUES     
              MOVE WS-DEFAULT-DATE        TO WS-10X-DATE-AR-BILLED      
           ELSE                                                         
              MOVE WS-105-DATE-AR-BILLED  TO WS-10X-DATE-AR-BILLED
           END-IF.     
           IF WS-105-ITEM-ID-NO IS NUMERIC                              
              MOVE WS-105-ITEM-ID-NO      TO WS-10X-ITEM-ID-NO          
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ITEM-ID-NO
           END-IF.         
           IF WS-105-ACCT-END-AR-BAL IS NUMERIC                         
              MOVE WS-105-ACCT-END-AR-BAL TO WS-10X-ACCT-END-AR-BAL     
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-ACCT-END-AR-BAL
           END-IF.    
           IF WS-105-REVENUE-MONTH   IS NUMERIC                         
              MOVE WS-105-REVENUE-MONTH   TO WS-10X-REVENUE-MONTH       
           ELSE                                                         
              MOVE ZEROS                  TO WS-10X-REVENUE-MONTH
           END-IF.      
           IF WS-105-CODE-REVENUE-DISTRICT = LOW-VALUE                  
              MOVE SPACES              TO WS-10X-CODE-REVENUE-DISTRICT  
           ELSE                                                         
              MOVE WS-105-CODE-REVENUE-DISTRICT                         
                                       TO WS-10X-CODE-REVENUE-DISTRICT
           END-IF. 
           IF WS-105-CODE-COMPANY-ACCT = LOW-VALUES                     
              MOVE SPACES                 TO WS-10X-CODE-COMPANY-ACCT   
           ELSE                                                         
              MOVE WS-105-CODE-COMPANY-ACCT TO WS-10X-CODE-COMPANY-ACCT
           END-IF.
           IF WS-105-CODE-ACCOUNT-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-ACCOUNT-STATUS    
           ELSE                                                         
           MOVE WS-105-CODE-ACCOUNT-STATUS                              
                                       TO WS-10X-CODE-ACCOUNT-STATUS
           END-IF.   
           IF WS-105-CODE-PREMISE-STATUS = LOW-VALUES                   
              MOVE SPACES              TO WS-10X-CODE-PREMISE-STATUS    
           ELSE                                                         
           MOVE WS-105-CODE-PREMISE-STATUS                              
                                       TO WS-10X-CODE-PREMISE-STATUS
           END-IF.   
      *                                                                         
           PERFORM 3000-F070X-MOVE-RGLEXT THRU 3000-EXIT.               
           PERFORM 8200-INSERT-RPT-GL-EXT THRU 8200-EXIT.               
      *                                                                         
       2015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  3000-F070X-MOVE-RGLEXT                                    **          
      **                                                            **          
      ****************************************************************          
       3000-F070X-MOVE-RGLEXT.                                          
      *                                                                         
           PERFORM 7200-GET-CURRENT-TIMESTAMP THRU 7200-EXIT.           
      *                                                                         
           MOVE WS-CURRENT-TS             TO XL-JRNL-UNIQUE-TS.         
           MOVE E-FCA07-JRNL-FORMAT-NO    TO XL-JRNL-FORMAT-NO.         
           MOVE WS-CURRENT-DATE           TO XL-CURNT-EXTRACT-DT.       
           IF E-FCA07-CASH-COMPANY-NO = LOW-VALUES                      
              MOVE SPACES                  TO XL-CASH-COMPANY-NO        
           ELSE                                                         
              MOVE E-FCA07-CASH-COMPANY-NO TO XL-CASH-COMPANY-NO
           END-IF.       
           IF E-FCA07-CASH-LOCAL-OFFICE = LOW-VALUES                    
              MOVE SPACES                  TO XL-CASH-LOCAL-OFFICE      
           ELSE                                                         
              MOVE E-FCA07-CASH-LOCAL-OFFICE TO XL-CASH-LOCAL-OFFICE
           END-IF.   
           IF E-FCA07-DATE-CASH-REPORT = SPACES OR ZEROS OR LOW-VALUES  
              MOVE WS-DEFAULT-DATE        TO XL-CASH-REPORT-DT          
           ELSE                                                         
              MOVE E-FCA07-DATE-CASH-REPORT TO XL-CASH-REPORT-DT
           END-IF.       
           MOVE E-FCA07-CASH-DRAWER-ID  TO XL-CASH-DRAWER-ID.           
           IF E-FCA07-JRNL-TRAN-APPL-NO IS NUMERIC                      
              MOVE E-FCA07-JRNL-TRAN-APPL-NO TO XL-JRNL-TRAN-APPL-NO    
           ELSE                                                         
              MOVE ZEROS                  TO XL-JRNL-TRAN-APPL-NO
           END-IF.      
           IF E-FCA07-DUP-CONTROL-NO    IS NUMERIC                      
              MOVE E-FCA07-DUP-CONTROL-NO    TO XL-DUP-CONTROL-NO       
           ELSE                                                         
              MOVE ZEROS                  TO XL-DUP-CONTROL-NO
           END-IF.         
           IF E-FCA07-JRNL-SORT-ID      = LOW-VALUES                    
              MOVE SPACES                 TO XL-JRNL-SORT-ID            
           ELSE                                                         
              MOVE E-FCA07-JRNL-SORT-ID   TO XL-JRNL-SORT-ID
           END-IF.           
           IF E-FCA07-COMPANY-NO        = LOW-VALUES                    
              MOVE SPACES                 TO XL-COMPANY-NO              
           ELSE                                                         
              MOVE E-FCA07-COMPANY-NO     TO XL-COMPANY-NO
           END-IF.             
           IF E-FCA07-LOCAL-OFFICE      = LOW-VALUES                    
              MOVE SPACES                 TO XL-LOCAL-OFFICE            
           ELSE                                                         
              MOVE E-FCA07-LOCAL-OFFICE   TO XL-LOCAL-OFFICE
           END-IF.           
           IF E-FCA07-RECORD-ID-ACCT-NO IS NUMERIC                      
              MOVE E-FCA07-RECORD-ID-ACCT-NO TO XL-RECORD-ID-ACCT-NO    
           ELSE                                                         
              MOVE ZEROS                  TO XL-RECORD-ID-ACCT-NO
           END-IF.      
           IF E-FCA07-TRAN-DATE     = SPACES OR ZEROS OR LOW-VALUES     
              MOVE WS-DEFAULT-DATE        TO XL-TRAN-DT                 
           ELSE                                                         
              MOVE E-FCA07-TRAN-DATE      TO XL-TRAN-DT
           END-IF.                
           IF E-FCA07-TRAN-TIME     = SPACES OR ZEROS OR LOW-VALUES     
              MOVE WS-DEFAULT-TIME        TO XL-TRAN-TM                 
           ELSE                                                         
              MOVE E-FCA07-TRAN-TIME      TO XL-TRAN-TM
           END-IF.                
           IF E-FCA07-CODE-TERMINAL-TRAN = LOW-VALUES                   
              MOVE SPACES                 TO XL-TERMINAL-TRAN-CD        
           ELSE                                                         
              MOVE E-FCA07-CODE-TERMINAL-TRAN TO XL-TERMINAL-TRAN-CD
           END-IF.   
           IF E-FCA07-DATE-LAST-ACTION = SPACES OR ZEROS OR LOW-VALUES  
              MOVE WS-DEFAULT-DATE        TO XL-LAST-ACTION-DT          
           ELSE                                                         
              MOVE E-FCA07-DATE-LAST-ACTION TO XL-LAST-ACTION-DT
           END-IF.       
           IF E-FCA07-CODE-ENTRY-SOURCE  = LOW-VALUES                   
              MOVE SPACES                 TO XL-CODE-ENTRY-SOURCE       
           ELSE                                                         
              MOVE E-FCA07-CODE-ENTRY-SOURCE  TO XL-CODE-ENTRY-SOURCE
           END-IF.  
           IF E-FCA07-USER-ID            = LOW-VALUES                   
              MOVE SPACES                 TO XL-USER-ID                 
           ELSE                                                         
              MOVE E-FCA07-USER-ID        TO XL-USER-ID
           END-IF.                
           IF E-FCA07-CASH-REPORT-NO     = LOW-VALUES                   
              MOVE SPACES                 TO XL-CASH-REPORT-NO          
           ELSE                                                         
              MOVE E-FCA07-CASH-REPORT-NO TO XL-CASH-REPORT-NO
           END-IF.         
           MOVE WS-10X-AMOUNT-ENTERED     TO XL-AMOUNT-ENTERED-AM.      
           MOVE WS-10X-AMT-POSTED         TO XL-AMT-POSTED.             
           MOVE WS-10X-ACCT-GEN-LED-DR    TO XL-ACCT-GEN-LED-DR-NO.     
           MOVE WS-10X-ACCT-GEN-LED-CR    TO XL-ACCT-GEN-LED-CR-NO.     
           MOVE WS-10X-AR-AGE             TO XL-CODE-AR-AGE.            
           MOVE WS-10X-DATE-AR-BILLED     TO XL-AR-BILLED-DT.           
           MOVE WS-10X-ITEM-ID-NO         TO XL-ITEM-ID-NO.             
           MOVE WS-10X-ACCT-END-AR-BAL    TO XL-ACCT-END-AR-BAL-AM.     
           MOVE WS-10X-REVENUE-MONTH      TO XL-REVENUE-MONTH.          
           MOVE WS-10X-CODE-REVENUE-DISTRICT TO XL-REV-DISTRICT-CD.     
           MOVE WS-10X-CODE-COMPANY-ACCT  TO XL-CODE-COMPANY-ACCT.      
           MOVE WS-10X-CODE-ACCOUNT-STATUS TO XL-CODE-ACCT-STAT.        
           MOVE WS-10X-CODE-PREMISE-STATUS TO XL-CODE-PREMISE-STAT.     
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7000-GET-OLD-DATE.                                    **              
      **      GETS THE CURRENT TIMESTAMP FROM CSS_MODEL_SQL.    **              
      ************************************************************              
       7000-GET-OLD-DATE.                                               
      *                                                                         
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, -10, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-OLD-DATE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-OLD-DATE = (CURRENT DATE - 10 DAYS)                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************** PCSCA125 ************'            
              DISPLAY '7000-GET-OLD-DATE'                               
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**OLD DATE    : ' WS-OLD-DATE                    
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '************** PCSCA125 ************'            
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7050-DELETE-OLD-REC-GLEXT.                            **              
      **      DELETE 10 DAYS OLD RECORDS FROM CSS_RPT_GL_EXT    **              
      ************************************************************              
       7050-DELETE-OLD-REC-GLEXT.                                       
      *                                                                         
           MOVE '7050'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_RPT_GL_EXT                              
                WHERE CURNT_EXTRACT_DT < IIF(TRY_CONVERT(DATE, 
                                                           :WS-OLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-DATE
              ) <> 0) OR (LEN(:WS-OLD-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-OLD-DATE
              ), CONVERT(DATE, :WS-OLD-DATE) )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_RPT_GL_EXT                                      
MFA-TR*         WHERE CURNT_EXTRACT_DT < :WS-OLD-DATE                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************** PCSCA125 ************'            
              DISPLAY '7050-DELETE-OLD-REC-GLEXT'                       
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**OLD DATE    : ' WS-OLD-DATE                    
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '************** PCSCA125 ************'            
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  7100-READ-FCSCA07                                         **          
      **                                                            **          
      ****************************************************************          
       7100-READ-FCSCA07.                                               
      *                                                                         
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSCA07-FILE                                            
               AT END                                                   
                  MOVE WS-Y   TO WS-END-OF-CA07.                        
                  ADD 1 TO WS-FCA07-RECORD-CNT.                         
           IF FCA07-SUCCESSFUL OR END-OF-CA07                           
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA125 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA07        **'       
               DISPLAY '**     FILE STATUS = ' WS-FCA07-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT
           END-IF.                   
      *                                                                         
           IF  E-FCA07-BEGIN-KEY = LOW-VALUES                           
              SUBTRACT 1 FROM WS-FCA07-RECORD-CNT                       
           END-IF.                                                      
      *                                                                         
           IF E-FCA07-END-KEY = HIGH-VALUES                             
               PERFORM 1900-PROCESS-END-REC     THRU 1900-EXIT          
               GO TO 1000-EXIT
           END-IF.                                         
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7200-GET-CURRENT-TIMESTAMP.                           **              
      **      GETS THE CURRENT TIMESTAMP FROM CSS_MODEL_SQL.    **              
      ************************************************************              
       7200-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TS   = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '************** PCSCA125 ************'            
              DISPLAY '7200-GET-CURRENT-TIMESTAMP'                      
              DISPLAY '**RETURN CODE : ' SQLCODE                        
              DISPLAY '**         PROCESSING TERMINATED         **'     
              DISPLAY '************** PCSCA125 ************'            
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *                                                             **          
      *   8200-INSERT-RPT-GL-EXT                                    **          
      *                                                             **          
      *   PERFORMS DB2 INSERT OF CSS_PNDNG_CARD_PMT                 **          
      *                                                             **          
      ****************************************************************          
       8200-INSERT-RPT-GL-EXT.                                          
      *                                                                         
           MOVE '8200'                   TO WS-ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_RPT_GL_EXT                                
                    (JRNL_UNIQUE_TS,                                    
                     JRNL_FORMAT_NO,                                    
                     CURNT_EXTRACT_DT,                                  
                     CASH_COMPANY_NO,                                   
                     CASH_LOCAL_OFFICE,                                 
                     CASH_REPORT_DT,                                    
                     CASH_DRAWER_ID,                                    
                     JRNL_TRAN_APPL_NO,                                 
                     DUP_CONTROL_NO,                                    
                     JRNL_SORT_ID,                                      
                     COMPANY_NO,                                        
                     LOCAL_OFFICE,                                      
                     RECORD_ID_ACCT_NO,                                 
                     TRAN_DT,                                           
                     TRAN_TM,                                           
                     TERMINAL_TRAN_CD,                                  
                     LAST_ACTION_DT,                                    
                     CODE_ENTRY_SOURCE,                                 
                     USER_ID,                                           
                     CASH_REPORT_NO,                                    
                     AMOUNT_ENTERED_AM,                                 
                     AMT_POSTED,                                        
                     ACCT_GEN_LED_DR_NO,                                
                     ACCT_GEN_LED_CR_NO,                                
                     CODE_AR_AGE,                                       
                     AR_BILLED_DT,                                      
                     ITEM_ID_NO,                                        
                     ACCT_END_AR_BAL_AM,                                
                     REVENUE_MONTH,                                     
                     REV_DISTRICT_CD,                                   
                     CODE_COMPANY_ACCT,                                 
                     CODE_ACCT_STAT,                                    
                     CODE_PREMISE_STAT)                                 
              VALUES                                                    
                    (CIS.CHAR2TIMESTAMP(:XL-JRNL-UNIQUE-TS),                    
                     :XL-JRNL-FORMAT-NO,                                
                     IIF(TRY_CONVERT(DATE, :XL-CURNT-EXTRACT-DT
              ) IS NULL OR (PATINDEX('%.%', :XL-CURNT-EXTRACT-DT
              ) <> 0) OR (LEN(:XL-CURNT-EXTRACT-DT
              ) <> 10), CIS.CHAR2DATE(:XL-CURNT-EXTRACT-DT
              ), CONVERT(DATE, :XL-CURNT-EXTRACT-DT) ),                        
                     :XL-CASH-COMPANY-NO,                               
                     :XL-CASH-LOCAL-OFFICE,                             
                     IIF(TRY_CONVERT(DATE, :XL-CASH-REPORT-DT
              ) IS NULL OR (PATINDEX('%.%', :XL-CASH-REPORT-DT
              ) <> 0) OR (LEN(:XL-CASH-REPORT-DT
              ) <> 10), CIS.CHAR2DATE(:XL-CASH-REPORT-DT
              ), CONVERT(DATE, :XL-CASH-REPORT-DT) ),                          
                     :XL-CASH-DRAWER-ID,                                
                     :XL-JRNL-TRAN-APPL-NO,                             
                     :XL-DUP-CONTROL-NO,                                
                     :XL-JRNL-SORT-ID,                                  
                     :XL-COMPANY-NO,                                    
                     :XL-LOCAL-OFFICE,                                  
                     :XL-RECORD-ID-ACCT-NO,                             
                     IIF(TRY_CONVERT(DATE, :XL-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :XL-TRAN-DT) <> 0) OR (LEN(
                                                            :XL-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:XL-TRAN-DT), CONVERT(DATE, 
                                                            :XL-TRAN-DT
              ) ),                                       
                     CIS.CHAR2TIME(:XL-TRAN-TM),                                
                     :XL-TERMINAL-TRAN-CD,                              
                     IIF(TRY_CONVERT(DATE, :XL-LAST-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :XL-LAST-ACTION-DT
              ) <> 0) OR (LEN(:XL-LAST-ACTION-DT
              ) <> 10), CIS.CHAR2DATE(:XL-LAST-ACTION-DT
              ), CONVERT(DATE, :XL-LAST-ACTION-DT) ),                          
                     :XL-CODE-ENTRY-SOURCE,                             
                     :XL-USER-ID,                                       
                     :XL-CASH-REPORT-NO,                                
                     :XL-AMOUNT-ENTERED-AM,                             
                     :XL-AMT-POSTED,                                    
                     :XL-ACCT-GEN-LED-DR-NO,                            
                     :XL-ACCT-GEN-LED-CR-NO,                            
                     :XL-CODE-AR-AGE,                                   
                     IIF(TRY_CONVERT(DATE, :XL-AR-BILLED-DT
              ) IS NULL OR (PATINDEX('%.%', :XL-AR-BILLED-DT
              ) <> 0) OR (LEN(:XL-AR-BILLED-DT) <> 10), CIS.CHAR2DATE(
                                                       :XL-AR-BILLED-DT
              ), CONVERT(DATE, :XL-AR-BILLED-DT) ),                            
                     :XL-ITEM-ID-NO,                                    
                     :XL-ACCT-END-AR-BAL-AM,                            
                     :XL-REVENUE-MONTH,                                 
                     :XL-REV-DISTRICT-CD,                               
                     :XL-CODE-COMPANY-ACCT,                             
                     :XL-CODE-ACCT-STAT,                                
                     :XL-CODE-PREMISE-STAT)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_RPT_GL_EXT                                        
MFA-TR*             (JRNL_UNIQUE_TS,                                            
MFA-TR*              JRNL_FORMAT_NO,                                            
MFA-TR*              CURNT_EXTRACT_DT,                                          
MFA-TR*              CASH_COMPANY_NO,                                           
MFA-TR*              CASH_LOCAL_OFFICE,                                         
MFA-TR*              CASH_REPORT_DT,                                            
MFA-TR*              CASH_DRAWER_ID,                                            
MFA-TR*              JRNL_TRAN_APPL_NO,                                         
MFA-TR*              DUP_CONTROL_NO,                                            
MFA-TR*              JRNL_SORT_ID,                                              
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              RECORD_ID_ACCT_NO,                                         
MFA-TR*              TRAN_DT,                                                   
MFA-TR*              TRAN_TM,                                                   
MFA-TR*              TERMINAL_TRAN_CD,                                          
MFA-TR*              LAST_ACTION_DT,                                            
MFA-TR*              CODE_ENTRY_SOURCE,                                         
MFA-TR*              USER_ID,                                                   
MFA-TR*              CASH_REPORT_NO,                                            
MFA-TR*              AMOUNT_ENTERED_AM,                                         
MFA-TR*              AMT_POSTED,                                                
MFA-TR*              ACCT_GEN_LED_DR_NO,                                        
MFA-TR*              ACCT_GEN_LED_CR_NO,                                        
MFA-TR*              CODE_AR_AGE,                                               
MFA-TR*              AR_BILLED_DT,                                              
MFA-TR*              ITEM_ID_NO,                                                
MFA-TR*              ACCT_END_AR_BAL_AM,                                        
MFA-TR*              REVENUE_MONTH,                                             
MFA-TR*              REV_DISTRICT_CD,                                           
MFA-TR*              CODE_COMPANY_ACCT,                                         
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              CODE_PREMISE_STAT)                                         
MFA-TR*       VALUES                                                            
MFA-TR*             (:XL-JRNL-UNIQUE-TS,                                        
MFA-TR*              :XL-JRNL-FORMAT-NO,                                        
MFA-TR*              :XL-CURNT-EXTRACT-DT,                                      
MFA-TR*              :XL-CASH-COMPANY-NO,                                       
MFA-TR*              :XL-CASH-LOCAL-OFFICE,                                     
MFA-TR*              :XL-CASH-REPORT-DT,                                        
MFA-TR*              :XL-CASH-DRAWER-ID,                                        
MFA-TR*              :XL-JRNL-TRAN-APPL-NO,                                     
MFA-TR*              :XL-DUP-CONTROL-NO,                                        
MFA-TR*              :XL-JRNL-SORT-ID,                                          
MFA-TR*              :XL-COMPANY-NO,                                            
MFA-TR*              :XL-LOCAL-OFFICE,                                          
MFA-TR*              :XL-RECORD-ID-ACCT-NO,                                     
MFA-TR*              :XL-TRAN-DT,                                               
MFA-TR*              :XL-TRAN-TM,                                               
MFA-TR*              :XL-TERMINAL-TRAN-CD,                                      
MFA-TR*              :XL-LAST-ACTION-DT,                                        
MFA-TR*              :XL-CODE-ENTRY-SOURCE,                                     
MFA-TR*              :XL-USER-ID,                                               
MFA-TR*              :XL-CASH-REPORT-NO,                                        
MFA-TR*              :XL-AMOUNT-ENTERED-AM,                                     
MFA-TR*              :XL-AMT-POSTED,                                            
MFA-TR*              :XL-ACCT-GEN-LED-DR-NO,                                    
MFA-TR*              :XL-ACCT-GEN-LED-CR-NO,                                    
MFA-TR*              :XL-CODE-AR-AGE,                                           
MFA-TR*              :XL-AR-BILLED-DT,                                          
MFA-TR*              :XL-ITEM-ID-NO,                                            
MFA-TR*              :XL-ACCT-END-AR-BAL-AM,                                    
MFA-TR*              :XL-REVENUE-MONTH,                                         
MFA-TR*              :XL-REV-DISTRICT-CD,                                       
MFA-TR*              :XL-CODE-COMPANY-ACCT,                                     
MFA-TR*              :XL-CODE-ACCT-STAT,                                        
MFA-TR*              :XL-CODE-PREMISE-STAT)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO WS-INSERT-RPT-GLXT-CNT                           
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA125 PROCESSING ERROR           **'     
              DISPLAY '**   8200-INSERT-RPT-GL-EXT              **'     
              DISPLAY '**   SQLCODE WAS: ', WS-ACTIVE-RETURN-CODE       
              DISPLAY ' ACCOUNT = ', XL-RECORD-ID-ACCT-NO               
              DISPLAY ' JRNL UNIQUE TS = ', XL-JRNL-UNIQUE-TS           
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND      THRU 9900-EXIT                    
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
       8900-PRINT-PROGRAM-INFO-LINE.                                    
      *                                                                         
           DISPLAY '                                   '.               
           DISPLAY '******************************************'.        
           DISPLAY '**     PCSCA125 PROCESSING ERROR        **'.        
           DISPLAY '** CURRENT PARAGRAPH = ' WS-ACTIVE-PARAGRAPH.       
           DISPLAY '**' WS-ABEND-MESSAGE.                               
           DISPLAY '**       PROCESSING TERMINATED          **'.        
           DISPLAY '******************************************'.        
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  9000-TERMINATE                                            **          
      **       PROGRAM WRAP UP                                      **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA07-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND INCLUDES SQL ROLLBACK                          **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
                                                                        
