       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA124.                                        
       DATE-WRITTEN.   DEC 1981.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      *               COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **    ____    ________     ______                              **         
      **                                                             **         
T7796 **   12/03/96   CSG        TPR 7796.  ADD WITH HOLD CLAUSE TO  **         
      **                         THE CASH_DRWR_CNTL CURSOR SO THAT   **         
      **                         THE CURSOR WILL NOT BE CLOSED ON    **         
      **                         A CHECKPOINT COMMIT STMT.  THE      **         
      **                         CURSOR WAS BEING FORCED CLOSED DUE  **         
      **                         TO THE 'FOR UPDATE OF' CLAUSE.      **         
T12013**    7/14/97   CSS        MODIFY DELETION OF CSH DRWR JRNL TO **         
      **                         INCLUDE CHECKS ON DATE BALANCED,    **         
      **                         CODE FCS EXTRACTED, AND CODE        **         
      **                         CSH DRWR STAT                       **         
      **                                                             **         
T13534**   10/30/97    MKN       THE NO-OF-ITEMS-ENTERED COLUMN IN   **         
      **                         CSH_DRWR_CNTL IS ALWAYS SET TO THE  **         
      **                         MAX NO OF ENTRIES                   **         
T14762**   02/11/98    SJM       AFTER BATCH JOURNAL HAS BEEN        **         
      **                         PROCESSED, SET THE STATUS TO A 'C'  **         
      **                         SO THAT IT WILL BE DELETED WITH THE **         
      **                         NEXT RUN                            **         
T15045**   02/25/98    KLP       NOW EXTRACTS BALANCED AND CLOSED    **         
      **                         CASH DRAWERS                        **         
T18128**   01/22/99    BM        CHANGED FOR COPY TO INCLUDE DUE TO  **         
T18128**                         CHANGE IN CPD00012                             
T19086** 02/10/99     CBSI       SQL CODE CHECK IS PERFORMED ONCE IT **         
T19086**              MADRAS     RETURNS FROM THE CPD00012 COPYBOOK  **         
T22024** 04/11/00     CBSI       WS-DEFAULT-PURGE-JRNL VALUE         **         
T22024** 04/20/00     MADRAS     INCREASED FROM 6 TO 400 TO KEEP     **         
T22024**                         CASH DRAWER JOURNALS LONGER.        **         
T22024**                         DATE PORTION OF THE BALANCED_TS     **         
T22024**                         FIELD FROM CSS_CSH_DRWR_CNTL TABLE  **         
T22024**                         IS USED INSTEAD OF DATE_BALANCED    **         
T22024**                         FIELD OF CSS_CSH_DRWR_JRNL. BECAUSE **         
T22024**                         OF DATE_BALANCED IS NOT POPULATED   **         
T22024**                         BY NEW FCS SYSTEM.                  **         
T22237** 05/19/00      SS82048   INCLUDED A DELETE ON CHILD TABLE    **         
      **                         CSS_BILL_AGNT_PYMT WHEN ROWS ARE    **         
      **                         DELETED FROM CSS_CSH_DRWR_JRNL      **         
      **                         AND STOPPED DELETE WHEN THE AMTS    **         
      **                         ZERO.                                          
T23814** 04/23/01      DS19153   RUN-TIME ENHANCEMENT. ONLY READ FOR **         
T23814**               ACT. 4    NUMBER OF JOURNAL ENTRIES IF A      **         
T23814**                         DELETE WAS MADE. THIS IS ONLY TO    **         
T23814**                         CAPTURE THE NEW # OF JOURNAL ENTRIES**         
T23814**                         TO PLACE IN NO-ITEMS-ENTERED ON     **         
T23814**                         CSS_CSH_DRWR_CNTL TABLE.            **         
T29686** 09/23/03      COVANSYS  CHANGED RESTART-DATA-LENGTH TO +99  **         
T29686**                         TO AVOID SOC7 ABENDS DURING RESTART.**         
C30472** 06/24/04      BASKAR V  CHANGED DEFAULT PURGE VALUE FROM    **         
C30472**                         400 TO 180                          **         
C30472** 05/28/04      BASKAR V  REMOVE FCS EXTRACT CHECK SINCE FCS  **         
C30472**                         IS MERGED WITH CIS                  **         
C36006** 09/06/07      BASKAR V  COMMENT ALL ONLINE JOURNAL PURGE,   **         
C36006**                         THIS IS HANDLED IN NEW PROGRAM      **         
C36006**                         PCSAC188.                           **         
ACT306** 10/20/16   RB19957      REMOVE ALL LOGIC THAT CALLS DB2     **         
ACT306** APPL00005460,ACT306     TABLE CSS_BILL_AGNT_PYMT & TBBAPYMT.**         
ACT306**                         ALSO REMOVE LOGIC NO LONGER USED.   **         
ACT323** 11/01/16   AD7F921      ADD DELETE QUERY TO DELETE FROM     **         
ACT323** APPL00005460,ACT323     CSS_BCH_JRNL_CNTL HAVING ZERO       **         
ACT323**                         AMOUNT.                             **         
      *****************************************************************         
      *                  N A R R A T I V E                            *         
      *                                                               *         
      *             * *   NO REPORTS PRODUCED  * *                    *         
      *     THIS PROGRAM DELETES THE BATCH JOURNAL, CASH DRAWER       *         
      *     JOURNAL, AND MISCELLANEOUS JOURNAL. IT ALSO CLEARS        *         
      *     ALL CREDITS AND DEBITS FROM BATCH CONTROL JOURNAL         *         
      *     AND CASH DRAWER CONTROL JOURNAL.                          *         
      * *                                                           * *         
           REMARKS.                                                     
           ----------- BASIC BATCH SEQUENCE STRUCTURE -------------     
                0000 - 0000     MAIN CONTROL PATH                       
                ---------------------------------------------------     
                0100 - 0100     SETS CURRENT DATE, DATE 6 DAYS AGO      
                ---------------------------------------------------     
                1000 - 1000     CONTROLS TOM PROCESSING                 
                2000 - 2000     CLEARS TOM SEGMENT                      
                2100 - 2100     CONTROLS TOC DELETIONS AND CLEARING     
                2110 - 2110     CLEARS TOC SEGMENT                      
                ---------------------------------------------------     
                7000 - 7200     INQUIRY CALLS TO DATABASES              
                8000 - 8200     UPDATE CALLS TO DATABASES               
                ---------------------------------------------------     
                    9900 - 9900     ABEND                               
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
HPCCDM*EJECT                                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
HPCCDM*EJECT                                                                    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA124'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA124'.      
       01  WS-MISC.                                                     
           05 WS-START                 PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA124 STARTS HERE'.            
           05  WS-DATE-PARM-DAYS-AGO  PIC X(10).                        
           05  WS-NULL-IND            PIC S9(04)     VALUE ZERO COMP.   
T22024     05  WS-NULL-IND1           PIC S9(04)     VALUE ZERO COMP.   
T22024*    05  WS-DEFAULT-PURGE-JRNL  PIC 9(02)      VALUE 6.                   
T22024*    05  WS-PURGE-JRNL          PIC 9(02)      VALUE ZERO.                
C30472*    05  WS-DEFAULT-PURGE-JRNL  PIC 9(04)      VALUE 400.                 
C30472     05  WS-DEFAULT-PURGE-JRNL  PIC 9(04)      VALUE 180.         
T22024     05  WS-PURGE-JRNL          PIC 9(04)      VALUE ZERO.        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE FIOCA00                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE FIOJC01                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE    PIC 9(01).                    
           05  WS-RESTART-JOB-COMPLETE  REDEFINES                       
               WS-RESTART-PROCESS-TYPE  PIC X(01).                      
           05  WS-RESTART-JOB-STATUS      PIC X(01).                    
               88  WS-RUN-COMPLETED-NO-PROBLEMS    VALUE 'A'.           
               88  WS-RERUN-COMPLETED              VALUE 'B'.           
               88  WS-RERUN-PENDING                VALUE 'C'.           
           05  WS-RESTART-INPUT-DATE      PIC X(10).                    
           05  WS-RESTART-CHKP-SEQ-NO     PIC S9(05) COMP-3 VALUE ZERO. 
      *** THIS REPOSITION KEY IS NOT NEEDED TO RE-OPEN CURSORS OR FOR           
      *** RESTART.  IT IS USED ONLY TO DISPLAY KEY OF LAST ROW PROCESSED        
      *** PRIOR TO COMMIT:                                                      
           05  WS-RESTART-REPOSITION-KEY.                               
               10  WS-RESTART-CASH-COMPANY-NO     PIC X(02).            
               10  WS-RESTART-CASH-LOCAL-OFFICE   PIC X(03).            
               10  WS-RESTART-CASH-REPORT-NO      PIC X(03).            
               10  WS-RESTART-DATE-CASH-REPORT    PIC X(10).            
               10  WS-RESTART-CASH-DRAWER-ID      PIC S9(4) COMP.       
      *  THE FOLLOWING FIELDS ARE TO STORE OFF THE DATABASE UPDATE              
      *  TOTAL COUNTERS IN THE RESTART DATA:                                    
      *                                                                         
           05  WS-RESTART-BC-UPDT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-BC-DLET-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-BJ-DLET-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-CS-UPDT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-CJ-DLET-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-MJ-DLET-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-RF-UPDT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-RF-ISRT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
      *  THE FOLLOWING FIELDS ARE TO STORE OFF THE DATABASE UPDATE              
      *  COUNTERS "PER LUW" IN THE RESTART DATA:                                
      *                                                                         
           05  WS-RESTART-BC-UPDT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-BC-DLET-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-BJ-DLET-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-CS-UPDT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-CJ-DLET-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-MJ-DLET-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-RF-UPDT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-RF-ISRT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
      *  THERE ARE NO RUNNING TOTAL FIELDS IN THIS PROGRAM:                     
       01  WS-RESTART-MISC.                                             
           05  WS-IS-THIS-A-RESTART      PIC X(01) VALUE 'N'.           
               88  WS-THIS-IS-A-RESTART      VALUE 'Y'.                 
           05  WS-PRINT-COUNTERS         PIC X(01) VALUE 'A'.           
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-DEFAULT-RESTART-REQ    PIC X(01) VALUE 'N'.           
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) VALUE ZEROES COMP.
           05  WS-PROCESS-TYPE           PIC 9(01).                     
T29686*    05  WS-RESTART-DATA-LENGTH    PIC S9(04) COMP VALUE +88.             
T29686     05  WS-RESTART-DATA-LENGTH    PIC S9(04) COMP VALUE +99.     
           05  WS-REPOSITION-NEEDED      PIC X(01) VALUE 'Y'.           
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04) VALUE 4.             
           05  WS-CHKP-LUW-LIMIT         PIC 9(04).                     
           05  WS-CHKP-LUW-COUNTER       PIC S9(04) COMP-3              
                                         VALUE ZERO.                    
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04) VALUE 20.            
           05  WS-CHKP-UPD-LIMIT         PIC 9(04).                     
           05  WS-CHKP-UPD-COUNTER       PIC S9(04) COMP-3              
                                         VALUE ZERO.                    
T19086     05  WS-ACTIVE-RETURN-CODE-ED  PIC -(9)9    VALUE SPACES.     
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID   PIC X(02) VALUE '24'.               
               10  WS-CHKP-PART-NO  PIC 9(01) VALUE 1.                  
               10  WS-CHKP-SEQ-NO   PIC 9(05) VALUE ZERO.               
      * THE FOLLOWING FIELD WILL ALLOW PROGRAMMER TO FORCE ABEND BY             
      * SPECIFYING WHICH LOOP TO ABEND IN AND WHICH CONCATENATED KEY TO         
      * ABEND ON:                                                               
           05  WS-STOP-CONCATENATED-KEY.                                
               10  WS-STOP-PROCESS-TYPE  PIC X(06).                     
                   88  STOP-REQUESTED-IN-BC-LOOP VALUE 'BCLOOP'.        
                   88  STOP-REQUESTED-IN-CS-LOOP VALUE 'CSLOOP'.        
      *** IT IS NOT POSSIBLE TO CAUSE INTENTIONAL ABEND DURING MJLOOP,          
      *** WHICH CONSISTS OF A DELETE CALL THAT WILL DLET MULTIPLE ROWS.         
               10  WS-STOP-CASH-COMPANY-NO     PIC X(02).               
               10  WS-STOP-CASH-LOCAL-OFFICE   PIC X(03).               
               10  WS-STOP-CASH-REPORT-NO      PIC X(03).               
               10  WS-STOP-DATE-CASH-REPORT    PIC X(10).               
               10  WS-STOP-CASH-DRAWER-ID      PIC 9(04).               
      *                                                                         
       01  WS-STOP-PARM-BREAKDOWN.                                      
           05  WS-STOP-PARM-PROCESS-TYPE       PIC X(06).               
               88  STOP-PARM-REQUESTED-BC-LOOP VALUE 'BCLOOP'.          
               88  STOP-PARM-REQUESTED-CS-LOOP VALUE 'CSLOOP'.          
           05  WS-STOP-PARM-CASH-COMPANY-NO    PIC X(02).               
           05  WS-STOP-PARM-CASH-LOCAL-OFFICE  PIC X(03).               
           05  WS-STOP-PARM-CASH-REPORT-NO     PIC X(03).               
           05  WS-STOP-PARM-DATE-CASH-REPORT.                           
               10  WS-STOP-PARM-CCYY           PIC 9(04).               
               10  WS-STOP-PARM-DASH-1         PIC X(01).               
               10  WS-STOP-PARM-MM             PIC 9(02).               
               10  WS-STOP-PARM-DASH-2         PIC X(01).               
               10  WS-STOP-PARM-DD             PIC 9(02).               
           05  WS-STOP-PARM-CASH-DRAWER-ID     PIC 9(04).               
           05  FILLER                          PIC X(21).               
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-I                    PIC X(01)     VALUE 'I'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-BALANCED             PIC X(01)     VALUE 'B'.         
T15045     05  WS-CLOSED               PIC X(01)     VALUE 'C'.         
           05  WS-1                    PIC 9(01)     VALUE 1.           
           05  WS-2                    PIC 9(01)     VALUE 2.           
           05  WS-3                    PIC 9(01)     VALUE 3.           
           05  WS-4                    PIC 9(01)     VALUE 4.           
           05  WS-9                    PIC 9(01)     VALUE 9.           
           05  WS-999                  PIC 9(03)     VALUE 999.         
           05  WS-BCLOOP               PIC X(06)     VALUE 'BCLOOP'.    
           05  WS-CSLOOP               PIC X(06)     VALUE 'CSLOOP'.    
           05  WS-ZZZZZZ               PIC X(06)     VALUE 'ZZZZZZ'.    
           05  WS-DASH                 PIC X(01)     VALUE '-'.         
           05  WS-LIT-99               PIC X(02)     VALUE '99'.        
           05  WS-LIT-999              PIC X(03)     VALUE '999'.       
           05  WS-ZERO-DATE            PIC X(10)                        
               VALUE '0001-01-01'.                                      
       01  WS-DISPLAY-DATE.                                             
           05  WS-DISPLAY-CC           PIC X(02).                       
           05  WS-DISPLAY-YY           PIC X(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-DISPLAY-MM           PIC X(02).                       
           05  FILLER                  PIC X(01).                       
           05  WS-DISPLAY-DD           PIC X(02).                       
      *                                                                         
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00038.                                                           
       01  WS-INPUT-DATA-R8  REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           05  WS-SYSIPT-R8        PIC X(10).                           
               88  PURGE-JRNL      VALUE 'PURGE JRNL'.                  
           05  FILLER              PIC X(01).                           
T22024*    05  WS-PURGE-JRNL-PARM  PIC 9(02).                                   
T22024     05  WS-PURGE-JRNL-PARM  PIC 9(03).                           
           05  FILLER              PIC X(40).                           
T22024 01  WS-BALANCED-DT          PIC X(10).                           
      *                                                                         
       COPY CWS00039.                                                           
T18127*COPY CWS00018.                                                           
T18127     EXEC SQL                                                             
T18127          INCLUDE CWS00018                                                
T18127     END-EXEC.                                                            
       COPY CWS00303.                                                           
HPCCDM*EJECT                                                                    
      *                                                                         
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE              PIC X(02) VALUE SPACE.       
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC       PIC 99.                       
      *                                                                         
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA124 ENDS HERE  '.            
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCDCNTL                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCDJRNL                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBBJCNTL                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBBTJRNL                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBMSJRNL                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBRESTRT                                                
           END-EXEC.                                                            
      ********************                                                      
      * BATCH-JRNL-CNTRL *                                                      
      ********************                                                      
           EXEC SQL                                                     
T7796           DECLARE BATCH_JRNL_CNTL CURSOR WITH HOLD FOR            
                SELECT                                                  
                 CASH_COMPANY_NO,                                       
                 CASH_LOCAL_OFFICE,                                     
                 CASH_REPORT_NO,                                        
                 DATE_CASH_REPORT,                                      
                 CASH_DRAWER_ID,                                        
                 CODE_BATCH_STATUS,                                     
                 DATE_BATCH_ENTERED,                                    
                 DATE_LAST_ACTIVITY,                                    
                 NO_ITEMS_ENTERED,                                      
                 AMT_CASH_DEBIT,                                        
                 AMT_CASH_CREDIT,                                       
                 AMT_AR_DEBIT,                                          
                 AMT_AR_CREDIT,                                         
                 AMT_CK_ISS_DEBIT,                                      
                 AMT_CK_ISS_CREDIT,                                     
                 AMT_GL_DEBIT,                                          
                 AMT_GL_CREDIT,                                         
                 AMT_NET_BATCH,                                         
                 NO_ITEMS_POSTED,                                       
                 AMT_BATCH_DEBITS,                                      
                 AMT_BATCH_CREDITS,                                     
T14762           CODE_BATCH_STATUS                                      
                FROM CSS_BCH_JRNL_CNTL                                  
                WHERE  CASH_COMPANY_NO    >=  '  '           AND        
                       CASH_LOCAL_OFFICE  >=  '   '          AND        
                       CASH_REPORT_NO     >=  '   '          AND        
                       DATE_CASH_REPORT   >=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-ZERO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ZERO-DATE
              ) <> 0) OR (LEN(:WS-ZERO-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-ZERO-DATE
              ), CONVERT(DATE, :WS-ZERO-DATE) )  AND        
                       CASH_DRAWER_ID     >=  0              AND        
      *** THIS WILL ASSURE ON RESTART THAT CURSOR WILL FETCH NOT-YET-           
      *** PROCESSED ROWS (AMT_NET_BATCH IS AN ACCUM FROM AMT_CASH_DEBIT         
      *** & AMT_CASH_CREDIT.  SINCE THIS PREDICATE MUST EXCLUDE                 
      *** AMT_NET_BATCH, IT MAY POSSIBLY RE-RETRIEVE A ROW FOR A                
      *** BCH_JRNL_CNTL THAT HAD NO ACTIVITY SINCE THE LAST TIME IT WAS         
      *** RESET BY PCSCA124.  HOWEVER, THIS WILL NOT HURT ANYTHING, IT          
      *** WILL SIMPLY RE-ADD 0 TO AMT_NET_BATCH AND RE-SUBTRACT 0 FROM          
      *** AMT_NET_BATCH AND UPDATE IT):                                         
                    (NO_ITEMS_ENTERED         <> 0                      
                     OR AMT_CASH_DEBIT        <> 0                      
                     OR AMT_CASH_CREDIT       <> 0                      
                     OR AMT_AR_DEBIT          <> 0                      
                     OR AMT_AR_CREDIT         <> 0                      
                     OR AMT_CK_ISS_DEBIT      <> 0                      
                     OR AMT_CK_ISS_CREDIT     <> 0                      
                     OR AMT_GL_DEBIT          <> 0                      
                     OR AMT_GL_CREDIT         <> 0                      
                     OR NO_ITEMS_POSTED       <> 0                      
                     OR AMT_BATCH_DEBITS      <> 0                      
                     OR AMT_BATCH_CREDITS     <> 0)                     
                FOR UPDATE OF                                           
                   AMT_CASH_DEBIT, AMT_CASH_CREDIT, AMT_AR_DEBIT,       
                   AMT_AR_CREDIT, AMT_CK_ISS_DEBIT, AMT_CK_ISS_CREDIT,  
                   AMT_GL_DEBIT, AMT_GL_CREDIT, AMT_NET_BATCH,          
                   NO_ITEMS_POSTED, AMT_BATCH_DEBITS, AMT_BATCH_CREDITS,
T14762             CODE_BATCH_STATUS                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE BATCH_JRNL_CNTL CURSOR WITH HOLD FOR                    
MFA-TR*         SELECT                                                          
MFA-TR*          CASH_COMPANY_NO,                                               
MFA-TR*          CASH_LOCAL_OFFICE,                                             
MFA-TR*          CASH_REPORT_NO,                                                
MFA-TR*          DATE_CASH_REPORT,                                              
MFA-TR*          CASH_DRAWER_ID,                                                
MFA-TR*          CODE_BATCH_STATUS,                                             
MFA-TR*          DATE_BATCH_ENTERED,                                            
MFA-TR*          DATE_LAST_ACTIVITY,                                            
MFA-TR*          NO_ITEMS_ENTERED,                                              
MFA-TR*          AMT_CASH_DEBIT,                                                
MFA-TR*          AMT_CASH_CREDIT,                                               
MFA-TR*          AMT_AR_DEBIT,                                                  
MFA-TR*          AMT_AR_CREDIT,                                                 
MFA-TR*          AMT_CK_ISS_DEBIT,                                              
MFA-TR*          AMT_CK_ISS_CREDIT,                                             
MFA-TR*          AMT_GL_DEBIT,                                                  
MFA-TR*          AMT_GL_CREDIT,                                                 
MFA-TR*          AMT_NET_BATCH,                                                 
MFA-TR*          NO_ITEMS_POSTED,                                               
MFA-TR*          AMT_BATCH_DEBITS,                                              
MFA-TR*          AMT_BATCH_CREDITS,                                             
MFA-TR*          CODE_BATCH_STATUS                                              
MFA-TR*         FROM CSS_BCH_JRNL_CNTL                                          
MFA-TR*         WHERE  CASH_COMPANY_NO    >=  '  '           AND                
MFA-TR*                CASH_LOCAL_OFFICE  >=  '   '          AND                
MFA-TR*                CASH_REPORT_NO     >=  '   '          AND                
MFA-TR*                DATE_CASH_REPORT   >=  :WS-ZERO-DATE  AND                
MFA-TR*                CASH_DRAWER_ID     >=  0              AND                
MFA-TR*** THIS WILL ASSURE ON RESTART THAT CURSOR WILL FETCH NOT-YET-           
MFA-TR*** PROCESSED ROWS (AMT_NET_BATCH IS AN ACCUM FROM AMT_CASH_DEBIT         
MFA-TR*** & AMT_CASH_CREDIT.  SINCE THIS PREDICATE MUST EXCLUDE                 
MFA-TR*** AMT_NET_BATCH, IT MAY POSSIBLY RE-RETRIEVE A ROW FOR A                
MFA-TR*** BCH_JRNL_CNTL THAT HAD NO ACTIVITY SINCE THE LAST TIME IT WAS         
MFA-TR*** RESET BY PCSCA124.  HOWEVER, THIS WILL NOT HURT ANYTHING, IT          
MFA-TR*** WILL SIMPLY RE-ADD 0 TO AMT_NET_BATCH AND RE-SUBTRACT 0 FROM          
MFA-TR*** AMT_NET_BATCH AND UPDATE IT):                                         
MFA-TR*             (NO_ITEMS_ENTERED         = 0                              
MFA-TR*              OR AMT_CASH_DEBIT        = 0                              
MFA-TR*              OR AMT_CASH_CREDIT       = 0                              
MFA-TR*              OR AMT_AR_DEBIT          = 0                              
MFA-TR*              OR AMT_AR_CREDIT         = 0                              
MFA-TR*              OR AMT_CK_ISS_DEBIT      = 0                              
MFA-TR*              OR AMT_CK_ISS_CREDIT     = 0                              
MFA-TR*              OR AMT_GL_DEBIT          = 0                              
MFA-TR*              OR AMT_GL_CREDIT         = 0                              
MFA-TR*              OR NO_ITEMS_POSTED       = 0                              
MFA-TR*              OR AMT_BATCH_DEBITS      = 0                              
MFA-TR*              OR AMT_BATCH_CREDITS     = 0)                             
MFA-TR*         FOR UPDATE OF                                                   
MFA-TR*            AMT_CASH_DEBIT, AMT_CASH_CREDIT, AMT_AR_DEBIT,               
MFA-TR*            AMT_AR_CREDIT, AMT_CK_ISS_DEBIT, AMT_CK_ISS_CREDIT,          
MFA-TR*            AMT_GL_DEBIT, AMT_GL_CREDIT, AMT_NET_BATCH,                  
MFA-TR*            NO_ITEMS_POSTED, AMT_BATCH_DEBITS, AMT_BATCH_CREDITS,        
MFA-TR*            CODE_BATCH_STATUS                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ********************                                                      
      * CASH-DRAWER-CNTRL*                                                      
      ********************                                                      
           EXEC SQL                                                     
T7796           DECLARE CASH_DRWR_CNTL CURSOR WITH HOLD FOR             
                SELECT                                                  
                   CASH_COMPANY_NO,                                     
                   CASH_LOCAL_OFFICE,                                   
                   CASH_REPORT_NO,                                      
                   DATE_CASH_REPORT,                                    
                   CASH_DRAWER_ID,                                      
                   AMT_CASH_DEBIT,                                      
                   AMT_CASH_CREDIT,                                     
                   AMT_AR_DEBIT,                                        
                   AMT_AR_CREDIT,                                       
                   AMT_CK_ISS_DEBIT,                                    
                   AMT_CK_ISS_CREDIT,                                   
                   AMT_GL_DEBIT,                                        
                   AMT_GL_CREDIT,                                       
                   AMT_CASH_BEGIN_BAL,                                  
                   AMT_BASIC_WORK,                                      
                   CODE_CSH_DRWR_STAT,                                  
                   DATE_LAST_ACTIVITY,                                  
T22024             CAST(BALANCED_TS AS DATE),                                   
T12023             CODE_FCS_EXTRACTED,                                  
                   NO_ITEMS_ENTERED                                     
              FROM CSS_CSH_DRWR_CNTL                                    
              WHERE  CASH_COMPANY_NO    >=  '  '           AND          
                     CASH_LOCAL_OFFICE  >=  '   '          AND          
                     CASH_REPORT_NO     >=  '   '          AND          
                     DATE_CASH_REPORT   >=  IIF(TRY_CONVERT(DATE, 
                                                          :WS-ZERO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-ZERO-DATE
              ) <> 0) OR (LEN(:WS-ZERO-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-ZERO-DATE
              ), CONVERT(DATE, :WS-ZERO-DATE) )  AND          
                     CASH_DRAWER_ID     >=  0              AND          
      *** THIS WILL ASSURE ON RESTART THAT CURSOR WILL FETCH NOT-YET-           
      *** PROCESSED ROWS (AMT_CASH_BEGIN_BAL IS NET FROM AMT_CASH_DEBIT         
      *** & AMT_CASH_CREDIT.  SINCE THIS PREDICATE MUST EXCLUDE                 
      *** AMT_CASH_BEGIN_BAL, IT MAY POSSIBLY RE-RETRIEVE A ROW FOR A           
      *** CSH_DRWR_CNTL THAT HAD NO ACTIVITY SINCE THE LAST TIME IT WAS         
      *** RESET BY PCSCA124.  HOWEVER, THIS WILL NOT HURT ANYTHING, IT          
      *** WILL SIMPLY RE-ADD 0 TO AMT_CASH_BEGIN_BAL AND RE-SUBTRACT 0          
      *** FROM AMT_CASH_BEGIN_BAL AND UPDATE IT):                               
                       (AMT_CASH_DEBIT        <> 0                      
                     OR AMT_CASH_CREDIT       <> 0                      
                     OR AMT_AR_DEBIT          <> 0                      
                     OR AMT_AR_CREDIT         <> 0                      
                     OR AMT_CK_ISS_DEBIT      <> 0                      
                     OR AMT_CK_ISS_CREDIT     <> 0                      
                     OR AMT_GL_DEBIT          <> 0                      
                     OR AMT_GL_CREDIT         <> 0                      
                     OR AMT_CASH_BEGIN_BAL    <> 0                      
                     OR AMT_BASIC_WORK        <> 0                      
                     OR NO_ITEMS_ENTERED      <> 0)                     
              FOR UPDATE OF                                             
      *** THE FOLLOWING 3 FLDS ARE NOT UPDATED IN THE UPDATE CALL:              
      *            DATE_LAST_ACTIVITY, AMT_BASIC_WORK, NO_ITEMS_ENTERED         
      *** TP2530 REMOVED THE ZEROING OF NO-ITEMS-ENTERED BECAUSE CA124          
      *** DOES NOT ALWAYS DELETE ALL JRNLS UNDER A CNTL.  NO-ITEMS-             
      *** ENTERED IS USED TO PROVIDE A SEED VALUE SO THAT JOURNALLING           
      *** ROUTINE CAN INSERT A JRNL WITH A UNIQUE KEY WITHOUT DOING A           
      *** SELECT MAX(ENTRY_NO) CALL FOR EACH INSERTED JRNL.  ADDING A           
      *** SELECT MAX(ENTRY_NO) TO THE JOURNALLING ROUTINE WOULD IMPACT          
      *** ONLINE PERFORMANCE TOO GREATLY.  TP2530 PREVENTS MOST DUP-ISRT        
      *** ABENDS, BUT 114110 WILL FURTHER AVERT THIS POSSIBILITY BY             
      *** RESETTING NO-ITEMS-ENTERED, NIGHTLY, BASED ON THE RESULTS OF          
      *** MAX(ENTRY_NO) AFTER "PURGE" DELETIONS ARE COMPLETE FOR THIS           
      *** CASH DRAWER.  THIS RESETTING HELPS GUARD AGAINST ROLLOVER.            
                   AMT_CASH_DEBIT, AMT_CASH_CREDIT, AMT_AR_DEBIT,       
                   AMT_AR_CREDIT, AMT_CK_ISS_DEBIT, AMT_CK_ISS_CREDIT,  
                   AMT_GL_DEBIT, AMT_GL_CREDIT, AMT_CASH_BEGIN_BAL,     
                   AMT_BASIC_WORK, NO_ITEMS_ENTERED                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE CASH_DRWR_CNTL CURSOR WITH HOLD FOR                     
MFA-TR*         SELECT                                                          
MFA-TR*            CASH_COMPANY_NO,                                             
MFA-TR*            CASH_LOCAL_OFFICE,                                           
MFA-TR*            CASH_REPORT_NO,                                              
MFA-TR*            DATE_CASH_REPORT,                                            
MFA-TR*            CASH_DRAWER_ID,                                              
MFA-TR*            AMT_CASH_DEBIT,                                              
MFA-TR*            AMT_CASH_CREDIT,                                             
MFA-TR*            AMT_AR_DEBIT,                                                
MFA-TR*            AMT_AR_CREDIT,                                               
MFA-TR*            AMT_CK_ISS_DEBIT,                                            
MFA-TR*            AMT_CK_ISS_CREDIT,                                           
MFA-TR*            AMT_GL_DEBIT,                                                
MFA-TR*            AMT_GL_CREDIT,                                               
MFA-TR*            AMT_CASH_BEGIN_BAL,                                          
MFA-TR*            AMT_BASIC_WORK,                                              
MFA-TR*            CODE_CSH_DRWR_STAT,                                          
MFA-TR*            DATE_LAST_ACTIVITY,                                          
MFA-TR*            DATE(BALANCED_TS),                                           
MFA-TR*            CODE_FCS_EXTRACTED,                                          
MFA-TR*            NO_ITEMS_ENTERED                                             
MFA-TR*       FROM CSS_CSH_DRWR_CNTL                                            
MFA-TR*       WHERE  CASH_COMPANY_NO    >=  '  '           AND                  
MFA-TR*              CASH_LOCAL_OFFICE  >=  '   '          AND                  
MFA-TR*              CASH_REPORT_NO     >=  '   '          AND                  
MFA-TR*              DATE_CASH_REPORT   >=  :WS-ZERO-DATE  AND                  
MFA-TR*              CASH_DRAWER_ID     >=  0              AND                  
MFA-TR*** THIS WILL ASSURE ON RESTART THAT CURSOR WILL FETCH NOT-YET-           
MFA-TR*** PROCESSED ROWS (AMT_CASH_BEGIN_BAL IS NET FROM AMT_CASH_DEBIT         
MFA-TR*** & AMT_CASH_CREDIT.  SINCE THIS PREDICATE MUST EXCLUDE                 
MFA-TR*** AMT_CASH_BEGIN_BAL, IT MAY POSSIBLY RE-RETRIEVE A ROW FOR A           
MFA-TR*** CSH_DRWR_CNTL THAT HAD NO ACTIVITY SINCE THE LAST TIME IT WAS         
MFA-TR*** RESET BY PCSCA124.  HOWEVER, THIS WILL NOT HURT ANYTHING, IT          
MFA-TR*** WILL SIMPLY RE-ADD 0 TO AMT_CASH_BEGIN_BAL AND RE-SUBTRACT 0          
MFA-TR*** FROM AMT_CASH_BEGIN_BAL AND UPDATE IT):                               
MFA-TR*                (AMT_CASH_DEBIT        = 0                              
MFA-TR*              OR AMT_CASH_CREDIT       = 0                              
MFA-TR*              OR AMT_AR_DEBIT          = 0                              
MFA-TR*              OR AMT_AR_CREDIT         = 0                              
MFA-TR*              OR AMT_CK_ISS_DEBIT      = 0                              
MFA-TR*              OR AMT_CK_ISS_CREDIT     = 0                              
MFA-TR*              OR AMT_GL_DEBIT          = 0                              
MFA-TR*              OR AMT_GL_CREDIT         = 0                              
MFA-TR*              OR AMT_CASH_BEGIN_BAL    = 0                              
MFA-TR*              OR AMT_BASIC_WORK        = 0                              
MFA-TR*              OR NO_ITEMS_ENTERED      = 0)                             
MFA-TR*       FOR UPDATE OF                                                     
MFA-TR*** THE FOLLOWING 3 FLDS ARE NOT UPDATED IN THE UPDATE CALL:              
MFA-TR*            DATE_LAST_ACTIVITY, AMT_BASIC_WORK, NO_ITEMS_ENTERED         
MFA-TR*** TP2530 REMOVED THE ZEROING OF NO-ITEMS-ENTERED BECAUSE CA124          
MFA-TR*** DOES NOT ALWAYS DELETE ALL JRNLS UNDER A CNTL.  NO-ITEMS-             
MFA-TR*** ENTERED IS USED TO PROVIDE A SEED VALUE SO THAT JOURNALLING           
MFA-TR*** ROUTINE CAN INSERT A JRNL WITH A UNIQUE KEY WITHOUT DOING A           
MFA-TR*** SELECT MAX(ENTRY_NO) CALL FOR EACH INSERTED JRNL.  ADDING A           
MFA-TR*** SELECT MAX(ENTRY_NO) TO THE JOURNALLING ROUTINE WOULD IMPACT          
MFA-TR*** ONLINE PERFORMANCE TOO GREATLY.  TP2530 PREVENTS MOST DUP-ISRT        
MFA-TR*** ABENDS, BUT 114110 WILL FURTHER AVERT THIS POSSIBILITY BY             
MFA-TR*** RESETTING NO-ITEMS-ENTERED, NIGHTLY, BASED ON THE RESULTS OF          
MFA-TR*** MAX(ENTRY_NO) AFTER "PURGE" DELETIONS ARE COMPLETE FOR THIS           
MFA-TR*** CASH DRAWER.  THIS RESETTING HELPS GUARD AGAINST ROLLOVER.            
MFA-TR*            AMT_CASH_DEBIT, AMT_CASH_CREDIT, AMT_AR_DEBIT,               
MFA-TR*            AMT_AR_CREDIT, AMT_CK_ISS_DEBIT, AMT_CK_ISS_CREDIT,          
MFA-TR*            AMT_GL_DEBIT, AMT_GL_CREDIT, AMT_CASH_BEGIN_BAL,             
MFA-TR*            AMT_BASIC_WORK, NO_ITEMS_ENTERED                             
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                                
       PROCEDURE DIVISION.                                              
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE    THRU 0100-EXIT.                   
           PERFORM 0200-CALC-DATE-PARM-DAYS-AGO THRU 0200-EXIT.         
           PERFORM 0600-PREPARE-FOR-RESTART THRU 0600-EXIT.             
           PERFORM 0605-VALIDATE-RESTART-REQ THRU 0605-EXIT.            
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES TO WS-RESTART-INPUT-DATE                     
               MOVE WS-C   TO WS-RESTART-JOB-STATUS                     
               MOVE ZERO   TO WS-RESTART-CHKP-SEQ-NO                    
      *        **  MOVE ZERO TO ALL OUTPUT FILE COUNTER FIELDS        **        
      *        **  MOVE ZERO TO ALL DATABASE UPDATE COUNTER FIELDS    **        
      *        **  FIELDS THAT ARE "RESTART DATA" FIELDS.             **        
                 MOVE ZERO TO WS-RESTART-BC-UPDT-CNTR-LUW               
                              WS-RESTART-BC-DLET-CNTR-LUW               
                              WS-RESTART-BJ-DLET-CNTR-LUW               
                              WS-RESTART-CS-UPDT-CNTR-LUW               
                              WS-RESTART-CJ-DLET-CNTR-LUW               
                              WS-RESTART-MJ-DLET-CNTR-LUW               
                              WS-RESTART-RF-UPDT-CNTR-LUW               
                              WS-RESTART-RF-ISRT-CNTR-LUW               
                 MOVE ZERO TO WS-RESTART-BC-UPDT-CNTR-TOT               
                              WS-RESTART-BC-DLET-CNTR-TOT               
                              WS-RESTART-BJ-DLET-CNTR-TOT               
                              WS-RESTART-CS-UPDT-CNTR-TOT               
                              WS-RESTART-CJ-DLET-CNTR-TOT               
                              WS-RESTART-MJ-DLET-CNTR-TOT               
                              WS-RESTART-RF-UPDT-CNTR-TOT               
                              WS-RESTART-RF-ISRT-CNTR-TOT
           END-IF.              
      ***  PREDICATE KEYS ARE HARD-CODED VALUES, WRITTEN  **                    
      ***  MERELY TO FETCH ALL NOT-YET-RESET JOURNAL      **                    
      ***  CONTROLS.  THERE ARE NO FIELDS TO BE LOADED    **                    
      ***  WITH KEY VALUES TO POSITION THE CURSORS.       **                    
           IF WS-THIS-IS-A-RESTART                                      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-1   TO WS-PROCESS-TYPE                           
      *        ********************************************************         
      *          ISSUE AN INITIAL CHECKPOINT:                                   
      *        ********************************************************         
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                   
*******        MOVE WS-Y TO WS-REPOSITION-NEEDED                                
               MOVE WS-INPUT-DATE TO WS-RESTART-INPUT-DATE
           END-IF.             
           PERFORM 1000-PROCESS-JRNL-RECORDS THRU 1000-EXIT.            
      ******************************************************************        
      * THE FOLLOWING STATEMENTS UPGRADE THE JOB-COMPLETE FIELD TO              
      * INDICATE A SUCCESSFUL COMPLETION:                                       
      ******************************************************************        
           MOVE SPACES    TO WS-RESTART-JOB-COMPLETE.                   
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-B TO WS-RESTART-JOB-STATUS                       
           ELSE                                                         
               MOVE WS-A TO WS-RESTART-JOB-STATUS
           END-IF.                      
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
           AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS      
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 8899-WRITE-RSDDR THRU 8899-EXIT
           END-IF.                 
      *                                                                         
           IF WS-RESTART-REQ EQUAL WS-Y                                 
               PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT
           END-IF.      
      *                                                                         
           IF WS-PRINT-COUNTERS EQUAL WS-B OR WS-C                      
               PERFORM 8600-PRINT-COUNTERS THRU 8600-EXIT
           END-IF.              
           PERFORM 9000-TERMINATE     THRU 9000-EXIT.                   
      *                                                                         
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *****************************************************************         
      * 0100-INITIALIZE ... STANDARD INITIALIZATION PROCEDURE ......  *         
      *****************************************************************         
       0100-INITIALIZE.                                                 
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT       
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE
           END-IF.           
           PERFORM 6253-GET-FJC01-CHKP-LIMIT THRU 6253-EXIT.            
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
           AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS      
               DISPLAY ' '                                              
               DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
               DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'          
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
                       ', INTERPRETED TO**'                             
               DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'          
               DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'          
               DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'          
               DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'          
               DISPLAY '**      PROCESSING CONTINUING      **'
           END-IF.         
           PERFORM 6254-GET-FJC01-STOP-KEY   THRU 6254-EXIT.            
           MOVE WS-STOP-KEY TO WS-STOP-PARM-BREAKDOWN.                  
           IF WS-STOP-PARM-PROCESS-TYPE GREATER THAN SPACES             
               MOVE WS-STOP-PARM-PROCESS-TYPE TO WS-STOP-PROCESS-TYPE   
           ELSE                                                         
               MOVE WS-ZZZZZZ                 TO WS-STOP-PROCESS-TYPE
           END-IF.  
           IF WS-STOP-PARM-CASH-COMPANY-NO NUMERIC                      
               MOVE WS-STOP-PARM-CASH-COMPANY-NO                        
                                          TO WS-STOP-CASH-COMPANY-NO    
           ELSE                                                         
               MOVE WS-LIT-99             TO WS-STOP-CASH-COMPANY-NO
           END-IF.   
           IF WS-STOP-PARM-CASH-LOCAL-OFFICE NUMERIC                    
               MOVE WS-STOP-PARM-CASH-LOCAL-OFFICE                      
                                          TO WS-STOP-CASH-LOCAL-OFFICE  
           ELSE                                                         
               MOVE WS-LIT-999            TO WS-STOP-CASH-LOCAL-OFFICE
           END-IF. 
           IF WS-STOP-PARM-CASH-REPORT-NO NUMERIC                       
               MOVE WS-STOP-PARM-CASH-REPORT-NO                         
                                          TO WS-STOP-CASH-REPORT-NO     
           ELSE                                                         
               MOVE WS-LIT-999            TO WS-STOP-CASH-REPORT-NO
           END-IF.    
           IF WS-STOP-PARM-CCYY      NUMERIC AND                        
              WS-STOP-PARM-MM        NUMERIC AND                        
              WS-STOP-PARM-DD        NUMERIC AND                        
              WS-STOP-PARM-DASH-1      EQUAL WS-DASH AND                
              WS-STOP-PARM-DASH-2      EQUAL WS-DASH                    
               MOVE WS-STOP-PARM-DATE-CASH-REPORT                       
                                          TO WS-STOP-DATE-CASH-REPORT   
           ELSE                                                         
               MOVE WS-ZERO-DATE          TO WS-STOP-DATE-CASH-REPORT
           END-IF.  
           IF WS-STOP-PARM-CASH-DRAWER-ID NUMERIC                       
               MOVE WS-STOP-PARM-CASH-DRAWER-ID                         
                                          TO WS-STOP-CASH-DRAWER-ID     
           ELSE                                                         
               MOVE 9999                  TO WS-STOP-CASH-DRAWER-ID
           END-IF.    
           PERFORM 6255-GET-FJC01-PRT-CNTR THRU 6255-EXIT.              
           PERFORM 6235-GET-FJC01-RESTART-REQ THRU 6235-EXIT.           
           MOVE SPACES TO WS-SYSIPT.                                    
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
           PERFORM 7600-START-FCSJC01   THRU   7600-EXIT                
           PERFORM 7610-READ-FCSJC01    THRU 7610-EXIT                  
               UNTIL (PURGE-JRNL AND INPUT-ACTIVE)                      
               OR END-OF-SYSIPT.                                        
           IF END-OF-SYSIPT                                             
               DISPLAY SPACES                                           
               DISPLAY '*   ' WS-PGRMNAME ' INFORMATIONAL MESSAGE'      
               DISPLAY '*   PURGE JRNL PARM NOT ACTIVE             '    
               DISPLAY '*   DEFAULT OF ' WS-DEFAULT-PURGE-JRNL ' WILL'  
                       ' BE USED'                                       
               DISPLAY '*   PROCESSING CONTINUING                  *'   
               MOVE WS-DEFAULT-PURGE-JRNL TO WS-PURGE-JRNL              
           ELSE                                                         
           IF WS-PURGE-JRNL-PARM NUMERIC                                
              MOVE WS-PURGE-JRNL-PARM TO WS-PURGE-JRNL                  
           ELSE                                                         
               DISPLAY SPACES                                           
               DISPLAY '*   ' WS-PGRMNAME ' PROCESSING WARNING'         
               DISPLAY '*   PURGE JRNL PARM NOT NUMERIC            '    
               DISPLAY '*   DEFAULT OF ' WS-DEFAULT-PURGE-JRNL ' WILL'  
                       ' BE USED'                                       
               DISPLAY '*   PROCESSING CONTINUING                  *'   
               MOVE WS-DEFAULT-PURGE-JRNL  TO WS-PURGE-JRNL
           END-IF
           END-IF.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 0200-CALC-DATE-PARM-DAYS-AGO                                  *         
      *****************************************************************         
       0200-CALC-DATE-PARM-DAYS-AGO.                                    
           MOVE WS-INPUT-DATE TO WS-DISPLAY-DATE.                       
           MOVE WS-DISPLAY-CC TO WS-CCD-DATE-CC.                        
           MOVE WS-DISPLAY-YY TO WS-CCD-DATE-YY.                        
           MOVE WS-DISPLAY-MM TO WS-CCD-DATE-MM.                        
           MOVE WS-DISPLAY-DD TO WS-CCD-DATE-DD.                        
           MOVE WS-DISPLAY-DATE TO WS-CCD-START-DATE.                   
           MOVE WS-CCD-SUBTRACT-DAYS TO WS-CCD-PLUS-MINUS.              
           MOVE  WS-PURGE-JRNL TO WS-CCD-DAYS-PLUS-MINUS.               
           PERFORM 6600-COMPUTE-CALENDAR-DATE THRU                      
                   6600-COMPUTE-DATE-EXIT.                              
T19086     PERFORM 7800-SQL-CODE-CHECK           THRU 7800-EXIT.        
           MOVE WS-CCD-NEW-DATE TO WS-DATE-PARM-DAYS-AGO.               
           MOVE WS-DASH TO WS-DATE-PARM-DAYS-AGO (5:1).                 
           MOVE WS-DASH TO WS-DATE-PARM-DAYS-AGO (8:1).                 
       0200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *****************************************************************         
      * 0600-PREPARE-FOR-RESTART                                      *         
      *****************************************************************         
       0600-PREPARE-FOR-RESTART.                                        
           MOVE WS-PGRMNAME    TO RF-NAME-PROGRAM.                      
           MOVE WS-1           TO RF-PARTITION-NO                       
                                  RF-DUP-CNTRL-NO                       
                                  WS-CHKP-PART-NO.                      
           PERFORM 7900-SELECT-RESTART-DATA THRU 7900-EXIT.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT TO WS-RESTART-DATA             
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                   MOVE WS-Y TO WS-IS-THIS-A-RESTART                    
               ELSE                                                     
                   GO TO 0600-EXIT
               END-IF                                      
           ELSE                                                         
               GO TO 0600-EXIT
           END-IF.                                         
      *                                                                         
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF JCSCA124  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-PROCESS-TYPE TO WS-PROCESS-TYPE.             
           MOVE WS-RESTART-CHKP-SEQ-NO  TO WS-CHKP-SEQ-NO.              
      ***********************************************************               
      ** THE FOLLOWING CODE COMPARES RUN DATE STORED IN        **               
      ** RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:       **               
      ***********************************************************               
      *                                                                         
           IF WS-RESTART-INPUT-DATE EQUAL WS-INPUT-DATE                 
           OR WS-RESTART-INPUT-DATE EQUAL SPACES                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '** RUN DATE WAS CHANGED PRIOR TO '              
                       'RESTART **'                                     
               DISPLAY '***************************************'        
               DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE       
               DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE               
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       0600-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
       COPY CPD00030.                                                           
HPCCDM*    EJECT                                                                
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
      **                                                              **        
      **    1000-PROCESS-JRNL-RECORDS.                                **        
      **                                                              **        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **        
       1000-PROCESS-JRNL-RECORDS.                                       
      *** PREDICATE KEYS ARE HARD-CODED IN THE CURSOR, WHETHER THIS IS          
      *** A RESTART OR NOT.  PGM WILL EXECUTE ALL 3 PROCESSING                  
      *** LOOPS, UNLESS WS-PROCESS-TYPE INDICATES THAT THIS IS A RESTART        
      *** RUN AND THE ABEND OCCURRED DURING COMPLETION OF THE 2ND OR 3RD        
      *** LOOP:                                                                 
           IF WS-PROCESS-TYPE EQUAL WS-1                                
               PERFORM 7100-OPEN-BATCH-JRNL-CNTRL   THRU  7100-EXIT     
               PERFORM 7110-FETCH-BATCH-JRNL-CNTRL  THRU  7110-EXIT     
               PERFORM 1100-PROCESS-BATCH-JRNLS     THRU  1100-EXIT     
                 UNTIL  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
               PERFORM 7120-CLOSE-BATCH-JRNL-CNTRL  THRU  7120-EXIT     
               MOVE WS-2 TO WS-PROCESS-TYPE                             
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                   
               MOVE WS-Y TO WS-REPOSITION-NEEDED
           END-IF.                       
      *                                                                         
           IF WS-PROCESS-TYPE EQUAL WS-2                                
               PERFORM 7300-OPEN-CASH-DRWR-CNTRL    THRU  7300-EXIT     
               PERFORM 7310-FETCH-CASH-DRWR-CNTRL   THRU  7310-EXIT     
               PERFORM 1200-PROCESS-CASH-DRWR-CNTRL THRU  1200-EXIT     
                 UNTIL  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
               PERFORM 7320-CLOSE-CASH-DRWR-CNTRL   THRU  7320-EXIT     
               MOVE WS-3 TO WS-PROCESS-TYPE                             
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                   
               MOVE WS-Y TO WS-REPOSITION-NEEDED
           END-IF.                       
      *                                                                         
           IF WS-PROCESS-TYPE EQUAL WS-3                                
      *** THE FOLLOWING CALL DELETES MULTIPLE ROWS:                             
               PERFORM 8500-DELETE-MISC-JRNL        THRU  8500-EXIT     
ACT323         PERFORM 8010-DEL-BCH-JRNL-CTL-AMT0   THRU  8010-EXIT     
               MOVE WS-4 TO WS-PROCESS-TYPE                             
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                   
               MOVE WS-Y TO WS-REPOSITION-NEEDED
           END-IF.                       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 1100-PROCESS-BATCH-JRNLS                                      *         
      *****************************************************************         
       1100-PROCESS-BATCH-JRNLS.                                        
      *** MUST DELETE BATCH JRNLS FIRST DUE TO DELETE-RESTRICT RI:              
           PERFORM 8200-DELETE-BATCH-JRNL THRU 8200-EXIT.               
           IF BC-CODE-BATCH-STATUS EQUAL WS-C                           
               PERFORM 8110-DELETE-BATCH-JRNL-CNTRL THRU 8110-EXIT      
           ELSE                                                         
               ADD BC-AMT-CASH-DEBIT         TO BC-AMT-NET-BATCH        
               SUBTRACT BC-AMT-CASH-CREDIT FROM BC-AMT-NET-BATCH        
               MOVE ZEROES                   TO BC-AMT-CASH-DEBIT       
                                                BC-AMT-CASH-CREDIT      
                                                BC-AMT-AR-DEBIT         
                                                BC-AMT-AR-CREDIT        
                                                BC-AMT-CK-ISS-DEBIT     
                                                BC-AMT-CK-ISS-CREDIT    
                                                BC-AMT-GL-DEBIT         
                                                BC-AMT-GL-CREDIT        
                                                BC-NO-ITEMS-POSTED      
T14762         MOVE WS-C TO                     BC-CODE-BATCH-STATUS    
               PERFORM 8100-UPDATE-BATCH-JRNL-CNTRL THRU 8100-EXIT
           END-IF.     
      *****************************************************************         
      * THE FOLLOWING STATEMENTS OCCUR JUST PRIOR TO THE LOOPING READ           
      * OF THE BC TABLE:                                                        
      *****************************************************************         
      *                                                                         
      *********                                                                 
      * THE FOLLOWING STATEMENT COMPARES THE STOP KEY TO THE          *         
      * LOCAL_OFFICE_NO AND BATCH_NO IN THE LAST BCH_JRNL_CNTL        *         
      * FETCHED, & ABENDS IF THE 2 FLDS ARE EQUAL, & IF STOP KEY      *         
      * REQUESTED THAT THE ABEND OCCUR IN THE BC LOOP:                *         
      *********                                                                 
           IF STOP-REQUESTED-IN-BC-LOOP                                 
           AND BC-CASH-COMPANY-NO   EQUAL WS-STOP-CASH-COMPANY-NO       
           AND BC-CASH-LOCAL-OFFICE EQUAL WS-STOP-CASH-LOCAL-OFFICE     
           AND BC-CASH-REPORT-NO    EQUAL WS-STOP-CASH-REPORT-NO        
           AND BC-DATE-CASH-REPORT  EQUAL WS-STOP-DATE-CASH-REPORT      
           AND BC-CASH-DRAWER-ID    EQUAL WS-STOP-CASH-DRAWER-ID        
               DISPLAY '******************************************'     
               DISPLAY '*****  JOB STOPPED DUE TO STOP PARM  *****'     
               DISPLAY '******************************************'     
               DISPLAY '*** STOP WAS REQUESTED IN BCH_JRNL_CNTL LOOP*'  
               DISPLAY '*** STOP CASH COMPANY NO   = '                  
                        WS-STOP-CASH-COMPANY-NO                         
               DISPLAY '*** STOP CASH LOCAL OFFICE = '                  
                        WS-STOP-CASH-LOCAL-OFFICE                       
               DISPLAY '*** STOP CASH REPORT NO    = '                  
                        WS-STOP-CASH-REPORT-NO                          
               DISPLAY '*** STOP DATE CASH REPORT  = '                  
                        WS-STOP-DATE-CASH-REPORT                        
               DISPLAY '*** STOP CASH DRAWER ID    = '                  
                        WS-STOP-CASH-DRAWER-ID                          
               DISPLAY '***  CONCATENATED KEY PRIOR TO LAST CHECKPOINT:'
               DISPLAY ' '                                              
               DISPLAY '  * LAST BC CASH COMPANY NO   = '               
                        WS-RESTART-CASH-COMPANY-NO                      
               DISPLAY '  * LAST BC CASH LOCAL OFFICE = '               
                        WS-RESTART-CASH-LOCAL-OFFICE                    
               DISPLAY '  * LAST BC CASH REPORT NO    = '               
                        WS-RESTART-CASH-REPORT-NO                       
               DISPLAY '  * LAST BC DATE CASH REPORT  = '               
                        WS-RESTART-DATE-CASH-REPORT                     
               DISPLAY '  * LAST BC CASH DRAWER ID    = '               
                        WS-RESTART-CASH-DRAWER-ID                       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *********                                                                 
      * THE FOLLOWING STATEMENTS ISSUE A CHECKPOINT IF THE CHKP-LUW    *        
      * LIMIT HAS BEEN REACHED OR THE CHKP-UPD LIMIT HAS BEEN REACHED  *        
      * OR EXCEEDED:                                                   *        
      *********                                                                 
           ADD 1 TO WS-CHKP-LUW-COUNTER.                                
           IF WS-CHKP-LUW-COUNTER EQUAL WS-CHKP-LUW-LIMIT OR            
              WS-CHKP-UPD-COUNTER  EQUAL WS-CHKP-UPD-LIMIT OR           
              WS-CHKP-UPD-COUNTER  GREATER THAN WS-CHKP-UPD-LIMIT       
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT
           END-IF.                  
           IF WS-PRINT-COUNTERS EQUAL WS-C                              
                   PERFORM 8601-PRINT-COUNTERS THRU 8601-EXIT
           END-IF.          
      ******************************************************************        
      * NOW CONTINUE READING BATCH_JRNL:                                        
      ******************************************************************        
      *                                                                         
           PERFORM  7110-FETCH-BATCH-JRNL-CNTRL   THRU  7110-EXIT.      
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1200-PROCESS-CASH-DRWR-CNTL                                   *         
      *****************************************************************         
       1200-PROCESS-CASH-DRWR-CNTRL.                                    
      *** REPLACED FETCH LOOP TO DELETE CASH DRWR JRNLS WITH DELETE             
      *** CALLS THAT WILL DELETE MULTIPLE ROWS THAT MATCH THE VARIOUS           
      *** DELETION CRITERIA.                                                    
T12023     IF (CS-CODE-CSH-DRWR-STAT = WS-BALANCED                      
T15045        OR CS-CODE-CSH-DRWR-STAT = WS-CLOSED)                     
C30472*       AND CS-CODE-FCS-EXTRACTED = WS-Y                                  
T22024        AND WS-BALANCED-DT NOT = SPACES                           
T22024        AND WS-BALANCED-DT < WS-DATE-PARM-DAYS-AGO                
T23814          PERFORM 7330-SELECT-MAX-CSH-DRWR-JRNL THRU 7330-EXIT    
T23814          MOVE CJ-ENTRY-NO TO CS-NO-ITEMS-ENTERED                 
T12023     END-IF.                                                      
           IF CS-AMT-CASH-DEBIT          EQUAL ZERO                     
              AND CS-AMT-CASH-CREDIT     EQUAL ZERO                     
              AND CS-AMT-AR-DEBIT        EQUAL ZERO                     
              AND CS-AMT-AR-CREDIT       EQUAL ZERO                     
              AND CS-AMT-CK-ISS-DEBIT    EQUAL ZERO                     
              AND CS-AMT-CK-ISS-CREDIT   EQUAL ZERO                     
              AND CS-AMT-GL-DEBIT        EQUAL ZERO                     
              AND CS-AMT-GL-CREDIT       EQUAL ZERO                     
              AND CS-AMT-CASH-BEGIN-BAL  EQUAL ZERO                     
T22237         CONTINUE                                                 
           ELSE                                                         
      *** UPDATE ONLY REQUIRED IF FLDS DON'T PRESENTLY CONTAIN ZEROES:          
      *** (AMT_CASH_BEGIN_BAL IS DERIVED FROM AMT_CASH_DEBIT &                  
      *** AMT_CASH_CREDIT AND WON'T CHG VALUE IF BOTH = 0):                     
               ADD CS-AMT-CASH-DEBIT         TO CS-AMT-CASH-BEGIN-BAL   
               SUBTRACT CS-AMT-CASH-CREDIT FROM CS-AMT-CASH-BEGIN-BAL   
               MOVE ZEROS TO                    CS-AMT-CASH-DEBIT       
                                                CS-AMT-CASH-CREDIT      
                                                CS-AMT-AR-DEBIT         
                                                CS-AMT-AR-CREDIT        
                                                CS-AMT-CK-ISS-DEBIT     
                                                CS-AMT-CK-ISS-CREDIT    
                                                CS-AMT-GL-DEBIT         
                                                CS-AMT-GL-CREDIT        
T13534     END-IF.                                                      
      *** IF NO JRNLS ARE FOUND, CJ-ENTRY-NO WILL CONTINUE TO HOLD ZERO:        
T23814*        PERFORM 7330-SELECT-MAX-CSH-DRWR-JRNL THRU 7330-EXIT             
T23814*        MOVE CJ-ENTRY-NO TO CS-NO-ITEMS-ENTERED                          
               PERFORM 8300-UPDATE-CASH-DRWR-CNTRL THRU 8300-EXIT.      
      *****************************************************************         
      * THE FOLLOWING STATEMENTS OCCUR JUST PRIOR TO THE LOOPING READ           
      * OF THE CS TABLE:                                                        
      *****************************************************************         
      *                                                                         
      *********                                                                 
      * THE FOLLOWING STATEMENT COMPARES THE STOP KEY TO THE          *         
      * LOCAL_OFFICE_NO AND CASH_DRAWER_ID IN THE LAST CSH_DRWR_CNTL  *         
      * AND ABENDS IF THE 2 FIELDS ARE EQUAL, PLUS IF STOP KEY IS     *         
      * REQUESTED THAT THE ABEND OCCUR IN THE CS LOOP:                *         
      *********                                                                 
           IF STOP-REQUESTED-IN-CS-LOOP                                 
           AND CS-CASH-COMPANY-NO   EQUAL WS-STOP-CASH-COMPANY-NO       
           AND CS-CASH-LOCAL-OFFICE EQUAL WS-STOP-CASH-LOCAL-OFFICE     
           AND CS-CASH-REPORT-NO    EQUAL WS-STOP-CASH-REPORT-NO        
           AND CS-DATE-CASH-REPORT  EQUAL WS-STOP-DATE-CASH-REPORT      
           AND CS-CASH-DRAWER-ID    EQUAL WS-STOP-CASH-DRAWER-ID        
               DISPLAY '******************************************'     
               DISPLAY '*****  JOB STOPPED DUE TO STOP PARM  *****'     
               DISPLAY '******************************************'     
               DISPLAY '*** STOP WAS REQUESTED IN CASH DRWR CNTL LOOP*' 
               DISPLAY '*** STOP CASH COMPANY NO   = '                  
                        WS-STOP-CASH-COMPANY-NO                         
               DISPLAY '*** STOP CASH LOCAL OFFICE = '                  
                        WS-STOP-CASH-LOCAL-OFFICE                       
               DISPLAY '*** STOP CASH REPORT NO    = '                  
                        WS-STOP-CASH-REPORT-NO                          
               DISPLAY '*** STOP DATE CASH REPORT  = '                  
                        WS-STOP-DATE-CASH-REPORT                        
               DISPLAY '*** STOP CASH DRAWER ID    = '                  
                        WS-STOP-CASH-DRAWER-ID                          
               DISPLAY '***  CONCATENATED KEY PRIOR TO LAST CHECKPOINT:'
               DISPLAY ' '                                              
               DISPLAY '  * LAST BC CASH COMPANY NO   = '               
                        WS-RESTART-CASH-COMPANY-NO                      
               DISPLAY '  * LAST BC CASH LOCAL OFFICE = '               
                        WS-RESTART-CASH-LOCAL-OFFICE                    
               DISPLAY '  * LAST BC CASH REPORT NO    = '               
                        WS-RESTART-CASH-REPORT-NO                       
               DISPLAY '  * LAST BC DATE CASH REPORT  = '               
                        WS-RESTART-DATE-CASH-REPORT                     
               DISPLAY '  * LAST BC CASH DRAWER ID    = '               
                        WS-RESTART-CASH-DRAWER-ID                       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *********                                                                 
      * THE FOLLOWING STATEMENTS ISSUE A CHECKPOINT IF THE CHKP-LUW    *        
      * LIMIT HAS BEEN REACHED OR THE CHKP-UPD LIMIT HAS BEEN REACHED  *        
      * OR EXCEEDED:                                                   *        
      *********                                                                 
           ADD 1 TO WS-CHKP-LUW-COUNTER.                                
           IF WS-CHKP-LUW-COUNTER EQUAL WS-CHKP-LUW-LIMIT OR            
              WS-CHKP-UPD-COUNTER  EQUAL WS-CHKP-UPD-LIMIT OR           
              WS-CHKP-UPD-COUNTER  GREATER THAN WS-CHKP-UPD-LIMIT       
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT
           END-IF.                  
           IF WS-PRINT-COUNTERS EQUAL WS-C                              
                   PERFORM 8601-PRINT-COUNTERS THRU 8601-EXIT
           END-IF.          
      ******************************************************************        
      * NOW CONTINUE READING CSH_DRWR_CNTL:                                     
      ******************************************************************        
      *                                                                         
           PERFORM 7310-FETCH-CASH-DRWR-CNTRL  THRU  7310-EXIT.         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *** DELETED 1300-PROCESS-CASH-DRWR-JRNL. (REPLACED BY MAKING              
      *** DELETE CALLS THAT DELETE MULTIPLE ROWS BASED ON PREDICATE             
      *** CRITERIA)                                                             
      *                                                                         
HPCCDM*EJECT                                                                    
       COPY CPD00035.                                                           
       COPY CPD00040.                                                           
       COPY CPD00037.                                                           
       COPY CPD00034.                                                           
       COPY CPD00036.                                                           
       COPY CPD00015.                                                           
T18128*COPY CPD00012.                                                           
T18128     EXEC SQL                                                             
T18128          INCLUDE CPD00012                                                
T18128     END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *****************************************************************         
      * 7100-OPEN-BATCH-JRNL-CNTRL                                    *         
      *****************************************************************         
       7100-OPEN-BATCH-JRNL-CNTRL.                                      
           EXEC SQL                                                     
                OPEN BATCH_JRNL_CNTL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7100- RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7110-FETCH-BATCH-JRNL-CNTRL                                   *         
      *****************************************************************         
       7110-FETCH-BATCH-JRNL-CNTRL.                                     
           EXEC SQL                                                     
                FETCH BATCH_JRNL_CNTL INTO                              
                   :BC-CASH-COMPANY-NO,                                 
                   :BC-CASH-LOCAL-OFFICE,                               
                   :BC-CASH-REPORT-NO,                                  
                   :BC-DATE-CASH-REPORT,                                
                   :BC-CASH-DRAWER-ID,                                  
                   :BC-CODE-BATCH-STATUS,                               
                   :BC-DATE-BATCH-ENTERED,                              
                   :BC-DATE-LAST-ACTIVITY,                              
                   :BC-NO-ITEMS-ENTERED,                                
                   :BC-AMT-CASH-DEBIT,                                  
                   :BC-AMT-CASH-CREDIT,                                 
                   :BC-AMT-AR-DEBIT,                                    
                   :BC-AMT-AR-CREDIT,                                   
                   :BC-AMT-CK-ISS-DEBIT,                                
                   :BC-AMT-CK-ISS-CREDIT,                               
                   :BC-AMT-GL-DEBIT,                                    
                   :BC-AMT-GL-CREDIT,                                   
                   :BC-AMT-NET-BATCH,                                   
                   :BC-NO-ITEMS-POSTED,                                 
                   :BC-AMT-BATCH-DEBITS,                                
                   :BC-AMT-BATCH-CREDITS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7110- RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7120-CLOSE-BATCH-JRNL-CNTRL                                   *         
      *****************************************************************         
       7120-CLOSE-BATCH-JRNL-CNTRL.                                     
           EXEC SQL                                                     
                CLOSE BATCH_JRNL_CNTL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7120- RETURN CODE= ' WS-ACTIVE-RETURN-CODE      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7300-OPEN-CASH-DRAWER-CNTRL                                   *         
      *****************************************************************         
       7300-OPEN-CASH-DRWR-CNTRL.                                       
           EXEC SQL                                                     
                OPEN CASH_DRWR_CNTL                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7300- RETURN CODE= ' WS-ACTIVE-RETURN-CODE      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7310-FETCH-CASH-DRWR-CNTRL                                    *         
      *****************************************************************         
       7310-FETCH-CASH-DRWR-CNTRL.                                      
           EXEC SQL                                                     
                FETCH CASH_DRWR_CNTL INTO                               
                   :CS-CASH-COMPANY-NO,                                 
                   :CS-CASH-LOCAL-OFFICE,                               
                   :CS-CASH-REPORT-NO,                                  
                   :CS-DATE-CASH-REPORT,                                
                   :CS-CASH-DRAWER-ID,                                  
                   :CS-AMT-CASH-DEBIT,                                  
                   :CS-AMT-CASH-CREDIT,                                 
                   :CS-AMT-AR-DEBIT,                                    
                   :CS-AMT-AR-CREDIT,                                   
                   :CS-AMT-CK-ISS-DEBIT,                                
                   :CS-AMT-CK-ISS-CREDIT,                               
                   :CS-AMT-GL-DEBIT,                                    
                   :CS-AMT-GL-CREDIT,                                   
                   :CS-AMT-CASH-BEGIN-BAL,                              
                   :CS-AMT-BASIC-WORK,                                  
                   :CS-CODE-CSH-DRWR-STAT,                              
                   :CS-DATE-LAST-ACTIVITY,                              
T22024             :WS-BALANCED-DT :WS-NULL-IND1,                       
T12023             :CS-CODE-FCS-EXTRACTED,                              
                   :CS-NO-ITEMS-ENTERED                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T22024         IF WS-NULL-IND1 < 0                                      
T22024            MOVE SPACES TO WS-BALANCED-DT                         
T22024         END-IF                                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND               
                 NEXT SENTENCE                                          
T22024        ELSE                                                      
               DISPLAY '7310' WS-ACTIVE-RETURN-CODE                     
               PERFORM 9900-ABEND THRU 9900-EXIT                        
              END-IF                                                    
T22024     END-IF.                                                      
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7320-CLOSE-CASH-DRWR-CNTRL                                    *         
      *****************************************************************         
       7320-CLOSE-CASH-DRWR-CNTRL.                                      
           EXEC SQL                                                     
                CLOSE CASH_DRWR_CNTL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7320' WS-ACTIVE-RETURN-CODE                     
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7330-SELECT-MAX-CSH-DRWR-JRNL                                 *         
      *****************************************************************         
       7330-SELECT-MAX-CSH-DRWR-JRNL.                                   
           EXEC SQL                                                     
                SELECT MAX(ENTRY_NO)                                    
                  INTO :CJ-ENTRY-NO :WS-NULL-IND                        
                  FROM CSS_CSH_DRWR_JRNL                                
                WHERE CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO         
                  AND CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE       
                  AND CASH_REPORT_NO      = :CS-CASH-REPORT-NO          
                  AND DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )        
                  AND CASH_DRAWER_ID      = :CS-CASH-DRAWER-ID          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MAX(ENTRY_NO)                                            
MFA-TR*           INTO :CJ-ENTRY-NO :WS-NULL-IND                                
MFA-TR*           FROM CSS_CSH_DRWR_JRNL                                        
MFA-TR*         WHERE CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO                 
MFA-TR*           AND CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE               
MFA-TR*           AND CASH_REPORT_NO      = :CS-CASH-REPORT-NO                  
MFA-TR*           AND DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT                
MFA-TR*           AND CASH_DRAWER_ID      = :CS-CASH-DRAWER-ID                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7330' WS-ACTIVE-RETURN-CODE                     
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T13534     IF WS-NULL-IND < 0                                           
T13534        MOVE ZERO TO CJ-ENTRY-NO                                  
T13534     END-IF.                                                      
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ********************                                                      
      * CASH-DRAWER-JRNL *                                                      
      ********************                                                      
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
T19086****************************************************************  08330004
T19086**                                                            **  08330004
T19086**  7800-SQL-CODE-CHECK.                                      **  08330004
T19086**  THIS PARA IS ADDED TO CHECK SQL RETURN CODE FROM THE COPY **          
T19086**  BOOK CPD00012  WHICH IS USED TO COMPUTE THE CALENDAR DATE **  08330004
T19086****************************************************************  08330004
T19086 7800-SQL-CODE-CHECK.                                             
T19086     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T19086     MOVE WS-ACTIVE-RETURN-CODE       TO WS-ACTIVE-RETURN-CODE-ED.
T19086     IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
T19086        NEXT SENTENCE                                             
T19086     ELSE                                                         
T19086        DISPLAY '** ERROR ON  6600-COMPUTE-CALENDAR **'           
T19086        DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE-ED      
T19086        DISPLAY '** INPUT DATE IS ' WS-CCD-START-DATE             
T19086        DISPLAY '** INPUT DAYS IS ' WS-CCD-DAYS-PLUS-MINUS        
T19086        DISPLAY '** PROCESSING TERMINATED            **'          
T19086        PERFORM 9900-ABEND               THRU 9900-EXIT           
T19086     END-IF.                                                      
T19086 7800-EXIT.                                                       
T19086      EXIT.                                                       
      *****************************************************************         
      * 7900-SELECT-RESTART-DATA                                      *         
      *****************************************************************         
       7900-SELECT-RESTART-DATA.                                        
           EXEC SQL                                                     
           SELECT RESTART_DATA                                          
             INTO :RF-RESTART-DATA                                      
           FROM  CSS_RESTART                                            
           WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                      
             AND PARTITION_NO   = :RF-PARTITION-NO                      
             AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7900-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7900-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
ACT323*****************************************************************         
ACT323* 8010-DEL-BCH-JRNL-CTL-AMT0                                    *         
ACT323*****************************************************************         
ACT323 8010-DEL-BCH-JRNL-CTL-AMT0.                                      
ACT323     EXEC SQL                                                     
ACT323          DELETE FROM CSS_BCH_JRNL_CNTL                           
ACT323          WHERE NO_ITEMS_ENTERED   = 0                            
ACT323            AND NO_ITEMS_POSTED    = 0                            
ACT323            AND AMT_CASH_DEBIT     = 0                            
ACT323            AND AMT_CASH_CREDIT    = 0                            
ACT323            AND AMT_AR_DEBIT       = 0                            
ACT323            AND AMT_AR_CREDIT      = 0                            
ACT323            AND AMT_CK_ISS_DEBIT   = 0                            
ACT323            AND AMT_CK_ISS_CREDIT  = 0                            
ACT323            AND AMT_GL_DEBIT       = 0                            
ACT323            AND AMT_GL_CREDIT      = 0                            
ACT323            AND AMT_NET_BATCH      = 0                            
ACT323            AND AMT_BATCH_DEBITS   = 0                            
ACT323            AND AMT_BATCH_CREDITS  = 0                            
ACT323     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT323     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT323     IF WS-ACTIVE-RETURN-CODE EQUAL TO ( SUCCESSFUL-CALL OR       
ACT323                                       NOT-FOUND )                
ACT323        NEXT SENTENCE                                             
ACT323     ELSE                                                         
ACT323        DISPLAY '8010- RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
ACT323        PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
ACT323 8010-EXIT.                                                       
ACT323     EXIT.                                                        
ACT323*                                                                         
      *****************************************************************         
      * 8100-UPDATE-BATCH-JRNL-CNTRL                                  *         
      *****************************************************************         
       8100-UPDATE-BATCH-JRNL-CNTRL.                                    
           EXEC SQL                                                     
                UPDATE CSS_BCH_JRNL_CNTL                                
                   SET AMT_CASH_DEBIT    = :BC-AMT-CASH-DEBIT,          
                       AMT_CASH_CREDIT   = :BC-AMT-CASH-CREDIT,         
                       AMT_AR_DEBIT      = :BC-AMT-AR-DEBIT,            
                       AMT_AR_CREDIT     = :BC-AMT-AR-CREDIT,           
                       AMT_CK_ISS_DEBIT  = :BC-AMT-CK-ISS-DEBIT,        
                       AMT_CK_ISS_CREDIT = :BC-AMT-CK-ISS-CREDIT,       
                       AMT_GL_DEBIT      = :BC-AMT-GL-DEBIT,            
                       AMT_GL_CREDIT     = :BC-AMT-GL-CREDIT,           
                       AMT_NET_BATCH     = :BC-AMT-NET-BATCH,           
                       NO_ITEMS_POSTED   = :BC-NO-ITEMS-POSTED,         
                       AMT_BATCH_DEBITS  = :BC-AMT-BATCH-DEBITS,        
                       AMT_BATCH_CREDITS = :BC-AMT-BATCH-CREDITS,       
T14762                 CODE_BATCH_STATUS = :BC-CODE-BATCH-STATUS        
                   WHERE CURRENT OF BATCH_JRNL_CNTL                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              ADD 1 TO WS-CHKP-UPD-COUNTER                              
              ADD 1 TO WS-RESTART-BC-UPDT-CNTR-TOT                      
              ADD 1 TO WS-RESTART-BC-UPDT-CNTR-LUW                      
           ELSE                                                         
               DISPLAY '8100- RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8110-DELETE-BATCH-JRNL-CNTRL                                  *         
      *****************************************************************         
       8110-DELETE-BATCH-JRNL-CNTRL.                                    
           EXEC SQL                                                     
                DELETE FROM CSS_BCH_JRNL_CNTL                           
                WHERE CURRENT OF BATCH_JRNL_CNTL                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              ADD 1 TO WS-CHKP-UPD-COUNTER                              
              ADD 1 TO WS-RESTART-BC-DLET-CNTR-TOT                      
              ADD 1 TO WS-RESTART-BC-DLET-CNTR-LUW                      
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '8110- RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
       8110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8200-DELETE-BATCH-JRNL                                        *         
      *****************************************************************         
       8200-DELETE-BATCH-JRNL.                                          
           EXEC SQL                                                     
                DELETE FROM CSS_BATCH_JRNL                              
                 WHERE CASH_COMPANY_NO   = :BC-CASH-COMPANY-NO          
                   AND CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE        
                   AND CASH_REPORT_NO    = :BC-CASH-REPORT-NO           
                   AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )         
                   AND CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_BATCH_JRNL                                      
MFA-TR*          WHERE CASH_COMPANY_NO   = :BC-CASH-COMPANY-NO                  
MFA-TR*            AND CASH_LOCAL_OFFICE = :BC-CASH-LOCAL-OFFICE                
MFA-TR*            AND CASH_REPORT_NO    = :BC-CASH-REPORT-NO                   
MFA-TR*            AND DATE_CASH_REPORT  = :BC-DATE-CASH-REPORT                 
MFA-TR*            AND CASH_DRAWER_ID    = :BC-CASH-DRAWER-ID                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              ADD 1 TO WS-CHKP-UPD-COUNTER                              
              ADD 1 TO WS-RESTART-BJ-DLET-CNTR-TOT                      
              ADD 1 TO WS-RESTART-BJ-DLET-CNTR-LUW                      
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '8200- RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8300-UPDATE-CASH-DRWR-CNTRL                                   *         
      *****************************************************************         
       8300-UPDATE-CASH-DRWR-CNTRL.                                     
           EXEC SQL                                                     
                UPDATE CSS_CSH_DRWR_CNTL                                
                   SET AMT_CASH_DEBIT     = :CS-AMT-CASH-DEBIT,         
                       AMT_CASH_CREDIT    = :CS-AMT-CASH-CREDIT,        
                       AMT_AR_DEBIT       = :CS-AMT-AR-DEBIT,           
                       AMT_AR_CREDIT      = :CS-AMT-AR-CREDIT,          
                       AMT_CK_ISS_DEBIT   = :CS-AMT-CK-ISS-DEBIT,       
                       AMT_CK_ISS_CREDIT  = :CS-AMT-CK-ISS-CREDIT,      
                       AMT_GL_DEBIT       = :CS-AMT-GL-DEBIT,           
                       AMT_GL_CREDIT      = :CS-AMT-GL-CREDIT,          
                       AMT_CASH_BEGIN_BAL = :CS-AMT-CASH-BEGIN-BAL,     
                       AMT_BASIC_WORK     = :CS-AMT-BASIC-WORK,         
                       NO_ITEMS_ENTERED   = :CS-NO-ITEMS-ENTERED        
                   WHERE CURRENT OF CASH_DRWR_CNTL                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              ADD 1 TO WS-CHKP-UPD-COUNTER                              
              ADD 1 TO WS-RESTART-CS-UPDT-CNTR-TOT                      
              ADD 1 TO WS-RESTART-CS-UPDT-CNTR-LUW                      
           ELSE                                                         
               DISPLAY '8300- RETURN CODE= ' WS-ACTIVE-RETURN-CODE      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8410-DELETE-CASH-DRWR-JRNL-2                                  *         
      *****************************************************************         
       8410-DELETE-CASH-DRWR-JRNL-2.                                    
           EXEC SQL                                                     
                DELETE FROM CSS_CSH_DRWR_JRNL                           
                 WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO          
                   AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE        
                   AND CASH_REPORT_NO    = :CS-CASH-REPORT-NO           
                   AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )         
                   AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_CSH_DRWR_JRNL                                   
MFA-TR*          WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                  
MFA-TR*            AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                
MFA-TR*            AND CASH_REPORT_NO    = :CS-CASH-REPORT-NO                   
MFA-TR*            AND DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                 
MFA-TR*            AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              ADD 1 TO WS-CHKP-UPD-COUNTER                              
              ADD 1 TO WS-RESTART-CJ-DLET-CNTR-TOT                      
              ADD 1 TO WS-RESTART-CJ-DLET-CNTR-LUW                      
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '8410- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8500-DELETE-MISC-JRNL                                         *         
      *****************************************************************         
       8500-DELETE-MISC-JRNL.                                           
           EXEC SQL                                                     
                DELETE FROM CSS_MISC_JRNL                               
                WHERE  DATE_TRAN < IIF(TRY_CONVERT(DATE, 
                                                 :WS-DATE-PARM-DAYS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-PARM-DAYS-AGO
              ) <> 0) OR (LEN(:WS-DATE-PARM-DAYS-AGO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-PARM-DAYS-AGO
              ), CONVERT(DATE, :WS-DATE-PARM-DAYS-AGO) )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_MISC_JRNL                                       
MFA-TR*         WHERE  DATE_TRAN < :WS-DATE-PARM-DAYS-AGO                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              ADD 1 TO WS-CHKP-UPD-COUNTER                              
              ADD 1 TO WS-RESTART-MJ-DLET-CNTR-TOT                      
              ADD 1 TO WS-RESTART-MJ-DLET-CNTR-LUW                      
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8500- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
       8500-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      *****************************************************************         
      * 8600-PRINT-COUNTERS                                           *         
      *****************************************************************         
       8600-PRINT-COUNTERS.                                             
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '*****   I/O COUNTERS FOR JCSCA124   *****'.         
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL BC UPDATES                   = '           
                              WS-RESTART-BC-UPDT-CNTR-TOT.              
           DISPLAY '** TOTAL BC DELETES                   = '           
                              WS-RESTART-BC-DLET-CNTR-TOT.              
           DISPLAY '** TOTAL TIMES BJ DELETE CALL INVOKED = '           
                              WS-RESTART-BJ-DLET-CNTR-TOT.              
           DISPLAY '** TOTAL CS UPDATES                   = '           
                              WS-RESTART-CS-UPDT-CNTR-TOT.              
           DISPLAY '** TOTAL TIMES CJ DELETE CALL INVOKED = '           
                              WS-RESTART-CJ-DLET-CNTR-TOT.              
           DISPLAY '** TOTAL TIMES MJ DELETE CALL INVOKED = '           
                              WS-RESTART-MJ-DLET-CNTR-TOT.              
           DISPLAY '** TOTAL RF UPDATES                   = '           
                              WS-RESTART-RF-UPDT-CNTR-TOT.              
           DISPLAY '** TOTAL RF INSERTS                   = '           
                              WS-RESTART-RF-ISRT-CNTR-TOT.              
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8601-PRINT-COUNTERS                                           *         
      *****************************************************************         
       8601-PRINT-COUNTERS.                                             
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '** I/O COUNTERS FOR 1 LUW IN JCSCA120  **'.         
           DISPLAY '** (1 LUW = 1 BATCH JRNL CNTL, 1 CASH  **'.         
           DISPLAY '**          DRWR CNTL, OR 1 MISC JRNL) **'.         
           DISPLAY ' '.                                                 
           IF WS-PROCESS-TYPE EQUAL 1                                   
               DISPLAY '** JUST PROCESSED A BATCH JRNL CNTL: '          
               DISPLAY '**   BC CASH COMPANY NO   = '                   
                        BC-CASH-COMPANY-NO                              
               DISPLAY '**   BC CASH LOCAL OFFICE = '                   
                        BC-CASH-LOCAL-OFFICE                            
               DISPLAY '**   BC CASH REPORT NO    = '                   
                        BC-CASH-REPORT-NO                               
               DISPLAY '**   BC DATE CASH REPORT  = '                   
                        BC-DATE-CASH-REPORT                             
               DISPLAY '**   BC CASH DRAWER ID    = '                   
                        BC-CASH-DRAWER-ID                               
           ELSE                                                         
      *** MUST BE IN CASH DRWR CNTL LOOP (PRINTERS DON'T COUNT INSIDE           
      *** MISC JRNL LOOP):                                                      
               DISPLAY '** JUST PROCESSED A CASH DRWR CNTL: '           
               DISPLAY '**   CS CASH COMPANY NO   = '                   
                        CS-CASH-COMPANY-NO                              
               DISPLAY '**   CS CASH LOCAL OFFICE = '                   
                        CS-CASH-LOCAL-OFFICE                            
               DISPLAY '**   CS CASH REPORT NO    = '                   
                        CS-CASH-REPORT-NO                               
               DISPLAY '**   CS DATE CASH REPORT  = '                   
                        CS-DATE-CASH-REPORT                             
               DISPLAY '**   CS CASH DRAWER ID    = '                   
                        CS-CASH-DRAWER-ID
           END-IF.                              
           DISPLAY ' '.                                                 
           DISPLAY '** BC UPDATES                     = '               
                                      WS-RESTART-BC-UPDT-CNTR-LUW.      
           DISPLAY '** BC DELETES                     = '               
                                      WS-RESTART-BC-DLET-CNTR-LUW.      
           DISPLAY '** # TIMES BJ DELETE CALL INVOKED = '               
                                      WS-RESTART-BJ-DLET-CNTR-LUW.      
           DISPLAY '** CS UPDATES                     = '               
                                      WS-RESTART-CS-UPDT-CNTR-LUW.      
           DISPLAY '** # TIMES CJ DELETE CALL INVOKED = '               
                                      WS-RESTART-CJ-DLET-CNTR-LUW.      
           DISPLAY '** # TIMES MJ DELETE CALL INVOKED = '               
                                      WS-RESTART-MJ-DLET-CNTR-LUW.      
           DISPLAY '** RF UPDATES                     = '               
                                      WS-RESTART-RF-UPDT-CNTR-LUW.      
           DISPLAY '** RF INSERTS                     = '               
                                      WS-RESTART-RF-ISRT-CNTR-LUW.      
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           MOVE ZERO TO WS-RESTART-BC-UPDT-CNTR-LUW                     
                        WS-RESTART-BC-DLET-CNTR-LUW                     
                        WS-RESTART-BJ-DLET-CNTR-LUW                     
                        WS-RESTART-CS-UPDT-CNTR-LUW                     
                        WS-RESTART-CJ-DLET-CNTR-LUW                     
                        WS-RESTART-MJ-DLET-CNTR-LUW                     
                        WS-RESTART-RF-UPDT-CNTR-LUW                     
                        WS-RESTART-RF-ISRT-CNTR-LUW.                    
       8601-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      *****************************************************************         
      * 8896-UPDATE-RESTART                                           *         
      *****************************************************************         
       8896-UPDATE-RESTART.                                             
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
               SET RESTART_DATA = :RF-RESTART-DATA                      
               WHERE                                                    
                   NAME_PROGRAM   =   :RF-NAME-PROGRAM AND              
                   PARTITION_NO   =   :RF-PARTITION-NO AND              
                   DUP_CNTRL_NO   =   :RF-DUP-CNTRL-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1 TO WS-CHKP-UPD-COUNTER                             
               ADD 1 TO WS-RESTART-RF-UPDT-CNTR-TOT                     
               ADD 1 TO WS-RESTART-RF-UPDT-CNTR-LUW                     
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8896-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
       8896-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      *****************************************************************         
      * 8897-INSERT-RESTART                                           *         
      *****************************************************************         
       8897-INSERT-RESTART.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1 TO WS-CHKP-UPD-COUNTER                             
               ADD 1 TO WS-RESTART-RF-ISRT-CNTR-TOT                     
               ADD 1 TO WS-RESTART-RF-ISRT-CNTR-LUW                     
           ELSE                                                         
               DISPLAY '8897-INSERT RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8897-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
           EXEC SQL                                                             
               INCLUDE CPD00029                                                 
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      *                                                                         
      *****************************************************************         
      * 8898-ISSUE-CHKP                                               *         
      *****************************************************************         
       8898-ISSUE-CHKP.                                                 
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
           AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS      
               GO TO 8898-EXIT
           END-IF.                                         
      ******************************************************                    
      *** THE FOLLOWING STATEMENTS MOVE IN RESTART DATA  ***                    
      ******************************************************                    
           MOVE WS-PROCESS-TYPE   TO WS-RESTART-PROCESS-TYPE.           
           ADD 1 TO WS-CHKP-SEQ-NO.                                     
           MOVE WS-CHKP-SEQ-NO    TO WS-RESTART-CHKP-SEQ-NO.            
      *                                                                         
           IF WS-REPOSITION-NEEDED = WS-N                               
      *** THIS CHECKPOINT IS THEREFORE THE ONE TAKEN AFTER COMPLETION           
      *** OF PROCESSING LOOP #3:                                                
               IF WS-PROCESS-TYPE > WS-3                                
                   MOVE WS-LIT-99    TO WS-RESTART-CASH-COMPANY-NO      
                   MOVE WS-LIT-999   TO WS-RESTART-CASH-LOCAL-OFFICE    
                                        WS-RESTART-CASH-REPORT-NO       
                   MOVE WS-ZERO-DATE TO WS-RESTART-DATE-CASH-REPORT     
                   MOVE 9999         TO WS-RESTART-CASH-DRAWER-ID       
               ELSE                                                     
      *** THIS CHECKPOINT IS THEREFORE THE INITIAL ONE OR THE ONE               
      *** TAKEN AFTER COMPLETION OF PROCESSING LOOP #1, #2, OR #3:              
                   MOVE SPACES       TO WS-RESTART-CASH-COMPANY-NO      
                                        WS-RESTART-CASH-LOCAL-OFFICE    
                                        WS-RESTART-CASH-REPORT-NO       
                                        WS-RESTART-DATE-CASH-REPORT     
                   MOVE ZEROES       TO WS-RESTART-CASH-DRAWER-ID
               END-IF       
           ELSE                                                         
               IF WS-PROCESS-TYPE = WS-1                                
                   MOVE BC-CASH-COMPANY-NO                              
                                     TO WS-RESTART-CASH-COMPANY-NO      
                   MOVE BC-CASH-LOCAL-OFFICE                            
                                     TO WS-RESTART-CASH-LOCAL-OFFICE    
                   MOVE BC-CASH-REPORT-NO                               
                                     TO WS-RESTART-CASH-REPORT-NO       
                   MOVE BC-DATE-CASH-REPORT                             
                                     TO WS-RESTART-DATE-CASH-REPORT     
                   MOVE BC-CASH-DRAWER-ID                               
                                     TO WS-RESTART-CASH-DRAWER-ID       
               ELSE                                                     
      *** THIS CHECKPOINT IS THEREFORE ONE TAKEN DURING LOOP #2 (COMMITS        
      *** ARE NOT ABLE TO BE TAKEN INSIDE LOOP #3, WHICH CONSISTS OF 1          
      *** DELETE CALL:                                                          
                   MOVE CS-CASH-COMPANY-NO                              
                                     TO WS-RESTART-CASH-COMPANY-NO      
                   MOVE CS-CASH-LOCAL-OFFICE                            
                                     TO WS-RESTART-CASH-LOCAL-OFFICE    
                   MOVE CS-CASH-REPORT-NO                               
                                     TO WS-RESTART-CASH-REPORT-NO       
                   MOVE CS-DATE-CASH-REPORT                             
                                     TO WS-RESTART-DATE-CASH-REPORT     
                   MOVE CS-CASH-DRAWER-ID                               
                                     TO WS-RESTART-CASH-DRAWER-ID
               END-IF
           END-IF.      
      *                                                                         
      ******************************************************                    
      *** THE FOLLOWING STATEMENT PERFORMS A PARAGRAPH THAT   ***               
      *** REPLACES THE RESTART DATA RECORD IN THE RESTART     ***               
      *** TABLE:                                              ***               
      ******************************************************                    
           PERFORM 8899-WRITE-RSDDR THRU 8899-EXIT.                     
      *** THE FOLLOWING STATEMENTS ISSUE A CHECKPOINT CALL:   ***               
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'           
           IF WS-PROCESS-TYPE EQUAL WS-1                                
               IF WS-REPOSITION-NEEDED EQUAL WS-N                       
                   DISPLAY '** THIS IS THE INITIAL CHECKPOINT '         
               ELSE                                                     
                   DISPLAY '** LAST BATCH JRNL CNTL PROCESSED: '        
                           'COMP/LO/RPT NO/DATE/ID = '                  
                                  BC-CASH-COMPANY-NO   '/'              
                                  BC-CASH-LOCAL-OFFICE '/'              
                                  BC-CASH-REPORT-NO    '/'              
                                  BC-DATE-CASH-REPORT  '/'              
                                  BC-CASH-DRAWER-ID
               END-IF                     
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-2                                
               IF WS-REPOSITION-NEEDED EQUAL WS-N                       
                   DISPLAY '** THIS IS THE FINAL CHECKPOINT AFTER'      
                           ' PROCESSING ALL BATCH JRNL CNTLS'           
                   DISPLAY '** LAST BATCH JRNL CNTL PROCESSED: '        
                           'COMP/LO/RPT NO/DATE/ID = '                  
                                  BC-CASH-COMPANY-NO   '/'              
                                  BC-CASH-LOCAL-OFFICE '/'              
                                  BC-CASH-REPORT-NO    '/'              
                                  BC-DATE-CASH-REPORT  '/'              
                                  BC-CASH-DRAWER-ID                     
               ELSE                                                     
                   DISPLAY '** LAST CASH DRWR CNTL PROCESSED: '         
                           'COMP/LO/RPT NO/DATE/ID = '                  
                                  CS-CASH-COMPANY-NO   '/'              
                                  CS-CASH-LOCAL-OFFICE '/'              
                                  CS-CASH-REPORT-NO    '/'              
                                  CS-DATE-CASH-REPORT  '/'              
                                  CS-CASH-DRAWER-ID
               END-IF                     
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-3                                
      *** THIS MUST BE THE END OF LOOP #2; NO COMMITS ARE TAKEN INSIDE          
      *** LOOP #3:                                                              
               DISPLAY '** THIS IS THE FINAL CHECKPOINT AFTER'          
                       ' PROCESSING CASH DRWR CNTLS'                    
               DISPLAY '** LAST CASH DRWR CNTL PROCESSED: '             
                       'COMP/LO/RPT NO/DATE/ID = '                      
                              CS-CASH-COMPANY-NO   '/'                  
                              CS-CASH-LOCAL-OFFICE '/'                  
                              CS-CASH-REPORT-NO    '/'                  
                              CS-DATE-CASH-REPORT  '/'                  
                              CS-CASH-DRAWER-ID                         
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-4                                
               DISPLAY '** THIS IS THE FINAL CHECKPOINT AFTER'          
                       ' PROCESSING ALL MISC JRNLS WITH 1 DLET CALL'
           END-IF
           END-IF
           END-IF
           END-IF.   
      *                                                                         
      *** THE FOLLOWING STATEMENT RESETS THE CHKP POINTERS: ***                 
           MOVE ZERO TO WS-CHKP-LUW-COUNTER                             
                        WS-CHKP-UPD-COUNTER.                            
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8899-WRITE-RSDDR                                              *         
      *****************************************************************         
       8899-WRITE-RSDDR.                                                
           MOVE WS-1         TO RF-PARTITION-NO.                        
           MOVE WS-PGRMNAME  TO RF-NAME-PROGRAM.                        
           MOVE WS-1         TO RF-DUP-CNTRL-NO.                        
           MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
           MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
           PERFORM 8896-UPDATE-RESTART THRU 8896-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8897-INSERT-RESTART THRU 8897-EXIT
           END-IF.              
       8899-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
      ****                                                                      
            EXEC SQL                                                            
              INCLUDE CPD09900                                                  
            END-EXEC.                                                           
