       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA123.                                         
       DATE-WRITTEN.  DEC 1981.                                         
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS    REASON                               **         
      **    ====    ========    ======                               **         
      **  03/25/96  ELJ         REPORT IS WRAPPING THE NEGATIVE SIGN **         
      **                        FOR ENDING-BAL ONTO THE NEXT LINE.   **         
      **                        I DECREASED THE SIZE OF THE RCVBL-BAL**         
      **                        COLUMN TO MATCH IT'S ACTUAL SIZE.    **         
      **  03/26/96  ELJ         INCREASE THE CASH DRAWER TO A 9(4)   **         
      **                        FIELD AND DELETE ALL REFERENCES TO   **         
      **                        P-TYPE-OF-PAYMENT-DTJ. TPR 3600      **         
      **  07/12/96  RAO JADA    ADDED LOGIC TO LOAD CORRECT GL #     **         
      **                        FOR UTILITY STATE TAX. ( PCR# 290)   **         
      **  09/16/96  JHR         TPR 5399 MOD - COMMENT OUT PERFORM   **         
      **                        3440-.                               **         
TP5674**  10/08/96  JHR         TPR 5674 CHANGED 2100-DETAIL SO NO   **         
TP5674**                        SOC-04.                              **         
TP5712**  10/08/96  JHR         TPR 5712 CHANGED TRANSACTION TYPE TO **         
TP5712**                        XFR WHEN SOURCE = 184.2201.          **         
TP8074**  12/10/96  MAD         TPR 8074 - ADDED NEW ABEND MESSAGING **         
      **                         FOR ABENDS DUE TO A GL NUMBER NOT   **         
      **                         BEING FOUND FOR PROCESSING.         **         
TP8267**  12/21/96  MAD         TPR 8267 - MODIFIED READABILITY OF   **         
      **                         ABEND MESSAGING.                    **         
TP8358**                        TPR 8358 - MODIFIED REPORT HEADERS   **         
      **                         TO ALIGN THEM WITH SCE&G STANDARDS. **         
TP9306**  02/17/97  RAO         TPR 9306 - MODIFIED CREATE CA09 FILE **         
      **                        CORRECTLY.                           **         
TP9434**  02/25/97  RAO         TPR 9434 - MODIFIED TO USE TRAN-DATE **         
      **                        INSTEAD OF DATE LAST ACTION.         **         
T10138**   3/04/97  CSS         DELETE SUPPRESSION OF GL NO FOR      **         
      **                        REPEATED GL NO IN MULTIPLE TRANSACTION*         
TP9779**   4/08/97  CSS         CHANGE MNEUMONIC FROM TAX-SCGAS TO   **         
      **                        TAX-SC                               **         
T10430**   4/16/97  CSS         CHANGE EDIT THAT USES AR12 TO POINT  **         
      **                        INSTEAD TO AR AGE CODE OF W TO DENOTE**         
      **                        WRITEOFF TRANSACTIONS                **         
      **   4/23/97  CSS         CORRECT DISPLAY OF 103 FOR MULTIPLE  **         
      **                        DETAILS                              **         
T11550**   6/05/97  CSS         CORRECT DISPLAY OF 102 JRNLS FOR     **         
      **                        MULTIPLE DETAILS                     **         
T11612**   6/11/97  CSS         COMMENT OUT EARLY CONTRACT PAYOFF WQ **         
      **                        LOGIC                                **         
T11663**   6/12/97  CSS         CORRECT SPACING FOR A 7 DIGIT ITEM ID**         
T11581**   6/17/97  CSS         CORRECT MISSING ACCT DESC WHEN A 105 **         
      **                         JOURNAL IS WRITTEN TO THE FIOCA09   **         
      **                        FILE                                 **         
ITEMID**   6/28/97  CSS         ITEM ID NO WAS INCREASED TO S9(09)   **         
T12419**   6/30/97  CSS         ELIMINATE WRITING WORK QUEUES TO     **         
      **                        FCSCA10 FILE WHEN NEITHER THE DR NOR **         
      **                        CR GL NUMBER  IS A RECEIVABLE        **         
T12594**   8/6/97   CSS         PREVENT ABEND WHEN NO DIRECT TRANS   **         
      **                        ARE PRESENT                          **         
      **                                                             **         
T13946**  12/02/97  TQT         ADD DISPLAY STATEMENTS TO ABEND      **         
      **  12/09/97  MJL         CHANGE CA09 OCCURS TO 13,000 FROM 12 **         
      **                                                             **         
      **  12/16/97  MKN         INCREASED THE SIZE OF OCCURS TO 15K  **         
      **                        BECAUSE NEW GLS HAVE BEEN ADDED      **         
  AJC **  01/14/98  AJC         TOOK OUT BAD PROCESSING OF BATCH CASH**         
      **                        PAYMENTS AS A WORK QUEUE ITEM        **         
  KLP **  04/07/98  KLP         REMOVED DISPLAY STATEMENTS IN PARA   **         
      **                        4530-FCSCA08-LOOK-UP                 **         
WQRMVL**  04/14/98  KLP         REMOVED WORK QUEUES FOR CASH BALANCING*         
      **                        DEEMED IRRELEVANT & INCORRECTLY MANGD**         
      **                        OR RELATED TO TOM & CASH             **         
PCR647**  05/19/98  KLP         ONLINE TRANS DO NOT PROVIDE REV MONTH**         
      **                        FOR THE TRANSACTION - WHEN NO REV MO **         
      **                        IS FOUND IN CA07 FILE - THE JOB PARM **         
      **                        FOR REVENUE MONTH IS INSERTED INTO   **         
      **                        THE CA09 FILE                        **         
T16859**  06/17/98  KLP         REMOVED OUT OF BALANCE WORK QUEUE    **         
      **                        SINCE ITS INVALID TO COMPARE 1 ACCT  **         
      **                        LEVEL AMNT VS A CONTROL LEVEL AMNT   **         
      **                                                             **         
T16880**  06/19/98  SJM         CHANGED OCCURRENCES IN THE CA09 TABLE**         
      **                        FROM 15,000 TO 30,000 TO ACCOMODATE  **         
      **                        THE ADDITION OF NEW GL ACCOUNT NUMBERS*         
T17734**  09/30/98  KLP         ADDED EXCEPTION TYPE DESCRIPTION TO  **         
      **                        WQS FOR CHANGE IN BILLED RECVBL AGE  **         
T18399**  12/02/98  CBSI        COMMENTED OUT 3300-DTJ-EXC-ERROR-CHECK*         
T18399**            MADRAS      WHICH HANDLES CODE-TRAN-ERRORS AND   **         
T18399**                        POPULATES THE OUTPUT FCSCA10-FILE    **         
CBSI  **  01/27/99  CBSI        WHEN REVENUE MONTH EXTRACTED FROM I/P**         
CBSI  **            MADRAS      FILE IS NUMERIC, GREATER THAN ZERO   **         
CBSI  **                        AND NOT SAME AS WS-REVENUE-MONTH-    **         
CBSI  **                        COMMON CREATES A NEW O/P FILE FCSRP132*         
      **                                                             **         
T21918**  23 MAR 2000 RDF       CHANGED OCCURRENCES IN BOTH OF THE   **         
      **                        CA09 TABLES AND THE WORKING STORAGE  **         
      **                        MAX COUNTER FROM 20,000 TO 25,000.   **         
C24555**  30-JUL 2001 LEF       CORRECT INDEX ON COMPANY TABLE       **         
C24753**  20-AUG 2001 LEF       CHANGED OCCURRENCES IN BOTH OF THE   **         
      **                        CA09 TABLES AND THE WORKING STORAGE  **         
      **                        MAX COUNTER FROM 25,000 TO 40,000.   **         
C24753**  12-SEP 2001 LEF       PER CHANELLE - COMMENT OUT COMPANY   **         
      **                        NUMBER IN 7500-                      **         
T24436**  10/12/01    COVANSYS  COPYBOOK CPD00061 CHANGED TO SUB     **         
T24436**              CHENNAI   PROGRAM  SCSCB061.                   **         
C25923**  06/17/02    BASKAR    INCREASE ARRAY LIMIT.                **         
T30899**  05/27/04    COVANSYS  ELIMINATED 060 EXCEPTION TYPE FOR    **         
T30899**              CHENNAI   SEB REGION                           **         
A01041** 07/09/09     SK42147   CHECK FOR NEW CLEARING GL FOR MST/SUB**         
A01041**                        TRANSFER CLEARING GL.(184.2500)      **         
PRDFIX** 08/19/09   PRIYA     WS-MAX-FIOCA09-ENTRIES INCREASED TO 51000*        
A02036** 02/09/10   DB41297   REMOVE REDUNDANT WORK QUEUE              .        
A02034** 02/13/10   SIVA      WS-MAX-FIOCA09-ENTRIES INCREASED TO 52000*        
A02036** 02/15/10   DB41297   WS-MAX-FIOCA09-ENTRIES INCREASED TO 99999.        
ACT031** 03/31/12   NS75440   REMOVED REFERENCE TO GL-LOC-OFCE-UPD-AUTH*        
ACT031***A03967               AND GL-GO-UPD-AUTH.                     **        
P00641***08/01/12   BD09555      TABLE CHANGES FOR CREDIT PROJECT     **        
ACT032***02/01/14   BD09555   REMOVE TBGLNAME       A04880            **        
A05460***05/06/16   HA7A338   COMMENT CODE THAT WRITES RECORD INTO    **        
A05460***                     FCSCA04 VSAM FILE.                      **        
A05460***05/10/16   HA7A338   COMMENT CODE THAT WRITES RECORD INTO    **        
A05460***                     FCSCA08 VSAM FILE.                      **        
A05460***06/29/16   HA7A338   COMMENT UNUSED CODES AND REPLACE FCSCA09**        
A05460***                     VSAM FILE WITH FLAT FILE.               **        
      *****************************************************************         
       REMARKS.                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     PROCESS INDIRECT JOURNALS               
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
       REMARKS.                                                         
      * USES FILES                                                              
      *     FCSCA07 - A ESDS FILE CONSISTING OF THAT DAYS INDIRECT 'TO'         
      *               ACTIVITY. 'INDIRECT' JOURNALS REQUIRING GA POSTING        
      *     FCSCA04 - A KSDS FILE CONSISTING OF THAT DAYS DIRECT 'TO'           
      *               ACTIVITY. THESE 'DIRECT' TRANSACTIONS WERE POSTED         
      *               VIA ONLINE TO THE GA DATA BASE.                           
      *     FCSCA08 - A ESDS FILE, DAILY JRNL --- WASH DISK WORK                
      *     FCSCA09 - A ESDS FILE, DAILY JRNL --- GEN-LED DISK WORK             
      *     FCSCA10 - A ESDS FILE, ERRORS WITH APPROPRIATE DESCRIPTIONS         
      * CHECKS THE JOURNAL RECORDS.                                             
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
           0000 - 0000     MAIN CONTROL PARAGRAPH                       
           ------------------------------------------------------------ 
           ---------- INITIAL PROCESSING  1 TIME ONLY ----------------- 
           0100 - 0100     INITIALIZATION, OPENS FILES                  
           0200 - 0200     LOADS CORRECT TABLE NUMBERS                  
           0500 - 0520     LOADS GENERAL LEDGER TABLES, GL CONTROL TABLE
                               AND THE FCSCA09 FILE FROM THE GA DATABASE
           ------------------------------------------------------------ 
           -----------  MAIN PROCESSING ROUTINES  --------------------- 
           1000 - 1000     MAJOR PROCESSING LOOP                        
                               CONTROLS PROCESSING ACCORDING TO TYPE OF 
                               CA07 RECORD READ                         
           ------------------------------------------------------------ 
           ----------- PROCESSES G/L DISK WORK FILE (FCSCA09) --------- 
           2100 - 2100     CONTROLS TRANSFER FROM THE G/L TABLES        
                            TO G/L DISK WORK (FCSCA09 FILE)             
               2110 - 2122      TRANSFERS INDIVIDUAL G/L TABLES         
                                   TO THE G/L DISK WORK FILE            
           ------------------------------------------------------------ 
           2200 - 2200     READS G/L DISK WORK, DETERMINES IF GA NEEDS  
                               TO BE UPDATED (5000)                     
           2500 - 2510     CONTROLS SEQUENTIAL PROCESSING OF G/L DISK   
                            WORK                                        
           ------------------------------------------------------------ 
           ----------- PROCESSES THE CA07 JOURNALS -------------------- 
           3000 - 3000     CONTROLS PROCESSING OF CA07 JOURNALS         
               3010 - 3014     CHECKS SIGNS ON TAXES AND AMOUNTS POSTED 
               3020 - 3020     HANDLES ERRORS FOUND IN 3010 - 3014      
           ------------------------------------------------------------ 
           3100 - 3100     HANDLES 00001 BATCH RECORDS. IF AMOUNG 1ST 50
                            BATCHES, CREATES RECORD IN BATCH WORK TABLE 
               3120 - 3120     UPDATES FCSCA08 (WASH DISK WORK)         
           ------------------------------------------------------------ 
           3200 - 3200     HANDLES 00002 BATCH RECORDS.  WRITES ERROR   
                            RECORD TO FCSCA10 FILE.                     
           ------------------------------------------------------------ 
           3300 - 3300     CHECKS TRANS-ERROR CODES                     
               3380 - 3380     FINDS AND LOADS CORRECT ERROR MESSAGE    
               3390 - 3390     CONTOLS ERROR MESSAGE DESTINATION CODING 
                   3391 - 3391     LOADS 'GO' ERROR MESSAGES TO FCSCA10 
                   3392 - 3392     LOADS LOC OFF ERROR MESS TO FCSCA10  
           ------------------------------------------------------------ 
           3400 - 3400     CHECKS DEBIT = CREDIT AND 142S BEING PRESENT 
               3410 - 3430     BREAKS OUT THE G/L NUMBER AND THE TAXES  
               3431 - 3431     CREATES ERROR RECORD - BATCH WITH 135.20 
               3440 - 3440     CHECKS FOR CLEARING ACCTS (184.XX)       
               3450 - 3482     UPDATING APPROPRIATE G/L TABLE           
               3500 - 3500     G/L NUMBER NOT IN TABLE, GOES DIRECTLY   
                                TO G/L DISK WORK (FCSCA09 FILE)         
               3600 - 3600     G/L NUMBER NOT IN FCSCA09 FILE, 184.24   
                                USED INSTEAD                            
               3700 - 3710     INVALID G/L NUMBER ERROR WRITTEN FCA10   
           ------------------------------------------------------------ 
           ----------- PROCESSES THE '1' JOURNALS --------------------- 
           4000 - 4000   CONTROLS PROCESSING OF THE WASH BUCKET ROUTINE 
           4500 - 4500   WASH BUCKET ADD ROUTINE                        
               4510 - 4511     FINDS AND UPDATES BATCH TABLES           
               4520 - 4521     FINDS AND UPDATES CASH DRAWER TABLES     
               4530 - 4530     UPDATES FCSCA08 IF TABLES NOT FOUND      
           ------------------------------------------------------------ 
           ----------- WASH BUCKET CLEARING --------------------------- 
           6000 - 6000     CONTROLS CLEARING ROUTINE                    
               6100 - 6100     COMPARES BATCH TABLES TO FCSCA08 RECORD  
               6200 - 6200     COMPARES CASH TABLES TO FCSCA08 RECORD   
               6300 - 6300     READS FCSCA08 SEQUENTIALLY, COMPARING    
                                TOM TOTALS TO JRNL TOTALS               
               6400 - 6400     CREATES ERROR MESSAGE FOR WASH ERRORS    
           ------------------------------------------------------------ 
           ----------- INQUIRY CALLS TO DATABASES  -------------------- 
           7000 - 7510     INQUIRY CALLS TO DATABASE                    
           ------------------------------------------------------------ 
           ----------- READ INPUT PARAMETERS -------------------------- 
           7700 - 7710     READ INPUT PARAMETERS                        
           ------------------------------------------------------------ 
           ----------- REPORT PRINTING -------------------------------- 
           8000 - 8070     PRINTS DAILY TRANSACTION  JOURNAL            
           ------------------------------------------------------------ 
           8800 - 8800     WRITE FCSCA10 RECORDS                        
           -----------------------------------------------------------  
           8900 - 8910     WRITE PROGRAM INFORMATION LINES              
           -----------------------------------------------------------  
           9901 - 9901     CONTROLLED ABEND                             
           -----------------------------------------------------------  
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.   IBM-370.                                      
       OBJECT-COMPUTER.   IBM-370.                                      
      *                                                                         
       SPECIAL-NAMES.     C01 IS TOP-OF-PAGE.                           
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
HEMA1 *    COPY CSSCA04.                                                        
           COPY CSSCA07.                                                        
HEMA2 *    COPY CSSCA08.                                                        
           COPY CSSCA09.                                                        
           COPY CSSCA10.                                                        
           COPY CSSPT33.                                                        
CBSI       COPY CSSRP132.                                                       
HPCCDM*    EJECT                                                                
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
HEMA1 *COPY CFDCA04.                                                            
HEMA1 *COPY FIOCA04.                                                            
      *                                                                         
       COPY CFDCA07.                                                            
       COPY FIOCA07.                                                            
      *                                                                         
HEMA2 *COPY CFDCA08.                                                            
HEMA2 *COPY FIOCA08.                                                            
      *                                                                         
       COPY CFDCA09.                                                            
       COPY FIOCA09.                                                            
      *                                                                         
       COPY CFDCA10.                                                            
       COPY FIOCA10.                                                            
      *                                                                         
CBSI   COPY CFDRP132.                                                           
CBSI   COPY FIORP132.                                                           
CBSI  *                                                                         
       COPY CFDPT33.                                                            
      *                                                                         
HPCCDM*    EJECT                                                                
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA123'.
MSQ017     COPY MFASQLM.
090889     EXEC SQL                                                             
090889          INCLUDE SQLCA                                                   
090889     END-EXEC.                                                            
      *                                                                         
090889     EXEC SQL                                                             
090889          INCLUDE TBGLACCT                                                
090889     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBGLATNO                                                
           END-EXEC.                                                            
      *                                                                         
090889     EXEC SQL                                                             
090889          INCLUDE TBLOCOFC                                                
090889     END-EXEC.                                                            
      *                                                                         
090889     EXEC SQL                                                             
                INCLUDE TBCOMPNY                                                
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
090889          INCLUDE TBJBPARM                                                
090889     END-EXEC.                                                            
      *                                                                         
T30899     EXEC SQL                                                             
T30899         INCLUDE TBDELQ                                                   
T30899     END-EXEC.                                                            
090889     EXEC SQL                                                             
                INCLUDE CWS00038                                                
090889     END-EXEC.                                                            
      *                                                                         
090889     EXEC SQL                                                             
                INCLUDE CWS00039                                                
090889     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00061                                                
           END-EXEC.                                                            
      *                                                                         
T24436 COPY CWS00010.                                                   02460000
      *                                                                         
      ********************                                                      
      *  GL-ACCOUNT      *                                                      
      ********************                                                      
090889     EXEC SQL                                                     
                DECLARE GL_ACCOUNT CURSOR FOR                           
090889          SELECT                                                  
                   A.COMPANY_NO,                                        
                   A.GL_ACCT_NO,                                        
                   A.LOCAL_OFFICE,                                      
                   A.DATE_LAST_TRANS,                                   
                   A.CODE_ACCT_STATUS,                                  
                   B.GL_ACCT_NAME,                                      
P00641             B.GL_ACCT_NAME_DESC,                                 
                   A.GL_DTL_CNTL_IND,                                   
                   A.ACCT_BALANCE,                                      
                   A.BEGIN_ACCT_BALANCE                                 
                FROM CSS_GL_ACCOUNT A WITH(READUNCOMMITTED),                    
                     CSS_GL_ACCT_NO B WITH(READUNCOMMITTED)                     
                WHERE  A.GL_ACCT_NO > 0                                 
                AND    A.GL_DTL_CNTL_IND = 'D'                          
                AND    A.COMPANY_NO = B.COMPANY_NO                      
                AND    A.GL_ACCT_NO = B.GL_ACCT_NO                      
                ORDER BY A.COMPANY_NO,                                  
                         A.LOCAL_OFFICE,                                
                         A.GL_ACCT_NO                                   
A02036          FOR READ ONLY                                   
090889     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE GL_ACCOUNT CURSOR FOR                                   
MFA-TR*         SELECT                                                          
MFA-TR*            A.COMPANY_NO,                                                
MFA-TR*            A.GL_ACCT_NO,                                                
MFA-TR*            A.LOCAL_OFFICE,                                              
MFA-TR*            A.DATE_LAST_TRANS,                                           
MFA-TR*            A.CODE_ACCT_STATUS,                                          
MFA-TR*            B.GL_ACCT_NAME,                                              
MFA-TR*            B.GL_ACCT_NAME_DESC,                                         
MFA-TR*            A.GL_DTL_CNTL_IND,                                           
MFA-TR*            A.ACCT_BALANCE,                                              
MFA-TR*            A.BEGIN_ACCT_BALANCE                                         
MFA-TR*         FROM CSS_GL_ACCOUNT A,                                          
MFA-TR*              CSS_GL_ACCT_NO B                                           
MFA-TR*         WHERE  A.GL_ACCT_NO > 0                                         
MFA-TR*         AND    A.GL_DTL_CNTL_IND = 'D'                                  
MFA-TR*         AND    A.COMPANY_NO = B.COMPANY_NO                              
MFA-TR*         AND    A.GL_ACCT_NO = B.GL_ACCT_NO                              
MFA-TR*         ORDER BY A.COMPANY_NO,                                          
MFA-TR*                  A.LOCAL_OFFICE,                                        
MFA-TR*                  A.GL_ACCT_NO                                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HEMA1 *01  WS-FCA04-STATUS           PIC X(02).                                 
HEMA1 *    88  FCA04-SUCCESSFUL      VALUE '00'.                                
       01  WS-FCA07-STATUS           PIC X(02).                         
           88  FCA07-SUCCESSFUL      VALUE '00'.                        
HEMA2 *01  WS-FCA08-STATUS           PIC X(02).                                 
HEMA2 *    88  FCA08-SUCCESSFUL      VALUE '00'.                                
HEMA2 *    88  FCA08-NOT-FOUND       VALUE '23'.                                
       01  WS-FCA09-STATUS           PIC X(02).                         
           88  FCA09-SUCCESSFUL      VALUE '00'.                        
112704 01  WS-FCA10-STATUS           PIC X(02).                         
           88  FCA10-SUCCESSFUL      VALUE '00'.                        
CBSI   01  WS-FRP132-STATUS          PIC X(02).                         
CBSI       88  FRP132-SUCCESSFUL     VALUE '00'.                        
      *                                                                         
HEMA3 *01  WS-FCA04-EMPTY-FLG        PIC X(01) VALUE 'N'.                       
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-START                PIC X(40)                        
               VALUE 'WORKING STORAGE FOR PCSCA123 STARTS HERE'.        
           05  WS-PCB-SAVE-AREA        PIC X(75)     VALUE SPACES.      
T24436     05  PROGRAM-NAME              PIC X(08)   VALUE 'PCSCA123'.  
           05  WS-PGRMNAME               PIC X(08)   VALUE 'PCSCA123'.  
T24436     05  SCSCB061                  PIC X(08)   VALUE 'SCSCB061'.  
      *                                                                 01270000
T24436 01  RS-RPC-RETURN-CODE.                                          
T24436     05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
T24436     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                 01290000
HEMA3 *01  WS-VSAM-FILE-STATUS.                                                 
HEMA3 *    05  WS-SUCCESSFUL         PIC X(02)  VALUE '00'.                     
HEMA3 *    05  WS-END-OF-FILE        PIC X(02)  VALUE '10'.                     
      *                                                                         
HEMA2 *01  WS-ZERO-RECORD-CA08.                                                 
HEMA2 *    10  WS-ACTIVITY-TYPE-FCSCA08        PIC X(01)   VALUE SPACES.        
HEMA2 *    10  WS-ACTIVITY-SOURCE-FCSCA08.                                      
HEMA2 *        15  WS-CASH-COMPANY-NO-FCSCA08   PIC X(02) VALUE SPACES.         
HEMA2 *        15  WS-CASH-LOCAL-OFFICE-FCSCA08 PIC X(03) VALUE SPACES.         
HEMA2 *        15  WS-CASH-REPORT-NO-FCSCA08    PIC X(03) VALUE SPACES.         
HEMA2 *        15  WS-DATE-CASH-REPORT-FCSCA08  PIC X(10) VALUE SPACES.         
HEMA2 *        15  WS-CASH-DRAWER-ID-FCSCA08    PIC S9(4) COMP VALUE +0.        
      *                                                                         
HEMA3 *01  WS-ZERO-RECORD-CA09.                                                 
HEMA3 *    05 WS-COMPANY-NO-FCSCA09            PIC X(02)   VALUE SPACES.        
HEMA3 *    05 WS-LOCAL-OFFICE-FCSCA09          PIC X(03)   VALUE SPACES.        
HEMA3 *    05 WS-GL-ACCT-NO-FCSCA09            PIC S9(03)V9(04) COMP-3          
HEMA3 *                                                    VALUE ZEROS.         
HEMA3 *    05 WS-FUNCTION-CODE-FCSCA09         PIC X(04)   VALUE SPACES.        
HEMA3 *    05 WS-REVENUE-MONTH-FCSCA09 PIC S9(6) COMP-3    VALUE ZEROS.         
HEMA3 *    05 WS-RECORD-TYPE-FCSCA09           PIC X(01)   VALUE SPACES.        
HEMA3 *    05 WS-SEQUENCE-NO-FCSCA09   PIC S9(5) COMP-3    VALUE ZEROS.         
      *                                                                         
       01  WS-HOLD-DTJ-ACCT-NO         PIC 9(13)           VALUE ZERO.  
       01  WS-HOLD-DTJ-COMPANY         PIC X(02)           VALUE SPACES.
       01  WS-HOLD-DTJ-LOC-OFF         PIC X(03)           VALUE SPACES.
HEMA3 *01  WS-HOLD-CDR-LOC-OFF         PIC X(03)           VALUE SPACES.        
HEMA3 *01  WS-CNTRL-GL-NO-HOLD         PIC 9(04)V9(05)     VALUE ZERO.          
HEMA3 *01  WS-WORK-GO-GL-NO            PIC S9(03)V9(04).                        
HEMA3 *01  WS-WORK-GL-NO-RED REDEFINES WS-WORK-GO-GL-NO.                        
HEMA3 *    05 WS-WORK-GL-NO            PIC X(08).                               
      *                                                                         
HEMA3 *01  WS-CNTRL-INDEX-999          PIC 9(03)           VALUE ZERO.          
HEMA3 *01  WS-CNTRL-INDEX-100          PIC 9(03)           VALUE ZERO.          
HEMA3 *01  WS-CNTRL-INDEX-200          PIC 9(03)           VALUE ZERO.          
HEMA3 *01  WS-CNTRL-INDEX-300          PIC 9(03)           VALUE ZERO.          
HEMA3 *01  WS-CNTRL-INDEX-400          PIC 9(03)           VALUE ZERO.          
HEMA3 *01  WS-CNTRL-INDEX-500          PIC 9(03)           VALUE ZERO.          
HEMA3 *01  WS-CNTRL-INDEX-600          PIC 9(03)           VALUE ZERO.          
TP1313 01  WS-P-JRNL-DESC-HOLD         PIC X(03)           VALUE SPACES.
       01  WS-P-DR-CR-HOLD             PIC X(02)           VALUE SPACES.
HEMA3 *01  WS-CONTROL-COUNTER          PIC 9(02)           VALUE 0.             
HEMA3 *01  WS-NO-OF-GL-CONTROLS        PIC 9(03)           VALUE 0.             
HEMA3 *01  WS-BEGINNING-BALANCE        PIC S9(09)V99       VALUE ZERO.          
HEMA3 *01  WS-RECORD-COUNTER           PIC 9(05)     COMP  VALUE 0.             
T16880 01  WS-GL-ACCT-COUNT            PIC S9(09)    COMP  VALUE 0.     
       01  WS-CA09-COUNTERS.                                            
           05  WS-CA09-COUNT        PIC  S9(08)   COMP  VALUE +0.       
           05  WS-CA09-DET-COUNT    PIC  S9(08)   COMP  VALUE +0.       
T16880 01  WS-GL-ACCT-NULL             PIC S9(04)    COMP  VALUE 0.     
A02036 01  WS-MAX-FIOCA09-ENTRIES      PIC 9(09)     COMP  VALUE 99999. 
       01  WS-PAGE-NO-DTJ              PIC 9(04)     COMP  VALUE 0.     
HEMA3 *01  WS-PAGE-NO-GLTJ             PIC 9(04)     COMP  VALUE 1.             
HEMA3 *01  WS-PAGE-NO-CGGLE            PIC 9(04)     COMP  VALUE 1.             
HEMA3 *01  WS-PAGE-NO-GLAS             PIC 9(04)     COMP  VALUE 1.             
HEMA3 *01  WS-PAGE-NO-CDR              PIC 9(04)     COMP  VALUE 0.             
       01  WS-LINE-NO-DTJ              PIC 9(04)     COMP  VALUE 0.     
HEMA3 *01  WS-LINE-NO-CGGLE            PIC 9(04)     COMP  VALUE 0.             
HEMA3 *01  WS-LINE-NO-GLTJ             PIC 9(04)     COMP  VALUE 0.             
HEMA3 *01  WS-LINE-NO-GLAS             PIC 9(04)     COMP  VALUE 0.             
HEMA3 *01  WS-LINE-NO-CDR              PIC 9(04)     COMP  VALUE 0.             
       01  WS-DUP-NO-INCREMENT         PIC 9(03)           VALUE 0.     
HEMA3 *01  WS-DUP-NO-CA10-INCREMENT    PIC 9(02)           VALUE 0.             
       01  WS-FCA09-SEQUENCE-NO        PIC S9(05)          VALUE 0.     
       01  WS-DATE-ZERO                PIC X(10)     VALUE '0000-00-00'.
       01  WS-TIME-ZERO                PIC X(08)     VALUE '00:00:00'.  
       01  WS-REVENUE-MONTH            PIC 9(06).                       
       01  FILLER REDEFINES WS-REVENUE-MONTH.                           
           05  WS-REVENUE-MONTH-CC     PIC 9(02).                       
           05  WS-REVENUE-MONTH-YY     PIC 9(02).                       
           05  WS-REVENUE-MONTH-MM     PIC 9(02).                       
PCR647 01  WS-REVENUE-MONTH-COMMON     PIC 9(06).                       
PCR647 01  FILLER REDEFINES WS-REVENUE-MONTH-COMMON.                    
PCR647     05  WS-REVENUE-MONTH-COM-CC     PIC 9(02).                   
PCR647     05  WS-REVENUE-MONTH-COM-YY     PIC 9(02).                   
PCR647     05  WS-REVENUE-MONTH-COM-MM     PIC 9(02).                   
       01  WS-RECORD-ID-DATA-CHECK     PIC X(08)           VALUE SPACES.
       01  WS-TRAN-DATE-FCA10          PIC X(10)    VALUE SPACES.       
HEMA3 *01  WS-REPORT-LOC-OFF-CHECK     PIC X(03)    VALUE SPACES.               
HEMA3 *01  WS-REPORT-LOC-OFF-KEY-CHECK PIC X(03)    VALUE SPACES.               
HEMA3 *01  WS-LOC-OFF-KEY-CHECK        PIC X(03)    VALUE SPACES.               
HEMA3 *01  WS-GL-NO-MAJOR-KEY-CHECK    PIC 9(03)           VALUE 0.             
HEMA3 *01  WS-BATCH-COUNT              PIC 9(04)     COMP  VALUE 0.             
HEMA3 *01  WS-SORT-KEY-SAVE            PIC X(01).                               
HEMA3 *01  WS-RECORD-ID-SAVE           PIC X(01).                               
       01  WS-CHECK-FORMAT-NO          PIC 9(05).                       
       01  WS-FUNCTION-CODE            PIC X(04).                       
      *                                                                         
HEMA3 *01  WS-SAVE-AREA.                                                        
HEMA3 *    05  WS-EXCPTN-DESC-SAVE     PIC X(30)   VALUE SPACES.                
HEMA3 *    05  WS-EXCPTN-ID-SAVE       PIC X(47)   VALUE SPACES.                
      *                                                                         
       01  WS-GL-HOLD-DR               PIC 9(03)V9(04).                 
       01  WS-GL-HOLD-DR-RED                                            
           REDEFINES WS-GL-HOLD-DR.                                     
           05  WS-GL-HOLD-DR-MAJOR          PIC 9(03).                  
           05  WS-GL-HOLD-DR-MINOR          PIC 9(04).                  
      *                                                                         
       01  WS-GL-HOLD-CR               PIC 9(03)V9(04).                 
       01  WS-GL-HOLD-CR-RED                                            
           REDEFINES WS-GL-HOLD-CR.                                     
           05  WS-GL-HOLD-CR-MAJOR          PIC 9(03).                  
           05  WS-GL-HOLD-CR-MINOR          PIC 9(04).                  
      *                                                                         
       01  WS-GL-NO-BREAKDOWN          PIC 9(07)V9(04).                 
       01  WS-GL-NO-BREAKDOWN-RED                                       
           REDEFINES WS-GL-NO-BREAKDOWN.                                
           05  FILLER                       PIC X(01).                  
           05  WS-GL-NO-BREAKDOWN-LOC-OFF   PIC X(03).                  
           05  WS-GL-NO-BREAKDOWN-MAJOR     PIC 9(03).                  
           05  WS-GL-NO-BREAKDOWN-MINOR     PIC 9(04).                  
      *                                                                         
TP5712 01  WS-GL-NO-ALPHA-RED                                           
TP5712     REDEFINES WS-GL-NO-BREAKDOWN.                                
TP5712     05  FILLER                       PIC X(04).                  
TP5712     05  WS-GL-NO-ALPHA               PIC X(07).                  
      *                                                                         
       01  WS-GL-NO-LOC-OFF-BREAKDOWN-RED                               
           REDEFINES WS-GL-NO-BREAKDOWN.                                
           05  FILLER                       PIC X(01).                  
           05  WS-GL-NO-MAJOR-RED           PIC 9(03).                  
           05  WS-GL-NO-MINOR-RED           PIC 9(04).                  
           05  WS-GL-NO-LOC-OFF-RED         PIC X(03).                  
      *                                                                         
       01  WS-GL-MAJOR-MINOR-BREAKDOWN.                                 
           05  WS-GL-NO-MAJOR-M-M           PIC 9(03).                  
           05  WS-GL-NO-MINOR-M-M           PIC 9(04).                  
       01  WS-GL-MAJOR-MINOR                                            
           REDEFINES WS-GL-MAJOR-MINOR-BREAKDOWN    PIC 9(03)V9(04).    
      *                                                                         
HEMA3 *01  WS-DR-NO-ALPHABETIC.                                                 
HEMA3 *    05  FILLER                       PIC X(04).                          
HEMA3 *    05  WS-DR-NO-ALPHA               PIC X(07).                          
      *                                                                         
HEMA3 *01  WS-GL-CNDSED-CONTROL-DISPLAY.                                        
HEMA3 *    05  FILLER                       PIC X(07)  VALUE 'RE ... '.         
HEMA3 *    05  WS-CONTROL-MAJOR-DISPLAY     PIC 9(03).                          
HEMA3 *    05  FILLER                       PIC X(01)  VALUE '.'.               
HEMA3 *    05  WS-CONTROL-MINOR-DISPLAY     PIC 9(04).                          
HEMA3 *    05  FILLER                       PIC X(01)  VALUE '.'.               
HEMA3 *    05  WS-CONTROL-LOC-OFF-DISPLAY   PIC X(03).                          
HEMA3 *    05  FILLER                       PIC X(08)   VALUE SPACES.           
      *                                                                         
       01  WS-ACCT-GEN-LED-DR          PIC S9(03)V9(04).                
       01  WS-ACCT-GEN-LED-CR          PIC S9(03)V9(04).                
       01  WS-AMT-POSTED               PIC S9(09)V9(02).                
HEMA3 *01  WS-BAD-GL-NO-DR-AMOUNT      PIC S9(09)V99.                           
HEMA3 *01  WS-BAD-GL-NO-CR-AMOUNT      PIC S9(09)V99.                           
HEMA3 *01  WS-JRNL-ACTIVITY-AMOUNT     PIC S9(09)V99 COMP-3 VALUE ZERO.         
HEMA3 *01  WS-JRNL-ACTIVITY-CODE       PIC X(01).                               
HEMA3 *01  WS-UNDEPOSITED-FUNDS-CDR    PIC S9(09)V99        VALUE ZERO.         
HEMA3 *01  WS-ACCUM-NEW-BAL-CDR        PIC S9(09)V99        VALUE ZERO.         
HEMA3 *01  WS-ACCUM-WORK-FUND-CDR      PIC S9(09)V99        VALUE ZERO.         
HEMA3 *01  WS-ACCUM-UNDEP-FUND-CDR     PIC S9(09)V99        VALUE ZERO.         
HEMA3 *01  WS-ACCUM-NEW-BAL-CDR-TOTAL      PIC S9(09)V99    VALUE ZERO.         
HEMA3 *01  WS-ACCUM-WORK-FUND-CDR-TOTAL    PIC S9(09)V99    VALUE ZERO.         
HEMA3 *01  WS-ACCUM-UNDEP-FUND-CDR-TOTAL   PIC S9(09)V99    VALUE ZERO.         
HEMA3 *01  WS-ACCUM-NEW-BAL-GAM-CDR-TOTAL  PIC S9(09)V99    VALUE ZERO.         
HEMA3 *01  WS-BEG-BAL-CDR              PIC S9(09)V99        VALUE ZERO.         
HEMA3 *01  WS-JRNL-ACTIVITY-TOTAL      PIC S9(09)V99        VALUE ZERO.         
      *                                                                         
FSW    01  WS-GL-KEY                   PIC 9(03)V9(04).                 
       01  WS-GAM-KEY-BREAKDOWN                                         
           REDEFINES WS-GL-KEY.                                         
           05  WS-GAM-GL-NO-MAJOR-KEY  PIC 9(03).                       
           05  WS-GAM-GL-NO-MINOR-KEY  PIC 9(04).                       
      *                                                                         
       01  WS-WASH-TABLE-KEY.                                           
           05  WS-COMPANY-WASH-TABLE-KEY  PIC X(02) VALUE SPACES.       
           05  WS-LOC-OFF-WASH-TABLE-KEY  PIC X(03) VALUE SPACES.       
           05  WS-RPT-NO-WASH-TABLE-KEY   PIC X(03) VALUE SPACES.       
           05  WS-RPT-DATE-WASH-TABLE-KEY PIC X(10) VALUE SPACES.       
           05  WS-DRAWER-WASH-TABLE-KEY   PIC S9(4) COMP VALUE +0.      
      *                                                                         
HEMA3 *01  WS-WASH-TABLE-KEY-DISPLAY.                                           
HEMA3 *    05  WS-COMPANY-WASH-DISPLAY    PIC X(02) VALUE SPACES.               
HEMA3 *    05  FILLER                     PIC X(01) VALUE SPACES.               
HEMA3 *    05  WS-LOC-OFF-WASH-DISPLAY    PIC X(03) VALUE SPACES.               
HEMA3 *    05  FILLER                     PIC X(01) VALUE SPACES.               
HEMA3 *    05  WS-RPT-NO-WASH-DISPLAY     PIC X(03) VALUE SPACES.               
HEMA3 *    05  FILLER                     PIC X(01) VALUE SPACES.               
HEMA3 *    05  WS-RPT-DATE-WASH-DISPLAY   PIC X(10) VALUE SPACES.               
HEMA3 *    05  FILLER                     PIC X(01) VALUE SPACES.               
HEMA3 *    05  WS-DRAWER-WASH-DISPLAY     PIC X(04) VALUE SPACES.               
      *                                                                         
HEMA3 *01  WS-PENDING-MSG             PIC X(55)     VALUE SPACES.               
HEMA3 *01  WS-PENDING-MSG-S REDEFINES                                           
HEMA3 *    WS-PENDING-MSG.                                                      
HEMA3 *    05  WS-PENDING-S-DATA      PIC X(47).                                
HEMA3 *    05  FILLER                 PIC X(07).                                
       01  WS-ACCT-NO-DISPLAY         PIC 9(11)     VALUE ZEROES.       
HEMA3 *01  WS-PENDING-DESC.                                                     
HEMA3 *    05  WS-PENDING-DESC-DATA   PIC X(15)     VALUE SPACES.               
HEMA3 *    05  WS-PENDING-DESC-CODE   PIC X(01).                                
HEMA3 *    05  FILLER                 PIC X(13)     VALUE SPACES.               
HEMA3 *01  WS-TRAN-DESCRIPTION-GL-NO.                                           
HEMA3 *    05  FILLER                     PIC X(16)                             
HEMA3 *        VALUE 'GL NUM NOT FOUND'.                                        
HEMA3 *    05  WS-TRAN-DESC-GL-NO         PIC 9(09)     VALUE ZEROS.            
      *                                                                         
HEMA3 *01  WS-REC-ID-DISPLAY.                                                   
HEMA3 *    05  WS-REC-ID-LOC-OFF-DSPL     PIC X(03).                            
HEMA3 *    05  FILLER                     PIC X(01)     VALUE '-'.              
HEMA3 *    05  WS-REC-ID-ACCT-NO-DSPL     PIC 9(07).                            
HEMA3 *    05  FILLER                     PIC X(01)     VALUE '-'.              
HEMA3 *    05  WS-REC-ID-TENANT-NO-DSPL   PIC 9(03).                            
      *                                                                         
HEMA3 *01  WS-GL-NO-DISPLAY.                                                    
HEMA3 *    05  WS-MAJOR-DISPLAY           PIC 9(03).                            
HEMA3 *    05  FILLER                     PIC X(01)     VALUE '.'.              
HEMA3 *    05  WS-MINOR-DISPLAY           PIC 9(04).                            
HEMA3 *    05  FILLER                     PIC X(01)     VALUE '.'.              
HEMA3 *    05  WS-LOC-OFF-DISPLAY         PIC X(03).                            
      *                                                                         
       01  WS-BAD-GL-NO-DISPLAY.                                        
           05  WS-BAD-GL-NO-MAJOR-DISPLAY PIC 9(03).                    
           05  FILLER                     PIC X(01)     VALUE '.'.      
           05  WS-BAD-GL-NO-MINOR-DISPLAY PIC 9(04).                    
           05  FILLER                     PIC X(01)     VALUE '.'.      
           05  WS-BAD-GL-NO-LOC-OFF-DISPLAY  PIC X(03).                 
           05  FILLER                     PIC X(01)     VALUE SPACES.   
           05  WS-BAD-GL-NO-DR-CR-DISPLAY PIC X(04).                    
      *                                                                         
HEMA3 *01  WS-EXCPTN-ID-WASH-ERROR.                                             
HEMA3 *    05  FILLER                      PIC X(05)    VALUE 'COMP '.          
HEMA3 *    05  WS-EXCPTN-CASH-COMPANY-NO   PIC X(02).                           
HEMA3 *    05  FILLER                      PIC X(05)    VALUE ' L/O '.          
HEMA3 *    05  WS-EXCPTN-CASH-LOCAL-OFFICE PIC X(03).                           
HEMA3 *    05  FILLER                      PIC X(05)    VALUE ' RPT '.          
HEMA3 *    05  WS-EXCPTN-CASH-REPORT-NO    PIC X(03).                           
HEMA3 *    05  FILLER                      PIC X(06)    VALUE ' DATE '.         
HEMA3 *    05  WS-EXCPTN-DATE-CASH-REPORT  PIC X(10).                           
HEMA3 *    05  FILLER                      PIC X(04)    VALUE ' ID '.           
HEMA3 *    05  WS-EXCPTN-CASH-DRAWER-ID    PIC 9(04).                           
      *                                                                         
CBSI   01  WS-RP132-USER-DEFINED-AREA.                                  
CBSI       05  FILLER                     PIC X(10).                    
COB305     05 WS-RP132-AMT-POSTED        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-RP132-GEN-LED-DR        PIC S9(3)V9(4) COMP-3 VALUE 0.        
COB305     05 WS-RP132-GEN-LED-CR        PIC S9(3)V9(4) COMP-3 VALUE 0.        
CBSI       05  FILLER                     PIC X(34).                    
COB305     05 WS-RP132-REV-MONTH        PIC S9(6) COMP-3 VALUE 0.        
CBSI       05  FILLER                     PIC X(88).                    
CBSI  *                                                                         
HEMA3 *01  WS-TRAN-DESCRIPTION.                                                 
HEMA3 *    05  FILLER                     PIC X(17)                             
HEMA3 *        VALUE 'SYSTEM ACTIVITY, '.                                       
HEMA3 *    05  WS-TRAN-DESCRIPTION-DATE   PIC X(08)     VALUE SPACES.           
HEMA3 *01  WS-00002-ERROR-DESC.                                                 
HEMA3 *    05  WS-TOTAL-SOURCE            PIC X(04).                            
HEMA3 *    05  WS-00002-TOTALS            PIC ZZZZZ9.99.                        
HEMA3 *01  WS-TABLE-ENTRY-KEY          PIC 9(03).9(04).                         
HEMA3 *01  WS-TAX-DISPLAY              PIC ZZ,ZZZ.99.                           
       01  WS-TOTAL-TAXES              PIC 9(07)V99      VALUE ZERO.    
HEMA3 *01  WS-BUCKET-AMOUNTS           PIC 999.99.                              
HEMA3 *01  WS-TAPE-KEY-AREA            PIC X(23)         VALUE SPACE.           
      *                                                                         
       COPY FIOCA00.                                                            
      *                                                                         
       COPY FIOJC01.                                                            
      *                                                                         
TP2056 COPY CWS09900.                                                           
090889 COPY CWS00303.                                                           
TP8358 COPY CWS00150.                                                           
      *  *  *  *  *   *  *   *   *  *  *  *  *  *   *  *  *  *  *  *  *         
      *   THE FOLLOWING WORKING-STORAGE AREAS ARE USED PRIMARILY DURING         
      * THE PROCESS OF CUSTOMER ACCOUNTING JOURNALS (SORT KEY A)                
      * WHEN ADDING GENERAL LEDGER DEBIT AND CREDIT VALUES TO EITHER            
      * A WORKING STORAGE TABLE OR TO GEN-LED-DISK-WORK.                        
      *                                                                         
      *  *  *  *  *   *  *   *   *  *  *  *  *  *   *  *  *  *  *  *  *         
       01  WS-HOLD-AREAS.                                               
HEMA3 *    05  WS-GL12-KEY                  PIC 9(03)V9(04).                    
HEMA3 *    05  WS-GL12-KEY-RED REDEFINES WS-GL12-KEY.                           
HEMA3 *        10  WS-GL1-KEY               PIC 9(03).                          
HEMA3 *        10  WS-GL2-KEY               PIC 9(04).                          
HEMA3 *    05  WS-SPECIAL-GL-DR-SAVE        PIC 9(03)V9(04).                    
           05  WS-HOLD-GL-NO                PIC 9(03)V9(04)  VALUE ZERO.
           05  WS-HOLD-GL-NO-RED                                        
               REDEFINES WS-HOLD-GL-NO      PIC 9(07).                  
           05  WS-HOLD-GL-NO-MAJOR-MINOR                                
               REDEFINES WS-HOLD-GL-NO.                                 
               10  WS-HOLD-GL-NO-MAJOR      PIC 9(03).                  
               10  WS-HOLD-GL-NO-MINOR      PIC 9(04).                  
           05  WS-LOC-OFF-GL-NO-KEY         PIC X(11).                  
           05  WS-LOC-OFF-GL-NO-BREAKDOWN                               
               REDEFINES WS-LOC-OFF-GL-NO-KEY.                          
               10  FILLER                  PIC X(01).                   
               10  WS-LOC-OFF-KEY          PIC X(03).                   
               10  WS-GL-NO-KEY.                                        
                   15  WS-GL-NO-MAJOR-KEY    PIC 9(03).                 
                   15  WS-GL-NO-MINOR-KEY    PIC 9(04).                 
HEMA3 *    05  WS-GL-NO-MML                  PIC 9(11).                         
HEMA3 *    05  WS-GL-NO-MML-RED                                                 
HEMA3 *        REDEFINES WS-GL-NO-MML.                                          
HEMA3 *        10  FILLER                    PIC X(01).                         
HEMA3 *        10  WS-GL-NO-M-MAJOR          PIC 9(03).                         
HEMA3 *        10  WS-GL-NO-M-MINOR          PIC 9(04).                         
HEMA3 *        10  WS-GL-NO-L-LOC-OFF        PIC X(03).                         
TP5678     05  WS-HOLD-AMOUNT          PIC S9(09)V99    VALUE ZERO.     
           05  WS-HOLD-AMOUNT-DISPLAY  PIC ZZ,ZZZ,ZZZ.99.               
           05  WS-HOLD-TYPE            PIC X(02)        VALUE SPACES.   
HEMA3 *    05  WS-ENTRY-NO             PIC 9(10)        VALUE ZERO.             
           05  WS-HOLD-LOC-OFF         PIC X(03)        VALUE SPACES.   
HEMA3 *    05  WS-HOLD-REVENUE-MONTH    PIC S9(06) COMP-3 VALUE ZERO.           
           05  WS-HOLD-STATE-TAX-AMT    PIC S9(09)V99    VALUE ZERO.    
           05  WS-HOLD-CITY-TAX-AMT     PIC S9(09)V99    VALUE ZERO.    
           05  WS-HOLD-EXCISE-TAX-AMT   PIC S9(09)V99    VALUE ZERO.    
           05  WS-HOLD-OTHER-TAX-AMT    PIC S9(09)V99    VALUE ZERO.    
           05  WS-HOLD-TAX-TOTAL        PIC S9(09)V99    VALUE ZERO.    
121204*                                                                         
       01  WS-HOLD-CA09-DETAIL-KEY.                                     
           05 WS-HOLD-CA09-DET-COMPANY-NO      PIC X(02).               
           05 WS-HOLD-CA09-DET-LOCAL-OFFICE    PIC X(03).               
COB305     05 WS-HOLD-CA09-DET-GL-ACCT-NO        PIC S9(03)V9(04) 
COB305       COMP-3 VALUE 0. 
           05 WS-HOLD-CA09-DET-FUNCTION-CODE   PIC X(04).               
COB305     05 WS-HOLD-CA09-DET-REVENUE-MONTH        PIC S9(06) COMP-3 
COB305       VALUE 0.       
       01  FILLER REDEFINES WS-HOLD-CA09-DETAIL-KEY.                    
           05 WS-HOLD-CA09-KEY.                                         
              10 WS-HOLD-CA09-COMPANY-NO       PIC X(02).               
              10 WS-HOLD-CA09-LOCAL-OFFICE     PIC X(03).               
              10 WS-HOLD-CA09-GL-ACCT-NO       PIC S9(03)V9(04) COMP-3. 
           05 FILLER                           PIC X(08).               
      *                                                                         
      ****************************************************************          
      *                                                                         
      ***  !!!!! HONK A NOTE !!!!                                               
      *** IF PROGRAM ABENDS WITH A RC = 05 WITH WS-FIOCA09 OCCURS               
      *** ENTRIES BEING LESS THAN THE NUMBER OF ROWS RETUNED FROM DB2           
      *** TABLE DO THE FOLLOWING                                                
      *** INCREASE THE SECOND NUMBER OF THE OCCURS CLAUSE OF THE TABLE          
      *** WS-FIOCA09  TO A HIGHER NUMBER                                        
      *** ALSO CHANGE THE VALUE CLAUSE OF THE FIELD                             
      *** WS-MAX-FIOCA09-ENTRIES TO THIS NEW NUMBER.                            
      *                                                                         
      ****************************************************************          
      *                                                                         
121204 01  WS-FIOCA09-TABLE.                                            
A02036   05  WS-FIOCA09                OCCURS 1 TO 99999 TIMES          
T16880                                 DEPENDING ON WS-GL-ACCT-COUNT    
                                       ASCENDING KEY WS-FCA09-KEY       
                                       INDEXED BY WS-CA09-INDX.         
             10 WS-FCA09-KEY.                                           
                15 WS-FCA09-COMPANY-NO        PIC X(02).                
                15 WS-FCA09-LOCAL-OFFICE      PIC X(03).                
COB305          15 WS-FCA09-GL-ACCT-NO        PIC S9(03)V9(04) COMP-3 
COB305             VALUE 0. 
            10  WS-FCA09-CODE-ACCT-STATUS     PIC X(01).                
121204      10  WS-FCA09-UPDATE-CODES.                                  
               15  WS-FCA09-UPDATE-CODE-1     PIC X(01).                
               15  WS-FCA09-UPDATE-CODE-2     PIC X(01).                
               15  WS-FCA09-UPDATE-CODE-3     PIC X(01).                
               15  WS-FCA09-UPDATE-CODE-4     PIC X(01).                
               15  WS-FCA09-UPDATE-CODE-5     PIC X(01).                
               15  WS-FCA09-UPDATE-CODE-6     PIC X(01).                
            10  WS-FCA09-ACCT-DESC            PIC X(25).                
            10  WS-FCA09-ACCT-NAME            PIC X(10).                
            10  WS-FCA09-DATE-LAST-TRANS      PIC X(10).                
            10  WS-FCA09-EXTRACT-BALANCE      PIC S9(09)V99.            
            10  FILLER                        PIC X(15).                
      *                                                                         
       01  WS-FIOCA09-DETAIL-TABLE.                                     
A02036   05  WS-FIOCA09-DET OCCURS 1 TO 99999 TIMES                     
A02036                         DEPENDING ON WS-CA09-DET-COUNT           
                               INDEXED BY WS-CA09-DET-INDX.             
             10 WS-FCA09-DETAIL-KEY.                                    
                15 WS-FCA09-DET-COMPANY-NO     PIC X(02).               
                15 WS-FCA09-DET-LOCAL-OFFICE   PIC X(03).               
COB305          15 WS-FCA09-DET-GL-ACCT-NO        PIC S9(03)V9(04) 
COB305             COMP-3 VALUE 0. 
                15 WS-FCA09-DET-FUNCTION-CODE  PIC X(04).               
COB305          15 WS-FCA09-DET-REVENUE-MONTH        PIC S9(06) COMP-3 
COB305             VALUE 0.    
COB305      10 WS-FCA09-JRNL-ACTIVITY-DR        PIC S9(09)V99 COMP-3 
COB305         VALUE 0.    
COB305      10 WS-FCA09-JRNL-ACTIVITY-CR        PIC S9(09)V99 COMP-3 
COB305         VALUE 0.    
      *                                                                         
      *  *  *  *  *   *  *   *   *  *  *  *  *  *   *  *  *  *  *  *  *         
      *    THESE ARE ACCUMULATORS FOR COMPANY DEBITS AND CREDITS                
      * ACCUMULATED TO DURING GEN-LED ADD PROCESS, WHEN PROCESSING              
      * SORT KEY-A ITEMS ONLY.                                                  
      *  *  *  *  *   *  *   *   *  *  *  *  *  *   *  *  *  *  *  *  *         
      *                                                                         
       01  WS-ACCUM-DR              PIC S9(11)V99    VALUE ZERO.        
       01  WS-ACCUM-CR              PIC S9(11)V99    VALUE ZERO.        
       01  WS-ACCUM-DR-ARM          PIC S9(11)V99    VALUE ZERO.        
       01  WS-ACCUM-CR-ARM          PIC S9(11)V99    VALUE ZERO.        
       01  WS-ACCUM-DR-IND          PIC S9(11)V99    VALUE ZERO.        
       01  WS-ACCUM-CR-IND          PIC S9(11)V99    VALUE ZERO.        
       01  WS-ACCUM-DR-CGGLE-TOTAL  PIC S9(11)V99    VALUE ZERO.        
       01  WS-ACCUM-CR-CGGLE-TOTAL  PIC S9(11)V99    VALUE ZERO.        
       01  WS-CNTRL-GLT             PIC 9(03)        VALUE ZERO.        
      **                                                                        
       01  WS-SWITCHES.                                                 
TP5710     05  WS-CASH-DRAWER-FOUND             PIC X(01)  VALUE 'N'.   
TP5710         88  CASH-DRAWER-FOUND                       VALUE 'Y'.   
HEMA3 *    05  WS-HAVE-ALL-PARAMS-BEEN-FOUND    PIC X(03)  VALUE 'N'.           
HEMA3 *        88  WS-ALL-PARAMS-HAVE-BEEN-FOUND           VALUE 'Y'.           
HEMA3 *    05  WS-VALIDATE-PARAMETERS           PIC X(03).                      
HEMA3 *        88  WS-VALID-PARAMETER-OPTION                                    
HEMA3 *                                           VALUES 'YES' 'NO '.           
HEMA3 *    05  WS-FIRST-ESDS-RECORD             PIC X(01)  VALUE 'Y'.           
HEMA3 *        88  WS-THIS-FIRST-ESDS-RECORD               VALUE 'Y'.           
           05  WS-LAST-ESDS-RECORD              PIC X(01)  VALUE 'N'.   
               88  WS-THIS-THE-LAST-ESDS-RECORD            VALUE 'Y'.   
HEMA1 *    05  WS-LAST-SEQ-CA04-REC             PIC X(01)  VALUE 'N'.           
HEMA1 *        88  WS-THIS-IS-LAST-SEQ-CA04-REC            VALUE 'Y'.           
HEMA2 *    05  WS-LAST-SEQ-CA08-REC             PIC X(01)  VALUE 'N'.           
HEMA2 *        88  WS-THIS-IS-LAST-SEQ-CA08-REC            VALUE 'Y'.           
HEMA3 *    05  WS-IS-THIS-THE-FIRST-CA09-REC    PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-THIS-IS-THE-FIRST-CA09-REC           VALUE 'Y'.           
HEMA3 *    05  WS-LAST-SEQ-CA09-REC             PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-THIS-IS-LAST-SEQ-CA09-REC            VALUE 'Y'.           
HEMA3 *    05  WS-PRINT-COMPANY-TOTALS          PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-PRINT-CGGLE-CMPNY-TOTALS             VALUE 'Y'.           
           05  WS-SHOULD-CASH-DRWR-BE-PRINTED   PIC X(01)  VALUE 'Y'.   
               88  WS-PRINT-CASH-DRAWER                    VALUE 'Y'.   
HEMA3 *    05  WS-LAST-SEQ-GLDW-REC             PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-THIS-IS-LAST-SEQ-GLDW-REC            VALUE 'Y'.           
HEMA3 *    05  WS-CGGLE-DONE                    PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-CGGLE-IS-DONE                        VALUE 'Y'.           
HEMA3 *    05  WS-GLAS-DONE                     PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-GLAS-IS-DONE                         VALUE 'Y'.           
           05  WS-NO-TAX-ADD                    PIC X(01)  VALUE 'N'.   
               88  WS-NO-TAX-IS-ADDED                      VALUE 'Y'.   
HEMA3 *    05  WS-HAS-FICHE-BREAK-OCCURED       PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-FICHE-BREAK-HAS-OCCURED              VALUE 'Y'.           
           05  WS-COMPANY-BREAK-SW              PIC X(01)  VALUE 'N'.   
               88  WS-COMPANY-BREAK-HAS-OCCURED            VALUE 'Y'.   
HEMA3 *    05  WS-IS-RECORD-FOUND-IN-GL-TABLE   PIC X(01)  VALUE 'Y'.           
HEMA3 *        88  WS-RECORD-IS-NOT-IN-GL-TABLE            VALUE 'N'.           
HEMA3 *    05  WS-IS-THIS-A-VALID-GL-NUM        PIC X(01)  VALUE 'Y'.           
HEMA3 *        88  WS-THIS-IS-NOT-A-VALID-GL-NUM           VALUE 'N'.           
HEMA3 *    05  WS-WAS-GL-NUMBER-FOUND           PIC X(01)  VALUE 'Y'.           
HEMA3 *        88  WS-GL-NUMBER-NOT-IN-GA                  VALUE 'N'.           
HEMA3 *    05  WS-WAS-GTH-SEG-FOUND             PIC X(01)  VALUE 'Y'.           
HEMA3 *        88  WS-GTH-SEG-WAS-FOUND                    VALUE 'Y'.           
HEMA3 *        88  WS-GTH-SEG-NOT-FOUND                    VALUE 'N'.           
HEMA3 *    05  WS-IS-TOC-SEGMENT-BALANCED       PIC X(01)  VALUE 'Y'.           
HEMA3 *        88  WS-TOC-IS-NOT-BALANCED                  VALUE 'N'.           
           05  WS-IS-DUP-KEY-ELIMINATED         PIC X(01)  VALUE 'N'.   
               88  WS-DUP-KEY-IS-ELIMINATED                VALUE 'Y'.   
HEMA3 *    05  WS-WAS-END-OF-TAPE-REACHED       PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-END-OF-TAPE-WAS-REACHED              VALUE 'Y'.           
HEMA3 *    05  WS-IS-THIS-THE-FIRST-CASH-DRWR   PIC X(01)  VALUE 'N'.           
HEMA3 *        88  WS-THIS-IS-THE-FIRST-CASH-DRWR          VALUE 'Y'.           
HEMA3 *    05  WS-ARE-CASH-DRAWERS-IN-BALANCE   PIC X(01)  VALUE 'Y'.           
HEMA3 *        88  WS-CASH-DRAWERS-ARE-IN-BALANCE          VALUE 'Y'.           
T30899     05  WS-SEB-DATABASE-SW               PIC X(01)  VALUE 'N'.   
T30899         88  WS-SEB-YES                              VALUE 'Y'.   
HEMA3 *    05  WS-LOC-OFF                 PIC X(03).                            
           05  WS-CA09-DET-FLAG         PIC X  VALUE 'Y'.               
               88   CA09-DET-FOUND      VALUE  'Y'.                     
               88   CA09-DET-NOT-FOUND  VALUE  'N'.                     
121204     05  WS-CA09-FLAG             PIC X  VALUE 'Y'.               
121204         88   CA09-FOUND          VALUE  'Y'.                     
121204         88   CA09-NOT-FOUND      VALUE  'N'.                     
       01  WS-CURRENT-DATE-CYMD        PIC X(10).                       
TP8358 01  WS-CURRENT-TIME.                                             
TP8358     05  WS-HH                   PIC 9(02).                       
TP8358     05  WS-MM                   PIC 9(02).                       
TP8358     05  WS-SS                   PIC 9(02).                       
TP8358     05  WS-TT                   PIC 9(02).                       
TP8358 01  WS-CURRENT-DATE.                                             
TP8358     05  WS-CY                   PIC 9(02).                       
TP8358     05  WS-CM                   PIC 9(02).                       
TP8358     05  WS-CD                   PIC 9(02).                       
TP8358 01  WS-RUN-TIME.                                                 
TP8358     05  WS-RT-HH                PIC X(02).                       
TP8358     05  FILLER                  PIC X(01) VALUE ':'.             
TP8358     05  WS-RT-MM                PIC X(02).                       
TP8358     05  FILLER                  PIC X(01) VALUE ':'.             
TP8358     05  WS-RT-SS                PIC X(02).                       
TP8358 01  WS-DATES-DISPLAY.                                            
TP8358     05  WS-DATE-DISPLAY-MM      PIC X(02).                       
TP8358     05  FILLER                  PIC X(01) VALUE '/'.             
TP8358     05  WS-DATE-DISPLAY-DD      PIC X(02).                       
TP8358     05  FILLER                  PIC X(01) VALUE '/'.             
TP8358     05  WS-DATE-DISPLAY-YY      PIC X(02).                       
HEMA3 *01  WS-ACCTNG-PER-DATE-CYM      PIC X(09) VALUE SPACES.                  
HEMA3 *01  FILLER REDEFINES                                                     
HEMA3 *    WS-ACCTNG-PER-DATE-CYM.                                              
HEMA3 *    05  FILLER                  PIC X(03).                               
HEMA3 *    05  WS-CCYYMM-CC            PIC X(02).                               
HEMA3 *    05  WS-CCYYMM-YY            PIC X(02).                               
HEMA3 *    05  WS-CCYYMM-MM            PIC X(02).                               
      *                                                                         
      * THE FOLLOWING LAYOUT GETS MOVED TO FIOCA04                              
      * AND NEEDS TO BE CHANGED IF FIOCA04 CHANGES                              
      * THE USER DEFINED AREA OF THE COPYBOOK MAPS TO                           
      * THE JOURNAL COPYBOOK CJF00201                                           
HEMA3 *01  WS-GL-TRAN.                                                          
HEMA3 *    05  WS-GL-TRAN-JRNL-SORT-ID        PIC X(01).                        
HEMA3 *    05  WS-GL-TRAN-COMPANY-NO          PIC X(02).                        
HEMA3 *    05  WS-GL-TRAN-LOCAL-OFFICE        PIC X(03).                        
HEMA3 *    05  WS-GL-TRAN-RECORD-ID.                                            
HEMA3 *        10  WS-GL-TRAN-GL-ACCT-NO      PIC S9(03)V9(04)  COMP-3.         
HEMA3 *        10  WS-GL-TRAN-ACCT-NO-FILLER  PIC X(03).                        
HEMA3 *    05  WS-GL-TRAN-TRAN-DATE           PIC X(10).                        
HEMA3 *    05  WS-GL-TRAN-TRAN-TIME           PIC X(08).                        
HEMA3 *    05  WS-GL-TRAN-CODE-TERMINAL-TRAN  PIC X(04).                        
HEMA3 *    05  WS-GL-TRAN-JRNL-TRAN-APPL-NO   PIC S9(03)   COMP-3.              
HEMA3 *    05  WS-GL-TRAN-DUP-CONTROL-KEY     PIC S9(03)   COMP-3.              
HEMA3 *    05  WS-GL-TRAN-DATE-LAST-ACTION    PIC X(10).                        
HEMA3 *    05  WS-GL-TRAN-REVENUE-MONTH       PIC S9(06)   COMP-3.              
HEMA3 *    05  WS-GL-TRAN-CODE-ENTRY-SOURCE   PIC X(01).                        
HEMA3 *    05  WS-GL-TRAN-USER-ID             PIC X(07).                        
HEMA3 *    05  WS-GL-TRAN-CASH-COMPANY-NO     PIC X(02).                        
HEMA3 *    05  WS-GL-TRAN-CASH-LOCAL-OFFICE   PIC X(03).                        
HEMA3 *    05  WS-GL-TRAN-CASH-REPORT-NO      PIC X(03).                        
HEMA3 *    05  WS-GL-TRAN-DATE-CASH-REPORT    PIC X(10).                        
HEMA3 *    05  WS-GL-TRAN-CASH-DRAWER-ID      PIC S9(4) COMP.                   
HEMA3 *    05  WS-GL-TRAN-TRANS-ERRORS        PIC X(07).                        
      * THE FOLLOWING PORTION OF THE LAYOUT MATCHES CJF00201                    
HEMA3 *    05  WS-GL-TRAN-USER-DEFINED-AREA.                                    
HEMA3 *        10 WS-GL-TRAN-JRNL-FORMAT-NO      PIC S9(05)    COMP-3.          
HEMA3 *        10 WS-GL-TRAN-CASH-DRAWER-USED    PIC X(01).                     
HEMA3 *        10 WS-GL-TRAN-AMT-ENTERED         PIC S9(11)V99 COMP-3.          
HEMA3 *        10 WS-GL-TRAN-AMT-POSTED          PIC S9(11)V99 COMP-3.          
HEMA3 *        10 WS-GL-TRAN-CODE-DR-CR          PIC X(01).                     
HEMA3 *        10 WS-GL-TRAN-ACCTING-PERIOD      PIC S9(09)    COMP.            
HEMA3 *        10 WS-GL-TRAN-CODE-JRNL-ENT-SRCE  PIC X(01).                     
HEMA3 *        10 WS-GL-TRAN-JRNL-ENT-NO         PIC S9(09)    COMP-3.          
HEMA3 *        10 WS-GL-TRAN-OFFSET-COMPANY-NO   PIC 9(02).                     
HEMA3 *        10 WS-GL-TRAN-OFFSET-GL-ACCT-NO   PIC S999V9999 COMP-3.          
HEMA3 *        10 WS-GL-TRAN-OFFSET-LOCAL-OFFICE PIC X(03).                     
HEMA3 *        10 WS-GL-TRAN-FUNCTION-CODE       PIC X(04).                     
HEMA3 *        10 WS-GL-TRAN-COST-CENTER         PIC 9(03).                     
HEMA3 *        10 WS-GL-TRAN-COST-CODE-TYPE      PIC X(03).                     
HEMA3 *        10 WS-GL-TRAN-NOE-CODE            PIC 9(03).                     
HEMA3 *        10 WS-GL-TRAN-WORK-ORDER-NO       PIC X(08).                     
HEMA3 *        10 WS-GL-TRAN-RESP-ID             PIC X(04).                     
HEMA3 *        10 WS-GL-TRAN-TRAN-DESCRIPTION    PIC X(45).                     
HEMA3 *        10 FILLER                         PIC X(42).                     
                                                                        
       01  WS-ACCT-NO-CA07                  PIC 9(13).                  
HEMA3 *01  WS-TRANSACTION-INFO-HOLD         PIC X(41) VALUE SPACES.             
       01  WS-HOLD-SOURCE-OF-FUNDS          PIC 9(03)V9(04) VALUE ZERO. 
       01  WS-CHECK-SOURCE-OF-FUNDS         PIC 9(03)V9(04) VALUE ZERO. 
       01  WS-CHECK-SOURCE-OF-FUNDS-RED                                 
           REDEFINES WS-CHECK-SOURCE-OF-FUNDS.                          
           05  WS-CHECK-SOURCE-OF-FUNDS-MAJOR    PIC 9(03).             
           05  FILLER                            PIC 9(04).             
HEMA3 *01  WS-PRINTER-CONTROL.                                                  
HEMA3 *    05  WS-LINES-PRT-S          PIC S999     COMP-3 VALUE ZERO.          
HEMA3 *    05  WS-PAGE-SIZE-S          PIC 9999     COMP-3 VALUE 51.            
HEMA3 *    05  WS-PAGE-COUNT-S         PIC S999     COMP-3 VALUE +1.            
HEMA3 *        88  WS-FIRST-PAGE-S                         VALUE +1.            
HEMA3 *01  WS-DISPLAY-LINE.                                                     
HEMA3 *    05  FILLER               PIC X(03)   VALUE SPACES.                   
HEMA3 *    05  P-HOLD-TYPE-DISPLAY  PIC X(02).                                  
HEMA3 *    05  FILLER               PIC X(03)   VALUE SPACES.                   
HEMA3 *    05  P-GEN-LED-DISPLAY    PIC 999.9999.                               
HEMA3 *    05  FILLER               PIC X(01)   VALUE SPACES.                   
HEMA3 *    05  P-HOLD-GL-NO-DISPLAY PIC 999.9999.                               
HEMA3 *    05  FILLER               PIC X(03)   VALUE SPACES.                   
HEMA3 *    05  P-HOLD-AMOUNT-DISPLAY PIC 999,999,999.99.                        
HEMA3 *01  WS-EXCPTN-MESSAGE-VALUES.                                            
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'A'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'POSSIBLE TAX CODE ERROR                                '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'B'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'TRANSACTION HAS QUESTIONABLE ACCURACY                  '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'C'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'METER CONSTANT OR CONTRACT DEMAND HAS CHANGED          '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'J'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'NEW CONTRACT ESTABLISHED                               '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'K'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'CHARGE-OFF ACTIVITY OCCURRED FROM REMOTE LOCATION      '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'L'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'PAYMENT ARRANGEMENTS ESTABLISHED                       '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'M'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'NON-SUFFICIENT FUND CHARGES ESTABLISHED               '.            
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'N'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'CANCEL REBILL ... REVENUE ADJUSTMENT                   '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'O'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'DEFFERRED AGREEMENT HAS BEEN ESTABLISHED               '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'R'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'BILLED RECEIVABLE AGING WAS CHANGED                    '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'S'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'EXEMPTED FROM DISCONNECT FOR NON-PAYMENT NOTICES       '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'T'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    'CHANGES OCCURRED TO CREDIT AND/OR DISCONNECT HISTORY   '.           
HEMA3 *    05  FILLER            PIC X(01)    VALUE 'W'.                        
HEMA3 *    05  FILLER            PIC X(55)    VALUE                             
HEMA3 *    '***EMP*** ACCOUNT INFORMATION CHANGED                  '.           
HEMA3 *01  WS-EXCPTN-MSG-VALUES REDEFINES WS-EXCPTN-MESSAGE-VALUES.             
HEMA3 *    05  WS-EXCEPTION-MESSAGE-RECORD OCCURS 13 TIMES                      
HEMA3 *            INDEXED BY WS-MSG-INDEX.                                     
HEMA3 *        10  WS-MESSAGE-KEY-TABLE       PIC X(01).                        
HEMA3 *        10  WS-MESSAGE-DATA-TABLE      PIC X(55).                        
      *                                                                         
       01  WS-BATCH-WASH-TABLE-VALUES.                                  
           05  WS-BATCH-WASH-TABLE-RECORD OCCURS 1000 TIMES             
               INDEXED BY WS-INDEX-BWT.                                 
               10  WS-ACTIVITY-SOURCE-BWT.                              
                   15  WS-CASH-COMPANY-NO-BWT    PIC X(02).             
                   15  WS-CASH-LOCAL-OFFICE-BWT  PIC X(03).             
                   15  WS-CASH-REPORT-NO-BWT     PIC X(03).             
                   15  WS-DATE-CASH-REPORT-BWT   PIC X(10).             
                   15  WS-CASH-DRAWER-ID-BWT     PIC S9(4) COMP.        
               10  WS-JRNL-ACCUM-ACT-TOTALS-BWT.                        
                   15  WS-CASH-TOTALS-BWT.                              
COB305                 20 WS-CASH-DR-TOTAL-BWT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
COB305                 20 WS-CASH-CR-TOTAL-BWT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
                   15  WS-AR-TOTALS-BWT.                                
COB305                 20 WS-AR-DR-TOTAL-BWT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
COB305                 20 WS-AR-CR-TOTAL-BWT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
                   15  WS-GL-TOTALS-BWT.                                
COB305                 20 WS-GL-DR-TOTAL-BWT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
COB305                 20 WS-GL-CR-TOTAL-BWT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
                   15  WS-CKI-TOTALS-BWT.                               
COB305                 20 WS-CKI-DR-TOTAL-BWT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
COB305                 20 WS-CKI-CR-TOTAL-BWT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
      *                                                                         
       01  WS-CASH-DRWR-TABLE.                                          
           05  WS-CASH-DRWR-TABLE-RECORD OCCURS 1000 TIMES              
               INDEXED BY WS-INDEX-CDT.                                 
               10  WS-ACTIVITY-SOURCE-CDT.                              
                   15  WS-CASH-COMPANY-NO-CDT    PIC X(02).             
                   15  WS-CASH-LOCAL-OFFICE-CDT  PIC X(03).             
                   15  WS-CASH-REPORT-NO-CDT     PIC X(03).             
                   15  WS-DATE-CASH-REPORT-CDT   PIC X(10).             
                   15  WS-CASH-DRAWER-ID-CDT     PIC S9(4) COMP.        
               10  WS-JRNL-ACCUM-ACT-TOTALS-CDT.                        
                   15  WS-CASH-TOTALS-CDT.                              
COB305                 20 WS-CASH-DR-TOTAL-CDT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
COB305                 20 WS-CASH-CR-TOTAL-CDT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
                   15  WS-AR-TOTALS-CDT.                                
COB305                 20 WS-AR-DR-TOTAL-CDT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
COB305                 20 WS-AR-CR-TOTAL-CDT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
                   15  WS-GL-TOTALS-CDT.                                
COB305                 20 WS-GL-DR-TOTAL-CDT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
COB305                 20 WS-GL-CR-TOTAL-CDT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
                   15  WS-CKI-TOTALS-CDT.                               
COB305                 20 WS-CKI-DR-TOTAL-CDT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
COB305                 20 WS-CKI-CR-TOTAL-CDT        PIC S9(09)V99 
COB305                   COMP-3 VALUE 0.
HEMA3 *01  WS-ERROR-MESSAGES.                                                   
HEMA3 *    05  WS-AR-NOT-EQUAL     PIC X(29)                                    
HEMA3 *        VALUE '* ACCT RECEIVABLE NOT EQUAL *'.                           
HEMA3 *    05  WS-TOTAL-TYPE-ERROR    PIC X(13).                                
       01  WS-LITERALS.                                                 
           05  WS-0                    PIC X(01)      VALUE '0'.        
           05  WS-00                   PIC X(02)      VALUE '00'.       
           05  WS-00001                PIC 9(05)      VALUE 00001.      
           05  WS-00002                PIC 9(05)      VALUE 00002.      
           05  WS-1                    PIC 9(01)      VALUE 1.          
           05  WS-3                    PIC X(01)      VALUE '3'.        
           05  WS-6                    PIC X(01)      VALUE '6'.        
           05  WS-9                    PIC X(01)      VALUE '9'.        
HEMA3 *    05  WS-10                   PIC 9(03)      VALUE 010.                
           05  WS-010                  PIC X(03)      VALUE '010'.      
           05  WS-30                   PIC X(02)      VALUE '30'.       
           05  WS-030                  PIC X(03)      VALUE '030'.      
HEMA3 *    05  WS-50                   PIC 9(02)      VALUE 50.                 
           05  WS-60                   PIC X(02)      VALUE '60'.       
           05  WS-060                  PIC X(03)      VALUE '060'.      
           05  WS-90                   PIC X(02)      VALUE '90'.       
           05  WS-090                  PIC X(03)      VALUE '090'.      
           05  WS-100                  PIC 9(03)      VALUE 100.        
           05  WS-101                  PIC 9(05)      VALUE 00101.      
           05  WS-102                  PIC 9(05)      VALUE 00102.      
           05  WS-103                  PIC 9(05)      VALUE 00103.      
           05  WS-104                  PIC 9(05)      VALUE 00104.      
           05  WS-105                  PIC 9(05)      VALUE 00105.      
TP9306     05  WS-111                  PIC 9(05)      VALUE 00111.      
HEMA3 *    05  WS-110                  PIC 9(03)      VALUE 110.                
           05  WS-113                  PIC 9(03)      VALUE 113.        
HEMA3 *    05  WS-200                  PIC 9(05)      VALUE 00200.              
HEMA3 *    05  WS-201                  PIC 9(05)      VALUE 00201.              
HEMA3 *    05  WS-211                  PIC 9(05)      VALUE 00211.              
HEMA3 *    05  WS-212                  PIC 9(05)      VALUE 00212.              
HEMA3 *    05  WS-999999S              PIC 9(11)      VALUE 99999999999.        
           05  WS-D                    PIC X(01)      VALUE 'D'.        
HEMA3 *    05  WS-E                    PIC X(01)      VALUE 'E'.                
           05  WS-F                    PIC X(01)      VALUE 'F'.        
HEMA3 *    05  WS-J                    PIC X(01)      VALUE 'J'.                
HEMA3 *    05  WS-K                    PIC X(01)      VALUE 'K'.                
HEMA3 *    05  WS-M                    PIC X(01)      VALUE 'M'.                
           05  WS-N                    PIC X(01)      VALUE 'N'.        
           05  WS-P                    PIC X(01)      VALUE 'P'.        
HEMA3 *    05  WS-R                    PIC X(01)      VALUE 'R'.                
           05  WS-S                    PIC X(01)      VALUE 'S'.        
HEMA3 *    05  WS-T                    PIC X(01)      VALUE 'T'.                
HEMA3 *    05  WS-W                    PIC X(01)      VALUE 'W'.                
           05  WS-Y                    PIC X(01)      VALUE 'Y'.        
           05  WS-Z                    PIC X(01)      VALUE 'Z'.        
HEMA3 *    05  WS-ASTERISK             PIC X(01)      VALUE '*'.                
ITEMID     05  WS-DR                   PIC X(01)      VALUE 'D'.        
ITEMID     05  WS-CR                   PIC X(01)      VALUE 'C'.        
           05  WS-CO                   PIC X(02)      VALUE 'CO'.       
           05  WS-FM                   PIC X(02)      VALUE 'FM'.       
           05  WS-PP                   PIC X(02)      VALUE 'PP'.       
           05  WS-YES                  PIC X(01)      VALUE 'Y'.        
HEMA3 *    05  WS-STX                  PIC X(03)      VALUE 'STX'.              
HEMA3 *    05  WS-CTX                  PIC X(03)      VALUE 'CTX'.              
HEMA3 *    05  WS-OTX                  PIC X(03)      VALUE 'OTX'.              
HEMA3 *    05  WS-ETX                  PIC X(03)      VALUE 'ETX'.              
           05  WS-NO                   PIC X(01)      VALUE 'N'.        
HEMA3 *    05  WS-OPTN                 PIC X(04)      VALUE 'OPTN'.             
TP1313     05  WS-PMT                  PIC X(05)      VALUE 'PMT'.      
TP1313     05  WS-CHG                  PIC X(05)      VALUE 'CHG'.      
           05  WS-BILL                 PIC X(05)      VALUE 'BILL.'.    
           05  WS-B-ADJ                PIC X(05)      VALUE 'B-ADJ'.    
TP1313     05  WS-ADJ                  PIC X(05)      VALUE 'ADJ'.      
TP1313     05  WS-XFR                  PIC X(05)      VALUE 'XFR'.      
TP1313     05  WS-MAINT                PIC X(05)      VALUE 'MNT'.      
TP1313     05  WS-IS                   PIC X(05)      VALUE 'IS '.      
HEMA3 *    05  WS-TO                   PIC X(03)      VALUE 'TO '.              
HEMA3 *    05  WS-FROM                 PIC X(03)      VALUE 'FR '.              
TP1313     05  WS-WAS                  PIC X(05)      VALUE 'WAS'.      
HEMA3 *    05  WS-GA01                 PIC X(04)      VALUE 'GA01'.             
HEMA3 *    05  WS-AR08                 PIC X(04)      VALUE 'AR08'.             
HEMA3 *    05  WS-AR12                 PIC X(04)      VALUE 'AR12'.             
HEMA3 *    05  WS-AR16                 PIC X(04)      VALUE 'AR16'.             
HEMA3 *    05  WS-SO06                 PIC X(04)      VALUE 'SO06'.             
HEMA3 *    05  WS-JE                   PIC X(05)      VALUE 'JE   '.            
HEMA3 *    05  WS-VCHR                 PIC X(05)      VALUE 'VCHR '.            
HEMA3 *    05  WS-SYS                  PIC X(05)      VALUE 'SYS  '.            
HEMA3 *    05  WS-SYSGEN               PIC X(06)      VALUE 'SYSGEN'.           
HEMA3 *    05  WS-GO                   PIC X(03)      VALUE 'GO '.              
HEMA3 *    05  WS-TOTALS               PIC X(06)      VALUE 'TOTALS'.           
HEMA3 *    05  WS-TOTAL                PIC X(05)      VALUE 'TOTAL'.            
HEMA3 *    05  WS-TOM                  PIC X(04)      VALUE ' TOM'.             
HEMA3 *    05  WS-TOT                  PIC X(04)      VALUE ' TOT'.             
HEMA3 *    05  WS-DVDS                 PIC X(04)      VALUE 'DVDS'.             
HEMA3 *    05  WS-GNLD                 PIC X(04)      VALUE 'GNLD'.             
HEMA3 *    05  WS-TRLC                 PIC X(04)      VALUE 'TRLC'.             
HEMA3 *    05  WS-CASH                 PIC X(07)      VALUE 'CASH - '.          
HEMA3 *    05  WS-PERIOD               PIC X(01)      VALUE '.'.                
HEMA3 *    05  WS-CONDITION-CODE       PIC X(15)                                
HEMA3 *        VALUE 'CONDITION CODE '.                                         
HEMA3 *    05  WS-PAYOFF               PIC X(15)                                
HEMA3 *        VALUE 'PAYOFF         '.                                         
HEMA3 *    05  WS-COMPANY-TOTAL        PIC X(13)                                
HEMA3 *        VALUE 'COMPANY TOTAL'.                                           
HEMA3 *    05  WS-DRAWER-TOTAL         PIC X(13)                                
HEMA3 *        VALUE 'DRAWER TOTAL '.                                           
HEMA3 *    05  WS-OUT-OF-BALANCE-WORD  PIC X(14)                                
HEMA3 *        VALUE 'OUT OF BALANCE'.                                          
HEMA3 *    05  WS-COMPANY-TOTALS       PIC X(24)                                
HEMA3 *        VALUE 'CO. TOTALS...ACCUMULATED'.                                
HEMA3 *    05  WS-COMPANY-TOTALS-POSTED PIC X(24)                               
HEMA3 *        VALUE 'CO. TOTALS...POSTED     '.                                
HEMA3 *    05  WS-GLAS-ACCUM-TOTALS    PIC X(42)                                
HEMA3 *        VALUE 'GLAS ACCUMULATED TOTALS                   '.              
HEMA3 *    05  WS-GLTJ-ACCUM-TOTALS    PIC X(42)                                
HEMA3 *        VALUE 'GLTJ ACCUMULATED TOTALS                   '.              
HEMA3 *    05  WS-MSG-UNDEFINED-ERROR  PIC X(55)   VALUE                        
HEMA3 *       'HAS NOT BEEN DEFINED TO THE DAILY JOURNAL              '.        
HEMA3 *    05  WS-CONTRACT-PAYOFF      PIC X(55)   VALUE                        
HEMA3 *       'TO A CONTRACT HAS OCCURRED ACCORDING TO UPDATE RESULTS '.        
T30899     05  WS-SEB                     PIC S9(9)V9(5)                
T30899                                              VALUE 2.00000.      
T30899     05  WS-DATABASE                PIC X(08) VALUE 'DATABASE'.   
T30899     05  WS-COMPANY-NO              PIC X(02) VALUE '01'.         
       01  WS-PROGRAM-MESSAGES.                                         
HEMA3 *    05  MSG-CUST-TRANS             PIC X(15)                             
HEMA3 *        VALUE 'CUST-TRANS'.                                              
HEMA2 *    05  MSG-READ-ERROR-FCSCA08     PIC X(30)                             
HEMA2 *        VALUE 'READING ERROR IN FILE FCSCA08'.                           
HEMA2 *    05  MSG-WRITE-ERROR-FCSCA08    PIC X(30)                             
HEMA2 *        VALUE 'REWRITE ERROR IN FILE FCSCA08'.                           
HEMA3 *    05  MSG-OFFSET-GL-NO-BAD       PIC X(16)                             
HEMA3 *        VALUE 'OFFSET GL-NO BAD'.                                        
           05  MSG-CHNGED                 PIC X(06)                     
               VALUE 'CHNGD '.                                          
       01  WS-FCSCA10-MESSAGES.                                         
HEMA2 *    05  WS-CNTRL-TOT-CA08-EDIT       PIC 9(09).99-.                      
HEMA2 *    05  WS-JRNL-TOT-CA08-EDIT      PIC 9(09).99-.                        
HEMA3 *    05  MSG-ERROR                  PIC X(06) VALUE ' ERROR'.             
HEMA3 *    05  MSG-CSH-DR                 PIC X(06) VALUE 'CSH-DR'.             
HEMA3 *    05  MSG-CSH-CR                 PIC X(06) VALUE 'CSH-CR'.             
HEMA3 *    05  MSG-AR-DR                  PIC X(06) VALUE 'A/R-DR'.             
HEMA3 *    05  MSG-AR-CR                  PIC X(06) VALUE 'A/R-CR'.             
HEMA3 *    05  MSG-GL-DR                  PIC X(06) VALUE 'G/L-DR'.             
HEMA3 *    05  MSG-GL-CR                  PIC X(06) VALUE 'G/L-CR'.             
HEMA3 *    05  MSG-CKI-DR                 PIC X(06) VALUE 'CKI-DR'.             
HEMA3 *    05  MSG-CKI-CR                 PIC X(06) VALUE 'CKI-CR'.             
           05  MSG-S-KEY                  PIC X(06) VALUE 'S-KEY '.     
           05  MSG-T-CODE                 PIC X(06) VALUE 'T-CODE'.     
           05  MSG-ID                     PIC X(06) VALUE '   ID '.     
           05  MSG-C-DR                   PIC X(06) VALUE ' C-DR '.     
HEMA3 *    05  MSG-BAT-NO                 PIC X(06) VALUE 'BAT-NO'.             
HEMA3 *    05  MSG-WITH                   PIC X(06) VALUE ' WITH '.             
HEMA3 *    05  MSG-SYSTEM                 PIC X(06) VALUE 'SYSTEM'.             
           05  MSG-GL-NO                  PIC X(06) VALUE ' GL-NO'.     
HEMA3 *    05  MSG-STATE                  PIC X(06) VALUE 'STATE '.             
HEMA3 *    05  MSG-EXCISE                 PIC X(06) VALUE 'EXCISE'.             
HEMA3 *    05  MSG-CITY                   PIC X(06) VALUE 'CITY  '.             
HEMA3 *    05  MSG-OTHER                  PIC X(06) VALUE 'OTHER '.             
HEMA3 *    05  MSG-CHANGED                PIC X(06) VALUE 'CHNGED'.             
           05  MSG-AMT                    PIC X(06) VALUE 'AMT...'.     
HEMA3 *    05  MSG-TOM                    PIC X(06) VALUE 'TOM   '.             
HEMA3 *    05  MSG-TOT                    PIC X(06) VALUE 'TOT   '.             
HEMA3 *    05  MSG-JRNL                   PIC X(06) VALUE 'JRNL  '.             
HEMA3 *    05  MSG-POSTED                 PIC X(06) VALUE 'POSTED'.             
HEMA3 *    05  MSG-ERROR-IN-CASH-DR       PIC X(13)                             
HEMA3 *        VALUE 'ERROR CASH DR'.                                           
HEMA3 *    05  MSG-ERROR-IN-CASH-CR       PIC X(13)                             
HEMA3 *        VALUE 'ERROR CASH CR'.                                           
HEMA3 *    05  MSG-ERROR-IN-AR-DR         PIC X(13)                             
HEMA3 *        VALUE 'ERROR A/R DR '.                                           
HEMA3 *    05  MSG-ERROR-IN-AR-CR         PIC X(13)                             
HEMA3 *        VALUE 'ERROR A/R CR '.                                           
HEMA3 *    05  MSG-ERROR-IN-GL-DR         PIC X(13)                             
HEMA3 *        VALUE 'ERROR G/L DR '.                                           
HEMA3 *    05  MSG-ERROR-IN-GL-CR         PIC X(13)                             
HEMA3 *        VALUE 'ERROR G/L CR '.                                           
HEMA3 *    05  MSG-ERROR-IN-CKI-DR        PIC X(13)                             
HEMA3 *        VALUE 'ERROR CKI DR '.                                           
HEMA3 *    05  MSG-ERROR-IN-CKI-CR        PIC X(13)                             
HEMA3 *        VALUE 'ERROR CKI CR '.                                           
           05  MSG-AND-POSTED-TO          PIC X(13)                     
               VALUE 'AND POSTED TO'.                                   
HEMA3 *    05  MSG-POSTED-TO              PIC X(13)                             
HEMA3 *        VALUE 'POSTED TO    '.                                           
HEMA3 *    05  MSG-ACASH.                                                       
HEMA3 *        10  MSG-ACASH-GL-NO       PIC 999.9999.                          
HEMA3 *        10  FILLER                PIC X(5) VALUE ' GLNO'.                
HEMA3 *    05  MSG-CLR-CASH.                                                    
HEMA3 *        10  MSG-CLR-CASH-GL-NO    PIC 999.9999.                          
HEMA3 *        10  FILLER                PIC X(5) VALUE '.000 '.                
HEMA3 *    05  MSG-CLR-PST-ER.                                                  
HEMA3 *        10  MSG-CLR-PST-ER-GL-NO  PIC 999.9999.                          
HEMA3 *        10  FILLER                PIC X(5) VALUE '.000 '.                
HEMA3 *    05  MSG-CLR-PST-ER.                                                  
HEMA3 *        10  MSG-CLR-PST-ER-GL-NO  PIC 999.9999.                          
HEMA3 *        10  FILLER                PIC X(5) VALUE '.000 '.                
HEMA3 *    05  MSG-184-20-000             PIC X(13)                             
HEMA3 *        VALUE '184.20.000   '.                                           
           05  MSG-184-24-000             PIC X(13)                     
               VALUE '184.24.000   '.                                   
HEMA3 *    05  MSG-142-NOT-REFERENCED.                                          
HEMA3 *        10  FILLER                      PIC X(04)   VALUE '142.'.        
HEMA3 *        10  MSG-142-MINOR-NO            PIC 9(04).                       
HEMA3 *        10  FILLER                      PIC X(15)                        
HEMA3 *        VALUE ' NOT REFERENCED'.                                         
HEMA3 *    05  MSG-NO-GL-CNTRL-ACCT.                                            
HEMA3 *        10  FILLER                      PIC X(23)                        
HEMA3 *            VALUE 'GENERAL LEDGER ACCOUNT '.                             
HEMA3 *        10  MSG-NO-GL-CNTRL-GL-NO       PIC X(10).                       
HEMA3 *        10  FILLER                      PIC X(29)                        
HEMA3 *            VALUE ' HAS INVALID CONTROL ACCOUNT '.                       
HEMA3 *        10  FILLER                      PIC X(17)   VALUE SPACES.        
HEMA3 *    05  MSG-TOO-MANY-CNTRL-ACCT.                                         
HEMA3 *        10  FILLER                      PIC X(23)                        
HEMA3 *            VALUE 'GENERAL LEDGER ACCOUNT '.                             
HEMA3 *        10  MSG-TOO-MANY-CNTRL-GL-NO    PIC X(10).                       
HEMA3 *        10  FILLER                      PIC X(38)                        
HEMA3 *            VALUE 'HAS OVER 10 LEVELS OF CONTROL ACCOUNTS'.              
HEMA3 *        10  FILLER                      PIC X(08)   VALUE SPACES.        
HEMA3 *    05  MSG-ALTERED-NEGATIVE-TAXES      PIC X(45)                        
HEMA3 *        VALUE 'NEGATIVE TAXES, HAVE BEEN CHANGED TO POSITIVE'.           
           05  MSG-TAXES-GREATER-AMT-POSTED    PIC X(45)                
               VALUE 'TAXES WERE GREATER THAN THE AMOUNT POSTED    '.   
HEMA3 *    05  MSG-IGNORED-ANY-TAX-DATA   PIC X(21)                             
HEMA3 *        VALUE 'IGNORED ANY TAX DATA '.                                   
HEMA3 *    05  MSG-FOR-TAXES-NOT-USED     PIC X(21)                             
HEMA3 *        VALUE 'FOR TAXES NOT USED   '.                                   
HEMA3 *    05  MSG-WASH-BUCKETS           PIC X(79)                             
HEMA3 *        VALUE 'WASH BUCKETS   '.                                         
HEMA3 *    05  MSG-ACCUMULATED-WASH       PIC X(79)                             
HEMA3 *        VALUE 'ACCUMULATED WASH'.                                        
HEMA3 *    05  MSG-CORRECT-GTH-NOT-FOUND  PIC X(30)                             
HEMA3 *        VALUE 'CORRECT GTH SEGMENT NOT FOUND '.                          
HEMA3 *    05  MSG-EXTRACT-JRNL-NO-WASH   PIC X(30)                             
HEMA3 *        VALUE 'EXTRACT JRNLS DO NOT WASH     '.                          
HEMA2 *    05  MSG-WASH-AREA-NO-WASH      PIC X(30)                             
HEMA2 *        VALUE 'WASH AREA TOTALS DO NOT WASH  '.                          
           05  MSG-INVALID-SORT-KEY       PIC X(30)                     
               VALUE 'INVALID SORT KEY              '.                  
HEMA3 *    05  MSG-BATCH-POSTED-WITH-CASH PIC X(30)                             
HEMA3 *        VALUE 'BATCH POSTED WITH CASH        '.                          
HEMA3 *    05  MSG-POSSIBLE-TAX-ERROR     PIC X(30)                             
HEMA3 *        VALUE 'POSSIBLE TAX ERROR            '.                          
           05  MSG-INVALID-GL-ACCT        PIC X(30)                     
               VALUE  'INVALID GL ACCOUNT           '.                  
HEMA3 *    05  MSG-TABLE-GL-NO-NOT-AVAILABLE PIC X(30)                          
HEMA3 *        VALUE 'TABLE GL-NO NOT AVAILABLE     '.                          
HEMA3 *    05  MSG-JRNLS-NO-WASH          PIC X(30)                             
HEMA3 *        VALUE 'ACCUMULATED JRNLS DO NOT WASH '.                          
HEMA3 *    05  MSG-INVALID-CONTROL-ACCT   PIC X(30)                             
HEMA3 *        VALUE 'INVALID CONTROL ACCOUNT       '.                          
HEMA3 *    05  MSG-EXCESSIVE-CNTRL-ACCTS  PIC X(30)                             
HEMA3 *        VALUE 'CONTROL ACCTS OVER 10 DEEP    '.                          
HPCCDM*    EJECT                                                                
       01  WS-FCA07-RECORD-CNT           PIC S9(9)  VALUE ZERO.         
       01  WS-FCA10-RECORD-CNT           PIC S9(9)  VALUE ZERO.         
HEMA1 *01  WS-FCA04-RECORD-CNT           PIC S9(9)  VALUE ZERO.                 
      *                                                                         
TP8358 01  WS-DEFAULT-RPT1-TITLE         PIC X(26)  VALUE               
TP8358     'SOUTH CAROLINA ELEC. & GAS'.                                
TP8358*                                                                         
TP8358 01  WS-DEFAULT-RPT1-HEAD1         PIC X(25)  VALUE               
TP8358     'DAILY TRANSACTION JOURNAL'.                                 
TP8358*                                                                         
TP8358 01  WS-DEFAULT-RPT-HEAD2.                                        
TP8358     05  FILLER                    PIC X(28)  VALUE               
TP8358         '              CURRENT AS OF '.                          
TP8358     05  WS-DEFAULT-RPT-DT         PIC X(08).                     
TP8358     05  FILLER                    PIC X(14)  VALUE SPACES.       
TP8358*                                                                         
TP8358 01  WS-PW-HEADER-LINE1.                                          
TP8358     05  FILLER                    PIC X(01)     VALUE SPACES.    
TP8358     05  FILLER                    PIC X(08)     VALUE 'PCSCA123'.
TP8358     05  FILLER                    PIC X(44)     VALUE SPACES.    
TP8358     05  P-RPT1-COMP-NAME          PIC X(26).                     
TP8358     05  FILLER                    PIC X(35)     VALUE SPACES.    
TP8358     05  FILLER                    PIC X(10)     VALUE            
TP8358                                             'RUN-DATE: '.        
TP8358     05  P-RPT1-RUN-DATE           PIC X(08).                     
TP8358*                                                                         
TP8358 01  WS-PW-HEADER-LINE2.                                          
TP8358     05  FILLER                    PIC X(01)     VALUE SPACES.    
TP8358     05  FILLER                    PIC X(06)     VALUE 'DATE: '.  
TP8358     05  P-RPT1-DATE               PIC X(08).                     
TP8358     05  FILLER                    PIC X(39)     VALUE SPACES.    
TP8358     05  P-RPT1-HEAD1              PIC X(25).                     
TP8358     05  FILLER                    PIC X(35)     VALUE SPACES.    
TP8358     05  FILLER                    PIC X(10)     VALUE            
TP8358                                             'RUN-TIME: '.        
TP8358     05  P-RPT1-RUN-TIME           PIC X(08).                     
TP8358*                                                                         
TP8358 01  WS-PW-HEADER-LINE3.                                          
TP8358     05  FILLER                    PIC X(41)     VALUE SPACES.    
TP8358     05  P-RPT1-HEAD2              PIC X(50).                     
TP8358     05  FILLER                    PIC X(27)     VALUE SPACES.    
TP8358     05  FILLER                    PIC X(08)     VALUE 'PAGE:   '.
TP8358     05  P-RPT1-PAGE-NO            PIC ZZ,ZZ9.                    
TP8358*                                                                         
HEMA3 *01  WS-ALTERED-JRNL-LINE.                                                
HEMA3 *    05  FILLER                    PIC X(43)                              
HEMA3 *        VALUE '******* THE NEXT JOURNAL WAS ALTERED BY EDP'.             
HEMA3 *    05  FILLER                    PIC X(89)     VALUE SPACES.            
       01  WS-DAILY-TRAN-JRNL-REPORT.                                   
           05  WS-DAILY-TRAN-JRNL-HDR-2.                                
               10  FILLER                    PIC X(01)     VALUE SPACES.
               10  FILLER                    PIC X(15)                  
                   VALUE 'LOCAL OFFICE:  '.                             
               10  P-LOCAL-OFFICE-DTJ        PIC X(03).                 
               10  FILLER                    PIC X(03)     VALUE SPACES.
               10  P-LOCAL-OFFICE-NAME-DTJ   PIC X(25).                 
               10  FILLER                    PIC X(85)     VALUE SPACES.
           05  WS-DAILY-TRAN-JRNL-HDR-3.                                
TP5678         10  FILLER                    PIC X(28)                  
TP5678             VALUE '  ACCOUNT      DATE  ...... '.                
TP5678         10  FILLER                    PIC X(17)                  
TP1313             VALUE 'TRAN-ID ..... ***'.                           
TP5678         10  FILLER                    PIC X(43)                  
T11663            VALUE '       AMOUNT   SOURCE OF TARGET   AMOUNT  '.  
TP5678         10  FILLER                    PIC X(44)                  
ITEMID         VALUE ' DR A/R.....ACCOUNT.............ITEM........'.    
           05  WS-DAILY-TRAN-JRNL-HDR-4.                                
TPR960         10  FILLER                    PIC X(28)                  
TPR960             VALUE '   NO.         LAST  OP-ID '.                 
TP5678         10  FILLER                    PIC X(18)                  
TP1313             VALUE ' FRM C   TRAN JRNL'.                          
ITEMID         10  FILLER                    PIC X(45)                  
ITEMID         VALUE 'DES  ENTERED   .FUNDS..  FUNDS    POSTED   CR'.   
               10  FILLER                    PIC X(41)                  
T11663        VALUE ' AGE  RCVBL-BAL RCVBL-BAL   ID-NO END-BAL'.        
           05  WS-DAILY-TRAN-JRNL-HDR-5.                                
TP5678         10  FILLER                    PIC X(20)     VALUE SPACES.
               10  FILLER                    PIC X(33)                  
T11663             VALUE ' BT-NO   LOC D   CODE CODE***'.               
               10  FILLER                    PIC X(29)                  
                   VALUE '***********************    FI'.               
               10  FILLER                    PIC X(40)                  
                   VALUE 'LE MAINTENANCE CHANGE DATA   ***********'.    
T11663         10  FILLER                    PIC X(11)                  
                   VALUE '***********'.                                 
           05  WS-DAILY-TRAN-JRNL-DETAIL.                               
               10  P-TENANT-INFO-DTJ.                                   
090889             15  P-ACCT-NO-DTJ            PIC X(13).              
                   15  FILLER                   PIC X(01)  VALUE SPACES.
TP5678             15  P-DATE-DTJ               PIC X(05).              
                   15  FILLER                   PIC X(01)  VALUE SPACES.
               10  P-TRAN-ID-DTJ.                                       
                   15  P-USER-ID-BATCH-NO-DTJ   PIC X(07).              
                   15  FILLER                   PIC X(01)  VALUE SPACES.
                   15  P-FROM-LOC-DTJ           PIC X(03).              
                   15  FILLER                   PIC X(01)  VALUE SPACES.
3600               15  P-CASH-DRAWER-DTJ        PIC 9(04).              
                   15  FILLER                   PIC X(01)  VALUE SPACES.
               10  P-TRAN-CODE-DTJ          PIC X(04).                  
               10  FILLER                   PIC X(01)  VALUE SPACES.    
TP5678         10  P-JRNL-CODE-DTJ          PIC 9(03).                  
               10  P-VARIABLE-FORM-INFO-DTJ.                            
TP1313             15  P-JRNL-DESC-DTJ          PIC X(03).              
                   15  P-AMOUNT-ENTERED-DTJ     PIC -ZZZZZZZ.99.        
                   15  P-AMOUNT-ENTERED-RED-DTJ                         
                       REDEFINES P-AMOUNT-ENTERED-DTJ  PIC X(10).       
                   15  FILLER                   PIC X(01)  VALUE SPACES.
TP5678             15  P-SOURCE-OF-FUNDS-DTJ    PIC X(08).              
                   15  P-SOURCE-OF-FUNDS-DTJ-RED                        
                       REDEFINES P-SOURCE-OF-FUNDS-DTJ.                 
                       20  P-NON-142-ACCT-DTJ        PIC 999.9999.      
TP5678             15  FILLER                   PIC X(01)  VALUE SPACES.
TP5678             15  P-TARGET-OF-FUNDS-DTJ    PIC X(08).              
TP5678             15  P-TARGET-OF-FUNDS-DTJ-RED                        
TP5678                 REDEFINES P-TARGET-OF-FUNDS-DTJ.                 
TP5678                 20  P-NON-142-TGT-DTJ        PIC 999.9999.       
                   15  P-AMOUNT-POSTED-DTJ      PIC -ZZZZZZZ.99.        
TP5678             15  FILLER                   PIC X(01)  VALUE SPACES.
ITEMID             15  P-DR-CR-DTJ              PIC X(01).              
                   15  FILLER                   PIC X(01)  VALUE SPACES.
                   15  P-AGE-DTJ                PIC X(02).              
                   15  P-ACCT-RCVBL-END-BAL-DTJ PIC ZZZZZZZ.99-.        
090889             15  P-DETAIL-END-AR-BAL-DTJ  PIC ZZZZZ.99-.          
ITEMID             15  P-ITEM-ID-NO-DTJ         PIC ZZZZZZZZ.           
090889             15  P-DETAIL-END-BAL-DTJ     PIC ZZZZZZZ.99-.        
           05  WS-DETAIL-RECORD-103-DTJ.                                
               10  FILLER                    PIC X(06)   VALUE 'XFR.. '.
               10  FILLER                    PIC X(54).                 
               10  P-TRANSFER-FROM-TO-DTJ.                              
                   15  P-ACCT-LOC-OFF-DTJ        PIC X(03).             
                   15  FILLER                    PIC X(01)   VALUE '-'. 
090889             15  P-XFR-ACCT-NO-DTJ         PIC 9(13).             
090889         10  FILLER                    PIC X(11)   VALUE SPACES.  
      * NOTE - DETAIL 105 JOURNAL SHOULD LOOK LIKE ARM SCREEN                   
HEMA3 *    05  WS-DETAIL-RECORD-105-DTJ.                                        
HEMA3 *        10  FILLER                    PIC X(06)   VALUE 'XFR.. '.        
HEMA3 *        10  FILLER                    PIC X(54).                         
           05  WS-DETAIL-RECORD-113-DTJ.                                
               10  P-DESC-IS-WAS-113-DTJ     PIC X(03).                 
               10  FILLER                    PIC X(01)     VALUE SPACES.
               10  P-FIELD-DESC-113-DTJ      PIC X(30).                 
           05  WS-DETAIL-RECORD-113-1-DTJ.                              
TP1313         10  P-IS-WAS-WORD-113-DTJ     PIC X(03).                 
               10  FILLER                    PIC X(04)    VALUE ' 00-'. 
               10  P-AR-00-DAY-VALUE-113-DTJ PIC ZZZZZZZ.99.            
               10  FILLER                    PIC X(04)    VALUE ' 30-'. 
               10  P-AR-30-DAY-VALUE-113-DTJ PIC ZZZZZZZ.99.            
               10  FILLER                    PIC X(54)    VALUE SPACES. 
           05  WS-DETAIL-RECORD-113-2-DTJ.                              
               10  FILLER                    PIC X(05)    VALUE SPACES. 
               10  FILLER                    PIC X(04)    VALUE ' 60-'. 
               10  P-AR-60-DAY-VALUE-113-DTJ PIC ZZZZZZZ.99.            
               10  FILLER                    PIC X(04)    VALUE ' 90-'. 
               10  P-AR-90-DAY-VALUE-113-DTJ PIC ZZZZZZZ.99.            
               10  FILLER                    PIC X(05)    VALUE ' TOT-'.
               10  P-TOT-AGED-113-DTJ        PIC ZZZZZZZ.99.            
               10  FILLER                    PIC X(01)    VALUE SPACES. 
               10  P-ACCT-AR-BAL-113-DTJ     PIC ZZZZZZZ.99.            
               10  FILLER                    PIC X(28)    VALUE SPACES. 
       01  WS-STATUS-KEY-ERROR-LINE.                                    
           05  FILLER                        PIC X(01)                  
               VALUE '*'.                                               
           05  P-STATUS-KEY-ERROR-MSG        PIC X(30).                 
           05  FILLER                        PIC X(15)                  
               VALUE '  STATUS KEY = '.                                 
           05  P-STATUS-KEY                  PIC X(02).                 
           05  FILLER                        PIC X(22)                  
               VALUE '   PARAGRAPH NUMBER = '.                          
           05  P-PARAGRAPH-NUMBER            PIC 9(04).                 
           05  FILLER                        PIC X(58)     VALUE SPACES.
      *                                                                         
TP8074 01  WS-GL-ERROR-MSG.                                             
TP8074     05  FILLER                        PIC X(03)     VALUE 'GL '. 
TP8074     05  P-GL-ACCT-NO                  PIC X(08).                 
TP8074     05  FILLER                        PIC X(06)     VALUE        
TP8074                                                  ' COMP '.       
TP8074     05  P-GL-COMP-NO                  PIC X(02).                 
TP8074     05  FILLER                        PIC X(08)     VALUE        
TP8074                                                  ' OFFICE '.     
TP8074     05  P-GL-LOC-OFF-NO               PIC X(03).                 
      *                                                                         
TP8074 01  WS-UNPACK-GL-ACCT-NO              PIC 9(03)V9(04).           
TP8074 01  WS-GL-ACCT-NO-UNPACKED REDEFINES WS-UNPACK-GL-ACCT-NO.       
TP8074     05  WS-GL-1ST-THREE-AN            PIC X(03).                 
TP8074     05  FILLER                        PIC X(01).                 
TP8074     05  WS-GL-2ND-FOUR-AN             PIC X(04).                 
TP8074*                                                                         
TP8074 01  WS-GL-ACCT-NO-DISP.                                          
TP8074     05  WS-GL-1ST-THREE-DISP          PIC X(03).                 
TP8074     05  FILLER                        PIC X(01)    VALUE '.'.    
TP8074     05  WS-GL-2ND-FOUR-DISP           PIC X(04).                 
      *                                                                         
       01  WS-PROGRAM-INFO-LINE.                                        
           05  FILLER                        PIC X(10)                  
               VALUE '**********'.                                      
           05  P-ABEND-MESSAGE               PIC X(122).                
HEMA2 *COPY CJF00001.                                                           
HEMA3 *COPY CJF00002.                                                           
       COPY CJF00101.                                                           
       COPY CJF00102.                                                           
       COPY CJF00103.                                                           
       COPY CJF00104.                                                           
       COPY CJF00105.                                                           
       COPY CJF00113.                                                           
       COPY CJF00201.                                                           
T24436* THIS INCLUDE IS RENAMED FOR UNIQUE DEFINITION OF ABEND-FUNCTION         
T24436* AND INCLUDED COPYBOOK CWS00010.                                         
T24436 01  ABEND-FUNCTION-1.                                            
           05  WS-ABEND-SPACE             PIC X(02) VALUE SPACE.        
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC       PIC 99.                       
       01  WS-END                         PIC X(40)                     
           VALUE 'WORKING STORAGE FOR PCSCA123 ENDS HERE '.             
HPCCDM*    EJECT                                                                
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
           PERFORM 0500-INITIAL-DW-GEN-LED     THRU 0500-EXIT.          
      *                                                                         
T24436     MOVE PROGRAM-NAME                   TO                       
T24436                                         WS-CPD00061-CALLING-PGM. 
T24436     MOVE SPACES                         TO  ABEND-FUNCTION.      
T24436     CALL SCSCB061  USING   WS-GL-ACCT-NAME,                      
T24436                            WS-GL-ACCT-MAJOR-FIELDS,              
T24436                            WS-VALID-COMPANY-NOS,                 
T24436                            WS-GL-NAME-INFO,                      
T24436                            WS-GL-ACCT-NO-TABLE,                  
T24436                            WS-CPD00061-CALLING-PGM,              
T24436                            ABEND-FILE,                           
T24436                            RS-RETURN-CODE.                       
T24436                                                                  
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
T24436     END-IF.                                                      
      *                                                                         
      *. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .            
      *      ACCUMULATE INDIRECT TRANSACTION JOURNALS TO                        
      *      WS-FCA09-DETAIL-TABLE                                              
      *. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .            
           PERFORM 1000-PROCESS-ESDS-FILE      THRU 1000-EXIT           
               UNTIL WS-THIS-THE-LAST-ESDS-RECORD.                      
      *. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .            
      *      LOAD SUMMARY JOURNALS TO THE JOURNAL TRAN FILE- CA04               
      *      FROM THE WS-FIOCA09-DETAIL-TABLE                                   
      *. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .            
HEMA1 *    PERFORM 2200-READ-WS-FCA09-DETAIL   THRU 2200-EXIT                   
HEMA1 *     VARYING  WS-CA09-DET-INDX FROM 1 BY 1                               
HEMA1 *     UNTIL  WS-CA09-DET-INDX > WS-CA09-DET-COUNT.                        
      *. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .            
      *      LOAD JOURNAL TRANSACTION TYPES 200 - 211 TO CASH FL CA08           
      *. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .            
HEMA1 *    PERFORM 7080-READ-FIRST-FCSCA04     THRU 7080-EXIT.                  
HEMA1 *    IF WS-FCA04-EMPTY-FLG = 'N'                                          
HEMA1 *      PERFORM 4000-GEN-LEDGER-TRAN-JRNL THRU 4000-EXIT                   
HEMA1 *          UNTIL WS-THIS-IS-LAST-SEQ-CA04-REC                             
HEMA1 *    END-IF.                                                              
HEMA2 *    PERFORM 6000-WASH-BUCKET-CLEAR-RTNE THRU 6000-EXIT.                  
           PERFORM 8002-WRITE-FCSCA09          THRU   8002-EXIT         
              VARYING   WS-CA09-DET-INDX  FROM  1 BY 1                  
              UNTIL  WS-CA09-DET-INDX > WS-CA09-DET-COUNT.              
121204*                                                                         
           PERFORM 2999-WRITE-END-CONTROLS      THRU 2999-EXIT.         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
           DISPLAY 'PCSCA123 COMPLETED'.                                
TP2056     STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
       0100-INITIALIZATION.                                             
      *                                                                         
TP8358     ACCEPT WS-CURRENT-TIME FROM TIME.                            
TP8358     MOVE WS-HH                  TO WS-RT-HH.                     
TP8358     MOVE WS-MM                  TO WS-RT-MM.                     
TP8358     MOVE WS-SS                  TO WS-RT-SS.                     
TP8358     MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME.              
TP8358*                                                                         
TP8358     ACCEPT WS-CURRENT-DATE FROM DATE.                            
TP8358     MOVE WS-CY                  TO WS-DATE-DISPLAY-YY.           
TP8358     MOVE WS-CM                  TO WS-DATE-DISPLAY-MM.           
TP8358     MOVE WS-CD                  TO WS-DATE-DISPLAY-DD.           
TP8358     MOVE WS-DATES-DISPLAY       TO P-RPT1-RUN-DATE.              
      *                                                                         
PCR647     PERFORM 7600-START-FCSJC01              THRU 7600-EXIT.      
PCR647     PERFORM 7610-READ-FCSJC01               THRU 7610-EXIT       
PCR647         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
PCR647         OR END-OF-SYSIPT.                                        
PCR647     EVALUATE TRUE                                                
PCR647        WHEN END-OF-SYSIPT                                        
PCR647           DISPLAY ' '                                            
PCR647           DISPLAY '**  PCSCA123 PROCESSING ERROR  **'            
PCR647           DISPLAY '**    NO ACTIVE REVENUE MONTH IN COMMON'      
PCR647           DISPLAY '**  PROCESSING TERMINATED **'                 
PCR647           PERFORM 9900-ABEND  THRU  9900-EXIT                    
PCR647        WHEN WS-REVENUE-MONTH-PARM NOT NUMERIC                    
PCR647           DISPLAY ' '                                            
PCR647           DISPLAY '**  PCSCA123 PROCESSING ERROR  **'            
PCR647           DISPLAY '**    REVENUE MONTH PARM NOT NUMERIC'         
PCR647           DISPLAY '**  PROCESSING TERMINATED  **'                
PCR647           PERFORM 9900-ABEND  THRU  9900-EXIT                    
PCR647        WHEN OTHER                                                
PCR647           PERFORM 7611-CLOSE THRU 7611-EXIT                      
PCR647           MOVE WS-REVENUE-MONTH-PARM TO WS-REVENUE-MONTH-COMMON  
PCR647     END-EVALUATE.                                                
                                                                        
T30899     MOVE WS-COMPANY-NO                 TO C8-COMPANY-NO.         
T30899     MOVE WS-DATABASE                   TO C8-DELINQ-CD.          
T30899     PERFORM 7550-SELECT-DATABASE       THRU 7550-EXIT.           
T30899     IF C8-DELINQ-VALUE = WS-SEB                                  
T30899        MOVE WS-YES                     TO WS-SEB-DATABASE-SW     
T30899     END-IF.                                                      
T30899                                                                  
           OPEN OUTPUT FCSPT33-FILE.                                    
           OPEN INPUT  FCSCA07-FILE.                                    
           IF FCA07-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'ERROR.  STATUS KEY 7 IS ' TO P-STATUS-KEY-ERROR-MSG
               MOVE WS-FCA07-STATUS TO P-STATUS-KEY                     
               MOVE WS-STATUS-KEY-ERROR-LINE TO P-ABEND-MESSAGE         
               PERFORM 8900-PRINT-PROGRAM-INFO-LINE THRU 8900-EXIT      
112704         PERFORM 9900-ABEND THROUGH 9900-EXIT
           END-IF.                    
HEMA1 *    OPEN I-O FCSCA04-FILE.                                               
HEMA1 *    IF FCA04-SUCCESSFUL                                                  
HEMA1 *        NEXT SENTENCE                                                    
HEMA1 *    ELSE                                                                 
HEMA1 *        MOVE 'ERROR.  STATUS KEY 4 IS ' TO P-STATUS-KEY-ERROR-MSG        
HEMA1 *        MOVE WS-FCA04-STATUS TO P-STATUS-KEY                             
HEMA1 *        MOVE WS-STATUS-KEY-ERROR-LINE TO P-ABEND-MESSAGE                 
HEMA1 *        PERFORM 8900-PRINT-PROGRAM-INFO-LINE THRU 8900-EXIT              
HEMA1 *        PERFORM 9900-ABEND THROUGH 9900-EXIT.                            
HEMA2 *    OPEN I-O FCSCA08-FILE.                                               
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        MOVE 'ERROR.  STATUS KEY 8 IS ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        MOVE WS-FCA08-STATUS TO P-STATUS-KEY                             
HEMA2 *        MOVE WS-STATUS-KEY-ERROR-LINE TO P-ABEND-MESSAGE                 
HEMA2 *        PERFORM 8900-PRINT-PROGRAM-INFO-LINE THRU 8900-EXIT              
HEMA2 *        PERFORM 9900-ABEND THROUGH 9900-EXIT.                            
HEMA3 *    OPEN I-O FCSCA09-FILE.                                               
HEMA3      OPEN OUTPUT FCSCA09-FILE.                                    
           IF FCA09-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'ERROR.  STATUS KEY 9 IS ' TO P-STATUS-KEY-ERROR-MSG
               MOVE WS-FCA09-STATUS TO P-STATUS-KEY                     
               MOVE WS-STATUS-KEY-ERROR-LINE TO P-ABEND-MESSAGE         
               PERFORM 8900-PRINT-PROGRAM-INFO-LINE THRU 8900-EXIT      
112704         PERFORM 9900-ABEND THROUGH 9900-EXIT
           END-IF.                    
      *                                                                         
CBSI       OPEN OUTPUT FCSRP132-FILE.                                   
CBSI       IF FRP132-SUCCESSFUL                                         
CBSI           NEXT SENTENCE                                            
CBSI       ELSE                                                         
CBSI           MOVE 'ERROR. STATUS KEY 132 IS 'TO P-STATUS-KEY-ERROR-MSG
CBSI           MOVE WS-FRP132-STATUS TO P-STATUS-KEY                    
CBSI           MOVE WS-STATUS-KEY-ERROR-LINE TO P-ABEND-MESSAGE         
CBSI           PERFORM 8900-PRINT-PROGRAM-INFO-LINE THRU 8900-EXIT      
CBSI           PERFORM 9900-ABEND THROUGH 9900-EXIT
           END-IF.                    
      *                                                                         
           OPEN OUTPUT FCSCA10-FILE.                                    
112704     IF FCA10-SUCCESSFUL                                          
112704         NEXT SENTENCE                                            
112704     ELSE                                                         
112704         MOVE 'ERROR. STATUS KEY 10 IS ' TO P-STATUS-KEY-ERROR-MSG
112704         MOVE WS-FCA10-STATUS TO P-STATUS-KEY                     
112704         MOVE WS-STATUS-KEY-ERROR-LINE TO P-ABEND-MESSAGE         
112704         PERFORM 8900-PRINT-PROGRAM-INFO-LINE THRU 8900-EXIT      
112704         PERFORM 9900-ABEND THROUGH 9900-EXIT
           END-IF.                    
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT       
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE
           END-IF.           
      *                                                                         
TP8358     MOVE WS-INPUT-DATE(3:2)     TO WS-DATE-DISPLAY-YY.           
TP8358     MOVE WS-INPUT-DATE(6:2)     TO WS-DATE-DISPLAY-MM.           
TP8358     MOVE WS-INPUT-DATE(9:2)     TO WS-DATE-DISPLAY-DD.           
TP8358     MOVE WS-DATES-DISPLAY       TO P-RPT1-DATE,                  
TP8358                                    WS-DEFAULT-RPT-DT.            
      *                                                                         
           PERFORM 0110-PROCESS-BEGIN-REC THRU 0110-EXIT.               
           SET WS-INDEX-CDT TO 1.                                       
           PERFORM 0151-INIT-CD-TABLE       THRU 0151-EXIT              
                 VARYING WS-INDEX-CDT  FROM 1 BY 1                      
                  UNTIL WS-INDEX-CDT GREATER THAN 1000.                 
       0100-EXIT.                                                       
           EXIT.                                                        
       0110-PROCESS-BEGIN-REC.                                          
            PERFORM 7050-READ-FCSCA07      THRU 7050-EXIT.              
            IF FCA07-SUCCESSFUL                                         
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '****************************************'       
               DISPLAY '* MISSING INPUT FILE FCA07 FOR PCSCA123*'       
               DISPLAY '*     PCSCA123 TERMINATED              *'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND    THRU 9900-EXIT
            END-IF.                    
      *                                                                         
           IF  E-FCA07-BEGIN-KEY = LOW-VALUES                           
              SUBTRACT 1 FROM WS-FCA07-RECORD-CNT                       
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '* PCSCA123 PROCESSING ERROR            *'        
              DISPLAY '* FIRST RECORD IS NOT A CONTROL RECORD *'        
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND    THRU 9900-EXIT
           END-IF.                     
           IF E-FCA07-BEGIN-CREATE-DATE = WS-INPUT-DATE                 
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '*   ' WS-PGRMNAME ' PROCESSING ERROR'           
               DISPLAY '*   FCSCA07 CREATE DATE NOT = PARAMETER DATE'   
               DISPLAY '*   FCSCA07 DATE   = ' E-FCA07-BEGIN-CREATE-DATE
               DISPLAY '*   PARAMETER DATE = ' WS-INPUT-DATE            
               DISPLAY '*   PROCESSING TERMINATED'                      
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND   THRU 9900-EXIT
           END-IF.                     
           PERFORM 2000-WRITE-BEGIN-CONTROLS    THRU 2000-EXIT.         
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0151-INIT-CD-TABLE.                                              
           MOVE SPACES TO WS-CASH-COMPANY-NO-CDT   (WS-INDEX-CDT)       
                          WS-CASH-LOCAL-OFFICE-CDT (WS-INDEX-CDT)       
                          WS-CASH-REPORT-NO-CDT    (WS-INDEX-CDT)       
                          WS-DATE-CASH-REPORT-CDT  (WS-INDEX-CDT).      
           MOVE ZEROES TO WS-CASH-DRAWER-ID-CDT    (WS-INDEX-CDT)       
                          WS-CASH-DR-TOTAL-CDT     (WS-INDEX-CDT)       
                          WS-CASH-CR-TOTAL-CDT     (WS-INDEX-CDT)       
                          WS-AR-DR-TOTAL-CDT       (WS-INDEX-CDT)       
                          WS-AR-CR-TOTAL-CDT       (WS-INDEX-CDT)       
                          WS-GL-DR-TOTAL-CDT       (WS-INDEX-CDT)       
                          WS-GL-CR-TOTAL-CDT       (WS-INDEX-CDT)       
                          WS-CKI-DR-TOTAL-CDT      (WS-INDEX-CDT)       
                          WS-CKI-CR-TOTAL-CDT      (WS-INDEX-CDT).      
      *                                                                         
       0151-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  0500-INITIAL-DW-GEN-LED.                                      *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       0500-INITIAL-DW-GEN-LED.                                         
T16880     PERFORM 8999-SELECT-COUNT-GL-ACCOUNT THRU 8999-EXIT.         
T16880     IF WS-GL-ACCT-COUNT > WS-MAX-FIOCA09-ENTRIES                 
T16880       DISPLAY 'GL-ACCOUNT-TABLE HAS ' WS-GL-ACCT-COUNT ' ENTRIES'
T16880       DISPLAY 'WS-FIOCA09 HAS ONLY ' WS-MAX-FIOCA09-ENTRIES      
T16880       DISPLAY 'ENTRIES IN THE OCCURS CLAUSE'                     
T16880       DISPLAY 'FIND !!!!!NOTE!!!!! IN THE SOURCE CODE AND DO AS' 
T16880       DISPLAY 'INSTRUCTED'                                       
T16880       PERFORM 9900-ABEND THRU 9900-EXIT                          
T16880     END-IF                                                       
           PERFORM 7100-OPEN-GL-ACCOUNT  THRU  7100-EXIT.               
           PERFORM 7110-FETCH-GL-ACCOUNT THRU  7110-EXIT.               
           MOVE HIGH-VALUES TO WS-FIOCA09-TABLE.                        
           SET WS-CA09-INDX TO 1.                                       
           PERFORM 0510-LOAD-FCSCA09-TABLE THRU 0510-EXIT               
090889         UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
           PERFORM 7120-CLOSE-GL-ACCOUNT   THRU  7120-EXIT.             
       0500-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  0510-LOAD-FCSCA09-FILE .                                      *        
      *  LOADS THE GEN-LED SUMMARY TABLE FROM THE GL_ACCOUNT TABLE     *        
      *  ** ONLY LOAD DATA FROM DETAILS RECORDS (GL-GL-DTL-CNTL-IND =D)*        
      *  ** CONTROL RECORDS HAVE A 'C' IN GL-GL-DTL-CNTL-IND           *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       0510-LOAD-FCSCA09-TABLE.                                         
           MOVE GL-COMPANY-NO TO                                        
                WS-FCA09-COMPANY-NO (WS-CA09-INDX).                     
           MOVE GL-GL-ACCT-NO TO                                        
                WS-FCA09-GL-ACCT-NO (WS-CA09-INDX).                     
           MOVE GL-LOCAL-OFFICE TO                                      
                WS-FCA09-LOCAL-OFFICE (WS-CA09-INDX).                   
           MOVE GL-CODE-ACCT-STATUS TO                                  
                WS-FCA09-CODE-ACCT-STATUS (WS-CA09-INDX).               
P00641     MOVE GO-GL-ACCT-NAME-DESC TO                                 
                WS-FCA09-ACCT-DESC (WS-CA09-INDX).                      
           MOVE GO-GL-ACCT-NAME TO                                      
                WS-FCA09-ACCT-NAME (WS-CA09-INDX).                      
           MOVE GL-DATE-LAST-TRANS TO                                   
                WS-FCA09-DATE-LAST-TRANS (WS-CA09-INDX).                
ACT031     MOVE SPACES TO WS-FCA09-UPDATE-CODE-1 (WS-CA09-INDX).        
ACT031     MOVE SPACES TO WS-FCA09-UPDATE-CODE-2 (WS-CA09-INDX).        
           MOVE GL-BEGIN-ACCT-BALANCE TO                                
                WS-FCA09-EXTRACT-BALANCE (WS-CA09-INDX).                
      *                                                                         
           SET WS-CA09-INDX UP BY 1.                                    
      *                                                                         
           PERFORM 7110-FETCH-GL-ACCOUNT THRU 7110-EXIT.                
       0510-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  1000-PROCESS-ESDS-FILE.                                       *        
      *       CONTROLS THE PROCESSING OF THE JOURNAL-EXTRACT-FILE      *        
      *  ONE RECORD AT A TIME.                                         *        
      *       THIS IS THE MAIN DRIVER OF THE PROGRAM                   *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       1000-PROCESS-ESDS-FILE.                                          
           PERFORM 7050-READ-FCSCA07     THRU 7050-EXIT.                
           IF FCA07-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE E-FCA07-GL-ACCT-NO TO WS-ACCT-NO-DISPLAY            
               DISPLAY '********************************************'   
               DISPLAY '*      PROCESSING ERROR IN PCSCA123        *'   
               DISPLAY '* IN-CHK1 = '                                   
                       WS-FCA07-STATUS ' '                              
                       WS-ACCT-NO-DISPLAY                               
               DISPLAY '* LAST RECORD NOT A CONTROL REC IN FCSCA07  *'  
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
           IF E-FCA07-END-KEY = HIGH-VALUES                             
               PERFORM 1900-PROCESS-END-REC     THRU 1900-EXIT          
               GO TO 1000-EXIT
           END-IF.                                         
      *                                                                         
      * CUT CODE PERTAINING TO PROCESSING TYPE 1 RECORDS                        
      *                                                                         
           MOVE E-FCA07-TRAN-DATE TO WS-TRAN-DATE-FCA10.                
           IF E-FCA07-JRNL-SORT-ID EQUAL WS-A                           
               PERFORM 2100-DETAIL-JOURNAL-ROUTINE THRU 2100-EXIT       
           ELSE                                                         
           IF E-FCA07-JRNL-SORT-ID EQUAL WS-B                           
               NEXT SENTENCE                                            
           ELSE                                                         
207006*** ERROR MSGS PASSED FROM PCSCA120 DO NOT LOAD JRNL-SORT-ID:             
207006     IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-00002                     
207006         NEXT SENTENCE                                            
207006     ELSE                                                         
               PERFORM 1100-JRNL-SORT-KEY-ERROR THRU 1100-EXIT
           END-IF
           END-IF
           END-IF.         
       1000-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  1100-JRNL-SORT-KEY-ERROR.                                     *        
      *       EITHER AN INVALID RECORD HAS BEEN FOUND, OR A RECORD IS  *        
      *  OUT OF SEQUENCE.  AN ERROR RECORD IS WRITTEN TO THE           *        
      *  EXCEPTION-FILE                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       1100-JRNL-SORT-KEY-ERROR.                                        
           MOVE E-FCA07-COMPANY-NO         TO E-FCA10-COMPANY-NO.       
           MOVE WS-Z                       TO E-FCA10-REPORT-CENTER.    
           MOVE E-FCA07-TRAN-DATE          TO E-FCA10-EXCEPTION-DATE.   
           MOVE WS-010                     TO E-FCA10-EXCPTN-CATEGORY.  
           MOVE WS-030                     TO E-FCA10-EXCPTN-TYPE.      
           MOVE SPACES                     TO E-FCA10-EXCEPTION-ID.     
           MOVE MSG-INVALID-SORT-KEY       TO E-FCA10-EXCEPTION-DESC.   
           MOVE 1                          TO E-FCA10-LINE-CONTROL.     
           MOVE 4                          TO E-FCA10-FORMAT-ID.        
           MOVE MSG-S-KEY                  TO E-FCA10-FIELD-1-4-DESC.   
           MOVE E-FCA07-JRNL-SORT-ID       TO E-FCA10-FIELD-1-4-DATA.   
           MOVE MSG-T-CODE                 TO E-FCA10-FIELD-2-4-DESC.   
           MOVE E-FCA07-CODE-TERMINAL-TRAN TO E-FCA10-FIELD-2-4-DATA.   
           MOVE MSG-ID                     TO E-FCA10-FIELD-3-4-DESC.   
           MOVE E-FCA07-USER-ID            TO E-FCA10-FIELD-3-4-DATA.   
           MOVE E-FCA07-USER-DEFINED-AREA  TO CJF00101.                 
           MOVE MSG-C-DR                   TO E-FCA10-FIELD-4-4-DESC.   
           MOVE WS-101-CASH-DRAWER-USED    TO E-FCA10-FIELD-4-4-DATA.   
           MOVE 1100                       TO P-PARAGRAPH-NUMBER.       
           PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT.                     
       1100-EXIT.                                                       
           EXIT.                                                        
       1900-PROCESS-END-REC.                                            
           SUBTRACT 1 FROM WS-FCA07-RECORD-CNT.                         
           IF WS-FCA07-RECORD-CNT = E-FCA07-END-RECORD-CNT              
               MOVE WS-YES TO WS-LAST-ESDS-RECORD                       
           ELSE                                                         
              DISPLAY '***********************************************' 
              DISPLAY ' PROGRAM PCSCA123 RECORD COUNT DOES '            
                      ' NOT = FCA07 CONTROL RECORD COUNT'               
              DISPLAY '* PCSCA123 REC COUNT = ' WS-FCA07-RECORD-CNT     
              DISPLAY '* CONTROL REC COUNT  = ' E-FCA07-END-RECORD-CNT  
              DISPLAY '*            PROCESSING    TERMINATED         *' 
              DISPLAY '***********************************************' 
              PERFORM 9900-ABEND  THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
       2000-WRITE-BEGIN-CONTROLS.                                       
           MOVE SPACES           TO FIOCA10.                            
           MOVE LOW-VALUES       TO E-FCA10-BEGIN-KEY.                  
           MOVE WS-INPUT-DATE    TO E-FCA10-BEGIN-CREATE-DATE.          
           PERFORM 7900-WRITE-FCA10    THRU 7900-EXIT.                  
           SUBTRACT 1 FROM WS-FCA10-RECORD-CNT.                         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *  DELETED THE INTERNAL CA09 TRANSFER PROCESS- THE PROGRAM HAS            
      *  BEEN MODIFIED TO UPDATE DIRECTELY INTO THE CA09 FILE AS CA07           
      *  RECORDS ARE PROCESSED.                                                 
      *                                                                         
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  2100-DETAIL-JOURNAL-ROUTINE.                                  *        
      *       DETERMINES TYPE OF JRNL RECIEVED, AND CONTROLS THE       *        
      *   PROCESSING REQUIRED.                                         *        
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       2100-DETAIL-JOURNAL-ROUTINE.                                     
           PERFORM VARYING WS-GL-SUB       FROM 1 BY 1                  
TP5674           UNTIL WS-GL-SUB        GREATER 5                       
TP5674           OR    E-FCA07-COMPANY-NO EQUAL                         
TP5674                 WS-VALID-CO-NO (WS-GL-SUB)                       
           END-PERFORM.                                                 
           IF WS-GL-SUB                 GREATER 5                       
              SET WS-GL-SUB                  TO 1
           END-IF.                      
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-00001                     
HEMA2 *       MOVE E-FCA07-USER-DEFINED-AREA TO  CJF00001                       
HEMA2 *       PERFORM 3100-INITIALIZE-FCSCA08 THRU 3100-EXIT                    
              GO TO 2100-EXIT                                           
           ELSE                                                         
           PERFORM 3010-VERIFY-CUST-TRANS THRU 3010-EXIT
           END-IF.               
           PERFORM 8000-PRINT-DTJ-RECORDS THRU 8000-EXIT.               
           MOVE E-FCA07-JRNL-FORMAT-NO TO WS-CHECK-FORMAT-NO.           
           IF (E-FCA07-JRNL-FORMAT-NO GREATER THAN WS-100) AND          
              (E-FCA07-JRNL-FORMAT-NO LESS THAN WS-111)                 
               PERFORM 3400-GL-DAILY-DIRECT-ACCESS THRU 3400-EXIT       
               PERFORM 4500-WASH-BUCKET-ADD-ROUTINE THRU 4500-EXIT
           END-IF.     
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *       READS THE WS-CA09 DETAIL TABLE AND WRITES THE RECORDS    *        
      *   TO THE TRANSACTION JOURNAL FILE. SINCE RECORDS ARE NOT EVEN  *        
      *   LOADED IN THE DETAIL TABLE UNLESS THEY HAVE A NON ZERO AMOUNT*        
      *   ALL DETAIL RECORDS ARE WRITTEN                               *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA1 *2200-READ-WS-FCA09-DETAIL.                                               
HEMA1 **                                                                        
HEMA1 *    PERFORM 5100-LOAD-GL-TRAN-WORK-AREA THRU 5100-EXIT.                  
HEMA1 *    MOVE WS-FCA09-DETAIL-KEY (WS-CA09-DET-INDX)                          
HEMA1 *                                    TO WS-HOLD-CA09-DETAIL-KEY.          
HEMA1 *    PERFORM 7010-SEARCH-WS-FIOCA09  THRU 7010-EXIT.                      
HEMA1 *    IF CA09-FOUND                                                        
HEMA1 *       MOVE WS-FCA09-DATE-LAST-TRANS (WS-CA09-INDX)                      
HEMA1 *                                  TO WS-GL-TRAN-DATE-LAST-ACTION.        
HEMA1 *    MOVE WS-FCA09-DET-COMPANY-NO (WS-CA09-DET-INDX)                      
HEMA1 *                                    TO WS-GL-TRAN-COMPANY-NO.            
HEMA1 *    MOVE WS-FCA09-DET-GL-ACCT-NO (WS-CA09-DET-INDX)                      
HEMA1 *                                    TO WS-GL-TRAN-GL-ACCT-NO.            
HEMA1 *    MOVE WS-FCA09-DET-LOCAL-OFFICE (WS-CA09-DET-INDX)                    
HEMA1 *                                    TO WS-GL-TRAN-LOCAL-OFFICE.          
HEMA1 *    MOVE WS-FCA09-DET-FUNCTION-CODE (WS-CA09-DET-INDX)                   
HEMA1 *                                    TO WS-GL-TRAN-FUNCTION-CODE.         
HEMA1 *    IF WS-FCA09-JRNL-ACTIVITY-DR(WS-CA09-DET-INDX) EQUAL ZERO            
HEMA1 *        NEXT SENTENCE                                                    
HEMA1 *    ELSE                                                                 
HEMA1 *        MOVE WS-FCA09-JRNL-ACTIVITY-DR (WS-CA09-DET-INDX)                
HEMA1 *                                       TO WS-GL-TRAN-AMT-POSTED          
HEMA1 *        MOVE WS-D                      TO WS-GL-TRAN-CODE-DR-CR          
HEMA1 *        PERFORM 5030-INSERT-KSDS-JRNL-RECORD THRU 5030-EXIT.             
HEMA1 *    IF WS-FCA09-JRNL-ACTIVITY-CR (WS-CA09-DET-INDX) EQUAL ZERO           
HEMA1 *        NEXT SENTENCE                                                    
HEMA1 *    ELSE                                                                 
HEMA1 *        ADD 1 TO WS-GL-TRAN-DUP-CONTROL-KEY                              
HEMA1 *        MOVE WS-FCA09-JRNL-ACTIVITY-CR (WS-CA09-DET-INDX)                
HEMA1 *                                       TO WS-GL-TRAN-AMT-POSTED          
HEMA1 *        ADD WS-FCA09-JRNL-ACTIVITY-CR (WS-CA09-DET-INDX)                 
HEMA1 *                                      TO WS-ACCUM-CR-CGGLE-TOTAL         
HEMA1 *        MOVE WS-C                     TO WS-GL-TRAN-CODE-DR-CR           
HEMA1 *        PERFORM 5030-INSERT-KSDS-JRNL-RECORD THRU 5030-EXIT.             
HEMA1 *2200-EXIT.                                                               
HEMA1 *    EXIT.                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *   THE FOLLOWING ROUTINE WRITE THE JOURNAL 105 TRANSACTIONS     *        
      *   TO THE TRANSACTION JOURNAL FILE. IT FUNCTIONS LIKE           *        
      *   2200-READ-WS-FCA09-DETAIL, BUT THE RECORDS ARE WRITTEN AT    *        
      *   AT THE SAME THE FCA09 RECORDS ARE WRITTEN                    *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA1 *2300-WRITE-FCA04-JRNL-105.                                               
HEMA1 *                                                                         
HEMA1 *    PERFORM 5100-LOAD-GL-TRAN-WORK-AREA THRU 5100-EXIT.                  
HEMA1 *    MOVE E-FCA09-COMPANY-NO         TO WS-GL-TRAN-COMPANY-NO.            
HEMA1 *    MOVE E-FCA09-LOCAL-OFFICE       TO WS-GL-TRAN-LOCAL-OFFICE.          
HEMA1 *    MOVE E-FCA09-FUNCTION-CODE      TO WS-GL-TRAN-FUNCTION-CODE.         
HEMA1 *    MOVE E-FCA09-TRAN-DATE       TO WS-GL-TRAN-DATE-LAST-ACTION.         
HEMA1 *    IF WS-105-AMT-POSTED EQUAL ZERO                                      
HEMA1 *        GO TO 2300-EXIT.                                                 
HEMA1 *                                                                         
HEMA1 *    MOVE WS-105-ACCT-GEN-LED-DR    TO WS-GL-TRAN-GL-ACCT-NO.             
HEMA1 *    MOVE WS-105-AMT-POSTED         TO WS-GL-TRAN-AMT-POSTED.             
HEMA1 *    MOVE WS-D                      TO WS-GL-TRAN-CODE-DR-CR.             
HEMA1 *    PERFORM 5030-INSERT-KSDS-JRNL-RECORD THRU 5030-EXIT.                 
HEMA1 *                                                                         
HEMA1 *    ADD 1 TO WS-GL-TRAN-DUP-CONTROL-KEY.                                 
HEMA1 *    MOVE WS-105-ACCT-GEN-LED-CR    TO WS-GL-TRAN-GL-ACCT-NO.             
HEMA1 *    MOVE WS-105-AMT-POSTED         TO WS-GL-TRAN-AMT-POSTED              
HEMA1 *    ADD  WS-105-AMT-POSTED         TO WS-ACCUM-CR-CGGLE-TOTAL.           
HEMA1 *    MOVE WS-C                      TO WS-GL-TRAN-CODE-DR-CR.             
HEMA1 *    PERFORM 5030-INSERT-KSDS-JRNL-RECORD THRU 5030-EXIT.                 
HEMA1 *2300-EXIT.                                                               
HEMA1 *    EXIT.                                                                
      *                                                                         
       2999-WRITE-END-CONTROLS.                                         
           MOVE SPACES              TO FIOCA10.                         
           MOVE HIGH-VALUES         TO E-FCA10-END-KEY.                 
           MOVE WS-FCA10-RECORD-CNT TO E-FCA10-END-RECORD-CNT.          
           PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT.                     
           SUBTRACT 1               FROM WS-FCA10-RECORD-CNT.           
      *                                                                         
           MOVE SPACES              TO FIOCA09.                         
           MOVE HIGH-VALUES         TO E-FCA09-KEY-EREC.                
           MOVE WS-ACCUM-DR         TO E-FCA09-ACCUM-DR-EREC.           
           MOVE WS-ACCUM-CR         TO E-FCA09-ACCUM-CR-EREC.           
           MOVE WS-ACCUM-DR-IND     TO E-FCA09-ACCUM-DR-EREC-IND.       
           MOVE WS-ACCUM-CR-IND     TO E-FCA09-ACCUM-CR-EREC-IND.       
           MOVE WS-ACCUM-DR-ARM     TO E-FCA09-ACCUM-DR-EREC-ARM.       
           MOVE WS-ACCUM-CR-ARM     TO E-FCA09-ACCUM-CR-EREC-ARM.       
           WRITE FIOCA09.                                               
      *                                                                         
       2999-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
       3010-VERIFY-CUST-TRANS.                                          
CBSI  *                                                                         
CBSI       EVALUATE E-FCA07-JRNL-FORMAT-NO                              
CBSI           WHEN WS-101  THRU WS-105                                 
CBSI                PERFORM 3016-COMP-REV-MTH THRU 3016-EXIT            
CBSI           WHEN OTHER                                               
CBSI                CONTINUE                                            
CBSI       END-EVALUATE.                                                
CBSI  *                                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-101                       
               PERFORM 3011-ANALYZE-101-JOURNALS THRU 3011-EXIT         
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-102                       
               PERFORM 3012-ANALYZE-102-JOURNALS THRU 3012-EXIT         
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-103                       
               PERFORM 3013-ANALYZE-103-JOURNALS THRU 3013-EXIT         
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-104                       
               PERFORM 3014-ANALYZE-104-JOURNALS THRU 3014-EXIT         
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-105                       
               PERFORM 3015-ANALYZE-105-JOURNALS THRU 3015-EXIT
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.        
      *                                                                         
       3010-EXIT.                                                       
           EXIT.                                                        
       3011-ANALYZE-101-JOURNALS.                                       
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00101.                  
           MOVE SPACES                    TO WS-FUNCTION-CODE.          
           IF WS-101-AMT-POSTED LESS THAN ZERO                          
A02036         MULTIPLY -1 BY WS-101-AMT-POSTED
           END-IF.                        
           MOVE CJF00101 TO E-FCA07-USER-DEFINED-AREA.                  
       3011-EXIT.                                                       
           EXIT.                                                        
       3012-ANALYZE-102-JOURNALS.                                       
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00102.                  
           MOVE SPACES                    TO WS-FUNCTION-CODE.          
           IF WS-102-AMT-POSTED LESS THAN ZERO                          
A02036         MULTIPLY -1 BY WS-102-AMT-POSTED
           END-IF.                        
           IF WS-102-STAT-TAX-AMT LESS THAN ZERO                        
A02036         MULTIPLY -1 BY WS-102-STAT-TAX-AMT
           END-IF.                      
           IF WS-102-XCIS-TAX-AMT LESS THAN ZERO                        
A02036         MULTIPLY -1 BY WS-102-XCIS-TAX-AMT
           END-IF.                      
           IF WS-102-CITY-TAX-AMT LESS THAN ZERO                        
A02036         MULTIPLY -1 BY WS-102-CITY-TAX-AMT                       
           IF WS-102-OTHER-TAX-AMT LESS THAN ZERO                       
A02036         MULTIPLY -1 BY WS-102-OTHER-TAX-AMT
           END-IF
           END-IF.                     
           COMPUTE WS-TOTAL-TAXES =                                     
                 WS-102-STAT-TAX-AMT                                    
               + WS-102-XCIS-TAX-AMT                                    
               + WS-102-CITY-TAX-AMT                                    
               + WS-102-OTHER-TAX-AMT.                                  
           IF WS-TOTAL-TAXES GREATER THAN WS-102-AMT-POSTED             
               MOVE ZERO TO WS-102-STAT-TAX-AMT                         
                            WS-102-XCIS-TAX-AMT                         
                            WS-102-CITY-TAX-AMT                         
                            WS-102-OTHER-TAX-AMT                        
               MOVE E-FCA07-RECORD-ID-ACCT-NO TO WS-ACCT-NO-CA07        
               MOVE WS-ACCT-NO-CA07           TO E-FCA10-EXCEPTION-ID   
SM             MOVE E-FCA07-LOCAL-OFFICE      TO E-FCA10-LOCAL-OFFICE   
               MOVE WS-Z                      TO E-FCA10-REPORT-CENTER  
               MOVE WS-010                    TO E-FCA10-EXCPTN-CATEGORY
               MOVE WS-060                    TO E-FCA10-EXCPTN-TYPE    
               MOVE 1                         TO E-FCA10-LINE-CONTROL   
               MOVE 1                         TO E-FCA10-FORMAT-ID      
               MOVE SPACES                    TO E-FCA10-FIELD-1-DESC   
               MOVE MSG-TAXES-GREATER-AMT-POSTED                        
                                              TO E-FCA10-FIELD-1-DATA   
               MOVE 3012                      TO P-PARAGRAPH-NUMBER     
T30899         IF WS-SEB-YES THEN                                       
T30899             NEXT SENTENCE                                        
T30899         ELSE                                                     
T30899             PERFORM 7900-WRITE-FCA10   THRU 7900-EXIT            
T30899         END-IF
           END-IF.                                                  
           MOVE CJF00102                 TO E-FCA07-USER-DEFINED-AREA.  
       3012-EXIT.                                                       
           EXIT.                                                        
       3013-ANALYZE-103-JOURNALS.                                       
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00103.                  
           MOVE SPACES                    TO WS-FUNCTION-CODE.          
           IF WS-103-AMT-POSTED LESS THAN ZERO                          
A02036         MULTIPLY -1 BY WS-103-AMT-POSTED
           END-IF.                        
           MOVE CJF00103 TO E-FCA07-USER-DEFINED-AREA.                  
       3013-EXIT.                                                       
           EXIT.                                                        
       3014-ANALYZE-104-JOURNALS.                                       
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00104.                  
           MOVE SPACES                    TO WS-FUNCTION-CODE.          
           IF WS-104-AMT-POSTED LESS THAN ZERO                          
A02036         MULTIPLY -1 BY WS-104-AMT-POSTED
           END-IF.                        
           IF WS-104-STAT-TAX-AMT LESS THAN ZERO                        
A02036         MULTIPLY -1 BY WS-104-STAT-TAX-AMT
           END-IF.                      
           IF WS-104-CITY-TAX-AMT LESS THAN ZERO                        
A02036         MULTIPLY -1 BY WS-104-CITY-TAX-AMT
           END-IF.                      
           IF WS-104-OTHER-TAX-AMT LESS THAN ZERO                       
A02036         MULTIPLY -1 BY WS-104-OTHER-TAX-AMT
           END-IF.                     
           COMPUTE WS-TOTAL-TAXES =                                     
                 WS-104-STAT-TAX-AMT                                    
               + WS-104-CITY-TAX-AMT                                    
               + WS-104-OTHER-TAX-AMT.                                  
           MOVE WS-104-REVENUE-MONTH    TO WS-REVENUE-MONTH.            
           IF WS-TOTAL-TAXES GREATER THAN WS-104-AMT-POSTED             
               MOVE ZERO TO WS-104-STAT-TAX-AMT                         
                            WS-104-CITY-TAX-AMT                         
                            WS-104-OTHER-TAX-AMT                        
               MOVE E-FCA07-RECORD-ID-ACCT-NO TO WS-ACCT-NO-CA07        
               MOVE WS-ACCT-NO-CA07           TO E-FCA10-EXCEPTION-ID   
               MOVE E-FCA07-LOCAL-OFFICE      TO E-FCA10-LOCAL-OFFICE   
               MOVE WS-Z                      TO E-FCA10-REPORT-CENTER  
               MOVE WS-010                    TO E-FCA10-EXCPTN-CATEGORY
               MOVE WS-060                    TO E-FCA10-EXCPTN-TYPE    
               MOVE 1                         TO E-FCA10-LINE-CONTROL   
               MOVE 1                         TO E-FCA10-FORMAT-ID      
               MOVE SPACES                    TO E-FCA10-FIELD-1-DESC   
               MOVE MSG-TAXES-GREATER-AMT-POSTED                        
                   TO E-FCA10-FIELD-1-DATA                              
               MOVE 3014                      TO P-PARAGRAPH-NUMBER     
T30899         IF WS-SEB-YES THEN                                       
T30899             NEXT SENTENCE                                        
T30899         ELSE                                                     
T30899             PERFORM 7900-WRITE-FCA10   THRU 7900-EXIT            
T30899         END-IF
           END-IF.                                                  
           MOVE CJF00104                   TO E-FCA07-USER-DEFINED-AREA.
       3014-EXIT.                                                       
           EXIT.                                                        
       3015-ANALYZE-105-JOURNALS.                                       
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00105.                  
           MOVE WS-105-FUNCTION-CODE      TO WS-FUNCTION-CODE.          
           IF WS-105-AMT-POSTED LESS THAN ZERO                          
A02036         MULTIPLY -1 BY WS-105-AMT-POSTED
           END-IF.                        
           MOVE CJF00105 TO E-FCA07-USER-DEFINED-AREA.                  
       3015-EXIT.                                                       
           EXIT.                                                        
CBSI  *                                                                         
CBSI   3016-COMP-REV-MTH.                                               
CBSI       MOVE E-FCA07-USER-DEFINED-AREA      TO                       
CBSI                                 WS-RP132-USER-DEFINED-AREA.        
CBSI  *                                                                         
CBSI       IF  WS-RP132-REV-MONTH NUMERIC AND WS-RP132-REV-MONTH > 0    
CBSI           IF  WS-RP132-REV-MONTH = WS-REVENUE-MONTH-COMMON         
CBSI               NEXT SENTENCE                                        
CBSI           ELSE                                                     
CBSI               PERFORM 3017-LOAD-FRP132    THRU 3017-EXIT           
CBSI               PERFORM 3018-WRITE-FRP132   THRU 3018-EXIT           
CBSI               PERFORM 3017-LOAD-FRP132    THRU 3017-EXIT           
CBSI               MOVE WS-RP132-GEN-LED-CR    TO E-FRP132-GEN-LED-DR-CR
CBSI               MOVE 1                      TO E-FRP132-FLAG         
CBSI               PERFORM 3018-WRITE-FRP132   THRU 3018-EXIT           
CBSI           END-IF                                                   
CBSI       END-IF.                                                      
CBSI  *                                                                         
CBSI   3016-EXIT.                                                       
CBSI       EXIT.                                                        
CBSI  *                                                                         
CBSI   3017-LOAD-FRP132.                                                
CBSI       MOVE E-FCA07-LOCAL-OFFICE      TO E-FRP132-LOCAL-OFFICE.     
CBSI       MOVE E-FCA07-RECORD-ID-ACCT-NO TO E-FRP132-ACCOUNT-NO.       
CBSI       MOVE WS-RP132-AMT-POSTED       TO E-FRP132-AMT-POSTED.       
CBSI       MOVE WS-RP132-GEN-LED-DR       TO E-FRP132-GEN-LED-DR-CR.    
CBSI       MOVE 0                         TO E-FRP132-FLAG.             
CBSI       MOVE WS-RP132-REV-MONTH        TO E-FRP132-REVENUE-MONTH.    
CBSI  *                                                                         
CBSI   3017-EXIT.                                                       
CBSI       EXIT.                                                        
CBSI  *                                                                         
CBSI   3018-WRITE-FRP132.                                               
CBSI  *                                                                         
CBSI       WRITE FIORP132.                                              
CBSI       IF  FRP132-SUCCESSFUL                                        
CBSI           NEXT SENTENCE                                            
CBSI       ELSE                                                         
CBSI           MOVE '**** WRITE ERROR - FCSRP132'                       
CBSI                                     TO P-STATUS-KEY-ERROR-MSG      
CBSI           MOVE WS-FRP132-STATUS     TO P-STATUS-KEY                
CBSI           MOVE 3018                 TO P-PARAGRAPH-NUMBER          
CBSI           PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE                   
CBSI                                      THRU 8910-EXIT                
CBSI       END-IF.                                                      
CBSI       INITIALIZE FIORP132.                                         
CBSI  *                                                                         
CBSI   3018-EXIT.                                                       
CBSI       EXIT.                                                        
CBSI  *                                                                         
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3100-INITIALIZE-FCSCA08.                                      *        
      *       THIS PARAGRAPH CHECKS TO SEE IF THE RECORD IS A BATCH    *        
      *   RECORD.  IF IT IS, THIS PARAGRAPH THEN LOOKS TO SEE IF THE   *        
      *   BATCH IS ONE OF THE FIRST 1000.   IF SO, IT IS ADDED TO THE  *        
      *   BATCH TABLE AND FCSCA08-FILE.  IF NOT, IT IS PUT OUT TO      *        
      *   FCSCA08-FILE.                                                *        
      *       IF THE JRNL RECORD IS NOT A BATCH RECORD, CONTROL IS     *        
      *   PASSED TO 3120-UPDATE-FCSCA08.                               *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA2 *3100-INITIALIZE-FCSCA08.                                                 
HEMA2 *    IF WS-001-ACTIVITY-TYPE EQUAL WS-B                                   
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        PERFORM 3120-UPDATE-FCSCA08-REC THRU 3120-EXIT                   
HEMA2 *        IF E-FCA07-TRAN-DATE GREATER  THAN WS-CURRENT-DATE-CYMD          
HEMA2 *            MOVE E-FCA07-TRAN-DATE      TO WS-CURRENT-DATE-CYMD          
HEMA2 *            MOVE SPACES                TO WS-ACCTNG-PER-DATE-CYM         
HEMA2 *            GO TO 3100-EXIT                                              
HEMA2 *         ELSE                                                            
HEMA2 *            GO TO 3100-EXIT.                                             
HEMA2 *    ADD 1 TO WS-BATCH-COUNT.                                             
HEMA2 *    IF WS-BATCH-COUNT GREATER THAN 1000                                  
HEMA2 *        PERFORM 3120-UPDATE-FCSCA08-REC THRU 3120-EXIT                   
HEMA2 *        GO TO 3100-EXIT.                                                 
HEMA2 *    SET WS-INDEX-BWT     TO WS-BATCH-COUNT.                              
HEMA2 *    MOVE WS-001-ACTIVITY-SOURCE                                          
HEMA2 *                     TO WS-ACTIVITY-SOURCE-BWT (WS-INDEX-BWT).           
HEMA2 *    MOVE ZEROS           TO WS-CASH-DR-TOTAL-BWT (WS-INDEX-BWT).         
HEMA2 *    MOVE ZEROS           TO WS-CASH-CR-TOTAL-BWT (WS-INDEX-BWT).         
HEMA2 *    MOVE ZEROS           TO WS-AR-DR-TOTAL-BWT (WS-INDEX-BWT).           
HEMA2 *    MOVE ZEROS           TO WS-AR-CR-TOTAL-BWT (WS-INDEX-BWT).           
HEMA2 *    MOVE ZEROS           TO WS-GL-DR-TOTAL-BWT (WS-INDEX-BWT).           
HEMA2 *    MOVE ZEROS           TO WS-GL-CR-TOTAL-BWT (WS-INDEX-BWT).           
HEMA2 *    MOVE ZEROS           TO WS-CKI-DR-TOTAL-BWT (WS-INDEX-BWT).          
HEMA2 *    MOVE ZEROS           TO WS-CKI-CR-TOTAL-BWT (WS-INDEX-BWT).          
HEMA2 *    PERFORM 3120-UPDATE-FCSCA08-REC THRU 3120-EXIT.                      
HEMA2 *3100-EXIT.                                                               
HEMA2 *    EXIT.                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3120-UDATE-FCSCA08-FILE.                                      *        
      *       UPDATES THE WASH-DISK-WORK FILE (FCSCA08) FROM THE       *        
      *   00001 JRNL RECORDS.  IF THERE IS NO FCSCA08 RECORD, CONTROL  *        
      *   IS PASSED TO 3121-CREATE-NEW-FIOCA08.                 *               
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA2 *3120-UPDATE-FCSCA08-REC.                                                 
HEMA2 *    MOVE WS-001-ACTIVITY-TYPE    TO E-FCA08-ACTIVITY-TYPE.               
HEMA2 *    MOVE WS-001-ACTIVITY-SOURCE  TO E-FCA08-ACTIVITY-SOURCE.             
HEMA2 *    MOVE ZEROS                   TO E-FCA08-JRNL-CASH-DR-TOT             
HEMA2 *                                    E-FCA08-JRNL-CASH-CR-TOT             
HEMA2 *                                    E-FCA08-JRNL-AR-DR-TOT               
HEMA2 *                                    E-FCA08-JRNL-AR-CR-TOT               
HEMA2 *                                    E-FCA08-JRNL-GL-DR-TOT               
HEMA2 *                                    E-FCA08-JRNL-GL-CR-TOT               
HEMA2 *                                    E-FCA08-JRNL-CKI-DR-TOT              
HEMA2 *                                    E-FCA08-JRNL-CKI-CR-TOT.             
HEMA2 *    MOVE WS-001-CNTRL-ACTIVITY-TOTALS TO                                 
HEMA2 *                                    E-FCA08-CNTRL-ACCUM-TOTALS.          
HEMA2 *    MOVE WS-001-CASH-DRWR-END-BAL TO                                     
HEMA2 *                                    E-FCA08-CNTRL-CASH-DRWR-BAL.         
HEMA2 *    MOVE WS-001-BASIC-WORK-FUND-AMT TO                                   
HEMA2 *                                    E-FCA08-CNTRL-WORK-FUND-AMT.         
HEMA2 *    MOVE E-FCA07-TRAN-DATE       TO E-FCA08-CNTRL-EXTRACT-DATE.          
HEMA2 *    WRITE FIOCA08.                                                       
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        MOVE '**** WRITE ERROR - CA08 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        MOVE WS-FCA08-STATUS            TO P-STATUS-KEY                  
HEMA2 *        MOVE 3120                       TO P-PARAGRAPH-NUMBER            
HEMA2 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA2 *3120-EXIT.                                                               
HEMA2 *    EXIT.                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3200-DTJ-TOT-EXT-ERROR.                                       *        
      *       THIS PARAGRAPH HANDLES THE 00002 JRNL RECORDS.  THE TOM  *        
      *   TOTALS DID NOT MATCH THE EXTRACT TOTALS.  A RECORD IS CREATED*        
      *   IN THE EXCEPTION-DISK-WORK (FCSCA10) FILE, STATING THE CASH- *        
      *   DRAWER OR BATCH NUMBER AND THE TWO TOTALS THAT ARE OUT OF    *        
      *   BALANCE.                                                     *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA3 *3200-DTJ-TOT-EXT-ERROR.                                                  
HEMA3 *    MOVE WS-Z               TO E-FCA10-REPORT-CENTER.                    
HEMA3 *    MOVE E-FCA07-TRAN-DATE  TO E-FCA10-EXCEPTION-DATE.                   
HEMA3 *    MOVE E-FCA07-COMPANY-NO TO E-FCA10-COMPANY-NO.                       
HEMA3 *    MOVE WS-010             TO E-FCA10-EXCPTN-CATEGORY                   
HEMA3 *                               E-FCA10-EXCPTN-TYPE.                      
HEMA3 *    MOVE WS-002-CASH-COMPANY-NO      TO                                  
HEMA3 *         WS-EXCPTN-CASH-COMPANY-NO.                                      
HEMA3 *    MOVE WS-002-CASH-LOCAL-OFFICE    TO                                  
HEMA3 *         WS-EXCPTN-CASH-LOCAL-OFFICE.                                    
HEMA3 *    MOVE WS-002-CASH-REPORT-NO       TO                                  
HEMA3 *         WS-EXCPTN-CASH-REPORT-NO.                                       
HEMA3 *    MOVE WS-002-DATE-CASH-REPORT     TO                                  
HEMA3 *         WS-EXCPTN-DATE-CASH-REPORT.                                     
HEMA3 *    MOVE WS-002-CASH-DRAWER-ID       TO                                  
HEMA3 *         WS-EXCPTN-CASH-DRAWER-ID.                                       
HEMA3 *    MOVE WS-EXCPTN-ID-WASH-ERROR     TO E-FCA10-EXCEPTION-ID.            
HEMA3 *    MOVE MSG-EXTRACT-JRNL-NO-WASH    TO E-FCA10-EXCEPTION-DESC.          
HEMA3 *    MOVE 1                           TO E-FCA10-LINE-CONTROL.            
HEMA3 *    MOVE 3                           TO E-FCA10-FORMAT-ID.               
HEMA3 *    MOVE MSG-ERROR                   TO E-FCA10-FIELD-1-3-DESC.          
HEMA3 *    MOVE WS-002-ERROR-DESCRIPTION    TO E-FCA10-FIELD-1-3-DATA.          
HEMA3 *    MOVE MSG-TOM                     TO E-FCA10-FIELD-2-3-DESC.          
HEMA3 *    MOVE WS-002-CNTRL-ACT-TOT-EDIT   TO E-FCA10-FIELD-2-3-DATA.          
HEMA3 *    MOVE MSG-TOT                     TO E-FCA10-FIELD-3-3-DESC.          
HEMA3 *    MOVE WS-002-EXT-ACT-TOT-EDIT     TO E-FCA10-FIELD-3-3-DATA.          
HEMA3 *    MOVE 3200                        TO P-PARAGRAPH-NUMBER.              
HEMA3 *    PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT.                             
HEMA3 *3200-EXIT.                                                               
HEMA3 *    EXIT.                                                                
HEMA3 *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA3 *  3300-DTJ-EXC-ERROR-CHECK.                                     *        
HEMA3 *       NOT DEFINED                                              *        
HEMA3 *                                                                *        
HEMA3 *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA3 *3300-DTJ-EXC-ERROR-CHECK.                                                
HEMA3 *    IF E-FCA07-CODE-TRAN-ERRORS (1) EQUAL SPACES OR LOW-VALUES           
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        MOVE E-FCA07-CODE-TRAN-ERRORS (1) TO WS-PENDING-DESC-CODE        
HEMA3 *        PERFORM 3380-LOAD-CONDITION-CODE-ERROR THRU 3380-EXIT.           
HEMA3 *    IF E-FCA07-CODE-TRAN-ERRORS (2) EQUAL SPACES OR LOW-VALUES           
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        MOVE E-FCA07-CODE-TRAN-ERRORS (2) TO WS-PENDING-DESC-CODE        
HEMA3 *        PERFORM 3380-LOAD-CONDITION-CODE-ERROR THRU 3380-EXIT.           
HEMA3 *    IF E-FCA07-CODE-TRAN-ERRORS (3) EQUAL SPACES OR LOW-VALUES           
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        MOVE E-FCA07-CODE-TRAN-ERRORS (3) TO WS-PENDING-DESC-CODE        
HEMA3 *        PERFORM 3380-LOAD-CONDITION-CODE-ERROR THRU 3380-EXIT.           
HEMA3 *    IF E-FCA07-CODE-TRAN-ERRORS (4) EQUAL SPACES OR LOW-VALUES           
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        MOVE E-FCA07-CODE-TRAN-ERRORS (4) TO WS-PENDING-DESC-CODE        
HEMA3 *        PERFORM 3380-LOAD-CONDITION-CODE-ERROR THRU 3380-EXIT.           
HEMA3 *    IF E-FCA07-CODE-TRAN-ERRORS (5) EQUAL SPACES OR LOW-VALUES           
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        MOVE E-FCA07-CODE-TRAN-ERRORS (5) TO WS-PENDING-DESC-CODE        
HEMA3 *        PERFORM 3380-LOAD-CONDITION-CODE-ERROR THRU 3380-EXIT.           
HEMA3 *    IF E-FCA07-CODE-TRAN-ERRORS (6) EQUAL SPACES OR LOW-VALUES           
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        MOVE E-FCA07-CODE-TRAN-ERRORS (6) TO WS-PENDING-DESC-CODE        
HEMA3 *        PERFORM 3380-LOAD-CONDITION-CODE-ERROR THRU 3380-EXIT.           
HEMA3 *    IF E-FCA07-CODE-TRAN-ERRORS (7) EQUAL SPACES OR LOW-VALUES           
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        MOVE E-FCA07-CODE-TRAN-ERRORS (7) TO WS-PENDING-DESC-CODE        
HEMA3 *        PERFORM 3380-LOAD-CONDITION-CODE-ERROR THRU 3380-EXIT.           
HEMA3 *    MOVE E-FCA07-USER-DEFINED-AREA TO CJF00102.                          
HEMA3 *    IF WS-102-JRNL-FORMAT-NO LESS THAN WS-101                            
HEMA3 *        GO TO 3300-EXIT.                                                 
HEMA3 *    IF WS-102-JRNL-FORMAT-NO GREATER THAN WS-110                         
HEMA3 *        GO TO 3300-EXIT.                                                 
HEMA3 *                                                                         
HEMA3 *3300-EXIT.                                                               
HEMA3 *    EXIT.                                                                
HEMA3 *3380-LOAD-CONDITION-CODE-ERROR.                                          
HEMA3 *    MOVE WS-A              TO E-FCA10-REPORT-CENTER.                     
HEMA3 *    MOVE SPACES            TO E-FCA10-EXCEPTION-DESC                     
HEMA3 *                              E-FCA10-FIELD-1-DATA.                      
HEMA3 *    MOVE WS-CONDITION-CODE TO WS-PENDING-DESC-DATA.                      
HEMA3 *    SET WS-MSG-INDEX TO 1.                                               
HEMA3 *    SEARCH WS-EXCEPTION-MESSAGE-RECORD                                   
HEMA3 *        AT END                                                           
HEMA3 *            MOVE WS-MSG-UNDEFINED-ERROR                                  
HEMA3 *                TO WS-PENDING-MSG                                        
HEMA3 *        WHEN                                                             
HEMA3 *            WS-MESSAGE-KEY-TABLE (WS-MSG-INDEX)                          
HEMA3 *                EQUAL WS-PENDING-DESC-CODE                               
HEMA3 *                    MOVE WS-MESSAGE-DATA-TABLE (WS-MSG-INDEX)            
HEMA3 *                        TO WS-PENDING-MSG.                               
HEMA3 *    PERFORM 3390-CREATE-EXCEPTION-ERROR THRU 3390-EXIT.                  
HEMA3 *3380-EXIT.                                                               
HEMA3 *    EXIT.                                                                
HEMA3 *3390-CREATE-EXCEPTION-ERROR.                                             
HEMA3 *    MOVE E-FCA07-RECORD-ID-ACCT-NO TO WS-ACCT-NO-CA07.                   
HEMA3 *    MOVE WS-ACCT-NO-CA07           TO E-FCA10-EXCEPTION-ID.              
HEMA3 *    MOVE E-FCA07-LOCAL-OFFICE      TO E-FCA10-LOCAL-OFFICE.              
HEMA3 *    MOVE E-FCA07-COMPANY-NO        TO E-FCA10-COMPANY-NO.                
HEMA3 *    MOVE WS-PENDING-DESC           TO E-FCA10-EXCEPTION-DESC.            
HEMA3 *    IF E-FCA10-EXCEPTION-ID EQUAL WS-EXCPTN-ID-SAVE                      
HEMA3 *        AND E-FCA10-EXCEPTION-DESC EQUAL WS-EXCPTN-DESC-SAVE             
HEMA3 *            GO TO 3390-EXIT.                                             
HEMA3 *    IF WS-PENDING-DESC-CODE EQUAL WS-A OR WS-B                           
HEMA3 *        MOVE WS-Z TO E-FCA10-REPORT-CENTER                               
HEMA3 *        PERFORM 3391-CREATE-GO-EXCPTN-ERROR THRU 3391-EXIT               
HEMA3 *        GO TO 3390-EXIT.                                                 
HEMA3 *    IF WS-PENDING-DESC-CODE EQUAL SPACES                                 
HEMA3 *        MOVE WS-A TO E-FCA10-REPORT-CENTER                               
HEMA3 *        PERFORM 3392-CREATE-LOC-OFF-EXCPT-ERR THRU 3392-EXIT             
HEMA3 *        GO TO 3390-EXIT.                                                 
HEMA3 *    IF WS-PENDING-DESC-CODE EQUAL WS-K OR WS-R OR WS-S OR WS-T           
HEMA3 *                                       OR WS-J OR WS-M OR WS-W           
HEMA3 *        MOVE WS-A TO E-FCA10-REPORT-CENTER                               
HEMA3 *        PERFORM 3391-CREATE-GO-EXCPTN-ERROR THRU 3391-EXIT               
HEMA3 *        GO TO 3390-EXIT.                                                 
HEMA3 *    MOVE WS-A TO E-FCA10-REPORT-CENTER.                                  
HEMA3 *    PERFORM 3391-CREATE-GO-EXCPTN-ERROR THRU 3391-EXIT.                  
TP1612* THE FD IS CLEARED AFTER A WRITE, SO ALL THE FIELDS MUST BE              
TP1612* INITIALIZED AGAIN.                                                      
HEMA3 *    MOVE WS-A                 TO E-FCA10-REPORT-CENTER.                  
HEMA3 *    MOVE WS-PENDING-DESC      TO E-FCA10-EXCEPTION-DESC.                 
HEMA3 *    MOVE WS-ACCT-NO-CA07      TO E-FCA10-EXCEPTION-ID.                   
      * SEE IF THE LOCAL OFFICE MOVE IS NEEDED HERE DURING TESTING              
      * SJM COMMENTED OUT- MAY NEED TO ADD COMPANY TOO                          
HEMA3 *    MOVE E-FCA07-LOCAL-OFFICE TO E-FCA10-LOCAL-OFFICE.                   
HEMA3 *    PERFORM 3392-CREATE-LOC-OFF-EXCPT-ERR THRU 3392-EXIT.                
HEMA3 *3390-EXIT.                                                               
HEMA3 *    EXIT.                                                                
HEMA3 *3391-CREATE-GO-EXCPTN-ERROR.                                             
HEMA3 *    MOVE E-FCA07-TRAN-DATE      TO E-FCA10-EXCEPTION-DATE.               
HEMA3 *    MOVE E-FCA07-LOCAL-OFFICE   TO E-FCA10-LOCAL-OFFICE.                 
HEMA3 *    MOVE E-FCA07-COMPANY-NO     TO E-FCA10-COMPANY-NO.                   
HEMA3 *    MOVE WS-010                 TO E-FCA10-EXCPTN-CATEGORY.              
HEMA3 *    MOVE WS-060                 TO E-FCA10-EXCPTN-TYPE.                  
HEMA3 *    MOVE 1                      TO E-FCA10-LINE-CONTROL.                 
HEMA3 *    MOVE WS-1                   TO E-FCA10-FORMAT-ID.                    
HEMA3 *    MOVE SPACES                 TO E-FCA10-FIELD-1-DESC.                 
HEMA3 *    MOVE WS-PENDING-MSG         TO E-FCA10-FIELD-1-DATA.                 
HEMA3 *    MOVE 3391                   TO P-PARAGRAPH-NUMBER.                   
HEMA3 *    MOVE E-FCA10-EXCEPTION-ID   TO WS-EXCPTN-ID-SAVE.                    
HEMA3 *    MOVE E-FCA10-EXCEPTION-DESC TO WS-EXCPTN-DESC-SAVE.                  
HEMA3 *    IF WS-PENDING-DESC-CODE = WS-R                                       
HEMA3 *        MOVE WS-PENDING-DESC    TO E-FCA10-FIELD-1-DESC                  
HEMA3 *        MOVE WS-ACCT-NO-CA07    TO E-FCA10-EXCEPTION-DESC                
HEMA3 *        MOVE WS-PENDING-MSG-S   TO E-FCA10-EXCEPTION-ID                  
HEMA3 *    END-IF.                                                              
HEMA3 *                                                                         
HEMA3 *    IF WS-SEB-YES THEN                                                   
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT                          
HEMA3 *    END-IF.                                                              
HEMA3 *3391-EXIT.                                                               
HEMA3 *    EXIT.                                                                
HEMA3 *3392-CREATE-LOC-OFF-EXCPT-ERR.                                           
HEMA3 *    MOVE E-FCA07-TRAN-DATE      TO E-FCA10-EXCEPTION-DATE.               
HEMA3 *    MOVE E-FCA07-COMPANY-NO     TO E-FCA10-COMPANY-NO.                   
HEMA3 *    MOVE SPACES                 TO E-FCA10-LOCAL-OFFICE.                 
HEMA3 *    MOVE WS-010                 TO E-FCA10-EXCPTN-CATEGORY.              
HEMA3 *    MOVE WS-060                 TO E-FCA10-EXCPTN-TYPE.                  
HEMA3 *    MOVE 1                      TO E-FCA10-LINE-CONTROL.                 
HEMA3 *    MOVE 1                      TO E-FCA10-FORMAT-ID.                    
HEMA3 *    MOVE SPACES                 TO E-FCA10-FIELD-1-DESC.                 
HEMA3 *    MOVE WS-PENDING-MSG         TO E-FCA10-FIELD-1-DATA.                 
HEMA3 *    MOVE 3392                   TO P-PARAGRAPH-NUMBER.                   
HEMA3 *    MOVE E-FCA10-EXCEPTION-ID   TO WS-EXCPTN-ID-SAVE.                    
HEMA3 *    MOVE E-FCA10-EXCEPTION-DESC TO WS-EXCPTN-DESC-SAVE.                  
HEMA3 *    IF WS-SEB-YES THEN                                                   
HEMA3 *        NEXT SENTENCE                                                    
HEMA3 *    ELSE                                                                 
HEMA3 *        PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT                          
HEMA3 *    END-IF.                                                              
HEMA3 *3392-EXIT.                                                               
HEMA3 *    EXIT.                                                                
HEMA3 *    EJECT                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3400-GL-DAILY-DIRECT-ACCESS.                                  *        
      *       THIS PARAGRAPH CHECKS FOR EQUAL DEBIT AND CREDIT         *        
      *   GENERAL LEDGER NUMBERS, IF FOUND, IT ZEROS OUT THE HOLD-AREAS*        
      *   AND DROPS OUT.                                               *        
      *       THIS PARAGRAPH ALSO CHECKS TO SEE THAT THERE IS A 142.XX *        
      *   ACCOUNT IN THIS TRANSACTION, IF NOT IT WRITES AN ERROR       *        
      *   MESSAGE OUT TO THE EXCEPTION-DISK-WORK FILE (FCSCA10).       *        
      *                                                                *        
      *       AFTER ALL OF WHICH, THE HOLD-AREAS ARE ZEROED OUT.       *        
      *                                                                *        
      *       SINCE ALL OF THE SORT KEY "A" COPY STATMENTS ARE OF      *        
      *   BASICALLY THE SAME LAYOUT, I WILL BE USING WS-00101 IN THE   *        
      *   FOLLOWING PARAGRAPHS IN REFERRING TO ALL OF THE SORT KEY "A" *        
      *   SEGMENTS FOR EASE IN PROGRAMMING.                            *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3400-GL-DAILY-DIRECT-ACCESS.                                     
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00101.                  
           IF WS-101-ACCT-GEN-LED-DR EQUAL WS-101-ACCT-GEN-LED-CR       
               MOVE WS-NO TO WS-NO-TAX-ADD                              
               MOVE ZERO  TO WS-HOLD-AREAS                              
               GO TO 3400-EXIT
           END-IF.                                         
           MOVE WS-101-ACCT-GEN-LED-DR TO WS-GL-NO-BREAKDOWN.           
           IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                  
               PERFORM 3410-GLADDA-010 THRU 3410-EXIT                   
           ELSE                                                         
               MOVE WS-101-ACCT-GEN-LED-CR TO WS-GL-NO-BREAKDOWN        
               IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142              
                   PERFORM 3410-GLADDA-010 THRU 3410-EXIT               
               ELSE                                                     
                   MOVE WS-YES TO WS-NO-TAX-ADD                         
                   PERFORM 3410-GLADDA-010 THRU 3410-EXIT
               END-IF
           END-IF.              
           MOVE WS-NO          TO WS-NO-TAX-ADD.                        
           MOVE ZERO           TO WS-HOLD-AREAS.                        
       3400-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3401-GL-EXCEPTION-ERROR.                                      *        
      *       AN A/R TRANSACTION OCCURRED WITHOUT A 142.XX ACCOUNT.    *        
      *   THIS PARAGRAPH CREATES THE NECESSARY RECORDS TO NOTE THE     *        
      *   ERROR AND PLACES THEM IN THE EXECPTION-DISK-WORK FILE .      *        
      *                                              (FCSCA10)         *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA3 *3401-GL-EXCEPTION-ERROR.                                                 
HEMA3 *    MOVE WS-A                      TO E-FCA10-REPORT-CENTER.             
HEMA3 *    MOVE E-FCA07-TRAN-DATE         TO E-FCA10-EXCEPTION-DATE.            
HEMA3 *    MOVE E-FCA07-RECORD-ID-ACCT-NO TO WS-ACCT-NO-CA07.                   
HEMA3 *    MOVE E-FCA07-LOCAL-OFFICE      TO E-FCA10-LOCAL-OFFICE.              
HEMA3 *    MOVE E-FCA07-COMPANY-NO        TO E-FCA10-COMPANY-NO.                
HEMA3 *    MOVE WS-ACCT-NO-CA07           TO E-FCA10-EXCEPTION-ID.              
HEMA3 *    MOVE WS-010                    TO E-FCA10-EXCPTN-CATEGORY.           
HEMA3 *    MOVE WS-030                    TO E-FCA10-EXCPTN-TYPE.               
HEMA3 *    MOVE MSG-POSSIBLE-TAX-ERROR    TO E-FCA10-EXCEPTION-DESC.            
HEMA3 *    MOVE 1                         TO E-FCA10-LINE-CONTROL.              
HEMA3 *    MOVE 3                         TO E-FCA10-FORMAT-ID.                 
HEMA3 *    MOVE MSG-GL-NO                 TO E-FCA10-FIELD-1-3-DESC.            
HEMA3 *    MOVE WS-GL-NO-MINOR-KEY        TO MSG-142-MINOR-NO.                  
HEMA3 *    MOVE MSG-142-NOT-REFERENCED    TO E-FCA10-FIELD-1-3-DATA.            
HEMA3 *    MOVE MSG-SYSTEM                TO E-FCA10-FIELD-2-3-DESC             
HEMA3 *    MOVE MSG-IGNORED-ANY-TAX-DATA  TO E-FCA10-FIELD-2-3-DATA.            
HEMA3 *    MOVE MSG-GL-NO                 TO E-FCA10-FIELD-3-3-DESC.            
HEMA3 *    MOVE MSG-FOR-TAXES-NOT-USED    TO E-FCA10-FIELD-3-3-DATA.            
HEMA3 *    MOVE 3401                      TO P-PARAGRAPH-NUMBER.                
HEMA3 *    PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT.                             
HEMA3 *    IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-102 OR WS-104                     
HEMA3 *        MOVE E-FCA07-USER-DEFINED-AREA TO CJF00102                       
HEMA3 *    ELSE                                                                 
HEMA3 *        GO TO 3401-EXIT.                                                 
HEMA3 *    MOVE E-FCA07-TRAN-DATE         TO E-FCA10-EXCEPTION-DATE.            
HEMA3 *    MOVE E-FCA07-RECORD-ID-ACCT-NO TO WS-ACCT-NO-CA07.                   
HEMA3 *    MOVE E-FCA07-LOCAL-OFFICE      TO E-FCA10-LOCAL-OFFICE.              
HEMA3 *    MOVE E-FCA07-COMPANY-NO        TO E-FCA10-COMPANY-NO.                
HEMA3 *    MOVE WS-ACCT-NO-CA07           TO E-FCA10-EXCEPTION-ID.              
HEMA3 *    MOVE WS-010                    TO E-FCA10-EXCPTN-CATEGORY.           
HEMA3 *    MOVE WS-030                    TO E-FCA10-EXCPTN-TYPE.               
HEMA3 *    MOVE MSG-POSSIBLE-TAX-ERROR    TO E-FCA10-EXCEPTION-DESC.            
HEMA3 *    MOVE 1                         TO E-FCA10-LINE-CONTROL.              
HEMA3 *    MOVE 4                         TO E-FCA10-FORMAT-ID.                 
HEMA3 *    MOVE E-FCA07-USER-DEFINED-AREA TO CJF00102.                          
HEMA3 *    MOVE MSG-STATE                 TO E-FCA10-FIELD-1-4-DESC.            
HEMA3 *    MOVE WS-102-STAT-TAX-AMT       TO WS-TAX-DISPLAY.                    
HEMA3 *    MOVE WS-TAX-DISPLAY            TO E-FCA10-FIELD-1-4-DATA.            
HEMA3 *    MOVE MSG-EXCISE                TO E-FCA10-FIELD-2-4-DESC.            
HEMA3 *    MOVE WS-102-XCIS-TAX-AMT       TO WS-TAX-DISPLAY.                    
HEMA3 *    MOVE WS-TAX-DISPLAY            TO E-FCA10-FIELD-2-4-DATA.            
HEMA3 *    MOVE MSG-CITY                  TO E-FCA10-FIELD-3-4-DESC.            
HEMA3 *    MOVE WS-102-CITY-TAX-AMT       TO WS-TAX-DISPLAY.                    
HEMA3 *    MOVE WS-TAX-DISPLAY            TO E-FCA10-FIELD-3-4-DATA.            
HEMA3 *    MOVE MSG-OTHER                 TO E-FCA10-FIELD-4-4-DESC.            
HEMA3 *    MOVE WS-102-OTHER-TAX-AMT      TO WS-TAX-DISPLAY.                    
HEMA3 *    MOVE WS-TAX-DISPLAY            TO E-FCA10-FIELD-4-4-DATA.            
HEMA3 *    MOVE 3401                      TO P-PARAGRAPH-NUMBER.                
HEMA3 *    PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT.                             
HEMA3 *3401-EXIT.                                                               
HEMA3 *    EXIT.                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3410-GLADDA-010.                                              *        
      *       TRANSFERS THE DEBIT GL-NUMBERS AND AMOUNTS TO HOLD AREAS *        
      *   FROM WHICH THE GL-TABLES WILL BE UPDATED, AFTER WHICH, THIS  *        
      *   PARAGRAPH DOES THE SAME FOR THE CREDIT SIDE.                 *        
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3410-GLADDA-010.                                                 
           MOVE WS-DR                  TO WS-HOLD-TYPE.                 
           MOVE WS-101-ACCT-GEN-LED-DR TO WS-HOLD-GL-NO.                
           MOVE WS-101-AMT-POSTED      TO WS-HOLD-AMOUNT.               
           PERFORM 3420-GLADDA-020 THRU 3420-EXIT.                      
           MOVE ZEROS                  TO WS-HOLD-STATE-TAX-AMT         
                                          WS-HOLD-EXCISE-TAX-AMT        
                                          WS-HOLD-CITY-TAX-AMT          
                                          WS-HOLD-OTHER-TAX-AMT.        
           MOVE WS-CR                  TO WS-HOLD-TYPE.                 
           MOVE WS-101-ACCT-GEN-LED-CR TO WS-HOLD-GL-NO.                
           MOVE WS-101-AMT-POSTED      TO WS-HOLD-AMOUNT.               
           PERFORM 3420-GLADDA-020 THRU 3420-EXIT.                      
       3410-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3420-GLADDA-020.                                              *        
      *       DETERMINES FROM THE TYPE OF JRNL AND THE GL-LED NUMBER   *        
      *   WHETHER OR NOT TAXES EXITS, AND WHAT KIND OF TAXES.          *        
      *       THIS PARAGRAPH THEN MOVES THE INDIVIDUAL TAXES TO        *        
      *   HOLD-FIELDS AND DETERMINES THE TOTAL TAX AMOUNT.  ONCE THE   *        
      *   TOTAL TAX AMOUNT IS DETERMINED, IT IS SUBTRACTED FROM THE    *        
      *   TOTAL AMOUNT, THE TAXES ARE THEN HANDLED SEPERATELY.         *        
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3420-GLADDA-020.                                                 
           IF (WS-HOLD-GL-NO-MAJOR EQUAL WS-GL-142)                     
               OR (WS-NO-TAX-IS-ADDED)                                  
               PERFORM 3430-GLADDA-050 THRU 3430-EXIT                   
               GO TO 3420-EXIT
           END-IF.                                         
           IF WS-101-JRNL-FORMAT-NO EQUAL WS-102                        
               MOVE E-FCA07-USER-DEFINED-AREA TO CJF00102               
               MOVE WS-102-STAT-TAX-AMT       TO WS-HOLD-STATE-TAX-AMT  
               MOVE WS-102-XCIS-TAX-AMT       TO WS-HOLD-EXCISE-TAX-AMT 
               MOVE WS-102-CITY-TAX-AMT       TO WS-HOLD-CITY-TAX-AMT   
               MOVE WS-102-OTHER-TAX-AMT      TO WS-HOLD-OTHER-TAX-AMT  
           ELSE                                                         
           IF WS-101-JRNL-FORMAT-NO EQUAL WS-104                        
               MOVE E-FCA07-USER-DEFINED-AREA TO CJF00104               
               MOVE WS-104-STAT-TAX-AMT       TO WS-HOLD-STATE-TAX-AMT  
               MOVE ZEROS                     TO WS-HOLD-EXCISE-TAX-AMT 
               MOVE WS-104-CITY-TAX-AMT       TO WS-HOLD-CITY-TAX-AMT   
               MOVE WS-104-OTHER-TAX-AMT      TO WS-HOLD-OTHER-TAX-AMT
           END-IF
           END-IF. 
           ADD WS-HOLD-STATE-TAX-AMT                                    
               WS-HOLD-EXCISE-TAX-AMT                                   
               WS-HOLD-CITY-TAX-AMT                                     
               WS-HOLD-OTHER-TAX-AMT          TO WS-HOLD-TAX-TOTAL.     
           SUBTRACT WS-HOLD-TAX-TOTAL FROM WS-HOLD-AMOUNT.              
           PERFORM 3430-GLADDA-050 THRU 3430-EXIT.                      
       3420-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3430-GLADDA-050.                                              *        
      *       THIS PARAGRAPH DETERMINES IF THE GEN-LED NUMBER IS A     *        
      *   CASH ACCOUNT (135.XX) OR NOT, AND IF IT IS, THE PROGRAM      *        
      *   CHECKS TO MAKE SURE IT IS NOT A BATCH TRANSACTION.  IF IT    *        
      *   IS A CASH ACCOUNT AND A BATCH TRANSACTION, CONTROL IS PASSED *        
      *   THRU 3431-BATCH-ERROR AND NORMAL PROCESSING IS THEN CONTINUED.        
      *       THE GEN-LED NUMBER AND TOTAL TRANSACTION AMOUNT ARE THEN *        
      *   PASSED TO 3450-GLADDA-TABLE.  AFTER WHICH, THE INDIVIDUAL    *        
      *   TAX AMOUNTS AND THEIR RESPECTIVE GEN-LED NUMBERS ARE ALSO    *        
      *   PASSED THRU 3450-GLADDA-TABLE.                               *        
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3430-GLADDA-050.                                                 
AJC   * THE FOLLOWING PARAGRAPH CHANGED TO NOT WRITE WORKQUEUES ON BATCH        
      * CASH PAYMENTS.                                                          
           MOVE E-FCA07-LOCAL-OFFICE TO WS-HOLD-LOC-OFF.                
           IF WS-HOLD-GL-NO EQUAL WS-CLR-CASH-GL-NO (WS-GL-SUB)         
               IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-B                  
                   MOVE WS-A TO E-FCA10-REPORT-CENTER                   
               ELSE                                                     
5399               NEXT SENTENCE
               END-IF
           END-IF.                                       
           PERFORM 3450-GLADDA-TABLE THRU 3450-EXIT.                    
                                                                        
                                                                        
PCR290     IF WS-101-JRNL-FORMAT-NO EQUAL 102                           
PCR290        MOVE WS-HOLD-STATE-TAX-AMT  TO WS-HOLD-AMOUNT             
PCR290        MOVE WS-TAX-STAT-GL-NO (WS-GL-SUB) TO WS-HOLD-GL-NO       
PCR290        PERFORM 3450-GLADDA-TABLE THRU 3450-EXIT                  
PCR290     ELSE                                                         
PCR290        IF WS-101-JRNL-FORMAT-NO EQUAL 104                        
PCR290           MOVE WS-HOLD-STATE-TAX-AMT  TO WS-HOLD-AMOUNT          
TP9779           MOVE WS-TAX-SC-GL-NO (WS-GL-SUB) TO WS-HOLD-GL-NO      
PCR290           PERFORM 3450-GLADDA-TABLE THRU 3450-EXIT               
PCR290        END-IF                                                    
PCR290     END-IF.                                                      
           MOVE WS-HOLD-CITY-TAX-AMT   TO WS-HOLD-AMOUNT.               
           MOVE WS-TAX-CITY-GL-NO (WS-GL-SUB) TO WS-HOLD-GL-NO.         
           PERFORM 3450-GLADDA-TABLE THRU 3450-EXIT.                    
           MOVE WS-HOLD-OTHER-TAX-AMT  TO WS-HOLD-AMOUNT.               
           MOVE WS-TAX-OTHR-GL-NO (WS-GL-SUB) TO WS-HOLD-GL-NO.         
           PERFORM 3450-GLADDA-TABLE THRU 3450-EXIT.                    
       3430-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  3431-BATCH-ERROR.                                             *        
      *       CREATES THE REQUIRED RECORDS IN FCSCA10 FOR A BATCH      *        
      *   TRANSACTION INVOLVING CASH.  THE GEN-LED NUMBER OF 184.20.000*        
      *   IS THEN SUBSTITUTED IN THE GEN-LED-HOLD FIELD AND CONTROL IS *        
      *   PASSED BACK TO 3430 TO CONTINUE PROCESSING.                  *        
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
HEMA3 *3431-BATCH-ERROR.                                                        
HEMA3 *    MOVE E-FCA07-TRAN-DATE          TO E-FCA10-EXCEPTION-DATE.           
HEMA3 *    MOVE E-FCA07-COMPANY-NO         TO E-FCA10-COMPANY-NO.               
HEMA3 *    MOVE WS-010                     TO E-FCA10-EXCPTN-CATEGORY.          
HEMA3 *    MOVE WS-030                     TO E-FCA10-EXCPTN-TYPE.              
HEMA3 *    MOVE SPACES                     TO E-FCA10-EXCEPTION-ID.             
HEMA3 *    MOVE E-FCA07-RECORD-ID-ACCT-NO  TO WS-ACCT-NO-CA07.                  
HEMA3 *    MOVE WS-ACCT-NO-CA07            TO E-FCA10-EXCEPTION-ID.             
HEMA3 *    MOVE E-FCA07-LOCAL-OFFICE       TO E-FCA10-LOCAL-OFFICE.             
HEMA3 *    MOVE MSG-BATCH-POSTED-WITH-CASH TO E-FCA10-EXCEPTION-DESC.           
HEMA3 *    MOVE 1                          TO E-FCA10-LINE-CONTROL.             
HEMA3 *    MOVE 4                          TO E-FCA10-FORMAT-ID.                
HEMA3 *    MOVE MSG-BAT-NO                 TO E-FCA10-FIELD-1-4-DESC.           
HEMA3 *    MOVE E-FCA07-USER-ID            TO E-FCA10-FIELD-1-4-DATA.           
HEMA3 *    MOVE MSG-WITH                   TO E-FCA10-FIELD-2-4-DESC.           
HEMA3 *    MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB) TO MSG-ACASH-GL-NO.               
HEMA3 *    MOVE MSG-ACASH                  TO E-FCA10-FIELD-2-4-DATA            
HEMA3 *    MOVE MSG-SYSTEM                 TO E-FCA10-FIELD-3-4-DESC.           
HEMA3 *    MOVE MSG-POSTED-TO              TO E-FCA10-FIELD-3-4-DATA.           
HEMA3 *    MOVE MSG-GL-NO                  TO E-FCA10-FIELD-4-4-DESC.           
HEMA3 *    MOVE WS-CLR-PST-ER-GL-NO (WS-GL-SUB) TO MSG-CLR-CASH-GL-NO.          
HEMA3 *    MOVE MSG-CLR-CASH               TO E-FCA10-FIELD-4-4-DATA.           
HEMA3 *    MOVE 3431                       TO P-PARAGRAPH-NUMBER.               
HEMA3 *    PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT.                             
HEMA3 *3431-EXIT.                                                               
HEMA3 *    EXIT.                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *   IF THIS TRANSACTION DOES NOT INVOLVE CASH (135.XX), THE      *        
      *   GEN-LED NUMBER IS CHECKED TO SEE IF IT IS A CLEARING ACCOUNT *        
      *   (184.XX), IF SO, THE DIVISION MUST BE 000.                   *        
      *       IF THE TRANSACTION DOES NOT INVOLVE 184.XX, THE DIVISION *        
      *   NUMBER IS CHANGED SO THAT THIS TRANSACTION WILL BELONG TO A  *        
      *   DISTRICT (XX1).                                              *        
      *       IF THE TRANSACTION INVOLVES 184.24, THE DIVISION NUMBER  *        
      *   WILL NOT BE CHANGED.  THIS GL-NUMBER SHOULD NOT BE USED AND  *        
      *   THIS WAY IT WILL SHOW UP ON THE ERROR LISTING.               *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      * SJM - LOOK INTO THIS LOGIC AND THE COMMENT ABOUT DIV NUMBER             
      *       CHANGING TO A DISTRICT BY MOVING A 1 IN THE LAST BYTE             
HEMA3 *3440-GLADDA-TABLE-020.                                                   
HEMA3 *    IF WS-HOLD-GL-NO EQUAL WS-CLR-CASH-GL-NO (WS-GL-SUB)                 
HEMA3 *                        OR WS-CLR-AR-XFR-GL-NO (WS-GL-SUB)               
HEMA3 *                        OR WS-CLR-CK-ISS-GL-NO (WS-GL-SUB)               
HEMA3 *                        OR WS-CLR-MSTSUB-GL-NO (WS-GL-SUB)               
HEMA3 *       MOVE SPACES TO WS-HOLD-LOC-OFF                                    
HEMA3 *    ELSE                                                                 
HEMA3 *       MOVE E-FCA07-LOCAL-OFFICE TO WS-HOLD-LOC-OFF.                     
HEMA3 *3440-EXIT.                                                               
HEMA3 *    EXIT.                                                                
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *       IF THE HOLD-AMOUNT IS 0, THERE IS NO USE FOR FURTHER     *        
      *   PROCESSING SO THAT TRANSACTION FALLS THRU.                   *        
      *   IF HOLD AMOUNT IS GREATER THAN ZERO, UPDATE THE DETAIL       *        
      *   FIOCA09 TABLE, EITHER BY UPDATING AN EXISTING OCCURRENCE OR  *        
      *   ADDING A NEW ONE. PRIOR TO ADDING A NEW OCCURRENCE, THE      *        
      *   SUMMARY GL TABLE MUST BE CHECKED TO ENSURE THAT THE GL NUMBER*        
      *   EXIST IN THE TABLE. IF IT DOES NOT, THEN GL NUMBER 184.24.000*        
      *   WILL BE SUBSTITUDED FOR THE INVALID GL NUMBER.               *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      * SJM  GL NUMBER 184.24.000 NEEDS TO BE ADDRESSED                         
       3450-GLADDA-TABLE.                                               
           IF WS-HOLD-AMOUNT EQUAL 0                                    
               NEXT SENTENCE                                            
           ELSE                                                         
              IF E-FCA07-JRNL-FORMAT-NO = 105                           
TP9306           MOVE ZEROS                  TO E-FCA09-GL-ACCT-NO      
                 PERFORM 8004-WRITE-FIOCA09-JRNL-105 THRU 8004-EXIT     
              ELSE                                                      
                  MOVE WS-HOLD-LOC-OFF TO                               
                       WS-HOLD-CA09-DET-LOCAL-OFFICE                    
RS                MOVE WS-HOLD-GL-NO      TO                            
                       WS-HOLD-CA09-DET-GL-ACCT-NO                      
                  MOVE E-FCA07-COMPANY-NO TO                            
                       WS-HOLD-CA09-DET-COMPANY-NO                      
                  MOVE SPACES TO                                        
                       WS-HOLD-CA09-DET-FUNCTION-CODE                   
                  IF  WS-101-REVENUE-MONTH NUMERIC                      
                      IF  WS-101-REVENUE-MONTH GREATER ZEROES           
                          MOVE WS-101-REVENUE-MONTH TO                  
                               WS-HOLD-CA09-DET-REVENUE-MONTH           
                      ELSE                                              
PCR647                    MOVE WS-REVENUE-MONTH-COMMON TO               
PCR647                         WS-HOLD-CA09-DET-REVENUE-MONTH,          
PCR647                         WS-REVENUE-MONTH                         
                      END-IF                                            
                  ELSE                                                  
PCR647                MOVE WS-REVENUE-MONTH-COMMON TO                   
PCR647                     WS-HOLD-CA09-DET-REVENUE-MONTH,              
PCR647                     WS-REVENUE-MONTH                             
                  END-IF                                                
                  PERFORM 3460-GLADDA-TABLE-060 THRU 3460-EXIT
              END-IF
           END-IF.         
       3450-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *   CHECK THE WS-FIOCA09-DET-TABLE FOR THE GIVEN KEY             *        
      *     (COMPANY/LOCAL OFFICE/GL NUBER/FUNCTION CODE)              *        
      *   IF THE CORRECT RECORD EXISTS, THE APPROPRIATE JRNL-ACTIVITY  *        
      *   FIELD IS UPDATED AND THE RECORD IS RE-WRITTEN.               *        
      *   IF THE CORRECT RECORD IS NOT FOUND, CONTROL IS TRANSFERRED   *        
      *   TO 3470-GLADDA-TABLE-070  WHERE THE WS-FIOCA09-TABLE IS      *        
      *   CHECKED TO SEE IF THE COMPANY/LOCAL OFFICE/GL NUMBER EXIST   *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3460-GLADDA-TABLE-060.                                           
           PERFORM 7000-SEARCH-WS-FIOCA09-DET  THRU 7000-EXIT.          
           IF  CA09-DET-FOUND                                           
               PERFORM 3500-UPDATE-FIOCA09-DET THRU 3500-EXIT           
           ELSE                                                         
               PERFORM 3470-GLADDA-TABLE-070   THRU 3470-EXIT
           END-IF.          
      *                                                                         
       3460-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  A MATCHING KEY WAS NOT FOUND IN THE FIOCA09 DETAIL TABLE, SO *         
      *  PRIOR TO ADDING THE ENTRY TO THE TABLE, THE FIOCA09 TABLE     *        
      *  IS CHECKED TO ENSURE THE COMPANY/LOCAL OFFICE/GL NUMBER ARE   *        
      *  VALID. IF THEY ARE VALID, THE ENTRY IS ADDED TO THE DETAIL    *        
      *  TABLE, OTHERWISE PROCESSING IS TRANSFERRRED TO 3480-GLADDA-   *        
      *  TABLE-080, WHICH HANDLES NON-EXISTENT GL NUMBERS              *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3470-GLADDA-TABLE-070.                                           
           PERFORM 7010-SEARCH-WS-FIOCA09   THRU 7010-EXIT.             
           IF CA09-NOT-FOUND                                            
              PERFORM 3480-GLADDA-TABLE-080 THRU  3480-EXIT             
              GO TO 3470-EXIT
           END-IF.                                          
                                                                        
      *  A RECORD WAS FOUND ON THE FIOCA09 TABLE, SO THE DATA CAN BE            
      *  ADDED TO THE DETAIL TABLE                                              
      *  A COUNT IS KEPT OF THE NUMBER OF RECORDS IN THE DETAIL TABLE           
      *  SO THAT THE COUNT CAN BE USED AS THE INDEX FOR ADDING NEW              
      *  RECORDS                                                                
           ADD 1 TO WS-CA09-DET-COUNT.                                  
           SET WS-CA09-DET-INDX TO WS-CA09-DET-COUNT.                   
           MOVE WS-HOLD-LOC-OFF TO                                      
                         WS-FCA09-DET-LOCAL-OFFICE (WS-CA09-DET-INDX).  
RS         MOVE WS-HOLD-GL-NO      TO                                   
                         WS-FCA09-DET-GL-ACCT-NO (WS-CA09-DET-INDX).    
           MOVE E-FCA07-COMPANY-NO TO                                   
                         WS-FCA09-DET-COMPANY-NO (WS-CA09-DET-INDX).    
           MOVE WS-FUNCTION-CODE TO                                     
                         WS-FCA09-DET-FUNCTION-CODE (WS-CA09-DET-INDX). 
           MOVE WS-HOLD-CA09-DET-REVENUE-MONTH TO                       
                         WS-FCA09-DET-REVENUE-MONTH (WS-CA09-DET-INDX). 
           MOVE ZEROES TO                                               
                         WS-FCA09-JRNL-ACTIVITY-DR (WS-CA09-DET-INDX)   
                         WS-FCA09-JRNL-ACTIVITY-CR (WS-CA09-DET-INDX).  
           IF WS-HOLD-TYPE EQUAL WS-DR                                  
               ADD WS-HOLD-AMOUNT TO WS-ACCUM-DR                        
                                     WS-ACCUM-DR-IND                    
                         WS-FCA09-JRNL-ACTIVITY-DR (WS-CA09-DET-INDX)   
           ELSE                                                         
               ADD WS-HOLD-AMOUNT TO WS-ACCUM-CR                        
                                     WS-ACCUM-CR-IND                    
                         WS-FCA09-JRNL-ACTIVITY-CR (WS-CA09-DET-INDX)
           END-IF.  
       3470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *   CONTROLS THE PROCESSING FOR A NON-EXISTING GEN-LED NUM.      *        
      *                                                                *        
      *       3700-CREATE-EXECPTION-ERROR CREATES THE EXCEPTION ERRORS *        
      *   IN EXCPTN-DISK-WORK-FILE (FCSCA10).                          *        
      *                                                                *        
      *       PROCESS IS PASSED TO 5100-LOAD-GL-TRAN-WORK-AREA, WHICH  *        
      *   LOADS THE GL-TRAN WORK AREA IN PREPARATION FOR CREATING A    *        
      *   NEW, SUBSTITUTE JRNL RECORD FOR THE INVALID GEN-LED NUMBER.  *        
      *                                                                *        
      *       184.24.000 IS THEN SUBSTITUTED FOR THE INVALID GL-LED    *        
      *   NUMBER.  FILE CA09  IS UPDATED BY ADDING THE AMOUNTS TO      *        
      *   ACCOUNT 184.24.000                                           *        
      *                                                                *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3480-GLADDA-TABLE-080.                                           
           PERFORM 3700-EXCEPTION-ERROR-ROUTINE THRU 3700-EXIT.         
HEMA1 *    PERFORM 5100-LOAD-GL-TRAN-WORK-AREA  THRU 5100-EXIT.                 
HEMA1 *    MOVE E-FCA07-USER-ID       TO WS-GL-TRAN-USER-ID.                    
HEMA1 *    MOVE WS-HOLD-CA09-DET-GL-ACCT-NO                                     
HEMA1 *                               TO WS-GL-TRAN-OFFSET-GL-ACCT-NO.          
HEMA1 *    MOVE WS-HOLD-CA09-DET-COMPANY-NO                                     
HEMA1 *                               TO WS-GL-TRAN-OFFSET-COMPANY-NO.          
HEMA1 *    MOVE WS-HOLD-CA09-DET-LOCAL-OFFICE                                   
HEMA1 *                               TO WS-GL-TRAN-OFFSET-LOCAL-OFFICE.        
           MOVE E-FCA07-RECORD-ID-ACCT-NO TO WS-ACCT-NO-CA07.           
           MOVE WS-ACCT-NO-CA07       TO E-FCA10-EXCEPTION-ID.          
           MOVE E-FCA07-LOCAL-OFFICE  TO E-FCA10-LOCAL-OFFICE.          
HEMA1 *    MOVE MSG-OFFSET-GL-NO-BAD  TO WS-GL-TRAN-TRAN-DESCRIPTION.           
HEMA1 *    MOVE SPACES                TO WS-GL-TRAN-RECORD-ID.                  
HEMA1 *    MOVE WS-HOLD-CA09-DET-GL-ACCT-NO                                     
HEMA1 *                               TO WS-GL-TRAN-GL-ACCT-NO.                 
HEMA1 *    MOVE WS-HOLD-CA09-DET-COMPANY-NO                                     
HEMA1 *                               TO WS-GL-TRAN-COMPANY-NO.                 
HEMA1 *    MOVE WS-HOLD-CA09-DET-LOCAL-OFFICE                                   
HEMA1 *                               TO WS-GL-TRAN-LOCAL-OFFICE.               
HEMA1 *    IF WS-HOLD-TYPE EQUAL WS-DR                                          
HEMA1 *        MOVE WS-D TO WS-GL-TRAN-CODE-DR-CR                               
HEMA1 *    ELSE                                                                 
HEMA1 *        MOVE WS-C TO WS-GL-TRAN-CODE-DR-CR.                              
      *  WRITE RECORD TO FIOCA04 FILE FOR INVALID GL NUMBER                     
HEMA1 *    PERFORM 5030-INSERT-KSDS-JRNL-RECORD THRU 5030-EXIT.                 
      *  SEARCH FIOCA09 TABLE FOR CLEARING ACCOUNT                              
           MOVE WS-HOLD-CA09-DET-LOCAL-OFFICE                           
                                         TO WS-HOLD-CA09-LOCAL-OFFICE.  
           MOVE WS-CLR-PST-ER-GL-NO (WS-GL-SUB)                         
                                         TO WS-HOLD-CA09-GL-ACCT-NO.    
           PERFORM 7010-SEARCH-WS-FIOCA09   THRU 7010-EXIT.             
           IF  CA09-NOT-FOUND                                           
TP8074         MOVE WS-HOLD-CA09-DET-LOCAL-OFFICE                       
TP8074                                         TO P-GL-LOC-OFF-NO       
TP8074         MOVE WS-HOLD-CA09-DET-COMPANY-NO                         
TP8074                                         TO P-GL-COMP-NO          
TP8074         MOVE WS-HOLD-CA09-DET-GL-ACCT-NO                         
TP8074                                         TO WS-UNPACK-GL-ACCT-NO  
TP8074         MOVE WS-GL-1ST-THREE-AN         TO WS-GL-1ST-THREE-DISP  
TP8074         MOVE WS-GL-2ND-FOUR-AN          TO WS-GL-2ND-FOUR-DISP   
TP8074         MOVE WS-GL-ACCT-NO-DISP         TO P-GL-ACCT-NO          
TP8074         MOVE WS-GL-ERROR-MSG            TO P-STATUS-KEY-ERROR-MSG
               MOVE WS-FCA09-STATUS            TO P-STATUS-KEY          
               MOVE 3480                       TO P-PARAGRAPH-NUMBER    
121204         PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT
           END-IF.   
121204                                                                  
      * THE CLEARING ACCOUNT WAS FOUND, SO UPDATE THE DETAIL TABLE              
      * THE WS-HOLD-CA09-DETAIL-KEY IS NOT RELOADED BECAUSE DATA WAS            
      * MOVED TO THE WS-HOLD-CA09-KEY WHICH IS A REDEFENITION OF                
      * THE DETAIL KEY.                                                         
                                                                        
           MOVE SPACES           TO WS-HOLD-CA09-DET-FUNCTION-CODE.     
           PERFORM 7000-SEARCH-WS-FIOCA09-DET  THRU 7000-EXIT.          
           IF  CA09-DET-FOUND                                           
               PERFORM 3500-UPDATE-FIOCA09-DET THRU 3500-EXIT           
           ELSE                                                         
               PERFORM 3470-GLADDA-TABLE-070   THRU 3470-EXIT
           END-IF.          
                                                                        
       3480-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *   IF A RECORD WITH A MATCHING KEY WAS FOUND IN THE FIOCA09     *        
      *   DETAIL TABLE, ADD THE AMOUNT TO EITHER THE DEBIT OR CREDIT   *        
      *   AMOUNT IN THE TABLE.                                         *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3500-UPDATE-FIOCA09-DET.                                         
           IF WS-HOLD-TYPE EQUAL WS-DR                                  
               ADD WS-HOLD-AMOUNT TO WS-ACCUM-DR                        
                                     WS-ACCUM-DR-IND                    
                         WS-FCA09-JRNL-ACTIVITY-DR (WS-CA09-DET-INDX)   
           ELSE                                                         
               ADD WS-HOLD-AMOUNT TO WS-ACCUM-CR                        
                                     WS-ACCUM-CR-IND                    
                          WS-FCA09-JRNL-ACTIVITY-CR (WS-CA09-DET-INDX)
           END-IF. 
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *       CONTROLS THE CREATION OF EXCEPTION-ERROR RECORDS IN      *        
      *   FCSCA10.  TWO RECORDS ARE TO BE CREATED FOR INVALID GEN-LED  *        
      *   NUMBERS, ONE HAS AN 'A' IN THE REPORT-CENTER CODE, THE OTHER *        
      *   HAS A 'Z'.                                                   *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3700-EXCEPTION-ERROR-ROUTINE.                                    
           MOVE WS-A    TO E-FCA10-REPORT-CENTER.                       
           PERFORM 3710-CREATE-EXCEPTION-ERROR THRU 3710-EXIT.          
           MOVE WS-Z    TO E-FCA10-REPORT-CENTER.                       
           PERFORM 3710-CREATE-EXCEPTION-ERROR THRU 3710-EXIT.          
       3700-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *       CREATES AND WRITES TO FCSCA10, THE EXCEPTION ERROR FOR   *        
      *   AN INVALID GEN-LED NUMBER.                                   *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       3710-CREATE-EXCEPTION-ERROR.                                     
           MOVE E-FCA07-TRAN-DATE      TO E-FCA10-EXCEPTION-DATE.       
           MOVE E-FCA07-LOCAL-OFFICE   TO E-FCA10-LOCAL-OFFICE.         
           MOVE E-FCA07-COMPANY-NO     TO E-FCA10-COMPANY-NO.           
           MOVE WS-010                 TO E-FCA10-EXCPTN-CATEGORY.      
           MOVE WS-090                 TO E-FCA10-EXCPTN-TYPE.          
           MOVE E-FCA07-RECORD-ID-ACCT-NO                               
                                       TO WS-ACCT-NO-CA07.              
           MOVE WS-ACCT-NO-CA07        TO E-FCA10-EXCEPTION-ID.         
           MOVE MSG-INVALID-GL-ACCT    TO E-FCA10-EXCEPTION-DESC.       
           MOVE 1                      TO E-FCA10-LINE-CONTROL.         
           MOVE 4                      TO E-FCA10-FORMAT-ID.            
           MOVE MSG-GL-NO              TO E-FCA10-FIELD-1-4-DESC.       
           MOVE WS-LOC-OFF-KEY         TO WS-BAD-GL-NO-LOC-OFF-DISPLAY. 
           MOVE WS-GL-NO-MAJOR-KEY     TO WS-BAD-GL-NO-MAJOR-DISPLAY.   
           MOVE WS-GL-NO-MINOR-KEY     TO WS-BAD-GL-NO-MINOR-DISPLAY.   
           MOVE WS-HOLD-TYPE           TO WS-BAD-GL-NO-DR-CR-DISPLAY.   
           MOVE WS-BAD-GL-NO-DISPLAY   TO E-FCA10-FIELD-1-4-DATA.       
           MOVE MSG-CHNGED             TO E-FCA10-FIELD-2-4-DESC.       
           MOVE MSG-AND-POSTED-TO      TO E-FCA10-FIELD-2-4-DATA        
           MOVE MSG-GL-NO              TO E-FCA10-FIELD-3-4-DESC.       
           MOVE MSG-184-24-000         TO WS-BAD-GL-NO-DISPLAY.         
           MOVE WS-HOLD-TYPE           TO WS-BAD-GL-NO-DR-CR-DISPLAY.   
           MOVE WS-BAD-GL-NO-DISPLAY   TO E-FCA10-FIELD-3-4-DATA.       
           MOVE MSG-AMT                TO E-FCA10-FIELD-4-4-DESC.       
           MOVE WS-HOLD-AMOUNT         TO WS-HOLD-AMOUNT-DISPLAY.       
           MOVE WS-HOLD-AMOUNT-DISPLAY TO E-FCA10-FIELD-4-4-DATA.       
           MOVE 3710                   TO P-PARAGRAPH-NUMBER.           
           PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT.                     
       3710-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
HEMA1 *4000-GEN-LEDGER-TRAN-JRNL.                                               
HEMA1 *    READ FCSCA04-FILE NEXT RECORD                                        
HEMA1 *    IF FCA04-SUCCESSFUL                                                  
HEMA1 *        NEXT SENTENCE                                                    
HEMA1 *    ELSE                                                                 
HEMA1 *    IF WS-FCA04-STATUS = '10'                                            
HEMA1 *       MOVE WS-YES TO WS-LAST-SEQ-CA04-REC                               
HEMA1 *       GO TO 4000-EXIT                                                   
HEMA1 *    ELSE                                                                 
HEMA1 *       MOVE '***** READ ERROR - CA04 ' TO P-STATUS-KEY-ERROR-MSG         
HEMA1 *       MOVE WS-FCA04-STATUS TO P-STATUS-KEY                              
HEMA1 *       MOVE 4000 TO P-PARAGRAPH-NUMBER                                   
HEMA1 *       PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.            
HEMA1 *                                                                         
HEMA1 *    IF E-FCA04-KEY EQUAL LOW-VALUES                                      
HEMA1 *        GO TO 4000-EXIT.                                                 
HEMA1 *                                                                         
HEMA1 *    IF (E-FCA04-JRNL-FORMAT-NO > WS-200)                                 
HEMA1 *     AND (E-FCA04-JRNL-FORMAT-NO < WS-211)                               
HEMA1 *           MOVE FIOCA04 TO FIOCA07                                       
HEMA1 *           PERFORM 4500-WASH-BUCKET-ADD-ROUTINE THRU 4500-EXIT.          
HEMA1 *                                                                         
HEMA1 *4000-EXIT.                                                               
HEMA1 *    EXIT.                                                                
      *                                                                         
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *  4500-WASH-BUCKET-ADD-ROUTINE.                                 *        
      *      IF THIS IS A SYSTEM-GENERATED TRANSACTION (E-CODE-ENTRY-  *        
      *   SOURCE-FCSCA07 EQUAL AN 'S') IT DROPS THRU THIS LOGIC.       *        
      *                                                                *        
      *       DEPENDING ON WHETHER IT IS A BATCH TRANSACTION OR A CASH-*        
      *   DRAWER TRANSACTION, THE AMOUNTS ARE ADDED TO THEIR RESPECTIVE*        
      *   RECORDS IN BATCH OR CASH-DRAWER TABLES.FOUND, CONTROL IS     *        
      *   PASSED TO 3500-GLADDA-TABLE-060 TO UPDATE THAT ACCOUNT ON THE*        
      *   GEN-LED-DISK-WORK FILE (FCSCA09).                            *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       4500-WASH-BUCKET-ADD-ROUTINE.                                    
           IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-S                      
               GO TO 4500-EXIT
           END-IF.                                         
           IF E-FCA07-JRNL-SORT-ID EQUAL WS-A                           
               MOVE E-FCA07-USER-DEFINED-AREA  TO CJF00101              
               IF WS-101-ACCT-GEN-LED-DR EQUAL WS-101-ACCT-GEN-LED-CR   
                   GO TO 4500-EXIT                                      
               ELSE                                                     
                   MOVE WS-101-AMT-POSTED      TO WS-AMT-POSTED         
                   MOVE WS-101-ACCT-GEN-LED-DR TO WS-ACCT-GEN-LED-DR    
                   MOVE WS-101-ACCT-GEN-LED-CR TO WS-ACCT-GEN-LED-CR    
                   MOVE WS-N                  TO WS-CASH-DRAWER-FOUND   
                   IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-A              
                      PERFORM 4520-CASH-DRAWER-TABLE-LOOK-UP            
                          THRU 4520-EXIT                                
                     IF CASH-DRAWER-FOUND                               
                        GO TO 4500-EXIT                                 
                     ELSE                                               
                       PERFORM 4510-BATCH-TABLE-LOOK-UP THRU 4510-EXIT  
                     END-IF                                             
                   END-IF                                               
                   IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-B              
                       PERFORM 4510-BATCH-TABLE-LOOK-UP THRU 4510-EXIT  
                   ELSE                                                 
                       PERFORM 4520-CASH-DRAWER-TABLE-LOOK-UP           
                           THRU 4520-EXIT
                   END-IF
               END-IF                               
           ELSE                                                         
           IF E-FCA07-JRNL-SORT-ID EQUAL WS-1                           
               MOVE E-FCA07-USER-DEFINED-AREA TO CJF00201               
               MOVE WS-201-AMT-POSTED         TO WS-AMT-POSTED          
               MOVE E-FCA07-GL-ACCT-NO        TO WS-GL-NO-BREAKDOWN     
               MOVE WS-GL-NO-BREAKDOWN-MAJOR  TO WS-GL-NO-MAJOR-M-M     
               MOVE WS-GL-NO-BREAKDOWN-MINOR  TO WS-GL-NO-MINOR-M-M     
               IF WS-201-CODE-DR-CR EQUAL WS-D                          
                   MOVE WS-GL-MAJOR-MINOR     TO WS-ACCT-GEN-LED-DR     
                   MOVE ZEROS                 TO WS-ACCT-GEN-LED-CR     
                   MOVE WS-N                  TO WS-CASH-DRAWER-FOUND   
                   IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-A              
                      PERFORM 4520-CASH-DRAWER-TABLE-LOOK-UP            
                          THRU 4520-EXIT                                
                     IF CASH-DRAWER-FOUND                               
                        GO TO 4500-EXIT                                 
                     ELSE                                               
                       PERFORM 4510-BATCH-TABLE-LOOK-UP THRU 4510-EXIT  
                     END-IF                                             
                   END-IF                                               
               ELSE                                                     
                   IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-B              
                       PERFORM 4510-BATCH-TABLE-LOOK-UP THRU 4510-EXIT  
                   ELSE                                                 
                      PERFORM 4520-CASH-DRAWER-TABLE-LOOK-UP            
                          THRU 4520-EXIT
                   END-IF
               END-IF                                
               ELSE                                                     
                   MOVE WS-GL-MAJOR-MINOR TO WS-ACCT-GEN-LED-CR         
                   MOVE ZEROS TO WS-ACCT-GEN-LED-DR                     
                   IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-B              
                       PERFORM 4510-BATCH-TABLE-LOOK-UP THRU 4510-EXIT  
                   ELSE                                                 
                       PERFORM 4520-CASH-DRAWER-TABLE-LOOK-UP           
                           THRU 4520-EXIT
                   END-IF
           END-IF
           END-IF.                              
       4500-EXIT.                                                       
           EXIT.                                                        
       4510-BATCH-TABLE-LOOK-UP.                                        
           MOVE E-FCA07-CASH-COMPANY-NO   TO                            
                WS-COMPANY-WASH-TABLE-KEY.                              
           MOVE E-FCA07-CASH-LOCAL-OFFICE TO                            
                WS-LOC-OFF-WASH-TABLE-KEY.                              
           MOVE E-FCA07-CASH-REPORT-NO    TO                            
                WS-RPT-NO-WASH-TABLE-KEY.                               
           MOVE E-FCA07-DATE-CASH-REPORT  TO                            
                WS-RPT-DATE-WASH-TABLE-KEY.                             
           MOVE E-FCA07-CASH-DRAWER-ID    TO                            
                WS-DRAWER-WASH-TABLE-KEY.                               
           SET WS-INDEX-BWT        TO 1.                                
           SEARCH WS-BATCH-WASH-TABLE-RECORD                            
               AT END                                                   
HEMA2 *            PERFORM 4530-FCSCA08-LOOK-UP THRU 4530-EXIT                  
                   GO TO 4510-EXIT                                      
               WHEN WS-ACTIVITY-SOURCE-BWT (WS-INDEX-BWT)               
                   EQUAL WS-WASH-TABLE-KEY                              
                   PERFORM 4511-UPDATE-BATCH-TABLE THRU 4511-EXIT.      
       4510-EXIT.                                                       
           EXIT.                                                        
       4511-UPDATE-BATCH-TABLE.                                         
            MOVE WS-ACCT-GEN-LED-DR TO WS-GL-NO-BREAKDOWN.              
            IF WS-ACCT-GEN-LED-DR EQUAL WS-CLR-CASH-GL-NO (WS-GL-SUB)   
                ADD WS-AMT-POSTED                                       
                    TO WS-CASH-DR-TOTAL-BWT (WS-INDEX-BWT)              
            ELSE                                                        
            IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                 
                ADD WS-AMT-POSTED                                       
                    TO WS-AR-DR-TOTAL-BWT (WS-INDEX-BWT)                
            ELSE                                                        
            IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL ZEROS                     
                NEXT SENTENCE                                           
            ELSE                                                        
                ADD WS-AMT-POSTED                                       
                    TO WS-GL-DR-TOTAL-BWT (WS-INDEX-BWT)
            END-IF
            END-IF
            END-IF.               
            MOVE WS-ACCT-GEN-LED-CR TO WS-GL-NO-BREAKDOWN.              
            IF WS-ACCT-GEN-LED-CR EQUAL WS-CLR-CASH-GL-NO (WS-GL-SUB)   
                ADD WS-AMT-POSTED                                       
                    TO WS-CASH-CR-TOTAL-BWT (WS-INDEX-BWT)              
            ELSE                                                        
            IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                 
                ADD WS-AMT-POSTED                                       
                    TO WS-AR-CR-TOTAL-BWT (WS-INDEX-BWT)                
            ELSE                                                        
            IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL ZEROS                     
                NEXT SENTENCE                                           
            ELSE                                                        
                ADD WS-AMT-POSTED                                       
                    TO WS-GL-CR-TOTAL-BWT (WS-INDEX-BWT)
            END-IF
            END-IF
            END-IF.               
       4511-EXIT.                                                       
           EXIT.                                                        
       4520-CASH-DRAWER-TABLE-LOOK-UP.                                  
           MOVE E-FCA07-CASH-COMPANY-NO   TO                            
                WS-COMPANY-WASH-TABLE-KEY.                              
           MOVE E-FCA07-CASH-LOCAL-OFFICE TO                            
                WS-LOC-OFF-WASH-TABLE-KEY.                              
           MOVE E-FCA07-CASH-REPORT-NO    TO                            
                WS-RPT-NO-WASH-TABLE-KEY.                               
           MOVE E-FCA07-DATE-CASH-REPORT  TO                            
                WS-RPT-DATE-WASH-TABLE-KEY.                             
           MOVE E-FCA07-CASH-DRAWER-ID    TO                            
                WS-DRAWER-WASH-TABLE-KEY.                               
                                                                        
           SET WS-INDEX-CDT TO 1.                                       
           SEARCH WS-CASH-DRWR-TABLE-RECORD                             
               AT END                                                   
HEMA2 *            IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-A                      
                      GO TO 4520-EXIT                                   
HEMA2 *            ELSE                                                         
HEMA2 *              PERFORM 4530-FCSCA08-LOOK-UP THRU 4530-EXIT                
HEMA2 *              GO TO 4520-EXIT                                            
HEMA2 *            END-IF                                                       
               WHEN WS-ACTIVITY-SOURCE-CDT (WS-INDEX-CDT)               
                   EQUAL WS-WASH-TABLE-KEY                              
                   MOVE WS-Y                  TO WS-CASH-DRAWER-FOUND   
                   PERFORM 4521-UPDATE-CASH-DRWR-TABLE THRU 4521-EXIT.  
       4520-EXIT.                                                       
           EXIT.                                                        
       4521-UPDATE-CASH-DRWR-TABLE.                                     
            MOVE WS-ACCT-GEN-LED-DR TO WS-GL-NO-BREAKDOWN.              
            IF WS-ACCT-GEN-LED-DR EQUAL WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-AMT-POSTED TO WS-CASH-DR-TOTAL-CDT (WS-INDEX-CDT) 
            ELSE                                                        
            IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                 
               ADD WS-AMT-POSTED TO WS-AR-DR-TOTAL-CDT (WS-INDEX-CDT)   
            ELSE                                                        
            IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL ZEROS                     
               NEXT SENTENCE                                            
            ELSE                                                        
               ADD WS-AMT-POSTED   TO WS-GL-DR-TOTAL-CDT (WS-INDEX-CDT)
            END-IF
            END-IF
            END-IF.
            MOVE WS-ACCT-GEN-LED-CR TO WS-GL-NO-BREAKDOWN.              
            IF WS-ACCT-GEN-LED-CR EQUAL WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-AMT-POSTED TO WS-CASH-CR-TOTAL-CDT (WS-INDEX-CDT) 
            ELSE                                                        
            IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                 
               ADD WS-AMT-POSTED TO WS-AR-CR-TOTAL-CDT (WS-INDEX-CDT)   
            ELSE                                                        
            IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL ZEROS                     
                NEXT SENTENCE                                           
            ELSE                                                        
                ADD WS-AMT-POSTED TO WS-GL-CR-TOTAL-CDT (WS-INDEX-CDT)
            END-IF
            END-IF
            END-IF. 
       4521-EXIT.                                                       
           EXIT.                                                        
HEMA2 *4530-FCSCA08-LOOK-UP.                                                    
HEMA2 *                                                                         
HEMA2 *    MOVE E-FCA07-CODE-ENTRY-SOURCE TO E-FCA08-ACTIVITY-TYPE.             
HEMA2 *    MOVE WS-WASH-TABLE-KEY         TO E-FCA08-ACTIVITY-SOURCE.           
HEMA2 *    MOVE MSG-READ-ERROR-FCSCA08    TO E-FCA10-EXCEPTION-DESC.            
HEMA2 *                                                                         
HEMA2 *    MOVE WS-COMPANY-WASH-TABLE-KEY TO WS-COMPANY-WASH-DISPLAY.           
HEMA2 *    MOVE WS-LOC-OFF-WASH-TABLE-KEY TO WS-LOC-OFF-WASH-DISPLAY.           
HEMA2 *    MOVE WS-RPT-NO-WASH-TABLE-KEY  TO WS-RPT-NO-WASH-DISPLAY.            
HEMA2 *    MOVE WS-RPT-DATE-WASH-TABLE-KEY                                      
HEMA2 *                                   TO WS-RPT-DATE-WASH-DISPLAY.          
HEMA2 *    MOVE WS-DRAWER-WASH-TABLE-KEY  TO WS-DRAWER-WASH-DISPLAY.            
HEMA2 *    READ FCSCA08-FILE.                                                   
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        MOVE '**** READ  ERROR - CA08 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        DISPLAY 'KEY = ' E-FCA08-KEY                                     
HEMA2 *        MOVE WS-FCA08-STATUS TO P-STATUS-KEY                             
HEMA2 *        MOVE 4530 TO P-PARAGRAPH-NUMBER                                  
HEMA2 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA2 *                                                                         
HEMA2 *     MOVE WS-ACCT-GEN-LED-DR  TO WS-GL-NO-BREAKDOWN.                     
HEMA2 *     IF WS-ACCT-GEN-LED-DR EQUAL WS-CLR-CASH-GL-NO (WS-GL-SUB)           
HEMA2 *         ADD WS-AMT-POSTED    TO E-FCA08-JRNL-CASH-DR-TOT                
HEMA2 *     ELSE                                                                
HEMA2 *     IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                         
HEMA2 *         ADD WS-AMT-POSTED    TO E-FCA08-JRNL-AR-DR-TOT                  
HEMA2 *     ELSE                                                                
HEMA2 *     IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL ZEROS                             
HEMA2 *         NEXT SENTENCE                                                   
HEMA2 *     ELSE                                                                
HEMA2 *         ADD WS-AMT-POSTED    TO E-FCA08-JRNL-GL-DR-TOT.                 
HEMA2 *                                                                         
HEMA2 *     MOVE WS-ACCT-GEN-LED-CR  TO WS-GL-NO-BREAKDOWN.                     
HEMA2 *     IF WS-ACCT-GEN-LED-CR EQUAL WS-CLR-CASH-GL-NO (WS-GL-SUB)           
HEMA2 *         ADD WS-AMT-POSTED    TO E-FCA08-JRNL-CASH-CR-TOT                
HEMA2 *     ELSE                                                                
HEMA2 *     IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                         
HEMA2 *         ADD WS-AMT-POSTED    TO E-FCA08-JRNL-AR-CR-TOT                  
HEMA2 *     ELSE                                                                
HEMA2 *     IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL ZEROS                             
HEMA2 *         NEXT SENTENCE                                                   
HEMA2 *     ELSE                                                                
HEMA2 *         ADD WS-AMT-POSTED    TO E-FCA08-JRNL-GL-CR-TOT.                 
HEMA2 *                                                                         
HEMA2 *    REWRITE FIOCA08.                                                     
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        MOVE '**** WRITE ERROR - CA08 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        MOVE WS-FCA08-STATUS TO P-STATUS-KEY                             
HEMA2 *        MOVE 4530 TO P-PARAGRAPH-NUMBER                                  
HEMA2 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA2 *4530-EXIT.                                                               
HEMA2 *    EXIT.                                                                
HEMA2 *    EJECT                                                                
HEMA1 *************************************************************             
HEMA1 * WRITE FIOCA04 JOURNAL RECORD FROM WORKING STORAGE GL-TRANS              
HEMA1 *************************************************************             
HEMA1 *5030-INSERT-KSDS-JRNL-RECORD.                                            
HEMA1 *                                                                         
HEMA1 *    MOVE WS-GL-TRAN TO FIOCA04.                                          
HEMA1 *    MOVE WS-YES     TO WS-IS-DUP-KEY-ELIMINATED.                         
HEMA1 *    WRITE FIOCA04.                                                       
HEMA1 *    IF FCA04-SUCCESSFUL                                                  
HEMA1 *        NEXT SENTENCE                                                    
HEMA1 *    ELSE                                                                 
HEMA1 *    IF WS-FCA04-STATUS EQUAL '22'                                        
HEMA1 *        MOVE WS-NO TO WS-IS-DUP-KEY-ELIMINATED                           
HEMA1 *        PERFORM 5031-PROCESS-DUP-KEY THRU 5031-EXIT                      
HEMA1 *            UNTIL WS-DUP-KEY-IS-ELIMINATED                               
HEMA1 *    ELSE                                                                 
HEMA1 *        MOVE '**** WRITE ERROR - CA04 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA1 *        MOVE WS-FCA04-STATUS TO P-STATUS-KEY                             
HEMA1 *        MOVE 5030 TO P-PARAGRAPH-NUMBER                                  
HEMA1 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA1 *5030-EXIT.                                                               
HEMA1 *    EXIT.                                                                
HEMA1 *5031-PROCESS-DUP-KEY.                                                    
HEMA1 *    ADD 1 TO WS-DUP-NO-INCREMENT.                                        
HEMA1 *    IF WS-DUP-NO-INCREMENT EQUAL 999                                     
HEMA1 *        DISPLAY 'EXCEEDED DUPLICATE NUMBER LIMIT IN FCSCA04'             
HEMA1 *        PERFORM 9900-ABEND THRU 9900-EXIT.                               
HEMA1 *    MOVE WS-DUP-NO-INCREMENT TO E-FCA04-DUP-CONTROL-NO.                  
HEMA1 *    WRITE FIOCA04.                                                       
HEMA1 *    IF FCA04-SUCCESSFUL                                                  
HEMA1 *        MOVE WS-YES TO WS-IS-DUP-KEY-ELIMINATED                          
HEMA1 *        MOVE ZERO TO WS-DUP-NO-INCREMENT                                 
HEMA1 *    ELSE                                                                 
HEMA1 *    IF WS-FCA04-STATUS EQUAL '22'                                        
HEMA1 *        NEXT SENTENCE                                                    
HEMA1 *    ELSE                                                                 
HEMA1 *        MOVE '**** WRITE ERROR - CA04 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA1 *        MOVE WS-FCA04-STATUS TO P-STATUS-KEY                             
HEMA1 *        MOVE 5031 TO P-PARAGRAPH-NUMBER                                  
HEMA1 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA1 *5031-EXIT.                                                               
HEMA1 *    EXIT.                                                                
HEMA1 *5100-LOAD-GL-TRAN-WORK-AREA.                                             
HEMA1 *    MOVE WS-1                 TO WS-GL-TRAN-JRNL-SORT-ID.                
HEMA1 *    MOVE WS-CURRENT-DATE-CYMD TO WS-GL-TRAN-TRAN-DATE.                   
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-TRAN-TIME.                   
HEMA1 *    MOVE WS-GA01              TO WS-GL-TRAN-CODE-TERMINAL-TRAN.          
HEMA1 *    MOVE WS-1                 TO WS-GL-TRAN-JRNL-TRAN-APPL-NO.           
HEMA1 *    MOVE ZEROS                TO WS-GL-TRAN-DUP-CONTROL-KEY.             
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-DATE-LAST-ACTION.            
HEMA1 *    MOVE WS-S                 TO WS-GL-TRAN-CODE-ENTRY-SOURCE.           
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-USER-ID.                     
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-CASH-COMPANY-NO.             
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-CASH-LOCAL-OFFICE.           
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-CASH-REPORT-NO.              
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-DATE-CASH-REPORT.            
HEMA1 *    MOVE ZEROES               TO WS-GL-TRAN-CASH-DRAWER-ID.              
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-TRANS-ERRORS.                
HEMA1 *    MOVE WS-201               TO WS-GL-TRAN-JRNL-FORMAT-NO.              
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-CASH-DRAWER-USED.            
HEMA1 *    MOVE ZEROS                TO WS-GL-TRAN-AMT-ENTERED                  
HEMA1 *                                 WS-GL-TRAN-AMT-POSTED.                  
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-CODE-DR-CR.                  
HEMA1 *    MOVE WS-ACCTNG-PER-DATE-CYM TO                                       
HEMA1 *                                 WS-GL-TRAN-ACCTING-PERIOD.              
HEMA1 *    MOVE WS-E                 TO WS-GL-TRAN-CODE-JRNL-ENT-SRCE.          
HEMA1 *    MOVE ZEROS                TO WS-GL-TRAN-JRNL-ENT-NO.                 
HEMA1 *    MOVE ZEROS                TO WS-GL-TRAN-OFFSET-COMPANY-NO.           
HEMA1 *    MOVE ZEROS                TO WS-GL-TRAN-OFFSET-GL-ACCT-NO.           
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-OFFSET-LOCAL-OFFICE.         
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-FUNCTION-CODE.               
HEMA1 *    MOVE ZEROS                TO WS-GL-TRAN-COST-CENTER.                 
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-COST-CODE-TYPE.              
HEMA1 *    MOVE ZEROS                TO WS-GL-TRAN-NOE-CODE.                    
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-WORK-ORDER-NO.               
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-RESP-ID.                     
HEMA1 *    MOVE SPACES               TO WS-GL-TRAN-TRAN-DESCRIPTION.            
HEMA1 *                                                                         
HEMA1 *5100-EXIT.                                                               
HEMA1 *    EXIT.                                                                
HEMA1 *    EJECT                                                                
HEMA2 *6000-WASH-BUCKET-CLEAR-RTNE.                                             
HEMA2 *    SET WS-INDEX-BWT TO 1.                                               
HEMA2 *    PERFORM 6100-CLEAR-BATCH-WASH-TABLES THRU 6100-EXIT                  
HEMA2 *        VARYING WS-INDEX-BWT FROM 1 BY 1                                 
HEMA2 *            UNTIL WS-INDEX-BWT GREATER THAN 1000                         
HEMA2 *                OR WS-CASH-COMPANY-NO-BWT (WS-INDEX-BWT)                 
HEMA2 *                    EQUAL SPACES                                         
HEMA2 *                       OR LOW-VALUES.                                    
HEMA2 *    SET WS-INDEX-CDT TO 1.                                               
HEMA2 *    PERFORM 6200-CLEAR-CASH-DRWR-TABLES THRU 6200-EXIT                   
HEMA2 *        VARYING WS-INDEX-CDT FROM 1 BY 1                                 
HEMA2 *            UNTIL WS-INDEX-CDT GREATER THAN 1000.                        
HEMA2 *    MOVE WS-ZERO-RECORD-CA08 TO E-FCA08-KEY.                             
HEMA2 *    START FCSCA08-FILE KEY GREATER THAN E-FCA08-KEY.                     
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *       MOVE WS-NO TO WS-LAST-SEQ-CA08-REC                                
HEMA2 *    ELSE                                                                 
HEMA2 *       IF FCA08-NOT-FOUND                                                
HEMA2 *          MOVE WS-YES TO WS-LAST-SEQ-CA08-REC                            
HEMA2 *       ELSE                                                              
HEMA2 *          MOVE '**** READ  ERROR - CA08 ' TO                             
HEMA2 *                                    P-STATUS-KEY-ERROR-MSG               
HEMA2 *          MOVE WS-FCA08-STATUS TO P-STATUS-KEY                           
HEMA2 *          MOVE 6000 TO P-PARAGRAPH-NUMBER                                
HEMA2 *          PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.         
HEMA2 *    PERFORM 6300-PROCESS-FCSCA08-SEQ THRU 6300-EXIT                      
HEMA2 *        UNTIL WS-THIS-IS-LAST-SEQ-CA08-REC.                              
HEMA2 *6000-EXIT.                                                               
HEMA2 *    EXIT.                                                                
HEMA2 *6100-CLEAR-BATCH-WASH-TABLES.                                            
HEMA2 *    IF WS-CASH-COMPANY-NO-BWT (WS-INDEX-BWT) EQUAL SPACES                
HEMA2 *                                                OR LOW-VALUES            
HEMA2 *        GO TO 6100-EXIT.                                                 
HEMA2 *    IF (WS-CASH-DR-TOTAL-BWT (WS-INDEX-BWT) EQUAL ZERO)                  
HEMA2 *        AND (WS-CASH-CR-TOTAL-BWT (WS-INDEX-BWT) EQUAL ZERO)             
HEMA2 *        AND (WS-AR-DR-TOTAL-BWT (WS-INDEX-BWT) EQUAL ZERO)               
HEMA2 *        AND (WS-AR-CR-TOTAL-BWT (WS-INDEX-BWT) EQUAL ZERO)               
HEMA2 *        AND (WS-GL-DR-TOTAL-BWT (WS-INDEX-BWT) EQUAL ZERO)               
HEMA2 *        AND (WS-GL-CR-TOTAL-BWT (WS-INDEX-BWT) EQUAL ZERO)               
HEMA2 *        AND (WS-CKI-DR-TOTAL-BWT (WS-INDEX-BWT) EQUAL ZERO)              
HEMA2 *        AND (WS-CKI-CR-TOTAL-BWT (WS-INDEX-BWT) EQUAL ZERO)              
HEMA2 *            GO TO 6100-EXIT.                                             
HEMA2 *    MOVE WS-B TO E-FCA08-ACTIVITY-TYPE.                                  
HEMA2 *    MOVE WS-ACTIVITY-SOURCE-BWT (WS-INDEX-BWT)                           
HEMA2 *        TO E-FCA08-ACTIVITY-SOURCE.                                      
HEMA2 *    READ FCSCA08-FILE.                                                   
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        MOVE '**** READ  ERROR - CA08 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        MOVE WS-FCA08-STATUS TO P-STATUS-KEY                             
HEMA2 *        MOVE 6100 TO P-PARAGRAPH-NUMBER                                  
HEMA2 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA2 *    ADD WS-CASH-DR-TOTAL-BWT (WS-INDEX-BWT)                              
HEMA2 *        TO E-FCA08-JRNL-CASH-DR-TOT.                                     
HEMA2 *    ADD WS-CASH-CR-TOTAL-BWT (WS-INDEX-BWT)                              
HEMA2 *        TO E-FCA08-JRNL-CASH-CR-TOT.                                     
HEMA2 *    ADD WS-AR-DR-TOTAL-BWT (WS-INDEX-BWT)                                
HEMA2 *        TO E-FCA08-JRNL-AR-DR-TOT.                                       
HEMA2 *    ADD WS-AR-CR-TOTAL-BWT (WS-INDEX-BWT)                                
HEMA2 *        TO E-FCA08-JRNL-AR-CR-TOT.                                       
HEMA2 *    ADD WS-GL-DR-TOTAL-BWT (WS-INDEX-BWT)                                
HEMA2 *        TO E-FCA08-JRNL-GL-DR-TOT.                                       
HEMA2 *    ADD WS-GL-CR-TOTAL-BWT (WS-INDEX-BWT)                                
HEMA2 *        TO E-FCA08-JRNL-GL-CR-TOT.                                       
HEMA2 *    ADD WS-CKI-DR-TOTAL-BWT (WS-INDEX-BWT)                               
HEMA2 *        TO E-FCA08-JRNL-CKI-DR-TOT.                                      
HEMA2 *    ADD WS-CKI-CR-TOTAL-BWT (WS-INDEX-BWT)                               
HEMA2 *        TO E-FCA08-JRNL-CKI-CR-TOT.                                      
HEMA2 *    REWRITE FIOCA08.                                                     
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        MOVE '**** WRITE ERROR - CA08 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        MOVE WS-FCA08-STATUS TO P-STATUS-KEY                             
HEMA2 *        MOVE 6100 TO P-PARAGRAPH-NUMBER                                  
HEMA2 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA2 *6100-EXIT.                                                               
HEMA2 *    EXIT.                                                                
HEMA2 *6200-CLEAR-CASH-DRWR-TABLES.                                             
HEMA2 *    IF WS-INDEX-CDT GREATER THAN 1000                                    
HEMA2 *        GO TO 6200-EXIT.                                                 
HEMA2 *    IF (WS-CASH-DR-TOTAL-CDT (WS-INDEX-CDT) EQUAL ZERO)                  
HEMA2 *        AND (WS-CASH-CR-TOTAL-CDT (WS-INDEX-CDT) EQUAL ZERO)             
HEMA2 *        AND (WS-AR-DR-TOTAL-CDT (WS-INDEX-CDT) EQUAL ZERO)               
HEMA2 *        AND (WS-AR-CR-TOTAL-CDT (WS-INDEX-CDT) EQUAL ZERO)               
HEMA2 *        AND (WS-GL-DR-TOTAL-CDT (WS-INDEX-CDT) EQUAL ZERO)               
HEMA2 *        AND (WS-GL-CR-TOTAL-CDT (WS-INDEX-CDT) EQUAL ZERO)               
HEMA2 *        AND (WS-CKI-DR-TOTAL-CDT (WS-INDEX-CDT) EQUAL ZERO)              
HEMA2 *        AND (WS-CKI-CR-TOTAL-CDT (WS-INDEX-CDT) EQUAL ZERO)              
HEMA2 *            GO TO 6200-EXIT.                                             
HEMA2 *    MOVE WS-C TO E-FCA08-ACTIVITY-TYPE.                                  
HEMA2 *    MOVE WS-ACTIVITY-SOURCE-CDT (WS-INDEX-CDT)                           
HEMA2 *        TO E-FCA08-ACTIVITY-SOURCE.                                      
HEMA2 *    READ FCSCA08-FILE.                                                   
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        MOVE '**** READ  ERROR - CA08 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        MOVE WS-FCA08-STATUS TO P-STATUS-KEY                             
HEMA2 *        MOVE 6200 TO P-PARAGRAPH-NUMBER                                  
HEMA2 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA2 *    ADD WS-CASH-DR-TOTAL-CDT (WS-INDEX-CDT)                              
HEMA2 *        TO E-FCA08-JRNL-CASH-DR-TOT.                                     
HEMA2 *    ADD WS-CASH-CR-TOTAL-CDT (WS-INDEX-CDT)                              
HEMA2 *        TO E-FCA08-JRNL-CASH-CR-TOT.                                     
HEMA2 *    ADD WS-AR-DR-TOTAL-CDT (WS-INDEX-CDT)                                
HEMA2 *        TO E-FCA08-JRNL-AR-DR-TOT.                                       
HEMA2 *    ADD WS-AR-CR-TOTAL-CDT (WS-INDEX-CDT)                                
HEMA2 *        TO E-FCA08-JRNL-AR-CR-TOT.                                       
HEMA2 *    ADD WS-GL-DR-TOTAL-CDT (WS-INDEX-CDT)                                
HEMA2 *        TO E-FCA08-JRNL-GL-DR-TOT.                                       
HEMA2 *    ADD WS-GL-CR-TOTAL-CDT (WS-INDEX-CDT)                                
HEMA2 *        TO E-FCA08-JRNL-GL-CR-TOT.                                       
HEMA2 *    ADD WS-CKI-DR-TOTAL-CDT (WS-INDEX-CDT)                               
HEMA2 *        TO E-FCA08-JRNL-CKI-DR-TOT.                                      
HEMA2 *    ADD WS-CKI-CR-TOTAL-CDT (WS-INDEX-CDT)                               
HEMA2 *        TO E-FCA08-JRNL-CKI-CR-TOT.                                      
HEMA2 *    REWRITE FIOCA08.                                                     
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *        MOVE '**** WRITE ERROR - CA08 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        MOVE WS-FCA08-STATUS TO P-STATUS-KEY                             
HEMA2 *        MOVE 6200 TO P-PARAGRAPH-NUMBER                                  
HEMA2 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA2 *6200-EXIT.                                                               
HEMA2 *    EXIT.                                                                
       COPY CPD00040.                                                           
       COPY CPD00037.                                                           
HEMA2 *6300-PROCESS-FCSCA08-SEQ.                                                
HEMA2 *    READ FCSCA08-FILE NEXT RECORD.                                       
HEMA2 *    IF FCA08-SUCCESSFUL                                                  
HEMA2 *        NEXT SENTENCE                                                    
HEMA2 *    ELSE                                                                 
HEMA2 *      IF WS-FCA08-STATUS EQUAL '10'                                      
HEMA2 *          MOVE WS-YES TO WS-LAST-SEQ-CA08-REC                            
HEMA2 *          GO TO 6300-EXIT                                                
HEMA2 *      ELSE                                                               
HEMA2 *        MOVE '**** READ  ERROR - CA08 ' TO P-STATUS-KEY-ERROR-MSG        
HEMA2 *        MOVE WS-FCA08-STATUS TO P-STATUS-KEY                             
HEMA2 *        MOVE 6300 TO P-PARAGRAPH-NUMBER                                  
HEMA2 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT.           
HEMA2 *6300-EXIT.                                                               
HEMA2 *    EXIT.                                                                
HEMA2 *6400-WASH-AREA-ERROR.                                                    
HEMA2 *    MOVE WS-Z                       TO E-FCA10-REPORT-CENTER.            
HEMA2 *    MOVE WS-TRAN-DATE-FCA10         TO E-FCA10-EXCEPTION-DATE.           
HEMA2 *    MOVE ZEROS                      TO E-FCA10-LOCAL-OFFICE.             
HEMA2 *    MOVE WS-010                     TO E-FCA10-EXCPTN-CATEGORY           
HEMA2 *                                       E-FCA10-EXCPTN-TYPE.              
HEMA2 *    MOVE E-FCA08-CASH-COMPANY-NO    TO                                   
HEMA2 *         WS-EXCPTN-CASH-COMPANY-NO.                                      
HEMA2 *    MOVE E-FCA08-CASH-LOCAL-OFFICE  TO                                   
HEMA2 *         WS-EXCPTN-CASH-LOCAL-OFFICE.                                    
HEMA2 *    MOVE E-FCA08-CASH-REPORT-NO     TO                                   
HEMA2 *         WS-EXCPTN-CASH-REPORT-NO.                                       
HEMA2 *    MOVE E-FCA08-DATE-CASH-REPORT   TO                                   
HEMA2 *         WS-EXCPTN-DATE-CASH-REPORT.                                     
HEMA2 *    MOVE E-FCA08-CASH-DRAWER-ID     TO                                   
HEMA2 *         WS-EXCPTN-CASH-DRAWER-ID.                                       
HEMA2 *    MOVE WS-EXCPTN-ID-WASH-ERROR    TO E-FCA10-EXCEPTION-ID.             
HEMA2 *    MOVE MSG-WASH-AREA-NO-WASH      TO E-FCA10-EXCEPTION-DESC.           
HEMA2 *    MOVE 1                          TO E-FCA10-LINE-CONTROL.             
HEMA2 *    MOVE 3                          TO E-FCA10-FORMAT-ID.                
HEMA2 *    MOVE MSG-ERROR                  TO E-FCA10-FIELD-1-3-DESC.           
HEMA2 *    MOVE WS-TOTAL-TYPE-ERROR        TO E-FCA10-FIELD-1-3-DATA.           
HEMA2 *    MOVE MSG-TOM                    TO E-FCA10-FIELD-2-3-DESC.           
HEMA2 *    MOVE WS-CNTRL-TOT-CA08-EDIT     TO E-FCA10-FIELD-2-3-DATA.           
HEMA2 *    MOVE MSG-JRNL                   TO E-FCA10-FIELD-3-3-DESC.           
HEMA2 *    MOVE WS-JRNL-TOT-CA08-EDIT      TO E-FCA10-FIELD-3-3-DATA.           
HEMA2 *    MOVE 6400                       TO P-PARAGRAPH-NUMBER.               
HEMA2 *    PERFORM 7900-WRITE-FCA10 THRU 7900-EXIT.                             
HEMA2 *6400-EXIT.                                                               
HEMA2 *    EXIT.                                                                
HEMA2 *    EJECT                                                                
      *                                                                         
      ******************************************************************        
      * SEARCH THE FIOCA09 DETAIL TABLE FOR AN ENTRY WITH A MATCHING   *        
      * COMPANY/LOCAL OFFICE/GENERAL LEDGER NUMBER/FUNCTION CODE       *        
      ******************************************************************        
       7000-SEARCH-WS-FIOCA09-DET.                                      
           MOVE  WS-N   TO  WS-CA09-DET-FLAG.                           
           SET  WS-CA09-DET-INDX   TO  +1.                              
           SEARCH   WS-FIOCA09-DET                                      
               AT  END                                                  
                   MOVE  WS-N  TO  WS-CA09-DET-FLAG                     
               WHEN WS-FCA09-DETAIL-KEY (WS-CA09-DET-INDX)              
                    EQUAL  WS-HOLD-CA09-DETAIL-KEY                      
                   MOVE  WS-Y  TO  WS-CA09-DET-FLAG.                    
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * DO A BINARY SEARCH ON THE FIOCA09 TABLE TO VALIDATE THE        *        
      * COMPANY/LOCAL OFFICE/GENERAL LEDGER NUMBER                     *        
      ******************************************************************        
       7010-SEARCH-WS-FIOCA09.                                          
121204     MOVE  WS-N   TO  WS-CA09-FLAG.                               
121204     SET  WS-CA09-INDX   TO  +1.                                  
           SEARCH ALL WS-FIOCA09                                        
121204         AT  END                                                  
121204             MOVE  WS-N  TO  WS-CA09-FLAG                         
               WHEN WS-FCA09-KEY (WS-CA09-INDX) EQUAL WS-HOLD-CA09-KEY  
                   MOVE  WS-Y  TO  WS-CA09-FLAG.                        
       7010-EXIT.                                                       
121204     EXIT.                                                        
      *                                                                         
       7050-READ-FCSCA07.                                               
           READ FCSCA07-FILE                                            
              AT END                                                    
                 GO TO 7050-EXIT.                                       
           ADD 1 TO WS-FCA07-RECORD-CNT.                                
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HEMA1 *7080-READ-FIRST-FCSCA04.                                                 
HEMA1 *    MOVE LOW-VALUES          TO E-FCA04-KEY.                             
HEMA1 *    START FCSCA04-FILE                                                   
HEMA1 *       KEY IS GREATER THAN E-FCA04-KEY.                                  
HEMA1 *    IF FCA04-SUCCESSFUL                                                  
HEMA1 *      READ FCSCA04-FILE NEXT RECORD                                      
HEMA1 *      IF FCA04-SUCCESSFUL                                                
HEMA1 *        NEXT SENTENCE                                                    
HEMA1 *      ELSE                                                               
HEMA1 *        MOVE '*** READ ERROR - CA04' TO P-STATUS-KEY-ERROR-MSG           
HEMA1 *        MOVE WS-FCA04-STATUS TO P-STATUS-KEY                             
HEMA1 *        MOVE 7080 TO P-PARAGRAPH-NUMBER                                  
HEMA1 *        PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT            
HEMA1 *       END-IF                                                            
HEMA1 *    ELSE IF WS-FCA04-STATUS = '23'                                       
HEMA1 *      MOVE WS-Y TO WS-FCA04-EMPTY-FLG                                    
HEMA1 *    ELSE                                                                 
HEMA1 *      MOVE '*** READ ERROR - CA04' TO P-STATUS-KEY-ERROR-MSG             
HEMA1 *      MOVE WS-FCA04-STATUS TO P-STATUS-KEY                               
HEMA1 *      MOVE 7080 TO P-PARAGRAPH-NUMBER                                    
HEMA1 *      PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT              
HEMA1 *    END-IF.                                                              
HEMA1 *                                                                         
HEMA1 *7080-EXIT.                                                               
HEMA1 *    EXIT.                                                                
      *                                                                         
       7100-OPEN-GL-ACCOUNT.                                            
090889     EXEC SQL                                                     
                OPEN GL_ACCOUNT                                         
090889     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

090889     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
090889     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
090889        NEXT SENTENCE                                             
090889     ELSE                                                         
090889         DISPLAY '** 7100-OPEN-GL-ACCOUNT'                        
T13946         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
090889         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
090889 7100-EXIT.                                                       
090889     EXIT.                                                        
      *                                                                         
       7110-FETCH-GL-ACCOUNT.                                           
090889     EXEC SQL                                                     
                FETCH GL_ACCOUNT   INTO                                 
                   :GL-COMPANY-NO,                                      
                   :GL-GL-ACCT-NO,                                      
                   :GL-LOCAL-OFFICE,                                    
                   :GL-DATE-LAST-TRANS,                                 
                   :GL-CODE-ACCT-STATUS,                                
                   :GO-GL-ACCT-NAME,                                    
P00641             :GO-GL-ACCT-NAME-DESC,                               
                   :GL-GL-DTL-CNTL-IND,                                 
                   :GL-ACCT-BALANCE,                                    
                   :GL-BEGIN-ACCT-BALANCE                               
090889     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
090889     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
090889          OR NOT-FOUND                                            
090889        NEXT SENTENCE                                             
090889     ELSE                                                         
090889         DISPLAY '** 7110-FETCH-GL-ACCOUNT'                       
T13946         DISPLAY '** COMPANY = ' GL-COMPANY-NO                    
T13946                 'LOCAL OFFICE = ' GL-LOCAL-OFFICE                
T13946                 'GL ACCT NO = ' GL-GL-ACCT-NO                    
T13946         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
090889         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
090889 7110-EXIT.                                                       
090889     EXIT.                                                        
      *                                                                         
       7120-CLOSE-GL-ACCOUNT.                                           
090889     EXEC SQL                                                     
                CLOSE GL_ACCOUNT                                        
090889     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
090889     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
090889     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
090889        NEXT SENTENCE                                             
090889     ELSE                                                         
090889         DISPLAY '** 7120-CLOSE-GL-ACCOUNT'                       
T13946         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
090889         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
090889 7120-EXIT.                                                       
090889     EXIT.                                                        
      ****************************************************************          
      * READ LOCAL OFFICE USER TABLE TO GET LOCAL OFFICE NAME        *          
      ****************************************************************          
       7500-SELECT-LOCAL-OFFICE.                                        
090889     EXEC SQL                                                     
              SELECT                                                    
                LOCAL_OFFICE_DESC                                       
              INTO :B1-LOCAL-OFFICE-DESC                                
              FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                       
              WHERE LOCAL_OFFICE = :B1-LOCAL-OFFICE                     
A02036                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*         LOCAL_OFFICE_DESC                                               
MFA-TR*       INTO :B1-LOCAL-OFFICE-DESC                                        
MFA-TR*       FROM CSS_LOCAL_OFFICE                                             
MFA-TR*       WHERE LOCAL_OFFICE = :B1-LOCAL-OFFICE                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

090889     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
090889     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
090889          OR NOT-FOUND                                            
090889        NEXT SENTENCE                                             
090889     ELSE                                                         
T13946         DISPLAY '** 7500-SELECT-LOCAL-OFFICE'                    
T13946         DISPLAY '** COMPANY = ' B1-COMPANY-NO                    
T13946                 'LOCAL OFFICE = ' B1-LOCAL-OFFICE                
T13946         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * READ COMPANY USER TABLE TO GET COMPANY NAME                  *          
      ****************************************************************          
       7510-SELECT-COMPANY.                                             
           EXEC SQL                                                     
              SELECT                                                    
                COMPANY_NAME                                            
              INTO :C7-COMPANY-NAME                                     
              FROM CSS_COMPANY WITH(READUNCOMMITTED)                            
              WHERE COMPANY_NO = :C7-COMPANY-NO                         
A02036                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*         COMPANY_NAME                                                    
MFA-TR*       INTO :C7-COMPANY-NAME                                             
MFA-TR*       FROM CSS_COMPANY                                                  
MFA-TR*       WHERE COMPANY_NO = :C7-COMPANY-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

090889     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
090889     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
090889        NEXT SENTENCE                                             
090889     ELSE                                                         
T13946         DISPLAY '** 7510-SELECT-COMPANY'                         
T13946         DISPLAY '** COMPANY = ' C7-COMPANY-NO                    
T13946         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * READ GL TABLE USING GL NUMBER TO GET DESCRIPTION             *          
      ****************************************************************          
       7530-SEL-GL-ACCT-NAME.                                           
TP5678*                                                               *         
TP5678*  PLEASE NOTE THAT THE FOLLOWING SQL SELECT WAS COMMENTED OUT  *         
TP5678*  SINCE THIS IS NO LONGER NECESSARY REQUEST WAS TO DROP PAY-DESC*        
TP5678*  INSTEAD THE NUMBER IS LOADED TO THE TARGET OF FUNDS FIELD     *        
TP5678*                                                               *         
TP5678     MOVE GO-GL-ACCT-NO  TO P-NON-142-TGT-DTJ.                    
TP5678*                                                               *         
       7530-EXIT.                                                       
090889     EXIT.                                                        
      *                                                                         
090889     EXEC SQL                                                             
090889          INCLUDE CPD00038                                                
090889     END-EXEC.                                                            
      *                                                                         
090889     EXEC SQL                                                             
090889          INCLUDE CPD00039                                                
090889     END-EXEC.                                                            
      *                                                                         
T30899******************************************************************        
T30899**  7550-SELECT-DATABASE                                        **        
T30899******************************************************************        
T30899*                                                                         
T30899 7550-SELECT-DATABASE.                                            
T30899                                                                  
T30899     MOVE '7550'                   TO WS-ACTIVE-PARAGRAPH.        
T30899                                                                  
T30899     EXEC SQL                                                     
T30899        SELECT                                                    
T30899            DELINQ_VALUE                                          
T30899        INTO                                                      
T30899           :C8-DELINQ-VALUE                                       
T30899        FROM                                                      
T30899            CSS_DELINQUENCY WITH(READUNCOMMITTED)                         
T30899        WHERE                                                     
T30899            COMPANY_NO = :C8-COMPANY-NO                           
T30899        AND DELINQ_CD  = :C8-DELINQ-CD                            
A02036                                                           
T30899     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           DELINQ_VALUE                                                  
MFA-TR*       INTO                                                              
MFA-TR*          :C8-DELINQ-VALUE                                               
MFA-TR*       FROM                                                              
MFA-TR*           CSS_DELINQUENCY                                               
MFA-TR*       WHERE                                                             
MFA-TR*           COMPANY_NO = :C8-COMPANY-NO                                   
MFA-TR*       AND DELINQ_CD  = :C8-DELINQ-CD                                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T30899                                                                  
T30899     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T30899                                                                  
T30899     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T30899        NEXT SENTENCE                                             
T30899     ELSE                                                         
T30899        DISPLAY '**********************************************'  
T30899        DISPLAY '**    PROCESSING ERROR FOR DB2 TABLE         *'  
T30899        DISPLAY '**********************************************'  
T30899        DISPLAY '** PARAGRAPH         = ' WS-ACTIVE-PARAGRAPH     
T30899        DISPLAY '** TABLE NAME        =   CSS_DELINQUENCY'        
T30899        DISPLAY '** SQL STATUS        = ' WS-ACTIVE-RETURN-CODE   
T30899        DISPLAY '** DELINQUENCY CODE  = ' C8-DELINQ-CD            
T30899        DISPLAY '** COMPANY NO        = ' C8-COMPANY-NO           
T30899        DISPLAY '**********************************************'  
T30899        PERFORM 9900-ABEND         THRU 9900-EXIT                 
T30899     END-IF.                                                      
T30899                                                                  
T30899 7550-EXIT.                                                       
T30899     EXIT.                                                        
T30899*                                                                         
       7900-WRITE-FCA10.                                                
           WRITE FIOCA10.                                               
           IF FCA10-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-FCA10-RECORD-CNT = 0                                
                 DISPLAY '*******************************************'  
                 DISPLAY '*            PCSCA123    ERROR            *'  
                 DISPLAY  '* UNABLE TO WRITE PCSCA10 INIT RECORD    *'  
                 DISPLAY '*            PCSCA123  TERMINATED         *'  
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND THRU  9900-EXIT                     
              ELSE                                                      
                 DISPLAY '*******************************************'  
                 DISPLAY '*            PCSCA123    ERROR            *'  
                 DISPLAY  '* WRITE ERROR OCCURED FOR PFCA10         *'  
                 DISPLAY '*            PCSCA123  TERMINATED         *'  
                 DISPLAY '*******************************************'  
                 PERFORM 9900-ABEND THRU  9900-EXIT
              END-IF
           END-IF.                    
           ADD 1 TO WS-FCA10-RECORD-CNT.                                
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8000-PRINT-DTJ-RECORDS.                                          
           MOVE SPACES TO WS-DAILY-TRAN-JRNL-DETAIL.                    
           IF (E-FCA07-COMPANY-NO EQUAL WS-HOLD-DTJ-COMPANY)            
               AND (WS-LINE-NO-DTJ GREATER THAN 0)                      
                   NEXT SENTENCE                                        
           ELSE                                                         
               MOVE ZERO TO WS-LINE-NO-DTJ                              
               MOVE WS-YES TO WS-COMPANY-BREAK-SW                       
               ADD 1 TO WS-PAGE-NO-DTJ                                  
               PERFORM 8001-PRINT-DTJ-HEADER-LINES THRU 8001-EXIT       
               MOVE E-FCA07-COMPANY-NO TO WS-HOLD-DTJ-COMPANY
           END-IF.          
      *                                                                         
           IF (E-FCA07-LOCAL-OFFICE EQUAL WS-HOLD-DTJ-LOC-OFF)          
               AND (WS-LINE-NO-DTJ GREATER THAN 0)                      
                   NEXT SENTENCE                                        
           ELSE                                                         
               MOVE ZERO TO WS-LINE-NO-DTJ                              
               ADD 1 TO WS-PAGE-NO-DTJ                                  
               PERFORM 8001-PRINT-DTJ-HEADER-LINES THRU 8001-EXIT       
090889         MOVE E-FCA07-LOCAL-OFFICE TO WS-HOLD-DTJ-LOC-OFF
           END-IF.        
      *                                                                         
           MOVE E-FCA07-RECORD-ID-ACCT-NO TO WS-ACCT-NO-CA07.           
           IF (WS-ACCT-NO-CA07 EQUAL WS-HOLD-DTJ-ACCT-NO)               
               AND (WS-LINE-NO-DTJ GREATER THAN 9)                      
TP5678             MOVE SPACES TO P-ACCT-NO-DTJ                         
           ELSE                                                         
090889         MOVE E-FCA07-RECORD-ID-ACCT-NO TO P-ACCT-NO-DTJ          
TP5678                                           WS-HOLD-DTJ-ACCT-NO
           END-IF.   
      *                                                                         
      *  REFORMAT DATE FROM X(10) CCYY-MM-DD TO PRINT DATE MM/DD/YY             
TP9434     MOVE E-FCA07-TRAN-DATE(6:2)        TO P-DATE-DTJ(1:2).       
TP9434     MOVE E-FCA07-TRAN-DATE(9:2)        TO P-DATE-DTJ(4:2).       
           MOVE '/' TO P-DATE-DTJ(3:1)                                  
      *                                                                         
           MOVE WS-YES               TO WS-SHOULD-CASH-DRWR-BE-PRINTED. 
           MOVE E-FCA07-COMPANY-NO         TO WS-HOLD-DTJ-COMPANY.      
           MOVE E-FCA07-USER-ID            TO P-USER-ID-BATCH-NO-DTJ.   
           MOVE E-FCA07-CASH-LOCAL-OFFICE  TO P-FROM-LOC-DTJ.           
           MOVE E-FCA07-JRNL-FORMAT-NO     TO P-JRNL-CODE-DTJ.          
           MOVE E-FCA07-RECORD-ID-DATA     TO WS-RECORD-ID-DATA-CHECK.  
           MOVE E-FCA07-CODE-TERMINAL-TRAN TO P-TRAN-CODE-DTJ.          
           IF E-FCA07-CODE-ENTRY-SOURCE EQUAL WS-B                      
               MOVE WS-NO TO WS-SHOULD-CASH-DRWR-BE-PRINTED
           END-IF.            
           IF E-FCA07-JRNL-TRAN-APPL-NO EQUAL WS-1                      
               MOVE ZEROS TO WS-HOLD-SOURCE-OF-FUNDS
           END-IF.                   
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-101                       
               PERFORM 8010-JRNL-FORMAT-101 THRU 8010-EXIT              
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-102                       
               PERFORM 8020-JRNL-FORMAT-102 THRU 8020-EXIT              
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-103                       
               PERFORM 8030-JRNL-FORMAT-103 THRU 8030-EXIT              
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-104                       
               PERFORM 8040-JRNL-FORMAT-104 THRU 8040-EXIT              
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-105                       
               PERFORM 8050-JRNL-FORMAT-105 THRU 8050-EXIT              
           ELSE                                                         
           IF E-FCA07-JRNL-FORMAT-NO EQUAL WS-113                       
               PERFORM 8070-JRNL-FORMAT-113 THRU 8070-EXIT
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.             
           MOVE SPACES TO WS-DAILY-TRAN-JRNL-DETAIL.                    
           IF WS-LINE-NO-DTJ GREATER THAN 58                            
               MOVE ZERO TO WS-LINE-NO-DTJ
           END-IF.                             
       8000-EXIT.                                                       
           EXIT.                                                        
       8001-PRINT-DTJ-HEADER-LINES.                                     
           IF WS-COMPANY-BREAK-HAS-OCCURED                              
               MOVE E-FCA07-LOCAL-OFFICE TO WS-HOLD-DTJ-LOC-OFF         
               MOVE E-FCA07-COMPANY-NO   TO C7-COMPANY-NO               
               PERFORM 7510-SELECT-COMPANY THRU 7510-EXIT               
               MOVE WS-NO                TO WS-COMPANY-BREAK-SW         
TP8358         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
TP8358           MOVE C7-COMPANY-NAME    TO WS-INPT-CTR-FIELD           
TP8358           MOVE +26                TO WS-MAX-FIELD-LEN-3900       
TP8358           PERFORM 3900-CENTERING-ROUTINE      THRU 3900-EXIT     
TP8358           MOVE WS-OUTPUT-CTR-FIELD                               
TP8358                                   TO P-RPT1-COMP-NAME            
TP8358         ELSE                                                     
TP8358            MOVE SPACES            TO P-RPT1-COMP-NAME            
TP8358     END-IF
           END-IF.                                                      
      *                                                                         
TP8358     MOVE WS-PAGE-NO-DTJ TO P-RPT1-PAGE-NO.                       
TP8358     WRITE PRT33-RECORD FROM WS-PW-HEADER-LINE1                   
TP8358         AFTER ADVANCING TOP-OF-PAGE.                             
      *                                                                         
TP8358     MOVE WS-DEFAULT-RPT1-HEAD1    TO P-RPT1-HEAD1.               
TP8358     WRITE PRT33-RECORD FROM WS-PW-HEADER-LINE2                   
TP8358         AFTER ADVANCING 1 LINE.                                  
      *                                                                         
TP8358     MOVE WS-DEFAULT-RPT-HEAD2     TO P-RPT1-HEAD2.               
TP8358     WRITE PRT33-RECORD FROM WS-PW-HEADER-LINE3                   
TP8358         AFTER ADVANCING 1 LINE.                                  
      *                                                                         
           MOVE E-FCA07-LOCAL-OFFICE     TO B1-LOCAL-OFFICE.            
           MOVE E-FCA07-COMPANY-NO       TO B1-COMPANY-NO.              
           PERFORM 7500-SELECT-LOCAL-OFFICE THRU 7500-EXIT.             
090889     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE B1-LOCAL-OFFICE-DESC TO P-LOCAL-OFFICE-NAME-DTJ     
           ELSE                                                         
               MOVE SPACES               TO P-LOCAL-OFFICE-NAME-DTJ     
           END-IF.                                                      
      *                                                                         
           MOVE E-FCA07-LOCAL-OFFICE TO P-LOCAL-OFFICE-DTJ.             
           WRITE PRT33-RECORD FROM WS-DAILY-TRAN-JRNL-HDR-2             
TP8358         AFTER 2 LINES.                                           
           WRITE PRT33-RECORD FROM WS-DAILY-TRAN-JRNL-HDR-3             
TP8358         AFTER 2 LINES.                                           
           WRITE PRT33-RECORD FROM WS-DAILY-TRAN-JRNL-HDR-4             
               AFTER 1 LINES.                                           
           WRITE PRT33-RECORD FROM WS-DAILY-TRAN-JRNL-HDR-5             
               AFTER 1 LINES.                                           
           MOVE SPACES TO PRT33-RECORD.                                 
           WRITE PRT33-RECORD AFTER ADVANCING 1 LINES.                  
           ADD 9 TO WS-LINE-NO-DTJ.                                     
       8001-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * WRITE FIOCA09 FROM THE WS-FIOCA09-DETAIL-TABLE. A LOOKUP WILL  *        
      * NEED TO BE DONE ON THE WS-FIOCA09-TABLE TO GET ADDITIONAL      *        
      * INFORMATION NEEDED IN ORDER TO WRITE THE FIOCA09 RECORD.       *        
      * THE E-FCA09-TRAN-DATA WILL CONTAIN SPACES EXCEPT FOR JOURNAL   *        
      * 105 RECORDS WHICH ARE NOT PROCESSED BY THIS ROUTINE.           *        
      ******************************************************************        
121204 8002-WRITE-FCSCA09.                                              
           MOVE ZEROS             TO E-FCA09-GL-ACCT-NO.                
           PERFORM 8003-INITIALIZE-FIOCA09 THRU 8003-EXIT.              
           MOVE 'A'                  TO E-FCA09-RECORD-TYPE.            
           MOVE WS-FCA09-DETAIL-KEY (WS-CA09-DET-INDX)                  
                                     TO WS-HOLD-CA09-DETAIL-KEY.        
           MOVE WS-HOLD-CA09-DET-COMPANY-NO                             
                                     TO E-FCA09-COMPANY-NO.             
           MOVE WS-HOLD-CA09-DET-GL-ACCT-NO                             
                                     TO E-FCA09-GL-ACCT-NO.             
           MOVE WS-HOLD-CA09-DET-LOCAL-OFFICE                           
                                     TO E-FCA09-LOCAL-OFFICE.           
           MOVE WS-HOLD-CA09-DET-REVENUE-MONTH                          
                                     TO E-FCA09-REVENUE-MONTH.          
           MOVE WS-FCA09-JRNL-ACTIVITY-DR (WS-CA09-DET-INDX)            
                                     TO E-FCA09-JRNL-ACTIVITY-DR.       
           MOVE WS-FCA09-JRNL-ACTIVITY-CR (WS-CA09-DET-INDX)            
                                     TO E-FCA09-JRNL-ACTIVITY-CR.       
           PERFORM 7010-SEARCH-WS-FIOCA09 THRU 7010-EXIT.               
           IF CA09-FOUND                                                
              MOVE WS-FCA09-CODE-ACCT-STATUS (WS-CA09-INDX)             
                                     TO E-FCA09-CODE-ACCT-STATUS        
              MOVE WS-FCA09-UPDATE-CODES (WS-CA09-INDX)                 
                                     TO E-FCA09-UPDATE-CODES            
              MOVE  WS-FCA09-ACCT-DESC (WS-CA09-INDX)                   
                                     TO E-FCA09-ACCT-DESC               
              MOVE WS-FCA09-DATE-LAST-TRANS (WS-CA09-INDX)              
                                     TO E-FCA09-TRAN-DATE               
              MOVE WS-TIME-ZERO      TO E-FCA09-TRAN-TIME               
              MOVE WS-FCA09-EXTRACT-BALANCE (WS-CA09-INDX)              
                                     TO E-FCA09-EXTRACT-BALANCE
           END-IF.        
121204     WRITE FIOCA09.                                               
      **SJM-- IS THIS WHERE THE SEQUENCE NUMBER COMES IN OR DO I IGNORE         
      **SJM-- DUPLICATES LIKE THE BASE DOES?                                    
121204*************** DUPLICATE KEY ENCOUNTERED, CONTINUE PROCESSING            
121204     IF WS-FCA09-STATUS EQUAL '00' OR '22'                        
121204         NEXT SENTENCE                                            
121204     ELSE                                                         
121204         MOVE '**** WRITE ERROR - CA09 ' TO P-STATUS-KEY-ERROR-MSG
121204         MOVE WS-FCA09-STATUS TO P-STATUS-KEY                     
121204         MOVE 0510 TO P-PARAGRAPH-NUMBER                          
121204         PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT
           END-IF.   
121204 8002-EXIT.                                                       
121204     EXIT.                                                        
      ******************************************************************        
      * INITIALIZE FIOCA09 PRIOR TO MOVING DATA TO IT                  *        
      ******************************************************************        
       8003-INITIALIZE-FIOCA09.                                         
              MOVE ZEROS             TO E-FCA09-COMPANY-NO.             
              MOVE ZEROS             TO E-FCA09-LOCAL-OFFICE.           
              MOVE SPACES            TO E-FCA09-FUNCTION-CODE.          
              MOVE SPACES            TO E-FCA09-RECORD-TYPE.            
              MOVE ZEROS             TO E-FCA09-SEQUENCE-NO.            
              MOVE SPACES            TO E-FCA09-CODE-ACCT-STATUS.       
              MOVE SPACES            TO E-FCA09-UPDATE-CODES.           
              MOVE ZEROS             TO E-FCA09-JRNL-ACTIVITY-DR.       
              MOVE ZEROS             TO E-FCA09-JRNL-ACTIVITY-CR.       
              MOVE SPACES            TO E-FCA09-ACCT-DESC.              
              MOVE ZEROS             TO E-FCA09-EXTRACT-BALANCE.        
              MOVE WS-DATE-ZERO      TO E-FCA09-TRAN-DATE.              
              MOVE WS-TIME-ZERO      TO E-FCA09-TRAN-TIME.              
              MOVE SPACES            TO E-FCA09-USER-ID.                
              MOVE ZEROS             TO E-FCA09-REVENUE-MONTH.          
              MOVE SPACES            TO E-FCA09-TRAN-DATA.              
       8003-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *   JOURNAL 105 RECORDS ARE NOT WRITTEN TO THE WS-FIOCA09-DETAIL *        
      *   TABLE, AND INSTEAD ARE WRITTEN DIRECTLY TO THE FIOCA09 FILE  *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       8004-WRITE-FIOCA09-JRNL-105.                                     
           PERFORM 8003-INITIALIZE-FIOCA09 THRU 8003-EXIT.              
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00105                   
                                             CJF00101.                  
           MOVE E-FCA07-COMPANY-NO        TO E-FCA09-COMPANY-NO.        
           MOVE E-FCA07-LOCAL-OFFICE      TO E-FCA09-LOCAL-OFFICE.      
           MOVE WS-105-FUNCTION-CODE      TO E-FCA09-FUNCTION-CODE.     
           MOVE 'B'                       TO E-FCA09-RECORD-TYPE.       
           ADD 1                          TO WS-FCA09-SEQUENCE-NO.      
           MOVE WS-FCA09-SEQUENCE-NO      TO E-FCA09-SEQUENCE-NO.       
           MOVE E-FCA07-TRAN-DATE         TO E-FCA09-TRAN-DATE.         
           MOVE E-FCA07-TRAN-TIME         TO E-FCA09-TRAN-TIME.         
           MOVE E-FCA07-USER-ID           TO E-FCA09-USER-ID.           
           IF  WS-101-REVENUE-MONTH NUMERIC                             
               IF  WS-101-REVENUE-MONTH GREATER ZEROES                  
                   MOVE WS-101-REVENUE-MONTH TO                         
                        E-FCA09-REVENUE-MONTH                           
               ELSE                                                     
PCR647             MOVE WS-REVENUE-MONTH-COMMON TO                      
PCR647                  E-FCA09-REVENUE-MONTH,                          
PCR647                  WS-REVENUE-MONTH                                
               END-IF                                                   
           ELSE                                                         
PCR647         MOVE WS-REVENUE-MONTH-COMMON TO                          
PCR647              E-FCA09-REVENUE-MONTH,                              
PCR647              WS-REVENUE-MONTH                                    
           END-IF.                                                      
           MOVE E-FCA07-USER-DEFINED-AREA TO E-FCA09-TRAN-DATA.         
           IF WS-HOLD-TYPE EQUAL WS-DR                                  
TP9306        MOVE WS-105-ACCT-GEN-LED-DR TO E-FCA09-GL-ACCT-NO         
              ADD WS-HOLD-AMOUNT          TO WS-ACCUM-DR                
                                             WS-ACCUM-DR-ARM            
              MOVE WS-HOLD-AMOUNT         TO E-FCA09-JRNL-ACTIVITY-DR   
           ELSE                                                         
TP9306        MOVE WS-105-ACCT-GEN-LED-CR TO E-FCA09-GL-ACCT-NO         
              ADD WS-HOLD-AMOUNT          TO WS-ACCUM-CR                
                                             WS-ACCUM-CR-ARM            
              MOVE WS-HOLD-AMOUNT         TO E-FCA09-JRNL-ACTIVITY-CR
           END-IF.  
      *                                                                         
T11581     MOVE E-FCA09-COMPANY-NO        TO WS-HOLD-CA09-COMPANY-NO.   
T11581     MOVE E-FCA09-GL-ACCT-NO        TO WS-HOLD-CA09-GL-ACCT-NO.   
T11581     MOVE E-FCA09-LOCAL-OFFICE      TO WS-HOLD-CA09-LOCAL-OFFICE. 
T11581                                                                  
T11581     PERFORM 7010-SEARCH-WS-FIOCA09 THRU 7010-EXIT.               
T11581     IF CA09-FOUND                                                
T11581        MOVE WS-FCA09-ACCT-DESC(WS-CA09-INDX) TO E-FCA09-ACCT-DESC
T11581     END-IF.                                                      
      *                                                                         
           WRITE FIOCA09.                                               
           IF WS-FCA09-STATUS EQUAL '00'                                
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '**** WRITE ERROR - CA09 ' TO P-STATUS-KEY-ERROR-MSG
               MOVE WS-FCA09-STATUS TO P-STATUS-KEY                     
               MOVE 0510 TO P-PARAGRAPH-NUMBER                          
               PERFORM 8910-PRINT-STATUS-KEY-ERR-LINE THRU 8910-EXIT
           END-IF.   
       8004-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINT JOURNAL 101 FORMAT                                       *        
      ******************************************************************        
       8010-JRNL-FORMAT-101.                                            
           MOVE E-FCA07-USER-DEFINED-AREA     TO CJF00101.              
           IF WS-PRINT-CASH-DRAWER                                      
               MOVE E-FCA07-CASH-DRAWER-ID    TO P-CASH-DRAWER-DTJ
           END-IF.     
           IF E-FCA07-JRNL-TRAN-APPL-NO EQUAL 1                         
               OR WS-LINE-NO-DTJ EQUAL 9                                
                   MOVE WS-101-AMOUNT-ENTERED TO P-AMOUNT-ENTERED-DTJ
           END-IF.  
           MOVE WS-101-AMT-POSTED             TO P-AMOUNT-POSTED-DTJ.   
           MOVE WS-101-ACCT-GEN-LED-DR        TO WS-GL-NO-BREAKDOWN     
                                                 WS-GL-HOLD-DR.         
           MOVE WS-101-ACCT-GEN-LED-CR        TO WS-GL-HOLD-CR.         
           PERFORM 8150-CHECK-ADV-AR-TRANSFER THRU 8150-EXIT.           
           IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                  
               MOVE WS-CHG                    TO P-JRNL-DESC-DTJ        
               MOVE WS-101-ACCT-GEN-LED-DR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-DR                     TO P-DR-CR-DTJ            
               MOVE WS-101-ACCT-GEN-LED-CR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           ELSE                                                         
               MOVE WS-101-ACCT-GEN-LED-DR    TO WS-GL-NO-BREAKDOWN     
               MOVE WS-PMT                    TO P-JRNL-DESC-DTJ        
               MOVE WS-101-ACCT-GEN-LED-CR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-CR                     TO P-DR-CR-DTJ            
               MOVE WS-101-ACCT-GEN-LED-DR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           IF WS-CHECK-SOURCE-OF-FUNDS EQUAL WS-HOLD-SOURCE-OF-FUNDS    
T10138         CONTINUE                                                 
           ELSE                                                         
               MOVE WS-CHECK-SOURCE-OF-FUNDS TO WS-HOLD-SOURCE-OF-FUNDS
           END-IF
           END-IF.
           IF WS-101-ACCT-GEN-LED-DR EQUAL WS-101-ACCT-GEN-LED-CR       
               MOVE WS-ADJ                   TO P-JRNL-DESC-DTJ         
               MOVE SPACES                   TO P-DR-CR-DTJ
           END-IF.            
      **** FIND OUT OF THE FOLLOWING AGING VALUES WILL REMAIN THE SAME?         
      **** ADDITIONALLY, FIND OUT THE VALUES OF PP, FM AND CO                   
           IF WS-101-AR-AGE EQUAL WS-0                                  
               MOVE WS-00                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-101-AR-AGE EQUAL WS-3                                  
               MOVE WS-30                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-101-AR-AGE EQUAL WS-6                                  
               MOVE WS-60                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-101-AR-AGE EQUAL WS-9                                  
               MOVE WS-90                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-101-AR-AGE EQUAL WS-P                                  
               MOVE WS-PP                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-101-AR-AGE EQUAL WS-C                                  
               MOVE WS-CO                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-101-AR-AGE EQUAL WS-F                                  
               MOVE WS-FM                    TO P-AGE-DTJ               
           ELSE                                                         
               MOVE WS-101-AR-AGE TO P-AGE-DTJ
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                         
ESCHFX     IF WS-101-ACCT-END-AR-BAL IS NOT NUMERIC                     
ESCHFX        MOVE ZEROS TO WS-101-ACCT-END-AR-BAL                      
ESCHFX     END-IF.                                                      
ESCHFX     IF WS-101-ITEM-ID-NO IS NOT NUMERIC                          
ESCHFX        MOVE ZEROS TO WS-101-ITEM-ID-NO                           
ESCHFX     END-IF.                                                      
ESCHFX     IF WS-101-DETAIL-END-BAL IS NOT NUMERIC                      
ESCHFX        MOVE ZEROS TO WS-101-DETAIL-END-BAL                       
ESCHFX     END-IF.                                                      
ESCHFX     IF WS-101-DETAIL-END-AR-BAL IS NOT NUMERIC                   
ESCHFX        MOVE ZEROS TO WS-101-DETAIL-END-AR-BAL                    
ESCHFX     END-IF.                                                      
           MOVE WS-101-ACCT-END-AR-BAL TO P-ACCT-RCVBL-END-BAL-DTJ.     
           IF (WS-101-DETAIL-END-BAL EQUAL ZERO)                        
               AND (WS-101-DETAIL-END-AR-BAL EQUAL ZERO)                
                   AND (WS-101-ITEM-ID-NO EQUAL ZERO)                   
                   NEXT SENTENCE                                        
           ELSE                                                         
               MOVE WS-101-DETAIL-END-AR-BAL TO P-DETAIL-END-AR-BAL-DTJ 
               MOVE WS-101-ITEM-ID-NO        TO P-ITEM-ID-NO-DTJ        
               MOVE WS-101-DETAIL-END-BAL    TO P-DETAIL-END-BAL-DTJ
           END-IF.   
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD AFTER ADVANCING 1 LINES.                  
           ADD 1 TO WS-LINE-NO-DTJ.                                     
       8010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * PRINT JOURNAL 102 FORMAT                                       *        
      ******************************************************************        
       8020-JRNL-FORMAT-102.                                            
           MOVE E-FCA07-USER-DEFINED-AREA     TO CJF00102.              
           IF WS-PRINT-CASH-DRAWER                                      
               MOVE E-FCA07-CASH-DRAWER-ID    TO P-CASH-DRAWER-DTJ
           END-IF.     
           IF E-FCA07-JRNL-TRAN-APPL-NO EQUAL 1                         
               OR WS-LINE-NO-DTJ EQUAL 9                                
                   MOVE WS-102-AMOUNT-ENTERED TO P-AMOUNT-ENTERED-DTJ
           END-IF.  
           PERFORM 8021-PRINT-TAX-BREAKDOWN-102 THRU 8021-EXIT.         
           MOVE WS-HOLD-AMOUNT                TO P-AMOUNT-POSTED-DTJ.   
           MOVE ZEROS TO WS-HOLD-AREAS.                                 
           MOVE WS-102-ACCT-GEN-LED-DR        TO WS-GL-NO-BREAKDOWN     
                                                 WS-GL-HOLD-DR.         
           MOVE WS-102-ACCT-GEN-LED-CR        TO WS-GL-HOLD-CR.         
           PERFORM 8150-CHECK-ADV-AR-TRANSFER THRU 8150-EXIT.           
           IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                  
               MOVE WS-CHG                    TO P-JRNL-DESC-DTJ        
               MOVE WS-102-ACCT-GEN-LED-DR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-DR                     TO P-DR-CR-DTJ            
               MOVE WS-102-ACCT-GEN-LED-CR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           ELSE                                                         
               MOVE WS-102-ACCT-GEN-LED-DR    TO WS-GL-NO-BREAKDOWN     
               MOVE WS-PMT                    TO P-JRNL-DESC-DTJ        
               MOVE WS-102-ACCT-GEN-LED-CR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-CR                     TO P-DR-CR-DTJ            
               MOVE WS-102-ACCT-GEN-LED-DR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           IF WS-102-ACCT-GEN-LED-DR EQUAL WS-102-ACCT-GEN-LED-CR       
               MOVE WS-ADJ TO P-VARIABLE-FORM-INFO-DTJ                  
               MOVE SPACES TO P-DR-CR-DTJ
           END-IF
           END-IF.                              
           IF (WS-CHECK-SOURCE-OF-FUNDS EQUAL WS-HOLD-SOURCE-OF-FUNDS)  
               OR (WS-102-ACCT-GEN-LED-DR EQUAL WS-102-ACCT-GEN-LED-CR) 
T10138             CONTINUE                                             
           ELSE                                                         
               MOVE WS-CHECK-SOURCE-OF-FUNDS TO WS-HOLD-SOURCE-OF-FUNDS
           END-IF.
           IF WS-102-AR-AGE EQUAL WS-0                                  
               MOVE WS-00                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-102-AR-AGE EQUAL WS-3                                  
               MOVE WS-30                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-102-AR-AGE EQUAL WS-6                                  
               MOVE WS-60                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-102-AR-AGE EQUAL WS-9                                  
               MOVE WS-90                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-102-AR-AGE EQUAL WS-P                                  
               MOVE WS-PP                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-102-AR-AGE EQUAL WS-C                                  
               MOVE WS-CO                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-102-AR-AGE EQUAL WS-F                                  
               MOVE WS-FM                    TO P-AGE-DTJ               
           ELSE                                                         
               MOVE WS-102-AR-AGE            TO P-AGE-DTJ
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.              
           MOVE WS-102-ACCT-END-AR-BAL     TO P-ACCT-RCVBL-END-BAL-DTJ. 
           IF (WS-102-DETAIL-END-BAL EQUAL ZERO)                        
               AND (WS-102-DETAIL-END-AR-BAL EQUAL ZERO)                
                   AND (WS-102-ITEM-ID-NO EQUAL ZERO)                   
                   NEXT SENTENCE                                        
           ELSE                                                         
               MOVE WS-102-DETAIL-END-AR-BAL TO P-DETAIL-END-AR-BAL-DTJ 
               MOVE WS-102-ITEM-ID-NO        TO P-ITEM-ID-NO-DTJ        
               MOVE WS-102-DETAIL-END-BAL    TO P-DETAIL-END-BAL-DTJ
           END-IF.   
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           ADD 1 TO WS-LINE-NO-DTJ.                                     
       8020-EXIT.                                                       
            EXIT.                                                       
       8021-PRINT-TAX-BREAKDOWN-102.                                    
           MOVE WS-102-AMT-POSTED TO WS-HOLD-AMOUNT.                    
           MOVE WS-102-ACCT-GEN-LED-DR TO WS-GL-NO-BREAKDOWN.           
           IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                  
               MOVE WS-CHG             TO WS-P-JRNL-DESC-HOLD           
               MOVE WS-DR              TO WS-P-DR-CR-HOLD               
           ELSE                                                         
               MOVE WS-102-ACCT-GEN-LED-CR TO WS-GL-NO-BREAKDOWN        
               MOVE WS-PMT             TO WS-P-JRNL-DESC-HOLD           
               MOVE WS-CR              TO WS-P-DR-CR-HOLD               
               IF WS-GL-NO-BREAKDOWN-MAJOR NOT EQUAL WS-GL-142          
                   GO TO 8021-EXIT
               END-IF
           END-IF.                                     
           MOVE ZEROS TO WS-HOLD-TAX-TOTAL.                             
           MOVE WS-102-STAT-TAX-AMT    TO WS-HOLD-STATE-TAX-AMT.        
           MOVE WS-102-CITY-TAX-AMT    TO WS-HOLD-CITY-TAX-AMT.         
           MOVE WS-102-XCIS-TAX-AMT    TO WS-HOLD-EXCISE-TAX-AMT.       
           MOVE WS-102-OTHER-TAX-AMT   TO WS-HOLD-OTHER-TAX-AMT.        
           ADD WS-102-STAT-TAX-AMT                                      
               WS-102-CITY-TAX-AMT                                      
               WS-102-XCIS-TAX-AMT                                      
               WS-102-OTHER-TAX-AMT    TO WS-HOLD-TAX-TOTAL.            
           IF WS-HOLD-TAX-TOTAL EQUAL ZERO                              
               GO TO 8021-EXIT
           END-IF.                                         
           SUBTRACT WS-HOLD-TAX-TOTAL FROM WS-HOLD-AMOUNT.              
           IF WS-HOLD-STATE-TAX-AMT NOT EQUAL ZERO                      
               MOVE WS-HOLD-STATE-TAX-AMT TO P-AMOUNT-POSTED-DTJ        
               MOVE WS-P-DR-CR-HOLD       TO P-DR-CR-DTJ                
               MOVE WS-TAX-STAT-GL-NO (WS-GL-SUB) TO P-NON-142-ACCT-DTJ 
               MOVE WS-P-JRNL-DESC-HOLD   TO P-JRNL-DESC-DTJ            
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
*************  WRITE PRT33-RECORD FROM WS-DAILY-TRAN-JRNL-DETAIL                
                   AFTER ADVANCING 1 LINES                              
               ADD 1                      TO WS-LINE-NO-DTJ             
               MOVE SPACES                TO WS-DAILY-TRAN-JRNL-DETAIL
           END-IF. 
           IF WS-HOLD-CITY-TAX-AMT NOT EQUAL ZERO                       
               MOVE WS-P-JRNL-DESC-HOLD    TO P-JRNL-DESC-DTJ           
               MOVE WS-P-DR-CR-HOLD        TO P-DR-CR-DTJ               
               MOVE WS-TAX-CITY-GL-NO (WS-GL-SUB) TO P-NON-142-ACCT-DTJ 
               MOVE WS-HOLD-CITY-TAX-AMT   TO P-AMOUNT-POSTED-DTJ       
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
                   AFTER ADVANCING 1 LINES                              
               ADD 1                       TO WS-LINE-NO-DTJ            
               MOVE SPACES TO WS-DAILY-TRAN-JRNL-DETAIL
           END-IF.                
           IF WS-HOLD-OTHER-TAX-AMT NOT EQUAL ZERO                      
               MOVE WS-P-JRNL-DESC-HOLD    TO P-JRNL-DESC-DTJ           
               MOVE WS-P-DR-CR-HOLD        TO P-DR-CR-DTJ               
               MOVE WS-TAX-OTHR-GL-NO (WS-GL-SUB) TO P-NON-142-ACCT-DTJ 
               MOVE WS-HOLD-OTHER-TAX-AMT  TO P-AMOUNT-POSTED-DTJ       
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
                   AFTER ADVANCING 1 LINES                              
               ADD 1                       TO WS-LINE-NO-DTJ
           END-IF.           
       8021-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PRINT JOURNAL 103 FORMAT                                       *        
      ******************************************************************        
       8030-JRNL-FORMAT-103.                                            
           MOVE E-FCA07-USER-DEFINED-AREA     TO CJF00103.              
           IF WS-PRINT-CASH-DRAWER                                      
               MOVE E-FCA07-CASH-DRAWER-ID    TO P-CASH-DRAWER-DTJ
           END-IF.     
           IF E-FCA07-JRNL-TRAN-APPL-NO EQUAL 1                         
               OR WS-LINE-NO-DTJ EQUAL 9                                
                   MOVE WS-103-AMOUNT-ENTERED TO P-AMOUNT-ENTERED-DTJ
           END-IF.  
           MOVE WS-103-AMT-POSTED             TO P-AMOUNT-POSTED-DTJ.   
           MOVE WS-103-ACCT-GEN-LED-DR        TO WS-GL-NO-BREAKDOWN     
                                                 WS-GL-HOLD-DR.         
           MOVE WS-103-ACCT-GEN-LED-CR        TO WS-GL-HOLD-CR.         
           PERFORM 8150-CHECK-ADV-AR-TRANSFER THRU 8150-EXIT.           
           IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                  
TP5712       IF (WS-103-ACCT-GEN-LED-CR EQUAL WS-CLR-AR-XFR-GL-NO       
                                             (WS-GL-SUB)                
TP5712       OR WS-103-ACCT-GEN-LED-DR EQUAL WS-CLR-AR-XFR-GL-NO        
                                             (WS-GL-SUB)                
A01041       OR WS-103-ACCT-GEN-LED-CR EQUAL WS-CLR-MSTSUB-GL-NO        
A01041                                       (WS-GL-SUB)                
A01041       OR WS-103-ACCT-GEN-LED-DR EQUAL WS-CLR-MSTSUB-GL-NO        
A01041                                       (WS-GL-SUB))               
TP5712          MOVE WS-XFR                   TO P-JRNL-DESC-DTJ        
TP5712       ELSE                                                       
               MOVE WS-CHG                    TO P-JRNL-DESC-DTJ        
TP5712       END-IF                                                     
               MOVE WS-103-ACCT-GEN-LED-DR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-DR                     TO P-DR-CR-DTJ            
               MOVE WS-103-ACCT-GEN-LED-CR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           ELSE                                                         
               MOVE WS-103-ACCT-GEN-LED-DR    TO WS-GL-NO-BREAKDOWN     
TP5712         IF (WS-103-ACCT-GEN-LED-CR EQUAL                         
TP5712                                 WS-CLR-AR-XFR-GL-NO (WS-GL-SUB)  
TP5712         OR WS-103-ACCT-GEN-LED-DR EQUAL                          
TP5712                                 WS-CLR-AR-XFR-GL-NO (WS-GL-SUB)  
A01041         OR WS-103-ACCT-GEN-LED-CR EQUAL WS-CLR-MSTSUB-GL-NO      
A01041                                       (WS-GL-SUB)                
A01041         OR WS-103-ACCT-GEN-LED-DR EQUAL WS-CLR-MSTSUB-GL-NO      
A01041                                       (WS-GL-SUB))               
TP5712            MOVE WS-XFR                   TO P-JRNL-DESC-DTJ      
TP5712         ELSE                                                     
TP5712           MOVE WS-PMT                    TO P-JRNL-DESC-DTJ      
TP5712         END-IF                                                   
               MOVE WS-103-ACCT-GEN-LED-CR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-CR                     TO P-DR-CR-DTJ            
               MOVE WS-103-ACCT-GEN-LED-DR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           IF WS-103-ACCT-GEN-LED-DR EQUAL WS-103-ACCT-GEN-LED-CR       
               MOVE WS-ADJ TO P-VARIABLE-FORM-INFO-DTJ                  
               MOVE SPACES TO P-DR-CR-DTJ
           END-IF
           END-IF.                              
           IF (WS-CHECK-SOURCE-OF-FUNDS EQUAL WS-HOLD-SOURCE-OF-FUNDS)  
               OR (WS-103-ACCT-GEN-LED-DR EQUAL WS-103-ACCT-GEN-LED-CR) 
T10138             CONTINUE                                             
           ELSE                                                         
               MOVE WS-CHECK-SOURCE-OF-FUNDS TO WS-HOLD-SOURCE-OF-FUNDS
           END-IF.
           IF WS-103-AR-AGE EQUAL WS-0                                  
               MOVE WS-00                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-103-AR-AGE EQUAL WS-3                                  
               MOVE WS-30                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-103-AR-AGE EQUAL WS-6                                  
               MOVE WS-60                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-103-AR-AGE EQUAL WS-9                                  
               MOVE WS-90                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-103-AR-AGE EQUAL WS-P                                  
               MOVE WS-PP                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-103-AR-AGE EQUAL WS-C                                  
               MOVE WS-CO                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-103-AR-AGE EQUAL WS-F                                  
               MOVE WS-FM                    TO P-AGE-DTJ               
           ELSE                                                         
               MOVE WS-103-AR-AGE            TO P-AGE-DTJ
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.              
           MOVE WS-103-ACCT-END-AR-BAL     TO P-ACCT-RCVBL-END-BAL-DTJ. 
           IF (WS-103-DETAIL-END-BAL EQUAL ZERO)                        
               AND (WS-103-DETAIL-END-AR-BAL EQUAL ZERO)                
                   AND (WS-103-ITEM-ID-NO EQUAL ZERO)                   
                   NEXT SENTENCE                                        
           ELSE                                                         
               MOVE WS-103-DETAIL-END-AR-BAL TO P-DETAIL-END-AR-BAL-DTJ 
               MOVE WS-103-ITEM-ID-NO        TO P-ITEM-ID-NO-DTJ        
               MOVE WS-103-DETAIL-END-BAL    TO P-DETAIL-END-BAL-DTJ
           END-IF.   
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           ADD 1                           TO WS-LINE-NO-DTJ.           
           MOVE SPACES                     TO P-TENANT-INFO-DTJ         
                                              P-TRAN-ID-DTJ.            
           MOVE WS-103-TRAN-ACCT-NO        TO WS-ACCT-NO-CA07.          
           MOVE E-FCA07-LOCAL-OFFICE       TO P-XFR-ACCT-NO-DTJ.        
           MOVE WS-ACCT-NO-CA07            TO P-XFR-ACCT-NO-DTJ.        
           MOVE WS-DETAIL-RECORD-103-DTJ   TO P-VARIABLE-FORM-INFO-DTJ. 
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           ADD 1                           TO WS-LINE-NO-DTJ.           
       8030-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * PRINT JOURNAL 104 FORMAT                                       *        
      ******************************************************************        
       8040-JRNL-FORMAT-104.                                            
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00104.                  
           IF WS-PRINT-CASH-DRAWER                                      
               MOVE E-FCA07-CASH-DRAWER-ID    TO P-CASH-DRAWER-DTJ
           END-IF.     
           IF E-FCA07-JRNL-TRAN-APPL-NO EQUAL 1                         
               OR WS-LINE-NO-DTJ EQUAL 9                                
                   MOVE WS-104-AMOUNT-ENTERED TO P-AMOUNT-ENTERED-DTJ
           END-IF.  
           MOVE WS-104-AMT-POSTED TO WS-HOLD-AMOUNT.                    
      ****** TAX BREAKDOWN NOT PRINTED AT PRESENT TIME......                    
      ****** TO REACTIVATE TAX-BREAKDOWN, PERFORM 8041-PRINT-TAX                
           MOVE WS-HOLD-AMOUNT TO P-AMOUNT-POSTED-DTJ.                  
           MOVE ZEROS TO WS-HOLD-AREAS.                                 
           MOVE WS-104-ACCT-GEN-LED-DR TO WS-GL-NO-BREAKDOWN            
                                          WS-GL-HOLD-DR.                
           MOVE WS-104-ACCT-GEN-LED-CR TO WS-GL-HOLD-CR.                
           PERFORM 8150-CHECK-ADV-AR-TRANSFER THRU 8150-EXIT.           
           IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                  
               MOVE WS-CHG                    TO P-JRNL-DESC-DTJ        
               MOVE WS-104-ACCT-GEN-LED-DR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-DR                     TO P-DR-CR-DTJ            
               MOVE WS-104-ACCT-GEN-LED-CR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           ELSE                                                         
               MOVE WS-104-ACCT-GEN-LED-DR    TO WS-GL-NO-BREAKDOWN     
               MOVE WS-PMT                    TO P-JRNL-DESC-DTJ        
               MOVE WS-104-ACCT-GEN-LED-CR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-CR                     TO P-DR-CR-DTJ            
               MOVE WS-104-ACCT-GEN-LED-DR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           IF WS-104-ACCT-GEN-LED-DR EQUAL WS-104-ACCT-GEN-LED-CR       
               MOVE WS-ADJ TO P-VARIABLE-FORM-INFO-DTJ                  
               MOVE SPACES TO P-DR-CR-DTJ
           END-IF
           END-IF.                              
           IF (WS-CHECK-SOURCE-OF-FUNDS EQUAL WS-HOLD-SOURCE-OF-FUNDS)  
               OR (WS-104-ACCT-GEN-LED-DR EQUAL WS-104-ACCT-GEN-LED-CR) 
T10138             CONTINUE                                             
           ELSE                                                         
               MOVE WS-CHECK-SOURCE-OF-FUNDS TO WS-HOLD-SOURCE-OF-FUNDS
           END-IF.
           IF WS-104-AR-AGE EQUAL WS-0                                  
               MOVE WS-00                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-104-AR-AGE EQUAL WS-3                                  
               MOVE WS-30                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-104-AR-AGE EQUAL WS-6                                  
               MOVE WS-60                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-104-AR-AGE EQUAL WS-9                                  
               MOVE WS-90                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-104-AR-AGE EQUAL WS-P                                  
               MOVE WS-PP                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-104-AR-AGE EQUAL WS-C                                  
               MOVE WS-CO                    TO P-AGE-DTJ               
           ELSE                                                         
           IF WS-104-AR-AGE EQUAL WS-F                                  
               MOVE WS-FM                    TO P-AGE-DTJ               
           ELSE                                                         
               MOVE WS-104-AR-AGE            TO P-AGE-DTJ
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.              
           MOVE WS-104-ACCT-END-AR-BAL     TO P-ACCT-RCVBL-END-BAL-DTJ. 
           IF (WS-104-DETAIL-END-BAL EQUAL ZERO)                        
               AND (WS-104-DETAIL-END-AR-BAL EQUAL ZERO)                
                   AND (WS-104-ITEM-ID-NO EQUAL ZERO)                   
                   NEXT SENTENCE                                        
           ELSE                                                         
               MOVE WS-104-DETAIL-END-AR-BAL TO P-DETAIL-END-AR-BAL-DTJ 
               MOVE WS-104-ITEM-ID-NO        TO P-ITEM-ID-NO-DTJ        
               MOVE WS-104-DETAIL-END-BAL    TO P-DETAIL-END-BAL-DTJ
           END-IF.   
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           ADD 1                       TO WS-LINE-NO-DTJ.               
       8040-EXIT.                                                       
           EXIT.                                                        
       8041-PRINT-TAX-BREAKDOWN-104.                                    
           MOVE WS-104-ACCT-GEN-LED-DR TO WS-GL-NO-BREAKDOWN.           
           IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                  
               MOVE WS-DR              TO WS-P-DR-CR-HOLD               
               MOVE WS-BILL            TO WS-P-JRNL-DESC-HOLD           
           ELSE                                                         
               MOVE WS-104-ACCT-GEN-LED-CR TO WS-GL-NO-BREAKDOWN        
               MOVE WS-CR                  TO WS-P-DR-CR-HOLD           
               MOVE WS-B-ADJ               TO WS-P-JRNL-DESC-HOLD       
               IF WS-GL-NO-BREAKDOWN-MAJOR NOT EQUAL WS-GL-142          
                   GO TO 8041-EXIT
               END-IF
           END-IF.                                     
           MOVE ZEROS                  TO WS-HOLD-TAX-TOTAL.            
           MOVE WS-104-STAT-TAX-AMT    TO WS-HOLD-STATE-TAX-AMT.        
           MOVE WS-104-CITY-TAX-AMT    TO WS-HOLD-CITY-TAX-AMT.         
           MOVE WS-104-OTHER-TAX-AMT   TO WS-HOLD-OTHER-TAX-AMT.        
           ADD WS-104-STAT-TAX-AMT                                      
               WS-104-CITY-TAX-AMT                                      
               WS-104-OTHER-TAX-AMT    TO WS-HOLD-TAX-TOTAL.            
           IF WS-HOLD-TAX-TOTAL EQUAL ZERO                              
               GO TO 8041-EXIT
           END-IF.                                         
           SUBTRACT WS-HOLD-TAX-TOTAL FROM WS-HOLD-AMOUNT.              
           IF WS-HOLD-STATE-TAX-AMT NOT EQUAL ZERO                      
               MOVE WS-P-DR-CR-HOLD       TO P-DR-CR-DTJ                
               MOVE WS-P-JRNL-DESC-HOLD   TO P-JRNL-DESC-DTJ            
               MOVE WS-TAX-STAT-GL-NO (WS-GL-SUB) TO P-NON-142-ACCT-DTJ 
               MOVE WS-HOLD-STATE-TAX-AMT TO P-AMOUNT-POSTED-DTJ        
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
                   AFTER ADVANCING 1 LINES                              
               ADD 1                      TO WS-LINE-NO-DTJ             
               MOVE SPACES                TO WS-DAILY-TRAN-JRNL-DETAIL
           END-IF. 
           IF WS-HOLD-CITY-TAX-AMT NOT EQUAL ZERO                       
               MOVE WS-P-DR-CR-HOLD       TO P-DR-CR-DTJ                
               MOVE WS-P-JRNL-DESC-HOLD   TO P-JRNL-DESC-DTJ            
               MOVE WS-TAX-CITY-GL-NO (WS-GL-SUB) TO P-NON-142-ACCT-DTJ 
               MOVE WS-HOLD-CITY-TAX-AMT  TO P-AMOUNT-POSTED-DTJ        
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
                   AFTER ADVANCING 1 LINES                              
               ADD 1                      TO WS-LINE-NO-DTJ             
               MOVE SPACES                TO WS-DAILY-TRAN-JRNL-DETAIL
           END-IF. 
           IF WS-HOLD-OTHER-TAX-AMT NOT EQUAL ZERO                      
               MOVE WS-P-DR-CR-HOLD       TO P-DR-CR-DTJ                
               MOVE WS-P-JRNL-DESC-HOLD   TO P-JRNL-DESC-DTJ            
               MOVE WS-TAX-OTHR-GL-NO (WS-GL-SUB) TO P-NON-142-ACCT-DTJ 
               MOVE WS-HOLD-OTHER-TAX-AMT TO P-AMOUNT-POSTED-DTJ        
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
                   AFTER ADVANCING 1 LINES                              
               ADD 1                      TO WS-LINE-NO-DTJ
           END-IF.            
       8041-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * JOURNAL 105 PRINT NEEDS WORK- SHOULD RESEMBLE ARM ENTRY SCREEN?*        
      *    NEED TO DEFINE 2 PRINT LINES THAT RESEMBLE THE INFO ON THE  *        
      *    OLD ARM ENTRY SCREEN                                        *        
      ******************************************************************        
       8050-JRNL-FORMAT-105.                                            
           MOVE E-FCA07-USER-DEFINED-AREA TO CJF00105.                  
           IF WS-PRINT-CASH-DRAWER                                      
               MOVE E-FCA07-CASH-DRAWER-ID    TO P-CASH-DRAWER-DTJ
           END-IF.     
           IF E-FCA07-JRNL-TRAN-APPL-NO EQUAL 1                         
               OR WS-LINE-NO-DTJ EQUAL 9                                
                   MOVE WS-105-AMOUNT-ENTERED TO P-AMOUNT-ENTERED-DTJ
           END-IF.  
           MOVE WS-105-AMT-POSTED TO P-AMOUNT-POSTED-DTJ.               
           MOVE WS-105-ACCT-GEN-LED-DR TO WS-GL-NO-BREAKDOWN            
                                          WS-GL-HOLD-DR.                
           MOVE WS-105-ACCT-GEN-LED-CR TO WS-GL-HOLD-CR.                
           PERFORM 8150-CHECK-ADV-AR-TRANSFER THRU 8150-EXIT.           
           IF WS-GL-NO-BREAKDOWN-MAJOR EQUAL WS-GL-142                  
               MOVE WS-CHG                    TO P-JRNL-DESC-DTJ        
TP9306         MOVE WS-105-ACCT-GEN-LED-DR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-DR                     TO P-DR-CR-DTJ            
TP9306         MOVE WS-105-ACCT-GEN-LED-CR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           ELSE                                                         
TP9306         MOVE WS-105-ACCT-GEN-LED-DR    TO WS-GL-NO-BREAKDOWN     
TP9306         MOVE WS-ADJ                    TO P-JRNL-DESC-DTJ        
TP9306         MOVE WS-105-ACCT-GEN-LED-CR    TO GO-GL-ACCT-NO          
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               MOVE WS-CR                     TO P-DR-CR-DTJ            
TP9306         MOVE WS-105-ACCT-GEN-LED-DR    TO P-NON-142-ACCT-DTJ     
                                               WS-CHECK-SOURCE-OF-FUNDS 
               MOVE E-FCA07-COMPANY-NO        TO GO-COMPANY-NO          
               PERFORM 7530-SEL-GL-ACCT-NAME THRU 7530-EXIT             
           IF WS-CHECK-SOURCE-OF-FUNDS EQUAL WS-HOLD-SOURCE-OF-FUNDS    
T10138         CONTINUE                                                 
           ELSE                                                         
               MOVE WS-CHECK-SOURCE-OF-FUNDS TO WS-HOLD-SOURCE-OF-FUNDS
           END-IF
           END-IF.
           IF WS-105-ACCT-GEN-LED-DR EQUAL WS-105-ACCT-GEN-LED-CR       
               MOVE WS-ADJ TO P-JRNL-DESC-DTJ                           
               MOVE SPACES TO P-DR-CR-DTJ
           END-IF.                              
           IF WS-105-AR-AGE EQUAL WS-0                                  
               MOVE WS-00 TO P-AGE-DTJ                                  
           ELSE                                                         
           IF WS-105-AR-AGE EQUAL WS-3                                  
               MOVE WS-30 TO P-AGE-DTJ                                  
           ELSE                                                         
           IF WS-105-AR-AGE EQUAL WS-6                                  
               MOVE WS-60 TO P-AGE-DTJ                                  
           ELSE                                                         
           IF WS-105-AR-AGE EQUAL WS-9                                  
               MOVE WS-90 TO P-AGE-DTJ                                  
           ELSE                                                         
           IF WS-105-AR-AGE EQUAL WS-P                                  
               MOVE WS-PP TO P-AGE-DTJ                                  
           ELSE                                                         
           IF WS-105-AR-AGE EQUAL WS-C                                  
               MOVE WS-CO TO P-AGE-DTJ                                  
           ELSE                                                         
           IF WS-105-AR-AGE EQUAL WS-F                                  
               MOVE WS-FM TO P-AGE-DTJ                                  
           ELSE                                                         
               MOVE WS-105-AR-AGE TO P-AGE-DTJ
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                         
           MOVE WS-105-ACCT-END-AR-BAL TO P-ACCT-RCVBL-END-BAL-DTJ.     
           IF (WS-105-DETAIL-END-BAL EQUAL ZERO)                        
               AND (WS-105-DETAIL-END-AR-BAL EQUAL ZERO)                
                   AND (WS-105-ITEM-ID-NO EQUAL ZERO)                   
                   NEXT SENTENCE                                        
           ELSE                                                         
               MOVE WS-105-DETAIL-END-AR-BAL TO P-DETAIL-END-AR-BAL-DTJ 
               MOVE WS-105-ITEM-ID-NO TO P-ITEM-ID-NO-DTJ               
               MOVE WS-105-DETAIL-END-BAL TO P-DETAIL-END-BAL-DTJ
           END-IF.      
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           ADD 1 TO WS-LINE-NO-DTJ.                                     
       8050-EXIT.                                                       
            EXIT.                                                       
       8070-JRNL-FORMAT-113.                                            
           MOVE E-FCA07-USER-DEFINED-AREA   TO CJF00113.                
           IF WS-PRINT-CASH-DRAWER                                      
               MOVE E-FCA07-CASH-DRAWER-ID    TO P-CASH-DRAWER-DTJ
           END-IF.     
           MOVE WS-MAINT                   TO P-DESC-IS-WAS-113-DTJ.    
           MOVE WS-113-RECORD-FIELD-DESC   TO P-FIELD-DESC-113-DTJ.     
           MOVE WS-DETAIL-RECORD-113-DTJ   TO P-VARIABLE-FORM-INFO-DTJ. 
TP5678         MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA             
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           MOVE SPACES                    TO P-TENANT-INFO-DTJ          
                                             P-TRAN-ID-DTJ.             
           MOVE WS-WAS                    TO P-IS-WAS-WORD-113-DTJ.     
           MOVE WS-113-AR-DAY-00-WAS      TO P-AR-00-DAY-VALUE-113-DTJ. 
           MOVE WS-113-AR-DAY-30-WAS      TO P-AR-30-DAY-VALUE-113-DTJ. 
           MOVE WS-DETAIL-RECORD-113-1-DTJ TO P-VARIABLE-FORM-INFO-DTJ. 
TP5678     MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA                 
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           MOVE SPACES TO P-IS-WAS-WORD-113-DTJ.                        
           MOVE WS-113-AR-DAY-60-WAS      TO P-AR-60-DAY-VALUE-113-DTJ. 
           MOVE WS-113-AR-DAY-90-WAS      TO P-AR-90-DAY-VALUE-113-DTJ. 
           MOVE WS-113-TOTAL-AGED-WAS     TO P-TOT-AGED-113-DTJ.        
           MOVE WS-113-ACCT-AR-BAL-WAS    TO P-ACCT-AR-BAL-113-DTJ.     
           MOVE WS-DETAIL-RECORD-113-2-DTJ TO P-VARIABLE-FORM-INFO-DTJ. 
TP5678     MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA                 
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           MOVE WS-IS TO P-IS-WAS-WORD-113-DTJ.                         
           MOVE WS-113-AR-DAY-00-IS       TO P-AR-00-DAY-VALUE-113-DTJ. 
           MOVE WS-113-AR-DAY-30-IS       TO P-AR-30-DAY-VALUE-113-DTJ. 
           MOVE WS-DETAIL-RECORD-113-1-DTJ TO P-VARIABLE-FORM-INFO-DTJ. 
TP5678     MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA                 
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           MOVE SPACES                    TO P-IS-WAS-WORD-113-DTJ.     
           MOVE WS-113-AR-DAY-60-IS       TO P-AR-60-DAY-VALUE-113-DTJ. 
           MOVE WS-113-AR-DAY-90-IS       TO P-AR-90-DAY-VALUE-113-DTJ. 
           MOVE WS-113-TOTAL-AGED-IS      TO P-TOT-AGED-113-DTJ.        
           MOVE WS-113-ACCT-AR-BAL-IS     TO P-ACCT-AR-BAL-113-DTJ.     
           MOVE WS-DETAIL-RECORD-113-2-DTJ TO P-VARIABLE-FORM-INFO-DTJ. 
TP5678     MOVE WS-DAILY-TRAN-JRNL-DETAIL TO PRT33-DATA                 
TP5678     WRITE PRT33-RECORD                                           
               AFTER ADVANCING 1 LINES.                                 
           ADD 5 TO WS-LINE-NO-DTJ.                                     
       8070-EXIT.                                                       
           EXIT.                                                        
       8150-CHECK-ADV-AR-TRANSFER.                                      
           IF WS-GL-HOLD-DR       EQUAL WS-GL-HOLD-CR                   
               GO TO 8150-EXIT
           END-IF.                                         
           IF WS-GL-HOLD-DR-MAJOR NOT EQUAL WS-GL-142                   
               GO TO 8150-EXIT
           END-IF.                                         
           IF WS-GL-HOLD-DR-MAJOR NOT EQUAL WS-GL-HOLD-CR-MAJOR         
               GO TO 8150-EXIT
           END-IF.                                         
           IF WS-GL-HOLD-DR        EQUAL WS-AR-ADV-GL-NO (WS-GL-SUB)    
               MOVE ZEROS TO WS-GL-NO-BREAKDOWN-MAJOR
           END-IF.                  
       8150-EXIT.                                                       
           EXIT.                                                        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
      *    PROCESS FOR GA DATABASE ERROR, NO MONTHLY ACTIVITY SHOWING  *        
      * BUT DAILY ACTIVITY EXISTS.                                     *        
      *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  *  * *        
       8900-PRINT-PROGRAM-INFO-LINE.                                    
           WRITE PRT33-RECORD FROM WS-PROGRAM-INFO-LINE                 
               AFTER ADVANCING 1 LINES.                                 
       8900-EXIT.                                                       
           EXIT.                                                        
       8910-PRINT-STATUS-KEY-ERR-LINE.                                  
           DISPLAY 'VSAM STATUS ERROR - ' WS-STATUS-KEY-ERROR-LINE      
           WRITE PRT33-RECORD FROM WS-STATUS-KEY-ERROR-LINE             
               AFTER ADVANCING 1 LINES.                                 
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
       8910-EXIT.                                                       
           EXIT.                                                        
       9000-TERMINATE.                                                  
HEMA1 *    CLOSE FCSCA04-FILE.                                                  
           CLOSE FCSCA07-FILE.                                          
HEMA2 *    CLOSE FCSCA08-FILE.                                                  
           CLOSE FCSCA09-FILE.                                          
           CLOSE FCSCA10-FILE.                                          
           CLOSE FCSPT33-FILE.                                          
CBSI       CLOSE FCSRP132-FILE.                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ****                                                                      
TP8358      EXEC SQL                                                            
TP8358        INCLUDE CPD00150                                                  
TP8358      END-EXEC.                                                           
      *                                                                         
010590      EXEC SQL                                                            
010590        INCLUDE CPD09900                                                  
010590      END-EXEC.                                                           
                                                                        
T16880 8999-SELECT-COUNT-GL-ACCOUNT.                                    
T16880      INITIALIZE WS-GL-ACCT-COUNT                                 
T16880      INITIALIZE WS-GL-ACCT-NULL                                  
T16880      EXEC SQL                                                    
T16880          SELECT                                                  
T16880             COUNT(*)                                             
T16880          INTO :WS-GL-ACCT-COUNT :WS-GL-ACCT-NULL                 
T16880          FROM CSS_GL_ACCOUNT A,                                  
T16880               CSS_GL_ACCT_NO B                                   
T16880          WHERE  A.GL_ACCT_NO > 0                                 
T16880          AND    A.GL_DTL_CNTL_IND = 'D'                          
T16880          AND    A.COMPANY_NO = B.COMPANY_NO                      
T16880          AND    A.GL_ACCT_NO = B.GL_ACCT_NO                      
T16880     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T16880     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T16880     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T16880        IF WS-GL-ACCT-NULL = -1                                   
T16880           MOVE ZEROES TO WS-GL-ACCT-COUNT                        
T16880           DISPLAY '** 8999-SELECT-COUNT-GL-ACCOUNT'              
T16880           DISPLAY '** NO ROWS RETURNED**'                        
T16880           PERFORM 9900-ABEND THRU 9900-EXIT                      
T16880        END-IF                                                    
T16880     ELSE                                                         
T16880         DISPLAY '** 8999-SELECT-COUNT-GL-ACCOUNT'                
T16880         DISPLAY '** SQLCODE = ' WS-ACTIVE-RETURN-CODE            
T16880         PERFORM 9900-ABEND THRU 9900-EXIT                        
T16880     END-IF.                                                      
T16880 8999-EXIT.                                                       
T16880     EXIT.                                                        
      *                                                                         
T24436****************************************************************  19602800
T24436**                                                            **  19602900
T24436**  9700-PROCESS-ABEND                                        **  19603000
T24436**                                                            **  19603100
T24436****************************************************************  19603200
T24436*                                                                 19583100
T24436     EXEC SQL                                                     19584000
T24436        INCLUDE CPD0023B                                          19585000
T24436     END-EXEC.                                                    19586000
T24436*                                                                         
