       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA122.                                        
       DATE-WRITTEN.   DEC 1981.                                        
       REMARKS.                                                         
      ***************************************************************** PCS00050
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** PCS00060
      **                     PRICE WATERHOUSE                        ** PCS00070
      **                1410 NORTH WESTSHORE BLVD                    ** PCS00080
      **                   TAMPA, FLORIDA  33607                     ** PCS00090
      **                      (813) 287-9200                         ** PCS00100
      **                                                             ** PCS00110
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **    ____    ________     ______                              **         
      **                                                             **         
A02036** 04/05/2010  VP94820   POPULATE REVENUE MONTH IN ALL JOURNALS**         
A02036**                       WITH MISSING REVENUE MONTH            **         
      *****************************************************************         
      *                   N A R R A T I V E                                     
      * BUILDS AN 'ESDS' DAILY JOURNAL FILE (FCSCA07 SEQUENCED BY KEY)          
      * FROM THE 'ESDS' SORTED DAILY JOURNAL FILE (FCSWK23 SORTED               
      * OUTFILE FROM FCSWK23) IN PROGRAM PCSCA120.  THE 'ESDS' FILE             
      * (FCSCA07) IS USED AS INPUT TO CREATE THE DAILY TRANSACTION              
      * JOURNAL REPORT (PCSCA123).  THE FCA07 FILE REPRESENTS INDIRECT          
      * DAILY TRANSACTION ACTIVITY, SUBJECT TO GA POSTING.                      
      * FILE CA04 REPRESENTS DIRECT DAILY TRANSACTIONS WHICH HAVE               
      * ALREADY BEEN POSTED VIA ONLINE PROCEESSING. CA04 IS A KSDS FILE         
      * WITH WHICH SUMMARY JOURNALS WILL BE INSERTED TO THE FILE IN             
      * PROGRAM PCSCA123.                                                       
      *                                                                         
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
           0000 - 0000     MAIN CONTROL PARAGRAPH                       
           ------------------------------------------------------------ 
           0100 - 0100     INITIALIZATION, OPENS FILES                  
           ------------------------------------------------------------ 
           -----------  MAIN PROCESSING ROUTINES  --------------------- 
           1000 - 1000     MAJOR PROCESSING LOOP                        
                           READS THE INPUT FWK23                        
                           DETERMINES WHEN TO WRITE DUMMY FCA07 RECORD  
                           COPIES FWK23 TO FCA07                        
                           WRITES FCA07 RECORD                          
               1001 - 1001    ELIMINATES DUPLICATE FCA07 RECORDS        
           2000 - 2000     CREATES DUMMY FCA07 RECORD                   
           3000 - 3000     NOT USED                                     
           4000 - 4000     NOT USED                                     
           -----------------------------------------------------------  
           9000 - 9000     CLOSE FILES                                  
           9900 - 9900     CONTROLLED ABEND                             
           ------------------------------------------------------------ 
      * USES FILES                                                              
      *     FWK23 - AN ESDS FILE CONSISTING OF THAT DAYS 'TO' ACTIVITY          
      *     FCA07 - A ESDS FILE FORMED FROM FWK23.(NON RECORD TYPE 1)           
      *     FCA04 - A KSDS FILE FORMED FROM FWK23.(RECORD TYPE 1)               
      *                                                                         
      *     READS THE FWK23.ESDS FILE AND CREATES THE FCA07.ESDS                
      * FILE, CHECKING FOR AND ELIMINATING POSSIBLE DUPLICATE KEYS.             
      *                                                                         
HPCCDM*    EJECT                                                                
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.   IBM-370.                                      
       OBJECT-COMPUTER.   IBM-370.                                      
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSWK23.                                                            
       COPY CSSCA07.                                                            
HEMA  *COPY CSSCA04.                                                            
HPCCDM*    EJECT                                                                
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDWK23.                                                            
       COPY FIOWK23.                                                            
      *                                                                         
       COPY CFDCA07.                                                            
       COPY FIOCA07.                                                            
HPCCDM*    EJECT                                                                
HEMA  *COPY CFDCA04.                                                            
HEMA  *COPY FIOCA04.                                                            
      *                                                                         
      *                                                                         
HPCCDM*    EJECT                                                                
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA122'.
MSQ017     COPY MFASQLM.
FSW    01  WS-FWK23-STATUS                  PIC XX VALUE '00'.          
           88  FWK23-SUCCESSFUL        VALUE '00'.                      
FSW    01  WS-FCA07-STATUS                  PIC XX VALUE '00'.          
           88  FCA07-SUCCESSFUL        VALUE '00'.                      
HEMA  *01  WS-FCA04-STATUS                  PIC XX.                             
HEMA  *    88  FCA04-SUCCESSFUL        VALUE '00'.                              
       01  WS-SWITCHES.                                                 
           05  WS-LAST-ESDS-RECORD            PIC X(01).                
               88  WS-THIS-IS-LAST-ESDS-RECORD      VALUE 'Y'.          
           05  WS-IS-DUP-KEY-ELIMINATED       PIC X(01).                
               88  WS-DUP-KEY-IS-ELIMINATED         VALUE 'Y'.          
       01  ABEND-FUNCTION.                                              
           05  WS-ABEND-SPACE            PIC X(02)  VALUE SPACE.        
           05  WS-ABEND-NUMERIC                                         
               REDEFINES WS-ABEND-SPACE  PIC 99.                        
       01  WS-DUP-NO-INCREMENT         PIC 9(03)    VALUE ZERO.         
FSW    01  WS-SORT-KEY-DISPLAY         PIC X(30)    VALUE SPACES.       
       01  WS-HOLD-KEY-REC.                                             
FSW        05  WS-HOLD-KEY             PIC X(30)   VALUE ZEROES.        
           05  WS-HOLD-DUP-CNTRL-NO  PIC S9(03) COMP-3 VALUE ZEROES.    
FSW    01  WS-HOLD-KEY-IN              PIC X(30) VALUE SPACES.          
       01  WS-ACCT-NO-DISPLAY          PIC 9(04)V9(05)  VALUE ZERO.     
       01  WS-COUNTERS.                                                 
           05  WS-FWK23-RECORD-CNT     PIC 9(07)     VALUE ZEROES.      
           05  WS-FCA07-RECORD-CNT     PIC 9(07)     VALUE ZEROES.      
A02036*                                                                         
A02036 01  WS-MISC.                                                     
A02036     05 WS-REV-MONTH             PIC S9(6) COMP-3 VALUE +0.       
A02036*                                                                         
       01  WS-LITERALS.                                                 
           05  WS-1                    PIC X(01)    VALUE '1'.          
           05  WS-YES                  PIC X(01)    VALUE 'Y'.          
           05  WS-NO                   PIC X(01)    VALUE 'N'.          
       COPY CWS09900.                                                   00010001
A02036*                                                                 04094000
A02036*****************************************************************         
A02036*    DB2 ERROR HANDLING                                         *         
A02036*****************************************************************         
A02036*                                                                         
A02036 COPY CWS00303.                                                           
A02036*                                                                         
A02036*****************************************************************         
A02036*    JOURNAL LAYOUTS                                            *         
A02036*****************************************************************         
A02036*                                                                         
A02036 COPY CJF00101.                                                           
A02036 COPY CJF00102.                                                           
A02036 COPY CJF00103.                                                           
A02036 COPY CJF00104.                                                           
A02036 COPY CJF00105.                                                           
A02036*                                                                         
A02036*****************************************************************         
A02036*    CSS_JOB_PARM - G6                                          *         
A02036*****************************************************************         
A02036*                                                                         
A02036     EXEC SQL                                                             
A02036         INCLUDE TBJBPARM                                                 
A02036     END-EXEC.                                                            
A02036*                                                                         
           EXEC SQL                                                     10510001
               INCLUDE SQLCA                                            10520001
           END-EXEC.                                                    10530001
HPCCDM*    EJECT                                                                
       PROCEDURE DIVISION.                                              
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 0500-PROCESS-BEGIN-REC THRU 0500-EXIT.               
           PERFORM 1000-PROCESS-ESDS-FILE THRU 1000-EXIT                
               UNTIL WS-THIS-IS-LAST-ESDS-RECORD.                       
           PERFORM 2999-WRITE-END-CONTROLS THRU 2999-EXIT.              
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           DISPLAY 'PCSCA122 COMPLETED '.                               
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
       0100-INITIALIZATION.                                             
           OPEN INPUT FCSWK23-FILE.                                     
           IF FWK23-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSWK23 OPEN.  STATUS KEY IS '    
                        WS-FWK23-STATUS                                 
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
           OPEN OUTPUT FCSCA07-FILE.                                    
           IF FCA07-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSCA07 OPEN.  STATUS KEY IS '    
                        WS-FCA07-STATUS                                 
               DISPLAY '**      PROCESSING TERMINATED      **'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
HEMA  *    OPEN I-O FCSCA04-FILE.                                               
HEMA  *    IF FCA04-SUCCESSFUL                                                  
HEMA  *        NEXT SENTENCE                                                    
HEMA  *    ELSE                                                                 
HEMA  *        DISPLAY '0100-ERROR ON FCSCA04 OPEN.  STATUS KEY IS '            
HEMA  *                 WS-FCA04-STATUS                                         
HEMA  *        DISPLAY '**      PROCESSING TERMINATED      **'                  
HEMA  *        PERFORM 9900-ABEND THRU 9900-EXIT.                               
A02036*                                                                         
A02036     MOVE 'COMMON'                  TO G6-PROGRAM-NAME.           
A02036     MOVE 20                        TO G6-SEQ-NO.                 
A02036     MOVE '01'                      TO G6-COMPANY-NO.             
A02036     MOVE 'A'                       TO G6-STATUS.                 
A02036     MOVE 'DATE'                    TO G6-CMND-CODE.              
A02036     PERFORM 7000-GET-REV-MONTH     THRU 7000-EXIT.               
A02036*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       0500-PROCESS-BEGIN-REC.                                          
            PERFORM 7100-READ-FCSWK23      THRU 7100-EXIT.              
            IF FWK23-SUCCESSFUL                                         
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '****************************************'       
               DISPLAY '* MISSING INPUT FILE FWK23 FOR PCSCA122*'       
               DISPLAY '*     PCSCA122 TERMINATED              *'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND    THRU 9900-EXIT
            END-IF.                    
      *                                                                         
           IF  E-FWK23-BEGIN-REC-KEY EQUAL LOW-VALUES                   
              SUBTRACT 1 FROM WS-FWK23-RECORD-CNT                       
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '* PSCA122 PROCESSING ERROR             *'        
              DISPLAY '* FIRST RECORD IS NOT A CONTROL RECORD *'        
              DISPLAY '* PROCESSING TERMINATED                *'        
              DISPLAY '****************************************'        
              PERFORM 9900-ABEND    THRU 9900-EXIT
           END-IF.                     
           PERFORM 2000-WRITE-BEGIN-CONTROLS    THRU 2000-EXIT.         
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       1000-PROCESS-ESDS-FILE.                                          
           PERFORM 7100-READ-FCSWK23     THRU 7100-EXIT.                
           IF WS-FWK23-STATUS NOT EQUAL '00'                            
               MOVE E-FWK23-GL-RECORD-ACCT-NO TO WS-ACCT-NO-DISPLAY     
               DISPLAY '********************************************'   
               DISPLAY '*      PROCESSING ERROR IN PCSCA122        *'   
               DISPLAY '* IN-CHK1 = '                                   
                       WS-FWK23-STATUS ' '                              
                       WS-ACCT-NO-DISPLAY                               
               DISPLAY '* LAST RECORD NOT A CONTROL REC IN FCSWK23 *'   
               DISPLAY '*           PROCESSING TERMINATED          *'   
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
           IF E-FWK23-END-REC-KEY = HIGH-VALUES                         
               PERFORM 1900-PROCESS-END-REC     THRU 1900-EXIT          
               GO TO 1000-EXIT
           END-IF.                                         
      *                                                                         
      *                                                                         
HEMA  *    IF E-FWK23-JRNL-SORT-ID EQUAL WS-1                                   
HEMA  *        PERFORM 1002-PROCESS-KSDS-CA04 THRU 1002-EXIT                    
HEMA  *    ELSE                                                                 
               PERFORM 1003-PROCESS-KSDS-CA07 THRU 1003-EXIT.           
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1001-PROCESS-DUP-CHECK.                                          
           MOVE E-FWK23-KEY TO WS-HOLD-KEY-IN.                          
           IF WS-HOLD-KEY-IN EQUAL WS-HOLD-KEY                          
               ADD 1 TO WS-HOLD-DUP-CNTRL-NO                            
           ELSE                                                         
               MOVE WS-HOLD-KEY-IN TO WS-HOLD-KEY                       
               MOVE ZERO TO WS-HOLD-DUP-CNTRL-NO
           END-IF.                       
       1001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
HEMA  *1002-PROCESS-KSDS-CA04.                                                  
HEMA  *    PERFORM 1001-PROCESS-DUP-CHECK THRU 1001-EXIT.                       
HEMA  *    MOVE E-FWK23-KEY TO E-FCA04-KEY.                                     
HEMA  *    MOVE WS-HOLD-DUP-CNTRL-NO TO E-FCA04-DUP-CONTROL-NO.                 
HEMA  *    MOVE E-FWK23-DATA TO E-FCA04-RECORD-DATA.                            
HEMA  *    PERFORM 7300-WRITE-FIOCA04 THRU 7300-EXIT.                           
HEMA  *1002-EXIT.                                                               
HEMA  *    EXIT.                                                                
      *                                                                         
      *                                                                         
       1003-PROCESS-KSDS-CA07.                                          
           PERFORM 1001-PROCESS-DUP-CHECK THRU 1001-EXIT.               
           MOVE E-FWK23-KEY TO E-FCA07-KEY.                             
           MOVE WS-HOLD-DUP-CNTRL-NO TO E-FCA07-DUP-CONTROL-NO.         
           MOVE E-FWK23-DATA TO E-FCA07-RECORD-DATA.                    
A02036*                                                                         
A02036     EVALUATE E-FCA07-JRNL-FORMAT-NO                              
A02036         WHEN 101                                                 
A02036              MOVE E-FCA07-USER-DEFINED-AREA TO CJF00101          
A02036              IF WS-101-REVENUE-MONTH IS NUMERIC                  
A02036                 IF WS-101-REVENUE-MONTH > 0                      
A02036                    CONTINUE                                      
A02036                 ELSE                                             
A02036                    MOVE WS-REV-MONTH TO WS-101-REVENUE-MONTH     
A02036                 END-IF                                           
A02036              ELSE                                                
A02036                 MOVE WS-REV-MONTH    TO WS-101-REVENUE-MONTH     
A02036              END-IF                                              
A02036              MOVE CJF00101 TO E-FCA07-USER-DEFINED-AREA          
A02036         WHEN 102                                                 
A02036              MOVE E-FCA07-USER-DEFINED-AREA TO CJF00102          
A02036              IF WS-102-REVENUE-MONTH IS NUMERIC                  
A02036                 IF WS-102-REVENUE-MONTH > 0                      
A02036                    CONTINUE                                      
A02036                 ELSE                                             
A02036                    MOVE WS-REV-MONTH TO WS-102-REVENUE-MONTH     
A02036                 END-IF                                           
A02036              ELSE                                                
A02036                 MOVE WS-REV-MONTH    TO WS-102-REVENUE-MONTH     
A02036              END-IF                                              
A02036              MOVE CJF00102 TO E-FCA07-USER-DEFINED-AREA          
A02036         WHEN 103                                                 
A02036              MOVE E-FCA07-USER-DEFINED-AREA TO CJF00103          
A02036              IF WS-103-REVENUE-MONTH IS NUMERIC                  
A02036                 IF WS-103-REVENUE-MONTH > 0                      
A02036                    CONTINUE                                      
A02036                 ELSE                                             
A02036                    MOVE WS-REV-MONTH TO WS-103-REVENUE-MONTH     
A02036                 END-IF                                           
A02036              ELSE                                                
A02036                 MOVE WS-REV-MONTH    TO WS-103-REVENUE-MONTH     
A02036              END-IF                                              
A02036              MOVE CJF00103 TO E-FCA07-USER-DEFINED-AREA          
A02036         WHEN 104                                                 
A02036              MOVE E-FCA07-USER-DEFINED-AREA TO CJF00104          
A02036              IF WS-104-REVENUE-MONTH IS NUMERIC                  
A02036                 IF WS-104-REVENUE-MONTH > 0                      
A02036                    CONTINUE                                      
A02036                 ELSE                                             
A02036                    MOVE WS-REV-MONTH TO WS-104-REVENUE-MONTH     
A02036                 END-IF                                           
A02036              ELSE                                                
A02036                 MOVE WS-REV-MONTH    TO WS-104-REVENUE-MONTH     
A02036              END-IF                                              
A02036              MOVE CJF00104 TO E-FCA07-USER-DEFINED-AREA          
A02036         WHEN 105                                                 
A02036              MOVE E-FCA07-USER-DEFINED-AREA TO CJF00105          
A02036              IF WS-105-REVENUE-MONTH IS NUMERIC                  
A02036                 IF WS-105-REVENUE-MONTH > 0                      
A02036                    CONTINUE                                      
A02036                 ELSE                                             
A02036                    MOVE WS-REV-MONTH TO WS-105-REVENUE-MONTH     
A02036                 END-IF                                           
A02036              ELSE                                                
A02036                 MOVE WS-REV-MONTH    TO WS-105-REVENUE-MONTH     
A02036              END-IF                                              
A02036              MOVE CJF00105 TO E-FCA07-USER-DEFINED-AREA          
A02036     END-EVALUATE                                                 
A02036*                                                                         
           PERFORM 7200-WRITE-FIOCA07 THRU 7200-EXIT.                   
       1003-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       1900-PROCESS-END-REC.                                            
           SUBTRACT 1 FROM WS-FWK23-RECORD-CNT.                         
           IF WS-FWK23-RECORD-CNT = E-FWK23-RECORD-CNT                  
               MOVE WS-YES TO WS-LAST-ESDS-RECORD                       
           ELSE                                                         
              DISPLAY '***********************************************' 
              DISPLAY ' PROGRAM PCSCA122 RECORD COUNT DOES '            
                      ' NOT = FWK23 CONTROL RECORD COUNT'               
              DISPLAY '* PCSCA122 RECORD COUNT = ' WS-FWK23-RECORD-CNT  
              DISPLAY '* CONTROL RECORD COUNT  = ' E-FWK23-RECORD-CNT   
              DISPLAY '*            PROCESSING TERMINATED            *' 
              DISPLAY '***********************************************' 
              PERFORM 9900-ABEND  THRU 9900-EXIT
           END-IF.                       
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
HPCCDM*    EJECT                                                                
       2000-WRITE-BEGIN-CONTROLS.                                       
           MOVE SPACES TO FIOCA07.                                      
           MOVE LOW-VALUES TO E-FCA07-BEGIN-KEY.                        
           MOVE E-FWK23-BEGIN-CREATE-DATE TO E-FCA07-BEGIN-CREATE-DATE. 
           PERFORM 7200-WRITE-FIOCA07    THRU 7200-EXIT.                
           SUBTRACT 1 FROM WS-FCA07-RECORD-CNT.                         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       2999-WRITE-END-CONTROLS.                                         
           MOVE SPACES TO FIOCA07.                                      
           MOVE HIGH-VALUES TO E-FCA07-BEGIN-KEY.                       
           MOVE WS-FCA07-RECORD-CNT TO E-FCA07-END-RECORD-CNT.          
           PERFORM 7200-WRITE-FIOCA07    THRU 7200-EXIT.                
           SUBTRACT 1 FROM WS-FCA07-RECORD-CNT.                         
      *                                                                         
       2999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
A02036*                                                                 41709000
A02036******************************************************************        
A02036* 7000-GET-REV-MONTH.                                            *        
A02036******************************************************************        
A02036*                                                                         
A02036 7000-GET-REV-MONTH.                                              
A02036*                                                                         
A02036     EXEC SQL                                                     
A02036         SELECT G6.PARM_DATA                                      
A02036           INTO :G6-PARM-DATA                                     
A02036           FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
A02036          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
A02036            AND G6.COMPANY_NO   = :G6-COMPANY-NO                  
A02036            AND G6.CMND_CODE    = :G6-CMND-CODE                   
A02036            AND G6.SEQ_NO       = :G6-SEQ-NO                      
A02036            AND G6.STATUS       = :G6-STATUS                      
A02036                                                           
A02036                                                      
A02036     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT G6.PARM_DATA                                              
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM CSS_JOB_PARM G6                                           
MFA-TR*         WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*           AND G6.COMPANY_NO   = :G6-COMPANY-NO                          
MFA-TR*           AND G6.CMND_CODE    = :G6-CMND-CODE                           
MFA-TR*           AND G6.SEQ_NO       = :G6-SEQ-NO                              
MFA-TR*           AND G6.STATUS       = :G6-STATUS                              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02036*                                                                         
A02036     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
A02036*                                                                         
A02036     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02036        MOVE G6-PARM-DATA(15:6)     TO WS-REV-MONTH               
A02036        DISPLAY 'REVENUE MONTH = ' G6-PARM-DATA(15:6)             
A02036     ELSE                                                         
A02036        DISPLAY '***************************************'         
A02036        DISPLAY '    PCSCA122 PROCESSING ERROR         *'         
A02036        DISPLAY '   UNABLE TO GET REVENUE MONTH        *'         
A02036        DISPLAY '    SQLCODE = ' WS-ACTIVE-RETURN-CODE            
A02036        DISPLAY '       PCSCA122 TERMINATED            *'         
A02036        DISPLAY '***************************************'         
A02036        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02036     END-IF.                                                      
A02036*                                                                         
A02036 7000-EXIT.                                                       
A02036     EXIT.                                                        
A02036*                                                                 41260000
       7100-READ-FCSWK23.                                               
           READ FCSWK23-FILE                                            
           ADD 1 TO WS-FWK23-RECORD-CNT.                                
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7200-WRITE-FIOCA07.                                              
           WRITE FIOCA07.                                               
           IF FCA07-SUCCESSFUL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
           IF WS-FCA07-RECORD-CNT = 0                                   
               DISPLAY '********************************************'   
               DISPLAY '         PCSCA122      ERROR               *'   
               DISPLAY ' UNABLE TO WRITE PCSCA07 INIT REC          *'   
               DISPLAY '          PCSCA122 TERMINATED              *'   
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '         PCSCA122      ERROR               *'   
               DISPLAY ' WRITE ERROR OCCURRED FOR FCA07            *'   
               DISPLAY '          PCSCA122 TERMINATED              *'   
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
           ADD 1 TO WS-FCA07-RECORD-CNT.                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
HEMA  *7300-WRITE-FIOCA04.                                                      
HEMA  *    WRITE FIOCA04                                                        
HEMA  *    IF FCA04-SUCCESSFUL                                                  
HEMA  *       NEXT SENTENCE                                                     
HEMA  *    ELSE                                                                 
HEMA  *       MOVE WS-NO TO WS-IS-DUP-KEY-ELIMINATED                            
HEMA  *       PERFORM 7301-PROCESS-DUP-KEY   THRU 7301-EXIT                     
HEMA  *          UNTIL WS-DUP-KEY-IS-ELIMINATED.                                
HEMA  *                                                                         
HEMA  *7300-EXIT.                                                               
HEMA  *    EXIT.                                                                
      *                                                                         
      *                                                                         
HEMA  *7301-PROCESS-DUP-KEY.                                                    
HEMA  *    MOVE E-FCA04-KEY TO WS-SORT-KEY-DISPLAY.                             
HEMA  *    ADD 1 TO WS-DUP-NO-INCREMENT.                                        
HEMA  *    MOVE E-FWK23-KEY TO E-FCA04-KEY.                                     
HEMA  *    MOVE E-FWK23-DATA TO E-FCA04-RECORD-DATA.                            
HEMA  *    MOVE WS-DUP-NO-INCREMENT TO E-FCA04-DUP-CONTROL-NO.                  
HEMA  *    WRITE FIOCA04.                                                       
HEMA  *    IF FCA04-SUCCESSFUL                                                  
HEMA  *       MOVE WS-YES TO WS-IS-DUP-KEY-ELIMINATED.                          
HEMA  *                                                                         
HEMA  *7301-EXIT.                                                               
HEMA  *    EXIT.                                                                
      *                                                                         
       9000-TERMINATE.                                                  
           CLOSE FCSWK23-FILE.                                          
           CLOSE FCSCA07-FILE.                                          
HEMA  *    CLOSE FCSCA04-FILE.                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
      **************************************************************    08140000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    08150000
      **************************************************************    08160000
           EXEC SQL                                                     08170000
             INCLUDE CPD09900                                           08180001
             END-EXEC.                                                  08190000
