       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA120.                                        
       AUTHOR.                                                          
       INSTALLATION.                                                    
       DATE-WRITTEN.   DEC 1981.                                        
           DATE-COMPILED.                                               
      ***************************************************************** 00070014
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00080014
      **                     PRICE WATERHOUSE                        ** 00090014
      **                1410 NORTH WESTSHORE BLVD                    ** 00100014
      **                   TAMPA, FLORIDA  33607                     ** 00110014
      **                      (813) 287-9200                         ** 00120014
      **                                                             ** 00130014
      ** *****            CUSTOMER SERVICE SYSTEM             ********* 00140014
      ********                      DB2                       ********* 00150014
      ***************************************************************** 00160014
      **                                                             ** 00170014
      **              PROGRAM  MODIFICATION  LOG                     ** 00180014
      **    DATE    INITIALS    REASON                               ** 00190014
      **  ========  ========    ===================================  ** 00200014
TP5672**  10/18/96   JHR         TPR 5672 FIX PERFORM DUE TO SOC4.   ** 00201016
      **                                                             ** 00201016
TP8095**  12/12/96   AJC         TPR 8095 FIX LOCAL OFFICE SELECT    ** 00201016
      **                          AND ASSIGNMENT.                    ** 00201016
T13129**  09/18/97   CSS         ACCUMULATE TOTAL FOR CK ISSUE BUCKETS* 00201016
      **                                                             ** 00201016
T23814**  04/23/01   DS19153     RUN-TIME ENHANCEMENT APPLIED. CHANGE** 00201016
      **                         CURSOR FOR CSS_CSH_DRWR_CNTL, TO    ** 00201016
      **                         ONLY PULL BACK ROWS DATED WITHIN THE** 00201016
      **                         LAST SIX DAYS. WAS PULLING BACK ALL ** 00201016
      **                         CSS_CSH_DRWR_CNTL ROWS AND LOOPING  ** 00201016
      **                         THRU ALL ROWS OF CSS_CSH_DRWR_JRNL  ** 00201016
      **                         TABLE, WHICH IS VERY SLOW.          ** 00201016
      **                                                             **         
T24436**  08/16/01   COVANSYS    COPYBOOK CPD00061 CHANGED TO SUB    **         
T24436**             CHENNAI     PROGRAM  SCSCB061.                  **         
T35692**  05/03/07   JS83520     ADDED LOCK TABLE COMMANDS FOR       **         
      **                         PERFORMANCE                         ** 00201016
A00755**  01/12/10   VV94890     CHANGED PURGE-JRNL DAYS FROM 6 TO 30**         
      **                         DAYS.                               ** 00201016
A00755**  01/13/10   VV94890     CHANGED BACK TO PREVIOUS VERSION :  **         
      **                         PURGE-JRNL DAYS FROM 30 TO 06 DAYS. ** 00201016
      **                         (DUE TO A JOB-PARM TABLE ISSUE)     ** 00201016
A04011**  04/26/12   BASKAR V    MADE THE WS-PURGE-JRNL VALUE AS     **         
A04011**                         TABLE DRIVEN VALUE.                 **         
ACT032**  02/XX/14   BD09555     REMOVE TBGLNAME A04880              **         
      ***************************************************************** 00210014
           REMARKS.                                                     
      *                 N A R R A T I V E                               00230014
      *                                                                 00240014
      * READS THE TERMINAL OPERATOR DATA BASE AND COPIES THE "TOT'      00250014
      * TRANSACTION JOURNALS TO A 'KSDS' DAILY JOURNAL FILE.  THE       00260014
      * PROGRAM ALSO CROSS-FOOTS INTERNALLY AND IF THERE IS A CROSS     00270014
      * FOOT ERROR, WRITES ERROR RECORDS TO THE 'KSDS' DAILY JOURNAL    00280014
      * FILE.  AFTER A JOURNAL HAS BEEN COPIED TO THE 'KSDS' DAILY      00290014
      * JOURNAL FILE, A FLAG IS SET IN THE TERMINAL OPERATOR DATA BASE  00300014
      * TO PREVENT THAT JOURNAL FROM BEING EXTRACTED AGAIN.  THE 'KSDS' 00310014
      * DAILY JOURNAL FILE IS PASSED THRU A SORT CREATING AN ESDS SORTED00320014
      * FILE TO BE USED AS INPUT IN PROGRAM PCSCA122.                   00330014
      *           **  NO   REPORTS   PRODUCED  **                       00340014
      *                                                                 00350014
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
           0000 - 0000     MAIN CONTROL PARAGRAPH                       
           ------------------------------------------------------------ 
           ---------- INITIAL PROCESSING  1 TIME ONLY ----------------- 
           0100 - 0100     INITIALIZATION, SET DATES                    
           ------------------------------------------------------------ 
           -----------  MAIN PROCESSING ROUTINES  --------------------- 
           1000 - 1000     MAJOR PROCESSING LOOP, CONTROLS TOM LOOPING  
           2000 - 2000     CONTROLS TYPE OF 001 AND 002 EXTRACTS        
           2100 - 2100     CREATES 001 EXTRACT                          
           2110 - 2110     CHECKS FOR AND CREATES 002 EXTRACTS          
           3000 - 3000     CONTROLS TOC PROCESSING, UPDATES EXTRACT CODE
           3100 - 3115     CREATES TOT JOURNALS                         
           -----------------------------------------------------------  
           7000 - 7130     INQUIRY CALLS TO DATABASE                    
           -----------------------------------------------------------  
           8000 - 8000     UPDATE CALLS TO DATABASE                     
           8200 - 8200     WRITE FCSCA06 RECORD                         
           -----------------------------------------------------------  
           9000 - 9000     CLOSE FILES                                  
           9900 - 9900     ABEND                                        
HPCCDM*EJECT                                                            00570014
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA06.                                                    00640014
HPCCDM*EJECT                                                            00670014
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA06.                                                    00700014
       COPY FIOCA06.                                                    00710014
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA120'.
MSQ017     COPY MFASQLM.
           EXEC SQL                                                     00770014
                INCLUDE SQLCA                                           00780014
           END-EXEC.                                                    00790014
           EXEC SQL                                                     00800014
                INCLUDE TBJBPARM                                        00810026
           END-EXEC.                                                    00820014
           EXEC SQL                                                     00821026
                INCLUDE TBCDCNTL                                        00810014
           END-EXEC.                                                    00820014
           EXEC SQL                                                     00830014
                INCLUDE TBCDJRNL                                        00840014
           END-EXEC.                                                    00850014
           EXEC SQL                                                     00860014
                INCLUDE TBBJCNTL                                        00870014
           END-EXEC.                                                    00880014
           EXEC SQL                                                     00890014
                INCLUDE TBBTJRNL                                        00900014
           END-EXEC.                                                    00910014
           EXEC SQL                                                     00920014
                INCLUDE TBMSJRNL                                        00930014
           END-EXEC.                                                    00940014
           EXEC SQL                                                     00950014
                INCLUDE TBRESTRT                                        00960014
           END-EXEC.                                                    00970014
                                                                        
A04011* CSS_DELINQUENCY                                                         
A04011     EXEC SQL                                                             
A04011        INCLUDE TBDELQ                                                    
A04011     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     00970443
                INCLUDE CWS00038                                        00971029
           END-EXEC.                                                    00971129
           EXEC SQL                                                     00971229
                INCLUDE CWS00039                                        00972030
           END-EXEC.                                                    00973029
           EXEC SQL                                                     00974041
                INCLUDE CWS00061                                        00975048
           END-EXEC.                                                    00976041
T23814     EXEC SQL                                                     00974041
T23814          INCLUDE CWS00018                                        00975048
T23814     END-EXEC.                                                    00976041
       01  WS-MISC.                                                     
           05 WS-START                 PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA120 STARTS HERE'.            
           05  WS-TYPE-CHECK           PIC X(02).                       
               88  BATCH-JRNL          VALUE 'BJ'.                      
               88  CASH-JRNL           VALUE 'CJ'.                      
               88  MISC-JRNL           VALUE 'MJ'.                      
               88  BATCH-JRNL-CNTRL    VALUE 'BC'.                      
               88  CASH-DRWR-CNTRL     VALUE 'CC'.                      
           05  WS-COMPANY-NO           PIC X(02).                       
           05  WS-NULL-IND             PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-IND-2           PIC S9(4) COMP VALUE +0.         
           05  WS-NULL-IND-3           PIC S9(4) COMP VALUE +0.         
      *** MOVED TO RESTART DATA:                                        01140014
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA120'.      
T24436     05  SCSCB061                PIC X(08) VALUE 'SCSCB061'.      
T24436*    05  ACTIVE-PARAGRAPH        PIC X(04).                       01201038
           05  WS-FCA06-STATUS            PIC X(02).                    
               88  FCA06-SUCCESSFUL     VALUE '00'.                     
               88  FCA06-ALREADY-EXISTS VALUE '22'.                     
               88  FCA06-EOF            VALUE '23'.                     
           05  WS-FCA06-MORE-DATA-SW   PIC X(01) VALUE 'Y'.             
               88  WS-NO-MORE-DATA     VALUE 'N'.                       
           05  WS-CNTL-JRNL-SW         PIC X(01) VALUE 'Y'.             
               88  WS-NOT-CNTRL-JRNL     VALUE 'N'.                     
           05  WS-TRAN-TIME-HOLD       PIC X(08)     VALUE SPACES.      
           05  WS-LAST-TIME-USED       PIC X(08)     VALUE SPACES.      
           05  WS-TOT-EXTRACT-SEGMENT.                                  
               10  FILLER                 PIC X(05).                    
               10  WS-TOT-ESDS-RECORD     PIC X(145).                   
           05  WS-GL-ACCT-NO-BREAKDOWN    PIC 9(03)V9(04).              
           05  WS-GL-ACCT-NO-BREAKDOWN-RED                              
               REDEFINES WS-GL-ACCT-NO-BREAKDOWN.                       
               10  WS-GL-ACCT-NO          PIC 9(03).                    
               10  FILLER                 PIC 9(04).                    
           05  WS-CNTRL-ACT-TOTAL         PIC S9(11)V99  VALUE +0.      
           05  WS-CNTRL-ACT-TOTAL-EDIT    PIC ++++,+++,+++.99.          
           05  WS-EXT-ACT-TOTAL           PIC S9(11)V99  VALUE +0.      
           05  WS-EXT-ACT-TOTAL-EDIT      PIC ++++,+++,+++.99.          
           05  WS-DIFFERENCE              PIC S9(11)V99  VALUE +0.      
           05  WS-DIFFERENCE-EDIT         PIC ++++,+++,+++.99.          
           05  WS-EXTRACT-NET-TOTAL       PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-CASH-DB-BUCKET          PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-CASH-CR-BUCKET          PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-AR-DB-BUCKET            PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-AR-CR-BUCKET            PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-CKI-DB-BUCKET           PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-CKI-CR-BUCKET           PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-GL-DB-BUCKET            PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-GL-CR-BUCKET            PIC S9(09)V99 COMP-3 VALUE +0.
           05  WS-BJ-COUNTER              PIC 9(04) COMP VALUE ZERO.    
           05  WS-CJ-COUNTER              PIC 9(04) COMP VALUE ZERO.    
           05  WS-MJ-COUNTER              PIC 9(04) COMP VALUE ZERO.    
T23814     05  WS-ACTIVE-RETURN-CODE-ED   PIC -(9)9      VALUE SPACES.  
T23814     05  WS-DATE-PARM-DAYS-AGO      PIC X(10).                    
T23814     05  WS-DISPLAY-DATE.                                         
T23814         10  WS-DISPLAY-CC          PIC X(02).                    
T23814         10  WS-DISPLAY-YY          PIC X(02).                    
T23814         10  FILLER                 PIC X(01).                    
T23814         10  WS-DISPLAY-MM          PIC X(02).                    
T23814         10  FILLER                 PIC X(01).                    
T23814         10  WS-DISPLAY-DD          PIC X(02).                    
A00755     05  WS-PURGE-JRNL              PIC 9(04)      VALUE 0006.    
           05  WS-JRNL-USER-DEFINED-TYPE PIC 9(03).                     
               88  WS-101-TYPE               VALUE 101.                 
               88  WS-102-TYPE               VALUE 102.                 
               88  WS-103-TYPE               VALUE 103.                 
               88  WS-104-TYPE               VALUE 104.                 
               88  WS-105-TYPE               VALUE 105.                 
               88  WS-201-TYPE               VALUE 201.                 
           05  WS-SHOULD-PRINT-JRNL-0002     PIC X(01) VALUE 'N'.       
               88  WS-PRINT-JRNL-0002                  VALUE 'Y'.       
           05  WS-TOT-PRINT-LINES.                                      
               10  WS-TOT-PRINT-LINE-1       PIC X(50).                 
               10  WS-TOT-PRINT-LINE-2       PIC X(100).                
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE    PIC 9(01).                    
           05  WS-RESTART-JOB-COMPLETE  REDEFINES                       
               WS-RESTART-PROCESS-TYPE  PIC X(01).                      
           05  WS-RESTART-JOB-STATUS      PIC X(01).                    
               88  WS-RUN-COMPLETED-NO-PROBLEMS    VALUE 'A'.           
               88  WS-RERUN-COMPLETED              VALUE 'B'.           
               88  WS-RERUN-PENDING                VALUE 'C'.           
           05  WS-RESTART-INPUT-DATE      PIC X(10).                    
           05  WS-RESTART-CHKP-SEQ-NO     PIC S9(05) COMP-3 VALUE ZERO. 
           05  WS-RESTART-REPOSITION-KEY.                               
               10  WS-RESTART-CASH-COMPANY-NO     PIC X(02).            
               10  WS-RESTART-CASH-LOCAL-OFFICE   PIC X(03).            
               10  WS-RESTART-CASH-REPORT-NO      PIC X(03).            
               10  WS-RESTART-DATE-CASH-REPORT    PIC X(10).            
               10  WS-RESTART-CASH-DRAWER-ID      PIC S9(4) COMP.       
      *  THE FOLLOWING FIELDS ARE TO STORE OFF THE DATABASE UPDATE      02020014
      *  TOTAL COUNTERS IN THE RESTART DATA:                            02030014
      *                                                                 02040014
           05  WS-RESTART-BJ-UPDT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-CJ-UPDT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-MJ-UPDT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-RF-UPDT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-RF-ISRT-CNTR-TOT        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
      *  THE FOLLOWING FIELDS ARE TO STORE OFF THE DATABASE UPDATE      02150014
      *  COUNTERS "PER LUW" IN THE RESTART DATA (THESE MUST BE RESTART  02160014
      *  FIELDS BECAUSE CHECKPOINTS ARE TAKEN WITHIN THE LUW):          02170014
      *                                                                 02180014
           05  WS-RESTART-BJ-UPDT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-CJ-UPDT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-MJ-UPDT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-RF-UPDT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
           05  WS-RESTART-RF-ISRT-CNTR-LUW        PIC S9(07) COMP-3     
                                                             VALUE ZERO.
      *  THE FOLLOWING FIELDS ARE TO STORE OFF ALL RUNNING TOTAL FIELDS 02290014
      *  IN THE PROGRAM:                                                02300014
      *                                                                 02310014
           05  WS-RESTART-FCSCA06-REC-CNTR  PIC S9(09)  COMP-3          
                                                        VALUE ZERO.     
           05  WS-RESTART-CASH-DB-BUCKET PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RESTART-CASH-CR-BUCKET PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RESTART-AR-DB-BUCKET   PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RESTART-AR-CR-BUCKET   PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RESTART-CKI-DB-BUCKET  PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RESTART-CKI-CR-BUCKET  PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RESTART-GL-DB-BUCKET   PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RESTART-GL-CR-BUCKET   PIC S9(09)V99 COMP-3 VALUE +0. 
           05  WS-RESTART-BJ-COUNTER     PIC 9(04) COMP VALUE ZERO.     
           05  WS-RESTART-CJ-COUNTER     PIC 9(04) COMP VALUE ZERO.     
           05  WS-RESTART-MJ-COUNTER     PIC 9(04) COMP VALUE ZERO.     
       01  WS-RESTART-MISC.                                             
           05  WS-IS-THIS-A-RESTART      PIC X(01) VALUE 'N'.           
               88  WS-THIS-IS-A-RESTART      VALUE 'Y'.                 
           05  WS-PRINT-COUNTERS         PIC X(01) VALUE 'A'.           
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-DEFAULT-RESTART-REQ    PIC X(01) VALUE 'N'.           
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) VALUE ZEROES COMP.
           05  WS-PROCESS-TYPE           PIC 9(01).                     
           05  WS-RESTART-DATA-LENGTH    PIC S9(04) COMP VALUE +123.    
           05  WS-REPOSITION-NEEDED      PIC X(01) VALUE 'Y'.           
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04) VALUE 4.             
           05  WS-CHKP-LUW-LIMIT         PIC 9(04).                     
           05  WS-CHKP-LUW-COUNTER       PIC S9(04) COMP-3              
                                         VALUE ZERO.                    
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04) VALUE 20.            
           05  WS-CHKP-UPD-LIMIT         PIC 9(04).                     
           05  WS-CHKP-UPD-COUNTER       PIC S9(04) COMP-3              
                                         VALUE ZERO.                    
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID   PIC X(02) VALUE '20'.               
               10  WS-CHKP-PART-NO  PIC 9(01) VALUE 1.                  
               10  WS-CHKP-SEQ-NO   PIC 9(05) VALUE ZERO.               
      * THE FOLLOWING FIELD WILL ALLOW PROGRAMMER TO FORCE ABEND BY     02680014
      * SPECIFYING WHICH LOOP TO ABEND IN AND WHICH CONCATENATED KEY TO 02690014
      * ABEND ON:                                                       02700014
           05  WS-STOP-CONCATENATED-KEY.                                
               10  WS-STOP-PROCESS-TYPE  PIC X(06).                     
                   88  STOP-REQUESTED-IN-BJ-LOOP VALUE 'BJLOOP'.        
                   88  STOP-REQUESTED-IN-CJ-LOOP VALUE 'CJLOOP'.        
                   88  STOP-REQUESTED-IN-MJ-LOOP VALUE 'MJLOOP'.        
               10  WS-STOP-CASH-COMPANY-NO     PIC X(02).               
               10  WS-STOP-CASH-LOCAL-OFFICE   PIC X(03).               
               10  WS-STOP-CASH-REPORT-NO      PIC X(03).               
               10  WS-STOP-DATE-CASH-REPORT    PIC X(10).               
               10  WS-STOP-CASH-DRAWER-ID      PIC 9(04).               
               10  WS-STOP-DATE-TRAN           PIC 9(08).               
               10  WS-STOP-ENTRY-NO            PIC 9(09).               
      *                                                                 02830014
       01  WS-STOP-PARM-BREAKDOWN.                                      
           05  WS-STOP-PARM-PROCESS-TYPE PIC X(06).                     
               88  STOP-PARM-REQUESTED-BJ-LOOP VALUE 'BJLOOP'.          
               88  STOP-PARM-REQUESTED-CJ-LOOP VALUE 'CJLOOP'.          
               88  STOP-PARM-REQUESTED-MJ-LOOP VALUE 'MJLOOP'.          
           05  WS-STOP-PARM-CASH-COMPANY-NO     PIC X(02).              
           05  WS-STOP-PARM-CASH-LOCAL-OFFICE   PIC X(03).              
           05  WS-STOP-PARM-CASH-REPORT-NO      PIC X(03).              
           05  WS-STOP-PARM-DATE-CASH-REPORT.                           
               10  WS-STOP-PARM-CCYY            PIC 9(04).              
               10  WS-STOP-PARM-DASH-1          PIC X(01).              
               10  WS-STOP-PARM-MM              PIC 9(02).              
               10  WS-STOP-PARM-DASH-2          PIC X(01).              
               10  WS-STOP-PARM-DD              PIC 9(02).              
           05  WS-STOP-PARM-CASH-DRAWER-ID      PIC 9(04).              
           05  WS-STOP-PARM-DATE-TRAN           PIC 9(08).              
           05  WS-STOP-PARM-ENTRY-NO            PIC 9(09).              
           05  FILLER                           PIC X(03).              
       01  WS-LITERALS.                                                 
           05  WS-00001                PIC 9(03)    VALUE 001.          
           05  WS-00002                PIC 9(03)    VALUE 002.          
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-CC                   PIC X(02)     VALUE 'CC'.        
           05  WS-BC                   PIC X(02)     VALUE 'BC'.        
           05  WS-BJ                   PIC X(02)     VALUE 'BJ'.        
           05  WS-CJ                   PIC X(02)     VALUE 'CJ'.        
           05  WS-MJ                   PIC X(02)     VALUE 'MJ'.        
           05  WS-DASH                 PIC X(01)     VALUE '-'.         
           05  WS-ACTIVE               PIC X(01)     VALUE 'A'.         
           05  WS-D                    PIC X(01)     VALUE 'D'.         
           05  WS-I                    PIC X(01)     VALUE 'I'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-S                    PIC X(01)     VALUE 'S'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-1                    PIC 9(01)     VALUE 1.           
           05  WS-2                    PIC 9(01)     VALUE 2.           
           05  WS-3                    PIC 9(01)     VALUE 3.           
           05  WS-4                    PIC 9(01)     VALUE 4.           
           05  WS-NINES-DATE           PIC X(10)                        
               VALUE '9999-12-31'.                                      
           05  WS-ZERO-DATE            PIC X(10)                        
               VALUE '0000-01-01'.                                      
      *** DELETED WS-NINES (UNUSED).                                    03290014
           05  WS-99                   PIC X(02)     VALUE '99'.        
           05  WS-999                  PIC X(03)     VALUE '999'.       
           05  WS-99999999             PIC 9(08)     VALUE 99999999.    
           05  WS-999999999            PIC 9(09)     VALUE 999999999.   
           05  WS-ERROR-CASH-DB        PIC X(29)                        
               VALUE ' IN CASH-DEBIT TOTALS        '.                   
           05  WS-ERROR-CASH-CR        PIC X(29)                        
               VALUE ' IN CSH-CREDIT TOTALS        '.                   
           05  WS-ERROR-AR-DB          PIC X(29)                        
               VALUE ' IN AR-DEBIT TOTALS          '.                   
           05  WS-ERROR-AR-CR          PIC X(29)                        
               VALUE ' IN AR-CREDIT TOTALS         '.                   
           05  WS-ERROR-CKI-DB         PIC X(29)                        
               VALUE ' IN CKI-DEBIT TOTALS         '.                   
           05  WS-ERROR-CKI-CR         PIC X(29)                        
               VALUE ' IN CKI-CREDIT TOTALS        '.                   
           05  WS-ERROR-GL-DB          PIC X(29)                        
               VALUE ' IN GL-DEBIT TOTALS          '.                   
           05  WS-ERROR-GL-CR          PIC X(29)                        
               VALUE ' IN GL-CREDIT TOTALS         '.                   
      *                                                                         
T24436 01  RS-RPC-RETURN-CODE.                                          
T24436     05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
T24436     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
       COPY FIOJC01.                                                    03541029
       COPY FIOCA00.                                                    03542029
       COPY CWS09900.                                                   03550014
       COPY CWS00303.                                                   03590014
       COPY CJF00001.                                                   03600014
       COPY CJF00002.                                                   03610014
       COPY CJF00101.                                                   03620014
       COPY CJF00102.                                                   03630014
       COPY CJF00103.                                                   03640014
       COPY CJF00104.                                                   03650014
       COPY CJF00105.                                                   03651023
       COPY CJF00201.                                                   03660014
T24436 COPY CWS00010.                                                           
HPCCDM*EJECT                                                            03670014
      *                                                                 03680014
T24436*01  ABEND-FUNCTION.                                              03690014
T24436*    05  WS-ABEND-SPACE              PIC X(02) VALUE SPACE.       03700014
T24436*    05  FILLER REDEFINES WS-ABEND-SPACE.                         03710014
T24436*        10  WS-ABEND-NUMERIC       PIC 99.                       03720014
      *                                                                 03730014
      ********************                                              03740014
      * BATCH-JRNL-CNTRL *                                              03750014
      ********************                                              03760014
           EXEC SQL                                                     
                DECLARE BATCH_JRNL_CNTRL CURSOR FOR                     
                SELECT                                                  
RS               CASH_DRAWER_ID,                                        
RS               CASH_LOCAL_OFFICE,                                     
RS               CASH_REPORT_NO,                                        
RS               DATE_CASH_REPORT,                                      
                 DATE_LAST_ACTIVITY,                                    
                 AMT_CASH_DEBIT,                                        
                 AMT_CASH_CREDIT,                                       
                 AMT_AR_DEBIT,                                          
                 AMT_AR_CREDIT,                                         
                 AMT_CK_ISS_DEBIT,                                      
                 AMT_CK_ISS_CREDIT,                                     
                 AMT_GL_DEBIT,                                          
                 AMT_GL_CREDIT,                                         
RS               CASH_COMPANY_NO                                        
                FROM CSS_BCH_JRNL_CNTL                                  
RS            WHERE (( CASH_COMPANY_NO     = :BC-CASH-COMPANY-NO        
RS              AND    CASH_LOCAL_OFFICE   = :BC-CASH-LOCAL-OFFICE      
RS              AND    CASH_REPORT_NO      = :BC-CASH-REPORT-NO         
RS              AND    DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )       
RS              AND    CASH_DRAWER_ID     >= :BC-CASH-DRAWER-ID )       
RS               OR  ( CASH_COMPANY_NO     = :BC-CASH-COMPANY-NO        
RS              AND    CASH_LOCAL_OFFICE   = :BC-CASH-LOCAL-OFFICE      
RS              AND    CASH_REPORT_NO      = :BC-CASH-REPORT-NO         
RS              AND    DATE_CASH_REPORT    < IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) ) )     
RS               OR  ( CASH_COMPANY_NO     = :BC-CASH-COMPANY-NO        
RS              AND    CASH_LOCAL_OFFICE   = :BC-CASH-LOCAL-OFFICE      
RS              AND    CASH_REPORT_NO      > :BC-CASH-REPORT-NO )       
RS               OR  ( CASH_COMPANY_NO     = :BC-CASH-COMPANY-NO        
RS              AND    CASH_LOCAL_OFFICE   > :BC-CASH-LOCAL-OFFICE )    
RS               OR  ( CASH_COMPANY_NO     > :BC-CASH-COMPANY-NO ))     
RS            ORDER BY CASH_COMPANY_NO,                                 
RS                     CASH_LOCAL_OFFICE,                               
RS                     CASH_REPORT_NO,                                  
RS                     DATE_CASH_REPORT DESC,                           
RS                     CASH_DRAWER_ID                                   
RS    *       WHERE (( LOCAL_OFFICE_ENTRY  = :BC-LOCAL-OFFICE-ENTRY     03950015
      *** THE FOLLOWING IS >= TO PROPERLY REOPEN CURSOR AFTER COMMIT:   03970014
RS    *                AND BATCH_NO         >= :BC-BATCH-NO )           03980014
RS    *          OR  ( LOCAL_OFFICE_ENTRY  > :BC-LOCAL-OFFICE-ENTRY))   03990015
RS    *       ORDER BY LOCAL_OFFICE_ENTRY, BATCH_NO                     04020015
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03770014
MFA-TR*         DECLARE BATCH_JRNL_CNTRL CURSOR FOR                     03780014
MFA-TR*         SELECT                                                  03790014
MFA-TR*          CASH_DRAWER_ID,                                        03850014
MFA-TR*          CASH_LOCAL_OFFICE,                                     03850014
MFA-TR*          CASH_REPORT_NO,                                        03850014
MFA-TR*          DATE_CASH_REPORT,                                      03850014
MFA-TR*          DATE_LAST_ACTIVITY,                                    03850014
MFA-TR*          AMT_CASH_DEBIT,                                        03860014
MFA-TR*          AMT_CASH_CREDIT,                                       03870014
MFA-TR*          AMT_AR_DEBIT,                                          03880014
MFA-TR*          AMT_AR_CREDIT,                                         03890014
MFA-TR*          AMT_CK_ISS_DEBIT,                                      03900014
MFA-TR*          AMT_CK_ISS_CREDIT,                                     03910014
MFA-TR*          AMT_GL_DEBIT,                                          03920014
MFA-TR*          AMT_GL_CREDIT,                                         03930014
MFA-TR*          CASH_COMPANY_NO                                        03820014
MFA-TR*         FROM CSS_BCH_JRNL_CNTL                                  03940014
MFA-TR*       WHERE (( CASH_COMPANY_NO     = :BC-CASH-COMPANY-NO        03950015
MFA-TR*         AND    CASH_LOCAL_OFFICE   = :BC-CASH-LOCAL-OFFICE      03950015
MFA-TR*         AND    CASH_REPORT_NO      = :BC-CASH-REPORT-NO         03950015
MFA-TR*         AND    DATE_CASH_REPORT    = :BC-DATE-CASH-REPORT       03950015
MFA-TR*         AND    CASH_DRAWER_ID     >= :BC-CASH-DRAWER-ID )       03980014
MFA-TR*          OR  ( CASH_COMPANY_NO     = :BC-CASH-COMPANY-NO        03950015
MFA-TR*         AND    CASH_LOCAL_OFFICE   = :BC-CASH-LOCAL-OFFICE      03950015
MFA-TR*         AND    CASH_REPORT_NO      = :BC-CASH-REPORT-NO         03950015
MFA-TR*         AND    DATE_CASH_REPORT    < :BC-DATE-CASH-REPORT )     03950015
MFA-TR*          OR  ( CASH_COMPANY_NO     = :BC-CASH-COMPANY-NO        03950015
MFA-TR*         AND    CASH_LOCAL_OFFICE   = :BC-CASH-LOCAL-OFFICE      03950015
MFA-TR*         AND    CASH_REPORT_NO      > :BC-CASH-REPORT-NO )       03950015
MFA-TR*          OR  ( CASH_COMPANY_NO     = :BC-CASH-COMPANY-NO        03950015
MFA-TR*         AND    CASH_LOCAL_OFFICE   > :BC-CASH-LOCAL-OFFICE )    03950015
MFA-TR*          OR  ( CASH_COMPANY_NO     > :BC-CASH-COMPANY-NO ))     03950015
MFA-TR*       ORDER BY CASH_COMPANY_NO,                                 04020015
MFA-TR*                CASH_LOCAL_OFFICE,                               04020015
MFA-TR*                CASH_REPORT_NO,                                  04020015
MFA-TR*                DATE_CASH_REPORT DESC,                           04020015
MFA-TR*                CASH_DRAWER_ID                                   04020015
MFA-TR*       WHERE (( LOCAL_OFFICE_ENTRY  = :BC-LOCAL-OFFICE-ENTRY     03950015
MFA-TR*** THE FOLLOWING IS >= TO PROPERLY REOPEN CURSOR AFTER COMMIT:   03970014
MFA-TR*                AND BATCH_NO         >= :BC-BATCH-NO )           03980014
MFA-TR*          OR  ( LOCAL_OFFICE_ENTRY  > :BC-LOCAL-OFFICE-ENTRY))   03990015
MFA-TR*       ORDER BY LOCAL_OFFICE_ENTRY, BATCH_NO                     04020015
MFA-TR*    END-EXEC.                                                    04030014
      *                                                                 04040014
           EXEC SQL                                                     
                DECLARE BATCH_JRNL CURSOR FOR                           
                SELECT                                                  
                   CASH_COMPANY_NO,                                     
                   CASH_LOCAL_OFFICE,                                   
                   CASH_REPORT_NO,                                      
                   DATE_CASH_REPORT,                                    
                   CASH_DRAWER_ID,                                      
                   LOCAL_OFFICE,                                        
                   GL_ACCT_NO,                                          
                   CODE_JRNL_EXTRACT,                                   
                   DATE_JRNL_EXTRACT,                                   
                   DATE_TRAN,                                           
                   ENTRY_NO,                                            
                   TRAN_APPL_NO,                                        
                   JRNL_SORT_ID,                                        
                   CUSTOMER_NO,                                         
                   ACCOUNT_NO,                                          
                   REPLACE(CONVERT(CHAR(8), TRAN_TIME, 108), ':', '.') 
           TRAN_TIME,                                           
                   TRAN_ID,                                             
                   DATE_LAST_ACTION,                                    
                   CODE_ENTRY_SOURCE,                                   
                   USER_ID,                                             
                   CODE_TRAN_ERRORS,                                    
                   TRAN_DATA,                                           
                   COMPANY_NO                                           
              FROM CSS_BATCH_JRNL                                       
RS    *       WHERE  LOCAL_OFFICE         = :BC-LOCAL-OFFICE-ENTRY      04300015
RS    *         AND  BATCH_NO             = :BC-BATCH-NO                04320014
RS            WHERE  CASH_COMPANY_NO      = :BC-CASH-COMPANY-NO         
RS              AND  CASH_LOCAL_OFFICE    = :BC-CASH-LOCAL-OFFICE       
RS              AND  CASH_REPORT_NO       = :BC-CASH-REPORT-NO          
RS              AND  DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )        
RS              AND  CASH_DRAWER_ID       = :BC-CASH-DRAWER-ID          
                AND  CODE_JRNL_EXTRACT   <> 'Y'                         
              FOR UPDATE OF CODE_JRNL_EXTRACT, DATE_JRNL_EXTRACT        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04050014
MFA-TR*         DECLARE BATCH_JRNL CURSOR FOR                           04060014
MFA-TR*         SELECT                                                  04070014
MFA-TR*            CASH_COMPANY_NO,                                             
MFA-TR*            CASH_LOCAL_OFFICE,                                           
MFA-TR*            CASH_REPORT_NO,                                              
MFA-TR*            DATE_CASH_REPORT,                                            
MFA-TR*            CASH_DRAWER_ID,                                              
MFA-TR*            LOCAL_OFFICE,                                        04080015
MFA-TR*            GL_ACCT_NO,                                          04100014
MFA-TR*            CODE_JRNL_EXTRACT,                                   04110014
MFA-TR*            DATE_JRNL_EXTRACT,                                   04120014
MFA-TR*            DATE_TRAN,                                           04130014
MFA-TR*            ENTRY_NO,                                            04140014
MFA-TR*            TRAN_APPL_NO,                                        04150014
MFA-TR*            JRNL_SORT_ID,                                        04160014
MFA-TR*            CUSTOMER_NO,                                         04170014
MFA-TR*            ACCOUNT_NO,                                          04180014
MFA-TR*            TRAN_TIME,                                           04200014
MFA-TR*            TRAN_ID,                                             04210014
MFA-TR*            DATE_LAST_ACTION,                                    04220014
MFA-TR*            CODE_ENTRY_SOURCE,                                   04230014
MFA-TR*            USER_ID,                                             04240028
MFA-TR*            CODE_TRAN_ERRORS,                                    04270014
MFA-TR*            TRAN_DATA,                                           04280014
MFA-TR*            COMPANY_NO                                           03820014
MFA-TR*       FROM CSS_BATCH_JRNL                                       04290014
MFA-TR*       WHERE  LOCAL_OFFICE         = :BC-LOCAL-OFFICE-ENTRY      04300015
MFA-TR*         AND  BATCH_NO             = :BC-BATCH-NO                04320014
MFA-TR*       WHERE  CASH_COMPANY_NO      = :BC-CASH-COMPANY-NO         03950015
MFA-TR*         AND  CASH_LOCAL_OFFICE    = :BC-CASH-LOCAL-OFFICE       03950015
MFA-TR*         AND  CASH_REPORT_NO       = :BC-CASH-REPORT-NO          03950015
MFA-TR*         AND  DATE_CASH_REPORT     = :BC-DATE-CASH-REPORT        03950015
MFA-TR*         AND  CASH_DRAWER_ID       = :BC-CASH-DRAWER-ID          03980014
MFA-TR*         AND  CODE_JRNL_EXTRACT   = 'Y'                         04330014
MFA-TR*       FOR UPDATE OF CODE_JRNL_EXTRACT, DATE_JRNL_EXTRACT        04340014
MFA-TR*    END-EXEC.                                                    04350014
      *                                                                 04360014
           EXEC SQL                                                     
                DECLARE CASH_DRWR_CNTRL CURSOR FOR                      
                SELECT                                                  
                   CASH_LOCAL_OFFICE,                                   
                   CASH_DRAWER_ID,                                      
                   CASH_REPORT_NO,                                      
                   DATE_CASH_REPORT,                                    
                   DATE_LAST_ACTIVITY,                                  
                   AMT_BASIC_WORK,                                      
                   AMT_CASH_DEBIT,                                      
                   AMT_CASH_CREDIT,                                     
                   AMT_AR_DEBIT,                                        
                   AMT_AR_CREDIT,                                       
                   AMT_CK_ISS_DEBIT,                                    
                   AMT_CK_ISS_CREDIT,                                   
                   AMT_GL_DEBIT,                                        
                   AMT_GL_CREDIT,                                       
                   AMT_CASH_BEGIN_BAL,                                  
                   CASH_COMPANY_NO                                      
              FROM CSS_CSH_DRWR_CNTL                                    
T23814        WHERE  DATE_CASH_REPORT     >= IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )       
RS    *T23814 WHERE (( CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO        03950015
RS    *T23814   AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE      03950015
RS    *T23814   AND    CASH_REPORT_NO      = :CS-CASH-REPORT-NO         03950015
RS    *T23814   AND    DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT       03950015
RS    *T23814   AND    CASH_DRAWER_ID     >= :CS-CASH-DRAWER-ID )       03980014
RS    *T23814    OR  ( CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO        03950015
RS    *T23814   AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE      03950015
RS    *T23814   AND    CASH_REPORT_NO      = :CS-CASH-REPORT-NO         03950015
RS    *T23814   AND    DATE_CASH_REPORT    < :CS-DATE-CASH-REPORT )     03950015
RS    *T23814    OR  ( CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO        03950015
RS    *T23814   AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE      03950015
RS    *T23814   AND    CASH_REPORT_NO      > :CS-CASH-REPORT-NO )       03950015
RS    *T23814    OR  ( CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO        03950015
RS    *T23814   AND    CASH_LOCAL_OFFICE   > :CS-CASH-LOCAL-OFFICE )    03950015
RS    *T23814    OR  ( CASH_COMPANY_NO     > :CS-CASH-COMPANY-NO ))     03950015
RS            ORDER BY CASH_COMPANY_NO,                                 
RS                     CASH_LOCAL_OFFICE,                               
RS                     CASH_REPORT_NO,                                  
RS                     DATE_CASH_REPORT DESC,                           
RS                     CASH_DRAWER_ID                                   
RS    *       WHERE (( LOCAL_OFFICE        = :CS-LOCAL-OFFICE           04550015
      *** THE FOLLOWING IS >= TO PROPERLY REOPEN CURSOR AFTER COMMIT:   04570014
RS    *                AND CASH_DRAWER_ID >= :CS-CASH-DRAWER-ID )       04580014
RS    *          OR  ( LOCAL_OFFICE        > :CS-LOCAL-OFFICE))         04610015
RS    *       ORDER BY LOCAL_OFFICE, CASH_DRAWER_ID                     04620015
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04370014
MFA-TR*         DECLARE CASH_DRWR_CNTRL CURSOR FOR                      04380014
MFA-TR*         SELECT                                                  04390014
MFA-TR*            CASH_LOCAL_OFFICE,                                   04400015
MFA-TR*            CASH_DRAWER_ID,                                      04420014
MFA-TR*            CASH_REPORT_NO,                                      04420014
MFA-TR*            DATE_CASH_REPORT,                                    04420014
MFA-TR*            DATE_LAST_ACTIVITY,                                  04430014
MFA-TR*            AMT_BASIC_WORK,                                      04440014
MFA-TR*            AMT_CASH_DEBIT,                                      04450014
MFA-TR*            AMT_CASH_CREDIT,                                     04460014
MFA-TR*            AMT_AR_DEBIT,                                        04470014
MFA-TR*            AMT_AR_CREDIT,                                       04480014
MFA-TR*            AMT_CK_ISS_DEBIT,                                    04490014
MFA-TR*            AMT_CK_ISS_CREDIT,                                   04500014
MFA-TR*            AMT_GL_DEBIT,                                        04510014
MFA-TR*            AMT_GL_CREDIT,                                       04520014
MFA-TR*            AMT_CASH_BEGIN_BAL,                                  04530014
MFA-TR*            CASH_COMPANY_NO                                      03820014
MFA-TR*       FROM CSS_CSH_DRWR_CNTL                                    04540014
MFA-TR*       WHERE  DATE_CASH_REPORT     >= :CS-DATE-CASH-REPORT       03950015
MFA-TR*T23814 WHERE (( CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO        03950015
MFA-TR*T23814   AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE      03950015
MFA-TR*T23814   AND    CASH_REPORT_NO      = :CS-CASH-REPORT-NO         03950015
MFA-TR*T23814   AND    DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT       03950015
MFA-TR*T23814   AND    CASH_DRAWER_ID     >= :CS-CASH-DRAWER-ID )       03980014
MFA-TR*T23814    OR  ( CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO        03950015
MFA-TR*T23814   AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE      03950015
MFA-TR*T23814   AND    CASH_REPORT_NO      = :CS-CASH-REPORT-NO         03950015
MFA-TR*T23814   AND    DATE_CASH_REPORT    < :CS-DATE-CASH-REPORT )     03950015
MFA-TR*T23814    OR  ( CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO        03950015
MFA-TR*T23814   AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE      03950015
MFA-TR*T23814   AND    CASH_REPORT_NO      > :CS-CASH-REPORT-NO )       03950015
MFA-TR*T23814    OR  ( CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO        03950015
MFA-TR*T23814   AND    CASH_LOCAL_OFFICE   > :CS-CASH-LOCAL-OFFICE )    03950015
MFA-TR*T23814    OR  ( CASH_COMPANY_NO     > :CS-CASH-COMPANY-NO ))     03950015
MFA-TR*       ORDER BY CASH_COMPANY_NO,                                 04020015
MFA-TR*                CASH_LOCAL_OFFICE,                               04020015
MFA-TR*                CASH_REPORT_NO,                                  04020015
MFA-TR*                DATE_CASH_REPORT DESC,                           04020015
MFA-TR*                CASH_DRAWER_ID                                   04020015
MFA-TR*       WHERE (( LOCAL_OFFICE        = :CS-LOCAL-OFFICE           04550015
MFA-TR*** THE FOLLOWING IS >= TO PROPERLY REOPEN CURSOR AFTER COMMIT:   04570014
MFA-TR*                AND CASH_DRAWER_ID >= :CS-CASH-DRAWER-ID )       04580014
MFA-TR*          OR  ( LOCAL_OFFICE        > :CS-LOCAL-OFFICE))         04610015
MFA-TR*       ORDER BY LOCAL_OFFICE, CASH_DRAWER_ID                     04620015
MFA-TR*    END-EXEC.                                                    04630014
      *                                                                 04640014
           EXEC SQL                                                     
                DECLARE CASH_DRWR_JRNL CURSOR FOR                       
                SELECT                                                  
                   CASH_COMPANY_NO,                                     
                   CASH_LOCAL_OFFICE,                                   
                   CASH_REPORT_NO,                                      
                   DATE_CASH_REPORT,                                    
                   CASH_DRAWER_ID,                                      
                   LOCAL_OFFICE,                                        
                   GL_ACCT_NO,                                          
                   DATE_TRAN,                                           
                   ENTRY_NO,                                            
                   TRAN_APPL_NO,                                        
                   JRNL_SORT_ID,                                        
                   CUSTOMER_NO,                                         
                   ACCOUNT_NO,                                          
                   REPLACE(CONVERT(CHAR(8), TRAN_TIME, 108), ':', '.') 
           TRAN_TIME,                                           
                   TRAN_ID,                                             
                   DATE_LAST_ACTION,                                    
                   CODE_ENTRY_SOURCE,                                   
                   USER_ID,                                             
                   CODE_TRAN_ERRORS,                                    
                   CODE_JRNL_EXTRACT,                                   
                   DATE_JRNL_EXTRACT,                                   
                   TRAN_DATA,                                           
                   COMPANY_NO                                           
              FROM CSS_CSH_DRWR_JRNL                                    
RS    *       WHERE  LOCAL_OFFICE         = :CS-LOCAL-OFFICE            04910015
RS    *         AND  CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID          04930014
RS            WHERE  CASH_COMPANY_NO      = :CS-CASH-COMPANY-NO         
RS              AND  CASH_LOCAL_OFFICE    = :CS-CASH-LOCAL-OFFICE       
RS              AND  CASH_REPORT_NO       = :CS-CASH-REPORT-NO          
RS              AND  DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )        
RS              AND  CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID          
                AND  CODE_JRNL_EXTRACT   <> 'Y'                         
              FOR UPDATE OF CODE_JRNL_EXTRACT, DATE_JRNL_EXTRACT        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04650014
MFA-TR*         DECLARE CASH_DRWR_JRNL CURSOR FOR                       04660014
MFA-TR*         SELECT                                                  04670014
MFA-TR*            CASH_COMPANY_NO,                                             
MFA-TR*            CASH_LOCAL_OFFICE,                                           
MFA-TR*            CASH_REPORT_NO,                                              
MFA-TR*            DATE_CASH_REPORT,                                            
MFA-TR*            CASH_DRAWER_ID,                                              
MFA-TR*            LOCAL_OFFICE,                                        04680015
MFA-TR*            GL_ACCT_NO,                                          04700014
MFA-TR*            DATE_TRAN,                                           04720014
MFA-TR*            ENTRY_NO,                                            04730014
MFA-TR*            TRAN_APPL_NO,                                        04740014
MFA-TR*            JRNL_SORT_ID,                                        04750014
MFA-TR*            CUSTOMER_NO,                                         04760014
MFA-TR*            ACCOUNT_NO,                                          04770014
MFA-TR*            TRAN_TIME,                                           04790014
MFA-TR*            TRAN_ID,                                             04800014
MFA-TR*            DATE_LAST_ACTION,                                    04810014
MFA-TR*            CODE_ENTRY_SOURCE,                                   04820014
MFA-TR*            USER_ID,                                             04830028
MFA-TR*            CODE_TRAN_ERRORS,                                    04860014
MFA-TR*            CODE_JRNL_EXTRACT,                                   04870014
MFA-TR*            DATE_JRNL_EXTRACT,                                   04880014
MFA-TR*            TRAN_DATA,                                           04890014
MFA-TR*            COMPANY_NO                                           03820014
MFA-TR*       FROM CSS_CSH_DRWR_JRNL                                    04900014
MFA-TR*       WHERE  LOCAL_OFFICE         = :CS-LOCAL-OFFICE            04910015
MFA-TR*         AND  CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID          04930014
MFA-TR*       WHERE  CASH_COMPANY_NO      = :CS-CASH-COMPANY-NO         03950015
MFA-TR*         AND  CASH_LOCAL_OFFICE    = :CS-CASH-LOCAL-OFFICE       03950015
MFA-TR*         AND  CASH_REPORT_NO       = :CS-CASH-REPORT-NO          03950015
MFA-TR*         AND  DATE_CASH_REPORT     = :CS-DATE-CASH-REPORT        03950015
MFA-TR*         AND  CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID          03980014
MFA-TR*         AND  CODE_JRNL_EXTRACT   = 'Y'                         04940014
MFA-TR*       FOR UPDATE OF CODE_JRNL_EXTRACT, DATE_JRNL_EXTRACT        04950014
MFA-TR*    END-EXEC.                                                    04960014
           EXEC SQL                                                     
                DECLARE MISC_JRNL CURSOR FOR                            
                SELECT                                                  
                   LOCAL_OFFICE,                                        
                   CASH_DRAWER_ID,                                      
                   DATE_TRAN,                                           
                   ENTRY_NO,                                            
                   TRAN_APPL_NO,                                        
                   JRNL_SORT_ID,                                        
                   CUSTOMER_NO,                                         
                   ACCOUNT_NO,                                          
                   REPLACE(CONVERT(CHAR(8), TRAN_TIME, 108), ':', '.') 
           TRAN_TIME,                                           
                   TRAN_ID,                                             
                   DATE_LAST_ACTION,                                    
                   CODE_ENTRY_SOURCE,                                   
                   USER_ID,                                             
                   CODE_TRAN_ERRORS,                                    
                   CODE_JRNL_EXTRACT,                                   
                   DATE_JRNL_EXTRACT,                                   
                   TRAN_DATA,                                           
                   COMPANY_NO                                           
              FROM CSS_MISC_JRNL                                        
              WHERE CODE_JRNL_EXTRACT    <> 'Y'                         
              FOR UPDATE OF CODE_JRNL_EXTRACT, DATE_JRNL_EXTRACT        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ053
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04970014
MFA-TR*         DECLARE MISC_JRNL CURSOR FOR                            04980014
MFA-TR*         SELECT                                                  04990014
MFA-TR*            LOCAL_OFFICE,                                        05000015
MFA-TR*            CASH_DRAWER_ID,                                      05020014
MFA-TR*            DATE_TRAN,                                           05030014
MFA-TR*            ENTRY_NO,                                            05040014
MFA-TR*            TRAN_APPL_NO,                                        05050014
MFA-TR*            JRNL_SORT_ID,                                        05060014
MFA-TR*            CUSTOMER_NO,                                         05070014
MFA-TR*            ACCOUNT_NO,                                          05080014
MFA-TR*            TRAN_TIME,                                           05100014
MFA-TR*            TRAN_ID,                                             05110014
MFA-TR*            DATE_LAST_ACTION,                                    05120014
MFA-TR*            CODE_ENTRY_SOURCE,                                   05130014
MFA-TR*            USER_ID,                                             05140028
MFA-TR*            CODE_TRAN_ERRORS,                                    05170014
MFA-TR*            CODE_JRNL_EXTRACT,                                   05180014
MFA-TR*            DATE_JRNL_EXTRACT,                                   05190014
MFA-TR*            TRAN_DATA,                                           05200014
MFA-TR*            COMPANY_NO                                           03820014
MFA-TR*       FROM CSS_MISC_JRNL                                        05210014
MFA-TR*       WHERE CODE_JRNL_EXTRACT    = 'Y'                         05220014
MFA-TR*       FOR UPDATE OF CODE_JRNL_EXTRACT, DATE_JRNL_EXTRACT        05230014
MFA-TR*    END-EXEC.                                                    05240014
       01  WS-END                          PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA120 ENDS HERE  '.            
HPCCDM*    EJECT                                                        05270014
       PROCEDURE DIVISION.                                              
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05290014
      **                                                              **05300014
      **    0000-MAINLINE                                             **05310014
      **                                                              **05320014
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **05330014
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
T23814     PERFORM 0200-CALC-DATE-PARM-DAYS-AGO THRU 0200-EXIT.         
           PERFORM 0600-PREPARE-FOR-RESTART THRU 0600-EXIT.             
           PERFORM 0605-VALIDATE-RESTART-REQ THRU 0605-EXIT.            
      *                                                                 05380014
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-Y TO WS-REPOSITION-NEEDED                        
               MOVE SPACES TO FIOCA06                                   
           ELSE                                                         
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               MOVE SPACES TO WS-RESTART-INPUT-DATE                     
               MOVE WS-C   TO WS-RESTART-JOB-STATUS                     
               MOVE ZERO   TO WS-RESTART-CHKP-SEQ-NO                    
      *        **  MOVE ZERO TO ALL OUTPUT FILE COUNTER FIELDS        **05470014
               MOVE ZERO   TO WS-RESTART-FCSCA06-REC-CNTR               
      *        **  MOVE ZERO TO ALL DATABASE UPDATE COUNTER FIELDS    **05490014
      *        **  FIELDS THAT ARE "RESTART DATA" FIELDS.             **05500014
                 MOVE ZERO TO WS-RESTART-BJ-UPDT-CNTR-LUW               
                              WS-RESTART-CJ-UPDT-CNTR-LUW               
                              WS-RESTART-MJ-UPDT-CNTR-LUW               
                              WS-RESTART-RF-UPDT-CNTR-LUW               
                              WS-RESTART-RF-ISRT-CNTR-LUW               
                 MOVE ZERO TO WS-RESTART-BJ-UPDT-CNTR-TOT               
                              WS-RESTART-CJ-UPDT-CNTR-TOT               
                              WS-RESTART-MJ-UPDT-CNTR-TOT               
                              WS-RESTART-RF-UPDT-CNTR-TOT               
                              WS-RESTART-RF-ISRT-CNTR-TOT               
      *        **  NOT A RESTART, SO INITIALIZE KEY FIELDS OF     **    05610014
      *        **  BATCH_JRNL AND CSH_DRWR_JRNL FOR ORIGINAL RUN: **    05620014
      *        **  (MISC_JRNL'S PREDICATE MERELY FETCHES ALL NOT- **    05630014
      *        **  -YET-EXTRACTED MISCELLANEOUS JOURNALS:         **    05640014
RS               MOVE SPACES     TO BC-CASH-COMPANY-NO                  
RS                                  BC-CASH-LOCAL-OFFICE                
RS                                  BC-CASH-REPORT-NO                   
RS                                  CS-CASH-COMPANY-NO                  
RS                                  CS-CASH-LOCAL-OFFICE                
RS                                  CS-CASH-REPORT-NO                   
RS               MOVE WS-NINES-DATE                                     
RS                               TO BC-DATE-CASH-REPORT                 
RS    *T23814                       CS-DATE-CASH-REPORT                 03950015
T23814           MOVE WS-DATE-PARM-DAYS-AGO                             
T23814                           TO CS-DATE-CASH-REPORT                 
RS               MOVE ZEROES     TO BC-CASH-DRAWER-ID                   
RS                                  CS-CASH-DRAWER-ID
           END-IF.                  
      *** LOAD THE PREDICATE KEY VALUES ACCORDING TO WHETHER THIS IS AN 05710014
      *** ORIGINAL RUN OR A RESTART DUE TO PREVIOUS ABEND IN ONE OF THE 05720014
      *** PROCESSING LOOPS:                                             05730014
           IF WS-THIS-IS-A-RESTART                                      
              IF WS-PROCESS-TYPE EQUAL WS-1                             
                 MOVE WS-RESTART-CASH-COMPANY-NO                        
                                              TO BC-CASH-COMPANY-NO     
                 MOVE WS-RESTART-CASH-LOCAL-OFFICE                      
                                              TO BC-CASH-LOCAL-OFFICE   
                 MOVE WS-RESTART-CASH-REPORT-NO                         
                                              TO BC-CASH-REPORT-NO      
                 MOVE WS-RESTART-DATE-CASH-REPORT                       
                                              TO BC-DATE-CASH-REPORT    
                 MOVE WS-RESTART-CASH-DRAWER-ID                         
                                              TO BC-CASH-DRAWER-ID      
RS               MOVE SPACES                  TO CS-CASH-COMPANY-NO     
RS                                               CS-CASH-LOCAL-OFFICE   
RS                                               CS-CASH-REPORT-NO      
RS    *T23814    MOVE WS-NINES-DATE           TO CS-DATE-CASH-REPORT    03950015
T23814           MOVE WS-DATE-PARM-DAYS-AGO   TO CS-DATE-CASH-REPORT    
RS               MOVE ZEROES                  TO CS-CASH-DRAWER-ID      
              ELSE                                                      
              IF WS-PROCESS-TYPE EQUAL WS-2                             
RS               MOVE WS-99                   TO BC-CASH-COMPANY-NO     
RS               MOVE WS-999                  TO BC-CASH-LOCAL-OFFICE   
RS                                               BC-CASH-REPORT-NO      
RS               MOVE WS-ZERO-DATE            TO BC-DATE-CASH-REPORT    
RS               MOVE 9999                    TO BC-CASH-DRAWER-ID      
                 MOVE WS-RESTART-CASH-COMPANY-NO                        
                                              TO CS-CASH-COMPANY-NO     
                 MOVE WS-RESTART-CASH-LOCAL-OFFICE                      
                                              TO CS-CASH-LOCAL-OFFICE   
                 MOVE WS-RESTART-CASH-REPORT-NO                         
                                              TO CS-CASH-REPORT-NO      
                 MOVE WS-RESTART-DATE-CASH-REPORT                       
                                              TO CS-DATE-CASH-REPORT    
                 MOVE WS-RESTART-CASH-DRAWER-ID                         
                                              TO CS-CASH-DRAWER-ID      
              ELSE                                                      
RS               MOVE WS-99                   TO BC-CASH-COMPANY-NO     
RS                                               CS-CASH-COMPANY-NO     
RS               MOVE WS-999                  TO BC-CASH-LOCAL-OFFICE   
RS                                               BC-CASH-REPORT-NO      
RS                                               CS-CASH-LOCAL-OFFICE   
RS                                               CS-CASH-REPORT-NO      
RS               MOVE WS-ZERO-DATE            TO BC-DATE-CASH-REPORT    
RS    *T23814                                    CS-DATE-CASH-REPORT    03950015
T23814           MOVE WS-NINES-DATE           TO CS-DATE-CASH-REPORT    
RS               MOVE 9999                    TO BC-CASH-DRAWER-ID      
RS                                               CS-CASH-DRAWER-ID
              END-IF
              END-IF      
           ELSE                                                         
               PERFORM 2001-WRITE-BEGIN-CONTROLS THRU 2001-EXIT         
               MOVE WS-1   TO WS-PROCESS-TYPE                           
      *        ******************************************************** 06090014
      *          ISSUE AN INITIAL CHECKPOINT:                           06100014
      *        ******************************************************** 06110014
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                   
               MOVE WS-Y TO WS-REPOSITION-NEEDED                        
               MOVE WS-INPUT-DATE TO WS-RESTART-INPUT-DATE
           END-IF.             
           PERFORM 1000-PROCESS-JRNL-EXTRACT THRU 1000-EXIT.            
           PERFORM 2999-WRITE-END-REC THRU 2999-EXIT.                   
      ******************************************************************06180014
      * THE FOLLOWING STATEMENTS UPGRADE THE JOB-COMPLETE FIELD TO      06190014
      * INDICATE A SUCCESSFUL COMPLETION:                               06200014
      ******************************************************************06210014
           MOVE SPACES    TO WS-RESTART-JOB-COMPLETE.                   
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-B TO WS-RESTART-JOB-STATUS                       
           ELSE                                                         
               MOVE WS-A TO WS-RESTART-JOB-STATUS
           END-IF.                      
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
           AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS      
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 8899-WRITE-RSDDR THRU 8899-EXIT
           END-IF.                 
      *                                                                 06320014
           IF WS-PRINT-COUNTERS EQUAL WS-B OR WS-C                      
               PERFORM 8600-PRINT-COUNTERS THRU 8600-EXIT
           END-IF.              
      *                                                                 06350014
           IF WS-RESTART-REQ EQUAL WS-Y                                 
               PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT
           END-IF.      
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           DISPLAY 'PCSCA120 COMPLETED'.                                
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06430014
      **                                                              **06440014
      **    0100-INITIALIZATION                                       **06450014
      **                                                              **06460014
      **   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **06470014
       0100-INITIALIZATION.                                             
           OPEN EXTEND  FCSCA06-FILE.                                   
           IF FCA06-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY 'VSAM OPEN ERROR FCSCA06-FILE.'                  
               DISPLAY 'FILE STATUS IS ' WS-FCA06-STATUS                
               DISPLAY '*   PROCESSING TERMINATED'                      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
           PERFORM 6251-GET-FJC01-DATE        THRU 6251-EXIT.           
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT       
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE
           END-IF.           
           PERFORM 6253-GET-FJC01-CHKP-LIMIT THRU 6253-EXIT.            
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
           AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS      
               DISPLAY ' '                                              
               DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
               DISPLAY '**   CHKP-LUW AND CHKP-UPD PARMS   **'          
               DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
                       ', INTERPRETED TO**'                             
               DISPLAY '**  INDICATE THAT INTERIM COMMIT   **'          
               DISPLAY '**   POINTS SHOULD NOT BE TAKEN.   **'          
               DISPLAY '** COMPLETE RERUN WILL BE REQUIRED **'          
               DISPLAY '**  UPON UNSUCCESSFUL COMPLETION.  **'          
               DISPLAY '**      PROCESSING CONTINUING      **'
           END-IF.         
           PERFORM 6254-GET-FJC01-STOP-KEY   THRU 6254-EXIT.            
           MOVE WS-STOP-KEY TO WS-STOP-PARM-BREAKDOWN.                  
           IF WS-STOP-PARM-PROCESS-TYPE GREATER THAN SPACES             
               MOVE WS-STOP-PARM-PROCESS-TYPE TO WS-STOP-PROCESS-TYPE   
           ELSE                                                         
               MOVE SPACES                    TO WS-STOP-PROCESS-TYPE
           END-IF.  
           IF WS-STOP-PARM-CASH-COMPANY-NO NUMERIC                      
               MOVE WS-STOP-PARM-CASH-COMPANY-NO                        
                                          TO WS-STOP-CASH-COMPANY-NO    
           ELSE                                                         
               MOVE WS-99                 TO WS-STOP-CASH-COMPANY-NO
           END-IF.   
           IF WS-STOP-PARM-CASH-LOCAL-OFFICE NUMERIC                    
               MOVE WS-STOP-PARM-CASH-LOCAL-OFFICE                      
                                          TO WS-STOP-CASH-LOCAL-OFFICE  
           ELSE                                                         
               MOVE WS-999                TO WS-STOP-CASH-LOCAL-OFFICE
           END-IF. 
           IF WS-STOP-PARM-CASH-REPORT-NO NUMERIC                       
               MOVE WS-STOP-PARM-CASH-REPORT-NO                         
                                          TO WS-STOP-CASH-REPORT-NO     
           ELSE                                                         
               MOVE WS-999                TO WS-STOP-CASH-REPORT-NO
           END-IF.    
           IF WS-STOP-PARM-CCYY      NUMERIC AND                        
              WS-STOP-PARM-MM        NUMERIC AND                        
              WS-STOP-PARM-DD        NUMERIC AND                        
              WS-STOP-PARM-DASH-1      EQUAL WS-DASH AND                
              WS-STOP-PARM-DASH-2      EQUAL WS-DASH                    
               MOVE WS-STOP-PARM-DATE-CASH-REPORT                       
                                          TO WS-STOP-DATE-CASH-REPORT   
           ELSE                                                         
               MOVE WS-ZERO-DATE          TO WS-STOP-DATE-CASH-REPORT
           END-IF.  
           IF WS-STOP-PARM-CASH-DRAWER-ID NUMERIC                       
               MOVE WS-STOP-PARM-CASH-DRAWER-ID                         
                                          TO WS-STOP-CASH-DRAWER-ID     
           ELSE                                                         
               MOVE 9999                  TO WS-STOP-CASH-DRAWER-ID
           END-IF.    
           IF WS-STOP-PARM-DATE-TRAN NUMERIC                            
               MOVE WS-STOP-PARM-DATE-TRAN    TO WS-STOP-DATE-TRAN      
           ELSE                                                         
               MOVE WS-99999999               TO WS-STOP-DATE-TRAN
           END-IF.     
           IF WS-STOP-PARM-ENTRY-NO NUMERIC                             
               MOVE WS-STOP-PARM-ENTRY-NO     TO WS-STOP-ENTRY-NO       
           ELSE                                                         
               MOVE WS-999999999              TO WS-STOP-ENTRY-NO
           END-IF.      
           PERFORM 6255-GET-FJC01-PRT-CNTR THRU 6255-EXIT.              
           PERFORM 6235-GET-FJC01-RESTART-REQ THRU 6235-EXIT.           
T24436     MOVE WS-PGRMNAME                   TO                        
T24436                                        WS-CPD00061-CALLING-PGM.  
T24436     MOVE SPACES                        TO  ABEND-FUNCTION.       
T24436     CALL SCSCB061  USING   WS-GL-ACCT-NAME,                      
T24436                            WS-GL-ACCT-MAJOR-FIELDS,              
T24436                            WS-VALID-COMPANY-NOS,                 
T24436                            WS-GL-NAME-INFO,                      
T24436                            WS-GL-ACCT-NO-TABLE,                  
T24436                            WS-CPD00061-CALLING-PGM,              
T24436                            ABEND-FILE,                           
T24436                            RS-RETURN-CODE.                       
T24436                                                                  
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T24436     END-IF.                                                      
T24436*    PERFORM 0700-LOAD-GL-NO-VALUES     THRU 0700-EXIT.           07240040
C35692     PERFORM 6000-LOCK-BCH-JRNL-CNTL    THRU 6000-EXIT.           
C35692     PERFORM 6100-LOCK-BATCH-JRNL       THRU 6100-EXIT.           
C35692     PERFORM 6200-LOCK-CSH-DRWR-CNTL    THRU 6200-EXIT.           
C35692     PERFORM 6300-LOCK-CSH-DRWR-JRNL    THRU 6300-EXIT.           
C35692     PERFORM 6400-LOCK-MISC-JRNL        THRU 6400-EXIT.           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T23814*****************************************************************         
T23814*0200-CALC-DATE-PARM-DAYS-AGO                                   *         
T23814*****************************************************************         
T23814 0200-CALC-DATE-PARM-DAYS-AGO.                                    
T23814     MOVE WS-INPUT-DATE TO WS-DISPLAY-DATE.                       
T23814     MOVE WS-DISPLAY-CC TO WS-CCD-DATE-CC.                        
T23814     MOVE WS-DISPLAY-YY TO WS-CCD-DATE-YY.                        
T23814     MOVE WS-DISPLAY-MM TO WS-CCD-DATE-MM.                        
T23814     MOVE WS-DISPLAY-DD TO WS-CCD-DATE-DD.                        
T23814     MOVE WS-DISPLAY-DATE TO WS-CCD-START-DATE.                   
T23814     MOVE WS-CCD-SUBTRACT-DAYS TO WS-CCD-PLUS-MINUS.              
T23814     MOVE  WS-PURGE-JRNL TO WS-CCD-DAYS-PLUS-MINUS.               
A04011     PERFORM 7000-GET-PURGE-JRNL                                  
A04011        THRU 7000-EXIT                                            
A04011     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04011        MOVE C8-DELINQ-VALUE TO WS-CCD-DAYS-PLUS-MINUS            
A04011     END-IF                                                       
T23814     PERFORM 6600-COMPUTE-CALENDAR-DATE THRU                      
T23814             6600-COMPUTE-DATE-EXIT.                              
T23814     PERFORM 7800-SQL-CODE-CHECK           THRU 7800-EXIT.        
T23814     MOVE WS-CCD-NEW-DATE TO WS-DATE-PARM-DAYS-AGO.               
T23814     MOVE WS-DASH TO WS-DATE-PARM-DAYS-AGO (5:1).                 
T23814     MOVE WS-DASH TO WS-DATE-PARM-DAYS-AGO (8:1).                 
T23814 0200-EXIT.                                                       
T23814     EXIT.                                                        
                                                                        
       0600-PREPARE-FOR-RESTART.                                        
           MOVE WS-PGRMNAME    TO RF-NAME-PROGRAM.                      
           MOVE WS-1           TO RF-PARTITION-NO                       
                                  RF-DUP-CNTRL-NO                       
                                  WS-CHKP-PART-NO.                      
           PERFORM 7900-SELECT-RESTART-DATA THRU 7900-EXIT.             
      *                                                                 07370014
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT TO WS-RESTART-DATA             
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                   MOVE WS-Y TO WS-IS-THIS-A-RESTART                    
               ELSE                                                     
                   GO TO 0600-EXIT
               END-IF                                      
           ELSE                                                         
               GO TO 0600-EXIT
           END-IF.                                         
      *                                                                 07460014
           DISPLAY '*******************************************'.       
           DISPLAY '*****  THIS IS A RESTART OF JCSCA120  *****'.       
           DISPLAY '*******************************************'.       
           MOVE WS-RESTART-PROCESS-TYPE TO WS-PROCESS-TYPE.             
           MOVE WS-RESTART-CHKP-SEQ-NO  TO WS-CHKP-SEQ-NO.              
      ***********************************************************       07520014
      ** THE FOLLOWING CODE COMPARES RUN DATE STORED IN        **       07530014
      ** RESTART DATA TO RUN DATE FROM JOB CONTROL FILE:       **       07540014
      ***********************************************************       07550014
      *                                                                 07560014
           IF WS-RESTART-INPUT-DATE EQUAL WS-INPUT-DATE                 
           OR WS-RESTART-INPUT-DATE EQUAL SPACES                        
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '** RUN DATE WAS CHANGED PRIOR TO '              
                       'RESTART **'                                     
               DISPLAY '***************************************'        
               DISPLAY '** OLD RUN DATE = ' WS-RESTART-INPUT-DATE       
               DISPLAY '** NEW RUN DATE = ' WS-INPUT-DATE               
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 07680014
           MOVE WS-RESTART-CASH-DB-BUCKET TO WS-CASH-DB-BUCKET.         
           MOVE WS-RESTART-CASH-CR-BUCKET TO WS-CASH-CR-BUCKET.         
           MOVE WS-RESTART-AR-DB-BUCKET   TO WS-AR-DB-BUCKET.           
           MOVE WS-RESTART-AR-CR-BUCKET   TO WS-AR-CR-BUCKET.           
           MOVE WS-RESTART-CKI-DB-BUCKET  TO WS-CKI-DB-BUCKET.          
           MOVE WS-RESTART-CKI-CR-BUCKET  TO WS-CKI-CR-BUCKET.          
           MOVE WS-RESTART-GL-DB-BUCKET   TO WS-GL-DB-BUCKET.           
           MOVE WS-RESTART-GL-CR-BUCKET   TO WS-GL-CR-BUCKET            
           MOVE WS-RESTART-BJ-COUNTER     TO WS-BJ-COUNTER.             
           MOVE WS-RESTART-CJ-COUNTER     TO WS-CJ-COUNTER.             
           MOVE WS-RESTART-MJ-COUNTER     TO WS-MJ-COUNTER.             
      *                                                                 07800014
       0600-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        07830014
       COPY CPD00030.                                                   07840014
T24436*COPY CPD00061.                                                   07841048
      *                                                                 07850014
HPCCDM*    EJECT                                                        07860014
       1000-PROCESS-JRNL-EXTRACT.                                       
      *** PREDICATE KEYS WERE LOADED IN 0000, DEPENDING UPON WHETHER    07880014
      *** THIS WAS A RESTART OR NOT.  PGM WILL EXECUTE ALL 3 PROCESSING 07890014
      *** LOOPS, UNLESS WS-PROCESS-TYPE INDICATES THAT THIS IS A RESTART07900014
      *** RUN AND THE ABEND OCCURRED DURING COMPLETION OF THE 2ND OR 3RD07910014
      *** LOOP:                                                         07920014
           IF WS-PROCESS-TYPE EQUAL WS-1                                
               PERFORM 7100-OPEN-BATCH-JRNL-CNTRL THRU 7100-EXIT        
               PERFORM 7110-FETCH-BATCH-JRNL-CNTRL THRU 7110-EXIT       
               PERFORM 1100-BATCH-JRNL-EXTRACT THRU 1100-EXIT           
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
               PERFORM 7120-CLOSE-BATCH-JRNL-CNTRL THRU 7120-EXIT       
               MOVE WS-2 TO WS-PROCESS-TYPE                             
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                   
               MOVE WS-Y TO WS-REPOSITION-NEEDED
           END-IF.                       
      *                                                                 08030014
           IF WS-PROCESS-TYPE EQUAL WS-2                                
               PERFORM 7300-OPEN-CASH-DRWR-CNTRL THRU 7300-EXIT         
               PERFORM 7310-FETCH-CASH-DRWR-CNTRL THRU 7310-EXIT        
               PERFORM 1200-CASH-JRNL-EXTRACT THRU 1200-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
               PERFORM 7320-CLOSE-CASH-DRWR-CNTRL THRU 7320-EXIT        
               MOVE WS-3 TO WS-PROCESS-TYPE                             
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                   
               MOVE WS-Y TO WS-REPOSITION-NEEDED
           END-IF.                       
      *                                                                 08140014
           IF WS-PROCESS-TYPE EQUAL WS-3                                
               PERFORM 7500-OPEN-MISC-JRNL THRU 7500-EXIT               
               PERFORM 7510-FETCH-MISC-JRNL THRU 7510-EXIT              
               PERFORM 1300-MISC-JRNL-EXTRACT THRU 1300-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
               PERFORM 7520-CLOSE-MISC-JRNL THRU 7520-EXIT              
               MOVE WS-4 TO WS-PROCESS-TYPE                             
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT                   
               MOVE WS-Y TO WS-REPOSITION-NEEDED
           END-IF.                       
       1000-EXIT.                                                       
           EXIT.                                                        
       1100-BATCH-JRNL-EXTRACT.                                         
           PERFORM  7200-OPEN-BATCH-JRNL  THRU  7200-EXIT.              
           PERFORM  7210-FETCH-BATCH-JRNL  THRU  7210-EXIT.             
           PERFORM  1110-EXTRACT-BATCH-JRNL THRU  1110-EXIT             
                    UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.        
           PERFORM  7220-CLOSE-BATCH-JRNL  THRU  7220-EXIT.             
      *                                                                 08330014
           MOVE WS-BC  TO  WS-TYPE-CHECK.                               
           IF (WS-BJ-COUNTER EQUAL ZERO)                                
               AND (BC-AMT-CASH-DEBIT EQUAL ZERO)                       
               AND (BC-AMT-CASH-CREDIT EQUAL ZERO)                      
               AND (BC-AMT-AR-DEBIT EQUAL ZERO)                         
               AND (BC-AMT-AR-CREDIT EQUAL ZERO)                        
               AND (BC-AMT-CK-ISS-DEBIT EQUAL ZERO)                     
               AND (BC-AMT-CK-ISS-CREDIT EQUAL ZERO)                    
               AND (BC-AMT-GL-DEBIT EQUAL ZERO)                         
               AND (BC-AMT-GL-CREDIT EQUAL ZERO)                        
               NEXT SENTENCE                                            
           ELSE                                                         
           IF (BC-AMT-CASH-DEBIT EQUAL WS-CASH-DB-BUCKET)               
               AND (BC-AMT-CASH-CREDIT                                  
                   EQUAL WS-CASH-CR-BUCKET)                             
               AND (BC-AMT-AR-DEBIT EQUAL WS-AR-DB-BUCKET)              
               AND (BC-AMT-AR-CREDIT EQUAL WS-AR-CR-BUCKET)             
               AND (BC-AMT-CK-ISS-DEBIT                                 
                    EQUAL WS-CKI-DB-BUCKET)                             
               AND (BC-AMT-CK-ISS-CREDIT                                
                    EQUAL WS-CKI-CR-BUCKET)                             
               AND (BC-AMT-GL-DEBIT                                     
                    EQUAL WS-GL-DB-BUCKET)                              
               AND (BC-AMT-GL-CREDIT                                    
                    EQUAL WS-GL-CR-BUCKET)                              
                   PERFORM 2100-CREATE-CNTRL-EXTRACTS THRU 2100-EXIT    
               ELSE                                                     
                   MOVE WS-YES TO WS-SHOULD-PRINT-JRNL-0002             
                   PERFORM 2100-CREATE-CNTRL-EXTRACTS THRU 2100-EXIT
           END-IF
           END-IF.   
           MOVE ZERO  TO  WS-BJ-COUNTER.                                
      *                                                                 08640014
           PERFORM 7110-FETCH-BATCH-JRNL-CNTRL  THRU  7110-EXIT.        
       1100-EXIT.                                                       
           EXIT.                                                        
       1110-EXTRACT-BATCH-JRNL.                                         
           MOVE WS-YES                  TO BJ-CODE-JRNL-EXTRACT.        
           MOVE WS-INPUT-DATE           TO BJ-DATE-JRNL-EXTRACT.        
           MOVE BJ-JRNL-SORT-ID         TO E-FCA06-JRNL-SORT-ID.        
TP8095     MOVE BJ-LOCAL-OFFICE         TO E-FCA06-LOCAL-OFFICE.        
TP8095*    MOVE BJ-CASH-LOCAL-OFFICE    TO E-FCA06-LOCAL-OFFICE.        08800016
           MOVE BJ-COMPANY-NO           TO E-FCA06-COMPANY-NO.          
           MOVE BJ-ACCOUNT-NO           TO E-FCA06-RECORD-ID-ACCT-NO.   
           MOVE BJ-DATE-TRAN            TO E-FCA06-TRAN-DATE.           
           IF WS-NULL-IND-3          EQUAL ZERO                         
              MOVE BJ-DATE-LAST-ACTION  TO E-FCA06-DATE-LAST-ACTION     
           ELSE                                                         
              MOVE '0000-00-00'         TO E-FCA06-DATE-LAST-ACTION
           END-IF.    
           IF WS-NULL-IND-2          EQUAL ZERO                         
              MOVE BJ-TRAN-TIME         TO E-FCA06-TRAN-TIME            
           ELSE                                                         
              MOVE '00.00.00'           TO E-FCA06-TRAN-TIME
           END-IF.           
           MOVE BJ-TRAN-ID              TO E-FCA06-CODE-TERMINAL-TRAN.  
           MOVE BJ-TRAN-APPL-NO         TO E-FCA06-JRNL-TRAN-APPL-NO.   
           MOVE BJ-CODE-ENTRY-SOURCE    TO E-FCA06-CODE-ENTRY-SOURCE.   
           MOVE BJ-USER-ID              TO E-FCA06-USER-ID.             
           MOVE BJ-CODE-TRAN-ERRORS     TO E-FCA06-TRANS-ERRORS.        
RS         MOVE BJ-CASH-COMPANY-NO      TO E-FCA06-CASH-COMPANY-NO.     
RS         MOVE BJ-CASH-LOCAL-OFFICE    TO E-FCA06-CASH-LOCAL-OFFICE.   
RS         MOVE BJ-CASH-REPORT-NO       TO E-FCA06-CASH-REPORT-NO.      
RS         MOVE BJ-DATE-CASH-REPORT     TO E-FCA06-DATE-CASH-REPORT.    
RS         MOVE BJ-CASH-DRAWER-ID       TO E-FCA06-CASH-DRAWER-ID.      
           MOVE BJ-TRAN-DATA            TO E-FCA06-USER-DEFINED-AREA.   
           MOVE BJ-TRAN-DATA            TO CJF00101.                    
           MOVE WS-101-JRNL-FORMAT-NO   TO WS-JRNL-USER-DEFINED-TYPE.   
           MOVE WS-BJ                   TO WS-TYPE-CHECK.               
           MOVE BJ-COMPANY-NO           TO WS-COMPANY-NO.               
           PERFORM 2000-FORMAT-TYPE THRU  2000-EXIT.                    
           PERFORM 8210-UPDATE-BATCH-JRNL  THRU  8210-EXIT.             
           ADD 1 TO WS-BJ-COUNTER.                                      
TEST       MOVE BJ-ENTRY-NO             TO E-FCA06-ENTRY-NO.            
TEST       MOVE WS-N                    TO WS-CNTL-JRNL-SW.             
           PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT.                 
      ***************************************************************** 09010014
      * THE FOLLOWING STATEMENTS OCCUR JUST PRIOR TO THE LOOPING READ   09020014
      * OF THE BJ TABLE:                                                09030014
      ***************************************************************** 09040014
      *                                                                 09050014
      *********                                                         09060014
      * THE FOLLOWING STATEMENT COMPARES THE STOP KEY TO THE          * 09070014
      * LOCAL_OFFICE/BATCH_NO/DATE_TRAN/ENTRY_NO IN THE               * 09080016
      * LAST BATCH_JRNL FETCHED, & ABENDS IF THE 5 FLDS ARE EQUAL,    * 09090014
      * PLUS IF STOP KEY REQUESTED THAT THE ABEND OCCUR IN THE BJ     * 09100014
      * LOOP:                                                         * 09110014
      *********                                                         09120014
           IF STOP-REQUESTED-IN-BJ-LOOP                                 
           AND BJ-CASH-COMPANY-NO   EQUAL WS-STOP-CASH-COMPANY-NO       
           AND BJ-CASH-LOCAL-OFFICE EQUAL WS-STOP-CASH-LOCAL-OFFICE     
           AND BJ-CASH-REPORT-NO    EQUAL WS-STOP-CASH-REPORT-NO        
           AND BJ-DATE-CASH-REPORT  EQUAL WS-STOP-DATE-CASH-REPORT      
           AND BJ-CASH-DRAWER-ID    EQUAL WS-STOP-CASH-DRAWER-ID        
           AND BJ-DATE-TRAN         EQUAL WS-STOP-DATE-TRAN             
           AND BJ-ENTRY-NO          EQUAL WS-STOP-ENTRY-NO              
               DISPLAY '******************************************'     
               DISPLAY '*****  JOB STOPPED DUE TO STOP PARM  *****'     
               DISPLAY '******************************************'     
               DISPLAY '*** STOP WAS REQUESTED IN BATCH JRNL LOOP*'     
               DISPLAY '*** STOP CASH COMPANY NO   = '                  
                        WS-STOP-CASH-COMPANY-NO                         
               DISPLAY '*** STOP CASH LOCAL OFFICE = '                  
                        WS-STOP-CASH-LOCAL-OFFICE                       
               DISPLAY '*** STOP CASH REPORT NO    = '                  
                        WS-STOP-CASH-REPORT-NO                          
               DISPLAY '*** STOP DATE CASH REPORT  = '                  
                        WS-STOP-DATE-CASH-REPORT                        
               DISPLAY '*** STOP CASH DRAWER ID    = '                  
                        WS-STOP-CASH-DRAWER-ID                          
               DISPLAY '*** STOP DATE TRAN         = ' WS-STOP-DATE-TRAN
               DISPLAY '*** STOP ENTRY NO          = ' WS-STOP-ENTRY-NO 
               DISPLAY '***  CONCATENATED KEY PRIOR TO LAST CHECKPOINT:'
               DISPLAY ' '                                              
               DISPLAY '  *    LAST BC CASH COMPANY NO   = '            
                       WS-RESTART-CASH-COMPANY-NO                       
               DISPLAY '  *    LAST BC CASH LOCAL OFFICE = '            
                       WS-RESTART-CASH-LOCAL-OFFICE                     
               DISPLAY '  *    LAST BC CASH REPORT NO    = '            
                       WS-RESTART-CASH-REPORT-NO                        
               DISPLAY '  *    LAST BC DATE CASH REPORT  = '            
                       WS-RESTART-DATE-CASH-REPORT                      
               DISPLAY '  *    LAST BC CASH DRAWER ID    = '            
                       WS-RESTART-CASH-DRAWER-ID                        
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *********                                                         09370014
      * THE FOLLOWING STATEMENTS ISSUE A CHECKPOINT IF THE CHKP-LUW    *09380014
      * LIMIT HAS BEEN REACHED OR THE CHKP-UPD LIMIT HAS BEEN REACHED  *09390014
      * OR EXCEEDED:                                                   *09400014
      *********                                                         09410014
           ADD 1 TO WS-CHKP-LUW-COUNTER.                                
           IF WS-CHKP-LUW-COUNTER EQUAL WS-CHKP-LUW-LIMIT OR            
              WS-CHKP-UPD-COUNTER  EQUAL WS-CHKP-UPD-LIMIT OR           
              WS-CHKP-UPD-COUNTER  GREATER THAN WS-CHKP-UPD-LIMIT       
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT
           END-IF.                  
           IF WS-PRINT-COUNTERS EQUAL WS-C                              
                   PERFORM 8601-PRINT-COUNTERS THRU 8601-EXIT
           END-IF.          
      ******************************************************************09490014
      * NOW CONTINUE READING BATCH_JRNL:                                09500014
      ******************************************************************09510014
      *                                                                 09520014
           PERFORM 7210-FETCH-BATCH-JRNL  THRU  7210-EXIT.              
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09560014
       1200-CASH-JRNL-EXTRACT.                                          
           PERFORM  7400-OPEN-CASH-DRWR  THRU  7400-EXIT.               
           PERFORM  7410-FETCH-CASH-DRWR THRU  7410-EXIT.               
           PERFORM  1210-EXTRACT-CASH-DRWR THRU  1210-EXIT              
                    UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.        
           PERFORM  7420-CLOSE-CASH-DRWR   THRU  7420-EXIT.             
      *                                                                 09630014
           MOVE WS-CC  TO  WS-TYPE-CHECK.                               
           IF (CS-AMT-CASH-DEBIT EQUAL WS-CASH-DB-BUCKET)               
              AND (CS-AMT-CASH-CREDIT                                   
                   EQUAL WS-CASH-CR-BUCKET)                             
              AND (CS-AMT-AR-DEBIT EQUAL WS-AR-DB-BUCKET)               
              AND (CS-AMT-AR-CREDIT EQUAL WS-AR-CR-BUCKET)              
              AND (CS-AMT-CK-ISS-DEBIT                                  
                   EQUAL WS-CKI-DB-BUCKET)                              
              AND (CS-AMT-CK-ISS-CREDIT                                 
                   EQUAL WS-CKI-CR-BUCKET)                              
              AND (CS-AMT-GL-DEBIT                                      
                   EQUAL WS-GL-DB-BUCKET)                               
              AND (CS-AMT-GL-CREDIT                                     
                   EQUAL WS-GL-CR-BUCKET)                               
              PERFORM 2100-CREATE-CNTRL-EXTRACTS THRU 2100-EXIT         
           ELSE                                                         
              MOVE WS-YES TO WS-SHOULD-PRINT-JRNL-0002                  
              PERFORM 2100-CREATE-CNTRL-EXTRACTS THRU 2100-EXIT
           END-IF.        
      *                                                                 09820014
           PERFORM 7310-FETCH-CASH-DRWR-CNTRL  THRU  7310-EXIT.         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09860014
       1210-EXTRACT-CASH-DRWR.                                          
      *                                                                 09930014
           MOVE WS-YES                  TO CJ-CODE-JRNL-EXTRACT.        
           MOVE WS-INPUT-DATE           TO CJ-DATE-JRNL-EXTRACT.        
           MOVE CJ-JRNL-SORT-ID         TO E-FCA06-JRNL-SORT-ID.        
           MOVE CJ-LOCAL-OFFICE         TO E-FCA06-LOCAL-OFFICE.        
           MOVE CJ-COMPANY-NO           TO E-FCA06-COMPANY-NO.          
           MOVE CJ-ACCOUNT-NO           TO E-FCA06-RECORD-ID-ACCT-NO.   
           MOVE CJ-DATE-TRAN            TO E-FCA06-TRAN-DATE.           
           IF WS-NULL-IND-3          EQUAL ZERO                         
              MOVE CJ-DATE-LAST-ACTION  TO E-FCA06-DATE-LAST-ACTION     
           ELSE                                                         
              MOVE '0000-00-00'         TO E-FCA06-DATE-LAST-ACTION
           END-IF.    
           IF WS-NULL-IND-2          EQUAL ZERO                         
              MOVE CJ-TRAN-TIME         TO E-FCA06-TRAN-TIME            
           ELSE                                                         
              MOVE '00.00.00'           TO E-FCA06-TRAN-TIME
           END-IF.           
           MOVE CJ-TRAN-ID              TO E-FCA06-CODE-TERMINAL-TRAN.  
           MOVE CJ-TRAN-APPL-NO         TO E-FCA06-JRNL-TRAN-APPL-NO.   
           MOVE CJ-CODE-ENTRY-SOURCE    TO E-FCA06-CODE-ENTRY-SOURCE.   
           MOVE CJ-USER-ID              TO E-FCA06-USER-ID.             
           MOVE CJ-CODE-TRAN-ERRORS     TO E-FCA06-TRANS-ERRORS.        
RS         MOVE CJ-CASH-COMPANY-NO      TO E-FCA06-CASH-COMPANY-NO.     
RS         MOVE CJ-CASH-LOCAL-OFFICE    TO E-FCA06-CASH-LOCAL-OFFICE.   
RS         MOVE CJ-CASH-REPORT-NO       TO E-FCA06-CASH-REPORT-NO.      
RS         MOVE CJ-DATE-CASH-REPORT     TO E-FCA06-DATE-CASH-REPORT.    
RS         MOVE CJ-CASH-DRAWER-ID       TO E-FCA06-CASH-DRAWER-ID.      
           MOVE CJ-TRAN-DATA            TO E-FCA06-USER-DEFINED-AREA.   
           MOVE CJ-TRAN-DATA            TO CJF00101.                    
           MOVE WS-101-JRNL-FORMAT-NO TO WS-JRNL-USER-DEFINED-TYPE.     
           MOVE WS-CJ                   TO  WS-TYPE-CHECK.              
           MOVE CJ-COMPANY-NO           TO WS-COMPANY-NO.               
           PERFORM  2000-FORMAT-TYPE   THRU  2000-EXIT.                 
           PERFORM 8410-UPDATE-CASH-DRWR  THRU  8410-EXIT.              
           ADD 1 TO WS-CJ-COUNTER.                                      
TEST       MOVE CJ-ENTRY-NO             TO E-FCA06-ENTRY-NO.            
TEST       MOVE WS-N                    TO WS-CNTL-JRNL-SW.             
           PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT.                 
      ***************************************************************** 10210014
      * THE FOLLOWING STATEMENTS OCCUR JUST PRIOR TO THE LOOPING READ   10220014
      * OF THE CJ TABLE:                                                10230014
      ***************************************************************** 10240014
      *                                                                 10250014
      *********                                                         10260014
      * THE FOLLOWING STATEMENT COMPARES THE STOP KEY TO THE          * 10270014
      * LOCAL_OFFICE/DISTRICT_NO/CASH_DRAWER_ID/DATE_TRAN/ENTRY_NO IN * 10280016
      * THE LAST CSH_DRWR_JRNL FETCHED, & ABENDS IF THE 5 FLDS ARE    * 10290014
      * EQUAL, PLUS IF STOP KEY REQUESTED THAT THE ABEND OCCUR IN     * 10300014
      * THE CJ LOOP:                                                  * 10310014
      *********                                                         10320014
           IF STOP-REQUESTED-IN-CJ-LOOP                                 
           AND CJ-CASH-COMPANY-NO   EQUAL WS-STOP-CASH-COMPANY-NO       
           AND CJ-CASH-LOCAL-OFFICE EQUAL WS-STOP-CASH-LOCAL-OFFICE     
           AND CJ-CASH-REPORT-NO    EQUAL WS-STOP-CASH-REPORT-NO        
           AND CJ-DATE-CASH-REPORT  EQUAL WS-STOP-DATE-CASH-REPORT      
           AND CJ-CASH-DRAWER-ID    EQUAL WS-STOP-CASH-DRAWER-ID        
           AND CJ-DATE-TRAN         EQUAL WS-STOP-DATE-TRAN             
           AND CJ-ENTRY-NO          EQUAL WS-STOP-ENTRY-NO              
               DISPLAY '******************************************'     
               DISPLAY '*****  JOB STOPPED DUE TO STOP PARM  *****'     
               DISPLAY '******************************************'     
               DISPLAY '*** STOP WAS REQUESTED IN CASH DRWR JRNL LOOP*' 
               DISPLAY '*** STOP CASH COMPANY NO   = '                  
                        WS-STOP-CASH-COMPANY-NO                         
               DISPLAY '*** STOP CASH LOCAL OFFICE = '                  
                        WS-STOP-CASH-LOCAL-OFFICE                       
               DISPLAY '*** STOP CASH REPORT NO    = '                  
                        WS-STOP-CASH-REPORT-NO                          
               DISPLAY '*** STOP DATE CASH REPORT  = '                  
                        WS-STOP-DATE-CASH-REPORT                        
               DISPLAY '*** STOP CASH DRAWER ID    = '                  
                        WS-STOP-CASH-DRAWER-ID                          
               DISPLAY '*** STOP DATE TRAN         = ' WS-STOP-DATE-TRAN
               DISPLAY '*** STOP ENTRY NO          = ' WS-STOP-ENTRY-NO 
               DISPLAY '***  CONCATENATED KEY PRIOR TO LAST CHECKPOINT:'
               DISPLAY ' '                                              
               DISPLAY '  *    LAST CS CASH COMPANY NO   = '            
                       WS-RESTART-CASH-COMPANY-NO                       
               DISPLAY '  *    LAST CS CASH LOCAL OFFICE = '            
                       WS-RESTART-CASH-LOCAL-OFFICE                     
               DISPLAY '  *    LAST CS CASH REPORT NO    = '            
                       WS-RESTART-CASH-REPORT-NO                        
               DISPLAY '  *    LAST CS DATE CASH REPORT  = '            
                       WS-RESTART-DATE-CASH-REPORT                      
               DISPLAY '  *    LAST CS CASH DRAWER ID    = '            
                       WS-RESTART-CASH-DRAWER-ID                        
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *********                                                         10580014
      * THE FOLLOWING STATEMENTS ISSUE A CHECKPOINT IF THE CHKP-LUW    *10590014
      * LIMIT HAS BEEN REACHED OR THE CHKP-UPD LIMIT HAS BEEN REACHED  *10600014
      * OR EXCEEDED:                                                   *10610014
      *********                                                         10620014
           ADD 1 TO WS-CHKP-LUW-COUNTER.                                
           IF WS-CHKP-LUW-COUNTER EQUAL WS-CHKP-LUW-LIMIT OR            
              WS-CHKP-UPD-COUNTER  EQUAL WS-CHKP-UPD-LIMIT OR           
              WS-CHKP-UPD-COUNTER  GREATER THAN WS-CHKP-UPD-LIMIT       
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT
           END-IF.                  
           IF WS-PRINT-COUNTERS EQUAL WS-C                              
                   PERFORM 8601-PRINT-COUNTERS THRU 8601-EXIT
           END-IF.          
      ******************************************************************10700014
      * NOW CONTINUE READING CSH_DRWR_JRNL:                             10710014
      ******************************************************************10720014
           PERFORM 7410-FETCH-CASH-DRWR   THRU  7410-EXIT.              
       1210-EXIT.                                                       
           EXIT.                                                        
       1300-MISC-JRNL-EXTRACT.                                          
           MOVE WS-YES                  TO MJ-CODE-JRNL-EXTRACT.        
           MOVE WS-INPUT-DATE           TO MJ-DATE-JRNL-EXTRACT.        
           MOVE MJ-JRNL-SORT-ID         TO E-FCA06-JRNL-SORT-ID.        
           MOVE MJ-LOCAL-OFFICE         TO E-FCA06-LOCAL-OFFICE.        
           MOVE MJ-COMPANY-NO           TO E-FCA06-COMPANY-NO.          
           MOVE MJ-ACCOUNT-NO           TO E-FCA06-RECORD-ID-ACCT-NO.   
           MOVE MJ-DATE-TRAN            TO E-FCA06-TRAN-DATE.           
           IF WS-NULL-IND-3          EQUAL ZERO                         
              MOVE MJ-DATE-LAST-ACTION  TO E-FCA06-DATE-LAST-ACTION     
           ELSE                                                         
              MOVE '0000-00-00'         TO E-FCA06-DATE-LAST-ACTION
           END-IF.    
           IF WS-NULL-IND-2          EQUAL ZERO                         
              MOVE MJ-TRAN-TIME         TO E-FCA06-TRAN-TIME            
           ELSE                                                         
              MOVE '00.00.00'           TO E-FCA06-TRAN-TIME
           END-IF.           
           MOVE MJ-TRAN-ID              TO E-FCA06-CODE-TERMINAL-TRAN.  
           MOVE MJ-TRAN-APPL-NO         TO E-FCA06-JRNL-TRAN-APPL-NO.   
           MOVE MJ-CODE-ENTRY-SOURCE    TO E-FCA06-CODE-ENTRY-SOURCE.   
           MOVE MJ-USER-ID              TO E-FCA06-USER-ID.             
           MOVE MJ-CODE-TRAN-ERRORS     TO E-FCA06-TRANS-ERRORS.        
RS         MOVE SPACES                  TO E-FCA06-CASH-COMPANY-NO      
RS                                         E-FCA06-CASH-LOCAL-OFFICE    
RS                                         E-FCA06-CASH-REPORT-NO       
RS                                         E-FCA06-DATE-CASH-REPORT.    
RS         MOVE MJ-CASH-DRAWER-ID       TO E-FCA06-CASH-DRAWER-ID.      
           MOVE MJ-TRAN-DATA            TO E-FCA06-USER-DEFINED-AREA.   
           MOVE MJ-TRAN-DATA            TO CJF00101.                    
           MOVE WS-101-JRNL-FORMAT-NO TO WS-JRNL-USER-DEFINED-TYPE.     
           MOVE WS-MJ                   TO  WS-TYPE-CHECK.              
           MOVE MJ-COMPANY-NO           TO WS-COMPANY-NO.               
           PERFORM  2000-FORMAT-TYPE   THRU  2000-EXIT.                 
           PERFORM 8510-UPDATE-MISC-JRNL  THRU  8510-EXIT.              
           ADD 1 TO WS-MJ-COUNTER.                                      
           PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT.                 
      ***************************************************************** 11090014
      * THE FOLLOWING STATEMENTS OCCUR JUST PRIOR TO THE LOOPING READ   11100014
      * OF THE MJ TABLE:                                                11110014
      ***************************************************************** 11120014
      *                                                                 11130014
      *********                                                         11140014
      * THE FOLLOWING STATEMENT COMPARES THE STOP KEY TO THE          * 11150014
      * LOCAL_OFFICE/CASH_DRAWER_ID/DATE_TRAN/ENTRY_NO IN             * 11160017
      * THE LAST MISC_JRNL FETCHED, & ABENDS IF THE 5 FLDS ARE        * 11170014
      * EQUAL, PLUS IF STOP KEY REQUESTED THAT THE ABEND OCCUR IN     * 11180014
      * THE MJ LOOP:                                                  * 11190014
      *********                                                         11200014
           IF STOP-REQUESTED-IN-MJ-LOOP                                 
           AND MJ-LOCAL-OFFICE   EQUAL WS-STOP-CASH-LOCAL-OFFICE        
           AND MJ-CASH-DRAWER-ID EQUAL WS-STOP-CASH-DRAWER-ID           
           AND MJ-DATE-TRAN      EQUAL WS-STOP-DATE-TRAN                
           AND MJ-ENTRY-NO       EQUAL WS-STOP-ENTRY-NO                 
               DISPLAY '******************************************'     
               DISPLAY '*****  JOB STOPPED DUE TO STOP PARM  *****'     
               DISPLAY '******************************************'     
               DISPLAY '*** STOP WAS REQUESTED IN MISC JRNL LOOP*'      
               DISPLAY '*** STOP LOCAL OFFICE   = '                     
                       WS-STOP-CASH-LOCAL-OFFICE                        
               DISPLAY '*** STOP CASH DRAWER ID = '                     
                       WS-STOP-CASH-DRAWER-ID                           
               DISPLAY '*** STOP DATE TRAN      = ' WS-STOP-DATE-TRAN   
               DISPLAY '*** STOP ENTRY NO       = ' WS-STOP-ENTRY-NO    
               DISPLAY '***  CONCATENATED KEY PRIOR TO LAST CHECKPOINT' 
               DISPLAY '***  IS IRRELEVANT, SINCE RESTART WILL MERELY ' 
               DISPLAY '***  FETCH ALL MISC JRNLS NOT YET MARKED AS   ' 
               DISPLAY '***  HAVING BEEN EXTRACTED, AND MISC JRNLS ARE' 
               DISPLAY '***  NOT PROCESSED IN ANY ORDER.'               
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *********                                                         11490014
      * THE FOLLOWING STATEMENTS ISSUE A CHECKPOINT IF THE CHKP-LUW    *11500014
      * LIMIT HAS BEEN REACHED OR THE CHKP-UPD LIMIT HAS BEEN REACHED  *11510014
      * OR EXCEEDED:                                                   *11520014
      *********                                                         11530014
           ADD 1 TO WS-CHKP-LUW-COUNTER.                                
           IF WS-CHKP-LUW-COUNTER EQUAL WS-CHKP-LUW-LIMIT OR            
              WS-CHKP-UPD-COUNTER  EQUAL WS-CHKP-UPD-LIMIT OR           
              WS-CHKP-UPD-COUNTER  GREATER THAN WS-CHKP-UPD-LIMIT       
               PERFORM 8898-ISSUE-CHKP THRU 8898-EXIT
           END-IF.                  
           IF WS-PRINT-COUNTERS EQUAL WS-C                              
                   PERFORM 8601-PRINT-COUNTERS THRU 8601-EXIT
           END-IF.          
      ******************************************************************11610014
      * NOW CONTINUE READING MISC_JRNL:                                 11620014
      ******************************************************************11630014
           PERFORM 7510-FETCH-MISC-JRNL   THRU  7510-EXIT.              
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11670014
       2000-FORMAT-TYPE.                                                
TP5672     IF WS-COMPANY-NO NOT NUMERIC                                 
TP5672        DISPLAY '******************************'                  
TP5672         DISPLAY '*** PROBLEM IN 2000-FORMAT LOOP*'               
TP5672         DISPLAY '*** STOP DATE TRAN      = ' WS-STOP-DATE-TRAN   
TP5672         DISPLAY '*** STOP ENTRY NO       = ' WS-STOP-ENTRY-NO    
TP5672         DISPLAY '***  DUE TO ERRONEOUS DATA RECORD IS BYPASSED'  
TP5672        DISPLAY 'COMPANY NUMBER IS INVALID:' WS-COMPANY-NO        
TP5672        DISPLAY 'TYPE OF CHECK IS:         ' WS-TYPE-CHECK        
TP5672        DISPLAY 'APPL NO: '          E-FCA06-JRNL-TRAN-APPL-NO    
TP5672        DISPLAY 'ENTRY SOURCE '      E-FCA06-CODE-ENTRY-SOURCE    
TP5672        DISPLAY 'USER ID'            E-FCA06-USER-ID              
TP5672        DISPLAY 'CASH COMPANY NO:'   E-FCA06-CASH-COMPANY-NO      
TP5672        DISPLAY 'LOCAL-OFFICE: '    E-FCA06-CASH-LOCAL-OFFICE     
TP5672        DISPLAY 'CASH REPORT NO'     E-FCA06-CASH-REPORT-NO       
TP5672        DISPLAY 'CR DATE: '          E-FCA06-DATE-CASH-REPORT     
TP5672        DISPLAY 'CASH DRAWER '       E-FCA06-CASH-DRAWER-ID       
TP5672        DISPLAY '******************************'                  
              GO TO 2000-EXIT                                           
TP5672     END-IF                                                       
           PERFORM VARYING WS-GL-SUB      FROM 1 BY 1                   
TP5672           UNTIL WS-GL-SUB       GREATER 5                        
TP5672           OR    WS-COMPANY-NO     EQUAL                          
                       WS-VALID-CO-NO (WS-GL-SUB)                       
           END-PERFORM.                                                 
           IF WS-GL-SUB                GREATER 5                        
              SET WS-GL-SUB                 TO 1
           END-IF.                       
           IF WS-101-TYPE                                               
               PERFORM 3111-FORMAT-NO-101 THRU 3111-EXIT                
           ELSE                                                         
           IF WS-102-TYPE                                               
               PERFORM 3112-FORMAT-NO-102 THRU 3112-EXIT                
           ELSE                                                         
           IF WS-103-TYPE                                               
               PERFORM 3113-FORMAT-NO-103 THRU 3113-EXIT                
           ELSE                                                         
           IF WS-104-TYPE                                               
               PERFORM 3114-FORMAT-NO-104 THRU 3114-EXIT                
           ELSE                                                         
           IF WS-105-TYPE                                               
               PERFORM 3116-FORMAT-NO-105 THRU 3116-EXIT                
           ELSE                                                         
           IF WS-201-TYPE                                               
               PERFORM 3115-FORMAT-NO-201 THRU 3115-EXIT
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.               
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11850014
       2001-WRITE-BEGIN-CONTROLS.                                       
           MOVE LOW-VALUES TO E-FCA06-BEGIN-REC-KEY.                    
           MOVE SPACES TO E-FCA06-DATA.                                 
           MOVE WS-INPUT-DATE TO E-FCA06-BEGIN-CREATE-DATE.             
           PERFORM 8201-OUTPUT-TO-KSDS-FILE      THRU 8201-EXIT.        
           MOVE SPACES TO E-FCA06-KEY E-FCA06-DATA.                     
       2001-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11940014
       2100-CREATE-CNTRL-EXTRACTS.                                      
           MOVE LOW-VALUES                TO E-FCA06-USER-DEFINED-AREA. 
           MOVE WS-00001                  TO WS-001-JRNL-FORMAT-NO.     
           MOVE ZEROS                     TO E-FCA06-RECORD-ID-ACCT-NO. 
           MOVE SPACES                    TO E-FCA06-USER-ID            
                                             E-FCA06-CODE-TERMINAL-TRAN 
                                             E-FCA06-TRANS-ERRORS.      
           MOVE WS-A                      TO E-FCA06-JRNL-SORT-ID.      
           MOVE ZEROS                     TO E-FCA06-TRAN-TIME          
                                             E-FCA06-LOCAL-OFFICE       
           MOVE WS-S                      TO E-FCA06-CODE-ENTRY-SOURCE. 
           MOVE WS-00001                  TO E-FCA06-JRNL-TRAN-APPL-NO. 
      *                                                                 12100014
           IF BATCH-JRNL-CNTRL                                          
               MOVE BC-DATE-LAST-ACTIVITY TO E-FCA06-TRAN-DATE          
                                             E-FCA06-DATE-LAST-ACTION   
               MOVE BC-CASH-COMPANY-NO    TO E-FCA06-COMPANY-NO         
               MOVE WS-B                  TO WS-001-ACTIVITY-TYPE       
RS             MOVE BC-CASH-COMPANY-NO    TO E-FCA06-CASH-COMPANY-NO    
RS                                           WS-001-CASH-COMPANY-NO     
RS             MOVE BC-CASH-LOCAL-OFFICE  TO E-FCA06-CASH-LOCAL-OFFICE  
RS                                           WS-001-CASH-LOCAL-OFFICE   
RS             MOVE BC-CASH-REPORT-NO     TO E-FCA06-CASH-REPORT-NO     
RS                                           WS-001-CASH-REPORT-NO      
RS             MOVE BC-DATE-CASH-REPORT   TO E-FCA06-DATE-CASH-REPORT   
RS                                           WS-001-DATE-CASH-REPORT    
RS             MOVE BC-CASH-DRAWER-ID     TO E-FCA06-CASH-DRAWER-ID     
RS                                           WS-001-CASH-DRAWER-ID      
               MOVE ZEROS                 TO WS-001-CASH-DRWR-END-BAL   
                                             WS-001-BASIC-WORK-FUND-AMT 
               MOVE BC-AMT-CASH-DEBIT     TO WS-001-CNTRL-CASH-DR-TOT   
               MOVE BC-AMT-CASH-CREDIT    TO WS-001-CNTRL-CASH-CR-TOT   
               MOVE BC-AMT-AR-DEBIT       TO WS-001-CNTRL-AR-DR-TOT     
               MOVE BC-AMT-AR-CREDIT      TO WS-001-CNTRL-AR-CR-TOT     
               MOVE BC-AMT-GL-DEBIT       TO WS-001-CNTRL-GL-DR-TOT     
               MOVE BC-AMT-GL-CREDIT      TO WS-001-CNTRL-GL-CR-TOT     
               MOVE BC-AMT-CK-ISS-DEBIT   TO WS-001-CNTRL-CKI-DR-TOT    
               MOVE BC-AMT-CK-ISS-CREDIT  TO WS-001-CNTRL-CKI-CR-TOT    
           ELSE                                                         
           IF CASH-DRWR-CNTRL                                           
               MOVE CS-DATE-LAST-ACTIVITY TO E-FCA06-TRAN-DATE          
                                             E-FCA06-DATE-LAST-ACTION   
               MOVE CS-CASH-COMPANY-NO    TO E-FCA06-COMPANY-NO         
               MOVE WS-C                  TO WS-001-ACTIVITY-TYPE       
RS             MOVE CS-CASH-COMPANY-NO    TO E-FCA06-CASH-COMPANY-NO    
RS                                           WS-001-CASH-COMPANY-NO     
RS             MOVE CS-CASH-LOCAL-OFFICE  TO E-FCA06-CASH-LOCAL-OFFICE  
RS                                           WS-001-CASH-LOCAL-OFFICE   
RS             MOVE CS-CASH-REPORT-NO     TO E-FCA06-CASH-REPORT-NO     
RS                                           WS-001-CASH-REPORT-NO      
RS             MOVE CS-DATE-CASH-REPORT   TO E-FCA06-DATE-CASH-REPORT   
RS                                           WS-001-DATE-CASH-REPORT    
RS             MOVE CS-CASH-DRAWER-ID     TO E-FCA06-CASH-DRAWER-ID     
RS                                           WS-001-CASH-DRAWER-ID      
               MOVE CS-AMT-CASH-DEBIT     TO WS-001-CNTRL-CASH-DR-TOT   
               MOVE CS-AMT-CASH-CREDIT    TO WS-001-CNTRL-CASH-CR-TOT   
               MOVE CS-AMT-AR-DEBIT       TO WS-001-CNTRL-AR-DR-TOT     
               MOVE CS-AMT-AR-CREDIT      TO WS-001-CNTRL-AR-CR-TOT     
               MOVE CS-AMT-GL-DEBIT       TO WS-001-CNTRL-GL-DR-TOT     
               MOVE CS-AMT-GL-CREDIT      TO WS-001-CNTRL-GL-CR-TOT     
               MOVE CS-AMT-CK-ISS-DEBIT   TO WS-001-CNTRL-CKI-DR-TOT    
               MOVE CS-AMT-CK-ISS-CREDIT  TO WS-001-CNTRL-CKI-CR-TOT
           END-IF
           END-IF.   
      *                                                                 12500014
           IF BATCH-JRNL-CNTRL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE CS-AMT-BASIC-WORK     TO WS-001-BASIC-WORK-FUND-AMT 
               MOVE CS-AMT-CASH-BEGIN-BAL TO WS-EXTRACT-NET-TOTAL       
               ADD CS-AMT-CASH-DEBIT      TO WS-EXTRACT-NET-TOTAL       
               SUBTRACT CS-AMT-CASH-CREDIT                              
                                          FROM WS-EXTRACT-NET-TOTAL     
               MOVE WS-EXTRACT-NET-TOTAL  TO WS-001-CASH-DRWR-END-BAL
           END-IF.  
           MOVE CJF00001                  TO E-FCA06-USER-DEFINED-AREA. 
           PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT.                 
           IF WS-PRINT-JRNL-0002                                        
               PERFORM 2110-TOM-00002-EXTRACTS THRU 2110-EXIT
           END-IF.          
           MOVE ZERO TO WS-CASH-DB-BUCKET                               
                        WS-CASH-CR-BUCKET                               
                        WS-AR-DB-BUCKET                                 
                        WS-AR-CR-BUCKET                                 
                        WS-CKI-DB-BUCKET                                
                        WS-CKI-CR-BUCKET                                
                        WS-GL-DB-BUCKET                                 
                        WS-GL-CR-BUCKET.                                
       2100-EXIT.                                                       
           EXIT.                                                        
       2110-TOM-00002-EXTRACTS.                                         
           MOVE WS-00002               TO WS-002-JRNL-FORMAT-NO.        
           MOVE WS-001-ACTIVITY-TYPE   TO WS-002-ACTIVITY-TYPE.         
           MOVE WS-001-ACTIVITY-SOURCE TO WS-002-ACTIVITY-SOURCE.       
           IF BATCH-JRNL-CNTRL                                          
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 2111-TOM-00002-EXTRACTS THRU 2111-EXIT            
              GO TO 2110-EXIT
           END-IF.                                          
      *                                                                 12860014
           IF BC-AMT-CASH-DEBIT NOT EQUAL WS-CASH-DB-BUCKET             
               MOVE WS-ERROR-CASH-DB        TO WS-002-ERROR-DESCRIPTION 
               MOVE BC-AMT-CASH-DEBIT       TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-CASH-DB-BUCKET       TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 13010014
           IF BC-AMT-CASH-CREDIT NOT EQUAL WS-CASH-CR-BUCKET            
               MOVE WS-ERROR-CASH-CR        TO WS-002-ERROR-DESCRIPTION 
               MOVE BC-AMT-CASH-CREDIT      TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-CASH-CR-BUCKET       TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 13160014
           IF BC-AMT-AR-DEBIT NOT EQUAL WS-AR-DB-BUCKET                 
               MOVE WS-ERROR-AR-DB          TO WS-002-ERROR-DESCRIPTION 
               MOVE BC-AMT-AR-DEBIT         TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-AR-DB-BUCKET         TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 13310014
           IF BC-AMT-AR-CREDIT NOT EQUAL WS-AR-CR-BUCKET                
               MOVE WS-ERROR-AR-CR          TO WS-002-ERROR-DESCRIPTION 
               MOVE BC-AMT-AR-CREDIT        TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-AR-CR-BUCKET         TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 13460014
           IF BC-AMT-CK-ISS-DEBIT NOT EQUAL WS-CKI-DB-BUCKET            
               MOVE WS-ERROR-CKI-DB         TO WS-002-ERROR-DESCRIPTION 
               MOVE BC-AMT-CK-ISS-DEBIT     TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-CKI-DB-BUCKET        TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 13610014
           IF BC-AMT-CK-ISS-CREDIT NOT EQUAL WS-CKI-CR-BUCKET           
               MOVE WS-ERROR-CKI-CR         TO WS-002-ERROR-DESCRIPTION 
               MOVE BC-AMT-CK-ISS-CREDIT    TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-CKI-CR-BUCKET        TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 13760014
           IF BC-AMT-GL-DEBIT NOT EQUAL WS-GL-DB-BUCKET                 
               MOVE WS-ERROR-GL-DB          TO WS-002-ERROR-DESCRIPTION 
               MOVE BC-AMT-GL-DEBIT         TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-GL-DB-BUCKET         TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 13910014
           IF BC-AMT-GL-CREDIT NOT EQUAL WS-GL-CR-BUCKET                
               MOVE WS-ERROR-GL-CR          TO WS-002-ERROR-DESCRIPTION 
               MOVE BC-AMT-GL-CREDIT        TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-GL-CR-BUCKET         TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 14060014
           MOVE WS-NO TO WS-SHOULD-PRINT-JRNL-0002.                     
       2110-EXIT.                                                       
           EXIT.                                                        
       2111-TOM-00002-EXTRACTS.                                         
           IF CS-AMT-CASH-DEBIT NOT EQUAL WS-CASH-DB-BUCKET             
               MOVE WS-ERROR-CASH-DB        TO WS-002-ERROR-DESCRIPTION 
               MOVE CS-AMT-CASH-DEBIT       TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-CASH-DB-BUCKET       TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 14250014
           IF CS-AMT-CASH-CREDIT NOT EQUAL WS-CASH-CR-BUCKET            
               MOVE WS-ERROR-CASH-CR        TO WS-002-ERROR-DESCRIPTION 
               MOVE CS-AMT-CASH-CREDIT      TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-CASH-CR-BUCKET       TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 14400014
           IF CS-AMT-AR-DEBIT NOT EQUAL WS-AR-DB-BUCKET                 
               MOVE WS-ERROR-AR-DB          TO WS-002-ERROR-DESCRIPTION 
               MOVE CS-AMT-AR-DEBIT         TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-AR-DB-BUCKET         TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 14550014
           IF CS-AMT-AR-CREDIT NOT EQUAL WS-AR-CR-BUCKET                
               MOVE WS-ERROR-AR-CR          TO WS-002-ERROR-DESCRIPTION 
               MOVE CS-AMT-AR-CREDIT        TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-AR-CR-BUCKET         TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 14700014
           IF CS-AMT-CK-ISS-DEBIT NOT EQUAL WS-CKI-DB-BUCKET            
               MOVE WS-ERROR-CKI-DB         TO WS-002-ERROR-DESCRIPTION 
               MOVE CS-AMT-CK-ISS-DEBIT     TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-CKI-DB-BUCKET        TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 14850014
           IF CS-AMT-CK-ISS-CREDIT NOT EQUAL WS-CKI-CR-BUCKET           
               MOVE WS-ERROR-CKI-CR         TO WS-002-ERROR-DESCRIPTION 
               MOVE CS-AMT-CK-ISS-CREDIT    TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-CKI-CR-BUCKET        TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 15000014
           IF CS-AMT-GL-DEBIT NOT EQUAL WS-GL-DB-BUCKET                 
               MOVE WS-ERROR-GL-DB          TO WS-002-ERROR-DESCRIPTION 
               MOVE CS-AMT-GL-DEBIT         TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-GL-DB-BUCKET         TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 15150014
           IF CS-AMT-GL-CREDIT NOT EQUAL WS-GL-CR-BUCKET                
               MOVE WS-ERROR-GL-CR          TO WS-002-ERROR-DESCRIPTION 
               MOVE CS-AMT-GL-CREDIT        TO WS-CNTRL-ACT-TOTAL       
               MOVE WS-GL-CR-BUCKET         TO WS-EXT-ACT-TOTAL         
               SUBTRACT WS-EXT-ACT-TOTAL    FROM WS-CNTRL-ACT-TOTAL     
                   GIVING WS-DIFFERENCE                                 
               MOVE WS-CNTRL-ACT-TOTAL      TO WS-CNTRL-ACT-TOTAL-EDIT  
               MOVE WS-CNTRL-ACT-TOTAL-EDIT TO WS-002-CNTRL-ACT-TOT-EDIT
               MOVE WS-EXT-ACT-TOTAL        TO WS-EXT-ACT-TOTAL-EDIT    
               MOVE WS-EXT-ACT-TOTAL-EDIT   TO WS-002-EXT-ACT-TOT-EDIT  
               MOVE WS-DIFFERENCE           TO WS-DIFFERENCE-EDIT       
               MOVE WS-DIFFERENCE-EDIT      TO WS-002-DIFFERENCE-EDIT   
               MOVE CJF00002                TO E-FCA06-USER-DEFINED-AREA
               PERFORM 8200-BUILD-KSDS-FILE THRU 8200-EXIT
           END-IF.             
      *                                                                 15300014
           MOVE WS-NO TO WS-SHOULD-PRINT-JRNL-0002.                     
       2111-EXIT.                                                       
           EXIT.                                                        
       2999-WRITE-END-REC.                                              
           MOVE SPACES TO FIOCA06.                                      
           MOVE HIGH-VALUES TO E-FCA06-END-REC-KEY.                     
           MOVE WS-RESTART-FCSCA06-REC-CNTR TO E-FCA06-RECORD-CNT.      
           PERFORM 8201-OUTPUT-TO-KSDS-FILE      THRU 8201-EXIT.        
       2999-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        15420014
       3111-FORMAT-NO-101.                                              
           IF  BATCH-JRNL                                               
               MOVE BJ-TRAN-DATA  TO  CJF00101                          
           ELSE                                                         
           IF  CASH-JRNL                                                
               MOVE CJ-ACCOUNT-NO TO E-FCA06-RECORD-ID-ACCT-NO          
               MOVE CJ-TRAN-DATA  TO  CJF00101                          
           ELSE                                                         
           IF  MISC-JRNL                                                
               MOVE MJ-TRAN-DATA  TO  CJF00101
           END-IF
           END-IF
           END-IF.                         
      *                                                                 15530014
           IF WS-101-ACCT-GEN-LED-DR NOT NUMERIC                        
              MOVE 0 TO WS-101-ACCT-GEN-LED-DR
           END-IF.                         
           IF WS-101-ACCT-GEN-LED-CR NOT NUMERIC                        
              MOVE 0 TO WS-101-ACCT-GEN-LED-CR
           END-IF.                         
           IF WS-101-ACCT-GEN-LED-DR EQUAL WS-101-ACCT-GEN-LED-CR       
               GO TO 3111-EXIT
           END-IF.                                         
           MOVE WS-101-ACCT-GEN-LED-DR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CASH-GL-NO(WS-GL-SUB)   
               ADD WS-101-AMT-POSTED TO WS-CASH-DB-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-101-AMT-POSTED TO WS-CKI-DB-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-101-AMT-POSTED TO WS-AR-DB-BUCKET                 
           ELSE                                                         
               ADD WS-101-AMT-POSTED TO WS-GL-DB-BUCKET
           END-IF
           END-IF
           END-IF.                
      *                                                                         
           MOVE WS-101-ACCT-GEN-LED-CR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO(WS-GL-SUB)    
               ADD WS-101-AMT-POSTED TO WS-CASH-CR-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-101-AMT-POSTED TO WS-CKI-CR-BUCKET                
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-101-AMT-POSTED TO WS-AR-CR-BUCKET                 
           ELSE                                                         
               ADD WS-101-AMT-POSTED TO WS-GL-CR-BUCKET
           END-IF
           END-IF
           END-IF.                
       3111-EXIT.                                                       
           EXIT.                                                        
       3112-FORMAT-NO-102.                                              
           IF  BATCH-JRNL                                               
               MOVE BJ-TRAN-DATA  TO  CJF00102                          
           ELSE                                                         
           IF  CASH-JRNL                                                
               MOVE CJ-ACCOUNT-NO TO E-FCA06-RECORD-ID-ACCT-NO          
               MOVE CJ-TRAN-DATA  TO  CJF00102                          
           ELSE                                                         
           IF  MISC-JRNL                                                
               MOVE MJ-TRAN-DATA  TO  CJF00102
           END-IF
           END-IF
           END-IF.                         
      *                                                                 15840014
           IF WS-102-ACCT-GEN-LED-DR EQUAL WS-102-ACCT-GEN-LED-CR       
               GO TO 3112-EXIT
           END-IF.                                         
           MOVE WS-102-ACCT-GEN-LED-DR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO(WS-GL-SUB)    
               ADD WS-102-AMT-POSTED TO WS-CASH-DB-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-102-AMT-POSTED TO WS-CKI-DB-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-102-AMT-POSTED TO WS-AR-DB-BUCKET                 
           ELSE                                                         
               ADD WS-102-AMT-POSTED TO WS-GL-DB-BUCKET
           END-IF
           END-IF
           END-IF.                
           MOVE WS-102-ACCT-GEN-LED-CR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-102-AMT-POSTED TO WS-CASH-CR-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-102-AMT-POSTED TO WS-CKI-CR-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-102-AMT-POSTED TO WS-AR-CR-BUCKET                 
           ELSE                                                         
               ADD WS-102-AMT-POSTED TO WS-GL-CR-BUCKET
           END-IF
           END-IF
           END-IF.                
       3112-EXIT.                                                       
           EXIT.                                                        
       3113-FORMAT-NO-103.                                              
           IF  BATCH-JRNL                                               
               MOVE BJ-TRAN-DATA  TO  CJF00103                          
           ELSE                                                         
           IF  CASH-JRNL                                                
               MOVE CJ-ACCOUNT-NO TO E-FCA06-RECORD-ID-ACCT-NO          
               MOVE CJ-TRAN-DATA  TO  CJF00103                          
           ELSE                                                         
           IF  MISC-JRNL                                                
               MOVE MJ-TRAN-DATA  TO  CJF00103
           END-IF
           END-IF
           END-IF.                         
      *                                                                 16150014
TP5672     IF WS-103-ACCT-GEN-LED-DR NOT NUMERIC                        
TP5672        MOVE ZEROES TO WS-103-ACCT-GEN-LED-DR                     
TP5672     END-IF                                                       
TP5672     IF WS-103-ACCT-GEN-LED-CR NOT NUMERIC                        
TP5672        MOVE ZEROES TO WS-103-ACCT-GEN-LED-CR                     
TP5672     END-IF                                                       
                                                                        
           IF WS-103-ACCT-GEN-LED-DR EQUAL WS-103-ACCT-GEN-LED-CR       
               GO TO 3113-EXIT
           END-IF.                                         
           MOVE WS-103-ACCT-GEN-LED-DR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-103-AMT-POSTED TO WS-CASH-DB-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-103-AMT-POSTED TO WS-CKI-DB-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-103-AMT-POSTED TO WS-AR-DB-BUCKET                 
           ELSE                                                         
               ADD WS-103-AMT-POSTED TO WS-GL-DB-BUCKET
           END-IF
           END-IF
           END-IF.                
           MOVE WS-103-ACCT-GEN-LED-CR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-103-AMT-POSTED TO WS-CASH-CR-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-103-AMT-POSTED TO WS-CKI-CR-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-103-AMT-POSTED TO WS-AR-CR-BUCKET                 
           ELSE                                                         
               ADD WS-103-AMT-POSTED TO WS-GL-CR-BUCKET
           END-IF
           END-IF
           END-IF.                
       3113-EXIT.                                                       
           EXIT.                                                        
       3114-FORMAT-NO-104.                                              
           IF  BATCH-JRNL                                               
               MOVE BJ-TRAN-DATA  TO  CJF00104                          
           ELSE                                                         
           IF  CASH-JRNL                                                
               MOVE CJ-ACCOUNT-NO TO E-FCA06-RECORD-ID-ACCT-NO          
               MOVE CJ-TRAN-DATA  TO  CJF00104                          
           ELSE                                                         
           IF  MISC-JRNL                                                
               MOVE MJ-TRAN-DATA  TO  CJF00104
           END-IF
           END-IF
           END-IF.                         
      *                                                                 16460014
           IF WS-104-ACCT-GEN-LED-DR EQUAL WS-104-ACCT-GEN-LED-CR       
               GO TO 3114-EXIT
           END-IF.                                         
           MOVE WS-104-ACCT-GEN-LED-DR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-104-AMT-POSTED TO WS-CASH-DB-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-104-AMT-POSTED TO WS-CKI-DB-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-104-AMT-POSTED TO WS-AR-DB-BUCKET                 
           ELSE                                                         
               ADD WS-104-AMT-POSTED TO WS-GL-DB-BUCKET
           END-IF
           END-IF
           END-IF.                
           MOVE WS-104-ACCT-GEN-LED-CR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-104-AMT-POSTED TO WS-CASH-CR-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-104-AMT-POSTED TO WS-CKI-CR-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-104-AMT-POSTED TO WS-AR-CR-BUCKET                 
           ELSE                                                         
               ADD WS-104-AMT-POSTED TO WS-GL-CR-BUCKET
           END-IF
           END-IF
           END-IF.                
       3114-EXIT.                                                       
           EXIT.                                                        
       3115-FORMAT-NO-201.                                              
           IF  BATCH-JRNL                                               
               MOVE BJ-TRAN-DATA  TO  CJF00201                          
               MOVE BJ-GL-ACCT-NO TO WS-GL-ACCT-NO-BREAKDOWN            
           ELSE                                                         
           IF  CASH-JRNL                                                
               MOVE CJ-TRAN-DATA  TO  CJF00201                          
               MOVE CJ-GL-ACCT-NO TO WS-GL-ACCT-NO-BREAKDOWN            
                                     E-FCA06-GL-RECORD-ID-DATA          
           ELSE                                                         
           IF  MISC-JRNL                                                
               MOVE MJ-TRAN-DATA  TO  CJF00201
           END-IF
           END-IF
           END-IF.                         
      *                                                                 16790014
T13129     MOVE WS-201-OFFSET-GL-ACCT-NO TO WS-GL-ACCT-NO-BREAKDOWN.    
           IF WS-201-CODE-DR-CR EQUAL WS-D                              
               IF WS-GL-ACCT-NO-BREAKDOWN EQUAL                         
                  WS-CLR-CASH-GL-NO (WS-GL-SUB)                         
                   ADD WS-201-AMT-POSTED TO WS-CASH-DB-BUCKET           
               ELSE                                                     
T13129         IF WS-GL-ACCT-NO-BREAKDOWN =                             
T13129           WS-CLR-CK-ISS-GL-NO(WS-GL-SUB)                         
T13129           ADD WS-201-AMT-POSTED TO WS-CKI-DB-BUCKET              
               ELSE                                                     
               IF WS-GL-ACCT-NO EQUAL WS-GL-142                         
                   ADD WS-201-AMT-POSTED TO WS-AR-DB-BUCKET             
               ELSE                                                     
                   ADD WS-201-AMT-POSTED TO WS-GL-DB-BUCKET
               END-IF
               END-IF
               END-IF
           END-IF.            
      *                                                                         
           IF WS-201-CODE-DR-CR EQUAL WS-C                              
               IF WS-GL-ACCT-NO-BREAKDOWN EQUAL                         
                  WS-CLR-CASH-GL-NO (WS-GL-SUB)                         
                   ADD WS-201-AMT-POSTED TO WS-CASH-CR-BUCKET           
               ELSE                                                     
T13129         IF WS-GL-ACCT-NO-BREAKDOWN =                             
T13129           WS-CLR-CK-ISS-GL-NO(WS-GL-SUB)                         
T13129           ADD WS-201-AMT-POSTED TO WS-CKI-CR-BUCKET              
               IF WS-GL-ACCT-NO EQUAL WS-GL-142                         
                   ADD WS-201-AMT-POSTED TO WS-AR-CR-BUCKET             
               ELSE                                                     
               ADD WS-201-AMT-POSTED TO WS-GL-CR-BUCKET
               END-IF
               END-IF
               END-IF
           END-IF.                
       3115-EXIT.                                                       
           EXIT.                                                        
       3116-FORMAT-NO-105.                                              
           IF  BATCH-JRNL                                               
               MOVE BJ-TRAN-DATA  TO  CJF00105                          
           ELSE                                                         
           IF  CASH-JRNL                                                
               MOVE CJ-ACCOUNT-NO TO E-FCA06-RECORD-ID-ACCT-NO          
               MOVE CJ-TRAN-DATA  TO  CJF00105                          
           ELSE                                                         
           IF  MISC-JRNL                                                
               MOVE MJ-TRAN-DATA  TO  CJF00105
           END-IF
           END-IF
           END-IF.                         
      *                                                                 16979417
           IF WS-105-ACCT-GEN-LED-DR EQUAL WS-105-ACCT-GEN-LED-CR       
               GO TO 3116-EXIT
           END-IF.                                         
           MOVE WS-105-ACCT-GEN-LED-DR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-105-AMT-POSTED TO WS-CASH-DB-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-105-AMT-POSTED TO WS-CKI-DB-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-105-AMT-POSTED TO WS-AR-DB-BUCKET                 
           ELSE                                                         
               ADD WS-105-AMT-POSTED TO WS-GL-DB-BUCKET
           END-IF
           END-IF
           END-IF.                
           MOVE WS-105-ACCT-GEN-LED-CR TO WS-GL-ACCT-NO-BREAKDOWN.      
           IF WS-GL-ACCT-NO-BREAKDOWN = WS-CLR-CASH-GL-NO (WS-GL-SUB)   
               ADD WS-105-AMT-POSTED TO WS-CASH-CR-BUCKET               
           ELSE                                                         
T13129     IF WS-GL-ACCT-NO-BREAKDOWN =  WS-CLR-CK-ISS-GL-NO(WS-GL-SUB) 
T13129         ADD WS-105-AMT-POSTED TO WS-CKI-CR-BUCKET                
           ELSE                                                         
           IF WS-GL-ACCT-NO EQUAL WS-GL-142                             
               ADD WS-105-AMT-POSTED TO WS-AR-CR-BUCKET                 
           ELSE                                                         
               ADD WS-105-AMT-POSTED TO WS-GL-CR-BUCKET
           END-IF
           END-IF
           END-IF.                
       3116-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            16980014
       COPY CPD00035.                                                   16990014
       COPY CPD00040.                                                   17000014
       COPY CPD00034.                                                   17010014
       COPY CPD00036.                                                   17020014
       COPY CPD00015.                                                   17030014
       COPY CPD00037.                                                   17040014
T23814     EXEC SQL                                                             
T23814          INCLUDE CPD00012                                                
T23814     END-EXEC.                                                            
HPCCDM*EJECT                                                            17050014
      *                                                                 17060014
      *                                                                 17080014
C35692 6000-LOCK-BCH-JRNL-CNTL.                                         
C35692*                                                                 17080014
C35692     EXEC SQL                                                     
C35692          CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE(
              'CSS_BCH_JRNL_CNTL')          
C35692     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35692                                                                  
C35692     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
C35692                                                                  
C35692     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35692        NEXT SENTENCE                                             
C35692     ELSE                                                         
C35692        DISPLAY '6000- ' WS-ACTIVE-RETURN-CODE                    
C35692        PERFORM 9900-ABEND              THRU 9900-EXIT            
C35692     END-IF.                                                      
C35692*                                                                 17080014
C35692 6000-EXIT.                                                       
C35692     EXIT.                                                        
C35692*                                                                 17210014
C35692 6100-LOCK-BATCH-JRNL.                                            
C35692*                                                                 17080014
C35692     EXEC SQL                                                     
C35692          CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_BATCH_JRNL')         
C35692     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35692                                                                  
C35692     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
C35692                                                                  
C35692     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35692        NEXT SENTENCE                                             
C35692     ELSE                                                         
C35692        DISPLAY '6100- ' WS-ACTIVE-RETURN-CODE                    
C35692        PERFORM 9900-ABEND              THRU 9900-EXIT            
C35692     END-IF.                                                      
C35692*                                                                 17080014
C35692 6100-EXIT.                                                       
C35692     EXIT.                                                        
C35692*                                                                 17210014
C35692 6200-LOCK-CSH-DRWR-CNTL.                                         
C35692*                                                                 17080014
C35692     EXEC SQL                                                     
C35692          CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE(
              'CSS_CSH_DRWR_CNTL')          
C35692     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35692                                                                  
C35692     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
C35692                                                                  
C35692     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35692        NEXT SENTENCE                                             
C35692     ELSE                                                         
C35692        DISPLAY '6200- ' WS-ACTIVE-RETURN-CODE                    
C35692        PERFORM 9900-ABEND              THRU 9900-EXIT            
C35692     END-IF.                                                      
C35692*                                                                 17080014
C35692 6200-EXIT.                                                       
C35692     EXIT.                                                        
C35692*                                                                 17210014
C35692 6300-LOCK-CSH-DRWR-JRNL.                                         
C35692*                                                                 17080014
C35692     EXEC SQL                                                     
C35692          CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE(
              'CSS_CSH_DRWR_JRNL')          
C35692     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35692                                                                  
C35692     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
C35692                                                                  
C35692     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35692        NEXT SENTENCE                                             
C35692     ELSE                                                         
C35692        DISPLAY '6300- ' WS-ACTIVE-RETURN-CODE                    
C35692        PERFORM 9900-ABEND              THRU 9900-EXIT            
C35692     END-IF.                                                      
C35692*                                                                 17080014
C35692 6300-EXIT.                                                       
C35692     EXIT.                                                        
C35692*                                                                 17210014
C35692 6400-LOCK-MISC-JRNL.                                             
C35692*                                                                 17080014
C35692     EXEC SQL                                                     
C35692          CALL CIS.LOCK_TABLE_IN_EXCLUSIVE_MODE('CSS_MISC_JRNL')          
C35692     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35692                                                                  
C35692     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
C35692                                                                  
C35692     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35692        NEXT SENTENCE                                             
C35692     ELSE                                                         
C35692        DISPLAY '6400- ' WS-ACTIVE-RETURN-CODE                    
C35692        PERFORM 9900-ABEND              THRU 9900-EXIT            
C35692     END-IF.                                                      
C35692*                                                                 17080014
C35692 6400-EXIT.                                                       
C35692     EXIT.                                                        
                                                                        
A04011 7000-GET-PURGE-JRNL.                                             
A04011                                                                  
A04011     EXEC SQL                                                     
A04011      SELECT DELINQ_VALUE                                         
A04011         INTO :C8-DELINQ-VALUE                                    
A04011         FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
A04011        WHERE DELINQ_CD  = 'JRNL-CHECK-DAYS'                      
A04011          AND COMPANY_NO = '01'                                   
A04011                                                           
A04011                                                      
A04011     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT DELINQ_VALUE                                                 
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD  = 'JRNL-CHECK-DAYS'                              
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04011                                                                  
A04011     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A04011                                                                  
A04011     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A04011        CONTINUE                                                  
A04011     ELSE                                                         
A04011        DISPLAY '7000-GET-PURGE-JRNL'                             
A04011        DISPLAY 'C8-DELINQ-CD  = JRNL-CHECK-DAYS'                 
A04011        DISPLAY 'C8-COMPANY-NO = 01 '                             
A04011        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
A04011        PERFORM 9900-ABEND THRU 9900-EXIT                         
A04011     END-IF                                                       
A04011     .                                                            
A04011 7000-EXIT.                                                       
A04011     EXIT.                                                        
                                                                        
      *                                                                 17210014
       7100-OPEN-BATCH-JRNL-CNTRL.                                      
           EXEC SQL                                                     
                OPEN BATCH_JRNL_CNTRL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7100- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17210014
       7110-FETCH-BATCH-JRNL-CNTRL.                                     
           EXEC SQL                                                     
                FETCH BATCH_JRNL_CNTRL INTO                             
                   :BC-CASH-DRAWER-ID,                                  
                   :BC-CASH-LOCAL-OFFICE,                               
                   :BC-CASH-REPORT-NO,                                  
                   :BC-DATE-CASH-REPORT,                                
                   :BC-DATE-LAST-ACTIVITY :WS-NULL-IND,                 
                   :BC-AMT-CASH-DEBIT,                                  
                   :BC-AMT-CASH-CREDIT,                                 
                   :BC-AMT-AR-DEBIT,                                    
                   :BC-AMT-AR-CREDIT,                                   
                   :BC-AMT-CK-ISS-DEBIT,                                
                   :BC-AMT-CK-ISS-CREDIT,                               
                   :BC-AMT-GL-DEBIT,                                    
                   :BC-AMT-GL-CREDIT,                                   
                   :BC-CASH-COMPANY-NO                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17400014
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7110- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7110-EXIT.                                                       
           EXIT.                                                        
       7120-CLOSE-BATCH-JRNL-CNTRL.                                     
           EXEC SQL                                                     
                CLOSE BATCH_JRNL_CNTRL                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7120- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17620014
      ********************                                              17630014
      * BATCH-JRNL       *                                              17640014
      ********************                                              17650014
       7200-OPEN-BATCH-JRNL.                                            
           EXEC SQL                                                     
                OPEN BATCH_JRNL                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7200- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17780014
       7210-FETCH-BATCH-JRNL.                                           
           MOVE ZEROES                  TO WS-NULL-IND                  
                                           WS-NULL-IND-2                
                                           WS-NULL-IND-3.               
           EXEC SQL                                                     
                FETCH BATCH_JRNL INTO                                   
                   :BJ-CASH-COMPANY-NO,                                 
                   :BJ-CASH-LOCAL-OFFICE,                               
                   :BJ-CASH-REPORT-NO,                                  
                   :BJ-DATE-CASH-REPORT,                                
                   :BJ-CASH-DRAWER-ID,                                  
                   :BJ-LOCAL-OFFICE,                                    
                   :BJ-GL-ACCT-NO,                                      
                   :BJ-CODE-JRNL-EXTRACT,                               
                   :BJ-DATE-JRNL-EXTRACT :WS-NULL-IND,                  
                   :BJ-DATE-TRAN,                                       
                   :BJ-ENTRY-NO,                                        
                   :BJ-TRAN-APPL-NO,                                    
                   :BJ-JRNL-SORT-ID,                                    
                   :BJ-CUSTOMER-NO,                                     
                   :BJ-ACCOUNT-NO,                                      
                   :BJ-TRAN-TIME :WS-NULL-IND-2,                        
                   :BJ-TRAN-ID,                                         
                   :BJ-DATE-LAST-ACTION :WS-NULL-IND-3,                 
                   :BJ-CODE-ENTRY-SOURCE,                               
                   :BJ-USER-ID,                                         
                   :BJ-CODE-TRAN-ERRORS,                                
                   :BJ-TRAN-DATA,                                       
                   :BJ-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7210- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18130014
       7220-CLOSE-BATCH-JRNL.                                           
           EXEC SQL                                                     
                CLOSE BATCH_JRNL                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7220- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18260014
      *                                                                 18270014
      ********************                                              18280014
      * CASH-DRAWER-CNTRL*                                              18290014
      ********************                                              18300014
       7300-OPEN-CASH-DRWR-CNTRL.                                       
           EXEC SQL                                                     
                OPEN CASH_DRWR_CNTRL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7300- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7300-EXIT.                                                       
           EXIT.                                                        
       7310-FETCH-CASH-DRWR-CNTRL.                                      
           EXEC SQL                                                     
                FETCH CASH_DRWR_CNTRL INTO                              
                   :CS-CASH-LOCAL-OFFICE,                               
                   :CS-CASH-DRAWER-ID,                                  
                   :CS-CASH-REPORT-NO,                                  
                   :CS-DATE-CASH-REPORT,                                
                   :CS-DATE-LAST-ACTIVITY :WS-NULL-IND,                 
                   :CS-AMT-BASIC-WORK,                                  
                   :CS-AMT-CASH-DEBIT,                                  
                   :CS-AMT-CASH-CREDIT,                                 
                   :CS-AMT-AR-DEBIT,                                    
                   :CS-AMT-AR-CREDIT,                                   
                   :CS-AMT-CK-ISS-DEBIT,                                
                   :CS-AMT-CK-ISS-CREDIT,                               
                   :CS-AMT-GL-DEBIT,                                    
                   :CS-AMT-GL-CREDIT,                                   
                   :CS-AMT-CASH-BEGIN-BAL,                              
                   :CS-CASH-COMPANY-NO                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18610014
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7310- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7310-EXIT.                                                       
           EXIT.                                                        
       7320-CLOSE-CASH-DRWR-CNTRL.                                      
           EXEC SQL                                                     
                CLOSE CASH_DRWR_CNTRL                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7320- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18830014
      ********************                                              18840014
      * CASH-DRAWER-JRNL *                                              18850014
      ********************                                              18860014
      *                                                                 18870014
       7400-OPEN-CASH-DRWR.                                             
           EXEC SQL                                                     
                OPEN CASH_DRWR_JRNL                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7400- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7400-EXIT.                                                       
           EXIT.                                                        
       7410-FETCH-CASH-DRWR.                                            
           MOVE ZEROES                  TO WS-NULL-IND                  
                                           WS-NULL-IND-2                
                                           WS-NULL-IND-3.               
           EXEC SQL                                                     
                FETCH CASH_DRWR_JRNL INTO                               
                   :CJ-CASH-COMPANY-NO,                                 
                   :CJ-CASH-LOCAL-OFFICE,                               
                   :CJ-CASH-REPORT-NO,                                  
                   :CJ-DATE-CASH-REPORT,                                
                   :CJ-CASH-DRAWER-ID,                                  
                   :CJ-LOCAL-OFFICE,                                    
                   :CJ-GL-ACCT-NO,                                      
                   :CJ-DATE-TRAN,                                       
                   :CJ-ENTRY-NO,                                        
                   :CJ-TRAN-APPL-NO,                                    
                   :CJ-JRNL-SORT-ID,                                    
                   :CJ-CUSTOMER-NO,                                     
                   :CJ-ACCOUNT-NO,                                      
                   :CJ-TRAN-TIME :WS-NULL-IND-2,                        
                   :CJ-TRAN-ID,                                         
                   :CJ-DATE-LAST-ACTION :WS-NULL-IND-3,                 
                   :CJ-CODE-ENTRY-SOURCE,                               
                   :CJ-USER-ID,                                         
                   :CJ-CODE-TRAN-ERRORS,                                
                   :CJ-CODE-JRNL-EXTRACT,                               
                   :CJ-DATE-JRNL-EXTRACT :WS-NULL-IND,                  
                   :CJ-TRAN-DATA,                                       
                   :CJ-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7410- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19350014
       7420-CLOSE-CASH-DRWR.                                            
           EXEC SQL                                                     
                CLOSE CASH_DRWR_JRNL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7420- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19480014
      ********************                                              19490014
      *      MISC-JRNL   *                                              19500014
      ********************                                              19510014
      *                                                                 19520014
       7500-OPEN-MISC-JRNL.                                             
           EXEC SQL                                                     
                OPEN MISC_JRNL                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7500- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7500-EXIT.                                                       
           EXIT.                                                        
       7510-FETCH-MISC-JRNL.                                            
           MOVE ZEROES                  TO WS-NULL-IND                  
                                           WS-NULL-IND-2                
                                           WS-NULL-IND-3.               
           EXEC SQL                                                     
                FETCH MISC_JRNL INTO                                    
                   :MJ-LOCAL-OFFICE,                                    
                   :MJ-CASH-DRAWER-ID,                                  
                   :MJ-DATE-TRAN,                                       
                   :MJ-ENTRY-NO,                                        
                   :MJ-TRAN-APPL-NO,                                    
                   :MJ-JRNL-SORT-ID,                                    
                   :MJ-CUSTOMER-NO,                                     
                   :MJ-ACCOUNT-NO,                                      
                   :MJ-TRAN-TIME :WS-NULL-IND-2,                        
                   :MJ-TRAN-ID,                                         
                   :MJ-DATE-LAST-ACTION :WS-NULL-IND-3,                 
                   :MJ-CODE-ENTRY-SOURCE,                               
                   :MJ-USER-ID,                                         
                   :MJ-CODE-TRAN-ERRORS,                                
                   :MJ-CODE-JRNL-EXTRACT,                               
                   :MJ-DATE-JRNL-EXTRACT :WS-NULL-IND,                  
                   :MJ-TRAN-DATA,                                       
                   :MJ-COMPANY-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19900014
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                OR NOT-FOUND                                            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7510- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20000014
       7520-CLOSE-MISC-JRNL.                                            
           EXEC SQL                                                     
                CLOSE MISC_JRNL                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7520- ' WS-ACTIVE-RETURN-CODE                   
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20120131
           EXEC SQL                                                     20121026
               INCLUDE CPD00038                                         20122026
           END-EXEC.                                                    20123026
      *                                                                 20123131
           EXEC SQL                                                     20124029
               INCLUDE CPD00039                                         20125030
           END-EXEC.                                                    20126029
      *                                                                 20127031
T24436*    EXEC SQL                                                     20128040
T24436*        INCLUDE CPD00062                                         20129048
T24436*    END-EXEC.                                                    20130040
      *                                                                 20140040
T23814****************************************************************  20150014
T23814**                                                            **  20150014
T23814**  7800-SQL-CODE-CHECK.                                      **  20150014
T23814**  THIS PARA IS ADDED TO CHECK SQL RETURN CODE FROM THE COPY **  20150014
T23814**  BOOK CPD00012  WHICH IS USED TO COMPUTE THE CALENDAR DATE **  20150014
T23814****************************************************************  20150014
T23814 7800-SQL-CODE-CHECK.                                             
T23814     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T23814     MOVE WS-ACTIVE-RETURN-CODE       TO WS-ACTIVE-RETURN-CODE-ED.
T23814     IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
T23814        NEXT SENTENCE                                             
T23814     ELSE                                                         
T23814        DISPLAY '** ERROR ON  6600-COMPUTE-CALENDAR **'           
T23814        DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE-ED      
T23814        DISPLAY '** INPUT DATE IS ' WS-CCD-START-DATE             
T23814        DISPLAY '** INPUT DAYS IS ' WS-CCD-DAYS-PLUS-MINUS        
T23814        DISPLAY '** PROCESSING TERMINATED            **'          
T23814        PERFORM 9900-ABEND               THRU 9900-EXIT           
T23814     END-IF.                                                      
T23814 7800-EXIT.                                                       
T23814      EXIT.                                                       
HPCCDM*    EJECT                                                        20150014
       7900-SELECT-RESTART-DATA.                                        
           EXEC SQL                                                     
           SELECT RESTART_DATA                                          
             INTO :RF-RESTART-DATA                                      
           FROM  CSS_RESTART                                            
           WHERE NAME_PROGRAM   = :RF-NAME-PROGRAM                      
             AND PARTITION_NO   = :RF-PARTITION-NO                      
             AND DUP_CNTRL_NO   = :RF-DUP-CNTRL-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '7900-SELECT RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7900-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        20340014
       8200-BUILD-KSDS-FILE.                                            
           ADD 1 TO WS-RESTART-FCSCA06-REC-CNTR.                        
TEST       IF WS-NOT-CNTRL-JRNL                                         
TEST           MOVE WS-Y  TO WS-CNTL-JRNL-SW                            
TEST       ELSE                                                         
TEST           MOVE WS-RESTART-FCSCA06-REC-CNTR TO E-FCA06-ENTRY-NO     
TEST       END-IF.                                                      
           PERFORM 8201-OUTPUT-TO-KSDS-FILE  THRU 8201-EXIT.            
       8200-EXIT.                                                       
           EXIT.                                                        
       8201-OUTPUT-TO-KSDS-FILE.                                        
           WRITE FIOCA06.                                               
           IF FCA06-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               SUBTRACT 1 FROM WS-RESTART-FCSCA06-REC-CNTR              
               DISPLAY 'VSAM WRITE ERROR OUTFILE PARAGRAPH 8201'        
               DISPLAY 'FILE STATUS IS ' WS-FCA06-STATUS                
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8201-EXIT.                                                       
           EXIT.                                                        
       8210-UPDATE-BATCH-JRNL.                                          
           EXEC SQL                                                     
                UPDATE CSS_BATCH_JRNL                                   
                SET CODE_JRNL_EXTRACT  = 'Y',                           
                    DATE_JRNL_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                  :BJ-DATE-JRNL-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BJ-DATE-JRNL-EXTRACT
              ) <> 0) OR (LEN(:BJ-DATE-JRNL-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:BJ-DATE-JRNL-EXTRACT
              ), CONVERT(DATE, :BJ-DATE-JRNL-EXTRACT) )          
                WHERE CURRENT OF BATCH_JRNL                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     20750014
MFA-TR*         UPDATE CSS_BATCH_JRNL                                   20760014
MFA-TR*         SET CODE_JRNL_EXTRACT  = 'Y',                           20770014
MFA-TR*             DATE_JRNL_EXTRACT  = :BJ-DATE-JRNL-EXTRACT          20780014
MFA-TR*         WHERE CURRENT OF BATCH_JRNL                             20790014
MFA-TR*    END-EXEC.                                                    20800014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               ADD 1 TO WS-CHKP-UPD-COUNTER                             
               ADD 1 TO WS-RESTART-BJ-UPDT-CNTR-TOT                     
               ADD 1 TO WS-RESTART-BJ-UPDT-CNTR-LUW                     
           ELSE                                                         
               DISPLAY '8210- RETURN CODE= ' WS-ACTIVE-RETURN-CODE      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20930014
       8410-UPDATE-CASH-DRWR.                                           
           EXEC SQL                                                     
                UPDATE CSS_CSH_DRWR_JRNL                                
                SET CODE_JRNL_EXTRACT  = 'Y',                           
                    DATE_JRNL_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                  :CJ-DATE-JRNL-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-JRNL-EXTRACT
              ) <> 0) OR (LEN(:CJ-DATE-JRNL-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-JRNL-EXTRACT
              ), CONVERT(DATE, :CJ-DATE-JRNL-EXTRACT) )          
                WHERE CURRENT OF CASH_DRWR_JRNL                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     20950014
MFA-TR*         UPDATE CSS_CSH_DRWR_JRNL                                20960014
MFA-TR*         SET CODE_JRNL_EXTRACT  = 'Y',                           20970014
MFA-TR*             DATE_JRNL_EXTRACT  = :CJ-DATE-JRNL-EXTRACT          20980014
MFA-TR*         WHERE CURRENT OF CASH_DRWR_JRNL                         20990014
MFA-TR*    END-EXEC.                                                    21000014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               ADD 1 TO WS-CHKP-UPD-COUNTER                             
               ADD 1 TO WS-RESTART-CJ-UPDT-CNTR-TOT                     
               ADD 1 TO WS-RESTART-CJ-UPDT-CNTR-LUW                     
           ELSE                                                         
               DISPLAY '8410- RETURN CODE=' WS-ACTIVE-RETURN-CODE       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21130014
      *                                                                 21140014
       8510-UPDATE-MISC-JRNL.                                           
           EXEC SQL                                                     
                UPDATE CSS_MISC_JRNL                                    
                SET CODE_JRNL_EXTRACT  = 'Y',                           
                    DATE_JRNL_EXTRACT  = IIF(TRY_CONVERT(DATE, 
                                                  :MJ-DATE-JRNL-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :MJ-DATE-JRNL-EXTRACT
              ) <> 0) OR (LEN(:MJ-DATE-JRNL-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:MJ-DATE-JRNL-EXTRACT
              ), CONVERT(DATE, :MJ-DATE-JRNL-EXTRACT) )          
                WHERE CURRENT OF MISC_JRNL                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     21160014
MFA-TR*         UPDATE CSS_MISC_JRNL                                    21170014
MFA-TR*         SET CODE_JRNL_EXTRACT  = 'Y',                           21180014
MFA-TR*             DATE_JRNL_EXTRACT  = :MJ-DATE-JRNL-EXTRACT          21190014
MFA-TR*         WHERE CURRENT OF MISC_JRNL                              21200014
MFA-TR*    END-EXEC.                                                    21210014

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               ADD 1 TO WS-CHKP-UPD-COUNTER                             
               ADD 1 TO WS-RESTART-MJ-UPDT-CNTR-TOT                     
               ADD 1 TO WS-RESTART-MJ-UPDT-CNTR-LUW                     
           ELSE                                                         
               DISPLAY '8510- RETURN CODE= ' WS-ACTIVE-RETURN-CODE      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8510-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        21340014
       8600-PRINT-COUNTERS.                                             
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '*****   I/O COUNTERS FOR JCSCA120   *****'.         
           DISPLAY ' '.                                                 
           DISPLAY '** TOTAL BJ UPDATES   = '                           
                              WS-RESTART-BJ-UPDT-CNTR-TOT.              
           DISPLAY '** TOTAL CJ UPDATES   = '                           
                              WS-RESTART-CJ-UPDT-CNTR-TOT.              
           DISPLAY '** TOTAL MJ UPDATES   = '                           
                              WS-RESTART-MJ-UPDT-CNTR-TOT.              
           DISPLAY '** TOTAL RF UPDATES   = '                           
                              WS-RESTART-RF-UPDT-CNTR-TOT.              
           DISPLAY '** TOTAL RF INSERTS   = '                           
                              WS-RESTART-RF-ISRT-CNTR-TOT.              
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21540014
       8601-PRINT-COUNTERS.                                             
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '** I/O COUNTERS FOR 1 LUW IN JCSCA120  **'.         
           DISPLAY '**(1 LUW = 1 JRNL (BATCH, CASH, OR MISC)*'.         
           IF WS-PROCESS-TYPE EQUAL 1                                   
              DISPLAY '** JUST PROCESSED A BATCH JRNL: '                
              DISPLAY '** COMP/LO/RPT/RPT DATE/ID/TRAN DATE/ENTRY/NO= ' 
                       BC-CASH-COMPANY-NO    '/'                        
                       BC-CASH-LOCAL-OFFICE  '/'                        
                       BC-CASH-REPORT-NO     '/'                        
                       BC-DATE-CASH-REPORT   '/'                        
                       BC-CASH-DRAWER-ID     '/'                        
                       BJ-DATE-TRAN         '/'                         
                       BJ-ENTRY-NO          '/'                         
                       BJ-TRAN-APPL-NO                                  
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-2                                
              DISPLAY '** JUST PROCESSED A CASH DRWR JRNL: '            
              DISPLAY '** COMP/LO/RPT/RPT DATE/ID/TRAN DATE/ENTRY/NO= ' 
                       CS-CASH-COMPANY-NO    '/'                        
                       CS-CASH-LOCAL-OFFICE  '/'                        
                       CS-CASH-REPORT-NO     '/'                        
                       CS-DATE-CASH-REPORT   '/'                        
                       CS-CASH-DRAWER-ID     '/'                        
                       CJ-DATE-TRAN         '/'                         
                       CJ-ENTRY-NO          '/'                         
                       CJ-TRAN-APPL-NO                                  
           ELSE                                                         
      *** MUST BE IN MISC_JRNL LOOP:                                    21810014
               DISPLAY '** JUST PROCESSED A MISC JRNL: '                
               DISPLAY '** COMP/LOC OFF/CASH DRAWER/DATE/ENTRY/'        
                       'TRAN APPL NO='                                  
                       MJ-COMPANY-NO        '/'                         
                       MJ-LOCAL-OFFICE      '/'                         
                       MJ-CASH-DRAWER-ID    '/'                         
                       MJ-DATE-TRAN         '/'                         
                       MJ-ENTRY-NO          '/'                         
                       MJ-TRAN-APPL-NO
           END-IF
           END-IF.                                 
           DISPLAY ' '.                                                 
           DISPLAY '** BJ UPDATES = ' WS-RESTART-BJ-UPDT-CNTR-LUW.      
           DISPLAY '** CJ UPDATES = ' WS-RESTART-CJ-UPDT-CNTR-LUW.      
           DISPLAY '** MJ UPDATES = ' WS-RESTART-MJ-UPDT-CNTR-LUW.      
           DISPLAY '** RF UPDATES = ' WS-RESTART-RF-UPDT-CNTR-LUW.      
           DISPLAY '** RF INSERTS = ' WS-RESTART-RF-ISRT-CNTR-LUW.      
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           MOVE ZERO TO WS-RESTART-BJ-UPDT-CNTR-LUW                     
                        WS-RESTART-CJ-UPDT-CNTR-LUW                     
                        WS-RESTART-MJ-UPDT-CNTR-LUW                     
                        WS-RESTART-RF-UPDT-CNTR-LUW                     
                        WS-RESTART-RF-ISRT-CNTR-LUW.                    
       8601-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        22060014
       8896-UPDATE-RESTART.                                             
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
               SET RESTART_DATA = :RF-RESTART-DATA                      
               WHERE                                                    
                   NAME_PROGRAM   =   :RF-NAME-PROGRAM AND              
                   PARTITION_NO   =   :RF-PARTITION-NO AND              
                   DUP_CNTRL_NO   =   :RF-DUP-CNTRL-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1 TO WS-CHKP-UPD-COUNTER                             
               ADD 1 TO WS-RESTART-RF-UPDT-CNTR-TOT                     
               ADD 1 TO WS-RESTART-RF-UPDT-CNTR-LUW                     
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8896-UPDATE RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
       8896-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        22290014
       8897-INSERT-RESTART.                                             
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                   (NAME_PROGRAM, PARTITION_NO, DUP_CNTRL_NO,           
                    RESTART_DATA)                                       
               VALUES                                                   
                   (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                 
                    :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               ADD 1 TO WS-CHKP-UPD-COUNTER                             
               ADD 1 TO WS-RESTART-RF-ISRT-CNTR-TOT                     
               ADD 1 TO WS-RESTART-RF-ISRT-CNTR-LUW                     
           ELSE                                                         
               DISPLAY '8897-INSERT RETURN CODE =' WS-ACTIVE-RETURN-CODE
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8897-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        22490014
           EXEC SQL                                                     22500036
                INCLUDE CPD00029                                        22510036
           END-EXEC.                                                    22520036
HPCCDM*    EJECT                                                        22530014
       8898-ISSUE-CHKP.                                                 
           IF WS-CHKP-LUW-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS       
           AND WS-CHKP-UPD-LIMIT EQUAL WS-FLAG-TO-TURN-OFF-COMMITS      
               GO TO 8898-EXIT
           END-IF.                                         
      ******************************************************            22580014
      *** THE FOLLOWING STATEMENTS MOVE IN RESTART DATA       ***       22590014
      ******************************************************            22600014
           MOVE WS-PROCESS-TYPE   TO WS-RESTART-PROCESS-TYPE.           
           ADD 1 TO WS-CHKP-SEQ-NO.                                     
           MOVE WS-CHKP-SEQ-NO    TO WS-RESTART-CHKP-SEQ-NO.            
           MOVE WS-CASH-DB-BUCKET TO WS-RESTART-CASH-DB-BUCKET.         
           MOVE WS-CASH-CR-BUCKET TO WS-RESTART-CASH-CR-BUCKET.         
           MOVE WS-AR-DB-BUCKET   TO WS-RESTART-AR-DB-BUCKET.           
           MOVE WS-AR-CR-BUCKET   TO WS-RESTART-AR-CR-BUCKET.           
           MOVE WS-CKI-DB-BUCKET  TO WS-RESTART-CKI-DB-BUCKET.          
           MOVE WS-CKI-CR-BUCKET  TO WS-RESTART-CKI-CR-BUCKET.          
           MOVE WS-GL-DB-BUCKET   TO WS-RESTART-GL-DB-BUCKET.           
           MOVE WS-GL-CR-BUCKET   TO WS-RESTART-GL-CR-BUCKET.           
           MOVE WS-BJ-COUNTER     TO WS-RESTART-BJ-COUNTER.             
           MOVE WS-CJ-COUNTER     TO WS-RESTART-CJ-COUNTER.             
           MOVE WS-MJ-COUNTER     TO WS-RESTART-MJ-COUNTER.             
      *                                                                 22750014
           IF WS-REPOSITION-NEEDED = WS-N                               
      *** THIS CHECKPOINT IS THEREFORE THE ONE TAKEN AFTER COMPLETION   22770014
      *** OF PROCESSING LOOP #2 OR #3:                                  22780014
               IF WS-PROCESS-TYPE > WS-2                                
                   MOVE WS-99          TO WS-RESTART-CASH-COMPANY-NO    
                   MOVE WS-999         TO WS-RESTART-CASH-LOCAL-OFFICE  
                   MOVE WS-999         TO WS-RESTART-CASH-REPORT-NO     
                   MOVE WS-ZERO-DATE   TO WS-RESTART-DATE-CASH-REPORT   
                   MOVE 9999           TO WS-RESTART-CASH-DRAWER-ID     
               ELSE                                                     
      *** THIS CHECKPOINT IS THEREFORE THE INITIAL ONE OR THE ONE       22840014
      *** TAKEN AFTER COMPLETION OF PROCESSING LOOP #1:                 22850014
                   MOVE SPACES         TO WS-RESTART-CASH-COMPANY-NO    
                                          WS-RESTART-CASH-LOCAL-OFFICE  
                                          WS-RESTART-CASH-REPORT-NO     
                   MOVE WS-NINES-DATE  TO WS-RESTART-DATE-CASH-REPORT   
                   MOVE ZEROES         TO WS-RESTART-CASH-DRAWER-ID
               END-IF     
           ELSE                                                         
               IF WS-PROCESS-TYPE = WS-1                                
                   MOVE BC-CASH-COMPANY-NO                              
                                       TO WS-RESTART-CASH-COMPANY-NO    
                   MOVE BC-CASH-LOCAL-OFFICE                            
                                       TO WS-RESTART-CASH-LOCAL-OFFICE  
                   MOVE BC-CASH-REPORT-NO                               
                                       TO WS-RESTART-CASH-REPORT-NO     
                   MOVE BC-DATE-CASH-REPORT                             
                                       TO WS-RESTART-DATE-CASH-REPORT   
                   MOVE BC-CASH-DRAWER-ID                               
                                       TO WS-RESTART-CASH-DRAWER-ID     
               ELSE                                                     
               IF WS-PROCESS-TYPE = WS-2                                
                   MOVE CS-CASH-COMPANY-NO                              
                                       TO WS-RESTART-CASH-COMPANY-NO    
                   MOVE CS-CASH-LOCAL-OFFICE                            
                                       TO WS-RESTART-CASH-LOCAL-OFFICE  
                   MOVE CS-CASH-REPORT-NO                               
                                       TO WS-RESTART-CASH-REPORT-NO     
                   MOVE CS-DATE-CASH-REPORT                             
                                       TO WS-RESTART-DATE-CASH-REPORT   
                   MOVE CS-CASH-DRAWER-ID                               
                                       TO WS-RESTART-CASH-DRAWER-ID     
               ELSE                                                     
      *** THIS CHECKPOINT IS THEREFORE ONE TAKEN DURING PROCESSING      23000014
      *** LOOP #3 (LOOP #3 DOES NOT REQUIRE REPOSITIONING KEYS;         23010014
      *** MISC_JRNL MERELY FETCHES ALL NOT-YET-EXTRACTED MISC JRNLS):   23020014
                   MOVE WS-99          TO WS-RESTART-CASH-COMPANY-NO    
                   MOVE WS-999         TO WS-RESTART-CASH-LOCAL-OFFICE  
                   MOVE WS-999         TO WS-RESTART-CASH-REPORT-NO     
                   MOVE WS-ZERO-DATE   TO WS-RESTART-DATE-CASH-REPORT   
                   MOVE 9999           TO WS-RESTART-CASH-DRAWER-ID
               END-IF
               END-IF
           END-IF.    
      *                                                                 23060014
      ******************************************************            23070014
      *** THE FOLLOWING STATEMENT PERFORMS A PARAGRAPH THAT   ***       23080014
      *** REPLACES THE RESTART DATA RECORD IN THE RESTART     ***       23090014
      *** TABLE:                                              ***       23100014
      ******************************************************            23110014
           PERFORM 8899-WRITE-RSDDR THRU 8899-EXIT.                     
           CLOSE FCSCA06-FILE.                                          
           IF FCA06-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8898-CLOSE ERROR ON FCSCA06-FILE.'              
               DISPLAY 'FILE STATUS IS ' WS-FCA06-STATUS                
               DISPLAY '*   PROCESSING TERMINATED'                      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *** THE FOLLOWING STATEMENTS ISSUE A CHECKPOINT CALL:   ***       23210014
      *                                                                 23220014
           EXEC SQL                                                     23230014
               INCLUDE CPD00047                                         23240014
           END-EXEC.                                                    23250014
           OPEN EXTEND FCSCA06-FILE.                                    
           IF FCA06-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8898-OPEN ERROR ON FCSCA06-FILE.'               
               DISPLAY 'FILE STATUS IS ' WS-FCA06-STATUS                
               DISPLAY '*   PROCESSING TERMINATED'                      
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 23350014
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'           
           IF WS-PROCESS-TYPE EQUAL WS-1                                
               IF WS-REPOSITION-NEEDED EQUAL WS-N                       
                   DISPLAY '** THIS IS THE INITIAL CHECKPOINT '         
               ELSE                                                     
                   DISPLAY '** LAST BATCH JRNL PROCESSED: '             
                   DISPLAY                                              
                      '** COMP/LO/RPT/RPT DATE/ID/TRAN DATE/ENTRY/NO= ' 
                       BC-CASH-COMPANY-NO    '/'                        
                       BC-CASH-LOCAL-OFFICE  '/'                        
                       BC-CASH-REPORT-NO     '/'                        
                       BC-DATE-CASH-REPORT   '/'                        
                       BC-CASH-DRAWER-ID     '/'                        
                       BJ-DATE-TRAN '/'                                 
                       BJ-ENTRY-NO '/'                                  
                       BJ-TRAN-APPL-NO
               END-IF                                  
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-2                                
               IF WS-REPOSITION-NEEDED EQUAL WS-N                       
                   DISPLAY '** THIS IS THE FINAL CHECKPOINT AFTER'      
                           ' PROCESSING ALL BATCH JRNLS'                
                   DISPLAY '** LAST BATCH JRNL PROCESSED: '             
                   DISPLAY                                              
                      '** COMP/LO/RPT/RPT DATE/ID/TRAN DATE/ENTRY/NO= ' 
                       BC-CASH-COMPANY-NO    '/'                        
                       BC-CASH-LOCAL-OFFICE  '/'                        
                       BC-CASH-REPORT-NO     '/'                        
                       BC-DATE-CASH-REPORT   '/'                        
                       BC-CASH-DRAWER-ID     '/'                        
                       BJ-DATE-TRAN '/'                                 
                       BJ-ENTRY-NO '/'                                  
                       BJ-TRAN-APPL-NO                                  
               ELSE                                                     
                   DISPLAY '** LAST CASH DRWR JRNL PROCESSED: '         
                   DISPLAY                                              
                      '** COMP/LO/RPT/RPT DATE/ID/TRAN DATE/ENTRY/NO= ' 
                       CS-CASH-COMPANY-NO    '/'                        
                       CS-CASH-LOCAL-OFFICE  '/'                        
                       CS-CASH-REPORT-NO     '/'                        
                       CS-DATE-CASH-REPORT   '/'                        
                       CS-CASH-DRAWER-ID     '/'                        
                       CJ-DATE-TRAN         '/'                         
                       CJ-ENTRY-NO          '/'                         
                       CJ-TRAN-APPL-NO
               END-IF                                  
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-3                                
               IF WS-REPOSITION-NEEDED EQUAL WS-N                       
                   DISPLAY '** THIS IS THE FINAL CHECKPOINT AFTER'      
                           ' PROCESSING CASH DRWR JRNLS'                
                   DISPLAY '** LAST CASH DRWR JRNL PROCESSED: '         
                   DISPLAY                                              
                      '** COMP/LO/RPT/RPT DATE/ID/TRAN DATE/ENTRY/NO= ' 
                       CS-CASH-COMPANY-NO    '/'                        
                       CS-CASH-LOCAL-OFFICE  '/'                        
                       CS-CASH-REPORT-NO     '/'                        
                       CS-DATE-CASH-REPORT   '/'                        
                       CS-CASH-DRAWER-ID     '/'                        
                       CJ-DATE-TRAN         '/'                         
                       CJ-ENTRY-NO          '/'                         
                       CJ-TRAN-APPL-NO                                  
               ELSE                                                     
                   DISPLAY '** LAST MISC JRNL PROCESSED: '              
                   DISPLAY '** COMP/LOC OFF/CASH DRAWER/DATE/ENTRY/'    
                           'TRAN APPL NO='                              
                       MJ-COMPANY-NO        '/'                         
                       MJ-LOCAL-OFFICE      '/'                         
                       MJ-CASH-DRAWER-ID    '/'                         
                       MJ-DATE-TRAN         '/'                         
                       MJ-ENTRY-NO          '/'                         
                       MJ-TRAN-APPL-NO
               END-IF                                  
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-4                                
               DISPLAY '** THIS IS THE FINAL CHECKPOINT AFTER'          
                       ' PROCESSING MISC JRNLS'                         
               DISPLAY '** LAST MISC JRNL PROCESSED: '                  
               DISPLAY '** COMP/LOC OFF/CASH DRAWER/DATE/ENTRY/'        
                       'TRAN APPL NO='                                  
                       MJ-COMPANY-NO        '/'                         
                       MJ-LOCAL-OFFICE      '/'                         
                       MJ-CASH-DRAWER-ID    '/'                         
                       MJ-DATE-TRAN         '/'                         
                       MJ-ENTRY-NO          '/'                         
                       MJ-TRAN-APPL-NO
           END-IF
           END-IF
           END-IF
           END-IF.                                 
      *                                                                 24090014
      *** THE FOLLOWING STATEMENT RESETS THE CHKP POINTERS: ***         24100014
           MOVE ZERO TO WS-CHKP-LUW-COUNTER                             
                        WS-CHKP-UPD-COUNTER.                            
           IF WS-REPOSITION-NEEDED EQUAL WS-N                           
               GO TO 8898-EXIT
           END-IF.                                         
      *** THE FOLLOWING STATEMENTS REPOSITION THE JRNL TABLES IF NEEDED:24150014
      *                                                                 24160014
           IF WS-PROCESS-TYPE EQUAL WS-1                                
               MOVE WS-RESTART-CASH-COMPANY-NO                          
                                           TO BC-CASH-COMPANY-NO        
               MOVE WS-RESTART-CASH-LOCAL-OFFICE                        
                                           TO BC-CASH-LOCAL-OFFICE      
               MOVE WS-RESTART-CASH-REPORT-NO                           
                                           TO BC-CASH-REPORT-NO         
               MOVE WS-RESTART-DATE-CASH-REPORT                         
                                           TO BC-DATE-CASH-REPORT       
               MOVE WS-RESTART-CASH-DRAWER-ID                           
                                           TO BC-CASH-DRAWER-ID         
      *** REPOSITION TO SAME CO/LO/RPT NO/RPT DATE/ID:                  24210017
               PERFORM 7100-OPEN-BATCH-JRNL-CNTRL THRU 7100-EXIT        
               PERFORM 7110-FETCH-BATCH-JRNL-CNTRL THRU 7110-EXIT       
      *** OPEN CURSOR TO GET ALL NOT-YET-EXTRACTED BJ'S:                24240014
               PERFORM  7200-OPEN-BATCH-JRNL  THRU  7200-EXIT           
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-2                                
               MOVE WS-RESTART-CASH-COMPANY-NO                          
                                           TO CS-CASH-COMPANY-NO        
               MOVE WS-RESTART-CASH-LOCAL-OFFICE                        
                                           TO CS-CASH-LOCAL-OFFICE      
               MOVE WS-RESTART-CASH-REPORT-NO                           
                                           TO CS-CASH-REPORT-NO         
               MOVE WS-RESTART-DATE-CASH-REPORT                         
                                           TO CS-DATE-CASH-REPORT       
               MOVE WS-RESTART-CASH-DRAWER-ID                           
                                           TO CS-CASH-DRAWER-ID         
      *** REPOSITION TO SAME CO/LO/RPT NO/RPT DATE/ID:                  24210017
               PERFORM 7300-OPEN-CASH-DRWR-CNTRL THRU 7300-EXIT         
               PERFORM 7310-FETCH-CASH-DRWR-CNTRL THRU 7310-EXIT        
      *** OPEN CURSOR TO GET ALL NOT-YET-EXTRACTED CJ'S:                24340014
           PERFORM  7400-OPEN-CASH-DRWR  THRU  7400-EXIT                
           ELSE                                                         
           IF WS-PROCESS-TYPE EQUAL WS-3                                
      *** OPEN CURSOR TO GET ALL NOT-YET-EXTRACTED MJ'S:                24380014
               PERFORM 7500-OPEN-MISC-JRNL THRU 7500-EXIT
           END-IF
           END-IF
           END-IF.              
       8898-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24420014
       8899-WRITE-RSDDR.                                                
           MOVE WS-1         TO RF-PARTITION-NO.                        
           MOVE WS-PGRMNAME  TO RF-NAME-PROGRAM.                        
           MOVE WS-1         TO RF-DUP-CNTRL-NO.                        
           MOVE WS-RESTART-DATA        TO RF-RESTART-DATA-TEXT.         
           MOVE WS-RESTART-DATA-LENGTH TO RF-RESTART-DATA-LEN.          
           PERFORM 8896-UPDATE-RESTART THRU 8896-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8897-INSERT-RESTART THRU 8897-EXIT
           END-IF.              
       8899-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            24540014
       9000-TERMINATE.                                                  
           CLOSE FCSCA06-FILE.                                          
       9000-EXIT.                                                       
           EXIT.                                                        
T24436******************************************************************25080000
T24436*  9700-PROCESS-ABEND                                            *25100000
T24436******************************************************************25120000
T24436*                                                                 25130000
T24436 COPY CPD0023B.                                                   25140000
      *                                                                         
            EXEC SQL                                                    24620014
              INCLUDE CPD09900                                          24630014
            END-EXEC.                                                   24640014
