       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA119.                                        
       DATE-WRITTEN.   02/23/98.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **            - COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      ** THIS PROGRAM WAS CREATED TO SAMPLE BILL A FEW ACCOUNTS      **         
      ** BEFORE THE ENTIRE BILLING PROCESS TAKES PLACE. THIS PROGRAM **         
      ** READS IN A FILE WHICH HAS THE TEST BILL ACCOUNT INFORMATION **         
      ** AND CHECKS IT AGAINST CSS_AR_TRANS_HIST FOR ACCURACY AND    **         
      ** PRINTS OUT THE RESULTS IN A REPORT.                         **         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **              --------------------------                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  ________     __________________________________  **         
      **  02/24/98    TDK        NEW PROGRAM FOR SAMPLE BILLING      **         
      **                                                             **         
T16425**  05/18/98    CBSI       REPORT FORMAT IS CHANGED.           **         
      **                                                             **         
T20337**  07/21/99    CBSI       JCL PARM ADDED TO IDENTIFY INDUSTRIAL*         
      **                         SAMPLE BILLING RUN.                 **         
T20761**  09/10/99    CBSI       CHANGES MADE FOR SEB.               **         
T19976**  02/08/00    SREENI     CHANGES MADE TO CONSIDER ONLY       **         
      **                         UTILITY CHARGES IN THE COMPARISON.  **         
T22229**  05/19/00    CBSI       ADD RATE PLAN NO TO THE REPORT      **         
T22229**              CHENNAI                                        **         
T26971**  08/13/2002  SEBR       ADD LOCAL OFFICE AND REGULATED CODE.**         
T26971**              DP19151     CML 26971                          **         
T26971**              SB35550     CML 26971                          **         
C34569**  03/19/2008  VY95550    ADD OPTION_CD AND DESCRIPTION FOR   **         
C34569**                         SEB REPORT                          **         
A01958**  01/02/2009  SJ97149    1.ADD WQ INFORMATION FOR THE ACCOUNT**         
A01958**                         FOR CSR AND SEB REPOR.              **         
A01958**                         2.ADDING FETCH ONLY WITH UR FOR THE **         
A01958**                         CURSOR AS PERFORMANCE TUNNING.      **         
P00473**  07/21/2011  SB93596    CHGS INCLUDED TO PULL APPROVED      **         
P00473**                         OPTION RECORDS.                     **         
ACT130**  08/13/2013  BD09555    DELETE CSS_WQ_ITEMS_MF AT END OF    **         
ACT130**        A04527           PROGRAM                             **         
ACT130**  08/23/2013  BD09555    CHANGE RETURN CODE TO 5 IF SQL ERROR**         
ACT130**                         DELETING CSS_WQ_ITEMS_MF            **         
ACT112**   04/15/16  MS7M727    REPLACE CSS_WQ_ITEMS_MF TABLE  WITH  **         
      **             A04860     CSS_WQ_ITEMS TABLE                   **         
      *****************************************************************         
           REMARKS.                                                     
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
      **************************************************************            
      *  CSSRP697  -  SELECT STATEMENT FOR FCSRP697 INPUT FILE.    *            
      **************************************************************            
             SELECT FCSSF95-FILE                                        
             ASSIGN TO UT-S-FCSSF95                                     
             FILE STATUS IS WS-FCSSF95-STATUS.                          
                                                                        
      ******************************************************************        
      * CSSPT33 - SELECT STATEMENT FOR A 133 CHAR/RECORD PRINT FILE    *        
      ******************************************************************        
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
      ****************************************************************          
      *             FD STATEMENT FOR THE INPUT FILE                  *          
      ****************************************************************          
      *                                                                         
       FD  FCSSF95-FILE                                                 
           RECORD CONTAINS 0 CHARACTERS.                                
      *                                                                         
T20761 COPY FCSSF95.                                                            
      *                                                                         
      *****************************************************************         
      * CFDPT33 - FD STATEMENT FOR A 133 CHAR/RECORD PRINT FILE       *         
      *****************************************************************         
       FD  FCSPT33-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRT33-RECORD.                                                
           05  PRT33-CC                  PIC X(01).                     
           05  PRT33-DATA                PIC X(132).                    
      *                                                                         
      ******************************************************************        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA119'.
MSQ017     COPY MFASQLM.
      ******************************************************************        
      *                                                                         
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                         
       01  WS-MISC.                                                     
      *                                                                         
           05  WS-DEFAULT-RPT1-HEADER1 PIC X(32)    VALUE               
                             'SAMPLE BILLING COMPARISON REPORT'.        
T20337     05  WS-DEFAULT-RPT2-HEADER1 PIC X(10)    VALUE 'INDUSTRIAL'. 
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
                                   '  S C ELECTRIC & GAS CO   '.        
T20761     05  WS-DEFAULT-COMPANY-NO   PIC X(02)    VALUE '01'.         
A01958     05  WS-COMPANY-NO           PIC X(02)    VALUE SPACES.       
      *                                                                         
           05  WS-MORE-DATA-SW          PIC X(01)    VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
           05  WS-FCSSF95-STATUS        PIC X(02).                      
               88  FCSSF95-SUCCESSFUL                VALUE '00'.        
               88  FCSSF95-EMPTY                     VALUE '10'.        
      *                                                                         
           05  WS-DISCREPANCIES-SW      PIC X(01)    VALUE 'N'.         
               88 DISCREPANCIES-EXIST                VALUE 'Y'.         
      *                                                                         
           05  WS-ERROR-MESSAGES.                                       
               10  WS-ACCT-NOT-FOUND-MSG   PIC X(26) VALUE              
                   'BILL NOT FOUND FOR ACCOUNT'.                        
               10  WS-BILL-AMT-DIFF-MSG    PIC X(43) VALUE              
                   'AMOUNT ENTERED DOES NOT MATCH AMOUNT BILLED'.       
      *                                                                         
           05  WS-AMT-DIFFERENCE    PIC S9(10)V9(02).                   
T19976     05  WS-TOTAL-BILL-ITEM   PIC S9(9)V9(2) COMP-3 VALUE 0.      
           05  WS-SUM-NULL-IND      PIC S9(4)                   COMP.   
T16425     05  WS-DISPLAY-RC        PIC -ZZZZZZZZ9.9.                   
      *                                                                         
      ******************************************************************        
      *                                                                         
       01  WS-RPT1-LINE-NO             PIC 9(02)    VALUE 62   COMP-3.  
      *                                                                         
       01  WS-RPT1-PAGE-NO             PIC 9(05)    VALUE ZERO COMP-3.  
      *                                                                         
           COPY CWS00010.                                                       
           COPY CWS00037.                                                       
           COPY CWS00038.                                                       
           COPY CWS00039.                                                       
           COPY CWS00303.                                                       
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
A01958*    CSS_BILLING_DET  BG                                                  
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
T19976         INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
T19976*                                                                         
T16425******************************************************************        
A01958*    CSS_BILLING_HDR BI                                                   
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
T19976         INCLUDE TBBLLHDR                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      ******************************************************************        
A01958*    CSS_JOB_PARM  G6                                                     
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
T20761******************************************************************        
A01958*    CSS_COMPANY C7                                                       
T20761******************************************************************        
T20761                                                                  
T20761     EXEC SQL                                                             
T20761         INCLUDE TBCOMPNY                                                 
T20761     END-EXEC.                                                            
HPCCDM*EJECT                                                                    
T26971******************************************************************        
A01958*    CSS_LOCAL_OFFICE  B1                                                 
T26971******************************************************************        
T26971                                                                  
T26971     EXEC SQL                                                             
T26971         INCLUDE TBLOCOFC                                                 
T26971     END-EXEC.                                                            
      *                                                                         
T26971******************************************************************        
A01958*    CSS_ACCOUNT  AT                                                      
T26971******************************************************************        
T26971                                                                  
T26971     EXEC SQL                                                             
T26971         INCLUDE TBACCT                                                   
T26971     END-EXEC.                                                            
      *                                                                         
T26971******************************************************************        
A01958*    CSS_DELINQUENCY  C8                                                  
T26971******************************************************************        
T26971                                                                  
T26971     EXEC SQL                                                             
T26971         INCLUDE TBDELQ                                                   
T26971     END-EXEC.                                                            
C34569*                                                                         
C34569******************************************************************        
C34569*    CSS_UTIL_ENVRNMT, UT                                                 
C34569******************************************************************        
C34569                                                                  
C34569     EXEC SQL                                                             
C34569         INCLUDE TBUTLENV                                                 
C34569     END-EXEC.                                                            
C34569*                                                                         
C34569******************************************************************        
C34569*    CRM_RT_PKG_OPTION, FI                                                
C34569******************************************************************        
C34569                                                                  
C34569     EXEC SQL                                                             
C34569         INCLUDE TBRTPKGO                                                 
C34569     END-EXEC.                                                            
C34569*                                                                         
C34569******************************************************************        
C34569*    CSS_ACCT_RTPK_AGR, DF                                                
C34569******************************************************************        
C34569                                                                  
C34569     EXEC SQL                                                             
C34569         INCLUDE TBACCTRG                                                 
C34569     END-EXEC.                                                            
      *                                                                         
A01958*                                                                         
ACT112******************************************************************        
ACT112*    CSS_WQ_ITEMS, WQ                                                     
ACT112******************************************************************        
ACT112                                                                  
ACT112     EXEC SQL                                                             
ACT112          INCLUDE TBWQITS                                                 
ACT112     END-EXEC.                                                            
ACT112*                                                                         
      ******************************************************************        
       01  WS-CURRENT-TIME.                                             
           05  WS-HH                   PIC 9(02).                       
           05  WS-MM                   PIC 9(02).                       
           05  WS-SS                   PIC 9(02).                       
           05  WS-TT                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-TIME.                                                 
           05  WS-RT-HH                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE ':'.          
           05  WS-RT-SS                PIC X(02).                       
      *                                                                         
       01  WS-CURRENT-DATE.                                             
           05  WS-CY                   PIC 9(02).                       
           05  WS-CM                   PIC 9(02).                       
           05  WS-CD                   PIC 9(02).                       
      *                                                                         
       01  WS-RUN-DATE.                                                 
           05  WS-RD-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)    VALUE '/'.          
           05  WS-RD-YY                PIC X(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-0                    PIC 9(01)    VALUE 0.            
           05  WS-1                    PIC 9(01)    VALUE 1.            
           05  WS-2                    PIC 9(01)    VALUE 2.            
           05  WS-3                    PIC 9(01)    VALUE 3.            
           05  WS-4                    PIC 9(01)    VALUE 4.            
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA119'.   
T26971     05  WS-REG-DEREG-LABEL      PIC X(05)    VALUE '     '.      
      *                                                                         
      ****************************************************************          
      *                  PCSRP697 REPORT HEADERS                     *          
      ****************************************************************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT TITLE            **          
      ****************************************************************          
      *                                                                         
          05   WS-RPT1-TITLE.                                           
               10 P-RPT1-TITLE-PGNM    PIC X(10)    VALUE SPACES.       
               10 FILLER               PIC X(40)    VALUE SPACES.       
               10 P-RPT1-COMP-NAME     PIC X(26).                       
               10 FILLER               PIC X(38)    VALUE SPACES.       
               10 FILLER               PIC X(10)    VALUE 'RUN-DATE: '. 
               10 P-RPT1-RUN-DATE      PIC X(08).                       
      *                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT HEADER1          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-1.                                        
               10  FILLER              PIC X(06)    VALUE 'DATE: '.     
               10  P-RPT1-MONTH        PIC X(02).                       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  P-RPT1-DAY          PIC X(02).                       
               10  FILLER              PIC X(01)    VALUE '/'.          
               10  P-RPT1-YEAR         PIC X(02).                       
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  P-RPT1-HEAD1        PIC X(34).                       
               10  FILLER              PIC X(33)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
               10  P-RPT1-RUN-TIME     PIC X(08).                       
      *                                                                         
T20337     05  WS-RPT2-HEADER-1.                                        
T20337         10  FILLER              PIC X(06)    VALUE 'DATE: '.     
T20337         10  P-RPT2-MONTH        PIC X(02).                       
T20337         10  FILLER              PIC X(01)    VALUE '/'.          
T20337         10  P-RPT2-DAY          PIC X(02).                       
T20337         10  FILLER              PIC X(01)    VALUE '/'.          
T20337         10  P-RPT2-YEAR         PIC X(02).                       
T20337         10  FILLER              PIC X(28)    VALUE SPACES.       
T20337         10  P-RPT2-HEAD1        PIC X(10).                       
T20337         10  FILLER              PIC X(01)    VALUE SPACES.       
T20337         10  P-RPT2-HEAD2        PIC X(32).                       
T20337         10  FILLER              PIC X(29)    VALUE SPACES.       
T20337         10  FILLER              PIC X(10)    VALUE 'RUN-TIME: '. 
T20337         10  P-RPT2-RUN-TIME     PIC X(08).                       
T20337*                                                                         
      ****************************************************************          
      **         COMMON WORKING STORAGE FOR REPORT HEADER2          **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-HEADER-2.                                        
T20337         10  FILLER              PIC X(14)    VALUE SPACES.       
               10  FILLER              PIC X(104)   VALUE SPACES.       
               10  FILLER              PIC X(06)    VALUE 'PAGE: '.     
               10  FILLER              PIC X(02)    VALUE SPACES.       
               10  P-RPT1-PAGE-NO      PIC ZZ,ZZ9.                      
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT1-COLUMN-HEADER-1.                                 
T19976         10  FILLER              PIC X(02)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE               
                                                    'ACCOUNT NO'.       
T22229         10  FILLER              PIC X(05)    VALUE SPACES.       
T22229         10  FILLER              PIC X(07)    VALUE 'UTILITY'.    
A01958         10  FILLER              PIC X(04)    VALUE SPACES.       
T22229         10  FILLER              PIC X(09)    VALUE 'RATE PLAN'.  
A01958         10  FILLER              PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE               
                                                    'AMT BILLED'.       
A01958         10  FILLER              PIC X(03)    VALUE SPACES.       
A01958         10  FILLER              PIC X(07)    VALUE 'COMP NO'.    
A01958         10  FILLER              PIC X(03)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE               
                                                    'AMT ENTERED'.      
T22229         10  FILLER              PIC X(07)    VALUE SPACES.       
               10  FILLER              PIC X(10)    VALUE               
                                                    'DIFFERENCE'.       
T22229         10  FILLER              PIC X(19)    VALUE SPACES.       
               10  FILLER              PIC X(07)    VALUE               
                                                    'MESSAGE'.          
T19976         10  FILLER              PIC X(20)    VALUE SPACES.       
C34569*                                                                         
C34569     05  WS-RPT1-COLUMN-HEADER-1-SEB.                             
C34569         10  FILLER              PIC X(02)    VALUE SPACES.       
C34569         10  FILLER              PIC X(10)    VALUE               
C34569                                              'ACCOUNT NO'.       
C34569         10  FILLER              PIC X(05)    VALUE SPACES.       
C34569         10  FILLER              PIC X(07)    VALUE 'UTILITY'.    
C34569         10  FILLER              PIC X(17)    VALUE SPACES.       
C34569         10  FILLER              PIC X(10)    VALUE               
C34569                                              'AMT BILLED'.       
A01958         10  FILLER              PIC X(02)    VALUE SPACES.       
A01958         10  FILLER              PIC X(07)    VALUE 'COMP NO'.    
A01958         10  FILLER              PIC X(03)    VALUE SPACES.       
C34569         10  FILLER              PIC X(11)    VALUE               
C34569                                              'AMT ENTERED'.      
C34569         10  FILLER              PIC X(07)    VALUE SPACES.       
C34569         10  FILLER              PIC X(10)    VALUE               
C34569                                              'DIFFERENCE'.       
C34569         10  FILLER              PIC X(19)    VALUE SPACES.       
C34569         10  FILLER              PIC X(07)    VALUE               
C34569                                              'MESSAGE'.          
C34569         10  FILLER              PIC X(20)    VALUE SPACES.       
C34569*                                                                         
C34569     05  WS-RPT1-COLUMN-HEADER-2-SEB.                             
C34569         10  FILLER              PIC X(26)    VALUE SPACES.       
C34569         10  FILLER              PIC X(23)    VALUE               
C34569                                 'OPTION CODE-DESCRIPTION'.       
C34569         10  FILLER              PIC X(83)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **          WORKING STORAGE FOR REPORT DETAIL LINES           **          
      ****************************************************************          
      *                                                                         
       01  WS-RPT1-DETAIL-LINES.                                        
T16425     05  WS-RPT1-DETAIL-LINE-0.                                   
ST             10  FILLER                 PIC X(01)    VALUE SPACES.    
               10  P0-ACCOUNT-NO          PIC X(13)    VALUE SPACES.    
               10  FILLER                 PIC X(117)   VALUE SPACES.    
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-1.                                   
               10  FILLER                 PIC X(01)    VALUE SPACES.    
               10  P-ACCOUNT-NO           PIC X(13)    VALUE SPACES.    
T19976         10  FILLER                 PIC X(03)    VALUE SPACES.    
T19976         10  P-UTIL-TYPE            PIC X(08)    VALUE SPACES.    
A01958         10  FILLER                 PIC X(05)    VALUE SPACES.    
T22229         10  P-RATE-PLAN-NO         PIC X(03)    VALUE SPACES.    
A01958         10  FILLER                 PIC X(03)    VALUE SPACES.    
               10  P-AMT-POSTED           PIC ZZZ,ZZZ,ZZ9.99.           
               10  FILLER                 PIC X(05)    VALUE SPACES.    
A01958         10  P-COMPANY              PIC X(02)    VALUE SPACES.    
      *                                                                         
           05  WS-RPT1-DETAIL-LINE-2.                                   
               10  FILLER                 PIC X(03)    VALUE SPACES.    
               10  FILLER                 PIC X(08)    VALUE 'TOTAL = '.
A01958         10  FILLER                 PIC X(25)    VALUE SPACES.    
T20761         10  P-AMT-BILLED           PIC ZZZ,ZZZ,ZZ9.99-.          
T19976         10  FILLER                 PIC X(09)    VALUE SPACES.    
T20761         10  P-AMT-ENTERED          PIC ZZZ,ZZZ,ZZ9.99-.          
T22229         10  FILLER                 PIC X(02)    VALUE SPACES.    
               10  P-DIFFERENCE           PIC ZZZ,ZZZ,ZZ9.99-.          
END            10  FILLER                 PIC X(04)    VALUE SPACES.    
T16425         10  P-MESSAGE              PIC X(43).                    
C34569*                                                                         
C34569     05  WS-RPT1-DETAIL-LINE-3-SEB.                               
C34569         10  FILLER                 PIC X(26)    VALUE SPACES.    
C34569         10  P-OPTION-CD3           PIC X(12)    VALUE SPACES.    
C34569         10  FILLER                 PIC X(01)    VALUE '-'.       
C34569         10  P-OPTION-DESC-INT3     PIC X(50)    VALUE SPACES.    
      *                                                                         
A01958     05  WS-RPT1-DETAIL-LINE-3.                                   
A01958         10  FILLER                 PIC X(01)    VALUE SPACES.    
A01958         10  P3-ACCOUNT-NO          PIC X(13)    VALUE SPACES.    
A01958         10  FILLER                 PIC X(03)    VALUE SPACES.    
A01958         10  P-WQ-MESSAGE           PIC X(115).                   
A01958*                                                                         
      ****************************************************************          
      *                                                                         
       01  WS-LINE                     PIC X(132)   VALUE ALL '-'.      
      *                                                                         
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '** NO DATA THIS RUN **'.                          
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)    VALUE               
                     '*** END OF REPORT ***'.                           
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
ST         EXEC SQL                                                     
T19976         DECLARE  BG-DET    CURSOR FOR                            
T19976          SELECT  BG.CODE_UTIL_TYPE                               
T19976                 ,BG.AMT_BILL_ITEM                                
T22229                 ,BG.RATE_PLAN_NO                                 
A01958                 ,BG.COMPANY_NO                                   
T19976            FROM  CSS_BILLING_DET BG WITH(READUNCOMMITTED)                
T19976                 ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                
T19976           WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO              
T19976             AND  BI.ACCOUNT_NO     = BG.ACCOUNT_NO               
T19976             AND  BG.BILL_NO        = BI.BILL_NO                  
T19976             AND  BG.CODE_BILL_CALC = 'A'                         
T19976             AND  BI.DATE_BILLED    = IIF(TRY_CONVERT(DATE, 
                                                        :BI-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :BI-DATE-BILLED
              ) <> 0) OR (LEN(:BI-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :BI-DATE-BILLED
              ), CONVERT(DATE, :BI-DATE-BILLED) )             
T19976        ORDER BY BG.CODE_UTIL_TYPE                                
A01958        FOR READ ONLY                                     
T16425     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04180000
MFA-TR*        DECLARE  BG-DET    CURSOR FOR                            04190000
MFA-TR*         SELECT  BG.CODE_UTIL_TYPE                               04200000
MFA-TR*                ,BG.AMT_BILL_ITEM                                        
MFA-TR*                ,BG.RATE_PLAN_NO                                         
MFA-TR*                ,BG.COMPANY_NO                                           
MFA-TR*           FROM  CSS_BILLING_DET BG                                      
MFA-TR*                ,CSS_BILLING_HDR BI                                      
MFA-TR*          WHERE  BG.ACCOUNT_NO     = :BG-ACCOUNT-NO                      
MFA-TR*            AND  BI.ACCOUNT_NO     = BG.ACCOUNT_NO                       
MFA-TR*            AND  BG.BILL_NO        = BI.BILL_NO                          
MFA-TR*            AND  BG.CODE_BILL_CALC = 'A'                                 
MFA-TR*            AND  BI.DATE_BILLED    = :BI-DATE-BILLED                     
MFA-TR*       ORDER BY BG.CODE_UTIL_TYPE                                03030000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T26971     EXEC SQL                                                     
T26971         DECLARE  B1-LOC-OFC CURSOR FOR                           
T26971          SELECT  B1.LOCAL_OFFICE                                 
T26971                 ,B1.REGULATED_CD                                 
T26971            FROM  CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)               
T26971                 ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
T26971           WHERE  AT.ACCOUNT_NO     = :AT-ACCOUNT-NO              
T26971             AND  B1.LOCAL_OFFICE   = AT.LOCAL_OFFICE             
T26971             AND  B1.COMPANY_NO     = AT.COMPANY_NO               
A01958           FOR READ ONLY                                  
T26971     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04180000
MFA-TR*        DECLARE  B1-LOC-OFC CURSOR FOR                           04190000
MFA-TR*         SELECT  B1.LOCAL_OFFICE                                 04200000
MFA-TR*                ,B1.REGULATED_CD                                         
MFA-TR*           FROM  CSS_LOCAL_OFFICE B1                                     
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*          WHERE  AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                      
MFA-TR*            AND  B1.LOCAL_OFFICE   = AT.LOCAL_OFFICE                     
MFA-TR*            AND  B1.COMPANY_NO     = AT.COMPANY_NO                       
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T26971     EXEC SQL                                                     
T26971         DECLARE  C8-REGION CURSOR FOR                            
T26971          SELECT  C8.DELINQ_VALUE                                 
T26971            FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                
T26971           WHERE  C8.DELINQ_CD = 'DATABASE'                       
A01958           FOR READ ONLY                                  
T26971     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04180000
MFA-TR*        DECLARE  C8-REGION CURSOR FOR                            04190000
MFA-TR*         SELECT  C8.DELINQ_VALUE                                 04200000
MFA-TR*           FROM  CSS_DELINQUENCY C8                                      
MFA-TR*          WHERE  C8.DELINQ_CD = 'DATABASE'                               
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
A01958*                                                                         
A01958******************************************************************        
A01958* WQ-INFO-CSR CURSOR FOR GETTING THE WORK QUEUE COMMENTS FROM    *        
A01958* CSS_WQ_ITEMS    TABLE                                          *        
A01958******************************************************************        
A01958     EXEC SQL                                                     
A01958         DECLARE WQ-INFO-CSR CURSOR FOR                           
A01958         SELECT COMMENTS                                          
ACT112           FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                     
ACT112          WHERE WQ.ACCOUNT_NO  = :WQ-ACCOUNT-NO                   
A01958          FOR READ ONLY                                   
A01958     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04180000
MFA-TR*        DECLARE WQ-INFO-CSR CURSOR FOR                           04190000
MFA-TR*        SELECT COMMENTS                                                  
MFA-TR*          FROM CSS_WQ_ITEMS WQ                                           
MFA-TR*         WHERE WQ.ACCOUNT_NO  = :WQ-ACCOUNT-NO                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSCA119 ENDS HERE'.                    
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
T20337*****************************************************************         
T20337* IF THERE IS ANY JCL PARM & PARM='INDUSTRIAL', IT IS CONSIDERED*         
T20337* AS INDUSTRIAL SAMPLE BILLING, ELSE RESIDENTIAL BILLING.       *         
T20337*****************************************************************         
T20337 LINKAGE SECTION.                                                 
T20337*                                                                         
T20337 01  PARMIN.                                                      
T20337     05  PARMLENGTH                      PIC S9(4)      COMP.     
T20337     05  PARMDATA.                                                
T20337         10  PARM-RUN-TYPE               PIC X(10).               
T20337*                                                                         
T20337 PROCEDURE DIVISION USING PARMIN.                                 
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
      *                                                                         
           PERFORM 7100-READ-FCSSF95       THRU 7100-EXIT.              
      *                                                                         
T26971*    PERFORM 8150-PRINT-COMP-NAME THRU 8150-EXIT                          
      *                                                                         
           IF FCSSF95-EMPTY                                             
              PERFORM 8200-PRINT-TITLE     THRU 8200-EXIT               
              PERFORM 8300-PRINT-COLUMN-HEADERS THRU 8300-EXIT          
           ELSE                                                         
              PERFORM 8200-PRINT-TITLE     THRU 8200-EXIT               
              PERFORM 8300-PRINT-COLUMN-HEADERS THRU 8300-EXIT          
              PERFORM 1100-PRODUCE-REPORTS THRU 1100-EXIT               
                                           UNTIL NO-MORE-DATA           
      *                                                                         
              IF DISCREPANCIES-EXIST                                    
                 DISPLAY ' '                                            
                 DISPLAY '********** I M P O R T A N T *********'       
T20337           DISPLAY '**     PCSCA119 PROCESSING INFO     **'       
                 DISPLAY '** THERE WERE DISCREPANCIES FOUND   **'       
                 DISPLAY '** BETWEEN THE DATA ENTERED AND THE **'       
T19976           DISPLAY '** DATA READ FROM CSS_BILLING_DET   **'       
                 DISPLAY '** HENCE RETURN CODE IS SET TO 05   **'       
                 DISPLAY '**************************************'       
                 MOVE 05  TO  RETURN-CODE                               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-END-DATA-LINE                     
                       AFTER ADVANCING 2 LINES.                         
      *                                                                         
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TIME               
T20337                                    P-RPT2-RUN-TIME.              
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           OPEN INPUT FCSSF95-FILE.                                     
           IF FCSSF95-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**       PCSCA119 PROCESSING ERROR      **'     
               DISPLAY '** OPEN ERROR OF FCSSF95 - INPUT FILE   **'     
               DISPLAY '**      FILE STATUS = ' WS-FCSSF95-STATUS       
               DISPLAY '**        PROCESSING TERMINATED         **'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE 'PCSCA100'              TO WS-PGRMNAME.                 
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE
           END-IF.               
      *                                                                         
           MOVE WS-INPUT-DATE(3:2)      TO P-RPT1-YEAR                  
T20337                                     P-RPT2-YEAR.                 
           MOVE WS-INPUT-DATE(6:2)      TO P-RPT1-MONTH                 
T20337                                     P-RPT2-MONTH.                
           MOVE WS-INPUT-DATE(9:2)      TO P-RPT1-DAY                   
T20337                                     P-RPT2-DAY.                  
T19976     MOVE WS-INPUT-DATE           TO BI-DATE-BILLED.              
      *                                                                         
           MOVE 'PCSCA119'              TO WS-PGRMNAME.                 
C34569*                                                                         
C34569     PERFORM 7152-OPEN-C8-REGION  THRU 7152-EXIT.                 
C34569     PERFORM 7162-FETCH-C8-REGION THRU 7162-EXIT.                 
C34569     PERFORM 7172-CLOSE-C8-REGION THRU 7172-EXIT.                 
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1100-PRODUCE-REPORTS                                     **          
      **       CONTROLS THE MAIN FLOW OF THE REPORT PCSCA119        **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1100-PRODUCE-REPORTS.                                            
      *                                                                         
T16425     PERFORM 2200-PRODUCE-RPT THRU 2200-EXIT.                     
ST         WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
                   AFTER ADVANCING 1 LINE.                              
           ADD 1                             TO WS-RPT1-LINE-NO.        
      *                                                                         
           MOVE SPACES                       TO P0-ACCOUNT-NO.          
T19976     MOVE FCSSF95-ACCOUNT-NO           TO P-ACCOUNT-NO            
T19976                                          BG-ACCOUNT-NO           
T26971                                          AT-ACCOUNT-NO           
ACT112                                          WQ-ACCOUNT-NO.          
      *                                                                         
T26971     PERFORM 7151-OPEN-B1-LOC-OFC  THRU 7151-EXIT.                
T26971     PERFORM 7161-FETCH-B1-LOC-OFC THRU 7161-EXIT.                
T26971     PERFORM 7171-CLOSE-B1-LOC-OFC THRU 7171-EXIT.                
      *                                                                 07470000
T26971     PERFORM 7180-CHECK-REG-DEREG THRU 7180-EXIT.                 
      *                                                                         
T19976     PERFORM 7150-OPEN-BG-DET THRU 7150-EXIT.                     
T19976     PERFORM 7160-FETCH-BG-DET THRU 7160-EXIT.                    
           PERFORM 1200-GET-TRANS-HIST-DET THRU 1200-EXIT UNTIL         
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                   
           IF  P0-ACCOUNT-NO EQUAL SPACES OR LOW-VALUES                 
               MOVE FCSSF95-ACCOUNT-NO       TO P0-ACCOUNT-NO           
               WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-0            
                   AFTER ADVANCING 1 LINE                               
               ADD 1                         TO WS-RPT1-LINE-NO         
               MOVE SPACES                   TO P0-ACCOUNT-NO           
END        END-IF.                                                      
T19976     IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
T19976         PERFORM 1500-PROCESS-BILL-INFO    THRU 1500-EXIT         
T19976         PERFORM 2300-FORMAT-DETAIL-LINE2  THRU 2300-EXIT         
T19976     END-IF.                                                      
T19976     PERFORM 7170-CLOSE-BG-DET THRU 7170-EXIT.                    
T19976     MOVE ZEROS                        TO WS-TOTAL-BILL-ITEM.     
      *                                                                         
           PERFORM 7100-READ-FCSSF95         THRU 7100-EXIT.            
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T16425 1200-GET-TRANS-HIST-DET.                                         
ST    *                                                                         
           MOVE FCSSF95-ACCOUNT-NO       TO P0-ACCOUNT-NO.              
T19976     EVALUATE BG-CODE-UTIL-TYPE                                   
T19976        WHEN 'E'                                                  
T19976           MOVE 'ELECTRIC'         TO P-UTIL-TYPE                 
T19976        WHEN 'G'                                                  
T19976           MOVE 'GAS'              TO P-UTIL-TYPE                 
T19976        WHEN 'U'                                                  
T19976           MOVE 'LIGHTS'           TO P-UTIL-TYPE                 
T19976     END-EVALUATE.                                                
T19976*                                                                         
T22229     MOVE BG-RATE-PLAN-NO          TO P-RATE-PLAN-NO              
T19976     MOVE BG-AMT-BILL-ITEM         TO P-AMT-POSTED                
T19976     ADD BG-AMT-BILL-ITEM          TO WS-TOTAL-BILL-ITEM          
A01958     MOVE BG-COMPANY-NO            TO WS-COMPANY-NO               
A01958     MOVE WS-COMPANY-NO            TO P-COMPANY                   
      *                                                                         
C34569     IF C8-DELINQ-VALUE = 2                                       
C34569        MOVE SPACES                TO P-RATE-PLAN-NO              
C34569                                                                  
C34569        WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-1             
C34569              AFTER ADVANCING 1 LINE                              
C34569     ELSE                                                         
C34569        WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-1             
C34569              AFTER ADVANCING 1 LINE                              
C34569     END-IF                                                       
      *                                                                         
           ADD 1                             TO WS-RPT1-LINE-NO.        
      *                                                                         
           PERFORM 2200-PRODUCE-RPT THRU 2200-EXIT.                     
           MOVE SPACES                       TO P-ACCOUNT-NO.           
T19976     PERFORM 7160-FETCH-BG-DET THRU 7160-EXIT.                    
      *                                                                         
END    1200-EXIT.                                                       
T16425     EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   1500-PROCESS-BILL-INFO                                   **          
      **       PROCESSES THE INFORMATION NEEDED FOR THE REPORT      **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       1500-PROCESS-BILL-INFO.                                          
      *                                                                         
T19976     IF WS-TOTAL-BILL-ITEM = 0                                    
              MOVE WS-ACCT-NOT-FOUND-MSG   TO P-MESSAGE                 
T16425        MOVE ZEROES                  TO P-DIFFERENCE              
              MOVE WS-Y                    TO WS-DISCREPANCIES-SW       
           ELSE                                                         
T19976        IF FCSSF95-BILL-AMT NOT EQUAL WS-TOTAL-BILL-ITEM          
T19976           SUBTRACT WS-TOTAL-BILL-ITEM  FROM FCSSF95-BILL-AMT     
                    GIVING WS-AMT-DIFFERENCE                            
                 MOVE WS-AMT-DIFFERENCE    TO P-DIFFERENCE              
                 MOVE WS-BILL-AMT-DIFF-MSG TO P-MESSAGE                 
                 MOVE WS-Y                 TO WS-DISCREPANCIES-SW       
              ELSE                                                      
                 MOVE SPACES               TO P-MESSAGE                 
T16425           MOVE ZEROES               TO P-DIFFERENCE              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2200-PRODUCE-RPT                                         **          
      **       CONTROLS THE REPORT FORMAT OF THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       2200-PRODUCE-RPT.                                                
      *                                                                         
           IF WS-RPT1-LINE-NO GREATER THAN 60                           
T26791*        PERFORM 8150-PRINT-COMP-NAME      THRU 8150-EXIT                 
               PERFORM 8200-PRINT-TITLE          THRU 8200-EXIT         
               PERFORM 8300-PRINT-COLUMN-HEADERS THRU 8300-EXIT         
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   2300-FORMAT-DETAIL-LINE-2                                **          
      **       FORMATS THE DETAIL LINE 1 OF THE REPORT PCSCA119     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
T19976 2300-FORMAT-DETAIL-LINE2.                                        
      *                                                                         
           MOVE FCSSF95-BILL-AMT             TO P-AMT-ENTERED.          
T19976     MOVE WS-TOTAL-BILL-ITEM           TO P-AMT-BILLED.           
      *                                                                         
           PERFORM 8900-PRINT-DETAIL-LINE    THRU 8900-EXIT.            
      *                                                                         
A01958     PERFORM 8920-PROCESS-WQ-INFO-PARA THRU 8920-EXIT.            
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01958****************************************************************          
A01958**   2500-PROC-WQ-INFO-CUR-PARA                               **          
A01958****************************************************************          
A01958*                                                                         
A01958 2500-PROC-WQ-INFO-CUR-PARA.                                      
A01958*                                                                         
A01958     WRITE PRT33-RECORD FROM WS-BLANK-LINE                        
A01958                        AFTER ADVANCING 1 LINE.                   
A01958     WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-3                
A01958                        AFTER ADVANCING 1 LINE.                   
A01958     ADD 2                                TO WS-RPT1-LINE-NO.     
ACT112     MOVE SPACES                    TO WQ-COMMENTS-TEXT.          
ACT112     MOVE 115                       TO WQ-COMMENTS-LEN.           
A01958*                                                                         
A01958     PERFORM 7500-FETCH-WQ-INFO-CUR-PARA THRU 7500-EXIT.          
A01958                                                                  
A01958 2500-EXIT.                                                       
A01958     EXIT.                                                        
A01958*                                                                         
A01958******************************************************************        
A01958*    CPD00037                                                    *        
A01958*    PROCESSING 6251-GET-FJC01-DATE PARA                         *        
A01958******************************************************************        
           COPY CPD00037.                                                       
      *                                                                         
A01958******************************************************************        
A01958*    CPD00038                                                    *        
A01958*    PROCESSING 7600-START-FCSJC01                               *        
A01958******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
A01958******************************************************************        
A01958*    CPD00039                                                    *        
A01958*    PROCESSING 7620-START-FCSCA00                               *        
A01958******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
A01958******************************************************************        
A01958*    CPD00040                                                    *        
A01958*    PROCESSING 6240-GET-FCA00-COMMON-DATE PARA                  *        
A01958******************************************************************        
           COPY CPD00040.                                                       
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   7100-READ-FCSSF95                                        **          
      **      READS THE INPUT FILE FCSSF95-FILE                     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       7100-READ-FCSSF95.                                               
      *                                                                         
           READ FCSSF95-FILE                                            
               AT END                                                   
                   MOVE WS-N           TO WS-MORE-DATA-SW               
                   GO                  TO 7100-EXIT.                    
      *                                                                         
           IF FCSSF95-SUCCESSFUL                                        
T19976         MOVE FCSSF95-ACCOUNT-NO   TO BG-ACCOUNT-NO               
           ELSE                                                         
               DISPLAY '7100-ERROR ON FCSSF95 READ.  STATUS IS '        
                        WS-FCSSF95-STATUS                               
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  07440000
      * OPENING  BG-DET     CURSOR                                   *  07450000
      ****************************************************************  07460000
      *                                                                         
T19976 7150-OPEN-BG-DET.                                                
ST    *                                                                 07220000
           EXEC SQL                                                     
T19976        OPEN BG-DET                                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07260000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 07260000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSCA119**************'          
T19976         DISPLAY '* 7150-OPEN-BG-DET                  *'          
T19976         DISPLAY '* ACCOUNT-NO = ' BG-ACCOUNT-NO                  
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSCA119**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 07400000
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T26971****************************************************************  07440000
T26971* OPENING  B1-LOC-OFC  CURSOR                                  *  07450000
T26971****************************************************************  07460000
T26971*                                                                 07430000
T26971 7151-OPEN-B1-LOC-OFC.                                            
T26971*                                                                 07220000
T26971     EXEC SQL                                                     
T26971        OPEN B1-LOC-OFC                                           
T26971     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26971*                                                                 07260000
T26971     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T26971*                                                                 07260000
T26971     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T26971         NEXT SENTENCE                                            
T26971     ELSE                                                         
T26971         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T26971         DISPLAY '***************PCSCA119**************'          
T26971         DISPLAY '* 7151-OPEN-BG-LOC-IFC              *'          
T26971         DISPLAY '* ACCOUNT-NO = ' BG-ACCOUNT-NO                  
T26971         DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
T26971         DISPLAY '* PROGRAM ABENDING...               *'          
T26971         DISPLAY '***************PCSCA119**************'          
T26971         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T26971*                                                                 07400000
T26971 7151-EXIT.                                                       
T26971     EXIT.                                                        
T26971*                                                                 07430000
T26971****************************************************************  07440000
T26971* OPENING  C8-REGION   CURSOR                                  *  07450000
T26971****************************************************************  07460000
T26971*                                                                 07430000
T26971 7152-OPEN-C8-REGION.                                             
T26971*                                                                 07220000
T26971     EXEC SQL                                                     
T26971        OPEN C8-REGION                                            
T26971     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26971*                                                                 07260000
T26971     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T26971*                                                                 07260000
T26971     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T26971         NEXT SENTENCE                                            
T26971     ELSE                                                         
T26971         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T26971         DISPLAY '***************PCSCA119**************'          
T26971         DISPLAY '* 7152-OPEN-C8-REGION               *'          
T26971         DISPLAY '* ACCOUNT-NO = ' BG-ACCOUNT-NO                  
T26971         DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
T26971         DISPLAY '* PROGRAM ABENDING...               *'          
T26971         DISPLAY '***************PCSCA119**************'          
T26971         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T26971*                                                                 07400000
T26971 7152-EXIT.                                                       
T26971     EXIT.                                                        
T26971*                                                                 07430000
      ****************************************************************  07440000
T19976* FETCHING BG-DET     CURSOR                                   *  07450000
      ****************************************************************  07460000
T19976 7160-FETCH-BG-DET.                                               
      *                                                                 07480000
           EXEC SQL                                                     
T19976        FETCH BG-DET                                              
T19976         INTO :BG-CODE-UTIL-TYPE                                  
T19976             ,:BG-AMT-BILL-ITEM                                   
T22229             ,:BG-RATE-PLAN-NO                                    
A01958             ,:BG-COMPANY-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07540000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 07540000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSCA119**************'          
T19976         DISPLAY '* 7160-FETCH-BG-DET                 *'          
T19976         DISPLAY '* ACCOUNT-NO = ' BG-ACCOUNT-NO                  
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSCA119**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 07680000
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07710000
T26971****************************************************************  07440000
T26971* FETCHING B1-LOC-OFC CURSOR                                   *  07450000
T26971****************************************************************  07460000
T26971 7161-FETCH-B1-LOC-OFC.                                           
T26971*                                                                 07480000
T26971     EXEC SQL                                                     
T26971        FETCH B1-LOC-OFC                                          
T26971         INTO :B1-LOCAL-OFFICE                                    
T26971             ,:B1-REGULATED-CD                                    
T26971     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26971*                                                                 07540000
T26971     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T26971*                                                                 07540000
T26971     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T26971         NEXT SENTENCE                                            
T26971     ELSE                                                         
T26971         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T26971         DISPLAY '***************PCSCA119**************'          
T26971         DISPLAY '* 7161-FETCH-B1-LOC-OFC             *'          
T26971         DISPLAY '* ACCOUNT-NO = ' AT-ACCOUNT-NO                  
T26971         DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
T26971         DISPLAY '* PROGRAM ABENDING...               *'          
T26971         DISPLAY '***************PCSCA119**************'          
T26971         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T26971*                                                                 07680000
T26971 7161-EXIT.                                                       
T26971     EXIT.                                                        
T26971*                                                                 07710000
T26971****************************************************************  07440000
T26971* FETCHING C8-REGION  CURSOR                                   *  07450000
T26971****************************************************************  07460000
T26971 7162-FETCH-C8-REGION.                                            
T26971*                                                                 07480000
T26971     EXEC SQL                                                     
T26971        FETCH C8-REGION                                           
T26971         INTO :C8-DELINQ-VALUE                                    
T26971     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26971*                                                                 07540000
T26971     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T26971*                                                                 07540000
T26971     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T26971         NEXT SENTENCE                                            
T26971     ELSE                                                         
T26971         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T26971         DISPLAY '***************PCSCA119**************'          
T26971         DISPLAY '* 7162-FETCH-C8-REGION              *'          
T26971         DISPLAY '* ACCOUNT-NO = ' AT-ACCOUNT-NO                  
T26971         DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
T26971         DISPLAY '* PROGRAM ABENDING...               *'          
T26971         DISPLAY '***************PCSCA119**************'          
T26971         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T26971*                                                                 07680000
T26971 7162-EXIT.                                                       
T26971     EXIT.                                                        
T26971*                                                                 07710000
      ****************************************************************  07720000
T19976* CLOSING  BG-DET     CURSOR                                   *  07730000
      ****************************************************************  07740000
T19976 7170-CLOSE-BG-DET.                                               
      *                                                                 07760000
           EXEC SQL                                                     
T19976        CLOSE BG-DET                                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07800000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 07800000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SQLCODE                    TO WS-DISPLAY-RC         
               DISPLAY '***************PCSCA119**************'          
T19976         DISPLAY '* 7170-CLOSE-BG-DET                 *'          
T19976         DISPLAY '* ACCOUNT-NO = ' BG-ACCOUNT-NO                  
               DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
               DISPLAY '* PROGRAM ABENDING...               *'          
               DISPLAY '***************PCSCA119**************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
      *                                                                 07940000
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07710000
T26971****************************************************************  07720000
T26971* CLOSING B1-LOC-OFC  CURSOR                                   *  07730000
T26971****************************************************************  07740000
T26971 7171-CLOSE-B1-LOC-OFC.                                           
T26971*                                                                 07760000
T26971     EXEC SQL                                                     
T26971        CLOSE B1-LOC-OFC                                          
T26971     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26971*                                                                 07800000
T26971     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T26971*                                                                 07800000
T26971     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T26971         NEXT SENTENCE                                            
T26971     ELSE                                                         
T26971         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T26971         DISPLAY '***************PCSCA119**************'          
T26971         DISPLAY '* 7171-CLOSE-B1-LOC-OFC             *'          
T26971         DISPLAY '* ACCOUNT-NO = ' BG-ACCOUNT-NO                  
T26971         DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
T26971         DISPLAY '* PROGRAM ABENDING...               *'          
T26971         DISPLAY '***************PCSCA119**************'          
T26971         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T26971*                                                                 07940000
T26971 7171-EXIT.                                                       
T26971     EXIT.                                                        
      *                                                                 07970000
T26971****************************************************************  07720000
T26971* CLOSING C8-REGION   CURSOR                                   *  07730000
T26971****************************************************************  07740000
T26971 7172-CLOSE-C8-REGION.                                            
T26971*                                                                 07760000
T26971     EXEC SQL                                                     
T26971        CLOSE C8-REGION                                           
T26971     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26971*                                                                 07800000
T26971     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T26971*                                                                 07800000
T26971     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T26971         NEXT SENTENCE                                            
T26971     ELSE                                                         
T26971         MOVE SQLCODE                    TO WS-DISPLAY-RC         
T26971         DISPLAY '***************PCSCA119**************'          
T26971         DISPLAY '* 7172-CLOSE-C8-REGION              *'          
T26971         DISPLAY '* ACCOUNT-NO = ' BG-ACCOUNT-NO                  
T26971         DISPLAY '* SQLCODE   IS ', WS-DISPLAY-RC                 
T26971         DISPLAY '* PROGRAM ABENDING...               *'          
T26971         DISPLAY '***************PCSCA119**************'          
T26971         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
T26971*                                                                 07940000
T26971 7172-EXIT.                                                       
T26971     EXIT.                                                        
      *                                                                 07970000
T26971****************************************************************  07720000
T26971* CHECKING THE REG VS DEREG STATUS OF AN ACCOUNT               *  07730000
T26971****************************************************************  07740000
T26971 7180-CHECK-REG-DEREG.                                            
T26971*                                                                 07760000
T26971     IF C8-DELINQ-VALUE = 2                                       
T26971         IF B1-REGULATED-CD = '02'                                
T26971            MOVE ' REG ' TO  WS-REG-DEREG-LABEL                   
T26971         ELSE                                                     
T26971            MOVE 'DEREG' TO  WS-REG-DEREG-LABEL                   
T26971         END-IF                                                   
T26971     ELSE                                                         
T26971         MOVE ' REG ' TO  WS-REG-DEREG-LABEL                      
T26971     END-IF.                                                      
T26971*                                                                 07940000
T26971 7180-EXIT.                                                       
T26971     EXIT.                                                        
      *                                                                 07970000
      ****************************************************************          
      **                                                            **          
      **   7250-GET-COMPANY-DESC                                    **          
      **      READS THE COMPANY NAME WITH THE GIVEN CODE            **          
      **                                                            **          
      ****************************************************************          
       7250-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7250'                 TO WS-ACTIVE-PARAGRAPH.          
      *                                                                         
           EXEC SQL                                                     
               SELECT  COMPANY_NAME                                     
                 INTO :C7-COMPANY-NAME                                  
                 FROM  CSS_COMPANY WITH(READUNCOMMITTED)                        
                WHERE  COMPANY_NO = :C7-COMPANY-NO                      
A01958                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  COMPANY_NAME                                             
MFA-TR*          INTO :C7-COMPANY-NAME                                          
MFA-TR*          FROM  CSS_COMPANY                                              
MFA-TR*         WHERE  COMPANY_NO = :C7-COMPANY-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** SELECT ERROR IN 7250-GET-COMPANY-DESC **'    
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**         PROCESSING TERMINATED         **'    
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
END        EXIT.                                                        
C34569*                                                                 07970000
C34569****************************************************************          
C34569**                                                            **          
C34569**   7300-GET-OPTION-CD                                       **          
C34569**      GETS THE OPTION CODE AND OPTION DESCRIPTION           **          
C34569**                                                            **          
C34569****************************************************************          
C34569 7300-GET-OPTION-CD.                                              
C34569*                                                                         
C34569     MOVE '7300'                 TO WS-ACTIVE-PARAGRAPH.          
C34569*                                                                         
C34569     EXEC SQL                                                     
C34569         SELECT TOP(1) DF.OPTION_CD,
              FI.OPT_DESC_INT                                   
C34569           INTO :DF-OPTION-CD                                     
C34569               ,:FI-OPT-DESC-INT                                  
C34569           FROM CSS_ACCOUNT       AT WITH(READUNCOMMITTED)                
C34569               ,CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                
C34569               ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
C34569               ,CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
C34569          WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO             
C34569            AND UT.ACCOUNT_NO        = AT.ACCOUNT_NO              
C34569            AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE         
C34569            AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO              
C34569            AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE          
C34569            AND UT.IC_NO             = DF.IC_NO                   
C34569            AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO       
C34569            AND DF.OPTION_CD         = FI.OPTION_CD               
C34569            AND AT.COMPANY_NO        = FI.COMPANY_NO              
P00473            AND FI.OPT_VSTART_TS    <= CIS.CURRENT$TIMESTAMP()          
P00473            AND FI.OPT_VEND_TS      >= CIS.CURRENT$TIMESTAMP()          
P00473            AND FI.PROC_STATUS_CD    = 'AC'                       
C34569                                       
C34569     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DF.OPTION_CD                                              
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*          INTO :DF-OPTION-CD                                             
MFA-TR*              ,:FI-OPT-DESC-INT                                          
MFA-TR*          FROM CSS_ACCOUNT       AT                                      
MFA-TR*              ,CSS_UTIL_ENVRNMT  UT                                      
MFA-TR*              ,CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*              ,CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE AT.ACCOUNT_NO        = :AT-ACCOUNT-NO                     
MFA-TR*           AND UT.ACCOUNT_NO        = AT.ACCOUNT_NO                      
MFA-TR*           AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                 
MFA-TR*           AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                      
MFA-TR*           AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                  
MFA-TR*           AND UT.IC_NO             = DF.IC_NO                           
MFA-TR*           AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO               
MFA-TR*           AND DF.OPTION_CD         = FI.OPTION_CD                       
MFA-TR*           AND AT.COMPANY_NO        = FI.COMPANY_NO                      
MFA-TR*           AND FI.OPT_VSTART_TS    <= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.OPT_VEND_TS      >= CURRENT TIMESTAMP                  
MFA-TR*           AND FI.PROC_STATUS_CD    = 'AC'                               
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34569*                                                                         
C34569     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C34569*                                                                         
C34569     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C34569         CONTINUE                                                 
C34569     ELSE                                                         
C34569         DISPLAY '** SELECT ERROR IN 7300-GET-OPTION-CD    **'    
C34569         DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE     
C34569         DISPLAY '** ACCOUNT_NO     = ' AT-ACCOUNT-NO             
C34569         DISPLAY '** CODE_UTIL_TYPE = ' UT-CODE-UTIL-TYPE         
C34569         DISPLAY '**         PROCESSING TERMINATED         **'    
C34569         PERFORM 9900-ABEND            THRU 9900-EXIT             
C34569     END-IF.                                                      
C34569*                                                                         
C34569 7300-EXIT.                                                       
C34569     EXIT.                                                        
T20761*                                                                         
A01958******************************************************************        
A01958*     7400-OPEN-WQ-INFO-CUR-PARA                                 *        
A01958*     OPENS THE CSR FOR CSS_WQ_ITEMS                             *        
A01958******************************************************************        
A01958 7400-OPEN-WQ-INFO-CUR-PARA.                                      
A01958*                                                                         
A01958     EXEC SQL                                                     
A01958         OPEN WQ-INFO-CSR                                         
A01958     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01958*                                                                         
A01958     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01958                                                                  
A01958     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01958         NEXT SENTENCE                                            
A01958     ELSE                                                         
A01958        DISPLAY '** SELECT ERROR IN 7400-OPEN-WQ-INFO-CUR-PARA'   
A01958        DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
ACT112        DISPLAY '** ACCOUNT_NO     = '  WQ-ACCOUNT-NO             
A01958        DISPLAY '**         PROCESSING TERMINATED         **'     
A01958        PERFORM 9900-ABEND            THRU 9900-EXIT              
A01958     END-IF.                                                      
A01958*                                                                         
A01958 7400-EXIT.                                                       
A01958     EXIT.                                                        
A01958*                                                                         
A01958******************************************************************        
A01958*     7500-FETCH-WQ-INFO-CUR-PARA                                *        
A01958*     FETCHES THE CSR FOR CSS_WQ_ITEMS                           *        
A01958******************************************************************        
A01958 7500-FETCH-WQ-INFO-CUR-PARA.                                     
A01958                                                                  
A01958     EXEC SQL                                                     
A01958         FETCH WQ-INFO-CSR                                        
A01958         INTO                                                     
ACT112               :WQ-COMMENTS                                       
A01958     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01958*                                                                         
A01958     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01958                                                                  
A01958     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01958        CONTINUE                                                  
A01958     ELSE                                                         
A01958        DISPLAY '** SELECT ERROR IN 7500-FETCH-WQ-INFO-CUR-PARA'  
A01958        DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
ACT112        DISPLAY '** ACCOUNT_NO     = '  WQ-ACCOUNT-NO             
A01958        DISPLAY '**         PROCESSING TERMINATED         **'     
A01958        PERFORM 9900-ABEND            THRU 9900-EXIT              
A01958     END-IF.                                                      
A01958*                                                                         
A01958 7500-EXIT.                                                       
A01958     EXIT.                                                        
A01958*                                                                         
A01958******************************************************************        
A01958*     7630-CLOSE-WQ-INFO-CUR-PARA                                *        
A01958*     CLOSES THE CSR FOR CSS_WQ_ITEMS                            *        
A01958******************************************************************        
A01958 7630-CLOSE-WQ-INFO-CUR-PARA.                                     
A01958*                                                                         
A01958     EXEC SQL                                                     
A01958         CLOSE WQ-INFO-CSR                                        
A01958     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01958*                                                                         
A01958     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01958                                                                  
A01958     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A01958         NEXT SENTENCE                                            
A01958     ELSE                                                         
A01958        DISPLAY '** SELECT ERROR IN 7630-CLOSE-WQ-INFO-CUR-PARA'  
A01958        DISPLAY '** RETURN CODE    = ' WS-ACTIVE-RETURN-CODE      
ACT112        DISPLAY '** ACCOUNT_NO     = '  WQ-ACCOUNT-NO             
A01958        DISPLAY '**         PROCESSING TERMINATED         **'     
A01958        PERFORM 9900-ABEND            THRU 9900-EXIT              
A01958     END-IF.                                                      
A01958*                                                                         
A01958 7630-EXIT.                                                       
A01958     EXIT.                                                        
A01958*                                                                         
      ****************************************************************          
      **                                                            **          
      **       8150-PRINT-COMP-NAME                                 **          
      **       PRINTS THE COMPANY NAME FOR THE REPORT               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8150-PRINT-COMP-NAME.                                            
      *                                                                         
           ADD 1                             TO WS-RPT1-PAGE-NO.        
           MOVE WS-PGRMNAME                  TO P-RPT1-TITLE-PGNM.      
T20761     MOVE WS-DEFAULT-COMPANY-NO        TO C7-COMPANY-NO.          
T20761     PERFORM 7250-GET-COMPANY-DESC THRU 7250-EXIT.                
T20761     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T20761         MOVE C7-COMPANY-NAME          TO P-RPT1-COMP-NAME        
T20761     ELSE                                                         
T20761         MOVE WS-DEFAULT-RPT1-COMPANY  TO P-RPT1-COMP-NAME        
T20761     END-IF.                                                      
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
      *                                                                         
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8200-PRINT-TITLE                                         **          
      **       PRINTS THE TITLE OF THE REPORT                       **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8200-PRINT-TITLE.                                                
      *                                                                         
T20337     IF  PARM-RUN-TYPE = 'INDUSTRIAL'                             
T20337         MOVE WS-DEFAULT-RPT2-HEADER1                             
T20337                                 TO P-RPT2-HEAD1                  
T20337         MOVE WS-DEFAULT-RPT1-HEADER1                             
T20337                                 TO P-RPT2-HEAD2                  
T20337         WRITE PRT33-RECORD FROM WS-RPT2-HEADER-1                 
T20337           AFTER ADVANCING 1 LINE                                 
T20337     ELSE                                                         
T20337         MOVE WS-DEFAULT-RPT1-HEADER1                             
T20337                                 TO P-RPT1-HEAD1                  
T20337         WRITE PRT33-RECORD FROM WS-RPT1-HEADER-1                 
T20337           AFTER ADVANCING 1 LINE                                 
T20337     END-IF.                                                      
      *                                                                         
A01958     ADD 1                             TO WS-RPT1-PAGE-NO.        
           MOVE WS-RPT1-PAGE-NO              TO P-RPT1-PAGE-NO.         
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
           MOVE 3                      TO WS-RPT1-LINE-NO.              
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8300-PRINT-COLUMN-HEADERS                                **          
      **       PRINTS THE COLUMN HEADERS FOR THE REPORT             **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8300-PRINT-COLUMN-HEADERS.                                       
      *                                                                         
C34569     IF C8-DELINQ-VALUE = 2                                       
C34569        WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-1-SEB       
C34569              AFTER ADVANCING 2 LINES                             
C34569        WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-2-SEB       
C34569              AFTER ADVANCING 2 LINES                             
C34569        ADD 1                    TO WS-RPT1-LINE-NO               
C34569     ELSE                                                         
C34569        WRITE PRT33-RECORD FROM WS-RPT1-COLUMN-HEADER-1           
C34569              AFTER ADVANCING 2 LINES                             
C34569     END-IF                                                       
C34569*                                                                         
           WRITE PRT33-RECORD FROM WS-LINE                              
                 AFTER ADVANCING 1 LINE.                                
      *                                                                         
T19976     ADD 3                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   8900-PRINT-DETAIL-LINE                                   **          
      **       PRINTS THE DETAIL LINE OF THE REPORT                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       8900-PRINT-DETAIL-LINE.                                          
      *                                                                         
C34569     IF C8-DELINQ-VALUE = 2                                       
C34569        MOVE SPACES                TO DF-OPTION-CD                
C34569                                      FI-OPT-DESC-INT             
C34569        MOVE BG-CODE-UTIL-TYPE     TO UT-CODE-UTIL-TYPE           
C34569                                                                  
C34569        PERFORM 7300-GET-OPTION-CD       THRU 7300-EXIT           
C34569                                                                  
C34569        MOVE DF-OPTION-CD          TO P-OPTION-CD3                
C34569        MOVE FI-OPT-DESC-INT       TO P-OPTION-DESC-INT3          
C34569                                                                  
C34569        WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-2             
C34569              AFTER ADVANCING 1 LINE                              
C34569                                                                  
C34569        WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-3-SEB         
C34569              AFTER ADVANCING 1 LINE                              
C34569                                                                  
C34569        ADD 1                      TO WS-RPT1-LINE-NO             
C34569                                                                  
C34569     ELSE                                                         
C34569        WRITE PRT33-RECORD FROM WS-RPT1-DETAIL-LINE-2             
C34569              AFTER ADVANCING 1 LINE                              
C34569     END-IF                                                       
      *                                                                         
           ADD 1                       TO WS-RPT1-LINE-NO.              
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A01958****************************************************************          
A01958**   8920-PROCESS-WQ-INFO-PARA                                **          
A01958**       GET THEN WORK QUEUE INFORM FOR THE REPORT            **          
A01958****************************************************************          
A01958*                                                                         
A01958 8920-PROCESS-WQ-INFO-PARA.                                       
A01958*                                                                         
A01958     PERFORM 7400-OPEN-WQ-INFO-CUR-PARA THRU 7400-EXIT.           
ACT112     MOVE SPACES                    TO WQ-COMMENTS-TEXT.          
ACT112     MOVE 115                       TO WQ-COMMENTS-LEN.           
A01958     PERFORM 7500-FETCH-WQ-INFO-CUR-PARA THRU 7500-EXIT.          
A01958     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT112        MOVE WQ-COMMENTS-TEXT             TO P-WQ-MESSAGE         
ACT112        MOVE WQ-ACCOUNT-NO                TO P3-ACCOUNT-NO        
A01958        PERFORM 2500-PROC-WQ-INFO-CUR-PARA THRU 2500-EXIT         
A01958             UNTIL WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND         
A01958     END-IF.                                                      
A01958     PERFORM 7630-CLOSE-WQ-INFO-CUR-PARA THRU 7630-EXIT.          
A01958*                                                                         
A01958 8920-EXIT.                                                       
A01958     EXIT.                                                        
A01958*                                                                         
      ******************************************************************        
      *    BYPASS ONLINE ERROR PROCESSING                                       
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   9000-TERMINATE                                           **          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSSF95-FILE.                                          
           IF FCSSF95-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**         PCSCA119 PROCESSING ERROR        **' 
               DISPLAY '**  CLOSE ERROR FOR FCSSF95 - INPUT FILE    **' 
               DISPLAY '**       FILE STATUS = ' WS-FCSSF95-STATUS      
           END-IF.                                                      
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
ACT130     EXEC SQL                                                     
ACT112         DELETE FROM CSS_WQ_ITEMS                                 
ACT130     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT130     IF SQLCODE NOT = 0                                           
ACT130         DISPLAY '**********************************************' 
ACT130         DISPLAY 'PCSCA119 - WARNING - SQL ERROR DELETING WQ IN ' 
ACT130         DISPLAY '           PARAGRAPH P9000-TERMINATE.         ' 
ACT130         DISPLAY 'SQLCODE = ' SQLCODE                             
ACT130         DISPLAY '**********************************************' 
ACT130         MOVE 5 TO RETURN-CODE                                    
ACT130     END-IF.                                                      
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    ABEND ROUTINE                                                        
      ******************************************************************        
       9900-SQL-ERROR-ROUTINE.                                          
      *************************************************************             
      * ABEND ROUTINE PERFORMED IF VSAM OR DB2 PROBLEM OCCURS.    *             
      * 9900-ABEND                                                *             
      *************************************************************             
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************  ****    
