       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA118.                                          
       AUTHOR.       COVANSYS.                                          
       DATE-WRITTEN. OCT 2009.                                          
       DATE-COMPILED.                                                   
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **  THIS PROGRAM FINDS THE BILLS THAT ARE HANGING IN PRINT      **        
      **  STATUS AND WHICH ARE DIVERTED FROM INSERTING MACHINE WRITES **        
      **  THEM OUT TO A FILE.                                         **        
      **                                                              **        
      **  THIS PROGRAM TAKES DETAILS FROM CSS_CORR_MAIL_STAT TABLE    **        
      **  BASED ON CREATE DATE AND CHECKS FOR SPECIFIC CODES AND      **        
      **  FINALLY WRITES TO OUTPUT FILE FCSCA118                      **        
      **                                                              **        
      **  CREATE DATE IS TAKEN FROM COMMON DATE IN CSS_JOB_PARM       **        
      **                                                              **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** -------  -------  ------                                     **        
PRJ166** 10/2009  COVANSYS INITIAL IMPLEMENTATION.                    **        
PRJ166** 01/2009  SV82012  ADD SEB MARKETING LETTERS AND NOTICES      **        
A04444** 01/2013  RAJ      PRINT CONSOLIDATED WITH GROUP 5.           **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
      *--------------------*                                                    
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSCA118.                                                           
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA118.                                                           
       COPY FIOCA118.                                                           
                                                                        
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-CORR-MAIL-CSR  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA118'.
MSQ017     COPY MFASQLM.
      *-----------------------*                                                 
      *                                                                         
       01  WS-START                     PIC X(40)         VALUE         
                        'WORKING STORAGE FOR PCSCA118 STARTS HERE'.     
       01  WS-MISC.                                                     
           05  WS-Y                     PIC X(01)         VALUE 'Y'.    
           05  WS-N                     PIC X(01)         VALUE 'N'.    
           05  WS-FCA118-STATUS         PIC XX            VALUE '  '.   
              88  FIOCA118-SUCCESSFUL                     VALUE '00'.   
           05  WS-FCA118-WRITE-COUNT    PIC 9(7)          VALUE ZEROS.  
           05  WS-CORR-ROW-COUNT        PIC S9(7)  COMP-3 VALUE +0.     
           05  WS-NUM-COND              PIC S9(7)  COMP-3 VALUE +0.     
           05  WS-INDEX                 PIC S9(04) COMP-3 VALUE +0.     
           05  WS-ACCOUNT               PIC X(13)         VALUE SPACES. 
           05  WS-ACCOUNT-NO REDEFINES  WS-ACCOUNT                      
                                        PIC 9(13).                      
           05  WS-COMMON-DATE           PIC X(10)         VALUE SPACES. 
                                                                        
       01  WS-MISC-HOST-VARIABLES.                                      
           05 WS-CSR-ACCOUNT-NO         PIC S9(13)V USAGE COMP-3        
                                         OCCURS 150 TIMES VALUE ZEROS.  
           05 WS-CSR-BARCODE-UNIQUE-ID  PIC X(9)  OCCURS 150 TIMES      
                                                          VALUE SPACES. 
           05 WS-CSR-COMM-TYPE-CODE     PIC X(2)  OCCURS 150 TIMES      
                                                          VALUE SPACES. 
           05 WS-CSR-TRACKING-STATUS-CD PIC X(2)  OCCURS 150 TIMES      
                                                          VALUE SPACES. 
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME              PIC  X(08)        VALUE         
                                                          'PCSCA118'.   
           05  PROGRAM-NAME             PIC  X(08)        VALUE         
                                                          'PCSCA118'.   
                                                                        
       01  WS-JOB-PARM-DATA.                                            
           05  WS-RUN-DATE-MSG          PIC  X(09)        VALUE         
                                                          'RUN DATE='.  
           05  WS-RUN-DATE              PIC  X(10).                     
           05  FILLER                   PIC  X(61).                     
      *                                                                         
       COPY FIOCA00.                                                            
      ******************************************************************03552000
      *  COPYBOOK FOR VARIABLES TO RETRIEVE DATE FROM JOB PARM         *01560000
      ******************************************************************03552000
       COPY FIOJC01.                                                    01582000
      *                                                                 03552500
      * ERROR MESSAGE COPYBOOK.                                                 
      *-----------------------*                                                 
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      **************WORKING STORAGE OF CPD00038***********************          
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
      *                                                                         
      **************WORKING STORAGE OF CPD00039***********************          
           EXEC SQL                                                             
             INCLUDE CWS00039                                                   
           END-EXEC.                                                            
      *                                                                         
      * DB2 INCLUDES.                                                           
      *                                                                         
      ******************************************************************        
      *    SQLCA                                                       *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT (AT)                                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CORR_MAIL_STAT (MW)                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMAILST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM (G6)                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      * DB2 CURSORS.                                                            
      *------------*                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR TO GET DETAILS FROM CSS_CORR_MAIL_STAT               *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE CORR-MAIL-CSR CURSOR WITH ROWSET POSITIONING FOR  
               SELECT  MW.ACCOUNT_NO                                    
                      ,MW.BARCODE_UNIQUE_ID                             
                      ,MW.COMM_TYPE_CODE                                
                      ,MW.TRACKING_STATUS_CD                            
                 FROM  CSS_CORR_MAIL_STAT MW WITH(READUNCOMMITTED)              
                WHERE MW.CREATE_DT        = IIF(TRY_CONVERT(DATE, 
                                                          :MW-CREATE-DT
              ) IS NULL OR (PATINDEX('%.%', :MW-CREATE-DT
              ) <> 0) OR (LEN(:MW-CREATE-DT) <> 10), CIS.CHAR2DATE(
                                                          :MW-CREATE-DT
              ), CONVERT(DATE, :MW-CREATE-DT) )               
                  AND MW.TRACKING_STATUS_CD IN                          
PRJ166                ('PN','PO','PT','PL','PA','PM',                   
PRJ166                 'DN','DO','DT','DL','DA','DM')                   
                  FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CORR-MAIL-CSR CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*        SELECT  MW.ACCOUNT_NO                                            
MFA-TR*               ,MW.BARCODE_UNIQUE_ID                                     
MFA-TR*               ,MW.COMM_TYPE_CODE                                        
MFA-TR*               ,MW.TRACKING_STATUS_CD                                    
MFA-TR*          FROM  CSS_CORR_MAIL_STAT MW                                    
MFA-TR*         WHERE MW.CREATE_DT        = :MW-CREATE-DT                       
MFA-TR*           AND MW.TRACKING_STATUS_CD IN                                  
MFA-TR*               ('PN','PO','PT','PL','PA','PM',                           
MFA-TR*                'DN','DO','DT','DL','DA','DM')                           
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       01  WS-END                          PIC X(40)      VALUE         
                       'WORKING STORAGE FOR PCSCA118 ENDS HERE  '.      
                                                                        
       PROCEDURE DIVISION.                                              
      *------------------*                                                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
           PERFORM  0100-INITIALIZATION         THRU  0100-EXIT.        
           PERFORM  1000-PROCESS-INPUT          THRU  1000-EXIT.        
           PERFORM  2000-PROCESS-OUTPUT         THRU  2000-EXIT.        
           PERFORM  9000-TERMINATE              THRU  9000-EXIT.        
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      * INITIALIZE FIELDS FOR PROCESSING                               *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT FCSCA118-FILE.                                   
           IF NOT FIOCA118-SUCCESSFUL                                   
              DISPLAY '********** PCSCA118 ABORT  ************'         
              DISPLAY '**  0100-INITIALIZATION               *'         
              DISPLAY '**  ERROR OPENING FCSCA118            *'         
              DISPLAY '**  FILE STATUS = ' WS-FCA118-STATUS             
              DISPLAY '********** PCSCA118 ABORT  ************'         
              MOVE 12                TO RETURN-CODE                     
              PERFORM 9900-ABEND     THRU 9900-EXIT                     
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      * PROCESS INPUT                                                  *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT.           
           MOVE WS-FCA00-COMMON-DATE          TO WS-COMMON-DATE.        
           DISPLAY '*COMMON DATE ' WS-COMMON-DATE.                      
                                                                        
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           MOVE WS-INPUT-RUN-DATE      TO MW-CREATE-DT.                 
           DISPLAY '*RUN DATE ' MW-CREATE-DT.                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      * PERFORMS OUTPUT PROCESS                                        *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-OPEN-CORR-MAIL-CSR  THRU 7000-EXIT.             
           PERFORM 7100-FETCH-CORR-MAIL-CSR THRU 7100-EXIT              
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.            
           PERFORM 7200-CLOSE-CORR-MAIL-CSR THRU 7200-EXIT .            
           PERFORM 8100-UPDATE-DATE THRU 8100-EXIT.                     
           DISPLAY '*TOTAL NUMBER OF RECORDS WRITTEN '                  
                                                 WS-FCA118-WRITE-COUNT. 
           DISPLAY '*PCSCA118 SUCCESSFULLY COMPLETED*'.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-CURSOR                                            *        
      * PERFORMS FETCH AND WRITES DATA TO OUTPUT FILE                  *        
      ******************************************************************        
       2100-PROCESS-CURSOR.                                             
                                                                        
           INITIALIZE  FIOCA118                                         
                       WS-ACCOUNT.                                      
                                                                        
           MOVE WS-CSR-ACCOUNT-NO(WS-INDEX)         TO WS-ACCOUNT-NO.   
           MOVE WS-ACCOUNT                          TO                  
                                              E-CA118-ACCOUNT-NO.       
           MOVE WS-CSR-BARCODE-UNIQUE-ID(WS-INDEX)  TO                  
                                              E-CA118-BARCODE-UNIQUE-ID.
           MOVE WS-CSR-COMM-TYPE-CODE(WS-INDEX)     TO                  
                                              E-CA118-COMM-TYPE-CODE.   
           MOVE WS-CSR-TRACKING-STATUS-CD(WS-INDEX) TO                  
                                             E-CA118-TRACKING-STATUS-CD.
           PERFORM 8000-WRITE-FIOCA118              THRU 8000-EXIT.     
           ADD 1           TO WS-INDEX.                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6240-GET-FCA00-COMMON-DATE                                     *        
      * GET COMMONDATE FROM JOBPARM                                    *        
      ******************************************************************        
       COPY CPD00040.                                                           
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-CORR-MAIL-CSR                                        *        
      * OPENS CORR-MAIL-CSR CURSOR                                     *        
      ******************************************************************        
       7000-OPEN-CORR-MAIL-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN CORR-MAIL-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO   WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA118 ABORT  ************'         
              DISPLAY '* 7000-OPEN-CORR-MAIL-CSR             *'         
              DISPLAY '* CREATE_DT    = ' MW-CREATE-DT                  
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA118  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-CORR-MAIL-CSR                                       *        
      * FETCH CORR-MAIL-CSR CURSOR                                     *        
      ******************************************************************        
       7100-FETCH-CORR-MAIL-CSR.                                        
           INITIALIZE WS-MISC-HOST-VARIABLES.                           

MSQ008     MOVE 150 TO MSQ008-CORR-MAIL-CSR
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-CORR-MAIL-CSR
              FETCH 
              FROM CORR-MAIL-CSR        
                 INTO                                                   
                      :WS-CSR-ACCOUNT-NO                                
                     ,:WS-CSR-BARCODE-UNIQUE-ID                         
                     ,:WS-CSR-COMM-TYPE-CODE                            
                     ,:WS-CSR-TRACKING-STATUS-CD                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*         FETCH NEXT ROWSET FROM CORR-MAIL-CSR FOR 150 ROWS               
MFA-TR*          INTO                                                           
MFA-TR*               :WS-CSR-ACCOUNT-NO                                        
MFA-TR*              ,:WS-CSR-BARCODE-UNIQUE-ID                                 
MFA-TR*              ,:WS-CSR-COMM-TYPE-CODE                                    
MFA-TR*              ,:WS-CSR-TRACKING-STATUS-CD                                
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-CORR-MAIL-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO                      
                                                WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                                                        
              IF  SQLERRD(3) >= 1                                       
                  MOVE SQLERRD (3)              TO WS-CORR-ROW-COUNT    
                  MOVE  1                       TO  WS-INDEX            
                  PERFORM 2100-PROCESS-CURSOR   THRU 2100-EXIT          
                            UNTIL WS-INDEX > WS-CORR-ROW-COUNT          
              ELSE                                                      
                  DISPLAY '* RECORD(S) NOT FOUND *'                     
              END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = +354                           
                  EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =              
                             ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
                  END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                                      
MFA-TR*               GET DIAGNOSTICS :WS-CORR-ROW-COUNT =                      
MFA-TR*                      ROW_COUNT                                          
MFA-TR*                     ,:WS-NUM-COND = NUMBER                              
MFA-TR*           END-EXEC                                                      
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-CORR-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
                  DISPLAY '********** PCSCA118 ABORT  ************'     
                  DISPLAY '* 7100-FETCH-CORR-MAIL-CSR            *'     
                  DISPLAY '* CREATE_DT    = ' MW-CREATE-DT              
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* ROWCOUNT ' SQLERRD(3)                      
                  DISPLAY '* NUM_COND '  WS-NUM-COND                    
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSCA118  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              ELSE                                                      
                  DISPLAY '********** PCSCA118 ABORT  ************'     
                  DISPLAY '* 7100-FETCH-CORR-MAIL-CSR            *'     
                  DISPLAY '* CREATE_DT    = ' MW-CREATE-DT              
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                 *'     
                  DISPLAY '********** PCSCA118  ABORT ************'     
                  PERFORM 9900-ABEND            THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-CORR-MAIL-CSR                                       *        
      * CLOSE CORR-MAIL-CSR CURSOR                                     *        
      ******************************************************************        
       7200-CLOSE-CORR-MAIL-CSR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE CORR-MAIL-CSR                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO   WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '********** PCSCA118 ABORT  ************'         
              DISPLAY '* 7200-CLOSE-CORR-MAIL-CSR            *'         
              DISPLAY '* CREATE_DT    = ' MW-CREATE-DT                  
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA118  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-UPDATE-DATE                                               *        
      * UPDATE CSS_JOB_PARM WITH THE COMMON DATE                       *        
      ******************************************************************        
       8100-UPDATE-DATE.                                                
                                                                        
           MOVE WS-COMMON-DATE           TO WS-RUN-DATE.                
           MOVE WS-JOB-PARM-DATA         TO G6-PARM-DATA.               
           MOVE WS-PGRMNAME              TO G6-PROGRAM-NAME.            
           MOVE 'DATE'                   TO G6-CMND-CODE.               
           MOVE '01'                     TO G6-COMPANY-NO.              
           MOVE 1                        TO G6-SEQ-NO.                  
      *                                                                         
           EXEC SQL                                                     
               UPDATE   CSS_JOB_PARM                                    
                  SET   PARM_DATA        = :G6-PARM-DATA                
                WHERE   PROGRAM_NAME     = :G6-PROGRAM-NAME             
                  AND   CMND_CODE        = :G6-CMND-CODE                
                  AND   COMPANY_NO       = :G6-COMPANY-NO               
                  AND   SEQ_NO           = :G6-SEQ-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO   WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '********** PCSCA118 ABORT  ************'         
              DISPLAY '* 8100-UPDATE-DATE                    *'         
              DISPLAY '* PARM_DATA = ' WS-JOB-PARM-DATA                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                 *'         
              DISPLAY '********** PCSCA118  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 6251-GET-FJC01-DATE                                            *        
      * GET RUN DATE FROM JOBPARM                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7600-START-FCSJC01                                             *        
      * START FCSJC01 FILE                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7620-START-FCSCA00                                             *        
      * COMMON DATE RETRIEVE LOGIC                                     *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8000-WRITE-FIOCA118                                            *        
      * WRITES OUTPUT FILE                                             *        
      ******************************************************************        
       8000-WRITE-FIOCA118.                                             
                                                                        
           WRITE FIOCA118.                                              
           ADD 1                   TO WS-FCA118-WRITE-COUNT.            
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9000-TERMINATE                                                 *        
      * PROGRAM TERMINATION                                            *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSCA118-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
      ********************** END OF THE PROGRAM ************************        
