       IDENTIFICATION  DIVISION.                                        
       PROGRAM-ID.     PCSCA117.                                        
       DATE-WRITTEN.   NOV 1997.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC AND GAS                **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **                  CUSTOMER INFORMATION SYSTEM                **         
      *****************************************************************         
      **                  P R O G R A M S U M M A R Y                **         
      **                                                             **         
      **                                                             **         
      **             F U N C T I O N A L   D E S C R I P T I O N     **         
      **                             O F   M O D U L E               **         
      **                                                             **         
      **  PURPOSE :                                                  **         
      **                                                             **         
      **  THIS BATCH PROGRAM WILL PROCESS ACCOUNTS WHOSE LOCAL OFFICE**         
      **  HAS BEEN CHANGED VIA PANEL 077.  WHEN THE LOCAL OFFICE IS  **         
      **  CHANGED ON PANEL 077, CSS_PREMISE WILL BE THE ONLY TABLE   **         
      **  UPDATED.  THIS PROGRAM WILL THEN EXECUTE DURING THE NIGHTLY**         
      **  BATCH FLOW.  ANY ACCOUNTS WHICH DO NOT HAVE THE SAME LOCAL **         
      **  OFFICE ON CSS_ACCOUNT AND CSS_PREMISE WILL BE PROCESSED.   **         
      **  JOURNALLING, TRANSACTION HISTORY AND TABLE UPDATES WILL BE **         
      **  COMPLETED FOR THIS ACCOUNT.                                **         
      **                                                             **         
      **  LOGIC :                                                    **         
      **                                                             **         
      **  THE DRIVING CURSOR FOR THIS PROGRAM SELECTS ACCOUNTS FROM  **         
      **  CSS_PREMISE AND CSS_ACCOUNT WHICH DO NOT HAVE              **         
      **  CORRESPONDING LOCAL OFFICES.                               **         
      **                                                             **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS REASON                                  **         
      **   ________ ________ ______                                  **         
T24646**   08/13/01 SS19371  EXPLICIT ASSIGNMENT TO "DO" TO PREVENT  **         
      **                     BIND ERROR FROM USING RESEREVED WORD    **         
      **                     AND ADDED COLON BEFORE HOST VARIABLE    **         
T26323**   09/19/02 VIJAY    UPDATE LOCAL_OFFICE IN CSS_NAME_ACCT_XREF*         
      **                     FROM PREMISE.                           **         
C36956**   11/14/08 SK42147  CHANGE EPP TP BBP.                      **         
ACT046**   02/28/11 VIJAY  1.FIX SQL CODE 100 IN GETTING             **         
      **   A03082            WRT_OFF_GL_ACCT_NO.                     **         
      **                   2.CORRECTED ABEND DISPLAYS                **         
      **                   2.ADDED WITH UR                           **         
ACT112**   06/01/11  MC95456 SKIP PROCESSING OF THE ACCOUNT WHEN     **         
ACT112**   A03082            LOCAL OFFICE IS BALNK.                  **         
P00778**   10/11/13  AS7C117 CREATE A NEW CURSOR FOR SEB.            **         
P00778**                                                             **         
      **                                                             **         
ACT012**  2 JAN 2015 RF10596 SEB ONLY - CHECK CSS_REG_PROFILE.       **         
ACT012**  APPL - 05136       UPDATE CSS_PREMISE INSTEAD OF           **         
ACT012**                     CSS_ACCOUNT FOR LOCAL-OFFICE SOMETIMES  **         
      **                                                             **         
ACT112**  04/15/16   MS7M727 TO REMOVE CSS_WQ_ITEMS_MF TABLE         **         
      **             A04860                                          **         
      **                                                             **         
A05460** 13 JUL 2016 RF10596 SEB ONLY - CORRECT LOCAL OFFICE         **         
      **                                                             **         
A05460** 17 AUG 2016 DB41297 ADD UPDATE TO CSS_SO_DATA               **         
ACT257**                                                             **         
ACT389** 20 DEC 2016 TP7R341 ADD COMMIT LOGIC                        **         
ACT389**                                                             **         
      *****************************************************************         
           REMARKS.                                                     
             AS ABOVE.                                                  
                     - BASIC BATCH SEQUENCE STRUCTURE -                 
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
ACT112* COPY BOOK FOR REPORT FILE                                               
ACT112 COPY CSSPT331.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
ACT112* COPY BOOK FOR REPORT FILE                                               
ACT112 FD  FCSPT331-FILE                                                
ACT112     BLOCK CONTAINS 0 RECORDS                                     
ACT112     RECORDING MODE IS F                                          
ACT112     LABEL RECORDS ARE STANDARD.                                  
ACT112 01  PRT331-RECORD                       PIC X(100).              
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA117'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-PROGRAM-NAME-AREA.                                        
           05  PROGRAM-NAME                  PIC X(08) VALUE 'PCSCA117'.
           05  WS-PGRMNAME                   PIC X(08) VALUE 'PCSCA117'.
           05  FILLER                        PIC X(15) VALUE            
                                                      'WORKING STORAGE'.
      *                                                                         
ACT112 01  WS-SKIP-HEADER-REC.                                          
ACT112     05  FILLER             PIC X(02) VALUE SPACES.               
ACT112     05  FILLER             PIC X(10) VALUE 'ACCOUNT NO'.         
ACT112     05  FILLER             PIC X(06) VALUE SPACES.               
ACT112     05  FILLER             PIC X(11) VALUE 'CUSTOMER NO'.        
ACT112     05  FILLER             PIC X(05) VALUE SPACES.               
ACT112     05  FILLER             PIC X(10) VALUE 'PREMISE NO'.         
      *                                                                         
ACT112 01  WS-SKIP-DETAIL-REC.                                          
ACT112     05  WS-SKIP-ACCT-NO    PIC 9(13) VALUE ZEROS.                
ACT112     05  WS-FILLER          PIC X(05) VALUE SPACES.               
ACT112     05  WS-SKIP-CUST-NO    PIC 9(10) VALUE ZEROS.                
ACT112     05  WS-FILLER          PIC X(06) VALUE SPACES.               
ACT112     05  WS-SKIP-PREM-NO    PIC 9(10) VALUE ZEROS.                
      *                                                                         
      *****************************************************************         
      **  DCLGENS FOR THIS PROGRAM                                   **         
      *****************************************************************         
      *                                                                         
      ***********************************                                       
      ** CSS_ACCOUNT DCLGEN            **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_AR_CNTL DCLGEN            **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_AR_TYPE DCLGEN            **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBARTYPE                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_BCH_JRNL_CNTL DCLGEN      **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBBJCNTL                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_BATCH_JRNL DCLGEN         **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBBTJRNL                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_CHRG_OFF DCLGEN           **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBCHGOFF                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_CUSTOMER DCLGEN           **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_DEP_ON_HAND DCLGEN        **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_GL_ACCT_NO DCLGEN         **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_MNT_TRANS_HIST DCLGEN     **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_MT_TRN_HST_DET DCLGEN     **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_MISC_JRNL DCLGEN          **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBMSJRNL                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_PENDING_XFER DCLGEN       **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBPENXFR                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_PREMISE DCLGEN            **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_REFUND DCLGEN             **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
      ***********************************                                       
      ** CSS_SO_DATA_MF DCLGEN         **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBSODTMF                                                 
           END-EXEC.                                                            
ACT257***********************************                                       
ACT257** CSS_SO_DATA    DCLGEN         **                                       
ACT257***********************************                                       
ACT257     EXEC SQL                                                             
ACT257         INCLUDE TBSODAT                                                  
ACT257     END-EXEC.                                                            
      ***********************************                                       
      ** CSS_CNT_DETAIL DCLGEN         **                                       
      ***********************************                                       
           EXEC SQL                                                             
               INCLUDE TBCNTDET                                                 
           END-EXEC.                                                            
      *                                                                         
T26323***********************************                                       
T26323** CSS_NAME_ACCT_XREF            **                                       
T26323***********************************                                       
T26323     EXEC SQL                                                             
T26323         INCLUDE TBNMACTX                                                 
T26323     END-EXEC.                                                            
      *                                                                         
      ***********************************                                       
ACT012** CSS_REG_PROFILE - LR          **                                       
      ***********************************                                       
ACT012     EXEC SQL                                                             
ACT012         INCLUDE TBREGPRF                                                 
ACT012     END-EXEC.                                                            
      *                                                                         
P00778***************************************************************           
P00778*   DCLGEN COPYBOOK FOR CSS_DELINQUENCY                       *           
P00778***************************************************************           
P00778                                                                  
P00778     EXEC SQL                                                             
P00778        INCLUDE TBDELQ                                                    
P00778     END-EXEC.                                                            
P00778                                                                  
      *                                                                         
      ***********************************                                       
      ** INTERNAL TABLE USED FOR TO    **                                       
      ** DETERMINE THE PYMT PRIORITY   **                                       
      ***********************************                                       
       01  WS-PYMT-PRIORITY-DATA.                                       
           05  WS-PYMT-PRIORITY-REC            OCCURS 50 TIMES          
                  INDEXED BY WS-PRIORITY-INDX.                          
               10  WS-PYMT-PRIORITY-LVL        PIC X(05) VALUE SPACES.  
               10  WS-AR-TYPE-SHORT-DESC       PIC X(25) VALUE SPACES.  
      *                                                                         
      *****************************************************************         
      ** JOURNAL FORMAT FOR THIS PROGRAM                             **         
      *****************************************************************         
       COPY CJF00103.                                                           
      *                                                                         
      *****************************************************************         
      ** GENERAL WORKING STORAGE FOR THE PROGRAM                     **         
      *****************************************************************         
      *                                                                         
       01  WS-HOLD-VARIABLES.                                           
           05 WS-LOC-OFF-OLD               PIC X(03)  VALUE SPACES.     
           05 WS-LOC-OFF-NEW               PIC X(03)  VALUE SPACES.     
A05460     05 WS-LOC-OFF-BRK.                                           
A05460        07 WS-LOC-OFF-BRK1           PIC X      VALUE SPACES.     
A05460        07 WS-LOC-OFF-BRK2           PIC XX     VALUE SPACES.     
           05 WS-LOCAL-OFFICE              PIC X(03)  VALUE SPACES.     
COB305     05 WS-HOLD-GL-MOVED        PIC S9(03)V9(04) COMP-3 VALUE 0.     
COB305     05 WS-HOLD-GL-BASE        PIC S9(03)V9(04) COMP-3 VALUE 0.     
COB305     05 WS-GL-OUT        PIC S9(03)V9(04) COMP-3 VALUE 0.     
COB305     05 WS-GL-IN        PIC S9(03)V9(04) COMP-3 VALUE 0.     
COB305     05 WS-JRNL-AMT        PIC S9(09)V99 COMP-3 VALUE 0.        
ACT112     05 WS-SKIP-ACCT-COUNT           PIC 9(04) VALUE 0.           
ACT389     05 WS-COMMIT-ACCTS-CNT          PIC 9(04) VALUE ZERO.        
      *                                                                         
       01  WS-SWITCHES.                                                 
ACT112     05  WS-FCA331-STATUS               PIC X(02).                
ACT112         88 FPT331-SUCCESSFUL           VALUE '00'.               
           05 WS-ACCT-EXISTS               PIC X(01)  VALUE 'N'.        
              88 ACCOUNT-PROCESSED                    VALUE 'Y'.        
           05 WS-ACCOUNT-TO-PROCESS        PIC X(01)  VALUE 'Y'.        
              88 NO-MORE-ACCOUNTS                     VALUE 'N'.        
           05 WS-NO-ARCNTL                 PIC X(01)  VALUE 'N'.        
              88 NO-MORE-ARCNTL                       VALUE 'Y'.        
           05 WS-NO-WRITEOFF               PIC X(01)  VALUE 'N'.        
              88 NO-MORE-WRITE-OFF                    VALUE 'Y'.        
           05 WS-NO-DEPOSIT                PIC X(01)  VALUE 'N'.        
              88 NO-MORE-DEPOSITS                     VALUE 'Y'.        
           05 WS-NO-PENDING-XFER           PIC X(01)  VALUE 'N'.        
              88 NO-MORE-PENDING-XFER                 VALUE 'Y'.        
           05 WS-PRIORITY-TYPE-DESC-SWITCH PIC X(01)  VALUE 'N'.        
              88 PRIORITY-DESC-NOT-FOUND              VALUE 'Y'.        
P00778     05  WS-DATABASE                 PIC 9(01)  VALUE ZERO.       
P00778         88  CSR-DATABASE                       VALUE 1.          
P00778         88  SEB-DATABASE                       VALUE 2.          
      *                                                                         
       01  WS-CONSTANTS.                                                
           05  WS-NUM-OF-ACCT-TYPES        PIC S9(09) VALUE 50.         
           05  WS-NULL                     PIC S9(01) VALUE -1.         
           05  WS-NOT-NULL                 PIC S9(01) VALUE ZERO.       
           05  WS-ONE                      PIC S9(01) VALUE +1.         
           05  WS-LOC-OFF-LEN              PIC S9(01) VALUE +3.         
           05  WS-TRAN-COMMENT-LEN         PIC S9(02) VALUE +19.        
           05  WS-CONTRACT-LVL             PIC 9(03) VALUE 100.         
           05  WS-103-JRNL-FMT             PIC 9(03) VALUE 103.         
      *                                                                         
       01  WS-LITERALS.                                                 
A05460     05  WS-FIVE                     PIC X     VALUE '5'.         
A05460     05  WS-ZERO                     PIC X     VALUE '0'.         
ACT012     05  WS-PREMISE-SW               PIC X     VALUE SPACES.      
ACT012     05  WS-REG-PROFILE-SW           PIC X     VALUE SPACES.      
ACT012     05  WS-N                        PIC X     VALUE 'N'.         
ACT012     05  WS-Y                        PIC X     VALUE 'Y'.         
           05  WS-NO                       PIC X(02) VALUE 'NO'.        
           05  WS-YES                      PIC X(03) VALUE 'YES'.       
           05  WS-WRITTEN-OFF              PIC X(01) VALUE 'S'.         
           05  WS-PENDING                  PIC X(01) VALUE 'P'.         
           05  WS-LOC-OFF-COLUMN           PIC X(12) VALUE              
                                                         'LOCAL OFFICE'.
           05  WS-LOCOFF-TABLE-ID          PIC X(02) VALUE 'B1'.        
           05  WS-TYPE-MNT                 PIC X(01) VALUE 'F'.         
           05  WS-TRAN-COMMENT             PIC X(19) VALUE              
                                                  'LOCAL OFFICE CHANGE'.
           05  WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
           05  WS-BATCH-DRAWER             PIC X(01) VALUE 'B'.         
           05  WS-ALPHA                    PIC X(01) VALUE 'A'.         
           05  WS-BETA                     PIC X(01) VALUE 'B'.         
           05  WS-A117                     PIC X(04) VALUE 'A117'.      
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-PRIORITY-DESC            PIC X(03) VALUE SPACES.      
           05  WS-TRANS-HIST-SEQ-NO        PIC X(26).                   
           05  WS-CUR-RUN-DATE-TIME.                                    
               10  WS-TRANS-DATE           PIC X(10).                   
               10  WS-TRANS-TIME           PIC X(16).                   
           05  WS-PRIORITY-LVL             PIC X(04).                   
           05  WS-NULL-DATE-TRANS          PIC S9(04) COMP VALUE ZERO.  
           05  WS-NULL-TRANS-HIST-SEQ-NO   PIC S9(04) COMP VALUE ZERO.  
           05  RS-RETURN-CODE              PIC S9(04) COMP.             
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-DISP-RETURN-CODE         PIC +Z(04).                  
ACT389     05  WS-CHKP-SEQ-NO              PIC 9(12) VALUE ZERO.        
                                                                        
       01  WS-JOURNAL-TOTALS.                                           
COB305     05 WS-AMOUNT-ENTERED        PIC S9(09)V99 COMP-3 VALUE 0.     
COB305     05 WS-SUM-00-DAY        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  WS-SUM-00-DAY-IND           PIC S9(04)       COMP.       
COB305     05 WS-SUM-30-DAY        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  WS-SUM-30-DAY-IND           PIC S9(04)       COMP.       
COB305     05 WS-SUM-60-DAY        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  WS-SUM-60-DAY-IND           PIC S9(04)       COMP.       
COB305     05 WS-SUM-90-DAY        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  WS-SUM-90-DAY-IND           PIC S9(04)       COMP.       
COB305     05 WS-SUM-UNUSED        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  WS-SUM-UNUSED-IND           PIC S9(04)       COMP.       
COB305     05 WS-SUM-TRAN-BAL        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  WS-SUM-TRAN-BAL-IND         PIC S9(04)       COMP.       
COB305     05 WS-SUM-AMT-TRANS        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  WS-SUM-AMT-TRANS-IND        PIC S9(04)       COMP.       
COB305     05 WS-SUM-AMT-DEPOSIT        PIC S9(09)V99 COMP-3 VALUE 0.     
           05  WS-SUM-AMT-DEPOSIT-IND      PIC S9(04)       COMP.       
                                                                        
       01  WS-PYM-PRIORITY.                                             
           05 WS-NSC                       PIC X(03) VALUE 'NSC'.       
           05 WS-NSA                       PIC X(03) VALUE 'NSA'.       
           05 WS-NSN                       PIC X(03) VALUE 'NSN'.       
           05 WS-LPC                       PIC X(03) VALUE 'LPC'.       
           05 WS-LPN                       PIC X(03) VALUE 'LPN'.       
           05 WS-UTE                       PIC X(03) VALUE 'UTE'.       
           05 WS-UTG                       PIC X(03) VALUE 'UTG'.       
           05 WS-UTW                       PIC X(03) VALUE 'UTW'.       
           05 WS-EPP                       PIC X(03) VALUE 'BBP'.       
           05 WS-RCC                       PIC X(03) VALUE 'RCC'.       
           05 WS-CIA                       PIC X(03) VALUE 'CIA'.       
           05 WS-DEP                       PIC X(03) VALUE 'DEP'.       
           05 WS-DFA                       PIC X(03) VALUE 'DFA'.       
           05 WS-CNT                       PIC X(03) VALUE 'CNT'.       
           05 WS-PJS                       PIC X(03) VALUE 'PJS'.       
           05 WS-ADJ                       PIC X(03) VALUE 'ADJ'.       
      *                                                                         
      *******************************                                           
      ** WORKING STORAGE COPYBOOKS **                                           
      *******************************                                           
      *                                                                         
      ** UTILIZED BY COPYBOOK CPD00007                                          
           EXEC SQL                                                             
               INCLUDE CWS00013                                                 
           END-EXEC.                                                            
      ** UTILIZED BY COPYBOOK CPD09900                                          
           COPY CWS09900.                                                       
      ** UTILIZED BY COPYBOOK CPD0023B                                          
           COPY CWS00010.                                                       
           COPY CWS00303.                                                       
      ** GL MNEMONICS                                                           
           COPY CWS00061.                                                       
      *                                                                         
      *****************************************************************         
      **  CURSORS UTILIZED BY THIS PROGRAM                           **         
      *****************************************************************         
      *                                                                         
      ** SELECTS AN ACCOUNT WITH DIFFERENT LOCAL OFFICES ON CSS_ACCOUNT         
      ** AND CSS_PREMISE.                                                       
           EXEC SQL                                                     
ACT389          DECLARE ACCT_PREM_CSR CURSOR WITH HOLD FOR              
                 SELECT AT.ACCOUNT_NO,                                  
                        AT.CODE_ACCT_STAT,                              
                        AT.LOCAL_OFFICE,                                
                        AT.CODE_COMPANY_ACCT,                           
                        AT.COMPANY_NO,                                  
                        AT.PREMISE_NO,                                  
                        AT.CUSTOMER_NO,                                 
                        PR.LOCAL_OFFICE,                                
                        PR.REV_DISTRICT_CD,                             
                        PR.CODE_PREMISE_STAT,                           
                        CU.CODE_EMPL_ACCT                               
                 FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
                        CSS_PREMISE PR WITH(READUNCOMMITTED),                   
                        CSS_CUSTOMER CU WITH(READUNCOMMITTED)                   
                 WHERE  AT.LOCAL_OFFICE <> PR.LOCAL_OFFICE              
                   AND  AT.PREMISE_NO   = PR.PREMISE_NO                 
                   AND  AT.CUSTOMER_NO  = CU.CUSTOMER_NO                
ACT046           FOR READ ONLY                                  
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE ACCT_PREM_CSR CURSOR WITH HOLD FOR                      
MFA-TR*          SELECT AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.CODE_ACCT_STAT,                                      
MFA-TR*                 AT.LOCAL_OFFICE,                                        
MFA-TR*                 AT.CODE_COMPANY_ACCT,                                   
MFA-TR*                 AT.COMPANY_NO,                                          
MFA-TR*                 AT.PREMISE_NO,                                          
MFA-TR*                 AT.CUSTOMER_NO,                                         
MFA-TR*                 PR.LOCAL_OFFICE,                                        
MFA-TR*                 PR.REV_DISTRICT_CD,                                     
MFA-TR*                 PR.CODE_PREMISE_STAT,                                   
MFA-TR*                 CU.CODE_EMPL_ACCT                                       
MFA-TR*          FROM   CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_PREMISE PR,                                         
MFA-TR*                 CSS_CUSTOMER CU                                         
MFA-TR*          WHERE  AT.LOCAL_OFFICE <> PR.LOCAL_OFFICE                      
MFA-TR*            AND  AT.PREMISE_NO   = PR.PREMISE_NO                         
MFA-TR*            AND  AT.CUSTOMER_NO  = CU.CUSTOMER_NO                        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7025                                                   
MFA-TR*    END-EXEC.                                                            
P00778*                                                                         
P00778** SELECTS AN ACCOUNT WITH DIFFERENT LOCAL OFFICES ON CSS_ACCOUNT         
P00778** AND CSS_PREMISE.                                                       
P00778     EXEC SQL                                                     
P00778          DECLARE ACCT_PREM_SEB CURSOR FOR                        
P00778           SELECT AT.ACCOUNT_NO,                                  
P00778                  AT.CODE_ACCT_STAT,                              
P00778                  AT.LOCAL_OFFICE,                                
P00778                  AT.CODE_COMPANY_ACCT,                           
P00778                  AT.COMPANY_NO,                                  
P00778                  AT.PREMISE_NO,                                  
P00778                  AT.CUSTOMER_NO,                                 
P00778                  PR.LOCAL_OFFICE,                                
P00778                  PR.REV_DISTRICT_CD,                             
P00778                  PR.CODE_PREMISE_STAT,                           
P00778                  CU.CODE_EMPL_ACCT                               
P00778           FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                   
P00778                  CSS_PREMISE PR WITH(READUNCOMMITTED),                   
P00778                  CSS_CUSTOMER CU WITH(READUNCOMMITTED)                   
P00778           WHERE  AT.LOCAL_OFFICE   <> PR.LOCAL_OFFICE            
P00778             AND  AT.CODE_ACCT_STAT  = 'A'                        
P00778             AND  AT.PREMISE_NO      = PR.PREMISE_NO              
P00778             AND  AT.CUSTOMER_NO     = CU.CUSTOMER_NO             
P00778           FOR READ ONLY                                  
P00778                                                      
P00778     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE ACCT_PREM_SEB CURSOR FOR                                
MFA-TR*          SELECT AT.ACCOUNT_NO,                                          
MFA-TR*                 AT.CODE_ACCT_STAT,                                      
MFA-TR*                 AT.LOCAL_OFFICE,                                        
MFA-TR*                 AT.CODE_COMPANY_ACCT,                                   
MFA-TR*                 AT.COMPANY_NO,                                          
MFA-TR*                 AT.PREMISE_NO,                                          
MFA-TR*                 AT.CUSTOMER_NO,                                         
MFA-TR*                 PR.LOCAL_OFFICE,                                        
MFA-TR*                 PR.REV_DISTRICT_CD,                                     
MFA-TR*                 PR.CODE_PREMISE_STAT,                                   
MFA-TR*                 CU.CODE_EMPL_ACCT                                       
MFA-TR*          FROM   CSS_ACCOUNT AT,                                         
MFA-TR*                 CSS_PREMISE PR,                                         
MFA-TR*                 CSS_CUSTOMER CU                                         
MFA-TR*          WHERE  AT.LOCAL_OFFICE   <> PR.LOCAL_OFFICE                    
MFA-TR*            AND  AT.CODE_ACCT_STAT  = 'A'                                
MFA-TR*            AND  AT.PREMISE_NO      = PR.PREMISE_NO                      
MFA-TR*            AND  AT.CUSTOMER_NO     = CU.CUSTOMER_NO                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7080                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ** SELECTS ROW FROM AR_CNTL FOR A PARTICULAR ACCOUNT.                     
           EXEC SQL                                                     
                DECLARE AR_CNTL_CURSOR CURSOR FOR                       
                 SELECT AC.PYMT_PRIORITY_LVL,                           
                        AC.AMT_AR_DAY_00,                               
                        AC.AMT_AR_DAY_30,                               
                        AC.AMT_AR_DAY_60,                               
                        AC.AMT_AR_DAY_90,                               
                        AC.AMT_UNUSED_CR,                               
                        AC.AMT_TRAN_BALANCE,                            
                        AC.TOT_SUMM_UNBILLED                            
                 FROM   CSS_AR_CNTL AC                                  
                 WHERE  AC.ACCOUNT_NO = :AT-ACCOUNT-NO                  
                   AND  (AC.PYMT_PRIORITY_LVL < 50                      
                    OR  (AC.PYMT_PRIORITY_LVL > 45                      
                            AND AC.ITEM_ID > 0))                        
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE AR_CNTL_CURSOR CURSOR FOR                               
MFA-TR*          SELECT AC.PYMT_PRIORITY_LVL,                                   
MFA-TR*                 AC.AMT_AR_DAY_00,                                       
MFA-TR*                 AC.AMT_AR_DAY_30,                                       
MFA-TR*                 AC.AMT_AR_DAY_60,                                       
MFA-TR*                 AC.AMT_AR_DAY_90,                                       
MFA-TR*                 AC.AMT_UNUSED_CR,                                       
MFA-TR*                 AC.AMT_TRAN_BALANCE,                                    
MFA-TR*                 AC.TOT_SUMM_UNBILLED                                    
MFA-TR*          FROM   CSS_AR_CNTL AC                                          
MFA-TR*          WHERE  AC.ACCOUNT_NO = :AT-ACCOUNT-NO                          
MFA-TR*            AND  (AC.PYMT_PRIORITY_LVL < 50                              
MFA-TR*             OR  (AC.PYMT_PRIORITY_LVL > 45                              
MFA-TR*                     AND AC.ITEM_ID > 0))                                
MFA-TR*          QUERYNO 7125                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ** SELECTS ROW FROM CSS_CHRG_OFF FOR A PARTICULAR ACCOUNT.                
           EXEC SQL                                                     
                DECLARE WRITE_OFF_CURSOR CURSOR FOR                     
                 SELECT CO.AMT_TRANS,                                   
                        CO.PYMT_PRIORITY_LVL,                           
                        CO.ITEM_ID                                      
                 FROM   CSS_CHRG_OFF CO                                 
                 WHERE  CO.ACCOUNT_NO = :AT-ACCOUNT-NO                  
ACT046           AND    CO.AMT_TRANS  > 0                               
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE WRITE_OFF_CURSOR CURSOR FOR                             
MFA-TR*          SELECT CO.AMT_TRANS,                                           
MFA-TR*                 CO.PYMT_PRIORITY_LVL,                                   
MFA-TR*                 CO.ITEM_ID                                              
MFA-TR*          FROM   CSS_CHRG_OFF CO                                         
MFA-TR*          WHERE  CO.ACCOUNT_NO = :AT-ACCOUNT-NO                          
MFA-TR*          AND    CO.AMT_TRANS  > 0                                       
MFA-TR*          QUERYNO 7225                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ** SELECT ROW FROM CSS_DEP_ON_HAND FOR A PARTICULAR ACCOUNT.              
           EXEC SQL                                                     
                DECLARE DEPOSIT_CURSOR CURSOR FOR                       
                 SELECT DO.AMT_DEPOSIT,                                 
                        DO.AMT_REFUNDED                                 
T24646           FROM   CSS_DEP_ON_HAND AS DO                           
                 WHERE  DO.ACCOUNT_NO = :AT-ACCOUNT-NO                  
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DEPOSIT_CURSOR CURSOR FOR                               
MFA-TR*          SELECT DO.AMT_DEPOSIT,                                         
MFA-TR*                 DO.AMT_REFUNDED                                         
MFA-TR*          FROM   CSS_DEP_ON_HAND AS DO                                   
MFA-TR*          WHERE  DO.ACCOUNT_NO = :AT-ACCOUNT-NO                          
MFA-TR*          QUERYNO 7325                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ** USED TO RETRIEVE PYMT PRIORITY DESCRIPTIONS.                           
           EXEC SQL                                                     
                DECLARE PRIORITY_DESC_CSR CURSOR FOR                    
                 SELECT L5.PYMT_PRIORITY_LVL,                           
                        L5.AR_TYPE_SHORT_DESC                           
                 FROM   CSS_AR_TYPE L5 WITH(READUNCOMMITTED)                    
ACT046           FOR READ ONLY                                  
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE PRIORITY_DESC_CSR CURSOR FOR                            
MFA-TR*          SELECT L5.PYMT_PRIORITY_LVL,                                   
MFA-TR*                 L5.AR_TYPE_SHORT_DESC                                   
MFA-TR*          FROM   CSS_AR_TYPE L5                                          
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7925                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ** RETRIEVE ENTIRE ROW FROM CSS_PENDING_XFER.                             
           EXEC SQL                                                     
                DECLARE PENDING_XFER_CSR CURSOR FOR                     
                 SELECT XP.ACCT_XFER_FROM,                              
                        XP.ACCT_XFER_TO,                                
                        XP.LOCAL_OFFICE,                                
                        XP.PARTITION_ID,                                
                        XP.PREMISE_NO,                                  
                        XP.SEQUENCE_NO,                                 
                        XP.SUB_ACCT_BLLD_OK,                            
                        XP.TABLE_ID,                                    
                        XP.XFER_DATA                                    
                 FROM   CSS_PENDING_XFER XP                             
                 WHERE  XP.ACCT_XFER_TO = :AT-ACCOUNT-NO                
                   AND  XP.LOCAL_OFFICE = :WS-LOC-OFF-OLD               
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE PENDING_XFER_CSR CURSOR FOR                             
MFA-TR*          SELECT XP.ACCT_XFER_FROM,                                      
MFA-TR*                 XP.ACCT_XFER_TO,                                        
MFA-TR*                 XP.LOCAL_OFFICE,                                        
MFA-TR*                 XP.PARTITION_ID,                                        
MFA-TR*                 XP.PREMISE_NO,                                          
MFA-TR*                 XP.SEQUENCE_NO,                                         
MFA-TR*                 XP.SUB_ACCT_BLLD_OK,                                    
MFA-TR*                 XP.TABLE_ID,                                            
MFA-TR*                 XP.XFER_DATA                                            
MFA-TR*          FROM   CSS_PENDING_XFER XP                                     
MFA-TR*          WHERE  XP.ACCT_XFER_TO = :AT-ACCOUNT-NO                        
MFA-TR*            AND  XP.LOCAL_OFFICE = :WS-LOC-OFF-OLD                       
MFA-TR*          QUERYNO 7425                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ** SQLCA INCLUDES THE VARIABLES USED FOR DB2 PROCESSING.       **         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)     VALUE              
           'WORKING STORAGE FOR PCSRP146 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0000-MAINLINE                                            **          
      **       CONTROLS THE EXECUTION OF THE PROGRAM AT THE HIGHEST **          
      **       LEVEL.  CALLS THE INITIATE ROUTINE, THE MAIN PROCESS **          
      **       LOOP, AND THEN THE TERMINATE ROUTINES.               **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION               THRU 0100-EXIT.    
      *                                                                         
           PERFORM 1000-PROCESS-ACCOUNTS             THRU 1000-EXIT     
              UNTIL NO-MORE-ACCOUNTS.                                   
      *                                                                         
P00778     IF CSR-DATABASE                                              
P00778        PERFORM 7075-CLOSE-ACCOUNT-PREM-CURSOR THRU 7075-EXIT     
P00778     ELSE                                                         
P00778        PERFORM 7090-CLOSE-ACC-PREM-SEB-CUR    THRU 7090-EXIT     
P00778     END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE                    THRU 9000-EXIT.    
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **   0100-INITIALIZATION                                      **          
      **       RETRIEVES THE CURRENT DATE/TIME AND PERFORMS THE     **          
      **       INITIAL FETCH.                                       **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
ACT112     OPEN OUTPUT FCSPT331-FILE.                                   
ACT112     IF FPT331-SUCCESSFUL                                         
ACT112        CONTINUE                                                  
ACT112     ELSE                                                         
ACT112        DISPLAY '********* PCSCA117 ********************'         
ACT112        DISPLAY '0100-ERROR ON FCSPT331 OPEN. STATUS IS '         
ACT112                 WS-FCA331-STATUS                                 
ACT112        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT112        DISPLAY '********* PCSCA117 ********************'         
ACT112     END-IF.                                                      
P00778****                                                                      
P00778     MOVE ZERO                     TO   WS-DATABASE.              
P00778     MOVE '01'                     TO   C8-COMPANY-NO.            
P00778     PERFORM 7010-GET-DELINQUENCY   THRU 7010-EXIT.               
P00778     MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
      *                                                                         
P00778     IF CSR-DATABASE                                              
P00778        PERFORM 7025-OPEN-ACCOUNT-PREM-CURSOR  THRU 7025-EXIT     
P00778        PERFORM 7050-FETCH-ACCOUNT-PREM-CURSOR THRU 7050-EXIT     
P00778     ELSE                                                         
P00778        PERFORM 7080-OPEN-ACC-PREM-SEB-CUR     THRU 7080-EXIT     
P00778        PERFORM 7085-FETCH-ACC-PREM-SEB-CUR    THRU 7085-EXIT     
ACT012        IF NO-MORE-ACCOUNTS                                       
ACT012           NEXT SENTENCE                                          
ACT012        ELSE                                                      
ACT012              PERFORM 5100-CHECK-REG-PROFILE THRU 5100-EXIT       
ACT012        END-IF                                                    
P00778     END-IF.                                                      
      *                                                                         
      ** LOAD THE INTERNAL PAYMENT PRIORITY TABLE AND TRANSFER GL               
      ** ONLY WHEN A VALID ACCOUNT HAS BEEN SELECTED.                           
           IF NO-MORE-ACCOUNTS                                          
               NEXT SENTENCE                                            
           ELSE                                                         
      ** VALIDATE OR INSERT THE BATCH JOURNAL CONTROL.                          
               PERFORM 1100-GET-AND-VALIDATE-CNTRL                      
               MOVE BC-NO-ITEMS-ENTERED      TO WS-JRNL-NO-ITEMS-CNTRL  
                                                                        
               PERFORM 7925-OPEN-PRIORITY-CURSOR         THRU 7925-EXIT 
               PERFORM 7950-FETCH-PRIORITY-CURSOR        THRU 7950-EXIT 
      *                                                                         
               PERFORM 0200-LOAD-PRIORITY-DESC-TABLE     THRU 0200-EXIT 
                VARYING WS-PRIORITY-INDX FROM 1 BY 1                    
                 UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
                    OR WS-PRIORITY-INDX > WS-NUM-OF-ACCT-TYPES          
      *                                                                         
               IF WS-PRIORITY-INDX > WS-NUM-OF-ACCT-TYPES THEN          
                 DISPLAY '0100-INITIALIZATION - '                       
                         'WS-ACCT-TYPE-INDX> INTERNAL ARRAY LIMIT (50)' 
                 PERFORM 9900-ABEND                  THRU 9900-EXIT     
               END-IF                                                   
      *                                                                         
               PERFORM 7975-CLOSE-PRIORITY-CURSOR        THRU 7975-EXIT 
      *                                                                         
      ** THE GENERAL LEDGER ACCOUNT NUMBER CLR-AR-XFR (184.2201) WILL           
      ** ALWAYS BE UTILIZED FOR THE WASH JOURNALS.                              
               MOVE WS-GL-CLR-AR-XFR-KEY     TO GO-GL-ACCT-NAME         
               PERFORM 7800-SELECT-GL-NO     THRU 7800-EXIT             
               MOVE GO-GL-ACCT-NO            TO WS-HOLD-GL-BASE         
                                                                        
      ** SET FLAG THAT AT LEAST ONE ACCOUNT HAS BEEN PROCESSED.                 
               MOVE WS-YES                   TO WS-ACCT-EXISTS          
                                                                        
      ** INITIALIZE THE JOURNAL VARIABLES.                                      
               INITIALIZE WS-100-JOURNAL-RECORD                         
                          CJF00103                                      
           END-IF.                                                      
      *                                                                         
ACT389     IF WS-COMMIT-ACCTS-CNT  = 100                                
ACT389        PERFORM 8850-ISSUE-COMMIT     THRU 8850-EXIT              
ACT389        MOVE ZERO                     TO WS-COMMIT-ACCTS-CNT      
ACT389     END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   0200-LOAD-PRIORITY-DESC-TABLE                                *        
      *        THIS WILL LOAD THE PRIORITY LEVEL AND DESCRIPTION INTO  *        
      *        AN INTERNAL TABLE.                                      *        
      ******************************************************************        
                                                                        
       0200-LOAD-PRIORITY-DESC-TABLE.                                   
      *                                                                         
           MOVE L5-AR-TYPE-SHORT-DESC TO WS-AR-TYPE-SHORT-DESC          
                                          (WS-PRIORITY-INDX).           
           MOVE L5-PYMT-PRIORITY-LVL  TO WS-PYMT-PRIORITY-LVL           
                                          (WS-PRIORITY-INDX).           
      *                                                                         
           PERFORM 7950-FETCH-PRIORITY-CURSOR            THRU 7950-EXIT.
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  1000-PROCESS-ACCOUNTS                                     **          
      **  CALLS THE OTHER PROCESSING COMPONENTS TO JOURNAL, UPDATE  **          
      **  TABLES AND WRITE TRANSACTION HISTORY.  A MESSAGE WILL     **          
      **  DISPLAY THE ACCOUNTS WHICH WERE PROCESSED.                **          
      ****************************************************************          
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
      ** INITIALIZE CONDITIONAL VARIABLES.                                      
           INITIALIZE WS-NO-ARCNTL                                      
                      WS-NO-WRITEOFF                                    
                      WS-NO-DEPOSIT                                     
                      WS-NO-PENDING-XFER.                               
      *                                                                         
ACT112     IF PR-LOCAL-OFFICE = ' '                                     
ACT112        PERFORM 1500-SKIP-EXTRACT-TRANSACTION THRU 1500-EXIT      
ACT112     ELSE                                                         
A05460        IF SEB-DATABASE AND WS-LOC-OFF-OLD = WS-LOC-OFF-NEW       
A05460           NEXT SENTENCE                                          
ACT112        ELSE                                                      
                 PERFORM 1100-GET-AND-VALIDATE-CNTRL THRU 1100-EXIT     
                 PERFORM 4000-CALCULATE-AMOUNT-ENT   THRU 4000-EXIT     
                 PERFORM 1200-RECIEVABLE-UPDATES     THRU 1200-EXIT     
                 PERFORM 1300-TABLE-UPDATES          THRU 1300-EXIT     
                 PERFORM 1400-PREMISE-ACCOUNT        THRU 1400-EXIT     
                 PERFORM 8800-UPDATE-BATCH-CNTL      THRU 8800-EXIT     
A05460        END-IF                                                    
ACT112     END-IF.                                                      
      *                                                                         
P00778     IF CSR-DATABASE                                              
P00778        PERFORM 7050-FETCH-ACCOUNT-PREM-CURSOR THRU 7050-EXIT     
P00778     ELSE                                                         
P00778        PERFORM 7085-FETCH-ACC-PREM-SEB-CUR    THRU 7085-EXIT     
ACT012        IF NO-MORE-ACCOUNTS                                       
ACT012           NEXT SENTENCE                                          
ACT012        ELSE                                                      
ACT012              PERFORM 5100-CHECK-REG-PROFILE THRU 5100-EXIT       
ACT012        END-IF                                                    
P00778     END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  1100-GET-AND-VALIDATE-CNTRL                                 **        
      **  THE BATCH JOURNAL CONTROL WILL BE SELECTED OR INSERTED.     **        
      ******************************************************************        
                                                                        
       1100-GET-AND-VALIDATE-CNTRL.                                     
                                                                        
      ** LOAD THE JOURNALLING VARIABLES TO SELECT OR INSERT THE BATCH           
      ** JOURNAL CONTROL.                                                       
           MOVE 'B'                         TO WS-JRNL-SOURCE-CODE.     
           MOVE SPACES                      TO WS-JRNL-BT-ENTRY-LOC-OFF.
           MOVE SPACES                      TO BC-LOCAL-OFFICE-ENTRY    
                                               WS-JRNL-BT-ENTRY-LOC.    
      *                                                                         
           PERFORM 6405-GET-CURRENT-JRNL-TIME THRU 6405-EXIT.           
           PERFORM 6410-GET-CURRENT-JRNL-DATE THRU 6410-EXIT.           
           MOVE '01'                        TO WS-JRNL-BT-BAT-COMPANY   
                                               WS-100-COMPANY-NO.       
           MOVE '998'                       TO WS-JRNL-BT-BAT-LOC-OFF.  
           MOVE '998'                       TO WS-JRNL-BT-BAT-REPORT-NO.
           MOVE WS-JRNL-TRAN-DATE           TO WS-JRNL-BT-BAT-REPORT-DT.
           MOVE '9999'                      TO WS-JRNL-BT-BAT-CASH-DRWR.
      *                                                                         
           MOVE WS-JRNL-SELECT-AND-OR-INS TO WS-JRNL-OPERATION-RQST.    
      *                                                                         
           PERFORM 6400-BATCH-JRNL-ROUTINE THRU 6400-EXIT.              
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE PROGRAM-NAME              TO ABEND-PROGRAM            
             MOVE '1100'                    TO ACTIVE-PARAGRAPH         
             MOVE 'USERABEN'                TO ABEND-FUNCTION           
             MOVE WS-YES                    TO WS-USER-FORCE-ABEND      
             PERFORM 9900-ABEND             THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  1200-RECIEVABLE-UPDATES                                    **         
      **  THIS PARAGRAPH DIRECTS THE PROCESSING OF THE TABLES WHICH  **         
      **  EFFECT RECIEVABLES.  THESE UPDATES REQUIRE WASH JOURNALS TO**         
      **  BE PERFORMED.  EACH TABLE REQUIRES A CUROSR TO BE OPENED,  **         
      **  FETCHED, AND CLOSED.  THE TABLES ARE CSS_AR_CNTL,          **         
      **  CSS_CHRG_OFF, AND CSS_DEP_ON_HAND.                         **         
      *****************************************************************         
      *                                                                         
       1200-RECIEVABLE-UPDATES.                                         
      ** THIS SECTION OF LOGIC JOURNAL BASED ON THE AR_CNTL TABLE.              
           PERFORM 7125-OPEN-ARCURSOR            THRU 7125-EXIT.        
           PERFORM 7150-FETCH-ARCURSOR           THRU 7150-EXIT.        
      *                                                                         
           PERFORM 2000-PROCESS-ARCNTL           THRU 2000-EXIT         
                   UNTIL NO-MORE-ARCNTL.                                
      *                                                                         
           PERFORM 7175-CLOSE-ARCURSOR.                                 
      *                                                                         
      ** ONLY PROCESS CSS_CHRG_OFF WHEN THE ACCOUNT IS WRITTEN OFF.             
           IF AT-CODE-ACCT-STAT EQUAL WS-WRITTEN-OFF                    
               PERFORM 7225-OPEN-WOCURSOR        THRU 7225-EXIT         
               PERFORM 7250-FETCH-WOCURSOR       THRU 7250-EXIT         
      *                                                                         
               PERFORM 2100-PROCESS-WRITTEN-OFF  THRU 2100-EXIT         
                       UNTIL NO-MORE-WRITE-OFF                          
      *                                                                         
               PERFORM 7275-CLOSE-WOCURSOR       THRU 7275-EXIT         
      *                                                                         
           ELSE                                                         
      **  JOURNALS FOR DEPOSIT WILL BE DRIVEN BY DEP_ON_HAND.  ACCOUNTS         
      **  THAT ARE WRITTEN OFF WILL NOT HAVE DEPOSITS.                          
               PERFORM 7325-OPEN-DEPOSITS-CURSOR THRU 7325-EXIT         
               PERFORM 7350-FETCH-DEPOSITS-CURSOR                       
                                                 THRU 7350-EXIT         
      *                                                                         
               PERFORM 2200-PROCESS-DEPOSITS     THRU 2200-EXIT         
                       UNTIL NO-MORE-DEPOSITS                           
      *                                                                         
               PERFORM 7375-CLOSE-DEPOSITS-CURSOR THRU 7375-EXIT        
      *                                                                         
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1300-TABLE-UPDATES                                           **        
      ** THIS LOGIC DRIVES THE SIMPLE UPDATES OF SEVERAL TABLES WHICH **        
      ** HOLD THE LOCAL OFFICE VALUE FOR AN ACCOUNT.  TABLES EFFECTED:**        
ACT257** CSS_PENDING_XFER, CSS_REFUND, CSS_SO_DATA_MF, CSS_SO_DATA   .**        
      ******************************************************************        
      *                                                                         
       1300-TABLE-UPDATES.                                              
      *                                                                         
      ** A SELECT, INSERT, AND DELETE MUST BE PERFORMED ON                      
      ** CSS_PENDING_XFER SINCE THE LOCAL OFFICE IS PART OF THE KEY.            
           PERFORM 7425-OPEN-PENDING-XFER-CURSOR         THRU 7425-EXIT.
           PERFORM 7450-FETCH-PENDING-XFER-CURSOR        THRU 7450-EXIT.
      *                                                                         
           PERFORM 2300-PROCESS-PENDING-XFER THRU 2300-EXIT             
                   UNTIL NO-MORE-PENDING-XFER.                          
      *                                                                         
           PERFORM 7475-CLOSE-PENDING-XFER-CURSOR        THRU 7475-EXIT.
      *                                                                         
      ** UPDATES ONLY NEED TO BE PERFORMED FOR THESE TABLES.                    
           PERFORM 8000-UPDATE-PENDING-REFUNDS           THRU 8000-EXIT.
           PERFORM 8100-UPDATE-MF-SERVICE-ORDERS         THRU 8100-EXIT.
ACT257     PERFORM 8150-UPDATE-SERVICE-ORDERS            THRU 8150-EXIT.
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS LOGIC WILL UPDATE THE CSS_ACCOUNT WITH THE NEW LOCAL   **        
      **  OFFICE FOR THE ACCOUNT.  ALSO, MAINTENANCE TRANSACTION      **        
      **  WILL BE WRITTEN FOR THE ACCOUNT AND THE PREMISE.            **        
      ******************************************************************        
      *                                                                         
       1400-PREMISE-ACCOUNT.                                            
      *                                                                         
      ** GET THE CURRENT TIME-STAMP.                                            
           PERFORM 5510-GET-TIMESTAMP                    THRU 5510-EXIT.
      *                                                                         
           PERFORM 8500-UPDATE-ACCOUNT-TABLE THRU 8500-EXIT.            
      *                                                                         
T26323** UPDATE THE LOCAL OFFICE ON CSS_NAME_ACCT_XREF.                         
T26323     PERFORM 8550-UPDATE-NAME-ACCT-XREF            THRU 8550-EXIT.
      ** WRITE MNT TRANSACTION HISTORY FOR THE ACCOUNT AND PREMISE.             
           PERFORM 5500-JRNL-TRAN-PROCESS                THRU 5500-EXIT.
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT112******************************************************************        
ACT112** 1500-SKIP-EXTRACT-TRANSACTION.                               **        
ACT112** THIS LOGIC WILL WRITES THE RECORD TO AN OUT PUT FILE WHEN    **        
ACT112** LOCAL OFFICE IS BLANK.                                       **        
ACT112******************************************************************        
      *                                                                         
ACT112 1500-SKIP-EXTRACT-TRANSACTION.                                   
      *                                                                         
ACT112     IF  WS-SKIP-ACCT-COUNT = 0                                   
ACT112         PERFORM  8900-WRITE-SKIP-HEADERS  THRU 8900-EXIT         
ACT112     END-IF.                                                      
ACT112     MOVE AT-ACCOUNT-NO                    TO WS-SKIP-ACCT-NO.    
ACT112     MOVE AT-CUSTOMER-NO                   TO WS-SKIP-CUST-NO.    
ACT112     MOVE AT-PREMISE-NO                    TO WS-SKIP-PREM-NO.    
ACT112     ADD  +1                               TO WS-SKIP-ACCT-COUNT. 
ACT112     PERFORM 8950-WRITE-SKIP-DETAIL-REC THRU 8950-EXIT.           
      *                                                                         
ACT112 1500-EXIT.                                                       
ACT112      EXIT.                                                       
      ******************************************************************        
      ** 2000-PROCESS-ARCNTL                                          **        
      ** A JRNL WILL BE WRITTEN FOR ALL OF THE ACCOUNTS ARCNTL ROWS.  **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-ARCNTL.                                             
      *                                                                         
      **  ASSOCIATE THE PAYMENT PRIORITY LEVEL WITH THE APPROPRIATE GL          
      **  NEUMONIC.                                                             
           MOVE AC-PYMT-PRIORITY-LVL         TO WS-PRIORITY-LVL.        
           PERFORM 3000-GET-GL-NEUMONIC      THRU 3000-EXIT.            
                                                                        
      **  THE AMOUNT THAT WILL BE JOURNALLED IS DEPENDENT UPON THE              
      **  PAYMENT PRIORITY LEVEL.                                               
           PERFORM 2050-COMPUTE-JRNL-AMT     THRU 2050-EXIT.            
                                                                        
      ** AN ACTIVE ACCOUNT CAN HAVE ACTIVE AR_CNTL ROWS OF ZERO FOR             
      ** UTE AND UTG.  THE PROGRAM SHOULD NOT JOURNAL IN THAT CASE.             
           IF WS-JRNL-AMT NOT EQUAL ZERO                                
                                                                        
      ** RETRIEVE THE GL ACCOUNT NUMBER.                                        
               PERFORM 7800-SELECT-GL-NO     THRU 7800-EXIT             
               MOVE GO-GL-ACCT-NO            TO WS-HOLD-GL-MOVED        
                                                                        
      ** CREATE JOURNAL TO REMOVE FROM OLD LOCAL OFFICE.                        
      ** THE DIRECTION (CREDIT/DEBIT) IS REVERSED WHEN THE AMOUNT IS            
      ** NEGATIVE.                                                              
               IF WS-JRNL-AMT GREATER THAN ZERO                         
                   MOVE WS-HOLD-GL-MOVED     TO WS-GL-IN                
                   MOVE WS-HOLD-GL-BASE      TO WS-GL-OUT               
               ELSE                                                     
                   MOVE WS-HOLD-GL-MOVED     TO WS-GL-OUT               
                   MOVE WS-HOLD-GL-BASE      TO WS-GL-IN                
               END-IF                                                   
                                                                        
               MOVE WS-LOC-OFF-OLD           TO WS-LOCAL-OFFICE         
               PERFORM 3100-CREATE-JRNL-FROM-RECORD                     
                                             THRU 3100-EXIT             
                                                                        
      ** DECREMENT THE TRAN-APPL-NO WHICH ALLOWS FOR CORRECT DISPLAY            
      ** ON THE 123 REPORT.  ADD TO THE ENTRY NUMBER TO JOURNAL                 
      ** CORRECTLY (PREVENT INDEX ERRORS ON INSERT).                            
               SUBTRACT WS-ONE FROM WS-100-TRAN-APPL-NO-HOLD            
               ADD WS-ONE      TO WS-JRNL-ENTRY-NO-HOLD                 
                                                                        
      ** CREATE THE JOURNAL TO ADD TO THE NEW LOCAL OFFICE.                     
      ** THE DIRECTION (CREDIT/DEBIT) IS REVERSED WHEN THE AMOUNT IS            
      ** NEGATIVE.                                                              
               IF WS-JRNL-AMT GREATER THAN ZERO                         
                   MOVE WS-HOLD-GL-MOVED     TO WS-GL-OUT               
                   MOVE WS-HOLD-GL-BASE      TO WS-GL-IN                
               ELSE                                                     
                   MOVE WS-HOLD-GL-MOVED     TO WS-GL-IN                
                   MOVE WS-HOLD-GL-BASE      TO WS-GL-OUT               
               END-IF                                                   
                                                                        
               MOVE WS-LOC-OFF-NEW           TO WS-LOCAL-OFFICE         
               PERFORM 3100-CREATE-JRNL-FROM-RECORD                     
                                             THRU 3100-EXIT             
                                                                        
      ** RESTORE THE ENTRY NUMBER TO ITS ORIGINAL VALUE FOR NEXT JOURNAL        
               SUBTRACT WS-ONE FROM WS-JRNL-ENTRY-NO-HOLD               
                                                                        
           END-IF.                                                      
                                                                        
      ** FETCH THE NEXT CSS_AR_CNTL_ROW.                                        
           PERFORM 7150-FETCH-ARCURSOR   THRU 7150-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2050-COMPUTE-JRNL-AMT                                       **        
      **  THE AMOUNT THAT NEEDS TO BE JOURNALLED DEPENDS UPON THE     **        
      **  PAYMENT PRIORITY LEVEL.                                     **        
      ******************************************************************        
      *                                                                         
       2050-COMPUTE-JRNL-AMT.                                           
      *                                                                         
           IF (WS-PRIORITY-DESC EQUAL WS-NSC                            
              OR WS-PRIORITY-DESC EQUAL WS-NSA                          
              OR WS-PRIORITY-DESC EQUAL WS-NSN)                         
                                                                        
               COMPUTE WS-JRNL-AMT = (AC-AMT-AR-DAY-00 +                
                                      AC-AMT-AR-DAY-30 +                
                                      AC-AMT-AR-DAY-60 +                
                                      AC-AMT-AR-DAY-90 +                
                                      AC-AMT-UNUSED-CR)                 
           ELSE                                                         
               IF (WS-PRIORITY-DESC EQUAL WS-LPC                        
                  OR WS-PRIORITY-DESC EQUAL WS-LPN                      
                  OR WS-PRIORITY-DESC EQUAL WS-UTE                      
                  OR WS-PRIORITY-DESC EQUAL WS-UTG                      
                  OR WS-PRIORITY-DESC EQUAL WS-PJS)                     
                                                                        
                   COMPUTE WS-JRNL-AMT = (AC-AMT-AR-DAY-00 +            
                                          AC-AMT-AR-DAY-30 +            
                                          AC-AMT-AR-DAY-60 +            
                                          AC-AMT-AR-DAY-90 +            
                                          AC-AMT-UNUSED-CR +            
                                          AC-TOT-SUMM-UNBILLED)         
               ELSE                                                     
                   IF (WS-PRIORITY-DESC EQUAL WS-EPP                    
                      OR WS-PRIORITY-DESC EQUAL WS-RCC                  
                      OR WS-PRIORITY-DESC EQUAL WS-CIA                  
                      OR WS-PRIORITY-DESC EQUAL WS-DEP                  
                      OR WS-PRIORITY-DESC EQUAL WS-DFA                  
                      OR WS-PRIORITY-DESC EQUAL WS-CNT)                 
                                                                        
                       COMPUTE WS-JRNL-AMT = AC-AMT-TRAN-BALANCE        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ** 2100-PROCESS-WRITTEN-OFF                                     **        
      ** A JRNL WILL BE WRITTEN FOR ALL OF THE ACCOUNTS CHRG OFF ROWS.**        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-WRITTEN-OFF.                                        
      *                                                                         
           MOVE CO-AMT-TRANS             TO WS-JRNL-AMT.                
                                                                        
      ** THE WRITE OFF ACCOUNT GL FOR THE CONTRACT NEEDS TO OBTAINED            
      ** FROM CSS_CNT_DETAILS.  OTHERWISE, THE OTHER PAYMENT PRIORITIES         
      ** HAVE GENERIC GLS.                                                      
           IF CO-PYMT-PRIORITY-LVL EQUAL WS-CONTRACT-LVL                
               PERFORM 7600-SELET-CNT-GL THRU 7600-EXIT                 
               MOVE EA-WRT-OFF-GL-ACCT-NO                               
                                         TO WS-HOLD-GL-MOVED            
           ELSE                                                         
      ** MOVE THE RETRIEVED PAYMENT LEVEL TO A COMPARABLE VARIABLE.             
               MOVE CO-PYMT-PRIORITY-LVL TO WS-PRIORITY-LVL             
                                                                        
               PERFORM 3050-GET-WO-GLNEUM                               
                                         THRU 3050-EXIT                 
               PERFORM 7800-SELECT-GL-NO THRU 7800-EXIT                 
               MOVE GO-GL-ACCT-NO            TO WS-HOLD-GL-MOVED        
           END-IF.                                                      
                                                                        
      ** CREATE JOURNAL TO REMOVE FROM OLD LOCAL OFFICE.                        
           MOVE WS-HOLD-GL-MOVED         TO WS-GL-IN.                   
           MOVE WS-HOLD-GL-BASE          TO WS-GL-OUT.                  
           MOVE WS-LOC-OFF-OLD           TO WS-LOCAL-OFFICE.            
           PERFORM 3100-CREATE-JRNL-FROM-RECORD                         
                                         THRU 3100-EXIT.                
                                                                        
      ** DECREMENT THE TRAN-APPL-NO WHICH ALLOWS FOR CORRECT DISPLAY            
      ** ON THE 123 REPORT.  ADD TO THE ENTRY NUMBER TO JOURNAL                 
      ** CORRECTLY (PREVENT INDEX ERRORS ON INSERT).                            
           SUBTRACT WS-ONE FROM WS-100-TRAN-APPL-NO-HOLD.               
           ADD WS-ONE      TO WS-JRNL-ENTRY-NO-HOLD.                    
                                                                        
      ** CREATE THE JOURNAL TO ADD TO THE NEW LOCAL OFFICE.                     
           MOVE WS-HOLD-GL-MOVED         TO WS-GL-OUT.                  
           MOVE WS-HOLD-GL-BASE          TO WS-GL-IN.                   
           MOVE WS-LOC-OFF-NEW           TO WS-LOCAL-OFFICE.            
           PERFORM 3100-CREATE-JRNL-FROM-RECORD                         
                                         THRU 3100-EXIT.                
                                                                        
      ** RESTORE THE ENTRY NUMBER TO ITS ORIGINAL VALUE FOR NEXT JOURNAL        
           SUBTRACT WS-ONE FROM WS-JRNL-ENTRY-NO-HOLD.                  
                                                                        
      ** FETCH THE NEXT CSS_CHRG_OFF ROW.                                       
           PERFORM 7250-FETCH-WOCURSOR   THRU 7250-EXIT.                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-PROCESS-DEPOSITS                                        **        
      ** A JRNL WILL BE WRITTEN FOR ALL OF THE ACCOUNTS DEPOSITS.     **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-DEPOSITS.                                           
      *                                                                         
           COMPUTE WS-JRNL-AMT EQUAL     DO-AMT-DEPOSIT.                
                                                                        
      ** IT IS NOT NECESSARY TO JOURNAL WHEN A DEPOSIT HAS BEEN FULLY           
      ** REFUNDED.(AMT-DEPOSIT WILL BE ZERO AT THAT POINT)                      
           IF WS-JRNL-AMT NOT EQUAL ZERO                                
                                                                        
               MOVE WS-GL-DEP-DEP-KEY        TO GO-GL-ACCT-NAME         
               PERFORM 7800-SELECT-GL-NO     THRU 7800-EXIT             
               MOVE GO-GL-ACCT-NO            TO WS-HOLD-GL-MOVED        
                                                                        
      ** CREATE JOURNAL TO REMOVE FROM OLD LOCAL OFFICE.                        
               MOVE WS-HOLD-GL-MOVED         TO WS-GL-OUT               
               MOVE WS-HOLD-GL-BASE          TO WS-GL-IN                
               MOVE WS-LOC-OFF-OLD           TO WS-LOCAL-OFFICE         
               PERFORM 3100-CREATE-JRNL-FROM-RECORD                     
                                             THRU 3100-EXIT             
                                                                        
      ** DECREMENT THE TRAN-APPL-NO WHICH ALLOWS FOR CORRECT DISPLAY            
      ** ON THE 123 REPORT.  ADD TO THE ENTRY NUMBER TO JOURNAL                 
      ** CORRECTLY (PREVENT INDEX ERRORS ON INSERT).                            
               SUBTRACT WS-ONE FROM WS-100-TRAN-APPL-NO-HOLD            
               ADD WS-ONE      TO WS-JRNL-ENTRY-NO-HOLD                 
                                                                        
      ** CREATE THE JOURNAL TO ADD TO THE NEW LOCAL OFFICE.                     
               MOVE WS-HOLD-GL-MOVED         TO WS-GL-IN                
               MOVE WS-HOLD-GL-BASE          TO WS-GL-OUT               
               MOVE WS-LOC-OFF-NEW           TO WS-LOCAL-OFFICE         
               PERFORM 3100-CREATE-JRNL-FROM-RECORD                     
                                             THRU 3100-EXIT             
                                                                        
      ** RESTORE THE ENTRY NUMBER TO ITS ORIGINAL VALUE FOR NEXT JOURNAL        
               SUBTRACT WS-ONE FROM WS-JRNL-ENTRY-NO-HOLD               
                                                                        
           END-IF.                                                      
                                                                        
      ** FETCH THE NEXT DEP_ON_HAND ROW.                                        
           PERFORM 7350-FETCH-DEPOSITS-CURSOR                           
                                             THRU 7350-EXIT.            
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2300-PROCESS-PENDING-XFER                                   **        
      **  THE LOGIC WILL INSERT A NEW PENDING XFER ROW FOR THE NEW    **        
      **  LOCAL OFFICE AND THEN DELETE THE ROW FOR THE OLD LOC OFF.   **        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-PENDING-XFER.                                       
      *                                                                         
      ** INSERT A ROW WITH THE NEW LOCAL OFFICE NUMBER.                         
           PERFORM 8300-INSERT-PEND-XFER             THRU 8300-EXIT.    
      ** DELETE CORRESPONDING ROW WITH OLD LOCAL OFFICE NUMBER.                 
           PERFORM 8400-DELETE-PEND-XFER             THRU 8400-EXIT.    
      *                                                                         
           PERFORM 7450-FETCH-PENDING-XFER-CURSOR    THRU 7450-EXIT.    
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3000-GET-GL-NEUMONIC                                        **        
      **  THIS PARAGRAPH WILL RETRIEVE THE GL ACCOUNT NUMBER FOR A    **        
      **  CORRESPONDING PAYMENT PRIORITY LEVEL FOR ACTIVE RECIEVABLES.**        
      ******************************************************************        
      *                                                                         
       3000-GET-GL-NEUMONIC.                                            
      *                                                                         
      **  SEARCH THE INTERNAL TABLE TO FIND THE PAYMENT PRIORITIES              
      **  DESCRIPTION.                                                          
           SET WS-PRIORITY-INDX    TO 1.                                
           SEARCH WS-PYMT-PRIORITY-REC                                  
              AT END                                                    
                   MOVE WS-NO           TO WS-PRIORITY-TYPE-DESC-SWITCH 
              WHEN WS-PYMT-PRIORITY-LVL(WS-PRIORITY-INDX) =             
                   WS-PRIORITY-LVL                                      
                   MOVE WS-AR-TYPE-SHORT-DESC(WS-PRIORITY-INDX)         
                                        TO WS-PRIORITY-DESC             
                   MOVE WS-YES          TO WS-PRIORITY-TYPE-DESC-SWITCH 
              WHEN WS-PRIORITY-INDX > WS-NUM-OF-ACCT-TYPES              
                   MOVE WS-NO           TO WS-PRIORITY-TYPE-DESC-SWITCH.
                                                                        
      **  LOAD THE CORRESPONDING GL ACCOUNT NUMBERS FOR PAYMENT                 
      **  PRIORITIES.                                                           
           EVALUATE WS-PRIORITY-DESC                                    
               WHEN WS-UTE                                              
                  MOVE WS-GL-AR-UTE-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-UTG                                              
                  MOVE WS-GL-AR-UTG-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-NSC                                              
                  MOVE WS-GL-AR-NSC-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-NSA                                              
                  MOVE WS-GL-AR-NSA-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-NSN                                              
                  MOVE WS-GL-AR-NSN-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-LPC                                              
                  MOVE WS-GL-AR-LPC-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-LPN                                              
                  MOVE WS-GL-AR-LPN-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-EPP                                              
                  MOVE WS-GL-AR-BUD-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-RCC                                              
                  MOVE WS-GL-AR-CCC-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-CIA                                              
                  MOVE WS-GL-AR-CIA-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-DEP                                              
                  MOVE WS-GL-AR-DEP-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-DFA                                              
                  MOVE WS-GL-AR-DFA-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-CNT                                              
                  MOVE WS-GL-AR-CNT-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-PJS                                              
                  MOVE WS-GL-AR-PJS-KEY TO GO-GL-ACCT-NAME              
           END-EVALUATE.                                                
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  3050-GET-WO-GLNEUM                                          **        
      **  THIS PARAGRAPH WILL RETRIEVE THE GL ACCOUNT NUMBER FOR A    **        
      **  CORRESPONDING PAYMENT PRIORITY LEVEL FOR WRITTEN OFF        **        
      **  RECIEVABLES.                                                **        
      ******************************************************************        
      *                                                                         
       3050-GET-WO-GLNEUM.                                              
      *                                                                         
      **  SEARCH THE INTERNAL TABLE TO FIND THE PAYMENT PRIORITIES              
      **  DESCRIPTION.                                                          
           SET WS-PRIORITY-INDX    TO 1.                                
           SEARCH WS-PYMT-PRIORITY-REC                                  
              AT END                                                    
                   MOVE WS-NO           TO WS-PRIORITY-TYPE-DESC-SWITCH 
              WHEN WS-PYMT-PRIORITY-LVL(WS-PRIORITY-INDX) =             
                   WS-PRIORITY-LVL                                      
                   MOVE WS-AR-TYPE-SHORT-DESC(WS-PRIORITY-INDX)         
                                        TO WS-PRIORITY-DESC             
                   MOVE WS-YES          TO WS-PRIORITY-TYPE-DESC-SWITCH 
              WHEN WS-PRIORITY-INDX > WS-NUM-OF-ACCT-TYPES              
                   MOVE WS-NO           TO WS-PRIORITY-TYPE-DESC-SWITCH.
                                                                        
      **  LOAD THE CORRESPONDING GL ACCOUNT NUMBERS FOR PAYMENT                 
      **  PRIORITIES.                                                           
           EVALUATE WS-PRIORITY-DESC                                    
               WHEN WS-UTE                                              
                  MOVE WS-GL-WO-UTE-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-UTG                                              
                  MOVE WS-GL-WO-UTG-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-NSC                                              
                  MOVE WS-GL-WO-NSC-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-NSA                                              
                  MOVE WS-GL-WO-NSA-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-NSN                                              
                  MOVE WS-GL-WO-NSN-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-LPC                                              
                  MOVE WS-GL-WO-ELECCHG-KEY TO GO-GL-ACCT-NAME          
               WHEN WS-LPN                                              
                  MOVE WS-GL-WO-LPN-KEY TO GO-GL-ACCT-NAME              
               WHEN WS-RCC                                              
                  MOVE WS-GL-WO-ELECCHG-KEY TO GO-GL-ACCT-NAME          
           END-EVALUATE.                                                
                                                                        
       3050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    CREATE JOURNAL FROM SELECTED DATA                           *        
      ******************************************************************        
                                                                        
       3100-CREATE-JRNL-FROM-RECORD.                                    
                                                                        
           MOVE AT-ACCOUNT-NO          TO WS-100-ACCT-NO                
                                          WS-103-TRAN-ACCT-NO.          
      *                                                                         
           MOVE WS-LOCAL-OFFICE        TO WS-100-LOCAL-OFFICE-CD.       
           MOVE AT-COMPANY-NO          TO WS-100-COMPANY-NO.            
           MOVE AT-PREMISE-NO          TO WS-100-PREMISE-NO.            
           MOVE AT-CODE-COMPANY-ACCT   TO WS-103-CODE-COMPANY-ACCT.     
           MOVE AT-CODE-ACCT-STAT      TO WS-103-CODE-ACCT-STATUS.      
           MOVE AT-CUSTOMER-NO         TO WS-100-CUSTOMER-NO            
                                          WS-103-TRAN-CUST-NO.          
                                                                        
           MOVE CU-CODE-EMPL-ACCT      TO WS-103-CODE-EMPL-ACCT.        
      *                                                                         
           MOVE PR-REV-DISTRICT-CD     TO WS-103-CODE-REVENUE-DISTRICT. 
           MOVE PR-CODE-PREMISE-STAT   TO WS-103-CODE-PREMISE-STATUS.   
      *                                                                         
           MOVE SPACES                 TO WS-100-TRANS-ERRORS.          
                                                                        
           MOVE WS-103-JRNL-FMT        TO WS-103-JRNL-FORMAT-NO.        
           MOVE WS-BATCH-DRAWER        TO WS-103-CASH-DRAWER-USED.      
                                                                        
           MOVE WS-AMOUNT-ENTERED      TO WS-103-AMOUNT-ENTERED.        
           MOVE WS-JRNL-AMT            TO WS-103-AMT-POSTED             
                                          WS-JRNL-GEN-LEG-DEBIT-AMT     
                                          WS-JRNL-GEN-LEG-CREDIT-AMT.   
                                                                        
           MOVE WS-GL-OUT              TO WS-103-ACCT-GEN-LED-DR.       
                                                                        
           MOVE WS-GL-IN               TO WS-103-ACCT-GEN-LED-CR.       
                                                                        
           MOVE WS-ALPHA               TO WS-100-JRNL-SORT-ID.          
           MOVE WS-A117                TO WS-100-CODE-TERMINAL-TRAN.    
           MOVE WS-BETA                TO WS-100-CODE-ENTRY-SOURCE.     
                                                                        
           MOVE WS-JRNL-ONLY           TO WS-JRNL-OPERATION-RQST.       
           MOVE WS-JRNL-CASH-UPDATE    TO WS-JRNL-BT-AUTH-TYPE.         
           MOVE WS-NO                  TO WS-UPDATE-JRNL-CNTL-NOW.      
                                                                        
           MOVE CJF00103               TO WS-100-USER-DEFINED-AREA.     
                                                                        
           PERFORM 6400-BATCH-JRNL-ROUTINE THRU 6400-EXIT.              
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PCSCA117 PROCESSING ERROR'                  
               DISPLAY '**  PARAGRAPH = 3000-'                          
               DISPLAY '**  RC        = ' WS-JRNL-RTRN-CODE             
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  4000-CALCULATE-AMOUNT-ENT                                   **        
      **  CALCULATE THE TOTAL AMOUNT TO BE JOURNALLED.                **        
      ******************************************************************        
      *                                                                         
       4000-CALCULATE-AMOUNT-ENT.                                       
      *                                                                         
      ** RETRIEVE AR CONTROL TOTAL FOR PAYMENT PRIORITIES LESS THAN             
      ** FIFTY.                                                                 
           PERFORM 7700-ARCNTL-FIRST-AMT  THRU 7700-EXIT.               
      *                                                                         
      ** RETRIEVE AR CONTROL TOTAL FOR PAYMENT PRIORITIES GREATER THAN          
      ** FOURTY FIVE.                                                           
           PERFORM 7710-ARCNTL-SECOND-AMT THRU 7710-EXIT.               
      *                                                                         
           IF AT-CODE-ACCT-STAT EQUAL WS-WRITTEN-OFF                    
                                                                        
      ** RETRIEVE WRITTEN OFF AMOUNT TOTAL TO BE JOURNALLED.                    
               PERFORM 7750-WRITE-OFF-AMT THRU 7750-EXIT                
               MOVE ZERO                  TO WS-SUM-AMT-DEPOSIT         
           ELSE                                                         
                                                                        
      ** RETRIEVE DEPOSIT AMOUNT TOTAL TO BE JOURNALLED.                        
               PERFORM 7775-DEPOSIT-AMT   THRU 7775-EXIT                
               MOVE ZERO                  TO WS-SUM-AMT-TRANS           
           END-IF.                                                      
      *                                                                         
           COMPUTE WS-AMOUNT-ENTERED = (WS-SUM-00-DAY +                 
                                        WS-SUM-30-DAY +                 
                                        WS-SUM-60-DAY +                 
                                        WS-SUM-90-DAY +                 
                                        WS-SUM-UNUSED +                 
                                        WS-SUM-TRAN-BAL +               
                                        WS-SUM-AMT-TRANS +              
                                        WS-SUM-AMT-DEPOSIT).            
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
ACT012**  SEB ONLY - CHECK CSS_REG_PROFILE.                         **          
ACT012**  IF ON TABLE AND PR-LOCAL-OFFICE > 499,                    **          
ACT012**      OR                                                    **          
ACT012**  IF NOT ON TABLE,                                          **          
ACT012**      NO CHANGE TO PROCESS FLOW OF PROGRAM -                **          
ACT012**          UPDATE AT-LOCAL-OFFICE WITH PR-LOCAL-OFFICE       **          
      **                                                            **          
ACT012**  IF ON TABLE AND PR-LOCAL-OFFICE < 500,                    **          
ACT012**     UPDATE PR-LOCAL-OFFICE WITH AT-LOCAL-OFFICE.           **          
      ****************************************************************          
      *                                                                         
ACT012 5100-CHECK-REG-PROFILE.                                          
      *                                                                         
ACT012     MOVE AT-ACCOUNT-NO TO LR-ACCOUNT-NO.                         
ACT012     MOVE AT-PREMISE-NO TO PR-PREMISE-NO.                         
ACT012     MOVE WS-N          TO WS-PREMISE-SW.                         
      *                                                                         
ACT012     PERFORM 7805-SELECT-REG-PROFILE THRU 7805-EXIT.              
      *                                                                         
A05460     IF ((WS-REG-PROFILE-SW = WS-N AND PR-LOCAL-OFFICE < '500')   
A05460        OR                                                        
A05460          (WS-REG-PROFILE-SW = WS-Y AND PR-LOCAL-OFFICE > '499')) 
A05460        NEXT SENTENCE                                             
A05460     ELSE                                                         
A05460        IF WS-REG-PROFILE-SW = WS-Y                               
A05460           MOVE PR-LOCAL-OFFICE TO WS-LOC-OFF-BRK                 
A05460           MOVE WS-FIVE         TO WS-LOC-OFF-BRK1                
A05460           MOVE WS-LOC-OFF-BRK  TO WS-LOC-OFF-NEW                 
A05460           MOVE AT-LOCAL-OFFICE TO WS-LOC-OFF-OLD                 
A05460           MOVE WS-Y            TO WS-PREMISE-SW                  
A05460        ELSE                                                      
A05460           MOVE PR-LOCAL-OFFICE TO WS-LOC-OFF-BRK                 
A05460           MOVE WS-ZERO         TO WS-LOC-OFF-BRK1                
A05460           MOVE WS-LOC-OFF-BRK  TO WS-LOC-OFF-NEW                 
A05460           MOVE AT-LOCAL-OFFICE TO WS-LOC-OFF-OLD                 
A05460           MOVE WS-Y            TO WS-PREMISE-SW                  
A05460        END-IF                                                    
A05460     END-IF.                                                      
      *                                                                         
A05460     IF WS-PREMISE-SW = WS-Y                                      
A05460        PERFORM 8510-UPDATE-PREMISE-TABLE THRU 8510-EXIT          
A05460     END-IF.                                                      
      *                                                                         
ACT012 5100-EXIT.                                                       
ACT012     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   5500-JRNL-TRAN-PROCESS.                                      *        
      *   FIRST THIS LOGIC WILL POPULATE THE TRANACTION HISTORY        *        
      *   VARIABLES.  INSERTS WILL THEN BE PERFORMED ON                *        
      *   CSS_MNT_TRANS_HIST AND CSS_MT_TRN_HST_DET.                   *        
      ******************************************************************        
       5500-JRNL-TRAN-PROCESS.                                          
                                                                        
           PERFORM 5510-GET-TIMESTAMP     THRU 5510-EXIT.               
                                                                        
           MOVE WS-TRANS-HIST-SEQ-NO      TO MH-TRANS-HIST-SEQ-NO.      
           MOVE WS-TYPE-MNT               TO MH-CODE-TRAN-TYPE.         
           MOVE SPACES                    TO MH-RESP-AREA-ID.           
           MOVE AT-ACCOUNT-NO             TO MH-ACCOUNT-NO.             
           MOVE ZERO                      TO MH-CUSTOMER-NO.            
           MOVE AT-PREMISE-NO             TO MH-PREMISE-NO.             
           MOVE WS-SYSTEM                 TO MH-USER-ID.                
                                                                        
           MOVE WS-TRANS-HIST-SEQ-NO      TO WS-CUR-RUN-DATE-TIME.      
           MOVE WS-TRANS-DATE             TO MH-DATE-TRANS.             
           MOVE WS-NULL-TRANS-HIST-SEQ-NO TO WS-NULL-DATE-TRANS.        
                                                                        
           MOVE PROGRAM-NAME              TO MH-APPL-PROGRAM-ID.        
           MOVE WS-TRAN-COMMENT           TO MH-TRAN-COMMENT-TEXT       
           MOVE WS-TRAN-COMMENT-LEN       TO MH-TRAN-COMMENT-LEN.       
                                                                        
           MOVE ZERO                      TO MI-TRAN-APPL-NO.           
           MOVE WS-LOCOFF-TABLE-ID        TO MI-TABLE-ID.               
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO       
           ADD WS-ONE                     TO MI-TRAN-APPL-NO.           
           MOVE WS-LOC-OFF-LEN            TO MI-CHG-COLUMN-VALUE-LEN    
                                             MI-PRV-COLUMN-VALUE-LEN.   
           MOVE WS-LOC-OFF-NEW            TO MI-CHG-COLUMN-VALUE-TEXT.  
           MOVE WS-LOC-OFF-OLD            TO MI-PRV-COLUMN-VALUE-TEXT.  
           MOVE WS-LOC-OFF-COLUMN         TO MI-COLUMN-DESC.            
                                                                        
      * PERFORM THE INSERT INTO THE TRANSACTION HIST AND DETAIL TABLES.         
           PERFORM 8740-INSERT-MH            THRU 8740-EXIT.            
           PERFORM 8750-INSERT-MI            THRU 8750-EXIT.            
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5510-GET-TIMESTAMP.                                           *         
      *                                                               *         
      *****************************************************************         
       5510-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
T24646         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRANS-HIST-SEQ-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-TRANS-HIST-SEQ-NO EQUAL LOW-VALUES                 
                   MOVE WS-NULL             TO WS-NULL-TRANS-HIST-SEQ-NO
               ELSE                                                     
                   MOVE WS-NOT-NULL         TO WS-NULL-TRANS-HIST-SEQ-NO
               END-IF                                                   
           ELSE                                                         
               DISPLAY '5510-GET-TIMESTAMP'                             
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       5510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  6400-BATCH-JRNL-ROUTINE(CPD00007)                          **         
      **  JOURNALLING COPYBOOK                                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00007                                                 
           END-EXEC.                                                            
      *                                                                         
P00778******************************************************************        
P00778* 7010-GET-DELINQUENCY                                           *        
P00778*  -- THIS MODULE RETRIEVES VALUES FROM CSS_DELINQUENCY.         *        
P00778******************************************************************        
P00778 7010-GET-DELINQUENCY.                                            
P00778*                                                                         
P00778     EXEC SQL                                                     
P00778          SELECT DELINQ_VALUE                                     
P00778            INTO :C8-DELINQ-VALUE                                 
P00778            FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
P00778           WHERE DELINQ_CD  = 'DATABASE'                          
P00778             AND COMPANY_NO = :C8-COMPANY-NO                      
P00778                                                           
P00778                                                      
P00778     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DELINQ_VALUE                                             
MFA-TR*           INTO :C8-DELINQ-VALUE                                         
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*          WHERE DELINQ_CD  = 'DATABASE'                                  
MFA-TR*            AND COMPANY_NO = :C8-COMPANY-NO                              
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7010                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00778*                                                                         
P00778     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00778*                                                                         
P00778     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00778        NEXT SENTENCE                                             
P00778     ELSE                                                         
P00778        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00778        MOVE '7010'                TO ACTIVE-PARAGRAPH            
P00778        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00778        MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
P00778        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00778        MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-2             
P00778        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00778        MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-2           
P00778        DISPLAY '******************************************'      
P00778        DISPLAY '**      PCSCA180 PROCESSING ERROR       **'      
P00778        DISPLAY '**   SELECT FOR DELINQUENCY FAILED      **'      
P00778        DISPLAY '**   SQLCODE WAS: ' WS-ACTIVE-RETURN-CODE        
P00778        DISPLAY '******************************************'      
P00778        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
P00778     END-IF.                                                      
P00778*                                                                         
P00778 7010-EXIT.                                                       
P00778     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7025-OPEN-ACCOUNT-PREM-CURSOR                             *         
      *     OPEN DRIVING CURSOR                                       *         
      *****************************************************************         
       7025-OPEN-ACCOUNT-PREM-CURSOR.                                   
      *                                                                         
           MOVE '7025' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              OPEN ACCT_PREM_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '**      PCSCA117 PROCESSING ERROR    **'        
               DISPLAY '**   COULD NOT OPEN ACCT/PREM CURSOR **'        
               DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE         
               DISPLAY '***************************************'        
               MOVE 'OPEN' TO ABEND-FUNCTION                            
               MOVE 'CSS_ACCOUNT' TO TABLE-1                            
               MOVE 'CSS_PREMISE' TO TABLE-2                            
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7050-FETCH-ACCOUNT-PREM-CURSOR                            *         
      *   FETCH DRIVING CURSOR INTO HOST VARIABLES                    *         
      *****************************************************************         
      *                                                                         
       7050-FETCH-ACCOUNT-PREM-CURSOR.                                  
      *                                                                         
           MOVE '7050' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              FETCH ACCT_PREM_CSR                                       
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-LOCAL-OFFICE,                                   
                    :AT-CODE-COMPANY-ACCT,                              
                    :AT-COMPANY-NO,                                     
                    :AT-PREMISE-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :PR-LOCAL-OFFICE,                                   
                    :PR-REV-DISTRICT-CD,                                
                    :PR-CODE-PREMISE-STAT,                              
                    :CU-CODE-EMPL-ACCT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE AT-LOCAL-OFFICE      TO WS-LOC-OFF-OLD              
               MOVE PR-LOCAL-OFFICE      TO WS-LOC-OFF-NEW              
ACT389         ADD  +1                   TO WS-COMMIT-ACCTS-CNT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-NO              TO WS-ACCOUNT-TO-PROCESS       
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '**      PCSCA117 PROCESSING ERROR       **'   
                 DISPLAY '**   FETCH FROM ACCT/PREM CURSOR FAILED **'   
                 DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE       
                 DISPLAY '******************************************'   
                 MOVE 'FETCH' TO ABEND-FUNCTION                         
                 MOVE 'CSS_ACCOUNT' TO TABLE-1                          
                 MOVE 'CSS_PREMISE' TO TABLE-2                          
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7075-CLOSE-ACCOUNT-PREM-CURSOR                            *         
      *   CLOSE DRIVING CURSOR                                        *         
      *****************************************************************         
      *                                                                         
       7075-CLOSE-ACCOUNT-PREM-CURSOR.                                  
      *                                                                         
           MOVE '7075' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE ACCT_PREM_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**      PCSCA117 PROCESSING ERROR     **'        
              DISPLAY '**   COULD NOT CLOSE ACCT/PREM CURSOR **'        
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '****************************************'        
              MOVE 'CLOSE' TO ABEND-FUNCTION                            
              MOVE 'CSS_ACCOUNT' TO TABLE-1                             
              MOVE 'CSS_PREMISE' TO TABLE-2                             
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7075-EXIT.                                                       
           EXIT.                                                        
P00778*                                                                         
P00778*****************************************************************         
P00778*     7080-OPEN-ACC-PREM-SEB-CUR                                *         
P00778*     OPEN DRIVING CURSOR FOR SEB                               *         
P00778*****************************************************************         
P00778 7080-OPEN-ACC-PREM-SEB-CUR.                                      
P00778*                                                                         
P00778     MOVE '7080' TO ACTIVE-PARAGRAPH.                             
P00778*                                                                         
P00778     EXEC SQL                                                     
P00778        OPEN ACCT_PREM_SEB                                        
P00778     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00778*                                                                         
P00778     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
P00778                     RS-RETURN-CODE,                              
P00778                     WS-DISP-RETURN-CODE.                         
P00778*                                                                         
P00778     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00778         NEXT SENTENCE                                            
P00778     ELSE                                                         
P00778         DISPLAY '***************************************'        
P00778         DISPLAY '**      PCSCA117 PROCESSING ERROR    **'        
P00778         DISPLAY '**   COULD NOT OPEN ACCT_PREM_SEB    **'        
P00778         DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE         
P00778         DISPLAY '***************************************'        
P00778         MOVE 'OPEN' TO ABEND-FUNCTION                            
P00778         MOVE 'CSS_ACCOUNT' TO TABLE-1                            
P00778         MOVE 'CSS_PREMISE' TO TABLE-2                            
P00778         PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
P00778     END-IF.                                                      
P00778*                                                                         
P00778 7080-EXIT.                                                       
P00778     EXIT.                                                        
P00778*                                                                         
P00778*****************************************************************         
P00778*     7085-FETCH-ACC-PREM-SEB-CUR                               *         
P00778*   FETCH DRIVING CURSOR INTO HOST VARIABLES                    *         
P00778*****************************************************************         
P00778*                                                                         
P00778 7085-FETCH-ACC-PREM-SEB-CUR.                                     
P00778*                                                                         
P00778     MOVE '7085' TO ACTIVE-PARAGRAPH.                             
P00778*                                                                         
P00778     EXEC SQL                                                     
P00778        FETCH ACCT_PREM_SEB                                       
P00778         INTO :AT-ACCOUNT-NO,                                     
P00778              :AT-CODE-ACCT-STAT,                                 
P00778              :AT-LOCAL-OFFICE,                                   
P00778              :AT-CODE-COMPANY-ACCT,                              
P00778              :AT-COMPANY-NO,                                     
P00778              :AT-PREMISE-NO,                                     
P00778              :AT-CUSTOMER-NO,                                    
P00778              :PR-LOCAL-OFFICE,                                   
P00778              :PR-REV-DISTRICT-CD,                                
P00778              :PR-CODE-PREMISE-STAT,                              
P00778              :CU-CODE-EMPL-ACCT                                  
P00778     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00778*                                                                         
P00778     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
P00778                     RS-RETURN-CODE,                              
P00778                     WS-DISP-RETURN-CODE.                         
P00778*                                                                         
P00778     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00778         MOVE AT-LOCAL-OFFICE      TO WS-LOC-OFF-OLD              
P00778         MOVE PR-LOCAL-OFFICE      TO WS-LOC-OFF-NEW              
P00778     ELSE                                                         
P00778        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00778           MOVE WS-NO              TO WS-ACCOUNT-TO-PROCESS       
P00778        ELSE                                                      
P00778           DISPLAY '********************************************' 
P00778           DISPLAY '**      PCSCA117 PROCESSING ERROR         **' 
P00778           DISPLAY '**   FETCH FROM ACCT_PREM_SEB CURSOR FAIL **' 
P00778           DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE       
P00778           DISPLAY '******************************************'   
P00778           MOVE 'FETCH' TO ABEND-FUNCTION                         
P00778           MOVE 'CSS_ACCOUNT' TO TABLE-1                          
P00778           MOVE 'CSS_PREMISE' TO TABLE-2                          
P00778           PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
P00778        END-IF                                                    
P00778     END-IF.                                                      
P00778*                                                                         
P00778 7085-EXIT.                                                       
P00778     EXIT.                                                        
P00778*                                                                         
P00778*****************************************************************         
P00778*     7090-CLOSE-ACC-PREM-SEB-CUR                               *         
P00778*   CLOSE DRIVING CURSOR                                        *         
P00778*****************************************************************         
P00778*                                                                         
P00778 7090-CLOSE-ACC-PREM-SEB-CUR.                                     
P00778*                                                                         
P00778     MOVE '7090' TO ACTIVE-PARAGRAPH.                             
P00778*                                                                         
P00778     EXEC SQL                                                     
P00778        CLOSE ACCT_PREM_SEB                                       
P00778     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00778*                                                                         
P00778     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
P00778                     RS-RETURN-CODE,                              
P00778                     WS-DISP-RETURN-CODE.                         
P00778*                                                                         
P00778     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00778        NEXT SENTENCE                                             
P00778     ELSE                                                         
P00778        DISPLAY '****************************************'        
P00778        DISPLAY '**      PCSCA117 PROCESSING ERROR     **'        
P00778        DISPLAY '**   COULD NOT CLOSE ACCT_PREM_SEB    **'        
P00778        DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
P00778        DISPLAY '****************************************'        
P00778        MOVE 'CLOSE' TO ABEND-FUNCTION                            
P00778        MOVE 'CSS_ACCOUNT' TO TABLE-1                             
P00778        MOVE 'CSS_PREMISE' TO TABLE-2                             
P00778        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
P00778     END-IF.                                                      
P00778*                                                                         
P00778 7090-EXIT.                                                       
P00778     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7125-OPEN-ARCURSOR                                        *         
      *     OPENS THE CURSOR SELECTING VALUES FROM AR_CNTL            *         
      *****************************************************************         
       7125-OPEN-ARCURSOR.                                              
      *                                                                         
           MOVE '7125' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              OPEN AR_CNTL_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '**      PCSCA117 PROCESSING ERROR    **'        
               DISPLAY '**   COULD NOT OPEN ARCNTL CURSOR    **'        
               DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE         
               DISPLAY '***************************************'        
               MOVE 'OPEN' TO ABEND-FUNCTION                            
               MOVE 'CSS_ARCNTL' TO TABLE-1                             
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7150-FETCH-ARCURSOR                                       *         
      *   FETCH ARCNTL ROWS FOR A PARTICULAR ACCOUNT                  *         
      *****************************************************************         
      *                                                                         
       7150-FETCH-ARCURSOR.                                             
      *                                                                         
           MOVE '7150' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              FETCH AR_CNTL_CURSOR                                      
               INTO :AC-PYMT-PRIORITY-LVL,                              
                    :AC-AMT-AR-DAY-00,                                  
                    :AC-AMT-AR-DAY-30,                                  
                    :AC-AMT-AR-DAY-60,                                  
                    :AC-AMT-AR-DAY-90,                                  
                    :AC-AMT-UNUSED-CR,                                  
                    :AC-AMT-TRAN-BALANCE,                               
                    :AC-TOT-SUMM-UNBILLED                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES             TO WS-NO-ARCNTL                
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '**      PCSCA117 PROCESSING ERROR       **'   
                 DISPLAY '**   FETCH FROM ARCNTL CURSOR FAILED    **'   
                 DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE       
                 DISPLAY '******************************************'   
                 MOVE 'FETCH' TO ABEND-FUNCTION                         
                 MOVE 'CSS_AR_CNTL' TO TABLE-1                          
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7175-CLOSE-ARCURSOR                                       *         
      *   CLOSE ARCNTL CURSOR                                         *         
      *****************************************************************         
      *                                                                         
       7175-CLOSE-ARCURSOR.                                             
      *                                                                         
           MOVE '7175' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE AR_CNTL_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**      PCSCA117 PROCESSING ERROR     **'        
              DISPLAY '**   COULD NOT CLOSE AR_CNTL CURSOR   **'        
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '****************************************'        
              MOVE 'CLOSE' TO ABEND-FUNCTION                            
              MOVE 'CSS_AR_CNTL' TO TABLE-1                             
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7175-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7225-OPEN-WOCURSOR                                        *         
      *     OPENS THE CURSOR SELECTING VALUES FROM CSS_CHRG_OFF       *         
      *****************************************************************         
       7225-OPEN-WOCURSOR.                                              
      *                                                                         
           MOVE '7225' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              OPEN WRITE_OFF_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '**      PCSCA117 PROCESSING ERROR    **'        
               DISPLAY '**   COULD NOT OPEN WRITE OFF CURSOR **'        
               DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE         
               DISPLAY '***************************************'        
               MOVE 'OPEN' TO ABEND-FUNCTION                            
               MOVE 'CSS_CHRG_OFF' TO TABLE-1                           
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7250-FETCH-WOCURSOR                                       *         
      *   FETCH CHRG_OFF ROWS FOR A PARTICULAR ACCOUNT                *         
      *****************************************************************         
      *                                                                         
       7250-FETCH-WOCURSOR.                                             
      *                                                                         
           MOVE '7250' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              FETCH WRITE_OFF_CURSOR                                    
               INTO :CO-AMT-TRANS,                                      
                    :CO-PYMT-PRIORITY-LVL,                              
                    :CO-ITEM-ID                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES             TO WS-NO-WRITEOFF              
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '**      PCSCA117 PROCESSING ERROR       **'   
                 DISPLAY '**   FETCH FROM WRITE OFF CURSOR FAILED **'   
                 DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE       
                 DISPLAY '******************************************'   
                 MOVE 'FETCH' TO ABEND-FUNCTION                         
                 MOVE 'CSS_CHRG_OFF' TO TABLE-1                         
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7275-CLOSE-WOCURSOR                                       *         
      *   CLOSE WRITE OFF CURSOR                                      *         
      *****************************************************************         
      *                                                                         
       7275-CLOSE-WOCURSOR.                                             
      *                                                                         
           MOVE '7275' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE WRITE_OFF_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**      PCSCA117 PROCESSING ERROR     **'        
              DISPLAY '**   COULD NOT CLOSE WRITE OFF CURSOR **'        
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '****************************************'        
              MOVE 'CLOSE' TO ABEND-FUNCTION                            
              MOVE 'CSS_CHRG_OFF' TO TABLE-1                            
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7275-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *     7325-OPEN-DEPOSIT-CURSOR                                  *         
      *     OPENS THE CURSOR SELECTING VALUES FROM CSS_DEP_ON_HAND    *         
      *****************************************************************         
       7325-OPEN-DEPOSITS-CURSOR.                                       
      *                                                                         
           MOVE '7325' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              OPEN DEPOSIT_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '**      PCSCA117 PROCESSING ERROR    **'        
               DISPLAY '**   COULD NOT OPEN DEPOSIT CURSOR   **'        
               DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE         
               DISPLAY '***************************************'        
               MOVE 'OPEN' TO ABEND-FUNCTION                            
               MOVE 'CSS_DEP_ON_HAND' TO TABLE-1                        
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7350-FETCH-DEPOSIT-CURSOR                                 *         
      *   FETCH CSS_DEP_ON_HAND ROWS FOR A PARTICULAR ACCOUNT         *         
      *****************************************************************         
      *                                                                         
       7350-FETCH-DEPOSITS-CURSOR.                                      
      *                                                                         
           MOVE '7350' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              FETCH DEPOSIT_CURSOR                                      
               INTO :DO-AMT-DEPOSIT,                                    
                    :DO-AMT-REFUNDED                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES             TO WS-NO-DEPOSIT               
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '**      PCSCA117 PROCESSING ERROR       **'   
                 DISPLAY '**   FETCH FROM DEPOSIT CURSOR FAILED   **'   
                 DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE       
                 DISPLAY '******************************************'   
                 MOVE 'FETCH' TO ABEND-FUNCTION                         
                 MOVE 'CSS_DEP_ON_HAND' TO TABLE-1                      
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7375-CLOSE-DEPOSITS-CURSOR                                *         
      *   CLOSE DEPOSIT CURSOR                                        *         
      *****************************************************************         
      *                                                                         
       7375-CLOSE-DEPOSITS-CURSOR.                                      
      *                                                                         
           MOVE '7375' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE DEPOSIT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**      PCSCA117 PROCESSING ERROR     **'        
              DISPLAY '**   COULD NOT CLOSE DEPOSIT CURSOR   **'        
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '****************************************'        
              MOVE 'CLOSE' TO ABEND-FUNCTION                            
              MOVE 'CSS_DEP_ON_HAND' TO TABLE-1                         
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7625-OPEN-PENDING-XFER-CURSOR                             *         
      *     OPENS THE CURSOR SELECTING VALUES FROM CSS_PENDING_XFER   *         
      *****************************************************************         
       7425-OPEN-PENDING-XFER-CURSOR.                                   
      *                                                                         
           MOVE '7425' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              OPEN PENDING_XFER_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '***************************************'        
               DISPLAY '**      PCSCA117 PROCESSING ERROR    **'        
               DISPLAY '**   COULD NOT OPEN PENDING XFER CSR **'        
               DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE         
               DISPLAY '***************************************'        
               MOVE 'OPEN' TO ABEND-FUNCTION                            
               MOVE 'CSS_PENDING_XFER' TO TABLE-1                       
               PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT         
           END-IF.                                                      
      *                                                                         
       7425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7450-FETCH-PENDING-XFER-CURSOR                            *         
      *   FETCH CSS_PENDING_XFER ROWS FOR A PARTICULAR ACCOUNT        *         
      *****************************************************************         
      *                                                                         
       7450-FETCH-PENDING-XFER-CURSOR.                                  
      *                                                                         
           MOVE '7450' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              FETCH PENDING_XFER_CSR                                    
               INTO :XP-ACCT-XFER-FROM,                                 
                    :XP-ACCT-XFER-TO,                                   
                    :XP-LOCAL-OFFICE,                                   
                    :XP-PARTITION-ID,                                   
                    :XP-PREMISE-NO,                                     
                    :XP-SEQUENCE-NO,                                    
                    :XP-SUB-ACCT-BLLD-OK,                               
                    :XP-TABLE-ID,                                       
                    :XP-XFER-DATA                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-YES             TO WS-NO-PENDING-XFER          
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '**      PCSCA117 PROCESSING ERROR       **'   
                 DISPLAY '**   FETCH FROM PENDING XFER CSR FAILED **'   
                 DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE       
                 DISPLAY '******************************************'   
                 MOVE 'FETCH' TO ABEND-FUNCTION                         
                 MOVE 'CSS_PENDING_XFER' TO TABLE-1                     
                 PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *     7475-CLOSE-PENDING-XFER-CURSOR                            *         
      *   CLOSE PENDING XFER CURSOR                                   *         
      *****************************************************************         
      *                                                                         
       7475-CLOSE-PENDING-XFER-CURSOR.                                  
      *                                                                         
           MOVE '7475' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE PENDING_XFER_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '****************************************'        
              DISPLAY '**      PCSCA117 PROCESSING ERROR     **'        
              DISPLAY '**   COULD NOT CLOSE PENDING XFER CSR **'        
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '****************************************'        
              MOVE 'CLOSE' TO ABEND-FUNCTION                            
              MOVE 'CSS_PENDING_XFER' TO TABLE-1                        
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       7475-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7600-SELET-CNT-GL                                     **              
      ************************************************************              
      *                                                                         
       7600-SELET-CNT-GL.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT WRT_OFF_GL_ACCT_NO                                
               INTO   :EA-WRT-OFF-GL-ACCT-NO                            
               FROM   CSS_CNT_DETAIL WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                 AND CNT_ITEM_ID = :CO-ITEM-ID                          
ACT046                                                           
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WRT_OFF_GL_ACCT_NO                                        
MFA-TR*        INTO   :EA-WRT-OFF-GL-ACCT-NO                                    
MFA-TR*        FROM   CSS_CNT_DETAIL                                            
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*          AND CNT_ITEM_ID = :CO-ITEM-ID                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PCSCA117 PROCESSING ERROR       **'          
               DISPLAY '** SELECT ERROR ON GL NO            *'          
               DISPLAY '** PARA 7600-SELET-CNT-GL          **'          
ACT046         DISPLAY 'ACCOUNT_NO      : ' AT-ACCOUNT-NO               
ACT046         DISPLAY 'CNT_ITEM_ID     : ' CO-ITEM-ID                  
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7700-ARCNTL-FIRST-AMT                                 **              
      **  SUM THE AMOUNT TO BE JOURNALLED FOR PAYMENT PRIORITY  **              
      **  LEVELS LESS THAN FIFTY.                               **              
      ************************************************************              
      *                                                                         
       7700-ARCNTL-FIRST-AMT.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT SUM(AMT_AR_DAY_00),                               
                      SUM(AMT_AR_DAY_30),                               
                      SUM(AMT_AR_DAY_60),                               
                      SUM(AMT_AR_DAY_90),                               
                      SUM(AMT_UNUSED_CR)                                
                 INTO :WS-SUM-00-DAY :WS-SUM-00-DAY-IND,                 
                      :WS-SUM-30-DAY :WS-SUM-30-DAY-IND,                 
                      :WS-SUM-60-DAY :WS-SUM-60-DAY-IND,                 
                      :WS-SUM-90-DAY :WS-SUM-90-DAY-IND,                 
                      :WS-SUM-UNUSED :WS-SUM-UNUSED-IND                  
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL < 50                            
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_AR_DAY_00),                                       
MFA-TR*               SUM(AMT_AR_DAY_30),                                       
MFA-TR*               SUM(AMT_AR_DAY_60),                                       
MFA-TR*               SUM(AMT_AR_DAY_90),                                       
MFA-TR*               SUM(AMT_UNUSED_CR)                                        
MFA-TR*          INTO :WS-SUM-00-DAY:WS-SUM-00-DAY-IND,                         
MFA-TR*               :WS-SUM-30-DAY:WS-SUM-30-DAY-IND,                         
MFA-TR*               :WS-SUM-60-DAY:WS-SUM-60-DAY-IND,                         
MFA-TR*               :WS-SUM-90-DAY:WS-SUM-90-DAY-IND,                         
MFA-TR*               :WS-SUM-UNUSED:WS-SUM-UNUSED-IND                          
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL < 50                                    
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF WS-SUM-00-DAY-IND EQUAL WS-NULL                       
                   MOVE ZERO         TO WS-SUM-00-DAY                   
               END-IF                                                   
               IF WS-SUM-30-DAY-IND EQUAL WS-NULL                       
                   MOVE ZERO         TO WS-SUM-30-DAY                   
               END-IF                                                   
               IF WS-SUM-60-DAY-IND EQUAL WS-NULL                       
                   MOVE ZERO         TO WS-SUM-60-DAY                   
               END-IF                                                   
               IF WS-SUM-90-DAY-IND EQUAL WS-NULL                       
                   MOVE ZERO         TO WS-SUM-90-DAY                   
               END-IF                                                   
               IF WS-SUM-UNUSED-IND EQUAL WS-NULL                       
                   MOVE ZERO         TO WS-SUM-UNUSED                   
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE ZERO         TO WS-SUM-00-DAY                   
                                        WS-SUM-30-DAY                   
                                        WS-SUM-60-DAY                   
                                        WS-SUM-90-DAY                   
                                        WS-SUM-UNUSED                   
               ELSE                                                     
                   DISPLAY '** PCSCA117 PROCESSING ERROR       **'      
                   DISPLAY '** SELECT AR CONTROL FIRST          *'      
                   DISPLAY '** PARA 7700-ARCNTL-FIRST-AMT      **'      
                   DISPLAY 'CSS_AR_CNTL'                                
                   DISPLAY AT-ACCOUNT-NO                                
                   DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
                   DISPLAY '** PROCESSING TERMINATED           **'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7710-ARCNTL-SECOND-AMT                                **              
      **  SUM THE AMOUNT TO BE JOURNALLED FOR PAYMENT PRIORITY  **              
      **  GREATER THAN FOURTY FIVE.                             **              
      ************************************************************              
      *                                                                         
       7710-ARCNTL-SECOND-AMT.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT SUM(AMT_TRAN_BALANCE)                             
                 INTO :WS-SUM-TRAN-BAL :WS-SUM-TRAN-BAL-IND              
                 FROM CSS_AR_CNTL                                       
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
                  AND PYMT_PRIORITY_LVL > 45                            
                  AND ITEM_ID           > 0                             
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRAN_BALANCE)                                     
MFA-TR*          INTO :WS-SUM-TRAN-BAL:WS-SUM-TRAN-BAL-IND                      
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL > 45                                    
MFA-TR*           AND ITEM_ID           > 0                                     
MFA-TR*        QUERYNO 7710                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF WS-SUM-TRAN-BAL-IND EQUAL WS-NULL                     
                   MOVE ZERO         TO WS-SUM-TRAN-BAL                 
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE ZERO         TO WS-SUM-TRAN-BAL                 
               ELSE                                                     
                   DISPLAY '** PCSCA117 PROCESSING ERROR       **'      
                   DISPLAY '** SELECT AR CONTROL FIRST          *'      
                   DISPLAY '** PARA 7710-ARCNTL-SECOND-AMT     **'      
                   DISPLAY 'CSS_AR_CNTL'                                
                   DISPLAY AT-ACCOUNT-NO                                
                   DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
                   DISPLAY '** PROCESSING TERMINATED           **'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7750-WRITE-OFF-AMT                                    **              
      **  SUM THE AMOUNT TO BE JOURNALLED FOR WRITTEN OFF       **              
      **  ACCOUNTS.                                             **              
      ************************************************************              
      *                                                                         
       7750-WRITE-OFF-AMT.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT SUM(AMT_TRANS)                                    
                 INTO :WS-SUM-AMT-TRANS :WS-SUM-AMT-TRANS-IND            
                 FROM CSS_CHRG_OFF                                      
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRANS)                                            
MFA-TR*          INTO :WS-SUM-AMT-TRANS:WS-SUM-AMT-TRANS-IND                    
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*        QUERYNO 7750                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF WS-SUM-AMT-TRANS-IND EQUAL WS-NULL                    
                   MOVE ZERO         TO WS-SUM-AMT-TRANS                
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE ZERO         TO WS-SUM-AMT-TRANS                
               ELSE                                                     
                   DISPLAY '** PCSCA117 PROCESSING ERROR       **'      
                   DISPLAY '** SELECT WRITTEN OFF AMOUNT        *'      
                   DISPLAY '** PARA 7750-WRITE-OFF-AMT         **'      
                   DISPLAY 'CSS_CHRG_OFF'                               
                   DISPLAY AT-ACCOUNT-NO                                
                   DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
                   DISPLAY '** PROCESSING TERMINATED           **'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7775-DEPOSIT-AMT                                      **              
      **  SUM THE AMOUNT TO BE JOURNALLED FOR ACCOUNTS WITH     **              
      **  DEPOSITS.                                             **              
      ************************************************************              
      *                                                                         
       7775-DEPOSIT-AMT.                                                
      *                                                                         
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                 INTO :WS-SUM-AMT-DEPOSIT :WS-SUM-AMT-DEPOSIT-IND        
                 FROM CSS_DEP_ON_HAND                                   
                WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :WS-SUM-AMT-DEPOSIT:WS-SUM-AMT-DEPOSIT-IND                
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                        
MFA-TR*        QUERYNO 7775                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF WS-SUM-AMT-DEPOSIT-IND EQUAL WS-NULL                  
                   MOVE ZERO         TO WS-SUM-AMT-DEPOSIT              
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE ZERO         TO WS-SUM-AMT-DEPOSIT              
               ELSE                                                     
                   DISPLAY '** PCSCA117 PROCESSING ERROR       **'      
                   DISPLAY '** SELECT DEPOSIT AMOUNT            *'      
                   DISPLAY '** PARA 7775-DEPOSIT-AMT           **'      
                   DISPLAY 'CSS_DEP_ON_HAND'                            
                   DISPLAY AT-ACCOUNT-NO                                
                   DISPLAY '** SQLCODE IS  ** ' SQLCODE                 
                   DISPLAY '** PROCESSING TERMINATED           **'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7775-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      **  7800-SELECT-GL-NO.                                    **              
      **      SELECTS GL NO FROM THE MNEMONICS.                 **              
      ************************************************************              
       7800-SELECT-GL-NO.                                               
      *                                                                         
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
               INTO   :GO-GL-ACCT-NO                                    
               FROM   CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                      
               WHERE GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
ACT046                                                           
ACT046                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GL_ACCT_NO                                                
MFA-TR*        INTO   :GO-GL-ACCT-NO                                            
MFA-TR*        FROM   CSS_GL_ACCT_NO                                            
MFA-TR*        WHERE GL_ACCT_NAME = :GO-GL-ACCT-NAME                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '** PCSCA117 PROCESSING ERROR       **'          
               DISPLAY '** SELECT ERROR ON GL NO            *'          
               DISPLAY '** PARA 7800-SELECT-GL-NO          **'          
               DISPLAY 'GO-GL-ACCT-NAME'                                
               DISPLAY GO-GL-ACCT-NAME                                  
               DISPLAY '** SQLCODE IS  ** ' SQLCODE                     
               DISPLAY '** PROCESSING TERMINATED           **'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
ACT012**   CHECK TO SEE IF ACCOUNT IS ON CSS_REG_PROFILE - SEB ONLY **          
      ****************************************************************          
      *                                                                         
ACT012 7805-SELECT-REG-PROFILE.                                         
      *                                                                         
ACT012     EXEC SQL                                                     
ACT012         SELECT REG_GROUP_CD                                      
ACT012               ,SENIOR_FL                                         
ACT012         INTO   :LR-REG-GROUP-CD                                  
ACT012               ,:LR-SENIOR-FL                                     
ACT012         FROM   CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
ACT012         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                        
ACT012                                                           
ACT012                                                      
ACT012     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*              ,SENIOR_FL                                                 
MFA-TR*        INTO   :LR-REG-GROUP-CD                                          
MFA-TR*              ,:LR-SENIOR-FL                                             
MFA-TR*        FROM   CSS_REG_PROFILE                                           
MFA-TR*        WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7805                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT012     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT012     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT012        MOVE WS-Y TO WS-REG-PROFILE-SW                            
ACT012     ELSE                                                         
ACT012        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT012           MOVE WS-N TO WS-REG-PROFILE-SW                         
ACT012        ELSE                                                      
ACT012           DISPLAY '** PCSCA117 PROCESSING ERROR    **'           
ACT012           DISPLAY '** SELECT ERROR                 **'           
ACT012           DISPLAY '** PARA 7805-SELECT-REG-PROFILE **'           
ACT012           DISPLAY 'LR-ACCOUNT-NO = ' LR-ACCOUNT-NO               
ACT012           DISPLAY '** SQLCODE IS  ** ' SQLCODE                   
ACT012           DISPLAY '** PROCESSING TERMINATED        **'           
ACT012           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT012        END-IF                                                    
ACT012     END-IF.                                                      
      *                                                                         
ACT012 7805-EXIT.                                                       
ACT012     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7925-OPEN-PRIORITY-CURSOR                                      *        
      *  OPENS THE CURSOR FOR LOADING AN INTERAL TABLE TO HOLD ALL OF  *        
      *  THE PYMT PRIORITY DESCRIPTIONS.                               *        
      ******************************************************************        
       7925-OPEN-PRIORITY-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN PRIORITY_DESC_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-PGRMNAME             TO ABEND-PROGRAM            
               MOVE '7900'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN PRIORITY_DESC_CSR' TO ABEND-FUNCTION          
               MOVE 'CSS_AR_TYPE'           TO TABLE-1                  
               MOVE SPACES                  TO TABLE-ELEMENT-1          
               DISPLAY '*****************************'                  
               DISPLAY '**7900-OPEN-PRIORITY-CURSOR**'                  
                       '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '*****************************'                  
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       7925-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7950-FETCH-PRIORITY-CURSOR.                                    *        
      *  FETCHES RECORDS BROUGHT BACK BY PRIORITY_DESC_CSR TO HOLD ALL *        
      *  OF THE PYMT PRIORITY DESC AND LVL IN TABLE CSS_AR_TYPE        *        
      ******************************************************************        
       7950-FETCH-PRIORITY-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH PRIORITY_DESC_CSR                                   
              INTO  :L5-PYMT-PRIORITY-LVL,                              
                    :L5-AR-TYPE-SHORT-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
               MOVE '7950'                   TO ACTIVE-PARAGRAPH        
               MOVE 'FETCH PRIORITY_DESC-CSR' TO ABEND-FUNCTION         
               MOVE 'CSS_AR_TYPE'            TO TABLE-1                 
               MOVE 'AR_TYPE_SHORT_DESC'     TO TABLE-ELEMENT-1         
               MOVE 'PYMT_PRIORITY_LVL'      TO TABLE-ELEMENT-2         
               MOVE L5-AR-TYPE-SHORT-DESC    TO HOSTVAR-ELEMENT-1       
               MOVE L5-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-2       
               DISPLAY '******************************'                 
               DISPLAY '**7950-FETCH-PRIORITY-CURSOR**'                 
                       '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '******************************'                 
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       7950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7975-CLOSE-PRIORITY-CURSOR                                     *        
      *  CLOSE THE CURSOR FOR LOADING AN INTERAL TABLE TO HOLD ALL OF  *        
      *  THE PYMT PRIORITY DESC. IN TABLE CSS_AR_TYPE                  *        
      *                                                                *        
      ******************************************************************        
       7975-CLOSE-PRIORITY-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE PRIORITY_DESC_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
               MOVE '7975'                   TO ACTIVE-PARAGRAPH        
               MOVE 'CLOSE PRIORITY_CURSOR'  TO ABEND-FUNCTION          
               MOVE 'CSS_AR_TYPE'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               DISPLAY '******************************'                 
               DISPLAY '**7020-CLOSE-PRIORITY-CURSOR**'                 
                       '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '******************************'                 
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       7975-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-UPDATE-PENDING-REFUNDS                                    *        
      *  UPDATE ANY PENDING REFUNDS TO THE NEW LOCAL OFFICE.           *        
      ******************************************************************        
       8000-UPDATE-PENDING-REFUNDS.                                     
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_REFUND                                         
                 SET LOCAL_OFFICE    = :WS-LOC-OFF-NEW                  
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
                 AND CHECK_STATUS_CD = :WS-PENDING                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
               MOVE '8000'                   TO ACTIVE-PARAGRAPH        
               MOVE 'UPDATE CSS_REFUND'      TO ABEND-FUNCTION          
               MOVE 'CSS_REFUND'             TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               DISPLAY '*******************************'                
               DISPLAY '**8000-UPDATE-PENDING-REFUNDS**'                
                       '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '*******************************'                
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-UPDATE-MF-SERVICE-ORDERS                                  *        
      *  UPDATE ROWS ON CSS_SO_DATA_MF TO THE NEW LOCAL OFFICE.        *        
      ******************************************************************        
       8100-UPDATE-MF-SERVICE-ORDERS.                                   
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA_MF                                     
                 SET LOCAL_OFFICE    = :WS-LOC-OFF-NEW                  
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
               MOVE '8100'                   TO ACTIVE-PARAGRAPH        
               MOVE 'UPDATE CSS_SO_DATA_MF'  TO ABEND-FUNCTION          
               MOVE 'CSS_SO_DATA_MF'         TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               DISPLAY '*********************************'              
               DISPLAY '**8100-UPDATE-MF-SERVICE-ORDERS **'             
                       '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '*********************************'              
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
ACT257*                                                                         
ACT257******************************************************************        
ACT257* 8150-UPDATE-SERVICE-ORDERS                                     *        
ACT257*  UPDATE ROWS ON CSS_SO_DATA    TO THE NEW LOCAL OFFICE.        *        
ACT257******************************************************************        
ACT257 8150-UPDATE-SERVICE-ORDERS.                                      
ACT257*                                                                         
ACT257     EXEC SQL                                                     
ACT257        UPDATE CSS_SO_DATA                                        
ACT257           SET LOCAL_OFFICE    = :WS-LOC-OFF-NEW                  
ACT257         WHERE PREMISE_NO      = :AT-PREMISE-NO                   
ACT257     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT257                                                                  
ACT257     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT257     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT257         NEXT SENTENCE                                            
ACT257     ELSE                                                         
ACT257         MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
ACT257         MOVE '8150'                   TO ACTIVE-PARAGRAPH        
ACT257         MOVE 'UPDATE CSS_SO_DATA'     TO ABEND-FUNCTION          
ACT257         MOVE 'CSS_SO_DATA'            TO TABLE-1                 
ACT257         MOVE SPACES                   TO TABLE-ELEMENT-1         
ACT257         DISPLAY '*********************************'              
ACT257         DISPLAY '**8150-UPDATE-SERVICE-ORDERS**'                 
ACT257                 '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT257         DISPLAY '*********************************'              
ACT257         PERFORM 9900-ABEND                  THRU 9900-EXIT       
ACT257     END-IF.                                                      
ACT257*                                                                         
ACT257 8150-EXIT.                                                       
ACT257     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-INSERT-PEND-XFER                                          *        
      *  INSERT A ROW WITH THE NEW LOCAL OFFICE INTO CSS_PENDING_XFER. *        
      ******************************************************************        
       8300-INSERT-PEND-XFER.                                           
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_PENDING_XFER                              
                  VALUES (:XP-ACCT-XFER-TO,                             
                          :XP-TABLE-ID,                                 
                          :XP-PARTITION-ID,                             
                          :WS-LOC-OFF-NEW,                              
                          :XP-PREMISE-NO,                               
                          :XP-SEQUENCE-NO,                              
                          :XP-SUB-ACCT-BLLD-OK,                         
                          :XP-ACCT-XFER-FROM,                           
                          :XP-XFER-DATA)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
               MOVE '8300'                   TO ACTIVE-PARAGRAPH        
               MOVE 'INSERT PENDING_XFER'    TO ABEND-FUNCTION          
               MOVE 'CSS_PENDING_XFER'       TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               DISPLAY '***************************'                    
               DISPLAY '** 8300-INSERT-PEND-XFER **'                    
                       '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '***************************'                    
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8400-DELETE-PEND-XFER                                          *        
      *  DELETE A ROW WITH THE OLD LOCAL OFFICE FROM CSS_PENDING_XFER. *        
      ******************************************************************        
       8400-DELETE-PEND-XFER.                                           
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM CSS_PENDING_XFER                              
                 WHERE ACCT_XFER_FROM = :XP-ACCT-XFER-FROM              
                   AND LOCAL_OFFICE   = :WS-LOC-OFF-OLD                 
                   AND SEQUENCE_NO    = :XP-SEQUENCE-NO                 
                   AND ACCT_XFER_TO   = :AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
               MOVE '8400'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE PENDING_XFER'    TO ABEND-FUNCTION          
               MOVE 'CSS_PENDING_XFER'       TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               DISPLAY '***************************'                    
               DISPLAY '** 8400-DELETE-PEND-XFER **'                    
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               DISPLAY '***************************'                    
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8500-UPDATE-ACCOUNT-TABLE                                      *        
      *  UPDATE ROWS ON CSS_ACCOUNT TO THE NEW LOCAL OFFICE.           *        
      ******************************************************************        
       8500-UPDATE-ACCOUNT-TABLE.                                       
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET LOCAL_OFFICE    = :WS-LOC-OFF-NEW,                 
                     LAST_UPDATE_TS  = CIS.CHAR2TIMESTAMP(
                                                  :WS-TRANS-HIST-SEQ-NO
              )            
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET LOCAL_OFFICE    = :WS-LOC-OFF-NEW,                         
MFA-TR*              LAST_UPDATE_TS  = :WS-TRANS-HIST-SEQ-NO                    
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
               MOVE '8500'                   TO ACTIVE-PARAGRAPH        
               MOVE 'UPDATE CSS_ACCOUNT'     TO ABEND-FUNCTION          
               MOVE 'CSS_ACCOUNT'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               DISPLAY '********************************'               
               DISPLAY '** 8500-UPDATE-ACCOUNT-TABLES **'               
                       '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '********************************'               
               PERFORM 9900-ABEND                  THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
ACT012*  UPDATE ROW ON CSS_PREMISE TO THE NEW LOCAL OFFICE.          *          
      ****************************************************************          
      *                                                                         
ACT012 8510-UPDATE-PREMISE-TABLE.                                       
      *                                                                         
ACT012     EXEC SQL                                                     
ACT012        UPDATE CSS_PREMISE                                        
ACT012           SET LOCAL_OFFICE    = :WS-LOC-OFF-NEW                  
ACT012              ,LAST_UPDATE_TS  = CIS.CHAR2TIMESTAMP(
                                                  :WS-TRANS-HIST-SEQ-NO
              )            
ACT012         WHERE PREMISE_NO      = :PR-PREMISE-NO                   
ACT012     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_PREMISE                                                
MFA-TR*          SET LOCAL_OFFICE    = :WS-LOC-OFF-NEW                          
MFA-TR*             ,LAST_UPDATE_TS  = :WS-TRANS-HIST-SEQ-NO                    
MFA-TR*        WHERE PREMISE_NO      = :PR-PREMISE-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
ACT012     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT012     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT012        NEXT SENTENCE                                             
ACT012     ELSE                                                         
ACT012        MOVE WS-PGRMNAME              TO ABEND-PROGRAM            
ACT012        MOVE '8510'                   TO ACTIVE-PARAGRAPH         
ACT012        MOVE 'UPDATE CSS_PREMISE'     TO ABEND-FUNCTION           
ACT012        MOVE 'CSS_PREMISE'            TO TABLE-1                  
ACT012        MOVE SPACES                   TO TABLE-ELEMENT-1          
ACT012        DISPLAY '********************************'                
ACT012        DISPLAY '** 8510-UPDATE-PREMISE-TABLE  **'                
ACT012                '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE         
ACT012                '** PREMISE NO  = ' PR-PREMISE-NO                 
ACT012                '** NEW LOCAL OFFICE = ' WS-LOC-OFF-NEW           
ACT012        DISPLAY '********************************'                
ACT012        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT012     END-IF.                                                      
      *                                                                         
ACT012 8510-EXIT.                                                       
ACT012     EXIT.                                                        
      *                                                                         
T26323******************************************************************        
T26323* 8550-UPDATE-NAME-ACCT-XREF                                     *        
T26323*  UPDATE ROWS ON CSS_NAME_ACCT_XREF FOR LOCAL OFFICE.           *        
T26323******************************************************************        
T26323 8550-UPDATE-NAME-ACCT-XREF.                                      
T26323     EXEC SQL                                                     
T26323        UPDATE CSS_NAME_ACCT_XREF                                 
T26323           SET LOCAL_OFFICE    = :WS-LOC-OFF-NEW                  
T26323         WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
T26323         AND   PREMISE_NO      = :AT-PREMISE-NO                   
T26323         AND   CUSTOMER_NO     = :AT-CUSTOMER-NO                  
T26323     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26323                                                                  
T26323     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T26323     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T26323         NEXT SENTENCE                                            
T26323     ELSE                                                         
T26323         MOVE WS-PGRMNAME              TO ABEND-PROGRAM           
T26323         MOVE '8550'                   TO ACTIVE-PARAGRAPH        
T26323         MOVE 'UPDATE NAME_ACCT_XREF'  TO ABEND-FUNCTION          
T26323         MOVE 'CSS_NAME_ACCT_XREF'     TO TABLE-1                 
T26323         MOVE SPACES                   TO TABLE-ELEMENT-1         
T26323         DISPLAY '********************************'               
T26323         DISPLAY '** 8550-UPDATE--NAME-ACCT-XREF. '               
T26323         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
T26323         DISPLAY '** ACCOUNT NO  = ' AT-ACCOUNT-NO                
T26323         DISPLAY '********************************'               
T26323         PERFORM 9900-ABEND                  THRU 9900-EXIT       
T26323     END-IF.                                                      
T26323 8550-EXIT.                                                       
T26323      EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *   8740-INSERT-MH                                              *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF MH TABLE.                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8740-INSERT-MH.                                                  
      *                                                                         
           MOVE '8740' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MNT_TRANS_HIST                            
                    (ACCOUNT_NO,                                        
                     APPL_PROGRAM_ID,                                   
                     CODE_TRAN_TYPE,                                    
                     CUSTOMER_NO,                                       
                     DATE_TRANS,                                        
                     ENTITY_KEY_DESC,                                   
                     PREMISE_NO,                                        
                     RESP_AREA_ID,                                      
                     TRAN_COMMENT,                                      
                     TRANS_HIST_SEQ_NO,                                 
                     USER_ID)                                           
              VALUES                                                    
                    (:MH-ACCOUNT-NO,                                    
                     :MH-APPL-PROGRAM-ID,                               
                     :MH-CODE-TRAN-TYPE,                                
                     :MH-CUSTOMER-NO,                                   
                     IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS 
                                           :WS-NULL-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS 
                                                    :WS-NULL-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS :WS-NULL-DATE-TRANS
              ) <> 10), CIS.CHAR2DATE(:MH-DATE-TRANS 
                                                    :WS-NULL-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS :WS-NULL-DATE-TRANS) ),          
                     :MH-ENTITY-KEY-DESC,                               
                     :MH-PREMISE-NO,                                    
                     :MH-RESP-AREA-ID,                                  
                     :MH-TRAN-COMMENT,                                  
                     CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO 
                                        :WS-NULL-TRANS-HIST-SEQ-NO),   
                     :MH-USER-ID)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MNT_TRANS_HIST                                    
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              APPL_PROGRAM_ID,                                           
MFA-TR*              CODE_TRAN_TYPE,                                            
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              DATE_TRANS,                                                
MFA-TR*              ENTITY_KEY_DESC,                                           
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              RESP_AREA_ID,                                              
MFA-TR*              TRAN_COMMENT,                                              
MFA-TR*              TRANS_HIST_SEQ_NO,                                         
MFA-TR*              USER_ID)                                                   
MFA-TR*       VALUES                                                            
MFA-TR*             (:MH-ACCOUNT-NO,                                            
MFA-TR*              :MH-APPL-PROGRAM-ID,                                       
MFA-TR*              :MH-CODE-TRAN-TYPE,                                        
MFA-TR*              :MH-CUSTOMER-NO,                                           
MFA-TR*              :MH-DATE-TRANS:WS-NULL-DATE-TRANS,                         
MFA-TR*              :MH-ENTITY-KEY-DESC,                                       
MFA-TR*              :MH-PREMISE-NO,                                            
MFA-TR*              :MH-RESP-AREA-ID,                                          
MFA-TR*              :MH-TRAN-COMMENT,                                          
MFA-TR*              :MH-TRANS-HIST-SEQ-NO:WS-NULL-TRANS-HIST-SEQ-NO,           
MFA-TR*              :MH-USER-ID)                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA699 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO MH TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '*******************************************'     
              MOVE 'INSERT' TO ABEND-FUNCTION                           
              MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       8740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *   8750-INSERT-MI                                              *         
      *                                                               *         
      *   PERFORMS DB2 INSERT OF MI TABLE.                            *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       8750-INSERT-MI.                                                  
      *                                                                         
           MOVE '8750' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_MT_TRN_HST_DET                            
                    (CHG_COLUMN_VALUE,                                  
                     COLUMN_DESC,                                       
                     PRV_COLUMN_VALUE,                                  
                     TABLE_ID,                                          
                     TRAN_APPL_NO,                                      
                     TRANS_HIST_SEQ_NO)                                 
              VALUES                                                    
                    (:MI-CHG-COLUMN-VALUE,                              
                     :MI-COLUMN-DESC,                                   
                     :MI-PRV-COLUMN-VALUE,                              
                     :MI-TABLE-ID,                                      
                     :MI-TRAN-APPL-NO,                                  
                     CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO 
                                        :WS-NULL-TRANS-HIST-SEQ-NO))   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MT_TRN_HST_DET                                    
MFA-TR*             (CHG_COLUMN_VALUE,                                          
MFA-TR*              COLUMN_DESC,                                               
MFA-TR*              PRV_COLUMN_VALUE,                                          
MFA-TR*              TABLE_ID,                                                  
MFA-TR*              TRAN_APPL_NO,                                              
MFA-TR*              TRANS_HIST_SEQ_NO)                                         
MFA-TR*       VALUES                                                            
MFA-TR*             (:MI-CHG-COLUMN-VALUE,                                      
MFA-TR*              :MI-COLUMN-DESC,                                           
MFA-TR*              :MI-PRV-COLUMN-VALUE,                                      
MFA-TR*              :MI-TABLE-ID,                                              
MFA-TR*              :MI-TRAN-APPL-NO,                                          
MFA-TR*              :MI-TRANS-HIST-SEQ-NO:WS-NULL-TRANS-HIST-SEQ-NO)           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE,                       
                           RS-RETURN-CODE,                              
                           WS-DISP-RETURN-CODE.                         
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA699 PROCESSING ERROR           **'     
              DISPLAY '**   INSERT TO MI TABLE FAILED           **'     
              DISPLAY '**   SQLCODE WAS: ' WS-DISP-RETURN-CODE          
              DISPLAY '*******************************************'     
              MOVE 'INSERT' TO ABEND-FUNCTION                           
              MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
       8750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  8800-UPDATE-BATCH-CNTL                                     **         
      **  UPDATE THE BATCH CONTROL FOR EACH ACCOUNT                  **         
      *****************************************************************         
      *                                                                         
       8800-UPDATE-BATCH-CNTL.                                          
      *                                                                         
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST.           
                                                                        
           PERFORM 6400-BATCH-JRNL-ROUTINE           THRU 6400-EXIT.    
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PCSCA117 JOURNALLING ERROR'                 
               DISPLAY '**  PARAGRAPH = 8800-'                          
               DISPLAY '**  RC        = ' WS-JRNL-RTRN-CODE             
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT389 8850-ISSUE-COMMIT.                                               
ACT389*                                                                         
ACT389     ADD 1                            TO WS-CHKP-SEQ-NO.          
ACT389*                                                                         
ACT389     EXEC SQL                                                     
ACT389         COMMIT                                                   
ACT389     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT389*                                                                         
ACT389     DISPLAY 'LAST ACCT COMMITTED' AT-ACCOUNT-NO  .               
ACT389     DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.' .         
ACT389*                                                                         
ACT389 8850-EXIT.                                                       
ACT389     EXIT.                                                        
      *                                                                         
ACT112*****************************************************************         
ACT112**  8900-WRITE-SKIP-HEADERS.                                   **         
ACT112**  WRITE HEADER RECORD TO THE OUTPUT FILE                     **         
ACT112*****************************************************************         
      *                                                                         
ACT112 8900-WRITE-SKIP-HEADERS.                                         
      *                                                                         
ACT112     INITIALIZE PRT331-RECORD.                                    
ACT112     WRITE PRT331-RECORD     FROM WS-SKIP-HEADER-REC.             
      *                                                                         
ACT112     IF FPT331-SUCCESSFUL                                         
ACT112        CONTINUE                                                  
ACT112     ELSE                                                         
ACT112        DISPLAY '********* PCSCA117 ********************'         
ACT112        DISPLAY '8900-WRITE-SKIP-HEADERS.     STATUS IS '         
ACT112                 WS-FCA331-STATUS                                 
ACT112        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT112        DISPLAY '********* PCSCA117 ********************'         
ACT112     END-IF.                                                      
      *                                                                         
ACT112 8900-EXIT.                                                       
ACT112      EXIT.                                                       
ACT112*****************************************************************         
ACT112**   8950-WRITE-SKIP-DETAIL-REC.                               **         
ACT112**  WRITES DATA LINES TO THE OUTPUT FILE                       **         
ACT112*****************************************************************         
      *                                                                         
ACT112 8950-WRITE-SKIP-DETAIL-REC.                                      
      *                                                                         
ACT112     INITIALIZE PRT331-RECORD.                                    
ACT112     WRITE PRT331-RECORD     FROM WS-SKIP-DETAIL-REC.             
      *                                                                         
ACT112     IF FPT331-SUCCESSFUL                                         
ACT112        CONTINUE                                                  
ACT112     ELSE                                                         
ACT112        DISPLAY '********* PCSCA117 ********************'         
ACT112        DISPLAY '8950-WRITE-SKIP-DETAIL-REC.  STATUS IS '         
ACT112                 WS-FCA331-STATUS                                 
ACT112        PERFORM 9900-ABEND THRU 9900-EXIT                         
ACT112        DISPLAY '********* PCSCA117 ********************'         
ACT112     END-IF.                                                      
      *                                                                         
ACT112 8950-EXIT.                                                       
ACT112      EXIT.                                                       
      *****************************************************************         
      **  9000-TERMINATE                                             **         
      **  DISPLAY MESSAGE WHEN NO ACCOUNTS HAVE BEEN PROCESSED.      **         
      *****************************************************************         
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           IF ACCOUNT-PROCESSED                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*******************************'                
               DISPLAY '**   NO ACCOUNTS PROCESSED   **'                
               DISPLAY '*******************************'                
           END-IF.                                                      
      *                                                                         
ACT112     CLOSE FCSPT331-FILE.                                         
                                                                        
ACT112     IF  FPT331-SUCCESSFUL                                        
ACT112         CONTINUE                                                 
ACT112     ELSE                                                         
ACT112         DISPLAY '********** PCSCA117    ABORT ************'      
ACT112         DISPLAY '* 9000-TERMINATE                        *'      
ACT112         DISPLAY 'ERROR IN CLOSING FCSCA331 FILE'                 
ACT112         DISPLAY 'ERROR STATUS ' WS-FCA331-STATUS                 
ACT112         DISPLAY 'ACCOUNT NO   ' WS-SKIP-ACCT-NO                  
ACT112         DISPLAY '********** PCSCA117    ABORT ************'      
ACT112         PERFORM 9900-ABEND               THRU 9900-EXIT          
ACT112     END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  9700-PROCESS-ABEND                                         **         
      *****************************************************************         
      *                                                                         
           COPY CPD0023B.                                                       
      *                                                                         
      *****************************************************************         
      **  9900-ABEND                                                 **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
