       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA116.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      **  THIS PROGRAM CHECKS THE COMMON RUN DATE FROM CSS_JOB_PARM  **         
      **  AGAINST THE RUN DATE FOR PCSCA116 TO BE SURE IT HAS NOT    **         
      **  BEEN EDITED.  THEN IT FINDS THE NEXT BUSINESS DAY,         **         
      **  SKIPPING HOLIDAYS AND WEEKENDS.  THERE IS ALSO A CHECK     **         
      **  THAT THE NEW BUSINESS DAY IS NOT MORE THAN MAX-DAY-DIFF    **         
      **  DAYS NEWER THAN THE OLD ONE, WHERE MAX-DAY-DIFF IS ALSO    **         
      **  A PARAMETER FROM CSS_JOB_PARM FOR PCSCA116.  FINALLY,      **         
      **  IT UPDATES THE TABLE WITH THE NEW BUSINESS DAY, AND ALSO   **         
      **  SAVES THE LAST RUN DATE.                                   **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS   REASON                                **         
      *    ----     --------   ------                                **         
PC473 *   01/07/98    AMG      ADDED LOGIC TO UPDATE THE REVENUE     **         
      *                        MONTH IN CSS_JOB_PARM FOR 'COMMON'    **         
T15791*   04/21/98    AMG      -CHANGED LOGIC SO THAT THE REVENUE    **         
T15791*                        MONTH IS UPDATED CORRECTLY (AT THE    **         
T15791*                        OPEN OF CYCLE 01 FOR A GIVEN MONTH)   **         
T15791*                        -ALSO PUT IN A CHECK TO BE SURE THAT  **         
T15791*                        THE CURRENT REVENUE MONTH IS CORRECT  **         
T15791*                        WHEN NOT UPDATING IT                  **         
C35227*   02/21/07   DB41297   REPLACE MODEL_SQL CALLS WITH DB2 SET  **         
      *                        STATEMENTS.                           **         
      *****************************************************************         
      **          ---- BASIC SEQUENCE STRUCTURE ----                 **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **         
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*         
      **                                                             **         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
      *SOURCE-COMPUTER.    IBM-370.                                             
       OBJECT-COMPUTER.    IBM-370.                                     
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
     *                                                                  
       DATA DIVISION.                                                   
     *                                                                  
       FILE SECTION.                                                    
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA116'.
MSQ017     COPY MFASQLM.
       01  WS-INPUT-DATA-R116.                                          
           10  WS-SYSIPT-RUN-DATE-R116         PIC  X(08).              
               88  RUN-DATE-R116                                        
                   VALUE 'RUN DATE'.                                    
           10  FILLER                          PIC  X(01).              
           10  WS-INPUT-RUN-DATE-R116.                                  
               15  WS-INPUT-RUN-DATE-R116-CC   PIC  X(02).              
               15  WS-INPUT-RUN-DATE-R116-YY   PIC  X(02).              
               15  FILLER                      PIC  X(01).              
               15  WS-INPUT-RUN-DATE-R116-MM   PIC  X(02).              
               15  FILLER                      PIC  X(01).              
               15  WS-INPUT-RUN-DATE-R116-DD   PIC  X(02).              
           10  FILLER                          PIC  X(01).              
           10  WS-SYSIPT-LAST-DATE-R116        PIC  X(13).              
               88  LAST-DATE-R116                                       
                   VALUE 'LAST RUN DATE'.                               
           10  FILLER                          PIC  X(01).              
           10  WS-INPUT-LAST-DATE-R116.                                 
               15  WS-INPUT-LAST-DATE-R116-CC  PIC  X(02).              
               15  WS-INPUT-LAST-DATE-R116-YY  PIC  X(02).              
               15  FILLER                      PIC  X(01).              
               15  WS-INPUT-LAST-DATE-R116-MM  PIC  X(02).              
               15  FILLER                      PIC  X(01).              
               15  WS-INPUT-LAST-DATE-R116-DD  PIC  X(02).              
           10  FILLER                          PIC  X(36).              
      *                                                                         
       01  WS-INPUT-MAX-DIFF.                                           
           10  WS-SYSIPT-MAX-DIFF              PIC  X(12).              
               88  MAX-DAY-DIFF                                         
                 VALUE 'MAX DAY DIFF'.                                  
           10  FILLER                          PIC  X(01).              
           10  WS-MAX-DAY-DIFF                 PIC  9(02).              
           10  FILLER                          PIC  X(65).              
      *                                                                         
PC473  01  WS-INPUT-REV-MONTH.                                          
PC473      10  WS-SYSIPT-REV-MONTH             PIC  X(13).              
PC473          88  REV-MONTH-FOUND                                      
PC473            VALUE 'REVENUE-MONTH'.                                 
PC473      10  FILLER                          PIC  X(01).              
PC473      10  WS-INPUT-FULL-REV-MONTH.                                 
PC473          15  WS-REV-MONTH-CC             PIC  X(02).              
PC473          15  WS-REV-MONTH-YY             PIC  X(02).              
PC473          15  WS-REV-MONTH-MM             PIC  X(02).              
T15791     10  WS-REV-MONTH-NUMERIC REDEFINES WS-INPUT-FULL-REV-MONTH   
T15791                                         PIC  9(06).              
PC473      10  FILLER                          PIC  X(60).              
                                                                        
      *                                                                         
       01  WS-COMMON-DATE.                                              
           10  FILLER                          PIC  X(08)               
                 VALUE 'RUN DATE'.                                      
           10  FILLER                          PIC  X(01) VALUE '='.    
           10  WS-COMMON-DATE-VALUE            PIC  X(10) VALUE SPACES. 
           10  FILLER                          PIC  X(61) VALUE SPACES. 
      *                                                                         
PC473  01  WS-REVENUE-MONTH.                                            
PC473      10  FILLER                          PIC  X(13)               
PC473            VALUE 'REVENUE-MONTH'.                                 
PC473      10  FILLER                          PIC  X(01) VALUE '='.    
PC473      10  WS-REV-MONTH-VALUE              PIC  X(06) VALUE SPACES. 
PC473      10  FILLER                          PIC  X(60) VALUE SPACES. 
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-NO                       PIC X(01) VALUE 'N'.         
           05  WS-YES                      PIC X(01) VALUE 'Y'.         
           05  RS-RETURN-CODE              PIC S9(04) COMP.             
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-SYS-DATE                 PIC X(10).                   
           05  WS-CURRENT-DATE             PIC X(10).                   
T15791     05  WS-CURRENT-REV-MONTH        PIC 9(06).                   
           05  WS-NEW-DATA-R116            PIC X(80).                   
           05  WS-DAY-SPAN                 PIC S9(04) COMP.             
COB305     05 WS-DATE-SEQ        PIC S9999V USAGE COMP-3 VALUE 0.     
COB305     05 WS-REV-SEQ        PIC S9999V USAGE COMP-3 VALUE 0.     
COB305     05 WS-COMMON-DATE-SEQ        PIC S9999V USAGE COMP-3 VALUE 0.     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME         PIC  X(10) VALUE 'PCSCA116  '.       
           05  WS-COMMON-NAME      PIC  X(10) VALUE 'COMMON    '.       
           05  WS-PCSCA116-NAME    PIC  X(10) VALUE 'PCSCA116  '.       
                                                                        
      ***********  FIOJC01 CONTAINS WS-IO INFORMATION  *************            
       COPY FIOJC01.                                                            
      **************************************************************            
                                                                        
      ******* CWS00303 CONTAINS ALL WS-WARNING DATA ELEMENTS *******            
       COPY CWS00303.                                                           
      **************************************************************            
                                                                        
      ***********  DECLARATIONS OF ALL ABEND WS INFO ***************            
       COPY CWS00010.                                                           
       COPY CWS09900.                                                           
      **************************************************************            
                                                                        
       COPY FIOCA00.                                                            
                                                                        
      ****** CWS00038 CONTAINS WS FOR READING FROM JOB PARM ********            
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
      ****************************************************************          
                                                                        
           EXEC SQL                                                             
             INCLUDE CWS00039                                                   
           END-EXEC.                                                            
                                                                        
      ****** CWS00315 CONTAINS WS FOR FINDING NEXT BUSINESS DAY ****            
           EXEC SQL                                                             
             INCLUDE CWS00315                                                   
           END-EXEC.                                                            
      ****************************************************************          
                                                                        
      ****** INCLUDE SQL COMMUNICATIONS AREA *************************          
            EXEC SQL                                                            
                 INCLUDE SQLCA                                                  
            END-EXEC.                                                           
      ****************************************************************          
                                                                        
      ****** TABLE DECLARATION FOR CSS_JOB_PARM **********************          
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      ****************************************************************          
                                                                        
      ****** TABLE DECLARATION FOR CSS_HOLIDAY ***********************          
           EXEC SQL                                                             
             INCLUDE TBHLDAY                                                    
           END-EXEC.                                                            
      ****************************************************************          
      ****************************************************************          
                                                                        
T15791****** TABLE DECLARATION FOR CSS_BILL_WINDOW *******************          
T15791     EXEC SQL                                                             
T15791       INCLUDE TBBILWDW                                                   
T15791     END-EXEC.                                                            
T15791****************************************************************          
                                                                        
       PROCEDURE DIVISION.                                              
      *****************************************************************         
      *                                                              **         
      *    0000-MAINLINE                                             **         
      *                                                              **         
      *    CONTROLS MAIN OPERATION OF THE PROGRAM                    **         
      *                                                              **         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
      *                                                                         
           PERFORM 6500-GET-NEXT-BUSINESS-DAY                           
              THRU 6500-NEXT-BUSINESS-DAY-EXIT                          
               UNTIL NEXT-BUSINESS-DAY-FOUND.                           
      *                                                                         
           PERFORM 2150-CHECK-FOR-FUTURE   THRU 2150-EXIT.              
      *                                                                         
           PERFORM 2200-CHECK-TIME-SPAN    THRU 2200-EXIT.              
      *                                                                         
           PERFORM 7000-UPDATE-DATES       THRU 7000-EXIT.              
      *                                                                         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    0100-INITIALIZATION                                       **         
      *                                                              **         
      *    GETS THE RUN DATE AND LAST RUN DATE FOR PCSCA116.         **         
      *    IF THAT IS FOUND, THEN THE COMMON DATE IS ALSO FOUND.     **         
      *    OTHERWISE, THE PROGRAM ABENDS.                            **         
      *****************************************************************         
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT.            
      *                                                                         
           IF OVERRIDE-DATE-LOADED                                      
              MOVE G6-SEQ-NO                 TO WS-DATE-SEQ             
              MOVE WS-INPUT-DATA-BREAKDOWN   TO WS-INPUT-DATA-R116      
              MOVE WS-INPUT-RUN-DATE-R116    TO WS-NEW-BUSINESS-DAY     
              MOVE WS-COMMON-NAME            TO WS-PGRMNAME             
              MOVE SPACES                    TO WS-INPUT-AREA           
              MOVE SPACES                    TO WS-INPUT-DATA-BREAKDOWN 
              PERFORM 6251-GET-FJC01-DATE    THRU 6251-EXIT             
              MOVE G6-SEQ-NO                 TO WS-COMMON-DATE-SEQ      
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**   PCSCA116 PROCESSING ERROR   **'             
              DISPLAY '**-------------------------------**'             
              DISPLAY '**   0100-INITIALIZATION:'                       
              DISPLAY '**   RUN DATE AND LAST RUN DATE'                 
              DISPLAY '**   WERE NOT FOUND'                             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
           PERFORM 2000-CHECK-FOR-EDITED     THRU 2000-EXIT.            
      *                                                                         
PC473      MOVE SPACES                       TO WS-SYSIPT.              
PC473 *                                                                         
PC473      PERFORM 7600-START-FCSJC01        THRU 7600-EXIT.            
PC473 *                                                                         
PC473      PERFORM UNTIL (REV-MONTH-FOUND AND INPUT-ACTIVE)             
PC473                 OR END-OF-SYSIPT                                  
PC473          PERFORM 7610-READ-FCSJC01     THRU 7610-EXIT             
PC473          MOVE WS-INPUT-DATA-BREAKDOWN  TO WS-INPUT-REV-MONTH      
PC473      END-PERFORM.                                                 
PC473 *                                                                         
PC473      IF END-OF-SYSIPT                                             
PC473          DISPLAY '***********************************'            
PC473          DISPLAY '**   PCSCA116 PROCESSING ERROR   **'            
PC473          DISPLAY '**-------------------------------**'            
PC473          DISPLAY '**   0100-INITIALIZATION:'                      
PC473          DISPLAY '**   CAN NOT FIND REVENUE MONTH'                
PC473          DISPLAY '**   IN CSS_JOB_PARM TABLE'                     
PC473          DISPLAY '**   OR WAS SET TO INACTIVE'                    
PC473          DISPLAY '***********************************'            
PC473          PERFORM 9900-ABEND            THRU 9900-EXIT             
PC473      ELSE                                                         
PC473          PERFORM 7611-CLOSE            THRU 7611-EXIT             
PC473          MOVE G6-SEQ-NO                TO WS-REV-SEQ              
T15791         MOVE WS-REV-MONTH-NUMERIC     TO WS-CURRENT-REV-MONTH    
PC473      END-IF.                                                      
                                                                        
           MOVE WS-PCSCA116-NAME             TO WS-PGRMNAME.            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    2000-CHECK-FOR-EDITED                                     **         
      *                                                              **         
      *    CHECKS THE PCSCA116 RUN DATE AGAINST THE COMMON RUN DATE  **         
      *    TO BE SURE THAT THEY ARE THE SAME.  IF THEY ARE NOT,      **         
      *    THE PROGRAM ABENDS.                                       **         
      *****************************************************************         
       2000-CHECK-FOR-EDITED.                                           
      *                                                                         
           IF WS-INPUT-RUN-DATE-R116 NOT EQUAL WS-INPUT-RUN-DATE        
              DISPLAY '***********************************'             
              DISPLAY '**   PCSCA116 PROCESSING ERROR   **'             
              DISPLAY '**-------------------------------**'             
              DISPLAY '**   2000-CHECK-FOR-EDITED:'                     
              DISPLAY '**   RUN DATE HAS BEEN MANUALLY'                 
              DISPLAY '**   EDITED'                                     
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    2150-CHECK-FOR-FUTURE                                     **         
      *                                                              **         
      *    CHECKS THAT THE NEW BUSINESS DAY IS NOT IN THE FUTURE,    **         
      *    OR GREATER THAN THE CURRENT DATE.                         **         
      *****************************************************************         
       2150-CHECK-FOR-FUTURE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-SYS-DATE                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-SYS-DATE = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NEW-BUSINESS-DAY GREATER THAN WS-SYS-DATE              
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA116 PROCESSING ERROR   **'            
               DISPLAY '**-------------------------------**'            
               DISPLAY '**   2150-CHECK-FOR-FUTURE:'                    
               DISPLAY '**   NEW BUSINESS DAY CAN NOT BE'               
               DISPLAY '**   GREATER THAN TODAY (' WS-SYS-DATE ')'      
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       2150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    2200-CHECK-TIME-SPAN                                      **         
      *                                                              **         
      *    CHECKS THAT THE DIFFERENCE BETWEEN THE OLD BUSINESS DAY   **         
      *    AND NEW BUSINESS DAY IS NOT MORE THAN MAX-DAY-DIFF, A     **         
      *    PARAMETER FOUND IN CSS_JOB_PARM FOR PCSCA116.  IF THE     **         
      *    PARAMETER IS NOT FOUND OR SPAN IS TOO LONG, IT ABENDS.    **         
      *****************************************************************         
       2200-CHECK-TIME-SPAN.                                            
      *                                                                         
           MOVE WS-PGRMNAME                  TO WS-PROGRAM.             
           MOVE WS-PARM                      TO WS-COMMAND.             
           MOVE SPACES                       TO WS-SYSIPT.              
      *                                                                         
           PERFORM 7600-START-FCSJC01        THRU 7600-EXIT.            
           PERFORM UNTIL (MAX-DAY-DIFF AND INPUT-ACTIVE)                
                      OR END-OF-SYSIPT                                  
               PERFORM 7610-READ-FCSJC01     THRU 7610-EXIT             
               MOVE WS-INPUT-DATA-BREAKDOWN  TO WS-INPUT-MAX-DIFF       
           END-PERFORM.                                                 
      *                                                                         
           IF END-OF-SYSIPT                                             
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA116 PROCESSING ERROR   **'            
               DISPLAY '**-------------------------------**'            
               DISPLAY '**   2200-CHECK-TIME-SPAN:'                     
               DISPLAY '**   MAX DAY DIFF PARAMETER WAS'                
               DISPLAY '**   NOT FOUND IN CSS_JOB_PARM'                 
               DISPLAY '**   OR WAS SET TO INACTIVE'                    
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           ELSE                                                         
               PERFORM 7611-CLOSE            THRU 7611-EXIT             
           END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-RUN-DATE-R116       TO WS-CURRENT-DATE.        
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )) -                 
                     CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))
            INTO
              :WS-DAY-SPAN                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-DAY-SPAN =                                               
MFA-TR*             (DAYS(DATE(:WS-NEW-BUSINESS-DAY)) -                         
MFA-TR*              DAYS(DATE(:WS-CURRENT-DATE)) )                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA116 PROCESSING ERROR   **'            
               DISPLAY '**-------------------------------**'            
               DISPLAY '**   2200-CHECK-TIME-SPAN:'                     
               DISPLAY '**   COULD NOT COMPUTE THE SPAN'                
               DISPLAY '**   OF DAYS FROM OLD BUSINESS'                 
               DISPLAY '**   DAY TO THE NEW ONE'                        
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           IF WS-DAY-SPAN IS GREATER THAN WS-MAX-DAY-DIFF               
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA116 PROCESSING ERROR   **'            
               DISPLAY '**-------------------------------**'            
               DISPLAY '**   2200-CHECK-TIME-SPAN:'                     
               DISPLAY '**   SPAN OF DAYS IS TOO LONG --'               
               DISPLAY '**   ' WS-CURRENT-DATE ' TO '                   
               DISPLAY '**   ' WS-NEW-BUSINESS-DAY ' IS ' WS-DAY-SPAN   
               DISPLAY '**   DAYS (MAX DAY DIFF = ' WS-MAX-DAY-DIFF ')' 
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND            THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    6251-GET-FJC01-DATE                                      **         
      **      THIS COPYBOOK, CPD00037, CONTAINS THE DB2 STATEMENTS   **         
      **      NECESSARY TO RETRIEVE PARAMETERS FROM TABLE CSS_JOB_   **         
      **      PARM.                                                  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00037                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    6500-GET-NEXT-BUSINESS-DAY                                **         
      *                                                              **         
      *    COPYBOOK CPD00315 CONTAINS THE LOGIC FOR FINDING          **         
      *    THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00315                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    7000-UPDATE-DATES                                         **         
      *                                                              **         
      *    THIS MODULE UPDATES CSS_JOB_PARM WITH NEW BUSINESS DAY.   **         
      *****************************************************************         
       7000-UPDATE-DATES.                                               
      *                                                                         
           MOVE WS-INPUT-RUN-DATE-R116   TO WS-INPUT-LAST-DATE-R116.    
           MOVE WS-NEW-BUSINESS-DAY      TO WS-INPUT-RUN-DATE-R116.     
      *                                                                         
           MOVE WS-INPUT-DATA-R116       TO G6-PARM-DATA.               
           MOVE WS-DATE                  TO G6-CMND-CODE.               
           MOVE '01'                     TO G6-COMPANY-NO.              
           MOVE WS-DATE-SEQ              TO G6-SEQ-NO.                  
      *                                                                         
           EXEC SQL                                                     
               UPDATE   CSS_JOB_PARM                                    
                  SET   PARM_DATA        = :G6-PARM-DATA                
                WHERE   PROGRAM_NAME     = :G6-PROGRAM-NAME             
                  AND   CMND_CODE        = :G6-CMND-CODE                
                  AND   COMPANY_NO       = :G6-COMPANY-NO               
                  AND   SEQ_NO           = :G6-SEQ-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA116 PROCESSING ERROR   **'            
               DISPLAY '**-------------------------------**'            
               DISPLAY '**   7000-UPDATE-DATES:'                        
               DISPLAY '**   COULD NOT UPDATE CSS_JOB_PARM'             
               DISPLAY '**   FOR PROGRAM PCSCA116'                      
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
           MOVE WS-NEW-BUSINESS-DAY      TO WS-COMMON-DATE-VALUE.       
      *                                                                         
           MOVE WS-COMMON-DATE           TO G6-PARM-DATA.               
           MOVE WS-COMMON-NAME           TO G6-PROGRAM-NAME.            
           MOVE WS-DATE                  TO G6-CMND-CODE.               
           MOVE WS-COMMON-DATE-SEQ       TO G6-SEQ-NO.                  
      *                                                                         
           EXEC SQL                                                     
               UPDATE   CSS_JOB_PARM                                    
                  SET   PARM_DATA        = :G6-PARM-DATA                
                WHERE   PROGRAM_NAME     = :G6-PROGRAM-NAME             
                  AND   CMND_CODE        = :G6-CMND-CODE                
                  AND   COMPANY_NO       = :G6-COMPANY-NO               
                  AND   SEQ_NO           = :G6-SEQ-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
               DISPLAY '***********************************'            
               DISPLAY '**   PCSCA116 PROCESSING ERROR   **'            
               DISPLAY '**-------------------------------**'            
               DISPLAY '**   7000-UPDATE-DATES:'                        
               DISPLAY '**   COULD NOT UPDATE RUN DATE'                 
               DISPLAY '**   IN CSS_JOB_PARM FOR PROGRAM'               
               DISPLAY '**   COMMON'                                    
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
      *                                                                         
PC473      MOVE WS-INPUT-RUN-DATE-R116-CC TO WS-REV-MONTH-CC.           
PC473      MOVE WS-INPUT-RUN-DATE-R116-YY TO WS-REV-MONTH-YY.           
PC473      MOVE WS-INPUT-RUN-DATE-R116-MM TO WS-REV-MONTH-MM.           
PC473      MOVE WS-INPUT-FULL-REV-MONTH   TO WS-REV-MONTH-VALUE.        
T15791     MOVE WS-REV-MONTH-NUMERIC      TO BN-REVENUE-MONTH.          
                                                                        
PC473      EXEC SQL                                                     
T15791         SELECT   MIN(DATE_EXTRACT)                               
T15791           INTO   :BN-DATE-EXTRACT                                
T15791           FROM   CSS_BILL_WINDOW                                 
T15791          WHERE   BILL_CYCLE       = '01'                         
T15791            AND   REVENUE_MONTH    = :BN-REVENUE-MONTH            
PC473      END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15791                                                                  
T15791     IF SQLCODE EQUAL SUCCESSFUL-CALL                             
T15791         CONTINUE                                                 
T15791     ELSE                                                         
PC473          DISPLAY '***********************************'            
PC473          DISPLAY '**   PCSCA116 PROCESSING ERROR   **'            
PC473          DISPLAY '**-------------------------------**'            
PC473          DISPLAY '**   7000-UPDATE-DATES:'                        
T15791         DISPLAY '**   COULD NOT FIND OPEN OF BILL'               
T15791         DISPLAY '**   CYCLE 01 FOR THE CURRENT MONTH'            
PC473          DISPLAY '***********************************'            
PC473          PERFORM 9900-ABEND         THRU 9900-EXIT                
PC473      END-IF.                                                      
                                                                        
T15791     IF WS-NEW-BUSINESS-DAY = BN-DATE-EXTRACT                     
                                                                        
PC473         MOVE WS-REVENUE-MONTH             TO G6-PARM-DATA         
T15791        MOVE WS-REV-SEQ                   TO G6-SEQ-NO            
PC473 *                                                                         
PC473         EXEC SQL                                                  
PC473             UPDATE   CSS_JOB_PARM                                 
PC473                SET   PARM_DATA        = :G6-PARM-DATA             
PC473              WHERE   PROGRAM_NAME     = :G6-PROGRAM-NAME          
PC473                AND   CMND_CODE        = :G6-CMND-CODE             
PC473                AND   COMPANY_NO       = :G6-COMPANY-NO            
PC473                AND   SEQ_NO           = :G6-SEQ-NO                
PC473         END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PC473 *                                                                         
PC473         IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                      
PC473            DISPLAY '***********************************'          
PC473            DISPLAY '**   PCSCA116 PROCESSING ERROR   **'          
PC473            DISPLAY '**-------------------------------**'          
PC473            DISPLAY '**   7000-UPDATE-DATES:'                      
PC473            DISPLAY '**   COULD NOT UPDATE REVENUE MONTH'          
PC473            DISPLAY '**   IN CSS_JOB_PARM FOR PROGRAM'             
PC473            DISPLAY '**   COMMON'                                  
PC473            DISPLAY '***********************************'          
PC473            PERFORM 9900-ABEND         THRU 9900-EXIT              
PC473         END-IF                                                    
T15791     ELSE                                                         
T15791                                                                  
T15791        EXEC SQL                                                  
T15791           SELECT    MAX(REVENUE_MONTH)                           
T15791             INTO    :BN-REVENUE-MONTH                            
T15791             FROM    CSS_BILL_WINDOW                              
T15791            WHERE    DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                   :WS-NEW-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-NEW-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-NEW-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-NEW-BUSINESS-DAY
              ), CONVERT(DATE, :WS-NEW-BUSINESS-DAY) )          
T15791        END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT    MAX(REVENUE_MONTH)                                   
MFA-TR*            INTO    :BN-REVENUE-MONTH                                    
MFA-TR*            FROM    CSS_BILL_WINDOW                                      
MFA-TR*           WHERE    DATE_EXTRACT = :WS-NEW-BUSINESS-DAY                  
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T15791                                                                  
T15791        IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                      
T15791           DISPLAY '***********************************'          
T15791           DISPLAY '**   PCSCA116 PROCESSING ERROR   **'          
T15791           DISPLAY '**-------------------------------**'          
T15791           DISPLAY '**   7000-UPDATE-DATES:'                      
T15791           DISPLAY '**   COULD NOT DETERMINE WHAT THE'            
T15791           DISPLAY '**   CORRECT REVENUE MONTH SHOULD'            
T15791           DISPLAY '**   BE'                                      
T15791           DISPLAY '***********************************'          
T15791           PERFORM 9900-ABEND         THRU 9900-EXIT              
T15791        END-IF                                                    
T15791                                                                  
T15791        IF BN-REVENUE-MONTH NOT EQUAL WS-CURRENT-REV-MONTH        
T15791           DISPLAY '***********************************'          
T15791           DISPLAY '**   PCSCA116 PROCESSING ERROR   **'          
T15791           DISPLAY '**-------------------------------**'          
T15791           DISPLAY '**   7000-UPDATE-DATES:'                      
T15791           DISPLAY '**   THE REVENUE MONTH IS NOT SET'            
T15791           DISPLAY '**   CORRECTLY.'                              
T15791           DISPLAY '**   CURRENTLY: ' WS-CURRENT-REV-MONTH        
T15791           DISPLAY '**   SHOULD BE: ' BN-REVENUE-MONTH            
T15791           DISPLAY '***********************************'          
T15791           PERFORM 9900-ABEND         THRU 9900-EXIT              
T15791        END-IF                                                    
T15791     END-IF.                                                      
      *                                                                         
      *                                                                         
           DISPLAY '***********************************'                
           DISPLAY '*******  UPDATES OCCURED  *********'.               
           DISPLAY '***********************************'                
      *                                                                         
           DISPLAY '** OLD BUSINESS DAY  = ' WS-INPUT-LAST-DATE-R116.   
           DISPLAY '** NEW BUSINESS DAY  = ' WS-INPUT-RUN-DATE-R116.    
T15791     IF WS-NEW-BUSINESS-DAY = BN-DATE-EXTRACT                     
T15791        DISPLAY '** REVENUE MONTH WAS UPDATED:'                   
PC473         DISPLAY '** NEW REVENUE MONTH = ' WS-REV-MONTH-VALUE      
T15791     ELSE                                                         
T15791        DISPLAY '** REVENUE MONTH     = ' WS-CURRENT-REV-MONTH    
T15791     END-IF.                                                      
           DISPLAY '** MAX DAY DIFF      = ' WS-MAX-DAY-DIFF.           
      *                                                                         
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7600-START-FCSJC01                                       **         
      **      COPYBOOK CPD00038 IS UTILIZED IN THE PARAMETER         **         
      **      RETRIEVAL FROM CSS_JOB_PARM.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7620-START-FCSCA00                                       **         
      **      COPYBOOK CPD00039 IS UTILIZED IN THE PARAMETER         **         
      **      RETRIEVAL FROM CSS_JOB_PARM.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **   9000-TERMINATE                                           **          
      **                                                            **          
      **   PERFORMS NO FUNCTIONALITY, BUT NEEDS TO BE HERE SINCE    **          
      **   IT IS CALLED FROM SOME COPYBOOK MODULES                  **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE         **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
                                                                        
