       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA115.                                        
       DATE-WRITTEN.   11/21/96.                                        
       DATE-COMPILED.                                                   
      *****************************************************************         
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               **         
      **                     PRICE WATERHOUSE                        **         
      **                1410 NORTH WESTSHORE BLVD                    **         
      **                   TAMPA, FLORIDA  33607                     **         
      **                      (813) 287-9200                         **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **    DATE    INITIALS     REASON                              **         
      **  ________  _________    __________________________________  **         
      **  11/21/96     MAD       PROGRAM RE-WRITE FOR TPR 5686       **         
      **                                                             **         
      **  12/12/96     MAD       COMPONENT PCSCA115 WILL NOW PRODUCE **         
      **                          AN EXTRACT WHICH WILL BE READ BY   **         
      **                          REPORT WRITING COMPONENT PCSRP115  **         
      **                          TO PRODUCE THE CUSTOMER ACTION     **         
      **                          REPORT.                            **         
TP8613**  01/24/97     KB         THE FIX HAS BEEN APPLIED TO THE    **         
      **                          COPYBOOK WHICH LOADS THE BE00      **         
      **                          RECOERDS TO CWS10000               **         
TP9144**  02/10/97     RAO JADA   THE FIX HAS BEEN MADE TO CURSOR    **         
      **                          TO PICK FINAL BILLED ACCOUNTS AS   **         
      **                          WELL.                              **         
T13346**  10/15/97     BAB        MANUALLY RELEASED GUARANTORS SHOULD**         
      **                          APPEAR ON THE SECOND SECTION OF THE**         
      **                          REPORT.(PER SUE M.)                **         
T20513**  07/28/99     MDJ        IN PARA 7500, DISPLAY ACCOUNT NO   **         
      **                          WHEN RETURN CODE NOT SUCCESSFUL.   **         
      **                          IF ACCOUNT IS NOT FOUND, GET  NEXT **         
      **                          ROW.                               **         
T21396**  01/05/00     MDJ        IF CREDIT STATUS CODE = GOOD & SURETY         
      **                          BOND STATUS = ACTIVE, SURETY BOND  **         
      **                          STATUS WILL BE CHANGED TO RELEASED. *         
T20819**  09/28/00     VVKS       ACCOUNTS WITH RELEASED IRREVOCABLE *          
      **                          LETTERS OF CREDIT SHOW UP IN REPRT  *         
      **                          ONCE IN EVERY MONTH.                *         
T33928**  07/08/06     PRIYA      ADD FOR FETCH ONLY WITH UR TO AVOID *         
T33928**                          -911S.                               *        
T35434**  02/28/07     MC95456    REPLACED CSS_MODEL_SQL WITH SET     *         
T35434**                                                 STATEMENTS   *         
P26289**  07/09/08     RB19957    MAKE CHANGES TO HOW WE KEEP/WORK    *         
P26289**            RICK BLACK    SURETY BONDS AND IRLOC              *         
A00633**  09/02/09     SV95326    ADDED "WITH UR " TO CURSORS AND     *         
A00633**                          SINGLETON SELECT STATEMENTS.        *         
P00599**  05/09/12     AA97148    GET DISCONNECT & ARREARS HISTORY    *         
P00599**                          FIELDS FROM CSS_CREDIT_HISTORY TABLE*         
P00599**                          INSTEAD OF BE00 FILE.               *         
P0599A**  10/25/12     RC41079    CHANGE TO GET SURETY BOND DATA FROM *         
P0599A**                          CSS_SURETY_BOND INSTEAD OF FILE.    *         
P0599A**                          CHANGE GUARANTOR RELEASE COMPONENT  *         
P0599A**                          FROM SCSCA110 TO SCSKR111B.         *         
A05088**  10/31/14     VP43661    REMOVED CHANGES (T21396) TO NOT TO  *         
A05088**                          RELEASE SURETY BONDS BY SYSTEM.     *         
      *****************************************************************         
           REMARKS.                                                     
                   ---- EXTRACT GENERATOR FOR PCSRP115 REPORTS ----     
                   -- THIS IS A NEW PROGRAM WRITTEN FOR CSS 1.3 --      
                         ---- BASIC SEQUENCE STRUCTURE ----             
                                                                        
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
                                                                        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBE00.                                                            
       COPY CSSRP115.                                                           
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBE00.                                                            
       COPY FIOBE00.                                                            
       COPY CFDRP115.                                                           
       COPY FIORP115.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA115'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                    PIC X(40)     VALUE              
           'WORKING STORAGE FOR PCSCA115 STARTS HERE'.                  
      *                                                                         
      ****************************************************************          
      *********************** PCSCA115 SWITCHES **********************          
      ****************************************************************          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-MORE-DATA-SW         PIC X(01)     VALUE 'Y'.         
               88  NO-MORE-DATA                      VALUE 'N'.         
               88  MORE-DATA-FOUND                   VALUE 'Y'.         
           05  WS-END-REC-PROCESSED    PIC X(01)     VALUE 'N'.         
               88  END-REC-WAS-PROCESSED             VALUE 'Y'.         
           05  WS-GUARANTORS-SW        PIC X(01)     VALUE 'N'.         
               88  END-OF-GUARANTORS                 VALUE 'Y'.         
           05  WS-ACCOUNT-NUMBER-SW    PIC X(01)     VALUE 'N'.         
               88  ACCOUNT-NUM-HAS-CHANGED           VALUE 'Y'.         
      *                                                                         
      ****************************************************************          
      *************** PCSCA115 WORKING STORAGE COPYBOOKS *************          
      ****************************************************************          
      *                                                                         
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
       COPY CWS10005.                                                           
       COPY CWS00074.                                                           
       COPY CWS00011.                                                           
       COPY CWS00056.                                                           
       COPY FIOBE02.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00038                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CWS00039                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ************* PCSCA115 TIME AND DATE WORKING STORAGE ***********          
      ****************************************************************          
      *                                                                         
       01  WS-DATE-10.                                                  
           05  WS-D10-CC               PIC X(02).                       
           05  WS-D10-YY               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '-'.         
           05  WS-D10-MM               PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '-'.         
           05  WS-D10-DD               PIC X(02).                       
P26289*                                                                         
P26289 01  WS-DATE-10-RPT.                                              
P26289     05  WS-D10-MM-RPT           PIC X(02).                       
P26289     05  FILLER                  PIC X(01)     VALUE '/'.         
P26289     05  WS-D10-DD-RPT           PIC X(02).                       
P26289     05  FILLER                  PIC X(01)     VALUE '/'.         
P26289     05  WS-D10-CC-RPT           PIC X(02).                       
P26289     05  WS-D10-YY-RPT           PIC X(02).                       
P26289*                                                                         
P26289 01  WS-EXPIRATION-DT.                                            
P26289     05  WS-EXPIRATION-DT-CCYY   PIC X(04).                       
P26289     05  FILLER                  PIC X(01).                       
P26289     05  WS-EXPIRATION-DT-MM     PIC X(02).                       
P26289     05  FILLER                  PIC X(01).                       
P26289     05  WS-EXPIRATION-DT-DD     PIC X(02).                       
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-MM                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-D8-DD                PIC X(02).                       
           05  FILLER                  PIC X(01)     VALUE '/'.         
           05  WS-D8-YY                PIC X(02).                       
      *                                                                         
C34788 01  WS-DATE-60-FUTURE-DAYS      PIC X(10).                       
P26289 01  WS-ESTBLSH-DATE-NI          PIC S9(04) COMP VALUE ZERO.      
P26289 01  WS-DATE-1-FUTURE-YEAR       PIC X(10).                       
P26289 01  WS-FUTURE-YEAR REDEFINES WS-DATE-1-FUTURE-YEAR.              
P26289     05  WS-FUTURE-CCYY          PIC X(04).                       
P26289     05  FILLER                  PIC X(01).                       
P26289     05  WS-FUTURE-MM            PIC X(02).                       
P26289     05  FILLER                  PIC X(01).                       
P26289     05  WS-FUTURE-DD            PIC X(02).                       
      *                                                                         
      ****************************************************************          
      *************** PCSCA115 GENERAL WORKING STORAGE ***************          
      ****************************************************************          
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  WS-FRP115-REC-COUNTER   PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-FBE00-REC-COUNTER    PIC S9(07) COMP-3 VALUE ZERO.    
      *                                                                         
       01  WS-FILE-STATUS.                                              
           05  WS-FBE00-STATUS         PIC X(02).                       
               88  FBE00-SUCCESSFUL                  VALUE '00'.        
           05  WS-FRP115-STATUS        PIC X(02).                       
               88  FRP115-SUCCESSFUL                 VALUE '00'.        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSCA115'.  
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSCA115'.  
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
P26289     05  WS-LIT-GC-SB            PIC X(35)     VALUE              
A05088         'GOOD CREDIT - SURETY BOND          '.                   
P26289     05  WS-LIT-GC-ILC           PIC X(35)     VALUE              
P26289         'GOOD CREDIT - ILOC                 '.                   
P26289     05  WS-LIT-FB-SB            PIC X(35)     VALUE              
P26289         'FINAL BILL - SURETY BOND           '.                   
P26289     05  WS-LIT-FB-ILC           PIC X(35)     VALUE              
P26289         'FINAL BILL - ILOC                  '.                   
           05  WS-LIT-GFB-NAME.                                         
P26289         10  FILLER              PIC X(13)     VALUE              
P26289             'GUARANTOR FB-'.                                     
P26289         10  WS-NAMED-GUARANTOR  PIC X(22).                       
           05  WS-LIT-ILC-EXP.                                          
P26289         10  FILLER              PIC X(16)     VALUE              
P26289         'ILOC EXPIRES ON '.                                      
P26289         10  WS-ILC-EXP-DATE     PIC X(08).                       
P26289         10  FILLER              PIC X(11)     VALUE SPACES.      
P26289     05  WS-LIT-SB-EXP.                                           
P26289         10  FILLER              PIC X(23)     VALUE              
P26289         'SURETY BOND EXPIRES ON '.                               
P26289         10  WS-SB-EXP-DATE      PIC X(08).                       
P26289         10  FILLER              PIC X(04)     VALUE SPACES.      
P26289     05  WS-LIT-GC-GR            PIC X(35)     VALUE              
P26289         'GOOD CREDIT - GUARANTOR AUTO REL   '.                   
P26289     05  WS-LIT-EXP-ILC          PIC X(35)     VALUE              
P26289         'EXPIRED - ILOC                     '.                   
P26289     05  WS-LIT-EXP-SB           PIC X(35)     VALUE              
P26289         'EXPIRED - SURETY BOND              '.                   
P26289     05  WS-LIT-BKRPT-SB         PIC X(35)     VALUE              
P26289         'BANKRUPT - SURETY BOND             '.                   
P26289     05  WS-LIT-BKRPT-ILC        PIC X(35)     VALUE              
P26289         'BANKRUPT - ILOC                    '.                   
P26289     05  WS-LIT-BKRPT-AG         PIC X(35)     VALUE              
P26289         'BANKRUPT - ACCOUNT GUARANTEED      '.                   
P26289     05  WS-LIT-GUAR-RLSE        PIC X(35)     VALUE              
P26289         'GUARANTOR RELEASED MANUALLY        '.                   
           05  WS-ALPHA-1              PIC X(01)     VALUE '1'.         
           05  WS-ALPHA-2              PIC X(01)     VALUE '2'.         
           05  WS-ALPHA-3              PIC X(01)     VALUE '3'.         
      *                                                                         
       01  WS-GUARANTOR-TABLE.                                          
           05  WS-IND-GUARANTORS OCCURS 10 TIMES INDEXED BY WS-TAB-IDX. 
               10  WS-GUAR-STATUS-CD   PIC X(01).                       
COB305         10 WS-GUARNTR-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.          
P26289         10  WS-GUAR-ESTBLSH-DT  PIC X(10).                       
      *                                                                         
       01  WS-GENERAL.                                                  
           05  WS-HOLD-FINAL-DATE-10   PIC X(10).                       
COB305     05 WS-CURRENT-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.              
P0599A     05  WS-NULL-IND-1           PIC S9(4)  COMP.                 
P0599A     05  WS-NULL-IND-2           PIC S9(4)  COMP.                 
P0599A     05  WS-NULL-IND-3           PIC S9(4)  COMP.                 
      *                                                                         
      ****************************************************************          
      ********************** PCSCA115 ERROR CONTROL ******************          
      ****************************************************************          
      *                                                                         
       01  WS-ERROR-VARIABLES.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP.                 
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  WS-DISP-RETURN-CODE     PIC +Z(04).                      
      *                                                                         
      ****************************************************************          
      ******************** PCSCA115 DB2 DECLARATIONS *****************          
      ****************************************************************          
      *                                                                         
      **********************                                                    
      **    S Q L C A     **                                                    
      **********************                                                    
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      ********************                                                      
      **  CSS_JOB_PARM  **                                                      
      ********************                                                      
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *********************                                                     
      **  CSS_GUARANTOR  **                                                     
      *********************                                                     
           EXEC SQL                                                             
             INCLUDE TBGTNTR                                                    
           END-EXEC.                                                            
      *******************                                                       
      **  CSS_ACCOUNT  **                                                       
      *******************                                                       
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      ****************                                                          
      **  CSS_NAME  **                                                          
      ****************                                                          
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
      **************************                                                
      **  CSS_NAME_ACCT_XREF  **                                                
      **************************                                                
           EXEC SQL                                                             
             INCLUDE TBNMACTX                                                   
           END-EXEC.                                                            
      **************************                                                
      **  CSS_CUST_ADDR_XREF  **                                                
      **************************                                                
           EXEC SQL                                                             
             INCLUDE TBCSADRX                                                   
           END-EXEC.                                                            
      *************************                                                 
      **  CSS_ADDR_FREEFORM  **                                                 
      *************************                                                 
           EXEC SQL                                                             
             INCLUDE TBADRFRE                                                   
           END-EXEC.                                                            
      **************************                                                
      **  CSS_ADDR_FORMATTED  **                                                
      **************************                                                
           EXEC SQL                                                             
             INCLUDE TBADRFMT                                                   
           END-EXEC.                                                            
      ********************                                                      
      **  CSS_ZIP_CODE  **                                                      
      ********************                                                      
           EXEC SQL                                                             
             INCLUDE TBZIPCD                                                    
           END-EXEC.                                                            
      **************************                                                
      **  CSS_ACCT_MISC_INFO  **                                                
      **************************                                                
           EXEC SQL                                                             
             INCLUDE TBATMISC                                                   
           END-EXEC.                                                            
      **************************                                                
      **  CSS_MNT_TRANS_HIST  **                                                
      **************************                                                
           EXEC SQL                                                             
             INCLUDE TBMNHIST                                                   
           END-EXEC.                                                            
      **************************                                                
      **  CSS_MT_TRN_HST_DET  **                                                
      **************************                                                
           EXEC SQL                                                             
             INCLUDE TBMNHDT                                                    
           END-EXEC.                                                            
T21396**************************                                                
T21396**  CSS_SURETY_BOND SB  **                                                
T21396**************************                                                
T21396     EXEC SQL                                                             
T21396       INCLUDE TBSTYBND                                                   
T21396     END-EXEC.                                                            
P26289******************************                                            
P26289**  CSS_CREDIT_PROFILE  CZ  **                                            
P26289******************************                                            
P26289     EXEC SQL                                                             
P26289       INCLUDE TBCRPROF                                                   
P26289     END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ************************** PCSCA115 CURSORS *********************         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
             DECLARE  GUARANTOR_CSR CURSOR FOR                          
              SELECT  GUAR_STATUS_CD,                                   
                      GUARNTR_ACCT_NO                                   
P26289               ,GUAR_ESTBLSH_DT                                   
P26289               ,AMOUNT_GUARANTEED                                 
                FROM  CSS_GUARANTOR WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO = :GU-ACCOUNT-NO                       
T33928         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  GUARANTOR_CSR CURSOR FOR                                  
MFA-TR*       SELECT  GUAR_STATUS_CD,                                           
MFA-TR*               GUARNTR_ACCT_NO                                           
MFA-TR*              ,GUAR_ESTBLSH_DT                                           
MFA-TR*              ,AMOUNT_GUARANTEED                                         
MFA-TR*         FROM  CSS_GUARANTOR                                             
MFA-TR*        WHERE  ACCOUNT_NO = :GU-ACCOUNT-NO                               
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE  GUAR_ACCT_CSR CURSOR FOR                          
              SELECT  A.ACCOUNT_NO,                                     
                      A.ADDRESS_ID,                                     
                      A.COMPANY_NO                                      
P26289               ,A.CREDIT_GROUP                                    
P26289               ,B.GUAR_ESTBLSH_DT                                 
P26289               ,B.AMOUNT_GUARANTEED                               
                FROM  CSS_ACCOUNT A WITH(READUNCOMMITTED),                      
                      CSS_GUARANTOR B WITH(READUNCOMMITTED)                     
               WHERE  A.ACCOUNT_NO       = B.ACCOUNT_NO                 
                 AND  B.GUARNTR_ACCT_NO  = :GU-GUARNTR-ACCT-NO          
TP9144           AND  A.CODE_ACCT_STAT IN ('A','P','B' )                
T33928           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  GUAR_ACCT_CSR CURSOR FOR                                  
MFA-TR*       SELECT  A.ACCOUNT_NO,                                             
MFA-TR*               A.ADDRESS_ID,                                             
MFA-TR*               A.COMPANY_NO                                              
MFA-TR*              ,A.CREDIT_GROUP                                            
MFA-TR*              ,B.GUAR_ESTBLSH_DT                                         
MFA-TR*              ,B.AMOUNT_GUARANTEED                                       
MFA-TR*         FROM  CSS_ACCOUNT A,                                            
MFA-TR*               CSS_GUARANTOR B                                           
MFA-TR*        WHERE  A.ACCOUNT_NO       = B.ACCOUNT_NO                         
MFA-TR*          AND  B.GUARNTR_ACCT_NO  = :GU-GUARNTR-ACCT-NO                  
MFA-TR*          AND  A.CODE_ACCT_STAT IN ('A','P','B' )                        
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
             DECLARE  RELEASE_CSR CURSOR FOR                            
              SELECT  A.ACCOUNT_NO                                      
                FROM  CSS_MNT_TRANS_HIST A WITH(READUNCOMMITTED),               
                      CSS_MT_TRN_HST_DET B WITH(READUNCOMMITTED)                
               WHERE  A.DATE_TRANS         = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )             
                 AND  A.TRANS_HIST_SEQ_NO  = B.TRANS_HIST_SEQ_NO        
P26289           AND  A.APPL_PROGRAM_ID    = 'PANEL245'                 
                 AND  B.TABLE_ID           = '68'                       
                 AND  B.CHG_COLUMN_VALUE   = 'R'                        
                 AND  B.COLUMN_DESC        = 'GUAR STATUS CD '          
T33928           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  RELEASE_CSR CURSOR FOR                                    
MFA-TR*       SELECT  A.ACCOUNT_NO                                              
MFA-TR*         FROM  CSS_MNT_TRANS_HIST A,                                     
MFA-TR*               CSS_MT_TRN_HST_DET B                                      
MFA-TR*        WHERE  A.DATE_TRANS         = :WS-INPUT-DATE                     
MFA-TR*          AND  A.TRANS_HIST_SEQ_NO  = B.TRANS_HIST_SEQ_NO                
MFA-TR*          AND  A.APPL_PROGRAM_ID    = 'PANEL245'                         
MFA-TR*          AND  B.TABLE_ID           = '68'                               
MFA-TR*          AND  B.CHG_COLUMN_VALUE   = 'R'                                
MFA-TR*          AND  B.COLUMN_DESC        = 'GUAR STATUS CD '                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
P26289     EXEC SQL                                                     
P26289       DECLARE  GC_RELEASE_CSR CURSOR FOR                         
P26289        SELECT  MH.ACCOUNT_NO                                     
P26289          FROM  CSS_MNT_TRANS_HIST MH WITH(READUNCOMMITTED)               
P26289               ,CSS_MT_TRN_HST_DET MI WITH(READUNCOMMITTED)               
P26289         WHERE MH.DATE_TRANS        = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )              
P26289           AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO        
P26289           AND MH.USER_ID           = 'SYSTEM'                    
P0599A           AND MH.APPL_PROGRAM_ID   = 'SCSKR111B'                 
P26289           AND MI.PRV_COLUMN_VALUE  = 'A'                         
P26289           AND MI.CHG_COLUMN_VALUE  = 'G'                         
P26289           AND MI.COLUMN_DESC       = 'GUAR-STATUS-REA'           
P26289           AND MH.TRAN_COMMENT      = 'CHANGE GUARANTOR STATUS'   
P26289           FOR READ ONLY                                  
P26289     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  GC_RELEASE_CSR CURSOR FOR                                 
MFA-TR*       SELECT  MH.ACCOUNT_NO                                             
MFA-TR*         FROM  CSS_MNT_TRANS_HIST MH                                     
MFA-TR*              ,CSS_MT_TRN_HST_DET MI                                     
MFA-TR*        WHERE MH.DATE_TRANS        = :WS-INPUT-DATE                      
MFA-TR*          AND MH.TRANS_HIST_SEQ_NO = MI.TRANS_HIST_SEQ_NO                
MFA-TR*          AND MH.USER_ID           = 'SYSTEM'                            
MFA-TR*          AND MH.APPL_PROGRAM_ID   = 'SCSKR111B'                         
MFA-TR*          AND MI.PRV_COLUMN_VALUE  = 'A'                                 
MFA-TR*          AND MI.CHG_COLUMN_VALUE  = 'G'                                 
MFA-TR*          AND MI.COLUMN_DESC       = 'GUAR-STATUS-REA'                   
MFA-TR*          AND MH.TRAN_COMMENT      = 'CHANGE GUARANTOR STATUS'           
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
P26289*                                                                         
P0599A     EXEC SQL                                                     
P0599A       DECLARE  SURETY_BOND_CSR CURSOR WITH HOLD FOR              
P0599A       SELECT  BOND_NO                                            
P0599A              ,DATE_BOND_ISSUED                                   
P0599A              ,AMT_BOND                                           
P0599A              ,CODE_BOND_TYPE                                     
P0599A              ,CODE_STATUS                                        
P0599A              ,BOND_EXPIRATION_DT                                 
P0599A         FROM  CSS_SURETY_BOND WITH(READUNCOMMITTED)                      
P0599A        WHERE  ACCOUNT_NO = :SB-ACCOUNT-NO                        
P0599A        FOR READ ONLY                                     
P0599A                                                      
P0599A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  SURETY_BOND_CSR CURSOR WITH HOLD FOR                      
MFA-TR*      SELECT  BOND_NO                                                    
MFA-TR*             ,DATE_BOND_ISSUED                                           
MFA-TR*             ,AMT_BOND                                                   
MFA-TR*             ,CODE_BOND_TYPE                                             
MFA-TR*             ,CODE_STATUS                                                
MFA-TR*             ,BOND_EXPIRATION_DT                                         
MFA-TR*        FROM  CSS_SURETY_BOND                                            
MFA-TR*       WHERE  ACCOUNT_NO = :SB-ACCOUNT-NO                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*     QUERYNO 7380                                                        
MFA-TR*    END-EXEC.                                                            
P0599A*                                                                         
       01  WS-END                      PIC X(38)     VALUE              
           'WORKING STORAGE FOR PCSCA115 ENDS HERE'.                    
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0000-MAINLINE                                            **         
      **      MAIN PROCESSING MODULE - CONTROLS PROGRAM FLOW         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION               THRU 0100-EXIT.    
      *                                                                         
           PERFORM 3000-PROCESS-BE00-FILE            THRU 3000-EXIT     
            UNTIL NO-MORE-DATA.                                         
      *                                                                         
P26289     PERFORM 3100-PROCESS-NONBE00-DATA         THRU 3100-EXIT.    
P26289*                                                                         
           PERFORM 9500-CLEANUP                      THRU 9500-EXIT.    
      *                                                                         
           PERFORM 9000-TERMINATE                    THRU 9000-EXIT.    
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0100-INITIALIZATION                                      **         
      **      RETRIEVES CURRENT DATE AND TIME, OPENS FILES, DOES     **         
      **      CSS_JOB_PARM DATE PROCESSING, COMPUTES THE DATE 70     **         
      **      DAYS FROM NOW, PROCESSES THE FCSBE00 BEGIN RECORD,     **         
      **      INITIALIZES THE FBE00 WORKING STORAGE AREA AND         **         
      **      PERFORMS THE PRIMING READ.                             **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN OUTPUT FCSRP115-FILE.                                   
           IF FRP115-SUCCESSFUL                                         
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSRP115 PROCESSING ERROR      **'        
             DISPLAY '** OPEN ERROR OF FCSRP115 - OUTPUT FILE'          
             DISPLAY '**    FILE STATUS = ' WS-FRP115-STATUS            
             DISPLAY '**       PROCESSING TERMINATED         **'        
             DISPLAY '*****************************************'        
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
           OPEN INPUT FCSBE00-FILE.                                     
           IF FBE00-SUCCESSFUL                                          
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSBE00 PROCESSING ERROR       **'        
             DISPLAY '** OPEN ERROR OF FCSBE00 - INPUT FILE'            
             DISPLAY '**    FILE STATUS = ' WS-FBE00-STATUS             
             DISPLAY '**       PROCESSING TERMINATED         **'        
             DISPLAY '*****************************************'        
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE               THRU 6251-EXIT.    
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
             PERFORM 6240-GET-FCA00-COMMON-DATE      THRU 6240-EXIT     
             MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                 
           END-IF.                                                      
      *                                                                         
C34788     PERFORM 7400-GET-60-DAYS-FROM-NOW         THRU 7400-EXIT.    
P26289     PERFORM 7410-GET-1-YEAR-FROM-NOW          THRU 7410-EXIT.    
      *                                                                         
           PERFORM 1000-PROCESS-BEGIN-REC            THRU 1000-EXIT.    
      *                                                                         
           PERFORM 0609-INITIALIZE-FBE00-WS-AREA     THRU 0609-EXIT.    
      *                                                                         
           PERFORM 7000-READ-FCSBE00                 THRU 7000-EXIT.    
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0609-INITIALIZE-FBE00-WS-AREA                            **         
      **      COPYBOOK CPD00052 INITIALIZES THE FBE00 WORKING STORAGE**         
      **      AREAS FOR LOADING FROM THE INPUT FILE.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       COPY CPD00052.                                                           
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    0800-LOAD-FBE02-WS-AREA                                  **         
      **      COPYBOOK CPD00050 LOADS THE INPUT FILE DATA INTO FBE00 **         
      **      WORKING STORAGES AREAS.                                **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       COPY CPD00050.                                                           
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    1000-PROCESS-BEGIN-REC                                   **         
      **      MODULE PROCESSES THE FCSBE00 BEGIN RECORD - PROGRAM    **         
      **      WILL ABEND IF THE FILE CREATE DATE IS NOT THE SAME AS  **         
      **      THE CSS_JOB_PARM DATE.                                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1000-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7000-READ-FCSBE00                 THRU 7000-EXIT.    
      *                                                                         
           IF E-FBE00-KEY-BREC EQUAL LOW-VALUES                         
             IF WS-INPUT-DATE EQUAL E-FBE00-CREATE-DATE-BREC            
               SUBTRACT 1 FROM WS-FBE00-REC-COUNTER                     
               INITIALIZE FIORP115                                      
               PERFORM 8000-FMT-FRP115-BEGIN-REC     THRU 8000-EXIT     
             ELSE                                                       
               DISPLAY '****************************************'       
               DISPLAY '**      FCSBE00 PROCESSING ERROR      **'       
               DISPLAY '**  FILE CREATE DATE IS NOT EQUAL TO  **'       
               DISPLAY '**       THE PROGRAM COMMON DATE      **'       
               DISPLAY '**  ********************************  **'       
               DISPLAY '**  FILE CREATE DATE IS: '                      
                                                E-FBE00-CREATE-DATE-BREC
               DISPLAY '**  PROGRAM COMMON DATE IS: ' WS-INPUT-DATE     
               DISPLAY '**        PROCESSING TERMINATED       **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
             END-IF                                                     
           ELSE                                                         
             DISPLAY '********************************************'     
             DISPLAY '**       FCSBE00 PROCESSING ERROR         **'     
             DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'     
             DISPLAY '**         PROCESSING TERMINATED          **'     
             DISPLAY '********************************************'     
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    1900-PROCESS-END-REC                                     **         
      **      MODULE PROCESSES THE END RECORD FOR INPUT FILE FCSBE00.**         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       1900-PROCESS-END-REC.                                            
      *                                                                         
           SUBTRACT 1 FROM WS-FBE00-REC-COUNTER.                        
      *                                                                         
           IF WS-FBE00-REC-COUNTER EQUAL E-FBE00-RECORD-COUNT-EREC      
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '**********************************************'   
             DISPLAY '**         FCSBE00 PROCESSING ERROR         **'   
             DISPLAY '** ACTUAL REC COUNT DOES NOT MATCH CNTL REC **'   
             DISPLAY '**     CONTROL REC COUNT = '                      
                                      E-FBE00-RECORD-COUNT-EREC         
             DISPLAY '**     ACTUAL  REC COUNT = ' WS-FBE00-REC-COUNTER 
             DISPLAY '**           PROCESSING TERMINATED          **'   
             DISPLAY '**********************************************'   
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE WS-Y                   TO WS-END-REC-PROCESSED.         
      *                                                                         
           PERFORM 7000-READ-FCSBE00                 THRU 7000-EXIT.    
      *                                                                         
           IF MORE-DATA-FOUND                                           
             DISPLAY '*****************************************'        
             DISPLAY '**       PCSBE00 PROCESSING ERROR      **'        
             DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'        
             DISPLAY '**        PROCESSING TERMINATED        **'        
             DISPLAY '*****************************************'        
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3000-PROCESS-BE00-FILE                                   **         
      **      MAIN PROCESSING LOOP - IS PERFORMED UNTIL AN END-OF-   **         
      **      FILE CONDITION IS RETURNED FROM THE READ PARAGRAPH.    **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3000-PROCESS-BE00-FILE.                                          
      *                                                                         
           IF END-REC-WAS-PROCESSED                                     
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSBE00 PROCESSING ERROR       **'        
             DISPLAY '** LAST RECORD IS NOT A CONTROL RECORD **'        
             DISPLAY '**        PROCESSING TERMINATED        **'        
             DISPLAY '*****************************************'        
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           ELSE                                                         
      *                                                                         
             IF E-FBE00-KEY-EREC EQUAL HIGH-VALUES                      
               PERFORM 1900-PROCESS-END-REC          THRU 1900-EXIT     
             ELSE                                                       
               MOVE E-FBE00-ACCOUNT-NO TO WS-CURRENT-ACCT-NO            
      *                                                                         
               PERFORM 3300-LOAD-INPUT-RECORDS       THRU 3300-EXIT     
                UNTIL ACCOUNT-NUM-HAS-CHANGED                           
      *                                                                         
               PERFORM 3600-PRODUCE-FILE             THRU 3600-EXIT     
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
           MOVE WS-N                   TO WS-ACCOUNT-NUMBER-SW.         
      *                                                                         
           PERFORM 0609-INITIALIZE-FBE00-WS-AREA     THRU 0609-EXIT.    
      *                                                                         
       3000-EXIT.                                                       
           EXIT.                                                        
P26289*                                                                         
P26289*****************************************************************         
P26289**    3100-PROCESS-NONBE00-DATA                                **         
P26289**      THIS PARAGRAPH PROCESSES GOOD CREDIT - GUARANTOR AUTO  **         
P26289**      RELEASED AND GUARANTOR RELEASED MANUALLY.              **         
P26289*****************************************************************         
P26289*                                                                         
P26289 3100-PROCESS-NONBE00-DATA.                                       
P26289*                                                                         
P26289     PERFORM 7300-OPEN-RELEASE-CSR             THRU 7300-EXIT.    
P26289     PERFORM 7310-FETCH-RELEASE-CSR            THRU 7310-EXIT.    
P26289*                                                                         
P26289     PERFORM 3775-PROCESS-RELEASES             THRU 3775-EXIT     
P26289      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                
P26289*                                                                         
P26289     PERFORM 7320-CLOSE-RELEASE-CSR            THRU 7320-EXIT.    
P26289*                                                                         
P26289     PERFORM 7350-OPEN-GC-RELEASE-CSR          THRU 7350-EXIT.    
P26289     PERFORM 7360-FETCH-GC-RELEASE-CSR         THRU 7360-EXIT.    
P26289*                                                                         
P26289     PERFORM 3775-PROCESS-RELEASES             THRU 3775-EXIT     
P26289      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                
P26289*                                                                         
P26289     PERFORM 7370-CLOSE-GC-RELEASE-CSR         THRU 7370-EXIT.    
P26289*                                                                         
P26289 3100-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
      *****************************************************************         
      **                                                             **         
      **    3300-LOAD-INPUT-RECORDS                                  **         
      **      LOOPING MODULE WHICH LOADS THE FBE00 WORKING STORAGE   **         
      **      AREAS WITH DATA FROM THE INPUT FILE UNTIL THE ACCOUNT  **         
      **      NUMBER CHANGES OR THE END RECORD IS ENCOUNTERED.       **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3300-LOAD-INPUT-RECORDS.                                         
      *                                                                         
           MOVE FIOBE00                TO FIOBE02.                      
      *                                                                         
           PERFORM 0800-LOAD-FBE02-WS-AREA           THRU 0800-EXIT.    
      *                                                                         
           PERFORM 7000-READ-FCSBE00                 THRU 7000-EXIT.    
      *                                                                         
           IF E-FBE00-KEY-EREC EQUAL HIGH-VALUES                        
             MOVE WS-Y                 TO WS-ACCOUNT-NUMBER-SW          
           ELSE                                                         
             IF E-FBE00-ACCOUNT-NO NOT EQUAL WS-CURRENT-ACCT-NO         
               MOVE WS-Y               TO WS-ACCOUNT-NUMBER-SW          
             END-IF                                                     
           END-IF.                                                      
      *                                                                         
       3300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3600-PRODUCE-FILE                                        **         
      **      MODULE RETRIEVES GUARANTOR INFORMATION FROM THE CSS_   **         
      **      GUARANTOR TABLE AND CALLS TWO OTHER LOOPING MODULES    **         
      **      WHICH DETERMINE WHETHER OR NOT THE AVAILABLE DATA      **         
      **      SHOULD CAUSE DETAIL RECORDS TO BE WRITTEN TO THE       **         
      **      OUTPUT FILE.                                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3600-PRODUCE-FILE.                                               
      *                                                                         
P26289     MOVE WS-CURRENT-ACCT-NO     TO GU-ACCOUNT-NO.                
      *                                                                         
           PERFORM 7100-OPEN-GUARANTOR-CURSOR        THRU 7100-EXIT.    
      *                                                                         
           PERFORM 7110-FETCH-GUARANTOR-CURSOR       THRU 7110-EXIT.    
      *                                                                         
           INITIALIZE WS-GUARANTOR-TABLE.                               
           PERFORM 3950-LOAD-GUARANTOR-TABLE         THRU 3950-EXIT     
            VARYING WS-TAB-IDX FROM +1 BY +1                            
            UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                
      *                                                                         
           PERFORM 7120-CLOSE-GUARANTOR-CURSOR       THRU 7120-EXIT.    
      *                                                                         
           MOVE WS-CODES-DATA-PRESENT-AT                                
                                       TO WS-CODES-DATA-PRESENT.        
           MOVE WS-ACCT-FINALED-DT-AT  TO WS-HOLD-FINAL-DATE-10.        
      *                                                                         
           PERFORM 3700-PROCESS-GUAR-FINAL-BILL      THRU 3700-EXIT.    
      *                                                                         
           MOVE WS-N                   TO WS-GUARANTORS-SW.             
           PERFORM 3725-PROCESS-GUAR-BKRPT-MSG       THRU 3725-EXIT     
            VARYING WS-TAB-IDX FROM +1 BY +1                            
            UNTIL END-OF-GUARANTORS.                                    
      *                                                                         
      *                                                                         
P0599A     MOVE WS-ACCOUNT-NO-AT       TO SB-ACCOUNT-NO.                
P0599A     PERFORM 7375-OPEN-SURETY-BOND-CSR         THRU 7375-EXIT.    
P0599A     PERFORM 7380-FETCH-SURETY-BOND-CSR        THRU 7380-EXIT.    
           PERFORM 3750-PROCESS-CRED-MSGS            THRU 3750-EXIT     
P0599A      UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                
P26289     PERFORM 7385-CLOSE-SURETY-BOND-CSR        THRU 7385-EXIT.    
      *                                                                         
       3600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3700-PROCESS-GUAR-FINAL-BILL                             **         
      **      MODULE PROCESSES THE CONDITION WHEN AN ACTIVE          **         
      **      GUARANTOR'S ACCOUNT IS FINALED THROUGH BILLING ON THE  **         
      **      COMMON DATE.                                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3700-PROCESS-GUAR-FINAL-BILL.                                    
      *                                                                         
           IF WS-CODE-GUARANTOR EQUAL 'A'                               
            AND WS-HOLD-FINAL-DATE-10 EQUAL WS-INPUT-DATE               
             MOVE WS-ACCOUNT-NO-AT     TO GU-GUARNTR-ACCT-NO            
             PERFORM 7200-OPEN-GUAR-ACCT-CSR         THRU 7200-EXIT     
             PERFORM 7210-FETCH-GUAR-ACCT-CSR        THRU 7210-EXIT     
             PERFORM 3710-PROCESS-GUARANTORS         THRU 3710-EXIT     
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
             PERFORM 7220-CLOSE-GUAR-ACCT-CSR        THRU 7220-EXIT     
           END-IF.                                                      
      *                                                                         
       3700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3710-PROCESS-GUARANTORS                                  **         
      **      MODULE PROCESSES GUARANTOR ACCOUNTS WHICH ARE BEING    **         
      **      FINALED ON THE COMMON DATE.                            **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3710-PROCESS-GUARANTORS.                                         
      *                                                                         
           PERFORM 3805-PRODUCE-FB-SECTION1          THRU 3805-EXIT.    
      *                                                                         
           PERFORM 7210-FETCH-GUAR-ACCT-CSR          THRU 7210-EXIT.    
      *                                                                         
       3710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3725-PROCESS-GUAR-BKRPT-MSG                              **         
      **      MODULE PROCESSES CONDITION WHEN AN ACTIVE GUARANTOR    **         
      **      EXISTS FOR AN ACCOUNT WHICH HAS GONE BANKRUPT.         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3725-PROCESS-GUAR-BKRPT-MSG.                                     
      *                                                                         
           IF WS-GUAR-STATUS-CD(WS-TAB-IDX) EQUAL SPACES OR LOW-VALUES  
             MOVE WS-Y                 TO WS-GUARANTORS-SW              
           ELSE                                                         
      *                                                                         
             IF WS-GUAR-STATUS-CD(WS-TAB-IDX) EQUAL 'A'                 
              AND WS-BANKRUPTCY-IND-AT EQUAL 'B'                        
               MOVE WS-LIT-BKRPT-AG    TO E-FRP115-REPORT-ACTION        
               PERFORM 3820-PRODUCE-SECTION3         THRU 3820-EXIT     
             END-IF                                                     
      *                                                                         
           END-IF.                                                      
      *                                                                         
       3725-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3750-PROCESS-CRED-MSGS                                   **         
      **      DETERMINES WHETHER OR NOT THE AVAILABLE CREDIT DATA    **         
      **      SHOULD CAUSE A DETAIL RECORD TO BE WRITTEN TO THE      **         
      **      OUTPUT FILE.                                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3750-PROCESS-CRED-MSGS.                                          
      *                                                                         
           IF WS-CREDIT-STATUS-CODE-AT EQUAL 'G'                        
P0599A      AND SB-CODE-STATUS EQUAL 'A'                                
P0599A      AND SB-CODE-BOND-TYPE EQUAL 'A'                             
            MOVE WS-LIT-GC-SB         TO E-FRP115-REPORT-ACTION         
T21396      PERFORM 3800-PRODUCE-SECTION1           THRU 3800-EXIT      
           END-IF.                                                      
      *                                                                         
           IF WS-CREDIT-STATUS-CODE-AT EQUAL 'G'                        
P0599A      AND SB-CODE-STATUS EQUAL 'A'                                
P0599A      AND SB-CODE-BOND-TYPE EQUAL 'B'                             
             MOVE WS-LIT-GC-ILC        TO E-FRP115-REPORT-ACTION        
             PERFORM 3800-PRODUCE-SECTION1           THRU 3800-EXIT     
           END-IF                                                       
      *                                                                         
           IF WS-TOTAL-AR-BALANCE-AT GREATER THAN ZERO                  
            AND WS-HOLD-FINAL-DATE-10 EQUAL WS-INPUT-DATE               
P0599A      AND SB-CODE-BOND-TYPE EQUAL 'A'                             
             MOVE WS-LIT-FB-SB         TO E-FRP115-REPORT-ACTION        
             PERFORM 3800-PRODUCE-SECTION1           THRU 3800-EXIT     
           END-IF.                                                      
      *                                                                         
           IF WS-TOTAL-AR-BALANCE-AT GREATER THAN ZERO                  
            AND WS-HOLD-FINAL-DATE-10 EQUAL WS-INPUT-DATE               
P0599A      AND SB-CODE-BOND-TYPE EQUAL 'B'                             
             MOVE WS-LIT-FB-ILC        TO E-FRP115-REPORT-ACTION        
             PERFORM 3800-PRODUCE-SECTION1           THRU 3800-EXIT     
           END-IF.                                                      
      *                                                                         
P0599A     MOVE SB-BOND-EXPIRATION-DT TO WS-EXPIRATION-DT               
      *                                                                         
P0599A     IF SB-CODE-BOND-TYPE EQUAL 'A'                               
P0599A      AND SB-CODE-STATUS EQUAL 'A'                                
P0599A      AND SB-BOND-EXPIRATION-DT GREATER THAN WS-INPUT-DATE        
P0599A      AND ((SB-BOND-EXPIRATION-DT                                 
P26289                       LESS THAN OR EQUAL WS-DATE-60-FUTURE-DAYS) 
P26289       OR (WS-EXPIRATION-DT-CCYY = WS-FUTURE-CCYY AND             
P26289          WS-EXPIRATION-DT-MM = WS-FUTURE-MM))                    
P00599       MOVE SB-BOND-EXPIRATION-DT TO WS-DATE-10                   
P26289       MOVE WS-D10-MM             TO WS-D8-MM                     
P26289       MOVE WS-D10-DD             TO WS-D8-DD                     
P26289       MOVE WS-D10-YY             TO WS-D8-YY                     
P26289       MOVE WS-DATE-8             TO WS-SB-EXP-DATE               
P26289       MOVE WS-LIT-SB-EXP         TO E-FRP115-REPORT-ACTION       
P26289       PERFORM 3800-PRODUCE-SECTION1           THRU 3800-EXIT     
P26289     END-IF.                                                      
      *                                                                         
P0599A     IF SB-CODE-BOND-TYPE EQUAL 'B'                               
P0599A      AND SB-CODE-STATUS EQUAL 'A'                                
P0599A      AND SB-BOND-EXPIRATION-DT GREATER THAN WS-INPUT-DATE        
P00599      AND ((SB-BOND-EXPIRATION-DT                                 
C34788                       LESS THAN OR EQUAL WS-DATE-60-FUTURE-DAYS) 
P26289       OR (WS-EXPIRATION-DT-CCYY = WS-FUTURE-CCYY AND             
P26289          WS-EXPIRATION-DT-MM = WS-FUTURE-MM))                    
P0599A       MOVE SB-BOND-EXPIRATION-DT TO WS-DATE-10                   
             MOVE WS-D10-MM             TO WS-D8-MM                     
             MOVE WS-D10-DD             TO WS-D8-DD                     
             MOVE WS-D10-YY             TO WS-D8-YY                     
             MOVE WS-DATE-8             TO WS-ILC-EXP-DATE              
             MOVE WS-LIT-ILC-EXP        TO E-FRP115-REPORT-ACTION       
             PERFORM 3800-PRODUCE-SECTION1           THRU 3800-EXIT     
           END-IF.                                                      
      *                                                                         
T20819     MOVE WS-ACCOUNT-NO-AT       TO AT-ACCOUNT-NO.                
T20819     PERFORM 7500-SELECT-ADDRESS-ID            THRU 7500-EXIT.    
P0599A     IF SB-CODE-BOND-TYPE EQUAL 'B'                               
P0599A       AND (SB-BOND-EXPIRATION-DT                                 
                                   LESS THAN OR EQUAL WS-INPUT-DATE)    
T20819       AND (AT-DATE-BILL-DAY-30                                   
P0599A                LESS THAN SB-BOND-EXPIRATION-DT)                  
               MOVE WS-LIT-EXP-ILC       TO E-FRP115-REPORT-ACTION      
               PERFORM 3800-PRODUCE-SECTION1       THRU 3800-EXIT       
           END-IF.                                                      
P0599A     IF SB-CODE-BOND-TYPE EQUAL 'A'                               
P0599A       AND (SB-BOND-EXPIRATION-DT                                 
P26289                             LESS THAN OR EQUAL WS-INPUT-DATE)    
P26289       AND (AT-DATE-BILL-DAY-30                                   
P0599A                LESS THAN SB-BOND-EXPIRATION-DT)                  
P26289         MOVE WS-LIT-EXP-SB        TO E-FRP115-REPORT-ACTION      
P26289         PERFORM 3800-PRODUCE-SECTION1       THRU 3800-EXIT       
P26289     END-IF.                                                      
      *                                                                         
P0599A     IF SB-CODE-BOND-TYPE EQUAL 'A'                               
P0599A      AND SB-CODE-STATUS EQUAL 'A'                                
            AND WS-BANKRUPTCY-IND-AT EQUAL 'B'                          
             MOVE WS-LIT-BKRPT-SB      TO E-FRP115-REPORT-ACTION        
             PERFORM 3820-PRODUCE-SECTION3           THRU 3820-EXIT     
           END-IF.                                                      
      *                                                                         
P0599A     IF SB-CODE-BOND-TYPE EQUAL 'B'                               
P0599A      AND SB-CODE-STATUS EQUAL 'A'                                
            AND WS-BANKRUPTCY-IND-AT EQUAL 'B'                          
             MOVE WS-LIT-BKRPT-ILC     TO E-FRP115-REPORT-ACTION        
             PERFORM 3820-PRODUCE-SECTION3           THRU 3820-EXIT     
           END-IF.                                                      
      *                                                                         
P0599A     PERFORM 7380-FETCH-SURETY-BOND-CSR        THRU 7380-EXIT.    
      *                                                                         
       3750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3775-PROCESS-RELEASES                                    **         
      **      MODULE PROCESSES GUARANTOR RELEASE CONDITIONS          **         
      **      - AUTOMATIC RELEASES (SCSCA108)                        **         
      **      - MANUAL RELEASES (PANEL 245)                          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3775-PROCESS-RELEASES.                                           
      *                                                                         
           MOVE MH-ACCOUNT-NO          TO AT-ACCOUNT-NO.                
           PERFORM 7500-SELECT-ADDRESS-ID            THRU 7500-EXIT.    
      *                                                                         
T20513     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P26289         IF E-FRP115-REPORT-ACTION = WS-LIT-GC-GR                 
                 PERFORM 3815-PRODUCE-SECTION2-GUAR      THRU 3815-EXIT 
P26289           PERFORM 7360-FETCH-GC-RELEASE-CSR       THRU 7360-EXIT 
               ELSE                                                     
T13346           PERFORM 3815-PRODUCE-SECTION2-GUAR      THRU 3815-EXIT 
P26289           PERFORM 7310-FETCH-RELEASE-CSR          THRU 7310-EXIT 
T20513         END-IF                                                   
           END-IF.                                                      
      *                                                                         
       3775-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3800-PRODUCE-SECTION1                                    **         
      **      MODULE PRODUCES DETAIL SECTION 1 RECORDS FOR THE       **         
      **      OUTPUT FILE.                                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3800-PRODUCE-SECTION1.                                           
      *                                                                         
           PERFORM 3850-BUILD-DETAIL                 THRU 3850-EXIT.    
      *                                                                         
           MOVE WS-ALPHA-1             TO E-FRP115-REPORT-SECTION.      
      *                                                                         
           PERFORM 8500-WRITE-RP115-FILE             THRU 8500-EXIT.    
      *                                                                         
           ADD 1                       TO WS-FRP115-REC-COUNTER.        
      *                                                                         
       3800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3805-PRODUCE-FB-SECTION1                                 **         
      **      MODULE PRODUCES DETAIL SECTION 1 RECORDS FOR THE       **         
      **      OUTPUT FILE - CLONE TO FULFILL DIFFERENT REQUIREMENTS  **         
      **      FOR PROCESSING GUARANTOR FINAL BILLED.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3805-PRODUCE-FB-SECTION1.                                        
      *                                                                         
           PERFORM 3855-BUILD-DETAIL-FB              THRU 3855-EXIT.    
      *                                                                         
           MOVE WS-ALPHA-1             TO E-FRP115-REPORT-SECTION.      
      *                                                                         
           PERFORM 8500-WRITE-RP115-FILE             THRU 8500-EXIT.    
      *                                                                         
           ADD 1                       TO WS-FRP115-REC-COUNTER.        
      *                                                                         
       3805-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3810-PRODUCE-SECTION2                                    **         
      **      MODULE PRODUCES DETAIL SECTION 2 RECORDS FOR THE       **         
      **      OUTPUT FILE.                                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3810-PRODUCE-SECTION2.                                           
      *                                                                         
           PERFORM 3850-BUILD-DETAIL                 THRU 3850-EXIT.    
      *                                                                         
           MOVE WS-ALPHA-2             TO E-FRP115-REPORT-SECTION.      
      *                                                                         
           PERFORM 8500-WRITE-RP115-FILE             THRU 8500-EXIT.    
      *                                                                         
           ADD 1                       TO WS-FRP115-REC-COUNTER.        
      *                                                                         
       3810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3815-PRODUCE-SECTION2-GUAR                               **         
      **      MODULE PRODUCES DETAIL SECTION 2 RECORDS FOR THE       **         
      **      OUTPUT FILE - CLONE TO FULFILL DIFFERENT REQUIREMENTS  **         
      **      FOR PROCESSING GUARANTOR RELEASES.                     **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3815-PRODUCE-SECTION2-GUAR.                                      
      *                                                                         
           PERFORM 3860-BUILD-DETAIL-GUAR            THRU 3860-EXIT.    
      *                                                                         
           MOVE WS-ALPHA-2             TO E-FRP115-REPORT-SECTION.      
      *                                                                         
           PERFORM 8500-WRITE-RP115-FILE             THRU 8500-EXIT.    
      *                                                                         
           ADD 1                       TO WS-FRP115-REC-COUNTER.        
      *                                                                         
       3815-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3820-PRODUCE-SECTION3                                    **         
      **      MODULE PRODUCES DETAIL SECTION 3 RECORDS FOR THE       **         
      **      OUTPUT FILE.                                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3820-PRODUCE-SECTION3.                                           
      *                                                                         
           PERFORM 3850-BUILD-DETAIL                 THRU 3850-EXIT.    
      *                                                                         
           MOVE WS-ALPHA-3             TO E-FRP115-REPORT-SECTION.      
      *                                                                         
           PERFORM 8500-WRITE-RP115-FILE             THRU 8500-EXIT.    
      *                                                                         
           ADD 1                       TO WS-FRP115-REC-COUNTER.        
      *                                                                         
       3820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3850-BUILD-DETAIL                                        **         
      **      MODULE BUILDS DETAIL RECORDS FOR ALL REPORT MESSAGES   **         
      **      (EXCEPT GUARANTOR FINAL BILLED AND GUARANTOR RELEASES) **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3850-BUILD-DETAIL.                                               
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT       TO E-FRP115-ACCOUNT-NUMBER,      
                                          AT-ACCOUNT-NO                 
P00599                                    CZ-ACCOUNT-NO.                
           MOVE WS-COMPANY-NO-AT       TO E-FRP115-COMPANY-NO.          
           MOVE WS-ADDRESS-ID-AT       TO AT-ADDRESS-ID.                
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS            THRU 4000-EXIT.    
      *                                                                         
           MOVE WS-CUSTOMER-NAME       TO E-FRP115-CUSTOMER-NAME.       
           MOVE WS-PR-STREET           TO E-FRP115-CUSTOMER-ADDRESS.    
           MOVE WS-PR-ADDR-CITY-STATE-ZIP                               
                                       TO E-FRP115-CUSTOMER-CITY-ST-ZIP.
P26289*                                                                         
P26289     IF E-FRP115-REPORT-ACTION = WS-LIT-BKRPT-AG                  
P26289        MOVE SPACES                 TO E-FRP115-BOND-EXPIRATION-DT
P26289        MOVE WS-GUAR-ESTBLSH-DT(WS-TAB-IDX)TO WS-DATE-10          
P26289        MOVE WS-D10-MM              TO WS-D10-MM-RPT              
P26289        MOVE WS-D10-DD              TO WS-D10-DD-RPT              
P26289        MOVE WS-D10-CC              TO WS-D10-CC-RPT              
P26289        MOVE WS-D10-YY              TO WS-D10-YY-RPT              
P26289        MOVE WS-DATE-10-RPT         TO E-FRP115-DATE-BOND-ISSUED  
P26289     ELSE                                                         
P0599A        MOVE SB-BOND-EXPIRATION-DT   TO WS-DATE-10                
P26289        MOVE WS-D10-MM               TO WS-D10-MM-RPT             
P26289        MOVE WS-D10-DD               TO WS-D10-DD-RPT             
P26289        MOVE WS-D10-CC               TO WS-D10-CC-RPT             
P26289        MOVE WS-D10-YY               TO WS-D10-YY-RPT             
P26289        MOVE WS-DATE-10-RPT         TO E-FRP115-BOND-EXPIRATION-DT
P00599        MOVE SB-DATE-BOND-ISSUED     TO WS-DATE-10                
P26289        MOVE WS-D10-MM               TO WS-D10-MM-RPT             
P26289        MOVE WS-D10-DD               TO WS-D10-DD-RPT             
P26289        MOVE WS-D10-CC               TO WS-D10-CC-RPT             
P26289        MOVE WS-D10-YY               TO WS-D10-YY-RPT             
P26289        MOVE WS-DATE-10-RPT          TO E-FRP115-DATE-BOND-ISSUED 
P26289     END-IF.                                                      
P00599     PERFORM 7550-SELECT-CREDIT-PROFILE        THRU 7550-EXIT.    
P0599A     MOVE SB-BOND-NO                 TO E-FRP115-BOND-LTR-NUMBER. 
P0599A     MOVE SB-AMT-BOND                TO E-FRP115-AMT-BOND.        
P26289     MOVE WS-CREDIT-GROUP-AT         TO E-FRP115-CREDIT-GROUP.    
P00599     MOVE CZ-DISCONNECT-HIST         TO E-FRP115-CREDIT-HIST.     
P00599     MOVE CZ-ARREARS-HIST           TO E-FRP115-UTIL-ARREARS-HIST.
      *                                                                         
       3850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3855-BUILD-DETAIL-FB                                     **         
      **      MODULE BUILDS THE DETAIL RECORDS FOR GUARANTOR FINAL   **         
      **      BILLED.  CLONED FOR DIFFERENT REQUIREMENTS.            **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3855-BUILD-DETAIL-FB.                                            
      *                                                                         
           MOVE AT-ACCOUNT-NO          TO E-FRP115-ACCOUNT-NUMBER       
P26289                                    CZ-ACCOUNT-NO.                
           MOVE AT-COMPANY-NO          TO E-FRP115-COMPANY-NO.          
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS            THRU 4000-EXIT.    
      *                                                                         
           MOVE WS-CUSTOMER-NAME       TO E-FRP115-CUSTOMER-NAME.       
           MOVE WS-PR-STREET           TO E-FRP115-CUSTOMER-ADDRESS.    
           MOVE WS-PR-ADDR-CITY-STATE-ZIP                               
                                       TO E-FRP115-CUSTOMER-CITY-ST-ZIP.
      *                                                                         
           MOVE WS-ACCOUNT-NO-AT       TO AT-ACCOUNT-NO                 
           MOVE WS-ADDRESS-ID-AT       TO AT-ADDRESS-ID.                
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS            THRU 4000-EXIT.    
      *                                                                         
           MOVE WS-CUSTOMER-NAME       TO WS-NAMED-GUARANTOR.           
           MOVE WS-LIT-GFB-NAME        TO E-FRP115-REPORT-ACTION.       
P26289*                                                                         
P26289     PERFORM 7550-SELECT-CREDIT-PROFILE THRU 7550-EXIT.           
P26289     MOVE SPACES                 TO E-FRP115-BOND-EXPIRATION-DT.  
P26289     MOVE GU-GUAR-ESTBLSH-DT     TO WS-DATE-10.                   
P26289     MOVE WS-D10-MM              TO WS-D10-MM-RPT.                
P26289     MOVE WS-D10-DD              TO WS-D10-DD-RPT.                
P26289     MOVE WS-D10-CC              TO WS-D10-CC-RPT.                
P26289     MOVE WS-D10-YY              TO WS-D10-YY-RPT.                
P26289     MOVE WS-DATE-10-RPT         TO E-FRP115-DATE-BOND-ISSUED.    
P26289     MOVE GU-AMOUNT-GUARANTEED   TO E-FRP115-AMT-BOND.            
P26289     MOVE AT-CREDIT-GROUP        TO E-FRP115-CREDIT-GROUP.        
P26289     MOVE CZ-DISCONNECT-HIST     TO E-FRP115-CREDIT-HIST.         
P26289     MOVE CZ-ARREARS-HIST        TO E-FRP115-UTIL-ARREARS-HIST.   
      *                                                                         
       3855-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3860-BUILD-DETAIL-GUAR                                   **         
      **      MODULE BUILDS THE DETAIL RECORDS FOR GUARANTOR         **         
      **      RELEASES.  CLONED FOR DIFFERENT REQUIREMENTS.          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3860-BUILD-DETAIL-GUAR.                                          
      *                                                                         
           PERFORM 4000-MAIL-NAME-ADDRESS            THRU 4000-EXIT.    
      *                                                                         
           MOVE WS-CUSTOMER-NAME       TO E-FRP115-CUSTOMER-NAME.       
           MOVE WS-PR-STREET           TO E-FRP115-CUSTOMER-ADDRESS.    
           MOVE WS-PR-ADDR-CITY-STATE-ZIP                               
                                       TO E-FRP115-CUSTOMER-CITY-ST-ZIP.
      *                                                                         
           MOVE AT-ACCOUNT-NO          TO E-FRP115-ACCOUNT-NUMBER       
P26289                                    GU-ACCOUNT-NO                 
P26289                                    CZ-ACCOUNT-NO.                
           MOVE AT-COMPANY-NO          TO E-FRP115-COMPANY-NO.          
P26289*                                                                         
P26289     PERFORM 7535-SELECT-GUARANTOR      THRU 7535-EXIT.           
P26289     PERFORM 7550-SELECT-CREDIT-PROFILE THRU 7550-EXIT.           
P26289     MOVE SPACES                 TO E-FRP115-BOND-EXPIRATION-DT.  
P26289     MOVE GU-GUAR-ESTBLSH-DT     TO WS-DATE-10.                   
P26289     MOVE WS-D10-MM              TO WS-D10-MM-RPT.                
P26289     MOVE WS-D10-DD              TO WS-D10-DD-RPT.                
P26289     MOVE WS-D10-CC              TO WS-D10-CC-RPT.                
P26289     MOVE WS-D10-YY              TO WS-D10-YY-RPT.                
P26289     MOVE WS-DATE-10-RPT         TO E-FRP115-DATE-BOND-ISSUED.    
P26289     MOVE GU-AMOUNT-GUARANTEED   TO E-FRP115-AMT-BOND.            
P26289     MOVE AT-CREDIT-GROUP        TO E-FRP115-CREDIT-GROUP.        
P26289     MOVE CZ-DISCONNECT-HIST     TO E-FRP115-CREDIT-HIST.         
P26289     MOVE CZ-ARREARS-HIST        TO E-FRP115-UTIL-ARREARS-HIST.   
      *                                                                         
       3860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    3950-LOAD-GUARANTOR-TABLE                                **         
      **      MODULE LOADS A TABLE WITH GUARANTOR STATUS CODE AND    **         
      **      GUARANTOR ACCOUNT NUMBER FOR FURTHER PROCESSING -      **         
      **      ONE ACCOUNT MAY HAVE MORE THAN ONE GUARANTOR.          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       3950-LOAD-GUARANTOR-TABLE.                                       
      *                                                                         
           MOVE GU-GUAR-STATUS-CD     TO WS-GUAR-STATUS-CD(WS-TAB-IDX). 
           MOVE GU-GUARNTR-ACCT-NO    TO WS-GUARNTR-ACCT-NO(WS-TAB-IDX).
P26289     MOVE GU-GUAR-ESTBLSH-DT    TO WS-GUAR-ESTBLSH-DT(WS-TAB-IDX).
      *                                                                         
           PERFORM 7110-FETCH-GUARANTOR-CURSOR       THRU 7110-EXIT.    
      *                                                                         
       3950-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    4000-MAIL-NAME-ADDRESS                                   **         
      **      COPYBOOK CPD00074 RETRIEVES AND FORMATS NAME AND       **         
      **      ADDRESS FOR THE GIVEN ACCOUNT AND ADDRESS ID.          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00074                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    6010-REDUCE-EMBEDDED-SPACES                              **         
      **      COPYBOOK CPD00004 REDUCES EMBEDDED SPACES IN CONCAT-   **         
      **      ENATED FIELDS - IT IS USED BY CPD00074 IN PROCESSING   **         
      **      NAME AND ADDRESS INFORMATION.                          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00004                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    6240-GET-FCA00-COMMON-DATE                               **         
      **      IF NECESSARY, COPYBOOK CPD00040 RETRIEVES THE COMMON   **         
      **      DATE FROM TABLE CSS_JOB_PARM.                          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00040                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    6251-GET-FJC01-DATE                                      **         
      **      THIS COPYBOOK, CPD00037, CONTAINS THE DB2 STATEMENTS   **         
      **      NECESSARY TO RETRIEVE PARAMETERS FROM TABLE CSS_JOB_   **         
      **      PARM.                                                  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00037                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7000-READ-FCSBE00                                        **         
      **      MODULE READS THE INPUT BILLING FILE FCSBE00.           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7000-READ-FCSBE00.                                               
      *                                                                         
           READ FCSBE00-FILE                                            
            AT END                                                      
            MOVE WS-N                  TO WS-MORE-DATA-SW               
            GO                         TO 7000-EXIT.                    
      *                                                                         
           IF FBE00-SUCCESSFUL                                          
             ADD 1                     TO WS-FBE00-REC-COUNTER          
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSBE00 PROCESSING ERROR       **'        
             DISPLAY '** READ ERROR OF FCSBE00 - INPUT FILE  **'        
             DISPLAY '**    FILE STATUS = ' WS-FBE00-STATUS             
             DISPLAY '**       PROCESSING TERMINATED         **'        
             DISPLAY '*****************************************'        
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7100-OPEN-GUARANTOR-CURSOR                               **         
      **      OPENS THE CURSOR REPONSIBLE FOR RETRIEVING ALL         **         
      **      GUARANTOR STATUS CODES AND GUARANTOR ACCOUNT NUMBERS   **         
      **      FOR THE GIVEN ACCOUNT.                                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7100-OPEN-GUARANTOR-CURSOR.                                      
      *                                                                         
           MOVE '7100'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             OPEN  GUARANTOR_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      PCSCA115 PROCESSING ERROR      **'        
             DISPLAY '** CURSOR OPEN ERROR IN PARAGRAPH 7100 **'        
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED        **'        
             DISPLAY '*****************************************'        
             MOVE 'OPEN'               TO ABEND-FUNCTION                
             MOVE 'CSS_GUARANTOR'      TO TABLE-1                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7110-FETCH-GUARANTOR-CURSOR                              **         
      **      FETCHES GUARANTOR STATUS CODE AND GUARANTOR ACCOUNT    **         
      **      NUMBER INTO HOST VARIABLES.                            **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7110-FETCH-GUARANTOR-CURSOR.                                     
      *                                                                         
           MOVE '7110'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             FETCH   GUARANTOR_CSR                                      
              INTO   :GU-GUAR-STATUS-CD,                                
                     :GU-GUARNTR-ACCT-NO                                
P26289              ,:GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI             
P26289              ,:GU-AMOUNT-GUARANTEED                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P26289       IF WS-ESTBLSH-DATE-NI < 0                                  
P26289           MOVE SPACES TO GU-GUAR-ESTBLSH-DT                      
P26289       END-IF                                                     
           ELSE                                                         
             DISPLAY '******************************************'       
             DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
             DISPLAY '** CURSOR FETCH ERROR IN PARAGRAPH 7110 **'       
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED         **'       
             DISPLAY '******************************************'       
             MOVE 'FETCH'              TO ABEND-FUNCTION                
             MOVE 'CSS_GUARANTOR'      TO TABLE-1                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7120-CLOSE-GUARANTOR-CURSOR                              **         
      **      CLOSES THE CURSOR RESPONSIBLE FOR RETRIEVING ALL       **         
      **      GUARANTOR STATUS CODES AND GUARANTOR ACCOUNT NUMBERS   **         
      **      FOR THE GIVEN ACCOUNT.                                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7120-CLOSE-GUARANTOR-CURSOR.                                     
      *                                                                         
           MOVE '7120'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             CLOSE   GUARANTOR_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '******************************************'       
             DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
             DISPLAY '** CURSOR CLOSE ERROR IN PARAGRAPH 7120 **'       
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED         **'       
             DISPLAY '******************************************'       
             MOVE 'CLOSE'              TO ABEND-FUNCTION                
             MOVE 'CSS_GUARANTOR'      TO TABLE-1                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7200-OPEN-GUAR-ACCT-CSR                                  **         
      **      MODULE OPENS THE CURSOR RESPONSIBLE FOR SELECTING ALL  **         
      **      GUARANTEED ACCOUNTS WHICH ARE ASSOCIATED WITH A        **         
      **      GUARANTOR ACCOUNT WHICH HAS FINALED ON THE COMMON DATE.**         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7200-OPEN-GUAR-ACCT-CSR.                                         
      *                                                                         
           MOVE '7200'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             OPEN  GUAR_ACCT_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      PCSCA115 PROCESSING ERROR      **'        
             DISPLAY '** CURSOR OPEN ERROR IN PARAGRAPH 7200 **'        
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED        **'        
             DISPLAY '*****************************************'        
             MOVE 'OPEN'               TO ABEND-FUNCTION                
             MOVE 'CSS_ACCOUNT'        TO TABLE-1                       
             MOVE 'CSS_GUARANTOR'      TO TABLE-2                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7210-FETCH-GUAR-ACCT-CSR                                 **         
      **      MODULE FETCHES THE CURSOR RESPONSIBLE FOR SELECTING ALL**         
      **      GUARANTEED ACCOUNTS WHICH ARE ASSOCIATED WITH A        **         
      **      GUARANTOR ACCOUNT WHICH HAS FINALED ON THE COMMON DATE.**         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7210-FETCH-GUAR-ACCT-CSR.                                        
      *                                                                         
           MOVE '7210'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             FETCH   GUAR_ACCT_CSR                                      
              INTO   :AT-ACCOUNT-NO,                                    
                     :AT-ADDRESS-ID,                                    
                     :AT-COMPANY-NO                                     
P26289              ,:AT-CREDIT-GROUP                                   
P26289              ,:GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI             
P26289              ,:GU-AMOUNT-GUARANTEED                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P26289       IF WS-ESTBLSH-DATE-NI < 0                                  
P26289           MOVE SPACES TO GU-GUAR-ESTBLSH-DT                      
P26289       END-IF                                                     
           ELSE                                                         
             DISPLAY '******************************************'       
             DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
             DISPLAY '** CURSOR FETCH ERROR IN PARAGRAPH 7210 **'       
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED         **'       
             DISPLAY '******************************************'       
             MOVE 'FETCH'              TO ABEND-FUNCTION                
             MOVE 'CSS_ACCOUNT'        TO TABLE-1                       
             MOVE 'CSS_GUARANTOR'      TO TABLE-2                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7220-CLOSE-GUAR-ACCT-CSR                                 **         
      **      MODULE CLOSES THE CURSOR RESPONSIBLE FOR SELECTING ALL **         
      **      GUARANTEED ACCOUNTS WHICH ARE ASSOCIATED WITH A        **         
      **      GUARANTOR ACCOUNT WHICH HAS FINALED ON THE COMMON DATE.**         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7220-CLOSE-GUAR-ACCT-CSR.                                        
      *                                                                         
           MOVE '7220'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             CLOSE   GUAR_ACCT_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '******************************************'       
             DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
             DISPLAY '** CURSOR CLOSE ERROR IN PARAGRAPH 7220 **'       
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED         **'       
             DISPLAY '******************************************'       
             MOVE 'CLOSE'              TO ABEND-FUNCTION                
             MOVE 'CSS_ACCOUNT'        TO TABLE-1                       
             MOVE 'CSS_GUARANTOR'      TO TABLE-2                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7300-OPEN-RELEASE-CSR                                    **         
      **      MODULE OPENS THE CURSOR RESPONSIBLE FOR SELECTING ALL  **         
P26289**      MANUAL GUARANTOR RELEASES WHICH HAVE                   **         
      **      OCCURRED ON THE SPECIFIED COMMON DATE.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7300-OPEN-RELEASE-CSR.                                           
      *                                                                         
           MOVE '7300'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             OPEN  RELEASE_CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      PCSCA115 PROCESSING ERROR      **'        
             DISPLAY '** CURSOR OPEN ERROR IN PARAGRAPH 7300 **'        
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED        **'        
             DISPLAY '*****************************************'        
             MOVE 'OPEN'               TO ABEND-FUNCTION                
             MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                       
             MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-2                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7310-FETCH-RELEASE-CSR                                   **         
      **      MODULE FETCHES THE CURSOR RESPONSIBLE FOR SELECTING ALL**         
P26289**      MANUAL GUARANTOR RELEASES WHICH HAVE                   **         
      **      OCCURRED ON THE SPECIFIED COMMON DATE.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7310-FETCH-RELEASE-CSR.                                          
      *                                                                         
           MOVE '7310'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             FETCH   RELEASE_CSR                                        
              INTO   :MH-ACCOUNT-NO                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P26289       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
P26289         MOVE WS-LIT-GUAR-RLSE TO E-FRP115-REPORT-ACTION          
P26289       ELSE                                                       
P26289         CONTINUE                                                 
P26289       END-IF                                                     
           ELSE                                                         
             DISPLAY '******************************************'       
             DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
             DISPLAY '** CURSOR FETCH ERROR IN PARAGRAPH 7310 **'       
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED         **'       
             DISPLAY '******************************************'       
             MOVE 'FETCH'              TO ABEND-FUNCTION                
             MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                       
             MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-2                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7320-CLOSE-RELEASE-CSR                                   **         
      **      MODULE CLOSES THE CURSOR RESPONSIBLE FOR SELECTING ALL **         
P26289**      MANUAL GUARANTOR RELEASES WHICH HAVE                   **         
      **      OCCURRED ON THE SPECIFIED COMMON DATE.                 **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7320-CLOSE-RELEASE-CSR.                                          
      *                                                                         
           MOVE '7320'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             CLOSE   RELEASE_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '******************************************'       
             DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
             DISPLAY '** CURSOR CLOSE ERROR IN PARAGRAPH 7320 **'       
             DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
             DISPLAY '**        PROCESSING TERMINATED         **'       
             DISPLAY '******************************************'       
             MOVE 'CLOSE'              TO ABEND-FUNCTION                
             MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                       
             MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-2                       
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P26289*****************************************************************         
P26289**    7350-OPEN-GV-RELEASE-CSR                                 **         
P26289**      MODULE OPENS THE CURSOR RESPONSIBLE FOR SELECTING ALL  **         
P26289**      AUTOMATIC GUARANTOR RELEASES WHICH HAVE                **         
P26289**      OCCURRED ON THE SPECIFIED COMMON DATE.                 **         
P26289*****************************************************************         
P26289*                                                                         
P26289 7350-OPEN-GC-RELEASE-CSR.                                        
P26289*                                                                         
P26289     MOVE '7350'                 TO ACTIVE-PARAGRAPH.             
P26289*                                                                         
P26289     EXEC SQL                                                     
P26289       OPEN  GC_RELEASE_CSR                                       
P26289     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289*                                                                         
P26289     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P26289                                    RS-RETURN-CODE,               
P26289                                    WS-DISP-RETURN-CODE.          
P26289*                                                                         
P26289     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P26289       CONTINUE                                                   
P26289     ELSE                                                         
P26289       DISPLAY '*****************************************'        
P26289       DISPLAY '**      PCSCA115 PROCESSING ERROR      **'        
P26289       DISPLAY '** CURSOR OPEN ERROR IN PARAGRAPH 7350 **'        
P26289       DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
P26289       DISPLAY '**        PROCESSING TERMINATED        **'        
P26289       DISPLAY '*****************************************'        
P26289       MOVE 'OPEN'               TO ABEND-FUNCTION                
P26289       MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                       
P26289       MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-2                       
P26289       PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
P26289     END-IF.                                                      
P26289*                                                                         
P26289 7350-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
P26289*****************************************************************         
P26289**    7360-FETCH-GC-RELEASE-CSR                                **         
P26289**      MODULE FETCHES THE CURSOR RESPONSIBLE FOR SELECTING ALL**         
P26289**      AUTOMATIC GUARANTOR RELEASES WHICH HAVE                **         
P26289**      OCCURRED ON THE SPECIFIED COMMON DATE.                 **         
P26289*****************************************************************         
P26289*                                                                         
P26289 7360-FETCH-GC-RELEASE-CSR.                                       
P26289*                                                                         
P26289     MOVE '7360'                 TO ACTIVE-PARAGRAPH.             
P26289*                                                                         
P26289     EXEC SQL                                                     
P26289       FETCH   GC_RELEASE_CSR                                     
P26289        INTO   :MH-ACCOUNT-NO                                     
P26289     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289*                                                                         
P26289     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P26289                                    RS-RETURN-CODE,               
P26289                                    WS-DISP-RETURN-CODE.          
P26289*                                                                         
P26289     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P26289       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
P26289         MOVE WS-LIT-GC-GR TO E-FRP115-REPORT-ACTION              
P26289       ELSE                                                       
P26289         CONTINUE                                                 
P26289       END-IF                                                     
P26289     ELSE                                                         
P26289       DISPLAY '******************************************'       
P26289       DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
P26289       DISPLAY '** CURSOR FETCH ERROR IN PARAGRAPH 7360 **'       
P26289       DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
P26289       DISPLAY '**        PROCESSING TERMINATED         **'       
P26289       DISPLAY '******************************************'       
P26289       MOVE 'FETCH'              TO ABEND-FUNCTION                
P26289       MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                       
P26289       MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-2                       
P26289       PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
P26289     END-IF.                                                      
P26289*                                                                         
P26289 7360-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
P26289*****************************************************************         
P26289**    7370-CLOSE-GC-RELEASE-CSR                                **         
P26289**      MODULE CLOSES THE CURSOR RESPONSIBLE FOR SELECTING ALL **         
P26289**      AUTOMATIC GUARANTOR RELEASES WHICH HAVE                **         
P26289**      OCCURRED ON THE SPECIFIED COMMON DATE.                 **         
P26289*****************************************************************         
P26289*                                                                         
P26289 7370-CLOSE-GC-RELEASE-CSR.                                       
P26289*                                                                         
P26289     MOVE '7370'                 TO ACTIVE-PARAGRAPH.             
P26289*                                                                         
P26289     EXEC SQL                                                     
P26289       CLOSE   GC_RELEASE_CSR                                     
P26289     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289*                                                                         
P26289     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P26289                                    RS-RETURN-CODE,               
P26289                                    WS-DISP-RETURN-CODE.          
P26289*                                                                         
P26289     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P26289       CONTINUE                                                   
P26289     ELSE                                                         
P26289       DISPLAY '******************************************'       
P26289       DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
P26289       DISPLAY '** CURSOR CLOSE ERROR IN PARAGRAPH 7370 **'       
P26289       DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
P26289       DISPLAY '**        PROCESSING TERMINATED         **'       
P26289       DISPLAY '******************************************'       
P26289       MOVE 'CLOSE'              TO ABEND-FUNCTION                
P26289       MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                       
P26289       MOVE 'CSS_MT_TRN_HST_DET' TO TABLE-2                       
P26289       PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
P26289     END-IF.                                                      
P26289*                                                                         
P26289 7370-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
P0599A*****************************************************************         
P0599A**                                                             **         
P0599A**    7375-OPEN-SURETY-BOND-CSR                                **         
P0599A**      MODULE OPENS THE CURSOR RESPONSIBLE FOR SELECTING ALL  **         
P0599A**      SURETY BOND RECORDS.                                   **         
P0599A*****************************************************************         
P0599A*                                                                         
P0599A 7375-OPEN-SURETY-BOND-CSR.                                       
P0599A*                                                                         
P0599A     MOVE '7375'                 TO ACTIVE-PARAGRAPH.             
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A       OPEN  SURETY_BOND_CSR                                      
P0599A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P0599A                                    RS-RETURN-CODE,               
P0599A                                    WS-DISP-RETURN-CODE.          
P0599A*                                                                         
P0599A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0599A       CONTINUE                                                   
P0599A     ELSE                                                         
P0599A       DISPLAY '*****************************************'        
P0599A       DISPLAY '**      PCSCA115 PROCESSING ERROR      **'        
P0599A       DISPLAY '** CURSOR OPEN ERROR IN PARAGRAPH 7375 **'        
P0599A       DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
P0599A       DISPLAY '**        PROCESSING TERMINATED        **'        
P0599A       DISPLAY '*****************************************'        
P0599A       MOVE 'OPEN'               TO ABEND-FUNCTION                
P0599A       MOVE 'CSS_SURETY_BOND' TO TABLE-1                          
P0599A       PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7375-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
P0599A*****************************************************************         
P0599A**                                                             **         
P0599A**    7380-FETCH-SURETY-BOND-CSR                               **         
P0599A**      MODULE FETCHES THE CURSOR RESPONSIBLE FOR SELECTING ALL**         
P0599A**      SURETY BOND RECORDS.                                   **         
P0599A*****************************************************************         
P0599A*                                                                         
P0599A 7380-FETCH-SURETY-BOND-CSR.                                      
P0599A*                                                                         
P0599A     MOVE '7380'                 TO ACTIVE-PARAGRAPH.             
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A       FETCH   SURETY_BOND_CSR                                    
P0599A        INTO  :SB-BOND-NO                                         
P0599A             ,:SB-DATE-BOND-ISSUED :WS-NULL-IND-1                  
P0599A             ,:SB-AMT-BOND :WS-NULL-IND-2                          
P0599A             ,:SB-CODE-BOND-TYPE                                  
P0599A             ,:SB-CODE-STATUS                                     
P0599A             ,:SB-BOND-EXPIRATION-DT :WS-NULL-IND-3                
P0599A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P0599A                                    RS-RETURN-CODE,               
P0599A                                    WS-DISP-RETURN-CODE.          
P0599A*                                                                         
P0599A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0599A       IF WS-NULL-IND-1 < ZERO                                    
P0599A           MOVE SPACES     TO SB-DATE-BOND-ISSUED                 
P0599A       END-IF                                                     
P0599A       IF WS-NULL-IND-2 < ZERO                                    
P0599A           MOVE ZEROS      TO SB-AMT-BOND                         
P0599A       END-IF                                                     
P0599A       IF WS-NULL-IND-3 < ZERO                                    
P0599A           MOVE LOW-VALUES TO SB-BOND-EXPIRATION-DT               
P0599A       END-IF                                                     
P0599A     ELSE                                                         
P0599A       DISPLAY '******************************************'       
P0599A       DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
P0599A       DISPLAY '** CURSOR FETCH ERROR IN PARAGRAPH 7380 **'       
P0599A       DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
P0599A       DISPLAY '**        PROCESSING TERMINATED         **'       
P0599A       DISPLAY '******************************************'       
P0599A       MOVE 'FETCH'              TO ABEND-FUNCTION                
P0599A       MOVE 'CSS_SURETY_BOND' TO TABLE-1                          
P0599A       PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7380-EXIT.                                                       
P0599A     EXIT.                                                        
P0599A*                                                                         
P0599A*****************************************************************         
P0599A**                                                             **         
P0599A**    7385-CLOSE-SURETY-BOND-CSR                               **         
P0599A**      MODULE CLOSES THE CURSOR RESPONSIBLE FOR SELECTING ALL **         
P0599A**      SURETY BOND RECORDS.                                   **         
P0599A**                                                             **         
P0599A*****************************************************************         
P0599A*                                                                         
P0599A 7385-CLOSE-SURETY-BOND-CSR.                                      
P0599A*                                                                         
P0599A     MOVE '7385'                 TO ACTIVE-PARAGRAPH.             
P0599A*                                                                         
P0599A     EXEC SQL                                                     
P0599A       CLOSE   SURETY_BOND_CSR                                    
P0599A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0599A*                                                                         
P0599A     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P0599A                                    RS-RETURN-CODE,               
P0599A                                    WS-DISP-RETURN-CODE.          
P0599A*                                                                         
P0599A     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P0599A       CONTINUE                                                   
P0599A     ELSE                                                         
P0599A       DISPLAY '******************************************'       
P0599A       DISPLAY '**      PCSCA115 PROCESSING ERROR       **'       
P0599A       DISPLAY '** CURSOR CLOSE ERROR IN PARAGRAPH 7385 **'       
P0599A       DISPLAY '**          SQLCODE = ' WS-DISP-RETURN-CODE       
P0599A       DISPLAY '**        PROCESSING TERMINATED         **'       
P0599A       DISPLAY '******************************************'       
P0599A       MOVE 'CLOSE'              TO ABEND-FUNCTION                
P0599A       MOVE 'CSS_SURETY_BOND' TO TABLE-1                          
P0599A       PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
P0599A     END-IF.                                                      
P0599A*                                                                         
P0599A 7385-EXIT.                                                       
P0599A     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
C34788**    7400-GET-60-DAYS-FROM-NOW                                **         
C34788**      MODULE COMPUTES 60 DAYS FROM THE PRESENT   -            **        
      **      NEEDED FOR A CONDTION WITHIN THE PROGRAM.              **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
C34788 7400-GET-60-DAYS-FROM-NOW.                                       
      *                                                                         
           MOVE '7400'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
C34788       SELECT
              DATEADD( DAY, 60, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-DATE-60-FUTURE-DAYS                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-DATE-60-FUTURE-DAYS                                        
MFA-TR*             = DATE(:WS-INPUT-DATE) + 60 DAYS                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*************************************'            
             DISPLAY '**    PCSCA115 PROCESSING ERROR    **'            
             DISPLAY '** SELECT ERROR IN PARAGRAPH 7400  **'            
             DISPLAY '**        SQLCODE = ' WS-DISP-RETURN-CODE         
             DISPLAY '**      PROCESSING TERMINATED      **'            
             DISPLAY '*************************************'            
T35434       MOVE 'SET'                TO ABEND-FUNCTION                
             PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P26289*****************************************************************         
P26289**                                                             **         
P26289**    7410-GET-1-YEAR-FROM-NOW                                 **         
P26289**      MODULE COMPUTES 1 YEAR FROM THE PRESENT   -            **         
P26289**      NEEDED FOR A CONDTION WITHIN THE PROGRAM.              **         
P26289**                                                             **         
P26289*****************************************************************         
P26289 7410-GET-1-YEAR-FROM-NOW.                                        
P26289*                                                                         
P26289     MOVE '7410'                 TO ACTIVE-PARAGRAPH.             
P26289*                                                                         
P26289     EXEC SQL                                                     
P26289       SELECT
              DATEADD( YEAR, 1, IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-DATE-1-FUTURE-YEAR                     
P26289     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-DATE-1-FUTURE-YEAR                                         
MFA-TR*             = DATE(:WS-INPUT-DATE) + 1 YEAR                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289*                                                                         
P26289     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P26289                                    RS-RETURN-CODE,               
P26289                                    WS-DISP-RETURN-CODE.          
P26289*                                                                         
P26289     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P26289       CONTINUE                                                   
P26289     ELSE                                                         
P26289       DISPLAY '*************************************'            
P26289       DISPLAY '**    PCSCA115 PROCESSING ERROR    **'            
P26289       DISPLAY '** SELECT ERROR IN PARAGRAPH 7410  **'            
P26289       DISPLAY '**        SQLCODE = ' WS-DISP-RETURN-CODE         
P26289       DISPLAY '**      PROCESSING TERMINATED      **'            
P26289       DISPLAY '*************************************'            
P26289       MOVE 'SET'                TO ABEND-FUNCTION                
P26289       PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT     
P26289     END-IF.                                                      
P26289*                                                                         
P26289 7410-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
      *****************************************************************         
      **                                                             **         
      **    7500-SELECT-ADDRESS-ID                                   **         
      **      RETRIEVES THE ADDRESS ID FOR THE GIVEN ACCOUNT - USED  **         
      **      TO DETERMINE NAME AND ADDRESS INFORMATION FOR GUARAN-  **         
      **      TOR RELEASES.                                          **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       7500-SELECT-ADDRESS-ID.                                          
      *                                                                         
           MOVE '7500'                 TO ACTIVE-PARAGRAPH.             
      *                                                                         
           EXEC SQL                                                     
             SELECT  ADDRESS_ID,                                        
                     COMPANY_NO,                                        
T20819               DATE_BILL_DAY_30                                   
P26289              ,CREDIT_GROUP                                       
               INTO  :AT-ADDRESS-ID,                                    
                     :AT-COMPANY-NO,                                    
T20819               :AT-DATE-BILL-DAY-30                               
P26289              ,:AT-CREDIT-GROUP                                   
               FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
A00633                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  ADDRESS_ID,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              DATE_BILL_DAY_30                                           
MFA-TR*             ,CREDIT_GROUP                                               
MFA-TR*        INTO  :AT-ADDRESS-ID,                                            
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-DATE-BILL-DAY-30                                       
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*        FROM  CSS_ACCOUNT                                                
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
                                          RS-RETURN-CODE,               
                                          WS-DISP-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T20513                              OR    NOT-FOUND                     
             NEXT SENTENCE                                              
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      PCSCA115 PROCESSING ERROR      **'        
             DISPLAY '* SELECT ERROR IN 7500-SELECT-ADDRESS-ID*'        
             DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE             
             DISPLAY '*         PROCESSING TERMINATED         *'        
             DISPLAY '*****************************************'        
T20513       DISPLAY 'AT-ACCOUNT-NO: ' AT-ACCOUNT-NO                    
             MOVE 'SELECT'             TO ABEND-FUNCTION                
             MOVE 'CSS_ACCOUNT'        TO TABLE-1                       
             PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT       
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P26289*****************************************************************         
P26289**                                                             **         
P26289**    7535-SELECT-GUARANTOR                                    **         
P26289**      RETRIEVES THE GUARANTOR INFO FOR THE GIVEN ACCOUNT.    **         
P26289**                                                             **         
P26289*****************************************************************         
P26289*                                                                         
P26289 7535-SELECT-GUARANTOR.                                           
P26289*                                                                         
P26289     MOVE '7535'                 TO ACTIVE-PARAGRAPH.             
P26289*                                                                         
P26289     EXEC SQL                                                     
P26289       SELECT  GUAR_ESTBLSH_DT                                    
P26289              ,AMOUNT_GUARANTEED                                  
P26289         INTO  :GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI             
P26289              ,:GU-AMOUNT-GUARANTEED                              
P26289         FROM  CSS_GUARANTOR GU WITH(READUNCOMMITTED)                     
P26289        WHERE  ACCOUNT_NO = :GU-ACCOUNT-NO                        
A00633                                                           
P26289     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  GUAR_ESTBLSH_DT                                            
MFA-TR*             ,AMOUNT_GUARANTEED                                          
MFA-TR*        INTO  :GU-GUAR-ESTBLSH-DT:WS-ESTBLSH-DATE-NI                     
MFA-TR*             ,:GU-AMOUNT-GUARANTEED                                      
MFA-TR*        FROM  CSS_GUARANTOR GU                                           
MFA-TR*       WHERE  ACCOUNT_NO = :GU-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289*                                                                         
P26289     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P26289                                    RS-RETURN-CODE,               
P26289                                    WS-DISP-RETURN-CODE.          
P26289*                                                                         
P26289     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P26289                              OR    NOT-FOUND                     
P26289                              OR    -811                          
P26289       IF WS-ESTBLSH-DATE-NI < 0                                  
P26289           MOVE SPACES TO GU-GUAR-ESTBLSH-DT                      
P26289       END-IF                                                     
P26289       IF WS-ACTIVE-RETURN-CODE EQUAL -811                        
P26289           MOVE SPACES TO GU-GUAR-ESTBLSH-DT                      
P26289           MOVE ZEROES TO GU-AMOUNT-GUARANTEED                    
P26289       END-IF                                                     
P26289     ELSE                                                         
P26289       DISPLAY '*****************************************'        
P26289       DISPLAY '**      PCSCA115 PROCESSING ERROR      **'        
P26289       DISPLAY '* SELECT ERROR IN 7535-SELECT-GUARANTOR  '        
P26289       DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE             
P26289       DISPLAY '*         PROCESSING TERMINATED         *'        
P26289       DISPLAY '*****************************************'        
P26289       DISPLAY '* GU-ACCOUNT-NO: ' GU-ACCOUNT-NO                  
P26289       MOVE 'SELECT'             TO ABEND-FUNCTION                
P26289       MOVE 'CSS_GUARANTOR'      TO TABLE-1                       
P26289       PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT       
P26289     END-IF.                                                      
P26289*                                                                         
P26289 7535-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
P26289*****************************************************************         
P26289**                                                             **         
P26289**    7550-SELECT-CREDIT-PROFILE                               **         
P26289**    RETRIEVES THE CREDIT PROFILE INFO FOR THE GIVEN ACCOUNT. **         
P26289**                                                             **         
P26289*****************************************************************         
P26289*                                                                         
P26289 7550-SELECT-CREDIT-PROFILE.                                      
P26289*                                                                         
P26289     MOVE '7550'                 TO ACTIVE-PARAGRAPH.             
P26289*                                                                         
P26289     EXEC SQL                                                     
P26289       SELECT  DISCONNECT_HIST                                    
P26289              ,ARREARS_HIST                                       
P26289         INTO  :CZ-DISCONNECT-HIST                                
P26289              ,:CZ-ARREARS-HIST                                   
P26289         FROM  CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
P26289        WHERE  ACCOUNT_NO = :CZ-ACCOUNT-NO                        
A00633                                                           
P26289     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DISCONNECT_HIST                                            
MFA-TR*             ,ARREARS_HIST                                               
MFA-TR*        INTO  :CZ-DISCONNECT-HIST                                        
MFA-TR*             ,:CZ-ARREARS-HIST                                           
MFA-TR*        FROM  CSS_CREDIT_PROFILE                                         
MFA-TR*       WHERE  ACCOUNT_NO = :CZ-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P26289*                                                                         
P26289     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE,        
P26289                                    RS-RETURN-CODE,               
P26289                                    WS-DISP-RETURN-CODE.          
P26289*                                                                         
P26289     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P26289                              OR    NOT-FOUND                     
P26289       NEXT SENTENCE                                              
P26289     ELSE                                                         
P26289       DISPLAY '*******************************************'      
P26289       DISPLAY '**      PCSCA115 PROCESSING ERROR        **'      
P26289       DISPLAY '*SELECT ERROR IN 7550-SELECT-CREDIT-PROFILE'      
P26289       DISPLAY '* RETURN CODE = ' WS-DISP-RETURN-CODE             
P26289       DISPLAY '*         PROCESSING TERMINATED           *'      
P26289       DISPLAY '*******************************************'      
P26289       DISPLAY 'CZ-ACCOUNT-NO: ' SB-ACCOUNT-NO                    
P26289       MOVE 'SELECT'             TO ABEND-FUNCTION                
P26289       MOVE 'CSS_CREDIT_PROFILE' TO TABLE-1                       
P26289       PERFORM 9700-PROCESS-ABEND            THRU 9700-EXIT       
P26289     END-IF.                                                      
P26289*                                                                         
P26289 7550-EXIT.                                                       
P26289     EXIT.                                                        
P26289*                                                                         
      *****************************************************************         
      **                                                             **         
      **    7600-START-FCSJC01                                       **         
      **      COPYBOOK CPD00038 IS UTILIZED IN THE PARAMETER         **         
      **      RETRIEVAL FROM CSS_JOB_PARM.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    7620-START-FCSCA00                                       **         
      **      COPYBOOK CPD00039 IS UTILIZED IN THE PARAMETER         **         
      **      RETRIEVAL FROM CSS_JOB_PARM.                           **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00039                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8000-FMT-FRP115-BEGIN-REC                                **         
      **      MODULE FORMATS AND WRITES THE BEGIN RECORD FOR OUTPUT  **         
      **      FILE FCSRP115.                                         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8000-FMT-FRP115-BEGIN-REC.                                       
      *                                                                         
           MOVE LOW-VALUES             TO E-FRP115-KEY-BREC.            
           MOVE ZEROES                 TO E-FRP115-DB-PART-BREC.        
           MOVE SPACES                 TO E-FRP115-SOURCE-BREC.         
           MOVE E-FBE00-CREATE-DATE-BREC                                
                                       TO E-FRP115-CREATE-DATE-BREC.    
      *                                                                         
           PERFORM 8500-WRITE-RP115-FILE             THRU 8500-EXIT.    
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8100-FMT-FRP115-END-REC                                  **         
      **      MODULE FORMATS AND WRITES THE ENDING RECORD FOR OUTPUT **         
      **      FILE FCSRP115.                                         **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8100-FMT-FRP115-END-REC.                                         
      *                                                                         
           MOVE HIGH-VALUES            TO E-FRP115-KEY-EREC.            
           MOVE ZEROES                 TO E-FRP115-DB-PART-EREC.        
           MOVE SPACES                 TO E-FRP115-SOURCE-EREC.         
           MOVE WS-FRP115-REC-COUNTER  TO E-FRP115-RECORD-COUNT-EREC.   
      *                                                                         
           PERFORM 8500-WRITE-RP115-FILE             THRU 8500-EXIT.    
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    8500-WRITE-RP115-FILE                                    **         
      **      MODULE WRITES DETAIL RECORDS TO THE OUTPUT FILE -      **         
      **      FCSRP115.                                              **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       8500-WRITE-RP115-FILE.                                           
      *                                                                         
           WRITE FIORP115.                                              
      *                                                                         
           INITIALIZE FIORP115.                                         
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9000-TERMINATE                                           **         
      **      MODULE CLOSES ALL OPEN FILES UTILIZED BY THE PROGRAM.  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBE00-FILE.                                          
           IF FBE00-SUCCESSFUL                                          
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '*****************************************'        
             DISPLAY '**      FCSBE00 PROCESSING ERROR       **'        
             DISPLAY '** CLOSE ERROR OF FCSBE00 - INPUT FILE **'        
             DISPLAY '**    FILE STATUS = ' WS-FBE00-STATUS             
             DISPLAY '*****************************************'        
           END-IF.                                                      
      *                                                                         
           CLOSE FCSRP115-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9500-CLEANUP                                             **         
P26289**      WRITES THE OUTPUT FILE ENDING RECORD.                  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
       9500-CLEANUP.                                                    
      *                                                                         
           PERFORM 8100-FMT-FRP115-END-REC           THRU 8100-EXIT.    
      *                                                                         
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9700-PROCESS-ABEND                                       **         
      **      COPYBOOK CPD0023B PERFORM BATCH ABEND PROCESSING.      **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD0023B                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **                                                             **         
      **    9900-ABEND                                               **         
      **      COPYBOOK CPD09900 PERFORMS THE ABEND PROCESSING        **         
      **      UTILIZED BY ALL MAINFRAME COMPONENTS.                  **         
      **                                                             **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
