       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA114.                                        
      ***************************************************************** 00003000
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00004000
      **                     PRICE WATERHOUSE                        ** 00005000
      **                                                             ** 00006000
      **               CUSTOMER INFORMATION SYSTEM                   ** 00007000
      **                                                             ** 00008000
      ***************************************************************** 00009000
      **               P R O G R A M  S U M M A R Y                  ** 00010000
      **                                                             ** 00011000
      ** PCSCA925 REFORMATS BILL PRINT EXTRACT DATA FOR DIALOUGE.    ** 00012000
      **                                                             ** 00013000
      ***************************************************************** 00014000
      *                                                              ** 00015000
      *              PROGRAM  MODIFICATION  LOG                      ** 00016000
      *                                                              ** 00017000
      *    DATE     INITIALS  REASON                                 ** 00018000
      *    ----     --------  ------                                 ** 00019000
PRJ166** 01/2010    RAJ       PULL ACCOUNTS FOR REPRINT.             ** 00705310
      ***************************************************************** 00705400
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSCA911-FILE                                         
               ASSIGN UT-S-FCSCA911                                     
               FILE STATUS IS WS-CA911-STATUS.                          
                                                                        
           SELECT FCSBE28-FILE                                          
               ASSIGN UT-S-FCSBE28                                      
               FILE STATUS IS WS-FBE28-STATUS.                          
                                                                        
           SELECT OUTPUT-FILE                                           
               ASSIGN UT-S-OUTPUT                                       
               FILE STATUS IS WS-OTPUT-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  FCSCA911-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  EXT-SORTIDX-FILE.                                            
           05 FILLER                         PIC X(013).                
           05 EXT-ACCT-ACCOUNT-NO            PIC X(009).                
           05 FILLER                         PIC X(004).                
                                                                        
       FD  FCSBE28-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOBE28.                                                     
           02  FIOBE28-DATA-REC.                                        
               05  FILLER                        PIC X(714).            
               05  E-FBE28-ACCT-NO               PIC X(009).            
CISOP          05  E-FBE28-DATA                 PIC X(0079).            
                                                                        
       FD  OUTPUT-FILE                                                  
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  OUTPUT-R.                                                    
           02  OUTPUT-REC.                                              
CISOP          05  FILLER                        PIC X(0802).           
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-MISC.                                                     
           05  WS-FBE28-STATUS              PIC  X(02).                 
               88 FBE28-SUCCESSFUL                      VALUE '00'.     
           05  WS-CA911-STATUS               PIC XX VALUE '  '.         
               88  CA911-SUCCESSFUL                 VALUE '00'.         
           05  WS-OTPUT-STATUS               PIC XX VALUE '  '.         
               88  OTPUT-SUCCESSFUL                 VALUE '00'.         
           05  WS-END-OF-CA911               PIC X VALUE 'N'.           
               88  END-OF-CA911                    VALUE 'Y'.           
           05  WS-END-OF-BE28                PIC X VALUE 'N'.           
               88  END-OF-BE28                     VALUE 'Y'.           
           05  SUB1                          PIC S9(7) COMP-3 VALUE +0. 
           05  WS-REC-COUNT                  PIC S9(7) COMP-3 VALUE +0. 
           05 WS-PREV-ACCT-NO                PIC X(13) VALUE SPACES.    
           05 WS-FOUND-FLAG                  PIC X(01) VALUE 'N'.       
           05 WS-Y                           PIC X(01) VALUE 'Y'.       
           05 WS-ACCOUNT-TABLE.                                         
              10  WS-ACCOUNT           PIC X(09) OCCURS 5000 TIMES.     
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ***********************************************************       02405000
      *  PERFORM THE PROCESSING ROUTINE FOR EACH INPUT FILE:    *       02406000
      *  BE26 (REGULAR BILLS),                                  *       02407000
      *  BE32 (CONSOLIDATED BILLS)                              *       02408000
      ***********************************************************       02409000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
                                                                        
           PERFORM 7000-READ-FCSCA911           THRU 7000-EXIT          
                                                UNTIL END-OF-CA911.     
                                                                        
           PERFORM 7100-READ-FCSBE28            THRU 7100-EXIT          
                                                UNTIL END-OF-BE28.      
                                                                        
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************       02537000
      *  OPEN INPUT AND OUTPUT FILES.                           *       02538000
      ***********************************************************       02540000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSCA911-FILE.                                    
           IF NOT CA911-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE26           **'         
               DISPLAY '**  FILE STATUS = ' WS-CA911-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           OPEN INPUT FCSBE28-FILE.                                     
           IF NOT FBE28-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE28           **'         
               DISPLAY '**  FILE STATUS = ' WS-FBE28-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN OUTPUT OUTPUT-FILE.                                     
           IF NOT OTPUT-SUCCESSFUL                                      
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE28           **'         
               DISPLAY '**  FILE STATUS = ' WS-OTPUT-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           INITIALIZE WS-ACCOUNT-TABLE.                                 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ************************************************************      03854000
      *  READ THE INPUT FILE                                     *              
      ************************************************************      03856000
                                                                        
       7000-READ-FCSCA911.                                              
                                                                        
           READ FCSCA911-FILE AT END                                    
               MOVE WS-Y TO WS-END-OF-CA911.                            
           IF CA911-SUCCESSFUL                                          
               ADD  +1                          TO SUB1                 
                                                   WS-REC-COUNT         
               IF SUB1 > 5000                                           
                 MOVE 12 TO RETURN-CODE                                 
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA114 PROCESSING ERROR      **'     
                 DISPLAY '**       MORE THAN 5000 ACCOUNTS      **'     
                 DISPLAY '**     PULLED FOR REPRINTS            **'     
                 DISPLAY '****************************************'     
                 PERFORM 9000-TERMINATE THRU 9000-EXIT                  
               ELSE                                                     
                   MOVE EXT-ACCT-ACCOUNT-NO         TO WS-ACCOUNT(SUB1) 
               END-IF                                                   
           ELSE                                                         
               IF END-OF-CA911                                          
                  CONTINUE                                              
               ELSE                                                     
                 MOVE 12 TO RETURN-CODE                                 
                 DISPLAY '****************************************'     
                 DISPLAY '**     PCSCA114 PROCESSING ERROR      **'     
                 DISPLAY '**       ERROR READING FCSCA911       **'     
                 DISPLAY '**     FILE STATUS = ' WS-CA911-STATUS        
                 DISPLAY '****************************************'     
                 PERFORM 9000-TERMINATE THRU 9000-EXIT                  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-READ-FCSBE28.                                               
                                                                        
           READ FCSBE28-FILE AT END                                     
               MOVE WS-Y TO WS-END-OF-BE28.                             
           IF FBE28-SUCCESSFUL OR END-OF-BE28                           
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     PCSRP910 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE28        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE28-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           IF FBE28-SUCCESSFUL                                          
              MOVE 'N'                      TO WS-FOUND-FLAG            
              PERFORM VARYING SUB1 FROM 1 BY 1 UNTIL                    
                      (SUB1 > WS-REC-COUNT) OR WS-FOUND-FLAG='Y'        
                   IF WS-ACCOUNT(SUB1) = E-FBE28-ACCT-NO                
                      MOVE 'Y'                 TO WS-FOUND-FLAG         
                      PERFORM 8000-WRITE-OUTPUT-FILE THRU 8000-EXIT     
                   END-IF                                               
              END-PERFORM                                               
           END-IF.                                                      
           MOVE E-FBE28-ACCT-NO   TO WS-PREV-ACCT-NO.                   
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-WRITE-OUTPUT-FILE.                                          
                                                                        
           MOVE  FIOBE28      TO   OUTPUT-R.                            
           WRITE OUTPUT-R.                                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
       9000-TERMINATE.                                                  
                                                                        
                                                                        
           CLOSE FCSCA911-FILE                                          
                 OUTPUT-FILE                                            
                 FCSBE28-FILE.                                          
                                                                        
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
                                                                        
                                                                        
