       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA113.                                        
       DATE-WRITTEN.   AUGUST 2011.                                     
       DATE-COMPILED.                                                   
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC AND GAS               **          
      ********          CUSTOMER INFORMATION SYSTEM          *********          
      ****************************************************************          
      **               P R O G R A M    S U M M A R Y               **          
      **           F U N C T I O N A L  D E S C R I P T I O N       **          
      **                       O F    M O D U L E                   **          
      **                                                            **          
      **  PURPOSE :                                                 **          
      **  PRODUCES A REPORT THAT SHOWS FOR A COMPANY AND GENERAL    **          
      **  LEDGER ACCOUNT NUMBER THE ACCOUNT BALANCE AND ANY         **          
      **  DIFFERENCES.                                              **          
      **                                                            **          
      **  LOGIC :                                                   **          
      **                                                            **          
      **  REWRITE OF PCSGA305 - INPUT CHANGES TO TABLES ONLY.       **          
      **  THE GENERAL LEDGER ACCOUNT NUMBERS EXTRACTED PERTAIN ONLY **          
      **  TO UTILITY SALES REVENUE AND TAXES. EACH ROW FETCHED FROM **          
      **  THE MAIN CURSOR IS WRITTEN TO THE REPORT. THE REPORT PAGE **          
      **  BREAKS ON COMPANY_NO.                                     **          
      **                                                            **          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      **    DATE    INITIALS     REASON                             **          
      **  ________  _________    __________________________________ **          
      ** AUGUST 2011   RDF       INITIAL VERSION.                   **          
      **                                                            **          
PRG641** 19 JUN 2012   RDF       CHANGE TABLE FROM WHERE WE GET     **          
      **                         GO.GL_INTRFCE_ID                   **          
      **                                                            **          
P04527** 10 FEB 2013   RDF       REMOVE MAIL HEADER CREATION.       **          
      **                         JCL CHANGES FOR MAILHEADER-CSR/SEB **          
      **                         ADD LOCAL OFFICE TO CURSORS        **          
      **                                                            **          
P04527**  3 JUL 2013   RDF       ADD TO ALL CURSOR FOR REV TABLES   **          
      **                         REV_POST_STATUS_FL = 'Y'           **          
      **                                                            **          
P04527** 26 SEP 2013   RDF       ADD CHECK FOR CORRECTIONS INTO     **          
      **                         THE TAX CURSORS                    **          
      **                                                            **          
P05460** 11 JUL 2016   RDF       DELETE UNNEEDED CODE               **          
      **                                                            **          
      ****************************************************************          
           REMARKS.                                                     
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                3000 - 4999     BATCH PROCESSING MODULES - NOT USED     
                5000 - 5999     COMMON PROGRAM MODULES                  
                6000 - 6999     COMMON SYSTEM MODULES                   
                7000 - 7999     INPUT MODULES                           
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
                9800 - 9899     XCTLS TO PROGRAMS                       
                9900 - 9999     ABEND/ABORT MODULES                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       SPECIAL-NAMES.      C01 IS TOP-OF-PAGE.                          
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSMA113.                                                           
       COPY CSSPT33.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDMA113.                                                           
       COPY CFDPT33.                                                            
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA113'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_JOB_PARM                                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_COMPANY  -  C7                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCOMPNY                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_GL_ACCOUNT  -  GL                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGLACCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_GL_MNTHLY_TOT  -  GY                       *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGLMNTH                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_DELINQUENCY  -  C8                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_LOCAL_OFFICE  -  B1                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_REV_BILL_TAX  -  R9                        *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVTAX                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_REV_BILL_COMP_ADJ  -  RB                   *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVCOM                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_REV_BILLING_DET  -  RV                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVBLD                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_REV_PROTEC_DET  -  RL                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_REV_PROTEC_HDR  -  R0                      *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREVPRT                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_BILL_WINDOW  -  BN                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_GL_ACCT_NO  -  GO                          *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-SCEG                 PIC XX       VALUE '01'.         
           05  WS-ELECTRIC             PIC X        VALUE 'E'.          
           05  WS-TAX                  PIC X        VALUE 'B'.          
           05  WS-GAS                  PIC X        VALUE 'G'.          
           05  WS-CYCLE-20             PIC X        VALUE 'N'.          
           05  WS-ERR-FLAG             PIC X        VALUE 'N'.          
           05  WS-DEFAULT-RPT1-HEAD1   PIC X(45)    VALUE               
               '    CIS GENERAL LEDGER REVENUE CONTROL REPORT'.         
           05  WS-DEFAULT-RPT1-COMPANY PIC X(26)    VALUE               
               'SOUTH CAROLINA ELECT & GAS'.                            
           05  WS-MORE-DATA-GL-CSR     PIC X        VALUE 'Y'.          
               88  NO-MORE-DATA-GL-CSR              VALUE 'N'.          
           05  WS-PREV-COMP-NO         PIC XX       VALUE SPACES.       
           05  WS-RPT1-LINE-NO         PIC 99       VALUE ZERO.         
           05  WS-RPT1-PAGE-NO         PIC 99       VALUE ZERO.         
           05  WS-SCEG-ELECTRIC        PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-SCEG-GAS             PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-PSNC-GAS             PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-SEB-DEREGULATED      PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-SEB-REGULATED        PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-SUM-DR-AMT           PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-SUM-CR-AMT           PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-GL-BALANCE           PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-REV-BALANCE          PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-GL-BAL-COMPARE       PIC 9(11)V99  VALUE 0.           
           05  WS-REV-BAL-COMPARE      PIC 9(11)V99  VALUE 0.           
           05  WS-DIFFERENCE           PIC S9(11)V99 COMP-3 VALUE 0.    
           05  WS-ACCT-PRD             PIC 9(6)      VALUE ZERO.        
           05  WS-GL-ACCOUNT-NUMBER.                                    
               10  WS-ACCT-INT         PIC S9(3)     VALUE ZERO.        
               10  WS-ACCT-DEC         PIC 9(4)      VALUE ZERO.        
           05  WS-GL-ACCT-PERIOD1      PIC S9(9).                       
           05  WS-GL-ACCT-PERIOD       PIC 9(9)      VALUE ZERO.        
      *        10  WS-ACCT-PERIOD1     PIC S9(3).                               
           05  WS-ACCT-PERIOD2         PIC 9(6).                        
           05  WS-FCSMA113-STATUS      PIC XX.                          
               88  FCSMA113-SUCCESSFUL              VALUE '00'.         
           05  WS-FIRST-READ-FLAG      PIC X        VALUE 'Y'.          
               88  WS-FIRST-READ                    VALUE 'Y'.          
      *                                                                         
       01  WS-1650217                  PIC 9(3)V9999 VALUE 165.0217.    
       01  WS-2410900                  PIC 9(3)V9999 VALUE 241.0900.    
      *                                                                         
       01  WS-COMMON-DATE-PARM         PIC X(80).                       
       01  WS-COMMON-DATE-PARMX REDEFINES WS-COMMON-DATE-PARM.          
           05  WS-COMMON-DATE-LIT      PIC X(9).                        
           05  WS-COMMON-DATE-NUM      PIC X(10).                       
           05  FILLER                  PIC X(61).                       
      *                                                                         
       01  WS-REV-MNTH-BREAKDOWN.                                       
      *        10  FILLER              PIC X(14).                               
           05  WS-REV-MNTH-CHAR.                                        
               10  WS-REVENUE-YEAR     PIC X(4).                        
               10  WS-REVENUE-MONTH    PIC XX.                          
           05  WS-REV-MNTH-NUM         PIC 9(6).                        
      *        10  FILLER              PIC X(60).                               
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-U                    PIC X       VALUE 'U'.           
           05  WS-N                    PIC X       VALUE 'N'.           
           05  WS-Y                    PIC X       VALUE 'Y'.           
           05  WS-PGRMNAME             PIC X(8)    VALUE 'PCSCA113'.    
           05  WS-COMMONDATE           PIC X(10)   VALUE 'COMMONDATE'.  
      *                                                                         
           05  WS-CURRENT-TIME.                                         
               10  WS-HH               PIC XX       VALUE SPACES.       
               10  WS-MM               PIC XX       VALUE SPACES.       
               10  WS-SS               PIC XX       VALUE SPACES.       
               10  WS-TT               PIC XX       VALUE SPACES.       
      *                                                                         
           05  WS-CURRENT-DATE.                                         
               10  WS-CY               PIC 99       VALUE ZERO.         
               10  WS-CM               PIC 99       VALUE ZERO.         
               10  WS-CD               PIC XX       VALUE SPACES.       
      *                                                                         
       01  WS-BILL-UNIQUE-TS.                                           
           05  WS-BUT-YEAR             PIC X(4).                        
           05  FILLER                  PIC X   VALUE '-'.               
           05  WS-BUT-MONTH            PIC XX.                          
           05  FILLER                  PIC X   VALUE '-'.               
           05  WS-BUT-DAY              PIC XX.                          
           05  WS-BUT-REST             PIC X(16)                        
                                       VALUE '-00.00.00.000000'.        
      *                                                                         
       01  WS-CYCLE-DATE               PIC X(10).                       
      *                                                                         
       01  WS-COMMON-DATE.                                              
           05  WS-DATE-10                  PIC X(10)   VALUE SPACES.    
           05  FILLER                      PIC X(70)   VALUE SPACES.    
      *                                                                         
       01  WS-DATE-TEMP.                                                
           05  WS-DAT-MM               PIC XX.                          
           05  FILLER                  PIC X        VALUE '/'.          
           05  WS-DAT-DD               PIC XX.                          
           05  FILLER                  PIC X        VALUE '/'.          
           05  WS-DAT-YY               PIC XX.                          
      *                                                                         
       01  WS-DATE-8.                                                   
           05  WS-D8-CC                PIC 99.                          
           05  WS-D8-YY                PIC 99.                          
           05  WS-D8-MM                PIC 99.                          
      *                                                                         
       01  WS-REV-MNTH.                                                 
           05  WS-REV-MM               PIC 99.                          
           05  FILLER                  PIC X        VALUE '/'.          
           05  WS-REV-YY               PIC 99.                          
      *                                                                         
       01  WS-REV-YEAR                 PIC 9(4).                        
      *                                                                         
       01  WS-DATE-CAS.                                                 
           05  WS-DCA-MM               PIC XX.                          
           05  FILLER                  PIC X        VALUE '/'.          
           05  WS-DCA-DD               PIC XX       VALUE '01'.         
           05  FILLER                  PIC X        VALUE '/'.          
           05  WS-DCA-YY               PIC XX.                          
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      ****** WORKING STORAGE FOR REPORT HEADER                                  
       COPY CWS00079.                                                           
      *                                                                         
      ****** JOBS FILE/TABLE DEFINITIONS                                        
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      ****** CWS00038 IS JC01 WORK DATA                                         
       COPY CWS00038.                                                           
       COPY CWS00114.                                                           
      ****** CWS00039 IS CA00 WORK DATA                                         
       COPY CWS00039.                                                           
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************** PCSCA113 REPORT HEADERS **********************          
      *                                                                         
       01  WS-HEADING-LINES.                                            
      *                                                                         
           05  WS-RPT1-HDR-1.                                           
               10  FILLER              PIC X(16)                        
                                          VALUE 'REVENUE MONTH : '.     
               10  P-RPT1-REPT-MNTH    PIC X(5)     VALUE SPACES.       
               10  WS-NEXT             PIC X(6)     VALUE SPACES.       
               10  FILLER              PIC X(16)    VALUE SPACES.       
      *        10  FILLER              PIC X(22)    VALUE SPACES.               
               10  P-RPT1-HDR          PIC X(50).                       
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  FILLER              PIC X(11)    VALUE 'RUN TIME: '. 
               10  P-RPT1-RUN-TM       PIC X(8).                        
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT COLUMN HEADERS     **          
      ****************************************************************          
      *                                                                         
           05  WS-RPT-CLMN-HDR-1.                                       
               10  FILLER              PIC X(17)                        
                   VALUE 'COMPANY NUMBER : '.                           
               10  P-COMP-NO           PIC XX       VALUE SPACES.       
               10  FILLER              PIC X(113)   VALUE SPACES.       
      *                                                                         
           05  WS-RPT-CLMN-HDR-2.                                       
               10  FILLER              PIC X(10)                        
                   VALUE 'GL ACCOUNT'.                                  
               10  FILLER              PIC X(25)    VALUE SPACES.       
               10  FILLER              PIC X(7)                         
                   VALUE 'BALANCE'.                                     
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  FILLER              PIC X(14)                        
                   VALUE 'BILLING AMOUNT'.                              
               10  FILLER              PIC X(20)    VALUE SPACES.       
               10  FILLER              PIC X(10)                        
                   VALUE 'DIFF'.                                        
               10  FILLER              PIC X(30)    VALUE SPACES.       
      *                                                                         
      ****************************************************************          
      **       COMMON WORKING STORAGE FOR REPORT DETAIL LINES       **          
      ****************************************************************          
      *                                                                         
       01  WS-RPT-DTL.                                                  
           05  P-ACCT-NUMB             PIC -9(3).9(4).                  
           05  FILLER                  PIC X(21)       VALUE SPACES.    
           05  P-GL-BALANCE            PIC -(14)9.99.                   
           05  FILLER                  PIC X(10)       VALUE SPACES.    
           05  P-REV-BALANCE           PIC -(14)9.99.                   
           05  FILLER                  PIC X(10)       VALUE SPACES.    
           05  P-DIFFERENCE            PIC -(14)9.99.                   
           05  FILLER                  PIC X(28)       VALUE SPACES.    
      *                                                                         
       01  WS-BLANK-LINE               PIC X(132)   VALUE SPACES.       
      *                                                                         
       01  WS-TOTAL-LINE.                                               
           05  FILLER                  PIC X(12)                        
                   VALUE 'GAS TOTAL = '.                                
           05  PRT-TOTAL-GAS           PIC -(14)9.99.                   
           05  FILLER                  PIC X(10)    VALUE SPACES.       
           05  FILLER                  PIC X(17)                        
                   VALUE 'ELECTRIC TOTAL = '.                           
           05  PRT-TOTAL-ELECTRIC      PIC -(14)9.99.                   
           05  FILLER                  PIC X(57)    VALUE SPACES.       
      *                                                                         
       01  WS-NO-DATA-LINE.                                             
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
                   VALUE '** NO DATA THIS RUN **'.                      
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-END-DATA-LINE.                                            
           05  FILLER                  PIC X(55)    VALUE SPACES.       
           05  FILLER                  PIC X(22)                        
                   VALUE '*** END OF REPORT ***'.                       
           05  FILLER                  PIC X(55)    VALUE SPACES.       
      *                                                                         
       01  WS-MISC.                                                     
P04527     05  WS-PREV-REGULATED-CD    PIC XX       VALUE SPACES.       
           05  WS-REGULATED-CD         PIC XX       VALUE SPACES.       
           05  WS-REG-DEREG-CD.                                         
               10 WS-DIV               PIC X(3)     VALUE ' - '.        
               10 WS-REG-CD            PIC X(11).                       
               10 WS-DIVISION          PIC X(9)     VALUE ' DIVISION'.  
           05  WS-DATABASE             PIC 9        VALUE ZERO.         
               88  CSR-DATABASE                     VALUE 1.            
               88  SEB-DATABASE                     VALUE 2.            
           05  WS-COMPANY-NAME         PIC X(35)    VALUE SPACES.       
           05  WS-MULTIPLE-ROWS-FOUND  PIC S9(4) COMP VALUE -811.       
           05  WS-SPC-2                PIC XX       VALUE '  '.         
      *                                                                         
       01  MAILHEAD-10.                                                 
           05  FILLER                  PIC X(7)  VALUE 'COMPANY'.       
           05  FILLER                  PIC X(4)  VALUE SPACES.          
           05  FILLER                  PIC X(3)  VALUE 'G/L'.           
           05  FILLER                  PIC X(9)  VALUE SPACES.          
           05  FILLER                  PIC X(7)  VALUE 'BILLING'.       
           05  FILLER                  PIC X(9)  VALUE SPACES.          
           05  FILLER                  PIC X(3)  VALUE 'G/L'.           
      *                                                                         
       01  MAILHEAD-11.                                                 
           05  FILLER                  PIC XX    VALUE 'NO'.            
           05  FILLER                  PIC X(9)  VALUE SPACES.          
           05  FILLER                  PIC X(4)  VALUE 'ACCT'.          
           05  FILLER                  PIC X(8)  VALUE SPACES.          
           05  FILLER                  PIC X(3)  VALUE 'AMT'.           
           05  FILLER                  PIC X(13) VALUE SPACES.          
           05  FILLER                  PIC X(7)  VALUE 'BALANCE'.       
           05  FILLER                  PIC X(10) VALUE SPACES.          
           05  FILLER                  PIC X(04) VALUE 'DIFF'.          
      *                                                                         
       01  MAIL-DETAIL.                                                 
           05  FILLER                  PIC X          VALUE SPACES.     
           05  MAIL-COMPANY-NO         PIC XX.                          
           05  FILLER                  PIC X(6)       VALUE SPACES.     
           05  MAIL-GL-REC             PIC X(9).                        
           05  FILLER                  PIC X(4)       VALUE SPACES.     
           05  MAIL-AR-TOTAL           PIC -(9)9.9(2).                  
           05  FILLER                  PIC X(4)       VALUE SPACES.     
           05  MAIL-GL-BAL             PIC -(9)9.9(2).                  
           05  FILLER                  PIC X(4)       VALUE SPACES.     
           05  MAIL-DIFF               PIC -(9)9.9(2).                  
      *                                                                         
      ****************************************************************          
      **      CURSOR DECLARATION FOR GL TABLES                      **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE GL-CURSOR CURSOR FOR                               
                SELECT SUM(GY.MNTH_DR_AMT)                              
                      ,SUM(GY.MNTH_CR_AMT)                              
P04527                ,B1.REGULATED_CD                                  
                      ,B1.COMPANY_NO                                    
                      ,GY.GL_ACCT_NO                                    
                      ,GO.CODE_UTIL_TYPE                                
                 FROM  CSS_GL_ACCOUNT GL WITH(READUNCOMMITTED)                  
                      ,CSS_GL_MNTHLY_TOT GY WITH(READUNCOMMITTED)               
                      ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                
                      ,CSS_GL_ACCT_NO GO WITH(READUNCOMMITTED)                  
                WHERE  GL.COMPANY_NO     = GY.COMPANY_NO                
                  AND  GL.COMPANY_NO     = GO.COMPANY_NO                
                  AND  GL.GL_ACCT_NO     = GY.GL_ACCT_NO                
                  AND  GL.GL_ACCT_NO     = GO.GL_ACCT_NO                
                  AND  GY.ACCTING_PERIOD = :GY-ACCTING-PERIOD           
PRG641            AND  GO.GL_INTRFCE_ID IN ('A','B')                    
                  AND  GL.LOCAL_OFFICE   = GY.LOCAL_OFFICE              
                  AND  GL.LOCAL_OFFICE   = B1.LOCAL_OFFICE              
P04527          GROUP BY B1.REGULATED_CD                                
                        ,B1.COMPANY_NO                                  
                        ,GY.GL_ACCT_NO                                  
                        ,GO.CODE_UTIL_TYPE                              
P04527          ORDER BY B1.REGULATED_CD                                
                        ,B1.COMPANY_NO                                  
                        ,GY.GL_ACCT_NO                                  
                        ,GO.CODE_UTIL_TYPE                              
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GL-CURSOR CURSOR FOR                                       
MFA-TR*         SELECT SUM(GY.MNTH_DR_AMT)                                      
MFA-TR*               ,SUM(GY.MNTH_CR_AMT)                                      
MFA-TR*               ,B1.REGULATED_CD                                          
MFA-TR*               ,B1.COMPANY_NO                                            
MFA-TR*               ,GY.GL_ACCT_NO                                            
MFA-TR*               ,GO.CODE_UTIL_TYPE                                        
MFA-TR*          FROM  CSS_GL_ACCOUNT GL                                        
MFA-TR*               ,CSS_GL_MNTHLY_TOT GY                                     
MFA-TR*               ,CSS_LOCAL_OFFICE B1                                      
MFA-TR*               ,CSS_GL_ACCT_NO GO                                        
MFA-TR*         WHERE  GL.COMPANY_NO     = GY.COMPANY_NO                        
MFA-TR*           AND  GL.COMPANY_NO     = GO.COMPANY_NO                        
MFA-TR*           AND  GL.GL_ACCT_NO     = GY.GL_ACCT_NO                        
MFA-TR*           AND  GL.GL_ACCT_NO     = GO.GL_ACCT_NO                        
MFA-TR*           AND  GY.ACCTING_PERIOD = :GY-ACCTING-PERIOD                   
MFA-TR*           AND  GO.GL_INTRFCE_ID IN ('A','B')                            
MFA-TR*           AND  GL.LOCAL_OFFICE   = GY.LOCAL_OFFICE                      
MFA-TR*           AND  GL.LOCAL_OFFICE   = B1.LOCAL_OFFICE                      
MFA-TR*         GROUP BY B1.REGULATED_CD                                        
MFA-TR*                 ,B1.COMPANY_NO                                          
MFA-TR*                 ,GY.GL_ACCT_NO                                          
MFA-TR*                 ,GO.CODE_UTIL_TYPE                                      
MFA-TR*         ORDER BY B1.REGULATED_CD                                        
MFA-TR*                 ,B1.COMPANY_NO                                          
MFA-TR*                 ,GY.GL_ACCT_NO                                          
MFA-TR*                 ,GO.CODE_UTIL_TYPE                                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      CURSOR DECLARATION FOR ALL NON TAX REVENUE            **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE REV-CURSOR CURSOR FOR                              
P04527          SELECT B1.REGULATED_CD                                  
                      ,RV.COMPANY_NO                                    
                      ,RB.GL_ACCT_NO                                    
                      ,SUM(RB.BILLED_AMT)                               
                 FROM  REV_BILL_COMP_ADJ RB WITH(READUNCOMMITTED)               
                      ,REV_BILLING_DET RV WITH(READUNCOMMITTED)                 
P04527                ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                
                WHERE RV.COMPANY_NO     = :RV-COMPANY-NO                
                  AND RV.REVENUE_MONTH  = :RV-REVENUE-MONTH             
                  AND RV.BILL_UNIQUE_TS >= CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )           
                  AND RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS             
                  AND RB.GL_ACCT_NO     = :RB-GL-ACCT-NO                
                  AND RB.UTILITY_REV_CD = :WS-U                         
P04527            AND B1.REGULATED_CD   = :B1-REGULATED-CD              
P04527            AND RV.COMPANY_NO     = B1.COMPANY_NO                 
P04527            AND RV.LOCAL_OFFICE   = B1.LOCAL_OFFICE               
P04527            AND RV.REV_POST_STATUS_FL = 'Y'                       
P04527          GROUP BY B1.REGULATED_CD                                
                        ,RV.COMPANY_NO                                  
                        ,RB.GL_ACCT_NO                                  
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE REV-CURSOR CURSOR FOR                                      
MFA-TR*         SELECT B1.REGULATED_CD                                          
MFA-TR*               ,RV.COMPANY_NO                                            
MFA-TR*               ,RB.GL_ACCT_NO                                            
MFA-TR*               ,SUM(RB.BILLED_AMT)                                       
MFA-TR*          FROM  REV_BILL_COMP_ADJ RB                                     
MFA-TR*               ,REV_BILLING_DET RV                                       
MFA-TR*               ,CSS_LOCAL_OFFICE B1                                      
MFA-TR*         WHERE RV.COMPANY_NO     = :RV-COMPANY-NO                        
MFA-TR*           AND RV.REVENUE_MONTH  = :RV-REVENUE-MONTH                     
MFA-TR*           AND RV.BILL_UNIQUE_TS >= :RV-BILL-UNIQUE-TS                   
MFA-TR*           AND RV.BILL_UNIQUE_TS = RB.BILL_UNIQUE_TS                     
MFA-TR*           AND RB.GL_ACCT_NO     = :RB-GL-ACCT-NO                        
MFA-TR*           AND RB.UTILITY_REV_CD = :WS-U                                 
MFA-TR*           AND B1.REGULATED_CD   = :B1-REGULATED-CD                      
MFA-TR*           AND RV.COMPANY_NO     = B1.COMPANY_NO                         
MFA-TR*           AND RV.LOCAL_OFFICE   = B1.LOCAL_OFFICE                       
MFA-TR*           AND RV.REV_POST_STATUS_FL = 'Y'                               
MFA-TR*         GROUP BY B1.REGULATED_CD                                        
MFA-TR*                 ,RV.COMPANY_NO                                          
MFA-TR*                 ,RB.GL_ACCT_NO                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      CURSOR DECLARATION FOR ALL NON FRANCHISE TAX          **          
      ****************************************************************          
      *                                                                         
      *                                                                         
      *                                                                         
      *                                                                         
           EXEC SQL                                                     
             DECLARE TAX-CURSOR CURSOR FOR                              
P04527          SELECT B1.REGULATED_CD                                  
                      ,RV.COMPANY_NO                                    
                      ,SUM(R9.TAX_AMT)                                  
                 FROM  REV_BILL_TAX R9 WITH(READUNCOMMITTED)                    
                      ,REV_BILLING_DET RV WITH(READUNCOMMITTED)                 
P04527                ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                
                WHERE RV.COMPANY_NO     = :RV-COMPANY-NO                
                  AND RV.REVENUE_MONTH  = :RV-REVENUE-MONTH             
                  AND RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS             
P04527            AND R9.TAX_TYPE  NOT IN ('B', 'T')                    
P04527            AND B1.REGULATED_CD   = :B1-REGULATED-CD              
P04527            AND RV.COMPANY_NO     = B1.COMPANY_NO                 
P04527            AND RV.LOCAL_OFFICE   = B1.LOCAL_OFFICE               
P04527            AND RV.REV_POST_STATUS_FL = 'Y'                       
P04527          GROUP BY B1.REGULATED_CD                                
                        ,RV.COMPANY_NO                                  
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TAX-CURSOR CURSOR FOR                                      
MFA-TR*         SELECT B1.REGULATED_CD                                          
MFA-TR*               ,RV.COMPANY_NO                                            
MFA-TR*               ,SUM(R9.TAX_AMT)                                          
MFA-TR*          FROM  REV_BILL_TAX R9                                          
MFA-TR*               ,REV_BILLING_DET RV                                       
MFA-TR*               ,CSS_LOCAL_OFFICE B1                                      
MFA-TR*         WHERE RV.COMPANY_NO     = :RV-COMPANY-NO                        
MFA-TR*           AND RV.REVENUE_MONTH  = :RV-REVENUE-MONTH                     
MFA-TR*           AND RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS                     
MFA-TR*           AND R9.TAX_TYPE  NOT IN ('B', 'T')                            
MFA-TR*           AND B1.REGULATED_CD   = :B1-REGULATED-CD                      
MFA-TR*           AND RV.COMPANY_NO     = B1.COMPANY_NO                         
MFA-TR*           AND RV.LOCAL_OFFICE   = B1.LOCAL_OFFICE                       
MFA-TR*           AND RV.REV_POST_STATUS_FL = 'Y'                               
MFA-TR*         GROUP BY B1.REGULATED_CD                                        
MFA-TR*                 ,RV.COMPANY_NO                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      CURSOR DECLARATION FOR ALL FRANCHISE TAX              **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE FRAN-CURSOR CURSOR FOR                             
P04527          SELECT B1.REGULATED_CD                                  
                      ,RV.COMPANY_NO                                    
                      ,SUM(R9.TAX_AMT)                                  
                 FROM  REV_BILL_TAX R9 WITH(READUNCOMMITTED)                    
                      ,REV_BILLING_DET RV WITH(READUNCOMMITTED)                 
P04527                ,CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                
                WHERE RV.COMPANY_NO     = :RV-COMPANY-NO                
                  AND RV.REVENUE_MONTH  = :RV-REVENUE-MONTH             
                  AND RV.BILL_UNIQUE_TS >= CIS.CHAR2TIMESTAMP(
                                                     :R9-BILL-UNIQUE-TS
              )           
                  AND RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS             
                  AND R9.TAX_TYPE       = 'B'                           
A04527            AND ((RV.BILL_NO > 0)                                 
A04527               OR (RV.BILL_NO = 0 AND RV.CALC_SOURCE_CD = 'R'))   
P04527            AND B1.REGULATED_CD   = :B1-REGULATED-CD              
P04527            AND RV.COMPANY_NO     = B1.COMPANY_NO                 
P04527            AND RV.LOCAL_OFFICE   = B1.LOCAL_OFFICE               
P04527            AND RV.REV_POST_STATUS_FL = 'Y'                       
P04527          GROUP BY B1.REGULATED_CD                                
                        ,RV.COMPANY_NO                                  
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE FRAN-CURSOR CURSOR FOR                                     
MFA-TR*         SELECT B1.REGULATED_CD                                          
MFA-TR*               ,RV.COMPANY_NO                                            
MFA-TR*               ,SUM(R9.TAX_AMT)                                          
MFA-TR*          FROM  REV_BILL_TAX R9                                          
MFA-TR*               ,REV_BILLING_DET RV                                       
MFA-TR*               ,CSS_LOCAL_OFFICE B1                                      
MFA-TR*         WHERE RV.COMPANY_NO     = :RV-COMPANY-NO                        
MFA-TR*           AND RV.REVENUE_MONTH  = :RV-REVENUE-MONTH                     
MFA-TR*           AND RV.BILL_UNIQUE_TS >= :R9-BILL-UNIQUE-TS                   
MFA-TR*           AND RV.BILL_UNIQUE_TS = R9.BILL_UNIQUE_TS                     
MFA-TR*           AND R9.TAX_TYPE       = 'B'                                   
MFA-TR*           AND ((RV.BILL_NO > 0)                                         
MFA-TR*              OR (RV.BILL_NO = 0 AND RV.CALC_SOURCE_CD = 'R'))           
MFA-TR*           AND B1.REGULATED_CD   = :B1-REGULATED-CD                      
MFA-TR*           AND RV.COMPANY_NO     = B1.COMPANY_NO                         
MFA-TR*           AND RV.LOCAL_OFFICE   = B1.LOCAL_OFFICE                       
MFA-TR*           AND RV.REV_POST_STATUS_FL = 'Y'                               
MFA-TR*         GROUP BY B1.REGULATED_CD                                        
MFA-TR*                 ,RV.COMPANY_NO                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **      CURSOR DECLARATION FOR ALL PROTEC GL DATA             **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
             DECLARE PROTEC-CURSOR CURSOR FOR                           
                SELECT R0.COMPANY_NO                                    
                      ,RL.GL_ACCT_NO                                    
                      ,SUM(RL.COLLECTIBLE_AM)                           
                 FROM  CSS_REV_PROTEC_HDR R0 WITH(READUNCOMMITTED)              
                      ,CSS_REV_PROTEC_DET RL WITH(READUNCOMMITTED)              
                WHERE R0.COMPANY_NO       = :R0-COMPANY-NO              
                  AND R0.REVENUE_MONTH    = :R0-REVENUE-MONTH           
                  AND RL.GL_ACCT_NO       = :RL-GL-ACCT-NO              
                  AND R0.REV_PROT_CASE_NO = RL.REV_PROT_CASE_NO         
                  AND R0.ACCOUNT_NO       = RL.ACCOUNT_NO               
                GROUP BY R0.COMPANY_NO, RL.GL_ACCT_NO                   
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE PROTEC-CURSOR CURSOR FOR                                   
MFA-TR*         SELECT R0.COMPANY_NO                                            
MFA-TR*               ,RL.GL_ACCT_NO                                            
MFA-TR*               ,SUM(RL.COLLECTIBLE_AM)                                   
MFA-TR*          FROM  CSS_REV_PROTEC_HDR R0                                    
MFA-TR*               ,CSS_REV_PROTEC_DET RL                                    
MFA-TR*         WHERE R0.COMPANY_NO       = :R0-COMPANY-NO                      
MFA-TR*           AND R0.REVENUE_MONTH    = :R0-REVENUE-MONTH                   
MFA-TR*           AND RL.GL_ACCT_NO       = :RL-GL-ACCT-NO                      
MFA-TR*           AND R0.REV_PROT_CASE_NO = RL.REV_PROT_CASE_NO                 
MFA-TR*           AND R0.ACCOUNT_NO       = RL.ACCOUNT_NO                       
MFA-TR*         GROUP BY R0.COMPANY_NO, RL.GL_ACCT_NO                           
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ****************************************************************          
      **       CONTROLS THE MAIN PROCESSING OF THE PROGRAM          **          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           IF NO-MORE-DATA-GL-CSR                                       
               WRITE PRT33-RECORD FROM WS-NO-DATA-LINE AFTER            
                   ADVANCING 2 LINES                                    
           ELSE                                                         
               PERFORM 1100-PROCESS-CURS-GL THRU 1100-EXIT              
                   UNTIL NO-MORE-DATA-GL-CSR                            
           END-IF.                                                      
      *                                                                         
           IF WS-ERR-FLAG = 'Y'                                         
              DISPLAY '** PCSCA113                      **'             
              DISPLAY '** BILLING AND GL OUT OF BALANCE **'             
              DISPLAY '** DETAILS ARE IN THE REPORT     **'             
      *       PERFORM 9900-ABEND  THRU 9900-EXIT                                
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
              MOVE +04 TO  RETURN-CODE                                  
           ELSE                                                         
              PERFORM 9000-TERMINATE THRU 9000-EXIT                     
           END-IF.                                                      
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PERFORMS INITIALIZATION OF INPUT/OUTPUT FILES        **          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE MAIL-DETAIL.                                      
           INITIALIZE WS-RPT-DTL.                                       
      *                                                                         
           MOVE ZERO                        TO WS-DATABASE.             
           MOVE '01'                        TO C8-COMPANY-NO.           
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           PERFORM 7900-SELECT-DELINQ-VALUE THRU 7900-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
      *                                                                         
           ACCEPT WS-CURRENT-TIME FROM TIME.                            
           MOVE WS-HH                  TO WS-RT-HH.                     
           MOVE WS-MM                  TO WS-RT-MM.                     
           MOVE WS-SS                  TO WS-RT-SS.                     
           MOVE WS-RUN-TIME            TO P-RPT1-RUN-TM.                
      *                                                                         
           ACCEPT WS-CURRENT-DATE FROM DATE.                            
           MOVE WS-CY                  TO WS-RD-YY.                     
           MOVE WS-CM                  TO WS-RD-MM.                     
           MOVE WS-CD                  TO WS-RD-DD.                     
           MOVE WS-RUN-DATE            TO P-RPT1-RUN-DATE.              
           MOVE WS-PGRMNAME            TO P-RPT1-PGRMNAME.              
           MOVE WS-DEFAULT-RPT1-HEAD1  TO P-RPT1-HEADER.                
      *                                                                         
           PERFORM 7000-FETCH-RUN-DATE THRU 7000-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-COMMON-DATE-NUM  TO WS-COMMON-DATE                
           ELSE                                                         
              MOVE WS-COMMONDATE       TO G6-PROGRAM-NAME               
              MOVE '01'                TO G6-COMPANY-NO                 
              MOVE 'CA00'              TO G6-CMND-CODE                  
              MOVE 'A'                 TO G6-STATUS                     
              PERFORM 7001-FETCH-COMMONDATE THRU 7001-EXIT              
              MOVE G6-PARM-DATA TO WS-COMMON-DATE                       
           END-IF.                                                      
      *                                                                         
           MOVE WS-DEFAULT-RPT1-HEAD1 TO P-RPT1-HDR.                    
      *                                                                         
           MOVE SPACES TO WS-INPUT-DATA-BREAKDOWN.                      
                                                                        
           PERFORM 6200-GET-PARAMETER-DATE THRU 6200-EXIT.              
                                                                        
           IF END-OF-SYSIPT                                             
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 7611-CLOSE THRU 7611-EXIT                         
           END-IF.                                                      
      *                                                                         
           MOVE WS-CY                  TO WS-DAT-YY.                    
           MOVE WS-CM                  TO WS-DAT-MM.                    
           MOVE WS-CD                  TO WS-DAT-DD.                    
           MOVE WS-DATE-TEMP           TO P-RPT1-REPORT-DATE.           
      *                                                                         
           MOVE WS-PARM-YR(3:2)        TO WS-REV-YY.                    
           MOVE WS-PARM-YR             TO WS-REVENUE-YEAR.              
           MOVE WS-PARM-MONTH          TO WS-REV-MM                     
                                          WS-REVENUE-MONTH.             
      *                                                                         
           MOVE WS-REVENUE-YEAR  TO WS-BUT-YEAR.                        
           MOVE WS-REVENUE-MONTH TO WS-BUT-MONTH.                       
           MOVE '01'             TO WS-BUT-DAY.                         
           DISPLAY 'WS-BILL-UNIQUE-TS = ' WS-BILL-UNIQUE-TS.            
      *                                                                         
           MOVE WS-REV-MNTH-CHAR       TO WS-REV-MNTH-NUM.              
           MOVE WS-REV-MNTH-NUM        TO GY-ACCTING-PERIOD.            
           MOVE WS-REV-MNTH            TO P-RPT1-REPT-MNTH.             
      *                                                                         
           OPEN OUTPUT FCSPT33-FILE.                                    
      *                                                                         
           MOVE WS-DATE-10 TO WS-CYCLE-DATE.                            
           MOVE WS-REV-MNTH-NUM TO BN-REVENUE-MONTH.                    
           PERFORM 7700-SELECT-BILL-WINDOW THRU 7700-EXIT.              
           DISPLAY '7700 / WS-CYCLE-DATE = ' WS-CYCLE-DATE.             
           DISPLAY '7700 / BN-REVENUE-MONTH = ' BN-REVENUE-MONTH.       
           DISPLAY '7700 / BN-BILL-CYCLE    = ' BN-BILL-CYCLE.          
      *                                                                         
           PERFORM 7100-OPEN-GL-CURSOR THRU 7100-EXIT.                  
      *                                                                         
           PERFORM 7120-FETCH-GL-CURSOR THRU 7120-EXIT.                 
      *                                                                         
           MOVE GY-COMPANY-NO TO WS-PREV-COMP-NO.                       
P04527     MOVE B1-REGULATED-CD TO WS-REGULATED-CD                      
P04527                             WS-PREV-REGULATED-CD.                
           PERFORM 8100-PRINT-HEADERS THRU 8100-EXIT.                   
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS AS DETAIL LINE ROWS FETCHED BY CURSOR.        **          
      ****************************************************************          
      *                                                                         
       1100-PROCESS-CURS-GL.                                            
      *                                                                         
P04527     IF GY-COMPANY-NO NOT = WS-PREV-COMP-NO OR                    
P04527              WS-REGULATED-CD NOT = WS-PREV-REGULATED-CD          
P04527        IF (SEB-DATABASE)                                         
P04527           MOVE ZEROS              TO PRT-TOTAL-ELECTRIC          
P04527           MOVE WS-SEB-DEREGULATED TO PRT-TOTAL-GAS               
P04527        ELSE                                                      
                 MOVE WS-SCEG-ELECTRIC TO PRT-TOTAL-ELECTRIC            
                 MOVE WS-SCEG-GAS      TO PRT-TOTAL-GAS                 
P04527        END-IF                                                    
              WRITE PRT33-RECORD FROM WS-TOTAL-LINE AFTER ADVANCING     
                 2 LINES                                                
           END-IF.                                                      
      *                                                                         
           IF WS-RPT1-LINE-NO > 53 OR                                   
               GY-COMPANY-NO NOT = WS-PREV-COMP-NO OR                   
P04527         WS-REGULATED-CD NOT = WS-PREV-REGULATED-CD               
               PERFORM 8100-PRINT-HEADERS THRU 8100-EXIT                
               MOVE GY-COMPANY-NO TO WS-PREV-COMP-NO                    
P04527         MOVE B1-REGULATED-CD TO WS-PREV-REGULATED-CD             
               MOVE ZEROES TO WS-RPT1-LINE-NO                           
           END-IF.                                                      
      *                                                                         
           MOVE GY-ACCTING-PERIOD  TO WS-GL-ACCT-PERIOD1.               
           MOVE WS-GL-ACCT-PERIOD1 TO WS-GL-ACCT-PERIOD.                
           MOVE WS-GL-ACCT-PERIOD  TO WS-ACCT-PERIOD2.                  
           MOVE GY-GL-ACCT-NO      TO P-ACCT-NUMB.                      
      *                                                                         
           MOVE GY-MNTH-DR-AMT  TO WS-SUM-DR-AMT.                       
           MOVE GY-MNTH-CR-AMT  TO WS-SUM-CR-AMT.                       
           MOVE GY-COMPANY-NO   TO RV-COMPANY-NO.                       
      *                                                                         
           IF GY-GL-ACCT-NO = WS-1650217                                
              MOVE WS-GL-ACCT-PERIOD TO RV-REVENUE-MONTH                
              MOVE WS-BILL-UNIQUE-TS TO R9-BILL-UNIQUE-TS               
              PERFORM 1200-FRANCHISE-TAX THRU 1200-EXIT                 
           ELSE                                                         
              IF GY-GL-ACCT-NO = WS-2410900                             
                 MOVE WS-GL-ACCT-PERIOD TO RV-REVENUE-MONTH             
                 MOVE WS-BILL-UNIQUE-TS TO R9-BILL-UNIQUE-TS            
                 PERFORM 1300-ALLOTHER-TAX THRU 1300-EXIT               
              ELSE                                                      
                 MOVE WS-GL-ACCT-PERIOD TO RV-REVENUE-MONTH             
                 MOVE WS-BILL-UNIQUE-TS TO RV-BILL-UNIQUE-TS            
                 MOVE GY-GL-ACCT-NO     TO RB-GL-ACCT-NO                
                 PERFORM 1400-NOTATAX THRU 1400-EXIT                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 1110-PROCESS-ROUTINE THRU 1110-EXIT.                 
      *                                                                         
           WRITE PRT33-RECORD FROM WS-RPT-DTL AFTER ADVANCING           
               1 LINE.                                                  
           ADD 1 TO WS-RPT1-LINE-NO.                                    
      *                                                                         
           PERFORM 7120-FETCH-GL-CURSOR THRU 7120-EXIT.                 
P04527     MOVE B1-REGULATED-CD TO WS-REGULATED-CD.                     
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PROCESS THE GL AND REVENUE AMOUNT                    **          
      ****************************************************************          
      *                                                                         
       1110-PROCESS-ROUTINE.                                            
      *                                                                         
           COMPUTE WS-GL-BALANCE = WS-SUM-DR-AMT - WS-SUM-CR-AMT.       
           MOVE WS-GL-BALANCE  TO P-GL-BALANCE.                         
           MOVE WS-REV-BALANCE TO P-REV-BALANCE.                        
      *                                                                         
           MOVE WS-REV-BALANCE TO WS-REV-BAL-COMPARE.                   
           MOVE WS-GL-BALANCE  TO WS-GL-BAL-COMPARE.                    
      *                                                                         
P04527     IF (SEB-DATABASE)                                            
P04527        CONTINUE                                                  
P04527     ELSE                                                         
              IF WS-CYCLE-20 = WS-N                                     
                 MOVE GY-GL-ACCT-NO     TO RL-GL-ACCT-NO                
                 MOVE GY-COMPANY-NO     TO R0-COMPANY-NO                
                 MOVE WS-GL-ACCT-PERIOD TO R0-REVENUE-MONTH             
                 PERFORM 1210-PROTEC-TAX THRU 1210-EXIT                 
      *                                                                         
                 MOVE WS-REV-BALANCE TO WS-REV-BAL-COMPARE              
                                        P-REV-BALANCE                   
              END-IF                                                    
P04527     END-IF.                                                      
      *                                                                         
           IF WS-REV-BAL-COMPARE = WS-GL-BAL-COMPARE                    
              MOVE ZEROS TO P-DIFFERENCE                                
           ELSE                                                         
              COMPUTE WS-DIFFERENCE = WS-REV-BALANCE + WS-GL-BALANCE    
              MOVE WS-DIFFERENCE TO P-DIFFERENCE                        
              MOVE 'Y' TO WS-ERR-FLAG                                   
              IF WS-FIRST-READ                                          
                 OPEN OUTPUT FCSMA113-FILE                              
                 IF FCSMA113-SUCCESSFUL                                 
                    CONTINUE                                            
                 ELSE                                                   
                   DISPLAY '* PCSCA113 PROCESSING ERROR        *'       
                   DISPLAY '* OPEN ERROR - FCSMA113-INPUT FILE *'       
                   DISPLAY '* FILE STATUS = ' WS-FCSMA113-STATUS        
                   DISPLAY '* PROCESSING TERMINATED            *'       
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
                 END-IF                                                 
                   PERFORM 8300-WRITE-MAIL-HEADING THRU 8300-EXIT       
                   MOVE 'N' TO WS-FIRST-READ-FLAG                       
              END-IF                                                    
      *                                                                         
              MOVE P-REV-BALANCE   TO MAIL-AR-TOTAL                     
              MOVE P-COMP-NO       TO MAIL-COMPANY-NO                   
              MOVE P-ACCT-NUMB     TO MAIL-GL-REC                       
              MOVE P-GL-BALANCE    TO MAIL-GL-BAL                       
              MOVE P-DIFFERENCE    TO MAIL-DIFF                         
      *                                                                         
              IF ((SEB-DATABASE) AND (WS-REGULATED-CD = '02'))          
                 MOVE 'RE' TO MAIL-COMPANY-NO                           
              END-IF                                                    
      *                                                                         
              WRITE FCSMA113-REC FROM MAIL-DETAIL                       
      *                                                                         
           END-IF.                                                      
      *                                                                         
           IF GY-COMPANY-NO = WS-SCEG                                   
              IF GO-CODE-UTIL-TYPE = WS-ELECTRIC                        
                 ADD WS-GL-BALANCE TO WS-SCEG-ELECTRIC                  
              ELSE                                                      
                 IF GO-CODE-UTIL-TYPE = WS-GAS                          
                    ADD WS-GL-BALANCE TO WS-SCEG-GAS                    
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              IF GO-CODE-UTIL-TYPE = WS-TAX                             
                 CONTINUE                                               
              ELSE                                                      
                 ADD WS-GL-BALANCE TO WS-PSNC-GAS                       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
P04527     IF SEB-DATABASE                                              
P04527        IF WS-REGULATED-CD = '02'                                 
P04527           ADD WS-GL-BALANCE TO WS-SEB-REGULATED                  
P04527        ELSE                                                      
P04527           ADD WS-GL-BALANCE TO WS-SEB-DEREGULATED                
P04527        END-IF                                                    
P04527     END-IF.                                                      
      *                                                                         
       1110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** OPEN, FETCH, CLOSE FRANCHISE TAX - PROCESS EACH            **          
      ****************************************************************          
      *                                                                         
       1200-FRANCHISE-TAX.                                              
      *                                                                         
           PERFORM 7400-OPEN-FRN-CURSOR THRU 7400-EXIT.                 
      *                                                                         
           PERFORM 7420-FETCH-FRN-CURSOR THRU 7420-EXIT.                
      *                                                                         
           MOVE R9-TAX-AMT TO WS-REV-BALANCE.                           
      *                                                                         
           PERFORM 7430-CLOSE-FRN-CURSOR THRU 7430-EXIT.                
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** OPEN, FETCH, CLOSE PROTEC - PROCESS EACH                   **          
      ****************************************************************          
      *                                                                         
       1210-PROTEC-TAX.                                                 
      *                                                                         
           PERFORM 7440-OPEN-PROTEC-CURSOR THRU 7440-EXIT.              
      *                                                                         
           PERFORM 7450-FETCH-PROTEC-CURSOR THRU 7450-EXIT.             
      *                                                                         
           ADD RL-COLLECTIBLE-AM TO WS-REV-BALANCE.                     
      *                                                                         
           PERFORM 7460-CLOSE-PROTEC-CURSOR THRU 7460-EXIT.             
      *                                                                         
       1210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** OPEN, FETCH, CLOSE OTHER TAX - PROCESS EACH                **          
      ****************************************************************          
      *                                                                         
       1300-ALLOTHER-TAX.                                               
      *                                                                         
           PERFORM 7300-OPEN-TAX-CURSOR THRU 7300-EXIT.                 
      *                                                                         
           PERFORM 7320-FETCH-TAX-CURSOR THRU 7320-EXIT.                
      *                                                                         
           MOVE R9-TAX-AMT TO WS-REV-BALANCE.                           
      *                                                                         
           PERFORM 7330-CLOSE-TAX-CURSOR THRU 7330-EXIT.                
      *                                                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** OPEN, FETCH, CLOSE NOT A TAX GL - PROCESS EACH             **          
      ****************************************************************          
      *                                                                         
       1400-NOTATAX.                                                    
      *                                                                         
           PERFORM 7200-OPEN-REV-CURSOR THRU 7200-EXIT.                 
      *                                                                         
           PERFORM 7220-FETCH-REV-CURSOR THRU 7220-EXIT.                
      *                                                                         
           MOVE RB-BILLED-AMT TO WS-REV-BALANCE.                        
      *                                                                         
           PERFORM 7230-CLOSE-REV-CURSOR THRU 7230-EXIT.                
      *                                                                         
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 6200-GET-PARAMETER-DATE                                    **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                 INCLUDE CPD00114                                               
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      **        GET RUN DATE FROM CSS_JOB_PARM USING PCSCA113       **          
      ****************************************************************          
      *                                                                         
       7000-FETCH-RUN-DATE.                                             
      *                                                                         
           MOVE '7000' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :WS-COMMON-DATE-PARM                               
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = 'PCSCA113'                          
                AND  COMPANY_NO   = '01'                                
                AND  CMND_CODE    = 'DATE'                              
                AND  STATUS       = 'A'                                 
                AND CIS.SUBSTR3(PARM_DATA,1,9) = 'RUN DATE='                 
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :WS-COMMON-DATE-PARM                                       
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*       WHERE  PROGRAM_NAME = 'PCSCA113'                                  
MFA-TR*         AND  COMPANY_NO   = '01'                                        
MFA-TR*         AND  CMND_CODE    = 'DATE'                                      
MFA-TR*         AND  STATUS       = 'A'                                         
MFA-TR*         AND SUBSTR(PARM_DATA,1,9) = 'RUN DATE='                         
MFA-TR*       WITH  UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7000-FETCH-RUN-DATE    **'          
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED        **'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        GET COMMONDATE FROM CSS_JOB_PARM                    **          
      ****************************************************************          
      *                                                                         
       7001-FETCH-COMMONDATE.                                           
      *                                                                         
           MOVE '7001' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                    
                AND  COMPANY_NO   = :G6-COMPANY-NO                      
                AND  CMND_CODE    = :G6-CMND-CODE                       
                AND  STATUS       = :G6-STATUS                          
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*       WHERE  PROGRAM_NAME = :G6-PROGRAM-NAME                            
MFA-TR*         AND  COMPANY_NO   = :G6-COMPANY-NO                              
MFA-TR*         AND  CMND_CODE    = :G6-CMND-CODE                               
MFA-TR*         AND  STATUS       = :G6-STATUS                                  
MFA-TR*       WITH  UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7001-FETCH-COMMONDATE  **'          
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED        **'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        OPENS GL CURSOR                                     **          
      ****************************************************************          
      *                                                                         
       7100-OPEN-GL-CURSOR.                                             
      *                                                                         
           MOVE '7100' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN GL-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7100-OPEN-GL-CURSOR    **'          
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED     **'             
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        FETCHES FOR GL CURSOR                               **          
      ****************************************************************          
      *                                                                         
       7120-FETCH-GL-CURSOR.                                            
      *                                                                         
           MOVE '7120' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                FETCH GL-CURSOR                                         
                INTO  :GY-MNTH-DR-AMT                                   
                     ,:GY-MNTH-CR-AMT                                   
P04527               ,:B1-REGULATED-CD                                  
                     ,:GY-COMPANY-NO                                    
                     ,:GY-GL-ACCT-NO                                    
                     ,:GO-CODE-UTIL-TYPE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO WS-MORE-DATA-GL-CSR                        
              ELSE                                                      
                 DISPLAY '**  ERROR IN 7120-FETCH-GL-CURSOR    **'      
                 DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '**  GY-ACCTING-PERIOD = ' GY-ACCTING-PERIOD   
                 DISPLAY '**  PROCESSING IS TERMINATED     **'          
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        CLOSES GL CURSOR                                    **          
      ****************************************************************          
      *                                                                         
       7130-CLOSE-GL-CURSOR.                                            
      *                                                                         
           MOVE '7130' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                CLOSE GL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7130-CLOSE-GL-CURSOR    **'         
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED     **'             
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        OPENS REVENUE CURSOR                                **          
      ****************************************************************          
      *                                                                         
       7200-OPEN-REV-CURSOR.                                            
      *                                                                         
           MOVE '7200' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN REV-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7200-OPEN-REV-CURSOR    **'         
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED         **'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        FETCHES FOR REVENUE CURSOR                          **          
      ****************************************************************          
      *                                                                         
       7220-FETCH-REV-CURSOR.                                           
      *                                                                         
           MOVE '7220' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                FETCH REV-CURSOR                                        
P04527          INTO  :B1-REGULATED-CD                                  
                     ,:RV-COMPANY-NO                                    
                     ,:RB-GL-ACCT-NO                                    
                     ,:RB-BILLED-AMT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS TO RB-BILLED-AMT                            
              ELSE                                                      
                 DISPLAY '**  ERROR IN 7220-FETCH-REV-CURSOR    **'     
                 DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '**  RV-COMPANY-NO     = ' RV-COMPANY-NO       
                 DISPLAY '**  RV-REVENUE-MONTH  = ' RV-REVENUE-MONTH    
                 DISPLAY '**  RV-BILL-UNIQUE-TS = ' RV-BILL-UNIQUE-TS   
                 DISPLAY '**  RB-GL-ACCT-NO     = ' RB-GL-ACCT-NO       
                 DISPLAY '**  PROCESSING IS TERMINATED          **'     
                 DISPLAY '**  PROCESSING IS TERMINATED          **'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        CLOSES REVENUE CURSOR                               **          
      ****************************************************************          
      *                                                                         
       7230-CLOSE-REV-CURSOR.                                           
      *                                                                         
           MOVE '7230' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE REV-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7230-CLOSE-REV-CURSOR    **'        
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED         **'         
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        OPENS TAX CURSOR                                    **          
      ****************************************************************          
      *                                                                         
       7300-OPEN-TAX-CURSOR.                                            
      *                                                                         
           MOVE '7300' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN TAX-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7300-OPEN-TAX-CURSOR    **'         
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED         **'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        FETCHES FOR TAX CURSOR                              **          
      ****************************************************************          
      *                                                                         
       7320-FETCH-TAX-CURSOR.                                           
      *                                                                         
           MOVE '7320' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                FETCH TAX-CURSOR                                        
P04527          INTO  :B1-REGULATED-CD                                  
                     ,:RV-COMPANY-NO                                    
                     ,:R9-TAX-AMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS TO R9-TAX-AMT                               
              ELSE                                                      
                 DISPLAY '**  ERROR IN 7320-FETCH-TAX-CURSOR    **'     
                 DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '**  RV-COMPANY-NO     = ' RV-COMPANY-NO       
                 DISPLAY '**  RV-REVENUE-MONTH  = ' RV-REVENUE-MONTH    
                 DISPLAY '**  R9-BILL-UNIQUE-TS = ' R9-BILL-UNIQUE-TS   
                 DISPLAY '**  PROCESSING IS TERMINATED          **'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        CLOSES TAX CURSOR                                   **          
      ****************************************************************          
      *                                                                         
       7330-CLOSE-TAX-CURSOR.                                           
      *                                                                         
           MOVE '7330' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE TAX-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7330-CLOSE-TAX-CURSOR    **'        
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED         **'         
           END-IF.                                                      
      *                                                                         
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        OPENS FRANCHISE CURSOR                              **          
      ****************************************************************          
      *                                                                         
       7400-OPEN-FRN-CURSOR.                                            
      *                                                                         
           MOVE '7400' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN FRAN-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7400-OPEN-FRN-CURSOR    **'         
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED         **'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        FETCHES FOR FRANCHISE CURSOR                        **          
      ****************************************************************          
      *                                                                         
       7420-FETCH-FRN-CURSOR.                                           
      *                                                                         
           MOVE '7420' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                FETCH FRAN-CURSOR                                       
P04527          INTO  :B1-REGULATED-CD                                  
                     ,:RV-COMPANY-NO                                    
                     ,:R9-TAX-AMT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS TO R9-TAX-AMT                               
              ELSE                                                      
                 DISPLAY '**  ERROR IN 7420-FETCH-FRN-CURSOR   **'      
                 DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '**  RV-COMPANY-NO     = ' RV-COMPANY-NO       
                 DISPLAY '**  RV-REVENUE-MONTH  = ' RV-REVENUE-MONTH    
                 DISPLAY '**  R9-BILL-UNIQUE-TS = ' R9-BILL-UNIQUE-TS   
                 DISPLAY '**  PROCESSING IS TERMINATED         **'      
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        CLOSES FRANCHISE CURSOR                             **          
      ****************************************************************          
      *                                                                         
       7430-CLOSE-FRN-CURSOR.                                           
      *                                                                         
           MOVE '7430' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE FRAN-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7430-CLOSE-FRN-CURSOR    **'        
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED         **'         
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        OPENS PROTEC CURSOR                                 **          
      ****************************************************************          
      *                                                                         
       7440-OPEN-PROTEC-CURSOR.                                         
      *                                                                         
           MOVE '7440' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                OPEN PROTEC-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7440-OPEN-PROTEC-CURSOR **'         
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED         **'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        FETCHES FOR PROTEC CURSOR                           **          
      ****************************************************************          
      *                                                                         
       7450-FETCH-PROTEC-CURSOR.                                        
      *                                                                         
           MOVE '7450' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
                FETCH PROTEC-CURSOR                                     
                INTO  :R0-COMPANY-NO                                    
                     ,:RL-GL-ACCT-NO                                    
                     ,:RL-COLLECTIBLE-AM                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS TO RL-COLLECTIBLE-AM                        
              ELSE                                                      
                 DISPLAY '**  ERROR IN 7450-FETCH-PROTEC-CURSOR **'     
                 DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
                 DISPLAY '**  R0-COMPANY-NO = ' R0-COMPANY-NO           
                 DISPLAY '**  RL-GL-ACCT-NO = ' RL-GL-ACCT-NO           
                 DISPLAY '**  PROCESSING IS TERMINATED          **'     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **        CLOSES PROTEC CURSOR                                **          
      ****************************************************************          
      *                                                                         
       7460-CLOSE-PROTEC-CURSOR.                                        
      *                                                                         
           MOVE '7460' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
                CLOSE PROTEC-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR IN 7460-CLOSE-PROTEC-CURSOR **'        
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING IS TERMINATED          **'        
           END-IF.                                                      
      *                                                                         
       7460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      GETS COMPANY DESC FROM TABLE CSS_COMPANY USING        **          
      **      COMPANY_NO                                            **          
      ****************************************************************          
      *                                                                         
       7500-GET-COMPANY-DESC.                                           
      *                                                                         
           MOVE '7500' TO WS-ACTIVE-PARAGRAPH.                          
           EXEC SQL                                                     
               SELECT  COMPANY_NAME                                     
               INTO    :C7-COMPANY-NAME                                 
               FROM    CSS_COMPANY                                      
               WHERE   COMPANY_NO   = :C7-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE C7-COMPANY-NAME    TO P-RPT1-COMPANY-NAME            
           ELSE                                                         
              IF SQLCODE = NOT-FOUND                                    
                 MOVE WS-DEFAULT-RPT1-COMPANY TO P-RPT1-COMPANY-NAME    
                 MOVE SPACES                  TO WS-PREV-COMP-NO        
              ELSE                                                      
                 DISPLAY '* SELECT ERROR IN 7500-GET-COMPANY-DESC *'    
                 DISPLAY '* RETURN CODE = ' SQLCODE                     
                 DISPLAY '* C7-COMPANY-NO = ' C7-COMPANY-NO             
                 DISPLAY '* PROCESSING TERMINATED          *'           
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      ** 7600-START-FCJ01                                           **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** 7600-START-FCJ01                                           **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      ** 6251-GET-FJC01-DATE                                        **          
      ****************************************************************          
      *                                                                         
       COPY CPD00037.                                                           
      *                                                                         
       COPY CPD00040.                                                           
      *                                                                         
      ****************************************************************          
      **     SELECT BILL WINDOW -  LOOKING FOR CYCLE 20 CLOSE       **          
      ****************************************************************          
      *                                                                         
       7700-SELECT-BILL-WINDOW.                                         
      *                                                                         
           MOVE '7700' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(MAX(BILL_CYCLE),' ')                        
                INTO :BN-BILL-CYCLE                                     
                FROM CSS_BILL_WINDOW                                    
               WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                  
                 AND DATE_EXTRACT = IIF(TRY_CONVERT(DATE, :WS-CYCLE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CYCLE-DATE
              ) <> 0) OR (LEN(:WS-CYCLE-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-CYCLE-DATE
              ), CONVERT(DATE, :WS-CYCLE-DATE) )                      
                 AND CODE_BILL_COND = 'C'                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(MAX(BILL_CYCLE),' ')                                
MFA-TR*         INTO :BN-BILL-CYCLE                                             
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE REVENUE_MONTH = :BN-REVENUE-MONTH                          
MFA-TR*          AND DATE_EXTRACT = :WS-CYCLE-DATE                              
MFA-TR*          AND CODE_BILL_COND = 'C'                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF BN-BILL-CYCLE > '19'                                   
                 MOVE WS-Y TO WS-CYCLE-20                               
              END-IF                                                    
           ELSE                                                         
              DISPLAY '**************************************'          
              DISPLAY '**     PCSCA113 PROCESSING ERROR    **'          
              DISPLAY '**   ERROR SELECTING BILL WINDOW    **'          
              DISPLAY '**   PROCESSING TERMINATED IN       **'          
              DISPLAY '**   7700-SELECT-BILL-WINDOW        **'          
              DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE           
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **     READS THE DATABASE FROM THE DELINQUENCY TABLE          **          
      ****************************************************************          
      *                                                                         
       7900-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           MOVE '7900' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY                                    
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-MULTIPLE-ROWS-FOUND                                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**************************************'          
              DISPLAY '**     PCSCA113 PROCESSING ERROR    **'          
              DISPLAY '**       ERROR SELECTING DELINQUENCY**'          
              DISPLAY '**       PROCESSING TERMINATED IN 7900'          
              DISPLAY '**************************************'          
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       PRINTS HEADERS FOR REPORT.                           **          
      ****************************************************************          
      *                                                                         
       8100-PRINT-HEADERS.                                              
      *                                                                         
           ADD 1 TO WS-RPT1-PAGE-NO.                                    
           MOVE GY-COMPANY-NO TO C7-COMPANY-NO                          
               P-COMP-NO.                                               
           PERFORM 7500-GET-COMPANY-DESC THRU 7500-EXIT.                
           IF ((SEB-DATABASE) AND (WS-PREV-COMP-NO NOT = SPACES))       
              PERFORM 8200-FORMAT-SEB-HDR   THRU 8200-EXIT              
           END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-RPT1-TITLE                        
                 AFTER ADVANCING TOP-OF-PAGE.                           
           WRITE PRT33-RECORD FROM WS-RPT1-HDR-1                        
                 AFTER ADVANCING 1 LINE.                                
           MOVE WS-RPT1-PAGE-NO TO P-RPT1-PAGE-NO.                      
           WRITE PRT33-RECORD FROM WS-RPT1-HEADER-2                     
                 AFTER ADVANCING 1 LINE.                                
           WRITE PRT33-RECORD FROM WS-RPT-CLMN-HDR-1                    
                 AFTER ADVANCING 3 LINE.                                
           WRITE PRT33-RECORD FROM WS-RPT-CLMN-HDR-2                    
                 AFTER ADVANCING 3 LINE.                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      WRITES THE HEADER FOR REGULATED/DEREGULATED SECTION   **          
      ****************************************************************          
      *                                                                         
       8200-FORMAT-SEB-HDR.                                             
      *                                                                         
           IF SEB-DATABASE                                              
              IF WS-REGULATED-CD = '02'                                 
                 MOVE 'REGULATED  '  TO WS-REG-CD                       
              ELSE                                                      
                 MOVE 'DEREGULATED'  TO WS-REG-CD                       
              END-IF                                                    
              INITIALIZE             WS-COMPANY-NAME                    
              STRING P-RPT1-COMPANY-NAME DELIMITED BY WS-SPC-2          
                     WS-DIV          DELIMITED BY SIZE                  
                     WS-REG-CD       DELIMITED BY SPACE                 
                     WS-DIVISION     DELIMITED BY SIZE                  
                                     INTO WS-COMPANY-NAME               
              END-STRING                                                
              MOVE WS-COMPANY-NAME   TO WS-RPT1-TITLE(54:35)            
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      WRITES THE MAIL HEADING                               **          
      ****************************************************************          
      *                                                                         
       8300-WRITE-MAIL-HEADING.                                         
      *                                                                         
           WRITE FCSMA113-REC FROM MAILHEAD-10.                         
           WRITE FCSMA113-REC FROM MAILHEAD-11.                         
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **       CLOSES ALL OPEN FILES AND TERMINATES THE PROGRAM     **          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           MOVE ZEROS       TO PRT-TOTAL-ELECTRIC.                      
           MOVE WS-PSNC-GAS TO PRT-TOTAL-GAS.                           
P04527     IF (SEB-DATABASE)                                            
P04527        MOVE WS-SEB-REGULATED TO PRT-TOTAL-GAS                    
P04527     END-IF.                                                      
           WRITE PRT33-RECORD FROM WS-TOTAL-LINE AFTER ADVANCING        
               2 LINES.                                                 
      *                                                                         
           WRITE PRT33-RECORD FROM WS-END-DATA-LINE AFTER ADVANCING     
               3 LINES.                                                 
           PERFORM 7130-CLOSE-GL-CURSOR THRU 7130-EXIT.                 
      *                                                                         
           CLOSE FCSPT33-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **  9900-ABEND                                                **          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
