       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA109.                                        
       AUTHOR.         VAISHNAVI.                                       
       DATE-WRITTEN.   MAY 2010.                                        
      *****************************************************************         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                      DB2                       *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      **    DATE    INITIALS     REASON                              **         
      **  --------  --------     ----------------------------------  **         
      **                                                             **         
PRJ236**  03/05/10  SV82012      STREAMLINE CONSOLIDATED BUSINESS    **         
PRJ236**                         RULES/PROCESSES.                    **         
A02003**  28/10/10  SV82012      FIX CROSSFOOT ISSUE WHEN THERE IS A **         
A02003**                         BAL FWD.                            **         
      *****************************************************************         
                                                                        
      *****************************************************************         
      **                     PCSCA109 NARRATIVE                      **         
      **                                                             **         
      **  THIS PROGRAM IS TO CHECK IF THE CONSOLIDATED BILLS HAVE    **         
      **  CROSSFOOT ERROR. THIS IS DONE BY CHECKING IF THE           **         
A02003**  WS-BILL-TOTAL-CURR-CHARGES FROM FIOEXT02 RECORD TALLY WITH **         
      **  EXT-CONS-TOTAL-AMT-BILLED  + EXT-BILL-TOTAL-MISC-CHARGE.   **         
      **  IF THEY DO NOT TALLY WRITE THE ACCT IN A WORKING STORAGE   **         
      **  CROSSFOOT TABLE.                                           **         
      **  READ THE SORTINDX FILE AND CHECK IF THE ACCOUNT FROM WORKING*         
      **  STORAGE MACTCHES WITH THE ACCOUNT READ, IF THEY MATCH SET  **         
      **  THE PULL CODE TO "X" AND WRITE THEM TO AN OUTPUT FILE      **         
      **  IF THEY DO NOT MATCH WRITE THE REC AS IS TO AN OUTPUT FILE **         
      *****************************************************************         
      **                                                             ** 00015000
      **             PROGRAM  MODIFICATION  LOG                      ** 00016000
      **                                                             ** 00017000
      **   DATE     INITIALS  REASON                                 ** 00018000
      **   ----     --------  ------                                 ** 00019000
      ** 04/2010    SV82012   INITIAL VERSION.                       ** 00020000
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           COPY CSSBE28.                                                        
           COPY CSSCA911.                                                       
           COPY CSSCA912.                                                       
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  FCSBE28-FILE                                                 
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOBE28.                                                     
           02  FIOBE28-DATA-REC.                                        
               05  E-FBE28-SORT-KEY              PIC X(65).             
               05  E-FBE28-DATA                  PIC X(1135).           
           COPY CFDCA911.                                                       
           COPY SORTINDX.                                                       
                                                                        
           COPY CFDCA912.                                                       
       01  E-SRT-IDX-REC                     PIC X(802).                
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-EXT-IO-AREA.                                              
           05  SORT-KEY.                                                
               10  LEVEL-1-SORT-FLDS.                                   
                   15  KEY-L1-COMP-NO          PIC 9(2).                
               10  LEVEL-2-SORT-FLDS.                                   
                   15  KEY-L2-ACCOUNT-NO       PIC X(13).               
                   15  KEY-L2-DATE-BILLED      PIC X(10).               
               10  LEVEL-3-SORT-FLDS.                                   
                   15  KEY-L3-REC-SEQ          PIC X(3).                
                   15  KEY-L3-RECORD-ID        PIC X(10).               
                   15  KEY-L3-TIE-BREAKER      PIC 9(4).                
               10  LEVEL-4-SORT-FLDS.                                   
                   15  KEY-L4-SUB-ACCOUNT      PIC X(13).               
                   15  KEY-L4-SUB-DATE-BILLED  PIC X(10).               
                   15  FILLER                  REDEFINES                
                       KEY-L4-SUB-DATE-BILLED.                          
                       20  FILLER              PIC X(06).               
                       20  KEY-L4-TIE-BREAKER  PIC 9(04).               
           05  WS-BILL-DATA                    PIC X(1135).             
                                                                        
       01  WS-BILL-WORK-AREA.                                           
       COPY FIOEXT03.                                                           
       COPY FIOEXTID.                                                           
       COPY CWSCA109.                                                           
       COPY CWS09900.                                                           
                                                                        
                                                                        
       01  WS-BILLING-WQ-ITEMS-WF.                                      
           05  WS-BILLING-WQ-ITEMS-DATA-WF                              
                   OCCURS 50 TIMES INDEXED BY WS-BILL-WQ-INDX.          
               10  WS-CATEGORY-ID-WF         PIC S9(04)  COMP.          
               10  WS-PRIORITY-WF            PIC X(1).                  
               10  WS-ROUTE-CATEGORY-WF      PIC X(01).                 
               10  WS-COMMENTS-WF.                                      
                   15  WS-COMMENTS-LEN-WF    PIC S9(04)  COMP.          
                   15  WS-COMMENTS-TEXT-WF   PIC X(250).                
               10  FILLER                    PIC X(244).                
       01  WS-MISC.                                                     
           05  WS-FIRST-TIME-SW              PIC X  VALUE ' '.          
               88  FIRST-TIME                       VALUE 'Y'.          
           05  WS-ACCT-FOUND-SW              PIC X  VALUE ' '.          
               88  ACCT-FOUND                       VALUE 'Y'.          
           05  WS-DISPLAY-SQLCODE            PIC -ZZZZZZZZ9.            
           05  WS-HOLD-MASTER-ACCT           PIC X(13).                 
           05  WS-HOLD-CURRENT-AMT           PIC S9(11)V99 VALUE 0.     
           05  WS-HOLD-MISC-CHG              PIC S9(09)V99 VALUE 0.     
           05  WS-HOLD-TOTAL-CHGS            PIC S9(09)V99 VALUE 0.     
           05  WS-DISP-CURRENT-AMT           PIC -9(11).99.             
           05  WS-DISP-MISC-CHG              PIC -9(09).99.             
           05  WS-PREV-BE28-ACCT-NO          PIC X(13)  VALUE SPACES.   
           05  WS-CONS-SUB                   PIC 9(3)   VALUE 0.        
           05  WS-CONS-ACCT-FLAG             PIC  X(01) VALUE 'N'.      
           05  WS-XFOOT-SUB                  PIC 9(3)   VALUE 0.        
           05  WS-SUB                        PIC 9(01)  VALUE ZEROS.    
           05  WS-SUB1                       PIC 9(01)  VALUE ZEROS.    
           05  WS-FBE28-STATUS               PIC XX VALUE '  '.         
               88  BE28-SUCCESSFUL                  VALUE '00'.         
               88  BE28-READ-OK                     VALUE '00' '04'.    
           05  WS-CA911-STATUS               PIC XX VALUE '  '.         
               88  CA911-SUCCESSFUL                 VALUE '00'.         
               88  CA911-READ-OK                    VALUE '00' '04'.    
           05  WS-CA912-STATUS               PIC XX VALUE '  '.         
               88  CA912-SUCCESSFUL                 VALUE '00'.         
                                                                        
       01  WS-XFOOT-DETAILS.                                            
           05  WS-CROSSFOOT-TABLE              OCCURS 2000 TIMES.       
               10  WS-XFOOT-ACCOUNT-NO         PIC 9(13).               
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-END-OF-BE28                PIC X VALUE 'N'.           
               88  END-OF-BE28                VALUE 'Y'.                
           05  WS-END-OF-CA911               PIC X VALUE 'N'.           
               88  END-OF-CA911               VALUE 'Y'.                
                                                                        
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA109'.  
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA109'.  
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-MB                       PIC X(02) VALUE 'MB'.        
T35152     05  WS-TP                       PIC X(02) VALUE 'TP'.        
                                                                        
       01  WS-BLANK-LINE                   PIC X(132) VALUE SPACES.     
       01  WS-NO-DATA-LINE                 PIC X(132) VALUE             
           '               NO DATA THIS RUN.                     '.     
                                                                        
A02003 LINKAGE SECTION.                                                 
A02003 01  WS-PARM-VALUE.                                               
A02003     03  WS-PARMVAL-LENGTH            PIC S9(04) COMP.            
A02003     03  WS-PARM-COMP                 PIC X(03).                  
                                                                        
A02003 PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      *****************************************************************         
      *  MAIN PROCESS AREA.                                           *         
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU  0100-EXIT.                 
           PERFORM 1000-PROCESS-ACCOUNTS THRU 1000-EXIT.                
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  OPEN FILES.  .    *                                                    
      *****************************************************************         
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT  FCSBE28-FILE FCSCA911-FILE                       
                OUTPUT FCSCA912-FILE.                                   
           IF WS-FBE28-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSBE28            '         
               DISPLAY '**   FILE STATUS = ' WS-FBE28-STATUS            
               DISPLAY '**************************************'         
               MOVE 12                 TO RETURN-CODE                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
           IF WS-CA911-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA911           '         
               DISPLAY '**   FILE STATUS = ' WS-CA911-STATUS            
               DISPLAY '**************************************'         
               MOVE 12                 TO RETURN-CODE                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
           IF WS-CA912-STATUS NOT = '00'                                
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING FCSCA912'                    
               DISPLAY '**   FILE STATUS = ' WS-CA912-STATUS            
               DISPLAY '**************************************'         
               MOVE 12                 TO RETURN-CODE                   
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
           MOVE 1                             TO WS-XFOOT-SUB.          
           INITIALIZE WS-XFOOT-DETAILS.                                 
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  PROCESS BE28 FILE AND SORTINDX FILE                     *              
      ************************************************************              
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 1100-PROCESS-BE28-FILE          THRU 1100-EXIT.      
           PERFORM 1200-PROCESS-SORTINDX           THRU 1200-EXIT.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-PROCESS-BE28-FILE.                                          
                                                                        
           PERFORM 7900-READ-FCSBE28               THRU 7900-EXIT.      
           PERFORM 2000-PROCESS-CONS-DATA          THRU 2000-EXIT       
                                                UNTIL END-OF-BE28.      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-PROCESS-SORTINDX.                                           
                                                                        
           PERFORM 7910-READ-FCSCA911              THRU 7910-EXIT.      
           PERFORM 2100-PROCESS-SORTINDX           THRU 2100-EXIT       
                                               UNTIL END-OF-CA911.      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE GETS THE CONSHDRREC AND ALL CONSDETAIL RECORDS  *         
      *  FOR AN ACCOUNT. ADD ALL THE DETAIL AMOUNTS AND CHECK IF THEY *         
      *  EQUAL WITH HDR AMOUNT. IF THEY ARE EQUAL CONTINUE ELSE LOAD  *         
      *  THE ACCOUNT IN A WORKING STORAGE VARIABLE.                   *         
      *****************************************************************         
                                                                        
       2000-PROCESS-CONS-DATA.                                          
                                                                        
           INITIALIZE EXT-CONSOLIDATED-REC                              
                      WS-BILL-RECORD                                    
                      WS-HOLD-CURRENT-AMT                               
                      WS-HOLD-TOTAL-CHGS                                
                      WS-HOLD-MISC-CHG.                                 
           MOVE KEY-L2-ACCOUNT-NO             TO WS-PREV-BE28-ACCT-NO.  
           MOVE 1                             TO WS-CONS-SUB.           
           MOVE 'N'                           TO WS-CONS-ACCT-FLAG.     
           PERFORM UNTIL END-OF-BE28 OR                                 
             KEY-L2-ACCOUNT-NO NOT = WS-PREV-BE28-ACCT-NO               
              EVALUATE TRUE                                             
                 WHEN KEY-L3-REC-SEQ = WS-BILL-REC                      
                    MOVE WS-BILL-DATA         TO WS-BILL-RECORD         
                    IF WS-BILL-MASTER-SUB-FLAG = 'M'                    
                        MOVE 'Y'              TO WS-CONS-ACCT-FLAG      
A02003                  IF WS-PARM-COMP = 'CSR' OR 'PNC'                
A02003                     MOVE WS-BILL-TOTAL-CURR-CHARGES              
                                              TO WS-HOLD-CURRENT-AMT    
A02003                  ELSE                                            
A02003                     MOVE WS-BILL-CURRENT-AMT                     
                                              TO WS-HOLD-CURRENT-AMT    
A02003                  END-IF                                          
A02003                  COMPUTE WS-HOLD-MISC-CHG =                      
A02003                          WS-BILL-TOTAL-MISC-CHARGE  +            
A02003                          WS-BILL-TOTAL-REG-INST-REBATE           
                    END-IF                                              
                 WHEN KEY-L3-REC-SEQ = WS-CONS-HDR-REC                  
                    MOVE WS-BILL-DATA         TO EXT-CONSOLIDATED-REC   
                    MOVE KEY-L2-ACCOUNT-NO    TO WS-HOLD-MASTER-ACCT    
                    MOVE 'Y'                  TO WS-CONS-ACCT-FLAG      
                    DISPLAY 'MST ACCT ' KEY-L2-ACCOUNT-NO               
              END-EVALUATE                                              
              PERFORM 7900-READ-FCSBE28 THRU 7900-EXIT                  
           END-PERFORM.                                                 
      * IF ACCOUNT IS CONSOLIDATED THEN CHECK FOR CROSSFOOT ERROR.      00152100
           IF WS-CONS-ACCT-FLAG = 'Y'                                   
              PERFORM 2050-PROCESS-XFOOT  THRU 2050-EXIT                
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2050-PROCESS-XFOOT.                                              
                                                                        
           COMPUTE WS-HOLD-TOTAL-CHGS = EXT-CONS-TOTAL-AMT-BILLED       
                                      + WS-HOLD-MISC-CHG                
           IF WS-HOLD-CURRENT-AMT NOT = WS-HOLD-TOTAL-CHGS              
              MOVE WS-HOLD-MASTER-ACCT        TO                        
                   WS-XFOOT-ACCOUNT-NO (WS-XFOOT-SUB)                   
              MOVE WS-HOLD-CURRENT-AMT        TO WS-DISP-CURRENT-AMT    
              MOVE WS-HOLD-MISC-CHG           TO WS-DISP-MISC-CHG       
              DISPLAY '** 2050-PROCESS-XFOOT **'                        
              DISPLAY 'XFOOT FOR MASTER ' WS-HOLD-MASTER-ACCT           
              DISPLAY 'CURRENT AMT ' WS-DISP-CURRENT-AMT                
              DISPLAY 'MISC CHARGE 'WS-DISP-MISC-CHG                    
              DISPLAY 'CONS TOTAL AMT ' EXT-CONS-TOTAL-AMT-BILLED       
              ADD 1                           TO WS-XFOOT-SUB           
           END-IF.                                                      
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  THIS ROUTINE WILL READ THE SORTINDX FILE AND CHECK IF THERE  *         
      *  ARE ANY ACCOUNTS MATCHING WITH ACCOUNTS SELECTED AS CROSS FOOT         
      *  IF SO SET PULL CODE TO X OR JUST WRITE THE SORTINDX FILE.    *         
      *****************************************************************         
                                                                        
       2100-PROCESS-SORTINDX.                                           
                                                                        
           MOVE 'N'                             TO WS-ACCT-FOUND-SW     
           IF EXT-ACCT-MASTER-SUB-FLAG = ('M' OR 'S')                   
              PERFORM VARYING WS-XFOOT-SUB FROM 1 BY 1                  
                UNTIL WS-XFOOT-SUB > 2000 OR ACCT-FOUND                 
                OR WS-XFOOT-ACCOUNT-NO (WS-XFOOT-SUB) = 0               
                IF WS-XFOOT-ACCOUNT-NO (WS-XFOOT-SUB)=                  
                   EXT-ACCT-ACCOUNT-NO                                  
                   MOVE 'X'                   TO EXT-BILL-PULL-CODE     
                   SET ACCT-FOUND             TO TRUE                   
                END-IF                                                  
                IF (WS-XFOOT-ACCOUNT-NO (WS-XFOOT-SUB)=                 
                    EXT-ACCT-XFER-TO-ACCOUNT AND                        
                    EXT-ACCT-MASTER-SUB-FLAG = 'S')                     
                   MOVE '2'                   TO EXT-BILL-PULL-CODE     
                   SET ACCT-FOUND             TO TRUE                   
                END-IF                                                  
              END-PERFORM                                               
           END-IF.                                                      
           PERFORM 8000-WRITE-SORT-IDX          THRU 8000-EXIT.         
           PERFORM 7910-READ-FCSCA911           THRU 7910-EXIT.         
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7900-READ-FCSBE28.                                               
                                                                        
           INITIALIZE WS-BILL-DATA.                                     
           READ FCSBE28-FILE INTO WS-EXT-IO-AREA                        
               AT END                                                   
                  MOVE WS-Y                   TO WS-END-OF-BE28.        
           IF BE28-READ-OK OR END-OF-BE28                               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12                        TO RETURN-CODE            
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA109 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE28        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE28-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      *  READ THE INPUT FILE                                     *              
      ************************************************************              
                                                                        
       7910-READ-FCSCA911.                                              
                                                                        
           READ FCSCA911-FILE AT END                                    
               MOVE WS-Y                      TO WS-END-OF-CA911.       
           IF CA911-READ-OK OR END-OF-CA911                             
               CONTINUE                                                 
           ELSE                                                         
               MOVE 12                        TO RETURN-CODE            
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA109 PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSCA911       **'       
               DISPLAY '**     FILE STATUS = ' WS-CA911-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9000-TERMINATE THRU 9000-EXIT                    
           END-IF.                                                      
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
      ************************************************************      17189000
      *  WRITE SORTINDX TO OUTPUT FILE.                          *      17190000
      ************************************************************      17191000
                                                                        
       8000-WRITE-SORT-IDX.                                             
                                                                        
           MOVE SPACES                     TO E-SRT-IDX-REC.            
           MOVE EXT-SORTIDX-FILE           TO E-SRT-IDX-REC.            
           WRITE E-SRT-IDX-REC.                                         
                                                                        
           IF CA912-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '8000-ERROR ON FCSCA912 WRITE.  STATUS IS '      
                        WS-CA912-STATUS                                 
               PERFORM 9000-TERMINATE      THRU 9000-EXIT               
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE28-FILE                                           
                 FCSCA911-FILE                                          
                 FCSCA912-FILE.                                         
           STOP RUN.                                                    
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
       9900-EXIT.                                                       
                                                                        
