       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA108.                                        
       DATE-WRITTEN.   JAN 2008.                                        
       DATE-COMPILED.                                                   
      ****************************************************************          
      ********            CUSTOMER SERVICE SYSTEM             ********          
      ********************       COBOL/DB2       *********************          
      **                                                            **          
      ** THIS PROGRAM CREATES DB09 BY USING OFF-CYCLE ACCOUNTS FILE **          
      ** FROM AUTOMATED READ ONLY PROCESS (AROP). DB09 IS THE LIST  **          
      ** OF ACCOUNTS FOR METER READING. AFTER THIS PROGRAM, THE     **          
      ** PCSCA109 PROGRAM WILL READ THIS DB09 FILE AND PROCEED TO   **          
      ** CREATE METER READ REQUEST FILE.                            **          
      **                                                            **          
      ********                                                ********          
      ****************************************************************          
      ***             PROGRAM  MODIFICATION  LOG                   ***          
      **------------------------------------------------------------**          
CML-NO**  DATE      EMP-ID   REASON                                 **          
------**  --------  -------  ---------------------------------------**          
      **                                                            **          
C35066**  01/15/08  NC94746  INITIAL VERSION (NEW CODE).            **          
ACT054**  03/15/11  BD09555  ACT054: INITIALIZE PR-SPCL-READ-INSTR  **          
      **  A03082             BEFORE FETCH.                          **          
ACT199**  10/20/11  BD09555  ACT199: CLEAR PREMISE 'SPECIAL READ    **          
      **  A03082             INSTRUCTIONS' IF THEY HAVE EXPIRED     **          
A04684** 20/05/13   SS95855  Create BW06 File if reads are found in **          
A04684**                     CSS_OFFCYCLE_READS Table and skip      **          
A04684**                     sending them in AROP file.             **          
AA4684** 09/06/13   SS95855  To get the latest available read from  **          
AA4684**                     Offcycle Read table.                   **          
Ab4684** 09/30/13   SS95855  To use Current Date instead of COMMON  **          
Ab4684**                     Date.                                  **          
      **                                                            **          
A04527**  7 OCT 2013 RF10596  PUT IN JCL PARM TO BE ABLE TO         **          
A04527**                      DETERMINE IF JOB IS CSRC108 OR        **          
A04527**                      CSRC108Q.  IF CSRC108Q - SET          **          
A04527**                      E-FDB09-OFF-CYCLE-BILL-CODE = 'S'     **          
      **                                                            **          
A04880** 27 JUN 2014 RF10596  WHEN REQUEST - LOAD CIRCUIT-NBR       **          
      **                                                            **          
A04880** 10 OCT 2014 RF10596  WHEN REQUEST - ALL RECORDS GO TO DB09 **          
      **                                                            **          
A04684** 20 JUL 2015 SS95855  ACT002 UPDATE READ_USED_FL TO 'Y'     **          
A04684** 14 SEP 2015 SS95855  ACT002 REMOVE UNNECESSARY CODE        **          
A#5470** 11 NOV 2016 SS95855  ACT054 LAT/LONG FROM PREMISE          **          
A#4200** 15 DEC 2016 SS95855  ACT018 LOOKUP CURRENT DATE - 3 DAYS   **          
      **                      IN CSS_OFFCYCLE_READS TABLE.          **          
A#4200** 21 DEC 2016 SS95855  ACT018 LOOKUP PREV WORK DAY           **          
      **                      IN CSS_OFFCYCLE_READS TABLE.          **          
      ****************************************************************          
           REMARKS.                                                     
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSDB09.                                                            
       COPY CSSCA108.                                                           
       COPY CSSBW629.                                                           
A04684 COPY CSSBW06.                                                            
      /                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDDB09.                                                            
       COPY FIODB09.                                                            
       COPY CFDCA108.                                                           
       COPY FIOCA108.                                                           
       COPY CFDBW629.                                                           
       COPY FIOBW629.                                                           
A04684 COPY CFDBW06.                                                            
A04684 COPY FIOBW06.                                                            
      /                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA108'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)   VALUE                
           'WORKING STORAGE FOR PCSCA108 STARTS HERE'.                  
      *                                                                         
       01  WS-FILE-STATUS-FIELDS.                                       
           05  WS-FDB09-STATUS         PIC X(02).                       
               88  FDB09-SUCCESSFUL                VALUE '00'.          
           05  WS-FCA108-STATUS        PIC X(02).                       
               88  FCA108-SUCCESSFUL               VALUE '00'.          
           05  WS-FBW629-STATUS        PIC X(02).                       
               88 FBW629-SUCCESSFUL                VALUE '00'.          
A04684     05  WS-FBW06-STATUS             PIC X(02)  VALUE '00'.       
A04684         88  FBW06-SUCCESSFUL                   VALUE '00'.       
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ACC-SW        PIC X(01)   VALUE ' '.           
              88 WS-NO-MORE-ACCOUNTS               VALUE 'Y'.           
           05 WS-EOF-FCSCA108-SW       PIC X(01)   VALUE ' '.           
              88 WS-EOF-FCSCA108                   VALUE 'Y'.           
           05 WS-WRITE-DB09-BW629-SW   PIC X(01)   VALUE ' '.           
              88 WS-WRITE-DB09-BW629               VALUE ' '.           
              88 WS-NOT-WRITE-DB09-BW629           VALUE 'N'.           
           05 WS-CYC-BILL-CODE-SW      PIC X(01)   VALUE ' '.           
              88 WS-NO-BILL-CODE-PARM              VALUE ' '.           
              88 WS-PROCESS-AROP-CYCLE             VALUE 'A'.           
              88 WS-PROCESS-NORMAL-CYCLE           VALUE 'B'.           
           05 WS-MTR-PROCESS-SW        PIC X(01)   VALUE ' '.           
              88 WS-NO-METER-TYPE-PARM             VALUE ' '.           
              88 WS-PROCESS-AMR-ONLY               VALUE 'A'.           
              88 WS-PROCESS-ALL-MTR                VALUE 'B'.           
           05 WS-CYC-PROCESS-SW        PIC X(01)   VALUE ' '.           
              88 WS-NO-CYC-PROCESS-PARM            VALUE ' '.           
              88 WS-EXCLUDE-TODAY-CYC              VALUE 'E'.           
              88 WS-PROCESS-ALL-ACC                VALUE 'A'.           
           05 WS-PREV-BUS-DAY-SW               PIC X(01)  VALUE 'N'.    
              88 PREV-BUS-DAY-NOT-FOUND                   VALUE 'N'.    
              88 PREV-BUS-DAY-FOUND                       VALUE 'Y'.    
           05 WS-HOLIDAY-EXISTS-SW             PIC X(01)  VALUE 'N'.    
              88 THIS-IS-NOT-HOLIDAY                      VALUE 'N'.    
              88 THIS-IS-HOLIDAY                          VALUE 'Y'.    
A04684     05 WS-WRITE-BW06-SW         PIC X(01)   VALUE 'N'.           
A04684        88 WRITE-BW06                        VALUE 'Y'.           
A04684        88 DO-NOT-WRITE-BW06                 VALUE 'N'.           
      *                                                                         
       01  WS-MISC.                                                     
           05 WS-PREV-BUSINESS-DAY     PIC X(10).                       
           05 WS-WEEK-DAY-NO           PIC S9(4) COMP.                  
ACT199     05 WS-DATE-MSG-NULL         PIC S9(4) COMP.                  
           05 WS-SUNDAY-NO             PIC S9(4) COMP VALUE +1.         
           05 WS-SATURDAY-NO           PIC S9(4) COMP VALUE +7.         
A04684     05  WS-FBW06-MAX-SUB        PIC S9(4) COMP.                  
           05  WS-AMR-ONLY             PIC X.                           
           05  WS-RUN-DATE             PIC X(10).                       
           05  WS-RUN-CYCLE            PIC X(02)  VALUE SPACES.         
           05  WS-JOB-PARM-CYCLE       PIC X(02)  VALUE SPACES.         
           05  WS-COMPARE-ACCT         PIC 9(13)   VALUE 0.             
           05  WS-IC-NO                PIC 9(04)   VALUE ZEROS.         
           05  WS-MTR-REF-NO           PIC 9(04)   VALUE ZEROS.         
           05  WS-GIS-POINT-ID         PIC 9(12)   VALUE ZEROS.         
           05  WS-LONGITUDE            PIC -9(3).9(6).                  
           05  WS-LATITUDE             PIC -9(3).9(6).                  
           05  WS-SAVE-ACCOUNT-NO      PIC 9(13)   VALUE ZERO.          
           05  WS-DUMMY                PIC X(01)   VALUE SPACES.        
ACT018     05  WS-PREV-WORK-DAY        PIC X(10)   VALUE SPACES.        
Ab4684     05  WS-CURRENT-DATE         PIC X(10)   VALUE SPACES.        
           05  WS-CUR-DATE-BREAKDOWN   PIC X(10).                       
           05  WS-CUR-DATE-BREAKDOWN-RED REDEFINES                      
               WS-CUR-DATE-BREAKDOWN.                                   
               10  WS-CUR-CCYY         PIC 9(04).                       
               10  FILLER REDEFINES WS-CUR-CCYY.                        
                   15  WS-CUR-CC       PIC 9(02).                       
                   15  WS-CUR-YY       PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CUR-MM           PIC 9(02).                       
               10  FILLER              PIC X(01).                       
               10  WS-CUR-DD           PIC 9(02).                       
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-DB-PART-NUM          PIC 9(01)    VALUE 9.            
A04527     05  WS-REQUEST              PIC X(3)     VALUE 'YES'.        
           05  WS-Y                    PIC X(01)    VALUE 'Y'.          
           05  WS-N                    PIC X(01)    VALUE 'N'.          
           05  WS-O                    PIC X(01)    VALUE 'O'.          
           05  WS-COMMON               PIC X(08)    VALUE 'COMMON  '.   
           05  WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA108'.   
           05  PROGRAM-NAME            PIC X(08)    VALUE 'PCSCA108'.   
A04684     05  WS-GAS                  PIC X(01)    VALUE 'G'.          
A04684     05  WS-ELECTRIC             PIC X(01)    VALUE 'E'.          
AA4684     05  WS-YES                  PIC X(01)    VALUE 'Y'.          
AA4684     05  WS-NO                   PIC X(01)    VALUE 'N'.          
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  WS-DB09-CTR             PIC S9(07)   COMP-3 VALUE +0.    
           05  WS-COUNT-FCSCA108       PIC 9(7)     VALUE ZERO.         
           05  WS-FCSCA108-REC-CNTR    PIC 9(7)     VALUE ZERO.         
           05  WS-COUNT-FCSDB09        PIC 9(7)     VALUE ZERO.         
AA4684     05  WS-COUNT-FCSBW06        PIC 9(7)     VALUE ZERO.         
AA4684     05  WS-DISPLAY-FCSCA108     PIC ZZZ,ZZ9.                     
AA4684     05  WS-DISPLAY-FCSDB09      PIC ZZZ,ZZ9.                     
AA4684     05  WS-DISPLAY-FCSBW06      PIC ZZZ,ZZ9.                     
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
A04684 01 WS-FIOBW06-TABLE.                                             
A04684    05 BW06-SUB                      PIC S9(04) COMP.             
A04684    05 WS-FIOBW06-REC OCCURS 50 TIMES.                            
A04684       10 WS-FBW06-ACCOUNT-NO              PIC 9(13).             
A04684       10 WS-FBW06-METER-NO                PIC X(09).             
A04684       10 WS-FBW06-CODE-UTIL-TYPE          PIC X(01).             
A04684       10 WS-FBW06-CODE-USAGE-TYPE         PIC X(01).             
A04684       10 WS-FBW06-CODE-TIME-PERIOD        PIC 9(04).             
A04684       10 WS-FBW06-CODE-TOU-SEASN          PIC X(01).             
A04684       10 WS-FBW06-CODE-USAGE-ID           PIC X(01).             
A04684       10 WS-FBW06-CODE-USAGE-SOURCE       PIC X(01).             
A04684       10 FILLER                           PIC X(09).             
A04684       10 WS-FBW06-REG-MEASURE-CD          PIC X(03).             
A04684       10 WS-FBW06-METER-READING           PIC 9(12)V9(3).        
A04684       10 WS-FBW06-DATE-READ               PIC X(10).             
A04684       10 WS-FBW06-TIME-READ               PIC X(08).             
A04684       10 WS-FBW06-CODE-METER-READ         PIC X(01).             
A04684       10 WS-FBW06-CODE-METER-NO-READ      PIC X(01).             
A04684       10 WS-FBW06-MTR-COMMENT-TX          PIC X(40).             
A04684       10 WS-FBW06-MTR-COND-CD1            PIC X(02).             
A04684       10 WS-FBW06-MTR-COND-CD2            PIC X(02).             
A04684       10 WS-FBW06-EMPLOYEE-NO             PIC X(09).             
A04684       10 WS-FBW06-MTR-READ-SOURCE-CD      PIC X(01).             
A04684       10 WS-FBW06-CNSMPTN-READ-FL         PIC X(01).             
A04684       10 WS-FBW06-INDEX-VALUE-CD          PIC X(01).             
A04684       10 WS-FBW06-READ-PROCESS-CD         PIC X(01).             
A04684       10 WS-FBW06-BTU-FACTOR              PIC 9(02)V9(5).        
A04684       10 WS-FBW06-READ-ITEM-STATUS        PIC X(01).             
A04684       10 WS-FBW06-WORKSET-ID              PIC X(08).             
A04684       10 FILLER                           PIC X(128).            
A04684       10 WS-FBW06-DB-PART-DREC            PIC 9(01).             
      *                                                                         
      *================================================================*        
      * COBOL COPY BOOKS                                               *        
      *================================================================*        
      *                                                                         
       COPY FIOJC01.                                                            
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
       COPY CWS00010.                                                           
       COPY CWS00314.                                                           
       COPY FIOCA00.                                                            
       COPY CWS00038.                                                   04050000
      *** BEWARE OF BELOW REDIFINITIONS, WHICH ARE LINK TO CWS00038     04051000
       01  WS-BILL-CODE-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           10  WS-BILL-CODE-TEXT       PIC X(15).                       
               88  WS-BILL-CODE-EXISTS       VALUE 'CYCLE BILL CODE'.   
           10  FILLER                  PIC X(01).                       
           10  WS-PARM-BILL-CODE-VALUE PIC X(01).                       
               88  WS-NORMAL-CYC-READ               VALUE 'B'.          
               88  WS-AROP-CYC-READ                 VALUE 'A'.          
           10  FILLER                  PIC X(36).                       
      *                                                                 04120000
       01  WS-CYCLE-NUM-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.         
           10  WS-CYCLE-NUM-TEXT       PIC X(17).                       
               88  WS-CYCLE-NUM-EXISTS       VALUE 'READ CYCLE NUMBER'. 
           10  FILLER                  PIC X(01).                       
           10  WS-PARM-CYCLE-VALUE     PIC X(02).                       
           10  FILLER                  PIC X(33).                       
      *                                                                 04110000
       01  WS-MTR-TYPE-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.          
           10  WS-MTR-TYPE-TEXT        PIC X(15).                       
               88  WS-MTR-TYPE-EXISTS        VALUE 'MTRS TO EXTRACT'.   
           10  FILLER                  PIC X(01).                       
           10  WS-PARM-MTR-TYPE-VALUE  PIC X(03).                       
               88  WS-PARM-MTR-TYPE-AMR             VALUE 'AMR'.        
               88  WS-PARM-MTR-TYPE-ALL             VALUE 'ALL'.        
           10  FILLER                  PIC X(34).                       
      *                                                                 04120000
       01  WS-ACC-VAL-PARM REDEFINES WS-INPUT-DATA-BREAKDOWN.           
           10  WS-ACC-VALIDATE-TEXT    PIC X(26).                       
               88  WS-ACC-VAL-EXISTS VALUE 'EXCLUDE TODAY CYC ACCOUNTS'.
           10  FILLER                  PIC X(01).                       
           10  WS-PARM-ACC-VAL-VALUE   PIC X(01).                       
               88  WS-XCLUDE-TODAY-CYC              VALUE 'Y'.          
               88  WS-ALL-CYC-ACCOUNTS              VALUE 'N'.          
           10  FILLER                  PIC X(25).                       
      *                                                                 04120000
      *================================================================*        
      * DB2 DCLGEN MEMBERS                                             *        
      *================================================================*        
      *----------------------------------------------------------------*        
      *** CSS_READ_WINDOW (RW)                                         *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBRDWNDW                                                 
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_ACCOUNT (AT)                                             *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_UTIL_ENVRNMT (UT)                                        *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_JOB_PARM (G6)                                            *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_MTRD_ENVRNMT (MN)                                        *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
                INCLUDE TBMTRENV                                                
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_PREMISE (PR)                                             *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_CUSTOMER (CU)                                            *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBCUST                                                     
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_NAME (DQ)                                                *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBNAME                                                     
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_NAME_ACCT_XREF (HT)                                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBNMACTX                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_CUST_ADDR_XREF (DM)                                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBCSADRX                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_ADDR_FREEFORM (DZ)                                       *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBADRFRE                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_ADDR_FORMATTED (DY)                                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBADRFMT                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_ZIP_CODE (A4)                                            *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBZIPCD                                                    
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_ACCT_MISC_INFO (TA)                                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBATMISC                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_CUST_PREM_HIST (CH)                                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBCSTPRM                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_LOC_OFF_CYC_RT (O2)                                      *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
             INCLUDE TBLCOFRT                                                   
           END-EXEC.                                                            
      *                                                                         
      *----------------------------------------------------------------*        
      *** CSS_HOLIDAY                                                  *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                         
A04684***************************                                               
A04684*    CSS_OFFCYCLE_READS, 3B                                               
A04684***************************                                               
A04684     EXEC SQL                                                     00600000
A04684        INCLUDE TBOFFCYR                                          00610000
A04684     END-EXEC.                                                    00620000
A04684*                                                                         
      *================================================================*        
      * DB2 INCLUDE MEMBERS                                            *        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00074                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00011                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00039                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
      * DB2 CURSOR DECLARATIONS                                        *        
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
ACT199         DECLARE READ_CYCLES CURSOR WITH HOLD FOR                 
                   SELECT READ_CYCLE,                                   
                          UT_READ_CYCLE                                 
                   FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                   
                   WHERE DATE_MTR_RD_XTRCT = IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )      
                   ORDER BY READ_CYCLE                                  
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE READ_CYCLES CURSOR WITH HOLD FOR                         
MFA-TR*            SELECT READ_CYCLE,                                           
MFA-TR*                   UT_READ_CYCLE                                         
MFA-TR*            FROM CSS_READ_WINDOW                                         
MFA-TR*            WHERE DATE_MTR_RD_XTRCT = :RW-DATE-MTR-RD-XTRCT              
MFA-TR*            ORDER BY READ_CYCLE                                          
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE ROUTE_SMART_CSR       CURSOR FOR                  
              SELECT    AT.ACCOUNT_NO                                   
                       ,AT.PREMISE_NO                                   
                       ,AT.COMPANY_NO                                   
                       ,AT.LOCAL_OFFICE                                 
                       ,UT.CODE_UTIL_TYPE                               
                       ,UT.READ_ROUTE                                   
                       ,UT.READ_CYCLE                                   
                       ,UT.COMPANY_NO                                   
                       ,MN.CODE_METER_STATUS                            
                       ,MN.REGISTER_RD_SEQ                              
                       ,MN.CODE_UTIL_TYPE                               
                       ,MN.MTR_REF_NO                                   
                       ,MN.IC_NO                                        
                       ,MN.REMOTE_READ_IND                              
A#5470                 ,PR.PREM_REF_LATITUDE                            
A#5470                 ,PR.PREM_REF_LONGITUDE                           
                       ,MN.GIS_POINT_ID                                 
                       ,PR.ADDRESS_ID                                   
                       ,PR.SPCL_READ_INSTR                              
ACT199                 ,PR.DATE_SPCL_MSG_ENDS                           
                FROM    CSS_ACCOUNT        AT WITH(READUNCOMMITTED)             
                       ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
                       ,CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)             
                       ,CSS_PREMISE        PR WITH(READUNCOMMITTED)             
               WHERE    AT.ACCOUNT_NO         = :AT-ACCOUNT-NO          
                 AND    AT.ACCOUNT_NO         = UT.ACCOUNT_NO           
                 AND    UT.ACCOUNT_NO         = MN.ACCOUNT_NO           
                 AND    UT.IC_NO              = MN.IC_NO                
                 AND    UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE       
                 AND    UT.CODE_UTIL_TYPE     IN ('E','G')              
                 AND    AT.PREMISE_NO         = PR.PREMISE_NO           
                 AND    (MN.REMOTE_READ_IND    = 'A'                    
                         OR :WS-AMR-ONLY = 'N' )                        
                 AND    MN.CODE_METER_STATUS  <> 'K'                    
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ROUTE_SMART_CSR       CURSOR FOR                          
MFA-TR*       SELECT    AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.PREMISE_NO                                           
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,UT.CODE_UTIL_TYPE                                       
MFA-TR*                ,UT.READ_ROUTE                                           
MFA-TR*                ,UT.READ_CYCLE                                           
MFA-TR*                ,UT.COMPANY_NO                                           
MFA-TR*                ,MN.CODE_METER_STATUS                                    
MFA-TR*                ,MN.REGISTER_RD_SEQ                                      
MFA-TR*                ,MN.CODE_UTIL_TYPE                                       
MFA-TR*                ,MN.MTR_REF_NO                                           
MFA-TR*                ,MN.IC_NO                                                
MFA-TR*                ,MN.REMOTE_READ_IND                                      
MFA-TR*                ,PR.PREM_REF_LATITUDE                                    
MFA-TR*                ,PR.PREM_REF_LONGITUDE                                   
MFA-TR*                ,MN.GIS_POINT_ID                                         
MFA-TR*                ,PR.ADDRESS_ID                                           
MFA-TR*                ,PR.SPCL_READ_INSTR                                      
MFA-TR*                ,PR.DATE_SPCL_MSG_ENDS                                   
MFA-TR*         FROM    CSS_ACCOUNT        AT                                   
MFA-TR*                ,CSS_UTIL_ENVRNMT   UT                                   
MFA-TR*                ,CSS_MTRD_ENVRNMT   MN                                   
MFA-TR*                ,CSS_PREMISE        PR                                   
MFA-TR*        WHERE    AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                  
MFA-TR*          AND    AT.ACCOUNT_NO         = UT.ACCOUNT_NO                   
MFA-TR*          AND    UT.ACCOUNT_NO         = MN.ACCOUNT_NO                   
MFA-TR*          AND    UT.IC_NO              = MN.IC_NO                        
MFA-TR*          AND    UT.CODE_UTIL_TYPE     = MN.CODE_UTIL_TYPE               
MFA-TR*          AND    UT.CODE_UTIL_TYPE     IN ('E','G')                      
MFA-TR*          AND    AT.PREMISE_NO         = PR.PREMISE_NO                   
MFA-TR*          AND    (MN.REMOTE_READ_IND    = 'A'                            
MFA-TR*                  OR :WS-AMR-ONLY = 'N' )                                
MFA-TR*          AND    MN.CODE_METER_STATUS  <> 'K'                            
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
A04684     EXEC SQL                                                     
A04684         DECLARE GET_MTR_CSR CURSOR FOR                           
A04684             SELECT MN.METER_NO                                   
A04684                   ,MN.CODE_UTIL_TYPE                             
A04684                   ,MN.IC_NO                                      
A04684                   ,MN.MTR_READ_SOURCE_CD                         
A04684                   ,AT.COMPANY_NO                                 
A04684             FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)               
A04684                 ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)               
A04684                 ,CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
A04684             WHERE MN.ACCOUNT_NO     = UT.ACCOUNT_NO              
A04684               AND UT.ACCOUNT_NO     = AT.ACCOUNT_NO              
A04684               AND AT.ACCOUNT_NO     = :AT-ACCOUNT-NO             
A04684               AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE          
A04684               AND UT.CODE_UTIL_TYPE IN ('E','G')                 
A04684               AND MN.IC_NO          = UT.IC_NO                   
A04684               AND MN.CODE_METER_STATUS <> 'K'                    
A04684               AND AT.CODE_ACCT_STAT IN ('A','B')                 
A04684         FOR READ ONLY                                    
A04684                                                      
A04684     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE GET_MTR_CSR CURSOR FOR                                   
MFA-TR*            SELECT MN.METER_NO                                           
MFA-TR*                  ,MN.CODE_UTIL_TYPE                                     
MFA-TR*                  ,MN.IC_NO                                              
MFA-TR*                  ,MN.MTR_READ_SOURCE_CD                                 
MFA-TR*                  ,AT.COMPANY_NO                                         
MFA-TR*            FROM CSS_MTRD_ENVRNMT MN                                     
MFA-TR*                ,CSS_UTIL_ENVRNMT UT                                     
MFA-TR*                ,CSS_ACCOUNT AT                                          
MFA-TR*            WHERE MN.ACCOUNT_NO     = UT.ACCOUNT_NO                      
MFA-TR*              AND UT.ACCOUNT_NO     = AT.ACCOUNT_NO                      
MFA-TR*              AND AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                     
MFA-TR*              AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                  
MFA-TR*              AND UT.CODE_UTIL_TYPE IN ('E','G')                         
MFA-TR*              AND MN.IC_NO          = UT.IC_NO                           
MFA-TR*              AND MN.CODE_METER_STATUS <> 'K'                            
MFA-TR*              AND AT.CODE_ACCT_STAT IN ('A','B')                         
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                      PIC X(38)    VALUE               
           'WORKING STORAGE FOR PCSCA108 ENDS HERE'.                    
      *                                                                         
A04527 LINKAGE SECTION.                                                 
A04527 01  WS-PARM-VALUE.                                               
A04527     05 WS-PARMVAL-LENGTH             PIC S9(4) COMP.             
A04527     05 WS-PARM-REQUEST-JOB           PIC X(3).                   
      *                                                                         
A04527 PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *                                                                         
      *==============================================================*          
       0000-MAINLINE.                                                   
      *==============================================================*          
      *                                                                         
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-ACCOUNTS         THRU 1000-EXIT         
                      UNTIL WS-NO-MORE-ACCOUNTS.                        
      *                                                                         
           PERFORM 0300-WRITE-END-CONTROLS       THRU 0300-EXIT.        
      *                                                                         
           PERFORM 1900-END-OF-JOB-PROCESS       THRU 1900-EXIT.        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
      *                                                                 09400000
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           PERFORM 0110-GET-PGM-JOB-PARMS     THRU 0110-EXIT.           
           PERFORM 0130-OPEN-DB09-FILE        THRU 0130-EXIT.           
           PERFORM 0140-OPEN-BW629-FILE      THRU 0140-EXIT.            
           PERFORM 0120-OPEN-CA108-FILE       THRU 0120-EXIT.           
           PERFORM 7000-READ-FCSCA108         THRU 7000-EXIT.           
      *                                                                         
           IF WS-EOF-FCSCA108                                           
              DISPLAY ' '                                               
              DISPLAY '*******************************************'     
              DISPLAY '** EAMTY  FCSCA108 FILE  ******************'     
              DISPLAY '** MISSING END RECORD IN FCSCA108 FILE ****'     
              DISPLAY '** PROCESS ABENDING      ******************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
           IF WS-NO-MORE-ACCOUNTS                                       
              DISPLAY ' '                                               
              DISPLAY '*******************************************'     
              DISPLAY '** NO DATA IN FCSCA108 FILE TO PROCESS ****'     
              DISPLAY '** FILE DATED: ' E-FCA108-END-DATE               
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
           INITIALIZE FIODB09                                           
           MOVE WS-RUN-DATE            TO WS-CUR-DATE-BREAKDOWN         
      *                                                                         
           PERFORM 0150-SELECT-MRMS-CYCLE THRU 0150-EXIT                
      *                                                                         
           PERFORM 0200-WRITE-BEGIN-CONTROLS THRU 0200-EXIT             
           DISPLAY '**********************************'                 
           DISPLAY 'RUN DATE: ' WS-RUN-DATE                             
           DISPLAY 'RUN CYCLE: ' WS-RUN-CYCLE                           
           DISPLAY 'TODAY CYCLE: ' RW-READ-CYCLE                        
           DISPLAY '**********************************'.                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       0110-GET-PGM-JOB-PARMS.                                          
      *================================================================*        
      *                                                                         
Ab4684     PERFORM 7900-GET-CURRENT-DATE                                
Ab4684        THRU 7900-EXIT.                                           
ACT018                                                                  
ACT018     MOVE WS-CURRENT-DATE        TO WS-PREV-BUSINESS-DAY.         
ACT018     SET THIS-IS-HOLIDAY TO TRUE.                                 
ACT018     PERFORM 0153-GET-PREV-WORK-DAY        THRU 0153-EXIT         
ACT018       UNTIL THIS-IS-NOT-HOLIDAY.                                 
ACT018                                                                  
ACT018     DISPLAY ' WS-CURRENT-DATE:  ' WS-CURRENT-DATE.               
ACT018     DISPLAY ' WS-PREV-WORK-DAY: ' WS-PREV-WORK-DAY.              
ACT018     DISPLAY ' '                                                  
ACT018                                                                  
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
      *                                                                 10011000
           IF COMMON-DATE-NEEDED                                        
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                 THRU 6240-EXIT         
               MOVE WS-FCA00-COMMON-DATE                                
                                       TO WS-INPUT-DATE                 
           END-IF.                                                      
      *                                                                 10050000
           MOVE WS-INPUT-DATE          TO WS-RUN-DATE.                  
           MOVE SPACES                 TO WS-RUN-CYCLE                  
      *                                                                 10050000
           MOVE SPACES                 TO  WS-SYSIPT.                   
           MOVE WS-PGRMNAME            TO  WS-PROGRAM.                  
           MOVE WS-PARM                TO  WS-COMMAND.                  
           MOVE ZEROES                 TO  WS-SEQUENCE.                 
           MOVE WS-KEY-AREA            TO  E-FJC01-KEY.                 
           PERFORM 7600-START-FCSJC01    THRU  7600-EXIT.               
           PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT.               
           PERFORM 0111-SET-ALL-PARM-VALUES THRU 0111-EXIT.             
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       0111-SET-ALL-PARM-VALUES.                                        
      *================================================================*        
      *                                                                         
           PERFORM UNTIL END-OF-SYSIPT                                  
              IF INPUT-ACTIVE                                           
                 EVALUATE TRUE                                          
                   WHEN WS-BILL-CODE-EXISTS                             
                     DISPLAY '************************************'     
                     DISPLAY '** OVERRIDE BILL CODE BEING USED  **'     
                     IF WS-NORMAL-CYC-READ                              
                        SET WS-PROCESS-NORMAL-CYCLE TO TRUE             
                        DISPLAY '** REGULAR CYC PROCESS CONTINUE .. **' 
                     ELSE                                               
                        SET WS-PROCESS-AROP-CYCLE TO TRUE               
                        DISPLAY '** AROP PROCESS CONTINUE ..  **'       
                     END-IF                                             
                     DISPLAY '************************************'     
      *                                                                         
                   WHEN WS-CYCLE-NUM-EXISTS                             
                     IF WS-PARM-CYCLE-VALUE > SPACES                    
                        DISPLAY '************************************'  
                        DISPLAY '** OVERRIDE CYCLE NO# BEING USED  **'  
                        DISPLAY '** PROCESS USE ' WS-PARM-CYCLE-VALUE   
                                  ' AS MRMS CYCLE IN CASE NONE OPENS '  
                        DISPLAY '************************************'  
                        MOVE WS-PARM-CYCLE-VALUE TO WS-JOB-PARM-CYCLE   
                     END-IF                                             
                                                                        
                   WHEN WS-MTR-TYPE-EXISTS                              
                     DISPLAY '************************************'     
                     DISPLAY '** OVERRIDE METER TYPE BEING USED **'     
                     IF WS-PARM-MTR-TYPE-ALL                            
                        SET WS-PROCESS-ALL-MTR  TO TRUE                 
                        DISPLAY '** PROCESS ALL TYPES OF METERS    **'  
                     ELSE                                               
                        SET WS-PROCESS-AMR-ONLY TO TRUE                 
                        DISPLAY '** PROCESS ONLY AMR METERS        **'  
                     END-IF                                             
                     DISPLAY '************************************'     
                                                                        
                   WHEN WS-ACC-VAL-EXISTS                               
                     DISPLAY '************************************'     
                     DISPLAY '** OVERRIDE ACC VALIDATE BEING USED '     
                     IF WS-ALL-CYC-ACCOUNTS                             
                        DISPLAY '** INCLUDE TODAY CYCLE ACCOUNTS   **'  
                        SET WS-PROCESS-ALL-ACC  TO TRUE                 
                     ELSE                                               
                        SET WS-EXCLUDE-TODAY-CYC TO TRUE                
                        DISPLAY '** EXCLUDE TODAY CYCLE ACCOUNTS   **'  
                     END-IF                                             
                     DISPLAY '************************************'     
                                                                        
                   WHEN OTHER                                           
                     DISPLAY '************************************'     
                     DISPLAY '**UNRECOGNIZED PARM IS ACTIVE     **'     
                     DISPLAY '**BUT PGM DISCARDED PARAMETER:    **'     
                     DISPLAY '** '                                      
                              WS-INPUT-DATA-BREAKDOWN(1:31)    '**'     
                     DISPLAY '************************************'     
                 END-EVALUATE                                           
              END-IF                                                    
              PERFORM 7610-READ-FCSJC01     THRU  7610-EXIT             
           END-PERFORM.                                                 
      ***                                                                       
      ***SET DEFAULT PARAMETERS WHEN JOB PARM NOT ACTIVE                        
      ***OFF-CYCLE-BILL-CODE: AROP (A) / NORMAL (B)                             
           IF WS-NO-BILL-CODE-PARM                                      
              DISPLAY '************************************'            
              DISPLAY '** BILL CODE PARM NOT ACTIVE      **'            
              DISPLAY '** AROP BILL CODE BEING USED      **'            
              DISPLAY '** AROP PROCESS CONTINUE ...      **'            
              DISPLAY '************************************'            
              SET WS-PROCESS-AROP-CYCLE  TO TRUE                        
           END-IF.                                                      
      ***                                                                       
      ***METER TYPES TO PROCESS: AMR ONLY / ALL METERS                          
           IF WS-NO-METER-TYPE-PARM                                     
              DISPLAY '************************************'            
              DISPLAY '** METER TYPE PARM NOT ACTIVE     **'            
              DISPLAY '** ONLY AMR METERS BEING USED     **'            
              DISPLAY '** PROCESSING CONTINUE ...        **'            
              DISPLAY '************************************'            
              SET WS-PROCESS-AMR-ONLY TO TRUE                           
           END-IF.                                                      
      ***                                                                       
      ***VALIDATE ACCOUNTS: EXCLUDE / INCLUDE TODAY CYCLE ACCOUNTS              
           IF WS-NO-CYC-PROCESS-PARM                                    
              DISPLAY '************************************'            
              DISPLAY '** ACC VALIDATE PARM NOT ACTIVE   **'            
              DISPLAY '** EXCLUDING TODAY CYCLE ACCOUNTS **'            
              DISPLAY '** PROCESSING CONTINUE ...        **'            
              DISPLAY '************************************'            
              SET WS-EXCLUDE-TODAY-CYC TO TRUE                          
           END-IF.                                                      
           IF WS-JOB-PARM-CYCLE  = SPACES                               
              DISPLAY '************************************'            
              DISPLAY '** CYCLE NO PARM NOT ACTIVE       **'            
              DISPLAY '** TODAY READ CYCLE BEING USED    **'            
              DISPLAY '** PROCESSING CONTINUE ...        **'            
              DISPLAY '************************************'            
           END-IF.                                                      
      *                                                                         
       0111-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       0120-OPEN-CA108-FILE.                                            
      *================================================================*        
      *                                                                         
           OPEN INPUT FCSCA108-FILE.                                    
      *                                                                         
           IF FCA108-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSCA108 OPEN.  STATUS IS '       
                        WS-FCA108-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       0130-OPEN-DB09-FILE.                                             
      *================================================================*        
      *                                                                         
           OPEN OUTPUT FCSDB09-FILE                                     
      *                                                                         
           IF FDB09-SUCCESSFUL                                          
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSDB09 OPEN.  STATUS IS '        
                        WS-FDB09-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       0140-OPEN-BW629-FILE.                                            
      *================================================================*        
      *                                                                         
           OPEN OUTPUT FCSBW629-FILE.                                   
      *                                                                         
           IF FBW629-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSBW629 OPEN.  STATUS IS '       
                        WS-FBW629-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSBW06-FILE.                                    
      *                                                                         
A04684     IF FBW06-SUCCESSFUL                                          
A04684         CONTINUE                                                 
A04684     ELSE                                                         
A04684         DISPLAY '0100-ERROR ON FCSBW06  OPEN.  STATUS IS '       
A04684                  WS-FBW06-STATUS                                 
A04684         PERFORM 9900-ABEND                THRU 9900-EXIT         
A04684     END-IF.                                                      
      *                                                                         
       0140-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *===============================================================*         
       0150-SELECT-MRMS-CYCLE.                                          
      *===============================================================*         
      * IDENTIFY A CYCLE TO BE USED TO CREATE INTEGRATOR ROUTE-ID     *         
      * FOLLOWING OPTIONS WILL BE USED IN THE ORDER OF PRIORITY       *         
      *  (1) READ CYCLE THAT OPENED ON RUN DATE.                      *         
      *  (2) JOB PARM CYCLE IF ACTIVE.                                *         
      *  (3) USE CYCLE 22 WHEN RUN DAY IS OFF-CYCLE AND PREVIOUS      *         
      *      BUSINESS DAY IS NOT OFF-CYCLE.                           *         
      *  (4) USE CYCLE 23 WHEN RUN DAY AS WELL AS PREVIOUS BUSINESS   *         
      *      DAY WERE OFF-CYCLE.                                      *         
      *  (5) IN CASES WHERE PREVIOUS TWO BUSINESS DAYS ARE OFF-CYCLE  *         
      *      THEN "OUT OF ROUTE AROP" WILL BE ABNORMALLY TERMINATED.  *         
      *      IN THIS CASE JOB PARM CYCLE CAN BE USED TO RESTART JOB.  *         
      *      METER READING MAY INVOLVE TO IDENTIFY JOB PARM CYCLE NO. *         
      *****************************************************************         
      *                                                                         
      * USE READ CYCLE THAT OPENED ON RUN DATE                                  
      *                                                                         
           MOVE WS-RUN-DATE            TO RW-DATE-MTR-RD-XTRCT          
           PERFORM 7050-GET-READ-CYCLE    THRU 7050-EXIT                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RW-READ-CYCLE    TO WS-RUN-CYCLE                     
           ELSE                                                         
      *       USE JOB PARM CYCLE IF ACTIVE                                      
              IF WS-JOB-PARM-CYCLE    > SPACES                          
                 MOVE WS-JOB-PARM-CYCLE   TO WS-RUN-CYCLE               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-RUN-CYCLE > SPACES                                     
              GO TO 0150-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE WS-RUN-DATE            TO WS-PREV-BUSINESS-DAY          
           SET PREV-BUS-DAY-NOT-FOUND  TO TRUE                          
           PERFORM 0152-GET-PREV-BUSINESS-DAY THRU 0152-EXIT            
                    UNTIL PREV-BUS-DAY-FOUND.                           
      *                                                                         
           MOVE WS-PREV-BUSINESS-DAY   TO RW-DATE-MTR-RD-XTRCT          
      *                                                                         
      *****CHECK IF PREV BUSINESS IS OFF-CYCLE                                  
           PERFORM 7050-GET-READ-CYCLE    THRU 7050-EXIT                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE '22'             TO WS-RUN-CYCLE                     
           ELSE                                                         
      *****   CHECK IF PREV 2 BUSINESS DAYS OFF-CYCLE                           
      *****   CYCLE 23 CODE HERERN-CODE EQUAL NOT-FOUND                         
              SET PREV-BUS-DAY-NOT-FOUND  TO TRUE                       
              PERFORM 0152-GET-PREV-BUSINESS-DAY THRU 0152-EXIT         
                       UNTIL PREV-BUS-DAY-FOUND                         
              MOVE WS-PREV-BUSINESS-DAY   TO RW-DATE-MTR-RD-XTRCT       
              PERFORM 7050-GET-READ-CYCLE    THRU 7050-EXIT             
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE '23'             TO WS-RUN-CYCLE                  
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '**   PCSCA108 PROCESSING ERROR          **'   
                 DISPLAY '**-------------------------------       **'   
                 DISPLAY '**   0150-SELECT-MRMS-CYCLE:'                 
                 DISPLAY '**   WS-RUN-DATE :' WS-RUN-DATE               
                 DISPLAY '**   NOT ABLE TO IDENTIFY CYCLE TO BE USED'   
                 DISPLAY '**   PREVIOUS TWO BUSINESS DAYS WERE'         
                 DISPLAY '**   OFF-CYCLES. NEED TO SPECIFY JOB PARM'    
                 DISPLAY '**   CYCLE TO PROCEED....'                    
                 DISPLAY '******************************************'   
                 PERFORM 9900-ABEND              THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
       0150-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       0152-GET-PREV-BUSINESS-DAY.                                      
      *================================================================*        
      *                                                                         
      *    GETS THE PREVIOUS BUSINESS DAY AND ITS DAY OF WEEK                   
           PERFORM 7340-CHECK-WEEK-END     THRU 7340-EXIT.              
                                                                        
      ***  CHECK TO SEE IF IT IS A WEEKEND...                                   
           IF WS-WEEK-DAY-NO     NOT EQUAL WS-SATURDAY-NO AND           
              WS-WEEK-DAY-NO     NOT EQUAL WS-SUNDAY-NO                 
                                                                        
              MOVE WS-PREV-BUSINESS-DAY  TO J8-HOLIDAY-DT               
              SET THIS-IS-NOT-HOLIDAY    TO TRUE                        
                                                                        
      ***     CHECK TO SEE IF IT IS A HOLIDAY...                                
              PERFORM 7360-CHECK-HOLIDAY      THRU 7360-EXIT            
      *                                                                         
              IF THIS-IS-NOT-HOLIDAY                                    
                 SET PREV-BUS-DAY-FOUND      TO TRUE                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0152-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT018*================================================================*        
ACT018 0153-GET-PREV-WORK-DAY.                                          
ACT018*================================================================*        
ACT018*                                                                         
ACT018*    GETS THE PREVIOUS BUSINESS DAY AND ITS DAY OF WEEK                   
ACT018     PERFORM 7340-CHECK-WEEK-END     THRU 7340-EXIT.              
ACT018                                                                  
ACT018***  CHECK TO SEE IF IT IS A WEEKEND...                                   
ACT018     IF WS-WEEK-DAY-NO     NOT EQUAL WS-SATURDAY-NO AND           
ACT018        WS-WEEK-DAY-NO     NOT EQUAL WS-SUNDAY-NO                 
ACT018        MOVE WS-PREV-BUSINESS-DAY  TO WS-PREV-WORK-DAY            
ACT018        SET THIS-IS-NOT-HOLIDAY    TO TRUE                        
ACT018     END-IF.                                                      
ACT018*                                                                         
ACT018 0153-EXIT.                                                       
ACT018     EXIT.                                                        
      *                                                                         
      *================================================================*        
       0200-WRITE-BEGIN-CONTROLS.                                       
      *================================================================*        
      *                                                                         
           MOVE LOW-VALUES             TO E-FDB09-KEY-BREC              
           MOVE WS-DB-PART-NUM         TO E-FDB09-DB-PART-BREC          
           MOVE WS-RUN-DATE            TO E-FDB09-CREATE-DATE-BREC      
           MOVE WS-RUN-CYCLE           TO E-FDB09-CYCLE-NO-BREC (1)     
           PERFORM 8950-WRITE-FCSDB09     THRU 8950-EXIT                
           SUBTRACT 1 FROM  WS-DB09-CTR                                 
           .                                                            
       0200-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       0300-WRITE-END-CONTROLS.                                         
      *================================================================*        
      *                                                                         
           INITIALIZE                     FIODB09                       
           MOVE HIGH-VALUES            TO E-FDB09-KEY-EREC              
           MOVE WS-DB-PART-NUM         TO E-FDB09-DB-PART-EREC          
           MOVE WS-DB09-CTR            TO E-FDB09-RECORD-COUNT-EREC     
           PERFORM 8950-WRITE-FCSDB09     THRU 8950-EXIT                
           SUBTRACT 1 FROM  WS-DB09-CTR                                 
A04684                                                                  
A04684     MOVE SPACES                 TO FIOBW06.                      
A04684     INITIALIZE FIOBW06.                                          
A04684     MOVE 1                      TO E-FBW06-DB-PART-DREC.         
A04684     MOVE ALL '9'                TO E-FBW06-RECORD-KEY.           
A04684     PERFORM 8960-WRITE-FCSBW06     THRU 8960-EXIT.               
A04684*                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       1000-PROCESS-ACCOUNTS.                                           
      *================================================================*        
      *                                                                         
           DISPLAY 'PROCESSING ACCT# ' E-FCA108-ACCOUNT-NO              
           MOVE E-FCA108-ACCOUNT-NO    TO AT-ACCOUNT-NO                 
           PERFORM 7300-SELECT-ACCOUNT THRU 7300-EXIT.                  
           MOVE AT-PREMISE-NO          TO WS-CPD99-PREMISE-NO           
           MOVE ZEROS                  TO WS-CPD99-ACCOUNT-NO           
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT                
           MOVE WS-CPD99-ACCOUNT-NO  TO WS-COMPARE-ACCT                 
           IF AT-ACCOUNT-NO NOT EQUAL WS-CPD99-ACCOUNT-NO               
              DISPLAY 'WARNING: ACCOUNT REPLACING LATEST ACCOUNT'       
              DISPLAY 'OLD ACCOUNT: ' E-FCA108-ACCOUNT-NO               
              DISPLAY 'NEW ACCOUNT: ' WS-COMPARE-ACCT                   
              MOVE WS-CPD99-ACCOUNT-NO TO AT-ACCOUNT-NO                 
           END-IF                                                       
      *                                                                         
           SET WS-WRITE-DB09-BW629     TO TRUE                          
           MOVE AT-ACCOUNT-NO          TO UT-ACCOUNT-NO                 
                                          MN-ACCOUNT-NO                 
      *                                                                         
           IF AT-ACCOUNT-NO = WS-SAVE-ACCOUNT-NO                        
              SET WS-NOT-WRITE-DB09-BW629 TO TRUE                       
           ELSE                                                         
               MOVE AT-ACCOUNT-NO      TO WS-SAVE-ACCOUNT-NO            
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                    TO WS-AMR-ONLY                   
           IF WS-PROCESS-AMR-ONLY AND WS-WRITE-DB09-BW629               
              MOVE 'Y'                 TO WS-AMR-ONLY                   
              PERFORM 7500-CHECK-MTRD-ENV THRU 7500-EXIT                
              IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  SET WS-NOT-WRITE-DB09-BW629 TO TRUE                   
                  DISPLAY 'SKIPPED AT MTRD'                             
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-EXCLUDE-TODAY-CYC AND WS-WRITE-DB09-BW629              
              PERFORM 7510-CHECK-UTIL-ENV THRU 7510-EXIT                
              IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  SET WS-NOT-WRITE-DB09-BW629 TO TRUE                   
                  DISPLAY 'SKIPPED AT UTIL'                             
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-WRITE-DB09-BW629                                       
              PERFORM 2000-PROCESS-DB09-BW629 THRU 2000-EXIT            
           END-IF.                                                      
           PERFORM 7000-READ-FCSCA108 THRU 7000-EXIT.                   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       2000-PROCESS-DB09-BW629.                                         
      *================================================================*        
      *                                                                         
           PERFORM 7400-OPEN-ROUTE-SMART     THRU 7400-EXIT.            
ACT054     INITIALIZE PR-SPCL-READ-INSTR PR-DATE-SPCL-MSG-ENDS.         
           PERFORM 7420-FETCH-ROUTE-SMART    THRU 7420-EXIT.            
ACT199     IF  PR-DATE-SPCL-MSG-ENDS > SPACES      AND                  
ACT199         PR-DATE-SPCL-MSG-ENDS < WS-RUN-DATE                      
ACT199             MOVE SPACES TO PR-SPCL-READ-INSTR-TEXT               
ACT199             MOVE      0 TO PR-SPCL-READ-INSTR-LEN                
ACT199             PERFORM 7550-UPDATE-PREMISE THRU 7550-EXIT           
ACT199     END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                  DISPLAY 'SKIPPED AT DTL'                              
           END-IF                                                       
           PERFORM 2100-PROCESS-ROUTE-SMART  THRU 2100-EXIT             
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7440-CLOSE-ROUTE-SMART    THRU 7440-EXIT.            
      *                                                                         
A04684     SET WRITE-BW06 TO TRUE.                                      
A04684                                                                  
A04684     PERFORM 2110-CHECK-AROP-READ   THRU 2110-EXIT.               
A04684                                                                  
A04880     IF DO-NOT-WRITE-BW06 OR WS-PARM-REQUEST-JOB = WS-REQUEST     
A04684        PERFORM 2200-FORMAT-FCSDB09 THRU 2200-EXIT                
A04684     ELSE                                                         
AA4684        ADD  +1                     TO WS-COUNT-FCSBW06           
A04684        MOVE +1                     TO BW06-SUB                   
A04684        PERFORM 2400-PREPARE-BWO6   THRU 2400-EXIT                
A04684           VARYING BW06-SUB FROM 1 BY 1                           
A04684             UNTIL BW06-SUB > WS-FBW06-MAX-SUB                    
A04684     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       2100-PROCESS-ROUTE-SMART.                                        
      *================================================================*        
      *                                                                         
           INITIALIZE FIOBW629                                          
           MOVE AT-ACCOUNT-NO          TO E-FBW629-ACCOUNT-NO           
      *                                                                         
           MOVE PR-ADDRESS-ID          TO AT-ADDRESS-ID.                
           PERFORM 4000-MAIL-NAME-ADDRESS THRU 4000-EXIT.               
      *                                                                         
           MOVE AT-PREMISE-NO          TO E-FBW629-PREMISE-NO.          
           MOVE UT-CODE-UTIL-TYPE      TO E-FBW629-CODE-UTIL-TYPE.      
      *                                                                         
           MOVE MN-IC-NO               TO WS-IC-NO.                     
           MOVE WS-IC-NO               TO E-FBW629-IC-NO.               
      *                                                                         
           MOVE MN-MTR-REF-NO          TO WS-MTR-REF-NO.                
           MOVE WS-MTR-REF-NO          TO E-FBW629-MTR-REF-NO.          
      *                                                                         
           MOVE WS-CUSTOMER-NAME       TO E-FBW629-CUSTOMER-NAME.       
           MOVE WS-HOUSE-NO            TO E-FBW629-STREET-NUMBER.       
           MOVE WS-ADDR-PREFIX-2       TO E-FBW629-STREET-PREFIX.       
           MOVE WS-NAME-STREET         TO E-FBW629-STREET-NAME.         
           MOVE WS-STREET-SUFFIX       TO E-FBW629-STREET-TYPE.         
           MOVE SPACES                 TO E-FBW629-STREET-SUFFIX.       
           MOVE WS-STREET-LOCATION-2   TO E-FBW629-APARTMENT-NO.        
           MOVE SPACES                 TO E-FBW629-BUILDING-NO.         
           MOVE WS-CITY                TO E-FBW629-CITY.                
           MOVE WS-STATE               TO E-FBW629-STATE.               
           MOVE WS-ZIP-CODE            TO E-FBW629-POSTAL-CODE.         
           MOVE WS-ZIP-PLUS-4          TO E-FBW629-ZIP-PLUS4.           
      *                                                                         
           IF PR-SPCL-READ-INSTR-LEN > 0                                
              MOVE PR-SPCL-READ-INSTR-TEXT                              
                                       TO E-FBW629-COMMENT-TEXT         
           END-IF.                                                      
      *                                                                         
           MOVE 'N'                      TO E-FBW629-ALLEY-SERVICE.     
      *                                                                         
A#5470     IF PR-PREM-REF-LONGITUDE = ZEROS                             
              MOVE SPACES              TO E-FBW629-LONGITUDE            
           ELSE                                                         
A#5470        MOVE PR-PREM-REF-LONGITUDE TO WS-LONGITUDE                
              MOVE WS-LONGITUDE         TO E-FBW629-LONGITUDE           
              MOVE +0                   TO WS-LONGITUDE                 
           END-IF.                                                      
                                                                        
A#5470     IF PR-PREM-REF-LATITUDE = ZEROS                              
              MOVE SPACES              TO E-FBW629-LATITUDE             
           ELSE                                                         
A#5470        MOVE PR-PREM-REF-LATITUDE TO WS-LATITUDE                  
              MOVE WS-LATITUDE         TO E-FBW629-LATITUDE             
              MOVE +0                  TO WS-LATITUDE                   
           END-IF.                                                      
      *                                                                         
           MOVE MN-GIS-POINT-ID        TO WS-GIS-POINT-ID               
           MOVE ZEROS                  TO WS-GIS-POINT-ID(1:3)          
           MOVE WS-GIS-POINT-ID        TO E-FBW629-GIS-POINT-ID         
                                                                        
           MOVE 'A'                    TO E-FBW629-METER-STATUS         
      *                                                                         
           MOVE SPACES                 TO E-FBW629-EXIST-PARTITION.     
           MOVE UT-READ-ROUTE          TO E-FBW629-EXIST-ROUTE.         
           MOVE MN-REGISTER-RD-SEQ     TO E-FBW629-EXIST-SEQUENCE.      
           MOVE AT-LOCAL-OFFICE        TO E-FBW629-REGION.              
           MOVE MN-REMOTE-READ-IND     TO E-FBW629-SERVICE-TYPE.        
           MOVE SPACES                 TO E-FBW629-SERVICE-MODE.        
           MOVE UT-READ-CYCLE          TO E-FBW629-FREQUENCY-CODE.      
           MOVE SPACES                 TO E-FBW629-PRODUCT-CODE.        
      *                                                                         
           MOVE AT-LOCAL-OFFICE        TO O2-LOCAL-OFFICE               
           MOVE UT-READ-CYCLE          TO O2-READ-CYCLE                 
           MOVE UT-READ-ROUTE          TO O2-READ-ROUTE                 
      *                                                                         
           PERFORM 7320-GET-ITRON-PC-ID   THRU 7320-EXIT                
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE O2-ITRON-PC-ID      TO E-FBW629-START-POINT-ID       
                                          E-FBW629-END-POINT-ID         
           ELSE                                                         
              MOVE SPACES              TO E-FBW629-START-POINT-ID       
                                          E-FBW629-END-POINT-ID         
           END-IF.                                                      
      *                                                                         
           MOVE AT-COMPANY-NO          TO E-FBW629-COMPANY-NO.          
      *                                                                         
           PERFORM 8000-WRITE-FIOBW629           THRU 8000-EXIT.        
ACT054     INITIALIZE PR-SPCL-READ-INSTR PR-DATE-SPCL-MSG-ENDS.         
           PERFORM 7420-FETCH-ROUTE-SMART        THRU 7420-EXIT.        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04684*================================================================*        
A04684 2110-CHECK-AROP-READ.                                            
A04684*================================================================*        
A04684*                                                                         
A04684     INITIALIZE WS-FIOBW06-TABLE                                  
A04684                WS-FBW06-MAX-SUB.                                 
A04684                                                                  
A04684     PERFORM 7810-OPEN-GET-MTR         THRU 7810-EXIT.            
A04684                                                                  
A04684     PERFORM 7820-FETCH-GET-MTR        THRU 7820-EXIT.            
A04684                                                                  
A04684     PERFORM 2300-PROCESS-GET-MTR      THRU 2300-EXIT             
A04684        UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
A04684                                                                  
A04684     PERFORM 7830-CLOSE-GET-MTR        THRU 7830-EXIT.            
A04684*                                                                         
A04684 2110-EXIT.                                                       
A04684     EXIT.                                                        
      *                                                                         
      *================================================================*        
       2200-FORMAT-FCSDB09.                                             
      *================================================================*        
      *                                                                         
           MOVE ZERO                   TO E-FDB09-SORT-SUM-FLD.         
           MOVE AT-ACCOUNT-NO          TO E-FDB09-ACCOUNT-NO.           
A04527     IF WS-PARM-REQUEST-JOB = WS-REQUEST                          
A04527        MOVE 'S' TO E-FDB09-OFF-CYCLE-BILL-CODE                   
A04880        MOVE E-FCA108-CIRCUIT-NBR TO E-FDB09-CIRCUIT-NBR          
A04527     ELSE                                                         
A04527        MOVE 'A' TO E-FDB09-OFF-CYCLE-BILL-CODE                   
              IF WS-PROCESS-NORMAL-CYCLE                                
                 MOVE 'M' TO E-FDB09-OFF-CYCLE-BILL-CODE                
              END-IF                                                    
A04527     END-IF.                                                      
           MOVE 'N'  TO E-FDB09-MID-MONTH-RD-FLAG.                      
           MOVE ' '  TO E-FDB09-HELD-CODE.                              
      *                                                                         
           PERFORM 8950-WRITE-FCSDB09        THRU 8950-EXIT.            
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04684*================================================================*        
A04684 2300-PROCESS-GET-MTR.                                            
A04684*================================================================*        
A04684*                                                                         
A04684     MOVE MN-METER-NO            TO 3B-METER-NO.                  
A04684     MOVE MN-CODE-UTIL-TYPE      TO 3B-CODE-UTIL-TYPE.            
A04684     MOVE MN-IC-NO               TO 3B-IC-NO.                     
A04684     MOVE AT-COMPANY-NO          TO 3B-COMPANY-NO.                
A04684     MOVE AT-ACCOUNT-NO          TO 3B-ACCOUNT-NO.                
A04684                                                                  
A04684     PERFORM 7840-GET-AROP-READ     THRU 7840-EXIT.               
A04684                                                                  
A04684     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
A04684        SET DO-NOT-WRITE-BW06 TO TRUE                             
A04684        GO TO 2300-EXIT                                           
A04684     END-IF.                                                      
A04684                                                                  
A04684     PERFORM 2310-LOAD-BW06-ARRAY   THRU 2310-EXIT.               
A04684                                                                  
ACT002     PERFORM 8100-UPDT-OFFCYCLE     THRU 8100-EXIT.               
A04684                                                                  
A04684     PERFORM 7820-FETCH-GET-MTR     THRU 7820-EXIT.               
A04684*                                                                         
A04684 2300-EXIT.                                                       
A04684     EXIT.                                                        
A04684/                                                                         
A04684*================================================================*        
A04684 2310-LOAD-BW06-ARRAY.                                            
A04684*================================================================*        
A04684*                                                                         
A04684     ADD +1              TO BW06-SUB.                             
A04684                                                                  
A04684     MOVE 3B-ACCOUNT-NO  TO WS-FBW06-ACCOUNT-NO    (BW06-SUB).    
A04684     MOVE 3B-METER-NO    TO WS-FBW06-METER-NO      (BW06-SUB).    
A04684     MOVE 3B-CODE-UTIL-TYPE                                       
A04684                         TO WS-FBW06-CODE-UTIL-TYPE(BW06-SUB).    
A04684                                                                  
A04684     MOVE 3B-RAW-READING TO WS-FBW06-METER-READING (BW06-SUB).    
A04684     MOVE 3B-REG-READ-DT TO WS-FBW06-DATE-READ     (BW06-SUB).    
A04684     MOVE 3B-REG-READ-TM TO WS-FBW06-TIME-READ     (BW06-SUB).    
A04684     MOVE 3B-TAMPER-CD-1 TO WS-FBW06-MTR-COND-CD1  (BW06-SUB).    
A04684     MOVE 3B-TAMPER-CD-2 TO WS-FBW06-MTR-COND-CD2  (BW06-SUB).    
A04684     MOVE MN-MTR-READ-SOURCE-CD                                   
A04684                         TO WS-FBW06-MTR-READ-SOURCE-CD(BW06-SUB).
A04684                                                                  
A04684     MOVE 'Y'            TO WS-FBW06-CNSMPTN-READ-FL(BW06-SUB).   
A04684     MOVE 'I'            TO WS-FBW06-INDEX-VALUE-CD (BW06-SUB).   
A04684     MOVE 'C'            TO WS-FBW06-CODE-TOU-SEASN (BW06-SUB).   
A04684     MOVE 0              TO WS-FBW06-CODE-TIME-PERIOD(BW06-SUB).  
A04684                                                                  
A04684***  HANDHELD READ                                                        
A04684     MOVE '3'            TO WS-FBW06-READ-PROCESS-CD(BW06-SUB).   
A04684                                                                  
AA4684***  CHANGED AROP READ 'O' TO OFFCYCLE UNATTENDED READ 'U'                
AA4684***  IN ORDER TO IDENTIFY THIS BY SERVICE ORDERS                          
AA4684     MOVE 'U'            TO WS-FBW06-READ-ITEM-STATUS(BW06-SUB).  
A04684                                                                  
A04684***  AMR READ CODE                                                        
A04684     MOVE 'A'            TO WS-FBW06-CODE-METER-READ(BW06-SUB).   
A04684                                                                  
A04684     IF 3B-CODE-UTIL-TYPE = WS-ELECTRIC                           
A04684        MOVE 'KWH'       TO WS-FBW06-REG-MEASURE-CD (BW06-SUB)    
A04684        MOVE 'B'         TO WS-FBW06-CODE-USAGE-TYPE(BW06-SUB)    
A04684     ELSE                                                         
A04684        MOVE 'GAS'       TO WS-FBW06-REG-MEASURE-CD (BW06-SUB)    
A04684        MOVE 'C'         TO WS-FBW06-CODE-USAGE-TYPE(BW06-SUB)    
A04684     END-IF.                                                      
A04684                                                                  
A04684*** BASIC SERVICE                                                         
A04684     MOVE 'A'            TO WS-FBW06-CODE-USAGE-ID  (BW06-SUB).   
A04684                                                                  
A04684*** PRIMARY REGISTER                                                      
A04684     MOVE 'B'            TO WS-FBW06-CODE-USAGE-SOURCE(BW06-SUB). 
A04684                                                                  
A04684     MOVE ZERO           TO WS-FBW06-BTU-FACTOR     (BW06-SUB).   
A04684                                                                  
A04684     MOVE SPACES         TO WS-FBW06-WORKSET-ID     (BW06-SUB)    
A04684                            WS-FBW06-EMPLOYEE-NO    (BW06-SUB)    
A04684                            WS-FBW06-MTR-COMMENT-TX (BW06-SUB)    
A04684                            WS-FBW06-EMPLOYEE-NO    (BW06-SUB)    
A04684                            WS-FBW06-CODE-METER-NO-READ(BW06-SUB).
A04684                                                                  
A04684     MOVE 1              TO WS-FBW06-DB-PART-DREC   (BW06-SUB).   
A04684                                                                  
A04684     MOVE BW06-SUB       TO WS-FBW06-MAX-SUB.                     
A04684*                                                                         
A04684 2310-EXIT.                                                       
A04684     EXIT.                                                        
A04684/                                                                         
A04684*================================================================*        
A04684 2400-PREPARE-BWO6.                                               
A04684*================================================================*        
A04684*                                                                         
A04684     MOVE WS-FIOBW06-REC(BW06-SUB) TO FIOBW06.                    
A04684     PERFORM 8960-WRITE-FCSBW06       THRU 8960-EXIT.             
A04684*                                                                         
A04684 2400-EXIT.                                                       
A04684     EXIT.                                                        
A04684/                                                                         
      *================================================================*        
       1900-END-OF-JOB-PROCESS.                                         
      *================================================================*        
      *                                                                         
           IF WS-EOF-FCSCA108                                           
              DISPLAY '*******************************************'     
              DISPLAY '** ERROR DETECTED IN FCSCA108 FILE ********'     
              DISPLAY '** NO END CONTROL RECORD FOUND ************'     
              DISPLAY '** PROGRAM ABENDING IN 1900- PARA  ********'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
           PERFORM 7000-READ-FCSCA108         THRU 7000-EXIT.           
      *                                                                         
           IF NOT WS-EOF-FCSCA108                                       
              DISPLAY '*******************************************'     
              DISPLAY '** ERROR DETECTED IN FCSCA108 FILE ********'     
              DISPLAY '** DATA FOUND AFTER END CNTL RECORD *******'     
              DISPLAY '** PROGRAM ABENDING IN 1900- PARA  ********'     
              PERFORM 9900-ABEND       THRU 9900-EXIT                   
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
AA4684     MOVE WS-FCSCA108-REC-CNTR   TO WS-DISPLAY-FCSCA108.          
           MOVE WS-COUNT-FCSDB09       TO WS-DISPLAY-FCSDB09.           
AA4684     MOVE WS-COUNT-FCSBW06       TO WS-DISPLAY-FCSBW06.           
      *                                                                         
           DISPLAY '                                       '.           
           DISPLAY '                                       '.           
AA4684     DISPLAY '# OF RECS READ FROM FCSCA108  ' WS-DISPLAY-FCSCA108.
AA4684     DISPLAY '# OF RECS WRITTEN TO FCSDB09  ' WS-DISPLAY-FCSDB09. 
AA4684     DISPLAY '# OF RECS WRITTEN TO FCSBW06  ' WS-DISPLAY-FCSBW06. 
           DISPLAY '                                       '.           
           DISPLAY '                                       '.           
                                                                        
           DISPLAY 'PCSCA108 SUCESSFULLY ENDED             '.           
      *                                                                         
       1900-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *--------------------------------------------------------------*          
      *** 6010-REDUCE-EMBEDDED-SPACES                                *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE CPD00004                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *** 4000-MAIL-NAME-ADDRESS                                     *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE CPD00074                                                 
           END-EXEC.                                                            
      *                                                                         
      *--------------------------------------------------------------*          
      *** 6990-FETCH-CUR-ACCOUNT                                     *          
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.           *          
      *--------------------------------------------------------------*          
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
       6995-CPD99-ERROR-ROUTINE.                                        
      *==============================================================*          
      *                                                                         
           DISPLAY '*************PCSCA108************'.                 
           DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
           DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1.                
           DISPLAY '* SQL CODE IS  ', WS-CPD99-RETURN-CODE.             
           DISPLAY '* PROGRAM ABENDING...           *'.                 
           DISPLAY '*************PCSBW121************'.                 
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       COPY CPD00040.                                                           
       COPY CPD00037.                                                           
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *================================================================*        
       7000-READ-FCSCA108.                                              
      *================================================================*        
      *                                                                 20301000
           READ FCSCA108-FILE                                           
               AT END                                                   
                   SET WS-EOF-FCSCA108      TO TRUE                     
                   SET WS-NO-MORE-ACCOUNTS  TO TRUE                     
                   GO                  TO 7000-EXIT.                    
      *                                                                 20341000
           IF FCA108-SUCCESSFUL                                         
              IF E-FCA108-END-KEY = '9999999999999'                     
                 SET WS-NO-MORE-ACCOUNTS  TO TRUE                       
              ELSE                                                      
                 ADD 1                   TO WS-FCSCA108-REC-CNTR        
              END-IF                                                    
           ELSE                                                         
               DISPLAY '7000-ERROR ON FCSCA108 READ.  STATUS IS '       
                        WS-FCA108-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 20420000
       7000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       7050-GET-READ-CYCLE.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) READ_CYCLE                                       
                  INTO :RW-READ-CYCLE                                   
                FROM CSS_READ_WINDOW WITH(READUNCOMMITTED)                      
                WHERE DATE_MTR_RD_XTRCT = IIF(TRY_CONVERT(DATE, 
                                                  :RW-DATE-MTR-RD-XTRCT
              ) IS NULL OR (PATINDEX('%.%', :RW-DATE-MTR-RD-XTRCT
              ) <> 0) OR (LEN(:RW-DATE-MTR-RD-XTRCT
              ) <> 10), CIS.CHAR2DATE(:RW-DATE-MTR-RD-XTRCT
              ), CONVERT(DATE, :RW-DATE-MTR-RD-XTRCT) )         
                  AND READ_CYCLE < '21'                                 
                  AND UT_READ_CYCLE     = '  '                          
                ORDER BY READ_CYCLE                                     
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT READ_CYCLE                                               
MFA-TR*           INTO :RW-READ-CYCLE                                           
MFA-TR*         FROM CSS_READ_WINDOW                                            
MFA-TR*         WHERE DATE_MTR_RD_XTRCT = :RW-DATE-MTR-RD-XTRCT                 
MFA-TR*           AND READ_CYCLE < '21'                                         
MFA-TR*           AND UT_READ_CYCLE     = '  '                                  
MFA-TR*         ORDER BY READ_CYCLE                                             
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '*******************************************'     
               DISPLAY '** PGM ABEND AT 7050-GET-READ-CYCLE ******'     
               DISPLAY '** DATE_MTR_RD_XTRCT = ' RW-DATE-MTR-RD-XTRCT   
               DISPLAY '** UT_READ_CYCLE     = SPACES'                  
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               PERFORM 9900-ABEND                THRU 9900-EXIT         
              DISPLAY '*******************************************'     
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       7500-CHECK-MTRD-ENV.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'X'                                                
                INTO :WS-DUMMY                                          
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      IN ( 'E', 'G')                 
                 AND CODE_METER_STATUS  <> 'K'                          
                 AND REMOTE_READ_IND    <> 'A'                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'X'                                                        
MFA-TR*         INTO :WS-DUMMY                                                  
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      IN ( 'E', 'G')                         
MFA-TR*          AND CODE_METER_STATUS  <> 'K'                                  
MFA-TR*          AND REMOTE_READ_IND    <> 'A'                                  
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSCA108 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7500        **'          
               DISPLAY '**      ACCOUNT-NO    = ' MN-ACCOUNT-NO         
               DISPLAY '**      UTIL TYPE     =   E OR G   **'          
               DISPLAY '**      IC-NO         = ' MN-IC-NO              
               DISPLAY '**      REG READ CODE = ' MN-CODE-CRNT-REG-READ 
               DISPLAY '**             SQLCODE = ' WS-ACTIVE-RETURN-CODE
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7510-CHECK-UTIL-ENV.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'X'                                                
                INTO :WS-DUMMY                                          
                FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO          = :UT-ACCOUNT-NO               
                 AND CODE_UTIL_TYPE      IN ( 'E', 'G')                 
                 AND READ_CYCLE          = :RW-READ-CYCLE               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'X'                                                        
MFA-TR*         INTO :WS-DUMMY                                                  
MFA-TR*         FROM CSS_UTIL_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO          = :UT-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      IN ( 'E', 'G')                         
MFA-TR*          AND READ_CYCLE          = :RW-READ-CYCLE                       
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**  PCSCA108 PROCESSING ERROR      **'          
               DISPLAY '**  ABEND IN PARAGRAPH 7510        **'          
               DISPLAY '**      ACCOUNT-NO    = ' UT-ACCOUNT-NO         
               DISPLAY '**      UTIL TYPE     =   E OR G   **'          
               DISPLAY '**      READ_CYCLE    = ' RW-READ-CYCLE         
               DISPLAY '**       SQLCODE = ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7300-SELECT-ACCOUNT.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                 INTO :AT-PREMISE-NO                                    
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*          INTO :AT-PREMISE-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '7300-' WS-ACTIVE-RETURN-CODE                     
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       7320-GET-ITRON-PC-ID.                                            
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT ITRON_PC_ID                                       
                 INTO :O2-ITRON-PC-ID                                   
                 FROM CSS_LOC_OFF_CYC_RT WITH(READUNCOMMITTED)                  
                WHERE LOCAL_OFFICE = :O2-LOCAL-OFFICE                   
                  AND READ_CYCLE   = :O2-READ-CYCLE                     
                  AND READ_ROUTE   = :O2-READ-ROUTE                     
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ITRON_PC_ID                                               
MFA-TR*          INTO :O2-ITRON-PC-ID                                           
MFA-TR*          FROM CSS_LOC_OFF_CYC_RT                                        
MFA-TR*         WHERE LOCAL_OFFICE = :O2-LOCAL-OFFICE                           
MFA-TR*           AND READ_CYCLE   = :O2-READ-CYCLE                             
MFA-TR*           AND READ_ROUTE   = :O2-READ-ROUTE                             
MFA-TR*         QUERYNO 7320                                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA108 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7320       **'       
               DISPLAY '** LOCAL OFFICE = ' O2-LOCAL-OFFICE             
               DISPLAY '** READ CYCLE   = ' O2-READ-CYCLE               
               DISPLAY '** READ ROUTN   = ' O2-READ-ROUTE               
               DISPLAY '*****************************************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       7340-CHECK-WEEK-END.                                             
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) ),
              (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) )) -       
                     CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                  :WS-PREV-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-PREV-BUSINESS-DAY
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-BUSINESS-DAY
              ), CONVERT(DATE, :WS-PREV-BUSINESS-DAY) ) ))/7*7)+1
            INTO
              :WS-PREV-BUSINESS-DAY,
              :WS-WEEK-DAY-NO  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-PREV-BUSINESS-DAY =                                        
MFA-TR*           DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS                          
MFA-TR*         ,:WS-WEEK-DAY-NO    =                                           
MFA-TR*             (DAYS(DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS) -               
MFA-TR*              DAYS(DATE(:WS-PREV-BUSINESS-DAY) - 1 DAYS)/7*7)+1          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '**   PCSCA108 PROCESSING ERROR          **'      
              DISPLAY '**-------------------------------       **'      
              DISPLAY '**   7340-CHECK-WEEK-END:'                       
              DISPLAY '**   COULD NOT FIND PREV'                        
              DISPLAY '**   CALENDAR DAY'                               
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7340-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       7360-CHECK-HOLIDAY.                                              
      *================================================================*        
      *                                                                         
              EXEC SQL                                                  
                  SELECT 'Y'                                            
                  INTO   :WS-HOLIDAY-EXISTS-SW                          
                  FROM   CSS_HOLIDAY WITH(READUNCOMMITTED)                      
                  WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                         :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                    
                                                                 
                                                            
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           SELECT 'Y'                                                    
MFA-TR*           INTO   :WS-HOLIDAY-EXISTS-SW                                  
MFA-TR*           FROM   CSS_HOLIDAY                                            
MFA-TR*           WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                            
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7360                                                  
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************************************'           
               DISPLAY '**  PCSCA108  PROCESSING ERROR    **'           
               DISPLAY '**--------------------------------**'           
               DISPLAY '**   7360-CHECK-HOLIDAY:'                       
               DISPLAY '**   ERROR WHEN CHECKING TO SEE'                
               DISPLAY '**   IF THE PREV DAY IS A HOLIDAY'              
               DISPLAY '************************************'           
               PERFORM 9900-ABEND         THRU 9900-EXIT                
            END-IF.                                                     
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       7400-OPEN-ROUTE-SMART.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               OPEN ROUTE_SMART_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA109 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7400       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       7420-FETCH-ROUTE-SMART.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
             FETCH  ROUTE_SMART_CSR                                     
              INTO  :AT-ACCOUNT-NO                                      
                   ,:AT-PREMISE-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-READ-ROUTE                                      
                   ,:UT-READ-CYCLE                                      
                   ,:UT-COMPANY-NO                                      
                   ,:MN-CODE-METER-STATUS                               
                   ,:MN-REGISTER-RD-SEQ                                 
                   ,:MN-CODE-UTIL-TYPE                                  
                   ,:MN-MTR-REF-NO                                      
                   ,:MN-IC-NO                                           
                   ,:MN-REMOTE-READ-IND                                 
A#5470             ,:PR-PREM-REF-LATITUDE                               
A#5470             ,:PR-PREM-REF-LONGITUDE                              
                   ,:MN-GIS-POINT-ID                                    
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-SPCL-READ-INSTR                                 
ACT199             ,:PR-DATE-SPCL-MSG-ENDS :WS-DATE-MSG-NULL            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA108 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7420       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *================================================================*        
       7440-CLOSE-ROUTE-SMART.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               CLOSE  ROUTE_SMART_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA108 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7440       **'       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7440-EXIT.                                                       
           EXIT.                                                        
      ************************************************************              
      *  WHEN THE DATE OF DATE_SPCL_MSG_ENDS IS PREVIOUS TO      *              
      *  CURRENT DATE, MESSAGE AND DATE FIELDS ARE CLEARED ON    *              
      *  THE CSS_PREMISE_TABLE.                                  *              
      ************************************************************              
ACT199 7550-UPDATE-PREMISE.                                             
ACT199                                                                  
ACT199     EXEC SQL                                                     
ACT199          UPDATE CSS_PREMISE                                      
ACT199          SET DATE_SPCL_MSG_ENDS = NULL,                          
ACT199                 SPCL_READ_INSTR = :PR-SPCL-READ-INSTR            
ACT199          WHERE PREMISE_NO = :AT-PREMISE-NO                       
ACT199                                                      
ACT199     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_PREMISE                                              
MFA-TR*         SET DATE_SPCL_MSG_ENDS = NULL,                                  
MFA-TR*                SPCL_READ_INSTR = :PR-SPCL-READ-INSTR                    
MFA-TR*         WHERE PREMISE_NO = :AT-PREMISE-NO                               
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT199                                                                  
ACT199     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT199                                                                  
ACT199     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT199         CONTINUE                                                 
ACT199     ELSE                                                         
ACT199         DISPLAY '**************** PCSCA108 *****************'    
ACT199         DISPLAY '* 7550 : RETURN CODE ERROR - UPDATE'            
ACT199         DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
ACT199         DISPLAY '* PREMISE NO= ' AT-PREMISE-NO                   
ACT199         DISPLAY '**************** PCSCA108 *****************'    
ACT199         PERFORM 9900-ABEND                THRU 9900-EXIT         
ACT199     END-IF.                                                      
ACT199                                                                  
ACT199 7550-EXIT.                                                       
A04684*================================================================*        
A04684 7810-OPEN-GET-MTR.                                               
A04684*================================================================*        
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684         OPEN GET_MTR_CSR                                         
A04684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A04684*                                                                         
A04684     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A04684        CONTINUE                                                  
A04684     ELSE                                                         
A04684         DISPLAY '****************************************'       
A04684         DISPLAY '**     PCSCA109 PROCESSING ERROR      **'       
A04684         DISPLAY '**      ABEND IN PARAGRAPH 7810       **'       
A04684         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
A04684         DISPLAY '**        ACCOUNT NO = ' AT-ACCOUNT-NO          
A04684         DISPLAY '****************************************'       
A04684         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7810-EXIT.                                                       
A04684     EXIT.                                                        
A04684/                                                                         
A04684*================================================================*        
A04684 7820-FETCH-GET-MTR.                                              
A04684*================================================================*        
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684       FETCH  GET_MTR_CSR                                         
A04684        INTO  :MN-METER-NO                                        
A04684             ,:MN-CODE-UTIL-TYPE                                  
A04684             ,:MN-IC-NO                                           
A04684             ,:MN-MTR-READ-SOURCE-CD                              
A04684             ,:AT-COMPANY-NO                                      
A04684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A04684*                                                                         
A04684     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
A04684         CONTINUE                                                 
A04684     ELSE                                                         
A04684         DISPLAY '****************************************'       
A04684         DISPLAY '**     PCSCA108 PROCESSING ERROR      **'       
A04684         DISPLAY '**      ABEND IN PARAGRAPH 7820       **'       
A04684         DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
A04684         DISPLAY '**        ACCOUNT NO = ' AT-ACCOUNT-NO          
A04684         DISPLAY '****************************************'       
A04684         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7820-EXIT.                                                       
A04684     EXIT.                                                        
A04684/                                                                         
A04684*================================================================*        
A04684 7830-CLOSE-GET-MTR.                                              
A04684*================================================================*        
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684         CLOSE GET_MTR_CSR                                        
A04684     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A04684*                                                                         
A04684     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
A04684         CONTINUE                                                 
A04684     ELSE                                                         
A04684         DISPLAY '****************************************'       
A04684         DISPLAY '**     PCSCA108 PROCESSING ERROR      **'       
A04684         DISPLAY '**      ABEND IN PARAGRAPH 7830       **'       
A04684         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
A04684         DISPLAY '**        ACCOUNT NO = ' AT-ACCOUNT-NO          
A04684         DISPLAY '****************************************'       
A04684         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7830-EXIT.                                                       
A04684     EXIT.                                                        
A04684*================================================================*        
A04684 7840-GET-AROP-READ.                                              
A04684*================================================================*        
A04684*                                                                         
A04684     EXEC SQL                                                     
A04684         SELECT TOP(1) REG_READ_DT,
              REPLACE(CONVERT(CHAR(8), REG_READ_TM, 108), ':', '.') 
           REG_READ_TM,
              RAW_READING,
              TAMPER_CD_1,
              TAMPER_CD_2,
              DEVICE_NO                                         
A04684           INTO :3B-REG-READ-DT                                   
A04684               ,:3B-REG-READ-TM                                   
A04684               ,:3B-RAW-READING                                   
A04684               ,:3B-TAMPER-CD-1                                   
A04684               ,:3B-TAMPER-CD-2                                   
ACT002               ,:3B-DEVICE-NO                                     
A04684           FROM CSS_OFFCYCLE_READS WITH(READUNCOMMITTED)                  
A04684          WHERE ACCOUNT_NO     = :3B-ACCOUNT-NO                   
A04684            AND METER_NO       = :3B-METER-NO                     
A04684            AND CODE_UTIL_TYPE = :3B-CODE-UTIL-TYPE               
A04684            AND IC_NO          = :3B-IC-NO                        
A04684            AND COMPANY_NO     = :3B-COMPANY-NO                   
ACT018            AND REG_READ_DT   >= IIF(TRY_CONVERT(DATE, 
                                                      :WS-PREV-WORK-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-WORK-DAY
              ) <> 0) OR (LEN(:WS-PREV-WORK-DAY) <> 10), CIS.CHAR2DATE(
                                                      :WS-PREV-WORK-DAY
              ), CONVERT(DATE, :WS-PREV-WORK-DAY) )                
AA4684            ORDER BY REG_READ_DT DESC                             
AA4684                    ,REG_READ_TM DESC                             
A04684                                       
AA4684                                                      
A04684     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_READ_DT                                               
MFA-TR*              ,REG_READ_TM                                               
MFA-TR*              ,RAW_READING                                               
MFA-TR*              ,TAMPER_CD_1                                               
MFA-TR*              ,TAMPER_CD_2                                               
MFA-TR*              ,DEVICE_NO                                                 
MFA-TR*          INTO :3B-REG-READ-DT                                           
MFA-TR*              ,:3B-REG-READ-TM                                           
MFA-TR*              ,:3B-RAW-READING                                           
MFA-TR*              ,:3B-TAMPER-CD-1                                           
MFA-TR*              ,:3B-TAMPER-CD-2                                           
MFA-TR*              ,:3B-DEVICE-NO                                             
MFA-TR*          FROM CSS_OFFCYCLE_READS                                        
MFA-TR*         WHERE ACCOUNT_NO     = :3B-ACCOUNT-NO                           
MFA-TR*           AND METER_NO       = :3B-METER-NO                             
MFA-TR*           AND CODE_UTIL_TYPE = :3B-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO          = :3B-IC-NO                                
MFA-TR*           AND COMPANY_NO     = :3B-COMPANY-NO                           
MFA-TR*           AND REG_READ_DT   >= :WS-PREV-WORK-DAY                        
MFA-TR*           ORDER BY REG_READ_DT DESC                                     
MFA-TR*                   ,REG_READ_TM DESC                                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7840                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04684*                                                                         
A04684     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
A04684*                                                                         
A04684     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
A04684         CONTINUE                                                 
A04684     ELSE                                                         
A04684         DISPLAY '****************************************'       
A04684         DISPLAY '**     PCSCA108 PROCESSING ERROR      **'       
A04684         DISPLAY '**      ABEND IN PARAGRAPH 7840       **'       
A04684         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
A04684         DISPLAY '**      ACCOUNT_NO     = ' 3B-ACCOUNT-NO        
A04684         DISPLAY '**      METER_NO       = ' 3B-METER-NO          
A04684         DISPLAY '**      CODE_UTIL_TYPE = ' 3B-CODE-UTIL-TYPE    
A04684         DISPLAY '**      IC-NO          = ' 3B-IC-NO             
A04684         DISPLAY '**      COMPANY-NO     = ' 3B-COMPANY-NO        
A04684         DISPLAY '****************************************'       
A04684         PERFORM 9900-ABEND THRU 9900-EXIT                        
A04684     END-IF.                                                      
A04684*                                                                         
A04684 7840-EXIT.                                                       
A04684     EXIT.                                                        
Ab4684*                                                                         
Ab4684*================================================================*        
Ab4684 7900-GET-CURRENT-DATE.                                           
Ab4684*================================================================*        
Ab4684*                                                                         
Ab4684     EXEC SQL                                                     
Ab4684         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
Ab4684     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

Ab4684                                                                  
Ab4684     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
Ab4684*                                                                         
Ab4684     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
Ab4684         CONTINUE                                                 
Ab4684     ELSE                                                         
Ab4684         DISPLAY '****************************************'       
Ab4684         DISPLAY '**     PCSCA108 PROCESSING ERROR      **'       
Ab4684         DISPLAY '**       7900-GET-CURRENT-DATE        **'       
Ab4684         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
Ab4684         DISPLAY '****************************************'       
Ab4684         PERFORM 9900-ABEND THRU 9900-EXIT                        
Ab4684     END-IF.                                                      
Ab4684                                                                  
Ab4684 7900-EXIT.                                                       
Ab4684     EXIT.                                                        
                                                                        
      *================================================================*        
       8000-WRITE-FIOBW629.                                             
      *================================================================*        
      *                                                                         
           WRITE FIOBW629.                                              
      *                                                                         
           IF  FBW629-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '8950-ERROR ON FCSBE629 WRITE.  STATUS IS '      
                        WS-FBW629-STATUS                                
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /                                                                         
ACT002*================================================================*        
ACT002 8100-UPDT-OFFCYCLE.                                              
ACT002*================================================================*        
ACT002*                                                                         
ACT002     EXEC SQL                                                     
ACT002         UPDATE CSS_OFFCYCLE_READS                                
ACT002            SET READ_USED_FL    = 'Y'                             
ACT002          WHERE DEVICE_NO       = :3B-DEVICE-NO                   
ACT002            AND COMPANY_NO      = :3B-COMPANY-NO                  
ACT002            AND REG_READ_DT     = IIF(TRY_CONVERT(DATE, 
                                                        :3B-REG-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :3B-REG-READ-DT
              ) <> 0) OR (LEN(:3B-REG-READ-DT) <> 10), CIS.CHAR2DATE(
                                                        :3B-REG-READ-DT
              ), CONVERT(DATE, :3B-REG-READ-DT) )                 
ACT002            AND REG_READ_TM     = CIS.CHAR2TIME(:3B-REG-READ-TM)          
ACT002            AND CODE_UTIL_TYPE  = :3B-CODE-UTIL-TYPE              
ACT002     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_OFFCYCLE_READS                                        
MFA-TR*           SET READ_USED_FL    = 'Y'                                     
MFA-TR*         WHERE DEVICE_NO       = :3B-DEVICE-NO                           
MFA-TR*           AND COMPANY_NO      = :3B-COMPANY-NO                          
MFA-TR*           AND REG_READ_DT     = :3B-REG-READ-DT                         
MFA-TR*           AND REG_READ_TM     = :3B-REG-READ-TM                         
MFA-TR*           AND CODE_UTIL_TYPE  = :3B-CODE-UTIL-TYPE                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT002                                                                  
ACT002     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT002*                                                                         
ACT002     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
ACT002         CONTINUE                                                 
ACT002     ELSE                                                         
ACT002         DISPLAY '****************************************'       
ACT002         DISPLAY '**     PCSCA108 PROCESSING ERROR      **'       
ACT002         DISPLAY '**       8100-UPDATE-RENT-DATE        **'       
ACT002         DISPLAY '**   DEVICE-NO      : ' 3B-DEVICE-NO            
ACT002         DISPLAY '**   COMPANY-NO     : ' 3B-COMPANY-NO           
ACT002         DISPLAY '**   REG-READ-DT    : ' 3B-REG-READ-DT          
ACT002         DISPLAY '**   REG-READ-TM    : ' 3B-REG-READ-TM          
ACT002         DISPLAY '**   CODE-UTIL-TYPE : ' 3B-CODE-UTIL-TYPE       
ACT002         DISPLAY '**                                    **'       
ACT002         DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
ACT002         DISPLAY '****************************************'       
ACT002         PERFORM 9900-ABEND THRU 9900-EXIT                        
ACT002     END-IF.                                                      
ACT002                                                                  
ACT002 8100-EXIT.                                                       
ACT002     EXIT.                                                        
ACT002/                                                                         
      *================================================================*        
       8950-WRITE-FCSDB09.                                              
      *================================================================*        
      *                                                                         
      *                                                                         
           WRITE FIODB09.                                               
      *                                                                         
           IF FDB09-SUCCESSFUL                                          
               ADD 1                   TO WS-DB09-CTR                   
               ADD 1                   TO WS-COUNT-FCSDB09              
           ELSE                                                         
               DISPLAY '8950-ERROR ON FCSDB09 WRITE.  STATUS IS '       
                        WS-FDB09-STATUS                                 
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
           MOVE SPACES  TO  FIODB09.                                    
      *                                                                         
       8950-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
A04684*================================================================*        
A04684 8960-WRITE-FCSBW06.                                              
A04684*================================================================*        
A04684*                                                                         
A04684     WRITE FIOBW06.                                               
A04684*                                                                         
A04684     IF FBW06-SUCCESSFUL                                          
A04684         CONTINUE                                                 
A04684     ELSE                                                         
A04684         DISPLAY '8960-ERROR ON FCSBW06 WRITE.  STATUS IS '       
A04684                  WS-FBW06-STATUS                                 
A04684         PERFORM 9900-ABEND                THRU 9900-EXIT         
A04684     END-IF.                                                      
A04684*                                                                         
A04684     MOVE SPACES  TO  FIOBW06.                                    
A04684*                                                                         
A04684 8960-EXIT.                                                       
A04684     EXIT.                                                        
A04684/                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA108-FILE.                                         
           CLOSE FCSBW629-FILE.                                         
           CLOSE FCSDB09-FILE.                                          
AA4684     CLOSE FCSBW06-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
      *--------------------------------------------------------------*          
      *** 9700-PROCESS-ABEND                                         *          
      *  STANDARD ABEND COPYBOOK                                     *          
      *--------------------------------------------------------------*          
      /                                                                         
       COPY CPD0023B.                                                           
      /                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      /                                                                         
