       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA106.                                         
       DATE-WRITTEN.   AUG.1995.                                        
           DATE-COMPILED.                                               
      ****************************************************************  00052000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL              **  00060000
      **                                                            **  00110000
      ********            CUSTOMER SERVICE SYSTEM             ********  00120000
      ********                      DB2                       ********  00130000
      ****************************************************************  00140000
      **                                                            **  00150000
      **              PROGRAM  MODIFICATION  LOG                    **  00160000
      **                                                            **  00170000
      **   03/02/2000  CBSI    NEW PROGRAM TO ALLOW MEDICAL         **          
      **               MADRAS  CERTIFICATE TO BE EXPIRED PRIOR      **          
      **                       TO BILLING.                          **          
T22018**   04/03/2000  SS82048 USE COMMON AS PROGRAM NAME TO GET    **          
      **                       THE DATE FROM JOB-PARM               **          
      ****************************************************************  00445000
           REMARKS.                                                     
      * ------------------------------------------------------------ *  00460000
      * ------------------------------------------------------------ *  00590000
      *                                                                 00600000
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                          ---- PARAGRAPH STRUCTURE ----                 
      *                                                                 00740000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA106'.
MSQ017     COPY MFASQLM.
      *                                                                 00960000
       01  WS-MISCELLANEOUS.                                            
           05  WS-MED-CERT-EXPIRED    PIC X(01)      VALUE 'N'.         
COB305     05 WS-PREV-MED-CERT-ACC        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.         
           05  WS-CURRENT-DATE        PIC X(10).                        
           05  WS-N                   PIC X(01)      VALUE 'N'.         
           05  WS-Y                   PIC X(01)      VALUE 'Y'.         
           05  WS-PGRMNAME            PIC X(08)      VALUE 'PCSCA106'.  
      *                                                                 01234000
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE         PIC S9(04) COMP VALUE 0.          
           05  RS-RETURN-CODE-DISP    PIC +Z(04).                       
      *                                                                         
           EXEC SQL                                                     01553500
               INCLUDE CWS00039                                         01553600
           END-EXEC.                                                    01553700
      *                                                                 01553800
           EXEC SQL                                                     01553900
               INCLUDE CWS00038                                         01554000
           END-EXEC.                                                    01554100
      *                                                                 01554200
       COPY CWS00303.                                                   02264200
       COPY CWS00056.                                                           
       COPY CWS00010.                                                           
       COPY CWS09900.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                 02265000
           EXEC SQL                                                     02270000
               INCLUDE SQLCA                                            02280000
           END-EXEC.                                                    02290000
      *                                                                 02300000
      * DCLGEN FOR CSS_ACCOUNT                                          02301000
      *                                                                 02302000
           EXEC SQL                                                     02310000
               INCLUDE TBACCT                                           02320000
           END-EXEC.                                                    02330000
      *                                                                 02340000
      * DCLGEN FOR CSS_JOB_PARM                                         02661000
      *                                                                 02662000
           EXEC SQL                                                     02670000
               INCLUDE TBJBPARM                                         02680000
           END-EXEC.                                                    02690000
      *                                                                 02744000
      * DCLGEN FOR CSS_CUST_ALERT                                       02745000
      *                                                                 02746000
           EXEC SQL                                                     02750000
               INCLUDE TBCSTALT                                         02760000
           END-EXEC.                                                    02770000
      *                                                                 02780000
      *****************************************                         04060000
      * MED_CERT_CSR                                                    04070000
      *****************************************                         04090000
           EXEC SQL                                                     
               DECLARE MED_CERT_CSR CURSOR FOR                          
               SELECT  CA.ACCOUNT_NO,                                   
                       AT.CODES_DATA_PRESENT,                           
                       CA.DATE_EXPIRE                                   
               FROM   CSS_CUST_ALERT CA,                                
                      CSS_ACCOUNT AT                                    
               WHERE  CA.ACCOUNT_NO      = AT.ACCOUNT_NO                
                 AND  CIS.SUBSTR3((AT.CODES_DATA_PRESENT),24,1) = 'A'        
                 AND  CA.CODE_ALERT_TYPE = 'M'                          
               ORDER  BY CA.ACCOUNT_NO, CA.DATE_EXPIRE DESC             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     04100000
MFA-TR*        DECLARE MED_CERT_CSR CURSOR FOR                          04110000
MFA-TR*        SELECT  CA.ACCOUNT_NO,                                   04120000
MFA-TR*                AT.CODES_DATA_PRESENT,                                   
MFA-TR*                CA.DATE_EXPIRE                                           
MFA-TR*        FROM   CSS_CUST_ALERT CA,                                04140000
MFA-TR*               CSS_ACCOUNT AT                                    04150000
MFA-TR*        WHERE  CA.ACCOUNT_NO      = AT.ACCOUNT_NO                04170000
MFA-TR*          AND  SUBSTR((AT.CODES_DATA_PRESENT),24,1) = 'A'                
MFA-TR*          AND  CA.CODE_ALERT_TYPE = 'M'                          04171000
MFA-TR*        ORDER  BY CA.ACCOUNT_NO, CA.DATE_EXPIRE DESC                     
MFA-TR*    END-EXEC.                                                    04180000
      *                                                                 04190000
       PROCEDURE DIVISION.                                              
      ****************************************************************  04240000
      **                                                            **  04250000
      **  0000-MAINLINE                                             **  04260000
      **       CONTROLS THE MAIN PROCESS OF PROGRAM                 **  04270000
      **                                                            **  04280000
      ****************************************************************  04290000
       0000-MAINLINE.                                                   
      *                                                                 04320000
           PERFORM 0100-INITIALIZATION           THRU 0100-EXIT.        
           PERFORM 1000-MAIN-PROCESS             THRU 1000-EXIT.        
           PERFORM 9000-TERMINATE                THRU 9000-EXIT.        
      *                                                                 04430000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04460000
      ****************************************************************  04470000
      **                                                            **  04480000
      **  0100-INITIALIZATION                                       **  04490000
      **       COMMON INITIALIZATION ROUTINE                        **  04500000
      **                                                            **  04510000
      ****************************************************************  04520000
       0100-INITIALIZATION.                                             
      *                                                                 04560000
           PERFORM 6251-GET-FJC01-DATE              THRU 6251-EXIT.     
           IF COMMON-DATE-NEEDED                                        
T22018        MOVE 'COMMON  '                 TO WS-PGRMNAME            
T22018        MOVE SPACES                     TO WS-INPUT-AREA          
T22018        MOVE SPACES                     TO WS-INPUT-DATA-BREAKDOWN
T22018        PERFORM 6251-GET-FJC01-DATE     THRU 6251-EXIT            
T22018        MOVE 'PCSCA106'                 TO WS-PGRMNAME            
T22018*        PERFORM 6240-GET-FCA00-COMMON-DATE   THRU 6240-EXIT      04600000
T22018*        MOVE WS-FCA00-COMMON-DATE            TO WS-INPUT-DATE    04630000
           END-IF.                                                      
      *                                                                 04650000
           MOVE WS-INPUT-DATE                       TO WS-CURRENT-DATE. 
                                                                        
      *                                                                 04670100
      *                                                                 04810700
       0100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  05210000
      **  1000-MAIN-PROCESS                                         **  05220000
      ****************************************************************  05290000
       1000-MAIN-PROCESS.                                               
      *                                                                 05310000
           PERFORM 1700-CLEAR-MED-CERT           THRU 1700-EXIT.        
      *                                                                 05460000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08832000
      ****************************************************************  08833000
      **  1700-CLEAR-MED-CERT.                                      **  08840000
      **    CSS_CUST_ALERT TABLE IS FETCHED WHEN THE DATE-EXPIRE    **  08850000
      **    EQUALS THE HOLD DATE. THAT ROW IS PROCESSED TO SPACE    **  08860000
      **    OUT CODE-DISC-OK AND CODE-MEDICAL IN CODES-DATA-PRESENT **  08870000
      ****************************************************************  08880000
       1700-CLEAR-MED-CERT.                                             
      *                                                                 08900000
           PERFORM 7650-OPEN-MED-CERT           THRU 7650-EXIT.         
           PERFORM 7660-FETCH-MED-CERT          THRU 7660-EXIT.         
           MOVE ZEROES                          TO WS-PREV-MED-CERT-ACC.
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 1710-PROCESS-MED-CERT    THRU 1710-EXIT          
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
           END-IF.                                                      
      *                                                                 08970000
           PERFORM 7670-CLOSE-MED-CERT          THRU 7670-EXIT.         
      *                                                                 08990000
       1700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09020000
      ****************************************************************  09030000
      **  1710-PROCESS-MED-CERT.                                    **  09040000
      **    CODE-DISC-OK AND CODE-MEDICAL IN CODES-DATA-PRESENT ARE **  09050000
      **    SPACES AND THE ACCOUNT TABLE IS UPDATED.                **  09060000
      ****************************************************************  09070000
       1710-PROCESS-MED-CERT.                                           
      *                                                                 09090000
           IF  CA-DATE-EXPIRE > WS-CURRENT-DATE                         
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  CA-ACCOUNT-NO NOT = WS-PREV-MED-CERT-ACC             
                   MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT
      *                                                                 09092000
                   MOVE SPACES                  TO WS-CODE-MEDICAL      
                   MOVE WS-CODES-DATA-PRESENT   TO AT-CODES-DATA-PRESENT
      *                                                                 09111000
                   MOVE CA-ACCOUNT-NO           TO AT-ACCOUNT-NO        
                   PERFORM 7100-UPDATE-ACCOUNT  THRU 7100-EXIT          
               END-IF                                                   
           END-IF.                                                      
      *                                                                 09140000
           MOVE CA-ACCOUNT-NO                   TO WS-PREV-MED-CERT-ACC.
           PERFORM 7660-FETCH-MED-CERT          THRU 7660-EXIT.         
      *                                                                 09160000
       1710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11186900
      * PARAGRAPH 6240-GET-FCA00-COMMON-DATE IS IN CPD00040.            11187000
      *                                                                 11187100
       COPY CPD00040.                                                   11187200
      *                                                                 11187300
      * PARAGRAPH 6243-GET-FCA00-UTIL-TYPES IS IN CPD00043.             11187400
      *                                                                 11187500
       COPY CPD00043.                                                   11187600
      *                                                                 11187700
      * PARAGRAPH 6244-GET-FCA00-ALLOW-DATES IS IN CPD00044.            11187800
      *                                                                 11187900
       COPY CPD00044.                                                   11188000
      *                                                                 11188100
      * PARAGRAPH 6246-GET-FCA00-EXTRA-DATES IS IN CPD00046.            11188200
      *                                                                 11188300
       COPY CPD00046.                                                   11188400
      *                                                                 11188500
      * PARAGRAPH 6251-GET-FJC01-DATE IS IN CPD00037.                   11188600
      *                                                                 11188700
       COPY CPD00037.                                                   11188800
      *                                                                 11188900
      ****************************************************************  11810000
      **  7100-UPDATE-ACCOUNT                                       **  11820000
      **      ACCOUNT TABLE IS UPDATED WITH SPACES FOR MED CERT     **  11830000
      ****************************************************************  11840000
       7100-UPDATE-ACCOUNT.                                             
      *                                                                 11860000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                 SET CODES_DATA_PRESENT =  :AT-CODES-DATA-PRESENT       
               WHERE ACCOUNT_NO         =  :AT-ACCOUNT-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11930000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 11950000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** 7100 :  RETURN CODE ERROR - UPDATE '         
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '******************************************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 12050000
       7100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  17790000
      **  7650-OPEN-MED-CERT.                                       **  17800000
      **      OPEN THE CUSROR MED_CERT_CSR                          **  17810000
      **                                                            **  17820000
      ****************************************************************  17830000
       7650-OPEN-MED-CERT.                                              
      *                                                                 17850000
           EXEC SQL                                                     
               OPEN MED_CERT_CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17890000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 17910000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**************** PCSCA106 *****************'    
               DISPLAY '* 7650 : RETURN CODE ERROR - OPEN'              
               DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY '**************** PCSCA106 *****************'    
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 18010000
       7650-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18040000
      ****************************************************************  18050000
      **  7660-FETCH-MED-CERT                                       **  18060000
      **      FETCH THE CURSOR MED_CERT_CSR                         **  18070000
      **                                                            **  18080000
      ****************************************************************  18090000
       7660-FETCH-MED-CERT.                                             
      *                                                                 18110000
           EXEC SQL                                                     
               FETCH MED_CERT_CSR                                       
               INTO :CA-ACCOUNT-NO,                                     
                    :AT-CODES-DATA-PRESENT,                             
                    :CA-DATE-EXPIRE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18170000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 18190000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**************** PCSCA106 *****************'    
               DISPLAY '* 7660 : RETURN CODE ERROR - FETCH'             
               DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY '**************** PCSCA106 *****************'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18290000
       7660-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18320000
      ****************************************************************  18330000
      **  7670-CLOSE-MED-CERT                                       **  18340000
      **       CLOSE THE CURSOR MED_CERT_CSR                        **  18350000
      **                                                            **  18360000
      ****************************************************************  18370000
       7670-CLOSE-MED-CERT.                                             
      *                                                                 18390000
           EXEC SQL                                                     
                CLOSE MED_CERT_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18430000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                 18450000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**************** PCSCA106 *****************'    
               DISPLAY '* 7670 : RETURN CODE ERROR - CLOSE'             
               DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY '**************** PCSCA106 *****************'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 18550000
       7670-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19300000
      *                                                                 18960000
      * PARAGRAPH 7600-START-FCSJC01 IS IN CPD00038.                    18961000
      *                                                                 18962000
            EXEC SQL                                                    18970000
                 INCLUDE CPD00038                                       18980000
            END-EXEC.                                                   18990000
      *                                                                 19000000
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                     19001000
      *                                                                 19002000
            EXEC SQL                                                    19010000
                 INCLUDE CPD00039                                       19020000
            END-EXEC.                                                   19030000
      *                                                                 19040000
      ****************************************************************  19310900
      *  9000-PROCESS-EXIT.                                          *  19311000
      ****************************************************************  19311100
      *                                                                 19040000
       9000-TERMINATE.                                                  
                                                                        
            STOP RUN.                                                   
                                                                        
       9000-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************  19310900
      *  9700-PROCESS-ABEND.                                         *  19311000
      ****************************************************************  19311100
           EXEC SQL                                                     19311200
               INCLUDE CPD0023B                                         19311300
           END-EXEC.                                                    19311400
                                                                        
HPCCDM*    EJECT                                                        19311600
      *                                                                 19311700
      **************************************************************    19313800
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE   *    19313900
      * 9900-ABEND                                                 *    19314000
      **************************************************************    19314100
      *                                                                 19314200
           EXEC SQL                                                     19314300
               INCLUDE CPD09900                                         19314400
           END-EXEC.                                                    19314500
