       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA105.                                        
      ***************************************************************** 00000100
      **              SOUTH CAROLINA ELECTRIC & GAS                  ** 00000400
      **                     PRICE WATERHOUSE                        ** 00000500
      **                                                             ** 00000600
      **               CUSTOMER INFORMATION SYSTEM                   ** 00000700
      **                                                             ** 00000800
      ***************************************************************** 00000900
      **               P R O G R A M  S U M M A R Y                  ** 00001000
      **                                                             ** 00001100
      ** THIS PROGRAM WILL READ IN THE BE22 FLAT FILE FROM BILLING.  ** 00001400
      ** NON-CONSOLIDATED ACCOUNTS:                                  ** 00001500
      ** ~~~~~~~~~~~~~~~~                                            ** 00001500
      ** SLIDE-IN AND SLIDE-OUT WITH KEY BEING FORMATTED TO BE06 FMT.** 00001600
      ** MASTER ACCOUNTS:                                            ** 00001500
      ** ~~~~~~~~~~~~~~~~                                            ** 00001500
      ** THE MASTER ACCOUNT NUMBER IS WRITTEN INTO THE KEY OF        ** 00001500
      ** MASTER ACCOUNT RECORDS. RETRIEVES ALL THE SUB ACCOUNTS FROM ** 00001600
      ** CSS_HELD_BP_SUBS FOR THE MASTER ACCOUNT.                    ** 00001700
      ** SUB ACCOUNTS:                                               ** 00001500
      ** ~~~~~~~~~~~~~~~~                                            ** 00001500
      ** 1. IF THE SUB IS BILLED SAME DAY WITH MASTER THE RECORDS ARE** 00001800
      ** FORMATTED AND WRITTEN TO OUTPUT FILE.                       ** 00001900
      ** 2. IF SUBS COME BY ITSELF THE RECORDS ARE FORMATTED AND     ** 00001900
      ** WRITTEN TO OUTPUT FILE AND ALSO THEY ARE INSERTED TO        ** 00002000
      ** CSS_HELD_BP_SUBS TABLE.                                     ** 00002100
      ** 3. IF THE SUBS ARE CANCEL REBILL THE RECORDS ARE  WRITTEN   ** 00002100
      ** TO OUTPUT FILE AND ALSO DELETES THE EXISTING RECORDS FROM   ** 00002100
      ** CSS_HELD_BP_SUBS AND INSERT NEW RECORDS TO THE TABLE.       ** 00002100
      ***************************************************************** 00002200
      *                                                              ** 00002300
      *              PROGRAM  MODIFICATION  LOG                      ** 00002400
      *                                                              ** 00002500
      *    DATE     INITIALS  REASON                                 ** 00002600
      *    ----     --------  ------                                 ** 00002700
PRJ166**   08/09    RAJ       INITIAL VERSION.                       ** 00016220
A2119 **   03/10    BED       BUMP HELD BP SUB CURSOR TO 200 ROWS    ** 00016220
      **                      PERFORM BP FETCHES UNTIL FINISHED.     ** 00016220
A02034**  6 APR 2010 RF10596  ADD 'WITH UR' TO SELECT                ** 00016220
P00257**   05/10    RAJ       REVENUE REPORTING.                     ** 00016220
A02541**   06/10    SV        CONSOLIDATED SUB NOT TO SHOW TWO ROWS  **         
A02541**            ACT 001   ON MASTER BILL WHEN THE SUB IS CANCEL  **         
A02541**                      REBILLED ON SAME DAY MASTER IS BILLED  **         
A02541**   06/10    SV        DEAD HEADS TO UPDATE CORR_MAIL_STAT    **         
A02541**            ACT 002   ONLY JOB PARM IS SET TO HAVE PROCESS FLAG 00016220
A02541**                      AS Y FOR SCSCA165.                     ** 00016220
A03019**   01/11    SV ACT 6  INITIALIZE MU-MST-ACCT-NO.             **         
ACT044**   09/11    BD09555   PRODUCE LIST OF GENERATED UNIQUE IDS   **         
ACT044**   APPL 3019                                                 **         
P00496**   12/11    RAJ       INDUSTRIAL BILLING ENHANCEMENTS.       ** 00016220
P00599**   04/12    DMS       CREDIT SIMPLIFICATION.                 **         
A04494**   06/13    SV95326   FIX STATE AND FRANCHISE TAX RATE       **         
A04494**            ACT 035   DECIMALS CHANGE IN CWS1000B.           **         
      **                                                             **         
A04527** 14 OCT 2013 RF10596  REMOVE RATECHK COPYBOOK RELATED LOGIC  **         
A04860** 12/29/14   AS7C117   REPLACE CSS_WQ_ITEMS_MF WITH            *         
A04860**            ACT057    CSS_WQ_ITEMS.                           *         
A05462** 09/23/16   DB41297   REMOVE WQ THAT IS CREATED WHEN SUB      *         
ACT058**            ACT058    ACCOUNT NOT IN CSS-HELD-BP-SUBS TABLE   *         
      ***END***********************************************************         
      **                                                             **         
      ***END***********************************************************         
      **          ---- BASIC SEQUENCE STRUCTURE ----                 **         
      **                                                             **         
      **  0000         MODULE CONTROL                                **         
      **  0100 - 0999  INITIALIZATION (OPTIONAL)                     **         
      **  1000 - 1999  FUNCTIONAL CONTROL                            **         
      **  2000 - 4999  DETAIL LOGIC                                  **         
      **  5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES            **         
      **  6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)  **         
      **  7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.)**         
      **  8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC.)*         
      **                                                             **         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** BE22 IS THE MERGE OF BE00 AND BE01 BILLING FILES              00018100
       COPY CSSBE22.                                                            
                                                                        
      *** BE06 IS THE OUTPUT FILE                                       00018400
       COPY CSSBE06.                                                    00700002
                                                                        
      *** OMIT IS THE SKIP ACCOUNTS FILE FROM BILLPRINT                 00019000
       COPY CSSOMIT.                                                    00019100
                                                                        
      *** EMAIL IS THE LIST OF GENERATED UNIQUE IDS                     00019000
       COPY CSSEMAIL.                                                   00019100
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      *** BE22 IS THE MERGE OF BE00 AND BE01 BILLING FILES              00018100
       COPY CFDBE22.                                                            
       COPY FIOBE22.                                                            
                                                                        
      *** BE06 IS THE OUTPUT FILE                                       00018400
       COPY CFDBE06.                                                    00760002
       COPY FIOBE06.                                                    00770002
                                                                        
      *** OMIT IS THE SKIP ACCOUNTS FILE FROM BILLPRINT                 00019000
       COPY CFDOMIT.                                                    00021500
       COPY FIOOMIT.                                                    00021600
                                                                        
ACT044*** EMAILFL IS THE FILE OF GENERATED UNIQUE IDS TO BE EMAILED     00019000
ACT044 COPY CFDEMAIL.                                                   00021500
ACT044 COPY FIOEMAIL REPLACING REC-LEN BY 80.                           00021600
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ009  01 MSQ009-SQLCODE  PIC S9(9) COMP-4.
MSQ008  01 MSQ008-DEL-SUB-CSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-OCCUR-CSR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-MSTSUB  PIC S9(9) COMP-5.
MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA105'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SQL-VARIABLES.                                            
           05  WS-SQL-CURSOR-TEMP          PIC X(25).                   
           05  WS-SQL-CALL-TEMP            PIC X(3).                    
           05  WS-SQL-PARA-TEMP            PIC X(4).                    
                                                                        
       01  WS-OMIT-STATUS                  PIC  X(02) EXTERNAL.         
           88  OMIT-SUCCESSFUL                        VALUE '00'.       
           88  OMIT-READ-OK                           VALUE '00' '04'.  
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-FBE22-STATUS             PIC  X(02).                  
               88  FBE22-SUCCESSFUL                    VALUE ZERO.      
           05  WS-FBE06-STATUS             PIC  X(02).                  
               88  FBE06-SUCCESSFUL                    VALUE ZERO.      
ACT044     05  WS-EMAILFL-STATUS           PIC  X(02).                  
ACT044         88  EMAILFL-SUCCESSFUL                  VALUE ZERO.      
           05  WS-FCSBE22-ACCT-FLAG        PIC  X(01)  VALUE 'N'.       
               88  FCSBE22-ACCT-NO-CHANGED             VALUE 'Y'.       
           05  WS-FCSBE22-FLAG             PIC  X(01) VALUE 'N'.        
               88  END-OF-FCSBE22                     VALUE 'Y'.        
           05  WS-SCSCA-WQ-CREATED-SW      PIC X(01).                   
               88  WS-SCSCA-WQ-CREATED                VALUE 'Y'.        
           05  WS-BILLED-WITH-MSTR-SW      PIC X(01)  VALUE ' '.        
               88  BILLED-WITH-MASTER                 VALUE 'Y'.        
               88  SUB-ONLY-BILLED                    VALUE 'N'.        
           05  WS-TWO-MASTER-SWITCH        PIC X(01)   VALUE SPACE.     
               88  TWO-MASTERS                         VALUE 'Y'.       
           05  WS-BYPASS-ACCOUNT-SW        PIC X(01)   VALUE SPACE.     
               88  BYPASS-ACCT                         VALUE 'Y'.       
           05 WS-AT-FOUND-SW               PIC X(01)   VALUE 'N'.       
               88  HAVE-AT-RECORD                      VALUE 'Y'.       
           05 WS-INSERT-SW                 PIC X(01)   VALUE 'N'.       
               88  INSERT-ACCT                         VALUE 'Y'.       
           05 WS-DELETE-SW                 PIC X(01)   VALUE 'N'.       
               88  DELETE-ACCTS                        VALUE 'Y'.       
           05 WS-DEAD-HEAD-SW              PIC X(01)   VALUE 'N'.       
               88  NOT-DEAD-HEAD                       VALUE 'N'.       
               88  DEAD-HEAD                           VALUE 'Y'.       
           05 WS-SUB-ACCT-FOUND-SW         PIC X(01)   VALUE 'N'.       
               88  SUB-ACCT-FOUND                      VALUE 'Y'.       
A02541         88  SUB-ACCT-NOT-FOUND                  VALUE 'N'.       
           05 WS-SKIP-ACCT                 PIC X(01)   VALUE 'N'.       
               88  SKIP-ACCT                           VALUE 'Y'.       
           05 WS-UNIQ-GEN-SW               PIC X(01)   VALUE 'N'.       
               88  UNIQ-GENERATED                      VALUE 'Y'.       
                                                                        
       01  WS-CNTRS.                                                    
           05  WS-ACCOUNTS-READ            PIC 9(07)  VALUE ZERO.       
           05  WS-ACCTS-WRITTEN            PIC 9(07)  VALUE ZERO.       
           05  WS-RECORDS-READ             PIC 9(07)  VALUE ZERO.       
           05  WS-RECORDS-WRITTEN          PIC 9(07)  VALUE ZERO.       
           05  WS-ACCTS-FROM-TAB           PIC 9(07)  VALUE ZERO.       
           05  WS-RECS-FROM-TAB            PIC 9(07)  VALUE ZERO.       
           05  WS-DEADHEAD-CNTR            PIC 9(07)  VALUE ZERO.       
           05  WS-SKIP-CNTR                PIC 9(07)  VALUE ZERO.       
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-YES                      PIC  X(01) VALUE 'Y'.        
           05  WS-Y                        PIC  X(01) VALUE 'Y'.        
           05  WS-NO                       PIC  X(01) VALUE 'N'.        
           05  WS-N                        PIC  X(01) VALUE 'N'.        
           05  WS-PGRMNAME                 PIC  X(08) VALUE 'PCSCA105'. 
           05  SCSCA151                    PIC  X(08) VALUE 'SCSCA151'. 
           05  SCSCA165                    PIC  X(08) VALUE 'SCSCA165'. 
A04860     05  SCSCB077                    PIC  X(08) VALUE 'SCSCB077'. 
A04860     05  WS-INPUT-TS.                                             
A04860         10 WS-INPUT-DATE-PT         PIC  X(10).                  
A04860         10 WS-INPUT-TIME-PT         PIC  X(16)  VALUE            
A04860                                               '-00.00.00.000000'.
                                                                        
       01  WS-MISC.                                                     
           05  WS-DISPLAY-ACCOUNT          PIC 9(13).                   
           05  WS-PREVIOUS-ACCT-NO         PIC S9(13)  COMP-3 VALUE 0.  
           05  WS-PREV-ACCT-NO             PIC S9(13)  COMP-3 VALUE 0.  
           05  WS-PREV-BE22-ACCT-NO        PIC S9(13)  COMP-3 VALUE 0.  
           05  WS-PREV-SEQ-ACCT-NO         PIC S9(13)  COMP-3 VALUE 0.  
           05  WS-PREVIOUS-DATE-BILLED     PIC X(10)  VALUE SPACES.     
ACT044     05  WS-UNIQ-ID-SUB              PIC S9(5) COMP-3 VALUE +0.   
           05  WS-DISPLAY-OMIT-ACCTS       PIC -Z(2).                   
           05  WS-SCSCA-RETURN-CODE        PIC S9(4) COMP.              
           05  WS-REGULATED-CD-NUM         PIC 9(2) VALUE 0.            
           05  WS-MASTER-COUNT             PIC S9(5) COMP-3 VALUE +0.   
A02541     05  WS-HOLD-SUB-COUNT           PIC S9(5) COMP-3 VALUE +0.   
           05  WS-SUB-ROW-COUNT            PIC S9(9) USAGE COMP VALUE 0.
           05  WS-BYPASS-INFO              PIC X(45).                   
           05  WS-MISC-IDX                 PIC 9(09) COMP-3 VALUE 0.    
           05  WS-MISC-IDX-1               PIC 9(09) COMP-3 VALUE 0.    
           05  WS-NULL-IND                 PIC S9(04) COMP.             
           05  WS-HOLD-BE06-DATA           PIC  X(650) VALUE SPACES.    
           05  WS-BYPASS-MSG-LITERAL       PIC X(45)                    
                VALUE 'CONTACT BILL PRINT TEAM; ACCOUNT BYPASSED IN:'.  
           05  WS-INPUT-BE22-DATE.                                      
               10  WS-INPUT-RUN-YEAR       PIC 9(04).                   
               10  FILLER                  PIC X(01).                   
               10  WS-INPUT-RUN-MONTH      PIC 9(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-INPUT-RUN-DAY        PIC 9(02).                   
           05  PROGRAM-NAME                PIC X(08)   VALUE 'PCSCA105'.
           05  WS-DELETE-DATE-BILLED       PIC X(10) VALUE SPACES.      
COB305     05 WS-DELETE-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.           
           05  WS-NO-DATE-ON-BILL-MSG.                                  
               10  WS-NO-DATE-CAT-ID       PIC S9(04) COMP VALUE +137.  
               10  WS-NO-DATE-PRIORITY     PIC X(01)  VALUE 'N'.        
               10  WS-NO-DATE-ROUTE-CAT    PIC X(01)  VALUE '4'.        
               10  WS-NO-DATE-MSG-LEN      PIC S9(04) COMP VALUE +67.   
               10  WS-NO-DATE-MSG-TEXT     PIC X(90).                   
           05  WS-NO-DATE-INFO             PIC X(45).                   
           05  WS-NO-DATE-MSG-LITERAL      PIC X(25)                    
                VALUE 'NO DATE ON BILL HEADER : '.                      
           05  WS-PREV-MAX-DOB             PIC X(10) VALUE SPACES.      
           05  WS-SEQ-NO                   PIC S9(04) COMP VALUE 0.     
           05  WS-FIOBE06-HOLD-EREC        PIC  X(557).                 
           05  WS-FIOBE22-HOLD-REC         PIC  X(547).                 
A04494     05  WS-HOLD-FIOBE22             PIC  X(547).                 
A04494     05  WS-HOLD-FIOBE22-ED          REDEFINES WS-HOLD-FIOBE22.   
A04494         10 FILLER                   PIC X(375).                  
A04494         10 WS-FRANCHISE-TX-RATE-CALC-ED PIC S9V9(4) COMP-3.      
A04494         10 WS-STATE-TX-RATE-CALC-ED  PIC S9V9(4) COMP-3.         
A04494         10 FILLER                   PIC X(165).                  
           05  WS-DISPLAY-SCSCA            PIC X(08).                   
A02541     05  WS-CTRL-PARM-STR.                                        
A02541         10  FILLER                   PIC X(08).                  
A02541         10  WS-CONTROL-FLAG          PIC X(01).                  
                                                                        
       01  WS-AT-XX.                                                    
           05  FILLER                      PIC X(135).                  
           05  WS-AT-XX-BILL-COPIES        PIC S9(04)   COMP.           
           05  FILLER                      PIC X(185).                  
           05  WS-AT-XX-CODE-PRNT-BLL-MST  PIC X(01).                   
           05  FILLER                      PIC X(234).                  
                                                                        
       01  WS-CALLING-PARAGRAPH            PIC  X(04).                  
ACT044 01  WS-UNIQ-ID-GEN-TAB.                                          
ACT044     05  WS-UNIQ-ID-EMAIL-LINE  OCCURS 100.                       
ACT044         10  FILLER                  PIC  X(26).                  
ACT044         10  WS-UNIQ-ID-ACCT         PIC  9(13).                  
ACT044         10  FILLER                  PIC  X(6).                   
ACT044         10  WS-UNIQ-ID-GEN          PIC  X(9).                   
                                                                        
      *********************************************************         00048900
      *   WORKING STORAGE FOR BASIC WQ MESSAGE TEXT           *         00049100
      *********************************************************         00049300
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-DATABASE-EXCEPTION.                                   
               10  FILLER                 PIC S9(04) COMP VALUE +121.   
               10  FILLER                 PIC  X(01) VALUE 'N'.         
               10  FILLER                 PIC  X(01) VALUE '4'.         
               10  FILLER                 PIC S9(04) COMP VALUE +29.    
               10  FILLER                 PIC  X(30) VALUE              
                   'A DATABASE EXCEPTION OCCURRED'.                     
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  FILLER                  PIC S9(04) COMP VALUE +121.  
               10  FILLER                  PIC  X(01)  VALUE 'N'.       
               10  FILLER                  PIC  X(01)  VALUE '4'.       
               10  WS-MISC-MSG-LEN         PIC S9(04) COMP VALUE +60.   
               10  WS-MISC-MSG-TEXT        PIC  X(60).                  
                                                                        
       01  WS-WQ-MESSAGE-INFO.                                          
           05  WS-MESSAGE-PATTERN.                                      
               10  WS-WQ-CATEGORY-ID       PIC S9(04) COMP VALUE +121.  
               10  WS-WQ-PRIORITY          PIC  X(01)      VALUE 'N'.   
               10  WS-WQ-ROUTE-CATEGORY    PIC  X(01)      VALUE '4'.   
               10  WS-WQ-MESSAGE-LENGTH    PIC S9(04) COMP VALUE +53.   
               10  WS-WQ-MISSING-SUB.                                   
                   15 F                    PIC  X(09)      VALUE        
                      'SUB ACCT '.                                      
                   15  WS-WQ-SUB-ACCT      PIC  X(13).                  
                   15  F                   PIC  X(31)  VALUE            
                      ' NOT ON CSS-HELD-BP-SUBS TABLE'.                 
               10  WS-WQ-MESSAGE2-LENGTH   PIC S9(04) COMP VALUE +62.   
               10  WS-WQ-SUB-TWO-MSTRS.                                 
                   15 FILLER               PIC  X(09)  VALUE            
                      'SUB ACCT '.                                      
                   15 WS-WQ-SUB-ACCT-TEMP  PIC  X(13).                  
                   15 FILLER               PIC  X(38)  VALUE            
                      ' IS ON CSS_HELD_BP_SUBS WITH 2 MASTERS'.         
                                                                        
     *****************************************************************          
     ** HOST VARIABLE ARRAYS TO DO MULTI FETCH AND MULTI INSERT ON   *          
     ** CSS_HELD_BP_SUBS.                                            *          
     *****************************************************************          
                                                                        
       01 WS-HOLD-MST-SUB-HV.                                           
COB305    05 WS-SUB-ACCOUNT-HV        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 100 TIMES VALUE 0.   
                                                                        
       01 WS-SUB-REC-ROWS-HV               PIC S9(4) USAGE COMP VALUE 0.
       01 WS-HOLD-HELD-BPSUBS-HV.                                       
COB305     05 WS-SUB-ACCOUNT-NO-HV        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 32000 TIMES VALUE 0. 
           05 WS-DATE-BILLED-HV            PIC  X(10)                   
                                                    OCCURS 32000 TIMES. 
           05 WS-SEQ-NO-HV                 PIC S9(4) USAGE COMP         
                                                    OCCURS 32000 TIMES. 
COB305     05 WS-MST-ACCT-NO-HV        PIC S9(13)V USAGE COMP-3 
COB305       OCCURS 32000 TIMES VALUE 0. 
           05 WS-PULL-FL-HV                PIC X(1) OCCURS 32000 TIMES. 
           05 WS-OCC-DATA-HV                        OCCURS 32000 TIMES. 
               49 WS-OCC-DATA-LEN-HV       PIC S9(4) USAGE COMP SYNC.   
               49 WS-OCC-DATA-TEXT-HV      PIC X(650).                  
                                                                        
      *********************************************************                 
      *   TABLE TO HOLD THE MASTER ACCOUNTS BILLED.           *                 
      *********************************************************                 
       01 WS-MASTER-ACCTS-HOLD-TABLE.                                   
           05  WS-MASTER-ACCTS-TBL  OCCURS 0 TO 999999                  
               DEPENDING ON WS-MASTER-COUNT                             
               ASCENDING KEY WS-MASTER-ACCOUNT-NO                       
               INDEXED BY MASTER-IND.                                   
COB305         10 WS-MASTER-ACCOUNT-NO        PIC S9(13)V COMP-3 
COB305           VALUE 0.         
      *                                                                 00053200
A02541***************************************************************           
A02541*   TABLE TO HOLD SUB ACCOUNTS THAT BILLS ALONG WITH MASTER   *           
A02541***************************************************************           
A02541 01 WS-HOLD-SUB-ACCTS-TABLE.                                      
A02541    05 WS-HOLD-SUB-ACCT-TABLE OCCURS 0 TO 9999                    
A02541         DEPENDING ON WS-HOLD-SUB-COUNT                           
A02541         INDEXED BY WS-HOLD-SUB-INDX.                             
COB305        10 WS-HOLD-SUB-ACCOUNT        PIC S9(13)V USAGE COMP-3 
COB305          VALUE 0.    
      *********************************************************                 
      *   TABLE TO HOLD THE SUB ACCOUNTS TO INSERT WQ IF      *                 
      *   NOT AVAILABLE TO PRINT WITH MASTER.                 *                 
      *********************************************************                 
       01 WS-SUB-WQ-INDX                   PIC S9(5) COMP-3 VALUE +0.   
       01 WS-SUB-WQ-ACCTS-HOLD-TABLE.                                   
           05  WS-SUB-WQ-ACCTS-TBL  OCCURS 99999 TIMES.                 
COB305         10 WS-SUB-WQ-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.         
               10  WS-SUB-WQ-INS-STATUS    PIC  X(01).                  
      *                                                                 00053200
      *********************************************************                 
      *   TABLE TO HOLD SUBS FOR THE CURRENT MASTER PROCESSING*                 
      *********************************************************                 
       01 WS-SUB-COUNT                     PIC S9(5) COMP-3 VALUE +0.   
       01 WS-SUB-ACCTS-HOLD-TABLE.                                      
           05  WS-SUB-ACCTS-TBL  OCCURS 999999.                         
COB305         10 WS-SUB-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.         
      *                                                                 00053200
      *************************************************************             
      *   TABLE TO HOLD SUB RECORDS PULLED OUT OF CSS_HELD_BP_SUBS*             
      *************************************************************             
       01 WS-SUB-REC-ROWS                  PIC S9(4) USAGE COMP VALUE 0.
       01 WS-SUB-ACCTS-RECS-HOLD-TABLE.                                 
          05  WS-SUB-ACCTS-RECS-HOLD-TBL OCCURS 99999 TIMES.            
COB305        10 WS-SUB-REC-ACCOUNT-NO        PIC S9(13)V COMP-3 
COB305          VALUE 0.        
              10  WS-SUB-REC-DATE-BILLED    PIC X(10).                  
COB305        10 WS-SUB-REC-MST-ACT-NO        PIC S9(13)V USAGE COMP-3 
COB305          VALUE 0.   
              10  WS-SUB-REC-OCC-DATA.                                  
                   49 WS-OCC-DATA-LEN       PIC S9(4) USAGE COMP.       
                   49 WS-OCC-DATA-TEXT      PIC X(650).                 
      *                                                                 00053200
      *********************************************************                 
      *   FIOBE37 CONTAINS CWS10001 VARIABLES USED IN OTHER   *                 
      *   COPYBOOKS IN THIS PROGRAM                           *                 
      *********************************************************                 
       COPY FIOBE37.                                                            
      *********************************************************                 
      *      IO AREA FOR QSAM BILLING EXTRACT FILE            *                 
      *********************************************************                 
       COPY FIOBE00A.                                                   00053800
      *********************************************************                 
      *   FIOBE36 CONTAINS CWS10000 VARIABLES USED IN OTHER   *                 
      *   COPYBOOKS IN THIS PROGRAM                           *                 
      *********************************************************                 
       COPY FIOBE36.                                                            
      *********************************************************                 
      *   FIOBE38 CONTAINS CWS10000 VARIABLES USED IN OTHER   *                 
      *   COPYBOOKS IN THIS PROGRAM                           *                 
      *********************************************************                 
       COPY FIOBE38.                                                            
      *********************************************************                 
      *   INDEX TABLE ERROR MESSAGES FOR BE38                 *                 
      *********************************************************                 
       COPY CWS100B5.                                                           
      *********************************************************                 
      *   COMMON SUBROUTINE DATA                              *                 
      *********************************************************                 
       COPY CWS0024B.                                                   00054200
      *********************************************************                 
      *  WORKING STORAGE VALUES FOR THE TABLE IDS USED IN THE *                 
      *     BEXX FILES                                        *                 
      *********************************************************                 
       COPY CWS00050.                                                   00054500
      *********************************************************                 
      *  THIS COPY STATEMENT CONTAINS THE WORKING STORAGE TAB *         00030022
      *  LAYOUT FOR CUSTOMER BILL EXTRACT INFORMATION FCSBE00 *         00040022
      *********************************************************                 
       COPY CWS1000B.                                                   00054900
       COPY CWS1000A.                                                   00054900
      *********************************************************                 
      ** THIS COPY STATEMENT CONTAINS THE WORKING STORAGE TAB *         00040000
      ** LAYOUT FOR METERED INFORMATION AND USAGE HISTORY FOR *         00050000
      ** QSAM FILE FCSBE01.                                   *         00060000
      *********************************************************                 
       COPY CWS1001B.                                                   00054900
       COPY CWS1001A.                                                   00054900
      *********************************************************                 
      *  THIS COPY STATEMENT CONTAINS THE WORKING STORAGE TAB *                 
      *  LAYOUT FOR INDEX AND TABLE ERROR MESSAGES FOR        *                 
      *  QSAM FILE FCSBE37  -  USED BY COPYBOOK CPD00051      *                 
      *********************************************************                 
       COPY CWS100B6.                                                   00055600
      *********************************************************                 
      *  THIS COPY STATEMENT CONTAINS THE WORKING STORAGE TAB *                 
      *  LAYOUT FOR CUSTOMER BILL PRINT EXTRACT INFORMATION.  *                 
      *********************************************************                 
       COPY CWS10009.                                                   00054900
P00599***********************************************************               
P00599*  THIS COPY STATEMENT CONTAINS THE WORKING STORAGE TABLE *       00000400
P00599*  LAYOUT FOR CUSTOMER CREDIT DETAILS FOR A BILL.         *       00000500
P00599***********************************************************               
P00599 COPY CWS1000K.                                                           
      *********************************************************                 
      *COPYBOOK TO SUPPORT DB2 SQL ERROR CHECKING.            *                 
      *********************************************************                 
       COPY CWS00303.                                                   00055700
      *********************************************************                 
      * VARIABLES NEEDED FOR ACCOUNT SKIP PROCESSING.         *         00040022
      *********************************************************                 
       COPY CWSCA151.                                                           
      *********************************************************                 
      * COPYBOOK ADDED FOR ERROR HANDLING.                    *                 
      *********************************************************                 
       COPY CWS00010.                                                   02700000
      *********************************************************                 
      *  CWS09900  ABEND SWITCH COPYBOOK                      *       *         
      *********************************************************                 
       COPY CWS09900.                                                   02700000
      *********************************************************                 
      *                                                                         
      *********************************************************                 
      * COPYBOOK TO LOAD DATA TO WORKING STORAGE TABLES       *                 
      *********************************************************                 
       COPY CWSCA105.                                                   02046000
      *********************************************************                 
      ***  COPYBOOK FOR SCSCA165 PARAMETERS                                     
      *********************************************************                 
           EXEC SQL                                                             
               INCLUDE CWSCA165                                                 
           END-EXEC.                                                            
      *                                                                         
                                                                        
           EXEC SQL                                                     00056600
                INCLUDE SQLCA                                           00056700
           END-EXEC.                                                    00056800
                                                                        
      ***********************************************************               
      *   WORKING STORAGE SUPPLEMENTAL WQ TEXT                  *               
      ***********************************************************               
           EXEC SQL                                                     00056900
                INCLUDE CWS0070B                                        00057000
           END-EXEC.                                                    00057100
                                                                        
      ***********************************************************               
      * DCLGEN TABLE(CSS_DELINQUENCY)                           *               
      ***********************************************************               
           EXEC SQL                                                     00058700
                INCLUDE TBDELQ                                          00058800
           END-EXEC.                                                    00058900
                                                                        
      ***********************************************************               
      * DCLGEN TABLE(CSS_JOB_PARM)                              *               
      ***********************************************************               
           EXEC SQL                                                     00057800
                INCLUDE TBJBPARM                                        00057900
           END-EXEC.                                                    00058000
                                                                        
      ***********************************************************               
      * DCLGEN TABLE(CSS_MSTSUB_ACCT)                           *               
      ***********************************************************               
           EXEC SQL                                                     03190000
               INCLUDE TBMSTSUB                                         03200000
           END-EXEC.                                                    03210000
                                                                        
      ***********************************************************               
      * DCLGEN TABLE(CSS_HELD_BP_SUBS)                          *               
      ***********************************************************               
           EXEC SQL                                                     02970000
               INCLUDE TBHLDBPS                                         02980000
           END-EXEC.                                                    02990000
                                                                        
      ***********************************************************               
      * DCLGEN TABLE(CSS_CORR_MAIL_STAT)                        *               
      ***********************************************************               
             EXEC SQL                                                           
                 INCLUDE TBMAILST                                               
             END-EXEC.                                                          
A04860*                                                                         
A04860/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
A04860      EXEC SQL                                                            
A04860           INCLUDE CWS00077                                               
A04860      END-EXEC.                                                           
A04860*                                                                         
                                                                        
      ***********************************************************       03490000
      *  CURSOR TO FETCH SUB ACCOUNTS FOR THE MASTER            *       03500000
      ***********************************************************       03510000
                                                                        
           EXEC SQL                                                     
                DECLARE MSTSUB CURSOR WITH ROWSET POSITIONING FOR       
                SELECT SUB_ACCT_NO                                      
                FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                      
                WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                
              ORDER BY SUB_ACCT_NO                                      
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03020000
MFA-TR*         DECLARE MSTSUB CURSOR WITH ROWSET POSITIONING FOR       03031000
MFA-TR*         SELECT SUB_ACCT_NO                                      03040000
MFA-TR*         FROM CSS_MSTSUB_ACCT                                    03050000
MFA-TR*         WHERE MST_ACCT_NO      = :MU-MST-ACCT-NO                03060000
MFA-TR*       ORDER BY SUB_ACCT_NO                                              
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    03080000
                                                                        
      *********************************************************         03490000
      *  CURSOR TO FETCH ALL THE RECORDS FOR SUB ACCOUNT      *         03500000
      *  FROM CSS_HELD_BP_SUBS.                               *                 
      *********************************************************         03510000
                                                                        
           EXEC SQL                                                     
                DECLARE OCCUR-CSR CURSOR WITH ROWSET POSITIONING FOR    
                SELECT                                                  
                      DATE_BILLED,                                      
                      MST_ACCT_NO,                                      
                      OCC_DATA                                          
                FROM CSS_HELD_BP_SUBS WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO       = :HB-ACCOUNT-NO                 
                ORDER BY DATE_BILLED, SEQ_NO                            
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03160000
MFA-TR*         DECLARE OCCUR-CSR CURSOR WITH ROWSET POSITIONING FOR    03171000
MFA-TR*         SELECT                                                  03180000
MFA-TR*               DATE_BILLED,                                      03190000
MFA-TR*               MST_ACCT_NO,                                      03200000
MFA-TR*               OCC_DATA                                          03210000
MFA-TR*         FROM CSS_HELD_BP_SUBS                                   03220000
MFA-TR*         WHERE ACCOUNT_NO       = :HB-ACCOUNT-NO                 03230000
MFA-TR*         ORDER BY DATE_BILLED, SEQ_NO                            03250000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    03260000
                                                                        
      *********************************************************         03490000
      *  CURSOR TO DELEL ALL THE RECORDS FOR SUB ACCOUNTS THAT*         03500000
      *  HAVE PULL FLAG AS D.                                 *         03500000
      *********************************************************         03510000
                                                                        
           EXEC SQL                                                     
                DECLARE DEL-SUB-CSR CURSOR WITH ROWSET POSITIONING FOR  
                SELECT                                                  
                      ACCOUNT_NO,                                       
                      MST_ACCT_NO,                                      
                      DATE_BILLED,                                      
                      OCC_DATA                                          
                FROM CSS_HELD_BP_SUBS WITH(READUNCOMMITTED)                     
                WHERE PULL_FL      = 'D'                                
                ORDER BY ACCOUNT_NO, DATE_BILLED, SEQ_NO                
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03380000
MFA-TR*         DECLARE DEL-SUB-CSR CURSOR WITH ROWSET POSITIONING FOR  03391000
MFA-TR*         SELECT                                                  03400000
MFA-TR*               ACCOUNT_NO,                                       03410000
MFA-TR*               MST_ACCT_NO,                                      03420000
MFA-TR*               DATE_BILLED,                                      03430000
MFA-TR*               OCC_DATA                                          03440000
MFA-TR*         FROM CSS_HELD_BP_SUBS                                   03450000
MFA-TR*         WHERE PULL_FL      = 'D'                                03460000
MFA-TR*         ORDER BY ACCOUNT_NO, DATE_BILLED, SEQ_NO                03470000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    03480000
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           03  WS-PARMVAL-LENGTH            PIC S9(04) COMP.            
           03  WS-WQ-INS-SW                 PIC X(01).                  
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          

SCA006        SET WS-BILL-WQ-INDX TO 1.
                                                                        
      ***************************************************************** 00065400
      *    0000-MAINLINE                                             ** 00065500
      ***************************************************************** 00065700
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION         THRU 0100-EXIT.          
                                                                        
           PERFORM 5000-CALL-SKIP-ACCTS        THRU 5000-EXIT.          
                                                                        
           PERFORM 1000-PROCESS-BEGIN-REC      THRU 1000-EXIT.          
                                                                        
           PERFORM 1100-PROCESS-ACCOUNTS       THRU 1100-EXIT           
             UNTIL END-OF-FCSBE22.                                      
                                                                        
A02541*** GET ALL SUBS FOR THE MASTER ACCOUNTS BILLED                           
A02541     PERFORM 2050-GET-ALL-SUBS           THRU 2050-EXIT.          
A02541                                                                  
           PERFORM 2700-DELETE-SUBS            THRU 2700-EXIT.          
                                                                        
ACT044     IF WS-UNIQ-ID-SUB > 0                                        
ACT044        PERFORM 3100-EMAIL-LIST          THRU 3100-EXIT           
ACT044     END-IF.                                                      
                                                                        
           PERFORM 2900-WRITE-END-CONTROLS     THRU 2900-EXIT.          
                                                                        
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00072100
      *    0100-INITIALIZATION                                       ** 00072200
      *    OPEN FILES                                                ** 00072300
      ***************************************************************** 00072500
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSBE22-FILE.                                     
           IF NOT FBE22-SUCCESSFUL                                      
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSBE22'                     
               DISPLAY '**   FILE STATUS = ' WS-FBE22-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSBE06-FILE.                                    
           IF FBE06-SUCCESSFUL                                          
               INITIALIZE FIOBE06                                       
           ELSE                                                         
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZE                  '         
               DISPLAY '**   ERROR OPENING FCSBE06'                     
               DISPLAY '**   FILE STATUS = ' WS-FBE06-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
ACT044     OPEN OUTPUT EMAILFL.                                         
ACT044     IF EMAILFL-SUCCESSFUL                                        
ACT044         INITIALIZE EMAILFL-REC                                   
ACT044     ELSE                                                         
ACT044         DISPLAY '**************************************'         
ACT044         DISPLAY '**   0100-INITIALIZE                  '         
ACT044         DISPLAY '**   ERROR OPENING EMAILFL'                     
ACT044         DISPLAY '**   FILE STATUS = ' WS-EMAILFL-STATUS          
ACT044         DISPLAY '**************************************'         
ACT044         PERFORM 9900-ABEND             THRU 9900-EXIT            
ACT044     END-IF.                                                      
                                                                        
           MOVE WS-YES                TO WS-CA151-FIRST-CALL-SW.        
                                                                        
           INITIALIZE                    WS-CA151-TOT-ACCTS-OMITTED     
                                         WS-SUB-WQ-ACCTS-HOLD-TABLE     
                                         WS-SCSCA-WQ-CREATED-SW         
                                         WS-INSERT-SW                   
A03019                                   MU-MST-ACCT-NO                 
ACT044                                   WS-UNIQ-ID-GEN-TAB             
                                         WS-UNIQ-GEN-SW.                
A02541     MOVE HIGH-VALUES           TO WS-HOLD-SUB-ACCTS-TABLE.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  00122600
      * INITIALIZE BE38 VARIABLES : 0639-                            *  00126700
      ****************************************************************  00123100
       COPY CPD0052B.                                                   00126800
                                                                        
      ****************************************************************  00122600
      * INITIALIZE BE37 VARIABLES : 0640-                            *  00126400
      ****************************************************************  00123100
       COPY CPD0049B.                                                   00126500
                                                                        
      ****************************************************************          
      *   0690-INITIALIZE-FBE38-WS-AREA                              *          
      ****************************************************************          
       COPY CPD0101C.                                                           
                                                                        
      * LOAD BE38 VARIABLES BY TABLE ID                                 00127300
       COPY CPD0050B.                                                   00127400
                                                                        
      * LOAD BE37 VARIABLES BY TABLE ID                                 00127600
       COPY CPD0051B.                                                   00127700
                                                                        
      * LOAD BE38 BILL PRINT CWS10009 VARIABLES BY TABLE ID             00127900
       COPY CPD0102C.                                                   00128000
                                                                        
      ****************************************************************  00122600
      ** 1000-PROCESS-BEGIN-REC                                     **  00122700
      ** THIS PROCESS IS CALLED TO DO AN INITIAL READ OF THE BE22   **  00122800
      ** TO SEE IF IT IS EMPTY OR IF THE FIRST RECORD IS            **  00122900
      ** NOT A CONTROL RECORD.                                      **  00123000
      ****************************************************************  00123100
                                                                        
       1000-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7000-READ-FCSBE22           THRU 7000-EXIT.          
                                                                        
           IF END-OF-FCSBE22                                            
              DISPLAY '** PCSCA105 PROCESSING ERROR  **'                
              DISPLAY '**   FCSBE22 FILE IS EMPTY    **'                
              DISPLAY '**   PROCESSING TERMINATED    **'                
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           IF E-FBE22-KEY-BREC EQUAL LOW-VALUES                         
               MOVE ZERO                       TO E-FBE22-DB-PART-BREC  
               MOVE FIOBE22-DATA-REC           TO FIOBE06-DATA-REC      
               MOVE E-FBE22-CREATE-DATE-BREC   TO WS-INPUT-BE22-DATE    
               PERFORM 8900-WRITE-FCSBE06      THRU 8900-EXIT           
               SUBTRACT 1                      FROM WS-RECORDS-WRITTEN  
           ELSE                                                         
              DISPLAY '*********PCSCA105 PROCESSING ERROR *********'    
              DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'    
              DISPLAY '**         PROCESSING TERMINATED          **'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
   ******FLIP THRU THE INPUT FILE UNTIL PASSING THE BEGIN RECORDS       00126000
                                                                        
           PERFORM UNTIL E-FBE22-KEY-BREC > LOW-VALUES                  
               SUBTRACT 1                      FROM WS-RECORDS-READ     
               PERFORM 7000-READ-FCSBE22       THRU 7000-EXIT           
               IF END-OF-FCSBE22                                        
                  DISPLAY '**************************************'      
                  DISPLAY '**   0000-MAINLINE                    '      
                  DISPLAY '**   ERROR READING FCSBE22'                  
                  DISPLAY '**   NO RECORDS PAST BEGINNING CONTROL'      
                  DISPLAY '**************************************'      
                  PERFORM 9900-ABEND           THRU 9900-EXIT           
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
   ******GET WHICH DATABASE WE ARE DEALING WITH                         00126000
                                                                        
           MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
           MOVE E-FBE22-COMPANY-NO             TO C8-COMPANY-NO.        
           PERFORM 7100-GET-DATABASE           THRU 7100-EXIT.          
           MOVE C8-DELINQ-VALUE                TO LS-DATABASE.          
                                                                        
           MOVE WS-NO                         TO WS-CA151-FIRST-CALL-SW.
A02541     PERFORM 7150-GET-PROCESS-FLAG       THRU 7150-EXIT.          
                                                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    1100-PROCESS-ACCOUNTS.                                       00128300
      * THIS WILL LOAD THE ACCOUNTS AND CHECK IF THE ACCT NEEDS TO   ** 00128400
      * BE SKIPPED FROM PROCESSING.                                  ** 00128500
      ***************************************************************** 00128700
                                                                        
       1100-PROCESS-ACCOUNTS.                                           
                                                                        
           PERFORM 2000-LOAD-ACCOUNT           THRU 2000-EXIT.          
                                                                        
           ADD 1                               TO WS-ACCOUNTS-READ.     
                                                                        
           MOVE 'N'                            TO WS-INSERT-SW.         
                                                                        
           IF ACCTS-TO-PROCESS                                          
              MOVE WS-N                        TO                       
                                            WS-CA151-OMIT-ACCOUNT-FL    
              MOVE WS-ACCOUNT-NO-AT            TO WS-CA151-INPUT-ACCOUNT
              PERFORM 5000-CALL-SKIP-ACCTS     THRU 5000-EXIT           
              IF WS-CA151-OMIT-ACCOUNT-FL = WS-Y                        
                 ADD  +1                       TO WS-SKIP-CNTR          
                 MOVE 'Y'                      TO WS-SKIP-ACCT          
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF NOT SKIP-ACCT                                             
      ****CHECK IF THE ACCOUNT HAS UNIQUE IDENTIFIER GENERATED                  
              IF WS-BARCODE-UNIQUE-ID-MW EQUAL TO SPACES                
                 MOVE  'L'                        TO                    
                                             WS-CA165IN-TP-MEMO-PROCESS 
                 PERFORM 3000-GET-UNIQ-IDENT    THRU 3000-EXIT          
ACT044           DISPLAY 'PCSCA105 UNIQUE IDENTIFER '                   
ACT044               WS-CA165OUT-UNIQ-ID ' CREATED FOR ACCOUNT '        
ACT044               WS-ACCOUNT-NO-AT                                   
ACT044           ADD +1 TO WS-UNIQ-ID-SUB                               
ACT044           IF WS-UNIQ-ID-SUB < 101                                
ACT044               MOVE WS-CA165OUT-UNIQ-ID     TO                    
ACT044                   WS-UNIQ-ID-GEN  (WS-UNIQ-ID-SUB)               
ACT044               MOVE WS-ACCOUNT-NO-AT        TO                    
ACT044                   WS-UNIQ-ID-ACCT (WS-UNIQ-ID-SUB)               
ACT044            END-IF                                                
              END-IF                                                    
              PERFORM 1150-DETAIL-PROCESSING    THRU 1150-EXIT          
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    1150-DETAIL-PROCESSING.                                   ** 00128300
      * THIS WILL CONTROL THE PROCESS OF GOING THROUGH THE FILES     ** 00128400
      * AND DECIDE WHAT PROCESSING NEEDS TO BE DONE FOR AN ACCOUNT.  ** 00128500
      ***************************************************************** 00128700
                                                                        
       1150-DETAIL-PROCESSING.                                          
                                                                        
           MOVE WS-ACCOUNT-NO-AT               TO WS-DISPLAY-ACCOUNT.   
           DISPLAY ' ACCOUNT: ', WS-DISPLAY-ACCOUNT.                    
   ****CHECK WHETHER THE ACCOUNT IS A DEADHEAD ACCOUNT                          
           MOVE 'N'                            TO WS-DEAD-HEAD-SW.      
A02541     IF WS-ACCOUNT-TYPE-CODE-AT = 'D'                             
              ADD 1                           TO WS-DEADHEAD-CNTR       
              MOVE 'Y'                        TO WS-DEAD-HEAD-SW        
           END-IF.                                                      
      *                                                                 00068800
   ****IF DEADHEAD ACCOUNT SKIP PROCESSING THE ACCOUNT AND UPDATE THE   00068800
   ****TRACKING STATUS IN CSS_CORR_MAIL_STAT TO DH                      00068800
A02541     IF DEAD-HEAD AND WS-CONTROL-FLAG = 'Y'                       
              MOVE 'ED'                     TO WS-TRACKING-STATUS-CD-MW 
              PERFORM 8930-UPDATE-CORR-MAIL-STAT THRU 8930-EXIT         
           END-IF.                                                      
                                                                        
   ****IF NOT DEADHEAD PROCESS BASED ON WS-MST-SUB-ACCT-IND-AT          00068800
                                                                        
   ****MASTER ACCOUNTS WILL BE WRITTEN TO OUTPUT FILE AND PULL ALL ITS  00068800
   ****SUBS FROM CSS_HELD_BP_SUBS.                                      00068800
                                                                        
   ****SUB ACCOUNTS WHEN IT COMES WITH ITS MASTER GETS WRITTEN TO THE   00068800
   ****OUTPUT FILE AND WHEN IT COMES BY ITSELF GETS WRITTEN TO OUTPUT   00068800
   ****FILE FOR IMAGING AND ALSO GETS INSERTED TO CSS_HELD_BP_SUBS.             
                                                                        
   ****ALL OTHER ACCOUNTS ARE WRITTEN TO THE OUTPUT FILE.               00068800
                                                                        
           IF NOT-DEAD-HEAD                                             
              EVALUATE WS-MST-SUB-ACCT-IND-AT                           
                  WHEN 'M'                                              
                       ADD 1                   TO WS-MASTER-COUNT       
                       MOVE WS-ACCOUNT-NO-AT   TO                       
                                  WS-MASTER-ACCOUNT-NO (WS-MASTER-COUNT)
                       PERFORM 8000-WRITE-CWS-VALUES    THRU 8000-EXIT  
A02541*                MOVE FIOBE22            TO WS-FIOBE22-HOLD-REC           
A02541*                PERFORM 2100-GET-SUBS            THRU 2100-EXIT  03660000
A02541*                MOVE WS-FIOBE22-HOLD-REC         TO FIOBE22              
                                                                        
                  WHEN 'S'                                              
                       MOVE 'N'                  TO WS-BYPASS-ACCOUNT-SW
                                                          WS-AT-FOUND-SW
                                                          WS-INSERT-SW  
                       INITIALIZE                         WS-SEQ-NO     
                       PERFORM 2400-CHECK-DATE-BILLED   THRU 2400-EXIT  
                       IF NOT BYPASS-ACCT                               
                          PERFORM 2500-SUB-ACCT-PROCESS THRU 2500-EXIT  
                       END-IF                                           
                  WHEN OTHER                                            
                       PERFORM 8000-WRITE-CWS-VALUES    THRU 8000-EXIT  
              END-EVALUATE                                              
           END-IF.                                                      
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 00128700
      *    2000-LOAD-ACCOUNT.                                        ** 00128300
      * READS THE DATA FROM INPUT FILE AND LOADS TO WORKING STORAGE  ** 00128400
      * TABLES.                                                      ** 00128500
      ***************************************************************** 00128700
                                                                        
       2000-LOAD-ACCOUNT.                                               
                                                                        
           MOVE E-FBE22-ACCOUNT-NO          TO WS-PREV-BE22-ACCT-NO.    
                                                                        
           PERFORM 0609-INITIALIZE-FBE36-WS-AREA THRU 0609-EXIT.        
                                                                        
           PERFORM 0640-INITIALIZE-FBE37-WS-AREA THRU 0640-EXIT.        
                                                                        
           PERFORM 0690-INITIALIZE-FBE38-WS-AREA THRU 0690-EXIT.        
                                                                        
      * READ FROM THE BE22 FILE FOR ALL RECORDS FOR THIS ACCOUNT.       00152100
           PERFORM UNTIL END-OF-FCSBE22 OR                              
              E-FBE22-ACCOUNT-NO NOT = WS-PREV-BE22-ACCT-NO             
                  MOVE E-FBE22-DATA         TO E-FBE38-DATA             
                  MOVE E-FBE22-COMPANY-NO   TO E-FBE38-COMPANY-NO       
                  MOVE E-FBE22-LOCAL-OFFICE TO E-FBE38-LOCAL-OFFICE     
                  MOVE E-FBE22-ACCOUNT-NO   TO E-FBE38-ACCOUNT-NO       
                  MOVE E-FBE22-TABLE-ID     TO E-FBE38-TABLE-ID         
                  MOVE E-FBE22-PREMISE-NO   TO E-FBE38-PREMISE-NO       
                  MOVE E-FBE22-MST-ACCT-NO  TO E-FBE38-MST-ACCT-NO      
                  MOVE E-FBE22-MST-SUB-IND  TO E-FBE38-MST-SUB-IND      
                  MOVE E-FBE22-SORT-KEY TO E-FBE37-SORT-KEY             
                  MOVE E-FBE22-TABLE-ID TO WS-CWS-TABLE-ID              
                  IF WS-CWS10000-TABLE-ID                               
                     PERFORM 0800-LOAD-FBE38-WS-AREA THRU 0800-EXIT     
                  END-IF                                                
                  IF WS-CWS10001-TABLE-ID                               
                     MOVE E-FBE38-SORT-KEY   TO E-FBE37-SORT-KEY        
                     MOVE E-FBE38-DATA(1:250) TO E-FBE37-DATA           
                     PERFORM 0850-LOAD-FBE37-WS-AREA THRU 0850-EXIT     
                  END-IF                                                
                  IF WS-CWS10009-TABLE-ID                               
                     PERFORM 0880-LOAD-FBE38-WS-AREA THRU 0880-EXIT     
                  END-IF                                                
                  PERFORM 7000-READ-FCSBE22          THRU 7000-EXIT     
           END-PERFORM.                                                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02541***************************************************************** 04670000
A02541*    2050-GET-ALL-SUBS.                                        ** 00235000
A02541* DOWNLOAD ALL THE SUBS FROM CSS_HELD_BP_SUBS FOR THE MASTER   ** 00235100
A02541***************************************************************** 04680000
A02541 2050-GET-ALL-SUBS.                                               
A02541                                                                  
A02541     PERFORM VARYING MASTER-IND FROM 1 BY 1 UNTIL                 
A02541       MASTER-IND > WS-MASTER-COUNT                               
A02541         MOVE WS-MASTER-ACCOUNT-NO(MASTER-IND) TO WS-ACCOUNT-NO-AT
A02541         INITIALIZE WS-SUB-REC-ROWS-HV                            
A02541         MOVE 'N'                              TO WS-INSERT-SW    
A02541         PERFORM 2100-GET-SUBS         THRU 2100-EXIT             
A02541     END-PERFORM.                                                 
A02541                                                                  
A02541 2050-EXIT.                                                       
A02541     EXIT.                                                        
A02541                                                                  
      ***************************************************************** 04670000
      *    2100-GET-SUBS.                                            ** 00235000
      * DOWNLOAD ALL THE SUBS FROM CSS_HELD_BP_SUBS FOR THE MASTER.  ** 00235100
      ***************************************************************** 04680000
       2100-GET-SUBS.                                                   
                                                                        
           MOVE WS-ACCOUNT-NO-AT               TO MU-MST-ACCT-NO        
                                                  WS-PREVIOUS-ACCT-NO.  
   ****PULL ALL THE SUB ACCOUNTS FOR THE MASTER FROM CSS_MSTSUB_ACCT.   04730000
           INITIALIZE WS-SUB-ACCTS-HOLD-TABLE.                          
           MOVE ZERO                             TO WS-SUB-COUNT.       
           PERFORM 7200-OPEN-MSTSUB-CURSOR     THRU 7200-EXIT.          
                                                                        
           PERFORM 7210-FETCH-MSTSUB-CURSOR    THRU 7210-EXIT           
                            UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.    
                                                                        
           PERFORM 7220-CLOSE-MSTSUB-CURSOR    THRU 7220-EXIT.          
                                                                        
   ****FOR ALL THE SUB ACCOUNTS FOR THE MASTER PULL THE RECORDS FROM    04730000
   ****CSS_HELD_BP_SUBS.                                                04730000
           PERFORM VARYING WS-MISC-IDX FROM 1 BY 1                      
                     UNTIL WS-SUB-ACCOUNT-NO(WS-MISC-IDX) = ZEROES      
                MOVE WS-SUB-ACCOUNT-NO(WS-MISC-IDX) TO  HB-ACCOUNT-NO   
                PERFORM 2200-GET-OCCURRENCES     THRU 2200-EXIT         
           END-PERFORM.                                                 
                                                                        
      *                                                                 00100100
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-GET-OCCURRENCES.                                            
                                                                        
           INITIALIZE WS-SUB-ACCTS-RECS-HOLD-TABLE                      
                      WS-SUB-REC-ROWS.                                  
                                                                        
           MOVE 'N'                            TO WS-TWO-MASTER-SWITCH. 
                                                                        
                                                                        
           PERFORM 7400-OPEN-OCCUR-CSR         THRU 7400-EXIT.          
                                                                        
           PERFORM 7410-FETCH-OCCURRENCES      THRU 7410-EXIT           
A2119         UNTIL WS-ACTIVE-RETURN-CODE NOT = 0.                      
           PERFORM 7420-CLOSE-OCCURRENCES      THRU 7420-EXIT.          
                                                                        
A02541** IF SUB ACCOUNTS ARE FETCHED FROM CSS_HELD_BP_SUBS, LOAD THE            
A02541** THE DATA TO OUTPUT FILE. IF SUBS ARE NOT FOUND FROM TABLE              
A02541** CHECK IF THE SUB CAME ALONG WITH ITS MASTER, IF SO IGNORE IT           
A02541** AS THE SUB WAS WRITTEN TO OUTPUT ALREADY. IF THE SUB DID NOT           
A02541** COME ALONG WITH ITS MASTER WRITE A WQ.                                 
           IF WS-SUB-REC-ROWS > 0                                       
              MOVE +1                          TO WS-MISC-IDX-1         
              MOVE WS-SUB-REC-DATE-BILLED(WS-MISC-IDX-1) TO             
                                                 HB-DATE-BILLED         
              MOVE WS-SUB-REC-MST-ACT-NO(WS-MISC-IDX-1)  TO             
                                                 HB-MST-ACCT-NO         
              MOVE WS-SUB-REC-OCC-DATA (WS-MISC-IDX-1)   TO             
                                                 HB-OCC-DATA            
              PERFORM 2300-LOAD-TO-WS          THRU 2300-EXIT UNTIL     
                                        WS-MISC-IDX-1 > WS-SUB-REC-ROWS 
           ELSE                                                         
A02541        MOVE 'N'                    TO WS-SUB-ACCT-FOUND-SW       
A02541        SET WS-HOLD-SUB-INDX        TO 1                          
A02541        SEARCH WS-HOLD-SUB-ACCT-TABLE AT END                      
A02541            MOVE 'N'                     TO WS-SUB-ACCT-FOUND-SW  
A02541        WHEN WS-HOLD-SUB-ACCOUNT(WS-HOLD-SUB-INDX) = HB-ACCOUNT-NO
A02541            MOVE 'Y'                     TO WS-SUB-ACCT-FOUND-SW  
A02541        END-SEARCH                                                
A02541        IF SUB-ACCT-NOT-FOUND                                     
                 ADD  +1                       TO WS-SUB-WQ-INDX        
                 MOVE HB-ACCOUNT-NO            TO                       
                                    WS-SUB-WQ-ACCT-NO(WS-SUB-WQ-INDX)   
                 MOVE 'Y'                      TO                       
                                    WS-SUB-WQ-INS-STATUS(WS-SUB-WQ-INDX)
A02541        END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************         08210000
      *   LOAD ALL CA15 RECORDS FOR AN ACCOUNT TO CWS10000,1. *         08220000
      *   READ THE NEXT CA15 RECORD.                          *         08230000
      *********************************************************         08240000
                                                                        
       2300-LOAD-TO-WS.                                                 
                                                                        
           PERFORM 0609-INITIALIZE-FBE36-WS-AREA THRU 0609-EXIT.        
                                                                        
           PERFORM 0640-INITIALIZE-FBE37-WS-AREA THRU 0640-EXIT.        
                                                                        
           PERFORM 0690-INITIALIZE-FBE38-WS-AREA THRU 0690-EXIT.        
                                                                        
           MOVE HB-ACCOUNT-NO               TO WS-DELETE-ACCOUNT-NO     
                                               WS-PREV-ACCT-NO.         
           MOVE HB-DATE-BILLED              TO WS-PREVIOUS-DATE-BILLED  
                                               WS-DELETE-DATE-BILLED.   
   ****LOAD THE ACCOUNTS TO CWS1000B WORKING STORAGE TABLE              08420000
           PERFORM UNTIL (HB-DATE-BILLED NOT = WS-PREVIOUS-DATE-BILLED  
                      OR  HB-ACCOUNT-NO  NOT = WS-PREV-ACCT-NO)         
               MOVE HB-OCC-DATA-TEXT           TO FIOBE22               
A04494         IF E-FBE22-TABLE-ID = 1910 AND                           
A04494                                   HB-DATE-BILLED < '2013-06-30'  
A04494            MOVE FIOBE22                 TO WS-HOLD-FIOBE22       
A04494            COMPUTE WS-FRANCHISE-TX-RATE-CALC-ED =                
A04494                     WS-FRANCHISE-TX-RATE-CALC-ED * 10            
A04494            COMPUTE  WS-STATE-TX-RATE-CALC-ED =                   
A04494                       WS-STATE-TX-RATE-CALC-ED * 10              
A04494            MOVE WS-HOLD-FIOBE22         TO FIOBE22               
A04494         END-IF                                                   
               MOVE E-FBE22-DATA               TO E-FBE38-DATA          
               MOVE E-FBE22-COMPANY-NO         TO E-FBE38-COMPANY-NO    
               MOVE E-FBE22-LOCAL-OFFICE       TO E-FBE38-LOCAL-OFFICE  
               MOVE E-FBE22-ACCOUNT-NO         TO E-FBE38-ACCOUNT-NO    
               MOVE E-FBE22-TABLE-ID           TO E-FBE38-TABLE-ID      
               MOVE E-FBE22-PREMISE-NO         TO E-FBE38-PREMISE-NO    
               MOVE E-FBE22-MST-ACCT-NO        TO E-FBE38-MST-ACCT-NO   
               MOVE E-FBE22-MST-SUB-IND        TO E-FBE38-MST-SUB-IND   
               MOVE E-FBE22-SORT-KEY           TO E-FBE37-SORT-KEY      
               MOVE E-FBE22-TABLE-ID           TO WS-CWS-TABLE-ID       
               ADD +1                          TO WS-RECS-FROM-TAB      
                                                                        
               IF WS-CWS10000-TABLE-ID                                  
                  PERFORM 0800-LOAD-FBE38-WS-AREA THRU 0800-EXIT        
               END-IF                                                   
               IF WS-CWS10001-TABLE-ID                                  
                  MOVE E-FBE38-SORT-KEY        TO E-FBE37-SORT-KEY      
                  MOVE E-FBE38-DATA(1:250)     TO E-FBE37-DATA          
                  PERFORM 0850-LOAD-FBE37-WS-AREA THRU 0850-EXIT        
               END-IF                                                   
               IF WS-CWS10009-TABLE-ID                                  
                  PERFORM 0880-LOAD-FBE38-WS-AREA THRU 0880-EXIT        
               END-IF                                                   
                                                                        
               IF E-FBE22-TABLE-ID = 0300                               
                  ADD +1                       TO WS-ACCTS-FROM-TAB     
   ****IDENTIFY IF A SUB ACCT BELONG TO 2 DIFFERENT MASTER ACCT                 
A03019*THE CONDITION MU-MST-ACCT-NO > ZERO IS ADDED FOR CHECKING WHETHER        
A03019*SUB IS COMING WITH TWO MASTERS, AS THE MU-MST-ACCT-NO IS                 
A03019*INITIALIZED, WHEN SEVERD SUB COMES ALONE THIS WILL TAKE CARE.            
                  MOVE 'N'                     TO WS-TWO-MASTER-SWITCH  
                  IF WS-MST-SUB-ACCT-IND-AT = 'S'                       
A03019               IF (HB-MST-ACCT-NO NOT EQUAL TO MU-MST-ACCT-NO AND 
A03019                   MU-MST-ACCT-NO > ZERO)                         
                        SET TWO-MASTERS               TO TRUE           
                     END-IF                                             
                  END-IF                                                
                  IF TWO-MASTERS                                        
                     MOVE 'E'                 TO WS-CODE-PRNT-BLL-MST-AT
                     PERFORM 5350-BUILD-SUB-WQ THRU 5350-EXIT           
                  END-IF                                                
   ********                                                                     
                 IF WS-MST-SUB-ACCT-IND-AT = 'S'                        
                    DISPLAY ' HB-DATE-BILLED      ' HB-DATE-BILLED      
                    DISPLAY ' MU-MST-ACCT-NO      ' HB-MST-ACCT-NO      
                 END-IF                                                 
   ********                                                                     
                 IF DELETE-ACCTS                                        
                    IF WS-CODE-TEMP-BILL-AT = 'R' AND SEB-DATABASE      
                       MOVE 'I'                TO                       
                                               WS-CODE-PRNT-BLL-MST-AT  
                    ELSE                                                
                       MOVE 'T'                TO WS-CODE-TEMP-BILL-AT  
                       MOVE 'I'                TO                       
                                               WS-CODE-PRNT-BLL-MST-AT  
                    END-IF                                              
                 END-IF                                                 
               END-IF                                                   
                                                                        
                                                                        
               ADD +1                          TO WS-MISC-IDX-1         
               IF DELETE-ACCTS                                          
                  MOVE WS-SUB-REC-ACCOUNT-NO(WS-MISC-IDX-1) TO          
                                                   HB-ACCOUNT-NO        
               END-IF                                                   
               MOVE WS-SUB-REC-DATE-BILLED(WS-MISC-IDX-1)   TO          
                                               HB-DATE-BILLED           
               MOVE WS-SUB-REC-MST-ACT-NO(WS-MISC-IDX-1)    TO          
                                               HB-MST-ACCT-NO           
               MOVE WS-SUB-REC-OCC-DATA(WS-MISC-IDX-1)      TO          
                                               HB-OCC-DATA              
           END-PERFORM.                                                 
                                                                        
           MOVE  'H'                           TO                       
                                             WS-CA165IN-TP-MEMO-PROCESS 
           PERFORM 3000-GET-UNIQ-IDENT         THRU 3000-EXIT.          
                                                                        
           PERFORM 8000-WRITE-CWS-VALUES       THRU 8000-EXIT.          
           PERFORM 8910-DELETE-OCCURRENCES     THRU 8910-EXIT.          
                                                                        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************                 
      * THE DATE BILLED BI IS NULL, DO NOT PROCESS THE ACCT   *                 
      * SEND A WQ TO BILLING TEAM                             *                 
      *********************************************************                 
                                                                        
       2400-CHECK-DATE-BILLED.                                          
                                                                        
A04860     INITIALIZE CWS00077-FIELDS.                                  
           IF WS-DATE-BILLED-BI = LOW-VALUES OR SPACES                  
              DISPLAY '**** ACCOUNT NUMBER  -  ' WS-ACCOUNT-NO-AT       
              DISPLAY '**** DATE BILLED ON BILLING HDR IS NULL ! ****'  
              MOVE 'PCSCA105'                  TO WS-NO-DATE-INFO       
              STRING WS-NO-DATE-MSG-LITERAL                             
                     WS-NO-DATE-INFO                                    
                     DELIMITED BY SIZE                                  
                INTO WS-NO-DATE-MSG-TEXT                                
              MOVE WS-NO-DATE-ON-BILL-MSG      TO                       
                   WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)        
A04860        MOVE WS-NO-DATE-CAT-ID           TO WS-77-CATEGORY-ID     
A04860        MOVE WS-NO-DATE-PRIORITY         TO WS-77-PRIORITY        
A04860        MOVE WS-NO-DATE-ROUTE-CAT        TO WS-77-ROUTE-CATEGORY  
A04860        MOVE WS-NO-DATE-MSG-LEN          TO WS-77-COMMENTS-LEN    
A04860        MOVE WS-NO-DATE-MSG-TEXT         TO WS-77-COMMENTS-TEXT   
A04860        MOVE ZERO                        TO WS-77-SERV-ORDER-NO   
A04860        MOVE WS-INPUT-BE22-DATE          TO WS-77-DATE-REQUIRED   
A04860        MOVE WS-ACCOUNT-NO-AT            TO WS-77-ACCOUNT-NO      
A04860        MOVE WS-PREMISE-NO-AT            TO WS-77-PREMISE-NO      
A04860        MOVE WS-CUSTOMER-NO-AT           TO WS-77-CUSTOMER-NO     
A04860        MOVE SPACES                      TO WS-77-RESP-AREA-ID    
A04860        MOVE WS-LOCAL-OFFICE-AT          TO WS-77-LOCAL-OFFICE    
A04860        MOVE ZERO                        TO WS-77-FREE-FORM-LEN   
A04860        MOVE LOW-VALUES                  TO WS-77-FREE-FORM-TXT   
A04860        MOVE PROGRAM-NAME                TO WS-77-CREATED-BY      
              IF WS-WQ-INS-SW = 'Y'                                     
                 PERFORM 8895-INSERT-WORK-QUEUE   THRU 8895-EXIT        
              END-IF                                                    
              MOVE 'Y'                         TO WS-BYPASS-ACCOUNT-SW  
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************                 
      * SUB ACCOUNT PROCESSING.                               *                 
      *********************************************************                 
                                                                        
       2500-SUB-ACCT-PROCESS.                                           
                                                                        
   ****CHECKS IF CANCEL REBILLED                                                
           MOVE LOW-VALUE TO WS-PREV-MAX-DOB                            
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
              WS-BILLING-INDX  > 30 OR                                  
                   WS-ACCOUNT-NO-BG (WS-BILLING-INDX) = +0              
             IF WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) > WS-PREV-MAX-DOB
                MOVE WS-DATE-ORIG-BILL-BG (WS-BILLING-INDX) TO          
                       WS-PREV-MAX-DOB                                  
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
   ****IF CANCEL REBILLED DELETES THE EXISTING RECORDS FROM                     
   ****CSS_HELD_BP_SUBS                                                         
           IF WS-PREV-MAX-DOB > LOW-VALUE                               
              MOVE WS-ACCOUNT-NO-AT            TO HB-ACCOUNT-NO         
                                                  WS-DELETE-ACCOUNT-NO  
              MOVE WS-PREV-MAX-DOB             TO HB-DATE-BILLED        
                                                  WS-DELETE-DATE-BILLED 
              DISPLAY 'C/R ACCOUNT = ' WS-ACCOUNT-NO-AT                 
              PERFORM 8910-DELETE-OCCURRENCES  THRU 8910-EXIT           
           END-IF                                                       
                                                                        
   ****CHECKS IF SUB COMES ALONG WITH ITS MASTER.                               
           MOVE SPACES                         TO WS-BILLED-WITH-MSTR-SW
           SEARCH ALL WS-MASTER-ACCTS-TBL AT END                        
                  MOVE 'N'                     TO WS-BILLED-WITH-MSTR-SW
             WHEN WS-MASTER-ACCOUNT-NO(MASTER-IND) = WS-ACCT-XFER-TO-AT 
                  MOVE 'Y'                     TO WS-BILLED-WITH-MSTR-SW
           END-SEARCH                                                   
                                                                        
A02541**IF SUB COMES ALONE WRITE TO OUTPUT FILE AND INSERT INTO                 
A02541**CSS_HELD_BP_SUBS                                                        
A02541**IF SUB COMES ALONG WITH ITS MASTER WRITE TO OUTPUT FILE                 
A02541**AND ALSO TO WORKING STORAGE TABLE.                                      
           IF SUB-ONLY-BILLED                                           
              MOVE 'Y'                         TO WS-INSERT-SW          
              INITIALIZE WS-HOLD-HELD-BPSUBS-HV                         
                         WS-SUB-REC-ROWS-HV                             
              PERFORM 8000-WRITE-CWS-VALUES    THRU 8000-EXIT           
              PERFORM 8920-INSERT-OCCURANCES   THRU 8920-EXIT           
           ELSE                                                         
A02541        ADD  +1                     TO WS-HOLD-SUB-COUNT          
A02541        MOVE WS-ACCOUNT-NO-AT       TO                            
A02541                 WS-HOLD-SUB-ACCOUNT(WS-HOLD-SUB-COUNT)           
              PERFORM 8000-WRITE-CWS-VALUES    THRU 8000-EXIT           
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************                 
      * HOLD THE SUB ACCOUNT RECORDS IN AN ARRAY TO DO A MULTI*                 
      * ROW INSERT IN CSS_HELD_BP_SUBS.                       *                 
      *********************************************************                 
                                                                        
       2600-HOLD-INSERT-DATA.                                           
                                                                        
           MOVE WS-ACCOUNT-NO-AT               TO                       
                              WS-SUB-ACCOUNT-NO-HV (WS-SUB-REC-ROWS-HV).
           MOVE WS-DATE-BILLED-BI              TO                       
                                 WS-DATE-BILLED-HV (WS-SUB-REC-ROWS-HV).
           MOVE WS-ACCT-XFER-TO-AT             TO                       
                                 WS-MST-ACCT-NO-HV (WS-SUB-REC-ROWS-HV).
           MOVE 'N'                            TO                       
                                     WS-PULL-FL-HV (WS-SUB-REC-ROWS-HV).
           MOVE SPACES                         TO WS-HOLD-BE06-DATA     
                                                                        
   ****EXCLUDE DATE-BILLED-BI FROM INSERTING TO CSS_HELD_BP_SUBS SO             
   ****IT WOULD BE IN INPUT FORMAT TO LOAD WHEN WE DOWNLOAD                     
           MOVE FIOBE06-DATA-REC(1:46)         TO                       
                                     WS-HOLD-BE06-DATA(1:46)            
           MOVE FIOBE06-DATA-REC(57:500)       TO                       
                                     WS-HOLD-BE06-DATA(47:500)          
           MOVE WS-HOLD-BE06-DATA              TO                       
                               WS-OCC-DATA-TEXT-HV (WS-SUB-REC-ROWS-HV).
                                                                        
           MOVE LENGTH OF WS-OCC-DATA-TEXT-HV (WS-SUB-REC-ROWS-HV) TO   
                                WS-OCC-DATA-LEN-HV (WS-SUB-REC-ROWS-HV).
                                                                        
   ****ASSIGN THE SEQUENCE NUMBER TO LOAD TO CSS_HELD_BP_SUBS                   
           IF WS-ACCOUNT-NO-AT = WS-PREV-SEQ-ACCT-NO                    
              ADD 1                            TO WS-SEQ-NO             
           ELSE                                                         
              MOVE WS-ACCOUNT-NO-AT            TO WS-PREV-SEQ-ACCT-NO   
              MOVE 1                           TO WS-SEQ-NO             
           END-IF.                                                      
           MOVE WS-SEQ-NO                      TO                       
                                      WS-SEQ-NO-HV (WS-SUB-REC-ROWS-HV).
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************                 
      * DELETE ACCOUNTS FROM CSS_HELD_BP_SUBS WHICH HAVE      *                 
      * PULL_FLAG = 'D'                                       *                 
      *********************************************************                 
                                                                        
       2700-DELETE-SUBS.                                                
                                                                        
           INITIALIZE WS-SUB-ACCTS-RECS-HOLD-TABLE.                     
           MOVE 0                              TO WS-SUB-REC-ROWS.      
           MOVE 'Y'                            TO WS-DELETE-SW.         
                                                                        
           PERFORM 7700-OPEN-DEL-SUB-CSR       THRU 7700-EXIT.          
                                                                        
           PERFORM 7710-FETCH-DEL-SUB-CSR      THRU 7710-EXIT           
A2119          UNTIL WS-ACTIVE-RETURN-CODE NOT = 0.                     
                                                                        
           PERFORM 7720-CLOSE-DEL-SUB-CSR      THRU 7720-EXIT.          
                                                                        
           MOVE +1                             TO WS-MISC-IDX-1         
                                                                        
           MOVE WS-SUB-REC-ACCOUNT-NO(WS-MISC-IDX-1)  TO                
                                              HB-ACCOUNT-NO             
           MOVE WS-SUB-REC-DATE-BILLED(WS-MISC-IDX-1) TO                
                                              HB-DATE-BILLED            
           MOVE WS-SUB-REC-MST-ACT-NO(WS-MISC-IDX-1)  TO                
                                              HB-MST-ACCT-NO            
           MOVE WS-SUB-REC-OCC-DATA (WS-MISC-IDX-1)   TO                
                                              HB-OCC-DATA               
                                                                        
           PERFORM 2300-LOAD-TO-WS        THRU 2300-EXIT UNTIL          
                                        WS-MISC-IDX-1 > WS-SUB-REC-ROWS.
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************         11820000
      *   WRITE ENDING CONTROL RECORDS FOR OUTPUT FILE.       *         11830000
      *********************************************************         11850000
                                                                        
       2900-WRITE-END-CONTROLS.                                         
                                                                        
      *******UPDATE CSS_JOB_PARM WITH LATEST SEQUENCE NBR GENEREATED            
            IF UNIQ-GENERATED AND                                       
               WS-CA165IN-OK-TO-PROCESS = 'Y'                           
               MOVE    'Y'                    TO                        
                                              WS-CA165IN-END-OF-PROG-FL 
               PERFORM 5100-CALL-SCSCA165     THRU 5100-EXIT            
            END-IF.                                                     
                                                                        
           MOVE WS-FIOBE06-HOLD-EREC          TO FIOBE06-DATA-REC.      
           PERFORM 8900-WRITE-FCSBE06         THRU 8900-EXIT.           
           SUBTRACT 1                         FROM WS-RECORDS-WRITTEN.  
           IF ACCTS-TO-PROCESS                                          
              DISPLAY '***********************************************' 
              DISPLAY '* CHECK OMIT FILE, NOT ALL ACCOUNTS SKIPPED   *' 
              DISPLAY '* ACCTS FROM FILE ' WS-CA151-TOT-ACCTS-FROM-FILE 
              DISPLAY '* ACCTS OMITTED   ' WS-CA151-TOT-ACCTS-OMITTED   
              DISPLAY '***********************************************' 
           END-IF.                                                      
           DISPLAY '**********************************************'.    
           DISPLAY '*****PCSCA105 READ/WRITE DETAILS**************'.    
           DISPLAY '**********************************************'.    
           DISPLAY '   RECORDS READ       : ', WS-RECORDS-READ          
           DISPLAY '   ACCOUNTS READ      : ', WS-ACCOUNTS-READ         
           DISPLAY '**RECORDS FROM CSS_HELD_BP SUB TABLE DETAILS**'.    
           DISPLAY '   RECORDS DOWNLOADED : ', WS-RECS-FROM-TAB         
           DISPLAY '   ACCOUNTS DOWNLOADED: ', WS-ACCTS-FROM-TAB        
           DISPLAY '**********************************************'.    
           DISPLAY '   DEADHEADS          : ', WS-DEADHEAD-CNTR         
           DISPLAY '   ACCOUNTS SKIPPED   : ', WS-SKIP-CNTR             
           DISPLAY '   RECORDS WRITTEN    : ', WS-RECORDS-WRITTEN       
           DISPLAY '   ACCOUNTS WRITTEN   : ', WS-ACCTS-WRITTEN         
           DISPLAY '**********************************************'.    
           DISPLAY '**********************************************'.    
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *********************************************************         11820000
      *   GENERATE UNIQUE IDENTIFIER CALLING SCSCA165.        *         11830000
      *********************************************************         11850000
                                                                        
       3000-GET-UNIQ-IDENT.                                             
                                                                        
           MOVE 'BLLPRT'                    TO WS-CA165IN-CORR-TYPE     
           MOVE WS-ACCOUNT-NO-AT            TO WS-CA165IN-ACCOUNT-NO    
                                               WS-ACCOUNT-NO-MW         
           MOVE WS-CUSTOMER-NO-AT           TO WS-CA165IN-CUSTOMER-NO   
           MOVE WS-INPUT-BE22-DATE          TO WS-CREATE-DT-MW          
                                               WS-CA165IN-PROCESS-DATE  
           MOVE WS-COMPANY-NO-AT            TO WS-CA165IN-COMPANY-NO    
           MOVE C8-DELINQ-VALUE             TO WS-CA165IN-DATABASE      
           MOVE WS-REG-GROUP-CD-AT          TO WS-CA165IN-REG-GROUP-CD  
           MOVE WS-LOCAL-OFFICE-AT          TO WS-CA165IN-LOCAL-OFFICE  
           MOVE PROGRAM-NAME                TO                          
                                            WS-CA165IN-APPL-PROGRAM-ID  
           MOVE  'N'                        TO WS-CA165IN-UPDATE-SEQ-FL 
                                               WS-CA165IN-END-OF-PROG-FL
           MOVE  'Y'                        TO WS-UNIQ-GEN-SW           
           PERFORM 5100-CALL-SCSCA165       THRU 5100-EXIT              
           MOVE WS-CA165OUT-UNIQ-ID         TO WS-BARCODE-UNIQUE-ID-MW. 
           MOVE WS-CA165OUT-CUR-STATUS      TO WS-TRACKING-STATUS-CD-MW.
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
ACT044*********************************************************         11820000
ACT044*   GENERATE UNIQUE IDENTIFIER LIST FOR EMAIL           *         11830000
ACT044*********************************************************         11850000
ACT044                                                                  
ACT044 3100-EMAIL-LIST.                                                 
ACT044     PERFORM VARYING WS-UNIQ-ID-SUB FROM 1 BY 1 UNTIL             
ACT044         WS-UNIQ-ID-SUB                   > 100 OR                
ACT044         WS-UNIQ-ID-ACCT (WS-UNIQ-ID-SUB) = 0                     
ACT044             WRITE EMAILFL-REC FROM                               
ACT044                  WS-UNIQ-ID-EMAIL-LINE (WS-UNIQ-ID-SUB)          
ACT044     END-PERFORM.                                                 
ACT044     IF WS-UNIQ-ID-SUB > 100                                      
ACT044        MOVE 'OVER 100 ACCOUNTS HAD GENERATED UNIQUE IDS'         
ACT044           TO EMAILFL-REC                                         
ACT044        WRITE EMAILFL-REC                                         
ACT044     END-IF.                                                      
ACT044     IF RETURN-CODE = 0                                           
ACT044         MOVE 2 TO RETURN-CODE                                    
ACT044     END-IF.                                                      
ACT044 3100-EXIT.                                                       
ACT044     EXIT.                                                        
      ***************************************************************** 00234900
      *    5000-CALL-SKIP-ACCTS                                      ** 00235000
      * THIS WILL CALL PROGRAM SCSCA151 TO ACCOMPLISH THE FOLLOWING.  * 00235100
      * 1. AT FIRST CALL LOAD ALL THE ACCOUNTS THAT SHOULD GET SKIPPED* 00235200
      *    FROM OMITACCT FILE.                                        * 00235100
      * 2. AT ACCOUNT LEVEL CALLS THIS SUB PROGRAM WILL CHECK IF THE  * 00237200
      *    ACCOUNT NEED TO GET SKIPPED FROM BILL PRINT.               * 00237200
      ***************************************************************** 00235300
                                                                        
       5000-CALL-SKIP-ACCTS.                                            
                                                                        
           DISPLAY 'CALLING SCSCA151 FROM PCSCA105'.                    
                                                                        
           CALL SCSCA151 USING   WS-SCSCA151-PARMS                      
                                 WS-SCSCA-RETURN-CODE.                  
                                                                        
           IF WS-SCSCA-RETURN-CODE > 1                                  
              MOVE 'SCSCA151'                  TO WS-BYPASS-INFO        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************      16440000
      *  CALL SCSCA165 TO GET UNIQUE IDENTIFIER                  *      16441000
      ************************************************************      16442000
       5100-CALL-SCSCA165.                                              
      *                                                                 16445000
           DISPLAY 'CALL SCSCA165 FROM PCSCA105'.                       
                                                                        
           CALL  SCSCA165                 USING WS-SCSCA165-PARMS,      
                                                WS-CA165-MISC,          
                                                ABEND-FILE,             
                                                WS-SCSCA-RETURN-CODE    
                                                                        
           MOVE 'SCSCA165'                TO WS-DISPLAY-SCSCA.          
                                                                        
           IF WS-SCSCA-RETURN-CODE        NOT = 0                       
              PERFORM 9200-SCSCA-ERROR    THRU   9200-EXIT              
           END-IF.                                                      
      *                                                                 16471000
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
     ***************************************************************            
     ** TWO MASTERS FOR THE SAME SUB WORK QUEUE.                  **            
     ***************************************************************            
                                                                        
       5350-BUILD-SUB-WQ.                                               
                                                                        
A04860     INITIALIZE CWS00077-FIELDS.                                  
A04860     MOVE WS-WQ-CATEGORY-ID  TO WS-77-CATEGORY-ID.                
A04860     MOVE WS-WQ-PRIORITY TO WS-77-PRIORITY.                       
A04860     MOVE WS-WQ-ROUTE-CATEGORY TO WS-77-ROUTE-CATEGORY.           
A04860     MOVE HB-ACCOUNT-NO       TO WS-77-ACCOUNT-NO                 
                                       WS-WQ-SUB-ACCT-TEMP.             
A04860     MOVE WS-WQ-MESSAGE2-LENGTH TO WS-77-COMMENTS-LEN.            
A04860     MOVE WS-WQ-SUB-TWO-MSTRS TO WS-77-COMMENTS-TEXT.             
A04860     MOVE ZERO TO WS-77-SERV-ORDER-NO.                            
A04860     MOVE WS-INPUT-BE22-DATE  TO WS-77-DATE-REQUIRED              
A04860     MOVE WS-INPUT-BE22-DATE  TO WS-INPUT-DATE-PT.                
A04860     MOVE WS-INPUT-TS         TO WS-77-DATE-CREATED.              
A04860     MOVE ZERO                TO WS-77-PREMISE-NO.                
A04860     MOVE ZERO                TO WS-77-CUSTOMER-NO.               
A04860     MOVE SPACES TO WS-77-RESP-AREA-ID                            
A04860                    WS-77-LOCAL-OFFICE.                           
A04860     MOVE ZERO TO WS-77-FREE-FORM-LEN.                            
A04860     MOVE LOW-VALUES TO WS-77-FREE-FORM-TXT.                      
A04860     MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.            
                                                                        
           PERFORM 8895-INSERT-WORK-QUEUE     THRU 8895-EXIT.           
                                                                        
       5350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12490000
      *                                                                 00264900
      ****************************************************************  00122600
      ** 7000-READ-FCSBE22.                                         **  00122700
      ** READ THE INPUT FILE FCSBE22.                               **  00122800
      ****************************************************************  00123100
       7000-READ-FCSBE22.                                               
                                                                        
           READ FCSBE22-FILE                                            
               AT END                                                   
                  MOVE WS-YES                 TO WS-FCSBE22-FLAG.       
           IF FBE22-SUCCESSFUL  OR END-OF-FCSBE22                       
              IF E-FBE22-KEY-EREC  = HIGH-VALUES                        
                 MOVE WS-YES                  TO WS-FCSBE22-FLAG        
                 MOVE ZERO                    TO E-FBE22-DB-PART-EREC   
                 MOVE FIOBE22-DATA-REC        TO WS-FIOBE06-HOLD-EREC   
              ELSE                                                      
                 ADD  +1                      TO WS-RECORDS-READ        
              END-IF                                                    
           ELSE                                                         
              DISPLAY '7000-ERROR ON FIOBE22 READ'                      
              DISPLAY 'PROCESSING TERMINATED'                           
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   GET DATABASE, WHETHER CSR OR SEB.                            *        
      ******************************************************************        
       7100-GET-DATABASE.                                               
                                                                        
           EXEC SQL                                                     
                SELECT DELINQ_VALUE                                     
                  INTO :C8-DELINQ-VALUE                                 
                  FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
                 WHERE DELINQ_CD = :C8-DELINQ-CD                        
                   AND COMPANY_NO = :C8-COMPANY-NO                      
A02034                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00205100
MFA-TR*         SELECT DELINQ_VALUE                                     00205200
MFA-TR*           INTO :C8-DELINQ-VALUE                                 00205300
MFA-TR*           FROM CSS_DELINQUENCY                                  00205400
MFA-TR*          WHERE DELINQ_CD = :C8-DELINQ-CD                        00205500
MFA-TR*            AND COMPANY_NO = :C8-COMPANY-NO                      00205600
MFA-TR*          WITH UR                                                00205600
MFA-TR*    END-EXEC.                                                    00205700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE 'C8' TO WS-DB2-TABLE-ID                             
               MOVE 'OPEN' TO WS-DB2-FUNCTION                           
               MOVE SQLCODE TO WS-DB2-RETURN-CODE                       
               MOVE '105' TO WS-DB2-MODULE-ID                           
               MOVE '7100' TO WS-DB2-PARAGRAPH                          
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '*** IN 7100 CHECK DATABASE ***'                 
               DISPLAY '*** SQL CODE    = ' SQLCODE                     
               DISPLAY '*** DELINQ CODE = ' C8-DELINQ-CD                
               DISPLAY '*** COMPANY NO  = ' C8-COMPANY-NO               
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7150-GET-PROCESS-FLAG                                                   
      *****************************************************************         
                                                                        
A02541 7150-GET-PROCESS-FLAG.                                           
A02541                                                                  
A02541     EXEC SQL                                                     
A02541          SELECT G6.PARM_DATA                                     
A02541            INTO :G6-PARM-DATA                                    
A02541            FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
A02541           WHERE G6.PROGRAM_NAME = 'SCSCA165'                     
A02541             AND G6.COMPANY_NO   = '01'                           
A02541             AND G6.CMND_CODE    = 'PARM'                         
A02541             AND G6.STATUS       = 'A'                            
A02541                                                           
A02541     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02642000
MFA-TR*         SELECT G6.PARM_DATA                                     01176000
MFA-TR*           INTO :G6-PARM-DATA                                            
MFA-TR*           FROM CSS_JOB_PARM G6                                  01178000
MFA-TR*          WHERE G6.PROGRAM_NAME = 'SCSCA165'                     01179000
MFA-TR*            AND G6.COMPANY_NO   = '01'                           01179100
MFA-TR*            AND G6.CMND_CODE    = 'PARM'                         01179200
MFA-TR*            AND G6.STATUS       = 'A'                            01179400
MFA-TR*           WITH UR                                               01179500
MFA-TR*    END-EXEC.                                                    02647000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02541                                                                  
A02541     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A02541                                                                  
A02541     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02541        MOVE G6-PARM-DATA             TO WS-CTRL-PARM-STR         
A02541     ELSE                                                         
A02541         DISPLAY '*** IN 7150 GET PROCESS FLAG *****'             
A02541         DISPLAY '*** SQL CODE    = ' WS-ACTIVE-RETURN-CODE       
A02541        PERFORM 9900-ABEND               THRU 9900-EXIT           
A02541     END-IF.                                                      
A02541*                                                                         
A02541 7150-EXIT.                                                       
A02541     EXIT.                                                        
A02541*                                                                         
      ******************************************************************        
      *   OPET MSTSUB CURSOR TO PULL ALL THE SUBS FOR MASTER           *        
      ******************************************************************        
                                                                        
       7200-OPEN-MSTSUB-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN MSTSUB                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7200-OPEN-MSTSUB-CURSOR  '                
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_BUDGET_HIST  '                     
              DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO             
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   FETCH FROM MSTSUB CURSOR AND STORE IT IN ARRAY               *        
      ******************************************************************        
                                                                        
       7210-FETCH-MSTSUB-CURSOR.                                        
                                                                        
           INITIALIZE                             WS-HOLD-MST-SUB-HV.   
           MOVE 0                              TO WS-SUB-ROW-COUNT      

MSQ008     MOVE 100 TO MSQ008-MSTSUB
           EXEC SQL                                                     
               FOR :MSQ008-MSTSUB
              FETCH 
              FROM MSTSUB  INTO          
                     :WS-SUB-ACCOUNT-HV                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM MSTSUB FOR 100 ROWS INTO                  
MFA-TR*              :WS-SUB-ACCOUNT-HV                                         
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-MSTSUB
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN 354                                                 
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                  
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                                     
MFA-TR*                  :WS-SUB-ROW-COUNT = ROW_COUNT                          
MFA-TR*            END-EXEC                                                     
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-SUB-ROW-COUNT
                   MOVE 1 TO WS-MISC-IDX                                
                   PERFORM UNTIL WS-MISC-IDX > 100                      
                              OR WS-MISC-IDX > WS-SUB-ROW-COUNT         
                      ADD 1                      TO WS-SUB-COUNT        
                      MOVE WS-SUB-ACCOUNT-HV(WS-MISC-IDX)   TO          
                           WS-SUB-ACCOUNT-NO(WS-SUB-COUNT)              
                      ADD 1                      TO WS-MISC-IDX         
                   END-PERFORM                                          
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      CONTINUE                                          
                   END-IF                                               
               WHEN OTHER                                               
                    DISPLAY '****** 7210-FETCH-MSTSUB-CURSOR   '        
                    DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
                    DISPLAY ' ** ERROR ON FETCH  '                      
                    DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY ' ** TABLE CSS_BUDGET_HIST  '               
                    DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO       
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   CLOSE MSTSUB                                                 *        
      ******************************************************************        
                                                                        
       7220-CLOSE-MSTSUB-CURSOR.                                        
                                                                        
      *                                                                 05330000
           EXEC SQL                                                     
                CLOSE MSTSUB                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05330000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7220-CLOSE-MSTSUB-CURSOR  '               
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_BUDGET_HIST  '                     
              DISPLAY ' ** ACCOUNT_NO     '  MU-MST-ACCT-NO             
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   OPEN OCCUR-CSR CURSOR.                                       *        
      ******************************************************************        
                                                                        
       7400-OPEN-OCCUR-CSR.                                             
                                                                        
                                                                        
           EXEC SQL                                                     
                OPEN OCCUR-CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
                DISPLAY '****** 7400-OPEN-OCCUR-CSR       '             
                DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'          
                DISPLAY ' ** ERROR ON OPEN   '                          
                DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE        
                DISPLAY ' ** TABLE CSS_HELD_BP_SUB  '                   
                DISPLAY ' ** ACCOUNT_NO     '  HB-ACCOUNT-NO            
                PERFORM 9900-ABEND             THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   FETCH OCCUR-CSR CURSOR AND STORE IT IN ARRAY.                *        
      ******************************************************************        
                                                                        
       7410-FETCH-OCCURRENCES.                                          
                                                                        
           MOVE 0                              TO WS-SUB-ROW-COUNT      

MSQ008     MOVE 200 TO MSQ008-OCCUR-CSR
           EXEC SQL                                                     
A2119           FOR :MSQ008-OCCUR-CSR
              FETCH 
              FROM OCCUR-CSR  INTO      
                  :WS-DATE-BILLED-HV,                                   
                  :WS-MST-ACCT-NO-HV,                                   
                  :WS-OCC-DATA-HV                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     07490000
MFA-TR*         FETCH NEXT ROWSET FROM OCCUR-CSR FOR 200 ROWS INTO      07500000
MFA-TR*           :WS-DATE-BILLED-HV,                                   07510000
MFA-TR*           :WS-MST-ACCT-NO-HV,                                   07520000
MFA-TR*           :WS-OCC-DATA-HV                                       07530000
MFA-TR*    END-EXEC.                                                    07540000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-OCCUR-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN 354                                                 
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                  
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                                     
MFA-TR*                  :WS-SUB-ROW-COUNT = ROW_COUNT                          
MFA-TR*            END-EXEC                                                     
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-SUB-ROW-COUNT
                   MOVE 1                      TO WS-MISC-IDX-1         
                   PERFORM UNTIL WS-MISC-IDX-1 > 200                    
                              OR WS-MISC-IDX-1 > WS-SUB-ROW-COUNT       
                       ADD 1                   TO WS-SUB-REC-ROWS       
                       MOVE WS-DATE-BILLED-HV(WS-MISC-IDX-1)   TO       
                            WS-SUB-REC-DATE-BILLED(WS-SUB-REC-ROWS)     
                       MOVE WS-MST-ACCT-NO-HV(WS-MISC-IDX-1)   TO       
                            WS-SUB-REC-MST-ACT-NO(WS-SUB-REC-ROWS)      
                       MOVE WS-OCC-DATA-HV (WS-MISC-IDX-1)     TO       
                            WS-SUB-REC-OCC-DATA  (WS-SUB-REC-ROWS)      
                       ADD 1                   TO WS-MISC-IDX-1         
                   END-PERFORM                                          
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      CONTINUE                                          
                   END-IF                                               
               WHEN OTHER                                               
                   DISPLAY '****** 7410-FETCH-OCCURRENCES       '       
                   DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'       
                   DISPLAY ' ** ERROR ON FETCH  '                       
                   DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE     
                   DISPLAY ' ** TABLE CSS_HELD_BP_SUB  '                
                   DISPLAY ' ** ACCOUNT_NO     '  HB-ACCOUNT-NO         
                   PERFORM 9900-ABEND             THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   CLOSE OCCUR-CSR CURSOR.                                      *        
      ******************************************************************        
                                                                        
       7420-CLOSE-OCCURRENCES.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE OCCUR-CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7420-CLOSE-OCCURRENCES       '            
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_HELD_BP_SUB  '                     
              DISPLAY ' ** ACCOUNT_NO     '  HB-ACCOUNT-NO              
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   OPEN DEL-SUB-CSR CURSOR.                                     *        
      ******************************************************************        
                                                                        
       7700-OPEN-DEL-SUB-CSR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN DEL-SUB-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7700-OPEN-DEL-SUB-CSR       '             
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN  '                             
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_HELD_BP_SUB  '                     
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   FETCH DEL-SUB-CSR CURSOR AND LOAD TO AN ARRAY                *        
      ******************************************************************        
                                                                        
       7710-FETCH-DEL-SUB-CSR.                                          
                                                                        
           MOVE '7710' TO WS-SQL-PARA-TEMP.                             

MSQ008     MOVE 200 TO MSQ008-DEL-SUB-CSR
           EXEC SQL                                                     
A2119           FOR :MSQ008-DEL-SUB-CSR
              FETCH 
              FROM DEL-SUB-CSR  INTO    
                  :WS-SUB-ACCOUNT-NO-HV,                                
                  :WS-MST-ACCT-NO-HV,                                   
                  :WS-DATE-BILLED-HV,                                   
                  :WS-OCC-DATA-HV                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     10600000
MFA-TR*         FETCH NEXT ROWSET FROM DEL-SUB-CSR FOR 200 ROWS INTO    07500000
MFA-TR*           :WS-SUB-ACCOUNT-NO-HV,                                07510000
MFA-TR*           :WS-MST-ACCT-NO-HV,                                   07520000
MFA-TR*           :WS-DATE-BILLED-HV,                                   07510000
MFA-TR*           :WS-OCC-DATA-HV                                       07530000
MFA-TR*    END-EXEC.                                                    10660000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-DEL-SUB-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A2119      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
               WHEN 354                                                 
                   EXEC SQL GET DIAGNOSTICS                             
MSQ012                   :MFA-GD-ROW-COUNT = ROW_COUNT                  
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*            EXEC SQL GET DIAGNOSTICS                                     
MFA-TR*                  :WS-SUB-ROW-COUNT = ROW_COUNT                          
MFA-TR*            END-EXEC                                                     
MSQ012             MOVE MFA-GD-ROW-COUNT TO WS-SUB-ROW-COUNT
                   MOVE 1 TO WS-MISC-IDX-1                              
                   PERFORM UNTIL WS-MISC-IDX-1 > 200                    
                              OR WS-MISC-IDX-1 > WS-SUB-ROW-COUNT       
                       ADD 1 TO WS-SUB-REC-ROWS                         
                       MOVE WS-SUB-ACCOUNT-NO-HV(WS-MISC-IDX-1)   TO    
                            WS-SUB-REC-ACCOUNT-NO(WS-SUB-REC-ROWS)      
                       MOVE WS-DATE-BILLED-HV(WS-MISC-IDX-1)      TO    
                            WS-SUB-REC-DATE-BILLED(WS-SUB-REC-ROWS)     
                       MOVE WS-MST-ACCT-NO-HV(WS-MISC-IDX-1)      TO    
                            WS-SUB-REC-MST-ACT-NO(WS-SUB-REC-ROWS)      
                       MOVE WS-OCC-DATA-HV (WS-MISC-IDX-1)        TO    
                            WS-SUB-REC-OCC-DATA (WS-SUB-REC-ROWS)       
                       ADD 1                      TO WS-MISC-IDX-1      
                   END-PERFORM                                          
                   IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
                      CONTINUE                                          
                   END-IF                                               
               WHEN OTHER                                               
                    DISPLAY '****** 7710-FETCH-DEL-SUB-CSR   '          
                    DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
                    DISPLAY ' ** ERROR ON FETCH '                       
                    DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE    
                    DISPLAY ' ** TABLE CSS_HELD_BP_SUB  '               
                    PERFORM 9900-ABEND             THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   CLOSE DEL-SUB-CSR CURSOR                                     *        
      ******************************************************************        
                                                                        
       7720-CLOSE-DEL-SUB-CSR.                                          
                                                                        
      *                                                                 05330000
           EXEC SQL                                                     
                CLOSE DEL-SUB-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05330000
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '****** 7720-CLOSE-DEL-SUB-CSR   '                
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE '                             
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_HELD_BP_SUB  '                     
              PERFORM 9900-ABEND             THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * THIS COPY OF CPD00103 WILL MOVE THE VALUES FROM          *              
      * CWS10000, CWS10001, AND CWS10009 TO THE BEXX AREA        *              
      * AND WRITE TO THE BE04 & BE06 OUTPUT FOR EACH OF THE      *              
      * TABLE IDS IN THE CWS COPYBOOKS.                          *              
      * 8000-WRITE-CWS-VALUES                                    *              
      ************************************************************              
       COPY CPD0103C.                                                           
                                                                        
      ************************************************************              
      * POPULATE THE KEY INFORMATION FOR WRITING TO OUTPUT FILE  *              
      ************************************************************              
                                                                        
       8800-WRITE-FCSBEXX.                                              
                                                                        
           MOVE E-FBE36-TABLE-ID               TO E-FBE06-TABLE-ID.     
           MOVE E-FBE36-DATA                   TO E-FBE06-DATA.         
           MOVE WS-COMPANY-NO-AT               TO E-FBE06-COMPANY-NO.   
           MOVE WS-ACCOUNT-NO-AT               TO E-FBE06-ACCOUNT-NO.   
           MOVE WS-LOCAL-OFFICE-AT             TO E-FBE06-LOCAL-OFFICE. 
           IF SEB-DATABASE                                              
              IF WS-REGULATED-CD-AT  = '02'                             
                 MOVE WS-REGULATED-CD-AT       TO WS-REGULATED-CD-NUM   
                 MOVE WS-REGULATED-CD-NUM      TO                       
                                               E-FBE06-PREMISE-NO(1:2)  
                 MOVE ZERO                     TO                       
                                               E-FBE06-PREMISE-NO(3:8)  
              ELSE                                                      
                 MOVE ZERO                     TO E-FBE06-PREMISE-NO    
              END-IF                                                    
           ELSE                                                         
              MOVE WS-PREMISE-NO-AT            TO E-FBE06-PREMISE-NO    
           END-IF.                                                      
           MOVE WS-MST-SUB-ACCT-IND-AT         TO E-FBE06-MST-SUB-IND.  
           MOVE WS-DATE-BILLED-BI              TO E-FBE06-DATE-BILLED.  
           EVALUATE WS-MST-SUB-ACCT-IND-AT                              
               WHEN 'M'                                                 
                   MOVE WS-ACCOUNT-NO-AT       TO E-FBE06-MST-ACCT-NO   
               WHEN 'S'                                                 
                   MOVE WS-ACCT-XFER-TO-AT     TO E-FBE06-MST-ACCT-NO   
               WHEN OTHER                                               
                   MOVE ZEROES                 TO E-FBE06-MST-ACCT-NO   
           END-EVALUATE.                                                
                                                                        
           MOVE ZERO                           TO E-FBE06-SORT-SUM-FLD. 
                                                                        
           IF E-FBE06-TABLE-ID = 0300                                   
              ADD +1                           TO WS-ACCTS-WRITTEN      
           END-IF                                                       
                                                                        
           PERFORM 8900-WRITE-FCSBE06          THRU 8900-EXIT.          
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************                                     13267400
      *  8895-INSERT-WORK-QUEUE  **                                     13267600
      *****************************                                     13267800
A04860*                                                                         
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860*                                                                         
A04860     CALL SCSCB077 USING CWS00077-FIELDS,                         
A04860                         ABEND-FILE,                              
A04860                         RS-RETURN-CODE                           
A04860     MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE                 
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
      *                                                                 13268300
      ************************************************************              
      * WRITE DATA TO BE06 AND LOAD TO HOLD SUB ACCOUNT IF IT    *              
      * COMES BY ITESLF.                                         *              
      ************************************************************              
       8900-WRITE-FCSBE06.                                              
                                                                        
           IF INSERT-ACCT                                               
              ADD +1                           TO WS-SUB-REC-ROWS-HV    
              PERFORM 2600-HOLD-INSERT-DATA    THRU 2600-EXIT           
   ****WHEN SUB COMES BY ITSELF THE COUPLE OF AT VALUES NEED TO BE              
   ****CHANGED SO THAT THE ACCOUNT DOESN'T GET MAILED OUT                       
              IF E-FBE06-TABLE-ID = 0300                                
                 INITIALIZE WS-AT-XX                                    
                 MOVE FIOBE06                  TO WS-AT-XX              
                 MOVE 'I'                      TO                       
                                             WS-AT-XX-CODE-PRNT-BLL-MST 
                 MOVE ZEROES                   TO WS-AT-XX-BILL-COPIES  
                 MOVE WS-AT-XX                 TO FIOBE06               
              END-IF                                                    
           END-IF.                                                      
                                                                        
           WRITE FIOBE06.                                               
                                                                        
           IF FBE06-SUCCESSFUL                                          
              ADD 1                            TO WS-RECORDS-WRITTEN    
           ELSE                                                         
              DISPLAY '8900-ERROR ON FCSBE06 WRITE. STATUS IS '         
                        WS-FBE06-STATUS                                 
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           INITIALIZE FIOBE06.                                          
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * DELETE SUB ACCOUNT BASED ON THE DATE BILLED SPECIFIED.   *              
      ************************************************************              
                                                                        
       8910-DELETE-OCCURRENCES.                                         
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_HELD_BP_SUBS                             
                WHERE ACCOUNT_NO  = :WS-DELETE-ACCOUNT-NO               
                  AND DATE_BILLED = IIF(TRY_CONVERT(DATE, 
                                                 :WS-DELETE-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :WS-DELETE-DATE-BILLED
              ) <> 0) OR (LEN(:WS-DELETE-DATE-BILLED
              ) <> 10), CIS.CHAR2DATE(:WS-DELETE-DATE-BILLED
              ), CONVERT(DATE, :WS-DELETE-DATE-BILLED) )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     07980000
MFA-TR*        DELETE FROM CSS_HELD_BP_SUBS                             07990000
MFA-TR*         WHERE ACCOUNT_NO  = :WS-DELETE-ACCOUNT-NO               08000000
MFA-TR*           AND DATE_BILLED = :WS-DELETE-DATE-BILLED              08010000
MFA-TR*    END-EXEC.                                                    08020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '****** 8910-DELETE-OCCURRENCES      '            
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON DELETE '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_HELD_BP_SUB  '                     
              DISPLAY ' ** ACCOUNT_NO     '  WS-DELETE-ACCOUNT-NO       
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * INSERT SUB ACCOUNT TO CSS_HELD_BP_SUBS                   *              
      ************************************************************              
                                                                        
       8920-INSERT-OCCURANCES.                                          

MSQ009     EXEC SQL
MSQ009       SAVE TRANSACTION MSQ009-TRNS
MSQ009     END-EXEC
                                                                        
           EXEC SQL                                                     
               FOR :WS-SUB-REC-ROWS-HV
              INSERT INTO CSS_HELD_BP_SUBS
              (ACCOUNT_NO,                                      
                       DATE_BILLED,                                     
                       SEQ_NO,                                          
                       MST_ACCT_NO,                                     
                       PULL_FL,                                         
                       OCC_DATA)
              VALUES                                                   
                      (:WS-SUB-ACCOUNT-NO-HV,                           
                       IIF(TRY_CONVERT(DATE, :WS-DATE-BILLED-HV
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-BILLED-HV
              ) <> 0) OR (LEN(:WS-DATE-BILLED-HV
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-BILLED-HV
              ), CONVERT(DATE, :WS-DATE-BILLED-HV) ),                          
                       :WS-SEQ-NO-HV,                                   
                       :WS-MST-ACCT-NO-HV,                              
                       :WS-PULL-FL-HV,                                  
                       :WS-OCC-DATA-HV)
              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ009
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_HELD_BP_SUBS                                     
MFA-TR*               (ACCOUNT_NO,                                              
MFA-TR*                DATE_BILLED,                                             
MFA-TR*                SEQ_NO,                                                  
MFA-TR*                MST_ACCT_NO,                                             
MFA-TR*                PULL_FL,                                                 
MFA-TR*                OCC_DATA)                                                
MFA-TR*        VALUES                                                           
MFA-TR*               (:WS-SUB-ACCOUNT-NO-HV,                                   
MFA-TR*                :WS-DATE-BILLED-HV,                                      
MFA-TR*                :WS-SEQ-NO-HV,                                           
MFA-TR*                :WS-MST-ACCT-NO-HV,                                      
MFA-TR*                :WS-PULL-FL-HV,                                          
MFA-TR*                :WS-OCC-DATA-HV)                                         
MFA-TR*        FOR :WS-SUB-REC-ROWS-HV ROWS                                     
MFA-TR*        ATOMIC                                                           
MFA-TR*    END-EXEC.                                                            

MSQ009     IF SQLCODE NOT EQUAL 0
MSQ009       MOVE SQLCODE TO MSQ009-SQLCODE
MSQ009       EXEC SQL
MSQ009         CALL CIS.ROLLBACK_SAVEPOINT('MSQ009-TRNS')
MSQ009       END-EXEC
MSQ009       MOVE MSQ009-SQLCODE TO SQLCODE
MSQ009     END-IF
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '****** 8920-INSERT-OCCURANCES        '           
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON INSERT '                            
              DISPLAY ' ** RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY ' ** TABLE CSS_HELD_BP_SUB  '                     
              DISPLAY ' ** ACCOUNT_NO     '  WS-SUB-ACCOUNT-NO-HV(1)    
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      * UPDATE STATUS AS DH IN CSS_CORR_MAIL_STAT FOR DEAD HEADS *              
      ************************************************************              
                                                                        
       8930-UPDATE-CORR-MAIL-STAT.                                      
                                                                        
           MOVE WS-ACCOUNT-NO-MW               TO MW-ACCOUNT-NO.        
           MOVE WS-BARCODE-UNIQUE-ID-MW        TO MW-BARCODE-UNIQUE-ID. 
           MOVE WS-TRACKING-STATUS-CD-MW       TO MW-TRACKING-STATUS-CD.
           MOVE WS-PGRMNAME                    TO MW-APPL-PROGRAM-ID.   
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CORR_MAIL_STAT                                
                  SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD      
                     ,LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()           
                     ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID         
                  WHERE ACCOUNT_NO        = :MW-ACCOUNT-NO              
                    AND BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CORR_MAIL_STAT                                        
MFA-TR*           SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD              
MFA-TR*              ,LAST_UPDATE_TS      = CURRENT TIMESTAMP                   
MFA-TR*              ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID                 
MFA-TR*           WHERE ACCOUNT_NO        = :MW-ACCOUNT-NO                      
MFA-TR*             AND BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               DISPLAY '*** IN 8930 UPDATE CORR MAIL STAT*****'         
               DISPLAY '*** SQL CODE    = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '*** ACCOUNT #   = ' MW-ACCOUNT-NO               
               DISPLAY '*** UNIQUE ID   = ' MW-BARCODE-UNIQUE-ID        
               DISPLAY '*** STATUS      = ' MW-TRACKING-STATUS-CD       
               DISPLAY '*** LAST UPD TS = ' MW-LAST-UPDATE-TS           
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8930-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************00300400
      *     9000-TERMINATE                                             *00300500
      *     CLOSE FILES. IF WORK QUEUE CREATED SET THE RETURN CODE TO 1*00300600
      ******************************************************************00300700
                                                                        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSBE22-FILE                                           
ACT044           EMAILFL                                                
                 FCSBE06-FILE.                                          
                                                                        
            IF WS-SCSCA-WQ-CREATED                                      
                DISPLAY '****************************************'      
                DISPLAY '****************************************'      
                DISPLAY '**  WORK QUEUE CREATED BY CALLED PGM  **'      
                DISPLAY '****************************************'      
                DISPLAY '****************************************'      
                IF RETURN-CODE = 0                                      
                   MOVE 1 TO RETURN-CODE                                
                END-IF                                                  
            END-IF.                                                     
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************00300700
      *                                                                 00303200
      *                                                                         
       9200-SCSCA-ERROR.                                                
                                                                        
           MOVE 12 TO RETURN-CODE.                                      
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           DISPLAY '**  CALLED PGM  = ' WS-DISPLAY-SCSCA.               
           DISPLAY '**  RETURN CODE = ' WS-SCSCA-RETURN-CODE.           
           DISPLAY '**  ACCOUNT     = ' WS-ACCOUNT-NO-AT.               
           DISPLAY '********************************************'.      
           DISPLAY ' '.                                                 
           DISPLAY ' '.                                                 
           DISPLAY '********************************************'.      
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
                                                                        
       9200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************                                         13900000
      *  9700-PROCESS-ABEND  **                                         13920000
      *************************                                         13940000
      *                                                                 13950000
       COPY CPD0023B.                                                   13960000
      *                                                                 13970000
      ******************************************************************        
      *     9900-ABEND                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     19620000
              INCLUDE CPD09900                                          19630000
           END-EXEC.                                                    19640000
      *                                                                         
