       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA104.                                          
       AUTHOR.       GOKUL SATHIYAMOORTHY                               
       DATE-WRITTEN. APRIL 2009.                                        
       DATE-COMPILED.                                                   
      ******************************************************************00060000
      **               SOUTH CAROLINA ELECTRIC & GAS                  **00070000
      **                      COBOL-DB2                               **00080000
      ******************************************************************00090000
      **              PROGRAM  MODIFICATION  LOG                      **00100000
      ******************************************************************00110000
      ** DATE     USERID   REASON                                     **00120000
      ** -------  -------  ------                                     **00130000
      ** 04/2009  GOKUL    INITIAL VERSION.                           **00140000
A01354** 06/2009  BED      ADD DATE TO VSAM SELECTION                 **00150000
A37741** 11/2009  MC95456  DECLARED  S-RETURN-CODE REPECTIVE TO       **00160000
A37741**                   CPD00067  CHANGES                          **00170000
A02119** 02/2010  SV82012  UPDATE TRACKING STATUS CD AS RB FOR REBILLS**00180000
A02119**                   IN CSS_CORR_MAIL_STAT.                     **00190000
A02119** 02/2010  SV82012  DUPLICATE BILL COPY RELEASE  FROM ONLINE BILL00200000
A02119**          ACT 18   VIEW HAVE THE ORIGINAL COPIES UNIQUE ID.   **00210000
A02119** 03/2010  DMS      IN 8300- PARAGRAPH CONTINUE PROCESSING WHEN**00220000
      **                   ROW IS NOT FOUND.                          **00230000
A02119** 05/2010  SV82012  INCLUDE THE NEW EXCEPTION CODES TO PROCESS **00240000
A02501** 06/2010  DMS      WRITE ACCOUNTS NOT FOUND IN THE VSAM TO    **00250000
A02501**                   A REPORT                                   **00260000
A02003** 09/2010  ST       BUG FIX - THIRD PARTY 002 RECORD ISSUE     **00270000
PRJ400** 12/2010  ESM      ADD PAPERLESS EXCEPTION TO OLBV            **00280000
A03019** 09/2011  ESM      ADD CODE TO UPDATE CSS_CORR_MAIL_STAT FOR  **00281000
A03019**                   "REMOVED" ACCOUNT  FROM OLBV.              **00282000
ACT052** 02/2015  BD09555  REPLACE VSAM FILE WITH CSS_EXCP_BILL_DET   **00283000
ACT052**A05460-ACT052      TABLE                                      **00284000
P00836** 02/2016  ESM      ADD CODE TO SET THE CORRECT COMM TYPE AND  **00284100
P00836**                   SUBTYPE FOR MEMO AND THIRD PARTY BILLS.    **00284200
ACT052** 02/2015  BD09555  CORRECT PAPERLESS PROCESSING.  REMOVE      **00284300
ACT052**A05460-ACT052      VSAM REFERENCES                            **00284400
      ******************************************************************00285000
                                                                        
      ******************************************************************00287000
      **                     PROGRAM SUMMARY                          **00288000
      ******************************************************************00289000
      ** THIS PROGRAM HANDLES THE PROCESSING OF EXCEPTION BILLS.      **00290000
      **         A. UNLOAD THE ACCOUNTS THAT NEED TO BE PROCESSED.    **00300000
      **         B. UNLOAD THE BE28 DATA FROM VSAM FOR ACCOUNTS TO    **00310000
      **            PRINT.                                            **00320000
      **         C. DELETE THE ROWS THAT HAVE BEEN PROCESSED FROM DB2.**00330000
      **         D. FLAG THE DELETED ACCOUNTS IN VSAM.                **00340000
      ******************************************************************00350000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                 00420000
           SELECT EXCPBE28-FILE  ASSIGN TO       EXCPBE28               
                                 STATUS       IS WS-EXCPBE28-STATUS.    
      *                                                                 00450000
A02501*** REPORT FILE DECLARATION                                       00460000
A02501     SELECT FCSP1041-FILE                                         
A02501         ASSIGN UT-S-FCSP1041                                     
A02501         FILE STATUS IS WS-F1041-STATUS.                          
      *                                                                 00500000
      *                                                                 00510000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                 00540000
       FD  EXCPBE28-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FIOBE28                     PIC X(1200).                     
      *                                                                 00610000
A02501*** REPORT FILE STRUCTURE.                                        00620000
A02501 FD  FCSP1041-FILE                                                
A02501     BLOCK CONTAINS 0 RECORDS                                     
A02501     RECORDING MODE IS F                                          
A02501     LABEL RECORDS ARE STANDARD.                                  
A02501 01  WS-PRT1041-RECORD                  PIC X(80).                
      *                                                                 00680000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA104'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-NOOPS-STRUCTURE.                                          
           05  WS-NOOP-IDX-DATA.                                        
               10  FILLER              PIC X(6)   VALUE SPACES.         
               10  WS-NOOP-IDX         PIC X(6)   VALUE SPACES.         
                   88  NOOP-RECORD                VALUE 'IDX@@@'.       
           05  FILLER                  PIC X      VALUE '~'.            
PRJ400     05  WS-NOOP-BILL-DATE.                                       
PRJ400         10  WS-NOOP-BILL-DT-MM  PIC X(02).                       
PRJ400         10  FILLER              PIC X(01).                       
PRJ400         10  WS-NOOP-BILL-DT-DD  PIC X(02).                       
PRJ400         10  FILLER              PIC X(01).                       
PRJ400         10  WS-NOOP-BILL-DT-CC  PIC X(02).                       
PRJ400         10  WS-NOOP-BILL-DT-YY  PIC X(02).                       
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-CORRES-TYPE     PIC X(4)   VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-CUST-NO         PIC X(10)  VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-ACCT-NO         PIC X(13)  VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-BILL-NO         PIC 9(9)   VALUE 0.              
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-BILL-DEST-CD    PIC X      VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-BILL-PULL-CD    PIC X      VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-TOTAL-PAGES     PIC 9(9)   VALUE 0.              
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-BILL-IMAGE-FL   PIC X      VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-COMPANY-NO      PIC X(2)   VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-BILL-TYPE       PIC X(2)   VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-MAIL-DTL        PIC X(312) VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-BRCODE-ZIP      PIC X(11)  VALUE SPACES.         
           05  FILLER                  PIC X      VALUE '~'.            
           05  WS-NOOP-ACCT-ZIP        PIC X(9)   VALUE SPACES.         
PRJ166     05  FILLER                  PIC X      VALUE '~'.            
PRJ166     05  WS-NOOP-BILL-UNIQID     PIC X(9)   VALUE SPACES.         
PRJ400     05  FILLER                  PIC X      VALUE '~'.            
PRJ400     05  WS-NOOP-TRK-STATUS      PIC X(2)   VALUE SPACES.         
PRJ400     05  FILLER                  PIC X      VALUE '~'.            
PRJ400     05  WS-NOOP-EDI-DEST-FL     PIC X(1)   VALUE SPACES.         
PRJ400     05  FILLER                  PIC X      VALUE '~'.            
PRJ400     05  WS-NOOP-NO-COPIES       PIC X(1)   VALUE SPACES.         
                                                                        
       01  5J-BILL-IMAGE-SEQ.                                           
           49  5J-BILL-IMAGE-SEQ-LEN   PIC S9(4) COMP.                  
           49  5J-BILL-IMAGE-SEQ-TEXT  PIC X(1200).                     
       01  WS-EXT-IO-AREA              PIC X(1200).                     
       01  FILLER REDEFINES WS-EXT-IO-AREA.                             
           05  WS-AREA-1               PIC X(25).                       
           05  WS-RECORD-TYPE          PIC X(03).                       
                88  ACCT-RECORD        VALUE '001'.                     
                88  BILL-RECORD        VALUE '002'.                     
           05  WS-AREA-2               PIC X(50).                       
           05  WS-MAIL-DATA            PIC X(312).                      
           05  FILLER REDEFINES WS-MAIL-DATA.                           
               10  FILLER              PIC X(11).                       
               10  WS-BILL-TYPE        PIC X(2).                        
               10  FILLER              PIC X(299).                      
           05  WS-BARCODE-ZIP          PIC X(11).                       
           05  FILLER                  PIC X(18).                       
           05  WS-ACCT-ZIP             PIC X(9).                        
           05  WS-BE28-DATA            PIC X(772).                      
           05  FILLER REDEFINES WS-BE28-DATA.                           
               10  FILLER              PIC X(318).                      
               10  WS-BILL-UNIQID      PIC X(9).                        
P00836         10  FILLER              PIC X(66).                       
P00836         10  WS-BILL-COMM-TYPE   PIC X(02).                       
P00836         10  WS-BILL-COMM-SUBTYPE PIC X(02).                      
P00836         10  FILLER              PIC X(375).                      
                                                                        
       01  WS-TRANS-COMMENTS.                                           
           05  WS-EDIT-COMMENTS        PIC X(74)  VALUE                 
             'BILL NOT MAILED TO CUSTOMER. BILL WILL BE CORRECTED THROUG01420000
      -      'H EDITING.  '.                                            01430000
           05  WS-REBILL-COMMENTS      PIC X(74)  VALUE                 
             'BILL NOT MAILED TO CUSTOMER. BILL WILL BE CORRECTED THROUG01450000
      -      'H CANCEL/REBILL.'.                                        01460000
           05  WS-PRINT-COMMENTS       PIC X(74)  VALUE                 
             'BILL RELEASED FOR BATCH PRINT TO BE MAILED TO CUSTOMER.'. 
PRJ400     05  WS-PAPERLESS-COMMENTS   PIC X(74)  VALUE                 
PRJ400       'PAPERLESS BILL IMAGE RELEASED FOR VIEWING.'.              
PRJ400     05  WS-ACCT-REMOVED.                                         
PRJ400         10  FILLER              PIC X(15)  VALUE                 
PRJ400                                 'BILL IMAGE FOR '.               
PRJ400         10  WS-ACCT-REM-MM      PIC X(02).                       
PRJ400         10  FILLER              PIC X(01)  VALUE '/'.            
PRJ400         10  WS-ACCT-REM-DD      PIC X(02).                       
PRJ400         10  FILLER              PIC X(01)  VALUE '/'.            
PRJ400         10  WS-ACCT-REM-YY      PIC X(02).                       
PRJ400         10  FILLER              PIC X(19)  VALUE                 
PRJ400                                 ' REMOVED FROM VIEW.'.           
PRJ400         10  FILLER              PIC X(32)  VALUE SPACES.         
                                                                        
A37741 01  S-RETURN-CODE               PIC S9(9) VALUE 0.               
                                                                        
A02501 01  WS-BLANK-LINE               PIC X(80) VALUE SPACES.          
                                                                        
       01  WS-MISC.                                                     
           05  WS-EXCPBE28-STATUS      PIC XX     VALUE '00'.           
               88  EXCPBE28-SUCCESSFUL            VALUE '00'.           
A02501     05  WS-F1041-STATUS         PIC XX     VALUE '00'.           
A02501         88  FC1041-SUCCESSFUL              VALUE '00'.           
           05  WS-REC-LEN              PIC 9(04)  COMP.                 
           05  WS-TRAN-APPL-NO         PIC 9(04)  COMP.                 
           05  WS-HOLD-NOOPS-DATA      PIC X(430) VALUE SPACES.         
           05  FILLER REDEFINES WS-HOLD-NOOPS-DATA.                     
               10 FILLER               PIC X(6).                        
               10 WS-HOLD-NOOPS        PIC X(424).                      
           05  WS-TIMESTAMP            PIC X(26)  VALUE SPACES.         
           05  WS-ACCT-CHANGE          PIC X      VALUE ' '.            
           05  WS-DELIMITER            PIC X      VALUE '~'.            
           05  WS-Y                    PIC X      VALUE 'Y'.            
A02501     05  WS-N                    PIC X(01)  VALUE 'N'.            
A02501     05  WS-CURRENT-DATE.                                         
A02501         10  WS-CURRENT-CCYY     PIC 9(04).                       
A02501         10  WS-CURRENT-MM       PIC 9(02).                       
A02501         10  WS-CURRENT-DD       PIC 9(02).                       
A02501         10  WS-CURRENT-HH       PIC 9(02).                       
A02501         10  WS-CURRENT-MS       PIC 9(02).                       
A02501         10  WS-CURRENT-SS       PIC 9(02).                       
A02501     05  WS-FIRST-ACCT-NOTFOU-SW PIC X(01)  VALUE 'Y'.            
A02501         88 FIRST-ACCT-NF-REP               VALUE 'Y'.            
A02501     05  WS-ACCT-NOTFND-CNT      PIC 9(07)  VALUE ZERO.           
A02501     05  WS-ACCT-NOTFND-MAX      PIC 9(03)  VALUE 10.             
A02501     05  WS-ACCT-FOUND-FL        PIC X      VALUE 'Y'.            
A02501     05  WS-RUN-DATE             PIC X(10).                       
A02501     05  WS-RUN-DATE-1           PIC X(10).                       
PRJ400     05  WS-TRACKING-STATUS-CODE.                                 
PRJ400         10  WS-TRACKING-STATUS-C1    PIC X(01) VALUE SPACES.     
PRJ400         10  WS-TRACKING-STATUS-C2    PIC X(01) VALUE SPACES.     
PRJ400     05  WS-COMP-TYPE-CD         PIC X(01).                       
PRJ400         88 PAPERLESS-ACCT       VALUE 'Q' 'K' 'L' 'H' 'J' 'M'.   
A02501     05  WS-RPT1-HEAD            PIC X(42)  VALUE                 
A02501         '   ACCOUNTS NOT FOUND IN CSS_EXCP_BILL_DET'.            
A02501     05  WS-RPT1-CSR-TITLE            PIC X(38)     VALUE         
A02501         '                   SCEG/PSNC          '.                
A02501     05  WS-RPT1-SEBD-TITLE           PIC X(38)     VALUE         
A02501         '                   SCANA ENERGY       '.                
A02501     05  WS-RPT1-SEBR-TITLE           PIC X(38)     VALUE         
A02501         '     SCANA ENERGY REGULATED DIVISION  '.                
A02501     05  WS-RPT1-SVC-TITLE            PIC X(38)     VALUE         
A02501         '                   SERVICECARE        '.                
A02501 01  WS-RPT-HEADER-LINE-1.                                        
A02501     05  FILLER                   PIC X(03)  VALUE SPACES.        
A02501     05  FILLER                   PIC X(07)  VALUE 'DATE: '.      
A02501     05  WS-RPT-DATE              PIC X(10).                      
A02501     05  FILLER                   PIC X(03)  VALUE SPACES.        
A02501     05  FILLER                   PIC X(11)  VALUE 'RUN TIME:  '. 
A02501     05  WS-RPT-RUN-TIME          PIC X(08).                      
A02501     05  WS-RPT-TITLE             PIC X(38).                      
A02501*                                                                 02240000
A02501 01  WS-RPT-HEADER-LINE-2.                                        
A02501     05  FILLER                   PIC X(02) VALUE SPACES.         
A02501     05  WS-RPT-NAME              PIC X(12) VALUE 'PCSCA104-001'. 
A02501     05  FILLER                   PIC X(15) VALUE SPACES.         
A02501     05  WS-RPT-HEAD              PIC X(38).                      
A02501     05  FILLER                   PIC X(13) VALUE SPACES.         
A02501*                                                                 02310000
A02501 01  WS-RPT-HEADER-LINE-3.                                        
A02501     05  FILLER                   PIC X(05) VALUE SPACES.         
A02501     05  FILLER                   PIC X(14)                       
A02501                                     VALUE 'ACCOUNT NUMBER'.      
A02501     05  FILLER                   PIC X(07) VALUE SPACES.         
A02501     05  FILLER                   PIC X(10)                       
A02501                                     VALUE 'BILL DATE'.           
A02501     05  FILLER                   PIC X(08) VALUE SPACES.         
A02501     05  FILLER                   PIC X(08)                       
A02501                                     VALUE 'VSAM KEY'.            
A02501     05  FILLER                   PIC X(28) VALUE SPACES.         
A02501*                                                                 02430000
A02501 01  WS-RPT-HEADER-LINE-4.                                        
A02501     05  FILLER                   PIC X(80) VALUE ALL '-'.        
A02501*                                                                 02460000
A02501 01  WS-RPT-DETAIL-LINE-NOTFOU.                                   
A02501     05  FILLER                      PIC X(05)  VALUE SPACES.     
A02501     05  WS-RPT-ACCOUNT-NO           PIC X(13).                   
A02501     05  FILLER                      PIC X(08)  VALUE SPACES.     
A02501     05  WS-RPT-BILL-DATE            PIC X(10).                   
A02501     05  FILLER                      PIC X(08)  VALUE SPACES.     
A02501     05  WS-RPT-VSAM-KEY.                                         
A02501         10  WS-RPT-VSAM-ACCOUNT-NO      PIC 9(13).               
A02501         10  WS-RPT-VSAM-BILL-DATE       PIC X(10).               
A02501         10  WS-RPT-VSAM-SEQ-NO          PIC 9(9).                
A02501         10  WS-RPT-VSAM-SUB-SEQ-NO      PIC 9(4).                
      *                                                                 02580000
                                                                        
       COPY CWS00303.                                                   02600000
       COPY CWS00010.                                                   02610000
       COPY CWS09900.                                                   02620000
                                                                        
           EXEC SQL                                                     02640000
               INCLUDE SQLCA                                            02650000
           END-EXEC.                                                    02660000
                                                                        
           EXEC SQL                                                     02680000
               INCLUDE FIOCA716                                         02690000
           END-EXEC.                                                    02700000
                                                                        
      * COBOL DECLARATION FOR TABLE CSS_EXCEPTION_BILLS                 02720000
      *                                                                 02730000
           EXEC SQL                                                     02740000
               INCLUDE TBBILLEX                                         02750000
           END-EXEC.                                                    02760000
                                                                        
      * COBOL DECLARATION FOR TABLE CSS_ACCOUNT                         02780000
      *                                                                 02790000
           EXEC SQL                                                     02800000
               INCLUDE TBACCT                                           02810000
           END-EXEC.                                                    02820000
                                                                        
      * COBOL DECLARATION FOR TABLE CSS_MNT_TRANS_HIST                  02840000
      *                                                                 02850000
           EXEC SQL                                                     02860000
               INCLUDE TBMNHIST                                         02870000
           END-EXEC.                                                    02880000
                                                                        
      * COBOL DECLARATION FOR TABLE CSS_MT_TRN_HST_DET                  02900000
      *                                                                 02910000
           EXEC SQL                                                     02920000
               INCLUDE TBMNHDT                                          02930000
           END-EXEC.                                                    02940000
                                                                        
A02119* COBOL DECLARATION FOR TABLE CSS_CORR_MAIL_STAT MW               02960000
A02119*                                                                 02970000
A02119       EXEC SQL                                                   02980000
A02119           INCLUDE TBMAILST                                       02990000
A02119       END-EXEC.                                                  03000000
A02119*                                                                 03010000
           EXEC SQL                                                     
               DECLARE GET_EXCBILL CURSOR FOR                           
                  SELECT  DATE_BILLED                                   
                         ,COMPANY_NO                                    
                         ,ACCOUNT_NO                                    
                         ,DEST_CD                                       
                         ,PULL_CD                                       
                         ,BILL_NO                                       
                         ,BILL_IMAGE_SEQ                                
                         ,COMPANY_TYPE_CD                               
                         ,ACCOUNT_SEQ_NO                                
                         ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
                         ,LAST_UPDATE_USERID                            
                         ,BILL_DISP_CD                                  
                         ,BILL_IMAGE                                    
                    FROM CSS_EXCEPTION_BILL WITH(READUNCOMMITTED)               
                   WHERE BILL_DISP_CD IN ('P', 'E', 'R','M','L')        
                    ORDER BY  ACCOUNT_NO                                
                             ,BILL_IMAGE_SEQ                            
                             ,ACCOUNT_SEQ_NO                            
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03020000
MFA-TR*        DECLARE GET_EXCBILL CURSOR FOR                           03030000
MFA-TR*           SELECT  DATE_BILLED                                   03040000
MFA-TR*                  ,COMPANY_NO                                    03050000
MFA-TR*                  ,ACCOUNT_NO                                    03060000
MFA-TR*                  ,DEST_CD                                       03070000
MFA-TR*                  ,PULL_CD                                       03080000
MFA-TR*                  ,BILL_NO                                       03090000
MFA-TR*                  ,BILL_IMAGE_SEQ                                03100000
MFA-TR*                  ,COMPANY_TYPE_CD                               03110000
MFA-TR*                  ,ACCOUNT_SEQ_NO                                03120000
MFA-TR*                  ,LAST_UPDATE_TS                                03130000
MFA-TR*                  ,LAST_UPDATE_USERID                            03140000
MFA-TR*                  ,BILL_DISP_CD                                  03150000
MFA-TR*                  ,BILL_IMAGE                                    03160000
MFA-TR*             FROM CSS_EXCEPTION_BILL                             03170000
MFA-TR*            WHERE BILL_DISP_CD IN ('P', 'E', 'R','M','L')        03180000
MFA-TR*             ORDER BY  ACCOUNT_NO                                03190000
MFA-TR*                      ,BILL_IMAGE_SEQ                            03200000
MFA-TR*                      ,ACCOUNT_SEQ_NO                            03210000
MFA-TR*             FOR FETCH ONLY WITH UR                              03220000
MFA-TR*    END-EXEC.                                                    03230000
                                                                        
ACT052     EXEC SQL                                                     
ACT052         DECLARE EXCP_BILL_DET_CSR CURSOR FOR                     
ACT052            SELECT  BILL_IMAGE                                    
ACT052              FROM CSS_EXCP_BILL_DET WITH(READUNCOMMITTED)                
ACT052             WHERE ACCOUNT_NO     = :JW-ACCOUNT-NO     AND        
ACT052                   BILL_IMAGE_SEQ = :JW-BILL-IMAGE-SEQ AND        
ACT052                   DATE_BILLED    = IIF(TRY_CONVERT(DATE, 
                                                        :JW-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :JW-DATE-BILLED
              ) <> 0) OR (LEN(:JW-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :JW-DATE-BILLED
              ), CONVERT(DATE, :JW-DATE-BILLED) )               
ACT052              ORDER BY ACCOUNT_SEQ_NO                             
ACT052              FOR READ ONLY                               
ACT052     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     03250000
MFA-TR*        DECLARE EXCP_BILL_DET_CSR CURSOR FOR                     03260000
MFA-TR*           SELECT  BILL_IMAGE                                    03270000
MFA-TR*             FROM CSS_EXCP_BILL_DET                              03280000
MFA-TR*            WHERE ACCOUNT_NO     = :JW-ACCOUNT-NO     AND        03281000
MFA-TR*                  BILL_IMAGE_SEQ = :JW-BILL-IMAGE-SEQ AND        03282000
MFA-TR*                  DATE_BILLED    = :JW-DATE-BILLED               03283000
MFA-TR*             ORDER BY ACCOUNT_SEQ_NO                             03284000
MFA-TR*             FOR FETCH ONLY WITH UR                              03285000
MFA-TR*    END-EXEC.                                                    03286000
                                                                        
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           05  WS-PARM-LENGTH          PIC S9(04) COMP.                 
PRJ400     05  WS-PROCESS-PARM         PIC X(05).                       
           05  FILLER REDEFINES WS-PROCESS-PARM.                        
               10 FILLER               PIC X(03).                       
               10 WS-PROCESS-FLAG      PIC X.                           
PRJ400         10 WS-PROCESS-FLAG-PL   PIC X.                           
                                                                        
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
                                                                        
      ***************************************************************** 03380000
      *  PERFORM THE INITIALIZATION ROUTINE                           * 03390000
      *  CREATE BE28 FROM CSS_EXCP_BILL_DET                           * 03391000
      *  INSERT TRANSACTION HISTORY                                   * 03400000
      *  DELETE PROCESSED ACCOUNTS FROM CSS_EXCEPTION_BILL            * 03401000
      *  FLAG PROCESSED ACCOUNTS IN CSS_EXCP_BILL_DET FOR DELTION IN A* 03402000
      *  LATER PROGRAM.                                               * 03403000
      ***************************************************************** 03410000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION     THRU 0100-EXIT.              
           PERFORM 1000-PROCESS-ACCOUNTS   THRU 1000-EXIT.              
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 03530000
      *  OPEN FILES.                                                  * 03540000
      ***************************************************************** 03550000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN OUTPUT EXCPBE28-FILE.                                   
A02501     OPEN OUTPUT FCSP1041-FILE.                                   
                                                                        
           IF WS-EXCPBE28-STATUS NOT = '00'                             
               DISPLAY '**************************************'         
               DISPLAY '**   0100-INITIALIZATION              '         
               DISPLAY '**   ERROR OPENING EXCPBE28'                    
               DISPLAY '**   FILE STATUS = ' WS-EXCPBE28-STATUS         
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
A02501     IF NOT FC1041-SUCCESSFUL                                     
A02501         DISPLAY '**************************************'         
A02501         DISPLAY '**   0100-INITIALIZE                  '         
A02501         DISPLAY '**   ERROR OPENING FCSC1661'                    
A02501         DISPLAY '**   FILE STATUS = ' WS-F1041-STATUS            
A02501         DISPLAY '**************************************'         
A02501         PERFORM 9900-ABEND              THRU 9900-EXIT           
A02501     END-IF.                                                      
                                                                        
           IF WS-PARM-LENGTH = 0                                        
              MOVE SPACES                   TO WS-PROCESS-PARM          
           END-IF.                                                      
                                                                        
A02501     INITIALIZE                          WS-ACCT-NOTFND-CNT       
A02501                                         WS-ACCT-FOUND-FL.        
                                                                        
A02501*****GENERATE DATA FOR REPORT HEADING                             03870000
A02501     MOVE FUNCTION CURRENT-DATE(1:14)                             
A02501                                 TO WS-CURRENT-DATE.              
A02501     STRING    WS-CURRENT-MM                                      
A02501               '-'                                                
A02501               WS-CURRENT-DD                                      
A02501               '-'                                                
A02501               WS-CURRENT-CCYY                                    
A02501               DELIMITED BY SIZE                                  
A02501                                 INTO WS-RUN-DATE.                
A02501     STRING    WS-CURRENT-CCYY                                    
A02501               '-'                                                
A02501               WS-CURRENT-MM                                      
A02501               '-'                                                
A02501               WS-CURRENT-DD                                      
A02501               DELIMITED BY SIZE                                  
A02501                                 INTO WS-RUN-DATE-1.              
A02501     MOVE WS-RUN-DATE            TO WS-RPT-DATE.                  
A02501     STRING    WS-CURRENT-HH                                      
A02501               ':'                                                
A02501               WS-CURRENT-MS                                      
A02501               ':'                                                
A02501               WS-CURRENT-SS                                      
A02501               DELIMITED BY SIZE                                  
A02501                                 INTO WS-RPT-RUN-TIME.            
A02501*****DETERMINE WHICH COMPANY IS BEING PROCESSED                   04120000
A02501     EVALUATE WS-PROCESS-PARM                                     
A02501         WHEN SPACES                                              
A02501            MOVE WS-RPT1-CSR-TITLE       TO WS-RPT-TITLE          
A02501         WHEN 'SEBD'                                              
A02501            MOVE WS-RPT1-SEBD-TITLE      TO WS-RPT-TITLE          
A02501         WHEN 'SEBR'                                              
A02501            MOVE WS-RPT1-SEBR-TITLE      TO WS-RPT-TITLE          
A02501         WHEN 'SERV'                                              
A02501            MOVE WS-RPT1-SVC-TITLE       TO WS-RPT-TITLE          
A02501     END-EVALUATE.                                                
A02501*****                                                             04230000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      04280000
      *   MAIN PROCESS PARA.                                     *      04290000
      ************************************************************      04300000
                                                                        
       1000-PROCESS-ACCOUNTS.                                           
                                                                        
                                                                        
           PERFORM 7100-OPEN-EXCP-CURSOR    THRU 7100-EXIT.             
           PERFORM 7200-FETCH-EXCP-CURSOR   THRU 7200-EXIT.             
                                                                        
           PERFORM 2500-CREATE-BE28         THRU 2500-EXIT              
                   UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
                                                                        
           PERFORM 7300-CLOSE-EXCP-CURSOR   THRU 7300-EXIT.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      04460000
      *   PARSE THE NOOP RECORD TO READ DATA DELIMITED BY ~      *      04470000
      ************************************************************      04480000
                                                                        
       2100-PARSE-NOOP-REC.                                             
                                                                        
           INITIALIZE                          WS-NOOPS-STRUCTURE.      
                                                                        
           UNSTRING                            WS-HOLD-NOOPS            
           DELIMITED BY                        WS-DELIMITER             
           INTO                                WS-NOOP-IDX-DATA         
                                               WS-NOOP-BILL-DATE        
                                               WS-NOOP-CORRES-TYPE      
                                               WS-NOOP-CUST-NO          
                                               WS-NOOP-ACCT-NO          
                                               WS-NOOP-BILL-NO          
                                               WS-NOOP-BILL-DEST-CD     
                                               WS-NOOP-BILL-PULL-CD     
                                               WS-NOOP-TOTAL-PAGES      
                                               WS-NOOP-BILL-IMAGE-FL    
                                               WS-NOOP-COMPANY-NO       
                                               WS-NOOP-BILL-TYPE        
                                               WS-NOOP-MAIL-DTL         
                                               WS-NOOP-BRCODE-ZIP       
                                               WS-NOOP-ACCT-ZIP         
                                               WS-NOOP-BILL-UNIQID      
PRJ400                                         WS-NOOP-TRK-STATUS       
PRJ400                                         WS-NOOP-EDI-DEST-FL      
PRJ400                                         WS-NOOP-NO-COPIES.       
                                                                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      04800000
      *   CREATE THE BE28 FILE FROM THE CSS_EXCP_BILL_DET TABLE. *      04810000
      ************************************************************      04820000
                                                                        
       2500-CREATE-BE28.                                                
                                                                        
           PERFORM 7600-GET-TIMESTAMP       THRU 7600-EXIT.             
           MOVE SPACES                      TO WS-HOLD-NOOPS.           
           MOVE SPACES                      TO WS-ACCT-CHANGE.          
PRJ400     INITIALIZE                          WS-TRACKING-STATUS-CODE  
PRJ400                                         WS-COMP-TYPE-CD.         
           MOVE JW-BILL-IMAGE-TEXT          TO WS-HOLD-NOOPS-DATA.      
           PERFORM 2100-PARSE-NOOP-REC      THRU 2100-EXIT.             
                                                                        
PRJ400     MOVE WS-NOOP-TRK-STATUS          TO WS-TRACKING-STATUS-CODE. 
PRJ400     MOVE JW-COMPANY-TYPE-CD          TO WS-COMP-TYPE-CD.         
                                                                        
           IF WS-PROCESS-FLAG = JW-COMPANY-TYPE-CD                      
           OR WS-PROCESS-FLAG-PL = JW-COMPANY-TYPE-CD                   
           OR WS-PROCESS-FLAG = ' '                                     
                                                                        
              DISPLAY 'PROCESSING ACCOUNT '    WS-NOOP-ACCT-NO          
              DISPLAY '    STARTING BILL DETAILS RETRIEVAL'             
              PERFORM 8700-OPEN-EXCP-BILL-DET   THRU 8700-EXIT          
              PERFORM 8800-FETCH-EXCP-BILL-DET  THRU 8800-EXIT          
              IF SQLCODE = SUCCESSFUL-CALL                              
                  PERFORM UNTIL SQLCODE = NOT-FOUND                     
ACT052                PERFORM 2600-PROCESS-DETAILS      THRU 2600-EXIT  
ACT052                PERFORM 8800-FETCH-EXCP-BILL-DET  THRU 8800-EXIT  
ACT052            END-PERFORM                                           
              ELSE                                                      
                  PERFORM 7400-CHECK-NOT-FOUND       THRU 7400-EXIT     
              END-IF                                                    
              PERFORM 8900-CLOSE-EXCP-BILL-DET   THRU 8900-EXIT         
ACT052        DISPLAY '    BILL DETAILS PROCESSING COMPLETE '           
              DISPLAY '    STARTING TRANS HISTORY PROCESSING'           
              PERFORM 2700-INSERT-TRANS-HIST        THRU 2700-EXIT      
              DISPLAY '    TRANS HISTORY PROCESSING COMPLETE'           
              PERFORM 8200-DELETE-EXCP-BILLS        THRU 8200-EXIT      
A02119        DISPLAY '    UPDATE CSS_CORR_MAIL_STATS FOR REBILLS '     
ACT052        EVALUATE TRUE                                             
ACT052            WHEN JW-BILL-DISP-CD = 'R'                            
ACT052               MOVE 'RB'             TO MW-TRACKING-STATUS-CD     
ACT052               PERFORM 8300-UPDATE-CORR-MAIL-STAT                 
ACT052                                                THRU 8300-EXIT    
ACT052            WHEN JW-BILL-DISP-CD = 'M'                            
ACT052               MOVE 'MG'             TO MW-TRACKING-STATUS-CD     
ACT052               PERFORM 8300-UPDATE-CORR-MAIL-STAT                 
ACT052                                                THRU 8300-EXIT    
ACT052            WHEN PAPERLESS-ACCT                                   
ACT052               MOVE '0'              TO WS-TRACKING-STATUS-C1     
ACT052               MOVE WS-TRACKING-STATUS-CODE                       
ACT052                                     TO MW-TRACKING-STATUS-CD     
ACT052               PERFORM 8300-UPDATE-CORR-MAIL-STAT                 
ACT052        END-EVALUATE                                              
           END-IF.                                                      
           PERFORM 7200-FETCH-EXCP-CURSOR   THRU 7200-EXIT.             
                                                                        
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05410000
      *   PROCESS THE EXCEPTION DETAILS.                         *      05420000
      ************************************************************      05430000
                                                                        
       2600-PROCESS-DETAILS.                                            
                                                                        
           IF  JW-BILL-DISP-CD = 'P'                                    
P00836        AND ((WS-NOOP-BILL-TYPE = 'MB' OR 'TP' OR 'FM' OR 'FT') OR
A02119              WS-NOOP-BILL-IMAGE-FL = 'D')                        
A02119           IF ACCT-RECORD AND                                     
P00836              (WS-NOOP-BILL-TYPE = 'MB' OR 'TP' OR 'FM' OR 'FT')  
                    MOVE SPACES             TO WS-MAIL-DATA             
                                               WS-ACCT-ZIP              
                                               WS-BARCODE-ZIP           
                    MOVE WS-NOOP-MAIL-DTL   TO WS-MAIL-DATA             
                    MOVE WS-NOOP-ACCT-ZIP   TO WS-ACCT-ZIP              
                    MOVE WS-NOOP-BRCODE-ZIP TO WS-BARCODE-ZIP           
                 END-IF                                                 
                                                                        
                 IF BILL-RECORD                                         
                    MOVE SPACES             TO WS-BILL-TYPE             
                    MOVE WS-NOOP-BILL-TYPE  TO WS-BILL-TYPE             
PRJ166              MOVE SPACES             TO WS-BILL-UNIQID           
PRJ166              MOVE WS-NOOP-BILL-UNIQID                            
PRJ166                                      TO WS-BILL-UNIQID           
P00836              IF WS-NOOP-BILL-TYPE = ('TP' OR 'FT')               
P00836                 MOVE '06'            TO WS-BILL-COMM-TYPE        
P00836                 MOVE '44'            TO WS-BILL-COMM-SUBTYPE     
P00836              END-IF                                              
P00836              IF WS-NOOP-BILL-TYPE = ('MB' OR 'FM')               
P00836                 MOVE '06'            TO WS-BILL-COMM-TYPE        
P00836                 MOVE '45'            TO WS-BILL-COMM-SUBTYPE     
P00836              END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF JW-BILL-DISP-CD = 'P'                                  
                 PERFORM 8000-WRITE-FCSBE28 THRU 8000-EXIT              
              END-IF                                                    
                                                                        
              IF ACCT-RECORD                                            
                  PERFORM 8100-UPDATE-EXCP-BILL-DET   THRU 8100-EXIT    
              END-IF.                                                   
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      05800000
      *   INSERT TRANSACTION HISTORY ROWS                        *      05810000
      ************************************************************      05820000
                                                                        
       2700-INSERT-TRANS-HIST.                                          
                                                                        
           PERFORM 7700-GET-ACCOUNT-DETAILS                             
                                          THRU 7700-EXIT.               
                                                                        
           MOVE SPACES                    TO MH-TRAN-COMMENT-TEXT       
                                             MI-CHG-COLUMN-VALUE-TEXT.  
           EVALUATE JW-BILL-DISP-CD                                     
              WHEN 'E'                                                  
                 MOVE 'EXCEPTION BILL TO BE EDITED'                     
                                          TO                            
                                             MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE WS-EDIT-COMMENTS    TO MH-TRAN-COMMENT-TEXT       
                                                                        
              WHEN 'R'                                                  
                 MOVE 'EXCEPTION BILL CANCEL REBILLED'                  
                                          TO                            
                                             MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE WS-REBILL-COMMENTS  TO MH-TRAN-COMMENT-TEXT       
                                                                        
              WHEN 'P'                                                  
                 MOVE 'EXCEPTION BILL PRINTED '                         
                                          TO                            
                                             MI-CHG-COLUMN-VALUE-TEXT   
                 MOVE WS-PRINT-COMMENTS   TO MH-TRAN-COMMENT-TEXT       
PRJ400        WHEN 'M'                                                  
PRJ400           MOVE 'EXCEPTION BILL REMOVED '                         
PRJ400                                    TO                            
PRJ400                                       MI-CHG-COLUMN-VALUE-TEXT   
PRJ400           MOVE WS-NOOP-BILL-DT-MM  TO WS-ACCT-REM-MM             
PRJ400           MOVE WS-NOOP-BILL-DT-DD  TO WS-ACCT-REM-DD             
PRJ400           MOVE WS-NOOP-BILL-DT-YY  TO WS-ACCT-REM-YY             
PRJ400           MOVE WS-ACCT-REMOVED     TO MH-TRAN-COMMENT-TEXT       
PRJ400        WHEN 'L'                                                  
PRJ400           MOVE 'PAPERLESS EXCP BILL RELEASED'                    
PRJ400                                    TO                            
PRJ400                                       MI-CHG-COLUMN-VALUE-TEXT   
PRJ400           MOVE WS-PAPERLESS-COMMENTS TO MH-TRAN-COMMENT-TEXT     
              WHEN OTHER                                                
                 MOVE 'UNKNOWN ACTION'    TO MI-CHG-COLUMN-VALUE-TEXT   
           END-EVALUATE.                                                
                                                                        
           MOVE WS-TIMESTAMP              TO MH-TRANS-HIST-SEQ-NO       
           MOVE WS-TIMESTAMP              TO MH-DATE-TRANS.             
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE          
           MOVE WS-NOOP-ACCT-NO           TO MH-ACCOUNT-NO              
           MOVE AT-CUSTOMER-NO            TO MH-CUSTOMER-NO             
           MOVE AT-PREMISE-NO             TO MH-PREMISE-NO              
           MOVE ZERO                      TO MH-ENTITY-KEY-DESC-LEN     
           MOVE JW-LAST-UPDATE-USERID     TO MH-USER-ID                 
           MOVE 'PCSCA104'                TO MH-APPL-PROGRAM-ID         
           MOVE +1                        TO WS-TRAN-APPL-NO            
           MOVE SPACES                    TO MH-RESP-AREA-ID            
           MOVE +74                       TO MH-TRAN-COMMENT-LEN        
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +1                        TO MI-TRAN-APPL-NO.           
           MOVE SPACES                    TO MI-TABLE-ID.               
           MOVE 'BILL DISP CD'            TO MI-COLUMN-DESC.            
           MOVE 30                        TO MI-CHG-COLUMN-VALUE-LEN    
           MOVE 19                        TO MI-PRV-COLUMN-VALUE-LEN    
           MOVE 'EXCEPTION BILL HELD'     TO MI-PRV-COLUMN-VALUE-TEXT   
           PERFORM 6530-LOAD-MNT-TRANS-HIST                             
                                          THRU 6530-EXIT.               
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 06510000
      ** 6540-INSERT-MNT-TRANS-HIST.                                 ** 06520000
      ***************************************************************** 06530000
                                                                        
           EXEC SQL                                                     06550000
               INCLUDE CPD00067                                         06560000
           END-EXEC.                                                    06570000
                                                                        
      ************************************************************      06590000
      *  OPEN GET_EXCP CURSOR                                    *      06600000
      ************************************************************      06610000
                                                                        
       7100-OPEN-EXCP-CURSOR.                                           
                                                                        
      *                                                                 06650000
            EXEC SQL                                                    
                OPEN GET_EXCBILL                                        
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** 7100-OPEN-EXCP-CURSOR '                      
               DISPLAY '** PCSCA104 PROCESSING ERROR'                   
               DISPLAY '** ERROR ON OPEN '                              
               DISPLAY '** SQL CODE ' WS-ACTIVE-RETURN-CODE             
               DISPLAY '** TABLE  CSS_EXCEPTION_BILLS'                  
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND                     THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      06880000
      *  FETCH EXCEPTION DATA FROM DB2 TABLE                     *      06890000
      ************************************************************      06900000
                                                                        
       7200-FETCH-EXCP-CURSOR.                                          
                                                                        
      *                                                                 06940000
            EXEC SQL                                                    
                FETCH GET_EXCBILL                                       
                  INTO  :JW-DATE-BILLED                                 
                       ,:JW-COMPANY-NO                                  
                       ,:JW-ACCOUNT-NO                                  
                       ,:JW-DEST-CD                                     
                       ,:JW-PULL-CD                                     
                       ,:JW-BILL-NO                                     
                       ,:JW-BILL-IMAGE-SEQ                              
                       ,:JW-COMPANY-TYPE-CD                             
                       ,:JW-ACCOUNT-SEQ-NO                              
                       ,:JW-LAST-UPDATE-TS                              
                       ,:JW-LAST-UPDATE-USERID                          
                       ,:JW-BILL-DISP-CD                                
                       ,:JW-BILL-IMAGE                                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
           OR WS-ACTIVE-RETURN-CODE EQUAL      NOT-FOUND                
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** 7200-FETCH-EXCP-CURSOR '                     
               DISPLAY '** PCSCA104 PROCESSING ERROR'                   
               DISPLAY '** ERROR ON FETCH '                             
               DISPLAY '** SQL CODE ' WS-ACTIVE-RETURN-CODE             
               DISPLAY '** TABLE  CSS_EXCEPTION_BILLS'                  
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND                     THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      07310000
      *  CLOSE GET_EXCBILL CURSOR                                *      07320000
      ************************************************************      07330000
                                                                        
       7300-CLOSE-EXCP-CURSOR.                                          
                                                                        
      *                                                                 07370000
            EXEC SQL                                                    
                CLOSE GET_EXCBILL                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                               TO                
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** 7300-CLOSE-EXCP-CURSOR '                     
               DISPLAY '** PCSCA104 PROCESSING ERROR'                   
               DISPLAY '** ERROR ON CLOSE '                             
               DISPLAY '** SQL CODE ' WS-ACTIVE-RETURN-CODE             
               DISPLAY '** TABLE  CSS_EXCEPTION_BILLS'                  
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND                     THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      07600000
      *  CHECK FOR NOT FOUND IN CSS_EXCP_BILL_DET                *      07610000
      ************************************************************      07620000
                                                                        
       7400-CHECK-NOT-FOUND.                                            
                                                                        
      *                                                                 07660000
A02501     IF  WS-ACCT-NOTFND-CNT < WS-ACCT-NOTFND-MAX                  
A02501          MOVE 'N' TO WS-ACCT-FOUND-FL                            
A02501          ADD +1 TO WS-ACCT-NOTFND-CNT                            
A02501          PERFORM 8400-WRITE-NOTFND-ACCTS THRU 8400-EXIT          
A02501       ELSE                                                       
A02501          DISPLAY '****************************************'      
A02501          DISPLAY '** NUMBER OF ACCOUNTS NOT FOUND IN '           
A02501                  'BILL DETAILS TABLE EXCEEDED MAX LIMIT OF '     
A02501                  WS-ACCT-NOTFND-MAX                              
A02501          DISPLAY '****************************************'      
A02501          PERFORM 9900-ABEND                 THRU 9900-EXIT       
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************07840000
      *        GET TIMESTAMP FOR MNT_TRANS_HIST FILE                   *07850000
      ******************************************************************07860000
       7600-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07890000
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                    07900000
MFA-TR*    END-EXEC.                                                    07910000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                NEXT SENTENCE                                           
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** ERROR IN 7600-SELECT-TIMESTAMP        **'    
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**        PROCESSING TERMINATED          **'    
               DISPLAY '** ACCOUNT NO ' WS-NOOP-ACCT-NO                 
               DISPLAY '** BILL DATE ' WS-NOOP-BILL-DATE                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08110000
      *        GET ACCOUNT DETAILS FROM CSS_ACCOUNT                    *08120000
      ******************************************************************08130000
       7700-GET-ACCOUNT-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT  ACCOUNT_NO                                       
                      ,CUSTOMER_NO                                      
                      ,PREMISE_NO                                       
                 INTO  :AT-ACCOUNT-NO                                   
                      ,:AT-CUSTOMER-NO                                  
                      ,:AT-PREMISE-NO                                   
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :JW-ACCOUNT-NO                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08160000
MFA-TR*        SELECT  ACCOUNT_NO                                       08170000
MFA-TR*               ,CUSTOMER_NO                                      08180000
MFA-TR*               ,PREMISE_NO                                       08190000
MFA-TR*          INTO  :AT-ACCOUNT-NO                                   08200000
MFA-TR*               ,:AT-CUSTOMER-NO                                  08210000
MFA-TR*               ,:AT-PREMISE-NO                                   08220000
MFA-TR*          FROM CSS_ACCOUNT                                       08230000
MFA-TR*         WHERE ACCOUNT_NO = :JW-ACCOUNT-NO                       08240000
MFA-TR*          WITH UR                                                08250000
MFA-TR*    END-EXEC.                                                    08260000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                NEXT SENTENCE                                           
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** ERROR IN 7700-GET-ACCOUNT-DETAILS     **'    
               DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
               DISPLAY '**        PROCESSING TERMINATED          **'    
               DISPLAY '** ACCOUNT NO ' WS-NOOP-ACCT-NO                 
               DISPLAY '** BILL DATE ' WS-NOOP-BILL-DATE                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      08460000
      *  WRITE THE OUTPUT FILE                                   *      08470000
      ************************************************************      08480000
                                                                        
       8000-WRITE-FCSBE28.                                              
                                                                        
           WRITE FIOBE28 FROM WS-EXT-IO-AREA.                           
           IF EXCPBE28-SUCCESSFUL                                       
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '** 8000-WRITE-FCSBE28 '                         
               DISPLAY '** PCSCA104 PROCESSING ERROR'                   
               DISPLAY '** FILE PROCESSING ERROR '                      
               DISPLAY '** FILE STATUS CODE ' WS-EXCPBE28-STATUS        
               DISPLAY '** ACCOUNT NO ' WS-NOOP-ACCT-NO                 
               DISPLAY '** BILL DATE ' WS-NOOP-BILL-DATE                
               DISPLAY '*******************************************'    
               PERFORM 9900-ABEND                 THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      08700000
      *  UPDATE CSS_EXCP_BILL_DET TABLE TO SHOW DETAILS CAN BE   *      08710000
      *  DELETED.                                                *      08720000
      ************************************************************      08730000
                                                                        
ACT052 8100-UPDATE-EXCP-BILL-DET.                                       
ACT052     EXEC SQL                                                     
ACT052         UPDATE CSS_EXCP_BILL_DET                                 
ACT052         SET    STATUS = 'D'                                      
ACT052         WHERE  DATE_BILLED    = IIF(TRY_CONVERT(DATE, 
                                                        :JW-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :JW-DATE-BILLED
              ) <> 0) OR (LEN(:JW-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :JW-DATE-BILLED
              ), CONVERT(DATE, :JW-DATE-BILLED) )     AND          
ACT052                ACCOUNT_NO     = :JW-ACCOUNT-NO      AND          
ACT052                BILL_IMAGE_SEQ = :JW-BILL-IMAGE-SEQ  AND          
ACT052                ACCOUNT_SEQ_NO = :JW-ACCOUNT-SEQ-NO               
ACT052     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08760000
MFA-TR*        UPDATE CSS_EXCP_BILL_DET                                 08770000
MFA-TR*        SET    STATUS = 'D'                                      08780000
MFA-TR*        WHERE  DATE_BILLED    = :JW-DATE-BILLED     AND          08790000
MFA-TR*               ACCOUNT_NO     = :JW-ACCOUNT-NO      AND          08800000
MFA-TR*               BILL_IMAGE_SEQ = :JW-BILL-IMAGE-SEQ  AND          08810000
MFA-TR*               ACCOUNT_SEQ_NO = :JW-ACCOUNT-SEQ-NO               08820000
MFA-TR*    END-EXEC.                                                    08830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT052     IF SQLCODE NOT = SUCCESSFUL-CALL                             
ACT052         DISPLAY '*******************************************'    
ACT052         DISPLAY '** 8100-UPDATE-EXCP-BILL-DET'                   
ACT052         DISPLAY '** PCSCA104 PROCESSING ERROR'                   
ACT052         DISPLAY '** SQLCODE        = ' SQLCODE                   
ACT052         DISPLAY '** ACCOUNT NO     = ' JW-ACCOUNT-NO             
ACT052         DISPLAY '** BILL DATE      = ' JW-DATE-BILLED            
ACT052         DISPLAY '** BILL IMAGE SEQ = ' JW-BILL-IMAGE-SEQ         
ACT052         DISPLAY '** ACCOUNT-SEQ-NO = ' JW-ACCOUNT-SEQ-NO         
ACT052         DISPLAY '*******************************************'    
ACT052         PERFORM 9900-ABEND                 THRU 9900-EXIT        
ACT052     END-IF.                                                      
ACT052                                                                  
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09000000
      *        DELETE PROCESSED BILLS FROM CSS_EXCEPTION_BILL TABLE    *09010000
      ******************************************************************09020000
       8200-DELETE-EXCP-BILLS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_EXCEPTION_BILL                           
                WHERE DATE_BILLED     = IIF(TRY_CONVERT(DATE, 
                                                        :JW-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :JW-DATE-BILLED
              ) <> 0) OR (LEN(:JW-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :JW-DATE-BILLED
              ), CONVERT(DATE, :JW-DATE-BILLED) )        AND      
                      ACCOUNT_NO      = :JW-ACCOUNT-NO         AND      
                      BILL_NO         = :JW-BILL-NO            AND      
                      COMPANY_TYPE_CD = :JW-COMPANY-TYPE-CD    AND      
                      BILL_IMAGE_SEQ  = :JW-BILL-IMAGE-SEQ     AND      
                      ACCOUNT_SEQ_NO  = :JW-ACCOUNT-SEQ-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09050000
MFA-TR*        DELETE FROM CSS_EXCEPTION_BILL                           09060000
MFA-TR*         WHERE DATE_BILLED     = :JW-DATE-BILLED        AND      09070000
MFA-TR*               ACCOUNT_NO      = :JW-ACCOUNT-NO         AND      09080000
MFA-TR*               BILL_NO         = :JW-BILL-NO            AND      09090000
MFA-TR*               COMPANY_TYPE_CD = :JW-COMPANY-TYPE-CD    AND      09100000
MFA-TR*               BILL_IMAGE_SEQ  = :JW-BILL-IMAGE-SEQ     AND      09110000
MFA-TR*               ACCOUNT_SEQ_NO  = :JW-ACCOUNT-SEQ-NO              09120000
MFA-TR*    END-EXEC.                                                    09130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
                NEXT SENTENCE                                           
           ELSE                                                         
                DISPLAY '*******************************************'   
                DISPLAY '** ERROR IN 8200-DELETE-EXCP-BILLS       **'   
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '**        PROCESSING TERMINATED          **'   
                DISPLAY ' ** ACCOUNT NO ' WS-NOOP-ACCT-NO               
                DISPLAY ' ** BILL DATE ' WS-NOOP-BILL-DATE              
                DISPLAY ' ** BILL NO   ' JW-BILL-NO                     
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
A02119                                                                  
A02119******************************************************************09350000
A02119*        UPDATE REBILLS TO HAVE TRACKING STATUS AS 'CB'          *09360000
A02119******************************************************************09370000
A02119 8300-UPDATE-CORR-MAIL-STAT.                                      
A02119                                                                  
A02119     EXEC SQL                                                     
A02119         UPDATE CSS_CORR_MAIL_STAT                                
A02119            SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD      
A02119          WHERE CREATE_DT           = IIF(TRY_CONVERT(DATE, 
                                                        :JW-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :JW-DATE-BILLED
              ) <> 0) OR (LEN(:JW-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :JW-DATE-BILLED
              ), CONVERT(DATE, :JW-DATE-BILLED) )             
A02119            AND ACCOUNT_NO          = :JW-ACCOUNT-NO              
A02119            AND TRACKING_STATUS_CD  IN ('BB', 'XB', 'XS', 'XC')   
A02119     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09400000
MFA-TR*        UPDATE CSS_CORR_MAIL_STAT                                09410000
MFA-TR*           SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD      09420000
MFA-TR*         WHERE CREATE_DT           = :JW-DATE-BILLED             09430000
MFA-TR*           AND ACCOUNT_NO          = :JW-ACCOUNT-NO              09440000
MFA-TR*           AND TRACKING_STATUS_CD  IN ('BB', 'XB', 'XS', 'XC')   09450000
MFA-TR*    END-EXEC.                                                    09460000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02119                                                                  
A02119     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
A02119                                                                  
A02119     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02119     OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
A02119          NEXT SENTENCE                                           
A02119     ELSE                                                         
A02119          DISPLAY '*******************************************'   
A02119          DISPLAY '** ERROR IN 8300-UPDATE-CORR-MAIL-STAT   **'   
A02119          DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
A02119          DISPLAY '**        PROCESSING TERMINATED          **'   
A02119          DISPLAY '** ACCOUNT NO  = ' JW-ACCOUNT-NO               
A02119          DISPLAY '** BILL DATE   = ' JW-DATE-BILLED              
A02119          DISPLAY '** TRACKING_STATUS_CD IS BB              **'   
A02119          DISPLAY '*******************************************'   
A02119          PERFORM 9900-ABEND                THRU 9900-EXIT        
A02119     END-IF.                                                      
A02119                                                                  
A02119 8300-EXIT.                                                       
A02119     EXIT.                                                        
A02119                                                                  
A02501******************************************************************09680000
A02501*        WRITE ACCOUNTS NOT FOUND IN CSS_EXCP_BILL_DET TO REPORT *09690000
A02501******************************************************************09700000
A02501 8400-WRITE-NOTFND-ACCTS.                                         
A02501                                                                  
A02501     IF FIRST-ACCT-NF-REP                                         
A02501        MOVE WS-RPT1-HEAD              TO WS-RPT-HEAD             
A02501        WRITE WS-PRT1041-RECORD        FROM WS-BLANK-LINE         
A02501        WRITE WS-PRT1041-RECORD        FROM WS-RPT-HEADER-LINE-1  
A02501        WRITE WS-PRT1041-RECORD        FROM WS-BLANK-LINE         
A02501        WRITE WS-PRT1041-RECORD        FROM WS-RPT-HEADER-LINE-2  
A02501        WRITE WS-PRT1041-RECORD        FROM WS-BLANK-LINE         
A02501        WRITE WS-PRT1041-RECORD        FROM WS-RPT-HEADER-LINE-3  
A02501        WRITE WS-PRT1041-RECORD        FROM WS-BLANK-LINE         
A02501        WRITE WS-PRT1041-RECORD        FROM WS-RPT-HEADER-LINE-4  
A02501        MOVE  WS-N                     TO WS-FIRST-ACCT-NOTFOU-SW 
A02501     END-IF.                                                      
A02501                                                                  
A02501     INITIALIZE WS-RPT-DETAIL-LINE-NOTFOU.                        
A02501     MOVE WS-NOOP-ACCT-NO      TO WS-RPT-ACCOUNT-NO.              
A02501     MOVE WS-NOOP-BILL-DATE    TO WS-RPT-BILL-DATE.               
A02501     MOVE JW-ACCOUNT-NO        TO WS-RPT-VSAM-ACCOUNT-NO.         
A02501     MOVE JW-DATE-BILLED       TO WS-RPT-VSAM-BILL-DATE.          
A02501     MOVE JW-BILL-IMAGE-SEQ    TO WS-RPT-VSAM-SEQ-NO.             
A02501     MOVE JW-ACCOUNT-SEQ-NO    TO WS-RPT-VSAM-SUB-SEQ-NO.         
A02501     WRITE WS-PRT1041-RECORD   FROM WS-RPT-DETAIL-LINE-NOTFOU.    
A02501                                                                  
A02501 8400-EXIT.                                                       
A02501     EXIT.                                                        
ACT052************************************************************      09970000
ACT052*  OPEN GET_EXCP CURSOR                                    *      09980000
ACT052************************************************************      09990000
ACT052                                                                  
ACT052 8700-OPEN-EXCP-BILL-DET.                                         
ACT052                                                                  
ACT052*                                                                 10030000
ACT052      EXEC SQL                                                    
ACT052          OPEN EXCP_BILL_DET_CSR                                  
ACT052      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT052                                                                  
ACT052     MOVE SQLCODE                               TO                
ACT052                                         WS-ACTIVE-RETURN-CODE.   
ACT052     IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
ACT052        NEXT SENTENCE                                             
ACT052     ELSE                                                         
ACT052         DISPLAY '*******************************************'    
ACT052         DISPLAY '** 8700-OPEN-EXCP-BILL-DET'                     
ACT052         DISPLAY '** PCSCA104 PROCESSING ERROR'                   
ACT052         DISPLAY '** ERROR ON OPEN '                              
ACT052         DISPLAY '** SQL CODE ' WS-ACTIVE-RETURN-CODE             
ACT052         DISPLAY '** TABLE  CSS_EXCEPTION_BILLS'                  
ACT052         DISPLAY '*******************************************'    
ACT052         PERFORM 9900-ABEND                     THRU 9900-EXIT    
ACT052     END-IF.                                                      
ACT052                                                                  
ACT052 8700-EXIT.                                                       
ACT052     EXIT.                                                        
ACT052                                                                  
ACT052************************************************************      10260000
ACT052*  FETCH EXCEPTION DATA FROM DB2 TABLE                     *      10270000
ACT052************************************************************      10280000
ACT052                                                                  
ACT052 8800-FETCH-EXCP-BILL-DET.                                        
ACT052                                                                  
ACT052*                                                                 10320000
ACT052      EXEC SQL                                                    
ACT052          FETCH EXCP_BILL_DET_CSR                                 
ACT052            INTO  :5J-BILL-IMAGE-SEQ                              
ACT052      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT052                                                                  
ACT052     MOVE 5J-BILL-IMAGE-SEQ-TEXT  TO  WS-EXT-IO-AREA.             
ACT052     MOVE SQLCODE                 TO  WS-ACTIVE-RETURN-CODE.      
ACT052     IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
ACT052     OR WS-ACTIVE-RETURN-CODE EQUAL      NOT-FOUND                
ACT052        NEXT SENTENCE                                             
ACT052     ELSE                                                         
ACT052         DISPLAY '*******************************************'    
ACT052         DISPLAY '** 8800-FETCH-EXCP-BILL-DET'                    
ACT052         DISPLAY '** PCSCA104 PROCESSING ERROR'                   
ACT052         DISPLAY '** ERROR ON FETCH '                             
ACT052         DISPLAY '** SQL CODE ' WS-ACTIVE-RETURN-CODE             
ACT052         DISPLAY '** TABLE  CSS_EXCEPTION_BILLS'                  
ACT052         DISPLAY '*******************************************'    
ACT052         PERFORM 9900-ABEND                     THRU 9900-EXIT    
ACT052     END-IF.                                                      
ACT052                                                                  
ACT052 8800-EXIT.                                                       
ACT052     EXIT.                                                        
ACT052                                                                  
ACT052************************************************************      10570000
ACT052*  CLOSE GET_EXCBILL CURSOR                                *      10580000
ACT052************************************************************      10590000
ACT052                                                                  
ACT052 8900-CLOSE-EXCP-BILL-DET.                                        
ACT052                                                                  
ACT052*                                                                 10630000
ACT052      EXEC SQL                                                    
ACT052          CLOSE EXCP_BILL_DET_CSR                                 
ACT052      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT052                                                                  
ACT052     MOVE SQLCODE                               TO                
ACT052                                         WS-ACTIVE-RETURN-CODE.   
ACT052     IF WS-ACTIVE-RETURN-CODE EQUAL      SUCCESSFUL-CALL          
ACT052        NEXT SENTENCE                                             
ACT052     ELSE                                                         
ACT052         DISPLAY '*******************************************'    
ACT052         DISPLAY '** 8900-CLOSE-EXCP-BILL-DET'                    
ACT052         DISPLAY '** PCSCA104 PROCESSING ERROR'                   
ACT052         DISPLAY '** ERROR ON CLOSE '                             
ACT052         DISPLAY '** SQL CODE ' WS-ACTIVE-RETURN-CODE             
ACT052         DISPLAY '** TABLE  CSS_EXCEPTION_BILLS'                  
ACT052         DISPLAY '*******************************************'    
ACT052         PERFORM 9900-ABEND                     THRU 9900-EXIT    
ACT052     END-IF.                                                      
ACT052                                                                  
ACT052 8900-EXIT.                                                       
ACT052     EXIT.                                                        
ACT052                                                                  
                                                                        
      ************************************************************      10657600
      * THE BELOW PARAGRAPH IS NECESSARY TO BE ABLE TO USE THE   *      10657700
      * COPYBOOK FOR WRITING THE MH AND MI.                      *      10657800
      ************************************************************      10657900
      *                                                                 10658000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
      ****************************************************************  10670000
      * 9000-TERMINATE. TERMINATE PROCESSING.                        *  10680000
      ****************************************************************  10690000
       9000-TERMINATE.                                                  
                                                                        
           CLOSE EXCPBE28-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      10770000
      * THE BELOW PARAGRAPH IS NECESSARY TO BE ABLE TO USE THE   *      10780000
      * COPYBOOK FOR WRITING THE MH AND MI.                      *      10790000
      ************************************************************      10800000
      *                                                                 10810000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 10830000
           DISPLAY '*******************************************'.       
           DISPLAY '** ABEND IN TRANS HIST INSERT            **'.       
           DISPLAY '** SQL CODE = ' WS-ACTIVE-RETURN-CODE.              
           DISPLAY '*******************************************'.       
           EXEC SQL                                                     10880000
             INCLUDE CPD09900                                           10890000
           END-EXEC.                                                    10900000
                                                                        
