       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA103.                                          
       AUTHOR.       COVANSYS.                                          
       DATE-WRITTEN. SEP 2009.                                          
       DATE-COMPILED.                                                   
      ****************************************************************          
      **               SOUTH CAROLINA ELECTRIC & GAS                 *          
      **                      COBOL-DB2                              *          
      ****************************************************************          
      **                     PROGRAM SUMMARY                         *          
      ****************************************************************          
      ** THIS PROGRAM IS A PURGE/UPDATE PROGRAM TO PURGE THE RECORDS *          
      ** IN CORR MAIL STAT TABLE AND UPDATE RECORDS IN JOB PARM TABLE*          
      ** BASED ON THE PARM                                           *          
      **                                                             *          
      ** -WHEN THE PARM SENT IS JOBP THE CURR VALUE IN CSS_JOB_PARM  *          
      **  TABLE WILL RESET                                           *          
      **                                                             *          
      ** -WHEN THE PARM SENT IS CORR, PROGRAM SHOULD PURGE THE ROWS  *          
      **  FROM CSS_CORR_MAIL_STAT TABLE WHICH ARE 60 DAYS OLDER      *          
      ****************************************************************          
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE          *          
      ****************************************************************          
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION *          
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH        *          
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH          *          
      **        3000 - 4999     NOT USED                             *          
      **        5000 - 5999     COMMON PROGRAM MODULES               *          
      **        6000 - 6999     COMMON SYSTEM MODULES                *          
      **        7000 - 7999     INPUT MODULES                        *          
      **        8000 - 8999     OUTPUT MODULES                       *          
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES*          
      ****************************************************************          
      **              PROGRAM  MODIFICATION  LOG                     *          
      ****************************************************************          
      ** DATE     USERID   REASON                                    *          
      ** -------  -------  ------                                    *          
PRJ166** 09/2009  COVANSYS INITIAL IMPLEMENTATION.                   *          
      *                                                              *          
A04527*   6 FEB 2014    RF10596   CHANGE PROGRAM TO USE A CURSOR TO  *          
A04527*                           DELETE CSS_CORR_MAIL_STAT ROWS     *          
      *                                                              *          
ACT165*  09/21/2015     BD09555   REMOVE CSS_CORR_MAIL_STAT PURGE    *          
ACT165* A05136-ACT165                                                *          
      ****************************************************************          
      *                                                              *          
       ENVIRONMENT DIVISION.                                            
      *--------------------*                                                    
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA103'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-MISC.                                                     
A04527     05  WS-SAVE-SQLCODE          PIC S9(9) COMP   VALUE 0.       
A04527     05  WS-COMMIT-TAKEN          PIC S9(9) COMP-3 VALUE 0.       
           05  WS-NUM-OF-PRIOR-DAYS     PIC S9(4)V COMP-3 VALUE 60.     
           05  WS-TOTAL-DEL-RECS        PIC S9(9) COMP  VALUE 0.        
           05  WS-MAX-CREATE-DT         PIC X(10) VALUE SPACES.         
           05  WS-PRIOR-DATE            PIC X(10) VALUE SPACES.         
           05  WS-JOB-PARM-STR.                                         
               10  WS-CORR-TYPE         PIC X(6).                       
               10  FILLER               PIC X(4).                       
               10  WS-MIN-SEQ-NO        PIC 9(6).                       
               10  FILLER               PIC X(4).                       
               10  WS-MAX-SEQ-NO        PIC 9(6).                       
               10  FILLER               PIC X(4).                       
               10  WS-LAST-USED-SEQ-NO  PIC 9(6).                       
           05  WS-JOB-PARM-PURGE.                                       
               10  FILLER               PIC X(11).                      
               10  WS-NBR-PURGE-DAYS    PIC 9(3).                       
      *                                                                         
       01  WS-FLAGS.                                                    
           05  WS-CURSOR-STATUS         PIC X VALUE SPACE.              
               88 WS-C1-EOC                   VALUE '1'.                
           05  WS-CSR-STS               PIC X VALUE 'C'.                
               88 WS-C1-OPEN                  VALUE 'O'.                
               88 WS-C1-CLOSE                 VALUE 'C'.                
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-PROGRAM-NAME          PIC X(8) VALUE 'PCSCA103'.      
      *                                                                         
      *-----------------------*                                                 
      * ERROR MESSAGE COPYBOOK.                                                 
      *-----------------------*                                                 
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      * DB2 INCLUDES.                                                           
      *                                                                         
      ****************************************************************          
      *    SQLCA                                                     *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    CSS_JOB_PARM (G6)                                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      * DB2 CURSORS.                                                            
      *                                                                         
      ****************************************************************          
      *    CURSOR TO GET JOB PARM DETAILS                            *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                     
                DECLARE  JOBPARM_C1  CURSOR FOR                         
                SELECT G6.SEQ_NO                                        
                      ,G6.PARM_DATA                                     
                      ,G6.PROGRAM_NAME                                  
                  FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                 WHERE G6.PROGRAM_NAME LIKE  'SCSC_165%'                
                   AND G6.COMPANY_NO   = :G6-COMPANY-NO                 
                   AND G6.CMND_CODE    = :G6-CMND-CODE                  
                   AND G6.SEQ_NO      != 9999                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE  JOBPARM_C1  CURSOR FOR                                 
MFA-TR*         SELECT G6.SEQ_NO                                                
MFA-TR*               ,G6.PARM_DATA                                             
MFA-TR*               ,G6.PROGRAM_NAME                                          
MFA-TR*           FROM CSS_JOB_PARM G6                                          
MFA-TR*          WHERE G6.PROGRAM_NAME LIKE  'SCSC_165%'                        
MFA-TR*            AND G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*            AND G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*            AND G6.SEQ_NO      != 9999                                   
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LK-PARM.                                                     
          05  LK-PARM-LENGTH               PIC S9(4) COMP.              
          05  LK-PARM-VALUE                PIC X(4).                    
      *                                                                         
       PROCEDURE DIVISION USING LK-PARM.                                
      *                                                                         
      ****************************************************************          
      * CONTROLS THE MAIN PATH OF THE PROGRAM                        *          
      ****************************************************************          
      *                                                                         
       0000-MAINLINE.                                                   
           PERFORM  0100-INITIALIZATION  THRU  0100-EXIT.               
           PERFORM  2000-PROCESS-OUTPUT  THRU  2000-EXIT.               
      *                                                                         
       0000-EXIT.                                                       
      *                                                                         
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * INITIALIZE FIELDS FOR PROCESSING                             *          
      ****************************************************************          
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           MOVE '01'    TO G6-COMPANY-NO.                               
           MOVE 'PARM'  TO G6-CMND-CODE.                                
       0100-EXIT.                                                       
      *                                                                         
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * VALIDATE AND PROCESS INPUT                                   *          
      ****************************************************************          
      *                                                                         
      ****************************************************************          
      * PERFORMS OUTPUT PROCESS                                      *          
      ****************************************************************          
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7100-OPEN-JOBPARM-C1  THRU 7100-EXIT                 
      *                                                                         
           PERFORM 7200-FETCH-JOBPARM-C1 THRU 7200-EXIT                 
      *                                                                         
           PERFORM 2100-UPD-JOBPARM-C1 THRU 2100-EXIT                   
                 UNTIL WS-C1-EOC                                        
      *                                                                         
      *                                                                         
           PERFORM 7300-CLOSE-JOBPARM-C1  THRU 7300-EXIT                
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PERFORMS FETCH, UPDATE AND COMMIT                            *          
      ****************************************************************          
      *                                                                         
       2100-UPD-JOBPARM-C1.                                             
      *                                                                         
           MOVE G6-PARM-DATA                 TO WS-JOB-PARM-STR.        
           MOVE WS-MIN-SEQ-NO                TO WS-LAST-USED-SEQ-NO.    
           MOVE WS-JOB-PARM-STR              TO G6-PARM-DATA.           
           PERFORM 8000-UPDATE-JOB-PARM      THRU 8000-EXIT.            
           DISPLAY WS-CORR-TYPE ' ' WS-MIN-SEQ-NO ' ' WS-MAX-SEQ-NO ' ' 
                   WS-LAST-USED-SEQ-NO ' RESET'.                        
           PERFORM 7200-FETCH-JOBPARM-C1     THRU 7200-EXIT.            
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * OPENS JOBPARM-C1 CURSOR                                      *          
      ****************************************************************          
      *                                                                         
       7100-OPEN-JOBPARM-C1.                                            
                                                                        
           EXEC SQL                                                     
                OPEN JOBPARM_C1                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET WS-C1-OPEN TO TRUE                                    
           ELSE                                                         
              DISPLAY '********** PCSCA103 ABORT  ************'         
              DISPLAY '* 7100-OPEN-JOBPARM-C1             *'            
              DISPLAY '* PROGRAM_NAME = ' G6-PROGRAM-NAME               
              DISPLAY '* COMPANY_NO   = ' G6-COMPANY-NO                 
              DISPLAY '* CMND_CODE    = ' G6-CMND-CODE                  
              DISPLAY '* SEQ_NO       = ' G6-SEQ-NO                     
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '********** PCSCA103  ABORT ************'         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * FETCH  JOBPARM-C1  CURSOR                                      *        
      ******************************************************************        
      *                                                                         
       7200-FETCH-JOBPARM-C1.                                           
      *                                                                         
           EXEC SQL                                                     
                FETCH JOBPARM_C1                                        
                 INTO :G6-SEQ-NO                                        
                     ,:G6-PARM-DATA                                     
                     ,:G6-PROGRAM-NAME                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    CONTINUE                                            
               WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    SET  WS-C1-EOC              TO    TRUE              
               WHEN OTHER                                               
                    DISPLAY '********** PCSCA103 ABORT  ************'   
                    DISPLAY '* 7200-FETCH-JOBPARM-C1               *'   
                    DISPLAY '* PROGRAM_NAME = ' G6-PROGRAM-NAME         
                    DISPLAY '* COMPANY_NO   = ' G6-COMPANY-NO           
                    DISPLAY '* CMND_CODE    = ' G6-CMND-CODE            
                    DISPLAY '* SEQ_NO       = ' G6-SEQ-NO               
                    DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE      
                    DISPLAY '********** PCSCA103  ABORT ************'   
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
           END-EVALUATE.                                                
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CLOSE  JOBPARM-C1 CURSOR                                     *          
      ****************************************************************          
      *                                                                         
       7300-CLOSE-JOBPARM-C1.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE JOBPARM_C1                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              DISPLAY '********** PCSCA103 ABORT  ************'         
              DISPLAY '* 7300-CLOSE-JOBPARM-C1               *'         
              DISPLAY '* PROGRAM_NAME = ' G6-PROGRAM-NAME               
              DISPLAY '* COMPANY_NO   = ' G6-COMPANY-NO                 
              DISPLAY '* CMND_CODE    = ' G6-CMND-CODE                  
              DISPLAY '* SEQ_NO       = ' G6-SEQ-NO                     
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '********** PCSCA103  ABORT ************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  UPDATE JOB-PARM.                                            *          
      ****************************************************************          
      *                                                                         
       8000-UPDATE-JOB-PARM.                                            
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET PARM_DATA      = :G6-PARM-DATA                   
                 WHERE PROGRAM_NAME   = :G6-PROGRAM-NAME                
                   AND COMPANY_NO     = :G6-COMPANY-NO                  
                   AND CMND_CODE      = :G6-CMND-CODE                   
                   AND SEQ_NO         = :G6-SEQ-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
            ELSE                                                        
               DISPLAY '********** PCSCA103  ABORT ************'        
               DISPLAY '* 8000-UPDATE-JOB-PARM                *'        
               DISPLAY '* PROGRAM_NAME = ' G6-PROGRAM-NAME              
               DISPLAY '* COMPANY_NO   = ' G6-COMPANY-NO                
               DISPLAY '* CMND_CODE    = ' G6-CMND-CODE                 
               DISPLAY '* SEQ_NO       = ' G6-SEQ-NO                    
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '********** PCSCA103  ABORT ************'        
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * ISSUES EXPLICIT COMMIT TO THE DB2 TRANSACTION                *          
      ****************************************************************          
      *                                                                         
       8200-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                     
                COMMIT                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * PROGRAM TERMINATION ON ABEND/ERROR                           *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
           IF WS-C1-OPEN                                                
              PERFORM 7300-CLOSE-JOBPARM-C1   THRU 7300-EXIT            
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
      *                                                                         
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * COPYBOOKS FOR ABEND/ERROR PROCESSING                         *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
      *                                                                         
