       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA102.                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *                 CUSTOMER INFORMATION SYSTEM                   *         
      *                                                               *         
      *****************************************************************         
      *                 P R O G R A M   S U M M A R Y                 *         
      *                                                               *         
      * IN ORDER TO ACHIEVE RANDOM SELECTION OF AUDIT CASES, THIS PGM *         
      * ASSIGNS RANDOM NUMBERS TO ACCOUNTS IN BE06.                   *         
      *                                                               *         
      *****************************************************************         
      *                                                               *         
      *               PROGRAM  MODIFICATION  LOG                      *         
      *      DATE    INITIALS     REASON                              *         
      *    ________  ________     __________________________________  *         
      *    10/11        SDHAL     INITIAL VERSION.                    *         
      *****************************************************************         
      *                                                               *         
      *         -----    BASIC SEQUENCE STRUCTURE   -----             *         
      * 0000         MODULE CONTROL                                   *         
      * 0100 - 0999  INITIALIZATION                                   *         
      * 1000 - 1999  FUNCTIONAL CONTROL                               *         
      * 2000 - 4999  DETAIL LOGIC                                     *         
      * 5000 - 5999  INTERNAL (PROGRAM) COMMON ROUTINES               *         
      * 6000 - 6999  INTERNAL (SYSTEM) COMMON ROUTINES (CPDXXXXX)     *         
      * 7000 - 7999  PHYSICAL INPUT ROUTINES (READS, SELECTS, ETC.    *         
      * 8000 - 8999  PHYSICAL OUTPUT ROUTINES (WRITES, UPDATES,ETC    *         
      * 9000 - 9999  ABEND / ERROR ROUTINES.                          *         
      *                                                               *         
      *****************************************************************         
      ***************************************************************** 00705400
                                                                        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** BE06 IS THE PRIMARY INPUT FILE                                        
           SELECT FCSBE38-FILE                                          
               ASSIGN UT-S-FCSBE38                                      
               STATUS IS WS-FBE38-STATUS.                               
                                                                        
           SELECT FCSCAOUT-FILE                                         
               ASSIGN UT-S-OUTPUT                                       
               FILE STATUS IS WS-FCAOUT-STATUS.                         
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDBE38.                                                            
       COPY FIOBE38.                                                            
                                                                        
       FD  FCSCAOUT-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01  FCSCAOUT.                                                    
           02  FCSCAOUT-REC.                                            
               05  RANDOM-SORT-KEY       PIC X(07).                     
               05  BE06-REC-KEY          PIC X(18).                     
               05  FILLER                PIC X(539).                    
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-MISC.                                                     
           05  WS-FCAOUT-STATUS          PIC XX VALUE '  '.             
               88 FCAOUT-SUCCESSFUL                 VALUE '00'.         
           05  WS-FBE38-STATUS            PIC XX VALUE '  '.            
               88 BE38-SUCCESSFUL                   VALUE '00'.         
           05  WS-END-OF-BE38            PIC X VALUE 'N'.               
               88  END-OF-BE38                     VALUE 'Y'.           
           05  SUB1                      PIC S9(7) COMP-3 VALUE +0.     
           05 WS-REC-COUNT               PIC S9(7) COMP-3 VALUE +0.     
           05 WS-PREV-BE38-KEY           PIC X(18) VALUE SPACES.        
           05 WS-HEADER-FOUND            PIC X(01) VALUE 'N'.           
           05 WS-Y                       PIC X(01) VALUE 'Y'.           
                                                                        
       77 WS-RANDOM-NUMBER     PIC V9(7) VALUE 0.                       
       77 WS-RANDOM-NUMBER-I   PIC 9(7) VALUE 0.                        
       77 WS-HOLD-RANDOM-NO    PIC X(07) VALUE SPACES.                  
       77 SEED                 PIC 9(9) VALUE 0.                        
                                                                        
       01  DATE-AND-TIME-FIELDS.                                        
           03  WS-DATE          PIC 9(06)  VALUE ZEROES.                
           03  WS-DATE-R REDEFINES WS-DATE.                             
               05 WS-YY       PIC 99.                                   
               05 WS-MM       PIC 99.                                   
               05 WS-DD       PIC 99.                                   
                                                                        
           03  WS-TIME          PIC 9(08)  VALUE ZEROES.                
           03  WS-TIME-R REDEFINES WS-TIME.                             
               05 WS-HR       PIC 99.                                   
               05 WS-MIN      PIC 99.                                   
               05 WS-SEC      PIC 99.                                   
               05 WS-HUN      PIC 99.                                   
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      **************************************************************    02405000
      *  READ BE06 AND WRITE TO OUT FILE WITH A RANDOM NUMBER      *    02406000
      *  PREFIXED TO TEH ACCOUNT                                   *    02407000
      **************************************************************    02409000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION          THRU 0100-EXIT.         
                                                                        
           ADD  +1              TO SUB1                                 
                                   WS-REC-COUNT.                        
           MOVE SPACES          TO WS-PREV-BE38-KEY.                    
                                                                        
           PERFORM 1000-RANDOMIZE               THRU 1000-EXIT          
                                                UNTIL END-OF-BE38.      
                                                                        
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************       02537000
      *  OPEN INPUT AND OUTPUT FILES.                           *       02538000
      ***********************************************************       02540000
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           OPEN INPUT FCSBE38-FILE.                                     
           IF NOT BE38-SUCCESSFUL                                       
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSBE06            **'        
               DISPLAY '**  FILE STATUS = ' WS-FBE38-STATUS             
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSCAOUT-FILE.                                   
           IF NOT FCAOUT-SUCCESSFUL                                     
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '**************************************'         
               DISPLAY '**  ERROR OPENING FCSCAOUT           **'        
               DISPLAY '**  FILE STATUS = ' WS-FCAOUT-STATUS            
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
      ***** SEED THE RANDOM NUMBER FUNCTION  ***************                    
           ACCEPT WS-DATE FROM DATE.                                    
           ACCEPT WS-TIME FROM TIME.                                    
           COMPUTE SEED = (WS-MM * WS-DD * WS-YY) *                     
                          (WS-HR + WS-MIN + WS-SEC + WS-HUN)            
           END-COMPUTE.                                                 
           DISPLAY SEED.                                                
           COMPUTE WS-RANDOM-NUMBER = FUNCTION RANDOM (SEED)            
           END-COMPUTE.                                                 
           COMPUTE                                                      
               WS-RANDOM-NUMBER-I = WS-RANDOM-NUMBER * 10000000         
           END-COMPUTE.                                                 
           DISPLAY WS-RANDOM-NUMBER-I.                                  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************              
      *  ADD RANDOM NUMBER TO THE SET OF RECORDS FOR THE ACCOUNT                
      ************************************************************              
       1000-RANDOMIZE.                                                  
           PERFORM 7100-READ-FIOBE38      THRU  7100-EXIT.              
                                                                        
           IF BE06-REC-KEY = HIGH-VALUES OR LOW-VALUES                  
    ***       KEEP FOOTER RECORD AT LAST                                        
              IF WS-HEADER-FOUND = 'Y'                                  
                 MOVE '9999999'           TO WS-HOLD-RANDOM-NO          
              END-IF                                                    
           ELSE                                                         
              IF WS-PREV-BE38-KEY NOT = BE06-REC-KEY                    
    ***       GENERATE AND ASSIGN NEW RANDOM NUMBER                             
                 COMPUTE WS-RANDOM-NUMBER = FUNCTION RANDOM             
                 END-COMPUTE                                            
                 COMPUTE                                                
                     WS-RANDOM-NUMBER-I = WS-RANDOM-NUMBER * 10000000   
                 END-COMPUTE                                            
                 MOVE WS-RANDOM-NUMBER-I  TO WS-HOLD-RANDOM-NO          
                 MOVE BE06-REC-KEY        TO WS-PREV-BE38-KEY           
              END-IF                                                    
           END-IF.                                                      
                                                                        
    ***    KEEP HEADER RECORD ON TOP                                            
           IF WS-HEADER-FOUND NOT = 'Y'                                 
              MOVE '0000000'              TO WS-HOLD-RANDOM-NO          
              MOVE 'Y'                    TO WS-HEADER-FOUND            
           END-IF.                                                      
                                                                        
           IF WS-END-OF-BE38 NOT = 'Y'                                  
              MOVE WS-HOLD-RANDOM-NO             TO RANDOM-SORT-KEY     
              PERFORM 8000-WRITE-FCSCAOUT-FILE   THRU 8000-EXIT         
           END-IF.                                                      
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      03854000
      *  READ THE INPUT FILE                                     *              
      ************************************************************      03856000
       7100-READ-FIOBE38.                                               
                                                                        
           READ FCSBE38-FILE AT END                                     
               MOVE WS-Y TO WS-END-OF-BE38.                             
                                                                        
           IF BE38-SUCCESSFUL OR END-OF-BE38                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 12 TO RETURN-CODE                                   
               DISPLAY '****************************************'       
               DISPLAY '**     REKHUDMP PROCESSING ERROR      **'       
               DISPLAY '**       ERROR READING FCSBE06        **'       
               DISPLAY '**     FILE STATUS = ' WS-FBE38-STATUS          
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
           IF BE38-SUCCESSFUL                                           
              STRING  '0000000'                                         
                      FIOBE38                                           
                      DELIMITED BY SIZE                                 
                      INTO FCSCAOUT                                     
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-WRITE-FCSCAOUT-FILE.                                        
           WRITE FCSCAOUT.                                              
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       9000-TERMINATE.                                                  
           CLOSE FCSBE38-FILE                                           
                 FCSCAOUT-FILE.                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *     9900-ABEND                                                 *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           DISPLAY 'PERFORMING 9900-ABEND'.                             
           MOVE 12  TO  RETURN-CODE.                                    
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           STOP RUN.                                                    
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
