       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA100.                                        
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRIC & GAS                  **         
      **                     PRICE WATERHOUSE                        **         
      **                                                             **         
      **               CUSTOMER INFORMATION SYSTEM                   **         
      **                                                             **         
      **                                                             **         
      *****************************************************************         
      **               P R O G R A M  S U M M A R Y                  **         
      **                                                             **         
      ** PCSCA100 IS THE DRIVER PROGRAM FOR BATCH BILLING. THE       **         
      ** STRUCTURE IS AS FOLLOWS                                     **         
      **                                                             **         
      ** FUNCTION                                    LOCATION        **         
      ** ------- ----------------------------------  --------        **         
      ** 1. GET ACCOUNT FROM DB07                    DRIVER          **         
      ** 2. GET BASIC DATA                           SCSCA102        **         
      **    2A. EXTRACT DATA BASE ROWS                   "           **         
      **    2B. APPEND TRANSFER DATA (PART 9 ONLY)       "           **         
      **    2C. CREATE GUARANTEE RELEASE NOTIFICATION    "           **         
      **        (PART 9 ONLY)                                        **         
      ** 3. COMPUTE NEW UTILITY CHARGES              SCSCA105        **         
      **    3A. GET SUB-METERED CONSUMPTION          SCSCA104        **         
      **    3B. ESTIMATE CONSUMPTION                 SCSCA103        **         
      **    3C. BUILD UM CNSMPT HIST                 SCSCA105        **         
      **    3D. CALCULATE UTILITY CHARGES            SCSCA107        **         
      **    3E. APPLY TAXES                          SCSCA105        **         
      **    3F. APPLY SPECIAL ANNUAL MINIMUMS        SCSCA105        **         
      **        3F1. CALC HISTORICAL CHARGE DATA     SCSCA107        **         
      **    3G. CREATE REVENUE JOURNALS              SCSCA105        **         
      ** 4. UPDATE ACCOUNTS RECEIVABLE               SCSCA108        **         
      **    4A. REFUND DEPOSITS & INTEREST           SCSCA101        **         
      **    4B. APPLY REBATES (CRED CONTRACTS)       SCSCA117        **         
      **    4C. AGE RECEIVABLES                      SCSCA108        **         
      **    4D. COMPUTE NEW CHARGES                  SCSCA108        **         
      **        4D1. INCORPORATE XFER SUMM UNBILLED      "           **         
      **        4D2. CALCULATE RECURRING CHARGES         "           **         
      **        4D3. APPLY UNUSED CREDITS                "           **         
      **        4D4. CREATE AR JOURNALS                  "           **         
      **    4E. CALCULATE AND APPLY LPC                  "           **         
      **    4F. UPDATE CREDIT HISTORY                    "           **         
      **        4F1. REMOVE GUARANTEES                   "           **         
      ** 5. RECALCULATE EPP                          SCSCA112        **         
      **    5A. MONITOR CURRENT EPP ACCOUNTS             "           **         
      **    5B. RECALC RATES WITH TARIFF CHANGE          "           **         
      **        5B1. RECALC HISTORICAL USAGE         SCSCA107        **         
      **    5C. PERFORM ANNIVERSARY REVIEWS          SCSCA112        **         
      **        5C1. RECALC HISTORICAL USAGE         SCSCA107        **         
      **    5D. EXTEND OFFERS TO NON-BUDGET ACCOUNTS SCSCA110        **         
      **        5C1. RECALC HISTORICAL USAGE         SCSCA107        **         
      ** 6. APPLY BILL RESULTS                       SCSCA110        **         
      **    6A. FORECAST NOTICE DATES                    "           **         
      **    6B. REFUND CREDITS ON FINAL BILLS        SCSCA109        **         
      **    6C. TERMINATE BONDS & LOC                SCSCA110        **         
      **    6D. TRANSFER RECEIVABLES                 SCSCA115        **         
      **    6F. UPDATE BILL HISTORY                  SCSCA114        **         
      **    6G. UPDATE ACCOUNTS RECEIVABLE           SCSCA113        **         
      ** 7. CREATE OUTPUT FILES                                      **         
      **    7A.  CREATE BILL EXTRACT (BE00, BE01)    SCSCA116        **         
      **    7B.  CREATE SUMMARY FILES (WK00, 02, 06) PCSCA100        **         
      **    7C.  CREATE WORK QUEUES                      "           **         
      **                                                             **         
      ** UTILITY FUNCTIONS.                                          **         
      **    U1.  OPEN FILES                          PCSCA100        **         
      **    U2.  CLOSE FILES                             "           **         
      **    U3.  CREATE FILE HEADERS/TRAILERS            "           **         
      **    U4.  HANDLE RESTART & CHECKPOINTING          "           **         
      **    U5.  HANDLE ABNORMAL CONDITIONS FROM         "           **         
      **         SUBROUTINES                                         **         
      *****************************************************************         
      *                                                              **         
      *              PROGRAM  MODIFICATION  LOG                      **         
      *                                                              **         
      *    DATE     INITIALS  REASON                                 **         
      *    ----     --------  ------                                 **         
      *    11/94    KG        PRELIMINARY VERSION                    **         
      *    02/95    TF        FINAL VERSION                          **         
      *    07/18/95 KMG       T5912 FIX CHECK ON WEATHER TREND TO    **         
      *                       CHECK FOR SPACES IN REV CLASS          **         
      *    01/18/96 LMB       TPR 2699 - ADV COLL TABLE DROPPED      **         
KGDB  *    01/23/96 KMG       ADD PARM TO AVOID DB UPDATES           **         
      *    01/24/96 LMB       TPR 2341 - ADD CREDIT LETTER IND TO    **         
      *                       DB07 WORKING STORAGE SECTION           **         
      *    02/06/96 LMB       TPR 2878 - WRITE BEGIN AND END RECORDS **         
      *                       FOR FCSRP112 FILE.                     **         
FCS   *    03/11/96 MJL       FCS CHANGES FOR COOKBOOKS 63 & 64      **         
      *    03/27/96 RSN       2000-PROCESS ACCOUNT AFTER WARNING     **         
      *    04/16/96 RSN       CHANGED 3100- TO CHECK FOR NULL        **         
TP3973*    04/24/96 LMB       FIX SOC7 - LINKAGE INVALID FOR SCSCA110**         
TP4294*    05/28/96 KMG       REMOVE COMPANY CODE LOGIC SO THEY BILL **         
TP4409*    06/05/96 KMG       ENSURE HANDLING OF MULTIPLE TRAILER    **         
TP4409*                       RECS ON DB07 SINCE PARTITION 9 PROCESS **         
TP4409*                       WILL HAVE MULTIPLE ENDING RECS         **         
TP4569*    06/17/96 KMG       PREVENT PART 9 MASTERS (OFF CYCLE) FROM**         
TP4569*                       EXECUTING CA105, 108 ETC SINCE THIS    **         
TP4569*                       IS FOR TRANSFER PROCESS ONLY           **         
RSN5  *    06/19/96 RSN       ADD LOGIC TO BILL MASTERS ONLY IF THEIR**         
RSN5  *                       SUBS HAVE BILLED.                      **         
TP4645*    06/19/96 KMG       DO NOT WRITE BE00/BE01 IF PAR 9 MASTER **         
RSN5  *    06/25/96 RSN       ADD LOGIC TO BILL MASTERS ONLY IF THEIR**         
TP4576*    06/26/96 TCB       CHANGED CODE TO SET THE WS-PROCESS-    **         
TP4576*                       REFUND FLAG IF THE OFF-CYCLE-BILL-CODE **         
TP4576*                       FROM DB07 IS 'R'.  ALSO ADDED LOGIC TO **         
TP4576*                       SKIP SCSCA105 & SCSCA112 IF THIS FLAG  **         
TP4576*                       IS SET.                                **         
KMG1  *    06/28/96 KMG       FIX LOGIC TO HANDLE WHEN A MASTER      **         
KMG1  *                       COMES THRU FOR TRANSFER AND OFF CYCLE  **         
KMG1  *                       PROCESSING                             **         
TP4886*    07/11/96 LMB       FIX CODE USED FOR ON CYCLE BILL TO     **         
TP4886*                       MATCH THE CODE USED BY SUB-MODULES     **         
KMG2  *    07/15/96 KMG       FIX LOGIC TO GO INTO 2100 FOR ON CYCLE **         
KMG2  *                       MASTERS THAT HAVE ALL SUBS BILLED      **         
      *                       MATCH THE CODE USED BY SUB-MODULES     **         
TP4670*    08/27/96 PD        CALL 2100- WHEN OFF CYCLE BILLING WITH **         
TP4670*                       PARTITION 9 AND TYPE T.                **         
TP5228*    08/29/96 MAD       ADDED LOGIC FOR ABEND STANDARDIZATION  **         
TP5228*                       AMONG BATCH AND ONLINE (CICS) MODULES. **         
TP5228*                       TPR 5228.                                         
TP5339*    09/04/96 FSW       CORRECT STRESS TEST ABEND ON INDEX OVER**         
TP5339*                       50                                                
T4146 *    09/10/96 CSG       ADD COMMIT AFTER BUILD WQ IN 2100-.    **         
      *                        TPR 4146.                                        
PCR233*    09/23/96 MAD       ADD FCA00 INFORMATION TO THE LINKAGE   **         
PCR233*                        SECTION FROM PCSCA100 TO SCSCA110 IN  **         
PCR233*                        PARAGRAPH 2800                        **         
      *                                                              **         
PCR305*    09/26/96 CSS       PCR305 - INCLUDE LOGIC TO HANDLE       **         
      *                       DEFERRED INTEREST FOR FIOWK03 RECORDS  **         
PCR072*    10/01/96 PD        PCR072- REMOVE CODE FOR CIAC.          **         
PCR294*    10/02/96 CDS       PCR294 - ADD CONTRACT DETAILS TO       **         
PCR294*                       LINKAGE FOR SCSCA108.                  **         
T6068 *    11/12/96 CSG       T6068 - ADD ROLL BACK WHEN ABENDING    **         
      *                       WITH EXTRACT-CODE = 12.                **         
T7882 *    12/11/96 CSG       T7882 - CHANGING THE REINITIALIZATION  **         
      *                       OF THE WEATHER TABLE TO ONLY CERTAIN   **         
      *                       FIELDS.                                **         
TP7965*     1/13/97 ADA       T7965 - ONLY CERTAIN PROGRAMS NEED TO BE*         
TP7965*                       CALLED FOR A TRANSFER-GUARANTEE OR A   **         
TP7965*                       TRANSFER-GUARANTOR.                    **         
T7970 *     1/29/97 FSW       CONSOLIDATED BILLING                   **         
T9995 *     3/31/97 WTF       FIXED LOOP ERROR FOR DB07-INDX         **         
T10033*     4/1/97  WTF       DO NOT WRITE JOURNALS/TRAN HIST FOR    **         
      *                       CURRENT BUDGET CHARGE WHEN ACCOUNT IS  **         
      *                       REMOVED FROM BUDGET                    **         
T10082*     4/8/97  CSG       ADD LINKAGE FOR CALL TO SCSCA112.      **         
T10545*     4/25/97 MJL       DO NOT ADD WS-104-AMT-POSTED TO ACCOUNT**         
      *                       WHEN WS-103-AR-AGE = 'A' (SUM-UNBILLED)**         
T10675*     4/28/97 MJL       CHANGE TRANSACTION COMMENT FOR LPC ONLY**         
      *                       BILLS.                                 **         
T10424*     4/30/97 MJL       DO NOT WRITE TO BEOO FOR TRANSFER TO   **         
      *                       ACCOUNTS THAT ARE NOT ON CYCLE.        **         
T10658*     5/1/97  MAD       ADDED WS-LOCAL-AND-TOTAL-ACCUM-TABLE   **         
      *                       TO LINKAGE FOR SCSCA110 FOR EPP DROP.  **         
      *     5/5/97  CSG       TPRS 10611 AND 10847.                  **         
T10847*                       ADDED 2 SITUATIONS TO THE JOURNALING:  **         
      *                        1-IF AN ACCOUNT WAS DROPPED FROM EPP, **         
      *                          SUBTRACT THE AMT-POSTED ON THE      **         
      *                          RECORD WITH AGE=SPACES (THIS BACKS  **         
      *                          OUT THE EPP ALREADY CHARGED).       **         
      *                        2-IF AN ACCOUNT HAD A CREDIT BAL ON   **         
      *                          THE EPP AT ANNIV TIME, SUBTRACT THE **         
      *                          AMT-POSTED ON THAT JOURNAL.         **         
T10611*                       DON'T WRITE THE OUTPUT FILES IF THIS IS**         
      *                       AN LPC ONLY BILL.                      **         
      *     5/6/97  CSG       TPRS 10622 AND 10850 AND 10779.        **         
T10622*                       CHANGE THE TRANS HIST DESCRIPTION ON   **         
      *                       A DROP FOR EPP ACCOUNT TO PCSCA10A     **         
T10850*                       CHANGE THE TRANS HIST DESCRIPTION ON   **         
      *                       A GUARANTOR TRANSFER TO PCSCA10C       **         
T10779*                       CHANGE THE TRANS HIST DESCRIPTION ON   **         
      *                       A ACCOUNT WITH A REFUND TO PCSCA10B    **         
T10808*     5/8/97  CSG       SET THE CONTRACT TYPE IN AR TRANS HIST **         
      *                       FOR CONTRACT JOURNALS.                 **         
T11432*     6/4/97  MJL       DO NOT CALL 2600- IF MASTER AND WS-ON- **         
      *                       OFF-CYCLE-IND = SPACES.                **         
T11766*     6/24/97 MJL       DO NOT CALL 3000-EXTRACT IF MASTER AND **         
      *                       WS-ON-OFF-CYCLE-IND = SPACES.          **         
T11745*     6/27/97 CSG       SAVE THE LOCAL OFFICE TABLE AFTER EACH **         
      *                       SUCCESSFUL ACCOUNT, SO IF AN ACCOUNT   **         
      *                       FAILS, THE TABLE CAN BE RESTORED.      **         
T11939*     7/8/97  MJL       CHANGE BE10 FILE PROCESSING TO DB2.    **         
      *                       REMOVE DELETE PENDING_XFER LOGIC AND   **         
      *                       PUT INTO SCSCA113.                     **         
      *                       IF MASTER IS ON DB07 TWICE ONCE FOR SUB**         
      *                       AND ONCE FOR BEING ON CYCLE AND ALL    **         
      *                       SUBS HAVE NOT BILLED THEN SET ON-OFF-  **         
      *                       CYCLE-IND TO SPACE SO MASTER WILL STILL**         
      *                       GO THROUGH 102 AND TRANSFER THE SUB.   **         
PCR526*    7/22/97  CSG       ADD TRANS HIST CHANGES.                **         
PCR526*    7/29/97  MJL       ADD TRANS HIST CHANGES.                **         
      *    8/01/97  CSG       TPRS 12486 AND 12480.                  **         
T12486*                       CREATE AN AR-TRANS-HIST HEADER EVEN IF **         
      *                       NO JOURNALS WERE CREATED (FOR NON-UTIL)**         
T12480*                       CORRECT MASTERS/SUBS ON SAME CYCLE:    **         
      *                       MSTRS ARE ADDING THE XFERED $ TWICE    **         
T12650*    8/08/97  CSG       CHANGE T12486 TO CREATE A HEADER FOR   **         
      *                       ANY ACCT GOING THROUGH BILLING FOR A   **         
      *                       BILL (NOT MSTRS ON PART. 9 ONLY).      **         
T12429*    8/15/97  MJL       WRITE COMMENTS FOR OFF CYCLE SUB ACCT  **         
PCR551*   10/21/97  CSG       ADD TRANS HIST CHANGES.                **         
T13499*   10/28/97  CSG       CHANGES TO TRANS HIST COMMENTS FOR XFER**         
      *                       ACCOUNTS.                              **         
T13616*   11/11/97  CSG       REMOVE ':' FROM TRANS COMMENTS         **         
T13536*   11/13/97  CSG       INCREASE THE SIZE OF WK03 HOLD AREA.   **         
PCR473*   11/17/97  CSG       RESTART-RECOVERY CHANGES.              **         
PCR473*   12/03/97  CSG       RESTART-RECOVERY ADDITIONAL CHANGES.   **         
T14039*    1/08/98  MAO       DO NOT SET RESTART FLAG UNTIL COMMITS  **         
T14039*                       HAVE BEEN DONE.                        **         
T13418*    1/15/98  MAO                                              **         
T14505*   01/24/98  CSG       CORRECT RESTART LOGIC.                 **         
T14563*   01/29/98  CSG       ADD SUM FIELDS TO THE RESTART ROW FOR  **         
      *                       THE WK02 AND WK04 FILES.               **         
      *   02/24/98  CSG       TPRS 14972 AND 15042 AND 15097.        **         
T14972*                       CHANGE THE JOURNALLING ADDITIONS FOR   **         
      *                       XFER 'TO' ACCOUNTS.                    **         
T15042*                       USE THE CORRECT COUNTER FOR FILES THAT **         
      *                       ARE WRITTEN TO IN THE SUB PROGRAMS     **         
      *                       (WK05, BE21, RP112).                   **         
T15097*                       IF THE ACCOUNT ISN'T PROCESSED, DO NOT **         
      *                       MOVE IT TO THE DB07 INDX ARRAY.        **         
T15798*   04/08/98  CSG       DO NOT AUTOMATICALLY MOVE 0 TO UNPAID  **         
      *                       FOR SUB JOURNALS.                      **         
T15865*   04/14/98  AMG       - CALL 3500 TO CREATE THE WORK QUEUE   **         
T15865*                       FROM 2350 WHEN ALL SUBS ARE NOT BILLED **         
T15865*                       AND THE MASTER IS PULLED BUT NO SUBS   **         
T15865*                       ARE PULLED BY PCSCA107.                **         
T15865*                       - ADDED 7150-GET-ACCOUNT-INFO TO       **         
T15865*                       POPULATE APPROPRIATE FIELDS FOR 3500   **         
T15865*                       FOR ABOVE CASE.                        **         
T15980*   04/27/98  AMG       FIXED 1010- SO THAT ONLY A FINAL BILL  **         
T15980*                       IS PROCESSED WHEN AN ACCOUNT IS        **         
T15980*                       ON CYCLE AS WELL.                      **         
PCR629*   04/27/98  AMG       CHANGED THE CATEGORIES OF SOME         **         
PCR629*                       WORK QUEUES                            **         
T16223*   05/06/98  CSG       FETCH REVENUE-MONTH PARM TO USE IF THE **         
      *                       CYCLE FOR AN ACCT IS NOT IN THE BILL   **         
      *                       WINDOW.                                **         
T16440*   05/19/98  CSG       TREAT EXTRACT RETURN CODE 12 THE SAME  **         
      *                       AS AN UPDATE RETURN CODE 12 (-911 IN   **         
      *                       DB2 DOES AN AUTOMATIC ROLL BACK, SO    **         
      *                       WE NEED TO REPROCESS THE ACCOUNTS SINCE**         
      *                       THE LAST COMMIT).                      **         
T17051*   07/09/98  SJM       ADDED LOGIC TO CHECK THE MASTER ACCOUNTS*         
      *                       TO ENSURE ALL SUBS HAVE BEILLED WHEN    *         
      *                       REPROCESSING THE MASTER ACCOUNT DUE TO  *         
      *                       AN ERROR ON ANOTHER ACCOUNT             *         
T17052*   07/23/98  GAC       FIXED 1010- SO THAT ONLY AN OFF-CYCLE   *         
      *                       REBILL IS PROCESSED WHEN AN ACCOUNT IS  *         
      *                       ON CYCLE AS WELL.                       *         
T17199*   07/24/98  JR        FIXED 2000- SO FINAL BILLED ACCOUNTS WITH         
      *                       A REFUND PENDING WILL NOT GO THROUGH BILL         
      *                       PRINT.                                  *         
T16887*   07/31/98  GAC       FIXED 1000- WHEN PARTITION 9 RUNS WITH  *         
      *                       MULTIPLE ENDING RECORDS, LAST MASTER IN *         
      *                       DB07 WILL ONLY TRY TO BILL ONCE.        *         
T17269*   08/06/98  JYL       CHANGED 3100- WHEN ACCOUNT BILLS ON     *         
      *                       CYCLE, DO NOT SUBTRACT FROM AMT-BILLED- *         
      *                       UNPAID AS IT HAS ALREADY BEEN UPDATED IN*         
      *                       SCSCA102.                               *         
T16846*   08/12/98  GAC       FIXED CODE SO THAT WHEN A MASTER IS     *         
      *                       RECYCLED AND HAS AN M CODE, THE RECYCLE *         
      *                       WQ IS NOT "ERASED" BY RESETTING         *         
      *                       LS-CURR-WQ-ITEM TO ZERO IN 2100.        *         
T17432*   08/20/98  GAC       IN 3100, DO NOT SUBTRACT FROM AMT-BILLED*         
      *                       -UNPAID ONLY IF A MASTER (ON CYCLE MST  *         
      *                       OR OFF CYCLE MST).  NON-MASTERS SHOULD  *         
      *                       SUBTRACT FROM AMT-BILLED-UNPAID.        *         
T17357*   08/21/98  JER       IF AN ACCOUNT IS ON CYCLE AND IS  A     *         
      *                       'XFER TO' ACCOUNT AND IT FAILS BILLING, *         
      *                       WRITE THE ACCOUNT BACK OUT TO THE OFF   *         
      *                       CYCLE TABLE TO ACCEPT THE TRANSFER THE  *         
      *                       NEXT DAY.                               *         
T17242*   08/24/98  JER       DO NOT INCLUDE FINAL BILLED SUBS        *         
      *                       IN SUB_ACCT CURSOR WHEN CHECKING        *         
      *                       THAT ALL SUBS HAVE BILLED CORRECTLY     *         
T17490*   08/27/98  RGB       ADDED CODE TO CREATE WORK QUEUE         *         
      *                       FOR OUT OF BALANCE CONDITION            *         
T17778*   09/17/98  KLP       ADDED COMMENT TO TRANS HIST ROW WHEN    *         
      *                       PJS IS DROPPED = BIL/PJS DROPPED        *         
T17605*   09/25/98  KLP       REMOVED WQ FOR OOB ACCOUNT - RE-INSERTED*         
      *                       THE DISPLAY                             *         
T17931*   09/28/98  JER       FIXED JOURNALLING FOR RECONNECT CHARGES *         
T17777*   09/30/98  JYL       ADDED FIELD IN LINKAGE OF CALL TO       *         
T17777*                       SCSCA108 AND SCSCA112. ALSO ADDED LOGIC *         
T17777*                       LOGIC IN 3100-.  THIS IS FOR JOURNALLING*         
T17777*                       OF APPLYING CIA TO EPP TRAN BAL AT EPP  *         
T17777*                       ANNIVERSARY.                            *         
T17871*   10/02/98  KLP       ADDED APPL_PROGRAM_ID FOR CANCEL/REBILLS*         
T17871*                       WHICH ARE BILL IMMEDIATE                *         
T18003*   10/12/98  RGB       CODE CHANGED WHEN WRITING OUT WQ DUE TO *         
T18003*                       ABEND TO INCLUDE CUST/ACCT/PREM INFO    *         
T18208*   10/20/98  AAT       CHANGED ACCT TRANS HEADER TO NOT DISPLAY*         
      *                       BILL/PJS DROP FOR ACCOUNTS THAT ARE NOT *         
      *                       DROPPING SHARE FOR ARREARS              *         
T17582*   10/19/98  RGB       CODE CHANGED TO SUPRESS BILLING ON      *         
T17582*                       ACCOUNTS WITHOUT MONEY TRANSACTION TO   *         
T17582*                       DISPLAY ON BILL                         *         
T18485*   11/18/98  JYL       CHANGED PARA 3100- TO NOT CREATE        *         
T18485*                       TRANS HIST HDR. WHEN NOTHING IS         *         
T18485*                       JOURNALLED FOR APPLY-LPC ONLY ACCTS.    *         
T13284*   12/08/98  RGB       CODE CHANGED TO GIVE A MESSAGE WHEN     *         
T13284*                       CONTROL REC DB07 FILE IS NOT FOUND      *         
T13284*                       OR INVALID CONDITION OCCURS.            *         
T18579*   12/15/98  JYL       CHANGED PARA 3100-.  FOR (2), ADD 'E'   *         
T18579*                       AS A VALID AR-AGE CODE; FOR JOURNALS    *         
T18579*                       THAT ARE CREDIT APPLIED TO EPP-TRAN-BAL.*         
T17883*   01/14/99  JYL       ADDED FLAG TO LINKAGE TO SCSAC108 AND   *         
T17883*                       SCSAC112 TO ALLOW FOR EPP RECALC FOR   *          
T17883*                       CANCEL/REBILL AT EPP ANNIV. MONTH.      *         
T19317*   03/12/99  KDF       ADDED FLAG TO LINKAGE TO SCSAC110 AND   *         
T19317*                       SCSCA115 TO IDENTIFY SUCCESSFUL XFER.   *         
T19419*   03/22/99  KDF       UPDATE AMT-BILLED-UNPAID FOR REFUND     *         
T19419*                       CHECK ISSUED AT FB                      *         
T19289*   04/07/99  KDF       CHECK AMT-ORIG-ENTERED FOR NEG AND MULT *         
T19289*                       BY -1 PRIOR TO DB UPDATE (NO NEG)       *         
T19541*   04/15/99  RAH       IF AN OFF-CYCLE REBILL IS REJECTED FROM *         
T19541*                       BILLING, PULL IT BACK IN THE NEXT DAY.  *         
T19214*   04/23/99  MDJ       ADDED WS-CRED-COLL-CL TO LINKAGE TO     *         
T19214*                       SCSCA108 TO CHECK FORECASTED CREDIT     *         
T19214*                       GROUP WHEN  CHANGING CREDIT GROUP.      *         
SEB   *   06/24/99  MJL       ALLOW FOR READ CYCLE 21                 *         
KDFKDF*   09/03/99  KDF       DO NOT LET PENDING ACCTS HOLD MST FROM  *         
KDFKDF*                       BILLING                                 *         
T20710*   09/08/99  CBSI      CODE RELETED TO FCSWK00 FILE HAS BEEN   *         
T20710*             CHENNAI   DELETED.                                *         
T20910*   10/04/99  RAH       ADD CODE TO INDICATE BILLING ENTITY.    *         
T20910*                       READ THE CSS_DELINQUENCY TABLE TO PICKUP*         
T20910*                       THE VALUE AND TRANSLATE IT INTO A 1 BYTE*         
T20910*                       CODE TO BE PASSED THROUGHOUT BILLING.   *         
T21893*   03/29/00  MDJ       ADDED WS-DPP-AMOUNT-DELINQ TO LINKAGE   *         
      *                       FOR SCSCA110.                           *         
T21753*   04/14/00  CBSI      PASS WS-SECURED-RATE-FL TO THE SUBPGMS  *         
T21753*             CHENNAI   INORDER TO CORRECT METER READ EXCEPTIONS*         
T21753*                       FOR SECURED RATES                       *         
C23301*   01/25/01  VIJAY     CHANGES FOR PSNC - MCR 092 .            *         
      *                       ADDED DELINQUENCY CHANGES FOR MULTI     *         
      *                       COMPANY(CML 23501).                     *         
T23513*   01/30/01  CBSI      CHANGES MADE TO REPLACE LS-SCEG WITH    *         
T23513*             CHENNAI   CSR-DATABASE                            *         
VVKS  *   06/07/01  VIJAY     REMOVED WS-LOCAL-AND-TOTAL-ACCUM-TABLE **         
      *                       IN CALL SCSCA110 FOR EPP DROP          **         
      *                       (IN 2800-UPDATE-BILL-RESULTS).         **         
T24669*   08/09/01  RGB       CHANGED TO FIX THE SEQUENCE ERROR      **         
C23301*   08/28/01  VIJAY     LOADING OF WEATHER TREND DATA WHEN     **         
      *                       COMPANY CHANGES.                       **         
T24436*   10/18/01  NVM       CHANGES MADE TO CALL SUB PROGRAM       **         
T24436*                       SCSCB061 FOR COPYBOOK CONVERSION       **         
C26679*   06/17/02  SRIDEVI   TO AVOID CROSS FOOT ERRORS AT THE TIME **         
C26679*                       OF EPP ANNIVERSARY, WRITING AN ADJ ROW **         
C26679*                       PRIOR TO BILLING ROW IN AR_TRANS_HIST  **         
C26130*   06/28/02  SRIDEVI   REMOVE EPP OFFER LOGIC AS IT IS PUT IN **         
C26130*                       SCSCA108                               **         
T27054*   08/12/02  VIJAY     ADD JOB PARM FOR COMMONDATE TO SUBSTITUTE         
      *                       COMMONDATE VALUE FROM CSS_JOB_PARM. VALUE         
      *                       IS SUPPLIED FROM JCL THROUGH PARM.                
T26954*   08/21/02  VIJAY     20 DAY RULE FOR SEBR ACCOUNTS.                    
T27054*   09/24/02  VIJAY     INCREASE BILLCYCLES TO 8.                         
T27054*   11/14/02  VIJAY     ADD JOB PARM FOR REVENUE MONTH(YYYYMM) TO         
      *                       SUBSTITUTE REVENUE MONTH VALUE FROM               
      *                       CSS_JOB_PARM.                                     
T28586*   04/24/03  VIJAY     IF ACCOUNT IS AN ACTIVE NON-UTILITY WITH-         
      *                       OUT ACTIVE CONTRACTS AND THE TOTAL BILL IS        
      *                       IS 0, THEN A BILL SHOULD NOT BE PRODUCED.         
T27149*   06/18/03  JS83520   REMOVED CHECK FOR METER STATUS WHILE              
      *                       FETCHING SECURED RATE FLAG                        
C29752*   11/10/03  MDJ       REMOVED REFERENCE TO WS-INTEREST-RATE-            
      *                       TABLE IN WORKING STORAGE AND PARM AREA            
      *                       THAT IS SENT TO SCSCA108.  THIS IS NOT            
      *                       USED.                                             
C29752*   12/30/03  MDJ       PUT BACK CALL TO 5200-.                           
T30368*   02/20/04  VIJAY     NON-UTILITY ACCOUNTS WITH ZERO MONEY AND          
      *                       MSE CONTRACT CANCELLED, SHOULD NOT PRINT          
      *                       BILL.                                             
T30700*   04/06/04  VIJAY     NON-UTILITY ACCOUNTS WITH ZERO MONEY AND          
      *                       'MSE CANCEL CNT DET',SHOULD NOT PRINT             
      *                       BILL.                                             
T30752*   04/21/04  VIJAY     INCREASE OCCURS OF WS-WORK-DAY-TABLE              
      *                       FROM 300 TO 500 TO ACCOMMODATE                    
      *                       INCREASING THE FORECAST OF CREDIT BUREAU          
      *                       DATE TO 345 BUSINESS DAYS FROM FINAL              
T31442*   08/27/04  VIJAY     DO NOT SUPPRESS NON UTILITY ACCOUNTS WITH         
      *                       ARREARS EVEN IF CURRENT MONTH CHARGES ARE         
      *                       ZERO.                                             
T31542*   10/28/04  CVNS      MOVED CML23501 CHANGES TO PARA 1000-              
      *             CHENNAI   TO LOAD WEATHER TRED AND EXCEPTION                
      *                       LIMIT DATA WHEN COMPANY CHANGES                   
T31962*   12/14/04  VIJAY     DISPLAY CREATE DATE OF FILE AND RUN DATE          
      *                       WHEN IT ABENDS WITH CREATE DATE NOT = RUN         
      *                       DATE.                                             
T32989*   08/08/05  VIJAY     ADD JOB PARM FOR DB UPDATES(YES OR NO) TO         
      *                       OVERRIDE DB UPDATES VALUE FOR PCSCA100            
      *                       FROM CSS_JOB_PARM.                                
T32676*   09/08/05  GANESH    CHANGES MADE TO LOAD THE FIELD                    
      *                       LS-NON-SUMMER-START-MTH FROM                      
      *                       CSS_DELIQUENCY TABLE.                             
C33462** 12/01/05   DB41297   EXCLUDE RECORD FROM PROCESSING IF      **         
C33462**                      CODE-ACCT-BILLED = 'X' AND CYCLE       **         
C33462**                      NOT = 20.                              **         
C34001** 04/03/06   DB41297   CORRECT INITIALIZATION PROBLEM THAT    **         
C34001**                      DISPLAY INVALID ACCT OOBS IN BILLING   **         
T33996** 05/26/06   VIJAY  1. WHEN WS-NO-BILL IS SET FOR NO BILL IN  **         
T33996**                      SCSCA102 DO NOT GO INTO CALC UTILITY   **         
T33996**                      CHARGES(2500-).                        **         
T33996**                   2. REMOVED 7150-GET-ACCT-INFO TO GET      **         
T33996**                      ACCOUNT INFORMATION AFTER 2800- TO AVOID*         
T33996**                      MISMATCH OF AT-CREDIT-GROUP CHANGED IN  *         
T33996**                      SCSCA110(2800- PARA). AND IT IS NOT NEC-*         
T33996**                      ESSARY TO ACCESS ACCOUT TABLE AT THIS   *         
T33996**                      POINT SINCE INFORMATION ALREADY AVAILA- *         
T33996**                      IN WS-ACCOUNT-AT.                       *         
T33924**  08/15/06  DB41297  PSNC RATE CASE CHANGES                   *         
T33182** 11/03/06   DB41297   PERFORMANCE IMPROVEMENTS.                         
C34216** 07/31/06 WILLIE  CHANGE PARAGRAPH 3100 TO CHECK TO SEE IF   **         
C34216**                  EPP CUSTOMER ACCOUNT IS IN ANNIVERSARY     **         
C34216**                  MONTH AND 101 AGE = SPACES.  IF SO, ADJ ROW**         
C34216**                  HAS BEEN CREATED IN SCSCA112 SO WE NEED TO **         
C34216**                  BACKOUT ARREARS FORM AR-AMT-BILLED-UNPAID  **         
C36000**  09/17/07  JC91900   SEB REGULATED PROVIDER CHANGES.         *         
C36000**  10/16/07  ROD       RETRIEVE ACCOUNT INFO FOR NEXT ACCOUNT  *         
C36000**                      FOLLOWING A HELD OR EXCLUDED ACCOUNT.   *         
C34680** 11/01/07   VIJAY     COMMIT WHEN COMPANY CHANGES. THIS WILL  *         
C34680**                      TO HAVE ONLY ONE COMPANY IN RETRY PROC- *         
C34680**                      ESS AREA.                               *         
C34569** 04/20/08   SS95855   SEB RATE REENGINEERING CHANGES.         *         
C30169** 06/13/08   CVNS      WRITE OFF RECOVERY CHANGES CML 30169    *         
C30169**            CHENNAI   INCLUDED WS-FINAL-WO-ACTN-KD,           *         
C30169**                      WS-FINAL-WO-COLL-IZ WHILE CALLING       *         
C30169**                      SCSCA110, SCSCA102                      *         
C37761** 10/03/08   GD97441   IF WS-ON-CYCLE-BILL & CODE_ACCT_STAT='B'*         
C37761**                      THEN SKIP THE ACCOUNT FROM BILLING.     *         
C31702**                      COMMIT CONTROL RELATED INPUTS HAVE BEEN *         
C31702**                      ADDED TO JOB_PARM TABLE.                *         
C36956** 10/29/08   RC41078   BUDGET BILLING - CHANGED MESSAGES WITH  *         
C36956**                      EPP TO BBP.                             *         
I00177** 01/05/09   SS97726   PASS MAX ARRAY LIMITS IN LINKAGE AND    *         
I00177**                      REPLACE ANY RELATED HARD CODING FOR IDX *         
A01005** 05/21/09   VP94820   WHEN DB07 HAS MULTIPLE ROWS FOR THE SAME*         
A01005**                      ACCT WITH DIFF OFF-CYCLE-CD(L&R/O&R)    *         
A01005**                      -WHEN O&R, ALWAYS O WILL BE PRIORITIZED *         
A01005**                      -WHEN L&R, IF AT-TOTAL-AR-BALANCE < 0   *         
A01005**                       R WILL BE PRIORITIZED ELSE L.          *         
A00753** 05/26/09   SK42147   INORDER TO AVOID -502 WQS IN SCSCA102   *         
A00753**                      COMMIT PROGRAM FOR WS-NO-BILL.          *         
A01041** 07/09/09   SK42147   CHECK FOR NEW CLEARING GL FOR MST/SUB   *         
A01041**                      TRANSFER CLEARING GL.(184.2500)         *         
P00577** 06/04/09   AW41078   ADDED WS-CONTRACT-CONT-1C TO CALL OF 102*         
A03730** 09/15/09   MN90523   REMOVED DATA ITEMS RELATED TO           *         
A03730**                      TABLES BY, RA, LN                       *         
P00166** 08/10/09   AW41078   INCORPORATE OUTPUT MANAGMENT CHANGES TO *         
P00166**                      TRACK UNIQUE ID THROUGH BILLING.  NEW   *         
P00166**                      CSS_CORR_MAIL_STAT TABLE INCLUDED IN    *         
P00166**                      BE00.  TRACKING STATUS CODE UPDATED     *         
P00166**                      THROUGHOUT BILLING.                     *         
P00166** 11/14/09   AW41078   OUTPUT MANAGEMENT FIXES                 *         
P00166**                      1.  CORRECT ISSUE WITH BE00 RECORD      *         
P00166**                          NOT CONTAINING 6770 RECORD B/C OF   *         
P00166**                          MULT DB07 RECORDS FOR THE ACCT.     *         
P00166**                      2.  CORRECT ABEND OCCURING IN 8330 WHEN *         
P00166**                          ACCT WHICH SHOULD NOT BE TRACKED IS *         
P00166**                          XCLUDED.                            *         
P00166**                      3.  CORRECT ISSUE WITH XCLUDED ACCT NOT *         
P00166**                          TRACKED PROPERLY WHEN PREV ACCT     *         
P00166**                          HASD OFF CYCLE CODE WHICH WE DON'T  *         
P00166**                          TRACK.                              *         
P00166**                      4.  TRACK 'HAS A NEW METER THAT HAS NOT *         
P00166**                          BEEN READ YET' SCENARIO WHICH HAS NO*         
P00166**                          REJECT WQ AS BP NOT BR.             *         
P00166** 01/11/10             5.  CORRECT ISSUE WITH ACCTS NOT GETTING*         
P00166**                          TRACKED PROPERLY DURING RETRY       *         
P00246** 01/22/10   SS97726   INCLUDE SPECIAL TRANSACTION COMMENTS IF *         
P00246**                      RATE PARAMETER OVER RIDE IS PRESENT.    *         
A02036** 03/15/10   SK42147   DO NOT UPDATE AMT-ORIG-ENTERES FOR ACCTS*         
A02036** (ACT0024)            BILLED ON SAME DAY OF RECEIVING TRANSFER*         
A02036**                     (FOLLOW THE SAME LOGIC OF MST-SUB & GRNTR*         
P00257** 03/22/10   RH15956   CHANGES FOR REVENUE REPORTING PROJECT.  *         
P00251** 04/07/10   SS97726   Net Metering Project Changes.           *         
A02036** 06/28/10   SK42147   PCSCA10F should be populated for final  *         
A02036** (ACT0068)            BILLS ONLY.                             *         
A02036** 07/29/10   SK42147   ACCOUNTS WITH 2 GUARANTORS-DISPLAY BOTH *         
A02036** (ACT0091)            THE ACCOUNTS IN TRANSACTION HISTORY.    *         
A02034** 09/17/10   VV81550   1.Fix -ve sign for AR storing field  for*         
A02034** (ACT077)               master transfer from sub account.     *         
A02034**                      2.Fix not to write BILL transaction for *         
A02034**                        transfer process.                     *         
A02034**                      3.Apply PRE-PAY for master accounts.    *         
P00251** 10/05/10   VY95550   Net Metering project changes            *         
A02906** 11/09/10   VY95550   Removed CODE_ACCT_USAGE references      *         
P00453** 04/12/11   MN90523   PREPAID PLAN CHANGES                    *         
P00496** 04/05/11   SS97726   Industrial Billing Enhancements.        *         
ACT185*  09/14/11   VIJAY     PRP CHANGES.                            *         
ACT185*  A03082                                                       *         
VKSACT*  09/08/11   VIJAY     History rows creation for event process.*         
VKSACT*  P00496               This includes Curtailment, Maintenance  *         
VKSACT*                       and Standby events.                     *         
P00453** 11/11/11   VP43661   WRITE ADJ JRNLS FOR PRP ADJUSTMENTS     *         
P00599** 06/14/12   GOKUL     DO NOT SUPPRESS ACCOUNTS.               *         
P00599**                      THESE BILLS WILL BE DROPPED AFTER       *         
P00599**                      KR100 (POST BILLING CREDIT) IS COMPLETE.*         
P0599A** 10/15/12   GOKUL     SET THE CORRECT TRACKING CODE FOR       *         
P0599A**                      SUPPRESSED BILLS.                       *         
ACT002** 12/16/13   VIJAY     Replace CSS_WQ_ITEMS_MF with            *         
ACT002** A04860               CSS_WQ_ITEMS.                           *         
ACT035** 02/04/14   VIJAY     Remove TBGLNAME                         *         
ACT035** A04880                                                       *         
I01687** 02/26/14   VIJAY     ADD WS-ACCT-ATTRIBUTE-YP IN SCSCA108    *         
I01687**                      CALL.                                   *         
ACT037** 07/09/14   VIJAY     USE DATE-REQUIRED-WF FIELD IF POPULATED *         
ACT037** A04860               AS PART OF CONVERSION OF WQ-MF TO       *         
ACT037**                      CSS_WQ_ITEMS.                           *         
I01959** 08/26/15   SS45239   SOLAR/RENEWABLE NET METERING 2.0        *         
ACT108** 03/30/16   VIJAY   1.PROCESS REFUND IF ON CYCLE BILL ALSO    *         
ACT108** A05460               HAPPENS ON THE SAME DAY.                *         
ACT108**                    2.FIX JOURNALLING ISSUE FOR REFUNDS.      *         
ACT108**                    3.INSERT ACCOUNT IN OFF CYCLE TABLE TO    *         
ACT108**                      BILL NEXT DAY.                          *         
ACT255** 08/15/16   VIJAY   1.FIX PBI ACCOUNT XFER VS REGULAR SO XFER *         
ACT255** A05460               TRANS COMMENT.                          *         
ACT255**                    2.DELETED TBMFWQ  DCLGEN                  *         
ACT294** 10/06/16   VIJAY     INITIALIZE INDEXES TO SUPPORT MFES      *         
ACT294** A05460                                                       *         
ACT364** 11/29/16   VIJAY     REMOVE FIORP112 RELATED CODE.           *         
ACT364** A05460                                                       *         
      *****************************************************************         
      *****************************************************************         
      /                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      *** BE21 IS A CORRESPONDANCE FILE CREATED OUT PF PARTITION                
      *** 9 ONLY. IT RELATES TO RELEASES OF GUARANTEES.                         
       COPY CSSBE21.                                                            
       COPY CSSBE21R.                                                           
      *                                                                         
      *** DB07 IS THE LIST OF ACCOUNTS TO BE BILLED                             
       COPY CSSDB07.                                                            
      *                                                                         
      *** BE00 IS THE PRIMARY BILL EXTRACT FILE                                 
       COPY CSSBE00.                                                            
       COPY CSSBE00R.                                                           
      *                                                                         
      *** BE01 IS THE SECONDARY BILL EXTRACT FILE                               
       COPY CSSBE01.                                                            
       COPY CSSBE01R.                                                           
      *                                                                         
      *** WK02 CONTAINS LOCAL OFFICE SUMMARY TOTALS PROCESSED BY                
      *** PCSWK101                                                              
       COPY CSSWK02.                                                            
      *                                                                         
      *** WK03 CONTAINS JOURNALS TO BE PROCESSED BY PCSCA152                    
       COPY CSSWK03.                                                            
       COPY CSSWK03R.                                                           
      *                                                                         
DC    *** WK04 CONTAINS WNA REVENUE SUMMARY PROCESSED BY PCSCA101               
DC     COPY CSSWK04.                                                            
      *                                                                         
      *** WK05 IS A REPORT EXTRACT CONTAINING IDR WORKSHEET DATA                
       COPY CSSWK05.                                                            
       COPY CSSWK05R.                                                           
      *                                                                         
      *** WK06 CONTAINS REVENUE TOTALS PRINTED IN PCSCA154                      
       COPY CSSWK06.                                                            
      *                                                                         
      /                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBE21.                                                            
       COPY FIOBE21.                                                            
       COPY CFDBE21R.                                                           
       COPY FIOBE21R.                                                           
      /                                                                         
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
      /                                                                         
       COPY CFDBE00X.                                                           
       COPY FIOBE00.                                                            
       COPY CFDBE00R.                                                           
       COPY FIOBE00R.                                                           
      /                                                                         
       COPY CFDBE01X.                                                           
       COPY FIOBE01.                                                            
       COPY CFDBE01R.                                                           
       COPY FIOBE01R.                                                           
      /                                                                         
       COPY CFDWK02.                                                            
       COPY FIOWK02.                                                            
      /                                                                         
       COPY CFDWK03.                                                            
       COPY FIOWK03.                                                            
       COPY CFDWK03R.                                                           
       COPY FIOWK03R.                                                           
      /                                                                         
DC     COPY CFDWK04.                                                            
DC     COPY FIOWK04.                                                            
      /                                                                         
       COPY CFDWK05.                                                            
       COPY FIOWK05.                                                            
       COPY CFDWK05R.                                                           
       COPY FIOWK05R.                                                           
      /                                                                         
       COPY CFDWK06.                                                            
       COPY FIOWK06.                                                            
      /                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA100'.
MSQ017     COPY MFASQLM.
      /                                                                         
       01  WS-START                 PIC X(40)                           
           VALUE 'WORKING STORAGE FOR PCSCA100 STARTS HERE'.            
       01  WS-MISC.                                                     
           05  WS-NULL-IND             PIC S9(4)     COMP.              
           05  WS-NULL-IND-1           PIC S9(4)     COMP.              
           05  WS-NULL-IND-2           PIC S9(4)     COMP.              
           05  WS-NULL-IND-3           PIC S9(4)     COMP.              
           05  WS-NULL-IND-4           PIC S9(4)     COMP.              
           05  WS-NULL-IND-5           PIC S9(4)     COMP.              
           05  WS-NULL-IND-6           PIC S9(4)     COMP.              
           05  WS-NULL-IND-7           PIC S9(4)     COMP.              
           05  WS-NULL-IND-8           PIC S9(4)     COMP.              
           05  WS-NULL-IND-9           PIC S9(4)     COMP.              
           05  WS-NULL-IND-10          PIC S9(4)     COMP.              
           05  WS-NULL-IND-11          PIC S9(4)     COMP.              
           05  WS-NULL-IND-12          PIC S9(4)     COMP.              
           05  WS-NULL-IND-13          PIC S9(4)     COMP.              
           05  WS-NULL-IND-14          PIC S9(4)     COMP.              
           05  WS-GL-PRIME             PIC 9(3).                        
PCR305     05  WS-GL-PRIME1            PIC 9(3).                        
           05  WS-SEQ-NO               PIC S9(4) COMP.                  
           05  WS-PRINT-SAVE-ACCT-NO   PIC 9(13).                       
COB305     05 WS-UTIL-ENVRNMT-COUNT        PIC S9(04) COMP-3 VALUE 0.           
           05  WS-INPUT-BILL-WINDOW    PIC 9(02).                       
           05  WS-BILL-YYMM-HOLD       PIC 9(04).                       
           05  WS-RUN-DATE             PIC X(10).                       
           05  WS-WORK-DATE            PIC X(10).                       
PCR473     05  WS-CURRENT-DAY          PIC X(10).                       
           05  WS-ADJ-DAY              PIC S9(9) COMP.                  
T17931     05  WS-ITEM-ID              PIC S9(9) COMP.                  
           05  WS-CURRENT-DATE         PIC X(10).                       
           05  WS-READ-CYCLE-NUM       PIC S9(04) COMP.                 
COB305     05 WS-WK02-SUMM-TOTAL        PIC S9(11)V99 COMP-3 VALUE 0.           
COB305     05 WS-WK04-SUMM-TOTAL        PIC S9(11)V99 COMP-3 VALUE 0.           
           05  EXTRACT-RETURN-CODE     PIC S9(4) COMP.                  
           05  UPDATE-RETURN-CODE      PIC S9(4) COMP.                  
           05  CALC-RETURN-CODE        PIC S9(4) COMP.                  
           05  EPP-RETURN-CODE         PIC S9(4) COMP.                  
           05  WS-DEAD-HORSE-COUNT     PIC S9(5) COMP VALUE +0.         
COB305     05 WS-EXCEPTION-LIMIT        PIC S9(5) COMP-3 VALUE 0.               
T16223     05  WS-REVENUE-JOB-PARM     PIC 9(6).                        
C26679     05  WS-TRAN-APPL-NUM        PIC S9(4) COMP VALUE ZERO.       
C26679     05  WS-AR-TRN-APPL-NO       PIC S9(4) COMP VALUE ZERO.       
C26679     05  WS-HOLD-TOTAL-BAL       PIC S9(9)V99 COMP-3 VALUE ZERO.  
C26679     05  WS-HOLD-POSTED-AMT      PIC S9(9)V99 COMP-3 VALUE ZERO.  
C34216     05  WS-HOLD-EPP-ADJ-AMT     PIC S9(9)V99 COMP-3 VALUE ZERO.  
C26679     05  WS-ADJ-TRANSACTION      PIC X(1) VALUE 'N'.              
C26679         88  ADJ-TRANSACTION     VALUE 'Y'.                       
T19317     05  WS-TRAN-SUCCESSFUL-FL   PIC X(1) VALUE 'Y'.              
T19317         88  TRANS-SUCCESSFUL    VALUE 'Y'.                       
           05  WS-RETRY-STATUS         PIC X(1).                        
               88  RETRY-OFF           VALUE '0'.                       
               88  RETRY-NEEDED        VALUE '1'.                       
               88  RETRY-IN-PROGRESS   VALUE '2'.                       
COB305     05 WS-HOLD-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.               
COB305     05 WS-HOLD-ACCT-NO1        PIC S9(13) COMP-3 VALUE 0.               
COB305     05 WS-SAVE-XFER-ASGNE-ACCT        PIC S9(13) COMP-3 VALUE 0.         
PCR526     05  WS-SUB-COMMENT.                                          
PCR526         10  FILLER              PIC X(30)                        
PCR526               VALUE '; TRANSFER TO MASTER ACCOUNT: '.            
PCR526         10  WS-MST-ACCT-NO      PIC 9B9999B9999B9999.            
PCR526     05  WS-MASTER-COMMENT.                                       
PCR526         10  FILLER              PIC X(27)                        
PCR526               VALUE 'TRANSFERRED FROM SUB ACCT: '.               
PCR526         10  WS-SUB-ACCT-NO      PIC X(16).                       
PCR526     05  WS-MSTSUB-ACCT-NO       PIC 9B9999B9999B9999.            
PCR551     05  WS-XFER-FROM-COMMENT.                                    
PCR551         10  FILLER              PIC X(13)                        
PCR551               VALUE 'TRANSFER TO: '.                             
T13499         10  WS-XFER-TO-ACCT-NO  PIC X(13).                       
PCR551     05  WS-XFER-TO-COMMENT.                                      
PCR551         10  FILLER              PIC X(14)                        
T13616               VALUE 'TRANSFER FROM '.                            
T13499         10  WS-XFER-FR-ACCT-NO  PIC X(13).                       
PCR526     05  WS-GUARANTOR-COMMENT.                                    
PCR526         10  FILLER              PIC X(14)                        
PCR526               VALUE 'TRANSFER FROM '.                            
PCR526         10  WS-GUARANTEE-ACCT   PIC X(13).                       
PCR526         10  FILLER              PIC X(38)                        
PCR526               VALUE '; TRANSFER TYPE: GUARANTOR; STYLE: DFA'.    
PCR526     05  WS-GUARANTEE-COMMENT.                                    
PCR526         10  FILLER              PIC X(12)                        
PCR526               VALUE 'TRANSFER TO '.                              
PCR526         10  WS-GUARANTOR-ACCT   PIC X(13).                       
PCR526         10  FILLER              PIC X(38)                        
PCR526               VALUE '; TRANSFER TYPE: GUARANTOR; STYLE: DFA'.    
A02036     05  WS-GUARANTEE-COMMENT1.                                   
A02036         10  FILLER              PIC X(12)                        
A02036               VALUE 'TRANSFER TO '.                              
A02036         10  WS-GUARANTOR-ACCT1  PIC X(13).                       
A02036         10  FILLER              PIC X(1) VALUE ';'.              
A02036         10  WS-GUARANTOR-ACCT2  PIC X(13).                       
A02036         10  FILLER              PIC X(38)                        
A02036               VALUE '; TRANSFER TYPE: GUARANTOR; STYLE: DFA'.    
I01959     05  WS-XFER-TO-ASSIGNEE-COMMENT.                             
I01959         10  FILLER              PIC X(02) VALUE '. '.            
I01959         10  FILLER              PIC X(18)                        
I01959               VALUE 'Assignee Acct No: '.                        
I01959         10  WS-ASSIGNEE-ACCOUNT PIC X(13).                       
I01959         10  FILLER              PIC X(02) VALUE '. '.            
I01959         10  FILLER              PIC X(12)                        
I01959               VALUE 'Transfer to '.                              
I01959         10  WS-ASSIGNEE-NAME    PIC X(70) VALUE SPACES.          
T18208     05  STATUS-CD-PJS-SAVE      PIC X(01).                       
COB305     05 WS-DPP-AMOUNT-DELINQ        PIC S9(09)V99 COMP-3 VALUE 0.         
P00166     05  WS-OFF-CYCLE-BILL-CODE         PIC X(01).                
ACT185         88 WS-TRACK-BILL               VALUES ' ', 'O', 'B','P'. 
P00166     05  WS-OUTPUT-MANAGEMENT-FL        PIC X(01) VALUE 'Y'.      
P00166         88 WS-OUTPUT-MANAGEMENT-ON               VALUE 'Y'.      
P00166         88 WS-OUTPUT-MANAGEMENT-OFF              VALUE 'N'.      
P00166     05  WS-PREV-BARCODE-UNIQUE-ID      PIC X(09).                
COB305     05 WS-PREV-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.        
                                                                        
T17490 01  WS-CATEGORY-ID          PIC S9(04)  COMP VALUE 137.          
T17490 01  WS-WQ-COMMENTS.                                              
T17490     05  WS-WQ-COMMENTS-LEN          PIC S9(4)  COMP VALUE +105.  
T17490     05  WS-WQ-COMMENTS-TEXT.                                     
T17490         10  FILLER                  PIC X(07)  VALUE             
T17490                                              'ACCOUNT'.          
T17490         10  FILLER                  PIC X(20)  VALUE             
T17490                               ' IS OUT OF BALANCE. '.            
T17490         10  FILLER                  PIC X(25)  VALUE             
T17490                               '  AR CONTROL BALANCE IS  '.       
T17490         10  WS-WQ-AR-BALANCE        PIC -Z(10)9.99.              
T17490         10  FILLER                  PIC X(25)  VALUE             
T17490                               ' JOURNAL BALANCE IS      '.       
T17490         10  WS-WQ-ENDAR-BAL         PIC -Z(8)9.99.               
       01  WS-PART-NO                  PIC 9(02).                       
       01  WS-ACCT-NO-DISPLAY          PIC 9(13).                       
       01  WS-USER-ABEND-CODE          PIC S9(4) COMP VALUE +100.       
       01  WS-FRP112-STATUS            PIC X(02) EXTERNAL.              
           88  FRP112-SUCCESSFUL       VALUE '00'.                      
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LEN         PIC S9(04) VALUE +80 COMP.   
           05  WS-IS-THIS-A-RESTART        PIC X(01) VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART             VALUE 'Y'.          
           05  WS-PRINT-COUNTERS           PIC X(01) VALUE 'A'.         
           05  WS-RESTART-REQ              PIC X(01).                   
           05  WS-DEFAULT-RESTART-REQ      PIC X(01) VALUE 'N'.         
           05  WS-COUNT-UNSUCCESSFUL-ROWS  PIC S9(04) VALUE ZEROES COMP.
           05  WS-PROCESS-TYPE             PIC 9(01) VALUE ZERO.        
           05  WS-REPOSITION-NEEDED        PIC X(01) VALUE 'Y'.         
           05  WS-FLAG-TO-TURN-OFF-COMMITS PIC 9(04) VALUE 9999.        
C31702     05  WS-CHKP-LUW-LIMIT           PIC 9(04).                   
C31702     05  WS-CHKP-UPD-LIMIT           PIC 9(04).                   
C31702     05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04) VALUE 200.         
C31702     05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04) VALUE 200.         
           05  WS-FCSDB07-REC-CNTR         PIC S9(07) VALUE ZERO COMP-3.
           05  WS-FCSDB07-REC-CNTR-TOT     PIC S9(07) VALUE ZERO COMP-3.
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID          PIC X(02) VALUE '00'.        
               10  WS-CHKP-PART-NO         PIC 9(01) VALUE 1.           
               10  WS-CHKP-SEQ-NO          PIC 9(05) VALUE ZERO.        
           05  WS-STOP-ACCT-NO             PIC 9(13).                   
           05  WS-RPT-SEQ-NO               PIC S9(05) VALUE ZERO COMP-3.
           05  WS-RPT-SAVE-ACCT-NO         PIC 9(13)  VALUE ZERO.       
           05  WS-RECORD-COUNT-PIC-9       PIC S9(07) VALUE ZERO.       
           05  WS-RF-UPDATE-CNTR-LUW       PIC S9(07) VALUE ZERO COMP-3.
           05  WS-RF-INSERT-CNTR-LUW       PIC S9(07) VALUE ZERO COMP-3.
           05  WS-LOOP-COUNTER             PIC S9(07) VALUE ZERO COMP.  
T17582     05  WS-COUNT                    PIC S9(04) VALUE ZERO COMP-3.
A02036     05  WS-COUNT1                   PIC S9(04) VALUE ZERO COMP-3.
      *                                                                         
PCR473 01  WS-INPUT-DATA-R116.                                          
PCR473     05  WS-SYSIPT-RUN-DATE-R116         PIC  X(08).              
PCR473         88  RUN-DATE-R116               VALUE 'RUN DATE'.        
PCR473     05  FILLER                          PIC  X(01).              
PCR473     05  WS-INPUT-RUN-DATE-R116          PIC  X(10).              
PCR473     05  FILLER                          PIC  X(01).              
PCR473     05  WS-SYSIPT-LAST-DATE-R116        PIC  X(13).              
PCR473         88  LAST-DATE-R116              VALUE 'LAST RUN DATE'.   
PCR473     05  FILLER                          PIC  X(01).              
PCR473     05  WS-INPUT-LAST-DATE-R116         PIC  X(10).              
PCR473     05  FILLER                          PIC  X(36).              
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE    REDEFINES                     
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS     VALUE 'A'.          
               88  WS-RERUN-COMPLETED               VALUE 'B'.          
               88  WS-RERUN-PENDING                 VALUE 'C'.          
           05  WS-RESTART-COMMON-DATE      PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05).                   
           05  WS-RESTART-RPT-SAVE-ACCT-NO   PIC 9(13) VALUE ZERO.      
           05  WS-RESTART-PRINT-SAVE-ACCT-NO PIC 9(13) VALUE ZERO.      
PCR473     05  WS-RESTART-EXCEPTION-CTR      PIC 9(05) VALUE ZERO.      
      *** THE FOLLOWING IS USED FOR DISPLAY PURPOSES ONLY:                      
           05  WS-RESTART-ACCOUNT-NO       PIC 9(13).                   
           05  WS-RESTART-REPOSITION-KEY.                               
COB305         10 WS-RESTART-RECORD-COUNT        PIC S9(07) COMP-3 
COB305           VALUE 0.          
COB305     05 WS-RESTART-FCSBE00-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSBE01-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSWK02-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSWK03-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSWK04-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSWK05-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSWK06-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSBE11-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSBE21-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSRP112-REC-CNTR        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-RF-UPD-CNTR-TOT        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-RF-ISRT-CNTR-TOT        PIC S9(07) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-RESTART-FCSWK02-SUM-TOTL        PIC S9(11)V99 COMP-3 
COB305       VALUE 0.        
COB305     05 WS-RESTART-FCSWK04-SUM-TOTL        PIC S9(11)V99 COMP-3 
COB305       VALUE 0.        
      *                                                                         
       01  WS-STOP-PARM-BREAKDOWN.                                      
           05  WS-STOP-PARM-ACCT-NO      PIC 9(13).                     
           05  FILLER                    PIC X(35).                     
      *                                                                         
       01  WS-STATUS-AREA.                                              
           05  WS-FDB07-STATUS           PIC X(02).                     
               88  FDB07-SUCCESSFUL        VALUE '00'.                  
           05  WS-FWK02-STATUS           PIC X(02).                     
               88  FWK02-SUCCESSFUL        VALUE '00'.                  
DC         05  WS-FWK04-STATUS           PIC X(02).                     
DC             88  FWK04-SUCCESSFUL        VALUE '00'.                  
           05  WS-FWK06-STATUS           PIC X(02).                     
               88  FWK06-SUCCESSFUL        VALUE '00'.                  
           05  WS-FBE00R-STATUS          PIC X(02).                     
               88  FBE00R-SUCCESSFUL       VALUE '00'.                  
               88  FBE00R-END-OF-FILE      VALUE '10'.                  
           05  WS-FBE01R-STATUS          PIC X(02).                     
               88  FBE01R-SUCCESSFUL       VALUE '00'.                  
               88  FBE01R-END-OF-FILE      VALUE '10'.                  
           05  WS-FBE21R-STATUS          PIC X(02).                     
               88  FBE21R-SUCCESSFUL       VALUE '00'.                  
               88  FBE21R-END-OF-FILE      VALUE '10'.                  
           05  WS-FWK03R-STATUS          PIC X(02).                     
               88  FWK03R-SUCCESSFUL       VALUE '00'.                  
               88  FWK03R-END-OF-FILE      VALUE '10'.                  
           05  WS-FWK05R-STATUS          PIC X(02).                     
               88  FWK05R-SUCCESSFUL       VALUE '00'.                  
               88  FWK05R-END-OF-FILE      VALUE '10'.                  
                                                                        
       01  WS-FBE00-STATUS               PIC X(02) EXTERNAL.            
           88  FBE00-SUCCESSFUL            VALUE '00'.                  
       01  WS-FBE01-STATUS               PIC X(02) EXTERNAL.            
           88  FBE01-SUCCESSFUL            VALUE '00'.                  
       01  WS-FBE21-STATUS               PIC X(02) EXTERNAL.            
           88  FBE21-SUCCESSFUL            VALUE '00'.                  
       01  WS-FWK03-STATUS               PIC X(02) EXTERNAL.            
           88  FWK03-SUCCESSFUL            VALUE '00'.                  
       01  WS-FWK05-STATUS               PIC X(02) EXTERNAL.            
           88  FWK05-SUCCESSFUL            VALUE '00'.                  
                                                                        
TF1    01  WS-WQ-MESSAGE-DATA.                                          
TF1        05  WS-MESSAGE-PATTERN.                                      
TF1            10  WS-WQ-CATEGORY-ID       PIC S9(4) COMP.              
TF1            10  WS-WQ-PRIORITY          PIC X(1).                    
TF1            10  WS-WQ-ROUTE-CATEGORY    PIC X(1).                    
TF1            10  WS-WQ-MESSAGE-LENGTH    PIC S9(4) COMP.              
TF1            10  WS-WQ-MESSAGE-TEXT      PIC X(40).                   
TF1        05  WS-OFF-CYCLE-WARNING.                                    
T21753*        10  FILLER                  PIC S9(4) COMP VALUE +17.            
T21753         10  WS-OFCYL-CAT-ID         PIC S9(4) COMP VALUE +17.    
TF1            10  FILLER                  PIC X(1)  VALUE 'N'.         
TF1            10  FILLER                  PIC X(1)  VALUE '4'.         
TF1            10  FILLER                  PIC S9(4) COMP VALUE +76.    
TF1            10  FILLER                  PIC X(48) VALUE              
TF1                'WARNING: DEPOSIT-ONLY BILL REQUESTED WITH NORMAL'.  
TF1            10  FILLER                  PIC X(28) VALUE              
TF1                'BILL. REGULAR BILL PRODUCED.'.                      
RSN5       05  WS-SUBS-NOT-ALL-BILLED.                                  
RSN5  *        10  FILLER                  PIC S9(4) COMP VALUE +17.            
T15980         10  FILLER                  PIC S9(4) COMP VALUE +4.     
RSN5           10  FILLER                  PIC X(1)  VALUE 'N'.         
RSN5           10  FILLER                  PIC X(1)  VALUE '4'.         
RSN5           10  FILLER                  PIC S9(4) COMP VALUE +86.    
RSN5           10  FILLER                  PIC X(49) VALUE              
RSN5               'WARNING: WE ARE RECYCLING MASTER ACCOUNT BECAUSE '. 
RSN5           10  FILLER                  PIC X(37) VALUE              
RSN5               'ALL SUBS HAVE NOT BILLED SUCCESSFULLY'.             
C33462     05  WS-RECORD-EXCLUDED.                                      
C33462         10  FILLER                  PIC S9(4) COMP VALUE +17.    
C33462         10  FILLER                  PIC X(1)  VALUE 'N'.         
C33462         10  FILLER                  PIC X(1)  VALUE '4'.         
C33462         10  FILLER                  PIC S9(4) COMP VALUE +76.    
C33462         10  FILLER                  PIC X(47) VALUE              
C33462             'WARNING: THIS ACCOUNT IS EXCLUDED FROM BILLING '.   
C33462         10  FILLER                  PIC X(29) VALUE              
C33462             'AND MUST BE MANUALLY RELEASED'.                     
                                                                        
       01  WS-HOLD-WK03.                                                
COB305     03 WS-WK03-TOTAL-AR-BAL        PIC S9(9)V99 COMP-3 VALUE 0.        
           03  WS-WK03-COUNT                PIC S9(4) COMP.             
           03  WS-HOLD-WK03-DATA            PIC X(220)                  
T13536            OCCURS 5000 TIMES                                     
                  INDEXED BY WK03-INDX.                                 
                                                                        
       01  WS-FIODB07.                                                  
COB305     05 WS-FDB07-ACCT-NO        PIC S9(13) COMP-3 VALUE 0.      
           05  WS-FDB07-PROCESS-CONTROL.                                
               10  WS-ON-OFF-CYCLE-IND          PIC X(1).               
                   88  WS-OFF-CYCLE-FINAL        VALUE 'B'.             
                   88  WS-OFF-CYCLE-REBILL       VALUE 'O'.             
TP4886             88  WS-ON-CYCLE-BILL          VALUE 'A'.             
TP4569             88  WS-OFF-CYCLE-ACCT-TRANS   VALUE 'T'.             
P00453             88  WS-PRP-FIRST-EST          VALUE 'P'.             
TF1            10  WS-SINGLE-ITEM-BILL-IND      PIC X(1).               
TF1                88  WS-SINGLE-ITEM-BILL       VALUE 'S'.             
               10  WS-MASTER-ACCOUNT-IND        PIC X(1).               
                   88  WS-CONS-BILL-MAST         VALUE 'M'.             
                   88  WS-ADDITIVE-MAST          VALUE 'A'.             
               10  WS-REFUND-CONTROL-IND        PIC X(1).               
                   88  WS-PROCESS-REFUND         VALUE 'R'.             
               10  WS-GUARANTEE-TRANSFER-IND    PIC X(1).               
                   88  WS-TRANSFER-GUARANTEE     VALUE 'E'.             
                   88  WS-TRANSFER-GUARANTOR     VALUE 'G'.             
           05  WS-FDB07-NO-BILL-CYCLES          PIC S9(4) COMP.         
TF1        05  WS-FDB07-PYMT-PRIORITY-LVL       PIC S9(4) COMP.         
TF1        05  WS-FDB07-ITEM-ID                 PIC S9(9) COMP.         
TP2341     05  WS-FDB07-CREDIT-LETTER-IND       PIC X(01).              
P00166     05  WS-FDB07-BARCODE-UNIQUE-ID       PIC X(09).              
P00166     05  WS-PROCESS-UNIQUE-ID-FL          PIC X(01) VALUE 'N'.    
P00166         88 WS-PROCESS-UNIQUE-ID                    VALUE 'Y'.    
P00166         88 WS-DO-NOT-PROCESS-UNIQUE-ID             VALUE 'N'.    
COB305 01 WS-HOLD-AMT-POSTED        PIC S9(09)V99 COMP-3 VALUE 0.   
T17883 01  WS-CALC-EPP-ANNIV-FLG                PIC X(01).              
P00453 01  WS-PRP-ADJ-FLG                       PIC X(01).              
                                                                        
C23301 01  WS-PREV-COMPANY-NO                PIC X(02) VALUE SPACES.    
C23301 01  WS-CHECK-COMPANY-NO               PIC X(02) VALUE SPACES.    
                                                                        
       01  WS-HOLD-DB07-FOR-RESTART.                                    
TF1        05  WS-HOLD-DB07-ENTRY               PIC X(31)               
                  OCCURS 200 TIMES                                      
                  INDEXED BY WS-DB07-INDX.                              
       01  WS-WORK-DAY-TABLE.                                           
           03  WS-WORK-DAY-LIST                                         
T30752            OCCURS 500 TIMES                                      
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
               05  WS-WORK-DAY              PIC X(10).                  
                                                                        
       01  SCSCA103-ACCUMULATORS.                                       
           05  WS-WEATHER-DATA.                                         
              10  WS-WFT-CNTRL              PIC 9(04) COMP.             
              10  WS-WEATHER-FACTOR-TABLE.                              
                  15  WS-WEATHER-FACTOR-TABLE-RECORD                    
                          OCCURS 100 TIMES                              
                          INDEXED BY WS-WFT-INDEX.                      
KMG                   20  WS-REV-CLASS-WFT      PIC X(03).              
                      20  WS-CODE-UTIL-TYPE-WFT PIC X(1).               
COB305                20 WS-FACTOR-WFT        PIC S9(01)V9(04) COMP-3 
COB305                  VALUE 0.
COB305                20 WS-ACCUM-USAGE-WFT        PIC S9(11) COMP-3 
COB305                  VALUE 0.      
           05  WS-OPT-READ-DATE-TABLE.                                  
              10  WS-OPT-READ-DATE-DATA OCCURS 30 TIMES                 
                          INDEXED BY WS-OPT-RD-DATE-INDX.               
                  15  WS-READ-CYCLE-OP        PIC X(02).                
                  15  WS-OPT-RD-DATE-OP       PIC X(10).                
                                                                        
       01  WS-LOCAL-AND-TOTAL-ACCUM-TABLE.                              
           05  WS-LOCAL-ACCUMULATORS-DATA                               
                  OCCURS 99 TIMES                                       
                  INDEXED BY WS-LOCAL-INDEX.                            
               10  WS-LO-ACCUM-COMPANY-NO       PIC X(2).               
               10  WS-LO-ACCUM-LOCAL-OFFICE     PIC 9(3).               
               10  WS-LO-ACCUM-CONTROL          PIC X(330).             
               10  WS-LO-ACCUM-DATA.                                    
COB305             15 WS-LO-ACCUM        PIC S9(9)V99 COMP-3 
COB305               OCCURS 223 TIMES                              
COB305                    INDEXED BY WS-LA-INDX VALUE 0.                        
           05  WS-TOTAL-ACCUMULATORS-DATA.                              
               10  WS-TA-ACCUM-COMPANY-NO       PIC X(2).               
               10  WS-TA-ACCUM-LOCAL-OFFICE     PIC 9(3).               
               10  WS-TA-ACCUM-CONTROL          PIC X(330).             
               10  WS-TA-ACCUM-DATA.                                    
COB305             15 WS-TA-ACCUM        PIC S9(9)V99 COMP-3 
COB305               OCCURS 223 TIMES                              
COB305                    INDEXED BY WS-TA-INDX VALUE 0.                        
                                                                        
T11745 01  WS-LOCAL-ACCUM-HOLD.                                         
T11745     05  WS-LOCAL-DATA-HOLD                                       
T11745            OCCURS 99 TIMES                                       
T11745            INDEXED BY WS-LOCAL-INDX-HOLD.                        
T11745         10  WS-LO-HOLD                  PIC X(1673).             
T11745     05  WS-TOTAL-DATA-HOLD.                                      
T11745         10  WS-TA-HOLD                  PIC X(1673).             
                                                                        
       01  WS-LOCAL-OFFICE-REVENUE-TABLE.                               
           05  WS-LO-BILL-ISSUE-DATE           PIC X(10).               
           05  WS-LOC-OFFICE-REVENUE-RECORD                             
                  OCCURS 100 TIMES                                      
                  INDEXED BY WS-LO-REV-INDX.                            
               10  WS-LO-COMPANY-NO            PIC X(2).                
               10  WS-LO-OFFICE-NO             PIC 9(3).                
COB305         10 WS-LO-TOT-NEW-REVENUE        PIC S9(09)V99 COMP-3 
COB305           VALUE 0.    
                                                                        
DC     01  WS-WNA-REVENUE-SUMMARY-TABLE.                                
DC         05  WS-WNA-REV-SUM-ISSUE-DATE       PIC X(10).               
DC         05  WS-WNA-REVENUE-SUMMARY-RECORD                            
DC                OCCURS 25 TIMES                                       
DC                INDEXED BY WS-WNA-REV-SUM-INDX.                       
DC             10  WS-WNA-ACCOUNT-COUNT        PIC S9(09)       COMP.   
COB305         10 WS-TOTAL-WNA-RATE        PIC S9(11)V9(05) COMP-3 
COB305           VALUE 0. 
COB305         10 WS-TOTAL-WNA-REV        PIC S9(09)V99 COMP-3 VALUE 0. 
                                                                        
       01  WS-MISC-AREA    COMP.                                        
           05  WS-SUB                  PIC S9(04)  VALUE ZERO.          
           05  WS-SUB1                 PIC S9(04)  VALUE ZERO.          
           05  WS-MAX-MTR-RD-CYCLES    PIC S9(04)  VALUE +0002.         
           05  WS-MAX-BILLING-CYCLES   PIC S9(04)  VALUE +0002.         
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-BEGIN-REC-SW                  PIC X(01).              
               88  WS-BEGIN-RECS-PROCESSED       VALUE 'Y'.             
               88  WS-BEGIN-REC-NOT-PROCESSED   VALUE 'N'.              
               88  WS-START-INPUT-DATA          VALUE 'X'.              
           05  WS-END-REC-PROCESSED             PIC X(01)    VALUE 'N'. 
T17357     05  WS-IS-ACCT-ON-CYCLE-TRANSFER     PIC X(01)    VALUE 'N'. 
T17357         88  WS-ON-CYCLE-TRANSFER               VALUE 'Y'.        
T17357         88  WS-NOT-ON-CYCLE-TRANSFER           VALUE 'N'.        
           05  WS-IS-RECORD-IN-TABLE            PIC X(01)    VALUE 'N'. 
               88  WS-RECORD-IS-IN-TABLE              VALUE 'Y'.        
               88  WS-RECORD-IS-NOT-IN-TABLE          VALUE 'N'.        
           05  WS-WAS-BEBTR-CANCELLED           PIC X(01)    VALUE 'N'. 
               88  WS-BEBTR-WAS-CANCELLED             VALUE 'Y'.        
               88  WS-BEBTR-WAS-NOT-CANCELLED         VALUE 'N'.        
           05  WS-IS-THIS-A-BILLABLE-ACCOUNT    PIC X(01)    VALUE 'N'. 
               88  WS-THIS-IS-A-BILLABLE-ACCOUNT      VALUE 'Y'.        
           05  WS-IS-ACCT-ON-CYCLE              PIC X(01)    VALUE 'N'. 
               88  WS-ACCT-IS-ON-CYCLE                VALUE 'Y'.        
               88  WS-ACCT-IS-NOT-ON-CYCLE            VALUE 'N'.        
           05  WS-DOES-PRIOR-CUST-NEED-BILL   PIC X(01)    VALUE 'N'.   
               88  WS-PRIOR-CUST-NEEDS-BILL         VALUE 'Y'.          
           05  WS-TRANSFER-ONLY-RECEIVABLES     PIC X(01)    VALUE 'N'. 
               88  WS-TRANSFER-RECEIVABLES-ONLY       VALUE 'Y'.        
           05  WS-IS-CORRECT-BHH-HOOK-FOUND     PIC X(01)    VALUE 'N'. 
               88  WS-CORRECT-BHH-HOOK-IS-FOUND       VALUE 'Y'.        
           05  WS-IS-CORRECT-BILL-HOOK-FOUND     PIC X(01)    VALUE 'N'.
               88  WS-CORRECT-BILL-HOOK-IS-FOUND       VALUE 'Y'.       
           05  WS-IS-THERE-USAGE                PIC X(01)    VALUE 'N'. 
               88  WS-THERE-IS-USAGE                  VALUE 'Y'.        
           05  WS-IS-THERE-A-KVAR-METER         PIC X(01)    VALUE 'N'. 
               88  WS-THERE-IS-A-KVAR-METER           VALUE 'Y'.        
           05  WS-IS-THERE-A-QHR-METER          PIC X(01)    VALUE 'N'. 
               88  WS-THERE-IS-A-QHR-METER            VALUE 'Y'.        
           05  WS-ARE-THERE-CX-UNDR-THIS-BI    PIC X(01)    VALUE 'N'.  
               88  WS-THERE-ARE-CX-UNDR-THIS-BI      VALUE 'Y'.         
           05  WS-IS-CDM-FACTOR-FOUND         PIC X(01)    VALUE 'N'.   
               88  WS-CDM-FACTOR-IS-NOT-FOUND       VALUE 'N'.          
           05  WS-IS-THIS-A-NEW-TENANT          PIC X(01)    VALUE 'N'. 
               88  WS-THIS-IS-A-NEW-TENANT             VALUE 'Y'.       
           05  WS-FIRST-READ-ONLY               PIC X(01) VALUE 'N'.    
               88  FIRST-READ-ONLY                        VALUE 'Y'.    
           05  WS-NO-MORE-DATA       PIC X(01) VALUE 'N'.               
               88  NO-MORE-DATA                VALUE 'Y'.               
           05  WS-PROCESS-BILLING    PIC X(01) VALUE 'Y'.               
               88  PROCESS-BILLING             VALUE 'Y'.               
           05  WS-PREMISE-NO-SW              PIC X  VALUE 'N'.          
               88  PREMISE-NO-CHANGED      VALUE 'Y'.                   
           05  WS-CNTRL-REC-FLAG       PIC X(01)     VALUE 'N'.         
           05  WS-INITIAL-READ-STATUS-SW   PIC X(1).                    
               88  FIRST-INPUT-RECORD      VALUE '1'.                   
               88  SUBSEQUENT-INPUT-RECORD VALUE '0'.                   
T10622     05  WS-EPP-DROP           PIC X(01) VALUE 'N'.               
T10622         88  EPP-DROP                    VALUE 'Y'.               
T10779     05  WS-REFUND-GIVEN       PIC X(01) VALUE 'N'.               
T10779         88  REFUND-GIVEN                VALUE 'Y'.               
PCR526     05  WS-MULTIPLE-SUBS-XFER PIC X(01) VALUE 'N'.               
PCR526         88  MULTIPLE-SUBS-XFER          VALUE 'Y'.               
T12835     05  WS-CONTRACT-DEF-INT   PIC X(01) VALUE 'N'.               
T12835         88  CONTRACT-DEF-INT            VALUE 'Y'.               
T12835     05  WS-PJS-DROPPED        PIC X(01) VALUE 'N'.               
T12835         88  PJS-DROPPED                 VALUE 'Y'.               
PCR473     05  WS-CSS-BTU-FACTOR-EXISTS    PIC X(01).                   
PCR473         88  DATE-IN-CSS-BTU-FACTOR              VALUE 'Y'.       
PCR473         88  DATE-NOT-IN-CSS-BTU-FACTOR          VALUE 'N'.       
PCR473     05  WS-CSS-TEMPERATURE-EXISTS   PIC X(01).                   
PCR473         88  DATE-IN-CSS-TEMPERATURE             VALUE 'Y'.       
PCR473         88  DATE-NOT-IN-CSS-TEMPERATURE         VALUE 'N'.       
T21753     05  WS-SECURED-RATE             PIC X(01).                   
T21753         88  SECURED-RATE                        VALUE 'Y'.       
T21753         88  NOT-SECURED-RATE                    VALUE 'N'.       
C31702     05  WS-COMMIT-REQ-SW            PIC X(1)    VALUE 'Y'.       
C31702         88 WS-COMMITS-REQUIRE                   VALUE 'Y'.       
C31702         88 WS-COMMITS-NOT-REQUIRE               VALUE 'N'.       
P00246     05  WS-RT-PARM-OVRD-SW          PIC X(01).                   
P00246         88  RT-PARM-OVRD-PRESENT                VALUE 'Y'.       
P00246         88  RT-PARM-OVRD-NOT-PRESENT            VALUE 'N'.       
      /                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  ILBOABN0              PIC X(8) VALUE 'ILBOABN0'.     
               10  SCSCA102              PIC X(8) VALUE 'SCSCA102'.     
               10  SCSCA105              PIC X(8) VALUE 'SCSCA105'.     
               10  SCSCA108              PIC X(8) VALUE 'SCSCA108'.     
               10  SCSCA110              PIC X(8) VALUE 'SCSCA110'.     
               10  SCSCA112              PIC X(8) VALUE 'SCSCA112'.     
               10  SCSCA116              PIC X(8) VALUE 'SCSCA116'.     
T24436         10  SCSCB061              PIC X(8) VALUE 'SCSCB061'.     
ACT002         10  SCSCB077              PIC X(8) VALUE 'SCSCB077'.     
           05  WS-YES                  PIC X(01)     VALUE 'Y'.         
           05  WS-NO                   PIC X(01)     VALUE 'N'.         
           05  WS-13-NINES             PIC 9(13) VALUE 9999999999999.   
           05  WS-RECEIVABLE-ACCOUNT   PIC 9(3) VALUE 142.              
T17931     05  WS-GL-AR-CCC            PIC S9(03)V9(04) VALUE 142.0500. 
           05  WS-D                    PIC X(01)     VALUE 'D'.         
           05  WS-E                    PIC X(01)     VALUE 'E'.         
           05  WS-F                    PIC X(01)     VALUE 'F'.         
           05  WS-G                    PIC X(01)     VALUE 'G'.         
           05  WS-H                    PIC X(01)     VALUE 'H'.         
           05  WS-I                    PIC X(01)     VALUE 'I'.         
           05  WS-J                    PIC X(01)     VALUE 'J'.         
           05  WS-K                    PIC X(01)     VALUE 'K'.         
           05  WS-L                    PIC X(01)     VALUE 'L'.         
           05  WS-M                    PIC X(01)     VALUE 'M'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-O                    PIC X(01)     VALUE 'O'.         
           05  WS-Q                    PIC X(01)     VALUE 'Q'.         
           05  WS-R                    PIC X(01)     VALUE 'R'.         
           05  WS-S                    PIC X(01)     VALUE 'S'.         
           05  WS-T                    PIC X(01)     VALUE 'T'.         
           05  WS-U                    PIC X(01)     VALUE 'U'.         
           05  WS-W                    PIC X(01)     VALUE 'W'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-Z                    PIC X(01)     VALUE 'Z'.         
           05  WS-SYSTEM               PIC X(6)      VALUE 'SYSTEM'.    
           05  WS-PGRMNAME             PIC X(08)     VALUE 'PCSCA100'.  
           05  WS-PGRMNAME-A           PIC X(08)     VALUE 'PCSCA10A'.  
           05  WS-PGRMNAME-B           PIC X(08)     VALUE 'PCSCA10B'.  
           05  WS-PGRMNAME-C           PIC X(08)     VALUE 'PCSCA10C'.  
           05  WS-PGRMNAME-D           PIC X(08)     VALUE 'PCSCA10D'.  
PCR526     05  WS-PGRMNAME-E           PIC X(08)     VALUE 'PCSCA10E'.  
PCR526     05  WS-PGRMNAME-F           PIC X(08)     VALUE 'PCSCA10F'.  
PCR526     05  WS-PGRMNAME-G           PIC X(08)     VALUE 'PCSCA10G'.  
PCR551     05  WS-PGRMNAME-H           PIC X(08)     VALUE 'PCSCA10H'.  
T17778     05  WS-PGRMNAME-I           PIC X(08)     VALUE 'PCSCA10I'.  
I01959     05  WS-PGRMNAME-J           PIC X(08)     VALUE 'PCSCA10J'.  
I01959     05  WS-PGRMNAME-K           PIC X(08)     VALUE 'PCSCA10K'.  
T17871     05  WS-PGRMNAME-R           PIC X(08)     VALUE 'PCSCA10R'.  
ACT108***REFUND                                                                 
ACT108     05  WS-PGRMNAME-S           PIC X(08)     VALUE 'PCSCA10S'.  
           05  PROGRAM-NAME            PIC X(08)     VALUE 'PCSCA100'.  
PCR473     05  WS-PCSCA116-NAME        PIC X(08)     VALUE 'PCSCA116'.  
           05  WS-NO-BILL              PIC X(01)     VALUE 'X'.         
           05  WS-NOT-COMPANY-ACCT     PIC X(01)     VALUE 'A'.         
           05  WS-COMPANY-ACCT         PIC X(01)     VALUE 'B'.         
           05  WS-SUB-ACCT-BILL        PIC X(01)     VALUE 'Y'.         
           05  WS-TRANSFER             PIC X(01)     VALUE 'T'.         
T17242     05  WS-FINAL-BILL           PIC X(01)     VALUE 'B'.         
KDFKDF     05  WS-PNDG-ACCT            PIC X(01)     VALUE 'P'.         
T11939     05  WS-MASTER-ACCT          PIC X(01)     VALUE 'M'.         
T11939     05  WS-SUB-ACCT             PIC X(01)     VALUE 'S'.         
           05  WS-CASH-REPORT-NO       PIC X(03)     VALUE '997'.       
           05  WS-CASH-DRAWER-ID       PIC S9(04) COMP VALUE 9999.      
           05  WS-CASH-COMPANY-NO      PIC X(02)     VALUE '01'.        
           05  WS-ACTIVE               PIC X(01)     VALUE 'A'.         
T21753     05  WS-CATEGORY-ID-17       PIC S9(04) COMP VALUE 17.        
T21753     05  WS-CATEGORY-ID-138      PIC S9(04) COMP VALUE 138.       
C32676     05  WS-DELI-NON-SUMMER-MTH  PIC X(20) VALUE                  
C32676                                    'NON-SUMMER-START-MTH'.       
P00246     05  WS-RT-PARM-OVRD         PIC X(04) VALUE 'RTOV'.          
P00166***  SEE CSS_TRACK_STATUS USER TABLE FOR ALL TRACKING STATUS              
P00166***  CODES.  ALL BILLING STATUS CODES SHOULD BEGIN WITH 'B'.              
P00166***  ONLY ACCOUNTS TRACKED AS 'WS-TRACK-BILLED..' WILL BE SENT            
P00166***  TO BILL PRINT VIA BE00.                                              
P00166     05  WS-TRACKING-STATUS-CD   PIC X(02) VALUE '  '.            
P00166         88  WS-TRACK-BILL-XCLUDE    VALUE 'BX'.                  
P00166         88  WS-TRACK-BILL-REJECT    VALUE 'BR'.                  
P00166         88  WS-TRACK-BILL-MISC      VALUE 'BM'.                  
P00166         88  WS-TRACK-BILL-SUPPRESS  VALUE 'BP'.                  
P00166         88  WS-TRACK-BILLED-NORMAL  VALUE 'BN'.                  
P00166         88  WS-TRACK-BILLED-CIG     VALUE 'BC'.                  
P00166         88  WS-TRACK-BILLED-SECRATE VALUE 'BS'.                  
P00166         88  WS-TRACK-BILLED-REBILL  VALUE 'BI'.                  
      *                                                                         
TP5228 01  RS-RPC-RETURN-CODE.                                          
TP5228     05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
TP5228     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                         
P00496 01  WS-CALL-ENVIRONMENT         PIC X(01) VALUE SPACES.          
P00496     88 ONLINE-CALL              VALUE 'O'.                       
P00496     88 BATCH-CALL               VALUE 'B'.                       
      *                                                                         
      /****** JOBS FILE/TABLE DEFINITIONS                                       
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      /****** CJF00104 IS JOURNAL DATA                                          
       COPY CJF00104.                                                           
PCR526/****** CJF00103 IS JOURNAL DATA                                          
PCR526 COPY CJF00103.                                                           
      /****** CWS00006 CONTAINS MISC AR CONTROL WORK FIELDS                     
       COPY CWS00006.                                                           
      /****** CWS00024 CONTAINS COMMON SUBROUTINE DATA                          
       COPY CWS0024B.                                                           
      /****** CWS00038 IS JC01 WORK DATA                                        
       COPY CWS00038.                                                           
       01  WS-INPUT-DATA-R8  REDEFINES  WS-INPUT-DATA-BREAKDOWN.        
           05  WS-SYSIPT-R8              PIC X(17).                     
               88  BILL-CYCLE-WINDOW         VALUE 'BILL CYCLE WINDOW'. 
           05  FILLER                    PIC X(01).                     
           05  WS-INPUT-BILL-WINDOW-PARM PIC 9(02).                     
           05  FILLER                    PIC X(33).                     
      /****** CWS00039 IS CA00 WORK DATA                                        
       COPY CWS00039.                                                           
      /****** CWS00041 CONTAINS A LIST OF PAYMENT PRIORITY LEVELS               
       COPY CWS00041.                                                           
      /****** CWS00056 EXPANDS CODES-DATA-PRESENT                               
       COPY CWS00056.                                                           
      /****** CWS00061 HAS GL NUMBERS                                           
       COPY CWS00061.                                                           
      /****** CWS10000 CONTAINS BE00 RECORD LAYOUTS                             
       COPY CWS1000A.                                                           
       COPY CWS1000B.                                                           
      /****** CWS10001 CONTAINS BE01 RECORD LAYOUTS                             
       COPY CWS1001A.                                                           
       COPY CWS1001B.                                                           
      /****** CWS00303 CONTAINS WS-WARNING-DATA-ELEMENTS                        
       COPY CWS00303.                                                           
      /****** WORK QUEUE BUILD AREA                                             
       COPY CWS0070B.                                                           
      /****** STANDARD ABEND COPYBOOK                                           
TP5228 COPY CWS00010.                                                           
      /****** RESTART-RECOVERY DELINQUENCY VARIABLES                            
PCR473 COPY CWS00314.                                                           
ACT002                                                                  
ACT002/****** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077             
ACT002      EXEC SQL                                                            
ACT002           INCLUDE CWS00077                                               
ACT002      END-EXEC.                                                           
ACT002*                                                                         
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE SQLCA                                                  
            END-EXEC.                                                           
      /                                                                         
            EXEC SQL                                                            
                 INCLUDE TBACCT                                                 
            END-EXEC.                                                           
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBRESTRT                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBHLDAY                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
                INCLUDE TBRDWNDW                                                
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBMSTSUB                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBOFFCYL                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBGLACCT                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPINT                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
               INCLUDE TBWTHTRD                                                 
           END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
T11939         INCLUDE TBPENXFR                                                 
           END-EXEC.                                                            
      /                                                                         
PCR473     EXEC SQL                                                             
PCR473         INCLUDE TBDELQ                                                   
PCR473     END-EXEC.                                                            
      /                                                                         
T21753     EXEC SQL                                                             
T21753         INCLUDE TBRTDESC                                                 
T21753     END-EXEC.                                                            
T21753/                                                                         
T21753     EXEC SQL                                                             
T21753         INCLUDE TBUTLENV                                                 
T21753     END-EXEC.                                                            
T21753/                                                                         
T21753     EXEC SQL                                                             
T21753         INCLUDE TBMTRENV                                                 
T21753     END-EXEC.                                                            
      /                                                                         
           EXEC SQL                                                             
C23301       INCLUDE TBCOMPNY                                                   
C23301     END-EXEC.                                                            
      /                                                                         
A02036******************************************************************        
A02036* GU - CSS_GUARANTOR                                                      
A02036******************************************************************        
A02036     EXEC SQL                                                             
A02036       INCLUDE TBGTNTR                                                    
A02036     END-EXEC.                                                            
      /                                                                         
P00166*                                                                         
P00166******************************************************************        
P00166* MW - CSS_CORR_MAIL_STAT                                        *        
P00166******************************************************************        
P00166       EXEC SQL                                                           
P00166           INCLUDE TBMAILST                                               
P00166       END-EXEC.                                                          
P00166*                                                                         
           EXEC SQL                                                     
               DECLARE OPT_READ_DATE CURSOR FOR                         
               SELECT                                                   
                       READ_CYCLE,                                      
                       OPTIMUM_READ_DATE                                
                  FROM  CSS_READ_WINDOW A WITH(READUNCOMMITTED)                 
                  WHERE DATE_MTR_RD_XTRCT =                             
                           (SELECT MAX(DATE_MTR_RD_XTRCT)               
                            FROM CSS_READ_WINDOW B WITH(READUNCOMMITTED)        
                            WHERE A.READ_CYCLE = B.READ_CYCLE           
                            AND DATE_MTR_RD_XTRCT < 
              IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ))       
                 ORDER BY A.READ_CYCLE ASC                              
T33182           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OPT_READ_DATE CURSOR FOR                                 
MFA-TR*        SELECT                                                           
MFA-TR*                READ_CYCLE,                                              
MFA-TR*                OPTIMUM_READ_DATE                                        
MFA-TR*           FROM  CSS_READ_WINDOW A                                       
MFA-TR*           WHERE DATE_MTR_RD_XTRCT =                                     
MFA-TR*                    (SELECT MAX(DATE_MTR_RD_XTRCT)                       
MFA-TR*                     FROM CSS_READ_WINDOW B                              
MFA-TR*                     WHERE A.READ_CYCLE = B.READ_CYCLE                   
MFA-TR*                     AND DATE_MTR_RD_XTRCT < :WS-RUN-DATE)               
MFA-TR*          ORDER BY A.READ_CYCLE ASC                                      
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      /                                                                         
      /                                                                         
TP6075     EXEC SQL                                                     
TP6075        DECLARE WEATHER_TREND CURSOR FOR                          
TP6075         SELECT CODE_REVENUE_CLASS,                               
TP6075                FACTOR,                                           
TP6075                UNITS_ACCUM,                                      
TP6075                CODE_UTIL_TYPE                                    
TP6075           FROM CSS_WEATHER_TREND WITH(READUNCOMMITTED)                   
TP6075          WHERE DATE_BILL  = IIF(TRY_CONVERT(DATE, :WT-DATE-BILL
              ) IS NULL OR (PATINDEX('%.%', :WT-DATE-BILL
              ) <> 0) OR (LEN(:WT-DATE-BILL) <> 10), CIS.CHAR2DATE(
                                                          :WT-DATE-BILL
              ), CONVERT(DATE, :WT-DATE-BILL) )                        
C23301            AND COMPANY_NO = :WT-COMPANY-NO                       
T33182           FOR READ ONLY                                  
TP6075     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE WEATHER_TREND CURSOR FOR                                  
MFA-TR*        SELECT CODE_REVENUE_CLASS,                                       
MFA-TR*               FACTOR,                                                   
MFA-TR*               UNITS_ACCUM,                                              
MFA-TR*               CODE_UTIL_TYPE                                            
MFA-TR*          FROM CSS_WEATHER_TREND                                         
MFA-TR*         WHERE DATE_BILL  = :WT-DATE-BILL                                
MFA-TR*           AND COMPANY_NO = :WT-COMPANY-NO                               
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      /                                                                         
T21753     EXEC SQL                                                     
T21753         DECLARE RATE_PLAN CURSOR FOR                             
T21753            SELECT  SECURED_RATE_FL                               
T21753              FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),            
T27149*                   CSS_MTRD_ENVRNMT MN,                                  
T21753                    CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)           
T21753             WHERE  UT.ACCOUNT_NO        = :UT-ACCOUNT-NO         
T27149*              AND  UT.ACCOUNT_NO        = MN.ACCOUNT_NO                  
T27149*              AND  UT.CODE_UTIL_TYPE    = MN.CODE_UTIL_TYPE              
T27149*              AND  UT.IC_NO             = MN.IC_NO                       
T21753               AND  UT.RATE_PLAN_NO      = RD.RATE_PLAN_NO        
T21753               AND  UT.CODE_UTIL_TYPE    = RD.CODE_UTIL_TYPE      
T27149*              AND  MN.CODE_METER_STATUS NOT IN ('J', 'K')                
T33182           FOR READ ONLY                                  
T21753     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_PLAN CURSOR FOR                                     
MFA-TR*           SELECT  SECURED_RATE_FL                                       
MFA-TR*             FROM  CSS_UTIL_ENVRNMT UT,                                  
MFA-TR*                   CSS_MTRD_ENVRNMT MN,                                  
MFA-TR*                   CSS_RATE_PLAN_DESC RD                                 
MFA-TR*            WHERE  UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                 
MFA-TR*              AND  UT.ACCOUNT_NO        = MN.ACCOUNT_NO                  
MFA-TR*              AND  UT.CODE_UTIL_TYPE    = MN.CODE_UTIL_TYPE              
MFA-TR*              AND  UT.IC_NO             = MN.IC_NO                       
MFA-TR*              AND  UT.RATE_PLAN_NO      = RD.RATE_PLAN_NO                
MFA-TR*              AND  UT.CODE_UTIL_TYPE    = RD.CODE_UTIL_TYPE              
MFA-TR*              AND  MN.CODE_METER_STATUS NOT IN ('J', 'K')                
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
C23301     EXEC SQL DECLARE COMPANY_CURSOR CURSOR FOR                   
C23301        SELECT COMPANY_NO,                                        
C23301               COMPANY_NAME,                                      
C23301               TEMPERATURE_REQ_FL,                                
C23301               BTU_FACTOR_REQ_FL,                                 
C23301               WEATHER_TND_REQ_FL,                                
C23301               CALC_WNA_METHOD_CD                                 
C23301          FROM CSS_COMPANY WITH(READUNCOMMITTED)                          
C23301         WHERE TEMPERATURE_REQ_FL = 'Y'                           
C23301            OR BTU_FACTOR_REQ_FL  = 'Y'                           
C23301            OR WEATHER_TND_REQ_FL = 'Y'                           
C23301      ORDER BY COMPANY_NO                                         
T33182      FOR READ ONLY                                       
C23301     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE COMPANY_CURSOR CURSOR FOR                           
MFA-TR*       SELECT COMPANY_NO,                                                
MFA-TR*              COMPANY_NAME,                                              
MFA-TR*              TEMPERATURE_REQ_FL,                                        
MFA-TR*              BTU_FACTOR_REQ_FL,                                         
MFA-TR*              WEATHER_TND_REQ_FL,                                        
MFA-TR*              CALC_WNA_METHOD_CD                                         
MFA-TR*         FROM CSS_COMPANY                                                
MFA-TR*        WHERE TEMPERATURE_REQ_FL = 'Y'                                   
MFA-TR*           OR BTU_FACTOR_REQ_FL  = 'Y'                                   
MFA-TR*           OR WEATHER_TND_REQ_FL = 'Y'                                   
MFA-TR*     ORDER BY COMPANY_NO                                                 
MFA-TR*     FOR FETCH ONLY WITH UR                                              
MFA-TR*    END-EXEC.                                                            
T21753/                                                                         
T27054 LINKAGE SECTION.                                                 
P00166***  THE FOLLOWING JCL PARMS MAY BE USED BY BAT OR DEVELOPERS TO          
P00166***  OVERRIDE JOB PARM TABLE VALUES. THESE ARE NOT USED IN PROD.          
P00166***  PARM-OUTPUT-MANAGEMENT-FL WILL OVERRIDE THE PROCESS FLAG FOR         
P00166***  THE SCSCA165 JOB PARM WHICH CONTROLS WHETHER OUTPUT                  
P00166***  MANAGMENT FUNCTIONALITY TO CREATE AND TRACK UNIQUE IDS               
P00166***  IS TURNED ON OR OFF (Y OR N).                                        
T27054 01  PARMIN.                                                      
T27054     05  PARMLENGTH                   PIC S9(04) COMP.            
T27054     05  PARM-COMMON-DATE             PIC X(10).                  
T27054     05  PARM-REVENUE-MONTH           PIC X(06).                  
T32989     05  PARM-DATABASE-UPDATES        PIC X(01).                  
P00166     05  PARM-OUTPUT-MANAGEMENT-FL    PIC X(01).                  
                                                                        
T27054 PROCEDURE DIVISION USING PARMIN.                                 
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    0000-MAINLINE                                             **         
      *                                                              **         
      *    PERFORM INITIALIZATION TO OPEN FILES/INIT CWS10000 ETC    **         
      *                                                              **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       0000-MAINLINE.                                                   
I00177     INITIALIZE WS-MISC                                           
I00177                WS-SQL-ERROR-TXT-WQ.                              
           MOVE LENGTH OF WS-RESTART-DATA TO WS-RESTART-DATA-LEN.       
                                                                        
           SET WS-BEGIN-REC-NOT-PROCESSED TO TRUE.                      
           MOVE ZEROES TO WS-FCSDB07-REC-CNTR                           
                          WS-RESTART-RECORD-COUNT.                      
      *                                                                         
      *    WHEN 'COMMONDATE' VALUE SUPPLIED THROUGH JCL SKIP PCSCA100           
      *    CHECK FROM CSS_JOB_PARM                                              
      *                                                                         
T27054     IF PARMLENGTH > 0                                            
T27054        CONTINUE                                                  
T27054     ELSE                                                         
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
T27054     END-IF.                                                      
      *                                                                         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE
           END-IF.               
      *                                                                         
      *                                                                         
      *    PARM-COMMON-DATE PASSED FROM JCL THROUGH PARM TO OVERRIDE            
      *    'COMMONDATE' VALUE FROM CSS_JOB_PARM                                 
      *                                                                         
T27054     IF PARMLENGTH > 0                                            
T27054        MOVE PARM-COMMON-DATE TO WS-INPUT-DATE                    
T27054     END-IF.                                                      
      *                                                                         
           MOVE WS-INPUT-DATE TO WS-RUN-DATE                            
                                 LS-INPUT-DATE                          
      *  BEGIN - CML 23301  ***                                                 
      *  MOVED TO 7000- PARA DUE TO MULTI COMPANY CHANGES ***                   
PCR473***  PERFORM 6500-LOAD-EXCP-LIMITS THRU                                   
PCR473***          6500-LOAD-EXCP-LIMITS-EXIT.                                  
      *                                                                         
T23513*    MOVE WS-DATABASE                  TO  LS-DATABASE.                   
T23513*                                                                         
      *  END   - CML 23301  ***                                                 
           OPEN INPUT FCSDB07-FILE.                                     
           IF FDB07-SUCCESSFUL                                          
              PERFORM 5001-PROCESS-BEGIN-REC  THRU  5001-EXIT           
                   UNTIL WS-START-INPUT-DATA                            
      *                                                                         
           ELSE                                                         
               DISPLAY '0000-ERROR ON FCSDB07 OPEN.  STATUS IS '        
                        WS-FDB07-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF                                                       
      *                                                                         
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
      *                                                                         
           PERFORM 0600-GET-RESTART-REQUEST THRU 0600-EXIT              
           IF WS-THIS-IS-A-RESTART                                      
              PERFORM 0602-VALIDATE-REQUEST THRU 0602-EXIT              
           END-IF                                                       
           PERFORM 0605-VALIDATE-RESTART-REQ THRU 0605-EXIT.            
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-Y TO WS-REPOSITION-NEEDED                        
                                                                        
               IF WS-PROCESS-TYPE EQUAL 1                               
T14563             MOVE WS-RESTART-FCSWK02-SUM-TOTL TO                  
T14563                       WS-WK02-SUMM-TOTAL                         
T14563             MOVE WS-RESTART-FCSWK04-SUM-TOTL TO                  
T14563                       WS-WK04-SUMM-TOTAL                         
T15042             MOVE WS-RESTART-FCSRP112-REC-CNTR TO                 
T15042                       LS-FCSRP112-REC-CNTR                       
T15042             MOVE WS-RESTART-FCSBE21-REC-CNTR TO                  
T15042                       LS-FCSBE21-REC-CNTR                        
T15042             MOVE WS-RESTART-FCSWK05-REC-CNTR TO                  
T15042                       LS-FCSWK05-REC-CNTR                        
PCR473             MOVE WS-RESTART-EXCEPTION-CTR TO WS-DEAD-HORSE-COUNT 
                   MOVE WS-RESTART-RECORD-COUNT TO WS-LOOP-COUNTER      
                   MOVE 2 TO WS-RESTART-RECORD-COUNT                    
                   SUBTRACT 2 FROM WS-LOOP-COUNTER                      
      ** 2 BECAUSE THE FIRST 2 RECORDS (HEADER PLUS 1ST                         
      ** DATA) HAVE ALREADY BEEN READ                                           
                   PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT             
                           WS-LOOP-COUNTER TIMES                        
               END-IF                                                   
               PERFORM 0120-OPEN-RESTART THRU 0120-EXIT                 
           ELSE                                                         
               INITIALIZE WS-RESTART-DATA                               
      ** THE FIRST 2 RECORDS (HEADER PLUS 1 DATA) HAVE ALREADY BEEN READ        
               MOVE 2 TO WS-RESTART-RECORD-COUNT                        
PCR473         MOVE 0 TO WS-RESTART-EXCEPTION-CTR                       
               MOVE WS-C TO WS-RESTART-JOB-STATUS                       
                                                                        
               PERFORM 0110-OPEN-NORMAL THRU 0110-EXIT                  
               PERFORM 5100-WRITE-BEGIN-CONTROLS THRU 5100-EXIT         
               MOVE 1 TO WS-PROCESS-TYPE                                
      *        *******************************************************          
      *          ISSUE INITIAL CHECKPOINT                                       
      *        *******************************************************          
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
                                                                        
T14039*        PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT                           
                                                                        
               MOVE WS-Y TO WS-REPOSITION-NEEDED                        
               MOVE WS-INPUT-DATE TO WS-RESTART-COMMON-DATE             
           END-IF                                                       
                                                                        
           SET FIRST-INPUT-RECORD TO TRUE                               
           IF WS-PROCESS-TYPE = 1                                       
               PERFORM 1000-PROCESS-ALL-FCSDB07 THRU 1000-EXIT          
                 UNTIL NO-MORE-DATA                                     
      ****************************************************************          
      *    THE FOLLOWING STATEMENTS ISSUE ERROR MESSAGES AND TERMINATE          
      *    THE PROGRAM ABNORMALLY IF THE COUNT FIELD ACCUMULATED                
      *    DURING READ OF THE INPUT FILE DOES NOT MATCH THE SUM OF              
      *    THE RECORD COUNT FIELDS ON ALL ENDING CONTROL RECORDS OF             
      *    EACH FILE:                                                           
      ****************************************************************          
              IF WS-FCSDB07-REC-CNTR NOT = WS-FCSDB07-REC-CNTR-TOT      
T13284          IF WS-FCSDB07-REC-CNTR-TOT = 0                          
T13284            DISPLAY '**         PCSCA100 PROCESSING ERROR      **'
T13284            DISPLAY '** CONTROL REC IS INVALID OR NOT FOUND    **'
T13284            DISPLAY '** CONTROL REC COUNT = '                     
                         WS-FCSDB07-REC-CNTR-TOT                        
T13284            DISPLAY '** ACTUAL REC COUNT  = '                     
                         WS-FCSDB07-REC-CNTR                            
T13284            DISPLAY '**           PROCESSING TERMINATED        **'
T13284            PERFORM 9900-ABEND THRU 9900-EXIT                     
T13284          ELSE                                                    
                  DISPLAY '**         PCSCA100 PROCESSING ERROR      **'
                  DISPLAY '** ACTUAL REC COUNT NOT = CNTL REC        **'
                  DISPLAY '** CONTROL REC COUNT = '                     
                         WS-FCSDB07-REC-CNTR-TOT                        
                  DISPLAY '** ACTUAL REC COUNT  = '                     
                         WS-FCSDB07-REC-CNTR                            
                  DISPLAY '**           PROCESSING TERMINATED        **'
                  PERFORM 9900-ABEND THRU 9900-EXIT                     
T13284          END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ****************************************************************          
      * ISSUE A CHECKPOINT AFTER COMPLETION OF PROCESSING LOOP #1:              
      ****************************************************************          
           IF WS-THIS-IS-A-RESTART                                      
                  AND WS-PROCESS-TYPE GREATER THAN 1                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 2 TO WS-PROCESS-TYPE                                
               MOVE WS-N TO WS-REPOSITION-NEEDED                        
C31702         IF WS-COMMITS-REQUIRE                                    
                  PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT                
C31702         END-IF                                                   
               MOVE WS-Y TO WS-REPOSITION-NEEDED                        
           END-IF                                                       
      *                                                                         
           PERFORM 4000-WRITE-SUMMARY-FILES THRU 4000-EXIT.             
           PERFORM 5110-WRITE-END-CONTROLS THRU 5110-EXIT               
      *                                                                         
      ****************************************************************          
      * UPGRADE THE JOB-COMPLETE FIELD TO INDICATE SUCCESSFUL COMPLETION        
      ****************************************************************          
           MOVE SPACES TO WS-RESTART-JOB-COMPLETE.                      
           IF WS-THIS-IS-A-RESTART                                      
               MOVE WS-B TO WS-RESTART-JOB-STATUS                       
           ELSE                                                         
               MOVE WS-A TO WS-RESTART-JOB-STATUS
           END-IF.                      
           PERFORM 8890-MAINTAIN-RESTART THRU 8890-EXIT                 
      *                                                                         
           IF WS-PRINT-COUNTERS EQUAL WS-B OR WS-C                      
              PERFORM 8870-PRINT-COUNTERS THRU 8870-EXIT
           END-IF.               
                                                                        
           IF WS-RESTART-REQ = WS-YES                                   
              PERFORM 8893-RESET-RESTART-REQ-PARM THRU 8893-EXIT
           END-IF.       
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    0100-INITIALIZATION                                       **         
      *                                                              **         
      *    OPEN FILES                                                **         
      *    READ JOBS TABLE TO OBTAIN RUN DATE/COMMON DATE            **         
      *    PERFORM 0200- PARAGRAPH TO OBTAIN BILL WINDOW PARMS       **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       0100-INITIALIZATION.                                             
           INITIALIZE WS-WEATHER-DATA                                   
                      WS-OPT-READ-DATE-TABLE                            
                      WS-WORK-DAY-TABLE                                 
                      WS-LOCAL-AND-TOTAL-ACCUM-TABLE                    
T11745                WS-LOCAL-ACCUM-HOLD                               
                      WS-LOCAL-OFFICE-REVENUE-TABLE                     
DC                    WS-WNA-REVENUE-SUMMARY-TABLE                      
                      WS-FIODB07                                        
           MOVE WS-INPUT-DATE TO WS-LO-BILL-ISSUE-DATE                  
DC                               WS-WNA-REV-SUM-ISSUE-DATE.             
           INITIALIZE WS-HOLD-DB07-FOR-RESTART                          
           SET WS-DB07-INDX TO 1                                        
           SET RETRY-OFF TO TRUE                                        
      *                                                                         
C31702     PERFORM 6253-GET-FJC01-CHKP-LIMIT  THRU 6253-EXIT.           
C31702*                                                                         
C31702     IF WS-CHKP-LUW-LIMIT    = WS-FLAG-TO-TURN-OFF-COMMITS        
C31702       AND WS-CHKP-UPD-LIMIT = WS-FLAG-TO-TURN-OFF-COMMITS        
C31702         SET WS-COMMITS-NOT-REQUIRE TO TRUE                       
C31702         DISPLAY '********************************************'   
C31702         DISPLAY '**   ' WS-PGRMNAME ' INFORMATIONAL MSG    **'   
C31702         DISPLAY '** JOB PARM INPUTS CHKP-LUW AND CHKP-UPD  **'   
C31702         DISPLAY '** BOTH SET TO ' WS-FLAG-TO-TURN-OFF-COMMITS    
C31702         DISPLAY '** THIS INDICATES THAT INTERIM COMMIT     **'   
C31702         DISPLAY '** POINTS SHOULD NOT BE TAKEN.            **'   
C31702         DISPLAY '********************************************'   
C31702     END-IF.                                                      
      *                                                                         
      **   INITIALIZE LS-PCSCA100-COMM-AREA.                                    
                                                                        
      *                                                                         
           PERFORM 0200-GET-BILLING-PARAMETERS THRU 0200-EXIT.          
           IF PROCESS-BILLING                                           
TP6075        PERFORM 0250-LOAD-WEATHER-TREND-INFO  THRU 0250-EXIT
           END-IF.     
      *                                                                         
T31542     MOVE E-FDB07-COMPANY-NO               TO   C8-COMPANY-NO     
T31542     PERFORM 6500-LOAD-EXCP-LIMITS         THRU                   
T31542                                  6500-LOAD-EXCP-LIMITS-EXIT      
T31542     MOVE WS-DATABASE        TO  LS-DATABASE                      
      *                                                                         
T31542     IF E-FDB07-DB-PART-BREC = 9                                  
T31542        MOVE WS-RR-WQ-BILLING9 TO WS-EXCEPTION-LIMIT              
T31542     ELSE                                                         
T31542        MOVE WS-RR-WQ-BILLING  TO WS-EXCEPTION-LIMIT              
T31542     END-IF.                                                      
                                                                        
C32676     MOVE ZEROES                     TO LS-NON-SUMMER-START-MTH   
C32676     MOVE E-FDB07-COMPANY-NO         TO C8-COMPANY-NO             
C32676     MOVE WS-DELI-NON-SUMMER-MTH TO C8-DELINQ-CD                  
C32676     PERFORM 6550-LOAD-NON-SUMMER-ST-MTH THRU 6550-EXIT.          
C32676     IF SQLCODE = SUCCESSFUL-CALL                                 
C32676        MOVE C8-DELINQ-VALUE       TO LS-NON-SUMMER-START-MTH     
C32676     END-IF                                                       
                                                                        
      *                                                                         
           PERFORM 6255-GET-FJC01-PRT-CNTR     THRU 6255-EXIT.          
      *                                                                         
           PERFORM 6235-GET-FJC01-RESTART-REQ THRU 6235-EXIT.           
      *                                                                         
           PERFORM 7560-OPEN-OPT-READ-DATE-CSR      THRU 7560-EXIT.     
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 7565-FETCH-OPT-READ-DATE-CSR THRU 7565-EXIT      
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE RW-READ-CYCLE        TO  WS-READ-CYCLE-NUM       
SEB               IF WS-READ-CYCLE-NUM > ZERO AND <= 21                 
                     SET WS-OPT-RD-DATE-INDX   TO  WS-READ-CYCLE-NUM    
                     MOVE RW-READ-CYCLE                                 
                       TO WS-READ-CYCLE-OP (WS-OPT-RD-DATE-INDX)        
                     MOVE RW-OPTIMUM-READ-DATE                          
                       TO WS-OPT-RD-DATE-OP (WS-OPT-RD-DATE-INDX)       
                  END-IF                                                
               END-IF                                                   
           END-PERFORM                                                  
           PERFORM 7570-CLOSE-OPT-READ-DATE-CSR     THRU 7570-EXIT.     
                                                                        
           PERFORM 0130-LOAD-WORK-DAYS              THRU 0130-EXIT.     
           MOVE ZERO TO LS-CURR-WQ-ITEM.                                
                                                                        
T24436***        COPYBOOK CPD00061 CHANGES STARTS HERE         *****            
T24436***INCLUDE COMMENTED TO CALL SCSCB061 BATCH SUB PROGRAM TO                
T24436***                  LOAD GL NO VALUES                                    
T24436***  PERFORM 0700-LOAD-GL-NO-VALUES THRU 0700-EXIT                        
T24436***       VARYING WS-VALID-CO-SUB FROM 1 BY 1 UNTIL                       
T24436***       WS-VALID-CO-SUB > WS-MAX-CO                                     
T24436***         OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = 99                      
T24436*                                                                         
T24436     MOVE WS-PGRMNAME                   TO                        
T24436                                        WS-CPD00061-CALLING-PGM.  
T24436     MOVE SPACES                        TO  ABEND-FUNCTION.       
T24436     CALL SCSCB061  USING   WS-GL-ACCT-NAME,                      
T24436                            WS-GL-ACCT-MAJOR-FIELDS,              
T24436                            WS-VALID-COMPANY-NOS,                 
T24436                            WS-GL-NAME-INFO,                      
T24436                            WS-GL-ACCT-NO-TABLE,                  
T24436                            WS-CPD00061-CALLING-PGM,              
T24436                            ABEND-FILE,                           
T24436                            RS-RETURN-CODE.                       
T24436                                                                  
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T24436     END-IF.                                                      
T24436***        COPYBOOK CPD00061 CHANGES ENDS HERE             ****           
      *                                                                         
PCR473     PERFORM 0800-GET-RUN-DATES      THRU 0800-EXIT.              
PCR473     MOVE WS-INPUT-LAST-DATE-R116   TO WS-CURRENT-DAY.            
                                                                        
T23513     IF CSR-DATABASE                                              
C23301        PERFORM 0810-CHECK-FOR-BTU-TEMP  THRU 0810-EXIT           
T20910           UNTIL WS-CURRENT-DAY EQUAL WS-INPUT-RUN-DATE-R116
           END-IF.     
                                                                        
PCR473     MOVE PROGRAM-NAME              TO WS-PGRMNAME.               
C29752*                                                                         
C29752     PERFORM 5200-GET-RELATIVE-DATES THRU 5200-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0110-OPEN-NORMAL.                                                
      *                                                                         
           OPEN OUTPUT FCSBE00-FILE.                                    
           IF NOT FBE00-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE00 OPEN.  STATUS IS '         
                       WS-FBE00-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSBE01-FILE.                                    
           IF NOT FBE01-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE01 OPEN.  STATUS IS '         
                       WS-FBE01-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
S108       OPEN OUTPUT FCSWK02-FILE.                                    
           IF NOT FWK02-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK02 OPEN.  STATUS IS '         
                       WS-FWK02-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSWK03-FILE.                                    
           IF NOT FWK03-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK03 OPEN.  STATUS IS '         
                       WS-FWK03-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
DC         OPEN OUTPUT FCSWK04-FILE.                                    
DC         IF NOT FWK04-SUCCESSFUL                                      
DC            DISPLAY '0100-ERROR ON FCSWK04 OPEN.  STATUS IS '         
DC                     WS-FWK04-STATUS                                  
DC            PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSWK05-FILE.                                    
           IF NOT FWK05-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK05 OPEN.  STATUS IS '         
                       WS-FWK05-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSBE21-FILE                                     
           IF NOT FBE21-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE21 OPEN.  STATUS IS '         
                       WS-FBE21-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
      *                                                                         
S114       OPEN OUTPUT FCSWK06-FILE.                                    
           IF NOT FWK06-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK06 OPEN.  STATUS IS '         
                       WS-FWK06-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0120-OPEN-RESTART.                                               
      ***                                                                       
      *** THIS PROCESS REMOVES ANY DATA WRITTEN BETWEEN THE LAST                
      *** CHECKPOINT AND THE ABEND.                                             
      *** NOTE THAT FILES THAT ARE WRITTEN ONLY AT A CHECKPOINT                 
      *** (WK00, WK02, WK04, AND WK06) DO NOT NEED TO BE RECYCLED.              
      ***                                                                       
      *** OPEN ALL INPUT FILES (FROM LAST RUN) FOR RECYCLING.                   
           OPEN INPUT FCSBE00R-FILE.                                    
           IF NOT FBE00R-SUCCESSFUL                                     
              DISPLAY '0100-ERROR ON FCSBE00R OPEN.  STATUS IS '        
                       WS-FBE00R-STATUS                                 
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN INPUT FCSBE01R-FILE.                                    
           IF NOT FBE01R-SUCCESSFUL                                     
              DISPLAY '0100-ERROR ON FCSBE01R OPEN.  STATUS IS '        
                       WS-FBE01R-STATUS                                 
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN INPUT FCSWK03R-FILE.                                    
           IF NOT FWK03R-SUCCESSFUL                                     
              DISPLAY '0100-ERROR ON FCSWK03R OPEN.  STATUS IS '        
                       WS-FWK03R-STATUS                                 
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN INPUT FCSWK05R-FILE.                                    
           IF NOT FWK05R-SUCCESSFUL                                     
              DISPLAY '0100-ERROR ON FCSWK05R OPEN.  STATUS IS '        
                       WS-FWK05R-STATUS                                 
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN INPUT FCSBE21R-FILE                                     
           IF NOT FBE21R-SUCCESSFUL                                     
              DISPLAY '0100-ERROR ON FCSBE21R OPEN.  STATUS IS '        
                       WS-FBE21R-STATUS                                 
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
      *                                                                         
      *** OPEN RESTART FILES FOR OUTPUT                                         
           OPEN OUTPUT FCSBE00-FILE.                                    
           IF NOT FBE00-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE00 OPEN.  STATUS IS '         
                       WS-FBE00-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSBE01-FILE.                                    
           IF NOT FBE01-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE01 OPEN.  STATUS IS '         
                       WS-FBE01-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSWK03-FILE.                                    
           IF NOT FWK03-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK03 OPEN.  STATUS IS '         
                       WS-FWK03-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSWK05-FILE.                                    
           IF NOT FWK05-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK05 OPEN.  STATUS IS '         
                       WS-FWK05-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN OUTPUT FCSBE21-FILE                                     
           IF NOT FBE21-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE21 OPEN.  STATUS IS '         
                       WS-FBE21-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
      *                                                                         
      **** COPY INPUT TO OUTPUT                                                 
           PERFORM WS-RESTART-FCSBE00-REC-CNTR TIMES                    
              READ FCSBE00R-FILE                                        
              IF FBE00R-SUCCESSFUL                                      
                 WRITE FIOBE00 FROM FIOBE00R                            
                 IF FBE00-SUCCESSFUL                                    
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY 'ERROR ON FCSBE00 REWRITE.  STATUS IS '     
                             WS-FBE00-STATUS                            
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'PREMATURE EOF ON BE00 RESTART'                
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
           PERFORM WS-RESTART-FCSBE01-REC-CNTR TIMES                    
              READ FCSBE01R-FILE                                        
              IF FBE01R-SUCCESSFUL                                      
                 WRITE FIOBE01 FROM FIOBE01R                            
                 IF FBE01-SUCCESSFUL                                    
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY 'ERROR ON FCSBE01 REWRITE.  STATUS IS '     
                             WS-FBE01-STATUS                            
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'PREMATURE EOF ON BE01 RESTART'                
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
           PERFORM WS-RESTART-FCSWK03-REC-CNTR TIMES                    
              READ FCSWK03R-FILE                                        
              IF FWK03R-SUCCESSFUL                                      
                 WRITE FIOWK03 FROM FIOWK03R                            
                 IF FWK03-SUCCESSFUL                                    
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY 'ERROR ON FCSWK03 REWRITE.  STATUS IS '     
                             WS-FWK03-STATUS                            
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'PREMATURE EOF ON WK03 RESTART'                
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
           PERFORM WS-RESTART-FCSWK05-REC-CNTR TIMES                    
              READ FCSWK05R-FILE                                        
              IF FWK05R-SUCCESSFUL                                      
                 WRITE FIOWK05 FROM FIOWK05R                            
                 IF FWK05-SUCCESSFUL                                    
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY 'ERROR ON FCSWK05 REWRITE.  STATUS IS '     
                             WS-FWK05-STATUS                            
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'PREMATURE EOF ON WK05 RESTART'                
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
T11939*    PERFORM WS-RESTART-FCSBE11-REC-CNTR TIMES                            
      *       READ FCSBE11R-FILE                                                
      *       IF FBE11R-SUCCESSFUL                                              
      *          WRITE FIOBE11 FROM FIOBE11R                                    
      *          IF FBE11-SUCCESSFUL                                            
      *             CONTINUE                                                    
      *          ELSE                                                           
      *             DISPLAY 'ERROR ON FCSBE11 REWRITE.  STATUS IS '             
      *                      WS-FBE11-STATUS                                    
      *             PERFORM 9900-ABEND THRU 9900-EXIT                           
      *          END-IF                                                         
      *       ELSE                                                              
      *          DISPLAY 'PREMATURE EOF ON BE11 RESTART'                        
      *          DISPLAY 'PROCESSING TERMINATED'                                
      *          PERFORM 9900-ABEND THRU 9900-EXIT                              
      *       END-IF                                                            
      *    END-PERFORM                                                          
      *                                                                         
           PERFORM WS-RESTART-FCSBE21-REC-CNTR TIMES                    
              READ FCSBE21R-FILE                                        
              IF FBE21R-SUCCESSFUL                                      
                 WRITE FIOBE21 FROM FIOBE21R                            
                 IF FBE21-SUCCESSFUL                                    
                    CONTINUE                                            
                 ELSE                                                   
                    DISPLAY 'ERROR ON FCSBE21 REWRITE.  STATUS IS '     
                             WS-FBE21-STATUS                            
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              ELSE                                                      
                 DISPLAY 'PREMATURE EOF ON BE21 RESTART'                
                 DISPLAY 'PROCESSING TERMINATED'                        
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-PERFORM                                                  
      *                                                                         
      **** CLOSE ALL FILES                                                      
           CLOSE FCSBE00-FILE                                           
                 FCSBE01-FILE                                           
                 FCSWK03-FILE                                           
                 FCSWK05-FILE                                           
                 FCSBE21-FILE                                           
                 FCSBE00R-FILE                                          
                 FCSBE01R-FILE                                          
                 FCSWK03R-FILE                                          
                 FCSWK05R-FILE                                          
                 FCSBE21R-FILE                                          
      **** REOPEN FILES IN EXTEND MODE                                          
           OPEN EXTEND FCSBE00-FILE.                                    
           IF NOT FBE00-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE00 OPEN.  STATUS IS '         
                       WS-FBE00-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN EXTEND FCSBE01-FILE.                                    
           IF NOT FBE01-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE01 OPEN.  STATUS IS '         
                       WS-FBE01-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
S108       OPEN EXTEND FCSWK02-FILE.                                    
           IF NOT FWK02-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK02 OPEN.  STATUS IS '         
                       WS-FWK02-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN EXTEND FCSWK03-FILE.                                    
           IF NOT FWK03-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK03 OPEN.  STATUS IS '         
                       WS-FWK03-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
DC         OPEN EXTEND FCSWK04-FILE.                                    
DC         IF NOT FWK04-SUCCESSFUL                                      
DC            DISPLAY '0100-ERROR ON FCSWK04 OPEN.  STATUS IS '         
DC                     WS-FWK04-STATUS                                  
DC            PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN EXTEND FCSWK05-FILE.                                    
           IF NOT FWK05-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK05 OPEN.  STATUS IS '         
                       WS-FWK05-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
           OPEN EXTEND FCSBE21-FILE                                     
           IF NOT FBE21-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSBE21 OPEN.  STATUS IS '         
                       WS-FBE21-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF                                                       
      *                                                                         
S114       OPEN EXTEND FCSWK06-FILE.                                    
           IF NOT FWK06-SUCCESSFUL                                      
              DISPLAY '0100-ERROR ON FCSWK06 OPEN.  STATUS IS '         
                       WS-FWK06-STATUS                                  
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
      *                                                                         
       0120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /************************************************************             
      *                                                           *             
      *      0130-LOAD-WORK-DAYS                                                
      *                                                           *             
      * LOAD PREVIOUS 6 MONTHS AND NEXT 12 MONTHS WORK DAYS INTO  *             
      * TABLE. THIS IS USED IN NOTICE FORECASTING. ENTRY 101 IS   *             
      * ALWAYS THE CURRENT DATE; 1-100 ARE PAST;  102-300 ARE     *             
      * FUTURE                                                    *             
      *                                                           *             
      *************************************************************             
       0130-LOAD-WORK-DAYS.                                             
           MOVE '01' TO J8-COMPANY-NO                                   
           MOVE LS-INPUT-DATE TO WS-CURRENT-DATE                        
                                 WS-WORK-DAY (101)                      
           MOVE 1 TO WS-ADJ-DAY                                         
           SET WD-INDX TO 100                                           
           PERFORM UNTIL WD-INDX < 1                                    
                      OR WS-ADJ-DAY > 180                               
              PERFORM 7031-GET-PREV-WORK-DAY THRU 7031-EXIT             
              EVALUATE SQLCODE                                          
                 WHEN SUCCESSFUL-CALL                                   
                    MOVE WS-WORK-DATE TO WS-WORK-DAY (WD-INDX)          
                    ADD 1 TO WS-ADJ-DAY                                 
                    SET WD-INDX DOWN BY 1                               
                 WHEN NOT-FOUND                                         
                    ADD 1 TO WS-ADJ-DAY                                 
                 WHEN OTHER                                             
                    DISPLAY 'WORK-DATE ERROR'                           
                    SET WD-INDX TO 1                                    
                    SET WD-INDX DOWN BY 1                               
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
           SET WD-INDX TO 102                                           
           MOVE 1 TO WS-ADJ-DAY                                         
T30752     PERFORM UNTIL WD-INDX > 500                                  
T30752                OR WS-ADJ-DAY > 730                               
              PERFORM 7030-GET-NEXT-WORK-DAY THRU 7030-EXIT             
              EVALUATE SQLCODE                                          
                 WHEN SUCCESSFUL-CALL                                   
                    MOVE WS-WORK-DATE TO WS-WORK-DAY (WD-INDX)          
                    ADD 1 TO WS-ADJ-DAY                                 
                    SET WD-INDX UP BY 1                                 
                 WHEN NOT-FOUND                                         
                    ADD 1 TO WS-ADJ-DAY                                 
                 WHEN OTHER                                             
                    DISPLAY 'WORK-DATE ERROR'                           
                    SET WD-INDX TO 200                                  
                    SET WD-INDX UP BY 1                                 
              END-EVALUATE                                              
           END-PERFORM.                                                 
                                                                        
           MOVE WS-WORK-DAY (116) TO LS-DATE-15-DAYS-FROM-NOW.          
           MOVE WS-WORK-DAY (121) TO LS-DATE-20-DAYS-FROM-NOW.          
           MOVE WS-WORK-DAY (126) TO LS-DATE-25-DAYS-FROM-NOW.          
           MOVE WS-WORK-DAY (131) TO LS-DATE-30-DAYS-FROM-NOW.          
           MOVE WS-WORK-DAY (141) TO LS-DATE-40-DAYS-FROM-NOW.          
           MOVE WS-WORK-DAY (146) TO LS-DATE-45-DAYS-FROM-NOW.          
           MOVE WS-WORK-DAY (161) TO LS-DATE-60-DAYS-FROM-NOW.          
           MOVE WS-WORK-DAY (171) TO LS-DATE-60-DAYS-FROM-NOW.          
                                                                        
      *                                                                         
       0130-EXIT.                                                       
           EXIT.                                                        
      /*****************************************************************        
      *                                                                *        
      *       0200-GET-BILLING PARAMETERS.                             *        
      *                                                                *        
      ******************************************************************        
       0200-GET-BILLING-PARAMETERS.                                     
                                                                        
           MOVE SPACES TO WS-SYSIPT.                                    
T16223     MOVE 'COMMON'    TO WS-PROGRAM.                              
T16223     MOVE WS-DATE     TO WS-COMMAND.                              
T16223     MOVE ZEROS       TO WS-SEQUENCE.                             
T16223     MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
                                                                        
T16223     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
T16223     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
T16223         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
T16223            OR  END-OF-SYSIPT.                                    
                                                                        
T16223     EVALUATE TRUE                                                
T16223        WHEN END-OF-SYSIPT                                        
T16223           DISPLAY ' '                                            
T16223           DISPLAY '**  PCSCA100 PROCESSING ERROR  **'            
T16223           DISPLAY '**    NO ACTIVE REVENUE MONTH IN COMMON'      
T16223           DISPLAY '**  PROCESSING TERMINATED **'                 
T16223           PERFORM 9900-ABEND  THRU  9900-EXIT                    
T16223        WHEN WS-REVENUE-MONTH-PARM NOT NUMERIC                    
T16223           DISPLAY ' '                                            
T16223           DISPLAY '**  PCSCA100 PROCESSING ERROR  **'            
T16223           DISPLAY '**    REVENUE MONTH PARM NOT NUMERIC'         
T16223           DISPLAY '**    KEY = ' E-FJC01-KEY                     
T16223           DISPLAY '**  PROCESSING TERMINATED  **'                
T16223           PERFORM 9900-ABEND  THRU  9900-EXIT                    
T16223        WHEN OTHER                                                
T16223           PERFORM 7611-CLOSE THRU 7611-EXIT                      
T16223           MOVE WS-REVENUE-MONTH-PARM TO WS-REVENUE-JOB-PARM      
T27054           IF PARMLENGTH > 0 AND                                  
T27054              PARM-REVENUE-MONTH > 0                              
T27054              MOVE PARM-REVENUE-MONTH TO WS-REVENUE-JOB-PARM      
T27054           END-IF                                                 
T16223     END-EVALUATE.                                                
P00166*                                                                         
P00166***  GET SCSCA165 UNIQUE ID PROCESS JOB PARM.  THIS WILL TELL US          
P00166***  IF FUNCTIONALITY TO CREATE UNIQUE ID BARCODES IS CURRENTLY           
P00166***  TURNED ON.  UNIQUE ID BARCODES ARE CREATED IN PCSCA107               
P00166***  BILLING EXTRACT PROCESS BY CALLING SCSCA165.  STATUS IS              
P00166***  TRACKED THROUGHOUT BILLING PROCESS.                                  
P00166*                                                                         
P00166     MOVE SPACES      TO WS-SYSIPT.                               
P00166     MOVE 'SCSCA165'  TO WS-PROGRAM.                              
P00166     MOVE WS-PARM     TO WS-COMMAND.                              
P00166     MOVE ZEROS       TO WS-SEQUENCE.                             
P00166     MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
P00166                                                                  
P00166     PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
P00166                                                                  
P00166     PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
P00166         UNTIL (WS-INPUT-DATA-BREAKDOWN(1:7) = 'process'          
P00166            AND INPUT-ACTIVE)                                     
P00166            OR  END-OF-SYSIPT.                                    
P00166                                                                  
P00166     EVALUATE TRUE                                                
P00166        WHEN END-OF-SYSIPT                                        
P00166           DISPLAY ' '                                            
P00166           DISPLAY '**  PCSCA100 PROCESSING ERROR             **' 
P00166           DISPLAY '**  UNIQUE ID PROCESS FLAG PARM NOT FOUND **' 
P00166           DISPLAY '**  KEY = ' E-FJC01-KEY                       
P00166           DISPLAY '**  PROCESSING TERMINATED                 **' 
P00166           DISPLAY ' '                                            
P00166           PERFORM 9900-ABEND  THRU  9900-EXIT                    
P00166        WHEN WS-INPUT-DATA-BREAKDOWN (9:3) = 'YES' OR 'Y'         
P00166           SET WS-OUTPUT-MANAGEMENT-ON TO TRUE                    
P00166           DISPLAY ' '                                            
P00166           DISPLAY '**  PCSCA100 PROCESSING NOTE              **' 
P00166           DISPLAY '**  UNIQUE ID PROCESS FLAG SET TO YES     **' 
P00166           DISPLAY '**  ' WS-INPUT-DATA-BREAKDOWN                 
P00166           DISPLAY '**  KEY = ' E-FJC01-KEY                       
P00166           DISPLAY '**  PROCESSING CONTINUING                 **' 
P00166           PERFORM 7611-CLOSE THRU 7611-EXIT                      
P00166        WHEN WS-INPUT-DATA-BREAKDOWN (9:3) = 'NO' OR 'N'          
P00166           SET WS-OUTPUT-MANAGEMENT-OFF TO TRUE                   
P00166           PERFORM 7611-CLOSE THRU 7611-EXIT                      
P00166           DISPLAY ' '                                            
P00166           DISPLAY '**  PCSCA100 PROCESSING NOTE              **' 
P00166           DISPLAY '**  UNIQUE ID PROCESS FLAG SET TO NO      **' 
P00166           DISPLAY '**  ' WS-INPUT-DATA-BREAKDOWN                 
P00166           DISPLAY '**  KEY = ' E-FJC01-KEY                       
P00166           DISPLAY '**  PROCESSING CONTINUING                 **' 
P00166           DISPLAY ' '                                            
P00166        WHEN OTHER                                                
P00166           DISPLAY ' '                                            
P00166           DISPLAY '**  PCSCA100 PROCESSING ERROR             **' 
P00166           DISPLAY '**  UNIQUE ID PROCESS FLAG NOT VALID      **' 
P00166           DISPLAY '**  ' WS-INPUT-DATA-BREAKDOWN                 
P00166           DISPLAY '**  ' WS-INPUT-DATA-BREAKDOWN (9:3)           
P00166           DISPLAY '**  KEY = ' E-FJC01-KEY                       
P00166           DISPLAY '**  PROCESSING TERMINATED                 **' 
P00166           DISPLAY ' '                                            
P00166           PERFORM 9900-ABEND  THRU  9900-EXIT                    
P00166     END-EVALUATE.                                                
P00166*                                                                         
P00166***  CHECK JCL JOB PARM IF ANY.  THIS WILL OVERRIDE SCSCA165              
P00166***  JOB PARM IF FOUND. THERE SHOULD BE NO JCL JOB PARM IN PROD.          
P00166     IF PARMLENGTH > 0 AND PARM-OUTPUT-MANAGEMENT-FL > SPACES     
P00166        MOVE PARM-OUTPUT-MANAGEMENT-FL TO WS-OUTPUT-MANAGEMENT-FL 
P00166        DISPLAY ' '                                               
P00166        DISPLAY '**  PCSCA100 PROCESSING NOTE              **'    
P00166        DISPLAY '**  UNIQUE ID PROCESS FLAG OVERRIDEN      **'    
P00166        DISPLAY '**  PROCESS=' WS-OUTPUT-MANAGEMENT-FL            
P00166        DISPLAY '**  PROCESSING CONTINUING                 **'    
P00166     END-IF.                                                      
P00166*                                                                         
           MOVE SPACES TO WS-SYSIPT.                                    
           MOVE WS-PGRMNAME TO WS-PROGRAM.                              
           MOVE WS-PARM     TO WS-COMMAND.                              
           MOVE ZEROS       TO WS-SEQUENCE.                             
           MOVE WS-KEY-AREA TO E-FJC01-KEY.                             
                                                                        
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
               UNTIL (BILL-CYCLE-WINDOW AND INPUT-ACTIVE)               
                  OR  END-OF-SYSIPT.                                    
                                                                        
           EVALUATE TRUE                                                
              WHEN END-OF-SYSIPT                                        
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSCA100 PROCESSING ERROR  **'            
                 DISPLAY '**    BILLING WINDOW PARM NOT PRESENT'        
                 DISPLAY '**    KEY = ' E-FJC01-KEY                     
                 DISPLAY '**  PROCESSING CONTINUED  **'                 
                 MOVE WS-N TO WS-PROCESS-BILLING                        
KGDB             MOVE SPACES TO WS-SYSIPT                               
              WHEN WS-INPUT-BILL-WINDOW-PARM NOT NUMERIC                
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSCA100 PROCESSING ERROR  **'            
                 DISPLAY '**    BILLING WINDOW PARM NOT NUMERIC'        
                 DISPLAY '**    KEY = ' E-FJC01-KEY                     
                 DISPLAY '**  PROCESSING TERMINATED  **'                
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
T27054        WHEN WS-INPUT-BILL-WINDOW-PARM GREATER THAN 8             
                 DISPLAY ' '                                            
                 DISPLAY '**  PCSCA100 PROCESSING ERROR  **'            
                 DISPLAY '**    BILLING WINDOW PARM GREATER THAN 8'     
                 DISPLAY '**    KEY = ' E-FJC01-KEY                     
                 DISPLAY '**  PROCESSING TERMINATED  **'                
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
              WHEN OTHER                                                
                 PERFORM 7611-CLOSE THRU 7611-EXIT                      
                 MOVE WS-INPUT-BILL-WINDOW-PARM TO WS-INPUT-BILL-WINDOW 
                 PERFORM 6241-GET-FCA00-BILL-CYCLES THRU 6241-EXIT      
                 MOVE WS-FCA00-PROCESS-BILLING TO WS-PROCESS-BILLING    
           END-EVALUATE.                                                
                                                                        
C26130     MOVE 'NO'                           TO LS-EPP-OFFER.         
C26130*    MOVE SPACES TO WS-SYSIPT.                                            
C26130*    PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                         
C26130*                                                                         
C26130*    PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                          
C26130*        UNTIL (WS-INPUT-DATA-BREAKDOWN (1:9) = 'EPP OFFER'               
C26130*                 AND INPUT-ACTIVE)                                       
C26130*           OR  END-OF-SYSIPT.                                            
C26130*                                                                         
C26130*    EVALUATE TRUE                                                        
C26130*       WHEN END-OF-SYSIPT                                                
C26130*          MOVE 'NO' TO LS-EPP-OFFER                                      
C26130*       WHEN WS-INPUT-DATA-BREAKDOWN (11:3)                               
C26130*                                 = 'YES' OR 'Y'                          
C26130*          MOVE 'YES' TO LS-EPP-OFFER                                     
C26130*          PERFORM 7611-CLOSE THRU 7611-EXIT                              
C26130*       WHEN WS-INPUT-DATA-BREAKDOWN (11:3)                               
C26130*                                 = 'NO' OR 'N'                           
C26130*          MOVE 'NO' TO LS-EPP-OFFER                                      
C26130*          PERFORM 7611-CLOSE THRU 7611-EXIT                              
C26130*       WHEN OTHER                                                        
C26130*          MOVE 'NO' TO LS-EPP-OFFER                                      
C26130*          PERFORM 7611-CLOSE THRU 7611-EXIT                              
C26130*    END-EVALUATE.                                                        
                                                                        
KGDB       MOVE SPACES TO WS-SYSIPT.                                    
KGDB       PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
                                                                        
KGDB       PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
KGDB           UNTIL (WS-INPUT-DATA-BREAKDOWN (1:10) = 'DB UPDATES'     
KGDB                    AND INPUT-ACTIVE)                               
KGDB              OR  END-OF-SYSIPT.                                    
KGDB                                                                    
KGDB       EVALUATE TRUE                                                
KGDB          WHEN END-OF-SYSIPT                                        
KGDB             MOVE 'YES' TO LS-DATABASE-UPDATES                      
KGDB             DISPLAY ' '                                            
KGDB             DISPLAY '**  PCSCA100 PROCESSING ERROR  **'            
KGDB             DISPLAY '**    DATABASE UPDATES PARM NOT PRESENT'      
KGDB             DISPLAY '**    KEY = ' E-FJC01-KEY                     
KGDB             DISPLAY '**  PROCESSING CONTINUING WITH UPDATES **'    
KGDB          WHEN WS-INPUT-DATA-BREAKDOWN (12:3)                       
KGDB                                    = 'YES' OR 'Y'                  
KGDB             MOVE 'YES' TO LS-DATABASE-UPDATES                      
KGDB             PERFORM 7611-CLOSE THRU 7611-EXIT                      
KGDB          WHEN WS-INPUT-DATA-BREAKDOWN (12:2)                       
KGDB                                    = 'NO' OR 'N'                   
KGDB             MOVE 'NO' TO LS-DATABASE-UPDATES                       
KGDB             DISPLAY ' '                                            
KGDB             DISPLAY '**  PCSCA100 PROCESSING NOTE  **'             
KGDB             DISPLAY '**    DATABASE UPDATES PARM SET TO NO **'     
KGDB             DISPLAY '**    KEY = ' E-FJC01-KEY                     
KGDB             DISPLAY '**  PROCESSING CONTINUING WITH NO UPDATES **' 
KGDB             PERFORM 7611-CLOSE THRU 7611-EXIT                      
KGDB          WHEN OTHER                                                
KGDB             MOVE 'YES' TO LS-DATABASE-UPDATES                      
KGDB             PERFORM 7611-CLOSE THRU 7611-EXIT                      
KGDB       END-EVALUATE.                                                
      *                                                                         
T32989     EVALUATE PARM-DATABASE-UPDATES                               
T32989        WHEN 'Y'                                                  
T32989           MOVE 'YES' TO LS-DATABASE-UPDATES                      
T32989        WHEN 'N'                                                  
T32989           MOVE 'NO'  TO LS-DATABASE-UPDATES                      
T32989     END-EVALUATE.                                                
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT.                                                               
      /                                                                         
TP6075*****************************************************************         
TP6075*    0250-LOAD-WEATHER-TREND-INFO                              **         
TP6075*                                                              **         
TP6075*    RETRIEVE CSS_WEATHER_TREND INFO AND LOAD INTO CA00        **         
TP6075*                                                              **         
TP6075*****************************************************************         
TP6075 0250-LOAD-WEATHER-TREND-INFO.                                    
TP6075     MOVE LS-INPUT-DATE TO WT-DATE-BILL.                          
C23301     MOVE E-FDB07-COMPANY-NO TO WT-COMPANY-NO.                    
TP6075     PERFORM 7300-OPEN-WEATHER-TREND  THRU 7300-EXIT.             
TP6075     PERFORM 7310-FETCH-WEATHER-TREND THRU 7310-EXIT.             
TP6075     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP6075        MOVE 1 TO WS-WFT-CNTRL                                    
TP6075        PERFORM 0275-LOAD-SCSCA103-WTHR-INFO THRU 0275-EXIT       
TP6075          UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
TP6075             OR WS-WFT-CNTRL > 100                                
TP6075        IF WS-WFT-CNTRL GREATER THAN 100                          
TP6075           DISPLAY '**     PCSCA100 PROCESSING ERROR     **'      
TP6075           DISPLAY '**  WEATHER FACTORS TABLE TOO SMALL  **'      
TP6075           DISPLAY '**   INCREASE TABLE AND RERUN JOB    **'      
TP6075           DISPLAY '**       PROCESSING TERMINATED       **'      
TP6075           PERFORM 9900-ABEND THRU 9900-EXIT                      
TP6075        END-IF                                                    
TP6075     END-IF.                                                      
TP6075     PERFORM 7320-CLOSE-WEATHER-TREND THRU 7320-EXIT.             
TP6075 0250-EXIT.                                                       
TP6075     EXIT.                                                        
TP6075*                                                                         
TP6075*****************************************************************         
TP6075*    0275-LOAD-SCSCA103-WTHR-INFO                              **         
TP6075*                                                              **         
TP6075*    LOADS THE RETRIEVED WEATHER TREND INFO INTO SCSCA103      **         
TP6075*    WS-WEATHER-FACTOR-TABLE                                   **         
TP6075*****************************************************************         
TP6075 0275-LOAD-SCSCA103-WTHR-INFO.                                    
TP6075     SET WS-WFT-INDEX TO WS-WFT-CNTRL.                            
TP6075     MOVE WT-CODE-REVENUE-CLASS                                   
TP6075       TO WS-REV-CLASS-WFT (WS-WFT-INDEX).                        
TP6075     MOVE WT-CODE-UTIL-TYPE                                       
             TO WS-CODE-UTIL-TYPE-WFT (WS-WFT-INDEX).                   
TP6075     MOVE WT-FACTOR       TO WS-FACTOR-WFT (WS-WFT-INDEX).        
TP6075     MOVE WT-UNITS-ACCUM  TO WS-ACCUM-USAGE-WFT (WS-WFT-INDEX).   
TP6075     PERFORM 7310-FETCH-WEATHER-TREND THRU 7310-EXIT.             
TP6075     ADD 1 TO WS-WFT-CNTRL.                                       
TP6075 0275-EXIT.                                                       
TP6075     EXIT.                                                        
TP6075*                                                                         
      /                                                                         
      /                                                                         
       0600-GET-RESTART-REQUEST.                                        
           MOVE WS-PGRMNAME    TO RF-NAME-PROGRAM.                      
           MOVE WS-PART-NO     TO RF-PARTITION-NO                       
                                  WS-CHKP-PART-NO.                      
           MOVE 1              TO RF-DUP-CNTRL-NO.                      
           PERFORM 7900-SELECT-RESTART THRU 7900-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE RF-RESTART-DATA-TEXT TO WS-RESTART-DATA              
              IF WS-RESTART-PROCESS-TYPE NUMERIC                        
                 SET WS-THIS-IS-A-RESTART TO TRUE                       
              END-IF                                                    
           END-IF.                                                      
       0600-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       0602-VALIDATE-REQUEST.                                           
           DISPLAY '*********************************************'.     
           DISPLAY '*****   THIS IS A RESTART OF JCSCA100   *****'.     
           DISPLAY '*********************************************'.     
           MOVE WS-RESTART-PROCESS-TYPE       TO WS-PROCESS-TYPE.       
           MOVE WS-RESTART-CHKP-SEQ-NO        TO WS-CHKP-SEQ-NO.        
           MOVE WS-RESTART-RPT-SAVE-ACCT-NO   TO WS-RPT-SAVE-ACCT-NO.   
           MOVE WS-RESTART-PRINT-SAVE-ACCT-NO TO WS-PRINT-SAVE-ACCT-NO. 
      *                                                                         
           IF WS-RESTART-COMMON-DATE NOT = WS-INPUT-DATE                
                 AND WS-RESTART-COMMON-DATE NOT EQUAL SPACES            
               DISPLAY '**********************************************' 
               DISPLAY '** COMMON DATE WAS CHANGED PRIOR TO RESTART **' 
               DISPLAY '**********************************************' 
               DISPLAY '** OLD COMMON DATE = ' WS-RESTART-COMMON-DATE   
               DISPLAY '** NEW COMMON DATE = ' WS-INPUT-DATE            
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       0602-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *    0700-LOAD-GL-NO-VALUES                                    **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
T24436***INCLUDE COMMENTED TO CALL SCSCB061                                     
T24436*COPY CPD00061.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *    0605-VALIDATE-RESTART-REQ                                 **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       COPY CPD00030.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
                                                                        
PCR473*    0800-GET-RUN-DATES                                        **         
PCR473*    GETS THE RUN DATE AND LAST RUN DATE FOR PCSCA116.         **         
                                                                        
PCR473 0800-GET-RUN-DATES.                                              
PCR473     MOVE WS-PCSCA116-NAME             TO WS-PGRMNAME.            
      *                                                                         
PCR473     PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT.            
      *                                                                         
PCR473     IF OVERRIDE-DATE-LOADED                                      
PCR473        MOVE WS-INPUT-DATA-BREAKDOWN   TO WS-INPUT-DATA-R116      
PCR473     ELSE                                                         
PCR473        DISPLAY '***********************************'             
PCR473        DISPLAY '**   PCSCA100 PROCESSING ERROR   **'             
PCR473        DISPLAY '**-------------------------------**'             
PCR473        DISPLAY '**   0800-CHECK-RUN-DATES:'                      
PCR473        DISPLAY '**   RUN DATE AND LAST RUN DATE'                 
PCR473        DISPLAY '**   WERE NOT FOUND'                             
PCR473        DISPLAY '***********************************'             
PCR473        PERFORM 9900-ABEND             THRU 9900-EXIT             
PCR473     END-IF.                                                      
PCR473 0800-EXIT.                                                       
PCR473     EXIT.                                                        
      *****************************************************************         
C23301*    0810-CHECK-FOR-BTU-TEMP                                   **         
PCR473*    CONTROLS THE LOGIC TO CHECK CSS_BTU_FACTOR AND            **         
PCR473*    CSS_TEMPERATURE FOR DATA FOR EVERY DAY SINCE THE LAST     **         
PCR473*    RUN DATE UP UNTIL YESTERDAY                               **         
      *****************************************************************         
C23301 0810-CHECK-FOR-BTU-TEMP.                                         
      *                                                                         
C23301     PERFORM 7340-OPEN-COMPANY-CURSOR THRU 7340-EXIT.             
C23301     PERFORM 7350-FETCH-COMPANY-CURSOR THRU 7350-EXIT.            
C23301     PERFORM 0820-CHECK-TABLES-FOR-DATA THRU 0820-EXIT            
C23301             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
C23301     PERFORM 7360-CLOSE-COMPANY-CURSOR THRU 7360-EXIT.            
C23301                                                                  
      *                                                                         
PCR473     EXEC SQL                                                     
PCR473        SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DAY
              ) <> 0) OR (LEN(:WS-CURRENT-DAY) <> 10), CIS.CHAR2DATE(
                                                        :WS-CURRENT-DAY
              ), CONVERT(DATE, :WS-CURRENT-DAY) ) )
            INTO
              :WS-CURRENT-DAY                       
PCR473     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DAY =                                             
MFA-TR*            DATE(:WS-CURRENT-DAY) + 1 DAYS                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
PCR473     IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
PCR473        DISPLAY '***********************************'             
PCR473        DISPLAY '**   PCSCA100 PROCESSING ERROR   **'             
PCR473        DISPLAY '**-------------------------------**'             
C23301        DISPLAY '**   0810-CHECK-FOR-BTU-TEMP:'                   
PCR473        DISPLAY '**   CANNOT ADVANCE WS-CURRENT-DAY'              
PCR473        DISPLAY '**   BY ONE CALENDAR DAY'                        
PCR473        DISPLAY '***********************************'             
PCR473        PERFORM 9900-ABEND          THRU 9900-EXIT                
PCR473     END-IF.                                                      
C23301 0810-EXIT.                                                       
C23301     EXIT.                                                        
      *                                                                         
      *****************************************************************         
PCR473*    0820-CHECK-TABLES-FOR-DATA                                **         
PCR473*    CONTROLS THE LOGIC TO CHECK CSS_BTU_FACTOR AND            **         
PCR473*    CSS_TEMPERATURE FOR DATA FOR EVERY DAY SINCE THE LAST     **         
PCR473*    RUN DATE UP UNTIL YESTERDAY                               **         
      *****************************************************************         
PCR473 0820-CHECK-TABLES-FOR-DATA.                                      
C23301     IF C7-BTU-FACTOR-REQ-FL  = 'Y'                               
PCR473        PERFORM 0830-CHECK-CSS-BTU-FACTOR                         
PCR473        IF DATE-IN-CSS-BTU-FACTOR                                 
PCR473           CONTINUE                                               
PCR473        ELSE                                                      
PCR473           DISPLAY '***********************************'          
PCR473           DISPLAY '**   PCSCA100 PROCESSING ERROR   **'          
PCR473           DISPLAY '**-------------------------------**'          
PCR473           DISPLAY '**   0820-CHECK-TABLES-FOR-DATA:'             
PCR473           DISPLAY '**   NO DATA IN CSS_BTU_FACTOR'               
PCR473           DISPLAY '**   FOR  ' WS-CURRENT-DAY                    
C23301           DISPLAY '**COMPANY ' C7-COMPANY-NO                     
PCR473           DISPLAY '***********************************'          
PCR473           PERFORM 9900-ABEND          THRU 9900-EXIT             
PCR473        END-IF                                                    
C23301     END-IF.                                                      
      *                                                                         
C23301     IF C7-TEMPERATURE-REQ-FL = 'Y'                               
PCR473        PERFORM 0840-CHECK-CSS-TEMPERATURE                        
PCR473        IF DATE-IN-CSS-TEMPERATURE                                
PCR473           CONTINUE                                               
PCR473        ELSE                                                      
PCR473           DISPLAY '***********************************'          
PCR473           DISPLAY '**   PCSCA100 PROCESSING ERROR   **'          
PCR473           DISPLAY '**-------------------------------**'          
PCR473           DISPLAY '**   0820-CHECK-TABLES-FOR-DATA:'             
PCR473           DISPLAY '**   NO DATA IN CSS_TEMPERATURE'              
PCR473           DISPLAY '**    FOR ' WS-CURRENT-DAY                    
C23301           DISPLAY '**COMPANY ' C7-COMPANY-NO                     
PCR473           DISPLAY '***********************************'          
PCR473           PERFORM 9900-ABEND          THRU 9900-EXIT             
PCR473        END-IF                                                    
C23301     END-IF.                                                      
      *                                                                         
C23301     PERFORM 7350-FETCH-COMPANY-CURSOR THRU 7350-EXIT.            
      *                                                                         
PCR473 0820-EXIT.                                                       
PCR473     EXIT.                                                        
      *****************************************************************         
PCR473*    0830-CHECK-CSS-BTU-FACTOR                                 **         
PCR473*    CHECKS THE CSS_BTU_FACTOR TABLE FOR DATA ON A GIVEN DAY   **         
      *****************************************************************         
PCR473 0830-CHECK-CSS-BTU-FACTOR.                                       
PCR473     MOVE WS-NO                     TO WS-CSS-BTU-FACTOR-EXISTS.  
      *                                                                         
PCR473     EXEC SQL                                                     
PCR473        SELECT  DISTINCT('Y')                                     
PCR473          INTO  :WS-CSS-BTU-FACTOR-EXISTS                         
PCR473          FROM  CSS_BTU_FACTOR WITH(READUNCOMMITTED)                      
PCR473         WHERE  BTU_DT = IIF(TRY_CONVERT(DATE, :WS-CURRENT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DAY
              ) <> 0) OR (LEN(:WS-CURRENT-DAY) <> 10), CIS.CHAR2DATE(
                                                        :WS-CURRENT-DAY
              ), CONVERT(DATE, :WS-CURRENT-DAY) )                          
C23301           AND  COMPANY_NO = :C7-COMPANY-NO                       
T33182                                                           
PCR473     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DISTINCT('Y')                                             
MFA-TR*         INTO  :WS-CSS-BTU-FACTOR-EXISTS                                 
MFA-TR*         FROM  CSS_BTU_FACTOR                                            
MFA-TR*        WHERE  BTU_DT = :WS-CURRENT-DAY                                  
MFA-TR*          AND  COMPANY_NO = :C7-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
PCR473     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
PCR473         CONTINUE                                                 
PCR473     ELSE                                                         
PCR473        DISPLAY '***********************************'             
PCR473        DISPLAY '**   PCSCA100 PROCESSING ERROR   **'             
PCR473        DISPLAY '**-------------------------------**'             
PCR473        DISPLAY '**   0830-CHECK-CSS-BTU-FACTOR:'                 
PCR473        DISPLAY '**   ERROR CHECKING FOR DATA'                    
PCR473        DISPLAY '**   IN CSS_BTU_FACTOR TABLE'                    
C23301        DISPLAY '**   BTU_DT     = ' WS-CURRENT-DAY               
C23301        DISPLAY '**   COMPANY_NO = ' C7-COMPANY-NO                
PCR473        DISPLAY '***********************************'             
PCR473        PERFORM 9900-ABEND          THRU 9900-EXIT                
PCR473     END-IF.                                                      
      *                                                                         
PCR473 0830-EXIT.                                                       
PCR473     EXIT.                                                        
      *****************************************************************         
PCR473*    0840-CHECK-CSS-TEMPERATURE                                **         
PCR473*    CHECKS THE CSS_TEMPERATURE TABLE FOR DATA ON A GIVEN DAY  **         
      *****************************************************************         
PCR473 0840-CHECK-CSS-TEMPERATURE.                                      
PCR473     MOVE WS-NO                     TO WS-CSS-TEMPERATURE-EXISTS. 
      *                                                                         
PCR473     EXEC SQL                                                     
PCR473        SELECT  DISTINCT('Y')                                     
PCR473          INTO  :WS-CSS-TEMPERATURE-EXISTS                        
PCR473          FROM  CSS_TEMPERATURE WITH(READUNCOMMITTED)                     
PCR473         WHERE  TEMP_DT = IIF(TRY_CONVERT(DATE, :WS-CURRENT-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DAY
              ) <> 0) OR (LEN(:WS-CURRENT-DAY) <> 10), CIS.CHAR2DATE(
                                                        :WS-CURRENT-DAY
              ), CONVERT(DATE, :WS-CURRENT-DAY) )                         
C23301           AND  COMPANY_NO = :C7-COMPANY-NO                       
T33182                                                           
PCR473     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DISTINCT('Y')                                             
MFA-TR*         INTO  :WS-CSS-TEMPERATURE-EXISTS                                
MFA-TR*         FROM  CSS_TEMPERATURE                                           
MFA-TR*        WHERE  TEMP_DT = :WS-CURRENT-DAY                                 
MFA-TR*          AND  COMPANY_NO = :C7-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
PCR473     IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
PCR473         CONTINUE                                                 
PCR473     ELSE                                                         
PCR473        DISPLAY '***********************************'             
PCR473        DISPLAY '**   PCSCA100 PROCESSING ERROR   **'             
PCR473        DISPLAY '**-------------------------------**'             
PCR473        DISPLAY '**   0840-CHECK-CSS-TEMPERATURE:'                
PCR473        DISPLAY '**   ERROR CHECKING FOR DATA'                    
PCR473        DISPLAY '**   IN CSS_TEMPERATURE TABLE'                   
C23301        DISPLAY '**   TEMP_DT    = ' WS-CURRENT-DAY               
C23301        DISPLAY '**   COMPANY_NO = ' C7-COMPANY-NO                
PCR473        DISPLAY '***********************************'             
PCR473        PERFORM 9900-ABEND          THRU 9900-EXIT                
PCR473     END-IF.                                                      
PCR473 0840-EXIT.                                                       
PCR473     EXIT.                                                        
      *****************************************************************         
      *                                                              **         
      *    1000-PROCESS-ALL-FCSDB07                                  **         
      *                                                              **         
      *    PERFORM INITIALIZATION TO OPEN FILES/INIT CWS10000 ETC    **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
                                                                        
       1000-PROCESS-ALL-FCSDB07.                                        
           EVALUATE TRUE                                                
T16887        WHEN WS-END-REC-PROCESSED EQUAL WS-Y                      
T16887           IF E-FDB07-KEY-EREC EQUAL HIGH-VALUES                  
T16887              SUBTRACT 1 FROM WS-FCSDB07-REC-CNTR                 
T16887              ADD E-FDB07-RECORD-COUNT-EREC TO                    
T16887                         WS-FCSDB07-REC-CNTR-TOT                  
T16887              MOVE WS-Y TO WS-END-REC-PROCESSED                   
T16887           ELSE                                                   
T16887              DISPLAY ' '                                         
T16887              DISPLAY '**   PCSCA100 PROCESSING ERROR        '    
T16887              DISPLAY '** SOME OTHER RECORDS FOLLOW THE TRAILER ' 
T16887                       FIODB07-DATA-REC                           
T16887              DISPLAY '**     PROCESSING TERMINATED          '    
T16887              PERFORM 9900-ABEND THRU 9900-EXIT                   
T16887           END-IF                                                 
T16887           PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT               
              WHEN E-FDB07-KEY-EREC EQUAL HIGH-VALUES                   
                 IF WS-FDB07-ACCT-NO > ZERO                             
                    PERFORM 2000-PROCESS-ACCOUNT THRU 2000-EXIT         
                    SUBTRACT 1 FROM WS-FCSDB07-REC-CNTR                 
                    ADD E-FDB07-RECORD-COUNT-EREC TO                    
                               WS-FCSDB07-REC-CNTR-TOT                  
                    MOVE WS-Y TO WS-END-REC-PROCESSED                   
C33462              IF AT-CODE-ACCT-BILLED = 'X'                        
C36000                 OR AT-CODE-ACCT-BILLED = 'H'                     
C33462                 PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT         
C33462                 GO TO 1000-EXIT                                  
C33462              END-IF                                              
                 ELSE                                                   
                    DISPLAY ' '                                         
                    DISPLAY '*****      W A R N I N G     *****'        
                    DISPLAY '** NO DATA RECORDS ON DB07 FILE **'        
                    DISPLAY '**     PROCESSING TERMINATED    **'        
                    SUBTRACT 1 FROM WS-FCSDB07-REC-CNTR                 
RSN                 MOVE ZERO TO WS-FDB07-ACCT-NO                       
T21753              MOVE 'N'  TO WS-SECURED-RATE-FL                     
RSN                 PERFORM 2200-GET-BILL-DATA     THRU 2200-EXIT       
                 END-IF                                                 
                                                                        
                 PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT               
              WHEN FIRST-INPUT-RECORD                                   
                 SET SUBSEQUENT-INPUT-RECORD TO TRUE                    
                 MOVE E-FDB07-ACCT-NO TO WS-FDB07-ACCT-NO               
                 PERFORM 1010-SET-CYCLE-CONTROL THRU 1010-EXIT          
                 MOVE E-FDB07-NO-BILL-CYCLES TO WS-FDB07-NO-BILL-CYCLES 
P00166           MOVE E-FDB07-BARCODE-UNIQUE-ID TO                      
P00166                WS-FDB07-BARCODE-UNIQUE-ID                        
                 PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT               
              WHEN E-FDB07-ACCT-NO = WS-FDB07-ACCT-NO                   
P00166           IF WS-PROCESS-UNIQUE-ID                                
P00166***           TRACK THE LAST UNIQUE ID FOR ACCT IF ANY WHEN               
P00166***           ACCT HAS MULTIPLE DB07 RECORDS.  ALL OTHER UNIQUE           
P00166***           UNIQUE IDS FOR THE ACCT WILL BE TRACKED AS BM. IF           
P00166***           ACCT HAS BEEN XCLUDED ALL UNIQUE IDS FOR THE ACCT           
P00166***           DURING EXTRACT WILL BE TRACKED AS BX.                       
P00166              IF AT-CODE-ACCT-BILLED = 'X'                        
P00166                 OR AT-CODE-ACCT-BILLED = 'H'                     
P00166                 SET WS-TRACK-BILL-XCLUDE TO TRUE                 
P00166              ELSE                                                
P00166                 SET WS-TRACK-BILL-MISC TO TRUE                   
P00166              END-IF                                              
P00166              PERFORM 3700-LOAD-CORR-MAIL-STAT THRU 3700-EXIT     
P00166              MOVE WS-FDB07-BARCODE-UNIQUE-ID TO                  
P00166                   WS-PREV-BARCODE-UNIQUE-ID                      
P00166              MOVE WS-FDB07-ACCT-NO TO WS-PREV-ACCT-NO            
P00166              MOVE E-FDB07-BARCODE-UNIQUE-ID TO                   
P00166                   WS-FDB07-BARCODE-UNIQUE-ID                     
P00166           ELSE                                                   
P00166              MOVE E-FDB07-BARCODE-UNIQUE-ID TO                   
P00166                   WS-FDB07-BARCODE-UNIQUE-ID                     
P00166           END-IF                                                 
                 PERFORM 1010-SET-CYCLE-CONTROL THRU 1010-EXIT          
                 PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT               
T24669        WHEN (E-FDB07-ACCT-NO > WS-FDB07-ACCT-NO                  
T24669           AND E-FDB07-COMPANY-NO EQUAL WS-PREV-COMPANY-NO)       
T24669         OR (E-FDB07-ACCT-NO < WS-FDB07-ACCT-NO                   
T24669           AND  E-FDB07-COMPANY-NO > WS-PREV-COMPANY-NO)          
T24669         OR (E-FDB07-ACCT-NO > WS-FDB07-ACCT-NO                   
T24669           AND  E-FDB07-COMPANY-NO > WS-PREV-COMPANY-NO)          
                 PERFORM 2000-PROCESS-ACCOUNT THRU 2000-EXIT            
                 IF WS-PRINT-COUNTERS EQUAL WS-C                        
                    PERFORM 8871-PRINT-COUNTERS THRU 8871-EXIT          
                 END-IF                                                 
                                                                        
C31702           IF WS-COMMITS-REQUIRE                                  
C34680              IF (WS-DB07-INDX = WS-CHKP-LUW-LIMIT) OR            
C34680                 (E-FDB07-COMPANY-NO NOT = WS-CHECK-COMPANY-NO)   
                       PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT           
                       INITIALIZE WS-HOLD-DB07-FOR-RESTART              
                       SET WS-DB07-INDX TO 1                            
                    END-IF                                              
C31702           END-IF                                                 
                 INITIALIZE WS-FIODB07                                  
                 MOVE E-FDB07-ACCT-NO TO WS-FDB07-ACCT-NO               
                 MOVE E-FDB07-NO-BILL-CYCLES TO WS-FDB07-NO-BILL-CYCLES 
P00166           MOVE E-FDB07-BARCODE-UNIQUE-ID TO                      
P00166                WS-FDB07-BARCODE-UNIQUE-ID                        
C36000                                                                  
C36000           PERFORM 7150-GET-ACCT-INFO THRU 7150-EXIT              
C36000                                                                  
C33462           IF AT-CODE-ACCT-BILLED = 'X'                           
C36000             OR AT-CODE-ACCT-BILLED = 'H'                         
P00166             PERFORM 1020-SET-PROCESS-UNIQUE-ID-FL THRU 1020-EXIT 
C33462             PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT             
C33462             GO TO 1000-EXIT                                      
C33462           END-IF                                                 
T31542           IF E-FDB07-COMPANY-NO NOT = WS-CHECK-COMPANY-NO        
T31542              MOVE E-FDB07-COMPANY-NO TO WS-CHECK-COMPANY-NO      
T31542              MOVE E-FDB07-COMPANY-NO TO C8-COMPANY-NO            
T31542                                         WT-COMPANY-NO            
T31542              MOVE LS-INPUT-DATE      TO WT-DATE-BILL             
T31542              PERFORM 0250-LOAD-WEATHER-TREND-INFO  THRU 0250-EXIT
T31542              PERFORM 6500-LOAD-EXCP-LIMITS THRU                  
T31542                      6500-LOAD-EXCP-LIMITS-EXIT                  
T31542              MOVE WS-DATABASE        TO  LS-DATABASE             
T31542              IF E-FDB07-DB-PART-BREC = 9                         
T31542                 MOVE WS-RR-WQ-BILLING9 TO WS-EXCEPTION-LIMIT     
T31542              ELSE                                                
T31542                 MOVE WS-RR-WQ-BILLING  TO WS-EXCEPTION-LIMIT     
T31542              END-IF                                              
T31542           END-IF                                                 
                                                                        
T24669           MOVE E-FDB07-COMPANY-NO TO  WS-PREV-COMPANY-NO         
                 PERFORM 1010-SET-CYCLE-CONTROL THRU 1010-EXIT          
                                                                        
                 PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT               
T16887*   MOVED THE FOLLOWING WHEN CODE TO BEGINNING OF EVALUATE STMT           
TP4409*       WHEN WS-END-REC-PROCESSED EQUAL WS-Y                              
TP4409*          IF E-FDB07-KEY-EREC EQUAL HIGH-VALUES                          
TP4409*             SUBTRACT 1 FROM WS-FCSDB07-REC-CNTR                         
TP4409*             ADD E-FDB07-RECORD-COUNT-EREC TO                            
TP4409*                        WS-FCSDB07-REC-CNTR-TOT                          
TP4409*             MOVE WS-Y TO WS-END-REC-PROCESSED                           
TP4409*          ELSE                                                           
TP4409*             DISPLAY ' '                                                 
TP4409*             DISPLAY '**   PCSCA100 PROCESSING ERROR        '            
TP4409*             DISPLAY '** SOME OTHER RECORDS FOLLOW THE TRAILER '         
TP4409*                      FIODB07-DATA-REC                                   
TP4409*             DISPLAY '**     PROCESSING TERMINATED          '            
TP4409*             PERFORM 9900-ABEND THRU 9900-EXIT                           
TP4409*          END-IF                                                         
TP4409*          PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT                       
              WHEN OTHER                                                
                 DISPLAY ' '                                            
                 DISPLAY '**   PCSCA100 PROCESSING ERROR             **'
                 DISPLAY '** SEQUENCE ERROR ON DB07 AFTER '             
                         WS-FDB07-ACCT-NO                               
                 DISPLAY '**     PROCESSING TERMINATED               **'
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
                                                                        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       1010-SET-CYCLE-CONTROL.                                          
T17357     SET WS-NOT-ON-CYCLE-TRANSFER TO TRUE                         
P00166     PERFORM 1020-SET-PROCESS-UNIQUE-ID-FL THRU 1020-EXIT         
           EVALUATE E-FDB07-OFF-CYCLE-BILL-CODE                         
              WHEN 'B'                                                  
                 SET WS-OFF-CYCLE-FINAL TO TRUE                         
TP2341           MOVE E-FDB07-CREDIT-LETTER-IND TO                      
TP2341                                    WS-FDB07-CREDIT-LETTER-IND    
              WHEN 'O'                                                  
                 SET WS-OFF-CYCLE-REBILL TO TRUE                        
              WHEN 'M'                                                  
                 IF E-FDB07-PART-NO = 9                                 
                    SET WS-CONS-BILL-MAST TO TRUE                       
                 ELSE                                                   
                    DISPLAY ' '                                         
                    DISPLAY '**   PCSCA100 PROCESSING ERROR    **'      
                    DISPLAY '** INVALID PARTITION FOR CB MAST  **'      
                    DISPLAY '** ACCOUNT NO = '                          
                            E-FDB07-ACCT-NO                             
                    DISPLAY '     **'                                   
                    DISPLAY '** OFF CYCLE CODE = '                      
                            E-FDB07-OFF-CYCLE-BILL-CODE                 
                    DISPLAY '             **'                           
                    DISPLAY '**     PROCESSING TERMINATED      **'      
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              WHEN 'A'                                                  
                 IF E-FDB07-PART-NO < 9                                 
                    SET WS-ADDITIVE-MAST TO TRUE                        
                 ELSE                                                   
                    DISPLAY ' '                                         
                    DISPLAY '**   PCSCA100 PROCESSING ERROR    **'      
                    DISPLAY '** INVALID PARTITION FOR ADD MAST **'      
                    DISPLAY '** ACCOUNT NO = '                          
                            E-FDB07-ACCT-NO                             
                    DISPLAY '     **'                                   
                    DISPLAY '** OFF CYCLE CODE = '                      
                            E-FDB07-OFF-CYCLE-BILL-CODE                 
                    DISPLAY '             **'                           
                    DISPLAY '**     PROCESSING TERMINATED      **'      
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              WHEN 'C'                                                  
                 SET WS-PROCESS-REFUND TO TRUE                          
              WHEN 'E'                                                  
                 IF E-FDB07-PART-NO NOT = 9                             
                    SET WS-TRANSFER-GUARANTEE TO TRUE                   
                 ELSE                                                   
                    DISPLAY ' '                                         
                    DISPLAY '**   PCSCA100 PROCESSING ERROR     **'     
                    DISPLAY '** INVALID PARTITION FOR GUARANTEE **'     
                    DISPLAY '** ACCOUNT NO = '                          
                            E-FDB07-ACCT-NO                             
                    DISPLAY '      **'                                  
                    DISPLAY '** OFF CYCLE CODE = '                      
                            E-FDB07-OFF-CYCLE-BILL-CODE                 
                    DISPLAY '              **'                          
                    DISPLAY '**     PROCESSING TERMINATED       **'     
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
              WHEN 'G'                                                  
                 IF E-FDB07-PART-NO = 9                                 
                    SET WS-TRANSFER-GUARANTOR TO TRUE                   
                 ELSE                                                   
                    DISPLAY ' '                                         
                    DISPLAY '**   PCSCA100 PROCESSING ERROR    **'      
                    DISPLAY '** INVALID PARTITION FOR MASTER   **'      
                    DISPLAY '** ACCOUNT NO = '                          
                            E-FDB07-ACCT-NO                             
                    DISPLAY '     **'                                   
                    DISPLAY '** OFF CYCLE CODE = '                      
                            E-FDB07-OFF-CYCLE-BILL-CODE                 
                    DISPLAY '             **'                           
                    DISPLAY '**     PROCESSING TERMINATED            **'
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
TF1           WHEN 'S'                                                  
TF1              SET WS-SINGLE-ITEM-BILL TO TRUE                        
TF1              MOVE E-FDB07-PYMT-PRIORITY-LVL                         
TF1                TO WS-FDB07-PYMT-PRIORITY-LVL                        
TF1              MOVE E-FDB07-ITEM-ID                                   
TF1                TO WS-FDB07-ITEM-ID                                  
TP4576        WHEN SPACE                                                
T15980*          IF NOT WS-OFF-CYCLE-FINAL                                      
T17052           IF (NOT WS-OFF-CYCLE-FINAL) AND                        
T17052              (NOT WS-OFF-CYCLE-REBILL)                           
TP4576              SET WS-ON-CYCLE-BILL  TO TRUE                       
T15980           END-IF                                                 
TP4576        WHEN 'R'                                                  
TP4576           SET WS-PROCESS-REFUND TO TRUE                          
TP4569        WHEN 'T'                                                  
TP4569           IF E-FDB07-PART-NO = 9                                 
T13829             IF NOT WS-ON-CYCLE-BILL                              
TP4569              SET WS-OFF-CYCLE-ACCT-TRANS TO TRUE                 
T17357             ELSE                                                 
T17357               IF WS-ON-CYCLE-BILL                                
T17357                SET WS-ON-CYCLE-TRANSFER TO TRUE                  
T17357               END-IF                                             
T13829             END-IF                                               
TP4569           ELSE                                                   
TP4569              DISPLAY ' '                                         
TP4569              DISPLAY '**   PCSCA100 PROCESSING ERROR    **'      
TP4569              DISPLAY '** INVALID PARTITION FOR MASTER   **'      
TP4569              DISPLAY '** FOR ACCOUNT TRANSFERS          **'      
TP4569              DISPLAY '** ACCOUNT NO = '                          
TP4569                      E-FDB07-ACCT-NO                             
TP4596              DISPLAY '     **'                                   
TP4569              DISPLAY '** OFF CYCLE CODE = '                      
TP4569                      E-FDB07-OFF-CYCLE-BILL-CODE                 
TP4569              DISPLAY '             **'                           
TP4569              DISPLAY '**     PROCESSING TERMINATED            **'
TP4569              PERFORM 9900-ABEND THRU 9900-EXIT                   
TP4569           END-IF                                                 
P00453        WHEN 'P'                                                  
P00453           SET WS-PRP-FIRST-EST TO TRUE                           
              WHEN OTHER                                                
                 DISPLAY ' '                                            
                 DISPLAY '**   PCSCA100 PROCESSING ERROR    **'         
                 DISPLAY '** UNKNOWN OFF CYCLE CODE ON DB07 **'         
                 DISPLAY '** ACCOUNT NO = '                             
                         E-FDB07-ACCT-NO                                
                 DISPLAY '     **'                                      
                 DISPLAY '** OFF CYCLE CODE = '                         
                         E-FDB07-OFF-CYCLE-BILL-CODE                    
                 DISPLAY '             **'                              
                 DISPLAY '**     PROCESSING TERMINATED            **'   
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
       1010-EXIT.                                                       
           EXIT.                                                        
P00166*                                                                         
P00166 1020-SET-PROCESS-UNIQUE-ID-FL.                                   
P00166*                                                                         
P00166***  ONLY SET PROCESS UNIQUE ID FLAG TO TRUE IF UNIQUE ID                 
P00166***  FUNCTIONALITY IS CURRENTLY TURNED ON AND OFF CYCLE BILL              
P00166***  CODE IS OF SPECIFIED VALUE                                           
P00166     MOVE E-FDB07-OFF-CYCLE-BILL-CODE TO WS-OFF-CYCLE-BILL-CODE.  
P00166     IF E-FDB07-ACCT-NO = WS-PREV-ACCT-NO AND                     
P00166        WS-PROCESS-UNIQUE-ID AND E-FDB07-BARCODE-UNIQUE-ID=SPACES 
P00166        MOVE WS-PREV-BARCODE-UNIQUE-ID TO                         
P00166             WS-FDB07-BARCODE-UNIQUE-ID                           
P00166     ELSE                                                         
P00166        IF WS-TRACK-BILL AND WS-OUTPUT-MANAGEMENT-ON              
P00166           SET WS-PROCESS-UNIQUE-ID TO TRUE                       
P00166        ELSE                                                      
P00166           SET WS-DO-NOT-PROCESS-UNIQUE-ID TO TRUE                
P00166        END-IF                                                    
P00166     END-IF.                                                      
P00166*                                                                         
P00166     MOVE WS-PROCESS-UNIQUE-ID-FL TO LS-PROCESS-UNIQUE-ID-FL.     
P00166*                                                                         
P00166 1020-EXIT.                                                       
P00166     EXIT.                                                        
P00166*                                                                         
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    2000-PROCESS-ACCOUNT                                      **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       2000-PROCESS-ACCOUNT.                                            
T21753*                                                                         
T21753     MOVE WS-FDB07-ACCT-NO            TO UT-ACCOUNT-NO            
T21753     PERFORM 2150-CHECK-SECURED-FLAG  THRU 2150-EXIT              
T21753     MOVE WS-SECURED-RATE             TO WS-SECURED-RATE-FL       
TP5339*    MOVE ZERO TO LS-CURR-WQ-ITEM.                                        
C33462                                                                  
C33462     PERFORM 7150-GET-ACCT-INFO    THRU 7150-EXIT.                
C33462                                                                  
C33462     EVALUATE TRUE                                                
A01005* PRIORITIZING OFF-CYC-CD WHEN DB07 HAS MULTIPLE ROWS FOR THE SAME        
A01005* ACCT WITH OFF-CYC-CD L&R OR O&R.                                        
A01005     WHEN  WS-PROCESS-REFUND                                      
A01005           EVALUATE TRUE                                          
A01005               WHEN WS-OFF-CYCLE-REBILL                           
A01005                    MOVE SPACES     TO WS-REFUND-CONTROL-IND      
ACT108               WHEN WS-ON-CYCLE-BILL                              
ACT108                    MOVE SPACES     TO WS-ON-OFF-CYCLE-IND        
ACT108                    MOVE WS-FDB07-ACCT-NO TO OC-ACCOUNT-NO        
ACT108                    MOVE AT-CUSTOMER-NO TO OC-CUSTOMER-NO         
ACT108                    MOVE ' ' TO OC-CODE-BILL-OFF-CYCL             
ACT108                    PERFORM 8000-INSERT-OFF-CYCLE THRU 8000-EXIT  
A01005           END-EVALUATE                                           
A01005*                                                                         
C37761     WHEN  (WS-ON-CYCLE-BILL AND AT-CODE-ACCT-STAT='B')           
C37761           DISPLAY '****************************************'     
C37761           DISPLAY '** SKIPPED THE ACCOUNT FROM BILLING   **'     
C37761           DISPLAY '** BECAUSE CODE_ACCT_STAT = B FOR     **'     
C37761           DISPLAY '** NORMAL BILLING ACCOUNT             **'     
C37761           DISPLAY '** ACCOUNT_NO         :' AT-ACCOUNT-NO        
C37761           DISPLAY '** WS-ON-OFF-CYCLE-IND:' WS-ON-OFF-CYCLE-IND  
C37761           DISPLAY '****************************************'     
P00166           IF WS-PROCESS-UNIQUE-ID                                
P00166             SET WS-TRACK-BILL-XCLUDE TO TRUE                     
P00166             PERFORM 3700-LOAD-CORR-MAIL-STAT THRU 3700-EXIT      
P00166             PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT               
P00166           END-IF                                                 
C37761           GO TO 2000-EXIT                                        
C33462     WHEN AT-CODE-ACCT-BILLED = 'X'                               
C33462        MOVE AT-ACCOUNT-NO    TO WS-ACCOUNT-NO-AT                 
C33462        DISPLAY WS-ACCOUNT-NO-AT ' IS EXCLUDED '                  
C33462        DISPLAY WS-ACCOUNT-NO-AT                                  
C33462                  '  WORK QUEUE GENERATED'                        
C33462        MOVE AT-PREMISE-NO    TO WS-PREMISE-NO-AT                 
C33462        MOVE AT-CUSTOMER-NO   TO WS-CUSTOMER-NO-AT                
C33462        MOVE AT-COMPANY-NO    TO WS-COMPANY-NO-AT                 
C33462        MOVE AT-LOCAL-OFFICE  TO WS-LOCAL-OFFICE-AT               
C33462        MOVE 1 TO LS-CURR-WQ-ITEM                                 
C33462        SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
C33462        MOVE LOW-VALUES TO                                        
C33462           WS-BILLING-WQ-ITEMS-DATA-WF(WS-BILL-WQ-INDX)           
C33462        MOVE WS-RECORD-EXCLUDED TO                                
C33462           WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)          
C33462        IF WS-SECURED-RATE-FL = 'Y'                               
C33462           MOVE WS-CATEGORY-ID-138 TO                             
C33462              WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX)                 
C33462        ELSE                                                      
C33462        MOVE WS-CATEGORY-ID-17  TO                                
C33462           WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX)                    
C33462        END-IF                                                    
C33462        ADD  1 TO LS-CURR-WQ-ITEM                                 
C33462        SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
C33462        MOVE LOW-VALUES TO                                        
C33462           WS-BILLING-WQ-ITEMS-DATA-WF(WS-BILL-WQ-INDX)           
C33462        MOVE 0 TO WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX)             
C33462        PERFORM 3500-BUILD-WK-QUEUES   THRU 3500-EXIT             
P00166        IF WS-PROCESS-UNIQUE-ID                                   
P00166          SET WS-TRACK-BILL-XCLUDE TO TRUE                        
P00166          PERFORM 3700-LOAD-CORR-MAIL-STAT THRU 3700-EXIT         
P00166          PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT                  
P00166        END-IF                                                    
C33462        GO TO 2000-EXIT                                           
C36000     WHEN AT-CODE-ACCT-BILLED = 'H'                               
C36000        MOVE AT-ACCOUNT-NO             TO WS-ACCOUNT-NO-AT        
C36000        DISPLAY WS-ACCOUNT-NO-AT ' IS HELD FROM BILLING'          
P00166        IF WS-PROCESS-UNIQUE-ID                                   
P00166          SET WS-TRACK-BILL-XCLUDE TO TRUE                        
P00166          PERFORM 3700-LOAD-CORR-MAIL-STAT THRU 3700-EXIT         
P00166          PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT                  
P00166        END-IF                                                    
C36000        GO TO 2000-EXIT                                           
C33462     WHEN WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
P00166        IF WS-PROCESS-UNIQUE-ID                                   
P00166          SET WS-TRACK-BILL-XCLUDE TO TRUE                        
P00166          PERFORM 3700-LOAD-CORR-MAIL-STAT THRU 3700-EXIT         
P00166          PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT                  
P00166        END-IF                                                    
C33462        GO TO 2000-EXIT                                           
C33462     END-EVALUATE.                                                
                                                                        
TF1        IF WS-SINGLE-ITEM-BILL                                       
TF1          AND WS-ON-OFF-CYCLE-IND NOT = SPACE                        
TF1           MOVE 1 TO LS-CURR-WQ-ITEM                                 
TF1           SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM                    
T21753        IF WS-SECURED-RATE-FL = 'Y'                               
T21753           MOVE WS-CATEGORY-ID-138       TO WS-OFCYL-CAT-ID       
T21753        ELSE                                                      
T21753           MOVE WS-CATEGORY-ID-17        TO WS-OFCYL-CAT-ID       
T21753        END-IF                                                    
T21753*                                                                         
TF1           MOVE WS-OFF-CYCLE-WARNING                                 
TF1              TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX)       
TF1           MOVE SPACE TO WS-SINGLE-ITEM-BILL-IND                     
TF1        END-IF                                                       
           MOVE WS-FIODB07 TO WS-HOLD-DB07-ENTRY (WS-DB07-INDX)         
           SET WS-DB07-INDX UP BY 1                                     
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
RSN5***    YOU SHOULD ONLY GO INTO 2100 IF NOT PART 9 OR             **         
RSN5***    IT IS PARTITION 9 AND YOU ARE DEALING WITH A MASTER ACCT  **         
RSN5***    WHO IS EITHER ON CYCLE OR OFF CYCLE ( DUE TO RECYCLING)   **         
RSN5***    AND EITHER HAS ALL SUBS SUCCESSFULLY BILLED OR HIS        **         
RSN5***    OVERRIDE FLAG IS SET                                      **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
ADDMOD     IF WS-PART-NO = 9                                            
RSN5          PERFORM 8010-SELECT-MST-OVERRIDE THRU 8010-EXIT           
ADDMOD     END-IF.                                                      
T16846     MOVE ZERO TO LS-CURR-WQ-ITEM.                                
RSN5       EVALUATE TRUE                                                
RSN5          WHEN WS-PART-NO NOT EQUAL 9                               
RSN5               PERFORM 2100-ACCOUNT-PROCESSING-DRIVER               
RSN5                                       THRU 2100-EXIT               
TP7965        WHEN (WS-PART-NO EQUAL 9                                  
TP7965         AND WS-TRANSFER-GUARANTOR)                               
TP7965             PERFORM 2100-ACCOUNT-PROCESSING-DRIVER               
TP7965                                     THRU 2100-EXIT               
RSN5          WHEN (WS-PART-NO EQUAL 9                                  
RSN5           AND AT-MST-SUB-ACCT-IND = WS-MASTER-ACCT                 
RSN5           AND AT-MST-OVRRD-BLL-IND NOT EQUAL WS-YES                
RSN5           AND (WS-ON-CYCLE-BILL OR WS-OFF-CYCLE-REBILL             
T11939              OR WS-OFF-CYCLE-FINAL ))                            
RSN5               PERFORM 2350-CHECK-SUB-ACCT THRU 2350-EXIT           
T11939             IF WS-SUB-ACCT-BILL EQUAL WS-NO                      
T11939                IF WS-CONS-BILL-MAST                              
T11939                   MOVE SPACES TO WS-ON-OFF-CYCLE-IND             
T11939                   PERFORM 2100-ACCOUNT-PROCESSING-DRIVER         
T11939                                     THRU 2100-EXIT               
T11939                ELSE                                              
T15097                   SET WS-DB07-INDX DOWN BY 1                     
T15097                   MOVE SPACES TO                                 
T15097                                WS-HOLD-DB07-ENTRY (WS-DB07-INDX) 
T15865                   PERFORM 7150-GET-ACCT-INFO     THRU 7150-EXIT  
T15865                   MOVE AT-ACCOUNT-NO    TO WS-ACCOUNT-NO-AT      
T15865                   MOVE AT-PREMISE-NO    TO WS-PREMISE-NO-AT      
T15865                   MOVE AT-CUSTOMER-NO   TO WS-CUSTOMER-NO-AT     
T15865                   MOVE AT-COMPANY-NO    TO WS-COMPANY-NO-AT      
T15865                   MOVE AT-LOCAL-OFFICE  TO WS-LOCAL-OFFICE-AT    
T15865                   PERFORM 3500-BUILD-WK-QUEUES   THRU 3500-EXIT  
T15865                   DISPLAY WS-ACCOUNT-NO-AT                       
T15865                                '  WORK QUEUE GENERATED'          
P00166                   IF WS-PROCESS-UNIQUE-ID                        
P00166                      SET WS-TRACK-BILL-MISC TO TRUE              
P00166                      PERFORM 3700-LOAD-CORR-MAIL-STAT            
P00166                                                  THRU 3700-EXIT  
P00166                   END-IF                                         
P00166                   PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT         
T11939                END-IF                                            
RSN5               ELSE                                                 
RSN5                  PERFORM 2100-ACCOUNT-PROCESSING-DRIVER            
RSN5                                       THRU 2100-EXIT               
RSN5               END-IF                                               
KMG2          WHEN (WS-PART-NO EQUAL 9                                  
KMG2           AND AT-MST-SUB-ACCT-IND = WS-MASTER-ACCT                 
KMG2           AND AT-MST-OVRRD-BLL-IND NOT EQUAL WS-YES                
KMG2           AND WS-ON-OFF-CYCLE-IND EQUAL SPACE)                     
KMG2               PERFORM 2100-ACCOUNT-PROCESSING-DRIVER               
KMG2                                       THRU 2100-EXIT               
RSN5          WHEN (WS-PART-NO EQUAL 9                                  
RSN5           AND AT-MST-SUB-ACCT-IND = WS-MASTER-ACCT                 
RSN5           AND AT-MST-OVRRD-BLL-IND EQUAL WS-YES)                   
RSN5               PERFORM 2100-ACCOUNT-PROCESSING-DRIVER               
RSN5                                       THRU 2100-EXIT               
TP4670        WHEN (WS-PART-NO EQUAL 9                                  
TP4670         AND WS-OFF-CYCLE-ACCT-TRANS)                             
TP4670             PERFORM 2100-ACCOUNT-PROCESSING-DRIVER               
TP4670                                     THRU 2100-EXIT               
T13829        WHEN (WS-PART-NO EQUAL 9                                  
T13829         AND WS-ON-CYCLE-BILL)                                    
T13829             PERFORM 2100-ACCOUNT-PROCESSING-DRIVER               
T13829                                     THRU 2100-EXIT               
RSN5       END-EVALUATE.                                                
           IF RETRY-NEEDED                                              
              IF WS-HOLD-DB07-ENTRY (1) NOT = SPACES                    
      ** NO NEED TO REPROCESS IF THE ERROR OCCURRED ON THE FIRST ACCT           
      ** IN THE INTERVAL                                                        
                 DISPLAY '***                                          '
                         '                   ***'                       
                 DISPLAY '*** STARTING RETRY ATTEMPT AFTER ENCOUNTERING'
T16440                   ' AN UPDATE OR EXTRACT PROBLEM ***'            
                 INITIALIZE WS-LOCAL-AND-TOTAL-ACCUM-TABLE              
T11745                      WS-LOCAL-ACCUM-HOLD                         
                            WS-LOCAL-OFFICE-REVENUE-TABLE               
                            WS-WNA-REVENUE-SUMMARY-TABLE                
                 SET RETRY-IN-PROGRESS TO TRUE                          
                 PERFORM VARYING WS-DB07-INDX FROM 1 BY 1               
TP9995                     UNTIL WS-DB07-INDX > 200                     
                              OR WS-HOLD-DB07-ENTRY (WS-DB07-INDX)      
                                   = SPACES                             
                    MOVE WS-HOLD-DB07-ENTRY (WS-DB07-INDX)              
                          TO WS-FIODB07                                 
P00166              MOVE WS-PROCESS-UNIQUE-ID-FL                        
P00166                   TO LS-PROCESS-UNIQUE-ID-FL                     
                    DISPLAY 'START OF RE-PROCESSING FOR ACCOUNT '       
                            WS-FDB07-ACCT-NO                            
T17051              IF WS-PART-NO EQUAL 9                               
T17051                 PERFORM 8010-SELECT-MST-OVERRIDE THRU 8010-EXIT  
T17051              END-IF                                              
T17051              IF (WS-PART-NO EQUAL 9                              
T17051                 AND AT-MST-SUB-ACCT-IND = WS-MASTER-ACCT         
T17051                 AND AT-MST-OVRRD-BLL-IND NOT EQUAL WS-YES        
T17051                 AND (WS-ON-CYCLE-BILL OR WS-OFF-CYCLE-REBILL     
T17051                 OR WS-OFF-CYCLE-FINAL ))                         
T17051                 PERFORM 2350-CHECK-SUB-ACCT THRU 2350-EXIT       
T17051                 IF WS-SUB-ACCT-BILL EQUAL WS-NO                  
T17051                    IF WS-CONS-BILL-MAST                          
T17051                       MOVE SPACES TO WS-ON-OFF-CYCLE-IND         
T17051                       PERFORM 2100-ACCOUNT-PROCESSING-DRIVER     
T17051                                     THRU 2100-EXIT               
T17051                    ELSE                                          
T17051                       SET WS-DB07-INDX DOWN BY 1                 
T17051                       MOVE SPACES TO                             
T17051                                WS-HOLD-DB07-ENTRY (WS-DB07-INDX) 
T17051                       PERFORM 7150-GET-ACCT-INFO THRU 7150-EXIT  
T17051                       MOVE AT-ACCOUNT-NO    TO WS-ACCOUNT-NO-AT  
T17051                       MOVE AT-PREMISE-NO    TO WS-PREMISE-NO-AT  
T17051                       MOVE AT-CUSTOMER-NO   TO WS-CUSTOMER-NO-AT 
T17051                       MOVE AT-COMPANY-NO    TO WS-COMPANY-NO-AT  
T17051                       MOVE AT-LOCAL-OFFICE  TO WS-LOCAL-OFFICE-AT
T17051                       PERFORM 3500-BUILD-WK-QUEUES THRU 3500-EXIT
T17051                       DISPLAY WS-ACCOUNT-NO-AT                   
T17051                                '  WORK QUEUE GENERATED'          
P00166                       IF WS-PROCESS-UNIQUE-ID                    
P00166                          SET WS-TRACK-BILL-MISC TO TRUE          
P00166                          PERFORM 3700-LOAD-CORR-MAIL-STAT        
P00166                                                  THRU 3700-EXIT  
P00166                       END-IF                                     
P00166                       PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT     
T17051                    END-IF                                        
T17051                 ELSE                                             
T17051                    PERFORM 2100-ACCOUNT-PROCESSING-DRIVER        
T17051                                     THRU 2100-EXIT               
T17051                 END-IF                                           
T17051              ELSE                                                
T16846                  MOVE ZERO TO LS-CURR-WQ-ITEM                    
                        PERFORM 2100-ACCOUNT-PROCESSING-DRIVER          
                           THRU 2100-EXIT                               
                    END-IF                                              
                    END-PERFORM                                         
      ** EVEN THOUGH THE CHECKPOINT INTERVAL MAY NOT HAVE BEEN                  
      ** REACHED, A CHECKPOINT IS TAKEN TO AVOID THE POTENTIAL TO               
      ** OF THRASHING ABOUT REUPDATING THE SAME SET OF ACCOUNTS                 
C31702           IF WS-COMMITS-REQUIRE                                  
                    PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT              
C31702           END-IF                                                 
                 DISPLAY '*** RETRY SUCCESSFUL                         '
                         '                   ***'                       
                 DISPLAY '***                                          '
                         '                   ***'                       
                 ELSE                                                   
      ** THE ONLY ACCOUNT IN THE CHECKPOINT INTERVAL HAD AN ERROR;              
C31702              IF WS-COMMITS-REQUIRE                               
                       PERFORM 8880-ISSUE-CHKP THRU 8880-EXIT           
C31702              END-IF                                              
                 END-IF                                                 
           END-IF                                                       
              SET RETRY-OFF TO TRUE.                                    
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-ACCOUNT-PROCESSING-DRIVER.                                  
T21753*                                                                         
T21753     IF RETRY-IN-PROGRESS                                         
T21753        MOVE WS-FDB07-ACCT-NO         TO UT-ACCOUNT-NO            
T21753        PERFORM 2150-CHECK-SECURED-FLAG  THRU 2150-EXIT           
T21753        MOVE WS-SECURED-RATE          TO WS-SECURED-RATE-FL       
T21753     END-IF                                                       
T16846*    MOVE ZERO TO LS-CURR-WQ-ITEM.                                        
           SET LS-TENANT-DOES-NOT-HAVE-UTIL TO TRUE                     
           INITIALIZE LS-COMM-AREA-VARIABLES                            
                      WS-HOLD-WK03                                      
T19317     MOVE 'Y' TO  WS-TRAN-SUCCESSFUL-FL                           
T16223*    MOVE THE REVENUE MONTH READ FROM JOB_PARM TO BE USED AS              
T16223*    DEFAULT IF THE ACCT BILL WINDOW ISN'T OPEN - IF IT IS OPEN,          
T16223*    THIS FIELD IS RESET IN SCSCA102                                      
T16223     MOVE WS-REVENUE-JOB-PARM    TO LS-CURR-REVENUE-MONTH         
           MOVE ZERO TO LS-FCSWK03-REC-CNTR                             
                        RETURN-CODE                                     
                        EXTRACT-RETURN-CODE                             
                        CALC-RETURN-CODE                                
                        EPP-RETURN-CODE                                 
                        UPDATE-RETURN-CODE                              
T11745     MOVE WS-LOCAL-AND-TOTAL-ACCUM-TABLE TO                       
T11745              WS-LOCAL-ACCUM-HOLD                                 
                                                                        
                                                                        
           PERFORM 2200-GET-BILL-DATA     THRU 2200-EXIT.               
      *  NOTES ON EXTRACT RETURN CODES:                              **         
TF1   *    1.  (SET IN SCSCA102) SINGLE AR ITEM BILL (DEPOSIT)       **         
      *    2.  (SET IN SCSCA102) LPC-ONLY ACCOUNT                    **         
      *    3.  (SET IN SCSCA102) MERCHANDISE-ONLY                    **         
      *    5.  (SET IN SCSCA102) ONLY EXEC TRANSFER-RELATED PROCESSES**         
      *    6.  (SET IN SCSCA102) NO ACTION ON THIS ACCOUNT           **         
      *                                                                         
           MOVE RETURN-CODE           TO EXTRACT-RETURN-CODE            
T18208     MOVE WS-SHARE-STATUS-CD-PJ TO STATUS-CD-PJS-SAVE.            
                                                                        
      ** LOAD STARTING AR BALANCE FOR JOURNALS                                  
           IF EXTRACT-RETURN-CODE < 6                                   
              MOVE WS-TOTAL-AR-BALANCE-AT TO WS-WK03-TOTAL-AR-BAL       
           END-IF.                                                      
                                                                        
TP4569***** SHOULD NOT EXECUTE CA105 IF TRANSFER PROCESS *****                  
                                                                        
KMG1       EVALUATE TRUE                                                
TP4569         WHEN (WS-CONS-BILL-MAST AND NOT WS-OFF-CYCLE-REBILL)     
TP4569         WHEN WS-OFF-CYCLE-ACCT-TRANS                             
TP7965         WHEN (WS-TRANSFER-GUARANTOR AND NOT WS-ON-CYCLE-BILL)    
TP7965         WHEN (WS-TRANSFER-GUARANTEE AND NOT WS-ON-CYCLE-BILL)    
TP4569              CONTINUE                                            
KMG1           WHEN  WS-ADDITIVE-MAST                                   
KMG1           WHEN  EXTRACT-RETURN-CODE = ZERO                         
T33996               IF WS-CODE-BILL-STATUS-BI NOT = WS-NO-BILL         
                       PERFORM 2500-CALC-UTIL-CHARGES    THRU 2500-EXIT 
                       MOVE RETURN-CODE TO CALC-RETURN-CODE             
T33996               END-IF                                             
TP4569     END-EVALUATE.                                                
                                                                        
TP4569***** SHOULD NOT EXECUTE CA108/112 IF TRANSFER PROCESS ***                
TP4569***** NOTE CONS BILL MAST COULD ALSO BE OFF CYCLE DUE TO                  
TP4569***** RECYCLE PROCESS AND THEN YOU NEED TO GO INTO 105 ETC.               
                                                                        
T17777     INITIALIZE WS-HOLD-AMT-POSTED.                               
T17883     MOVE 'N' TO WS-CALC-EPP-ANNIV-FLG.                           
KMG1       EVALUATE TRUE                                                
T11432         WHEN (WS-CONS-BILL-MAST AND WS-ON-OFF-CYCLE-IND = SPACE) 
KMG1           WHEN WS-OFF-CYCLE-ACCT-TRANS                             
TP7965         WHEN (WS-TRANSFER-GUARANTOR AND NOT WS-ON-CYCLE-BILL)    
TP7965         WHEN (WS-TRANSFER-GUARANTEE AND NOT WS-ON-CYCLE-BILL)    
TP4576         WHEN WS-PROCESS-REFUND                                   
TP4569              CONTINUE                                            
KMG1           WHEN (WS-CODE-BILL-STATUS-BI NOT = WS-NO-BILL)           
                     AND NOT WS-ADDITIVE-MAST                           
TF1               IF EXTRACT-RETURN-CODE < 6                            
                        AND CALC-RETURN-CODE = ZERO                     
                     PERFORM 2600-CALC-NON-UTIL-CHGS   THRU 2600-EXIT   
                     MOVE RETURN-CODE TO CALC-RETURN-CODE               
                  END-IF                                                
                                                                        
C26130*           IF EXTRACT-RETURN-CODE = ZERO                                 
C26130*                 AND CALC-RETURN-CODE = ZERO                             
C26130*                 AND LS-EPP-OFFER   = 'YES'                              
C26130*              PERFORM 2700-PROCESS-EPP-OFFER    THRU 2700-EXIT           
C26130*              MOVE RETURN-CODE TO EPP-RETURN-CODE                        
C26130*           END-IF                                                        
               END-EVALUATE.                                            
                                                                        
TP4569**** SHOULD EXECUTE CA110 FOR UPDATES IF TRANSFER PROCESS                 
TF1        IF EXTRACT-RETURN-CODE < 6                                   
                 AND CALC-RETURN-CODE = ZERO                            
                 AND EPP-RETURN-CODE = ZERO                             
                 AND WS-CODE-BILL-STATUS-BI NOT = WS-NO-BILL            
                 AND NOT WS-ADDITIVE-MAST                               
              PERFORM 2800-UPDATE-BILL-RESULTS  THRU 2800-EXIT          
              MOVE RETURN-CODE TO UPDATE-RETURN-CODE                    
           END-IF                                                       
      *                                                              **         
      *  NOTES ON UPDATE RETURN CODES:                               **         
      *    4.  TIME STAMP ERROR (RECORD CHANGED SINCE EXTRACT)       **         
      *   12.  AN ERROR OCCURRED THAT IMPACTS A SPECIFIC ACCOUNT     **         
      *   16.  A SYSTEM-WIDE ERROR OCCURRED OR TOO MANY ATTEMPTS     **         
      *        TO RECOVER FROM RC=4 AND/OR RC-12 WERE DETECTED       **         
      *        OR A RETRY IS IN PROGRESS WHEN A NEW PROBLEM WAS      **         
      *        DETECTED.                                                        
                                                                        
           IF (UPDATE-RETURN-CODE > 0                                   
                   OR EXTRACT-RETURN-CODE > 6                           
PCR473             OR EPP-RETURN-CODE > ZERO                            
PCR473             OR WS-CODE-BILL-STATUS-BI = WS-NO-BILL               
                   OR CALC-RETURN-CODE > ZERO)                          
PCR473           AND WS-DEAD-HORSE-COUNT >= WS-EXCEPTION-LIMIT          
              MOVE 16 TO UPDATE-RETURN-CODE                             
              DISPLAY '***                                        '     
                   '                   ***'                             
              DISPLAY '*** TOO MANY RECOVERABLE ERRORS ENCOUNTERED'     
                   '                   ***'                             
              DISPLAY '*** TERMINATING PROGRAM                    '     
                   '                   ***'                             
              DISPLAY '***                                        '     
                   '                   ***'                             
           END-IF                                                       
           EVALUATE TRUE                                                
              WHEN EXTRACT-RETURN-CODE = 16                             
              WHEN CALC-RETURN-CODE = 16                                
              WHEN EPP-RETURN-CODE = 16                                 
              WHEN UPDATE-RETURN-CODE = 16                              
                 DISPLAY WS-ACCOUNT-NO-AT                               
                         ' FAILED. SYSTEM-WIDE ERROR OCCURRED '         
                 PERFORM 9910-ROLLBACK             THRU 9910-EXIT       
                 PERFORM 3500-BUILD-WK-QUEUES      THRU 3500-EXIT       
                 PERFORM 9920-COMMIT THRU 9920-EXIT                     
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              WHEN UPDATE-RETURN-CODE = 4                               
                 DISPLAY WS-ACCOUNT-NO-AT                               
                         '   TIME STAMP CHANGED; REQUEUED'              
====> *          MOVE WS-HOLD-DB07-ENTRY (WS-DB07-INDX)                         
====> *            TO RETRY-DB07-RECORD                                         
                 PERFORM 8990-WRITE-RETRY-DB07 THRU 8990-EXIT           
                 SET WS-DB07-INDX DOWN BY 1                             
                 MOVE SPACES TO WS-HOLD-DB07-ENTRY (WS-DB07-INDX)       
                 PERFORM 9910-ROLLBACK             THRU 9910-EXIT       
T11745           MOVE WS-LOCAL-ACCUM-HOLD TO                            
T11745                      WS-LOCAL-AND-TOTAL-ACCUM-TABLE              
PCR473           MOVE WS-RESTART-EXCEPTION-CTR TO WS-DEAD-HORSE-COUNT   
                 ADD 1 TO WS-DEAD-HORSE-COUNT                           
                 IF RETRY-OFF                                           
                    SET RETRY-NEEDED TO TRUE                            
                 END-IF                                                 
      ********---------------------------------------------*********            
T16440*COMMENTING OUT WHEN STMT FOR THIS TPR                                    
STRS  *       WHEN EXTRACT-RETURN-CODE = 12                                     
TEST  *             DISPLAY WS-ACCOUNT-NO-AT                                    
TEMP  *                  ' SKIPPED. EXTRACT ERROR OCCURRED '                    
CHNG  *             SET WS-DB07-INDX DOWN BY 1                                  
CONT  *             MOVE SPACES TO WS-HOLD-DB07-ENTRY (WS-DB07-INDX)            
MN    *             PERFORM 3500-BUILD-WK-QUEUES      THRU 3500-EXIT            
T6068 *             SET WS-DB07-INDX TO WS-CHKP-LUW-LIMIT                       
T6068 ** THE ABOVE "SET" CAUSES THE CONTROLLING PARAGRAPH (1000)                
T6068 ** TO EXECUTE THE CHECKPOINT ROUTINE                                      
T6068 *             ADD 1 TO WS-DEAD-HORSE-COUNT                                
T6068 *             PERFORM 9920-COMMIT               THRU 9920-EXIT            
T11745*             MOVE WS-LOCAL-ACCUM-HOLD TO                                 
T11745*                     WS-LOCAL-AND-TOTAL-ACCUM-TABLE                      
T16440*       PROCESS EXTRACT RETURN 12 THE SAME AS UPDATE FAILURE              
T16440*       DUE TO A -911 RETURN CODE AUTOMATICALLY ROLLING BACK              
T16440*       THE DATA.  NOW ANY EXTRACT PROBLEM WILL GO THROUGH THE            
T16440*       RETRY ROUTINE.                                                    
      ********---------------------------------------------*********            
T16440        WHEN EXTRACT-RETURN-CODE = 12                             
              WHEN CALC-RETURN-CODE = 12                                
              WHEN EPP-RETURN-CODE = 12                                 
              WHEN UPDATE-RETURN-CODE = 12                              
                 IF RETRY-IN-PROGRESS                                   
                    MOVE 16 TO UPDATE-RETURN-CODE                       
                    DISPLAY '*** ERROR ENCOUNTERED DURRING RETRY       '
                         '                      ***'                    
                    DISPLAY '*** RETRY ATTEMPT FOR ACCOUNT '            
                            WS-ACCOUNT-NO-AT                            
                            ' ABANDONED           ***'                  
                    DISPLAY '***                                       '
                         '                      ***'                    
                    PERFORM 9910-ROLLBACK             THRU 9910-EXIT    
                    PERFORM 3500-BUILD-WK-QUEUES      THRU 3500-EXIT    
P00166              IF WS-PROCESS-UNIQUE-ID                             
P00166                SET WS-TRACK-BILL-REJECT TO TRUE                  
P00166                PERFORM 3700-LOAD-CORR-MAIL-STAT THRU 3700-EXIT   
P00166              END-IF                                              
                    PERFORM 9920-COMMIT               THRU 9920-EXIT    
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 ELSE                                                   
                    DISPLAY WS-ACCOUNT-NO-AT                            
                         ' FAILED. PROCESSING ERROR OCCURRED '          
                    SET WS-DB07-INDX DOWN BY 1                          
                    MOVE SPACES TO WS-HOLD-DB07-ENTRY (WS-DB07-INDX)    
                    PERFORM 9910-ROLLBACK             THRU 9910-EXIT    
                    PERFORM 3500-BUILD-WK-QUEUES      THRU 3500-EXIT    
P00166              IF WS-PROCESS-UNIQUE-ID                             
P00166                SET WS-TRACK-BILL-REJECT TO TRUE                  
P00166                PERFORM 3700-LOAD-CORR-MAIL-STAT THRU 3700-EXIT   
P00166              END-IF                                              
T4146               PERFORM 9920-COMMIT               THRU 9920-EXIT    
T11745              MOVE WS-LOCAL-ACCUM-HOLD TO                         
T11745                      WS-LOCAL-AND-TOTAL-ACCUM-TABLE              
PCR473              MOVE WS-RESTART-EXCEPTION-CTR TO WS-DEAD-HORSE-COUNT
                    ADD 1 TO WS-DEAD-HORSE-COUNT                        
                    IF RETRY-OFF                                        
                       SET RETRY-NEEDED TO TRUE                         
                    END-IF                                              
                 END-IF                                                 
              WHEN OTHER                                                
                 IF WS-CODE-BILL-STATUS-BI NOT = WS-NO-BILL             
P00166***           NEED TO UPDATE TRACKING STATUS DURNING RETRY DUE            
P00166***           TO ROLLBACK                                                 
                    IF RETRY-OFF OR RETRY-IN-PROGRESS                   
T17582                 PERFORM 2900-SET-SUPPRESS-FLAG  THRU 2900-EXIT   
TP7965                 IF ((WS-TRANSFER-GUARANTOR                       
TP7965                      AND NOT WS-ON-CYCLE-BILL)                   
TP7965                   OR (WS-TRANSFER-GUARANTEE                      
TP7965                       AND NOT WS-ON-CYCLE-BILL))                 
T11766                   OR (WS-CONS-BILL-MAST                          
T11766                       AND WS-ON-OFF-CYCLE-IND = SPACE)           
T10424                   OR WS-OFF-CYCLE-ACCT-TRANS                     
T17199                   OR WS-PROCESS-REFUND                           
P00166                    IF WS-PROCESS-UNIQUE-ID                       
P00599                      SET WS-TRACK-BILL-MISC TO TRUE              
P00166                      PERFORM 3700-LOAD-CORR-MAIL-STAT THRU       
P00166                                                     3700-EXIT    
P00166                    END-IF                                        
TP7965                    CONTINUE                                      
TP7965                 ELSE                                             
P00166                    IF WS-PROCESS-UNIQUE-ID                       
P00166                      EVALUATE TRUE                               
P0599A                        WHEN WS-ACCT-SUPPRESS-IND = 'Z'           
P0599A                          SET WS-TRACK-BILL-SUPPRESS  TO TRUE     
P00166                        WHEN WS-OFF-CYCLE-REBILL                  
P00166                          SET WS-TRACK-BILLED-REBILL  TO TRUE     
P00166                        WHEN LS-CIG-CUSTOMER = 'Y'                
P00166                          SET WS-TRACK-BILLED-CIG     TO TRUE     
P00166                        WHEN SECURED-RATE                         
P00166                          SET WS-TRACK-BILLED-SECRATE TO TRUE     
P00166                        WHEN OTHER                                
P00166                          SET WS-TRACK-BILLED-NORMAL  TO TRUE     
P00166                      END-EVALUATE                                
P00166                      PERFORM 3700-LOAD-CORR-MAIL-STAT THRU       
P00166                                                        3700-EXIT 
P00166                    END-IF                                        
P00166                    IF RETRY-OFF                                  
                             MOVE ZERO TO LS-FCSBE00-REC-CNTR           
                                 LS-FCSBE01-REC-CNTR                    
P00166                       MOVE WS-PROCESS-UNIQUE-ID-FL               
P00166                           TO LS-PROCESS-UNIQUE-ID-FL             
                             PERFORM 3000-WRITE-EXTRACTS THRU 3000-EXIT 
                             ADD LS-FCSBE00-REC-CNTR                    
                                 TO WS-RESTART-FCSBE00-REC-CNTR         
                             ADD LS-FCSBE01-REC-CNTR                    
                                 TO WS-RESTART-FCSBE01-REC-CNTR         
P00166                    END-IF                                        
TP7965                 END-IF                                           
                    END-IF                                              
                    IF NOT WS-ADDITIVE-MAST                             
                       PERFORM 3100-BUILD-JOURNALS THRU 3100-EXIT       
                    END-IF                                              
T11745           ELSE                                                   
P00166***           TRACK AS BILL SUPPRESSED IF NO REJECT WQ                    
P00166              IF WS-PROCESS-UNIQUE-ID                             
P00166                 IF WS-CATEGORY-ID-WF (1) > ZERO                  
P00166                    SET WS-TRACK-BILL-REJECT TO TRUE              
P00166                 ELSE                                             
P00166                    SET WS-TRACK-BILL-SUPPRESS TO TRUE            
P00166                 END-IF                                           
P00166                 PERFORM 3700-LOAD-CORR-MAIL-STAT THRU 3700-EXIT  
P00166              END-IF                                              
T11745              MOVE WS-LOCAL-ACCUM-HOLD TO                         
T11745                      WS-LOCAL-AND-TOTAL-ACCUM-TABLE              
PCR473              ADD +1 TO WS-DEAD-HORSE-COUNT                       
T19541              IF WS-OFF-CYCLE-REBILL                              
T19541                 MOVE WS-FDB07-ACCT-NO TO OC-ACCOUNT-NO           
T19541                 MOVE AT-CUSTOMER-NO TO OC-CUSTOMER-NO            
T19541                 MOVE 'O' TO OC-CODE-BILL-OFF-CYCL                
T19541                 PERFORM 8000-INSERT-OFF-CYCLE THRU 8000-EXIT     
T19541              END-IF                                              
T17357              IF WS-MST-SUB-ACCT-IND-AT = SPACE AND               
T17357                 WS-ON-CYCLE-TRANSFER                             
T17357                   MOVE WS-FDB07-ACCT-NO    TO OC-ACCOUNT-NO      
T17357                   MOVE AT-CUSTOMER-NO      TO OC-CUSTOMER-NO     
T17357                   MOVE 'T'              TO OC-CODE-BILL-OFF-CYCL 
T17357                   PERFORM 8000-INSERT-OFF-CYCLE   THRU 8000-EXIT 
T17357                   SET WS-NOT-ON-CYCLE-TRANSFER TO TRUE           
T17357              END-IF                                              
                 END-IF                                                 
                 IF WS-CATEGORY-ID-WF (1) > ZERO                        
                    IF RETRY-IN-PROGRESS                                
                       DISPLAY WS-ACCOUNT-NO-AT                         
                            '  WORK QUEUE REBUILT '                     
                    ELSE                                                
                       DISPLAY WS-ACCOUNT-NO-AT                         
                            '  WORK QUEUE GENERATED'                    
                    END-IF                                              
                    PERFORM 3500-BUILD-WK-QUEUES   THRU 3500-EXIT       
A00753              PERFORM 8880-ISSUE-CHKP        THRU 8880-EXIT       
                 ELSE                                                   
                    IF RETRY-IN-PROGRESS                                
                       DISPLAY WS-ACCOUNT-NO-AT                         
                             ' REPROCESSED SUCCESSFULLY'                
                    ELSE                                                
                       DISPLAY WS-ACCOUNT-NO-AT                         
                             ' PROCESSED SUCCESSFULLY'                  
                    END-IF                                              
                 END-IF                                                 
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
T21753******************************************************************        
T21753* PROCESSES RECORDS UNTIL THE ACCOUNT IS A SECURED RATE OR RETURN         
T21753* CODE EQUAL NOT FOUND                                                    
T21753******************************************************************        
T21753 2150-CHECK-SECURED-FLAG.                                         
T21753*                                                                         
T21753     SET NOT-SECURED-RATE             TO TRUE                     
T21753     PERFORM 7100-OPEN-RATE-PLAN      THRU 7100-EXIT.             
T21753     PERFORM 7110-FETCH-RATE-PLAN     THRU 7110-EXIT              
T21753     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
T21753         OR  SECURED-RATE                                         
T21753         PERFORM 7110-FETCH-RATE-PLAN THRU 7110-EXIT              
T21753     END-PERFORM.                                                 
T21753     PERFORM 7120-CLOSE-RATE-PLAN     THRU 7120-EXIT.             
T21753*                                                                         
T21753 2150-EXIT.                                                       
T21753     EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    2200-GET-BILL-DATA                                        **         
      *                                                              **         
      *    THIS PARAGRAPH DETERMINES WHEN TO CALL SCSCA100 TO OBTAIN **         
      *    THE INFORMATION FROM THE DATABASE THAT IS NEEDED TO BILL  **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       2200-GET-BILL-DATA.                                              
      *                                                                         
P00496     SET BATCH-CALL TO TRUE.                                      
      *                                                                         
           CALL SCSCA102 USING LS-PCSCA100-COMM-AREA                    
                               WS-FIODB07                               
                               WS-PART-NO                               
                               WS-PREMISE-PR                            
                               WS-PREMISE-INSTR-PS                      
                               WS-PREMISE-DIRECT-PP                     
                               WS-PREMISE-PAD-PC                        
                               WS-CUSTOMER-CU                           
                               WS-CUST-PREM-HIST-CH                     
                               WS-ACCOUNT-AT                            
                               WS-DEP-ON-HAND-DO                        
                               WS-CHRG-OFF-CO                           
                               WS-CUST-STATS-CE                         
                               WS-CUST-ALERT-CA                         
                               WS-BANK-EFT-BE                           
                               WS-CRED-COLL-CL                          
                               WS-SURETY-BOND-SB                        
                               WS-LIEAP-LI                              
                               WS-PEAK-HIST-PH                          
                               WS-BILLING-BI                            
                               WS-BILLING-BG                            
                               WS-BILL-CALC-DETAIL                      
                               WS-BILL-ADJUST-DETAIL                    
                               WS-CNSMPTN-HIST-CX                       
                               WS-UNMTRD-CNSMPTN-UC                     
                               WS-FIXED-FCTR-HIST-FH                    
                               WS-BILL-CONTRACT-BK                      
                               WS-BILL-CNTR-HIST-BX                     
                               WS-AR-CNTRL-AC                           
                               WS-BUDGET-PLAN-BU                        
                               WS-CONNECT-CHRG-CC                       
                               WS-DFA-ACCT-DA                           
                               WS-DFA-RECV-DV                           
PCR072*                        WS-CIAC-CI                                       
                               WS-DEP-REQ-DR                            
                               WS-CONTRACT-CT                           
                               WS-CONTRACT-DETAIL-TABLE-EA              
TP2699*                        WS-ADV-COLL-AD                                   
                               WS-BUS-CUST-STATS-BS                     
                               WS-CONTACT-CN                            
                               WS-ACCT-BILL-NMES-AB                     
                               WS-ADDR-FREEFORM-DZ                      
                               WS-ADDR-FORMATTED-DY                     
                               WS-CREDIT-PROFILE-CZ                     
                               WS-SHORT-TERM-AGMT-SA                    
                               WS-PROJECT-SHARE-PJ                      
                               WS-INTERRUPT-ACCT-IP                     
                               WS-STANDBY-GEN-SE                        
                               WS-INTERRUPT-IR                          
                               WS-FINAL-WO-FW                           
                               WS-UTILITY-TABLE-UT                      
                               WS-USAGE-HIST-TABLE-UH                   
                               WS-REGISTER-READ-TABLE-RG                
                               WS-UTL-BILL-REL-TABLE-UR                 
                               WS-FIXED-FCTR-TABLE-FF                   
                               WS-MTRD-ENVRNMT-TABLE-MN                 
                               WS-MTR-CAP-TABLE-MC                      
                               WS-EQUIPMENT-TABLE-EQ                    
                               WS-CUST-PLAN-TABLE-CP                    
                               WS-FCA00-BILL-CYCLES-RECORD              
                               WS-BILLING-WQ-ITEMS-WF                   
                               WS-12-MONTH-DATA-EPP                     
                               WS-RATE-COMPARE-RC                       
                               WS-GL-ACCT-NO-TABLE                      
                               WS-HOLD-WK03                             
                               WS-REFUND-RN                             
C34569                         WS-ACCT-ATTRIBUTE-YP                     
C34569                         WS-ACCT-MKT-TIER-DD                      
C34569                         WS-ACCT-RTPK-AGR-DF                      
C34569                         WS-BI-FIXED-FCTR-FF                      
C34569                         WS-BILL-DET-BT                           
T33924                         WS-BILL-ADJUSTMNT                        
C30169                         WS-FINAL-WO-ACTN-KD                      
C30169                         WS-FINAL-WO-COLL-IZ                      
I00177                         WS-CWS1001B-MAX-TBL-LIMITS               
I00177                         WS-CWS1000B-MAX-TBL-LIMITS               
P00577                         WS-CONTRACT-CONT-1C                      
P00166                         WS-CORR-MAIL-STAT-MW                     
P00257                         WS-BILL-CALC-X-DETAIL                    
P00251                         WS-VOL-DAILY-ND                          
P00251                         WS-UTL-BI-REL-HST-TABLE-UX               
P00453                         WS-PREPAY-HIST-PK                        
P00496                         WS-BILL-BSLN-CNTR-LN                     
P00496                         WS-BILL-BSLN-HIST-LO                     
P00496                         WS-CALL-ENVIRONMENT                      
VKSACT                         WS-INTERRUPT-NZ                          
P00496                         WS-CNSMPTN-HOURLY                        
I01959                         WS-AR-CNTRL-ASGNE-XFER-AX.               
C34569     MOVE WS-ON-OFF-CYCLE-IND TO WS-CODE-OFF-CYCLE-CALC.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
RSN5  /****************************************************************         
RSN5  *                                                              **         
RSN5  *    2350-CHECK-SUB-ACCT                                       **         
T11939*    CHECK THE SUB_ACCT_BLLD_OK FLAG FOR EACH SUB.  IF ANY SUB **         
      *    HAS A CODE OF NO THEN INSERT THE MASTER IN                **         
      *    THE OFF CYCLE TABLE TO TRY AND BILL AGAIN TOMORROW.       **         
RSN5  *                                                              **         
RSN5  *****************************************************************         
RSN5   2350-CHECK-SUB-ACCT.                                             
TP5339     MOVE ZERO TO LS-CURR-WQ-ITEM.                                
RSN5       MOVE WS-YES TO WS-SUB-ACCT-BILL.                             
RSN5       PERFORM 7530-OPEN-MST-ACCT            THRU 7530-EXIT.        
RSN5       PERFORM 7540-FETCH-MST-ACCT           THRU 7540-EXIT.        
RSN5       PERFORM UNTIL WS-SUB-ACCT-BILL EQUAL WS-NO                   
RSN5         OR SQLCODE EQUAL NOT-FOUND                                 
RSN5          IF MU-SUB-ACCT-BLLD-OK EQUAL WS-NO                        
T17242           PERFORM 7615-SELECT-SUB-ACCT-STAT THRU 7615-EXIT       
T17242           IF AT-CODE-ACCT-STAT NOT EQUAL (WS-FINAL-BILL AND      
KDFKDF               WS-PNDG-ACCT)                                      
RSN5               MOVE WS-NO                  TO WS-SUB-ACCT-BILL      
RSN5               PERFORM 2355-SUB-ACCT-WQ        THRU 2355-EXIT       
RSN5               MOVE WS-FDB07-ACCT-NO       TO OC-ACCOUNT-NO         
RSN5               MOVE AT-CUSTOMER-NO         TO OC-CUSTOMER-NO        
RSN5               MOVE SPACE                  TO OC-CODE-BILL-OFF-CYCL 
RSN5               PERFORM 8000-INSERT-OFF-CYCLE   THRU 8000-EXIT       
T17242           ELSE                                                   
T17242            PERFORM 7540-FETCH-MST-ACCT     THRU 7540-EXIT
                 END-IF        
RSN5          ELSE                                                      
RSN5             PERFORM 7540-FETCH-MST-ACCT     THRU 7540-EXIT         
RSN5          END-IF                                                    
RSN5       END-PERFORM.                                                 
RSN5       PERFORM 7550-CLOSE-MST-ACCT           THRU 7550-EXIT.        
RSN5   2350-EXIT.                                                       
RSN5       EXIT.                                                        
RSN5  /****************************************************************         
RSN5  *                                                              **         
RSN5  *    2355-SUB-ACCT-WQ                                          **         
RSN5  *                                                              **         
RSN5  *****************************************************************         
RSN5   2355-SUB-ACCT-WQ.                                                
RSN5       ADD +1 TO LS-CURR-WQ-ITEM.                                   
RSN5       SET WS-BILL-WQ-INDX TO LS-CURR-WQ-ITEM.                      
RSN5       MOVE WS-SUBS-NOT-ALL-BILLED                                  
RSN5          TO WS-BILLING-WQ-ITEMS-DATA-WF (WS-BILL-WQ-INDX).         
RSN5   2355-EXIT.                                                       
RSN5       EXIT.                                                        
      *                                                                         
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    2500-CALC-UTIL-CHARGES                                    **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       2500-CALC-UTIL-CHARGES.                                          
      *                                                                         
P00496     SET BATCH-CALL TO TRUE.                                      
      *                                                                         
           CALL SCSCA105 USING LS-PCSCA100-COMM-AREA                    
T17119                         WS-FIODB07                               
                               SCSCA103-ACCUMULATORS                    
                               WS-PREMISE-PR                            
                               WS-CUSTOMER-CU                           
                               WS-ACCOUNT-AT                            
                               WS-AR-CNTRL-AC                           
                               WS-BILLING-BI                            
                               WS-BILLING-BG                            
                               WS-BILL-CALC-DETAIL                      
                               WS-BILL-ADJUST-DETAIL                    
                               WS-CNSMPTN-HIST-CX                       
                               WS-UNMTRD-CNSMPTN-UC                     
                               WS-FIXED-FCTR-HIST-FH                    
                               WS-BILL-CONTRACT-BK                      
                               WS-CUST-PLAN-TABLE-CP                    
                               WS-FIXED-FCTR-TABLE-FF                   
                               WS-BILL-CNTR-HIST-BX                     
                               WS-PEAK-HIST-PH                          
                               WS-INTERRUPT-ACCT-IP                     
                               WS-STANDBY-GEN-SE                        
                               WS-INTERRUPT-IR                          
                               WS-UTILITY-TABLE-UT                      
                               WS-REGISTER-READ-TABLE-RG                
                               WS-MTRD-ENVRNMT-TABLE-MN                 
                               WS-MTR-CAP-TABLE-MC                      
                               WS-UTL-BILL-REL-TABLE-UR                 
                               WS-EQUIPMENT-TABLE-EQ                    
                               WS-FCA00-BILL-CYCLES-RECORD              
                               WS-BILLING-WQ-ITEMS-WF                   
                               WS-LOCAL-AND-TOTAL-ACCUM-TABLE           
                               WS-GL-NAME-INFO                          
                               WS-GL-ACCT-NO-TABLE                      
                               WS-GL-ACCT-MAJOR-FIELDS                  
                               WS-HOLD-WK03                             
DC                             WS-WNA-REVENUE-SUMMARY-TABLE             
                               WS-REFUND-RN                             
C34569                         WS-ACCT-ATTRIBUTE-YP                     
C34569                         WS-ACCT-MKT-TIER-DD                      
C34569                         WS-ACCT-RTPK-AGR-DF                      
C34569                         WS-BI-FIXED-FCTR-FF                      
C34569                         WS-BILL-DET-BT                           
T33924                         WS-BILL-ADJUSTMNT                        
I00177                         WS-CWS1000B-MAX-TBL-LIMITS               
I00177                         WS-CWS1001B-MAX-TBL-LIMITS               
P00257                         WS-BILL-CALC-X-DETAIL                    
P00251                         WS-VOL-DAILY-ND                          
P00251                         WS-UTL-BI-REL-HST-TABLE-UX               
P00453                         WS-PREPAY-HIST-PK                        
P00496                         WS-BILL-BSLN-CNTR-LN                     
P00496                         WS-BILL-BSLN-HIST-LO                     
P00496                         WS-CALL-ENVIRONMENT                      
VKSACT                         WS-INTERRUPT-NZ                          
P00496                         WS-CNSMPTN-HOURLY                        
I01959                         WS-AR-CNTRL-ASGNE-XFER-AX.               
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    2600-CALC-NON-UTIL-CHGS                                   **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       2600-CALC-NON-UTIL-CHGS.                                         
           CALL SCSCA108 USING LS-PCSCA100-COMM-AREA                    
TF1                            WS-FIODB07                               
                               WS-CUSTOMER-CU                           
                               WS-CUST-PREM-HIST-CH                     
                               WS-ACCOUNT-AT                            
                               WS-PREMISE-PR                            
                               WS-DEP-ON-HAND-DO                        
                               WS-BILLING-BI                            
                               WS-BILLING-BG                            
                               WS-UNMTRD-CNSMPTN-UC                     
                               WS-AR-CNTRL-AC                           
                               WS-BUDGET-PLAN-BU                        
                               WS-CONNECT-CHRG-CC                       
                               WS-DFA-ACCT-DA                           
                               WS-DFA-RECV-DV                           
PCR072*                        WS-CIAC-CI                                       
                               WS-DEP-REQ-DR                            
                               WS-CONTRACT-CT                           
                               WS-PROJECT-SHARE-PJ                      
                               WS-CREDIT-PROFILE-CZ                     
                               WS-BILLING-WQ-ITEMS-WF                   
C29752*                        WS-INTEREST-RATE-TABLE                           
                               WS-GL-NAME-INFO                          
                               WS-GL-ACCT-NO-TABLE                      
                               WS-GL-ACCT-MAJOR-FIELDS                  
                               WS-LOCAL-OFFICE-REVENUE-TABLE            
                               WS-LOCAL-AND-TOTAL-ACCUM-TABLE           
                               WS-CHRG-OFF-CO                           
                               WS-HOLD-WK03                             
                               WS-BILL-CALC-DETAIL                      
                               WS-BILL-ADJUST-DETAIL                    
                               WS-CNSMPTN-HIST-CX                       
                               WS-FIXED-FCTR-HIST-FH                    
                               WS-BILL-CONTRACT-BK                      
                               WS-CUST-PLAN-TABLE-CP                    
                               WS-FIXED-FCTR-TABLE-FF                   
                               WS-BILL-CNTR-HIST-BX                     
                               WS-PEAK-HIST-PH                          
                               WS-INTERRUPT-ACCT-IP                     
                               WS-INTERRUPT-IR                          
                               WS-UTILITY-TABLE-UT                      
                               WS-REGISTER-READ-TABLE-RG                
                               WS-MTRD-ENVRNMT-TABLE-MN                 
                               WS-MTR-CAP-TABLE-MC                      
                               WS-12-MONTH-DATA-EPP                     
                               WS-STANDBY-GEN-SE                        
                               WS-REFUND-RN                             
PCR294                         WS-CONTRACT-DETAIL-TABLE-EA              
T17777                         WS-HOLD-AMT-POSTED                       
T17883                         WS-CALC-EPP-ANNIV-FLG                    
T19214                         WS-CRED-COLL-CL                          
T21893                         WS-DPP-AMOUNT-DELINQ                     
C34569                         WS-ACCT-RTPK-AGR-DF                      
C34569                         WS-BI-FIXED-FCTR-FF                      
C34569                         WS-BILL-DET-BT                           
T33924                         WS-BILL-ADJUSTMNT                        
I00177                         WS-CWS1000B-MAX-TBL-LIMITS               
I00177                         WS-CWS1001B-MAX-TBL-LIMITS               
P00453                         WS-PREPAY-HIST-PK                        
P00496                         WS-BILL-BSLN-CNTR-LN                     
P00496                         WS-BILL-BSLN-HIST-LO                     
P00496                         WS-UTL-BILL-REL-TABLE-UR                 
VKSACT                         WS-INTERRUPT-NZ                          
P00496                         WS-CNSMPTN-HOURLY                        
I01687                         WS-ACCT-ATTRIBUTE-YP.                    
       2600-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    2700-RECALC-EPP                                           **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
C26130*2700-PROCESS-EPP-OFFER.                                                  
C26130*                                                                         
C26130*    CALL SCSCA112 USING LS-PCSCA100-COMM-AREA                            
C26130*                        WS-PREMISE-PR                                    
C26130*                        WS-CUSTOMER-CU                                   
C26130*                        WS-ACCOUNT-AT                                    
C26130*                        WS-BILLING-BI                                    
C26130*                        WS-BILLING-BG                                    
C26130*                        WS-BILL-CALC-DETAIL                              
C26130*                        WS-BILL-ADJUST-DETAIL                            
C26130*                        WS-CNSMPTN-HIST-CX                               
C26130*                        WS-UNMTRD-CNSMPTN-UC                             
C26130*                        WS-FIXED-FCTR-HIST-FH                            
C26130*                        WS-BILL-CONTRACT-BK                              
C26130*                        WS-CUST-PLAN-TABLE-CP                            
C26130*                        WS-FIXED-FCTR-TABLE-FF                           
C26130*                        WS-BILL-CNTR-HIST-BX                             
C26130*                        WS-AR-CNTRL-AC                                   
C26130*                        WS-BUDGET-PLAN-BU                                
C26130*                        WS-PEAK-HIST-PH                                  
C26130*                        WS-INTERRUPT-ACCT-IP                             
C26130*                        WS-INTERRUPT-IR                                  
C26130*                        WS-UTILITY-TABLE-UT                              
C26130*                        WS-REGISTER-READ-TABLE-RG                        
C26130*                        WS-MTRD-ENVRNMT-TABLE-MN                         
C26130*                        WS-MTR-CAP-TABLE-MC                              
C26130*                        WS-BILLING-WQ-ITEMS-WF                           
C26130*                        WS-12-MONTH-DATA-EPP                             
C26130*                        WS-STANDBY-GEN-SE                                
C26130*                        WS-REFUND-RN                                     
T10082*                        WS-GL-NAME-INFO                                  
T10082*                        WS-GL-ACCT-NO-TABLE                              
T10082*                        WS-HOLD-WK03                                     
T17777*                        WS-HOLD-AMT-POSTED                               
T17883*                        WS-CALC-EPP-ANNIV-FLG.                           
C26130*2700-EXIT.                                                               
C26130*    EXIT.                                                                
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    2800-UPDATE-BILL-RESULTS                                  **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       2800-UPDATE-BILL-RESULTS.                                        
           CALL SCSCA110 USING LS-PCSCA100-COMM-AREA                    
                               WS-FIODB07                               
                               WS-PART-NO                               
                               WS-PREMISE-PR                            
                               WS-PREMISE-INSTR-PS                      
                               WS-PREMISE-DIRECT-PP                     
                               WS-PREMISE-PAD-PC                        
                               WS-CUSTOMER-CU                           
                               WS-CUST-PREM-HIST-CH                     
                               WS-ACCOUNT-AT                            
                               WS-DEP-ON-HAND-DO                        
                               WS-CHRG-OFF-CO                           
                               WS-CUST-STATS-CE                         
                               WS-CUST-ALERT-CA                         
                               WS-BANK-EFT-BE                           
                               WS-CRED-COLL-CL                          
                               WS-SURETY-BOND-SB                        
                               WS-LIEAP-LI                              
                               WS-PEAK-HIST-PH                          
                               WS-BILLING-BI                            
                               WS-BILLING-BG                            
                               WS-BILL-CALC-DETAIL                      
                               WS-BILL-ADJUST-DETAIL                    
                               WS-CNSMPTN-HIST-CX                       
                               WS-UNMTRD-CNSMPTN-UC                     
                               WS-FIXED-FCTR-HIST-FH                    
                               WS-BILL-CONTRACT-BK                      
                               WS-BILL-CNTR-HIST-BX                     
                               WS-AR-CNTRL-AC                           
                               WS-BUDGET-PLAN-BU                        
                               WS-CONNECT-CHRG-CC                       
                               WS-DFA-ACCT-DA                           
                               WS-DFA-RECV-DV                           
PCR072*                        WS-CIAC-CI                                       
                               WS-DEP-REQ-DR                            
                               WS-CONTRACT-CT                           
                               WS-CONTRACT-DETAIL-TABLE-EA              
TP2699*                        WS-ADV-COLL-AD                                   
                               WS-BUS-CUST-STATS-BS                     
                               WS-CONTACT-CN                            
                               WS-ACCT-BILL-NMES-AB                     
                               WS-ADDR-FREEFORM-DZ                      
                               WS-ADDR-FORMATTED-DY                     
                               WS-CREDIT-PROFILE-CZ                     
                               WS-SHORT-TERM-AGMT-SA                    
                               WS-PROJECT-SHARE-PJ                      
                               WS-INTERRUPT-ACCT-IP                     
                               WS-STANDBY-GEN-SE                        
                               WS-INTERRUPT-IR                          
                               WS-FINAL-WO-FW                           
                               WS-UTILITY-TABLE-UT                      
                               WS-USAGE-HIST-TABLE-UH                   
                               WS-REGISTER-READ-TABLE-RG                
                               WS-UTL-BILL-REL-TABLE-UR                 
                               WS-FIXED-FCTR-TABLE-FF                   
                               WS-MTRD-ENVRNMT-TABLE-MN                 
                               WS-MTR-CAP-TABLE-MC                      
                               WS-EQUIPMENT-TABLE-EQ                    
                               WS-CUST-PLAN-TABLE-CP                    
                               WS-BILLING-WQ-ITEMS-WF                   
                               WS-WORK-DAY-TABLE                        
                               WS-GL-ACCT-NO-TABLE                      
                               WS-GL-NAME-INFO                          
TP3973*                        WS-DFA-RECV-DV                                   
                               WS-HOLD-WK03                             
                               WS-REFUND-RN                             
PCR233                         WS-FCA00-BILL-CYCLES-RECORD              
VVKS************************   WS-LOCAL-AND-TOTAL-ACCUM-TABLE                   
T19317                         WS-TRAN-SUCCESSFUL-FL                    
T29815                         WS-12-MONTH-DATA-EPP                     
T21893                         WS-DPP-AMOUNT-DELINQ                     
C34569                         WS-ACCT-ATTRIBUTE-YP                     
C34569                         WS-ACCT-MKT-TIER-DD                      
C34569                         WS-ACCT-RTPK-AGR-DF                      
C34569                         WS-BI-FIXED-FCTR-FF                      
T33924                         WS-BILL-ADJUSTMNT                        
C30169                         WS-FINAL-WO-ACTN-KD                      
C30169                         WS-FINAL-WO-COLL-IZ                      
I00177                         WS-CWS1000B-MAX-TBL-LIMITS               
I00177                         WS-CWS1001B-MAX-TBL-LIMITS               
P00251                         WS-UTL-BI-REL-HST-TABLE-UX               
P00453                         WS-PREPAY-HIST-PK                        
P00496                         WS-BILL-BSLN-CNTR-LN                     
P00496                         WS-BILL-BSLN-HIST-LO                     
VKSACT                         WS-INTERRUPT-NZ                          
P00496                         WS-CNSMPTN-HOURLY                        
I01959                         WS-AR-CNTRL-ASGNE-XFER-AX.               
       2800-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
T17582*   2900-SET-SUPPRESS-FLAG                                      **        
    ST*                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       2900-SET-SUPPRESS-FLAG.                                          
      * TO CHECK NO AR TRANSACTION WRITTEN FOR BILLING                          
           IF WS-WK03-COUNT > 0                                         
              GO TO 2900-EXIT                                           
            END-IF                                                      
      * TO CHECK NO AR TRANSACTION HISTORY AFTER LAST BILL                      
            MOVE WS-FDB07-ACCT-NO       TO AR-ACCOUNT-NO                
            MOVE ZEROES                 TO WS-COUNT                     
P00599      MOVE SPACES                 TO WS-ACCT-SUPPRESS-IND         
            PERFORM  7160-GET-AR-TIMESTAMP       THRU 7160-EXIT         
            PERFORM  7165-GET-TRANS-HIST         THRU 7165-EXIT         
                                                                        
P00599* IDENTIFY ACCTS WITHOUT AR TRANSACTIONS TO BE SUPPRESSED.                
P00599      IF WS-COUNT = 0                                             
P00599                                                                  
P00599*          SET 'Z' FOR ACCTS WITH AR-BAL <= 0.                            
P00599         IF WS-TOTAL-AR-BALANCE-AT <= 0                           
P00599                MOVE 'Z'                TO WS-ACCT-SUPPRESS-IND   
P00599         END-IF                                                   
P00599                                                                  
P00599      END-IF.                                                     
                                                                        
    ED 2900-EXIT.                                                       
T17582     EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    3000-WRITE-EXTRACTS                                       **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       3000-WRITE-EXTRACTS.                                             
                                                                        
           CALL SCSCA116 USING LS-PCSCA100-COMM-AREA                    
                               WS-PREMISE-PR                            
                               WS-PREMISE-INSTR-PS                      
                               WS-PREMISE-DIRECT-PP                     
                               WS-PREMISE-PAD-PC                        
                               WS-CUSTOMER-CU                           
                               WS-CUST-PREM-HIST-CH                     
                               WS-ACCOUNT-AT                            
                               WS-DEP-ON-HAND-DO                        
                               WS-CHRG-OFF-CO                           
                               WS-CUST-STATS-CE                         
                               WS-CUST-ALERT-CA                         
                               WS-BANK-EFT-BE                           
                               WS-CRED-COLL-CL                          
                               WS-SURETY-BOND-SB                        
                               WS-LIEAP-LI                              
                               WS-PEAK-HIST-PH                          
                               WS-BILLING-BI                            
                               WS-BILLING-BG                            
                               WS-BILL-CALC-DETAIL                      
                               WS-BILL-ADJUST-DETAIL                    
                               WS-CNSMPTN-HIST-CX                       
                               WS-UNMTRD-CNSMPTN-UC                     
                               WS-FIXED-FCTR-HIST-FH                    
                               WS-BILL-CONTRACT-BK                      
                               WS-BILL-CNTR-HIST-BX                     
                               WS-AR-CNTRL-AC                           
                               WS-BUDGET-PLAN-BU                        
                               WS-CONNECT-CHRG-CC                       
                               WS-DFA-ACCT-DA                           
                               WS-DFA-RECV-DV                           
PCR072*                        WS-CIAC-CI                                       
                               WS-DEP-REQ-DR                            
                               WS-CONTRACT-CT                           
                               WS-CONTRACT-DETAIL-TABLE-EA              
TP2699*                        WS-ADV-COLL-AD                                   
                               WS-BUS-CUST-STATS-BS                     
                               WS-CONTACT-CN                            
                               WS-ACCT-BILL-NMES-AB                     
                               WS-ADDR-FREEFORM-DZ                      
                               WS-ADDR-FORMATTED-DY                     
                               WS-CREDIT-PROFILE-CZ                     
                               WS-SHORT-TERM-AGMT-SA                    
                               WS-PROJECT-SHARE-PJ                      
                               WS-INTERRUPT-ACCT-IP                     
                               WS-STANDBY-GEN-SE                        
                               WS-INTERRUPT-IR                          
                               WS-FINAL-WO-FW                           
                               WS-UTILITY-TABLE-UT                      
                               WS-USAGE-HIST-TABLE-UH                   
                               WS-REGISTER-READ-TABLE-RG                
                               WS-UTL-BILL-REL-TABLE-UR                 
                               WS-FIXED-FCTR-TABLE-FF                   
                               WS-MTRD-ENVRNMT-TABLE-MN                 
                               WS-MTR-CAP-TABLE-MC                      
                               WS-EQUIPMENT-TABLE-EQ                    
                               WS-CUST-PLAN-TABLE-CP                    
                               WS-BILLING-WQ-ITEMS-WF                   
                               WS-12-MONTH-DATA-EPP                     
                               WS-RATE-COMPARE-RC                       
                               WS-PART-NO                               
                               WS-REFUND-RN                             
C34569                         WS-ACCT-ATTRIBUTE-YP                     
C34569                         WS-ACCT-MKT-TIER-DD                      
C34569                         WS-ACCT-RTPK-AGR-DF                      
C34569                         WS-BI-FIXED-FCTR-FF                      
C34569                         WS-BILL-DET-BT                           
T33924                         WS-BILL-ADJUSTMNT                        
I00177                         WS-CWS1000B-MAX-TBL-LIMITS               
I00177                         WS-CWS1001B-MAX-TBL-LIMITS               
P00577                         WS-CONTRACT-CONT-1C                      
P00166                         WS-CORR-MAIL-STAT-MW                     
P00257                         WS-BILL-CALC-X-DETAIL                    
P00251                         WS-VOL-DAILY-ND                          
P00251                         WS-UTL-BI-REL-HST-TABLE-UX               
P00453                         WS-PREPAY-HIST-PK                        
P00496                         WS-BILL-BSLN-CNTR-LN                     
P00496                         WS-BILL-BSLN-HIST-LO.                    
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       3100-BUILD-JOURNALS.                                             
T10622     MOVE 'N'   TO WS-EPP-DROP                                    
T10779                   WS-REFUND-GIVEN                                
PCR526                   WS-MULTIPLE-SUBS-XFER                          
           INITIALIZE DCLCSS-AR-TRANS-HIST                              
                      DCLCSS-AR-TRN-HST-DET                             
PCR526     INITIALIZE WS-HOLD-ACCT-NO                                   
A02036                WS-HOLD-ACCT-NO1                                  
C26679                WS-HOLD-TOTAL-BAL                                 
C26679                WS-HOLD-POSTED-AMT.                               
ACT294     SET WS-GL-SUB                      TO 1.                     
C26679     MOVE ZERO                          TO WS-TRAN-APPL-NUM.      
C26679     MOVE WS-N                          TO WS-ADJ-TRANSACTION.    
C26679     MOVE WS-WK03-TOTAL-AR-BAL          TO WS-HOLD-TOTAL-BAL.     
P00453     MOVE 'N'                           TO WS-PRP-ADJ-FLG.        
C26679*                                                                         
C26679** CREATING AN ADJ ROW AT THE TIME OF EPP ANNIVERSARY                     
C26679     SET WK03-INDX                      TO 1.                     
C26679     SEARCH WS-HOLD-WK03-DATA VARYING WK03-INDX                   
C26679          AT END                                                  
C26679             CONTINUE                                             
C26679          WHEN (WS-HOLD-WK03-DATA(WK03-INDX)(20:4)) = 'A112'      
P00453               OR 'A108'                                          
C26679             PERFORM 3300-CREATE-ADJ    THRU 3300-EXIT            
C26679     END-SEARCH.                                                  
C26679*                                                                         
      ** AT THIS POINT, WS-WK03-TOTAL-AR-BAL CONTAINS THE PRE-BILLING           
      ** VALUE OF AT-TOTAL-AR-BALANCE                                           
C26679     MOVE WS-HOLD-TOTAL-BAL             TO WS-WK03-TOTAL-AR-BAL   
PAL        IF WS-WK03-TOTAL-AR-BAL NUMERIC                              
              MOVE WS-WK03-TOTAL-AR-BAL TO AR-AMT-BILLED-UNPAID         
PAL        ELSE                                                         
PAL           MOVE 0                    TO AR-AMT-BILLED-UNPAID         
PAL        END-IF                                                       
      * ACCUMULATE CHANGES IN AR BALANCE FOR JOURNAL                            
           PERFORM VARYING WK03-INDX FROM 1 BY 1                        
T13536               UNTIL WK03-INDX > 5000                             
                        OR WK03-INDX > WS-WK03-COUNT                    
              MOVE WS-HOLD-WK03-DATA (WK03-INDX) TO FIOWK03             
              MOVE E-FWK03-USER-DEFINED-AREA TO CJF00104                
              MOVE WS-104-ACCT-GEN-LED-DR TO WS-GL-PRIME                
PCR305        MOVE WS-104-ACCT-GEN-LED-CR TO WS-GL-PRIME1               
              EVALUATE TRUE                                             
      ***************************************************************           
      *  (1)  "PRE-PAY" THAT ADDS TO UNUSED CREDIT FROM NON-AR SOURCE.          
      *       DECREASES THE ACCOUNT BALANCE                                     
      *       EXAMPLE: EXCESS DEPOSIT REFUND. UNAPPLIED CREDIT WOULD            
      *                GO TO CIA.  CREDIT AR-CIA; DEBIT DEP-DEP                 
      ***************************************************************           
                  WHEN WS-104-AR-AGE = 'P'                              
                    AND WS-GL-PRIME NOT = WS-RECEIVABLE-ACCOUNT         
                    AND WS-GL-PRIME1 = WS-RECEIVABLE-ACCOUNT            
T17931* THIS SECTION WILL BE USED WHEN THE DR <> GL-AR AND CR = AR-CCC          
T17931              IF WS-104-ACCT-GEN-LED-CR                           
T17931                                   = WS-GL-AR-CCC                 
T17931                MOVE  WS-104-ITEM-ID-NO TO WS-ITEM-ID             
T17931                SET WS-AR-DATA-INDX               TO 1            
T17931                SEARCH WS-AR-DATA                                 
T17931                  AT END                                          
T17931                     CONTINUE                                     
T17931                  WHEN WS-PYMT-PRIORITY-LVL-AC                    
T17931                      (WS-AR-DATA-INDX) = 60                      
T17931                  AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = WS-ITEM-ID
T17931                  IF WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) < 0 
T17931                     ADD WS-104-AMT-POSTED TO AR-AMT-BILLED-UNPAID
                                                    AR-AMT-ORIG-ENTERED 
T17931                  ELSE                                            
T17931                     SUBTRACT WS-104-AMT-POSTED                   
T17931                                         FROM AR-AMT-BILLED-UNPAID
T17931                                              AR-AMT-ORIG-ENTERED 
T17391                  END-IF                                          
T17931                END-SEARCH                                        
T17931              ELSE                                                
                      SUBTRACT WS-104-AMT-POSTED                        
                                               FROM AR-AMT-BILLED-UNPAID
                                                    AR-AMT-ORIG-ENTERED 
T17931              END-IF                                              
      ***************************************************************           
      *  (1.5) IF A PAYMENT IS MADE WITH A RECONNECT CHARGE WE WRITE            
      *       IT TO AMT TRAN BALANCE AND NOT BILLED BALANCE, SO                 
      *       WE NEED TO ADD THAT AMOUNT FROM THE RCC ROW TO THE                
      *       AMT BILLED UNPAID IN CSS_AR_TRAN_HIST.                            
      **NOTE* THIS SECTION WILL ONLY BE USED WHEN THE DR = GL-AR AND            
      *       THE CR=AR-CCC, SINCE IF THE DR<>GL-AR IT WOULD GET PICKED         
      *       UP IN THE WHEN CLAUSE ABOVE IN (1)                                
      ***************************************************************           
T17931            WHEN WS-104-AR-AGE = 'P'                              
T17931                  AND WS-104-ACCT-GEN-LED-DR                      
T17931                                   NOT EQUAL WS-GL-AR-CCC         
T17931                  AND WS-104-ACCT-GEN-LED-CR                      
T17931                                   = WS-GL-AR-CCC                 
T17931              MOVE  WS-104-ITEM-ID-NO TO WS-ITEM-ID               
T17931              SET WS-AR-DATA-INDX               TO 1              
T17931              SEARCH WS-AR-DATA                                   
T17931               AT END                                             
T17931                  CONTINUE                                        
T17931               WHEN WS-PYMT-PRIORITY-LVL-AC                       
T17931                      (WS-AR-DATA-INDX) = 60                      
T17391               AND WS-ITEM-ID-AC (WS-AR-DATA-INDX) = WS-ITEM-ID   
T17391                 IF WS-AMT-TRAN-BALANCE-AC (WS-AR-DATA-INDX) < 0  
T17391                    ADD WS-104-AMT-POSTED TO AR-AMT-BILLED-UNPAID 
T17391                                             AR-AMT-ORIG-ENTERED  
T17391                 END-IF                                           
T17931            END-SEARCH                                            
      ***************************************************************           
T19419*  (1.75) IF A REFUND CHECK IS ISSUED AT FB FROM A CIA WE DEDUCT          
T19419*       FROM TRANS HIST BALLANCE (AMT_BILLED_UNPAID) BUT NOT FROM         
T19419*       AMT-ORIG-ENTERED. AR WILL NOT "CHECK BOOK" BUT THE                
T19419*       TRANSACTION INFO WILL BE KEPT.                                    
T19419***************************************************************           
T19419            WHEN WS-104-AR-AGE = 'P'                              
T19419              AND WS-GL-PRIME  = WS-RECEIVABLE-ACCOUNT            
T19419              AND WS-104-ACCT-GEN-LED-CR =                        
T19419                              WS-CLR-CK-ISS-GL-NO (WS-GL-SUB)     
T19419                ADD WS-104-AMT-POSTED  TO AR-AMT-BILLED-UNPAID    
ACT108                MOVE WS-104-AMOUNT-ENTERED                        
ACT108                  TO AR-AMT-ORIG-ENTERED                          
      ***************************************************************           
      *  (2)  "PRE-PAY" THAT APPLIES UNUSED CREDIT TO AN AR BALANCE.            
      *       THERE IS NO CHANGE IN THE ACCOUNT BALANCE                         
      *       EXAMPLE: APPLICATION OF CIA TO UTILITY AR BALANCE.                
      *                CREDIT AR-UTE; DEBIT AR-CIA                              
      ***************************************************************           
A02034            WHEN WS-104-AR-AGE = 'P'                              
A02034                  AND WS-GL-PRIME  = WS-RECEIVABLE-ACCOUNT        
A02034                  AND WS-GL-PRIME1 = WS-RECEIVABLE-ACCOUNT        
A02034               IF WS-MST-SUB-ACCT-IND-AT = WS-MASTER-ACCT         
A02034                     SUBTRACT WS-104-AMT-POSTED                   
A02034                                         FROM AR-AMT-ORIG-ENTERED 
A02034               END-IF                                             
P00453               IF (WS-CODES-DATA-PRESENT-AT (15:1) = 'A' AND      
P00453                   WS-104-ACCT-GEN-LED-CR =                       
P00453                   WS-AR-CIA-GL-NO (WS-GL-SUB))                   
P00453                  SUBTRACT WS-104-AMT-POSTED                      
P00453                                         FROM AR-AMT-ORIG-ENTERED 
P00453                                              AR-AMT-BILLED-UNPAID
P00453               END-IF                                             
                                                                        
      ***************************************************************           
      * (2.5)   E - CREDIT IS APPLIED AGAINST EPP-TRAN-BAL                      
      *       THERE IS NO CHANGE IN THE ACCOUNT BALANCE                         
      *       EXAMPLE: APPLICATION OF CIA TO UTILITY AR BALANCE.                
      *                CREDIT AR-UTE; DEBIT AR-CIA                              
      ***************************************************************           
A02034            WHEN WS-104-AR-AGE = 'E'                              
A02034                  AND WS-GL-PRIME  = WS-RECEIVABLE-ACCOUNT        
A02034                  AND WS-GL-PRIME1 = WS-RECEIVABLE-ACCOUNT        
A02034               CONTINUE                                           
                                                                        
T10545***************************************************************           
T10545*  (3)  TRANSFER 'TO' ACCOUNTS HAVE ALL MONEY PUT INTO                    
T10545*       SUM-UNBILLED - (AR-AMT-BILLED-UNPAID ISN'T UPDATED)               
T10545*       THERE IS NO CHANGE IN THE ACCOUNT BALANCE.                        
T13172*       TRANSFER 'FROM' ACCOUNTS HAVE THE SAME GL'S BUT THE               
T13172*       AR-XFER-IND IS SET TO YES AND AR-AMT-BILLED-UNPAID                
T13172*       MUST BE UPDATED WHEN TRANSFERING A CREDIT.                        
T14972*       MASTER/GUARANTOR ACCOUNTS THAT ARE ALSO BILLING                   
T14972*       ON-CYCLE WILL NOT UPDATE THE TRANSACTION AMOUNT                   
T14972*       (ORIG-ENTERED) BECAUSE THE FULL AMOUNT OF SUM-UNBILLED            
T14972*       IS ADDED IN #7 AND INCLUDES THE JUST XFER'D AMOUNT                
T14972*       (SUM BILLED ON THE SAME CYCLE).                                   
T10545***************************************************************           
T10789            WHEN WS-104-ACCT-GEN-LED-CR =                         
T10789                       WS-CLR-AR-XFR-GL-NO (WS-GL-SUB)            
A01041            WHEN WS-104-ACCT-GEN-LED-CR =                         
A01041                       WS-CLR-MSTSUB-GL-NO (WS-GL-SUB)            
T13172              IF WS-AR-XFER-IND-AT = WS-YES                       
T13172                 ADD WS-104-AMT-POSTED TO AR-AMT-BILLED-UNPAID    
T13172              END-IF                                              
I01959              IF WS-COGEN-AR-XFER-IND  EQUAL 'Y' OR               
T14972                  (WS-ON-CYCLE-BILL    AND                        
T14972                    (WS-MST-SUB-ACCT-IND-AT = WS-MASTER-ACCT OR   
A02036                      WS-ON-CYCLE-TRANSFER OR                     
T14972                       WS-GUARANTEE-TRANSFER-IND NOT = SPACE))    
T14972                 CONTINUE                                         
T14972              ELSE                                                
T10545                 ADD WS-104-AMT-POSTED TO AR-AMT-ORIG-ENTERED     
T14972              END-IF                                              
      ***************************************************************           
      *  (4)  BUDGET IS THE ONLY EXAMPLE IN BILLING WHERE THERE                 
      *       IS A "PRE-PAY" THAT DEBITS AN AR ACCOUNT. THIS DEBIT              
      *       IS APPLIED TO TRAN-BALANCE, SO THERE IS NO CHANGE IN              
      *       THE ACCOUNT BALANCE.                                              
      *       CREDIT AR-BUD; DEBIT A REVENUE ACCOUNT                            
T15304*       A CANCEL REBILL WILL BE THE OPPOSITE                              
T15304*       CREDIT A REVENUE ACCOUNT; DEBIT AR-BUD                            
      ***************************************************************           
                  WHEN WS-104-AR-AGE = ' '                              
                        AND WS-104-ACCT-GEN-LED-DR                      
                          = WS-AR-BUD-GL-NO (WS-GL-SUB)                 
                        AND WS-GL-PRIME1 NOT = WS-RECEIVABLE-ACCOUNT    
                     CONTINUE                                           
T15304            WHEN WS-104-AR-AGE = ' '                              
T15304                  AND WS-104-ACCT-GEN-LED-CR                      
T15304                    = WS-AR-BUD-GL-NO (WS-GL-SUB)                 
T15304                  AND WS-GL-PRIME NOT = WS-RECEIVABLE-ACCOUNT     
T15304               CONTINUE                                           
T10033***************************************************************           
T10033** (5) IF THE ACCOUNT CAME OFF BUDGET, DO NOT WRITE THE JOURNAL           
T10033**     FOR THIS MONTH'S EPP CHARGE                                        
T10847**     BUT INCLUDE THE JOURNAL THAT BACKS OUT ANY EPP AMOUNT              
T10847**     THAT WAS ALREADY CHARGED (AR-AGE IS SPACES)                        
T10033***************************************************************           
T10033            WHEN WS-GL-PRIME = WS-RECEIVABLE-ACCOUNT              
T10033               IF WS-CODES-DATA-PRESENT-AT (3:1) = SPACE          
P00453                     AND WS-CODES-DATA-PRESENT-AT (15:1) = SPACE  
T10033                     AND WS-104-ACCT-GEN-LED-DR                   
T10033                       = WS-AR-BUD-GL-NO (WS-GL-SUB)              
T10033                     AND WS-104-ACCT-GEN-LED-CR                   
T10033                       = WS-AR-BUD-GL-NO (WS-GL-SUB)              
T10847                  IF WS-104-AR-AGE = ' '                          
T10847                     SUBTRACT WS-104-AMT-POSTED FROM              
T10847                        AR-AMT-ORIG-ENTERED                       
T10847                        AR-AMT-BILLED-UNPAID                      
T10847                  ELSE                                            
T10033                     MOVE 'X' TO E-FWK03-JRNL-SORT-ID             
T10622                     MOVE 'Y' TO WS-EPP-DROP                      
T10847                  END-IF                                          
C34216               ELSE                                               
C34216               IF (WS-CALC-EPP-ANNIV-FLG = 'Y'                    
P00453                   OR WS-PRP-ADJ-FLG     = 'Y')                   
C34216                     AND WS-104-ACCT-GEN-LED-DR                   
C34216                       = WS-AR-BUD-GL-NO (WS-GL-SUB)              
C34216                     AND WS-104-ACCT-GEN-LED-CR                   
C34216                       = WS-AR-BUD-GL-NO (WS-GL-SUB)              
C34216                    AND WS-104-AR-AGE = ' '                       
C34216                     SUBTRACT WS-HOLD-EPP-ADJ-AMT FROM            
C34216                        AR-AMT-BILLED-UNPAID                      
T10847***************************************************************           
T10847** (6) EPP TRANSACTIONS THAT CREDIT A CIA RECEIVABLE ACCOUNT              
T10847**     WILL DECREASE THE ACCOUNT BALANCE (CREDIT BAL AT ANNIV)            
T10847**     EXAMPLE: MONTHLY BUDGET CHARGES WITH CREDIT AT ANNIV               
T10847**              DEBIT AR-BUD; CREDIT AR-CIA                               
T10847***************************************************************           
T10847               ELSE                                               
T10847                  IF WS-104-ACCT-GEN-LED-DR                       
T10847                    = WS-AR-BUD-GL-NO (WS-GL-SUB)                 
T10847                  AND WS-104-ACCT-GEN-LED-CR                      
T10847                    = WS-AR-CIA-GL-NO (WS-GL-SUB)                 
T10847                    SUBTRACT WS-104-AMT-POSTED                    
T10847                              FROM AR-AMT-BILLED-UNPAID           
T10847                                   AR-AMT-ORIG-ENTERED            
T10033***************************************************************           
T10033** (7) ANY OTHER TRANSACTIONS THAT DEBIT A RECEIVABLE ACCOUNT             
T10033**     WILL INCREASE THE ACCOUNT BALANCE                                  
T10033**     EXAMPLE: NON-BUDGET UTILITY CHARGES. CREDIT REVENUE;               
T10033**              DEBIT AR-UTE                                              
T10033**     EXAMPLE: MONTHLY BUDGET (OR CONTRACT) CHARGES                      
T10033**              DEBIT AR-BUD; CREDIT AR-BUD                               
T10033***************************************************************           
T10033                  ELSE                                            
T10033                   ADD WS-104-AMT-POSTED TO AR-AMT-BILLED-UNPAID  
T10033                   ADD WS-104-AMT-POSTED TO AR-AMT-ORIG-ENTERED   
T10779                   IF WS-104-ACCT-GEN-LED-CR =                    
T10779                     WS-CLR-CK-ISS-GL-NO (WS-GL-SUB)              
T10779                      MOVE 'Y' TO WS-REFUND-GIVEN                 
T10779                   END-IF                                         
C34216                  END-IF                                          
T10033                  END-IF                                          
T10847               END-IF                                             
      ***************************************************************           
      ** (8) SOME TRANSACTIONS NEITHER DEBIT NOR CREDIT A RECEIVABLE            
      **     ACCOUNT. THESE DO NOT EFFECT THE ACCOUNT BALANCE.                  
      **     EXAMPLE: CONTRACT INTEREST ACCRUALS                                
      ***************************************************************           
PCR305            WHEN WS-GL-PRIME NOT EQUAL WS-RECEIVABLE-ACCOUNT      
PCR305              AND WS-GL-PRIME1 NOT EQUAL WS-RECEIVABLE-ACCOUNT    
PCR305                CONTINUE                                          
      ***************************************************************           
      ** (9) TRANSACTIONS THAT CREDIT AR-CNT FROM THE DINT ACCOUNT              
      **     SHOULD NOT REDUCE THE BALANCE.                                     
      ***************************************************************           
                  WHEN WS-GL-PRIME NOT = WS-RECEIVABLE-ACCOUNT          
                        AND WS-GL-PRIME1  = WS-RECEIVABLE-ACCOUNT       
T12835             MOVE 'N' TO WS-CONTRACT-DEF-INT                      
T12835             IF WS-104-ACCT-GEN-LED-CR =                          
T12835                             WS-AR-CNT-GL-NO (WS-GL-SUB)          
T12835*             SEARCH THE CONTRACTS TO FIND THE DINT GL NUMBER             
T12835              SET WS-CNT-INDX TO 1                                
T12835              SEARCH WS-CONTRACT-DATA                             
T12835                 AT END CONTINUE                                  
T12835                 WHEN WS-ACCOUNT-NO-CT (WS-CNT-INDX) = ZERO       
T12835                    CONTINUE                                      
T12835                 WHEN WS-CNT-ITEM-ID-CT (WS-CNT-INDX) =           
T12835                          WS-104-ITEM-ID-NO AND                   
T12835                      WS-GL-ACCT-NO-DEF-INT-CT (WS-CNT-INDX) =    
T12835                          WS-104-ACCT-GEN-LED-DR                  
T12835                    SET CONTRACT-DEF-INT TO TRUE                  
T12835              END-SEARCH                                          
T12835             END-IF                                               
T12835             IF CONTRACT-DEF-INT                                  
T12835                CONTINUE                                          
      ***************************************************************           
      ** (10)THAT LEAVES TRANSACTIONS THAT CREDIT AR FROM A NON-AR              
      **     ACCOUNT. THESE REDUCE THE ACCOUNT BALANCE.                         
      **     EXAMPLE: DEPOSIT REFUND APPLIED TO A UTILITY BALANCE               
      **              CREDIT AR-UTE; DEBIT DEP-DEP                              
      ***************************************************************           
T12835             ELSE                                                 
                      IF WS-MST-SUB-ACCT-IND-AT = WS-SUB-ACCT           
                         SUBTRACT WS-104-AMT-POSTED                     
                             FROM AR-AMT-ORIG-ENTERED                   
T15798                   SUBTRACT WS-104-AMT-POSTED                     
T15798                       FROM AR-AMT-BILLED-UNPAID                  
T15798*                  MOVE 0 TO AR-AMT-BILLED-UNPAID                         
                      ELSE                                              
T13418*  WHEN SUB NOT ON CYCLE BILL DO NOT UPDATE AMT-BILLED-UNPAID.            
T17432*  OFF CYCLE TRANSFERS AND MASTERS (ON OR OFF CYCLE) HAVE ALREADY         
T17432*  UPDATED AMT-BILLED-UNPAID IN 102.  ALL OTHERS NEED TO DO IT.           
                         IF WS-OFF-CYCLE-ACCT-TRANS                     
T13418                   OR (WS-MST-SUB-ACCT-IND-AT = WS-MASTER-ACCT)   
T17432*                      AND NOT WS-ON-CYCLE-BILL)                          
                            SUBTRACT WS-104-AMT-POSTED                  
                                FROM AR-AMT-ORIG-ENTERED                
                         ELSE                                           
                            SUBTRACT WS-104-AMT-POSTED                  
T17432                          FROM AR-AMT-BILLED-UNPAID               
T17432                               AR-AMT-ORIG-ENTERED                
T17432*                         FROM AR-AMT-ORIG-ENTERED                        
                         END-IF                                         
                      END-IF                                            
T12835             END-IF                                               
              END-EVALUATE                                              
PAL           IF AR-AMT-BILLED-UNPAID NUMERIC                           
                 MOVE AR-AMT-BILLED-UNPAID TO WS-104-ACCT-END-AR-BAL    
PAL           ELSE                                                      
PAL              MOVE 0                    TO WS-104-ACCT-END-AR-BAL    
PAL           END-IF                                                    
              MOVE CJF00104 TO E-FWK03-USER-DEFINED-AREA                
              MOVE FIOWK03 TO WS-HOLD-WK03-DATA (WK03-INDX)             
PCR526        IF WS-ON-OFF-CYCLE-IND = SPACE AND WS-CONS-BILL-MAST      
PCR526          OR (NOT WS-ON-CYCLE-BILL AND WS-TRANSFER-GUARANTOR)     
PCR526          OR (NOT WS-ON-CYCLE-BILL AND WS-TRANSFER-GUARANTEE)     
PCR551          OR WS-OFF-CYCLE-ACCT-TRANS                              
PCR526*       MASTER ACCOUNTS THAT AREN'T ON-CYCLE                              
PCR526           MOVE E-FWK03-USER-DEFINED-AREA TO CJF00103             
PCR526           IF WS-HOLD-ACCT-NO = 0                                 
PCR526              MOVE WS-103-TRAN-ACCT-NO TO WS-HOLD-ACCT-NO         
PCR526           ELSE                                                   
PCR526              IF WS-103-TRAN-ACCT-NO = WS-HOLD-ACCT-NO            
PCR526                 CONTINUE                                         
PCR526              ELSE                                                
PCR526                 MOVE 'Y'  TO WS-MULTIPLE-SUBS-XFER               
PCR526*                INDICATES THAT THERE WAS MORE THAN 1 SUB                 
PCR526*                ACCOUNT TRANSFERRED                                      
PCR526              END-IF                                              
PCR526           END-IF                                                 
PCR526        END-IF                                                    
           END-PERFORM                                                  
T17777                                                                  
T17777     IF WS-HOLD-AMT-POSTED > 0                                    
T17777        ADD WS-HOLD-AMT-POSTED    TO AR-AMT-ORIG-ENTERED          
T17777     END-IF                                                       
      * VERIFY WITH ENDING VALUE IN AT                                          
           IF WS-104-ACCT-END-AR-BAL NOT NUMERIC                        
              MOVE 0 TO WS-104-ACCT-END-AR-BAL                          
           END-IF                                                       
           IF WS-TOTAL-AR-BALANCE-AT NOT NUMERIC                        
              MOVE 0 TO WS-TOTAL-AR-BALANCE-AT                          
           END-IF                                                       
C34001     IF AR-AMT-BILLED-UNPAID NOT = WS-TOTAL-AR-BALANCE-AT         
T17605* REMOVED WQ FOR TPR17605 - LEAVE AS DISPLAY                              
C34001        DISPLAY '**  WARNING: ACCOUNT ' WS-ACCOUNT-NO-AT          
C34001                ' OUT OF BALANCE '                                
C34001                '; AR CONTROL BALANCE ' WS-TOTAL-AR-BALANCE-AT    
C34001                '; BILLED UNPAID '      AR-AMT-BILLED-UNPAID      
C34001                '; JOURNAL BALANCE '    WS-104-ACCT-END-AR-BAL    
           END-IF                                                       
                                                                        
P00246*CHECK IF RATE PARAMETER OVERRIDE IS PRESENT FOR THE ACCOUNT TO           
P00246*INCLUDE SPECIAL COMMENTS IN BILLING TRANSACTION HISTORY.                 
P00246     SET RT-PARM-OVRD-NOT-PRESENT    TO TRUE                      
P00246     SET WS-ADJUSTMNT-INDEX          TO 1                         
P00246     SEARCH WS-BILL-ADJUSTMNT-DATA                                
P00246         AT END                                                   
P00246            CONTINUE                                              
P00246       WHEN WS-ADJ-TYPE-CD-BP(WS-ADJUSTMNT-INDEX) =               
P00246            WS-RT-PARM-OVRD                                       
P00246            SET RT-PARM-OVRD-PRESENT TO TRUE                      
P00246     END-SEARCH                                                   
P00246*                                                                         
T10033     MOVE ZERO TO WS-SEQ-NO                                       
C26679                  WS-TRAN-APPL-NUM                                
C26679                  WS-AR-TRN-APPL-NO                               
           PERFORM VARYING WK03-INDX FROM 1 BY 1                        
T13536               UNTIL WK03-INDX > 5000                             
                        OR WK03-INDX > WS-WK03-COUNT                    
              MOVE WS-HOLD-WK03-DATA (WK03-INDX) TO FIOWK03             
T10033        IF E-FWK03-JRNL-SORT-ID NOT = 'X'                         
                 MOVE E-FWK03-USER-DEFINED-AREA TO CJF00104             
                 MOVE AR-AMT-ORIG-ENTERED TO WS-104-AMOUNT-ENTERED      
C26679           IF E-FWK03-CODE-TERMINAL-TRAN EQUAL 'A112'             
P00453              OR 'A108'                                           
C26679              MOVE WS-HOLD-POSTED-AMT TO WS-104-AMT-POSTED        
C26679                                         WS-104-AMOUNT-ENTERED    
C26679           END-IF                                                 
                 MOVE CJF00104 TO E-FWK03-USER-DEFINED-AREA             
T10033           ADD 1 TO WS-SEQ-NO                                     
T10033           MOVE WS-SEQ-NO TO E-FWK03-JRNL-TRAN-APPL-NO            
T10033                             E-FWK03-SEQ-NO                       
C26679*                                                                         
C26679* TRAN-APPL-NO IS SET BACK TO 1 AFTER THE ADJ ROW IS WRITTEN. THIS        
C26679* IS DONE SO THAT IT WRITES THE BILLING SUMMARY ROW IN TRANS HIST.        
C26679           IF WS-SEQ-NO = 1 AND                                   
C26679              (E-FWK03-CODE-TERMINAL-TRAN = 'A112'                
P00453              OR 'A108')                                          
C26679              MOVE 0        TO WS-TRAN-APPL-NUM                   
C26679           ELSE                                                   
C26679              IF ADJ-TRANSACTION                                  
C26679                 MOVE 1     TO WS-TRAN-APPL-NUM                   
C26679                 MOVE WS-N  TO WS-ADJ-TRANSACTION                 
C26679              ELSE                                                
C26679                 ADD 1      TO WS-TRAN-APPL-NUM                   
C26679              END-IF                                              
C26679           END-IF                                                 
C26679*                                                                         
T19289           IF AR-AMT-ORIG-ENTERED < 0 AND                         
A02034                             ( WS-ON-OFF-CYCLE-IND = 'T'          
A02034                               OR WS-CONS-BILL-MAST)              
T19289              COMPUTE AR-AMT-ORIG-ENTERED =                       
T19289                      AR-AMT-ORIG-ENTERED * -1                    
T19289           END-IF                                                 
C26679*                                                                         
C26679* SINCE THE ADJ ROW IS ALREADY WRITTEN, STOPPING IT FROM WRITING          
C26679* AGAIN                                                                   
C26679           IF E-FWK03-CODE-TERMINAL-TRAN NOT EQUAL 'A112'         
P00453              AND 'A108'                                          
                    PERFORM 3600-UPDATE-TRAN-HIST THRU 3600-EXIT        
C26679           END-IF                                                 
                 IF RETRY-OFF                                           
                    PERFORM 8300-WRITE-WK03 THRU 8300-EXIT              
                 END-IF                                                 
T10033        END-IF                                                    
           END-PERFORM                                                  
                                                                        
T12486*    FOR NON-UTIL ACCTS WITH NO AR (BUT A PYMT), CREATE A                 
T12486*    HEADER RECORD ONLY                                                   
T12650*    FOR ANY ACCT GOING THROUGH BILLING FOR A BILL (NOT A MSTR            
T12650*      ON PARTITION 9 ONLY), CREATE A HEADER IF THERE ARE NO              
T12650*      DETAILS                                                            
T12650     IF WS-WK03-COUNT = 0 AND WS-ON-OFF-CYCLE-IND NOT = ' '       
A02034        AND NOT WS-OFF-CYCLE-ACCT-TRANS                           
T12486        PERFORM 8400-GET-CURRENT-TIMESTAMP THRU 8400-EXIT         
T12486        PERFORM 3615-CREATE-NON-UTIL-HDR THRU 3615-EXIT           
T12486     END-IF                                                       
           .                                                            
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26679 3300-CREATE-ADJ.                                                 
C26679*                                                                         
C26679     IF (WS-HOLD-WK03-DATA(WK03-INDX)(20:4)) = 'A112'             
P00453        OR 'A108'                                                 
C26679        MOVE WS-HOLD-WK03-DATA (WK03-INDX)    TO FIOWK03          
C26679        MOVE E-FWK03-USER-DEFINED-AREA        TO CJF00104         
C26679        ADD 1                                 TO WS-TRAN-APPL-NUM 
C26679        IF LS-DATABASE-UPDATES = 'YES'                            
C26679           PERFORM 8400-GET-CURRENT-TIMESTAMP THRU 8400-EXIT      
C26679           PERFORM 3630-CREATE-TRAN-HIST-HDR  THRU 3630-EXIT      
C26679        END-IF                                                    
C26679                                                                  
C26679        MOVE AR-ACCOUNT-NO                    TO AU-ACCOUNT-NO    
C26679        MOVE AR-TRANS-HIST-SEQ-NO          TO AU-TRANS-HIST-SEQ-NO
C26679        MOVE WS-TRAN-APPL-NUM                 TO AU-TRAN-APPL-NO  
C26679        MOVE WS-104-AR-AGE                    TO AU-CODE-AR-AGE   
C26679        MOVE WS-104-ACCT-GEN-LED-DR           TO AU-GL-ACCT-DEBIT 
C26679        MOVE WS-104-ACCT-GEN-LED-CR           TO AU-GL-ACCT-CREDIT
C26679        MOVE WS-104-AMT-POSTED                TO AU-AMT-POSTED    
C26679        MOVE WS-104-ITEM-ID-NO                TO AU-ITEM-ID       
C26679        MOVE SPACES                       TO AU-CODE-CONTRACT-TYPE
C26679        PERFORM 8320-INSERT-AR-TRN-HST-DET THRU 8320-EXIT         
C26679        MOVE WS-104-AMT-POSTED             TO WS-HOLD-POSTED-AMT  
C26679        MOVE 0                             TO WS-104-AMT-POSTED   
C26679        MOVE CJF00104                      TO                     
C26679                                      E-FWK03-USER-DEFINED-AREA   
C26679        MOVE FIOWK03                       TO                     
C26679                                      WS-HOLD-WK03-DATA(WK03-INDX)
C26679        SET ADJ-TRANSACTION                TO TRUE                
C26679        INITIALIZE DCLCSS-AR-TRANS-HIST                           
C26679                   DCLCSS-AR-TRN-HST-DET                          
C26679     END-IF.                                                      
C26679*                                                                         
C26679 3300-EXIT.                                                       
C26679     EXIT.                                                        
C26679*                                                                         
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *   3500-BUILD-WK-QUEUES                                                  
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       3500-BUILD-WK-QUEUES.                                            
           PERFORM VARYING WS-BILL-WQ-INDX FROM 1 BY 1                  
                   UNTIL WS-BILL-WQ-INDX > 50                           
                      OR WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX) = ZERO     
              IF WS-BILL-WQ-INDX = 1                                    
                 DISPLAY 'CONTENTS OF WQ FOR ACCOUNT '                  
                         WS-ACCOUNT-NO-AT                               
                         ':'                                            
              END-IF                                                    
                                                                        
ACT002        INITIALIZE CWS00077-FIELDS                                
ACT002        MOVE WS-ROUTE-CATEGORY-WF (WS-BILL-WQ-INDX)               
ACT002                                   TO WS-77-ROUTE-CATEGORY        
ACT002        MOVE WS-LOCAL-OFFICE-AT    TO WS-77-LOCAL-OFFICE          
ACT002        MOVE 'SYSTEM'              TO WS-77-USER-ID-ORIG          
ACT002        MOVE SPACES                TO WS-77-USER-ID-ASGN          
ACT002        MOVE SPACES                TO WS-77-RESP-AREA-ID          
ACT002        MOVE WS-CATEGORY-ID-WF (WS-BILL-WQ-INDX)                  
ACT002                                   TO WS-77-CATEGORY-ID           
ACT002        MOVE WS-ACCOUNT-NO-AT      TO WS-77-ACCOUNT-NO            
ACT002        MOVE WS-PREMISE-NO-AT      TO WS-77-PREMISE-NO            
ACT002        MOVE WS-CUSTOMER-NO-AT     TO WS-77-CUSTOMER-NO           
ACT002        MOVE ZERO                  TO WS-77-SERV-ORDER-NO         
ACT002        MOVE WS-COMMENTS-WF (WS-BILL-WQ-INDX)                     
ACT002                                   TO WS-77-COMMENTS              
ACT037        IF   WS-DATE-REQUIRED-WF (WS-BILL-WQ-INDX) > SPACES       
ACT037           MOVE WS-DATE-REQUIRED-WF (WS-BILL-WQ-INDX)             
ACT037             TO WS-77-DATE-REQUIRED                               
ACT037        ELSE                                                      
ACT002           MOVE LS-INPUT-DATE      TO WS-77-DATE-REQUIRED         
ACT037        END-IF                                                    
ACT002        MOVE SPACES                TO WS-77-DATE-CREATED          
ACT002        MOVE WS-PRIORITY-WF (WS-BILL-WQ-INDX)                     
ACT002                                   TO Ws-77-PRIORITY              
ACT002        IF   WS-CREATED-BY-WF (WS-BILL-WQ-INDX) > SPACES          
ACT002             MOVE WS-CREATED-BY-WF (WS-BILL-WQ-INDX)              
ACT002                                   TO WS-77-CREATED-BY            
ACT002        ELSE                                                      
ACT002             MOVE 'PCSCA100'       TO WS-77-CREATED-BY            
ACT002        END-IF                                                    
ACT002        MOVE ZERO                  TO WS-77-FREE-FORM-LEN         
ACT002        MOVE SPACES                TO WS-77-FREE-FORM-TXT         
ACT002        MOVE 0                     TO WS-77-ITEM-ID               
T16410*       IF EPP WAS DROPPED, DO NOT WRITE EPP WORK QUEUES                  
ACT002        IF EPP-DROP AND WS-77-CATEGORY-ID = +6                    
T16410              CONTINUE                                            
T16410        ELSE                                                      
                 DISPLAY '   ' WS-COMMENTS-WF (WS-BILL-WQ-INDX)         
ACT002           CALL SCSCB077 USING CWS00077-FIELDS,                   
ACT002                               ABEND-FILE,                        
ACT002                               RS-RETURN-CODE                     
ACT002           MOVE RS-RETURN-CODE TO WS-ACTIVE-RETURN-CODE           
ACT002                                                                  
ACT002           IF RS-RETURN-CODE NOT = 0                              
ACT002              MOVE PROGRAM-NAME               TO ABEND-PROGRAM    
ACT002              MOVE 'CALL'                     TO ABEND-FUNCTION   
ACT002              MOVE 'SCSCB077'                 TO TABLE-1          
ACT002              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1  
ACT002              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-2  
ACT002              MOVE 'SERV_ORDER_NO '           TO TABLE-ELEMENT-3  
ACT002              MOVE 'SQL RETURN CODE'          TO TABLE-ELEMENT-4  
ACT002              MOVE WS-77-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1
ACT002              MOVE WS-77-PREMISE-NO           TO HOSTVAR-ELEMENT-2
ACT002              MOVE WS-77-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-3
ACT002              MOVE WS-ACTIVE-RETURN-CODE      TO HOSTVAR-ELEMENT-4
ACT002              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT      
ACT002           END-IF                                                 
T16410        END-IF                                                    
           END-PERFORM                                                  
           .                                                            
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
       3600-UPDATE-TRAN-HIST.                                           
      ** THE 104 FORMAT WORKS FOR ALL FORMATS (FOR THIS ROUTINE)                
           MOVE E-FWK03-USER-DEFINED-AREA TO CJF00104                   
C26679*    IF E-FWK03-JRNL-TRAN-APPL-NO = 1                                     
C26679     IF WS-TRAN-APPL-NUM = 1                                      
KGDB          IF LS-DATABASE-UPDATES = 'YES'                            
                 PERFORM 8400-GET-CURRENT-TIMESTAMP THRU 8400-EXIT      
                 PERFORM 3610-CREATE-TRAN-HIST-HDR THRU 3610-EXIT       
KGDB          END-IF                                                    
           END-IF                                                       
                                                                        
PCR305      IF WS-104-REVENUE-MONTH IS NOT NUMERIC                      
PCR305         MOVE 0 TO WS-104-REVENUE-MONTH                           
PCR305      END-IF                                                      
                                                                        
           IF WS-104-REVENUE-MONTH = ZERO                               
              MOVE LS-CURR-REVENUE-MONTH   TO WS-104-REVENUE-MONTH      
              MOVE CJF00104 TO E-FWK03-USER-DEFINED-AREA                
              MOVE FIOWK03 TO WS-HOLD-WK03-DATA (WK03-INDX)             
           END-IF                                                       
                                                                        
T10808     IF WS-104-ACCT-GEN-LED-DR = WS-AR-CNT-GL-NO (WS-GL-SUB)      
T10808      OR WS-104-ACCT-GEN-LED-CR = WS-AR-CNT-GL-NO (WS-GL-SUB)     
T10808       PERFORM 3620-FIND-CONTRACT-TYPE  THRU 3620-EXIT            
T10808     ELSE                                                         
T10808       MOVE SPACES                  TO AU-CODE-CONTRACT-TYPE      
T10808     END-IF                                                       
                                                                        
C26679     ADD 1                          TO WS-AR-TRN-APPL-NO          
           MOVE AR-ACCOUNT-NO             TO AU-ACCOUNT-NO              
           MOVE AR-TRANS-HIST-SEQ-NO      TO AU-TRANS-HIST-SEQ-NO       
C26679*    MOVE E-FWK03-JRNL-TRAN-APPL-NO TO AU-TRAN-APPL-NO                    
C26679     MOVE WS-AR-TRN-APPL-NO         TO AU-TRAN-APPL-NO            
           MOVE WS-104-AR-AGE             TO AU-CODE-AR-AGE             
           MOVE WS-104-ACCT-GEN-LED-DR    TO AU-GL-ACCT-DEBIT           
           MOVE WS-104-ACCT-GEN-LED-CR    TO AU-GL-ACCT-CREDIT          
           MOVE WS-104-AMT-POSTED         TO AU-AMT-POSTED              
           MOVE WS-104-ITEM-ID-NO         TO AU-ITEM-ID                 
           PERFORM 8320-INSERT-AR-TRN-HST-DET THRU 8320-EXIT.           
       3600-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       3610-CREATE-TRAN-HIST-HDR.                                       
           MOVE WS-PGRMNAME               TO AR-APPL-PROGRAM-ID         
PCR526     MOVE SPACES                    TO AR-TRAN-COMMENT-TEXT       
           MOVE E-FWK03-ACCT-NO           TO AR-ACCOUNT-NO.             
           MOVE E-FWK03-DATE-LAST-ACTION  TO AR-DATE-TRANS              
      *                                      AR-TRAN-COMMENT-TEXT.              
PCR526     MOVE E-FWK03-DATE-LAST-ACTION (1:4)                          
PCR526                             TO AR-TRAN-COMMENT-TEXT (7:4).       
PCR526     MOVE E-FWK03-DATE-LAST-ACTION (6:2)                          
PCR526                             TO AR-TRAN-COMMENT-TEXT (1:2).       
PCR526     MOVE E-FWK03-DATE-LAST-ACTION (9:2)                          
PCR526                             TO AR-TRAN-COMMENT-TEXT (4:2).       
PCR526     MOVE '/'                TO AR-TRAN-COMMENT-TEXT (3:1)        
PCR526                                AR-TRAN-COMMENT-TEXT (6:1).       
T10789     IF WS-ON-CYCLE-BILL                                          
              MOVE 'BILLING'                                            
                   TO AR-TRAN-COMMENT-TEXT (12:7)                       
              MOVE +18                    TO AR-TRAN-COMMENT-LEN        
PCR526        IF WS-MST-SUB-ACCT-IND-AT = WS-SUB-ACCT                   
PCR526           MOVE WS-ACCT-XFER-TO-AT    TO WS-ACCT-NO-DISPLAY       
PCR526           MOVE WS-ACCT-NO-DISPLAY    TO WS-MST-ACCT-NO           
PCR526           MOVE WS-SUB-COMMENT TO AR-TRAN-COMMENT-TEXT (19:46)    
PCR526           MOVE +64                 TO AR-TRAN-COMMENT-LEN        
PCR526        END-IF                                                    
PCR526        IF WS-TRANSFER-GUARANTOR                                  
PCR526           MOVE WS-ACCT-XFER-FROM-LST-AT TO WS-GUARANTEE-ACCT     
PCR526           MOVE WS-GUARANTOR-COMMENT                              
PCR526                TO AR-TRAN-COMMENT-TEXT (19:65)                   
PCR526           MOVE +83 TO AR-TRAN-COMMENT-LEN                        
PCR551        ELSE                                                      
PCR526        IF WS-TRANSFER-GUARANTEE                                  
PCR526           MOVE WS-ACCT-XFER-TO-AT TO WS-GUARANTOR-ACCT           
A02036                                      WS-GUARANTOR-ACCT1          
PCR526           MOVE WS-GUARANTEE-COMMENT                              
PCR526                      TO AR-TRAN-COMMENT-TEXT (19:63)             
PCR526           MOVE +81 TO AR-TRAN-COMMENT-LEN                        
PCR551        ELSE                                                      
PCR551          IF WS-ACCT-XFER-TO-AT > ZERO AND                        
PCR551             WS-AR-XFER-IND-AT  = 'Y'  AND                        
PCR551             WS-MST-SUB-ACCT-IND-AT = SPACE AND                   
T19317             TRANS-SUCCESSFUL                                     
PCR551           MOVE WS-ACCT-XFER-TO-AT TO WS-XFER-TO-ACCT-NO          
PCR551           MOVE WS-XFER-FROM-COMMENT                              
T13499                TO AR-TRAN-COMMENT-TEXT (19:26)                   
T13499           MOVE +44 TO AR-TRAN-COMMENT-LEN                        
PCR551          END-IF                                                  
PCR551        END-IF                                                    
PCR526        END-IF                                                    
T10789     ELSE                                                         
PCR551        IF WS-OFF-CYCLE-ACCT-TRANS                                
PCR551           IF MULTIPLE-SUBS-XFER                                  
PCR551              MOVE 'MULTIPLE     ' TO WS-XFER-FR-ACCT-NO          
PCR551           ELSE                                                   
PCR551              MOVE WS-HOLD-ACCT-NO    TO WS-XFER-FR-ACCT-NO       
PCR551           END-IF                                                 
T13499           MOVE WS-XFER-TO-COMMENT TO AR-TRAN-COMMENT-TEXT (1:27) 
T13499           MOVE +27                TO AR-TRAN-COMMENT-LEN         
PCR551        END-IF                                                    
PCR526        IF WS-CONS-BILL-MAST                                      
PCR526           IF MULTIPLE-SUBS-XFER                                  
PCR526              MOVE 'MULTIPLE        ' TO WS-SUB-ACCT-NO           
PCR526           ELSE                                                   
PCR526              MOVE WS-HOLD-ACCT-NO    TO WS-ACCT-NO-DISPLAY       
PCR526              MOVE WS-ACCT-NO-DISPLAY TO WS-MSTSUB-ACCT-NO        
PCR526              MOVE WS-MSTSUB-ACCT-NO  TO WS-SUB-ACCT-NO           
PCR526           END-IF                                                 
PCR526           MOVE WS-MASTER-COMMENT TO AR-TRAN-COMMENT-TEXT (1:43)  
PCR526           MOVE +43               TO AR-TRAN-COMMENT-LEN          
PCR526        END-IF                                                    
T12429        IF WS-MST-SUB-ACCT-IND-AT = WS-SUB-ACCT                   
T12429           MOVE 'BILLING'                                         
T12429                TO AR-TRAN-COMMENT-TEXT (12:7)                    
T12429           MOVE WS-ACCT-XFER-TO-AT    TO WS-ACCT-NO-DISPLAY       
T12429           MOVE WS-ACCT-NO-DISPLAY    TO WS-MST-ACCT-NO           
T12429           MOVE WS-SUB-COMMENT TO AR-TRAN-COMMENT-TEXT (19:46)    
T12429           MOVE +64                 TO AR-TRAN-COMMENT-LEN        
T12429        END-IF                                                    
PCR526        IF WS-TRANSFER-GUARANTOR                                  
PCR526           IF MULTIPLE-SUBS-XFER                                  
PCR526              MOVE 'MULTIPLE    ' TO WS-GUARANTEE-ACCT            
PCR526           ELSE                                                   
PCR526              MOVE WS-HOLD-ACCT-NO TO WS-GUARANTEE-ACCT           
PCR526           END-IF                                                 
PCR526           MOVE WS-GUARANTOR-COMMENT                              
PCR526                TO AR-TRAN-COMMENT-TEXT (1:65)                    
PCR526           MOVE +65 TO AR-TRAN-COMMENT-LEN                        
T13532        ELSE                                                      
PCR526        IF WS-TRANSFER-GUARANTEE                                  
PCR526           MOVE WS-HOLD-ACCT-NO TO WS-GUARANTOR-ACCT              
a02036                                   WS-GUARANTOR-ACCT1             
PCR526           MOVE WS-GUARANTEE-COMMENT                              
PCR526                TO AR-TRAN-COMMENT-TEXT (1:63)                    
PCR526           MOVE +63 TO AR-TRAN-COMMENT-LEN                        
T13532        ELSE                                                      
T13532*         THIS IS POSSIBLE FOR FINAL XFER ACCOUNTS                        
T13532          IF WS-ACCT-XFER-TO-AT > ZERO AND                        
T13532             WS-AR-XFER-IND-AT  = 'Y'  AND                        
T13532             WS-MST-SUB-ACCT-IND-AT = SPACE AND                   
T19317             TRANS-SUCCESSFUL                                     
T13532           MOVE WS-ACCT-XFER-TO-AT TO WS-XFER-TO-ACCT-NO          
T13532           MOVE WS-XFER-FROM-COMMENT                              
T13532                TO AR-TRAN-COMMENT-TEXT (1:26)                    
T13532           MOVE +26 TO AR-TRAN-COMMENT-LEN                        
T13532          END-IF                                                  
PCR526        END-IF                                                    
           END-IF
           END-IF.                                                      
A02036***ACT0091 - START                                                        
A02036     IF WS-TRANSFER-GUARANTEE                                     
A02036           MOVE ZERO               TO WS-COUNT1                   
A02036           MOVE WS-GUARANTOR-ACCT1 TO WS-HOLD-ACCT-NO1            
A02036           PERFORM 7920-GET-GUARANTOR-COUNT THRU 7920-EXIT        
A02036           IF WS-COUNT1 > 1                                       
A02036              PERFORM 7930-GET-GUARANTOR-ACCOUNT THRU 7930-EXIT   
A02036              MOVE GU-GUARNTR-ACCT-NO TO WS-GUARANTOR-ACCT2       
A02036              MOVE WS-GUARANTEE-COMMENT1                          
A02036                 TO AR-TRAN-COMMENT-TEXT (1:77)                   
A02036              MOVE +77 TO AR-TRAN-COMMENT-LEN                     
A02036           END-IF                                                 
A02036     END-IF                                                       
A02036***ACT0091 - END                                                          
P00246*                                                                         
P00246     IF RT-PARM-OVRD-PRESENT                                      
P00246        COMPUTE AR-TRAN-COMMENT-LEN = AR-TRAN-COMMENT-LEN + 1     
P00246        MOVE ' Proration Code Overridden.'                        
P00246          TO AR-TRAN-COMMENT-TEXT (AR-TRAN-COMMENT-LEN:27)        
P00246        COMPUTE AR-TRAN-COMMENT-LEN = AR-TRAN-COMMENT-LEN + 27    
P00246     END-IF                                                       
P00246*                                                                         
T10424     IF WS-OFF-CYCLE-ACCT-TRANS                                   
T10424       OR (WS-TRANSFER-GUARANTOR AND NOT WS-ON-CYCLE-BILL)        
T10424       OR (WS-TRANSFER-GUARANTEE AND NOT WS-ON-CYCLE-BILL)        
PCR526       OR (WS-CONS-BILL-MAST AND NOT WS-ON-CYCLE-BILL)            
T10424        MOVE WS-TRANSFER TO AR-CODE-TRAN-TYPE                     
T10424     ELSE                                                         
              MOVE E-FWK03-CODE-ENTRY-SOURCE TO AR-CODE-TRAN-TYPE       
           END-IF.                                                      
T10850     IF (WS-TRANSFER-GUARANTOR AND WS-ON-CYCLE-BILL)              
T10850       OR (WS-TRANSFER-GUARANTEE AND WS-ON-CYCLE-BILL)            
T10850        MOVE WS-PGRMNAME-C          TO AR-APPL-PROGRAM-ID         
T10850     END-IF.                                                      
T10789     IF (WS-TRANSFER-GUARANTOR AND NOT WS-ON-CYCLE-BILL)          
T10789       OR (WS-TRANSFER-GUARANTEE AND NOT WS-ON-CYCLE-BILL)        
T10789        MOVE WS-PGRMNAME-D          TO AR-APPL-PROGRAM-ID         
T10789     END-IF.                                                      
T10622     IF EPP-DROP                                                  
T10622        MOVE WS-PGRMNAME-A          TO AR-APPL-PROGRAM-ID         
T10622     END-IF.                                                      
T10779     IF REFUND-GIVEN                                              
T10779        MOVE WS-PGRMNAME-B          TO AR-APPL-PROGRAM-ID         
T10779     END-IF.                                                      
PCR526     IF WS-OFF-CYCLE-FINAL AND WS-TOTAL-AR-BALANCE-AT > 0         
PCR526        MOVE WS-PGRMNAME-F          TO AR-APPL-PROGRAM-ID         
PCR526     END-IF.                                                      
PCR526     IF WS-MST-SUB-ACCT-IND-AT = WS-SUB-ACCT                      
PCR551        OR (WS-ACCT-XFER-TO-AT > ZERO AND                         
PCR551            WS-AR-XFER-IND-AT = 'Y'   AND                         
PCR551            WS-MST-SUB-ACCT-IND-AT = SPACE)                       
T19317        IF TRANS-SUCCESSFUL                                       
PCR526           MOVE WS-PGRMNAME-E          TO AR-APPL-PROGRAM-ID      
T19317        ELSE                                                      
A02036**ACT0068 -START                                                          
A02036           IF AT-CODE-ACCT-STAT = 'B'                             
T19317              MOVE WS-PGRMNAME-F          TO AR-APPL-PROGRAM-ID   
A02036           ELSE                                                   
A02036              MOVE WS-PGRMNAME            TO AR-APPL-PROGRAM-ID   
A02036           END-IF                                                 
A02036**ACT0068 -END                                                            
PCR526     END-IF
           END-IF.                                                      
PCR526     IF WS-CONS-BILL-MAST AND NOT WS-ON-CYCLE-BILL                
PCR526        MOVE WS-PGRMNAME-G          TO AR-APPL-PROGRAM-ID         
PCR526     END-IF.                                                      
PCR551     IF WS-OFF-CYCLE-ACCT-TRANS                                   
PCR551        MOVE WS-PGRMNAME-H          TO AR-APPL-PROGRAM-ID         
PCR551     END-IF.                                                      
T17778     IF WS-SHARE-STATUS-CD-PJ = WS-I AND                          
T18208        STATUS-CD-PJS-SAVE    = WS-ACTIVE AND                     
T17778        WS-ACCT-TERM-DT-PJ    = LS-INPUT-DATE                     
T17778           MOVE WS-PGRMNAME-I       TO AR-APPL-PROGRAM-ID         
T17778     END-IF.                                                      
T17871     IF WS-OFF-CYCLE-REBILL                                       
T17871           MOVE WS-PGRMNAME-R       TO AR-APPL-PROGRAM-ID         
T17871     END-IF.                                                      
                                                                        
ACT255     IF NOT WS-OFF-CYCLE-ACCT-TRANS                               
I01959      IF WS-COGEN-AR-XFER-IND = 'Y'  AND                          
I01959        WS-XFER-TO-ASSIGNEE-ACCT    NOT EQUAL ZEROES              
I01959        IF WS-OFF-CYCLE-REBILL                                    
I01959           MOVE WS-PGRMNAME-K       TO AR-APPL-PROGRAM-ID         
I01959        ELSE                                                      
I01959           MOVE WS-PGRMNAME-J       TO AR-APPL-PROGRAM-ID         
I01959        END-IF                                                    
I01959        MOVE WS-XFER-TO-ASSIGNEE-ACCT                             
I01959                                    TO WS-SAVE-XFER-ASGNE-ACCT    
I01959                                       WS-ACCT-NO-DISPLAY         
I01959        MOVE WS-ACCT-NO-DISPLAY     TO WS-ASSIGNEE-ACCOUNT        
I01959        PERFORM 7940-GET-ASSIGNEE-NAME THRU 7940-EXIT             
I01959        MOVE WS-XFER-TO-ASSIGNEE-COMMENT                          
I01959             TO AR-TRAN-COMMENT-TEXT(19:117)                      
I01959        MOVE +136                   TO AR-TRAN-COMMENT-LEN        
I01959      END-IF                                                      
ACT255     END-IF.                                                      
                                                                        
ACT108     IF WS-PROCESS-REFUND                                         
ACT108        MOVE 'R'                    TO AR-CODE-TRAN-TYPE          
ACT108        MOVE WS-PGRMNAME-S          TO AR-APPL-PROGRAM-ID         
ACT108     END-IF                                                       
           MOVE WS-SYSTEM                 TO AR-USER-ID                 
FCS        MOVE WS-COMPANY-NO-AT          TO AR-COMPANY-NO              
FCS        MOVE WS-CASH-COMPANY-NO        TO AR-CASH-COMPANY-NO         
FCS        MOVE WS-LOCAL-OFFICE-AT        TO AR-CASH-LOCAL-OFFICE       
FCS        MOVE WS-CASH-REPORT-NO         TO AR-CASH-REPORT-NO          
FCS        MOVE WS-INPUT-DATE             TO AR-DATE-CASH-REPORT        
FCS        MOVE WS-CASH-DRAWER-ID         TO AR-CASH-DRAWER-ID          
           PERFORM 8310-INSERT-AR-TRAN-HIST THRU 8310-EXIT.             
      *                                                                         
       3610-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
T12486 3615-CREATE-NON-UTIL-HDR.                                        
T12486     MOVE WS-PGRMNAME               TO AR-APPL-PROGRAM-ID         
T12486     MOVE SPACES                    TO AR-TRAN-COMMENT-TEXT       
T12486     MOVE WS-ACCOUNT-NO-AT          TO AR-ACCOUNT-NO.             
T12486     MOVE LS-INPUT-DATE             TO AR-DATE-TRANS              
T12486     MOVE LS-INPUT-DATE (1:4) TO AR-TRAN-COMMENT-TEXT (7:4).      
T12486     MOVE LS-INPUT-DATE (6:2) TO AR-TRAN-COMMENT-TEXT (1:2).      
T12486     MOVE LS-INPUT-DATE (9:2) TO AR-TRAN-COMMENT-TEXT (4:2).      
T12486     MOVE '/'                 TO AR-TRAN-COMMENT-TEXT (3:1)       
T12486                                 AR-TRAN-COMMENT-TEXT (6:1).      
T12486     IF WS-ON-CYCLE-BILL                                          
T12486        MOVE 'BILLING'                                            
T12486             TO AR-TRAN-COMMENT-TEXT (12:7)                       
T12486        MOVE +18                    TO AR-TRAN-COMMENT-LEN        
T12486     END-IF.                                                      
P00599     IF WS-ACCT-SUPPRESS-IND = 'Z'                                
T31442        MOVE ' ; ZERO BILL-NOT MAILED'                            
T31442             TO AR-TRAN-COMMENT-TEXT (19:23)                      
T31442        MOVE +41                    TO AR-TRAN-COMMENT-LEN        
T31442     END-IF.                                                      
P00246*                                                                         
P00246     IF RT-PARM-OVRD-PRESENT                                      
P00246        COMPUTE AR-TRAN-COMMENT-LEN = AR-TRAN-COMMENT-LEN + 1     
P00246        MOVE ' Proration Code Overridden.'                        
P00246          TO AR-TRAN-COMMENT-TEXT (AR-TRAN-COMMENT-LEN:27)        
P00246        COMPUTE AR-TRAN-COMMENT-LEN = AR-TRAN-COMMENT-LEN + 27    
P00246     END-IF.                                                      
P00246*                                                                         
T12486     MOVE 'B'                       TO AR-CODE-TRAN-TYPE          
T12486     MOVE WS-SYSTEM                 TO AR-USER-ID                 
T12486     MOVE WS-COMPANY-NO-AT          TO AR-COMPANY-NO              
T12486     MOVE WS-CASH-COMPANY-NO        TO AR-CASH-COMPANY-NO         
T12486     MOVE WS-LOCAL-OFFICE-AT        TO AR-CASH-LOCAL-OFFICE       
T12486     MOVE WS-CASH-REPORT-NO         TO AR-CASH-REPORT-NO          
T12486     MOVE WS-INPUT-DATE             TO AR-DATE-CASH-REPORT        
T12486     MOVE WS-CASH-DRAWER-ID         TO AR-CASH-DRAWER-ID          
T12486     PERFORM 8310-INSERT-AR-TRAN-HIST THRU 8310-EXIT.             
      *                                                                         
T12486 3615-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
T10808 3620-FIND-CONTRACT-TYPE.                                         
T10808     SET WS-CNT-INDX TO 1.                                        
T10808     SEARCH WS-CONTRACT-DATA                                      
T10808        AT END                                                    
T10808           MOVE SPACES  TO AU-CODE-CONTRACT-TYPE                  
T10808        WHEN WS-ACCOUNT-NO-CT (WS-CNT-INDX) = AR-ACCOUNT-NO       
T10808         AND WS-CNT-ITEM-ID-CT (WS-CNT-INDX) = WS-104-ITEM-ID-NO  
T10808           MOVE WS-CODE-CONTRACT-TYPE-CT (WS-CNT-INDX) TO         
T10808                AU-CODE-CONTRACT-TYPE                             
T10808     END-SEARCH.                                                  
T10808 3620-EXIT.                                                       
T10808     EXIT.                                                        
C26679*                                                                         
C26679 3630-CREATE-TRAN-HIST-HDR.                                       
C34216***CHECKING POSITION 120 FOR ADJS IN CJF00104 BECAUSE **********          
C34216***'ADJS' WAS MOVED TO WS-101-FUNCTION-CODE IN CJF00101 IN******          
C34216****SCSCA112 BUT COPYBOOKS ARE NOT THE SAME LENGTH *************          
P00453     EVALUATE (WS-HOLD-WK03-DATA(WK03-INDX)(20:4))                
P00453       WHEN 'A112'                                                
P00453         IF CJF00104(120:4) = 'ADJS'                              
P00453            MOVE 'SCSCA112B'         TO AR-APPL-PROGRAM-ID        
P00453            MOVE 'BBP ADJ TO PREV BILLED AMT'                     
P00453                                     TO AR-TRAN-COMMENT-TEXT      
P00453            MOVE SPACES              TO WS-104-FUNCTION-CODE      
P00453         ELSE                                                     
P00453            MOVE 'SCSCA112A'         TO AR-APPL-PROGRAM-ID        
P00453            MOVE 'PREV BBP BILL ADJUSTMENT'                       
P00453                                     TO AR-TRAN-COMMENT-TEXT      
P00453         END-IF                                                   
P00453         MOVE +24                    TO AR-TRAN-COMMENT-LEN       
P00453         MOVE SPACES                 TO AR-RECORD-ONLY-FL         
P00453       WHEN 'A108'                                                
P00453*        POPULATED IN SCSCA108 FOR PRP ADJUSTMENT                         
P00453         MOVE 'Y'                    TO WS-PRP-ADJ-FLG            
P00453                                        AR-RECORD-ONLY-FL         
P00453         MOVE 'SCSCA108B'            TO AR-APPL-PROGRAM-ID        
P00453         MOVE 'PREVIOUS BILL ADJUSTED TO ACTUAL CHARGES'          
P00453                                     TO AR-TRAN-COMMENT-TEXT      
P00453         MOVE +40                    TO AR-TRAN-COMMENT-LEN       
P00453       WHEN OTHER                                                 
P00453            GO TO 3630-EXIT                                       
P00453     END-EVALUATE.                                                
C26679     MOVE SPACES                     TO AR-RESP-AREA-ID.          
C26679     MOVE SPACES                     TO AR-PYMT-FACILITY-CD       
C26679     MOVE WS-SYSTEM                  TO AR-USER-ID.               
C26679     MOVE WS-104-DETAIL-END-AR-BAL   TO AR-AMT-ORIG-ENTERED       
C34216                                        WS-HOLD-EPP-ADJ-AMT.      
C26679     MOVE WS-104-ACCT-END-AR-BAL     TO AR-AMT-BILLED-UNPAID.     
C26679     MOVE E-FWK03-ACCT-NO            TO AR-ACCOUNT-NO.            
C26679     MOVE E-FWK03-DATE-LAST-ACTION   TO AR-DATE-TRANS.            
C26679     MOVE WS-A                       TO AR-CODE-TRAN-TYPE.        
C26679     MOVE WS-COMPANY-NO-AT           TO AR-COMPANY-NO.            
C26679     MOVE WS-CASH-COMPANY-NO         TO AR-CASH-COMPANY-NO.       
C26679     MOVE WS-LOCAL-OFFICE-AT         TO AR-CASH-LOCAL-OFFICE.     
C26679     MOVE WS-CASH-REPORT-NO          TO AR-CASH-REPORT-NO.        
C26679     MOVE WS-INPUT-DATE              TO AR-DATE-CASH-REPORT.      
C26679     MOVE WS-CASH-DRAWER-ID          TO AR-CASH-DRAWER-ID.        
C26679     PERFORM 8310-INSERT-AR-TRAN-HIST THRU 8310-EXIT.             
C26679*                                                                         
C26679 3630-EXIT.                                                       
C26679     EXIT.                                                        
C26679*                                                                         
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
P00166 3700-LOAD-CORR-MAIL-STAT.                                        
P00166                                                                  
P00166     MOVE WS-FDB07-ACCT-NO           TO MW-ACCOUNT-NO.            
P00166     MOVE WS-FDB07-BARCODE-UNIQUE-ID TO MW-BARCODE-UNIQUE-ID.     
P00166     MOVE WS-TRACKING-STATUS-CD      TO MW-TRACKING-STATUS-CD     
P00166                                        WS-TRACKING-STATUS-CD-MW. 
P00166     MOVE WS-SYSTEM                  TO MW-USER-ID.               
P00166     MOVE PROGRAM-NAME               TO MW-APPL-PROGRAM-ID        
P00166                                        WS-APPL-PROGRAM-ID-MW.    
P00166     PERFORM 8330-UPDATE-CORR-MAIL-STAT THRU 8330-EXIT.           
P00166     MOVE SPACES TO MW-TRACKING-STATUS-CD.                        
P00166 3700-EXIT.                                                       
P00166     EXIT.                                                        
P00166*                                                                         
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       4000-WRITE-SUMMARY-FILES.                                        
      *                                                                         
           MOVE ZERO TO E-FWK02-SORT-SUM-FLD                            
           MOVE WS-PART-NO TO E-FWK02-BE-DB-PART-ID                     
           MOVE WS-LOCAL-OFFICE-REVENUE-TABLE TO E-FWK02-DATA.          
           WRITE FIOWK02                                                
      *                                                                         
           IF FWK02-SUCCESSFUL                                          
              ADD 1 TO WS-RESTART-FCSWK02-REC-CNTR                      
           ELSE                                                         
              DISPLAY '4000-ERROR ON FCSWK02 WRITE.  STATUS IS '        
                      WS-FWK02-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
                                                                        
           PERFORM VARYING WS-LO-REV-INDX FROM 1 BY 1                   
                   UNTIL WS-LO-REV-INDX > 100                           
              ADD WS-LO-TOT-NEW-REVENUE (WS-LO-REV-INDX)                
                 TO WS-WK02-SUMM-TOTAL                                  
           END-PERFORM.                                                 
T14563     MOVE WS-WK02-SUMM-TOTAL TO WS-RESTART-FCSWK02-SUM-TOTL.      
      *                                                                         
DC         MOVE ZERO TO E-FWK04-SORT-SUM-FLD                            
DC         MOVE WS-PART-NO TO E-FWK04-BE-DB-PART-ID                     
DC         MOVE WS-WNA-REVENUE-SUMMARY-TABLE TO E-FWK04-DATA.           
DC         WRITE FIOWK04                                                
DC    *                                                                         
DC         IF FWK04-SUCCESSFUL                                          
DC            ADD 1 TO WS-RESTART-FCSWK04-REC-CNTR                      
DC         ELSE                                                         
DC            DISPLAY '4000-ERROR ON FCSWK04 WRITE.  STATUS IS '        
DC                    WS-FWK04-STATUS                                   
DC            PERFORM 9900-ABEND         THRU 9900-EXIT                 
DC         END-IF.                                                      
DC                                                                      
DC         PERFORM VARYING WS-WNA-REV-SUM-INDX FROM 1 BY 1              
DC                 UNTIL WS-WNA-REV-SUM-INDX > 25                       
DC            ADD WS-TOTAL-WNA-REV (WS-WNA-REV-SUM-INDX)                
DC               TO WS-WK04-SUMM-TOTAL                                  
DC         END-PERFORM.                                                 
T14563     MOVE WS-WK04-SUMM-TOTAL TO WS-RESTART-FCSWK04-SUM-TOTL.      
      *                                                                         
           PERFORM VARYING WS-LOCAL-INDEX FROM 1 BY 1                   
                     UNTIL WS-LOCAL-INDEX > 100                         
                        OR WS-LO-ACCUM-LOCAL-OFFICE (WS-LOCAL-INDEX)    
                           = ZERO                                       
                        AND WS-LO-ACCUM-COMPANY-NO (WS-LOCAL-INDEX)     
                           = SPACES                                     
              MOVE ZERO TO E-FWK06-SORT-SUM-FLD                         
              MOVE WS-PART-NO TO E-FWK06-DB-PART                        
              MOVE WS-LO-ACCUM-COMPANY-NO (WS-LOCAL-INDEX)              
                TO E-FWK06-COMPANY-NO                                   
              MOVE WS-LO-ACCUM-LOCAL-OFFICE (WS-LOCAL-INDEX)            
                TO E-FWK06-LOCAL-OFFICE                                 
              MOVE WS-LO-ACCUM-CONTROL (WS-LOCAL-INDEX)                 
                TO E-FWK06-LO-CONTROL                                   
              MOVE WS-LO-ACCUM-DATA (WS-LOCAL-INDEX)                    
                TO E-FWK06-LO-ACCUMS                                    
              WRITE FIOWK06                                             
      *                                                                         
              IF FWK06-SUCCESSFUL                                       
                 ADD 1 TO WS-RESTART-FCSWK06-REC-CNTR                   
              ELSE                                                      
                 DISPLAY '4000-ERROR ON FCSWK06 WRITE.  STATUS IS '     
                         WS-FWK06-STATUS                                
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
              END-IF                                                    
           END-PERFORM.                                                 
       4000-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *    5001-PROCESS-BEGIN-REC                                    **         
      *                                                              **         
      *    THIS PARAGRAPH DOES AN INITIAL READ TO THE DB07 FILE AND  **         
      *    CHECKS FOR A BEGINNING RECORD. WHEN FOUND THE DATE ON     **         
      *    THE BEGIN RECORD IS COMPARED TO THE RUN DATE OBTAINED     **         
      *    FROM THE JOBS TABLE TO ENSURE WE ARE PROCESSING WITH      **         
      *    THE CORRECT FILE.                                         **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
       5001-PROCESS-BEGIN-REC.                                          
           PERFORM 7000-READ-FCSDB07 THRU 7000-EXIT.                    
                                                                        
           EVALUATE TRUE                                                
              WHEN NO-MORE-DATA                                         
                 DISPLAY '**    PCSCA100 PROCESSING ERROR   **'         
                 DISPLAY '**      FCSDB07 FILE IS EMPTY     **'         
                 DISPLAY '**      PROCESSING TERMINATED     **'         
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
                                                                        
              WHEN E-FDB07-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FDB07-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '**     PCSCA100 PROCESSING ERROR      **'  
                    DISPLAY '** FCSDB07 CREATE DATE NOT = RUN DATE **'  
T31962              DISPLAY '** DATE ON FILE: ' E-FDB07-CREATE-DATE-BREC
T31962              DISPLAY '** RUN DATE    : ' WS-INPUT-DATE           
                    DISPLAY '**       PROCESSING TERMINATED        **'  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
                                                                        
                 IF E-FDB07-DB-PART-BREC  GREATER THAN ZERO             
                     MOVE  E-FDB07-DB-PART-BREC  TO WS-PART-NO          
      **************  BEGIN - CML 23301  ***                                    
      *       MOVED TO 7000- PARA DUE TO MULTI COMPANY CHANGES ***              
PCR473**             IF E-FDB07-DB-PART-BREC = 9                                
PCR473**                MOVE WS-RR-WQ-BILLING9 TO WS-EXCEPTION-LIMIT            
PCR473**             ELSE                                                       
PCR473**                MOVE WS-RR-WQ-BILLING  TO WS-EXCEPTION-LIMIT            
PCR473**             END-IF                                                     
      **************  END   - CML 23301  ***                                    
                 ELSE                                                   
                    DISPLAY '**     PCSCA100 PROCESSING ERROR      **'  
                    DISPLAY '** FCSDB07 PART NO NOT GREATER THAN 0 **'  
                    DISPLAY '**       PROCESSING TERMINATED        **'  
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
                 END-IF                                                 
                                                                        
                 SUBTRACT 1 FROM WS-FCSDB07-REC-CNTR                    
                 SET WS-BEGIN-RECS-PROCESSED TO TRUE                    
                                                                        
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 SET WS-START-INPUT-DATA TO TRUE                        
                                                                        
              WHEN OTHER                                                
                 DISPLAY '**    PCSCA100 PROCESSING ERROR   **'         
                 DISPLAY '** FIRST RECORD IS NOT A CNTL REC **'         
                 DISPLAY '**      PROCESSING TERMINATED     **'         
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
           END-EVALUATE.                                                
                                                                        
       5001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-WRITE-BEGIN-CONTROLS.                                       
           MOVE WS-Y           TO WS-CNTRL-REC-FLAG.                    
           MOVE LOW-VALUES     TO E-FBE00-KEY-BREC.                     
           MOVE WS-PART-NO     TO E-FBE00-DB-PART-BREC.                 
           MOVE WS-INPUT-DATE  TO E-FBE00-CREATE-DATE-BREC.             
           PERFORM 8100-WRITE-FCSBE00 THRU 8100-EXIT.                   
           MOVE SPACES         TO FIOBE00.                              
      *                                                                         
           MOVE LOW-VALUES     TO E-FBE01-KEY-BREC.                     
           MOVE WS-PART-NO     TO E-FBE01-DB-PART-BREC.                 
           MOVE WS-INPUT-DATE  TO E-FBE01-CREATE-DATE-BREC.             
           PERFORM 8200-WRITE-FCSBE01 THRU 8200-EXIT.                   
           MOVE SPACES         TO FIOBE01.                              
           MOVE WS-N           TO WS-CNTRL-REC-FLAG.                    
      *                                                                         
           MOVE LOW-VALUES     TO E-FWK02-KEY-BREC.                     
           MOVE WS-PART-NO     TO E-FWK02-DB-PART-BREC.                 
           MOVE WS-INPUT-DATE  TO E-FWK02-CREATE-DATE-BREC.             
           WRITE FIOWK02                                                
      *                                                                         
           IF FWK02-SUCCESSFUL                                          
              ADD 1 TO WS-RESTART-FCSWK02-REC-CNTR                      
           ELSE                                                         
              DISPLAY '5100-ERROR ON FCSWK02 WRITE.  STATUS IS '        
                      WS-FWK02-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE LOW-VALUES     TO E-FWK03-KEY-BREC.                     
           MOVE WS-PART-NO     TO E-FWK03-DB-PART-BREC.                 
           MOVE WS-INPUT-DATE  TO E-FWK03-CREATE-DATE-BREC.             
           WRITE FIOWK03                                                
      *                                                                         
           IF FWK03-SUCCESSFUL                                          
              ADD 1 TO WS-RESTART-FCSWK03-REC-CNTR                      
           ELSE                                                         
              DISPLAY '5100-ERROR ON FCSWK03 WRITE.  STATUS IS '        
                      WS-FWK03-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
DC         MOVE LOW-VALUES     TO E-FWK04-KEY-BREC.                     
DC         MOVE WS-PART-NO     TO E-FWK04-DB-PART-BREC.                 
DC         MOVE WS-INPUT-DATE  TO E-FWK04-CREATE-DATE-BREC.             
DC         WRITE FIOWK04                                                
DC    *                                                                         
DC         IF FWK04-SUCCESSFUL                                          
DC            ADD 1 TO WS-RESTART-FCSWK04-REC-CNTR                      
DC         ELSE                                                         
DC            DISPLAY '5100-ERROR ON FCSWK04 WRITE.  STATUS IS '        
DC                    WS-FWK04-STATUS                                   
DC            PERFORM 9900-ABEND         THRU 9900-EXIT                 
DC         END-IF.                                                      
      *                                                                         
           MOVE LOW-VALUES     TO E-FWK05-KEY-BREC.                     
           MOVE WS-PART-NO     TO E-FWK05-DB-PART-BREC.                 
           MOVE WS-INPUT-DATE  TO E-FWK05-CREATE-DATE-BREC.             
           WRITE FIOWK05                                                
      *                                                                         
           IF FWK05-SUCCESSFUL                                          
              ADD 1 TO LS-FCSWK05-REC-CNTR                              
           ELSE                                                         
              DISPLAY '5100-ERROR ON FCSWK05 WRITE.  STATUS IS '        
                      WS-FWK05-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE LOW-VALUES     TO E-FWK06-KEY-BREC.                     
           MOVE WS-PART-NO     TO E-FWK06-DB-PART-BREC.                 
           MOVE WS-INPUT-DATE  TO E-FWK06-CREATE-DATE-BREC.             
           WRITE FIOWK06                                                
      *                                                                         
           IF FWK06-SUCCESSFUL                                          
              ADD 1 TO WS-RESTART-FCSWK06-REC-CNTR                      
           ELSE                                                         
              DISPLAY '5100-ERROR ON FCSWK06 WRITE.  STATUS IS '        
                      WS-FWK06-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE LOW-VALUES     TO E-FBE21-KEY-BREC                      
           MOVE WS-PART-NO     TO E-FBE21-DB-PART-BREC                  
           MOVE WS-INPUT-DATE  TO E-FBE21-CREATE-DATE-BREC              
           WRITE FIOBE21                                                
      *                                                                         
           IF FBE21-SUCCESSFUL                                          
              ADD 1 TO LS-FCSBE21-REC-CNTR                              
           ELSE                                                         
              DISPLAY '5100-ERROR ON FCSBE21 WRITE.  STATUS IS '        
                      WS-FBE21-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5110-WRITE-END-CONTROLS.                                         
           MOVE WS-Y           TO WS-CNTRL-REC-FLAG.                    
           MOVE SPACES          TO FIOBE00.                             
           MOVE ZERO            TO E-FBE00-SORT-SUM-FLD.                
           MOVE HIGH-VALUES     TO E-FBE00-KEY-EREC.                    
           MOVE WS-PART-NO      TO E-FBE00-DB-PART-EREC.                
           COMPUTE E-FBE00-RECORD-COUNT-EREC                            
              = WS-RESTART-FCSBE00-REC-CNTR - 1                         
           PERFORM 8100-WRITE-FCSBE00 THRU 8100-EXIT.                   
                                                                        
           MOVE SPACES           TO FIOBE01.                            
           MOVE ZERO             TO E-FBE01-SORT-SUM-FLD.               
           MOVE HIGH-VALUES      TO E-FBE01-KEY-EREC.                   
           MOVE WS-PART-NO       TO E-FBE01-DB-PART-EREC.               
           COMPUTE E-FBE01-RECORD-COUNT-EREC                            
              = WS-RESTART-FCSBE01-REC-CNTR - 1                         
           PERFORM 8200-WRITE-FCSBE01 THRU 8200-EXIT.                   
           MOVE WS-N           TO WS-CNTRL-REC-FLAG.                    
      *                                                                         
           MOVE SPACES             TO FIOWK02.                          
           MOVE HIGH-VALUES        TO E-FWK02-KEY-EREC.                 
           MOVE WS-PART-NO         TO E-FWK02-DB-PART-EREC.             
           COMPUTE E-FWK02-RECORD-COUNT-EREC                            
              = WS-RESTART-FCSWK02-REC-CNTR - 1                         
           MOVE WS-WK02-SUMM-TOTAL TO E-FWK02-BILL-CALC-TOT-EREC.       
           WRITE FIOWK02                                                
      *                                                                         
           IF FWK02-SUCCESSFUL                                          
              ADD 1 TO WS-RESTART-FCSWK02-REC-CNTR                      
           ELSE                                                         
              DISPLAY '5110-ERROR ON FCSWK02 WRITE.  STATUS IS '        
                      WS-FWK02-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE SPACES              TO FIOWK03.                         
           MOVE HIGH-VALUES         TO E-FWK03-KEY-EREC.                
           MOVE WS-PART-NO          TO E-FWK03-DB-PART-EREC.            
           COMPUTE E-FWK03-RECORD-COUNT-EREC                            
              = WS-RESTART-FCSWK03-REC-CNTR - 1                         
           WRITE FIOWK03                                                
      *                                                                         
           IF FWK03-SUCCESSFUL                                          
              ADD 1 TO WS-RESTART-FCSWK03-REC-CNTR                      
           ELSE                                                         
              DISPLAY '5110-ERROR ON FCSWK03 WRITE.  STATUS IS '        
                      WS-FWK03-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
DC         MOVE SPACES             TO FIOWK04.                          
DC         MOVE HIGH-VALUES        TO E-FWK04-KEY-EREC.                 
DC         MOVE WS-PART-NO         TO E-FWK04-DB-PART-EREC.             
DC         COMPUTE E-FWK04-RECORD-COUNT-EREC                            
DC            = WS-RESTART-FCSWK04-REC-CNTR - 1                         
DC         MOVE WS-WK04-SUMM-TOTAL TO E-FWK04-BILL-CALC-TOT-EREC.       
DC         WRITE FIOWK04                                                
DC    *                                                                         
DC         IF FWK04-SUCCESSFUL                                          
DC            ADD 1 TO WS-RESTART-FCSWK04-REC-CNTR                      
DC         ELSE                                                         
DC            DISPLAY '5110-ERROR ON FCSWK04 WRITE.  STATUS IS '        
DC                    WS-FWK04-STATUS                                   
DC            PERFORM 9900-ABEND         THRU 9900-EXIT                 
DC         END-IF.                                                      
      *                                                                         
           MOVE SPACES              TO FIOWK05.                         
           MOVE HIGH-VALUES         TO E-FWK05-KEY-EREC.                
           MOVE WS-PART-NO          TO E-FWK05-DB-PART-EREC.            
           COMPUTE E-FWK05-RECORD-COUNT-EREC                            
T15042        = LS-FCSWK05-REC-CNTR - 1                                 
           WRITE FIOWK05                                                
      *                                                                         
           IF FWK05-SUCCESSFUL                                          
T15042        ADD 1 TO LS-FCSWK05-REC-CNTR                              
           ELSE                                                         
              DISPLAY '5110-ERROR ON FCSWK05 WRITE.  STATUS IS '        
                      WS-FWK05-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE SPACES             TO FIOWK06.                          
           MOVE HIGH-VALUES        TO E-FWK06-KEY-EREC.                 
           MOVE WS-PART-NO         TO E-FWK06-DB-PART-EREC.             
           COMPUTE E-FWK06-RECORD-COUNT-EREC                            
              = WS-RESTART-FCSWK06-REC-CNTR - 1                         
           WRITE FIOWK06                                                
      *                                                                         
           IF FWK06-SUCCESSFUL                                          
              ADD 1 TO WS-RESTART-FCSWK06-REC-CNTR                      
           ELSE                                                         
              DISPLAY '5110-ERROR ON FCSWK06 WRITE.  STATUS IS '        
                      WS-FWK06-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
           MOVE SPACES             TO FIOBE21                           
           MOVE HIGH-VALUES        TO E-FBE21-KEY-EREC                  
           MOVE WS-PART-NO         TO E-FBE21-DB-PART-EREC              
           COMPUTE E-FBE21-RECORD-COUNT-EREC                            
T15042        = LS-FCSBE21-REC-CNTR - 1                                 
           WRITE FIOBE21                                                
      *                                                                         
           IF FBE21-SUCCESSFUL                                          
T15042        ADD 1 TO LS-FCSBE21-REC-CNTR                              
           ELSE                                                         
              DISPLAY '5110-ERROR ON FCSBE21 WRITE.  STATUS IS '        
                      WS-FBE21-STATUS                                   
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       5110-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       5200-GET-RELATIVE-DATES.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -20, IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ) )
            INTO
              :WS-WORK-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-RUN-DATE) - 20 DAYS                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-WORK-DATE TO LS-DATE-20-DAYS-AGO.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -25, IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ) )
            INTO
              :WS-WORK-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-RUN-DATE) - 25 DAYS                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-WORK-DATE TO LS-DATE-25-DAYS-AGO.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -55, IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ) )
            INTO
              :WS-WORK-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-RUN-DATE) - 55 DAYS                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-WORK-DATE TO LS-DATE-55-DAYS-AGO.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, -85, IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ) )
            INTO
              :WS-WORK-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-RUN-DATE) - 85 DAYS                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-WORK-DATE TO LS-DATE-85-DAYS-AGO.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 15, IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ) )
            INTO
              :WS-WORK-DATE                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-RUN-DATE) + 15 DAYS                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-RUN-DATE
              ) <> 0) OR (LEN(:WS-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-RUN-DATE
              ), CONVERT(DATE, :WS-RUN-DATE) ) )
            INTO
              :WS-WORK-DATE                          
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*            DATE(:WS-RUN-DATE) - 1 YEAR                                  
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       5200-EXIT.                                                       
           EXIT.                                                        
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *   6235-GET-FJC01-RESTART-REQ.                                           
       COPY CPD00035.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *   6240-GET-FCA00-COMMON-DATE.                                **         
       COPY CPD00040.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *   6241-GET-FCA00-BILL-CYCLES.                                **         
       COPY CPD00041.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *   6244-GET-FCA00-ALLOW-DATES.                                **         
       COPY CPD00044.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *   6246-GET-FCA00-EXTRA-DATES.                                **         
       COPY CPD00046.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *   6251-GET-FJC01-DATE.                                       **         
       COPY CPD00037.                                                           
C31702/   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
C31702*   6253-GET-FJC01-CHKP-LIMIT.                                            
C31702 COPY CPD00034.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *   6255-GET-FJC01-PRT-CNTR.                                   **         
       COPY CPD00015.                                                           
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
PCR473*   6500-LOAD-EXCP-LIMITS.                                     **         
PCR473     EXEC SQL                                                             
PCR473         INCLUDE CPD00314                                                 
PCR473     END-EXEC.                                                            
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
C32676 6550-LOAD-NON-SUMMER-ST-MTH.                                     
    ST     EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
              WHERE   DELINQ_CD = :C8-DELINQ-CD                         
              AND     COMPANY_NO = :C8-COMPANY-NO                       
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :C8-DELINQ-VALUE                                          
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD = :C8-DELINQ-CD                                 
MFA-TR*       AND     COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '** 6550-LOAD-NON-SUMMER-ST-MTH'                 
               DISPLAY '** ERROR ON SELECT FROM CSS_DELINQUENCY **'     
               DISPLAY '** DELINQ_CD = ' C8-DELINQ-CD ' ; SQLCODE = '   
                       SQLCODE                                          
               DISPLAY '** DCOMPANY_NO= ' C8-COMPANY-NO ' ; SQLCODE = ' 
                       SQLCODE                                          
               DISPLAY '**  PROCESSING TERMINATED  **'                  
               PERFORM 9900-ABEND      THRU  9900-EXIT                  
   END     END-IF.                                                      
C32676 6550-EXIT.                                                       
           EXIT.                                                        
      *   6600-COMPUTE-CALENDAR-DATE.                                **         
      *COPY CPD00012.                                                           
      /*****************************************************************        
      *     7000-READ-FCSDB07                                          *        
      *      MAIN DRIVER.   READS THE DAILY BILLING FILE               *        
      *                                                                *        
      ******************************************************************        
       7000-READ-FCSDB07.                                               
           READ FCSDB07-FILE                                            
               AT END                                                   
                   MOVE WS-Y TO WS-NO-MORE-DATA                         
                   GO TO 7000-EXIT.                                     
                                                                        
           IF FDB07-SUCCESSFUL                                          
               ADD 1 TO WS-FCSDB07-REC-CNTR                             
                        WS-RESTART-RECORD-COUNT                         
           ELSE                                                         
               DISPLAY '7000-ERROR ON FCSDB07 READ.  STATUS IS '        
                        WS-FDB07-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
C23301     IF E-FDB07-KEY-BREC NOT = LOW-VALUES   AND                   
C23301        E-FDB07-KEY-BREC NOT = HIGH-VALUES                        
C23301        IF WS-PREV-COMPANY-NO = SPACES                            
C23301           MOVE E-FDB07-COMPANY-NO TO WS-PREV-COMPANY-NO          
T31542                                      WS-CHECK-COMPANY-NO         
C23301        END-IF                                                    
C23501     END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
     *                                                                  
C33462/****************************************************************         
C33462*    7150-GET-ACCT-INFO                                         *         
C33462*                                                               *         
C33462*****************************************************************         
C33462 7150-GET-ACCT-INFO.                                              
C33462                                                                  
C33462     MOVE WS-FDB07-ACCT-NO TO AT-ACCOUNT-NO.                      
C33462     MOVE SPACES TO AT-CODE-ACCT-BILLED.                          
C33462                                                                  
C33462     EXEC SQL                                                     
C33462          SELECT                                                  
C33462              ACCOUNT_NO,                                         
C33462              PREMISE_NO,                                         
C33462              CUSTOMER_NO,                                        
C33462              COMPANY_NO,                                         
C33462              LOCAL_OFFICE,                                       
C33462              CREDIT_GROUP,                                       
C33462              TOTAL_AR_BALANCE,                                   
C33462              CODE_ACCT_BILLED,                                   
C37761              CODE_ACCT_STAT                                      
C33462          INTO                                                    
C33462              :AT-ACCOUNT-NO,                                     
C33462              :AT-PREMISE-NO,                                     
C33462              :AT-CUSTOMER-NO,                                    
C33462              :AT-COMPANY-NO,                                     
C33462              :AT-LOCAL-OFFICE,                                   
C33462              :AT-CREDIT-GROUP,                                   
C33462              :AT-TOTAL-AR-BALANCE,                               
C33462              :AT-CODE-ACCT-BILLED,                               
C37761              :AT-CODE-ACCT-STAT                                  
C33462          FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
C33462          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T33182                                                           
C33462     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*             ACCOUNT_NO,                                                 
MFA-TR*             PREMISE_NO,                                                 
MFA-TR*             CUSTOMER_NO,                                                
MFA-TR*             COMPANY_NO,                                                 
MFA-TR*             LOCAL_OFFICE,                                               
MFA-TR*             CREDIT_GROUP,                                               
MFA-TR*             TOTAL_AR_BALANCE,                                           
MFA-TR*             CODE_ACCT_BILLED,                                           
MFA-TR*             CODE_ACCT_STAT                                              
MFA-TR*         INTO                                                            
MFA-TR*             :AT-ACCOUNT-NO,                                             
MFA-TR*             :AT-PREMISE-NO,                                             
MFA-TR*             :AT-CUSTOMER-NO,                                            
MFA-TR*             :AT-COMPANY-NO,                                             
MFA-TR*             :AT-LOCAL-OFFICE,                                           
MFA-TR*             :AT-CREDIT-GROUP,                                           
MFA-TR*             :AT-TOTAL-AR-BALANCE,                                       
MFA-TR*             :AT-CODE-ACCT-BILLED,                                       
MFA-TR*             :AT-CODE-ACCT-STAT                                          
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C33462*                                                                         
C33462     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
C33462                                                                  
C33462     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND OR -811            
C33462        CONTINUE                                                  
C33462     ELSE                                                         
C33462        DISPLAY '**         PCSCA100 PROCESSING ERROR      **'    
C33462        DISPLAY '**    COULD NOT GET ACCOUNT BILLED INFO   **'    
C33462        DISPLAY '**    ACCT NO:  ' AT-ACCOUNT-NO                  
C33462        PERFORM 9900-ABEND THRU 9900-EXIT                         
C33462     END-IF.                                                      
C33462                                                                  
C33462 7150-EXIT.                                                       
C33462     EXIT.                                                        
T17582/****************************************************************         
    ST*   7160-GET-AR-TIMESTAMP                                                 
      *                                                               *         
      *****************************************************************         
       7160-GET-AR-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           TRANS_HIST_SEQ_NO), 121), ' ', '-'), ':', '.')                      
                   INTO :AR-TRANS-HIST-SEQ-NO :WS-NULL-IND-14           
                   FROM CSS_AR_TRANS_HIST                               
                   WHERE CODE_TRAN_TYPE = 'B'                           
                   AND APPL_PROGRAM_ID = 'PCSCA100'                     
                   AND ACCOUNT_NO  =:AR-ACCOUNT-NO                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MAX(TRANS_HIST_SEQ_NO)                                   
MFA-TR*            INTO :AR-TRANS-HIST-SEQ-NO :WS-NULL-IND-14                   
MFA-TR*            FROM CSS_AR_TRANS_HIST                                       
MFA-TR*            WHERE CODE_TRAN_TYPE = 'B'                                   
MFA-TR*            AND APPL_PROGRAM_ID = 'PCSCA100'                             
MFA-TR*            AND ACCOUNT_NO  =:AR-ACCOUNT-NO                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              IF WS-NULL-IND-14 < 0                                     
                 MOVE '1900-01-01-00.00.00.000000'                      
                                 TO AR-TRANS-HIST-SEQ-NO                
              END-IF                                                    
           ELSE                                                         
              DISPLAY '**         PCSCA100 PROCESSING ERROR      **'    
              DISPLAY '7160-GET-AR-TIMESTAMP'                           
              DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
              DISPLAY '**    ACCT NO:  ' AT-ACCOUNT-NO                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
    ED 7160-EXIT.                                                       
T17582     EXIT.                                                        
T17582/****************************************************************         
    ST*    7165-GET-TRANS-HIST                                        *         
T28586* PANEL404  - MSE CONTRACT CREATED BUT NOT ACTIVE                         
T30368* PANEL404C - MSE CONTRACT CANCELLED(CANCEL SUMMARY)                      
T30700* PANEL403B - MSE CANCEL CNT DET                                          
      *****************************************************************         
       7165-GET-TRANS-HIST.                                             
                                                                        
           EXEC SQL                                                     
             SELECT COUNT(*)                                            
               INTO :WS-COUNT                                           
               FROM CSS_AR_TRANS_HIST                                   
               WHERE ACCOUNT_NO = :AR-ACCOUNT-NO  AND                   
                    TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )           
T28586          AND APPL_PROGRAM_ID  <> 'PANEL404'                      
T30368          AND APPL_PROGRAM_ID  <> 'PANEL404C'                     
T30700          AND APPL_PROGRAM_ID  <> 'PANEL403B'                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COUNT(*)                                                    
MFA-TR*        INTO :WS-COUNT                                                   
MFA-TR*        FROM CSS_AR_TRANS_HIST                                           
MFA-TR*        WHERE ACCOUNT_NO = :AR-ACCOUNT-NO  AND                           
MFA-TR*             TRANS_HIST_SEQ_NO > :AR-TRANS-HIST-SEQ-NO                   
MFA-TR*         AND APPL_PROGRAM_ID  <> 'PANEL404'                              
MFA-TR*         AND APPL_PROGRAM_ID  <> 'PANEL404C'                             
MFA-TR*         AND APPL_PROGRAM_ID  <> 'PANEL403B'                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**         PCSCA100 PROCESSING ERROR      **'    
              DISPLAY '7165-GET-TRANS-HIST'                             
              DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
              DISPLAY '**    ACCT NO:  ' AT-ACCOUNT-NO                  
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
                                                                        
    ED 7165-EXIT.                                                       
T17582     EXIT.                                                        
      /                                                                         
       7030-GET-NEXT-WORK-DAY.                                          
           EXEC SQL                                                     
              SELECT DATEADD( DAY, :WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )          
                INTO :WS-WORK-DATE                                      
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
                WHERE CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) -                
                        (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE
              ) ) )) / 7 * 7) BETWEEN 1 AND 5 
                  AND NOT EXISTS                                        
                       (SELECT HOLIDAY_DT                               
                          FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                
                          WHERE COMPANY_NO = :J8-COMPANY-NO             
                            AND HOLIDAY_DT =                            
                                DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))                
C34001                                                           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-CURRENT-DATE) + :WS-ADJ-DAY DAYS                  
MFA-TR*         INTO :WS-WORK-DATE                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WHERE DAYS(DATE(:WS-CURRENT-DATE)                               
MFA-TR*                            + :WS-ADJ-DAY DAYS) -                        
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-CURRENT-DATE)                    
MFA-TR*                   + :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*                (SELECT HOLIDAY_DT                                       
MFA-TR*                   FROM CSS_HOLIDAY                                      
MFA-TR*                   WHERE COMPANY_NO = :J8-COMPANY-NO                     
MFA-TR*                     AND HOLIDAY_DT =                                    
MFA-TR*                         DATE(:WS-CURRENT-DATE) +                        
MFA-TR*                                :WS-ADJ-DAY DAYS)                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /                                                                         
       7031-GET-PREV-WORK-DAY.                                          
           EXEC SQL                                                     
              SELECT DATEADD( DAY, -:WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )          
                INTO :WS-WORK-DATE                                      
                FROM CSS_MODEL_SQL WITH(READUNCOMMITTED)                        
                WHERE CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) -                
                        (CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )
               )) / 7 * 7) BETWEEN 1 AND 5 
                  AND NOT EXISTS                                        
                       (SELECT HOLIDAY_DT                               
                          FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                
                          WHERE COMPANY_NO = :J8-COMPANY-NO             
                            AND HOLIDAY_DT =                            
                                DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))                
C34001                                                           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-CURRENT-DATE) - :WS-ADJ-DAY DAYS                  
MFA-TR*         INTO :WS-WORK-DATE                                              
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*         WHERE DAYS(DATE(:WS-CURRENT-DATE)                               
MFA-TR*                            - :WS-ADJ-DAY DAYS) -                        
MFA-TR*                 (INTEGER(DAYS(DATE(:WS-CURRENT-DATE)                    
MFA-TR*                   - :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5         
MFA-TR*           AND NOT EXISTS                                                
MFA-TR*                (SELECT HOLIDAY_DT                                       
MFA-TR*                   FROM CSS_HOLIDAY                                      
MFA-TR*                   WHERE COMPANY_NO = :J8-COMPANY-NO                     
MFA-TR*                     AND HOLIDAY_DT =                                    
MFA-TR*                         DATE(:WS-CURRENT-DATE) -                        
MFA-TR*                                :WS-ADJ-DAY DAYS)                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       7031-EXIT.                                                       
           EXIT.                                                        
T21753/                                                                         
T21753 7100-OPEN-RATE-PLAN.                                             
T21753*                                                                         
T21753     EXEC SQL                                                     
T21753         OPEN RATE_PLAN                                           
T21753     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21753*                                                                         
T21753     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T21753     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T21753         CONTINUE                                                 
T21753     ELSE                                                         
T21753         DISPLAY '7100-OPEN-RATE-PLAN'                            
T21753                 ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
T21753                 ' ACCOUNT NO  = ' UT-ACCOUNT-NO                  
T21753         PERFORM 9900-ABEND                THRU 9900-EXIT         
T21753     END-IF.                                                      
T21753*                                                                         
T21753 7100-EXIT.                                                       
T21753     EXIT.                                                        
T21753/                                                                         
T21753 7110-FETCH-RATE-PLAN.                                            
T21753*                                                                         
T21753     EXEC SQL                                                     
T21753         FETCH RATE_PLAN                                          
T21753         INTO :WS-SECURED-RATE                                    
T21753     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21753*                                                                         
T21753     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T21753     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T21753         CONTINUE                                                 
T21753     ELSE                                                         
T21753         DISPLAY '7110-FETCH-SUB-ACCT'                            
T21753                 ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
T21753                 ' ACCOUNT NO  = ' UT-ACCOUNT-NO                  
T21753         PERFORM 9900-ABEND                THRU 9900-EXIT         
T21753     END-IF.                                                      
T21753*                                                                         
T21753 7110-EXIT.                                                       
T21753     EXIT.                                                        
T21753/                                                                         
T21753 7120-CLOSE-RATE-PLAN.                                            
T21753*                                                                         
T21753     EXEC SQL                                                     
T21753         CLOSE RATE_PLAN                                          
T21753     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21753*                                                                         
T21753     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T21753     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T21753         CONTINUE                                                 
T21753     ELSE                                                         
T21753         DISPLAY '7120-CLOSE-SUB-ACCT'                            
T21753                 ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
T21753                 ' ACCOUNT NO  = ' UT-ACCOUNT-NO                  
T21753         PERFORM 9900-ABEND                THRU 9900-EXIT         
T21753     END-IF.                                                      
T21753*                                                                         
T21753 7120-EXIT.                                                       
T21753     EXIT.                                                        
TP6075*                                                                         
TP6075 7300-OPEN-WEATHER-TREND.                                         
TP6075     EXEC SQL                                                     
TP6075          OPEN WEATHER_TREND                                      
TP6075     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP6075     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP6075     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
TP6075        NEXT SENTENCE                                             
TP6075     ELSE                                                         
TP6075        DISPLAY '7300-OPEN-WEATHER-TREND'                         
TP6075        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
TP6075        PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
TP6075 7300-EXIT.                                                       
TP6075     EXIT.                                                        
TP6075*                                                                         
TP6075 7310-FETCH-WEATHER-TREND.                                        
TP6075     EXEC SQL                                                     
TP6075        FETCH WEATHER_TREND                                       
TP6075         INTO :WT-CODE-REVENUE-CLASS,                             
TP6075              :WT-FACTOR,                                         
TP6075              :WT-UNITS-ACCUM,                                    
TP6075              :WT-CODE-UTIL-TYPE                                  
TP6075     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP6075     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP6075     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
TP6075                              OR NOT-FOUND                        
TP6075        NEXT SENTENCE                                             
TP6075     ELSE                                                         
TP6075        DISPLAY '7310-FETCH-WEATHER-TREND'                        
TP6075        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
TP6075        PERFORM 7320-CLOSE-WEATHER-TREND                          
TP6075        PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
TP6075 7310-EXIT.                                                       
TP6075     EXIT.                                                        
TP6075*                                                                         
TP6075 7320-CLOSE-WEATHER-TREND.                                        
TP6075     EXEC SQL                                                     
TP6075          CLOSE WEATHER_TREND                                     
TP6075     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP6075     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP6075     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
TP6075        NEXT SENTENCE                                             
TP6075     ELSE                                                         
TP6075        DISPLAY '7320-CLOSE-WEATHER-TREND'                        
TP6075        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
TP6075        PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
TP6075 7320-EXIT.                                                       
TP6075     EXIT.                                                        
TP6075*                                                                         
      *                                                                         
C23301******************************************************************        
C23301* 7340-OPEN-COMPANY-CURSOR                                                
C23301******************************************************************        
C23301 7340-OPEN-COMPANY-CURSOR.                                        
C23301     EXEC SQL                                                     
C23301        OPEN COMPANY_CURSOR                                       
C23301     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23301                                                                  
C23301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C23301                                                                  
C23301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C23301        NEXT SENTENCE                                             
C23301     ELSE                                                         
C23301        MOVE '7340'          TO ACTIVE-PARAGRAPH                  
C23301        MOVE 'OPEN'          TO ABEND-FUNCTION                    
C23301        MOVE 'CSS_COMPANY'        TO TABLE-1                      
C23301        PERFORM 9900-ABEND THRU 9900-EXIT                         
C23301     END-IF.                                                      
      *                                                                         
C23301 7340-EXIT.                                                       
C23301     EXIT.                                                        
                                                                        
C23301******************************************************************        
C23301* 7350-FETCH-COMPANY-CURSOR                                               
C23301******************************************************************        
C23301 7350-FETCH-COMPANY-CURSOR.                                       
C23301                                                                  
C23301     EXEC SQL                                                     
C23301        FETCH COMPANY_CURSOR                                      
C23301        INTO  :C7-COMPANY-NO,                                     
C23301              :C7-COMPANY-NAME,                                   
C23301              :C7-TEMPERATURE-REQ-FL,                             
C23301              :C7-BTU-FACTOR-REQ-FL,                              
C23301              :C7-WEATHER-TND-REQ-FL,                             
C23301              :C7-CALC-WNA-METHOD-CD                              
C23301     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23301                                                                  
C23301                                                                  
C23301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C23301                                                                  
C23301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C23301        NEXT SENTENCE                                             
C23301     ELSE                                                         
C23301        MOVE '7350'                TO ACTIVE-PARAGRAPH            
C23301        MOVE 'FETCH'               TO ABEND-FUNCTION              
C23301        MOVE 'CSS_COMPANY'         TO TABLE-1                     
C23301        MOVE 'TEMPERATURE_REQ_FL'  TO TABLE-ELEMENT-1             
C23301        MOVE C7-TEMPERATURE-REQ-FL TO HOSTVAR-ELEMENT-1           
C23301        MOVE 'BTU_FACTOR_REQ_FL'   TO TABLE-ELEMENT-2             
C23301        MOVE C7-BTU-FACTOR-REQ-FL  TO HOSTVAR-ELEMENT-2           
C23301        MOVE 'WEATHER_TND_REQ_FL'  TO TABLE-ELEMENT-3             
C23301        MOVE C7-WEATHER-TND-REQ-FL TO HOSTVAR-ELEMENT-3           
C23301        PERFORM 9900-ABEND THRU 9900-EXIT                         
C23301     END-IF.                                                      
C23301                                                                  
C23301 7350-EXIT.                                                       
C23301     EXIT.                                                        
                                                                        
C23301******************************************************************        
C23301* 7360-CLOSE-COMPANY-CURSOR                                               
C23301******************************************************************        
C23301 7360-CLOSE-COMPANY-CURSOR.                                       
C23301                                                                  
C23301     EXEC SQL                                                     
C23301        CLOSE COMPANY_CURSOR                                      
C23301     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23301                                                                  
C23301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C23301                                                                  
C23301     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C23301        NEXT SENTENCE                                             
C23301     ELSE                                                         
C23301        MOVE '7360'          TO ACTIVE-PARAGRAPH                  
C23301        MOVE 'CLOSE'         TO ABEND-FUNCTION                    
C23301        MOVE 'CSS_COMPANY'        TO TABLE-1                      
C23301        PERFORM 9900-ABEND THRU 9900-EXIT                         
C23301     END-IF.                                                      
C23301                                                                  
C23301 7360-EXIT.                                                       
C23301     EXIT.                                                        
                                                                        
RSN5  /****************************************************************         
RSN5  *                                                              **         
RSN5  *    7530-OPEN-MST-ACCT                                        **         
RSN5  *                                                              **         
RSN5  *****************************************************************         
RSN5   7530-OPEN-MST-ACCT.                                              
RSN5  *                                                                         
RSN5       EXEC SQL                                                     
RSN5           DECLARE MST_ACCT CURSOR FOR                              
RSN5               SELECT MST_ACCT_NO,                                  
RSN5                      SUB_ACCT_NO,                                  
RSN5                      SUB_ACCT_BLLD_OK                              
RSN5               FROM   CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                 
RSN5               WHERE  MST_ACCT_NO = :WS-FDB07-ACCT-NO               
T33182         FOR READ ONLY                                    
RSN5       END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MST_ACCT CURSOR FOR                                      
MFA-TR*            SELECT MST_ACCT_NO,                                          
MFA-TR*                   SUB_ACCT_NO,                                          
MFA-TR*                   SUB_ACCT_BLLD_OK                                      
MFA-TR*            FROM   CSS_MSTSUB_ACCT                                       
MFA-TR*            WHERE  MST_ACCT_NO = :WS-FDB07-ACCT-NO                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
RSN5  *                                                                         
RSN5       EXEC SQL                                                     
RSN5           OPEN MST_ACCT                                            
RSN5       END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

RSN5  *                                                                         
RSN5       MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
RSN5       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
RSN5           CONTINUE                                                 
RSN5       ELSE                                                         
RSN5           DISPLAY '7530-OPEN-MST-ACCT'                             
RSN5                   ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
RSN5                   ' ACCT NO     = ' WS-FDB07-ACCT-NO               
RSN5           PERFORM 9900-ABEND          THRU 9900-EXIT               
RSN5       END-IF.                                                      
RSN5  *                                                                         
RSN5   7530-EXIT.                                                       
RSN5       EXIT.                                                        
      *                                                                         
RSN5  /****************************************************************         
RSN5  *                                                              **         
RSN5  *    7540-FETCH-MST-ACCT                                       **         
RSN5  *                                                              **         
RSN5  *****************************************************************         
RSN5   7540-FETCH-MST-ACCT.                                             
RSN5  *                                                                         
RSN5       EXEC SQL                                                     
RSN5           FETCH MST_ACCT                                           
RSN5           INTO :MU-MST-ACCT-NO,                                    
RSN5                :MU-SUB-ACCT-NO,                                    
RSN5                :MU-SUB-ACCT-BLLD-OK                                
RSN5       END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

RSN5  *                                                                         
RSN5       MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
RSN5       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
RSN5                                   OR NOT-FOUND                     
RSN5           CONTINUE                                                 
RSN5       ELSE                                                         
RSN5           DISPLAY '7540-FETCH-MST-ACCT'                            
RSN5                   ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
RSN5           PERFORM 9900-ABEND          THRU 9900-EXIT               
RSN5       END-IF.                                                      
RSN5  *                                                                         
RSN5   7540-EXIT.                                                       
RSN5       EXIT.                                                        
      *                                                                         
RSN5  /****************************************************************         
RSN5  *                                                              **         
RSN5  *    7550-CLOSE-MST-ACCT                                       **         
RSN5  *                                                              **         
RSN5  *****************************************************************         
RSN5   7550-CLOSE-MST-ACCT.                                             
RSN5  *                                                                         
RSN5       EXEC SQL                                                     
RSN5           CLOSE MST_ACCT                                           
RSN5       END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

RSN5  *                                                                         
RSN5       MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
RSN5       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
RSN5           CONTINUE                                                 
RSN5       ELSE                                                         
RSN5           DISPLAY '7550-CLOSE-MST-ACCT'                            
RSN5                   ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
RSN5           PERFORM 9900-ABEND          THRU 9900-EXIT               
RSN5       END-IF.                                                      
RSN5  *                                                                         
RSN5   7550-EXIT.                                                       
RSN5       EXIT.                                                        
      *                                                                         
       7560-OPEN-OPT-READ-DATE-CSR.                                     
           EXEC SQL                                                     
                OPEN OPT_READ_DATE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7560-OPEN-OPT-READ-DATE-CSR CODE = '            
                                                 WS-ACTIVE-RETURN-CODE  
               PERFORM 9900-ABEND         THRU 9900-EXIT
           END-IF.               
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7565-FETCH-OPT-READ-DATE-CSR.                                    
           EXEC SQL                                                     
                FETCH  OPT_READ_DATE    INTO                            
                       :RW-READ-CYCLE,                                  
                       :RW-OPTIMUM-READ-DATE                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7565-FETCH-OPT-READ-DATE-CSR CODE = '           
                                                 WS-ACTIVE-RETURN-CODE  
               PERFORM 9900-ABEND         THRU 9900-EXIT
           END-IF.               
       7565-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7570-CLOSE-OPT-READ-DATE-CSR.                                    
           EXEC SQL                                                     
                CLOSE OPT_READ_DATE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY ' 7570-CLOSE-OPT-READ-DATE-CSR CODE = '          
                                              WS-ACTIVE-RETURN-CODE     
               PERFORM 9900-ABEND         THRU 9900-EXIT                
           END-IF.                                                      
       7570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /*****************************************************************        
      *                                                                *        
      *     7600-START-FCSJC01                                         *        
      *                                                                *        
      ******************************************************************        
            EXEC SQL                                                            
              INCLUDE CPD00038                                                  
            END-EXEC.                                                           
      /*****************************************************************        
      *                                                                *        
      *     7615-SELECT-SUB-ACCT-STAT                                  *        
      *                                                                *        
      ******************************************************************        
       7615-SELECT-SUB-ACCT-STAT.                                       
           EXEC SQL                                                     
                SELECT  CODE_ACCT_STAT INTO :AT-CODE-ACCT-STAT          
                FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE   ACCOUNT_NO = :MU-SUB-ACCT-NO                    
T33182                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  CODE_ACCT_STAT INTO :AT-CODE-ACCT-STAT                  
MFA-TR*         FROM  CSS_ACCOUNT                                               
MFA-TR*         WHERE   ACCOUNT_NO = :MU-SUB-ACCT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               OR NOT-FOUND                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7615-SELECT-SUB-ACCT-STAT'                      
                       ' RETURN CODE=' WS-ACTIVE-RETURN-CODE            
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7615-EXIT.                                                       
            EXIT.                                                       
      /*****************************************************************        
      *                                                                *        
      *     7620-START-FCSCA00                                         *        
      *                                                                *        
      ******************************************************************        
            EXEC SQL                                                            
              INCLUDE CPD00039                                                  
            END-EXEC.                                                           
      /*****************************************************************        
      *                                                                *        
      *     7900-SELECT-RESTART                                        *        
      *                                                                *        
      ******************************************************************        
       7900-SELECT-RESTART.                                             
           EXEC SQL                                                     
                SELECT  RESTART_DATA INTO :RF-RESTART-DATA              
                FROM  CSS_RESTART                                       
                WHERE   NAME_PROGRAM  = :RF-NAME-PROGRAM AND            
                        PARTITION_NO  = :RF-PARTITION-NO AND            
                        DUP_CNTRL_NO  = :RF-DUP-CNTRL-NO                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               OR NOT-FOUND                                             
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7900-SELECT-RESTART'                            
                       ' RETURN CODE=' WS-ACTIVE-RETURN-CODE            
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7900-EXIT.                                                       
            EXIT.                                                       
      /*****************************************************************        
      *                                                                *        
      *     7910-SELECT-GL-NO                                          *        
      *                                                                *        
      ******************************************************************        
T24436***INCLUDE COMMENTED TO SELECT GL NO FROM SCSCB061 SUB PROGRAM   *        
T24436***  EXEC SQL                                                             
T24436***     INCLUDE CPD00062                                                  
T24436***  END-EXEC.                                                            
                                                                        
A02036****ACT0091 - START                                                       
A02036 7920-GET-GUARANTOR-COUNT.                                        
A02036                                                                  
A02036     EXEC SQL                                                     
A02036       SELECT COUNT(*)                                            
A02036       INTO   :WS-COUNT1                                          
A02036       FROM      CSS_GUARANTOR WITH(READUNCOMMITTED)                      
A02036       WHERE     ACCOUNT_NO     = :AT-ACCOUNT-NO                  
A02036       AND       GUAR_STATUS_CD = 'C'                             
A02036       AND       GUAR_STATUS_REASON = 'GUARANTOR BILLED.'         
A02036                                                           
A02036                                                      
A02036     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT COUNT(*)                                                    
MFA-TR*      INTO   :WS-COUNT1                                                  
MFA-TR*      FROM      CSS_GUARANTOR                                            
MFA-TR*      WHERE     ACCOUNT_NO     = :AT-ACCOUNT-NO                          
MFA-TR*      AND       GUAR_STATUS_CD = 'C'                                     
MFA-TR*      AND       GUAR_STATUS_REASON = 'GUARANTOR BILLED.'                 
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 8912                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02036                                                                  
A02036     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A02036                                                                  
A02036     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
A02036        CONTINUE                                                  
A02036     ELSE                                                         
A02036        DISPLAY '**         PCSCA100 PROCESSING ERROR      **'    
A02036        DISPLAY '7920-GET-GUARANTOR-COUNT'                        
A02036        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
A02036        DISPLAY '**    ACCT NO:  ' AT-ACCOUNT-NO                  
A02036        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02036     END-IF.                                                      
A02036                                                                  
A02036 7920-EXIT.                                                       
A02036     EXIT.                                                        
A02036                                                                  
A02036                                                                  
A02036 7930-GET-GUARANTOR-ACCOUNT.                                      
A02036                                                                  
A02036     EXEC SQL                                                     
A02036       SELECT TOP(1) GUARNTR_ACCT_NO                                     
A02036         INTO :GU-GUARNTR-ACCT-NO                                 
A02036         FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                         
A02036       WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                    
A02036         AND GUARNTR_ACCT_NO <> :WS-HOLD-ACCT-NO1                 
A02036         AND GUAR_STATUS_CD   = 'C'                               
A02036         AND GUAR_STATUS_REASON = 'GUARANTOR BILLED.'             
A02036       ORDER BY GUAR_ESTBLSH_DT                                   
A02036                                       
A02036                                                      
A02036     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT GUARNTR_ACCT_NO                                             
MFA-TR*        INTO :GU-GUARNTR-ACCT-NO                                         
MFA-TR*        FROM CSS_GUARANTOR                                               
MFA-TR*      WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                            
MFA-TR*        AND GUARNTR_ACCT_NO = :WS-HOLD-ACCT-NO1                         
MFA-TR*        AND GUAR_STATUS_CD   = 'C'                                       
MFA-TR*        AND GUAR_STATUS_REASON = 'GUARANTOR BILLED.'                     
MFA-TR*      ORDER BY GUAR_ESTBLSH_DT                                           
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 8913                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02036                                                                  
A02036     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A02036                                                                  
A02036     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
A02036        CONTINUE                                                  
A02036     ELSE                                                         
A02036        DISPLAY '**         PCSCA100 PROCESSING ERROR      **'    
A02036        DISPLAY '7930-GET-GUARANTOR-ACCOUNT'                      
A02036        DISPLAY 'RETURN CODE = ' WS-ACTIVE-RETURN-CODE            
A02036        DISPLAY '**    ACCT NO:  ' AT-ACCOUNT-NO                  
A02036        PERFORM 9900-ABEND THRU 9900-EXIT                         
A02036     END-IF.                                                      
A02036                                                                  
A02036 7930-EXIT.                                                       
A02036     EXIT.                                                        
A02036                                                                  
A02036****ACT0091 - END                                                         
I01959/*****************************************************************        
I01959*                                                                *        
I01959*     7940-GET-ASSIGNEE-NAME.                                    *        
I01959*                                                                *        
I01959******************************************************************        
I01959 7940-GET-ASSIGNEE-NAME.                                          
I01959                                                                  
I01959     EXEC SQL                                                     
I01959        SELECT TOP(1) CASE WHEN DQ.NAME_FORMAT = 'B' THEN 
           DQ.FULL_NAME  
I01959                ELSE CIS.CHAR2$CHAR(LTRIM(RTRIM(DQ.LAST_NAME)) + 
           CASE WHEN CIS.SUBSTR3(DQ.FIRST_NAME,1,1)  = ' '   
I01959                          THEN '' ELSE ', '    END + LTRIM(RTRIM(
           DQ.FIRST_NAME)) + CASE WHEN CIS.SUBSTR3(
           DQ.MIDDLE_NAME,1,1) = ' '   
I01959                          THEN '' ELSE ' '     END + LTRIM(RTRIM(
           DQ.MIDDLE_NAME)),70) END                
I01959          INTO :WS-ASSIGNEE-NAME                                  
I01959          FROM  CSS_ACCOUNT         AT WITH(READUNCOMMITTED)              
I01959          JOIN  CSS_NAME_ACCT_XREF  HT WITH(READUNCOMMITTED)              
I01959            ON  HT.ACCOUNT_NO       =  AT.ACCOUNT_NO              
I01959           AND  HT.CUSTOMER_ROLE_CD =  ' '                        
I01959          JOIN  CSS_NAME            DQ WITH(READUNCOMMITTED)              
I01959            ON  DQ.NAME_ID          =  HT.NAME_ID                 
I01959           AND  DQ.NAME_TYPE        =  'CN'                       
I01959         WHERE  AT.ACCOUNT_NO       = :WS-SAVE-XFER-ASGNE-ACCT    
I01959                                              
I01959                                                           
I01959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CASE WHEN DQ.NAME_FORMAT = 'B' THEN DQ.FULL_NAME          
MFA-TR*               ELSE CHAR(STRIP(DQ.LAST_NAME)       ||                    
MFA-TR*                    CASE WHEN SUBSTR(DQ.FIRST_NAME,1,1)  = ' '           
MFA-TR*                         THEN '' ELSE ', '    END  ||                    
MFA-TR*                    STRIP(DQ.FIRST_NAME)           ||                    
MFA-TR*                    CASE WHEN SUBSTR(DQ.MIDDLE_NAME,1,1) = ' '           
MFA-TR*                         THEN '' ELSE ' '     END  ||                    
MFA-TR*                    STRIP(DQ.MIDDLE_NAME),70) END                        
MFA-TR*         INTO :WS-ASSIGNEE-NAME                                          
MFA-TR*         FROM  CSS_ACCOUNT         AT                                    
MFA-TR*         JOIN  CSS_NAME_ACCT_XREF  HT                                    
MFA-TR*           ON  HT.ACCOUNT_NO       =  AT.ACCOUNT_NO                      
MFA-TR*          AND  HT.CUSTOMER_ROLE_CD =  ' '                                
MFA-TR*         JOIN  CSS_NAME            DQ                                    
MFA-TR*           ON  DQ.NAME_ID          =  HT.NAME_ID                         
MFA-TR*          AND  DQ.NAME_TYPE        =  'CN'                               
MFA-TR*        WHERE  AT.ACCOUNT_NO       = :WS-SAVE-XFER-ASGNE-ACCT            
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I01959                                                                  
I01959     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
I01959                                                                  
I01959     EVALUATE WS-ACTIVE-RETURN-CODE                               
I01959         WHEN SUCCESSFUL-CALL                                     
I01959            CONTINUE                                              
I01959         WHEN NOT-FOUND                                           
I01959            MOVE SPACES             TO WS-ASSIGNEE-NAME           
I01959         WHEN OTHER                                               
I01959            DISPLAY '** PCSCA100 PROCESSING ERROR **'             
I01959            DISPLAY '**  7940-GET-ASSIGNEE-NAME   **'             
I01959            DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
I01959            DISPLAY '** PROCESSING  ACCT:  ' AT-ACCOUNT-NO        
I01959            DISPLAY '** ASSIGNEE ACCOUNT:  '                      
I01959                                        WS-SAVE-XFER-ASGNE-ACCT   
I01959            PERFORM 9900-ABEND         THRU 9900-EXIT             
I01959     END-EVALUATE.                                                
I01959                                                                  
I01959 7940-EXIT.                                                       
I01959     EXIT.                                                        
RSN5  /****************************************************************         
RSN5  *                                                              **         
RSN5  *    8000-INSERT-OFF-CYCLE                                     **         
RSN5  *                                                              **         
RSN5  *****************************************************************         
RSN5   8000-INSERT-OFF-CYCLE.                                           
RSN5  *                                                                         
RSN5       EXEC SQL                                                     
RSN5           INSERT INTO CSS_OFF_CYCL_ACCT                            
RSN5                (ACCOUNT_NO,                                        
RSN5                 CODE_BILL_OFF_CYCL,                                
RSN5                 CUSTOMER_NO,                                       
RSN5                 LAST_UPDATE_TS)                                    
RSN5           VALUES                                                   
RSN5                (:OC-ACCOUNT-NO,                                    
RSN5                 :OC-CODE-BILL-OFF-CYCL,                            
RSN5                 :OC-CUSTOMER-NO,                                   
RSN5                 CIS.CURRENT$TIMESTAMP())                                 
RSN5       END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_OFF_CYCL_ACCT                                    
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              CODE_BILL_OFF_CYCL,                                        
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              LAST_UPDATE_TS)                                            
MFA-TR*        VALUES                                                           
MFA-TR*             (:OC-ACCOUNT-NO,                                            
MFA-TR*              :OC-CODE-BILL-OFF-CYCL,                                    
MFA-TR*              :OC-CUSTOMER-NO,                                           
MFA-TR*              CURRENT TIMESTAMP)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

RSN5  *                                                                         
RSN5       MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
RSN5       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
RSN5           CONTINUE                                                 
RSN5       ELSE                                                         
RSN5           DISPLAY '8000-INSERT-OFF-CYCLE'                          
RSN5                   ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
RSN5           PERFORM 9900-ABEND          THRU 9900-EXIT               
RSN5       END-IF.                                                      
RSN5  *                                                                         
RSN5   8000-EXIT.                                                       
RSN5       EXIT.                                                        
      *                                                                         
RSN5  /****************************************************************         
RSN5  *                                                              **         
RSN5  *    8010-SELECT-MST-OVERRIDE                                  **         
RSN5  *                                                              **         
RSN5  *****************************************************************         
RSN5   8010-SELECT-MST-OVERRIDE.                                        
RSN5  *                                                                         
RSN5       EXEC SQL                                                     
RSN5         SELECT                                                     
RSN5            CUSTOMER_NO,                                            
RSN5            MST_SUB_ACCT_IND,                                       
A02906          MST_OVRRD_BLL_IND                                       
RSN5         INTO                                                       
RSN5            :AT-CUSTOMER-NO,                                        
RSN5            :AT-MST-SUB-ACCT-IND,                                   
A02906          :AT-MST-OVRRD-BLL-IND                                   
RSN5         FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
RSN5         WHERE ACCOUNT_NO = :WS-FDB07-ACCT-NO                       
T33182                                                           
RSN5       END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                             
MFA-TR*         CUSTOMER_NO,                                                    
MFA-TR*         MST_SUB_ACCT_IND,                                               
MFA-TR*         MST_OVRRD_BLL_IND                                               
MFA-TR*      INTO                                                               
MFA-TR*         :AT-CUSTOMER-NO,                                                
MFA-TR*         :AT-MST-SUB-ACCT-IND,                                           
MFA-TR*         :AT-MST-OVRRD-BLL-IND                                           
MFA-TR*      FROM CSS_ACCOUNT                                                   
MFA-TR*      WHERE ACCOUNT_NO = :WS-FDB07-ACCT-NO                               
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

RSN5  *                                                                         
RSN5       MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
RSN5       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
RSN5           CONTINUE                                                 
RSN5       ELSE                                                         
RSN5           DISPLAY '8010-SELECT-MST-OVERRIDE'                       
RSN5           DISPLAY 'UNSUCCESSFUL RETRIEVAL OF ACCOUNT'              
RSN5                   ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
RSN5           PERFORM 9900-ABEND          THRU 9900-EXIT               
RSN5       END-IF.                                                      
RSN5  *                                                                         
RSN5   8010-EXIT.                                                       
RSN5       EXIT.                                                        
      *                                                                         
       8100-WRITE-FCSBE00.                                              
           MOVE ZERO  TO  E-FBE00-SORT-SUM-FLD.                         
      *                                                                         
           WRITE FIOBE00.                                               
           MOVE SPACES TO FIOBE00.                                      
           IF FBE00-SUCCESSFUL                                          
               ADD 1 TO WS-RESTART-FCSBE00-REC-CNTR                     
           ELSE                                                         
               DISPLAY '8100-ERROR ON FCSBE00 WRITE.  STATUS IS '       
                        WS-FBE00-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8100-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8200-WRITE-FCSBE01.                                              
           MOVE ZERO  TO  E-FBE01-SORT-SUM-FLD.                         
           WRITE FIOBE01.                                               
           IF FBE01-SUCCESSFUL                                          
               ADD 1 TO WS-RESTART-FCSBE01-REC-CNTR                     
           ELSE                                                         
               DISPLAY '8200-ERROR ON FCSBE01 WRITE.  STATUS IS '       
                        WS-FBE01-STATUS                                 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8200-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8300-WRITE-WK03.                                                 
           WRITE FIOWK03.                                               
                                                                        
           IF FWK03-SUCCESSFUL                                          
              ADD 1 TO WS-RESTART-FCSWK03-REC-CNTR                      
           ELSE                                                         
              DISPLAY 'WRITE ERROR ON WK03. STATUS = '                  
                      WS-FWK03-STATUS                                   
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
       8300-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8310-INSERT-AR-TRAN-HIST.                                        
           EXEC SQL                                                     
              INSERT INTO  CSS_AR_TRANS_HIST                            
                (ACCOUNT_NO,                                            
                 TRANS_HIST_SEQ_NO,                                     
                 DATE_TRANS,                                            
                 CODE_TRAN_TYPE,                                        
                 AMT_ORIG_ENTERED,                                      
                 AMT_BILLED_UNPAID,                                     
                 RESP_AREA_ID,                                          
                 APPL_PROGRAM_ID,                                       
                 PYMT_FACILITY_CD,                                      
                 USER_ID,                                               
                 COMPANY_NO,                                            
                 TRAN_COMMENT,                                          
                 RECORD_ONLY_FL,                                        
                 DATE_ORIG_PYMT,                                        
                 CASH_COMPANY_NO,                                       
                 CASH_LOCAL_OFFICE,                                     
                 CASH_REPORT_NO,                                        
                 DATE_CASH_REPORT,                                      
                 CASH_DRAWER_ID)                                        
                VALUES                                                  
                (:AR-ACCOUNT-NO,                                        
                 CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO),                     
                 IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) ),                              
                 :AR-CODE-TRAN-TYPE,                                    
                 :AR-AMT-ORIG-ENTERED,                                  
                 :AR-AMT-BILLED-UNPAID,                                 
                 :AR-RESP-AREA-ID,                                      
                 :AR-APPL-PROGRAM-ID,                                   
                 :AR-PYMT-FACILITY-CD,                                  
                 :AR-USER-ID,                                           
                 :AR-COMPANY-NO,                                        
                 :AR-TRAN-COMMENT,                                      
                 :AR-RECORD-ONLY-FL,                                    
                 NULL,                                                  
                 :AR-CASH-COMPANY-NO,                                   
                 :AR-CASH-LOCAL-OFFICE,                                 
                 :AR-CASH-REPORT-NO,                                    
                 IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT) ),                        
                 :AR-CASH-DRAWER-ID)                                    
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO  CSS_AR_TRANS_HIST                                    
MFA-TR*         (ACCOUNT_NO,                                                    
MFA-TR*          TRANS_HIST_SEQ_NO,                                             
MFA-TR*          DATE_TRANS,                                                    
MFA-TR*          CODE_TRAN_TYPE,                                                
MFA-TR*          AMT_ORIG_ENTERED,                                              
MFA-TR*          AMT_BILLED_UNPAID,                                             
MFA-TR*          RESP_AREA_ID,                                                  
MFA-TR*          APPL_PROGRAM_ID,                                               
MFA-TR*          PYMT_FACILITY_CD,                                              
MFA-TR*          USER_ID,                                                       
MFA-TR*          COMPANY_NO,                                                    
MFA-TR*          TRAN_COMMENT,                                                  
MFA-TR*          RECORD_ONLY_FL,                                                
MFA-TR*          DATE_ORIG_PYMT,                                                
MFA-TR*          CASH_COMPANY_NO,                                               
MFA-TR*          CASH_LOCAL_OFFICE,                                             
MFA-TR*          CASH_REPORT_NO,                                                
MFA-TR*          DATE_CASH_REPORT,                                              
MFA-TR*          CASH_DRAWER_ID)                                                
MFA-TR*         VALUES                                                          
MFA-TR*         (:AR-ACCOUNT-NO,                                                
MFA-TR*          :AR-TRANS-HIST-SEQ-NO,                                         
MFA-TR*          :AR-DATE-TRANS,                                                
MFA-TR*          :AR-CODE-TRAN-TYPE,                                            
MFA-TR*          :AR-AMT-ORIG-ENTERED,                                          
MFA-TR*          :AR-AMT-BILLED-UNPAID,                                         
MFA-TR*          :AR-RESP-AREA-ID,                                              
MFA-TR*          :AR-APPL-PROGRAM-ID,                                           
MFA-TR*          :AR-PYMT-FACILITY-CD,                                          
MFA-TR*          :AR-USER-ID,                                                   
MFA-TR*          :AR-COMPANY-NO,                                                
MFA-TR*          :AR-TRAN-COMMENT,                                              
MFA-TR*          :AR-RECORD-ONLY-FL,                                            
MFA-TR*          NULL,                                                          
MFA-TR*          :AR-CASH-COMPANY-NO,                                           
MFA-TR*          :AR-CASH-LOCAL-OFFICE,                                         
MFA-TR*          :AR-CASH-REPORT-NO,                                            
MFA-TR*          :AR-DATE-CASH-REPORT,                                          
MFA-TR*          :AR-CASH-DRAWER-ID)                                            
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8310-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8320-INSERT-AR-TRN-HST-DET.                                      
           EXEC SQL                                                     
              INSERT INTO  CSS_AR_TRN_HST_DET                           
                (ACCOUNT_NO,                                            
                 TRANS_HIST_SEQ_NO,                                     
                 TRAN_APPL_NO,                                          
                 CODE_AR_AGE,                                           
                 GL_ACCT_CREDIT,                                        
                 GL_ACCT_DEBIT,                                         
                 AMT_POSTED,                                            
                 ITEM_ID,                                               
                 CODE_CONTRACT_TYPE,                                    
                 CURRENCY_TYPE,                                         
                 CURRENCY_AMT)                                          
                VALUES                                                  
                (:AU-ACCOUNT-NO,                                        
                 CIS.CHAR2TIMESTAMP(:AU-TRANS-HIST-SEQ-NO),                     
                 :AU-TRAN-APPL-NO,                                      
                 :AU-CODE-AR-AGE,                                       
                 :AU-GL-ACCT-CREDIT,                                    
                 :AU-GL-ACCT-DEBIT,                                     
                 :AU-AMT-POSTED,                                        
                 :AU-ITEM-ID,                                           
                 :AU-CODE-CONTRACT-TYPE,                                
                 :AU-CURRENCY-TYPE,                                     
                 :AU-CURRENCY-AMT)                                      
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO  CSS_AR_TRN_HST_DET                                   
MFA-TR*         (ACCOUNT_NO,                                                    
MFA-TR*          TRANS_HIST_SEQ_NO,                                             
MFA-TR*          TRAN_APPL_NO,                                                  
MFA-TR*          CODE_AR_AGE,                                                   
MFA-TR*          GL_ACCT_CREDIT,                                                
MFA-TR*          GL_ACCT_DEBIT,                                                 
MFA-TR*          AMT_POSTED,                                                    
MFA-TR*          ITEM_ID,                                                       
MFA-TR*          CODE_CONTRACT_TYPE,                                            
MFA-TR*          CURRENCY_TYPE,                                                 
MFA-TR*          CURRENCY_AMT)                                                  
MFA-TR*         VALUES                                                          
MFA-TR*         (:AU-ACCOUNT-NO,                                                
MFA-TR*          :AU-TRANS-HIST-SEQ-NO,                                         
MFA-TR*          :AU-TRAN-APPL-NO,                                              
MFA-TR*          :AU-CODE-AR-AGE,                                               
MFA-TR*          :AU-GL-ACCT-CREDIT,                                            
MFA-TR*          :AU-GL-ACCT-DEBIT,                                             
MFA-TR*          :AU-AMT-POSTED,                                                
MFA-TR*          :AU-ITEM-ID,                                                   
MFA-TR*          :AU-CODE-CONTRACT-TYPE,                                        
MFA-TR*          :AU-CURRENCY-TYPE,                                             
MFA-TR*          :AU-CURRENCY-AMT)                                              
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
       8320-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
P00166 8330-UPDATE-CORR-MAIL-STAT.                                      
P00166                                                                  
P00166     EXEC SQL                                                     
P00166         UPDATE CSS_CORR_MAIL_STAT                                
P00166            SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD      
P00166               ,LAST_UPDATE_TS      = CIS.CURRENT$TIMESTAMP()           
P00166               ,USER_ID             = :MW-USER-ID                 
P00166               ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID         
P00166            WHERE ACCOUNT_NO        = :MW-ACCOUNT-NO              
P00166              AND BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID       
P00166     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CORR_MAIL_STAT                                        
MFA-TR*           SET TRACKING_STATUS_CD  = :MW-TRACKING-STATUS-CD              
MFA-TR*              ,LAST_UPDATE_TS      = CURRENT TIMESTAMP                   
MFA-TR*              ,USER_ID             = :MW-USER-ID                         
MFA-TR*              ,APPL_PROGRAM_ID     = :MW-APPL-PROGRAM-ID                 
MFA-TR*           WHERE ACCOUNT_NO        = :MW-ACCOUNT-NO                      
MFA-TR*             AND BARCODE_UNIQUE_ID = :MW-BARCODE-UNIQUE-ID               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00166                                                                  
P00166     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00166     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
P00166        DISPLAY ' '                                               
P00166        DISPLAY '**8330-UPDATE-CORR-MAIL-STAT**'                  
P00166                ' RETURN CODE=' WS-ACTIVE-RETURN-CODE             
P00166        DISPLAY '**ACCOUNT #  : ' MW-ACCOUNT-NO                   
P00166        DISPLAY '**UNIQUE ID  : ' MW-BARCODE-UNIQUE-ID            
P00166        DISPLAY '**STATUS     : ' MW-TRACKING-STATUS-CD           
P00166        DISPLAY ' '                                               
P00166        PERFORM 9900-ABEND THRU 9900-EXIT                         
P00166     END-IF.                                                      
P00166*                                                                         
P00166 8330-EXIT.                                                       
P00166     EXIT.                                                        
P00166*                                                                         
       8400-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :AR-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :AR-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              DISPLAY '8400-GET-CURRENT-TIMESTAMP'                      
                      ' RETURN CODE=' SQLCODE                           
              PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                        
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8870-PRINT-COUNTERS.                                             
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
           DISPLAY '*****   I/O COUNTERS FOR JCSCA100   *****'.         
           DISPLAY '*****************************************'.         
           DISPLAY ' '.                                                 
           DISPLAY '***** TOTAL RF  UPDATE   = '                        
                     WS-RESTART-RF-UPD-CNTR-TOT.                        
           DISPLAY '***** TOTAL RF  INSERT   = '                        
                     WS-RESTART-RF-ISRT-CNTR-TOT.                       
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
       8870-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8871-PRINT-COUNTERS.                                             
           DISPLAY ' '.                                                 
           DISPLAY '***************************************************'
           DISPLAY '*****   I/O COUNTERS FOR 1 LUW FOR JCSCA100   *****'
           DISPLAY '***************************************************'
           DISPLAY ' '.                                                 
           DISPLAY '*****  ACCOUNT NUMBER JUST PROCESSED = '            
                                                  WS-FDB07-ACCT-NO.     
           DISPLAY ' '.                                                 
           DISPLAY '*****  RF UPDATE = '                                
                     WS-RF-UPDATE-CNTR-LUW.                             
           DISPLAY '*****  RF INSERT = '                                
                     WS-RF-INSERT-CNTR-LUW.                             
           DISPLAY ' '.                                                 
           DISPLAY '*****************************************'.         
      *                                                                         
           MOVE ZERO TO                                                 
               WS-RF-UPDATE-CNTR-LUW                                    
               WS-RF-INSERT-CNTR-LUW.                                   
       8871-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      /   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
      *                                                              **         
      *   8893-RESET-RESTART-REQ-PARM                                **         
      *                                                              **         
      *   *   *   *   *   *   *   *   *   *   *   *   *   *   *   *  **         
           EXEC SQL                                                             
              INCLUDE CPD00029                                                  
           END-EXEC.                                                            
      *                                                                         
       8880-ISSUE-CHKP.                                                 
           MOVE WS-PROCESS-TYPE        TO WS-RESTART-PROCESS-TYPE.      
           ADD 1                       TO WS-CHKP-SEQ-NO.               
           MOVE WS-CHKP-SEQ-NO         TO WS-RESTART-CHKP-SEQ-NO.       
           MOVE WS-RPT-SAVE-ACCT-NO    TO WS-RESTART-RPT-SAVE-ACCT-NO.  
           MOVE WS-PRINT-SAVE-ACCT-NO  TO WS-RESTART-PRINT-SAVE-ACCT-NO.
PCR473     MOVE WS-DEAD-HORSE-COUNT    TO WS-RESTART-EXCEPTION-CTR.     
           MOVE LS-FCSBE21-REC-CNTR  TO WS-RESTART-FCSBE21-REC-CNTR     
           MOVE LS-FCSWK05-REC-CNTR  TO WS-RESTART-FCSWK05-REC-CNTR     
TP2878     MOVE LS-FCSRP112-REC-CNTR TO WS-RESTART-FCSRP112-REC-CNTR    
           IF WS-REPOSITION-NEEDED = WS-N                               
             IF WS-PROCESS-TYPE > 1                                     
                MOVE WS-13-NINES    TO WS-RESTART-ACCOUNT-NO            
             ELSE                                                       
      ************ THIS CHECKPOINT IS THEREFORE THE INITIAL ONE                 
                MOVE ZEROS          TO WS-RESTART-ACCOUNT-NO            
             END-IF                                                     
           ELSE                                                         
              MOVE WS-FDB07-ACCT-NO    TO WS-RESTART-ACCOUNT-NO         
           END-IF.                                                      
      *****************************************************************         
      *    ACCUMULATOR FILES (WK00, WK02) NEED TO BE WRITTEN AT                 
      *    EACH CHECKPOINT. ACCUMULATORS ARE RESET.  THE PROCESSING             
      *    PROGRAMS WILL AGREGATE THE VARIOUS RECORDS. NOTE THAT                
      *    THIS IS SUPERFLUOUS FOR THE INITIAL CHECKPOINT.                      
T14505*  INITIAL CHECKPOINT WAS REMOVED.                                        
      *****************************************************************         
T14505*    IF WS-CHKP-SEQ-NO > 1                                                
              IF WS-HOLD-DB07-ENTRY (1) NOT = SPACES                    
                 PERFORM 4000-WRITE-SUMMARY-FILES THRU 4000-EXIT        
              END-IF                                                    
T7882         INITIALIZE WS-LOCAL-AND-TOTAL-ACCUM-TABLE                 
T11745                   WS-LOCAL-ACCUM-HOLD                            
                         WS-LOCAL-OFFICE-REVENUE-TABLE                  
                         WS-WNA-REVENUE-SUMMARY-TABLE                   
                         WS-HOLD-DB07-FOR-RESTART                       
              SET WS-DB07-INDX TO 1                                     
T7882         PERFORM VARYING WS-WFT-INDEX FROM 1 BY 1                  
T7882           UNTIL WS-WFT-INDEX > 100                                
T7882            MOVE ZERO TO WS-ACCUM-USAGE-WFT (WS-WFT-INDEX)         
T7882         END-PERFORM                                               
T14505*    END-IF.                                                              
           PERFORM 8890-MAINTAIN-RESTART THRU 8890-EXIT.                
           EXEC SQL                                                     
               COMMIT                                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'           
                   'LAST ACCOUNT NO PROCESSED=' WS-RESTART-ACCOUNT-NO.  
       8880-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8890-MAINTAIN-RESTART.                                           
           MOVE WS-PGRMNAME    TO RF-NAME-PROGRAM.                      
           MOVE WS-PART-NO     TO RF-PARTITION-NO.                      
           MOVE 1              TO RF-DUP-CNTRL-NO.                      
           MOVE WS-RESTART-DATA     TO RF-RESTART-DATA-TEXT.            
           MOVE WS-RESTART-DATA-LEN TO RF-RESTART-DATA-LEN.             
           PERFORM 8910-UPDATE-RESTART THRU 8910-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 8911-INSERT-RESTART THRU 8911-EXIT
           END-IF.              
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8910-UPDATE-RESTART.                                             
           EXEC SQL                                                     
                UPDATE CSS_RESTART                                      
                SET RESTART_DATA   = :RF-RESTART-DATA                   
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM  AND              
                      PARTITION_NO = :RF-PARTITION-NO  AND              
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1  TO WS-RESTART-RF-UPD-CNTR-TOT                      
              ADD 1  TO WS-RF-UPDATE-CNTR-LUW                           
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '8910-UPDATE-RESTART'                            
                       ' RETURN CODE=' WS-ACTIVE-RETURN-CODE            
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
       8910-EXIT.                                                       
           EXIT.                                                        
      /                                                                         
       8911-INSERT-RESTART.                                             
           EXEC SQL                                                     
                INSERT INTO CSS_RESTART                                 
                (NAME_PROGRAM, PARTITION_NO,                            
                 DUP_CNTRL_NO, RESTART_DATA)                            
                VALUES                                                  
                (:RF-NAME-PROGRAM, :RF-PARTITION-NO,                    
                 :RF-DUP-CNTRL-NO, :RF-RESTART-DATA)                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1  TO WS-RESTART-RF-ISRT-CNTR-TOT                     
              ADD 1  TO WS-RF-INSERT-CNTR-LUW                           
           ELSE                                                         
               DISPLAY '8911-INSERT-RESTART'                            
                       ' RETURN CODE=' WS-ACTIVE-RETURN-CODE            
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8911-EXIT.                                                       
           EXIT.                                                        
       8990-WRITE-RETRY-DB07.                                           
                                                                        
       8990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      /*****************************************************************        
      *                                                                *        
      *     9000-TERMINATE                                             *        
      *                                                                *        
      *     CLOSE FILES                                                *        
      *                                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
           CLOSE FCSDB07-FILE                                           
                 FCSBE00-FILE                                           
                 FCSBE01-FILE                                           
                 FCSWK02-FILE                                           
                 FCSWK03-FILE                                           
DC               FCSWK04-FILE                                           
                 FCSWK05-FILE                                           
                 FCSBE21-FILE                                           
ACT364           FCSWK06-FILE.                                          
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /*****************************************************************        
      *                                                                *        
      *     9700-PROCESS-ABEND                                         *        
      *                                                                *        
      ******************************************************************        
TP5228 COPY CPD0023B.                                                           
      /*****************************************************************        
      *                                                                *        
      *     9900-ABEND                                                 *        
      *                                                                *        
      *     CLOSE FILES                                                *        
      *                                                                *        
      ******************************************************************        
       9900-ABEND.                                                      
           PERFORM 9910-ROLLBACK             THRU 9910-EXIT             
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
           DISPLAY 'PCSCA100 ABEND INITIATED'                           
           CALL ILBOABN0 USING WS-USER-ABEND-CODE.                      
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9910-ROLLBACK.                                                   
           EXEC SQL                                                     
              ROLLBACK                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9920-COMMIT.                                                     
           EXEC SQL                                                     
              COMMIT                                                    
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       9920-EXIT.                                                       
           EXIT.                                                        
                                                                        
