       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSCA099.                                           
       DATE-WRITTEN.  10/10/00.                                         
       DATE-COMPILED.                                                   
       AUTHOR.         SRIDEVI                                          
      *****************************************************************         
      **                                                             **         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      **                  CUSTOMER SERVICE SYSTEM                    **         
      **                         DB2                                 **         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      **                                                             **         
      ** 09/29/00   AS82045        DEVELOPMENT OF NEW PROGRAM        **         
T22308** 04/11/01   AS82045        COMMENTED CODE THAT DROPS AN ACCT **         
T22308**            COVANSYS       FROM DPP, WHICH WILL BE HANDLED   **         
T22308**                           BY TPR 23957 SOME TIME LATER      **         
T23238** 05/10/01   COVANSYS       DPP AUTO DROP FOR PSNC            **         
T25075** 09/19/01   JS83520        ABEND WITH APPROPRIATE MESSAGE    **         
T25075**                           IF NO DATA RECORDS FOUND          **         
C25165** 09/26/01   DL85939        DCLGEN INCLUDED FOR BILL-WINDOW   **         
C25165**                           - REQUIRED IN CPD00317            **         
C25416** 10/16/01   DL85939        FIXED FOR PSNC ACCTS THAT DROPPED **         
C25416**                           EPP WHICH SHOULD NOT HAVE DROPPED **         
T23339** 10/24/01   EM19682        ADDED CODE FOR 1RATE DROP.        **         
T26415** 06/26/02   AS82045        CODE CHANGED TO PREVENT AN ACCOUNT**         
T26415**                           FROM DROPPING FROM DFA            **         
T26264** 07/01/02   EM19682        ADDED CODE FOR SKYMILES DROP.     **         
T26531** 07/11/02   DL85939     1. PSNC ACCTS SHOULD DROP DPP WHEN   **         
T26531**                           THE UTIL BALANCE IS > DPP DELINQ  **         
T26531**                           VALUE.                            **         
T26531**                        2. THE DPP SHOULD NOT BE DROPPED WHEN**         
T26531**                           THERE'S A CANCEL/REBILL IMMEDIATE **         
T26531**                           OR FUTURE.                        **         
C27405** 09/04/02   SRIDEVI        SEASONAL OFF ACCOUNTS ON EPP SHOULD*         
C27405**                           PRINT THE ANNIVERSARY BILL. TO    **         
C27405**                           ACCOMPLISH THIS POPULATING BG & CX**         
C27405**                           TABLES WITH THE MISSING DATA      **         
T26877** 10/30/02   EM19682        ADDED CODE FOR PPP DROP.          **         
T27989** 11/22/02   LAT            DO NOT DROP 1RATE AND EPP WHEN    **         
T27989**                           THERE IS A CANCEL/REBILL IMMEDIATE**         
T27989**                           ALSO, THE REBILL ROW SHOULD BILL  **         
T27989**                           WITH THE SAME RATE AS THE BACKOUT **         
T27989**                           ROW.                              **         
C27405** 03/17/03   SRIDEVI        CREATE AN MNT ROW FOR SEASONALLY  **         
C27405**                           OFF ACCOUNTS WHEN BG, CX INSERTS  **         
C27405**                           ARE DONE FOR MISSING DATA         **         
C28788** 07/03/03   MDJ            GET IVR-EXEMPT-CD TO CPD00068.    **         
T28515** 10/02/03   S. MOSES       DROP LOGIC FOR RATE 635 AND 655.  **         
T28515** 12/03/03   S. MOSES       SYSTEM ATTEMPTED TO UPDATE WHEN   **         
C28515**                           WS-NUM-MONTHS EQUAL ZERO          **         
T30122** 02/18/04   S. MOSES       UPDATE CODE WHERE ONERATE_ANNIV_MO**         
T30122**                           AND EFF_DATE_TO WON'T UPDATE FOR  **         
T30122**                           ENERGY AMERICA ACCOUNTS.          **         
T30122** 03/16/04   S. MOSES       REMOVE RATE PLAN 808 AND 809      **         
T30122**                           FROM 1200-CHK-IF-1RATE-ACCT IN    **         
T30122**                           ORDER TO PREVENT AN ABEND, FURTHER**         
T30122**                           RESEARCH TO BE DONE.              **         
T29872** 04/01/04   S. MOSES       DROP LOGIC FOR RATE 800-803.      **         
T30122** 05/27/04   S. MOSES       DROP LOGIC FOR RATE 804-807.      **         
C29815** 09/07/04   S. MOSES       REVERSE BACK THE CIA DURING       **         
C29815**      PRE-BILLING FOR THE MONTH AFTER ANNIVERSARY AND JOURN- **         
C29815**      ALLING. MORE WORK NEEDS TO BE DONE, PER MANY CHANGES   **         
C29815**      OF SPECS (UNCLEAR AND NOT INFORMED BEFORE HAND), ALL   **         
C29815**      IS AWARE OF BY D. PERDUE-SHUPE AND L. SANDERS.         **         
T30766** 09/07/04   S. MOSES       DROP LOGIC FOR RATE 285-290.      **         
T30766**                           AND RATE 800-807.                 **         
C29815** 10/28/04   S. MOSES       EPP/CIA CHANGES BASED ON ABENDS   **         
C29815**                           AND SPEC CHANGES.  DELETION OF    **         
C29815**                           CSS_AR_CNTL (CREDIT IN ADVANCE)   **         
T31347** 02/07/05   S. MOSES       PHASE 2 OF 2004 FALL CAMPAIGNS    **         
T32200** 03/02/05   S. MOSES  UPDATE SR RATES DROPPING TO 100 TO GO  **         
T32200**                      TO 120 IF THEY HAVE AN 8.95 CSC        **         
C32821**  06/05     WR19680   CHANGED EPP ANNIVERSARY DATE ROUTINE   **         
C32821**                      TO USED REVENUE MONTH LAST NORMAL      **         
C32821**                      INSTEAD OF JOB PARM REVENUE MONTH TO   **         
C32821**                      TAKE OF PROBLEM WITH 2 REVENUE MONTHS  **         
C32821**                      OPEN THE SAME TIME.                    **         
AGLPRO**                      UPDATED THE ANNIVERSARY MONTH FOR ONE  **         
AGLPRO**                      RATE CUSTOMERS WHILE BILLING INITIAL   **         
AGLPRO**                      BILL WITH NO CONSUMPTION (CML 32043)   **         
T32579** 09/06/05   RH15956   CHANGES FOR 2005 FALL MARKETING CAMPAIN**         
C32676** 10/01/05   RH15956   CHANGES FOR 2005 GAS RATE CASE.  ADD   **         
C32676**                      CODE TO HANDLE SEASONAL BLOCK CHARGE.  **         
C33502** 10/16/05   RH15956   INSURE THAT BG-RATE-PLAN-NO IS ALWAYS  **         
C33502**                      POPULATED.                             **         
C33042** 12/13/05   RH15956   CHANGES FOR 2005 FALL MARKETING CAMPAIN**         
C33442** 02/06/06   RH15956   SEB-EMC CONVERSION.  EPP AND ONE RATE  **         
C33442**                      DROP ARE MUTUALLY EXCLUSIVE FOR COBB   **         
C33442**                      AND SNAPPING SHOALS ACCOUNTS.          **         
C33023** 02/20/06   NC94746   AGL METER CHARGE CHANGES FOR SEB       **         
C33023**                      ACCOUNTS. A FIXED FACTOR VALUE WILL    **         
C33023**                      BE CHARGED FOR EACH METER READ.        **         
T33215** 04/03/06   JC91900   CLEAN UP THE CODE AND DISPLAY CORRECT  **         
T33215**                      DUMP INFO WHEN PROGRAM ABENDS.         **         
C33462** 04/10/06   DB41297   ALLOW EXCLUDED ACCOUNTS TO BE BYPASSED.**         
C33415** 06/25/06   GANESH    CHANGES MADE TO CHARGE SEASONAL BLOCK  **         
C33415**                      CHARGE ONCE DURING BILLING.            **         
C33934** 06/28/06   JS83520   DROP EPP IF ACCTS 1ST BILL SETUP ON    **         
C33934**                      NEXT BILL AND IS IN ARREARS SIMILAR TO **         
C33934**                      CURRENT BILL LOGIC                     **         
C34324** 07/21/06   DB41297   FIX -811 PROBLEM WHEN 2 ACCOUNTS HAVE  **         
C34324**                      THE SAME DATE_UTIL_SVC_END             **         
C34571** 07/28/06   DB41297   NEW HARD CODED RATE CHANGES FOR FALL   **         
C34571**                      2006 CAMPAIGN.                         **         
T33182** 07/29/06    DB41297       PERFORMANCE IMPROVEMENTS.         **         
C34709** 08/18/06   DB41297   FIX PROBLEM WITH SEASONAL BLOCK.       **         
C34709** 09/11/06   SS95855   FIX PROBLEM WITH SEASONAL BLOCK.       **         
C34440** 09/26/06   SS95855   ONERATE_ANNIV_MO NEEDS TO ZERO OUT     **         
C34440**                      WHEN FIXED RATE IS CHANGED TO VARIABLE **         
C34440**                      RATE                                   **         
C35160** 12/08/06   RH15956   INSURE THAT THE BG-RATE-PLAN-NO IS     **         
C35160**                      POPULATED WHEN RETRIEVING BFC AMOUNT.  **         
C34983** 12/04/06   SS95855   RETRIEVE FREECSC AND DROPRATE FROM     **         
C34983*                       RATE ATTRIBUTE TABLE.                  **         
C34983*                       FOLLOWING NEW RATES ADDED.             **         
C34983*                       RATES 703,713,149,150,151,152,153,154, **         
C34983*                             940.                             **         
C34983*                       FIX : 891,892,893,894,895,896,860,862, **         
C34983*                             863,864.                         **         
T35129** 01/01/07   JC91900   DISCONTINUE PULLING CC '~' ON SCEG.    **         
C36197*  09/11/07   VP94820   SELECTING CODE_STATUS_REASON COLUMN               
C34569*  01/07/08   VP94820   SEB RATE RE-ENGINNERING CHANGES        **         
C34569*                       - REMOVED BILLING PORTION OF THE CODE  **         
C34569*                       - EPP DROP FOR ONE-RATE &              **         
C34569*                         NOT-RENEWED-ON-1-RATE ACCOUNTS       **         
C37469** 10/09/08   JC91900   SET DURATION REMAINING TO NULL FOR     **         
C37469**                      SEABLK FACTORS.                        **         
C37207** 09/22/08   SK42147   FOR EPP ANNIV. ACCOUNTS DISTRIBUTE CIA **         
C37422** 09/22/08   SK42147   INSERT RCC TAX FACTOR FOR ACCOUNTS     **         
C37422**                      WITH RCC CHARGE HAS NOT BEEN POSTED AND**         
C37422**                      HAS PRE-PAYMENT (SEB DATABASE ONLY).   **         
C36956** 10/29/08   RC41079   BUDGET BILLING - CHANGED ALL MESSAGES  **         
C36956**                      WITH EPP TO BBP.                       **         
C35597** 03/04/09   SS95855   REMOVE FACTOR ID AGLMTCHRG             **         
P00141** 04/14/09   SS97726   ADD START/END DATE TO OPT_ATTR_INCTV   **         
A01542** 08/25/09   SK42147 1)CHECK ON BBP DROP FOR RENEWAL ONLY IF  **         
A01542**                      BBP AND FIXED PRICE ARE IN SYNCH.(SEB) **         
A01542**                    2)UPDATE CODES-DATA-PRESENT FOR CIA      **         
A01542**                      CORRECTLY.                             **         
A00388** 11/11/09   GD97441   REMOVED DURATION REMAINING UPDATE LOGIC**         
A00388** 11/17/09   GD97441   DELETE CSS_FIXED_FCTR SEASONAL BLOCK   **         
A00388**                      FIXED FACTOR UPDATE LOGIC.             **         
A00388** 12/29/09   GD97441   DELETE SEABLK FACTOR CALCULATION LOGIC.**         
A02036** 05/13/10   SK42147   CHANGE FOR CSR DROP - DON'T CHECK ON    *         
A02036**                      CURRENT BALANCE. DROP BASED ON ARREARS  *         
A00755** 05/20/10   VP94820   BUMP-UP BBP ANNIVERSARY DATE.          **         
A02364** 06/03/10   SK42147   REMOVE RATE RELATED BBP DROP FOR SEB   **         
P00307*  07/15/10   SK42147   DROP DELETE BBP_REVIEW_EXEMPT from      *         
P00307*                       CSS_ACCT_ATTRIBUTE                      *         
P00307*                     (A) FOR BBP DROP (B) DURING ANNIVERSARY   *         
A00755** 08/20/10   SP95538   BBP TRANSACTION COMMENT LENGTH REDUCED  *         
A00755**                      FROM 47 TO 30 AND ADDED TRANS COMMENT.  *         
A00755** 09/24/10   SP95538   REMOVED THE LOGIC FOR TRUNCATING EXCESS *         
A00755**                      BBP COMMENT LENGTH.                     *         
A02036** 11/12/10   VP94820   FIX THE ISSUE WITH SEARCH WHEN 2 REVENUE*         
A02036**                      MONTHS OPENED.                          *         
ACT088** 12/28/10   BG17805   CHANGE P2500 TO CHECK FOR 12 MONTHS     *         
ACT088**            APP02034  DIFF AND IF 12 ONLY THEN EXEC NEXT      *         
ACT088**                      PERFORM                                 *         
ACT003** 01/03/11   VIJAY     Do not drop accounts from BBP, if the   *         
ACT003** A03106               account has any exempts set for either  *         
ACT003**                      LPC or Notice or DNP set on the account.*         
ACT003** *                                                                      
ACT004** 01/03/11   VIJAY  FIRST MONTH AFTER ACCOUNT SET UP ON BBP::  *         
ACT004** A03106            Check for 30 + 60 + 90 >= $5(Delq Value)   *         
ACT004**                   and full balance >=50 (Delq Value )        *         
ACT004**                   drop the account from BBP                  *         
ACT004** *                                                                      
ACT004**                   ANY OTHER MONTH ::                         *         
ACT004**                   Check for 00 + 30 + 60 + 90 >= $5(delq     *         
ACT004**                   value) and full balance >=50 (Delq value)  *         
ACT004**                   drop the account from BBP                  *         
ACT004**                                                              *         
P00506** 04/14/11   VV94890 SEB - ROLL CREDIT ACCOUNT BALANCE INTO    *         
P00506**                    BUDGET BILLING ANNIVERSARY.               *         
P00471** 08/17/11   SP95538 1.ADDED DPP DROP LOGIC.                   *         
P00471**                    2.REMOVED CPD00109 RELATED CURSORS.       *         
P00471**                    3.REMOVED DELTA DROP CODE.                *         
ACT174** 08/29/11   VIJAY   Drop accounts from BBP, if the account    *         
ACT174** A03082             has INDEF - NON-UTL(B) exempt.            *         
P00471** 09/23/11   AA97148 ADDED CHECK FOR THE ACCOUNT IS GOING FOR  *         
P00471**                    BILLING 1ST MONTH AFTER ANNIVERSARY.      *         
P0471A** 11/01/11   GOKUL   CHANGES TO SUPPORT CPD00109 ONLINE        *         
P0471A**                    JOURNALING.                               *         
ACT036** 04/12/12   VIJAY   FIX BILLED BALANCE AT BBP ANNV. WITH CIA  *         
ACT036** A03967             PRESENT.                                  *         
P00794** 05/27/14   VIJAY 1.INSERT RECCHGTAX FOR PSNC. AND ALSO DELE- *         
P00794**                    TED WQ PROCESS AND IT'S CODE.             *         
P00794**                  2.ADD BH.LAST_UPDATE_USERID IN INSERT/UPDATE*         
      **                                                              *         
A05154** 15 JAN 2015 RF10596 CLEAN UP PROGRAM                         *         
      **                                                              *         
      *****************************************************************         
      *                   PCSCA099  NARRATIVE                         *         
      *                                                               *         
      * THIS PROGRAM IS TO BE RUN BEFORE BILLING. IT IDENTIFIES ALL   *         
      * THE ACCOUNTS THAT ARE TO BE EXEMPT FROM EPP AND DROPS THEM    *         
      * THERE BY PUTTING THE AMOUNT FROM 0 DAY, 30 DAY, 60 DAY AND 90 *         
      * DAY BUCKETS INTO THE 0 DAY BUCKET OF THE RECV UTE OR UTG OR   *         
      * BOTH. ALSO IDENTIFIES ACCOUNTS THAT ARE TO BE EXEMPT FROM DPP *         
      * AND DROPS THEM THERE BY PUTTING THE AMOUNT FROM 0 DAY, 30 DAY *         
      * 60 DAY AND 90 DAY BUCKETS INTO THE APPROPRIATE BUCKETS OF THE *         
      * RECV UTE, UTG RCC OR CONTRACT                                 *         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                2000 - 2999     OUTPUT PROCESSING CONTROL PATH          
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
       COPY CSSDB07.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA099'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FDB07-STATUS                 PIC X(02).               
               88 FDB07-SUCCESSFUL                       VALUE '00'.    
           05  WS-END-OF-FILE                  PIC X(01) VALUE 'N'.     
               88 END-OF-FILE                            VALUE 'Y'.     
T25075     05  WS-RECORD-FOUND                 PIC X(01) VALUE 'N'.     
T25075         88 DATA-RECORD-FOUND                      VALUE 'Y'.     
T25075         88 NO-DATA-RECORD-FOUND                   VALUE 'N'.     
           05  WS-BEGIN-REC-SW                 PIC X(01) VALUE 'N'.     
               88 WS-BEGIN-RECS-PROCESSED                VALUE 'Y'.     
           05  WS-DATABASE                     PIC 9(01) VALUE ZERO.    
               88 CSR-DATABASE                           VALUE 1.       
               88 SEB-DATABASE                           VALUE 2.       
           05  WS-DFA-RECV-SW                  PIC X(01) VALUE 'N'.     
               88 RECV-DONE                              VALUE 'Y'.     
           05  WS-EPP-EXISTS                   PIC X(01) VALUE 'N'.     
               88 EPP-EXISTS                             VALUE 'Y'.     
               88 NOT-EPP-EXISTS                         VALUE 'N'.     
T23238     05  WS-DPP-EXISTS                   PIC X(01) VALUE 'N'.     
T23238         88 DPP-EXISTS                             VALUE 'Y'.     
T26264     05  WS-MESG-DATE-CHK-SW             PIC X(01) VALUE 'N'.     
T26264         88 MESG-DATE-OK                           VALUE 'Y'.     
T26264     05  WS-DROP-DATE-CHK-SW             PIC X(01) VALUE 'N'.     
T26264         88 DROP-DATE-OK                           VALUE 'Y'.     
C27405     05  WS-SEASONAL-RATE-ACCT           PIC X(01) VALUE 'N'.     
C27405         88 SEASONAL-RATE-ACCT                     VALUE 'Y'.     
C34709     05  WS-OLD-ACC-HSTRY                PIC X(01) VALUE 'N'.     
C34709         88 HSTRY-EXISTS                           VALUE 'Y'.     
C34709         88 NO-HSTRY-EXISTS                        VALUE 'N'.     
C33442     05  WS-EXT-BILLING-FL               PIC X(1)  VALUE ' '.     
C33442         88 COBB-OR-SNAPPING-SHOALS                VALUE 'S' 'C'. 
A00755*                                                                         
A00755     05  WS-REV-MNTH-FOUND-SW            PIC X(1).                
A00755         88 REV-MNTH-FOUND                         VALUE 'Y'.     
A00755         88 REV-MNTH-NOT-FOUND                     VALUE 'N'.     
      *                                                                         
ACT004*                                                                         
ACT004     05  WS-FIRST-MTH-AFTER-SETUP        PIC X(01).               
ACT004         88 FIRST-MTH-AFTER-SETUP                  VALUE 'Y'.     
ACT004         88 NOT-FIRST-MTH-AFTER-SETUP              VALUE 'N'.     
      *                                                                         
P00471     05  WS-DPP-IND-DELINQ-VALUE         PIC 9(01) VALUE ZERO.    
P00471         88 DPP-DROP-ALL                            VALUE 1.      
P00471         88 DPP-DROP-BILLING                        VALUE 2.      
P00471         88 DPP-DROP-DNP                            VALUE 3.      
P00471         88 NO-DPP-DROP                             VALUE 4.      
      *                                                                         
P00471     05  WS-DPP-GP1-DELINQ-VALUE         PIC 9(01) VALUE ZERO.    
P00471         88 REG-GP1-ALL                            VALUE 1.       
P00471         88 REG-GP1-BILLING                        VALUE 2.       
P00471         88 REG-GP1-DNP                            VALUE 3.       
P00471         88 REG-GP1-NO-DROP                        VALUE 4.       
      *                                                                         
P00471     05  WS-DPP-GP2-DELINQ-VALUE         PIC 9(01) VALUE ZERO.    
P00471         88 REG-GP2-ALL                            VALUE 1.       
P00471         88 REG-GP2-BILLING                        VALUE 2.       
P00471         88 REG-GP2-DNP                            VALUE 3.       
P00471         88 REG-GP2-NO-DROP                        VALUE 4.       
      *                                                                         
P00453     05  WS-FIRST-MONTH-AFTER-ANNIV      PIC X(01) VALUE 'N'.     
P00453         88 FIRST-MONTH-AFTER-ANNIV                VALUE 'Y'.     
P00453         88 NOT-FIRST-MONTH-AFTER-ANNIV            VALUE 'N'.     
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-D                            PIC X(01) VALUE 'D'.     
           05  WS-E                            PIC X(01) VALUE 'E'.     
           05  WS-F                            PIC X(01) VALUE 'F'.     
           05  WS-G                            PIC X(01) VALUE 'G'.     
           05  WS-J                            PIC X(01) VALUE 'J'.     
           05  WS-N                            PIC X(01) VALUE 'N'.     
           05  WS-R                            PIC X(01) VALUE 'R'.     
           05  WS-U                            PIC X(01) VALUE 'U'.     
           05  WS-Y                            PIC X(01) VALUE 'Y'.     
           05  WS-0                            PIC 9(01) VALUE 0.       
           05  WS-01                           PIC S9(4) USAGE COMP     
                                                         VALUE 1.       
           05  WS-50                           PIC S9(4) USAGE COMP     
                                                         VALUE 50.      
           05  WS-90                           PIC S9(4) USAGE COMP     
                                                         VALUE 90.      
           05  WS-100                          PIC S9(4) USAGE COMP     
                                                         VALUE 100.     
T26264     05  WS-SKYMILE-COMMENT              PIC X(49) VALUE          
T26264         'ACCT DROPPED FROM SKYMILES PROGRAM DUE TO ARREARS'.     
T26877     05  WS-PPP-EPP-COMMENT              PIC X(29) VALUE          
T26877         'ACCT DROPPED FROM PPP AND BBP'.                         
T26877     05  WS-PPP-COMMENT                  PIC X(21) VALUE          
T26877         'ACCT DROPPED FROM PPP'.                                 
T28515     05  WS-ANNIV-DT-COMMENT             PIC X(51) VALUE          
T28515         'ANNIV DATE UPDATED TO CORRESPOND WITH FIRST BILLING'.   
C34569     05  WS-BBP-DROP-COMMENT           PIC X(32) VALUE            
C34569         'ACCT DROPPED FROM BUDGET BILLING'.                      
C37422     05 WS-RCC-COMMENT                 PIC X(45) VALUE            
C37422         'INSERT RCC - CHARGE AMOUNT TO BE TAXED ONLY.'.          
A00755     05  WS-BBP-MNT-COMMENT            PIC X(30) VALUE            
A00755         ';BBP DATES UPDT BY PRE-BILLING'.                        
A00755     05  WS-MNT-COMMENT                PIC X(32) VALUE            
A00755         'BBP DATES UPDATED BY PRE-BILLING'.                      
      *                                                                         
       01  WS-VARIABLES.                                                
           05  PROGRAM-NAME                    PIC X(08) VALUE          
                                                         'PCSCA099'.    
           05  WS-PGRMNAME                     PIC X(08) VALUE          
                                                         'PCSCA099'.    
           05  SCSCB068                        PIC X(08) VALUE          
                                                         'SCSCB068'.    
           05  RS-RETURN-CODE                  PIC S9(9) VALUE          
               +000 COMP.                                               
           05  RS-RETURN-CODE-DISP             PIC S9(9) VALUE          
               +000 COMP.                                               
           05  WS-COMMON-DATE                  PIC X(10) VALUE SPACES.  
           05  WS-DT-55-DAYS-AGO               PIC X(10) VALUE SPACES.  
           05  WS-DT-85-DAYS-AGO               PIC X(10) VALUE SPACES.  
P0471A     05  CMN-USER-ID                     PIC X(07) VALUE SPACES.  
           05  WS-DAY-60-UTL-RELATED-DELINQ    PIC S9(9)V99 COMP-3      
                                                         VALUE ZERO.    
           05  WS-DAY-90-UTL-RELATED-DELINQ    PIC S9(9)V99 COMP-3      
                                                         VALUE ZERO.    
P00471     05  WS-EXCEL-EARNEST-AMT            PIC S9(09)V99 COMP-3     
P00471                                                   VALUE ZERO.    
           05  WS-REL-DATE                     PIC X(10) VALUE SPACES.  
C27405     05  WS-POP-ANNIV-DATA               PIC X(01) VALUE 'N'.     
C29815     05  WS-REV-MNTH-HOLD.                                        
C29815         10 WS-REV-YY-HOLD               PIC 9(04).               
C29815         10 WS-REV-MM-HOLD               PIC 9(02).               
C29815     05  WS-INPUT-DATE-REV.                                       
C29815         10 WS-INPUT-YY-REV              PIC X(04).               
C29815         10 WS-DASH1-REV                 PIC X(01) VALUE '-'.     
C29815         10 WS-INPUT-MM-REV              PIC X(02).               
C29815         10 WS-DASH2-REV                 PIC X(01) VALUE '-'.     
C29815         10 WS-INPUT-DD-REV              PIC X(02) VALUE '01'.    
A00755*                                                                         
A00755     05  WS-PYMT-STRT-DT                 PIC X(10) VALUE SPACES.  
A00755     05  WS-ANNIV-DT-CUR                 PIC X(10) VALUE SPACES.  
A00755     05  WS-ANNIV-DT-NEW                 PIC X(10) VALUE SPACES.  
A00755     05  WS-REV-MNTH-DT.                                          
A00755         10 WS-REV-MNTH-YYYY             PIC X(04).               
A00755         10 FILLER                       PIC X(01) VALUE '-'.     
A00755         10 WS-REV-MNTH-MM               PIC X(02).               
A00755         10 WS-REV-MNTH-DD               PIC X(03) VALUE '-01'.   
COB305     05 WS-REV-MNTH-OLDEST        PIC S9(06)V COMP-3 VALUE 0.     
COB305     05 WS-REV-MNTH-PREV        PIC S9(06)V COMP-3 VALUE 0.     
A00755     05  WS-REV-MNTH-CUR                 PIC 9(06) VALUE ZEROS.   
A00755     05  WS-BIL-CYCLE                    PIC X(02) VALUE ZEROS.   
A00755     05  WS-INDEX                        PIC 9(02)  VALUE ZERO.   
A00755*                                                                         
C29815     05  WS-1ST-MNTH-ANNIV-DT            PIC X(10).               
COB305     05 WS-LAST-ACCT-PROCESS        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.
C29815     05  WS-TOTAL-AR-BALANCE             PIC S9(09)V99            
C29815                                             COMP-3 VALUE +0.     
COB305     05 WS-BG-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.
C27405     05  WS-BG-BILL-NO                   PIC S9(9) USAGE COMP     
C27405                                                   VALUE ZERO.    
C27405     05  WS-BG-IC-NO                     PIC S9(4) USAGE COMP     
C27405                                                   VALUE ZERO.    
C27405     05  WS-BG-CODE-UTIL-TYPE            PIC X(01) VALUE SPACES.  
C27405     05  WS-BG-BILL-ITEM-TIMESTMP        PIC X(26) VALUE SPACES.  
C27405     05  WS-BG-CODE-REVENUE-CLASS        PIC X(03) VALUE SPACES.  
C27405     05  WS-BG-RATE-PLAN-NO              PIC X(03) VALUE SPACES.  
C27405     05  WS-BG-COMPANY-NO                PIC X(02) VALUE SPACES.  
C27405     05  WS-BG-REVENUE-MONTH             PIC S9(6)V USAGE COMP-3  
C27405                                                   VALUE ZERO.    
C27405     05  WS-CX-MTR-REF-NO                PIC S9(4) USAGE COMP     
C27405                                                   VALUE ZERO.    
C27405     05  WS-CX-METER-NO                  PIC X(09) VALUE SPACES.  
C27405     05  WS-CX-EMPLOYEE-NO               PIC S9(9) USAGE COMP     
C27405                                                   VALUE ZERO.    
C27405     05  WS-CX-CONSTANT                  PIC S9(6)V9(5) USAGE     
C27405                                             COMP-3 VALUE ZERO.   
C27405     05  WS-CX-NO-DIALS                  PIC S9(4) USAGE COMP     
C27405                                                   VALUE ZERO.    
C27405     05  WS-CX-CODE-METER-READ           PIC X(01) VALUE SPACES.  
C27405     05  WS-CX-METER-READING             PIC S9(11)V USAGE COMP-3 
C27405                                                   VALUE ZERO.    
C27405     05  WS-CX-DATE-READ.                                         
C27405         10 WS-CX-CCYY                   PIC X(04).               
C27405         10 FILLER                       PIC X(01) VALUE '-'.     
C27405         10 WS-CX-MM                     PIC X(02).               
C27405         10 FILLER                       PIC X(01) VALUE '-'.     
C27405         10 WS-CX-DD                     PIC X(02) VALUE '01'.    
C27405     05  WS-REVENUE-MONTH-NUM            PIC 9(06) VALUE 0.       
C27405     05  WS-REVMTH-12MTHS-AGO            PIC 9(06) VALUE 0.       
C27405     05  WS-SPLIT-REVMTH.                                         
C27405         10  WS-SPLIT-YEAR               PIC 9(04)  VALUE 0.      
C27405         10  WS-SPLIT-MONTH              PIC 9(02)  VALUE 0.      
C27405     05  WS-HOLD-REVENUE-MONTH           PIC S9(06) COMP VALUE 0. 
           05  WS-REVENUE-MTH-NULL-1           PIC S9(04) COMP VALUE +0.
C27405     05  WS-NULL-INDICATOR               PIC S9(04) COMP VALUE +0.
C27405     05  WS-NULL-IND-EFF-TO              PIC S9(04) COMP VALUE +0.
           05  WS-EPP-DELINQ-CD                PIC X(13) VALUE          
                                               'AMT-EPPDELINQ'.         
           05  WS-AMT-EPP-DELINQ-CD            PIC X(14) VALUE          
                                               'AMT-EPPFULLBAL'.        
           05  WS-DPP-DELINQ-CD                PIC X(12) VALUE          
                                               'AMT-DPP-DROP'.          
P00471     05  WS-DPP-IND-DELINQ-CD            PIC X(14) VALUE          
P00471                                         'DPP-DROP-IND'.          
P00471     05  WS-DPP-GP1-DELINQ-CD            PIC X(14) VALUE          
P00471                                         'DPP-DROP-GP1'.          
P00471     05  WS-DPP-GP2-DELINQ-CD            PIC X(14) VALUE          
P00471                                         'DPP-DROP-GP2'.          
           05  WS-DPP-DELINQ-VALUE             PIC S9(5) USAGE COMP-3   
                                                         VALUE +99999.  
           05  WS-EPP-DELINQ-VALUE             PIC S9(5) USAGE COMP-3   
                                                         VALUE +99999.  
           05  WS-AMT-EPP-DELINQ-VALUE         PIC S9(5) USAGE COMP-3   
                                                         VALUE +99999.  
T23238     05  WS-PSNC                         PIC X(02) VALUE '26'.    
T23238     05  WS-SCEG                         PIC X(02) VALUE '01'.    
C32821     05  WS-REVENUE-MONTH-EPP            PIC 9(06).               
T26415     05  WS-DFA-FLAG                     PIC X(01) VALUE 'N'.     
T26531     05  WS-CAN-REBILL-FLAG              PIC X(01) VALUE 'N'.     
C37422     05  WS-FACT-VAL-Z               PIC -Z(09).9(06).            
C37422     05  WS-FACTOR-TEXT              PIC 9(9).9(6).               
C37422     05  WS-RCC-EXIST                    PIC X(01) VALUE 'N'.     
C37422     05  WS-FCTRROW-EXIST                PIC X(01) VALUE 'N'.     
C37422     05  WS-NULL-VALUE                   PIC S9(04) COMP VALUE 0. 
C37422     05  WS-EFF-DATE-FROM.                                        
C37422         10  WS-EFF-DATE-FROM-YYYY PIC X(4) VALUE SPACES.         
C37422         10  WS-DASH-1             PIC X(1) VALUE '-'.            
C37422         10  WS-EFF-DATE-FROM-MM   PIC X(2) VALUE SPACES.         
C37422         10  WS-DASH-2             PIC X(1) VALUE '-'.            
C37422         10  WS-EFF-DATE-FROM-DD   PIC X(2) VALUE '01'.           
C37422     05  WS-LAST-UPDATE-TS-FF.                                    
C37422         10  WS-LAST-UPDATE-DATE   PIC X(10) VALUE SPACES.        
C37422         10  WS-LAST-UPDATE-TS     PIC X(16)                      
C37422                                   VALUE '-00.00.00.000000'.      
      *                                                                         
C34569     05  WS-REVENUE-MONTH-1              PIC X(06).               
C34569     05  FILLER REDEFINES WS-REVENUE-MONTH-1.                     
C34569         10  WS-REVMTH-CCYY              PIC 9(04).               
C34569         10  WS-REVMTH-MM                PIC 9(02).               
AGLPRO     05  WS-DATE-HOLD                    PIC X(10).               
C33042     05  WS-DATE-HOLD2                   PIC X(10).               
T33215     05  WS-DB07-ACCT-NO             PIC S9(13) COMP-3 VALUE ZERO.
ACT088     05  WS-NUM-OF-MONTHS            PIC 9(09)  VALUE ZERO.       
ACT088     05  WS-TIME-DIFFERENCE          PIC S9(09) COMP VALUE ZERO.  
ACT088     05  WS-NULL-DIFF                PIC S9(04) COMP VALUE ZERO.  
ACT088     05  WS-ANNIV-TS.                                             
ACT088         10  WS-ANNIV-TS-DATE        PIC X(10).                   
ACT088         10  WS-ANNIV-TS-REST        PIC X(16)  VALUE             
ACT088                                     '-00.00.00.000000'.          
ACT088     05  WS-PYMT-TS.                                              
ACT088         10  WS-PYMT-TS-DATE         PIC X(10).                   
ACT088         10  WS-PYMT-TS-REST         PIC X(16)  VALUE             
ACT088                                     '-00.00.00.000000'.          
ACT088     05  WS-ANNIV-26                 PIC X(26) VALUE SPACES.      
ACT088     05  WS-PYMT-26                  PIC X(26) VALUE SPACES.      
P00471     05  WS-DISPLAY-SQLCODE          PIC -Z(8)9 VALUE ZERO.       
P00471     05  WS-ATTRIBUTE-VALUE-CD       PIC X(05) VALUE SPACES.      
P00471     05  WS-AMT-UNUSED-CR-BPP        PIC S9(09)V99 COMP-3 VALUE 0.
ACT036     05  WS-AMT-BILLED-UNPAID        PIC S9(09)V99 COMP-3 VALUE 0.
                                                                        
      *                                                                         
C28515 01  WS-CATEGORY-ID                  PIC S9(04)  COMP VALUE 295.  
C28515 01  WS-WQ-COMMENTS.                                              
C28515     05  WS-WQ-COMMENTS-TEXT.                                     
C28515         10  FILLER                      PIC X(45)  VALUE         
C28515             'VERIFY ANNIVERSARY DATE ON FIXED RATE ACCOUNT'.     
C34709     05  WS-SEASNL-BLK-CMTS.                                      
C34709         10  WS-SEA-PGMID                PIC X(09)                
C34709                                                VALUE 'PCSCA099T'.
C34709         10  WS-ACCT-XCLUDED-BILLG       PIC X(01)  VALUE 'X'.    
C34709     05  WS-SEA-CMT-HIS.                                          
C34709         10  FILLER                      PIC X(43) VALUE          
C34709             "ACCOUNT EXCLUDED FROM BILLING. PLEASE CHECK".       
C34709         10  FILLER                      PIC X(27) VALUE          
C34709             " THE WQ FOR MORE DETAILS".                          
C34709                                                                  
      *                                                                         
                                                                        
      *                                                                         
C33462 01  WS-RECORD-EXCLUDED.                                          
C33462     10  FILLER                          PIC X(47) VALUE          
C33462         'WARNING: THIS ACCOUNT IS EXCLUDED FROM BILLING '.       
C33462     10  FILLER                          PIC X(29) VALUE          
C33462         'AND MUST BE MANUALLY RELEASED'.                         
      *                                                                         
C28515******************************************************************        
C28515*  LAYOUT FOR CUSTOMER BILL EXTRACT INFORMATION                  *        
C28515******************************************************************        
C28515*                                                                         
C28515 COPY CWS1000A.                                                           
C28515*                                                                         
      ******************************************************************        
      *  COPY BOOK HAVING WORKING STORAGE VARIABLES FOR CPD00317       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00317                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  SUPPORTS PAYMENT ROUTINE (CPD00010).                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00017                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *  WORKING STORAGE COPYBOOK FOR CODES DATA PRESENT.             *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00056                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  APPLICATION  TABLE DCLGENS                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
C28515******************************************************************        
C28515*  CSS_FIXED_FCTR.                                               *        
C28515******************************************************************        
C28515*                                                                         
C28515     EXEC SQL                                                             
C28515         INCLUDE TBFXDFCT                                                 
C28515     END-EXEC.                                                            
C28515*                                                                         
      ******************************************************************        
      *  CSS_DELINQUENCY.                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_AR_CNTL                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBARCNTL                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_JOB-PARM.                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_ACCOUNT                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BUDGET_PLAN                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBGTPLN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CREDIT_PROFILE                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_LOCAL_OFFICE                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CUST_PLAN                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
      *                                                                         
P00471*****************************************************************         
P00471* LR - CSS_REG_PROFILE                                          *         
P00471*****************************************************************         
P00471     EXEC SQL                                                             
P00471        INCLUDE TBREGPRF                                                  
P00471     END-EXEC.                                                            
P00471*                                                                         
      ******************************************************************        
      *  CSS_USER_PROFILE                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_AR_TRANS_HIST                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_AR_TRN_HST_DET                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CUSTOMER                                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_PREMISE                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BILLING_DET                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BILLING_HDR                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BCH_JRNL_CNTL                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BATCH_JRNL                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CSH_DRWR_JRNL                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_MISC_JRNL                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_GL_ACCT_NO                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_BUDGET_HIST                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBGTHST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CONTRACT                                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_RECONNECT                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_DFA_ACCT                                                  *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDFAACT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_DFA_RECVBLE                                               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDFARCV                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CRED_COLL                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRCOLL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_CONNECT_CHRG                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCCCHRG                                                  
           END-EXEC.                                                            
C27405*                                                                         
C27405******************************************************************        
C27405*  CSS_CNSMPTN_HIST                                              *        
C27405******************************************************************        
C27405*                                                                         
C27405     EXEC SQL                                                             
C27405        INCLUDE TBCNSMP                                                   
C27405     END-EXEC.                                                            
C25165*                                                                         
C25165******************************************************************        
C25165*  CSS_BILL_WINDOW                                               *        
C25165******************************************************************        
C25165*                                                                         
C25165     EXEC SQL                                                             
C25165        INCLUDE TBBILWDW                                                  
C25165     END-EXEC.                                                            
      *                                                                         
C32676******************************************************************        
C32676*  CSS_RATE_CREATOR                                              *        
C32676******************************************************************        
C32676*                                                                         
C32676     EXEC SQL                                                             
C32676        INCLUDE TBRTCRTR                                                  
C32676     END-EXEC.                                                            
      *                                                                         
T23339*****************************************************************         
T23339* CSS_UTIL_ENVRNMT                                                        
T23339*****************************************************************         
T23339*                                                                         
T23339     EXEC SQL                                                             
T23339        INCLUDE TBUTLENV                                                  
T23339     END-EXEC.                                                            
T23339*                                                                         
T23339*****************************************************************         
T23339* CSS_MNT_TRANS_HIST                                                      
T23339*****************************************************************         
T23339*                                                                         
T23339     EXEC SQL                                                             
T23339        INCLUDE TBMNHIST                                                  
T23339     END-EXEC.                                                            
T23339*                                                                         
T23339*****************************************************************         
T23339* CSS_MT_TRN_HST_DET                                                      
T23339*****************************************************************         
T23339*                                                                         
T23339     EXEC SQL                                                             
T23339        INCLUDE TBMNHDT                                                   
T23339     END-EXEC.                                                            
T23339*                                                                         
      *****************************************************************         
      * CSS_MTRD_ENVRNMT                                                        
      *****************************************************************         
      *                                                                         
            EXEC SQL                                                            
              INCLUDE TBMTRENV                                                  
            END-EXEC.                                                           
      *                                                                         
P00307*****************************************************************         
P00307* CSS_ACCT_ATTRIBUTE                                                      
P00307*****************************************************************         
P00307*                                                                         
P00307     EXEC SQL                                                             
P00307        INCLUDE TBACTATT                                                  
P00307     END-EXEC.                                                            
P00307*                                                                         
P00471******************************************************************        
P00471* CSS_SPCL_BILL_MSG - U1                                         *        
P00471******************************************************************        
P00471*                                                                         
P00471     EXEC SQL                                                             
P00471        INCLUDE TBSBLMSG                                                  
P00471     END-EXEC.                                                            
P00471*                                                                         
      ******************************************************************        
      * COPYBOOKS REQUIRED BY SCSCB068                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00068                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS COMMON JOURNALING.                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
      *                                                                         
       COPY CJF00101.                                                           
       COPY FIOCA01.                                                            
       COPY FIOJC01.                                                            
       COPY FIOCA00.                                                            
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE AREA FOR COMMON DATES                         *        
      ******************************************************************        
      *                                                                         
       COPY CWS00039.                                                           
      *                                                                         
      ******************************************************************        
      *   WORKING STORAGE AREA FOR RESTART-REQUEST PARM                *        
      ******************************************************************        
      *                                                                         
       COPY CWS00038.                                                           
      *                                                                         
      ******************************************************************        
      *   WORKING STORAGE AREA FOR READING CSS_JOB_PARM TABLE          *        
      ******************************************************************        
      *                                                                         
       COPY CWS00114.                                                           
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE FOR SUPPLEMENTAL WQ TEXT                      *        
      ******************************************************************        
      *                                                                         
       COPY CWS0070B.                                                           
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE FOR DB2 ERROR PROCESSING.                     *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
                                                                        
      ******************************************************************        
      *  WORKING STORAGE FOR ABEND SWITCH                              *        
      ******************************************************************        
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE FOR ERROR HANDLING                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR DECLARATIONS                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             DECLARE DET-AR-CNTL CURSOR FOR                             
              SELECT  AMT_AR_DAY_00                                     
                     ,AMT_AR_DAY_30                                     
                     ,AMT_AR_DAY_60                                     
                     ,AMT_AR_DAY_90                                     
                     ,AMT_TRAN_BALANCE                                  
                     ,ITEM_ID                                           
                FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO        = :WS-AC-ACCOUNT-NO             
                 AND  PYMT_PRIORITY_LVL = :WS-AC-PYMT-PRIORITY-LVL      
                 AND  ITEM_ID           > :WS-AC-ITEM-ID                
T26415         ORDER BY ITEM_ID DESC                                    
T26415                 ,AMT_TRAN_BALANCE ASC                            
T33182         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DET-AR-CNTL CURSOR FOR                                     
MFA-TR*       SELECT  AMT_AR_DAY_00                                             
MFA-TR*              ,AMT_AR_DAY_30                                             
MFA-TR*              ,AMT_AR_DAY_60                                             
MFA-TR*              ,AMT_AR_DAY_90                                             
MFA-TR*              ,AMT_TRAN_BALANCE                                          
MFA-TR*              ,ITEM_ID                                                   
MFA-TR*         FROM  CSS_AR_CNTL                                               
MFA-TR*        WHERE  ACCOUNT_NO        = :WS-AC-ACCOUNT-NO                     
MFA-TR*          AND  PYMT_PRIORITY_LVL = :WS-AC-PYMT-PRIORITY-LVL              
MFA-TR*          AND  ITEM_ID           > :WS-AC-ITEM-ID                        
MFA-TR*        ORDER BY ITEM_ID DESC                                            
MFA-TR*                ,AMT_TRAN_BALANCE ASC                                    
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
T26264*                                                                         
C27405     EXEC SQL                                                     
C27405       DECLARE  EPP_SEASONAL_RATE CURSOR FOR                      
C27405        SELECT  'Y'                                               
C27405          FROM  CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
C27405               ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
C27405               ,CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                 
C27405         WHERE  UT.ACCOUNT_NO             = :UT-ACCOUNT-NO        
C27405           AND  UT.ACCOUNT_NO             = MN.ACCOUNT_NO         
C27405           AND  UT.CODE_UTIL_TYPE         = MN.CODE_UTIL_TYPE     
C27405           AND  UT.IC_NO                  = MN.IC_NO              
C27405           AND  UT.CODE_UTIL_TYPE         = RT.CODE_UTIL_TYPE     
C27405           AND  UT.RATE_PLAN_NO           = RT.RATE_PLAN_NO       
C27405           AND  RT.VERSION_NO_CNTRL IN                            
C27405                (SELECT MAX(VERSION_NO_CNTRL)                     
C27405                   FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)         
C27405                  WHERE UT.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE     
C27405                    AND UT.RATE_PLAN_NO   = RT.RATE_PLAN_NO       
C27405                    AND RT.CODE_STATUS    = 'A')                  
T33182           AND  RT.SEASONAL_DEP_IND       = 'Y'                   
T33182           AND  MN.CODE_METER_STATUS      = 'J'                   
T33182         FOR READ ONLY                                    
C27405     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  EPP_SEASONAL_RATE CURSOR FOR                              
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         FROM  CSS_UTIL_ENVRNMT UT                                       
MFA-TR*              ,CSS_MTRD_ENVRNMT MN                                       
MFA-TR*              ,CSS_RATE_CREATOR RT                                       
MFA-TR*        WHERE  UT.ACCOUNT_NO             = :UT-ACCOUNT-NO                
MFA-TR*          AND  UT.ACCOUNT_NO             = MN.ACCOUNT_NO                 
MFA-TR*          AND  UT.CODE_UTIL_TYPE         = MN.CODE_UTIL_TYPE             
MFA-TR*          AND  UT.IC_NO                  = MN.IC_NO                      
MFA-TR*          AND  UT.CODE_UTIL_TYPE         = RT.CODE_UTIL_TYPE             
MFA-TR*          AND  UT.RATE_PLAN_NO           = RT.RATE_PLAN_NO               
MFA-TR*          AND  RT.VERSION_NO_CNTRL IN                                    
MFA-TR*               (SELECT MAX(VERSION_NO_CNTRL)                             
MFA-TR*                  FROM CSS_RATE_CREATOR RT                               
MFA-TR*                 WHERE UT.CODE_UTIL_TYPE = RT.CODE_UTIL_TYPE             
MFA-TR*                   AND UT.RATE_PLAN_NO   = RT.RATE_PLAN_NO               
MFA-TR*                   AND RT.CODE_STATUS    = 'A')                          
MFA-TR*          AND  RT.SEASONAL_DEP_IND       = 'Y'                           
MFA-TR*          AND  MN.CODE_METER_STATUS      = 'J'                           
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
C27405*                                                                         
T26264 LINKAGE SECTION.                                                 
T26264 01 WS-PARM-VALUE.                                                
T26264    05 WS-PARMVAL-LENGTH           PIC S9(04) COMP.               
T26264    05 WS-PARM-DATE-1              PIC X(10).                     
T26264    05 WS-PARM-DATE-2              PIC X(10).                     
T26264    05 WS-PARM-DATE-3              PIC X(10).                     
T26264*                                                                         
T26264 PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION         THRU  0100-EXIT.         
      *                                                                         
C28515     PERFORM 7050-SELECT-TIMESTAMP       THRU  7050-EXIT.         
      *                                                                         
           PERFORM 1000-PROCESS-INPUT          THRU  1000-EXIT          
                                               UNTIL END-OF-FILE.       
      *                                                                         
           PERFORM 9000-TERMINATE              THRU  9000-EXIT.         
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   OPENS THE INPUT  FILE DB07                                   *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE         THRU 6251-EXIT.          
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                               THRU 6240-EXIT           
               MOVE WS-FCA00-COMMON-DATE       TO WS-INPUT-DATE         
           END-IF.                                                      
C27405*                                                                         
C27405     MOVE SPACES                         TO WS-SYSIPT.            
C27405     MOVE 'COMMON'                       TO WS-PROGRAM.           
C27405     MOVE WS-DATE                        TO WS-COMMAND.           
C27405     MOVE ZEROS                          TO WS-SEQUENCE.          
C27405     MOVE WS-KEY-AREA                    TO E-FJC01-KEY.          
C27405                                                                  
C27405     PERFORM 7600-START-FCSJC01          THRU  7600-EXIT.         
C27405                                                                  
C27405     PERFORM 7610-READ-FCSJC01           THRU  7610-EXIT          
C27405         UNTIL (REVENUE-MONTH AND INPUT-ACTIVE)                   
C27405            OR  END-OF-SYSIPT.                                    
C27405                                                                  
C27405     EVALUATE TRUE                                                
C27405        WHEN END-OF-SYSIPT                                        
C27405           DISPLAY '**  PCSCA099 PROCESSING ERROR        **'      
C27405           DISPLAY '**    NO ACTIVE REVENUE MONTH IN COMMON'      
C27405           DISPLAY '**  PROCESSING TERMINATED            **'      
C27405           PERFORM 9900-ABEND            THRU  9900-EXIT          
C27405        WHEN WS-REVENUE-MONTH-PARM NOT NUMERIC                    
C27405           DISPLAY '**  PCSCA099 PROCESSING ERROR        **'      
C27405           DISPLAY '**    REVENUE MONTH PARM NOT NUMERIC'         
C27405           DISPLAY '**    KEY = ' E-FJC01-KEY                     
C27405           DISPLAY '**  PROCESSING TERMINATED            **'      
C27405           PERFORM 9900-ABEND            THRU  9900-EXIT          
C27405        WHEN OTHER                                                
C27405           PERFORM 7611-CLOSE            THRU 7611-EXIT           
C27405     END-EVALUATE.                                                
A00755* Load Current Bill Cycles From CSS_JOB_PARM                              
A00755     PERFORM 6241-GET-FCA00-BILL-CYCLES  THRU 6241-EXIT .         
A00755*                                                                         
           OPEN INPUT FCSDB07-FILE.                                     
           IF  FDB07-SUCCESSFUL                                         
               PERFORM 0500-PROCESS-BEGIN-REC  THRU  0500-EXIT          
                   UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES          
           ELSE                                                         
               DISPLAY 'OPEN ERROR ON FCSDB07 FILE.'                    
               DISPLAY ' STATUS IS ', WS-FDB07-STATUS                   
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF                                                       
      *                                                                         
           MOVE WS-INPUT-DATE                  TO WS-COMMON-DATE.       
           PERFORM 7125-GET-RELATIVE-DATES     THRU 7125-EXIT.          
      *                                                                         
           MOVE ZERO                           TO WS-DATABASE.          
           MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
           PERFORM 7100-SELECT-DELINQ-VALUE    THRU 7100-EXIT.          
           MOVE C8-DELINQ-VALUE                TO WS-DATABASE.          
      *                                                                         
           MOVE WS-DPP-DELINQ-CD               TO C8-DELINQ-CD.         
           PERFORM 7100-SELECT-DELINQ-VALUE    THRU 7100-EXIT.          
           MOVE C8-DELINQ-VALUE                TO WS-DPP-DELINQ-VALUE.  
      *                                                                         
           MOVE WS-EPP-DELINQ-CD               TO C8-DELINQ-CD.         
           PERFORM 7100-SELECT-DELINQ-VALUE    THRU 7100-EXIT.          
           MOVE C8-DELINQ-VALUE                TO WS-EPP-DELINQ-VALUE.  
      *                                                                         
           MOVE WS-AMT-EPP-DELINQ-CD           TO C8-DELINQ-CD.         
           PERFORM 7100-SELECT-DELINQ-VALUE    THRU 7100-EXIT.          
           MOVE C8-DELINQ-VALUE                TO                       
                                               WS-AMT-EPP-DELINQ-VALUE. 
P00471     MOVE WS-DPP-IND-DELINQ-CD           TO C8-DELINQ-CD          
P00471     PERFORM 7100-SELECT-DELINQ-VALUE    THRU 7100-EXIT           
P00471     MOVE C8-DELINQ-VALUE                TO                       
P00471                                         WS-DPP-IND-DELINQ-VALUE  
      *                                                                         
T26264     IF SEB-DATABASE                                              
P00471        MOVE WS-DPP-GP1-DELINQ-CD        TO C8-DELINQ-CD          
P00471        PERFORM 7100-SELECT-DELINQ-VALUE THRU 7100-EXIT           
P00471        MOVE C8-DELINQ-VALUE             TO                       
P00471                                         WS-DPP-GP1-DELINQ-VALUE  
P00471        MOVE WS-DPP-GP2-DELINQ-CD        TO C8-DELINQ-CD          
P00471        PERFORM 7100-SELECT-DELINQ-VALUE THRU 7100-EXIT           
P00471        MOVE C8-DELINQ-VALUE             TO                       
P00471                                         WS-DPP-GP2-DELINQ-VALUE  
T26264     END-IF.                                                      
T26264*                                                                         
           PERFORM 0155-INIT-CWS00013-FLDS     THRU 0155-EXIT.          
           INITIALIZE WS-100-TRAN-APPL-NO-HOLD.                         
T23339*                                                                         
T26264     MOVE 'N'                            TO WS-MESG-DATE-CHK-SW   
T26264                                            WS-DROP-DATE-CHK-SW.  
T26264     IF ((WS-PARM-DATE-1 NOT = SPACES                             
T26264     AND WS-PARM-DATE-1 NOT = LOW-VALUES)                         
T26264     AND (WS-PARM-DATE-2 NOT = SPACES                             
T26264     AND WS-PARM-DATE-2 NOT = LOW-VALUES))                        
T26264        IF (WS-COMMON-DATE > WS-PARM-DATE-1                       
T26264        AND WS-COMMON-DATE < WS-PARM-DATE-2)                      
T26264           MOVE 'Y'                      TO WS-MESG-DATE-CHK-SW   
T26264        END-IF                                                    
T26264     END-IF.                                                      
T26264*                                                                         
T26264     IF (WS-PARM-DATE-3 NOT = SPACES                              
T26264     AND WS-PARM-DATE-3 NOT = LOW-VALUES)                         
T26264        IF WS-COMMON-DATE > WS-PARM-DATE-3                        
T26264           MOVE 'Y'                      TO WS-DROP-DATE-CHK-SW   
T26264        END-IF                                                    
T26264     END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    0500-PROCESS-BEGIN-REC                                      *        
      *    THIS PARAGRAPH DOES AN INITIAL READ TO THE DB07 FILE AND    *        
      *    CHECKS FOR A BEGINNING RECORD. WHEN FOUND THE DATE ON       *        
      *    THE BEGIN RECORD IS COMPARED TO THE RUN DATE OBTAINED       *        
      *    FROM THE JOBS TABLE TO ENSURE WE ARE PROCESSING WITH        *        
      *    THE CORRECT FILE.                                           *        
      ******************************************************************        
      *                                                                         
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7000-READ-FCSDB07           THRU 7000-EXIT.          
      *                                                                         
           EVALUATE TRUE                                                
              WHEN END-OF-FILE                                          
                 DISPLAY '**    PCSCA099 PROCESSING ERROR          **'  
                 DISPLAY '**      FCSDB07 FILE IS EMPTY            **'  
                 DISPLAY '**      PROCESSING TERMINATED            **'  
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
      *                                                                         
              WHEN E-FDB07-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FDB07-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '**     PCSCA099 PROCESSING ERROR      **'  
                    DISPLAY '** FCSDB07 CREATE DATE NOT = RUN DATE **'  
                    DISPLAY '**       PROCESSING TERMINATED        **'  
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
                 SET WS-BEGIN-RECS-PROCESSED   TO TRUE                  
      *                                                                         
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
T25075              IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES AND           
T25075                 NO-DATA-RECORD-FOUND AND                         
T25075                 E-FDB07-RECORD-COUNT-EREC EQUAL ZERO             
T25075                 DISPLAY                                          
T25075                 '**    PCSCA099 PROCESSING ERROR          **'    
T25075                 DISPLAY                                          
T25075                 '**      FCSDB07 FILE IS EMPTY            **'    
T25075                 DISPLAY                                          
T25075                 '**      PROCESSING TERMINATED            **'    
T25075                 PERFORM 9900-ABEND            THRU 9900-EXIT     
T25075              ELSE                                                
                       CONTINUE                                         
T25075              END-IF                                              
                 ELSE                                                   
T25075              SET DATA-RECORD-FOUND      TO TRUE                  
                    MOVE E-FDB07-COMPANY-NO    TO C8-COMPANY-NO         
                 END-IF                                                 
      *                                                                         
              WHEN OTHER                                                
                 DISPLAY '**    PCSCA099 PROCESSING ERROR          **'  
                 DISPLAY '** FIRST RECORD IS NOT A CNTL REC        **'  
                 DISPLAY '**      PROCESSING TERMINATED            **'  
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PROCESSES EACH INPUT RECORD UNTIL THE END OF FILE              *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF  E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES         
               CONTINUE                                                 
           ELSE                                                         
               MOVE E-FDB07-ACCT-NO            TO AC-ACCOUNT-NO         
                                                  DA-ACCOUNT-NO         
                                                  WS-ACCOUNT-NO         
                                                  BU-ACCOUNT-NO         
                                                  CZ-ACCOUNT-NO         
                                                  AT-ACCOUNT-NO         
T23339                                            UT-ACCOUNT-NO         
T23339                                            BG-ACCOUNT-NO         
C27405                                            CX-ACCOUNT-NO         
C27405                                            BI-ACCOUNT-NO         
T33215                                            WS-DB07-ACCT-NO       
C34569                                            BH-ACCOUNT-NO         
P00471                                            LR-ACCOUNT-NO         
               MOVE E-FDB07-COMPANY-NO         TO C8-COMPANY-NO         
               PERFORM 7150-SELECT-ACCOUNT     THRU 7150-EXIT           
C33462         IF AT-CODE-ACCT-BILLED = 'X'                             
C33462            PERFORM 7000-READ-FCSDB07  THRU 7000-EXIT             
C33462            GO TO 1000-EXIT                                       
C33462         END-IF                                                   
A00755*                                                                         
A00755         MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT 
A00755* For Initial Bills With BBP                                              
A00755         IF AT-REV-MTH-LST-NRML = 0 AND WS-CODE-BUDGET = 'A'      
A00755            PERFORM 2450-GET-REV-MNTH-CUR      THRU 2450-EXIT     
A00755            PERFORM 2500-VALIDATE-BBP-ANNIV-DT THRU 2500-EXIT     
A00755         END-IF                                                   
A00755*                                                                         
C33442         MOVE AT-EXT-BILLING-FL TO WS-EXT-BILLING-FL              
               INITIALIZE WS-DAY-60-UTL-RELATED-DELINQ                  
                          WS-DAY-90-UTL-RELATED-DELINQ                  
      *                                                                         
               MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT 
               MOVE WS-INPUT-DATE              TO WS-HOLD-DATE          
               MOVE 'Y'                        TO CALC-ARREARS-SW       
                                                  CALC-BALANCE-SW       
               MOVE PROGRAM-NAME               TO                       
                                               WS-CPD00068-CALLING-PGM  
               MOVE SPACES                     TO ABEND-FUNCTION        
      *                                                                         
               IF WS-CODE-BUDGET = 'A' OR WS-CODE-DPP-ACCT = 'A'        
                  CALL SCSCB068  USING   CWS00068-FIELDS                
                                        , WS-CODES-DATA-PRESENT         
                                        , DCLCSS-ACCOUNT                
                                        , ABEND-FILE                    
                                        , RS-RETURN-CODE                
                  IF ABEND-FUNCTION  > SPACES                           
                     PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT        
                  END-IF                                                
               END-IF                                                   
      *                                                                         
T23238         MOVE 'N'                       TO WS-EPP-EXISTS          
T23238                                           WS-DPP-EXISTS          
T23339*                                                                         
A01542***ONLY ACTIVE ACCOUNTS ARE ELIGIBLE FOR BBP                              
A01542         IF  WS-CODE-BUDGET = 'A' AND AT-CODE-ACCT-STAT = 'A'     
ACT004           AND AT-REV-MTH-LST-NRML > 0                            
                   SET EPP-EXISTS              TO TRUE                  
A01542             PERFORM 7800-GET-EPP-ANNIV-DATE    THRU 7800-EXIT    
                   PERFORM 2000-PROCESS-EPP           THRU 2000-EXIT    
               END-IF                                                   
      *                                                                         
P00471         COMPUTE WS-EXCEL-EARNEST-AMT =                           
P00471                   WS-TOTAL-BALANCE-UTL - WS-TOTAL-EARNEST-AMT    
T26415         MOVE 'N'                        TO WS-DFA-FLAG           
T23238         IF  WS-CODE-DPP-ACCT = 'A'                               
T23238             SET DPP-EXISTS              TO TRUE                  
T26531             PERFORM 7550-SELECT-CANCEL-REBILL                    
T26531                                         THRU 7550-EXIT           
P00471             IF E-FDB07-OFF-CYCLE-BILL-CODE NOT = 'O'             
P00471                AND WS-CAN-REBILL-FLAG NOT = 'Y'                  
P00471                IF SEB-DATABASE                                   
P00471                   PERFORM 7440-SELECT-REG-PROFILE  THRU 7440-EXIT
P00471                END-IF                                            
P00471                EVALUATE TRUE                                     
P00471                    WHEN SEB-DATABASE AND LR-REG-GROUP-CD = SPACES
P00471                         AND (DPP-DROP-ALL OR DPP-DROP-BILLING)   
P00471                    WHEN SEB-DATABASE AND LR-REG-GROUP-CD = '100' 
P00471                         AND (REG-GP1-ALL OR REG-GP1-BILLING)     
P00471                    WHEN SEB-DATABASE AND LR-REG-GROUP-CD = '200' 
P00471                         AND (REG-GP2-ALL OR REG-GP2-BILLING)     
P00471                    WHEN CSR-DATABASE                             
P00471                         AND (DPP-DROP-ALL OR DPP-DROP-BILLING)   
P00471                         PERFORM 7450-SELECT-BLLD-MTH             
P00471                                                    THRU 7450-EXIT
P00471                         IF (DA-RCNTLY-BLLD-MTH = 0               
P00471                             AND WS-EXCEL-EARNEST-AMT >           
P00471                                 WS-DPP-DELINQ-VALUE)             
P00471                             OR (DA-RCNTLY-BLLD-MTH > 0           
P00471                                 AND WS-TOTAL-BALANCE-UTL >       
P00471                                     WS-DPP-DELINQ-VALUE)         
P00471                             PERFORM 2100-CHECK-DPP THRU 2100-EXIT
P00471                         END-IF                                   
P00471                END-EVALUATE                                      
T23238             END-IF                                               
T23238         END-IF                                                   
C27405*                                                                         
C27405         IF AT-CODE-ACCT-STAT = 'A' AND WS-CODE-BUDGET = 'A'      
C27405            PERFORM 2200-PROCESS-EPP-ACCTS                        
C27405                                         THRU 2200-EXIT           
C27405         END-IF                                                   
T23238     END-IF.                                                      
      *                                                                         
P00506     IF WS-CODE-BUDGET = 'A'                                      
C32821        IF AT-REV-MTH-LST-NRML EQUAL ZEROS                        
C32821           NEXT SENTENCE                                          
C32821        ELSE                                                      
C29815           PERFORM 5999-INPUT-REV-MTH-01 THRU 5999-EXIT           
P00453* Check the account is going for billing 1st month after anniv            
P00453           SET  NOT-FIRST-MONTH-AFTER-ANNIV TO TRUE               
P00453           PERFORM 7022-CHECK-1ST-MNTH-AFTR-ANNIV THRU 7022-EXIT  
P00453         IF (((WS-INPUT-DATE-REV(1:7) = WS-1ST-MNTH-ANNIV-DT(1:7))
P00453                                    AND (FIRST-MONTH-AFTER-ANNIV))
C37207          OR (WS-INPUT-DATE-REV(1:7) = BU-ANNIVERSARY-DATE(1:7))) 
C29815             PERFORM 6000-CHECK-FOR-CIA THRU 6000-EXIT            
C29815         END-IF                                                   
C29815        END-IF                                                    
C32821     END-IF.                                                      
P00307     IF ((WS-CODE-BUDGET = 'A') AND                               
P00307         (WS-INPUT-DATE-REV(1:7) = BU-ANNIVERSARY-DATE(1:7)))     
P00307           MOVE AT-ACCOUNT-NO           TO YP-ACCOUNT-NO          
P00307           MOVE 'BBP_REVIEW_EXEMPT'     TO YP-ATTRIBUTE-DESC      
P00307           PERFORM 8940-DELETE-ACCT-ATTR THRU 8940-EXIT           
P00307     END-IF.                                                      
C37422                                                                  
C37422     IF  E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES         
C37422         CONTINUE                                                 
C37422     ELSE                                                         
P00794      IF ((SEB-DATABASE OR AT-COMPANY-NO = '26') AND              
C37422          (AT-CODE-ACCT-STAT NOT EQUAL 'B'))                      
C37422        MOVE E-FDB07-ACCT-NO            TO DL-ACCOUNT-NO          
C37422                                           AR-ACCOUNT-NO          
C37422                                           UT-ACCOUNT-NO          
C37422                                           FF-ACCOUNT-NO          
C37422        MOVE 'N'                        TO WS-RCC-EXIST           
C37422        MOVE SPACE                      TO WS-LAST-UPDATE-DATE    
C37422        PERFORM 8897-CHECK-PREPAY-RCC   THRU 8897-EXIT            
C37422        IF WS-RCC-EXIST = 'Y'                                     
C37422           MOVE DL-DATETIME-SETUP     TO WS-LAST-UPDATE-DATE      
C37422           MOVE WS-LAST-UPDATE-TS-FF  TO FF-LAST-UPDATE-TS        
C37422           MOVE 'N'                       TO WS-FCTRROW-EXIST     
C37422           PERFORM 8898-CHECK-FOR-FCTRROW THRU 8898-EXIT          
C37422           IF WS-FCTRROW-EXIST = 'N'                              
C37422              PERFORM 8899-GET-UTIL-ENV   THRU 8899-EXIT          
C37422              PERFORM 8900-GET-MIN-REV-MO THRU 8900-EXIT          
C37422              PERFORM 8910-GET-MAX-SEQ-NO THRU 8910-EXIT          
C37422              PERFORM 8930-CHECK-FOR-MANUAL-ENTRY                 
C37422                                          THRU 8930-EXIT          
C37422*********FOR FINAL BILL ACCOUNTS CREATE WQ                                
C37422              IF  WS-FCTRROW-EXIST = 'N'                          
C37422               ADD 1                      TO FF-FIXED-FCTR-SEQ-NO 
C37422               MOVE 'RECCHGTAX'           TO FF-FACTOR-ID         
C37422               MOVE '10'                  TO FF-CMPNT-ID-CD       
C37422               MOVE 'B'                   TO FF-CODE-SEASON       
C37422               MOVE 'R'                   TO FF-INSTR-USE-TYPE-CD 
C37422               MOVE 0                     TO FF-CODE-TIME-PERIOD  
C37422               MOVE WS-EFF-DATE-FROM      TO FF-EFF-DATE-FROM     
C37422               MOVE '2999-12-31'          TO FF-EFF-DATE-TO       
C37422               MOVE '00'                  TO FF-FIXED-FCTR-TYP-CD 
C37422               COMPUTE FF-FACTOR = (AC-AMT-TRAN-BALANCE * -1)     
C37422               MOVE 0                     TO FF-FAC-CHRG-BASE-AM  
C37422               MOVE 0                     TO FF-RT-PKG-OPT-SEQ-NO 
C37422               MOVE 1                     TO FF-DURATION-REMAIN-NO
C37422               MOVE 0                     TO WS-NULL-VALUE        
C37422               PERFORM 8920-INSERT-FACTOR  THRU 8920-EXIT         
C37422               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL         
C37422                  PERFORM 7050-SELECT-TIMESTAMP THRU              
C37422                                                7050-EXIT         
C37422********** DATA FOR CSS_MNT_TRANS_HIST                                    
C37422                  MOVE WS-CURRENT-TIMESTAMP TO                    
C37422                                              MH-TRANS-HIST-SEQ-NO
C37422                  MOVE WS-CURRENT-DATE      TO MH-DATE-TRANS      
C37422                  MOVE WS-F                 TO MH-CODE-TRAN-TYPE  
C37422                  MOVE 'AGL'                TO MH-RESP-AREA-ID    
C37422                  MOVE AT-ACCOUNT-NO        TO MH-ACCOUNT-NO      
C37422                  MOVE AT-CUSTOMER-NO       TO MH-CUSTOMER-NO     
C37422                  MOVE AT-PREMISE-NO        TO MH-PREMISE-NO      
C37422                  MOVE 'SYSTEM'             TO MH-USER-ID         
C37422                  MOVE +45                  TO MH-TRAN-COMMENT-LEN
C37422                  MOVE WS-RCC-COMMENT      TO MH-TRAN-COMMENT-TEXT
C37422                  MOVE 'PCSCA099'           TO MH-APPL-PROGRAM-ID 
C37422                  MOVE +0                   TO                    
C37422                                            MH-ENTITY-KEY-DESC-LEN
C37422                  MOVE SPACES               TO                    
C37422                                           MH-ENTITY-KEY-DESC-TEXT
C37422                                                                  
C37422** DATA FOR CSS_MT_TRN_HST_DET                                            
C37422                 MOVE WS-CURRENT-TIMESTAMP TO MI-TRANS-HIST-SEQ-NO
C37422                  MOVE 1                     TO MI-TRAN-APPL-NO   
C37422                  MOVE 'FACTOR VALUE'        TO MI-COLUMN-DESC    
C37422                  MOVE SPACES                TO MI-TABLE-ID       
C37422                  MOVE 7                     TO                   
C37422                                           MI-PRV-COLUMN-VALUE-LEN
C37422                  MOVE '**NEW**'             TO                   
C37422                                          MI-PRV-COLUMN-VALUE-TEXT
C37422                  MOVE FF-FACTOR             TO WS-FACTOR-TEXT    
C37422                  MOVE WS-FACTOR-TEXT        TO WS-FACT-VAL-Z     
C37422                  MOVE WS-FACT-VAL-Z         TO                   
C37422                                          MI-CHG-COLUMN-VALUE-TEXT
C37422                  MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT         
C37422                                   TO MI-CHG-COLUMN-VALUE-LEN     
C37422*                                                                         
C37422                  PERFORM 1450-INSERT-MN-TRANS-HIST THRU 1450-EXIT
C37422                 PERFORM 1460-INSERT-MN-TRN-HST-DET THRU 1460-EXIT
C37422*                                                                         
C37422                MOVE WS-CURRENT-TIMESTAMP  TO MI-TRANS-HIST-SEQ-NO
C37422                 MOVE 2                     TO MI-TRAN-APPL-NO    
C37422                 MOVE 'DURATION'            TO MI-COLUMN-DESC     
C37422                 MOVE +7                    TO                    
C37422                                           MI-PRV-COLUMN-VALUE-LEN
C37422                 MOVE '**NEW**'             TO                    
C37422                                          MI-PRV-COLUMN-VALUE-TEXT
C37422                 MOVE +01                   TO                    
C37422                                           MI-CHG-COLUMN-VALUE-LEN
C37422                 MOVE '1'                   TO                    
C37422                                          MI-CHG-COLUMN-VALUE-TEXT
C37422                 MOVE SPACES                TO MI-TABLE-ID        
C37422                 PERFORM 1460-INSERT-MN-TRN-HST-DET THRU 1460-EXIT
C37422               END-IF                                             
C37422               IF (DL-RECNCT-COLLECT-AMT +                        
C37422                  AC-AMT-TRAN-BALANCE) > 0                        
C37422                 ADD 1                  TO FF-FIXED-FCTR-SEQ-NO   
C37422                 MOVE 0                 TO FF-DURATION-REMAIN-NO  
C37422                 MOVE -1                TO WS-NULL-VALUE          
C37422                 COMPUTE FF-FACTOR =                              
C37422                       DL-RECNCT-COLLECT-AMT + AC-AMT-TRAN-BALANCE
C37422                 PERFORM 8920-INSERT-FACTOR  THRU 8920-EXIT       
C37422** DATA FOR CSS_MT_TRN_HST_DET                                            
C37422                 MOVE WS-CURRENT-TIMESTAMP TO MI-TRANS-HIST-SEQ-NO
C37422                 MOVE 3                 TO MI-TRAN-APPL-NO        
C37422                 MOVE 'FACTOR VALUE'    TO MI-COLUMN-DESC         
C37422                 MOVE SPACES            TO MI-TABLE-ID            
C37422                 MOVE 7                 TO                        
C37422                                          MI-PRV-COLUMN-VALUE-LEN 
C37422                 MOVE '**NEW**'         TO                        
C37422                                         MI-PRV-COLUMN-VALUE-TEXT 
C37422                 MOVE FF-FACTOR         TO WS-FACTOR-TEXT         
C37422                 MOVE WS-FACTOR-TEXT    TO WS-FACT-VAL-Z          
C37422                 MOVE WS-FACT-VAL-Z     TO                        
C37422                                         MI-CHG-COLUMN-VALUE-TEXT 
C37422                 MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT          
C37422                                 TO MI-CHG-COLUMN-VALUE-LEN       
C37422*                                                                         
C37422                 PERFORM 1460-INSERT-MN-TRN-HST-DET THRU 1460-EXIT
C37422*                                                                         
C37422                 MOVE WS-CURRENT-TIMESTAMP                        
P00794                   TO MI-TRANS-HIST-SEQ-NO                        
C37422                 MOVE 4                 TO MI-TRAN-APPL-NO        
C37422                 MOVE 'DURATION'        TO MI-COLUMN-DESC         
C37422                 MOVE +7                TO                        
C37422                                          MI-PRV-COLUMN-VALUE-LEN 
C37422                 MOVE '**NEW**'         TO                        
C37422                                         MI-PRV-COLUMN-VALUE-TEXT 
C37422                 MOVE +03               TO                        
C37422                                          MI-CHG-COLUMN-VALUE-LEN 
C37422                 MOVE 'N/A'             TO                        
C37422                                         MI-CHG-COLUMN-VALUE-TEXT 
C37422                 MOVE SPACES            TO MI-TABLE-ID            
C37422                 PERFORM 1460-INSERT-MN-TRN-HST-DET THRU 1460-EXIT
C37422               END-IF                                             
C37422              END-IF                                              
C37422           END-IF                                                 
C37422        END-IF                                                    
C37422      END-IF                                                      
C37422     END-IF.                                                      
C37422                                                                  
           PERFORM 7000-READ-FCSDB07           THRU 7000-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T23339******************************************************************        
T23339* INSERT A ROW INTO CSS_MNT_TRANS_HIST                           *        
T23339******************************************************************        
T23339*                                                                         
T23339 1450-INSERT-MN-TRANS-HIST.                                       
T23339*                                                                         
T23339     EXEC SQL                                                     
T23339          INSERT INTO CSS_MNT_TRANS_HIST                          
T23339               ( TRANS_HIST_SEQ_NO,                               
T23339                 DATE_TRANS,                                      
T23339                 CODE_TRAN_TYPE,                                  
T23339                 RESP_AREA_ID,                                    
T23339                 ACCOUNT_NO,                                      
T23339                 CUSTOMER_NO,                                     
T23339                 PREMISE_NO,                                      
T23339                 USER_ID,                                         
T23339                 APPL_PROGRAM_ID,                                 
T23339                 TRAN_COMMENT,                                    
T23339                 ENTITY_KEY_DESC)                                 
T23339          VALUES                                                  
T23339               ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
T23339                 IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
T23339                 :MH-CODE-TRAN-TYPE,                              
T23339                 :MH-RESP-AREA-ID,                                
T23339                 :MH-ACCOUNT-NO,                                  
T23339                 :MH-CUSTOMER-NO,                                 
T23339                 :MH-PREMISE-NO,                                  
T23339                 :MH-USER-ID,                                     
T23339                 :MH-APPL-PROGRAM-ID,                             
T23339                 :MH-TRAN-COMMENT,                                
T23339                 :MH-ENTITY-KEY-DESC)                             
T23339     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                USER_ID,                                                 
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                ENTITY_KEY_DESC)                                         
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MH-DATE-TRANS,                                          
MFA-TR*                :MH-CODE-TRAN-TYPE,                                      
MFA-TR*                :MH-RESP-AREA-ID,                                        
MFA-TR*                :MH-ACCOUNT-NO,                                          
MFA-TR*                :MH-CUSTOMER-NO,                                         
MFA-TR*                :MH-PREMISE-NO,                                          
MFA-TR*                :MH-USER-ID,                                             
MFA-TR*                :MH-APPL-PROGRAM-ID,                                     
MFA-TR*                :MH-TRAN-COMMENT,                                        
MFA-TR*                :MH-ENTITY-KEY-DESC)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23339*                                                                         
T23339     IF SQLCODE = 0                                               
T23339         CONTINUE                                                 
T23339     ELSE                                                         
T23339         DISPLAY '**  ERROR ON 1450-INSERT-MN-TRANS-HIST    **'   
T23339         DISPLAY '**  COULD NOT INSERT IN CSS_MNT_TRAN_HIST **'   
T23339         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
T23339         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
T23339         PERFORM 9900-ABEND                THRU 9900-EXIT         
T23339     END-IF.                                                      
T23339*                                                                         
T23339 1450-EXIT.                                                       
T23339     EXIT.                                                        
T23339*                                                                         
T23339******************************************************************        
T23339* INSERT A ROW INTO CSS_MT_TRN_HST_DET                           *        
T23339******************************************************************        
T23339*                                                                         
T23339 1460-INSERT-MN-TRN-HST-DET.                                      
T23339*                                                                         
T23339     EXEC SQL                                                     
T23339          INSERT INTO CSS_MT_TRN_HST_DET                          
T23339               ( TRANS_HIST_SEQ_NO,                               
T23339                 TRAN_APPL_NO,                                    
T23339                 COLUMN_DESC,                                     
T23339                 TABLE_ID,                                        
T23339                 PRV_COLUMN_VALUE,                                
T23339                 CHG_COLUMN_VALUE)                                
T23339          VALUES                                                  
T23339               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),               
T23339                 :MI-TRAN-APPL-NO,                                
T23339                 :MI-COLUMN-DESC,                                 
T23339                 :MI-TABLE-ID,                                    
T23339                 :MI-PRV-COLUMN-VALUE,                            
T23339                 :MI-CHG-COLUMN-VALUE)                            
T23339     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MT_TRN_HST_DET                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                TRAN_APPL_NO,                                            
MFA-TR*                COLUMN_DESC,                                             
MFA-TR*                TABLE_ID,                                                
MFA-TR*                PRV_COLUMN_VALUE,                                        
MFA-TR*                CHG_COLUMN_VALUE)                                        
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MI-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MI-TRAN-APPL-NO,                                        
MFA-TR*                :MI-COLUMN-DESC,                                         
MFA-TR*                :MI-TABLE-ID,                                            
MFA-TR*                :MI-PRV-COLUMN-VALUE,                                    
MFA-TR*                :MI-CHG-COLUMN-VALUE)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23339*                                                                         
T23339     IF SQLCODE = 0                                               
T23339         CONTINUE                                                 
T23339     ELSE                                                         
T23339         DISPLAY '** ERROR ON 1460-INSERT-MN-TRN-HST-DET    **'   
T23339         DISPLAY '** COULD NOT INSERT IN CSS_MT_TRN_HST_DET **'   
T23339         DISPLAY '** RETURN CODE    = ' SQLCODE                   
T23339         DISPLAY '** ACCOUNT-NO     = ' AT-ACCOUNT-NO             
T23339         PERFORM 9900-ABEND                THRU 9900-EXIT         
T23339     END-IF.                                                      
T23339*                                                                         
T23339 1460-EXIT.                                                       
T23339     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PROCESSES THE ACCOUNTS FOR DROPING THEM FROM EPP               *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-EPP.                                                
      *                                                                         
ACT174     IF  ( AT-CODE-LPC-XMT     = SPACE                            
ACT174           OR AT-CODE-LPC-XMT  = 'B')                             
ACT003      AND  AT-NOTICE-EXEMPT-CD = SPACE                            
ACT003      AND  AT-CODE-DISC-OK     = SPACE                            
ACT003         CONTINUE                                                 
ACT003     ELSE                                                         
ACT003         GO TO 2000-EXIT                                          
ACT003     END-IF.                                                      
      *                                                                         
           PERFORM 7250-SELECT-ARR-HIST        THRU 7250-EXIT           
      *                                                                         
           MOVE WS-50                          TO BU-PYMT-PRIORITY-LVL  
C34569                                            BH-PYMT-PRIORITY-LVL  
                                                  AC-PYMT-PRIORITY-LVL. 
           MOVE WS-01                          TO BU-BP-ITEM-ID         
C34569                                            BH-ITEM-ID            
                                                  AC-ITEM-ID.           
      *                                                                         
           PERFORM 7200-SELECT-AR-DETAILS      THRU 7200-EXIT           
      *                                                                         
ACT004     SET  NOT-FIRST-MTH-AFTER-SETUP TO TRUE.                      
ACT004     PERFORM 7021-CHECK-BBP-SETUP-DATE     THRU 7021-EXIT.        
      *                                                                         
ACT004     IF ( (FIRST-MTH-AFTER-SETUP AND                              
ACT004           WS-AMT-ARREARS-UTL >  WS-EPP-DELINQ-VALUE)             
ACT004                       OR                                         
ACT004          (NOT-FIRST-MTH-AFTER-SETUP AND                          
ACT004           AC-AMT-AR-DAY-00 + WS-AMT-ARREARS-UTL                  
ACT004                                > WS-EPP-DELINQ-VALUE) )          
ACT004         AND (CZ-ARREARS-HIST(1:1) NOT EQUAL 0 AND                
C25416                                    NOT EQUAL SPACES AND          
C25416                                    NOT EQUAL LOW-VALUES)         
                    CONTINUE                                            
           ELSE                                                         
                 GO TO 2000-EXIT                                        
           END-IF.                                                      
      *                                                                         
           PERFORM 7300-SELECT-BUD-PLAN        THRU 7300-EXIT           
      *                                                                         
           IF  AT-CREDIT-GROUP = 'C'                                    
C33934      OR (BU-DATE-PYMT-STRT (6:2) = WS-COMMON-DATE (6:2)          
C33934      AND SEB-DATABASE)                                           
                CONTINUE                                                
           ELSE                                                         
             IF (AC-AMT-TRAN-BALANCE > WS-AMT-EPP-DELINQ-VALUE          
              AND E-FDB07-OFF-CYCLE-BILL-CODE NOT EQUAL 'O')            
                 DISPLAY 'BBP ACCOUNT NO ', E-FDB07-ACCT-NO             
C34569           PERFORM 2400-INS-TRANS-HIST  THRU 2400-EXIT            
                 PERFORM 5255-REMOVE-FROM-EPP THRU 5255-EXIT            
P00307           MOVE AT-ACCOUNT-NO           TO YP-ACCOUNT-NO          
P00307           MOVE 'BBP_REVIEW_EXEMPT'     TO YP-ATTRIBUTE-DESC      
P00307           PERFORM 8940-DELETE-ACCT-ATTR THRU 8940-EXIT           
             END-IF                                                     
T23339     END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * PROCESSES THE ACCOUNTS FOR DROPPING THEM FROM DPP              *        
      ******************************************************************        
T23238*                                                                         
T23238 2100-CHECK-DPP.                                                  
T23238*                                                                         
T23238     MOVE WS-90                          TO DA-PYMT-PRIORITY-LVL  
T23238                                            AC-PYMT-PRIORITY-LVL. 
T23238     MOVE WS-0                           TO AC-ITEM-ID            
T23238                                            WS-AC-ITEM-ID.        
P00471     MOVE 'B'                            TO WS-DPP-DROP-CALL-TYPE.
T23238*                                                                         
T23238     MOVE AC-ACCOUNT-NO                  TO WS-AC-ACCOUNT-NO      
T23238     MOVE AC-PYMT-PRIORITY-LVL           TO                       
T23238                                           WS-AC-PYMT-PRIORITY-LVL
T23238     PERFORM 7410-OPEN-DET-AR-CNTL       THRU 7410-EXIT           
T23238     PERFORM 7420-FETCH-DET-AR-CNTL      THRU 7420-EXIT           
T23238     PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
T23238        PERFORM 2150-PROCESS-DPP         THRU 2150-EXIT           
T23238     END-PERFORM.                                                 
T23238     PERFORM 7430-CLOSE-DET-AR-CNTL      THRU 7430-EXIT.          
T23238*                                                                         
T23238 2100-EXIT.                                                       
T23238     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* PROCESSES THE ACCOUNTS FOR EPP                                 *        
C27405******************************************************************        
C27405*                                                                         
C27405 2200-PROCESS-EPP-ACCTS.                                          
C27405*                                                                         
C27405     MOVE WS-N                              TO                    
C27405                                         WS-SEASONAL-RATE-ACCT    
C27405                                         WS-POP-ANNIV-DATA.       
C27405     IF WS-INPUT-DATE(1:7) = BU-ANNIVERSARY-DATE(1:7)             
C27405        PERFORM 7810-OPEN-EPP-SEAS-RATE     THRU 7810-EXIT        
C27405        PERFORM 7820-FETCH-EPP-SEAS-RATE    THRU 7820-EXIT        
C27405           UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND OR         
C27405              WS-SEASONAL-RATE-ACCT = WS-Y                        
C27405        PERFORM 7830-CLOSE-EPP-SEAS-RATE    THRU 7830-EXIT        
C27405        IF SEASONAL-RATE-ACCT                                     
C27405           PERFORM 2210-POPULATE-BG-CX      THRU 2210-EXIT        
C27405           IF WS-POP-ANNIV-DATA = 'Y'                             
C27405              PERFORM 2214-CREATE-MNT       THRU 2214-EXIT        
C27405              DISPLAY 'BBP ANNIVERSARY DATA POPULATED '           
C27405              DISPLAY 'IN BG AND CX FOR ACCT #' AT-ACCOUNT-NO     
C27405              PERFORM 2215-POP-BG-CX-1YEAR-DATA                   
C27405                                            THRU 2215-EXIT        
C27405           END-IF                                                 
C27405        END-IF                                                    
C27405     END-IF.                                                      
C27405                                                                  
C27405*                                                                         
C27405 2200-EXIT.                                                       
C27405     EXIT.                                                        
      *                                                                         
C27405******************************************************************        
C27405* POPULATE BILLING DETAILS AND CONSUMPTION                       *        
C27405******************************************************************        
C27405*                                                                         
C27405 2210-POPULATE-BG-CX.                                             
C27405*                                                                         
C27405     MOVE WS-REVENUE-MONTH-PARM          TO WS-SPLIT-REVMTH       
C27405     PERFORM 2212-SUBTRACT1-FROM-REVMTH  THRU 2212-EXIT           
C27405          11 TIMES.                                               
C27405     MOVE WS-REVENUE-MONTH-NUM          TO WS-REVMTH-12MTHS-AGO.  
C27405*                                                                         
C27405     PERFORM 7050-SELECT-TIMESTAMP       THRU 7050-EXIT.          
C27405     PERFORM 7850-GET-MAX-BI-BILLNO      THRU 7850-EXIT.          
C27405     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C27405        GO TO 2210-EXIT                                           
C27405     END-IF.                                                      
C27405*                                                                         
C27405     PERFORM 7840-GET-BG-CX-DETAILS      THRU 7840-EXIT.          
C27405     MOVE BG-REVENUE-MONTH               TO WS-HOLD-REVENUE-MONTH 
C27405     PERFORM UNTIL BG-BILL-NO = BI-BILL-NO                        
C27405         ADD 1                           TO BG-BILL-NO            
C27405         PERFORM 7855-GET-BI-DETAILS     THRU 7855-EXIT           
C27405         IF BI-DATE-BILLED EQUAL SPACES                           
C27405            MOVE WS-CURRENT-DATE         TO CX-DATE-READ          
C27405            MOVE WS-CURRENT-TIMESTAMP    TO CX-BILL-ITEM-TIMESTMP 
C27405                                            BG-BILL-ITEM-TIMESTMP 
C27405         ELSE                                                     
C27405            MOVE BI-DATE-BILLED          TO CX-DATE-READ          
C27405            MOVE BI-LAST-UPDATE-TS       TO CX-BILL-ITEM-TIMESTMP 
C27405                                            BG-BILL-ITEM-TIMESTMP 
C27405         END-IF                                                   
C27405*                                                                         
C27405         MOVE BG-REVENUE-MONTH           TO WS-REVENUE-MONTH-NUM  
C27405         MOVE WS-REVENUE-MONTH-NUM       TO WS-SPLIT-REVMTH       
C27405         ADD 1                           TO WS-SPLIT-MONTH        
C27405         IF WS-SPLIT-MONTH = 13                                   
C27405            MOVE 1                       TO WS-SPLIT-MONTH        
C27405            ADD 1                        TO WS-SPLIT-YEAR         
C27405         END-IF                                                   
C27405         MOVE WS-SPLIT-REVMTH            TO WS-REVENUE-MONTH-NUM  
C27405         IF BG-BILL-NO = BI-BILL-NO                               
C27405            MOVE ZERO                    TO BG-REVENUE-MONTH      
C27405         ELSE                                                     
C27405            MOVE WS-REVENUE-MONTH-NUM    TO BG-REVENUE-MONTH      
C27405         END-IF                                                   
C27405*                                                                         
C27405         MOVE SPACES                     TO BG-DATE-ORIG-BILL     
C27405                                            BG-PRORATE-CD         
C27405                                            BG-TAX-REFUND-CD      
C27405                                            BG-DATE-LFTM-HI-DMD   
C27405                                            BG-REBILL-IND         
C27405                                            BG-ADJ-REASON-CD      
C27405                                            CX-CODE-DISCOUNT      
C27405         MOVE ZEROS                      TO BG-AMT-BILL-ITEM      
C27405                                            BG-AMT-STATE-TAX      
C27405                                            BG-CODE-SIC-NO        
C27405                                            BG-AMT-CITY-TAX       
C27405                                            BG-AMT-OTHER-TAX      
C27405                                            BG-CODE-CURTAIL-PRTY  
C27405                                            BG-CODE-SUB-TOTAL     
C27405                                            BG-LFTM-HI-PEAK-DMD   
C27405                                            BG-GAS-BASE-USE       
C27405                                            BG-WNA-FACTOR         
C27405                                            BG-BTU-FACTOR         
C27405                                            BG-NO-OF-CONS-DAYS    
C27405                                            BG-REV-MTH-ORIG-BILL  
C27405         MOVE 'A'                        TO BG-CODE-BILL-CALC     
C27405                                            BG-CODE-BILL-ITM-IND  
C27405                                            CX-CODE-USAGE-ID      
C27405                                            CX-CODE-SOURCE-ID     
C27405                                            CX-CODE-ITEM-STATUS   
C27405         MOVE 'C'                        TO BG-CODE-BILL-ITM-TYPE 
C27405                                            CX-CODE-USAGE-TYPE    
C27405         MOVE 'D'                        TO BG-CODE-DR-CR-CNSMPTN 
C27405                                            CX-CODE-DEBIT-CREDIT  
C27405         MOVE 0.0                        TO BG-CODE-CURTAIL-PRTY  
C27405         MOVE .0000                      TO BG-NEW-RATE-PCT       
C27405         MOVE BG-BILL-NO                 TO CX-BILL-NO            
C27405         MOVE 'B'                        TO CX-CODE-USAGE-SOURCE  
C27405         MOVE ZERO                       TO CX-DEMAND-READING     
C27405                                            CX-NO-UNITS           
C27405                                            CX-NO-DEMAND-UNITS    
C27405                                            CX-NO-DAYS            
C27405                                            CX-REQUESTED-USAGE    
C27405         MOVE -1                         TO WS-NULL-INDICATOR     
C27405         MOVE 'Y'                        TO WS-POP-ANNIV-DATA     
C27405         PERFORM 8010-INSERT-BG-DETAILS  THRU 8010-EXIT           
C27405         PERFORM 8020-INSERT-CX-DETAILS  THRU 8020-EXIT           
C27405     END-PERFORM.                                                 
C27405*                                                                         
C27405 2210-EXIT.                                                       
C27405     EXIT.                                                        
      *                                                                         
C27405 2212-SUBTRACT1-FROM-REVMTH.                                      
C27405*                                                                         
C27405      SUBTRACT 1 FROM  WS-SPLIT-MONTH.                            
C27405      IF WS-SPLIT-MONTH = 00                                      
C27405         MOVE 12                         TO WS-SPLIT-MONTH        
C27405         SUBTRACT 1 FROM WS-SPLIT-YEAR                            
C27405      END-IF                                                      
C27405      MOVE WS-SPLIT-REVMTH               TO WS-REVENUE-MONTH-NUM. 
C27405*                                                                         
C27405 2212-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* CREATE TRANSACTION HISTORY                                     *        
C27405******************************************************************        
C27405*                                                                         
C27405 2214-CREATE-MNT.                                                 
C27405*                                                                         
C27405     PERFORM 7050-SELECT-TIMESTAMP    THRU 7050-EXIT.             
C27405*                                                                         
C27405     MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
C27405     MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
C27405     MOVE WS-F                        TO MH-CODE-TRAN-TYPE.       
C27405     MOVE SPACES                      TO MH-RESP-AREA-ID.         
C27405     MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
C27405     MOVE AT-CUSTOMER-NO              TO MH-CUSTOMER-NO.          
C27405     MOVE AT-PREMISE-NO               TO MH-PREMISE-NO.           
C27405     MOVE 'SYSTEM'                    TO MH-USER-ID.              
C27405     MOVE WS-SEAS-EPP-BG-CX           TO MH-APPL-PROGRAM-ID.      
C27405     MOVE +67                         TO MH-TRAN-COMMENT-LEN      
C27405     MOVE WS-SEAS-EPP-BG-CX-DESC      TO MH-TRAN-COMMENT-TEXT     
C27405     MOVE +0                          TO MH-ENTITY-KEY-DESC-LEN.  
C27405     MOVE SPACES                      TO MH-ENTITY-KEY-DESC-TEXT. 
C27405*                                                                         
C27405     MOVE WS-CURRENT-TIMESTAMP        TO MI-TRANS-HIST-SEQ-NO.    
C27405     MOVE 1                           TO MI-TRAN-APPL-NO.         
C27405     MOVE 'BG CX INSERTS'             TO MI-COLUMN-DESC.          
C27405     MOVE '12'                        TO MI-TABLE-ID.             
C27405     MOVE +0                          TO MI-PRV-COLUMN-VALUE-LEN. 
C27405     MOVE SPACES                      TO MI-PRV-COLUMN-VALUE-TEXT.
C27405     MOVE +0                          TO MI-CHG-COLUMN-VALUE-LEN. 
C27405     MOVE SPACES                      TO MI-CHG-COLUMN-VALUE-TEXT.
C27405     PERFORM 1450-INSERT-MN-TRANS-HIST  THRU 1450-EXIT.           
C27405     PERFORM 1460-INSERT-MN-TRN-HST-DET THRU 1460-EXIT.           
C27405*                                                                         
C27405 2214-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* POPULATE 1 YEAR'S CONSUMPTION AND BLLING DETAILS               *        
C27405******************************************************************        
C27405*                                                                         
C27405 2215-POP-BG-CX-1YEAR-DATA.                                       
C27405*                                                                         
C27405     MOVE WS-HOLD-REVENUE-MONTH        TO BG-REVENUE-MONTH.       
C27405*                                                                         
C27405     PERFORM UNTIL BG-REVENUE-MONTH < WS-REVMTH-12MTHS-AGO        
C27405         PERFORM 7845-SELECT-BG-CX-DET THRU 7845-EXIT             
C27405         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -811   
C27405            MOVE BG-PREMISE-NO         TO WS-BG-PREMISE-NO        
C27405            MOVE BG-BILL-NO            TO WS-BG-BILL-NO           
C27405            MOVE BG-IC-NO              TO WS-BG-IC-NO             
C27405            MOVE BG-CODE-UTIL-TYPE     TO WS-BG-CODE-UTIL-TYPE    
C27405            MOVE BG-BILL-ITEM-TIMESTMP TO WS-BG-BILL-ITEM-TIMESTMP
C27405            MOVE BG-CODE-REVENUE-CLASS TO WS-BG-CODE-REVENUE-CLASS
C27405            MOVE BG-RATE-PLAN-NO       TO WS-BG-RATE-PLAN-NO      
C27405            MOVE BG-COMPANY-NO         TO WS-BG-COMPANY-NO        
C27405            MOVE BG-REVENUE-MONTH      TO WS-REVENUE-MONTH-NUM    
C27405            MOVE WS-REVENUE-MONTH-NUM  TO WS-SPLIT-REVMTH         
C27405            PERFORM 2212-SUBTRACT1-FROM-REVMTH THRU 2212-EXIT     
C27405            MOVE WS-REVENUE-MONTH-NUM  TO BG-REVENUE-MONTH        
C27405            MOVE BG-REVENUE-MONTH      TO WS-BG-REVENUE-MONTH     
C27405            MOVE CX-MTR-REF-NO         TO WS-CX-MTR-REF-NO        
C27405            MOVE CX-METER-NO           TO WS-CX-METER-NO          
C27405            MOVE CX-EMPLOYEE-NO        TO WS-CX-EMPLOYEE-NO       
C27405            MOVE CX-CONSTANT           TO WS-CX-CONSTANT          
C27405            MOVE CX-NO-DIALS           TO WS-CX-NO-DIALS          
C27405            MOVE CX-CODE-METER-READ    TO WS-CX-CODE-METER-READ   
C27405            MOVE CX-METER-READING      TO WS-CX-METER-READING     
C27405         ELSE                                                     
C27405            SUBTRACT 1  FROM WS-BG-BILL-NO                        
C27405            MOVE WS-BG-BILL-NO         TO BG-BILL-NO              
C27405                                          CX-BILL-NO              
C27405            MOVE WS-BG-REVENUE-MONTH   TO BG-REVENUE-MONTH        
C27405            MOVE WS-SPLIT-MONTH        TO WS-CX-MM                
C27405            MOVE WS-SPLIT-YEAR         TO WS-CX-CCYY              
C27405            MOVE '01'                  TO WS-CX-DD                
C27405            MOVE WS-CX-DATE-READ       TO CX-DATE-READ            
C27405            MOVE AT-ACCOUNT-NO         TO BG-ACCOUNT-NO           
C27405                                          CX-ACCOUNT-NO           
C27405            MOVE WS-BG-BILL-ITEM-TIMESTMP                         
C27405                                       TO BG-BILL-ITEM-TIMESTMP   
C27405                                          CX-BILL-ITEM-TIMESTMP   
C27405            MOVE CX-DATE-READ          TO                         
C27405                                      CX-BILL-ITEM-TIMESTMP(1:10) 
C27405                                      BG-BILL-ITEM-TIMESTMP(1:10) 
C27405            MOVE WS-BG-PREMISE-NO      TO BG-PREMISE-NO           
C27405            MOVE WS-BG-IC-NO           TO BG-IC-NO                
C27405                                          CX-IC-NO                
C27405            MOVE WS-BG-CODE-UTIL-TYPE  TO BG-CODE-UTIL-TYPE       
C27405                                          CX-CODE-UTIL-TYPE       
C27405            MOVE WS-BG-CODE-REVENUE-CLASS TO BG-CODE-REVENUE-CLASS
C27405            MOVE WS-BG-RATE-PLAN-NO    TO BG-RATE-PLAN-NO         
C27405            MOVE WS-BG-COMPANY-NO      TO BG-COMPANY-NO           
C27405                                          CX-COMPANY-NO           
C27405            MOVE WS-CX-MTR-REF-NO      TO CX-MTR-REF-NO           
C27405            MOVE WS-CX-METER-NO        TO CX-METER-NO             
C27405            MOVE WS-CX-EMPLOYEE-NO     TO CX-EMPLOYEE-NO          
C27405            MOVE WS-CX-CONSTANT        TO CX-CONSTANT             
C27405            MOVE WS-CX-NO-DIALS        TO CX-NO-DIALS             
C27405            MOVE WS-CX-CODE-METER-READ TO CX-CODE-METER-READ      
C27405            MOVE WS-CX-METER-READING   TO CX-METER-READING        
C27405*                                                                         
C27405            MOVE SPACES                TO BG-DATE-ORIG-BILL       
C27405                                          BG-PRORATE-CD           
C27405                                          BG-TAX-REFUND-CD        
C27405                                          BG-DATE-LFTM-HI-DMD     
C27405                                          BG-REBILL-IND           
C27405                                          BG-ADJ-REASON-CD        
C27405                                          BG-CODE-STAT-TAX-XMT    
C27405                                          BG-CODE-CITY-TAX-XMT    
C27405                                          BG-CODE-OTHR-TAX-XMT    
C27405                                          BG-REV-RPT-CD           
C27405                                          BG-STANDBY-COMPLIED     
C27405                                          BG-PRORATE-CD           
C27405                                          BG-REV-DISTRICT-CD      
C27405                                          BG-FUEL-SHIPPER-CD      
C27405                                          CX-CODE-DISCOUNT        
C27405                                          CX-EXCEPT-OVERRIDE-CD   
C27405                                          CX-DIGTL-INTRL-MTR-NO   
C27405                                          CX-DIGTL-MTR-TYPE       
C27405                                          CX-CODE-TOU-SEASN       
C27405                                          CX-EXCL-DMD-RCHT-IND    
C27405            MOVE ZEROS                 TO BG-AMT-BILL-ITEM        
C27405                                          BG-AMT-STATE-TAX        
C27405                                          BG-AMT-CITY-TAX         
C27405                                          BG-AMT-OTHER-TAX        
C27405                                          BG-CODE-CURTAIL-PRTY    
C27405                                          BG-CODE-SUB-TOTAL       
C27405                                          BG-LFTM-HI-PEAK-DMD     
C27405                                          BG-GAS-BASE-USE         
C27405                                          BG-WNA-FACTOR           
C27405                                          BG-BTU-FACTOR           
C27405                                          BG-NO-OF-CONS-DAYS      
C27405                                          BG-REV-MTH-ORIG-BILL    
C27405                                          CX-CODE-TIME-PERIOD     
C27405            MOVE 1                     TO CX-ITEM-SEQ-NO          
C27405                                          CX-REG-ID-NO            
C27405            MOVE 'A'                   TO BG-CODE-BILL-CALC       
C27405                                          BG-CODE-BILL-ITM-IND    
C27405                                          CX-CODE-USAGE-ID        
C27405                                          CX-CODE-SOURCE-ID       
C27405                                          CX-CODE-ITEM-STATUS     
C27405            MOVE 'C'                   TO BG-CODE-BILL-ITM-TYPE   
C27405                                          CX-CODE-USAGE-TYPE      
C27405            MOVE 'D'                   TO BG-CODE-DR-CR-CNSMPTN   
C27405                                          CX-CODE-DEBIT-CREDIT    
C27405            MOVE 0.0                   TO BG-CODE-CURTAIL-PRTY    
C27405            MOVE .0000                 TO BG-NEW-RATE-PCT         
C27405            MOVE 'B'                   TO CX-CODE-USAGE-SOURCE    
C27405            MOVE ZERO                  TO CX-DEMAND-READING       
C27405                                          CX-NO-UNITS             
C27405                                          CX-NO-DEMAND-UNITS      
C27405                                          CX-NO-DAYS              
C27405                                          CX-REQUESTED-USAGE      
C27405            MOVE -1                    TO WS-NULL-INDICATOR       
C27405            PERFORM 8010-INSERT-BG-DETAILS  THRU 8010-EXIT        
C27405            PERFORM 8020-INSERT-CX-DETAILS  THRU 8020-EXIT        
C27405            MOVE BG-REVENUE-MONTH      TO WS-REVENUE-MONTH-NUM    
C27405            MOVE WS-REVENUE-MONTH-NUM  TO WS-SPLIT-REVMTH         
C27405            PERFORM 2212-SUBTRACT1-FROM-REVMTH THRU 2212-EXIT     
C27405            MOVE WS-REVENUE-MONTH-NUM  TO BG-REVENUE-MONTH        
C27405                                          WS-BG-REVENUE-MONTH     
C27405         END-IF                                                   
C27405     END-PERFORM.                                                 
C27405*                                                                         
C27405 2215-EXIT.                                                       
C27405     EXIT.                                                        
      *                                                                         
T23238******************************************************************        
T23238* PROCESS DPP ACCOUNTS                                           *        
T23238******************************************************************        
T23238*                                                                         
T23238 2150-PROCESS-DPP.                                                
T23238*                                                                         
T23238     MOVE WS-AC-ITEM-ID                     TO DA-DFA-ITEM-ID     
T23238                                               WS-DFA-ITEM-ID.    
P00471     MOVE AT-ACCOUNT-NO                     TO YP-ACCOUNT-NO.     
P00471     MOVE SPACES  TO WS-ATTRIBUTE-VALUE-CD                        
P00471     PERFORM 7560-CHECK-DPP-DROP-EXEMPT     THRU 7560-EXIT.       
T23238     PERFORM 7500-SELECT-CODE-DFA-DESC      THRU 7500-EXIT.       
T23238*                                                                         
T23238     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T26415         IF DA-CODE-DFA-TYPE EQUAL 'A'                            
T26415            MOVE 'Y'                        TO WS-DFA-FLAG        
T26415         ELSE                                                     
P00471            IF WS-ATTRIBUTE-VALUE-CD > SPACE                      
P00471               CONTINUE                                           
P00471            ELSE                                                  
T23238               DISPLAY 'DPP ACCOUNT NO ', E-FDB07-ACCT-NO         
P00471               PERFORM 5260-REMOVE-FROM-DPP THRU 5260-CPD109-EXIT 
P00471            END-IF                                                
T26415        END-IF                                                    
T23238     END-IF.                                                      
T23238*                                                                         
T23238     PERFORM 7420-FETCH-DET-AR-CNTL         THRU 7420-EXIT.       
T23238*                                                                         
T23238 2150-EXIT.                                                       
T23238     EXIT.                                                        
T26264*                                                                         
C34569******************************************************************        
C34569* MOVE DATA FOR TRANS HIST TABLES.                               *        
C34569******************************************************************        
C34569 2400-INS-TRANS-HIST.                                             
C34569*                                                                         
C34569     PERFORM 7050-SELECT-TIMESTAMP  THRU 7050-EXIT.               
C34569*                                                                         
C34569     MOVE WS-CURRENT-TIMESTAMP      TO MH-TRANS-HIST-SEQ-NO.      
C34569     MOVE WS-CURRENT-DATE           TO MH-DATE-TRANS.             
C34569     MOVE WS-F                      TO MH-CODE-TRAN-TYPE.         
C34569     MOVE SPACES                    TO MH-RESP-AREA-ID.           
C34569     MOVE AT-ACCOUNT-NO             TO MH-ACCOUNT-NO.             
C34569     MOVE AT-CUSTOMER-NO            TO MH-CUSTOMER-NO.            
C34569     MOVE AT-PREMISE-NO             TO MH-PREMISE-NO.             
C34569     MOVE 'SYSTEM'                  TO MH-USER-ID.                
C34569     MOVE WS-1RATE-EPP-MNT          TO MH-APPL-PROGRAM-ID         
C34569     MOVE +50                       TO MH-TRAN-COMMENT-LEN        
C34569     MOVE WS-BBP-DROP-COMMENT       TO MH-TRAN-COMMENT-TEXT       
C34569     MOVE +0                        TO MH-ENTITY-KEY-DESC-LEN.    
C34569     MOVE SPACES                    TO MH-ENTITY-KEY-DESC-TEXT.   
C34569*                                                                         
C28515     PERFORM 4510-INSERT-MN-TRANS-HIST                            
C28515                                    THRU 4510-EXIT.               
C34569*                                                                         
C34569 2400-EXIT.                                                       
C34569     EXIT.                                                        
C34569*                                                                         
A00755******************************************************************        
A00755* 2450-GET-REV-MNTH-CUR.                                         *        
A00755******************************************************************        
A00755*                                                                         
A00755 2450-GET-REV-MNTH-CUR.                                           
A00755*                                                                         
A00755     MOVE  AT-BILL-CYCLE        TO WS-BIL-CYCLE.                  
A00755*                                                                         
A02036     SET WS-BILL-CYC-INDX       TO 1.                             
A00755     SEARCH WS-FCA00-BILLING-CYCLES                               
A00755         AT END                                                   
A00755            SET REV-MNTH-NOT-FOUND TO TRUE                        
A00755       WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL        
A00755            WS-BIL-CYCLE                                          
A00755            MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX) TO         
A00755                 WS-REV-MNTH-CUR                                  
A00755            SET REV-MNTH-FOUND    TO TRUE                         
A00755     END-SEARCH.                                                  
A00755*                                                                         
A00755     IF REV-MNTH-NOT-FOUND                                        
A00755        MOVE ZEROES              TO WS-REV-MNTH-PREV              
A00755                                    WS-REV-MNTH-OLDEST            
A00755        MOVE 1                   TO WS-INDEX                      
A00755        PERFORM 4525-GET-OLDEST-REV-MONTH THRU 4525-EXIT          
A00755          UNTIL WS-FCA00-BLCYC-NUMBER(WS-INDEX) = '00'            
A00755             OR WS-INDEX >= 8                                     
A00755        MOVE WS-REV-MNTH-OLDEST TO WS-REV-MNTH-CUR                
A00755     END-IF.                                                      
A00755*                                                                         
A00755 2450-EXIT.                                                       
A00755     EXIT.                                                        
A00755*                                                                         
A00755******************************************************************        
A00755* 2500-VALIDATE-BBP-ANNIV-DT.                                    *        
A00755*      BUMP-UP BBP ANNIV DT WHEN PYMT START DT IS NOT EQUAL TO   *        
A00755*      REV MONTH DT.                                             *        
A00755******************************************************************        
A00755*                                                                         
A00755 2500-VALIDATE-BBP-ANNIV-DT.                                      
A00755*                                                                         
A00755     MOVE WS-REV-MNTH-CUR(1:4)       TO WS-REV-MNTH-YYYY          
A00755     MOVE WS-REV-MNTH-CUR(5:2)       TO WS-REV-MNTH-MM            
A00755     MOVE WS-50                      TO BU-PYMT-PRIORITY-LVL      
A00755     MOVE WS-01                      TO BU-BP-ITEM-ID             
A00755* Get Anniversary & Payment Start Dates                                   
A00755     PERFORM 7300-SELECT-BUD-PLAN    THRU 7300-EXIT               
A00755     MOVE BU-ANNIVERSARY-DATE        TO WS-ANNIV-DT-CUR           
A00755     MOVE BU-DATE-PYMT-STRT          TO WS-PYMT-STRT-DT           
ACT088*    COMPUTE DIFFERENCE EXPRESSED IN MONTHS                               
ACT088     PERFORM 7925-COMPUTE-DIFFERENCE THRU                         
ACT088             7925-COMPUTE-DIFFERENCE-EXIT                         
A00755* If Pymt Start Date Is Not current Rev Month Date                        
A00755     IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  AND             
ACT088        WS-REV-MNTH-DT NOT EQUAL BU-DATE-PYMT-STRT                
ACT088        AND WS-TIME-DIFFERENCE >= 11)                             
A00755        PERFORM 7050-SELECT-TIMESTAMP    THRU 7050-EXIT           
A00755        MOVE  WS-REV-MNTH-DT         TO BU-DATE-PYMT-STRT         
A00755        PERFORM 7030-GET-NEW-ANNIV-DT    THRU 7030-EXIT           
A00755        MOVE WS-ANNIV-DT-NEW         TO BU-ANNIVERSARY-DATE       
A00755* Insert Budget History                                                   
A00755        PERFORM 7020-SELECT-BUDGET-HIST  THRU 7020-EXIT           
A00755        MOVE BU-DATE-PYMT-STRT       TO BH-DATE-PYMT-STRT         
A00755        MOVE WS-CURRENT-TIMESTAMP    TO BH-LAST-UPDATE-TS         
A00755        MOVE 12                      TO BH-EPP-MTHS-RMNG-QT       
A00755        IF BH-REMARKS-LEN > 180                                   
A00755           CONTINUE                                               
A00755        ELSE                                                      
A00755           IF BH-REMARKS-LEN = 0                                  
A00755              MOVE 1                 TO BH-REMARKS-LEN            
A00755           ELSE                                                   
A00755              ADD  1                 TO BH-REMARKS-LEN            
A00755           END-IF                                                 
A00755           MOVE WS-BBP-MNT-COMMENT   TO                           
A00755                        BH-REMARKS-TEXT (BH-REMARKS-LEN:30)       
A00755           ADD  29                   TO BH-REMARKS-LEN            
A00755        END-IF                                                    
P00794        MOVE 'SYSTEM'                TO BH-LAST-UPDATE-USERID     
A00755        PERFORM 8650-UPDATE-BUDGET-HIST  THRU 8650-EXIT           
A00755        MOVE 'M'                     TO BH-CHANGE-REASON          
A00755        MOVE SPACES                  TO BH-METHOD-OF-ESTIMATE     
A00755        MOVE WS-CURRENT-TIMESTAMP    TO BH-BUD-HIST-SEQ-NO        
A00755                                        BU-LAST-UPDATE-TS         
A00755        PERFORM 8700-INSERT-BUDGET-HIST  THRU 8700-EXIT           
A00755* Update Anniversary & Payment Dates                                      
A00755        PERFORM 8750-UPDATE-BUDGET-PLAN  THRU 8750-EXIT           
A00755        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A00755* Data For CSS_MNT_TRANS_HIST                                             
A00755           MOVE WS-CURRENT-TIMESTAMP TO MH-TRANS-HIST-SEQ-NO      
A00755           MOVE WS-CURRENT-DATE      TO MH-DATE-TRANS             
A00755           MOVE WS-F                 TO MH-CODE-TRAN-TYPE         
A00755           MOVE SPACES               TO MH-RESP-AREA-ID           
A00755           MOVE AT-ACCOUNT-NO        TO MH-ACCOUNT-NO             
A00755           MOVE AT-CUSTOMER-NO       TO MH-CUSTOMER-NO            
A00755           MOVE AT-PREMISE-NO        TO MH-PREMISE-NO             
A00755           MOVE 'SYSTEM'             TO MH-USER-ID                
A00755           MOVE +32                  TO MH-TRAN-COMMENT-LEN       
A00755           MOVE WS-MNT-COMMENT       TO MH-TRAN-COMMENT-TEXT      
A00755           MOVE 'PANEL147A'          TO MH-APPL-PROGRAM-ID        
A00755           MOVE +0                   TO MH-ENTITY-KEY-DESC-LEN    
A00755           MOVE SPACES               TO MH-ENTITY-KEY-DESC-TEXT   
A00755*                                                                         
A00755           PERFORM 1450-INSERT-MN-TRANS-HIST  THRU 1450-EXIT      
A00755* Data For CSS_MT_TRN_HST_DET                                             
A00755           MOVE WS-CURRENT-TIMESTAMP TO MI-TRANS-HIST-SEQ-NO      
A00755           MOVE 1                    TO MI-TRAN-APPL-NO           
A00755           MOVE 'DATE PYMT STRT'     TO MI-COLUMN-DESC            
A00755           MOVE SPACES               TO MI-TABLE-ID               
A00755           MOVE 10                   TO MI-PRV-COLUMN-VALUE-LEN   
A00755           MOVE WS-PYMT-STRT-DT      TO MI-PRV-COLUMN-VALUE-TEXT  
A00755           MOVE BH-DATE-PYMT-STRT    TO MI-CHG-COLUMN-VALUE-TEXT  
A00755           MOVE 10                   TO MI-CHG-COLUMN-VALUE-LEN   
A00755*                                                                         
A00755           PERFORM 1460-INSERT-MN-TRN-HST-DET THRU 1460-EXIT      
A00755*                                                                         
A00755           MOVE WS-CURRENT-TIMESTAMP TO MI-TRANS-HIST-SEQ-NO      
A00755           MOVE 2                    TO MI-TRAN-APPL-NO           
A00755           MOVE 'ANNIV DATE'         TO MI-COLUMN-DESC            
A00755           MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN   
A00755           MOVE WS-ANNIV-DT-CUR      TO MI-PRV-COLUMN-VALUE-TEXT  
A00755           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN   
A00755           MOVE BU-ANNIVERSARY-DATE  TO MI-CHG-COLUMN-VALUE-TEXT  
A00755           MOVE SPACES               TO MI-TABLE-ID               
A00755*                                                                         
A00755           PERFORM 1460-INSERT-MN-TRN-HST-DET THRU 1460-EXIT      
A00755        END-IF                                                    
A00755     ELSE                                                         
A00755        CONTINUE                                                  
A00755     END-IF.                                                      
A00755*                                                                         
A00755 2500-EXIT.                                                       
A00755     EXIT.                                                        
A00755*                                                                         
C28515******************************************************************        
C28515* INSERT A ROW INTO CSS_MNT_TRANS_HIST                           *        
C28515******************************************************************        
C28515 4510-INSERT-MN-TRANS-HIST.                                       
C28515*                                                                         
C28515     EXEC SQL                                                     
C28515          INSERT INTO CSS_MNT_TRANS_HIST                          
C28515               ( TRANS_HIST_SEQ_NO,                               
C28515                 DATE_TRANS,                                      
C28515                 CODE_TRAN_TYPE,                                  
C28515                 RESP_AREA_ID,                                    
C28515                 ACCOUNT_NO,                                      
C28515                 CUSTOMER_NO,                                     
C28515                 PREMISE_NO,                                      
C28515                 USER_ID,                                         
C28515                 APPL_PROGRAM_ID,                                 
C28515                 TRAN_COMMENT,                                    
C28515                 ENTITY_KEY_DESC)                                 
C28515          VALUES                                                  
C28515               ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
C28515                 IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
C28515                 :MH-CODE-TRAN-TYPE,                              
C28515                 :MH-RESP-AREA-ID,                                
C28515                 :MH-ACCOUNT-NO,                                  
C28515                 :MH-CUSTOMER-NO,                                 
C28515                 :MH-PREMISE-NO,                                  
C28515                 :MH-USER-ID,                                     
C28515                 :MH-APPL-PROGRAM-ID,                             
C28515                 :MH-TRAN-COMMENT,                                
C28515                 :MH-ENTITY-KEY-DESC)                             
C28515     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                USER_ID,                                                 
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                ENTITY_KEY_DESC)                                         
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MH-DATE-TRANS,                                          
MFA-TR*                :MH-CODE-TRAN-TYPE,                                      
MFA-TR*                :MH-RESP-AREA-ID,                                        
MFA-TR*                :MH-ACCOUNT-NO,                                          
MFA-TR*                :MH-CUSTOMER-NO,                                         
MFA-TR*                :MH-PREMISE-NO,                                          
MFA-TR*                :MH-USER-ID,                                             
MFA-TR*                :MH-APPL-PROGRAM-ID,                                     
MFA-TR*                :MH-TRAN-COMMENT,                                        
MFA-TR*                :MH-ENTITY-KEY-DESC)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C28515*                                                                         
C28515     IF SQLCODE = 0                                               
C28515         CONTINUE                                                 
C28515     ELSE                                                         
C28515         DISPLAY '**  ERROR ON 4510-INSERT-MN-TRANS-HIST    **'   
C28515         DISPLAY '**  COULD NOT INSERT IN CSS_MNT_TRAN_HIST **'   
C28515         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
C28515         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C28515         PERFORM 9900-ABEND                THRU 9900-EXIT         
C28515     END-IF.                                                      
C28515*                                                                         
C28515 4510-EXIT.                                                       
C28515     EXIT.                                                        
A00755*                                                                         
A00755******************************************************************        
A00755*4525-GET-OLDEST-REV-MONTH.                                      *        
A00755******************************************************************        
A00755*                                                                         
A00755 4525-GET-OLDEST-REV-MONTH.                                       
A00755*                                                                         
A00755     IF WS-FCA00-REV-MONTH (WS-INDEX) = WS-REV-MNTH-PREV          
A00755        CONTINUE                                                  
A00755     ELSE                                                         
A00755       IF WS-REV-MNTH-PREV = ZEROES                               
A00755          MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO WS-REV-MNTH-OLDEST 
A00755       END-IF                                                     
A00755       IF WS-FCA00-REV-MONTH (WS-INDEX) < WS-REV-MNTH-PREV        
A00755          AND WS-FCA00-REV-MONTH (WS-INDEX) NOT = ZEROES          
A00755          MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO WS-REV-MNTH-OLDEST 
A00755       END-IF                                                     
A00755     END-IF.                                                      
A00755*                                                                         
A00755     MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO WS-REV-MNTH-PREV.       
A00755     ADD 1                             TO WS-INDEX.               
A00755*                                                                         
A00755 4525-EXIT.                                                       
A00755     EXIT.                                                        
A00755*                                                                         
      ******************************************************************        
      * 5255-REMOVE-FROM-EPP                                           *        
      * COPYBOOK THAT HANDLES EXEMPTING AN ACCOUNT FROM EPP.           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00317                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5260-REMOVE-FROM-DPP                                           *        
      * COPYBOOK THAT HANDLES EXEMPTING AN ACCOUNT FROM DPP.           *        
      ******************************************************************        
      *                                                                         
T23238     EXEC SQL                                                             
T23238        INCLUDE CPD00109                                                  
T23238     END-EXEC.                                                            
      *                                                                         
C29815******************************************************************        
C29815* EVALUATE NEXT REVENUE MONTH                                    *        
C29815******************************************************************        
C29815*                                                                         
C29815 5999-INPUT-REV-MTH-01.                                           
C29815*                                                                         
C32821     MOVE AT-REV-MTH-LST-NRML TO WS-REVENUE-MONTH-EPP.            
C32821     MOVE WS-REVENUE-MONTH-EPP TO WS-REV-MNTH-HOLD.               
C32821     ADD +1 TO WS-REV-MM-HOLD.                                    
C32821     IF WS-REV-MM-HOLD = 13                                       
C32821         MOVE 01 TO WS-REV-MM-HOLD                                
C32821         ADD +1 TO WS-REV-YY-HOLD
           END-IF.                                
C29815     MOVE WS-REV-YY-HOLD TO WS-INPUT-YY-REV.                      
C29815     MOVE WS-REV-MM-HOLD TO WS-INPUT-MM-REV.                      
C29815*                                                                         
C29815 5999-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
C29815******************************************************************        
C29815* GET CIA FROM AR_CNTL                                           *        
C29815******************************************************************        
C29815*                                                                         
C29815 6000-CHECK-FOR-CIA.                                              
C29815*                                                                         
C29815     EXEC SQL                                                     
A00755        SELECT COALESCE (SUM(AMT_UNUSED_CR),0)                    
A00755          INTO :AC-AMT-UNUSED-CR                                  
C29815          FROM CSS_AR_CNTL                                        
C29815         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
C29815           AND PYMT_PRIORITY_LVL = 70                             
A01542           AND ITEM_ID IN (1,2)                                   
A00755                                                      
C29815     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COALESCE (SUM(AMT_UNUSED_CR),0)                            
MFA-TR*         INTO :AC-AMT-UNUSED-CR                                          
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = 70                                     
MFA-TR*          AND ITEM_ID IN (1,2)                                           
MFA-TR*         QUERYNO 6000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29815*                                                                         
C29815     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C29815     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
A00755         IF AC-AMT-UNUSED-CR < 0                                  
A00755            PERFORM 6300-GO-GET-EPP-INFO THRU 6300-EXIT           
A00755         ELSE                                                     
A00755            CONTINUE                                              
A00755         END-IF                                                   
C29815     ELSE                                                         
C29815         DISPLAY '********** PCSCA099 ABORT **************'       
C29815         DISPLAY '* 6000-CHECK-FOR-CIA                   *'       
C29815         DISPLAY '* ACCOUNT NO ', AC-ACCOUNT-NO                   
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C29815         DISPLAY '* PYMT PRIORITY LVL ', AC-PYMT-PRIORITY-LVL     
C29815         DISPLAY '* ITEM ID ', AC-ITEM-ID                         
C29815         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C29815         DISPLAY '* PROGRAM ABORTING...                  *'       
C29815         DISPLAY '********** PCSCA099 ABORT **************'       
C29815         PERFORM 9900-ABEND              THRU 9900-EXIT           
C29815     END-IF.                                                      
C29815*                                                                         
C29815 6000-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
      ******************************************************************        
      * PARAGRAPH 6240-GET-FCA00-COMMON-DATE IS IN CPD00040.           *        
      ******************************************************************        
      *                                                                         
       COPY CPD00040.                                                           
       COPY CPD00037.                                                           
      *                                                                         
A00755******************************************************************        
A00755* PARAGRAPH 6241-GET-FCA00-BILL-CYCLES IS IN CPD00041            *        
A00755******************************************************************        
A00755*                                                                         
A00755     EXEC SQL                                                             
A00755        INCLUDE CPD00041                                                  
A00755     END-EXEC.                                                            
A00755*                                                                         
C29815******************************************************************        
C29815* GET EPP AMOUNT FROM AR_CNTL                                    *        
C29815******************************************************************        
C29815*                                                                         
C29815 6300-GO-GET-EPP-INFO.                                            
C29815*                                                                         
C29815     EXEC SQL                                                     
C29815        SELECT AMT_TRAN_BALANCE                                   
C29815          INTO :AC-AMT-TRAN-BALANCE                               
C29815          FROM CSS_AR_CNTL                                        
C29815         WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
C29815           AND PYMT_PRIORITY_LVL = 50                             
C29815           AND ITEM_ID = 1                                        
A00755                                                      
C29815     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_TRAN_BALANCE                                           
MFA-TR*         INTO :AC-AMT-TRAN-BALANCE                                       
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = 50                                     
MFA-TR*          AND ITEM_ID = 1                                                
MFA-TR*         QUERYNO 6300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29815*                                                                         
C29815     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C29815     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C29815        MOVE AC-AMT-TRAN-BALANCE TO WS-AMT-TRAN-BALANCE-EPP       
C29815        MOVE AC-AMT-UNUSED-CR TO WS-AMT-UNUSED-CR-EPP             
P00471                                 WS-AMT-UNUSED-CR-BPP             
C29815        COMPUTE WS-AMT-TRAN-BALANCE-EPP =                         
C29815          WS-AMT-UNUSED-CR-EPP + WS-AMT-TRAN-BALANCE-EPP          
C29815        PERFORM 8440-JRNL-CIA-EPP            THRU 8440-EXIT       
C29815        PERFORM 6535-DELETE-CSS-AR-CNTL   THRU 6535-EXIT          
C29815        PERFORM 6530-UPDT-CSS-AR-CNTL THRU 6530-EXIT              
A01542        PERFORM 6600-CALC-NEW-TOT-AR-BALANCE THRU 6600-EXIT       
C29815     ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
C29815        CONTINUE                                                  
C29815     ELSE                                                         
C29815         DISPLAY '********** PCSCA099 ABORT **************'       
C29815         DISPLAY '* 6300-GO-GET-EPP-INFO          *'              
C29815         DISPLAY '* ACCOUNT NO ', AC-ACCOUNT-NO                   
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C29815         DISPLAY '* PYMT PRIORITY LVL ', AC-PYMT-PRIORITY-LVL     
C29815         DISPLAY '* ITEM ID ', AC-ITEM-ID                         
C29815         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C29815         DISPLAY '* PROGRAM ABORTING...                  *'       
C29815         DISPLAY '********** PCSCA099 ABORT **************'       
C29815         PERFORM 9900-ABEND              THRU 9900-EXIT           
C29815     END-IF
           END-IF.                                                      
C29815*                                                                         
C29815 6300-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
      ******************************************************************        
      * BATCH JOURNAL ROUTINE. 6400-BATCH-JRNL-ROUTINE.                *        
      ******************************************************************        
      *                                                                         
           COPY CPD0013B.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00007                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * SUPPORTS AR TRANS HIST (6500-ONLINE-LOAD-AR-TRAN-HIST).        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
      *                                                                         
C29815******************************************************************        
C29815* UPDATE EPP TRAN-BALANCE ON AR_CNTL                             *        
C29815******************************************************************        
C29815*                                                                         
C29815 6530-UPDT-CSS-AR-CNTL.                                           
C29815*                                                                         
C29815     EXEC SQL                                                     
C29815        UPDATE CSS_AR_CNTL                                        
C29815           SET AMT_TRAN_BALANCE = :WS-AMT-TRAN-BALANCE-EPP        
C29815         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
C29815           AND ITEM_ID        = 1                                 
C29815           AND PYMT_PRIORITY_LVL = 50                             
C29815     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29815                                                                  
C29815     IF SQLCODE = 0                                               
C29815         CONTINUE                                                 
C29815     ELSE                                                         
C29815         DISPLAY '**  ERROR ON 6530-UPDT-CSS-AR-CNTL    **'       
C29815         DISPLAY '**  COULD NOT UPDATE CSS_AR_CNTL      **'       
C29815         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
C29815         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C29815         PERFORM 9900-ABEND                THRU 9900-EXIT         
C29815     END-IF.                                                      
C29815*                                                                         
C29815 6530-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
C29815******************************************************************        
C29815* DELETE AR_CNTL ROWS                                            *        
C29815******************************************************************        
C29815*                                                                         
C29815 6535-DELETE-CSS-AR-CNTL.                                         
C29815*                                                                         
C29815     PERFORM 6540-DELETE-CSS-AR-CNTL-1 THRU 6540-EXIT.            
C29815     PERFORM 6550-DELETE-CSS-AR-CNTL-2 THRU 6550-EXIT.            
A01542     PERFORM 6560-CHECK-CSS-AR-CNTL-3  THRU 6560-EXIT.            
A01542     IF SQLCODE = NOT-FOUND                                       
C29815        PERFORM 6570-DELETE-CSS-AR-CNTL-0 THRU 6570-EXIT          
A01542     ELSE                                                         
A01542        PERFORM 6580-UPDATE-CSS-AR-CNTL-0 THRU 6580-EXIT          
A01542     END-IF.                                                      
C29815*                                                                         
C29815 6535-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
C29815******************************************************************        
C29815* DELETE AR_CNTL ROWS                                            *        
C29815******************************************************************        
C29815*                                                                         
C29815 6540-DELETE-CSS-AR-CNTL-1.                                       
C29815*                                                                         
C29815     EXEC SQL                                                     
C29815         DELETE FROM CSS_AR_CNTL                                  
C29815         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
C29815           AND ITEM_ID = 1                                        
C29815           AND PYMT_PRIORITY_LVL = 70                             
C29815     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29815                                                                  
C29815     IF SQLCODE = 0 OR SQLCODE = NOT-FOUND                        
C29815         CONTINUE                                                 
C29815     ELSE                                                         
C29815         DISPLAY '**  ERROR ON 6540-DELETE-CSS-AR-CNTL-1  **'     
C29815         DISPLAY '**  COULD NOT DELETE FROM CSS_AR_CNTL      **'  
C29815         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
C29815         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C29815         PERFORM 9900-ABEND                THRU 9900-EXIT         
C29815     END-IF.                                                      
C29815*                                                                         
C29815 6540-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
C29815******************************************************************        
C29815* DELETE AR_CNTL ROWS                                            *        
C29815******************************************************************        
C29815*                                                                         
C29815 6550-DELETE-CSS-AR-CNTL-2.                                       
C29815*                                                                         
C29815     EXEC SQL                                                     
C29815         DELETE FROM CSS_AR_CNTL                                  
C29815         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
C29815           AND ITEM_ID = 2                                        
C29815           AND PYMT_PRIORITY_LVL = 70                             
C29815     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29815                                                                  
C29815     IF SQLCODE = 0 OR SQLCODE = NOT-FOUND                        
C29815         CONTINUE                                                 
C29815     ELSE                                                         
C29815         DISPLAY '**  ERROR ON 6550-DELETE-CSS-AR-CNTL-2  **'     
C29815         DISPLAY '**  COULD NOT DELETE FROM CSS_AR_CNTL      **'  
C29815         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
C29815         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C29815         PERFORM 9900-ABEND                THRU 9900-EXIT         
C29815     END-IF.                                                      
C29815*                                                                         
C29815 6550-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
C29815******************************************************************        
C29815* DELETE AR_CNTL ROWS                                            *        
C29815******************************************************************        
C29815*                                                                         
A01542 6560-CHECK-CSS-AR-CNTL-3.                                        
C29815*                                                                         
A01542     EXEC SQL                                                     
A01542        SELECT ACCOUNT_NO                                         
A01542         INTO :AC-ACCOUNT-NO                                      
A01542         FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                           
A01542        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                  
A01542          AND PYMT_PRIORITY_LVL = 70                              
A01542          AND ITEM_ID           = 3                               
A01542                                                           
A00755                                                      
A01542     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*        INTO :AC-ACCOUNT-NO                                              
MFA-TR*        FROM CSS_AR_CNTL                                                 
MFA-TR*       WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                          
MFA-TR*         AND PYMT_PRIORITY_LVL = 70                                      
MFA-TR*         AND ITEM_ID           = 3                                       
MFA-TR*     WITH UR                                                             
MFA-TR*     QUERYNO 6560                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29815                                                                  
C29815     IF SQLCODE = 0 OR SQLCODE = NOT-FOUND                        
C29815         CONTINUE                                                 
C29815     ELSE                                                         
C29815         DISPLAY '**  ERROR ON 6560-CHECK-CSS-AR-CNTL-3  **'      
C29815         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
C29815         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C29815         PERFORM 9900-ABEND                THRU 9900-EXIT         
C29815     END-IF.                                                      
C29815*                                                                         
C29815 6560-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
C29815******************************************************************        
C29815* DELETE AR_CNTL ROWS                                            *        
C29815******************************************************************        
C29815*                                                                         
C29815 6570-DELETE-CSS-AR-CNTL-0.                                       
C29815*                                                                         
C29815     EXEC SQL                                                     
C29815         DELETE FROM CSS_AR_CNTL                                  
C29815         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
C29815           AND ITEM_ID = 0                                        
C29815           AND PYMT_PRIORITY_LVL = 70                             
C29815     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29815                                                                  
C29815     IF SQLCODE = 0                                               
A01542        MOVE SPACES                    TO WS-CODE-CIA             
A01542        MOVE WS-CODES-DATA-PRESENT     TO AT-CODES-DATA-PRESENT   
C29815     ELSE                                                         
C29815         DISPLAY '**  ERROR ON 6570-DELETE-CSS-AR-CNTL-0     **'  
C29815         DISPLAY '**  COULD NOT DELETE FROM CSS_AR_CNTL      **'  
C29815         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
C29815         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C29815         PERFORM 9900-ABEND                THRU 9900-EXIT         
C29815     END-IF.                                                      
C29815*                                                                         
C29815 6570-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
A01542******************************************************************        
A01542* UPDATE AR_CNTL SUMMARY ROW                                     *        
A01542******************************************************************        
A01542*                                                                         
A01542 6580-UPDATE-CSS-AR-CNTL-0.                                       
A01542*                                                                         
A01542     EXEC SQL                                                     
A01542        UPDATE CSS_AR_CNTL                                        
A01542           SET AMT_UNUSED_CR = 0                                  
A01542         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
A01542           AND ITEM_ID        = 0                                 
A01542           AND PYMT_PRIORITY_LVL = 70                             
A01542     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01542                                                                  
A01542     IF SQLCODE = 0                                               
A01542        MOVE SPACES                    TO WS-CODE-CIA             
A01542        MOVE WS-CODES-DATA-PRESENT     TO AT-CODES-DATA-PRESENT   
A01542     ELSE                                                         
A01542         DISPLAY '**  ERROR ON 6580-UPDATE-CSS-AR-CNTL-0     **'  
A01542         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
A01542         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
A01542         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
A01542         PERFORM 9900-ABEND                THRU 9900-EXIT         
A01542     END-IF.                                                      
A01542*                                                                         
A01542 6580-EXIT.                                                       
A01542     EXIT.                                                        
A01542*                                                                         
C29815******************************************************************        
C29815* CALCULATE NEW TOTAL AR BALALNCE                                *        
C29815******************************************************************        
C29815*                                                                         
C29815 6600-CALC-NEW-TOT-AR-BALANCE.                                    
C29815*                                                                         
C29815        COMPUTE WS-TOTAL-AR-BALANCE =                             
P00471          AT-TOTAL-AR-BALANCE - WS-AMT-UNUSED-CR-BPP.             
C29815        PERFORM 6610-UPD-CSS-ACCOUNT THRU 6610-EXIT.              
C29815 6600-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
C29815******************************************************************        
C29815* UPDATE CSS_ACCOUNT TABLE                                       *        
C29815******************************************************************        
C29815*                                                                         
C29815 6610-UPD-CSS-ACCOUNT.                                            
C29815*                                                                         
C29815     EXEC SQL                                                     
C29815        UPDATE CSS_ACCOUNT                                        
C29815           SET TOTAL_AR_BALANCE = :WS-TOTAL-AR-BALANCE            
A01542              ,CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
C29815         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
C29815     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29815                                                                  
C29815     IF SQLCODE = 0                                               
C29815         CONTINUE                                                 
C29815     ELSE                                                         
C29815         DISPLAY '**  ERROR ON 6610-UPD-CSS-ACCOUNT     **'       
C29815         DISPLAY '**  COULD NOT UPDATE CSS_ACCOUNT      **'       
C29815         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
C29815         DISPLAY '**  ACCOUNT-NO     = ' AT-ACCOUNT-NO            
T33215         DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
C29815         PERFORM 9900-ABEND                THRU 9900-EXIT         
C29815     END-IF.                                                      
C29815*                                                                         
C29815 6610-EXIT.                                                       
C29815     EXIT.                                                        
C29815*                                                                         
      ******************************************************************        
      * READS THE DAILY BILLING FILE                                   *        
      ******************************************************************        
      *                                                                         
       7000-READ-FCSDB07.                                               
      *                                                                         
           READ FCSDB07-FILE                                            
               AT END                                                   
                   MOVE WS-Y                   TO WS-END-OF-FILE        
                   GO TO 7000-EXIT                                      
           END-READ.                                                    
      *                                                                         
           IF  FDB07-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '7000-ERROR ON FCSDB07 READ.  STATUS IS '        
                        WS-FDB07-STATUS                                 
               DISPLAY 'ERROR IN ACCOUNT NO' E-FDB07-ACCT-NO            
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
A00755*                                                                         
A00755******************************************************************        
A00755* 7020-SELECT-BUDGET-HIST                                        *        
A00755******************************************************************        
A00755*                                                                         
A00755 7020-SELECT-BUDGET-HIST.                                         
A00755*                                                                         
A00755     EXEC SQL                                                     
A00755        SELECT                                                    
A00755               ACCOUNT_NO                                         
A00755              ,PYMT_PRIORITY_LVL                                  
A00755              ,ITEM_ID                                            
A00755              ,REPLACE(REPLACE(CONVERT(CHAR(26), BUD_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') BUD_HIST_SEQ_NO                        
A00755              ,AMT_MO_PYMT                                        
A00755              ,DATE_PYMT_STRT                                     
A00755              ,UTILITY_BALANCE                                    
A00755              ,BALANCE_FORWARD                                    
A00755              ,EPP_ESTIMATE                                       
A00755              ,METHOD_OF_ESTIMATE                                 
A00755              ,CHANGE_REASON                                      
A00755              ,EPP_MTHS_RMNG_QT                                   
A00755              ,REMARKS                                            
A00755         INTO                                                     
A00755               :BH-ACCOUNT-NO                                     
A00755              ,:BH-PYMT-PRIORITY-LVL                              
A00755              ,:BH-ITEM-ID                                        
A00755              ,:BH-BUD-HIST-SEQ-NO                                
A00755              ,:BH-AMT-MO-PYMT                                    
A00755              ,:BH-DATE-PYMT-STRT                                 
A00755              ,:BH-UTILITY-BALANCE                                
A00755              ,:BH-BALANCE-FORWARD                                
A00755              ,:BH-EPP-ESTIMATE                                   
A00755              ,:BH-METHOD-OF-ESTIMATE                             
A00755              ,:BH-CHANGE-REASON                                  
A00755              ,:BH-EPP-MTHS-RMNG-QT                               
A00755              ,:BH-REMARKS                                        
A00755          FROM                                                    
A00755               CSS_BUDGET_HIST WITH(READUNCOMMITTED)                      
A00755         WHERE                                                    
A00755               ACCOUNT_NO     = :BH-ACCOUNT-NO                    
A00755           AND CHANGE_REASON  = 'S'                               
A00755           AND LAST_UPDATE_TS =                                   
A00755                (SELECT MAX(LAST_UPDATE_TS)                       
A00755                   FROM CSS_BUDGET_HIST WITH(READUNCOMMITTED)             
A00755                  WHERE ACCOUNT_NO    = :BH-ACCOUNT-NO            
A00755                    AND CHANGE_REASON = 'S')                      
A00755                                                           
A00755                                                      
A00755     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              ACCOUNT_NO                                                 
MFA-TR*             ,PYMT_PRIORITY_LVL                                          
MFA-TR*             ,ITEM_ID                                                    
MFA-TR*             ,BUD_HIST_SEQ_NO                                            
MFA-TR*             ,AMT_MO_PYMT                                                
MFA-TR*             ,DATE_PYMT_STRT                                             
MFA-TR*             ,UTILITY_BALANCE                                            
MFA-TR*             ,BALANCE_FORWARD                                            
MFA-TR*             ,EPP_ESTIMATE                                               
MFA-TR*             ,METHOD_OF_ESTIMATE                                         
MFA-TR*             ,CHANGE_REASON                                              
MFA-TR*             ,EPP_MTHS_RMNG_QT                                           
MFA-TR*             ,REMARKS                                                    
MFA-TR*        INTO                                                             
MFA-TR*              :BH-ACCOUNT-NO                                             
MFA-TR*             ,:BH-PYMT-PRIORITY-LVL                                      
MFA-TR*             ,:BH-ITEM-ID                                                
MFA-TR*             ,:BH-BUD-HIST-SEQ-NO                                        
MFA-TR*             ,:BH-AMT-MO-PYMT                                            
MFA-TR*             ,:BH-DATE-PYMT-STRT                                         
MFA-TR*             ,:BH-UTILITY-BALANCE                                        
MFA-TR*             ,:BH-BALANCE-FORWARD                                        
MFA-TR*             ,:BH-EPP-ESTIMATE                                           
MFA-TR*             ,:BH-METHOD-OF-ESTIMATE                                     
MFA-TR*             ,:BH-CHANGE-REASON                                          
MFA-TR*             ,:BH-EPP-MTHS-RMNG-QT                                       
MFA-TR*             ,:BH-REMARKS                                                
MFA-TR*         FROM                                                            
MFA-TR*              CSS_BUDGET_HIST                                            
MFA-TR*        WHERE                                                            
MFA-TR*              ACCOUNT_NO     = :BH-ACCOUNT-NO                            
MFA-TR*          AND CHANGE_REASON  = 'S'                                       
MFA-TR*          AND LAST_UPDATE_TS =                                           
MFA-TR*               (SELECT MAX(LAST_UPDATE_TS)                               
MFA-TR*                  FROM CSS_BUDGET_HIST                                   
MFA-TR*                 WHERE ACCOUNT_NO    = :BH-ACCOUNT-NO                    
MFA-TR*                   AND CHANGE_REASON = 'S')                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00755*                                                                         
A00755     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
A00755*                                                                         
A00755     EVALUATE WS-ACTIVE-RETURN-CODE                               
A00755         WHEN SUCCESSFUL-CALL                                     
A00755              CONTINUE                                            
A00755         WHEN NOT-FOUND                                           
A00755              CONTINUE                                            
A00755         WHEN OTHER                                               
A00755              DISPLAY '********** PCSCA099 ABORT **************'  
A00755              DISPLAY '* 7020-SELECT-BUDGET_HIST              *'  
A00755              DISPLAY '* ACCOUNT NO    : ' WS-ACCOUNT-NO          
A00755              DISPLAY '* PYMT PRT LVL  : ' BH-PYMT-PRIORITY-LVL   
A00755              DISPLAY '* ITEM ID       : ' BH-ITEM-ID             
A00755              DISPLAY '* SQLCODE IS    : ' WS-ACTIVE-RETURN-CODE  
A00755              DISPLAY '* PROGRAM ABORTING...                  *'  
A00755              DISPLAY '********** PCSCA099 ABORT **************'  
A00755              PERFORM 9900-ABEND              THRU 9900-EXIT      
A00755     END-EVALUATE.                                                
A00755*                                                                         
A00755 7020-EXIT.                                                       
A00755     EXIT.                                                        
A00755*                                                                         
ACT004                                                                  
ACT004******************************************************************        
ACT004* 7021-CHECK-BBP-SETUP-DATE                                     *         
ACT004******************************************************************        
ACT004*                                                                         
ACT004 7021-CHECK-BBP-SETUP-DATE.                                       
ACT004*                                                                         
ACT004     EXEC SQL                                                     
ACT004        SELECT 'Y'                                                
ACT004                                                                  
ACT004          INTO :WS-FIRST-MTH-AFTER-SETUP                          
ACT004                                                                  
ACT004          FROM CSS_BUDGET_HIST  BH WITH(READUNCOMMITTED)                  
ACT004             , CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                  
ACT004                                                                  
ACT004         WHERE BH.ACCOUNT_NO     = :BH-ACCOUNT-NO                 
ACT004           AND BH.ACCOUNT_NO     = AT.ACCOUNT_NO                  
ACT004           AND BH.CHANGE_REASON  = 'S'                            
ACT004           AND CAST(BUD_HIST_SEQ_NO AS DATE) > AT.DATE_BILL_DAY_00        
ACT004           AND BUD_HIST_SEQ_NO   =                                
ACT004                (SELECT MAX(BH1.BUD_HIST_SEQ_NO)                  
ACT004                   FROM CSS_BUDGET_HIST BH1 WITH(READUNCOMMITTED)         
ACT004                  WHERE BH1.ACCOUNT_NO = :BH-ACCOUNT-NO           
ACT004                    AND CHANGE_REASON  = 'S')                     
ACT004                                                           
ACT004                                                      
ACT004     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*                                                                         
MFA-TR*         INTO :WS-FIRST-MTH-AFTER-SETUP                                  
MFA-TR*                                                                         
MFA-TR*         FROM CSS_BUDGET_HIST  BH                                        
MFA-TR*            , CSS_ACCOUNT      AT                                        
MFA-TR*                                                                         
MFA-TR*        WHERE BH.ACCOUNT_NO     = :BH-ACCOUNT-NO                         
MFA-TR*          AND BH.ACCOUNT_NO     = AT.ACCOUNT_NO                          
MFA-TR*          AND BH.CHANGE_REASON  = 'S'                                    
MFA-TR*          AND DATE(BUD_HIST_SEQ_NO) > AT.DATE_BILL_DAY_00                
MFA-TR*          AND BUD_HIST_SEQ_NO   =                                        
MFA-TR*               (SELECT MAX(BH1.BUD_HIST_SEQ_NO)                          
MFA-TR*                  FROM CSS_BUDGET_HIST BH1                               
MFA-TR*                 WHERE BH1.ACCOUNT_NO = :BH-ACCOUNT-NO                   
MFA-TR*                   AND CHANGE_REASON  = 'S')                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7021                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004*                                                                         
ACT004     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
ACT004*                                                                         
ACT004     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT004         WHEN SUCCESSFUL-CALL                                     
ACT004              CONTINUE                                            
ACT004         WHEN NOT-FOUND                                           
ACT004              CONTINUE                                            
ACT004         WHEN OTHER                                               
ACT004              DISPLAY '********** PCSCA099 ABORT **************'  
ACT004              DISPLAY '* 7021-CHECK-BBP-SETUP-DATE            *'  
ACT004              DISPLAY '* ACCOUNT NO    : ' WS-ACCOUNT-NO          
ACT004              DISPLAY '* SQLCODE IS    : ' WS-ACTIVE-RETURN-CODE  
ACT004              DISPLAY '* PROGRAM ABORTING...                  *'  
ACT004              DISPLAY '********** PCSCA099 ABORT **************'  
ACT004              PERFORM 9900-ABEND              THRU 9900-EXIT      
ACT004     END-EVALUATE.                                                
ACT004*                                                                         
ACT004 7021-EXIT.                                                       
ACT004     EXIT.                                                        
      *                                                                         
P00453******************************************************************        
P00453* 7022-CHECK-1ST-MNTH-AFTR-ANNIV                                 *        
P00453******************************************************************        
P00453*                                                                         
P00453 7022-CHECK-1ST-MNTH-AFTR-ANNIV.                                  
P00453*                                                                         
P00453     EXEC SQL                                                     
P00453        SELECT TOP(1) 'Y'                                                
P00453          INTO :WS-FIRST-MONTH-AFTER-ANNIV                        
P00453          FROM CSS_BUDGET_PLAN  BU WITH(READUNCOMMITTED)                  
P00453              ,CSS_BUDGET_HIST  BH WITH(READUNCOMMITTED)                  
P00453         WHERE BU.ACCOUNT_NO     = :BU-ACCOUNT-NO                 
P00453           AND BH.ACCOUNT_NO     = :BU-ACCOUNT-NO                 
P00453           AND BU.DATE_PYMT_STRT = BH.DATE_PYMT_STRT              
P00453           AND BH.CHANGE_REASON  = 'A'                            
P00453                                            
P00453                                                           
P00453                                                      
P00453     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-FIRST-MONTH-AFTER-ANNIV                                
MFA-TR*         FROM CSS_BUDGET_PLAN  BU                                        
MFA-TR*             ,CSS_BUDGET_HIST  BH                                        
MFA-TR*        WHERE BU.ACCOUNT_NO     = :BU-ACCOUNT-NO                         
MFA-TR*          AND BH.ACCOUNT_NO     = :BU-ACCOUNT-NO                         
MFA-TR*          AND BU.DATE_PYMT_STRT = BH.DATE_PYMT_STRT                      
MFA-TR*          AND BH.CHANGE_REASON  = 'A'                                    
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7022                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00453*                                                                         
P00453     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
P00453*                                                                         
P00453     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00453        CONTINUE                                                  
P00453     ELSE                                                         
P00453        DISPLAY '********** PCSCA099 ABORT **************'        
P00453        DISPLAY '* 7022-CHECK-1ST-MNTH-AFTR-ANNIV       *'        
P00453        DISPLAY '* ACCOUNT NO  : ' BU-ACCOUNT-NO                  
P00453        DISPLAY '* SQLCODE IS  : ' WS-ACTIVE-RETURN-CODE          
P00453        DISPLAY '* PROGRAM ABORTING...                  *'        
P00453        DISPLAY '********** PCSCA099 ABORT **************'        
P00453        PERFORM 9900-ABEND           THRU 9900-EXIT               
P00453     END-IF.                                                      
P00453*                                                                         
P00453 7022-EXIT.                                                       
P00453     EXIT.                                                        
      *                                                                         
A00755******************************************************************        
A00755* 7030-GET-NEW-ANNIV-DT.                                         *        
A00755******************************************************************        
A00755*                                                                         
A00755 7030-GET-NEW-ANNIV-DT.                                           
A00755*                                                                         
A00755     EXEC SQL                                                     
A00755        SELECT
              DATEADD( MONTH, 11, IIF(TRY_CONVERT(DATE, 
                                                     :BU-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BU-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BU-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BU-DATE-PYMT-STRT
              ), CONVERT(DATE, :BU-DATE-PYMT-STRT) ) )
            INTO
              :WS-ANNIV-DT-NEW                 
A00755     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-ANNIV-DT-NEW =                                            
MFA-TR*            DATE(:BU-DATE-PYMT-STRT) + 11 MONTHS                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00755*                                                                         
A00755     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
A00755     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A00755         CONTINUE                                                 
A00755     ELSE                                                         
A00755         DISPLAY '********** PCSCA099 ABORT **************'       
A00755         DISPLAY '* 7030-GET-NEW-ANNIV-DT                  *'     
A00755         DISPLAY '* DATE PYMT STRT ', BU-DATE-PYMT-STRT           
A00755         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
A00755         DISPLAY '* PROGRAM ABORTING...                  *'       
A00755         DISPLAY '********** PCSCA099 ABORT **************'       
A00755         PERFORM 9900-ABEND              THRU 9900-EXIT           
A00755     END-IF.                                                      
A00755*                                                                         
A00755 7030-EXIT.                                                       
A00755     EXIT.                                                        
A00755*                                                                         
      ******************************************************************        
      * SELECTS DELINQUENCY VALUE FOR DELINQ CODE 'AMT-EPPDELINQ'      *        
      ******************************************************************        
      *                                                                         
       7100-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
T33182                                                           
A00755                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7100-SELECT-DELINQ-VALUE             *'       
               DISPLAY '* DELINQ CD ', C8-DELINQ-CD                     
               DISPLAY '* COMPANY NO', C8-COMPANY-NO                    
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * CALCULATES 55 DAYS AGO AND 85 DAYS AGO FROM COMMON DATE        *        
      ******************************************************************        
      *                                                                         
       7125-GET-RELATIVE-DATES.                                         
      *                                                                         
T33182     EXEC SQL                                                     
T33182        SELECT
              DATEADD( DAY, -55, IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-REL-DATE                      
T33182     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-REL-DATE =                                                
MFA-TR*            DATE(:WS-COMMON-DATE) - 55 DAYS                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE WS-REL-DATE                TO WS-DT-55-DAYS-AGO     
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7125-GET-RELATIVE-DATES              *'       
               DISPLAY '* COMMON DATE ', WS-COMMON-DATE                 
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
T33182     EXEC SQL                                                     
T33182        SELECT
              DATEADD( DAY, -85, IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-REL-DATE                      
T33182     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-REL-DATE =                                                
MFA-TR*            DATE(:WS-COMMON-DATE) - 85 DAYS                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE WS-REL-DATE                TO WS-DT-85-DAYS-AGO     
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7125-GET-RELATIVE-DATES              *'       
               DISPLAY '* COMMON DATE ', WS-COMMON-DATE                 
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT ACCOUNT DETAILS                                         *        
      ******************************************************************        
      *                                                                         
       7150-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
A00755        SELECT                                                    
                     CUSTOMER_NO                                        
A00755              ,COALESCE (CAST(DATE_BILL_DAY_00 AS CHAR(10)),' ')          
A00755              ,COALESCE (CAST(DATE_BILL_DAY_30 AS CHAR(10)),' ')          
A00755              ,COALESCE (CAST(DATE_BILL_DAY_60 AS CHAR(10)),' ')          
A00755              ,COALESCE (CAST(DATE_BILL_DAY_90 AS CHAR(10)),' ')          
                    ,TOTAL_AR_BALANCE                                   
                    ,CODE_ACCT_STAT                                     
                    ,NOTICE_EXEMPT_CD                                   
                    ,LOCAL_OFFICE                                       
                    ,PREMISE_NO                                         
                    ,CODE_DISC_OK                                       
                    ,CODES_DATA_PRESENT                                 
                    ,COMPANY_NO                                         
                    ,CREDIT_GROUP                                       
                    ,BANKRUPTCY_IND                                     
                    ,LAST_NRML_BILL_NO                                  
A00755              ,COALESCE (REV_MTH_LST_NRML,0)                      
                    ,ELEC_REV_ALLOC_PCT                                 
C28788              ,IVR_EXEMPT_CD                                      
C33442              ,EXT_BILLING_FL                                     
C33462              ,CODE_ACCT_BILLED                                   
C36197              ,CODE_STATUS_REASON                                 
A00755              ,BILL_CYCLE                                         
ACT003              ,CODE_LPC_XMT                                       
                INTO                                                    
                     :AT-CUSTOMER-NO                                    
A00755              ,:AT-DATE-BILL-DAY-00                               
A00755              ,:AT-DATE-BILL-DAY-30                               
A00755              ,:AT-DATE-BILL-DAY-60                               
A00755              ,:AT-DATE-BILL-DAY-90                               
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-COMPANY-NO                                     
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-LAST-NRML-BILL-NO                              
A00755              ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-ELEC-REV-ALLOC-PCT                             
C28788              ,:AT-IVR-EXEMPT-CD                                  
C33442              ,:AT-EXT-BILLING-FL                                 
C33462              ,:AT-CODE-ACCT-BILLED                               
C36197              ,:AT-CODE-STATUS-REASON                             
A00755              ,:AT-BILL-CYCLE                                     
ACT003              ,:AT-CODE-LPC-XMT                                   
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
T33182                                                           
A00755                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*             ,COALESCE (CHAR(DATE_BILL_DAY_00),' ')                      
MFA-TR*             ,COALESCE (CHAR(DATE_BILL_DAY_30),' ')                      
MFA-TR*             ,COALESCE (CHAR(DATE_BILL_DAY_60),' ')                      
MFA-TR*             ,COALESCE (CHAR(DATE_BILL_DAY_90),' ')                      
MFA-TR*             ,TOTAL_AR_BALANCE                                           
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,NOTICE_EXEMPT_CD                                           
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,CODE_DISC_OK                                               
MFA-TR*             ,CODES_DATA_PRESENT                                         
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,CREDIT_GROUP                                               
MFA-TR*             ,BANKRUPTCY_IND                                             
MFA-TR*             ,LAST_NRML_BILL_NO                                          
MFA-TR*             ,COALESCE (REV_MTH_LST_NRML,0)                              
MFA-TR*             ,ELEC_REV_ALLOC_PCT                                         
MFA-TR*             ,IVR_EXEMPT_CD                                              
MFA-TR*             ,EXT_BILLING_FL                                             
MFA-TR*             ,CODE_ACCT_BILLED                                           
MFA-TR*             ,CODE_STATUS_REASON                                         
MFA-TR*             ,BILL_CYCLE                                                 
MFA-TR*             ,CODE_LPC_XMT                                               
MFA-TR*         INTO                                                            
MFA-TR*              :AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-DATE-BILL-DAY-00                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-30                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-60                                       
MFA-TR*             ,:AT-DATE-BILL-DAY-90                                       
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-LAST-NRML-BILL-NO                                      
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-ELEC-REV-ALLOC-PCT                                     
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-EXT-BILLING-FL                                         
MFA-TR*             ,:AT-CODE-ACCT-BILLED                                       
MFA-TR*             ,:AT-CODE-STATUS-REASON                                     
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*             ,:AT-CODE-LPC-XMT                                           
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A00755         CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'TEST - RECORD BYPASSED'                         
               GO TO 7150-EXIT                                          
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT DETAILS FROM CSS_AR_CNTL TO DECIDE WHETHER ACCT IS ON EPP        
      ******************************************************************        
      *                                                                         
       7200-SELECT-AR-DETAILS.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT AMT_AR_DAY_00                                      
                    ,AMT_AR_DAY_30                                      
                    ,AMT_AR_DAY_60                                      
                    ,AMT_AR_DAY_90                                      
                    ,AMT_TRAN_BALANCE                                   
                INTO :AC-AMT-AR-DAY-00                                  
                    ,:AC-AMT-AR-DAY-30                                  
                    ,:AC-AMT-AR-DAY-60                                  
                    ,:AC-AMT-AR-DAY-90                                  
                    ,:AC-AMT-TRAN-BALANCE                               
                FROM CSS_AR_CNTL                                        
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
A00755                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_AR_DAY_00                                              
MFA-TR*             ,AMT_AR_DAY_30                                              
MFA-TR*             ,AMT_AR_DAY_60                                              
MFA-TR*             ,AMT_AR_DAY_90                                              
MFA-TR*             ,AMT_TRAN_BALANCE                                           
MFA-TR*         INTO :AC-AMT-AR-DAY-00                                          
MFA-TR*             ,:AC-AMT-AR-DAY-30                                          
MFA-TR*             ,:AC-AMT-AR-DAY-60                                          
MFA-TR*             ,:AC-AMT-AR-DAY-90                                          
MFA-TR*             ,:AC-AMT-TRAN-BALANCE                                       
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7200-SELECT-AR-DETAILS               *'       
               DISPLAY '* ACCOUNT NO ', AC-ACCOUNT-NO                   
               DISPLAY '* PYMT PRIORITY LVL ', AC-PYMT-PRIORITY-LVL     
               DISPLAY '* ITEM ID ', AC-ITEM-ID                         
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT ARREARS HIST FROM CSS_CREDIT_PROFILE                    *        
      ******************************************************************        
      *                                                                         
       7250-SELECT-ARR-HIST.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT ARREARS_HIST                                       
                INTO :CZ-ARREARS-HIST                                   
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        
T33182                                                           
A00755                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ARREARS_HIST                                               
MFA-TR*         INTO :CZ-ARREARS-HIST                                           
MFA-TR*         FROM CSS_CREDIT_PROFILE                                         
MFA-TR*        WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7250-SELECT-ARR-HIST                 *'       
               DISPLAY '* ACCOUNT NO ', CZ-ACCOUNT-NO                   
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT AMOUNT MONTHLY PAYMENT FROM BUDGET PLAN                 *        
      ******************************************************************        
      *                                                                         
       7300-SELECT-BUD-PLAN.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT DATE_PYMT_STRT                                     
A00755              ,ANNIVERSARY_DATE                                   
                INTO :BU-DATE-PYMT-STRT                                 
A00755              ,:BU-ANNIVERSARY-DATE                               
                FROM CSS_BUDGET_PLAN WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL          
                 AND BP_ITEM_ID        = :BU-BP-ITEM-ID                 
T33182                                                           
A00755                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_PYMT_STRT                                             
MFA-TR*             ,ANNIVERSARY_DATE                                           
MFA-TR*         INTO :BU-DATE-PYMT-STRT                                         
MFA-TR*             ,:BU-ANNIVERSARY-DATE                                       
MFA-TR*         FROM CSS_BUDGET_PLAN                                            
MFA-TR*        WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL                  
MFA-TR*          AND BP_ITEM_ID        = :BU-BP-ITEM-ID                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7300-SELECT-BUD-PLAN                 *'       
               DISPLAY '* ACCOUNT NO ', BU-ACCOUNT-NO                   
               DISPLAY '* PYMT PRIORITY LVL ', BU-PYMT-PRIORITY-LVL     
               DISPLAY '* ITEM ID ', BU-BP-ITEM-ID                      
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * OPEN DET-AR-CNTL                                               *        
      ******************************************************************        
      *                                                                         
       7410-OPEN-DET-AR-CNTL.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN DET-AR-CNTL                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7410-OPEN-DET-AR-CNTL                *'       
               DISPLAY '* ACCOUNT NO ', WS-AC-ACCOUNT-NO                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7420-FETCH-DET-AR-CNTL.                                        *        
      ******************************************************************        
      *                                                                         
       7420-FETCH-DET-AR-CNTL.                                          
      *                                                                         
           EXEC SQL                                                     
               FETCH  DET-AR-CNTL                                       
                INTO  :WS-AC-AMT-AR-DAY-00                              
                     ,:WS-AC-AMT-AR-DAY-30                              
                     ,:WS-AC-AMT-AR-DAY-60                              
                     ,:WS-AC-AMT-AR-DAY-90                              
                     ,:WS-AC-AMT-TRAN-BALANCE                           
                     ,:WS-AC-ITEM-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7420-FETCH-DET-AR-CNTL               *'       
               DISPLAY '* ACCOUNT NO ', WS-AC-ACCOUNT-NO                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7030-CLOSE-DET-AR-CNTL.                                       *         
      *****************************************************************         
      *                                                                         
       7430-CLOSE-DET-AR-CNTL.                                          
      *                                                                         
                                                                        
           EXEC SQL                                                     
               CLOSE DET-AR-CNTL                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7430-CLOSE-DET-AR-CNTL               *'       
               DISPLAY '* ACCOUNT NO ', WS-AC-ACCOUNT-NO                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
P00471*                                                                         
P00471******************************************************************        
P00471* 7440-SELECT-REG-PROFILE.                                       *        
P00471******************************************************************        
P00471*                                                                         
P00471 7440-SELECT-REG-PROFILE.                                         
P00471*                                                                         
P00471     EXEC SQL                                                     
P00471         SELECT REG_GROUP_CD                                      
P00471           INTO :LR-REG-GROUP-CD                                  
P00471           FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
P00471          WHERE ACCOUNT_NO   = :LR-ACCOUNT-NO                     
P00471                                                           
P00471                                                      
P00471     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO   = :LR-ACCOUNT-NO                             
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7440                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471*                                                                         
P00471     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00471     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00471         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
P00471            MOVE SPACES       TO LR-REG-GROUP-CD                  
P00471         END-IF                                                   
P00471     ELSE                                                         
P00471         DISPLAY '********** PCSCA099 ABORT **************'       
P00471         DISPLAY '* 7440-SELECT-REG-PROFILE              *'       
P00471         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
P00471         DISPLAY '* ACCOUNT NO ', LR-ACCOUNT-NO                   
P00471         DISPLAY '* PROGRAM ABORTING...                  *'       
P00471         DISPLAY '********** PCSCA099 ABORT **************'       
P00471         PERFORM 9900-ABEND              THRU 9900-EXIT           
P00471     END-IF.                                                      
P00471*                                                                         
P00471 7440-EXIT.                                                       
P00471     EXIT.                                                        
P00471*                                                                         
P00471******************************************************************        
P00471* 7450-SELECT-BLLD-MTH.                                          *        
P00471******************************************************************        
P00471*                                                                         
P00471 7450-SELECT-BLLD-MTH.                                            
P00471*                                                                         
P00471     EXEC SQL                                                     
P00471         SELECT RCNTLY_BLLD_MTH                                   
P00471           INTO :DA-RCNTLY-BLLD-MTH                               
P00471           FROM CSS_DFA_ACCT WITH(READUNCOMMITTED)                        
P00471          WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO                
P00471            AND PYMT_PRIORITY_LVL = 90                            
P00471            AND CODE_DFA_STATUS   = 'A'                           
P00471            AND CODE_DFA_TYPE     = 'B'                           
P00471                                                           
P00471                                                      
P00471     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RCNTLY_BLLD_MTH                                           
MFA-TR*          INTO :DA-RCNTLY-BLLD-MTH                                       
MFA-TR*          FROM CSS_DFA_ACCT                                              
MFA-TR*         WHERE ACCOUNT_NO        = :DA-ACCOUNT-NO                        
MFA-TR*           AND PYMT_PRIORITY_LVL = 90                                    
MFA-TR*           AND CODE_DFA_STATUS   = 'A'                                   
MFA-TR*           AND CODE_DFA_TYPE     = 'B'                                   
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7450                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471*                                                                         
P00471     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00471     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00471         CONTINUE                                                 
P00471     ELSE                                                         
P00471         DISPLAY '********** PCSCA099 ABORT **************'       
P00471         DISPLAY '* 7450-SELECT-BLLD-MTH                 *'       
P00471         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
P00471         DISPLAY '* ACCOUNT NO ', DA-ACCOUNT-NO                   
P00471         DISPLAY '* PROGRAM ABORTING...                  *'       
P00471         DISPLAY '********** PCSCA099 ABORT **************'       
P00471         PERFORM 9900-ABEND              THRU 9900-EXIT           
P00471     END-IF.                                                      
P00471*                                                                         
P00471 7450-EXIT.                                                       
P00471     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * SELECT CODE-DFA-DESC FROM CSS_DFA_ACCT                         *        
      ******************************************************************        
      *                                                                         
       7500-SELECT-CODE-DFA-DESC.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT  CODE_DFA_DESC                                     
                     ,CODE_DFA_TYPE                                     
                INTO  :DA-CODE-DFA-DESC                                 
                     ,:DA-CODE-DFA-TYPE                                 
                FROM  CSS_DFA_ACCT WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO                
                 AND  PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL         
                 AND  DFA_ITEM_ID       = :DA-DFA-ITEM-ID               
T33182                                                           
A00755                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CODE_DFA_DESC                                             
MFA-TR*              ,CODE_DFA_TYPE                                             
MFA-TR*         INTO  :DA-CODE-DFA-DESC                                         
MFA-TR*              ,:DA-CODE-DFA-TYPE                                         
MFA-TR*         FROM  CSS_DFA_ACCT                                              
MFA-TR*        WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO                        
MFA-TR*          AND  PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL                 
MFA-TR*          AND  DFA_ITEM_ID       = :DA-DFA-ITEM-ID                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7500-SELECT-CODE-DFA-DESC            *'       
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T26531******************************************************************        
T26531* CHECK IF THERE'S A CANCEL/REBILL FUTURE                        *        
T26531******************************************************************        
T26531*                                                                         
T26531 7550-SELECT-CANCEL-REBILL.                                       
T26531*                                                                         
T26531     EXEC SQL                                                     
T26531        SELECT  'Y'                                               
T26531          INTO  :WS-CAN-REBILL-FLAG                               
T26531          FROM  CSS_BILLING_DET                                   
T26531         WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                
T26531           AND  DATE_ORIG_BILL    IS NOT NULL                     
T26531           AND  REV_MTH_ORIG_BILL > 0                             
T26531           AND  BILL_NO = (SELECT MAX(BILL_NO)                    
T26531                             FROM CSS_BILLING_HDR                 
T26531                            WHERE ACCOUNT_NO = :BG-ACCOUNT-NO     
T26531                              AND DATE_BILLED IS NULL)            
A00755                                                      
T26531     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO  :WS-CAN-REBILL-FLAG                                       
MFA-TR*         FROM  CSS_BILLING_DET                                           
MFA-TR*        WHERE  ACCOUNT_NO        = :BG-ACCOUNT-NO                        
MFA-TR*          AND  DATE_ORIG_BILL    IS NOT NULL                             
MFA-TR*          AND  REV_MTH_ORIG_BILL > 0                                     
MFA-TR*          AND  BILL_NO = (SELECT MAX(BILL_NO)                            
MFA-TR*                            FROM CSS_BILLING_HDR                         
MFA-TR*                           WHERE ACCOUNT_NO = :BG-ACCOUNT-NO             
MFA-TR*                             AND DATE_BILLED IS NULL)                    
MFA-TR*         QUERYNO 7550                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T26531*                                                                         
T26531     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T26531     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811          
T26531         MOVE 'Y'                     TO WS-CAN-REBILL-FLAG       
T26531     ELSE                                                         
T26531         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
T26531            MOVE 'N'                  TO WS-CAN-REBILL-FLAG       
T26531         ELSE                                                     
T26531            DISPLAY '********** PCSCA099 ABORT ***********'       
T26531            DISPLAY '***** 7550-SELECT-CANCEL-REBILL *****'       
T26531            DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
T26531            DISPLAY '* PROGRAM ABORTING...               *'       
T26531            DISPLAY '********** PCSCA099 ABORT ***********'       
T26531            PERFORM 9900-ABEND        THRU 9900-EXIT              
T26531         END-IF                                                   
T26531     END-IF.                                                      
T26531*                                                                         
T26531 7550-EXIT.                                                       
T26531     EXIT.                                                        
                                                                        
      *                                                                         
P00471*****************************************************************         
P00471* 7560-CHECK-DPP-DROP-EXEMPT.                                   *         
P00471*****************************************************************         
P00471*                                                                         
P00471 7560-CHECK-DPP-DROP-EXEMPT.                                      
P00471*                                                                         
P00471     EXEC SQL                                                     
P00471        SELECT ATTRIBUTE_VALUE_CD                                 
P00471          INTO :WS-ATTRIBUTE-VALUE-CD                             
P00471          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
P00471         WHERE YP.ACCOUNT_NO          = :YP-ACCOUNT-NO            
P00471           AND YP.ATTRIBUTE_DESC      ='AUTODPPDRPEXEMPIND'       
P00471                                                           
P00471                                                      
P00471     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ATTRIBUTE_VALUE_CD                                         
MFA-TR*         INTO :WS-ATTRIBUTE-VALUE-CD                                     
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO          = :YP-ACCOUNT-NO                    
MFA-TR*          AND YP.ATTRIBUTE_DESC      ='AUTODPPDRPEXEMPIND'               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7560                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471*                                                                         
P00471     MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
P00471                                         WS-ACTIVE-RETURN-CODE.   
P00471     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00471        CONTINUE                                                  
P00471     ELSE                                                         
P00471        DISPLAY '********** PCSCA099 ABORT *****************'     
P00471        DISPLAY '** ERROR ON 7560-CHECK-DPP-DROP-EXEMPT   **'     
P00471        DISPLAY '** ACCOUNT NO  = ' YP-ACCOUNT-NO                 
P00471        DISPLAY '** SQLCODE     = ' WS-DISPLAY-SQLCODE            
P00471        DISPLAY '** PROGRAM ABORTING...                   **'     
P00471        DISPLAY '********** PCSCA099 ABORT *****************'     
P00471        PERFORM 9900-ABEND                THRU 9900-EXIT          
P00471     END-IF.                                                      
P00471*                                                                         
P00471 7560-EXIT.                                                       
P00471     EXIT.                                                        
P00471*                                                                         
      ******************************************************************        
      * PARAGRAPH 7600-START-FCSJC01 IS IN CPD00038.                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7800-GET-EPP-ANNIV-DATE                                        *        
      ******************************************************************        
      *                                                                         
C27405 7800-GET-EPP-ANNIV-DATE.                                         
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405        SELECT  ANNIVERSARY_DATE                                  
C29815               ,DATEADD( MONTH, 1, DATEADD( YEAR, -1, 
           ANNIVERSARY_DATE ) )               
C27405          INTO  :BU-ANNIVERSARY-DATE                              
C29815               ,:WS-1ST-MNTH-ANNIV-DT                             
C27405          FROM  CSS_BUDGET_PLAN WITH(READUNCOMMITTED)                     
C27405         WHERE  ACCOUNT_NO      = :BU-ACCOUNT-NO                  
T33182                                                           
A00755                                                      
C27405     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  ANNIVERSARY_DATE                                          
MFA-TR*              ,ANNIVERSARY_DATE - 1 YEAR + 1 MONTH                       
MFA-TR*         INTO  :BU-ANNIVERSARY-DATE                                      
MFA-TR*              ,:WS-1ST-MNTH-ANNIV-DT                                     
MFA-TR*         FROM  CSS_BUDGET_PLAN                                           
MFA-TR*        WHERE  ACCOUNT_NO      = :BU-ACCOUNT-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C27405     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         DISPLAY '* 7800-GET-EPP-ANNIV-DATE              *'       
C27405         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27405         DISPLAY '* ACCOUNT NO ', BU-ACCOUNT-NO                   
C27405         DISPLAY '* PROGRAM ABORTING...                  *'       
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         PERFORM 9900-ABEND              THRU 9900-EXIT           
C27405     END-IF.                                                      
C27405*                                                                         
C27405 7800-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
      *                                                                         
C27405******************************************************************        
C27405* 7810-OPEN-EPP-SEAS-RATE                                        *        
C27405******************************************************************        
C27405*                                                                         
C27405 7810-OPEN-EPP-SEAS-RATE.                                         
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405         OPEN EPP_SEASONAL_RATE                                   
C27405     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C27405     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         DISPLAY '* 7810-OPEN-EPP-SEAS-RATE              *'       
C27405         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27405         DISPLAY '* ACCOUNT NO ', UT-ACCOUNT-NO                   
C27405         DISPLAY '* PROGRAM ABORTING...                  *'       
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         PERFORM 9900-ABEND              THRU 9900-EXIT           
C27405     END-IF.                                                      
C27405*                                                                         
C27405 7810-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* 7820-FETCH-EPP-SEAS-RATE                                       *        
C27405******************************************************************        
C27405*                                                                         
C27405 7820-FETCH-EPP-SEAS-RATE.                                        
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405         FETCH EPP_SEASONAL_RATE                                  
C27405          INTO :WS-SEASONAL-RATE-ACCT                             
C27405     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C27405     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         DISPLAY '* 7820-FETCH-EPP-SEAS-RATE             *'       
C27405         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27405         DISPLAY '* ACCOUNT NO ', UT-ACCOUNT-NO                   
C27405         DISPLAY '* PROGRAM ABORTING...                  *'       
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         PERFORM 9900-ABEND              THRU 9900-EXIT           
C27405     END-IF.                                                      
C27405*                                                                         
C27405 7820-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* 7830-CLOSE-EPP-SEAS-RATE.                                      *        
C27405******************************************************************        
C27405*                                                                         
C27405 7830-CLOSE-EPP-SEAS-RATE.                                        
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405         CLOSE EPP_SEASONAL_RATE                                  
C27405     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C27405     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         DISPLAY '* 7830-CLOSE-EPP-SEAS-RATE             *'       
C27405         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27405         DISPLAY '* ACCOUNT NO ', UT-ACCOUNT-NO                   
C27405         DISPLAY '* PROGRAM ABORTING...                  *'       
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         PERFORM 9900-ABEND              THRU 9900-EXIT           
C27405     END-IF.                                                      
C27405*                                                                         
C27405 7830-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* 7840-GET-BG-CX-DETAILS.                                        *        
C27405******************************************************************        
C27405*                                                                         
C27405 7840-GET-BG-CX-DETAILS.                                          
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405        SELECT  BG.PREMISE_NO                                     
C27405               ,BG.BILL_NO                                        
C27405               ,BG.CODE_UTIL_TYPE                                 
C27405               ,BG.IC_NO                                          
C27405               ,BG.CODE_REVENUE_CLASS                             
C27405               ,BG.CODE_SIC_NO                                    
C27405               ,BG.RATE_PLAN_NO                                   
C27405               ,BG.CODE_STAT_TAX_XMT                              
C27405               ,BG.CODE_CITY_TAX_XMT                              
C27405               ,BG.CODE_OTHR_TAX_XMT                              
C27405               ,BG.REV_RPT_CD                                     
C27405               ,BG.STANDBY_COMPLIED                               
C27405               ,BG.ACCOUNT_NO                                     
C27405               ,BG.COMPANY_NO                                     
C27405               ,BG.REVENUE_MONTH                                  
C27405               ,BG.REV_DISTRICT_CD                                
C27405               ,BG.FUEL_SHIPPER_CD                                
C27405               ,CX.CODE_UTIL_TYPE                                 
C27405               ,CX.IC_NO                                          
C27405               ,CX.MTR_REF_NO                                     
C27405               ,CX.REG_ID_NO                                      
C27405               ,CX.CODE_TIME_PERIOD                               
C27405               ,CX.ITEM_SEQ_NO                                    
C27405               ,CX.METER_NO                                       
C27405               ,CX.DATE_READ                                      
C27405               ,CX.CODE_METER_READ                                
C27405               ,CX.METER_READING                                  
C27405               ,CX.EMPLOYEE_NO                                    
C27405               ,CX.CONSTANT                                       
C27405               ,CX.NO_DIALS                                       
C27405               ,CX.COMPANY_NO                                     
C27405               ,CX.EXCEPT_OVERRIDE_CD                             
C27405               ,CX.DIGTL_INTRL_MTR_NO                             
C27405               ,CX.DIGTL_MTR_TYPE                                 
C27405               ,CX.CODE_TOU_SEASN                                 
C27405               ,CX.EXCL_DMD_RCHT_IND                              
C27405          INTO :BG-PREMISE-NO                                     
C27405              ,:BG-BILL-NO                                        
C27405              ,:BG-CODE-UTIL-TYPE                                 
C27405              ,:BG-IC-NO                                          
C27405              ,:BG-CODE-REVENUE-CLASS                             
C27405              ,:BG-CODE-SIC-NO                                    
C27405              ,:BG-RATE-PLAN-NO                                   
C27405              ,:BG-CODE-STAT-TAX-XMT                              
C27405              ,:BG-CODE-CITY-TAX-XMT                              
C27405              ,:BG-CODE-OTHR-TAX-XMT                              
C27405              ,:BG-REV-RPT-CD                                     
C27405              ,:BG-STANDBY-COMPLIED                               
C27405              ,:BG-ACCOUNT-NO                                     
C27405              ,:BG-COMPANY-NO                                     
C27405              ,:BG-REVENUE-MONTH                                  
C27405              ,:BG-REV-DISTRICT-CD                                
C27405              ,:BG-FUEL-SHIPPER-CD                                
C27405              ,:CX-CODE-UTIL-TYPE                                 
C27405              ,:CX-IC-NO                                          
C27405              ,:CX-MTR-REF-NO                                     
C27405              ,:CX-REG-ID-NO                                      
C27405              ,:CX-CODE-TIME-PERIOD                               
C27405              ,:CX-ITEM-SEQ-NO                                    
C27405              ,:CX-METER-NO                                       
C27405              ,:CX-DATE-READ                                      
C27405              ,:CX-CODE-METER-READ                                
C27405              ,:CX-METER-READING                                  
C27405              ,:CX-EMPLOYEE-NO                                    
C27405              ,:CX-CONSTANT                                       
C27405              ,:CX-NO-DIALS                                       
C27405              ,:CX-COMPANY-NO                                     
C27405              ,:CX-EXCEPT-OVERRIDE-CD                             
C27405              ,:CX-DIGTL-INTRL-MTR-NO                             
C27405              ,:CX-DIGTL-MTR-TYPE                                 
C27405              ,:CX-CODE-TOU-SEASN                                 
C27405              ,:CX-EXCL-DMD-RCHT-IND                              
C27405          FROM  CSS_BILLING_DET  BG                               
C27405               ,CSS_CNSMPTN_HIST CX                               
C27405         WHERE  BG.ACCOUNT_NO            = :BG-ACCOUNT-NO         
C27405           AND  BG.ACCOUNT_NO            =  CX.ACCOUNT_NO         
C27405           AND  BG.CODE_UTIL_TYPE        =  CX.CODE_UTIL_TYPE     
C27405           AND  BG.IC_NO                 =  CX.IC_NO              
C27405           AND  BG.BILL_NO               =  CX.BILL_NO            
C27405           AND  BG.BILL_NO           IN                           
C27405                (SELECT MAX(BG.BILL_NO)                           
C27405                   FROM CSS_BILLING_DET BG                        
C27405                  WHERE BG.ACCOUNT_NO    = :BG-ACCOUNT-NO)        
A00755                                                      
C27405     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BG.PREMISE_NO                                             
MFA-TR*              ,BG.BILL_NO                                                
MFA-TR*              ,BG.CODE_UTIL_TYPE                                         
MFA-TR*              ,BG.IC_NO                                                  
MFA-TR*              ,BG.CODE_REVENUE_CLASS                                     
MFA-TR*              ,BG.CODE_SIC_NO                                            
MFA-TR*              ,BG.RATE_PLAN_NO                                           
MFA-TR*              ,BG.CODE_STAT_TAX_XMT                                      
MFA-TR*              ,BG.CODE_CITY_TAX_XMT                                      
MFA-TR*              ,BG.CODE_OTHR_TAX_XMT                                      
MFA-TR*              ,BG.REV_RPT_CD                                             
MFA-TR*              ,BG.STANDBY_COMPLIED                                       
MFA-TR*              ,BG.ACCOUNT_NO                                             
MFA-TR*              ,BG.COMPANY_NO                                             
MFA-TR*              ,BG.REVENUE_MONTH                                          
MFA-TR*              ,BG.REV_DISTRICT_CD                                        
MFA-TR*              ,BG.FUEL_SHIPPER_CD                                        
MFA-TR*              ,CX.CODE_UTIL_TYPE                                         
MFA-TR*              ,CX.IC_NO                                                  
MFA-TR*              ,CX.MTR_REF_NO                                             
MFA-TR*              ,CX.REG_ID_NO                                              
MFA-TR*              ,CX.CODE_TIME_PERIOD                                       
MFA-TR*              ,CX.ITEM_SEQ_NO                                            
MFA-TR*              ,CX.METER_NO                                               
MFA-TR*              ,CX.DATE_READ                                              
MFA-TR*              ,CX.CODE_METER_READ                                        
MFA-TR*              ,CX.METER_READING                                          
MFA-TR*              ,CX.EMPLOYEE_NO                                            
MFA-TR*              ,CX.CONSTANT                                               
MFA-TR*              ,CX.NO_DIALS                                               
MFA-TR*              ,CX.COMPANY_NO                                             
MFA-TR*              ,CX.EXCEPT_OVERRIDE_CD                                     
MFA-TR*              ,CX.DIGTL_INTRL_MTR_NO                                     
MFA-TR*              ,CX.DIGTL_MTR_TYPE                                         
MFA-TR*              ,CX.CODE_TOU_SEASN                                         
MFA-TR*              ,CX.EXCL_DMD_RCHT_IND                                      
MFA-TR*         INTO :BG-PREMISE-NO                                             
MFA-TR*             ,:BG-BILL-NO                                                
MFA-TR*             ,:BG-CODE-UTIL-TYPE                                         
MFA-TR*             ,:BG-IC-NO                                                  
MFA-TR*             ,:BG-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:BG-CODE-SIC-NO                                            
MFA-TR*             ,:BG-RATE-PLAN-NO                                           
MFA-TR*             ,:BG-CODE-STAT-TAX-XMT                                      
MFA-TR*             ,:BG-CODE-CITY-TAX-XMT                                      
MFA-TR*             ,:BG-CODE-OTHR-TAX-XMT                                      
MFA-TR*             ,:BG-REV-RPT-CD                                             
MFA-TR*             ,:BG-STANDBY-COMPLIED                                       
MFA-TR*             ,:BG-ACCOUNT-NO                                             
MFA-TR*             ,:BG-COMPANY-NO                                             
MFA-TR*             ,:BG-REVENUE-MONTH                                          
MFA-TR*             ,:BG-REV-DISTRICT-CD                                        
MFA-TR*             ,:BG-FUEL-SHIPPER-CD                                        
MFA-TR*             ,:CX-CODE-UTIL-TYPE                                         
MFA-TR*             ,:CX-IC-NO                                                  
MFA-TR*             ,:CX-MTR-REF-NO                                             
MFA-TR*             ,:CX-REG-ID-NO                                              
MFA-TR*             ,:CX-CODE-TIME-PERIOD                                       
MFA-TR*             ,:CX-ITEM-SEQ-NO                                            
MFA-TR*             ,:CX-METER-NO                                               
MFA-TR*             ,:CX-DATE-READ                                              
MFA-TR*             ,:CX-CODE-METER-READ                                        
MFA-TR*             ,:CX-METER-READING                                          
MFA-TR*             ,:CX-EMPLOYEE-NO                                            
MFA-TR*             ,:CX-CONSTANT                                               
MFA-TR*             ,:CX-NO-DIALS                                               
MFA-TR*             ,:CX-COMPANY-NO                                             
MFA-TR*             ,:CX-EXCEPT-OVERRIDE-CD                                     
MFA-TR*             ,:CX-DIGTL-INTRL-MTR-NO                                     
MFA-TR*             ,:CX-DIGTL-MTR-TYPE                                         
MFA-TR*             ,:CX-CODE-TOU-SEASN                                         
MFA-TR*             ,:CX-EXCL-DMD-RCHT-IND                                      
MFA-TR*         FROM  CSS_BILLING_DET  BG                                       
MFA-TR*              ,CSS_CNSMPTN_HIST CX                                       
MFA-TR*        WHERE  BG.ACCOUNT_NO            = :BG-ACCOUNT-NO                 
MFA-TR*          AND  BG.ACCOUNT_NO            =  CX.ACCOUNT_NO                 
MFA-TR*          AND  BG.CODE_UTIL_TYPE        =  CX.CODE_UTIL_TYPE             
MFA-TR*          AND  BG.IC_NO                 =  CX.IC_NO                      
MFA-TR*          AND  BG.BILL_NO               =  CX.BILL_NO                    
MFA-TR*          AND  BG.BILL_NO           IN                                   
MFA-TR*               (SELECT MAX(BG.BILL_NO)                                   
MFA-TR*                  FROM CSS_BILLING_DET BG                                
MFA-TR*                 WHERE BG.ACCOUNT_NO    = :BG-ACCOUNT-NO)                
MFA-TR*        QUERYNO 7840                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C27405     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C27405         OR -811                                                  
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         DISPLAY '* 7840-GET-BG-CX-DETAILS               *'       
C27405         DISPLAY '* ACCOUNT NO', BG-ACCOUNT-NO                    
C27405         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27405         DISPLAY '* PROGRAM ABORTING...                  *'       
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         PERFORM 9900-ABEND              THRU 9900-EXIT           
C27405     END-IF.                                                      
C27405*                                                                         
C27405 7840-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* 7845-SELECT-BG-CX-DET.                                         *        
C27405******************************************************************        
C27405*                                                                         
C27405 7845-SELECT-BG-CX-DET.                                           
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405        SELECT  BG.PREMISE_NO                                     
C27405               ,BG.BILL_NO                                        
C27405               ,BG.CODE_UTIL_TYPE                                 
C27405               ,BG.IC_NO                                          
C27405               ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
C27405               ,BG.CODE_REVENUE_CLASS                             
C27405               ,BG.RATE_PLAN_NO                                   
C27405               ,BG.COMPANY_NO                                     
C27405               ,BG.REVENUE_MONTH                                  
C27405               ,CX.MTR_REF_NO                                     
C27405               ,CX.METER_NO                                       
C27405               ,CX.CODE_METER_READ                                
C27405               ,CX.METER_READING                                  
C27405               ,CX.EMPLOYEE_NO                                    
C27405               ,CX.CONSTANT                                       
C27405               ,CX.NO_DIALS                                       
C27405          INTO :BG-PREMISE-NO                                     
C27405              ,:BG-BILL-NO                                        
C27405              ,:BG-CODE-UTIL-TYPE                                 
C27405              ,:BG-IC-NO                                          
C27405              ,:BG-BILL-ITEM-TIMESTMP                             
C27405              ,:BG-CODE-REVENUE-CLASS                             
C27405              ,:BG-RATE-PLAN-NO                                   
C27405              ,:BG-COMPANY-NO                                     
C27405              ,:BG-REVENUE-MONTH                                  
C27405              ,:CX-MTR-REF-NO                                     
C27405              ,:CX-METER-NO                                       
C27405              ,:CX-CODE-METER-READ                                
C27405              ,:CX-METER-READING                                  
C27405              ,:CX-EMPLOYEE-NO                                    
C27405              ,:CX-CONSTANT                                       
C27405              ,:CX-NO-DIALS                                       
C27405          FROM  CSS_BILLING_DET  BG                               
C27405               ,CSS_CNSMPTN_HIST CX                               
C27405         WHERE  BG.ACCOUNT_NO            = :BG-ACCOUNT-NO         
C27405           AND  BG.ACCOUNT_NO            =  CX.ACCOUNT_NO         
C27405           AND  BG.CODE_UTIL_TYPE        =  CX.CODE_UTIL_TYPE     
C27405           AND  BG.IC_NO                 =  CX.IC_NO              
C27405           AND  BG.BILL_NO               =  CX.BILL_NO            
C27405           AND  BG.REVENUE_MONTH         =  :BG-REVENUE-MONTH     
C27405           AND  BG.BILL_NO           IN                           
C27405                (SELECT MIN(BG.BILL_NO)                           
C27405                   FROM CSS_BILLING_DET BG                        
C27405                  WHERE BG.ACCOUNT_NO    = :BG-ACCOUNT-NO         
C27405                    AND BG.REVENUE_MONTH = :BG-REVENUE-MONTH)     
A00755                                                      
C27405     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  BG.PREMISE_NO                                             
MFA-TR*              ,BG.BILL_NO                                                
MFA-TR*              ,BG.CODE_UTIL_TYPE                                         
MFA-TR*              ,BG.IC_NO                                                  
MFA-TR*              ,BG.BILL_ITEM_TIMESTMP                                     
MFA-TR*              ,BG.CODE_REVENUE_CLASS                                     
MFA-TR*              ,BG.RATE_PLAN_NO                                           
MFA-TR*              ,BG.COMPANY_NO                                             
MFA-TR*              ,BG.REVENUE_MONTH                                          
MFA-TR*              ,CX.MTR_REF_NO                                             
MFA-TR*              ,CX.METER_NO                                               
MFA-TR*              ,CX.CODE_METER_READ                                        
MFA-TR*              ,CX.METER_READING                                          
MFA-TR*              ,CX.EMPLOYEE_NO                                            
MFA-TR*              ,CX.CONSTANT                                               
MFA-TR*              ,CX.NO_DIALS                                               
MFA-TR*         INTO :BG-PREMISE-NO                                             
MFA-TR*             ,:BG-BILL-NO                                                
MFA-TR*             ,:BG-CODE-UTIL-TYPE                                         
MFA-TR*             ,:BG-IC-NO                                                  
MFA-TR*             ,:BG-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:BG-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:BG-RATE-PLAN-NO                                           
MFA-TR*             ,:BG-COMPANY-NO                                             
MFA-TR*             ,:BG-REVENUE-MONTH                                          
MFA-TR*             ,:CX-MTR-REF-NO                                             
MFA-TR*             ,:CX-METER-NO                                               
MFA-TR*             ,:CX-CODE-METER-READ                                        
MFA-TR*             ,:CX-METER-READING                                          
MFA-TR*             ,:CX-EMPLOYEE-NO                                            
MFA-TR*             ,:CX-CONSTANT                                               
MFA-TR*             ,:CX-NO-DIALS                                               
MFA-TR*         FROM  CSS_BILLING_DET  BG                                       
MFA-TR*              ,CSS_CNSMPTN_HIST CX                                       
MFA-TR*        WHERE  BG.ACCOUNT_NO            = :BG-ACCOUNT-NO                 
MFA-TR*          AND  BG.ACCOUNT_NO            =  CX.ACCOUNT_NO                 
MFA-TR*          AND  BG.CODE_UTIL_TYPE        =  CX.CODE_UTIL_TYPE             
MFA-TR*          AND  BG.IC_NO                 =  CX.IC_NO                      
MFA-TR*          AND  BG.BILL_NO               =  CX.BILL_NO                    
MFA-TR*          AND  BG.REVENUE_MONTH         =  :BG-REVENUE-MONTH             
MFA-TR*          AND  BG.BILL_NO           IN                                   
MFA-TR*               (SELECT MIN(BG.BILL_NO)                                   
MFA-TR*                  FROM CSS_BILLING_DET BG                                
MFA-TR*                 WHERE BG.ACCOUNT_NO    = :BG-ACCOUNT-NO                 
MFA-TR*                   AND BG.REVENUE_MONTH = :BG-REVENUE-MONTH)             
MFA-TR*        QUERYNO 7845                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C27405     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C27405         OR -811                                                  
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         DISPLAY '* 7845-SELECT-BG-CX-DET                *'       
C27405         DISPLAY '* ACCOUNT NO', BG-ACCOUNT-NO                    
C27405         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27405         DISPLAY '* PROGRAM ABORTING...                  *'       
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         PERFORM 9900-ABEND              THRU 9900-EXIT           
C27405     END-IF.                                                      
C27405*                                                                         
C27405 7845-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* 7850-GET-MAX-BI-BILLNO                                         *        
C27405******************************************************************        
C27405*                                                                         
C27405 7850-GET-MAX-BI-BILLNO.                                          
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405        SELECT  MAX(BILL_NO)                                      
C27405          INTO  :BI-BILL-NO                                       
C27405          FROM  CSS_BILLING_HDR                                   
C27405         WHERE  ACCOUNT_NO      = :BI-ACCOUNT-NO                  
A00755                                                      
C27405     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  MAX(BILL_NO)                                              
MFA-TR*         INTO  :BI-BILL-NO                                               
MFA-TR*         FROM  CSS_BILLING_HDR                                           
MFA-TR*        WHERE  ACCOUNT_NO      = :BI-ACCOUNT-NO                          
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C27405     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
C27405            DISPLAY '********** PCSCA099 ABORT **************'    
C27405            DISPLAY '* 7850-GET-MAX-BILLNO                  *'    
C27405            DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
C27405            DISPLAY '*ACCOUNT NO', BI-ACCOUNT-NO 'NOT IN BI TABLE'
C27405         ELSE                                                     
C27405            DISPLAY '********** PCSCA099 ABORT **************'    
C27405            DISPLAY '* 7850-GET-MAX-BILLNO                  *'    
C27405            DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
C27405            DISPLAY '* ACCOUNT NO ', BI-ACCOUNT-NO                
C27405            DISPLAY '* PROGRAM ABORTING...                  *'    
C27405            DISPLAY '********** PCSCA099 ABORT **************'    
C27405            PERFORM 9900-ABEND              THRU 9900-EXIT        
C27405         END-IF                                                   
C27405     END-IF.                                                      
C27405*                                                                         
C27405 7850-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* 7855-GET-BI-DETAILS.                                           *        
C27405******************************************************************        
C27405*                                                                         
C27405 7855-GET-BI-DETAILS.                                             
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405        SELECT  COALESCE (CAST(DATE_BILLED AS CHAR(10)),' '),             
C27405                REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
A00755          INTO  :BI-DATE-BILLED                                   
A00755               ,:BI-LAST-UPDATE-TS                                
C27405          FROM  CSS_BILLING_HDR                                   
C27405         WHERE  ACCOUNT_NO      = :BI-ACCOUNT-NO                  
C27405           AND  BILL_NO         = :BG-BILL-NO                     
A00755                                                      
C27405     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  COALESCE (CHAR(DATE_BILLED),' '),                         
MFA-TR*               LAST_UPDATE_TS                                            
MFA-TR*         INTO  :BI-DATE-BILLED                                           
MFA-TR*              ,:BI-LAST-UPDATE-TS                                        
MFA-TR*         FROM  CSS_BILLING_HDR                                           
MFA-TR*        WHERE  ACCOUNT_NO      = :BI-ACCOUNT-NO                          
MFA-TR*          AND  BILL_NO         = :BG-BILL-NO                             
MFA-TR*        QUERYNO 7855                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C27405     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A00755         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         DISPLAY '* 7855-GET-BI-DETAILS                  *'       
C27405         DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
C27405         DISPLAY '* ACCOUNT NO ', BI-ACCOUNT-NO                   
C27405         DISPLAY '* BILL NO    ', BG-BILL-NO                      
C27405         DISPLAY '* PROGRAM ABORTING...                  *'       
C27405         DISPLAY '********** PCSCA099 ABORT **************'       
C27405         PERFORM 9900-ABEND              THRU 9900-EXIT           
C27405     END-IF.                                                      
C27405*                                                                         
C27405 7855-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
ACT088* COMPUTE VALUE FOR MONTHS DIFFERENT BETWEEN 2 FIELDS.                    
ACT088 7925-COMPUTE-DIFFERENCE.                                         
ACT088                                                                  
ACT088     MOVE SPACES TO WS-ANNIV-TS-DATE                              
ACT088                    WS-PYMT-TS-DATE.                              
ACT088                                                                  
ACT088     MOVE WS-ANNIV-DT-CUR TO WS-ANNIV-TS-DATE.                    
ACT088     MOVE WS-PYMT-STRT-DT TO WS-PYMT-TS-DATE.                     
ACT088                                                                  
ACT088                                                                  
ACT088     MOVE SPACES TO WS-ANNIV-26                                   
ACT088                    WS-PYMT-26.                                   
ACT088                                                                  
ACT088     MOVE WS-ANNIV-TS TO WS-ANNIV-26.                             
ACT088     MOVE WS-PYMT-TS  TO WS-PYMT-26.                              
ACT088                                                                  
ACT088     MOVE 0 TO WS-TIME-DIFFERENCE.                                
ACT088                                                                  
ACT088     EXEC SQL                                                     
ACT088         SELECT
              CIS.TIMESTAMPDIFF(64,CIS.DECIMAL2CHAR(                            
ACT088                CIS.DIFFTIMESTAMP( CIS.CHAR2TIMESTAMP(
                                                        :WS-ANNIV-26), 
           CIS.CHAR2TIMESTAMP(:WS-PYMT-26) )))
            INTO
              :WS-TIME-DIFFERENCE :WS-NULL-DIFF                    
ACT088     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES TIMESTAMPDIFF(64,CHAR(                                    
MFA-TR*               TIMESTAMP(:WS-ANNIV-26) -                                 
MFA-TR*               TIMESTAMP(:WS-PYMT-26)))                                  
MFA-TR*        INTO :WS-TIME-DIFFERENCE:WS-NULL-DIFF                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT088                                                                  
ACT088     IF SQLCODE = 0                                               
ACT088         CONTINUE                                                 
ACT088     ELSE                                                         
ACT088         DISPLAY '**  ERROR ON 7925-COMPUTE-DIFFERENCE      **'   
ACT088         DISPLAY '**  BAD CALL USING MONTHS CALL            **'   
ACT088         DISPLAY '* ACCOUNT NO       = ' BU-ACCOUNT-NO            
ACT088         DISPLAY '**  ANNIV DATE     = ' WS-ANNIV-DT-CUR          
ACT088         DISPLAY '**  START DATE     = ' WS-PYMT-STRT-DT          
ACT088         DISPLAY '**  RETURN CODE    = ' SQLCODE                  
ACT088         PERFORM 9900-ABEND                THRU 9900-EXIT         
ACT088     END-IF.                                                      
ACT088                                                                  
ACT088     IF WS-NULL-DIFF < 0                                          
ACT088         MOVE 0 TO WS-TIME-DIFFERENCE
           END-IF.                            
ACT088                                                                  
ACT088                                                                  
ACT088                                                                  
ACT088 7925-COMPUTE-DIFFERENCE-EXIT.                                    
ACT088     EXIT.                                                        
C27405******************************************************************        
C27405* 8010-INSERT-BG-DETAILS.                                        *        
C27405******************************************************************        
C27405*                                                                         
C27405 8010-INSERT-BG-DETAILS.                                          
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405          INSERT INTO CSS_BILLING_DET                             
C27405                ( PREMISE_NO                                      
C27405                 ,BILL_NO                                         
C27405                 ,CODE_UTIL_TYPE                                  
C27405                 ,IC_NO                                           
C27405                 ,BILL_ITEM_TIMESTMP                              
C27405                 ,DATE_ORIG_BILL                                  
C27405                 ,AMT_BILL_ITEM                                   
C27405                 ,CODE_BILL_CALC                                  
C27405                 ,CODE_BILL_ITM_TYPE                              
C27405                 ,CODE_BILL_ITM_IND                               
C27405                 ,CODE_DR_CR_CNSMPTN                              
C27405                 ,AMT_STATE_TAX                                   
C27405                 ,AMT_CITY_TAX                                    
C27405                 ,AMT_OTHER_TAX                                   
C27405                 ,CODE_REVENUE_CLASS                              
C27405                 ,CODE_SIC_NO                                     
C27405                 ,RATE_PLAN_NO                                    
C27405                 ,CODE_CURTAIL_PRTY                               
C27405                 ,CODE_STAT_TAX_XMT                               
C27405                 ,CODE_CITY_TAX_XMT                               
C27405                 ,CODE_OTHR_TAX_XMT                               
C27405                 ,REV_RPT_CD                                      
C27405                 ,STANDBY_COMPLIED                                
C27405                 ,PRORATE_CD                                      
C27405                 ,NEW_RATE_PCT                                    
C27405                 ,CODE_SUB_TOTAL                                  
C27405                 ,TAX_REFUND_CD                                   
C27405                 ,ACCOUNT_NO                                      
C27405                 ,COMPANY_NO                                      
C27405                 ,DATE_LFTM_HI_DMD                                
C27405                 ,LFTM_HI_PEAK_DMD                                
C27405                 ,REBILL_IND                                      
C27405                 ,ADJ_REASON_CD                                   
C27405                 ,REVENUE_MONTH                                   
C27405                 ,GAS_BASE_USE                                    
C27405                 ,WNA_FACTOR                                      
C27405                 ,BTU_FACTOR                                      
C27405                 ,NO_OF_CONS_DAYS                                 
C27405                 ,REV_MTH_ORIG_BILL                               
C27405                 ,REV_DISTRICT_CD                                 
C27405                 ,FUEL_SHIPPER_CD )                               
C27405          VALUES                                                  
C27405               ( :BG-PREMISE-NO                                   
C27405                ,:BG-BILL-NO                                      
C27405                ,:BG-CODE-UTIL-TYPE                               
C27405                ,:BG-IC-NO                                        
C27405                ,CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP)               
C27405                ,IIF(TRY_CONVERT(DATE, :BG-DATE-ORIG-BILL 
                                             :WS-NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-ORIG-BILL 
                                                     :WS-NULL-INDICATOR
              ) <> 0) OR (LEN(:BG-DATE-ORIG-BILL :WS-NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-ORIG-BILL 
                                                     :WS-NULL-INDICATOR
              ), CONVERT(DATE, :BG-DATE-ORIG-BILL :WS-NULL-INDICATOR) )        
C27405                ,:BG-AMT-BILL-ITEM                                
C27405                ,:BG-CODE-BILL-CALC                               
C27405                ,:BG-CODE-BILL-ITM-TYPE                           
C27405                ,:BG-CODE-BILL-ITM-IND                            
C27405                ,:BG-CODE-DR-CR-CNSMPTN                           
C27405                ,:BG-AMT-STATE-TAX                                
C27405                ,:BG-AMT-CITY-TAX                                 
C27405                ,:BG-AMT-OTHER-TAX                                
C27405                ,:BG-CODE-REVENUE-CLASS                           
C27405                ,:BG-CODE-SIC-NO                                  
C27405                ,:BG-RATE-PLAN-NO                                 
C27405                ,:BG-CODE-CURTAIL-PRTY                            
C27405                ,:BG-CODE-STAT-TAX-XMT                            
C27405                ,:BG-CODE-CITY-TAX-XMT                            
C27405                ,:BG-CODE-OTHR-TAX-XMT                            
C27405                ,:BG-REV-RPT-CD                                   
C27405                ,:BG-STANDBY-COMPLIED                             
C27405                ,:BG-PRORATE-CD                                   
C27405                ,:BG-NEW-RATE-PCT                                 
C27405                ,:BG-CODE-SUB-TOTAL                               
C27405                ,:BG-TAX-REFUND-CD                                
C27405                ,:BG-ACCOUNT-NO                                   
C27405                ,:BG-COMPANY-NO                                   
C27405                ,IIF(TRY_CONVERT(DATE, :BG-DATE-LFTM-HI-DMD 
                                             :WS-NULL-INDICATOR
              ) IS NULL OR (PATINDEX('%.%', :BG-DATE-LFTM-HI-DMD 
                                                     :WS-NULL-INDICATOR
              ) <> 0) OR (LEN(:BG-DATE-LFTM-HI-DMD :WS-NULL-INDICATOR
              ) <> 10), CIS.CHAR2DATE(:BG-DATE-LFTM-HI-DMD 
                                                     :WS-NULL-INDICATOR
              ), CONVERT(DATE, :BG-DATE-LFTM-HI-DMD :WS-NULL-INDICATOR
              ) )          
C27405                ,:BG-LFTM-HI-PEAK-DMD                             
C27405                ,:BG-REBILL-IND                                   
C27405                ,:BG-ADJ-REASON-CD                                
C27405                ,:BG-REVENUE-MONTH                                
C27405                ,:BG-GAS-BASE-USE                                 
C27405                ,:BG-WNA-FACTOR                                   
C27405                ,:BG-BTU-FACTOR                                   
C27405                ,:BG-NO-OF-CONS-DAYS                              
C27405                ,:BG-REV-MTH-ORIG-BILL                            
C27405                ,:BG-REV-DISTRICT-CD                              
C27405                ,:BG-FUEL-SHIPPER-CD )                            
C27405     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BILLING_DET                                     
MFA-TR*               ( PREMISE_NO                                              
MFA-TR*                ,BILL_NO                                                 
MFA-TR*                ,CODE_UTIL_TYPE                                          
MFA-TR*                ,IC_NO                                                   
MFA-TR*                ,BILL_ITEM_TIMESTMP                                      
MFA-TR*                ,DATE_ORIG_BILL                                          
MFA-TR*                ,AMT_BILL_ITEM                                           
MFA-TR*                ,CODE_BILL_CALC                                          
MFA-TR*                ,CODE_BILL_ITM_TYPE                                      
MFA-TR*                ,CODE_BILL_ITM_IND                                       
MFA-TR*                ,CODE_DR_CR_CNSMPTN                                      
MFA-TR*                ,AMT_STATE_TAX                                           
MFA-TR*                ,AMT_CITY_TAX                                            
MFA-TR*                ,AMT_OTHER_TAX                                           
MFA-TR*                ,CODE_REVENUE_CLASS                                      
MFA-TR*                ,CODE_SIC_NO                                             
MFA-TR*                ,RATE_PLAN_NO                                            
MFA-TR*                ,CODE_CURTAIL_PRTY                                       
MFA-TR*                ,CODE_STAT_TAX_XMT                                       
MFA-TR*                ,CODE_CITY_TAX_XMT                                       
MFA-TR*                ,CODE_OTHR_TAX_XMT                                       
MFA-TR*                ,REV_RPT_CD                                              
MFA-TR*                ,STANDBY_COMPLIED                                        
MFA-TR*                ,PRORATE_CD                                              
MFA-TR*                ,NEW_RATE_PCT                                            
MFA-TR*                ,CODE_SUB_TOTAL                                          
MFA-TR*                ,TAX_REFUND_CD                                           
MFA-TR*                ,ACCOUNT_NO                                              
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,DATE_LFTM_HI_DMD                                        
MFA-TR*                ,LFTM_HI_PEAK_DMD                                        
MFA-TR*                ,REBILL_IND                                              
MFA-TR*                ,ADJ_REASON_CD                                           
MFA-TR*                ,REVENUE_MONTH                                           
MFA-TR*                ,GAS_BASE_USE                                            
MFA-TR*                ,WNA_FACTOR                                              
MFA-TR*                ,BTU_FACTOR                                              
MFA-TR*                ,NO_OF_CONS_DAYS                                         
MFA-TR*                ,REV_MTH_ORIG_BILL                                       
MFA-TR*                ,REV_DISTRICT_CD                                         
MFA-TR*                ,FUEL_SHIPPER_CD )                                       
MFA-TR*         VALUES                                                          
MFA-TR*              ( :BG-PREMISE-NO                                           
MFA-TR*               ,:BG-BILL-NO                                              
MFA-TR*               ,:BG-CODE-UTIL-TYPE                                       
MFA-TR*               ,:BG-IC-NO                                                
MFA-TR*               ,:BG-BILL-ITEM-TIMESTMP                                   
MFA-TR*               ,:BG-DATE-ORIG-BILL :WS-NULL-INDICATOR                    
MFA-TR*               ,:BG-AMT-BILL-ITEM                                        
MFA-TR*               ,:BG-CODE-BILL-CALC                                       
MFA-TR*               ,:BG-CODE-BILL-ITM-TYPE                                   
MFA-TR*               ,:BG-CODE-BILL-ITM-IND                                    
MFA-TR*               ,:BG-CODE-DR-CR-CNSMPTN                                   
MFA-TR*               ,:BG-AMT-STATE-TAX                                        
MFA-TR*               ,:BG-AMT-CITY-TAX                                         
MFA-TR*               ,:BG-AMT-OTHER-TAX                                        
MFA-TR*               ,:BG-CODE-REVENUE-CLASS                                   
MFA-TR*               ,:BG-CODE-SIC-NO                                          
MFA-TR*               ,:BG-RATE-PLAN-NO                                         
MFA-TR*               ,:BG-CODE-CURTAIL-PRTY                                    
MFA-TR*               ,:BG-CODE-STAT-TAX-XMT                                    
MFA-TR*               ,:BG-CODE-CITY-TAX-XMT                                    
MFA-TR*               ,:BG-CODE-OTHR-TAX-XMT                                    
MFA-TR*               ,:BG-REV-RPT-CD                                           
MFA-TR*               ,:BG-STANDBY-COMPLIED                                     
MFA-TR*               ,:BG-PRORATE-CD                                           
MFA-TR*               ,:BG-NEW-RATE-PCT                                         
MFA-TR*               ,:BG-CODE-SUB-TOTAL                                       
MFA-TR*               ,:BG-TAX-REFUND-CD                                        
MFA-TR*               ,:BG-ACCOUNT-NO                                           
MFA-TR*               ,:BG-COMPANY-NO                                           
MFA-TR*               ,:BG-DATE-LFTM-HI-DMD :WS-NULL-INDICATOR                  
MFA-TR*               ,:BG-LFTM-HI-PEAK-DMD                                     
MFA-TR*               ,:BG-REBILL-IND                                           
MFA-TR*               ,:BG-ADJ-REASON-CD                                        
MFA-TR*               ,:BG-REVENUE-MONTH                                        
MFA-TR*               ,:BG-GAS-BASE-USE                                         
MFA-TR*               ,:BG-WNA-FACTOR                                           
MFA-TR*               ,:BG-BTU-FACTOR                                           
MFA-TR*               ,:BG-NO-OF-CONS-DAYS                                      
MFA-TR*               ,:BG-REV-MTH-ORIG-BILL                                    
MFA-TR*               ,:BG-REV-DISTRICT-CD                                      
MFA-TR*               ,:BG-FUEL-SHIPPER-CD )                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
C27405     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '**  ERROR ON 8010-INSERT-BG-DETAILS       **'   
C27405         DISPLAY '**  COULD NOT INSERT IN CSS_BILLING_DET   **'   
C27405         DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE    
C27405         DISPLAY '**  ACCOUNT-NO     = ' BG-ACCOUNT-NO            
C27405         PERFORM 9900-ABEND                THRU 9900-EXIT         
C27405     END-IF.                                                      
C27405*                                                                         
C27405 8010-EXIT.                                                       
C27405     EXIT.                                                        
C27405*                                                                         
C27405******************************************************************        
C27405* 8020-INSERT-CX-DETAILS.                                        *        
C27405******************************************************************        
C27405*                                                                         
C27405 8020-INSERT-CX-DETAILS.                                          
C27405*                                                                         
C27405     EXEC SQL                                                     
C27405          INSERT INTO CSS_CNSMPTN_HIST                            
C27405                ( ACCOUNT_NO                                      
C27405                 ,BILL_NO                                         
C27405                 ,CODE_UTIL_TYPE                                  
C27405                 ,IC_NO                                           
C27405                 ,BILL_ITEM_TIMESTMP                              
C27405                 ,MTR_REF_NO                                      
C27405                 ,REG_ID_NO                                       
C27405                 ,CODE_TIME_PERIOD                                
C27405                 ,ITEM_SEQ_NO                                     
C27405                 ,CODE_USAGE_TYPE                                 
C27405                 ,CODE_USAGE_ID                                   
C27405                 ,CODE_USAGE_SOURCE                               
C27405                 ,METER_NO                                        
C27405                 ,DATE_READ                                       
C27405                 ,CODE_METER_READ                                 
C27405                 ,CODE_METER_NO_READ                              
C27405                 ,METER_READING                                   
C27405                 ,DEMAND_READING                                  
C27405                 ,EMPLOYEE_NO                                     
C27405                 ,NO_UNITS                                        
C27405                 ,NO_DEMAND_UNITS                                 
C27405                 ,NO_DAYS                                         
C27405                 ,CODE_SOURCE_ID                                  
C27405                 ,CODE_DEBIT_CREDIT                               
C27405                 ,CODE_ITEM_STATUS                                
C27405                 ,CODE_DISCOUNT                                   
C27405                 ,CONSTANT                                        
C27405                 ,NO_DIALS                                        
C27405                 ,COMPANY_NO                                      
C27405                 ,EXCEPT_OVERRIDE_CD                              
C27405                 ,REQUESTED_USAGE                                 
C27405                 ,DIGTL_INTRL_MTR_NO                              
C27405                 ,DIGTL_MTR_TYPE                                  
C27405                 ,CODE_TOU_SEASN                                  
C27405                 ,EXCL_DMD_RCHT_IND )                             
C27405          VALUES                                                  
C27405               ( :CX-ACCOUNT-NO                                   
C27405                ,:CX-BILL-NO                                      
C27405                ,:CX-CODE-UTIL-TYPE                               
C27405                ,:CX-IC-NO                                        
C27405                ,CIS.CHAR2TIMESTAMP(:CX-BILL-ITEM-TIMESTMP)               
C27405                ,:CX-MTR-REF-NO                                   
C27405                ,:CX-REG-ID-NO                                    
C27405                ,:CX-CODE-TIME-PERIOD                             
C27405                ,:CX-ITEM-SEQ-NO                                  
C27405                ,:CX-CODE-USAGE-TYPE                              
C27405                ,:CX-CODE-USAGE-ID                                
C27405                ,:CX-CODE-USAGE-SOURCE                            
C27405                ,:CX-METER-NO                                     
C27405                ,IIF(TRY_CONVERT(DATE, :CX-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :CX-DATE-READ
              ) <> 0) OR (LEN(:CX-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                          :CX-DATE-READ
              ), CONVERT(DATE, :CX-DATE-READ) )                                
C27405                ,:CX-CODE-METER-READ                              
C27405                ,:CX-CODE-METER-NO-READ                           
C27405                ,:CX-METER-READING                                
C27405                ,:CX-DEMAND-READING                               
C27405                ,:CX-EMPLOYEE-NO                                  
C27405                ,:CX-NO-UNITS                                     
C27405                ,:CX-NO-DEMAND-UNITS                              
C27405                ,:CX-NO-DAYS                                      
C27405                ,:CX-CODE-SOURCE-ID                               
C27405                ,:CX-CODE-DEBIT-CREDIT                            
C27405                ,:CX-CODE-ITEM-STATUS                             
C27405                ,:CX-CODE-DISCOUNT                                
C27405                ,:CX-CONSTANT                                     
C27405                ,:CX-NO-DIALS                                     
C27405                ,:CX-COMPANY-NO                                   
C27405                ,:CX-EXCEPT-OVERRIDE-CD                           
C27405                ,:CX-REQUESTED-USAGE                              
C27405                ,:CX-DIGTL-INTRL-MTR-NO                           
C27405                ,:CX-DIGTL-MTR-TYPE                               
C27405                ,:CX-CODE-TOU-SEASN                               
C27405                ,:CX-EXCL-DMD-RCHT-IND )                          
C27405     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_CNSMPTN_HIST                                    
MFA-TR*               ( ACCOUNT_NO                                              
MFA-TR*                ,BILL_NO                                                 
MFA-TR*                ,CODE_UTIL_TYPE                                          
MFA-TR*                ,IC_NO                                                   
MFA-TR*                ,BILL_ITEM_TIMESTMP                                      
MFA-TR*                ,MTR_REF_NO                                              
MFA-TR*                ,REG_ID_NO                                               
MFA-TR*                ,CODE_TIME_PERIOD                                        
MFA-TR*                ,ITEM_SEQ_NO                                             
MFA-TR*                ,CODE_USAGE_TYPE                                         
MFA-TR*                ,CODE_USAGE_ID                                           
MFA-TR*                ,CODE_USAGE_SOURCE                                       
MFA-TR*                ,METER_NO                                                
MFA-TR*                ,DATE_READ                                               
MFA-TR*                ,CODE_METER_READ                                         
MFA-TR*                ,CODE_METER_NO_READ                                      
MFA-TR*                ,METER_READING                                           
MFA-TR*                ,DEMAND_READING                                          
MFA-TR*                ,EMPLOYEE_NO                                             
MFA-TR*                ,NO_UNITS                                                
MFA-TR*                ,NO_DEMAND_UNITS                                         
MFA-TR*                ,NO_DAYS                                                 
MFA-TR*                ,CODE_SOURCE_ID                                          
MFA-TR*                ,CODE_DEBIT_CREDIT                                       
MFA-TR*                ,CODE_ITEM_STATUS                                        
MFA-TR*                ,CODE_DISCOUNT                                           
MFA-TR*                ,CONSTANT                                                
MFA-TR*                ,NO_DIALS                                                
MFA-TR*                ,COMPANY_NO                                              
MFA-TR*                ,EXCEPT_OVERRIDE_CD                                      
MFA-TR*                ,REQUESTED_USAGE                                         
MFA-TR*                ,DIGTL_INTRL_MTR_NO                                      
MFA-TR*                ,DIGTL_MTR_TYPE                                          
MFA-TR*                ,CODE_TOU_SEASN                                          
MFA-TR*                ,EXCL_DMD_RCHT_IND )                                     
MFA-TR*         VALUES                                                          
MFA-TR*              ( :CX-ACCOUNT-NO                                           
MFA-TR*               ,:CX-BILL-NO                                              
MFA-TR*               ,:CX-CODE-UTIL-TYPE                                       
MFA-TR*               ,:CX-IC-NO                                                
MFA-TR*               ,:CX-BILL-ITEM-TIMESTMP                                   
MFA-TR*               ,:CX-MTR-REF-NO                                           
MFA-TR*               ,:CX-REG-ID-NO                                            
MFA-TR*               ,:CX-CODE-TIME-PERIOD                                     
MFA-TR*               ,:CX-ITEM-SEQ-NO                                          
MFA-TR*               ,:CX-CODE-USAGE-TYPE                                      
MFA-TR*               ,:CX-CODE-USAGE-ID                                        
MFA-TR*               ,:CX-CODE-USAGE-SOURCE                                    
MFA-TR*               ,:CX-METER-NO                                             
MFA-TR*               ,:CX-DATE-READ                                            
MFA-TR*               ,:CX-CODE-METER-READ                                      
MFA-TR*               ,:CX-CODE-METER-NO-READ                                   
MFA-TR*               ,:CX-METER-READING                                        
MFA-TR*               ,:CX-DEMAND-READING                                       
MFA-TR*               ,:CX-EMPLOYEE-NO                                          
MFA-TR*               ,:CX-NO-UNITS                                             
MFA-TR*               ,:CX-NO-DEMAND-UNITS                                      
MFA-TR*               ,:CX-NO-DAYS                                              
MFA-TR*               ,:CX-CODE-SOURCE-ID                                       
MFA-TR*               ,:CX-CODE-DEBIT-CREDIT                                    
MFA-TR*               ,:CX-CODE-ITEM-STATUS                                     
MFA-TR*               ,:CX-CODE-DISCOUNT                                        
MFA-TR*               ,:CX-CONSTANT                                             
MFA-TR*               ,:CX-NO-DIALS                                             
MFA-TR*               ,:CX-COMPANY-NO                                           
MFA-TR*               ,:CX-EXCEPT-OVERRIDE-CD                                   
MFA-TR*               ,:CX-REQUESTED-USAGE                                      
MFA-TR*               ,:CX-DIGTL-INTRL-MTR-NO                                   
MFA-TR*               ,:CX-DIGTL-MTR-TYPE                                       
MFA-TR*               ,:CX-CODE-TOU-SEASN                                       
MFA-TR*               ,:CX-EXCL-DMD-RCHT-IND )                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27405*                                                                         
C27405     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
C27405     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C27405         CONTINUE                                                 
C27405     ELSE                                                         
C27405         DISPLAY '**  ERROR ON 8020-INSERT-CX-DETAILS       **'   
C27405         DISPLAY '**  COULD NOT INSERT IN CSS_CNSMPTN_HIST  **'   
C27405         DISPLAY '**  RETURN CODE    = ' WS-ACTIVE-RETURN-CODE    
C27405         DISPLAY '**  ACCOUNT-NO     = ' CX-ACCOUNT-NO            
C27405         PERFORM 9900-ABEND                THRU 9900-EXIT         
C27405     END-IF.                                                      
C27405*                                                                         
C27405 8020-EXIT.                                                       
C27405     EXIT.                                                        
C29815*                                                                         
C29815******************************************************************        
C29815* 8440-JRNL-CIA-EPP.                                             *        
C29815******************************************************************        
C29815*                                                                         
C29815 8440-JRNL-CIA-EPP.                                               
C29815*                                                                         
C29815     MOVE '01'                     TO WS-JRNL-BT-BAT-COMPANY      
C29815     MOVE '098'                    TO WS-JRNL-BT-BAT-LOC-OFF      
C29815                                      WS-JRNL-BT-BAT-REPORT-NO    
C29815     MOVE WS-INPUT-DATE            TO WS-JRNL-BT-BAT-REPORT-DT    
C29815     MOVE 9999                     TO WS-JRNL-BT-BAT-CASH-DRWR    
C29815     MOVE WS-JRNL-VALIDATE-OPER       TO WS-JRNL-OPERATION-RQST   
C29815     MOVE WS-C                        TO WS-JRNL-SOURCE-CODE      
           PERFORM 7010-SELECT-ACT-PREM-DET                             
                                           THRU 7010-EXIT.              
C29815     MOVE WS-JRNL-CASH-UPDATE         TO WS-JRNL-OL-AUTH-TYPE     
C29815     MOVE WS-JRNL-SELECT-AND-OR-INS TO WS-JRNL-OPERATION-RQST     
C29815*                                                                         
C29815     PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
C29815*                                                                         
C29815     MOVE AT-ACCOUNT-NO              TO AU-ACCOUNT-NO.            
C29815     MOVE 0                          TO AU-TRAN-APPL-NO.          
C29815     MOVE WS-01                      TO AU-ITEM-ID.               
C29815     MOVE WS-A                       TO AR-CODE-TRAN-TYPE.        
C29815     MOVE WS-EPP-CIA-ADJ             TO AR-APPL-PROGRAM-ID.       
C29815     MOVE +0                         TO AR-TRAN-COMMENT-LEN.      
C29815     MOVE SPACES                     TO AR-TRAN-COMMENT-TEXT.     
C29815     MOVE '0'                        TO AU-CODE-AR-AGE.           
C29815     MOVE SPACES                     TO AU-CODE-CONTRACT-TYPE     
C29815                                        AU-CURRENCY-TYPE.         
C29815     MOVE 0                         TO AU-CURRENCY-AMT.           
C29815                                                                  
C29815     ADD +1                          TO AU-TRAN-APPL-NO.          
C29815                                                                  
C29815     IF  AU-TRAN-APPL-NO = 1                                      
C29815         PERFORM 7050-SELECT-TIMESTAMP                            
C29815                                     THRU 7050-EXIT               
C29815         MOVE WS-CURRENT-TIMESTAMP   TO AR-TRANS-HIST-SEQ-NO      
C29815                                        AU-TRANS-HIST-SEQ-NO      
C29815     END-IF.                                                      
C29815*                                                                         
C29815     IF  WS-AMT-UNUSED-CR-EPP < 0                                 
C29815        COMPUTE WS-AMT-UNUSED-CR-EPP =                            
C29815                    WS-AMT-UNUSED-CR-EPP * -1                     
C29815     END-IF.                                                      
C29815*                                                                         
C29815     MOVE AT-ACCOUNT-NO              TO AR-ACCOUNT-NO.            
C29815     MOVE WS-CURRENT-TIMESTAMP       TO AR-TRANS-HIST-SEQ-NO.     
C29815     MOVE AT-COMPANY-NO              TO AR-COMPANY-NO.            
C29815     MOVE WS-A                       TO AR-CODE-TRAN-TYPE.        
C29815     MOVE SPACES                     TO AR-DATE-ORIG-PYMT.        
C29815     MOVE -1                         TO WS-DATE-ORIG-PYMT-IND.    
C29815     MOVE WS-CURRENT-DATE            TO AR-DATE-TRANS             
C29815                                        AR-DATE-CASH-REPORT.      
C29815     MOVE SPACES                     TO AR-PYMT-FACILITY-CD.      
C29815     MOVE WS-N                       TO AR-RECORD-ONLY-FL.        
C29815     MOVE 'SYSTEM'                   TO AR-USER-ID.               
C29815     MOVE SPACES                     TO AR-RESP-AREA-ID.          
C29815     MOVE +0                         TO AR-TRAN-COMMENT-LEN.      
C29815     MOVE SPACES                     TO AR-TRAN-COMMENT-TEXT.     
C29815     MOVE '01'                       TO AR-CASH-COMPANY-NO.       
C29815     MOVE '998'                      TO AR-CASH-LOCAL-OFFICE.     
C29815     MOVE '998'                      TO AR-CASH-REPORT-NO.        
C29815     MOVE +9999                      TO AR-CASH-DRAWER-ID.        
ACT036     PERFORM 8450-GET-AMT-BILLED-UNPAID THRU 8450-EXIT.           
ACT036     COMPUTE AR-AMT-BILLED-UNPAID =                               
ACT036             WS-AMT-UNUSED-CR-EPP + WS-AMT-BILLED-UNPAID.         
C29815     MOVE WS-AMT-UNUSED-CR-EPP       TO AR-AMT-ORIG-ENTERED       
C29815                                        AU-AMT-POSTED             
C29815     MOVE SPACES                     TO AR-PYMT-REFUNDED-IND      
C29815                                        AR-PYMT-RCPT-PRNTD-CD.    
C29815*                                                                         
C29815                                                                  
C29815     MOVE WS-AR-BUD-GL-NO            TO AU-GL-ACCT-CREDIT         
C29815                                        WS-101-ACCT-GEN-LED-CR    
C29815     MOVE WS-AR-CIA-GL-NO            TO AU-GL-ACCT-DEBIT          
C29815                                        WS-101-ACCT-GEN-LED-DR    
C29815*                                                                         
C29815     MOVE WS-AMT-UNUSED-CR-EPP       TO WS-101-AMT-POSTED         
C29815                                        WS-JRNL-RCV-DEBIT-AMT     
C29815                                        WS-JRNL-RCV-CREDIT-AMT.   
C29815     MOVE WS-AMT-UNUSED-CR-EPP       TO WS-101-AMOUNT-ENTERED.    
C29815     MOVE WS-TOTAL-AR-BALANCE   TO WS-101-ACCT-END-AR-BAL.        
C29815     MOVE  ZEROES                    TO WS-101-AR-AGE.            
C29815     MOVE WS-CURRENT-DATE            TO WS-101-DATE-AR-BILLED.    
C29815     MOVE 0                          TO WS-101-ITEM-ID-NO.        
C29815*                                                                         
C29815     IF AC-PYMT-PRIORITY-LVL < WS-50                              
C29815        MOVE 0                       TO WS-101-DETAIL-END-AR-BAL  
C29815                                        WS-101-DETAIL-END-BAL     
C29815     ELSE                                                         
C29815        MOVE AC-AMT-TRAN-BALANCE     TO WS-101-DETAIL-END-BAL     
C29815        COMPUTE WS-101-DETAIL-END-AR-BAL = AC-AMT-AR-DAY-00 +     
C29815                                           AC-AMT-AR-DAY-30 +     
C29815                                           AC-AMT-AR-DAY-60 +     
C29815                                           AC-AMT-AR-DAY-90       
C29815     END-IF.                                                      
C29815                                                                  
C29815     MOVE SPACES                     TO WS-101-FUNCTION-CODE.     
C29815     MOVE PR-REV-DISTRICT-CD         TO                           
C29815                                   WS-101-CODE-REVENUE-DISTRICT.  
C29815     MOVE CU-CODE-EMPL-ACCT          TO WS-101-CODE-EMPL-ACCT.    
C29815     MOVE AT-CODE-COMPANY-ACCT       TO WS-101-CODE-COMPANY-ACCT. 
C29815     MOVE AT-CODE-ACCT-STAT          TO                           
C29815                                   WS-101-CODE-ACCOUNT-STATUS.    
C29815     MOVE PR-CODE-PREMISE-STAT       TO                           
C29815                                   WS-101-CODE-PREMISE-STATUS.    
C29815     MOVE 101                        TO WS-101-JRNL-FORMAT-NO.    
C29815     MOVE SPACES                     TO WS-101-CASH-DRAWER-USED.  
C29815     MOVE WS-B                       TO WS-JRNL-SOURCE-CODE.      
C29815                                                                  
C29815     MOVE WS-JRNL-ONLY               TO WS-JRNL-OPERATION-RQST.   
C29815     MOVE CJF00101                   TO WS-100-USER-DEFINED-AREA. 
C29815     PERFORM 6400-ONLINE-JRNL-ROUTINE                             
C29815                                     THRU 6400-EXIT.              
C29815     IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
C29815        MOVE 'Y'                     TO WS-JRNL-WRITTEN           
C29815     ELSE                                                         
C29815         DISPLAY '********** CPD00317  ABORT **************'      
C29815         DISPLAY '* 5813-JRNL-ADJ                        *'       
C29815         DISPLAY '* USERABEND                            *'       
C29815         DISPLAY '* PROGRAM ABORTING...                  *'       
C29815         DISPLAY '********** CPD00317  ABORT **************'      
C29815         PERFORM 9900-ABEND          THRU 9900-EXIT               
C29815     END-IF.                                                      
C29815*                                                                         
C29815     PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST                        
C29815                                     THRU 6500-EXIT.              
C29815                                                                  
BC0895     MOVE WS-JRNL-CNTRL-ONLY        TO WS-JRNL-OPERATION-RQST     
C29815     PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
C29815*                                                                         
C29815 8440-EXIT.                                                       
C29815     EXIT.                                                        
                                                                        
ACT036******************************************************************        
      * GET LATEST AMT-BILLED-UNPAID                                            
      ******************************************************************        
       8450-GET-AMT-BILLED-UNPAID.                                      
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) AMT_BILLED_UNPAID                                  
                INTO :AR-AMT-BILLED-UNPAID                              
                FROM CSS_AR_TRANS_HIST                                  
               WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
              ORDER BY TRANS_HIST_SEQ_NO DESC                           
                                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_BILLED_UNPAID                                          
MFA-TR*         INTO :AR-AMT-BILLED-UNPAID                                      
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*        WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                            
MFA-TR*       ORDER BY TRANS_HIST_SEQ_NO DESC                                   
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       QUERYNO 6350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              MOVE AR-AMT-BILLED-UNPAID TO WS-AMT-BILLED-UNPAID         
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE ZEROS                TO WS-AMT-BILLED-UNPAID       
             ELSE                                                       
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 8450-GET-AMT-BILLED-UNPAID    *'              
               DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                   
               DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO        
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
             END-IF                                                     
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
ACT036      EXIT.                                                       
A00755*                                                                         
A00755******************************************************************        
A00755* 8650-UPDATE-BUDGET-HIST.                                       *        
A00755******************************************************************        
A00755*                                                                         
A00755 8650-UPDATE-BUDGET-HIST.                                         
A00755*                                                                         
A00755     EXEC SQL                                                     
A00755       UPDATE CSS_BUDGET_HIST                                     
A00755          SET                                                     
A00755               DATE_PYMT_STRT    = IIF(TRY_CONVERT(DATE, 
                                                     :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )             
A00755              ,EPP_MTHS_RMNG_QT  = :BH-EPP-MTHS-RMNG-QT           
A00755              ,LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
A00755              ,REMARKS           = :BH-REMARKS                    
P00794              ,LAST_UPDATE_USERID = :BH-LAST-UPDATE-USERID        
A00755        WHERE                                                     
A00755               ACCOUNT_NO        = :BH-ACCOUNT-NO                 
A00755          AND  PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL          
A00755          AND  ITEM_ID           = :BH-ITEM-ID                    
A00755          AND  BUD_HIST_SEQ_NO   = CIS.CHAR2TIMESTAMP(
                                                    :BH-BUD-HIST-SEQ-NO
              )            
A00755     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_BUDGET_HIST                                             
MFA-TR*         SET                                                             
MFA-TR*              DATE_PYMT_STRT    = :BH-DATE-PYMT-STRT                     
MFA-TR*             ,EPP_MTHS_RMNG_QT  = :BH-EPP-MTHS-RMNG-QT                   
MFA-TR*             ,LAST_UPDATE_TS    = :WS-CURRENT-TIMESTAMP                  
MFA-TR*             ,REMARKS           = :BH-REMARKS                            
MFA-TR*             ,LAST_UPDATE_USERID = :BH-LAST-UPDATE-USERID                
MFA-TR*       WHERE                                                             
MFA-TR*              ACCOUNT_NO        = :BH-ACCOUNT-NO                         
MFA-TR*         AND  PYMT_PRIORITY_LVL = :BH-PYMT-PRIORITY-LVL                  
MFA-TR*         AND  ITEM_ID           = :BH-ITEM-ID                            
MFA-TR*         AND  BUD_HIST_SEQ_NO   = :BH-BUD-HIST-SEQ-NO                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00755                                                                  
A00755     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00755                                                                  
A00755     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00755        CONTINUE                                                  
A00755     ELSE                                                         
A00755        DISPLAY '********** PCSCA099 ABORT **************'        
A00755        DISPLAY '* 8650-UPDATE-BUDGET-HIST              *'        
A00755        DISPLAY '* ACCOUNT_NO  = ', WS-ACCOUNT-NO                 
A00755        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A00755        DISPLAY '* PROGRAM ABORTING...                  *'        
A00755        DISPLAY '********** PCSCA099 ABORT **************'        
A00755        PERFORM 9900-ABEND           THRU 9900-EXIT               
A00755     END-IF.                                                      
A00755*                                                                         
A00755 8650-EXIT.                                                       
A00755     EXIT.                                                        
A00755*                                                                         
A00755******************************************************************        
A00755* 8700-INSERT-BUDGET-HIST.                                       *        
A00755******************************************************************        
A00755*                                                                         
A00755 8700-INSERT-BUDGET-HIST.                                         
A00755*                                                                         
A00755     EXEC SQL                                                     
A00755         INSERT INTO CSS_BUDGET_HIST                              
A00755                ( ACCOUNT_NO                                      
A00755                 ,PYMT_PRIORITY_LVL                               
A00755                 ,ITEM_ID                                         
A00755                 ,BUD_HIST_SEQ_NO                                 
A00755                 ,AMT_MO_PYMT                                     
A00755                 ,DATE_PYMT_STRT                                  
A00755                 ,UTILITY_BALANCE                                 
A00755                 ,BALANCE_FORWARD                                 
A00755                 ,EPP_ESTIMATE                                    
A00755                 ,EPP_MTHS_RMNG_QT                                
A00755                 ,METHOD_OF_ESTIMATE                              
A00755                 ,CHANGE_REASON                                   
A00755                 ,LAST_UPDATE_TS                                  
A00755                 ,REMARKS                                         
P00794                 ,LAST_UPDATE_USERID)                             
A00755         VALUES ( :BH-ACCOUNT-NO                                  
A00755                 ,:BH-PYMT-PRIORITY-LVL                           
A00755                 ,:BH-ITEM-ID                                     
A00755                 ,CIS.CHAR2TIMESTAMP(:BH-BUD-HIST-SEQ-NO)                 
A00755                 ,:BH-AMT-MO-PYMT                                 
A00755                 ,IIF(TRY_CONVERT(DATE, :BH-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BH-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BH-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BH-DATE-PYMT-STRT
              ), CONVERT(DATE, :BH-DATE-PYMT-STRT) )                           
A00755                 ,:BH-UTILITY-BALANCE                             
A00755                 ,:BH-BALANCE-FORWARD                             
A00755                 ,:BH-EPP-ESTIMATE                                
A00755                 ,:BH-EPP-MTHS-RMNG-QT                            
A00755                 ,:BH-METHOD-OF-ESTIMATE                          
A00755                 ,:BH-CHANGE-REASON                               
A00755                 ,CIS.CHAR2TIMESTAMP(:BH-LAST-UPDATE-TS)                  
A00755                 ,:BH-REMARKS                                     
P00794                 ,:BH-LAST-UPDATE-USERID)                         
A00755     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BUDGET_HIST                                      
MFA-TR*               ( ACCOUNT_NO                                              
MFA-TR*                ,PYMT_PRIORITY_LVL                                       
MFA-TR*                ,ITEM_ID                                                 
MFA-TR*                ,BUD_HIST_SEQ_NO                                         
MFA-TR*                ,AMT_MO_PYMT                                             
MFA-TR*                ,DATE_PYMT_STRT                                          
MFA-TR*                ,UTILITY_BALANCE                                         
MFA-TR*                ,BALANCE_FORWARD                                         
MFA-TR*                ,EPP_ESTIMATE                                            
MFA-TR*                ,EPP_MTHS_RMNG_QT                                        
MFA-TR*                ,METHOD_OF_ESTIMATE                                      
MFA-TR*                ,CHANGE_REASON                                           
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,REMARKS                                                 
MFA-TR*                ,LAST_UPDATE_USERID)                                     
MFA-TR*        VALUES ( :BH-ACCOUNT-NO                                          
MFA-TR*                ,:BH-PYMT-PRIORITY-LVL                                   
MFA-TR*                ,:BH-ITEM-ID                                             
MFA-TR*                ,:BH-BUD-HIST-SEQ-NO                                     
MFA-TR*                ,:BH-AMT-MO-PYMT                                         
MFA-TR*                ,:BH-DATE-PYMT-STRT                                      
MFA-TR*                ,:BH-UTILITY-BALANCE                                     
MFA-TR*                ,:BH-BALANCE-FORWARD                                     
MFA-TR*                ,:BH-EPP-ESTIMATE                                        
MFA-TR*                ,:BH-EPP-MTHS-RMNG-QT                                    
MFA-TR*                ,:BH-METHOD-OF-ESTIMATE                                  
MFA-TR*                ,:BH-CHANGE-REASON                                       
MFA-TR*                ,:BH-LAST-UPDATE-TS                                      
MFA-TR*                ,:BH-REMARKS                                             
MFA-TR*                ,:BH-LAST-UPDATE-USERID)                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00755                                                                  
A00755     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00755                                                                  
A00755     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00755        CONTINUE                                                  
A00755     ELSE                                                         
A00755        DISPLAY '********** PCSCA099 ABORT **************'        
A00755        DISPLAY '* 8700-INSERT-BUDGET-HIST              *'        
A00755        DISPLAY '* ACCOUNT_NO  = ', WS-ACCOUNT-NO                 
A00755        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A00755        DISPLAY '* PROGRAM ABORTING...                  *'        
A00755        DISPLAY '********** PCSCA099 ABORT **************'        
A00755        PERFORM 9900-ABEND           THRU 9900-EXIT               
A00755     END-IF.                                                      
A00755*                                                                         
A00755 8700-EXIT.                                                       
A00755     EXIT.                                                        
A00755*                                                                         
A00755******************************************************************        
A00755* 8750-UPDATE-BUDGET-PLAN.                                       *        
A00755******************************************************************        
A00755*                                                                         
A00755 8750-UPDATE-BUDGET-PLAN.                                         
A00755*                                                                         
A00755     EXEC SQL                                                     
A00755        UPDATE CSS_BUDGET_PLAN                                    
A00755           SET DATE_PYMT_STRT    = IIF(TRY_CONVERT(DATE, 
                                                     :BU-DATE-PYMT-STRT
              ) IS NULL OR (PATINDEX('%.%', :BU-DATE-PYMT-STRT
              ) <> 0) OR (LEN(:BU-DATE-PYMT-STRT
              ) <> 10), CIS.CHAR2DATE(:BU-DATE-PYMT-STRT
              ), CONVERT(DATE, :BU-DATE-PYMT-STRT) )             
A00755              ,ANNIVERSARY_DATE  = IIF(TRY_CONVERT(DATE, 
                                                   :BU-ANNIVERSARY-DATE
              ) IS NULL OR (PATINDEX('%.%', :BU-ANNIVERSARY-DATE
              ) <> 0) OR (LEN(:BU-ANNIVERSARY-DATE
              ) <> 10), CIS.CHAR2DATE(:BU-ANNIVERSARY-DATE
              ), CONVERT(DATE, :BU-ANNIVERSARY-DATE) )           
A00755              ,LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                     :BU-LAST-UPDATE-TS
              )             
A00755         WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                 
A00755     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BUDGET_PLAN                                            
MFA-TR*          SET DATE_PYMT_STRT    = :BU-DATE-PYMT-STRT                     
MFA-TR*             ,ANNIVERSARY_DATE  = :BU-ANNIVERSARY-DATE                   
MFA-TR*             ,LAST_UPDATE_TS    = :BU-LAST-UPDATE-TS                     
MFA-TR*        WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00755                                                                  
A00755     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00755                                                                  
A00755     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A00755        CONTINUE                                                  
A00755     ELSE                                                         
A00755        DISPLAY '********** PCSCA099 ABORT **************'        
A00755        DISPLAY '* 8750-UPDATE-BUDGET-HIST              *'        
A00755        DISPLAY '* ACCOUNT_NO  = ', WS-ACCOUNT-NO                 
A00755        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
A00755        DISPLAY '* PROGRAM ABORTING...                  *'        
A00755        DISPLAY '********** PCSCA099 ABORT **************'        
A00755        PERFORM 9900-ABEND           THRU 9900-EXIT               
A00755     END-IF.                                                      
A00755*                                                                         
A00755 8750-EXIT.                                                       
A00755     EXIT.                                                        
A00755*                                                                         
C37422******************************************************************        
C37422* 8897-CHECK-PREPAY-RCC.                                         *        
C37422******************************************************************        
C37422*                                                                         
C37422 8897-CHECK-PREPAY-RCC.                                           
C37422*                                                                         
C37422     EXEC SQL                                                     
C37422        SELECT DL.RECNCT_COLLECT_AMT                              
C37422              ,DL.DATETIME_SETUP                                  
C37422              ,AC.AMT_TRAN_BALANCE                                
C37422         INTO  :DL-RECNCT-COLLECT-AMT                             
C37422              ,:DL-DATETIME-SETUP                                 
C37422              ,:AC-AMT-TRAN-BALANCE                               
C37422          FROM CSS_RECONNECT DL WITH(READUNCOMMITTED)                     
C37422              ,CSS_AR_CNTL   AC WITH(READUNCOMMITTED)                     
C37422         WHERE DL.ACCOUNT_NO        = :DL-ACCOUNT-NO              
C37422           AND DL.ACCOUNT_NO        = AC.ACCOUNT_NO               
C37422           AND AC.PYMT_PRIORITY_LVL = 60                          
C37422           AND AC.AMT_TRAN_BALANCE < 0                            
C37422           AND AC.ITEM_ID= ( SELECT MAX(ITEM_ID) FROM             
C37422                             CSS_AR_CNTL WITH(READUNCOMMITTED)            
C37422                             WHERE ACCOUNT_NO = :DL-ACCOUNT-NO    
C37422                             AND AC.PYMT_PRIORITY_LVL = 60        
C37422                             AND ITEM_ID      > 0)         
A00755                                                      
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DL.RECNCT_COLLECT_AMT                                      
MFA-TR*             ,DL.DATETIME_SETUP                                          
MFA-TR*             ,AC.AMT_TRAN_BALANCE                                        
MFA-TR*        INTO  :DL-RECNCT-COLLECT-AMT                                     
MFA-TR*             ,:DL-DATETIME-SETUP                                         
MFA-TR*             ,:AC-AMT-TRAN-BALANCE                                       
MFA-TR*         FROM CSS_RECONNECT DL                                           
MFA-TR*             ,CSS_AR_CNTL   AC                                           
MFA-TR*        WHERE DL.ACCOUNT_NO        = :DL-ACCOUNT-NO                      
MFA-TR*          AND DL.ACCOUNT_NO        = AC.ACCOUNT_NO                       
MFA-TR*          AND AC.PYMT_PRIORITY_LVL = 60                                  
MFA-TR*          AND AC.AMT_TRAN_BALANCE < 0                                    
MFA-TR*          AND AC.ITEM_ID= ( SELECT MAX(ITEM_ID) FROM                     
MFA-TR*                            CSS_AR_CNTL                                  
MFA-TR*                            WHERE ACCOUNT_NO = :DL-ACCOUNT-NO            
MFA-TR*                            AND AC.PYMT_PRIORITY_LVL = 60                
MFA-TR*                            AND ITEM_ID      > 0) WITH UR                
MFA-TR*        QUERYNO 8897                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37422     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C37422         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
C37422            MOVE 'Y'              TO WS-RCC-EXIST                 
C37422         ELSE                                                     
C37422            MOVE 'N'              TO WS-RCC-EXIST                 
C37422         END-IF                                                   
C37422     ELSE                                                         
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        DISPLAY '*      8897-CHECK-PREPAY-RCC           *'        
C37422        DISPLAY '* ACCOUNT NO          ', DL-ACCOUNT-NO           
C37422        DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO         
C37422        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
C37422        DISPLAY '* PROGRAM ABORTING...                  *'        
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        PERFORM 9900-ABEND              THRU 9900-EXIT            
C37422     END-IF.                                                      
C37422*                                                                         
C37422 8897-EXIT.                                                       
C37422     EXIT.                                                        
C37422*                                                                         
C37422******************************************************************        
C37422* 8898-CHECK-FOR-FCTRROW.                                        *        
C37422******************************************************************        
C37422*                                                                         
C37422 8898-CHECK-FOR-FCTRROW.                                          
C37422*                                                                         
C37422     EXEC SQL                                                     
C37422        SELECT TOP(1) 'Y'                                                
C37422         INTO  :WS-FCTRROW-EXIST                                  
C37422          FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
C37422         WHERE ACCOUNT_NO       = :FF-ACCOUNT-NO                  
C37422           AND CODE_UTIL_TYPE   = 'G'                             
C37422           AND FACTOR_ID        = 'RECCHGTAX'                     
C37422           AND LAST_UPDATE_TS   = CIS.CHAR2TIMESTAMP(
                                                     :FF-LAST-UPDATE-TS
              )              
C37422                                            
C37422                                                           
A00755                                                      
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*        INTO  :WS-FCTRROW-EXIST                                          
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE ACCOUNT_NO       = :FF-ACCOUNT-NO                          
MFA-TR*          AND CODE_UTIL_TYPE   = 'G'                                     
MFA-TR*          AND FACTOR_ID        = 'RECCHGTAX'                             
MFA-TR*          AND LAST_UPDATE_TS   = :FF-LAST-UPDATE-TS                      
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 8898                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37422     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C37422         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
C37422            MOVE 'Y'              TO WS-FCTRROW-EXIST             
C37422         ELSE                                                     
C37422            MOVE 'N'              TO WS-FCTRROW-EXIST             
C37422         END-IF                                                   
C37422     ELSE                                                         
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        DISPLAY '*      8898-CHECK-FOR-FCTRROW          *'        
C37422        DISPLAY '* ACCOUNT NO           ', AR-ACCOUNT-NO          
C37422        DISPLAY '* DB07 ACCOUNT NUMBER  ', WS-DB07-ACCT-NO        
C37422        DISPLAY '* LAST UPDATE TIMESTAMP', FF-LAST-UPDATE-TS      
C37422        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
C37422        DISPLAY '* PROGRAM ABORTING...                  *'        
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        PERFORM 9900-ABEND              THRU 9900-EXIT            
C37422     END-IF.                                                      
C37422*                                                                         
C37422 8898-EXIT.                                                       
C37422     EXIT.                                                        
C37422*                                                                         
C37422******************************************************************        
C37422* 8899-GET-UTIL-ENV.                                             *        
C37422******************************************************************        
C37422*                                                                         
C37422 8899-GET-UTIL-ENV.                                               
C37422*                                                                         
C37422     EXEC SQL                                                     
C37422        SELECT TOP(1) IC_NO,
              CODE_UTIL_TYPE                                     
C37422         INTO  :UT-IC-NO,                                         
C37422               :UT-CODE-UTIL-TYPE                                 
C37422          FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
C37422         WHERE ACCOUNT_NO       = :UT-ACCOUNT-NO                  
C37422                                            
C37422                                                           
A00755                                                      
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IC_NO,                                                     
MFA-TR*              CODE_UTIL_TYPE                                             
MFA-TR*        INTO  :UT-IC-NO,                                                 
MFA-TR*              :UT-CODE-UTIL-TYPE                                         
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE ACCOUNT_NO       = :UT-ACCOUNT-NO                          
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 8899                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37422     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C37422         MOVE UT-IC-NO           TO FF-IC-NO                      
C37422         MOVE UT-CODE-UTIL-TYPE  TO FF-CODE-UTIL-TYPE             
C37422     ELSE                                                         
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        DISPLAY '*      8899-GET-UTIL-ENV               *'        
C37422        DISPLAY '* ACCOUNT NO          ', UT-ACCOUNT-NO           
C37422        DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO         
C37422        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
C37422        DISPLAY '* PROGRAM ABORTING...                  *'        
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        PERFORM 9900-ABEND              THRU 9900-EXIT            
C37422     END-IF.                                                      
C37422*                                                                         
C37422 8899-EXIT.                                                       
C37422     EXIT.                                                        
C37422*                                                                         
C37422******************************************************************        
C37422* 8900-GET-MIN-REV-MO.                                           *        
C37422******************************************************************        
C37422*                                                                         
C37422 8900-GET-MIN-REV-MO.                                             
C37422*                                                                         
C37422     EXEC SQL                                                     
C37422         SELECT MIN(REVENUE_MONTH)                                
C37422           INTO :BN-REVENUE-MONTH                                 
C37422           FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                  
C37422          WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )                 
C37422                                                           
A00755                                                      
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MIN(REVENUE_MONTH)                                        
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE BN.DATE_EXTRACT = :WS-COMMON-DATE                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 8900                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37422     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C37422        MOVE BN-REVENUE-MONTH     TO WS-REVENUE-MONTH-1           
C37422        MOVE WS-REVMTH-CCYY       TO WS-EFF-DATE-FROM-YYYY        
C37422        MOVE WS-REVMTH-MM         TO WS-EFF-DATE-FROM-MM          
C37422     ELSE                                                         
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        DISPLAY '*      8900-GET-MIN-REV-MO             *'        
C37422        DISPLAY '* DATE EXTRACT IS     ', WS-CURRENT-DATE         
C37422        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
C37422        DISPLAY '* PROGRAM ABORTING...                  *'        
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        PERFORM 9900-ABEND              THRU 9900-EXIT            
C37422     END-IF.                                                      
C37422*                                                                         
C37422 8900-EXIT.                                                       
C37422     EXIT.                                                        
C37422*                                                                         
C37422******************************************************************        
C37422* 8910-GET-MAX-SEQ-NO.                                                    
C37422******************************************************************        
C37422 8910-GET-MAX-SEQ-NO.                                             
C37422                                                                  
C37422     EXEC SQL                                                     
A00755         SELECT COALESCE (MAX(FIXED_FCTR_SEQ_NO),0)               
A00755           INTO :FF-FIXED-FCTR-SEQ-NO                             
C37422           FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
C37422          WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            
C37422            AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE        
C37422            AND FF.IC_NO              = :FF-IC-NO                 
C37422                                                           
A00755                                                      
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COALESCE (MAX(FIXED_FCTR_SEQ_NO),0)                       
MFA-TR*          INTO :FF-FIXED-FCTR-SEQ-NO                                     
MFA-TR*          FROM CSS_FIXED_FCTR FF                                         
MFA-TR*         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                    
MFA-TR*           AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                
MFA-TR*           AND FF.IC_NO              = :FF-IC-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 8910                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37422                                                                  
C37422     EVALUATE WS-ACTIVE-RETURN-CODE                               
C37422         WHEN SUCCESSFUL-CALL                                     
C37422         WHEN NOT-FOUND                                           
A00755              CONTINUE                                            
C37422         WHEN OTHER                                               
C37422          DISPLAY '********** PCSCA099 ABORT **************'      
C37422          DISPLAY '*      8910-GET-MAX-SEQ-NO             *'      
C37422          DISPLAY '* ACCOUNT NO          ', FF-ACCOUNT-NO         
C37422          DISPLAY '* IC NO               ', FF-IC-NO              
C37422          DISPLAY '* CODE UTIL TYPE      ', FF-CODE-UTIL-TYPE     
C37422          DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO       
C37422          DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE 
C37422          DISPLAY '* PROGRAM ABORTING...                  *'      
C37422          DISPLAY '********** PCSCA099 ABORT **************'      
C37422          PERFORM 9900-ABEND              THRU 9900-EXIT          
C37422     END-EVALUATE.                                                
C37422                                                                  
C37422 8910-EXIT.                                                       
C37422     EXIT.                                                        
C37422*****************************************************************         
C37422* 8920-INSERT-FACTOR                                            *         
C37422*****************************************************************         
C37422 8920-INSERT-FACTOR.                                              
C37422                                                                  
C37422     EXEC SQL                                                     
C37422         INSERT INTO CSS_FIXED_FCTR                               
C37422                (ACCOUNT_NO        ,                              
C37422                 CODE_UTIL_TYPE    ,                              
C37422                 IC_NO             ,                              
C37422                 FIXED_FCTR_SEQ_NO ,                              
C37422                 FACTOR_ID         ,                              
C37422                 EFF_DATE_FROM     ,                              
C37422                 CMPNT_ID_CD       ,                              
C37422                 CODE_SEASON       ,                              
C37422                 INSTR_USE_TYPE_CD ,                              
C37422                 CODE_TIME_PERIOD  ,                              
C37422                 EFF_DATE_TO       ,                              
C37422                 FIXED_FCTR_TYP_CD ,                              
C37422                 FACTOR            ,                              
C37422                 FAC_CHRG_BASE_AM  ,                              
C37422                 LAST_UPDATE_TS    ,                              
C37422                 DURATION_REMAIN_NO,                              
C37422                 RT_PKG_OPT_SEQ_NO)                               
C37422         VALUES                                                   
C37422                (:FF-ACCOUNT-NO       ,                           
C37422                 :FF-CODE-UTIL-TYPE   ,                           
C37422                 :FF-IC-NO            ,                           
C37422                 :FF-FIXED-FCTR-SEQ-NO,                           
C37422                 :FF-FACTOR-ID        ,                           
C37422                 IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )    ,                       
C37422                 :FF-CMPNT-ID-CD      ,                           
C37422                 :FF-CODE-SEASON      ,                           
C37422                 :FF-INSTR-USE-TYPE-CD,                           
C37422                 :FF-CODE-TIME-PERIOD ,                           
C37422                 IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )      ,                       
C37422                 :FF-FIXED-FCTR-TYP-CD,                           
C37422                 :FF-FACTOR           ,                           
C37422                 :FF-FAC-CHRG-BASE-AM ,                           
C37422                 CIS.CHAR2TIMESTAMP(:FF-LAST-UPDATE-TS)   ,               
C37422                 :FF-DURATION-REMAIN-NO :WS-NULL-VALUE,           
C37422                 :FF-RT-PKG-OPT-SEQ-NO)                           
C37422                                                                  
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIXED_FCTR                                       
MFA-TR*               (ACCOUNT_NO        ,                                      
MFA-TR*                CODE_UTIL_TYPE    ,                                      
MFA-TR*                IC_NO             ,                                      
MFA-TR*                FIXED_FCTR_SEQ_NO ,                                      
MFA-TR*                FACTOR_ID         ,                                      
MFA-TR*                EFF_DATE_FROM     ,                                      
MFA-TR*                CMPNT_ID_CD       ,                                      
MFA-TR*                CODE_SEASON       ,                                      
MFA-TR*                INSTR_USE_TYPE_CD ,                                      
MFA-TR*                CODE_TIME_PERIOD  ,                                      
MFA-TR*                EFF_DATE_TO       ,                                      
MFA-TR*                FIXED_FCTR_TYP_CD ,                                      
MFA-TR*                FACTOR            ,                                      
MFA-TR*                FAC_CHRG_BASE_AM  ,                                      
MFA-TR*                LAST_UPDATE_TS    ,                                      
MFA-TR*                DURATION_REMAIN_NO,                                      
MFA-TR*                RT_PKG_OPT_SEQ_NO)                                       
MFA-TR*        VALUES                                                           
MFA-TR*               (:FF-ACCOUNT-NO       ,                                   
MFA-TR*                :FF-CODE-UTIL-TYPE   ,                                   
MFA-TR*                :FF-IC-NO            ,                                   
MFA-TR*                :FF-FIXED-FCTR-SEQ-NO,                                   
MFA-TR*                :FF-FACTOR-ID        ,                                   
MFA-TR*                :FF-EFF-DATE-FROM    ,                                   
MFA-TR*                :FF-CMPNT-ID-CD      ,                                   
MFA-TR*                :FF-CODE-SEASON      ,                                   
MFA-TR*                :FF-INSTR-USE-TYPE-CD,                                   
MFA-TR*                :FF-CODE-TIME-PERIOD ,                                   
MFA-TR*                :FF-EFF-DATE-TO      ,                                   
MFA-TR*                :FF-FIXED-FCTR-TYP-CD,                                   
MFA-TR*                :FF-FACTOR           ,                                   
MFA-TR*                :FF-FAC-CHRG-BASE-AM ,                                   
MFA-TR*                :FF-LAST-UPDATE-TS   ,                                   
MFA-TR*                :FF-DURATION-REMAIN-NO :WS-NULL-VALUE,                   
MFA-TR*                :FF-RT-PKG-OPT-SEQ-NO)                                   
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37422                                                                  
C37422     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C37422        CONTINUE                                                  
C37422     ELSE                                                         
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        DISPLAY '*      8920-INSERT FACTOR              *'        
C37422        DISPLAY '* ACCOUNT NO          ', FF-ACCOUNT-NO           
C37422        DISPLAY '* IC NO               ', FF-IC-NO                
C37422        DISPLAY '* CODE UTIL TYPE      ', FF-CODE-UTIL-TYPE       
C37422        DISPLAY '* DB07 ACCOUNT NUMBER ', WS-DB07-ACCT-NO         
C37422        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
C37422        DISPLAY '* PROGRAM ABORTING...                  *'        
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        PERFORM 9900-ABEND              THRU 9900-EXIT            
C37422     END-IF.                                                      
C37422                                                                  
C37422 8920-EXIT.                                                       
C37422     EXIT.                                                        
C37422*                                                                         
C37422******************************************************************        
C37422* 8930-CHECK-FOR-MANUAL-ENTRY.                                   *        
C37422******************************************************************        
C37422*                                                                         
C37422 8930-CHECK-FOR-MANUAL-ENTRY.                                     
C37422*                                                                         
C37422     EXEC SQL                                                     
C37422        SELECT TOP(1) 'Y'                                                
C37422         INTO  :WS-FCTRROW-EXIST                                  
C37422          FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
C37422         WHERE ACCOUNT_NO                    = :FF-ACCOUNT-NO     
C37422           AND CODE_UTIL_TYPE                = 'G'                
C37422           AND FACTOR_ID                     = 'RECCHGTAX'        
C37422           AND DATEPART(MICROSECOND, LAST_UPDATE_TS)   > 0                
C37422           AND DURATION_REMAIN_NO            > 0                  
C37422                                            
C37422                                                           
A00755                                                      
C37422     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*        INTO  :WS-FCTRROW-EXIST                                          
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE ACCOUNT_NO                    = :FF-ACCOUNT-NO             
MFA-TR*          AND CODE_UTIL_TYPE                = 'G'                        
MFA-TR*          AND FACTOR_ID                     = 'RECCHGTAX'                
MFA-TR*          AND MICROSECOND(LAST_UPDATE_TS)   > 0                          
MFA-TR*          AND DURATION_REMAIN_NO            > 0                          
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 8930                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37422                                                                  
C37422     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C37422     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
C37422         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
C37422            MOVE 'Y'              TO WS-FCTRROW-EXIST             
C37422         ELSE                                                     
C37422            MOVE 'N'              TO WS-FCTRROW-EXIST             
C37422         END-IF                                                   
C37422     ELSE                                                         
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        DISPLAY '*      8930-CHECK-FOR-MANUAL-ENTRY     *'        
C37422        DISPLAY '* ACCOUNT NO           ', AR-ACCOUNT-NO          
C37422        DISPLAY '* DB07 ACCOUNT NUMBER  ', WS-DB07-ACCT-NO        
C37422        DISPLAY '* LAST UPDATE TIMESTAMP', FF-LAST-UPDATE-TS      
C37422        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
C37422        DISPLAY '* PROGRAM ABORTING...                  *'        
C37422        DISPLAY '********** PCSCA099 ABORT **************'        
C37422        PERFORM 9900-ABEND              THRU 9900-EXIT            
C37422     END-IF.                                                      
C37422*                                                                         
C37422 8930-EXIT.                                                       
C37422     EXIT.                                                        
C37422*                                                                         
P00307***************************************************************           
P00307* 8940-DELETE-ACCT-ATTR.                                      *           
P00307*                                                             *           
P00307* DELETE RECORD IN THE ACCT ATTRIBUTE TABLE.                  *           
P00307***************************************************************           
P00307 8940-DELETE-ACCT-ATTR.                                           
P00307                                                                  
P00307     MOVE '8940' TO ACTIVE-PARAGRAPH.                             
P00307                                                                  
P00307     EXEC SQL                                                     
P00307        DELETE FROM CSS_ACCT_ATTRIBUTE                            
P00307         WHERE ACCOUNT_NO        = :YP-ACCOUNT-NO                 
P00307           AND ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC             
P00307     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00307                                                                  
P00307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00307     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00307        NEXT SENTENCE                                             
P00307     ELSE                                                         
P00307        DISPLAY '********** PCSCA099 ABORT **************'        
P00307        DISPLAY '*      8940-DELETE-ACCT-ATTR           *'        
P00307        DISPLAY '* ACCOUNT NO           ', YP-ACCOUNT-NO          
P00307        DISPLAY '* DB07 ACCOUNT NUMBER  ', WS-DB07-ACCT-NO        
P00307        DISPLAY '* SQLCODE IS          ', WS-ACTIVE-RETURN-CODE   
P00307        DISPLAY '* PROGRAM ABORTING...                  *'        
P00307        DISPLAY '********** PCSCA099 ABORT **************'        
p00307        PERFORM 9900-ABEND              THRU 9900-EXIT            
P00307     END-IF.                                                      
P00307                                                                  
P00307 8940-EXIT.                                                       
P00307     EXIT.                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ******************************************************************        
      *  CLOSES  THE INPUT  FILE                                       *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSDB07-FILE                                           
      *                                                                         
           IF  FDB07-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'ERROR IN CLOSING FCSDB07-FILE'                  
               DISPLAY 'ERROR STATUS ' WS-FDB07-STATUS                  
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  WS-DB2-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' WS-DB2-PARAGRAPH
           END-IF.            
                                                                        
           IF  WS-DB2-FUNCTION > SPACES                                 
               DISPLAY '**  FUNCTION   = ' WS-DB2-FUNCTION
           END-IF.             
                                                                        
           IF  ACTIVE-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' ACTIVE-PARAGRAPH
           END-IF.            
                                                                        
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CPD0023B                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT                 *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
**************************** END OF PROGRAM ****************************        
