       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        PCSCA098.                                     
COB303 DATE-WRITTEN.      JANUARY 2, 2003.                              
       DATE-COMPILED.                                                   
      ******************************************************************00060000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM REVIEWS ACCOUNTS W/ PAID DEPOSITS TO DETERMINE   *        
      *  IF A REFUND IS DUE BECAUSE TOTAL PAID DEPOSITS IS GREATER THAN*        
      *  MAX DEPOSIT.                                                  *        
      *  UPDATES DEPOSIT-ON-HAND, REFUND HIST, MAX-DEP-REVIEW &        *00200000
      *  OTHER AR-JOURNAL DETAIL FOR THE REFUND OF DEPOSIT AMOUNT.     *00210000
      *  WHEN A WQ IS PRODUCED, A FILE WILL BE WRITTEN TO PRODUCE A    *        
      *  DAILY OVER-MAX WQ REGISTER REPORT.                            *        
      ******************************************************************00330000
      *                                                                *00340000
      *                     PROGRAM MODIFICATION LOG                   *00350000
      *                                                                *00360000
      *    DATE    INITIALS   COMMENTS                                 *00370000
      *  --------  --------   ---------------------------------------  *00380000
C25730*  01/03/03    MJ       COMPONENT ORIGINALLY CODED.              *00390000
      *              MJ       COMMIT AND RESTART LOGIC.                *        
C29752*  12/09/03    MJ       REMOVED REFERENCE TO WS-DATE-INT-CALC-FROM        
      *                       BECAUSE IT WAS NOT BEING USED AND SHOWED *        
      *                       ON SCANS.                                *        
C30980*  06/16/04    MJ       DO NOT GENERATE WQ FOR GOOD CREDIT.      *        
C33201*  09/14/05    SS82048  INCLUDE DCLGEN FOR CSS_REG_PROFILE       *        
      *                       FOR MAX DEPOSIT CALCULATION CHANGES.     *        
T33431** 03/16/06   SK88120        COG PROJECT CHANGES -                        
T33431**                           A- ADD NEW COPYBOOKS                         
T33431**                           B- CHANGE IN CPD00073                        
C32206** 08/23/06   AP40911  CHANGED THE NAME OF THE COPYBOOK CWS10000 *        
C32206**                     TO CWS1000A.                                       
T34097** 02/07/07   MC95456  REPLACED CSS_MODEL_SQL WITH SET STATEMENTS*        
A37061*  16/02/09   MC95456  REPLACED  CHECKING MIDDLE DIGIT FROM      *        
A37061*                      CODE_REV_CLASS OF CSS_UTIL_ENVRMT WITH    *        
A37061*                      ACCOUNT_TYPE_CODE OF CSS_ACCOUNT TABLE.   *        
A37061*                      ADDED WITH UR TO THE SINGLETON SELECTS    *        
P00172*  09/03/09   SP95538  REFUND THE DEPOSIT FOR SEB REGULATED      *        
P00172*                      CUSTOMERS IF ANY PAID DEPOSIT OVER THE    *        
P00172*                      MAX DEPOSIT.                              *        
A37302** 09/09/09   MC95456  REMOVED DCLGEN FOR CSS_RVC_ACCT           *        
P00172** 09/10/09   VP94820  FIXED -811 IN 7881- PARAGRAPH.            *        
P00172** 10/10/09   VP94820  ADDED BANKRUPTCY CHECK AND FIXED REFUND   *        
P00172**                     AMOUNT COMPUTATION.                       *        
A01731** 01/08/10   VP94820  CHANGED PARA 7150- TO SELECT 13 MONTHS    *        
A01731**                     BEFORE DATES.                             *        
A01731** 07/17/10   VP94820  USING INPUT-DATE FOR INTEREST CALCULATION *        
P00399** 08/02/10   MJ13662  REMOVE THE GOOD CREDIT RULES.  DEPOSITS   *        
P00399**                     WILL BE REFUNDED PRIOR TO THIS JOB.       *        
P00399**                     CHANGED SELECT TO RETRIEVE TRANSFERRED    *        
P00399**                     DEPOSIT AMOUNT ALSO.                      *        
P00394** 09/07/10   VP94820  USING INPUT-DATE FOR CHECKING ELIGIBILITY *        
A03808** 11/29/11   MC95456  REMOVED THE CODE TO UPDATE NULL VALUE TO  *        
A03808**                     THE FIELD WS-DATE-INTST-CALC-TO-NI        *        
A04064** 03/26/12   NS75440  UPDATE WS-CODE-DEP-ON-HAND ON CSS_ACCOUNT.*        
A04173** 05/22/2012 NS75440  TEMPORARILY STOP GENERATING WQ WHEN       *        
A04173**                     "PAID DEPOSIT = MAX DEPOSIT" FOR SEB.     *        
P00677** 06/13/2012 NS75440  ADDDED A NEW SELECT TO GET DHR FROM       *        
P00677**                     CSS_CUSTOMER TABLE AND EDITED WQ MESSAGES.*        
P00641** 06/27/2012 NS75440  REMOVED REFERENCE TO TBGLNAME             *        
P00641**                     "CSS_GL_ACCT_NAME".                       *        
P00677** 07/24/2012 NS75440  CHANGES TO ADD DEPOSIT TYPE OF 'RECONNECT'*        
P00677**                     FOR SEB CUSTOMERS.                        *        
A04776** 08/29/2013 AS7C117  REMOVED UNUSED COPYBOOKS CWS00068 AND     *        
A04776**                     CWS0068L                                  *        
A04776**                     REMOVED UNUSED DCLGENS                    *        
A04860** 02/28/2014 MR7E794  FIX THE JUNK ISSUE IN WQ MESSAGE AND      *        
A04860**                     LOAD DIRECTLY CSS_WQ_ITEMS INSTEAD                 
A04860**                     OF CSS_WQ_ITEMS_MF BY CALLING SUB                  
A04860**                     PROGRAM SCSCB077                                   
ACT109** 05/30/2014 BD09555  ADD CODE 'R' TO SELECT IN PARAGRAPH 7910.          
ACT109** 05/30/2014 A04880-ACT109                                               
ACT012** 01/21/2016 BD09555  REMOVE SYBASE COPYBOOKX A05460-ACT012              
ACT012** 01/21/2016 MR7E794  REMOVE UNUSED COPYBOOKS.                           
A05091** 01/23/2016 RB19957  ADDED TBATMISC WHICH IS NOW NEEDED        *        
A05091**                     IN CPD00308 FOR SEB SEASONAL FLAG.        *        
A04860** 02/26/2016 MS7M727  REPLACE CSS_WQ_ITEMS_MF TABLE WITH        *        
A04860**            ACT089   CSS_WQ_ITEMS TABLE                        *        
ACT294*  10/06/16   VIJAY    INITIALIZE INDEXES TO SUPPORT MFES.       *        
A05460** 10/21/2016 RS7V450  REMOVED THE FILE FCSRP098 AND RESTART              
A05460**            ACT312   LOGIC.                                    *        
A05091** 11/09/2016 RB19957  CHANGE LOGIC TO USE CPD00308 TO PICK UP            
A05091**                     THE MIN/MAX DEPOSIT FOR SEB.              *        
      ******************************************************************00419400
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00419600
      *                                                                *00419700
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00419800
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00419900
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00420000
      *  3000 - 4999  NOT USED                                         *00421000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00430000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00440000
      *  7000 - 7999  INPUT MODULES                                    *00450000
      *  8000 - 8999  OUTPUT MODULES                                   *00460000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00470000
      ******************************************************************00490000
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSDB07.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA098'.
MSQ017     COPY MFASQLM.
      *                                                                 00540000
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR PCSCA098 STARTS HERE'.                  
       COPY FIOJC01.                                                            
       COPY CWS09900.                                                           
       COPY CWS00011.                                                           
       COPY CWS00038.                                                           
       COPY CWS0070B.                                                           
       COPY CWS00039.                                                           
      *COPY CWS00074.                                                           
       COPY FIOCA00.                                                            
T33431 COPY CWSCA225.                                                           
A04860******************************************************************        
A04860* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
A04860******************************************************************        
A04860*                                                                         
A04860     EXEC SQL                                                             
A04860        INCLUDE CWS00077                                                  
A04860     END-EXEC.                                                            
A04860*                                                                         
      ******************************************************************00580000
      *    DB2 INCLUDES                                                *00590000
      ******************************************************************00600000
           EXEC SQL                                                     00620000
               INCLUDE SQLCA                                            00630000
           END-EXEC.                                                    00640000
      *---< CSS_ACCOUNT      - AT >                                     00660000
           EXEC SQL                                                     00670000
              INCLUDE TBACCT                                            00680000
           END-EXEC.                                                    00690000
      *---< CSS_MAX_DEP_REVIEW - MG >                                   00660000
           EXEC SQL                                                     00670000
              INCLUDE TBDEPREV                                          00680000
           END-EXEC.                                                    00690000
      *---< CSS_DEP_INT_RATE - P6                                               
           EXEC SQL                                                     00670000
              INCLUDE TBDEPINT                                                  
           END-EXEC.                                                    00690000
      *---< CSS_JOB_PARM                                                        
           EXEC SQL                                                     00670000
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                    00690000
      *---< CSS_RATE_CREATOR - RT                                               
           EXEC SQL                                                     00670000
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                    00690000
      *---< CSS_BILLING_HDR - BI                                                
           EXEC SQL                                                     00670000
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                    00690000
      *---< CSS_CUST_PREM_HIST - CH                                             
           EXEC SQL                                                     00670000
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                    00690000
      *---< CSS_UTIL_ENVRNMT - UT                                               
           EXEC SQL                                                     00670000
              INCLUDE TBUTLENV                                          00680000
           END-EXEC.                                                    00690000
      *---< CSS_BILLING_DETAIL - BG                                             
           EXEC SQL                                                     00670000
              INCLUDE TBBLLDET                                          00680000
           END-EXEC.                                                    00690000
      *---< CSS_CNT_DETAIL   - EA >                                     00692000
           EXEC SQL                                                     00693000
              INCLUDE TBCNTDET                                          00694000
           END-EXEC.                                                    00695000
      *---< CSS_CUSTOMER     - CU >                                     00710000
           EXEC SQL                                                     00720000
              INCLUDE TBCUST                                            00730000
           END-EXEC.                                                    00740000
           EXEC SQL                                                     00720000
              INCLUDE TBNAME                                            00730000
           END-EXEC.                                                    00740000
      *---< CSS_PREMISE      - PR >                                     00760000
           EXEC SQL                                                     00770000
              INCLUDE TBPREM                                            00780000
           END-EXEC.                                                    00790000
      *---< CSS_REFUND       - RN >                                     00810000
           EXEC SQL                                                     00820000
              INCLUDE TBREFUND                                          00830000
           END-EXEC.                                                    00840000
      *---< CSS_DEP_ON_HAND    - DO >                                   00910000
           EXEC SQL                                                     00920000
              INCLUDE TBDEPHND                                          00930000
           END-EXEC.                                                    00940000
      *---< CSS_DEP_PAY_HST    - DP >                                   00960000
           EXEC SQL                                                     00970000
              INCLUDE TBDEPHST                                          00980000
           END-EXEC.                                                    00990000
      *---< CSS_INTEREST_HIST  - IH >                                   01010000
           EXEC SQL                                                     01020000
              INCLUDE TBINTHST                                          01030000
           END-EXEC.                                                    01040000
      *---< CSS_AR_CNTL        - AC >                                   01060000
           EXEC SQL                                                     01070000
              INCLUDE TBARCNTL                                          01080000
           END-EXEC.                                                    01090000
      *---< CSS_AR_TRANS_HIST  - AR >                                   01110000
           EXEC SQL                                                     01120000
              INCLUDE TBARHIST                                          01130000
           END-EXEC.                                                    01140000
      *---< CSS_AR_TRN_HST_DET - AU >                                   01160000
           EXEC SQL                                                     01170000
              INCLUDE TBARHDT                                           01180000
           END-EXEC.                                                    01190000
      *---< CSS_BCH_JRNL_CNTL  - BC >                                   01310000
           EXEC SQL                                                     01320000
              INCLUDE TBBJCNTL                                          01330000
           END-EXEC.                                                    01340000
      *---< CSS_BATCH_JRNL    - BJ >                                    01360000
           EXEC SQL                                                     01370000
              INCLUDE TBBTJRNL                                          01380000
           END-EXEC.                                                    01390000
      *---< CSS_MISC_JRNL     - MJ >                                    01410000
           EXEC SQL                                                     01420000
              INCLUDE TBMSJRNL                                          01430000
           END-EXEC.                                                    01440000
      *---< CSS_GL_ACCT_NO     - GO >                                   01460000
           EXEC SQL                                                     01470000
              INCLUDE TBGLATNO                                          01480000
           END-EXEC.                                                    01490000
      *---< CSS_MNT_TRANS_HIST - MH >                                   01510000
           EXEC SQL                                                     01520000
              INCLUDE TBMNHIST                                          01530000
           END-EXEC.                                                    01540000
      *---< CSS_USER_PROFILE  - PF >                                    01560000
           EXEC SQL                                                     01570000
              INCLUDE TBUSRPRF                                          01580000
           END-EXEC.                                                    01590000
      *--- <CSS_MT_TRN_HST_DET - MI >                                   01710000
           EXEC SQL                                                     01720000
              INCLUDE TBMNHDT                                           01730000
           END-EXEC.                                                    01740000
      *---< CSS_AR_PMT_PRTY    - C9>                                    01760000
           EXEC SQL                                                     01770000
              INCLUDE TBARPMT                                           01780000
           END-EXEC.                                                    01790000
      *---< CSS_CONTRACT       - CT>                                    01860000
           EXEC SQL                                                     01870000
              INCLUDE TBCNTRCT                                          01880000
           END-EXEC.                                                    01890000
      *--- <CSS_DFA_RECVBLE    - DV >                                   01910000
           EXEC SQL                                                     01920000
              INCLUDE TBDFARCV                                          01930000
           END-EXEC.                                                    01940000
      *--- <CSS_DFA_ACCT       - DA >                                   02010000
           EXEC SQL                                                     02020000
              INCLUDE TBDFAACT                                          02030000
           END-EXEC.                                                    02040000
      *---< CSS_RECONNECT      - DL>                                    02060000
           EXEC SQL                                                     02070000
              INCLUDE TBRECNCT                                          02080000
           END-EXEC.                                                    02090000
      *---< CSS_CHRG_OFF      - CO >                                    02160000
           EXEC SQL                                                     02170000
              INCLUDE TBCHGOFF                                          02180000
           END-EXEC.                                                    02190000
      *---< CSS_BUDGET_PLAN    - BU >                                   02310000
           EXEC SQL                                                     02320000
              INCLUDE TBBGTPLN                                          02330000
           END-EXEC.                                                    02340000
      *---< CSS_BUDGET_HIST    - BH >                                   02360000
           EXEC SQL                                                     02370000
              INCLUDE TBBGTHST                                          02380000
           END-EXEC.                                                    02390000
      *---< CSS_DELINQUENCY    - C8 >                                   02510000
           EXEC SQL                                                     02520000
              INCLUDE TBDELQ                                            02530000
           END-EXEC.                                                    02540000
      *---< CSS_LIEAP          - LI >                                   02560000
           EXEC SQL                                                     02570000
              INCLUDE TBLIEAP                                           02580000
           END-EXEC.                                                    02590000
      *---< CSS_CREDIT_PROFILE - CZ >                                   02623100
           EXEC SQL                                                     02623200
              INCLUDE TBCRPROF                                          02623300
           END-EXEC.                                                    02623400
      *---< CSS_PROJ_SHAR      - CG >                                   02623600
           EXEC SQL                                                     02623700
              INCLUDE TBPRJSHR                                          02623800
           END-EXEC.                                                    02623900
      *---< CSS_LOCAL_OFFICE        >                                   02624100
           EXEC SQL                                                     02624200
              INCLUDE TBLOCOFC                                          02624300
           END-EXEC.                                                    02624400
           EXEC SQL                                                     02624600
              INCLUDE TBCCCHRG                                          02624700
           END-EXEC.                                                    02624800
           EXEC SQL                                                     02625000
              INCLUDE TBRCNCHR                                          02625100
           END-EXEC.                                                    02625200
      ******************************************************************02625400
      *    CSS_WO_ARRANGEMENT                                           02625500
      ******************************************************************02625600
           EXEC SQL                                                     02625800
               INCLUDE TBWOARGM                                         02625900
           END-EXEC.                                                    02626000
      ******************************************************************02626300
      *    CSS_HOLIDAY                                                  02626400
      ******************************************************************02626500
           EXEC SQL                                                     02626600
               INCLUDE TBHLDAY                                          02626700
           END-EXEC.                                                    02626800
C33201************************************************************              
C33201**   CSS_REG_PROFILE (LR)                                                 
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBREGPRF                                                  
C33201     END-EXEC.                                                            
P00172******************************************************************02628100
P00172* CSS_CUST_STATS, CE                                             *02628100
P00172******************************************************************02628100
P00172     EXEC SQL                                                     02628100
P00172          INCLUDE TBCSTSTS                                        02628100
P00172     END-EXEC.                                                    02628100
P00172*                                                                 02628100
A05091******************************************************************02628100
A05091* CSS_ACCT_MISC_INFO TA                                          *        
A05091******************************************************************02628100
A05091     EXEC SQL                                                             
A05091        INCLUDE TBATMISC                                                  
A05091     END-EXEC.                                                            
A05091*                                                                         
HPCCDM*EJECT                                                            02628400
           EXEC SQL                                                             
              INCLUDE CWS0223B                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     02628600
              INCLUDE CWS00013                                          02628700
           END-EXEC.                                                    02628800
           EXEC SQL                                                     02650000
              INCLUDE CWS00061                                          02660000
           END-EXEC.                                                    02670000
           EXEC SQL                                                     02730000
              INCLUDE CWS00073                                          02740000
           END-EXEC.                                                    02750000
      ******************************************************************02770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02780000
      ******************************************************************02790000
      * ADDED FOR JOURNALING                                            02840000
           COPY CJF00101.                                               02860000
           COPY CJF00102.                                               02870000
           COPY CJF00105.                                               02871000
           COPY CWS00004.                                               02881000
           EXEC SQL                                                     02900000
              INCLUDE CWS00008                                          02901000
           END-EXEC.                                                    02902000
           COPY CWS00010.                                               02910000
           COPY CWS00027.                                               02910000
           COPY CWS00056.                                               02930000
           COPY CWS00303.                                               02950000
      / WORKING STORAGE REQUIRED FOR CPD0010S.                                  
            EXEC SQL                                                            
               INCLUDE CWS00017                                                 
            END-EXEC.                                                           
      / WORKING STORAGE REQUIRED FOR CPD00312.                                  
            EXEC SQL                                                            
               INCLUDE CWS10016                                                 
            END-EXEC.                                                           
      ******************************************************************02970000
      *    WORK AREAS                                                  *02980000
      ******************************************************************02990000
       01  WS-SAVE-DEP-ON-HAND.                                         
COB305     05 WS-DO-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
           05 WS-DO-DEPOSIT-CERT-NO      PIC S9(9) USAGE COMP.          
COB305     05 WS-DO-AMT-DEPOSIT        PIC S9999999V99 USAGE COMP-3 
COB305       VALUE 0.  
           05 WS-DO-DATE-INTST-CALC-TO   PIC X(10).                     
COB305     05 WS-DO-INTRST-YTD        PIC S9999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-DO-TOTAL-INTRST        PIC S9999999V99 USAGE COMP-3 
COB305       VALUE 0.  
           05 WS-DO-CODE-REFUND-STATUS   PIC X(1).                      
           05 WS-DO-CODE-REFUND-REASON   PIC X(1).                      
           05 WS-DO-DEPOSIT-STATUS-CD    PIC X(1).                      
COB305     05 WS-DO-AMT-REFUNDED        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.    
      *                                                                 03820000
       01  WS-NAME-BREAKDOWN.                                           
           05  WS-FIRST-NAME-BD        PIC X(20).                       
           05  WS-MIDDLE-NAME-BD       PIC X(15).                       
           05  WS-LAST-NAME-BD         PIC X(15).                       
                                                                        
ACT089 01  WS-CPD0010S-CALL-TYPE       PIC X(01)  VALUE 'B'.            
ACT089     88  WS-CPD0010S-ONLINE-CALL            VALUE 'O'.            
ACT089     88  WS-CPD0010S-BATCH-CALL             VALUE 'B'.            
                                                                        
       01  WS-MISC.                                                     
           05  SCSCB061                PIC X(08)     VALUE 'SCSCB061'.  
T33431     05  MCSCB225                 PIC  X(8) VALUE  'SCSCB225'.    
T33431     05  WS-COG-TRAN-TYPE-CD-73   PIC X(1) VALUE  'P'.            
           05  RS-MIN-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP        
                                                VALUE 0.                
ACT089     05  WS-WQ-CALL-PGM           PIC X(08)  VALUE 'SCSCB077'.    
           05  WS-CURRENT-TIMESTAMP    PIC X(26)  VALUE SPACES.         
A04776     05  WS-HOLD-DATE            PIC X(10).                       
           05  WS-LAST-UPDATE-TS       PIC X(26).                       
           05  WS-DATE-1-YEAR-AGO      PIC X(10).                       
           05  WS-NEXT-DATE            PIC X(10).                       
           05  WS-DAY                  PIC S9(04)     COMP.             
           05  WS-LAST-REFUND-ITEM-ID  PIC S9(9) USAGE COMP.            
           05  WS-NEW-ADDRESS-ID       PIC 9(13) VALUE ZERO.            
           05  WS-DATE-11-MNT-AGO          PIC X(10).                   
A01731     05  WS-DATE-13-MNT-AGO          PIC X(10).                   
P00394     05  WS-INPUT-DATE-1             PIC X(10).                   
COB305     05 WS-INTEREST-REMAIN        PIC S9(09)V99 COMP-3 VALUE 0.        
COB305     05 WS-NUM-OF-DAYS        PIC S9(04) COMP-3 VALUE 0.        
           05  WS-TOT-MOS-IN-ARREARS       PIC S9(02) COMP VALUE ZERO.  
COB305     05 WS-AMT-TRAN-BALANCE        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-SUMM-AMT-TRAN-BALANCE        PIC S9(09)V99 
COB305       USAGE COMP-3 VALUE 0.  
COB305     05 WS-THIS-AR-AMOUNT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-SPEC-AR-AMOUNT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-HOLD-30-ARREARS-AMT        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-HOLD-60-90-ARREARS-AMT        PIC S9(9)V99 COMP-3 
COB305       VALUE 0.         
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO        PIC X(02).                   
               10  WS-CD-LOCAL-OFFICE      PIC X(03).                   
               10  WS-CD-REPORT-NO         PIC X(03).                   
               10  WS-CD-REPORT-DATE       PIC X(10).                   
               10  WS-CASH-DRAWER-ID       PIC S9(04) COMP VALUE 9999.  
           05  WS-CASH-REPORT-NO           PIC X(03)     VALUE '998'.   
           05  WS-GL-ACCT-NAME-CR          PIC X(10).                   
           05  WS-GL-ACCT-NAME-DB          PIC X(10).                   
COB305     05 WS-AU-AMOUNT        PIC S9(09)V99 USAGE COMP-3 VALUE 0.  
           05  WS-AMT-BILLED-UNPAID        PIC S9(09)V99 USAGE COMP-3   
                                           VALUE 0.                     
           05  WS-SPEC-CR-FLAG             PIC X(01) VALUE 'N'.         
               88 NOT-SPECIFIED-CREDIT     VALUE 'N'.                   
           05  WS-UPDATE-FLAG              PIC X(01) VALUE 'N'.         
               88 UPDATE-IS-NEEDED         VALUE 'Y'.                   
           05  WS-ROW-EXISTS               PIC X(01).                   
               88  ROW-EXISTS              VALUE 'Y'.                   
           05  WS-THIS-TRAN-APPL-NO    PIC S9(4) USAGE COMP.            
           05  WS-THIS-TIMESTAMP       PIC X(26)  VALUE SPACES.         
           05  WS-SPEC-TIMESTAMP       PIC X(26)  VALUE SPACES.         
           05  WS-DEP-REQ-EXISTS       PIC X(01)  VALUE 'N'.            
           05  WS-ACTIVE-DEP-EXISTS    PIC X(01)  VALUE 'N'.            
               88  ACTIVE-DEP-EXISTS              VALUE 'Y'.            
           05  WS-RECENT-PD-DEP-EXISTS PIC X(01)  VALUE 'N'.            
               88  RECENT-PD-DEP-EXISTS           VALUE 'Y'.            
           05  WS-DEP-ON-HAND-EXISTS   PIC X(01)  VALUE 'N'.            
           05  WS-CHECK-AMOUNT         PIC 9(09)V9(2) VALUE 0.          
           05  WS-CASH-AMOUNT          PIC 9(09)V9(2) VALUE 0.          
COB305     05 WS-TOTAL-PAYMENTS        PIC S9(07)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-TOTAL-CREDIT-DEP        PIC S9(07)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-TOTAL-REFUNDED        PIC S9(07)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-TOTAL-PYMTS-HOLDING        PIC S9(07)V99 USAGE COMP-3 
COB305       VALUE 0.      
COB305     05 WS-TOTAL-PAYMENTS-BY-DEP        PIC S9(07)V99 
COB305       USAGE COMP-3 VALUE 0.     
           05  WS-REFUND-AMOUNT        PIC S9(07)V99 USAGE COMP-3       
                                                     VALUE 0.           
           05  WS-STARTING-POS          PIC S9(04) COMP.                
           05  WS-AR-AMT                PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-CURR-FULL-BAL         PIC S9(11)V99 COMP-3 VALUE 0.   
           05  WS-EIBRESP               PIC S9(8)  COMP SYNC VALUE 0.   
COB305     05 WS-WO-MTH-YR        PIC S9(06)V COMP-3 VALUE 0.           
           05  WS-WO-MTH-YR-X           PIC X(06).                      
           05  WS-LINE-COUNT            PIC S9(03)   COMP-3 VALUE +99.  
           05  WS-PAGE-COUNT            PIC S9(05)   COMP-3 VALUE +0.   
           05  WS-REC-COUNT             PIC S9(05)   COMP-3 VALUE +0.   
           05  WS-FDB07-STATUS          PIC X(02).                      
               88  FDB07-SUCCESSFUL                  VALUE '00'.        
           05  WS-FRP098-STATUS         PIC X(02).                      
               88  FRP098-SUCCESSFUL              VALUE '00'.           
           05  WS-FCSRP98R-STATUS   PIC X(02).                          
               88  FCSRP98R-SUCCESSFUL    VALUE '00'.                   
           05  WS-END-OF-FILE           PIC X(01) VALUE 'N'.            
               88  END-OF-FILE                    VALUE 'Y'.            
           05  WS-CONTINUE-REVIEW       PIC X(01) VALUE 'Y'.            
               88  CONTINUE-REVIEW                VALUE 'Y'.            
           05  WS-DISPLAY-SQLCODE       PIC -ZZZZZZZZ9.                 
           05  RS-RETURN-CODE           PIC S9(04)   COMP.              
           05  RS-RETURN-CODE-DISP      PIC S9(04).                     
           05  WS-REV-DT                PIC X(6).                       
           05  WS-REV-DT-ALPHA REDEFINES WS-REV-DT.                     
               10  WS-REV-YR            PIC X(4).                       
               10  WS-REV-MTH           PIC X(2).                       
COB305     05 WS-ACCOUNT-NO-P        PIC S9(13) USAGE COMP-3 VALUE 0.        
COB305     05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.        
           05  WS-CURRENT-DATE          PIC X(10).                      
           05  WS-HOLD-ACCOUNT-NO       PIC 9(13).                      
           05  WS-WQ-CATEGORY           PIC 9(4)       VALUE ZERO.      
           05  WS-WQ-PRIORITY           PIC X(1)       VALUE SPACE.     
           05  WS-CODE-REFUND-ELIG      PIC X(1)       VALUE SPACE.     
P00172     05  S-RETURN-CODE            PIC S9(04)   COMP.              
COB305     05 WS-BILLD-DEP-AMT        PIC S9(09)V99 COMP-3 VALUE 0.           
P00172     05  WS-DELINQ-CODE           PIC X(20)     VALUE SPACE.      
P00172     05  WS-RESULT-YEAR           PIC S9(04) COMP.                
P00172     05  WS-START-DATE            PIC X(10) VALUE SPACES.         
P00172     05  WS-END-DATE              PIC X(10) VALUE SPACES.         
P00172     05  WS-SCANA-SR-AGE          PIC S9(4) USAGE COMP VALUE +0.  
A04860*                                                                         
A04860     05  SCSCB077                PIC X(08)  VALUE 'SCSCB077'.     
ACT089     05  MCSCB077                PIC X(08)  VALUE 'MCSCB077'.     
A04860     05  WS-CUSTOMER-NAME        PIC X(96)  VALUE SPACE.          
A04860 01  WS-INPUT-TS.                                                 
A04860     05  WS-INPUT-DATE-TS          PIC X(10).                     
A04860     05  WS-INPUT-TS-REF           PIC X(16)                      
A04860                                   VALUE '-00.00.00.000000'.      
A04860*                                                                 04290000
A04860 01  WS-NEXT-TS.                                                  
A04860     05  WS-NEXT-DATE-TS          PIC X(10).                      
A04860     05  WS-NEXT-TS-REF           PIC X(16)                       
A04860                                   VALUE '-00.00.00.000000'.      
A04860*                                                                 04290000
       01  WS-COMMENTS.                                                 
           05 WS-COMMENTS-LEN             PIC S9(4) USAGE COMP.         
           05 WS-COMMENTS-TEXT            PIC X(250).                   
       01  WS-WQ-COMMENTS.                                              
A04860     05 WS-WQ-COMMENTS-LIT         PIC X(50) VALUE SPACES.        
A04860     05 WS-WQ-GROUP                PIC X(07) VALUE SPACES.        
P00677     05 WS-WQ-MAX-DEP-LIT          PIC X(08)  VALUE               
P00677         'MAXIMUM '.                                              
A04860     05 WS-WQ-MAX-DEP-LIT-SR       PIC X(19) VALUE SPACES.        
A04860     05  WS-WQ-MAX-DEPOSIT         PIC $$$$$$.99 VALUE ZERO.      
           05  WS-WQ-TOT-PD-DEPOSITS-LIT PIC X(20)  VALUE               
               ' TOTAL PD DEPOSITS: '.                                  
A04860     05  WS-WQ-TOT-PD-DEPOSITS     PIC $$$$$$.99 VALUE ZERO.      
P00677     05  WS-WQ-TOT-BD-DEPOSITS-LIT PIC X(24)  VALUE               
P00677         ' TOTAL BILLED DEPOSITS: '.                              
A04860     05  WS-WQ-TOT-BLD-DEPOSITS    PIC $$$$$$.99 VALUE ZERO.      
           05  WS-WQ-TOT-REFUND-LIT      PIC X(9)   VALUE               
               ' REFUND: '.                                             
A04860     05  WS-WQ-REFUND              PIC $$$$$$.99 VALUE ZERO.      
       01  WS-WORKQUEUE-A-COMMENTS        PIC X(26)  VALUE              
               'UNPAID DEPOSIT - NO REFUND'.                            
       01  WS-WORKQUEUE-D-COMMENTS        PIC X(23)  VALUE              
               'CURRENT DNP - NO REFUND'.                               
       01  WS-WORKQUEUE-E-COMMENTS        PIC X(18)  VALUE              
               'EXEMPT FROM REFUND'.                                    
       01  WS-WORKQUEUE-I-COMMENTS        PIC X(25)  VALUE              
               'INSUFFICIENT MAX DEP DATA'.                             
       01  WS-WORKQUEUE-L-COMMENTS        PIC X(26)  VALUE              
               'NOT OVER LIMIT - NO REFUND'.                            
       01  WS-WORKQUEUE-P-COMMENTS        PIC X(33)  VALUE              
               'PAID DEPOSIT RECENTLY - NO REFUND'.                     
       01  WS-WORKQUEUE-X-COMMENTS        PIC X(23)  VALUE              
               'NOT ELIGIBLE FOR REFUND'.                               
      *                                                                 01551200
P00172 01  WS-WORKQUEUE-B-COMMENTS        PIC X(46)  VALUE              
P00172     'PAID DEP > MAX DEP, HAS BILLED/XFER DEPOSIT'.               
P00172 01  WS-WORKQUEUE-C-COMMENTS        PIC X(46)  VALUE              
P00172     'PAID DEP <= MAX DEP, HAS BILLED/XFER DEPOSIT'.              
      *                                                                 01551200
       01  WS-AR-INT-COMMENT-TEXT.                                      
           05  FILLER                   PIC X(52)    VALUE              
             'MAX DEPOSIT REVIEW REFUND. INT + DEPOSIT APPLIED TO '.    
           05  FILLER                   PIC X(13)    VALUE              
             'DEP CERT NO: '.                                           
           05  WS-INT-DEP-CERT-NO       PIC 9(4).                       
       01  WS-AR-DEP-COMMENT-TEXT.                                      
           05  FILLER                   PIC X(53)    VALUE              
               'MAX DEPOSIT REVIEW REFUND. REFUND APPLIED TO DEP ID: '. 
           05  WS-DEP-CERT-NO           PIC 9(4).                       
       01  WS-LITERAL.                                                  
           05  PROGRAM-NAME             PIC X(08)    VALUE 'PCSCA098'.  
           05  WS-PGRMNAME              PIC X(08)    VALUE 'PCSCA098'.  
           05  WS-COMMON                PIC X(08)    VALUE 'COMMON  '.  
           05  WS-D                     PIC X(01) VALUE 'D'.            
           05  WS-S                     PIC X(01) VALUE 'S'.            
           05  WS-U                     PIC X(01) VALUE 'U'.            
           05  WS-O                     PIC X(01) VALUE 'O'.            
           05  WS-RCV-TYPE              PIC S9(04) COMP.                
           05  WS-NO                    PIC  X(01) VALUE 'N'.           
           05  WS-YES                   PIC  X(01) VALUE 'Y'.           
           05  WS-NO-ERROR              PIC  X(05) VALUE 'NOERR'.       
           05  WS-CIA                   PIC  X(04) VALUE '0070'.        
           05  WS-1                     PIC  X(01) VALUE '1'.           
           05  WS-3                     PIC  X(01) VALUE '3'.           
           05  WS-4                     PIC  X(01) VALUE '4'.           
           05  WS-I                     PIC  X(01) VALUE 'I'.           
           05  WS-R                     PIC  X(01) VALUE 'R'.           
           05  WS-50                    PIC  9(02) VALUE  50.           
      *                                                                         
       01  WS-NULL-IND-VARS.                                            
           05  WS-NULL-INDICATOR-1      PIC S9(04) COMP.                
           05  WS-NULL-INDICATOR-2      PIC S9(04) COMP.                
           05  WS-NULL-INDICATOR-3      PIC S9(04) COMP.                
           05  WS-NULL-INDICATOR-4      PIC S9(04) COMP.                
           05  WS-RN-NULL-IND-1         PIC S9(04) COMP.                
           05  DATE-CREDIT-ACTION-NI    PIC S9(04) COMP.                
           05  DATE-NOTICE-MAIL-NI      PIC S9(04) COMP.                
           05  WS-NULL-IND-CREATE-DT    PIC S9(04) COMP.                
           05  WS-NULL-IND-REV-DT       PIC S9(04) COMP.                
           05  WS-NULL-PAYMENT          PIC S9(04) COMP.                
           05  WS-NULL-CREDIT           PIC S9(04) COMP.                
           05  WS-NULL-REFUND           PIC S9(04) COMP.                
P00172     05  WS-NULL-BLD-DEP          PIC S9(04) COMP.                
P00172     05  WS-NULL-CUST-DOB         PIC S9(04) COMP.                
           05  WS-REVENUE-MTH-NULL-1    PIC S9(04) COMP.                
           05  WS-NULL-IND-00           PIC S9(04) COMP.                
           05  WS-NULL-IND-30           PIC S9(04) COMP.                
           05  WS-NULL-IND-60           PIC S9(04) COMP.                
           05  WS-NULL-IND-90           PIC S9(04) COMP.                
      *                                                                 04850000
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                 04930000
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                 04990000
       01  NULL-INDICATOR-FIELDS.                                       
           05  WS-REFUND-ITEM-ID-NI      PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-INTST-CALC-TO-NI  PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-ORIG-PYMT-IND     PIC S9(4) COMP VALUE 0.        
           05  WS-DEP-PAY-DT-NI          PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-CERT-ISSUE-NI     PIC S9(4) COMP VALUE 0.        
           05  WS-TOTAL-PAYMENTS-NI      PIC S9(4) COMP VALUE 0.        
           05  WS-TOTAL-PAYMENTS-BY-DEP-NI PIC S9(4) COMP VALUE 0.      
           05  WS-DATE-PYMT-START-NI     PIC S9(4) COMP VALUE 0.        
      *                                                                 05170000
       01  WS-REFUND-TYPE.                                              
           05  WS-DEPOSIT-ONLY           PIC X(01) VALUE 'D'.           
           05  WS-DEP-AND-INTR           PIC X(01) VALUE 'A'.           
      *                                                                 05220000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  WS-THIS-ACCOUNT-SW      PIC X(01) VALUE 'Y'.             
               88 WS-THIS-ACCOUNT                VALUE 'Y'.             
               88 WS-SPEC-ACCOUNT                VALUE 'N'.             
           05  WS-REFUND-SW            PIC X(01) VALUE 'Y'.             
               88 REFUND-OK                      VALUE 'Y'.             
               88 DO-NOT-REFUND                  VALUE 'N'.             
           05  WS-BEGIN-REC-SW         PIC X(01) VALUE 'N'.             
               88  WS-BEGIN-RECS-PROCESSED       VALUE 'Y'.             
           05  WS-DATE-FOUND           PIC X(01) VALUE 'N'.             
               88  DATE-IS-FOUND                 VALUE 'Y'.             
           05  WS-RECORD-FOUND         PIC X(01) VALUE 'N'.             
               88  DATA-RECORD-FOUND             VALUE 'Y'.             
               88  NO-DATA-RECORD-FOUND          VALUE 'N'.             
           05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
               88  CSR-DATABASE                  VALUE 1.               
               88  SEB-DATABASE                  VALUE 2.               
P00172     05  WS-BILLED-DEP-EXISTS    PIC X(01) VALUE 'N'.             
P00172         88 BILLED-DEP-EXISTS              VALUE 'Y'.             
P00172     05  WS-XFER-DEP-EXISTS      PIC X(01) VALUE 'N'.             
P00172         88 XFER-DEP-EXISTS                VALUE 'Y'.             
           05  WS-DATABASE-CD                  PIC X(08) VALUE          
                                   'DATABASE'.                          
           05  WS-AMT-MIN-REFUND-CD            PIC X(20) VALUE          
                                   'AMT-MIN-REFUND-LIMIT'.              
           05  WS-AMT-MIN-REFUND-VALUE         PIC S9(5) USAGE COMP-3   
                                                         VALUE +99999.  
           05  WS-MIN-AGE-CD                   PIC X(18) VALUE          
                                   'MIN-AGE-DEP-REFUND'.                
COB305     05 WS-MIN-AGE-VALUE        PIC S9(5) USAGE COMP-3 VALUE 0.  
      *                                                                 05300000
       01  WS-MISC1.                                                    
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
                                                                        
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
      *                                                                 05360000
           EXEC SQL                                                             
               INCLUDE CWS00308                                                 
           END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                            05370000
      ******************************************************************05390000
      * CURSOR DECLARATION                                             *05400000
      ******************************************************************05410000
      *                                                                         
           EXEC SQL                                                     
              DECLARE DEP_ON_HAND CURSOR FOR                            
              SELECT DEPOSIT_CERT_NO,                                   
                     AMT_DEPOSIT,                                       
                     AMT_REFUNDED,                                      
                     INTRST_YTD,                                        
                     TOTAL_INTRST,                                      
                     DATE_PYMT_START,                                   
                     DATE_INTST_CALC_TO,                                
                     CODE_REFUND_STATUS,                                
                     DEPOSIT_STATUS_CD,                                 
                     DATE_CERT_ISSUE                                    
              FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
              WHERE  ACCOUNT_NO = :DO-ACCOUNT-NO AND                    
                     DEPOSIT_STATUS_CD IN ('P')                         
              ORDER BY DATE_CERT_ISSUE                                  
T34097        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05630000
MFA-TR*       DECLARE DEP_ON_HAND CURSOR FOR                            05640000
MFA-TR*       SELECT DEPOSIT_CERT_NO,                                   05650000
MFA-TR*              AMT_DEPOSIT,                                       05660000
MFA-TR*              AMT_REFUNDED,                                      05670000
MFA-TR*              INTRST_YTD,                                        05680000
MFA-TR*              TOTAL_INTRST,                                      05690000
MFA-TR*              DATE_PYMT_START,                                   05700000
MFA-TR*              DATE_INTST_CALC_TO,                                05710000
MFA-TR*              CODE_REFUND_STATUS,                                05730000
MFA-TR*              DEPOSIT_STATUS_CD,                                 05750000
MFA-TR*              DATE_CERT_ISSUE                                    05751000
MFA-TR*       FROM   CSS_DEP_ON_HAND                                    05760000
MFA-TR*       WHERE  ACCOUNT_NO = :DO-ACCOUNT-NO AND                    05770000
MFA-TR*              DEPOSIT_STATUS_CD IN ('P')                         05790000
MFA-TR*       ORDER BY DATE_CERT_ISSUE                                  00066100
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    05800000
      *                                                                 05810000
           EXEC SQL                                                     
              DECLARE DEP_EXISTS  CURSOR FOR                            
              SELECT   'Y'                                              
              FROM     CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                    
              WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 
                       DEPOSIT_STATUS_CD IN ('A', 'P')                  
T34097        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05900000
MFA-TR*       DECLARE DEP_EXISTS  CURSOR FOR                            05910000
MFA-TR*       SELECT   'Y'                                              05920000
MFA-TR*       FROM     CSS_DEP_ON_HAND                                  05930000
MFA-TR*       WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 05940000
MFA-TR*                DEPOSIT_STATUS_CD IN ('A', 'P')                  05950000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    05960000
      *                                                                 05970000
           EXEC SQL                                                     
              DECLARE ACTDEP_EXISTS  CURSOR FOR                         
              SELECT   'Y'                                              
              FROM     CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                    
              WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 
                       DEPOSIT_STATUS_CD = ('A')                        
T34097        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05900000
MFA-TR*       DECLARE ACTDEP_EXISTS  CURSOR FOR                         05910000
MFA-TR*       SELECT   'Y'                                              05920000
MFA-TR*       FROM     CSS_DEP_ON_HAND                                  05930000
MFA-TR*       WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 05940000
MFA-TR*                DEPOSIT_STATUS_CD = ('A')                        05950000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    05960000
      *                                                                 05810000
           EXEC SQL                                                     
              DECLARE NOT_ELIG_EXISTS CURSOR FOR                        
              SELECT   'Y'                                              
              FROM     CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                    
              WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 
                       CODE_REFUND_ELIG = 'A'                           
T34097        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05900000
MFA-TR*       DECLARE NOT_ELIG_EXISTS CURSOR FOR                        05910000
MFA-TR*       SELECT   'Y'                                              05920000
MFA-TR*       FROM     CSS_DEP_ON_HAND                                  05930000
MFA-TR*       WHERE    ACCOUNT_NO = :AT-ACCOUNT-NO  AND                 05940000
MFA-TR*                CODE_REFUND_ELIG = 'A'                           05950000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    05960000
      *                                                                         
P00172     EXEC SQL                                                     
P00172        DECLARE DELINQUENCY_CSR CURSOR FOR                        
P00172          SELECT DELINQ_CD,                                       
P00172                 DELINQ_VALUE                                     
P00172            FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
P00172           WHERE DELINQ_CD  IN ('SCANA SENIOR AGE')               
P00172        FOR READ ONLY                                     
P00172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DELINQUENCY_CSR CURSOR FOR                                
MFA-TR*         SELECT DELINQ_CD,                                               
MFA-TR*                DELINQ_VALUE                                             
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*          WHERE DELINQ_CD  IN ('SCANA SENIOR AGE')                       
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                 03880000
COMMIT     EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                 05970000
       PROCEDURE DIVISION.                                              
      ******************************************************************06000000
      * 0000-MAINLINE                                                  *06010000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *06020000
      ******************************************************************06030000
      *                                                                 06040000
       0000-MAINLINE.                                                   
      *                                                                 06060000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT                   
              UNTIL END-OF-FILE.                                        
           PERFORM 9000-TERMINATE      THRU 9000-EXIT.                  
           STOP RUN.                                                    
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06150000
      * 0100-INITIALIZE                                                *06160000
      *     COMMON INITIALIZATION ROUTINE.                             *06180000
      ******************************************************************06230000
       0100-INITIALIZE.                                                 
      *                                                                 06250000
           MOVE PROGRAM-NAME                   TO ABEND-PROGRAM.        
ACT294     SET WS-GL-SUB                       TO 1.                    
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                                 THRU 6240-EXIT         
               MOVE WS-FCA00-COMMON-DATE         TO WS-INPUT-DATE       
           END-IF.                                                      
           PERFORM 7020-GET-REVENUE-MONTH        THRU 7020-EXIT.        
           MOVE WS-INPUT-DATE                  TO WS-HOLD-DATE          
P00394                                            WS-INPUT-DATE-1       
P00394                                            WS-REFUND-DATE.       
           PERFORM 1805-GET-NEXT-BUSINESS-DAY  THRU 1805-EXIT.          
           MOVE WS-HOLD-DATE                   TO WS-NEXT-DATE.         
           PERFORM 7000-GET-DATES              THRU 7000-EXIT.          
           OPEN INPUT FCSDB07-FILE.                                     
           IF  FDB07-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'OPEN ERROR ON FCSDB07 FILE.'                    
               DISPLAY ' STATUS IS ', WS-FDB07-STATUS                   
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF                                                       
              PERFORM 0500-PROCESS-BEGIN-REC  THRU  0500-EXIT           
                 UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES            
           MOVE WS-DATABASE-CD           TO C8-DELINQ-CD                
           PERFORM 7050-SELECT-DELINQ-VALUE    THRU 7050-EXIT.          
           MOVE C8-DELINQ-VALUE                TO                       
                                               WS-DATABASE.             
P00172     IF CSR-DATABASE                                              
              MOVE WS-AMT-MIN-REFUND-CD        TO C8-DELINQ-CD          
              PERFORM 7050-SELECT-DELINQ-VALUE THRU 7050-EXIT           
              MOVE C8-DELINQ-VALUE             TO                       
                                                 WS-AMT-MIN-REFUND-VALUE
              MOVE WS-MIN-AGE-CD               TO C8-DELINQ-CD          
              PERFORM 7050-SELECT-DELINQ-VALUE THRU 7050-EXIT           
              MOVE C8-DELINQ-VALUE             TO                       
                                                  WS-MIN-AGE-VALUE      
P00172     ELSE                                                         
P00172        PERFORM  1100-LOAD-DELINQ-VALUES THRU 1100-EXIT           
P00172     END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *****************************************************************         
      *    0500-PROCESS-BEGIN-REC                                    **         
      *    THIS PARAGRAPH DOES AN INITIAL READ TO THE DB07 FILE AND  **         
      *    CHECKS FOR A BEGINNING RECORD. WHEN FOUND THE DATE ON     **         
      *    THE BEGIN RECORD IS COMPARED TO THE RUN DATE OBTAINED     **         
      *    FROM THE JOBS TABLE TO ENSURE WE ARE PROCESSING WITH      **         
      *    THE CORRECT FILE.                                         **         
      *****************************************************************         
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7001-READ-FCSDB07           THRU 7001-EXIT.          
           EVALUATE TRUE                                                
              WHEN END-OF-FILE                                          
                 DISPLAY '**    PCSCA098 PROCESSING ERROR          **'  
                 DISPLAY '**      FCSDB07 FILE IS EMPTY            **'  
                 DISPLAY '**      PROCESSING TERMINATED            **'  
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
      *                                                                         
              WHEN E-FDB07-KEY-BREC EQUAL LOW-VALUES                    
                 IF E-FDB07-CREATE-DATE-BREC NOT = WS-INPUT-DATE        
                    DISPLAY '**     PCSCA098 PROCESSING ERROR      **'  
                    DISPLAY '** FCSDB07 CREATE DATE NOT = RUN DATE **'  
                    DISPLAY '**       PROCESSING TERMINATED        **'  
                    PERFORM 9900-ABEND         THRU 9900-EXIT           
                 END-IF                                                 
                 SET WS-BEGIN-RECS-PROCESSED   TO TRUE                  
      *                                                                         
              WHEN WS-BEGIN-RECS-PROCESSED                              
                 IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES    
                    IF E-FDB07-KEY-BREC EQUAL HIGH-VALUES AND           
                       NO-DATA-RECORD-FOUND AND                         
                       E-FDB07-RECORD-COUNT-EREC EQUAL ZERO             
                       DISPLAY                                          
                       '**    PCSCA098 PROCESSING ERROR          **'    
                       DISPLAY                                          
                       '**      FCSDB07 FILE IS EMPTY            **'    
                       DISPLAY                                          
                       '**      PROCESSING TERMINATED            **'    
                       PERFORM 9900-ABEND            THRU 9900-EXIT     
                    ELSE                                                
                       CONTINUE                                         
                    END-IF                                              
                 ELSE                                                   
                    SET DATA-RECORD-FOUND      TO TRUE                  
                    MOVE E-FDB07-COMPANY-NO    TO C8-COMPANY-NO         
                 END-IF                                                 
      *                                                                         
              WHEN OTHER                                                
                 DISPLAY '**    PCSCA098 PROCESSING ERROR          **'  
                 DISPLAY '** FIRST RECORD IS NOT A CNTL REC        **'  
                 DISPLAY '**      PROCESSING TERMINATED            **'  
                 PERFORM 9900-ABEND            THRU 9900-EXIT           
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************06520000
      * 1000-PROCESS-INPUT.                                            *06530000
      ******************************************************************06580000
       1000-PROCESS-INPUT.                                              
      *                                                                         
           IF  (E-FDB07-KEY-BREC EQUAL HIGH-VALUES OR LOW-VALUES)       
               OR E-FDB07-COMPANY-NO NOT = WS-SCEG                      
               CONTINUE                                                 
           ELSE                                                         
               MOVE E-FDB07-ACCT-NO            TO WS-ACCOUNT-NO         
                                                  AT-ACCOUNT-NO         
                                                  DP-ACCOUNT-NO         
                                                  DO-ACCOUNT-NO         
                                                  UT-ACCOUNT-NO         
                                                  AC-ACCOUNT-NO         
                                                  RN-ACCOUNT-NO         
                                                  CH-ACCOUNT-NO         
                                                  MG-ACCOUNT-NO         
                                                  DL-ACCOUNT-NO         
P00172                                            LR-ACCOUNT-NO         
               MOVE 'N'                        TO WS-CONTINUE-REVIEW    
               MOVE 0                          TO WS-LAST-REFUND-ITEM-ID
               PERFORM 7150-SELECT-ACCOUNT              THRU 7150-EXIT  
P00172         IF SEB-DATABASE                                          
P00172            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL        
P00172               PERFORM 2400-PROCESS-SEB-CUSTOMERS THRU 2400-EXIT  
P00172            END-IF                                                
               ELSE                                                     
                  IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL        
                     MOVE AT-PREMISE-NO             TO PR-PREMISE-NO    
                     MOVE AT-CODES-DATA-PRESENT     TO                  
                                                  WS-CODES-DATA-PRESENT 
A37061               IF AT-ACCOUNT-TYPE-CODE = 'R' OR 'C'               
                       PERFORM 7160-SELECT-MAX-DEP-REVIEW THRU 7160-EXIT
                       IF CONTINUE-REVIEW                               
                          MOVE 0               TO WS-TOTAL-PAYMENTS     
                                                  WS-TOTAL-REFUNDED     
                                                  WS-TOTAL-CREDIT-DEP   
                                                  WS-TOTAL-PYMTS-HOLDING
                                                  WS-REFUND-AMOUNT      
P00172                    PERFORM 7850-GET-TOTAL-PAID-REFUNDS           
P00172                                                    THRU 7850-EXIT
                          PERFORM 7900-GET-TOTAL-PAID-DEPS              
                                                          THRU 7900-EXIT
                          IF WS-TOTAL-REFUNDED > 0                      
                            PERFORM 7910-GET-TOTAL-CREDIT THRU 7910-EXIT
                          END-IF                                        
                          COMPUTE WS-TOTAL-PYMTS-HOLDING =              
                                               WS-TOTAL-PAYMENTS -      
                                               WS-TOTAL-REFUNDED +      
                                               WS-TOTAL-CREDIT-DEP      
                          IF  WS-TOTAL-PYMTS-HOLDING > 0                
                              PERFORM 2000-PROCESS-DEPOSIT-REVIEW       
                                                       THRU 2000-EXIT   
                          ELSE                                          
                             NEXT SENTENCE
                          END-IF                              
                       ELSE                                             
                          NEXT SENTENCE
                       END-IF                                 
                     ELSE                                               
                        NEXT SENTENCE
                     END-IF                                   
                  ELSE                                                  
                     NEXT SENTENCE                                      
P00172         END-IF                                                   
           END-IF
           END-IF.                                                      
      *                                                                         
           PERFORM 7001-READ-FCSDB07           THRU 7001-EXIT.          
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05519000
P00172*************************************************************             
P00172* LOAD THE DELINQUENCY VALUES.                              *             
P00172*************************************************************             
P00172*                                                                         
P00172 1100-LOAD-DELINQ-VALUES.                                         
P00172*                                                                         
A05091     MOVE 'SCANA SENIOR AGE' TO C8-DELINQ-CD                      
A05091     PERFORM 7050-SELECT-DELINQ-VALUE THRU 7050-EXIT.             
P00172*                                                                         
P00172     MOVE C8-DELINQ-VALUE           TO WS-SCANA-SR-AGE.           
P00172*                                                                         
P00172 1100-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                         
P00172*************************************************************             
P00172* PROCESS DELINQUENCY VALUES.                               *             
P00172*************************************************************             
P00172*                                                                         
P00172 1150-PROCESS-DELINQ-VALUES.                                      
P00172*                                                                         
P00172     IF LR-SENIOR-FL NOT = 'Y'                                    
P00172        MOVE AT-CUSTOMER-NO          TO CE-CUSTOMER-NO            
P00172        MOVE WS-C                    TO CE-CUSTOMER-TYPE          
P00172        MOVE WS-D                    TO CE-DOB-VERIFIED-CD        
P00172*                                                                         
P00172        PERFORM 7890-SELECT-CUST-STATS THRU 7890-EXIT             
P00172*                                                                         
P00172        IF CE-DATE-OF-BIRTH = SPACES                              
P00172           CONTINUE                                               
P00172        ELSE                                                      
P00172           MOVE WS-INPUT-DATE         TO WS-START-DATE            
P00172           MOVE CE-DATE-OF-BIRTH      TO WS-END-DATE              
P00172           PERFORM 7891-CALCULATE-AGE THRU 7891-EXIT              
P00677           IF WS-RESULT-YEAR >= WS-SCANA-SR-AGE AND               
P00677                                WS-DHR-ACCT-FL = 'Y'              
P00172              MOVE 'Y'                TO LR-SENIOR-FL             
P00172           END-IF                                                 
P00172        END-IF                                                    
P00172     END-IF                                                       
P00172*                                                                         
P00172     EVALUATE TRUE                                                
P00172        WHEN LR-REG-GROUP-CD = '100' AND LR-SENIOR-FL = 'N'       
P00677          MOVE 'GROUP1 '            TO  WS-WQ-GROUP               
P00677          MOVE 'DEPOSIT: '          TO  WS-WQ-MAX-DEP-LIT-SR(1:19)
P00172        WHEN LR-REG-GROUP-CD = '100' AND LR-SENIOR-FL = 'Y'       
P00677          MOVE 'GROUP1 '            TO  WS-WQ-GROUP               
P00677          MOVE 'SENIOR DEPOSIT: '   TO  WS-WQ-MAX-DEP-LIT-SR(1:19)
P00172        WHEN LR-REG-GROUP-CD = '200' AND LR-SENIOR-FL = 'N'       
P00677          MOVE 'GROUP2 '            TO  WS-WQ-GROUP               
P00677          MOVE 'DEPOSIT: '          TO  WS-WQ-MAX-DEP-LIT-SR(1:19)
P00172        WHEN LR-REG-GROUP-CD = '200' AND LR-SENIOR-FL = 'Y'       
P00677                                     AND WS-DHR-ACCT-FL = 'N'     
P00677          MOVE 'GROUP2 '            TO  WS-WQ-GROUP               
P00677          MOVE 'SENIOR DEPOSIT: '   TO  WS-WQ-MAX-DEP-LIT-SR(1:19)
P00677        WHEN LR-REG-GROUP-CD = '200' AND LR-SENIOR-FL = 'Y'       
P00677                                     AND WS-DHR-ACCT-FL = 'Y'     
P00677          MOVE 'GROUP2 '            TO  WS-WQ-GROUP               
P00677          MOVE 'DHR SENIOR DEPOSIT:' TO                           
P00677                                        WS-WQ-MAX-DEP-LIT-SR(1:19)
P00172      END-EVALUATE.                                               
P00172*                                                                         
P00172 1150-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                         
      ****************************************************************  08833000
      **  1805-GET-NEXT-BUSINESS-DAY                                **  09210000
      **      GETS THE NEXT BUSINESS DAY.  IF IT'S A SATURDAY OR    **  09220000
      **      A SUNDAY IT EXECUTES 1810- OTHERWISE IT CHECKS TO SEE **  09230000
      **      IF THE DAY IS A HOLIDAY.  IF SO, IT PERFORMS 1810-    **  09240000
      **      UNTIL THE NEXT BUSINESS DAY IS FOUND.                 **  09250000
      ****************************************************************  09260000
       1805-GET-NEXT-BUSINESS-DAY.                                      
      *                                                                 09280000
           MOVE WS-N                   TO WS-DATE-FOUND.                
           PERFORM 7097-GET-NEXT-DAY             THRU 7097-EXIT.        
           IF WS-DAY EQUAL 6 OR                                         
              WS-DAY EQUAL ZEROS                                        
               PERFORM 1810-GET-NEXT-DATE        THRU 1810-EXIT         
                   UNTIL DATE-IS-FOUND                                  
           ELSE                                                         
               MOVE WS-N               TO WS-ROW-EXISTS                 
               MOVE WS-HOLD-DATE       TO J8-HOLIDAY-DT                 
               PERFORM 7095-SELECT-HOLIDAY       THRU 7095-EXIT         
               IF ROW-EXISTS                                            
                   PERFORM 1810-GET-NEXT-DATE    THRU 1810-EXIT         
                       UNTIL DATE-IS-FOUND                              
               ELSE                                                     
                   MOVE WS-Y TO WS-DATE-FOUND                           
               END-IF                                                   
           END-IF.                                                      
      *                                                                 09460000
       1805-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  09500000
      **  1810-GET-NEXT-DATE                                        **  09510000
      **      GETS NEXT BUSINESS DAY.  IF IT'S SATURDAY OR SUNDAY,  **  09520000
      **      GET NEXT BUSINESS DAY, ELSE CHECK TO SEE IF THE DAY   **  09530000
      **      IS A HOLIDAY.  IF IT IS NOT, DATE IS FOUND.           **  09540000
      ****************************************************************  09550000
       1810-GET-NEXT-DATE.                                              
      *                                                                 09570000
           PERFORM 7097-GET-NEXT-DAY             THRU 7097-EXIT.        
           IF WS-DAY EQUAL 6 OR                                         
              WS-DAY EQUAL ZEROS                                        
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-N               TO WS-ROW-EXISTS                 
               MOVE WS-HOLD-DATE       TO J8-HOLIDAY-DT                 
               PERFORM 7095-SELECT-HOLIDAY       THRU 7095-EXIT         
               IF ROW-EXISTS                                            
                   CONTINUE                                             
               ELSE                                                     
                   MOVE WS-Y           TO WS-DATE-FOUND                 
               END-IF                                                   
           END-IF.                                                      
      *                                                                 09720000
       1810-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10490000
      *   2000-PROCESS-DEPOSIT-REVIEW                                  *10500000
      ******************************************************************10570000
       2000-PROCESS-DEPOSIT-REVIEW.                                     
      *                                                                 10601000
           PERFORM 2050-GET-MAX-DEPOSIT         THRU 2050-EXIT.         
           PERFORM 7660-OPEN-NOT-ELIG-EXISTS    THRU 7660-EXIT.         
           PERFORM 7665-FETCH-NOT-ELIG-EXISTS   THRU 7665-EXIT.         
           PERFORM 7670-CLOSE-NOT-ELIG-EXISTS   THRU 7670-EXIT.         
           MOVE ' '                       TO MG-MAX-DEP-REFUND-CD.      
           IF WS-MAX-DEPOSIT-AMT          = ZERO                        
              MOVE 'I'                     TO MG-MAX-DEP-REFUND-CD      
              MOVE WS-WORKQUEUE-I-COMMENTS TO WS-WQ-COMMENTS-LIT        
              PERFORM 2300-SEND-NO-REFUND-WQ    THRU 2300-EXIT          
           ELSE                                                         
              IF WS-TOTAL-PYMTS-HOLDING >  WS-MAX-DEPOSIT-AMT           
C28160           IF WS-CODE-REFUND-ELIG = 'Y'                           
C28160              COMPUTE WS-REFUND-AMOUNT = WS-TOTAL-PYMTS-HOLDING - 
C28160                                         WS-MAX-DEPOSIT-AMT       
C28160              MOVE 'X'                     TO MG-MAX-DEP-REFUND-CD
C28160              MOVE WS-WORKQUEUE-X-COMMENTS TO WS-WQ-COMMENTS-LIT  
C28160              PERFORM 2300-SEND-NO-REFUND-WQ       THRU 2300-EXIT 
C28160              DISPLAY '***WQ:  ', WS-WQ-COMMENTS-LIT, '***'       
C28160              DISPLAY WS-ACCOUNT-NO                               
C28160           END-IF                                                 
                 PERFORM 2100-CHECK-EXCEPTIONS  THRU 2100-EXIT          
              ELSE                                                      
                 MOVE 'N'                    TO MG-MAX-DEP-REFUND-CD    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF MG-MAX-DEP-REFUND-CD = 'R' OR                             
              AT-MAX-DEP-REF-XMT-CD = '1'                               
              PERFORM 5370-UPDATE-AT-FIELDS  THRU 5370-EXIT
           END-IF.            
           PERFORM 5380-UPDATE-MG-FIELDS     THRU 5380-EXIT.            
       2000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **  2050-GET-MAX-DEPOSIT                                       **         
      **  THIS PARAGRAPH RETRIEVES THE MAXIMUM ALLOWABLE DEPOSIT FOR **         
      **  AN ACCOUNT.  THE CALCULATION IS DONE IN CPD00308.          **         
      *****************************************************************         
       2050-GET-MAX-DEPOSIT.                                            
      *                                                                         
           MOVE AT-PREMISE-NO   TO    WS-PREMISE-NO.                    
           MOVE WS-Y            TO    WS-CALLING-BATCH-SW.              
           MOVE WS-INPUT-DATE   TO    WS-TEMP-BATCH-DATE                
                                      WS-DATE-CWS00308.                 
           PERFORM 5650-GET-MAX-DEPOSIT                                 
              THRU 5650-GET-MAX-DEPOSIT-EXIT.                           
      *                                                                         
       2050-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **  2100-CHECK-EXCEPTIONS                                      **         
      *****************************************************************         
       2100-CHECK-EXCEPTIONS.                                           
                                                                        
           COMPUTE WS-REFUND-AMOUNT = WS-TOTAL-PYMTS-HOLDING -          
                                      WS-MAX-DEPOSIT-AMT.               
C28160     IF MG-MAX-DEP-REFUND-CD = 'X'                                
C28160        CONTINUE                                                  
C28160     ELSE                                                         
              IF AT-MAX-DEP-REF-XMT-CD = 'L' OR '1'                     
                  MOVE 'E'                     TO MG-MAX-DEP-REFUND-CD  
                  MOVE WS-WORKQUEUE-E-COMMENTS TO WS-WQ-COMMENTS-LIT    
              ELSE                                                      
                  PERFORM 2200-OTHER-EXCEPTIONS       THRU 2200-EXIT    
              END-IF                                                    
                                                                        
C30980        IF MG-MAX-DEP-REFUND-CD = 'A' OR 'D' OR 'E' OR 'P'        
                 PERFORM 2300-SEND-NO-REFUND-WQ       THRU 2300-EXIT    
              ELSE                                                      
P00399           IF MG-MAX-DEP-REFUND-CD = 'L'                          
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE 'R'                TO MG-MAX-DEP-REFUND-CD     
                    PERFORM 5000-UPDATE                  THRU 5000-EXIT 
                 END-IF                                                 
              END-IF                                                    
C28160     END-IF.                                                      
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2200-OTHER-EXCEPTIONS.                                           
           IF WS-REFUND-AMOUNT > WS-AMT-MIN-REFUND-VALUE                
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'L' TO MG-MAX-DEP-REFUND-CD                          
              GO TO 2200-EXIT                                           
           END-IF.                                                      
           IF WS-CODE-PENDING-DNP EQUAL WS-A                            
               PERFORM 7290-SELECT-RECONNECT THRU 7290-EXIT             
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE 'D'                     TO MG-MAX-DEP-REFUND-CD  
                  MOVE WS-WORKQUEUE-D-COMMENTS TO WS-WQ-COMMENTS-LIT    
                  GO TO 2200-EXIT                                       
               END-IF                                                   
           END-IF.                                                      
           MOVE SPACE                      TO WS-ACTIVE-DEP-EXISTS.     
           PERFORM 7630-OPEN-ACTDEP-EXISTS      THRU 7630-EXIT.         
           PERFORM 7640-FETCH-ACTDEP-EXISTS     THRU 7640-EXIT.         
           PERFORM 7650-CLOSE-ACTDEP-EXISTS     THRU 7650-EXIT.         
           IF ACTIVE-DEP-EXISTS                                         
              MOVE 'A'                     TO MG-MAX-DEP-REFUND-CD      
              MOVE WS-WORKQUEUE-A-COMMENTS TO WS-WQ-COMMENTS-LIT        
              GO TO 2200-EXIT                                           
           END-IF.                                                      
      *                                                                 10687400
           PERFORM 7380-RECENT-PAID-DEP         THRU 7380-EXIT.         
           IF RECENT-PD-DEP-EXISTS                                      
              MOVE 'P'                     TO MG-MAX-DEP-REFUND-CD      
              MOVE WS-WORKQUEUE-P-COMMENTS TO WS-WQ-COMMENTS-LIT        
              GO TO 2200-EXIT                                           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-SEND-NO-REFUND-WQ.                                          
           INITIALIZE WS-COMMENTS.                                      
           MOVE ' '                            TO WS-WQ-PRIORITY.       
           MOVE WS-MAX-DEPOSIT-AMT             TO WS-WQ-MAX-DEPOSIT.    
           MOVE WS-TOTAL-PYMTS-HOLDING         TO WS-WQ-TOT-PD-DEPOSITS.
           MOVE WS-REFUND-AMOUNT               TO WS-WQ-REFUND.         
           MOVE WS-WQ-COMMENTS                 TO WS-COMMENTS-TEXT.     
P00677     MOVE +173                           TO WS-COMMENTS-LEN.      
P00172     IF CSR-DATABASE                                              
P00172        MOVE +265                        TO WS-WQ-CATEGORY        
P00172     ELSE                                                         
P00172        MOVE +185                        TO WS-WQ-CATEGORY        
P00172     END-IF.                                                      
           PERFORM 3500-CREATE-WORK-QUEUE             THRU 3500-EXIT.   
                                                                        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
P00172*                                                                         
P00172*****************************************************************         
P00172** 2400-PROCESS-SEB-CUSTOMERS.                                 **         
P00172**   PROCESS SEB REGULATED CUSTOMERS                           **         
P00172*****************************************************************         
P00172*                                                                         
P00172 2400-PROCESS-SEB-CUSTOMERS.                                      
P00172*                                                                         
P00172     INITIALIZE                           WS-TOTAL-PAYMENTS       
P00172                                          WS-TOTAL-REFUNDED       
P00172                                          WS-REFUND-AMOUNT        
P00172                                          WS-BILLED-DEP-EXISTS    
P00172                                          WS-XFER-DEP-EXISTS      
P00172                                          WS-COMMENTS-TEXT        
P00172                                          WS-TOTAL-CREDIT-DEP     
P00172                                          WS-TOTAL-PYMTS-HOLDING. 
P00172*                                                                         
P00172     MOVE WS-INPUT-DATE TO  WS-NEXT-DATE                          
P00172*                                                                         
A05091     PERFORM  2050-GET-MAX-DEPOSIT          THRU 2050-EXIT.       
P00172     PERFORM  1150-PROCESS-DELINQ-VALUES    THRU 1150-EXIT        
P00172     PERFORM  7880-CHECK-BILLED-DEP         THRU 7880-EXIT        
P00172     PERFORM  7881-CHECK-XFER-DEP           THRU 7881-EXIT        
P00172     PERFORM  7850-GET-TOTAL-PAID-REFUNDS   THRU 7850-EXIT        
P00172     PERFORM  7900-GET-TOTAL-PAID-DEPS      THRU 7900-EXIT        
P00172*                                                                         
P00172     IF WS-TOTAL-REFUNDED > 0                                     
P00172        PERFORM 7910-GET-TOTAL-CREDIT       THRU 7910-EXIT        
P00172     END-IF                                                       
P00172*                                                                         
P00172     COMPUTE  WS-TOTAL-PYMTS-HOLDING =                            
P00172                     WS-TOTAL-PAYMENTS - WS-TOTAL-REFUNDED +      
P00172                                         WS-TOTAL-CREDIT-DEP      
P00172*                                                                         
P00172     PERFORM 2600-PROCESS-DEPOSIT-REVIEW  THRU 2600-EXIT.         
P00172*                                                                         
P00172 2400-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                         
      *****************************************************************         
      ** 2500-GET-CUSTOMER-INFO ..                                   **         
      **   GETS CUST_ID FROM CUSTOMER TABLE AND THEN GETS NAME FROM  **         
      **   CSS_NAME TABLE                                            **         
      *****25**********************************************************         
       2500-GET-CUSTOMER-INFO.                                          
           PERFORM 7280-SELECT-CUSTOMER      THRU 7280-EXIT.            
           PERFORM 7285-SELECT-CUST-NAME     THRU 7285-EXIT.            
           IF DQ-NAME-FORMAT EQUAL 'B'                                  
               MOVE DQ-FULL-NAME TO WS-CUSTOMER-NAME                    
           ELSE                                                         
               PERFORM 3100-FORMAT-CUST-NAME THRU 3100-EXIT             
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00172*****************************************************************         
P00172** 2600-PROCESS-DEPOSIT-REVIEW                                 **         
P00172**                                                             **         
P00172*****************************************************************         
P00172 2600-PROCESS-DEPOSIT-REVIEW.                                     
P00172*                                                                         
P00172     IF WS-TOTAL-PYMTS-HOLDING >  WS-MAX-DEPOSIT-AMT              
P00172*                                                                         
P00677        MOVE 'N'                       TO MG-MAX-DEP-REFUND-CD    
P00172        COMPUTE WS-REFUND-AMOUNT = WS-TOTAL-PYMTS-HOLDING -       
P00172                                   WS-MAX-DEPOSIT-AMT             
P00172*                                                                         
P00172        IF BILLED-DEP-EXISTS OR XFER-DEP-EXISTS                   
P00172           MOVE WS-WORKQUEUE-B-COMMENTS TO WS-WQ-COMMENTS-LIT     
P00172           PERFORM 2300-SEND-NO-REFUND-WQ      THRU 2300-EXIT     
P00172        ELSE                                                      
P00172           PERFORM 2500-GET-CUSTOMER-INFO         THRU 2500-EXIT  
P00172           PERFORM 5000-UPDATE                    THRU 5000-EXIT  
A04064           PERFORM 5370-UPDATE-AT-FIELDS          THRU 5370-EXIT  
P00172        END-IF                                                    
P00172     ELSE                                                         
P00677        MOVE WS-BILLD-DEP-AMT  TO WS-WQ-TOT-BLD-DEPOSITS          
P00172        COMPUTE WS-BILLD-DEP-AMT = WS-TOTAL-PYMTS-HOLDING +       
P00172                                      WS-BILLD-DEP-AMT            
P00172        IF WS-BILLD-DEP-AMT > WS-MAX-DEPOSIT-AMT                  
P00677           COMPUTE WS-REFUND-AMOUNT = WS-BILLD-DEP-AMT -          
P00677                                      WS-MAX-DEPOSIT-AMT          
P00172           MOVE WS-WORKQUEUE-C-COMMENTS TO WS-WQ-COMMENTS-LIT     
P00172           PERFORM 2300-SEND-NO-REFUND-WQ   THRU 2300-EXIT        
P00172        END-IF                                                    
P00172     END-IF.                                                      
P00172*                                                                         
P00172*                                                                         
P00172 2600-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                         
      *****************************************************************         
      ** 3100-FORMAT-CUST-NAME ..                                    **         
      **     CONTROLS FORMAT OF CUSTOMER NAME BY PERFORMING ROUTINE  **         
      **      TO REDUCE EMBEDDED SPACES                              **         
      *****************************************************************         
       3100-FORMAT-CUST-NAME.                                           
      *                                                                         
           MOVE SPACES                 TO WS-EMB-INPUT.                 
           MOVE DQ-LAST-NAME           TO WS-LAST-NAME-BD.              
           MOVE DQ-FIRST-NAME          TO WS-FIRST-NAME-BD.             
           MOVE DQ-MIDDLE-NAME         TO WS-MIDDLE-NAME-BD.            
           MOVE WS-50                  TO WS-EMB-LENG.                  
           MOVE SPACES                 TO WS-CMP-TABLE.                 
           MOVE WS-NAME-BREAKDOWN      TO WS-EMB-INPUT.                 
           PERFORM 6010-REDUCE-EMBEDDED-SPACES   THRU 6010-EXIT.        
           MOVE WS-CMP-TABLE           TO WS-CUSTOMER-NAME.             
      *                                                                         
       3100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  11183800
      * 3500-CREATE-WORK-QUEUE                                          11184000
      ****************************************************************  11184200
       3500-CREATE-WORK-QUEUE.                                          
      *                                                                 11184500
A04860     INITIALIZE CWS00077-FIELDS.                                  
      *                                                                 11184900
A04860     MOVE AT-ACCOUNT-NO           TO WS-77-ACCOUNT-NO.            
A04860     MOVE AT-CUSTOMER-NO          TO WS-77-CUSTOMER-NO.           
A04860     MOVE AT-PREMISE-NO           TO WS-77-PREMISE-NO.            
A04860     MOVE AT-LOCAL-OFFICE         TO WS-77-LOCAL-OFFICE.          
A04860     MOVE WS-WQ-CATEGORY          TO WS-77-CATEGORY-ID.           
A04860     MOVE WS-COMMENTS-TEXT        TO WS-77-COMMENTS-TEXT.         
A04860     MOVE WS-COMMENTS-LEN         TO WS-77-COMMENTS-LEN.          
A04860     MOVE 4                       TO WS-77-ROUTE-CATEGORY.        
A04860     IF WS-WQ-PRIORITY  = 'H'                                     
A04860         MOVE 'H'                 TO WS-77-PRIORITY               
A04860     ELSE                                                         
A04860         MOVE 'N'                 TO WS-77-PRIORITY               
A04860     END-IF.                                                      
A04860     MOVE WS-INPUT-DATE           TO WS-INPUT-DATE-TS.            
A04860     MOVE WS-INPUT-TS             TO WS-77-DATE-CREATED.          
A04860     MOVE WS-NEXT-DATE            TO WS-NEXT-DATE-TS.             
A04860     MOVE WS-NEXT-TS              TO WS-77-DATE-REQUIRED.         
A04860     MOVE WS-PGRMNAME             TO WS-77-CREATED-BY.            
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
                                                                        
       3500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11230000
      *   5000-UPDATE.                                                 *11240000
      ******************************************************************11290000
      *                                                                 11291000
       5000-UPDATE.                                                     
      *                                                                 11310000
           PERFORM 7000-GET-DATES                  THRU 7000-EXIT.      
           MOVE WS-CURRENT-TIMESTAMP       TO WS-THIS-TIMESTAMP.        
           MOVE AT-PREMISE-NO              TO PR-PREMISE-NO             
                                              WS-100-PREMISE-NO.        
           PERFORM 7260-SELECT-PREMISE             THRU 7260-EXIT.      
           MOVE AT-COMPANY-NO              TO P6-COMPANY-NO             
                                              WS-100-COMPANY-NO.        
           MOVE AT-LOCAL-OFFICE            TO P6-LOCAL-OFFICE           
                                              WS-100-LOCAL-OFFICE-CD.   
           MOVE PR-REV-DISTRICT-CD         TO P6-REV-DISTRICT-CD.       
           PERFORM 5250-LOAD-GL-NUMBERS            THRU 5250-EXIT.      
           PERFORM 5300-PROCESS-DEPOSIT            THRU 5300-EXIT.      
      *                                                                 11640000
       5000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 14180000
      * 5090-SET-UP-REFUND                                            * 14190000
      *      ASSIGN VALUES TO THE COLUMNS OF CSS_REFUND BEFORE INSERT * 14210000
      ***************************************************************** 14220000
      *                                                                 14230000
       5090-SET-UP-REFUND.                                              
           INITIALIZE RN-ACCT-NO-CREDITED.                              
           IF WS-LAST-REFUND-ITEM-ID = 0                                
              PERFORM 7100-GET-REFUND-ITEM-ID     THRU 7100-EXIT        
           END-IF.                                                      
      *                                                                 14291000
           ADD 1                         TO WS-LAST-REFUND-ITEM-ID.     
           MOVE WS-LAST-REFUND-ITEM-ID   TO RN-REFUND-ITEM-ID.          
           MOVE WS-O                     TO RN-CHECK-ISS-REAS-CD.       
           MOVE +24                      TO RN-COMMENTS-LEN.            
           MOVE 'OVER MAX - YEARLY REVIEW'  TO RN-COMMENTS-TEXT.        
           MOVE DO-DEPOSIT-CERT-NO       TO RN-DEPOSIT-CERT-NO          
           MOVE 'SYSTEM'                 TO RN-USER-ID-RQSTED-BY.       
           MOVE ' '                      TO RN-PANEL-NO.                
           MOVE WS-CURRENT-TIMESTAMP     TO RN-TRANS-HIST-SEQ-NO.       
           MOVE 0                        TO RN-ADDRESS-ID.              
           MOVE SPACES                   TO RN-REFUND-CHECK-NO,         
                                            RN-ORIGINAL-CHECK-NO,       
                                            RN-RETURNED-REASON.         
           MOVE AT-LOCAL-OFFICE          TO RN-LOCAL-OFFICE.            
           PERFORM 8200-INSERT-REFUND    THRU 8200-EXIT.                
      *                                                                 14640000
       5090-EXIT.                                                       
           EXIT.                                                        
       5250-LOAD-GL-NUMBERS.                                            
      *                                                                 16780000
           MOVE WS-PGRMNAME                   TO                        
                                          WS-CPD00061-CALLING-PGM.      
           MOVE SPACES                        TO  ABEND-FUNCTION.       
           CALL SCSCB061 USING  WS-GL-ACCT-NAME,                        
                                WS-GL-ACCT-MAJOR-FIELDS,                
                                WS-VALID-COMPANY-NOS,                   
                                WS-GL-NAME-INFO,                        
                                WS-GL-ACCT-NO-TABLE,                    
                                WS-CPD00061-CALLING-PGM,                
                                ABEND-FILE,                             
                                RS-RETURN-CODE                          
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                 16920000
       5250-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 16970000
      * 5300-PROCESS-DEPOSIT                                          * 16980000
      *     RETRIEVE DEPOSIT DETAILS.                                 * 17000000
      *     IF REFUND OF INTEREST IS DUE, THEN COMPUTE INTEREST,      * 17030000
      *        UPDATE INTRST-HISTORY AND REFUND THE INTEREST          * 17040000
      ***************************************************************** 17070000
       5300-PROCESS-DEPOSIT.                                            
*******   ASCENDING DATE ORDER AND PAID STATUS.                                 
           PERFORM 7310-OPEN-DEP-ON-HAND                THRU 7310-EXIT. 
           PERFORM 7320-FETCH-DEP-ON-HAND               THRU 7320-EXIT. 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE SPACES             TO RN-CHECK-STATUS-CD             
              MOVE 'A'                TO RN-MANUAL-INDICATOR            
              MOVE SPACES             TO RN-USER-ID-APPRVD-BY           
                                                                        
              MOVE WS-REFUND-DATE     TO RN-DATE-REFUNDED               
                                         RN-REFUND-STATUS-DT            
                                         RN-REQUEST-DT                  
              MOVE +0                 TO WS-PAR-TRAN-APPL-NO            
                                         WS-100-JRNL-TRAN-APPL-NO       
                                         AU-TRAN-APPL-NO                
                                         WS-THIS-TRAN-APPL-NO           
              IF DO-AMT-DEPOSIT > 0 AND WS-REFUND-AMOUNT > 0            
                 PERFORM 5995-DEPOSIT-INTEREST-CALC  THRU 5995-EXIT     
                 IF WS-INTEREST-CALC  > 0                               
                    PERFORM 5320-REFUND-INTEREST     THRU 5320-EXIT     
                 END-IF                                                 
                 IF DO-AMT-DEPOSIT  >  WS-REFUND-AMOUNT                 
                    MOVE WS-REFUND-AMOUNT   TO RN-AMT-REFUNDED          
                                               WS-PAYMENT-AMOUNT        
                    ADD WS-INTEREST-CALC    TO RN-AMT-REFUNDED          
                    MOVE ZERO               TO WS-INTEREST-CALC         
                    PERFORM 5090-SET-UP-REFUND       THRU 5090-EXIT     
                    PERFORM 5330-REFUND-DEPOSIT      THRU 5330-EXIT     
??????              SUBTRACT WS-REFUND-AMOUNT FROM DO-AMT-DEPOSIT       
                    ADD WS-REFUND-AMOUNT      TO   DO-AMT-REFUNDED      
                    MOVE 0                    TO   WS-REFUND-AMOUNT     
                 ELSE                                                   
                    MOVE DO-AMT-DEPOSIT       TO   RN-AMT-REFUNDED      
                                                   WS-PAYMENT-AMOUNT    
                    ADD WS-INTEREST-CALC      TO   RN-AMT-REFUNDED      
                    MOVE ZERO                 TO   WS-INTEREST-CALC     
                    PERFORM 5090-SET-UP-REFUND       THRU 5090-EXIT     
                    PERFORM 5330-REFUND-DEPOSIT      THRU 5330-EXIT     
                    SUBTRACT DO-AMT-DEPOSIT   FROM WS-REFUND-AMOUNT     
                    ADD DO-AMT-DEPOSIT        TO   DO-AMT-REFUNDED      
                    MOVE 0                    TO   DO-AMT-DEPOSIT       
                 END-IF                                                 
              END-IF                                                    
              MOVE DO-DEPOSIT-CERT-NO    TO DP-DEPOSIT-CERT-NO          
              MOVE 0                     TO WS-TOTAL-PAYMENTS-BY-DEP    
              PERFORM 7990-SELECT-DEP-PAY-AMT        THRU 7990-EXIT     
              IF DO-AMT-DEPOSIT < WS-TOTAL-PAYMENTS-BY-DEP              
                 MOVE SPACES             TO DO-CODE-REFUND-STATUS       
                 MOVE 'P'                TO DO-DEPOSIT-STATUS-CD        
                 IF DO-DATE-CERT-ISSUE EQUAL SPACES                     
P00394              MOVE WS-REFUND-DATE   TO DO-DATE-CERT-ISSUE         
                 END-IF                                                 
                 MOVE WS-YES             TO WS-UPDATE-FLAG              
              END-IF                                                    
              IF DO-AMT-DEPOSIT < 0 OR DO-AMT-DEPOSIT = 0               
                 MOVE '0'                TO DO-CODE-REFUND-STATUS       
                 MOVE 'R'                TO DO-DEPOSIT-STATUS-CD        
                 MOVE WS-YES             TO WS-UPDATE-FLAG              
              END-IF                                                    
              IF UPDATE-IS-NEEDED                                       
                 PERFORM 8530-UPDATE-AR-HIST            THRU 8530-EXIT  
              END-IF                                                    
              MOVE WS-NO                 TO WS-UPDATE-FLAG              
              PERFORM 8400-UPDATE-DEP-ON-HAND           THRU 8400-EXIT  
              PERFORM 7320-FETCH-DEP-ON-HAND            THRU 7320-EXIT  
           END-PERFORM.                                                 
           PERFORM 7330-CLOSE-DEP-ON-HAND               THRU 7330-EXIT. 
       5300-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 18510000
      * 5320-REFUND-INTEREST                                          * 18520000
      ***************************************************************** 18540000
       5320-REFUND-INTEREST.                                            
      *                                                                 18584100
           MOVE WS-INTEREST-CALC         TO WS-PAYMENT-AMOUNT           
                                            WS-PAYMENT-AMOUNT-TOTAL.    
           ADD WS-INTEREST-CALC          TO DO-INTRST-YTD               
                                            DO-TOTAL-INTRST.            
           MOVE 'SYSTEM'                 TO DO-USER-ID-UPDT-BY.         
P00394     MOVE WS-REFUND-DATE           TO DO-DATE-INTST-CALC-TO.      
           MOVE 0                        TO WS-DATE-INTST-CALC-TO-NI.   
      *                                                                 18660000
           MOVE WS-DEP-INT-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB.     
           MOVE ZEROES                   TO WS-PAR-TYPE                 
                                            WS-PAR-TYPE-NO              
           MOVE 'Y'                      TO WS-DEPOSIT-REFUND-SW.       
           MOVE DO-DEPOSIT-CERT-NO       TO WS-INT-DEP-CERT-NO.         
           MOVE WS-AR-INT-COMMENT-TEXT   TO WS-PAR-AR-TRAN-COMMENT-TEXT.
           MOVE +69                      TO WS-PAR-AR-TRAN-COMMENT-LEN. 
           PERFORM 5500-CALL-APPLY-PAYMENT   THRU 5500-EXIT.            
           MOVE AU-TRAN-APPL-NO          TO WS-PAR-TRAN-APPL-NO         
                                            WS-THIS-TRAN-APPL-NO        
                                            WS-100-JRNL-TRAN-APPL-NO.   
           MOVE AR-TRANS-HIST-SEQ-NO     TO AU-TRANS-HIST-SEQ-NO        
                                            WS-THIS-TIMESTAMP.          
           MOVE 'N'                      TO WS-DEPOSIT-REFUND-SW.       
           MOVE ZEROES                   TO WS-PAYMENT-AMOUNT           
                                            WS-PAYMENT-AMOUNT-TOTAL.    
      *                                                                 18900000
       5320-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 19660000
      * 5330-REFUND-DEPOSIT                                           * 19670000
      ***************************************************************** 19690000
       5330-REFUND-DEPOSIT.                                             
      *                                                                 19720000
           MOVE WS-DEP-DEP-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB.     
           MOVE DO-DEPOSIT-CERT-NO           TO WS-DEP-CERT-NO.         
           MOVE WS-AR-DEP-COMMENT-TEXT       TO                         
                                            WS-PAR-AR-TRAN-COMMENT-TEXT.
           MOVE +57                          TO                         
                                            WS-PAR-AR-TRAN-COMMENT-LEN. 
           MOVE 'Y'                          TO WS-DEPOSIT-REFUND-SW.   
           PERFORM 5500-CALL-APPLY-PAYMENT   THRU 5500-EXIT.            
           MOVE 'N'                          TO WS-DEPOSIT-REFUND-SW.   
           MOVE ZEROES                       TO WS-PAYMENT-AMOUNT       
                                                WS-PAYMENT-AMOUNT-TOTAL.
           IF AR-AMT-ORIG-ENTERED = RN-AMT-REFUNDED                     
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 8535-UPDATE-AR-TRANS-HIST THRU 8535-EXIT          
           END-IF.                                                      
                                                                        
       5330-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************23090000
      * 5370-UPDATE-CODES-DATA-PRESENT                                 *23100000
      *    -- THIS MODULE CHECKS IF ANY DEP_ON_HAND RECORD             *23110000
      *       PRESENT TO UPDATE THE CODES_DATA_PRESENT OF CSS_ACCOUNT  *23120000
      *       ALSO UPDATE AT-MAX-DEP-REF-XMT-CD IF NECESSARY.          *        
      ******************************************************************23130000
       5370-UPDATE-AT-FIELDS.                                           
      *                                                                 23161000
           PERFORM 7250-SELECT-ACCOUNT       THRU 7250-EXIT.            
           MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT.       
           MOVE SPACES                  TO WS-CODE-DEP-ON-HAND.         
A04064     PERFORM 7600-OPEN-DEP-EXISTS      THRU 7600-OPEN-EXIT.       
A04064     PERFORM 7610-FETCH-DEP-EXISTS     THRU 7610-FETCH-EXIT.      
A04064     PERFORM 7615-CLOSE-DEP-EXISTS     THRU 7615-EXIT.            
             IF WS-DEP-ON-HAND-EXISTS = 'N'                             
                MOVE SPACES             TO WS-CODE-DEP-ON-HAND          
             ELSE                                                       
                MOVE WS-A               TO WS-CODE-DEP-ON-HAND          
             END-IF.                                                    
           MOVE WS-CODES-DATA-PRESENT   TO AT-CODES-DATA-PRESENT.       
           IF AT-MAX-DEP-REF-XMT-CD  =  '1'                             
              MOVE SPACE                  TO AT-MAX-DEP-REF-XMT-CD      
           END-IF.                                                      
           PERFORM 8520-UPDATE-ACCOUNT       THRU 8520-EXIT.            
      *                                                                 23430000
       5370-EXIT.                                                       
           EXIT.                                                        
      *                                                                 23460000
       5380-UPDATE-MG-FIELDS.                                           
P00394     MOVE WS-REFUND-DATE          TO MG-LAST-MAX-AT-REV-DT.       
           MOVE WS-TOTAL-PYMTS-HOLDING  TO MG-PD-DEP-AT-REV-AM.         
           MOVE WS-MAX-DEPOSIT-AMT      TO MG-MAX-DEP-AT-REV-AM.        
           PERFORM 8525-UPDATE-MAX-DEP       THRU 8525-EXIT.            
           IF WS-ACTIVE-RETURN-CODE      = NOT-FOUND                    
               PERFORM 8526-INSERT-MAX-DEP   THRU 8526-EXIT             
           END-IF.                                                      
                                                                        
       5380-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 23470000
      * 5500-CALL-APPLY-PAYMENT                                       * 23480000
      *     INITIALISE ALL THE WORKING STORAGES REQUIRED BEFORE       * 23500000
      *     CALLING 6700-APPLY-PAYMENT (CPD00010)                     * 23510000
      ***************************************************************** 23520000
       5500-CALL-APPLY-PAYMENT.                                         
      *                                                                 23550000
           PERFORM 7250-SELECT-ACCOUNT   THRU 7250-EXIT.                
           MOVE AT-CUSTOMER-NO           TO CU-CUSTOMER-NO.             
           MOVE AT-PREMISE-NO            TO PR-PREMISE-NO.              
           PERFORM 7280-SELECT-CUSTOMER  THRU 7280-EXIT.                
           PERFORM 7260-SELECT-PREMISE   THRU 7260-EXIT.                
           MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT.      
           MOVE AT-ACCOUNT-NO            TO DL-ACCOUNT-NO.              
           PERFORM 7290-SELECT-RECONNECT THRU 7290-EXIT.                
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                   TO WS-PAR-RECONNECT-EXIST      
           ELSE                                                         
              MOVE 'N'                   TO WS-PAR-RECONNECT-EXIST      
           END-IF.                                                      
           MOVE 'N'                   TO WS-IS-THIS-DIRECTED-PYMT       
           MOVE 1                     TO C9-PMT-PRTY-SCHEDULE           
           PERFORM 6722B-OPEN-AR-PMT-PRTY THRU 6722B-EXIT               
           PERFORM 6722C-FETCH-AR-PMT-PRTY THRU 6722C-EXIT              
           PERFORM 6722D-LOAD-AR-PMT-PRTY  THRU 6722D-EXIT              
              VARYING WS-PAR-SUB FROM 1 BY 1                            
                 UNTIL WS-PAR-SUB > 52                                  
                    OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           PERFORM 6722E-CLOSE-AR-PMT-PRTY  THRU 6722E-EXIT.            
           PERFORM 5550-SAVE-DEP-ON-HAND      THRU 5550-EXIT.           
           MOVE WS-THIS-TIMESTAMP     TO WS-CURRENT-TIMESTAMP           
                                         AR-TRANS-HIST-SEQ-NO           
                                         AU-TRANS-HIST-SEQ-NO.          
           MOVE WS-PAYMENT-AMOUNT     TO WS-PAYMENT-AMOUNT-TOTAL        
                                         WS-AMT-CASH.                   
           MOVE 'R'                   TO WS-PAR-CODE-TRAN-TYPE.         
           MOVE AT-COMPANY-NO         TO WS-PAR-COMPANY-NO.             
           MOVE AT-LOCAL-OFFICE       TO WS-PAR-LOCAL-OFFICE.           
           MOVE WS-CASH-REPORT-NO     TO WS-PAR-REPORT-NO.              
P00394     MOVE WS-REFUND-DATE        TO WS-PAR-REPORT-DATE.            
           MOVE WS-CASH-DRAWER-ID     TO WS-PAR-CASH-DRAWER.            
           MOVE AT-LOCAL-OFFICE       TO WS-PAR-ACCESS-LOC.             
           MOVE 'SYSTEM'              TO WS-PAR-OPERATOR-ID.            
           MOVE SPACES                TO WS-PAR-RESP-AREA               
                                         PF-RESP-AREA-ID.               
           MOVE 'PCSCA098'            TO WS-PAR-APPL-PROG-ID.           
           MOVE 'Y'                   TO WS-THIS-ACCOUNT-SW.            
           MOVE SPACES                TO WS-PAR-PYMT-FACILITY-CD        
                                         WS-PAR-PAY-AHEAD               
                                         WS-PAR-PAY-CHRG-OFF.           
           MOVE 'A098'                TO WS-100-CODE-TERMINAL-TRAN      
                                         WS-PAR-EIBTRNID.               
           MOVE 'B'                   TO WS-100-CODE-ENTRY-SOURCE       
                                         WS-JRNL-SOURCE-CODE.           
           MOVE SPACES                TO WS-100-TRANS-ERRORS.           
           PERFORM 6700-APPLY-PAYMENT    THRU 6700-EXIT.                
           PERFORM 5555-RESTORE-DEP-ON-HAND      THRU 5555-EXIT.        
           IF PYMT-WAS-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5500'                TO ACTIVE-PARAGRAPH            
              MOVE 'USERABEN'            TO ABEND-FUNCTION              
              MOVE 'Y'                   TO WS-USER-FORCE-ABEND         
              MOVE 'PAYMENT ABEND'       TO DSNTIAR-MESSAGE-1           
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 24460000
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25350000
           EXEC SQL                                                     27340000
              INCLUDE CPD00312                                          27350000
           END-EXEC.                                                    27360000
       5550-SAVE-DEP-ON-HAND.                                           
      *                                                                 25840000
           MOVE DO-ACCOUNT-NO         TO WS-DO-ACCOUNT-NO.              
           MOVE DO-DEPOSIT-CERT-NO    TO WS-DO-DEPOSIT-CERT-NO.         
           MOVE DO-AMT-DEPOSIT        TO WS-DO-AMT-DEPOSIT.             
           MOVE DO-DATE-INTST-CALC-TO TO WS-DO-DATE-INTST-CALC-TO.      
           MOVE DO-INTRST-YTD         TO WS-DO-INTRST-YTD.              
           MOVE DO-TOTAL-INTRST       TO WS-DO-TOTAL-INTRST.            
           MOVE DO-CODE-REFUND-STATUS TO WS-DO-CODE-REFUND-STATUS.      
           MOVE DO-DEPOSIT-STATUS-CD  TO WS-DO-DEPOSIT-STATUS-CD.       
           MOVE DO-AMT-REFUNDED       TO WS-DO-AMT-REFUNDED.            
      *                                                                 25950000
       5550-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25980000
       5555-RESTORE-DEP-ON-HAND.                                        
      *                                                                 26000000
           MOVE WS-DO-ACCOUNT-NO          TO  DO-ACCOUNT-NO.            
           MOVE WS-DO-DEPOSIT-CERT-NO     TO  DO-DEPOSIT-CERT-NO.       
           MOVE WS-DO-AMT-DEPOSIT         TO  DO-AMT-DEPOSIT.           
           MOVE WS-DO-DATE-INTST-CALC-TO  TO  DO-DATE-INTST-CALC-TO.    
           MOVE WS-DO-INTRST-YTD          TO  DO-INTRST-YTD.            
           MOVE WS-DO-TOTAL-INTRST        TO  DO-TOTAL-INTRST.          
           MOVE WS-DO-CODE-REFUND-STATUS  TO  DO-CODE-REFUND-STATUS.    
           MOVE WS-DO-DEPOSIT-STATUS-CD   TO  DO-DEPOSIT-STATUS-CD.     
           MOVE WS-DO-AMT-REFUNDED        TO  DO-AMT-REFUNDED.          
      *                                                                 26110000
       5555-EXIT.                                                       
           EXIT.                                                        
********************************************************************            
******* 6010-REDUCE-EMBEDDED-SPACES                                             
********************************************************************            
       COPY CPD00004.                                                           
      ****************************************************************          
      ************************                                          27020000
           EXEC SQL                                                     27030000
             INCLUDE CPD00003                                           27030100
           END-EXEC.                                                    27030200
      ***********************************************************               
      * INCLUDE CPD00023 CALCULATE DEPOSIT INTEREST                             
      ***********************************************************               
           EXEC SQL                                                             
               INCLUDE CPD00023                                                 
           END-EXEC.                                                            
      ************************************************************              
      * INCLUDE CPD00128 INSERT/UPDATE DEPOSIT INTEREST HISTORY                 
      ************************************************************              
           EXEC SQL                                                             
               INCLUDE CPD00128                                                 
           END-EXEC.                                                            
       6400-ONLINE-JRNL-ROUTINE.                                        
           GO TO 6400-BATCH-JRNL-ROUTINE.                               
HPCCDM*EJECT                                                                    
      *************************************************************             
      * BATCH JOURNAL ROUTINE. 6400-BATCH-JRNL-ROUTINE.           *             
      *************************************************************             
           EXEC SQL                                                             
               INCLUDE CPD00007                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *************************************************************             
      * 6500-ONLINE-LOAD-AR-TRAN-HIST. ROUITNE TO LOAD THE AR     *             
      * TRANSACTION HEADER AND DETAIL DATABASE ROWS.              *             
      *************************************************************             
           EXEC SQL                                                             
               INCLUDE CPD00008                                                 
           END-EXEC.                                                            
      ******************************************************************27050000
      *  JOURNALING COPYBOOK.                                          *27060000
      ******************************************************************27070000
           EXEC SQL                                                             
              INCLUDE CPD00308                                                  
           END-EXEC.                                                            
      * PARAGRAPH 6251-GET-FJC01-DATE IS IN CPD00037                            
       COPY CPD00037.                                                           
      * PARAGRAPH 6240-GET-FCA00-COMMON-DATE IS IN CPD00040                     
       COPY CPD00040.                                                           
       COPY CPD00010.                                                   27350000
      *                                                                 27331000
           EXEC SQL                                                     27340000
              INCLUDE CPD0010S                                          27350000
           END-EXEC.                                                    27360000
                                                                        
           EXEC SQL                                                     27380000
              INCLUDE CPD00073                                          27390000
           END-EXEC.                                                    27400000
      *                                                                 27490000
HPCCDM*EJECT                                                            27500000
      ***************************************************************** 27520000
      * 7000-GET-DATES                                                * 27530000
      *      GET CURRENT DATE AND TIMESTAMP TO UPDATE THE JOURNALS    * 27550000
      ***************************************************************** 27560000
       7000-GET-DATES.                                                  
      *                                                                 27590000
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     27600000
MFA-TR*       SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP             27610000
MFA-TR*          ,:WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*    END-EXEC                                                     27720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27730000
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
      *                                                                 27730000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              DISPLAY '* 7000-                                *'        
              DISPLAY '* AT-ACCOUNT-NO ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 27870000
P00394     EXEC SQL                                                     
P00394        SELECT
              DATEADD( MONTH, -11, IIF(TRY_CONVERT(DATE, 
                                                       :WS-INPUT-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE-1
              ) <> 0) OR (LEN(:WS-INPUT-DATE-1) <> 10), CIS.CHAR2DATE(
                                                       :WS-INPUT-DATE-1
              ), CONVERT(DATE, :WS-INPUT-DATE-1) ) ),
              DATEADD( MONTH, -13, IIF(TRY_CONVERT(DATE, 
                                                       :WS-INPUT-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE-1
              ) <> 0) OR (LEN(:WS-INPUT-DATE-1) <> 10), CIS.CHAR2DATE(
                                                       :WS-INPUT-DATE-1
              ), CONVERT(DATE, :WS-INPUT-DATE-1) ) )
            INTO
              :WS-DATE-11-MNT-AGO,
              :WS-DATE-13-MNT-AGO   
P00394     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     27600000
MFA-TR*       SET :WS-DATE-11-MNT-AGO =                                         
MFA-TR*                            DATE(:WS-INPUT-DATE-1) - 11 MONTHS           
MFA-TR*          ,:WS-DATE-13-MNT-AGO =                                         
MFA-TR*                            DATE(:WS-INPUT-DATE-1) - 13 MONTHS           
MFA-TR*    END-EXEC                                                     27720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00394*                                                                 27730000
P00394     MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE              
P00394*                                                                 27730000
P00394     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00394        NEXT SENTENCE                                             
P00394     ELSE                                                         
P00394        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00394        DISPLAY '* 7000-                                *'        
P00394        DISPLAY '* SET XX MONTHS AGO DATES              *'        
P00394        DISPLAY '* AT-ACCOUNT-NO ', AT-ACCOUNT-NO                 
P00394        DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
P00394        DISPLAY '* PROGRAM ABORTING...                  *'        
P00394        PERFORM 9900-ABEND              THRU 9900-EXIT            
P00394     END-IF.                                                      
P00394*                                                                 27870000
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *     7001-READ-FCSDB07                                          *        
      *      MAIN DRIVER.   READS THE DAILY BILLING FILE               *        
      ******************************************************************        
       7001-READ-FCSDB07.                                               
      *                                                                         
           READ FCSDB07-FILE                                            
               AT END                                                   
                   MOVE WS-Y                   TO WS-END-OF-FILE        
                   GO TO 7001-EXIT                                      
           END-READ.                                                    
      *                                                                         
       7001-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * DECLARE AND OPEN MAIN CURSOR OF THE CSS_AR_CNTL TABLE.        *         
      *                                                                         
      ******************************************************************        
      *   RETRIEVE REVENUE MONTH FROM CSS_JOB_PARM                     *        
      ******************************************************************        
       7020-GET-REVENUE-MONTH.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT (CIS.SUBSTR3(PARM_DATA,15,6))                          
                 INTO :WS-REV-DT                                        
                 FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                        
                WHERE PROGRAM_NAME = 'COMMON'                           
                  AND CMND_CODE    = 'DATE'                             
                  AND COMPANY_NO   = '01'                               
                  AND SEQ_NO       = 20                                 
                  AND STATUS       = 'A'                                
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT (SUBSTR(PARM_DATA,15,6))                                  
MFA-TR*          INTO :WS-REV-DT                                                
MFA-TR*          FROM CSS_JOB_PARM                                              
MFA-TR*         WHERE PROGRAM_NAME = 'COMMON'                                   
MFA-TR*           AND CMND_CODE    = 'DATE'                                     
MFA-TR*           AND COMPANY_NO   = '01'                                       
MFA-TR*           AND SEQ_NO       = 20                                         
MFA-TR*           AND STATUS       = 'A'                                        
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**  ERROR ON 7020-GET-REVENUE-MONTH   **'        
              DISPLAY '**  COULD NOT GET REVENUE MONTH       **'        
              DISPLAY '**  RETURN CODE    = ' SQLCODE                   
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **  DB2 CALLS                                                   **        
      ** SELECTS DELINQUENCY VALUE FOR DELINQ CODE 'AMT-EPPDELINQ'    **        
      ******************************************************************        
       7050-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA099 ABORT **************'       
               DISPLAY '* 7050-SELECT-DELINQ-VALUE             *'       
               DISPLAY '* DELINQ CD ', C8-DELINQ-CD                     
               DISPLAY '* COMPANY NO', C8-COMPANY-NO                    
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA099 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  11472000
      **  7095-SELECT-HOLIDAY                                       **  11474000
      **      CHECKS CSS_HOLIDAY TABLE TO SEE IF DATE IS A HOLIDAY. **  11475000
      ****************************************************************  11477000
       7095-SELECT-HOLIDAY.                                             
      *                                                                 11479000
           EXEC SQL                                                     
                SELECT DISTINCT ('Y')                                   
                  INTO :WS-ROW-EXISTS                                   
                FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                          
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                       
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11479100
MFA-TR*         SELECT DISTINCT ('Y')                                   11479200
MFA-TR*           INTO :WS-ROW-EXISTS                                   11479300
MFA-TR*         FROM CSS_HOLIDAY                                        11479400
MFA-TR*         WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                       11479500
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    11479600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11479700
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSCA098 ******************'     
               DISPLAY '** 7095 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************** PCSCA098 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 11480900
       7095-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  11490000
      **  7097-GET-NEXT-DAY                                         **  11510000
      **      SELECTS THE DATE PLUS ONE DAY IN ORDER TO GET THE     **  11520000
      **      NEXT VALID BUSINESS DAY.                              **  11530000
      ****************************************************************  11540000
       7097-GET-NEXT-DAY.                                               
      *                                                                 11560000
           EXEC SQL                                                     
              SELECT DISTINCT(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) )),            
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) ))                       
              - (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) ))/7 * 7)     
                  INTO :WS-HOLD-DATE,                                   
                       :WS-DAY                                          
               FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                           
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     11570000
MFA-TR*       SELECT DISTINCT(DATE(:WS-HOLD-DATE) + 1 DAYS),            11580000
MFA-TR*       DAYS (DATE(:WS-HOLD-DATE) + 1 DAYS)                       11590000
MFA-TR*       - (INTEGER(DAYS(DATE(:WS-HOLD-DATE) + 1 DAYS)/7) * 7)     11600000
MFA-TR*           INTO :WS-HOLD-DATE,                                   11610000
MFA-TR*                :WS-DAY                                          11620000
MFA-TR*        FROM CSS_HOLIDAY                                         11630000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    11640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11650000
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 11670000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************* PCSCA098 *******************'     
               DISPLAY '** 7097 :  RETURN CODE ERROR'                   
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '************* PCSCA098 *******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                 11770000
       7097-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 28211000
      * 7100-GET-REFUND-ITEM-ID                                       * 28220000
      *     GET THE LAST REFUND-ITEM-ID USED FOR THE ACCOUNT IN       * 28240000
      *     CSS_REFUND TABLE                                          * 28250000
      ***************************************************************** 28260000
       7100-GET-REFUND-ITEM-ID.                                         
      *                                                                 28290000
           EXEC SQL                                                     
              SELECT MAX(REFUND_ITEM_ID)                                
              INTO   :WS-LAST-REFUND-ITEM-ID :WS-REFUND-ITEM-ID-NI       
              FROM   CSS_REFUND WITH(READUNCOMMITTED)                           
              WHERE  ACCOUNT_NO = :RN-ACCOUNT-NO                        
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28300000
MFA-TR*       SELECT MAX(REFUND_ITEM_ID)                                28310000
MFA-TR*       INTO   :WS-LAST-REFUND-ITEM-ID:WS-REFUND-ITEM-ID-NI       28320000
MFA-TR*       FROM   CSS_REFUND                                         28330000
MFA-TR*       WHERE  ACCOUNT_NO = :RN-ACCOUNT-NO                        28340000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    28350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28360000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-REFUND-ITEM-ID-NI < 0                               
                 MOVE 0      TO WS-LAST-REFUND-ITEM-ID                  
              END-IF                                                    
           ELSE                                                         
               DISPLAY '* 7100-GET-REFUND-ITEM-ID              *'       
               DISPLAY '* ACCOUNT-NO    ', RN-ACCOUNT-NO                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               DISPLAY '* PROGRAM ABORTING...                  *'       
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 28540000
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * SELECT ACCOUNT DETAILS                                                  
      ******************************************************************        
       7150-SELECT-ACCOUNT.                                             
      *                                                                         
P00172     IF CSR-DATABASE                                              
             EXEC SQL                                                   
                SELECT AT.ACCOUNT_NO                                    
                      ,AT.CUSTOMER_NO                                   
                      ,AT.ACCOUNT_TYPE_CODE                             
                      ,AT.DATE_BILL_DAY_00                              
                      ,AT.DATE_BILL_DAY_30                              
                      ,AT.DATE_BILL_DAY_60                              
                      ,AT.DATE_BILL_DAY_90                              
                      ,AT.TOTAL_AR_BALANCE                              
                      ,AT.BILL_CYCLE                                    
                      ,AT.CODE_ACCT_STAT                                
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') ACCT_CREATE_DT        
                      ,AT.LOCAL_OFFICE                                  
                      ,AT.PREMISE_NO                                    
                      ,AT.MAX_DEP_REF_XMT_CD                            
                      ,AT.CODES_DATA_PRESENT                            
                      ,AT.COMPANY_NO                                    
                      ,AT.CREDIT_GROUP                                  
                      ,AT.REV_MTH_LST_NRML                              
                  INTO :AT-ACCOUNT-NO                                   
                      ,:AT-CUSTOMER-NO                                  
                      ,:AT-ACCOUNT-TYPE-CODE                            
                      ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND-00              
                      ,:AT-DATE-BILL-DAY-30 :WS-NULL-IND-30              
                      ,:AT-DATE-BILL-DAY-60 :WS-NULL-IND-60              
                      ,:AT-DATE-BILL-DAY-90 :WS-NULL-IND-90              
                      ,:AT-TOTAL-AR-BALANCE                             
                      ,:AT-BILL-CYCLE                                   
                      ,:AT-CODE-ACCT-STAT                               
                      ,:AT-ACCT-CREATE-DT :WS-NULL-IND-CREATE-DT         
                      ,:AT-LOCAL-OFFICE                                 
                      ,:AT-PREMISE-NO                                   
                      ,:AT-MAX-DEP-REF-XMT-CD                           
                      ,:AT-CODES-DATA-PRESENT                           
                      ,:AT-COMPANY-NO                                   
                      ,:AT-CREDIT-GROUP                                 
                      ,:AT-REV-MTH-LST-NRML :WS-REVENUE-MTH-NULL-1       
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND AT.COMPANY_NO = '01'                              
                  AND AT.CODE_ACCT_STAT = 'A'                           
A01731            AND CAST(AT.ACCT_CREATE_DT AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :WS-DATE-13-MNT-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-13-MNT-AGO
              ) <> 0) OR (LEN(:WS-DATE-13-MNT-AGO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-13-MNT-AGO
              ), CONVERT(DATE, :WS-DATE-13-MNT-AGO) )    
A01731            AND SUBSTRING(CAST(DATEADD( MONTH, 1, CAST(
           AT.ACCT_CREATE_DT AS DATE) ) AS CHAR(10)), 6, 2)
A01731                                           = :WS-REV-MTH          
A37061                                                           
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*               ,AT.CUSTOMER_NO                                           
MFA-TR*               ,AT.ACCOUNT_TYPE_CODE                                     
MFA-TR*               ,AT.DATE_BILL_DAY_00                                      
MFA-TR*               ,AT.DATE_BILL_DAY_30                                      
MFA-TR*               ,AT.DATE_BILL_DAY_60                                      
MFA-TR*               ,AT.DATE_BILL_DAY_90                                      
MFA-TR*               ,AT.TOTAL_AR_BALANCE                                      
MFA-TR*               ,AT.BILL_CYCLE                                            
MFA-TR*               ,AT.CODE_ACCT_STAT                                        
MFA-TR*               ,AT.ACCT_CREATE_DT                                        
MFA-TR*               ,AT.LOCAL_OFFICE                                          
MFA-TR*               ,AT.PREMISE_NO                                            
MFA-TR*               ,AT.MAX_DEP_REF_XMT_CD                                    
MFA-TR*               ,AT.CODES_DATA_PRESENT                                    
MFA-TR*               ,AT.COMPANY_NO                                            
MFA-TR*               ,AT.CREDIT_GROUP                                          
MFA-TR*               ,AT.REV_MTH_LST_NRML                                      
MFA-TR*           INTO :AT-ACCOUNT-NO                                           
MFA-TR*               ,:AT-CUSTOMER-NO                                          
MFA-TR*               ,:AT-ACCOUNT-TYPE-CODE                                    
MFA-TR*               ,:AT-DATE-BILL-DAY-00:WS-NULL-IND-00                      
MFA-TR*               ,:AT-DATE-BILL-DAY-30:WS-NULL-IND-30                      
MFA-TR*               ,:AT-DATE-BILL-DAY-60:WS-NULL-IND-60                      
MFA-TR*               ,:AT-DATE-BILL-DAY-90:WS-NULL-IND-90                      
MFA-TR*               ,:AT-TOTAL-AR-BALANCE                                     
MFA-TR*               ,:AT-BILL-CYCLE                                           
MFA-TR*               ,:AT-CODE-ACCT-STAT                                       
MFA-TR*               ,:AT-ACCT-CREATE-DT:WS-NULL-IND-CREATE-DT                 
MFA-TR*               ,:AT-LOCAL-OFFICE                                         
MFA-TR*               ,:AT-PREMISE-NO                                           
MFA-TR*               ,:AT-MAX-DEP-REF-XMT-CD                                   
MFA-TR*               ,:AT-CODES-DATA-PRESENT                                   
MFA-TR*               ,:AT-COMPANY-NO                                           
MFA-TR*               ,:AT-CREDIT-GROUP                                         
MFA-TR*               ,:AT-REV-MTH-LST-NRML:WS-REVENUE-MTH-NULL-1               
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND AT.COMPANY_NO = '01'                                      
MFA-TR*           AND AT.CODE_ACCT_STAT = 'A'                                   
MFA-TR*           AND DATE(AT.ACCT_CREATE_DT) <= :WS-DATE-13-MNT-AGO            
MFA-TR*           AND SUBSTR(CHAR(DATE(AT.ACCT_CREATE_DT) +1 MONTH),6,2)        
MFA-TR*                                          = :WS-REV-MTH                  
MFA-TR*           WITH UR                                                       
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
P00172     ELSE                                                         
P00172        EXEC SQL                                                  
P00172           SELECT TOP(1) AT.ACCOUNT_NO,
              AT.CUSTOMER_NO,
              AT.ACCOUNT_TYPE_CODE,
              AT.DATE_BILL_DAY_00,
              AT.DATE_BILL_DAY_30,
              AT.DATE_BILL_DAY_60,
              AT.DATE_BILL_DAY_90,
              AT.TOTAL_AR_BALANCE,
              AT.BILL_CYCLE,
              AT.CODE_ACCT_STAT,
              REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,
              AT.LOCAL_OFFICE,
              AT.PREMISE_NO,
              AT.MAX_DEP_REF_XMT_CD,
              AT.CODES_DATA_PRESENT,
              AT.COMPANY_NO,
              AT.CREDIT_GROUP,
              AT.REV_MTH_LST_NRML,
              LR.REG_GROUP_CD,
              LR.SENIOR_FL                                    
P00172            INTO  :AT-ACCOUNT-NO                                  
P00172                 ,:AT-CUSTOMER-NO                                 
P00172                 ,:AT-ACCOUNT-TYPE-CODE                           
P00172                 ,:AT-DATE-BILL-DAY-00 :WS-NULL-IND-00             
P00172                 ,:AT-DATE-BILL-DAY-30 :WS-NULL-IND-30             
P00172                 ,:AT-DATE-BILL-DAY-60 :WS-NULL-IND-60             
P00172                 ,:AT-DATE-BILL-DAY-90 :WS-NULL-IND-90             
P00172                 ,:AT-TOTAL-AR-BALANCE                            
P00172                 ,:AT-BILL-CYCLE                                  
P00172                 ,:AT-CODE-ACCT-STAT                              
P00172                 ,:AT-ACCT-CREATE-DT :WS-NULL-IND-CREATE-DT        
P00172                 ,:AT-LOCAL-OFFICE                                
P00172                 ,:AT-PREMISE-NO                                  
P00172                 ,:AT-MAX-DEP-REF-XMT-CD                          
P00172                 ,:AT-CODES-DATA-PRESENT                          
P00172                 ,:AT-COMPANY-NO                                  
P00172                 ,:AT-CREDIT-GROUP                                
P00172                 ,:AT-REV-MTH-LST-NRML :WS-REVENUE-MTH-NULL-1      
P00172                 ,:LR-REG-GROUP-CD                                
P00172                 ,:LR-SENIOR-FL                                   
P00172            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
P00172                ,CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                 
P00677                ,CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                 
P00172           WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO               
P00172             AND AT.COMPANY_NO     = '01'                         
P00172             AND AT.CODE_ACCT_STAT = 'A'                          
P00172             AND AT.BANKRUPTCY_IND = ' '                          
P00172             AND LR.ACCOUNT_NO     = :LR-ACCOUNT-NO               
P00677             AND LR.ACCOUNT_NO     = DO.ACCOUNT_NO                
P00677             AND DO.CODE_REFUND_ELIG <> 'A'                       
P00677             AND (DO.CODE_DEP_TYPE    <> 'X' AND                  
P00677                  DO.DEPOSIT_STATUS_CD IN ('A','P'))              
P00677                                              
P00172                                                           
P00172        END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.CUSTOMER_NO                                          
MFA-TR*                ,AT.ACCOUNT_TYPE_CODE                                    
MFA-TR*                ,AT.DATE_BILL_DAY_00                                     
MFA-TR*                ,AT.DATE_BILL_DAY_30                                     
MFA-TR*                ,AT.DATE_BILL_DAY_60                                     
MFA-TR*                ,AT.DATE_BILL_DAY_90                                     
MFA-TR*                ,AT.TOTAL_AR_BALANCE                                     
MFA-TR*                ,AT.BILL_CYCLE                                           
MFA-TR*                ,AT.CODE_ACCT_STAT                                       
MFA-TR*                ,AT.ACCT_CREATE_DT                                       
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,AT.PREMISE_NO                                           
MFA-TR*                ,AT.MAX_DEP_REF_XMT_CD                                   
MFA-TR*                ,AT.CODES_DATA_PRESENT                                   
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,AT.CREDIT_GROUP                                         
MFA-TR*                ,AT.REV_MTH_LST_NRML                                     
MFA-TR*                ,LR.REG_GROUP_CD                                         
MFA-TR*                ,LR.SENIOR_FL                                            
MFA-TR*           INTO  :AT-ACCOUNT-NO                                          
MFA-TR*                ,:AT-CUSTOMER-NO                                         
MFA-TR*                ,:AT-ACCOUNT-TYPE-CODE                                   
MFA-TR*                ,:AT-DATE-BILL-DAY-00:WS-NULL-IND-00                     
MFA-TR*                ,:AT-DATE-BILL-DAY-30:WS-NULL-IND-30                     
MFA-TR*                ,:AT-DATE-BILL-DAY-60:WS-NULL-IND-60                     
MFA-TR*                ,:AT-DATE-BILL-DAY-90:WS-NULL-IND-90                     
MFA-TR*                ,:AT-TOTAL-AR-BALANCE                                    
MFA-TR*                ,:AT-BILL-CYCLE                                          
MFA-TR*                ,:AT-CODE-ACCT-STAT                                      
MFA-TR*                ,:AT-ACCT-CREATE-DT:WS-NULL-IND-CREATE-DT                
MFA-TR*                ,:AT-LOCAL-OFFICE                                        
MFA-TR*                ,:AT-PREMISE-NO                                          
MFA-TR*                ,:AT-MAX-DEP-REF-XMT-CD                                  
MFA-TR*                ,:AT-CODES-DATA-PRESENT                                  
MFA-TR*                ,:AT-COMPANY-NO                                          
MFA-TR*                ,:AT-CREDIT-GROUP                                        
MFA-TR*                ,:AT-REV-MTH-LST-NRML:WS-REVENUE-MTH-NULL-1              
MFA-TR*                ,:LR-REG-GROUP-CD                                        
MFA-TR*                ,:LR-SENIOR-FL                                           
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*               ,CSS_REG_PROFILE LR                                       
MFA-TR*               ,CSS_DEP_ON_HAND DO                                       
MFA-TR*          WHERE AT.ACCOUNT_NO     = :AT-ACCOUNT-NO                       
MFA-TR*            AND AT.COMPANY_NO     = '01'                                 
MFA-TR*            AND AT.CODE_ACCT_STAT = 'A'                                  
MFA-TR*            AND AT.BANKRUPTCY_IND = ' '                                  
MFA-TR*            AND LR.ACCOUNT_NO     = :LR-ACCOUNT-NO                       
MFA-TR*            AND LR.ACCOUNT_NO     = DO.ACCOUNT_NO                        
MFA-TR*            AND DO.CODE_REFUND_ELIG <> 'A'                               
MFA-TR*            AND (DO.CODE_DEP_TYPE    <> 'X' AND                          
MFA-TR*                 DO.DEPOSIT_STATUS_CD IN ('A','P'))                      
MFA-TR*            FETCH FIRST ROW ONLY                                         
MFA-TR*            WITH UR                                                      
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
P00172     END-IF.                                                      
      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-NULL-IND-00 < 0                                   
                   MOVE SPACES                 TO AT-DATE-BILL-DAY-00   
               END-IF                                                   
               IF  WS-NULL-IND-30 < 0                                   
                   MOVE SPACES                 TO AT-DATE-BILL-DAY-30   
               END-IF                                                   
               IF  WS-NULL-IND-60 < 0                                   
                   MOVE SPACES                 TO AT-DATE-BILL-DAY-60   
               END-IF                                                   
               IF  WS-NULL-IND-90 < 0                                   
                   MOVE SPACES                 TO AT-DATE-BILL-DAY-90   
               END-IF                                                   
               IF  WS-NULL-IND-CREATE-DT < 0                            
                   MOVE SPACES                 TO AT-ACCT-CREATE-DT     
               END-IF                                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  NEXT SENTENCE                                         
               ELSE                                                     
                  DISPLAY '********** PCSCA098 ABORT **************'    
                  DISPLAY '* 7150-SELECT-ACCOUNT                  *'    
                  DISPLAY '* ACCOUNT NO ', AT-ACCOUNT-NO                
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                  *'    
                  DISPLAY '********** PCSCA098 ABORT **************'    
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * SELECT MAX-DEP-REVIEW                                                   
      ******************************************************************        
       7160-SELECT-MAX-DEP-REVIEW.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT MG.ACCOUNT_NO                                      
                    ,MG.LAST_MAX_AT_REV_DT                              
                INTO :MG-ACCOUNT-NO                                     
                    ,:MG-LAST-MAX-AT-REV-DT :WS-NULL-IND-REV-DT          
               FROM CSS_MAX_DEP_REVIEW MG WITH(READUNCOMMITTED)                 
              WHERE MG.ACCOUNT_NO = :MG-ACCOUNT-NO                      
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MG.ACCOUNT_NO                                              
MFA-TR*             ,MG.LAST_MAX_AT_REV_DT                                      
MFA-TR*         INTO :MG-ACCOUNT-NO                                             
MFA-TR*             ,:MG-LAST-MAX-AT-REV-DT:WS-NULL-IND-REV-DT                  
MFA-TR*        FROM CSS_MAX_DEP_REVIEW MG                                       
MFA-TR*       WHERE MG.ACCOUNT_NO = :MG-ACCOUNT-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-NULL-IND-REV-DT < 0                               
                   MOVE 'Y'                    TO WS-CONTINUE-REVIEW    
                   MOVE SPACES                 TO MG-LAST-MAX-AT-REV-DT 
               ELSE                                                     
                   IF MG-LAST-MAX-AT-REV-DT                             
                                           <= WS-DATE-11-MNT-AGO        
                      MOVE 'Y'                    TO WS-CONTINUE-REVIEW 
                   ELSE                                                 
                      MOVE 'N'                    TO WS-CONTINUE-REVIEW 
               END-IF
               END-IF                                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                  MOVE 'Y'                     TO WS-CONTINUE-REVIEW    
              ELSE                                                      
                  DISPLAY '********** PCSCA098 ABORT **************'    
                  DISPLAY '* 7160-SELECT-MAX-DEP-REVIEW           *'    
                  DISPLAY '* ACCOUNT NO ', MG-ACCOUNT-NO                
                  DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE        
                  DISPLAY '* PROGRAM ABORTING...                  *'    
                  DISPLAY '********** PCSCA098 ABORT **************'    
                  PERFORM 9900-ABEND              THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 30120000
      * 7250-SELECT-ACCOUNT                                           * 30130000
      *     SELECT THE DETAILS FROM CSS_ACCOUNT TABLE                 * 30150000
      ***************************************************************** 30160000
       7250-SELECT-ACCOUNT.                                             
      *                                                                 30190000
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE,                                      
                     CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     TOTAL_AR_BALANCE,                                  
                     CODES_DATA_PRESENT,                                
                     CODE_COMPANY_ACCT,                                 
                     CODE_ACCT_STAT,                                    
                     COMPANY_NO,                                        
                     BILL_CYCLE,                                        
                     DATE_LAST_ACTION,                                  
                     AR_XFER_IND,                                       
                     ACCT_XFER_TO,                                      
                     BANKRUPTCY_IND,                                    
                     NOTICE_EXEMPT_CD,                                  
                     CODE_DISC_OK,                                      
                     DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90,                                  
                     MAX_DEP_REF_XMT_CD,                                
                     CREDIT_GROUP                                       
              INTO   :AT-LOCAL-OFFICE,                                  
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-CODE-COMPANY-ACCT,                             
                     :AT-CODE-ACCT-STAT,                                
                     :AT-COMPANY-NO,                                    
                     :AT-BILL-CYCLE,                                    
                     :AT-DATE-LAST-ACTION,                              
                     :AT-AR-XFER-IND,                                   
                     :AT-ACCT-XFER-TO,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-NOTICE-EXEMPT-CD,                              
                     :AT-CODE-DISC-OK,                                  
                     :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,         
                     :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,         
                     :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,         
                     :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,         
                     :AT-MAX-DEP-REF-XMT-CD,                            
                     :AT-CREDIT-GROUP                                   
              FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30200000
MFA-TR*       SELECT LOCAL_OFFICE,                                      30210000
MFA-TR*              CUSTOMER_NO,                                       30220000
MFA-TR*              PREMISE_NO,                                        30230000
MFA-TR*              TOTAL_AR_BALANCE,                                  30240000
MFA-TR*              CODES_DATA_PRESENT,                                30250000
MFA-TR*              CODE_COMPANY_ACCT,                                 30260000
MFA-TR*              CODE_ACCT_STAT,                                    30270000
MFA-TR*              COMPANY_NO,                                        30280000
MFA-TR*              BILL_CYCLE,                                        30280000
MFA-TR*              DATE_LAST_ACTION,                                  30290000
MFA-TR*              AR_XFER_IND,                                       30300000
MFA-TR*              ACCT_XFER_TO,                                      30310000
MFA-TR*              BANKRUPTCY_IND,                                    30320000
MFA-TR*              NOTICE_EXEMPT_CD,                                  30321000
MFA-TR*              CODE_DISC_OK,                                      30322000
MFA-TR*              DATE_BILL_DAY_00,                                  30323000
MFA-TR*              DATE_BILL_DAY_30,                                  30324000
MFA-TR*              DATE_BILL_DAY_60,                                  30325000
MFA-TR*              DATE_BILL_DAY_90,                                  30326000
MFA-TR*              MAX_DEP_REF_XMT_CD,                                30326000
MFA-TR*              CREDIT_GROUP                                       30330000
MFA-TR*       INTO   :AT-LOCAL-OFFICE,                                  30340000
MFA-TR*              :AT-CUSTOMER-NO,                                   30350000
MFA-TR*              :AT-PREMISE-NO,                                    30360000
MFA-TR*              :AT-TOTAL-AR-BALANCE,                              30370000
MFA-TR*              :AT-CODES-DATA-PRESENT,                            30380000
MFA-TR*              :AT-CODE-COMPANY-ACCT,                             30390000
MFA-TR*              :AT-CODE-ACCT-STAT,                                30400000
MFA-TR*              :AT-COMPANY-NO,                                    30410000
MFA-TR*              :AT-BILL-CYCLE,                                    30410000
MFA-TR*              :AT-DATE-LAST-ACTION,                              30420000
MFA-TR*              :AT-AR-XFER-IND,                                   30430000
MFA-TR*              :AT-ACCT-XFER-TO,                                  30440000
MFA-TR*              :AT-BANKRUPTCY-IND,                                30450000
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                              30451000
MFA-TR*              :AT-CODE-DISC-OK,                                  30452000
MFA-TR*              :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,         30453000
MFA-TR*              :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,         30454000
MFA-TR*              :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,         30455000
MFA-TR*              :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,         30456000
MFA-TR*              :AT-MAX-DEP-REF-XMT-CD,                            30326000
MFA-TR*              :AT-CREDIT-GROUP                                   30460000
MFA-TR*       FROM   CSS_ACCOUNT                                        30470000
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        30480000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    30490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30500000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 30520000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 7250-SELECT-ACCOUNT                  *'        
              DISPLAY '* ACCOUNT-NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 30650000
       7250-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 30690000
      * 7260-SELECT-PREMISE                                           * 30700000
      *     SELECT THE DETAILS FROM CSS_PREMISE TABLE                 * 30720000
      ***************************************************************** 30730000
       7260-SELECT-PREMISE.                                             
      *                                                                 30760000
           EXEC SQL                                                     
              SELECT REV_DISTRICT_CD,                                   
                     CODE_PREMISE_STAT                                  
              INTO   :PR-REV-DISTRICT-CD,                               
                     :PR-CODE-PREMISE-STAT                              
              FROM   CSS_PREMISE WITH(READUNCOMMITTED)                          
              WHERE  PREMISE_NO = :PR-PREMISE-NO                        
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     30770000
MFA-TR*       SELECT REV_DISTRICT_CD,                                   30780000
MFA-TR*              CODE_PREMISE_STAT                                  30790000
MFA-TR*       INTO   :PR-REV-DISTRICT-CD,                               30800000
MFA-TR*              :PR-CODE-PREMISE-STAT                              30810000
MFA-TR*       FROM   CSS_PREMISE                                        30820000
MFA-TR*       WHERE  PREMISE_NO = :PR-PREMISE-NO                        30830000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    30840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 30850000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 30870000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 7260-SELECT-PREMISE                  *'        
              DISPLAY '* PERMISE-NO    ', PR-PREMISE-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 31000000
       7260-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************31370000
      * 7280-SELECT-CUSTOMER                                           *31380000
      *    -- THIS MODULE OBTAINS THE EMPLOYEE ACCOUNT CODE.           *31390000
      ******************************************************************31400000
       7280-SELECT-CUSTOMER.                                            
      *                                                                 31420000
           EXEC SQL                                                     
               SELECT CODE_EMPL_ACCT,                                   
                      CODE_CUST_STATUS,                                 
                      NAME_ID                                           
                 INTO :CU-CODE-EMPL-ACCT,                               
                      :CU-CODE-CUST-STATUS,                             
                      :CU-NAME-ID                                       
                 FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
                WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                    
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31430000
MFA-TR*        SELECT CODE_EMPL_ACCT,                                   31440000
MFA-TR*               CODE_CUST_STATUS,                                 31450000
MFA-TR*               NAME_ID                                                   
MFA-TR*          INTO :CU-CODE-EMPL-ACCT,                               31460000
MFA-TR*               :CU-CODE-CUST-STATUS,                             31470000
MFA-TR*               :CU-NAME-ID                                               
MFA-TR*          FROM CSS_CUSTOMER                                      31480000
MFA-TR*         WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                    31490000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    31500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31510000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 31540000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              DISPLAY '* 7280-SELECT-CUSTOMER                 *'        
              DISPLAY '* CUSTOMER NO   ', AT-CUSTOMER-NO                
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 31650000
       7280-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      ** 7285-SELECT-CUST-NAME ..                                    **         
      **        GETS CUSTOMER NAME FROM CSS_NAME TABLE               **         
      *****************************************************************         
       7285-SELECT-CUST-NAME.                                           
           MOVE '7285' TO WS-ACTIVE-PARAGRAPH.                          
      *                                                                         
           EXEC SQL                                                     
               SELECT  NAME_FORMAT,                                     
                       FIRST_NAME,                                      
                       MIDDLE_NAME,                                     
                       LAST_NAME,                                       
                       FULL_NAME                                        
                 INTO  :DQ-NAME-FORMAT,                                 
                       :DQ-FIRST-NAME,                                  
                       :DQ-MIDDLE-NAME,                                 
                       :DQ-LAST-NAME,                                   
                       :DQ-FULL-NAME                                    
                 FROM  CSS_NAME WITH(READUNCOMMITTED)                           
                WHERE  NAME_ID = :CU-NAME-ID                            
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  NAME_FORMAT,                                             
MFA-TR*                FIRST_NAME,                                              
MFA-TR*                MIDDLE_NAME,                                             
MFA-TR*                LAST_NAME,                                               
MFA-TR*                FULL_NAME                                                
MFA-TR*          INTO  :DQ-NAME-FORMAT,                                         
MFA-TR*                :DQ-FIRST-NAME,                                          
MFA-TR*                :DQ-MIDDLE-NAME,                                         
MFA-TR*                :DQ-LAST-NAME,                                           
MFA-TR*                :DQ-FULL-NAME                                            
MFA-TR*          FROM  CSS_NAME                                                 
MFA-TR*         WHERE  NAME_ID = :CU-NAME-ID                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                CONTINUE                                                
           ELSE                                                         
               MOVE SQLCODE TO WS-DISPLAY-SQLCODE                       
               DISPLAY '**** ABEND IN 7285-SELECT-CUST-NAME ****'       
               DISPLAY '**** SQLCODE IS ' WS-DISPLAY-SQLCODE            
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7285-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************31690000
      * 7290-SELECT-RECONNECT                                          *31700000
      *    -- THIS MODULE OBTAINS THE RECONNECT DETAIL                 *31710000
      ******************************************************************31720000
       7290-SELECT-RECONNECT.                                           
      *                                                                 31740000
           EXEC SQL                                                     
               SELECT AMT_TOT_RECONNECT                                 
                 INTO :DL-AMT-TOT-RECONNECT                             
                 FROM CSS_RECONNECT WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                      
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31750000
MFA-TR*        SELECT AMT_TOT_RECONNECT                                 31760000
MFA-TR*          INTO :DL-AMT-TOT-RECONNECT                             31770000
MFA-TR*          FROM CSS_RECONNECT                                     31780000
MFA-TR*         WHERE ACCOUNT_NO  = :DL-ACCOUNT-NO                      31790000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    31800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31810000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 31840000
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 7290-SELECT-RECONNECT                *'        
              DISPLAY '* ACCOUNT NO    ', DL-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 31970000
       7290-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 32570000
      * 7310-OPEN-DEP-ON-HAND                                         * 32580000
      *     OPEN THE CURSOR TO SELECT DETAILS FROM CSS_DEP_ON_HAND    * 32600000
      ***************************************************************** 32610000
       7310-OPEN-DEP-ON-HAND.                                           
      *                                                                 32640000
           EXEC SQL                                                     
              OPEN DEP_ON_HAND                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 32680000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 32700000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 7310-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 32830000
       7310-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 32870000
      * 7320-FETCH-DEP-ON-HAND                                        * 32880000
      *    FETCH THE DETAILS FROM DEP_ON_HAND CURSOR                  * 32900000
      ***************************************************************** 32910000
       7320-FETCH-DEP-ON-HAND.                                          
      *                                                                 32940000
           EXEC SQL                                                     
              FETCH  DEP_ON_HAND                                        
              INTO   :DO-DEPOSIT-CERT-NO,                               
                     :DO-AMT-DEPOSIT,                                   
                     :DO-AMT-REFUNDED,                                  
                     :DO-INTRST-YTD,                                    
                     :DO-TOTAL-INTRST,                                  
                     :DO-DATE-PYMT-START :WS-DATE-PYMT-START-NI,         
                     :DO-DATE-INTST-CALC-TO :WS-DATE-INTST-CALC-TO-NI,   
                     :DO-CODE-REFUND-STATUS,                            
                     :DO-DEPOSIT-STATUS-CD,                             
                     :DO-DATE-CERT-ISSUE :WS-DATE-CERT-ISSUE-NI          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33090000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 33110000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-DATE-INTST-CALC-TO-NI < 0                           
                 MOVE SPACES      TO DO-DATE-INTST-CALC-TO              
              END-IF                                                    
              IF WS-DATE-CERT-ISSUE-NI < 0                              
                 MOVE SPACES      TO DO-DATE-CERT-ISSUE                 
              END-IF                                                    
              IF WS-DATE-PYMT-START-NI < 0                              
                 MOVE SPACES      TO DO-DATE-PYMT-START                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '* 7320-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 33260000
       7320-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 33300000
      * 7330-CLOSE-DEP-ON-HAND                                        * 33310000
      *                                                               * 33320000
      *     CLOSE THE DEP_ON_HAND CURSOR                              * 33330000
      ***************************************************************** 33340000
       7330-CLOSE-DEP-ON-HAND.                                          
      *                                                                 33370000
           EXEC SQL                                                     
              CLOSE DEP_ON_HAND                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 33410000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 7330-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              DISPLAY '* PROGRAM ABORTING...                  *'        
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
       7330-EXIT.                                                       
           EXIT.                                                        
       7380-RECENT-PAID-DEP.                                            
                                                                        
           MOVE 'N' TO WS-RECENT-PD-DEP-EXISTS.                         
           EXEC SQL                                                     
               SELECT DISTINCT('Y')                                     
                 INTO :WS-RECENT-PD-DEP-EXISTS                          
                 FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :DP-ACCOUNT-NO                       
                  AND DEPOSIT_STATUS_CD = ('P')                         
                  AND DATE_CERT_ISSUE >                                 
                      (DATEADD( DAY, -:WS-MIN-AGE-VALUE, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))           
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DISTINCT('Y')                                             
MFA-TR*          INTO :WS-RECENT-PD-DEP-EXISTS                                  
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :DP-ACCOUNT-NO                               
MFA-TR*           AND DEPOSIT_STATUS_CD = ('P')                                 
MFA-TR*           AND DATE_CERT_ISSUE >                                         
MFA-TR*               (CURRENT DATE - :WS-MIN-AGE-VALUE DAYS)                   
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-RECENT-PD-DEP-EXISTS                  
               WHEN OTHER                                               
                   DISPLAY '********** PCSCA098 ABORT **************'   
                   DISPLAY '* 7380-                                *'   
                   DISPLAY '* ACCOUNT NO ', DP-ACCOUNT-NO               
                   DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE       
                   DISPLAY '* PROGRAM ABORTING...                  *'   
                   DISPLAY '********** PCSCA098 ABORT **************'   
                   PERFORM 9900-ABEND              THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7380-EXIT.                                                       
           EXIT.                                                        
*******  7600-START-FCSJC01 IS IN CPD00038                                      
*******                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      ******************************************************************36710000
      * 7600-OPEN-DEP-EXISTS                                           *36720000
      *      OPEN THE CURSOR TO SELECT DEP_ON-HAND DATA FOR A GIVEN    *36730000
      *      ACCOUNT-NO WITH DEPOSIT STATUS = 'A' OR 'P'               *36740000
      ******************************************************************36750000
       7600-OPEN-DEP-EXISTS.                                            
      *                                                                 36780000
           EXEC SQL                                                     
                OPEN DEP_EXISTS                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36820000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36831000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '* 7600-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
            END-IF.                                                     
      *                                                                 36950000
       7600-OPEN-EXIT.                                                  
           EXIT.                                                        
      *                                                                 36980000
       7610-FETCH-DEP-EXISTS.                                           
      *                                                                 37000000
           EXEC SQL                                                     
                FETCH  DEP_EXISTS                                       
                INTO   :WS-DEP-ON-HAND-EXISTS                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37050000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37061000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-DEP-ON-HAND-EXISTS                   
              END-IF                                                    
           ELSE                                                         
              DISPLAY '* 7610-FETCH                           *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37200000
       7610-FETCH-EXIT.                                                 
           EXIT.                                                        
      *                                                                 37230000
       7615-CLOSE-DEP-EXISTS.                                           
      *                                                                 37250000
           EXEC SQL                                                     
                CLOSE DEP_EXISTS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37301000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '* 7615-CLOSE                           *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37420000
       7615-EXIT.                                                       
           EXIT.                                                        
      *                                                                 37450000
      * PARAGRAPH 7620-START-FCSCA00 IS IN CPD00039                             
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      ******************************************************************36710000
      * 7630-OPEN-ACTDEP-EXISTS                                        *36720000
      *      OPEN THE CURSOR TO SELECT DEP_ON-HAND DATA FOR A GIVEN    *36730000
      *      ACCOUNT-NO WITH DEPOSIT STATUS = 'A'                      *36740000
      ******************************************************************36750000
       7630-OPEN-ACTDEP-EXISTS.                                         
      *                                                                 36780000
           EXEC SQL                                                     
                OPEN ACTDEP_EXISTS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36820000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36831000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '* 7630-OPEN                            *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
            END-IF.                                                     
      *                                                                 36950000
       7630-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36980000
       7640-FETCH-ACTDEP-EXISTS.                                        
      *                                                                 37000000
           EXEC SQL                                                     
                FETCH  ACTDEP_EXISTS                                    
                INTO   :WS-ACTIVE-DEP-EXISTS                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37050000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37061000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-ACTIVE-DEP-EXISTS                    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '* 7640-FETCH                           *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37200000
       7640-EXIT.                                                       
           EXIT.                                                        
      *                                                                 37230000
       7650-CLOSE-ACTDEP-EXISTS.                                        
      *                                                                 37250000
           EXEC SQL                                                     
                CLOSE ACTDEP_EXISTS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37301000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '* 7650-CLOSE                           *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37420000
       7650-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************36710000
C28160* 7660-OPEN-NOT_ELIG_EXISTS                                      *36720000
      *      OPEN THE CURSOR TO SELECT DEP_ON-HAND DATA FOR A GIVEN    *36730000
      *      ACCOUNT-NO WITH CODE_REFUND_ELIG = 'A'                    *36740000
      ******************************************************************36750000
       7660-OPEN-NOT-ELIG-EXISTS.                                       
      *                                                                 36780000
           EXEC SQL                                                     
                OPEN NOT_ELIG_EXISTS                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 36820000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 36831000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '* 7660-OPEN                            *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
            END-IF.                                                     
      *                                                                 36950000
       7660-EXIT.                                                       
           EXIT.                                                        
      *                                                                 36980000
       7665-FETCH-NOT-ELIG-EXISTS.                                      
      *                                                                 37000000
           EXEC SQL                                                     
                FETCH  NOT_ELIG_EXISTS                                  
                INTO   :WS-CODE-REFUND-ELIG                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37050000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37061000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO    WS-CODE-REFUND-ELIG                     
              END-IF                                                    
           ELSE                                                         
              DISPLAY '* 7665-FETCH                           *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37200000
       7665-EXIT.                                                       
           EXIT.                                                        
      *                                                                 37230000
       7670-CLOSE-NOT-ELIG-EXISTS.                                      
      *                                                                 37250000
           EXEC SQL                                                     
                CLOSE NOT_ELIG_EXISTS                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 37301000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '* 7670-CLOSE                           *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 37420000
       7670-EXIT.                                                       
           EXIT.                                                        
P00172*                                                                         
P00172******************************************************************42348200
P00172* 7850-GET-TOTAL-PAID-REFUNDS                                    *42348300
P00172*                                                                *42348500
P00172******************************************************************42348600
P00172*                                                                         
P00172 7850-GET-TOTAL-PAID-REFUNDS.                                     
P00172*                                                                 42348800
P00172     EXEC SQL                                                     
P00399        SELECT   SUM(DO.AMT_REFUNDED + DO.TRANSFER_AMT)           
P00172          INTO   :WS-TOTAL-REFUNDED :WS-NULL-REFUND                
P00172          FROM   CSS_DEP_ON_HAND AS DO WITH(READUNCOMMITTED)              
P00172         WHERE   DO.ACCOUNT_NO       =  :DO-ACCOUNT-NO            
P00172                                                           
P00172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42348900
MFA-TR*       SELECT   SUM(DO.AMT_REFUNDED + DO.TRANSFER_AMT)           42349000
MFA-TR*         INTO   :WS-TOTAL-REFUNDED:WS-NULL-REFUND                42349100
MFA-TR*         FROM   CSS_DEP_ON_HAND AS DO                            42349200
MFA-TR*        WHERE   DO.ACCOUNT_NO       =  :DO-ACCOUNT-NO            42349300
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    42349500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00172*                                                                 42350000
P00172     IF WS-NULL-REFUND  < 0                                       
P00172         MOVE ZEROES                   TO WS-TOTAL-REFUNDED       
P00172     END-IF.                                                      
P00172*                                                                 42350000
P00172     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00172*                                                                 42350200
P00172     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00172         NEXT SENTENCE                                            
P00172     ELSE                                                         
P00172         DISPLAY '********** PCSCA098 ABORT **************'       
P00172         DISPLAY '* 7850-GET-TOTAL-PAID-REFUNDS          *'       
P00172         DISPLAY '* ACCOUNT NO   = ' DO-ACCOUNT-NO                
P00172         DISPLAY '* SQLCODE IS   = ' WS-ACTIVE-RETURN-CODE        
P00172         PERFORM 9900-ABEND            THRU 9900-EXIT             
P00172         DISPLAY '********** PCSCA098 ABORT **************'       
P00172     END-IF.                                                      
P00172*                                                                 42351400
P00172 7850-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                         
P00172******************************************************************16990000
P00172* 7880-CHECK-BILLED-DEP.                                         *17000000
P00172*    -- THIS MODULE CHECKS IF THERE IS A BILLED DEPOSIT          *17010000
P00172*       FOR THE ACCOUNT.                                         *17020000
P00172******************************************************************17050000
P00172*                                                                         
P00172 7880-CHECK-BILLED-DEP.                                           
P00172*                                                                 17070000
P00172     EXEC SQL                                                     
P00677          SELECT SUM(AMT_TRAN_BALANCE)                            
P00677          INTO :AC-AMT-TRAN-BALANCE :WS-NULL-BLD-DEP               
P00677          FROM CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                      
P00677          WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             
P00677            AND AC.ITEM_ID           > 0                          
P00677            AND AC.PYMT_PRIORITY_LVL = 80                         
P00172                                                           
P00172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17080000
MFA-TR*         SELECT SUM(AMT_TRAN_BALANCE)                            17090000
MFA-TR*         INTO :AC-AMT-TRAN-BALANCE:WS-NULL-BLD-DEP               17100000
MFA-TR*         FROM CSS_AR_CNTL  AC                                    17110000
MFA-TR*         WHERE AC.ACCOUNT_NO        = :AC-ACCOUNT-NO             17120000
MFA-TR*           AND AC.ITEM_ID           > 0                                  
MFA-TR*           AND AC.PYMT_PRIORITY_LVL = 80                                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    17150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00172                                                                  
P00172     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00172                                                                  
P00172     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00172         WHEN SUCCESSFUL-CALL                                     
P00172              IF WS-NULL-BLD-DEP < 0                              
P00172                 MOVE ZEROS            TO WS-BILLD-DEP-AMT        
P00172                 MOVE SPACES           TO WS-BILLED-DEP-EXISTS    
P00172              ELSE                                                
P00677                 MOVE AC-AMT-TRAN-BALANCE TO WS-BILLD-DEP-AMT     
P00172                 SET BILLED-DEP-EXISTS    TO TRUE                 
P00172              END-IF                                              
P00172         WHEN NOT-FOUND                                           
P00172              MOVE 0                   TO WS-BILLD-DEP-AMT        
P00172              MOVE SPACES              TO WS-BILLED-DEP-EXISTS    
P00172         WHEN OTHER                                               
P00172              DISPLAY '********** PCSCA098 ABORT **************'  
P00172              DISPLAY '* 7880-CHECK-BILLED-DEP                *'  
P00172              DISPLAY '* ACCOUNT NO   = ' DO-ACCOUNT-NO           
P00172              DISPLAY '* SQLCODE IS   = ' WS-ACTIVE-RETURN-CODE   
P00172              PERFORM 9900-ABEND       THRU 9900-EXIT             
P00172              DISPLAY '********** PCSCA098 ABORT **************'  
P00172     END-EVALUATE.                                                
P00172*                                                                 17300000
P00172 7880-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                         
P00172******************************************************************16990000
P00172* 7881-CHECK-XFER-DEP.                                           *17000000
P00172*    -- THIS MODULE CHECKS IF THERE IS ANY TRANSFERRED DEPOSIT   *17010000
P00172*       FOR THE ACCOUNT.                                         *17020000
P00172******************************************************************17050000
P00172*                                                                         
P00172 7881-CHECK-XFER-DEP.                                             
P00172*                                                                 17070000
P00172     EXEC SQL                                                     
P00172          SELECT TOP(1) 'Y'                                              
P00172          INTO :WS-XFER-DEP-EXISTS                                
P00172          FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
P00172          WHERE ACCOUNT_NO        = :DO-ACCOUNT-NO                
P00172            AND DEPOSIT_STATUS_CD = 'T'                           
P00172                                     
P00172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17080000
MFA-TR*         SELECT 'Y'                                              17090000
MFA-TR*         INTO :WS-XFER-DEP-EXISTS                                17100000
MFA-TR*         FROM CSS_DEP_ON_HAND                                    17110000
MFA-TR*         WHERE ACCOUNT_NO        = :DO-ACCOUNT-NO                17120000
MFA-TR*           AND DEPOSIT_STATUS_CD = 'T'                                   
MFA-TR*           FETCH FIRST 1 ROW ONLY WITH UR                                
MFA-TR*    END-EXEC.                                                    17150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00172                                                                  
P00172     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
P00172                                                                  
P00172     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00172         WHEN SUCCESSFUL-CALL                                     
P00172         WHEN NOT-FOUND                                           
P00172              CONTINUE                                            
P00172         WHEN OTHER                                               
P00172              DISPLAY '********** PCSCA098 ABORT **************'  
P00172              DISPLAY '* 7881-CHECK-XFER-DEP                  *'  
P00172              DISPLAY '* ACCOUNT NO   = ' DO-ACCOUNT-NO           
P00172              DISPLAY '* SQLCODE IS   = ' WS-ACTIVE-RETURN-CODE   
P00172              DISPLAY '********** PCSCA098 ABORT **************'  
P00172              PERFORM 9900-ABEND       THRU 9900-EXIT             
P00172     END-EVALUATE.                                                
P00172*                                                                 17300000
P00172 7881-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                 17320000
P00172******************************************************************17330000
P00172* 7890-SELECT-CUST-STATS                                         *17330000
P00172******************************************************************17330000
P00172*                                                                 17320000
P00172 7890-SELECT-CUST-STATS.                                          
P00172*                                                                 17320000
P00172     EXEC SQL                                                     
P00172         SELECT                                                   
P00172                CE.DATE_OF_BIRTH                                  
P00172           INTO                                                   
P00172                :CE-DATE-OF-BIRTH :WS-NULL-CUST-DOB                
P00172           FROM                                                   
P00172                CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
P00172          WHERE                                                   
P00172                CE.CUSTOMER_NO     = :CE-CUSTOMER-NO              
P00172            AND CE.CUSTOMER_TYPE   = :CE-CUSTOMER-TYPE            
P00172            AND CE.DOB_VERIFIED_CD = :CE-DOB-VERIFIED-CD          
P00172                                                           
P00172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17330000
MFA-TR*        SELECT                                                   17330000
MFA-TR*               CE.DATE_OF_BIRTH                                  17330000
MFA-TR*          INTO                                                   17330000
MFA-TR*               :CE-DATE-OF-BIRTH:WS-NULL-CUST-DOB                17330000
MFA-TR*          FROM                                                   17330000
MFA-TR*               CSS_CUST_STATS CE                                 17330000
MFA-TR*         WHERE                                                   17330000
MFA-TR*               CE.CUSTOMER_NO     = :CE-CUSTOMER-NO              17330000
MFA-TR*           AND CE.CUSTOMER_TYPE   = :CE-CUSTOMER-TYPE            17330000
MFA-TR*           AND CE.DOB_VERIFIED_CD = :CE-DOB-VERIFIED-CD          17330000
MFA-TR*          WITH UR                                                17330000
MFA-TR*    END-EXEC.                                                    17330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00172*                                                                 17330000
P00172     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00172*                                                                 17330000
P00172     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00172         WHEN SUCCESSFUL-CALL                                     
P00172              IF WS-NULL-CUST-DOB < 0                             
P00172                 MOVE SPACES           TO CE-DATE-OF-BIRTH        
P00172              END-IF                                              
P00172         WHEN NOT-FOUND                                           
P00172              MOVE SPACES              TO CE-DATE-OF-BIRTH        
P00172         WHEN OTHER                                               
P00172              DISPLAY '********** PCSCA098 ABORT **************'  
P00172              DISPLAY '* 7890-SELECT-CUST-STATS               *'  
P00172              DISPLAY '* CE-CUSTOMER-NO     =' CE-CUSTOMER-NO     
P00172              DISPLAY '* CE-CUSTOMER-TYPE   =' CE-CUSTOMER-TYPE   
P00172              DISPLAY '* CE-DOB-VERIFIED-CD =' CE-DOB-VERIFIED-CD 
P00172              DISPLAY '********** PCSCA098 ABORT **************'  
P00172              PERFORM 9900-ABEND       THRU 9900-EXIT             
P00172     END-EVALUATE.                                                
P00172*                                                                 17330000
P00172 7890-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                 17330000
P00172******************************************************************17330000
P00172* 7891-CALCULATE-AGE                                             *17330000
P00172******************************************************************17330000
P00172*                                                                 17330000
P00172 7891-CALCULATE-AGE.                                              
P00172*                                                                 17330000
P00172     EXEC SQL                                                     
P00172        SELECT
              ( 12 * CIS.DECIMAL2YEAR(CIS.DIFFDATE( 
              IIF(TRY_CONVERT(DATE, :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) ))          
P00172                                   + 
           CIS.DECIMAL2MONTH(CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, 
                                                         :WS-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-START-DATE
              ) <> 0) OR (LEN(:WS-START-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-START-DATE
              ), CONVERT(DATE, :WS-START-DATE) ), 
              IIF(TRY_CONVERT(DATE, :WS-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-END-DATE
              ) <> 0) OR (LEN(:WS-END-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-END-DATE
              ), CONVERT(DATE, :WS-END-DATE) ) )))         
P00172                                   / 12
            INTO
              :WS-RESULT-YEAR                           
P00172     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*    EXEC SQL                                                     17330000
MFA-TR*       SET :WS-RESULT-YEAR = ( 12 * YEAR(DATE(:WS-START-DATE)    17330000
MFA-TR*                                  - DATE(:WS-END-DATE))          17330000
MFA-TR*                                  + MONTH(DATE(:WS-START-DATE)   17330000
MFA-TR*                                  - DATE(:WS-END-DATE)))         17330000
MFA-TR*                                  / 12                           17330000
MFA-TR*    END-EXEC.                                                    17330000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00172*                                                                 17330000
P00172     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00172*                                                                 17330000
P00172     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00172        NEXT SENTENCE                                             
P00172     ELSE                                                         
P00172        DISPLAY '********** PCSCA098 ABORT **************'        
P00172        DISPLAY '* 7891-CALCULATE-AGE                   *'        
P00172        DISPLAY '* CE-CUSTOMER-NO     =' CE-CUSTOMER-NO           
P00172        DISPLAY '* CE-CUSTOMER-TYPE   =' CE-CUSTOMER-TYPE         
P00172        DISPLAY '* CE-DOB-VERIFIED-CD =' CE-DOB-VERIFIED-CD       
P00172        DISPLAY '********** PCSCA098 ABORT **************'        
P00172        PERFORM 9900-ABEND       THRU 9900-EXIT                   
P00172     END-IF.                                                      
P00172*                                                                 17330000
P00172 7891-EXIT.                                                       
P00172     EXIT.                                                        
P00172*                                                                 17330000
      ******************************************************************42348200
      * 7900-GET-TOTAL-PAID-DEPS                                       *42348300
      ******************************************************************42348600
       7900-GET-TOTAL-PAID-DEPS.                                        
      *                                                                 42348800
           EXEC SQL                                                     
              SELECT   SUM(DP.DEP_PAY_AMT)                              
                INTO   :WS-TOTAL-PAYMENTS :WS-NULL-PAYMENT               
                FROM   CSS_DEP_PAY_HST DP WITH(READUNCOMMITTED)                 
               WHERE   DP.ACCOUNT_NO       =  :DP-ACCOUNT-NO            
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42348900
MFA-TR*       SELECT   SUM(DP.DEP_PAY_AMT)                              42349000
MFA-TR*         INTO   :WS-TOTAL-PAYMENTS:WS-NULL-PAYMENT               42349100
MFA-TR*         FROM   CSS_DEP_PAY_HST DP                               42349200
MFA-TR*        WHERE   DP.ACCOUNT_NO       =  :DP-ACCOUNT-NO            42349300
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    42349500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42349600
           IF WS-NULL-PAYMENT < 0                                       
               MOVE ZEROES          TO WS-TOTAL-PAYMENTS                
           END-IF.                                                      
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* 7900-GET                             *'       
               DISPLAY '* ACCOUNT NO    ', DP-ACCOUNT-NO                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                 42351400
       7900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************42348200
      * 7910-GET-TOTAL-CREDIT                                          *42348300
      ******************************************************************42348600
       7910-GET-TOTAL-CREDIT.                                           
      *                                                                 42348800
           EXEC SQL                                                     
              SELECT   SUM(RN.AMT_REFUNDED)                             
                INTO   :WS-TOTAL-CREDIT-DEP :WS-NULL-CREDIT              
                FROM   CSS_REFUND RN WITH(READUNCOMMITTED),                     
                       CSS_DEP_ON_HAND AS DO WITH(READUNCOMMITTED)              
               WHERE   DO.ACCOUNT_NO       =  :DO-ACCOUNT-NO            
                 AND   RN.ACCOUNT_NO       =  :DO-ACCOUNT-NO            
                 AND   DO.DEPOSIT_CERT_NO  =  RN.DEPOSIT_CERT_NO        
ACT109           AND   DO.DEPOSIT_STATUS_CD    IN ('A', 'P', 'R')       
                 AND   DO.AMT_REFUNDED     > 0                          
                 AND   RN.MANUAL_INDICATOR     IN ('E')                 
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42348900
MFA-TR*       SELECT   SUM(RN.AMT_REFUNDED)                             42349000
MFA-TR*         INTO   :WS-TOTAL-CREDIT-DEP:WS-NULL-CREDIT              42349100
MFA-TR*         FROM   CSS_REFUND RN,                                   42349200
MFA-TR*                CSS_DEP_ON_HAND AS DO                                    
MFA-TR*        WHERE   DO.ACCOUNT_NO       =  :DO-ACCOUNT-NO            42349300
MFA-TR*          AND   RN.ACCOUNT_NO       =  :DO-ACCOUNT-NO                    
MFA-TR*          AND   DO.DEPOSIT_CERT_NO  =  RN.DEPOSIT_CERT_NO                
MFA-TR*          AND   DO.DEPOSIT_STATUS_CD    IN ('A', 'P', 'R')               
MFA-TR*          AND   DO.AMT_REFUNDED     > 0                                  
MFA-TR*          AND   RN.MANUAL_INDICATOR     IN ('E')                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    42349500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42349600
           IF WS-NULL-CREDIT  < 0                                       
               MOVE ZEROES          TO WS-TOTAL-CREDIT-DEP              
           END-IF.                                                      
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '* 7910-GET-TOTAL-CREDIT                *'       
               DISPLAY '* ACCOUNT NO    ', DO-ACCOUNT-NO                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                 42351400
       7910-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 37450100
      * 7990-SELECT-DEP-PAY-AMT                                       * 37451000
      *      MODULE GETS THE TOTAL PAYMENTS ON A SPECIFIED DEPOSIT    * 37453000
      ***************************************************************** 37454000
       7990-SELECT-DEP-PAY-AMT.                                         
      *                                                                 37457000
           EXEC SQL                                                     
              SELECT   SUM(DEP_PAY_AMT)                                 
                INTO   :WS-TOTAL-PAYMENTS-BY-DEP 
                       :WS-TOTAL-PAYMENTS-BY-DEP-NI                     
                FROM   CSS_DEP_PAY_HST WITH(READUNCOMMITTED)                    
               WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO               
                 AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO          
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     37458000
MFA-TR*       SELECT   SUM(DEP_PAY_AMT)                                 37459000
MFA-TR*         INTO   :WS-TOTAL-PAYMENTS-BY-DEP                        37459100
MFA-TR*                :WS-TOTAL-PAYMENTS-BY-DEP-NI                             
MFA-TR*         FROM   CSS_DEP_PAY_HST                                  37459200
MFA-TR*        WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO               37459300
MFA-TR*          AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO          37459400
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    37459500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37459600
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                 37459800
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-TOTAL-PAYMENTS-BY-DEP-NI < 0                       
                   MOVE ZEROES      TO WS-TOTAL-PAYMENTS-BY-DEP         
               END-IF                                                   
           ELSE                                                         
               DISPLAY '* 7990-SELECT                          *'       
               DISPLAY '* ACCOUNT NO    ', DP-ACCOUNT-NO                
               DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE           
               PERFORM 9900-ABEND                   THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                 37461100
       7990-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 37462000
      * 8200-INSERT-REFUND                                            * 37470000
      *      INSERT REFUND REQUEST DETAILS IN CSS_REFUND TABLE        * 37490000
      ***************************************************************** 37500000
       8200-INSERT-REFUND.                                              
      *                                                                 37530000
           EXEC SQL                                                     
              INSERT INTO CSS_REFUND                                    
                     (ACCOUNT_NO,                                       
                      REFUND_ITEM_ID,                                   
                      AMT_REFUNDED,                                     
                      CHECK_STATUS_CD,                                  
                      CHECK_ISS_REAS_CD,                                
                      COMMENTS,                                         
                      DATE_REFUNDED,                                    
                      REQUEST_DT,                                       
                      DEPOSIT_CERT_NO,                                  
                      PANEL_NO,                                         
                      USER_ID_RQSTED_BY,                                
                      MANUAL_INDICATOR,                                 
                      REFUND_CHECK_NO,                                  
                      LOCAL_OFFICE,                                     
                      ORIGINAL_CHECK_NO,                                
                      RETURNED_REASON,                                  
                      USER_ID_APPRVD_BY,                                
                      REFUND_STATUS_DT,                                 
                      TRANS_HIST_SEQ_NO,                                
                      ADDRESS_ID,                                       
                      ACCT_NO_CREDITED)                                 
              VALUES (:RN-ACCOUNT-NO,                                   
                      :RN-REFUND-ITEM-ID,                               
                      :RN-AMT-REFUNDED,                                 
                      :RN-CHECK-STATUS-CD,                              
                      :RN-CHECK-ISS-REAS-CD,                            
                      :RN-COMMENTS,                                     
                      IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED) <> 10), CIS.CHAR2DATE(
                                                      :RN-DATE-REFUNDED
              ), CONVERT(DATE, :RN-DATE-REFUNDED) ),                           
                      IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT 
                                            :WS-RN-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                      :WS-RN-NULL-IND-1
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-RN-NULL-IND-1) ),            
                      :RN-DEPOSIT-CERT-NO,                              
                      :RN-PANEL-NO,                                     
                      :RN-USER-ID-RQSTED-BY,                            
                      :RN-MANUAL-INDICATOR,                             
                      :RN-REFUND-CHECK-NO,                              
                      :RN-LOCAL-OFFICE,                                 
                      :RN-ORIGINAL-CHECK-NO,                            
                      :RN-RETURNED-REASON,                              
                      :RN-USER-ID-APPRVD-BY,                            
                      IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ),                        
                      CIS.CHAR2TIMESTAMP(:RN-TRANS-HIST-SEQ-NO),                
                      :RN-ADDRESS-ID,                                   
                      :RN-ACCT-NO-CREDITED)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     37540000
MFA-TR*       INSERT INTO CSS_REFUND                                    37550000
MFA-TR*              (ACCOUNT_NO,                                       37560000
MFA-TR*               REFUND_ITEM_ID,                                   37570000
MFA-TR*               AMT_REFUNDED,                                     37580000
MFA-TR*               CHECK_STATUS_CD,                                  37590000
MFA-TR*               CHECK_ISS_REAS_CD,                                37600000
MFA-TR*               COMMENTS,                                         37610000
MFA-TR*               DATE_REFUNDED,                                    37620000
MFA-TR*               REQUEST_DT,                                       37621000
MFA-TR*               DEPOSIT_CERT_NO,                                  37630000
MFA-TR*               PANEL_NO,                                         37640000
MFA-TR*               USER_ID_RQSTED_BY,                                37650000
MFA-TR*               MANUAL_INDICATOR,                                 37660000
MFA-TR*               REFUND_CHECK_NO,                                  37665000
MFA-TR*               LOCAL_OFFICE,                                     37670000
MFA-TR*               ORIGINAL_CHECK_NO,                                37690000
MFA-TR*               RETURNED_REASON,                                  37700000
MFA-TR*               USER_ID_APPRVD_BY,                                37710000
MFA-TR*               REFUND_STATUS_DT,                                 37720000
MFA-TR*               TRANS_HIST_SEQ_NO,                                37730000
MFA-TR*               ADDRESS_ID,                                       37740000
MFA-TR*               ACCT_NO_CREDITED)                                 37741000
MFA-TR*       VALUES (:RN-ACCOUNT-NO,                                   37750000
MFA-TR*               :RN-REFUND-ITEM-ID,                               37760000
MFA-TR*               :RN-AMT-REFUNDED,                                 37770000
MFA-TR*               :RN-CHECK-STATUS-CD,                              37780000
MFA-TR*               :RN-CHECK-ISS-REAS-CD,                            37790000
MFA-TR*               :RN-COMMENTS,                                     37800000
MFA-TR*               :RN-DATE-REFUNDED,                                37810000
MFA-TR*               :RN-REQUEST-DT:WS-RN-NULL-IND-1,                  37811000
MFA-TR*               :RN-DEPOSIT-CERT-NO,                              37820000
MFA-TR*               :RN-PANEL-NO,                                     37830000
MFA-TR*               :RN-USER-ID-RQSTED-BY,                            37840000
MFA-TR*               :RN-MANUAL-INDICATOR,                             37850000
MFA-TR*               :RN-REFUND-CHECK-NO,                              37860000
MFA-TR*               :RN-LOCAL-OFFICE,                                 37870000
MFA-TR*               :RN-ORIGINAL-CHECK-NO,                            37880000
MFA-TR*               :RN-RETURNED-REASON,                              37890000
MFA-TR*               :RN-USER-ID-APPRVD-BY,                            37900000
MFA-TR*               :RN-REFUND-STATUS-DT,                             37910000
MFA-TR*               :RN-TRANS-HIST-SEQ-NO,                            37920000
MFA-TR*               :RN-ADDRESS-ID,                                   37930000
MFA-TR*               :RN-ACCT-NO-CREDITED)                             37931000
MFA-TR*    END-EXEC.                                                    37940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37950000
           MOVE SQLCODE              TO WS-ACTIVE-RETURN-CODE.          
      *                                                                 37970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 8200-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 38140000
       8200-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 39960000
      * 8400-UPDATE-DEP-ON-HAND                                       * 39970000
      *     UPDATE THE DETAILS IN CSS_DEP_ON_HAND TABLE               * 39990000
      ***************************************************************** 40000000
       8400-UPDATE-DEP-ON-HAND.                                         
      *                                                                 40030000
           EXEC SQL                                                     
              UPDATE CSS_DEP_ON_HAND                                    
              SET    AMT_DEPOSIT        = :DO-AMT-DEPOSIT,              
                     AMT_REFUNDED       = :DO-AMT-REFUNDED,             
                     INTRST_YTD         = :DO-INTRST-YTD,               
                     TOTAL_INTRST       = :DO-TOTAL-INTRST,             
                     DATE_INTST_CALC_TO =                               
                      IIF(TRY_CONVERT(DATE, :DO-DATE-INTST-CALC-TO 
                                            :WS-DATE-INTST-CALC-TO-NI
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) <> 0) OR (LEN(:DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) <> 10), CIS.CHAR2DATE(:DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ), CONVERT(DATE, :DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) ),  
                     DEPOSIT_STATUS_CD  = :DO-DEPOSIT-STATUS-CD,        
                     DATE_CERT_ISSUE    =                               
                      IIF(TRY_CONVERT(DATE, :DO-DATE-CERT-ISSUE 
                                            :WS-DATE-CERT-ISSUE-NI
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-CERT-ISSUE 
                                                 :WS-DATE-CERT-ISSUE-NI
              ) <> 0) OR (LEN(:DO-DATE-CERT-ISSUE 
                                                 :WS-DATE-CERT-ISSUE-NI
              ) <> 10), CIS.CHAR2DATE(:DO-DATE-CERT-ISSUE 
                                                 :WS-DATE-CERT-ISSUE-NI
              ), CONVERT(DATE, :DO-DATE-CERT-ISSUE 
                                                 :WS-DATE-CERT-ISSUE-NI
              ) ),        
                     CODE_REFUND_STATUS = :DO-CODE-REFUND-STATUS        
              WHERE  DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO AND          
                     ACCOUNT_NO      = :DO-ACCOUNT-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     40040000
MFA-TR*       UPDATE CSS_DEP_ON_HAND                                    40050000
MFA-TR*       SET    AMT_DEPOSIT        = :DO-AMT-DEPOSIT,              40060000
MFA-TR*              AMT_REFUNDED       = :DO-AMT-REFUNDED,             40070000
MFA-TR*              INTRST_YTD         = :DO-INTRST-YTD,               40080000
MFA-TR*              TOTAL_INTRST       = :DO-TOTAL-INTRST,             40090000
MFA-TR*              DATE_INTST_CALC_TO =                               40100000
MFA-TR*               :DO-DATE-INTST-CALC-TO:WS-DATE-INTST-CALC-TO-NI,  40110000
MFA-TR*              DEPOSIT_STATUS_CD  = :DO-DEPOSIT-STATUS-CD,        40140000
MFA-TR*              DATE_CERT_ISSUE    =                               40151000
MFA-TR*               :DO-DATE-CERT-ISSUE:WS-DATE-CERT-ISSUE-NI,        40152000
MFA-TR*              CODE_REFUND_STATUS = :DO-CODE-REFUND-STATUS        40153000
MFA-TR*       WHERE  DEPOSIT_CERT_NO = :DO-DEPOSIT-CERT-NO AND          40160000
MFA-TR*              ACCOUNT_NO      = :DO-ACCOUNT-NO                   40170000
MFA-TR*    END-EXEC.                                                    40180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 40190000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 40210000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 8400-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 40360000
       8400-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 42130000
      * 8520-UPDATE-ACCOUNT                                           * 42140000
      *     UPDATE THE DETAILS INTO CSS_ACCOUNT TABLE                 * 42160000
      ***************************************************************** 42170000
       8520-UPDATE-ACCOUNT.                                             
      *                                                                 42200000
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
              SET    CODES_DATA_PRESENT     = :AT-CODES-DATA-PRESENT,   
                     MAX_DEP_REF_XMT_CD     = :AT-MAX-DEP-REF-XMT-CD,   
                     DATE_LAST_ACTION       = CAST(SYSDATETIMEOFFSET() 
           AS DATE),             
                     LAST_UPDATE_TS         = CIS.CURRENT$TIMESTAMP()         
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     42210000
MFA-TR*       UPDATE CSS_ACCOUNT                                        42220000
MFA-TR*       SET    CODES_DATA_PRESENT     = :AT-CODES-DATA-PRESENT,   42240000
MFA-TR*              MAX_DEP_REF_XMT_CD     = :AT-MAX-DEP-REF-XMT-CD,           
MFA-TR*              DATE_LAST_ACTION       = CURRENT DATE,                     
MFA-TR*              LAST_UPDATE_TS         = CURRENT TIMESTAMP                 
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        42260000
MFA-TR*    END-EXEC.                                                    42270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42280000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 8520-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 42430000
       8520-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 42130000
      * 8525-UPDATE-MAX-DEP                                           * 42140000
      *     UPDATE THE DETAILS INTO CSSW_MAX_DEP TABLE                * 42160000
      ***************************************************************** 42170000
       8525-UPDATE-MAX-DEP.                                             
      *                                                                 42200000
           EXEC SQL                                                     
              UPDATE CSS_MAX_DEP_REVIEW                                 
               SET   LAST_MAX_AT_REV_DT     = IIF(TRY_CONVERT(DATE, 
                                                 :MG-LAST-MAX-AT-REV-DT
              ) IS NULL OR (PATINDEX('%.%', :MG-LAST-MAX-AT-REV-DT
              ) <> 0) OR (LEN(:MG-LAST-MAX-AT-REV-DT
              ) <> 10), CIS.CHAR2DATE(:MG-LAST-MAX-AT-REV-DT
              ), CONVERT(DATE, :MG-LAST-MAX-AT-REV-DT) ),   
                     MAX_DEP_AT_REV_AM      = :MG-MAX-DEP-AT-REV-AM,    
                     PD_DEP_AT_REV_AM       = :MG-PD-DEP-AT-REV-AM,     
                     MAX_DEP_REFUND_CD      = :MG-MAX-DEP-REFUND-CD,    
                     LAST_UPDATE_TS         = CIS.CURRENT$TIMESTAMP()         
              WHERE  ACCOUNT_NO = :MG-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42210000
MFA-TR*       UPDATE CSS_MAX_DEP_REVIEW                                 42220000
MFA-TR*        SET   LAST_MAX_AT_REV_DT     = :MG-LAST-MAX-AT-REV-DT,   42230000
MFA-TR*              MAX_DEP_AT_REV_AM      = :MG-MAX-DEP-AT-REV-AM,    42240000
MFA-TR*              PD_DEP_AT_REV_AM       = :MG-PD-DEP-AT-REV-AM,     42250000
MFA-TR*              MAX_DEP_REFUND_CD      = :MG-MAX-DEP-REFUND-CD,            
MFA-TR*              LAST_UPDATE_TS         = CURRENT TIMESTAMP                 
MFA-TR*       WHERE  ACCOUNT_NO = :MG-ACCOUNT-NO                        42260000
MFA-TR*    END-EXEC.                                                    42270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42280000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 8525-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 42430000
       8525-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 42130000
      * 8526-INSERT-MAX-DEP                                           * 42140000
      *     INSERT THE DETAILS INTO CSS_MAX_DEP_REVIEW TABLE           *42160000
      ***************************************************************** 42170000
       8526-INSERT-MAX-DEP.                                             
      *                                                                 42200000
           EXEC SQL                                                     
              INSERT INTO CSS_MAX_DEP_REVIEW                            
                     (ACCOUNT_NO,                                       
                     LAST_MAX_AT_REV_DT,                                
                     MAX_DEP_AT_REV_AM,                                 
                     PD_DEP_AT_REV_AM,                                  
                     MAX_DEP_REFUND_CD,                                 
                     LAST_UPDATE_TS)                                    
              VALUES (:MG-ACCOUNT-NO,                                   
                      IIF(TRY_CONVERT(DATE, :MG-LAST-MAX-AT-REV-DT
              ) IS NULL OR (PATINDEX('%.%', :MG-LAST-MAX-AT-REV-DT
              ) <> 0) OR (LEN(:MG-LAST-MAX-AT-REV-DT
              ) <> 10), CIS.CHAR2DATE(:MG-LAST-MAX-AT-REV-DT
              ), CONVERT(DATE, :MG-LAST-MAX-AT-REV-DT) ),                      
                      :MG-MAX-DEP-AT-REV-AM,                            
                      :MG-PD-DEP-AT-REV-AM,                             
                      :MG-MAX-DEP-REFUND-CD,                            
                      CIS.CURRENT$TIMESTAMP())                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42210000
MFA-TR*       INSERT INTO CSS_MAX_DEP_REVIEW                            42220000
MFA-TR*              (ACCOUNT_NO,                                               
MFA-TR*              LAST_MAX_AT_REV_DT,                                42230000
MFA-TR*              MAX_DEP_AT_REV_AM,                                 42240000
MFA-TR*              PD_DEP_AT_REV_AM,                                  42250000
MFA-TR*              MAX_DEP_REFUND_CD,                                         
MFA-TR*              LAST_UPDATE_TS)                                            
MFA-TR*       VALUES (:MG-ACCOUNT-NO,                                   42230000
MFA-TR*               :MG-LAST-MAX-AT-REV-DT,                           42230000
MFA-TR*               :MG-MAX-DEP-AT-REV-AM,                            42240000
MFA-TR*               :MG-PD-DEP-AT-REV-AM,                             42250000
MFA-TR*               :MG-MAX-DEP-REFUND-CD,                                    
MFA-TR*               CURRENT TIMESTAMP)                                        
MFA-TR*    END-EXEC.                                                    42270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42280000
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 8526-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 42430000
       8526-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 42451000
      * 8530-UPDATE-AR-HIST                                           * 42452000
      *     UPDATE SUMMARY OF AR_TRANS_HIST; SET REFUNDED INDICATOR   * 42454000
      *     TO 'Y' FOR FULLY REFUNDED DEPOSITS                        * 42454100
      ***************************************************************** 42455000
       8530-UPDATE-AR-HIST.                                             
      *                                                                 42457100
           EXEC SQL                                                     
             SELECT GL_ACCT_NO                                          
             INTO   :GO-GL-ACCT-NO                                      
             FROM   CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                        
             WHERE  GL_ACCT_NAME      = 'AR-DEP'                        
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     42457200
MFA-TR*      SELECT GL_ACCT_NO                                          42458000
MFA-TR*      INTO   :GO-GL-ACCT-NO                                      42458100
MFA-TR*      FROM   CSS_GL_ACCT_NO                                      42459000
MFA-TR*      WHERE  GL_ACCT_NAME      = 'AR-DEP'                        42459100
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    42459200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42459300
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42459500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 8530-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 42460800
           EXEC SQL                                                     
             UPDATE CSS_AR_TRANS_HIST                                   
             SET    PYMT_REFUNDED_IND = 'Y'                             
             WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO                  
             AND  ( CODE_TRAN_TYPE    = 'P'                             
                   AND   TRANS_HIST_SEQ_NO IN                           
                   ( SELECT DISTINCT  TRANS_HIST_SEQ_NO                 
                    FROM   CSS_AR_TRN_HST_DET                           
                    WHERE  ACCOUNT_NO    = :AT-ACCOUNT-NO               
                    AND    GL_ACCT_CREDIT = :GO-GL-ACCT-NO              
                    AND    ITEM_ID        = :DO-DEPOSIT-CERT-NO))       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42470100
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42470300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 8530-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 42471600
       8530-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 42451000
      * 8535-UPDATE-AR-HIST SUMMARY FOR THE DEPOSIT REFUND RECORD     * 42452000
      ***************************************************************** 42455000
       8535-UPDATE-AR-TRANS-HIST.                                       
           EXEC SQL                                                     
             UPDATE CSS_AR_TRANS_HIST                                   
             SET    AMT_ORIG_ENTERED = :RN-AMT-REFUNDED                 
             WHERE  ACCOUNT_NO          = :AT-ACCOUNT-NO                
             AND    CODE_TRAN_TYPE      = 'R'                           
             AND    TRANS_HIST_SEQ_NO   = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42460900
MFA-TR*      UPDATE CSS_AR_TRANS_HIST                                   42461000
MFA-TR*      SET    AMT_ORIG_ENTERED = :RN-AMT-REFUNDED                 42462000
MFA-TR*      WHERE  ACCOUNT_NO          = :AT-ACCOUNT-NO                42463000
MFA-TR*      AND    CODE_TRAN_TYPE      = 'R'                           42465000
MFA-TR*      AND    TRANS_HIST_SEQ_NO   = :AR-TRANS-HIST-SEQ-NO         42466000
MFA-TR*    END-EXEC.                                                    42470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42470100
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
      *                                                                 42470300
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '* 8535-                                *'        
              DISPLAY '* ACCOUNT NO    ', AT-ACCOUNT-NO                 
              DISPLAY '* SQLCODE IS ', WS-ACTIVE-RETURN-CODE            
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
      *                                                                 42471600
       8535-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      ****************************************************************  19172000
      ** 8895-INSERT-WORK-QUEUE                                         19174000
      ****************************************************************  19177000
A04860 8895-INSERT-WORK-QUEUE.                                          
A04860                                                                  
A04860     CALL SCSCB077  USING   CWS00077-FIELDS,                      
A04860                            ABEND-FILE,                           
A04860                            RS-RETURN-CODE.                       
A04860*                                                                         
A04860     MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
A04860                                                                  
A04860     IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
A04860        MOVE WS-PGRMNAME              TO ABEND-PROGRAM            
A04860        DISPLAY '8895-INSERT-WORK-QUEUE'                          
A04860        DISPLAY 'CALL SCSCB077         '                          
A04860        DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
A04860        DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
A04860        DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
A04860        DISPLAY 'COMMENTS        ' WS-77-COMMENTS                 
A04860        DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
A04860        PERFORM 9900-ABEND    THRU 9900-EXIT                      
A04860     END-IF.                                                      
A04860                                                                  
A04860 8895-EXIT.                                                       
A04860     EXIT.                                                        
A04860                                                                  
      ****************************************************************          
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK             *          
      ****************************************************************          
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      ****************************************************************          
      *  CLOSES  THE INPUT  FILE                                    **          
      ****************************************************************          
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSDB07-FILE                                           
      *                                                                         
           IF  FDB07-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'ERROR IN CLOSING FCSDB07-FILE'                  
               DISPLAY 'ERROR STATUS ' WS-FDB07-STATUS                  
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK             *          
      ****************************************************************          
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  WS-DB2-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' WS-DB2-PARAGRAPH
           END-IF.            
           IF  WS-DB2-FUNCTION > SPACES                                 
               DISPLAY '**  FUNCTION   = ' WS-DB2-FUNCTION
           END-IF.             
           IF  ACTIVE-PARAGRAPH > SPACES                                
               DISPLAY '**  PARAGRAPH  = ' ACTIVE-PARAGRAPH
           END-IF.            
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
           DISPLAY '**************************************'.            
      ****************************************************************          
      *  COPY BOOK CONTAINING 9700-PROCESS-ABEND                 ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
