       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA097.                                        
       DATE-WRITTEN.   JUN 2010.                                        
      ***************************************************************** 00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                * 00000501
      **                                                              * 00000601
      ********            CUSTOMER SERVICE SYSTEM             ********* 00000701
      ********                      DB2                       ********* 00000801
      **                                                              * 00000601
      *****************************************************************         
      **-------------- P R O G R A M  S U M M A R Y -----------------**         
      *****************************************************************         
      **   THIS MODULE PROCESSES DEPOSIT REFUNDS FOR ALL THE ACCOUNTS**         
      **   IN DB07 FILE. IF CUSTOMER OBTAINS GOOD CREDIT IT REFUNDS  **         
      **   DEPOSIT AND INTEREST ELSE REFUNDS INTEREST ONLY. REFUND   **         
      **   WILL BE CREDITED TO THE ACCOUNT.                          **         
P00399*****************************************************************         
P00399** CSR COMMERCIAL/INDUSTRIAL DEPOSITS                          **         
P00399** **********************************                          **         
P00399**   - REFUND INTEREST DURING 13TH MONTH FIRST TIME & THEN FOR **         
P00399**     EVERY 12 MONTHS                                         **         
P00399**   - RETAIN FOR 'RETAIN-COMMER-DEP/RETAIN-INDUST-DEP' MONTHS **         
P00399**   - IF ONE OF THE DEPOSITS ELIGIBLE FOR REFUND, REFUND ALL  **         
P00399**     THE OTHER DEPOSITS INCLUDING BILLED DEPOSITS.           **         
P00399**                                                             **         
P00399** CSR RESIDENTIAL DEPOSITS                                    **         
P00399** ************************                                    **         
P00399**   - REFUND INTEREST DURING 13TH MONTH FIRST TIME & THEN FOR **         
P00399**     EVERY 12 MONTHS                                         **         
P00399**   - RETAIN FOR 'RETAIN-RESIDENT-DEP' MONTHS                 **         
P00399**   - IF ONE OF THE DEPOSITS ELIGIBLE FOR REFUND, REFUND ALL  **         
P00399**     THE OTHER DEPOSITS INCLUDING BILLED DEPOSITS.           **         
P00399**                                                             **         
P00399** SEB RESIDENTIAL/COMMERCIAL/INDUSTRIAL DEPOSITS              **         
P00399** **********************************************              **         
P00399**   - REFUND INTEREST FOR EVERY 'RETAIN-RESIDENT-DEP' MONTHS  **         
P00399**     (SOME TIME IT COULD BE 'RETAIN-RESIDENT-DEP + 1' MONTH) **         
P00399**   - RETAIN FOR 'RETAIN-RESIDENT-DEP' MONTHS                 **         
P00399**                                                             **         
P00399** PSNC - TOTAL # OF ARREARS WILL DETERMINE GOOD CREDIT.       **         
      *****************************************************************         
      **------------- PROGRAM  MODIFICATION  LOG --------------------**         
      *****************************************************************         
      **      PCSCA097   PROGRAM  MODIFICATION  LOG                  **         
      **                                                             **         
      **    DATE    INITIALS  REASON                                 **         
      **   _______  ________  ______                                 **         
P00394**   6/08/10  SP95538   STAND-ALONE VERSION OF SCSCA101.       **         
P00399**   8/30/10  SP95538  -REMOVE BALANCE CREDIT GROUP FOR CSR    **         
P00399**                     -REMOVE FCSCA097 O/P FILE               **         
P00399**                     -REFUND/CREDIT BILLED DEPOSITS          **         
P00399**                     -ADDED FILES FCSCA347& FCSC347R FOR     **         
P00399**                      REVERSING UNPAID DEPOSITS IN PCSCA348. **         
P00399**  11/8/10   MJ13662  -TOTAL ARREARS WILL DETERMINE GOOD CREDIT*         
P00399**                      FOR PSNC.                              **         
A02034**  12/8/10   NC94746   REFUND ONLY INTEREST IN CASE OF        **         
A02034**                      COMMERCIAL/INDUSTRIAL CUSTOMERS AND    **         
A02034**                      NOT ELIG FOR REFUND INDICATOR SET.     **         
A02034**                      NO CHANGES TO RESIDENTIAL CUSTOMERS.   **         
ACT002**  01/25/11  GD97441   1.2210 PARA:FIXED INITIALIZATION ISSUE.**         
ACT002**  (APPL 3082)         2.9900 PARA:ADDED DISPLAY STATEMENTS   **         
ACT002**                        FOR ABEND HANDLING.                  **         
A03175**  02/24/11  MC95456  1. CHANGES TO GET ARREARS LIMIT FROM    **         
A03175**                        CSS_DELINQUENCY                      **         
A03175**                     2. FOR SEB HOLD ARREARS LIMIT WILL BE   **         
A03175**                        COMPARED WITH DELINQ ARREARS LIMIT   **         
P00518** 05/25/2011 WR19680   CHANGES DELINQUENCY VALUE FOR RESIDENTIAL         
P00518**                      DEPOSIT FROM 12 TO 24 MONTHS.  CHANGE  **         
P00518**                      RELEASE OF DEPOSIT TO CHECK TO SEE IF             
P00518**                      DEPOSIT SHOULD BE GRAND-FATHERED.  THIS           
P00518**                      IS ONLY FOR SCEG RESIDENTIAL.                     
P00471**09/13/2011  SP95538   ADD '4' FOR PSNC GOOD CREDIT RULE.     **         
ACT121**10/19/2012  SV95326   FIX FOR DEPOSIT REFUND ISSUE BEFORE    **         
ACT121**            A*3967    24 MONTHS.                             **         
A04531**01/16/2013  MC95456   REFUND-INTEREST DELINQUENCY IS ADDED TO**         
A04531**                      DETERMINE INTEREST ELIGIBILITY         **         
ACT121**07/30/2013  VIJAY   1.EXCLUDE ACCOUNT FROM PROCESSING        **         
ACT121** A04527               (WHEN UPDATED THROUGH ACCOUT DETAIL    **         
ACT121**                       PANEL TO EXCLUDE FROM PROCESSING).    **         
ACT121**                    2.DELETED UNUSED DCLGENS.                **         
ACT233**08/04/2014  MC95456   FIX TO DETERMINE INTEREST ELIGIBILITY  **         
ACT233**                      WHEN THERE IS NO ENOUGH CREDIT HISTORY.**         
ACT053**04/15/2016 SS7F226    WORK QUEUE CHANGE TO REPLACE THE       **         
ACT053**           A04860     CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.     **         
A05460**10/10/2016 SM93554    SET DEFAULT ONE FOR INDEX VARIABLE     **         
      **            DEFT83    AS PART OF MICRO FOCUS CONVERSION.     **         
      *****************************************************************         
      **----------------- BASIC SEQUENCE STRUCTURE ------------------**         
      *****************************************************************         
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION**         
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH       **         
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH      **         
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED **         
      **         5000 - 5999     COMMON PROGRAM MODULES              **         
      **         6000 - 6999     COMMON SYSTEM MODULES               **         
      **         7000 - 7999     INPUT MODULES                       **         
      **         8000 - 8999     OUTPUT MODULES                      **         
      **         9000 - 9799     TERMINATION MODULES                 **         
      **         9900 - 9999     ABEND/ABORT MODULES                 **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSDB07.                                                            
      *                                                                 00573020
P00399* UN-PAID DEP REFUND FILE                                         00573020
P00399*                                                                 00573020
P00399 COPY CSSCA347.                                                           
P00399*                                                                 00573020
P00399* RESTART FILE FOR FCSCA347                                       00573020
P00399*                                                                 00573020
P00399 COPY CSSCA347 REPLACING FCSCA347-FILE    BY FCA347R-FILE,        00005401
P00399                         UT-S-FCSCA347    BY UT-S-FCSC347R,       00005501
P00399                         WS-FCA347-STATUS BY WS-FCA347R-STATUS.   00005601
P00399*                                                                 00573020
       DATA DIVISION.                                                   
      *                                                                 00574020
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
      *                                                                 00540000
P00399 COPY CFDCA347.                                                           
P00399 COPY FIOCA347.                                                           
P00399*                                                                 00573020
P00399 COPY CFDCA347 REPLACING FCSCA347-FILE BY FCA347R-FILE.           00006701
P00399 01 WS-FCA347R                       PIC X(74).                   
P00399*                                                                 00006802
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA097'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA097 STARTS HERE'.            
      *                                                                         
       01  WS-CONSTANTS.                                                
           05  WS-PGRMNAME                 PIC X(08)  VALUE 'PCSCA097'. 
           05  PROGRAM-NAME                PIC X(08)  VALUE 'PCSCA097'. 
           05  SCSCB061                    PIC X(08)  VALUE 'SCSCB061'. 
ACT053     05  SCSCB077                    PIC X(08)  VALUE 'SCSCB077'. 
ACT053     05  MCSCB077                    PIC X(08)  VALUE 'MCSCB077'. 
           05  WS-INDIRECT-JRNL            PIC X(01)  VALUE 'A'.        
           05  WS-GOOD-CREDIT              PIC X(01)  VALUE 'G'.        
           05  WS-INTEREST-RFND            PIC X(02)  VALUE 'IN'.       
           05  WS-APPLIED-TO-ACCT          PIC X(01)  VALUE 'A'.        
           05  WS-M                        PIC X(01)  VALUE 'M'.        
           05  WS-BATCH                    PIC X(01)  VALUE 'B'.        
           05  WS-YES                      PIC X(01)  VALUE 'Y'.        
           05  WS-NO                       PIC X(01)  VALUE 'N'.        
           05  WS-OVER-30                  PIC X(01)  VALUE '1'.        
           05  WS-OVER-60                  PIC X(01)  VALUE '2'.        
           05  WS-3                        PIC X(01)  VALUE '3'.        
           05  WS-4                        PIC X(01)  VALUE '4'.        
           05  WS-I                        PIC X(01)  VALUE 'I'.        
           05  WS-R                        PIC X(01)  VALUE 'R'.        
           05  WS-MAX-MONTH                PIC S9(02) VALUE +12.        
           05  WS-MAX-MONTH2               PIC S9(02) VALUE +06.        
           05  WS-MAX-MONTHXX              PIC S9(02) VALUE ZERO.       
           05  WS-SYSTEM                   PIC X(07)  VALUE 'SYSTEM '.  
           05  WS-REFUND                   PIC X(04)  VALUE 'RFND'.     
      *                                                                         
ACT053 01  WS-CPD0010S-CALL-TYPE           PIC X(01)  VALUE 'B'.        
ACT053     88  WS-CPD0010S-ONLINE-CALL                VALUE 'O'.        
ACT053     88  WS-CPD0010S-BATCH-CALL                 VALUE 'B'.        
      *                                                                         
       01  WS-CASH-DRAWER.                                              
           05  WS-CD-COMPANY-NO            PIC X(02)  VALUE '01'.       
           05  WS-CD-LOCAL-OFFICE          PIC X(03)  VALUE SPACES.     
           05  WS-CD-REPORT-NO             PIC X(03)  VALUE '997'.      
           05  WS-CD-REPORT-DATE           PIC X(10)  VALUE SPACES.     
           05  WS-CASH-DRAWER-ID           PIC S9(04) COMP VALUE 9999.  
      *                                                                         
       01  WS-COUNTERS.                                                 
           05  WS-MONTH                    PIC S9(02) COMP VALUE ZERO.  
           05  WS-MONTH2                   PIC S9(02) COMP VALUE ZERO.  
           05  WS-TOT-MOS-IN-ARREARS       PIC S9(02) COMP VALUE ZERO.  
           05  WS-RECENT-DEP-COUNT         PIC S9(04) COMP VALUE ZERO.  
      *                                                                         
       01  WS-TEMP-VARIABLES.                                           
COB305     05 WS-AMOUNT-TEMP        PIC S9(11)V99 COMP-3 VALUE 0.        
COB305     05 WS-AMOUNT-TEMP2        PIC S9(11)V99 COMP-3 VALUE 0.        
           05  WS-DETAIL-END-AR-BAL        PIC S9(11)V99 VALUE ZERO.    
           05  WS-DATE-CSR-MONTHS-AGO      PIC X(10) .                  
           05  WS-DATE-SEB-MONTHS-AGO      PIC X(10) .                  
           05  WS-CURRENT-DATE             PIC X(10) .                  
           05  WS-CURRENT-TIMESTAMP        PIC X(26) .                  
           05  WS-DISPLAY-SQLCODE          PIC -Z(8)9 VALUE ZERO.       
           05  RS-RETURN-CODE              PIC S9(4) COMP VALUE ZERO.   
           05  RS-RETURN-CODE-DISP         PIC S9(04) VALUE ZERO.       
           05  WS-FCSCA097-REC-COUNT       PIC Z9(06)9 VALUE ZERO.      
           05  WS-DB07-REC-CNTR            PIC Z9(06)9 VALUE ZERO.      
P00399     05  WS-ACCOUNT-NO               PIC 9(13) VALUE 0.           
           05  WS-FCSCA097-COMMIT-COUNT    PIC Z9(06)9 VALUE ZERO.      
           05  WS-REV-DT                   PIC X(06).                   
           05  WS-REV-DT-ALPHA REDEFINES WS-REV-DT.                     
               10  WS-REV-YR               PIC X(04).                   
               10  WS-REV-MTH              PIC X(02).                   
      *                                                                         
       01  WS-RESTART-MISC.                                             
P00399     05  WS-RESTART-DATA-LENGTH      PIC S9(04) COMP VALUE +46.   
           05  WS-IS-THIS-A-RESTART        PIC X(01)  VALUE 'N'.        
               88  WS-THIS-IS-A-RESTART               VALUE 'Y'.        
               88  WS-THIS-IS-NOT-A-RESTART           VALUE 'N'.        
           05  WS-COMMIT-COUNTER           PIC 9(04)  VALUE ZERO.       
           05  WS-DEFAULT-CHKP-LUW-LIMIT   PIC 9(04)  VALUE 100.        
           05  WS-SEQ-NO                   PIC 9(04)  VALUE ZERO.       
           05  WS-CHKP-LUW-LIMIT           PIC 9(04)  VALUE ZERO.       
           05  WS-CHKP-LUW-COUNTER         PIC 9(04)  VALUE ZERO COMP-3.
           05  WS-DEFAULT-CHKP-UPD-LIMIT   PIC 9(04)  VALUE 100.        
           05  WS-CHKP-UPD-LIMIT           PIC 9(04)  VALUE ZERO.       
           05  WS-CHKP-UPD-COUNTER         PIC 9(04)  VALUE ZERO COMP-3.
           05  WS-CHKP-SEQ-NO              PIC 9(05)  VALUE ZERO.       
           05  WS-FCSDB07-REC-CNTR         PIC S9(07) VALUE ZERO COMP-3.
           05  WS-FCSDB07-RESTART-CNTR     PIC S9(07) VALUE ZERO COMP-3.
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE     PIC 9(01).                   
           05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
               WS-RESTART-PROCESS-TYPE     PIC X(01).                   
           05  WS-RESTART-JOB-STATUS       PIC X(01).                   
               88  WS-RUN-COMPLETED-NO-PROBLEMS       VALUE 'A'.        
               88  WS-RERUN-COMPLETED                 VALUE 'B'.        
               88  WS-RERUN-PENDING                   VALUE 'C'.        
           05  WS-RESTART-COMMON-DATE      PIC X(10).                   
           05  WS-RESTART-CHKP-SEQ-NO      PIC 9(05).                   
           05  WS-RESTART-ACCOUNT-NO       PIC X(13)  VALUE SPACES.     
           05  WS-RESTART-FCSDB07-REC-CNTR                              
                                           PIC S9(07) COMP-3 VALUE ZERO.
P00399     05  WS-RESTART-FCA347-REC-CNTR                               
P00399                                     PIC S9(07) COMP-3 VALUE ZERO.
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-1               PIC S9(04) COMP VALUE ZERO.  
           05  WS-NULL-IND-2               PIC S9(04) COMP VALUE ZERO.  
           05  WS-NULL-IND-3               PIC S9(04) COMP VALUE ZERO.  
           05  WS-NULL-IND-4               PIC S9(04) COMP VALUE ZERO.  
           05  WS-NULL-IND-5               PIC S9(04) COMP VALUE ZERO.  
           05  WS-NULL-IND-6               PIC S9(04) COMP VALUE ZERO.  
           05  WS-RN-NULL-IND-1            PIC S9(04) COMP VALUE ZERO.  
           05  WS-NULL-ACCT-CREATE-DT      PIC S9(04) COMP VALUE ZERO.  
           05  WS-DATE-INTST-CALC-TO-NI    PIC S9(04) COMP VALUE ZERO.  
           05  WS-DATE-REFUND-NI           PIC S9(04) COMP VALUE ZERO.  
           05  WS-DATE-ORIG-PYMT-IND       PIC S9(04) COMP VALUE ZERO.  
      *                                                                         
       01  WS-MISC.                                                     
COB305     05 WS-AMT-DEPOSIT        PIC S9(7)V99 USAGE COMP-3 VALUE 0.   
COB305     05 WS-AMT-REFUND        PIC S9(9)V99 USAGE COMP-3 VALUE 0.   
COB305     05 WS-AMT-REFUNDED        PIC S9(9)V99 USAGE COMP-3 VALUE 0.   
ACT053     05  WS-WQ-CALL-PGM              PIC X(08)  VALUE 'SCSCB077'. 
           05  WS-THIS-TRAN-APPL-NO        PIC S9(4)  USAGE COMP.       
           05  WS-LAST-REFUND-ITEM-ID      PIC S9(9)  USAGE COMP.       
COB305     05 WS-HOLD-00-ARREARS-AMT        PIC S9(9)V99 COMP-3 VALUE 0.        
COB305     05 WS-HOLD-30-60-90-ARRS-AMT        PIC S9(9)V99 COMP-3 
COB305       VALUE 0.         
           05  WS-COMMON-DATE              PIC X(10)  VALUE SPACES.     
           05  LS-INPUT-DATE               PIC X(10)  VALUE SPACES.     
           05  WS-PYMT-PRIORITY-LVL-AC     PIC S9(4)  USAGE COMP.       
           05  WS-ACCOUNT-TYPE-CODE-AT     PIC X(1)   VALUE SPACES.     
COB305     05 WS-PREMISE-NO-AT        PIC S9(10)V USAGE COMP-3 VALUE 0.   
COB305     05 WS-CUSTOMER-NO-AT        PIC S9(10)V USAGE COMP-3 VALUE 0.   
           05  WS-COMPANY-NO-AT            PIC X(2)   VALUE SPACES.     
           05  WS-LOCAL-OFFICE-AT          PIC X(3)   VALUE SPACES.     
           05  WS-CREDIT-GROUP-AT          PIC X(1)   VALUE SPACES.     
           05  WS-CODE-ACCT-STAT-AT        PIC X(1)   VALUE SPACES.     
           05  WS-CODES-DATA-PRESENT-AT    PIC X(32)  VALUE SPACES.     
COB305     05 WS-TOTAL-AR-BALANCE-AT        PIC S9(11)V9(2) 
COB305       USAGE COMP-3 VALUE 0.
           05  WS-CODE-COMPANY-ACCT-AT     PIC X(1)   VALUE SPACES.     
COB305     05 WS-REV-MTH-LST-NRML-AT        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-ACCT-CREATE-DT-AT        PIC X(26)  VALUE SPACES.     
           05  WS-MST-SUB-ACCT-IND-AT      PIC X(01)  VALUE SPACES.     
           05  WS-REV-DISTRICT-CD-PR       PIC X(03)  VALUE SPACES.     
           05  WS-CODE-PREMISE-STAT-PR     PIC X(01)  VALUE SPACES.     
           05  WS-CODE-EMPL-ACCT-CU        PIC X(01)  VALUE SPACES.     
           05  WS-ARREARS-HIST-CZ          PIC X(24)  VALUE SPACES.     
           05  WS-DISCONNECT-HIST-CZ       PIC X(24)  VALUE SPACES.     
           05  WS-DISC-EXCEPTN-HIST-CZ     PIC X(24)  VALUE SPACES.     
COB305     05 WS-AMT-AR-DAY-30-AC        PIC S9(9)V99 USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 WS-AMT-AR-DAY-60-AC        PIC S9(9)V99 USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 WS-AMT-AR-DAY-90-AC        PIC S9(9)V99 USAGE COMP-3 
COB305       VALUE 0.   
COB305     05 WS-AMT-AR-DAY-00-AC        PIC S9(9)V99 USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-PREV-ACCT-NO             PIC S9(13)V  USAGE COMP-3    
                                                      VALUE +0.         
           05  WS-12-MOS-CREDIT-HIST       PIC X(01)  VALUE 'Y'.        
           05  WS-06-MOS-CREDIT-HIST       PIC X(01)  VALUE 'Y'.        
           05  WS-ORIG-REFUND-TYPE         PIC X(01)  VALUE SPACES.     
           05  WS-DEP-EXISTS               PIC X(01)  VALUE SPACES.     
P00399     05  WS-FCA347-REC-COUNT         PIC S9(07) COMP-3 VALUE ZERO.
P00518     05  WS-DELINQ-VALUE9              PIC 9999V9999.             
P00518     05  WS-DELINQ-VALUEX REDEFINES WS-DELINQ-VALUE9 PIC X(09).   
P00518     05  WS-GRAND-FATHER-DEPOSIT       PIC X(01) VALUE SPACE.     
P00518     05  WS-RES-SECUR-START-DATE.                                 
P00518         10  WS-RES-SECUR-DATE.                                   
P00518             15  WS-RES-DATE-CCYY      PIC X(4) VALUE SPACES.     
P00518             15  WS-FILLER1-RES        PIC X(1) VALUE '-'.        
P00518             15  WS-RES-DATE-MM        PIC X(2) VALUE SPACES.     
P00518             15  WS-FILLER2-RES        PIC X(1) VALUE '-'.        
P00518             15  WS-RES-DATE-DD        PIC X(2) VALUE SPACES.     
A04531     05  WS-DATE-INT-MNTHS-AGO       PIC X(10)  VALUE SPACES.     
                                                                        
      *                                                                         
P00518 01  WS-DO-DATE-TRANS                  PIC X(10) VALUE SPACES.    
       01  WS-AR-INT-COMMENT-TEXT.                                      
P00399     05  FILLER                      PIC X(33)  VALUE             
P00399       'REFUNDING INTEREST. DEP CERT NO: '.                       
           05  WS-INT-DEP-CERT-NO          PIC 9(04).                   
                                                                        
       01  WS-AR-DEP-COMMENT-TEXT.                                      
P00399     05  FILLER                      PIC X(46)  VALUE             
P00399       'REFUNDING DEPOSIT - GOOD CREDIT. DEP CERT NO: '.          
           05  WS-DEP-CERT-NO              PIC 9(04).                   
                                                                        
      *                                                                         
       01  WS-COM-IND-VARIABLES.                                        
           05  WS-RETAIN-COMMER-DEP        PIC S9(04) COMP VALUE ZERO.  
           05  WS-RETAIN-INDUST-DEP        PIC S9(04) COMP VALUE ZERO.  
           05  WS-RETAIN-RES-DEP           PIC S9(04) COMP VALUE ZERO.  
ACT121     05  WS-RETAIN-RES-DEP-DELQ      PIC S9(04) COMP VALUE ZERO.  
A04531     05  WS-DELINQ-REFUND-INT        PIC S9(04) COMP VALUE ZERO.  
           05  WS-CURR-CO                  PIC X(02)  VALUE SPACES.     
           05  WS-DEP-DATE-TRAN.                                        
               10  WS-DEP-DATE-TRAN-CCYY   PIC X(04)  VALUE SPACES.     
               10  WS-FILLER1              PIC X(01)  VALUE '-'.        
               10  WS-DEP-DATE-TRAN-MM     PIC X(02)  VALUE SPACES.     
               10  WS-FILLER2              PIC X(01)  VALUE '-'.        
               10  WS-DEP-DATE-TRAN-DD     PIC X(02)  VALUE SPACES.     
           05  WS-DATE-CI-MONTHS-AGO       PIC X(10).                   
           05  WS-XX-MOS-CREDIT-HIST       PIC X(01)  VALUE 'Y'.        
           05  WS-DNP-IN-LAST-XX-MTHS      PIC X(01)  VALUE 'N'.        
               88  DNP-NOT-FOUND-IN-HIST-XX           VALUE 'N'.        
               88  DNP-FOUND-IN-HIST-XX               VALUE 'Y'.        
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-DATA             PIC X(01)  VALUE 'N'.        
               88  NO-MORE-DATA                       VALUE 'Y'.        
           05  WS-FDB07-STATUS             PIC X(02).                   
               88 FDB07-SUCCESSFUL                    VALUE '00'.       
           05  WS-END-OF-FILE              PIC X(01)  VALUE 'N'.        
               88 END-OF-FILE                         VALUE 'Y'.        
           05  WS-RECORD-FOUND             PIC X(01)  VALUE 'N'.        
               88 DATA-RECORD-FOUND                   VALUE 'Y'.        
               88 NO-DATA-RECORD-FOUND                VALUE 'N'.        
           05  WS-BEGIN-REC-SW             PIC X(01)  VALUE 'N'.        
               88 WS-BEGIN-RECS-PROCESSED             VALUE 'Y'.        
P00399     05  WS-REFUND-CHK               PIC X(01)  VALUE 'N'.        
P00399         88 WS-REFUND-REQ                       VALUE 'Y'.        
           05  WS-DATABASE                 PIC 9(01)  VALUE ZERO.       
               88  CSR-DATABASE                       VALUE 1.          
               88  SEB-DATABASE                       VALUE 2.          
           05  WS-REFUND-TYPE              PIC X(01).                   
               88  WS-DEPOSIT-PLUS-INTEREST           VALUE 'D'.        
               88  WS-INTEREST-ONLY                   VALUE 'I'.        
               88  WS-NO-REFUND                       VALUE SPACE.      
           05  WS-ELIG-FOR-REFUND-FLAG     PIC X(01).                   
               88  WS-ELIG-FOR-REFUND          VALUE '0' ' '.           
               88  WS-NOT-ELIG-FOR-REFUND      VALUE 'A'.               
           05  WS-DNP-IN-LAST-05-MTHS      PIC X(01)  VALUE 'N'.        
               88  DNP-NOT-FOUND-IN-HIST-6MO          VALUE 'N'.        
               88  DNP-FOUND-IN-HIST-6MO              VALUE 'Y'.        
           05  WS-DEP-REQ-IND              PIC X(01).                   
               88  WS-NO-DEP-REQ                      VALUE '0'.        
               88  WS-HAS-DEP-REQ                     VALUE '1'.        
           05  WS-LAST-DEPOSIT-VALID2      PIC X(01).                   
               88  WS-LAST-DEP-GT-6MO                 VALUE 'Y'.        
               88  WS-LAST-DEP-LT-6MO                 VALUE 'N'.        
           05  WS-NON-UTILITY-FLAG         PIC X(01)  VALUE 'N'.        
               88 NON-UTILITY-ACCT                    VALUE 'Y'.        
           05  WS-DEPOSIT-TYPE             PIC X(01).                   
               88 WS-COM-IND-DEPOSIT                  VALUE 'C'         
                                                            'I'.        
P00399     05  WS-FCA347-STATUS            PIC X(02).                   
P00399         88  FCA347-SUCCESSFUL                  VALUE '00'.       
P00399     05  WS-FCA347R-STATUS           PIC X(02).                   
P00399         88  FCA347R-SUCCESSFUL                 VALUE '00'.       
           05  WS-COMPANY-FLAG             PIC X(04)  VALUE SPACES.     
               88  SCEG                               VALUE 'SCEG'.     
               88  SEB                                VALUE 'SEB'.      
               88  PSNC                               VALUE 'PSNC'.     
      *                                                                         
      ******************************************************************        
      *  WORKING STORAGE FOR WQ MESSAGES PERTAINING TO SQL ERRORS AND  *        
      *  OTHER PROGRAM PROBLEMS.                                       *        
      ******************************************************************        
       01  WS-WQ-MESSAGE-DATA.                                          
           05  WS-MISCELLANEOUS-MESSAGE.                                
               10  WS-MISC-CATEGORY-ID     PIC S9(04) COMP.             
               10  FILLER                  PIC X(01)  VALUE 'N'.        
               10  FILLER                  PIC X(01)  VALUE '4'.        
               10  WS-MISC-MSG-LEN         PIC S9(04) COMP VALUE +60.   
               10  WS-MISC-MSG-TEXT        PIC X(60).                   
      *                                                                         
      ******************************************************************        
      * COMMON COPYBOOK FOR WS-VARIABLES                               *        
      ******************************************************************        
      *                                                                         
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      * WQ WORKING STORAGE VARIABLES                                   *        
      ******************************************************************        
      *                                                                         
       COPY CWS0070B.                                                           
      *                                                                         
      ******************************************************************        
      * ABEND SWITCH COPYBOOK                                          *        
      ******************************************************************        
      *                                                                         
       COPY CWS09900.                                                           
      *                                                                         
      ******************************************************************        
      * COMMON ERROR MESSAGES                                          *        
      ******************************************************************        
      *                                                                         
       COPY CWS00027.                                                           
      *                                                                         
      ******************************************************************        
      * WS ABEND WORK AREA                                             *        
      ******************************************************************        
      *                                                                         
       COPY CWS00010.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
       COPY CWS00056.                                                           
      *                                                                         
P00399******************************************************************        
P00399* WORKING STORAGE FOR CPD00334                                   *        
P00399******************************************************************        
P00399*                                                                         
P00399 COPY CWS00334.                                                           
P00399*                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR PAYMENT JOURNAL                            *        
      ******************************************************************        
      *                                                                         
       COPY CJF00101.                                                           
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR JOURNAL                                    *        
      ******************************************************************        
      *                                                                         
       COPY CJF00102.                                                           
      *                                                                         
       COPY CJF00105.                                                           
      *                                                                         
      ******************************************************************07910200
      *   WORKING STORAGE AREA FOR RESTART-REQUEST PARM                *07910300
      ******************************************************************07910400
      *                                                                 07910500
       COPY CWS00038.                                                   07910600
      *                                                                 07910700
      ******************************************************************07870000
      *  WORKING STORAGE AREA FOR COMMON DATES                         *07880000
      ******************************************************************07890000
      *                                                                 07900000
       COPY CWS00039.                                                   07910000
      *                                                                 07910100
      ******************************************************************07870000
      * FIOJC01 WORKING STORAGE                                        *07880000
      ******************************************************************07890000
      *                                                                 07900000
       COPY FIOJC01.                                                    07910000
      *                                                                 07910100
      ******************************************************************06330000
      * FCA00-KEY                                                      *06340000
      ******************************************************************06350000
      *                                                                 06360000
       COPY FIOCA00.                                                    06370000
      *                                                                 06391000
      ******************************************************************06330000
      *    SQL COMMUNICATIONS AREA                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ACCOUNT - AT                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_AR_CNTL - AC                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_AR_PMT_PRTY - C9                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARPMT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_AR_TRANS_HIST - AR                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_AR_TRN_HST_DET - AU                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBARHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_BATCH_JRNL - BJ                                         *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBTJRNL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_BUDGET_HIST - BH                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBGTHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_BCH_JRNL_CNTL - BC                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBJCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_BUDGET_PLAN - BU                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBGTPLN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_CREDIT_PROFILE - CZ                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_CUSTOMER - CU                                           *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCUST                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_CONTRACT - CT                                           *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_CONNECT_CHRG - CC                                       *06340000
      ******************************************************************06350000
      *                                                                 06360000
           EXEC SQL                                                     06370000
               INCLUDE TBCCCHRG                                         06380000
           END-EXEC.                                                    06390000
      *                                                                 06391000
      ******************************************************************06330000
      *    CSS_DFA_ACCT - DA                                           *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_DEP_ON_HAND - DO                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_DEP_PAY_HST - DP                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_DFA_RECVBL - DV                                         *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDFARCV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_DEP_INT_RATE - P6                                       *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDEPINT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_DELINQUENCY - C8                                        *06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                     06370000
               INCLUDE TBDELQ                                           06380000
           END-EXEC.                                                    06390000
      *                                                                 06391000
      ******************************************************************06330000
      *    CSS_GL_ACCT_NO  - GO                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBGLATNO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_HOLIDAY - J8                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_INTEREST_HIST - IH                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBINTHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_JOB_PARM - G6                                           *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_LIEAP - LI                                              *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLIEAP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_LOCAL_OFFICE - B1                                       *06340000
      ******************************************************************06350000
      *                                                                 06360000
           EXEC SQL                                                     06370000
               INCLUDE TBLOCOFC                                         06380000
           END-EXEC.                                                    06390000
      *                                                                         
      ******************************************************************06330000
      *    CSS_MNT_TRANS_HIS - MH                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_MT_TRN_HST_DET - MI                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_MISC_JRNL - MJ                                          *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMSJRNL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_PREMISE - PR                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_PROJ_SHARE - PJ                                         *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPRJSHR                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_RESTART - RF                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_RECONNECT - DL                                          *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRECNCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_USER_PROFILE - PF                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUSRPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_REFUND - RN                                             *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBREFUND                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_RECONNECT_CHRG - U7                                     *06340000
      ******************************************************************06350000
      *                                                                 06360000
           EXEC SQL                                                     06370000
               INCLUDE TBRCNCHR                                         06380000
           END-EXEC.                                                    06390000
      *                                                                 06391000
ACT053******************************************************************06330000
ACT053* FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077          *06340000
ACT053******************************************************************06350000
ACT053*                                                                         
ACT053     EXEC SQL                                                             
ACT053         INCLUDE CWS00077                                                 
ACT053     END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * WORKING STORAGE REQUIRED FOR COMMON JOURNAL AREA.              *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00013                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * WORKING STORAGE VARIABLES FOR GENERAL LEDGER                   *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00061                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *  WORKING STORAGE REQUIRED FOR CPD00312.                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS10016                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *  WORKING STORAGE REQUIRED FOR CPD0010S.                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00017                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * THIS COPY STATEMENT CONTAINS THE FIELDS REQUIRED TO            *06340000
      * CHANGE DATES ON THE DATABASE (FORM PICTURE S9(9) COMP)         *06340000
      * FOR DISPLAY ON A SCREEN (MM/DD/YY OR MM/YY).                   *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00004                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * WORKING STORAGE REQUIRED TO COMPUTE THE AMOUNT TO BE           *06340000
      * REBATED WHEN PAYING OFF AN ADD ON INTEREST RECEIVABLE.         *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00008                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * WORKING-STORAGE AREA TO COMPUTE THE 00, 30, 60 AND 90 DAY      *06340000
      * INTERVALS FROM THE CURRENT DATE.                               *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00007                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      * WORKING STORAGE REQUIRED FOR DEPOSIT INTEREST CALCULATION      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS0223B                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  CURSOR DECLARATIONS                                          *        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE DEP_ON_HAND CURSOR FOR                          
                SELECT                                                  
                  DO.ACCOUNT_NO                                         
                 ,DO.DEPOSIT_CERT_NO                                    
                 ,DO.AMT_DEPOSIT                                        
                 ,DO.DATE_CERT_ISSUE                                    
                 ,DO.DATE_INTST_CALC_TO                                 
                 ,DO.INTRST_YTD                                         
                 ,DO.TOTAL_INTRST                                       
                 ,DO.CODE_REFUND_ELIG                                   
                 ,DO.CODE_REFUND_STATUS                                 
                 ,DO.EMPL_HOLD_INIT                                     
                 ,DO.DATE_TRAN                                          
                 ,DO.CODE_DEP_TYPE                                      
                 ,DO.SERVICE_TYPE_CD                                    
                 ,DO.PROJECTED_CR_DT                                    
                 ,DO.TRANSFERRED_FROM                                   
                 ,DO.TRANSFERRED_TO                                     
                 ,DO.TRANSFER_AMT                                       
                 ,DO.DEPOSIT_STATUS_CD                                  
                 ,DO.USER_ID_UPDT_BY                                    
                 ,DO.DATE_REFUNDED                                      
                 ,DO.CODE_REFUND_TYPE                                   
                 ,DO.CODE_REFUND_REASON                                 
                 ,DO.CODE_REFUND_FROM                                   
                 ,DO.DEP_ACTION_CODE                                    
                 ,DO.DEP_CERT_NO_TO                                     
                 ,DO.DEP_CERT_NO_FROM                                   
                 ,DO.DATE_PYMT_START                                    
                 ,DO.AMT_REFUNDED                                       
                 ,DO.COMMENTS                                           
                 ,COALESCE(AC.PYMT_PRIORITY_LVL,0)                      
                 ,COALESCE(AC.ITEM_ID,0)                                
                 ,COALESCE(AC.AMT_TRAN_BALANCE,0.00)                    
                FROM CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                   
                   LEFT OUTER JOIN  CSS_AR_CNTL AC WITH(READUNCOMMITTED)        
                       ON  DO.ACCOUNT_NO        = AC.ACCOUNT_NO         
                      AND  DO.DEPOSIT_CERT_NO   = AC.ITEM_ID            
                      AND  AC.PYMT_PRIORITY_LVL = 80                    
                WHERE DO.ACCOUNT_NO = :DO-ACCOUNT-NO                    
                  AND DO.DEPOSIT_STATUS_CD IN ('A','P')                 
P00399          ORDER BY DO.DEPOSIT_CERT_NO ASC                         
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DEP_ON_HAND CURSOR FOR                                  
MFA-TR*         SELECT                                                          
MFA-TR*           DO.ACCOUNT_NO                                                 
MFA-TR*          ,DO.DEPOSIT_CERT_NO                                            
MFA-TR*          ,DO.AMT_DEPOSIT                                                
MFA-TR*          ,DO.DATE_CERT_ISSUE                                            
MFA-TR*          ,DO.DATE_INTST_CALC_TO                                         
MFA-TR*          ,DO.INTRST_YTD                                                 
MFA-TR*          ,DO.TOTAL_INTRST                                               
MFA-TR*          ,DO.CODE_REFUND_ELIG                                           
MFA-TR*          ,DO.CODE_REFUND_STATUS                                         
MFA-TR*          ,DO.EMPL_HOLD_INIT                                             
MFA-TR*          ,DO.DATE_TRAN                                                  
MFA-TR*          ,DO.CODE_DEP_TYPE                                              
MFA-TR*          ,DO.SERVICE_TYPE_CD                                            
MFA-TR*          ,DO.PROJECTED_CR_DT                                            
MFA-TR*          ,DO.TRANSFERRED_FROM                                           
MFA-TR*          ,DO.TRANSFERRED_TO                                             
MFA-TR*          ,DO.TRANSFER_AMT                                               
MFA-TR*          ,DO.DEPOSIT_STATUS_CD                                          
MFA-TR*          ,DO.USER_ID_UPDT_BY                                            
MFA-TR*          ,DO.DATE_REFUNDED                                              
MFA-TR*          ,DO.CODE_REFUND_TYPE                                           
MFA-TR*          ,DO.CODE_REFUND_REASON                                         
MFA-TR*          ,DO.CODE_REFUND_FROM                                           
MFA-TR*          ,DO.DEP_ACTION_CODE                                            
MFA-TR*          ,DO.DEP_CERT_NO_TO                                             
MFA-TR*          ,DO.DEP_CERT_NO_FROM                                           
MFA-TR*          ,DO.DATE_PYMT_START                                            
MFA-TR*          ,DO.AMT_REFUNDED                                               
MFA-TR*          ,DO.COMMENTS                                                   
MFA-TR*          ,COALESCE(AC.PYMT_PRIORITY_LVL,0)                              
MFA-TR*          ,COALESCE(AC.ITEM_ID,0)                                        
MFA-TR*          ,COALESCE(AC.AMT_TRAN_BALANCE,0.00)                            
MFA-TR*         FROM CSS_DEP_ON_HAND DO                                         
MFA-TR*            LEFT OUTER JOIN  CSS_AR_CNTL AC                              
MFA-TR*                ON  DO.ACCOUNT_NO        = AC.ACCOUNT_NO                 
MFA-TR*               AND  DO.DEPOSIT_CERT_NO   = AC.ITEM_ID                    
MFA-TR*               AND  AC.PYMT_PRIORITY_LVL = 80                            
MFA-TR*         WHERE DO.ACCOUNT_NO = :DO-ACCOUNT-NO                            
MFA-TR*           AND DO.DEPOSIT_STATUS_CD IN ('A','P')                         
MFA-TR*         ORDER BY DO.DEPOSIT_CERT_NO ASC                                 
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7301                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       01  WS-END                           PIC X(40) VALUE             
           'WORKING STORAGE FOR PCSCA097 ENDS HERE  '.                  
      *                                                                         
       PROCEDURE DIVISION .                                             
      *                                                                         
      ******************************************************************        
      *  0000-MAINLINE                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
      *                                                                         
           PERFORM 1000-MAIN-PROCESS        THRU 1000-EXIT              
                                            UNTIL END-OF-FILE.          
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                     TO WS-RESTART-JOB-STATUS    
              DISPLAY 'PCSCA097 RERUN COMPLETED'                        
           ELSE                                                         
              MOVE WS-A                     TO WS-RESTART-JOB-STATUS    
                                                                        
              DISPLAY 'PCSCA097 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8850-DEL-RESTART-REC     THRU 8850-EXIT.             
           PERFORM 8889-COMMIT              THRU 8889-EXIT.             
           PERFORM 9000-TERMINATE           THRU 9000-EXIT.             
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06150000
      *  0100-INITIALIZE                                               *06160000
      ******************************************************************06230000
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                 06250000
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
DEFT83     SET WS-GL-SUB                    TO 1.                       
      *                                                                 06250000
           INITIALIZE WS-SYSIPT                                         
           PERFORM 6253-GET-FJC01-CHKP-LIMIT THRU 6253-EXIT.            
           PERFORM 6251-GET-FJC01-DATE       THRU 6251-EXIT.            
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE            
           END-IF.                                                      
           MOVE WS-INPUT-DATE               TO WS-COMMON-DATE.          
           MOVE WS-COMMON-DATE              TO LS-INPUT-DATE.           
      *                                                                 04680000
           OPEN INPUT FCSDB07-FILE.                                     
           IF FDB07-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************'               
              DISPLAY '** 0100-INITIALIZE               '               
              DISPLAY '** ERROR ON OPENING FCSDB07 FILE.'               
              DISPLAY '** STATUS IS ' WS-FDB07-STATUS                   
              DISPLAY '*********************************'               
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                 04680000
           OPEN OUTPUT FCSCA347-FILE.                                   
      *                                                                         
           IF FCA347-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '*********************************'               
              DISPLAY '** 0100-INITIALIZE               '               
              DISPLAY '** ERROR ON OPENING FCA347 FILE. '               
              DISPLAY '** STATUS IS ' WS-FCA347-STATUS                  
              DISPLAY '*********************************'               
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF                                                       
      *                                                                 04680000
           PERFORM 0200-CHECK-RESTART       THRU 0200-EXIT.             
           PERFORM 0300-PREPARE-RESTART     THRU 0300-EXIT.             
P00399     IF WS-THIS-IS-NOT-A-RESTART                                  
             PERFORM 0500-PROCESS-BEGIN-REC THRU 0500-EXIT              
                 UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES            
           END-IF.                                                      
      *                                                                 04680000
           MOVE 'DATABASE'                  TO C8-DELINQ-CD.            
           MOVE '01'                        TO C8-COMPANY-NO.           
           PERFORM 7200-GET-DLINQ-VAL       THRU 7200-EXIT.             
           MOVE C8-DELINQ-VALUE             TO WS-DATABASE.             
      *                                                                 04680000
           PERFORM 5250-LOAD-GL-NUMBERS     THRU 5250-EXIT.             
      *                                                                         
P00399     IF CSR-DATABASE AND WS-THIS-IS-NOT-A-RESTART                 
P00399        INITIALIZE FIOCA347                                       
P00399        PERFORM 5710-WRITE-BEGIN-CONTROLS                         
P00399                                      THRU 5710-EXIT              
P00399     END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-CHECK-RESTART.                                            *        
      ******************************************************************        
      *                                                                         
       0200-CHECK-RESTART.                                              
      *                                                                         
            MOVE WS-PGRMNAME                TO RF-NAME-PROGRAM.         
            MOVE 1                          TO RF-PARTITION-NO.         
            MOVE 1                          TO RF-DUP-CNTRL-NO.         
      *                                                                         
            PERFORM 7120-SELECT-RESTART     THRU 7120-EXIT.             
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE RF-RESTART-DATA-TEXT    TO WS-RESTART-DATA          
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                 TO WS-IS-THIS-A-RESTART     
               END-IF                                                   
            ELSE                                                        
               GO TO 0200-EXIT                                          
            END-IF.                                                     
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  0300-PREPARE-RESTART                                          *        
      ******************************************************************        
      *                                                                         
       0300-PREPARE-RESTART.                                            
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '*******************************************'     
              DISPLAY '**   THIS IS A RESTART OF PCSCA097       **'     
              DISPLAY '*LAST PROCESSED ACCOUNT # 'WS-RESTART-ACCOUNT-NO 
              DISPLAY '*CONTINUING FROM COMMIT # 'WS-RESTART-CHKP-SEQ-NO
              DISPLAY '*******************************************'     
              MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO           
      *                                                                         
              PERFORM 7001-READ-FCSDB07     THRU 7001-EXIT              
P00399           UNTIL WS-FCSDB07-REC-CNTR = WS-RESTART-FCSDB07-REC-CNTR
P00399*                                                                         
P00399        OPEN INPUT FCA347R-FILE                                   
P00399*                                                                         
P00399        IF FCA347R-SUCCESSFUL                                     
P00399            CONTINUE                                              
P00399        ELSE                                                      
P00399            DISPLAY '*********************************'           
P00399            DISPLAY '** 0300-PREPARE-RESTART          '           
P00399            DISPLAY '** ERROR ON OPENING FCA347R FILE.'           
P00399            DISPLAY '** STATUS IS ' WS-FCA347R-STATUS             
P00399            DISPLAY '*********************************'           
P00399            PERFORM 9900-ABEND           THRU 9900-EXIT           
P00399        END-IF                                                    
P00399*                                                                         
P00399        PERFORM WS-RESTART-FCA347-REC-CNTR TIMES                  
P00399            INITIALIZE WS-FCA347R                                 
P00399            PERFORM 7002-READ-FCA347  THRU 7002-EXIT              
P00399            MOVE WS-FCA347R           TO E-FCA347-DATA            
P00399            PERFORM 8900-WRITE-FCA347 THRU 8900-EXIT              
P00399        END-PERFORM                                               
P00399        COMPUTE WS-FCA347-REC-COUNT = WS-FCA347-REC-COUNT - 1     
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      *   THIS PARAGRAPH DOES AN INITIAL READ TO THE DB07 FILE AND     *        
      *   CHECKS FOR A BEGINNING RECORD. WHEN FOUND THE DATE ON        *        
      *   THE BEGIN RECORD IS COMPARED TO THE RUN DATE OBTAINED        *        
      *   FROM THE JOBS TABLE TO ENSURE WE ARE PROCESSING WITH         *        
      *   THE CORRECT FILE.                                            *        
      ******************************************************************        
      *                                                                         
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7001-READ-FCSDB07        THRU 7001-EXIT.             
      *                                                                         
           EVALUATE TRUE                                                
               WHEN END-OF-FILE                                         
                    DISPLAY '********************************'          
                    DISPLAY '**    PCSCA097 PROCESSING ERROR '          
                    DISPLAY '**      FCSDB07 FILE IS EMPTY   '          
                    DISPLAY '**      PROCESSING TERMINATED   '          
                    DISPLAY '********************************'          
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
               WHEN E-FDB07-KEY-BREC = LOW-VALUES                       
                    IF E-FDB07-CREATE-DATE-BREC NOT = WS-COMMON-DATE    
                       DISPLAY '**********************************'     
                       DISPLAY '**     PCSCA097 PROCESSING ERROR  '     
                       DISPLAY '** FCSDB07 CREATE DATE NOT = RUN DATE ' 
                       DISPLAY '**       PROCESSING TERMINATED    '     
                       DISPLAY '**********************************'     
                       PERFORM 9900-ABEND   THRU 9900-EXIT              
                    END-IF                                              
                    SET WS-BEGIN-RECS-PROCESSED TO TRUE                 
               WHEN WS-BEGIN-RECS-PROCESSED                             
                    IF E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES     
                       IF E-FDB07-KEY-BREC = HIGH-VALUES AND            
                          NO-DATA-RECORD-FOUND AND                      
                          E-FDB07-RECORD-COUNT-EREC EQUAL ZERO          
                          DISPLAY '********************************'    
                          DISPLAY '**    PCSCA097 PROCESSING ERROR '    
                          DISPLAY '**      FCSDB07 FILE IS EMPTY   '    
                          DISPLAY '**      PROCESSING TERMINATED   '    
                          DISPLAY '********************************'    
                          PERFORM 9900-ABEND THRU 9900-EXIT             
                       ELSE                                             
                          CONTINUE                                      
                       END-IF                                           
                    ELSE                                                
                       SET DATA-RECORD-FOUND TO TRUE                    
                    END-IF                                              
               WHEN OTHER                                               
                    DISPLAY '**********************************'        
                    DISPLAY '**    PCSCA097 PROCESSING ERROR   '        
                    DISPLAY '** FIRST RECORD IS NOT A CNTL REC '        
                    DISPLAY '**      PROCESSING TERMINATED     '        
                    DISPLAY '**********************************'        
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-MAIN-PROCESS.                                             *        
      ******************************************************************        
      *                                                                         
       1000-MAIN-PROCESS.                                               
      *                                                                         
           IF (E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES) OR         
              E-FDB07-OFF-CYCLE-BILL-CODE > SPACES                      
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2000-OUTPUT-PROCESS   THRU 2000-EXIT              
           END-IF.                                                      
      *                                                                         
P00399     MOVE 'N'                         TO WS-REFUND-CHK            
           PERFORM 7001-READ-FCSDB07        THRU 7001-EXIT              
      *                                                                         
           IF WS-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR                  
              WS-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT                     
              PERFORM 8888-COMMIT           THRU 8888-EXIT              
              MOVE ZEROES                   TO WS-COMMIT-COUNTER        
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-OUTPUT-PROCESS.                                           *        
      ******************************************************************        
      *                                                                         
       2000-OUTPUT-PROCESS.                                             
      *                                                                         
           INITIALIZE WS-COUNTERS                                       
                      WS-CALCULATIONS                                   
                      WS-TEMP-VARIABLES                                 
                      WS-AMT-DEPOSIT.                                   
      *                                                                         
           MOVE WS-YES                      TO WS-XX-MOS-CREDIT-HIST.   
           MOVE WS-NO                       TO WS-NON-UTILITY-FLAG.     
           MOVE +365                        TO WS-ONE-YEAR.             
           MOVE ZERO                        TO RN-REFUND-ITEM-ID        
                                               RETURN-CODE              
                                               WS-HOLD-00-ARREARS-AMT   
                                               WS-HOLD-30-60-90-ARRS-AMT
      *                                                                         
           MOVE E-FDB07-ACCT-NO             TO AT-ACCOUNT-NO            
                                               CZ-ACCOUNT-NO            
                                               AC-ACCOUNT-NO            
                                               RN-ACCOUNT-NO            
                                               AR-ACCOUNT-NO            
                                               AU-ACCOUNT-NO            
                                               DO-ACCOUNT-NO.           
      *                                                                         
           MOVE ZEROES                      TO WS-LAST-REFUND-ITEM-ID.  
           PERFORM 7000-GET-ACCT-DTLS       THRU 7000-EXIT.             
                                                                        
ACT121     IF AT-CODE-ACCT-BILLED = 'X'                                 
ACT121        DISPLAY 'ACCOUNT EXCLUDED FROM PROCESSING : '             
ACT121                    AT-ACCOUNT-NO                                 
ACT121        GO TO 2000-EXIT                                           
ACT121     END-IF.                                                      
                                                                        
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT-AT 
                                               WS-CODES-DATA-PRESENT.   
P00399     MOVE AT-COMPANY-NO               TO WS-COMPANY-NO-AT.        
      *                                                                         
           IF WS-CODE-DEP-ON-HAND ='A'                                  
              MOVE AT-ACCOUNT-TYPE-CODE     TO WS-ACCOUNT-TYPE-CODE-AT  
              MOVE AT-PREMISE-NO            TO WS-PREMISE-NO-AT         
              MOVE AT-CUSTOMER-NO           TO WS-CUSTOMER-NO-AT        
              MOVE AT-LOCAL-OFFICE          TO WS-LOCAL-OFFICE-AT       
              MOVE AT-CREDIT-GROUP          TO WS-CREDIT-GROUP-AT       
              MOVE AT-CODE-ACCT-STAT        TO WS-CODE-ACCT-STAT-AT     
              MOVE AT-TOTAL-AR-BALANCE      TO WS-TOTAL-AR-BALANCE-AT   
              MOVE AT-CODE-COMPANY-ACCT     TO WS-CODE-COMPANY-ACCT-AT  
              MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MTH-LST-NRML-AT   
              MOVE AT-ACCT-CREATE-DT        TO WS-ACCT-CREATE-DT-AT     
              MOVE AT-MST-SUB-ACCT-IND      TO WS-MST-SUB-ACCT-IND-AT   
              MOVE PR-REV-DISTRICT-CD       TO WS-REV-DISTRICT-CD-PR    
              MOVE PR-CODE-PREMISE-STAT     TO WS-CODE-PREMISE-STAT-PR  
              MOVE CU-CODE-EMPL-ACCT        TO WS-CODE-EMPL-ACCT-CU     
      *                                                                         
              PERFORM 7030-GET-CREDIT-DTLS  THRU 7030-EXIT              
              MOVE CZ-ARREARS-HIST          TO WS-ARREARS-HIST-CZ       
              MOVE CZ-DISCONNECT-HIST       TO WS-DISCONNECT-HIST-CZ    
              MOVE CZ-DISC-EXCEPTN-HIST     TO WS-DISC-EXCEPTN-HIST-CZ  
P00471        MOVE SPACES                   TO WS-ACCT-DISCONNECT-HST   
P00471                                         WS-ACCT-DISC-EXCEPTN-HST 
P00471        MOVE WS-DISCONNECT-HIST-CZ    TO WS-ACCT-DISCONNECT-HST   
P00471        MOVE WS-DISC-EXCEPTN-HIST-CZ  TO WS-ACCT-DISC-EXCEPTN-HST 
      *                                                                         
              PERFORM 7050-GET-AR-DTLS      THRU 7050-EXIT              
              MOVE AC-AMT-AR-DAY-30         TO WS-AMT-AR-DAY-30-AC      
              MOVE AC-AMT-AR-DAY-60         TO WS-AMT-AR-DAY-60-AC      
              MOVE AC-AMT-AR-DAY-90         TO WS-AMT-AR-DAY-90-AC      
              MOVE AC-AMT-AR-DAY-00         TO WS-AMT-AR-DAY-00-AC      
      *                                                                         
              PERFORM 7110-SEL-CURRENT-DT   THRU 7110-EXIT              
      *                                                                         
              IF SEB-DATABASE                                           
                 MOVE 'SEB'                 TO WS-COMPANY-FLAG          
              ELSE                                                      
                 IF WS-COMPANY-NO-AT = '01'                             
                    MOVE 'SCEG'             TO WS-COMPANY-FLAG          
                 ELSE                                                   
                    MOVE 'PSNC'             TO WS-COMPANY-FLAG          
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              IF WS-COMPANY-NO-AT NOT = WS-CURR-CO                      
                 MOVE WS-COMPANY-NO-AT      TO C8-COMPANY-NO            
                                               WS-CURR-CO               
                 MOVE 'RETAIN-RESIDENT-DEP' TO C8-DELINQ-CD             
                 PERFORM 7200-GET-DLINQ-VAL THRU 7200-EXIT              
                 MOVE C8-DELINQ-VALUE       TO WS-RETAIN-RES-DEP        
ACT121                                         WS-RETAIN-RES-DEP-DELQ   
                 MOVE 'RETAIN-COMMER-DEP'   TO C8-DELINQ-CD             
                 PERFORM 7200-GET-DLINQ-VAL THRU 7200-EXIT              
                 MOVE C8-DELINQ-VALUE       TO WS-RETAIN-COMMER-DEP     
                 MOVE 'RETAIN-INDUST-DEP'   TO C8-DELINQ-CD             
                 PERFORM 7200-GET-DLINQ-VAL THRU 7200-EXIT              
                 MOVE C8-DELINQ-VALUE       TO WS-RETAIN-INDUST-DEP     
A03175           MOVE 'AMT-ARREARS'         TO C8-DELINQ-CD             
A03175           PERFORM 7200-GET-DLINQ-VAL THRU 7200-EXIT              
A03175           MOVE C8-DELINQ-VALUE       TO WS-DELINQ-ARRS-LIMIT     
A04531           MOVE 'REFUND-INTEREST'     TO C8-DELINQ-CD             
A04531           PERFORM 7200-GET-DLINQ-VAL THRU 7200-EXIT              
A04531           MOVE C8-DELINQ-VALUE       TO WS-DELINQ-REFUND-INT     
A04531           PERFORM 7005-GET-DT-INT-MTHS-AGO THRU 7005-EXIT        
P00518           IF SCEG                                                
P00518              MOVE 'RES-SECUR-START-DATE' TO  C8-DELINQ-CD        
P00518              PERFORM 7200-GET-DLINQ-VAL THRU 7200-EXIT           
P00518              MOVE C8-DELINQ-VALUE   TO WS-DELINQ-VALUE9          
P00518              MOVE WS-DELINQ-VALUEX(1:4) TO WS-RES-DATE-CCYY      
P00518              MOVE WS-DELINQ-VALUEX(5:2) TO WS-RES-DATE-MM        
P00518              MOVE WS-DELINQ-VALUEX(7:2) TO WS-RES-DATE-DD        
P00518              MOVE '-'                   TO WS-FILLER1-RES        
P00518                                         WS-FILLER2-RES           
P00518              MOVE WS-RES-SECUR-DATE     TO WS-DO-DATE-TRANS      
P00518           END-IF                                                 
              END-IF                                                    
      *                                                                         
              MOVE WS-ACCOUNT-TYPE-CODE-AT  TO WS-DEPOSIT-TYPE          
              MOVE WS-CUSTOMER-NO-AT        TO AT-CUSTOMER-NO           
P00399* PROCESS SEB COMM AND IND DEPOSITS AS RESIDENTIAL DEPOSITS               
P00399        IF WS-COM-IND-DEPOSIT  AND CSR-DATABASE                   
                 PERFORM 7003-GET-DT-CI-MTHS-AGO  THRU 7003-EXIT        
                 IF WS-ACCOUNT-TYPE-CODE-AT = 'C'                       
                    MOVE WS-RETAIN-COMMER-DEP                           
                                            TO WS-MAX-MONTHXX           
                 ELSE                                                   
                    MOVE WS-RETAIN-INDUST-DEP                           
                                            TO WS-MAX-MONTHXX           
                 END-IF                                                 
                 PERFORM 2140-CHK-CI-ELIGIBILITY THRU 2140-EXIT         
              ELSE                                                      
                 IF SEB-DATABASE                                        
                    PERFORM 7008-GET-DT-SEB-MTHS-AGO THRU 7008-EXIT     
                    PERFORM 2120-CHK-SEB-ELIGIBILITY THRU 2120-EXIT     
                 ELSE                                                   
P00518              IF SCEG                                             
P00518                 PERFORM 2105-CHECK-DEPOSIT THRU 2105-EXIT        
P00518              END-IF                                              
A04531              PERFORM 7004-GET-DT-CSR-MTHS-AGO THRU 7004-EXIT     
                    PERFORM 2100-CHK-CSR-ELIGIBILITY THRU 2100-EXIT     
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
              MOVE WS-REFUND-TYPE           TO WS-ORIG-REFUND-TYPE      
              MOVE WS-REV-MTH-LST-NRML-AT   TO WS-REV-DT                
      *                                                                         
              IF NON-UTILITY-ACCT                                       
                 IF WS-MST-SUB-ACCT-IND-AT = WS-M AND                   
                    WS-CODE-DEP-ON-HAND = WS-A                          
                    PERFORM 2203-PROCESS-INTEREST-ONLY  THRU 2203-EXIT  
                 END-IF                                                 
              ELSE                                                      
                 IF WS-DEPOSIT-PLUS-INTEREST                            
                    OR WS-INTEREST-ONLY                                 
                    IF WS-COM-IND-DEPOSIT AND CSR-DATABASE              
                       PERFORM 2202-PROCESS-CI-DEP      THRU 2202-EXIT  
                    ELSE                                                
                       IF SEB-DATABASE                                  
                          PERFORM 2201-PROCESS-SEB-DEP  THRU 2201-EXIT  
                       ELSE                                             
                          PERFORM 2200-PROCESS-CSR-DEP  THRU 2200-EXIT  
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2100-CHK-CSR-ELIGIBILITY - PSNC AND SCEG.                     *        
      *    THIS MODULE DETERMINES IF A CUSTOMER HAS GOOD OR BAD        *        
      *    CREDIT.                                                     *        
      *    (1) CUSTOMER MUST HAVE 12 MONTHS OF CREDIT HISTORY;         *        
P00399*    (2) FOR SCEG, NO MORE THAN 2 NON-CONSECUTIVE ARREARS IN THE *        
P00399*        LAST RETAIN MONTHS.                                     *        
      *    (3) FOR SCEG, NO CONSECUTIVE ARREARS IN THE LAST RETAIN     *        
      *        MONTHS.                                                 *        
      *    IF ALL CRITERIA IS MET,    THE CUSTOMER HAS GOOD CREDIT     *        
      *    AND WILL BE REFUNDED DEPOSIT PLUS INTEREST; OTHERWISE       *        
      *    CUSTOMER HAS BAD CREDIT AND WILL BE REFUNDED INTEREST       *        
      *    ONLY.                                                       *        
P00399*    FOR PSNC, NO MORE THAN 2 ARREARS.                           *        
      ******************************************************************        
      *                                                                         
       2100-CHK-CSR-ELIGIBILITY.                                        
      *                                                                         
           IF WS-CREDIT-GROUP-AT = WS-A OR WS-B OR WS-C OR WS-N         
P00399        MOVE 0                        TO WS-ELIG-NO-MTHS          
P00399                                         WS-DELINQ-MTH            
P00399                                         WS-AR-CNTL-ARRS-AMT      
P00399        MOVE SPACES                   TO WS-ACCT-HST              
P00399        MOVE 'N'                      TO WS-NOT-USE-CR-HIST-FL    
P00399        MOVE 'N'                      TO WS-FORECAST-CRED-GR-FL   
P00399        MOVE WS-PGRMNAME              TO WS-PROGRAM-CPD334        
P00399        MOVE WS-ARREARS-HIST-CZ       TO WS-ACCT-HST              
P00399        MOVE WS-RETAIN-RES-DEP        TO WS-ELIG-NO-MTHS          
P00399        COMPUTE WS-DELINQ-MTH         = WS-RETAIN-RES-DEP - 1     
P00399        ADD WS-AMT-AR-DAY-30-AC                                   
P00399            WS-AMT-AR-DAY-60-AC                                   
P00399            WS-AMT-AR-DAY-90-AC                                   
P00399            WS-AMT-AR-DAY-00-AC       TO WS-AR-CNTL-ARRS-AMT      
P00399        MOVE WS-COMPANY-NO-AT         TO WS-COMPANY-CPD334        
P00399        PERFORM 6565-PROCESS-CREDIT-RULE THRU 6565-EXIT           
           ELSE                                                         
              SET NON-UTILITY-ACCT          TO TRUE                     
              GO TO 2100-EXIT                                           
           END-IF                                                       
      *                                                                         
P00399     IF SCEG                                                      
P00399        IF WS-ENOUGH-CREDIT-HIST = 'Y'                            
P00399           IF WS-CONSEC-CNT = 0 AND WS-NON-CONSEC-CNT <= 2        
P00399              SET WS-DEPOSIT-PLUS-INTEREST TO TRUE                
P00399           ELSE                                                   
P00399              SET WS-INTEREST-ONLY         TO  TRUE               
P00399           END-IF                                                 
P00399        ELSE                                                      
ACT233           SET WS-INTEREST-ONLY            TO  TRUE               
P00399        END-IF                                                    
P00399     ELSE                                                         
P00399        IF WS-ENOUGH-CREDIT-HIST = 'Y'                            
P00399           IF WS-ARRS-CNT  <= 2                                   
P00399              SET WS-DEPOSIT-PLUS-INTEREST TO TRUE                
P00399           ELSE                                                   
P00399              SET WS-INTEREST-ONLY         TO  TRUE               
P00399           END-IF                                                 
P00399        ELSE                                                      
P00399           SET WS-NO-REFUND                TO  TRUE               
P00399        END-IF                                                    
P00399     END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
P00518******************************************************************        
P00518* 2105-CHECK-DEPOSIT                                             *        
P00518*   CHECK TO SEE IF DEPOSIT WAS ESTABLISHED BEFORE               *        
P00518*   RES-SECUR-START-DATE.  IF SO YOU 12 MONTHS FOR DETERMINE     *        
P00518*   GOOD CREDIT VERSUS 24 MONTHS                                 *        
      ******************************************************************        
P00518 2105-CHECK-DEPOSIT.                                              
P00518     MOVE 'N' TO WS-GRAND-FATHER-DEPOSIT.                         
P00518     PERFORM 7511-CHECK-GF-DEPOSIT THRU 7511-EXIT.                
P00518     IF WS-GRAND-FATHER-DEPOSIT = 'Y'                             
P00518        MOVE 12 TO WS-RETAIN-RES-DEP                              
ACT121     ELSE                                                         
ACT121*    MOVE ORIGINAL DELIQUENCY VALUE IF THE ACCOUNT IS NOT ELGIBLE         
ACT121*    FOR GRAND FATHER DEPOSIT.BECAUSE IN THE PROGRAM THEY TOOK            
ACT121*    DELIQUENCY VALUE ONLY IF THE COMPANY_NO CHANGE FOR THE               
ACT121*    NEXT ACCOUNT.                                                        
ACT121        MOVE WS-RETAIN-RES-DEP-DELQ TO WS-RETAIN-RES-DEP          
P00518     END-IF.                                                      
P00518 2105-EXIT.                                                       
P00518     EXIT.                                                        
      ******************************************************************        
      * 2120-CHK-SEB-ELIGIBILITY                                       *        
      *   THIS MODULE DETERMINES IF A CUSTOMER HAS GOOD OR BAD         *        
      *   CREDIT.  IN ORDER TO INITIATE THE DEPOSIT REFUND PROCESS,    *        
      *   (1) THE CUSTOMER MUST HAVE A DEPOSIT THAT HAS NOT BEEN       *        
      *   REFUNDED YET; AND (2) THE FULL DEPOSIT MUST BE HELD FOR      *        
      *   AT LEAST 06 MONTHS.                                          *        
      *                                                                *        
      *   IF THOSE CRITERIA HAVE BEEN SATISFIED, THEN DETERMINE        *        
      *   IF THE CUSTOMER HAS ACHEIVED GOOD CREDIT: (1) CUSTOMER       *        
      *   MUST HAVE 06 MONTHS OF CREDIT HISTORY; AND (2) NO MORE       *        
      *   THAN 0 30-DAY ARREARS IN THE LAST 06 MONTHS AND (3) NORMAL   *        
      *   & EXCEPTIONAL CREDIT HISTORY CANNOT CONTAIN 3, 4, I OR R     *        
      *   IN THE LAST 11 MONTHS AND (4) NO                             *        
      *   60, 90 OR 120-DAY (LEGACY) ARREARS IN THE LAST 06 MTHS.      *        
      *   IF ALL CRITERIA IS MET,    THE CUSTOMER HAS GOOD CREDIT      *        
      *   AND WILL BE REFUNDED DEPOSIT PLUS INTEREST; OTHERWISE        *        
      *   CUSTOMER HAS BAD CREDIT AND WILL BE REFUNDED INTEREST        *        
      *   ONLY.                                                        *        
      ******************************************************************        
      *                                                                         
       2120-CHK-SEB-ELIGIBILITY.                                        
      *                                                                         
           MOVE +1                          TO WS-MONTH2.               
           MOVE ZERO                        TO WS-TOT-MOS-IN-ARREARS.   
           MOVE 'Y'                         TO WS-06-MOS-CREDIT-HIST.   
           MOVE 'N'                         TO WS-DNP-IN-LAST-05-MTHS.  
      *                                                                         
           IF WS-CREDIT-GROUP-AT = WS-A OR WS-B OR WS-C OR WS-N         
              PERFORM 2125-SEB-ARRS-AND-DNP THRU 2125-EXIT              
                  UNTIL (WS-MONTH2 > WS-MAX-MONTH2)                     
              IF WS-TOT-MOS-IN-ARREARS = 0 AND                          
                 DNP-NOT-FOUND-IN-HIST-6MO                              
                 PERFORM 2130-CHK-CUR-ARRS  THRU 2130-EXIT              
              END-IF                                                    
           ELSE                                                         
              SET NON-UTILITY-ACCT          TO TRUE                     
              GO TO 2120-EXIT                                           
           END-IF.                                                      
      *                                                                         
           PERFORM 7515-CHK-LAST-SEB-DEP    THRU 7515-EXIT              
           IF WS-RECENT-DEP-COUNT  = 0                                  
              MOVE 'Y'                      TO WS-LAST-DEPOSIT-VALID2   
           ELSE                                                         
              MOVE 'N'                      TO WS-LAST-DEPOSIT-VALID2   
           END-IF.                                                      
      *                                                                         
           SET WS-NO-REFUND                 TO TRUE                     
           IF WS-06-MOS-CREDIT-HIST = 'Y'                               
              IF (WS-TOT-MOS-IN-ARREARS = 0)                            
                     AND WS-LAST-DEP-GT-6MO                             
                     AND DNP-NOT-FOUND-IN-HIST-6MO                      
                  SET WS-DEPOSIT-PLUS-INTEREST TO TRUE                  
              ELSE                                                      
                  SET WS-INTEREST-ONLY      TO TRUE                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2125-SEB-ARRS-AND-DNP                                          *        
      ******************************************************************        
      *                                                                         
       2125-SEB-ARRS-AND-DNP.                                           
      *                                                                         
      *** CHECK IF 6 MONTHS OF CREDIT HISTORY EXISTS                            
      *                                                                         
           IF WS-ARREARS-HIST-CZ (WS-MONTH2:1) EQUAL SPACES OR          
              WS-ARREARS-HIST-CZ (WS-MONTH2:1) EQUAL LOW-VALUES         
              MOVE WS-NO                    TO WS-06-MOS-CREDIT-HIST    
              MOVE +7                       TO WS-MONTH2                
           ELSE                                                         
              IF WS-MONTH2 = +6                                         
                 NEXT SENTENCE                                          
              ELSE                                                      
                 EVALUATE TRUE                                          
                    WHEN (WS-ARREARS-HIST-CZ (WS-MONTH2:1)              
                        >= WS-OVER-60)                                  
                        ADD +3              TO WS-TOT-MOS-IN-ARREARS    
                    WHEN (WS-ARREARS-HIST-CZ (WS-MONTH2:1)              
                        = WS-OVER-30)                                   
                        ADD +1              TO WS-TOT-MOS-IN-ARREARS    
                 END-EVALUATE                                           
                 IF (WS-DISCONNECT-HIST-CZ (WS-MONTH2:1)                
                     = WS-3 OR WS-4 OR WS-I OR WS-R)                    
                    MOVE 'Y'                TO WS-DNP-IN-LAST-05-MTHS   
                    MOVE +7                 TO WS-MONTH2                
                 END-IF                                                 
                 IF (WS-DISC-EXCEPTN-HIST-CZ (WS-MONTH2:1)              
                     = WS-3 OR WS-4 OR WS-I OR WS-R)                    
                    MOVE 'Y'                TO WS-DNP-IN-LAST-05-MTHS   
                    MOVE +7                 TO WS-MONTH2                
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           ADD 1                            TO WS-MONTH2.               
      *                                                                         
       2125-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2130-CHECK-CURRENT-ARREARS                                    *        
      ******************************************************************        
      *                                                                         
       2130-CHK-CUR-ARRS.                                               
      *                                                                         
           ADD WS-AMT-AR-DAY-30-AC                                      
               WS-AMT-AR-DAY-60-AC                                      
               WS-AMT-AR-DAY-90-AC          TO WS-HOLD-30-60-90-ARRS-AMT
           ADD WS-AMT-AR-DAY-00-AC          TO WS-HOLD-00-ARREARS-AMT   
      *                                                                         
A03175     IF WS-HOLD-00-ARREARS-AMT    >   WS-DELINQ-ARRS-LIMIT        
              ADD +1                        TO WS-TOT-MOS-IN-ARREARS    
           END-IF.                                                      
A03175     IF WS-HOLD-30-60-90-ARRS-AMT >   WS-DELINQ-ARRS-LIMIT        
              ADD +3                        TO WS-TOT-MOS-IN-ARREARS    
           END-IF.                                                      
      *                                                                         
       2130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2140-CHK-CI-ELIGIBILITY - SCEG AND PSNC.                       *        
      *   THIS MODULE DETERMINES IF A CUSTOMER HAS GOOD OR BAD         *        
      *   CREDIT.  IN ORDER TO INITIATE THE DEPOSIT REFUND PROCESS,    *        
      *   (1) CUSTOMER MUST HAVE XX MONTHS OF CREDIT HISTORY.          *        
P00399*   (2) FOR SCEG, NO MORE THAN 2 NON-CONSECUTIVE 30-DAYS ARREARS *        
P00399*       IN THE LAST XX MONTHS.                                   *        
      *   (3) FOR SCEG, NO CONSECUTIVE ARREARS IN THE LAST XX MONTHS.  *        
      *   IF CRITERIA IS MET,    THE CUSTOMER HAS GOOD CREDIT          *        
      *   AND WILL BE REFUNDED DEPOSIT PLUS INTEREST; OTHERWISE        *        
      *   CUSTOMER HAS BAD CREDIT AND WILL BE REFUNDED INTEREST        *        
      *   ONLY.                                                        *        
P00399*   FOR PSNC, NO MORE THAN 2 ARREARS IN THE LAST XX MONTHS.      *        
      ******************************************************************        
      *                                                                         
       2140-CHK-CI-ELIGIBILITY.                                         
      *                                                                         
           IF WS-CREDIT-GROUP-AT = WS-A OR WS-B OR WS-C OR WS-N         
P00399        MOVE SPACES                   TO WS-ACCT-HST              
P00399        MOVE 0                        TO WS-AR-CNTL-ARRS-AMT      
P00399        MOVE 'N'                      TO WS-NOT-USE-CR-HIST-FL    
P00399        MOVE 'N'                      TO WS-FORECAST-CRED-GR-FL   
P00399        MOVE WS-PGRMNAME              TO WS-PROGRAM-CPD334        
P00399        MOVE WS-ARREARS-HIST-CZ       TO WS-ACCT-HST              
P00399        MOVE WS-MAX-MONTHXX           TO WS-ELIG-NO-MTHS          
P00399        COMPUTE WS-DELINQ-MTH    = WS-MAX-MONTHXX - 1             
P00399        ADD WS-AMT-AR-DAY-30-AC                                   
P00399            WS-AMT-AR-DAY-60-AC                                   
P00399            WS-AMT-AR-DAY-90-AC                                   
P00399            WS-AMT-AR-DAY-00-AC       TO WS-AR-CNTL-ARRS-AMT      
P00399        MOVE WS-COMPANY-NO-AT         TO WS-COMPANY-CPD334        
P00399        PERFORM 6565-PROCESS-CREDIT-RULE THRU 6565-EXIT           
           ELSE                                                         
              SET NON-UTILITY-ACCT          TO TRUE                     
              GO TO 2140-EXIT                                           
           END-IF.                                                      
P00399*                                                                         
P00399     IF SCEG                                                      
P00399        IF WS-ENOUGH-CREDIT-HIST = 'Y'                            
P00399           IF WS-CONSEC-CNT = 0 AND WS-NON-CONSEC-CNT <= 2        
P00399              SET WS-DEPOSIT-PLUS-INTEREST  TO TRUE               
P00399           ELSE                                                   
P00399              SET WS-INTEREST-ONLY          TO TRUE               
P00399           END-IF                                                 
P00399        ELSE                                                      
P00399           IF WS-ELIGIBILITY-HST-CNT >= 12                        
P00399              SET WS-INTEREST-ONLY          TO TRUE               
P00399           ELSE                                                   
P00399              SET WS-NO-REFUND              TO TRUE               
P00399           END-IF                                                 
P00399        END-IF                                                    
P00399     ELSE                                                         
P00399        IF WS-ENOUGH-CREDIT-HIST = 'Y'                            
P00399           IF WS-ARRS-CNT  <= 2                                   
P00399              SET WS-DEPOSIT-PLUS-INTEREST  TO TRUE               
P00399           ELSE                                                   
P00399              SET WS-INTEREST-ONLY          TO TRUE               
P00399           END-IF                                                 
P00399        ELSE                                                      
P00399           IF WS-ELIGIBILITY-HST-CNT >= 12                        
P00399              SET WS-INTEREST-ONLY          TO TRUE               
P00399           ELSE                                                   
P00399              SET WS-NO-REFUND              TO TRUE               
P00399           END-IF                                                 
P00399        END-IF                                                    
P00399     END-IF.                                                      
      *                                                                         
       2140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-CSR-DEP                                           *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-CSR-DEP.                                            
      *                                                                         
           PERFORM 7300-OPEN-DEP-ON-HAND    THRU 7300-EXIT.             
           PERFORM 7301-FETCH-DEP-ON-HAND   THRU 7301-EXIT.             
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             MOVE DO-CODE-REFUND-ELIG       TO WS-ELIG-FOR-REFUND-FLAG  
             IF DO-CODE-DEP-TYPE = 'A'                                  
                IF WS-NOT-ELIG-FOR-REFUND                               
                   SET WS-INTEREST-ONLY     TO TRUE                     
                END-IF                                                  
             ELSE                                                       
                IF WS-NOT-ELIG-FOR-REFUND AND SCEG                      
                   IF WS-DEPOSIT-PLUS-INTEREST                          
P00399               IF DO-DATE-PYMT-START > SPACES                     
                        AND DO-DATE-PYMT-START <= WS-DATE-CSR-MONTHS-AGO
                        MOVE '0'            TO DO-CODE-REFUND-ELIG      
                     END-IF                                             
                   END-IF                                               
                END-IF                                                  
                IF WS-NOT-ELIG-FOR-REFUND AND PSNC                      
                   IF WS-DEPOSIT-PLUS-INTEREST                          
P00399               IF DO-DATE-PYMT-START > SPACES                     
                        AND DO-DATE-PYMT-START <= WS-DATE-CSR-MONTHS-AGO
                        PERFORM 5610-SEND-MANUAL-REF-WQ THRU 5610-EXIT  
                     END-IF                                             
                   END-IF                                               
                END-IF                                                  
             END-IF                                                     
      * INTEREST SHOULD BE CALCULATED FROM DATE-PYMT-START AND                  
      * THAT SHOULD BE A SELECTION CRITERIA FOR CHOSING A DEPOSIT               
      * FOR REFUND. DATE-CERT-ISSUE IS THE DATE WHEN THE DEPOSIT WAS            
      * FULLY PAID. BUT A DEPOSIT CAN BE REFUNDED EVEN IF IT IS NOT             
      * FULLY PAID.                                                             
             MOVE DO-CODE-REFUND-ELIG       TO WS-ELIG-FOR-REFUND-FLAG  
             IF WS-ELIG-FOR-REFUND                                      
                OR (WS-NOT-ELIG-FOR-REFUND AND                          
                    WS-INTEREST-ONLY)                                   
                PERFORM 5000-CHK-DEP-REQ    THRU 5000-EXIT              
                IF WS-DEPOSIT-PLUS-INTEREST                             
P00399             IF (DO-DATE-PYMT-START > SPACES                      
P00399               AND DO-DATE-PYMT-START <= WS-DATE-CSR-MONTHS-AGO)  
P00399               OR WS-REFUND-REQ                                   
                     PERFORM 2210-PROCESS-DEPOSIT                       
                                         THRU 2210-EXIT                 
P00399               MOVE WS-YES         TO WS-REFUND-CHK               
                   END-IF                                               
                ELSE                                                    
P00399             IF WS-INTEREST-ONLY AND WS-NO-DEP-REQ                
                      IF (DO-DATE-INTST-CALC-TO <=                      
A04531                                      WS-DATE-INT-MNTHS-AGO       
                          OR DO-DATE-INTST-CALC-TO = LOW-VALUES)        
P00399                   AND (DO-DATE-PYMT-START > SPACES               
                              AND DO-DATE-PYMT-START <=                 
A04531                                 WS-DATE-INT-MNTHS-AGO)           
                         PERFORM 2210-PROCESS-DEPOSIT                   
                                         THRU 2210-EXIT                 
                      END-IF                                            
                   END-IF                                               
                END-IF                                                  
             END-IF                                                     
             PERFORM 7301-FETCH-DEP-ON-HAND THRU 7301-EXIT              
             MOVE WS-ORIG-REFUND-TYPE       TO WS-REFUND-TYPE           
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7302-CLOSE-DEP-ON-HAND   THRU 7302-EXIT.             
      *                                                                         
           PERFORM 2300-RESET-CDP           THRU 2300-EXIT.             
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  2201-PROCESS-SEB-DEP                                          *        
      ******************************************************************        
      *                                                                         
       2201-PROCESS-SEB-DEP.                                            
      *                                                                         
           PERFORM 7300-OPEN-DEP-ON-HAND    THRU 7300-EXIT.             
           PERFORM 7301-FETCH-DEP-ON-HAND   THRU 7301-EXIT.             
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             MOVE DO-CODE-REFUND-ELIG       TO WS-ELIG-FOR-REFUND-FLAG  
A02034       IF WS-NOT-ELIG-FOR-REFUND                                  
A02034          IF WS-COM-IND-DEPOSIT                                   
A02034             OR DO-CODE-DEP-TYPE = 'A'                            
A02034             SET WS-INTEREST-ONLY     TO TRUE                     
A02034          ELSE                                                    
A02034             MOVE '0'                 TO DO-CODE-REFUND-ELIG      
A02034          END-IF                                                  
A02034       END-IF                                                     
      * INTEREST SHOULD BE CALCULATED FROM DATE-PYMT-START AND                  
      * THAT SHOULD BE A SELECTION CRITERIA FOR CHOSING A DEPOSIT               
      * FOR REFUND. DATE-CERT-ISSUE IS THE DATE WHEN THE DEPOSIT WAS            
      * FULLY PAID. BUT A DEPOSIT CAN BE REFUNDED EVEN IF IT IS NOT             
      * FULLY PAID.                                                             
             MOVE DO-CODE-REFUND-ELIG       TO WS-ELIG-FOR-REFUND-FLAG  
             IF WS-ELIG-FOR-REFUND                                      
                OR (WS-NOT-ELIG-FOR-REFUND AND                          
                    WS-INTEREST-ONLY AND DO-CODE-DEP-TYPE = 'A')        
                PERFORM 5000-CHK-DEP-REQ    THRU 5000-EXIT              
               IF WS-NO-DEP-REQ                                         
                 IF WS-DEPOSIT-PLUS-INTEREST                            
P00399             IF DO-DATE-PYMT-START > SPACES                       
                      AND DO-DATE-PYMT-START <= WS-DATE-SEB-MONTHS-AGO  
                      PERFORM 2210-PROCESS-DEPOSIT                      
                                            THRU 2210-EXIT              
                   END-IF                                               
                 ELSE                                                   
                   IF WS-INTEREST-ONLY                                  
                     IF (DO-DATE-INTST-CALC-TO <=                       
A04531                                     WS-DATE-INT-MNTHS-AGO        
                         OR DO-DATE-INTST-CALC-TO = LOW-VALUES)         
P00399                 AND (DO-DATE-PYMT-START > SPACES                 
                       AND DO-DATE-PYMT-START <=                        
A04531                                     WS-DATE-INT-MNTHS-AGO)       
                       PERFORM 2210-PROCESS-DEPOSIT                     
                                            THRU 2210-EXIT              
                     END-IF                                             
                   END-IF                                               
                 END-IF                                                 
               END-IF                                                   
             END-IF                                                     
             PERFORM 7301-FETCH-DEP-ON-HAND THRU 7301-EXIT              
             MOVE WS-ORIG-REFUND-TYPE       TO WS-REFUND-TYPE           
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7302-CLOSE-DEP-ON-HAND   THRU 7302-EXIT.             
      *                                                                         
           PERFORM 2300-RESET-CDP           THRU 2300-EXIT.             
      *                                                                         
       2201-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2202-PROCESS-CI-DEP                                            *        
      ******************************************************************        
      *                                                                         
       2202-PROCESS-CI-DEP.                                             
      *                                                                         
           PERFORM 7300-OPEN-DEP-ON-HAND    THRU 7300-EXIT.             
           PERFORM 7301-FETCH-DEP-ON-HAND   THRU 7301-EXIT.             
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             MOVE DO-CODE-REFUND-ELIG       TO WS-ELIG-FOR-REFUND-FLAG  
A02034       IF WS-NOT-ELIG-FOR-REFUND                                  
A02034          SET WS-INTEREST-ONLY     TO TRUE                        
A02034       END-IF                                                     
      * INTEREST SHOULD BE CALCULATED FROM DATE-PYMT-START AND                  
      * THAT SHOULD BE A SELECTION CRITERIA FOR CHOSING A DEPOSIT               
      * FOR REFUND. DATE-CERT-ISSUE IS THE DATE WHEN THE DEPOSIT WAS            
      * FULLY PAID. BUT A DEPOSIT CAN BE REFUNDED EVEN IF IT IS NOT             
      * FULLY PAID.                                                             
             MOVE DO-CODE-REFUND-ELIG       TO WS-ELIG-FOR-REFUND-FLAG  
             IF WS-ELIG-FOR-REFUND                                      
                OR (WS-NOT-ELIG-FOR-REFUND AND                          
A02034              WS-INTEREST-ONLY )                                  
                PERFORM 5000-CHK-DEP-REQ    THRU 5000-EXIT              
                IF WS-DEPOSIT-PLUS-INTEREST                             
P00399             IF (DO-DATE-PYMT-START > SPACES                      
P00399                AND DO-DATE-PYMT-START <= WS-DATE-CI-MONTHS-AGO)  
P00399                OR WS-REFUND-REQ                                  
P00399                PERFORM 2210-PROCESS-DEPOSIT                      
P00399                                   THRU 2210-EXIT                 
P00399                MOVE WS-YES        TO WS-REFUND-CHK               
P00399             END-IF                                               
                ELSE                                                    
P00399             IF WS-INTEREST-ONLY AND WS-NO-DEP-REQ                
                      IF (DO-DATE-INTST-CALC-TO <=                      
A04531                                      WS-DATE-INT-MNTHS-AGO       
                          OR DO-DATE-INTST-CALC-TO = LOW-VALUES)        
P00399                   AND (DO-DATE-PYMT-START > SPACES               
                              AND DO-DATE-PYMT-START <=                 
A04531                                    WS-DATE-INT-MNTHS-AGO)        
                         PERFORM 2210-PROCESS-DEPOSIT THRU 2210-EXIT    
                      END-IF                                            
                   END-IF                                               
                END-IF                                                  
             END-IF                                                     
             PERFORM 7301-FETCH-DEP-ON-HAND THRU 7301-EXIT              
             MOVE WS-ORIG-REFUND-TYPE       TO WS-REFUND-TYPE           
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7302-CLOSE-DEP-ON-HAND   THRU 7302-EXIT.             
      *                                                                         
           PERFORM 2300-RESET-CDP           THRU 2300-EXIT.             
      *                                                                         
       2202-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2203-PROCESS-INTEREST-ONLY                                     *        
      ******************************************************************        
      *                                                                         
       2203-PROCESS-INTEREST-ONLY.                                      
      *                                                                         
           PERFORM 7300-OPEN-DEP-ON-HAND    THRU 7300-EXIT.             
           PERFORM 7301-FETCH-DEP-ON-HAND   THRU 7301-EXIT.             
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
             MOVE DO-CODE-REFUND-ELIG       TO WS-ELIG-FOR-REFUND-FLAG  
             SET WS-INTEREST-ONLY           TO TRUE                     
             IF SEB-DATABASE                                            
A04531          IF (DO-DATE-INTST-CALC-TO <= WS-DATE-INT-MNTHS-AGO      
                   OR DO-DATE-INTST-CALC-TO = LOW-VALUES)               
P00399             AND (DO-DATE-PYMT-START > SPACES                     
A04531             AND DO-DATE-PYMT-START <= WS-DATE-INT-MNTHS-AGO)     
                   PERFORM 2210-PROCESS-DEPOSIT                         
                                            THRU 2210-EXIT              
                END-IF                                                  
             ELSE                                                       
A04531          IF (DO-DATE-INTST-CALC-TO <= WS-DATE-INT-MNTHS-AGO      
                   OR DO-DATE-INTST-CALC-TO = LOW-VALUES)               
P00399             AND (DO-DATE-PYMT-START > SPACES                     
A04531             AND DO-DATE-PYMT-START <= WS-DATE-INT-MNTHS-AGO)     
                   PERFORM 2210-PROCESS-DEPOSIT                         
                                            THRU 2210-EXIT              
                END-IF                                                  
             END-IF                                                     
             PERFORM 7301-FETCH-DEP-ON-HAND THRU 7301-EXIT              
             MOVE WS-ORIG-REFUND-TYPE       TO WS-REFUND-TYPE           
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7302-CLOSE-DEP-ON-HAND   THRU 7302-EXIT.             
      *                                                                         
       2203-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2210-PROCESS-DEPOSIT                                           *        
      ******************************************************************        
      *                                                                         
       2210-PROCESS-DEPOSIT.                                            
      *                                                                         
           INITIALIZE CJF00101.                                         
           MOVE +0                          TO WS-PAR-TRAN-APPL-NO      
                                               WS-100-JRNL-TRAN-APPL-NO 
                                               AU-TRAN-APPL-NO          
ACT002                                         WS-PAR-TRAN-APPL-NO-WO1  
                                               WS-THIS-TRAN-APPL-NO.    
           MOVE WS-COMMON-DATE              TO WS-REFUND-DATE.          
           MOVE WS-LOCAL-OFFICE-AT          TO AT-LOCAL-OFFICE.         
           MOVE WS-REV-DISTRICT-CD-PR       TO PR-REV-DISTRICT-CD.      
      *                                                                         
P00399     IF CSR-DATABASE AND WS-HAS-DEP-REQ                           
P00399        MOVE ZERO                     TO WS-INTEREST-CALC         
P00399        MOVE DO-ACCOUNT-NO            TO WS-ACCOUNT-NO            
P00399        MOVE WS-ACCOUNT-NO            TO E-FCA347-ACCOUNT-NO      
P00399        MOVE DO-DEPOSIT-CERT-NO       TO E-FCA347-DEP-ITEM-ID     
P00399        MOVE DO-AMT-DEPOSIT           TO E-FCA347-AMT-DEP         
P00399        MOVE AC-AMT-TRAN-BALANCE      TO E-FCA347-AMT-DEP-BAL     
P00399        PERFORM  8900-WRITE-FCA347    THRU 8900-EXIT              
P00399* IF NO PAYMENTS RECEIVED TOWARDS DEPOSIT, NO NEED TO PROCEED             
P00399        IF DO-AMT-DEPOSIT = AC-AMT-TRAN-BALANCE                   
P00399           GO TO 2210-EXIT                                        
P00399        END-IF                                                    
P00399     ELSE                                                         
P00399        CONTINUE                                                  
P00399     END-IF.                                                      
P00399*                                                                         
           PERFORM 5995-DEPOSIT-INTEREST-CALC                           
                                            THRU 5995-EXIT.             
           PERFORM 5100-UPDT-DEP-AND-RFND   THRU 5100-EXIT.             
      *                                                                         
           PERFORM 5200-FMT-TR-HIST         THRU 5200-EXIT.             
      *                                                                         
           IF WS-DEPOSIT-PLUS-INTEREST                                  
P00399* IF BILLED DEPOSIT REFUND ONLY PAID PORTION OF THE DEPOSIT.REST          
P00399* WILL BE REVERSED IN PCSCA348                                            
P00399        IF CSR-DATABASE AND WS-HAS-DEP-REQ                        
P00399           COMPUTE WS-PAYMENT-AMOUNT-TOTAL =                      
P00399                   DO-AMT-DEPOSIT - AC-AMT-TRAN-BALANCE           
P00399        ELSE                                                      
P00399           MOVE DO-AMT-DEPOSIT        TO WS-PAYMENT-AMOUNT-TOTAL  
P00399           PERFORM 8800-DELETE-AR-CNTL                            
P00399                                      THRU 8800-EXIT              
P00399        END-IF                                                    
              PERFORM 5300-REFUND-DEPOSIT   THRU 5300-EXIT              
              MOVE WS-DEP-DEP-GL-NO (WS-GL-SUB)                         
                                            TO WS-PAR-GEN-LEDG-DB       
              MOVE DO-DEPOSIT-CERT-NO       TO WS-DEP-CERT-NO           
              MOVE WS-AR-DEP-COMMENT-TEXT   TO                          
                                            WS-PAR-AR-TRAN-COMMENT-TEXT 
P00399        MOVE +50                      TO                          
                                            WS-PAR-AR-TRAN-COMMENT-LEN  
              PERFORM 5500-APPLY-AS-PAYMENT THRU 5500-EXIT              
              IF AR-AMT-ORIG-ENTERED = RN-AMT-REFUNDED                  
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 8535-UPDT-TR-HIST  THRU 8535-EXIT              
              END-IF                                                    
              MOVE AU-TRAN-APPL-NO          TO WS-PAR-TRAN-APPL-NO      
                                               WS-THIS-TRAN-APPL-NO     
                                               WS-100-JRNL-TRAN-APPL-NO 
              MOVE AR-TRANS-HIST-SEQ-NO     TO AU-TRANS-HIST-SEQ-NO     
              MOVE 'N'                      TO WS-DEPOSIT-REFUND-SW     
              MOVE ZEROES                   TO WS-PAYMENT-AMOUNT        
                                               WS-PAYMENT-AMOUNT-TOTAL  
                                               WS-AMT-CASH              
           END-IF.                                                      
      *                                                                         
           IF WS-INTEREST-CALC > ZERO                                   
              MOVE WS-INTEREST-CALC         TO WS-PAYMENT-AMOUNT-TOTAL  
              MOVE WS-DEP-INT-GL-NO (WS-GL-SUB)                         
                                            TO WS-PAR-GEN-LEDG-DB       
              PERFORM 5400-REFUND-INTEREST  THRU 5400-EXIT              
              MOVE WS-AMOUNT-TEMP           TO AU-AMT-POSTED            
              MOVE DO-DEPOSIT-CERT-NO       TO WS-INT-DEP-CERT-NO       
              MOVE WS-AR-INT-COMMENT-TEXT   TO                          
                                            WS-PAR-AR-TRAN-COMMENT-TEXT 
P00399        MOVE +37                      TO                          
                                            WS-PAR-AR-TRAN-COMMENT-LEN  
              PERFORM 5500-APPLY-AS-PAYMENT THRU 5500-EXIT              
              MOVE 'N'                      TO WS-DEPOSIT-REFUND-SW     
           END-IF.                                                      
      *                                                                         
           IF AT-ACCOUNT-NO NOT EQUAL WS-PREV-ACCT-NO                   
              ADD  1                        TO WS-COMMIT-COUNTER        
              DISPLAY 'DEPOSIT REFUND PROCESS FOR ACCT #' AT-ACCOUNT-NO 
           END-IF.                                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO               TO WS-PREV-ACCT-NO.         
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-RESET-CDP.                                                *        
      ******************************************************************        
      *                                                                         
       2300-RESET-CDP.                                                  
      *                                                                         
           MOVE SPACES                      TO WS-DEP-EXISTS.           
           PERFORM 7510-CHK-ACTIVE-DEP      THRU 7510-EXIT.             
           IF WS-DEP-EXISTS = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE AT-CODES-DATA-PRESENT    TO WS-CODES-DATA-PRESENT    
              MOVE SPACE                    TO WS-CODE-DEP-ON-HAND      
              MOVE WS-CODES-DATA-PRESENT    TO AT-CODES-DATA-PRESENT    
              PERFORM 8200-UPDATE-ACCOUNT   THRU 8200-EXIT              
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2800-PRE-COMMIT.                                               *        
      ******************************************************************        
      *                                                                         
       2800-PRE-COMMIT.                                                 
      *                                                                         
           MOVE 1                           TO WS-RESTART-PROCESS-TYPE. 
           MOVE WS-C                        TO WS-RESTART-JOB-STATUS.   
           MOVE WS-COMMON-DATE              TO WS-RESTART-COMMON-DATE.  
           ADD  1                           TO WS-CHKP-SEQ-NO.          
           MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO.  
           MOVE AT-ACCOUNT-NO               TO WS-RESTART-ACCOUNT-NO.   
           MOVE WS-FCSDB07-REC-CNTR         TO                          
                                          WS-RESTART-FCSDB07-REC-CNTR.  
           COMPUTE WS-RESTART-FCA347-REC-CNTR = WS-FCA347-REC-COUNT + 1.
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************  11183800
      * 3500-CREATE-WORK-QUEUE                                       *  11184000
      ****************************************************************  11184200
      *                                                                         
       3500-CREATE-WORK-QUEUE.                                          
      *                                                                 11184500
ACT053     INITIALIZE CWS00077-FIELDS.                                  
      *                                                                 11184900
ACT053     MOVE AT-ACCOUNT-NO               TO WS-77-ACCOUNT-NO.        
ACT053     MOVE AT-CUSTOMER-NO              TO WS-77-CUSTOMER-NO.       
ACT053     MOVE AT-PREMISE-NO               TO WS-77-PREMISE-NO.        
ACT053     MOVE AT-LOCAL-OFFICE             TO WS-77-LOCAL-OFFICE.      
ACT053     MOVE WS-MISC-CATEGORY-ID         TO WS-77-CATEGORY-ID.       
ACT053     MOVE WS-MISC-MSG-TEXT            TO WS-77-COMMENTS-TEXT.     
ACT053     MOVE WS-MISC-MSG-LEN             TO WS-77-COMMENTS-LEN.      
ACT053     MOVE 4                           TO WS-77-ROUTE-CATEGORY.    
ACT053     MOVE 'N'                         TO WS-77-PRIORITY           
ACT053     MOVE WS-COMMON-DATE              TO WS-77-DATE-REQUIRED.     
ACT053                                                                  
ACT053     MOVE WS-PGRMNAME                 TO WS-77-CREATED-BY.        
ACT053                                                                  
ACT053     PERFORM 6797E-INSERT-WORK-QUEUE THRU 6797E-EXIT.             
      *                                                                         
       3500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  5000-CHK-DEP-REQ                                              *        
      ******************************************************************        
      *                                                                         
       5000-CHK-DEP-REQ.                                                
      *                                                                         
           MOVE AC-PYMT-PRIORITY-LVL        TO WS-PYMT-PRIORITY-LVL-AC  
      *                                                                         
           IF WS-PYMT-PRIORITY-LVL-AC = 80                              
               SET WS-HAS-DEP-REQ           TO TRUE                     
           ELSE                                                         
               SET WS-NO-DEP-REQ            TO TRUE                     
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42345600
      ******************************************************************        
      * 5100-UPDT-DEP-AND-RFND                                         *        
      *   UPDATE CSS_DEP_ON_HAND                                       *        
      *   INSERT ROW INTO CSS_INTEREST_HIST IF CALCULATED INTEREST     *        
      *   IS GREATER THAN 0.                                           *        
      ******************************************************************        
      *                                                                         
       5100-UPDT-DEP-AND-RFND.                                          
      *                                                                         
      * WS-AMT-REFUND IS THE TOTAL AMOUNT (DEP+INT) THAT WILL BE                
      * APPLIED TO THE AR. FOR DEPOSITS IT IS THE AMOUNT THAT IS                
      * INSERTED IN TH REFUND TABLE                                             
      *                                                                         
           MOVE ZERO                        TO WS-AMT-REFUND            
           IF WS-DEPOSIT-PLUS-INTEREST                                  
              MOVE WS-COMMON-DATE           TO DO-DATE-REFUNDED         
P00399* IF BILLED DEPOSIT,DO NOT MARK IT DEPSOIT AS REFUNDED                    
P00399        IF CSR-DATABASE AND WS-HAS-DEP-REQ                        
P00399           COMPUTE WS-AMT-REFUND =                                
P00399                   DO-AMT-DEPOSIT - AC-AMT-TRAN-BALANCE           
P00399        ELSE                                                      
P00399           MOVE 'R'                   TO DO-DEPOSIT-STATUS-CD     
P00399           MOVE DO-AMT-DEPOSIT        TO WS-AMT-REFUND            
P00399        END-IF                                                    
              ADD  WS-INTEREST-CALC         TO WS-AMT-REFUND            
              PERFORM 5700-INSERT-REFUND    THRU 5700-EXIT              
           END-IF.                                                      
      *                                                                         
           IF WS-INTEREST-CALC > ZERO                                   
              MOVE WS-COMMON-DATE           TO DO-DATE-INTST-CALC-TO    
              ADD WS-INTEREST-CALC          TO DO-INTRST-YTD            
                                               DO-TOTAL-INTRST          
               MOVE ZEROES                  TO WS-PAR-TYPE              
                                               WS-PAR-TYPE-NO           
              IF WS-INTEREST-ONLY                                       
                 MOVE WS-INTEREST-CALC      TO WS-AMT-REFUND            
                 PERFORM 5700-INSERT-REFUND THRU 5700-EXIT              
              END-IF                                                    
              IF WS-MST-SUB-ACCT-IND-AT = WS-M                          
                 PERFORM 5620-SEND-MST-ACCT-WQ                          
                                            THRU 5620-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF DO-DATE-INTST-CALC-TO <= SPACES                           
              MOVE -1                       TO WS-DATE-INTST-CALC-TO-NI 
           ELSE                                                         
              MOVE 0                        TO WS-DATE-INTST-CALC-TO-NI 
           END-IF.                                                      
           IF DO-DATE-REFUNDED <= SPACES                                
              MOVE -1                       TO WS-DATE-REFUND-NI        
           ELSE                                                         
              MOVE 0                        TO WS-DATE-REFUND-NI        
           END-IF.                                                      
      ******************************************************************        
      * WHEN DEPOSIT IS BEING REFUNDED IT SHOULD BE ADDED (NOT MOVED)  *        
      * TO THE AMT-REFUNDED, SO THAT ANY PARTIALS REFUNDS MADE         *        
      * EARLIER IS NOT LOST.                                           *        
      ******************************************************************        
           IF WS-DEPOSIT-PLUS-INTEREST                                  
              MOVE DO-AMT-REFUNDED          TO WS-AMT-REFUNDED          
P00399        IF CSR-DATABASE AND WS-HAS-DEP-REQ                        
P00399           COMPUTE WS-AMT-DEPOSIT = DO-AMT-DEPOSIT - WS-AMT-REFUND
P00399           ADD  WS-AMT-REFUND         TO WS-AMT-REFUNDED          
P00399        ELSE                                                      
P00399           MOVE 0                     TO WS-AMT-DEPOSIT           
P00399           ADD  DO-AMT-DEPOSIT        TO WS-AMT-REFUNDED          
P00399        END-IF                                                    
           ELSE                                                         
              MOVE DO-AMT-DEPOSIT           TO WS-AMT-DEPOSIT           
              MOVE DO-AMT-REFUNDED          TO WS-AMT-REFUNDED          
           END-IF                                                       
      *                                                                         
           PERFORM 8710-UPDATE-DEP          THRU 8710-EXIT.             
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5200-FMT-TR-HIST.                                              *        
      ******************************************************************        
      *                                                                         
       5200-FMT-TR-HIST.                                                
      *                                                                         
           MOVE AT-ACCOUNT-NO               TO WS-100-ACCT-NO.          
           MOVE WS-INDIRECT-JRNL            TO WS-100-JRNL-SORT-ID.     
           MOVE WS-CUSTOMER-NO-AT           TO WS-100-CUSTOMER-NO.      
           MOVE WS-PREMISE-NO-AT            TO WS-100-PREMISE-NO.       
           MOVE WS-REFUND                   TO WS-100-CODE-TERMINAL-TRAN
                                               WS-PAR-EIBTRNID.         
           MOVE WS-LOCAL-OFFICE-AT          TO WS-100-LOCAL-OFFICE-CD.  
           MOVE WS-COMMON-DATE              TO WS-100-DATE-LAST-ACTION. 
           MOVE WS-BATCH                    TO WS-100-CODE-ENTRY-SOURCE.
           MOVE CJF00101                    TO WS-100-USER-DEFINED-AREA.
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5250-LOAD-GL-NUMBERS.                                          *        
      ******************************************************************        
      *                                                                         
       5250-LOAD-GL-NUMBERS.                                            
      *                                                                 16780000
           MOVE WS-PGRMNAME                 TO WS-CPD00061-CALLING-PGM. 
      *                                                                 16780000
           MOVE SPACES                      TO ABEND-FUNCTION.          
           CALL SCSCB061 USING  WS-GL-ACCT-NAME,                        
                                WS-GL-ACCT-MAJOR-FIELDS,                
                                WS-VALID-COMPANY-NOS,                   
                                WS-GL-NAME-INFO,                        
                                WS-GL-ACCT-NO-TABLE,                    
                                WS-CPD00061-CALLING-PGM,                
                                ABEND-FILE,                             
                                RS-RETURN-CODE                          
      *                                                                 16920000
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                 16920000
       5250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16920000
      ******************************************************************        
      * 5300-REFUND-DEPOSIT.                                           *        
      ******************************************************************        
      *                                                                         
       5300-REFUND-DEPOSIT.                                             
      *                                                                         
           MOVE ZERO                        TO WS-DETAIL-END-AR-BAL     
           MOVE WS-JRNL-ONLY                TO WS-JRNL-OPERATION-RQST.  
           MOVE WS-TOTAL-AR-BALANCE-AT      TO WS-DETAIL-END-AR-BAL.    
           SUBTRACT DO-AMT-DEPOSIT FROM WS-DETAIL-END-AR-BAL.           
           MOVE WS-DETAIL-END-AR-BAL        TO WS-TOTAL-AR-BALANCE-AT.  
      *                                                                         
           MOVE DO-AMT-DEPOSIT              TO WS-AMOUNT-TEMP.          
           MOVE DO-AMT-DEPOSIT              TO WS-AMOUNT-TEMP2.         
      *                                                                         
           MOVE WS-AMOUNT-TEMP              TO AR-AMT-ORIG-ENTERED      
           MOVE WS-AMOUNT-TEMP2             TO AU-AMT-POSTED            
           MOVE 'DEPOSIT-INTEREST REFUND'   TO AR-TRAN-COMMENT-TEXT     
                                             WS-PAR-AR-TRAN-COMMENT-TEXT
           MOVE +23                         TO AR-TRAN-COMMENT-LEN      
                                              WS-PAR-AR-TRAN-COMMENT-LEN
           MOVE 'PCSCA097A'                 TO WS-PAR-APPL-PROG-ID.     
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5400-REFUND-INTEREST                                           *        
      ******************************************************************        
      *                                                                         
       5400-REFUND-INTEREST.                                            
      *                                                                         
           MOVE ZERO                        TO WS-DETAIL-END-AR-BAL.    
           MOVE WS-JRNL-ONLY                TO WS-JRNL-OPERATION-RQST.  
           MOVE WS-INTEREST-CALC            TO WS-AMOUNT-TEMP.          
           MOVE WS-INTEREST-CALC            TO WS-AMOUNT-TEMP2.         
      *                                                                         
           IF WS-INTEREST-ONLY                                          
              MOVE WS-TOTAL-AR-BALANCE-AT   TO WS-DETAIL-END-AR-BAL     
              SUBTRACT WS-INTEREST-CALC FROM WS-DETAIL-END-AR-BAL       
              MOVE WS-DETAIL-END-AR-BAL     TO WS-TOTAL-AR-BALANCE-AT   
              MOVE WS-AMOUNT-TEMP           TO AR-AMT-ORIG-ENTERED      
                                               AU-AMT-POSTED            
              MOVE 'INTEREST REFUND'        TO AR-TRAN-COMMENT-TEXT     
                                             WS-PAR-AR-TRAN-COMMENT-TEXT
              MOVE +15                      TO AR-TRAN-COMMENT-LEN      
                                              WS-PAR-AR-TRAN-COMMENT-LEN
              MOVE 'PCSCA097B'              TO WS-PAR-APPL-PROG-ID      
           END-IF.                                                      
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5500-APPLY-AS-PAYMENT                                          *        
      ******************************************************************        
      *                                                                         
       5500-APPLY-AS-PAYMENT.                                           
      *                                                                         
           MOVE WS-REFUND-DATE              TO WS-CD-REPORT-DATE.       
           MOVE WS-LOCAL-OFFICE-AT          TO WS-CD-LOCAL-OFFICE.      
           MOVE WS-CD-COMPANY-NO            TO WS-PAR-COMPANY-NO.       
           MOVE WS-CD-LOCAL-OFFICE          TO WS-PAR-LOCAL-OFFICE.     
           MOVE WS-CD-REPORT-NO             TO WS-PAR-REPORT-NO.        
           MOVE WS-CD-REPORT-DATE           TO WS-PAR-REPORT-DATE.      
           MOVE WS-CASH-DRAWER-ID           TO WS-PAR-CASH-DRAWER.      
           MOVE 'R'                         TO WS-PAR-CODE-TRAN-TYPE.   
           MOVE 'SYSTEM'                    TO WS-PAR-OPERATOR-ID.      
           MOVE SPACES                      TO WS-PAR-RESP-AREA         
                                               PF-RESP-AREA-ID.         
           MOVE 'Y'                         TO WS-DEPOSIT-REFUND-SW.    
           MOVE SPACES                      TO WS-PAR-PYMT-FACILITY-CD  
                                               WS-PAR-PAY-AHEAD         
                                               WS-PAR-PAY-CHRG-OFF.     
           MOVE 'B'                         TO WS-100-CODE-ENTRY-SOURCE 
                                               WS-JRNL-SOURCE-CODE.     
           MOVE SPACES                      TO WS-100-TRANS-ERRORS.     
      * THIS IS A NON-DIRECTED PYMT. WS-PAYMENT-AMOUNT AND                      
      * WS-PAYMENT-AMOUNT-TOTAL ARE THE SAME.                                   
           MOVE WS-PAYMENT-AMOUNT-TOTAL     TO WS-PAYMENT-AMOUNT.       
      * PAYMENT TYPE IS CASH                                                    
           MOVE WS-PAYMENT-AMOUNT-TOTAL     TO WS-AMT-CASH.             
      *                                                                         
           MOVE 'B'                         TO WS-PAR-UPDATE-TYPE.      
           MOVE 'N'                         TO WS-IS-THIS-DIRECTED-PYMT.
           MOVE DO-DEPOSIT-CERT-NO          TO WS-PAR-ITEM-ID-NO.       
      *                                                                         
           PERFORM 6700-APPLY-PAYMENT       THRU 6700-EXIT.             
      *                                                                         
           IF NOT PYMT-WAS-SUCCESSFUL                                   
              DISPLAY 'PAYMENT APPLICATION ERROR'                       
              DISPLAY 'ACCOUNT NO:' E-FDB07-ACCT-NO                     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5610-SEND-MANUAL-REF-WQ                                        *        
      *   HANDLE WORK QUEUE PROCESSING FOR PSNC GOOD CREDIT REFUNDS    *        
      *   THAT ARE MARKED NOT-ELIGIBILE                                *        
      ******************************************************************        
      *                                                                         
       5610-SEND-MANUAL-REF-WQ.                                         
      *                                                                         
           MOVE                                                         
          'AGENCY VOUCHER PD DEP ON ACCT. AGENCY IS ELIG FOR DEP REFUND'
                                            TO WS-MISC-MSG-TEXT.        
           MOVE +60                         TO WS-MISC-MSG-LEN.         
           MOVE 00                          TO RETURN-CODE.             
           MOVE +302                        TO WS-MISC-CATEGORY-ID.     
           PERFORM 3500-CREATE-WORK-QUEUE   THRU 3500-EXIT.             
      *                                                                         
       5610-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5620-SEND-MST-ACCT-WQ                                          *        
      *   HANDLE WORK QUEUE PROCESSING FOR INTEREST REFUNDS            *        
      ******************************************************************        
      *                                                                         
       5620-SEND-MST-ACCT-WQ.                                           
      *                                                                         
           MOVE 'CALCULATE & REFUND INTEREST FOR MASTER ACCOUNTS ANNUALL        
      -          'Y.'                                                           
                                            TO WS-MISC-MSG-TEXT.        
           MOVE +57                         TO WS-MISC-MSG-LEN.         
           MOVE 00                          TO RETURN-CODE.             
           MOVE +486                        TO WS-MISC-CATEGORY-ID.     
           PERFORM 3500-CREATE-WORK-QUEUE   THRU 3500-EXIT.             
      *                                                                         
       5620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5700-INSERT-REFUND.                                            *        
      *   THIS MODULES CONTROLS THE FIELD UPDATES CALLS THE            *        
      *   JOURNALING ROUTINE.                                          *        
      ******************************************************************        
      *                                                                         
       5700-INSERT-REFUND.                                              
      *                                                                         
           MOVE '5700'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           INITIALIZE RN-ACCT-NO-CREDITED                               
                      RN-CHECK-ISS-REAS-CD.                             
           IF WS-LAST-REFUND-ITEM-ID = 0                                
              PERFORM 7100-GET-REFUND-ITEM-ID                           
                                            THRU 7100-EXIT              
           END-IF                                                       
           IF WS-INTEREST-ONLY                                          
              MOVE WS-INTEREST-RFND         TO RN-CHECK-ISS-REAS-CD     
              MOVE 'INTEREST REFUND'        TO RN-COMMENTS-TEXT         
              MOVE +15                      TO RN-COMMENTS-LEN          
           ELSE                                                         
              MOVE WS-GOOD-CREDIT           TO RN-CHECK-ISS-REAS-CD     
              MOVE 'DEPOSIT-INTEREST REFUND'                            
                                            TO RN-COMMENTS-TEXT         
              MOVE +23                      TO RN-COMMENTS-LEN          
           END-IF                                                       
           ADD 1                            TO WS-LAST-REFUND-ITEM-ID   
           MOVE WS-LAST-REFUND-ITEM-ID      TO RN-REFUND-ITEM-ID.       
           MOVE '0'                         TO RN-ORIGINAL-CHECK-NO     
                                               RN-REFUND-CHECK-NO.      
           MOVE 'BATC'                      TO RN-PANEL-NO.             
           MOVE WS-CURRENT-TIMESTAMP        TO RN-TRANS-HIST-SEQ-NO.    
           MOVE '  '                        TO RN-RETURNED-REASON       
           MOVE 'SYSTEM'                    TO RN-USER-ID-APPRVD-BY.    
           MOVE 'SYSTEM'                    TO RN-USER-ID-RQSTED-BY.    
           MOVE WS-AMT-REFUND               TO RN-AMT-REFUNDED.         
           MOVE WS-APPLIED-TO-ACCT          TO RN-MANUAL-INDICATOR.     
           MOVE DO-DEPOSIT-CERT-NO          TO RN-DEPOSIT-CERT-NO.      
           MOVE SPACES                      TO RN-CHECK-STATUS-CD.      
           MOVE WS-REFUND-DATE              TO RN-DATE-REFUNDED         
                                               RN-REFUND-STATUS-DT      
                                               RN-REQUEST-DT.           
           MOVE AT-LOCAL-OFFICE             TO RN-LOCAL-OFFICE.         
           MOVE 0                           TO RN-ADDRESS-ID.           
           PERFORM 8100-INSERT-REFUND       THRU 8100-EXIT.             
      *                                                                         
       5700-EXIT.                                                       
           EXIT.                                                        
P00399*                                                                         
P00399******************************************************************        
P00399* 5710-WRITE-BEGIN-CONTROLS                                      *        
P00399******************************************************************        
P00399*                                                                         
P00399 5710-WRITE-BEGIN-CONTROLS.                                       
P00399*                                                                         
P00399     INITIALIZE E-FCA347-BEGIN-REC.                               
P00399     MOVE LOW-VALUES                  TO E-FCA347-BEGIN-REC.      
P00399     MOVE WS-PGRMNAME                 TO E-FCA347-EXTRACT-PGM.    
P00399     MOVE WS-INPUT-DATE               TO E-FCA347-RUN-DATE.       
P00399     PERFORM 8900-WRITE-FCA347        THRU 8900-EXIT.             
P00399     SUBTRACT 1 FROM WS-FCA347-REC-COUNT.                         
P00399*                                                                         
P00399 5710-EXIT.                                                       
P00399     EXIT.                                                        
P00399*                                                                         
P00399******************************************************************        
P00399* 5720-WRITE-END-CONTROLS.                                       *        
P00399******************************************************************        
P00399*                                                                         
P00399 5720-WRITE-END-CONTROLS.                                         
P00399*                                                                         
P00399     INITIALIZE E-FCA347-END-REC.                                 
P00399     MOVE HIGH-VALUES                 TO E-FCA347-END-REC.        
P00399     MOVE WS-FCA347-REC-COUNT         TO E-FCA347-RECORD-COUNT.   
P00399     PERFORM 8900-WRITE-FCA347        THRU 8900-EXIT.             
P00399*                                                                         
P00399 5720-EXIT.                                                       
P00399     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   6800 IS COPY CODE FOR PAYMENTS TO CHARGE OFF ACCTS.          *        
      *   THIS IS REFERENCED IN CPD00010 BUT DOES NOT APPLY TO         *        
      *   BATCH BILLING.                                               *        
      ******************************************************************        
      *                                                                         
       6800-APPLY-PYMT-CO.                                              
      *                                                                         
           CONTINUE.                                                    
      *                                                                         
       6800-APPLY-PYMT-CO-EXIT.                                         
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-GET-ACCT-DTLS.                                            *        
      ******************************************************************        
      *                                                                         
       7000-GET-ACCT-DTLS.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.ACCOUNT_TYPE_CODE                               
                    ,AT.PREMISE_NO                                      
                    ,AT.CUSTOMER_NO                                     
P00399              ,AT.COMPANY_NO                                      
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.CREDIT_GROUP                                    
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.CODE_COMPANY_ACCT                               
                    ,AT.REV_MTH_LST_NRML                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
                    ,AT.MST_SUB_ACCT_IND                                
                    ,PR.REV_DISTRICT_CD                                 
                    ,PR.CODE_PREMISE_STAT                               
                    ,CU.CODE_EMPL_ACCT                                  
ACT121              ,AT.CODE_ACCT_BILLED                                
                INTO :AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-PREMISE-NO                                     
                    ,:AT-CUSTOMER-NO                                    
P00399              ,:AT-COMPANY-NO                                     
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CODE-COMPANY-ACCT                              
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-ACCT-CREATE-DT :WS-NULL-ACCT-CREATE-DT          
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:PR-REV-DISTRICT-CD                                
                    ,:PR-CODE-PREMISE-STAT                              
                    ,:CU-CODE-EMPL-ACCT                                 
ACT121              ,:AT-CODE-ACCT-BILLED                               
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
                    ,CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
                    ,CSS_PREMISE PR WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                    
                 AND AT.PREMISE_NO  = PR.PREMISE_NO                     
                 AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.CODE_COMPANY_ACCT                                       
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.ACCT_CREATE_DT                                          
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                        
MFA-TR*             ,PR.REV_DISTRICT_CD                                         
MFA-TR*             ,PR.CODE_PREMISE_STAT                                       
MFA-TR*             ,CU.CODE_EMPL_ACCT                                          
MFA-TR*             ,AT.CODE_ACCT_BILLED                                        
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-CODE-COMPANY-ACCT                                      
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-ACCT-CREATE-DT:WS-NULL-ACCT-CREATE-DT                  
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:PR-REV-DISTRICT-CD                                        
MFA-TR*             ,:PR-CODE-PREMISE-STAT                                      
MFA-TR*             ,:CU-CODE-EMPL-ACCT                                         
MFA-TR*             ,:AT-CODE-ACCT-BILLED                                       
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*             ,CSS_CUSTOMER CU                                            
MFA-TR*             ,CSS_PREMISE PR                                             
MFA-TR*        WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                            
MFA-TR*          AND AT.PREMISE_NO  = PR.PREMISE_NO                             
MFA-TR*          AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              IF WS-NULL-ACCT-CREATE-DT < 0 THEN                        
                 MOVE SPACES                TO AT-ACCT-CREATE-DT        
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7000-GET-ACCT-DTLS     **'         
              DISPLAY '**   ACCOUNT NO   = ' AT-ACCOUNT-NO              
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7001-READ-FCSDB07                                              *        
      ******************************************************************        
      *                                                                         
       7001-READ-FCSDB07.                                               
      *                                                                         
           READ FCSDB07-FILE                                            
               AT END                                                   
                   MOVE WS-Y                TO WS-END-OF-FILE           
                   GO TO 7001-EXIT                                      
           END-READ.                                                    
      *                                                                         
           IF  FDB07-SUCCESSFUL                                         
               ADD 1 TO WS-FCSDB07-REC-CNTR                             
           ELSE                                                         
               DISPLAY '7001-ERROR ON FCSDB07 READ.  STATUS IS '        
                        WS-FDB07-STATUS                                 
               DISPLAY 'ERROR IN ACCOUNT NO' E-FDB07-ACCT-NO            
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00399******************************************************************        
P00399* 7002-READ-FCA347                                               *        
P00399******************************************************************        
P00399*                                                                         
P00399 7002-READ-FCA347.                                                
P00399*                                                                         
P00399     READ FCA347R-FILE                                            
P00399         AT END                                                   
P00399             MOVE WS-Y                TO WS-END-OF-FILE           
P00399             GO TO 7002-EXIT                                      
P00399     END-READ.                                                    
P00399*                                                                         
P00399     IF FCA347-SUCCESSFUL                                         
P00399        CONTINUE                                                  
P00399     ELSE                                                         
P00399         DISPLAY '7002-ERROR ON FCA347 READ.  STATUS IS '         
P00399                  WS-FCA347R-STATUS                               
P00399         PERFORM 9900-ABEND           THRU 9900-EXIT              
P00399     END-IF.                                                      
P00399*                                                                         
P00399 7002-EXIT.                                                       
P00399     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7003-GET-DT-CI-MTHS-AGO                                        *        
      *   DETERMINE DATE USING DELINQUENCY VALUE MONTHS AGO            *        
      *   FROM RUN DATE                                                *        
      ******************************************************************        
      *                                                                         
       7003-GET-DT-CI-MTHS-AGO.                                         
      *                                                                         
           IF WS-ACCOUNT-TYPE-CODE-AT = 'C'                             
             EXEC SQL                                                   
                SELECT
              DATEADD( MONTH, -:WS-RETAIN-COMMER-DEP, 
              IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-DATE-CI-MONTHS-AGO                  
             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SET :WS-DATE-CI-MONTHS-AGO                                      
MFA-TR*              = DATE(:WS-COMMON-DATE)                                    
MFA-TR*                 - :WS-RETAIN-COMMER-DEP MONTHS                          
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
           ELSE                                                         
             EXEC SQL                                                   
                SELECT
              DATEADD( MONTH, -:WS-RETAIN-INDUST-DEP, 
              IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-DATE-CI-MONTHS-AGO                   
             END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SET :WS-DATE-CI-MONTHS-AGO                                      
MFA-TR*              = DATE(:WS-COMMON-DATE)                                    
MFA-TR*                - :WS-RETAIN-INDUST-DEP MONTHS                           
MFA-TR*      END-EXEC                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                   
           END-IF                                                       
      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********************************************'    
              DISPLAY '**   ERROR ON 7003-GET-DT-CI-MTHS-AGO **'        
              DISPLAY '**   COMMON DATE  = ' WS-COMMON-DATE             
              DISPLAY '**   INDUST DEP   = ' WS-RETAIN-INDUST-DEP       
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED            **'    
              DISPLAY '********************************************'    
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7003-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04531******************************************************************        
A04531* 7004-GET-DT-CSR-MTHS-AGO                                       *        
A04531*   DETERMINE DATE USING DELINQUENCY VALUE MONTHS AGO            *        
A04531*   FROM RUN DATE                                                *        
A04531******************************************************************        
A04531*                                                                         
A04531 7004-GET-DT-CSR-MTHS-AGO.                                        
      *                                                                         
A04531       EXEC SQL                                                   
A04531          SELECT
              DATEADD( MONTH, -:WS-RETAIN-RES-DEP, 
              IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-DATE-CSR-MONTHS-AGO                     
A04531       END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SET :WS-DATE-CSR-MONTHS-AGO                                     
MFA-TR*              = DATE(:WS-COMMON-DATE)                                    
MFA-TR*                 - :WS-RETAIN-RES-DEP MONTHS                             
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
A04531                                         WS-ACTIVE-RETURN-CODE.   
      *                                                                         
A04531     IF SQLCODE = SUCCESSFUL-CALL                                 
A04531        CONTINUE                                                  
A04531     ELSE                                                         
A04531        DISPLAY '********************************************'    
A04531        DISPLAY '**   ERROR ON 7004-GET-DT-CSR-MTHS-AGO **'       
A04531        DISPLAY '**   COMMON DATE  = ' WS-COMMON-DATE             
A04531        DISPLAY '**   RESID  DEP   = ' WS-RETAIN-RES-DEP          
A04531        DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
A04531        DISPLAY '**       PROCESSING TERMINATED            **'    
A04531        DISPLAY '********************************************'    
A04531        PERFORM 9900-ABEND            THRU 9900-EXIT              
A04531     END-IF.                                                      
      *                                                                         
A04531 7004-EXIT.                                                       
A04531     EXIT.                                                        
      *                                                                         
      ******************************************************************        
A04531* 7005-GET-DT-INT-MTHS-AGO                                *               
      ******************************************************************        
      *                                                                         
A04531 7005-GET-DT-INT-MTHS-AGO.                                        
      *                                                                         
           EXEC SQL                                                     
A04531        SELECT
              DATEADD( MONTH, -:WS-DELINQ-REFUND-INT, 
              IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-DATE-INT-MNTHS-AGO
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-INT-MNTHS-AGO                                        
MFA-TR*           = DATE(:WS-COMMON-DATE) - :WS-DELINQ-REFUND-INT MONTHS        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7005-GET-DT-INT-MTHS-AGO   **'     
              DISPLAY '**   COMMON DATE   = ' WS-COMMON-DATE            
A04531        DISPLAY '**   REFUND INTRST = ' WS-DELINQ-REFUND-INT      
              DISPLAY '**   SQLCODE       = ' WS-DISPLAY-SQLCODE        
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7008-GET-DT-SEB-MTHS-AGO                                       *        
      ******************************************************************        
      *                                                                         
       7008-GET-DT-SEB-MTHS-AGO.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, -:WS-RETAIN-RES-DEP, 
              IIF(TRY_CONVERT(DATE, :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) ) )
            INTO
              :WS-DATE-SEB-MONTHS-AGO   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-SEB-MONTHS-AGO                                       
MFA-TR*           = DATE(:WS-COMMON-DATE) - :WS-RETAIN-RES-DEP MONTHS           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7008-GET-DT-SEB-MTHS-AGO **'       
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7008-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      * 7030-GET-CREDIT-DTLS.                                    *              
      ************************************************************              
      *                                                                         
       7030-GET-CREDIT-DTLS.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT CZ.ARREARS_HIST                                    
                    ,CZ.DISCONNECT_HIST                                 
                    ,CZ.DISC_EXCEPTN_HIST                               
                INTO :CZ-ARREARS-HIST                                   
                    ,:CZ-DISCONNECT-HIST                                
                    ,:CZ-DISC-EXCEPTN-HIST                              
                FROM CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                
               WHERE CZ.ACCOUNT_NO = :CZ-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CZ.ARREARS_HIST                                            
MFA-TR*             ,CZ.DISCONNECT_HIST                                         
MFA-TR*             ,CZ.DISC_EXCEPTN_HIST                                       
MFA-TR*         INTO :CZ-ARREARS-HIST                                           
MFA-TR*             ,:CZ-DISCONNECT-HIST                                        
MFA-TR*             ,:CZ-DISC-EXCEPTN-HIST                                      
MFA-TR*         FROM CSS_CREDIT_PROFILE CZ                                      
MFA-TR*        WHERE CZ.ACCOUNT_NO = :CZ-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**  ERROR ON 7030-GET-CREDIT-DTLS        **'     
              DISPLAY '**  ACCOUNT NO   = ' CZ-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * 7050-GET-AR-DTLS.                                          *            
      **************************************************************            
      *                                                                         
       7050-GET-AR-DTLS.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                     COALESCE(SUM(AC.AMT_AR_DAY_00),0)                  
                    ,COALESCE(SUM(AC.AMT_AR_DAY_30),0)                  
                    ,COALESCE(SUM(AC.AMT_AR_DAY_60),0)                  
                    ,COALESCE(SUM(AC.AMT_AR_DAY_90),0)                  
                INTO :AC-AMT-AR-DAY-00                                  
                    ,:AC-AMT-AR-DAY-30                                  
                    ,:AC-AMT-AR-DAY-60                                  
                    ,:AC-AMT-AR-DAY-90                                  
                FROM CSS_AR_CNTL  AC WITH(READUNCOMMITTED)                      
               WHERE AC.ACCOUNT_NO = :AC-ACCOUNT-NO                     
                 AND AC.ITEM_ID    = 0                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*              COALESCE(SUM(AC.AMT_AR_DAY_00),0)                          
MFA-TR*             ,COALESCE(SUM(AC.AMT_AR_DAY_30),0)                          
MFA-TR*             ,COALESCE(SUM(AC.AMT_AR_DAY_60),0)                          
MFA-TR*             ,COALESCE(SUM(AC.AMT_AR_DAY_90),0)                          
MFA-TR*         INTO :AC-AMT-AR-DAY-00                                          
MFA-TR*             ,:AC-AMT-AR-DAY-30                                          
MFA-TR*             ,:AC-AMT-AR-DAY-60                                          
MFA-TR*             ,:AC-AMT-AR-DAY-90                                          
MFA-TR*         FROM CSS_AR_CNTL  AC                                            
MFA-TR*        WHERE AC.ACCOUNT_NO = :AC-ACCOUNT-NO                             
MFA-TR*          AND AC.ITEM_ID    = 0                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7050-GET-AR-DTLS           **'     
              DISPLAY '**   ACCOUNT NO  = ' AC-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 28211000
      * 7100-GET-REFUND-ITEM-ID                                       * 28220000
      ***************************************************************** 28260000
      *                                                                         
       7100-GET-REFUND-ITEM-ID.                                         
      *                                                                 28290000
           EXEC SQL                                                     
              SELECT COALESCE(MAX(REFUND_ITEM_ID), 0)                   
                INTO :WS-LAST-REFUND-ITEM-ID                            
                FROM CSS_REFUND WITH(READUNCOMMITTED)                           
               WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28300000
MFA-TR*       SELECT COALESCE(MAX(REFUND_ITEM_ID), 0)                   28310000
MFA-TR*         INTO :WS-LAST-REFUND-ITEM-ID                            28320000
MFA-TR*         FROM CSS_REFUND                                         28330000
MFA-TR*        WHERE ACCOUNT_NO = :RN-ACCOUNT-NO                        28340000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                    28350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28360000
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7100-GET-REFUND-ITEM-ID    **'     
              DISPLAY '**   ACCOUNT-NO  = ' RN-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 28540000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28540000
      *****************************************************************         
      * 7110-SEL-CURRENT-DT.                                          *         
      *   SELECTS VALUES FROM CSS_DELINQUENCY                         *         
      *****************************************************************         
      *                                                                         
       7110-SEL-CURRENT-DT.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*          ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7110-SEL-CURRENT-DT   **'          
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7120-SELECT-RESTART                                          *          
      ****************************************************************          
      *                                                                         
       7120-SELECT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT RF.RESTART_DATA                                    
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART RF WITH(READUNCOMMITTED)                       
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RF.RESTART_DATA                                            
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART RF                                             
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                         
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7120                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7120-SELECT-RESTART        **'     
              DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-GET-DLINQ-VAL.                                           *         
      *****************************************************************         
      *                                                                         
       7200-GET-DLINQ-VAL.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                      
                 AND C8.COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*          AND C8.COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7200-GET-DLINQ-VAL      **'        
              DISPLAY '**   DELINQ CD   = ' C8-DELINQ-CD                
              DISPLAY '**   COMPANY NO  = ' C8-COMPANY-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-OPEN-DEP-ON-HAND                                          *        
      ******************************************************************        
      *                                                                         
       7300-OPEN-DEP-ON-HAND.                                           
      *                                                                         
           EXEC SQL                                                     
              OPEN DEP_ON_HAND                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7300-OPEN-DEP-ON-HAND      **'     
              DISPLAY '**   ACCOUNT NO  = ' AT-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7301-FETCH-DEP-ON-HAND                                         *        
      ******************************************************************        
      *                                                                         
       7301-FETCH-DEP-ON-HAND.                                          
      *                                                                         
           EXEC SQL                                                     
              FETCH DEP_ON_HAND INTO                                    
                   :DO-ACCOUNT-NO                                       
                  ,:DO-DEPOSIT-CERT-NO                                  
                  ,:DO-AMT-DEPOSIT                                      
                  ,:DO-DATE-CERT-ISSUE :WS-NULL-IND-1                   
                  ,:DO-DATE-INTST-CALC-TO :WS-NULL-IND-2                
                  ,:DO-INTRST-YTD                                       
                  ,:DO-TOTAL-INTRST                                     
                  ,:DO-CODE-REFUND-ELIG                                 
                  ,:DO-CODE-REFUND-STATUS                               
                  ,:DO-EMPL-HOLD-INIT                                   
                  ,:DO-DATE-TRAN :WS-NULL-IND-3                         
                  ,:DO-CODE-DEP-TYPE                                    
                  ,:DO-SERVICE-TYPE-CD                                  
                  ,:DO-PROJECTED-CR-DT :WS-NULL-IND-4                   
                  ,:DO-TRANSFERRED-FROM                                 
                  ,:DO-TRANSFERRED-TO                                   
                  ,:DO-TRANSFER-AMT                                     
                  ,:DO-DEPOSIT-STATUS-CD                                
                  ,:DO-USER-ID-UPDT-BY                                  
                  ,:DO-DATE-REFUNDED :WS-NULL-IND-5                     
                  ,:DO-CODE-REFUND-TYPE                                 
                  ,:DO-CODE-REFUND-REASON                               
                  ,:DO-CODE-REFUND-FROM                                 
                  ,:DO-DEP-ACTION-CODE                                  
                  ,:DO-DEP-CERT-NO-TO                                   
                  ,:DO-DEP-CERT-NO-FROM                                 
                  ,:DO-DATE-PYMT-START :WS-NULL-IND-6                   
                  ,:DO-AMT-REFUNDED                                     
                  ,:DO-COMMENTS                                         
                  ,:AC-PYMT-PRIORITY-LVL                                
                  ,:AC-ITEM-ID                                          
                  ,:AC-AMT-TRAN-BALANCE                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              OR NOT-FOUND                                              
              IF SQLCODE = SUCCESSFUL-CALL                              
                 IF WS-NULL-IND-1 < ZERO                                
                     MOVE LOW-VALUES       TO DO-DATE-CERT-ISSUE        
                 END-IF                                                 
                 IF WS-NULL-IND-2 < ZERO                                
                     MOVE LOW-VALUES       TO DO-DATE-INTST-CALC-TO     
                 END-IF                                                 
                 IF WS-NULL-IND-3 < ZERO                                
                     MOVE LOW-VALUES       TO DO-DATE-TRAN              
                 END-IF                                                 
                 IF WS-NULL-IND-4 < ZERO                                
                     MOVE LOW-VALUES       TO DO-PROJECTED-CR-DT        
                 END-IF                                                 
                 IF WS-NULL-IND-5 < ZERO                                
                     MOVE LOW-VALUES       TO DO-DATE-REFUNDED          
                 END-IF                                                 
                 IF WS-NULL-IND-6 < ZERO                                
                     MOVE LOW-VALUES       TO DO-DATE-PYMT-START        
                 END-IF                                                 
              ELSE                                                      
                 MOVE LOW-VALUES           TO DO-DATE-CERT-ISSUE        
                                              DO-DATE-INTST-CALC-TO     
                                              DO-DATE-TRAN              
                                              DO-PROJECTED-CR-DT        
                                              DO-DATE-REFUNDED          
                                              DO-DATE-PYMT-START        
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7301-FETCH-DEP-ON-HAND     **'     
              DISPLAY '**   ACCOUNT NO  = ' AT-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7301-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7302-CLOSE-DEP-ON-HAND                                         *        
      ******************************************************************        
      *                                                                         
       7302-CLOSE-DEP-ON-HAND.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE DEP_ON_HAND                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7302-CLOSE-DEP-ON-HAND     **'     
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7302-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************40260000
      * 7510-CHK-ACTIVE-DEP.                                           *40280000
      *   CHECKS IF ANY PAID/BILLED DEPOSITS EXISTS ON THE ACCOUNT     *40290000
      ******************************************************************40300000
      *                                                                         
       7510-CHK-ACTIVE-DEP.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                               
                INTO  :WS-DEP-EXISTS                                    
                FROM  CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                  
               WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                    
                 AND  DO.DEPOSIT_STATUS_CD IN ('A','P')                 
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO  :WS-DEP-EXISTS                                            
MFA-TR*         FROM  CSS_DEP_ON_HAND DO                                        
MFA-TR*        WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                            
MFA-TR*          AND  DO.DEPOSIT_STATUS_CD IN ('A','P')                         
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7510-CHK-ACTIVE-DEP  **'           
              DISPLAY '**   ACCOUNT     = ' DO-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00518******************************************************************40260000
P00518* 7511-CHECK-GF-DEPOSIT.                                         *40280000
P00518*   CHECK TO SEE IF DEPOSIT SHOULD BE GRAND FATHERED             *40290000
P00518******************************************************************40300000
P00518*                                                                         
P00518 7511-CHECK-GF-DEPOSIT.                                           
P00518*                                                                         
P00518     EXEC SQL                                                     
P00518        SELECT TOP(1) 'Y'                                               
P00518          INTO  :WS-GRAND-FATHER-DEPOSIT                          
P00518          FROM  CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                  
P00518         WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                    
P00518           AND  DO.DEPOSIT_STATUS_CD IN ('A','P')                 
P00518           AND  DO.DATE_TRAN <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-DO-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :WS-DO-DATE-TRANS
              ) <> 0) OR (LEN(:WS-DO-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                      :WS-DO-DATE-TRANS
              ), CONVERT(DATE, :WS-DO-DATE-TRANS) )                 
P00518         ORDER BY DO.DATE_TRAN                                    
P00518                                     
P00518                                                      
P00518     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO  :WS-GRAND-FATHER-DEPOSIT                                  
MFA-TR*         FROM  CSS_DEP_ON_HAND DO                                        
MFA-TR*        WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                            
MFA-TR*          AND  DO.DEPOSIT_STATUS_CD IN ('A','P')                         
MFA-TR*          AND  DO.DATE_TRAN <= :WS-DO-DATE-TRANS                         
MFA-TR*        ORDER BY DO.DATE_TRAN                                            
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*         QUERYNO 7511                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00518                                                                  
P00518     MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
P00518                                         WS-ACTIVE-RETURN-CODE.   
P00518*                                                                         
P00518     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
P00518        CONTINUE                                                  
P00518     ELSE                                                         
P00518        DISPLAY '*******************************************'     
P00518        DISPLAY '**   ERROR ON 7511-CHK-ACTIVE-DEP  **'           
P00518        DISPLAY '**   ACCOUNT     = ' DO-ACCOUNT-NO               
P00518        DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
P00518        DISPLAY '**       PROCESSING TERMINATED           **'     
P00518        DISPLAY '*******************************************'     
P00518        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00518     END-IF.                                                      
P00518*                                                                         
P00518 7511-EXIT.                                                       
P00518     EXIT.                                                        
      *                                                                         
      ******************************************************************40260000
      * 7515-CHK-LAST-SEB-DEP                                          *40280000
      *   SELECTS A COUNT OF ANY DEPOSITS THAT WERE ISSUED WITHIN      *40290000
      *   THE LAST 06 MONTHS.                                          *40290000
      ******************************************************************40300000
      *                                                                         
       7515-CHK-LAST-SEB-DEP.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  COUNT(*)                                          
                INTO  :WS-RECENT-DEP-COUNT                              
                FROM  CSS_DEP_ON_HAND DO WITH(READUNCOMMITTED)                  
               WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                    
                 AND  DO.DEPOSIT_STATUS_CD IN ('A','P')                 
                 AND  DO.DATE_PYMT_START > IIF(TRY_CONVERT(DATE, 
                                                :WS-DATE-SEB-MONTHS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-SEB-MONTHS-AGO
              ) <> 0) OR (LEN(:WS-DATE-SEB-MONTHS-AGO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-SEB-MONTHS-AGO
              ), CONVERT(DATE, :WS-DATE-SEB-MONTHS-AGO) )      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  COUNT(*)                                                  
MFA-TR*         INTO  :WS-RECENT-DEP-COUNT                                      
MFA-TR*         FROM  CSS_DEP_ON_HAND DO                                        
MFA-TR*        WHERE  DO.ACCOUNT_NO = :DO-ACCOUNT-NO                            
MFA-TR*          AND  DO.DEPOSIT_STATUS_CD IN ('A','P')                         
MFA-TR*          AND  DO.DATE_PYMT_START > :WS-DATE-SEB-MONTHS-AGO              
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7515                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7515-CHK-LAST-SEB-DEP    **'       
              DISPLAY '**   ACCOUNT  NO  = ' DO-ACCOUNT-NO              
              DISPLAY '**   NO. OF MONTH = ' WS-DATE-SEB-MONTHS-AGO     
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7515-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************37462000
      * 8100-INSERT-REFUND                                             *37470000
      ******************************************************************37500000
      *                                                                         
       8100-INSERT-REFUND.                                              
      *                                                                 37530000
           EXEC SQL                                                     
              INSERT INTO CSS_REFUND                                    
                     (ACCOUNT_NO,                                       
                      REFUND_ITEM_ID,                                   
                      AMT_REFUNDED,                                     
                      CHECK_STATUS_CD,                                  
                      CHECK_ISS_REAS_CD,                                
                      COMMENTS,                                         
                      DATE_REFUNDED,                                    
                      REQUEST_DT,                                       
                      DEPOSIT_CERT_NO,                                  
                      PANEL_NO,                                         
                      USER_ID_RQSTED_BY,                                
                      MANUAL_INDICATOR,                                 
                      REFUND_CHECK_NO,                                  
                      LOCAL_OFFICE,                                     
                      ORIGINAL_CHECK_NO,                                
                      RETURNED_REASON,                                  
                      USER_ID_APPRVD_BY,                                
                      REFUND_STATUS_DT,                                 
                      TRANS_HIST_SEQ_NO,                                
                      ADDRESS_ID,                                       
                      ACCT_NO_CREDITED)                                 
              VALUES (:RN-ACCOUNT-NO,                                   
                      :RN-REFUND-ITEM-ID,                               
                      :RN-AMT-REFUNDED,                                 
                      :RN-CHECK-STATUS-CD,                              
                      :RN-CHECK-ISS-REAS-CD,                            
                      :RN-COMMENTS,                                     
                      IIF(TRY_CONVERT(DATE, :RN-DATE-REFUNDED
              ) IS NULL OR (PATINDEX('%.%', :RN-DATE-REFUNDED
              ) <> 0) OR (LEN(:RN-DATE-REFUNDED) <> 10), CIS.CHAR2DATE(
                                                      :RN-DATE-REFUNDED
              ), CONVERT(DATE, :RN-DATE-REFUNDED) ),                           
                      IIF(TRY_CONVERT(DATE, :RN-REQUEST-DT 
                                            :WS-RN-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :RN-REQUEST-DT 
                                                      :WS-RN-NULL-IND-1
              ) <> 0) OR (LEN(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:RN-REQUEST-DT :WS-RN-NULL-IND-1
              ), CONVERT(DATE, :RN-REQUEST-DT :WS-RN-NULL-IND-1) ),            
                      :RN-DEPOSIT-CERT-NO,                              
                      :RN-PANEL-NO,                                     
                      :RN-USER-ID-RQSTED-BY,                            
                      :RN-MANUAL-INDICATOR,                             
                      :RN-REFUND-CHECK-NO,                              
                      :RN-LOCAL-OFFICE,                                 
                      :RN-ORIGINAL-CHECK-NO,                            
                      :RN-RETURNED-REASON,                              
                      :RN-USER-ID-APPRVD-BY,                            
                      IIF(TRY_CONVERT(DATE, :RN-REFUND-STATUS-DT
              ) IS NULL OR (PATINDEX('%.%', :RN-REFUND-STATUS-DT
              ) <> 0) OR (LEN(:RN-REFUND-STATUS-DT
              ) <> 10), CIS.CHAR2DATE(:RN-REFUND-STATUS-DT
              ), CONVERT(DATE, :RN-REFUND-STATUS-DT) ),                        
                      CIS.CHAR2TIMESTAMP(:RN-TRANS-HIST-SEQ-NO),                
                      :RN-ADDRESS-ID,                                   
                      :RN-ACCT-NO-CREDITED)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     37540000
MFA-TR*       INSERT INTO CSS_REFUND                                    37550000
MFA-TR*              (ACCOUNT_NO,                                       37560000
MFA-TR*               REFUND_ITEM_ID,                                   37570000
MFA-TR*               AMT_REFUNDED,                                     37580000
MFA-TR*               CHECK_STATUS_CD,                                  37590000
MFA-TR*               CHECK_ISS_REAS_CD,                                37600000
MFA-TR*               COMMENTS,                                         37610000
MFA-TR*               DATE_REFUNDED,                                    37620000
MFA-TR*               REQUEST_DT,                                       37621000
MFA-TR*               DEPOSIT_CERT_NO,                                  37630000
MFA-TR*               PANEL_NO,                                         37640000
MFA-TR*               USER_ID_RQSTED_BY,                                37650000
MFA-TR*               MANUAL_INDICATOR,                                 37660000
MFA-TR*               REFUND_CHECK_NO,                                  37665000
MFA-TR*               LOCAL_OFFICE,                                     37670000
MFA-TR*               ORIGINAL_CHECK_NO,                                37690000
MFA-TR*               RETURNED_REASON,                                  37700000
MFA-TR*               USER_ID_APPRVD_BY,                                37710000
MFA-TR*               REFUND_STATUS_DT,                                 37720000
MFA-TR*               TRANS_HIST_SEQ_NO,                                37730000
MFA-TR*               ADDRESS_ID,                                       37740000
MFA-TR*               ACCT_NO_CREDITED)                                 37741000
MFA-TR*       VALUES (:RN-ACCOUNT-NO,                                   37750000
MFA-TR*               :RN-REFUND-ITEM-ID,                               37760000
MFA-TR*               :RN-AMT-REFUNDED,                                 37770000
MFA-TR*               :RN-CHECK-STATUS-CD,                              37780000
MFA-TR*               :RN-CHECK-ISS-REAS-CD,                            37790000
MFA-TR*               :RN-COMMENTS,                                     37800000
MFA-TR*               :RN-DATE-REFUNDED,                                37810000
MFA-TR*               :RN-REQUEST-DT:WS-RN-NULL-IND-1,                  37811000
MFA-TR*               :RN-DEPOSIT-CERT-NO,                              37820000
MFA-TR*               :RN-PANEL-NO,                                     37830000
MFA-TR*               :RN-USER-ID-RQSTED-BY,                            37840000
MFA-TR*               :RN-MANUAL-INDICATOR,                             37850000
MFA-TR*               :RN-REFUND-CHECK-NO,                              37860000
MFA-TR*               :RN-LOCAL-OFFICE,                                 37870000
MFA-TR*               :RN-ORIGINAL-CHECK-NO,                            37880000
MFA-TR*               :RN-RETURNED-REASON,                              37890000
MFA-TR*               :RN-USER-ID-APPRVD-BY,                            37900000
MFA-TR*               :RN-REFUND-STATUS-DT,                             37910000
MFA-TR*               :RN-TRANS-HIST-SEQ-NO,                            37920000
MFA-TR*               :RN-ADDRESS-ID,                                   37930000
MFA-TR*               :RN-ACCT-NO-CREDITED)                             37931000
MFA-TR*    END-EXEC.                                                    37940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37950000
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                 37970000
           IF SQLCODE  = SUCCESSFUL-CALL                                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 8100-INSERT-REFUND         **'     
              DISPLAY '**   ACCOUNT NO    = ' RN-ACCOUNT-NO             
              DISPLAY '**   SQLCODE       = ' WS-DISPLAY-SQLCODE        
              DISPLAY '**        PROCESSING TERMINATED          **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 38140000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 38140000
      ******************************************************************42130000
      * 8200-UPDATE-ACCOUNT                                            *42140000
      ******************************************************************42170000
       8200-UPDATE-ACCOUNT.                                             
      *                                                                 42200000
           EXEC SQL                                                     
              UPDATE                                                    
                     CSS_ACCOUNT                                        
                 SET                                                    
                     CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        
                    ,DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )              
                    ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
               WHERE                                                    
                     ACCOUNT_NO         = :AT-ACCOUNT-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42210000
MFA-TR*       UPDATE                                                    42220000
MFA-TR*              CSS_ACCOUNT                                        42220000
MFA-TR*          SET                                                    42240000
MFA-TR*              CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT        42240000
MFA-TR*             ,DATE_LAST_ACTION   = :WS-CURRENT-DATE                      
MFA-TR*             ,LAST_UPDATE_TS     = :WS-CURRENT-TIMESTAMP                 
MFA-TR*        WHERE                                                    42260000
MFA-TR*              ACCOUNT_NO         = :AT-ACCOUNT-NO                42260000
MFA-TR*        QUERYNO 8200                                                     
MFA-TR*    END-EXEC.                                                    42270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42280000
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                 42300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 8200-UPDATE-ACCOUNT        **'     
              DISPLAY '**   ACCOUNT NO      = ' AT-ACCOUNT-NO           
              DISPLAY '**   SQLCODE         = ' WS-DISPLAY-SQLCODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 42430000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************42451000
      * 8535-UPDT-TR-HIST.                                             *42452000
      ******************************************************************42455000
      *                                                                         
       8535-UPDT-TR-HIST.                                               
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_AR_TRANS_HIST                                  
                 SET AMT_ORIG_ENTERED    = :RN-AMT-REFUNDED             
               WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO               
                 AND CODE_TRAN_TYPE      = 'R'                          
                 AND TRANS_HIST_SEQ_NO   = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42460900
MFA-TR*       UPDATE CSS_AR_TRANS_HIST                                  42461000
MFA-TR*          SET AMT_ORIG_ENTERED    = :RN-AMT-REFUNDED             42462000
MFA-TR*        WHERE ACCOUNT_NO          = :AT-ACCOUNT-NO               42463000
MFA-TR*          AND CODE_TRAN_TYPE      = 'R'                          42465000
MFA-TR*          AND TRANS_HIST_SEQ_NO   = :AR-TRANS-HIST-SEQ-NO        42466000
MFA-TR*        QUERYNO 8535                                                     
MFA-TR*    END-EXEC.                                                    42470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42470100
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                 42470300
           IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*****************************************'       
              DISPLAY '**  ERROR ON 8535-UPDT-TR-HIST **'               
              DISPLAY '**  ACCOUNT NO        = ' AT-ACCOUNT-NO          
              DISPLAY '**  TRANS_HIST_SEQ_NO = ' AR-TRANS-HIST-SEQ-NO   
              DISPLAY '**  SQLCODE           = ' WS-DISPLAY-SQLCODE     
              DISPLAY '**       PROCESSING TERMINATED         **'       
              DISPLAY '*****************************************'       
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 42471600
       8535-EXIT.                                                       
           EXIT.                                                        
      *                                                                 38140000
      ******************************************************************        
      * 8710-UPDATE-DEP                                                *        
      ******************************************************************        
      *                                                                         
       8710-UPDATE-DEP.                                                 
      *                                                                         
           EXEC SQL                                                     
              UPDATE DO                                  
                 SET DO.CODE_REFUND_ELIG   = :DO-CODE-REFUND-ELIG,      
                     DO.DATE_INTST_CALC_TO = IIF(TRY_CONVERT(DATE, 
                                                :DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) <> 0) OR (LEN(:DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) <> 10), CIS.CHAR2DATE(:DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ), CONVERT(DATE, :DO-DATE-INTST-CALC-TO 
                                              :WS-DATE-INTST-CALC-TO-NI
              ) ), 
                     DO.INTRST_YTD         = :DO-INTRST-YTD,            
                     DO.TOTAL_INTRST       = :DO-TOTAL-INTRST,          
                     DO.DATE_TRAN          = IIF(TRY_CONVERT(DATE, 
                                                          :DO-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-TRAN
              ) <> 0) OR (LEN(:DO-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :DO-DATE-TRAN
              ), CONVERT(DATE, :DO-DATE-TRAN) ),             
                     DO.DATE_REFUNDED      = IIF(TRY_CONVERT(DATE, 
                                                     :DO-DATE-REFUNDED 
                                                     :WS-DATE-REFUND-NI
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-REFUNDED 
                                                     :WS-DATE-REFUND-NI
              ) <> 0) OR (LEN(:DO-DATE-REFUNDED :WS-DATE-REFUND-NI
              ) <> 10), CIS.CHAR2DATE(:DO-DATE-REFUNDED 
                                                     :WS-DATE-REFUND-NI
              ), CONVERT(DATE, :DO-DATE-REFUNDED :WS-DATE-REFUND-NI) ),        
                     DO.DEPOSIT_STATUS_CD  = :DO-DEPOSIT-STATUS-CD,     
                     DO.AMT_REFUNDED       = :WS-AMT-REFUNDED,          
                     DO.AMT_DEPOSIT        = :WS-AMT-DEPOSIT            
              FROM CSS_DEP_ON_HAND DO
               WHERE DO.ACCOUNT_NO         = :DO-ACCOUNT-NO             
                 AND DO.DEPOSIT_CERT_NO    = :DO-DEPOSIT-CERT-NO        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_DEP_ON_HAND DO                                         
MFA-TR*          SET DO.CODE_REFUND_ELIG   = :DO-CODE-REFUND-ELIG,              
MFA-TR*              DO.DATE_INTST_CALC_TO = :DO-DATE-INTST-CALC-TO:            
MFA-TR*                                       WS-DATE-INTST-CALC-TO-NI,         
MFA-TR*              DO.INTRST_YTD         = :DO-INTRST-YTD,                    
MFA-TR*              DO.TOTAL_INTRST       = :DO-TOTAL-INTRST,                  
MFA-TR*              DO.DATE_TRAN          = :DO-DATE-TRAN,                     
MFA-TR*              DO.DATE_REFUNDED      = :DO-DATE-REFUNDED:                 
MFA-TR*                                       WS-DATE-REFUND-NI,                
MFA-TR*              DO.DEPOSIT_STATUS_CD  = :DO-DEPOSIT-STATUS-CD,             
MFA-TR*              DO.AMT_REFUNDED       = :WS-AMT-REFUNDED,                  
MFA-TR*              DO.AMT_DEPOSIT        = :WS-AMT-DEPOSIT                    
MFA-TR*        WHERE DO.ACCOUNT_NO         = :DO-ACCOUNT-NO                     
MFA-TR*          AND DO.DEPOSIT_CERT_NO    = :DO-DEPOSIT-CERT-NO                
MFA-TR*        QUERYNO 8710                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE  = SUCCESSFUL-CALL                                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 8710-UPDATE-DEP**'                 
              DISPLAY '**   ACCOUNT NO      = ' DO-ACCOUNT-NO           
              DISPLAY '**   DEPOSIT CERT NO = ' DO-DEPOSIT-CERT-NO      
              DISPLAY '**   SQLCODE         = ' WS-DISPLAY-SQLCODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8800-DELETE-AR-CNTL                                            *        
      ******************************************************************        
      *                                                                         
       8800-DELETE-AR-CNTL.                                             
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM AC                                 
              FROM CSS_AR_CNTL AC
               WHERE AC.ACCOUNT_NO        = :AT-ACCOUNT-NO              
                 AND AC.ITEM_ID           = :DO-DEPOSIT-CERT-NO         
                 AND AC.PYMT_PRIORITY_LVL = 80                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_AR_CNTL AC                                        
MFA-TR*        WHERE AC.ACCOUNT_NO        = :AT-ACCOUNT-NO                      
MFA-TR*          AND AC.ITEM_ID           = :DO-DEPOSIT-CERT-NO                 
MFA-TR*          AND AC.PYMT_PRIORITY_LVL = 80                                  
MFA-TR*        QUERYNO 8800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**   ERROR ON 8800-DELETE-AR-CNTL    **'         
              DISPLAY '**   ACCOUNT  NO     = ' AT-ACCOUNT-NO           
              DISPLAY '**   DEPOSIT CERT NO = ' DO-DEPOSIT-CERT-NO      
              DISPLAY '**   SQLCODE         = ' WS-DISPLAY-SQLCODE      
              DISPLAY '**       PROCESSING TERMINATED       **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8810-WRITE-RESTART                                             *        
      ******************************************************************        
      *                                                                         
       8810-WRITE-RESTART.                                              
      *                                                                         
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
                                                                        
           PERFORM 8820-UPDATE-RESTART      THRU 8820-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8830-INSERT-RESTART   THRU 8830-EXIT              
           END-IF.                                                      
      *                                                                         
       8810-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8820-UPDATE-RESTART                                            *        
      ******************************************************************        
      *                                                                         
       8820-UPDATE-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE RF                                     
                  SET RF.RESTART_DATA = :RF-RESTART-DATA                
               FROM CSS_RESTART RF
                WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                
                  AND RF.PARTITION_NO = :RF-PARTITION-NO                
                  AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_RESTART RF                                            
MFA-TR*           SET RF.RESTART_DATA = :RF-RESTART-DATA                        
MFA-TR*         WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                        
MFA-TR*           AND RF.PARTITION_NO = :RF-PARTITION-NO                        
MFA-TR*           AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                        
MFA-TR*        QUERYNO 8820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**  ERROR ON 8820-UPDATE-RESTART     **'         
              DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM             
              DISPLAY '**  SQLCODE      = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**      PROCESSING TERMINATED        **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8830-INSERT-RESTART                                            *        
      ******************************************************************        
      *                                                                         
       8830-INSERT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                          (NAME_PROGRAM                                 
                          ,PARTITION_NO                                 
                          ,DUP_CNTRL_NO                                 
                          ,RESTART_DATA)                                
               VALUES    (:RF-NAME-PROGRAM                              
                         ,:RF-PARTITION-NO                              
                         ,:RF-DUP-CNTRL-NO                              
                         ,:RF-RESTART-DATA)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE  = SUCCESSFUL-CALL                                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**   ERROR ON 8830-INSERT-RESTART    **'         
              DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED       **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8830-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42471600
      ******************************************************************        
      * 8850-DEL-RESTART-REC.                                          *        
      ******************************************************************        
      *                                                                         
       8850-DEL-RESTART-REC.                                            
      *                                                                         
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM RF                                 
              FROM CSS_RESTART RF
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_RESTART RF                                        
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                         
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                         
MFA-TR*        QUERYNO 8850                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**  ERROR ON 8850-DEL-RESTART-REC'               
              DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM             
              DISPLAY '**  SQLCODE      = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED         '         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8888-COMMIT.                                                     
      *                                                                         
           PERFORM 2800-PRE-COMMIT          THRU 2800-EXIT              
           PERFORM 8810-WRITE-RESTART       THRU 8810-EXIT              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '*******************************************'        
           DISPLAY '*COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.**'        
           DISPLAY '*LAST REC PROCESSED  = ' AT-ACCOUNT-NO              
           DISPLAY '*******************************************'.       
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8889-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8889-COMMIT.                                                     
      *                                                                         
           MOVE WS-FCSDB07-REC-CNTR         TO WS-DB07-REC-CNTR         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '*******************************************'        
           DISPLAY '*TOT NO. OF DB07 RECORDS PROCESSED:'WS-DB07-REC-CNTR
           DISPLAY '*******************************************'.       
      *                                                                         
       8889-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00399******************************************************************        
P00399* 8900-WRITE-FCA347.                                             *        
P00399******************************************************************        
P00399*                                                                         
P00399 8900-WRITE-FCA347.                                               
P00399*                                                                         
P00399     WRITE FIOCA347.                                              
P00399*                                                                         
P00399     IF  FCA347-SUCCESSFUL                                        
P00399         ADD 1                   TO WS-FCA347-REC-COUNT           
P00399         INITIALIZE                 FIOCA347                      
P00399     ELSE                                                         
P00399        DISPLAY '*********************************'               
P00399        DISPLAY '** 8900-WRITE-FCA347           '                 
P00399        DISPLAY '** ERROR ON WRITING FCA347 FILE. '               
P00399        DISPLAY '** STATUS IS ' WS-FCA347-STATUS                  
P00399        DISPLAY '*********************************'               
P00399        PERFORM 9900-ABEND            THRU 9900-EXIT              
P00399     END-IF.                                                      
P00399*                                                                         
P00399 8900-EXIT.                                                       
P00399     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK               *        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ******************************************************************        
      *  CLOSES  THE INPUT  FILE                                       *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
P00399     IF CSR-DATABASE                                              
P00399        PERFORM 5720-WRITE-END-CONTROLS                           
P00399                                      THRU 5720-EXIT              
P00399     END-IF.                                                      
      *                                                                         
           CLOSE FCSCA347-FILE.                                         
      *                                                                         
           CLOSE FCSDB07-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK  CPD00067     *        
      ******************************************************************        
      *                                                                         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           MOVE '9900'                      TO ACTIVE-PARAGRAPH.        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE,   
                                               RS-RETURN-CODE,          
                                               WS-DISPLAY-SQLCODE.      
           DISPLAY ' '                                                  
           DISPLAY '**********************************************'     
           DISPLAY '***** 9900-SQL-ERROR-ROUTINE            ******'     
           DISPLAY '**********************************************'     
           DISPLAY ' '                                                  
ACT002     DISPLAY 'ACCT NO           = ' AT-ACCOUNT-NO                 
ACT002     DISPLAY 'ACTIVE-PARAGRAPH  = ' ACTIVE-PARAGRAPH              
ACT002     DISPLAY 'ABEND FUNCTION    = ' ABEND-FUNCTION                
ACT002     DISPLAY 'TABLE-1           = ' TABLE-1                       
ACT002     DISPLAY 'TABLE-ELEMENT-1   = ' TABLE-ELEMENT-1               
ACT002     DISPLAY 'HOSTVAR-ELEMENT-1 = ' HOSTVAR-ELEMENT-1             
ACT002     DISPLAY 'TABLE-ELEMENT-2   = ' TABLE-ELEMENT-2               
ACT002     DISPLAY 'HOSTVAR-ELEMENT-2 = ' HOSTVAR-ELEMENT-2             
ACT002     DISPLAY 'TABLE-ELEMENT-3   = ' TABLE-ELEMENT-3               
ACT002     DISPLAY 'HOSTVAR-ELEMENT-3 = ' HOSTVAR-ELEMENT-3             
ACT002     DISPLAY 'TABLE-ELEMENT-4   = ' TABLE-ELEMENT-4               
ACT002     DISPLAY 'HOSTVAR-ELEMENT-4 = ' HOSTVAR-ELEMENT-4             
           DISPLAY 'SQLCODE = ' WS-DISPLAY-SQLCODE                      
           DISPLAY '**********************************************'     
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                         
      ******************************************************************        
      * 5500-CHECK-NON-UTIL.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00312                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 5995-DEPOSIT-INTEREST-CALC.                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00023                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6050-PROCESS-INTEREST-HIST.                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00128                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6100-COMPUTE-REBATE-AMOUNT.                                    *        
      *  COMPUTE REBATE AMOUNT                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0003B                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  6253-GET-FJC01-CHKP-LIMIT.                                   *        
      ******************************************************************        
      *                                                                         
           COPY CPD00034.                                                       
      *                                                                         
      ******************************************************************        
      **  6240-GET-FCA00-COMMON-DATE.                                  *        
      ******************************************************************        
      *                                                                         
           COPY CPD00040.                                                       
      *                                                                         
      ******************************************************************        
      *  6251-GET-FJC01-DATE.                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
      *                                                                         
       6400-ONLINE-JRNL-ROUTINE.                                        
           GO TO 6400-BATCH-JRNL-ROUTINE.                               
HPCCDM*EJECT                                                                    
      ******************************************************************        
      * 6400-BATCH-JRNL-ROUTINE.                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00007                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6500-ONLINE-LOAD-AR-TRAN-HIST.                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00008                                                 
           END-EXEC.                                                            
      *                                                                         
P00399******************************************************************        
P00399* 6565-PROCESS-CREDIT-RULE.                                      *        
P00399******************************************************************        
P00399*                                                                         
P00399     EXEC SQL                                                             
P00399         INCLUDE CPD00334                                                 
P00399     END-EXEC.                                                            
P00399*                                                                         
      ******************************************************************        
      * 6700-APPLY-PAYMENT.                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00010                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0010S                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7600-START-FCSJC01.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7620-START-FCSCA00.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  9700-PROCESS-ABEND                                            *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  9900-ABEND.                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
