       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA096.                                        
       DATE-WRITTEN.   OCT 2010.                                        
      ***************************************************************** 00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                * 00000501
      **                                                              * 00000601
      ********            CUSTOMER SERVICE SYSTEM             ********* 00000701
      ********                      DB2                       ********* 00000801
      **                                                              * 00000601
      *****************************************************************         
      **-------------- P R O G R A M  S U M M A R Y -----------------**         
      *****************************************************************         
      **   THIS PROGRAM INSERTS A ROW INTO CSS_PREPAY_HIST TABLE     **         
      **   FOR ALL SEB PRE-PAY PLAN USTOMERS FROM DB07 FILE.         **         
      *****************************************************************         
      **------------- PROGRAM  MODIFICATION  LOG --------------------**         
      *****************************************************************         
      **      PCSCA096   PROGRAM  MODIFICATION  LOG                  **         
      **                                                             **         
      **    DATE    INITIALS  REASON                                 **         
      **   _______  ________  ______                                 **         
P00453**   11/1/10  SP95538   PROCEDURE ORIGINALLY CODED.            **         
P00453**   08/30/11 SP95538   MOVE CANCEL/REBILL TO REMARKS COLUMN   **         
P00453**                      WHEN OFF-CYCLE-BILL-CODE = 'O'         **         
P00453**   12/19/11 GOKUL     COMPUTE CORRECT YEAR FOR JANUARY       **         
P00453**                      ESTIMATIONS.                           **         
ACT027**   03/22/12 VENKAT.P  USE ACTUAL REV MTH ACCT IS BILLING FOR **         
ACT072**   07/18/12 bd09555   make sure bg-revenue-month is          **         
ACT072**   A03967             populated for paragraph 7360           **         
      *****************************************************************         
      **----------------- BASIC SEQUENCE STRUCTURE ------------------**         
      *****************************************************************         
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION**         
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH       **         
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH      **         
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED **         
      **         5000 - 5999     COMMON PROGRAM MODULES              **         
      **         6000 - 6999     COMMON SYSTEM MODULES               **         
      **         7000 - 7999     INPUT MODULES                       **         
      **         8000 - 8999     OUTPUT MODULES                      **         
      **         9000 - 9799     TERMINATION MODULES                 **         
      **         9900 - 9999     ABEND/ABORT MODULES                 **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSDB07.                                                            
      *                                                                 00573020
       DATA DIVISION.                                                   
      *                                                                 00574020
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
      *                                                                 00540000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA096'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                         PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA096 STARTS HERE'.            
      *                                                                         
       01 WS-CONSTANTS.                                                 
          05 WS-PGRMNAME                   PIC X(08)  VALUE 'PCSCA096'. 
          05 PROGRAM-NAME                  PIC X(08)  VALUE 'PCSCA096'. 
          05 SCSCB063                      PIC X(08)  VALUE 'SCSCB063'. 
          05 WS-Y                          PIC X(01)  VALUE 'Y'.        
          05 WS-N                          PIC X(01)  VALUE 'N'.        
      *                                                                         
       01 WS-RESTART-MISC.                                              
          05 WS-RESTART-DATA-LENGTH        PIC S9(04) COMP VALUE +42.   
          05 WS-IS-THIS-A-RESTART          PIC X(01)  VALUE 'N'.        
             88 WS-THIS-IS-A-RESTART                  VALUE 'Y'.        
             88 WS-THIS-IS-NOT-A-RESTART              VALUE 'N'.        
          05 WS-COMMIT-COUNTER             PIC 9(04)  VALUE ZERO.       
          05 WS-DEFAULT-CHKP-LUW-LIMIT     PIC 9(04)  VALUE 100.        
          05 WS-SEQ-NO                     PIC 9(04)  VALUE ZERO.       
          05 WS-CHKP-LUW-LIMIT             PIC 9(04)  VALUE ZERO.       
          05 WS-CHKP-LUW-COUNTER           PIC 9(04)  VALUE ZERO COMP-3.
          05 WS-DEFAULT-CHKP-UPD-LIMIT     PIC 9(04)  VALUE 100.        
          05 WS-CHKP-UPD-LIMIT             PIC 9(04)  VALUE ZERO.       
          05 WS-CHKP-UPD-COUNTER           PIC 9(04)  VALUE ZERO COMP-3.
          05 WS-CHKP-SEQ-NO                PIC 9(05)  VALUE ZERO.       
          05 WS-FCSDB07-REC-CNTR           PIC S9(07) VALUE ZERO COMP-3.
          05 WS-FCSDB07-RESTART-CNTR       PIC S9(07) VALUE ZERO COMP-3.
      *                                                                         
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-PROCESS-TYPE       PIC 9(01).                   
          05 WS-RESTART-JOB-COMPLETE   REDEFINES                        
             WS-RESTART-PROCESS-TYPE       PIC X(01).                   
          05 WS-RESTART-JOB-STATUS         PIC X(01).                   
             88 WS-RUN-COMPLETED-NO-PROBLEMS        VALUE 'A'.          
             88 WS-RERUN-COMPLETED                  VALUE 'B'.          
             88 WS-RERUN-PENDING                    VALUE 'C'.          
          05 WS-RESTART-COMMON-DATE        PIC X(10).                   
          05 WS-RESTART-CHKP-SEQ-NO        PIC 9(05).                   
          05 WS-RESTART-ACCOUNT-NO         PIC X(13)  VALUE SPACES.     
          05 WS-RESTART-FCSDB07-REC-CNTR   PIC S9(07) COMP-3 VALUE ZERO.
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-CURRENT-TIMESTAMP          PIC X(26) VALUE SPACES.      
          05 WS-COMMON-DATE                PIC X(10) VALUE SPACES.      
          05 WS-CURRENT-ACCT-NO            PIC S9(13) COMP-3 VALUE 0.   
          05 WS-PREV-ACCOUNT-NO            PIC S9(13) COMP-3 VALUE 0.   
          05 WS-BN-COUNT                   PIC S9(04) COMP VALUE 0.     
          05 WS-BILL-COUNT                 PIC S9(04) COMP VALUE 0.     
          05 WS-NO-UNITS                   PIC S9(9)V COMP-3 VALUE 0.   
          05 WS-NO-DAYS                    PIC S9(4) USAGE COMP         
                                                        VALUE ZERO.     
          05 WS-DB07-REC-CNTR              PIC Z9(06)9 VALUE ZERO.      
          05 WS-DISPLAY-SQLCODE            PIC -Z(8)9 VALUE ZERO.       
          05 RS-RETURN-CODE-DISP           PIC S9(04) VALUE ZERO.       
          05 RS-RETURN-CODE                PIC S9(4) COMP VALUE ZERO.   
          05 S-RETURN-CODE                 PIC S9(9) COMP VALUE 0.      
          05 WS-REVENUE-MONTH              PIC 9(06) VALUE ZERO.        
          05 WS-REV-MONTH-P                PIC 9(06) VALUE ZERO.        
          05 WS-REVENUE-MTH.                                            
             10 WS-REV-YR                  PIC 9(04) VALUE ZERO.        
             10 WS-REV-MTH                 PIC 9(02) VALUE ZERO.        
          05 WS-PRP-EXEMPT                 PIC X(01) VALUE SPACE.       
COB305    05 WS-REV-MNTH-OLDEST        PIC S9(06)V COMP-3 VALUE 0.         
COB305    05 WS-REV-MNTH-PREV        PIC S9(06)V COMP-3 VALUE 0.         
ACT027    05 WS-REV-MNTH-CUR               PIC 9(06) VALUE ZEROS.       
ACT027    05 WS-BIL-CYCLE                  PIC X(02) VALUE ZEROS.       
ACT027    05 WS-INDEX                      PIC 9(02) VALUE ZERO.        
                                                                        
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 WS-NO-MORE-DATA               PIC X(01)  VALUE 'N'.        
             88 NO-MORE-DATA                          VALUE 'Y'.        
          05 WS-FDB07-STATUS               PIC X(02).                   
             88 FDB07-SUCCESSFUL                      VALUE '00'.       
          05 WS-END-OF-FILE                PIC X(01)  VALUE 'N'.        
             88 END-OF-FILE                           VALUE 'Y'.        
          05 WS-RECORD-FOUND               PIC X(01)  VALUE 'N'.        
             88 DATA-RECORD-FOUND                     VALUE 'Y'.        
             88 NO-DATA-RECORD-FOUND                  VALUE 'N'.        
          05 WS-BEGIN-REC-SW               PIC X(01)  VALUE 'N'.        
             88 WS-BEGIN-RECS-PROCESSED               VALUE 'Y'.        
ACT027*                                                                         
ACT027    05 WS-REV-MNTH-FOUND-SW          PIC X(01).                   
ACT027       88 REV-MNTH-FOUND                        VALUE 'Y'.        
ACT027       88 REV-MNTH-NOT-FOUND                    VALUE 'N'.        
      *                                                                         
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CPD04391                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS04391                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * COMMON COPYBOOK FOR WS-VARIABLES                               *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      * ABEND SWITCH COPYBOOK                                          *        
      ******************************************************************        
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE FOR CODES-DATA-PRESENT                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00056.                                                       
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOK FOR SCSCB063                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00063                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************07910200
      *   WORKING STORAGE AREA FOR RESTART-REQUEST PARM                *07910300
      ******************************************************************07910400
      *                                                                 07910500
           COPY CWS00038.                                               07910600
      *                                                                 07910700
      ******************************************************************07870000
      *  WORKING STORAGE AREA FOR COMMON DATES                         *07880000
      ******************************************************************07890000
      *                                                                 07900000
           COPY CWS00039.                                               07910000
      *                                                                 07910100
      ******************************************************************07870000
      * FIOJC01 WORKING STORAGE                                        *07880000
      ******************************************************************07890000
      *                                                                 07900000
           COPY FIOJC01.                                                07910000
      *                                                                 07910100
      ******************************************************************06330000
      * FCA00-KEY                                                      *06340000
      ******************************************************************06350000
      *                                                                 06360000
           COPY FIOCA00.                                                06370000
      *                                                                 06391000
      ******************************************************************06330000
      *    SQL COMMUNICATIONS AREA                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ACCOUNT - AT                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ACCT_RTPK_AGR - DF                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ADDR_FORMATTED - DY                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ADDR_FREEFORM - DZ                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_BILLING_DET - BG                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBLLDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CNSMPTN_NONCIS - PX                                     *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBCNSMPN                                                 
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************        
      *    CSS_CNSMPTN_HIST - CX                                       *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBCNSMP                                                  
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************06330000
      *    CSS_DELINQUENCY - C8                                        *06340000
      ******************************************************************06350000
                                                                        
           EXEC SQL                                                     06370000
               INCLUDE TBDELQ                                           06380000
           END-EXEC.                                                    06390000
      *                                                                         
      ******************************************************************        
      *    CSS_FIXED_FCTR - FF                                         *        
      ******************************************************************        
      *                                                                 04094000
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
      *                                                                 04094000
      ******************************************************************06330000
      *    CSS_JOB_PARM - G6                                           *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_LOCAL_OFFICE - B1                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBLOCOFC                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_PREPAY_HIST - PK                                        *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREHST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_PREMISE - PR                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_RESTART - RF                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR - SF                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_SPCL_FCTR_APPL - SA                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSPLAPL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_TAX_RATE - TR                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     03250000
               INCLUDE TBTXRATE                                         03260000
           END-EXEC.                                                    03270000
      *                                                                         
      ******************************************************************06330000
      *    CSS_UTIL_ENVRNMT - UT                                       *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ZIPCODE_LO_RT - ZT                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBZIPRTE                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_ACCT-ATTRIBUTE - YP                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-END                           PIC X(40) VALUE              
           'WORKING STORAGE FOR PCSCA096 ENDS HERE  '.                  
      *                                                                         
       PROCEDURE DIVISION .                                             
      *                                                                         
      ******************************************************************        
      *  0000-MAINLINE                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
      *                                                                         
           PERFORM 1000-MAIN-PROCESS            THRU 1000-EXIT          
                                                UNTIL END-OF-FILE.      
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                     TO WS-RESTART-JOB-STATUS    
              DISPLAY 'PCSCA096 RERUN COMPLETED'                        
           ELSE                                                         
              MOVE WS-A                     TO WS-RESTART-JOB-STATUS    
                                                                        
              DISPLAY 'PCSCA096 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8850-DEL-RESTART-REC         THRU 8850-EXIT.         
           PERFORM 8889-COMMIT                  THRU 8889-EXIT.         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06150000
      *  0100-INITIALIZE                                               *06160000
      ******************************************************************06230000
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                 06250000
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
      *                                                                 06250000
           INITIALIZE WS-SYSIPT                                         
                      DCLCSS-PREPAY-HIST.                               
           PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT.         
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE            
           END-IF.                                                      
           MOVE WS-INPUT-DATE               TO WS-COMMON-DATE.          
      *                                                                         
           OPEN INPUT FCSDB07-FILE.                                     
           IF FDB07-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************'               
              DISPLAY '** 0100-INITIALIZE               '               
              DISPLAY '** ERROR ON OPENING FCSDB07 FILE.'               
              DISPLAY '** STATUS IS ', WS-FDB07-STATUS                  
              DISPLAY '*********************************'               
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 04680000
           PERFORM 0200-CHECK-RESTART       THRU 0200-EXIT.             
           PERFORM 0300-PREPARE-RESTART     THRU 0300-EXIT.             
           IF WS-THIS-IS-NOT-A-RESTART                                  
              PERFORM 0500-PROCESS-BEGIN-REC    THRU 0500-EXIT          
                 UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES            
           END-IF.                                                      
           PERFORM 7020-ACCEPT-TIMESTAMP    THRU 7020-EXIT.             
ACT027*    Load Current Bill Cycles From CSS_JOB_PARM                   10220000
ACT027     PERFORM 6241-GET-FCA00-BILL-CYCLES  THRU 6241-EXIT .         
      *                                                                 04680000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-CHECK-RESTART.                                            *        
      ******************************************************************        
      *                                                                         
       0200-CHECK-RESTART.                                              
      *                                                                         
            MOVE WS-PGRMNAME                TO RF-NAME-PROGRAM.         
            MOVE 1                          TO RF-PARTITION-NO.         
            MOVE 1                          TO RF-DUP-CNTRL-NO.         
      *                                                                         
            PERFORM 7160-SELECT-RESTART         THRU 7160-EXIT.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE RF-RESTART-DATA-TEXT    TO WS-RESTART-DATA          
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                 TO WS-IS-THIS-A-RESTART     
               END-IF                                                   
            ELSE                                                        
               GO TO 0200-EXIT                                          
            END-IF.                                                     
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  0300-PREPARE-RESTART                                          *        
      ******************************************************************        
      *                                                                         
       0300-PREPARE-RESTART.                                            
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '*******************************************'     
              DISPLAY '**   THIS IS A RESTART OF PCSCA096       **'     
              DISPLAY '*LAST PROCESSED ACCOUNT # 'WS-RESTART-ACCOUNT-NO 
              DISPLAY '*CONTINUING FROM COMMIT # 'WS-RESTART-CHKP-SEQ-NO
              DISPLAY '*******************************************'     
              MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO           
              PERFORM 7050-READ-FCSDB07         THRU 7050-EXIT          
                 UNTIL WS-FCSDB07-REC-CNTR =  WS-FCSDB07-RESTART-CNTR   
              MOVE E-FDB07-COMPANY-NO       TO C8-COMPANY-NO            
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      *   THIS PARAGRAPH DOES AN INITIAL READ TO THE DB07 FILE AND     *        
      *   CHECKS FOR A BEGINNING RECORD. WHEN FOUND THE DATE ON        *        
      *   THE BEGIN RECORD IS COMPARED TO THE RUN DATE OBTAINED        *        
      *   FROM THE JOBS TABLE TO ENSURE WE ARE PROCESSING WITH         *        
      *   THE CORRECT FILE.                                            *        
      ******************************************************************        
      *                                                                         
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7050-READ-FCSDB07            THRU 7050-EXIT.         
      *                                                                         
           EVALUATE TRUE                                                
               WHEN END-OF-FILE                                         
                    DISPLAY '********************************'          
                    DISPLAY '**    PCSCA096 PROCESSING ERROR '          
                    DISPLAY '**      FCSDB07 FILE IS EMPTY   '          
                    DISPLAY '**      PROCESSING TERMINATED   '          
                    DISPLAY '********************************'          
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
               WHEN E-FDB07-KEY-BREC = LOW-VALUES                       
                    IF E-FDB07-CREATE-DATE-BREC NOT = WS-INPUT-DATE     
                       DISPLAY '**********************************'     
                       DISPLAY '**     PCSCA096 PROCESSING ERROR  '     
                       DISPLAY '** FCSDB07 CREATE DATE NOT = RUN DATE ' 
                       DISPLAY '**       PROCESSING TERMINATED    '     
                       DISPLAY '**********************************'     
                       PERFORM 9900-ABEND       THRU 9900-EXIT          
                    END-IF                                              
                    SET WS-BEGIN-RECS-PROCESSED TO TRUE                 
               WHEN WS-BEGIN-RECS-PROCESSED                             
                    IF E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES     
                       IF E-FDB07-KEY-BREC = HIGH-VALUES AND            
                          NO-DATA-RECORD-FOUND AND                      
                          E-FDB07-RECORD-COUNT-EREC EQUAL ZERO          
                          DISPLAY '********************************'    
                          DISPLAY '**    PCSCA096 PROCESSING ERROR '    
                          DISPLAY '**      FCSDB07 FILE IS EMPTY   '    
                          DISPLAY '**      PROCESSING TERMINATED   '    
                          DISPLAY '********************************'    
                          PERFORM 9900-ABEND    THRU 9900-EXIT          
                       ELSE                                             
                          CONTINUE                                      
                       END-IF                                           
                    ELSE                                                
                       SET DATA-RECORD-FOUND   TO TRUE                  
                       MOVE E-FDB07-COMPANY-NO TO C8-COMPANY-NO         
                    END-IF                                              
               WHEN OTHER                                               
                    DISPLAY '**********************************'        
                    DISPLAY '**    PCSCA096 PROCESSING ERROR   '        
                    DISPLAY '** FIRST RECORD IS NOT A CNTL REC '        
                    DISPLAY '**      PROCESSING TERMINATED     '        
                    DISPLAY '**********************************'        
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-MAIN-PROCESS.                                             *        
      ******************************************************************        
      *                                                                         
       1000-MAIN-PROCESS.                                               
      *                                                                         
           IF (E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES) OR         
              (E-FDB07-OFF-CYCLE-BILL-CODE NOT EQUAL SPACES AND         
               E-FDB07-OFF-CYCLE-BILL-CODE NOT EQUAL 'O' AND            
               E-FDB07-OFF-CYCLE-BILL-CODE NOT EQUAL 'P')               
              CONTINUE                                                  
           ELSE                                                         
              MOVE E-FDB07-ACCT-NO          TO WS-CURRENT-ACCT-NO       
              IF WS-CURRENT-ACCT-NO NOT EQUAL WS-PREV-ACCOUNT-NO        
                 PERFORM 2000-OUTPUT-PROCESS    THRU 2000-EXIT          
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           PERFORM 7050-READ-FCSDB07            THRU 7050-EXIT          
      *                                                                         
           IF WS-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR                  
              WS-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT                     
              PERFORM 8888-COMMIT               THRU 8888-EXIT          
              MOVE ZEROES                   TO WS-COMMIT-COUNTER        
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-OUTPUT-PROCESS.                                           *        
      ******************************************************************        
      *                                                                         
       2000-OUTPUT-PROCESS.                                             
      *                                                                         
           MOVE E-FDB07-ACCT-NO             TO AT-ACCOUNT-NO            
                                               BG-ACCOUNT-NO            
                                               PX-ACCOUNT-NO            
                                               FF-ACCOUNT-NO            
                                               DF-ACCOUNT-NO            
                                               PK-ACCOUNT-NO            
                                               YP-ACCOUNT-NO            
                                               WS-PREV-ACCOUNT-NO.      
      *                                                                         
           PERFORM 7010-GET-ACCT-DTLS       THRU 7010-EXIT.             
           MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT.   
           MOVE AT-PREMISE-NO               TO PR-PREMISE-NO            
      *Get the revenue month based on bill cycle & common date                  
ACT027     MOVE  AT-BILL-CYCLE        TO WS-BIL-CYCLE.                  
ACT027     SET WS-BILL-CYC-INDX       TO 1.                             
ACT027     SEARCH WS-FCA00-BILLING-CYCLES                               
ACT027         AT END                                                   
ACT027            SET REV-MNTH-NOT-FOUND TO TRUE                        
ACT027       WHEN WS-FCA00-BLCYC-NUMBER (WS-BILL-CYC-INDX) EQUAL        
ACT027            WS-BIL-CYCLE                                          
ACT027            MOVE WS-FCA00-REV-MONTH (WS-BILL-CYC-INDX) TO         
ACT027                 WS-REV-MNTH-CUR                                  
ACT027            SET REV-MNTH-FOUND    TO TRUE                         
ACT027     END-SEARCH.                                                  
ACT027*                                                                 24400000
ACT027     IF REV-MNTH-NOT-FOUND                                        
ACT027        MOVE ZEROES              TO WS-REV-MNTH-PREV              
ACT027                                    WS-REV-MNTH-OLDEST            
ACT027        MOVE 1                   TO WS-INDEX                      
ACT027        PERFORM 4525-GET-OLDEST-REV-MONTH THRU 4525-EXIT          
ACT027          UNTIL WS-FCA00-BLCYC-NUMBER(WS-INDEX) = '00'            
ACT027             OR WS-INDEX >= 8                                     
ACT027        MOVE WS-REV-MNTH-OLDEST TO WS-REV-MNTH-CUR                
ACT027     END-IF.                                                      
      *                                                                         
           MOVE WS-REV-MNTH-CUR             TO WS-REVENUE-MONTH         
                                               WS-REVENUE-MTH           
                                               PK-REVENUE-MONTH.        
      *                                                                         
           IF WS-CODE-PRE-PAY-PLAN = 'A'                                
              EVALUATE E-FDB07-OFF-CYCLE-BILL-CODE                      
                  WHEN SPACES                                           
                       PERFORM 7170-SELECT-ZIP-CD    THRU 7170-EXIT     
                       IF SQLCODE = NOT-FOUND                           
                          PERFORM 7180-SELECT-ADDR-ZIP-CD               
                                                     THRU 7180-EXIT     
                          MOVE DZ-ADDR-ZIP-CODE(1:5)                    
                                                  TO WS-ZIP-CD          
                       ELSE                                             
                          MOVE DY-ZIP-CODE        TO WS-ZIP-CD          
                       END-IF                                           
                       COMPUTE WS-REV-MTH         = WS-REV-MTH + 1      
                       IF WS-REV-MTH > 12                               
                          MOVE 1                  TO WS-REV-MTH         
P00453                 ELSE                                             
P00453                    COMPUTE WS-REV-YR       = WS-REV-YR - 1       
P00453                 END-IF                                           
                       MOVE WS-REVENUE-MTH        TO WS-REV-MONTH-P     
                       MOVE WS-REV-MONTH-P        TO PX-REVENUE-MONTH   
ACT072                                               BG-REVENUE-MONTH   
                       PERFORM 7205-CHECK-BILL-COUNT THRU 7205-EXIT     
                       IF WS-BILL-COUNT < 12                            
                          PERFORM 7260-GET-CNSMPTN-UNIT                 
                                                     THRU 7260-EXIT     
                          MOVE WS-NO-DAYS         TO WS-CNSMPTN-NO-DAYS 
                          MOVE WS-NO-UNITS        TO WS-ESTMT-CONSUMPT  
                       ELSE                                             
                          PERFORM 7360-CHECK-CNSMPTN-HIST               
                                                     THRU 7360-EXIT     
                          MOVE CX-NO-DAYS         TO WS-CNSMPTN-NO-DAYS 
                          MOVE CX-NO-UNITS        TO WS-ESTMT-CONSUMPT  
                       END-IF                                           
                       PERFORM 7310-GET-DDC-FACTOR   THRU 7310-EXIT     
                       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                          MOVE ZERO               TO WS-DDDC            
                       ELSE                                             
                          MOVE FF-FACTOR          TO WS-DDDC            
                       END-IF                                           
                       MOVE WS-REVENUE-MONTH      TO WS-REV-MONTH-C     
                       PERFORM 2100-CALL-SCSCB063    THRU 2100-EXIT     
                       PERFORM 6000-PRP-ESTIMATE     THRU 6000-EXIT     
                       PERFORM 2200-PROCESS-PREPAY   THRU 2200-EXIT     
                  WHEN 'P'                                              
                      PERFORM 7500-CHECK-PRP-EXEMPT  THRU 7500-EXIT     
                      IF WS-PRP-EXEMPT  = 'Y'                           
                         MOVE '1'             TO AT-NOTICE-EXEMPT-CD    
                                                 AT-CODE-DISC-OK        
                         PERFORM 8300-UPDATE-PRP-EXEMPT                 
                                                     THRU 8300-EXIT     
                         PERFORM 8400-DELETE-PRP-ACCT-ATTR              
                                                     THRU 8400-EXIT     
                         MOVE SPACES          TO WS-PRP-EXEMPT          
                      END-IF                                            
      * Update Rev Mnth from estimated to current billing Rev Mnth              
ACT027                MOVE WS-REV-MNTH-CUR    TO PK-REVENUE-MONTH       
                      PERFORM 8500-UPDATE-REV-MNTH    THRU 8500-EXIT    
                  WHEN 'O'                                              
                      PERFORM 7450-GET-MAX-ROW        THRU 7450-EXIT    
P00453                MOVE 'Cancel/Rebill'    TO PK-REMARKS-TEXT        
                      MOVE ZEROES             TO PK-EST-CONNECT-CHG-AM  
                                                 PK-NET-BILL-ADJ-AM     
                                                 PK-ARREARS-AMT         
                                                 PK-BILLED-AMT          
                                                 PK-PLAN-ACCT-BAL-AM    
                                                 PK-BILL-VARIANCE-AM    
P00453                MOVE LENGTH OF PK-REMARKS-TEXT                    
P00453                                         TO PK-REMARKS-LEN        
                      MOVE WS-CURRENT-TIMESTAMP                         
                                              TO PK-PREPAY-HIST-SEQ-TS  
                      PERFORM 8100-INSERT-PREPAY-HIST THRU 8100-EXIT    
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-CALL-SCSCB063.                                            *        
      ******************************************************************        
      *                                                                         
       2100-CALL-SCSCB063.                                              
      *                                                                         
           PERFORM 7400-GET-OPTION-CD           THRU 7400-EXIT          
           MOVE PROGRAM-NAME                TO WS-CPD063-CALLING-PGM.   
           MOVE SPACES                      TO ABEND-FUNCTION.          
           MOVE DF-OPTION-CD                TO WS-OPTION-CD.            
           MOVE AT-ACCOUNT-NO               TO WS-ACCOUNT-NO-063        
           MOVE 1                           TO WS-IC-NO-063             
           MOVE 'G'                         TO WS-CODE-UTIL-TYPE-063    
           MOVE 'Y'                         TO WS-THERM-CSC-ACCT-FL     
           MOVE 'N'                         TO WS-PENDING-OPTION-FL-063 
      *                                                                         
           CALL SCSCB063  USING   CWS00063-FIELDS,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
                                                                        
           MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE > 0             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '2100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPCODE ERROR'           TO ABEND-FUNCTION           
              MOVE 'CSS_UTIL_ENVRNMNT'      TO TABLE-ELEMENT-1          
              MOVE +100                     TO WS-ACTIVE-RETURN-CODE    
              PERFORM 9900-ABEND                THRU 9000-EXIT          
           END-IF.                                                      
           MOVE WS-THERM-PRICE              TO WS-RATE-PRICE.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 4200-PROCESS-PREPAY.                                           *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-PREPAY.                                             
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO PK-PREPAY-HIST-SEQ-TS.   
ACT027     MOVE WS-REV-MNTH-CUR             TO PK-REVENUE-MONTH.        
           MOVE 'S'                         TO PK-EST-METHOD-CD.        
           MOVE WS-ESTMT-CONSUMPT           TO PK-EST-NO-UNITS.         
           MOVE WS-THERM-PRICE              TO PK-EST-UNIT-PRICE-AM.    
           COMPUTE PK-EST-ADDL-CHARGE-AM    =  WS-AGL-PASS-CHARGE       
                                            +  WS-AGL-METER-CHARGE.     
           MOVE WS-CSC-AMT                  TO PK-EST-CUSTSVC-CHG-AM.   
           MOVE WS-ESTMT-AMOUNT             TO PK-EST-BILL-AM.          
           MOVE WS-BUFFER-AMT               TO PK-EST-MISC-CHARGE-AM.   
           MOVE ZEROS                       TO PK-EST-CONNECT-CHG-AM    
                                               PK-NET-BILL-ADJ-AM       
                                               PK-ARREARS-AMT           
                                               PK-BILLED-AMT            
                                               PK-PLAN-ACCT-BAL-AM      
                                               PK-BILL-VARIANCE-AM      
                                               PK-REMARKS-LEN.          
           MOVE SPACES                      TO PK-REMARKS-TEXT.         
           MOVE 'SYSTEM'                    TO PK-LAST-UPDATE-USERID.   
           PERFORM 8100-INSERT-PREPAY-HIST      THRU 8100-EXIT.         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2800-PRE-COMMIT.                                               *        
      ******************************************************************        
      *                                                                         
       2800-PRE-COMMIT.                                                 
      *                                                                         
           MOVE 1                           TO WS-RESTART-PROCESS-TYPE. 
           MOVE WS-C                        TO WS-RESTART-JOB-STATUS.   
           MOVE WS-INPUT-DATE               TO WS-RESTART-COMMON-DATE.  
           ADD  1                           TO WS-CHKP-SEQ-NO.          
           MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO.  
           MOVE AT-ACCOUNT-NO               TO WS-RESTART-ACCOUNT-NO.   
           MOVE WS-FCSDB07-REC-CNTR         TO                          
                                          WS-RESTART-FCSDB07-REC-CNTR.  
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT027******************************************************************25620000
ACT027*4525-GET-OLDEST-REV-MONTH.                                      *45550000
ACT027******************************************************************25640000
ACT027*                                                                 45750000
ACT027 4525-GET-OLDEST-REV-MONTH.                                       
ACT027*                                                                 45750000
ACT027     IF WS-FCA00-REV-MONTH (WS-INDEX) = WS-REV-MNTH-PREV          
ACT027        CONTINUE                                                  
ACT027     ELSE                                                         
ACT027       IF WS-REV-MNTH-PREV = ZEROES                               
ACT027          MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO WS-REV-MNTH-OLDEST 
ACT027       END-IF                                                     
ACT027       IF WS-FCA00-REV-MONTH (WS-INDEX) < WS-REV-MNTH-PREV        
ACT027          AND WS-FCA00-REV-MONTH (WS-INDEX) NOT = ZEROES          
ACT027          MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO WS-REV-MNTH-OLDEST 
ACT027       END-IF                                                     
ACT027     END-IF.                                                      
ACT027*                                                                 45750000
ACT027     MOVE WS-FCA00-REV-MONTH(WS-INDEX) TO WS-REV-MNTH-PREV.       
ACT027     ADD 1                             TO WS-INDEX.               
ACT027*                                                                 45750000
ACT027 4525-EXIT.                                                       
ACT027     EXIT.                                                        
ACT027*                                                                 45540000
      ******************************************************************        
      * 7010-GET-ACCT-DTLS.                                            *        
      ******************************************************************        
      *                                                                         
       7010-GET-ACCT-DTLS.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.PREMISE_NO                                      
                    ,AT.CODES_DATA_PRESENT                              
                    ,AT.REV_MTH_LST_NRML                                
                    ,AT.BILL_CYCLE                                      
                INTO :AT-PREMISE-NO                                     
                    ,:AT-CODES-DATA-PRESENT                             
                    ,:AT-REV-MTH-LST-NRML                               
                    ,:AT-BILL-CYCLE                                     
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
               WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.PREMISE_NO                                              
MFA-TR*             ,AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*         INTO :AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7010-GET-ACCT-DTLS         **'     
              DISPLAY '**   ACCOUNT NO   = ' AT-ACCOUNT-NO              
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************17770000
      * 7020-ACCEPT-TIMESTAMP                                          *17780000
      ******************************************************************17810000
      *                                                                         
       7020-ACCEPT-TIMESTAMP.                                           
      *                                                                 17830000
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     17840000
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP            17860000
MFA-TR*    END-EXEC.                                                    17880000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 17890000
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                 17920000
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7020-ACCEPT-TIMESTAMP      **'     
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 18050000
        7020-EXIT.                                                      
            EXIT.                                                       
      *                                                                 18050000
      ******************************************************************        
      * 7050-READ-FCSDB07                                              *        
      ******************************************************************        
      *                                                                         
       7050-READ-FCSDB07.                                               
      *                                                                         
           READ FCSDB07-FILE                                            
               AT END                                                   
                   MOVE WS-Y                TO WS-END-OF-FILE           
                   GO TO 7050-EXIT                                      
           END-READ.                                                    
      *                                                                         
           IF  FDB07-SUCCESSFUL                                         
               ADD 1 TO WS-FCSDB07-REC-CNTR                             
           ELSE                                                         
               DISPLAY '7050-ERROR ON FCSDB07 READ.  STATUS IS '        
                        WS-FDB07-STATUS                                 
               DISPLAY 'ERROR IN ACCOUNT NO' E-FDB07-ACCT-NO            
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28540000
      ****************************************************************          
      * 7160-SELECT-RESTART                                          *          
      ****************************************************************          
      *                                                                         
       7160-SELECT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT RF.RESTART_DATA                                    
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART RF WITH(READUNCOMMITTED)                       
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RF.RESTART_DATA                                            
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART RF                                             
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                         
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7160                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7160-SELECT-RESTART        **'     
              DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
              DISPLAY '**   PARTITION-NO = ' RF-PARTITION-NO            
              DISPLAY '**   DUP-CNTRL-NO = ' RF-DUP-CNTRL-NO            
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7170-SELECT-ZIP-CD                                           *          
      ****************************************************************          
      *                                                                         
       7170-SELECT-ZIP-CD.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT DY.ZIP_CODE                                        
                INTO :DY-ZIP-CODE                                       
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                       
                    ,CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
               WHERE PR.PREMISE_NO   = :PR-PREMISE-NO                   
                 AND PR.ADDRESS_ID   = DY.ADDRESS_ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DY.ZIP_CODE                                                
MFA-TR*         INTO :DY-ZIP-CODE                                               
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*             ,CSS_ADDR_FORMATTED DY                                      
MFA-TR*        WHERE PR.PREMISE_NO   = :PR-PREMISE-NO                           
MFA-TR*          AND PR.ADDRESS_ID   = DY.ADDRESS_ID                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7170                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7170-SELECT-ZIP-CD         **'     
              DISPLAY '**   PREMISE NO   = ' PR-PREMISE-NO              
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7180-SELECT-ADDR-ZIP-CD                                      *          
      ****************************************************************          
      *                                                                         
       7180-SELECT-ADDR-ZIP-CD.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT DZ.ADDR_ZIP_CODE                                   
                INTO :DZ-ADDR-ZIP-CODE                                  
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                       
                    ,CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED)                 
               WHERE PR.PREMISE_NO   = :PR-PREMISE-NO                   
                 AND PR.ADDRESS_ID   = DZ.ADDRESS_ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DZ.ADDR_ZIP_CODE                                           
MFA-TR*         INTO :DZ-ADDR-ZIP-CODE                                          
MFA-TR*         FROM CSS_PREMISE PR                                             
MFA-TR*             ,CSS_ADDR_FREEFORM DZ                                       
MFA-TR*        WHERE PR.PREMISE_NO   = :PR-PREMISE-NO                           
MFA-TR*          AND PR.ADDRESS_ID   = DZ.ADDRESS_ID                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7180                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7180-SELECT-ADDR-ZIP-CD    **'     
              DISPLAY '**   PREMISE NO   = ' PR-PREMISE-NO              
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7205-CHECK-BILL-COUNT.                                        *         
      *****************************************************************         
      *                                                                         
       7205-CHECK-BILL-COUNT.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT COUNT(BG.BILL_NO)                                  
                INTO :WS-BILL-COUNT                                     
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                    ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                   
               WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             
                 AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO              
                 AND BI.BILL_NO            = BG.BILL_NO                 
                 AND BI.DATE_BILLED        IS NOT NULL                  
                 AND BG.CODE_UTIL_TYPE     = 'G'                        
                 AND BG.CODE_BILL_CALC     = 'A'                        
                 AND BG.CODE_BILL_ITM_TYPE = 'C'                        
                 AND BG.CODE_BILL_ITM_IND  IN ('A','K')                 
                 AND BG.REV_MTH_ORIG_BILL  = 0                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(BG.BILL_NO)                                          
MFA-TR*         INTO :WS-BILL-COUNT                                             
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*             ,CSS_BILLING_HDR BI                                         
MFA-TR*        WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                     
MFA-TR*          AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                      
MFA-TR*          AND BI.BILL_NO            = BG.BILL_NO                         
MFA-TR*          AND BI.DATE_BILLED        IS NOT NULL                          
MFA-TR*          AND BG.CODE_UTIL_TYPE     = 'G'                                
MFA-TR*          AND BG.CODE_BILL_CALC     = 'A'                                
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND  IN ('A','K')                         
MFA-TR*          AND BG.REV_MTH_ORIG_BILL  = 0                                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7205                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7205-CHECK-BILL-COUNT      **'     
              DISPLAY '**   ACCOUNT NO  = ' BG-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7260-GET-CNSMPTN-UNIT.                                        *         
      *****************************************************************         
      *                                                                         
       7260-GET-CNSMPTN-UNIT.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(SUM(PX.NO_UNITS),0)                         
                    ,COALESCE(SUM(PX.NO_DAYS),0)                          
                INTO :WS-NO-UNITS                                       
                    ,:WS-NO-DAYS                                        
                FROM CSS_CNSMPTN_NONCIS PX WITH(READUNCOMMITTED)                
               WHERE PX.ACCOUNT_NO      = :PX-ACCOUNT-NO                
                 AND PX.REVENUE_MONTH   = :PX-REVENUE-MONTH             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(SUM(PX.NO_UNITS),0)                                 
MFA-TR*             ,IFNULL(SUM(PX.NO_DAYS),0)                                  
MFA-TR*         INTO :WS-NO-UNITS                                               
MFA-TR*             ,:WS-NO-DAYS                                                
MFA-TR*         FROM CSS_CNSMPTN_NONCIS PX                                      
MFA-TR*        WHERE PX.ACCOUNT_NO      = :PX-ACCOUNT-NO                        
MFA-TR*          AND PX.REVENUE_MONTH   = :PX-REVENUE-MONTH                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7260                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7260-GET-CNSMPTN-UNIT      **'     
              DISPLAY '**   ACCOUNT NO  = ' PX-ACCOUNT-NO               
              DISPLAY '**   REV MONTH   = ' PX-REVENUE-MONTH            
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7310-GET-DDC-FACTOR.                                      *             
      *****************************************************************         
      *                                                                         
       7310-GET-DDC-FACTOR.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT FF.FACTOR                                          
                INTO :FF-FACTOR                                         
                FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
               WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                 
                 AND IC_NO             = 1                              
                 AND FACTOR_ID         = 'DDC'                          
                 AND CODE_UTIL_TYPE    = 'G'                            
                 AND EFF_DATE_FROM    <= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )                
                 AND EFF_DATE_TO      >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FF.FACTOR                                                  
MFA-TR*         INTO :FF-FACTOR                                                 
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                         
MFA-TR*          AND IC_NO             = 1                                      
MFA-TR*          AND FACTOR_ID         = 'DDC'                                  
MFA-TR*          AND CODE_UTIL_TYPE    = 'G'                                    
MFA-TR*          AND EFF_DATE_FROM    <= :WS-COMMON-DATE                        
MFA-TR*          AND EFF_DATE_TO      >= :WS-COMMON-DATE                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7310-GET-DDC-FACTOR        **'     
              DISPLAY '**   ACCOUNT NO  = ' FF-ACCOUNT-NO               
              DISPLAY '**   COMMON-DATE = ' WS-COMMON-DATE              
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7360-CHECK-CNSMPTN-HIST.                                      *         
      *****************************************************************         
      *                                                                         
       7360-CHECK-CNSMPTN-HIST.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT COALESCE(SUM(CX.NO_UNITS),0)                         
                    ,COALESCE(SUM(CX.NO_DAYS),0)                          
                INTO :CX-NO-UNITS                                       
                    ,:CX-NO-DAYS                                        
                FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                   
                    ,CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                  
               WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO             
                 AND BG.ACCOUNT_NO         = CX.ACCOUNT_NO              
                 AND BG.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE          
                 AND BG.BILL_NO            = CX.BILL_NO                 
                 AND BG.CODE_BILL_CALC     = 'A'                        
                 AND BG.CODE_BILL_ITM_TYPE = 'C'                        
                 AND BG.CODE_BILL_ITM_IND  = 'A'                        
                 AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IFNULL(SUM(CX.NO_UNITS),0)                                 
MFA-TR*             ,IFNULL(SUM(CX.NO_DAYS),0)                                  
MFA-TR*         INTO :CX-NO-UNITS                                               
MFA-TR*             ,:CX-NO-DAYS                                                
MFA-TR*         FROM CSS_BILLING_DET BG                                         
MFA-TR*             ,CSS_CNSMPTN_HIST CX                                        
MFA-TR*        WHERE BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                     
MFA-TR*          AND BG.ACCOUNT_NO         = CX.ACCOUNT_NO                      
MFA-TR*          AND BG.CODE_UTIL_TYPE     = CX.CODE_UTIL_TYPE                  
MFA-TR*          AND BG.BILL_NO            = CX.BILL_NO                         
MFA-TR*          AND BG.CODE_BILL_CALC     = 'A'                                
MFA-TR*          AND BG.CODE_BILL_ITM_TYPE = 'C'                                
MFA-TR*          AND BG.CODE_BILL_ITM_IND  = 'A'                                
MFA-TR*          AND BG.REVENUE_MONTH      = :BG-REVENUE-MONTH                  
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7360                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7360-CHECK-CNSMPTN-HIST    **'     
              DISPLAY '**   ACCOUNT NO  = ' BG-ACCOUNT-NO               
              DISPLAY '**   REV MONTH   = ' BG-REVENUE-MONTH            
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7400-GET-OPTION-CD.                                           *         
      *****************************************************************         
      *                                                                         
       7400-GET-OPTION-CD.                                              
      *                                                                         
           EXEC SQL                                                     
              SELECT  DF.OPTION_CD                                      
                INTO :DF-OPTION-CD                                      
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                    ,CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
               WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO              
                 AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO               
                 AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE           
                 AND DF.IC_NO             = UT.IC_NO                    
                 AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DF.OPTION_CD                                              
MFA-TR*         INTO :DF-OPTION-CD                                              
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*        WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                      
MFA-TR*          AND DF.ACCOUNT_NO        = UT.ACCOUNT_NO                       
MFA-TR*          AND DF.CODE_UTIL_TYPE    = UT.CODE_UTIL_TYPE                   
MFA-TR*          AND DF.IC_NO             = UT.IC_NO                            
MFA-TR*          AND DF.RT_PKG_OPT_SEQ_NO = UT.RT_PKG_OPT_SEQ_NO                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7400-GET-OPTION-CD         **'     
              DISPLAY '**   ACCOUNT NO  = ' DF-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7450-GET-MAX-ROW.                                             *         
      *****************************************************************         
      *                                                                         
       7450-GET-MAX-ROW.                                                
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           PK.PREPAY_HIST_SEQ_TS, 121), ' ', '-'), ':', '.') 
           PREPAY_HIST_SEQ_TS,
              PK.REVENUE_MONTH,
              PK.EST_METHOD_CD,
              PK.EST_NO_UNITS,
              PK.EST_UNIT_PRICE_AM,
              PK.EST_ADDL_CHARGE_AM,
              PK.EST_CUSTSVC_CHG_AM,
              PK.EST_MISC_CHARGE_AM,
              PK.EST_CONNECT_CHG_AM,
              PK.EST_BILL_AM,
              PK.NET_BILL_ADJ_AM,
              PK.ARREARS_AMT,
              PK.BILLED_AMT,
              PK.REMARKS,
              PK.LAST_UPDATE_USERID,
              PK.PLAN_ACCT_BAL_AM,
              PK.BILL_VARIANCE_AM                               
                INTO                                                    
                      :PK-PREPAY-HIST-SEQ-TS                            
                     ,:PK-REVENUE-MONTH                                 
                     ,:PK-EST-METHOD-CD                                 
                     ,:PK-EST-NO-UNITS                                  
                     ,:PK-EST-UNIT-PRICE-AM                             
                     ,:PK-EST-ADDL-CHARGE-AM                            
                     ,:PK-EST-CUSTSVC-CHG-AM                            
                     ,:PK-EST-MISC-CHARGE-AM                            
                     ,:PK-EST-CONNECT-CHG-AM                            
                     ,:PK-EST-BILL-AM                                   
                     ,:PK-NET-BILL-ADJ-AM                               
                     ,:PK-ARREARS-AMT                                   
                     ,:PK-BILLED-AMT                                    
                     ,:PK-REMARKS                                       
                     ,:PK-LAST-UPDATE-USERID                            
                     ,:PK-PLAN-ACCT-BAL-AM                              
                     ,:PK-BILL-VARIANCE-AM                              
                FROM CSS_PREPAY_HIST PK WITH(READUNCOMMITTED)                   
               WHERE PK.ACCOUNT_NO          = :PK-ACCOUNT-NO            
               ORDER BY PREPAY_HIST_SEQ_TS  DESC                     
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*               PK.PREPAY_HIST_SEQ_TS                                     
MFA-TR*              ,PK.REVENUE_MONTH                                          
MFA-TR*              ,PK.EST_METHOD_CD                                          
MFA-TR*              ,PK.EST_NO_UNITS                                           
MFA-TR*              ,PK.EST_UNIT_PRICE_AM                                      
MFA-TR*              ,PK.EST_ADDL_CHARGE_AM                                     
MFA-TR*              ,PK.EST_CUSTSVC_CHG_AM                                     
MFA-TR*              ,PK.EST_MISC_CHARGE_AM                                     
MFA-TR*              ,PK.EST_CONNECT_CHG_AM                                     
MFA-TR*              ,PK.EST_BILL_AM                                            
MFA-TR*              ,PK.NET_BILL_ADJ_AM                                        
MFA-TR*              ,PK.ARREARS_AMT                                            
MFA-TR*              ,PK.BILLED_AMT                                             
MFA-TR*              ,PK.REMARKS                                                
MFA-TR*              ,PK.LAST_UPDATE_USERID                                     
MFA-TR*              ,PK.PLAN_ACCT_BAL_AM                                       
MFA-TR*              ,PK.BILL_VARIANCE_AM                                       
MFA-TR*         INTO                                                            
MFA-TR*               :PK-PREPAY-HIST-SEQ-TS                                    
MFA-TR*              ,:PK-REVENUE-MONTH                                 37770000
MFA-TR*              ,:PK-EST-METHOD-CD                                 37780000
MFA-TR*              ,:PK-EST-NO-UNITS                                  37790000
MFA-TR*              ,:PK-EST-UNIT-PRICE-AM                             37800000
MFA-TR*              ,:PK-EST-ADDL-CHARGE-AM                            37810000
MFA-TR*              ,:PK-EST-CUSTSVC-CHG-AM                            37811000
MFA-TR*              ,:PK-EST-MISC-CHARGE-AM                            37820000
MFA-TR*              ,:PK-EST-CONNECT-CHG-AM                                    
MFA-TR*              ,:PK-EST-BILL-AM                                   37830000
MFA-TR*              ,:PK-NET-BILL-ADJ-AM                               37840000
MFA-TR*              ,:PK-ARREARS-AMT                                   37850000
MFA-TR*              ,:PK-BILLED-AMT                                    37860000
MFA-TR*              ,:PK-REMARKS                                       37870000
MFA-TR*              ,:PK-LAST-UPDATE-USERID                            37880000
MFA-TR*              ,:PK-PLAN-ACCT-BAL-AM                              37880000
MFA-TR*              ,:PK-BILL-VARIANCE-AM                              37880000
MFA-TR*         FROM CSS_PREPAY_HIST PK                                         
MFA-TR*        WHERE PK.ACCOUNT_NO          = :PK-ACCOUNT-NO                    
MFA-TR*        ORDER BY PK.PREPAY_HIST_SEQ_TS  DESC                             
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7450                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7450-GET-MAX-ROW           **'     
              DISPLAY '**   ACCOUNT NO    = ' PK-ACCOUNT-NO             
              DISPLAY '**   SQLCODE       = ' WS-DISPLAY-SQLCODE        
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7500-CHECK-PRP-EXEMPT.                                        *         
      *****************************************************************         
      *                                                                         
       7500-CHECK-PRP-EXEMPT.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  'Y'                                               
                INTO  :WS-PRP-EXEMPT                                    
                FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
               WHERE YP.ACCOUNT_NO          = :YP-ACCOUNT-NO            
                 AND YP.ATTRIBUTE_DESC      ='SET_PRP_EXEMPTIONS'       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  'Y'                                                       
MFA-TR*         INTO  :WS-PRP-EXEMPT                                            
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO          = :YP-ACCOUNT-NO                    
MFA-TR*          AND YP.ATTRIBUTE_DESC      ='SET_PRP_EXEMPTIONS'               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7500-CHECK-PRP-EXEMPT      **'     
              DISPLAY '**   ACCOUNT NO  = ' YP-ACCOUNT-NO               
              DISPLAY '**   SQLCODE     = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************37462000
      * 8100-INSERT-PREPAY-HIST.                                       *37470000
      ******************************************************************37500000
      *                                                                         
       8100-INSERT-PREPAY-HIST.                                         
      *                                                                 37530000
           EXEC SQL                                                     
              INSERT INTO CSS_PREPAY_HIST                               
                     (ACCOUNT_NO                                        
                     ,PREPAY_HIST_SEQ_TS                                
                     ,REVENUE_MONTH                                     
                     ,EST_METHOD_CD                                     
                     ,EST_NO_UNITS                                      
                     ,EST_UNIT_PRICE_AM                                 
                     ,EST_ADDL_CHARGE_AM                                
                     ,EST_CUSTSVC_CHG_AM                                
                     ,EST_MISC_CHARGE_AM                                
                     ,EST_CONNECT_CHG_AM                                
                     ,EST_BILL_AM                                       
                     ,NET_BILL_ADJ_AM                                   
                     ,ARREARS_AMT                                       
                     ,BILLED_AMT                                        
                     ,REMARKS                                           
                     ,LAST_UPDATE_USERID                                
                     ,PLAN_ACCT_BAL_AM                                  
                     ,BILL_VARIANCE_AM)                                 
              VALUES (:PK-ACCOUNT-NO                                    
                     ,CIS.CHAR2TIMESTAMP(:PK-PREPAY-HIST-SEQ-TS)                
                     ,:PK-REVENUE-MONTH                                 
                     ,:PK-EST-METHOD-CD                                 
                     ,:PK-EST-NO-UNITS                                  
                     ,:PK-EST-UNIT-PRICE-AM                             
                     ,:PK-EST-ADDL-CHARGE-AM                            
                     ,:PK-EST-CUSTSVC-CHG-AM                            
                     ,:PK-EST-MISC-CHARGE-AM                            
                     ,:PK-EST-CONNECT-CHG-AM                            
                     ,:PK-EST-BILL-AM                                   
                     ,:PK-NET-BILL-ADJ-AM                               
                     ,:PK-ARREARS-AMT                                   
                     ,:PK-BILLED-AMT                                    
                     ,:PK-REMARKS                                       
                     ,:PK-LAST-UPDATE-USERID                            
                     ,:PK-PLAN-ACCT-BAL-AM                              
                     ,:PK-BILL-VARIANCE-AM)                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     37540000
MFA-TR*       INSERT INTO CSS_PREPAY_HIST                               37550000
MFA-TR*              (ACCOUNT_NO                                        37560000
MFA-TR*              ,PREPAY_HIST_SEQ_TS                                37570000
MFA-TR*              ,REVENUE_MONTH                                     37580000
MFA-TR*              ,EST_METHOD_CD                                     37590000
MFA-TR*              ,EST_NO_UNITS                                      37600000
MFA-TR*              ,EST_UNIT_PRICE_AM                                 37610000
MFA-TR*              ,EST_ADDL_CHARGE_AM                                37620000
MFA-TR*              ,EST_CUSTSVC_CHG_AM                                37621000
MFA-TR*              ,EST_MISC_CHARGE_AM                                37630000
MFA-TR*              ,EST_CONNECT_CHG_AM                                        
MFA-TR*              ,EST_BILL_AM                                       37640000
MFA-TR*              ,NET_BILL_ADJ_AM                                   37650000
MFA-TR*              ,ARREARS_AMT                                       37660000
MFA-TR*              ,BILLED_AMT                                        37665000
MFA-TR*              ,REMARKS                                           37670000
MFA-TR*              ,LAST_UPDATE_USERID                                37690000
MFA-TR*              ,PLAN_ACCT_BAL_AM                                          
MFA-TR*              ,BILL_VARIANCE_AM)                                         
MFA-TR*       VALUES (:PK-ACCOUNT-NO                                    37750000
MFA-TR*              ,:PK-PREPAY-HIST-SEQ-TS                            37760000
MFA-TR*              ,:PK-REVENUE-MONTH                                 37770000
MFA-TR*              ,:PK-EST-METHOD-CD                                 37780000
MFA-TR*              ,:PK-EST-NO-UNITS                                  37790000
MFA-TR*              ,:PK-EST-UNIT-PRICE-AM                             37800000
MFA-TR*              ,:PK-EST-ADDL-CHARGE-AM                            37810000
MFA-TR*              ,:PK-EST-CUSTSVC-CHG-AM                            37811000
MFA-TR*              ,:PK-EST-MISC-CHARGE-AM                            37820000
MFA-TR*              ,:PK-EST-CONNECT-CHG-AM                                    
MFA-TR*              ,:PK-EST-BILL-AM                                   37830000
MFA-TR*              ,:PK-NET-BILL-ADJ-AM                               37840000
MFA-TR*              ,:PK-ARREARS-AMT                                   37850000
MFA-TR*              ,:PK-BILLED-AMT                                    37860000
MFA-TR*              ,:PK-REMARKS                                       37870000
MFA-TR*              ,:PK-LAST-UPDATE-USERID                            37880000
MFA-TR*              ,:PK-PLAN-ACCT-BAL-AM                              37880000
MFA-TR*              ,:PK-BILL-VARIANCE-AM)                             37880000
MFA-TR*    END-EXEC.                                                    37940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 37950000
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                 37970000
           IF SQLCODE  = SUCCESSFUL-CALL                                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 8100-INSERT-PREPAY-HIST    **'     
              DISPLAY '**   ACCOUNT NO    = ' PK-ACCOUNT-NO             
              DISPLAY '**   HIST SEQ TS   = ' PK-PREPAY-HIST-SEQ-TS     
              DISPLAY '**   SQLCODE       = ' WS-DISPLAY-SQLCODE        
              DISPLAY '**        PROCESSING TERMINATED          **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 38140000
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 38140000
      ***************************************************************** 42130000
      * 8200-UPDATE-PREPAY-HIST                                       * 42140000
      ***************************************************************** 42170000
      *                                                                 42200000
       8200-UPDATE-PREPAY-HIST.                                         
      *                                                                 42200000
           EXEC SQL                                                     
              UPDATE PK                                  
                 SET PK.EST_BILL_AM        = :PK-EST-BILL-AM            
                    ,PK.NET_BILL_ADJ_AM    = :PK-NET-BILL-ADJ-AM        
                    ,PK.ARREARS_AMT        = :PK-ARREARS-AMT            
                    ,PK.BILLED_AMT         = :PK-BILLED-AMT             
                    ,PK.REMARKS            = :PK-REMARKS                
              FROM CSS_PREPAY_HIST PK
               WHERE PK.ACCOUNT_NO         = :PK-ACCOUNT-NO             
                 AND PK.PREPAY_HIST_SEQ_TS = CIS.CHAR2TIMESTAMP(
                                                 :PK-PREPAY-HIST-SEQ-TS
              )     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42210000
MFA-TR*       UPDATE CSS_PREPAY_HIST PK                                 42220000
MFA-TR*          SET PK.EST_BILL_AM        = :PK-EST-BILL-AM            42220000
MFA-TR*             ,PK.NET_BILL_ADJ_AM    = :PK-NET-BILL-ADJ-AM        42240000
MFA-TR*             ,PK.ARREARS_AMT        = :PK-ARREARS-AMT                    
MFA-TR*             ,PK.BILLED_AMT         = :PK-BILLED-AMT                     
MFA-TR*             ,PK.REMARKS            = :PK-REMARKS                        
MFA-TR*        WHERE PK.ACCOUNT_NO         = :PK-ACCOUNT-NO             42260000
MFA-TR*          AND PK.PREPAY_HIST_SEQ_TS = :PK-PREPAY-HIST-SEQ-TS     42260000
MFA-TR*    END-EXEC.                                                    42270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42280000
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                 42300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 8200-UPDATE-ACCOUNT        **'     
              DISPLAY '**   ACCOUNT NO      = ' PK-ACCOUNT-NO           
              DISPLAY '**   HIST SEQ NO     = ' PK-PREPAY-HIST-SEQ-TS   
              DISPLAY '**   SQLCODE         = ' WS-DISPLAY-SQLCODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 42430000
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8300-UPDATE-PRP-EXEMPT.                                       *         
      *****************************************************************         
      *                                                                         
       8300-UPDATE-PRP-EXEMPT.                                          
      *                                                                         
           EXEC SQL                                                     
               UPDATE AT                                     
                  SET AT.NOTICE_EXEMPT_CD = :AT-NOTICE-EXEMPT-CD        
                     ,AT.CODE_DISC_OK     = :AT-CODE-DISC-OK            
               FROM CSS_ACCOUNT AT
                WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT AT                                            
MFA-TR*           SET AT.NOTICE_EXEMPT_CD = :AT-NOTICE-EXEMPT-CD                
MFA-TR*              ,AT.CODE_DISC_OK     = :AT-CODE-DISC-OK                    
MFA-TR*         WHERE AT.ACCOUNT_NO       = :AT-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-DISPLAY-SQLCODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 8300-UPDATE-PRP-EXEMPT     **'     
              DISPLAY '**   ACCOUNT NO      = ' AT-ACCOUNT-NO           
              DISPLAY '**   SQLCODE         = ' WS-DISPLAY-SQLCODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8400-DELETE-PRP-ACCT-ATTR.                                    *         
      *****************************************************************         
      *                                                                         
       8400-DELETE-PRP-ACCT-ATTR.                                       
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM CSS_ACCT_ATTRIBUTE                           
                WHERE ACCOUNT_NO       = :YP-ACCOUNT-NO                 
                  AND ATTRIBUTE_DESC   = 'SET_PRP_EXEMPTIONS'           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                WS-DISPLAY-SQLCODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 8400-DELETE-PRP-ACCT-ATTR  **'     
              DISPLAY '**   ACCOUNT NO      = ' YP-ACCOUNT-NO           
              DISPLAY '**   SQLCODE         = ' WS-DISPLAY-SQLCODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 42130000
      * 8500-UPDATE-REV-MNTH                                          * 42140000
      ***************************************************************** 42170000
      *                                                                 42200000
       8500-UPDATE-REV-MNTH.                                            
      *                                                                 42200000
           EXEC SQL                                                     
              UPDATE PK                                  
                 SET PK.REVENUE_MONTH   = :PK-REVENUE-MONTH             
              FROM CSS_PREPAY_HIST PK
               WHERE PK.ACCOUNT_NO      = :PK-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                     42210000
MFA-TR*       UPDATE CSS_PREPAY_HIST PK                                 42220000
MFA-TR*          SET PK.REVENUE_MONTH   = :PK-REVENUE-MONTH             42220000
MFA-TR*        WHERE PK.ACCOUNT_NO      = :PK-ACCOUNT-NO                42260000
MFA-TR*    END-EXEC.                                                    42270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42280000
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
      *                                                                 42300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA096 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 8500-UPDATE-REV-MNTH       **'     
              DISPLAY '**   ACCOUNT NO      = ' PK-ACCOUNT-NO           
              DISPLAY '**   SQLCODE         = ' WS-DISPLAY-SQLCODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 42430000
       8500-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8810-WRITE-RESTART                                             *        
      ******************************************************************        
      *                                                                         
       8810-WRITE-RESTART.                                              
      *                                                                         
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
                                                                        
           PERFORM 8820-UPDATE-RESTART      THRU 8820-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8830-INSERT-RESTART       THRU 8830-EXIT          
           END-IF.                                                      
      *                                                                         
       8810-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8820-UPDATE-RESTART                                            *        
      ******************************************************************        
      *                                                                         
       8820-UPDATE-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE RF                                     
                  SET RF.RESTART_DATA = :RF-RESTART-DATA                
               FROM CSS_RESTART RF
                WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                
                  AND RF.PARTITION_NO = :RF-PARTITION-NO                
                  AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_RESTART RF                                            
MFA-TR*           SET RF.RESTART_DATA = :RF-RESTART-DATA                        
MFA-TR*         WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                        
MFA-TR*           AND RF.PARTITION_NO = :RF-PARTITION-NO                        
MFA-TR*           AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                        
MFA-TR*        QUERYNO 8820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**  PCSCA096 PROCESSING ERROR        **'         
              DISPLAY '**  ERROR ON 8820-UPDATE-RESTART     **'         
              DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM             
              DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO             
              DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO             
              DISPLAY '**  SQLCODE      = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**      PROCESSING TERMINATED        **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8830-INSERT-RESTART                                            *        
      ******************************************************************        
      *                                                                         
       8830-INSERT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                          (NAME_PROGRAM                                 
                          ,PARTITION_NO                                 
                          ,DUP_CNTRL_NO                                 
                          ,RESTART_DATA)                                
               VALUES    (:RF-NAME-PROGRAM                              
                         ,:RF-PARTITION-NO                              
                         ,:RF-DUP-CNTRL-NO                              
                         ,:RF-RESTART-DATA)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
           IF SQLCODE  = SUCCESSFUL-CALL                                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**   PCSCA096 PROCESSING ERROR       **'         
              DISPLAY '**   ERROR ON 8830-INSERT-RESTART    **'         
              DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
              DISPLAY '**   PARTITION_NO = ' RF-PARTITION-NO            
              DISPLAY '**   DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO            
              DISPLAY '**   SQLCODE      = ' WS-DISPLAY-SQLCODE         
              DISPLAY '**       PROCESSING TERMINATED       **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8830-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42471600
      ******************************************************************        
      * 8850-DEL-RESTART-REC.                                          *        
      ******************************************************************        
      *                                                                         
       8850-DEL-RESTART-REC.                                            
      *                                                                         
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM RF                                 
              FROM CSS_RESTART RF
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_RESTART RF                                        
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                         
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                         
MFA-TR*      QUERYNO 8850                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-DISPLAY-SQLCODE       
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**   PCSCA096 PROCESSING ERROR       **'         
              DISPLAY '**  ERROR ON 8850-DEL-RESTART-REC'               
              DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM             
              DISPLAY '**  SQLCODE      = ' WS-DISPLAY-SQLCODE          
              DISPLAY '**       PROCESSING TERMINATED       **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8888-COMMIT.                                                     
      *                                                                         
           PERFORM 2800-PRE-COMMIT          THRU 2800-EXIT              
           PERFORM 8810-WRITE-RESTART       THRU 8810-EXIT              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '*******************************************'        
           DISPLAY '*COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.**'        
           DISPLAY '*LAST REC PROCESSED  = ' AT-ACCOUNT-NO              
           DISPLAY '*******************************************'.       
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8889-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8889-COMMIT.                                                     
      *                                                                         
           MOVE WS-FCSDB07-REC-CNTR         TO WS-DB07-REC-CNTR         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '*******************************************'        
           DISPLAY '*TOT NO. OF DB07 RECORDS PROCESSED:'WS-DB07-REC-CNTR
           DISPLAY '*******************************************'.       
      *                                                                         
       8889-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK              *         
      *****************************************************************         
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ******************************************************************        
      *  CLOSES  THE INPUT  FILE                                       *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSDB07-FILE                                           
      *                                                                         
           IF FDB07-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR IN CLOSING FCSDB07-FILE'                   
              DISPLAY 'ERROR STATUS ' WS-FDB07-STATUS                   
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  6253-GET-FJC01-CHKP-LIMIT.                                   *        
      ******************************************************************        
      *                                                                         
           COPY CPD00034.                                                       
      *                                                                         
      ******************************************************************        
      **  6240-GET-FCA00-COMMON-DATE.                                  *        
      ******************************************************************        
      *                                                                         
           COPY CPD00040.                                                       
      *                                                                         
ACT027******************************************************************        
ACT027*  6241-GET-FCA00-BILL-CYCLES                                    *        
ACT027******************************************************************        
ACT027*                                                                         
ACT027     EXEC SQL                                                             
ACT027        INCLUDE CPD00041                                                  
ACT027     END-EXEC.                                                            
ACT027*                                                                         
      ******************************************************************        
      *  6251-GET-FJC01-DATE.                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7600-START-FCSJC01.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7620-START-FCSCA00.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6000-PRP-ESTIMATE                                              *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD04391                                                  
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************55180000
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK               *55190000
      ******************************************************************55200000
      *                                                                 55220000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 55220000
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                         
      ******************************************************************        
      *  9900-ABEND.                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
