       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA075.                                            
       AUTHOR. MADHAVI CH.                                              
       DATE-WRITTEN. NOV 2006.                                          
      ******************************************************************        
      *                 SOUTH CAROLINA ELECTRIC & GAS                  *        
      *                                                                *        
      ******************************************************************        
      *                 CUSTOMER INFORMATION SYSTEM                    *        
      ******************************************************************        
      *                       PROGRAM SUMMARY                          *        
      *                                                                *        
      *    PURPOSE:  OFAC CHECKING                                     *        
      *                                                                *        
      *    1.THIS PROGRAM RUNS ONCE IN A MONTH.                        *        
      *    2.SELECTS ALL NEW CUSTOMERS FROM LAST RUN(CSS_JOB_PARM).             
      *    3.THREE OUTPUT FILES RESIDENTIAL,COMMERCIAL AND SERVICE CARE         
      *      ARE CREATED.                                                       
      *    4.OUTPUT FILES ARE UPLOADED TO USER FOLDER.                          
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                PROGRAM  MODIFICATION  LOG                      *        
      *                                                                *        
      *       DATE       INITIALS         REASON                       *        
      *     ----------   --------         ---------------------------  *        
      *     11/15/2006   MC95456          CML-34978                    *        
      *                                   OFAC SCREENING FOR CSR/PSNC  *        
T35434*     05/15/2007   SP94986          REPLACE MODEL_SQL TO SET     *        
T35434*                                   COMMANDS.                    *        
T37141*     04/06/2008   MC95456          INCREASED LENGTH OF LAST_NAME*        
T37141*                                   AND FULL_NAME                *        
A02062*     01/19/2010   MC95456          REPORTS TO BE GENERATED BASED*        
A02062*                                   ON LAST NAME                 *        
ACT191*     10/01/2011   NS75440          INCLUDED NEW CUSTOMER FIELDS *        
ACT191*                  A03082-ACT191    STREET ADDRESS,PO BOX,CITY,  *        
ACT191*                                   STATE,COUNTRY                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
            SELECT  OFACCSR-FILE                                        
                ASSIGN UT-S-OFACCSR.                                    
            SELECT  OFACCSRB-FILE                                       
                ASSIGN UT-S-OFACCSRB.                                   
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  OFACCSR-FILE                                                 
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01 OFACCSR-RECORD.                                               
ACT191    05 OFAC-DATA                PIC X(379).                       
                                                                        
       FD  OFACCSRB-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01 OFACCSRB-RECORD.                                              
ACT191    05 OFACB-DATA               PIC X(379).                       
                                                                        
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA075'.
MSQ017     COPY MFASQLM.
                                                                        
       01 MS-START                    PIC X(40)  VALUE                  
         'WORKING STORAGE FOR PCSCA075 STARTS HERE'.                    
                                                                        
ACT191 01 TDS-RETURN-FIELDS.                                            
ACT191    05  RS-RETURN-CODE          PIC S9(09) VALUE +000 COMP.       
ACT191    05  RS-RETURN-CODE-DISP     PIC S9(09) VALUE +000 COMP.       
ACT191 01 WS-MISC.                                                      
ACT191    05 PROGRAM-NAME             PIC X(08)  VALUE 'PCSCA075'.      
                                                                        
       01 WS-GENERAL-WORKING-STORAGE.                                   
                                                                        
          05 WS-PRE-CUST-NO           PIC S9(10)   COMP-3 VALUE 0.      
          05 WS-CREDIT-GROUP          PIC X(01)    VALUE SPACES.        
          05 WS-LAST-RUN-DATE         PIC X(10)    VALUE SPACES.        
          05 WS-CURRENT-DATE          PIC X(10)    VALUE SPACES.        
ACT191    05 WS-PRT33-RECORD          PIC X(379)   VALUE SPACES.        
          05 WS-CODE-ACCT-STAT        PIC X(01)    VALUE SPACES.        
          05 WS-CODE-REVENUE-CLASS    PIC X(03)    VALUE SPACES.        
          05 WS-DATE-UTIL-SVC-STRT    PIC X(10)    VALUE SPACES.        
          05 WS-REPORT-TYPE           PIC 9(01)    VALUE 0.             
          05 WS-COMM-IND              PIC 9(01)    VALUE 0.             
          05 WS-RES-IND               PIC 9(01)    VALUE 0.             
                                                                        
       01 WS-PARM-DATA.                                                 
          05 FILLER                   PIC X(09)    VALUE 'RUN DATE='.   
          05 WS-NEW-RUN-DATE          PIC X(10)    VALUE SPACES.        
                                                                        
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-RECORDS     PIC X(01)    VALUE 'N'.           
               88 NO-MORE-RECORDS                  VALUE 'Y'.           
                                                                        
       01  WS-LITERALS.                                                 
           05 WS-Y                    PIC X(01)    VALUE 'Y'.           
           05 WS-N                    PIC X(01)    VALUE 'N'.           
           05 WS-PGRMNAME             PIC X(08)    VALUE 'PCSCA075'.    
                                                                        
      ****************************************************************          
      *           COMMON WORKING STORAGE FOR FILE HEADERS            *          
      ****************************************************************          
       01 WS-HEADING-LINES.                                             
             05 FILLER                 PIC X(08) VALUE 'UniqueId'.      
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(03) VALUE 'SSN'.           
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(09) VALUE 'FirstName'.     
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(10) VALUE 'MiddleName'.    
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(08) VALUE 'LastName'.      
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(08) VALUE 'Address1'.      
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(08) VALUE 'Address2'.      
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(04) VALUE 'City'.          
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(05) VALUE 'State'.         
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(07) VALUE 'ZipCode'.       
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(07) VALUE 'Country'.       
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(13) VALUE 'DriverLicense'. 
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(18) VALUE                  
                                               'DriverLicenseState'.    
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(05) VALUE 'Phone'.         
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
             05 FILLER                 PIC X(11) VALUE 'DateOfBirth'.   
       01 WS-DATA-LINE.                                                 
             05 F-UNIQUE-ID.                                            
                10 F-PREFIX            PIC X(01) VALUE SPACES.          
                10 F-CUSTOMER-NO       PIC X(10) VALUE SPACES.          
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
ACT191       05 F-FIRST-NAME           PIC X(185) VALUE SPACES.         
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
A02062       05 F-MIDDLE-NAME          PIC X(15) VALUE SPACES.          
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
T37141       05 F-LAST-NAME            PIC X(40) VALUE SPACES.          
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
ACT191       05 F-NAME-STREET          PIC X(55) VALUE SPACES.          
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
ACT191       05 F-CITY                 PIC X(26) VALUE SPACES.          
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
ACT191       05 F-STATE                PIC X(02) VALUE SPACES.          
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
HEX01        05 FILLER                 PIC X(01) VALUE X'09'.           
ACT191       05 F-COUNTRY              PIC X(35) VALUE SPACES.          
      *****************************************************************         
      * FIOJC01.                                                      *         
      *****************************************************************         
             COPY FIOJC01.                                                      
      *****************************************************************         
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       *         
      *****************************************************************         
             COPY CWS00010.                                                     
      *****************************************************************         
      * WORKING STORAGE FOR CPD09900                                  *         
      *****************************************************************         
             COPY CWS09900.                                                     
      *****************************************************************         
      *  COPYBOOK WITH COMMON SQL VARIABLES                           *         
      *****************************************************************         
             COPY CWS00303.                                                     
      *****************************************************************         
      *  CWS00038  JOB PARM ROUTINE                                   *         
      *****************************************************************         
             COPY CWS00038.                                                     
      *****************************************************************         
      *  COPYBOOK FOR CPD00039                                        *         
      *****************************************************************         
             COPY CWS00039.                                                     
      *****************************************************************         
      *  COPYBOOK WITH JOBS FILE/TABLE DEFINITIONS                    *         
      *****************************************************************         
             COPY FIOCA00.                                                      
ACT191*****************************************************************         
ACT191* CWS00074    WORKING STORAGE FOR CPD00074                      *         
ACT191*****************************************************************         
ACT191       COPY CWS00074.                                                     
      *                                                                         
ACT191*****************************************************************         
ACT191* CWS00011    THIS COPY STATEMENT IS THE WS AREA USED TO REDUCE *         
ACT191*             EMBEDDED BLANKS.                                  *         
ACT191*****************************************************************         
ACT191       COPY CWS00011.                                                     
      *****************************************************************         
      * SQL COMMUNICATION AREA                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_JOB_PARM                                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBJBPARM                                                
           END-EXEC.                                                            
      *****************************************************************         
      * TABLE CSS_ACCOUNT, AT                                         *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * TABLE CSS_CUSTOMER, CU                                        *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBCUST                                                  
           END-EXEC.                                                            
      *****************************************************************         
      * CSS_UTIL_ENVRNMT, UT                                          *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *****************************************************************         
      *****************************************************************         
      * TABLE CSS_CUST_PREM_HIST, CH                                  *         
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBCSTPRM                                                
           END-EXEC.                                                            
      *****************************************************************         
      * TABLE CSS_NAME                                                          
      *****************************************************************         
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
ACT191*****************************************************************         
ACT191*   CSS_NAME_ACCT_XREF - HT                                               
ACT191*****************************************************************         
ACT191     EXEC SQL                                                             
ACT191          INCLUDE TBNMACTX                                                
ACT191     END-EXEC.                                                            
      *                                                                         
ACT191*****************************************************************         
ACT191*   CSS_CUST_ADDR_XREF - DM                                               
ACT191*****************************************************************         
ACT191     EXEC SQL                                                             
ACT191          INCLUDE TBCSADRX                                                
ACT191     END-EXEC.                                                            
      *                                                                         
ACT191*****************************************************************         
ACT191*   CSS_ACCT_MISC_INFO - TA                                               
ACT191*****************************************************************         
ACT191     EXEC SQL                                                             
ACT191          INCLUDE TBATMISC                                                
ACT191     END-EXEC.                                                            
      *                                                                         
ACT191*****************************************************************         
ACT191*   CSS_ADDR_FORMATTED - DY                                               
ACT191*****************************************************************         
ACT191     EXEC SQL                                                             
ACT191          INCLUDE TBADRFMT                                                
ACT191     END-EXEC.                                                            
      *                                                                         
ACT191**************************************************************            
ACT191*   CSS_ADDR_FREE_FORM -DZ                                                
ACT191**************************************************************            
ACT191     EXEC SQL                                                             
ACT191          INCLUDE TBADRFRE                                                
ACT191     END-EXEC.                                                            
      *                                                                         
ACT191*****************************************************************         
ACT191*   CSS_ZIP_CODE -A4                                                      
ACT191*****************************************************************         
ACT191     EXEC SQL                                                             
ACT191          INCLUDE TBZIPCD                                                 
ACT191     END-EXEC.                                                            
      *                                                                         
ACT191****************************************************************          
ACT191*  CSS_PREMISE - PR                                            *          
ACT191****************************************************************          
ACT191     EXEC SQL                                                             
ACT191          INCLUDE TBPREM                                                  
ACT191     END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CURSOR FOR ACTIVE CUSTOMERS                                   *         
      *****************************************************************         
           EXEC SQL                                                     
           DECLARE BASE_CSR CURSOR FOR                                  
            SELECT  CU.CUSTOMER_NO                                      
                   ,AT.ACCOUNT_NO                                       
ACT191             ,AT.PREMISE_NO                                       
ACT191             ,AT.ADDRESS_ID                                       
ACT191             ,AT.ADDRESS_FORMAT                                   
ACT191             ,AT.ACCOUNT_TYPE_CODE                                
                   ,CU.NAME_ID                                          
              FROM  CSS_CUST_PREM_HIST  CH WITH(READUNCOMMITTED)                
                   ,CSS_CUSTOMER  CU WITH(READUNCOMMITTED)                      
                   ,CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                      
            WHERE AT.CUSTOMER_NO = CU.CUSTOMER_NO                       
            AND   CH.ACCOUNT_NO  = AT.ACCOUNT_NO                        
            AND   AT.CODE_ACCT_STAT  = 'A'                              
            AND   DATE_UTIL_SVC_STRT > IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )                
            ORDER BY CU.CUSTOMER_NO                                     
            FOR READ ONLY                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE BASE_CSR CURSOR FOR                                          
MFA-TR*     SELECT  CU.CUSTOMER_NO                                              
MFA-TR*            ,AT.ACCOUNT_NO                                               
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*            ,AT.ADDRESS_ID                                               
MFA-TR*            ,AT.ADDRESS_FORMAT                                           
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                        
MFA-TR*            ,CU.NAME_ID                                                  
MFA-TR*       FROM  CSS_CUST_PREM_HIST  CH                                      
MFA-TR*            ,CSS_CUSTOMER  CU                                            
MFA-TR*            ,CSS_ACCOUNT   AT                                            
MFA-TR*     WHERE AT.CUSTOMER_NO = CU.CUSTOMER_NO                               
MFA-TR*     AND   CH.ACCOUNT_NO  = AT.ACCOUNT_NO                                
MFA-TR*     AND   AT.CODE_ACCT_STAT  = 'A'                                      
MFA-TR*     AND   DATE_UTIL_SVC_STRT > :WS-LAST-RUN-DATE                        
MFA-TR*     ORDER BY CU.CUSTOMER_NO                                             
MFA-TR*     FOR FETCH ONLY WITH UR                                              
MFA-TR*    END-EXEC.                                                            
      *****************************************************************         
       LINKAGE SECTION.                                                 
       01 WS-PARM-CARD.                                                 
          05 WS-CHKBYTE               PIC S9(04) COMP.                  
          05 WS-PARM-COMPANY          PIC  X(01).                       
                                                                        
      ******************************************************************        
      *PROCEDURE DIVISION.                                             *        
      ******************************************************************        
       PROCEDURE DIVISION     USING   WS-PARM-CARD.                     
                                                                        
       0000-MAINLINE.                                                   
                                                                        
            PERFORM 0100-INITIALIZATION-PARA   THRU  0100-EXIT.         
            PERFORM 2000-PROCESS-COMM-RESD     THRU  2000-EXIT.         
            PERFORM 6000-UPDATE-TIME-STAMP     THRU  6000-EXIT.         
            PERFORM 9000-TERMINATE             THRU  9000-EXIT.         
            STOP RUN.                                                   
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  0100-INTIALZATION-PARA.                                       *        
      ******************************************************************        
       0100-INITIALIZATION-PARA.                                        
                                                                        
           OPEN OUTPUT OFACCSR-FILE.                                    
           OPEN OUTPUT OFACCSRB-FILE.                                   
           PERFORM 0200-LAST-RUN-DATE         THRU  0200-EXIT.          
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  2000-PROCESS-COMM-RESD.                                       *        
      ******************************************************************        
       2000-PROCESS-COMM-RESD.                                          
                                                                        
            MOVE    WS-PARM-COMPANY             TO   F-PREFIX.          
            PERFORM 5000-POPULATE-HEADERS      THRU  5000-EXIT.         
            PERFORM 7200-OPEN-BASE-CSR         THRU  7200-EXIT.         
            PERFORM 7210-FETCH-BASE-CSR        THRU  7210-EXIT.         
            PERFORM 5100-PROCESS-CSR           THRU  5100-EXIT          
                                               UNTIL NO-MORE-RECORDS.   
            PERFORM 7220-CLOSE-BASE-CSR        THRU  7220-EXIT.         
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
ACT191******************************************************************        
ACT191*   4025-DETERMINE-ADDRESS                                    *           
ACT191******************************************************************        
ACT191     EXEC SQL                                                             
ACT191         INCLUDE CPD00074                                                 
ACT191     END-EXEC.                                                            
      ******************************************************************        
      *  5000-POPULATE-HEADERS.                                        *        
      ******************************************************************        
       5000-POPULATE-HEADERS.                                           
                                                                        
           MOVE WS-HEADING-LINES               TO WS-PRT33-RECORD.      
                                                                        
           MOVE 1                              TO WS-REPORT-TYPE.       
           PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT.          
                                                                        
           MOVE WS-HEADING-LINES               TO WS-PRT33-RECORD.      
           MOVE 2                              TO WS-REPORT-TYPE.       
           PERFORM 8000-WRITE-REPORT           THRU 8000-EXIT.          
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  5100-PROCESS-CSR.                                             *        
      ******************************************************************        
       5100-PROCESS-CSR.                                                
                                                                        
             PERFORM 5200-PROCESS-BASE-CSR     THRU  5200-EXIT.         
             PERFORM 7210-FETCH-BASE-CSR       THRU  7210-EXIT.         
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  5200-PROCESS-BASE-CSR.                                        *        
      ******************************************************************        
                                                                        
       5200-PROCESS-BASE-CSR.                                           
                IF CU-CUSTOMER-NO = WS-PRE-CUST-NO                      
ACT191                IF (AT-ACCOUNT-TYPE-CODE = 'C' OR 'I')            
                         ADD     1                 TO   WS-COMM-IND     
                      ELSE                                              
ACT191                  IF AT-ACCOUNT-TYPE-CODE = 'R'                   
                         ADD     1                 TO   WS-RES-IND      
                        END-IF                                          
                      END-IF                                            
                ELSE                                                    
                      IF WS-RES-IND > 0                                 
                         PERFORM 5300-GET-NAMES   THRU 5300-EXIT        
                         MOVE           0         TO   WS-RES-IND       
                         MOVE           0         TO   WS-COMM-IND      
                      ELSE                                              
                         IF WS-COMM-IND > 0                             
                         PERFORM 5300-GET-NAMES   THRU 5300-EXIT        
                         MOVE           0         TO   WS-RES-IND       
                         MOVE           0         TO   WS-COMM-IND      
                         END-IF                                         
                      END-IF                                            
ACT191                IF (AT-ACCOUNT-TYPE-CODE = 'C' OR 'I')            
                         ADD     1                 TO  WS-COMM-IND      
ACT191                   MOVE  CU-CUSTOMER-NO      TO  WS-PRE-CUST-NO   
                      ELSE                                              
ACT191                  IF AT-ACCOUNT-TYPE-CODE = 'R'                   
                         ADD     1                 TO  WS-RES-IND       
ACT191                   MOVE  CU-CUSTOMER-NO      TO  WS-PRE-CUST-NO   
                        END-IF                                          
                      END-IF                                            
                END-IF.                                                 
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  5300-GET-NAMES.                                               *        
      ******************************************************************        
                                                                        
       5300-GET-NAMES.                                                  
                                                                        
ACT191       MOVE '5300'                        TO WS-ACTIVE-PARAGRAPH. 
ACT191       PERFORM  4000-MAIL-NAME-ADDRESS        THRU  4000-EXIT     
ACT191       IF WS-FMT-LAST-NAME > SPACES                               
ACT191          MOVE  CU-CUSTOMER-NO         TO F-CUSTOMER-NO           
A02062          MOVE           1             TO WS-REPORT-TYPE          
ACT191          MOVE  WS-FMT-FIRST-NAME      TO F-FIRST-NAME            
ACT191          PERFORM  5500-WRITE-DATA-LINE       THRU  5500-EXIT     
A02062       ELSE                                                       
ACT191          MOVE  CU-CUSTOMER-NO         TO F-CUSTOMER-NO           
A02062          MOVE           2             TO WS-REPORT-TYPE          
ACT191          MOVE  WS-FMT-SALUTATION-NAME TO F-FIRST-NAME            
ACT191          PERFORM  5500-WRITE-DATA-LINE       THRU  5500-EXIT     
ACT191       END-IF.                                                    
                                                                        
       5300-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  5500-WRITE-DATA-LINE.                                         *        
      ******************************************************************        
ACT191 5500-WRITE-DATA-LINE.                                            
ACT191       MOVE  WS-FMT-MIDDLE-NAME      TO  F-MIDDLE-NAME.           
ACT191       MOVE  WS-FMT-LAST-NAME        TO  F-LAST-NAME.             
ACT191       MOVE  WS-MAIL-ADDR-STREET     TO  F-NAME-STREET.           
ACT191       MOVE  WS-CITY                 TO  F-CITY.                  
ACT191       MOVE  WS-STATE                TO  F-STATE.                 
ACT191       IF WS-FRE-ADDR-COUNTRY  > SPACES                           
ACT191          MOVE  WS-FRE-ADDR-COUNTRY  TO  F-COUNTRY                
ACT191       ELSE                                                       
ACT191          MOVE  'USA'                TO  F-COUNTRY                
ACT191       END-IF.                                                    
             MOVE  WS-DATA-LINE            TO  WS-PRT33-RECORD.         
             PERFORM 8000-WRITE-REPORT     THRU 8000-EXIT.              
                                                                        
       5500-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  6000-UPDATE-TIME-STAMP.                                       *        
      ******************************************************************        
       6000-UPDATE-TIME-STAMP.                                          
                                                                        
            PERFORM 6100-GET-NEW-RUN-DATE       THRU 6100-EXIT.         
            MOVE WS-CURRENT-DATE                TO   WS-NEW-RUN-DATE.   
            MOVE WS-PARM-DATA                   TO   G6-PARM-DATA.      
            PERFORM 6200-UPDATE-JOB-PARM        THRU 6200-EXIT.         
                                                                        
       6000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  6010-REDUCE-EMBEDDED-SPACES                                            
      ******************************************************************        
ACT191      EXEC SQL                                                            
ACT191         INCLUDE CPD00004                                                 
ACT191      END-EXEC.                                                           
      ******************************************************************        
      *  6100-GET-NEW-RUN-DATE.                                        *        
      ******************************************************************        
                                                                        
       6100-GET-NEW-RUN-DATE.                                           
                                                                        
            EXEC SQL                                                    
T35434         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA075 ABORT **************'        
              DISPLAY '*        6100-GET-NEW-RUN-DATE         *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA075  ABORT *************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       6100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  6200-UPDATE-JOB-PARM.                                         *        
      ******************************************************************        
                                                                        
       6200-UPDATE-JOB-PARM.                                            
                                                                        
            EXEC SQL                                                    
              UPDATE CSS_JOB_PARM                                       
              SET    PARM_DATA = :G6-PARM-DATA                          
              WHERE  CMND_CODE = 'DATE'                                 
              AND    COMPANY_NO = '01'                                  
              AND    PROGRAM_NAME = :WS-PGRMNAME                        
              AND    STATUS = 'A'                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA075 ABORT **************'        
              DISPLAY '*        6200-UPDATE-JOB-PARM          *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA075  ABORT *************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       6200-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  0200-LAST-RUN-DATE.                                           *        
      ******************************************************************        
       0200-LAST-RUN-DATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT PARM_DATA                                          
              INTO   :G6-PARM-DATA                                      
              FROM   CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  CMND_CODE    = 'DATE'                              
              AND    COMPANY_NO   = '01'                                
              AND    PROGRAM_NAME = :WS-PGRMNAME                        
              AND    STATUS = 'A'                                       
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PARM_DATA                                                  
MFA-TR*       INTO   :G6-PARM-DATA                                              
MFA-TR*       FROM   CSS_JOB_PARM                                               
MFA-TR*       WHERE  CMND_CODE    = 'DATE'                                      
MFA-TR*       AND    COMPANY_NO   = '01'                                        
MFA-TR*       AND    PROGRAM_NAME = :WS-PGRMNAME                                
MFA-TR*       AND    STATUS = 'A'                                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO       WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA075 ABORT **************'       
               DISPLAY '*        0200-LAST-RUN-DATE            *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA075 ABORT **************'       
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
           MOVE G6-PARM-DATA(10:10)             TO   WS-LAST-RUN-DATE.  
                                                                        
       0200-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7200-OPEN-BASE-CSR                                            *        
      ******************************************************************        
       7200-OPEN-BASE-CSR.                                              
                                                                        
           EXEC SQL                                                     
              OPEN BASE_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA075 ABORT **************'        
              DISPLAY '*        7200-OPEN-BASE-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA075  ABORT *************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7210-FETCH-BASE-CSR                                           *        
      ******************************************************************        
       7210-FETCH-BASE-CSR.                                             
                                                                        
           EXEC SQL                                                     
              FETCH BASE_CSR                                            
              INTO :CU-CUSTOMER-NO                                      
                  ,:AT-ACCOUNT-NO                                       
ACT191            ,:AT-PREMISE-NO                                       
ACT191            ,:AT-ADDRESS-ID                                       
ACT191            ,:AT-ADDRESS-FORMAT                                   
ACT191            ,:AT-ACCOUNT-TYPE-CODE                                
                  ,:CU-NAME-ID                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO  WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE         EQUAL NOT-FOUND          
                 MOVE 'Y'                      TO WS-NO-MORE-RECORDS    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA075 ABORT **************'        
              DISPLAY '*       7210-FETCH-BASE-CSR            *'        
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
ACT191        DISPLAY '* CUSTOMER-NO    : ' CU-CUSTOMER-NO              
ACT191        DISPLAY '* ACCOUNT-NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* PROGRAM ABORTING...                  *'        
              DISPLAY '********** PCSCA075 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  7220-CLOSE-BASE-CSR                                           *        
      ******************************************************************        
       7220-CLOSE-BASE-CSR.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE BASE_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE       SQLCODE                 TO WS-ACTIVE-RETURN-CODE.
                                                                        
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
            ELSE                                                        
               DISPLAY '********** PCSCA075 ABORT **************'       
               DISPLAY '*       7220-CLOSE-BASE-CSR            *'       
               DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '* PROGRAM ABORTING...                  *'       
               DISPLAY '********** PCSCA075  ABORT *************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7220-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  8000-WRITE-REPORT                                             *        
      ******************************************************************        
                                                                        
       8000-WRITE-REPORT.                                               
            EVALUATE WS-REPORT-TYPE                                     
             WHEN 1                                                     
                WRITE  OFACCSR-RECORD  FROM      WS-PRT33-RECORD        
                INITIALIZE WS-PRT33-RECORD                              
             WHEN 2                                                     
                WRITE  OFACCSRB-RECORD FROM      WS-PRT33-RECORD        
                INITIALIZE WS-PRT33-RECORD                              
           END-EVALUATE.                                                
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      *  9000-TERMINATE                                                *        
      ******************************************************************        
       9000-TERMINATE.                                                  
                                                                        
           CLOSE  OFACCSR-FILE.                                         
           CLOSE  OFACCSRB-FILE.                                        
                                                                        
       9000-EXIT.                                                       
            EXIT.                                                       
ACT191****************************************************************          
ACT191**  9100-DISPLAY-ERROR.                                        *          
ACT191**       DISPLAY ERROR PARA                                    *          
ACT191****************************************************************          
ACT191                                                                  
ACT191 9100-DISPLAY-ERROR.                                              
ACT191     DISPLAY '**   PROCESSING ERROR IN PCSCA075  **'.             
ACT191     DISPLAY '**   ERROR AT ', WS-ACTIVE-PARAGRAPH.               
ACT191     DISPLAY '**   ABENDING PROGRAM              **'.             
ACT191     PERFORM 9900-ABEND              THRU 9900-EXIT.              
ACT191 9100-EXIT.                                                       
ACT191     EXIT.                                                        
ACT191***********************************************************               
ACT191* 9700-PROCESS-ABEND                                                      
ACT191***********************************************************               
ACT191 COPY CPD0023B.                                                           
                                                                        
      ******************************************************************        
      * 9900-PROCESS-ABEND                                             *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPD09900                                                
           END-EXEC.                                                            
      ******************************************************************        
