       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA041.                                        
       AUTHOR.         SCANA SERVICES.                                  
       DATE-WRITTEN.   AUG 2005.                                        
      ***************************************************************** 00040000
      ******** READ FILE FROM EQUIFAX CONTAINING ACCT REVIEW      ***** 00110000
      ******** CREDIT SCORES.                                     ***** 00110000
      ***************************************************************** 00130000
      *                                                             **  00140000
      *              PROGRAM  MODIFICATION  LOG                     **  00150000
      *    DATE    INITIALS     REASON                              **  00160000
      *    ----    --------     ------                              **  00170000
      ** 09/16/2005 MJ13662   INITIAL PROGRAM VERSION               **  00180000
PRO773*  09/12/2013 MJ13662   UPDATE SOURCE-CD W/ 'E'.              **          
P00951*  04/22/2016 MJ13662   FOR SCANA DEREG, UPDATE ADDL-CRED-SCORE*          
P00951*                       (AEP) SENT FROM EQUIFAX.              **          
      ****************************************************************  00184300
      *                                                                 00185000
      *REMARKS.                                                         00186000
      *         COMPONENT PCSCA041 READS FILE FROM EQUIFAX CONTAINING   00187000
      *         ACCOUNT REVIEW BEACON SCORES.                           00188000
      ***************************************************************** 00330000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                 00370000
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                 00400000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSRP041.                                                           
HPCCDM*EJECT                                                            00460000
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP041.                                                           
       COPY FIORP041.                                                           
HPCCDM*EJECT                                                            00510000
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA041'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                        PIC X(45)                    
           VALUE 'WORKING STORAGE FOR PCSCA041 STARTS HERE'.            
      *                                                                         
       01  WS-DATES.                                                    
           05  WS-JOB-PARM                 PIC X(10) VALUE SPACES.      
           05  WS-JOB-PARM-R REDEFINES WS-JOB-PARM.                     
               10  FILLER                  PIC X(02).                   
               10  WS-JOB-PARM-YEAR        PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-MONTH       PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-DAY         PIC X(02).                   
                                                                        
       01  WS-PROG-MISC.                                                
           05  WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA041'.  
           05  WS-NO-MORE-DATA             PIC X(01) VALUE 'N'.         
               88  NO-MORE-DATA                      VALUE 'Y'.         
           05  WS-PREV-PROC-CUST           PIC 9(10) VALUE ZEROES.      
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA041'.  
           05  WS-FRP041-STATUS            PIC X(02).                   
               88  FRP041-SUCCESSFUL       VALUE '00'.                  
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-RESTART-RECORD.                                       
               10  WS-RFFA01-07-SORT-KEY   PIC X(23).                   
               10  FILLER                  PIC X(7525).                 
           05  WS-NULL-IND1                PIC S9(04) COMP VALUE 0.     
           05  WS-RESTART-SW               PIC X(1)  VALUE 'N'.         
           05  WS-CUST-NO-NUM              PIC 9(10).                   
COB305     05 WS-CUST-NO-COMP3        PIC S9(10)V USAGE COMP-3 VALUE 0.    
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +25.    
           05  WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
               88  WS-THIS-IS-NOT-A-RESTART          VALUE 'N'.         
           05  WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.        
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.         
           05  WS-PROCESS-TYPE           PIC 9(01).                     
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 4.           
           05  WS-SEQ-NO                 PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 20.          
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID        PIC X(02)   VALUE '09'.        
               10  WS-CHKP-PART-NO       PIC 9(01)   VALUE 1.           
               10  WS-CHKP-SEQ-NO        PIC 9(05)   VALUE ZERO.        
           05  WS-FCSRP041-REC-CNTR      PIC S9(07)  VALUE ZERO COMP-3. 
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
           05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
               WS-RESTART-PROCESS-TYPE   PIC X(01).                     
           05  WS-RESTART-JOB-STATUS     PIC X(01).                     
               88  WS-RUN-COMPLETED-NO-PROBLEMS      VALUE 'A'.         
               88  WS-RERUN-COMPLETED                VALUE 'B'.         
               88  WS-RERUN-PENDING                  VALUE 'C'.         
           05  WS-RESTART-COMMON-DATE    PIC X(10).                     
           05  WS-RESTART-CHKP-SEQ-NO    PIC 9(05).                     
           05  WS-RESTART-FCSRP041-REC-CNTR                             
                                         PIC S9(07)  COMP-3 VALUE ZERO. 
       01  WS-LITERALS.                                                 
PRO773     05  WS-E                        PIC X(01) VALUE 'E'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-S                        PIC X(01) VALUE 'S'.         
           05  WS-I                        PIC X(01) VALUE 'I'.         
           05  WS-F                        PIC X(01) VALUE 'F'.         
           05  WS-ZERO                     PIC 9(01) VALUE  0.          
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
HPCCDM*EJECT                                                            00661100
                                                                        
      ******* WS FOR 6010-REDUCE-EMBEDDED SPACES ****************       00665600
       COPY CWS00011.                                                           
                                                                        
      ******* WS FOR DB2 & CICS ERROR PROCESSING ****************       00665600
       COPY CWS00303.                                                           
                                                                        
      ******* WS-ABEND WORK AREA  ****************                      00665600
       COPY CWS00010.                                                           
                                                                        
      ******* DB2 ABEND HANDLING  ****************                      00665600
       COPY CWS00039.                                                           
                                                                        
      ******* WS-ABEND-SWITCH     ****************                      00665600
       COPY CWS09900.                                                           
                                                                        
      ******* FIOJC01 WORKING STORAGE ************                      00665600
       COPY FIOJC01.                                                            
                                                                        
      ******* FCA00-KEY           ****************                      00665600
       COPY FIOCA00.                                                            
                                                                        
           EXEC SQL                                                     00665200
                INCLUDE SQLCA                                           00665300
           END-EXEC.                                                    00665400
                                                                        
      *                                                                 PCS11040
      ******* TABLE DECLARATION FOR CSS_CREDIT_HIST  CK **************  00665600
                                                                        
           EXEC SQL                                                     00665800
                INCLUDE TBCRHIST                                        00665900
           END-EXEC.                                                    00666000
      ******* TABLE DECLARATION FOR CSS_JOB_PARM  G6  ******************00670900
      *                                                                 00671000
           EXEC SQL                                                     00671100
               INCLUDE TBJBPARM                                         00671200
           END-EXEC.                                                    00671300
      ******* WORKING STORAGE FOR WS-MISC.                                      
           EXEC SQL                                                     00682900
              INCLUDE CWS00038                                          00683000
           END-EXEC.                                                    00683100
                                                                        
      ******* TABLE DECLARATION FOR CSS_RESTART  RF                     00683200
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
                                                                        
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA041 ENDS HERE  '.            
HPCCDM*    EJECT                                                        02208000
HPCCDM*EJECT                                                            02220000
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************02250000
      *                                                                *02260000
      *   0000-MAINLINE.                                               *02270000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *02280000
      *                                                                *02290000
      ******************************************************************02300000
       0000-MAINLINE.                                                   
      *                                                                 02320000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS        THRU 1000-EXIT.                  
           PERFORM 9000-TERMINATE      THRU 9000-EXIT.                  
      *                                                                 02440000
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-PGRMNAME                TO G6-PROGRAM-NAME        
              MOVE WS-PARM                    TO G6-CMND-CODE           
              MOVE WS-SEQ-NO                  TO G6-SEQ-NO              
              MOVE WS-I                       TO G6-STATUS              
              MOVE 'RESTART-REQ=N'            TO G6-PARM-DATA           
              PERFORM 8940-RESET-JOB-PARM     THRU 8940-EXIT            
      *                                                                         
              MOVE WS-B                          TO                     
                                                   WS-RESTART-JOB-STATUS
              DISPLAY 'PCSCA041 RERUN COMPLETED'                        
           ELSE                                                         
              MOVE WS-A                          TO                     
                                                   WS-RESTART-JOB-STATUS
              DISPLAY 'PCSCA041 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
      *                                                                         
           IF RETURN-CODE = 0                                           
               PERFORM 8890-DELETE-RESTART-RECORD THRU 8890-EXIT        
           END-IF.                                                      
      *                                                                         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02500000
      *                                                                *02510000
      *   0100-INITIALIZATION                                          *02520000
      *        COMMON INITIALIZATION ROUTINE                           *02530000
      *                                                                *02540000
      ***************************************************************** 02550000
                                                                        
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-SYSIPT                                         
              PERFORM 6235-GET-FJC01-RESTART-REQ                        
                                                 THRU 6235-EXIT.        
              MOVE G6-SEQ-NO TO WS-SEQ-NO.                              
                                                                        
           INITIALIZE WS-SYSIPT                                         
              PERFORM 6253-GET-FJC01-CHKP-LIMIT                         
                                                 THRU 6253-EXIT.        
           OPEN INPUT FCSRP041-FILE.                                    
           IF FRP041-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSRP041 OPEN.  STATUS IS '       
                        WS-FRP041-STATUS                                
               MOVE 12 TO RETURN-CODE                                   
               STOP RUN                                                 
           END-IF.                                                      
                                                                        
           PERFORM 0200-CHECK-RESTART            THRU 0200-EXIT.        
      *                                                                         
           PERFORM 0300-PREPARE-RESTART          THRU 0300-EXIT.        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE           TO WS-JOB-PARM                  
                                           CK-ACCT-REVIEW-RET-DT.       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   0200-CHECK-RESTART                                           *        
      *                                                                *        
      *        CHECK CSS_RESTART TABLE TO SEE IF THIS IS A RESTART OR  *        
      *   A NORMAL RUN.  IF A ROW IS FOUND IN THIS TABLE FOR PROGRAM   *        
      *   PCSCA041, THE RESTART LOGIC IS EXECUTED.  OTHERWISE, NORMAL  *        
      *   PROCESSING IS FOLLOWED.                                      *        
      ******************************************************************        
                                                                        
       0200-CHECK-RESTART.                                              
                                                                        
           MOVE 'PCSCA041'                   TO RF-NAME-PROGRAM.        
           MOVE 1                            TO RF-PARTITION-NO         
                                                WS-CHKP-PART-NO.        
           MOVE 1                            TO RF-DUP-CNTRL-NO.        
                                                                        
           PERFORM 7100-SELECT-RESTART          THRU 7100-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT         TO WS-RESTART-DATA     
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                      TO WS-IS-THIS-A-RESTART
               END-IF                                                   
           END-IF.                                                      
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0300-PREPARE-RESTART.                                                   
      ******************************************************************        
      *                                                                         
       0300-PREPARE-RESTART.                                            
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-RESTART-FCSRP041-REC-CNTR  TO                     
                                                 WS-FCSRP041-REC-CNTR   
              DISPLAY '*******************************************'     
              DISPLAY '*****   THIS IS A RESTART OF PCSCA041   ***'     
              DISPLAY '*******************************************'     
              MOVE WS-RESTART-CHKP-SEQ-NO        TO WS-CHKP-SEQ-NO      
              PERFORM WS-FCSRP041-REC-CNTR TIMES                        
                READ FCSRP041-FILE                                      
                    AT END MOVE WS-Y TO WS-NO-MORE-DATA                 
                END-READ                                                
                IF NOT FRP041-SUCCESSFUL                                
                    DISPLAY '**   PCSCA041 PROCESSING ERROR  **'        
                    DISPLAY '**   FCSRP041-FILE WILL NOT READ**'        
                    DISPLAY '**   STATUS IS ' WS-FRP041-STATUS          
                    DISPLAY '**   0300-PREPARE-RESTART       **'        
                    DISPLAY '**    PROCESSING TERMINATED     **'        
                    PERFORM 9900-ABEND       THRU 9900-EXIT             
                END-IF                                                  
              END-PERFORM                                               
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
       COPY CPD00030.                                                           
      *                                                                         
      ******************************************************************02920000
      * READS THE INPUT FILE FROM EQUIFAX.                             *        
      ******************************************************************02920000
       1000-PROCESS.                                                    
                                                                        
           PERFORM 7010-READ-FCSRP041 THRU 7010-EXIT.                   
           IF NO-MORE-DATA                                              
               DISPLAY '**   PCSCA041 PROCESSING ERROR  **'             
               DISPLAY '**   FCSRP041-FILE IS EMPTY     **'             
               DISPLAY '**   1000-PROCESS               **'             
               PERFORM 9900-ABEND       THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
           PERFORM 2000-PROCESS-RECORDS   THRU 2000-EXIT                
               UNTIL NO-MORE-DATA.                                      
      *                                                                 03060000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03090000
HPCCDM*EJECT                                                            03100000
      ***************************************************************           
      **    PREPARE-BEFORE COMMIT**                                             
      ***************************************************************           
       1800-PREPARE-PRECOMMIT.                                          
                                                                        
            MOVE 1                               TO                     
                                           WS-RESTART-PROCESS-TYPE.     
            MOVE WS-C                            TO                     
                                           WS-RESTART-JOB-STATUS.       
            MOVE WS-INPUT-DATE                   TO                     
                                           WS-RESTART-COMMON-DATE.      
            ADD  1                               TO  WS-CHKP-SEQ-NO.    
            MOVE WS-CHKP-SEQ-NO                  TO                     
                                           WS-RESTART-CHKP-SEQ-NO.      
            MOVE WS-FCSRP041-REC-CNTR            TO                     
                                           WS-RESTART-FCSRP041-REC-CNTR.
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03120000
      *                                                                *03130000
      *       2000-PROCESS-RECORDS.                                    *03140000
      *                                                                *03150000
      *  PROCESSES EACH RECORD TO UPDATE TABLE.                        *03160000
      *                                                                *03180000
      ******************************************************************03190000
       2000-PROCESS-RECORDS.                                            
                                                                        
           PERFORM 8100-UPD-CRED-HIST        THRU 8100-EXIT.            
           IF WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR          
              WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT             
              PERFORM 8888-COMMIT                THRU 8888-EXIT         
              MOVE ZEROES                        TO                     
                                              WS-RESTART-COMMIT-COUNTER
           END-IF.
                                                                        
           PERFORM 7010-READ-FCSRP041        THRU 7010-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * 6235-GET-FJC01-RESTART-REQ.                                             
      **************************************************************            
           EXEC SQL                                                             
               INCLUDE CPD00035                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ** 6240-GET-FCA00-COMMON-DATE                                             
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00040                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** 6251-GET-FJC01-DATE                                         **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *          
      ****************************************************************          
            EXEC SQL                                                            
                INCLUDE CPD00034                                                
            END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  7010-READ-FCSRP041                                           *         
      ***************************************************************** 15025444
       7010-READ-FCSRP041.                                              
                                                                        
           READ FCSRP041-FILE                                           
               AT END                                                   
                 MOVE WS-Y TO WS-NO-MORE-DATA                           
                 GO TO 7010-EXIT.                                       
                                                                        
           IF NOT FRP041-SUCCESSFUL                                     
               DISPLAY '**   PCSCA041 PROCESSING ERROR  **'             
               DISPLAY '**   FCSRP041-FILE WILL NOT READ**'             
               DISPLAY '**   STATUS IS ' WS-FRP041-STATUS               
               DISPLAY '**   0710-READ-FIORP041         **'             
               DISPLAY '**    PROCESSING TERMINATED     **'             
               PERFORM 9900-ABEND       THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
           ADD 1 TO WS-FCSRP041-REC-CNTR                                
                    WS-RESTART-COMMIT-COUNTER.                          
                                                                        
           MOVE E-RP041-CUSTOMER-NO   TO WS-CUST-NO-NUM.                
           MOVE WS-CUST-NO-NUM        TO WS-CUST-NO-COMP3.              
           MOVE WS-CUST-NO-COMP3      TO CK-CUSTOMER-NO.                
           MOVE E-RP041-TRAN-DT       TO CK-CR-HIST-TRAN-DT.            
           MOVE E-RP041-TRAN-TM       TO CK-CR-HIST-TRAN-TM.            
           MOVE E-RP041-BEACON-SCORE  TO CK-BEACON-SCORE.               
           MOVE E-RP041-HIT-IND       TO CK-ACCT-REVIEW-ACT-CD.         
           MOVE E-RP041-ADDR-DISC-IND TO CK-ADDR-DISCREP-FL.            
P00951     IF E-RP041-SUBSIDIARY = '   '                                
P00951        MOVE E-RP041-AEP-PLUS-SCORE TO CK-ADDL-CRED-SCORE         
P00951     ELSE                                                         
P00951        MOVE SPACES                 TO CK-ADDL-CRED-SCORE         
P00951     END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **                                                            **          
      **         7100-SELECT-RESTART                                **          
      **                                                            **          
      ****************************************************************          
       7100-SELECT-RESTART.                                             
      *                                                                         
           MOVE '7100'                           TO WS-ACTIVE-PARAGRAPH.
      *                                                                         
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART                                       
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
                      PARTITION_NO = :RF-PARTITION-NO AND               
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                          TO                     
                                                 WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**   ERROR ON 7100-SELECT-RESTART   **'          
              DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**       PROCESSING TERMINATED      **'          
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04850000
      *  UPDATE CSS_CREDIT_HIST.                                       *04880000
      ******************************************************************900000  
       8100-UPD-CRED-HIST.                                              
                                                                        
           IF CK-ACCT-REVIEW-RET-DT = SPACES OR = LOW-VALUES            
              MOVE -1        TO WS-NULL-IND1                            
           ELSE                                                         
              MOVE 0         TO WS-NULL-IND1                            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CREDIT_HIST                                    
                SET BEACON_SCORE         = :CK-BEACON-SCORE,            
                    ACCT_REVIEW_ACT_CD   = :CK-ACCT-REVIEW-ACT-CD,      
                    ACCT_REVIEW_RET_DT   = IIF(TRY_CONVERT(DATE, 
                                                :CK-ACCT-REVIEW-RET-DT 
                                                          :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :CK-ACCT-REVIEW-RET-DT 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:CK-ACCT-REVIEW-RET-DT :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:CK-ACCT-REVIEW-RET-DT 
                                                          :WS-NULL-IND1
              ), CONVERT(DATE, :CK-ACCT-REVIEW-RET-DT :WS-NULL-IND1) ),       
                    ADDR_DISCREP_FL      = :CK-ADDR-DISCREP-FL,         
PRO773              CREDIT_SOURCE_CD     = :WS-E                        
                WHERE CUSTOMER_NO        = :CK-CUSTOMER-NO              
                  AND CR_HIST_TRAN_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )          
                  AND CR_HIST_TRAN_TM    = CIS.CHAR2TIME(
                                                    :CK-CR-HIST-TRAN-TM
              )          
                  AND CR_RQST_REASON_CD  = :WS-B                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CREDIT_HIST                                            
MFA-TR*         SET BEACON_SCORE         = :CK-BEACON-SCORE,                    
MFA-TR*             ACCT_REVIEW_ACT_CD   = :CK-ACCT-REVIEW-ACT-CD,              
MFA-TR*             ACCT_REVIEW_RET_DT   = :CK-ACCT-REVIEW-RET-DT:              
MFA-TR*                                             WS-NULL-IND1,               
MFA-TR*             ADDR_DISCREP_FL      = :CK-ADDR-DISCREP-FL,                 
MFA-TR*             CREDIT_SOURCE_CD     = :WS-E                                
MFA-TR*         WHERE CUSTOMER_NO        = :CK-CUSTOMER-NO                      
MFA-TR*           AND CR_HIST_TRAN_DT    = :CK-CR-HIST-TRAN-DT                  
MFA-TR*           AND CR_HIST_TRAN_TM    = :CK-CR-HIST-TRAN-TM                  
MFA-TR*           AND CR_RQST_REASON_CD  = :WS-B                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8100-UPD-CRED-HIST'                           
               DISPLAY '* CUSTOMER_NO = ' CK-CUSTOMER-NO                
               DISPLAY '* CR_HIST_TRAN_DT = ' CK-CR-HIST-TRAN-DT        
               DISPLAY '* CR_HIST_TRAN_TM = ' CK-CR-HIST-TRAN-TM        
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *     8800-WRITE-RESTART                                      **          
      *                                                             **          
      ****************************************************************          
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                      TO RF-NAME-PROGRAM.    
           MOVE 1                                TO RF-PARTITION-NO.    
           MOVE 1                                TO RF-DUP-CNTRL-NO.    
           MOVE WS-RESTART-DATA                  TO                     
                                                 RF-RESTART-DATA-TEXT.  
           MOVE WS-RESTART-DATA-LENGTH           TO RF-RESTART-DATA-LEN.
                                                                        
           PERFORM 8850-UPDATE-RESTART           THRU 8850-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART        THRU 8860-EXIT         
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   8850-UPDATE-RESTART                                       **         
      **                                                            **          
      ****************************************************************          
       8850-UPDATE-RESTART.                                             
      *                                                                         
           MOVE '8850'                           TO WS-ACTIVE-PARAGRAPH.
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
               SET RESTART_DATA   = :RF-RESTART-DATA                    
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND                
                     PARTITION_NO = :RF-PARTITION-NO AND                
                     DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                          TO                     
                                                 WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                   DISPLAY '**  ERROR ON 8850-UPDATE-RESTART  **'       
                   DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
                   DISPLAY '**      PROCESSING TERMINATED     **'       
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **      8860-INSERT-RESTART                                   **          
      **                                                            **          
      ****************************************************************          
       8860-INSERT-RESTART.                                             
      *                                                                         
           MOVE '8860'                           TO WS-ACTIVE-PARAGRAPH.
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                          (NAME_PROGRAM                                 
                          ,PARTITION_NO                                 
                          ,DUP_CNTRL_NO                                 
                          ,RESTART_DATA)                                
               VALUES    (:RF-NAME-PROGRAM                              
                         ,:RF-PARTITION-NO                              
                         ,:RF-DUP-CNTRL-NO                              
                         ,:RF-RESTART-DATA)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                          TO                     
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**   ERROR ON 8860-INSERT-RESTART   **'         
               DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '**       PROCESSING TERMINATED      **'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    8888-COMMIT                                               **         
      *                                                              **         
      *****************************************************************         
       8888-COMMIT.                                                     
           PERFORM 1800-PREPARE-PRECOMMIT     THRU 1800-EXIT.           
           PERFORM 8800-WRITE-RESTART         THRU 8800-EXIT.           
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'.          
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8890-DELETE-RESTART-RECORD.                                      
           MOVE WS-PGRMNAME                      TO RF-NAME-PROGRAM.    
           MOVE 1                                TO RF-PARTITION-NO.    
           MOVE 1                                TO RF-DUP-CNTRL-NO.    
           EXEC SQL                                                     
             DELETE FROM CSS_RESTART                                    
              WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     
                AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     
                AND PARTITION_NO = :RF-PARTITION-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                          TO                     
                                                 WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  8890-DELETE-RESTART-RECORD     **'          
               DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '**       PROCESSING TERMINATED      **'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8940-RESET-JOB-PARM.                                          *         
      *****************************************************************         
       8940-RESET-JOB-PARM.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
                  SET STATUS       = :G6-STATUS,                        
                      PARM_DATA    = :G6-PARM-DATA                      
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND CMND_CODE    = :G6-CMND-CODE                      
                  AND COMPANY_NO   = :G6-COMPANY-NO                     
                  AND SEQ_NO       = :G6-SEQ-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                          TO                     
                                                 WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN 8940-RESET-JOB-PARM ***'            
              DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '***   PROCESSING TERMINATED ***'                 
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       8940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05990000
      *                                                                *06000000
      *   9000-CLOSE-FILES.                                            *06010000
      *                                                                *06020000
      ******************************************************************06030000
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSRP041-FILE.                                         
           IF FRP041-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA041 PROCESSING ERROR   **'           
               DISPLAY '**   FCSRP041-FILE WILL NOT CLOSE **'           
               DISPLAY '**      PARA - 9000-TERMINATE     **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ** 9700-PROCESS-ABEND.                                         **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** 9900-ABEND.                                                 **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     06330000
               INCLUDE CPD09900                                         06340000
           END-EXEC.                                                    06350000
