       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA040.                                        
       AUTHOR.         SCANA SERVICES.                                  
       DATE-WRITTEN.   AUG 2005.                                        
      ***************************************************************** 00040000
      ******** GENERATE FILE FOR ACCOUNT REVIEW.                  ***** 00110000
      ******** REGULATED AND DEREGULATED ACCOUNTS - SEB ONLY      ***** 00110000
      ********                      DB2                           ***** 00120000
      ***************************************************************** 00130000
      *                                                             **  00140000
      *              PROGRAM  MODIFICATION  LOG                     **  00150000
      *    DATE    INITIALS     REASON                              **  00160000
      *    ----    --------     ------                              **  00170000
      ** 08/24/2005 MJ13662   INITIAL PROGRAM VERSION               **  00180000
T35434** 05/15/2007 SP94986   REPLACED MODEL_SQL TO SET COMMANDS.   **  00180000
C36013** 02/15/2008 MJ13662   ADD CHANGES FOR DECISION TREE.        **          
C36013**                      UPDATE FIELDS SENT TO EQUIFAX:        **          
C36013**                        FIRST-NAME, MIDDLE-NAME, LAST NAME, **          
C36013**                        TITLE-SUFFIX-1, AND SSN.            **          
C36013**                        CONTINUE MOVING NAME INFORMATION TO **          
C36013**                        NAME FIELDS THAT NORMALLY CONTAIN   **          
C36013**                        NAMES RECEIVED FROM EQUIFAX.        **          
P00951** 04/22/2016 MJ13662   MOVE SPACES TO CK-ADDL-CRED-SCORE     **          
      ****************************************************************  00184300
      *                                                                 00185000
      *REMARKS.                                                         00186000
      *         COMPONENT PCSCA040 PRODUCES EXTRACT FILE                00187000
      *         WHICH IS USED TO REQUEST CREDIT SCORES BASED FOR AN     00188000
      *         ACCOUNT REVIEW.                                         00189000
      ***************************************************************** 00330000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
      *                                                                 00370000
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                 00400000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSRP040.                                                           
       COPY CSSRP04R.                                                           
HPCCDM*EJECT                                                            00460000
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDRP040.                                                           
       COPY FIORP040.                                                           
       COPY CFDRP04R.                                                           
       COPY FIORP04R.                                                           
HPCCDM*EJECT                                                            00510000
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA040'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                        PIC X(45)                    
           VALUE 'WORKING STORAGE FOR PCSCA040 STARTS HERE'.            
      *                                                                         
       01  WS-DATES.                                                    
           05  WS-JOB-PARM                 PIC X(10) VALUE SPACES.      
           05  WS-JOB-PARM-R REDEFINES WS-JOB-PARM.                     
               10  FILLER                  PIC X(02).                   
               10  WS-JOB-PARM-YEAR        PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-MONTH       PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-JOB-PARM-DAY         PIC X(02).                   
           05  WS-LAST-SENT-CMPDT          PIC X(10).                   
                                                                        
       01  SCSCB068                        PIC X(08)  VALUE 'SCSCB068'. 
                                                                        
       01  WS-PROG-MISC.                                                
           05  WS-SYSTEM                   PIC X(06) VALUE 'SYSTEM'.    
           05  PROGRAM-NAME                PIC X(08) VALUE 'PCSCA040'.  
           05  WS-RECENT-REVIEW            PIC X(01) VALUE SPACES.      
           05  WS-PREV-PROC-CUST           PIC 9(10) VALUE ZEROES.      
           05  WS-PGRMNAME                 PIC X(08) VALUE 'PCSCA040'.  
           05  WS-FIRST-NAME-DQ            PIC X(15) VALUE SPACES.      
           05  WS-MIDDLE-NAME-DQ           PIC X(15) VALUE SPACES.      
           05  WS-LAST-NAME-DQ             PIC X(20) VALUE SPACES.      
           05  WS-TITLE-SUFFIX-1-DQ        PIC X(03) VALUE SPACES.      
           05  WS-MAX-LEN                  PIC S9(4) COMP.              
           05  WS-VARCHAR                  PIC X(255).                  
           05  FILLER REDEFINES WS-VARCHAR.                             
               10 WS-VARCHAR-POS           PIC X(01) OCCURS 255.        
           05  WS-VARCHAR-LEN              PIC S9(4) COMP.              
           05  WS-TIMESTAMP                PIC X(26) VALUE SPACES.      
           05  WS-TIMESTAMP-RED REDEFINES WS-TIMESTAMP.                 
               10  WS-TS-DATE              PIC X(11).                   
               10  WS-TS-TIME              PIC X(08).                   
               10  WS-FILLER               PIC X(07).                   
           05  WS-TRAN-APPL-NO             PIC S9(04) COMP VALUE 0.     
           05  WS-FRP040-STATUS            PIC X(02).                   
               88  FRP040-SUCCESSFUL       VALUE '00'.                  
           05  WS-FCSRP04R-STATUS            PIC X(02).                 
               88  FCSRP04R-SUCCESSFUL       VALUE '00'.                
               88  FCSRP04R-END-OF-FILE      VALUE '10'.                
           05  WS-END-OF-ROWS              PIC X(01) VALUE 'N'.         
               88  END-OF-ROWS             VALUE 'Y'.                   
           05  VALID-ROW-EXIST-FLAG        PIC X(01) VALUE 'N'.         
               88  VALID-ROW-EXIST         VALUE 'Y'.                   
           05  WS-NAME-FOUND-FLAG          PIC X(01) VALUE 'Y'.         
               88  WS-NAME-FOUND                     VALUE 'Y'.         
           05  WS-INDEX                    PIC 9(02) VALUE 0.           
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-DATABASE-CD              PIC X(20) VALUE              
                                           'DATABASE            '.      
           05  WS-DATABASE                 PIC 9(01) VALUE 0.           
               88  CSR-DATABASE                      VALUE 1.           
               88  SEB-DATABASE                      VALUE 2.           
           05  WS-AMT-AR-PD-REG-CD         PIC X(20) VALUE              
                                           'AMT-AR-PASTDUE-REG  '.      
           05  WS-AMT-AR-PD-DEREG-CD       PIC X(20) VALUE              
                                           'AMT-AR-PASTDUE-DEREG'.      
           05  WS-AMT-AR-PD-REG            PIC X(9).                    
           05  WS-AMT-AR-PD-REG-NUM   REDEFINES WS-AMT-AR-PD-REG        
                                           PIC 9(7)V99.                 
           05  WS-AMT-AR-PD-REG-COMP3      PIC S9(7)V99 COMP-3          
                                                     VALUE ZERO.        
           05  WS-AMT-AR-PD-DEREG          PIC X(9).                    
           05  WS-AMT-AR-PD-DEREG-NUM REDEFINES WS-AMT-AR-PD-DEREG      
                                           PIC 9(7)V99.                 
           05  WS-AMT-AR-PD-DEREG-COMP3    PIC S9(7)V99 COMP-3          
                                                     VALUE ZERO.        
           05  WS-ALPHA-PASTDUE            PIC X(9).                    
           05  WS-NUM-PASTDUE        REDEFINES WS-ALPHA-PASTDUE         
                                           PIC 9(7)V99.                 
           05  WS-ACCT-REVDAYS-CD          PIC X(20) VALUE              
                                           'ACCT-REV-DAYS       '.      
           05  WS-ACCT-REVDAYS             PIC S9(05) COMP-3 VALUE +0.  
           05  WS-RESTART-RECORD.                                       
               10  WS-RFFA01-07-SORT-KEY   PIC X(23).                   
               10  FILLER                  PIC X(7525).                 
           05  WS-FCSRP04R-EOF             PIC X(01)  VALUE 'N'.        
               88  FCSRP04R-EOF                      VALUE 'Y'.         
           05  WS-RESTART-SW               PIC X(1)  VALUE 'N'.         
           05  WS-DATA-FOUND               PIC X(1)  VALUE 'Y'.         
           05  WS-RED-FL-NULL-IND          PIC S9(4) COMP  VALUE 0.     
           05  WS-END-NULL-IND             PIC S9(4) COMP  VALUE 0.     
           05  WS-NULL-TRAN-DT             PIC S9(04) COMP VALUE 0.     
           05  WS-FFA00-REC-CNTR           PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-FFA00-SEQ-NO             PIC S9(07) COMP-3 VALUE ZERO.
           05  WS-HOME-PHONE-NO            PIC X(10) VALUE SPACES.      
           05  WS-WORK-PHONE-NO            PIC X(10) VALUE SPACES.      
                                                                        
       01  WS-RESTART-MISC.                                             
           05  WS-RESTART-DATA-LENGTH    PIC S9(04)  COMP VALUE +25.    
           05  WS-IS-THIS-A-RESTART      PIC X(01)   VALUE 'N'.         
               88  WS-THIS-IS-A-RESTART              VALUE 'Y'.         
               88  WS-THIS-IS-NOT-A-RESTART          VALUE 'N'.         
           05  WS-RESTART-COMMIT-COUNTER PIC 9(04)   VALUE ZERO.        
           05  WS-RESTART-REQ            PIC X(01).                     
           05  WS-DEFAULT-RESTART-REQ    PIC X(01)   VALUE 'N'.         
           05  WS-PROCESS-TYPE           PIC 9(01).                     
           05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04)   VALUE 4.           
           05  WS-SEQ-NO                 PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-LUW-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-LUW-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-DEFAULT-CHKP-UPD-LIMIT PIC 9(04)   VALUE 20.          
           05  WS-CHKP-UPD-LIMIT         PIC 9(04)   VALUE ZERO.        
           05  WS-CHKP-UPD-COUNTER       PIC 9(04)   VALUE ZERO COMP-3. 
           05  WS-CHKP-ID.                                              
               10  WS-CHKP-PGM-ID        PIC X(02)   VALUE '09'.        
               10  WS-CHKP-PART-NO       PIC 9(01)   VALUE 1.           
               10  WS-CHKP-SEQ-NO        PIC 9(05)   VALUE ZERO.        
           05  WS-FCSRP040-REC-CNTR      PIC S9(07)  VALUE ZERO COMP-3. 
      *                                                                         
       01  WS-RESTART-DATA.                                             
           05  WS-RESTART-PROCESS-TYPE   PIC 9(01).                     
           05  WS-RESTART-JOB-COMPLETE   REDEFINES                      
               WS-RESTART-PROCESS-TYPE   PIC X(01).                     
           05  WS-RESTART-JOB-STATUS     PIC X(01).                     
               88  WS-RUN-COMPLETED-NO-PROBLEMS      VALUE 'A'.         
               88  WS-RERUN-COMPLETED                VALUE 'B'.         
               88  WS-RERUN-PENDING                  VALUE 'C'.         
           05  WS-RESTART-COMMON-DATE    PIC X(10).                     
           05  WS-RESTART-CHKP-SEQ-NO    PIC 9(05).                     
           05  WS-RESTART-FCSRP040-REC-CNTR                             
                                         PIC S9(07)  COMP-3 VALUE ZERO. 
       01  WS-LITERALS.                                                 
           05  WS-CN                       PIC X(02) VALUE 'CN'.        
           05  WS-SEB                      PIC X(03) VALUE 'SEB'.       
           05  WS-1                        PIC X(1)  VALUE '1'.         
           05  WS-N                        PIC X(01) VALUE 'N'.         
           05  WS-80                       PIC S9(04) COMP VALUE +80.   
           05  WS-01                       PIC X(02) VALUE '01'.        
           05  WS-Y                        PIC X(01) VALUE 'Y'.         
           05  WS-P                        PIC X(01) VALUE 'P'.         
           05  WS-E                        PIC X(01) VALUE 'E'.         
           05  WS-S                        PIC X(01) VALUE 'S'.         
           05  WS-I                        PIC X(01) VALUE 'I'.         
           05  WS-R                        PIC X(01) VALUE 'R'.         
           05  WS-F                        PIC X(01) VALUE 'F'.         
           05  WS-ZERO                     PIC 9(01) VALUE  0.          
                                                                        
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
                                                                        
HPCCDM*EJECT                                                            00661100
                                                                        
      ******* WS FOR 4000-MAIL-NAME-ADDRESS *********************       00665600
       COPY CWS00074.                                                           
                                                                        
      ******* WS FOR 6010-REDUCE-EMBEDDED SPACES ****************       00665600
       COPY CWS00011.                                                           
                                                                        
      ******* WS FOR DB2 & CICS ERROR PROCESSING ****************       00665600
       COPY CWS00303.                                                           
                                                                        
      ******* WS-ABEND WORK AREA  ****************                      00665600
       COPY CWS00010.                                                           
                                                                        
      ******* DB2 ABEND HANDLING  ****************                      00665600
       COPY CWS00039.                                                           
                                                                        
      ******* WS-ABEND-SWITCH     ****************                      00665600
       COPY CWS09900.                                                           
                                                                        
      ******* FIOJC01 WORKING STORAGE ************                      00665600
       COPY FIOJC01.                                                            
                                                                        
      ******* FCA00-KEY           ****************                      00665600
       COPY FIOCA00.                                                            
                                                                        
           EXEC SQL                                                     00665200
                INCLUDE SQLCA                                           00665300
           END-EXEC.                                                    00665400
                                                                        
      ******* TABLE DECLARATION FOR CSS_ACCOUNT  AT ******************  00665600
                                                                        
           EXEC SQL                                                     00665800
                INCLUDE TBACCT                                          00665900
           END-EXEC.                                                    00666000
      *                                                                 PCS11040
      ******* TABLE DECLARATION FOR CSS_CREDIT_HIST  CK **************  00665600
                                                                        
           EXEC SQL                                                     00665800
                INCLUDE TBCRHIST                                        00665900
           END-EXEC.                                                    00666000
      *                                                                 00666100
      ******* TABLE DECLARATION FOR CSS_CRED_HIST_ACCT  CR ***********  00665600
                                                                        
           EXEC SQL                                                     00665800
                INCLUDE TBCRACCT                                        00665900
           END-EXEC.                                                    00666000
      *                                                                 00666100
      ******* TABLE DECLARATION FOR CSS_MKT_XREF_ACCT  XM **********            
           EXEC SQL                                                             
                INCLUDE TBMRKXR                                                 
           END-EXEC.                                                            
      *                                                                         
      ****** TABLE DECLARATION FOR CSS_REG_PROFILE  LR **************           
                                                                        
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
     *                                                                  
      ******* TABLE DECLARATION FOR CSS_ADDR_FREEFORM DZ *************  00667400
                                                                        
           EXEC SQL                                                     00667600
               INCLUDE TBADRFRE                                         00667700
           END-EXEC.                                                    00667800
      *                                                                 00667900
      ******* TABLE DECLARATION FOR CSS_CUSTOMER  CU *****************  00668500
                                                                        
           EXEC SQL                                                     00668700
               INCLUDE TBCUST                                           00668800
           END-EXEC.                                                    00668900
      *                                                                 00669000
      ******* TABLE DECLARATION FOR CSS_JOB_PARM  G6  ******************00670900
      *                                                                 00671000
           EXEC SQL                                                     00671100
               INCLUDE TBJBPARM                                         00671200
           END-EXEC.                                                    00671300
      ******* TABLE DECLARATION FOR CSS_NAME   DQ     ****************  00672700
      *                                                                 00671000
           EXEC SQL                                                     00672900
               INCLUDE TBNAME                                           00673000
           END-EXEC.                                                    00673100
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_NAME_ACCT_XREF  HT ***********  00672700
      *                                                                 00671000
           EXEC SQL                                                     00672900
               INCLUDE TBNMACTX                                         00673000
           END-EXEC.                                                    00673100
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCT_BILL_NMES  AB ***********  00672700
      *                                                                 00671000
           EXEC SQL                                                     00672900
               INCLUDE TBATBLNM                                         00673000
           END-EXEC.                                                    00673100
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ACCT_MISC_INFO  TA  **********  00672700
      *                                                                 00671000
           EXEC SQL                                                     00672900
               INCLUDE TBATMISC                                         00673000
           END-EXEC.                                                    00673100
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_CUST_ADDR_XREF  DM************  00672700
      *                                                                 00671000
           EXEC SQL                                                     00672900
               INCLUDE TBCSADRX                                         00673000
           END-EXEC.                                                    00673100
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ADDR_FORMATTED   DY **********  00672700
      *                                                                 00671000
           EXEC SQL                                                     00672900
               INCLUDE TBADRFMT                                         00673000
           END-EXEC.                                                    00673100
      *                                                                         
      ******* TABLE DECLARATION FOR CSS_ZIP_CODE   A4 ****************  00672700
      *                                                                 00671000
           EXEC SQL                                                     00672900
               INCLUDE TBZIPCD                                          00673000
           END-EXEC.                                                    00673100
      *                                                                         
      *---< CSS_CUST_PHONE  >   CB                                              
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
      ***** CSS_CUST_STATS     CE                                               
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
      ******* WORKING STORAGE FOR WS-MISC.                                      
           EXEC SQL                                                     00682900
              INCLUDE CWS00038                                          00683000
           END-EXEC.                                                    00683100
                                                                        
      ****** WORKING STORAGE FOR SCSCB068.                                      
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      ****** WORKING STORAGE FOR CODES-DATA-PRESENT                             
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_DELINQUENCY  C8 *************   00672700
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
                                                                        
      ******* TABLE DECLARATION FOR CSS_RESTART  RF                     00683200
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
                                                                        
      ******* CURSOR DECLARATION FOR ACCT                                       
           EXEC SQL                                                     
              DECLARE ACCT_CSR CURSOR WITH HOLD FOR                     
              SELECT AT.ACCOUNT_NO,                                     
                     AT.CODE_ACCT_STAT,                                 
                     AT.ADDRESS_ID,                                     
                     AT.CUSTOMER_NO,                                    
                     AT.COMPANY_NO,                                     
                     AT.ADDRESS_FORMAT,                                 
                     AT.CODES_DATA_PRESENT,                             
                     AT.NOTICE_EXEMPT_CD,                               
                     AT.CODE_DISC_OK,                                   
                     AT.DATE_BILL_DAY_00,                               
                     AT.DATE_BILL_DAY_30,                               
                     AT.DATE_BILL_DAY_60,                               
                     AT.DATE_BILL_DAY_90,                               
                     AT.LOCAL_OFFICE,                                   
                     AT.BANKRUPTCY_IND,                                 
                     AT.CREDIT_GROUP,                                   
                     AT.TOTAL_AR_BALANCE                                
              FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                         
              WHERE AT.CODE_ACCT_STAT = :WS-A                           
                 AND AT.ACCOUNT_TYPE_CODE = :WS-R                       
                 AND NOT EXISTS                                         
                 (SELECT 'Y'                                            
                  FROM CSS_CREDIT_HIST CK WITH(READUNCOMMITTED)                 
                    WHERE                                               
                  AT.CUSTOMER_NO = CK.CUSTOMER_NO                       
                  AND CK.CR_HIST_TRAN_DT > IIF(TRY_CONVERT(DATE, 
                                                    :WS-LAST-SENT-CMPDT
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-SENT-CMPDT
              ) <> 0) OR (LEN(:WS-LAST-SENT-CMPDT
              ) <> 10), CIS.CHAR2DATE(:WS-LAST-SENT-CMPDT
              ), CONVERT(DATE, :WS-LAST-SENT-CMPDT) )          
                  AND CK.CR_RQST_REASON_CD = :WS-B)                     
              ORDER BY AT.CUSTOMER_NO                                   
              FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00059800
MFA-TR*       DECLARE ACCT_CSR CURSOR WITH HOLD FOR                     00059900
MFA-TR*       SELECT AT.ACCOUNT_NO,                                             
MFA-TR*              AT.CODE_ACCT_STAT,                                         
MFA-TR*              AT.ADDRESS_ID,                                             
MFA-TR*              AT.CUSTOMER_NO,                                            
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AT.ADDRESS_FORMAT,                                         
MFA-TR*              AT.CODES_DATA_PRESENT,                                     
MFA-TR*              AT.NOTICE_EXEMPT_CD,                                       
MFA-TR*              AT.CODE_DISC_OK,                                           
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              AT.DATE_BILL_DAY_30,                                       
MFA-TR*              AT.DATE_BILL_DAY_60,                                       
MFA-TR*              AT.DATE_BILL_DAY_90,                                       
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              AT.BANKRUPTCY_IND,                                         
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.TOTAL_AR_BALANCE                                        
MFA-TR*       FROM CSS_ACCOUNT AT                                       00062000
MFA-TR*       WHERE AT.CODE_ACCT_STAT = :WS-A                                   
MFA-TR*          AND AT.ACCOUNT_TYPE_CODE = :WS-R                               
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*          (SELECT 'Y'                                                    
MFA-TR*           FROM CSS_CREDIT_HIST CK                                       
MFA-TR*             WHERE                                                       
MFA-TR*           AT.CUSTOMER_NO = CK.CUSTOMER_NO                               
MFA-TR*           AND CK.CR_HIST_TRAN_DT > :WS-LAST-SENT-CMPDT                  
MFA-TR*           AND CK.CR_RQST_REASON_CD = :WS-B)                             
MFA-TR*       ORDER BY AT.CUSTOMER_NO                                           
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    00062500
      **                                                                02201000
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR PCSCA040 ENDS HERE  '.            
HPCCDM*    EJECT                                                        02208000
HPCCDM*EJECT                                                            02220000
                                                                        
       PROCEDURE DIVISION.                                              
      ******************************************************************02250000
      *                                                                *02260000
      *   0000-MAINLINE.                                               *02270000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *02280000
      *                                                                *02290000
      ******************************************************************02300000
       0000-MAINLINE.                                                   
      *                                                                 02320000
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-CURSOR-PROCESS THRU 1000-EXIT.                  
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                 02440000
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-PGRMNAME                TO G6-PROGRAM-NAME        
              MOVE WS-PARM                    TO G6-CMND-CODE           
              MOVE WS-SEQ-NO                  TO G6-SEQ-NO              
              MOVE WS-I                       TO G6-STATUS              
              MOVE 'RESTART-REQ=N'            TO G6-PARM-DATA           
              PERFORM 8940-RESET-JOB-PARM     THRU 8940-EXIT            
      *                                                                         
              MOVE WS-B                          TO                     
                                                   WS-RESTART-JOB-STATUS
              DISPLAY 'PCSCA040 RERUN COMPLETED'                        
           ELSE                                                         
              MOVE WS-A                          TO                     
                                                   WS-RESTART-JOB-STATUS
              DISPLAY 'PCSCA040 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
      *                                                                         
           IF RETURN-CODE = 0                                           
               PERFORM 8890-DELETE-RESTART-RECORD THRU 8890-EXIT        
           END-IF.                                                      
      *                                                                         
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02500000
      *                                                                *02510000
      *   0100-INITIALIZATION                                          *02520000
      *        COMMON INITIALIZATION ROUTINE                           *02530000
      *                                                                *02540000
      ***************************************************************** 02550000
                                                                        
       0100-INITIALIZATION.                                             
      *                                                                         
           INITIALIZE WS-SYSIPT                                         
              PERFORM 6235-GET-FJC01-RESTART-REQ                        
                                                 THRU 6235-EXIT.        
              MOVE G6-SEQ-NO TO WS-SEQ-NO.                              
                                                                        
           INITIALIZE WS-SYSIPT                                         
              PERFORM 6253-GET-FJC01-CHKP-LIMIT                         
                                                 THRU 6253-EXIT.        
           OPEN OUTPUT FCSRP040-FILE.                                   
                                                                        
           IF FRP040-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '0100-ERROR ON FCSRP040 OPEN.  STATUS IS '       
                        WS-FRP040-STATUS                                
               MOVE 12 TO RETURN-CODE                                   
               STOP RUN                                                 
           END-IF.                                                      
                                                                        
           PERFORM 0200-CHECK-RESTART            THRU 0200-EXIT.        
      *                                                                         
           PERFORM 0300-PREPARE-RESTART          THRU 0300-EXIT.        
      *                                                                         
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE                
           END-IF.                                                      
                                                                        
           MOVE WS-INPUT-DATE           TO WS-JOB-PARM                  
                                           CK-CR-HIST-TRAN-DT.          
                                                                        
           MOVE WS-01                   TO C8-COMPANY-NO.               
           PERFORM 2645-GET-REGION         THRU 2645-EXIT.              
           IF SEB-DATABASE                                              
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'INVALID REGION FOR THIS FUNCTIONALITY'           
              DISPLAY 'WS-DATABASE: ' WS-DATABASE                       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 2650-GET-ACCT-REV-DAYS  THRU 2650-EXIT.              
      ******************************************************************        
      *   GET DATE AS OF WS-ACCT-REVDAYS  AGO.                         *        
      ******************************************************************        
           MOVE WS-INPUT-DATE TO WS-HOLD-DATE.                          
           PERFORM 7098-GET-DAYS-AGO       THRU 7098-EXIT.              
                                                                        
           PERFORM 2655-GET-AMT-AR-PD-REG   THRU 2655-EXIT.             
           PERFORM 2656-GET-AMT-AR-PD-DEREG THRU 2656-EXIT.             
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   0110-PREPARE-FOR-RESTART                                     *        
      *                                                                *        
      *        CHECK CSS_RESTART TABLE TO SEE IF THIS IS A RESTART OR  *        
      *   A NORMAL RUN.  IF A ROW IS FOUND IN THIS TABLE FOR PROGRAM   *        
      *   PCSCA040, THE RESTART LOGIC IS EXECUTED.  OTHERWISE, NORMAL  *        
      *   PROCESSING IS FOLLOWED.                                      *        
      ******************************************************************        
                                                                        
       0200-CHECK-RESTART.                                              
                                                                        
           MOVE 'PCSCA040'                   TO RF-NAME-PROGRAM.        
           MOVE 1                            TO RF-PARTITION-NO         
                                                WS-CHKP-PART-NO.        
           MOVE 1                            TO RF-DUP-CNTRL-NO.        
                                                                        
           PERFORM 7100-SELECT-RESTART          THRU 7100-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE RF-RESTART-DATA-TEXT         TO WS-RESTART-DATA     
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                      TO WS-IS-THIS-A-RESTART
               END-IF                                                   
           END-IF.                                                      
           PERFORM 0605-VALIDATE-RESTART-REQ   THRU 0605-EXIT.          
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *PREPARE-RESTART.                                                         
      ******************************************************************        
      *                                                                         
       0300-PREPARE-RESTART.                                            
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-RESTART-FCSRP040-REC-CNTR  TO                     
                                                 WS-FCSRP040-REC-CNTR   
              DISPLAY '*******************************************'     
              DISPLAY '*****   THIS IS A RESTART OF PCSCA040   ***'     
              DISPLAY '*******************************************'     
              MOVE WS-RESTART-CHKP-SEQ-NO        TO WS-CHKP-SEQ-NO      
              OPEN INPUT FCSRP04R-FILE                                  
              IF FCSRP04R-SUCCESSFUL                                    
                 CONTINUE                                               
              ELSE                                                      
                 DISPLAY '0300-ERROR ON FCSRP04R OPEN.  STATUS IS '     
                                                      WS-FCSRP04R-STATUS
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
              END-IF                                                    
              PERFORM WS-FCSRP040-REC-CNTR TIMES                        
                READ FCSRP04R-FILE                                      
                IF FCSRP04R-SUCCESSFUL                                  
                   WRITE FIORP040 FROM  FIORP04R                        
                   IF FRP040-SUCCESSFUL                                 
                      CONTINUE                                          
                   ELSE                                                 
                      DISPLAY 'ERROR ON FCSRP040 REWRITE.  STATUS IS '  
                                                    WS-FRP040-STATUS    
                      PERFORM 9900-ABEND       THRU 9900-EXIT           
                   END-IF                                               
                ELSE                                                    
                   DISPLAY 'PREMATURE EOF ON FCSRP04R RESTART'          
                   DISPLAY 'PROCESSING TERMINATED'                      
                   PERFORM 9900-ABEND           THRU 9900-EXIT          
                END-IF                                                  
              END-PERFORM                                               
              CLOSE FCSRP04R-FILE                                       
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
       COPY CPD00030.                                                           
      *                                                                         
      ******************************************************************02920000
      * OPENS THE CURSOR,  FETCH AND PROCESS TO CHECK FOR              *        
      * ACCOUNT REVIEW ACCOUNT.                                        *        
      ******************************************************************02920000
       1000-CURSOR-PROCESS.                                             
                                                                        
           PERFORM 7005-OPEN-CURSOR  THRU 7005-EXIT.                    
           PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT.                    
           PERFORM 2000-PROCESS-RECORDS   THRU 2000-EXIT                
               UNTIL END-OF-ROWS.                                       
           PERFORM 7050-CLOSE-CURSOR THRU 7050-EXIT.                    
      *                                                                 03060000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03090000
HPCCDM*EJECT                                                            03100000
      ***************************************************************           
      **    PREPARE-BEFORE COMMIT**                                             
      ***************************************************************           
       1800-PREPARE-PRECOMMIT.                                          
                                                                        
            MOVE 1                               TO                     
                                           WS-RESTART-PROCESS-TYPE.     
            MOVE WS-C                            TO                     
                                           WS-RESTART-JOB-STATUS.       
            MOVE WS-INPUT-DATE                   TO                     
                                           WS-RESTART-COMMON-DATE.      
            ADD  1                               TO  WS-CHKP-SEQ-NO.    
            MOVE WS-CHKP-SEQ-NO                  TO                     
                                           WS-RESTART-CHKP-SEQ-NO.      
            MOVE WS-FCSRP040-REC-CNTR            TO                     
                                           WS-RESTART-FCSRP040-REC-CNTR.
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************03120000
      *                                                                *03130000
      *       2000-PROCESS-RECORDS.                                    *03140000
      *                                                                *03150000
      *  PROCESSES EACH RECORD                                         *03160000
      *                                                                *03180000
      ******************************************************************03190000
       2000-PROCESS-RECORDS.                                            
                                                                        
           PERFORM 2020-CALL-CPD00068        THRU 2020-EXIT.            
           PERFORM 7430-SEL-REG-PROFILE      THRU 7430-EXIT.            
           IF  (LR-REG-GROUP-CD > SPACE AND                             
               WS-AMT-PAST-DUE > WS-AMT-AR-PD-REG-NUM) OR               
               (LR-REG-GROUP-CD = SPACE  AND                            
               WS-AMT-PAST-DUE > WS-AMT-AR-PD-DEREG-NUM)                
               PERFORM 2100-PROCESS-ACCOUNT   THRU 2100-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7010-FETCH-CURSOR         THRU 7010-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03120000
      *                                                                *03130000
      *       2020-CALL-CPD00068.                                      *03140000
      *                                                                *03180000
      ******************************************************************03190000
       2020-CALL-CPD00068.                                              
                                                                        
           MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT.       
      *SET CPD00068 SWITCHES THAT ARE NEEDED                                    
           MOVE 'Y'         TO CALC-ARREARS-SW                          
                               CALC-BALANCE-SW                          
                               CALC-PAST-DUE-SW.                        
                                                                        
           MOVE PROGRAM-NAME            TO WS-CPD00068-CALLING-PGM.     
           MOVE SPACES                  TO  ABEND-FUNCTION.             
           CALL SCSCB068  USING  CWS00068-FIELDS,                       
                                 WS-CODES-DATA-PRESENT,                 
                                 DCLCSS-ACCOUNT,                        
                                 ABEND-FILE,                            
                                 WS-ACTIVE-RETURN-CODE.                 
                                                                        
           IF  ABEND-FUNCTION  > SPACES                                 
               DISPLAY '**** 2020-CALL-CPD00068'                        
               DISPLAY '**** ACCOUNT NO: ' , AT-ACCOUNT-NO              
               DISPLAY WS-ACTIVE-RETURN-CODE                            
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03120000
      *                                                                *03130000
      *       2100-PROCESS-ACCOUNT                                     *03140000
      *                                                                *03180000
      ******************************************************************03190000
       2100-PROCESS-ACCOUNT.                                            
                                                                        
           IF AT-CUSTOMER-NO   = WS-PREV-PROC-CUST                      
              MOVE SPACE TO CR-ACCT-REVIEW-SEL-FL                       
              PERFORM 8160-MOVE-CRACCT       THRU 8160-EXIT             
              PERFORM 8170-INS-HIST-ACCT     THRU 8170-EXIT             
           ELSE                                                         
              PERFORM 7200-GET-TIMESTAMP     THRU 7200-EXIT             
              PERFORM 2630-GET-INFO          THRU 2630-EXIT             
              IF WS-NAME-FOUND                                          
                 PERFORM 8050-PRE-INSERT        THRU 8050-EXIT          
                 PERFORM 8100-INS-CREDIT-HIST   THRU 8100-EXIT          
                 PERFORM 8150-UPD-FILE          THRU 8150-EXIT          
                 MOVE WS-Y TO CR-ACCT-REVIEW-SEL-FL                     
                 PERFORM 8160-MOVE-CRACCT       THRU 8160-EXIT          
                 PERFORM 8170-INS-HIST-ACCT     THRU 8170-EXIT          
                 MOVE AT-CUSTOMER-NO            TO WS-PREV-PROC-CUST    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-RESTART-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR          
              WS-RESTART-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT             
              PERFORM 8888-COMMIT                THRU 8888-EXIT         
              MOVE ZEROES                        TO                     
                                              WS-RESTART-COMMIT-COUNTER
           END-IF.
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2630-GET-INFO.                                                   
      ***********************************************************               
      *    GETTING CUSTOMER'S SSN.                              *               
      ***********************************************************               
           PERFORM 7210-SELECT-CUST-STATS THRU 7210-EXIT.               
           PERFORM 7300-GET-CUST-NAME     THRU 7300-EXIT.               
      ***********************************************************               
      *  GETTING CUSTOMER'S ADDRESS.                            *               
      ***********************************************************               
           IF WS-NAME-FOUND                                             
              PERFORM 4000-MAIL-NAME-ADDRESS                            
                                           THRU 4000-EXIT               
           END-IF.                                                      
       2630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    GET REGION                                                 **        
      ******************************************************************        
       2645-GET-REGION.                                                 
           MOVE WS-DATABASE-CD        TO C8-DELINQ-CD.                  
           PERFORM 7800-GET-VALUES    THRU 7800-EXIT.                   
           MOVE C8-DELINQ-VALUE       TO WS-DATABASE.                   
       2645-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    GET ACCT-REV-DAYS FROM CSS_DELINQUENCY                     **        
      ******************************************************************        
       2650-GET-ACCT-REV-DAYS.                                          
           MOVE WS-ACCT-REVDAYS-CD    TO C8-DELINQ-CD.                  
           PERFORM 7800-GET-VALUES    THRU 7800-EXIT.                   
           MOVE C8-DELINQ-VALUE       TO WS-ACCT-REVDAYS.               
       2650-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    GET AMT-AR-PASTDUE-REG  FROM CSS_DELINQUENCY               **        
      ******************************************************************        
       2655-GET-AMT-AR-PD-REG.                                          
           MOVE WS-AMT-AR-PD-REG-CD    TO C8-DELINQ-CD.                 
           PERFORM 7800-GET-VALUES     THRU 7800-EXIT.                  
           MOVE C8-DELINQ-VALUE        TO WS-AMT-AR-PD-REG-NUM.         
           MOVE WS-AMT-AR-PD-REG-NUM   TO WS-AMT-AR-PD-REG-COMP3.       
       2655-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    GET AMT-AR-PASTDUE-DEREG FROM CSS_DELINQUENCY              **        
      ******************************************************************        
       2656-GET-AMT-AR-PD-DEREG.                                        
           MOVE WS-AMT-AR-PD-DEREG-CD  TO C8-DELINQ-CD.                 
           PERFORM 7800-GET-VALUES     THRU 7800-EXIT.                  
           MOVE C8-DELINQ-VALUE        TO WS-AMT-AR-PD-DEREG-NUM.       
           MOVE WS-AMT-AR-PD-DEREG-NUM TO WS-AMT-AR-PD-DEREG-COMP3.     
       2656-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04270000
      * 4000-MAIL-NAME-ADDRESS.                                        *04240000
      *                                                                *04250000
      ******************************************************************04270000
            EXEC SQL                                                            
                INCLUDE CPD00074                                                
            END-EXEC.                                                           
                                                                        
       COPY CPD00004.                                                           
                                                                        
      ******************************************************************04270000
      * 5900-CALC-VARCHAR-LENGTH.                                      *04240000
      *                                                                *04250000
      * CALCULATE THE NUMBER OF CHARACTERS IN A DB2 VARCHAR            *        
      * HOST VARIABLE.                                                 *        
      ******************************************************************04270000
       COPY CPD00060.                                                           
                                                                        
      *                                                                         
      **************************************************************            
      * 6235-GET-FJC01-RESTART-REQ.                                             
      **************************************************************            
           EXEC SQL                                                             
               INCLUDE CPD00035                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ** 6240-GET-FCA00-COMMON-DATE                                             
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00040                                                
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** 6251-GET-FJC01-DATE                                         **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00037                                                
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      **  6253-GET-FJC01-CHKP-LIMIT.                                 *          
      ****************************************************************          
            EXEC SQL                                                            
                INCLUDE CPD00034                                                
            END-EXEC.                                                           
      *                                                                         
      ****************************************************************          
           EXEC SQL                                                             
                INCLUDE CPD00038                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00039                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************04270000
      * 7005-OPEN-CURSOR                                               *04240000
      *  OPENS THE CURSOR FOR PROCESSING                               *04250000
      *                                                                *04260000
      ******************************************************************04270000
       7005-OPEN-CURSOR.                                                
      *                                                                 04290000
           EXEC SQL                                                     
              OPEN ACCT_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7005-OPEN-CURSOR'                               
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 04440000
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04470000
      ******************************************************************04480000
      *                                                                *04490000
      *   7010-FETCH-CURSOR.                                           *04500000
      *        FETCHES THE RECORD FROM THE OPENED CURSOR               *04510000
      *                                                                *04520000
      ******************************************************************04530000
       7010-FETCH-CURSOR.                                               
                                                                        
                                                                        
           EXEC SQL                                                     
               FETCH ACCT_CSR                                           
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-ADDRESS-ID,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-COMPANY-NO,                                     
                    :AT-ADDRESS-FORMAT,                                 
                    :AT-CODES-DATA-PRESENT,                             
                    :AT-NOTICE-EXEMPT-CD,                               
                    :AT-CODE-DISC-OK,                                   
                    :AT-DATE-BILL-DAY-00,                               
                    :AT-DATE-BILL-DAY-30,                               
                    :AT-DATE-BILL-DAY-60,                               
                    :AT-DATE-BILL-DAY-90,                               
                    :AT-LOCAL-OFFICE,                                   
                    :AT-BANKRUPTCY-IND,                                 
                    :AT-CREDIT-GROUP,                                   
                    :AT-TOTAL-AR-BALANCE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE 'Y' TO VALID-ROW-EXIST-FLAG                         
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE 'Y' TO WS-END-OF-ROWS                           
               ELSE                                                     
                   DISPLAY '7010-FETCH-CURSOR'                          
                           ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                 04810000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04840000
      ******************************************************************04850000
      *   7050-CLOSE-CURSOR                                            *04870000
      *        CLOSES THE CURSOR                                       *04880000
      ******************************************************************04900000
       7050-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT_CSR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '7050-CLOSE-CURSOR'                              
                       ' RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04850000
      *   7098-GET-DAYS-AGO.                                           *04870000
      ******************************************************************04900000
       7098-GET-DAYS-AGO.                                               
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              DATEADD( DAY, -:WS-ACCT-REVDAYS, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) )
            INTO
              :WS-LAST-SENT-CMPDT        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     15025297
MFA-TR*       SET :WS-LAST-SENT-CMPDT =                                 15025298
MFA-TR*              DATE(:WS-HOLD-DATE) - :WS-ACCT-REVDAYS DAYS        15025298
MFA-TR*    END-EXEC.                                                    15025400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** SET STATEMENTS                         '      
              DISPLAY '** GET ACCT-REV-DAYS AGO                '        
              DISPLAY '** 7098 :  RETURN CODE ERROR              '      
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7098-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15025444
      ****************************************************************          
      **                                                            **          
      **         7100-SELECT-RESTART                                **          
      **                                                            **          
      ****************************************************************          
       7100-SELECT-RESTART.                                             
      *                                                                         
           MOVE '7100'                           TO WS-ACTIVE-PARAGRAPH.
      *                                                                         
           EXEC SQL                                                     
               SELECT RESTART_DATA                                      
                 INTO :RF-RESTART-DATA                                  
                 FROM CSS_RESTART WITH(READUNCOMMITTED)                         
                WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND               
                      PARTITION_NO = :RF-PARTITION-NO AND               
                      DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESTART_DATA                                              
MFA-TR*          INTO :RF-RESTART-DATA                                          
MFA-TR*          FROM CSS_RESTART                                               
MFA-TR*         WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND                       
MFA-TR*               PARTITION_NO = :RF-PARTITION-NO AND                       
MFA-TR*               DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                          TO                     
                                                 WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '**   ERROR ON 7100-SELECT-RESTART   **'          
              DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**       PROCESSING TERMINATED      **'          
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04850000
      *        GET TIMESTAMP                                           *04880000
      ******************************************************************04900000
       7200-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIMESTAMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET: WS-TIMESTAMP = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                NEXT SENTENCE                                           
           ELSE                                                         
                DISPLAY '*******************************************'   
                DISPLAY '** ERROR IN 7200-GET-TIMESTAMP           **'   
                DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE       
                DISPLAY '**        PROCESSING IS TERMINATED       **'   
                DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                  
                DISPLAY '*******************************************'   
                PERFORM 9900-ABEND                THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41040
      *     7210-SELECT-CUST-STATS                                     *PCS41060
      ******************************************************************PCS41100
      *                                                                         
       7210-SELECT-CUST-STATS.                                          
           MOVE AT-CUSTOMER-NO TO CE-CUSTOMER-NO.                       
           MOVE SPACES         TO CE-SSN.                               
                                                                        
           EXEC SQL                                                     
                SELECT                                                  
                      CE.SSN,                                           
                      CE.CUSTOMER_NO                                    
                INTO                                                    
                      :CE-SSN,                                          
                      :CE-CUSTOMER-NO                                   
                FROM                                                    
                      CSS_CUST_STATS CE WITH(READUNCOMMITTED)                   
                WHERE CE.CUSTOMER_NO = :CE-CUSTOMER-NO                  
                  AND CE.CUSTOMER_TYPE = 'C'                            
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*               CE.SSN,                                                   
MFA-TR*               CE.CUSTOMER_NO                                            
MFA-TR*         INTO                                                            
MFA-TR*               :CE-SSN,                                                  
MFA-TR*               :CE-CUSTOMER-NO                                           
MFA-TR*         FROM                                                            
MFA-TR*               CSS_CUST_STATS CE                                         
MFA-TR*         WHERE CE.CUSTOMER_NO = :CE-CUSTOMER-NO                          
MFA-TR*           AND CE.CUSTOMER_TYPE = 'C'                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
           OR  NOT-FOUND                                                
           OR  SQLCODE = -811                                           
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*****************PCSCA040******************'    
               DISPLAY '* 7210 : RETURN CODE ERROR                *'    
               DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE           
               DISPLAY '* CUSTOMER NO = ' CE-CUSTOMER-NO                
               DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                  
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA040******************'    
               PERFORM 9900-ABEND  THRU  9900-EXIT                      
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************PCS41040
      *     7300-GET-CUST-NAME                                         *PCS41060
      ******************************************************************PCS41100
      *                                                                         
       7300-GET-CUST-NAME.                                              
           MOVE 'Y'            TO WS-NAME-FOUND-FLAG.                   
           MOVE AT-ACCOUNT-NO  TO HT-ACCOUNT-NO.                        
           MOVE WS-CN          TO DQ-NAME-TYPE.                         
           MOVE WS-I           TO DQ-NAME-FORMAT.                       
           MOVE SPACES         TO HT-CUSTOMER-ROLE-CD                   
                                  WS-FIRST-NAME-DQ                      
                                  WS-MIDDLE-NAME-DQ                     
                                  WS-LAST-NAME-DQ                       
                                  WS-TITLE-SUFFIX-1-DQ.                 
           EXEC SQL                                                     
                  SELECT DQ.FIRST_NAME,                                 
                         DQ.MIDDLE_NAME,                                
                         DQ.LAST_NAME,                                  
                         DQ.TITLE_SUFFIX_1                              
                  INTO   :WS-FIRST-NAME-DQ,                             
                         :WS-MIDDLE-NAME-DQ,                            
                         :WS-LAST-NAME-DQ,                              
                         :WS-TITLE-SUFFIX-1-DQ                          
                  FROM CSS_NAME DQ WITH(READUNCOMMITTED),                       
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                  WHERE HT.ACCOUNT_NO = :AT-ACCOUNT-NO AND              
                        HT.CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD AND  
                        DQ.NAME_ID = HT.NAME_ID AND                     
                        DQ.NAME_TYPE = :DQ-NAME-TYPE AND                
                        DQ.NAME_FORMAT = :DQ-NAME-FORMAT                
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*           SELECT DQ.FIRST_NAME,                                         
MFA-TR*                  DQ.MIDDLE_NAME,                                        
MFA-TR*                  DQ.LAST_NAME,                                          
MFA-TR*                  DQ.TITLE_SUFFIX_1                                      
MFA-TR*           INTO   :WS-FIRST-NAME-DQ,                                     
MFA-TR*                  :WS-MIDDLE-NAME-DQ,                                    
MFA-TR*                  :WS-LAST-NAME-DQ,                                      
MFA-TR*                  :WS-TITLE-SUFFIX-1-DQ                                  
MFA-TR*           FROM CSS_NAME DQ,                                             
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*           WHERE HT.ACCOUNT_NO = :AT-ACCOUNT-NO AND                      
MFA-TR*                 HT.CUSTOMER_ROLE_CD = :HT-CUSTOMER-ROLE-CD AND          
MFA-TR*                 DQ.NAME_ID = HT.NAME_ID AND                             
MFA-TR*                 DQ.NAME_TYPE = :DQ-NAME-TYPE AND                        
MFA-TR*                 DQ.NAME_FORMAT = :DQ-NAME-FORMAT                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               OR SQLCODE = -811                                        
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO WS-NAME-FOUND-FLAG                         
              ELSE                                                      
                 DISPLAY '*****************PCSCA040******************'  
                 DISPLAY '* 7300 : RETURN CODE ERROR                *'  
                 DISPLAY '*        RC = ' WS-ACTIVE-RETURN-CODE         
                 DISPLAY '* ACCOUNT NO = ' AT-ACCOUNT-NO                
                 DISPLAY '* PROGRAM ABENDING...                     *'  
                 DISPLAY '*****************PCSCA040******************'  
                 PERFORM 9900-ABEND  THRU  9900-EXIT                    
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7430-SELECT-REG-PROFILE.                                       *        
      ******************************************************************        
       7430-SEL-REG-PROFILE.                                            
      *                                                                         
           MOVE AT-ACCOUNT-NO             TO LR-ACCOUNT-NO.             
           MOVE SPACES                    TO LR-REG-GROUP-CD.           
                                                                        
           EXEC SQL                                                     
                SELECT REG_GROUP_CD                                     
                  INTO :LR-REG-GROUP-CD                                 
                FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT REG_GROUP_CD                                             
MFA-TR*           INTO :LR-REG-GROUP-CD                                         
MFA-TR*         FROM CSS_REG_PROFILE                                            
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '************** PCSCA040 ******************'     
               DISPLAY '** 7430 :  RETURN CODE ERROR - SELECT'          
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**      :  ACCOUNT-NO = ' LR-ACCOUNT-NO         
               DISPLAY '************** PCSCA040 ******************'     
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               **        
      *   GET THE COMPANY DETAILS FROM DELINQUENCY TABLE              **        
      *                                                               **        
      ******************************************************************        
       7800-GET-VALUES.                                                 
                                                                        
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :C8-DELINQ-VALUE                                    
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
              AND  COMPANY_NO = :C8-COMPANY-NO                          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*        INTO :C8-DELINQ-VALUE                                            
MFA-TR*        FROM CSS_DELINQUENCY                                             
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*       AND  COMPANY_NO = :C8-COMPANY-NO                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
             DISPLAY '**************** PCSCA040 *****************'      
             DISPLAY '** 7800-GET-VALUES   **'                          
             DISPLAY '** CSS_DELINQUENCY   **'                          
             DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE          
             DISPLAY '** C8-COMPANY-NO: ' C8-COMPANY-NO                 
             DISPLAY '** C8-DELINQ-CD: ' C8-DELINQ-CD                   
             DISPLAY '**        PROCESSING IS TERMINATED       **'      
             DISPLAY '**************** PCSCA040 *****************'      
             PERFORM 9900-ABEND            THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************04850000
      *  PREPARE FOR INSERT TO CSS_CREDIT_HIST                         *04880000
      ******************************************************************04900000
       8050-PRE-INSERT.                                                 
           MOVE AT-CUSTOMER-NO               TO CK-CUSTOMER-NO.         
           MOVE AT-COMPANY-NO                TO CK-CR-CHK-COMPANY-NO.   
           MOVE SPACES                       TO CK-BEACON-SCORE         
P00951                                          CK-SCORE-MODEL-CD       
P00951                                          CK-ADDL-CRED-SCORE.     
           MOVE WS-TS-TIME                   TO CK-CR-HIST-TRAN-TM.     
           MOVE WS-E                         TO CK-CR-BUREAU-CD.        
           MOVE WS-B                         TO CK-CR-RQST-REASON-CD.   
           MOVE WS-SYSTEM                    TO CK-USER-ID-CR-INIT-BY.  
           MOVE WS-S                         TO CK-ACCT-REVIEW-ACT-CD.  
           MOVE LR-REG-GROUP-CD              TO CK-REG-GROUP-CD.        
C36013     MOVE WS-FIRST-NAME-DQ             TO CK-FIRST-NAME           
                                                CK-CUST-NAME-FIRST-TEXT 
                                                WS-VARCHAR.             
           MOVE +25                          TO WS-MAX-LEN.             
           PERFORM 5900-CALC-VARCHAR-LENGTH  THRU 5900-EXIT.            
           MOVE WS-VARCHAR-LEN               TO CK-CUST-NAME-FIRST-LEN. 
                                                                        
C36013     MOVE WS-LAST-NAME-DQ              TO CK-LAST-NAME            
                                                CK-CUST-NAME-LAST-TEXT  
                                                WS-VARCHAR.             
           MOVE +25                          TO WS-MAX-LEN.             
           PERFORM 5900-CALC-VARCHAR-LENGTH  THRU 5900-EXIT.            
           MOVE WS-VARCHAR-LEN               TO CK-CUST-NAME-LAST-LEN.  
                                                                        
C36013     MOVE WS-MIDDLE-NAME-DQ            TO CK-MIDDLE-NAME          
                                                CK-CUST-NAME-MID-TEXT   
                                                WS-VARCHAR.             
           MOVE +25                          TO WS-MAX-LEN.             
           PERFORM 5900-CALC-VARCHAR-LENGTH  THRU 5900-EXIT.            
           MOVE WS-VARCHAR-LEN               TO CK-CUST-NAME-MID-LEN.   
                                                                        
C36013     EVALUATE WS-TITLE-SUFFIX-1-DQ                                
C36013        WHEN 'JR'                                                 
C36013        WHEN 'SR'                                                 
C36013        WHEN SPACES                                               
C36013           MOVE WS-TITLE-SUFFIX-1-DQ   TO CK-TITLE-SUFFIX-1       
C36013                                          CK-CUST-NAME-SFX        
C36013        WHEN 'II'                                                 
C36013           MOVE '2'                    TO CK-TITLE-SUFFIX-1       
C36013                                          CK-CUST-NAME-SFX        
C36013        WHEN 'III'                                                
C36013           MOVE '3'                    TO CK-TITLE-SUFFIX-1       
C36013                                          CK-CUST-NAME-SFX        
C36013        WHEN 'IV'                                                 
C36013           MOVE '4'                    TO CK-TITLE-SUFFIX-1       
C36013                                          CK-CUST-NAME-SFX        
C36013     END-EVALUATE.                                                
C36013                                                                  
C36013     MOVE CE-SSN                       TO CK-SSN.                 
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04850000
      *  INSERT CSS_CREDIT_HIST.                                       *04880000
      ******************************************************************900000  
       8100-INS-CREDIT-HIST.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CREDIT_HIST                               
                   ( CUSTOMER_NO,                                       
                     CR_CHK_COMPANY_NO,                                 
                     CR_HIST_TRAN_DT,                                   
                     CR_HIST_TRAN_TM,                                   
                     CR_BUREAU_CD,                                      
                     CR_RQST_REASON_CD,                                 
                     USER_ID_CR_INIT_BY,                                
                     REG_GROUP_CD,                                      
                     CUST_NAME_FIRST,                                   
                     CUST_NAME_MID,                                     
                     CUST_NAME_LAST,                                    
                     CUST_NAME_SFX,                                     
                     ACCT_REVIEW_ACT_CD,                                
C36013               SSN,                                               
C36013               FIRST_NAME,                                        
C36013               MIDDLE_NAME,                                       
C36013               LAST_NAME,                                         
C36013               TITLE_SUFFIX_1)                                    
              VALUES (:CK-CUSTOMER-NO,                                  
                     :CK-CR-CHK-COMPANY-NO,                             
                     IIF(TRY_CONVERT(DATE, :CK-CR-HIST-TRAN-DT 
                                           :WS-NULL-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT 
                                                       :WS-NULL-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT :WS-NULL-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT 
                                                       :WS-NULL-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT :WS-NULL-TRAN-DT) ),        
                     CIS.CHAR2TIME(:CK-CR-HIST-TRAN-TM),                        
                     :CK-CR-BUREAU-CD,                                  
                     :CK-CR-RQST-REASON-CD,                             
                     :CK-USER-ID-CR-INIT-BY,                            
                     :CK-REG-GROUP-CD,                                  
                     :CK-CUST-NAME-FIRST,                               
                     :CK-CUST-NAME-MID,                                 
                     :CK-CUST-NAME-LAST,                                
                     :CK-CUST-NAME-SFX,                                 
                     :CK-ACCT-REVIEW-ACT-CD,                            
C36013               :CK-SSN,                                           
C36013               :CK-FIRST-NAME,                                    
C36013               :CK-MIDDLE-NAME,                                   
C36013               :CK-LAST-NAME,                                     
C36013               :CK-TITLE-SUFFIX-1)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CREDIT_HIST                                       
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CR_CHK_COMPANY_NO,                                         
MFA-TR*              CR_HIST_TRAN_DT,                                           
MFA-TR*              CR_HIST_TRAN_TM,                                           
MFA-TR*              CR_BUREAU_CD,                                              
MFA-TR*              CR_RQST_REASON_CD,                                         
MFA-TR*              USER_ID_CR_INIT_BY,                                        
MFA-TR*              REG_GROUP_CD,                                              
MFA-TR*              CUST_NAME_FIRST,                                           
MFA-TR*              CUST_NAME_MID,                                             
MFA-TR*              CUST_NAME_LAST,                                            
MFA-TR*              CUST_NAME_SFX,                                             
MFA-TR*              ACCT_REVIEW_ACT_CD,                                        
MFA-TR*              SSN,                                                       
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_SUFFIX_1)                                            
MFA-TR*       VALUES (:CK-CUSTOMER-NO,                                          
MFA-TR*              :CK-CR-CHK-COMPANY-NO,                                     
MFA-TR*              :CK-CR-HIST-TRAN-DT:WS-NULL-TRAN-DT,                       
MFA-TR*              :CK-CR-HIST-TRAN-TM,                                       
MFA-TR*              :CK-CR-BUREAU-CD,                                          
MFA-TR*              :CK-CR-RQST-REASON-CD,                                     
MFA-TR*              :CK-USER-ID-CR-INIT-BY,                                    
MFA-TR*              :CK-REG-GROUP-CD,                                          
MFA-TR*              :CK-CUST-NAME-FIRST,                                       
MFA-TR*              :CK-CUST-NAME-MID,                                         
MFA-TR*              :CK-CUST-NAME-LAST,                                        
MFA-TR*              :CK-CUST-NAME-SFX,                                         
MFA-TR*              :CK-ACCT-REVIEW-ACT-CD,                                    
MFA-TR*              :CK-SSN,                                                   
MFA-TR*              :CK-FIRST-NAME,                                            
MFA-TR*              :CK-MIDDLE-NAME,                                           
MFA-TR*              :CK-LAST-NAME,                                             
MFA-TR*              :CK-TITLE-SUFFIX-1)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8100-INS-CREDIT-HIST'                         
               DISPLAY '* ACCOUNT_NO = ' AT-ACCOUNT-NO                  
               DISPLAY '* CUSTOMER_NO = ' CK-CUSTOMER-NO                
               DISPLAY '* CR_HIST_TRAN_DT = ' CK-CR-HIST-TRAN-DT        
               DISPLAY '* CR_HIST_TRAN_TM = ' CK-CR-HIST-TRAN-TM        
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18660200
      ******************************************************************04850000
      *  UPDATE FIORP040                                               *04880000
      ******************************************************************04900000
       8150-UPD-FILE.                                                   
                                                                        
P00951     MOVE SPACES                  TO FIORP040.                    
           MOVE WS-PR-ADDR-ZIP-CODE     TO E-RP040-ZIP-CODE.            
           MOVE WS-1                    TO E-RP040-FORMAT-IND.          
           MOVE WS-STATE                TO E-RP040-STATE-ABBR.          
           MOVE WS-CITY                 TO E-RP040-CITY-NAME.           
           MOVE WS-HOUSE-NO             TO E-RP040-HOUSE-NO.            
           MOVE WS-STREET-LOCATION-2    TO E-RP040-APT-NO.              
           MOVE WS-ADDR-PREFIX-2        TO E-RP040-STREET-DIR.          
           MOVE WS-NAME-STREET          TO E-RP040-STREET-NAME.         
           MOVE WS-STREET-SUFFIX        TO E-RP040-STREET-SUFF.         
           MOVE WS-SEB                  TO E-RP040-SOURCE.              
           MOVE LR-REG-GROUP-CD         TO E-RP040-SUBSIDIARY.          
           MOVE WS-FIRST-NAME-DQ        TO E-RP040-FIRST-NAME.          
           MOVE WS-MIDDLE-NAME-DQ       TO E-RP040-MIDDLE-INITIAL.      
           MOVE WS-LAST-NAME-DQ         TO E-RP040-LAST-NAME.           
C36013     MOVE CK-TITLE-SUFFIX-1       TO E-RP040-SUFFIX.              
           IF CE-SSN = SPACES                                           
              MOVE ZEROES               TO E-RP040-SSN                  
           ELSE                                                         
              MOVE CE-SSN               TO E-RP040-SSN                  
           END-IF.                                                      
           MOVE CK-CUSTOMER-NO          TO E-RP040-CUSTOMER-NO.         
           MOVE CK-CR-HIST-TRAN-DT      TO E-RP040-TRAN-DT.             
           MOVE CK-CR-HIST-TRAN-TM      TO E-RP040-TRAN-TM.             
                                                                        
           WRITE FIORP040.                                              
           IF FRP040-SUCCESSFUL                                         
              ADD 1                     TO WS-FCSRP040-REC-CNTR         
                                           WS-RESTART-COMMIT-COUNTER    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   8150-WRITE-FCSRP040 NOT SUCCESSFUL  **'     
              DISPLAY '**        PROCESSING IS TERMINATED       **'     
              DISPLAY '** ACCOUNT NO ' AT-ACCOUNT-NO                    
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04850000
      *  PREPARE FOR INSERT TO CSS_CRED_HIST_ACCT.                     *04880000
      ******************************************************************04900000
       8160-MOVE-CRACCT.                                                
           MOVE CK-CUSTOMER-NO               TO CR-CUSTOMER-NO.         
           MOVE CK-CR-HIST-TRAN-DT           TO CR-CR-HIST-TRAN-DT.     
           MOVE CK-CR-HIST-TRAN-TM           TO CR-CR-HIST-TRAN-TM.     
           MOVE AT-ACCOUNT-NO                TO CR-ACCOUNT-NO.          
           MOVE WS-AMT-PAST-DUE              TO CR-ACCT-PAST-DUE-AM.    
       8160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04850000
      *  INSERT CSS_CRED_HIST_ACCT                                     *04880000
      ******************************************************************900000  
       8170-INS-HIST-ACCT.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CRED_HIST_ACCT                            
                   ( CUSTOMER_NO,                                       
                     CR_HIST_TRAN_DT,                                   
                     CR_HIST_TRAN_TM,                                   
                     ACCOUNT_NO,                                        
                     ACCT_PAST_DUE_AM,                                  
                     ACCT_REVIEW_SEL_FL)                                
              VALUES (:CK-CUSTOMER-NO,                                  
                     IIF(TRY_CONVERT(DATE, :CK-CR-HIST-TRAN-DT 
                                           :WS-NULL-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT 
                                                       :WS-NULL-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT :WS-NULL-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT 
                                                       :WS-NULL-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT :WS-NULL-TRAN-DT) ),        
                     CIS.CHAR2TIME(:CK-CR-HIST-TRAN-TM),                        
                     :CR-ACCOUNT-NO,                                    
                     :CR-ACCT-PAST-DUE-AM,                              
                     :CR-ACCT-REVIEW-SEL-FL)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CRED_HIST_ACCT                                    
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CR_HIST_TRAN_DT,                                           
MFA-TR*              CR_HIST_TRAN_TM,                                           
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              ACCT_PAST_DUE_AM,                                          
MFA-TR*              ACCT_REVIEW_SEL_FL)                                        
MFA-TR*       VALUES (:CK-CUSTOMER-NO,                                          
MFA-TR*              :CK-CR-HIST-TRAN-DT:WS-NULL-TRAN-DT,                       
MFA-TR*              :CK-CR-HIST-TRAN-TM,                                       
MFA-TR*              :CR-ACCOUNT-NO,                                            
MFA-TR*              :CR-ACCT-PAST-DUE-AM,                                      
MFA-TR*              :CR-ACCT-REVIEW-SEL-FL)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '* 8170-INS-HIST-ACCT'                           
               DISPLAY '* ACCOUNT_NO = ' CR-ACCOUNT-NO                  
               DISPLAY '* CUSTOMER_NO = ' CR-CUSTOMER-NO                
               DISPLAY '* CR_HIST_TRAN_DT = ' CR-CR-HIST-TRAN-DT        
               DISPLAY '* CR_HIST_TRAN_TM = ' CR-CR-HIST-TRAN-TM        
               DISPLAY '* SQL RETURN CODE = ' SQLCODE                   
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND      THRU 9900-EXIT                   
           END-IF.                                                      
                                                                        
       8170-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      *     8800-WRITE-RESTART                                      **          
      *                                                             **          
      ****************************************************************          
       8800-WRITE-RESTART.                                              
                                                                        
           MOVE WS-PGRMNAME                      TO RF-NAME-PROGRAM.    
           MOVE 1                                TO RF-PARTITION-NO.    
           MOVE 1                                TO RF-DUP-CNTRL-NO.    
           MOVE WS-RESTART-DATA                  TO                     
                                                 RF-RESTART-DATA-TEXT.  
           MOVE WS-RESTART-DATA-LENGTH           TO RF-RESTART-DATA-LEN.
                                                                        
           PERFORM 8850-UPDATE-RESTART           THRU 8850-EXIT.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8860-INSERT-RESTART        THRU 8860-EXIT         
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      **   8850-UPDATE-RESTART                                       **         
      **                                                            **          
      ****************************************************************          
       8850-UPDATE-RESTART.                                             
      *                                                                         
           MOVE '8850'                           TO WS-ACTIVE-PARAGRAPH.
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_RESTART                                       
               SET RESTART_DATA   = :RF-RESTART-DATA                    
               WHERE NAME_PROGRAM = :RF-NAME-PROGRAM AND                
                     PARTITION_NO = :RF-PARTITION-NO AND                
                     DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                          TO                     
                                                 WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
                   DISPLAY '**  ERROR ON 8850-UPDATE-RESTART  **'       
                   DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE   
                   DISPLAY '**      PROCESSING TERMINATED     **'       
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **      8860-INSERT-RESTART                                   **          
      **                                                            **          
      ****************************************************************          
       8860-INSERT-RESTART.                                             
      *                                                                         
           MOVE '8860'                           TO WS-ACTIVE-PARAGRAPH.
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                          (NAME_PROGRAM                                 
                          ,PARTITION_NO                                 
                          ,DUP_CNTRL_NO                                 
                          ,RESTART_DATA)                                
               VALUES    (:RF-NAME-PROGRAM                              
                         ,:RF-PARTITION-NO                              
                         ,:RF-DUP-CNTRL-NO                              
                         ,:RF-RESTART-DATA)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                          TO                     
                                               WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**   ERROR ON 8860-INSERT-RESTART   **'         
               DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '**       PROCESSING TERMINATED      **'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
      *                                                                         
       8860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *    8888-COMMIT                                               **         
      *                                                              **         
      *****************************************************************         
       8888-COMMIT.                                                     
           PERFORM 1800-PREPARE-PRECOMMIT     THRU 1800-EXIT.           
           PERFORM 8800-WRITE-RESTART         THRU 8800-EXIT.           
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
           DISPLAY 'COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.'.          
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       8890-DELETE-RESTART-RECORD.                                      
           MOVE WS-PGRMNAME                      TO RF-NAME-PROGRAM.    
           MOVE 1                                TO RF-PARTITION-NO.    
           MOVE 1                                TO RF-DUP-CNTRL-NO.    
           EXEC SQL                                                     
             DELETE FROM CSS_RESTART                                    
              WHERE NAME_PROGRAM = :RF-NAME-PROGRAM                     
                AND DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                     
                AND PARTITION_NO = :RF-PARTITION-NO                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                          TO                     
                                                 WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '**  8890-DELETE-RESTART-RECORD     **'          
               DISPLAY '**   RETURN CODE = ' WS-ACTIVE-RETURN-CODE      
               DISPLAY '**       PROCESSING TERMINATED      **'         
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
       8890-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 8940-RESET-JOB-PARM.                                          *         
      *****************************************************************         
       8940-RESET-JOB-PARM.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_JOB_PARM                                      
                  SET STATUS       = :G6-STATUS,                        
                      PARM_DATA    = :G6-PARM-DATA                      
                WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                   
                  AND CMND_CODE    = :G6-CMND-CODE                      
                  AND COMPANY_NO   = :G6-COMPANY-NO                     
                  AND SEQ_NO       = :G6-SEQ-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                          TO                     
                                                 WS-ACTIVE-RETURN-CODE  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*** ERROR IN 8940-RESET-JOB-PARM ***'            
              DISPLAY '*** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '***   PROCESSING TERMINATED ***'                 
              PERFORM 9900-ABEND                     THRU 9900-EXIT     
           END-IF.                                                      
      *                                                                         
       8940-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05990000
      *                                                                *06000000
      *   9000-CLOSE-FILES.                                            *06010000
      *                                                                *06020000
      ******************************************************************06030000
       9000-TERMINATE.                                                  
                                                                        
           CLOSE FCSRP040-FILE.                                         
           IF FRP040-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA040 PROCESSING ERROR   **'           
               DISPLAY '**   FCSRP040-FILE WILL NOT CLOSE **'           
               DISPLAY '**      PARA - 9000-TERMINATE     **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               MOVE 12 TO RETURN-CODE                                   
               STOP RUN                                                 
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ** 9700-PROCESS-ABEND.                                         **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** 9900-ABEND.                                                 **         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     06330000
               INCLUDE CPD09900                                         06340000
           END-EXEC.                                                    06350000
