       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA032.                                        
       DATE-WRITTEN.   JUN 2003.                                        
           DATE-COMPILED.                                               
      ***************************************************************** 00050000
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL               ** 00060000
      **                     PRICE WATERHOUSE                        ** 00070000
      **                1410 NORTH WESTSHORE BLVD                    ** 00080000
      **                   TAMPA, FLORIDA  33607                     ** 00090000
      **                      (813) 287-9200                         ** 00100000
      **                                                             ** 00110000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00120000
      ********                      DB2                       ********* 00130000
      ***************************************************************** 00140000
      **                                                             ** 00150000
      **              PROGRAM  MODIFICATION  LOG                     ** 00160000
      **    DATE    INITIALS     REASON                              ** 00170000
      **    ----    --------     ------                              ** 00180000
T10890** 05/06/97     EMM        ADDED NO INPUT RECORD PROCESSING    ** 00190088
T18437** 03/17/99     ZB17046    ADDED LOGIC TO COMMIT DB2 UPDATES   ** 00270088
T18437**                         EVERY 100 ACCOUNTS PROCESSED.       ** 00280088
T18437**                         AT THE SAME TIME, ADDED LOGIC TO    ** 00290088
T18437**                         MAKE PROGRAM RESTARTABLE IN CASE OF ** 00300088
T18437**                         UNSUCCESSFUL COMPLETION.            ** 00310088
T18437**                         COMMENTED OUT PARAGRAPHS NOT BEING  ** 00320088
T18437**                         EXECUTED IN THE PROGRAM.            ** 00330088
T18437**                         SETUP ROUTINE 9600-PROCESS-ABEND    ** 00340088
T18437**                         TO BE EXECUTED FORM 9000-TERMINATE  ** 00350088
T18437**                         TO AVOID LOOP WITH THE 9700- ABEND  ** 00360088
T18437**                         ROUTINE WHICH EXECUTES TERMINATE.   ** 00370088
T23513** 02/01/01     CBSI       CHANGES MADE TO DISTINGUISH DATABASE * 00540088
T23513**              MDS        SEB AND NON SEB TO INCORPORATE PSNC  * 00550088
T23513**                         IN NON SEB                           * 00560088
C26954** 07/25/02     LF19392    SEBR CHANGES                           00600088
C26196** 06/14/03     RB19957    COPIED PCSCA132 AND DELETED/ADDED    * 00610088
C26196**              RICK       CODE TO DO SELECT ACCOUNTS FOR AUTO  * 00620088
C26196**                         TRANSFER OF FB & WRITE-OFF ACCOUNTS. * 00630088
T26196** 07/01/04     RB19957    ADDED CODE TO CHECK THAT THE 'FROM'  * 00630089
T26196**              RICK       ACCOUNT COMPANY NUMBER MATCHES THE   * 00630090
T26196**                         CU-AUTO-XFER-TO-ACCT COMPANY NUMBER. * 00630100
C35227** 03/07/07   DB41297    PERFORMANCE IMPROVEMENT.              **         
C30169** 03/12/08   CVNS       AUTO XFER WILL BE TRIGGERED BY        **         
C30169**            CHENNAI    FORECASTED DATES IN CSS_FIN_WO_ACTION **         
C30169**                       FOR ACTION TYPEAXFR1,AXFR2,AXFR3,     **         
C30169**                       AXFR4 AND AXFR5.                     **          
A01272** 12/03/09   VP94820    ALLOW CREDIT FORECAST FOR SUB-ACCOUNT **         
A01272**                       DURING FINAL BILLED.                  **         
A02036** 07/19/10   RB19957  1)FIX PARA 7100 SO IT DOES NOT ABEND    **         
A02036**                       WITH A 100(NOT FOUND). INSTEAD ACCOUNT**         
A02036**                       WILL BE BYPASSED.                     **         
A02036**                     2)UPDATE REMARKS.                       **         
A02036**                     3)REMOVE COMMENTED OUT CODE AND REMOVE  **         
A02036**                       WS FIELDS NOT USED.                   **         
A02036**                     4)REMOVE RESTART LOGIC NO LONGER NEEDED.**         
A04091** 04/14/12   NS75440  REMOVED "7240-CK-FOR-SEC-RATE" TO ALLOW **         
A04091**                     AUTO TRANSFER OF UNPAID MONEY FOR'FB' OR**         
A04091**                     'WO' SECURED RATE ACCOUNTS              **         
      **                                                             **         
A05154** 30 JAN 2015 RF10596 REMOVE UNUSED CODE                      **         
      **                                                             **         
      ***************************************************************** 00640000
           REMARKS.                                                     
      ******************************************************************00660000
      *   THE NOTICE/CHARGE OFF PROGRAM WILL BE EXECUTED DAILY         *00670000
A02036*   AND WILL BE TRIGGERED BY FORECASTED DATES IN                 *00680000
A02036*   CSS_FIN_WO_ACTION FOR ACTION TYPE AXFR1,AXFR2,AXFR3,         *00690000
A02036*   AXFR4 AND AXFR5 > LAST RUN DATE AND <= CURRENT DATE.         *00700000
      *   1  THESE RECORDS WILL BE WRITTEN TO THE FCSFA08 FILE WHICH   *00710000
      *      IS USED TO CREATE TRANSFER WO & FB ACCOUNTS.              *00720000
      *   2. RP32- EXCEPTION OR PARTIAL MATCH ACCOUNTS SELECTED FOR    *00730000
      *      EXCEPTION REPORTS FILE.                                   *00740000
      *                                                                *00750000
      *   THIS PROGRAM READS NUMEROUS TABLES ON THE DATABASE AND       *00760000
      *   CREATES EXTRACT FILES TO FEED TO OTHER PROGRAMS. THESE       *00770000
      *   FILES USE CWS10007 AS THE LAYOUT FOR THEIR DETAIL DATA.      *00780000
      ******************************************************************00790000
                     ---- BASIC BATCH SEQUENCE STRUCTURE ----           
                    0000 - 0000     MAIN CONTROL PATH                   
                    0100 - 0100     INITIALIZATION                      
                    1000 - 1000     MAJOR PROCESSING LOOP               
                    1100 - 4999     PERFORMED PARAGRAPHS OF MAJOR       
                                    PROCESSING LOOPS                    
                    5000 - 5999     COMMON PROGRAM MODULES              
                    6000 - 6999     COMMON SYSTEM MODULES               
                    7000 - 7999     INPUT MODULES                       
                    8000 - 8999     OUTPUT MODULES                      
                    9000 - 9799     TERMINATION MODULES                 
                    9900 - 9999     ABEND/ABORT MODULES                 
                          ---- PARAGRAPH STRUCTURE ----                 
           ---- ------------------------- ------------------------------
HPCCDM*    EJECT                                                        00940000
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.    IBM-370.                                     
       OBJECT-COMPUTER.    IBM-370.                                     
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
HPCCDM*    SKIP2                                                        01030000
           COPY CSSFA08.                                                01040000
HPCCDM*    SKIP2                                                        01050000
           COPY CSSRP032.                                               01060000
HPCCDM*    EJECT                                                        01220000
       DATA DIVISION.                                                   
      *                                                                 01240000
       FILE SECTION.                                                    
      *                                                                 01260000
       COPY CFDFA08.                                                    01300000
       COPY FIOFA08.                                                    01310000
      *                                                                 01320000
       COPY CFDRP032.                                                   01330000
       COPY FIORP032.                                                   01340000
      *                                                                 01350000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA032'.
MSQ017     COPY MFASQLM.
       01  WS-MISCELLANEOUS.                                            
           05 WS-START                 PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA032 STARTS HERE'.            
       COPY CWS00056.                                                   01600000
      *                                                                 01610000
       COPY CWS09900.                                                   01620000
      *                                                                 01630000
       01  WS-WORK-AREA.                                                
           05  WS-ACCT-FINALED-DT-NULL     PIC S9(04) COMP VALUE +0.    
           05  WS-LAST-PYMT-DATE-NULL      PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-BILL-DAY-00-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-BILL-DAY-30-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-BILL-DAY-60-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-BILL-DAY-90-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-DATE-LAST-ACTION-NULL    PIC S9(04) COMP VALUE +0.    
           05  WS-AUTO-XFER-ACCT-NULL      PIC S9(04) COMP VALUE +0.    
           05  WS-TOTAL-NON-UTIL-BAL-NULL  PIC S9(04) COMP VALUE +0.    
COB305     05 WS-CA-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
COB305     05 WS-CB-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.    
           05  WS-LAST-RUN-DATE            PIC X(10).                   
           05  WS-CURR-RUN-DATE            PIC X(10).                   
           05  WS-PROGRAM-DATE             PIC X(10).                   
           05  WS-FULL-NAME-SPACES         PIC X(50)     VALUE SPACES.  
           05  WS-SSN-SPACES               PIC X(09)     VALUE SPACES.  
COB305     05 WS-TOTAL-NON-UTIL-BAL        PIC S9(09)V99 COMP-3 VALUE 0.        
           05  WS-TO-COMPANY-NO            PIC X(02).                   
           05  WS-DISPLAY-SQLCODE          PIC -ZZZZZZZZ9.              
           05  WS-ACCOUNT-TYPE-CODE        PIC X(1).                    
COB305     05 WS-TEMP-CUSTOMER-NO        PIC S9(10) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-TOTAL-BAL                PIC S9(07)V99 COMP-3 VALUE 0.
C30169     05  WS-AXFR1                    PIC X(05)  VALUE 'AXFR1'.    
C30169     05  WS-AXFR2                    PIC X(05)  VALUE 'AXFR2'.    
C30169     05  WS-AXFR3                    PIC X(05)  VALUE 'AXFR3'.    
C30169     05  WS-AXFR4                    PIC X(05)  VALUE 'AXFR4'.    
COB305     05 WS-LOWER-LIMIT        PIC S9(4)V99 COMP-3 VALUE 0.         
           05  WS-WRITE-OFF-BAL            PIC S9(09)V99 COMP-3 VALUE 0.
           05  WS-RETURN-CODE7000          PIC S9(04) COMP VALUE 0.     
           05  WS-RETURN-CODE7002          PIC S9(04) COMP VALUE 0.     
           05  WS-SORT-KEY.                                             
               10  WS-COMPANY-NBR          PIC X(02)     VALUE SPACES.  
               10  WS-ACCOUNT-NO           PIC 9(13)     VALUE ZEROS.   
               10  WS-SEQ-NO               PIC 9(05)     VALUE ZEROS.   
               10  WS-OUTPUT-ID            PIC X(04)     VALUE SPACES.  
T26196     05  WS-CREDIT-HIST-NO.                                       
T26196         10  WS-CREDIT-HIST-NO1      PIC X(01).                   
T26196         10  FILLER                  PIC X(23).                   
COB305     05 WS-HOLD-DEL-VALUE        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0. 
           05  WS-HOLD-FIORP032            PIC X(230).                  
      ******************************************************************01970088
       01  WS-FROM-ACCOUNT-INFO.                                        
COB305     10 WS-FR-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     10 WS-FR-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           10 WS-FR-BILL-CYCLE         PIC X(2).                        
           10 WS-FR-CODE-ACCT-STAT     PIC X(1).                        
           10 WS-FR-CODE-STATUS-REASON PIC X(1).                        
           10 WS-FR-ACCOUNT-TYPE-CODE  PIC X(1).                        
           10 WS-FR-DATE-BILL-DAY-00   PIC X(10).                       
           10 WS-FR-DATE-BILL-DAY-30   PIC X(10).                       
           10 WS-FR-DATE-BILL-DAY-60   PIC X(10).                       
           10 WS-FR-DATE-BILL-DAY-90   PIC X(10).                       
COB305     10 WS-FR-TOTAL-AR-BALANCE        PIC S9(11)V9(2) 
COB305       USAGE COMP-3 VALUE 0.    
           10 WS-FR-CODE-CRIT-OUTAGE   PIC X(2).                        
           10 WS-FR-CODE-MAJOR-ACCT    PIC X(1).                        
           10 WS-FR-CODE-REPRINT-BILL  PIC X(1).                        
           10 WS-FR-CODE-COMPANY-ACCT  PIC X(1).                        
           10 WS-FR-CODE-LPC-XMT       PIC X(1).                        
           10 WS-FR-CODE-BILL-FREQ     PIC X(3).                        
           10 WS-FR-CODE-PERM-BILL     PIC X(1).                        
           10 WS-FR-CODE-P-BILL-DEST   PIC X(1).                        
           10 WS-FR-CODE-TEMP-BILL     PIC X(1).                        
           10 WS-FR-CODE-BILL-PEND     PIC X(1).                        
           10 WS-FR-NOTICE-EXEMPT-CD   PIC X(1).                        
           10 WS-FR-NO-BILL-COPIES     PIC S9(4) USAGE COMP.            
           10 WS-FR-CODE-GROUP-ACCT    PIC S9(9) USAGE COMP.            
           10 WS-FR-NO-MO-ONLINE-HIST  PIC S9(4) USAGE COMP.            
           10 WS-FR-CODE-ACCT-BILLED   PIC X(1).                        
           10 WS-FR-DATE-EARLY-PAY     PIC X(10).                       
           10 WS-FR-LOCAL-OFFICE       PIC X(3).                        
COB305     10 WS-FR-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           10 WS-FR-DATE-LAST-ACTION   PIC X(10).                       
           10 WS-FR-CODE-DISC-OK       PIC X(1).                        
           10 WS-FR-DATE-CRNT-BIL-DLNQ PIC X(10).                       
COB305     10 WS-FR-ACCT-XFER-TO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
COB305     10 WS-FR-ACCT-XFER-FROM-LST        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
           10 WS-FR-BILL-HIST-XFER-IND PIC X(1).                        
           10 WS-FR-AR-XFER-IND        PIC X(1).                        
           10 WS-FR-CODES-DATA-PRESENT PIC X(32).                       
           10 WS-FR-DATE-REV-CHG-AUTH  PIC X(10).                       
           10 WS-FR-WORK-Q-PEND        PIC X(1).                        
           10 WS-FR-MARKETING-PEND     PIC X(1).                        
           10 WS-FR-EARLY-PAY-REASON   PIC X(16).                       
           10 WS-FR-COMPANY-NO         PIC X(2).                        
           10 WS-FR-CREDIT-GROUP       PIC X(1).                        
           10 WS-FR-BANKRUPTCY-IND     PIC X(1).                        
           10 WS-FR-MST-SUB-ACCT-IND   PIC X(1).                        
           10 WS-FR-PRINT-TYPE-CD      PIC X(1).                        
           10 WS-FR-CUST-PREM-REL      PIC X(1).                        
           10 WS-FR-ACCT-CREATE-DT     PIC X(26).                       
           10 WS-FR-ACCT-FINALED-DT    PIC X(26).                       
           10 WS-FR-DISCON-REASON-CD   PIC X(1).                        
           10 WS-FR-BILL-CYCLE-CHG-CD  PIC X(1).                        
           10 WS-FR-MST-OVRRD-BLL-IND  PIC X(1).                        
           10 WS-FR-CODE-PRNT-BLL-MST  PIC X(1).                        
           10 WS-FR-NO-MO-BILL-HIST    PIC S9(4) USAGE COMP.            
           10 WS-FR-NXT-BILL-NO        PIC S9(9) USAGE COMP.            
           10 WS-FR-LAST-NRML-BILL-NO  PIC S9(9) USAGE COMP.            
           10 WS-FR-NXT-SMRY-BILL-NO   PIC S9(9) USAGE COMP.            
           10 WS-FR-NXT-SMRY-REBILL-NO PIC S9(9) USAGE COMP.            
           10 WS-FR-BNKRPT-CASE-NO     PIC X(10).                       
           10 WS-FR-CODE-ACCT-USAGE    PIC X(1).                        
COB305     10 WS-FR-ADDRESS-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           10 WS-FR-ADDRESS-FORMAT     PIC X(1).                        
           10 WS-FR-REDUCTN-FXDFCT-IND PIC X(1).                        
           10 WS-FR-CANREB-CODE-00-DAY PIC X(1).                        
           10 WS-FR-CANREB-CODE-30-DAY PIC X(1).                        
           10 WS-FR-CANREB-CODE-60-DAY PIC X(1).                        
           10 WS-FR-CANREB-CODE-90-DAY PIC X(1).                        
           10 WS-FR-CUST-RQST-RD-TIME  PIC X(8).                        
           10 WS-FR-CUST-RQST-RD-DT-CD PIC X(2).                        
           10 WS-FR-LAST-UPDATE-TS     PIC X(26).                       
           10 WS-FR-CREDIT-STATUS-CODE PIC X(1).                        
           10 WS-FR-LAST-PYMT-DATE     PIC X(10).                       
COB305     10 WS-FR-LAST-PYMT-AMOUNT        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           10 WS-FR-CT-METER-RATED-IND PIC X(1).                        
COB305     10 WS-FR-EPP-OFFER-AMOUNT        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           10 WS-FR-EPP-OFFER-DATE     PIC X(10).                       
COB305     10 WS-FR-REV-MTH-LST-NRML        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.         
COB305     10 WS-FR-ELEC-REV-ALLOC-PCT        PIC S9(3)V9(2) 
COB305       USAGE COMP-3 VALUE 0.     
           10 WS-FR-MEMO-BILL-IND      PIC X(1).                        
           10 WS-FR-JUDGMENT-CASE-NO   PIC X(10).                       
           10 WS-FR-JUDGMENT-IND       PIC X(1).                        
           10 WS-FR-EXT-BILLING-FL     PIC X(1).                        
           10 WS-FR-MAX-DEP-REF-XMT-CD PIC X(1).                        
      ******************************************************************02820088
       01  WS-FROM-MISC-INFO.                                           
           10 DQ-FROM-NAME             PIC X(50).                       
           10 DQ-FROM-NAME-TYPE        PIC X(02).                       
COB305     10 CE-FROM-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           10 CE-FROM-SSN              PIC X(9).                        
           10 CE-FROM-CUSTOMER-TYPE    PIC X(1).                        
      ******************************************************************02880088
      *                                                                 02890088
       01  WS-PROGRAM-FLAGS.                                            
           05  WS-FA08-SELECT             PIC X(01)  VALUE 'N'.         
               88  FA08-SELECTED                     VALUE 'Y'.         
           05  WS-RP032-SELECT            PIC X(01)  VALUE 'N'.         
               88  RP032-SELECTED                    VALUE 'Y'.         
           05  WS-NO-MORE-DATA            PIC X(01)  VALUE 'N'.         
               88  NO-MORE-DATA                      VALUE 'Y'.         
           05  WS-FATAL-ERROR             PIC X(01)  VALUE 'N'.         
               88  YES-FATAL-ERROR                   VALUE 'Y'.         
           05  WS-BYPASS                  PIC X(01)  VALUE 'N'.         
               88  YES-BYPASS                        VALUE 'Y'.         
           05  WS-FINISH                  PIC X(01)  VALUE 'N'.         
               88  YES-FINISH                        VALUE 'Y'.         
           05  WS-END-REC-PROCESSED       PIC X(01)  VALUE 'N'.         
           05  WS-BEGIN-REC-PROCESSED     PIC X(01)  VALUE 'N'.         
           05  WS-MORE-BEGIN-REC          PIC X(01)  VALUE 'N'.         
           05  WS-RECONNECT-ROW-EXISTS    PIC X(01)  VALUE 'N'.         
           05  WS-FRP032-FLAGS-SET        PIC X(01)  VALUE 'N'.         
           05  WS-FRP032-MULTI-ACCT2      PIC X(01)  VALUE 'N'.         
           05  WS-ACCT-PRE-SELECTED       PIC X(01)  VALUE 'N'.         
C26954     05  WS-SEB-SENIOR-FLAG         PIC X(01)  VALUE 'N'.         
C26954         88  WS-SEB-SENIOR                     VALUE 'Y'.         
C26954     05  WS-SEB-REG-FLAG            PIC X(01)  VALUE 'N'.         
C26954         88  WS-SEB-REGULATED                  VALUE 'Y'.         
           05  WS-OUTPUT-FLAGS.                                         
               10  WS-AUTO-XFER-EXEMP-FL    PIC X(01).                  
               10  WS-BNKDRFT-ACCT2-FLAG    PIC X(01).                  
               10  WS-WO-ARRANG-ACCT1-FLAG  PIC X(01).                  
               10  WS-ACT-SURETY-EITHER-FLAG PIC X(01).                 
               10  WS-ACT-IRLOC-EITHER-FLAG PIC X(01).                  
T18437     05  WS-FCSFA08R-EOF            PIC X(01)  VALUE 'N'.         
T18437         88  FCSFA08R-EOF                      VALUE 'Y'.         
T18437     05  WS-FCSRP32R-EOF            PIC X(01)  VALUE 'N'.         
T18437         88  FCSRP32R-EOF                      VALUE 'Y'.         
T23513     05  WS-DATABASES               PIC 9(01)  VALUE ZERO.        
T23513         88  CSR-DATABASE                      VALUE 1.           
T23513         88  SEB-DATABASE                      VALUE 2.           
T18437     05  WS-DATA-FOUND               PIC X(1)  VALUE 'Y'.         
           05  WS-SCEG                     PIC X(02) VALUE '01'.        
           05  WS-PSNC                     PIC X(02) VALUE '26'.        
A02036     05  WS-ACCOUNT-NOT-FOUND        PIC X(1)  VALUE 'N'.         
      *                                                                 03310088
       01  WS-FILE-STATUS.                                              
           05  WS-FFA08-STATUS            PIC X(02).                    
               88  FFA08-SUCCESSFUL       VALUE '00'.                   
           05  WS-FRP032-STATUS           PIC X(02).                    
               88  FRP032-SUCCESSFUL      VALUE '00'.                   
      *                                                                 03430088
       01  WS-RECORD-COUNTERS.                                          
           05  WS-FFA08-REC-CNTR       PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-FFA08-SEQ-NO         PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-FRP032-REC-CNTR      PIC S9(07) COMP-3 VALUE ZERO.    
           05  WS-FRP032-SEQ-NO        PIC S9(07) COMP-3 VALUE ZERO.    
T18437     05  WS-COMMITS-COUNT        PIC 9(4)   VALUE ZEROES.         
T18437     05  WS-RECS-TO-COMMIT-COUNT PIC 9(3)   VALUE ZEROES.         
      **********************************                                03530000
       01  WS-LITERALS.                                                 
           05  WS-CUSTOMER             PIC X(01)     VALUE 'C'.         
           05  WS-N                    PIC X(01)     VALUE 'N'.         
           05  WS-Y                    PIC X(01)     VALUE 'Y'.         
           05  WS-811                  PIC S9(9) VALUE -811.            
TP5109     05  PROGRAM-NAME            PIC X(08) VALUE 'PCSCA032'.      
           05  WS-PGRMNAME             PIC X(08) VALUE 'PCSCA032'.      
           05  WS-LAST-R-DATE-LITERAL  PIC X(14)  VALUE                 
                  'LAST RUN DATE='.                                     
           05  WS-CURR-R-DATE-LITERAL  PIC X(14)  VALUE                 
                  'CURR RUN DATE='.                                     
       01  SCSCB068                     PIC X(08)  VALUE 'SCSCB068'.    
      *                                                                 03620000
TP5228 01  RS-RPC-RETURN-CODE.                                          
TP5228     05  RS-RETURN-CODE          PIC S9(04) COMP VALUE 0.         
TP5228     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
      *                                                                 03660088
           COPY FIOCA00.                                                03910000
T30169     COPY FIOJC01.                                                03920000
      *                                                                 03930000
           COPY CWS00303.                                               03940000
           COPY CWS00010.                                               03950000
      *                                                                 03960000
           EXEC SQL                                                     03970000
              INCLUDE CWS00038                                          03980000
           END-EXEC.                                                    03990000
      *                                                                 04000000
           EXEC SQL                                                     04000200
              INCLUDE CWS00039                                          04000300
           END-EXEC.                                                    04000400
      *                                                                 04000500
           EXEC SQL                                                     04010000
              INCLUDE CWS00068                                          04020000
           END-EXEC.                                                    04030000
      *                                                                 04040000
      ******************************************************************04100200
      * COBOL DECLARATION FOR TABLE CSS_ACCT_ATTRIBUTE            *     04100300
      ******************************************************************04100400
           EXEC SQL                                                     04100500
              INCLUDE TBACTATT                                          04100600
           END-EXEC.                                                    04100700
      *                                                                 04110000
      ******************************************************************04370088
      * COBOL DECLARATION FOR TABLE CSS_JOB_PARM                   *    04380088
      ******************************************************************04390088
           EXEC SQL                                                     04400000
              INCLUDE TBJBPARM                                          04410000
           END-EXEC.                                                    04420000
      *                                                                 04430000
      ******************************************************************04440088
      * COBOL DECLARATION FOR SQL STUFF                            *    04450088
      ******************************************************************04460088
           EXEC SQL                                                     04470000
               INCLUDE SQLCA                                            04480000
           END-EXEC.                                                    04490000
      *                                                                 04500000
      ******************************************************************04580088
      * COBOL DECLARATION FOR TABLE CSS_ACCOUNT                    *    04590088
      ******************************************************************04600088
           EXEC SQL                                                     04610000
               INCLUDE TBACCT                                           04620000
           END-EXEC.                                                    04630000
      *                                                                 04640000
      ******************************************************************04650088
      * COBOL DECLARATION FOR TABLE CSS_AR_CNTL                    *    04660088
      ******************************************************************04670088
           EXEC SQL                                                     04680000
               INCLUDE TBARCNTL                                         04690000
           END-EXEC.                                                    04700000
      *                                                                 04700100
      ******************************************************************04700490
      * COBOL DECLARATION FOR TABLE CSS_CREDIT_PROFILE             *    04700491
      ******************************************************************04700492
           EXEC SQL                                                     04700500
               INCLUDE TBCRPROF                                         04700600
           END-EXEC.                                                    04700700
      *                                                                 04710000
      ******************************************************************04720088
      * COBOL DECLARATION FOR TABLE CSS_CUSTOMER                   *    04730088
      ******************************************************************04740088
           EXEC SQL                                                     04750000
               INCLUDE TBCUST                                           04760000
           END-EXEC.                                                    04770000
      *                                                                 04780000
      ******************************************************************04790088
      * COBOL DECLARATION FOR TABLE CSS_CUST_STATS                 *    04800088
      ******************************************************************04810088
           EXEC SQL                                                     04820000
               INCLUDE TBCSTSTS                                         04830000
           END-EXEC.                                                    04840000
      *                                                                 04850000
      ******************************************************************04860088
      * COBOL DECLARATION FOR TABLE CSS_NAME                       *    04870088
      ******************************************************************04880088
           EXEC SQL                                                     04890000
               INCLUDE TBNAME                                           04900000
           END-EXEC.                                                    04910000
      *                                                                 04920000
      ******************************************************************05070088
      * COBOL DECLARATION FOR TABLE CSS_DELINQUENCY                *    05080088
      ******************************************************************05090088
           EXEC SQL                                                     05100000
              INCLUDE TBDELQ                                            05110000
           END-EXEC.                                                    05120000
      *                                                                 05130000
      ******************************************************************05140088
      * COBOL DECLARATION FOR TABLE CSS_SURETY_BOND                *    05150088
      ******************************************************************05160088
           EXEC SQL                                                     05170000
              INCLUDE TBSTYBND                                          05180000
           END-EXEC.                                                    05190000
      *                                                                 05200000
      ******************************************************************05420088
      * COBOL DECLARATION FOR TABLE CSS_CONTRACT                   *    05430088
      ******************************************************************05440088
KDFKDF     EXEC SQL                                                     05450088
KDFKDF         INCLUDE TBCNTRCT                                         05460088
KDFKDF     END-EXEC.                                                    05470088
      *                                                                 05480000
      ******************************************************************05490088
      * COBOL DECLARATION FOR TABLE CSS_REG_PROFILE                *    05500088
      ******************************************************************05510088
KDFKDF     EXEC SQL                                                     05520088
KDFKDF         INCLUDE TBREGPRF                                         05530088
KDFKDF     END-EXEC.                                                    05540088
      ******************************************************************05490088
      * KD - CSS_FIN_WO_ACTION                                         *05500088
      ******************************************************************05510088
C30169     EXEC SQL                                                     05520088
C30169         INCLUDE  TBFWACTN                                        05530088
C30169     END-EXEC.                                                    05540088
      ******************************************************************05550088
      ******************************************************************05560000
           EXEC SQL                                                     
              DECLARE GET_OTHER_ACCTS CURSOR WITH HOLD FOR              
              SELECT                                                    
                     AT.ACCOUNT_NO,                                     
                     AT.CUSTOMER_NO,                                    
                     AT.PREMISE_NO,                                     
                     AT.COMPANY_NO,                                     
                     AT.LOCAL_OFFICE,                                   
                     AT.DATE_BILL_DAY_00,                               
                     AT.DATE_BILL_DAY_30,                               
                     AT.DATE_BILL_DAY_60,                               
                     AT.DATE_BILL_DAY_90,                               
                     AT.DATE_LAST_ACTION,                               
                     AT.CODE_DISC_OK,                                   
                     AT.CODE_LPC_XMT,                                   
                     AT.CODE_PERM_BILL,                                 
                     AT.BILL_CYCLE,                                     
                     AT.TOTAL_AR_BALANCE,                               
                     AT.LAST_PYMT_AMOUNT,                               
                     AT.LAST_PYMT_DATE,                                 
                     AT.CODES_DATA_PRESENT,                             
                     AT.CODE_COMPANY_ACCT,                              
                     AT.CODE_ACCT_STAT,                                 
                     AT.ADDRESS_FORMAT,                                 
                     AT.ADDRESS_ID,                                     
                     AT.MST_SUB_ACCT_IND,                               
                     AT.CODE_MAJOR_ACCT,                                
                     AT.CREDIT_GROUP,                                   
                     AT.ACCOUNT_TYPE_CODE,                              
                     AT.BANKRUPTCY_IND,                                 
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT,                                
                     AT.NOTICE_EXEMPT_CD,                               
                     AT.CODE_STATUS_REASON,                             
                     AT.JUDGEMENT_CASE_NO                               
              FROM CSS_ACCOUNT AT                                       
              WHERE  AT.ACCOUNT_NO IN                                   
                   (SELECT AT.ACCOUNT_NO                                
                      FROM CSS_ACCOUNT AT                               
                    WHERE AT.CUSTOMER_NO = :WS-TEMP-CUSTOMER-NO         
                      AND AT.COMPANY_NO = :WS-FR-COMPANY-NO             
                      AND AT.CODE_ACCT_STAT = 'A')                      
               AND  AT.ACCOUNT_NO IN                                    
                (SELECT AT.ACCOUNT_NO                                   
                 FROM CSS_ACCOUNT AT                                    
                WHERE AT.ACCOUNT_NO <> :WS-FR-ACCOUNT-NO)               
                  AND AT.CREDIT_GROUP <> 'D'                            
                  AND AT.ACCOUNT_TYPE_CODE <> 'N'                       
C35227        FOR READ ONLY                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     05570000
MFA-TR*       DECLARE GET_OTHER_ACCTS CURSOR WITH HOLD FOR              05580000
MFA-TR*       SELECT                                                    05590000
MFA-TR*              AT.ACCOUNT_NO,                                     05600000
MFA-TR*              AT.CUSTOMER_NO,                                    05610000
MFA-TR*              AT.PREMISE_NO,                                     05620000
MFA-TR*              AT.COMPANY_NO,                                     05630000
MFA-TR*              AT.LOCAL_OFFICE,                                   05640000
MFA-TR*              AT.DATE_BILL_DAY_00,                               05650000
MFA-TR*              AT.DATE_BILL_DAY_30,                               05660000
MFA-TR*              AT.DATE_BILL_DAY_60,                               05670000
MFA-TR*              AT.DATE_BILL_DAY_90,                               05680000
MFA-TR*              AT.DATE_LAST_ACTION,                               05690000
MFA-TR*              AT.CODE_DISC_OK,                                   05700000
MFA-TR*              AT.CODE_LPC_XMT,                                   05710000
MFA-TR*              AT.CODE_PERM_BILL,                                 05720000
MFA-TR*              AT.BILL_CYCLE,                                     05730000
MFA-TR*              AT.TOTAL_AR_BALANCE,                               05740000
MFA-TR*              AT.LAST_PYMT_AMOUNT,                               05750000
MFA-TR*              AT.LAST_PYMT_DATE,                                 05760000
MFA-TR*              AT.CODES_DATA_PRESENT,                             05770000
MFA-TR*              AT.CODE_COMPANY_ACCT,                              05780000
MFA-TR*              AT.CODE_ACCT_STAT,                                 05790000
MFA-TR*              AT.ADDRESS_FORMAT,                                 05800000
MFA-TR*              AT.ADDRESS_ID,                                     05810000
MFA-TR*              AT.MST_SUB_ACCT_IND,                               05820000
MFA-TR*              AT.CODE_MAJOR_ACCT,                                05830000
MFA-TR*              AT.CREDIT_GROUP,                                   05840000
MFA-TR*              AT.ACCOUNT_TYPE_CODE,                              05850000
MFA-TR*              AT.BANKRUPTCY_IND,                                 05860000
MFA-TR*              AT.ACCT_FINALED_DT,                                05870000
MFA-TR*              AT.NOTICE_EXEMPT_CD,                               05880000
MFA-TR*              AT.CODE_STATUS_REASON,                             05890000
MFA-TR*              AT.JUDGEMENT_CASE_NO                               05900000
MFA-TR*       FROM CSS_ACCOUNT AT                                       05910000
MFA-TR*       WHERE  AT.ACCOUNT_NO IN                                   05940710
MFA-TR*            (SELECT AT.ACCOUNT_NO                                05940800
MFA-TR*               FROM CSS_ACCOUNT AT                               05940900
MFA-TR*             WHERE AT.CUSTOMER_NO = :WS-TEMP-CUSTOMER-NO         05941000
MFA-TR*               AND AT.COMPANY_NO = :WS-FR-COMPANY-NO             05941100
MFA-TR*               AND AT.CODE_ACCT_STAT = 'A')                      05941200
MFA-TR*        AND  AT.ACCOUNT_NO IN                                    05940300
MFA-TR*         (SELECT AT.ACCOUNT_NO                                   05940400
MFA-TR*          FROM CSS_ACCOUNT AT                                    05940500
MFA-TR*         WHERE AT.ACCOUNT_NO <> :WS-FR-ACCOUNT-NO)               05940600
MFA-TR*           AND AT.CREDIT_GROUP <> 'D'                            05940700
MFA-TR*           AND AT.ACCOUNT_TYPE_CODE <> 'N'                       05940701
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*    END-EXEC.                                                    05950000
      *************************                                         05960000
C30169     EXEC SQL                                                     
C30169        DECLARE GET_CA_CRED_BUR CURSOR FOR                        
C30169        SELECT AT.ACCOUNT_NO,                                     
C30169               AT.CUSTOMER_NO,                                    
C30169               AT.PREMISE_NO,                                     
C30169               AT.COMPANY_NO,                                     
C30169               AT.LOCAL_OFFICE,                                   
C30169               KD.FW_ACTION_TYPE_CD,                              
C30169               KD.FW_ACTION_DT                                    
C30169          FROM CSS_FIN_WO_ACTION KD,                              
C30169               CSS_ACCOUNT AT                                     
C30169         WHERE KD.ACCOUNT_NO      = AT.ACCOUNT_NO                 
C30169           AND KD.FW_ACTION_TYPE_CD IN ('AXFR1','AXFR2',          
C30169                                        'AXFR3','AXFR4')          
C30169           AND KD.FW_ACTION_DT   >  IIF(TRY_CONVERT(DATE, 
                                                      :WS-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-LAST-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-LAST-RUN-DATE) )             
C30169           AND KD.FW_ACTION_DT   <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-CURR-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-RUN-DATE
              ) <> 0) OR (LEN(:WS-CURR-RUN-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-CURR-RUN-DATE
              ), CONVERT(DATE, :WS-CURR-RUN-DATE) )             
C30169         ORDER BY AT.ACCOUNT_NO                                   
C30169           FOR READ ONLY                                         
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE GET_CA_CRED_BUR CURSOR FOR                                
MFA-TR*       SELECT AT.ACCOUNT_NO,                                             
MFA-TR*              AT.CUSTOMER_NO,                                            
MFA-TR*              AT.PREMISE_NO,                                             
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              KD.FW_ACTION_TYPE_CD,                                      
MFA-TR*              KD.FW_ACTION_DT                                            
MFA-TR*         FROM CSS_FIN_WO_ACTION KD,                                      
MFA-TR*              CSS_ACCOUNT AT                                             
MFA-TR*        WHERE KD.ACCOUNT_NO      = AT.ACCOUNT_NO                         
MFA-TR*          AND KD.FW_ACTION_TYPE_CD IN ('AXFR1','AXFR2',                  
MFA-TR*                                       'AXFR3','AXFR4')                  
MFA-TR*          AND KD.FW_ACTION_DT   >  :WS-LAST-RUN-DATE                     
MFA-TR*          AND KD.FW_ACTION_DT   <= :WS-CURR-RUN-DATE                     
MFA-TR*        ORDER BY AT.ACCOUNT_NO                                           
MFA-TR*          FOR FETCH ONLY                                                 
MFA-TR*    END-EXEC.                                                            
C30169*                                                                         
      *************************                                         06880000
           EXEC SQL                                                     
              DECLARE GET_OTHER_CUSTS CURSOR FOR                        
              SELECT                                                    
                     DQ.NAME_ID,                                        
                     DQ.FULL_NAME,                                      
                     DQ.NAME_TYPE,                                      
                     CE.CUSTOMER_NO,                                    
                     CE.CUSTOMER_TYPE,                                  
                     CE.SSN                                             
              FROM CSS_NAME DQ WITH(READUNCOMMITTED),                           
                   CSS_CUST_STATS CE WITH(READUNCOMMITTED)                      
              WHERE DQ.NAME_ID = CE.NAME_ID                             
                AND DQ.FULL_NAME = :DQ-FROM-NAME                        
                AND DQ.FULL_NAME <> :WS-FULL-NAME-SPACES                
                AND DQ.NAME_ID <> :CE-FROM-NAME-ID                      
                AND CE.CUSTOMER_NO <> :WS-FR-CUSTOMER-NO                
              GROUP BY DQ.NAME_ID, DQ.FULL_NAME, DQ.NAME_TYPE,          
                       CE.CUSTOMER_NO, CE.CUSTOMER_TYPE, CE.SSN         
C35227        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06890000
MFA-TR*       DECLARE GET_OTHER_CUSTS CURSOR FOR                        06900000
MFA-TR*       SELECT                                                    06910000
MFA-TR*              DQ.NAME_ID,                                        06920000
MFA-TR*              DQ.FULL_NAME,                                      06920100
MFA-TR*              DQ.NAME_TYPE,                                      06921090
MFA-TR*              CE.CUSTOMER_NO,                                    06930000
MFA-TR*              CE.CUSTOMER_TYPE,                                  06930100
MFA-TR*              CE.SSN                                             06940000
MFA-TR*       FROM CSS_NAME DQ,                                         06950000
MFA-TR*            CSS_CUST_STATS CE                                    06960000
MFA-TR*       WHERE DQ.NAME_ID = CE.NAME_ID                             06970000
MFA-TR*         AND DQ.FULL_NAME = :DQ-FROM-NAME                        06980000
MFA-TR*         AND DQ.FULL_NAME <> :WS-FULL-NAME-SPACES                06990000
MFA-TR*         AND DQ.NAME_ID <> :CE-FROM-NAME-ID                      07000000
MFA-TR*         AND CE.CUSTOMER_NO <> :WS-FR-CUSTOMER-NO                07010000
MFA-TR*       GROUP BY DQ.NAME_ID, DQ.FULL_NAME, DQ.NAME_TYPE,          07010100
MFA-TR*                CE.CUSTOMER_NO, CE.CUSTOMER_TYPE, CE.SSN         07010200
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    07020000
      *************************                                         07030000
       01  WS-MISC-END.                                                 
           05 WS-END                   PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSCA032 ENDS HERE'.              
      *                                                                 07030000
       PROCEDURE DIVISION.                                              
      ******************************************************************07170000
      *   0000-MAINLINE.                                               *07180000
      *        CONTROLS THE MAIN PROCESS OF PROGRAM                    *07190000
      ******************************************************************07200000
       0000-MAINLINE.                                                   
      *                                                                 07220000
           PERFORM 0100-INITIALIZATION                 THRU 0100-EXIT.  
      *                                                                 07240000
C30169     PERFORM 0105-GET-RUN-DATES         THRU 0105-EXIT.           
C30169     PERFORM 7070-OPEN-COLL-AGY-CRED-BUR  THRU 7070-OPEN-EXIT.    
C30169     PERFORM 7080-GET-COLL-AGY-CRED-BUR   THRU 7080-EXIT.         
C30169     PERFORM 1055-PROCESS-COLL-AGY-CRED-BUR THRU 1055-EXIT        
C30169       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                   
C30169     PERFORM 7090-CLOSE-COLL-AGY-CRED-BUR THRU 7090-CLOSE-EXIT.   
      *                                                                 07570000
           PERFORM 0200-WRITE-END-CONTROLS THRU 0200-EXIT.              
           PERFORM 4750-UPD-LAST-RUN-DATE  THRU 4750-EXIT.              
           PERFORM 9000-TERMINATE          THRU 9000-EXIT.              
      *                                                                 07640088
TP2056     STOP RUN.                                                    
      *                                                                 07660088
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07690088
      ******************************************************************07700000
      *   0100-INITIALIZATION                                          *07710000
      *        COMMON INITIALIZATION ROUTINE                           *07720000
      ******************************************************************07730000
       0100-INITIALIZATION.                                             
      *                                                                 08240032
           OPEN OUTPUT FCSFA08-FILE.                                    
           IF FFA08-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA032 PROCESSING ERROR   **'           
               DISPLAY '**   FCSFA08-FILE WILL NOT OPEN   **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 08240300
           OPEN OUTPUT FCSRP032-FILE.                                   
           IF FRP032-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA032 PROCESSING ERROR   **'           
               DISPLAY '**   FCSRP032-FILE WILL NOT OPEN  **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 08241300
           PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT.                  
C30169     IF COMMON-DATE-NEEDED                                        
C30169         PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT        
C30169         MOVE WS-FCA00-COMMON-DATE TO WS-INPUT-DATE               
C30169     END-IF.                                                      
           MOVE WS-INPUT-DATE TO WS-PROGRAM-DATE                        
                                 WS-HOLD-DATE.                          
C30169     PERFORM 0190-WRITE-BEGIN-CONTROLS THRU 0190-EXIT.            
      *                                                                 08244300
      ******************************************************************08250088
      *   CHECK CSS_DELINQUENCY TABLE FOR CURRENT DATABASE - CSR/SEB   *08260088
      ******************************************************************08270088
      *                                                                 08280088
           MOVE ZERO TO WS-DATABASES.                                   
           MOVE '01' TO AT-COMPANY-NO.                                  
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 1800-SELECT-DELINQUENCY THRU 1800-EXIT.              
           MOVE  WS-HOLD-DEL-VALUE TO WS-DATABASES.                     
      *                                                                 08340088
      ** EXCP LIMIT NEEDED TO SELECT ACCOUNTS W/BAL > LIMIT.            08360088
           MOVE ZERO TO WS-LOWER-LIMIT.                                 
           MOVE '01' TO AT-COMPANY-NO.                                  
           MOVE 'AUTO-XFER-LIMIT' TO C8-DELINQ-CD.                      
           PERFORM 1800-SELECT-DELINQUENCY THRU 1800-EXIT.              
           MOVE WS-HOLD-DEL-VALUE TO WS-LOWER-LIMIT.                    
      *                                                                 08390088
T18437     MOVE 1 TO WS-RECS-TO-COMMIT-COUNT.                           
           INITIALIZE WS-FROM-ACCOUNT-INFO.                             
           INITIALIZE E-FRP032-DATA-REC.                                
           INITIALIZE FIOFA08.                                          
           MOVE SPACES TO DQ-FROM-NAME-TYPE                             
                          DQ-FROM-NAME                                  
                          CE-FROM-SSN                                   
                          CE-FROM-CUSTOMER-TYPE.                        
           MOVE 'N' TO WS-FATAL-ERROR                                   
                       WS-BYPASS                                        
                       WS-FINISH                                        
                       WS-FA08-SELECT                                   
                       WS-RP032-SELECT.                                 
      *                                                                 08410088
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08440088
      ******************************************************************08450080
      *     0105-GET-RUN-DATES.                                        *08460000
      *     MODULE RETRIEVES THE DATE OF THE LAST RUN OF PCSCA032.     *08470020
      ******************************************************************08480050
C30169 0105-GET-RUN-DATES.                                              
C30169                                                                  
C30169     MOVE SPACES                TO WS-SYSIPT.                     
C30169     MOVE WS-PARM               TO WS-COMMAND.                    
C30169     MOVE PROGRAM-NAME          TO WS-PROGRAM.                    
C30169     MOVE '01'                  TO G6-COMPANY-NO.                 
C30169     MOVE +10                   TO G6-SEQ-NO.                     
C30169     PERFORM 7600-START-FCSJC01                THRU 7600-EXIT.    
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        SELECT  PARM_DATA                                         
C30169                INTO                                              
C30169                :WS-INPUT-DATA-BREAKDOWN                          
C30169       FROM    CSS_JOB_PARM WITH(READUNCOMMITTED)                         
C30169       WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                  
C30169         AND   CMND_CODE      = :G6-CMND-CODE                     
C30169         AND   COMPANY_NO     = :G6-COMPANY-NO                    
C30169         AND   SEQ_NO         = :G6-SEQ-NO                        
C35227                                                           
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08580088
MFA-TR*       SELECT  PARM_DATA                                         08590088
MFA-TR*               INTO                                              08600088
MFA-TR*               :WS-INPUT-DATA-BREAKDOWN                          08610088
MFA-TR*      FROM    CSS_JOB_PARM                                       08620088
MFA-TR*      WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                  08630088
MFA-TR*        AND   CMND_CODE      = :G6-CMND-CODE                     08640088
MFA-TR*        AND   COMPANY_NO     = :G6-COMPANY-NO                    08650088
MFA-TR*        AND   SEQ_NO         = :G6-SEQ-NO                        08660088
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    08670088

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     IF END-OF-SYSIPT                                             
C30169         DISPLAY ' '                                              
C30169         DISPLAY '**  PCSCA032 PROCESSING ERROR             **'   
C30169         DISPLAY '**   LAST RUN DATE NOT FOUND IN CSS_JOB_PARM'   
C30169         DISPLAY '**  PROCESSING TERMINATED                 **'   
C30169         PERFORM 9900-ABEND                   THRU 9900-EXIT      
C30169     ELSE                                                         
C30169         IF   WS-L-RUN-DATE-MM  NUMERIC                           
C30169           AND WS-L-RUN-DATE-DD NUMERIC                           
C30169           AND WS-L-RUN-DATE-CC NUMERIC                           
C30169           AND WS-L-RUN-DATE-YY NUMERIC                           
C30169                                                                  
C30169             MOVE WS-L-RUN-DATE TO WS-LAST-RUN-DATE               
C30169             PERFORM 7611-CLOSE THRU 7611-EXIT                    
C30169         END-IF                                                   
C30169     END-IF.                                                      
C30169                                                                  
C30169     MOVE SPACES               TO WS-SYSIPT.                      
C30169     MOVE WS-PARM              TO WS-COMMAND.                     
C30169     MOVE PROGRAM-NAME         TO WS-PROGRAM.                     
C30169     MOVE '01'                 TO G6-COMPANY-NO.                  
C30169     MOVE +20                  TO G6-SEQ-NO.                      
C30169     PERFORM 7600-START-FCSJC01               THRU 7600-EXIT.     
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        SELECT STATUS,                                            
C30169                PARM_DATA                                         
C30169                INTO                                              
C30169                :WS-INPUT-STATUS,                                 
C30169                :WS-INPUT-DATA-BREAKDOWN                          
C30169        FROM   CSS_JOB_PARM WITH(READUNCOMMITTED)                         
C30169        WHERE  PROGRAM_NAME   = :G6-PROGRAM-NAME                  
C30169          AND  CMND_CODE      = :G6-CMND-CODE                     
C30169          AND  COMPANY_NO     = :G6-COMPANY-NO                    
C30169          AND  SEQ_NO         = :G6-SEQ-NO                        
C35227                                                           
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08840600
MFA-TR*       SELECT STATUS,                                            08840700
MFA-TR*               PARM_DATA                                         08840710
MFA-TR*               INTO                                              08840800
MFA-TR*               :WS-INPUT-STATUS,                                 08840900
MFA-TR*               :WS-INPUT-DATA-BREAKDOWN                          08840910
MFA-TR*       FROM   CSS_JOB_PARM                                       08841000
MFA-TR*       WHERE  PROGRAM_NAME   = :G6-PROGRAM-NAME                  08841100
MFA-TR*         AND  CMND_CODE      = :G6-CMND-CODE                     08841200
MFA-TR*         AND  COMPANY_NO     = :G6-COMPANY-NO                    08841300
MFA-TR*         AND  SEQ_NO         = :G6-SEQ-NO                        08841400
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    08841500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     IF END-OF-SYSIPT                                             
C30169         MOVE WS-INPUT-DATE TO WS-CURR-RUN-DATE                   
C30169     ELSE                                                         
C30169         IF INPUT-INACTIVE                                        
C30169             MOVE WS-INPUT-DATE TO WS-CURR-RUN-DATE               
C30169         ELSE                                                     
C30169             IF   WS-L-RUN-DATE-MM  NUMERIC                       
C30169               AND WS-L-RUN-DATE-DD NUMERIC                       
C30169               AND WS-L-RUN-DATE-CC NUMERIC                       
C30169               AND WS-L-RUN-DATE-YY NUMERIC                       
C30169                 MOVE WS-L-RUN-DATE TO WS-CURR-RUN-DATE           
C30169                 PERFORM 7611-CLOSE THRU 7611-EXIT                
C30169             END-IF                                               
C30169         END-IF                                                   
C30169     END-IF.                                                      
C30169                                                                  
C30169 0105-EXIT.                                                       
C30169     EXIT.                                                        
C30169                                                                  
      ******************************************************************11240088
      *  0190-WRITE-BEGIN-CONTROLS.                                    *11250088
      ******************************************************************11260088
       0190-WRITE-BEGIN-CONTROLS.                                       
      *                                                                 11280000
           INITIALIZE FIOFA08-BEGIN-REC.                                
           MOVE LOW-VALUES TO E-FFA08-KEY-BREC.                         
           MOVE WS-INPUT-DATE TO E-FFA08-CREATE-DATE-BREC.              
           PERFORM 8700-WRITE-FCSFA08 THRU 8700-EXIT.                   
           SUBTRACT 1 FROM WS-FFA08-REC-CNTR.                           
           INITIALIZE FIOFA08.                                          
      *                                                                 11350000
           INITIALIZE E-FRP032-BEGIN-REC.                               
           MOVE LOW-VALUES TO E-FRP032-KEY-BREC.                        
           MOVE WS-INPUT-DATE TO E-FRP032-CREATE-DATE-BREC.             
           PERFORM 8702-WRITE-FCSRP032 THRU 8702-EXIT.                  
           SUBTRACT 1 FROM WS-FRP032-REC-CNTR.                          
      *                                                                 11420000
       0190-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11450088
      ******************************************************************11460088
      *  0200-WRITE-END-CONTROLS.                                      *11470088
      ******************************************************************11480088
       0200-WRITE-END-CONTROLS.                                         
      *                                                                 11500088
           INITIALIZE FIOFA08.                                          
           MOVE HIGH-VALUES TO E-FFA08-KEY-EREC.                        
           MOVE WS-FFA08-REC-CNTR TO                                    
                     E-FFA08-RECORD-COUNT-EREC.                         
           PERFORM 8700-WRITE-FCSFA08 THRU 8700-EXIT.                   
      *                                                                 11560000
           INITIALIZE FIORP032.                                         
           MOVE HIGH-VALUES TO E-FRP032-KEY-EREC.                       
           MOVE WS-FRP032-REC-CNTR TO                                   
                     E-FRP032-RECORD-COUNT-EREC.                        
           PERFORM 8702-WRITE-FCSRP032 THRU 8702-EXIT.                  
      *                                                                 11620000
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11650088
C30169******************************************************************12740000
C30169*1000-PROCESS-AXFR1-AXFR2                                        *12750000
C30169******************************************************************12760000
C30169 1000-PROCESS-AXFR1-AXFR2.                                        
C30169                                                                  
C30169     MOVE WS-CA-ACCOUNT-NO   TO AT-ACCOUNT-NO.                    
C30169                                                                  
C30169     IF (KD-FW-ACTION-TYPE-CD = 'AXFR1' OR                        
C30169         KD-FW-ACTION-TYPE-CD = 'AXFR2')                          
C30169         PERFORM 7120-CHECK-GUARANTEED-IND THRU 7120-EXIT         
C30169         IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
C30169             GO TO 1055-READ-NEXT                                 
C30169         END-IF                                                   
C30169     END-IF.                                                      
C30169                                                                  
C30169     PERFORM 7130-CHECK-AR THRU 7130-EXIT.                        
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169                                                                  
C30169     PERFORM 7100-SELECT-ACCOUNT      THRU 7100-EXIT.             
C30169                                                                  
A02036     IF AT-ACCOUNT-TYPE-CODE = 'N' OR WS-ACCOUNT-NOT-FOUND = 'Y'  
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169                                                                  
C30169     PERFORM 2450-MOVE-FROM-ACCT-INFO THRU 2450-EXIT.             
C30169                                                                  
C30169     PERFORM 7260-CK-FOR-AUTO-XFER-EXEMP-FL THRU 7260-EXIT        
C30169     IF WS-AUTO-XFER-EXEMP-FL = 'Y'                               
C30169         MOVE 'Y' TO E-FRP032-XFER-XEMPT-EITHER-FL                
C30169         MOVE '99' TO E-FRP032-EXCPTION-CODE                      
C30169         MOVE 'Y' TO WS-RP032-SELECT                              
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169     IF AT-CODE-ACCT-STAT = 'B'                                   
C30169         PERFORM 2040-GET-FB-BALANCE THRU 2040-EXIT               
C30169         IF WS-TOTAL-BAL > WS-LOWER-LIMIT                         
C30169             MOVE WS-TOTAL-BAL TO WS-FR-TOTAL-AR-BALANCE          
C30169                              E-FRP032-FROM-TOTAL-AR-BAL          
C30169         ELSE                                                     
C30169             GO TO 1055-READ-NEXT                                 
C30169         END-IF                                                   
C30169     END-IF                                                       
C30169     IF (KD-FW-ACTION-TYPE-CD = 'AXFR2' OR                        
C30169        KD-FW-ACTION-TYPE-CD = 'AXFR1')AND                        
C30169        AT-CODE-ACCT-STAT = 'S'                                   
C30169         MOVE '09' TO E-FRP032-EXCPTION-CODE                      
C30169         MOVE 'Y' TO WS-RP032-SELECT                              
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169                                                                  
C30169     MOVE 'N' TO WS-ACCT-PRE-SELECTED.                            
C30169     MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO                        
C30169     PERFORM 7200-SELECT-CUSTOMER THRU 7200-EXIT                  
C30169     IF CU-AUTO-XFER-TO-ACCT > ZEROES                             
C30169         MOVE CU-AUTO-XFER-TO-ACCT TO AT-ACCOUNT-NO               
C30169         PERFORM 7100-SELECT-ACCOUNT      THRU 7100-EXIT          
A02036         IF WS-ACCOUNT-NOT-FOUND = 'Y'                            
A02036             GO TO 1055-READ-NEXT                                 
A02036         END-IF                                                   
C30169         IF AT-CODE-ACCT-STAT NOT = 'A'                           
C30169             MOVE '10' TO E-FRP032-EXCPTION-CODE                  
C30169             MOVE 'Y' TO WS-RP032-SELECT                          
C30169             GO TO 1055-READ-NEXT                                 
C30169         END-IF                                                   
T26196         IF AT-COMPANY-NO NOT = WS-FR-COMPANY-NO                  
T26196             MOVE AT-CUSTOMER-NO TO E-FRP032-TO-CUSTOMER-NO       
T26196             MOVE AT-ACCOUNT-NO  TO E-FRP032-TO-ACCOUNT-NO        
T26196             MOVE '04' TO E-FRP032-EXCPTION-CODE                  
T26196             MOVE 'Y' TO WS-RP032-SELECT                          
T26196             GO TO 1055-READ-NEXT                                 
T26196         END-IF                                                   
C30169         MOVE 'Y' TO WS-ACCT-PRE-SELECTED                         
********  NEED TO CHECK ONLY THIS ONE ACCOUNT **********************    13130088
C30169         PERFORM 1280-CK-PRE-SELECTED     THRU 1280-EXIT          
C30169         IF WS-FRP032-FLAGS-SET = 'N'                             
C30169              PERFORM 1500-LOAD-FFA08    THRU 1500-EXIT           
C30169              MOVE 'Y' TO WS-FA08-SELECT                          
C30169         ELSE                                                     
C30169              MOVE 'Y' TO WS-RP032-SELECT                         
C30169         END-IF                                                   
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169                                                                  
C30169     PERFORM 1100-SEARCH-FOR-ACCOUNTS  THRU 1100-EXIT.            
C30169                                                                  
C30169 1000-EXIT.                                                       
C30169     EXIT.                                                        
********  NEED TO CHECK ONLY THIS ONE ACCOUNT **********************    14230089
C30169******************************************************************13950000
C30169*1050-PROCESS-AXFR3-AXFR4                                        *13960000
C30169******************************************************************13970000
C30169 1050-PROCESS-AXFR3-AXFR4.                                        
C30169                                                                  
C30169     MOVE WS-CA-ACCOUNT-NO TO AT-ACCOUNT-NO.                      
C30169                                                                  
C30169     PERFORM 7135-CHECK-CHRG-OFF THRU 7135-EXIT.                  
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169                                                                  
C30169     PERFORM 7100-SELECT-ACCOUNT THRU 7100-EXIT.                  
C30169                                                                  
C30169     IF AT-ACCOUNT-TYPE-CODE = 'N' OR WS-ACCOUNT-NOT-FOUND = 'Y'  
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169     IF AT-CODE-ACCT-STAT = 'S'                                   
C30169         PERFORM 2050-GET-WO-BALANCE THRU 2050-EXIT               
C30169         IF WS-WRITE-OFF-BAL > 1                                  
C30169             MOVE WS-WRITE-OFF-BAL TO WS-FR-TOTAL-AR-BALANCE      
C30169                                  E-FRP032-FROM-TOTAL-AR-BAL      
C30169         ELSE                                                     
C30169             GO TO 1055-READ-NEXT                                 
C30169         END-IF                                                   
C30169     END-IF                                                       
C30169     PERFORM 2450-MOVE-FROM-ACCT-INFO    THRU 2450-EXIT.          
C30169                                                                  
C30169     PERFORM 7260-CK-FOR-AUTO-XFER-EXEMP-FL THRU 7260-EXIT        
C30169     IF WS-AUTO-XFER-EXEMP-FL = 'Y'                               
C30169         MOVE 'Y' TO E-FRP032-XFER-XEMPT-EITHER-FL                
C30169         MOVE '99' TO E-FRP032-EXCPTION-CODE                      
C30169         MOVE 'Y' TO WS-RP032-SELECT                              
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169                                                                  
C30169     MOVE 'N' TO WS-ACCT-PRE-SELECTED.                            
C30169     MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO                        
C30169     PERFORM 7200-SELECT-CUSTOMER THRU 7200-EXIT                  
C30169     IF CU-AUTO-XFER-TO-ACCT > ZEROES                             
C30169         MOVE CU-AUTO-XFER-TO-ACCT TO AT-ACCOUNT-NO               
C30169         PERFORM 7100-SELECT-ACCOUNT      THRU 7100-EXIT          
A02036         IF WS-ACCOUNT-NOT-FOUND = 'Y'                            
A02036             GO TO 1055-READ-NEXT                                 
A02036         END-IF                                                   
C30169         IF AT-CODE-ACCT-STAT NOT = 'A'                           
C30169             MOVE '10' TO E-FRP032-EXCPTION-CODE                  
C30169             MOVE 'Y' TO WS-RP032-SELECT                          
C30169             GO TO 1055-READ-NEXT                                 
C30169         END-IF                                                   
T26196         IF AT-COMPANY-NO NOT = WS-FR-COMPANY-NO                  
T26196             MOVE AT-CUSTOMER-NO TO E-FRP032-TO-CUSTOMER-NO       
T26196             MOVE AT-ACCOUNT-NO  TO E-FRP032-TO-ACCOUNT-NO        
T26196             MOVE '04' TO E-FRP032-EXCPTION-CODE                  
T26196             MOVE 'Y' TO WS-RP032-SELECT                          
T26196             GO TO 1055-READ-NEXT                                 
T26196         END-IF                                                   
C30169         MOVE 'Y' TO WS-ACCT-PRE-SELECTED                         
********  NEED TO CHECK ONLY THIS ONE ACCOUNT **********************    14230089
C30169         PERFORM 1280-CK-PRE-SELECTED     THRU 1280-EXIT          
C30169         IF WS-FRP032-FLAGS-SET = 'N'                             
C30169              PERFORM 1500-LOAD-FFA08    THRU 1500-EXIT           
C30169              MOVE 'Y' TO WS-FA08-SELECT                          
C30169         ELSE                                                     
C30169              MOVE 'Y' TO WS-RP032-SELECT                         
C30169         END-IF                                                   
C30169         GO TO 1055-READ-NEXT                                     
C30169     END-IF.                                                      
C30169                                                                  
C30169     PERFORM 1100-SEARCH-FOR-ACCOUNTS  THRU 1100-EXIT.            
C30169                                                                  
C30169 1050-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 14780000
C30169******************************************************************13950000
C30169*1055-PROCESS-COLL-AGY-CRED-BUR.                                 *13960000
C30169******************************************************************13970000
C30169 1055-PROCESS-COLL-AGY-CRED-BUR.                                  
C30169                                                                  
C30169     EVALUATE KD-FW-ACTION-TYPE-CD                                
C30169         WHEN WS-AXFR1                                            
C30169              MOVE 'FA08' TO WS-OUTPUT-ID                         
C30169         WHEN WS-AXFR2                                            
C30169              MOVE 'FA09' TO WS-OUTPUT-ID                         
C30169         WHEN WS-AXFR3                                            
C30169              MOVE 'FA10' TO WS-OUTPUT-ID                         
C30169         WHEN WS-AXFR4                                            
C30169              MOVE 'FA11' TO WS-OUTPUT-ID                         
C30169         WHEN OTHER                                               
C30169              DISPLAY '******************************************'
C30169              DISPLAY '** INVALID FORMAT ID                    **'
C30169              DISPLAY '** FORMAT-ID = ' KD-FW-ACTION-TYPE-CD      
C30169              DISPLAY '** PROCESSING TERMINATED                **'
C30169              DISPLAY '** INVALID FORMAT ID *********************'
C30169              DISPLAY '******************************************'
C30169              PERFORM 9900-ABEND            THRU 9900-EXIT        
C30169     END-EVALUATE.                                                
C30169                                                                  
C30169     IF (KD-FW-ACTION-TYPE-CD =  WS-AXFR1  OR                     
C30169         KD-FW-ACTION-TYPE-CD =  WS-AXFR2)                        
C30169        PERFORM 1000-PROCESS-AXFR1-AXFR2  THRU 1000-EXIT          
C30169     END-IF.                                                      
C30169                                                                  
C30169     IF (KD-FW-ACTION-TYPE-CD =  WS-AXFR3 OR                      
C30169         KD-FW-ACTION-TYPE-CD =  WS-AXFR4)                        
C30169        PERFORM 1050-PROCESS-AXFR3-AXFR4  THRU 1050-EXIT          
C30169     END-IF.                                                      
C30169                                                                  
C30169                                                                  
C30169 1055-READ-NEXT.                                                  
C30169     PERFORM 1067-CHECK-FILES-TO-WRITE   THRU 1067-EXIT.          
C30169     PERFORM 7080-GET-COLL-AGY-CRED-BUR  THRU 7080-EXIT.          
C30169*                                                                 14750017
C30169 1055-EXIT.                                                       
C30169     EXIT.                                                        
      *                                                                 15610070
      ******************************************************************15610080
      *   1067-CHECK-FILES-TO-WRITE.                                   *15610090
      ******************************************************************15610100
       1067-CHECK-FILES-TO-WRITE.                                       
      *                                                                 15613500
           IF FA08-SELECTED AND WS-FRP032-MULTI-ACCT2 = 'Y'             
               MOVE 'Y' TO E-FRP032-MULTI-ACCT2-FLAG                    
               MOVE '99' TO E-FRP032-EXCPTION-CODE                      
               PERFORM 8702-WRITE-FCSRP032 THRU 8702-EXIT               
               SUBTRACT 2 FROM WS-FFA08-SEQ-NO                          
               GO TO 1067-INIT                                          
           END-IF.                                                      
      *                                                                 15614300
           IF FA08-SELECTED                                             
               PERFORM 8700-WRITE-FCSFA08 THRU 8700-EXIT                
           ELSE                                                         
               IF RP032-SELECTED                                        
                   PERFORM 8702-WRITE-FCSRP032 THRU 8702-EXIT           
               END-IF                                                   
           END-IF.                                                      
      *                                                                 15614370
       1067-INIT.                                                       
           INITIALIZE WS-FROM-ACCOUNT-INFO.                             
           INITIALIZE E-FRP032-DATA-REC.                                
           INITIALIZE FIOFA08.                                          
           MOVE SPACES TO DQ-FROM-NAME-TYPE                             
                          DQ-FROM-NAME                                  
                          CE-FROM-SSN                                   
                          CE-FROM-CUSTOMER-TYPE.                        
           MOVE 'N' TO WS-FATAL-ERROR                                   
                       WS-BYPASS                                        
                       WS-FINISH                                        
                       WS-FA08-SELECT                                   
                       WS-RP032-SELECT                                  
                       WS-FRP032-MULTI-ACCT2                            
                       WS-FRP032-FLAGS-SET.                             
      *                                                                 15616900
       1067-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15620088
      ******************************************************************15620089
      *   PERFORM 1100-SEARCH-FOR-ACCOUNTS                             *15620090
      ******************************************************************15620091
       1100-SEARCH-FOR-ACCOUNTS.                                        
      *                                                                 15620093
           PERFORM 7180-SELECT-CUST-STATS    THRU 7180-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               IF CE-SSN = SPACES                                       
                   MOVE 'NO FR SSN'  TO CE-FROM-SSN                     
               ELSE                                                     
                   MOVE CE-SSN       TO CE-FROM-SSN                     
                                        E-FRP032-TO-SSN                 
               END-IF                                                   
               MOVE CE-NAME-ID       TO CE-FROM-NAME-ID                 
                                        DQ-NAME-ID                      
               MOVE CE-CUSTOMER-TYPE TO CE-FROM-CUSTOMER-TYPE           
                                        E-FRP032-TO-CUST-TYPE           
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               MOVE 'NO FR SSN'    TO CE-FROM-SSN                       
               MOVE ZEROES         TO CE-FROM-NAME-ID                   
               MOVE SPACES         TO CE-FROM-CUSTOMER-TYPE             
               MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO                    
               PERFORM 7105-SELECT-CUSTOMER THRU 7105-EXIT              
               MOVE CU-NAME-ID     TO DQ-NAME-ID                        
           END-IF.                                                      
           PERFORM 7190-SELECT-CUST-NAME     THRU 7190-EXIT.            
           MOVE DQ-FULL-NAME TO DQ-FROM-NAME                            
                                E-FRP032-TO-NAME.                       
           MOVE DQ-NAME-TYPE TO DQ-FROM-NAME-TYPE                       
                                E-FRP032-TO-NAME-TYPE.                  
           MOVE WS-FR-CUSTOMER-NO TO WS-TEMP-CUSTOMER-NO                
                                     E-FRP032-TO-CUSTOMER-NO.           
*********************************************************************** 15620130
********** SEARCHES FOR ACCOUNTS WITH SAME CUST # AS THE ORIGINAL ***** 15620131
           PERFORM 7000-OPEN-GET-OTHER-ACCTS  THRU 7000-OPEN-EXIT.      
           PERFORM UNTIL WS-RETURN-CODE7000 = NOT-FOUND OR              
                         WS-FRP032-MULTI-ACCT2 = 'Y' OR                 
                         YES-FATAL-ERROR                                
                     PERFORM 1150-PROCESS-ACCOUNTS THRU 1150-EXIT       
           END-PERFORM.                                                 
           PERFORM 7020-CLOSE-GET-OTHER-ACCTS THRU 7020-CLOSE-EXIT.     
********** END OF SEARCH FOR ACCOUNTS WITH SAME CUST # **************** 15620139
*********************************************************************** 15620140
********** SEARCHES FOR OTHER CUST #S WHERE THE DQ-FULL-NAME EQUALS *** 15620141
           PERFORM 7030-OPEN-GET-OTHER-CUSTS THRU 7030-OPEN-EXIT.       
           PERFORM 7040-GET-OTHER-CUSTS      THRU 7040-EXIT.            
           PERFORM UNTIL WS-RETURN-CODE7002 = NOT-FOUND OR              
                         WS-FRP032-MULTI-ACCT2 = 'Y' OR                 
                         YES-FATAL-ERROR                                
               MOVE CE-CUSTOMER-NO TO WS-TEMP-CUSTOMER-NO               
------*--- SEARCHES FOR ACCOUNTS WHERE NAME MATCHES -------------       15620148
               PERFORM 7000-OPEN-GET-OTHER-ACCTS  THRU 7000-OPEN-EXIT   
               PERFORM 1150-PROCESS-ACCOUNTS      THRU 1150-EXIT        
               PERFORM UNTIL WS-RETURN-CODE7000 = NOT-FOUND OR          
                             WS-FRP032-MULTI-ACCT2 = 'Y' OR             
                             YES-FINISH OR YES-FATAL-ERROR              
                   PERFORM 1150-PROCESS-ACCOUNTS      THRU 1150-EXIT    
               END-PERFORM                                              
               PERFORM 7020-CLOSE-GET-OTHER-ACCTS THRU 7020-CLOSE-EXIT  
------*--- END OF SEARCH FOR ACCOUNTS WHERE NAME MATCHES --------       15620157
               PERFORM 7040-GET-OTHER-CUSTS      THRU 7040-EXIT         
           END-PERFORM.                                                 
           PERFORM 7050-CLOSE-GET-OTHER-CUSTS THRU 7050-CLOSE-EXIT.     
********** END OF SEARCH FOR OTHER CUST #S **************************** 15620161
*********************************************************************** 15620162
      *                                                                 15620167
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15620170
      ******************************************************************15620171
      *   1150-PROCESS-ACCOUNTS.                                       *15620172
      ******************************************************************15620180
       1150-PROCESS-ACCOUNTS.                                           
           PERFORM 7010-GET-OTHER-ACCTS   THRU 7010-EXIT.               
           IF WS-RETURN-CODE7000 = NOT-FOUND                            
               GO TO 1150-EXIT                                          
           END-IF.                                                      
           PERFORM 1400-LOAD-FRP032       THRU 1400-EXIT.               
           PERFORM 1200-CK-FOR-EXCEPTION  THRU 1200-EXIT.               
           IF WS-FRP032-FLAGS-SET = 'N' AND                             
              WS-FRP032-MULTI-ACCT2 = 'N'                               
               PERFORM 1300-CHECK-MATCHES THRU 1300-EXIT                
           END-IF.                                                      
           IF WS-FRP032-FLAGS-SET = 'N' AND                             
              WS-FRP032-MULTI-ACCT2 = 'N'                               
               IF (E-FRP032-FROM-SSN = 'NO FR SSN' AND                  
                   E-FRP032-TO-SSN = SPACES) AND                        
                   E-FRP032-FROM-CUSTOMER-NO NOT =                      
                      E-FRP032-TO-CUSTOMER-NO AND                       
                  (E-FRP032-FROM-ACCT-TYPE NOT = 'C' AND                
                   E-FRP032-TO-ACCT-TYPE NOT = 'C')                     
                   NEXT SENTENCE                                        
               ELSE                                                     
                   IF FA08-SELECTED                                     
                       MOVE 'Y' TO WS-FRP032-MULTI-ACCT2                
                       PERFORM 1400-LOAD-FRP032 THRU 1400-EXIT          
                   END-IF                                               
                   IF WS-BYPASS = 'N'                                   
                       PERFORM 1500-LOAD-FFA08    THRU 1500-EXIT        
                       MOVE 'Y' TO WS-FA08-SELECT                       
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 15621700
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15622000
      ******************************************************************15630000
      *   PERFORM 1200-CK-FOR-EXCEPTION                                *15640000
      ******************************************************************15650000
       1200-CK-FOR-EXCEPTION.                                           
      *                                                                 15670088
           IF E-FRP032-TO-NAME-TYPE NOT = 'CN'                          
               MOVE '07' TO E-FRP032-EXCPTION-CODE                      
               MOVE 'Y'  TO WS-RP032-SELECT                             
               MOVE 'Y'  TO WS-FRP032-FLAGS-SET                         
               MOVE 'Y'  TO WS-FINISH                                   
               GO TO 1200-EXIT                                          
           END-IF.                                                      
      *                                                                 15670500
           PERFORM 7170-SELECT-CREDIT-PROFILE THRU 7170-EXIT.           
           MOVE CZ-ARREARS-HIST TO WS-CREDIT-HIST-NO.                   
           IF WS-CREDIT-HIST-NO1 > '3'                                  
               MOVE '05' TO E-FRP032-EXCPTION-CODE                      
               MOVE 'Y'  TO WS-RP032-SELECT                             
               GO TO 1200-EXIT                                          
           ELSE                                                         
               MOVE 'N' TO WS-RECONNECT-ROW-EXISTS                      
               PERFORM 7280-CK-FOR-RECONNECT-ROW THRU 7280-EXIT         
               IF AT-CODE-STATUS-REASON = 'C'                           
                                      AND AT-CODE-ACCT-STAT = 'S'       
                                      AND WS-RECONNECT-ROW-EXISTS = 'N' 
                   MOVE '06' TO E-FRP032-EXCPTION-CODE                  
                   MOVE 'Y'  TO WS-RP032-SELECT                         
                   GO TO 1200-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                 15870088
           PERFORM 1230-CK-FOR-FLAGS THRU 1230-EXIT.                    
      *                                                                 16060088
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16090088
      ******************************************************************17050089
      *   PERFORM 1230-CK-FOR-FLAGS                                    *17050090
      ******************************************************************17050091
       1230-CK-FOR-FLAGS.                                               
           MOVE 'N' TO WS-FRP032-FLAGS-SET.                             
      *                                                                 17050094
           IF WS-FR-BANKRUPTCY-IND = 'B' OR AT-BANKRUPTCY-IND = 'B'     
               MOVE 'Y' TO E-FRP032-BANKRUPT-EITHER-FLAG                
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-BANKRUPT-EITHER-FLAG                
           END-IF.                                                      
      *                                                                 17050101
           IF WS-FR-JUDGMENT-CASE-NO > SPACES OR                        
              AT-JUDGEMENT-CASE-NO > SPACES                             
               MOVE 'Y' TO E-FRP032-JUDGMENT-EITHER-FLAG                
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-JUDGMENT-EITHER-FLAG                
           END-IF.                                                      
      *                                                                 17050109
           IF WS-FR-CODE-MAJOR-ACCT = 'Y' OR AT-CODE-MAJOR-ACCT = 'Y'   
               MOVE 'Y' TO E-FRP032-MAJ-ACCT-EITHER-FLAG                
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-MAJ-ACCT-EITHER-FLAG                
           END-IF.                                                      
      *                                                                 17050116
           IF AT-CODE-STATUS-REASON = 'C' AND AT-CODE-ACCT-STAT = 'S'   
               MOVE 'Y' TO E-FRP032-PEND-DNPFB-ACCT2-FLAG               
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-PEND-DNPFB-ACCT2-FLAG               
           END-IF.                                                      
      *                                                                 17050123
           IF WS-FR-MST-SUB-ACCT-IND = 'M' OR AT-MST-SUB-ACCT-IND = 'M' 
           OR WS-FR-MST-SUB-ACCT-IND = 'S' OR AT-MST-SUB-ACCT-IND = 'S' 
               MOVE 'Y' TO E-FRP032-MSTR-ACCT-EITHER-FLAG               
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-MSTR-ACCT-EITHER-FLAG               
           END-IF.                                                      
      *                                                                         
           MOVE WS-N TO WS-ACT-SURETY-EITHER-FLAG.                      
           MOVE WS-FR-ACCOUNT-NO TO SB-ACCOUNT-NO.                      
           PERFORM 7447-SELECT-ACTIVE-SURETY-BOND THRU 7447-EXIT.       
           IF WS-ACT-SURETY-EITHER-FLAG = 'N'                           
               MOVE AT-ACCOUNT-NO TO SB-ACCOUNT-NO                      
               PERFORM 7447-SELECT-ACTIVE-SURETY-BOND THRU 7447-EXIT    
           END-IF.                                                      
           MOVE WS-ACT-SURETY-EITHER-FLAG TO                            
                                    E-FRP032-ACT-SURETY-EITHER-FL.      
           IF WS-ACT-SURETY-EITHER-FLAG = 'Y'                           
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           END-IF.                                                      
      *                                                                 17050157
           MOVE WS-N TO WS-ACT-IRLOC-EITHER-FLAG.                       
           MOVE WS-FR-ACCOUNT-NO TO SB-ACCOUNT-NO.                      
           PERFORM 7448-SELECT-ACTIVE-IRLOC THRU 7448-EXIT.             
           IF WS-ACT-IRLOC-EITHER-FLAG = 'N'                            
               MOVE AT-ACCOUNT-NO TO SB-ACCOUNT-NO                      
               PERFORM 7448-SELECT-ACTIVE-IRLOC THRU 7448-EXIT          
           END-IF.                                                      
           MOVE WS-ACT-IRLOC-EITHER-FLAG TO                             
                                    E-FRP032-ACT-IRLOC-EITHER-FL.       
           IF WS-ACT-IRLOC-EITHER-FLAG = 'Y'                            
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           END-IF.                                                      
      *                                                                 17050170
           MOVE WS-N TO WS-WO-ARRANG-ACCT1-FLAG.                        
           PERFORM 7250-CK-FOR-WO-ARRANG THRU 7250-EXIT.                
           MOVE WS-WO-ARRANG-ACCT1-FLAG TO                              
                                       E-FRP032-WO-ARRANG-ACCT1-FLAG.   
           IF WS-WO-ARRANG-ACCT1-FLAG = 'Y'                             
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           END-IF.                                                      
      *                                                                 17050178
           IF WS-FRP032-FLAGS-SET = 'Y'                                 
              MOVE '99' TO E-FRP032-EXCPTION-CODE                       
           END-IF.                                                      
      *                                                                 17050182
       1230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17340088
      ******************************************************************17340089
      *   PERFORM 1280-CK-PRE-SELECTED                                 *17340090
      ******************************************************************17340100
       1280-CK-PRE-SELECTED.                                            
      *                                                                 17340300
           PERFORM 7170-SELECT-CREDIT-PROFILE THRU 7170-EXIT.           
           MOVE CZ-ARREARS-HIST TO WS-CREDIT-HIST-NO.                   
           IF WS-CREDIT-HIST-NO1 > '3'                                  
               MOVE '05' TO E-FRP032-EXCPTION-CODE                      
               PERFORM 1400-LOAD-FRP032    THRU 1400-EXIT               
               MOVE 'Y'  TO WS-RP032-SELECT                             
               GO TO 1280-EXIT                                          
           ELSE                                                         
               MOVE 'N' TO WS-RECONNECT-ROW-EXISTS                      
               PERFORM 7280-CK-FOR-RECONNECT-ROW THRU 7280-EXIT         
               IF AT-CODE-STATUS-REASON = 'C'                           
                                      AND AT-CODE-ACCT-STAT = 'S'       
                                      AND WS-RECONNECT-ROW-EXISTS = 'N' 
                   MOVE '06' TO E-FRP032-EXCPTION-CODE                  
                   PERFORM 1400-LOAD-FRP032    THRU 1400-EXIT           
                   MOVE 'Y'  TO WS-RP032-SELECT                         
                   GO TO 1280-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
      *                                                                 17342300
           MOVE 'N'  TO E-FRP032-MULTI-ACCT2-FLAG.                      
           MOVE 'N' TO WS-FRP032-FLAGS-SET.                             
                                                                        
           IF WS-FR-BANKRUPTCY-IND = 'B' OR AT-BANKRUPTCY-IND = 'B'     
               MOVE 'Y' TO E-FRP032-BANKRUPT-EITHER-FLAG                
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-BANKRUPT-EITHER-FLAG                
           END-IF.                                                      
      *                                                                 17350100
           IF WS-FR-JUDGMENT-CASE-NO > SPACES OR                        
              AT-JUDGEMENT-CASE-NO > SPACES                             
               MOVE 'Y' TO E-FRP032-JUDGMENT-EITHER-FLAG                
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-JUDGMENT-EITHER-FLAG                
           END-IF.                                                      
      *                                                                 17350180
           IF WS-FR-CODE-MAJOR-ACCT = 'Y' OR AT-CODE-MAJOR-ACCT = 'Y'   
               MOVE 'Y' TO E-FRP032-MAJ-ACCT-EITHER-FLAG                
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-MAJ-ACCT-EITHER-FLAG                
           END-IF.                                                      
      *                                                                 17350196
           IF AT-CODE-STATUS-REASON = 'C' AND AT-CODE-ACCT-STAT = 'S'   
               MOVE 'Y' TO E-FRP032-PEND-DNPFB-ACCT2-FLAG               
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           ELSE                                                         
               MOVE 'N' TO E-FRP032-PEND-DNPFB-ACCT2-FLAG               
           END-IF.                                                      
      *                                                                         
           MOVE WS-N TO WS-ACT-SURETY-EITHER-FLAG.                      
           MOVE WS-FR-ACCOUNT-NO TO SB-ACCOUNT-NO.                      
           PERFORM 7447-SELECT-ACTIVE-SURETY-BOND THRU 7447-EXIT.       
           IF WS-ACT-SURETY-EITHER-FLAG = 'N'                           
               MOVE AT-ACCOUNT-NO TO SB-ACCOUNT-NO                      
               PERFORM 7447-SELECT-ACTIVE-SURETY-BOND THRU 7447-EXIT    
           END-IF.                                                      
           MOVE WS-ACT-SURETY-EITHER-FLAG TO                            
                                    E-FRP032-ACT-SURETY-EITHER-FL.      
           IF WS-ACT-SURETY-EITHER-FLAG = 'Y'                           
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           END-IF.                                                      
      *                                                                 17350398
           MOVE WS-N TO WS-ACT-IRLOC-EITHER-FLAG.                       
           MOVE WS-FR-ACCOUNT-NO TO SB-ACCOUNT-NO.                      
           PERFORM 7448-SELECT-ACTIVE-IRLOC THRU 7448-EXIT.             
           IF WS-ACT-IRLOC-EITHER-FLAG = 'N'                            
               MOVE AT-ACCOUNT-NO TO SB-ACCOUNT-NO                      
               PERFORM 7448-SELECT-ACTIVE-IRLOC THRU 7448-EXIT          
           END-IF.                                                      
           MOVE WS-ACT-IRLOC-EITHER-FLAG TO                             
                                    E-FRP032-ACT-IRLOC-EITHER-FL.       
           IF WS-ACT-IRLOC-EITHER-FLAG = 'Y'                            
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           END-IF.                                                      
      *                                                                 17350492
           MOVE WS-N TO WS-WO-ARRANG-ACCT1-FLAG.                        
           PERFORM 7250-CK-FOR-WO-ARRANG THRU 7250-EXIT.                
           MOVE WS-WO-ARRANG-ACCT1-FLAG TO                              
                                       E-FRP032-WO-ARRANG-ACCT1-FLAG.   
           IF WS-WO-ARRANG-ACCT1-FLAG = 'Y'                             
               MOVE 'Y' TO WS-FRP032-FLAGS-SET                          
           END-IF.                                                      
      *                                                                 17350500
           IF WS-FRP032-FLAGS-SET = 'Y'                                 
              PERFORM 1400-LOAD-FRP032 THRU 1400-EXIT                   
              MOVE '99' TO E-FRP032-EXCPTION-CODE                       
           END-IF.                                                      
      *                                                                 17350880
       1280-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17350892
      ******************************************************************17350900
      *   1300-CHECK-MATCHES.                                          *17360000
      ******************************************************************17370000
       1300-CHECK-MATCHES.                                              
      *                                                                 17380100
      ******* THE FOLLOWING CODE IS USED TO CHECK FOR AUTO TRANSFER ****17380110
           IF E-FRP032-FROM-CUSTOMER-NO = E-FRP032-TO-CUSTOMER-NO AND   
              E-FRP032-FROM-ACCT-TYPE = E-FRP032-TO-ACCT-TYPE           
               GO TO 1300-EXIT                                          
           END-IF.                                                      
      ******* END OF CHECK FOR AUTO TRANSFER ***************************17380200
      *                                                                 17380300
           IF E-FRP032-FROM-NAME = E-FRP032-TO-NAME AND                 
             E-FRP032-FROM-CUSTOMER-NO NOT = E-FRP032-TO-CUSTOMER-NO AND
             (E-FRP032-FROM-ACCT-TYPE = 'C' AND                         
              E-FRP032-TO-ACCT-TYPE = 'C')                              
               IF WS-FRP032-FLAGS-SET = 'N'                             
                   MOVE 'Y' TO WS-FRP032-FLAGS-SET                      
                   MOVE '08' TO E-FRP032-EXCPTION-CODE                  
                   MOVE 'Y' TO WS-RP032-SELECT                          
               END-IF                                                   
               GO TO 1300-EXIT                                          
           END-IF.                                                      
           IF E-FRP032-FROM-NAME = E-FRP032-TO-NAME AND                 
             (E-FRP032-FROM-SSN = 'NO FR SSN' OR                        
              E-FRP032-TO-SSN = SPACES) AND                             
              E-FRP032-FROM-SSN NOT = E-FRP032-TO-SSN AND               
             (E-FRP032-FROM-ACCT-TYPE NOT = 'C' AND                     
              E-FRP032-TO-ACCT-TYPE NOT = 'C')                          
               IF E-FRP032-FROM-SSN = 'NO FR SSN' AND                   
                  E-FRP032-TO-SSN = SPACES                              
                   NEXT SENTENCE                                        
               ELSE                                                     
                   IF WS-FRP032-FLAGS-SET = 'N'                         
                       MOVE 'Y' TO WS-FRP032-FLAGS-SET                  
                       MOVE '01' TO E-FRP032-EXCPTION-CODE              
                       MOVE 'Y' TO WS-RP032-SELECT                      
                       MOVE 'Y' TO WS-FATAL-ERROR                       
                   END-IF                                               
                   GO TO 1300-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
           IF E-FRP032-FROM-NAME NOT = E-FRP032-TO-NAME AND             
              E-FRP032-FROM-SSN = E-FRP032-TO-SSN                       
               IF WS-FRP032-FLAGS-SET = 'N'                             
                   MOVE 'Y' TO WS-FRP032-FLAGS-SET                      
                   MOVE '02' TO E-FRP032-EXCPTION-CODE                  
                   MOVE 'Y' TO WS-RP032-SELECT                          
               END-IF                                                   
               GO TO 1300-EXIT                                          
           END-IF.                                                      
           IF E-FRP032-FROM-ACCT-TYPE NOT = E-FRP032-TO-ACCT-TYPE AND   
              E-FRP032-COMPANY-NO = '26'                                
               IF WS-FRP032-FLAGS-SET = 'N'                             
                   MOVE 'Y' TO WS-FRP032-FLAGS-SET                      
                   MOVE '03' TO E-FRP032-EXCPTION-CODE                  
                   MOVE 'Y' TO WS-RP032-SELECT                          
               END-IF                                                   
               GO TO 1300-EXIT                                          
           END-IF.                                                      
           IF E-FRP032-COMPANY-NO NOT = WS-TO-COMPANY-NO                
               IF WS-FRP032-FLAGS-SET = 'N'                             
                   MOVE 'Y' TO WS-FRP032-FLAGS-SET                      
                   MOVE '04' TO E-FRP032-EXCPTION-CODE                  
                   MOVE 'Y' TO WS-RP032-SELECT                          
               END-IF                                                   
           END-IF.                                                      
      *                                                                 17690040
           IF E-FRP032-TO-ACCT-TYPE = 'R' AND                           
              E-FRP032-FROM-ACCT-TYPE  = 'C' AND                        
              E-FRP032-FROM-SSN NOT = E-FRP032-TO-SSN AND               
              E-FRP032-FROM-CUSTOMER-NO NOT = E-FRP032-TO-CUSTOMER-NO   
              AND E-FRP032-COMPANY-NO = '01'                            
               IF E-FRP032-FROM-SSN = 'NO FR SSN' OR                    
                  E-FRP032-TO-SSN = SPACES                              
                   IF WS-FRP032-FLAGS-SET = 'N'                         
                       MOVE 'Y' TO WS-FRP032-FLAGS-SET                  
                       MOVE '12' TO E-FRP032-EXCPTION-CODE              
                       MOVE 'Y' TO WS-RP032-SELECT                      
                       MOVE 'Y' TO WS-FATAL-ERROR                       
                   END-IF                                               
               ELSE                                                     
                   IF WS-FRP032-FLAGS-SET = 'N'                         
                       MOVE 'Y' TO WS-BYPASS                            
                   END-IF                                               
               END-IF                                                   
               GO TO 1300-EXIT                                          
           END-IF.                                                      
      *                                                                 17690910
           IF E-FRP032-TO-ACCT-TYPE = 'C' AND                           
              E-FRP032-FROM-ACCT-TYPE  = 'R' AND                        
              E-FRP032-FROM-SSN NOT = E-FRP032-TO-SSN AND               
              E-FRP032-FROM-CUSTOMER-NO NOT = E-FRP032-TO-CUSTOMER-NO   
              AND E-FRP032-COMPANY-NO = '01'                            
               IF E-FRP032-FROM-SSN = 'NO FR SSN' OR                    
                  E-FRP032-TO-SSN = SPACES                              
                   IF WS-FRP032-FLAGS-SET = 'N'                         
                       MOVE 'Y' TO WS-FRP032-FLAGS-SET                  
                       MOVE '13' TO E-FRP032-EXCPTION-CODE              
                       MOVE 'Y' TO WS-RP032-SELECT                      
                       MOVE 'Y' TO WS-FATAL-ERROR                       
                   END-IF                                               
               ELSE                                                     
                   IF WS-FRP032-FLAGS-SET = 'N'                         
                       MOVE 'Y' TO WS-BYPASS                            
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 17691100
       1300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17720088
      ******************************************************************17720089
      *   1305-ASSIGN-MATCH-CODE.                                      *17720090
      ******************************************************************17720100
       1305-ASSIGN-MATCH-CODE.                                          
           IF E-FRP032-FROM-CUSTOMER-NO = E-FRP032-TO-CUSTOMER-NO       
               MOVE 'Y' TO E-FRP032-MATCH-CODE                          
               GO TO 1305-EXIT                                          
           END-IF.                                                      
           IF E-FRP032-FROM-NAME = SPACES OR                            
              E-FRP032-TO-NAME   = SPACES OR                            
              E-FRP032-FROM-SSN  = SPACES OR                            
              E-FRP032-FROM-SSN  = 'NO FR SSN' OR                       
              E-FRP032-TO-SSN    = SPACES                               
               IF E-FRP032-FROM-ACCT-TYPE = 'R' AND                     
                  E-FRP032-TO-ACCT-TYPE = 'R'                           
                   MOVE 'N' TO E-FRP032-MATCH-CODE                      
                   GO TO 1305-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
           IF E-FRP032-FROM-NAME = E-FRP032-TO-NAME AND                 
              E-FRP032-FROM-CUSTOMER-NO = E-FRP032-TO-CUSTOMER-NO AND   
             (E-FRP032-FROM-ACCT-TYPE = 'C' AND                         
              E-FRP032-TO-ACCT-TYPE = 'C')                              
               MOVE 'Y' TO E-FRP032-MATCH-CODE                          
               GO TO 1305-EXIT                                          
           END-IF.                                                      
           IF E-FRP032-FROM-NAME = E-FRP032-TO-NAME AND                 
              E-FRP032-FROM-SSN = E-FRP032-TO-SSN                       
               MOVE 'Y' TO E-FRP032-MATCH-CODE                          
               GO TO 1305-EXIT                                          
           END-IF.                                                      
           IF E-FRP032-TO-NAME-TYPE NOT = 'CN'                          
               MOVE 'N' TO E-FRP032-MATCH-CODE                          
               GO TO 1305-EXIT                                          
           END-IF.                                                      
           MOVE 'N' TO E-FRP032-MATCH-CODE.                             
      *                                                                 17725800
       1305-EXIT.                                                       
           EXIT.                                                        
      *                                                                 17726100
      ******************************************************************17730000
      *      1400-LOAD-FRP032                                          *17740000
      * THIS PROCEDURE LOADS EXCEPTION REPORTING DATA TO FRP032 AND    *17750000
      * THEN WRITES THE RECORD TO THE EXCEPTION FILE.                  *17760000
      ******************************************************************17770000
       1400-LOAD-FRP032.                                                
      *                                                                 17790088
           IF E-FRP032-CONTRACT-LIEN-FLAG NOT = 'Y'                     
               MOVE AT-ACCOUNT-NO TO CT-ACCOUNT-NO                      
               PERFORM 7160-GET-CONTRACT-INFO THRU 7160-EXIT            
           END-IF.                                                      
      *                                                                 17910089
C30169     MOVE AT-ACCOUNT-TYPE-CODE TO WS-ACCOUNT-TYPE-CODE.           
      *                                                                 17920088
           MOVE WS-N TO WS-BNKDRFT-ACCT2-FLAG.                          
           PERFORM 7230-CK-FOR-BNKDRFT            THRU 7230-EXIT.       
           MOVE WS-BNKDRFT-ACCT2-FLAG TO E-FRP032-BNKDRFT-ACCT2-FLAG.   
      *                                                                 17990088
           MOVE AT-COMPANY-NO         TO WS-TO-COMPANY-NO.              
           MOVE WS-OUTPUT-ID          TO E-FRP032-OUTPUT-ID.            
           MOVE DQ-FROM-NAME-TYPE     TO E-FRP032-FROM-NAME-TYPE.       
           MOVE CE-FROM-SSN           TO E-FRP032-FROM-SSN.             
           MOVE DQ-FROM-NAME          TO E-FRP032-FROM-NAME.            
           MOVE CE-FROM-CUSTOMER-TYPE TO E-FRP032-FROM-CUST-TYPE.       
           MOVE AT-CUSTOMER-NO        TO E-FRP032-TO-CUSTOMER-NO.       
           MOVE AT-ACCOUNT-NO         TO E-FRP032-TO-ACCOUNT-NO.        
           MOVE WS-ACCOUNT-TYPE-CODE  TO E-FRP032-TO-ACCT-TYPE.         
           MOVE AT-CREDIT-GROUP       TO E-FRP032-TO-CREDIT-GRP.        
           MOVE AT-LOCAL-OFFICE       TO E-FRP032-LOCAL-OFFICE-ACCT2.   
           MOVE DQ-FULL-NAME          TO E-FRP032-TO-NAME.              
           MOVE CT-LIEN-CD            TO E-FRP032-CONTRACT-LIEN-FLAG.   
           MOVE 'N' TO E-FRP032-MULTI-ACCT2-FLAG.                       
           MOVE WS-AUTO-XFER-EXEMP-FL TO E-FRP032-XFER-XEMPT-EITHER-FL. 
      *                                                                 18290088
           IF RP032-SELECTED AND                                        
              WS-TEMP-CUSTOMER-NO NOT = E-FRP032-FROM-CUSTOMER-NO       
               MOVE DQ-FULL-NAME     TO E-FRP032-TO-NAME                
               MOVE DQ-NAME-TYPE     TO E-FRP032-TO-NAME-TYPE           
               MOVE CE-CUSTOMER-NO   TO E-FRP032-TO-CUSTOMER-NO         
               MOVE CE-CUSTOMER-TYPE TO E-FRP032-TO-CUST-TYPE           
               MOVE CE-SSN           TO E-FRP032-TO-SSN                 
           END-IF.                                                      
      *                                                                 18290200
       1400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18320005
      ******************************************************************18330000
      * LOAD THE FA08 INFORMATION SO ACCOUNT WILL BE TRANFERED TO      *18340000
      * OTHER ACTIVE ACCOUNT.                                          *18350000
      ******************************************************************18360000
       1500-LOAD-FFA08.                                                 
      *                                                                 18380000
           MOVE WS-FR-COMPANY-NO     TO E-FFA08-COMPANY-NO.             
           MOVE WS-OUTPUT-ID         TO E-FFA08-OUTPUT-ID.              
           ADD 1                     TO WS-FFA08-SEQ-NO.                
           MOVE WS-FFA08-SEQ-NO      TO E-FFA08-SEQ-NO.                 
           MOVE WS-FR-ACCOUNT-NO     TO E-FFA08-FROM-ACCOUNT-NO.        
           MOVE AT-ACCOUNT-NO        TO E-FFA08-TO-ACCOUNT-NO.          
      *                                                                 18450000
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18480000
      **********************************************************        18490088
      * RETRIEVE THE DAY WQ DEFER FROM CSS_DELINQUENCY         *        18500088
      * RATHER THAN USING HARD-CODED VALUES.                   *        18510088
      **********************************************************        18520088
       1800-SELECT-DELINQUENCY.                                         
      *                                                                 18540088
           MOVE AT-COMPANY-NO TO C8-COMPANY-NO.                         
      *                                                                 18560088
           EXEC SQL                                                     
             SELECT DELINQ_VALUE                                        
               INTO :WS-HOLD-DEL-VALUE                                  
               FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
              WHERE DELINQ_CD    = :C8-DELINQ-CD                        
                AND COMPANY_NO   = :C8-COMPANY-NO                       
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     18570088
MFA-TR*      SELECT DELINQ_VALUE                                        18580088
MFA-TR*        INTO :WS-HOLD-DEL-VALUE                                  18590088
MFA-TR*        FROM CSS_DELINQUENCY                                     18600088
MFA-TR*       WHERE DELINQ_CD    = :C8-DELINQ-CD                        18610088
MFA-TR*         AND COMPANY_NO   = :C8-COMPANY-NO                       18620088
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    18630088

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 18660088
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
LEF           DISPLAY ' DELINQUENCY CODE ' C8-DELINQ-CD                 
LEF           DISPLAY ' DELINQUENCY COMPANY ' C8-COMPANY-NO             
              DISPLAY '** DELINQUENCY TABLE  '                          
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 1505 :  RETURN CODE ERROR - SELECT '          
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18830088
      ******************************************************************18840050
      *   2040-GET-FB-BALANCE                                          *18840060
      ******************************************************************18840070
       2040-GET-FB-BALANCE.                                             
      *                                                                 18840090
           MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT.       
           MOVE 'Y'                       TO CALC-BALANCE-SW            
                                             CALC-ARREARS-SW            
                                             CALC-PAST-DUE-SW.          
           PERFORM 8600-CALL-SCSCB068   THRU 8600-EXIT.                 
      *                                                                 18840096
           MOVE WS-AMT-FULL-BALANCE     TO WS-TOTAL-BAL.                
      *                                                                 18840098
       2040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18840110
      ******************************************************************18840120
      *   2050-GET-WO-BALANCE                                          *18840130
      ******************************************************************18840140
       2050-GET-WO-BALANCE.                                             
      *                                                                 18840160
           MOVE AT-CODES-DATA-PRESENT   TO WS-CODES-DATA-PRESENT.       
C30169     MOVE 'Y'                     TO CALC-PAST-DUE-SW.            
           PERFORM 8600-CALL-SCSCB068  THRU 8600-EXIT.                  
      *                                                                 18840193
           MOVE WS-WO-BALANCE          TO WS-WRITE-OFF-BAL.             
      *                                                                 18840195
       2050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18840198
      ******************************************************************18840199
      *   2060-CHECK-REGULATED                                         *18840200
      ******************************************************************18840210
       2060-CHECK-REGULATED.                                            
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     18840230
MFA-TR*        SELECT REG_GROUP_CD                                      18840240
MFA-TR*          INTO :LR-REG-GROUP-CD                                  18840250
MFA-TR*          FROM CSS_REG_PROFILE                                   18840260
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       18840270
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    18840280

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18840290
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   MOVE '   ' TO LR-REG-GROUP-CD                        
               END-IF                                                   
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** CSS_REG_PROFILE                        '     
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '** 1260 : RETURN CODE ERROR - SELECT      '     
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '******************************************'     
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 18840350
       2060-EXIT.                                                       
           EXIT.                                                        
      *                                                                 18840380
      ******************************************************************18840400
      * 2450-MOVE-FROM-ACCT-INFO.                                      *18850020
      * THIS MODULE POPULATES WS-FROM-ACCOUNT-INFO.                    *18860040
      ******************************************************************18870000
       2450-MOVE-FROM-ACCT-INFO.                                        
      *                                                                 18880100
C30169     MOVE AT-ACCOUNT-TYPE-CODE TO WS-ACCOUNT-TYPE-CODE.           
           MOVE WS-ACCOUNT-TYPE-CODE TO E-FRP032-FROM-ACCT-TYPE.        
      *                                                                 18880400
           IF SEB-DATABASE                                              
               PERFORM 2060-CHECK-REGULATED   THRU 2060-EXIT            
               MOVE 'SEB' TO E-FRP032-DATABASE                          
               MOVE LR-REG-GROUP-CD TO E-FRP032-REG-GROUP-CD            
           ELSE                                                         
               MOVE '   ' TO E-FRP032-REG-GROUP-CD                      
               MOVE 'CSR' TO E-FRP032-DATABASE                          
           END-IF.                                                      
      *                                                                 18881000
           MOVE AT-ACCOUNT-NO TO CT-ACCOUNT-NO.                         
           PERFORM 7160-GET-CONTRACT-INFO THRU 7160-EXIT.               
           MOVE CT-LIEN-CD TO E-FRP032-CONTRACT-LIEN-FLAG.              
      *                                                                 18881700
           MOVE ZEROES TO WS-TOTAL-NON-UTIL-BAL.                        
           MOVE WS-N TO E-FRP032-NON-UTIL-BAL-FLAG.                     
           PERFORM 7140-GET-NON-UTIL-AMT          THRU 7140-EXIT.       
      *                                                                 18890000
           MOVE AT-COMPANY-NO         TO WS-FR-COMPANY-NO.              
           MOVE AT-ACCOUNT-NO         TO WS-FR-ACCOUNT-NO.              
           MOVE AT-CUSTOMER-NO        TO WS-FR-CUSTOMER-NO.             
           MOVE AT-CODE-ACCT-STAT     TO WS-FR-CODE-ACCT-STAT.          
           MOVE AT-CODE-STATUS-REASON TO WS-FR-CODE-STATUS-REASON.      
           MOVE AT-CODE-COMPANY-ACCT  TO WS-FR-CODE-COMPANY-ACCT.       
           MOVE AT-BILL-CYCLE         TO WS-FR-BILL-CYCLE.              
           MOVE AT-DATE-BILL-DAY-00   TO WS-FR-DATE-BILL-DAY-00.        
           MOVE AT-DATE-BILL-DAY-30   TO WS-FR-DATE-BILL-DAY-30.        
           MOVE AT-DATE-BILL-DAY-60   TO WS-FR-DATE-BILL-DAY-60.        
           MOVE AT-DATE-BILL-DAY-90   TO WS-FR-DATE-BILL-DAY-90.        
           MOVE AT-DATE-LAST-ACTION   TO WS-FR-DATE-LAST-ACTION.        
           MOVE AT-LAST-PYMT-AMOUNT   TO WS-FR-LAST-PYMT-AMOUNT.        
           MOVE AT-LAST-PYMT-DATE     TO WS-FR-LAST-PYMT-DATE.          
           MOVE AT-BANKRUPTCY-IND     TO WS-FR-BANKRUPTCY-IND.          
           MOVE WS-ACCOUNT-TYPE-CODE  TO WS-FR-ACCOUNT-TYPE-CODE.       
           MOVE AT-PREMISE-NO         TO WS-FR-PREMISE-NO.              
           MOVE AT-ACCT-FINALED-DT    TO WS-FR-ACCT-FINALED-DT.         
           MOVE AT-CREDIT-GROUP       TO WS-FR-CREDIT-GROUP.            
           MOVE AT-LOCAL-OFFICE       TO WS-FR-LOCAL-OFFICE.            
           MOVE AT-MST-SUB-ACCT-IND   TO WS-FR-MST-SUB-ACCT-IND.        
           MOVE AT-JUDGEMENT-CASE-NO  TO WS-FR-JUDGMENT-CASE-NO.        
           MOVE AT-JUDGEMENT-IND      TO WS-FR-JUDGMENT-IND.            
           MOVE AT-NOTICE-EXEMPT-CD   TO WS-FR-NOTICE-EXEMPT-CD.        
           MOVE AT-CODE-MAJOR-ACCT    TO WS-FR-CODE-MAJOR-ACCT.         
           MOVE AT-ADDRESS-ID         TO WS-FR-ADDRESS-ID.              
           MOVE AT-ADDRESS-FORMAT     TO WS-FR-ADDRESS-FORMAT.          
           MOVE AT-CODES-DATA-PRESENT TO WS-FR-CODES-DATA-PRESENT.      
           MOVE AT-CODE-LPC-XMT       TO WS-FR-CODE-LPC-XMT.            
           MOVE AT-CODE-BILL-FREQ     TO WS-FR-CODE-BILL-FREQ.          
           MOVE AT-CODE-PERM-BILL     TO WS-FR-CODE-PERM-BILL.          
      *                                                                 19080088
           MOVE WS-FR-COMPANY-NO       TO E-FRP032-COMPANY-NO.          
           MOVE WS-OUTPUT-ID           TO E-FRP032-OUTPUT-ID.           
           MOVE WS-INPUT-DATE          TO E-FRP032-RUN-DATE.            
           MOVE WS-FR-ACCOUNT-NO       TO E-FRP032-FROM-ACCOUNT-NO.     
           MOVE WS-FR-CUSTOMER-NO      TO E-FRP032-FROM-CUSTOMER-NO.    
           MOVE SPACES                 TO E-FRP032-FROM-NAME-TYPE.      
           MOVE SPACES                 TO E-FRP032-FROM-SSN.            
           MOVE SPACES                 TO E-FRP032-FROM-NAME.           
           MOVE SPACES                 TO E-FRP032-FROM-CUST-TYPE.      
           MOVE WS-FR-LOCAL-OFFICE     TO E-FRP032-LOCAL-OFFICE-ACCT1.  
           MOVE 'D'                    TO E-FRP032-REC-TYPE.            
      *                                                                 19081300
           IF AT-LAST-PYMT-DATE = LOW-VALUES                            
               MOVE '0000-00-00'      TO WS-FR-LAST-PYMT-DATE           
           ELSE                                                         
               MOVE AT-LAST-PYMT-DATE TO WS-FR-LAST-PYMT-DATE           
           END-IF.                                                      
      *                                                                 19140088
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19170000
      ******************************************************************19180020
      *                                                                *19190030
      *      4750-UPD-LAST-RUN-DATE                                    *19200040
      *                                                                *19210050
      ******************************************************************19220080
       4750-UPD-LAST-RUN-DATE.                                          
      *                                                                 19240088
           MOVE SPACES TO G6-PARM-DATA.                                 
           STRING                                                       
              WS-LAST-R-DATE-LITERAL  DELIMITED BY SIZE                 
              WS-PROGRAM-DATE DELIMITED BY SIZE                         
           INTO                                                         
              G6-PARM-DATA.                                             
      *                                                                 19310088
           MOVE PROGRAM-NAME             TO G6-PROGRAM-NAME.            
           MOVE WS-PARM                  TO G6-CMND-CODE.               
           MOVE '01'                     TO G6-COMPANY-NO.              
           MOVE +10                      TO G6-SEQ-NO.                  
           PERFORM 8200-UPD-LAST-RUN-DATE THRU 8200-EXIT.               
      *                                                                 19370000
       4750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19400000
      ****************************                                      19410010
      * THE FOLLOWING GETS DATES                                        19420000
      ****************************                                      19430010
           EXEC SQL                                                     19440000
                INCLUDE CPD00037                                        19450000
           END-EXEC.                                                    19460000
      *                                                                         
      ***************************** *********************************** 25262000
      ** 6240-GET-FCA00-COMMON-DATE                                     25270000
      ***************************************************************** 25280000
      *                                                                 19470000
C30169     EXEC SQL                                                     19480000
C30169          INCLUDE CPD00040                                        19490000
C30169     END-EXEC.                                                    19500000
      *                                                                 19510088
      ******************************************************************19520088
      *  7000-OPEN-GET-OTHER-ACCTS.                                    *19530000
      *      TRY AND FIND OTHER ACOUNT/S THAT HAVE THE SAME CUSTOMER #.*19540000
      ******************************************************************19550088
       7000-OPEN-GET-OTHER-ACCTS.                                       
      *                                                                 19570000
           EXEC SQL                                                     
              OPEN GET_OTHER_ACCTS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 19610000
           MOVE SQLCODE TO WS-RETURN-CODE7000.                          
           IF WS-RETURN-CODE7000 EQUAL SUCCESSFUL-CALL OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GET-OTHER-ACCTS                         '     
              DISPLAY '** ACCOUNT NO = ' WS-FR-ACCOUNT-NO               
              DISPLAY '** 7000 :  RETURN CODE ERROR - OPEN   '          
              DISPLAY '**      :  RC = ' WS-RETURN-CODE7000             
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 19740000
       7000-OPEN-EXIT.                                                  
           EXIT.                                                        
      *                                                                 19770000
       7010-GET-OTHER-ACCTS.                                            
      *                                                                 19790000
           EXEC SQL                                                     
              FETCH GET_OTHER_ACCTS INTO                                
                 :AT-ACCOUNT-NO,                                        
                 :AT-CUSTOMER-NO,                                       
                 :AT-PREMISE-NO,                                        
                 :AT-COMPANY-NO,                                        
                 :AT-LOCAL-OFFICE,                                      
                 :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,        
                 :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,        
                 :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,        
                 :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,        
                 :AT-DATE-LAST-ACTION :WS-DATE-LAST-ACTION-NULL,        
                 :AT-CODE-DISC-OK,                                      
                 :AT-CODE-LPC-XMT,                                      
                 :AT-CODE-PERM-BILL,                                    
                 :AT-BILL-CYCLE,                                        
                 :AT-TOTAL-AR-BALANCE,                                  
                 :AT-LAST-PYMT-AMOUNT,                                  
                 :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,            
                 :AT-CODES-DATA-PRESENT,                                
                 :AT-CODE-COMPANY-ACCT,                                 
                 :AT-CODE-ACCT-STAT,                                    
                 :AT-ADDRESS-FORMAT,                                    
                 :AT-ADDRESS-ID,                                        
                 :AT-MST-SUB-ACCT-IND,                                  
                 :AT-CODE-MAJOR-ACCT,                                   
                 :AT-CREDIT-GROUP,                                      
                 :AT-ACCOUNT-TYPE-CODE,                                 
                 :AT-BANKRUPTCY-IND,                                    
                 :AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NULL,          
                 :AT-NOTICE-EXEMPT-CD,                                  
                 :AT-CODE-STATUS-REASON,                                
                 :AT-JUDGEMENT-CASE-NO                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20140000
           MOVE SQLCODE TO WS-RETURN-CODE7000.                          
           IF WS-RETURN-CODE7000 = SUCCESSFUL-CALL OR NOT-FOUND         
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT TABLE                          '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7010 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' WS-RETURN-CODE7000             
              DISPLAY '******************************************'      
           END-IF.                                                      
      *                                                                 20260000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 20290000
       7020-CLOSE-GET-OTHER-ACCTS.                                      
      *                                                                 20310000
           EXEC SQL                                                     
              CLOSE GET_OTHER_ACCTS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-RETURN-CODE7000.                          
           IF WS-RETURN-CODE7000 EQUAL SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GET_OTHER_ACCTS                        '      
              DISPLAY '** ACCOUNT NO = ' WS-FR-ACCOUNT-NO               
              DISPLAY '** 7020 :  RETURN CODE ERROR - CLOSE      '      
              DISPLAY '**      :  RC = ' WS-RETURN-CODE7000             
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7020-CLOSE-EXIT.                                                 
           EXIT.                                                        
      *                                                                 20500088
      ******************************************************************20510088
      *  7030-OPEN-GET-OTHER-CUSTS.                                    *20520000
      *      TRY AND FIND OTHER CUSTOMERS WITH THE SAME NAME.          *20530000
      ******************************************************************20540088
       7030-OPEN-GET-OTHER-CUSTS.                                       
      *                                                                 20560000
           EXEC SQL                                                     
              OPEN GET_OTHER_CUSTS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20600000
           MOVE SQLCODE TO WS-RETURN-CODE7002.                          
           IF WS-RETURN-CODE7002 EQUAL SUCCESSFUL-CALL OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GET-OTHER-CUSTS                        '      
              DISPLAY '** CUSTOMER NO = ' WS-FR-CUSTOMER-NO             
              DISPLAY '** 7030 :  RETURN CODE ERROR - OPEN   '          
              DISPLAY '**      :  RC = ' WS-RETURN-CODE7002             
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 20730000
       7030-OPEN-EXIT.                                                  
           EXIT.                                                        
      *                                                                 20760000
       7040-GET-OTHER-CUSTS.                                            
      *                                                                 20780000
           INITIALIZE DCLCSS-NAME.                                      
           INITIALIZE DCLCSS-CUST-STATS.                                
      *                                                                 20780400
           EXEC SQL                                                     
              FETCH GET_OTHER_CUSTS INTO                                
                 :DQ-NAME-ID,                                           
                 :DQ-FULL-NAME,                                         
                 :DQ-NAME-TYPE,                                         
                 :CE-CUSTOMER-NO,                                       
                 :CE-CUSTOMER-TYPE,                                     
                 :CE-SSN                                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 20850000
           MOVE SQLCODE TO WS-RETURN-CODE7002.                          
      *                                                                 20860100
           IF E-FRP032-FROM-ACCT-TYPE = 'R'                             
               IF CE-SSN = SPACES OR CE-FROM-SSN = 'NO FR SSN'          
                   NEXT SENTENCE                                        
               ELSE                                                     
                   IF WS-RETURN-CODE7002 = SUCCESSFUL-CALL AND          
                      CE-SSN NOT = CE-FROM-SSN                          
                       GO TO 7040-GET-OTHER-CUSTS                       
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
      *                                                                 20890110
           IF WS-RETURN-CODE7002 = SUCCESSFUL-CALL OR NOT-FOUND         
               IF RP032-SELECTED                                        
                   NEXT SENTENCE                                        
               ELSE                                                     
                   IF WS-RETURN-CODE7002 = SUCCESSFUL-CALL AND          
                      WS-FRP032-MULTI-ACCT2 = 'N'                       
                       MOVE DQ-NAME-TYPE     TO E-FRP032-TO-NAME-TYPE   
                       MOVE CE-CUSTOMER-NO   TO E-FRP032-TO-CUSTOMER-NO 
                       MOVE CE-CUSTOMER-TYPE TO E-FRP032-TO-CUST-TYPE   
                       MOVE CE-SSN           TO E-FRP032-TO-SSN         
                       IF DQ-NAME-TYPE NOT = 'CN'                       
                           MOVE DQ-FROM-NAME TO E-FRP032-TO-NAME        
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CUSTOMER TABLE                         '      
              DISPLAY '** CUSTOMER NO = ' WS-FR-CUSTOMER-NO             
              DISPLAY '** 7040 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' WS-RETURN-CODE7002             
              DISPLAY '******************************************'      
           END-IF.                                                      
      *                                                                 20970000
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21000000
       7050-CLOSE-GET-OTHER-CUSTS.                                      
      *                                                                 21020000
           EXEC SQL                                                     
              CLOSE GET_OTHER_CUSTS                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-RETURN-CODE7002.                          
           IF WS-RETURN-CODE7002 EQUAL SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** GET_OTHER_CUSTS                       '       
              DISPLAY '** CUSTOMER NO = ' WS-FR-CUSTOMER-NO             
              DISPLAY '** 7050 :  RETURN CODE ERROR - CLOSE      '      
              DISPLAY '**      :  RC = ' WS-RETURN-CODE7002             
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7050-CLOSE-EXIT.                                                 
           EXIT.                                                        
C30169*                                                                 22200088
C30169******************************************************************21220088
C30169*  7070-OPEN-COLL-AGY-CRED-BUR.                                  *21230000
C30169*      TRY AND FIND OTHER COLLECTION AGENCY ACCTS (65 DAY)       *21240000
C30169******************************************************************21250088
C30169 7070-OPEN-COLL-AGY-CRED-BUR.                                     
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        OPEN GET_CA_CRED_BUR                                      
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        DISPLAY '******************************************'      
C30169        DISPLAY '** GET_CA_CRED_BUR                    '          
C30169        DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
C30169        DISPLAY '** LAST RUN DATE = ' WS-LAST-RUN-DATE            
C30169        DISPLAY '** CURR RUN DATE = ' WS-CURR-RUN-DATE            
C30169        DISPLAY '** 7070 :  RETURN CODE ERROR - OPEN   '          
C30169        DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
C30169        DISPLAY '******************************************'      
C30169        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
C30169     END-IF.                                                      
C30169                                                                  
C30169 7070-OPEN-EXIT.                                                  
C30169     EXIT.                                                        
C30169                                                                  
C30169 7080-GET-COLL-AGY-CRED-BUR.                                      
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        FETCH GET_CA_CRED_BUR INTO                                
C30169           :WS-CA-ACCOUNT-NO,                                     
C30169           :AT-CUSTOMER-NO,                                       
C30169           :AT-PREMISE-NO,                                        
C30169           :AT-COMPANY-NO,                                        
C30169           :AT-LOCAL-OFFICE,                                      
C30169           :KD-FW-ACTION-TYPE-CD,                                 
C30169           :KD-FW-ACTION-DT                                       
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        DISPLAY '******************************************'      
C30169        DISPLAY '** ACCOUNT TABLE                          '      
C30169        DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
C30169        DISPLAY '** 7080 :  RETURN CODE ERROR - SELECT     '      
C30169        DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
C30169        DISPLAY '******************************************'      
C30169     END-IF.                                                      
C30169                                                                  
C30169 7080-EXIT.                                                       
C30169     EXIT.                                                        
C30169                                                                  
C30169 7090-CLOSE-COLL-AGY-CRED-BUR.                                    
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        CLOSE GET_CA_CRED_BUR                                     
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        DISPLAY '******************************************'      
C30169        DISPLAY '** GET_CA_CRED_BUR                  '            
C30169        DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
C30169        DISPLAY '** 7090 :  RETURN CODE ERROR - CLOSE      '      
C30169        DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
C30169        DISPLAY '******************************************'      
C30169        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
C30169     END-IF.                                                      
C30169 7090-CLOSE-EXIT.                                                 
C30169     EXIT.                                                        
C30169*                                                                 22200088
      ******************************************************************23200088
      *  7100-SELECT-ACCOUNT.                                          *23210006
      ******************************************************************23220088
       7100-SELECT-ACCOUNT.                                             
      *                                                                 23240009
           EXEC SQL                                                     
             SELECT                                                     
                 CUSTOMER_NO,                                           
                 ACCOUNT_NO,                                            
                 PREMISE_NO,                                            
                 COMPANY_NO,                                            
                 LOCAL_OFFICE,                                          
                 DATE_BILL_DAY_00,                                      
                 DATE_BILL_DAY_30,                                      
                 DATE_BILL_DAY_60,                                      
                 DATE_BILL_DAY_90,                                      
                 DATE_LAST_ACTION,                                      
                 CODE_DISC_OK,                                          
                 CODE_LPC_XMT,                                          
                 CODE_PERM_BILL,                                        
                 BILL_CYCLE,                                            
                 TOTAL_AR_BALANCE,                                      
                 LAST_PYMT_AMOUNT,                                      
                 LAST_PYMT_DATE,                                        
                 CODES_DATA_PRESENT,                                    
                 CODE_COMPANY_ACCT,                                     
                 CODE_ACCT_STAT,                                        
                 ADDRESS_FORMAT,                                        
                 ADDRESS_ID,                                            
                 MST_SUB_ACCT_IND,                                      
                 CODE_MAJOR_ACCT,                                       
                 CREDIT_GROUP,                                          
                 ACCOUNT_TYPE_CODE,                                     
                 BANKRUPTCY_IND,                                        
                 REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                 NOTICE_EXEMPT_CD,                                      
                 CODE_STATUS_REASON,                                    
                 JUDGEMENT_CASE_NO,                                     
                 JUDGEMENT_IND                                          
               INTO                                                     
                 :AT-CUSTOMER-NO,                                       
                 :AT-ACCOUNT-NO,                                        
                 :AT-PREMISE-NO,                                        
                 :AT-COMPANY-NO,                                        
                 :AT-LOCAL-OFFICE,                                      
                 :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,        
                 :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,        
                 :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,        
                 :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,        
                 :AT-DATE-LAST-ACTION :WS-DATE-LAST-ACTION-NULL,        
                 :AT-CODE-DISC-OK,                                      
                 :AT-CODE-LPC-XMT,                                      
                 :AT-CODE-PERM-BILL,                                    
                 :AT-BILL-CYCLE,                                        
                 :AT-TOTAL-AR-BALANCE,                                  
                 :AT-LAST-PYMT-AMOUNT,                                  
                 :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,            
                 :AT-CODES-DATA-PRESENT,                                
                 :AT-CODE-COMPANY-ACCT,                                 
                 :AT-CODE-ACCT-STAT,                                    
                 :AT-ADDRESS-FORMAT,                                    
                 :AT-ADDRESS-ID,                                        
                 :AT-MST-SUB-ACCT-IND,                                  
                 :AT-CODE-MAJOR-ACCT,                                   
                 :AT-CREDIT-GROUP,                                      
                 :AT-ACCOUNT-TYPE-CODE,                                 
                 :AT-BANKRUPTCY-IND,                                    
                 :AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NULL,          
                 :AT-NOTICE-EXEMPT-CD,                                  
                 :AT-CODE-STATUS-REASON,                                
                 :AT-JUDGEMENT-CASE-NO,                                 
                 :AT-JUDGEMENT-IND                                      
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
             WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     23250010
MFA-TR*      SELECT                                                     23260020
MFA-TR*          CUSTOMER_NO,                                           23270030
MFA-TR*          ACCOUNT_NO,                                            23280040
MFA-TR*          PREMISE_NO,                                            23290050
MFA-TR*          COMPANY_NO,                                            23300060
MFA-TR*          LOCAL_OFFICE,                                          23310070
MFA-TR*          DATE_BILL_DAY_00,                                      23320080
MFA-TR*          DATE_BILL_DAY_30,                                      23330088
MFA-TR*          DATE_BILL_DAY_60,                                      23340000
MFA-TR*          DATE_BILL_DAY_90,                                      23350000
MFA-TR*          DATE_LAST_ACTION,                                      23360000
MFA-TR*          CODE_DISC_OK,                                          23370000
MFA-TR*          CODE_LPC_XMT,                                          23380000
MFA-TR*          CODE_PERM_BILL,                                        23390000
MFA-TR*          BILL_CYCLE,                                            23400000
MFA-TR*          TOTAL_AR_BALANCE,                                      23410000
MFA-TR*          LAST_PYMT_AMOUNT,                                      23420000
MFA-TR*          LAST_PYMT_DATE,                                        23430000
MFA-TR*          CODES_DATA_PRESENT,                                    23440000
MFA-TR*          CODE_COMPANY_ACCT,                                     23450000
MFA-TR*          CODE_ACCT_STAT,                                        23460000
MFA-TR*          ADDRESS_FORMAT,                                        23470000
MFA-TR*          ADDRESS_ID,                                            23480000
MFA-TR*          MST_SUB_ACCT_IND,                                      23490000
MFA-TR*          CODE_MAJOR_ACCT,                                       23500000
MFA-TR*          CREDIT_GROUP,                                          23510000
MFA-TR*          ACCOUNT_TYPE_CODE,                                     23520000
MFA-TR*          BANKRUPTCY_IND,                                        23530000
MFA-TR*          ACCT_FINALED_DT,                                       23540000
MFA-TR*          NOTICE_EXEMPT_CD,                                      23550000
MFA-TR*          CODE_STATUS_REASON,                                    23560000
MFA-TR*          JUDGEMENT_CASE_NO,                                     23570088
MFA-TR*          JUDGEMENT_IND                                          23580088
MFA-TR*        INTO                                                     23590000
MFA-TR*          :AT-CUSTOMER-NO,                                       23600000
MFA-TR*          :AT-ACCOUNT-NO,                                        23610000
MFA-TR*          :AT-PREMISE-NO,                                        23620000
MFA-TR*          :AT-COMPANY-NO,                                        23630000
MFA-TR*          :AT-LOCAL-OFFICE,                                      23640000
MFA-TR*          :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,        23650000
MFA-TR*          :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,        23660000
MFA-TR*          :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,        23670000
MFA-TR*          :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,        23680000
MFA-TR*          :AT-DATE-LAST-ACTION :WS-DATE-LAST-ACTION-NULL,        23690000
MFA-TR*          :AT-CODE-DISC-OK,                                      23700000
MFA-TR*          :AT-CODE-LPC-XMT,                                      23710000
MFA-TR*          :AT-CODE-PERM-BILL,                                    23720000
MFA-TR*          :AT-BILL-CYCLE,                                        23730000
MFA-TR*          :AT-TOTAL-AR-BALANCE,                                  23740000
MFA-TR*          :AT-LAST-PYMT-AMOUNT,                                  23750000
MFA-TR*          :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NULL,            23760000
MFA-TR*          :AT-CODES-DATA-PRESENT,                                23770000
MFA-TR*          :AT-CODE-COMPANY-ACCT,                                 23780000
MFA-TR*          :AT-CODE-ACCT-STAT,                                    23790000
MFA-TR*          :AT-ADDRESS-FORMAT,                                    23800000
MFA-TR*          :AT-ADDRESS-ID,                                        23810000
MFA-TR*          :AT-MST-SUB-ACCT-IND,                                  23820000
MFA-TR*          :AT-CODE-MAJOR-ACCT,                                   23830000
MFA-TR*          :AT-CREDIT-GROUP,                                      23840000
MFA-TR*          :AT-ACCOUNT-TYPE-CODE,                                 23850000
MFA-TR*          :AT-BANKRUPTCY-IND,                                    23860000
MFA-TR*          :AT-ACCT-FINALED-DT :WS-ACCT-FINALED-DT-NULL,          23870000
MFA-TR*          :AT-NOTICE-EXEMPT-CD,                                  23880000
MFA-TR*          :AT-CODE-STATUS-REASON,                                23890000
MFA-TR*          :AT-JUDGEMENT-CASE-NO,                                 23900088
MFA-TR*          :AT-JUDGEMENT-IND                                      23910088
MFA-TR*       FROM CSS_ACCOUNT                                          23920000
MFA-TR*      WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                          23930000
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    23940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 23950000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02036     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A02036         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
A02036            MOVE 'Y' TO WS-ACCOUNT-NOT-FOUND                      
A02036         ELSE                                                     
A02036            MOVE 'N' TO WS-ACCOUNT-NOT-FOUND                      
                  IF WS-DATE-BILL-DAY-00-NULL < ZERO                    
                     MOVE LOW-VALUES TO AT-DATE-BILL-DAY-00             
                  END-IF                                                
                  IF WS-DATE-BILL-DAY-30-NULL < ZERO                    
                     MOVE LOW-VALUES TO AT-DATE-BILL-DAY-30             
                  END-IF                                                
                  IF WS-DATE-BILL-DAY-60-NULL < ZERO                    
                     MOVE LOW-VALUES TO AT-DATE-BILL-DAY-60             
                  END-IF                                                
                  IF WS-DATE-BILL-DAY-90-NULL < ZERO                    
                     MOVE LOW-VALUES TO AT-DATE-BILL-DAY-90             
                  END-IF                                                
                  IF WS-DATE-LAST-ACTION-NULL < ZERO                    
                     MOVE LOW-VALUES TO AT-DATE-LAST-ACTION             
                  END-IF                                                
                  IF WS-ACCT-FINALED-DT-NULL < ZERO                     
                     MOVE LOW-VALUES TO AT-ACCT-FINALED-DT              
                  END-IF                                                
                  IF WS-LAST-PYMT-DATE-NULL < ZERO                      
                     MOVE LOW-VALUES TO AT-LAST-PYMT-DATE               
                  END-IF                                                
A02036         END-IF                                                   
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** ACCOUNT TABLE                      '         
               DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                 
               DISPLAY '** 7100 :  RETURN CODE ERROR  - SELECT    '     
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '******************************************'     
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 24280000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24310000
      ******************************************************************24310200
      *  7105                                                          *24310300
      ******************************************************************24310400
       7105-SELECT-CUSTOMER.                                            
      *                                                                 24310600
           EXEC SQL                                                     
             SELECT                                                     
                 NAME_ID                                                
               INTO                                                     
                 :CU-NAME-ID                                            
              FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                           
             WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                        
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24310700
MFA-TR*      SELECT                                                     24310800
MFA-TR*          NAME_ID                                                24311000
MFA-TR*        INTO                                                     24314100
MFA-TR*          :CU-NAME-ID                                            24314300
MFA-TR*       FROM CSS_CUSTOMER                                         24317400
MFA-TR*      WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                        24317500
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    24317600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24317700
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '** CUSTOMER TABLE                      '        
               DISPLAY '** CUSTOMER NO = ' CU-CUSTOMER-NO               
               DISPLAY '** 7105 :  RETURN CODE ERROR  - SELECT    '     
               DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '******************************************'     
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
      *                                                                 24319992
       7105-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24319995
      ******************************************************************24320000
      *  7120-CHECK-GUARANTEED-IND.                                     24330000
      ******************************************************************24340088
       7120-CHECK-GUARANTEED-IND.                                       
      *                                                                 24360000
           EXEC SQL                                                     
              SELECT                                                    
                  ACCOUNT_NO                                            
               INTO                                                     
                  :AC-ACCOUNT-NO                                        
              FROM CSS_FINAL_WO WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        
                AND GUARANTEED_IND = 'Y'                                
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24370000
MFA-TR*       SELECT                                                    24380000
MFA-TR*           ACCOUNT_NO                                            24390000
MFA-TR*        INTO                                                     24400000
MFA-TR*           :AC-ACCOUNT-NO                                        24410000
MFA-TR*       FROM CSS_FINAL_WO                                         24420000
MFA-TR*       WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        24430000
MFA-TR*         AND GUARANTEED_IND = 'Y'                                24430100
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    24450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24460000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** FINAL WO TABLE                         '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7120:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24600100
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24610000
      ******************************************************************24610010
      *  7130-CHECK-AR.                                                *24610020
      ******************************************************************24610030
       7130-CHECK-AR.                                                   
      *                                                                 24610050
           EXEC SQL                                                     
C35227        SELECT TOP(1) ACCOUNT_NO                                          
               INTO                                                     
                  :AC-ACCOUNT-NO                                        
              FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                            
              WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        
                AND PYMT_PRIORITY_LVL IN(50,70,80,90)                   
                AND ITEM_ID > 0                                         
                                                    
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24610060
MFA-TR*       SELECT                                                    24610070
MFA-TR*           ACCOUNT_NO                                            24610080
MFA-TR*        INTO                                                     24610090
MFA-TR*           :AC-ACCOUNT-NO                                        24610091
MFA-TR*       FROM CSS_AR_CNTL                                          24610092
MFA-TR*       WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        24610093
MFA-TR*         AND PYMT_PRIORITY_LVL IN(50,70,80,90)                   24610095
MFA-TR*         AND ITEM_ID > 0                                         24610094
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    24610099

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24610100
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** AR CNTL TABLE                          '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7130:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24610113
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24610116
      ******************************************************************24610117
      *  7135-CHECK-CHRG-OFF.                                          *24610118
      ******************************************************************24610120
       7135-CHECK-CHRG-OFF.                                             
      *                                                                 24610140
           EXEC SQL                                                     
              SELECT                                                    
                  ACCOUNT_NO                                            
               INTO                                                     
                  :AC-ACCOUNT-NO                                        
              FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        
C35227          AND PYMT_PRIORITY_LVL IN(50,70,80,90)                   
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24610150
MFA-TR*       SELECT                                                    24610160
MFA-TR*           ACCOUNT_NO                                            24610170
MFA-TR*        INTO                                                     24610180
MFA-TR*           :AC-ACCOUNT-NO                                        24610190
MFA-TR*       FROM CSS_CHRG_OFF                                         24610191
MFA-TR*       WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        24610192
MFA-TR*         AND PYMT_PRIORITY_LVL IN(50,70,80,90)                   24610194
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    24610198

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24610199
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CHRG OFF TABLE                         '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7130:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24610212
       7135-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24610215
      ******************************************************************24610220
      *  7140-GET-NON-UTIL-AMT.                                        *24610300
      ******************************************************************24610400
       7140-GET-NON-UTIL-AMT.                                           
      *                                                                 24610600
           EXEC SQL                                                     
              SELECT                                                    
                  SUM(TOTAL_AR_BALANCE)                                 
               INTO                                                     
                  :WS-TOTAL-NON-UTIL-BAL :WS-TOTAL-NON-UTIL-BAL-NULL    
              FROM CSS_ACCOUNT                                          
              WHERE CUSTOMER_NO  = :AT-CUSTOMER-NO                      
                AND ACCOUNT_TYPE_CODE = 'N'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24611600
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-TOTAL-NON-UTIL-BAL > ZERO                           
                 MOVE 'Y' TO E-FRP032-NON-UTIL-BAL-FLAG                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT TABLE                          '      
              DISPLAY '** CUSTOMER NO = ' AT-CUSTOMER-NO                
              DISPLAY '** 7140:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24613100
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24640000
      ******************************************************************24650000
      *  7160-GET-CONTRACT-INFO.                                       *24660000
      ******************************************************************24670088
       7160-GET-CONTRACT-INFO.                                          
      *                                                                 24690000
           EXEC SQL                                                     
              SELECT                                                    
                  LIEN_CD                                               
               INTO                                                     
                  :CT-LIEN-CD                                           
              FROM CSS_CONTRACT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO = :CT-ACCOUNT-NO                         
                AND LIEN_CD    = 'Y'                                    
              GROUP BY LIEN_CD                                          
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     24700000
MFA-TR*       SELECT                                                    24710000
MFA-TR*           LIEN_CD                                               24720000
MFA-TR*        INTO                                                     24730000
MFA-TR*           :CT-LIEN-CD                                           24740000
MFA-TR*       FROM CSS_CONTRACT                                         24750000
MFA-TR*       WHERE ACCOUNT_NO = :CT-ACCOUNT-NO                         24760000
MFA-TR*         AND LIEN_CD    = 'Y'                                    24760100
MFA-TR*       GROUP BY LIEN_CD                                          24760200
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    24770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 24780000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             OR WS-ACTIVE-RETURN-CODE EQUAL -811                        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO CT-LIEN-CD                              
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE EQUAL WS-811                     
                 MOVE 'Y' TO CT-LIEN-CD                                 
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CONTRACT TABLE                         '      
              DISPLAY '** ACCOUNT NO = ' CT-ACCOUNT-NO                  
              DISPLAY '** 7160:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 24930000
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 24960000
      ******************************************************************24970088
      *  7170-SELECT-CREDIT-PROFILE                                    *24980000
      ******************************************************************24990088
       7170-SELECT-CREDIT-PROFILE.                                      
      *                                                                 25010000
           EXEC SQL                                                     
              SELECT                                                    
                  NON_UTL_ARRER_HIST,                                   
                  DISC_EXCEPTN_HIST,                                    
                  DISCONNECT_HIST,                                      
                  ARREARS_HIST,                                         
                  REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                  CASH_ONLY_FL                                          
              INTO                                                      
                  :CZ-NON-UTL-ARRER-HIST,                               
                  :CZ-DISC-EXCEPTN-HIST,                                
                  :CZ-DISCONNECT-HIST,                                  
                  :CZ-ARREARS-HIST,                                     
                  :CZ-LAST-UPDATE-TS,                                   
                  :CZ-CASH-ONLY-FL                                      
              FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     25020000
MFA-TR*       SELECT                                                    25030000
MFA-TR*           NON_UTL_ARRER_HIST,                                   25040000
MFA-TR*           DISC_EXCEPTN_HIST,                                    25050000
MFA-TR*           DISCONNECT_HIST,                                      25060000
MFA-TR*           ARREARS_HIST,                                         25070000
MFA-TR*           LAST_UPDATE_TS,                                       25080000
MFA-TR*           CASH_ONLY_FL                                          25090000
MFA-TR*       INTO                                                      25100000
MFA-TR*           :CZ-NON-UTL-ARRER-HIST,                               25110000
MFA-TR*           :CZ-DISC-EXCEPTN-HIST,                                25120000
MFA-TR*           :CZ-DISCONNECT-HIST,                                  25130000
MFA-TR*           :CZ-ARREARS-HIST,                                     25140000
MFA-TR*           :CZ-LAST-UPDATE-TS,                                   25150000
MFA-TR*           :CZ-CASH-ONLY-FL                                      25160000
MFA-TR*       FROM CSS_CREDIT_PROFILE                                   25170000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         25180000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    25190000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25200000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES TO CZ-ARREARS-HIST                         
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CREDIT_PROFILE TABLE                   '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7170 :  RETURN CODE ERROR - SELECT     '      
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25350000
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25380088
      ******************************************************************25390088
      *  7180-SELECT-CUST-STATS.                                       *25400000
      ******************************************************************25410088
       7180-SELECT-CUST-STATS.                                          
      *                                                                 25430088
           EXEC SQL                                                     
               SELECT  SSN,                                             
                       NAME_ID,                                         
                       CUSTOMER_TYPE                                    
              INTO                                                      
                  :CE-SSN,                                              
                  :CE-NAME-ID,                                          
                  :CE-CUSTOMER-TYPE                                     
              FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                         
              WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                       
               AND  CUSTOMER_TYPE = :WS-CUSTOMER                        
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25440000
MFA-TR*        SELECT  SSN,                                             25450088
MFA-TR*                NAME_ID,                                         25460088
MFA-TR*                CUSTOMER_TYPE                                    25470088
MFA-TR*       INTO                                                      25480000
MFA-TR*           :CE-SSN,                                              25490000
MFA-TR*           :CE-NAME-ID,                                          25500000
MFA-TR*           :CE-CUSTOMER-TYPE                                     25510000
MFA-TR*       FROM CSS_CUST_STATS                                       25520000
MFA-TR*       WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                       25530000
MFA-TR*        AND  CUSTOMER_TYPE = :WS-CUSTOMER                        25540088
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    25550000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25560000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_CUST_STATS TABLE             '            
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7180 :  RETURN CODE ERROR - SELECT '          
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 25690088
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                 25720088
      ******************************************************************25730088
      *  7190-SELECT-CUST-NAME.                                        *25740000
      ******************************************************************25750088
       7190-SELECT-CUST-NAME.                                           
      *                                                                 25770088
           EXEC SQL                                                     
               SELECT  NAME_TYPE,                                       
                       FULL_NAME                                        
              INTO                                                      
                  :DQ-NAME-TYPE,                                        
                  :DQ-FULL-NAME                                         
              FROM CSS_NAME WITH(READUNCOMMITTED)                               
              WHERE NAME_ID = :DQ-NAME-ID                               
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     25780000
MFA-TR*        SELECT  NAME_TYPE,                                       25790090
MFA-TR*                FULL_NAME                                        25791090
MFA-TR*       INTO                                                      25800000
MFA-TR*           :DQ-NAME-TYPE,                                        25810090
MFA-TR*           :DQ-FULL-NAME                                         25811090
MFA-TR*       FROM CSS_NAME                                             25820000
MFA-TR*       WHERE NAME_ID = :DQ-NAME-ID                               25830000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    25840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 25850000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES          TO DQ-FROM-NAME-TYPE              
                 MOVE SPACES          TO DQ-FROM-NAME                   
                 MOVE 'NO NAME FOUND' TO DQ-FROM-NAME                   
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_NAME TABLE             '                  
              DISPLAY '** NAME ID = ' CE-FROM-NAME-ID                   
              DISPLAY '** 7190 :  RETURN CODE ERROR - SELECT '          
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 26010088
       7190-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26040088
      ******************************************************************26050088
      *  7200                                                          *26060000
      ******************************************************************26070088
       7200-SELECT-CUSTOMER.                                            
      *                                                                 26090000
           EXEC SQL                                                     
              SELECT                                                    
                  CODE_EMPL_ACCT,                                       
                  CODE_CUST_STATUS,                                     
                  AUTO_XFER_TO_ACCT,                                    
                  NAME_ID                                               
              INTO                                                      
                  :CU-CODE-EMPL-ACCT,                                   
                  :CU-CODE-CUST-STATUS,                                 
                  :CU-AUTO-XFER-TO-ACCT :WS-AUTO-XFER-ACCT-NULL,        
                  :CU-NAME-ID                                           
              FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                           
              WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26100000
MFA-TR*       SELECT                                                    26110000
MFA-TR*           CODE_EMPL_ACCT,                                       26120000
MFA-TR*           CODE_CUST_STATUS,                                     26130000
MFA-TR*           AUTO_XFER_TO_ACCT,                                    26140000
MFA-TR*           NAME_ID                                               26150000
MFA-TR*       INTO                                                      26160000
MFA-TR*           :CU-CODE-EMPL-ACCT,                                   26170000
MFA-TR*           :CU-CODE-CUST-STATUS,                                 26180000
MFA-TR*           :CU-AUTO-XFER-TO-ACCT :WS-AUTO-XFER-ACCT-NULL,        26190000
MFA-TR*           :CU-NAME-ID                                           26200000
MFA-TR*       FROM CSS_CUSTOMER                                         26210000
MFA-TR*       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       26220000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    26230000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26240000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-AUTO-XFER-ACCT-NULL < 0                             
                 MOVE ZEROES TO CU-AUTO-XFER-TO-ACCT                    
              END-IF                                                    
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CUSTOMER TABLE                   '            
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7200 :  RETURN CODE ERROR - SELECT '          
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 26390000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26420000
      ******************************************************************26430000
      *  7230-CK-FOR-BNKDRFT.                                          *26440000
      ******************************************************************26450088
       7230-CK-FOR-BNKDRFT.                                             
      *                                                                 26470088
           EXEC SQL                                                     
              SELECT                                                    
                   'Y'                                                  
               INTO                                                     
                  :WS-BNKDRFT-ACCT2-FLAG                                
              FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        
                AND STATUS_CODE = 'A'                                   
                AND INIT_TYPE_CD = '01'                                 
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     26480000
MFA-TR*       SELECT                                                    26490000
MFA-TR*            'Y'                                                  26500000
MFA-TR*        INTO                                                     26510000
MFA-TR*           :WS-BNKDRFT-ACCT2-FLAG                                26520000
MFA-TR*       FROM CSS_BANK_EFT                                         26570100
MFA-TR*       WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                        26570200
MFA-TR*         AND STATUS_CODE = 'A'                                   26570300
MFA-TR*         AND INIT_TYPE_CD = '01'                                 26570400
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    26570500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 26580000
           MOVE 'N' TO WS-BNKDRFT-ACCT2-FLAG.                           
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              OR WS-ACTIVE-RETURN-CODE EQUAL -811                       
               IF WS-ACTIVE-RETURN-CODE EQUAL -811                      
                   MOVE 'Y' TO WS-BNKDRFT-ACCT2-FLAG                    
               END-IF                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** ACCOUNT TABLE                          '      
              DISPLAY '** CUSTOMER NO = ' AT-ACCOUNT-NO                 
              DISPLAY '** 7230:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 26710000
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                 26740000
      ******************************************************************27090000
      *  7250-CK-FOR-WO-ARRANG                                         *27100000
      ******************************************************************27110088
       7250-CK-FOR-WO-ARRANG.                                           
      *                                                                 27130000
           EXEC SQL                                                     
              SELECT                                                    
                   'Y'                                                  
               INTO                                                     
                  :WS-WO-ARRANG-ACCT1-FLAG                              
              FROM CSS_WO_ARRANGEMENT WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :WS-FR-ACCOUNT-NO                      
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27140000
MFA-TR*       SELECT                                                    27150000
MFA-TR*            'Y'                                                  27160000
MFA-TR*        INTO                                                     27170000
MFA-TR*           :WS-WO-ARRANG-ACCT1-FLAG                              27180000
MFA-TR*       FROM CSS_WO_ARRANGEMENT                                   27190000
MFA-TR*       WHERE ACCOUNT_NO = :WS-FR-ACCOUNT-NO                      27200000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    27210000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27220000
           MOVE 'N' TO WS-WO-ARRANG-ACCT1-FLAG.                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              OR WS-ACTIVE-RETURN-CODE EQUAL -811                       
               IF WS-ACTIVE-RETURN-CODE EQUAL -811                      
                   MOVE 'Y' TO WS-WO-ARRANG-ACCT1-FLAG                  
               END-IF                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_WO_ARRANGEMENT                     '      
              DISPLAY '** ACCOUNT NO = ' WS-FR-ACCOUNT-NO               
              DISPLAY '** 7250:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 27350000
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27380000
      ******************************************************************27390000
      *  7260-CK-FOR-AUTO-XFER-EXEMP-FL                                *27400000
      ******************************************************************27410088
       7260-CK-FOR-AUTO-XFER-EXEMP-FL.                                  
      *                                                                 27430000
           EXEC SQL                                                     
              SELECT                                                    
                  ACCOUNT_NO                                            
               INTO                                                     
                  :YP-ACCOUNT-NO                                        
              FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
                AND ATTRIBUTE_DESC = 'AUTOXFERFBWOEXEMPT'               
                AND ATTRIBUTE_VALUE_CD = 'YES  '                        
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27440000
MFA-TR*       SELECT                                                    27450000
MFA-TR*           ACCOUNT_NO                                            27460000
MFA-TR*        INTO                                                     27470000
MFA-TR*           :YP-ACCOUNT-NO                                        27480000
MFA-TR*       FROM CSS_ACCT_ATTRIBUTE                                   27490000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         27500000
MFA-TR*         AND ATTRIBUTE_DESC = 'AUTOXFERFBWOEXEMPT'               27510000
MFA-TR*         AND ATTRIBUTE_VALUE_CD = 'YES  '                        27520000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    27530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27540000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                   MOVE 'Y' TO WS-AUTO-XFER-EXEMP-FL                    
               ELSE                                                     
                   MOVE 'N' TO WS-AUTO-XFER-EXEMP-FL                    
               END-IF                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_ACCT_ATTRIBUTE                     '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7260:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 27670000
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27700000
      ******************************************************************27710000
      *  7280-CK-FOR-RECONNECT-ROW.                                    *27720000
      ******************************************************************27730088
       7280-CK-FOR-RECONNECT-ROW.                                       
      *                                                                 27750000
           EXEC SQL                                                     
              SELECT                                                    
                   'Y'                                                  
               INTO                                                     
                  :WS-RECONNECT-ROW-EXISTS                              
              FROM CSS_RECONNECT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     27760000
MFA-TR*       SELECT                                                    27770000
MFA-TR*            'Y'                                                  27780000
MFA-TR*        INTO                                                     27790000
MFA-TR*           :WS-RECONNECT-ROW-EXISTS                              27800000
MFA-TR*       FROM CSS_RECONNECT                                        27810000
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         27820000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    27830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27840000
           MOVE 'N' TO WS-RECONNECT-ROW-EXISTS.                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              OR WS-ACTIVE-RETURN-CODE EQUAL -811                       
               IF WS-ACTIVE-RETURN-CODE EQUAL -811                      
                   MOVE 'Y' TO WS-RECONNECT-ROW-EXISTS                  
               END-IF                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_RECONNECT                          '      
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7280:   RETURN CODE ERROR        '            
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 27970000
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28000002
      ******************************************************************28010000
      *  7447-SELECT-ACTIVE-SURETY-BOND.                               *28020000
      ******************************************************************28030000
       7447-SELECT-ACTIVE-SURETY-BOND.                                  
      *                                                                 28050088
           EXEC SQL                                                     
               SELECT  'Y'                                              
                   INTO :WS-ACT-SURETY-EITHER-FLAG                      
               FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO  = :SB-ACCOUNT-NO                       
                 AND CODE_STATUS = 'A'                                  
                 AND CODE_BOND_TYPE = 'A'                               
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28060000
MFA-TR*        SELECT  'Y'                                              28070000
MFA-TR*            INTO :WS-ACT-SURETY-EITHER-FLAG                      28080000
MFA-TR*        FROM CSS_SURETY_BOND                                     28090000
MFA-TR*        WHERE ACCOUNT_NO  = :SB-ACCOUNT-NO                       28100000
MFA-TR*          AND CODE_STATUS = 'A'                                  28110000
MFA-TR*          AND CODE_BOND_TYPE = 'A'                               28120000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    28130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28140000
           MOVE 'N' TO WS-ACT-SURETY-EITHER-FLAG.                       
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              OR WS-ACTIVE-RETURN-CODE EQUAL -811                       
               IF WS-ACTIVE-RETURN-CODE EQUAL -811                      
                   MOVE 'Y' TO WS-ACT-SURETY-EITHER-FLAG                
               END-IF                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** SURETY BOND TABLE                 '           
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7447 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 28270000
       7447-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28300000
      ******************************************************************28310000
      *  7448-SELECT-ACTIVE-IRLOC                                      *28320000
      ******************************************************************28330000
       7448-SELECT-ACTIVE-IRLOC.                                        
      *                                                                 28350000
           EXEC SQL                                                     
               SELECT  'Y'                                              
                   INTO :WS-ACT-IRLOC-EITHER-FLAG                       
               FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                       
               WHERE ACCOUNT_NO  = :SB-ACCOUNT-NO                       
                 AND CODE_STATUS = 'A'                                  
                 AND CODE_BOND_TYPE = 'B'                               
C35227                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     28360000
MFA-TR*        SELECT  'Y'                                              28370000
MFA-TR*            INTO :WS-ACT-IRLOC-EITHER-FLAG                       28380000
MFA-TR*        FROM CSS_SURETY_BOND                                     28390000
MFA-TR*        WHERE ACCOUNT_NO  = :SB-ACCOUNT-NO                       28400000
MFA-TR*          AND CODE_STATUS = 'A'                                  28410000
MFA-TR*          AND CODE_BOND_TYPE = 'B'                               28420000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    28430000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 28440000
           MOVE 'N' TO WS-ACT-IRLOC-EITHER-FLAG.                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              OR WS-ACTIVE-RETURN-CODE EQUAL -811                       
               IF WS-ACTIVE-RETURN-CODE EQUAL -811                      
                   MOVE 'Y' TO WS-ACT-IRLOC-EITHER-FLAG                 
               END-IF                                                   
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** SURETY BOND TABLE                 '           
              DISPLAY '** ACCOUNT NO = ' AT-ACCOUNT-NO                  
              DISPLAY '** 7448 : RETURN CODE ERROR - SELECT '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                 28570000
       7448-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29010000
      ******************************************************************29020000
      *  7600-START-FCSJC01                                            *29030000
      ******************************************************************29040000
T30169     EXEC SQL                                                     29050000
T30169         INCLUDE CPD00038                                         29060000
T30169     END-EXEC.                                                    29070000
      ******************************************************************29080000
      *  7620-START-FCSCA00                                            *29090000
      ******************************************************************29100000
           EXEC SQL                                                     29110000
               INCLUDE CPD00039                                         29120000
           END-EXEC.                                                    29130000
      *                                                                 29140000
      ******************************************************************29150020
      *      8200-UPD-LAST-RUN-DATE                                    *29160040
      ******************************************************************29170080
       8200-UPD-LAST-RUN-DATE.                                          
      *                                                                 29190088
           EXEC SQL                                                     
               UPDATE                                                   
                  CSS_JOB_PARM                                          
               SET                                                      
                  PARM_DATA           = :G6-PARM-DATA                   
               WHERE                                                    
                    PROGRAM_NAME      = :G6-PROGRAM-NAME                
               AND  CMND_CODE         = :G6-CMND-CODE                   
               AND  COMPANY_NO        = :G6-COMPANY-NO                  
               AND  SEQ_NO            = :G6-SEQ-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 29310088
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               NEXT SENTENCE                                            
           ELSE                                                         
              DISPLAY '******************************************'      
              DISPLAY '** CSS_JOB_PARM TABLE                '           
              DISPLAY '** 8200 : RETURN CODE ERROR - UPDATE '           
              DISPLAY '**      :  RC = ' WS-ACTIVE-RETURN-CODE          
              DISPLAY '******************************************'      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29440000
      ******************************************************************29440200
      *                                                                *29440300
      *      8600-CALL-SCSCB068.                                       *29440400
      *                                                                *29440500
      ******************************************************************29440600
      *                                                                 29440700
       8600-CALL-SCSCB068.                                              
      *                                                                 29440900
           MOVE SPACES                     TO  ABEND-FUNCTION           
           MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM   
           CALL SCSCB068  USING   CWS00068-FIELDS,                      
                                  WS-CODES-DATA-PRESENT,                
                                  DCLCSS-ACCOUNT,                       
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE                        
           IF ABEND-FUNCTION  > SPACES                                  
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29442200
      ******************************************************            29450000
       8700-WRITE-FCSFA08.                                              
      *                                                                 29470000
           WRITE FIOFA08.                                               
T18437     ADD 1 TO WS-FFA08-REC-CNTR.                                  
       8700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************            29530000
       8702-WRITE-FCSRP032.                                             
      *                                                                 29550000
           PERFORM 1305-ASSIGN-MATCH-CODE THRU 1305-EXIT.               
           IF E-FRP032-KEY-BREC = LOW-VALUES OR HIGH-VALUES             
               NEXT SENTENCE                                            
           ELSE                                                         
               ADD 1                 TO WS-FRP032-SEQ-NO                
               MOVE WS-FRP032-SEQ-NO TO E-FRP032-SEQ-NO                 
           END-IF.                                                      
           MOVE FIORP032 TO WS-HOLD-FIORP032.                           
           WRITE FIORP032.                                              
           MOVE WS-HOLD-FIORP032 TO FIORP032.                           
           MOVE 'N' TO WS-FINISH.                                       
T18437     ADD 1 TO WS-FRP032-REC-CNTR.                                 
       8702-EXIT.                                                       
           EXIT.                                                        
      *                                                                 29630000
      ******************************************************            29640000
       9000-TERMINATE.                                                  
      *                                                                 29660000
           CLOSE FCSFA08-FILE.                                          
           IF FFA08-SUCCESSFUL                                          
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA032 PROCESSING ERROR   **'           
               DISPLAY '**   FCSFA08-FILE WILL NOT CLOSE  **'           
T18437         DISPLAY '**      PARA - 9000-TERMINATE     **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
T18437         PERFORM 9600-PROCESS-ABEND THRU 9600-EXIT                
           END-IF.                                                      
      *                                                                 29880000
           CLOSE FCSRP032-FILE.                                         
           IF FRP032-SUCCESSFUL                                         
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '**    PCSCA032 PROCESSING ERROR   **'           
               DISPLAY '**   FCSRP032-FILE WILL NOT CLOSE **'           
T18437         DISPLAY '**      PARA - 9000-TERMINATE     **'           
               DISPLAY '**      PROCESSING TERMINATED     **'           
T18437         PERFORM 9600-PROCESS-ABEND THRU 9600-EXIT                
           END-IF.                                                      
      *                                                                 30180000
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 30210002
T18437******************************************************************30520088
T18437*   9600-PROCESS-ABEND                                           *30530088
T18437*                                                                *30540088
T18437*        THIS ROUTINE IS EXECUTED ONLY FROM 9000-TERMINATE WHEN  *30550088
T18437*   AN ERROR CONDITION OCCURS.  SINCE 9000-TERMINATE IS          *30560088
T18437*   EXECUTED FROM 9700-PROCESS-ABEND, THIS PARAGRAPH WAS SETUP   *30570088
T18437*   TO AVOID LOOP.                                               *30580088
T18437******************************************************************30590088
T18437*                                                                 30600088
T18437 9600-PROCESS-ABEND.                                              
T18437*                                                                 30620088
T18437     MOVE '9600'                   TO ACTIVE-PARAGRAPH.           
T18437     MOVE RS-RETURN-CODE           TO RS-RETURN-CODE-DISP.        
T18437*                                                                 30650088
T18437     DISPLAY '*********************************************'      
T18437     DISPLAY '** COMPONENT ABEND   ' ABEND-PROGRAM                
T18437     DISPLAY '** DB2 RETURN CODE   ' RS-RETURN-CODE-DISP          
T18437     DISPLAY '** ABEND FUNCTION    ' ABEND-FUNCTION               
T18437     DISPLAY '** TABLE 1           ' TABLE-1                      
T18437     DISPLAY '** TABLE ELEMENT 1   ' TABLE-ELEMENT-1              
T18437     DISPLAY '** HOSTVAR ELEMENT 1 ' HOSTVAR-ELEMENT-1            
T18437     DISPLAY '** TABLE 2           ' TABLE-2                      
T18437     DISPLAY '** TABLE ELEMENT 2   ' TABLE-ELEMENT-2              
T18437     DISPLAY '** HOSTVAR ELEMENT 2 ' HOSTVAR-ELEMENT-2            
T18437     DISPLAY '** TABLE 3           ' TABLE-3                      
T18437     DISPLAY '** TABLE ELEMENT 3   ' TABLE-ELEMENT-3              
T18437     DISPLAY '** HOSTVAR ELEMENT 3 ' HOSTVAR-ELEMENT-3            
T18437     DISPLAY '** TABLE 4           ' TABLE-4                      
T18437     DISPLAY '** TABLE ELEMENT 4   ' TABLE-ELEMENT-4              
T18437     DISPLAY '** HOSTVAR ELEMENT 4 ' HOSTVAR-ELEMENT-4            
T18437     DISPLAY '*********************************************'      
T18437     DISPLAY 'PERFORMING 9900-ABEND'.                             
T18437                                                                  
SCA003     EXEC SQL
SCA003         ROLLBACK
SCA003     END-EXEC.                                                

SCA003     CALL "MFASQLCA"
SCA003       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
SCA003       BY REFERENCE MFSQLMESSAGETEXT
SCA003     END-CALL

T18437                                                                  
T18437     MOVE 12  TO  RETURN-CODE.                                    
T18437     MOVE 'YES' TO WS-ABEND-SWITCH.                               
T18437*                                                                 30920088
T18437 9600-EXIT.                                                       
T18437      IF WS-ABEND-YES                                             
T18437          STOP RUN
            END-IF.                                               
      *                                                                 30960002
      ******************************************************************30970003
TP5109*  9700-PROCESS-ABEND.                                           *30980004
      ******************************************************************30990005
PCR361     EXEC SQL                                                     31000006
PCR361         INCLUDE CPD0023B                                         31010007
PCR361     END-EXEC.                                                    31020008
      *                                                                 31030088
      ******************************************************************31040000
      * CPD09900   THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE       *31050000
      * 9900-ABEND                                                     *31060088
      ******************************************************************31070000
           EXEC SQL                                                     31080000
               INCLUDE CPD09900                                         31090001
           END-EXEC.                                                    31100000
