       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PCSCA018.                                            
       AUTHOR. RS7M249.                                                 
       DATE-WRITTEN. 07 MAY 2015.                                       
       DATE-COMPILED.                                                   
      ******************************************************************00050000
      *                 SOUTH CAROLINA ELECTRIC & GAS                  *00060000
      *                                                                *00070000
      ******************************************************************00080000
      *                 CUSTOMER INFORMATION SYSTEM                    *00090000
      ******************************************************************00100000
      *                       PROGRAM SUMMARY                          *00110000
      *                                                                *00120000
      *    PURPOSE:  CREATE CUSTOMERS CONTRACT AND ACCOUNT INFORMATION *00130000
      *                                                                *00140000
      *    1.THIS PROGRAM RUNS ALMOST EVERY DAY.                       *00150000
      *    2.SELECTS ALL SERVICE CARE AND HOME SECURITY CUSTOMERS      *00160000
      *      DETAILS FROM CIS.                                         *00161032
      *    3.ONE OUTPUT FILE CONTRACT / ACCOUNT  IS CREATED.           *00170073
      *    4.OUTPUT FILES ARE UPLOADED TO USER FOLDER.                 *00190000
      ******************************************************************00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                PROGRAM  MODIFICATION  LOG                      *00230000
      *                                                                *00240000
      *       DATE       INITIALS         REASON                       *00250000
      *     ----------   --------         ---------------------------  *00260000
      *     05/07/2015   RS7M249          INITIALLY CODED.             *00270076
      ******************************************************************00380000
                                                                        
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
                                                                        
       SOURCE-COMPUTER.    IBM-4341.                                    
       OBJECT-COMPUTER.    IBM-4341.                                    
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
                                                                        
           SELECT FCSRP018-FILE ASSIGN TO UT-S-FCSRP018                 
              FILE STATUS IS WS-FCS018-STATUS.                          
                                                                        
       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
                                                                        
       FD  FCSRP018-FILE                                                
           BLOCK CONTAINS  0 RECORDS                                    
           RECORD CONTAINS 250 CHARACTERS                               
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       01 FCSRP018-RECORD             PIC X(250).                       
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA018'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                    PIC X(40)  VALUE                  
           'WORKING STORAGE FOR PCSCA018 STARTS HERE'.                  
                                                                        
       01 WS-LITERALS.                                                  
          05 WS-PROGRAM               PIC X(08)  VALUE 'PCSCA018'.      
          05 WS-YES                   PIC X(01)  VALUE 'Y'.             
                                                                        
       01 WS-DATE.                                                      
          05 WS-BILL-FREQ.                                              
             10 WS-FREQ-CD            PIC X(01)  VALUE SPACES.          
             10 WS-FREQ-MM            PIC X(02)  VALUE SPACES.          
          05 WS-START-DATE.                                             
             10 WS-START-CC           PIC 9(02)  VALUE 0.               
             10 WS-START-YY           PIC 9(02)  VALUE 0.               
             10 FILLER                PIC X(01)  VALUE '-'.             
             10 WS-START-MM           PIC 9(02)  VALUE 0.               
             10 FILLER                PIC X(01)  VALUE '-'.             
             10 WS-START-DD           PIC 9(02)  VALUE 0.               
          05 WS-TEMP-YY               PIC 9(02)  VALUE 0.               
          05 WS-TEMP-MM               PIC 9(02)  VALUE 0.               
          05 WS-END-DATE.                                               
             10 WS-END-MM             PIC X(02)  VALUE SPACES.          
             10 WS-END-YY             PIC X(02)  VALUE SPACES.          
          05 WS-MM-INT                PIC 9(02)  VALUE 0.               
                                                                        
       01 WS-AMOUNT.                                                    
          05 WS-LATE-FEE              PIC 9(05)V9(2) VALUE 0.           
COB305    05 WS-SUM-POSTED        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.      
COB305    05 WS-BILL-MO        PIC S9(4) USAGE COMP-3 VALUE 0.      
          05 WS-NO-SCHED-PYMTS        PIC 9(04)  VALUE 0.               
          05 WS-CNT-NAME-CD           PIC 9(04)  VALUE 0.               
COB305    05 WS-AMT-AR-DAY-00        PIC S9(5)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305    05 WS-AMT-AR-DAY-30        PIC S9(5)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305    05 WS-AMT-AR-DAY-60        PIC S9(5)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305    05 WS-AMT-AR-DAY-90        PIC S9(5)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
COB305    05 WS-TOT-SUMM-UNBILLED        PIC S9(5)V9(2) USAGE COMP-3 
COB305       VALUE 0.      
                                                                        
       01 WS-SWITCHES.                                                  
          05  WS-NO-MORE-RECORDS      PIC X(01)  VALUE 'N'.             
              88 NO-MORE-RECORDS                 VALUE 'Y'.             
          05  WS-FCS018-STATUS        PIC X(02)  VALUE SPACES.          
              88  P018-SUCCESSFUL                VALUE '00'.            
                                                                        
       01 WS-FILRP.                                                     
          05 O-ACCOUNT-NO             PIC 9(13)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-CUSTOMER-NO            PIC 9(10)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-CODE-ACCT-STAT         PIC X(01)  VALUE SPACES.          
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-DATE-BILL-DAY-00       PIC 9(10)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-BILL-CYCLE             PIC 9(02)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-ACCT-XFER-TO           PIC 9(13)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-ACCT-XFER-FROM-LST     PIC 9(13)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-CNT-ITEM-ID            PIC 9(09)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-DATE-CONTRACT          PIC 9(10)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-CNT-STATUS-CD          PIC X(01)  VALUE SPACES.          
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-CNT-NAME-CD            PIC 9(04)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-CNT-NAME-DESC          PIC X(30)  VALUE SPACES.          
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-AMT-ORIG-ENTERED       PIC 9(05)V9(2) VALUE 0.           
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-DATE-PYMT-START        PIC 9(10)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-NO-SCHED-PYMTS         PIC 9(04)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-END-DATE               PIC 9(04)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-BILL-MONTHS            PIC 9(04)  VALUE 0.               
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-AMT-AR-DAY-00          PIC 9(05)V9(2) VALUE 0.           
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-AMT-AR-DAY-30          PIC 9(05)V9(2) VALUE 0.           
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-AMT-AR-DAY-60          PIC 9(05)V9(2) VALUE 0.           
          05 FILLER                   PIC X(01)  VALUE ','.             
          05 O-AMT-AR-DAY-90          PIC 9(05)V9(2) VALUE 0.           
          05 FILLER                   PIC X(05)  VALUE ',    '.         
          05 O-LATE-FEE               PIC 9(05)V9(2) VALUE 0.           
          05 FILLER                   PIC X(01)  VALUE ','.             
                                                                        
      ***************************************************************** 01140000
      *  COPYBOOK WITH COMMON SQL VARIABLES                           * 01150000
      ***************************************************************** 01160000
         COPY CWS00303.                                                 01170031
                                                                        
      ***************************************************************** 01220000
      *  CWS00010  CONTAINS DB2 ABEND VARIABLES                       * 01230000
      ***************************************************************** 01240000
         COPY CWS00010.                                                 01250031
                                                                        
      ***************************************************************** 01260000
      * WORKING STORAGE FOR CPD09900                                  * 01270000
      ***************************************************************** 01280000
         COPY CWS09900.                                                 01290032
                                                                        
      ***************************************************************** 01990000
      * SQL COMMUNICATION AREA                                        * 02000000
      ***************************************************************** 02010000
           EXEC SQL                                                     02020032
              INCLUDE SQLCA                                             02030032
           END-EXEC.                                                    02040032
                                                                        
      ***************************************************************** 02060074
      * CSS_AR_CNTL,        AC                                        * 02070075
      ***************************************************************** 02080074
           EXEC SQL                                                     02090074
              INCLUDE TBARCNTL                                          02100074
           END-EXEC.                                                    02101074
                                                                        
      ***************************************************************** 02103074
      * CSS_AR_TRANS_HIST,  AR                                        * 02104075
      ***************************************************************** 02105074
           EXEC SQL                                                     02106074
              INCLUDE TBARHIST                                          02107074
           END-EXEC.                                                    02108074
                                                                        
      ***************************************************************** 02109174
      * CSS_ACCOUNT,        AT                                        * 02109275
      ***************************************************************** 02109374
           EXEC SQL                                                     02109474
              INCLUDE TBACCT                                            02109574
           END-EXEC.                                                    02109674
                                                                        
      ***************************************************************** 02109874
      * CSS_AR_TRN_HST_DET, AU                                        * 02109975
      ***************************************************************** 02110074
           EXEC SQL                                                     02110174
              INCLUDE TBARHDT                                           02110274
           END-EXEC.                                                    02110374
                                                                        
      ***************************************************************** 02111000
      * CSS_CONTRACT,       CT                                        * 02120075
      ***************************************************************** 02130000
           EXEC SQL                                                     02140032
              INCLUDE TBCNTRCT                                          02150032
           END-EXEC.                                                    02160032
                                                                        
      ***************************************************************** 02230000
      * CSS_CNT_DETAIL,     EA                                        * 02240075
      ***************************************************************** 02250000
           EXEC SQL                                                     02260032
              INCLUDE TBCNTDET                                          02270032
           END-EXEC.                                                    02280032
                                                                        
      ***************************************************************** 02300000
      * CSS_CONTRACT_INFO,  K6                                        * 02310075
      ***************************************************************** 02320000
           EXEC SQL                                                     02330032
              INCLUDE TBCNTINF                                          02340032
           END-EXEC.                                                    02350032
                                                                        
      ***************************************************************** 03141100
      * CURSOR FOR SERVICE CARE                                       * 03141273
      ***************************************************************** 03141300
           EXEC SQL                                                     
              DECLARE SRVCARE_CSR CURSOR FOR                            
                 SELECT AT.ACCOUNT_NO                                   
                       ,AT.CUSTOMER_NO                                  
                       ,AT.CODE_ACCT_STAT                               
                       ,AT.DATE_BILL_DAY_00                             
                       ,AT.CODE_BILL_FREQ                               
                       ,AT.BILL_CYCLE                                   
                       ,AT.ACCT_XFER_TO                                 
                       ,AT.ACCT_XFER_FROM_LST                           
                       ,CT.PYMT_PRIORITY_LVL                            
                       ,CT.CNT_ITEM_ID                                  
                       ,CT.DATE_CONTRACT                                
                       ,CT.DATE_PYMT_START                              
                       ,CT.NO_SCHED_PYMTS                               
                       ,CT.AMT_ORIG_ENTERED                             
                       ,CT.CNT_STATUS_CD                                
                       ,CT.CNT_NAME_CD                                  
                       ,K6.CNT_NAME_DESC                                
                       ,EA.CHARGE_AM                                    
                   FROM CSS_CONTRACT      CT WITH(READUNCOMMITTED)              
                       ,CSS_ACCOUNT       AT WITH(READUNCOMMITTED)              
                       ,CSS_CNT_DETAIL    EA WITH(READUNCOMMITTED)              
                       ,CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)              
                  WHERE CT.CODE_CONTRACT_TYPE = 'F'                     
                    AND AT.ACCOUNT_NO         = CT.ACCOUNT_NO           
                    AND EA.ACCOUNT_NO         = CT.ACCOUNT_NO           
                    AND EA.CNT_ITEM_ID        = CT.CNT_ITEM_ID          
                    AND K6.CNT_NAME_CD        = CT.CNT_NAME_CD          
               ORDER BY AT.ACCOUNT_NO                                   
                       ,CT.CNT_NAME_CD                                  
                       ,CT.CNT_ITEM_ID                                  
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03141400
MFA-TR*       DECLARE SRVCARE_CSR CURSOR FOR                            03141526
MFA-TR*          SELECT AT.ACCOUNT_NO                                   03141631
MFA-TR*                ,AT.CUSTOMER_NO                                  03141731
MFA-TR*                ,AT.CODE_ACCT_STAT                               03141831
MFA-TR*                ,AT.DATE_BILL_DAY_00                             03141931
MFA-TR*                ,AT.CODE_BILL_FREQ                               03142031
MFA-TR*                ,AT.BILL_CYCLE                                   03142131
MFA-TR*                ,AT.ACCT_XFER_TO                                 03142231
MFA-TR*                ,AT.ACCT_XFER_FROM_LST                           03142331
MFA-TR*                ,CT.PYMT_PRIORITY_LVL                            03142431
MFA-TR*                ,CT.CNT_ITEM_ID                                  03142531
MFA-TR*                ,CT.DATE_CONTRACT                                03142631
MFA-TR*                ,CT.DATE_PYMT_START                              03142831
MFA-TR*                ,CT.NO_SCHED_PYMTS                               03142931
MFA-TR*                ,CT.AMT_ORIG_ENTERED                             03143031
MFA-TR*                ,CT.CNT_STATUS_CD                                03143131
MFA-TR*                ,CT.CNT_NAME_CD                                  03143231
MFA-TR*                ,K6.CNT_NAME_DESC                                03143331
MFA-TR*                ,EA.CHARGE_AM                                    03143431
MFA-TR*            FROM CSS_CONTRACT      CT                            03143537
MFA-TR*                ,CSS_ACCOUNT       AT                            03143637
MFA-TR*                ,CSS_CNT_DETAIL    EA                            03143737
MFA-TR*                ,CSS_CONTRACT_INFO K6                            03143831
MFA-TR*           WHERE CT.CODE_CONTRACT_TYPE = 'F'                     03143931
MFA-TR*             AND AT.ACCOUNT_NO         = CT.ACCOUNT_NO           03144031
MFA-TR*             AND EA.ACCOUNT_NO         = CT.ACCOUNT_NO           03144131
MFA-TR*             AND EA.CNT_ITEM_ID        = CT.CNT_ITEM_ID          03144231
MFA-TR*             AND K6.CNT_NAME_CD        = CT.CNT_NAME_CD          03144331
MFA-TR*        ORDER BY AT.ACCOUNT_NO                                   03144431
MFA-TR*                ,CT.CNT_NAME_CD                                  03144531
MFA-TR*                ,CT.CNT_ITEM_ID                                  03144631
MFA-TR*        FOR FETCH ONLY WITH UR                                   03144731
MFA-TR*         QUERYNO 7000                                            03144873
MFA-TR*    END-EXEC.                                                    03144900
                                                                        
       PROCEDURE DIVISION.                                              
                                                                        
      ***************************************************************** 03221073
      *  0000-MAINLINE.                                               * 03222073
      *       CONTROLS THE MAIN PROCESS OF PROGRAM                    * 03223073
      ***************************************************************** 03224073
                                                                        
             PERFORM 0100-INITIALIZATION-PARA THRU  0100-EXIT.          
             PERFORM 2000-PROCESS-ACC         THRU  2000-EXIT.          
             PERFORM 9000-TERMINATE           THRU  9000-EXIT.          
                                                                        
             STOP RUN.                                                  
                                                                        
      ******************************************************************03350000
      *  0100-INTIALZATION-PARA.                                       *03360000
      *       OPEN FILES - GET REPORT FROM DATABASE                    *03361073
      ******************************************************************03370000
          0100-INITIALIZATION-PARA.                                     
                                                                        
             OPEN OUTPUT FCSRP018-FILE.                                 
                                                                        
             IF P018-SUCCESSFUL                                         
                CONTINUE                                                
             ELSE                                                       
                DISPLAY '**   PCSRP018 PROCESSING ERROR       **'       
                DISPLAY '** ERROR ON FCSRP018 OUTPUT FILE     **'       
                DISPLAY '**      FILE STATUS = ' WS-FCS018-STATUS       
                PERFORM 9900-ABEND                THRU 9900-EXIT        
             END-IF.                                                    
                                                                        
          0100-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************03460000
      *  2000-PROCESS-ACC.                                             *03470073
      ******************************************************************03480000
          2000-PROCESS-ACC.                                             
                                                                        
             PERFORM 7000-OPEN-SRVCARE-CSR    THRU  7000-EXIT.          
             PERFORM 7100-FETCH-SRVCARE-CSR   THRU  7100-EXIT.          
             PERFORM 2100-PROCESS-SRVCARE-CSR THRU  2100-EXIT           
                                              UNTIL NO-MORE-RECORDS.    
             PERFORM 7200-CLOSE-SRVCARE-CSR   THRU  7200-EXIT.          
                                                                        
          2000-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************03800003
      *  2100-PROCESS-SRVCARE-CSR.                                     *03844002
      ******************************************************************03850000
          2100-PROCESS-SRVCARE-CSR.                                     
                                                                        
             MOVE CT-NO-SCHED-PYMTS         TO WS-NO-SCHED-PYMTS.       
             MOVE CT-CNT-NAME-CD            TO WS-CNT-NAME-CD.          
             MOVE AT-CODE-BILL-FREQ         TO WS-BILL-FREQ.            
             MOVE CT-DATE-PYMT-START        TO WS-START-DATE.           
                                                                        
             PERFORM 2150-GET-PYMT-END-DATE   THRU  2150-EXIT.          
             PERFORM 2200-GET-BILL-MONTH      THRU  2200-EXIT.          
             PERFORM 2250-GET-ARREAR          THRU  2250-EXIT.          
             PERFORM 2300-GET-LATE-FEE        THRU  2300-EXIT.          
             PERFORM 2350-MOVE-RPT-DATA       THRU  2350-EXIT.          
             PERFORM 8000-WRITE-REPORT        THRU  8000-EXIT.          
             PERFORM 7100-FETCH-SRVCARE-CSR   THRU  7100-EXIT.          
                                                                        
          2100-EXIT.                                                    
             EXIT.                                                      
                                                                        
      ******************************************************************04040003
      *  2150-GET-PYMT-END-DATE.                                       *04050031
      *       CHECK FOR THE FREQUENCY CODE AND FIND THE END DATE       *04051073
      ******************************************************************04060003
          2150-GET-PYMT-END-DATE.                                       
                                                                        
             IF WS-NO-SCHED-PYMTS <= 0                                  
                MOVE SPACES                 TO WS-END-DATE              
                GO TO 2150-EXIT                                         
             END-IF.                                                    
             EVALUATE WS-FREQ-CD                                        
                WHEN 'M'                                                
                   MOVE 1                   TO WS-MM-INT                
                WHEN 'B'                                                
                   MOVE 2                   TO WS-MM-INT                
                WHEN 'Q'                                                
                   MOVE 3                   TO WS-MM-INT                
                WHEN 'S'                                                
                   MOVE 6                   TO WS-MM-INT                
                WHEN 'A'                                                
                   MOVE 12                  TO WS-MM-INT                
             END-EVALUATE                                               
                                                                        
             MOVE WS-START-YY               TO WS-TEMP-YY               
                                                                        
             COMPUTE WS-TEMP-MM = ((WS-NO-SCHED-PYMTS - 1)*WS-MM-INT)   
                                     + WS-START-MM                      
                                                                        
             PERFORM UNTIL WS-TEMP-MM <= 12                             
                COMPUTE WS-TEMP-YY = WS-TEMP-YY + 1                     
                COMPUTE WS-TEMP-MM = WS-TEMP-MM - 12                    
             END-PERFORM                                                
                                                                        
             MOVE WS-TEMP-MM                TO WS-END-MM                
             MOVE WS-TEMP-YY                TO WS-END-YY                
                                                                        
             IF WS-FREQ-CD = 'N'                                        
                MOVE SPACES                 TO WS-END-DATE              
             END-IF.                                                    
                                                                        
          2150-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************05782003
      *  2200-GET-BILL-MONTH                                           *05783003
      *       CHECK FOR THE CONTRACT NAME CODE AND GET THE BILL MONTH  *05783173
      ******************************************************************05784003
          2200-GET-BILL-MONTH.                                          
                                                                        
             IF WS-CNT-NAME-CD >= 600 OR WS-CNT-NAME-CD <= 699          
                PERFORM 7300-SELECT-BILLMTH   THRU 7300-EXIT            
             END-IF.                                                    
                                                                        
          2200-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************05788403
      *  2250-GET-ARREAR                                               *05788573
      *       GET THE AMOUNT BILLED OR UNPAID                          *05788673
      ******************************************************************05788703
          2250-GET-ARREAR.                                              
                                                                        
             PERFORM 7400-SELECT-ARREAR       THRU  7400-EXIT.          
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                MOVE AC-AMT-AR-DAY-00       TO WS-AMT-AR-DAY-00         
                MOVE AC-AMT-AR-DAY-30       TO WS-AMT-AR-DAY-30         
                MOVE AC-AMT-AR-DAY-60       TO WS-AMT-AR-DAY-60         
                MOVE AC-AMT-AR-DAY-90       TO WS-AMT-AR-DAY-90         
                MOVE AC-TOT-SUMM-UNBILLED   TO WS-TOT-SUMM-UNBILLED     
             ELSE                                                       
                MOVE 0                      TO WS-AMT-AR-DAY-00         
                                               WS-AMT-AR-DAY-30         
                                               WS-AMT-AR-DAY-60         
                                               WS-AMT-AR-DAY-90         
                                               WS-TOT-SUMM-UNBILLED     
             END-IF.                                                    
                                                                        
          2250-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************05791203
      *  2300-GET-LATE-FEE.                                            *05791303
      *       GET THE LATE FEE BASED ON THE AMOUNT                     *05791473
      ******************************************************************05791503
          2300-GET-LATE-FEE.                                            
                                                                        
             PERFORM 7500-SELECT-LATEFEE      THRU  7500-EXIT.          
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                MOVE AC-AMT-AR-DAY-00       TO WS-LATE-FEE              
             ELSE                                                       
                MOVE 0                      TO WS-LATE-FEE              
             END-IF.                                                    
                                                                        
          2300-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************05792803
      *  2350-MOVE-RPT-DATA.                                           *05792973
      ******************************************************************05793003
          2350-MOVE-RPT-DATA.                                           
                                                                        
             MOVE  AT-ACCOUNT-NO            TO O-ACCOUNT-NO.            
             MOVE  AT-CUSTOMER-NO           TO O-CUSTOMER-NO.           
             MOVE  AT-CODE-ACCT-STAT        TO O-CODE-ACCT-STAT.        
             MOVE  AT-DATE-BILL-DAY-00      TO O-DATE-BILL-DAY-00.      
             MOVE  AT-BILL-CYCLE            TO O-BILL-CYCLE.            
             MOVE  AT-ACCT-XFER-TO          TO O-ACCT-XFER-TO.          
             MOVE  AT-ACCT-XFER-FROM-LST    TO O-ACCT-XFER-FROM-LST.    
             MOVE  CT-CNT-ITEM-ID           TO O-CNT-ITEM-ID.           
             MOVE  CT-DATE-CONTRACT         TO O-DATE-CONTRACT.         
             MOVE  CT-CNT-STATUS-CD         TO O-CNT-STATUS-CD.         
             MOVE  CT-CNT-NAME-CD           TO O-CNT-NAME-CD.           
             MOVE  K6-CNT-NAME-DESC         TO O-CNT-NAME-DESC.         
             MOVE  EA-CHARGE-AM             TO O-AMT-ORIG-ENTERED.      
             MOVE  CT-DATE-PYMT-START       TO O-DATE-PYMT-START.       
             MOVE  CT-NO-SCHED-PYMTS        TO O-NO-SCHED-PYMTS.        
             MOVE  WS-END-DATE              TO O-END-DATE.              
             MOVE  WS-BILL-MO               TO O-BILL-MONTHS.           
             MOVE  WS-AMT-AR-DAY-00         TO O-AMT-AR-DAY-00.         
             MOVE  WS-AMT-AR-DAY-30         TO O-AMT-AR-DAY-30.         
             MOVE  WS-AMT-AR-DAY-60         TO O-AMT-AR-DAY-60.         
             MOVE  WS-AMT-AR-DAY-90         TO O-AMT-AR-DAY-90.         
             MOVE  WS-LATE-FEE              TO O-LATE-FEE.              
                                                                        
          2350-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************05796826
      *  7000-OPEN-SRVCARE-CSR                                         *05797002
      ******************************************************************05800000
          7000-OPEN-SRVCARE-CSR.                                        
                                                                        
             EXEC SQL                                                   
                OPEN SRVCARE_CSR                                        
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA018 ABORT *****************'     
              DISPLAY '*        7000-OPEN-SRVCARE-CSR            *'     
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                     *'     
              DISPLAY '********** PCSCA018 ABORT *****************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
          7000-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************06020000
      *  7100-FETCH-SRVCARE-CSR                                        *06030002
      ******************************************************************06040000
          7100-FETCH-SRVCARE-CSR.                                       
                                                                        
             EXEC SQL                                                   
                FETCH SRVCARE_CSR                                       
                 INTO :AT-ACCOUNT-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-CODE-ACCT-STAT                                
                     ,:AT-DATE-BILL-DAY-00                              
                     ,:AT-CODE-BILL-FREQ                                
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-ACCT-XFER-TO                                  
                     ,:AT-ACCT-XFER-FROM-LST                            
                     ,:CT-PYMT-PRIORITY-LVL                             
                     ,:CT-CNT-ITEM-ID                                   
                     ,:CT-DATE-CONTRACT                                 
                     ,:CT-DATE-PYMT-START                               
                     ,:CT-NO-SCHED-PYMTS                                
                     ,:CT-AMT-ORIG-ENTERED                              
                     ,:CT-CNT-STATUS-CD                                 
                     ,:CT-CNT-NAME-CD                                   
                     ,:K6-CNT-NAME-DESC                                 
                     ,:EA-CHARGE-AM                                     
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL OR NOT-FOUND
              IF WS-ACTIVE-RETURN-CODE   EQUAL NOT-FOUND                
                 MOVE WS-YES                TO WS-NO-MORE-RECORDS       
              END-IF                                                    
           ELSE                                                         
              DISPLAY '********** PCSCA018 ABORT *****************'     
              DISPLAY '*       7100-FETCH-SRVCARE-CSR            *'     
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                     *'     
              DISPLAY '********** PCSCA018 ABORT *****************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
          7100-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************06370000
      *  7200-CLOSE-SRVCARE-CSR                                        *06380002
      ******************************************************************06390000
          7200-CLOSE-SRVCARE-CSR.                                       
                                                                        
             EXEC SQL                                                   
                CLOSE SRVCARE_CSR                                       
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA018 ABORT *****************'     
              DISPLAY '*       7200-CLOSE-SRVCARE-CSR            *'     
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '* PROGRAM ABORTING...                     *'     
              DISPLAY '********** PCSCA018  ABORT ****************'     
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
          7200-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************06601031
      *  7300-SELECT-BILLMTH                                           *06601131
      ******************************************************************06601231
          7300-SELECT-BILLMTH.                                          
                                                                        
             EXEC SQL                                                   
                SELECT CT.AMT_MO_PYMT                                   
                      ,COUNT(*)                                         
                      ,SUM(AU.AMT_POSTED)                               
                  INTO :CT-AMT-MO-PYMT                                  
                      ,:WS-BILL-MO                                      
                      ,:WS-SUM-POSTED                                   
                  FROM CSS_CONTRACT       CT                            
                      ,CSS_AR_TRANS_HIST  AR                            
                      ,CSS_AR_TRN_HST_DET AU                            
                 WHERE CT.ACCOUNT_NO              =:AT-ACCOUNT-NO       
                   AND CT.CNT_NAME_CD             =:CT-CNT-NAME-CD      
                   AND CT.CNT_ITEM_ID             =:CT-CNT-ITEM-ID      
                   AND CT.CNT_STATUS_CD IN ('A','B')                    
                   AND CT.CNT_NAME_CD BETWEEN 600 AND 699               
                   AND AR.ACCOUNT_NO              =CT.ACCOUNT_NO        
                   AND AR.CODE_TRAN_TYPE          ='B'                  
                   AND CAST(AR.TRANS_HIST_SEQ_NO AS DATE)>= 
           CT.DATE_CONTRACT    
                   AND AU.ACCOUNT_NO              =AR.ACCOUNT_NO        
                   AND AR.TRANS_HIST_SEQ_NO       =AU.TRANS_HIST_SEQ_NO 
                   AND AU.ITEM_ID                 =CT.CNT_ITEM_ID       
              GROUP BY CT.ACCOUNT_NO                                    
                      ,CT.PYMT_PRIORITY_LVL                             
                      ,CT.CNT_ITEM_ID                                   
                      ,CT.AMT_MO_PYMT                                   
                      ,CT.CNT_STATUS_CD                                 
                      ,CT.CNT_NAME_CD                                   
              ORDER BY CT.ACCOUNT_NO                                    
                      ,CT.CNT_ITEM_ID                                   
                                                            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*      EXEC SQL                                                   06601531
MFA-TR*         SELECT CT.AMT_MO_PYMT                                   06601631
MFA-TR*               ,COUNT(*)                                         06601739
MFA-TR*               ,SUM(AU.AMT_POSTED)                               06601831
MFA-TR*           INTO :CT-AMT-MO-PYMT                                  06601931
MFA-TR*               ,:WS-BILL-MO                                      06602039
MFA-TR*               ,:WS-SUM-POSTED                                   06602131
MFA-TR*           FROM CSS_CONTRACT       CT                            06602237
MFA-TR*               ,CSS_AR_TRANS_HIST  AR                            06602337
MFA-TR*               ,CSS_AR_TRN_HST_DET AU                            06602431
MFA-TR*          WHERE CT.ACCOUNT_NO              =:AT-ACCOUNT-NO       06602531
MFA-TR*            AND CT.CNT_NAME_CD             =:CT-CNT-NAME-CD      06602631
MFA-TR*            AND CT.CNT_ITEM_ID             =:CT-CNT-ITEM-ID      06602731
MFA-TR*            AND CT.CNT_STATUS_CD IN ('A','B')                    06602831
MFA-TR*            AND CT.CNT_NAME_CD BETWEEN 600 AND 699               06602931
MFA-TR*            AND AR.ACCOUNT_NO              =CT.ACCOUNT_NO        06603031
MFA-TR*            AND AR.CODE_TRAN_TYPE          ='B'                  06603131
MFA-TR*            AND DATE(AR.TRANS_HIST_SEQ_NO)>= CT.DATE_CONTRACT    06603231
MFA-TR*            AND AU.ACCOUNT_NO              =AR.ACCOUNT_NO        06603331
MFA-TR*            AND AR.TRANS_HIST_SEQ_NO       =AU.TRANS_HIST_SEQ_NO 06603431
MFA-TR*            AND AU.ITEM_ID                 =CT.CNT_ITEM_ID       06603531
MFA-TR*       GROUP BY CT.ACCOUNT_NO                                    06603631
MFA-TR*               ,CT.PYMT_PRIORITY_LVL                             06603731
MFA-TR*               ,CT.CNT_ITEM_ID                                   06603831
MFA-TR*               ,CT.AMT_MO_PYMT                                   06603931
MFA-TR*               ,CT.CNT_STATUS_CD                                 06604031
MFA-TR*               ,CT.CNT_NAME_CD                                   06604131
MFA-TR*       ORDER BY CT.ACCOUNT_NO                                    06604231
MFA-TR*               ,CT.CNT_ITEM_ID                                   06604331
MFA-TR*        QUERYNO 7300                                             06604474
MFA-TR*      END-EXEC.                                                  06604531

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA018 ABORT ******************'    
              DISPLAY '*        7300-SELECT-BILLMTH               *'    
              DISPLAY '* SQLCODE          : ' WS-ACTIVE-RETURN-CODE     
              DISPLAY '* ACCOUNT NO       : ' AT-ACCOUNT-NO             
              DISPLAY '* CNT NAME CD      : ' CT-CNT-NAME-CD            
              DISPLAY '* CNT ITEM ID      : ' CT-CNT-ITEM-ID            
              DISPLAY '* PROGRAM ABORTING...                      *'    
              DISPLAY '********** PCSCA018  ABORT *****************'    
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
        7300-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************06606500
      *  7400-SELECT-ARREAR                                            *06606631
      ******************************************************************06606700
         7400-SELECT-ARREAR.                                            
                                                                        
            EXEC SQL                                                    
               SELECT AC.AMT_AR_DAY_00                                  
                     ,AC.AMT_AR_DAY_30                                  
                     ,AC.AMT_AR_DAY_60                                  
                     ,AC.AMT_AR_DAY_90                                  
                     ,AC.TOT_SUMM_UNBILLED                              
                 INTO :AC-AMT-AR-DAY-00                                 
                     ,:AC-AMT-AR-DAY-30                                 
                     ,:AC-AMT-AR-DAY-60                                 
                     ,:AC-AMT-AR-DAY-90                                 
                     ,:AC-TOT-SUMM-UNBILLED                             
                 FROM CSS_AR_CNTL   AC                                  
                WHERE AC.ACCOUNT_NO        = :AT-ACCOUNT-NO             
                  AND AC.ITEM_ID           = :CT-CNT-ITEM-ID            
                  AND AC.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL      
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*     EXEC SQL                                                    06609631
MFA-TR*        SELECT AC.AMT_AR_DAY_00                                  06609831
MFA-TR*              ,AC.AMT_AR_DAY_30                                  06609931
MFA-TR*              ,AC.AMT_AR_DAY_60                                  06610031
MFA-TR*              ,AC.AMT_AR_DAY_90                                  06610131
MFA-TR*              ,AC.TOT_SUMM_UNBILLED                              06610231
MFA-TR*          INTO :AC-AMT-AR-DAY-00                                 06610331
MFA-TR*              ,:AC-AMT-AR-DAY-30                                 06610431
MFA-TR*              ,:AC-AMT-AR-DAY-60                                 06610531
MFA-TR*              ,:AC-AMT-AR-DAY-90                                 06610631
MFA-TR*              ,:AC-TOT-SUMM-UNBILLED                             06610731
MFA-TR*          FROM CSS_AR_CNTL   AC                                  06611037
MFA-TR*         WHERE AC.ACCOUNT_NO        = :AT-ACCOUNT-NO             06611131
MFA-TR*           AND AC.ITEM_ID           = :CT-CNT-ITEM-ID            06611231
MFA-TR*           AND AC.PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL      06611331
MFA-TR*       QUERYNO 7400                                              06611474
MFA-TR*     END-EXEC.                                                   06611631

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL OR NOT-FOUND
             CONTINUE                                                   
           ELSE                                                         
             DISPLAY '********** PCSCA018 ABORT ***********************'
             DISPLAY '*       7400-SELECT-ARREAR                     *' 
             DISPLAY '* SQLCODE             : ' WS-ACTIVE-RETURN-CODE   
             DISPLAY '* ACCOUNT NO          : ' AT-ACCOUNT-NO           
             DISPLAY '* ITEM  ID            : ' CT-CNT-ITEM-ID          
             DISPLAY '* PYMT PRIOIRTY LVL   : ' CT-PYMT-PRIORITY-LVL    
             DISPLAY '* PROGRAM ABORTING...                          *' 
             DISPLAY '********** PCSCA018  ABORT *********************' 
                                                                        
             PERFORM 9900-ABEND               THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
         7400-EXIT.                                                     
            EXIT.                                                       
      ***************************************************************   06635900
      *  7500-SELECT-LATEFEE                                        *   06636029
      ***************************************************************   06636100
          7500-SELECT-LATEFEE.                                          
                                                                        
             EXEC SQL                                                   
                SELECT AC.PYMT_PRIORITY_LVL                             
                      ,AC.ITEM_ID                                       
                      ,(AC.AMT_AR_DAY_00 + AC.AMT_AR_DAY_30 +           
                        AC.AMT_AR_DAY_60 + AC.AMT_AR_DAY_90 )           
                  INTO :AC-PYMT-PRIORITY-LVL                            
                      ,:AC-ITEM-ID                                      
                      ,:AC-AMT-AR-DAY-00                                
                  FROM CSS_AR_CNTL AC                                   
                 WHERE AC.ACCOUNT_NO          = :AT-ACCOUNT-NO          
                   AND AC.PYMT_PRIORITY_LVL   = 39                      
                                                            
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*      EXEC SQL                                                   06636428
MFA-TR*         SELECT AC.PYMT_PRIORITY_LVL                             06636528
MFA-TR*               ,AC.ITEM_ID                                       06636631
MFA-TR*               ,(AC.AMT_AR_DAY_00 + AC.AMT_AR_DAY_30 +           06636767
MFA-TR*                 AC.AMT_AR_DAY_60 + AC.AMT_AR_DAY_90 )           06636867
MFA-TR*           INTO :AC-PYMT-PRIORITY-LVL                            06637131
MFA-TR*               ,:AC-ITEM-ID                                      06637231
MFA-TR*               ,:AC-AMT-AR-DAY-00                                06637331
MFA-TR*           FROM CSS_AR_CNTL AC                                   06637731
MFA-TR*          WHERE AC.ACCOUNT_NO          = :AT-ACCOUNT-NO          06637831
MFA-TR*            AND AC.PYMT_PRIORITY_LVL   = 39                      06637931
MFA-TR*        QUERYNO 7500                                             06638074
MFA-TR*      END-EXEC.                                                  06638128

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA018 ABORT **********************'
              DISPLAY '*       7500-SELECT-LATEFEE                    *'
              DISPLAY '* SQLCODE             : ' WS-ACTIVE-RETURN-CODE  
              DISPLAY '* ACCOUNT NO          : ' AT-ACCOUNT-NO          
              DISPLAY '* PROGRAM ABORTING...                          *'
              DISPLAY '********** PCSCA018  ABORT *********************'
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
          7500-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************06640200
      * 8000-WRITE-REPORT                                              *06640337
      ******************************************************************06640400
          8000-WRITE-REPORT.                                            
                                                                        
             WRITE  FCSRP018-RECORD   FROM  WS-FILRP.                   
                                                                        
             INITIALIZE WS-FILRP.                                       
             INITIALIZE WS-DATE.                                        
             INITIALIZE WS-AMOUNT.                                      
                                                                        
             IF P018-SUCCESSFUL                                         
                CONTINUE                                                
             ELSE                                                       
                DISPLAY '**        PCSRP018 PROCESSING ERROR       **'  
                DISPLAY '** CLOSE ERROR FOR FCSRP018 - OUTPUT FILE **'  
                DISPLAY '**      FILE STATUS = ' WS-FCS018-STATUS       
             END-IF.                                                    
                                                                        
          8000-EXIT.                                                    
             EXIT.                                                      
      ******************************************************************06770000
      *  9000-TERMINATE                                                *06780000
      ******************************************************************06790000
          9000-TERMINATE.                                               
                                                                        
             CLOSE FCSRP018-FILE.                                       
                                                                        
             IF P018-SUCCESSFUL                                         
                CONTINUE                                                
             ELSE                                                       
                DISPLAY '**        PCSRP018 PROCESSING ERROR       **'  
                DISPLAY '** CLOSE ERROR FOR FCSRP018 - OUTPUT FILE **'  
                DISPLAY '**      FILE STATUS = ' WS-FCS018-STATUS       
             END-IF.                                                    
                                                                        
          9000-EXIT.                                                    
             EXIT.                                                      
      ***************************************************************** 06870000
      * 9100-DISPLAY-ERROR.                                           * 06880000
      ***************************************************************** 06900000
          9100-DISPLAY-ERROR.                                           
             DISPLAY '**   PROCESSING ERROR IN PCSCA018  **'.           
             DISPLAY '**   ABENDING PROGRAM              **'.           
             PERFORM 9900-ABEND               THRU 9900-EXIT.           
                                                                        
          9100-EXIT.                                                    
             EXIT.                                                      
      ***************************************************************** 06982100
      * 9900-PROCESS-ABEND                                            * 06982200
      ***************************************************************** 06983000
           EXEC SQL                                                     06984032
              INCLUDE CPD09900                                          06985032
           END-EXEC.                                                    06986032
