       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA015.                                      
COB303 DATE-WRITTEN.     APR 23, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  04/21/2015    VK7L032     ACTIVITY #001.CONVERTED THE EZT --*        
      *--                            PGM CSR015 TO COBOL.            --*        
A05268*--  08/14/2015    MR7E794     CONVERTED THE EZT PGM CSR050 TO --*        
A05268*--                ACT014      COBOL.                          --*        
A05136*--  09/07/2015    MR7E794     MOVED LOGIC TO GENERATE WQS FROM--*        
A05136*--                ACT193      PROGRAM PCSCA314(WQ - 557) AND  --*        
A05136*--                ACT194      PROGRAM PCSCA197(WQ - 558).     --*        
A05136*--  10/09/2015    MR7E794     MOVED LOGIC TO GENERATE WQS FROM--*        
A05136*--                ACT195      PROGRAM PCSCA130(WQ - 556).     --*        
      *----------------------------------------------------------------*        
      *                                                                *        
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA015'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_ACCOUNT, AT                                          *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_CUST_PREM_HIST, CH                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_WQ_ITEMS, WQ                                         *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_OFF_CYCL_ACCT, OC                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFCYL                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_UTIL_ENVRNMT, UT                                     *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_RATE_PLAN_DESC, RD                                   *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
ACT014***************************************************************           
ACT014*    CSS_AR_CNTL, AC                                          *           
ACT014***************************************************************           
ACT014*                                                                         
ACT014     EXEC SQL                                                             
ACT014        INCLUDE TBARCNTL                                                  
ACT014     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_JOB_PARM, G6                                         *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBJBPARM                                                 
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_CUSTOMER, CU                                         *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBCUST                                                   
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_NAME, DQ                                             *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBNAME                                                   
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_COMPANY, C7                                          *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBCOMPNY                                                 
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_NAME_ACCT_XREF, HT                                   *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBNMACTX                                                 
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_CUST_ADDR_XREF, DM                                   *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBCSADRX                                                 
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_ADDR_FREEFORM, DZ                                    *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBADRFRE                                                 
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_ADDR_FORMATTED,DY                                    *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBADRFMT                                                 
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_ZIP_CODE, A4                                         *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBZIPCD                                                  
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193***************************************************************           
ACT193*    CSS_ACCT_MISC_INFO, TA                                   *           
ACT193***************************************************************           
ACT193     EXEC SQL                                                             
ACT193         INCLUDE TBATMISC                                                 
ACT193     END-EXEC.                                                            
ACT195*                                                                         
ACT195***************************************************************           
ACT195*    CSS_REFUND  - RN                                         *           
ACT195***************************************************************           
ACT195     EXEC SQL                                                             
ACT195        INCLUDE TBREFUND                                                  
ACT195     END-EXEC.                                                            
ACT195                                                                  
      ***************************************************************           
      * FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077       *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
                INCLUDE CWS00077                                                
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *                                                             *           
       COPY CWS09900.                                                           
      *                                                             *           
       COPY CWS00303.                                                           
      *                                                                         
       COPY CWS00010.                                                           
ACT193*COPY CWS00104                                                            
ACT193 COPY FIOCA00.                                                            
ACT193 COPY FIOJC01.                                                            
ACT193 COPY CWS00011.                                                           
ACT193 COPY CWS00038.                                                           
ACT193 COPY CWS00039.                                                           
ACT193 COPY CWS00041.                                                           
ACT193 COPY CWS00074.                                                           
      *                                                             *           
      ***************************************************************           
ACT193*                                                                         
ACT193 01  WS-RPC-RETURN-CODES.                                         
ACT193     05  RS-RETURN-CODE          PIC S9(04) COMP.                 
ACT193     05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
ACT193     05  WS-DISP-RETURN-CODE     PIC +Z(04).                      
ACT193*                                                                         
ACT193 01  WS-DATE-10.                                                  
ACT193     05  WS-D10-CC               PIC X(02).                       
ACT193     05  WS-D10-YY               PIC X(02).                       
ACT193     05  FILLER                  PIC X(01)    VALUE '-'.          
ACT193     05  WS-D10-MM               PIC X(02).                       
ACT193     05  FILLER                  PIC X(01)    VALUE '-'.          
ACT193     05  WS-D10-DD               PIC X(02).                       
      *                                                                         
ACT194 01  WS-FORMAT-DATE.                                              
ACT194     05  WS-FMT-MM               PIC X(02).                       
ACT194     05  FILLER                  PIC X(01)    VALUE '/'.          
ACT194     05  WS-FMT-DD               PIC X(02).                       
ACT194     05  FILLER                  PIC X(01)    VALUE '/'.          
ACT194     05  WS-FMT-CC               PIC X(02).                       
ACT194     05  WS-FMT-YY               PIC X(02).                       
ACT195*                                                                         
ACT195     05  WS-OPT-DATA-VALUE-C           PIC X(40).                 
ACT195     05  WS-OPT-DATA-VALUE-N REDEFINES WS-OPT-DATA-VALUE-C.       
ACT195         10  WS-OPT-DATA-FILLER        PIC X(28).                 
ACT195         10  WS-OPT-DATA-INTEGER       PIC ZZZZZZZZ9.99.          
ACT195*                                                                         
ACT195 01  WS-RESP-AREA-ID              PIC X(03).                      
ACT195 01  WS-ROUTING-CATEGORY          PIC X(02).                      
ACT194*                                                                         
       01 WS-LITERALS.                                                  
ACT193     05 WS-PGRMNAME               PIC X(08) VALUE 'PCSCA015'.     
ACT193     05 PROGRAM-NAME              PIC X(08) VALUE 'PCSCA015'.     
           05 WS-COMMENTS               PIC X(49) VALUE                 
            'ACCOUNT IN FINAL BILL STATUS BUT NOT FINAL BILLED'.        
           05  SCSCB077                 PIC X(08) VALUE 'SCSCB077'.     
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
ACT193 01 WS-REC-TYPE.                                                  
ACT193     05  WS-NSC                  PIC X(03)     VALUE 'NSC'.       
ACT193     05  WS-NSA                  PIC X(03)     VALUE 'NSA'.       
ACT193     05  WS-NSN                  PIC X(03)     VALUE 'NSN'.       
ACT193     05  WS-LPC                  PIC X(03)     VALUE 'LPC'.       
ACT193     05  WS-LPN                  PIC X(03)     VALUE 'LPN'.       
ACT193     05  WS-UTE                  PIC X(03)     VALUE 'UTE'.       
ACT193     05  WS-UTG                  PIC X(03)     VALUE 'UTG'.       
ACT193     05  WS-UTW                  PIC X(03)     VALUE 'UTW'.       
ACT193     05  WS-EPP                  PIC X(03)     VALUE 'EPP'.       
ACT193     05  WS-RCC                  PIC X(03)     VALUE 'RCC'.       
ACT193     05  WS-DEP                  PIC X(03)     VALUE 'DEP'.       
ACT193     05  WS-DFA                  PIC X(03)     VALUE 'DFA'.       
ACT193     05  WS-CNT                  PIC X(03)     VALUE 'CNT'.       
ACT193     05  WS-RVC                  PIC X(03)     VALUE 'RVC'.       
ACT193     05  WS-PJS                  PIC X(03)     VALUE 'PJS'.       
ACT193     05  WS-ADJ                  PIC X(03)     VALUE 'ADJ'.       
ACT193     05  WS-N                    PIC X(01)     VALUE 'N'.         
ACT193     05  WS-Y                    PIC X(01)     VALUE 'Y'.         
ACT193     05  WS-A-STAT-314           PIC X(10)     VALUE              
ACT193                                 'ACTIVE    '.                    
ACT193     05  WS-B-STAT-314           PIC X(10)     VALUE              
ACT193                                 'FINAL BILL'.                    
ACT193     05  WS-J-STAT-314           PIC X(10)     VALUE              
ACT193                                 'INACTIVE  '.                    
ACT193     05  WS-S-STAT-314           PIC X(10)     VALUE              
ACT193                                 'WRITE OFF '.                    
ACT193     05  WS-P-STAT-314           PIC X(10)     VALUE              
ACT193                                 'PENDING   '.                    
ACT014     05 WS-WQ-COMMENTS.                                           
ACT014        10 WS-WQ-COMMENTS-1       PIC X(01) VALUE '$'.            
ACT014        10 WS-WQ-COMMENTS-2       PIC X(13) VALUE SPACES.         
ACT014        10 WS-WQ-COMMENTS-3       PIC X(01) VALUE ' '.            
ACT014        10 WS-WQ-COMMENTS-4       PIC X(53) VALUE                 
ACT014        'LIHEAP MONEY PRESENT.RESEARCH AND TRANSFER AS NEEDED.'.  
ACT014        10 WS-WQ-COMMENTS-7       PIC X(177) VALUE SPACES.        
      *                                                                         
ACT193     05  WS-WQ-COMMENTS-CRDRECV.                                  
ACT193         10  WS-WQ-RPT1-COMP-NAME PIC X(26).                      
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-CUSTOMER-NAME  PIC X(24).                      
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-ACCT-STATUS    PIC X(10).                      
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-ACCT-XFER-TO   PIC X(13).                      
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-ACCT-XFER-FROM PIC X(13)    VALUE SPACES.      
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-REC-TYPE-CRDRCV PIC X(03).                     
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-00-DAY-MONEY   PIC ----,---,--9.99.            
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-30-DAY-MONEY   PIC ----,---,--9.99.            
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-60-DAY-MONEY   PIC ----,---,--9.99.            
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-90-DAY-MONEY   PIC ----,---,--9.99.            
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-LAST-ACT-DT    PIC X(10).                      
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-CREDIT-AMOUNT  PIC ----,---,--9.99.            
ACT193         10  FILLER               PIC X(01)     VALUE ','.        
ACT193         10  WS-WQ-REASON         PIC X(32)     VALUE             
ACT193                            'ACCOUNTS WITH CREDIT RECEIVABLES'.   
ACT194 01  WS-WQ-COMMENTS-RECVBAL.                                      
ACT194     05  WS-WQ-COMP-NAME         PIC X(26).                       
ACT194     05  FILLER                  PIC X(01)    VALUE ','.          
ACT194     05  WS-WQ-CUSTOMER-NM       PIC X(41).                       
ACT194     05  FILLER                  PIC X(01)    VALUE ','.          
ACT194     05  WS-WQ-REC-TYPE-RCVBAL   PIC X(03).                       
ACT194     05  FILLER                  PIC X(01)    VALUE ','.          
ACT194     05  WS-WQ-AMT-TRAN-BALANCE  PIC --,---,---,-99.99.           
ACT194     05  FILLER                  PIC X(01)    VALUE ','.          
ACT194     05  WS-WQ-ACCT-FINALED-DT   PIC X(10).                       
ACT194     05  FILLER                  PIC X(01)    VALUE ','.          
ACT194     05  WS-WQ-LAST-PYMT-DATE    PIC X(10).                       
ACT194     05  FILLER                  PIC X(01)    VALUE ','.          
ACT194     05  WS-WQ-LAST-PYMT-AMOUNT  PIC -,---,---,-99.99.            
ACT194     05  FILLER                  PIC X(01)    VALUE ','.          
ACT194     05  WS-WQ-ACCT-BALANCE      PIC --,---,---,-99.99.           
ACT194     05  FILLER                  PIC X(01)    VALUE ','.          
ACT194     05  WS-WQ-MESSAGE           PIC X(51) VALUE                  
ACT194            'FINALLED ACCOUNTS WITH A RECEIVABLES CREDIT BALANCE'.
ACT194*                                                                         
ACT193 01  WS-PROGRAM-SWITCHES.                                         
ACT193     05  WS-COMPANY-CHANGE-SW    PIC X(01)     VALUE 'Y'.         
ACT193         88  COMPANY-CHANGED                   VALUE 'Y'.         
           05  WS-TERMINATE-CALL-SW    PIC X(01)     VALUE 'N'.         
               88  CALL-FROM-TERMINATE               VALUE 'Y'.         
       01 WS-MISC.                                                      
           05 WS-DATE-SVC-END-NULL      PIC S9(04) COMP VALUE 0.        
           05 WS-COMPANY-NO             PIC X(02) VALUE SPACES.         
ACT014     05 WS-ACCOUNT-NO             PIC X(13) VALUE SPACES.         
           05 WS-SECURED-RATE-FLAG      PIC X(01) VALUE SPACES.         
           05 WS-CURRENT-DATE           PIC X(10) VALUE SPACES.         
ACT014     05 WS-AMT-UNUSED-CR    PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.  
ACT014     05 WS-AMT-UNUSED-CR-N        PIC S9(9)V9(2) VALUE 0.         
ACT014     05 WS-AMT-UNUSED-CR-NUM      PIC 9(9).99.                    
           05  WS-INPUT-TS.                                             
               10 WS-INPUT-DATE-PT      PIC X(10).                      
               10 WS-INPUT-TIME-PT      PIC X(16)      VALUE            
                                                     '-00.00.00.000000'.
ACT193     05  WS-NULL-IND             PIC S9(04) COMP VALUE 0.         
ACT193     05  WS-SYSIN-COMP-NO        PIC X(02)  VALUE SPACES.         
ACT193     05  WS-COMPANY-NO-HOLD      PIC X(02)  VALUE SPACES.         
ACT193     05  WS-DEFAULT-COMPANY-NO   PIC X(02)  VALUE '01'.           
ACT193     05  WS-CURR-DATE-PLUS1      PIC X(10)  VALUE SPACES.         
ACT194     05  WS-LAST-PYMT-DATE-NI        PIC S9(04) COMP VALUE 0.     
ACT193     05  WS-WQ-REC-TYPE          PIC X(03)  VALUE SPACES.         
ACT193*                                                                         
ACT193 01  WS-CURR-TS.                                                  
ACT193     05  WS-CURR-DATE-TS              PIC X(10).                  
ACT193     05  WS-CURR-TS-REF               PIC X(16)                   
ACT193                               VALUE '-00.00.00.000000'.          
      *                                                                         
      ******************************************************************        
      * THIS IS THE DRIVING CURSOR OF THIS PROGRAM FETCHING DETAILS    *        
      * BY USING THE COMPANY NO                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE DTLS_CSR CURSOR FOR                               
                 SELECT AT.ACCOUNT_NO                                   
                       ,AT.COMPANY_NO                                   
                       ,AT.TOTAL_AR_BALANCE                             
                       ,AT.DATE_BILL_DAY_00                             
                       ,AT.MST_SUB_ACCT_IND                             
                       ,CH.DATE_UTIL_SVC_END                            
                   FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
                       ,CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED)             
                  WHERE AT.ACCOUNT_NO = CH.ACCOUNT_NO                   
                    AND AT.ACCT_FINALED_DT IS NULL                      
                    AND AT.CODE_ACCT_STAT = 'B'                         
                    AND NOT EXISTS                                      
                      (SELECT 'Y'                                       
                         FROM CSS_WQ_ITEMS  WF WITH(READUNCOMMITTED)            
                        WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO            
                          AND WF.CATEGORY_ID = 134                      
                          AND WF.STATUS      IN ('A', 'I'))             
                    AND NOT EXISTS                                      
                      (SELECT 'Y'                                       
                         FROM CSS_OFF_CYCL_ACCT OC WITH(READUNCOMMITTED)        
                        WHERE OC.ACCOUNT_NO         = AT.ACCOUNT_NO     
                          AND OC.CODE_BILL_OFF_CYCL = 'B')              
                    AND NOT EXISTS                                      
                      (SELECT 'Y'                                       
                         FROM CSS_WQ_ITEMS WF WITH(READUNCOMMITTED)             
                        WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO            
                          AND WF.CATEGORY_ID = 555                      
                          AND WF.CREATED_BY  = 'PCSCA107'               
                          AND WF.STATUS      = 'A'                      
                          AND CAST(WF.DATE_CREATED AS DATE) = 
           CAST(SYSDATETIMEOFFSET() AS DATE))     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTLS_CSR CURSOR FOR                                       
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*                ,AT.TOTAL_AR_BALANCE                                     
MFA-TR*                ,AT.DATE_BILL_DAY_00                                     
MFA-TR*                ,AT.MST_SUB_ACCT_IND                                     
MFA-TR*                ,CH.DATE_UTIL_SVC_END                                    
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_CUST_PREM_HIST CH                                   
MFA-TR*           WHERE AT.ACCOUNT_NO = CH.ACCOUNT_NO                           
MFA-TR*             AND AT.ACCT_FINALED_DT IS NULL                              
MFA-TR*             AND AT.CODE_ACCT_STAT = 'B'                                 
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*               (SELECT 'Y'                                               
MFA-TR*                  FROM CSS_WQ_ITEMS  WF                                  
MFA-TR*                 WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO                    
MFA-TR*                   AND WF.CATEGORY_ID = 134                              
MFA-TR*                   AND WF.STATUS      IN ('A', 'I'))                     
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*               (SELECT 'Y'                                               
MFA-TR*                  FROM CSS_OFF_CYCL_ACCT OC                              
MFA-TR*                 WHERE OC.ACCOUNT_NO         = AT.ACCOUNT_NO             
MFA-TR*                   AND OC.CODE_BILL_OFF_CYCL = 'B')                      
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*               (SELECT 'Y'                                               
MFA-TR*                  FROM CSS_WQ_ITEMS WF                                   
MFA-TR*                 WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO                    
MFA-TR*                   AND WF.CATEGORY_ID = 555                              
MFA-TR*                   AND WF.CREATED_BY  = 'PCSCA107'                       
MFA-TR*                   AND WF.STATUS      = 'A'                              
MFA-TR*                   AND DATE(WF.DATE_CREATED) = CURRENT DATE)             
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **   CURSOR TO DETERMINE IF THE ACCOUNT IS A SECURED/NON-SECURED**        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
              DECLARE RATE_PLAN CURSOR FOR                              
                 SELECT SECURED_RATE_FL                                 
                   FROM CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)             
                       ,CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)             
                  WHERE UT.ACCOUNT_NO     = :AT-ACCOUNT-NO              
                    AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO             
                    AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RATE_PLAN CURSOR FOR                                      
MFA-TR*          SELECT SECURED_RATE_FL                                         
MFA-TR*            FROM CSS_UTIL_ENVRNMT   UT                                   
MFA-TR*                ,CSS_RATE_PLAN_DESC RD                                   
MFA-TR*           WHERE UT.ACCOUNT_NO     = :AT-ACCOUNT-NO                      
MFA-TR*             AND UT.RATE_PLAN_NO   = RD.RATE_PLAN_NO                     
MFA-TR*             AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                   
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
ACT014***************************************************************           
ACT014* CURSOR FOR RETRIEVING INACTIVE ACCOUNTS WITH CREDIT         *           
ACT014*    BALANCES                                                 *           
ACT014***************************************************************           
ACT014                                                                  
ACT014     EXEC SQL                                                     
ACT014        DECLARE INACTIVE_ACCOUNTS CURSOR FOR                      
ACT014           SELECT AT.ACCOUNT_NO                                   
ACT014                 ,AT.PREMISE_NO                                   
ACT014                 ,AT.CUSTOMER_NO                                  
ACT014                 ,AT.LOCAL_OFFICE                                 
ACT014                 ,AT.DATE_LAST_ACTION AS DATE                     
ACT014                 ,AT.TOTAL_AR_BALANCE                             
ACT014                 ,AC.AMT_UNUSED_CR                                
ACT014                 ,AT.COMPANY_NO                                   
ACT014             FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                    
ACT014                 ,CSS_AR_CNTL AC WITH(READUNCOMMITTED)                    
ACT014            WHERE AT.ACCOUNT_NO = AC.ACCOUNT_NO                   
ACT014              AND AC.PYMT_PRIORITY_LVL = 70                       
ACT014              AND AC.ITEM_ID = 2                                  
ACT014              AND AT.CODE_ACCT_STAT <> 'A'                        
ACT014              AND AT.TOTAL_AR_BALANCE < 0                         
ACT014              AND NOT EXISTS                                      
ACT014                (SELECT 'Y'                                       
ACT014                   FROM CSS_WQ_ITEMS  WF WITH(READUNCOMMITTED)            
ACT014                  WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO            
ACT014                    AND WF.CATEGORY_ID = 535                      
ACT014                    AND WF.STATUS      IN ('A', 'I'))             
ACT014            ORDER BY AT.COMPANY_NO,DATE                           
ACT014                                                           
ACT014                                                      
ACT014     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE INACTIVE_ACCOUNTS CURSOR FOR                              
MFA-TR*          SELECT AT.ACCOUNT_NO                                           
MFA-TR*                ,AT.PREMISE_NO                                           
MFA-TR*                ,AT.CUSTOMER_NO                                          
MFA-TR*                ,AT.LOCAL_OFFICE                                         
MFA-TR*                ,AT.DATE_LAST_ACTION AS DATE                             
MFA-TR*                ,AT.TOTAL_AR_BALANCE                                     
MFA-TR*                ,AC.AMT_UNUSED_CR                                        
MFA-TR*                ,AT.COMPANY_NO                                           
MFA-TR*            FROM CSS_ACCOUNT AT                                          
MFA-TR*                ,CSS_AR_CNTL AC                                          
MFA-TR*           WHERE AT.ACCOUNT_NO = AC.ACCOUNT_NO                           
MFA-TR*             AND AC.PYMT_PRIORITY_LVL = 70                               
MFA-TR*             AND AC.ITEM_ID = 2                                          
MFA-TR*             AND AT.CODE_ACCT_STAT <> 'A'                                
MFA-TR*             AND AT.TOTAL_AR_BALANCE < 0                                 
MFA-TR*             AND NOT EXISTS                                              
MFA-TR*               (SELECT 'Y'                                               
MFA-TR*                  FROM CSS_WQ_ITEMS  WF                                  
MFA-TR*                 WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO                    
MFA-TR*                   AND WF.CATEGORY_ID = 535                              
MFA-TR*                   AND WF.STATUS      IN ('A', 'I'))                     
MFA-TR*           ORDER BY AT.COMPANY_NO,DATE                                   
MFA-TR*           WITH UR                                                       
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            
ACT014*                                                                         
ACT193****************************************************************          
ACT193** THIS CURSOR LIST OUT ALL ACCOUNTS WITH A CREDIT RECEIVABLE.**          
ACT193****************************************************************          
ACT193                                                                  
ACT193     EXEC SQL                                                     
ACT193         DECLARE AT-CURSOR CURSOR FOR                             
ACT193         SELECT AT.ACCOUNT_NO,                                    
ACT193                AT.CUSTOMER_NO,                                   
ACT193                AT.CODE_ACCT_STAT,                                
ACT193                AT.BILL_CYCLE,                                    
ACT193                AT.DATE_LAST_ACTION,                              
ACT193                AT.COMPANY_NO,                                    
ACT193                AT.ADDRESS_ID,                                    
ACT193                AT.ACCT_XFER_TO,                                  
ACT193                AT.ACCT_XFER_FROM_LST,                            
ACT193                AT.LOCAL_OFFICE,                                  
ACT193                AT.PREMISE_NO,                                    
ACT193                AC.PYMT_PRIORITY_LVL,                             
ACT193                AC.AMT_UNUSED_CR                                  
ACT193          FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
ACT193                CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
ACT193         WHERE  AT.ACCOUNT_NO        = AC.ACCOUNT_NO              
ACT193           AND  AT.ACCT_FINALED_DT IS NULL                        
ACT193           AND  (( AC.AMT_UNUSED_CR     < 0                       
ACT193                OR AC.AMT_AR_DAY_00     < 0                       
ACT193                OR AC.AMT_AR_DAY_30     < 0                       
ACT193                OR AC.AMT_AR_DAY_60     < 0                       
ACT193                OR AC.AMT_AR_DAY_90     < 0                       
ACT193                OR AC.TOT_SUMM_UNBILLED < 0                       
ACT193                OR AC.AMT_TRAN_BALANCE  < 0)                      
ACT193           AND  AC.PYMT_PRIORITY_LVL <> 50                        
ACT193           AND  AC.PYMT_PRIORITY_LVL <> 60                        
ACT193           AND  AC.PYMT_PRIORITY_LVL <> 70                        
ACT193           AND  AC.PYMT_PRIORITY_LVL <> 100                       
ACT193            OR   (  AC.AMT_UNUSED_CR     < 0                      
ACT193                 OR AC.AMT_AR_DAY_00     < 0                      
ACT193                 OR AC.AMT_AR_DAY_30     < 0                      
ACT193                 OR AC.AMT_AR_DAY_60     < 0                      
ACT193                 OR AC.AMT_AR_DAY_90     < 0                      
ACT193                 OR AC.TOT_SUMM_UNBILLED < 0)                     
ACT193           AND  AC.PYMT_PRIORITY_LVL = 50)                        
ACT193           AND NOT EXISTS                                         
ACT193             (SELECT 'Y'                                          
ACT193                FROM CSS_WQ_ITEMS  WF WITH(READUNCOMMITTED)               
ACT193               WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO               
ACT193                 AND WF.CATEGORY_ID = 557                         
ACT193                 AND WF.CREATED_BY  = 'PCSCA015'                  
ACT193                 AND WF.STATUS      IN ('A', 'I'))                
ACT193         ORDER BY AT.COMPANY_NO, AT.BILL_CYCLE,                   
ACT193                  AT.ACCOUNT_NO, AC.PYMT_PRIORITY_LVL             
ACT193                                                           
ACT193                                                      
ACT193     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE AT-CURSOR CURSOR FOR                                     
MFA-TR*        SELECT AT.ACCOUNT_NO,                                            
MFA-TR*               AT.CUSTOMER_NO,                                           
MFA-TR*               AT.CODE_ACCT_STAT,                                        
MFA-TR*               AT.BILL_CYCLE,                                            
MFA-TR*               AT.DATE_LAST_ACTION,                                      
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               AT.ADDRESS_ID,                                            
MFA-TR*               AT.ACCT_XFER_TO,                                          
MFA-TR*               AT.ACCT_XFER_FROM_LST,                                    
MFA-TR*               AT.LOCAL_OFFICE,                                          
MFA-TR*               AT.PREMISE_NO,                                            
MFA-TR*               AC.PYMT_PRIORITY_LVL,                                     
MFA-TR*               AC.AMT_UNUSED_CR                                          
MFA-TR*         FROM  CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_AR_CNTL AC                                            
MFA-TR*        WHERE  AT.ACCOUNT_NO        = AC.ACCOUNT_NO                      
MFA-TR*          AND  AT.ACCT_FINALED_DT IS NULL                                
MFA-TR*          AND  (( AC.AMT_UNUSED_CR     < 0                               
MFA-TR*               OR AC.AMT_AR_DAY_00     < 0                               
MFA-TR*               OR AC.AMT_AR_DAY_30     < 0                               
MFA-TR*               OR AC.AMT_AR_DAY_60     < 0                               
MFA-TR*               OR AC.AMT_AR_DAY_90     < 0                               
MFA-TR*               OR AC.TOT_SUMM_UNBILLED < 0                               
MFA-TR*               OR AC.AMT_TRAN_BALANCE  < 0)                              
MFA-TR*          AND  AC.PYMT_PRIORITY_LVL <> 50                                
MFA-TR*          AND  AC.PYMT_PRIORITY_LVL <> 60                                
MFA-TR*          AND  AC.PYMT_PRIORITY_LVL <> 70                                
MFA-TR*          AND  AC.PYMT_PRIORITY_LVL <> 100                               
MFA-TR*           OR   (  AC.AMT_UNUSED_CR     < 0                              
MFA-TR*                OR AC.AMT_AR_DAY_00     < 0                              
MFA-TR*                OR AC.AMT_AR_DAY_30     < 0                              
MFA-TR*                OR AC.AMT_AR_DAY_60     < 0                              
MFA-TR*                OR AC.AMT_AR_DAY_90     < 0                              
MFA-TR*                OR AC.TOT_SUMM_UNBILLED < 0)                             
MFA-TR*          AND  AC.PYMT_PRIORITY_LVL = 50)                                
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*            (SELECT 'Y'                                                  
MFA-TR*               FROM CSS_WQ_ITEMS  WF                                     
MFA-TR*              WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO                       
MFA-TR*                AND WF.CATEGORY_ID = 557                                 
MFA-TR*                AND WF.CREATED_BY  = 'PCSCA015'                          
MFA-TR*                AND WF.STATUS      IN ('A', 'I'))                        
MFA-TR*        ORDER BY AT.COMPANY_NO, AT.BILL_CYCLE,                           
MFA-TR*                 AT.ACCOUNT_NO, AC.PYMT_PRIORITY_LVL                     
MFA-TR*        WITH UR                                                          
MFA-TR*       QUERYNO 7955                                                      
MFA-TR*    END-EXEC.                                                            
ACT193*                                                                         
ACT194     EXEC SQL                                                     
ACT194         DECLARE FINALED_ACCT CURSOR FOR                          
ACT194          SELECT AT.ACCOUNT_NO,                                   
ACT194                 AT.CUSTOMER_NO,                                  
ACT194                 AT.BILL_CYCLE,                                   
ACT194                 AT.COMPANY_NO,                                   
ACT194                 AT.LOCAL_OFFICE,                                 
ACT194                 AT.PREMISE_NO,                                   
ACT194                 AT.ADDRESS_ID,                                   
ACT194                 AT.TOTAL_AR_BALANCE,                             
ACT194                 REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT,                              
ACT194                 AT.LAST_PYMT_DATE,                               
ACT194                 AT.LAST_PYMT_AMOUNT,                             
ACT194                 AC.PYMT_PRIORITY_LVL,                            
ACT194                 AC.AMT_TRAN_BALANCE,                             
ACT194                 AC.AMT_UNUSED_CR                                 
ACT194            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                    
ACT194                 CSS_AR_CNTL AC WITH(READUNCOMMITTED)                     
ACT194           WHERE AT.ACCOUNT_NO = AC.ACCOUNT_NO                    
ACT194             AND AT.CODE_ACCT_STAT = 'B'                          
ACT194             AND AT.ACCT_FINALED_DT IS NOT NULL                   
ACT194             AND AC.PYMT_PRIORITY_LVL NOT IN (70)                 
ACT194             AND ((AC.ITEM_ID <> 0                                
ACT194                 AND AC.PYMT_PRIORITY_LVL >= 50                   
ACT194                 AND (  AC.AMT_TRAN_BALANCE  < 0                  
ACT194                     OR AC.AMT_UNUSED_CR     < 0                  
ACT194                     OR AC.AMT_AR_DAY_00     < 0                  
ACT194                     OR AC.AMT_AR_DAY_30     < 0                  
ACT194                     OR AC.AMT_AR_DAY_60     < 0                  
ACT194                     OR AC.AMT_AR_DAY_90     < 0                  
ACT194                     OR AC.TOT_SUMM_UNBILLED < 0))                
ACT194              OR (AC.PYMT_PRIORITY_LVL < 50                       
ACT194                 AND AC.AMT_UNUSED_CR < 0))                       
ACT194             AND NOT EXISTS                                       
ACT194                (SELECT 'Y'                                       
ACT194                   FROM CSS_WQ_ITEMS  WF WITH(READUNCOMMITTED)            
ACT194                  WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO            
ACT193                    AND WF.CREATED_BY  = 'PCSCA015'               
ACT194                    AND WF.CATEGORY_ID = 558                      
ACT194                    AND WF.STATUS      IN ('A', 'I'))             
ACT194                                                           
ACT194                                                      
ACT194     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FINALED_ACCT CURSOR FOR                                  
MFA-TR*         SELECT AT.ACCOUNT_NO,                                           
MFA-TR*                AT.CUSTOMER_NO,                                          
MFA-TR*                AT.BILL_CYCLE,                                           
MFA-TR*                AT.COMPANY_NO,                                           
MFA-TR*                AT.LOCAL_OFFICE,                                         
MFA-TR*                AT.PREMISE_NO,                                           
MFA-TR*                AT.ADDRESS_ID,                                           
MFA-TR*                AT.TOTAL_AR_BALANCE,                                     
MFA-TR*                AT.ACCT_FINALED_DT,                                      
MFA-TR*                AT.LAST_PYMT_DATE,                                       
MFA-TR*                AT.LAST_PYMT_AMOUNT,                                     
MFA-TR*                AC.PYMT_PRIORITY_LVL,                                    
MFA-TR*                AC.AMT_TRAN_BALANCE,                                     
MFA-TR*                AC.AMT_UNUSED_CR                                         
MFA-TR*           FROM CSS_ACCOUNT AT,                                          
MFA-TR*                CSS_AR_CNTL AC                                           
MFA-TR*          WHERE AT.ACCOUNT_NO = AC.ACCOUNT_NO                            
MFA-TR*            AND AT.CODE_ACCT_STAT = 'B'                                  
MFA-TR*            AND AT.ACCT_FINALED_DT IS NOT NULL                           
MFA-TR*            AND AC.PYMT_PRIORITY_LVL NOT IN (70)                         
MFA-TR*            AND ((AC.ITEM_ID <> 0                                        
MFA-TR*                AND AC.PYMT_PRIORITY_LVL >= 50                           
MFA-TR*                AND (  AC.AMT_TRAN_BALANCE  < 0                          
MFA-TR*                    OR AC.AMT_UNUSED_CR     < 0                          
MFA-TR*                    OR AC.AMT_AR_DAY_00     < 0                          
MFA-TR*                    OR AC.AMT_AR_DAY_30     < 0                          
MFA-TR*                    OR AC.AMT_AR_DAY_60     < 0                          
MFA-TR*                    OR AC.AMT_AR_DAY_90     < 0                          
MFA-TR*                    OR AC.TOT_SUMM_UNBILLED < 0))                        
MFA-TR*             OR (AC.PYMT_PRIORITY_LVL < 50                               
MFA-TR*                AND AC.AMT_UNUSED_CR < 0))                               
MFA-TR*            AND NOT EXISTS                                               
MFA-TR*               (SELECT 'Y'                                               
MFA-TR*                  FROM CSS_WQ_ITEMS  WF                                  
MFA-TR*                 WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO                    
MFA-TR*                   AND WF.CREATED_BY  = 'PCSCA015'                       
MFA-TR*                   AND WF.CATEGORY_ID = 558                              
MFA-TR*                   AND WF.STATUS      IN ('A', 'I'))                     
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7980                                                    
MFA-TR*    END-EXEC.                                                            
ACT194                                                                  
ACT195*                                                                         
ACT195*****************************************************************         
ACT195**  CURSOR DECLARATION TO SELECT ACCOUNTS.                     **         
ACT195*****************************************************************         
ACT195*                                                                         
ACT195     EXEC SQL                                                     
ACT195       DECLARE ACCT_RANGE CURSOR FOR                              
ACT195       SELECT RN.ACCOUNT_NO,                                      
ACT195              RN.REFUND_ITEM_ID,                                  
ACT195              RN.REQUEST_DT,                                      
ACT195              RN.AMT_REFUNDED,                                    
ACT195              AT.COMPANY_NO,                                      
ACT195              AT.CUSTOMER_NO,                                     
ACT195              AT.PREMISE_NO,                                      
ACT195              AT.LOCAL_OFFICE                                     
ACT195         FROM CSS_REFUND RN WITH(READUNCOMMITTED),                        
ACT195              CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
ACT195        WHERE RN.CHECK_STATUS_CD = 'R'                            
ACT195          AND RN.REQUEST_DT < (DATEADD( DAY, -1, 
           CAST(SYSDATETIMEOFFSET() AS DATE) ))              
ACT195          AND RN.ACCOUNT_NO = AT.ACCOUNT_NO                       
ACT195          AND NOT EXISTS                                          
ACT195             (SELECT 'Y'                                          
ACT195                FROM CSS_WQ_ITEMS  WF WITH(READUNCOMMITTED)               
ACT195               WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO               
ACT195                 AND WF.CREATED_BY  = 'PCSCA015'                  
ACT195                 AND WF.CATEGORY_ID = 556                         
ACT195                 AND WF.STATUS      IN ('A', 'I'))                
ACT195        ORDER BY AT.COMPANY_NO, RN.REQUEST_DT,                    
ACT195               AT.ACCOUNT_NO                                      
ACT195         FOR READ ONLY                                           
ACT195                                                           
ACT195     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ACCT_RANGE CURSOR FOR                                      
MFA-TR*      SELECT RN.ACCOUNT_NO,                                              
MFA-TR*             RN.REFUND_ITEM_ID,                                          
MFA-TR*             RN.REQUEST_DT,                                              
MFA-TR*             RN.AMT_REFUNDED,                                            
MFA-TR*             AT.COMPANY_NO,                                              
MFA-TR*             AT.CUSTOMER_NO,                                             
MFA-TR*             AT.PREMISE_NO,                                              
MFA-TR*             AT.LOCAL_OFFICE                                             
MFA-TR*        FROM CSS_REFUND RN,                                              
MFA-TR*             CSS_ACCOUNT AT                                              
MFA-TR*       WHERE RN.CHECK_STATUS_CD = 'R'                                    
MFA-TR*         AND RN.REQUEST_DT < (CURRENT DATE - 1 DAY)                      
MFA-TR*         AND RN.ACCOUNT_NO = AT.ACCOUNT_NO                               
MFA-TR*         AND NOT EXISTS                                                  
MFA-TR*            (SELECT 'Y'                                                  
MFA-TR*               FROM CSS_WQ_ITEMS  WF                                     
MFA-TR*              WHERE WF.ACCOUNT_NO  = AT.ACCOUNT_NO                       
MFA-TR*                AND WF.CREATED_BY  = 'PCSCA015'                          
MFA-TR*                AND WF.CATEGORY_ID = 556                                 
MFA-TR*                AND WF.STATUS      IN ('A', 'I'))                        
MFA-TR*       ORDER BY AT.COMPANY_NO, RN.REQUEST_DT,                            
MFA-TR*              AT.ACCOUNT_NO                                              
MFA-TR*        FOR FETCH ONLY                                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            
ACT195*                                                                         
      ******************************************************************        
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 7700-GET-CURRENT-DATE            THRU  7700-EXIT.    
           PERFORM 2000-PROCESS-DTLS                THRU  2000-EXIT.    
ACT014     PERFORM 3000-PROCESS-FINB-CRDBAL         THRU  3000-EXIT.    
ACT193     PERFORM 4005-PROCESS-ACCT-CRDRECV        THRU  4005-EXIT.    
ACT194     PERFORM 5000-PROCESS-FINBCRD-RECVBAL     THRU  5000-EXIT.    
ACT195     PERFORM 5300-PROCESS-REFUND-REQBNSNT     THRU  5300-EXIT.    
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-DTLS.                                           **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-DTLS.                                               
      *                                                                         
           PERFORM 7000-OPEN-DTLS-CSR               THRU 7000-EXIT.     
      *                                                                         
           PERFORM 7100-FETCH-DTLS-CSR              THRU 7100-EXIT.     
      *                                                                         
           PERFORM 2200-PROCESS-ACCOUNT-DTLS        THRU 2200-EXIT      
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
      *                                                                         
           PERFORM 7200-CLOSE-DTLS-CSR              THRU 7200-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2200-PROCESS-ACCOUNT-DTLS                                    **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-ACCOUNT-DTLS.                                       
      *                                                                         
           MOVE AT-COMPANY-NO             TO WS-COMPANY-NO.             
           PERFORM 2300-CHECK-SECURED-RATE          THRU 2300-EXIT.     
           PERFORM 2400-CHECK-WQ-EXISTS             THRU 2400-EXIT.     
           PERFORM 7100-FETCH-DTLS-CSR              THRU 7100-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2300-CHECK-SECURED-RATE                                      **        
      ******************************************************************        
      *                                                                         
       2300-CHECK-SECURED-RATE.                                         
      *                                                                         
           MOVE WS-NO                     TO WS-SECURED-RATE-FLAG.      
           MOVE ZEROES                    TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           PERFORM 7300-OPEN-RATE-PLAN              THRU 7300-EXIT.     
           PERFORM 7400-FETCH-RATE-PLAN             THRU 7400-EXIT      
                   UNTIL WS-SECURED-RATE-FLAG EQUAL WS-YES OR           
                         WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
           PERFORM 7500-CLOSE-RATE-PLAN             THRU 7500-EXIT.     
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2400-CHECK-WQ-EXISTS                                         **        
      ******************************************************************        
      *                                                                         
       2400-CHECK-WQ-EXISTS.                                            
      *                                                                         
ACT193     PERFORM 7550-CHECK-WQ-EXISTS             THRU 7550-EXIT      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 2500-GET-WQ-VALUES            THRU 2500-EXIT      
              PERFORM 6000-CREATE-WORK-QUEUE        THRU 6000-EXIT      
           ELSE                                                         
              DISPLAY AT-ACCOUNT-NO  '*** NOT INSERTED ***'             
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2500-GET-WQ-VALUES                                           **        
      ******************************************************************        
      *                                                                         
       2500-GET-WQ-VALUES.                                              
      *                                                                         
           INITIALIZE CWS00077-FIELDS                                   
           MOVE ZEROES                    TO WS-77-SERV-ORDER-NO.       
                                                                        
           IF WS-SECURED-RATE-FLAG = WS-YES                             
              MOVE  138                   TO WS-77-CATEGORY-ID          
           ELSE                                                         
              MOVE  13                    TO WS-77-CATEGORY-ID          
           END-IF.                                                      
                                                                        
           MOVE AT-ACCOUNT-NO             TO WS-77-ACCOUNT-NO.          
           MOVE SPACES                    TO WS-77-USER-ID-ORIG.        
           MOVE '4'                       TO WS-77-ROUTE-CATEGORY.      
           MOVE 'N'                       TO WS-77-PRIORITY.            
           MOVE WS-COMMENTS               TO WS-77-COMMENTS-TEXT.       
           MOVE 49                        TO WS-77-COMMENTS-LEN.        
ACT193     MOVE WS-PGRMNAME               TO WS-77-FREE-FORM-TXT.       
           MOVE 8                         TO WS-77-FREE-FORM-LEN.       
           MOVE ZEROES                    TO WS-77-PREMISE-NO.          
           MOVE ZEROES                    TO WS-77-CUSTOMER-NO.         
           MOVE SPACES                    TO WS-77-RESP-AREA-ID.        
           MOVE SPACES                    TO WS-77-LOCAL-OFFICE.        
           MOVE WS-CURRENT-DATE           TO WS-INPUT-DATE-PT.          
           MOVE WS-INPUT-TS               TO WS-77-DATE-CREATED.        
ACT193     MOVE WS-PGRMNAME               TO WS-77-CREATED-BY.          
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT014******************************************************************        
ACT014** 2600-GET-WQ-VALUES                                           **        
ACT014******************************************************************        
ACT014*                                                                         
ACT014 2600-GET-WQ-VALUES.                                              
ACT014*                                                                         
ACT014     INITIALIZE CWS00077-FIELDS                                   
ACT014     MOVE ZEROES                    TO WS-77-SERV-ORDER-NO.       
ACT014     MOVE  535                      TO WS-77-CATEGORY-ID.         
ACT014     MOVE AT-ACCOUNT-NO             TO WS-77-ACCOUNT-NO.          
ACT014     MOVE AT-PREMISE-NO             TO WS-77-PREMISE-NO.          
ACT014     MOVE AT-CUSTOMER-NO            TO WS-77-CUSTOMER-NO.         
ACT014     MOVE SPACES                    TO WS-77-RESP-AREA-ID.        
ACT014     MOVE AT-LOCAL-OFFICE           TO WS-77-LOCAL-OFFICE.        
ACT014     MOVE SPACES                    TO WS-77-ROUTE-CATEGORY.      
ACT014     MOVE 'N'                       TO WS-77-PRIORITY.            
ACT014     MOVE SPACES                    TO WS-77-USER-ID-ORIG.        
ACT014     MOVE WS-WQ-COMMENTS            TO WS-77-COMMENTS-TEXT.       
ACT014     MOVE 245                       TO WS-77-COMMENTS-LEN.        
ACT193     MOVE WS-PGRMNAME               TO WS-77-FREE-FORM-TXT.       
ACT014     MOVE 8                         TO WS-77-FREE-FORM-LEN.       
ACT014     MOVE WS-CURRENT-DATE           TO WS-INPUT-DATE-PT.          
ACT014     MOVE WS-INPUT-TS               TO WS-77-DATE-CREATED.        
ACT193     MOVE WS-PGRMNAME               TO WS-77-CREATED-BY.          
ACT014*                                                                         
ACT014 2600-EXIT.                                                       
ACT014     EXIT.                                                        
ACT014*                                                                         
ACT014******************************************************************        
ACT014** 3000-PROCESS-FINB-CRDBAL.                                    **        
ACT014******************************************************************        
ACT014*                                                                         
ACT014 3000-PROCESS-FINB-CRDBAL.                                        
ACT014*                                                                         
ACT014     PERFORM 7800-OPEN-INACTIVE-ACC           THRU 7800-EXIT.     
ACT014*                                                                         
ACT014     PERFORM 7900-FETCH-INACTIVE-ACC          THRU 7900-EXIT.     
ACT014*                                                                         
ACT014     PERFORM 3200-PROCESS-FINBILL-DTLS        THRU 3200-EXIT      
ACT014         UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
ACT014*                                                                         
ACT014     PERFORM 7950-CLOSE-INACTIVE-ACC          THRU 7950-EXIT.     
ACT014*                                                                         
ACT014 3000-EXIT.                                                       
ACT014     EXIT.                                                        
ACT014*                                                                         
ACT014******************************************************************        
ACT014** 3200-PROCESS-ACCOUNT-DTLS                                    **        
ACT014******************************************************************        
ACT014*                                                                         
ACT014 3200-PROCESS-FINBILL-DTLS.                                       
ACT014*                                                                         
ACT014     IF WS-COMPANY-NO NOT = AT-COMPANY-NO                         
ACT014        MOVE AT-COMPANY-NO             TO WS-COMPANY-NO           
ACT014     END-IF.                                                      
ACT014     MOVE AT-ACCOUNT-NO                TO WS-ACCOUNT-NO.          
ACT014     MOVE AC-AMT-UNUSED-CR             TO WS-AMT-UNUSED-CR.       
ACT014     MOVE WS-AMT-UNUSED-CR             TO WS-AMT-UNUSED-CR-N.     
ACT014     MOVE WS-AMT-UNUSED-CR-N           TO WS-AMT-UNUSED-CR-NUM.   
ACT014     MOVE WS-AMT-UNUSED-CR-NUM         TO WS-WQ-COMMENTS-2.       
ACT014     PERFORM 2600-GET-WQ-VALUES               THRU 2600-EXIT.     
ACT014     PERFORM 6000-CREATE-WORK-QUEUE           THRU 6000-EXIT.     
ACT014     PERFORM 7900-FETCH-INACTIVE-ACC          THRU 7900-EXIT.     
ACT014*                                                                         
ACT014 3200-EXIT.                                                       
ACT014     EXIT.                                                        
ACT014*                                                                         
ACT193******************************************************************        
ACT193** 4005-PROCESS-ACCT-CRDRECV.                                   **        
ACT193******************************************************************        
ACT193*                                                                         
ACT193 4005-PROCESS-ACCT-CRDRECV.                                       
ACT193*                                                                         
ACT193     PERFORM 4008-GET-REQUIRED-DATE           THRU 4008-EXIT.     
ACT193*                                                                         
ACT193     PERFORM 7955-OPEN-CSS-ACCOUNT            THRU 7955-EXIT.     
ACT193*                                                                         
ACT193     PERFORM 7957-FETCH-CSS-ACCOUNT           THRU 7957-EXIT.     
ACT193*                                                                         
ACT193     PERFORM 4100-PROCESS-ACCT-CRDRECV        THRU 4100-EXIT      
ACT193         UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
ACT193*                                                                         
ACT193     PERFORM 7959-CLOSE-CSS-ACCOUNT           THRU 7959-EXIT.     
ACT193*                                                                         
ACT193 4005-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193** 4008-GET-REQUIRED-DATE                                     **          
ACT193****************************************************************          
ACT193 4008-GET-REQUIRED-DATE.                                          
ACT193*                                                                         
ACT193     INITIALIZE CWS00077-FIELDS.                                  
ACT193*                                                                         
ACT193     PERFORM 7953-GET-CURR-DATE-PLUS1      THRU 7953-EXIT.        
ACT193     MOVE WS-CURR-DATE-PLUS1       TO WS-CURR-DATE-TS.            
ACT193*                                                                         
ACT193     ACCEPT WS-SYSIN-COMP-NO FROM SYSIN.                          
ACT193*                                                                         
ACT193 4008-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193** 4100-PROCESS-ACCT-CRDRECV                                  **          
ACT193****************************************************************          
ACT193 4100-PROCESS-ACCT-CRDRECV.                                       
ACT193*                                                                         
ACT193     PERFORM 4110-FORMAT-WORK-QUEUE        THRU 4110-EXIT.        
ACT193*                                                                         
ACT193     IF WS-SYSIN-COMP-NO EQUAL AT-COMPANY-NO OR                   
ACT193       WS-SYSIN-COMP-NO EQUAL SPACES OR                           
ACT193       WS-SYSIN-COMP-NO EQUAL LOW-VALUES                          
ACT193        IF WS-COMPANY-NO-HOLD NOT EQUAL AT-COMPANY-NO             
ACT193           MOVE WS-YES             TO WS-COMPANY-CHANGE-SW        
ACT193           PERFORM 4120-GET-COMP-NAME      THRU 4120-EXIT         
ACT193        END-IF                                                    
ACT193*                                                                         
ACT193        MOVE AT-COMPANY-NO         TO WS-COMPANY-NO-HOLD          
ACT193*                                                                         
ACT193     END-IF.                                                      
ACT193*                                                                         
ACT193     MOVE WS-WQ-COMMENTS-CRDRECV   TO WS-77-COMMENTS-TEXT.        
ACT193     COMPUTE WS-77-COMMENTS-LEN = LENGTH OF WS-77-COMMENTS-TEXT.  
ACT193     PERFORM 6000-CREATE-WORK-QUEUE THRU 6000-EXIT.               
ACT193*                                                                         
ACT193     PERFORM 7957-FETCH-CSS-ACCOUNT        THRU 7957-EXIT.        
ACT193*                                                                         
ACT193 4100-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193** 4110-FORMAT-WORK-QUEUE                                     **          
ACT193****************************************************************          
ACT193 4110-FORMAT-WORK-QUEUE.                                          
ACT193*                                                                         
ACT193     MOVE AT-ACCOUNT-NO            TO WS-77-ACCOUNT-NO.           
ACT193*                                                                         
ACT193     MOVE AT-DATE-LAST-ACTION(1:4) TO WS-WQ-LAST-ACT-DT(7:4).     
ACT193     MOVE AT-DATE-LAST-ACTION(6:2) TO WS-WQ-LAST-ACT-DT(1:2).     
ACT193     MOVE AT-DATE-LAST-ACTION(9:2) TO WS-WQ-LAST-ACT-DT(4:2).     
ACT193     MOVE '/'                      TO WS-WQ-LAST-ACT-DT(3:1)      
ACT193                                      WS-WQ-LAST-ACT-DT(6:1).     
ACT193*                                                                         
ACT193     PERFORM 4000-MAIL-NAME-ADDRESS        THRU 4000-EXIT.        
ACT193     MOVE WS-CUSTOMER-NAME         TO WS-WQ-CUSTOMER-NAME.        
ACT193*                                                                         
ACT193     MOVE AT-CUSTOMER-NO           TO WS-77-CUSTOMER-NO.          
ACT193     MOVE AT-LOCAL-OFFICE          TO WS-77-LOCAL-OFFICE.         
ACT193     MOVE AT-PREMISE-NO            TO WS-77-PREMISE-NO.           
ACT193     MOVE '4'                      TO WS-77-ROUTE-CATEGORY.       
ACT193     MOVE 'N'                      TO WS-77-PRIORITY.             
ACT193     MOVE 557                      TO WS-77-CATEGORY-ID.          
ACT193     MOVE WS-INPUT-TS              TO WS-77-DATE-CREATED.         
ACT193     MOVE WS-CURR-TS               TO WS-77-DATE-REQUIRED.        
ACT193     MOVE WS-PGRMNAME              TO WS-77-CREATED-BY.           
ACT193*                                                                         
ACT193     MOVE AT-ACCOUNT-NO            TO AC-ACCOUNT-NO.              
ACT193     PERFORM 7960-SELECT-AR-SUM                THRU 7960-EXIT.    
ACT193*                                                                         
ACT193     MOVE AC-AMT-AR-DAY-00         TO WS-WQ-00-DAY-MONEY.         
ACT193     MOVE AC-AMT-AR-DAY-30         TO WS-WQ-30-DAY-MONEY.         
ACT193     MOVE AC-AMT-AR-DAY-60         TO WS-WQ-60-DAY-MONEY.         
ACT193     MOVE AC-AMT-AR-DAY-90         TO WS-WQ-90-DAY-MONEY.         
ACT193     MOVE AC-AMT-UNUSED-CR         TO WS-WQ-CREDIT-AMOUNT.        
ACT193     MOVE AT-ACCT-XFER-TO          TO WS-WQ-ACCT-XFER-TO.         
ACT193     MOVE AT-ACCT-XFER-FROM-LST    TO WS-WQ-ACCT-XFER-FROM.       
ACT193     IF WS-WQ-ACCT-XFER-TO          EQUAL '0000000000000'         
ACT193     AND WS-WQ-ACCT-XFER-FROM       EQUAL '0000000000000'         
ACT193        MOVE SPACES                TO WS-WQ-ACCT-XFER-TO          
ACT193                                      WS-WQ-ACCT-XFER-FROM
           END-IF.       
ACT193*                                                                         
ACT193     PERFORM 4115-GET-PYMT-PRI-LVL             THRU 4115-EXIT.    
ACT193         MOVE WS-WQ-REC-TYPE     TO WS-WQ-REC-TYPE-CRDRCV.        
ACT193*                                                                         
ACT193     EVALUATE AT-CODE-ACCT-STAT                                   
ACT193         WHEN 'A'                                                 
ACT193             MOVE WS-A-STAT-314  TO WS-WQ-ACCT-STATUS             
ACT193         WHEN 'B'                                                 
ACT193             MOVE WS-B-STAT-314  TO WS-WQ-ACCT-STATUS             
ACT193         WHEN 'J'                                                 
ACT193             MOVE WS-J-STAT-314  TO WS-WQ-ACCT-STATUS             
ACT193         WHEN 'S'                                                 
ACT193             MOVE WS-S-STAT-314  TO WS-WQ-ACCT-STATUS             
ACT193         WHEN 'P'                                                 
ACT193             MOVE WS-P-STAT-314  TO WS-WQ-ACCT-STATUS             
ACT193     END-EVALUATE.                                                
ACT193*                                                                         
ACT193 4110-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193** 4115-GET-PYMT-PRI-LVL                                      **          
ACT193****************************************************************          
ACT193 4115-GET-PYMT-PRI-LVL.                                           
ACT193*                                                                         
A04880     MOVE SPACES                 TO WS-WQ-REC-TYPE.               
ACT193     MOVE AC-PYMT-PRIORITY-LVL   TO WS-PYMT-PRTY-LVL.             
ACT193     EVALUATE WS-PYMT-PRTY-LVL                                    
ACT193         WHEN 019                                                 
ACT193             MOVE WS-NSC         TO WS-WQ-REC-TYPE                
ACT193         WHEN 020                                                 
ACT193             MOVE WS-NSA         TO WS-WQ-REC-TYPE                
ACT193         WHEN 029                                                 
ACT193             MOVE WS-NSN         TO WS-WQ-REC-TYPE                
ACT193         WHEN 030                                                 
ACT193             MOVE WS-LPC         TO WS-WQ-REC-TYPE                
ACT193         WHEN 039                                                 
ACT193             MOVE WS-LPN         TO WS-WQ-REC-TYPE                
ACT193         WHEN 040                                                 
ACT193             MOVE WS-UTE         TO WS-WQ-REC-TYPE                
ACT193         WHEN 045                                                 
ACT193             MOVE WS-UTG         TO WS-WQ-REC-TYPE                
ACT193         WHEN 047                                                 
ACT193             MOVE WS-UTW         TO WS-WQ-REC-TYPE                
ACT193         WHEN 050                                                 
ACT193             MOVE WS-EPP         TO WS-WQ-REC-TYPE                
ACT193         WHEN 060                                                 
ACT193             MOVE WS-RCC         TO WS-WQ-REC-TYPE                
ACT193         WHEN 080                                                 
ACT193             MOVE WS-DEP         TO WS-WQ-REC-TYPE                
ACT193         WHEN 090                                                 
ACT193             MOVE WS-DFA         TO WS-WQ-REC-TYPE                
ACT193         WHEN 100                                                 
ACT193             MOVE WS-CNT         TO WS-WQ-REC-TYPE                
ACT193         WHEN 110                                                 
ACT193             MOVE WS-RVC         TO WS-WQ-REC-TYPE                
ACT193         WHEN 129                                                 
ACT193             MOVE WS-PJS         TO WS-WQ-REC-TYPE                
ACT193         WHEN 999                                                 
ACT193             MOVE WS-ADJ         TO WS-WQ-REC-TYPE                
ACT193     END-EVALUATE.                                                
ACT193*                                                                         
ACT193 4115-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193** 4120-GET-COMP-NAME                                         **          
ACT193****************************************************************          
ACT193 4120-GET-COMP-NAME.                                              
ACT193*                                                                         
ACT193     IF COMPANY-CHANGED                                           
ACT193        MOVE AT-COMPANY-NO         TO C7-COMPANY-NO               
ACT193        PERFORM 7970-SELECT-COMPANY-NAME       THRU 7970-EXIT     
ACT193     END-IF.                                                      
ACT193*                                                                         
ACT193     IF CALL-FROM-TERMINATE                                       
ACT193        MOVE WS-DEFAULT-COMPANY-NO TO C7-COMPANY-NO               
ACT193        PERFORM 7970-SELECT-COMPANY-NAME THRU 7970-EXIT           
ACT193     END-IF.                                                      
ACT193     MOVE WS-NO                    TO WS-COMPANY-CHANGE-SW.       
ACT193*                                                                         
ACT193 4120-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT194******************************************************************        
ACT194*   5000-PROCESS-FINB-CRDRECVBAL                                 *        
ACT194* RETRIEVE FINAL BILLED ACCOUNTS WITH A CREDIT RECEIVABLES       *        
ACT194* BALANCE AND WRITE ACCOUNT INFORMATION TO FCSRP197 OUTPUT FILE. *        
ACT194******************************************************************        
ACT194*                                                                         
ACT194 5000-PROCESS-FINBCRD-RECVBAL.                                    
ACT194*                                                                         
ACT194     PERFORM 7980-OPEN-FINALED-ACCT           THRU 7980-EXIT.     
ACT194*                                                                         
ACT194     PERFORM 7985-FETCH-FINALED-ACCT          THRU 7985-EXIT.     
ACT194*                                                                         
ACT194     PERFORM 5200-PROCESS-ACCT-RECVBAL        THRU 5200-EXIT      
ACT194         UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
ACT194*                                                                         
ACT194     PERFORM 7990-CLOSE-FINALED-ACCT          THRU 7990-EXIT.     
ACT194*                                                                         
ACT194 5000-EXIT.                                                       
ACT194     EXIT.                                                        
ACT194*                                                                         
ACT194****************************************************************          
ACT194** 5200-PROCESS-ACCT-RECVBAL                                  **          
ACT194****************************************************************          
ACT194 5200-PROCESS-ACCT-RECVBAL.                                       
ACT194*                                                                         
ACT194     INITIALIZE CWS00077-FIELDS.                                  
ACT194                                                                  
ACT194     PERFORM 5225-FORMAT-WQ-RECVBAL    THRU 5225-EXIT.            
ACT194*                                                                         
ACT194     IF WS-SYSIN-COMP-NO EQUAL AT-COMPANY-NO OR                   
ACT194       WS-SYSIN-COMP-NO EQUAL SPACES OR                           
ACT194       WS-SYSIN-COMP-NO EQUAL LOW-VALUES                          
ACT194        IF WS-COMPANY-NO-HOLD NOT EQUAL AT-COMPANY-NO             
ACT194           MOVE WS-YES             TO WS-COMPANY-CHANGE-SW        
ACT194           PERFORM 4120-GET-COMP-NAME      THRU 4120-EXIT         
ACT194        END-IF                                                    
ACT194*                                                                         
ACT194        MOVE AT-COMPANY-NO         TO WS-COMPANY-NO-HOLD          
ACT194*                                                                         
ACT194     END-IF.                                                      
ACT194*                                                                         
ACT194     MOVE WS-WQ-COMMENTS-RECVBAL   TO WS-77-COMMENTS-TEXT.        
ACT194     COMPUTE WS-77-COMMENTS-LEN = LENGTH OF WS-77-COMMENTS-TEXT.  
ACT194     PERFORM 6000-CREATE-WORK-QUEUE THRU 6000-EXIT.               
ACT194*                                                                         
ACT194     PERFORM 7985-FETCH-FINALED-ACCT       THRU 7985-EXIT.        
ACT194*                                                                         
ACT194 5200-EXIT.                                                       
ACT194     EXIT.                                                        
ACT194*                                                                         
ACT194*****************************************************************         
ACT194*  5225-FORMAT-WQ-RECVBAL                                      **         
ACT194*****************************************************************         
ACT194 5225-FORMAT-WQ-RECVBAL.                                          
ACT194*                                                                         
ACT194     MOVE AT-ACCOUNT-NO          TO WS-77-ACCOUNT-NO.             
ACT194     MOVE AT-CUSTOMER-NO         TO WS-77-CUSTOMER-NO.            
ACT194     MOVE AT-PREMISE-NO          TO WS-77-PREMISE-NO.             
ACT194     MOVE '4'                    TO WS-77-ROUTE-CATEGORY.         
ACT194     MOVE 'N'                    TO WS-77-PRIORITY.               
ACT194     MOVE 558                    TO WS-77-CATEGORY-ID.            
ACT194     MOVE AT-LOCAL-OFFICE        TO WS-77-LOCAL-OFFICE.           
ACT194     MOVE WS-INPUT-TS            TO WS-77-DATE-CREATED.           
ACT194     MOVE WS-CURR-TS             TO WS-77-DATE-REQUIRED.          
ACT194     MOVE WS-PGRMNAME            TO WS-77-CREATED-BY.             
ACT194     MOVE AT-TOTAL-AR-BALANCE    TO WS-WQ-ACCT-BALANCE.           
ACT194     MOVE AT-ACCT-FINALED-DT     TO WS-DATE-10.                   
ACT194     MOVE WS-D10-CC              TO WS-FMT-CC.                    
ACT194     MOVE WS-D10-YY              TO WS-FMT-YY.                    
ACT194     MOVE WS-D10-MM              TO WS-FMT-MM.                    
ACT194     MOVE WS-D10-DD              TO WS-FMT-DD.                    
ACT194     MOVE WS-FORMAT-DATE         TO WS-WQ-ACCT-FINALED-DT.        
ACT194     IF AT-LAST-PYMT-DATE        = SPACES                         
ACT194        MOVE SPACES              TO WS-WQ-LAST-PYMT-DATE          
ACT194     ELSE                                                         
ACT194        MOVE AT-LAST-PYMT-DATE   TO WS-DATE-10                    
ACT194        MOVE WS-D10-CC           TO WS-FMT-CC                     
ACT194        MOVE WS-D10-YY           TO WS-FMT-YY                     
ACT194        MOVE WS-D10-MM           TO WS-FMT-MM                     
ACT194        MOVE WS-D10-DD           TO WS-FMT-DD                     
ACT194        MOVE WS-FORMAT-DATE      TO WS-WQ-LAST-PYMT-DATE          
ACT194     END-IF.                                                      
ACT194     MOVE AT-LAST-PYMT-AMOUNT    TO WS-WQ-LAST-PYMT-AMOUNT.       
ACT194*                                                                         
ACT194     PERFORM 4115-GET-PYMT-PRI-LVL        THRU 4115-EXIT.         
ACT194         MOVE WS-WQ-REC-TYPE     TO WS-WQ-REC-TYPE-RCVBAL.        
ACT194*                                                                         
ACT194     IF AC-AMT-TRAN-BALANCE < 0                                   
ACT194         MOVE AC-AMT-TRAN-BALANCE TO WS-WQ-AMT-TRAN-BALANCE       
ACT194     ELSE                                                         
ACT194         MOVE AC-AMT-UNUSED-CR    TO WS-WQ-AMT-TRAN-BALANCE       
ACT194     END-IF.                                                      
ACT194*                                                                         
ACT194     PERFORM 4000-MAIL-NAME-ADDRESS       THRU 4000-EXIT.         
ACT194*                                                                         
ACT194     MOVE WS-ACCOUNT-NAME         TO WS-WQ-CUSTOMER-NM.           
ACT194*                                                                         
ACT194 5225-EXIT.                                                       
ACT194     EXIT.                                                        
ACT194*                                                                         
ACT195******************************************************************        
ACT195*   5300-PROCESS-REFUND-REQBNSNT                                 *        
ACT195* TO CREATE WQ'S OF REFUNDS REQUESTED BUT NOT YET SENT.          *        
ACT195******************************************************************        
ACT195*                                                                         
ACT195 5300-PROCESS-REFUND-REQBNSNT.                                    
ACT195*                                                                         
ACT195     PERFORM 7991-GET-WQ-AREA-CAT             THRU 7991-EXIT.     
ACT195     PERFORM 7993-GET-WQ-CATEGORY             THRU 7993-EXIT.     
ACT195     PERFORM 7995-OPEN-ACCT-RANGE             THRU 7995-EXIT.     
ACT195*                                                                         
ACT195     PERFORM 7997-FETCH-ACCT-RANGE            THRU 7997-EXIT.     
ACT195*                                                                         
ACT195     PERFORM 5500-PROCESS-ACCT-REFUND         THRU 5500-EXIT      
ACT195         UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
ACT195*                                                                         
ACT195     PERFORM 7999-CLOSE-ACCT-RANGE            THRU 7999-EXIT.     
ACT195*                                                                         
ACT195 5300-EXIT.                                                       
ACT195     EXIT.                                                        
ACT195*                                                                         
ACT195******************************************************************        
ACT195*   5500-PROCESS-ACCT-REFUND                                     *        
ACT195* TO CREATE WQ'S OF REFUNDS REQUESTED BUT NOT YET SENT.          *        
ACT195******************************************************************        
ACT195*                                                                         
ACT195 5500-PROCESS-ACCT-REFUND.                                        
ACT195*                                                                         
ACT195     PERFORM 5505-GENERATE-WQ                 THRU 5505-EXIT.     
ACT195*                                                                         
ACT195     PERFORM 7997-FETCH-ACCT-RANGE            THRU 7997-EXIT.     
ACT195*                                                                         
ACT195 5500-EXIT.                                                       
ACT195     EXIT.                                                        
ACT195*                                                                         
ACT195******************************************************************        
ACT195**  GENERATE A WQ WITH REFUNDS REQUESTED BUT NOT YET SENT.      **        
ACT195******************************************************************        
ACT195 5505-GENERATE-WQ.                                                
ACT195*                                                                         
ACT195     INITIALIZE CWS00077-FIELDS.                                  
ACT195     MOVE AT-ACCOUNT-NO           TO WS-77-ACCOUNT-NO.            
ACT195     MOVE AT-CUSTOMER-NO          TO WS-77-CUSTOMER-NO.           
ACT195     MOVE AT-PREMISE-NO           TO WS-77-PREMISE-NO.            
ACT195     MOVE AT-LOCAL-OFFICE         TO WS-77-LOCAL-OFFICE,          
ACT195     MOVE WS-NO                   TO WS-77-PRIORITY.              
ACT195     MOVE WS-CURRENT-DATE         TO WS-INPUT-DATE-PT.            
ACT195     MOVE WS-INPUT-TS             TO WS-77-DATE-CREATED.          
ACT195     MOVE WS-CURR-TS              TO WS-77-DATE-REQUIRED.         
ACT195     MOVE WS-PGRMNAME             TO WS-77-CREATED-BY.            
ACT195*                                                                         
ACT195     MOVE 556                     TO WS-77-CATEGORY-ID.           
ACT195     MOVE WS-RESP-AREA-ID         TO WS-77-RESP-AREA-ID.          
ACT195     MOVE WS-ROUTING-CATEGORY     TO WS-77-ROUTE-CATEGORY.        
ACT195                                                                  
ACT195     MOVE 'AMOUNT REFUNDED NOT YET SENT' TO WS-OPT-DATA-FILLER.   
ACT195     MOVE RN-AMT-REFUNDED TO WS-OPT-DATA-INTEGER.                 
ACT195     MOVE WS-OPT-DATA-VALUE-C TO WS-77-COMMENTS-TEXT.             
ACT195     MOVE +42 TO WS-77-COMMENTS-LEN.                              
ACT195*                                                                         
ACT195     PERFORM 6000-CREATE-WORK-QUEUE        THRU 6000-EXIT.        
ACT195*                                                                         
ACT195 5505-EXIT.                                                       
ACT195     EXIT.                                                        
ACT195*                                                                         
ACT193 COPY CPD00004.                                                           
ACT193*                                                                         
ACT193 COPY CPD00037.                                                           
ACT193*                                                                         
ACT193 COPY CPD00040.                                                           
ACT193*                                                                         
      ******************************************************************        
      *   6000-CREATE-WORK-QUEUE.                                      *        
      * INSERT THE WORK QUEUE ITEMS IN THE CSS_WQ_ITEMS TABLE.         *        
      ******************************************************************        
      *                                                                         
       6000-CREATE-WORK-QUEUE.                                          
                                                                        
           CALL SCSCB077 USING CWS00077-FIELDS,                         
                               ABEND-FILE,                              
                               RS-RETURN-CODE                           
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              DISPLAY '6000-INSERT-WORK-QUEUE'                          
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              DISPLAY 'ABEND-FUNCTION' ABEND-FUNCTION                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       6000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-DTLS-CSR                                             *        
      ******************************************************************        
      *                                                                         
       7000-OPEN-DTLS-CSR.                                              
      *                                                                         
           EXEC SQL                                                     
              OPEN DTLS_CSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSCA015  ***********'                  
              DISPLAY '**  7000-OPEN-DTLS-CSR      **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-DTLS-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7100-FETCH-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              FETCH DTLS_CSR                                            
               INTO :AT-ACCOUNT-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:AT-TOTAL-AR-BALANCE                                
                   ,:AT-DATE-BILL-DAY-00                                
                   ,:AT-MST-SUB-ACCT-IND                                
                   ,:CH-DATE-UTIL-SVC-END :WS-DATE-SVC-END-NULL          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-DATE-SVC-END-NULL = -1                               
                MOVE SPACES                  TO CH-DATE-UTIL-SVC-END    
             END-IF                                                     
           ELSE                                                         
              DISPLAY '******** PCSCA015 ***********'                   
              DISPLAY '**  7100-FETCH-DTLS-CSR    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-DTLS-CSR                                            *        
      ******************************************************************        
      *                                                                         
       7200-CLOSE-DTLS-CSR.                                             
      *                                                                         
           EXEC SQL                                                     
              CLOSE DTLS_CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSCA015 ***********'                   
              DISPLAY '**  7200-CLOSE-DTLS-CSR    **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-OPEN-RATE-PLAN                                            *        
      ******************************************************************        
      *                                                                         
       7300-OPEN-RATE-PLAN.                                             
      *                                                                         
           EXEC SQL                                                     
              OPEN RATE_PLAN                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSCA015  ***********'                  
              DISPLAY '**  7300-OPEN-RATE-PLAN     **'                  
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT.ACCOUNT_NO ' AT-ACCOUNT-NO                
              DISPLAY '**  RD.SECURED_RATE_FL: ' RD-SECURED-RATE-FL     
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7400-FETCH-RATE-PLAN                                           *        
      ******************************************************************        
      *                                                                         
       7400-FETCH-RATE-PLAN.                                            
      *                                                                         
           EXEC SQL                                                     
              FETCH RATE_PLAN                                           
               INTO :WS-SECURED-RATE-FLAG                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '******** PCSCA015 ***********'                   
              DISPLAY '**  7400-FETCH-RATE-PLAN   **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT.ACCOUNT_NO ' AT-ACCOUNT-NO                
              DISPLAY '**  SECURED_RATE_FL: ' WS-SECURED-RATE-FLAG      
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-CLOSE-RATE-PLAN                                           *        
      ******************************************************************        
      *                                                                         
       7500-CLOSE-RATE-PLAN.                                            
      *                                                                         
           EXEC SQL                                                     
              CLOSE RATE_PLAN                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSCA015 ***********'                   
              DISPLAY '**  7500-CLOSE-RATE-PLAN   **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT.ACCOUNT_NO ' AT-ACCOUNT-NO                
              DISPLAY '**  RD.SECURED_RATE_FL: ' RD-SECURED-RATE-FL     
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
ACT193**  7550-CHECK-WQ-EXISTS                                        **        
      ******************************************************************        
      *                                                                         
ACT193  7550-CHECK-WQ-EXISTS.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT STATUS                                             
                INTO :WQ-STATUS                                         
                FROM CSS_WQ_ITEMS WQ WITH(READUNCOMMITTED)                      
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                 AND CATEGORY_ID IN ( 13, 138)                          
                 AND STATUS      IN ('A', 'I')                          
ACT193           AND FREE_FORM_AREA = :WS-PGRMNAME                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STATUS                                                     
MFA-TR*         INTO :WQ-STATUS                                                 
MFA-TR*         FROM CSS_WQ_ITEMS WQ                                            
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*          AND CATEGORY_ID IN ( 13, 138)                                  
MFA-TR*          AND STATUS      IN ('A', 'I')                                  
MFA-TR*          AND FREE_FORM_AREA = :WS-PGRMNAME                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSCA015 ***********'                   
ACT193        DISPLAY '**  7550-CHECK-WQ-EXISTS   **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  AT-ACCOUNT-NO = ' AT-ACCOUNT-NO              
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
ACT193 7550-EXIT.                                                       
           EXIT.                                                        
ACT014*                                                                         
      ******************************************************************        
      * 7700-GET-CURRENT-DATE.                                         *        
      ******************************************************************        
      *                                                                         
       7700-GET-CURRENT-DATE.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '******** PCSCA015 ***********'                   
              DISPLAY '**  7700-GET-CURRENT-DATE  **'                   
              DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**  PROCESSING TERMINATED  **'                   
              PERFORM 9900-ABEND                    THRU 9900-EXIT      
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT014******************************************************************        
ACT014* 7800-OPEN-INACTIVE-ACC                                         *        
ACT014******************************************************************        
ACT014*                                                                         
ACT014 7800-OPEN-INACTIVE-ACC.                                          
ACT014*                                                                         
ACT014     EXEC SQL                                                     
ACT014        OPEN INACTIVE_ACCOUNTS                                    
ACT014     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT014                                                                  
ACT014     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
ACT014                                                                  
ACT014     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL                  
ACT014         CONTINUE                                                 
ACT014     ELSE                                                         
ACT014        DISPLAY '******** PCSCA015  ***********'                  
ACT014        DISPLAY '**  7800-OPEN-INACTIVE-ACC  **'                  
ACT014        DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT014        DISPLAY '**  PROCESSING TERMINATED  **'                   
ACT014        PERFORM 9900-ABEND                    THRU 9900-EXIT      
ACT014     END-IF.                                                      
ACT014*                                                                         
ACT014 7800-EXIT.                                                       
ACT014     EXIT.                                                        
ACT014*                                                                         
ACT014******************************************************************        
ACT014* 7900-FETCH-INACTIVE-ACC                                        *        
ACT014******************************************************************        
ACT014*                                                                         
ACT014 7900-FETCH-INACTIVE-ACC.                                         
ACT014*                                                                         
ACT014     EXEC SQL                                                     
ACT014        FETCH INACTIVE_ACCOUNTS                                   
ACT014         INTO :AT-ACCOUNT-NO                                      
ACT014             ,:AT-PREMISE-NO                                      
ACT014             ,:AT-CUSTOMER-NO                                     
ACT014             ,:AT-LOCAL-OFFICE                                    
ACT014             ,:AT-DATE-LAST-ACTION                                
ACT014             ,:AT-TOTAL-AR-BALANCE                                
ACT014             ,:AC-AMT-UNUSED-CR                                   
ACT014             ,:AT-COMPANY-NO                                      
ACT014     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT014*                                                                         
ACT014     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
ACT014                                                                  
ACT014     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT014        CONTINUE                                                  
ACT014     ELSE                                                         
ACT014        DISPLAY '******** PCSCA015 ***********'                   
ACT014        DISPLAY '**  7900-FETCH-INACTIVE-ACC**'                   
ACT014        DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT014        DISPLAY '**  PROCESSING TERMINATED  **'                   
ACT014        PERFORM 9900-ABEND                    THRU 9900-EXIT      
ACT014     END-IF.                                                      
ACT014*                                                                         
ACT014 7900-EXIT.                                                       
ACT014     EXIT.                                                        
ACT014*                                                                         
ACT014******************************************************************        
ACT014* 7950-CLOSE-INACTIVE-ACC.                                      *         
ACT014******************************************************************        
ACT014*                                                                         
ACT014 7950-CLOSE-INACTIVE-ACC.                                         
ACT014*                                                                         
ACT014     EXEC SQL                                                     
ACT014        CLOSE INACTIVE_ACCOUNTS                                   
ACT014     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT014                                                                  
ACT014     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
ACT014                                                                  
ACT014     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT014        CONTINUE                                                  
ACT014     ELSE                                                         
ACT014        DISPLAY '******** PCSCA015 ***********'                   
ACT014        DISPLAY '**  7950-CLOSE-INACTIVE-ACC**'                   
ACT014        DISPLAY '**  RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT014        DISPLAY '**  PROCESSING TERMINATED  **'                   
ACT014        PERFORM 9900-ABEND                    THRU 9900-EXIT      
ACT014     END-IF.                                                      
ACT014*                                                                         
ACT014 7950-EXIT.                                                       
ACT014     EXIT.                                                        
ACT014*                                                                         
ACT193****************************************************************          
ACT193*7953-GET-CURR-DATE-PLUS1                                                 
ACT193****************************************************************          
ACT193 7953-GET-CURR-DATE-PLUS1.                                        
ACT193*                                                                         
ACT193     EXEC SQL                                                     
ACT193         SELECT
              DATEADD( DAY, 1, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CURR-DATE-PLUS1                              
ACT193     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET  :WS-CURR-DATE-PLUS1 =                                       
MFA-TR*              CURRENT DATE + 1 DAYS                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT193*                                                                         
ACT193     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT193*                                                                         
ACT193     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT193        CONTINUE                                                  
ACT193     ELSE                                                         
ACT193         DISPLAY '******** PCSCA015 ***********'                  
ACT193         DISPLAY '** 7953-GET-CURR-DATE-PLUS1'                    
ACT193         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT193         DISPLAY '**  PROCESSING TERMINATED  **'                  
ACT193         PERFORM 9900-ABEND                  THRU 9900-EXIT       
ACT193     END-IF.                                                      
ACT193*                                                                         
ACT193 7953-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193**   7955-OPEN-CSS-ACCOUNT                                    **          
ACT193**       OPENS AT-CURSOR FOR ACCOUNT TABLE                    **          
ACT193****************************************************************          
ACT193 7955-OPEN-CSS-ACCOUNT.                                           
ACT193*                                                                         
ACT193     MOVE '7955'                 TO WS-ACTIVE-PARAGRAPH.          
ACT193*                                                                         
ACT193     EXEC SQL                                                     
ACT193         OPEN AT-CURSOR                                           
ACT193     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT193*                                                                         
ACT193     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT193*                                                                         
ACT193     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT193         CONTINUE                                                 
ACT193     ELSE                                                         
ACT193         DISPLAY '******** PCSCA015 ***********'                  
ACT193         DISPLAY '** 7955-OPEN-CSS-ACCOUNT'                       
ACT193         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT193         DISPLAY '**  PROCESSING TERMINATED  **'                  
ACT193         PERFORM 9900-ABEND                    THRU 9900-EXIT     
ACT193     END-IF.                                                      
ACT193*                                                                         
ACT193 7955-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193**   7957-FETCH-CSS-ACCOUNT                                   **          
ACT193****************************************************************          
ACT193 7957-FETCH-CSS-ACCOUNT.                                          
ACT193*                                                                         
ACT193     MOVE '7957'                 TO WS-ACTIVE-PARAGRAPH.          
ACT193*                                                                         
ACT193     EXEC SQL                                                     
ACT193         FETCH AT-CURSOR                                          
ACT193         INTO :AT-ACCOUNT-NO,                                     
ACT193              :AT-CUSTOMER-NO,                                    
ACT193              :AT-CODE-ACCT-STAT,                                 
ACT193              :AT-BILL-CYCLE,                                     
ACT193              :AT-DATE-LAST-ACTION :WS-NULL-IND,                  
ACT193              :AT-COMPANY-NO,                                     
ACT193              :AT-ADDRESS-ID,                                     
ACT193              :AT-ACCT-XFER-TO,                                   
ACT193              :AT-ACCT-XFER-FROM-LST,                             
ACT193              :AT-LOCAL-OFFICE,                                   
ACT193              :AT-PREMISE-NO,                                     
ACT193              :AC-PYMT-PRIORITY-LVL,                              
ACT193              :AC-AMT-UNUSED-CR                                   
ACT193     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT193*                                                                         
ACT193     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT193*                                                                         
ACT193     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
ACT193       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
ACT193         IF WS-NULL-IND < 0                                       
ACT193           MOVE SPACES           TO AT-DATE-LAST-ACTION           
ACT193         END-IF                                                   
ACT193       END-IF                                                     
ACT193     ELSE                                                         
ACT193         DISPLAY '******** PCSCA015 ***********'                  
ACT193         DISPLAY '** 7957-FETCH-CSS-ACCOUNT'                      
ACT193         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT193         DISPLAY '**  PROCESSING TERMINATED  **'                  
ACT193         PERFORM 9900-ABEND                  THRU 9900-EXIT       
ACT193     END-IF.                                                      
ACT193*                                                                         
ACT193 7957-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193**   7959-CLOSE-CSS-ACCOUNT                                   **          
ACT193****************************************************************          
ACT193 7959-CLOSE-CSS-ACCOUNT.                                          
ACT193*                                                                         
ACT193     MOVE '7959'                 TO WS-ACTIVE-PARAGRAPH.          
ACT193*                                                                         
ACT193     EXEC SQL                                                     
ACT193         CLOSE AT-CURSOR                                          
ACT193     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT193*                                                                         
ACT193     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT193*                                                                         
ACT193     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT193         NEXT SENTENCE                                            
ACT193     ELSE                                                         
ACT193         DISPLAY '******** PCSCA015 ***********'                  
ACT193         DISPLAY '** 7959-CLOSE-CSS-ACCOUNT'                      
ACT193         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT193         DISPLAY '**  PROCESSING TERMINATED  **'                  
ACT193         PERFORM 9900-ABEND                    THRU 9900-EXIT     
ACT193     END-IF.                                                      
ACT193*                                                                         
ACT193 7959-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193** 7960-SELECT-AR-SUM                                         **          
ACT193****************************************************************          
ACT193 7960-SELECT-AR-SUM.                                              
ACT193*                                                                         
ACT193     EXEC SQL                                                     
ACT193        SELECT   SUM(AMT_AR_DAY_00),                              
ACT193                 SUM(AMT_AR_DAY_30),                              
ACT193                 SUM(AMT_AR_DAY_60),                              
ACT193                 SUM(AMT_AR_DAY_90)                               
ACT193          INTO   :AC-AMT-AR-DAY-00,                               
ACT193                 :AC-AMT-AR-DAY-30,                               
ACT193                 :AC-AMT-AR-DAY-60,                               
ACT193                 :AC-AMT-AR-DAY-90                                
ACT193          FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                        
ACT193         WHERE   ACCOUNT_NO          = :AC-ACCOUNT-NO             
ACT193           AND   ITEM_ID             = 0                          
ACT193           AND   PYMT_PRIORITY_LVL   <> 70                        
ACT193                                                           
ACT193     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   SUM(AMT_AR_DAY_00),                                      
MFA-TR*                SUM(AMT_AR_DAY_30),                                      
MFA-TR*                SUM(AMT_AR_DAY_60),                                      
MFA-TR*                SUM(AMT_AR_DAY_90)                                       
MFA-TR*         INTO   :AC-AMT-AR-DAY-00,                                       
MFA-TR*                :AC-AMT-AR-DAY-30,                                       
MFA-TR*                :AC-AMT-AR-DAY-60,                                       
MFA-TR*                :AC-AMT-AR-DAY-90                                        
MFA-TR*         FROM   CSS_AR_CNTL                                              
MFA-TR*        WHERE   ACCOUNT_NO          = :AC-ACCOUNT-NO                     
MFA-TR*          AND   ITEM_ID             = 0                                  
MFA-TR*          AND   PYMT_PRIORITY_LVL   <> 70                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT193*                                                                         
ACT193     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT193*                                                                         
ACT193     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT193         NEXT SENTENCE                                            
ACT193     ELSE                                                         
ACT193         DISPLAY '******** PCSCA015 ***********'                  
ACT193         DISPLAY '** 7960-SELECT-AR-SUM'                          
ACT193         DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE        
ACT193         DISPLAY '**  PROCESSING TERMINATED  **'                  
ACT193         PERFORM 9900-ABEND                    THRU 9900-EXIT     
ACT193     END-IF.                                                      
ACT193*                                                                         
ACT193 7960-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT193****************************************************************          
ACT193** 7970-SELECT-COMPANY-NAME                                   **          
ACT193****************************************************************          
ACT193 7970-SELECT-COMPANY-NAME.                                        
ACT193*                                                                         
ACT193     MOVE '7970'                 TO WS-ACTIVE-PARAGRAPH.          
ACT193*                                                                         
ACT193     EXEC SQL                                                     
ACT193         SELECT    COMPANY_NAME                                   
ACT193         INTO      :C7-COMPANY-NAME                               
ACT193         FROM      CSS_COMPANY WITH(READUNCOMMITTED)                      
ACT193          WHERE    COMPANY_NO = :C7-COMPANY-NO                    
ACT193                                                           
ACT193     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    COMPANY_NAME                                           
MFA-TR*        INTO      :C7-COMPANY-NAME                                       
MFA-TR*        FROM      CSS_COMPANY                                            
MFA-TR*         WHERE    COMPANY_NO = :C7-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT193*                                                                         
ACT193     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT193*                                                                         
ACT193     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT193         MOVE C7-COMPANY-NAME    TO WS-WQ-RPT1-COMP-NAME          
ACT194                                    WS-WQ-COMP-NAME               
ACT193     ELSE                                                         
ACT193         IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
ACT193             MOVE SPACES         TO WS-WQ-RPT1-COMP-NAME          
ACT194                                    WS-WQ-COMP-NAME               
ACT193         ELSE                                                     
ACT193             DISPLAY '******** PCSCA015 ***********'              
ACT193             DISPLAY '** 7970-SELECT-COMPANY-NAME'                
ACT193             DISPLAY '** RETURN CODE = ' WS-ACTIVE-RETURN-CODE    
ACT193             DISPLAY '**  PROCESSING TERMINATED  **'              
ACT193             PERFORM 9900-ABEND                    THRU 9900-EXIT 
ACT193         END-IF                                                   
ACT193     END-IF.                                                      
ACT193*                                                                         
ACT193 7970-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
ACT194*****************************************************************         
ACT194**    7980-OPEN-FINALED-ACCT                                   **         
ACT194**      OPEN CURSOR FINALED_ACCT TO GET FINALED ACCTS WITH     **         
ACT194**      WITH A CREDIT RECEIVABLES BALANCE.                     **         
ACT194*****************************************************************         
ACT194 7980-OPEN-FINALED-ACCT.                                          
ACT194     EXEC SQL                                                     
ACT194        OPEN FINALED_ACCT                                         
ACT194     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT194                                                                  
ACT194     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT194                                                                  
ACT194     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT194         NEXT SENTENCE                                            
ACT194     ELSE                                                         
ACT194         MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE            
ACT194         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
ACT194         MOVE 'OPEN'                 TO ABEND-FUNCTION            
ACT194         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
ACT194         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
ACT194         MOVE '7980'                 TO ACTIVE-PARAGRAPH          
ACT194         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
ACT194     END-IF.                                                      
ACT194 7980-EXIT.                                                       
ACT194     EXIT.                                                        
ACT194*                                                                         
ACT194*****************************************************************         
ACT194**    7985-FETCH-FINALED-ACCT                                  **         
ACT194**      FETCH ROWS FROM CURSOR FINALED_ACCT                    **         
ACT194*****************************************************************         
ACT194 7985-FETCH-FINALED-ACCT.                                         
ACT194     EXEC SQL                                                     
ACT194        FETCH FINALED_ACCT INTO                                   
ACT194              :AT-ACCOUNT-NO,                                    
ACT194              :AT-CUSTOMER-NO,                                   
ACT194              :AT-BILL-CYCLE,                                    
ACT194              :AT-COMPANY-NO,                                    
ACT194              :AT-LOCAL-OFFICE,                                  
ACT194              :AT-PREMISE-NO,                                    
ACT194              :AT-ADDRESS-ID,                                    
ACT194              :AT-TOTAL-AR-BALANCE,                              
ACT194              :AT-ACCT-FINALED-DT,                               
ACT194              :AT-LAST-PYMT-DATE :WS-LAST-PYMT-DATE-NI,           
ACT194              :AT-LAST-PYMT-AMOUNT,                              
ACT194              :AC-PYMT-PRIORITY-LVL,                             
ACT194              :AC-AMT-TRAN-BALANCE,                              
ACT194              :AC-AMT-UNUSED-CR                                  
ACT194     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT194                                                                  
ACT194     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT194                                                                  
ACT194     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT194         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
ACT194            IF WS-LAST-PYMT-DATE-NI < 0                           
ACT194               MOVE SPACES TO AT-LAST-PYMT-DATE                   
ACT194            END-IF                                                
ACT194         END-IF                                                   
ACT194     ELSE                                                         
ACT194         MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE            
ACT194         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
ACT194         MOVE 'FETCH'                TO ABEND-FUNCTION            
ACT194         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
ACT194         MOVE 'CSS_AR_CNTL'          TO TABLE-2                   
ACT194         MOVE '7985'                 TO ACTIVE-PARAGRAPH          
ACT194         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
ACT194     END-IF.                                                      
ACT194 7985-EXIT.                                                       
ACT194     EXIT.                                                        
ACT194*                                                                         
ACT194*****************************************************************         
ACT194**    7990-CLOSE-FINALED-ACCT                                  **         
ACT194**      CLOSE CURSOR FINALED_ACCT                              **         
ACT194*****************************************************************         
ACT194 7990-CLOSE-FINALED-ACCT.                                         
ACT194     EXEC SQL                                                     
ACT194        CLOSE FINALED_ACCT                                        
ACT194     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT194                                                                  
ACT194     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT194                                                                  
ACT194     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT194         NEXT SENTENCE                                            
ACT194     ELSE                                                         
ACT194         MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE            
ACT194         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
ACT194         MOVE 'CLOSE'                TO ABEND-FUNCTION            
ACT194         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
ACT194         MOVE 'CSS_AR_CNTL'          TO TABLE-2                   
ACT194         MOVE '7900'                 TO ACTIVE-PARAGRAPH          
ACT194         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
ACT194     END-IF.                                                      
ACT194 7990-EXIT.                                                       
ACT194     EXIT.                                                        
ACT194*                                                                         
ACT195*****************************************************************         
ACT195*  7991-GET-WQ-CAT                                              *         
ACT195*       GETS WQ CATEGORY FOR CSR OR SEB.                                  
ACT195*****************************************************************         
ACT195 7991-GET-WQ-AREA-CAT.                                            
ACT195                                                                  
ACT195     EXEC SQL                                                     
ACT195         SELECT                                                   
ACT195              RESP_AREA_ID                                        
ACT195          INTO                                                    
ACT195             :WS-RESP-AREA-ID                                     
ACT195           FROM  CSS_WQ_AREA_CAT WITH(READUNCOMMITTED)                    
ACT195          WHERE  CATEGORY_ID = 556                                
ACT195                                                           
ACT195                                                      
ACT195     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             RESP_AREA_ID                                                
MFA-TR*         INTO                                                            
MFA-TR*            :WS-RESP-AREA-ID                                             
MFA-TR*          FROM  CSS_WQ_AREA_CAT                                          
MFA-TR*         WHERE  CATEGORY_ID = 556                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7991                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT195*                                                                         
ACT195     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT195*                                                                         
ACT195     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT195        CONTINUE                                                  
ACT195     ELSE                                                         
ACT195        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
ACT195           MOVE '420' TO WS-RESP-AREA-ID                          
ACT195        ELSE                                                      
ACT195         DISPLAY '************* ABENDING ************'            
ACT195         DISPLAY '**   PCSCA130 PROCESSING ERROR   **'            
ACT195         DISPLAY '**   7991-GET-WQ-AREA-CAT         **'           
ACT195         DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
ACT195         DISPLAY '**   RESP_AREA_ID = 556 '                       
ACT195         DISPLAY '**   PROCESSING TERMINATED     **'              
ACT195         DISPLAY '************* PCSCA130 ************'            
ACT195         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT195        END-IF                                                    
ACT195     END-IF.                                                      
ACT195*                                                                         
ACT195 7991-EXIT.                                                       
ACT195     EXIT.                                                        
ACT195*                                                                         
ACT195*****************************************************************         
ACT195*  7993-GET-WQ-CATEGORY                                         *         
ACT195*       GETS WQ CATEGORY FOR CSR OR SEB.                                  
ACT195*****************************************************************         
ACT195 7993-GET-WQ-CATEGORY.                                            
ACT195                                                                  
ACT195     EXEC SQL                                                     
ACT195         SELECT                                                   
ACT195              ROUTING_CATEGORY                                    
ACT195          INTO                                                    
ACT195             :WS-ROUTING-CATEGORY                                 
ACT195           FROM  CSS_WQ_CATEGORY WITH(READUNCOMMITTED)                    
ACT195          WHERE  CATEGORY_ID = 556                                
ACT195                                                           
ACT195                                                      
ACT195     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             ROUTING_CATEGORY                                            
MFA-TR*         INTO                                                            
MFA-TR*            :WS-ROUTING-CATEGORY                                         
MFA-TR*          FROM  CSS_WQ_CATEGORY                                          
MFA-TR*         WHERE  CATEGORY_ID = 556                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7993                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT195*                                                                         
ACT195     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
ACT195*                                                                         
ACT195     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT195        CONTINUE                                                  
ACT195     ELSE                                                         
ACT195        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
ACT195           MOVE '4' TO WS-ROUTING-CATEGORY                        
ACT195        ELSE                                                      
ACT195         DISPLAY '************* ABENDING ************'            
ACT195         DISPLAY '**   PCSCA130 PROCESSING ERROR   **'            
ACT195         DISPLAY '**   7993-GET-WQ-CATEGORY    **'                
ACT195         DISPLAY '**   SQLCODE = ' WS-ACTIVE-RETURN-CODE          
ACT195         DISPLAY '**   RESP_AREA_ID = 556 '                       
ACT195         DISPLAY '**   PROCESSING TERMINATED     **'              
ACT195         DISPLAY '************* PCSCA130 ************'            
ACT195         PERFORM 9900-ABEND      THRU 9900-EXIT                   
ACT195        END-IF                                                    
ACT195     END-IF.                                                      
ACT195*                                                                         
ACT195 7993-EXIT.                                                       
ACT195     EXIT.                                                        
ACT195*                                                                         
ACT195******************************************************************        
ACT195*   7995-OPEN-ACCT-RANGE                                         *        
ACT195*   OPENS OLD UCA CURSOR                                         *        
ACT195******************************************************************        
ACT195 7995-OPEN-ACCT-RANGE.                                            
ACT195*                                                                         
ACT195     EXEC SQL                                                     
ACT195        OPEN ACCT_RANGE                                           
ACT195     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT195*                                                                         
ACT195     MOVE SQLCODE                       TO  WS-ACTIVE-RETURN-CODE.
ACT195*                                                                         
ACT195     IF  WS-ACTIVE-RETURN-CODE   EQUAL SUCCESSFUL-CALL            
ACT195         CONTINUE                                                 
ACT195     ELSE                                                         
ACT195         DISPLAY '************ ABENDING ************'             
ACT195         DISPLAY '** 7995-OPEN-ACCT-RANGE     **'                 
ACT195         DISPLAY '** SQLCODE IS ',     WS-ACTIVE-RETURN-CODE      
ACT195         DISPLAY '** CUSTOMER-NO = ' AT-CUSTOMER-NO ' **'         
ACT195         DISPLAY '**     PROCESSING TERMINATED    **'             
ACT195         DISPLAY '************ PCSCA130 ************'             
ACT195         PERFORM 9900-ABEND             THRU 9900-EXIT            
ACT195     END-IF.                                                      
ACT195*                                                                         
ACT195 7995-EXIT.                                                       
ACT195     EXIT.                                                        
ACT195******************************************************************        
ACT195*  7997-FETCH-ACCT-RANGE                                                  
ACT195*  FETCHES ACCT-RANGE                                                     
ACT195******************************************************************        
ACT195 7997-FETCH-ACCT-RANGE.                                           
ACT195     EXEC SQL                                                     
ACT195        FETCH   ACCT_RANGE                                        
ACT195         INTO   :AT-ACCOUNT-NO                                    
ACT195               ,:RN-REFUND-ITEM-ID                                
ACT195               ,:RN-REQUEST-DT                                    
ACT195               ,:RN-AMT-REFUNDED                                  
ACT195               ,:AT-COMPANY-NO                                    
ACT195               ,:AT-CUSTOMER-NO                                   
ACT195               ,:AT-PREMISE-NO                                    
ACT195               ,:AT-LOCAL-OFFICE                                  
ACT195     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT195*                                                                         
ACT195     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT195*                                                                         
ACT195     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
ACT195         CONTINUE                                                 
ACT195     ELSE                                                         
ACT195         DISPLAY '************ ABENDING ************'             
ACT195         DISPLAY '** 7997-FETCH-ACCT-RANGE    **'                 
ACT195         DISPLAY '** ACCOUNT NO ',  AT-ACCOUNT-NO                 
ACT195         DISPLAY '** CUSTOMER NO ', AT-CUSTOMER-NO                
ACT195         DISPLAY '** PREMISE  NO ', AT-PREMISE-NO                 
ACT195         DISPLAY '** SQLCODE IS ',  WS-ACTIVE-RETURN-CODE         
ACT195         DISPLAY '**     PROCESSING TERMINATED    **'             
ACT195         DISPLAY '************ PCSCA130 ************'             
ACT195         PERFORM 9900-ABEND             THRU 9900-EXIT            
ACT195     END-IF.                                                      
ACT195*                                                                         
ACT195 7997-EXIT.                                                       
ACT195     EXIT.                                                        
ACT195*                                                                         
ACT195******************************************************************        
ACT195*  7999-CLOSE-ACCT-RANGE                                                  
ACT195*  CLOSES ACCT-RANGE                                                      
ACT195******************************************************************        
ACT195 7999-CLOSE-ACCT-RANGE.                                           
ACT195     EXEC SQL                                                     
ACT195        CLOSE ACCT_RANGE                                          
ACT195     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT195*                                                                         
ACT195     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT195*                                                                         
ACT195     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
ACT195         CONTINUE                                                 
ACT195     ELSE                                                         
ACT195         DISPLAY '************ ABENDING ************'             
ACT195         DISPLAY '** 7999-CLOSE-ACCT-RANGE    **'                 
ACT195         DISPLAY '** SQLCODE IS ', WS-ACTIVE-RETURN-CODE          
ACT195         DISPLAY '**     PROCESSING TERMINATED    **'             
ACT195         DISPLAY '************ PCSCA130 ************'             
ACT195         PERFORM 9900-ABEND THRU 9900-EXIT                        
ACT195     END-IF.                                                      
ACT195*                                                                         
ACT195 7999-EXIT.                                                       
ACT195     EXIT.                                                        
ACT195*                                                                         
ACT194*****************************************************************         
ACT193     EXEC SQL                                                             
ACT193         INCLUDE CPD00038                                                 
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193     EXEC SQL                                                             
ACT193         INCLUDE CPD00039                                                 
ACT193     END-EXEC.                                                            
ACT193*                                                                         
ACT193     EXEC SQL                                                             
ACT193         INCLUDE CPD00074                                                 
ACT193     END-EXEC.                                                            
ACT193******************************************************************        
ACT193**  9000-TERMINATE.                                             **        
ACT193******************************************************************        
ACT193*                                                                         
ACT193 9000-TERMINATE.                                                  
ACT193*                                                                         
ACT193     DISPLAY '9000-TERMINATE'.                                    
ACT193*                                                                         
ACT193 9000-EXIT.                                                       
ACT193     EXIT.                                                        
ACT193*                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
ACT193*                                                                         
ACT193     EXEC SQL                                                             
ACT193       INCLUDE CPD0023B                                                   
ACT193     END-EXEC.                                                            
                                                                        
