       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSCA013.                                         
       AUTHOR.        ROGER D. FAULK                                    
       DATE-WRITTEN.  AUGUST 2015.                                      
       DATE-COMPILED.                                                   
      *                                                                         
      ****************************************************************          
      **              SOUTH CAROLINA ELECTRIC & GAS                 **          
      **                         DB2                                **          
      ****************************************************************          
      *  COMMENTS: THIS PROGRAM CHECKS THE STATUS OF RESTART-REQ     *          
      *            FLAG ON CSS_JOB_PARM TABLE FOR THE PROGRAM NAME   *          
      *            GIVEN ON THE JCL PARM, VIA DATA MEMBER.           *          
      *            DATA MEMBER - WILL HAVE THE PROGRAM NAME AND      *          
      *            THE STATUS THAT WOULD CAUSE THE PROGRAM TO ABEND. *          
      *             EXAMPLE:                                         *          
      *                A PROGRAM THAT USED THE OLD CSR013            *          
      *                        PARM('PCSBW171 A') -                  *          
      *                A PROGRAM THAT USED THE OLD CSR006            *          
      *                        PARM('PCSBW182 I') -                  *          
      *            THIS IS A COBOL RE-WRITE FOR EXTRIEVE PROGRAMS    *          
      *            CSR013 AND CSR006.                                *          
      ****************************************************************          
      **                                                            **          
      **              PROGRAM  MODIFICATION  LOG                    **          
      **                                                            **          
      ** DATE       INITIALS       REASON                           **          
      **                                                            **          
      **  8/14/2015 RF10596        REWRITE CSR013 (EZTRIEVE) INTO   **          
      **                           A COBOL PROGRAM.                 **          
      **                                                            **          
      ****************************************************************          
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA013'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-MISCELLANEOUS.                                             
          03 WS-PROGRAM-NAME         PIC X(8)  VALUE SPACES.            
          03 WS-COMPANY-NO           PIC XX    VALUE '01'.              
          03 WS-CMND-CODE            PIC X(4)  VALUE 'PARM'.            
          03 WS-PARM-DATA            PIC X(13) VALUE 'RESTART-REQ=Y'.   
          03 WS-STATUS               PIC X     VALUE SPACES.            
          03 WS-PARM-STATUS          PIC X     VALUE SPACES.            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *    DCLGEN FOR CSS_JOB_PARM -  G6                             *          
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  WS-PARM-VALUE.                                               
           05 WS-PARMVAL-LENGTH             PIC S9(4) COMP.             
           05 WS-PROGRAM-PARM               PIC X(8).                   
           05 FILLER                        PIC X.                      
           05 WS-STATUS-CODE                PIC X.                      
      *                                                                         
       PROCEDURE DIVISION USING WS-PARM-VALUE.                          
      *                                                                         
       0000-MAIN-PARA.                                                  
      *                                                                         
           MOVE WS-PROGRAM-PARM TO WS-PROGRAM-NAME.                     
           MOVE WS-STATUS-CODE  TO WS-PARM-STATUS.                      
      *                                                                         
           PERFORM 2000-CHECK-STATUS THRU 2000-EXIT.                    
      *                                                                         
           IF WS-STATUS = WS-PARM-STATUS                                
              DISPLAY '**********************************************'  
              DISPLAY '*        PROCESSING TERMINATED               *'  
              DISPLAY '*                                            *'  
              DISPLAY '* STATUS OF RESTART-REQ FLAG ON JOB_PARM     *'  
              DISPLAY '*   TABLE IS EQUAL TO INPUT PARM STATUS.     *'  
              DISPLAY '*                                            *'  
              DISPLAY '* STATUS ON CSS_JOB_PARM ROW (RESTART-REQ=Y) *'  
              DISPLAY '*                                            *'  
              DISPLAY '*  IF = A, CHANGE IT TO I.                   *'  
              DISPLAY '*  IF = I, CHANGE IT TO A.                   *'  
              DISPLAY '*                                            *'  
              DISPLAY '*  RESUBMIT THE JOB AFTER MAKING THE CHANGE  *'  
              DISPLAY '*                                            *'  
              DISPLAY '*PROGRAM NAME            = ' WS-PROGRAM-NAME     
              DISPLAY '*DATA MEMBER PARM STATUS = ' WS-PARM-STATUS      
              DISPLAY '*JOB PARM TABLE STATUS   = ' WS-STATUS           
              DISPLAY '**********************************************'  
              MOVE +12 TO RETURN-CODE                                   
           END-IF.                                                      
      *                                                                         
           PERFORM 9000-TERMINATE THRU 9000-EXIT.                       
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CHECK STATUS ON CSS_JOB_PARM                                *          
      ****************************************************************          
      *                                                                         
       2000-CHECK-STATUS.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT STATUS                                             
                INTO :WS-STATUS                                         
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
               WHERE  PROGRAM_NAME = :WS-PROGRAM-NAME                   
                 AND  COMPANY_NO   = :WS-COMPANY-NO                     
                 AND  CMND_CODE    = :WS-CMND-CODE                      
                 AND  PARM_DATA    = :WS-PARM-DATA                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STATUS                                                     
MFA-TR*         INTO :WS-STATUS                                                 
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*        WHERE  PROGRAM_NAME = :WS-PROGRAM-NAME                           
MFA-TR*          AND  COMPANY_NO   = :WS-COMPANY-NO                             
MFA-TR*          AND  CMND_CODE    = :WS-CMND-CODE                              
MFA-TR*          AND  PARM_DATA    = :WS-PARM-DATA                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = +0                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              IF SQLCODE = +100                                         
                 DISPLAY '******************************************'   
                 DISPLAY '*    PCSCA013 PROCESSING ERROR           *'   
                 DISPLAY '*      2000-CHECK-STATUS                 *'   
                 DISPLAY '*DATA MEMBER NOT FOUND ON JOB-PARM TABLE *'   
                 DISPLAY '*PROGRAM NAME = ' WS-PROGRAM-NAME             
                 DISPLAY '*   SQLCODE  = ' SQLCODE                      
                 DISPLAY '*         JOB TERMINATING                *'   
                 DISPLAY '******************************************'   
                 MOVE +12 TO RETURN-CODE                                
              ELSE                                                      
                 DISPLAY '******************************************'   
                 DISPLAY '*      PCSCA013 PROCESSING ERROR         *'   
                 DISPLAY '*      2000-CHECK-STATUS                 *'   
                 DISPLAY '*PROGRAM NAME = ' WS-PROGRAM-NAME             
                 DISPLAY '*   SQLCODE  = ' SQLCODE                      
                 DISPLAY '*         JOB TERMINATING                *'   
                 DISPLAY '******************************************'   
                 MOVE +12 TO RETURN-CODE                                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * JOB TERMINATION - NORMAL AND ABNORMAL                        *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
