       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       PCSCA011.                                      
COB303 DATE-WRITTEN.     OCT 19, 2015.                                  
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*        
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --*        
      *----------------------------------------------------------------*        
      *--                         S U M M A R Y                      --*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                                                            --*        
      *----------------------------------------------------------------*        
      *--                        MODIFICATION LOG                    --*        
      *--                                                            --*        
      *--  DATE          INITIALS    COMMENTS                        --*        
      *--  -----------   --------    ----------------------------------*        
A05268*--  08/14/2015    MR7E794     CONVERTED THE EZT PGM SEB004 TO --*        
A05268*--                ACT029      COBOL.                          --*        
A05136*--  12/28/2015    MR7E794     IF SPECTRUM AND AGL FILE IS NOT --*        
A05136*--                ACT261      MATCHING MORE THAN 200 RECORD   --*        
A05136*--                            ABEND THE PROGRAM.                         
      *----------------------------------------------------------------*        
      *                                                                *        
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
      ******************************************************************        
      * INPUT FILE                                                     *        
      ******************************************************************        
           SELECT FCSAGL11-FILE                                         
               ASSIGN UT-S-FCSAGL11                                     
               FILE STATUS IS WS-FCSAGL11-STATUS.                       
      *                                                                         
      ******************************************************************        
      * INPUT FILE                                                     *        
      ******************************************************************        
           SELECT FCSFNL11-FILE                                         
               ASSIGN UT-S-FCSFNL11                                     
               FILE STATUS IS WS-FCSFNL11-STATUS.                       
      *                                                                         
      ******************************************************************        
      * OUTPUT FILE                                                    *        
      ******************************************************************        
           SELECT FCSMATCH-FILE                                         
               ASSIGN UT-S-FCSMATCH.                                    
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ***************************************************************           
      *  - FD SECTION & LAYOUT FOR REPORT OUTPUT FILE               *           
      ***************************************************************           
      ** - FILE DESCRIPTION FOR THE FILE FCSAGL11                  **           
      ***************************************************************           
       FD  FCSAGL11-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
      ******************************************************************        
      * FIOAGL11 - FILE LAYOUT FOR FCSAGL11                            *        
      ******************************************************************        
      *                                                                         
       01 FIOAGL11.                                                     
          02 FIOAGL11-REC.                                              
             05 IN1-AGL-ACCT           PIC X(10).                       
             05 IN1-ZIP                PIC X(5).                        
             05 IN1-FIN1-ZIP           PIC X(5).                        
             05 IN1-FIN1-ZIP4          PIC X(4).                        
             05 FILLER                 PIC X(126).                      
      *                                                                         
      ***************************************************************           
      ** - FILE DESCRIPTION FOR THE FILE FCSFNL11                  **           
      ***************************************************************           
      *                                                                         
       FD  FCSFNL11-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
      ******************************************************************        
      * FIOFNL11 - FILE LAYOUT FOR FCSFNL11                            *        
      ******************************************************************        
      *                                                                         
       01 FIOFNL11.                                                     
          02 FIOFNL11-REC.                                              
             05 FILLER                 PIC X(57).                       
             05 IN2-AGL-ACCT           PIC X(10).                       
             05 FILLER                 PIC X(899).                      
      *                                                                         
      ***************************************************************           
      ** - FILE DESCRIPTION FOR THE FILE FCSMATCH                  **           
      ***************************************************************           
       FD  FCSMATCH-FILE                                                
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE OMITTED.                                   
      *                                                                         
      ******************************************************************        
      * FIOMATCH - FILE LAYOUT FOR FCSMATCH                            *        
      ******************************************************************        
      *                                                                         
       01 FIOMATCH.                                                     
          02 FIOMATCH-REC              PIC X(995).                      
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA011'.
MSQ017     COPY MFASQLM.
      *                                                                         
      ***************************************************************           
      *    DB2 INCLUDES                                             *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_MKT_XREF_ACCT  XM                                    *           
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMRKXR                                                   
           END-EXEC.                                                            
      *                                                                         
      *                                                             *           
      ***************************************************************           
      *                                                                         
       01 WS-LITERALS.                                                  
           05 WS-PROGRAM                PIC X(08) VALUE 'PCSCA011'.     
      *                                                                         
       01 WS-MISC.                                                      
           05 WS-ACCOUNT-CT             PIC 9(07) COMP-3 VALUE 0.       
           05 WS-ACCOUNT-HIT            PIC 9(07) COMP-3 VALUE 0.       
           05 WS-ADDR-MATCH             PIC 9(07) COMP-3 VALUE 0.       
           05 WS-ZIP-CHANGE             PIC 9(07) COMP-3 VALUE 0.       
           05 WS-ACCOUNT-CT-Z           PIC Z(07).                      
           05 WS-ACCOUNT-HIT-Z          PIC Z(07).                      
           05 WS-ADDR-MATCH-Z           PIC Z(07).                      
           05 WS-ZIP-CHANGE-Z           PIC Z(07).                      
           05 WS-ACCT-PCT               PIC 9(4)V9(3).                  
           05 WS-ZIPCH-PCT              PIC 9(4)V9(3).                  
           05 WS-MATCH-PCT              PIC 9(4)V9(3).                  
           05 WS-ACCT-PCT-DEC           PIC Z(4).9(3).                  
           05 WS-ZIPCH-PCT-DEC          PIC Z(4).9(3).                  
           05 WS-MATCH-PCT-DEC          PIC Z(4).9(3).                  
           05 WS-MKT-ACCT               PIC X(20)                       
                                        VALUE '00000000000000000000'.   
           05 WS-ERROR                  PIC X(07) VALUE SPACES.         
           05 WS-Y                      PIC X(01) VALUE 'Y'.            
ACT261     05 WS-UNMATCH-CNT            PIC S9(5) COMP-3 VALUE +0.      
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-FCSAGL11-STATUS       PIC X(02) VALUE '00'.           
               88 FCSAGL11-SUCCESSFUL             VALUE '00'.           
               88 FCSAGL11-EOF                    VALUE '10'.           
      *                                                                         
           05  WS-FCSFNL11-STATUS       PIC X(02) VALUE '00'.           
               88 FCSFNL11-SUCCESSFUL             VALUE '00'.           
               88 FCSFNL11-EOF                    VALUE '10'.           
      *                                                                         
       COPY FIOAGLFL.                                                           
       COPY CWS09900.                                                           
       COPY CWS00303.                                                           
      *                                                                         
      ******************************************************************        
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZATION              THRU 0100-EXIT.     
           PERFORM 7000-READ-FCSAGL11               THRU 7000-EXIT.     
           PERFORM 7050-READ-FCSFNL11               THRU 7050-EXIT.     
           PERFORM 1000-MAIN-PROCESS                THRU 1000-EXIT      
             UNTIL FCSAGL11-EOF OR FCSFNL11-EOF.                        
                                                                        
           PERFORM 2500-DISPLAY-TOTALS              THRU 2500-EXIT.     
           PERFORM 9000-TERMINATE                   THRU 9000-EXIT.     
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 0100-INITIALIZATION                                         **         
      ** OPEN FILES                                                             
      ******************************************************************        
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT  FCSAGL11-FILE.                                   
           OPEN INPUT  FCSFNL11-FILE.                                   
                                                                        
           OPEN OUTPUT FCSMATCH-FILE.                                   
                                                                        
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 1000-MAIN-PROCESS                                            **        
      ******************************************************************        
      *                                                                         
       1000-MAIN-PROCESS.                                               
      *                                                                         
           IF IN1-AGL-ACCT = IN2-AGL-ACCT                               
              PERFORM 2000-PROCESS-MATCHED          THRU 2000-EXIT      
           ELSE                                                         
              DISPLAY 'AGL FILE ACCOUNT NO: ' IN1-AGL-ACCT              
              DISPLAY 'SPECTRUM FILE ACCOUNT NO: ' IN2-AGL-ACCT         
              DISPLAY 'NO AGL AND SPECTRUM FILE MATCH'                  
              MOVE 'Y' TO WS-ERROR-FLAG                                 
ACT261        ADD 1 TO WS-UNMATCH-CNT                                   
ACT261        IF WS-UNMATCH-CNT > 200                                   
ACT261          DISPLAY '**********************************************'
ACT261          DISPLAY 'NO AGL AND SPECTRUM FILE MATCH:' WS-UNMATCH-CNT
ACT261          DISPLAY 'SPECTRUM AND AGL FILE IS NOT MATCHING '                
ACT261-                 'FURTHER ANALYSIS REQUIRED'                             
ACT261          DISPLAY '**********************************************'
ACT261           MOVE 12 TO RETURN-CODE                                 
ACT261           PERFORM 9900-ABEND THRU 9900-EXIT                      
ACT261        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 2000-PROCESS-MATCHED                                        **         
      ******************************************************************        
      *                                                                         
       2000-PROCESS-MATCHED.                                            
      *                                                                         
           COMPUTE WS-ACCOUNT-CT = WS-ACCOUNT-CT + 1                    
           MOVE FIOFNL11-REC        TO AGL-ACCOUNT-INFO                 
           MOVE IN1-AGL-ACCT        TO WS-MKT-ACCT(11:10)               
           MOVE WS-MKT-ACCT         TO XM-DIST-ACCT-NO                  
           PERFORM 7100-SELECT-MKT-XRF-ACC          THRU 7100-EXIT.     
                                                                        
           IF IN1-FIN1-ZIP > '00000'                                    
              MOVE IN1-FIN1-ZIP      TO AGL-ZIP-CODE                    
              MOVE IN1-FIN1-ZIP4     TO AGL-ZIP-PLUS-4                  
              COMPUTE WS-ADDR-MATCH = WS-ADDR-MATCH + 1                 
              IF IN1-ZIP NOT EQUAL IN1-FIN1-ZIP                         
                 COMPUTE WS-ZIP-CHANGE = WS-ZIP-CHANGE + 1              
              END-IF                                                    
           ELSE                                                         
              MOVE IN1-ZIP           TO AGL-ZIP-CODE                    
              MOVE '    '            TO AGL-ZIP-PLUS-4                  
           END-IF.                                                      
                                                                        
           MOVE AGL-ACCOUNT-INFO     TO FIOMATCH-REC.                   
                                                                        
           PERFORM 8000-WRITE-FCSMATCH              THRU 8000-EXIT.     
      *                                                                         
           PERFORM 7000-READ-FCSAGL11               THRU 7000-EXIT.     
           PERFORM 7050-READ-FCSFNL11               THRU 7050-EXIT.     
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  2500-DISPLAY-TOTALS                                         **        
      **                                                              **        
      ******************************************************************        
       2500-DISPLAY-TOTALS.                                             
      *                                                                         
           COMPUTE WS-ACCT-PCT = WS-ACCOUNT-HIT / WS-ACCOUNT-CT + 0.0005
           COMPUTE WS-MATCH-PCT = WS-ADDR-MATCH / WS-ACCOUNT-CT + 0.0005
           COMPUTE WS-ZIPCH-PCT = WS-ZIP-CHANGE / WS-ACCOUNT-CT + 0.0005
                                                                        
           MOVE WS-ACCOUNT-CT TO WS-ACCOUNT-CT-Z.                       
           DISPLAY WS-ACCOUNT-CT-Z  ' ACCOUNTS PROCESSED'.              
           IF WS-MATCH-PCT < .90                                        
               MOVE '*ERROR*' TO WS-ERROR                               
               MOVE 'Y'       TO WS-ERROR-FLAG                          
           END-IF.                                                      
                                                                        
           MOVE WS-ADDR-MATCH TO WS-ADDR-MATCH-Z.                       
           MOVE WS-MATCH-PCT  TO WS-MATCH-PCT-DEC.                      
           DISPLAY WS-ADDR-MATCH-Z  ' ADDRESS MATCHES ' WS-MATCH-PCT-DEC
                   ' ' WS-ERROR.                                        
           MOVE SPACES        TO WS-ERROR.                              
           IF WS-ACCT-PCT < .10                                         
               MOVE '*ERROR*' TO WS-ERROR                               
               MOVE 'Y'       TO WS-ERROR-FLAG                          
           END-IF.                                                      
                                                                        
           MOVE WS-ACCOUNT-HIT TO WS-ACCOUNT-HIT-Z.                     
           MOVE WS-ACCT-PCT    TO WS-ACCT-PCT-DEC.                      
           DISPLAY WS-ACCOUNT-HIT-Z ' ACCOUNT MATCHES ' WS-ACCT-PCT-DEC 
                   ' ' WS-ERROR.                                        
           MOVE SPACES        TO WS-ERROR.                              
           IF WS-ZIPCH-PCT > .10                                        
               MOVE '*ERROR*' TO WS-ERROR                               
               MOVE 'Y'       TO WS-ERROR-FLAG                          
           END-IF.                                                      
                                                                        
           MOVE WS-ZIP-CHANGE TO WS-ZIP-CHANGE-Z.                       
           MOVE WS-ZIPCH-PCT  TO WS-ZIPCH-PCT-DEC.                      
           DISPLAY WS-ZIP-CHANGE-Z  ' ZIP CHANGES     ' WS-ZIPCH-PCT-DEC
                   ' ' WS-ERROR.                                        
                                                                        
           IF WS-ERROR-FLAG = 'Y'                                       
               MOVE 12 TO RETURN-CODE                                   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7000-READ-FCSAGL11                                          **        
      **                                                              **        
      ******************************************************************        
       7000-READ-FCSAGL11.                                              
      *                                                                         
           MOVE '7000'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSAGL11-FILE.                                          
                                                                        
           IF FCSAGL11-SUCCESSFUL  OR  FCSAGL11-EOF                     
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSCA011 ABORT *********'          
               DISPLAY '** ERROR IN READING FCSAGL11 FILE ***'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FCSAGL11-STATUS          
               DISPLAY '**  PROCESSING TERMINATED          **'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7050-READ-FCSFNL11                                          **        
      **                                                              **        
      ******************************************************************        
       7050-READ-FCSFNL11.                                              
      *                                                                         
           MOVE '7050'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           READ FCSFNL11-FILE.                                          
                                                                        
           IF FCSFNL11-SUCCESSFUL  OR  FCSFNL11-EOF                     
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '************ PCSCA011 ABORT *********'          
               DISPLAY '** ERROR IN READING FCSFNL11 FILE ***'          
               DISPLAY '** PARAGRAPH - ' WS-ACTIVE-PARAGRAPH            
               DISPLAY '** FILE STATUS IS ' WS-FCSFNL11-STATUS          
               DISPLAY '**  PROCESSING TERMINATED          **'          
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  7100-SELECT-MKT-XRF-ACC                                     **        
      **                                                              **        
      ******************************************************************        
       7100-SELECT-MKT-XRF-ACC.                                         
           MOVE '7100'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
            SELECT TOP(1) XM.ACCOUNT_NO                                        
            INTO :XM-ACCOUNT-NO                                         
            FROM CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)                     
            WHERE DIST_ACCT_NO = :XM-DIST-ACCT-NO                       
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT XM.ACCOUNT_NO                                                
MFA-TR*     INTO :XM-ACCOUNT-NO                                                 
MFA-TR*     FROM CSS_MKT_XREF_ACCT XM                                           
MFA-TR*     WHERE DIST_ACCT_NO = :XM-DIST-ACCT-NO                               
MFA-TR*     FETCH FIRST ROW ONLY                                                
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE XM-ACCOUNT-NO         TO AGL-CIS-ACCOUNT-NO          
              COMPUTE WS-ACCOUNT-HIT = WS-ACCOUNT-HIT + 1               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS              TO AGL-CIS-ACCOUNT-NO          
              ELSE                                                      
                 DISPLAY 'PCSCA011 - FETCH SQLCODE = ' SQLCODE          
                 DISPLAY ' ACCOUNT NO              = ' WS-MKT-ACCT      
                 MOVE 12                 TO RETURN-CODE                 
                 PERFORM 9900-ABEND THRU 9900-EXIT                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  8000-WRITE-FCSMATCH                                         **        
      ******************************************************************        
      *                                                                         
       8000-WRITE-FCSMATCH.                                             
      *                                                                         
           WRITE FIOMATCH.                                              
                                                                        
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  9000-TERMINATE.                                             **        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSAGL11-FILE.                                         
           CLOSE FCSFNL11-FILE.                                         
           CLOSE FCSMATCH-FILE.                                         
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ************************************************************              
      *                                                          *              
      * COPYBOOK FOR ABEND ROUTINE                               *              
      *                                                          *              
      ************************************************************              
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
                                                                        
