       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA010.                                          
                                                                        
      ******************************************************************        
      *               SOUTH CAROLINA ELECTRIC AND GAS                  *        
      *                                                                *        
      *                CUSTOMER INFORMATION SYSTEM                     *        
      *                                                                *        
      ******************************************************************        
      *                P R O G R A M  S U M M A R Y                    *        
      *  READ THE FTP LOG, CHECKING FOR MESSAGE CODES:                 *        
      *  MESSAGE 221 INDICATES THE END OF THE FTP LOG, AND WE NEVER    *        
      *              ENCOUNTERED THE 'SUCCESSFUL TRANSMISSION' CODE.   *        
      *              THIS IS A FAILURE.                                *        
      *  MESSAGE 226 INDICATES THE FTP WAS PROBABLY SUCCESSFUL, BUT    *        
      *              CHECKS THE SUBSEQUENT VERBIAGE TO DOUBLE CHECK.   *        
      *              IT'S SOMETHING OTHER THAN WHAT WE EXPECT, FAILURE.*        
      *  MESSAGE 250 CERTAIN MESSAGES ARE EXPECTED WITH THIS CODE.  IF *        
      *              IT'S SOMETHING ELSE, IT'S A FAILURE               *        
      *  MESSAGE 426, 530, AND 550 ARE ERRORS, REGARDLESS OF THE       *        
      *              VERBIAGE.                                         *        
      ******************************************************************        
      *                                                                *        
      *              PROGRAM  MODIFICATION  LOG                        *        
      *                                                                *        
      *    DATE     INITIALS  REASON                                   *        
      *    ----     --------  ------                                   *        
      *  09/03/2013 BD09555   ADD 426 AS AN ERROR CODE                 *        
      *  12/19/2013 BD09555   ADD ADDITIONAL VERBIAGE FOR MESSAGE 250  *        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT INFILE   ASSIGN TO INFILE.                            
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       FD  INFILE                                                       
           RECORDING MODE IS U.                                         
       01  INFILE-REC.                                                  
           05  IN-MESSAGE-CODE           PIC XXX.                       
               88  TRANSFER-COMPLETE                VALUE '226'.        
               88  CHANGE-DELETE-CODE               VALUE '250'.        
               88  TRANSFER-ERROR                   VALUE '221' '426'   
                                                          '530' '550'.  
           05  FILLER                    PIC X.                         
           05  IN-MESSAGE                PIC X(24).                     
           05  FILLER                    PIC X(105).                    
       WORKING-STORAGE SECTION.                                         
       77  WS-TALLY                      PIC S9(4)   COMP.              
       77  WS-COMPLETION                 PIC X            VALUE 'N'.    
           88  UNSUCCESSFUL-TRANSFER                      VALUE 'N'.    
       77  WS-EOF                        PIC X            VALUE 'N'.    
           88  END-OF-FILE                                VALUE 'Y'.    
       PROCEDURE DIVISION.                                              
           OPEN INPUT INFILE.                                           
           PERFORM 1000-READ-MESSAGE-FILE      THRU 1000-EXIT.          
           PERFORM UNTIL END-OF-FILE                                    
               PERFORM 0100-PROCESS-MESSAGES   THRU 0100-EXIT           
               PERFORM 1000-READ-MESSAGE-FILE  THRU 1000-EXIT           
           END-PERFORM.                                                 
           CLOSE INFILE.                                                
           IF UNSUCCESSFUL-TRANSFER                                     
               DISPLAY 'PCSCA010 - UNSUCCESSFUL TRANSFER - CHECK '      
                       'MESSAGE LOG'                                    
               MOVE +16 TO RETURN-CODE                                  
           END-IF.                                                      
           STOP RUN.                                                    
        0100-PROCESS-MESSAGES.                                          
           EVALUATE TRUE                                                
               WHEN TRANSFER-COMPLETE                                   
                   IF IN-MESSAGE (1:17) = 'Transfer complete'        OR 
                      IN-MESSAGE (1:23) = 'ASCII Transfer complete'  OR 
                      IN-MESSAGE (1:23) = 'Transfer complete - ack'  OR 
                      IN-MESSAGE (1:24) = ' Transfer complete - ack' OR 
                      IN-MESSAGE (1:13) = 'File sent ok.'               
                          MOVE 'Y' TO WS-COMPLETION                     
                   ELSE                                                 
                      DISPLAY 'UNEXPECTED WORDING WITH MESSAGE 226: '   
                         IN-MESSAGE                                     
                      MOVE 'Y' TO WS-EOF                                
                   END-IF                                               
               WHEN CHANGE-DELETE-CODE                                  
                   IF IN-MESSAGE (1:22) = 'CWD command successful'  OR  
                      IN-MESSAGE (1:23) = 'DELE command successful'     
                           NEXT SENTENCE                                
                   ELSE                                                 
                      MOVE +0 TO WS-TALLY                               
                      INSPECT INFILE-REC TALLYING WS-TALLY              
                          FOR ALL 'is new cwd'                          
                      IF WS-TALLY = 0                                   
                         DISPLAY 'UNEXPECTED WORDING WITH MESSAGE 226: '
                             IN-MESSAGE                                 
                         MOVE 'Y' TO WS-EOF                             
                      END-IF                                            
                   END-IF                                               
               WHEN TRANSFER-ERROR                                      
                   MOVE 'Y' TO WS-EOF                                   
           END-EVALUATE.                                                
       0100-EXIT.                                                       
           EXIT.                                                        
       1000-READ-MESSAGE-FILE.                                          
           READ INFILE AT END                                           
               MOVE 'Y' TO WS-EOF.                                      
       1000-EXIT.                                                       
           EXIT.                                                        
