       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA009.                                        
       AUTHOR.        SAKTHIVEL MATHIYAZHAGAN                           
       DATE-WRITTEN.  OCTOBER 13, 2015.                                 
                                                                        
      ******************************************************************        
      *                   CUSTOMER SERVICE SYSTEM                      *        
      ******************************************************************        
      *                                                                *        
      *    CONVERT FREEFORM AND FORMATTED ADDRESSES INTO A COMMON      *        
      *    FORMAT.  CLONED FROM PCSCA368. USED IN JOB CSRC376.         *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *               M A I N T E N A N C E   L O G                    *        
      *                                                                *        
      *   DATE      INITIALS     COMMENTS                              *        
      *  ------     -------      --------------------------------      *        
PRJ910* 10-13-2015  SM93554      INTIALLY WRITTEN.                     *        
ACT105* 03-28-2016  BD09555      INCREASE ACCUMULATORS.  CHANGE ADDRESS*        
      *A05460-ACT105             ID IN OUTPUT TO DISPLAY FORMAT        *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.  IBM-370.                                       
       OBJECT-COMPUTER.  IBM-370.                                       
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSB3681.                                                           
       COPY CSSB3682.                                                           
       COPY CSSB3683.                                                           
       COPY CSSB3684.                                                           
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDB3681.                                                           
       01 INFILEU-FREE-RECORD.                                          
          05 E-ADDRESS-ID-FREE               PIC S9(13)V COMP-3.        
          05 E-ADDR-STREET-FREE              PIC X(55).                 
          05 E-ADDR-CITY-STATE-FREE          PIC X(30).                 
          05 E-ZIP-CODE-FREE                 PIC X(09).                 
          05 E-ADDR-COUNTRY-FREE             PIC X(35).                 
          05 E-ADDRESS-OVERFLOW-FREE         PIC X(35).                 
          05 E-ZIP-TOKEN-FREE                PIC X(01).                 
          05 E-DELIVERY-POINT-FREE           PIC X(02).                 
          05 E-CARRIER-ROUTE-FREE            PIC X(05).                 
          05 E-FILLER                        PIC X(86).                 
                                                                        
       COPY CFDB3682.                                                           
       01 INFILEF-FORM-RECORD.                                          
          05 E-ADDRESS-ID-FORM               PIC S9(13)V COMP-3.        
          05 E-ADDR-LINE1-FORM               PIC X(61).                 
          05 E-ADDR-LINE2-FORM               PIC X(16).                 
          05 E-ZIP-CODE-FORM                 PIC X(05).                 
          05 E-ZIP-PLUS4-FORM                PIC X(04).                 
          05 E-DELIV-PT-FORM                 PIC X(02).                 
          05 E-CITY-FORM                     PIC X(26).                 
          05 E-FILLER-FORM                   PIC X(01).                 
          05 E-STATE-FORM                    PIC X(02).                 
          05 E-ZIP-TOKEN-FORM                PIC X(01).                 
          05 E-FILLER                        PIC X(04).                 
                                                                        
       COPY CFDB3683.                                                           
       01 OUTFILE1-FREE-RECORD.                                         
ACT105    05 E-ADDRESS-ID-OUT                PIC 9(13).                 
          05 E-ADDR-LINE1-OUT                PIC X(61).                 
          05 E-ADDR-LINE2-OUT                PIC X(35).                 
          05 E-CITY-STATE-OUT                PIC X(30).                 
          05 E-ZIP5-PLUS4-OUT                PIC X(09).                 
          05 E-DELIV-PT-OUT                  PIC X(02).                 
          05 E-ZIP-TOKEN-OUT                 PIC X(01).                 
                                                                        
       COPY CFDB3684.                                                           
       01 OUTFILE2-FORM-RECORD.                                         
ACT105    05 E-ADDRESS-ID-OUT2               PIC 9(13).                 
          05 E-ADDR-LINE1-OUT2               PIC X(61).                 
          05 E-ADDR-LINE2-OUT2               PIC X(35).                 
          05 E-CITY-OUT2                     PIC X(27).                 
          05 E-STATE-OUT2                    PIC X(02).                 
          05 E-FILLER-OUT2                   PIC X(01).                 
          05 E-ZIP5-OUT2                     PIC X(05).                 
          05 E-ZIP4-OUT2                     PIC X(04).                 
          05 E-DELIV-PT-OUT2                 PIC X(02).                 
          05 E-ZIP-TOKEN-OUT2                PIC X(01).                 
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       01  WS-START                    PIC X(40)  VALUE                 
           'WORKING STORAGE FOR PCSCA009 STARTS HERE'.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-EOJ-CODE             PIC S9(4)   VALUE +0   COMP.     
           05  PROGRAM-NAME            PIC X(08)  VALUE 'PCSCA009'.     
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-USA                  PIC X(03)  VALUE 'USA'.          
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
                                                                        
       01  WS-FILE-STATUS.                                              
           05  WS-INFILEU-STATUS       PIC X(02).                       
               88 INFILEU-SUCCESSFUL              VALUE '00'.           
           05  WS-INFILEF-STATUS       PIC X(02).                       
               88 INFILEF-SUCCESSFUL              VALUE '00'.           
           05  WS-OUTFILE1-STATUS      PIC X(02).                       
               88 OUTFILE1-SUCCESSFUL             VALUE '00'.           
           05  WS-OUTFILE2-STATUS      PIC X(02).                       
               88 OUTFILE2-SUCCESSFUL             VALUE '00'.           
                                                                        
       01  WS-EOF-PROCESSING.                                           
           05  WS-END-OF-INFILEU-FREE  PIC X(01)  VALUE 'N'.            
               88 END-OF-INFILEU-FREE             VALUE 'Y'.            
           05  WS-END-OF-INFILEF-FORM  PIC X(01)  VALUE 'N'.            
               88 END-OF-INFILEF-FORM             VALUE 'Y'.            
                                                                        
       01  WS-COUNTERS.                                                 
ACT105     05  WS-READ-CNT-FREE        PIC S9(07) COMP-3 VALUE +0.      
ACT105     05  WS-DROP-CNT-FREE        PIC S9(07) COMP-3 VALUE +0.      
ACT105     05  WS-READ-CNT-FORM        PIC S9(07) COMP-3 VALUE +0.      
                                                                        
       01  WS-ABEND-PARA.                                               
           05  WS-PARAGRAPH            PIC X(30)  VALUE SPACE.          
           05  WS-PROGRAM-ID           PIC X(08)  VALUE 'PCSCA009'.     
           05  WS-DISPLAY-KEY          PIC S9(13)V COMP-3 VALUE 0.      
                                                                        
                                                                        
       01  WS-END                      PIC X(40)  VALUE                 
           'WORKING STORAGE FOR PCSCA009 ENDS HERE'.                    
                                                                        
                                                                        
      *****************************************************************         
      *            P R O C E D U R E   D I V I S I O N                *         
      *****************************************************************         
       PROCEDURE DIVISION.                                              
                                                                        
      *****************************************************************         
      *                                                               *         
      *     0000-MAINLINE                                             *         
      *****************************************************************         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIATE-PROCESSING          THRU 0100-EXIT.    
                                                                        
      *    FREEFORM ADDRESS.                                                    
           PERFORM 7500-READ-INFILE-FREE             THRU 7500-EXIT.    
           PERFORM 1000-PROCESS-FREEFROM-ADDR        THRU 1000-EXIT     
             UNTIL END-OF-INFILEU-FREE.                                 
                                                                        
      *    FOMRATTED ADDRESS.                                                   
           PERFORM 7600-READ-INFILE-FORM             THRU 7600-EXIT.    
           PERFORM 1500-PROCESS-FORMATTED-ADDR       THRU 1500-EXIT     
             UNTIL END-OF-INFILEF-FORM.                                 
                                                                        
      *    DISPLAY THE RESULTS                                                  
           DISPLAY '** FREEFORM ADDRESSES  **'                          
           DISPLAY '** READ ADDRESS CNT = ' WS-READ-CNT-FREE            
           DISPLAY '** DROP ADDRESS CNT = ' WS-DROP-CNT-FREE            
                                                                        
           DISPLAY '** FORMATTED ADDRESSES **'                          
           DISPLAY '** READ ADDRESS CNT = ' WS-READ-CNT-FORM            
                                                                        
           PERFORM 9700-TERMINATE                    THRU 9700-EXIT.    
           DISPLAY '** PCSCA009 PROCESSING COMPLETED SUCCESSFULLY **'.  
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 0100-INITIATE-PROCESSING.                                     *         
      *****************************************************************         
       0100-INITIATE-PROCESSING.                                        
                                                                        
           MOVE '0100'                        TO WS-PARAGRAPH           
                                                                        
           OPEN INPUT INFILEU-FREE.                                     
                                                                        
           IF NOT INFILEU-SUCCESSFUL                                    
               DISPLAY '************************************'           
               DISPLAY '**   PCSCA009 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING INFILEU      **'           
               DISPLAY '**     FILE STATUS =' WS-INFILEU-STATUS         
               DISPLAY '************************************'           
               PERFORM 9500-ABEND                THRU 9500-EXIT         
           END-IF.                                                      
                                                                        
           OPEN INPUT INFILEF-FORM.                                     
                                                                        
           IF NOT INFILEF-SUCCESSFUL                                    
               DISPLAY '************************************'           
               DISPLAY '**   PCSCA009 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING INFILEF      **'           
               DISPLAY '**     FILE STATUS =' WS-INFILEF-STATUS         
               DISPLAY '************************************'           
               PERFORM 9500-ABEND                THRU 9500-EXIT         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT OUTFILE1-FREE.                                   
                                                                        
           IF NOT OUTFILE1-SUCCESSFUL                                   
               DISPLAY '************************************'           
               DISPLAY '**   PCSCA009 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING OUTFILE1     **'           
               DISPLAY '**     FILE STATUS =' WS-OUTFILE1-STATUS        
               DISPLAY '************************************'           
               PERFORM 9500-ABEND                THRU 9500-EXIT         
           END-IF.                                                      
                                                                        
           OPEN OUTPUT OUTFILE2-FORM.                                   
                                                                        
           IF NOT OUTFILE2-SUCCESSFUL                                   
               DISPLAY '************************************'           
               DISPLAY '**   PCSCA009 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING OUTFILE2     **'           
               DISPLAY '**     FILE STATUS =' WS-OUTFILE2-STATUS        
               DISPLAY '************************************'           
               PERFORM 9500-ABEND                THRU 9500-EXIT         
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1000-PROCESS-FREEFROM-ADDR                                    *         
      *****************************************************************         
       1000-PROCESS-FREEFROM-ADDR.                                      
                                                                        
           PERFORM 2000-PROCESS-FOR-FREEFORM  THRU 2000-EXIT.           
           PERFORM 7500-READ-INFILE-FREE      THRU 7500-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1500-PROCESS-FORMATTED-ADDR.                                  *         
      *****************************************************************         
       1500-PROCESS-FORMATTED-ADDR.                                     
                                                                        
           INITIALIZE OUTFILE2-FORM-RECORD.                             
                                                                        
           COMPUTE WS-READ-CNT-FORM    = WS-READ-CNT-FORM + 1           
                                                                        
           MOVE E-ADDRESS-ID-FORM                  TO E-ADDRESS-ID-OUT2 
           MOVE E-ADDR-LINE1-FORM                  TO E-ADDR-LINE1-OUT2 
           MOVE E-ADDR-LINE2-FORM                  TO E-ADDR-LINE2-OUT2 
           MOVE E-ZIP-CODE-FORM                    TO E-ZIP5-OUT2       
           MOVE E-ZIP-PLUS4-FORM                   TO E-ZIP4-OUT2       
           MOVE E-DELIV-PT-FORM                    TO E-DELIV-PT-OUT2   
           MOVE E-CITY-FORM                        TO E-CITY-OUT2       
           MOVE E-STATE-FORM                       TO E-STATE-OUT2      
           MOVE E-ZIP-TOKEN-FORM                   TO E-ZIP-TOKEN-OUT2  
                                                                        
           PERFORM 7530-WRITE-OUTFILE2         THRU 7530-EXIT           
           PERFORM 7600-READ-INFILE-FORM       THRU 7600-EXIT.          
                                                                        
       1500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2000-PROCESS-FOR-FREEFORM                                     *         
      *****************************************************************         
       2000-PROCESS-FOR-FREEFORM.                                       
                                                                        
           INITIALIZE OUTFILE1-FREE-RECORD                              
                      WS-DISPLAY-KEY.                                   
                                                                        
           COMPUTE WS-READ-CNT-FREE    = WS-READ-CNT-FREE + 1           
           MOVE E-ADDRESS-ID-FREE                TO WS-DISPLAY-KEY      
                                                                        
           IF E-ADDR-STREET-FREE GREATER THAN SPACES OR                 
              E-ADDRESS-OVERFLOW-FREE GREATER THAN SPACES               
                                                                        
              IF E-ADDR-COUNTRY-FREE EQUAL WS-USA OR SPACES             
                 MOVE E-ADDRESS-ID-FREE            TO E-ADDRESS-ID-OUT  
                 MOVE E-ADDR-STREET-FREE           TO E-ADDR-LINE1-OUT  
                 MOVE E-ADDRESS-OVERFLOW-FREE      TO E-ADDR-LINE2-OUT  
                 MOVE E-ADDR-CITY-STATE-FREE       TO E-CITY-STATE-OUT  
                 MOVE E-ZIP-CODE-FREE              TO E-ZIP5-PLUS4-OUT  
                 MOVE E-DELIVERY-POINT-FREE        TO E-DELIV-PT-OUT    
                                                                        
                 PERFORM 7525-WRITE-OUTFILE1          THRU 7525-EXIT    
              ELSE                                                      
                 COMPUTE WS-DROP-CNT-FREE        =  WS-DROP-CNT-FREE + 1
              END-IF                                                    
           ELSE                                                         
              COMPUTE WS-DROP-CNT-FREE           =  WS-DROP-CNT-FREE + 1
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **                                                             **         
      ** 7500-READ-INFILE-FREE                                       **         
      *****************************************************************         
       7500-READ-INFILE-FREE.                                           
                                                                        
           MOVE '7500-'                      TO WS-PARAGRAPH            
                                                                        
           READ INFILEU-FREE AT END                                     
             MOVE WS-YES                     TO WS-END-OF-INFILEU-FREE. 
                                                                        
           IF INFILEU-SUCCESSFUL OR END-OF-INFILEU-FREE                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**************************************'         
               DISPLAY '**     PCSCA009 PROCESSING ERROR    **'         
               DISPLAY '**       ERROR READING INFILEU      **'         
               DISPLAY '**      FILE STATUS = ' WS-INFILEU-STATUS       
               DISPLAY '**       PROCESSING TERMINATED      **'         
               DISPLAY '**************************************'         
               PERFORM 9500-ABEND                THRU 9500-EXIT         
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7525-WRITE-FCSR8221                                           *         
      *****************************************************************         
       7525-WRITE-OUTFILE1.                                             
                                                                        
           WRITE OUTFILE1-FREE-RECORD.                                  
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      **                                                             **         
      ** 7600-READ-INFILE-FORM                                       **         
      *****************************************************************         
       7600-READ-INFILE-FORM.                                           
                                                                        
           MOVE '7600-'                      TO WS-PARAGRAPH            
                                                                        
           READ INFILEF-FORM AT END                                     
             MOVE WS-YES                     TO WS-END-OF-INFILEF-FORM. 
                                                                        
           IF INFILEF-SUCCESSFUL OR END-OF-INFILEF-FORM                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**************************************'         
               DISPLAY '**     PCSCA009 PROCESSING ERROR    **'         
               DISPLAY '**       ERROR READING INFILEF      **'         
               DISPLAY '**      FILE STATUS = ' WS-INFILEF-STATUS       
               DISPLAY '**       PROCESSING TERMINATED      **'         
               DISPLAY '**************************************'         
               PERFORM 9500-ABEND                THRU 9500-EXIT         
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7525-WRITE-FCSR8221                                           *         
      *****************************************************************         
       7530-WRITE-OUTFILE2.                                             
                                                                        
           WRITE OUTFILE2-FORM-RECORD.                                  
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 9500-ABEND.                                                   *         
      *****************************************************************         
       9500-ABEND.                                                      
                                                                        
           DISPLAY 'PCSCA009 - PARAGRAPH =   ' WS-PARAGRAPH.            
           DISPLAY 'PCSCA009 - KEY =         ' WS-DISPLAY-KEY.          
           MOVE 12                          TO WS-EOJ-CODE.             
           PERFORM 9700-TERMINATE              THRU 9700-EXIT.          
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **                                                             **         
      **  9700-TERMINATE                                             **         
      **  CLOSES THE INPUT FILE AT EOF                               **         
      *****************************************************************         
       9700-TERMINATE.                                                  
                                                                        
           CLOSE INFILEU-FREE.                                          
           CLOSE INFILEF-FORM.                                          
           CLOSE OUTFILE1-FREE.                                         
           CLOSE OUTFILE2-FORM.                                         
                                                                        
           MOVE WS-EOJ-CODE TO RETURN-CODE.                             
           STOP RUN.                                                    
       9700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
