       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA007.                                        
       DATE-WRITTEN.   MAY 2016.                                        
      *************************************************************             
      *                 PROGRAM MODIFICATION LOG                  *             
      *   DATE    INITIALS   REASON                               *             
      * --------  --------   -------------------------------------*             
      *  05/16     MC95456    NEW PROGRAM                         *             
ACT286*  09/16     MC95456    APPL5460-ACT286 PROCESS NEW ACCOUNTS*             
A05460*  11/16     MR7E794    HANDLED NOT FOUND CONDITION IN 8000-*             
A05460*            ACT377     PARA TO AVOID ABEND.                *             
      *************************************************************             
                           REMARKS.                                     
      *************************************************************             
      *  THIS PROGRAM READS DB07 FILE AND INSERTS CSS_CREDIT_PROFILE            
      *  TABLE WITH MIN_DEPOSIT_AM AND MAX_DEPOSIT_AM.                          
      *************************************************************             
                  ---- BASIC BATCH SEQUENCE STRUCTURE ----              
          0000 - 0900     MAIN CONTROL PATH AND INITIALIZATION          
          1000 - 1999     INPUT PROCESSING CONTROL PATH                 
          2000 - 2999     OUTPUT PROCESSING CONTROL PATH                
          3000 - 4999     BATCH PROCESSING MODULES - NOT USED           
          5000 - 5999     COMMON PROGRAM MODULES                        
          6000 - 6999     COMMON SYSTEM MODULES                         
          7000 - 7999     INPUT MODULES                                 
          8000 - 8999     OUTPUT MODULES                                
          9000 - 9799     TERMINATION MODULES                           
          9800 - 9899     XCTLS TO PROGRAMS                             
          9900 - 9999     ABEND/ABORT MODULES                           
      ***************************************************************           
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       CONFIGURATION SECTION.                                           
      *                                                                         
       SOURCE-COMPUTER.    IBM-4381.                                    
       OBJECT-COMPUTER.    IBM-4381.                                    
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSDB07.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
      ******************************************************************CSS00010
      * CFDDB07 - FD STATEMENT FOR DB07 FILE                           *CSS00020
      *                                                                *        
      ******************************************************************CSS00040
      *                                                                         
       COPY CFDDB07.                                                            
       COPY FIODB07.                                                            
      *                                                                         
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA007'.
MSQ017     COPY MFASQLM.
                                                                        
      ***************************************************************           
      *         'WORKING STORAGE FOR PCSCA007 STARTS HERE'.                     
      ***************************************************************           
                                                                        
       01  WS-START                   PIC X(40)                         
           VALUE 'WORKING STORAGE FOR PCSCA007 STARTS HERE'.            
      *                                                                         
       01 WS-SWITCHES.                                                  
          05  WS-FDB07-STATUS               PIC X(02).                  
              88 FDB07-SUCCESSFUL                     VALUE '00'.       
          05  WS-FCSDB07-EOF-SW             PIC X(01) VALUE 'N'.        
              88  WS-FCSDB07-EOF                      VALUE 'Y'.        
              88  WS-FCSDB07-NOT-EOF                  VALUE 'N'.        
ACT286    05  WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.        
ACT286        88  NO-MORE-ROWS                        VALUE 'Y'.        
          05  WS-BEGIN-REC-SW               PIC X(01) VALUE 'N'.        
              88 WS-BEGIN-RECS-PROCESSED              VALUE 'Y'.        
          05  WS-RECORD-FOUND               PIC X(01) VALUE 'N'.        
              88 DATA-RECORD-FOUND                    VALUE 'Y'.        
              88 NO-DATA-RECORD-FOUND                 VALUE 'N'.        
          05  WS-DATABASE                   PIC 9(01) VALUE ZERO.       
              88 CSR-DATABASE                         VALUE 1.          
              88 SEB-DATABASE                         VALUE 2.          
                                                                        
       01 WS-LITERALS.                                                  
          05  WS-PGRMNAME              PIC X(10)   VALUE 'PCSCA007'.    
          05  WS-Y                     PIC X(01)   VALUE 'Y'.           
          05  WS-N                     PIC X(01)   VALUE 'N'.           
          05  WS-MIN-DEP-AMT           PIC S9(09)V99 USAGE COMP-3       
                                                   VALUE +150.          
       01 WS-MISC.                                                      
          05  WS-PREV-ACCT-NO          PIC S9(13)V USAGE COMP-3 VALUE 0.
          05  WS-COMMON-DATE           PIC X(10)   VALUE SPACES.        
COB305    05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.        
          05  RS-MIN-DEPOSIT-AMT       PIC S9(09)V99  USAGE COMP        
                                                   VALUE 0.             
          05  RS-RETURN-CODE           PIC S9(04)  COMP.                
          05  RS-RETURN-CODE-DISP      PIC S9(04).                      
ACT286    05  WS-LAST-RUN-TIMESTAMP    PIC X(26)   VALUE SPACES.        
ACT286    05  WS-CURRENT-TS            PIC X(26)   VALUE SPACES.        
ACT286    05  WS-PARM-DATA.                                             
ACT286        10 WS-PARM-COMMENT       PIC X(20)   VALUE                
ACT286                                 'LAST RUN TIMESTAMP ='.          
ACT286        10 WS-PARM-TS            PIC X(26)   VALUE SPACES.        
      *                                                                         
      ****************************************************************          
      **   COPYBOOKS USED IN THE PROGRAM                                        
      ****************************************************************          
                                                                        
       COPY CJF00101.                                                           
       COPY FIOJC01.                                                            
       COPY CWS00010.                                                           
       COPY CWS00303.                                                           
       COPY CWS00038.                                                           
       COPY CWS00039.                                                           
       COPY CWS09900.                                                           
      ******************************************************************07870000
      *  WORKING STORAGE AREA FOR CPD00308                             *07880000
      ******************************************************************07890000
      *                                                                 07900000
           EXEC SQL                                                             
               INCLUDE CWS00308                                                 
           END-EXEC.                                                            
HPCCDM*EJECT                                                                    
      *                                                                 05360000
      ******************************************************************06330000
      * FCA00-KEY                                                      *06340000
      ******************************************************************06350000
      *                                                                 06360000
           COPY FIOCA00.                                                06370000
      *                                                                 06391000
      ******************************************************************06330000
      *    SQL COMMUNICATIONS AREA                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_ACCOUNT - AT                                                     
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_LOCAL_OFFICE   - B1                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CUST_PREM_HIST - CH                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCSTPRM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CREDIT_PROFILE - CZ                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCRPROF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DELINQUENCY    - C8                                              
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_JOB_PARM - G6                                                    
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_REG_PROFILE   - LR                                               
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_CREATOR  - RT                                               
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBRTCRTR                                                 
           END-EXEC.                                                            
      *                                                                         
ACT286******************************************************************        
ACT286*    CSS_ACCT_MISC_INFO - TA                                              
ACT286******************************************************************        
                                                                        
ACT286     EXEC SQL                                                             
ACT286         INCLUDE TBATMISC                                                 
ACT286     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT - UT                                                
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
ACT286******************************************************************        
ACT286**  CURSOR DECLARATIONS                                          *        
ACT286******************************************************************        
ACT286     EXEC SQL                                                     
ACT286         DECLARE NEW_ACCT_CSR CURSOR FOR                          
ACT286         SELECT                                                   
ACT286            AT.ACCOUNT_NO                                         
ACT286           ,AT.CUSTOMER_NO                                        
ACT286           ,AT.COMPANY_NO                                         
ACT286           ,AT.ACCOUNT_TYPE_CODE                                  
ACT286           ,AT.PREMISE_NO                                         
ACT286           ,AT.BILL_CYCLE                                         
ACT286          FROM CSS_ACCOUNT  AT WITH(READUNCOMMITTED)                      
ACT286         WHERE AT.ACCT_CREATE_DT  > CIS.CHAR2TIMESTAMP(
                                                 :WS-LAST-RUN-TIMESTAMP
              )        
ACT286           AND AT.CREDIT_GROUP    = 'N'                           
ACT286           AND AT.CODE_ACCT_STAT  = 'A'                           
ACT286           FOR READ ONLY                                  
ACT286                                                      
ACT286     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE NEW_ACCT_CSR CURSOR FOR                                  
MFA-TR*        SELECT                                                           
MFA-TR*           AT.ACCOUNT_NO                                                 
MFA-TR*          ,AT.CUSTOMER_NO                                                
MFA-TR*          ,AT.COMPANY_NO                                                 
MFA-TR*          ,AT.ACCOUNT_TYPE_CODE                                          
MFA-TR*          ,AT.PREMISE_NO                                                 
MFA-TR*          ,AT.BILL_CYCLE                                                 
MFA-TR*         FROM CSS_ACCOUNT  AT                                            
MFA-TR*        WHERE AT.ACCT_CREATE_DT  > :WS-LAST-RUN-TIMESTAMP                
MFA-TR*          AND AT.CREDIT_GROUP    = 'N'                                   
MFA-TR*          AND AT.CODE_ACCT_STAT  = 'A'                                   
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*         QUERYNO 7301                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
ACT286 01 WS-END                 PIC X(40)                              
ACT286     VALUE 'WORKING STORAGE FOR PCSCA007 ENDS HERE'.              
      **************************************************************            
      *    'WORKING STORAGE FOR PCSCA007 ENDS HERE '.                           
      **************************************************************            
       PROCEDURE DIVISION.                                              
      **************************************************************            
      **                         M A I N L I N E                                
      **************************************************************            
       0000-MAINLINE.                                                   
      *-------------*                                                           
           MOVE '0000'                      TO WS-ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
           PERFORM 0500-READ-HEADER-RECORDS THRU 0500-EXIT              
                   UNTIL E-FDB07-KEY-BREC NOT EQUAL LOW-VALUES.         
           PERFORM 1000-PROCESS-FCSDB07      THRU 1000-EXIT             
                   UNTIL WS-FCSDB07-EOF.                                
ACT286     PERFORM 1100-PROCESS-NEW-ACCOUNTS THRU 1100-EXIT.            
ACT286     PERFORM 1200-UPDATE-LAST-RUN-TS   THRU 1200-EXIT.            
           PERFORM 9000-TERMINATE            THRU 9000-EXIT.            
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
            EXIT.                                                       
      ***************************************************************           
      **  0100-INITIALIZATION                                                   
      **  COMMON INITIALIZATION ROUTINE                                         
      ***************************************************************           
       0100-INITIALIZATION.                                             
      *-------------------*                                                     
           MOVE '0100'                 TO WS-ACTIVE-PARAGRAPH.          
                                                                        
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6251-GET-FJC01-DATE           THRU 6251-EXIT.        
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE          TO WS-INPUT-DATE       
           END-IF.                                                      
           MOVE WS-INPUT-DATE                    TO WS-COMMON-DATE.     
           DISPLAY 'PCSCA007 RUNNING DATE - '    WS-COMMON-DATE.        
                                                                        
           PERFORM 0200-OPEN-INPUT-FILE          THRU 0200-EXIT.        
                                                                        
           MOVE 'DATABASE'                       TO C8-DELINQ-CD.       
           MOVE '01'                             TO C8-COMPANY-NO.      
           PERFORM 7100-SELECT-DELINQ-VALUE      THRU 7100-EXIT.        
           MOVE C8-DELINQ-VALUE                  TO WS-DATABASE.        
                                                                        
ACT286     MOVE  WS-PGRMNAME                     TO WS-PROGRAM.         
ACT286     MOVE  WS-PARM                         TO WS-COMMAND.         
ACT286     MOVE  SPACES                          TO WS-SYSIPT.          
ACT286     MOVE  SPACES                      TO WS-INPUT-DATA-BREAKDOWN.
ACT286     PERFORM 7600-START-FCSJC01            THRU  7600-EXIT.       
ACT286     PERFORM 7610-READ-FCSJC01             THRU  7610-EXIT.       
ACT286     MOVE WS-INPUT-DATA-BREAKDOWN(21:26)   TO                     
ACT286             WS-LAST-RUN-TIMESTAMP.                               
       0100-EXIT.                                                       
            EXIT.                                                       
      ********************************************************                  
      **  0200-OPEN-INPUT-FILE.                                                 
      ********************************************************                  
       0200-OPEN-INPUT-FILE.                                            
                                                                        
           MOVE '0200'                TO WS-ACTIVE-PARAGRAPH.           
                                                                        
           OPEN INPUT FCSDB07-FILE.                                     
           IF FDB07-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********ABENDING**************'               
              DISPLAY '** 0200-OPEN-INPUT-FILE          '               
              DISPLAY '** ERROR ON OPENING FCSDB07 FILE.'               
              DISPLAY '** STATUS IS ' WS-FDB07-STATUS                   
              DISPLAY '************ PCSCA007 ***********'               
              PERFORM 9900-ABEND                 THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      ** 0500-READ-HEADER-RECORDS.                                              
      **************************************************************            
                                                                        
       0500-READ-HEADER-RECORDS.                                        
                                                                        
ACT286     MOVE '0500'                TO WS-ACTIVE-PARAGRAPH.           
                                                                        
           PERFORM 7001-READ-FCSDB07        THRU 7001-EXIT.             
      *                                                                 09478886
           EVALUATE TRUE                                                
               WHEN WS-FCSDB07-EOF                                      
                    DISPLAY '************ABENDING************'          
                    DISPLAY '**    PCSCA007 PROCESSING ERROR '          
                    DISPLAY '**      FCSDB07 FILE IS EMPTY   '          
                    DISPLAY '**      PROCESSING TERMINATED   '          
                    DISPLAY '************PCSCA007************'          
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
               WHEN E-FDB07-KEY-BREC = LOW-VALUES                       
                    IF E-FDB07-CREATE-DATE-BREC NOT = WS-COMMON-DATE    
                       DISPLAY '*********ABENDING*****************'     
                       DISPLAY '**     PCSCA007 PROCESSING ERROR  '     
                       DISPLAY '** FCSDB07 CREATE DATE NOT = RUN DATE ' 
                       DISPLAY '**       PROCESSING TERMINATED    '     
                       DISPLAY '*********PCSCA007*****************'     
                       PERFORM 9900-ABEND   THRU 9900-EXIT              
                    END-IF                                              
                    SET WS-BEGIN-RECS-PROCESSED TO TRUE                 
               WHEN WS-BEGIN-RECS-PROCESSED                             
                    IF E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES     
                       IF E-FDB07-KEY-BREC = HIGH-VALUES AND            
                          NO-DATA-RECORD-FOUND AND                      
                          E-FDB07-RECORD-COUNT-EREC EQUAL ZERO          
                          DISPLAY '************ABENDING************'    
                          DISPLAY '**    PCSCA007 PROCESSING ERROR '    
                          DISPLAY '**      FCSDB07 FILE IS EMPTY   '    
                          DISPLAY '**      PROCESSING TERMINATED   '    
                          DISPLAY '************PCSCA007************'    
                          PERFORM 9900-ABEND THRU 9900-EXIT             
                       ELSE                                             
                          CONTINUE                                      
                       END-IF                                           
                    ELSE                                                
                       SET DATA-RECORD-FOUND TO TRUE                    
                    END-IF                                              
               WHEN OTHER                                               
                    DISPLAY '************ABENDING**************'        
                    DISPLAY '**    PCSCA007 PROCESSING ERROR   '        
                    DISPLAY '** FIRST RECORD IS NOT A CNTL REC '        
                    DISPLAY '**      PROCESSING TERMINATED     '        
                    DISPLAY '************PCSCA007**************'        
                    PERFORM 9900-ABEND      THRU 9900-EXIT              
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      **************************************************************            
      **    1000-PROCESS-FCSDB07.                                               
      **************************************************************            
       1000-PROCESS-FCSDB07.                                            
                                                                        
           MOVE '1000'                    TO WS-ACTIVE-PARAGRAPH.       
                                                                        
           IF E-FDB07-KEY-BREC = HIGH-VALUES OR LOW-VALUES              
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2500-OUTPUT-PROCESS THRU 2500-EXIT                
           END-IF.                                                      
                                                                        
           PERFORM 7001-READ-FCSDB07      THRU 7001-EXIT.               
                                                                        
       1000-EXIT.                                                       
            EXIT.                                                       
ACT286**************************************************************            
ACT286**    1100-PROCESS-NEW-ACCOUNTS.                                          
ACT286**************************************************************            
ACT286 1100-PROCESS-NEW-ACCOUNTS.                                       
ACT286                                                                  
ACT286     MOVE '1100'                    TO WS-ACTIVE-PARAGRAPH.       
ACT286                                                                  
ACT286     PERFORM 7300-OPEN-NEW-ACCOUNTS      THRU 7300-EXIT.          
ACT286     PERFORM 7310-FETCH-NEW-ACCOUNTS     THRU 7310-EXIT.          
ACT286     PERFORM UNTIL NO-MORE-ROWS                                   
ACT286        PERFORM 2550-PROCESS-DEP-AMT     THRU 2550-EXIT           
ACT286        PERFORM 7310-FETCH-NEW-ACCOUNTS  THRU 7310-EXIT           
ACT286     END-PERFORM.                                                 
ACT286     PERFORM 7320-CLOSE-NEW-ACCOUNTS     THRU 7320-EXIT.          
                                                                        
                                                                        
ACT286 1100-EXIT.                                                       
ACT286      EXIT.                                                       
ACT286**************************************************************            
ACT286*     1200-UPDATE-LAST-RUN-TS.                                            
ACT286**************************************************************            
ACT286 1200-UPDATE-LAST-RUN-TS.                                         
ACT286                                                                  
ACT286     MOVE '1200'                    TO WS-ACTIVE-PARAGRAPH.       
                                                                        
ACT286     INITIALIZE G6-PARM-DATA.                                     
ACT286     PERFORM 7500-SELECT-CURR-TS   THRU 7500-EXIT.                
ACT286     MOVE WS-CURRENT-TS            TO WS-PARM-TS.                 
ACT286     MOVE WS-PARM-DATA             TO G6-PARM-DATA.               
ACT286     MOVE WS-PGRMNAME              TO G6-PROGRAM-NAME.            
ACT286     MOVE 'PARM'                   TO G6-CMND-CODE.               
ACT286     MOVE +10                      TO G6-SEQ-NO.                  
ACT286     MOVE '01'                     TO G6-COMPANY-NO.              
ACT286     PERFORM 8100-UPDATE-LAST-RUN-DATE   THRU 8100-EXIT.          
                                                                        
ACT286 1200-EXIT.                                                       
ACT286      EXIT.                                                       
      **************************************************************            
      ** 2500-OUTPUT-PROCESS.                                                   
      **************************************************************            
       2500-OUTPUT-PROCESS.                                             
                                                                        
ACT286     MOVE '2500'                TO WS-ACTIVE-PARAGRAPH.           
                                                                        
           MOVE E-FDB07-ACCT-NO                     TO AT-ACCOUNT-NO    
                                                                        
           IF AT-ACCOUNT-NO = WS-PREV-ACCT-NO                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE AT-ACCOUNT-NO                    TO WS-PREV-ACCT-NO  
              PERFORM 7200-SELECT-ACCT-INFO         THRU 7200-EXIT      
ACT286        PERFORM 2550-PROCESS-DEP-AMT          THRU 2550-EXIT      
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      ** 2550-PROCESS-DEP-AMT.                                                  
      **************************************************************            
                                                                        
         2550-PROCESS-DEP-AMT.                                          
                                                                        
           MOVE '2500'                TO WS-ACTIVE-PARAGRAPH.           
                                                                        
           IF AT-ACCOUNT-TYPE-CODE = 'N' OR                             
              AT-MST-SUB-ACCT-IND  = 'S'                                
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 2510-GET-DEPOSIT-VALUES    THRU 2510-EXIT         
              MOVE AT-ACCOUNT-NO                 TO CZ-ACCOUNT-NO       
              MOVE WS-MIN-DEPOSIT-AMT            TO CZ-MIN-DEPOSIT-AM   
              MOVE WS-MAX-DEPOSIT-AMT            TO CZ-MAX-DEPOSIT-AM   
              IF   WS-MIN-DEPOSIT-AMT > WS-MAX-DEPOSIT-AMT              
                   MOVE WS-MAX-DEPOSIT-AMT       TO CZ-MIN-DEPOSIT-AM   
              END-IF                                                    
              PERFORM 8000-UPDATE-CREDIT-PROFILE THRU 8000-EXIT         
           END-IF.                                                      
                                                                        
ACT286   2550-EXIT.                                                     
ACT286        EXIT.                                                     
      *****************************************************************         
      **  2510-GET-DEPOSIT-VALUES.                                   **         
      **  THIS PARAGRAPH RETRIEVES THE MAXIMUM ALLOWABLE DEPOSIT FOR **         
      **  AN ACCOUNT.  THE CALCULATION IS DONE IN CPD00308.          **         
      *****************************************************************         
       2510-GET-DEPOSIT-VALUES.                                         
      *                                                                         
ACT286     MOVE '2510'                TO WS-ACTIVE-PARAGRAPH.           
                                                                        
           INITIALIZE WS-MAX-DEPOSIT-AMT.                               
           MOVE WS-MIN-DEP-AMT             TO WS-MIN-DEPOSIT-AMT.       
           MOVE AT-PREMISE-NO              TO WS-PREMISE-NO.            
           MOVE AT-ACCOUNT-NO              TO WS-ACCOUNT-NO.            
           MOVE WS-Y                       TO WS-CALLING-BATCH-SW.      
           MOVE WS-INPUT-DATE              TO WS-TEMP-BATCH-DATE        
                                              WS-DATE-CWS00308.         
           PERFORM 5650-GET-MAX-DEPOSIT                                 
              THRU 5650-GET-MAX-DEPOSIT-EXIT.                           
      *                                                                         
       2510-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************19423409
      * 7001-READ-FCSDB07                                              *19423509
      ******************************************************************19423609
      *                                                                 19423709
       7001-READ-FCSDB07.                                               
      *                                                                 19423909
           READ FCSDB07-FILE                                            
               AT END                                                   
                   MOVE WS-Y                TO WS-FCSDB07-EOF-SW        
                   GO TO 7001-EXIT                                      
           END-READ.                                                    
      *                                                                 19424509
           IF  FDB07-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '*************** ABENDING ***************'        
              DISPLAY '* 7001-ERROR ON FCSDB07 READ.          *'        
              DISPLAY '* STATUS  - ' WS-FDB07-STATUS                    
              DISPLAY 'ERROR IN ACCOUNT NO' E-FDB07-ACCT-NO             
              DISPLAY '*************** PCSCA007 ****************'       
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
      *                                                                 19425909
       7001-EXIT.                                                       
           EXIT.                                                        
      *                                                                 19426209
      ******************************************************************19423409
      * 7100-SELECT-DELINQ-VALUE.                                      *19423509
      ******************************************************************19423609
      *                                                                 19423709
       7100-SELECT-DELINQ-VALUE.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD  = :C8-DELINQ-CD                         
                 AND COMPANY_NO = :C8-COMPANY-NO                        
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********** PCSCA007 ABORT **************'       
               DISPLAY '* 7100-SELECT-DELINQ-VALUE             *'       
               DISPLAY '* DELINQ CD ', C8-DELINQ-CD                     
               DISPLAY '* COMPANY NO', C8-COMPANY-NO                    
               DISPLAY '* SQLCODE IS ',WS-ACTIVE-RETURN-CODE            
               DISPLAY '**     PROCESSING TERMINATED          **'       
               DISPLAY '********** PCSCA007 ABORT **************'       
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *************************************************************             
      **  7200-SELECT-ACCT-INFO                                                 
      *************************************************************             
       7200-SELECT-ACCT-INFO.                                           
                                                                        
           MOVE '7200'                   TO WS-ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
             SELECT AT.CUSTOMER_NO                                      
                   ,AT.COMPANY_NO                                       
                   ,AT.ACCOUNT_TYPE_CODE                                
                   ,AT.PREMISE_NO                                       
                   ,AT.BILL_CYCLE                                       
               INTO :AT-CUSTOMER-NO,
                :AT-COMPANY-NO,
                :AT-ACCOUNT-TYPE-CODE,
                :AT-PREMISE-NO,
                :AT-BILL-CYCLE                                
               FROM CSS_ACCOUNT AT                                      
              WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ064
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT AT.CUSTOMER_NO                                              
MFA-TR*            ,AT.COMPANY_NO                                               
MFA-TR*            ,AT.ACCOUNT_TYPE_CODE                                        
MFA-TR*            ,AT.PREMISE_NO                                               
MFA-TR*            ,AT.BILL_CYCLE                                               
MFA-TR*        INTO :AT-CUSTOMER-NO                                             
MFA-TR*            ,:AT-COMPANY-NO                                              
MFA-TR*            ,:AT-ACCOUNT-TYPE-CODE                                       
MFA-TR*            ,:AT-PREMISE-NO                                              
MFA-TR*            ,:AT-BILL-CYCLE                                              
MFA-TR*            ,:AT-MST-SUB-ACCT-IND                                        
MFA-TR*        FROM CSS_ACCOUNT AT                                              
MFA-TR*       WHERE AT.ACCOUNT_NO   = :AT-ACCOUNT-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 7200-SELECT-ACCT-INFO      **'     
              DISPLAY '**   ACCOUNT NO   = ' AT-ACCOUNT-NO              
              DISPLAY '**   SQLCODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
ACT286******************************************************************        
ACT286* 7300-OPEN-NEW-ACCOUNTS                                         *        
ACT286******************************************************************        
ACT286*                                                                         
ACT286 7300-OPEN-NEW-ACCOUNTS.                                          
ACT286*                                                                         
ACT286     EXEC SQL                                                     
ACT286        OPEN NEW_ACCT_CSR                                         
ACT286     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT286                                                                  
ACT286     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT286                                                                  
ACT286     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT286        CONTINUE                                                  
ACT286     ELSE                                                         
ACT286        DISPLAY '*******************************************'     
ACT286        DISPLAY '**   ERROR ON 7300-OPEN-NEW-ACCOUNTS     **'     
ACT286        DISPLAY '**   SQLCODE     = ' WS-ACTIVE-RETURN-CODE       
ACT286        DISPLAY '**       PROCESSING TERMINATED           **'     
ACT286        DISPLAY '*******************************************'     
ACT286        PERFORM 9900-ABEND            THRU 9900-EXIT              
ACT286     END-IF.                                                      
ACT286*                                                                         
ACT286 7300-EXIT.                                                       
ACT286     EXIT.                                                        
      *                                                                         
ACT286******************************************************************        
ACT286* 7310-FETCH-NEW-ACCOUNTS.                                       *        
ACT286******************************************************************        
ACT286*                                                                         
ACT286 7310-FETCH-NEW-ACCOUNTS.                                         
ACT286*                                                                         
ACT286     EXEC SQL                                                     
ACT286        FETCH NEW_ACCT_CSR INTO                                   
ACT286             :AT-ACCOUNT-NO                                       
ACT286            ,:AT-CUSTOMER-NO                                      
ACT286            ,:AT-COMPANY-NO                                       
ACT286            ,:AT-ACCOUNT-TYPE-CODE                                
ACT286            ,:AT-PREMISE-NO                                       
ACT286            ,:AT-BILL-CYCLE                                       
ACT286     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
ACT286     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT286                                                                  
ACT286     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT286        CONTINUE                                                  
ACT286     ELSE                                                         
ACT286        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ACT286           MOVE 'Y'                  TO WS-NO-MORE-ROWS           
ACT286        ELSE                                                      
ACT286           DISPLAY '*******************************************'  
ACT286           DISPLAY '**   ERROR ON 7310-FETCH-NEW-ACCOUNTS    **'  
ACT286           DISPLAY '**   ACCOUNT NO  = ' AT-ACCOUNT-NO            
ACT286           DISPLAY '**   SQLCODE     = ' WS-ACTIVE-RETURN-CODE    
ACT286           DISPLAY '**       PROCESSING TERMINATED           **'  
ACT286           DISPLAY '*******************************************'  
ACT286           PERFORM 9900-ABEND            THRU 9900-EXIT           
ACT286     END-IF
           END-IF.                                                      
ACT286*                                                                         
ACT286 7310-EXIT.                                                       
ACT286     EXIT.                                                        
ACT286*                                                                         
ACT286******************************************************************        
ACT286* 7320-CLOSE-NEW-ACCOUNTS.                                       *        
ACT286******************************************************************        
ACT286*                                                                         
ACT286 7320-CLOSE-NEW-ACCOUNTS.                                         
ACT286*                                                                         
ACT286     EXEC SQL                                                     
ACT286         CLOSE NEW_ACCT_CSR                                       
ACT286     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT286                                                                  
ACT286     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT286                                                                  
ACT286     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT286        CONTINUE                                                  
ACT286     ELSE                                                         
ACT286        DISPLAY '*******************************************'     
ACT286        DISPLAY '**   ERROR ON 7320-CLOSE-NEW-ACCOUNTS    **'     
ACT286        DISPLAY '**   SQLCODE     = ' WS-ACTIVE-RETURN-CODE       
ACT286        DISPLAY '**       PROCESSING TERMINATED           **'     
ACT286        DISPLAY '*******************************************'     
ACT286        PERFORM 9900-ABEND            THRU 9900-EXIT              
ACT286     END-IF.                                                      
ACT286*                                                                         
ACT286 7320-EXIT.                                                       
ACT286     EXIT.                                                        
ACT286*                                                                         
ACT286******************************************************************        
ACT286* 7500-SELECT-CURR-TS.                                           *        
ACT286******************************************************************        
ACT286*                                                                         
ACT286 7500-SELECT-CURR-TS.                                             
ACT286                                                                  
ACT286     EXEC SQL                                                     
ACT286        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS            
ACT286     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     16620000
MFA-TR*       SET  :WS-CURRENT-TS        = CURRENT TIMESTAMP            16640003
MFA-TR*    END-EXEC.                                                    16660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT286                                                                  
ACT286     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
ACT286                                                                  
ACT286     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT286        CONTINUE                                                  
ACT286     ELSE                                                         
ACT286        DISPLAY '*******************************************'     
ACT286        DISPLAY '**   ERROR ON 7500-SELECT-CURR-TS        **'     
ACT286        DISPLAY '**   SQLCODE     = ' WS-ACTIVE-RETURN-CODE       
ACT286        DISPLAY '**       PROCESSING TERMINATED           **'     
ACT286        DISPLAY '*******************************************'     
ACT286        PERFORM 9900-ABEND            THRU 9900-EXIT              
ACT286     END-IF.                                                      
ACT286                                                                  
ACT286 7500-EXIT.                                                       
ACT286     EXIT.                                                        
      *****************************************************************         
      **  8000-UPDATE-CREDIT-PROFILE.                                **         
      ******************************************************************19423409
       8000-UPDATE-CREDIT-PROFILE.                                      
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_CREDIT_PROFILE                                  
                SET MIN_DEPOSIT_AM  = :CZ-MIN-DEPOSIT-AM                
                   ,MAX_DEPOSIT_AM  = :CZ-MAX-DEPOSIT-AM                
                   ,LAST_UPDATE_TS  = CIS.CURRENT$TIMESTAMP()                 
              WHERE ACCOUNT_NO      = :CZ-ACCOUNT-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     05100000
MFA-TR*      UPDATE CSS_CREDIT_PROFILE                                  05110000
MFA-TR*         SET MIN_DEPOSIT_AM  = :CZ-MIN-DEPOSIT-AM                05120000
MFA-TR*            ,MAX_DEPOSIT_AM  = :CZ-MAX-DEPOSIT-AM                05130000
MFA-TR*            ,LAST_UPDATE_TS  = CURRENT TIMESTAMP                         
MFA-TR*       WHERE ACCOUNT_NO      = :CZ-ACCOUNT-NO                    05160000
MFA-TR*    END-EXEC.                                                    05170000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
ACT377     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT377        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
ACT377           CONTINUE                                               
ACT377        ELSE                                                      
ACT377           DISPLAY '*******************************************'  
ACT377           DISPLAY '**   8000-UPDATE-CREDIT-PROFILE          **'  
ACT377           DISPLAY '**   ACCOUNT NO      = ' CZ-ACCOUNT-NO        
ACT377           DISPLAY '**   MIN_DEPOSIT_AMT = ' CZ-MIN-DEPOSIT-AM    
ACT377           DISPLAY '**   MAX_DEPOSIT_AMT = ' CZ-MAX-DEPOSIT-AM    
ACT377           DISPLAY '**   SQLCODE      = ' WS-ACTIVE-RETURN-CODE   
ACT377           DISPLAY '*******************************************'  
ACT377        END-IF                                                    
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   ERROR ON 8000-UPDATE-CREDIT-PROFILE **'     
              DISPLAY '**   ACCOUNT NO      = ' CZ-ACCOUNT-NO           
              DISPLAY '**   MIN_DEPOSIT_AMT = ' CZ-MIN-DEPOSIT-AM       
              DISPLAY '**   MAX_DEPOSIT_AMT = ' CZ-MAX-DEPOSIT-AM       
              DISPLAY '**   SQLCODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
ACT286*****************************************************************         
ACT286* 8100-UPDATE-LAST-RUN-DATE                                     *         
ACT286*****************************************************************         
ACT286 8100-UPDATE-LAST-RUN-DATE.                                       
ACT286                                                                  
ACT286     EXEC SQL                                                     
ACT286          UPDATE CSS_JOB_PARM                                     
ACT286             SET PARM_DATA     = :G6-PARM-DATA                    
ACT286           WHERE PROGRAM_NAME  = :G6-PROGRAM-NAME                 
ACT286             AND CMND_CODE     = :G6-CMND-CODE                    
ACT286             AND COMPANY_NO    = :G6-COMPANY-NO                   
ACT286             AND SEQ_NO        = :G6-SEQ-NO                       
ACT286     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT286                                                                  
ACT286     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
ACT286                                                                  
ACT286     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT286        NEXT SENTENCE                                             
ACT286     ELSE                                                         
ACT286        DISPLAY '********** PCSCA007 ABORT **************'        
ACT286        DISPLAY '*     8100-UPDATE-LAST-RUN-DATE        *'        
ACT286        DISPLAY '* PROGRAM NAME   : ' G6-PROGRAM-NAME             
ACT286        DISPLAY '* COMPANY NO     : ' G6-COMPANY-NO               
ACT286        DISPLAY '* CMD CODE       : ' G6-CMND-CODE                
ACT286        DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
ACT286        DISPLAY '* PROGRAM ABORTING...                  *'        
ACT286        DISPLAY '********** PCSCA007 ABORT **************'        
ACT286        PERFORM 9900-ABEND               THRU 9900-EXIT           
ACT286     END-IF.                                                      
ACT286                                                                  
ACT286 8100-EXIT.                                                       
ACT286     EXIT.                                                        
                                                                        
      **************************************************************            
      **  9000-TERMINATE                                                        
      *        NORMAL TERMINATION OF THE PROGRAM                                
      **************************************************************            
       9000-TERMINATE.                                                  
      *--------------*                                                          
           CLOSE FCSDB07-FILE.                                          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  5650-GET-MAX-DEPOSIT.                                        *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00308                                                 
           END-EXEC.                                                            
      ******************************************************************        
      **  6240-GET-FCA00-COMMON-DATE.                                  *        
      ******************************************************************        
      *                                                                         
           COPY CPD00040.                                                       
      *                                                                         
      ******************************************************************        
      *  6251-GET-FJC01-DATE.                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7600-START-FCSJC01.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      ******************************************************************        
      *  7620-START-FCSCA00.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ****************************************************************          
      *  COPY BOOK CONTAINING 9700-PROCESS-ABEND                 ****           
      ****************************************************************          
           EXEC SQL                                                             
               INCLUDE CPD0023B                                                 
           END-EXEC.                                                            
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND AND 9900-EXIT           ****           
      ****************************************************************          
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
