HPCCDM*00001  PROCESS DYNAM,RENT,RES,DATA(24)                                  0
00001  IDENTIFICATION DIVISION.                                         
00002  PROGRAM-ID.   PCSCA006.                                          
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  CHECK EPAY FILE.                                              *        
      *  IF DATES DON'T MATCH, FAILURE - RETURN CODE 12                *        
      *  IF NO DETAIL RECORDS, RETURN CODE 3                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      ******************************************************************        
00014  ENVIRONMENT DIVISION.                                            
00015  INPUT-OUTPUT SECTION.                                            
00016  FILE-CONTROL.                                                    
           SELECT  INFILE ASSIGN TO  INFILE.                            
00020  DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD INFILE.                                                       
          COPY FIOAC03.                                                         
00024  WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA006'.
MSQ017     COPY MFASQLM.
       77  WS-END-OF-FILE  PIC X             VALUE 'N'.                 
           88  END-OF-FILE           VALUE 'Y'.                         
       77  WS-DATA-PRESENT PIC X             VALUE 'N'.                 
           88  NO-DETAIL-RECORDS     VALUE 'N'.                         
       77  WS-DATE-ERROR   PIC X             VALUE 'N'.                 
           88  DATE-ERROR            VALUE 'Y'.                         
       77  SORT-LOOP-CTR   PIC S999  COMP-3  VALUE +11.                 
       77  LAST-ENTRY      PIC S999  COMP-3  VALUE +11.                 
       77  I               PIC S999  COMP-3  VALUE +0.                  
       77  WS-LEN          PIC S999  COMP-3  VALUE +0.                  
       77  WS-NEW-NAME     PIC X(8).                                    
       77  WS-DATE-MESSAGE PIC X(36) VALUE                              
           'PCSCA006 - DATE ERROR - FILE DATE = '.                      
       01  WS-CURRENT-DATE PIC X(10).                                   
       01  FILLER REDEFINES WS-CURRENT-DATE.                            
           05  WS-CURRENT-YEAR.                                         
               10  FILLER          PIC XX.                              
               10  WS-CURRENT-YY   PIC XX.                              
               10  FILLER          PIC X.                               
               10  WS-CURRENT-MM   PIC XX.                              
               10  FILLER          PIC X.                               
               10  WS-CURRENT-DD   PIC XX.                              
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
A                                                                       
 0040  PROCEDURE DIVISION.                                              
           OPEN INPUT  INFILE.                                          
           EXEC SQL                                                     
               SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                         
               INTO   :WS-CURRENT-DATE                                  
               FROM   CIS.SYSDUMMY1                                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT DATE                                              
MFA-TR*        INTO   :WS-CURRENT-DATE                                          
MFA-TR*        FROM   SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = 0                                           
              DISPLAY 'SQL ERROR SELECTION CURRENT DATE : ' SQLCODE     
              MOVE 'Y' TO WS-END-OF-FILE                                
           END-IF                                                       
           PERFORM 7000-READ.                                           
           PERFORM UNTIL END-OF-FILE                                    
               EVALUATE CSHCNACH-RECORD-TYPE                            
                   WHEN '8'                                             
                        MOVE 'Y' TO WS-END-OF-FILE                      
                   WHEN '6'                                             
                        MOVE 'Y' TO WS-DATA-PRESENT                     
                   WHEN '1'                                             
                        DISPLAY 'PCSCA006 - FILE DATE = '               
                                 CSHCNACH-1-FILE-CREATE-DT ' '          
                                 'CURRENT DATE = ' WS-CURRENT-DATE      
                        IF CSHCNACH-1-FILE-CREATE-YY = WS-CURRENT-YY AND
                           CSHCNACH-1-FILE-CREATE-MM = WS-CURRENT-MM AND
                           CSHCNACH-1-FILE-CREATE-DD = WS-CURRENT-DD    
                               CONTINUE                                 
                           ELSE                                         
                               DISPLAY '*** DATE MISMATCH ***'          
                               MOVE 'Y' TO WS-DATE-ERROR                
                               MOVE 12  TO RETURN-CODE                  
                        END-IF                                          
               END-EVALUATE                                             
               PERFORM 7000-READ                                        
           END-PERFORM.                                                 
           IF DATE-ERROR                                                
               MOVE 12 TO RETURN-CODE                                   
           ELSE                                                         
               IF NO-DETAIL-RECORDS                                     
                   DISPLAY 'NO DETAIL RECORDS'                          
                   MOVE 03 TO RETURN-CODE                               
               END-IF                                                   
           END-IF.                                                      
           CLOSE INFILE.                                                
           STOP RUN.                                                    
*                                                                       
       7000-READ.                                                       
           READ INFILE AT END                                           
               MOVE 'Y' TO WS-END-OF-FILE.                              
