       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA005.                                        
       DATE-WRITTEN.   APR 2015.                                        
      ***************************************************************** 00000401
      **              COPYRIGHT/CONFIDENTIAL  MATERIAL                * 00000501
      **                                                              * 00000601
      ********            CUSTOMER SERVICE SYSTEM             ********* 00000701
      ********                      DB2                       ********* 00000801
      **                                                              * 00000601
      *****************************************************************         
      **-------------- P R O G R A M  S U M M A R Y -----------------**         
      *****************************************************************         
      **   THIS PROGRAM INSERTS A ROW INTO CSS_ACT_RT_REN_DET        **         
      **   AND CALLS SCSCB326 TO UPDATE RATE IN CSS_ACCT_RTPK_AGR.   **         
      *****************************************************************         
      **------------- PROGRAM  MODIFICATION  LOG --------------------**         
      *****************************************************************         
      **      PCSCA005   PROGRAM  MODIFICATION  LOG                  **         
      **                                                             **         
      **    DATE     INITIALS   REASON                               **         
      **  ---------  --------   ------------                         **         
      **  04/06/2015 MC95456    NEW PROGRAM                          **         
      **  P00892     & VIJAY                                         **         
ACT008**  01/14/2016 VIJAY      WARRANTY ISSUES FIX.                 **         
      **  A05460                                                     **         
ACT013**  01/21/2016 VIJAY      DO NOT WRITE MNT IN CASE OF SCSCA326 **         
      **  A05460                ABEND.                               **         
ACT035**  02/04/2016 VIJAY      FIX EXCEPTION LOGIC.                 **         
      **  A05460                                                     **         
ACT018**  01/28/2016 VIJAY      USE 5B.OFFER_CD INSTEAD 5A.OFFER_CD  **         
      **  A05460                                                     **         
ACT133**  04/21/2016 VIJAY      FIX EXCEPTION PROCESS.               **         
      **  A05460                                                     **         
ACT191**  06/13/2016 VIJAY      FIX -811 ERROR IN GETTING AR FLAG.   **         
      **  A05460                                                     **         
ACT208**  06/29/2016 VIJAY      FIX -811 ERROR IN GETTING OPTION     **         
ACT208**  A05460                DESCRIPTION.                         **         
      *****************************************************************         
      **----------------- BASIC SEQUENCE STRUCTURE ------------------**         
      *****************************************************************         
      **         0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION**         
      **         1000 - 1999     INPUT PROCESSING CONTROL PATH       **         
      **         2000 - 2999     OUTPUT PROCESSING CONTROL PATH      **         
      **         3000 - 4999     BATCH PROCESSING MODULES - NOT USED **         
      **         5000 - 5999     COMMON PROGRAM MODULES              **         
      **         6000 - 6999     COMMON SYSTEM MODULES               **         
      **         7000 - 7999     INPUT MODULES                       **         
      **         8000 - 8999     OUTPUT MODULES                      **         
      **         9000 - 9799     TERMINATION MODULES                 **         
      **         9900 - 9999     ABEND/ABORT MODULES                 **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
      *                                                                         
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSCA05.                                                            
                                                                        
      *** REPORT FILE                                                   00573020
           SELECT FCSCA05-REPORT                                        
               ASSIGN UT-REPORT1                                        
               STATUS IS WS-REPORT1-STATUS.                             
                                                                        
       DATA DIVISION.                                                   
      *                                                                 00574020
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDCA05.                                                            
       COPY FIOCA05.                                                            
                                                                        
      *** REPORT RECORD                                                 00573020
       FD  FCSCA05-REPORT.                                              
       01  REPORT-REC       PIC X(287).                                 
      *                                                                 00540000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA005'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                         PIC X(40)                    
           VALUE 'WORKING STORAGE FOR PCSCA005 STARTS HERE'.            
      *                                                                         
       01 WS-CONSTANTS.                                                 
          05 WS-PGRMNAME                   PIC X(08)  VALUE 'PCSCA005'. 
          05 PROGRAM-NAME                  PIC X(08)  VALUE 'PCSCA005'. 
          05 SCSCA326                      PIC X(08)  VALUE 'SCSCA326'. 
          05 SCSCB077                      PIC X(08)  VALUE 'SCSCB077'. 
          05 WS-E                          PIC X(01)  VALUE 'E'.        
          05 WS-I                          PIC X(01)  VALUE 'I'.        
          05 WS-N                          PIC X(01)  VALUE 'N'.        
          05 WS-P                          PIC X(01)  VALUE 'P'.        
          05 WS-U                          PIC X(01)  VALUE 'U'.        
          05 WS-Y                          PIC X(01)  VALUE 'Y'.        
          05 WS-X                          PIC X(01)  VALUE 'X'.        
                                                                        
      *                                                                         
       01 WS-RESTART-MISC.                                              
          05 WS-RESTART-DATA-LENGTH        PIC S9(04) COMP VALUE +42.   
          05 WS-IS-THIS-A-RESTART          PIC X(01)  VALUE 'N'.        
             88 WS-THIS-IS-A-RESTART                  VALUE 'Y'.        
             88 WS-THIS-IS-NOT-A-RESTART              VALUE 'N'.        
          05 WS-COMMIT-COUNTER             PIC 9(04)  VALUE ZERO.       
          05 WS-DEFAULT-CHKP-LUW-LIMIT     PIC 9(04)  VALUE 100.        
          05 WS-SEQ-NO                     PIC 9(04)  VALUE ZERO.       
          05 WS-CHKP-LUW-LIMIT             PIC 9(04)  VALUE ZERO.       
          05 WS-CHKP-LUW-COUNTER           PIC 9(04)  VALUE ZERO COMP-3.
          05 WS-DEFAULT-CHKP-UPD-LIMIT     PIC 9(04)  VALUE 100.        
          05 WS-CHKP-UPD-LIMIT             PIC 9(04)  VALUE ZERO.       
          05 WS-CHKP-UPD-COUNTER           PIC 9(04)  VALUE ZERO COMP-3.
          05 WS-CHKP-SEQ-NO                PIC 9(05)  VALUE ZERO.       
          05 WS-FIOCA05-REC-CNTR           PIC S9(07) VALUE ZERO COMP-3.
          05 WS-FIOCA05-RESTART-CNTR       PIC S9(07) VALUE ZERO COMP-3.
      *                                                                         
       01 WS-RESTART-DATA.                                              
          05 WS-RESTART-PROCESS-TYPE       PIC 9(01).                   
          05 WS-RESTART-JOB-COMPLETE   REDEFINES                        
             WS-RESTART-PROCESS-TYPE       PIC X(01).                   
          05 WS-RESTART-JOB-STATUS         PIC X(01).                   
             88 WS-RUN-COMPLETED-NO-PROBLEMS        VALUE 'A'.          
             88 WS-RERUN-COMPLETED                  VALUE 'B'.          
             88 WS-RERUN-PENDING                    VALUE 'C'.          
          05 WS-RESTART-COMMON-DATE        PIC X(10).                   
          05 WS-RESTART-CHKP-SEQ-NO        PIC 9(05).                   
          05 WS-RESTART-ACCOUNT-NO         PIC X(13)  VALUE SPACES.     
          05 WS-RESTART-FIOCA05-REC-CNTR   PIC S9(07) COMP-3 VALUE ZERO.
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-CURRENT-TIMESTAMP          PIC X(26) VALUE SPACES.      
          05 WS-EXIT-FEE-FCTR              PIC X(09) VALUE 'EXIT FEE'.  
          05 WS-THRM-PRICE                 PIC 9(09) VALUE 0.           
          05 WS-RATE-EXCHANGE-FEE          PIC 9(07) VALUE 0.           
          05 WS-COMMON-DATE                PIC X(10) VALUE SPACES.      
          05 RS-RETURN-CODE                PIC S9(04)    COMP.          
          05 WS-NULL-IND                   PIC S9(04)    COMP.          
          05 WS-SYSTEM                     PIC X(06) VALUE 'SYSTEM'.    
          05 WS-TRAN-APPL-NO               PIC S9(04)    COMP.          
          05 WS-EXCEPTION                  PIC X(01) VALUE SPACES.      
          05 WS-JOB-TYPE                   PIC X(01) VALUE SPACES.      
          05 WS-JOB-TYPE-DESC              PIC X(10) VALUE SPACES.      
          05 WS-COMM-CHANNEL-DESC          PIC X(15) VALUE SPACES.      
          05 WS-DNPFB                      PIC X(01) VALUE SPACES.      
          05 WS-COMM-TYPE-CD               PIC X(02) VALUE '45'.        
          05 WS-COMM-SUBTYPE-CODE          PIC X(02) VALUE '11'.        
          05 WS-RED-FL-NULL-IND            PIC S9(4) COMP  VALUE 0.     
          05 WS-END-NULL-IND               PIC S9(4) COMP  VALUE 0.     
          05 WS-OPTION-COUNT               PIC S9(4) COMP.              
          05 WS-OPTION-SORT-NO             PIC S9(4) COMP.              
          05 WS-SEL-OPTION-DUR-NO          PIC S9(4) USAGE COMP.        
          05 WS-CTR                        PIC 9(4)  VALUE 0.           
          05 WS-THERM-PRICE                PIC 9(05)V999999 VALUE ZERO. 
          05 WS-THERM-PRICE-A REDEFINES                                 
             WS-THERM-PRICE                PIC X(11) .                  
          05 WS-WORKQ-COMMENT              PIC X(100) VALUE SPACES.     
          05 WS-COMM-COMMENT               PIC X(150) VALUE SPACES.     
          05 WS-WORKQ-FULL-COMMENT         PIC X(250) VALUE SPACES.     
          05 WS-COMMON-DATE-FMT.                                        
             10 WS-COMM-MM                 PIC X(02) VALUE SPACES.      
             10 WS-COMM-DD                 PIC X(02) VALUE SPACES.      
             10 WS-COMM-YYYY               PIC X(04) VALUE SPACES.      
          05 WS-VALID-SELECTION            PIC X(01) VALUE SPACES.      
          05 WS-CARD-AUTO-REN-FL           PIC X(01) VALUE SPACES.      
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 WS-NO-MORE-DATA               PIC X(01)  VALUE 'N'.        
             88 NO-MORE-DATA                          VALUE 'Y'.        
          05 WS-FCA05-STATUS               PIC X(02).                   
             88 FCA05-SUCCESSFUL                      VALUE '00'.       
          05 WS-REPORT1-STATUS             PIC X(02).                   
             88 REPORT1-SUCCESSFUL                    VALUE '00'.       
          05 WS-END-OF-FILE                PIC X(01)  VALUE 'N'.        
             88 END-OF-FILE                           VALUE 'Y'.        
          05 WS-RECORD-FOUND               PIC X(01)  VALUE 'N'.        
             88 DATA-RECORD-FOUND                     VALUE 'Y'.        
             88 NO-DATA-RECORD-FOUND                  VALUE 'N'.        
          05 WS-OPTION-MATCHED             PIC X(01)  VALUE 'N'.        
             88 OPTION-MATCHED                        VALUE 'Y'.        
             88 OPTION-NOT-MATCHED                    VALUE 'N'.        
          05 WS-BEGIN-REC-SW               PIC X(01)  VALUE 'N'.        
             88 WS-BEGIN-RECS-PROCESSED               VALUE 'Y'.        
                                                                        
ACT008**** REPORT HEADING                                                       
ACT008 01 WS-REPORT-HDR.                                                
ACT008    05 FILLER               PIC X(20) VALUE SPACES.               
ACT008    05 FILLER               PIC X(18) VALUE 'INVALID SELECTIONS'. 
ACT008    05 FILLER               PIC X(10) VALUE SPACES.               
ACT008    05 FILLER               PIC X(11) VALUE 'RUN DATE : '.        
ACT008    05 WS-REP-DATE          PIC X(10) VALUE SPACES.               
ACT008    05 FILLER               PIC X(218) VALUE SPACES.              
                                                                        
ACT008**** REPORT DETAIL HEADING                                                
ACT008 01 WS-REPORT-DET-HDR.                                            
          05 FILLER               PIC X(10) VALUE 'ACCOUNT NO'.         
          05 WS-FIL1              PIC X(01) VALUE SPACES.               
          05 FILLER               PIC X(09) VALUE 'STUB TYPE'.          
          05 WS-FIL2              PIC X(01) VALUE SPACES.               
          05 FILLER               PIC X(14) VALUE 'DATE PROCESSED'.     
          05 WS-FIL3              PIC X(01) VALUE SPACES.               
          05 FILLER               PIC X(17) VALUE 'OPTION SELECTIONS'.  
          05 WS-FIL4              PIC X(01) VALUE SPACES.               
          05 FILLER               PIC X(08) VALUE 'COMMENTS'.           
          05 FILLER               PIC X(225) VALUE SPACES.              
                                                                        
      **** REPORT DETAILS                                                       
       01 WS-REPORT-DET.                                                
          05 WS-REP-ACCT-NO       PIC X(13) VALUE SPACES.               
          05 WS-FIL5              PIC X(01) VALUE SPACES.               
          05 WS-REP-STUB-TYPE     PIC X(09) VALUE SPACES.               
          05 WS-FIL6              PIC X(01) VALUE SPACES.               
          05 WS-REP-DATE-PROCESS  PIC X(08) VALUE SPACES.               
          05 WS-FIL7              PIC X(01) VALUE SPACES.               
          05 WS-REP-OPT-SEL       PIC X(04) VALUE SPACES.               
          05 WS-FIL8              PIC X(01) VALUE SPACES.               
          05 WS-REP-COMMENTS      PIC X(249) VALUE SPACES.              
                                                                        
      **** TOTAL 111 BYTES LENGTH                                               
       01 WS-WQ-RTPK-DET.                                               
          05 FILLER               PIC X(19) VALUE 'SLCTED OFR & OPT - '.
          05 WS-WQ-OFFER          PIC X(12) VALUE SPACES.               
          05 FILLER               PIC X(01) VALUE SPACES.               
          05 WS-WQ-OPTION         PIC X(12) VALUE SPACES.               
          05 FILLER               PIC X(01) VALUE SPACES.               
          05 WS-WQ-OPT-DESC       PIC X(40) VALUE SPACES.               
          05 FILLER               PIC X(01) VALUE ';'   .               
          05 FILLER               PIC X(06) VALUE 'PRICE '.             
          05 WS-WQ-PRICE          PIC Z9.9999 VALUE ZEROS.              
          05 FILLER               PIC X(01) VALUE ';'   .               
          05 FILLER               PIC X(08) VALUE 'AUTORNW-'.           
          05 WS-WQ-AUTO           PIC X(01) VALUE SPACES.               
          05 FILLER               PIC X(01) VALUE ';' .                 
                                                                        
       01 WS-WQ-COMM-COMMENTS.                                          
      **** WQ COMMENTS                                                          
          05 WS-WQ-COMMENT-1      PIC X(039) VALUE                      
             'ACCOUNT NOT FOUND IN CSS_ACCOUNT TABLE;'.                 
                                                                        
          05 WS-WQ-COMMENT-2      PIC X(046) VALUE                      
             'ACCOUNT NOT FOUND IN CSS_ACT_RT_RENEWAL TABLE;'.          
                                                                        
          05 WS-WQ-COMMENT-3      PIC X(046) VALUE                      
             'ACCOUNT NOT FOUND IN CSS_ACT_RT_REN_DET TABLE;'.          
                                                                        
          05 WS-WQ-COMMENT-4      PIC X(018) VALUE                      
             'INVALID SELECTION;' .                                     
                                                                        
          05 WS-WQ-COMMENT-5      PIC X(015) VALUE                      
             'DROPPED TO VAR;' .                                        
                                                                        
ACT008    05 WS-WQ-COMMENT-6      PIC X(048) VALUE                      
ACT008       "PRVSLY RNW'D; PRICE ON CRD NOT MATCH RNWD PRICE;" .       
                                                                        
          05 WS-WQ-COMMENT-7      PIC X(042) VALUE                      
             'ACCOUNT NOT FOUND IN CSS_ACCT_RTPK_AGR;'.                 
                                                                        
          05 WS-WQ-COMMENT-8      PIC X(032) VALUE                      
             "DRP'D TO VAR; INVALID SELECTION;" .                       
                                                                        
          05 WS-WQ-COMMENT-9      PIC X(032) VALUE                      
             "PRVSLY RNW'D; INVALID SELECTION;" .                       
                                                                        
          05 WS-WQ-COMMENT-10     PIC X(059) VALUE                      
             'TERM OF CURRENT OPTION DOES NOT MATCH WITH SELECTED OPTION        
      -      ';'.                                                               
                                                                        
          05 WS-WQ-COMMENT-11     PIC X(061) VALUE                      
             'CUR AUTO RENEW FL DOES NOT MATCH WITH SELECTED AUTO RENEW         
      -      'FL;'.                                                             
                                                                        
          05 WS-WQ-COMMENT-SCSCA326  PIC X(035) VALUE                   
             'RATE NOT FOUND IN SCSCA326 PROCESS;' .                    
                                                                        
      **** COMMUNICATIONS COMMENTS                                              
                                                                        
          05 WS-COMM-COMMENT-2          PIC X(058) VALUE                
             'RENEWAL CARD RECEIVED BUT NOT PROCESSED - ACCT NOT ACTIVE;        
      -      ''.                                                                
                                                                        
          05 WS-COMM-COMMENT-3          PIC X(054) VALUE                
             'RENEWAL CARD RECEIVED BUT NOT PROCESSED - ACTIVE SONP;' . 
                                                                        
          05 WS-COMM-COMMENT-4          PIC X(055) VALUE                
             'RENEWAL CARD RECEIVED BUT NOT PROCESSED - PENDING TOFF;' .
                                                                        
ACT008    05 WS-COMM-COMMENT-5          PIC X(040) VALUE                
ACT008       'RENEWAL CARD RECEIVED BUT NOT PROCESSED;'.                
                                                                        
          05 WS-COMM-COMMENT-6          PIC X(062) VALUE                
             'RENEWAL CARD RECEIVED BUT NOT PROCESSED - DROPPED TO VARIA        
      -      'BLE;'.                                                            
                                                                        
          05 WS-COMM-COMMENT-8          PIC X(046) VALUE                
             'RENEWAL CARD RECEIVED; PROCESSED SUCCESSFULLY;' .         
                                                                        
ACT008    05 WS-COMM-COMMENT-9          PIC X(071) VALUE                
ACT008       'RENEWAL CARD RECEIVED BUT NOT PROCESSED - COULD NOT VALIDA        
ACT008-      'TE SELECTION;' .                                                  
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                 *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR SCSCB077                   
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00077                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * COMMON COPYBOOK FOR WS-VARIABLES                               *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      * ABEND SWITCH COPYBOOK                                          *        
      ******************************************************************        
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
      ******************************************************************        
      * WORKING STORAGE COPYBOOK FOR SCSCB326                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00326                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************07910200
      *   WORKING STORAGE AREA FOR RESTART-REQUEST PARM                *07910300
      ******************************************************************07910400
      *                                                                 07910500
           COPY CWS00038.                                               07910600
      *                                                                 07910700
      ******************************************************************07870000
      *  WORKING STORAGE AREA FOR COMMON DATES                         *07880000
      ******************************************************************07890000
      *                                                                 07900000
           COPY CWS00039.                                               07910000
      *                                                                 07910100
      ******************************************************************07870000
      * FIOJC01 WORKING STORAGE                                        *07880000
      ******************************************************************07890000
      *                                                                 07900000
           COPY FIOJC01.                                                07910000
      *                                                                 07910100
      ******************************************************************06330000
      * FCA00-KEY                                                      *06340000
      ******************************************************************06350000
      *                                                                 06360000
           COPY FIOCA00.                                                06370000
      *                                                                 06391000
      ******************************************************************06330000
      *    SQL COMMUNICATIONS AREA                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ACCOUNT - AT                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      *    CSS_COMM_DATA  KO                                        *           
      ***************************************************************           
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
      ******************************************************************06330000
      *    CSS_UTIL_ENVRNMT  - UT                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_SO_DATA       - VO                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBSODAT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ACT_RT_RENEWAL - 5A                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRATREN                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ACT_RT_REN_DET - 5B                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRENDET                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ACCT_RTPK_AGR - DF                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_ACCT_MKT_TIER - DD                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBMKTIER                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_FIXED_FCTR    - FF                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_BILL_WINDOW   - BN                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CRM_RT_PKG_OPTION - FI                                      *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CRM_OPT_ATTR_INCTV - HQ                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBOPTATT                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * CSS_MNT_TRANS_HIST, MH                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHIST                                               
            END-EXEC.                                                           
                                                                        
      *****************************************************************         
      * CSS_MT_TRN_HST_DET, MI                                        *         
      *****************************************************************         
            EXEC SQL                                                            
                 INCLUDE TBMNHDT                                                
            END-EXEC.                                                           
                                                                        
      ******************************************************************06330000
      *    CRM_ATTR_PRORATE   - 2L                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATRPRO                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CRM_ATTR_PRO_FCTR  - 2L                                     *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBATRFCT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    TABLE : CSS_JOB_PARM, G6                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************06330000
      *    CSS_RESTART - RF                                            *06340000
      ******************************************************************06350000
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBRESTRT                                                 
           END-EXEC.                                                            
      *                                                                         
ACT008***************************************************************** 06330000
ACT008* CSS_CODE_VALUE   UV                                             06340000
ACT008***************************************************************** 06350000
ACT008      EXEC SQL                                                            
ACT008           INCLUDE TBCDVALU                                               
ACT008      END-EXEC.                                                           
                                                                        
      *                                                                         
       01 WS-END                           PIC X(40) VALUE              
           'WORKING STORAGE FOR PCSCA005 ENDS HERE  '.                  
      *                                                                         
       PROCEDURE DIVISION .                                             
      *                                                                         
      ******************************************************************        
      *  0000-MAINLINE                                                 *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
      *                                                                         
           PERFORM 1000-MAIN-PROCESS            THRU 1000-EXIT          
                                                UNTIL END-OF-FILE.      
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              MOVE WS-B                     TO WS-RESTART-JOB-STATUS    
              DISPLAY 'PCSCA005 RERUN COMPLETED'                        
           ELSE                                                         
              MOVE WS-A                     TO WS-RESTART-JOB-STATUS    
                                                                        
              DISPLAY 'PCSCA005 COMPLETED SUCCESSFULLY'                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8850-DEL-RESTART-REC         THRU 8850-EXIT.         
           PERFORM 8889-COMMIT                  THRU 8889-EXIT.         
           PERFORM 9000-TERMINATE               THRU 9000-EXIT.         
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************06150000
      *  0100-INITIALIZE                                               *06160000
      ******************************************************************06230000
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                 06250000
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
      *                                                                 06250000
           INITIALIZE WS-SYSIPT.                                        
           PERFORM 6253-GET-FJC01-CHKP-LIMIT    THRU 6253-EXIT.         
           PERFORM 6251-GET-FJC01-DATE          THRU 6251-EXIT.         
           IF COMMON-DATE-NEEDED                                        
              PERFORM 6240-GET-FCA00-COMMON-DATE THRU 6240-EXIT         
              MOVE WS-FCA00-COMMON-DATE     TO WS-INPUT-DATE            
           END-IF.                                                      
           MOVE WS-INPUT-DATE               TO WS-COMMON-DATE.          
           MOVE WS-COMMON-DATE(1:4)         TO WS-COMM-YYYY.            
           MOVE WS-COMMON-DATE(6:2)         TO WS-COMM-MM.              
           MOVE WS-COMMON-DATE(9:2)         TO WS-COMM-DD.              
           DISPLAY 'PCSCA005 RUNNING DATE - '  WS-COMMON-DATE.          
                                                                        
      *                                                                         
           OPEN INPUT FCSCA05-FILE.                                     
           IF FCA05-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************'               
              DISPLAY '** 0100-INITIALIZE               '               
              DISPLAY '** ERROR ON OPENING FCSA005 FILE.'               
              DISPLAY '** STATUS IS ', WS-FCA05-STATUS                  
              DISPLAY '*********************************'               
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                 04680000
           OPEN OUTPUT FCSCA05-REPORT.                                  
           IF REPORT1-SUCCESSFUL                                        
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*********************************'               
              DISPLAY '** 0100-INITIALIZE               '               
              DISPLAY '** ERROR ON OPENING REPORT  FILE.'               
              DISPLAY '** STATUS IS ', WS-REPORT1-STATUS                
              DISPLAY '*********************************'               
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
ACT008***  REPORT HEADERS PRINT                                         04680000
           MOVE SPACES TO REPORT-REC.                                   
ACT008     MOVE WS-COMMON-DATE TO WS-REP-DATE.                          
ACT008     WRITE REPORT-REC FROM WS-REPORT-HDR.                         
                                                                        
HEX01      MOVE X'09' TO WS-FIL1  WS-FIL2  WS-FIL3 WS-FIL4              
ACT008     WRITE REPORT-REC FROM WS-REPORT-DET-HDR.                     
                                                                        
           PERFORM 0200-CHECK-RESTART       THRU 0200-EXIT.             
           PERFORM 0300-PREPARE-RESTART     THRU 0300-EXIT.             
           IF WS-THIS-IS-NOT-A-RESTART                                  
              PERFORM 0500-PROCESS-BEGIN-REC    THRU 0500-EXIT          
           END-IF.                                                      
      *                                                                 04680000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0200-CHECK-RESTART.                                            *        
      ******************************************************************        
      *                                                                         
       0200-CHECK-RESTART.                                              
      *                                                                         
            MOVE WS-PGRMNAME                TO RF-NAME-PROGRAM.         
      *                                                                         
            PERFORM 7160-SELECT-RESTART         THRU 7160-EXIT.         
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE RF-RESTART-DATA-TEXT    TO WS-RESTART-DATA          
               IF WS-RESTART-PROCESS-TYPE NUMERIC                       
                  MOVE WS-Y                 TO WS-IS-THIS-A-RESTART     
               END-IF                                                   
            ELSE                                                        
               GO TO 0200-EXIT                                          
            END-IF.                                                     
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  0300-PREPARE-RESTART                                          *        
      ******************************************************************        
      *                                                                         
       0300-PREPARE-RESTART.                                            
      *                                                                         
           IF WS-THIS-IS-A-RESTART                                      
              DISPLAY '*******************************************'     
              DISPLAY '**   THIS IS A RESTART OF PCSCA005       **'     
              DISPLAY '*LAST PROCESSED ACCOUNT # ' WS-RESTART-ACCOUNT-NO
              DISPLAY '*CONTINUING FROM COMMIT #' WS-RESTART-CHKP-SEQ-NO
              DISPLAY '*******************************************'     
              MOVE WS-RESTART-CHKP-SEQ-NO   TO WS-CHKP-SEQ-NO           
              PERFORM 7050-READ-FIOCA05         THRU 7050-EXIT          
                UNTIL WS-FIOCA05-REC-CNTR = WS-RESTART-FIOCA05-REC-CNTR 
           END-IF.                                                      
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0500-PROCESS-BEGIN-REC.                                        *        
      *   THIS PARAGRAPH DOES AN INITIAL READ TO THE FIOCA05 FILE AND  *        
      *   CHECKS FOR A BEGINNING RECORD. WHEN FOUND THE DATE ON        *        
      *   THE BEGIN RECORD IS COMPARED TO THE RUN DATE OBTAINED        *        
      *   FROM THE JOBS TABLE TO ENSURE WE ARE PROCESSING WITH         *        
      *   THE CORRECT FILE.                                            *        
      ******************************************************************        
      *                                                                         
       0500-PROCESS-BEGIN-REC.                                          
      *                                                                         
           PERFORM 7050-READ-FIOCA05            THRU 7050-EXIT.         
      *                                                                         
           EVALUATE TRUE                                                
               WHEN END-OF-FILE                                         
                    DISPLAY '********************************'          
                    DISPLAY '**    PCSCA005 PROCESSING ERROR '          
                    DISPLAY '**      FIOCA05 FILE IS EMPTY   '          
                    DISPLAY '**      PROCESSING TERMINATED   '          
                    DISPLAY '********************************'          
                    PERFORM 9900-ABEND          THRU 9900-EXIT          
               WHEN E-FCA05-DATE-PROCESSED  NOT = WS-COMMON-DATE-FMT    
                    DISPLAY '**********************************'        
                    DISPLAY '**     PCSCA005 PROCESSING ERROR  '        
                    DISPLAY '** FIOCA05 CREATE DATE NOT = RUN DATE '    
                    DISPLAY '** FILE CREATE DT:' E-FCA05-DATE-PROCESSED 
                    DISPLAY '** RUN DATE      :' WS-COMMON-DATE-FMT     
                    DISPLAY '**       PROCESSING TERMINATED    '        
                    DISPLAY '**********************************'        
                    PERFORM 9900-ABEND       THRU 9900-EXIT             
           END-EVALUATE.                                                
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-MAIN-PROCESS.                                             *        
      ******************************************************************        
      *                                                                         
       1000-MAIN-PROCESS.                                               
      *                                                                         
           PERFORM 2000-OUTPUT-PROCESS    THRU 2000-EXIT                
      *                                                                         
           PERFORM 7050-READ-FIOCA05      THRU 7050-EXIT                
      *                                                                         
           IF WS-COMMIT-COUNTER = WS-CHKP-LUW-LIMIT OR                  
              WS-COMMIT-COUNTER = WS-CHKP-UPD-LIMIT                     
              PERFORM 8888-COMMIT               THRU 8888-EXIT          
              MOVE ZEROES                   TO WS-COMMIT-COUNTER        
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-OUTPUT-PROCESS.                                           *        
      ******************************************************************        
      *2000-OUTPUT-PROCESS.                                                     
      ******************************************************************        
      *                                                                         
       2000-OUTPUT-PROCESS.                                             
      *                                                                         
           PERFORM 2100-EXCEPTION-PROCESS   THRU 2100-EXIT.             
           IF WS-EXCEPTION = WS-N                                       
              PERFORM 2200-PROCESS-ACCOUNT  THRU 2200-EXIT              
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
            EXIT.                                                       
      ****************************************************************          
      *  2100-EXCEPTION-PROCESS.                                     *          
      ****************************************************************          
      *                                                                         
       2100-EXCEPTION-PROCESS.                                          
                                                                        
            DISPLAY 'PROCESSING ACCT# ' E-FCA05-ACCOUNT-NO.             
                                                                        
      *--- INITIALIZE VARIABLES.                                                
            INITIALIZE WS-OPTION-COUNT.                                 
            MOVE WS-N                            TO WS-EXCEPTION        
            MOVE WS-Y                            TO WS-VALID-SELECTION  
            MOVE ZEROS                           TO AT-PREMISE-NO       
                                                    AT-CUSTOMER-NO      
                                                    5B-THERM-PRICE      
            MOVE SPACES                          TO AT-LOCAL-OFFICE     
                                                    5B-OPTION-CD        
                                                    DF-OPT-AGRMT-EFF-DT 
                                                    FI-OPT-DESC-INT     
ACT018                                              5B-OFFER-CD.        
            MOVE SPACES                          TO WS-JOB-TYPE         
                                                    WS-CARD-AUTO-REN-FL 
            MOVE SPACES                          TO WS-WORKQ-COMMENT.   
            MOVE SPACES                          TO WS-COMM-COMMENT     
ACT008                                              WS-COMM-CHANNEL-DESC
                                                    WS-REP-COMMENTS.    
                                                                        
      *--- B-BILL ; L-LETTER                                                    
            IF E-FCA05-JOB-TYPE = 'P'                                   
               MOVE 'B'                      TO WS-JOB-TYPE             
               MOVE 'BILL STUB;'             TO WS-JOB-TYPE-DESC        
            ELSE                                                        
               MOVE 'L'                      TO WS-JOB-TYPE             
               MOVE 'LTR STUB;'              TO WS-JOB-TYPE-DESC        
            END-IF.                                                     
                                                                        
      *WHEN ACCOUNT IS NOT FOUND IN CSS_ACCOUNT                                 
            MOVE E-FCA05-ACCOUNT-NO              TO AT-ACCOUNT-NO.      
            PERFORM 7200-SELECT-ACCT-STATUS      THRU 7200-EXIT         
            IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE WS-Y                         TO WS-EXCEPTION        
ACT008         MOVE WS-WQ-COMMENT-1              TO WS-REP-COMMENTS     
ACT008         PERFORM 2160-WRITE-REPORT       THRU 2160-EXIT           
               GO TO 2100-EXIT                                          
            END-IF                                                      
                                                                        
      *WHEN ACCOUNT IS NOT FOUND IN CSS_ACT_RT_RENEWAL                          
            MOVE E-FCA05-ACCOUNT-NO              TO 5A-ACCOUNT-NO       
            PERFORM 7500-SELECT-ACT-RT-REN       THRU 7500-EXIT         
            IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE WS-Y                         TO WS-EXCEPTION        
ACT008         MOVE WS-WQ-COMMENT-2              TO WS-REP-COMMENTS     
               PERFORM 2160-WRITE-REPORT       THRU 2160-EXIT           
               GO TO 2100-EXIT                                          
            END-IF.                                                     
                                                                        
            MOVE 5A-ACCOUNT-NO                   TO 5B-ACCOUNT-NO.      
            MOVE 5A-CODE-UTIL-TYPE               TO 5B-CODE-UTIL-TYPE.  
            MOVE 5A-IC-NO                        TO 5B-IC-NO.           
            MOVE 5A-SEQ-NO                       TO 5B-SEQ-NO.          
                                                                        
      *CUSTOMER OPTION SELECTION UPDATES IN CSS_ACT_RT_REN_DET                  
            IF E-FCA05-SELECTION-CODE-1 = WS-Y                          
                ADD +1                          TO WS-OPTION-COUNT      
                MOVE 1                          TO WS-OPTION-SORT-NO    
                MOVE E-FCA05-SELECTION-CODE-1   TO 5B-SELECTION-CD      
                MOVE E-FCA05-AUTO-OPT-IN-FLAG   TO 5B-AUTO-REN-OPT-IN-FL
                MOVE WS-OPTION-SORT-NO          TO 5B-OPTION-SORT-NO    
                PERFORM 8000-UPDT-ACCT-REN-DET  THRU 8000-EXIT          
                IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   STRING WS-WQ-COMMENT-4          DELIMITED BY SIZE    
                          'SELECTED OPT 1'        DELIMITED BY SIZE     
                          E-FCA05-SELECTION-CODE-1 DELIMITED BY SIZE    
                     INTO WS-WORKQ-COMMENT                              
                   END-STRING                                           
                   PERFORM 2150-CREATE-WQ       THRU 2150-EXIT          
ACT133             MOVE WS-Y                      TO WS-EXCEPTION       
                   GO TO 2100-EXIT                                      
                END-IF                                                  
            END-IF.                                                     
                                                                        
            IF E-FCA05-SELECTION-CODE-2 = WS-Y                          
                ADD +1                          TO WS-OPTION-COUNT      
                MOVE 2                          TO WS-OPTION-SORT-NO    
                MOVE E-FCA05-SELECTION-CODE-2   TO 5B-SELECTION-CD      
                MOVE E-FCA05-AUTO-OPT-IN-FLAG   TO 5B-AUTO-REN-OPT-IN-FL
                MOVE WS-OPTION-SORT-NO          TO 5B-OPTION-SORT-NO    
                PERFORM 8000-UPDT-ACCT-REN-DET  THRU 8000-EXIT          
                IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   STRING WS-WQ-COMMENT-4          DELIMITED BY SIZE    
                          'SELECTED OPT 2'        DELIMITED BY SIZE     
                          E-FCA05-SELECTION-CODE-2 DELIMITED BY SIZE    
                     INTO WS-WORKQ-COMMENT                              
                   END-STRING                                           
                   PERFORM 2150-CREATE-WQ       THRU 2150-EXIT          
ACT133             MOVE WS-Y                      TO WS-EXCEPTION       
                   GO TO 2100-EXIT                                      
                END-IF                                                  
            END-IF.                                                     
                                                                        
            IF E-FCA05-SELECTION-CODE-3 = WS-Y                          
                ADD +1                          TO WS-OPTION-COUNT      
                MOVE 3                          TO WS-OPTION-SORT-NO    
                MOVE E-FCA05-SELECTION-CODE-3   TO 5B-SELECTION-CD      
                MOVE E-FCA05-AUTO-OPT-IN-FLAG   TO 5B-AUTO-REN-OPT-IN-FL
                MOVE WS-OPTION-SORT-NO          TO 5B-OPTION-SORT-NO    
                PERFORM 8000-UPDT-ACCT-REN-DET  THRU 8000-EXIT          
                IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   STRING WS-WQ-COMMENT-4          DELIMITED BY SIZE    
                          'SELECTED OPT 3'        DELIMITED BY SIZE     
                          E-FCA05-SELECTION-CODE-3 DELIMITED BY SIZE    
                     INTO WS-WORKQ-COMMENT                              
                   END-STRING                                           
                   PERFORM 2150-CREATE-WQ       THRU 2150-EXIT          
ACT133             MOVE WS-Y                      TO WS-EXCEPTION       
                   GO TO 2100-EXIT                                      
                END-IF                                                  
            END-IF.                                                     
                                                                        
                                                                        
      *CUSTOMER SELECTION VALIDATION                                            
      * WS-OPTION-COUNT = 1 - ONE OPTION IS SELECTED                            
      * WS-OPTION-COUNT > 1 - MULTIPLE OPTIONS SELECTED                         
            IF WS-OPTION-COUNT = 1                                      
               MOVE WS-OPTION-SORT-NO               TO 5B-OPTION-SORT-NO
               PERFORM 7550-SEL-ACT-RT-REN-DET      THRU 7550-EXIT      
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                  MOVE WS-Y                       TO WS-EXCEPTION       
ACT008            MOVE WS-WQ-COMMENT-3            TO WS-REP-COMMENTS    
                  PERFORM 2160-WRITE-REPORT     THRU 2160-EXIT          
                  GO TO 2100-EXIT                                       
               END-IF                                                   
            ELSE                                                        
      *------ WS-OPTION-COUNT = 0 - CUSTOMER MAKES NO SELECTION AT ALL          
               IF WS-OPTION-COUNT = 0                                   
                  IF E-FCA05-AUTO-OPT-IN-FLAG = WS-N                    
                     MOVE WS-Y                         TO WS-EXCEPTION  
                     STRING WS-JOB-TYPE-DESC  DELIMITED BY SIZE         
                            WS-COMM-COMMENT-9 DELIMITED BY SIZE         
                       INTO WS-COMM-COMMENT                             
                     END-STRING                                         
                     PERFORM 2110-CREATE-COMM-REC THRU 2110-EXIT        
                     MOVE    WS-COMM-COMMENT-9      TO WS-REP-COMMENTS  
                     PERFORM 2160-WRITE-REPORT    THRU 2160-EXIT        
                     GO TO 2100-EXIT                                    
                  ELSE                                                  
                     MOVE WS-Y                   TO WS-EXCEPTION        
                     MOVE WS-N                   TO WS-VALID-SELECTION  
                  END-IF                                                
               ELSE                                                     
                  MOVE WS-Y                       TO WS-EXCEPTION       
                  MOVE WS-N                       TO WS-VALID-SELECTION 
               END-IF                                                   
            END-IF.                                                     
                                                                        
      *ACCOUNT STATUS VALIDATION                                                
            IF AT-CODE-ACCT-STAT  NOT EQUAL 'A'                         
               MOVE WS-Y                         TO WS-EXCEPTION        
               STRING WS-JOB-TYPE-DESC  DELIMITED BY SIZE               
                      WS-COMM-COMMENT-2 DELIMITED BY SIZE               
                 INTO WS-COMM-COMMENT                                   
               END-STRING                                               
               PERFORM 2110-CREATE-COMM-REC      THRU 2110-EXIT         
               GO TO 2100-EXIT                                          
            END-IF.                                                     
                                                                        
      *SERVICE ORDER VALIDATION FOR OFF01 OR DNPFB ORDERS                       
            MOVE    AT-ACCOUNT-NO             TO VO-ACCOUNT-NO          
            PERFORM 7300-SELECT-DNPFB         THRU 7300-EXIT            
            IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF VO-ORDER-TYPE-CD = 'DNPFB'                            
                  STRING WS-JOB-TYPE-DESC  DELIMITED BY SIZE            
                         WS-COMM-COMMENT-3 DELIMITED BY SIZE            
                    INTO WS-COMM-COMMENT                                
                  END-STRING                                            
               ELSE                                                     
                  STRING WS-JOB-TYPE-DESC  DELIMITED BY SIZE            
                         WS-COMM-COMMENT-4 DELIMITED BY SIZE            
                    INTO WS-COMM-COMMENT                                
                  END-STRING                                            
               END-IF                                                   
               MOVE WS-Y                      TO WS-EXCEPTION           
               PERFORM 2110-CREATE-COMM-REC   THRU 2110-EXIT            
               GO TO 2100-EXIT                                          
            END-IF.                                                     
                                                                        
      * RTPKG DETAILS VALIDATION                                                
            MOVE    AT-ACCOUNT-NO                TO DF-ACCOUNT-NO.      
            PERFORM 7560-SELECT-RATE-PKG-AGR     THRU 7560-EXIT.        
            IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL          
               MOVE WS-Y                         TO WS-EXCEPTION        
               MOVE WS-WQ-COMMENT-7              TO WS-WORKQ-COMMENT    
               PERFORM 2150-CREATE-WQ            THRU 2150-EXIT         
               GO TO 2100-EXIT                                          
            END-IF.                                                     
                                                                        
ACT008* GET COMM_CHANNEL DESCRIPTION TO USE IN WQ                               
                                                                        
ACT008      MOVE +12                      TO UV-COLUMN-NA-LEN.          
ACT008      MOVE 'COMM_CHANNEL'           TO UV-COLUMN-NA-TEXT.         
ACT008      MOVE +17                      TO UV-TABLE-NA-LEN.           
ACT008      MOVE 'CSS_ACCT_RTPK_AGR'      TO UV-TABLE-NA-TEXT.          
ACT008      MOVE 01                       TO UV-CODE-VALUE-LEN.         
ACT008      MOVE DF-COMM-CHANNEL          TO UV-CODE-VALUE-TEXT.        
ACT008      MOVE 'ALL'                    TO UV-PROGRAM-ID.             
ACT008      PERFORM 7570-GET-CODE-VALUE   THRU 7570-EXIT.               
ACT008      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
ACT008         MOVE UV-CODE-LONG-DESC-TEXT(1:UV-CODE-LONG-DESC-LEN)     
ACT008           TO WS-COMM-CHANNEL-DESC                                
ACT008      ELSE                                                        
ACT008         MOVE SPACES TO WS-COMM-CHANNEL-DESC                      
ACT008      END-IF.                                                     
                                                                        
      * GET DURATION REMAINING & OPTION DURATION-NO                             
            MOVE 5A-ACCOUNT-NO                 TO FF-ACCOUNT-NO.        
            MOVE 5A-CODE-UTIL-TYPE             TO FF-CODE-UTIL-TYPE.    
            MOVE 5A-IC-NO                      TO FF-IC-NO.             
            MOVE DF-OPTION-CD                  TO HQ-OPTION-CD          
            MOVE DF-COMPANY-NO                 TO HQ-COMPANY-NO.        
            MOVE DF-RT-PKG-OPT-SEQ-NO          TO FF-RT-PKG-OPT-SEQ-NO. 
            PERFORM 7700-FIND-DURATION-REM     THRU 7700-EXIT.          
                                                                        
      * GET SELECTED OPTION DURATION-NO                                         
            MOVE 5B-OPTION-CD                  TO HQ-OPTION-CD          
            PERFORM 7710-FIND-DURATION-NO    THRU 7710-EXIT.            
                                                                        
      * RTPKG STATUS VALIDATIONS                                                
      * EXCEPTION WHEN ACCOUNT IN 'OPEN FOR RENEWAL' AND NO VALID OPTION        
            IF DF-STATUS-CD = 'O'                                       
               IF WS-VALID-SELECTION = 'N'                              
                  MOVE WS-Y                         TO WS-EXCEPTION     
                  STRING WS-WQ-COMMENT-4          DELIMITED BY SIZE     
                         'CARD SELECTIONS - '     DELIMITED BY SIZE     
                         E-FCA05-AUTO-OPT-IN-FLAG DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-1 DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-2 DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-3 DELIMITED BY SIZE     
ACT008              INTO WS-REP-COMMENTS                                
                  END-STRING                                            
                  STRING WS-JOB-TYPE-DESC         DELIMITED BY SIZE     
ACT008                   WS-COMM-COMMENT-9        DELIMITED BY SIZE     
                    INTO WS-COMM-COMMENT                                
                  END-STRING                                            
                  PERFORM 2110-CREATE-COMM-REC      THRU 2110-EXIT      
                  PERFORM 2160-WRITE-REPORT    THRU 2160-EXIT           
                  GO TO 2100-EXIT                                       
               ELSE                                                     
                  GO TO 2100-EXIT                                       
               END-IF                                                   
            END-IF.                                                     
                                                                        
      * FOLLOWING EXCEPTIONS ARE IF ACCOUNT HAS ALREADY RENEWED OR DROP-        
      * PED BY THE TIME RENEWAL CARD CAME IN FOR PROCESSING.                    
                                                                        
ACT035      MOVE WS-Y                            TO WS-EXCEPTION        
                                                                        
      * EXCEPTION WHEN ACCOUNT DROPPED TO VARIABLE                              
            IF DF-AGREEMNT-SOURCE-CD  = 'FDN' OR 'FDH' OR               
                                        'FDM' OR 'FD2'                  
               MOVE    WS-Y                 TO  WS-EXCEPTION            
               IF WS-VALID-SELECTION = 'Y'                              
                  MOVE WS-WQ-COMMENT-5   TO WS-WORKQ-COMMENT            
ACT008            PERFORM 2150-CREATE-WQ       THRU 2150-EXIT           
               ELSE                                                     
                  STRING WS-WQ-COMMENT-8          DELIMITED BY SIZE     
                         'CARD SELECTIONS - '     DELIMITED BY SIZE     
                         E-FCA05-AUTO-OPT-IN-FLAG DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-1 DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-2 DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-3 DELIMITED BY SIZE     
ACT008              INTO WS-REP-COMMENTS                                
                  END-STRING                                            
ACT008            PERFORM 2160-WRITE-REPORT    THRU 2160-EXIT           
               END-IF                                                   
               STRING WS-JOB-TYPE-DESC      DELIMITED BY SIZE           
                      WS-COMM-COMMENT-6     DELIMITED BY SIZE           
                 INTO WS-COMM-COMMENT                                   
               END-STRING                                               
               PERFORM 2110-CREATE-COMM-REC THRU 2110-EXIT              
               GO TO 2100-EXIT                                          
            END-IF                                                      
                                                                        
      * EXCEPTIONS WHEN ACCOUNT HAS RENEWED                                     
            IF DF-AGREEMNT-SOURCE-CD  = 'FRN' OR 'FRH' OR 'FRL' OR      
ACT035                                  'FRM' OR 'FR2' OR 'VRN' OR      
ACT035                                  '   '                           
               MOVE    WS-Y                 TO  WS-EXCEPTION            
      *------  HAS NO VALID SELECTION                                           
               IF WS-VALID-SELECTION = 'N'                              
                  STRING WS-WQ-COMMENT-9          DELIMITED BY SIZE     
ACT008                   'RNWD BY - '             DELIMITED BY SIZE     
ACT008                   WS-COMM-CHANNEL-DESC     DELIMITED BY SIZE     
ACT008                   ';CARD SELECTIONS - '    DELIMITED BY SIZE     
                         E-FCA05-AUTO-OPT-IN-FLAG DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-1 DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-2 DELIMITED BY SIZE     
                         E-FCA05-SELECTION-CODE-3 DELIMITED BY SIZE     
ACT008              INTO WS-REP-COMMENTS                                
                  END-STRING                                            
                  PERFORM 2160-WRITE-REPORT    THRU 2160-EXIT           
ACT035            GO TO 2100-EXIT                                       
               ELSE                                                     
      *---------- IF CURR OPT TERM DOES NOT MATCH WITH SEL OPT TERM             
                  IF HQ-DURATION-NO NOT = WS-SEL-OPTION-DUR-NO          
ACT008               STRING WS-WQ-COMMENT-10      DELIMITED BY SIZE     
ACT008                      'RNWD BY-'            DELIMITED BY SIZE     
ACT008                      WS-COMM-CHANNEL-DESC  DELIMITED BY SIZE     
ACT008                      ';'                   DELIMITED BY SIZE     
ACT008                 INTO WS-WORKQ-COMMENT                            
ACT008               END-STRING                                         
                     PERFORM 2150-CREATE-WQ        THRU 2150-EXIT       
ACT008               STRING 'ALREADY RENEWED-'    DELIMITED BY SIZE     
                            WS-JOB-TYPE-DESC      DELIMITED BY SIZE     
                            WS-COMM-COMMENT-5     DELIMITED BY SIZE     
                       INTO WS-COMM-COMMENT                             
                     END-STRING                                         
                     PERFORM 2110-CREATE-COMM-REC  THRU 2110-EXIT       
                     GO TO 2100-EXIT                                    
                  END-IF                                                
      *---------- IF CUR AUTO RENEW DOES NOT MATCH WITH CARD AUTO RENEW         
                  IF ((DF-AUTO-REN-OPT-IN-FL = 'I' AND                  
                      E-FCA05-AUTO-OPT-IN-FLAG = WS-N)                  
                            OR                                          
                     (DF-AUTO-REN-OPT-IN-FL NOT = 'I' AND               
                      E-FCA05-AUTO-OPT-IN-FLAG = WS-Y))                 
ACT008                  STRING WS-WQ-COMMENT-11      DELIMITED BY SIZE  
ACT008                         'RNWD BY-'            DELIMITED BY SIZE  
ACT008                         WS-COMM-CHANNEL-DESC  DELIMITED BY SIZE  
ACT008                         ';'                   DELIMITED BY SIZE  
ACT008                    INTO WS-WORKQ-COMMENT                         
ACT008                  END-STRING                                      
                        PERFORM 2150-CREATE-WQ        THRU 2150-EXIT    
ACT008                  STRING 'ALREADY RENEWED-'    DELIMITED BY SIZE  
                               WS-JOB-TYPE-DESC      DELIMITED BY SIZE  
                               WS-COMM-COMMENT-5     DELIMITED BY SIZE  
                          INTO WS-COMM-COMMENT                          
                        END-STRING                                      
                        PERFORM 2110-CREATE-COMM-REC  THRU 2110-EXIT    
                        GO TO 2100-EXIT                                 
                  END-IF                                                
      *---------- IF CUR PRICE IS <= SELECTED PRICE                             
                  IF FF-FACTOR     <=  5B-THERM-PRICE                   
ACT008               STRING 'ALREADY RENEWED-'    DELIMITED BY SIZE     
                            WS-JOB-TYPE-DESC      DELIMITED BY SIZE     
                            WS-COMM-COMMENT-5     DELIMITED BY SIZE     
                       INTO WS-COMM-COMMENT                             
                     END-STRING                                         
                     PERFORM 2110-CREATE-COMM-REC  THRU 2110-EXIT       
ACT035               GO TO 2100-EXIT                                    
                  ELSE                                                  
      *------------- IF CUR PRICE IS > SELECTED PRICE                           
ACT008               STRING WS-WQ-COMMENT-6       DELIMITED BY SIZE     
ACT008                      'RNWD BY-'            DELIMITED BY SIZE     
ACT008                      WS-COMM-CHANNEL-DESC  DELIMITED BY SIZE     
ACT008                      ';'                   DELIMITED BY SIZE     
ACT008                 INTO WS-WORKQ-COMMENT                            
ACT008               END-STRING                                         
                     PERFORM 2150-CREATE-WQ        THRU 2150-EXIT       
ACT008               STRING 'ALREADY RENEWED-'    DELIMITED BY SIZE     
ACT008                      WS-JOB-TYPE-DESC      DELIMITED BY SIZE     
ACT008                      WS-COMM-COMMENT-5     DELIMITED BY SIZE     
ACT008                 INTO WS-COMM-COMMENT                             
ACT008               END-STRING                                         
                     PERFORM 2110-CREATE-COMM-REC  THRU 2110-EXIT       
ACT035               GO TO 2100-EXIT                                    
                  END-IF                                                
               END-IF                                                   
            END-IF.                                                     
                                                                        
      * IN CASE FOR SOME REASON DID NOT PROCESS IN ANY LOGIC WITH EXCEP-        
      *  TION                                                                   
ACT035      DISPLAY 'ACCOUNT-NO: '    E-FCA05-ACCOUNT-NO                
ACT035              ' DF-STATUS-CD: ' DF-STATUS-CD                      
ACT035              ' DF-AGRSRC-CD: ' DF-AGREEMNT-SOURCE-CD .           
                                                                        
       2100-EXIT.                                                       
            EXIT.                                                       
      *****************************************************************         
      * 2110-CREATE-COMM-REC.                                         *         
      *   LOAD COMMUNICATION DATA.                                    *         
      *****************************************************************         
       2110-CREATE-COMM-REC.                                            
      *                                                                         
           MOVE AT-COMPANY-NO          TO KO-COMPANY-NO.                
           MOVE WS-N                   TO KO-RED-FLAG-IND.              
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
           MOVE -1                     TO WS-RED-FL-NULL-IND.           
           MOVE 'L'                    TO KO-COMM-METHOD.               
           MOVE 'I'                    TO KO-COMM-DIRECTION.            
           MOVE WS-COMM-TYPE-CD        TO KO-COMM-TYPE-CD.              
           MOVE WS-COMM-SUBTYPE-CODE   TO KO-COMM-SUBTYPE-CODE.         
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE SPACES                 TO KO-PROMOTION-ID.              
           MOVE SPACES                 TO KO-PSC-COMPLIANCE-IND.        
           MOVE 0                      TO KO-CALL-ORIGIN-ID.            
           MOVE SPACES                 TO KO-CALL-END-TIME.             
           MOVE -1                     TO WS-END-NULL-IND.              
           MOVE 0                      TO KO-NUMBER-TRANSFERS.          
           MOVE 0                      TO KO-HOLD-TIME.                 
           MOVE 0                      TO KO-QUEUE-TIME.                
           MOVE WS-N                   TO KO-SCREEN-POP-IND.            
           MOVE 0                      TO KO-TOTAL-CALL-TIME.           
           MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
           MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
           MOVE SPACES                 TO KO-SOLICITATION-CD.           
           MOVE 'A'                    TO KO-COMM-ASSOC-CD.             
           MOVE WS-N                   TO KO-COMPLAINT-FL.              
           MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
           MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
           MOVE 'SYSTEM'               TO KO-CONTACT-NAME.              
           MOVE AT-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
           MOVE AT-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO KO-PREMISE-NO.                
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE LENGTH OF  WS-COMM-COMMENT                              
                                       TO KO-INITIAL-COMMENT-TX-LEN.    
           MOVE WS-COMM-COMMENT        TO KO-INITIAL-COMMENT-TX-TEXT.   
           PERFORM 8100-INSERT-COMM-DATA  THRU 8100-EXIT.               
      *                                                                         
       2110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2150-CREATE-WQ.                                              *          
      *****************************************************************         
       2150-CREATE-WQ.                                                  
                                                                        
           INITIALIZE WS-WQ-RTPK-DET .                                  
           PERFORM 7000-GET-CURR-TIMESTAMP  THRU 7000-EXIT.             
           MOVE WS-N                         TO WS-77-PRIORITY          
           MOVE 580                          TO WS-77-CATEGORY-ID       
           MOVE ZEROS                        TO WS-77-SERV-ORDER-NO     
           MOVE SPACES                       TO WS-77-RESP-AREA-ID      
           MOVE WS-CURRENT-TIMESTAMP         TO WS-77-DATE-REQUIRED     
           MOVE WS-CURRENT-TIMESTAMP         TO WS-77-DATE-CREATED      
           MOVE AT-ACCOUNT-NO                TO WS-77-ACCOUNT-NO        
           MOVE AT-PREMISE-NO                TO WS-77-PREMISE-NO        
           MOVE AT-CUSTOMER-NO               TO WS-77-CUSTOMER-NO       
           MOVE AT-LOCAL-OFFICE              TO WS-77-LOCAL-OFFICE      
           MOVE 4                            TO WS-77-ROUTE-CATEGORY    
           MOVE ZEROS                        TO WS-77-FREE-FORM-LEN     
           MOVE LOW-VALUES                   TO WS-77-FREE-FORM-TXT     
           MOVE WS-PGRMNAME                  TO WS-77-CREATED-BY        
           MOVE SPACES                       TO WS-WORKQ-FULL-COMMENT   
           MOVE 5B-OPTION-CD                 TO WS-WQ-OPTION.           
ACT018     MOVE 5B-OFFER-CD                  TO WS-WQ-OFFER.            
           MOVE 5B-THERM-PRICE               TO WS-THERM-PRICE          
                                                WS-WQ-PRICE.            
           MOVE E-FCA05-AUTO-OPT-IN-FLAG     TO WS-WQ-AUTO.             
                                                                        
           IF 5B-OPTION-CD > SPACES                                     
              MOVE 5B-OPTION-CD                 TO FI-OPTION-CD         
              MOVE AT-COMPANY-NO                TO FI-COMPANY-NO        
              PERFORM 7760-GET-OPTION-DETAILS   THRU 7760-EXIT          
           END-IF.                                                      
                                                                        
           MOVE FI-OPT-DESC-INT              TO WS-WQ-OPT-DESC.         
                                                                        
           PERFORM VARYING WS-CTR FROM 100 BY -1                        
                   UNTIL WS-WORKQ-COMMENT(WS-CTR:1) > SPACE             
                      OR WS-CTR = 0                                     
           END-PERFORM                                                  
                                                                        
           IF WS-VALID-SELECTION = 'N'                                  
              STRING WS-JOB-TYPE-DESC           DELIMITED BY SIZE       
                     WS-WORKQ-COMMENT(1:WS-CTR) DELIMITED BY SIZE       
                INTO WS-WORKQ-FULL-COMMENT                              
              END-STRING                                                
           ELSE                                                         
              STRING WS-JOB-TYPE-DESC           DELIMITED BY SIZE       
                     WS-WORKQ-COMMENT(1:WS-CTR) DELIMITED BY SIZE       
                     WS-WQ-RTPK-DET             DELIMITED BY SIZE       
                INTO WS-WORKQ-FULL-COMMENT                              
              END-STRING                                                
           END-IF                                                       
                                                                        
           MOVE LENGTH OF WS-WORKQ-FULL-COMMENT TO WS-77-COMMENTS-LEN   
           MOVE WS-WORKQ-FULL-COMMENT           TO WS-77-COMMENTS-TEXT  
           PERFORM 8895-INSERT-WORK-QUEUE       THRU 8895-EXIT.         
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2160-WRITE-REPORT                                                       
      ******************************************************************        
        2160-WRITE-REPORT.                                              
                                                                        
           INITIALIZE REPORT-REC.                                       
                                                                        
HEX01      MOVE X'09' TO WS-FIL5  WS-FIL6  WS-FIL7 WS-FIL8.             
           MOVE E-FCA05-ACCOUNT-NO       TO WS-REP-ACCT-NO   .          
      *--- B-BILL ; L-LETTER                                                    
            IF E-FCA05-JOB-TYPE = 'P'                                   
               MOVE 'BILL STUB'             TO WS-JOB-TYPE-DESC         
            ELSE                                                        
               MOVE 'LTR STUB'              TO WS-JOB-TYPE-DESC         
            END-IF.                                                     
           MOVE WS-JOB-TYPE-DESC         TO WS-REP-STUB-TYPE .          
           MOVE E-FCA05-DATE-PROCESSED   TO WS-REP-DATE-PROCESS.        
           MOVE E-FCA05-AUTO-OPT-IN-FLAG TO WS-REP-OPT-SEL(1:1).        
           MOVE E-FCA05-SELECTION-CODE-1 TO WS-REP-OPT-SEL(2:1).        
           MOVE E-FCA05-SELECTION-CODE-2 TO WS-REP-OPT-SEL(3:1).        
           MOVE E-FCA05-SELECTION-CODE-3 TO WS-REP-OPT-SEL(4:1).        
           WRITE REPORT-REC FROM WS-REPORT-DET.                         
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2200-PROCESS-ACCOUNT.                                                    
      ******************************************************************        
      *                                                                         
       2200-PROCESS-ACCOUNT.                                            
      *                                                                         
             PERFORM 2300-CALL-SCSCA326      THRU 2300-EXIT.            
                                                                        
ACT013       IF RS-RETURN-CODE = 0                                      
                STRING WS-JOB-TYPE-DESC   DELIMITED BY SIZE             
                       WS-COMM-COMMENT-8  DELIMITED BY SIZE             
                  INTO WS-COMM-COMMENT                                  
                END-STRING                                              
                PERFORM 2110-CREATE-COMM-REC     THRU 2110-EXIT         
      **------  GET LATEST RTPKG DETAILS FOR MNT                                
                PERFORM 7560-SELECT-RATE-PKG-AGR THRU 7560-EXIT         
                PERFORM 2500-WRITE-TRANS-HIST    THRU 2500-EXIT         
             END-IF.                                                    
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-CALL-SCSCA326.                                            *        
      ******************************************************************        
      *                                                                         
       2300-CALL-SCSCA326.                                              
      *                                                                         
           IF FF-DURATION-REMAIN-NO = 0                                 
              MOVE WS-U                     TO WS-PROCESS-CD-O          
           ELSE                                                         
              MOVE WS-P                     TO WS-PROCESS-CD-O          
           END-IF.                                                      
           IF E-FCA05-AUTO-OPT-IN-FLAG = WS-Y                           
              MOVE WS-I                     TO WS-AUTO-REN-OPT-IN-FL-O  
           ELSE                                                         
              MOVE 5B-OPTION-CD             TO FI-OPTION-CD             
              PERFORM 7750-CHK-AUTO-REN-FLG THRU 7750-EXIT              
              IF FI-AUTO-RENEWAL-FL = WS-Y                              
************** ELIGIBLE BUT NOT OPTED IN                                        
                 MOVE WS-X                  TO WS-AUTO-REN-OPT-IN-FL-O  
              ELSE                                                      
                 MOVE WS-N                  TO WS-AUTO-REN-OPT-IN-FL-O  
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7000-GET-CURR-TIMESTAMP  THRU 7000-EXIT.             
           MOVE 5A-ACCOUNT-NO               TO WS-ACCOUNT-NO-O.         
           MOVE 5A-CODE-UTIL-TYPE           TO WS-CODE-UTIL-TYPE-O.     
           MOVE 5A-IC-NO                    TO WS-IC-NO-O.              
ACT018     MOVE 5B-OFFER-CD                 TO WS-OFFER-CD-O.           
           MOVE 5B-OPTION-CD                TO WS-OPTION-CD-O.          
           MOVE 5A-RT-PKG-OPT-SEQ-NO        TO WS-RT-PKG-OPT-SEQ-NO-O.  
           MOVE WS-JOB-TYPE                 TO WS-COMM-CHANNEL-O.       
           MOVE WS-SYSTEM                   TO WS-CREATED-USER-ID-O.    
           MOVE PROGRAM-NAME                TO WS-APPL-PGMID.           
           MOVE WS-CURRENT-TIMESTAMP(1:10)                              
                                            TO WS-OPT-AGRMT-EFF-DT-O.   
           MOVE WS-CURRENT-TIMESTAMP(12:8)                              
                                            TO WS-OPT-AGRMT-EFF-TM-O.   
           MOVE WS-N                        TO WS-EXIT-FEE-FLAG-O.      
           MOVE ZEROS                       TO WS-EXIT-FEE-AMT-O.       
           MOVE 5B-THERM-PRICE              TO WS-THERM-PRICE.          
           MOVE WS-THERM-PRICE-A            TO WS-CUST-AGRD-THERM-O.    
           MOVE SPACES                      TO WS-PROMO-CD-O.           
      *                                                                         
           CALL SCSCA326 USING  ABEND-FILE                              
                              , WS-WARNING-DATA-ELEMENTS                
                              , LS-MCSCB326-CALL-TYPE                   
                              , LS-MCSCB326-ONLINE-CALL                 
                              , LS-MCSCB326-RET-FIELDS                  
                                                                        
ACT013     MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE > 0             
              DISPLAY '********** PCSCA005 ERROR **************'        
              DISPLAY '*      2300-CALL-SCSCA326              *'        
              DISPLAY '* SUB-PROGRAM SCSCA326 FAILED WITH     *'        
              DISPLAY '* RETURN CODE       : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* ABEND PROGRAM     : ' ABEND-PROGRAM            
              DISPLAY '* ACTIVE PARAGRAPH  : ' ACTIVE-PARAGRAPH         
              DISPLAY '* ABEND-FUNCTION    : ' ABEND-FUNCTION           
              DISPLAY '* TABLE-1           : ' TABLE-1                  
              DISPLAY '* TABLE-ELEMENT-1   : ' TABLE-ELEMENT-1          
              DISPLAY '* TABLE-ELEMENT-2   : ' TABLE-ELEMENT-2          
              DISPLAY '* TABLE-ELEMENT-3   : ' TABLE-ELEMENT-3          
              DISPLAY '* TABLE-ELEMENT-4   : ' TABLE-ELEMENT-4          
              DISPLAY '* HOSTVAR-ELEMENT-1 : ' HOSTVAR-ELEMENT-1        
              DISPLAY '* HOSTVAR-ELEMENT-2 : ' HOSTVAR-ELEMENT-2        
              DISPLAY '* HOSTVAR-ELEMENT-3 : ' HOSTVAR-ELEMENT-3        
              DISPLAY '* HOSTVAR-ELEMENT-4 : ' HOSTVAR-ELEMENT-4        
              DISPLAY '* ACCOUNT NO        : ' WS-ACCOUNT-NO-O          
              DISPLAY '* CODE UTIL TYPE    : ' WS-CODE-UTIL-TYPE-O      
              DISPLAY '* IC NO             : ' WS-IC-NO-O               
              DISPLAY '* OPTION CODE       : ' WS-OPTION-CD-O           
              DISPLAY '* AGR EFF DATE      : ' WS-OPT-AGRMT-EFF-DT-O    
              DISPLAY '********** PCSCA005 END ERROR **********'        
                                                                        
ACT013***---  ROLL BACK CHANGES                                                 
ACT013        EXEC SQL                                                  
ACT013           ROLLBACK                                               
ACT013        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
ACT013***---  WRITE WQ                                                          
              MOVE WS-WQ-COMMENT-SCSCA326   TO WS-WORKQ-COMMENT         
              PERFORM 2150-CREATE-WQ      THRU 2150-EXIT                
                                                                        
ACT013        PERFORM 9000-TERMINATE      THRU 9000-EXIT                
ACT013        MOVE    12                    TO RETURN-CODE              
ACT013        STOP RUN                                                  
                                                                        
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  2500-WRITE-TRANS-HIST.                                      *          
      ****************************************************************          
                                                                        
       2500-WRITE-TRANS-HIST.                                           
           MOVE SPACES                       TO MH-TRAN-COMMENT-TEXT.   
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           STRING  'RECVD FIXED RATE RENEWAL CARD; PROCESSED RENEWAL            
      -    'CARD SUCCESSFULLY'  DELIMITED BY SIZE                               
             INTO MH-TRAN-COMMENT-TEXT                                  
           END-STRING                                                   
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                             TO MH-TRAN-COMMENT-LEN.    
           MOVE 1                            TO WS-TRAN-APPL-NO.        
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           MOVE DF-OFFER-CD                  TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN 
           MOVE 'OFFER_CD'                   TO MI-COLUMN-DESC.         
           MOVE 'FG'                         TO MI-TABLE-ID.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD  1                            TO WS-TRAN-APPL-NO.        
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           MOVE DF-OPTION-CD                 TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN 
           MOVE 'OPTION_CD'                  TO MI-COLUMN-DESC.         
           MOVE 'FI'                         TO MI-TABLE-ID.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD  1                            TO WS-TRAN-APPL-NO.        
                                                                        
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           MOVE DF-AUTO-REN-OPT-IN-FL        TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN 
           MOVE 'AUTO_REN_OPT_IN'            TO MI-COLUMN-DESC.         
           MOVE 'DF'                         TO MI-TABLE-ID.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD  1                            TO WS-TRAN-APPL-NO.        
      *                                                                         
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           MOVE DF-STATUS-CD                 TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN 
           MOVE 'STATUS_CD'                  TO MI-COLUMN-DESC.         
           MOVE 'DF'                         TO MI-TABLE-ID.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD  1                            TO WS-TRAN-APPL-NO.        
      *                                                                         
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                             TO MI-PRV-COLUMN-VALUE-LEN 
           MOVE DF-RT-PKG-OPT-SEQ-NO         TO MI-CHG-COLUMN-VALUE-TEXT
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                             TO MI-CHG-COLUMN-VALUE-LEN 
           MOVE 'RT_PKG_OPT_SEQ#'            TO MI-COLUMN-DESC.         
           MOVE 'SPACES'                     TO MI-TABLE-ID.            
           PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
           ADD  1                            TO WS-TRAN-APPL-NO.        
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 2800-PRE-COMMIT.                                               *        
      ******************************************************************        
      *                                                                         
       2800-PRE-COMMIT.                                                 
      *                                                                         
           MOVE 1                           TO WS-RESTART-PROCESS-TYPE. 
           MOVE WS-C                        TO WS-RESTART-JOB-STATUS.   
           MOVE WS-INPUT-DATE               TO WS-RESTART-COMMON-DATE.  
           ADD  1                           TO WS-CHKP-SEQ-NO.          
           MOVE WS-CHKP-SEQ-NO              TO WS-RESTART-CHKP-SEQ-NO.  
           MOVE AT-ACCOUNT-NO               TO WS-RESTART-ACCOUNT-NO.   
           MOVE WS-FIOCA05-REC-CNTR         TO                          
                                          WS-RESTART-FIOCA05-REC-CNTR.  
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 6510-MOVE-TRANS-HDR-DETAILS.                                  *         
      *****************************************************************         
       6510-MOVE-TRANS-HDR-DETAILS.                                     
                                                                        
           PERFORM 7400-SELECT-MH-DATE-TIME   THRU 7400-EXIT.           
           MOVE MH-TRANS-HIST-SEQ-NO          TO MI-TRANS-HIST-SEQ-NO.  
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
           MOVE '003'                         TO MH-RESP-AREA-ID.       
           MOVE ZEROS                         TO MH-CUSTOMER-NO         
                                                 MH-PREMISE-NO.         
           MOVE WS-SYSTEM                     TO MH-USER-ID             
           MOVE WS-PGRMNAME                   TO MH-APPL-PROGRAM-ID.    
           MOVE DF-ACCOUNT-NO                 TO MH-ACCOUNT-NO.         
                                                                        
       6510-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 6530-LOAD-MNT-TRANS-HIST.                                     *         
      *****************************************************************         
       6530-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           IF MI-TRAN-APPL-NO EQUAL 1                                   
              PERFORM 6510-MOVE-TRANS-HDR-DETAILS THRU 6510-EXIT        
              PERFORM 8600-INSERT-MNT-TRANS-HIST THRU 8600-EXIT         
              PERFORM 8610-INSERT-MT-TRN-HST-DET THRU 8610-EXIT         
           ELSE                                                         
              PERFORM 8610-INSERT-MT-TRN-HST-DET THRU 8610-EXIT         
           END-IF.                                                      
                                                                        
       6530-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7000-GET-CURR-TIMESTAMP.                                      *         
      *****************************************************************         
       7000-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTAMP =   CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '********** PCSCA005 ABORT **************'        
              DISPLAY '*      7000-GET-CURR-TIMESTAMP         *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA005 ABORT **************'        
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7050-READ-FIOCA05                                              *        
      ******************************************************************        
      *                                                                         
       7050-READ-FIOCA05.                                               
      *                                                                         
           READ FCSCA05-FILE                                            
               AT END                                                   
                   MOVE WS-Y                TO WS-END-OF-FILE           
                   GO TO 7050-EXIT                                      
           END-READ.                                                    
      *                                                                         
           IF  FCA05-SUCCESSFUL                                         
               ADD 1 TO WS-FIOCA05-REC-CNTR                             
                        WS-COMMIT-COUNTER                               
           ELSE                                                         
               DISPLAY '7050-ERROR ON FIOCA05 READ.  STATUS IS '        
                        WS-FCA05-STATUS                                 
               DISPLAY 'ERROR IN ACCOUNT NO' E-FCA05-ACCOUNT-NO         
               PERFORM 9900-ABEND           THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 28540000
      ****************************************************************          
      * 7160-SELECT-RESTART                                          *          
      ****************************************************************          
      *                                                                         
       7160-SELECT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT RF.RESTART_DATA                                    
                INTO :RF-RESTART-DATA                                   
                FROM CSS_RESTART RF WITH(READUNCOMMITTED)                       
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RF.RESTART_DATA                                            
MFA-TR*         INTO :RF-RESTART-DATA                                           
MFA-TR*         FROM CSS_RESTART RF                                             
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7160                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA005 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7160-SELECT-RESTART        **'     
              DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
              DISPLAY '**   SQLCODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-SELECT-ACCT-STATUS.                                      *         
      *****************************************************************         
       7200-SELECT-ACCT-STATUS.                                         
                                                                        
           EXEC SQL                                                     
               SELECT AT.CODE_ACCT_STAT                                 
                     ,AT.REV_MTH_LST_NRML                               
                     ,AT.BILL_CYCLE                                     
                     ,AT.CODE_ACCT_BILLED                               
                     ,AT.CUSTOMER_NO                                    
                     ,AT.LOCAL_OFFICE                                   
                     ,AT.PREMISE_NO                                     
                     ,AT.COMPANY_NO                                     
                 INTO :AT-CODE-ACCT-STAT                                
                     ,:AT-REV-MTH-LST-NRML                              
                     ,:AT-BILL-CYCLE                                    
                     ,:AT-CODE-ACCT-BILLED                              
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-LOCAL-OFFICE                                  
                     ,:AT-PREMISE-NO                                    
                     ,:AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.CODE_ACCT_STAT                                         
MFA-TR*              ,AT.REV_MTH_LST_NRML                                       
MFA-TR*              ,AT.BILL_CYCLE                                             
MFA-TR*              ,AT.CODE_ACCT_BILLED                                       
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*          INTO :AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:AT-REV-MTH-LST-NRML                                      
MFA-TR*              ,:AT-BILL-CYCLE                                            
MFA-TR*              ,:AT-CODE-ACCT-BILLED                                      
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA005 ABORT **************'        
              DISPLAY '*     7200-SELECT-ACCT-STATUS          *'        
              DISPLAY '* ACCOUNT NO     : ' AT-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA005 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
        7200-EXIT.                                                      
             EXIT.                                                      
      *****************************************************************         
      * 7300-SELECT-DNPFB.                                            *         
      *****************************************************************         
       7300-SELECT-DNPFB.                                               
                                                                        
           EXEC SQL                                                     
               SELECT VO.ORDER_TYPE_CD                                  
                 INTO :VO-ORDER-TYPE-CD                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE VO.ACCOUNT_NO          = :VO-ACCOUNT-NO           
                  AND VO.ORDER_TYPE_CD      IN ('DNPFB', 'OFF01')       
                  AND VO.ORDER_STATE_CD NOT IN ('C','Z')                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VO.ORDER_TYPE_CD                                          
MFA-TR*          INTO :VO-ORDER-TYPE-CD                                         
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE VO.ACCOUNT_NO          = :VO-ACCOUNT-NO                   
MFA-TR*           AND VO.ORDER_TYPE_CD      IN ('DNPFB', 'OFF01')               
MFA-TR*           AND VO.ORDER_STATE_CD NOT IN ('C','Z')                        
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA005 ABORT **************'        
              DISPLAY '*     7300-SELECT-DNPFB                *'        
              DISPLAY '* ACCOUNT NO     : ' VO-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA005 ABORT **************'        
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
        7300-EXIT.                                                      
             EXIT.                                                      
      *****************************************************************         
      * 7400-SELECT-MH-DATE-TIME.                                     *         
      *****************************************************************         
       7400-SELECT-MH-DATE-TIME.                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*          ,:MH-DATE-TRANS        = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               DISPLAY '*****************PCSCA005******************'    
               DISPLAY '* PARA : 7400-SELECT-MH-DATE-TIME         *'    
               DISPLAY '* SQLERROR: ' WS-ACTIVE-RETURN-CODE             
               DISPLAY '* PROGRAM ABENDING...                     *'    
               DISPLAY '*****************PCSCA005******************'    
               PERFORM 9900-ABEND              THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7500-SELECT-ACT-RT-REN.                                        *        
      ******************************************************************        
      *                                                                         
       7500-SELECT-ACT-RT-REN.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) [5A].CODE_UTIL_TYPE,
              [5A].IC_NO,
              [5A].SEQ_NO,
              [5A].RT_PKG_OPT_SEQ_NO,
              [5A].OFFERED_DT                                      
                INTO :5A-CODE-UTIL-TYPE                                 
                    ,:5A-IC-NO                                          
                    ,:5A-SEQ-NO                                         
                    ,:5A-RT-PKG-OPT-SEQ-NO                              
                    ,:5A-OFFERED-DT                                     
                FROM CSS_ACT_RT_RENEWAL [5A] WITH(READUNCOMMITTED)              
               WHERE [5A].ACCOUNT_NO  = :5A-ACCOUNT-NO                    
               ORDER BY [5A].OFFERED_DT DESC                              
                       ,[5A].SEQ_NO     DESC                              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 5A.CODE_UTIL_TYPE                                          
MFA-TR*             ,5A.IC_NO                                                   
MFA-TR*             ,5A.SEQ_NO                                                  
MFA-TR*             ,5A.RT_PKG_OPT_SEQ_NO                                       
MFA-TR*             ,5A.OFFERED_DT                                              
MFA-TR*         INTO :5A-CODE-UTIL-TYPE                                         
MFA-TR*             ,:5A-IC-NO                                                  
MFA-TR*             ,:5A-SEQ-NO                                                 
MFA-TR*             ,:5A-RT-PKG-OPT-SEQ-NO                                      
MFA-TR*             ,:5A-OFFERED-DT                                             
MFA-TR*         FROM CSS_ACT_RT_RENEWAL 5A                                      
MFA-TR*        WHERE 5A.ACCOUNT_NO  = :5A-ACCOUNT-NO                            
MFA-TR*        ORDER BY 5A.OFFERED_DT DESC                                      
MFA-TR*                ,5A.SEQ_NO     DESC                                      
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA005 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7500-SELECT-ACT-RT-REN     **'     
              DISPLAY '**   ACCOUNT NO   = ' 5A-ACCOUNT-NO              
              DISPLAY '**   SQLCODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-SEL-ACT-RT-REN-DET.                                       *        
      ******************************************************************        
       7550-SEL-ACT-RT-REN-DET.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT [5B].OPTION_CD                                       
                    ,[5B].THERM_PRICE                                     
                    ,[5B].SELECTION_CD                                    
ACT018              ,[5B].OFFER_CD                                        
                INTO :5B-OPTION-CD                                      
                    ,:5B-THERM-PRICE                                    
                    ,:5B-SELECTION-CD                                   
ACT018              ,:5B-OFFER-CD                                       
                FROM CSS_ACT_RT_REN_DET [5B] WITH(READUNCOMMITTED)              
               WHERE [5B].ACCOUNT_NO     = :5B-ACCOUNT-NO                 
                 AND [5B].CODE_UTIL_TYPE = :5B-CODE-UTIL-TYPE             
                 AND [5B].IC_NO          = :5B-IC-NO                      
                 AND [5B].SEQ_NO         = :5B-SEQ-NO                     
                 AND [5B].OPTION_SORT_NO = :5B-OPTION-SORT-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 5B.OPTION_CD                                               
MFA-TR*             ,5B.THERM_PRICE                                             
MFA-TR*             ,5B.SELECTION_CD                                            
MFA-TR*             ,5B.OFFER_CD                                                
MFA-TR*         INTO :5B-OPTION-CD                                              
MFA-TR*             ,:5B-THERM-PRICE                                            
MFA-TR*             ,:5B-SELECTION-CD                                           
MFA-TR*             ,:5B-OFFER-CD                                               
MFA-TR*         FROM CSS_ACT_RT_REN_DET 5B                                      
MFA-TR*        WHERE 5B.ACCOUNT_NO     = :5B-ACCOUNT-NO                         
MFA-TR*          AND 5B.CODE_UTIL_TYPE = :5B-CODE-UTIL-TYPE                     
MFA-TR*          AND 5B.IC_NO          = :5B-IC-NO                              
MFA-TR*          AND 5B.SEQ_NO         = :5B-SEQ-NO                             
MFA-TR*          AND 5B.OPTION_SORT_NO = :5B-OPTION-SORT-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA005 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7550-SEL-ACT-RT-REN-DET    **'     
              DISPLAY '**   ACCOUNT NO     = ' 5B-ACCOUNT-NO            
              DISPLAY '**   CODE UTIL TYPE = ' 5B-CODE-UTIL-TYPE        
              DISPLAY '**   IC NO          = ' 5B-IC-NO                 
              DISPLAY '**   SEQ NO           ' 5B-SEQ-NO                
              DISPLAY '**   OPTION SORT NO = ' 5B-OPTION-SORT-NO        
              DISPLAY '**   SQLCODE        = ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 7560-SELECT-RATE-PKG-AGR.                                     *         
      *****************************************************************         
       7560-SELECT-RATE-PKG-AGR.                                        
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) DF.ACCOUNT_NO,
              DF.CODE_UTIL_TYPE,
              DF.IC_NO,
              DF.RT_PKG_OPT_SEQ_NO,
              DF.TRANS_SEQ_ID,
              DF.OFFER_CD,
              DF.OPTION_CD,
              DF.PROMO_CD,
              DF.STATUS_CD,
              DF.COMM_CHANNEL,
              DF.CREATED_USERID,
              DF.LAST_UPDATE_USERID,
              DF.OPT_AGRMT_EFF_DT,
              REPLACE(CONVERT(CHAR(8), DF.OPT_AGRMT_EFF_TM, 108), ':', 
           '.') OPT_AGRMT_EFF_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), DF.CREATED_TS, 121), 
           ' ', '-'), ':', '.') CREATED_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), DF.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              DF.COMPANY_NO,
              DF.STATUS_EFF_REV_MTH,
              DF.AGREEMNT_SOURCE_CD,
              DF.ADJ_TIER_SEQ_NO,
              DF.OFF_OPT_VRSN_NO,
              DF.AUTO_REN_OPT_IN_FL                            
                  INTO :DF-ACCOUNT-NO                                   
                      ,:DF-CODE-UTIL-TYPE                               
                      ,:DF-IC-NO                                        
                      ,:DF-RT-PKG-OPT-SEQ-NO                            
                      ,:DF-TRANS-SEQ-ID                                 
                      ,:DF-OFFER-CD                                     
                      ,:DF-OPTION-CD                                    
                      ,:DF-PROMO-CD                                     
                      ,:DF-STATUS-CD                                    
                      ,:DF-COMM-CHANNEL                                 
                      ,:DF-CREATED-USERID                               
                      ,:DF-LAST-UPDATE-USERID                           
                      ,:DF-OPT-AGRMT-EFF-DT                             
                      ,:DF-OPT-AGRMT-EFF-TM                             
                      ,:DF-CREATED-TS                                   
                      ,:DF-LAST-UPDATE-TS                               
                      ,:DF-COMPANY-NO                                   
                      ,:DF-STATUS-EFF-REV-MTH                           
                      ,:DF-AGREEMNT-SOURCE-CD                           
                      ,:DF-ADJ-TIER-SEQ-NO                              
                      ,:DF-OFF-OPT-VRSN-NO                              
                      ,:DF-AUTO-REN-OPT-IN-FL                           
                  FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)               
                 WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO            
              ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                        
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DF.ACCOUNT_NO                                            
MFA-TR*               ,DF.CODE_UTIL_TYPE                                        
MFA-TR*               ,DF.IC_NO                                                 
MFA-TR*               ,DF.RT_PKG_OPT_SEQ_NO                                     
MFA-TR*               ,DF.TRANS_SEQ_ID                                          
MFA-TR*               ,DF.OFFER_CD                                              
MFA-TR*               ,DF.OPTION_CD                                             
MFA-TR*               ,DF.PROMO_CD                                              
MFA-TR*               ,DF.STATUS_CD                                             
MFA-TR*               ,DF.COMM_CHANNEL                                          
MFA-TR*               ,DF.CREATED_USERID                                        
MFA-TR*               ,DF.LAST_UPDATE_USERID                                    
MFA-TR*               ,DF.OPT_AGRMT_EFF_DT                                      
MFA-TR*               ,DF.OPT_AGRMT_EFF_TM                                      
MFA-TR*               ,DF.CREATED_TS                                            
MFA-TR*               ,DF.LAST_UPDATE_TS                                        
MFA-TR*               ,DF.COMPANY_NO                                            
MFA-TR*               ,DF.STATUS_EFF_REV_MTH                                    
MFA-TR*               ,DF.AGREEMNT_SOURCE_CD                                    
MFA-TR*               ,DF.ADJ_TIER_SEQ_NO                                       
MFA-TR*               ,DF.OFF_OPT_VRSN_NO                                       
MFA-TR*               ,DF.AUTO_REN_OPT_IN_FL                                    
MFA-TR*           INTO :DF-ACCOUNT-NO                                           
MFA-TR*               ,:DF-CODE-UTIL-TYPE                                       
MFA-TR*               ,:DF-IC-NO                                                
MFA-TR*               ,:DF-RT-PKG-OPT-SEQ-NO                                    
MFA-TR*               ,:DF-TRANS-SEQ-ID                                         
MFA-TR*               ,:DF-OFFER-CD                                             
MFA-TR*               ,:DF-OPTION-CD                                            
MFA-TR*               ,:DF-PROMO-CD                                             
MFA-TR*               ,:DF-STATUS-CD                                            
MFA-TR*               ,:DF-COMM-CHANNEL                                         
MFA-TR*               ,:DF-CREATED-USERID                                       
MFA-TR*               ,:DF-LAST-UPDATE-USERID                                   
MFA-TR*               ,:DF-OPT-AGRMT-EFF-DT                                     
MFA-TR*               ,:DF-OPT-AGRMT-EFF-TM                                     
MFA-TR*               ,:DF-CREATED-TS                                           
MFA-TR*               ,:DF-LAST-UPDATE-TS                                       
MFA-TR*               ,:DF-COMPANY-NO                                           
MFA-TR*               ,:DF-STATUS-EFF-REV-MTH                                   
MFA-TR*               ,:DF-AGREEMNT-SOURCE-CD                                   
MFA-TR*               ,:DF-ADJ-TIER-SEQ-NO                                      
MFA-TR*               ,:DF-OFF-OPT-VRSN-NO                                      
MFA-TR*               ,:DF-AUTO-REN-OPT-IN-FL                                   
MFA-TR*           FROM CSS_ACCT_RTPK_AGR DF                                     
MFA-TR*          WHERE DF.ACCOUNT_NO        = :DF-ACCOUNT-NO                    
MFA-TR*       ORDER BY DF.RT_PKG_OPT_SEQ_NO DESC                                
MFA-TR*          FETCH FIRST ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7560                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA005 ABORT **************'        
              DISPLAY '*     7560-SELECT-RATE-PKG-AGR         *'        
              DISPLAY '* ACCOUNT NO     : ' DF-ACCOUNT-NO               
              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA005 ABORT **************'        
              PERFORM 9900-ABEND        THRU 9900-EXIT                  
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
ACT008*****************************************************************         
ACT008*                                                               *         
ACT008* 7570-GET-CODE-VALUE                                           *         
ACT008*****************************************************************         
ACT008                                                                  
ACT008 7570-GET-CODE-VALUE.                                             
ACT008                                                                  
ACT008     EXEC SQL                                                     
ACT008        SELECT UV.CODE_LONG_DESC                                  
ACT008        INTO  :UV-CODE-LONG-DESC                                  
ACT008        FROM  CSS_CODE_VALUE    UV WITH(READUNCOMMITTED)                  
ACT008        WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                     
ACT008        AND   UV.COLUMN_NA   = :UV-COLUMN-NA                      
ACT008        AND   UV.TABLE_NA    = :UV-TABLE-NA                       
ACT008        AND   UV.PROGRAM_ID  = :UV-PROGRAM-ID                     
ACT008                                                           
ACT008                                                      
ACT008     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UV.CODE_LONG_DESC                                          
MFA-TR*       INTO  :UV-CODE-LONG-DESC                                          
MFA-TR*       FROM  CSS_CODE_VALUE    UV                                        
MFA-TR*       WHERE UV.CODE_VALUE  = :UV-CODE-VALUE                             
MFA-TR*       AND   UV.COLUMN_NA   = :UV-COLUMN-NA                              
MFA-TR*       AND   UV.TABLE_NA    = :UV-TABLE-NA                               
MFA-TR*       AND   UV.PROGRAM_ID  = :UV-PROGRAM-ID                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7570                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT008                                                                  
ACT008     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
ACT008                                                                  
ACT008     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT008         WHEN SUCCESSFUL-CALL                                     
ACT008         WHEN NOT-FOUND                                           
ACT008              CONTINUE                                            
ACT008         WHEN OTHER                                               
ACT008              DISPLAY '********** PCSCA005 ABORT **************'  
ACT008              DISPLAY '*     7570-GET-CODE-VALUE              *'  
ACT008              DISPLAY '* CODE_VALUE     : ' UV-CODE-VALUE         
ACT008              DISPLAY '* COLUMN_NA      : ' UV-COLUMN-NA          
ACT008              DISPLAY '* TABLE_NA       : ' UV-TABLE-NA           
ACT008              DISPLAY '* PROGRAM_ID     : ' UV-PROGRAM-ID         
ACT008              DISPLAY '* SQLCODE        : ' WS-ACTIVE-RETURN-CODE 
ACT008              DISPLAY '*     PROCESSING TERMINATED            *'  
ACT008              DISPLAY '********** PCSCA005 ABORT **************'  
ACT008     END-EVALUATE.                                                
ACT008*                                                                         
ACT008 7570-EXIT.                                                       
ACT008     EXIT.                                                        
                                                                        
      *****************************************************************         
      * ON CURRENT OPTION ON ACCOUNT                                  *         
      * 7700-FIND-DURATION-REM.                                       *         
      *****************************************************************         
       7700-FIND-DURATION-REM.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FF.DURATION_REMAIN_NO,
              FF.FACTOR,
              HQ.DURATION_NO                                    
                 INTO :FF-DURATION-REMAIN-NO :WS-NULL-IND                
                     ,:FF-FACTOR                                        
                     ,:HQ-DURATION-NO                                   
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                     ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
                WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            
                  AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE        
                  AND FF.IC_NO              = :FF-IC-NO                 
                  AND HQ.OPTION_CD          = :HQ-OPTION-CD             
                  AND HQ.COMPANY_NO         = :HQ-COMPANY-NO            
                  AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                       
                  AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()        
                  AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()        
                  AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )     
                  AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                   :DF-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :DF-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:DF-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:DF-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :DF-OPT-AGRMT-EFF-DT) )     
                  AND HQ.PROC_STATUS_CD      = 'AC'                     
                  AND FF.FACTOR_ID           = HQ.FACTOR_ID             
                  AND FF.RT_PKG_OPT_SEQ_NO   = :FF-RT-PKG-OPT-SEQ-NO    
                ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                     
                        ,FF.EFF_DATE_FROM DESC                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FF.DURATION_REMAIN_NO                                     
MFA-TR*              ,FF.FACTOR                                                 
MFA-TR*              ,HQ.DURATION_NO                                            
MFA-TR*          INTO :FF-DURATION-REMAIN-NO:WS-NULL-IND                        
MFA-TR*              ,:FF-FACTOR                                                
MFA-TR*              ,:HQ-DURATION-NO                                           
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*              ,CSS_FIXED_FCTR FF                                         
MFA-TR*         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                    
MFA-TR*           AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                
MFA-TR*           AND FF.IC_NO              = :FF-IC-NO                         
MFA-TR*           AND HQ.OPTION_CD          = :HQ-OPTION-CD                     
MFA-TR*           AND HQ.COMPANY_NO         = :HQ-COMPANY-NO                    
MFA-TR*           AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                               
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                
MFA-TR*           AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT <= :DF-OPT-AGRMT-EFF-DT             
MFA-TR*           AND HQ.ATTR_INCTV_END_DT  >= :DF-OPT-AGRMT-EFF-DT             
MFA-TR*           AND HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*           AND FF.FACTOR_ID           = HQ.FACTOR_ID                     
MFA-TR*           AND FF.RT_PKG_OPT_SEQ_NO   = :FF-RT-PKG-OPT-SEQ-NO            
MFA-TR*         ORDER BY HQ.OPT_ATTR_VSTART_TS DESC                             
MFA-TR*                 ,FF.EFF_DATE_FROM DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 IF WS-NULL-IND = -1                                    
                    MOVE -1               TO FF-DURATION-REMAIN-NO      
                 END-IF                                                 
              ELSE                                                      
                 MOVE -1                  TO FF-DURATION-REMAIN-NO      
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA005 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7700-FIND-DURATION-REM     **'     
              DISPLAY '**   ACCOUNT NO      = ' FF-ACCOUNT-NO           
              DISPLAY '**   CODE UTIL TYPE  = ' FF-CODE-UTIL-TYPE       
              DISPLAY '**   IC NO           = ' FF-IC-NO                
              DISPLAY '**   SQLCODE         = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * ON SELECTED OPTION                                                      
      * 7710-FIND-DURATION-NO .                                       *         
      *****************************************************************         
       7710-FIND-DURATION-NO.                                           
                                                                        
            EXEC SQL                                                    
              SELECT TOP(1) HQ.DURATION_NO                                     
                INTO :WS-SEL-OPTION-DUR-NO                              
                FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
               WHERE HQ.OPTION_CD          = :HQ-OPTION-CD              
                 AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                        
                 AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'              
                 AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
                 AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
                 AND HQ.PROC_STATUS_CD      = 'AC'                      
               ORDER BY HQ.ATTR_INCTV_STRT_DT                           
                                                    
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT HQ.DURATION_NO                                             
MFA-TR*         INTO :WS-SEL-OPTION-DUR-NO                                      
MFA-TR*         FROM CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE HQ.OPTION_CD          = :HQ-OPTION-CD                      
MFA-TR*          AND HQ.PRIMRY_OPT_ATTR_FL = 'Y'                                
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                      
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*        ORDER BY HQ.ATTR_INCTV_STRT_DT                                   
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        QUERYNO 7710                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE ZEROS               TO WS-SEL-OPTION-DUR-NO       
              END-IF                                                    
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA005 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 7710-FIND-DURATION-NO      **'     
              DISPLAY '**   OPTION_CD       = ' HQ-OPTION-CD            
              DISPLAY '**   SQLCODE         = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * OPTION DETAILS                                                *         
      * 7750-CHK-AUTO-REN-FLG.                                        *         
      *****************************************************************         
       7750-CHK-AUTO-REN-FLG.                                           
      *                                                                 52132201
            EXEC SQL                                                    
              SELECT TOP(1) FI.AUTO_RENEWAL_FL                                 
                INTO :FI-AUTO-RENEWAL-FL                                
                FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE FI.OPTION_CD         = :FI-OPTION-CD               
ACT191           AND FI.OPTION_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                         :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) )           
ACT191           AND FI.OPTION_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                         :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) )           
                 AND CAST(FI.OPT_VSTART_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) )           
                 AND CAST(FI.OPT_VEND_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) )           
                 AND FI.PROC_STATUS_CD    = 'AC'                        
ACT191         ORDER BY FI.OPT_VRSN_NO DESC                             
ACT191                                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT FI.AUTO_RENEWAL_FL                                         
MFA-TR*         INTO :FI-AUTO-RENEWAL-FL                                        
MFA-TR*         FROM CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE FI.OPTION_CD         = :FI-OPTION-CD                       
MFA-TR*          AND FI.OPTION_START_DT     <= :5A-OFFERED-DT                   
MFA-TR*          AND FI.OPTION_END_DT       >= :5A-OFFERED-DT                   
MFA-TR*          AND DATE(FI.OPT_VSTART_TS) <= :5A-OFFERED-DT                   
MFA-TR*          AND DATE(FI.OPT_VEND_TS)   >= :5A-OFFERED-DT                   
MFA-TR*          AND FI.PROC_STATUS_CD    = 'AC'                                
MFA-TR*        ORDER BY FI.OPT_VRSN_NO DESC                                     
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7750                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA005 ABORT **************'        
ACT191        DISPLAY '*      7750-CHK-AUTO-REN-FLG           *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* OPTION CODE       : ' FI-OPTION-CD             
ACT208        DISPLAY '* OFFERED DATE      : ' 5A-OFFERED-DT            
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA005 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 1760-GET-OPTION-DETAILS.                                      *         
      *****************************************************************         
       7760-GET-OPTION-DETAILS.                                         
      *                                                                 52132201
            EXEC SQL                                                    
              SELECT TOP(1) FI.OPT_DESC_INT                                    
                INTO :FI-OPT-DESC-INT                                   
                FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                 
               WHERE FI.OPTION_CD            = :FI-OPTION-CD            
                 AND FI.COMPANY_NO           = :FI-COMPANY-NO           
ACT208           AND FI.OPTION_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                         :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) )           
ACT208           AND FI.OPTION_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                         :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) )           
                 AND CAST(FI.OPT_VSTART_TS AS DATE) <= 
              IIF(TRY_CONVERT(DATE, :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) )           
                 AND CAST(FI.OPT_VEND_TS AS DATE)   >= 
              IIF(TRY_CONVERT(DATE, :5A-OFFERED-DT
              ) IS NULL OR (PATINDEX('%.%', :5A-OFFERED-DT
              ) <> 0) OR (LEN(:5A-OFFERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :5A-OFFERED-DT
              ), CONVERT(DATE, :5A-OFFERED-DT) )           
                 AND FI.PROC_STATUS_CD       = 'AC'                     
ACT208          ORDER BY FI.OPT_VRSN_NO DESC                            
ACT208                                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SELECT FI.OPT_DESC_INT                                            
MFA-TR*         INTO :FI-OPT-DESC-INT                                           
MFA-TR*         FROM CRM_RT_PKG_OPTION FI                                       
MFA-TR*        WHERE FI.OPTION_CD            = :FI-OPTION-CD                    
MFA-TR*          AND FI.COMPANY_NO           = :FI-COMPANY-NO                   
MFA-TR*          AND FI.OPTION_START_DT     <= :5A-OFFERED-DT                   
MFA-TR*          AND FI.OPTION_END_DT       >= :5A-OFFERED-DT                   
MFA-TR*          AND DATE(FI.OPT_VSTART_TS) <= :5A-OFFERED-DT                   
MFA-TR*          AND DATE(FI.OPT_VEND_TS)   >= :5A-OFFERED-DT                   
MFA-TR*          AND FI.PROC_STATUS_CD       = 'AC'                             
MFA-TR*         ORDER BY FI.OPT_VRSN_NO DESC                                    
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7760                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '********** PCSCA005 ABORT **************'        
              DISPLAY '*      7760-GET-OPTION-DETAILS         *'        
              DISPLAY '* SQLCODE           : ' WS-ACTIVE-RETURN-CODE    
              DISPLAY '* OPTION CODE       : ' FI-OPTION-CD             
              DISPLAY '* COMPANY NO        : ' FI-COMPANY-NO            
ACT208        DISPLAY '* OFFERED DATE      : ' 5A-OFFERED-DT            
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSCA005 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ***************************************************************** 42130000
      * 8000-UPDT-ACCT-REN-DET.                                       * 42140000
      ***************************************************************** 42170000
      *                                                                 42200000
       8000-UPDT-ACCT-REN-DET.                                          
      *                                                                 42200000
           EXEC SQL                                                     
              UPDATE [5B]                               
                 SET [5B].SELECTION_CD       = :5B-SELECTION-CD           
                    ,[5B].AUTO_REN_OPT_IN_FL = :5B-AUTO-REN-OPT-IN-FL     
              FROM CSS_ACT_RT_REN_DET [5B]
               WHERE [5B].ACCOUNT_NO         = :5B-ACCOUNT-NO             
                 AND [5B].CODE_UTIL_TYPE     = :5B-CODE-UTIL-TYPE         
                 AND [5B].IC_NO              = :5B-IC-NO                  
                 AND [5B].SEQ_NO             = :5B-SEQ-NO                 
                 AND [5B].OPTION_SORT_NO     = :5B-OPTION-SORT-NO         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                     42210000
MFA-TR*       UPDATE CSS_ACT_RT_REN_DET 5B                              42220000
MFA-TR*          SET 5B.SELECTION_CD       = :5B-SELECTION-CD           42220000
MFA-TR*             ,5B.AUTO_REN_OPT_IN_FL = :5B-AUTO-REN-OPT-IN-FL             
MFA-TR*        WHERE 5B.ACCOUNT_NO         = :5B-ACCOUNT-NO             42260000
MFA-TR*          AND 5B.CODE_UTIL_TYPE     = :5B-CODE-UTIL-TYPE         42260000
MFA-TR*          AND 5B.IC_NO              = :5B-IC-NO                          
MFA-TR*          AND 5B.SEQ_NO             = :5B-SEQ-NO                         
MFA-TR*          AND 5B.OPTION_SORT_NO     = :5B-OPTION-SORT-NO                 
MFA-TR*    END-EXEC.                                                    42270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 42280000
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
      *                                                                 42300000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '**   PCSCA005 PROCESSING ERROR           **'     
              DISPLAY '**   ERROR ON 8000-UPDT-ACCT-REN-DET     **'     
              DISPLAY '**   ACCOUNT NO      = ' 5B-ACCOUNT-NO           
              DISPLAY '**   CODE UTIL TYPE  = ' 5B-CODE-UTIL-TYPE       
              DISPLAY '**   IC NO           = ' 5B-IC-NO                
              DISPLAY '**   SEQ NO          = ' 5B-SEQ-NO               
              DISPLAY '**   OPTION SORT NO  = ' 5B-OPTION-SORT-NO       
              DISPLAY '**   SQLCODE         = ' WS-ACTIVE-RETURN-CODE   
              DISPLAY '**       PROCESSING TERMINATED           **'     
              DISPLAY '*******************************************'     
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                 42430000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 8100-INSERT-COMM-DATA                                       *           
      ***************************************************************           
                                                                        
       8100-INSERT-COMM-DATA.                                           
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '*    PCSCA005 PROCESSING ERROR       '          
               DISPLAY '* 8100-INSERT-COMM-DATA'                        
               DISPLAY '* CUSTOMER_NO = ' KO-CUSTOMER-NO                
               DISPLAY '* ACCOUNT_NO  = ' KO-ACCOUNT-NO                 
               DISPLAY '* SQL RETURN CODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND                THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8810-WRITE-RESTART                                             *        
      ******************************************************************        
      *                                                                         
       8810-WRITE-RESTART.                                              
      *                                                                         
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
           MOVE WS-RESTART-DATA             TO RF-RESTART-DATA-TEXT.    
           MOVE WS-RESTART-DATA-LENGTH      TO RF-RESTART-DATA-LEN.     
                                                                        
           PERFORM 8820-UPDATE-RESTART      THRU 8820-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8830-INSERT-RESTART       THRU 8830-EXIT          
           END-IF.                                                      
      *                                                                         
       8810-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8820-UPDATE-RESTART                                            *        
      ******************************************************************        
      *                                                                         
       8820-UPDATE-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE RF                                     
                  SET RF.RESTART_DATA = :RF-RESTART-DATA                
               FROM CSS_RESTART RF
                WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                
                  AND RF.PARTITION_NO = :RF-PARTITION-NO                
                  AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_RESTART RF                                            
MFA-TR*           SET RF.RESTART_DATA = :RF-RESTART-DATA                        
MFA-TR*         WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                        
MFA-TR*           AND RF.PARTITION_NO = :RF-PARTITION-NO                        
MFA-TR*           AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                        
MFA-TR*        QUERYNO 8820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF SQLCODE  = SUCCESSFUL-CALL OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**  PCSCA005 PROCESSING ERROR        **'         
              DISPLAY '**  ERROR ON 8820-UPDATE-RESTART     **'         
              DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM             
              DISPLAY '**  PARTITION_NO = ' RF-PARTITION-NO             
              DISPLAY '**  DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO             
              DISPLAY '**  SQLCODE      = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**      PROCESSING TERMINATED        **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8830-INSERT-RESTART                                            *        
      ******************************************************************        
      *                                                                         
       8830-INSERT-RESTART.                                             
      *                                                                         
           EXEC SQL                                                     
               INSERT INTO CSS_RESTART                                  
                          (NAME_PROGRAM                                 
                          ,PARTITION_NO                                 
                          ,DUP_CNTRL_NO                                 
                          ,RESTART_DATA)                                
               VALUES    (:RF-NAME-PROGRAM                              
                         ,:RF-PARTITION-NO                              
                         ,:RF-DUP-CNTRL-NO                              
                         ,:RF-RESTART-DATA)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF SQLCODE  = SUCCESSFUL-CALL                                
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**   PCSCA005 PROCESSING ERROR       **'         
              DISPLAY '**   ERROR ON 8830-INSERT-RESTART    **'         
              DISPLAY '**   NAME_PROGRAM = ' RF-NAME-PROGRAM            
              DISPLAY '**   PARTITION_NO = ' RF-PARTITION-NO            
              DISPLAY '**   DUP_CNTRL_NO = ' RF-DUP-CNTRL-NO            
              DISPLAY '**   SQLCODE      = ' WS-ACTIVE-RETURN-CODE      
              DISPLAY '**       PROCESSING TERMINATED       **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8830-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42471600
      ******************************************************************        
      * 8850-DEL-RESTART-REC.                                          *        
      ******************************************************************        
      *                                                                         
       8850-DEL-RESTART-REC.                                            
      *                                                                         
           MOVE WS-PGRMNAME                 TO RF-NAME-PROGRAM.         
           MOVE 1                           TO RF-PARTITION-NO.         
           MOVE 1                           TO RF-DUP-CNTRL-NO.         
      *                                                                         
           EXEC SQL                                                     
              DELETE FROM RF                                 
              FROM CSS_RESTART RF
               WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                 
                 AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                 
                 AND RF.PARTITION_NO = :RF-PARTITION-NO                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_RESTART RF                                        
MFA-TR*        WHERE RF.NAME_PROGRAM = :RF-NAME-PROGRAM                         
MFA-TR*          AND RF.DUP_CNTRL_NO = :RF-DUP-CNTRL-NO                         
MFA-TR*          AND RF.PARTITION_NO = :RF-PARTITION-NO                         
MFA-TR*      QUERYNO 8850                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***************************************'         
              DISPLAY '**   PCSCA005 PROCESSING ERROR       **'         
              DISPLAY '**  ERROR ON 8850-DEL-RESTART-REC'               
              DISPLAY '**  NAME_PROGRAM = ' RF-NAME-PROGRAM             
              DISPLAY '**  SQLCODE      = ' WS-ACTIVE-RETURN-CODE       
              DISPLAY '**       PROCESSING TERMINATED       **'         
              DISPLAY '***************************************'         
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8600-INSERT-MNT-TRANS-HIST.                                   *         
      *****************************************************************         
       8600-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST                           
                 (                                                      
                   TRANS_HIST_SEQ_NO                                    
                  ,DATE_TRANS                                           
                  ,CODE_TRAN_TYPE                                       
                  ,RESP_AREA_ID                                         
                  ,ACCOUNT_NO                                           
                  ,PREMISE_NO                                           
                  ,CUSTOMER_NO                                          
                  ,USER_ID                                              
                  ,APPL_PROGRAM_ID                                      
                  ,TRAN_COMMENT                                         
                 )                                                      
               VALUES                                                   
                 (                                                      
                   CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                    
                  ,IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) )                               
                  ,:MH-CODE-TRAN-TYPE                                   
                  ,:MH-RESP-AREA-ID                                     
                  ,:MH-ACCOUNT-NO                                       
                  ,:MH-PREMISE-NO                                       
                  ,:MH-CUSTOMER-NO                                      
                  ,:MH-USER-ID                                          
                  ,:MH-APPL-PROGRAM-ID                                  
                  ,:MH-TRAN-COMMENT                                     
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST                                   
MFA-TR*          (                                                              
MFA-TR*            TRANS_HIST_SEQ_NO                                            
MFA-TR*           ,DATE_TRANS                                                   
MFA-TR*           ,CODE_TRAN_TYPE                                               
MFA-TR*           ,RESP_AREA_ID                                                 
MFA-TR*           ,ACCOUNT_NO                                                   
MFA-TR*           ,PREMISE_NO                                                   
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,APPL_PROGRAM_ID                                              
MFA-TR*           ,TRAN_COMMENT                                                 
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :MH-TRANS-HIST-SEQ-NO                                        
MFA-TR*           ,:MH-DATE-TRANS                                               
MFA-TR*           ,:MH-CODE-TRAN-TYPE                                           
MFA-TR*           ,:MH-RESP-AREA-ID                                             
MFA-TR*           ,:MH-ACCOUNT-NO                                               
MFA-TR*           ,:MH-PREMISE-NO                                               
MFA-TR*           ,:MH-CUSTOMER-NO                                              
MFA-TR*           ,:MH-USER-ID                                                  
MFA-TR*           ,:MH-APPL-PROGRAM-ID                                          
MFA-TR*           ,:MH-TRAN-COMMENT                                             
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '     8600-INSERT-MNT-TRANS-HIST'                 
              DISPLAY ' RETURN CODE    = '   WS-ACTIVE-RETURN-CODE      
              DISPLAY 'ACCOUNT_NO      = '   MH-ACCOUNT-NO              
              DISPLAY 'PREMISE NO      = '   MH-PREMISE-NO              
              DISPLAY 'CUSTOMER NO     = '   MH-CUSTOMER-NO             
              DISPLAY 'USER ID         = '   MH-USER-ID                 
              PERFORM 9900-ABEND               THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8610-INSERT-MT-TRN-HST-DET.                                   *         
      *****************************************************************         
       8610-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET                           
                 (                                                      
                   TRANS_HIST_SEQ_NO                                    
                  ,TRAN_APPL_NO                                         
                  ,COLUMN_DESC                                          
                  ,PRV_COLUMN_VALUE                                     
                  ,CHG_COLUMN_VALUE                                     
                  ,TABLE_ID                                             
                 )                                                      
               VALUES                                                   
                 (                                                      
                   CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO)                    
                  ,:MI-TRAN-APPL-NO                                     
                  ,:MI-COLUMN-DESC                                      
                  ,:MI-PRV-COLUMN-VALUE                                 
                  ,:MI-CHG-COLUMN-VALUE                                 
                  ,:MI-TABLE-ID                                         
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET                                   
MFA-TR*          (                                                              
MFA-TR*            TRANS_HIST_SEQ_NO                                            
MFA-TR*           ,TRAN_APPL_NO                                                 
MFA-TR*           ,COLUMN_DESC                                                  
MFA-TR*           ,PRV_COLUMN_VALUE                                             
MFA-TR*           ,CHG_COLUMN_VALUE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :MI-TRANS-HIST-SEQ-NO                                        
MFA-TR*           ,:MI-TRAN-APPL-NO                                             
MFA-TR*           ,:MI-COLUMN-DESC                                              
MFA-TR*           ,:MI-PRV-COLUMN-VALUE                                         
MFA-TR*           ,:MI-CHG-COLUMN-VALUE                                         
MFA-TR*           ,:MI-TABLE-ID                                                 
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              DISPLAY '*******************************************'     
              DISPLAY '       ABENDING PROGRAM '                        
              DISPLAY '     8610-INSERT-MT-TRN-HST-DET'                 
              DISPLAY ' RETURN CODE      = '   WS-ACTIVE-RETURN-CODE    
              DISPLAY 'TRANS HIST SEQ NO = '   MI-TRANS-HIST-SEQ-NO     
              DISPLAY 'TRAN ALL          = '   MI-TRAN-APPL-NO          
              DISPLAY 'COLUMN DESC       = '   MI-COLUMN-DESC           
              DISPLAY 'PREV COLUMN VALUE = '   MI-PRV-COLUMN-VALUE      
              DISPLAY 'CHG COLUMN VALUE  = '   MI-CHG-COLUMN-VALUE      
              DISPLAY 'TABLE ID          = '   MI-TABLE-ID              
           END-IF.                                                      
                                                                        
       8610-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8888-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8888-COMMIT.                                                     
      *                                                                         
           PERFORM 2800-PRE-COMMIT          THRU 2800-EXIT              
           PERFORM 8810-WRITE-RESTART       THRU 8810-EXIT              
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '*******************************************'        
           DISPLAY '*COMMIT POINT # ' WS-CHKP-SEQ-NO ' TAKEN.**'        
           DISPLAY '*LAST REC PROCESSED  = ' AT-ACCOUNT-NO              
           DISPLAY '*******************************************'.       
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8889-COMMIT.                                                   *        
      ******************************************************************        
      *                                                                         
       8889-COMMIT.                                                     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00047                                                 
           END-EXEC.                                                            
      *                                                                         
           DISPLAY '*******************************************'        
           DISPLAY '* TOT NO. OF RECORDS PROCESSED:' WS-FIOCA05-REC-CNTR
           DISPLAY '*******************************************'.       
      *                                                                         
       8889-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 9000-SEND-ERROR-RESULT. REQUIRED BY THE COPYBOOK              *         
      *****************************************************************         
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
      *                                                                         
      ******************************************************************        
      *  CLOSES  THE INPUT  FILE                                       *        
      ******************************************************************        
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSCA05-FILE                                           
      *                                                                         
           IF FCA05-SUCCESSFUL                                          
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY 'ERROR IN CLOSING FCSCA05-FILE'                   
              DISPLAY 'ERROR STATUS ' WS-FCA05-STATUS                   
           END-IF.                                                      
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  6253-GET-FJC01-CHKP-LIMIT.                                   *        
      ******************************************************************        
      *                                                                         
           COPY CPD00034.                                                       
      *                                                                         
      ******************************************************************        
      **  6240-GET-FCA00-COMMON-DATE.                                  *        
      ******************************************************************        
      *                                                                         
           COPY CPD00040.                                                       
      *                                                                         
      ******************************************************************        
      *  6251-GET-FJC01-DATE.                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7600-START-FCSJC01.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00038                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  7620-START-FCSCA00.                                           *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00039                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *  8895-INSERT-WORK-QUEUE                                        *        
      ******************************************************************        
       8895-INSERT-WORK-QUEUE.                                          
      *                                                                *        
           MOVE SPACES                       TO ABEND-FUNCTION.         
           CALL SCSCB077  USING   CWS00077-FIELDS,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
                                                                        
            MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE.  
                                                                        
            IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0        
               MOVE PROGRAM-NAME             TO   ABEND-PROGRAM         
               DISPLAY '8895-INSERT-WORK-QUEUE'                         
               DISPLAY 'CALL SCSCB077         '                         
               DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO              
               DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO              
               DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO           
               DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE         
               PERFORM 9900-ABEND             THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8895-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************55180000
      * 9900-SQL-ERROR-ROUTINE. REQUIRED BY THE COPYBOOK               *55190000
      ******************************************************************55200000
      *                                                                 55220000
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                 55220000
           DISPLAY '**************************************'.            
           DISPLAY '**  PROCESSING ERROR'.                              
           DISPLAY '**  PROGRAM    = ' ABEND-PROGRAM.                   
                                                                        
           IF  ABEND-FUNCTION > SPACES                                  
               DISPLAY '**  FUNCTION   = ' ABEND-FUNCTION
           END-IF.              
                                                                        
           IF  TABLE-1 > SPACES                                         
               DISPLAY '**  TABLE/FILE = ' TABLE-1
           END-IF.                     
                                                                        
           IF HOSTVAR-ELEMENT-1 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-1
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-2 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-2
           END-IF.                        
                                                                        
           IF HOSTVAR-ELEMENT-3 > SPACES                                
               DISPLAY '**  ' HOSTVAR-ELEMENT-3
           END-IF.                        
                                                                        
           DISPLAY '**************************************'.            
           PERFORM 9900-ABEND                    THRU 9900-EXIT.        
      *                                                                         
      ******************************************************************        
      *  9900-ABEND.                                                   *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD09900                                                 
           END-EXEC.                                                            
      *                                                                         
