       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   PCSCA004.                                          
       AUTHOR.       BD09555.                                           
       DATE-WRITTEN. JUNE 2015.                                         
      ******************************************************************        
      **               SOUTH CAROLINA ELECTRIC & GAS                  **        
      **                      COBOL-DB2                               **        
      ******************************************************************        
      **                     PROGRAM SUMMARY                          **        
      ******************************************************************        
      **                                                              **        
      ** COUNT ZIP CODES IN SORT INDEX FILE FOR POSTAL DISCOUNTS.     **        
      ** FIVE GROUPS ARE CREATED:                                     **        
      ** 1) MISSING ZIPS AND BILLS WITH INTERNATIONAL ADDRESSES       **        
      ** 2) FIVE-DIGIT ZIPS (MUST HAVE AT LEAST 150/ZIP)              **        
      ** 3) THREE-DIGIT ZIPS (MUST HAVE AT LEAST 150/THREE-DIGIT ZIP) **        
      ** 4) ALL OTHER ADDRESSES CARRYING A ZIP+4                      **        
      ** 5) ADDRESSES NOT CARRYING A ZIP+4                            **        
      ******************************************************************        
      **           BASIC BATCH PARAGRAPH SEQUENCE STRUCTURE           **        
      ******************************************************************        
      **        0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION  **        
      **        1000 - 1999     INPUT PROCESSING CONTROL PATH         **        
      **        2000 - 2999     OUTPUT PROCESS CONTROL PATH           **        
      **        3000 - 4999     NOT USED                              **        
      **        5000 - 5999     COMMON PROGRAM MODULES                **        
      **        6000 - 6999     COMMON SYSTEM MODULES                 **        
      **        7000 - 7999     INPUT MODULES                         **        
      **        8000 - 8999     OUTPUT MODULES                        **        
      **        9000 - 9999     TERMINATION, ABEND, MESSAGING MODULES **        
      ******************************************************************        
      **              PROGRAM  MODIFICATION  LOG                      **        
      ******************************************************************        
      ** DATE     USERID   REASON                                     **        
      ** 07/23/15 BD09555  DO NOT ACCESS SORTIDX AREA AT END OF FILE  **        
      **                   TO PREVENT S0C4.                           **        
ACT163** 08/28/15 BD09555  INITIALIZE TOTALS AFTER PROCESSING         **        
ACT163**                   FIVE DIGIT ZIPS.                           **        
ACT025** 02/01/16 BD09555  INITIALIZE ADDITIONAL TOTALS AFTER         **        
ACT025**                   PROCESSING FIVE DIGIT ZIPS.                **        
ACT081** 03/07/16 BD09555  ALLOW FOR NULL CONDITION WHEN TRYING       **        
ACT081**                   TO DETERMINE BILL CYCLE.                   **        
      ******************************************************************        
       ENVIRONMENT DIVISION.                                            
                                                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
           SELECT SORTWORK ASSIGN TO UT-S-SORTWORK.                     
           SELECT SORTIDXI ASSIGN TO UT-S-SORTIDXI.                     
           SELECT SORTIDXO ASSIGN TO UT-S-SORTIDXO.                     
           SELECT GRP4IN   ASSIGN TO UT-S-GRP4IN.                       
           SELECT GRP4OUT  ASSIGN TO UT-S-GRP4OUT.                      
           SELECT THREEDDG ASSIGN TO UT-S-THREEDDG.                     
           SELECT THREEDEX ASSIGN TO UT-S-THREEDEX.                     
           SELECT THREEDST ASSIGN TO UT-S-THREEDST.                     
           SELECT FIVEDDG  ASSIGN TO UT-S-FIVEDDG.                      
           SELECT FIVEDEX  ASSIGN TO UT-S-FIVEDEX.                      
           SELECT FIVEDST  ASSIGN TO UT-S-FIVEDST.                      
           SELECT ZIP4NOD  ASSIGN TO UT-S-ZIP4NOD.                      
           SELECT NOZIPINT ASSIGN TO UT-S-NOZIPINT.                     
           SELECT NOZIP4   ASSIGN TO UT-S-NOZIP4.                       
           SELECT PRINTER1 ASSIGN TO UT-S-PRINTER1.                     
           SELECT PRINTER2 ASSIGN TO UT-S-PRINTER2.                     
           SELECT TEMPF1   ASSIGN TO UT-S-TEMPF1.                       
           SELECT TEMPF2   ASSIGN TO UT-S-TEMPF2.                       
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       FILE SECTION.                                                    
       FD  SORTIDXI                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
CISOP  01  SORTIDXI-REC                 PIC X(802).                     
      *                                                                         
       FD  SORTIDXO                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
CISOP  01  SORTIDXO-REC                 PIC X(802).                     
           COPY SORTINDX.                                                       
      *                                                                         
       FD  GRP4IN                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
CISOP  01  GRP4IN-REC                   PIC X(802).                     
      *                                                                         
       FD  GRP4OUT                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
CISOP  01  GRP4OUT-REC                  PIC X(802).                     
      *                                                                         
       FD  THREEDDG                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  THREEDDG-REC                 PIC X(900).                     
      *                                                                         
       FD  THREEDEX                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  THREEDEX-REC.                                                
           05  TDX-ZIP-CODE             PIC X(3).                       
           05  FILLER                   PIC X(1).                       
           05  TDX-ZIP-SCHEME           PIC X(3).                       
      *                                                                         
       FD  FIVEDDG                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FIVEDDG-REC.                                                 
           05   FDD-ZIP-CODE            PIC X(5).                       
           05   FILLER                  PIC X(895).                     
      *                                                                         
       FD  FIVEDEX                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FIVEDEX-REC.                                                 
           05  FDX-ZIP-CODE             PIC X(5).                       
           05  FILLER                   PIC X.                          
           05  FDX-ZIP-SCHEME           PIC X(5).                       
      *                                                                         
       FD  ZIP4NOD                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  ZIP4NOD-REC                  PIC X(900).                     
      *                                                                         
       FD  TEMPF1                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  TEMPF1-REC.                                                  
           05  FILLER                   PIC X(803).                     
           05  TF1-OUT-ZIP              PIC X(5).                       
           05  TF1-OUT-ZIP3             PIC X(3).                       
           05  FILLER                   PIC X(91).                      
      *                                                                         
       FD  TEMPF2                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  TEMPF2-REC.                                                  
           05  FILLER                   PIC X(803).                     
           05  TF2-OUT-ZIP              PIC X(5).                       
           05  TF2-OUT-ZIP3             PIC X(3).                       
           05  FILLER                   PIC X(91).                      
      *                                                                         
       FD  THREEDST                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  THREEDST-REC.                                                
           05  TDS-ZIP-CODE             PIC X(3).                       
           05  FILLER                   PIC X.                          
           05  TDS-ZIP-SCHEME           PIC X(3).                       
      *                                                                         
       FD  FIVEDST                                                      
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  FIVEDST-REC.                                                 
           05  FDS-ZIP-CODE             PIC X(5).                       
           05  FILLER                   PIC X.                          
           05  FDS-ZIP-SCHEME           PIC X(5).                       
      *                                                                         
       FD  NOZIPINT                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  NOZIPINT-REC                 PIC X(900).                     
      *                                                                         
       FD  NOZIP4                                                       
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  NOZIP4-REC                   PIC X(900).                     
      *                                                                         
       FD  PRINTER1                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRINT-LINE1                  PIC X(133).                     
      *                                                                         
       FD  PRINTER2                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  PRINT-LINE2                  PIC X(133).                     
      *                                                                         
       SD  SORTWORK                                                     
           BLOCK CONTAINS 0 RECORDS                                     
           RECORDING MODE IS F                                          
           LABEL RECORDS ARE STANDARD.                                  
       01  SORTWORK-REC.                                                
           05  SWK-5DIGIT-ZIP           PIC X(5).                       
           05  FILLER                   PIC X(1).                       
           05  SWK-5DIGIT-SCHEME        PIC X(5).                       
           05  FILLER                   PIC X(889).                     
       01  FILLER.                                                      
           05  SWK-3DIGIT-ZIP           PIC X(3).                       
           05  FILLER                   PIC X(3).                       
           05  SWK-3DIGIT-SCHEME        PIC X(3).                       
           05  FILLER                   PIC XX.                         
           05  FILLER                   PIC X(889).                     
       01  FILLER.                                                      
           05  SWK-SORTINDX-REC         PIC X(801).                     
           05  SWK-SORTINDX-ZIP         PIC X(5).                       
           05  SWK-SORTINDX-ZIP3        PIC X(3).                       
           05  FILLER                   PIC X(91).                      
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA004'.
MSQ017     COPY MFASQLM.
       77  WS-Y                      PIC X(01)  VALUE 'Y'.              
       77  WS-N                      PIC X(01)  VALUE 'N'.              
       77  WS-PGRMNAME               PIC X(08)  VALUE 'PCSCA004'.       
       77  WS-CURRENT-DATE           PIC X(10)  VALUE SPACES.           
       77  WS-ZIP-COUNT              PIC S9(5)  COMP VALUE +0.          
       77  WS-LINE-CT1               PIC S9(5)  COMP VALUE +99.         
       77  WS-LINE-CT2               PIC S9(5)  COMP VALUE +99.         
       77  WS-PAGE-CT1               PIC S9(5)  COMP VALUE +00.         
       77  WS-PAGE-CT2               PIC S9(5)  COMP VALUE +00.         
       77  WS-BAD-ZIPS               PIC S9(5)  COMP VALUE +0.          
       77  WS-ZIP-TABLE-MAX          PIC S9(4)  COMP VALUE +2000.       
       77  WS-ZIP-TABLE-WARNING      PIC S9(4)  COMP VALUE +1900.       
       77  WS-5DIGIT-TOTAL           PIC S9(5)  COMP VALUE +0.          
       77  WS-5DIGIT-TABLE-TOTAL     PIC S9(5)  COMP VALUE +0.          
       77  WS-3DIGIT-TOTAL           PIC S9(5)  COMP VALUE +0.          
       77  WS-3DIGIT-TABLE-TOTAL     PIC S9(5)  COMP VALUE +0.          
       77  WS-TOTAL-INPUT-RECORDS    PIC S9(5)  COMP VALUE +0.          
       77  WS-TOTAL-OUTPUT-RECORDS   PIC S9(5)  COMP VALUE +0.          
       77  WS-SEQUENCE-NUMBER        PIC S9(11) COMP-3 VALUE +0.        
       77  WS-ENVELOPE-ID            PIC S9(5)  COMP VALUE +0.          
       77  WS-PREV-ENVELOPE-ID       PIC S9(5)  COMP VALUE +0.          
       77  WS-GROUP4-SEQUENCE        PIC S9(5)  COMP VALUE +0.          
       77  WS-NO-DISCOUNT            PIC S9(5)  COMP VALUE +0.          
       77  WS-NO-ZIPPLUS4            PIC S9(5)  COMP VALUE +0.          
       77  WS-REPORT-TOTAL           PIC S9(5)  COMP VALUE +0.          
       77  WS-RETURN-CODE            PIC S9(5)  COMP VALUE +0.          
COB305 77 WS-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.                 
       77  WS-BILL-CYCLE             PIC XX.                            
       77  WS-ZIP3                   PIC XXX.                           
       77  WS-ZIP-GROUP              PIC X(5).                          
       77  WS-END-OF-FILE            PIC X      VALUE 'N'.              
           88  END-OF-FILE                      VALUE 'Y'.              
       77  WS-SCEG-TITLE             PIC X(31)  VALUE                   
           'SOUTH CAROLINA ELECTRIC AND GAS'.                           
       77  WS-PSNC-TITLE             PIC X(31)  VALUE                   
           '          PSNC ENERGY          '.                           
       77  WS-SEB-TITLE              PIC X(31)  VALUE                   
           '         SCANA ENERGY          '.                           
       77  WS-SEBR-TITLE             PIC X(31)  VALUE                   
           '     SCANA ENERGY REGULATED    '.                           
       01  WS-BAD-ZIP-HEADER1.                                          
           05  FILLER                PIC X      VALUE SPACES.           
           05  WS-BZ-MONTH           PIC XX.                            
           05  FILLER                PIC X      VALUE '/'.              
           05  WS-BZ-DAY             PIC XX.                            
           05  FILLER                PIC X      VALUE '/'.              
           05  WS-BZ-YEAR            PIC XXXX.                          
           05  FILLER                PIC X(37)  VALUE SPACES.           
           05  WS-BZ-COMPANY         PIC X(37).                         
           05  FILLER                PIC X(41)  VALUE SPACES.           
           05  FILLER                PIC X(4)   VALUE 'PAGE'.           
           05  WS-BZ-PAGE-CT         PIC ZZZ.                           
       01  WS-BAD-ZIP-HEADER2.                                          
           05  FILLER                PIC X(48)  VALUE ' PCSCA004-002'.  
           05  FILLER                PIC X(31)  VALUE                   
               'ACCOUNTS WITH INVALID ZIP CODES'.                       
       01  WS-BAD-ZIP-HEADER3.                                          
           05  FILLER                PIC X(50)  VALUE SPACES.           
           05  FILLER                PIC X(31)  VALUE                   
               'ACCOUNT NUMBER      ZIP CODE'.                          
       01  WS-BAD-ZIP-DETAIL.                                           
           05  FILLER                PIC X(45)  VALUE SPACES.           
           05  WS-BZ-ACCOUNT         PIC 9B9999B9999B9999.              
           05  FILLER                PIC X(5)   VALUE SPACES.           
           05  WS-BZ-ZIP             PIC X(5).                          
       01  WS-BAD-ZIP-NO-REPORT.                                        
           05  FILLER                PIC X(56)  VALUE SPACES.           
           05  FILLER                PIC X(15)  VALUE 'NO REPORT TODAY'.
       01  WS-ZIP-COUNT-HEADER1.                                        
           05  FILLER                PIC X      VALUE SPACES.           
           05  WS-ZC-MONTH           PIC XX.                            
           05  FILLER                PIC X      VALUE '/'.              
           05  WS-ZC-DAY             PIC XX.                            
           05  FILLER                PIC X      VALUE '/'.              
           05  WS-ZC-YEAR            PIC XXXX.                          
           05  FILLER                PIC X(37)  VALUE SPACES.           
           05  WS-ZC-COMPANY         PIC X(37).                         
           05  FILLER                PIC X(41)  VALUE SPACES.           
           05  FILLER                PIC X(4)   VALUE 'PAGE'.           
           05  WS-ZC-PAGE-CT         PIC ZZ9.                           
       01  WS-ZIP-COUNT-HEADER2.                                        
           05  FILLER                PIC X(59)  VALUE SPACES.           
           05  FILLER                PIC X(12)  VALUE                   
               'BILL CYCLE: '.                                          
           05  WS-ZC-BILL-CYCLE      PIC XX.                            
       01  WS-ZIP-COUNT-HEADER3.                                        
           05  FILLER                PIC X(47)  VALUE ' PCSCA004-001'.  
           05  FILLER                PIC X(31)  VALUE                   
               'NUMBER OF ZIPS BY DISCOUNT TYPE'.                       
       01  WS-ZIP-COUNT-HEADER4.                                        
           05  FILLER                PIC X(49)  VALUE SPACES.           
           05  FILLER                PIC X(32)  VALUE                   
               'GROUP        ZIP CODE      TOTAL'.                      
       01  WS-ZIP-COUNT-DETAIL.                                         
           05  FILLER                PIC X(46)  VALUE SPACES.           
           05  WS-ZC-GROUP           PIC X(15).                         
           05  FILLER                PIC X(04)  VALUE SPACES.           
           05  WS-ZC-ZIP             PIC X(5).                          
           05  FILLER                PIC X(04)  VALUE SPACES.           
           05  WS-ZC-TOTAL           PIC ZZZ,ZZ9.                       
       01  FILLER                               VALUE HIGH-VALUES.      
           05  WS-5DIGIT-TABLE                                          
               OCCURS 1 TO 2000 TIMES DEPENDING ON WS-ZIP-TABLE-MAX     
               ASCENDING KEY WS-5DIGIT-ZIP                              
               INDEXED BY I.                                            
               10  WS-5DIGIT-ZIP         PIC X(5).                      
               10  WS-5DIGIT-SCHEME      PIC X(5).                      
       01  FILLER                               VALUE HIGH-VALUES.      
           05  WS-3DIGIT-TABLE                                          
               OCCURS 300 TIMES                                         
               ASCENDING KEY WS-3DIGIT-ZIP                              
               INDEXED BY J.                                            
               10  WS-3DIGIT-ZIP          PIC X(3).                     
               10  WS-3DIGIT-SCHEME       PIC X(3).                     
       01  FILLER                               VALUE HIGH-VALUES.      
           05  WS-5DIGIT-DISCOUNT                                       
               OCCURS 100 TIMES                                         
               ASCENDING KEY WS-5DIGIT-DISC-ZIP                         
               INDEXED BY K.                                            
               10  WS-5DIGIT-DISC-ZIP     PIC X(5).                     
               10  WS-5DIGIT-COUNT        PIC S99999.                   
       01  FILLER                               VALUE HIGH-VALUES.      
           05  WS-3DIGIT-DISCOUNT                                       
               OCCURS 100 TIMES                                         
               ASCENDING KEY WS-3DIGIT-DISC-ZIP                         
               INDEXED BY L.                                            
               10  WS-3DIGIT-DISC-ZIP    PIC X(3).                      
               10  WS-3DIGIT-COUNT       PIC S99999.                    
       01  WS-OUT-REC.                                                  
           05  FILLER                    PIC X(802).                    
           05  WS-OUT-GROUP              PIC X.                         
           05  WS-OUT-ZIP                PIC X(5).                      
           05  WS-OUT-ZIP3               PIC XXX.                       
       01  WS-PARM-INPUT-BREAKDOWN.                                     
           05  FILLER                    PIC X(16).                     
           05  WS-PARM-ZIP               PIC XXX.                       
           05  FILLER                    PIC X(08).                     
           05  WS-PARM-3DIGIT-SCHEME     PIC XXX.                       
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
       01  WS-BLANK-LINE              PIC X VALUE ' '.                  
      ******************************************************************        
      *    DCLGEN FOR CSS_ZIP_CODE     (A4)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBZIPCD                                                  
           END-EXEC.                                                            
      ******************************************************************        
      *    DCLGEN FOR CSS_JOB_PARM     (G6)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CWS00038                                                 
           END-EXEC.                                                            
           COPY CWS00039.                                                       
           COPY CWS00303.                                                       
           COPY CWS09900.                                                       
           COPY FIOCA00.                                                        
           COPY FIOJC01.                                                        
      *                                                                         
           EXEC SQL DECLARE ZIP_CURSOR CURSOR FOR                       
                SELECT ZIP_CODE,                                        
                       ZIP_CODE_SCHEME                                  
                  FROM   CSS_ZIP_CODE                                   
                 WHERE ZIP_CODE_SCHEME IS NOT NULL AND                  
                       ZIP_CODE_SCHEME > '00000'                        
           END-EXEC                                                     
       LINKAGE SECTION.                                                 
       01  LINK-PARM.                                                   
           05  PARM-LENGTH     PIC S9(4) COMP.                          
           05  PARM-COMPANY    PIC X(4).                                
                                                                        
       PROCEDURE DIVISION USING LINK-PARM.                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM  0100-INITIALIZATION           THRU  0100-EXIT.      
           PERFORM  1000-ASSIGN-ZIPS              THRU  1000-EXIT.      
           PERFORM  1100-COUNT-5DIGIT-ZIPS        THRU  1100-EXIT.      
           PERFORM  1200-EXTRACT-5DIGIT-DISCOUNTS THRU  1200-EXIT.      
           PERFORM  1300-COUNT-3DIGIT-ZIPS        THRU  1300-EXIT.      
           PERFORM  1400-EXTRACT-3DIGIT-DISCOUNTS THRU  1400-EXIT.      
           PERFORM  1500-COMBINE-ZIP-GROUPS       THRU  1500-EXIT.      
           PERFORM  1600-PRINT-REPORT             THRU  1600-EXIT.      
           PERFORM  9000-TERMINATE                THRU  9000-EXIT.      
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *0100-INITIALIZATION.                                            *        
      *    RETRIEVE DATES.  CREATE A LIST OF FIVE-DIGIT SCHEMES FROM   *        
      *    THE ZIP CODE TABLE AND THREE-DIGIT SCHEMES FROM JOB PARMS.  *        
      *    A SCHEME IS A ZIP CODE THAT ENCOMPASSES MORE THAN ONE ZIP   *        
      *    FOR SORTING PURPOSE.  FOR EXAMPLE, ZIP CODES 29200, 29201,  *        
      *    AND 29202 MIGHT ALL BE CONSIDERED ZIP CODE 29201 WHEN       *        
      *    COUNTING VOLUME FOR DISCOUNTS.                              *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
           EVALUATE PARM-COMPANY                                        
               WHEN 'SCEG'                                              
                   MOVE WS-SCEG-TITLE TO WS-BZ-COMPANY WS-ZC-COMPANY    
               WHEN 'PSNC'                                              
                   MOVE WS-PSNC-TITLE TO WS-BZ-COMPANY WS-ZC-COMPANY    
               WHEN 'SEB'                                               
                   MOVE WS-SEB-TITLE  TO WS-BZ-COMPANY WS-ZC-COMPANY    
               WHEN 'SEBR'                                              
                   MOVE WS-SEBR-TITLE TO WS-BZ-COMPANY WS-ZC-COMPANY    
           END-EVALUATE.                                                
           SET I J K L                 TO    1.                         
           MOVE SPACES TO WS-INPUT-DATA-BREAKDOWN.                      
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT.             
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                            THRU 6240-EXIT              
               DISPLAY 'COMMON DATE USED ==> ' WS-FCA00-COMMON-DATE     
               MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE              
                                             WS-INPUT-RUN-DATE          
           END-IF.                                                      
           MOVE WS-INPUT-RUN-DATE         TO WS-BZ-YEAR  WS-ZC-YEAR.    
           MOVE WS-INPUT-RUN-DATE-MM      TO WS-BZ-MONTH WS-ZC-MONTH.   
           MOVE WS-INPUT-RUN-DATE-DD      TO WS-BZ-DAY   WS-ZC-DAY.     
           PERFORM 7530-GET-CYCLE.                                      
           MOVE WS-BILL-CYCLE TO WS-ZC-BILL-CYCLE.                      
           OPEN OUTPUT THREEDEX FIVEDEX SORTIDXO.                       
           PERFORM 7600-START-FCSJC01  THRU  7600-EXIT.                 
           PERFORM 7610-READ-FCSJC01   THRU  7610-EXIT                  
      *    LOAD THREE DIGIT SCHEMES FROM JOB PARM TABLE*                        
           MOVE SPACES                    TO WS-SYSIPT.                 
           MOVE WS-PARM                   TO WS-COMMAND.                
                                                                        
           PERFORM 7600-START-FCSJC01       THRU 7600-EXIT.             
                                                                        
           PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT.             
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              PERFORM UNTIL END-OF-SYSIPT                               
                  MOVE G6-PARM-DATA          TO  WS-PARM-INPUT-BREAKDOWN
                  MOVE WS-PARM-ZIP           TO  TDX-ZIP-CODE           
                  MOVE WS-PARM-3DIGIT-SCHEME TO  TDX-ZIP-SCHEME         
                  WRITE THREEDEX-REC                                    
                  PERFORM 7610-READ-FCSJC01  THRU 7610-EXIT             
              END-PERFORM                                               
           ELSE                                                         
              DISPLAY 'JOB PARM ERROR - SQLCODE = ' SQLCODE             
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF                                                       
           PERFORM 7500-OPEN-ZIP-CURSOR     THRU 7500-EXIT.             
                                                                        
           PERFORM 7510-READ-ZIP-CURSOR     THRU 7510-EXIT.             
                                                                        
           PERFORM UNTIL SQLCODE NOT = 0                                
              MOVE A4-ZIP-CODE           TO  FDX-ZIP-CODE               
              MOVE A4-ZIP-CODE-SCHEME    TO  FDX-ZIP-SCHEME             
              WRITE FIVEDEX-REC                                         
              PERFORM 7510-READ-ZIP-CURSOR     THRU 7510-EXIT           
           END-PERFORM.                                                 
           IF SQLCODE NOT = 0 AND 100                                   
              DISPLAY 'ZIP CURSOR SQLCODE =  ' SQLCODE                  
              PERFORM 9900-ABEND         THRU 9900-EXIT                 
           END-IF.                                                      
           PERFORM 7520-CLOSE-ZIP-CURSOR    THRU  7520-EXIT.            
           CLOSE THREEDEX FIVEDEX.                                      
           SORT SORTWORK                                                
               ASCENDING KEY SWK-3DIGIT-ZIP                             
               USING  THREEDEX                                          
               GIVING THREEDST.                                         
           SORT SORTWORK                                                
               ASCENDING KEY SWK-5DIGIT-ZIP                             
               USING  FIVEDEX                                           
               GIVING FIVEDST.                                          
           OPEN INPUT FIVEDST THREEDST.                                 
           SET I J TO 1.                                                
           PERFORM 7240-READ-FIVEDST.                                   
           PERFORM UNTIL END-OF-FILE                                    
               MOVE FDS-ZIP-CODE        TO WS-5DIGIT-ZIP    (I)         
               MOVE FDS-ZIP-SCHEME      TO WS-5DIGIT-SCHEME (I)         
               SET I UP BY 1                                            
               PERFORM 7240-READ-FIVEDST                                
           END-PERFORM.                                                 
           IF I > WS-ZIP-TABLE-WARNING                                  
               DISPLAY 'PCSCA004 - ZIP CODE TABLE APPROACHING MAXIMUM -'
                       ' INCREASE SOON '                                
               MOVE +4 TO WS-RETURN-CODE                                
           END-IF.                                                      
           PERFORM 7250-READ-THREEDST                                   
           PERFORM UNTIL END-OF-FILE                                    
               MOVE TDS-ZIP-CODE        TO WS-3DIGIT-ZIP    (J)         
               MOVE TDS-ZIP-SCHEME      TO WS-3DIGIT-SCHEME (J)         
               SET J UP BY 1                                            
               PERFORM 7250-READ-THREEDST                               
           END-PERFORM.                                                 
           CLOSE FIVEDST THREEDST.                                      
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      * READ THE DIALOG SORT INDEX FILE.  IF THERE IS A MATCH ON       *        
      * 5-DIGIT OR 3-DIGIT SCHEME, TACK THEM ONTO THE END OF THE SORT  *        
      * INDEX FILE.  IF NOT, USE THE BILLING ZIP CODE TO POPULATE THEM.*        
      * IF WE DON'T HAVE A ZIP+4, WRITE THEM TO A SEPARATE FILE BECAUSE*        
      * WE KNOW THEY WILL NOT QUALIFY FOR DISCOUNTS.                   *        
      ******************************************************************        
       1000-ASSIGN-ZIPS.                                                
           OPEN INPUT  SORTIDXI                                         
                OUTPUT NOZIPINT NOZIP4   TEMPF1 PRINTER1 PRINTER2.      
           MOVE 'N' TO WS-END-OF-FILE.                                  
           PERFORM 7210-READ-SORTIDXI.                                  
           PERFORM UNTIL END-OF-FILE                                    
               ADD +1 TO WS-TOTAL-INPUT-RECORDS                         
               IF EXT-ACCT-ZIPCODE NOT > '00000' OR                     
                  EXT-BILL-EXCEPTION-CODE  = 'CI'                       
                      MOVE 'A'        TO WS-OUT-GROUP                   
                      MOVE WS-OUT-REC TO NOZIPINT-REC                   
                      WRITE NOZIPINT-REC                                
                      ADD +1          TO WS-BAD-ZIPS                    
               ELSE                                                     
                   IF EXT-ACCT-ZIP-PLUS-FOUR >= '0000'                  
                      MOVE EXT-ACCT-ZIPCODE TO WS-ZIP3                  
                      SEARCH ALL WS-5DIGIT-TABLE                        
                          AT END                                        
                             MOVE EXT-ACCT-ZIPCODE         TO WS-OUT-ZIP
                          WHEN WS-5DIGIT-ZIP (I) = EXT-ACCT-ZIPCODE     
                             DISPLAY EXT-ACCT-ZIPCODE ' IS IN SCHEME  ' 
                               WS-5DIGIT-SCHEME (I)                     
                             MOVE WS-5DIGIT-SCHEME (I) TO WS-OUT-ZIP    
                      END-SEARCH                                        
                      SEARCH ALL WS-3DIGIT-TABLE                        
                           AT END                                       
                               MOVE EXT-ACCT-ZIPCODE     TO WS-OUT-ZIP3 
                           WHEN WS-3DIGIT-ZIP (J) = WS-ZIP3             
                               DISPLAY EXT-ACCT-ZIPCODE                 
                                       ' IS IN SCHEME '                 
                                       WS-3DIGIT-SCHEME (J)             
                               MOVE WS-3DIGIT-SCHEME (J) TO             
                                     WS-OUT-ZIP3                        
                      END-SEARCH                                        
                      MOVE WS-OUT-REC TO TEMPF1-REC                     
                      WRITE TEMPF1-REC                                  
                   ELSE                                                 
                      MOVE 'E' TO WS-OUT-GROUP                          
                      MOVE WS-OUT-REC TO NOZIP4-REC                     
                      WRITE NOZIP4-REC                                  
                   END-IF                                               
               END-IF                                                   
               PERFORM 7210-READ-SORTIDXI                               
           END-PERFORM.                                                 
           CLOSE SORTIDXI NOZIPINT NOZIP4 TEMPF1.                       
           SORT SORTWORK                                                
               ASCENDING KEY SWK-SORTINDX-ZIP                           
               USING  TEMPF1                                            
               GIVING TEMPF2.                                           
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MAINTAIN A TABLE OF HOW MANY ZIP CODES HAVE AT LEAST 150       *        
      * PIECES IN A FIVE-DIGIT ZIP OR ZIP SCHEME.                      *        
      ******************************************************************        
       1100-COUNT-5DIGIT-ZIPS.                                          
           MOVE 'N' TO WS-END-OF-FILE.                                  
           OPEN INPUT  TEMPF2                                           
                OUTPUT TEMPF1.                                          
           SET K TO 1.                                                  
           PERFORM 7230-READ-TEMPF2.                                    
           PERFORM UNTIL END-OF-FILE                                    
               IF WS-OUT-ZIP = WS-ZIP-GROUP                             
                   ADD +1 TO WS-ZIP-COUNT                               
               ELSE                                                     
                   IF WS-ZIP-COUNT > 150                                
                       DISPLAY WS-ZIP-GROUP ' QUALIFIED WITH '          
                           WS-ZIP-COUNT                                 
                       MOVE WS-ZIP-GROUP TO WS-5DIGIT-DISC-ZIP (K)      
                       MOVE WS-ZIP-COUNT TO WS-5DIGIT-COUNT    (K)      
                       ADD WS-5DIGIT-COUNT (K)                          
                            TO WS-5DIGIT-TABLE-TOTAL                    
                       SET K UP BY 1                                    
                   END-IF                                               
                   MOVE WS-OUT-ZIP TO WS-ZIP-GROUP                      
                   MOVE +1         TO WS-ZIP-COUNT                      
                   END-IF                                               
               MOVE TEMPF2-REC     TO TEMPF1-REC                        
               PERFORM 7400-WRITE-TEMPF1                                
               PERFORM 7230-READ-TEMPF2                                 
           END-PERFORM.                                                 
ACT163     IF WS-ZIP-COUNT > 150                                        
ACT163         DISPLAY WS-ZIP-GROUP ' QUALIFIED WITH '                  
ACT163             WS-ZIP-COUNT                                         
ACT163         MOVE WS-ZIP-GROUP TO WS-5DIGIT-DISC-ZIP (K)              
ACT163         MOVE WS-ZIP-COUNT TO WS-5DIGIT-COUNT    (K)              
ACT163         ADD WS-5DIGIT-COUNT (K)                                  
ACT163                           TO WS-5DIGIT-TABLE-TOTAL               
ACT163     END-IF.                                                      
           CLOSE  TEMPF2 TEMPF1.                                        
       1100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * SEPARATE ADDRESSES THAT HAVE A HIT IN THE FIVE-DIGIT TABLE     *        
      * WITH THOSE THAT DON'T.  THOSE THAT DON'T WILL LATER BE TESTED  *        
      * TO SEE WHETHER THEY QUALIFY FOR THREE-DIGIT DISCOUNT.          *        
      ******************************************************************        
       1200-EXTRACT-5DIGIT-DISCOUNTS.                                   
           MOVE 'N' TO WS-END-OF-FILE.                                  
           OPEN INPUT  TEMPF1                                           
                OUTPUT TEMPF2 FIVEDDG.                                  
           PERFORM 7220-READ-TEMPF1.                                    
           PERFORM UNTIL END-OF-FILE                                    
               SEARCH ALL WS-5DIGIT-DISCOUNT                            
                    AT END                                              
                        MOVE TEMPF1-REC TO TEMPF2-REC                   
                        PERFORM 7410-WRITE-TEMPF2                       
                    WHEN WS-5DIGIT-DISC-ZIP (K) = WS-OUT-ZIP            
                        MOVE 'B'                TO WS-OUT-GROUP         
                        MOVE WS-OUT-REC         TO FIVEDDG-REC          
                        DISPLAY EXT-ACCT-ACCOUNT-NO ': 5DIGIT-GROUP'    
                        WRITE                      FIVEDDG-REC          
                   END-SEARCH                                           
                PERFORM 7220-READ-TEMPF1                                
           END-PERFORM.                                                 
           CLOSE TEMPF1 TEMPF2 FIVEDDG.                                 
           SORT SORTWORK                                                
               ASCENDING KEY SWK-SORTINDX-ZIP3                          
               USING  TEMPF2                                            
               GIVING TEMPF1.                                           
       1200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * MAINTAIN A TABLE OF HOW MANY ZIP CODES HAVE AT LEAST 150       *        
      * PIECES IN A THREE-DIGIT ZIP OR ZIP SCHEME.                     *        
      ******************************************************************        
       1300-COUNT-3DIGIT-ZIPS.                                          
ACT025     MOVE ZERO TO WS-ZIP-COUNT.                                   
ACT025     MOVE ' '  TO WS-ZIP-GROUP.                                   
           MOVE 'N' TO WS-END-OF-FILE.                                  
           OPEN INPUT  TEMPF1                                           
                OUTPUT TEMPF2.                                          
           SET L TO 1.                                                  
           PERFORM 7220-READ-TEMPF1.                                    
           PERFORM UNTIL END-OF-FILE                                    
               IF WS-OUT-ZIP3 = WS-ZIP-GROUP                            
                   ADD +1 TO WS-ZIP-COUNT                               
               ELSE                                                     
                   IF WS-ZIP-COUNT > 150                                
                       DISPLAY WS-ZIP-GROUP  ' QUALIFIED WITH '         
                           WS-ZIP-COUNT                                 
                       MOVE WS-ZIP-GROUP  TO WS-3DIGIT-DISC-ZIP (L)     
                       MOVE WS-ZIP-COUNT  TO WS-3DIGIT-COUNT    (L)     
                       ADD WS-3DIGIT-COUNT   (L)                        
                            TO WS-3DIGIT-TABLE-TOTAL                    
                       SET L UP BY 1                                    
                   END-IF                                               
                   MOVE WS-OUT-ZIP3 TO WS-ZIP-GROUP                     
                   MOVE +1          TO WS-ZIP-COUNT                     
               END-IF                                                   
               MOVE TEMPF1-REC TO TEMPF2-REC                            
               PERFORM 7410-WRITE-TEMPF2                                
               PERFORM 7220-READ-TEMPF1                                 
           END-PERFORM.                                                 
           CLOSE TEMPF1 TEMPF2.                                         
       1300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * SEPARATE ADDRESSES THAT HAVE A HIT IN THE THREE-DIGIT-TABLE    *        
      * WITH THOSE THAT DON'T.                                                  
      ******************************************************************        
       1400-EXTRACT-3DIGIT-DISCOUNTS.                                   
           MOVE 'N'  TO WS-END-OF-FILE.                                 
ACT163     MOVE ZERO TO WS-ZIP-COUNT.                                   
ACT163     MOVE ' '  TO WS-ZIP-GROUP.                                   
           OPEN INPUT  TEMPF2                                           
                OUTPUT THREEDDG ZIP4NOD.                                
           PERFORM 7230-READ-TEMPF2                                     
           PERFORM UNTIL  END-OF-FILE                                   
               SEARCH ALL WS-3DIGIT-DISCOUNT                            
                    AT END                                              
                        MOVE 'D'                TO WS-OUT-GROUP         
                        WRITE ZIP4NOD-REC       FROM WS-OUT-REC         
                    WHEN WS-3DIGIT-DISC-ZIP (L) = WS-OUT-ZIP3           
                        MOVE 'C'                TO WS-OUT-GROUP         
                        DISPLAY EXT-ACCT-ACCOUNT-NO ': 3-DIGIT-GROUP'   
                        WRITE THREEDDG-REC      FROM WS-OUT-REC         
                END-SEARCH                                              
                PERFORM 7230-READ-TEMPF2                                
           END-PERFORM.                                                 
           CLOSE  TEMPF2 THREEDDG ZIP4NOD.                              
       1400-EXIT.                                                       
           EXIT.                                                        
       1500-COMBINE-ZIP-GROUPS.                                         
           OPEN INPUT  NOZIPINT FIVEDDG THREEDDG ZIP4NOD NOZIP4 GRP4IN  
               OUTPUT  GRP4OUT.                                         
           MOVE 'N' TO WS-END-OF-FILE.                                  
           PERFORM 7260-READ-NOZIPINT.                                  
           PERFORM UNTIL  END-OF-FILE                                   
               ADD   +1           TO   WS-BAD-ZIPS                      
               MOVE NOZIPINT-REC  TO SORTIDXO-REC                       
               ADD +1 TO WS-SEQUENCE-NUMBER                             
               MOVE WS-SEQUENCE-NUMBER TO EXT-SRT-SEQ-NO                
                                          EXT-SRT-MULTIPLE-ID           
               PERFORM 7420-WRITE-SORTIDXO                              
               PERFORM 1700-BAD-ZIP-REPORT                              
               PERFORM 7260-READ-NOZIPINT                               
           END-PERFORM.                                                 
           MOVE 'N' TO WS-END-OF-FILE.                                  
           PERFORM 7270-READ-FIVEDDG.                                   
           PERFORM UNTIL  END-OF-FILE                                   
               ADD   +1           TO   WS-5DIGIT-TOTAL                  
               MOVE FIVEDDG-REC   TO   SORTIDXO-REC                     
               ADD +1 TO WS-SEQUENCE-NUMBER                             
               MOVE WS-SEQUENCE-NUMBER TO EXT-SRT-SEQ-NO                
                                          EXT-SRT-MULTIPLE-ID           
               PERFORM 7420-WRITE-SORTIDXO                              
               PERFORM 7270-READ-FIVEDDG                                
           END-PERFORM.                                                 
           MOVE 'N' TO WS-END-OF-FILE.                                  
           PERFORM 7280-READ-THREEDDG.                                  
           PERFORM UNTIL  END-OF-FILE                                   
               ADD   +1           TO   WS-3DIGIT-TOTAL                  
               MOVE THREEDDG-REC  TO   SORTIDXO-REC                     
               ADD +1 TO WS-SEQUENCE-NUMBER                             
               MOVE WS-SEQUENCE-NUMBER TO EXT-SRT-SEQ-NO                
                                          EXT-SRT-MULTIPLE-ID           
               PERFORM 7420-WRITE-SORTIDXO                              
               PERFORM 7280-READ-THREEDDG                               
           END-PERFORM.                                                 
           MOVE 'N' TO WS-END-OF-FILE.                                  
           PERFORM 7290-READ-ZIP4NOD.                                   
           PERFORM UNTIL  END-OF-FILE                                   
               ADD   +1           TO   WS-NO-DISCOUNT                   
               MOVE ZIP4NOD-REC   TO   SORTIDXO-REC                     
               ADD +1 TO WS-SEQUENCE-NUMBER                             
               MOVE WS-SEQUENCE-NUMBER TO EXT-SRT-SEQ-NO                
                                          EXT-SRT-MULTIPLE-ID           
               PERFORM 7420-WRITE-SORTIDXO                              
               PERFORM 7290-READ-ZIP4NOD                                
           END-PERFORM.                                                 
           MOVE 'N' TO WS-END-OF-FILE.                                  
           PERFORM 7300-READ-NOZIP4.                                    
           PERFORM UNTIL  END-OF-FILE                                   
               ADD   +1           TO   WS-NO-ZIPPLUS4                   
               MOVE NOZIP4-REC    TO   SORTIDXO-REC                     
               ADD +1 TO WS-SEQUENCE-NUMBER                             
               MOVE WS-SEQUENCE-NUMBER TO EXT-SRT-SEQ-NO                
                                          EXT-SRT-MULTIPLE-ID           
               PERFORM 7420-WRITE-SORTIDXO                              
               PERFORM 7300-READ-NOZIP4                                 
           END-PERFORM.                                                 
           MOVE 'N' TO WS-END-OF-FILE.                                  
           PERFORM 7200-READ-GROUP4.                                    
           IF NOT END-OF-FILE                                           
               MOVE EXT-SRT-MULTIPLE-ID TO WS-PREV-ENVELOPE-ID          
           END-IF.                                                      
           ADD 1 TO WS-SEQUENCE-NUMBER GIVING WS-ENVELOPE-ID.           
           PERFORM UNTIL  END-OF-FILE                                   
               IF WS-PREV-ENVELOPE-ID NOT = EXT-SRT-MULTIPLE-ID         
                   ADD +1 TO WS-ENVELOPE-ID                             
                   MOVE EXT-SRT-MULTIPLE-ID TO WS-PREV-ENVELOPE-ID      
               END-IF                                                   
               ADD +1 TO   WS-SEQUENCE-NUMBER                           
               MOVE WS-ENVELOPE-ID     TO EXT-SRT-MULTIPLE-ID           
               MOVE WS-SEQUENCE-NUMBER TO EXT-SRT-SEQ-NO                
               PERFORM 7430-WRITE-GROUP4                                
               PERFORM 7200-READ-GROUP4                                 
           END-PERFORM.                                                 
           CLOSE NOZIPINT FIVEDDG THREEDDG ZIP4NOD NOZIP4 SORTIDXO      
                 GRP4OUT.                                               
       1500-EXIT.                                                       
           EXIT.                                                        
       1600-PRINT-REPORT.                                               
           IF WS-PAGE-CT2 = 0                                           
               MOVE WS-PAGE-CT1 TO WS-BZ-PAGE-CT                        
               WRITE PRINT-LINE1 FROM WS-BAD-ZIP-HEADER1 AFTER ADVANCING
                   PAGE                                                 
               WRITE PRINT-LINE1 FROM WS-BAD-ZIP-HEADER2 AFTER ADVANCING
                   1 LINE                                               
               WRITE PRINT-LINE1 FROM WS-BAD-ZIP-HEADER3 AFTER ADVANCING
                   2 LINES                                              
               MOVE WS-BAD-ZIP-NO-REPORT TO PRINT-LINE1                 
               WRITE PRINT-LINE1 AFTER ADVANCING 2 LINES                
           END-IF                                                       
           MOVE 'BAD ZIPS'     TO WS-ZC-GROUP.                          
           MOVE WS-BAD-ZIPS    TO WS-ZC-TOTAL.                          
           PERFORM 1650-WRITE-DETAIL.                                   
           MOVE ' ' TO PRINT-LINE2.                                     
           WRITE PRINT-LINE2                                            
               AFTER ADVANCING 2 LINES.                                 
           IF WS-5DIGIT-DISC-ZIP (1) NUMERIC                            
               SET K TO 1                                               
               MOVE '5-DIGIT ZIP'          TO WS-ZC-GROUP               
               PERFORM UNTIL WS-5DIGIT-DISC-ZIP (K) NOT NUMERIC         
                   MOVE WS-5DIGIT-DISC-ZIP (K) TO WS-ZC-ZIP             
                   MOVE WS-5DIGIT-COUNT    (K) TO WS-ZC-TOTAL           
                   PERFORM 1650-WRITE-DETAIL                            
                   ADD +1                      TO WS-LINE-CT2           
                   SET K UP BY 1                                        
               END-PERFORM                                              
               MOVE 'TOTAL'                TO WS-ZC-ZIP                 
               MOVE WS-5DIGIT-TOTAL            TO WS-ZC-TOTAL           
               PERFORM 1650-WRITE-DETAIL                                
               MOVE ' '                    TO WS-ZIP-COUNT-DETAIL       
               PERFORM 1650-WRITE-DETAIL                                
               ADD +1                      TO WS-LINE-CT2               
           END-IF.                                                      
           IF WS-3DIGIT-DISC-ZIP (1) NUMERIC                            
               SET L TO 1                                               
               PERFORM UNTIL WS-3DIGIT-DISC-ZIP (L) NOT NUMERIC         
                   MOVE WS-3DIGIT-DISC-ZIP (L) TO WS-ZC-ZIP             
                   MOVE WS-3DIGIT-COUNT    (L) TO WS-ZC-TOTAL           
                   MOVE '3-DIGIT ZIP'          TO WS-ZC-GROUP           
                   PERFORM 1650-WRITE-DETAIL                            
                   ADD +1                      TO WS-LINE-CT2           
                   SET L UP BY 1                                        
               END-PERFORM                                              
               MOVE 'TOTAL'                TO WS-ZC-ZIP                 
               MOVE WS-3DIGIT-TOTAL        TO WS-ZC-TOTAL               
               PERFORM 1650-WRITE-DETAIL                                
               MOVE ' '                    TO WS-ZIP-COUNT-DETAIL       
               PERFORM 1650-WRITE-DETAIL                                
               ADD +2                      TO WS-LINE-CT2               
           END-IF.                                                      
           MOVE 'OTHER BAR-CODED'      TO WS-ZC-GROUP                   
           MOVE WS-NO-DISCOUNT          TO WS-ZC-TOTAL                  
           PERFORM 1650-WRITE-DETAIL.                                   
           MOVE ' '                    TO WS-ZIP-COUNT-DETAIL.          
           PERFORM 1650-WRITE-DETAIL.                                   
           ADD +2                      TO WS-LINE-CT2                   
           MOVE 'NON   BAR-CODED'      TO WS-ZC-GROUP                   
           MOVE WS-NO-ZIPPLUS4         TO WS-ZC-TOTAL                   
           PERFORM 1650-WRITE-DETAIL                                    
           MOVE ' '                    TO WS-ZIP-COUNT-DETAIL.          
           PERFORM 1650-WRITE-DETAIL.                                   
           ADD +2                      TO WS-LINE-CT2                   
           MOVE 'GRAND TOTAL    '      TO WS-ZC-GROUP                   
           COMPUTE WS-REPORT-TOTAL        = WS-5DIGIT-TOTAL +           
                   WS-3DIGIT-TOTAL        + WS-BAD-ZIPS         +       
                   WS-NO-DISCOUNT         + WS-NO-ZIPPLUS4              
           MOVE WS-REPORT-TOTAL        TO WS-ZC-TOTAL.                  
           PERFORM 1650-WRITE-DETAIL.                                   
           CLOSE PRINTER1 PRINTER2.                                     
           IF  WS-TOTAL-INPUT-RECORDS      = WS-TOTAL-OUTPUT-RECORDS AND
               WS-5DIGIT-TABLE-TOTAL       = WS-5DIGIT-TOTAL         AND
               WS-3DIGIT-TABLE-TOTAL       = WS-3DIGIT-TOTAL            
                   NEXT SENTENCE                                        
           ELSE                                                         
               DISPLAY 'RECORD COUNT MISMATCH'                          
               DISPLAY 'TOTAL INPUT    = '      WS-TOTAL-INPUT-RECORDS  
                       '     TOTAL OUTPUT   = ' WS-TOTAL-OUTPUT-RECORDS 
ACT163         DISPLAY 'ON THE LEFT ARE THE TOTALS FOR THE ZIP '        
ACT163                 'DISCOUNTS COUNTED IN THE PROGRAM.  ON THE '     
ACT163                 'RIGHT ARE THE NUMBER ACTUALLY WRITTEN TO OUTPUT'
               DISPLAY '5-DIGIT TABLE  = ' WS-5DIGIT-TABLE-TOTAL        
                       '      5-DIGIT TOTAL = ' WS-5DIGIT-TOTAL         
               DISPLAY '3-DIGIT TABLE = ' WS-3DIGIT-TABLE-TOTAL         
                       '      3-DIGIT TOTAL = ' WS-3DIGIT-TOTAL         
               MOVE 12 TO WS-RETURN-CODE                                
            END-IF.                                                     
       1600-EXIT.                                                       
           EXIT.                                                        
       1650-WRITE-DETAIL.                                               
           IF WS-LINE-CT1 > 55                                          
              ADD +1 TO WS-PAGE-CT1                                     
              MOVE WS-PAGE-CT1 TO WS-ZC-PAGE-CT                         
              WRITE PRINT-LINE2 FROM WS-ZIP-COUNT-HEADER1               
                  AFTER ADVANCING PAGE                                  
              WRITE PRINT-LINE2 FROM WS-ZIP-COUNT-HEADER2               
                  AFTER ADVANCING 1 LINE                                
              WRITE PRINT-LINE2 FROM WS-ZIP-COUNT-HEADER3               
                  AFTER ADVANCING 1 LINE                                
              WRITE PRINT-LINE2 FROM WS-ZIP-COUNT-HEADER4               
                  AFTER ADVANCING 3 LINES                               
              WRITE PRINT-LINE2 FROM WS-BLANK-LINE                      
                  AFTER ADVANCING 1 LINE                                
              MOVE +7 TO WS-LINE-CT1                                    
           END-IF.                                                      
           WRITE PRINT-LINE2 FROM WS-ZIP-COUNT-DETAIL AFTER ADVANCING 1.
           ADD +1 TO WS-LINE-CT1.                                       
       1650-EXIT.                                                       
           EXIT.                                                        
       1700-BAD-ZIP-REPORT.                                             
           IF WS-LINE-CT2 > 55                                          
              ADD +1 TO WS-PAGE-CT1                                     
              MOVE WS-PAGE-CT1 TO WS-BZ-PAGE-CT                         
              WRITE PRINT-LINE1 FROM WS-BAD-ZIP-HEADER1 AFTER ADVANCING 
                  PAGE                                                  
              WRITE PRINT-LINE1 FROM WS-BAD-ZIP-HEADER2 AFTER ADVANCING 
                  1 LINE                                                
              WRITE PRINT-LINE1 FROM WS-BAD-ZIP-HEADER3 AFTER ADVANCING 
                  2 LINES                                               
              MOVE +5 TO WS-LINE-CT1                                    
           END-IF.                                                      
           MOVE NOZIPINT-REC TO EXT-SORTIDX-FILE.                       
           MOVE EXT-ACCT-ACCOUNT-NO TO WS-BZ-ACCOUNT.                   
           MOVE EXT-ACCT-ZIPCODE    TO WS-BZ-ZIP.                       
           WRITE PRINT-LINE1      FROM WS-BAD-ZIP-DETAIL.               
           ADD  +1                  TO WS-LINE-CT2.                     
       1700-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
      *================================================================*        
           EXEC SQL                                                             
               INCLUDE CPD00040                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00037                                                 
           END-EXEC.                                                            
       7200-READ-GROUP4.                                                
            READ GRP4IN AT END                                          
                 MOVE 'Y' TO WS-END-OF-FILE.                            
            MOVE GRP4IN-REC TO EXT-SORTIDX-FILE.                        
       7200-EXIT.                                                       
            EXIT.                                                       
       7210-READ-SORTIDXI.                                              
           READ SORTIDXI AT END                                         
               MOVE 'Y' TO WS-END-OF-FILE.                              
           IF NOT END-OF-FILE                                           
               MOVE SORTIDXI-REC TO WS-OUT-REC EXT-SORTIDX-FILE         
           END-IF.                                                      
       7210-EXIT.                                                       
           EXIT.                                                        
       7220-READ-TEMPF1.                                                
           READ TEMPF1 AT END                                           
               MOVE 'Y' TO WS-END-OF-FILE.                              
           MOVE TEMPF1-REC TO WS-OUT-REC EXT-SORTIDX-FILE.              
       7220-EXIT.                                                       
           EXIT.                                                        
       7230-READ-TEMPF2.                                                
             READ TEMPF2 AT END                                         
               MOVE 'Y' TO WS-END-OF-FILE.                              
             MOVE TEMPF2-REC TO WS-OUT-REC EXT-SORTIDX-FILE.            
       7230-EXIT.                                                       
           EXIT.                                                        
       7240-READ-FIVEDST.                                               
             READ FIVEDST AT END                                        
               MOVE 'Y' TO WS-END-OF-FILE.                              
       7240-EXIT.                                                       
           EXIT.                                                        
       7250-READ-THREEDST.                                              
             READ THREEDST AT END                                       
               MOVE 'Y' TO WS-END-OF-FILE.                              
       7250-EXIT.                                                       
           EXIT.                                                        
       7260-READ-NOZIPINT.                                              
             READ NOZIPINT AT END                                       
                 MOVE 'Y' TO WS-END-OF-FILE.                            
       7260-EXIT.                                                       
            EXIT.                                                       
       7270-READ-FIVEDDG.                                               
             READ FIVEDDG AT END                                        
                 MOVE 'Y' TO WS-END-OF-FILE.                            
       7270-EXIT.                                                       
            EXIT.                                                       
       7280-READ-THREEDDG.                                              
             READ THREEDDG AT END                                       
                 MOVE 'Y' TO WS-END-OF-FILE.                            
       7280-EXIT.                                                       
            EXIT.                                                       
       7290-READ-ZIP4NOD.                                               
             READ ZIP4NOD AT END                                        
                 MOVE 'Y' TO WS-END-OF-FILE.                            
       7290-EXIT.                                                       
            EXIT.                                                       
       7300-READ-NOZIP4.                                                
            READ NOZIP4 AT END                                          
                 MOVE 'Y' TO WS-END-OF-FILE.                            
       7740-EXIT.                                                       
            EXIT.                                                       
       7400-WRITE-TEMPF1.                                               
             WRITE TEMPF1-REC.                                          
       7400-EXIT.                                                       
            EXIT.                                                       
       7410-WRITE-TEMPF2.                                               
             WRITE TEMPF2-REC.                                          
       7410-EXIT.                                                       
            EXIT.                                                       
       7420-WRITE-SORTIDXO.                                             
           ADD +1 TO WS-TOTAL-OUTPUT-RECORDS.                           
           MOVE WS-SEQUENCE-NUMBER TO EXT-SRT-MULTIPLE-ID EXT-SRT-SEQ-NO
           WRITE SORTIDXO-REC.                                          
       7420-EXIT.                                                       
           EXIT.                                                        
       7430-WRITE-GROUP4.                                               
           MOVE EXT-SORTIDX-FILE TO GRP4OUT-REC.                        
           WRITE GRP4OUT-REC.                                           
       7430-EXIT.                                                       
           EXIT.                                                        
       7500-OPEN-ZIP-CURSOR.                                            
           EXEC SQL                                                     
               OPEN ZIP_CURSOR                                          
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                    
       7500-EXIT.                                                       
           EXIT.                                                        
       7510-READ-ZIP-CURSOR.                                            
           EXEC SQL                                                     
               FETCH ZIP_CURSOR                                         
               INTO :A4-ZIP-CODE,                                       
                    :A4-ZIP-CODE-SCHEME                                 
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                    
       7510-EXIT.                                                       
           EXIT.                                                        
       7520-CLOSE-ZIP-CURSOR.                                           
           EXEC SQL                                                     
               CLOSE ZIP_CURSOR                                         
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                    
       7520-EXIT.                                                       
           EXIT.                                                        
       7530-GET-CYCLE.                                                  
ACT081     EXEC SQL                                                     
ACT081         SELECT COALESCE(MAX(BILL_CYCLE),'??')                      
ACT081             INTO :WS-BILL-CYCLE                                  
ACT081             FROM   CSS_BILL_WINDOW                               
ACT081             WHERE DATE_EXTRACT  = CIS.CHAR2DATE(:WS-INPUT-DATE
              ) AND             
ACT081                 CODE_BILL_COND = 'R'           AND               
ACT081                 REVENUE_MONTH =                                  
ACT081                     (SELECT MAX(REVENUE_MONTH)                   
ACT081                         FROM   CSS_BILL_WINDOW                   
ACT081                         WHERE DATE_EXTRACT  = CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ))    
ACT081     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IFNULL(MAX(BILL_CYCLE),'??')                              
MFA-TR*            INTO :WS-BILL-CYCLE                                          
MFA-TR*            FROM   CSS_BILL_WINDOW                                       
MFA-TR*            WHERE DATE_EXTRACT  = :WS-INPUT-DATE AND                     
MFA-TR*                CODE_BILL_COND = 'R'           AND                       
MFA-TR*                REVENUE_MONTH =                                          
MFA-TR*                    (SELECT MAX(REVENUE_MONTH)                           
MFA-TR*                        FROM   CSS_BILL_WINDOW                           
MFA-TR*                        WHERE DATE_EXTRACT  = :WS-INPUT-DATE)            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT081     IF SQLCODE NOT = 0                                           
ACT081          DISPLAY '7530 - SELECT SQLCODE = ' SQLCODE              
ACT081          DISPLAY 'INPUT DATE =            ' WS-INPUT-DATE        
ACT081          PERFORM 9900-ABEND                                      
ACT081     END-IF.                                                      
       7530-EXIT.                                                       
           EXIT.                                                        
      *================================================================*        
      *                                                                         
      *================================================================*        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
      *================================================================*        
      *                                                                         
      *==============================================================*          
      * 7600-START-FCSJC01                    *                                 
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      * 7620-START-FCSCA00 VSAM CTRL FILE      *                                
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
       9000-TERMINATE.                                                  
           MOVE WS-RETURN-CODE TO RETURN-CODE.                          
           STOP RUN.                                                    
                                                                        
      *                                                                         
       9000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900-ABEND                                                     *        
      * COPYBOOK FOR ABEND/ERROR PROCESSING                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD09900                                                  
           END-EXEC.                                                            
      *                                                                         
