       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSCA001.                                        
       DATE-WRITTEN.   FEB 2017.                                        
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      **              SOUTH CAROLINA ELECTRIC AND GAS                ** 00060000
      **                     PRICE WATERHOUSE                        ** 00070000
      **                                                             ** 00080000
      **                CUSTOMER INFORMATION SYSTEM                  ** 00090000
      ***************************************************************** 00100000
      **                                                             ** 00110000
      **                P R O G R A M S U M M A R Y                  ** 00120000
      **                                                             ** 00130000
      **                                                             ** 00140000
      **         F U N C T I O N A L  D E S C R I P T I O N          ** 00150000
      **                         O F  M O D U L E                    ** 00160000
      **                                                             ** 00170000
      **  PURPOSE :                                                  ** 00180000
      **                                                             ** 00190000
      **  COPY THE LOCAL OFFICE TABLE FOR DIALOG                     ** 00200000
      ***************************************************************** 00330000
      ***************************************************************** 00340000
      **                                                             ** 00350000
      **              PROGRAM  MODIFICATION  LOG                     ** 00360000
      **    DATE    INITIALS     REASON                              ** 00370000
      **  ________  _______      ______                              ** 00380000
      **  BD09555   03-02-2017   ADD NULL INDICATOR FOR DISTRICT NO             
      ***************************************************************** 00491700
                     ---- BASIC BATCH SEQUENCE STRUCTURE -------------  
                    0000 - 0000     MAIN CONTROL PATH                   
                    --------------------------------------------------- 
                    0100 - 0100     INITIALIZE SWITCHES AND COUNTERS    
                                    OPEN FILES                          
                    --------------------------------------------------- 
                    1000 - 1000     MAIN PROCESSING LOOP                
                    --------------------------------------------------- 
                    7000 - 7500     INQUIRY CALLS TO DATABASES          
                    --------------------------------------------------- 
                    8000 - 8000     CREATE EXTRACT                      
                    --------------------------------------------------- 
                    9000 - 9000     TERMINATE                           
                    --------------------------------------------------- 
                    9900 - 9900     ABEND                               
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
           SELECT LOCALOFF ASSIGN TO UT-S-LOCALOFF.                     
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       FD  LOCALOFF.                                                    
       01  OUTPUT-RECORD.                                               
            05 OUT-COMPANY-NO        PIC X(2).                          
            05 OUT-LOCAL-OFFICE      PIC X(3).                          
            05 OUT-LOCAL-OFFICE-DESC PIC X(22).                         
            05 OUT-DISTRICT-NO       PIC X(3).                          
            05 OUT-DISTRICT-NI       PIC X.                             
            05 OUT-ADDR-STREET       PIC X(35).                         
            05 OUT-ADDRESS-OVERFLOW  PIC X(35).                         
            05 OUT-ADDR-CITY-STATE   PIC X(20).                         
            05 OUT-ADDR-ZIP-CODE     PIC X(9).                          
            05 OUT-PHONE-NO          PIC X(10).                         
            05 OUT-PHONE-NO-EXT      PIC X(6).                          
      *                                                                 00680000
      *                                                                 00720000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSCA001'.
MSQ017     COPY MFASQLM.
      *                                                                 00740000
       01  WS-MISC.                                                     
           05 WS-START                     PIC X(40) VALUE              
              'WORKING STORAGE FOR PCSCA001 STARTS HERE'.               
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  RS-RETURN-CODE              PIC S9(04) COMP VALUE 0.     
           05  WS-DISTRICT-NO-NI           PIC S9(04) COMP VALUE 0.     
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00010                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00303                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS09900                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBLOCOFC                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE LOCAL_OFFICE_CSR    CURSOR FOR                  
                SELECT  COMPANY_NO                                      
                       ,LOCAL_OFFICE                                    
                       ,LOCAL_OFFICE_DESC                               
                       ,DISTRICT_NO                                     
                       ,ADDR_STREET                                     
                       ,ADDRESS_OVERFLOW                                
                       ,ADDR_CITY_STATE                                 
TP459                  ,ADDR_ZIP_CODE                                   
T12342                 ,PHONE_NO                                        
JOURNL                 ,PHONE_NO_EXT                                    
                FROM    CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                  
C32206          ORDER BY COMPANY_NO,                                    
C32206                   LOCAL_OFFICE                                   
C32206          FOR READ ONLY                                          
C32206                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03591000
MFA-TR*         DECLARE LOCAL_OFFICE_CSR    CURSOR FOR                  03600000
MFA-TR*         SELECT  COMPANY_NO                                      03610000
MFA-TR*                ,LOCAL_OFFICE                                    03620000
MFA-TR*                ,LOCAL_OFFICE_DESC                               03621000
MFA-TR*                ,DISTRICT_NO                                     03621000
MFA-TR*                ,ADDR_STREET                                     03630000
MFA-TR*                ,ADDRESS_OVERFLOW                                03640000
MFA-TR*                ,ADDR_CITY_STATE                                 03650000
MFA-TR*                ,ADDR_ZIP_CODE                                   03660000
MFA-TR*                ,PHONE_NO                                        03661000
MFA-TR*                ,PHONE_NO_EXT                                    03662000
MFA-TR*         FROM    CSS_LOCAL_OFFICE                                03680000
MFA-TR*         ORDER BY COMPANY_NO,                                    03720023
MFA-TR*                  LOCAL_OFFICE                                   03720023
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    03730000
      *                                                                 03740000
       PROCEDURE DIVISION.                                              
                                                                        
           OPEN OUTPUT LOCALOFF.                                        
           PERFORM 7000-OPEN-LOCAL-OFFICE  THRU 7000-EXIT.              
           INITIALIZE DCLCSS-LOCAL-OFFICE.                              
           PERFORM 7300-FETCH-LOCAL-OFFICE THRU 7300-EXIT.              
           PERFORM UNTIL SQLCODE NOT = 0                                
               MOVE B1-COMPANY-NO        TO OUT-COMPANY-NO              
               MOVE B1-LOCAL-OFFICE      TO OUT-LOCAL-OFFICE            
               MOVE B1-LOCAL-OFFICE-DESC TO OUT-LOCAL-OFFICE-DESC       
               MOVE B1-DISTRICT-NO       TO OUT-DISTRICT-NO             
               MOVE B1-PHONE-NO          TO OUT-PHONE-NO                
               MOVE B1-PHONE-NO-EXT      TO OUT-PHONE-NO-EXT            
               MOVE B1-ADDRESS-OVERFLOW  TO OUT-ADDRESS-OVERFLOW        
               MOVE B1-ADDR-ZIP-CODE     TO OUT-ADDR-ZIP-CODE           
               MOVE B1-ADDR-CITY-STATE   TO OUT-ADDR-CITY-STATE         
               MOVE B1-ADDR-STREET       TO OUT-ADDR-STREET             
               WRITE OUTPUT-RECORD                                      
               INITIALIZE DCLCSS-LOCAL-OFFICE                           
               PERFORM 7300-FETCH-LOCAL-OFFICE THRU 7300-EXIT           
           END-PERFORM.                                                 
           PERFORM 7200-CLOSE-LOCAL-OFFICE THRU 7200-EXIT.              
           CLOSE LOCALOFF.                                              
           STOP RUN.                                                    
      *                                                                 04340000
        7000-OPEN-LOCAL-OFFICE.                                         
           EXEC SQL                                                     
               OPEN LOCAL_OFFICE_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7000'             TO ACTIVE-PARAGRAPH              
               MOVE SQLCODE            TO RS-RETURN-CODE                
               MOVE 'CSS_LOCAL_OFFICE' TO TABLE-1                       
               MOVE 'OPEN '            TO ABEND-FUNCTION                
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06647800
       7200-CLOSE-LOCAL-OFFICE.                                         
           EXEC SQL                                                     
               CLOSE LOCAL_OFFICE_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7100'             TO ACTIVE-PARAGRAPH              
               MOVE SQLCODE            TO RS-RETURN-CODE                
               MOVE 'CSS_LOCAL_OFFICE' TO TABLE-1                       
               MOVE 'CLOSE'            TO ABEND-FUNCTION                
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06648400
       7300-FETCH-LOCAL-OFFICE.                                         
            EXEC SQL                                                    
                FETCH LOCAL_OFFICE_CSR                                  
                INTO   :B1-COMPANY-NO                                   
                      ,:B1-LOCAL-OFFICE                                 
                      ,:B1-LOCAL-OFFICE-DESC                            
                      ,:B1-DISTRICT-NO :WS-DISTRICT-NO-NI               
                      ,:B1-ADDR-STREET                                  
                      ,:B1-ADDRESS-OVERFLOW                             
                      ,:B1-ADDR-CITY-STATE                              
                      ,:B1-ADDR-ZIP-CODE                                
                      ,:B1-PHONE-NO                                     
                      ,:B1-PHONE-NO-EXT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
               MOVE '7300'             TO ACTIVE-PARAGRAPH              
               MOVE SQLCODE            TO RS-RETURN-CODE                
               MOVE 'FETCH'            TO ABEND-FUNCTION                
               MOVE 'CSS_LOCAL_OFFICE' TO TABLE-1                       
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06652900
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
      *                                                                 09330000
       COPY CPD0023B.                                                   09340000
      *                                                                 09350100
       9900-SQL-ERROR-ROUTINE.                                          
           GO TO 9900-EXIT.                                             
      *                                                                 09350400
      *                                                                 09351000
      *                                                                 09330000
           EXEC SQL                                                     09400000
                INCLUDE CPD09900                                        09410000
           END-EXEC.                                                    09420000
