       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSC271A.                                        
       INSTALLATION.                                                    
       DATE-WRITTEN.   MAY 2012.                                        
           DATE-COMPILED.                                               
      *****************************************************************         
      **             SOUTH CAROLINA ELECTRIC & GAS                   **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                 COBOL/DB2                      *********         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS      REASON                             **         
      ** =====      ========      ======                             **         
      ** 12/31/12   SS95855       P#00585 DEVELOPMENT OF NEW PROGRAM **         
      ** 01/24/12   SS95855       P0585   STREAMLINE SEB PROCESS     **         
A04527** 06/25/13   SS95855       Remove 'F' Status Updates.         **         
      **                                                             **         
      *****************************************************************         
           REMARKS.                                                     
                              PCSC271A NARRATIVE                        
                              ==================                        
      *                                                                         
                                                                        
           This is a clone of PCSCA271 program.                         
           This Program will update the status in CSS_BATCH_EMAIL table 
           as 'M' - Missing relationship if there is no email record    
           found in CSS_CUST_EMAIL table for the corresponding Customer 
           record.                                                      
                                                                        
           Program is run for following companies:                      
           1. SCEG-RUN  VALUE '01'                                      
           2. PSNC-RUN  vALUE '26'                                      
           3. SEB-RUN   VALUE '03'                                      
           3. SEBR-RUN  VALUE '04'                                      
                                                                        
           ==========================================================   
                                                                        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
                                                                        
       CONFIGURATION SECTION.                                           
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
      **************************                                                
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSC271A'.
MSQ017     COPY MFASQLM.
      **************************                                                
      *                                                                         
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR PCSC271A STARTS HERE'.            
                                                                        
      *** ABEND SWITCH                                                          
       COPY CWS09900.                                                           
                                                                        
      *** WS ABEND WORK AREA                                                    
       COPY CWS00010.                                                           
                                                                        
      *** DB2 ERROR PROCESSING                                                  
       COPY CWS00303.                                                           
                                                                        
      ******************************************************************        
      ***                         DCLGEN'S                           ***        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    COMMUNICATION AREA                                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_BATCH_EMAIL  (AE)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBEMAIL                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_EMAIL_EVENT  (2T)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBEMEVNT                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_CUST_EMAIL     (NE)                          *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBCSTEML                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_JOB_PARM     (G6)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_DELINQUENCY  (C8)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    DCLGEN FOR CSS_REG_PROFILE  (LR)                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBREGPRF                                                 
           END-EXEC.                                                            
      *                                                                         
      * FCA00 MISC INPUT     *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00039                                                  
           END-EXEC.                                                            
      *                                                                         
      * WOKING STORAGE FOR CPDCA099                                             
           EXEC SQL                                                             
              INCLUDE CWS00099                                                  
           END-EXEC.                                                            
      *                                                                         
      * FCA00-KEY                                                               
           EXEC SQL                                                             
              INCLUDE FIOCA00                                                   
           END-EXEC.                                                            
      *                                                                         
      * DELINQUENCY                                                             
           COPY CWS00314.                                                       
      *                                                                         
      * IO AREA FOR PARM INPUT FILE 'A'                                         
           EXEC SQL                                                             
              INCLUDE FIOJC01                                                   
           END-EXEC.                                                            
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-Y                      PIC X(01)  VALUE 'Y'.            
          05 WS-N                      PIC X(01)  VALUE 'N'.            
          05 WS-PGRMNAME               PIC X(08)  VALUE 'PCSCA271'.     
          05 WS-COMPANY-NO             PIC X(02)  VALUE '01'.           
          05 PROGRAM-NAME              PIC X(08)  VALUE 'PCSCA271'.     
      *                                                                         
          05 WS-MISSING-RELATION       PIC X(01)  VALUE 'M'.            
      *                                                                         
          05 WS-EVENTS-FLAG            PIC X(01).                       
             88 MORE-EVENTS                       VALUE 'Y'.            
             88 NO-MORE-EVENTS                    VALUE 'N'.            
      *                                                                         
          05 WS-RUN-FLAG               PIC X(01).                       
             88 OVERRIDE-RUN                      VALUE 'Y'.            
             88 REGULAR-RUN                       VALUE 'N'.            
      *                                                                         
          05 WS-DATABASE-FL            PIC 9(01)  VALUE 0.              
             88 CSR-DATABASE                      VALUE 1.              
             88 SEB-DATABASE                      VALUE 2.              
      *                                                                         
          05 WS-SEB-REG-DEREG-FL       PIC X(01)  VALUE 'N'.            
             88 SEB-REGULATED                     VALUE 'Y'.            
             88 SEB-DEREGULATED                   VALUE 'N'.            
      *                                                                         
          05 WS-RUN-FOR-COMPANY        PIC X(02)  VALUE '  '.           
             88 SCEG-RUN                          VALUE '01'.           
             88 PSNC-RUN                          VALUE '26'.           
             88 SEB-RUN                           VALUE '03'.           
             88 SEBR-RUN                          VALUE '04'.           
      *                                                                         
       01 WS-WORK-AREA.                                                 
          05 RS-RETURN-CODE            PIC S9(09) VALUE +0 COMP.        
          05 RS-RETURN-CODE-DISP       PIC S9(09) VALUE +0 COMP.        
          05 WS-DISPLAY-SQLCODE        PIC ---9.                        
          05 WS-BATCH-EMAIL-ID         PIC X(18)  VALUE SPACES.         
          05 WS-SUB                    PIC 9(02)  VALUE ZERO.           
P0585     05 WS-NO-ROWS-UPDATED        PIC 9(06)  VALUE ZERO.           
      *                                                                         
       01 WS-EMAIL-EVENTS-TABLE.                                        
          05 WS-EMAIL-EVENT-ENTRIES OCCURS 99 TIMES.                    
             10  WS-TAB-COMP-NO        PIC X(02).                       
             10  WS-TAB-EMAIL-EVENT    PIC X(05).                       
      *                                                                         
      * MISC INPUT           *                                                  
           EXEC SQL                                                             
              INCLUDE CWS00038                                                  
           END-EXEC.                                                            
      *                                                                         
       01 WS-INPUT-DATA-R8                                              
             REDEFINES WS-INPUT-DATA-BREAKDOWN.                         
          10 WS-SYSIPT-R8              PIC X(08).                       
             88 COMPANY-NUMBER             VALUE 'COMP-NO='.            
          10 WS-COMP-NO-DATA           PIC X(02).                       
          10 WS-DLM                    PIC X(01).                       
          10 WS-EMAIL-EVENT-TEXT       PIC X(12).                       
          10 WS-EMAIL-EVENT-DATA       PIC X(05).                       
          10 FILLER                    PIC X(52).                       
      *                                                                         
       01 WS-END                            PIC X(40)                   
           VALUE 'WORKING STORAGE FOR PCSC271A ENDS HERE  '.            
      *                                                                         
      *****************************************************************         
      **  CURSOR TO GET ROWS FROM CSS_BATCH_EMAIL.                   **         
      **  ALL BATCH EVENTS ARE PULLED DAILY AND THIS CURSOR IS USED  **         
      **  FOR THE REGULAR RUN.                                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE BATCH_EMAIL_CSR CURSOR FOR                        
                 SELECT AE.BATCH_EMAIL_ID                               
                       ,AE.ACCOUNT_NO                                   
                       ,AE.CUSTOMER_NO                                  
                       ,AE.EMAIL_EVENT_CD                               
                       ,AE.COMPANY_NO                                   
                       ,[2T].EVENT_CHANNEL_CD                             
                       ,[2T].REG_GROUP_CD                                 
                 FROM  CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                 
                      ,CSS_EMAIL_EVENT [2T] WITH(READUNCOMMITTED)               
                 WHERE AE.EMAIL_EVENT_DT  = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )          
                 AND   AE.COMPANY_NO      = [2T].COMPANY_NO               
                 AND   AE.EMAIL_EVENT_CD  = [2T].EMAIL_EVENT_CD           
                 AND   [2T].EVENT_STATUS_CD = 'A'                         
                 AND  (AE.PROCESSED_CD IS NULL                          
                  OR   AE.PROCESSED_CD    = ' ')                        
                 ORDER BY AE.EMAIL_EVENT_CD                             
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BATCH_EMAIL_CSR CURSOR FOR                                
MFA-TR*          SELECT AE.BATCH_EMAIL_ID                                       
MFA-TR*                ,AE.ACCOUNT_NO                                           
MFA-TR*                ,AE.CUSTOMER_NO                                          
MFA-TR*                ,AE.EMAIL_EVENT_CD                                       
MFA-TR*                ,AE.COMPANY_NO                                           
MFA-TR*                ,2T.EVENT_CHANNEL_CD                                     
MFA-TR*                ,2T.REG_GROUP_CD                                         
MFA-TR*          FROM  CSS_BATCH_EMAIL AE                                       
MFA-TR*               ,CSS_EMAIL_EVENT 2T                                       
MFA-TR*          WHERE AE.EMAIL_EVENT_DT  = :AE-EMAIL-EVENT-DT                  
MFA-TR*          AND   AE.COMPANY_NO      = 2T.COMPANY_NO                       
MFA-TR*          AND   AE.EMAIL_EVENT_CD  = 2T.EMAIL_EVENT_CD                   
MFA-TR*          AND   2T.EVENT_STATUS_CD = 'A'                                 
MFA-TR*          AND  (AE.PROCESSED_CD IS NULL                                  
MFA-TR*           OR   AE.PROCESSED_CD    = ' ')                                
MFA-TR*          ORDER BY AE.EMAIL_EVENT_CD                                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7210                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CURSOR TO GET ROWS FROM CSS_BATCH_EMAIL.                   **         
      **  BATCH EVENTS THAT ARE PULLED ARE CONTROLLED BY JOB PARM    **         
      **  AND THIS CUSROR IS USED FOR OVERRIDE RUN.                  **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                     
              DECLARE OVERRIDE_EVENT_CSR CURSOR FOR                     
                 SELECT AE.BATCH_EMAIL_ID                               
                       ,AE.ACCOUNT_NO                                   
                       ,AE.CUSTOMER_NO                                  
                       ,AE.EMAIL_EVENT_CD                               
                       ,AE.COMPANY_NO                                   
                       ,[2T].EVENT_CHANNEL_CD                             
                       ,[2T].REG_GROUP_CD                                 
                 FROM  CSS_BATCH_EMAIL AE WITH(READUNCOMMITTED)                 
                      ,CSS_EMAIL_EVENT [2T] WITH(READUNCOMMITTED)               
                 WHERE AE.EMAIL_EVENT_DT  = IIF(TRY_CONVERT(DATE, 
                                                     :AE-EMAIL-EVENT-DT
              ) IS NULL OR (PATINDEX('%.%', :AE-EMAIL-EVENT-DT
              ) <> 0) OR (LEN(:AE-EMAIL-EVENT-DT
              ) <> 10), CIS.CHAR2DATE(:AE-EMAIL-EVENT-DT
              ), CONVERT(DATE, :AE-EMAIL-EVENT-DT) )          
                 AND   AE.EMAIL_EVENT_CD  = :AE-EMAIL-EVENT-CD          
                 AND   AE.COMPANY_NO      = :AE-COMPANY-NO              
                 AND   AE.COMPANY_NO      = [2T].COMPANY_NO               
                 AND   AE.EMAIL_EVENT_CD  = [2T].EMAIL_EVENT_CD           
                 AND   [2T].EVENT_STATUS_CD = 'A'                         
                 AND  (AE.PROCESSED_CD IS NULL                          
                  OR   AE.PROCESSED_CD = ' ')                           
                 ORDER BY AE.EMAIL_EVENT_CD                             
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OVERRIDE_EVENT_CSR CURSOR FOR                             
MFA-TR*          SELECT AE.BATCH_EMAIL_ID                                       
MFA-TR*                ,AE.ACCOUNT_NO                                           
MFA-TR*                ,AE.CUSTOMER_NO                                          
MFA-TR*                ,AE.EMAIL_EVENT_CD                                       
MFA-TR*                ,AE.COMPANY_NO                                           
MFA-TR*                ,2T.EVENT_CHANNEL_CD                                     
MFA-TR*                ,2T.REG_GROUP_CD                                         
MFA-TR*          FROM  CSS_BATCH_EMAIL AE                                       
MFA-TR*               ,CSS_EMAIL_EVENT 2T                                       
MFA-TR*          WHERE AE.EMAIL_EVENT_DT  = :AE-EMAIL-EVENT-DT                  
MFA-TR*          AND   AE.EMAIL_EVENT_CD  = :AE-EMAIL-EVENT-CD                  
MFA-TR*          AND   AE.COMPANY_NO      = :AE-COMPANY-NO                      
MFA-TR*          AND   AE.COMPANY_NO      = 2T.COMPANY_NO                       
MFA-TR*          AND   AE.EMAIL_EVENT_CD  = 2T.EMAIL_EVENT_CD                   
MFA-TR*          AND   2T.EVENT_STATUS_CD = 'A'                                 
MFA-TR*          AND  (AE.PROCESSED_CD IS NULL                                  
MFA-TR*           OR   AE.PROCESSED_CD = ' ')                                   
MFA-TR*          ORDER BY AE.EMAIL_EVENT_CD                                     
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7270                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  LS-PARM.                                                     
           05  LS-PARMLEN                    PIC S9(03) COMP.           
           05  LS-COMPANY-NO                 PIC X(02).                 
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION USING LS-PARM.                                
      ******************************************************************        
      *                                                                *        
      *================================================================*        
       0000-MAINLINE.                                                   
      *================================================================*        
      *                                                                         
           PERFORM 0100-INITIALIZATION      THRU 0100-EXIT.             
      *                                                                         
           IF REGULAR-RUN                                               
              PERFORM 0400-PROCESS-REGULAR-EVENTS                       
                                            THRU 0400-EXIT              
           ELSE                                                         
              PERFORM 0500-PROCESS-OVERRIDE-EVENTS                      
                                            THRU 0500-EXIT              
           END-IF.                                                      
      *                                                                         
P0585      MOVE WS-COMPANY-NO            TO AE-COMPANY-NO.              
P0585      IF PSNC-RUN                                                  
P0585         MOVE LS-COMPANY-NO         TO AE-COMPANY-NO               
P0585      END-IF.                                                      
P0585                                                                   
A04527*    PERFORM 8200-UPDATE-F-RECORDS    THRU 8200-EXIT.                     
      *                                                                         
           DISPLAY '*******************************************'        
           DISPLAY '*                                         *'        
           DISPLAY '* PROGRAM PCSC271A COMPLETED SUCCESSFULLY *'        
           DISPLAY '*                                         *'        
           DISPLAY '*******************************************'        
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0100-INITIALIZATION.                                             
      *================================================================*        
      *                                                                         
           SET REGULAR-RUN TO TRUE.                                     
      *                                                                         
      *** GET COMMON DATE IF NO OVERRIDE DATE SPECIFIED                         
           PERFORM 6251-GET-FJC01-DATE      THRU 6251-EXIT.             
           IF  COMMON-DATE-NEEDED                                       
               PERFORM 6240-GET-FCA00-COMMON-DATE                       
                                            THRU 6240-EXIT              
               DISPLAY 'COMMON DATE USED ==> ' WS-FCA00-COMMON-DATE     
               DISPLAY ' '                                              
               MOVE WS-FCA00-COMMON-DATE  TO WS-INPUT-DATE              
           END-IF.                                                      
      *                                                                         
      *** GET OVERRIDES FROM JOB PARM                                           
           PERFORM 0200-LOAD-OVERRIDES      THRU 0200-EXIT.             
                                                                        
           DISPLAY ' '.                                                 
           DISPLAY '*** NO COMMITS TAKEN, COMPLETE RE-RUN REQUIRED ***'.
           DISPLAY ' '.                                                 
      *                                                                         
      *** GET DATABASE FROM DELINQUENCY VALUE                                   
           SET CSR-DATABASE TO TRUE.                                    
                                                                        
           MOVE 'DATABASE'    TO C8-DELINQ-CD.                          
           MOVE WS-COMPANY-NO TO C8-COMPANY-NO.                         
                                                                        
           PERFORM 6520-GET-DELINQ-VALUE THRU                           
                   6520-GET-DELINQ-VALUE-EXIT.                          
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE C8-DELINQ-VALUE TO WS-DATABASE-FL                    
           END-IF.                                                      
      *                                                                         
      *** GET JCLPARM TO DETERMINE WHICH COMPANY THE JOB IS RUNNING FOR         
           IF LS-PARMLEN > ZERO                                         
              MOVE LS-COMPANY-NO      TO WS-RUN-FOR-COMPANY             
           END-IF.                                                      
                                                                        
           EVALUATE TRUE                                                
              WHEN SCEG-RUN                                             
                   DISPLAY " RUNNING FOR COMPANY SCE&G "                
                           " LS-COMPANY-NO " LS-COMPANY-NO              
                   DISPLAY " "                                          
              WHEN PSNC-RUN                                             
                   DISPLAY " RUNNING FOR COMPANY PSNC  "                
                           " LS-COMPANY-NO " LS-COMPANY-NO              
                   DISPLAY " "                                          
              WHEN SEB-RUN                                              
                   DISPLAY " RUNNING FOR COMPANY SEB (DE-REGULATED)"    
                           " LS-COMPANY-NO " LS-COMPANY-NO              
                   DISPLAY " "                                          
              WHEN SEBR-RUN                                             
                   DISPLAY " RUNNING FOR COMPANY SEB (REGULATED)"       
                           " LS-COMPANY-NO " LS-COMPANY-NO              
                   DISPLAY " "                                          
              WHEN OTHER                                                
                   DISPLAY '********** PCSC271A ERROR ****************' 
                   DISPLAY "    0100-INITIALIZATION    "                
                   DISPLAY " INVALID COMPANY CODE..... "                
                   DISPLAY " LS-COMPANY-NO " LS-COMPANY-NO              
                   DISPLAY '** PROCESSING TERMINATED                **' 
                   DISPLAY '******************************************' 
                   PERFORM 9900-ABEND            THRU 9900-EXIT         
           END-EVALUATE.                                                
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0200-LOAD-OVERRIDES.                                             
      *================================================================*        
      *                                                                         
           DISPLAY '  '.                                                
                                                                        
           INITIALIZE WS-EMAIL-EVENTS-TABLE.                            
           MOVE SPACES                    TO WS-SYSIPT.                 
           MOVE WS-PARM                   TO WS-COMMAND.                
                                                                        
           PERFORM 7600-START-FCSJC01       THRU 7600-EXIT.             
                                                                        
           PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT.             
                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              PERFORM 0300-LOAD-EMAIL-EVENT-OVERRIDE                    
                 THRU 0300-EXIT UNTIL END-OF-SYSIPT                     
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0300-LOAD-EMAIL-EVENT-OVERRIDE.                                  
      *================================================================*        
      *                                                                         
           IF COMPANY-NUMBER AND                                        
              INPUT-ACTIVE                                              
                                                                        
              SET OVERRIDE-RUN            TO TRUE                       
              COMPUTE WS-SUB = WS-SUB + 1                               
                                                                        
              MOVE WS-COMP-NO-DATA        TO WS-TAB-COMP-NO (WS-SUB)    
              MOVE WS-EMAIL-EVENT-DATA    TO WS-TAB-EMAIL-EVENT (WS-SUB)
                                                                        
             DISPLAY 'OVERRIDE COMPANY NO. ' WS-TAB-COMP-NO(WS-SUB) '  '
                     'EMAIL EVENT ' WS-TAB-EMAIL-EVENT(WS-SUB)          
                                                                        
              IF WS-SUB > 99                                            
                 DISPLAY '****************************************'     
                 DISPLAY '**  0300-LOAD-EMAIL-EVENT-OVERRIDE    **'     
                 DISPLAY '**   PCSC271A PROCESSING ERROR        **'     
                 DISPLAY '**   ABEND IN PARAGRAPH 0210          **'     
                 DISPLAY '**   ARRY OVER-FLOW OCCUR             **'     
                 DISPLAY '**   MORE THAN 99 EVENTS FOUND....    **'     
                 DISPLAY '****************************************'     
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
              END-IF                                                    
                                                                        
           END-IF.                                                      
      *                                                                         
           PERFORM 7610-READ-FCSJC01        THRU 7610-EXIT.             
      *                                                                         
       0300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0400-PROCESS-REGULAR-EVENTS.                                     
      *================================================================*        
      *                                                                         
           SET MORE-EVENTS                TO TRUE.                      
           MOVE WS-INPUT-DATE             TO AE-EMAIL-EVENT-DT          
      *                                                                         
           PERFORM 7210-OPEN-BATCH-EMAIL-CSR  THRU 7210-EXIT.           
      *                                                                         
           PERFORM 7220-FETCH-BATCH-EMAIL-CSR THRU 7220-EXIT.           
      *                                                                         
           PERFORM 1000-PROCESS-EMAIL-EVENT   THRU 1000-EXIT            
             UNTIL NO-MORE-EVENTS.                                      
      *                                                                         
           PERFORM 7230-CLOSE-BATCH-EMAIL-CSR THRU 7230-EXIT.           
      *                                                                         
       0400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0500-PROCESS-OVERRIDE-EVENTS.                                    
      *================================================================*        
      *                                                                         
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
              UNTIL WS-SUB > 99                                         
              OR WS-TAB-EMAIL-EVENT (WS-SUB) = SPACES                   
                                                                        
              MOVE WS-INPUT-DATE          TO AE-EMAIL-EVENT-DT          
              MOVE WS-TAB-COMP-NO(WS-SUB) TO AE-COMPANY-NO              
              MOVE WS-TAB-EMAIL-EVENT (WS-SUB)                          
                                          TO AE-EMAIL-EVENT-CD          
              DISPLAY 'PROCESSING EVENT: ' AE-EMAIL-EVENT-CD            
              PERFORM 0600-GET-OVERRIDE-EVENTS                          
                                            THRU 0600-EXIT              
           END-PERFORM.                                                 
      *                                                                         
       0500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       0600-GET-OVERRIDE-EVENTS.                                        
      *================================================================*        
      *                                                                         
           SET MORE-EVENTS                TO TRUE.                      
      *                                                                         
           PERFORM 7270-OPEN-OVERRIDE-EVENT-CSR  THRU 7270-EXIT.        
      *                                                                         
           PERFORM 7280-FETCH-OVERRIDE-EVENT-CSR THRU 7280-EXIT.        
      *                                                                         
           PERFORM 1000-PROCESS-EMAIL-EVENT      THRU 1000-EXIT         
             UNTIL NO-MORE-EVENTS.                                      
      *                                                                         
           PERFORM 7290-CLOSE-OVERRIDE-EVENT-CSR THRU 7290-EXIT.        
      *                                                                         
       0600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       1000-PROCESS-EMAIL-EVENT.                                        
      *================================================================*        
      *                                                                         
           MOVE AE-ACCOUNT-NO             TO LR-ACCOUNT-NO.             
      *                                                                         
           IF CSR-DATABASE                                              
              IF AE-COMPANY-NO = LS-COMPANY-NO                          
                 PERFORM 2000-PROCESS-UPDATES THRU 2000-EXIT            
              END-IF                                                    
           ELSE                                                         
P0585         PERFORM 2000-PROCESS-UPDATES    THRU 2000-EXIT            
           END-IF.                                                      
      *                                                                         
           IF REGULAR-RUN                                               
              PERFORM 7220-FETCH-BATCH-EMAIL-CSR    THRU 7220-EXIT      
           ELSE                                                         
              PERFORM 7280-FETCH-OVERRIDE-EVENT-CSR THRU 7280-EXIT      
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       2000-PROCESS-UPDATES.                                            
      *================================================================*        
      *                                                                         
           MOVE AE-CUSTOMER-NO            TO NE-CUSTOMER-NO.            
      *                                                                         
           PERFORM 7100-CHECK-EMAIL-RELATION THRU 7100-EXIT.            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 8100-UPDATE-PROCESS-CD THRU 8100-EXIT             
              DISPLAY 'UPD# ' AE-BATCH-EMAIL-ID '    ' AE-CUSTOMER-NO   
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      * 6500-LOAD-EXCP-LIMITS                                                   
      *================================================================*        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD00314                                                 
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       7000-SELECT-REG-PROFILE.                                         
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE LR WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE LR                                        
MFA-TR*         WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                               
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSC271A ERROR ******************'  
              DISPLAY '** ERROR IN  7000-SELECT-REG-PROFILE        **'  
              DISPLAY '** SELECT ERROR IN CSS_REG_PROFILE          **'  
              DISPLAY '** ACCOUNT NO     = '  LR-ACCOUNT-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7100-CHECK-EMAIL-RELATION.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               SELECT NE.EMAIL_DISP_PREF_CD                             
                 INTO :NE-EMAIL-DISP-PREF-CD                            
                 FROM CSS_CUST_EMAIL NE WITH(READUNCOMMITTED)                   
                WHERE NE.CUSTOMER_NO = :NE-CUSTOMER-NO                  
                  AND NE.EMAIL_TYPE_CD = 'P1'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NE.EMAIL_DISP_PREF_CD                                     
MFA-TR*          INTO :NE-EMAIL-DISP-PREF-CD                                    
MFA-TR*          FROM CSS_CUST_EMAIL NE                                         
MFA-TR*         WHERE NE.CUSTOMER_NO = :NE-CUSTOMER-NO                          
MFA-TR*           AND NE.EMAIL_TYPE_CD = 'P1'                                   
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSC271A ERROR ******************'  
              DISPLAY '** ERROR IN  7100-CHECK-EMAIL-RELATION      **'  
              DISPLAY '** SELECT ERROR IN CSS_CUST_EMAIL           **'  
              DISPLAY '** CUSTOMER NO    = '  NE-CUSTOMER-NO            
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7210-OPEN-BATCH-EMAIL-CSR.                                       
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN BATCH_EMAIL_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSC271A ERROR ******************'  
              DISPLAY '** ERROR IN  7210-OPEN-BATCH-EMAIL-CSR      **'  
              DISPLAY '** OPEN ERROR IN BATCH_EMAIL_CSR            **'  
              DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT         
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7220-FETCH-BATCH-EMAIL-CSR.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM BATCH_EMAIL_CSR                               
                INTO :AE-BATCH-EMAIL-ID                                 
                    ,:AE-ACCOUNT-NO                                     
                    ,:AE-CUSTOMER-NO                                    
                    ,:AE-EMAIL-EVENT-CD                                 
                    ,:AE-COMPANY-NO                                     
                    ,:2T-EVENT-CHANNEL-CD                               
                    ,:2T-REG-GROUP-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-EVENTS    TO TRUE                          
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '************ PCSC271A ERROR ****************' 
                 DISPLAY '** ERROR IN 7220-FETCH-BATCH-EMAIL-CSR    **' 
                 DISPLAY '** FETCH ERROR IN BATCH_EMAIL_CSR         **' 
                 DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT      
                 DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE     
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7230-CLOSE-BATCH-EMAIL-CSR.                                      
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE BATCH_EMAIL_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSC271A ERROR ******************'  
              DISPLAY '** ERROR IN 7230-CLOSE-BATCH-EMAIL-CSR      **'  
              DISPLAY '** CLOSE ERROR FOR IN BATCH_EMAIL_CSR       **'  
              DISPLAY '** EMAIL_EVENT_DT   = '  AE-EMAIL-EVENT-DT       
              DISPLAY '** SQL CODE         = '  WS-DISPLAY-SQLCODE      
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7230-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *================================================================*        
       7270-OPEN-OVERRIDE-EVENT-CSR.                                    
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                OPEN OVERRIDE_EVENT_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSC271A ERROR ******************'  
              DISPLAY '** ERROR IN  7270-OPEN-OVERRIDE-EVENT-CSR   **'  
              DISPLAY '** OPEN ERROR IN OVERRIDE_EVENT_CSR         **'  
              DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT         
              DISPLAY '** EMAIL_EVENT_CD = '  AE-EMAIL-EVENT-CD         
              DISPLAY '** COMPANY_NO     = '  AE-COMPANY-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7280-FETCH-OVERRIDE-EVENT-CSR.                                   
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
               FETCH FROM OVERRIDE_EVENT_CSR                            
                INTO :AE-BATCH-EMAIL-ID                                 
                    ,:AE-ACCOUNT-NO                                     
                    ,:AE-CUSTOMER-NO                                    
                    ,:AE-EMAIL-EVENT-CD                                 
                    ,:AE-COMPANY-NO                                     
                    ,:2T-EVENT-CHANNEL-CD                               
                    ,:2T-REG-GROUP-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 SET NO-MORE-EVENTS TO TRUE                             
              WHEN OTHER                                                
                 MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE      
                 DISPLAY '************ PCSC271A ERROR ****************' 
                 DISPLAY '** ERROR IN 7280-FETCH-OVERRIDE-EVENT-CSR **' 
                 DISPLAY '** FETCH ERROR IN OVERRIDE_EVENT_CSR      **' 
                 DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT      
                 DISPLAY '** EMAIL_EVENT_CD = '  AE-EMAIL-EVENT-CD      
                 DISPLAY '** COMPANY_NO     = '  AE-COMPANY-NO          
                 DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE     
                 DISPLAY '** PROCESSING TERMINATED                  **' 
                 DISPLAY '********************************************' 
                 PERFORM 9900-ABEND         THRU 9900-EXIT              
           END-EVALUATE.                                                
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
       7290-CLOSE-OVERRIDE-EVENT-CSR.                                   
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                CLOSE OVERRIDE_EVENT_CSR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSC271A ERROR ******************'  
              DISPLAY '** ERROR IN 7290-CLOSE-OVERRIDE-EVENT-CSR   **'  
              DISPLAY '** CLOSE ERROR FOR IN OVERRIDE_EVENT_CSR    **'  
              DISPLAY '** EMAIL_EVENT_DT = '  AE-EMAIL-EVENT-DT         
              DISPLAY '** EMAIL_EVENT_CD = '  AE-EMAIL-EVENT-CD         
              DISPLAY '** COMPANY_NO     = '  AE-COMPANY-NO             
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *================================================================*        
      *                                                                         
      *================================================================*        
      * GET FCA00 COMMON DATE - 6240-GET-FCA00-COMMON-DATE *                    
       COPY CPD00040.                                                           
      *================================================================*        
      *                                                                         
      *================================================================*        
      * READ PARM FILE FOR OVERRIDE DATE - 6251-GET-FJC01-DATE *                
       COPY CPD00037.                                                           
      *================================================================*        
      *                                                                         
      *==============================================================*          
      * 7600-START-FCSJC01                    *                                 
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00038                                                  
           END-EXEC.                                                            
      *                                                                         
      *==============================================================*          
      * 7620-START-FCSCA00 VSAM CTRL FILE     *                                 
      *==============================================================*          
           EXEC SQL                                                             
              INCLUDE CPD00039                                                  
           END-EXEC.                                                            
      *                                                                         
      *================================================================*        
       8100-UPDATE-PROCESS-CD.                                          
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_BATCH_EMAIL                                  
                   SET PROCESSED_CD    = 'M'                            
                      ,PROCESSED_DT    = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                 
                 WHERE BATCH_EMAIL_ID  = :AE-BATCH-EMAIL-ID             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BATCH_EMAIL                                          
MFA-TR*            SET PROCESSED_CD    = 'M'                                    
MFA-TR*               ,PROCESSED_DT    = :WS-INPUT-DATE                         
MFA-TR*          WHERE BATCH_EMAIL_ID  = :AE-BATCH-EMAIL-ID                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSC271A ERROR ******************'  
              DISPLAY '** ERROR IN 8100-UPDATE-PROCESS-CD          **'  
              DISPLAY '** UPDATE PROCESSED CD AS EXTRACTED         **'  
              DISPLAY '** BATCH_EMAIL_ID = '  AE-BATCH-EMAIL-ID         
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * These 'F' records are from previous day processing. In order to*        
      * process them thru old process, set the process code to null and*        
      * email event date to Common date.                               *        
      *================================================================*        
       8200-UPDATE-F-RECORDS.                                           
      *================================================================*        
      *                                                                         
           EXEC SQL                                                     
                UPDATE CSS_BATCH_EMAIL                                  
                   SET PROCESSED_CD    = NULL                           
                      ,PROCESSED_DT    = NULL                           
                    ,EMAIL_EVENT_DT    = IIF(TRY_CONVERT(DATE, 
                                                         :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )                 
                 WHERE PROCESSED_CD    = 'F'                            
P0585              AND COMPANY_NO      = :AE-COMPANY-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_BATCH_EMAIL                                          
MFA-TR*            SET PROCESSED_CD    = NULL                                   
MFA-TR*               ,PROCESSED_DT    = NULL                                   
MFA-TR*             ,EMAIL_EVENT_DT    = :WS-INPUT-DATE                         
MFA-TR*          WHERE PROCESSED_CD    = 'F'                                    
MFA-TR*            AND COMPANY_NO      = :AE-COMPANY-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P0585         MOVE SQLERRD(3)       TO WS-NO-ROWS-UPDATED               
P0585         DISPLAY 'NO. OF ROWS UPDATED TO F: ' WS-NO-ROWS-UPDATED   
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO WS-DISPLAY-SQLCODE         
              DISPLAY '************ PCSC271A ERROR ******************'  
              DISPLAY '** ERROR IN 8200-UPDATE-F-RECORDS           **'  
P0585         DISPLAY '**        CSS_BATCH_EMAIL                   **'  
              DISPLAY '** SQL CODE       = '  WS-DISPLAY-SQLCODE        
P0585         DISPLAY '** PROCESSED_CD   = F'                           
P0585         DISPLAY '** COMPANY_NO     = '  AE-COMPANY-NO             
              DISPLAY '** PROCESSING TERMINATED                    **'  
              DISPLAY '**********************************************'  
              PERFORM 9900-ABEND            THRU 9900-EXIT              
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      /                                                                         
      ****************************************************************          
      * 9700-PROCESS-ABEND  (REQUIED BY CPD00040)                    *          
      ****************************************************************          
       COPY CPD0023B.                                                           
      *                                                                         
       9000-TERMINATE.                                                  
       9000-EXIT.                                                       
           EXIT.                                                        
      ****                                                                      
      ****************************************************************          
      *  COPY BOOK CONTAINING 9900-ABEND INCLUDES SQL ROLLBACK   ****           
      ****************************************************************          
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
