       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     PCSBW822.                                        
       AUTHOR.        SAKTHIVEL MATHIYAZHAGAN                           
       DATE-WRITTEN.  DECEMBER 01, 2014.                                
                                                                        
      ******************************************************************00050000
      *                   CUSTOMER SERVICE SYSTEM                      *00120000
      ******************************************************************00140000
      *                                                                *00140000
      *   THIS PROGRAM CLONED FROM PCSBW160 TO CALL CPD04822 TO        *00140000
      *   SET-UP NEW CONTRACT INSTEAD OF USING OLD COPYBOOK CPD00132   *00140000
      *   AS PART OF CONTRACT PROJ000851.                              *00140000
      *                                                                *00140000
      *   THIS PROGRAM WILL CREATE 3 TYPES OF NEW CONTRACT.            *00140000
      *   1. MONTHLY CHARGE                                            *00140000
      *   2. ONE TIME PAYMENT                                          *00140000
      *   3. INSTALLMENT PAYMENT                                       *00140000
      *                                                                *00140000
      *   CWS0822A - ALL WORKING STORAGE VARIABLES                     *00140000
      *   CWS04822 - INPUT FILE                                        *00140000
      *   CPD04822 - MAIN LOGIC                                        *00140000
      *                                                                *00140000
      *   THE BELOW PARAMETERS ARE REQUIRED FIELD TO CREATE CONTRACT   *        
      *   SO MAKE SURE THAT YOU ARE PASSING THESE VALUES OR HANDLED    *        
      *   IN THE COPYBOOK.                                             *        
      *                                                                *        
      *   APPL-CODE                                                    *        
      *   APPL-PGM-ID                                                  *        
      *   UPDATE-TYPE                                                  *        
      *   ACCOUNT-NO                                                   *        
      *   CNT-ITEM-ID                                                  *        
      *   DATE-CONTRACT_TYPE                                           *        
      *   CNT-NAME-CDCODE                                              *        
      *   DATE-CONTRACT.                                               *        
      *   DATE-PYMT-START.                                             *        
      *   AMT-MO-PYMT.                                                 *        
      *   AMT-ORIG-ENTERED.                                            *        
      *   NO-SCHED-PYMTS.                                              *        
      *   CODE-BILL-TYPE                                               *        
      *   CODE-INTRST-METH                                             *        
      *   INTRST-RATE                                                  *        
      *   CNT-STATUS-CD                                                *        
      *   USER-ID                                                      *        
      *   CODE-CONTRACT-TYPE                                           *        
      *   CNT-COMMENTS-TXT                                             *        
      *   STATUS-CHANGE-DT                                             *        
      *   REV-DISTRICT-CD                                              *        
      *   DTL-CHRG-TYPE                                                *        
      *   DTL-GL-NO                                                    *        
      *   DTL-CHRG-AMT                                                 *        
      *   DTL-WRT-OFF-GL-NO                                            *        
      *   DTL-DISP-FEE                                                 *        
      *   DTL-INSP-FEE                                                 *        
      *   REBATE-AMOUNT                                                *        
      *   REBATE-CD.                                                   *        
      *   GL-ACCT-NO-ERN-INT                                           *        
      *   GL-ACCT-NO-DEF-INT                                           *        
      *   AMT-DOWN-PYMT                                                *        
      *   ADD-ON-INTRST                                                *        
      *   AMT-TAX-STATE                                                *        
      *   AMT-TAX-OTHER                                                *        
      *   LIEN-CD                                                      *        
      *                                                                *        
      ******************************************************************        
      **  PERFORM THE BELOW ACTIONS:                                  **        
      **                                                              **        
      **      1. CONTRACT INSERT:                                     **        
      **         SET-UP THE NEW CONTRACT BASED ON THE CONTRACT TYPE   **        
      **         AND CONTRACT NAME                                    **        
      **                                                              **        
      **      2. CONTRACT UPDATE:                                     **        
      **         CHANGE THE CONTRACT STATUS TO...                     **        
      **         A-PENDING                                            **        
      **         B-ACTIVE                                             **        
      **         C-PAID                                               **        
      **         D-CANCELLED                                          **        
      **         E-CLOSED                                             **        
      **         F-WRITTEN-OFF                                        **        
      **         G-FINAL BILL                                         **        
      **         P-REPOSSESSED                                        **        
      **         R-TRANSFERRED                                        **        
      **                                                              **        
      **      2. CONTRACT DELETE:  IT WONT DELETE ANY CONTARCT        **        
      **         INSTEAD IT WILL CHANGE THE CONTRACT STATUS TO        **        
      **         D-CANCELLED                                          **        
      **         E-CLOSED                                             **        
      **                                                              **        
      **      3. WHENEVER SETUP THE NEW CONTARCT OR ANY PAYMENT       **        
      **         INFO CHANGE, WILL PERFORM THE JOURNAL PROCESS.       **        
      **                                                              **        
      **      4. THE BELOW TABLES ARE USED TO SET-UP THE CONTRACT     **        
      **         1.CSS_CONTRACT                                       **        
      **         2.CSS_CNT_DETAIL                                     **        
      **         3.CSS_AR_CNTL                                        **        
      **         4.CSS_SPCL_BILL_MSG                                  **        
      **         5.CSS_ACCOUNT                                        **        
      **                                                              **        
      ******************************************************************00140000
      *   PROGRAM SUMMARY:                                             *00140000
      *                                                                *00140000
      *   COMPONENT PCSBW822 WILL VERIFY THAT ACCOUNTS ON THE          *00150000
      *   SERVICE CARE FILE ARE VALID, ACTIVE ACCOUNTS WITHIN CIS.     *00160000
      *   IF AN ACCOUNT IS NOT A VALID OR ACTIVE ACCOUNT, A WORK       *00170000
      *   QUEUE WILL BE WRITTEN FOR SERVICE CARE AND THE RECORD        *00180000
      *   WILL NOT BE WRITTEN OR UPDATE IN CIS.  IF A SERVICE CARE     *00190000
      *   CONTRACT IS TERMINATED AND THE CUSTOMER WAS ALREADY          *00200000
      *   BILLED FOR THE MONTHLY SERVICE, A WORK QUEUE WILL BE         *00210000
      *   CREATED AND ASSIGNED TO CUSTOMER ACCOUNTING.  CUSTOMER       *00220000
      *   ACCOUNTING WILL RESEARCH THE CHARGE AND DETERMINE IF A       *00230000
      *   CREDIT NEEDS TO BE ISSUED TO THE ACCOUNT.  ALL NEW           *00240000
      *   SERVICE CARE CONTRACTS WILL HAVE A ROW INSERTED INTO         *00250000
      *   TABLE CSS_CONTRACT, CSS_CNT_DETAIL AND OTHER JOURNALING,     *00260000
      *   ACCOUNTS RECEIVABLE AND ACCOUNT MAINTENANCE TABLES.  ALL     *00270000
      *   EXISTING SERVICE CARE CONTRACTS WILL HAVE THE MONTHLY        *00280000
      *   AMOUNT ADJUSTED.  WHEN AN EXISTING SERVICE CARE CONTRACT     *00290000
      *   IS CANCELLED, THE STATUS WILL BE CHANGED FROM ACTIVE TO      *00300000
      *   CANCEL.                                                      *00310000
      *                                                                *00320000
      ******************************************************************        
      *               M A I N T E N A N C E   L O G                    *        
      *                                                                *        
      *   DATE      INITIALS     COMMENTS                              *        
      *  ------     -------      --------------------------------      *        
PRJ851* 12-01-2014  MS93554      INTIALLY WRITTEN.                     *        
PRJ851* 04-20-2015  MS93554      ADDED VALIDATION FOR TRANSFERRED ACCT.*        
ACT278* 09-20-2016  TP7R341      REMOVE UNWANTED COLUMNS OF CONTRACT   *        
ACT278*  A05460                  TABLE                                 *        
      ******************************************************************        
      ******************************************************************02433000
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER.  IBM-370.                                       
       OBJECT-COMPUTER.  IBM-370.                                       
                                                                        
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
                                                                        
       COPY CSSBW822.                                                   02710000
       COPY CSSR8221.                                                   02730000
                                                                        
       COPY CSSPT33.                                                    02770000
       COPY CSSPT331.                                                   02790000
                                                                        
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
                                                                        
       COPY CFDBW822.                                                   02870000
       COPY FIOBW822.                                                   02880000
                                                                        
       COPY CFDR8221.                                                   02900000
       COPY FIOR8221.                                                   02910000
                                                                        
       COPY CFDPT33.                                                    02950000
       COPY CFDPT331.                                                   02970000
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR UPDATE CONTRACT                 *        
      ******************************************************************        
      *                                                                 02980000
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW822'.
MSQ017     COPY MFASQLM.
                                                                        
      *INPUT FILE TO SET-UP NEW CONTRACT USING CPD04822 COPYBOOK.       03000000
       COPY CWS04822.                                                           
                                                                        
       01  WS-START                    PIC X(40)  VALUE                 
           'WORKING STORAGE FOR PCSBW822 STARTS HERE'.                  
      *                                                                 03030000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08)  VALUE 'PCSBW822'.     
           05  WS-PGRMNAME             PIC X(08)  VALUE 'PCSBW822'.     
COB305     05 EIBDATE        PIC S9(7) COMP-3 VALUE 0.                
           05  SCSCB077                PIC X(08)  VALUE 'SCSCB077'.     
           05  SCSCA822                PIC X(08)  VALUE 'SCSCA822'.     
           05  WS-ITEM-ID              PIC S9(10)V COMP-3 VALUE +0.     
           05  WS-REVENUE-MONTH-1     PIC X(06).                        
           05  FILLER REDEFINES WS-REVENUE-MONTH-1.                     
               10  WS-REVMTH-CCYY     PIC 9(04).                        
               10  WS-REVMTH-MM       PIC 9(02).                        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-COMPANY-NO           PIC X(02)  VALUE '01'.           
           05  WS-ACTIVE-ACCOUNT       PIC X(01)  VALUE 'A'.            
           05  WS-ACTIVE-CONTRACT      PIC X(01)  VALUE 'B'.            
           05  WS-SERVICE-CARE-CONTRACT                                 
                                       PIC X(01)  VALUE 'F'.            
           05  WS-BILL-WINDOW-CLOSE    PIC X(01)  VALUE 'C'.            
           05  WS-CANCEL-CNTRCT        PIC X(01)  VALUE 'D'.            
           05  WS-CLOSE-CNTRCT         PIC X(01)  VALUE 'E'.            
           05  WS-INSERT               PIC X(01)  VALUE 'I'.            
           05  WS-UPDATE               PIC X(01)  VALUE 'U'.            
           05  WS-TERMINATE            PIC X(01)  VALUE 'T'.            
           05  WS-INSERT-TX            PIC X(09)  VALUE ' INSERT  '.    
           05  WS-UPDATE-TX            PIC X(09)  VALUE ' UPDATE  '.    
           05  WS-TERMINATE-TX         PIC X(09)  VALUE 'TERMINATE'.    
           05  WS-TOTAL-TX             PIC X(09)  VALUE '    TOTAL'.    
           05  WS-SERVICE-CARE         PIC X(10)  VALUE  'SRVC CARE'.   
           05  WS-COG-TRAN-TYPE-CD-73  PIC X(1)   VALUE  'P'.           
           05  WS-NEW                  PIC X(01)  VALUE 'I'.            
           05  WS-CHANGE               PIC X(01)  VALUE 'U'.            
           05  WS-DELETE               PIC X(01)  VALUE 'D'.            
           05  WS-NORMAL               PIC X(01)  VALUE 'N'.            
      *    05  WS-INVALID-ACCOUNT-FLAG PIC X(01)  VALUE 'N'.            03400000
           05  WS-FULL-COMPLIANCE      PIC X(24)  VALUE                 
               '                        '.                              
           05  WS-COMMENTS-TXT-I       PIC X(42)  VALUE                 
               'CONTRACT CREATED BY BATCH '.                            
           05  WS-COMMENTS-TXT-U       PIC X(42)  VALUE                 
               'CONTRACT UPDATED BY BATCH '.                            
           05  WS-COMMENTS-TXT-D       PIC X(42)  VALUE                 
               'CONTRACT DELETED BY BATCH '.                            
           05  WS-COMMENTS-LEN         PIC S9(04) VALUE 42.             
           05  WS-NO-REBATE            PIC X(01)  VALUE 'C'.            
           05  WS-GAS                  PIC X(01)  VALUE 'G'.            
           05  WS-UPDATE-AMT-FL        PIC X(01)  VALUE 'Y'.            
           05  WS-SYSTEM-USER-ID       PIC X(06)  VALUE 'SYSTEM'.       
           05  WS-REJECT-THRESHOLD     PIC 9(06)  VALUE 500.            
           05  WS-INVALID-CNT-CODE     PIC X(26)  VALUE                 
               'INVALID CONTRACT NAME CODE'.                            
           05  WS-INACTIVE-ACCT        PIC X(28)  VALUE                 
               'ACCOUNT IS NOT ACTIVE IN CIS'.                          
           05  WS-INVALID-ITEM-ID      PIC X(32)  VALUE                 
               'NOT A VALID SERVICE CARE ITEM ID'.                      
           05  WS-INVALID-CONTRACT     PIC X(33)  VALUE                 
               'INVALID CONTRACT TYPE FOR ITEM ID'.                     
           05  WS-NO-REV-DISTRICT      PIC X(37)  VALUE                 
               'REVENUE DISTRICT NOT AVAILABLE IN CIS'.                 
           05  WS-NO-HOME-SECURITY     PIC X(41)  VALUE                 
               'HOME SECURITY CONTRACTS MAY NOT BE ADDED.'.             
           05  WS-TRANSFER-NOT-SUB     PIC X(41)  VALUE                 
               'ACCOUNT TRANSFERRED AND NOT FINAL BILLED.'.             
           05  WS-INVALID-SETUP-DT.                                     
               10  FILLER              PIC X(33)  VALUE                 
                   'CONTRACT DATE MAY NOT BE GREATER '.                 
               10  FILLER              PIC X(19)  VALUE                 
                   'THAN CURRENT   DATE'.                               
           05  WS-INVALID-ACCOUNT.                                      
               10  WS-INVALID-ACCT-NBR PIC X(13)  VALUE SPACES.         
               10  FILLER              PIC X(01)  VALUE SPACES.         
               10  FILLER              PIC X(33)  VALUE                 
                   'NOT A VALID ACCOUNT NUMBER IN CIS'.                 
           05  WS-DUP-TRANSACTION.                                      
               10  FILLER              PIC X(32)  VALUE                 
                   'CONTRACT INSERTED OR TERMINATED '.                  
               10  FILLER              PIC X(22)  VALUE                 
                   'MULTIPLE TIMES  TODAY.'.                            
           05  WS-INVALID-ACTION.                                       
               10  FILLER              PIC X(38)  VALUE                 
                   'CONTRACT MAY BE UPDATED OR TERMINATED '.            
               10  FILLER              PIC X(23)  VALUE                 
                   'VIA CSR   DESKTOP ONLY.'.                           
           05  WS-NO-INSERT.                                            
               10  FILLER              PIC X(43)  VALUE                 
                   'VALID SERVICE CARE CONTRACT ALREADY EXISTS.'.       
               10  FILLER              PIC X(31)  VALUE                 
                   '  COULD NOT INSERT NEW CONTRACT'.                   
           05  WS-NO-UPDATE.                                            
               10  FILLER              PIC X(38)  VALUE                 
                   'VALID SERVICE CARE CONTRACT NOT FOUND.'.            
               10  FILLER              PIC X(18)  VALUE                 
                   '  UNABLE TO UPDATE'.                                
           05  WS-POSSIBLE-CREDIT.                                      
               10  FILLER              PIC X(44)  VALUE                 
                   'CUSTOMER ACCOUNTING - CREDIT MAY NEED TO BE '.      
               10  FILLER              PIC X(30)  VALUE                 
                   'GIVEN TO THE CUSTOMERS ACCOUNT'.                    
           05  WS-NO-CANCELLED.                                         
               10  FILLER              PIC X(49)  VALUE                 
                   'A VALID SERVICE CARE CONTRACT DOES NOT EXIST AND '. 
               10  FILLER              PIC X(22)  VALUE                 
                   'COULD NOT BE CANCELLED'.                            
           05  WS-CONTRACT-ITEM-ID     PIC X(08)  VALUE SPACES.         
           05  WS-CONTRACT-AMOUNT-N    PIC $(9)9.99.                    
           05  WS-CONTRACT-AMOUNT-C    PIC X(13) VALUE SPACES.          
      *                                                                 04110000
       01  WS-FILE-STATUS.                                              
           05  WS-FBW822-STATUS        PIC X(02).                       
               88  FBW822-SUCCESSFUL              VALUE '00'.           
           05  WS-FR8221-STATUS        PIC X(02).                       
               88  FR8221-SUCCESSFUL              VALUE '00'.           
           05  WS-FR8222-STATUS        PIC X(02).                       
               88  FR8222-SUCCESSFUL              VALUE '00'.           
           05  WS-FCA331-STATUS        PIC X(02).                       
               88  FCA331-SUCCESSFUL              VALUE '00'.           
      *                                                                 04210000
       01  WS-BEGIN-REC-PROCESSING.                                     
           05  WS-BEGIN-REC-SW         PIC X(01).                       
               88 BEGIN-RECS-PROCESSED            VALUE 'Y'.            
               88 BEGIN-RECS-NOT-PROCESSED        VALUE 'N'.            
               88 START-INPUT-DATA                VALUE 'X'.            
           05  WS-MORE-BEGIN-REC       PIC X(01)  VALUE 'Y'.            
               88 WS-MORE-BEGIN-REC-NO            VALUE 'N'.            
      *                                                                 04290000
       01  WS-END-REC-PROCESSING.                                       
           05  WS-END-REC-PROCESSED    PIC X(01)  VALUE 'N'.            
               88 END-REC-WAS-PROCESSED           VALUE 'Y'.            
               88 END-REC-NOT-PROCESSED           VALUE 'N'.            
      *                                                                 04340000
       01  WS-EOF-PROCESSING.                                           
           05  WS-END-OF-FCSBW822      PIC X(01)  VALUE 'N'.            
               88  END-OF-FCSBW822                VALUE 'Y'.            
      *                                                                 04380000
       01  WS-MISCELLANEOUS.                                            
           05  WS-MODEL-DATE           PIC X(10).                       
           05  WS-160-DATE-PYMT-START  PIC X(10).                       
           05  WS-160-CODE-BILL-TYPE   PIC X(01).                       
           05  WS-MODEL-STAMP          PIC X(26).                       
           05  WS-HOLD-DATE-BW         PIC X(10).                       
           05  WS-WORK-QUEUE-COUNT     PIC S9(04) COMP.                 
           05  WS-WORK-QUEUE-DAYS      PIC S9(04) VALUE +2.             
           05  WS-DAY                  PIC S9(04) COMP.                 
           05  WS-DATE-FOUND           PIC X(01)  VALUE 'N'.            
           05  WS-HOLIDAY-EXISTS       PIC X(01)  VALUE 'N'.            
               88  HOLIDAY-EXISTS                 VALUE 'Y'.            
           05  WS-TEST-TRAN-ID         PIC X(04)  VALUE 'B822'.         
      *                                                                 04530000
           05  WS-GL-NO-BREAKDOWN       PIC  9(07).                     
           05  WS-GL-NO-BREAKDOWN-NUM REDEFINES WS-GL-NO-BREAKDOWN      
                                        PIC  9(03)V9999.                
           05  WS-GL-NO-COMP3           PIC S9(03)V9999 COMP-3 VALUE 0. 
      *                                                                 04580000
       01  RS-RPC-RETURN-CODE.                                          
           05  RS-RETURN-CODE-DISP     PIC +Z(04).                      
           05  RS-ACCT-XFER-TO         PIC X(13)  VALUE SPACES.         
           05  RS-ITEM-ID              PIC S9(09) COMP VALUE +0.        
           05  S-RETURN-CODE           PIC S9(04) COMP VALUE 0.         
      *                                                                 04640000
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-BILL-DAY-00-NULL PIC S9(04) COMP VALUE +0.       
           05  WS-160-DATE-PYMT-START-N PIC S9(04) COMP VALUE +0.       
      *                                                                 04680000
       01  WS-COUNTERS.                                                 
           05  WS-ADD-COUNT            PIC S9(04) COMP VALUE +0.        
           05  WS-UPDATE-COUNT         PIC S9(04) COMP VALUE +0.        
           05  WS-TERM-COUNT           PIC S9(04) COMP VALUE +0.        
           05  WS-TOTAL-COUNT          PIC S9(04) COMP VALUE +0.        
      *                                                                 04740000
       01  WS-INPUT-TS.                                                 
           05  WS-INPUT-DATE-TS          PIC X(10).                     
           05  WS-INPUT-TS-REF           PIC X(16)                      
                                         VALUE '-00.00.00.000000'.      
      *    TITLES AND HEADERS                                           04760000
       01  WS01-TITLES-AND-HEADERS.                                     
           05  WS01-TITLES.                                             
               10  WS01-TITLE1.                                         
                   15  FILLER                PIC X(01) VALUE SPACES.    
                   15  WS01-TITLE1-PROGNAME  PIC X(08).                 
                   15  FILLER                PIC X(47) VALUE SPACES.    
                   15  WS01-TITLE1-COMP-NAME PIC X(26).                 
                   15  FILLER                PIC X(31) VALUE SPACES.    
                   15  FILLER                PIC X(10)                  
                       VALUE 'RUN-DATE: '.                              
                   15  WS01-TITLE1-RUN-DT    PIC X(10).                 
               10  WS01-TITLE2.                                         
                   15  FILLER                PIC X(59) VALUE SPACES.    
                   15  FILLER                PIC X(14)                  
                       VALUE ' SERVICE CARE '.                          
                   15  FILLER                PIC X(40) VALUE SPACES.    
                   15  FILLER                PIC X(12)                  
                       VALUE 'RUN-TIME:   '.                            
                   15  WS01-TITLE2-RUN-TM    PIC X(08).                 
               10  WS01-TITLE3.                                         
                   15  FILLER                PIC X(59) VALUE SPACES.    
                   15  FILLER                PIC X(14)                  
                       VALUE 'SUMMARY REPORT'.                          
                   15  FILLER                PIC X(44) VALUE SPACES.    
                   15  FILLER                PIC X(10)                  
                       VALUE 'PAGE:     '.                              
                   15  WS01-TITLE3-PAGE-NBR  PIC ZZ,ZZ9.                
               10  WS01-TITLE4.                                         
                   15  FILLER                PIC X(61) VALUE SPACES.    
                   15  WS01-TITLE4-RPT-DATE  PIC X(10).                 
                   15  FILLER                PIC X(62) VALUE SPACES.    
           05  WS01-HEADERS.                                            
               10  WS01-HEADER1.                                        
                   15  FILLER                PIC X(18) VALUE SPACES.    
                   15  FILLER                PIC X(07) VALUE 'TOT NBR'. 
                   15  FILLER                PIC X(09) VALUE SPACES.    
                   15  FILLER                PIC X(07) VALUE 'TOT AMT'. 
                   15  FILLER                PIC X(09) VALUE SPACES.    
                   15  FILLER                PIC X(06) VALUE 'NUMBER'.  
                   15  FILLER                PIC X(09) VALUE SPACES.    
                   15  FILLER                PIC X(06) VALUE 'AMOUNT'.  
                   15  FILLER                PIC X(08) VALUE SPACES.    
                   15  FILLER                PIC X(06) VALUE 'NUMBER'.  
                   15  FILLER                PIC X(09) VALUE SPACES.    
                   15  FILLER                PIC X(06) VALUE 'AMOUNT'.  
                   15  FILLER                PIC X(08) VALUE SPACES.    
                   15  FILLER                PIC X(08) VALUE 'NBR MISS'.
                   15  FILLER                PIC X(07) VALUE SPACES.    
                   15  FILLER                PIC X(08) VALUE 'AMT MISS'.
               10  WS01-HEADER2.                                        
                   15  FILLER                PIC X(03) VALUE SPACES.    
                   15  FILLER                PIC X(06) VALUE 'ACTION'.  
                   15  FILLER                PIC X(08) VALUE SPACES.    
                   15  FILLER                PIC X(08)                  
                       VALUE 'RECEIVED'.                                
                   15  FILLER                PIC X(08) VALUE SPACES.    
                   15  FILLER                PIC X(08)                  
                       VALUE 'RECEIVED'.                                
                   15  FILLER                PIC X(05) VALUE SPACES.    
                   15  FILLER                PIC X(10)                  
                       VALUE 'SUCCESSFUL'.                              
                   15  FILLER                PIC X(05) VALUE SPACES.    
                   15  FILLER                PIC X(10)                  
                       VALUE 'SUCCESSFUL'.                              
                   15  FILLER                PIC X(06) VALUE SPACES.    
                   15  FILLER                PIC X(08)                  
                       VALUE 'REJECTED'.                                
                   15  FILLER                PIC X(07) VALUE SPACES.    
                   15  FILLER                PIC X(08)                  
                       VALUE 'REJECTED'.                                
                   15  FILLER                PIC X(07) VALUE SPACES.    
                   15  FILLER                PIC X(09)                  
                       VALUE 'CURR BILL'.                               
                   15  FILLER                PIC X(06) VALUE SPACES.    
                   15  FILLER                PIC X(09)                  
                       VALUE 'CURR BILL'.                               
                   15  FILLER                PIC X(02) VALUE SPACES.    
                                                                        
                                                                        
      *  DETAIL LINES                                                   05570000
                                                                        
       01  WS02-DETAIL-LINES.                                           
           05  WS02-BLANK-LINE               PIC X(133) VALUE SPACES.   
           05  WS02-DETAIL-LINE.                                        
               10  FILLER                    PIC X(02) VALUE SPACES.    
               10  WS02-ACTION               PIC X(09).                 
               10  FILLER                    PIC X(05) VALUE SPACES.    
               10  WS02-NBR-PROCESSED        PIC Z,ZZZ,ZZ9.             
               10  FILLER                    PIC X(02) VALUE SPACES.    
               10  WS02-AMT-PROCESSED        PIC ---,---,--9.99.        
               10  FILLER                    PIC X(08) VALUE SPACES.    
               10  WS02-NBR-SUCCESS          PIC ZZZ,ZZ9.               
               10  FILLER                    PIC X(02) VALUE SPACES.    
               10  WS02-AMT-SUCCESS          PIC --,---,--9.99.         
               10  FILLER                    PIC X(07) VALUE SPACES.    
               10  WS02-NBR-REJECT           PIC ZZZ,ZZ9.               
               10  FILLER                    PIC X(02) VALUE SPACES.    
               10  WS02-AMT-REJECT           PIC --,---,--9.99.         
               10  FILLER                    PIC X(09) VALUE SPACES.    
               10  WS02-NBR-MISSED-BILL      PIC ZZZ,ZZ9.               
               10  FILLER                    PIC X(02) VALUE SPACES.    
               10  WS02-AMT-MISSED-BILL      PIC --,---,--9.99.         
               10  FILLER                    PIC X(02) VALUE SPACES.    
           05  WS02-TOTAL-LINE.                                         
               10  FILLER                    PIC X(16) VALUE SPACES.    
               10  FILLER                    PIC X(116) VALUE '-'.      
               10  FILLER                    PIC X(01) VALUE SPACES.    
           05  WS02-NO-FILE-LINE.                                       
               10  FILLER                    PIC X(56) VALUE SPACES.    
               10  FILLER                    PIC X(25)                  
                   VALUE '*** NO FILE RECEIVED *** '.                   
               10  FILLER                    PIC X(52) VALUE SPACES.    
           05  WS02-NO-DATA-LINE.                                       
               10  FILLER                    PIC X(56) VALUE SPACES.    
               10  FILLER                    PIC X(25)                  
                   VALUE '*** NO DATA RECEIVED *** '.                   
               10  FILLER                    PIC X(52) VALUE SPACES.    
           05  WS02-END-DATA-LINE.                                      
               10  FILLER                    PIC X(56) VALUE SPACES.    
               10  FILLER                    PIC X(22)                  
                   VALUE '*** END OF REPORT *** '.                      
               10  FILLER                    PIC X(55) VALUE SPACES.    
           05  WS02-ERROR-LINE.                                         
               10  WS02-ERROR-DATE           PIC X(19).                 
               10  FILLER                    PIC X(02).                 
               10  WS02-ERROR-DESC           PIC X(25).                 
                   88  WS02-ERROR-CREATE-DT            VALUE            
                       'INPUT FILE NOT CURRENT  '.                      
                   88  WS02-ERROR-ALL-REJECTED         VALUE            
                       'ALL RECORDS REJECTED    '.                      
                   88  WS02-ERROR-MANY-REJECTED        VALUE            
                       '500+ RECORDS REJECTED   '.                      
      *                '100+ RECORDS REJECTED   '.                      06100000
                   88  WS02-ERROR-RECORD-COUNTS        VALUE            
                       'RECORD COUNTS INCORRECT '.                      
               10  FILLER                    PIC X(02).                 
               10  WS02-ERROR-DETAIL         PIC X(84).                 
                                                                        
                                                                        
      *  PCSBW822 REPORT WORK AREA                                      06170000
                                                                        
       01  WS03-WORK-AREA.                                              
           05  WS03-INSERTS.                                            
               10  WS03-INS-NBR-SUCCESS      PIC 9(05).                 
               10  WS03-INS-NBR-REJECT       PIC 9(05).                 
               10  WS03-INS-NBR-PROCESSED    PIC 9(06).                 
               10  WS03-INS-NBR-MISSED-BILL  PIC 9(05).                 
               10  WS03-INS-AMT-SUCCESS      PIC 9(07)V9(02).           
               10  WS03-INS-AMT-REJECT       PIC 9(07)V9(02).           
               10  WS03-INS-AMT-PROCESSED    PIC 9(08)V9(02).           
               10  WS03-INS-AMT-MISSED-BILL  PIC 9(07)V9(02).           
           05  WS03-UPDATES.                                            
               10  WS03-UPD-NBR-SUCCESS      PIC 9(05).                 
               10  WS03-UPD-NBR-REJECT       PIC 9(05).                 
               10  WS03-UPD-NBR-PROCESSED    PIC 9(06).                 
               10  WS03-UPD-NBR-MISSED-BILL  PIC 9(05).                 
               10  WS03-UPD-AMT-SUCCESS      PIC 9(07)V9(02).           
               10  WS03-UPD-AMT-REJECT       PIC 9(07)V9(02).           
               10  WS03-UPD-AMT-PROCESSED    PIC 9(08)V9(02).           
               10  WS03-UPD-AMT-MISSED-BILL  PIC 9(07)V9(02).           
           05  WS03-TERMINATES.                                         
               10  WS03-TRM-NBR-SUCCESS      PIC 9(05).                 
               10  WS03-TRM-NBR-REJECT       PIC 9(05).                 
               10  WS03-TRM-NBR-PROCESSED    PIC 9(06).                 
               10  WS03-TRM-NBR-MISSED-BILL  PIC 9(05).                 
               10  WS03-TRM-AMT-SUCCESS      PIC 9(07)V9(02).           
               10  WS03-TRM-AMT-REJECT       PIC 9(07)V9(02).           
               10  WS03-TRM-AMT-PROCESSED    PIC 9(08)V9(02).           
               10  WS03-TRM-AMT-MISSED-BILL  PIC 9(07)V9(02).           
           05  WS03-TOTALS.                                             
               10  WS03-TOT-NBR-SUCCESS      PIC 9(06).                 
               10  WS03-TOT-NBR-REJECT       PIC 9(06).                 
               10  WS03-TOT-NBR-PROCESSED    PIC 9(07).                 
               10  WS03-TOT-NBR-MISSED-BILL  PIC 9(06).                 
               10  WS03-TOT-AMT-SUCCESS      PIC 9(08)V9(02).           
               10  WS03-TOT-AMT-REJECT       PIC 9(08)V9(02).           
               10  WS03-TOT-AMT-PROCESSED    PIC 9(09)V9(02).           
               10  WS03-TOT-AMT-MISSED-BILL  PIC 9(08)V9(02).           
           05  WS03-SWITCHES.                                           
               10  WS03-ACTION-SUCCESS-IND   PIC X(01).                 
                   88  WS03-ACTION-SUCCESS   VALUE SPACES.              
                   88  WS03-ACTION-FAIL      VALUE 'N'.                 
               10  WS03-ACTION-TYPE          PIC X(01).                 
                   88  WS03-INSERT           VALUE 'I'.                 
                   88  WS03-UPDATE           VALUE 'U'.                 
                   88  WS03-TERMINATE        VALUE 'T'.                 
               10  WS03-BAD-CREATE-DT-IND    PIC X(01).                 
                   88  WS03-BAD-CREATE-DATE  VALUE 'Y'.                 
           05  WS03-ERROR-MSG-HOLD           PIC X(75).                 
           05  WS03-JP-REV-MNTH-TX           PIC X(06).                 
           05  WS03-JP-REV-MNTH-NBR REDEFINES WS03-JP-REV-MNTH-TX.      
               10  WS03-JOB-PARM-REV-MNTH    PIC 9(06).                 
           05  WS03-PREV-PROCESS-CODE        PIC X(01).                 
      *                                                                 06710000
      ***************************************************************** 06720000
      **  COPYBOOK FOR ABEND SWITCH                                  ** 06730000
      ***************************************************************** 06740000
       COPY CWS09900.                                                   06750000
      ***************************************************************** 06760000
      **  COPYBOOK FOR DATE CHECK                                       06770000
      ***************************************************************** 06780000
       COPY FIOJC01.                                                    06790000
      ***************************************************************** 06800000
      **  COPYBOOK FOR ERROR HANDLING                                ** 06810000
      ***************************************************************** 06820000
       COPY CWS00010.                                                   06830000
      ***************************************************************** 06840000
      **  COPYBOOK FOR DB2/SQL ERROR HANDLING                        ** 06850000
      ***************************************************************** 06860000
       COPY CWS00303.                                                   06870000
      ***************************************************************** 06880000
      **  COPYBOOK FOR CPD04822 WORKING STORAGE                      ** 06890000
      ***************************************************************** 06900000
           EXEC SQL                                                     06910000
             INCLUDE CWS0822A                                           06920000
           END-EXEC.                                                    06930000
      ***************************************************************** 06940000
      **  MISCELLANEOUS WORKING STORAGE COPYBOOKS FOR CPD04822       ** 06950000
      ***************************************************************** 06960000
       COPY CJF00101.                                                   06970000
       COPY CJF00102.                                                   06980000
       COPY CJF00105.                                                   06990000
      *                                                                 07010000
       COPY CWS00004.                                                   07020000
       COPY CWS00056.                                                   07040000
       COPY CWSCA225.                                                   07050000
       COPY CWS00038 REPLACING WS-A BY WS-A1, WS-B BY WS-B1,            07060000
                               WS-C BY WS-C1.                           07070000
           EXEC SQL                                                     07080000
             INCLUDE CWS00008                                           07090000
           END-EXEC.                                                    07100000
      *                                                                 07110000
           EXEC SQL                                                     07120000
             INCLUDE CWS00013                                           07130000
           END-EXEC.                                                    07140000
      *                                                                 07150000
           EXEC SQL                                                     07160000
             INCLUDE CWS00017                                           07170000
           END-EXEC.                                                    07180000
      *                                                                 07190000
           EXEC SQL                                                     07200000
             INCLUDE CWS00061                                           07210000
           END-EXEC.                                                    07220000
      *                                                                 07230000
           EXEC SQL                                                     07240000
             INCLUDE CWS00073                                           07250000
           END-EXEC.                                                    07260000
      *                                                                 07270000
           EXEC SQL                                                     07280000
             INCLUDE CWS0070B                                           07290000
           END-EXEC.                                                    07300000
      *                                                                 07310000
      *********************                                             07320000
      *    HOLIDAY CHECK  *                                             07330000
      *********************                                             07340000
           EXEC SQL                                                     07350000
               INCLUDE CWS10016                                         07360000
           END-EXEC.                                                    07370000
      *                                                                 07380000
      ******************************************************************        
      * WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWS00077                                                  
           END-EXEC.                                                            
      *                                                                         
      ****************************                                      07390000
      **       S Q L C A        **                                      07400000
      ****************************                                      07410000
           EXEC SQL                                                     07420000
             INCLUDE SQLCA                                              07430000
           END-EXEC.                                                    07440000
                                                                        
      *****************************************************************         
      * CSS_ACCOUNT        - AT                                       *         
      *****************************************************************         
           EXEC SQL                                                     02220000
              INCLUDE TBACCT                                            02230000
           END-EXEC.                                                    02240000
                                                                        
      *****************************************************************         
      * CSS_CONTRACT       - CT                                       *         
      *****************************************************************         
           EXEC SQL                                                     02340000
              INCLUDE TBCNTRCT                                          02350000
           END-EXEC.                                                    02360000
                                                                        
      *****************************************************************         
      * CSS_CNT_DETAIL     - EA                                       *         
      *****************************************************************         
           EXEC SQL                                                     02380000
              INCLUDE TBCNTDET                                          02390000
           END-EXEC.                                                    02400000
                                                                        
      *****************************************************************         
      * CSS_CONTRACT_INFO  - K6                                       *         
      *****************************************************************         
           EXEC SQL                                                     02380000
              INCLUDE TBCNTINF                                          02390000
           END-EXEC.                                                    02400000
                                                                        
      ******************************************************************04081000
      * CSS_JOB_PARM       - G6                                        *04082000
      ******************************************************************04083000
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************04081000
      * CSS_AR_CNTL        - AC                                        *04082000
      ******************************************************************04083000
           EXEC SQL                                                             
             INCLUDE TBARCNTL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************04081000
      * CSS_PREMISE        - PR                                        *04082000
      ******************************************************************04083000
           EXEC SQL                                                             
             INCLUDE TBPREM                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************04081000
      * CSS_AR_LOCKOUT     - AL                                        *04082000
      ******************************************************************04083000
           EXEC SQL                                                             
             INCLUDE TBARLOCK                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************04081000
      * CSS_COMPANY        - C7                                        *04082000
      ******************************************************************04083000
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
                                                                        
       01  WS-END                      PIC X(40)  VALUE                 
           'WORKING STORAGE FOR PCSBW822 ENDS HERE'.                    
      *                                                                 09910000
                                                                        
      ***************************************************************** 09930000
      *            P R O C E D U R E   D I V I S I O N                * 09940000
      ***************************************************************** 09950000
       PROCEDURE DIVISION.                                              
                                                                        
      ***************************************************************** 09980000
      **                                                             ** 09990000
      **    0000-MAINLINE                                            ** 10000000
      ***************************************************************** 10030000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIATE-PROCESSING          THRU 0100-EXIT.    
                                                                        
           PERFORM 1000-PROCESS-RECORDS              THRU 1000-EXIT     
             UNTIL END-OF-FCSBW822.                                     
                                                                        
           IF END-REC-WAS-PROCESSED                                     
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**     PCSBW822 PROCESSING ERROR      **'       
               DISPLAY '** DID NOT HAVE ENDING CONTROL RECORD **'       
               DISPLAY '**       PROCESSING TERMINATED        **'       
               PERFORM 9900-ABEND                                       
           END-IF.                                                      
                                                                        
           PERFORM 7580-WRITE-FCSPT33-DETAIL         THRU 7580-EXIT.    
                                                                        
           PERFORM 7597-WRITE-END-RECORDS            THRU 7597-EXIT.    
                                                                        
           PERFORM 7598-COUNT-ERRORS                 THRU 7598-EXIT.    
                                                                        
           PERFORM 9000-TERMINATE                    THRU 9000-EXIT.    
                                                                        
           STOP RUN.                                                    
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10330000
      *                                                               * 10340000
      * 0100-INITIATE-PROCESSING.                                     * 10380000
      ***************************************************************** 10390000
       0100-INITIATE-PROCESSING.                                        
                                                                        
           MOVE '0100'              TO ACTIVE-PARAGRAPH.                
                                                                        
      *********************************************************         10440000
      *  CHECK AR LOCKOUT                                     *         10450000
      *********************************************************         10460000
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              DISPLAY ' '                                               
              DISPLAY '**  PCSBW822 PROCESSING ERROR  **'               
              DISPLAY '**  AR LOCKOUT IN EFFECT       **'               
              DISPLAY '**  PROCESSING TERMINATED      **'               
              PERFORM 9900-ABEND           THRU 9900-EXIT               
           END-IF.                                                      
                                                                        
           OPEN INPUT  FCSBW822-FILE.                                   
                                                                        
           IF NOT FBW822-SUCCESSFUL                                     
               DISPLAY '************************************'           
               DISPLAY '**   PCSBW822 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING FCSBW822     **'           
               DISPLAY '**     FILE STATUS =' WS-FBW822-STATUS          
               DISPLAY '************************************'           
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
           PERFORM 6251-GET-FJC01-DATE               THRU 6251-EXIT.    
                                                                        
           IF COMMON-DATE-NEEDED                                        
              MOVE 'COMMON  ' TO WS-PGRMNAME                            
              MOVE SPACES     TO WS-INPUT-AREA                          
              MOVE SPACES     TO WS-INPUT-DATA-BREAKDOWN                
              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT                
              MOVE 'PCSBW822' TO WS-PGRMNAME                            
           END-IF.                                                      
                                                                        
           PERFORM 7595-RETRIEVE-JP-REV-MNTH         THRU 7595-EXIT.    
                                                                        
           MOVE WS-MODEL-STAMP(1:10) TO WS-MODEL-DATE                   
                                        WS-HOLD-DATE-BW.                
                                                                        
           OPEN OUTPUT FCSPT33-FILE.                                    
                                                                        
           MOVE +1 TO WS01-TITLE3-PAGE-NBR.                             
                                                                        
           SET BEGIN-RECS-NOT-PROCESSED TO TRUE.                        
                                                                        
           MOVE WS-YES                  TO WS-MORE-BEGIN-REC.           
                                                                        
           INITIALIZE WS03-WORK-AREA.                                   
                                                                        
           OPEN OUTPUT FCSPT331-FILE.                                   
                                                                        
           IF NOT FCA331-SUCCESSFUL                                     
               DISPLAY '************************************'           
               DISPLAY '**   PCSBW822 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING FCA331       **'           
               DISPLAY '**     FILE STATUS =' WS-FCA331-STATUS          
               DISPLAY '************************************'           
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
           PERFORM 0500-PROCESS-BEGIN-REC            THRU 0500-EXIT.    
                                                                        
           PERFORM 7500-READ-FCSBW822                THRU 7500-EXIT.    
                                                                        
           IF E-FBW822-BEG-REC-KEY EQUAL '0000000000000'                
             DISPLAY '****************************************'         
             DISPLAY '**      PCSBW822 PROCESSING ERROR     **'         
             DISPLAY '**       MULTIPLE HEADER RECORDS      **'         
             DISPLAY '**       PROCESSING TERMINATING       **'         
             DISPLAY '****************************************'         
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
           OPEN OUTPUT FCSR8221-FILE.                                   
                                                                        
           IF NOT FR8221-SUCCESSFUL                                     
               DISPLAY '************************************'           
               DISPLAY '**   PCSBW822 PROCESSING ERROR    **'           
               DISPLAY '**     ERROR OPENING FCSR8221     **'           
               DISPLAY '**     FILE STATUS =' WS-FR8221-STATUS          
               DISPLAY '************************************'           
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
      ***************************************************************   11260000
      **   DELETED ALL REFERENCES FOR 8222 FILE SINCE IT BEING    ***   11270000
      **   TO A WORK QUE                                          ***   11280000
      ***************************************************************   11290000
                                                                        
           INITIALIZE              FIOR8221-BEG-REC.                    
                                                                        
           MOVE 'B'             TO E-FR8221-RECORD-TYPE-BREC.           
                                                                        
           MOVE '0000000000000' TO E-FR8221-BEG-REC-KEY.                
                                                                        
           MOVE WS-INPUT-DATE   TO E-FR8221-CONTRACT-DATE-BREC.         
                                                                        
           PERFORM 7525-WRITE-FCSR8221               THRU 7525-EXIT.    
                                                                        
                                                                        
           IF E-FBW822-END-REC-KEY EQUAL '9999999999999'                
              OR WS03-BAD-CREATE-DATE                                   
                 PERFORM 0600-NO-DATA-TO-PROCESS                        
                    THRU 0600-EXIT                                      
                 PERFORM 9000-TERMINATE                                 
                    THRU 9000-EXIT                                      
                 GO TO 9900-EXIT                                        
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11540000
      **                                                             ** 11550000
      **    0500-PROCESS-BEGIN-REC                                   ** 11560000
      **  THIS PROCESS IS CALLED TO DO AN INITIAL READ OF THE        ** 11570000
      **  FCSBW822 FILES TO SEE IF IT IS EMPTY OR IF THE FIRST       ** 11580000
      **  RECORD IS NOT A CONTROL RECORD                             ** 11590000
      **                                                             ** 11600000
      ***************************************************************** 11610000
       0500-PROCESS-BEGIN-REC.                                          
                                                                        
           PERFORM 7500-READ-FCSBW822                THRU 7500-EXIT.    
                                                                        
           IF END-OF-FCSBW822                                           
             DISPLAY '****************************************'         
             DISPLAY '**    PCSBW822 PROCESSING ERROR       **'         
             DISPLAY '**       NO CONTROL RECORDS           **'         
             DISPLAY '**     ABEND IN PARAGRAPH 0500        **'         
             DISPLAY '**      PROCESSING TERMINATED         **'         
             DISPLAY '****************************************'         
             PERFORM 9900-ABEND                      THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
           IF E-FBW822-BEG-REC-KEY EQUAL '0000000000000'                
              SET BEGIN-RECS-PROCESSED TO TRUE                          
              IF WS-INPUT-DATE NOT EQUAL E-FBW822-CONTRACT-DATE-BREC    
                 SET WS03-BAD-CREATE-DATE TO TRUE                       
                 INITIALIZE WS02-ERROR-LINE                             
                 SET WS02-ERROR-CREATE-DT TO TRUE                       
                 MOVE WS-MODEL-STAMP(1:19) TO WS02-ERROR-DATE           
                 STRING 'CREATE DATE = '            DELIMITED BY SIZE   
                        E-FBW822-CONTRACT-DATE-BREC DELIMITED BY SIZE   
                        '  JOB PARM DATE = '        DELIMITED BY SIZE   
                        WS-INPUT-DATE               DELIMITED BY SIZE   
                   INTO WS02-ERROR-DETAIL                               
                 WRITE PRT331-RECORD FROM WS02-ERROR-LINE               
              END-IF                                                    
           ELSE                                                         
              DISPLAY '**        PCSBW822 PROCESSING ERROR       **'    
              DISPLAY '**  FIRST RECORD IS NOT A CONTROL RECORD  **'    
              DISPLAY '**         PROCESSING TERMINATED          **'    
              PERFORM 9900-ABEND                   THRU 9900-EXIT       
           END-IF.                                                      
                                                                        
       0500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12000000
      *  0600-NO-DATA-TO-PROCESS                                      * 12010000
      *                                                               * 12020000
      *   THIS PARAGRAPH:                                             * 12030000
      *     1) WRITES END RECORDS TO OUTPUT FILES                     * 12040000
      *     2) CREATES REPORT INDICATING NO DATA WAS RECEIVED         * 12050000
      *     3) CHECKS RECORDS COUNTS IF NOT DUE TO BAD CREATE DATE    * 12060000
      *                                                               * 12070000
      ***************************************************************** 12080000
       0600-NO-DATA-TO-PROCESS.                                         
                                                                        
           MOVE '0600'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE '9999999999999'          TO E-FBW822-END-REC-KEY.       
                                                                        
           PERFORM 7597-WRITE-END-RECORDS                               
              THRU 7597-EXIT.                                           
                                                                        
           PERFORM 7575-WRITE-FCSPT33-TITLES                            
              THRU 7575-EXIT.                                           
                                                                        
           WRITE PRT33-RECORD FROM WS02-NO-DATA-LINE                    
                 AFTER ADVANCING 3 LINES.                               
                                                                        
           IF WS03-BAD-CREATE-DATE                                      
              MOVE 01 TO RETURN-CODE                                    
           ELSE                                                         
              PERFORM 2700-CHECK-END-REC                                
                 THRU 2700-EXIT                                         
           END-IF.                                                      
                                                                        
           MOVE 'YES' TO WS-ABEND-SWITCH.                               
                                                                        
       0600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12360000
      **                                                             ** 12370000
      **    1000-PROCESS-RECORDS.                                    ** 12380000
      **  CALLS THE MAIN PROCESSING LOOP AFTER CHECKING FOR THE END  ** 12390000
      **  OF FILE RECORD                                             ** 12400000
      **                                                             ** 12410000
      ***************************************************************** 12420000
       1000-PROCESS-RECORDS.                                            
                                                                        
           IF END-REC-NOT-PROCESSED                                     
              IF E-FBW822-END-REC-KEY EQUAL '9999999999999'             
                 PERFORM 2700-CHECK-END-REC   THRU 2700-EXIT            
              ELSE                                                      
                 PERFORM 2000-PROCESS-SERVICE-CARE-RECS                 
                                              THRU 2000-EXIT            
                 PERFORM 7590-RECORD-RESULTS  THRU 7590-EXIT            
              END-IF                                                    
           ELSE                                                         
              DISPLAY '**      FCSBW822 PROCESSING ERROR      **'       
              DISPLAY '**  RECORD FOUND AFTER CONTROL RECORD  **'       
              DISPLAY '**        PROCESSING TERMINATED        **'       
              PERFORM 9900-ABEND              THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE SPACES TO WS03-ACTION-SUCCESS-IND                       
                          WS03-ERROR-MSG-HOLD.                          
                                                                        
           PERFORM 7500-READ-FCSBW822         THRU 7500-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12710000
      **                                                             ** 12720000
      **    2000-PROCESS-SERVICE-CARE-RECS                           ** 12730000
      **  LOOPING MODULE FOR PCSBW822; PERFORMS UNTIL AN EOF         ** 12740000
      **  CONDITION IS RETURNED BY THE READ STATEMENT; PERFORMS      ** 12750000
      **  INSERTS, UPDATES AND DELETES FOR SERVICE CARE CONTRACTS;   ** 12760000
      **  PROCESSES WORK QUEUES WHEN ERRORS ARE FOUND IN THE ATTEMPT ** 12770000
      **  TO INSERT, UPDATE OR DELETE A CONTRACT                     ** 12780000
      **                                                             ** 12790000
      ***************************************************************** 12800000
       2000-PROCESS-SERVICE-CARE-RECS.                                  
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
      *    INITIALIZE INFO HOST VARIABLES                                       
           INITIALIZE                          DCLCSS-CONTRACT          
                                               DCLCSS-CNT-DETAIL        
                                               DCLCSS-CONTRACT-INFO     
                                               WS-CONTRACT-HEADER-PARMS.
                                                                        
           MOVE ZEROES                      TO AT-PREMISE-NO            
                                               AT-CUSTOMER-NO.          
                                                                        
      *    GETTING THE TODATL RECORD COUNT.                             12920000
           PERFORM 2002-RECORD-ACTION          THRU 2002-EXIT.          
                                                                        
      *    VALIDATION TO CHECK DUPLICATE CONTRACT RECORD.               12950000
           IF E-FBW822-ACCOUNT-NO        EQUAL WS-4822-ACCOUNT-NO       
              AND E-FBW822-ITEM-ID       EQUAL WS-4822-CNT-ITEM-ID      
              AND E-FBW822-PROCESS-CODE  EQUAL WS03-PREV-PROCESS-CODE   
              AND (E-FBW822-PROCESS-CODE EQUAL WS-NEW OR WS-TERMINATE)  
                  MOVE WS-DUP-TRANSACTION   TO WS03-ERROR-MSG-HOLD      
                  SET  WS03-ACTION-FAIL     TO TRUE                     
                  GO TO 2000-EXIT                                       
           END-IF.                                                      
                                                                        
P00851*    VALIDATE TO CHECK-NOT A VALID SERVICE CARE CONTRACT ITEM ID.         
P00851     IF E-FBW822-ITEM-ID    LESS THAN 3500000                     
P00851        OR (E-FBW822-ITEM-ID    GREATER THAN OR EQUAL 5000000     
P00851            AND E-FBW822-PROCESS-CODE EQUAL WS-NEW)               
P00851                MOVE WS-INVALID-ITEM-ID TO WS03-ERROR-MSG-HOLD    
P00851                SET  WS03-ACTION-FAIL   TO TRUE                   
P00851                GO TO 2000-EXIT                                   
P00851     END-IF.                                                      
                                                                        
P00851*    CONTRACT DATE SHOULD NOT BE GREATER THAN CURRENT DATE.       13150000
P00851     IF WS-4822-DATE-CONTRACT > WS-MODEL-DATE                     
P00851        MOVE WS-INVALID-SETUP-DT        TO WS03-ERROR-MSG-HOLD    
P00851        SET  WS03-ACTION-FAIL           TO TRUE                   
P00851        GO TO 2000-EXIT                                           
P00851     END-IF.                                                      
                                                                        
      *    POPULATES HOST AND WORKING-STORAGE VARIABLES TO CREATE CNT.          
           PERFORM 2004-POPULATE-PARMS         THRU 2004-EXIT.          
                                                                        
                                                                        
      *    GETTING ACCOUNT INFORMATION.                                 13210000
           PERFORM 7005-READ-CSS-ACCOUNT      THRU 7005-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              OR AT-CODE-ACCT-STAT NOT EQUAL WS-ACTIVE-ACCOUNT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    MOVE WS-INVALID-ACCOUNT  TO WS03-ERROR-MSG-HOLD     
                 ELSE                                                   
                    MOVE WS-INACTIVE-ACCT    TO WS03-ERROR-MSG-HOLD     
                 END-IF                                                 
                 SET  WS03-ACTION-FAIL       TO TRUE                    
                 GO TO 2000-EXIT                                        
           END-IF.                                                      
                                                                        
      *    IF ACCOUNT WAS TRANSFERRED AND NOT SUB ACCOUNT.                      
           IF AT-AR-XFER-IND EQUAL WS-Y                                 
              AND AT-MST-SUB-ACCT-IND NOT EQUAL 'S'                     
               MOVE WS-TRANSFER-NOT-SUB      TO WS03-ERROR-MSG-HOLD     
               SET  WS03-ACTION-FAIL         TO TRUE                    
               GO TO 2000-EXIT                                          
           END-IF.                                                      
                                                                        
           PERFORM 7205-READ-CSS-CONTRACT-INFO  THRU 7205-EXIT          
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-INVALID-CNT-CODE       TO WS03-ERROR-MSG-HOLD     
              SET  WS03-ACTION-FAIL          TO TRUE                    
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE AT-PREMISE-NO                TO PR-PREMISE-NO.          
                                                                        
           PERFORM 7006-READ-CSS-PREMISE        THRU 7006-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-NO-REV-DISTRICT        TO WS03-ERROR-MSG-HOLD     
              SET  WS03-ACTION-FAIL          TO TRUE                    
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE WS-4822-ACCOUNT-NO           TO WS-ACCOUNT-NO.          
           MOVE WS-ACCOUNT-NO-NUM            TO WS-ACCOUNT-NO-COMP3.    
           MOVE WS-ACCOUNT-NO-COMP3          TO AT-ACCOUNT-NO           
                                                AC-ACCOUNT-NO           
                                                CT-ACCOUNT-NO.          
                                                                        
           PERFORM 7105-READ-CSS-CONTRACT       THRU 7105-EXIT.         
           PERFORM 2006-EVAL-CONTRACT-RETCODE   THRU 2006-EXIT.         
                                                                        
           IF NOT WS03-ACTION-FAIL                                      
              PERFORM 2008-EVAL-CONTRACT-TYPE   THRU 2008-EXIT          
           END-IF.                                                      
                                                                        
           IF WS03-ACTION-FAIL                                          
              GO TO 2000-EXIT                                           
           END-IF.                                                      
                                                                        
           PERFORM 2010-MOVE-PARMS              THRU 2010-EXIT.         
           PERFORM 2012-PROCESS-CONTRACT        THRU 2012-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 14060000
      *                                                               * 14080000
      *  2002-RECORD-ACTION                                           * 14070000
      ***************************************************************** 14130000
       2002-RECORD-ACTION.                                              
                                                                        
           MOVE '2002'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE E-FBW822-PROCESS-CODE         TO WS03-ACTION-TYPE.      
                                                                        
           EVALUATE E-FBW822-PROCESS-CODE                               
               WHEN WS-NEW                                              
                    ADD +1                    TO WS-ADD-COUNT           
                                                 WS03-INS-NBR-PROCESSED 
                    ADD E-FBW822-CONTRACT-AMOUNT                        
                                              TO WS03-INS-AMT-PROCESSED 
               WHEN WS-TERMINATE                                        
                    ADD +1                    TO WS-TERM-COUNT          
                                                 WS03-TRM-NBR-PROCESSED 
                    ADD E-FBW822-CONTRACT-AMOUNT                        
                                              TO WS03-TRM-AMT-PROCESSED 
               WHEN WS-CHANGE                                           
                    ADD +1                    TO WS-UPDATE-COUNT        
                                                 WS03-UPD-NBR-PROCESSED 
                    ADD E-FBW822-CONTRACT-AMOUNT                        
                                              TO WS03-UPD-AMT-PROCESSED 
           END-EVALUATE.                                                
                                                                        
           ADD  +1                       TO WS-TOTAL-COUNT              
                                            WS03-TOT-NBR-PROCESSED.     
                                                                        
           ADD  E-FBW822-CONTRACT-AMOUNT TO WS03-TOT-AMT-PROCESSED.     
                                                                        
       2002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 14460000
      *                                                               * 14480000
      *  2004-POPULATE-PARMS                                          * 14470000
      ***************************************************************** 14520000
       2004-POPULATE-PARMS.                                             
                                                                        
           MOVE '2004'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE ZEROES                       TO AT-PREMISE-NO           
                                                AT-CUSTOMER-NO.         
           MOVE E-FBW822-PROCESS-CODE        TO WS03-PREV-PROCESS-CODE. 
           MOVE E-FBW822-ACCOUNT-NO          TO AT-ACCOUNT-NO           
                                                CT-ACCOUNT-NO           
                                                WS-4822-ACCOUNT-NO.     
           MOVE E-FBW822-CNT-NAME-CD         TO K6-CNT-NAME-CD          
                                                CT-CNT-NAME-CD          
                                                WS-4822-CNT-NAME-CD.    
           MOVE E-FBW822-ITEM-ID             TO CT-CNT-ITEM-ID          
                                                WS-4822-CNT-ITEM-ID.    
           MOVE E-FBW822-CONTRACT-DATE       TO WS-4822-DATE-CONTRACT.  
           MOVE E-FBW822-DATE-PYMT-START     TO WS-4822-DATE-PYMT-START.
           MOVE E-FBW822-AMT-MO-PYMT         TO WS-4822-AMT-MO-PYMT.    
           MOVE E-FBW822-CONTRACT-AMOUNT     TO                         
                                             WS-4822-DTL-CHRG-AMT       
                                             WS-4822-AMT-ORIG-ENTERED.  
           MOVE E-FBW822-NO-SCHED-PYMTS      TO WS-4822-NO-SCHED-PYMTS. 
           MOVE WS-TEST-TRAN-ID              TO WS-PAR-EIBTRNID.        
                                                                        
           IF WS-4822-NO-SCHED-PYMTS EQUAL ZERO                         
                MOVE WS-MNTHLY-CHARGE        TO WS-4822-CODE-BILL-TYPE  
           ELSE                                                         
             IF WS-4822-NO-SCHED-PYMTS EQUAL 1                          
                MOVE WS-ONE-TIME-CHARGE      TO WS-4822-CODE-BILL-TYPE  
             ELSE                                                       
                MOVE WS-INSTLMNT-BILLING     TO WS-4822-CODE-BILL-TYPE  
                MOVE WS-A                    TO WS-4822-CODE-INTRST-METH
             END-IF                                                     
           END-IF.                                                      
                                                                        
       2004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 14910000
      *                                                               * 14930000
      *  2006-EVAL-CONTRACT-RETCODE                                   * 14920000
      ***************************************************************** 14980000
       2006-EVAL-CONTRACT-RETCODE.                                      
                                                                        
           MOVE '2006'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN NOT-FOUND                                           
                                                                        
                    IF E-FBW822-PROCESS-CODE NOT EQUAL WS-NEW           
                       IF E-FBW822-PROCESS-CODE EQUAL WS-CHANGE         
                          MOVE WS-NO-UPDATE    TO WS03-ERROR-MSG-HOLD   
                          SET WS03-ACTION-FAIL TO TRUE                  
                       END-IF                                           
                    END-IF                                              
                                                                        
               WHEN SUCCESSFUL-CALL                                     
                                                                        
                    IF E-FBW822-PROCESS-CODE   EQUAL WS-NEW             
                       MOVE WS-NO-INSERT                                
                         TO WS03-ERROR-MSG-HOLD                         
                       SET  WS03-ACTION-FAIL   TO TRUE                  
                    END-IF                                              
                                                                        
           END-EVALUATE.                                                
                                                                        
       2006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15410000
      *                                                               * 15430000
      *  2008-EVAL-CONTRACT-TYPE                                      * 15420000
      ***************************************************************** 15480000
       2008-EVAL-CONTRACT-TYPE.                                         
                                                                        
           MOVE '2008'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           IF E-FBW822-PROCESS-CODE EQUAL WS-NEW                        
              IF CT-CNT-NAME-CD EQUAL 603 OR 604 OR 607 OR 608          
                            OR 609 OR 610 OR 611 OR 612 OR 613          
                 MOVE WS-NO-HOME-SECURITY    TO WS03-ERROR-MSG-HOLD     
                 SET  WS03-ACTION-FAIL       TO TRUE                    
              END-IF                                                    
              GO TO 2008-EXIT                                           
           END-IF                                                       
                                                                        
           IF WS-160-CODE-BILL-TYPE NOT EQUAL WS-MNTHLY-CHARGE          
              MOVE WS-INVALID-ACTION         TO WS03-ERROR-MSG-HOLD     
              SET  WS03-ACTION-FAIL          TO TRUE                    
              GO TO 2008-EXIT                                           
           END-IF.                                                      
                                                                        
       2008-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15710000
      **                                                             ** 15720000
      **    2010-MOVE-PARMS                                          ** 15730000
      **  CONTRACT VALUES ARE CONVERTED TO WORKING STORAGE PARM      ** 15740000
      **  VARIABLES SO THEY MAY BE PROCESSED BY THE BATCH/ONLINE     ** 15750000
      **  COMMON PROCEDURE DIVISION (CPD04822)                       ** 15760000
      **                                                             ** 15770000
      ***************************************************************** 15780000
       2010-MOVE-PARMS.                                                 
                                                                        
           MOVE '2010'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-PGRMNAME                  TO WS-4822-CNT-APPL-PGM-ID 
           MOVE WS-SERVICE-CARE              TO WS-CNT-APPL-CODE        
           MOVE WS-CNT-APPL-CODE             TO WS-4822-CNT-APPL-CODE   
           MOVE WS-BATCH                     TO WS-4822-PGM-CALLED-FROM 
                                                                        
                                                                        
           IF E-FBW822-PROCESS-CODE EQUAL WS-NEW                        
              PERFORM 3000-FORMAT-SC-CNTRCT     THRU 3000-EXIT          
           ELSE                                                         
              MOVE CT-INTRST-RATE            TO WS-4822-INTRST-RATE     
              MOVE CT-CNT-STATUS-CD          TO WS-4822-CNT-STATUS-CD   
              MOVE WS-SYSTEM-USER-ID         TO WS-4822-USER-ID         
              MOVE WS-160-CODE-BILL-TYPE     TO WS-4822-CODE-BILL-TYPE  
              MOVE CT-CODE-CONTRACT-TYPE     TO                         
                                             WS-4822-CODE-CONTRACT-TYPE 
              MOVE SPACES                    TO WS-4822-LIEN-CD         
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 16100000
      *                                                               * 16120000
      *  2012-PROCESS-CONTRACT                                        * 16110000
      ***************************************************************** 16160000
       2012-PROCESS-CONTRACT.                                           
                                                                        
           MOVE '2012'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-JRNL-SELECT-AND-OR-INS    TO WS-JRNL-OPERATION-RQST. 
           MOVE WS-MODEL-DATE                TO                         
                                             WS-4822-STATUS-CHANGE-DT.  
           EVALUATE E-FBW822-PROCESS-CODE                               
                                                                        
               WHEN WS-CHANGE                                           
                    MOVE WS-U                TO WS-4822-UPDATE-TYPE     
                    MOVE WS-YES              TO WS-UPDATE-CNT-AMT       
                    MOVE CT-REV-DISTRICT-CD  TO WS-4822-REV-DISTRICT-CD 
                    MOVE WS-COMMENTS-TXT-U   TO WS-4822-CNT-COMMENTS-TXT
                                                                        
               WHEN WS-TERMINATE                                        
                    MOVE AT-ACCOUNT-NO       TO AC-ACCOUNT-NO           
                    PERFORM 7004-SELECT-CNT-AR-ROW                      
                                                THRU 7004-EXIT          
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       IF ( WS-160-DATE-PYMT-START > AT-DATE-BILL-DAY-00
                          OR WS-160-DATE-PYMT-START-N = -1 )            
                          AND WS-CPD3-AMT-TRAN-BALANCE = 0              
                          MOVE WS-CANCEL-CNTRCT TO WS-4822-CNT-STATUS-CD
                       ELSE                                             
                          MOVE WS-CLOSE-CNTRCT  TO WS-4822-CNT-STATUS-CD
                       END-IF                                           
                       MOVE WS-NO               TO WS-UPDATE-CNT-AMT    
                       MOVE WS-DELETE           TO WS-4822-UPDATE-TYPE  
                       MOVE WS-COMMENTS-TXT-D   TO                      
                                                WS-4822-CNT-COMMENTS-TXT
                    ELSE                                                
                       GO TO 2012-EXIT                                  
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
           CALL SCSCA822 USING ABEND-FILE                               
                               WS-WARNING-DATA-ELEMENTS                 
                               WS-CONTRACT-HEADER-PARMS                 
                               WS-CONTRACT-DETAIL-PARMS                 
                               WS-CONTRACT-OPERATION-TYPE               
                               WS-CONTRACT-RETURN-INFO.                 
                                                                        
           IF CPD4822-DB2-ERR-FOUND                                     
              DISPLAY '********** PCSBW822 ABORT *********'             
              DISPLAY '**  2012-PROCESS-CONTRACT        **'             
              DISPLAY '*   ERROR ON CALLING SCSCA822     *'             
              DISPLAY 'RETURN CODE      = ' WS-4822-DB2-ERR-RETURN-CD   
              DISPLAY 'APPL RETURN CODE = ' WS-4822-APPL-CNT-RETURN-CD  
              DISPLAY 'ACCOUNT_NO       = ' AT-ACCOUNT-NO               
              DISPLAY 'PGRMNAME         = ' WS-PGRMNAME                 
              DISPLAY 'SCSCA822 - ABEND PARA = ' ACTIVE-PARAGRAPH       
              DISPLAY '*     PROCESSING TERMINATED            *'        
              DISPLAY '********** PCSBW822 ABORT **************'        
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       2012-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 16710000
      **                                                             ** 16720000
      **    2700-CHECK-END-REC                                       ** 16730000
      **    CHECK TRAILER RECORD TO VERIFY INPUT DATA MATCHES        ** 16740000
      **    CONTRACTS ADDED/UPDATED/TERMINATED AND TOTAL NUMBER      ** 16750000
      **    OF CONTRACTS PROCESSED                                   ** 16760000
      **                                                             ** 16770000
      ***************************************************************** 16780000
       2700-CHECK-END-REC.                                              
                                                                        
           IF WS-TOTAL-COUNT     NOT EQUAL E-FBW822-TOTAL-COUNT-EREC    
              OR WS-ADD-COUNT    NOT EQUAL E-FBW822-ADD-COUNT-EREC      
              OR WS-TERM-COUNT   NOT EQUAL E-FBW822-TERM-COUNT-EREC     
              OR WS-UPDATE-COUNT NOT EQUAL E-FBW822-UPDATE-COUNT-EREC   
                 INITIALIZE WS02-ERROR-LINE                             
                 SET WS02-ERROR-RECORD-COUNTS TO TRUE                   
                 MOVE WS-MODEL-STAMP(1:19) TO WS02-ERROR-DATE           
                 STRING 'INS: '                     DELIMITED BY SIZE   
                        WS03-INS-NBR-PROCESSED      DELIMITED BY SIZE   
                        ' / '                       DELIMITED BY SIZE   
                        E-FBW822-ADD-COUNT-EREC     DELIMITED BY SIZE   
                        '  UPD: '                   DELIMITED BY SIZE   
                        WS03-UPD-NBR-PROCESSED      DELIMITED BY SIZE   
                        ' / '                       DELIMITED BY SIZE   
                        E-FBW822-UPDATE-COUNT-EREC  DELIMITED BY SIZE   
                        '  TRM: '                   DELIMITED BY SIZE   
                        WS03-TRM-NBR-PROCESSED      DELIMITED BY SIZE   
                        ' / '                       DELIMITED BY SIZE   
                        E-FBW822-TERM-COUNT-EREC    DELIMITED BY SIZE   
                        '  TOT: '                   DELIMITED BY SIZE   
                        WS03-TOT-NBR-PROCESSED      DELIMITED BY SIZE   
                        ' / '                       DELIMITED BY SIZE   
                        E-FBW822-TOTAL-COUNT-EREC   DELIMITED BY SIZE   
                   INTO WS02-ERROR-DETAIL                               
                 WRITE PRT331-RECORD FROM WS02-ERROR-LINE               
                 MOVE 01 TO RETURN-CODE                                 
           END-IF.                                                      
                                                                        
           MOVE WS-YES               TO WS-END-REC-PROCESSED.           
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 17140000
      **                                                             ** 17150000
      **    3000-FORMAT-SC-CNTRCT                                    ** 17160000
      **  MODULE FOR FORMATTING THE ACTUAL SERVICE CARE CONTRACT     ** 17170000
      **  RECORD BASED ON A COMBINATION OF DEFAULT INFORMATION FROM  ** 17180000
      **  CSS_CONTRACT_INFO AND INFORMATION READ FROM THE INPUT FILE ** 17190000
      **                                                             ** 17200000
      ***************************************************************** 17210000
       3000-FORMAT-SC-CNTRCT.                                           
                                                                        
           MOVE '3000'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *    CONTRACT DETAILS ROWS                                        17250000
           MOVE K6-CHARGE-TYPE-CD        TO WS-4822-DTL-CHRG-TYPE.      
           MOVE K6-GL-ACCT-NO            TO WS-4822-DTL-GL-NO.          
           MOVE E-FBW822-CONTRACT-AMOUNT TO WS-4822-DTL-CHRG-AMT.       
           MOVE K6-WRT-OFF-GL-ACCT-NO    TO WS-4822-DTL-WRT-OFF-GL-NO.  
           MOVE ZEROES                   TO WS-4822-DTL-DISP-FEE        
                                            WS-4822-DTL-INSP-FEE.       
                                                                        
      *    CONTRACT HEADER ROWS                                         17610000
           MOVE WS-I                     TO WS-4822-UPDATE-TYPE.        
           MOVE K6-CODE-CONTRACT-TYPE    TO WS-4822-CODE-CONTRACT-TYPE. 
           MOVE WS-ACTIVE-CONTRACT       TO WS-4822-CNT-STATUS-CD.      
           MOVE K6-DFLT-INTRST-RT        TO WS-4822-INTRST-RATE.        
           MOVE K6-DFLT-REBATE-AMOUNT    TO WS-4822-REBATE-AMOUNT.      
           MOVE K6-REBATE-CD             TO WS-4822-REBATE-CD.          
           MOVE K6-GL-ACCT-NO-DEF-INT    TO WS-4822-GL-ACCT-NO-ERN-INT. 
           MOVE K6-GL-ACCT-NO-ERN-INT    TO WS-4822-GL-ACCT-NO-DEF-INT. 
           MOVE WS-SYSTEM-USER-ID        TO WS-4822-USER-ID.            
           MOVE WS-NO                    TO WS-4822-LIEN-CD.            
           MOVE WS-COMMENTS-TXT-I        TO WS-4822-CNT-COMMENTS-TXT.   
           MOVE SPACES                   TO WS-4822-REV-DISTRICT-CD.    
           MOVE ZEROES                   TO WS-4822-AMT-DOWN-PYMT       
                                            WS-4822-ADD-ON-INTRST       
                                            WS-4822-AMT-TAX-STATE       
                                            WS-4822-AMT-TAX-OTHER.      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 19050000
      **    6251-GET-FJC01-DATE                                      ** 19060000
      **      THIS COPYBOOK, CPD00037, CONTAINS THE DB2 STATEMENTS   ** 19070000
      **      NECESSARY TO RETRIEVE PARAMETERS FROM TABLE CSS_JOB_   ** 19080000
      **      PARM.                                                  ** 19090000
      ***************************************************************** 19100000
           EXEC SQL                                                     19110000
             INCLUDE CPD00037                                           19120000
           END-EXEC.                                                    19130000
                                                                        
      ***************************************************************** 19410000
      **                                                             ** 19420000
      ** 7004-SELECT-CNT-AR-ROW                                      ** 19430000
      **                                                             ** 19460000
      ***************************************************************** 19470000
       7004-SELECT-CNT-AR-ROW.                                          
                                                                        
           EXEC SQL                                                     
                SELECT AMT_AR_DAY_00                                    
                     , AMT_AR_DAY_30                                    
                     , AMT_AR_DAY_60                                    
                     , AMT_AR_DAY_90                                    
                     , AMT_UNUSED_CR                                    
                     , AMT_TRAN_BALANCE                                 
                 INTO  :WS-CPD3-AMT-AR-DAY-00                           
                     , :WS-CPD3-AMT-AR-DAY-30                           
                     , :WS-CPD3-AMT-AR-DAY-60                           
                     , :WS-CPD3-AMT-AR-DAY-90                           
                     , :WS-CPD3-AMT-UNUSED-CR                           
                     , :WS-CPD3-AMT-TRAN-BALANCE                        
               FROM CSS_AR_CNTL                                         
              WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO                 
                AND PYMT_PRIORITY_LVL  = 100                            
                AND ITEM_ID            = :CT-CNT-ITEM-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**   PCSBW822 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 7004    **'             
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**   ACCOUNT_NO = ' AC-ACCOUNT-NO                
              DISPLAY '**   ITEM_ID    = ' CT-CNT-ITEM-ID               
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 19410000
      **                                                             ** 19420000
      **    7005-READ-CSS-ACCOUNT                                    ** 19430000
      **  SELECTS ACCOUNT INFORMATION FOR THE ACCOUNT PASSED BY THE  ** 19440000
      **  INPUT FILE                                                 ** 19450000
      **                                                             ** 19460000
      ***************************************************************** 19470000
       7005-READ-CSS-ACCOUNT.                                           
                                                                        
           MOVE '7005'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             SELECT    CODE_ACCT_STAT,                                  
                       COMPANY_NO,                                      
                       CUSTOMER_NO,                                     
                       PREMISE_NO,                                      
                       DATE_BILL_DAY_00,                                
                       REV_MTH_LST_NRML,                                
                       BILL_CYCLE,                                      
                       IVR_EXEMPT_CD,                                   
                       AR_XFER_IND,                                     
                       MST_SUB_ACCT_IND                                 
             INTO      :AT-CODE-ACCT-STAT,                              
                       :AT-COMPANY-NO,                                  
                       :AT-CUSTOMER-NO,                                 
                       :AT-PREMISE-NO,                                  
                       :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,   
                       :AT-REV-MTH-LST-NRML,                            
                       :AT-BILL-CYCLE,                                  
                       :AT-IVR-EXEMPT-CD,                               
                       :AT-AR-XFER-IND,                                 
                       :AT-MST-SUB-ACCT-IND                             
             FROM      CSS_ACCOUNT                                      
             WHERE     ACCOUNT_NO      = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               IF WS-DATE-BILL-DAY-00-NULL < ZERO                       
                   MOVE LOW-VALUES  TO AT-DATE-BILL-DAY-00              
               END-IF                                                   
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                 
                   CONTINUE                                             
               ELSE                                                     
                   DISPLAY '***********************************'        
                   DISPLAY '**   PCSBW822 PROCESSING ERROR   **'        
                   DISPLAY '**    ABEND IN PARAGRAPH 7005    **'        
                   DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE   
                   DISPLAY '**      ACCOUNT = ' AT-ACCOUNT-NO           
                   DISPLAY '**     PROCESSING TERMINATED     **'        
                   DISPLAY '***********************************'        
                   PERFORM 9900-ABEND                THRU 9900-EXIT     
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 19960000
      **                                                             ** 19970000
      ** 7006-READ-CSS-PREMISE.                                      ** 19980000
      ***************************************************************** 20020000
       7006-READ-CSS-PREMISE.                                           
                                                                        
           MOVE '7006'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             SELECT    REV_DISTRICT_CD,                                 
                       PREMISE_NO                                       
             INTO      :PR-REV-DISTRICT-CD,                             
                       :PR-PREMISE-NO                                   
             FROM      CSS_PREMISE                                      
             WHERE     PREMISE_NO      = :PR-PREMISE-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**   PCSBW822 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 7006    **'             
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**      ACCOUNT = ' PR-PREMISE-NO                
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 20330000
      **                                                             ** 20340000
      ** 7105-READ-CSS-CONTRACT                                      ** 20350000
      ***************************************************************** 20390000
       7105-READ-CSS-CONTRACT.                                          
                                                                        
           MOVE '7105'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
             SELECT    PYMT_PRIORITY_LVL,                               
                       AMT_ORIG_ENTERED,                                
                       AMT_MO_PYMT,                                     
                       INTRST_RATE,                                     
                       CNT_STATUS_CD,                                   
                       CNT_NAME_CD,                                     
                       CONTRACT_COMMENTS,                               
                       REV_DISTRICT_CD,                                 
                       DATE_PYMT_START,                                 
                       CODE_BILL_TYPE                                   
             INTO      :CT-PYMT-PRIORITY-LVL,                           
                       :CT-AMT-ORIG-ENTERED,                            
                       :CT-AMT-MO-PYMT,                                 
                       :CT-INTRST-RATE,                                 
                       :CT-CNT-STATUS-CD,                               
                       :CT-CNT-NAME-CD,                                 
                       :CT-CONTRACT-COMMENTS,                           
                       :CT-REV-DISTRICT-CD,                             
                       :WS-160-DATE-PYMT-START 
                       :WS-160-DATE-PYMT-START-N,
                       :WS-160-CODE-BILL-TYPE                           
             FROM      CSS_CONTRACT                                     
             WHERE     ACCOUNT_NO          = :CT-ACCOUNT-NO             
               AND     CNT_ITEM_ID         = :CT-CNT-ITEM-ID            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '***********************************'            
               DISPLAY '**   PCSBW822 PROCESSING ERROR   **'            
               DISPLAY '**    ABEND IN PARAGRAPH 7105    **'            
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**      ACCOUNT = ' CT-ACCOUNT-NO               
               DISPLAY '**      CNT ITEM ID = ' CT-CNT-ITEM-ID          
               DISPLAY '**     PROCESSING TERMINATED     **'            
               DISPLAY '***********************************'            
               PERFORM 9900-ABEND                    THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 20950000
      **                                                             ** 20960000
      ** 7205-READ-CSS-CONTRACT-INFO                                 ** 20970000
      ***************************************************************** 21010000
       7205-READ-CSS-CONTRACT-INFO.                                     
                                                                        
           MOVE '7205'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              SELECT CNT_NAME_CD,                                       
                     CHARGE_TYPE_CD,                                    
                     CNT_NAME_DESC,                                     
                     REBATE_CD,                                         
                     INTEREST_CD,                                       
                     DFLT_CHARGE_AM,                                    
                     COST_CENTER,                                       
                     GL_ACCT_NO,                                        
                     CODE_CONTRACT_TYPE,                                
                     MIN_TERM_MO_NM,                                    
                     MAX_TERM_MO_NM,                                    
                     DFLT_TERM_MO_NM,                                   
                     MIN_INTRST_RT,                                     
                     MAX_INTRST_RT,                                     
                     DFLT_INTRST_RT,                                    
                     CODE_BILL_TYPE,                                    
                     DFLT_REBATE_AMOUNT,                                
                     COMPANY_NO,                                        
                     GL_ACCT_NO_OFFSET,                                 
                     GL_ACCT_NO_ERN_INT,                                
                     GL_ACCT_NO_DEF_INT,                                
                     WRT_OFF_GL_ACCT_NO                                 
             INTO    :K6-CNT-NAME-CD,                                   
                     :K6-CHARGE-TYPE-CD,                                
                     :K6-CNT-NAME-DESC,                                 
                     :K6-REBATE-CD,                                     
                     :K6-INTEREST-CD,                                   
                     :K6-DFLT-CHARGE-AM,                                
                     :K6-COST-CENTER,                                   
                     :K6-GL-ACCT-NO,                                    
                     :K6-CODE-CONTRACT-TYPE,                            
                     :K6-MIN-TERM-MO-NM,                                
                     :K6-MAX-TERM-MO-NM,                                
                     :K6-DFLT-TERM-MO-NM,                               
                     :K6-MIN-INTRST-RT,                                 
                     :K6-MAX-INTRST-RT,                                 
                     :K6-DFLT-INTRST-RT,                                
                     :K6-CODE-BILL-TYPE,                                
                     :K6-DFLT-REBATE-AMOUNT,                            
                     :K6-COMPANY-NO,                                    
                     :K6-GL-ACCT-NO-OFFSET,                             
                     :K6-GL-ACCT-NO-ERN-INT,                            
                     :K6-GL-ACCT-NO-DEF-INT,                            
                     :K6-WRT-OFF-GL-ACCT-NO                             
             FROM    CSS_CONTRACT_INFO                                  
             WHERE   CNT_NAME_CD         = :K6-CNT-NAME-CD              
               AND   COMPANY_NO          = :AT-COMPANY-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY '***********************************'             
              DISPLAY '**   PCSBW822 PROCESSING ERROR   **'             
              DISPLAY '**    ABEND IN PARAGRAPH 7205    **'             
              DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE        
              DISPLAY '**   CNT NAME CD= ' K6-CNT-NAME-CD               
              DISPLAY '**   COMPANY NO = ' AT-COMPANY-NO                
              DISPLAY '**     PROCESSING TERMINATED     **'             
              DISPLAY '***********************************'             
              PERFORM 9900-ABEND                THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 22420000
      **                                                             ** 22430000
      ** 7500-READ-FCSBW822                                          ** 22440000
      ***************************************************************** 22470000
       7500-READ-FCSBW822.                                              
                                                                        
           MOVE '7500'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           READ FCSBW822-FILE  AT END                                   
             MOVE WS-YES                     TO WS-END-OF-FCSBW822.     
                                                                        
           IF FBW822-SUCCESSFUL OR END-OF-FCSBW822                      
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**************************************'         
               DISPLAY '**     PCSBW822 PROCESSING ERROR    **'         
               DISPLAY '**       ERROR READING FCSBW822     **'         
               DISPLAY '**      FILE STATUS = ' WS-FBW822-STATUS        
               DISPLAY '**       PROCESSING TERMINATED      **'         
               DISPLAY '**************************************'         
               PERFORM 9900-ABEND               THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 22700000
      *                                                               * 22720000
      * 7525-WRITE-FCSR8221                                           * 22710000
      ***************************************************************** 22760000
       7525-WRITE-FCSR8221.                                             
                                                                        
           MOVE '7525'              TO ACTIVE-PARAGRAPH.                
                                                                        
           WRITE FIOR8221-RECORD.                                       
                                                                        
       7525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 23020000
      *                                                               * 23040000
      * 7575-WRITE-FCSPT33-TITLES                                     * 23030000
      ***************************************************************** 23080000
       7575-WRITE-FCSPT33-TITLES.                                       
                                                                        
           MOVE '7575'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE 'PCSB8221'                   TO WS01-TITLE1-PROGNAME.   
                                                                        
           PERFORM 7577-RETRIEVE-COMP-NAME      THRU 7577-EXIT          
           PERFORM 7578-FORMAT-DATE-TIME        THRU 7578-EXIT          
                                                                        
           WRITE PRT33-RECORD FROM WS01-TITLE1                          
                 AFTER ADVANCING PAGE.                                  
                                                                        
           WRITE PRT33-RECORD FROM WS01-TITLE2                          
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS01-TITLE3                          
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS01-TITLE4                          
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-BLANK-LINE                      
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS01-HEADER1                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS01-HEADER2                         
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-BLANK-LINE                      
                 AFTER ADVANCING 1 LINE.                                
                                                                        
       7575-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 23480000
      *                                                               * 23500000
      * 7577-RETRIEVE-COMP-NAME                                       * 23490000
      ***************************************************************** 23550000
       7577-RETRIEVE-COMP-NAME.                                         
                                                                        
           MOVE '7577'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           EXEC SQL                                                     
                SELECT COMPANY_NAME                                     
                  INTO :C7-COMPANY-NAME                                 
                  FROM CSS_COMPANY                                      
                 WHERE COMPANY_NO = :WS-COMPANY-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              MOVE C7-COMPANY-NAME TO WS01-TITLE1-COMP-NAME             
           ELSE                                                         
                DISPLAY '***********************************'           
                DISPLAY '**   PCSBW822 PROCESSING ERROR   **'           
                DISPLAY '**    ABEND IN PARAGRAPH 7577    **'           
                DISPLAY '**  UNABLE TO RETRIEVE COMP NAME **'           
                DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE      
                DISPLAY '**     PROCESSING TERMINATED     **'           
                DISPLAY '***********************************'           
                PERFORM 9900-ABEND                    THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7577-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 23850000
      *                                                               * 23870000
      * 7578-FORMAT-DATE-TIME                                         * 23860000
      ***************************************************************** 23910000
       7578-FORMAT-DATE-TIME.                                           
                                                                        
           MOVE '7578'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           STRING WS-MODEL-STAMP(6:2)           DELIMITED BY SIZE       
                  '/'                           DELIMITED BY SIZE       
                  WS-MODEL-STAMP(9:2)           DELIMITED BY SIZE       
                  '/'                           DELIMITED BY SIZE       
                  WS-MODEL-STAMP(1:4)           DELIMITED BY SIZE       
             INTO WS01-TITLE1-RUN-DT.                                   
                                                                        
           STRING WS-MODEL-STAMP(12:2)          DELIMITED BY SIZE       
                  ':'                           DELIMITED BY SIZE       
                  WS-MODEL-STAMP(15:2)          DELIMITED BY SIZE       
                  ':'                           DELIMITED BY SIZE       
                  WS-MODEL-STAMP(18:2)          DELIMITED BY SIZE       
             INTO WS01-TITLE2-RUN-TM.                                   
                                                                        
           STRING WS-INPUT-DATE(6:2)            DELIMITED BY SIZE       
                  '/'                           DELIMITED BY SIZE       
                  WS-INPUT-DATE(9:2)            DELIMITED BY SIZE       
                  '/'                           DELIMITED BY SIZE       
                  WS-INPUT-DATE(1:4)            DELIMITED BY SIZE       
             INTO WS01-TITLE4-RPT-DATE.                                 
                                                                        
       7578-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 24200000
      *                                                               * 24220000
      * 7580-WRITE-FCSPT33-DETAIL                                     * 24210000
      ***************************************************************** 24260000
       7580-WRITE-FCSPT33-DETAIL.                                       
                                                                        
           MOVE '7580'     TO ACTIVE-PARAGRAPH.                         
                                                                        
           PERFORM 7575-WRITE-FCSPT33-TITLES THRU 7575-EXIT.            
           PERFORM 7585-MOVE-INSERTS         THRU 7585-EXIT.            
                                                                        
           WRITE PRT33-RECORD FROM WS02-DETAIL-LINE                     
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-BLANK-LINE                      
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           PERFORM 7586-MOVE-UPDATES                                    
              THRU 7586-EXIT.                                           
                                                                        
           WRITE PRT33-RECORD FROM WS02-DETAIL-LINE                     
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-BLANK-LINE                      
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           PERFORM 7587-MOVE-TERMINATES                                 
              THRU 7587-EXIT.                                           
                                                                        
           WRITE PRT33-RECORD FROM WS02-DETAIL-LINE                     
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-BLANK-LINE                      
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-TOTAL-LINE                      
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-BLANK-LINE                      
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           PERFORM 7588-MOVE-TOTALS                                     
              THRU 7588-EXIT.                                           
                                                                        
           WRITE PRT33-RECORD FROM WS02-DETAIL-LINE                     
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-BLANK-LINE                      
                 AFTER ADVANCING 1 LINE.                                
                                                                        
           WRITE PRT33-RECORD FROM WS02-END-DATA-LINE                   
                 AFTER ADVANCING 3 LINES.                               
                                                                        
       7580-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 24820000
      *                                                               * 24840000
      * 7585-MOVE-INSERTS                                             * 24830000
      ***************************************************************** 24890000
       7585-MOVE-INSERTS.                                               
                                                                        
           MOVE '7585'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           INITIALIZE WS02-DETAIL-LINE.                                 
                                                                        
           MOVE WS-INSERT-TX             TO WS02-ACTION.                
           MOVE WS03-INS-NBR-SUCCESS     TO WS02-NBR-SUCCESS.           
           MOVE WS03-INS-NBR-REJECT      TO WS02-NBR-REJECT.            
           MOVE WS03-INS-NBR-PROCESSED   TO WS02-NBR-PROCESSED.         
           MOVE WS03-INS-NBR-MISSED-BILL TO WS02-NBR-MISSED-BILL.       
           MOVE WS03-INS-AMT-SUCCESS     TO WS02-AMT-SUCCESS.           
           MOVE WS03-INS-AMT-REJECT      TO WS02-AMT-REJECT.            
           MOVE WS03-INS-AMT-PROCESSED   TO WS02-AMT-PROCESSED.         
           MOVE WS03-INS-AMT-MISSED-BILL TO WS02-AMT-MISSED-BILL.       
                                                                        
       7585-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 25090000
      *                                                               * 25110000
      * 7586-MOVE-UPDATES                                             * 25100000
      ***************************************************************** 25160000
       7586-MOVE-UPDATES.                                               
                                                                        
           MOVE '7586'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           INITIALIZE WS02-DETAIL-LINE.                                 
                                                                        
           MOVE WS-UPDATE-TX             TO WS02-ACTION.                
           MOVE WS03-UPD-NBR-SUCCESS     TO WS02-NBR-SUCCESS.           
           MOVE WS03-UPD-NBR-REJECT      TO WS02-NBR-REJECT.            
           MOVE WS03-UPD-NBR-PROCESSED   TO WS02-NBR-PROCESSED.         
           MOVE WS03-UPD-NBR-MISSED-BILL TO WS02-NBR-MISSED-BILL.       
           MOVE WS03-UPD-AMT-SUCCESS     TO WS02-AMT-SUCCESS.           
           MOVE WS03-UPD-AMT-REJECT      TO WS02-AMT-REJECT.            
           MOVE WS03-UPD-AMT-PROCESSED   TO WS02-AMT-PROCESSED.         
           MOVE WS03-UPD-AMT-MISSED-BILL TO WS02-AMT-MISSED-BILL.       
                                                                        
       7586-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 25360000
      *                                                               * 25380000
      * 7587-MOVE-TERMINATES.                                         * 25370000
      ***************************************************************** 25430000
       7587-MOVE-TERMINATES.                                            
                                                                        
           MOVE '7587'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           INITIALIZE WS02-DETAIL-LINE.                                 
                                                                        
           MOVE WS-TERMINATE-TX          TO WS02-ACTION.                
           MOVE WS03-TRM-NBR-SUCCESS     TO WS02-NBR-SUCCESS.           
           MOVE WS03-TRM-NBR-REJECT      TO WS02-NBR-REJECT.            
           MOVE WS03-TRM-NBR-PROCESSED   TO WS02-NBR-PROCESSED.         
           MOVE WS03-TRM-NBR-MISSED-BILL TO WS02-NBR-MISSED-BILL.       
           MOVE WS03-TRM-AMT-SUCCESS     TO WS02-AMT-SUCCESS.           
           MOVE WS03-TRM-AMT-REJECT      TO WS02-AMT-REJECT.            
           MOVE WS03-TRM-AMT-PROCESSED   TO WS02-AMT-PROCESSED.         
           MOVE WS03-TRM-AMT-MISSED-BILL TO WS02-AMT-MISSED-BILL.       
                                                                        
       7587-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 25630000
      *                                                               * 25650000
      * 7588-MOVE-TOTALS                                              * 25640000
      ***************************************************************** 25700000
       7588-MOVE-TOTALS.                                                
                                                                        
           MOVE '7588'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           INITIALIZE WS02-DETAIL-LINE.                                 
                                                                        
           MOVE WS-TOTAL-TX              TO WS02-ACTION.                
           MOVE WS03-TOT-NBR-SUCCESS     TO WS02-NBR-SUCCESS.           
           MOVE WS03-TOT-NBR-REJECT      TO WS02-NBR-REJECT.            
           MOVE WS03-TOT-NBR-PROCESSED   TO WS02-NBR-PROCESSED.         
           MOVE WS03-TOT-NBR-MISSED-BILL TO WS02-NBR-MISSED-BILL.       
           MOVE WS03-TOT-AMT-SUCCESS     TO WS02-AMT-SUCCESS.           
           MOVE WS03-TOT-AMT-REJECT      TO WS02-AMT-REJECT.            
           MOVE WS03-TOT-AMT-PROCESSED   TO WS02-AMT-PROCESSED.         
           MOVE WS03-TOT-AMT-MISSED-BILL TO WS02-AMT-MISSED-BILL.       
                                                                        
       7588-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 25900000
      *  7590-RECORD-RESULTS                                          * 25910000
      *                                                               * 25920000
      *   THIS PARAGRAPH:                                             * 25930000
      *     1) DETERMINES IF PROCESSING WAS SUCCESSFUL OR NOT         * 25940000
      *        A) IF PROCESS WAS SUCCESSFUL:                          * 25950000
      *           -POPULATE DETAIL REPORT SUCCESS FIELDS              * 25960000
      *           -DETERMINES IF THE ACCOUNT HAS ALREADY BILLED       * 25970000
      *              FOR THE CURRENT MONTH                            * 25980000
      *              -IF SO, POPULATE DETAIL REPORT MISSED            * 25990000
      *                  BILL FIELDS                                  * 26000000
      *        B) IF PROCESS FAILED:                                  * 26010000
      *           -POPULATE EXCEPTION REPORT FIELDS                   * 26020000
      *     2) MOVES NUMBERS AND AMOUNTS FOR SUMMARY REPORT INFO      * 26030000
      *        INTO WORKING-STORAGE FIELDS.                           * 26040000
      *                                                               * 26050000
      ***************************************************************** 26060000
       7590-RECORD-RESULTS.                                             
                                                                        
           MOVE '7590'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EVALUATE TRUE                                                
                                                                        
               WHEN WS03-ACTION-SUCCESS                                 
                    INITIALIZE FIOR8221-RECORD                          
                    MOVE 'D'                  TO E-FR8221-RECORD-TYPE   
                    MOVE WS03-ACTION-TYPE     TO E-FR8221-ACTION-TYPE   
                    MOVE E-FBW822-ACCOUNT-NO  TO E-FR8221-ACCOUNT-NO    
                    MOVE AT-CUSTOMER-NO       TO E-FR8221-CUSTOMER-NO   
                    MOVE E-FBW822-ITEM-ID     TO E-FR8221-CNT-ITEM-ID   
                    MOVE E-FBW822-CNT-NAME-CD TO E-FR8221-CNT-NAME-CD   
                    MOVE E-FBW822-CONTRACT-AMOUNT                       
                      TO E-FR8221-CONTRACT-AMOUNT                       
                    MOVE E-FBW822-CONTRACT-DATE                         
                      TO E-FR8221-CONTRACT-DATE                         
                    MOVE AT-BILL-CYCLE        TO E-FR8221-BILL-CYCLE    
                    MOVE AT-DATE-BILL-DAY-00  TO E-FR8221-LAST-BILL-DATE
                    MOVE AT-REV-MTH-LST-NRML                            
                      TO E-FR8221-LAST-BILL-MONTH                       
                    ADD  +1                   TO WS03-TOT-NBR-SUCCESS   
                    ADD  E-FBW822-CONTRACT-AMOUNT                       
                     TO  WS03-TOT-AMT-SUCCESS                           
                    IF AT-REV-MTH-LST-NRML EQUAL WS03-JOB-PARM-REV-MNTH 
                       MOVE 'Y' TO E-FR8221-MISSED-CURR-BILL-IND        
                       ADD  +1  TO WS03-TOT-NBR-MISSED-BILL             
                       ADD  E-FBW822-CONTRACT-AMOUNT                    
                        TO  WS03-TOT-AMT-MISSED-BILL                    
                    END-IF                                              
                    IF WS03-INSERT                                      
                       ADD +1 TO WS03-INS-NBR-SUCCESS                   
                       ADD E-FBW822-CONTRACT-AMOUNT                     
                        TO WS03-INS-AMT-SUCCESS                         
                       IF E-FR8221-MISSED-CURR-BILL-IND EQUAL 'Y'       
                          ADD +1 TO WS03-INS-NBR-MISSED-BILL            
                          ADD E-FBW822-CONTRACT-AMOUNT                  
                           TO WS03-INS-AMT-MISSED-BILL                  
                       END-IF                                           
                    ELSE                                                
                      IF WS03-UPDATE                                    
                         ADD +1 TO WS03-UPD-NBR-SUCCESS                 
                         ADD E-FBW822-CONTRACT-AMOUNT                   
                          TO WS03-UPD-AMT-SUCCESS                       
                         IF E-FR8221-MISSED-CURR-BILL-IND EQUAL 'Y'     
                            ADD +1 TO WS03-UPD-NBR-MISSED-BILL          
                            ADD E-FBW822-CONTRACT-AMOUNT                
                             TO WS03-UPD-AMT-MISSED-BILL                
                         END-IF                                         
                      ELSE                                              
                         ADD +1 TO WS03-TRM-NBR-SUCCESS                 
                         ADD E-FBW822-CONTRACT-AMOUNT                   
                          TO WS03-TRM-AMT-SUCCESS                       
                         IF E-FR8221-MISSED-CURR-BILL-IND EQUAL 'Y'     
                            ADD +1 TO WS03-TRM-NBR-MISSED-BILL          
                            ADD E-FBW822-CONTRACT-AMOUNT                
                             TO WS03-TRM-AMT-MISSED-BILL                
                         END-IF                                         
                      END-IF                                            
                    END-IF                                              
                    PERFORM 7525-WRITE-FCSR8221 THRU 7525-EXIT          
                                                                        
               WHEN WS03-ACTION-FAIL                                    
      ***************************************************************   26710000
      *** REPLACING WRITING ERRORS TO 8222 RECORD WITH A WORK QUE ***   26720000
      ***************************************************************   26730000
                    MOVE WS-INPUT-DATE        TO WS-INPUT-DATE-TS       
                    MOVE WS-INPUT-TS          TO WS-77-DATE-REQUIRED    
                    MOVE ZEROES               TO WS-77-SERV-ORDER-NO    
                    MOVE E-FBW822-ACCOUNT-NO  TO WS-77-ACCOUNT-NO       
                                                 WS-INVALID-ACCT-NBR    
                    MOVE AT-PREMISE-NO        TO WS-77-PREMISE-NO       
                    MOVE AT-CUSTOMER-NO       TO WS-77-CUSTOMER-NO      
                    MOVE E-FBW822-ITEM-ID     TO WS-CONTRACT-ITEM-ID    
                    MOVE E-FBW822-CONTRACT-AMOUNT                       
                                              TO WS-CONTRACT-AMOUNT-N   
                    MOVE WS-CONTRACT-AMOUNT-N TO WS-CONTRACT-AMOUNT-C   
                    MOVE WS-NORMAL            TO WS-77-PRIORITY         
                    MOVE AT-LOCAL-OFFICE      TO WS-77-LOCAL-OFFICE     
                    MOVE E-FBW822-RESP-AREA   TO WS-77-RESP-AREA-ID     
                    MOVE +81                  TO WS-77-CATEGORY-ID      
                    MOVE +4                   TO WS-77-ROUTE-CATEGORY   
                    MOVE LOW-VALUES           TO WS-77-FREE-FORM-TXT    
                    MOVE ZEROS                TO WS-77-FREE-FORM-LEN    
                    STRING 'CONTRACT ITEM ID = ' WS-CONTRACT-ITEM-ID    
                     ' ' 'CONTRACT AMOUNT = ' WS-CONTRACT-AMOUNT-C      
                     ' ' WS03-ERROR-MSG-HOLD                            
                       DELIMITED BY SIZE INTO WS-77-COMMENTS-TEXT       
                       MOVE LENGTH OF WS-77-COMMENTS-TEXT               
                                              TO WS-77-COMMENTS-LEN     
                    MOVE WS-PGRMNAME          TO WS-77-CREATED-BY       
                    PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT       
                    ADD  +1                   TO WS03-TOT-NBR-REJECT    
                    ADD  E-FBW822-CONTRACT-AMOUNT                       
                     TO  WS03-TOT-AMT-REJECT                            
                    IF WS03-INSERT                                      
                       ADD +1 TO WS03-INS-NBR-REJECT                    
                       ADD E-FBW822-CONTRACT-AMOUNT                     
                        TO WS03-INS-AMT-REJECT                          
                    ELSE                                                
                      IF WS03-UPDATE                                    
                         ADD +1 TO WS03-UPD-NBR-REJECT                  
                         ADD E-FBW822-CONTRACT-AMOUNT                   
                          TO WS03-UPD-AMT-REJECT                        
                      ELSE                                              
                         ADD +1 TO WS03-TRM-NBR-REJECT                  
                         ADD E-FBW822-CONTRACT-AMOUNT                   
                          TO WS03-TRM-AMT-REJECT                        
                      END-IF                                            
                    END-IF                                              
                                                                        
           END-EVALUATE.                                                
                                                                        
       7590-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 27230000
      *                                                               * 27250000
      *  7595-RETRIEVE-JP-REV-MNTH                                    * 27240000
      ***************************************************************** 27290000
       7595-RETRIEVE-JP-REV-MNTH.                                       
                                                                        
           MOVE '7595'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
                SELECT PARM_DATA,                                       
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                  INTO :G6-PARM-DATA,                                   
                       :WS-MODEL-STAMP                                  
                  FROM CSS_JOB_PARM                                     
                 WHERE PROGRAM_NAME = 'COMMON'                          
                   AND CMND_CODE    = 'DATE'                            
                   AND COMPANY_NO   = '01'                              
                   AND SEQ_NO       = 20                                
                   AND STATUS       = 'A'                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     27340000
MFA-TR*         SELECT PARM_DATA,                                       27350000
MFA-TR*                CURRENT TIMESTAMP                                27360000
MFA-TR*           INTO :G6-PARM-DATA,                                   27370000
MFA-TR*                :WS-MODEL-STAMP                                  27380000
MFA-TR*           FROM CSS_JOB_PARM                                     27390000
MFA-TR*          WHERE PROGRAM_NAME = 'COMMON'                          27400000
MFA-TR*            AND CMND_CODE    = 'DATE'                            27410000
MFA-TR*            AND COMPANY_NO   = '01'                              27420000
MFA-TR*            AND SEQ_NO       = 20                                27430000
MFA-TR*            AND STATUS       = 'A'                               27440000
MFA-TR*    END-EXEC.                                                    27450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL              
              AND G6-PARM-DATA(1:14) EQUAL 'REVENUE-MONTH='             
                MOVE G6-PARM-DATA(15:6) TO WS03-JP-REV-MNTH-TX          
           ELSE                                                         
                DISPLAY '***********************************'           
                DISPLAY '**   PCSBW822 PROCESSING ERROR   **'           
                DISPLAY '**    ABEND IN PARAGRAPH 7595    **'           
                DISPLAY '**  UNABLE TO RETRIEVE REV MONTH **'           
                DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE      
                DISPLAY '**     PROCESSING TERMINATED     **'           
                DISPLAY '***********************************'           
                PERFORM 9900-ABEND                    THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7595-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 27660000
      *                                                               * 27680000
      *  7597-WRITE-END-RECORDS                                       * 27670000
      ***************************************************************** 27730000
       7597-WRITE-END-RECORDS.                                          
                                                                        
           MOVE '7597'                   TO ACTIVE-PARAGRAPH.           
      ***************************************************************** 27770000
      ***  DELETED ALL REFERENCES TO 8222 FILE                      *** 27780000
      ***************************************************************** 27790000
                                                                        
           INITIALIZE FIOR8221-RECORD.                                  
                                                                        
           MOVE 'E'                  TO E-FR8221-RECORD-TYPE-EREC.      
                                                                        
           MOVE E-FBW822-END-REC-KEY TO E-FR8221-END-REC-KEY.           
                                                                        
           MOVE WS03-INS-NBR-SUCCESS TO E-FR8221-ADD-COUNT-EREC.        
           MOVE WS03-INS-AMT-SUCCESS TO E-FR8221-ADD-AMOUNT-EREC.       
                                                                        
           MOVE WS03-UPD-NBR-SUCCESS TO E-FR8221-UPDATE-COUNT-EREC.     
           MOVE WS03-UPD-AMT-SUCCESS TO E-FR8221-UPDATE-AMOUNT-EREC.    
                                                                        
           MOVE WS03-TRM-NBR-SUCCESS TO E-FR8221-TERM-COUNT-EREC.       
           MOVE WS03-TRM-AMT-SUCCESS TO E-FR8221-TERM-AMOUNT-EREC.      
                                                                        
           PERFORM 7525-WRITE-FCSR8221 THRU 7525-EXIT.                  
                                                                        
                                                                        
       7597-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 28020000
      *                                                               * 28040000
      * 7598-COUNT-ERRORS                                             * 28030000
      ***************************************************************** 28080000
       7598-COUNT-ERRORS.                                               
                                                                        
           MOVE '7598'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           IF (WS03-TOT-NBR-PROCESSED GREATER THAN 20                   
               AND WS03-TOT-NBR-SUCCESS EQUAL ZERO)                     
              OR WS03-TOT-NBR-REJECT GREATER THAN WS-REJECT-THRESHOLD   
                 INITIALIZE WS02-ERROR-LINE                             
                 MOVE WS-MODEL-STAMP(1:19) TO WS02-ERROR-DATE           
                 IF WS03-TOT-NBR-REJECT GREATER THAN WS-REJECT-THRESHOLD
                    SET WS02-ERROR-MANY-REJECTED TO TRUE                
                 ELSE                                                   
                    SET WS02-ERROR-ALL-REJECTED TO TRUE                 
                 END-IF                                                 
                 STRING 'TOTAL PROCESSED = '        DELIMITED BY SIZE   
                        WS03-TOT-NBR-PROCESSED      DELIMITED BY SIZE   
                        '  TOTAL SUCCESSFUL = '     DELIMITED BY SIZE   
                        WS03-TOT-NBR-SUCCESS        DELIMITED BY SIZE   
                        '  TOTAL REJECTED = '       DELIMITED BY SIZE   
                        WS03-TOT-NBR-REJECT         DELIMITED BY SIZE   
                   INTO WS02-ERROR-DETAIL                               
                 WRITE PRT331-RECORD FROM WS02-ERROR-LINE               
                 MOVE 01 TO RETURN-CODE                                 
           END-IF.                                                      
                                                                        
       7598-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 28390000
      **                                                             ** 28400000
      ** 7600-START-FCSJC01                                          ** 28400000
      ***************************************************************** 28430000
           EXEC SQL                                                     28440000
             INCLUDE CPD00038                                           28450000
           END-EXEC.                                                    28460000
                                                                        
      ***************************************************************** 28480000
      *                                                               * 28490000
      * 7999-SELECT-AL                                                * 28500000
      ***************************************************************** 28530000
           EXEC SQL                                                     28540000
               INCLUDE CPD00075                                         28550000
           END-EXEC.                                                    28560000
                                                                        
      ***************************************************************** 28580000
      **                                                             ** 28590000
      **  8895-INSERT-WORK-QUEUE                                     ** 28600000
      **  CALL SUB PROGRAM SCSCB077 FOR INSERTING WORK QUEUES INTO   ** 28610000
      **  CSS_WQ_ITEMS                                               ** 28620000
      ***************************************************************** 28640000
       8895-INSERT-WORK-QUEUE.                                          
                                                                        
           CALL SCSCB077  USING   CWS00077-FIELDS,                      
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
      *                                                                         
           MOVE RS-RETURN-CODE          TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF ABEND-FUNCTION > SPACES OR RS-RETURN-CODE NOT = 0         
              MOVE WS-PGRMNAME          TO ABEND-PROGRAM                
              DISPLAY '8895-INSERT-WORK-QUEUE'                          
              DISPLAY 'CALL SCSCB077         '                          
              DISPLAY 'ACCOUNT_NO      ' WS-77-ACCOUNT-NO               
              DISPLAY 'PREMISE_NO      ' WS-77-PREMISE-NO               
              DISPLAY 'SERV_ORDER_NO   ' WS-77-SERV-ORDER-NO            
              DISPLAY 'COMMENTS        ' WS-77-COMMENTS                 
              DISPLAY 'SQL RETURN CODE ' WS-ACTIVE-RETURN-CODE          
              PERFORM 9900-ABEND    THRU 9900-EXIT                      
           ELSE                                                         
              MOVE WS-77-WQ-ITEM-ID     TO WS-ITEM-ID                   
           END-IF.                                                      
                                                                        
       8895-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************29000000
      *    BYPASS ONLINE ERROR PROCESSING                               29010000
      ******************************************************************29020000
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           GO TO 9000-EXIT.                                             
                                                                        
      ***************************************************************** 29070000
      **                                                             ** 29080000
      **    9000-TERMINATE                                           ** 29090000
      **  CLOSES THE INPUT FILE AT EOF                               ** 29100000
      **                                                             ** 29110000
      ***************************************************************** 29120000
       9000-TERMINATE.                                                  
                                                                        
           MOVE '9000'              TO ACTIVE-PARAGRAPH.                
                                                                        
           CLOSE FCSBW822-FILE.                                         
                                                                        
           CLOSE FCSR8221-FILE.                                         
      ********DELETED REFERENCES TO 8222 FILE******************         29200000
                                                                        
           CLOSE FCSPT33-FILE.                                          
                                                                        
           CLOSE FCSPT331-FILE.                                         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 29290000
      **  - - - >   W A R N I N G           W A R N I N G   < - - -  ** 29300000
      **  - - - >                                           < - - -  ** 29310000
      **  - - - >         DON'T MOVE THIS PARAGRAPH         < - - -  ** 29320000
      **  - - - >         CPD00008 REQUIRES THAT            < - - -  ** 29330000
      **  - - - >         9900-SQL-ERROR-ROUTINE            < - - -  ** 29340000
      **  - - - >         BE POSITIONED RIGHT BEFORE        < - - -  ** 29350000
      **  - - - >         9900-ABEND                        < - - -  ** 29360000
      **                                                             ** 29370000
      **    9900-SQL-ERROR-ROUTINE                                   ** 29380000
      **  MODULE FOR PROCESSING SQL ERRORS ENCOUNTERED DURING        ** 29390000
      **  PROGRAM EXECUTION - NECESSARY DUE TO CALLS FROM CPD04822   ** 29400000
      **                                                             ** 29410000
      ***************************************************************** 29420000
       9900-SQL-ERROR-ROUTINE.                                          
                                                                        
           DISPLAY '*************************************'.             
           DISPLAY '**    PCSBW822 PROCESSING ERROR    **'.             
           DISPLAY '*************************************'.             
           DISPLAY '**    ACCOUNT_NO = ' E-FBW822-ACCOUNT-NO.           
                                                                        
           IF WS-DB2-PARAGRAPH > SPACES                                 
               DISPLAY '**    PARAGRAPH  = ' WS-DB2-PARAGRAPH           
           END-IF.                                                      
                                                                        
           IF WS-DB2-FUNCTION > SPACES                                  
               DISPLAY '**    FUNCTION  = ' WS-DB2-FUNCTION             
           END-IF.                                                      
                                                                        
           IF ACTIVE-PARAGRAPH > SPACES                                 
               DISPLAY '**    PARAGRAPH  = ' ACTIVE-PARAGRAPH           
           END-IF.                                                      
                                                                        
           IF ABEND-FUNCTION > SPACES                                   
               DISPLAY '**    FUNCTION  = ' ABEND-FUNCTION              
           END-IF.                                                      
                                                                        
           IF TABLE-1 > SPACES                                          
               DISPLAY '**    TABLE/FILE = ' TABLE-1                    
           END-IF.                                                      
                                                                        
           DISPLAY '*************************************'.             
                                                                        
      ***************************************************************** 29720000
      **  - - - >   W A R N I N G           W A R N I N G   < - - -  ** 29730000
      **  - - - >                                           < - - -  ** 29740000
      **  - - - >         DON'T MOVE THIS PARAGRAPH         < - - -  ** 29750000
      **  - - - >         CPD00008 REQUIRES THAT            < - - -  ** 29760000
      **  - - - >         9900-SQL-ERROR-ROUTINE            < - - -  ** 29770000
      **  - - - >         BE POSITIONED RIGHT BEFORE        < - - -  ** 29780000
      **  - - - >         9900-ABEND                        < - - -  ** 29790000
      **                                                             ** 29800000
      **                                                             ** 29810000
      **    9900-ABEND                                               ** 29820000
      **  COMMON PROCEDURE DIVISION FOR ABEND PROCESSING             ** 29830000
      **                                                             ** 29840000
      ***************************************************************** 29850000
           EXEC SQL                                                     29860000
             INCLUDE CPD09900                                           29870000
           END-EXEC.                                                    29880000
                                                                        
      ***************************************************************** 30110000
      **  CHANGED COPYBOOK FROM CPD0023B TO CPD0023C                 ** 30120000
      ***************************************************************** 30130000
           EXEC SQL                                                     30140000
             INCLUDE CPD0023C                                           30150000
           END-EXEC.                                                    30160000
      *                                                                 30170000
