       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSBW629.                                         
       DATE-WRITTEN.  09/08/06.                                         
       DATE-COMPILED.                                                   
      ***************************************************************** 00050000
      ***************************************************************** 00060000
      **               SOUTH CAROLINA ELECTRIC & GAS                 ** 00070000
      **                        COVANSYS                             ** 00080000
      **                                                             ** 00090000
      ********            CUSTOMER SERVICE SYSTEM             ********* 00100000
      ********                      DB2                       ********* 00110000
      ***************************************************************** 00120000
      **                                                             ** 00130000
      **            PROGRAM    MODIFICATION  LOG                     ** 00140000
      **    DATE    INITIALS     REASON                              ** 00150000
      **    ____    ________     ______                              ** 00160000
      **  09/08/06  AD94658      ORIGINAL VERSION                    ** 00170000
T34097**  01/14/08  MR97640      CREATE ROUTESMART FILE IN CSV FORMAT** 00180000
A05460**  06/08/16  MR7E794      REPLACE THE DUPLICATE FIELD WS-A    ** 00181000
A05460**            ACT188       AND REMOVED THE UNUSED COPYBOOKS.   ** 00182000
A#5470**  11/10/16  SS95855      GET LAT/LONG FROM PREMISE(ACT054)   ** 00183000
      **                                                             ** 00190000
      ***************************************************************** 00200000
           REMARKS.                                                     
                              PCSBW629 NARRATIVE                        
            THIS PROGRAM EXTRACTS THE DETAILS OF ALL THE ACCOUNTS BASED 
            ON THE USER SPECIFIED LOCAL OFFICE/READ CYCLE/ROUTE/SEQ#    
            COMBINATION. SUCH EXTRACTED FILE WILL BE SENT TO THE        
            ROUTESMART SYSTEM FOR RE-SEQUENCING.                        
      *                                                                 00270000
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  1000 - 1999     INITIALIZATION                        
                  2000 - 4999     MAJOR PROCESSING LOOP                 
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                 00370000
       ENVIRONMENT DIVISION.                                            
      *                                                                 00390000
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBW629.                                                   00420000
                                                                        
T34097 COPY CSSCS629.                                                   00440000
      *                                                                 00450000
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDBW629.                                                   00480000
       COPY FIOBW629.                                                   00490000
                                                                        
T34097 COPY CFDCS629.                                                   00510000
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW629'.
MSQ017     COPY MFASQLM.
      *                                                                 00540000
T34097 COPY FIOCS629.                                                   00550000
      *                                                                 00560000
       01  WS-START                        PIC X(40)  VALUE             
           'WORKING STORAGE FOR PCSBW629 STARTS HERE'.                  
      *                                                                 00590000
       01  WS-JOB-PARM-DTL.                                             
           05  WS-CO-TXT                 PIC X(03).                     
           05  WS-CO-PARM                PIC X(02).                     
           05  FILLER                    PIC X(01).                     
           05  WS-LOC-OFF-TXT            PIC X(03).                     
           05  WS-LOC-OFF-PARM           PIC X(03).                     
           05  FILLER                    PIC X(01).                     
           05  WS-READ-CYC-TXT           PIC X(04).                     
           05  WS-READ-CYC-PARM          PIC X(02).                     
           05  FILLER                    PIC X(01).                     
           05  WS-ROUTE-TXT              PIC X(03).                     
           05  WS-ROUTE-PARM             PIC X(04).                     
           05  FILLER                    PIC X(01).                     
           05  WS-BEGIN-SEQ-TXT          PIC X(05).                     
           05  WS-BEGIN-SEQ-PARM         PIC X(07).                     
           05  FILLER                    PIC X(01).                     
           05  WS-END-SEQ-TXT            PIC X(05).                     
           05  WS-END-SEQ-PARM           PIC X(07).                     
           05  FILLER                    PIC X(17).                     
      *                                                                 00790000
      ******************************************************************00800000
      ** RUN TYPE VALUES: 'A' - ALL METERS, ' ' - NON REMOVED METERS  **00810000
      ******************************************************************00820000
      *                                                                 00830000
       01  WS-RUN-TYPE-PARM.                                            
           05  WS-RUN-TYPE               PIC X(09).                     
           05  WS-PGM-RUN-TYPE           PIC X(01).                     
           05  WS-FILLER                 PIC X(70).                     
      *                                                                 00880000
       01  WS-MISC.                                                     
           05  RS-RETURN-CODE            PIC S9(04) COMP.               
           05  RS-RETURN-CODE-DISP       PIC +Z(04).                    
           05  PROGRAM-NAME              PIC X(08)  VALUE               
                                         'PCSBW629'.                    
           05  WS-PGRMNAME               PIC X(08)  VALUE               
                                         'PCSBW629'.                    
           05  WS-READ-ROUTE             PIC 9(04)  VALUE 0.            
           05  WS-BEG-SEQ-N              PIC 9(09)  VALUE 0.            
           05  WS-END-SEQ-N              PIC 9(09)  VALUE 0.            
COB305     05 WS-BEG-SEQ        PIC S9(9) COMP-3 VALUE 0.             
COB305     05 WS-END-SEQ        PIC S9(9) COMP-3 VALUE 0.             
           05  WS-LO-ROUTE               PIC S9(4)  COMP.               
           05  WS-HI-ROUTE               PIC S9(4)  COMP.               
           05  WS-LO-LOC-OFF             PIC X(03).                     
           05  WS-HI-LOC-OFF             PIC X(03).                     
           05  WS-LO-CYCLE               PIC X(02).                     
           05  WS-HI-CYCLE               PIC X(02).                     
           05  WS-NO-MORE-DATA           PIC X(01)  VALUE 'N'.          
           05  WS-FBW629-STATUS          PIC X(02).                     
               88 FBW629-SUCCESSFUL                 VALUE '00'.         
T34097     05  WS-FCS629-CSV-STATUS      PIC X(02).                     
T34097         88 FCS629-CSV-SUCCESSFUL             VALUE '00'.         
           05  WS-SEQ-NO                 PIC X(08).                     
           05  WS-SEQ-NO-JUSTIFIED       PIC X(08) JUSTIFIED RIGHT.     
           05  WS-IC-NO                  PIC X(04) JUSTIFIED RIGHT.     
           05  WS-MTR-REF-NO             PIC X(04) JUSTIFIED RIGHT.     
           05  WS-LONGITUDE              PIC -9(3).9(6).                
           05  WS-LATITUDE               PIC -9(3).9(6).                
           05  WS-GIS-POINT-ID           PIC X(12) VALUE SPACES         
                                                   JUSTIFIED RIGHT.     
      *                                                                 01200000
       01  WS-LITERALS.                                                 
           05  WS-K                      PIC X(01)  VALUE 'K'.          
           05  WS-N                      PIC X(01)  VALUE 'N'.          
           05  WS-Y                      PIC X(01)  VALUE 'Y'.          
           05  WS-U                      PIC X(01)  VALUE 'U'.          
      *                                                                 01270000
       01  WS-SWITCHES.                                                 
           05  WS-FETCH-REQ-FL             PIC X(01)   VALUE 'N'.       
               88  FETCH-REQ-FL                        VALUE 'Y'.       
      *                                                                 01310000
      ******************************************************************01320000
      **                   NECESSARY COPYBOOKS                        **01330000
      ******************************************************************01340000
      *                                                                 01350000
           EXEC SQL                                                     01360000
               INCLUDE CWS00099                                         01370000
           END-EXEC.                                                    01380000
      *                                                                 01390000
           EXEC SQL                                                     01400000
               INCLUDE CWS00074                                         01410000
           END-EXEC.                                                    01420000
      *                                                                 01430000
           EXEC SQL                                                     01440000
               INCLUDE CWS00011                                         01450000
           END-EXEC.                                                    01460000
      *                                                                 01470000
      ******************************************************************01480000
      **  ABEND SWITCH COPYBOOK                                       **01490000
      ******************************************************************01500000
      *                                                                 01510000
           COPY CWS00010.                                               01520000
           COPY CWS09900.                                               01530000
           COPY CWS00038.                                               01540000
           COPY FIOJC01.                                                01550000
      *                                                                 01560000
      ******************************************************************01570000
      **  DB2 AND SQL ERROR CHECKING                                  **01580000
      ******************************************************************01590000
      *                                                                 01600000
           COPY CWS00303.                                               01610000
      *                                                                 01620000
      ******************************************************************01630000
      **                 COMMON ABEND FUNCTIONALITY                   **01640000
      ******************************************************************01650000
      *                                                                 01660000
       01  ABEND-FUNCTIONS.                                             
           05  WS-ABEND-SPACE              PIC X(02)  VALUE SPACE.      
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC        PIC 99.                      
      *                                                                 01710000
      ******************************************************************01720000
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS           **01730000
      ******************************************************************01740000
      *                                                                 01750000
           EXEC SQL                                                     01760000
             INCLUDE SQLCA                                              01770000
           END-EXEC.                                                    01780000
      *                                                                 01790000
      ******************************************************************01800000
      **  CSS_JOB_PARM                                                **01810000
      ******************************************************************01820000
      *                                                                 01830000
           EXEC SQL                                                     01840000
             INCLUDE TBJBPARM                                           01850000
           END-EXEC.                                                    01860000
      *                                                                 01870000
      ******************************************************************01880000
      **  CSS_UTIL_ENVRNMT                                            **01890000
      ******************************************************************01900000
      *                                                                 01910000
           EXEC SQL                                                     01920000
             INCLUDE TBUTLENV                                           01930000
           END-EXEC.                                                    01940000
      *                                                                 01950000
      ******************************************************************01960000
      **  CSS_MTRD_ENVRNMT                                            **01970000
      ******************************************************************01980000
      *                                                                 01990000
           EXEC SQL                                                     02000000
             INCLUDE TBMTRENV                                           02010000
           END-EXEC.                                                    02020000
      *                                                                 02030000
      ******************************************************************02120000
      **  CSS_PREMISE                                                 **02130000
      ******************************************************************02140000
      *                                                                 02150000
           EXEC SQL                                                     02160000
             INCLUDE TBPREM                                             02170000
           END-EXEC.                                                    02180000
      *                                                                 02190000
      ******************************************************************02200000
      **  CSS_CUSTOMER                                                **02210000
      ******************************************************************02220000
      *                                                                 02230000
           EXEC SQL                                                     02240000
             INCLUDE TBCUST                                             02250000
           END-EXEC.                                                    02260000
      *                                                                 02270000
      ******************************************************************02280000
      **  CSS_ACCOUNT                                                 **02290000
      ******************************************************************02300000
      *                                                                 02310000
           EXEC SQL                                                     02320000
             INCLUDE TBACCT                                             02330000
           END-EXEC.                                                    02340000
      *                                                                 02350000
      ******************************************************************02440000
      **  CSS_NAME                                                    **02450000
      ******************************************************************02460000
      *                                                                 02470000
           EXEC SQL                                                     02480000
             INCLUDE TBNAME                                             02490000
           END-EXEC.                                                    02500000
      *                                                                 02510000
      ******************************************************************02520000
      **  CSS_NAME_ACCT_XREF                                          **02530000
      ******************************************************************02540000
      *                                                                 02550000
           EXEC SQL                                                     02560000
             INCLUDE TBNMACTX                                           02570000
           END-EXEC.                                                    02580000
      *                                                                 02590000
      ******************************************************************02600000
      **  CSS_CUST_ADDR_XREF                                          **02610000
      ******************************************************************02620000
      *                                                                 02630000
           EXEC SQL                                                     02640000
             INCLUDE TBCSADRX                                           02650000
           END-EXEC.                                                    02660000
      *                                                                 02670000
      ******************************************************************02680000
      **  CSS_ADDR_FREEFORM                                           **02690000
      ******************************************************************02700000
      *                                                                 02710000
           EXEC SQL                                                     02720000
             INCLUDE TBADRFRE                                           02730000
           END-EXEC.                                                    02740000
      *                                                                 02750000
      ******************************************************************02760000
      **  CSS_ADDR_FORMATTED                                          **02770000
      ******************************************************************02780000
      *                                                                 02790000
           EXEC SQL                                                     02800000
             INCLUDE TBADRFMT                                           02810000
           END-EXEC.                                                    02820000
      *                                                                 02830000
      ******************************************************************02840000
      **  CSS_ZIP_CODE                                                **02850000
      ******************************************************************02860000
      *                                                                 02870000
           EXEC SQL                                                     02880000
             INCLUDE TBZIPCD                                            02890000
           END-EXEC.                                                    02900000
      *                                                                 02910000
      ******************************************************************03000000
      **  CSS_ACCT_MISC_INFO                                          **03010000
      ******************************************************************03020000
      *                                                                 03030000
           EXEC SQL                                                     03040000
             INCLUDE TBATMISC                                           03050000
           END-EXEC.                                                    03060000
      *                                                                 03070000
      ******************************************************************03160000
      ** CSS_LOC_OFF_CYC_RT                                           **03170000
      ******************************************************************03180000
      *                                                                 03190000
           EXEC SQL                                                     03200000
             INCLUDE TBLCOFRT                                           03210000
           END-EXEC.                                                    03220000
      *                                                                 03230000
      ******************************************************************03240000
      **  CURSOR DECLARATION -- PARM_CUR                              **03250000
      ******************************************************************03260000
      *                                                                 03270000
           EXEC SQL                                                     
             DECLARE PARM_CUR CURSOR FOR                                
             SELECT  PARM_DATA                                          
               FROM  CSS_JOB_PARM WITH(READUNCOMMITTED)                         
              WHERE  COMPANY_NO            = '01'                       
                AND  PROGRAM_NAME          = :G6-PROGRAM-NAME           
                AND  CMND_CODE             = :G6-CMND-CODE              
ACT188          AND  STATUS                = 'A'                        
                AND  PARM_DATA             LIKE 'CO=%'                  
                FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03280000
MFA-TR*      DECLARE PARM_CUR CURSOR FOR                                03290000
MFA-TR*      SELECT  PARM_DATA                                          03300000
MFA-TR*        FROM  CSS_JOB_PARM                                       03310000
MFA-TR*       WHERE  COMPANY_NO            = '01'                       03320000
MFA-TR*         AND  PROGRAM_NAME          = :G6-PROGRAM-NAME           03330000
MFA-TR*         AND  CMND_CODE             = :G6-CMND-CODE              03340000
MFA-TR*         AND  STATUS                = 'A'                        03350000
MFA-TR*         AND  PARM_DATA             LIKE 'CO=%'                  03360000
MFA-TR*         FOR FETCH ONLY WITH UR                                  03370000
MFA-TR*    END-EXEC.                                                    03380000
      *                                                                 03390000
      ******************************************************************03400000
      **  CURSOR DECLARATION --  ROUTE_METER_CSR                      **03410000
      ******************************************************************03420000
           EXEC SQL                                                     
              DECLARE ROUTE_METER_CSR CURSOR FOR                        
              SELECT  AT.ACCOUNT_NO                                     
                     ,AT.PREMISE_NO                                     
                     ,AT.COMPANY_NO                                     
                     ,UT.CODE_UTIL_TYPE                                 
                     ,UT.READ_ROUTE                                     
                     ,UT.READ_CYCLE                                     
                     ,UT.COMPANY_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                     ,MN.CODE_METER_STATUS                              
                     ,MN.REGISTER_RD_SEQ                                
                     ,MN.CODE_UTIL_TYPE                                 
                     ,MN.MTR_REF_NO                                     
                     ,MN.IC_NO                                          
                     ,MN.REMOTE_READ_IND                                
A#5470               ,PR.PREM_REF_LATITUDE                              
A#5470               ,PR.PREM_REF_LONGITUDE                             
                     ,MN.GIS_POINT_ID                                   
                     ,PR.ADDRESS_ID                                     
                     ,PR.SPCL_READ_INSTR                                
                FROM  CSS_ACCOUNT        AT WITH(READUNCOMMITTED)               
                     ,CSS_UTIL_ENVRNMT   UT WITH(READUNCOMMITTED)               
                     ,CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)               
                     ,CSS_PREMISE        PR WITH(READUNCOMMITTED)               
               WHERE  AT.COMPANY_NO      = :AT-COMPANY-NO               
                 AND  AT.LOCAL_OFFICE    BETWEEN :WS-LO-LOC-OFF         
                                             AND :WS-HI-LOC-OFF         
                 AND  AT.ACCOUNT_NO      = UT.ACCOUNT_NO                
                 AND  AT.PREMISE_NO      = PR.PREMISE_NO                
                 AND  UT.CODE_UTIL_TYPE  IN ('E','G')                   
                 AND  UT.READ_ROUTE      BETWEEN :WS-LO-ROUTE           
                                             AND :WS-HI-ROUTE           
                 AND  UT.READ_CYCLE      BETWEEN :WS-LO-CYCLE           
                                             AND :WS-HI-CYCLE           
                 AND  UT.ACCOUNT_NO      = MN.ACCOUNT_NO                
                 AND  UT.IC_NO           = MN.IC_NO                     
                 AND  UT.CODE_UTIL_TYPE  = MN.CODE_UTIL_TYPE            
                 AND  MN.REGISTER_RD_SEQ BETWEEN :WS-BEG-SEQ            
                                             AND :WS-END-SEQ            
                 FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03430000
MFA-TR*       DECLARE ROUTE_METER_CSR CURSOR FOR                        03440000
MFA-TR*       SELECT  AT.ACCOUNT_NO                                     03450000
MFA-TR*              ,AT.PREMISE_NO                                     03460000
MFA-TR*              ,AT.COMPANY_NO                                     03470000
MFA-TR*              ,UT.CODE_UTIL_TYPE                                 03480000
MFA-TR*              ,UT.READ_ROUTE                                     03490000
MFA-TR*              ,UT.READ_CYCLE                                     03500000
MFA-TR*              ,UT.COMPANY_NO                                     03510000
MFA-TR*              ,AT.LOCAL_OFFICE                                   03520000
MFA-TR*              ,MN.CODE_METER_STATUS                              03530000
MFA-TR*              ,MN.REGISTER_RD_SEQ                                03540000
MFA-TR*              ,MN.CODE_UTIL_TYPE                                 03550000
MFA-TR*              ,MN.MTR_REF_NO                                     03560000
MFA-TR*              ,MN.IC_NO                                          03570000
MFA-TR*              ,MN.REMOTE_READ_IND                                03580000
MFA-TR*              ,PR.PREM_REF_LATITUDE                              03590000
MFA-TR*              ,PR.PREM_REF_LONGITUDE                             03600000
MFA-TR*              ,MN.GIS_POINT_ID                                   03610000
MFA-TR*              ,PR.ADDRESS_ID                                     03620000
MFA-TR*              ,PR.SPCL_READ_INSTR                                03630000
MFA-TR*         FROM  CSS_ACCOUNT        AT                             03640000
MFA-TR*              ,CSS_UTIL_ENVRNMT   UT                             03650000
MFA-TR*              ,CSS_MTRD_ENVRNMT   MN                             03660000
MFA-TR*              ,CSS_PREMISE        PR                             03670000
MFA-TR*        WHERE  AT.COMPANY_NO      = :AT-COMPANY-NO               03680000
MFA-TR*          AND  AT.LOCAL_OFFICE    BETWEEN :WS-LO-LOC-OFF         03690000
MFA-TR*                                      AND :WS-HI-LOC-OFF         03700000
MFA-TR*          AND  AT.ACCOUNT_NO      = UT.ACCOUNT_NO                03710000
MFA-TR*          AND  AT.PREMISE_NO      = PR.PREMISE_NO                03720000
MFA-TR*          AND  UT.CODE_UTIL_TYPE  IN ('E','G')                   03730000
MFA-TR*          AND  UT.READ_ROUTE      BETWEEN :WS-LO-ROUTE           03740000
MFA-TR*                                      AND :WS-HI-ROUTE           03750000
MFA-TR*          AND  UT.READ_CYCLE      BETWEEN :WS-LO-CYCLE           03760000
MFA-TR*                                      AND :WS-HI-CYCLE           03770000
MFA-TR*          AND  UT.ACCOUNT_NO      = MN.ACCOUNT_NO                03780000
MFA-TR*          AND  UT.IC_NO           = MN.IC_NO                     03790000
MFA-TR*          AND  UT.CODE_UTIL_TYPE  = MN.CODE_UTIL_TYPE            03800000
MFA-TR*          AND  MN.REGISTER_RD_SEQ BETWEEN :WS-BEG-SEQ            03810000
MFA-TR*                                      AND :WS-END-SEQ            03820000
MFA-TR*          FOR FETCH ONLY WITH UR                                 03830000
MFA-TR*    END-EXEC.                                                    03840000
      *                                                                 03850000
       01  WS-WORKING-STORAGE-END        PIC X(40)  VALUE               
           'WORKING STORAGE FOR PCSBW629 ENDS HERE  '.                  
      *                                                                 03880000
       PROCEDURE DIVISION.                                              
      *                                                                 03900000
      ***************************************************************** 03910000
      **    0000-MAIN                                                ** 03920000
      ***************************************************************** 03930000
      *                                                                 03940000
       0000-MAIN.                                                       
      *                                                                 03960000
           PERFORM 0100-INITIALIZATION   THRU 0100-EXIT.                
      *                                                                 03980000
           PERFORM 1000-PROCESS-CURSOR   THRU 1000-EXIT.                
      *                                                                 04000000
           PERFORM 9000-TERMINATE        THRU 9000-EXIT.                
      *                                                                 04020000
           STOP RUN.                                                    
      *                                                                 04040000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04070000
      ***************************************************************** 04080000
      **    0100-INITIALIZATION.                                     ** 04090000
      **       OPEN OUTPUT FILES.                                    ** 04100000
      ***************************************************************** 04110000
      *                                                                 04120000
       0100-INITIALIZATION.                                             
      *                                                                 04140000
           INITIALIZE                      WS-BEG-SEQ                   
                                          ,WS-END-SEQ                   
                                          ,WS-LO-ROUTE                  
                                          ,WS-HI-ROUTE.                 
      *                                                                 04190000
T34097     OPEN OUTPUT FCSBW629-FILE                                    
T34097                 FCSCS629-FILE.                                   
      *                                                                 04220000
           IF  FBW629-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '**     PCSBW629 PROCESSING ERROR          **'   
               DISPLAY '**     OPEN ERROR ON FCSBW126 FILE        **'   
               DISPLAY '**     FBW629 FILE STATUS =' WS-FBW629-STATUS   
               DISPLAY '**     PROCESSING TERMINATED....          **'   
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
T34097     IF  FCS629-CSV-SUCCESSFUL                                    
T34097         CONTINUE                                                 
T34097     ELSE                                                         
T34097         DISPLAY '********************************************'   
T34097         DISPLAY '**     PCSBW629 PROCESSING ERROR          **'   
T34097         DISPLAY '**     OPEN ERROR ON FCSCS629-FILE        **'   
T34097         DISPLAY '**  FBW629 FILE STATUS =' WS-FCS629-CSV-STATUS  
T34097         DISPLAY '**     PROCESSING TERMINATED....          **'   
T34097         DISPLAY '********************************************'   
T34097         PERFORM 9900-ABEND THRU 9900-EXIT                        
T34097     END-IF.                                                      
                                                                        
           PERFORM 0200-GET-RUN-TYPE THRU 0200-EXIT.                    
      *                                                                 04480000
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04510000
      ******************************************************************04520000
      * MODULE TO GET RUN TYPE FOR CURSOR PROCESSING                   *04530000
      ******************************************************************04540000
       0200-GET-RUN-TYPE.                                               
      *                                                                 04560000
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE WS-PGRMNAME                TO WS-PROGRAM.               
           MOVE WS-OPTN                    TO WS-COMMAND.               
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           PERFORM 7600-START-FCSJC01      THRU 7600-EXIT.              
           PERFORM 7610-READ-FCSJC01       THRU 7610-EXIT               
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:9) =                    
                     'RUN TYPE=' AND INPUT-ACTIVE)                      
                  OR  END-OF-SYSIPT.                                    
                                                                        
           IF  END-OF-SYSIPT                                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE G6-PARM-DATA           TO WS-RUN-TYPE-PARM          
               PERFORM 7611-CLOSE THRU 7611-EXIT                        
           END-IF.                                                      
      *                                                                 04740000
       0200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04770000
      ******************************************************************04780000
      *  MAIN MODULE TO EXTRACT CUSTOMER DATA FROM DB2                 *04790000
      ******************************************************************04800000
       1000-PROCESS-CURSOR.                                             
      *                                                                 04820000
           MOVE WS-PGRMNAME              TO G6-PROGRAM-NAME.            
           MOVE WS-OPTN                  TO G6-CMND-CODE.               
      *                                                                 04850000
           PERFORM 7100-OPEN-PARM-CUR    THRU 7100-EXIT.                
           PERFORM 7110-FETCH-PARM-CUR   THRU 7110-EXIT.                
      *                                                                 04880000
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
                                                                        
               MOVE G6-PARM-DATA         TO WS-JOB-PARM-DTL             
               MOVE WS-CO-PARM           TO AT-COMPANY-NO               
                                                                        
               IF  WS-LOC-OFF-PARM   > SPACES AND LOW-VALUES            
                   MOVE WS-LOC-OFF-PARM  TO WS-LO-LOC-OFF               
                                            WS-HI-LOC-OFF               
               ELSE                                                     
                   MOVE '   '            TO WS-LO-LOC-OFF               
                   MOVE '999'            TO WS-HI-LOC-OFF               
               END-IF                                                   
                                                                        
               IF  WS-READ-CYC-PARM   > SPACES AND LOW-VALUES           
                   MOVE WS-READ-CYC-PARM TO WS-LO-CYCLE                 
                                            WS-HI-CYCLE                 
               ELSE                                                     
                   MOVE '  '             TO WS-LO-CYCLE                 
                   MOVE '99'             TO WS-HI-CYCLE                 
               END-IF                                                   
                                                                        
               IF  WS-ROUTE-PARM > SPACES AND LOW-VALUES                
                   MOVE WS-ROUTE-PARM    TO WS-READ-ROUTE               
                   MOVE WS-READ-ROUTE    TO WS-LO-ROUTE                 
                                            WS-HI-ROUTE                 
               ELSE                                                     
                   MOVE ZEROS            TO WS-LO-ROUTE                 
                   MOVE 9999             TO WS-HI-ROUTE                 
               END-IF                                                   
                                                                        
               IF  WS-BEGIN-SEQ-PARM  > SPACES AND LOW-VALUES           
                   MOVE WS-BEGIN-SEQ-PARM TO WS-BEG-SEQ-N               
               ELSE                                                     
                   MOVE  0                TO WS-BEG-SEQ-N               
               END-IF                                                   
                                                                        
               IF  WS-BEG-SEQ-N IS NUMERIC                              
                   MOVE WS-BEG-SEQ-N      TO WS-BEG-SEQ                 
               ELSE                                                     
                   DISPLAY '*********************************'          
                   DISPLAY '**  PCSBW629 PROCESSING ERROR  **'          
                   DISPLAY '**  BEGIN SEQ# ON JOB-PARM IS  **'          
                   DISPLAY '**  NOT NUMERIC. PLEASE CHECK. **'          
                   DISPLAY '**  PROCESSING TERMINATED....  **'          
                   DISPLAY '*********************************'          
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
                                                                        
               IF  WS-END-SEQ-PARM    > SPACES AND LOW-VALUES           
                   MOVE  WS-END-SEQ-PARM   TO WS-END-SEQ-N              
                   MOVE  WS-END-SEQ-N      TO WS-END-SEQ                
               ELSE                                                     
                   MOVE  +99999999         TO WS-END-SEQ-N              
               END-IF                                                   
                                                                        
               IF  WS-END-SEQ-N IS NUMERIC                              
                   MOVE WS-END-SEQ-N       TO WS-END-SEQ                
               ELSE                                                     
                   DISPLAY '*********************************'          
                   DISPLAY '**  PCSBW629 PROCESSING ERROR  **'          
                   DISPLAY '**  END  SEQ# ON JOB-PARM IS   **'          
                   DISPLAY '**  NOT NUMERIC. PLEASE CHECK. **'          
                   DISPLAY '**  PROCESSING TERMINATED....  **'          
                   DISPLAY '*********************************'          
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
                                                                        
               DISPLAY '*** PROCESSING FOR COMPANY '  AT-COMPANY-NO     
                          ' LOC OFF = ' WS-LOC-OFF-PARM                 
                          ' CYCLE   = ' WS-READ-CYC-PARM                
                          ' ROUTE   = ' WS-ROUTE-PARM                   
                                                                        
               PERFORM 7200-OPEN-METER-CURSOR  THRU 7200-EXIT           
               PERFORM 7210-FETCH-METER-CURSOR THRU 7210-EXIT           
               PERFORM 1100-FORMAT-FIOBW629    THRU 1100-EXIT           
                         UNTIL WS-NO-MORE-DATA EQUAL WS-Y               
               PERFORM 7220-CLOSE-METER-CURSOR THRU 7220-EXIT           
               MOVE    'N'                     TO WS-NO-MORE-DATA       
               PERFORM 7110-FETCH-PARM-CUR     THRU 7110-EXIT           
           END-PERFORM.                                                 
                                                                        
           PERFORM 7120-CLOSE-PARM-CUR THRU 7120-EXIT.                  
      *                                                                 05710000
       1000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 05740000
      **   1100-FORMAT-FIOBW629                                      ** 05750000
      **   FORMAT DATA FOR THE OUTPUT FILE FCSBW629                  ** 05760000
      ***************************************************************** 05770000
       1100-FORMAT-FIOBW629.                                            
      *                                                                 05790000
           IF FETCH-REQ-FL                                              
              MOVE WS-N                  TO WS-FETCH-REQ-FL             
              PERFORM 7210-FETCH-METER-CURSOR THRU 7210-EXIT            
              IF WS-NO-MORE-DATA EQUAL WS-Y                             
                 GO TO 1100-EXIT                                        
              END-IF                                                    
           END-IF                                                       
      *                                                                 05870000
           MOVE AT-PREMISE-NO            TO WS-CPD99-PREMISE-NO.        
           PERFORM 6990-FETCH-CUR-ACCOUNT     THRU 6990-EXIT.           
      *                                                                 05900000
           IF AT-ACCOUNT-NO NOT EQUAL WS-CPD99-ACCOUNT-NO               
              MOVE WS-Y                  TO WS-FETCH-REQ-FL             
              GO TO 1100-EXIT                                           
           END-IF.                                                      
      *                                                                 05950000
           MOVE AT-ACCOUNT-NO            TO E-FBW629-ACCOUNT-NO         
T34097                                      E-FCS629-ACCOUNT-NO         
      *                                                                 05980000
           MOVE PR-ADDRESS-ID            TO AT-ADDRESS-ID.              
           PERFORM 4000-MAIL-NAME-ADDRESS     THRU 4000-EXIT.           
      *                                                                 06010000
T34097     MOVE AT-PREMISE-NO            TO E-FBW629-PREMISE-NO         
T34097                                      E-FCS629-PREMISE-NO.        
T34097     MOVE UT-CODE-UTIL-TYPE        TO E-FBW629-CODE-UTIL-TYPE     
T34097                                      E-FCS629-CODE-UTIL-TYPE.    
      *                                                                 06060000
           MOVE MN-IC-NO                 TO WS-IC-NO.                   
           INSPECT WS-IC-NO              REPLACING ALL ' ' BY '0'.      
T34097     MOVE WS-IC-NO                 TO E-FBW629-IC-NO              
T34097                                      E-FCS629-IC-NO.             
      *                                                                 06110000
           MOVE MN-MTR-REF-NO            TO WS-MTR-REF-NO.              
           INSPECT WS-MTR-REF-NO         REPLACING ALL ' ' BY '0'.      
T34097     MOVE WS-MTR-REF-NO            TO E-FBW629-MTR-REF-NO         
T34097                                      E-FCS629-MTR-REF-NO.        
      *                                                                 06160000
T34097     MOVE ZEROES                   TO E-FBW629-FILLER             
T34097                                      E-FCS629-FILLER.            
      *                                                                 06190000
           MOVE WS-CUSTOMER-NAME         TO E-FBW629-CUSTOMER-NAME.     
T34097     INSPECT WS-CUSTOMER-NAME      REPLACING ALL ',' BY ' '.      
T34097     MOVE WS-CUSTOMER-NAME         TO E-FCS629-CUSTOMER-NAME.     
T34097                                                                  
T34097     MOVE WS-HOUSE-NO              TO E-FBW629-STREET-NUMBER      
T34097                                      E-FCS629-STREET-NUMBER.     
T34097                                                                  
           MOVE WS-ADDR-PREFIX-2         TO E-FBW629-STREET-PREFIX.     
T34097     INSPECT WS-ADDR-PREFIX-2      REPLACING ALL ',' BY ' '.      
T34097     MOVE WS-ADDR-PREFIX-2         TO E-FCS629-STREET-PREFIX.     
T34097                                                                  
           MOVE WS-NAME-STREET           TO E-FBW629-STREET-NAME.       
T34097     INSPECT WS-NAME-STREET        REPLACING ALL ',' BY ' '.      
T34097     MOVE WS-NAME-STREET           TO E-FCS629-STREET-NAME.       
T34097                                                                  
           MOVE WS-STREET-SUFFIX         TO E-FBW629-STREET-TYPE.       
T34097     INSPECT WS-STREET-SUFFIX      REPLACING ALL ',' BY ' '.      
T34097     MOVE WS-STREET-SUFFIX         TO E-FCS629-STREET-TYPE.       
T34097                                                                  
T34097     MOVE SPACES                   TO E-FBW629-STREET-SUFFIX      
T34097                                      E-FCS629-STREET-SUFFIX.     
T34097                                                                  
T34097     MOVE WS-STREET-LOCATION-2     TO E-FBW629-APARTMENT-NO       
T34097                                      E-FCS629-APARTMENT-NO.      
T34097                                                                  
T34097     MOVE SPACES                   TO E-FBW629-BUILDING-NO        
T34097                                      E-FCS629-BUILDING-NO.       
T34097                                                                  
           MOVE WS-CITY                  TO E-FBW629-CITY.              
T34097     INSPECT WS-CITY               REPLACING ALL ',' BY ' '.      
T34097     MOVE WS-CITY                  TO E-FCS629-CITY.              
T34097                                                                  
           MOVE WS-STATE                 TO E-FBW629-STATE.             
T34097     INSPECT WS-STATE              REPLACING ALL ',' BY ' '.      
T34097     MOVE WS-STATE                 TO E-FCS629-STATE.             
T34097                                                                  
T34097     MOVE WS-ZIP-CODE              TO E-FBW629-POSTAL-CODE        
T34097                                      E-FCS629-POSTAL-CODE.       
T34097                                                                  
T34097     MOVE WS-ZIP-PLUS-4            TO E-FBW629-ZIP-PLUS4          
T34097                                      E-FCS629-ZIP-PLUS4.         
T34097                                                                  
T34097     MOVE SPACES                   TO E-FBW629-COMMENT-TEXT       
T34097                                      E-FCS629-COMMENT-TEXT.      
           IF PR-SPCL-READ-INSTR-LEN > 0                                
               MOVE PR-SPCL-READ-INSTR-TEXT                             
                                         TO E-FBW629-COMMENT-TEXT       
T34097         INSPECT PR-SPCL-READ-INSTR-TEXT                          
T34097                                   REPLACING ALL ',' BY ' '       
T34097         MOVE PR-SPCL-READ-INSTR-TEXT                             
T34097                                   TO E-FCS629-COMMENT-TEXT       
               MOVE SPACES               TO PR-SPCL-READ-INSTR-TEXT     
           END-IF.                                                      
      *                                                                 06560000
T34097     MOVE 'N'                      TO E-FBW629-ALLEY-SERVICE      
T34097                                      E-FCS629-ALLEY-SERVICE.     
      *                                                                 06590000
A#5470     IF PR-PREM-REF-LONGITUDE EQUAL ZERO                          
              MOVE SPACES                TO E-FBW629-LONGITUDE          
T34097                                      E-FCS629-LONGITUDE          
           ELSE                                                         
A#5470        MOVE PR-PREM-REF-LONGITUDE TO WS-LONGITUDE                
              MOVE WS-LONGITUDE          TO E-FBW629-LONGITUDE          
T34097                                      E-FCS629-LONGITUDE          
              MOVE 0                     TO WS-LONGITUDE                
           END-IF.                                                      
                                                                        
A#5470     IF PR-PREM-REF-LATITUDE EQUAL ZERO                           
              MOVE SPACES                TO E-FBW629-LATITUDE           
T34097                                      E-FCS629-LATITUDE           
           ELSE                                                         
A#5470        MOVE PR-PREM-REF-LATITUDE  TO WS-LATITUDE                 
              MOVE WS-LATITUDE           TO E-FBW629-LATITUDE           
T34097                                      E-FCS629-LATITUDE           
              MOVE 0                     TO WS-LATITUDE                 
           END-IF.                                                      
      *                                                                 06790000
           MOVE MN-GIS-POINT-ID          TO WS-GIS-POINT-ID.            
           INSPECT WS-GIS-POINT-ID       REPLACING ALL ' ' BY '0'.      
T34097     MOVE WS-GIS-POINT-ID          TO E-FBW629-GIS-POINT-ID       
T34097                                      E-FCS629-GIS-POINT-ID.      
      *                                                                 06840000
           IF MN-CODE-METER-STATUS NOT EQUAL 'K'                        
              MOVE 'A'                   TO E-FBW629-METER-STATUS       
T34097                                      E-FCS629-METER-STATUS       
           ELSE                                                         
              MOVE 'I'                   TO E-FBW629-METER-STATUS       
T34097                                      E-FCS629-METER-STATUS       
           END-IF.                                                      
      *                                                                 06920000
T34097     MOVE SPACES                   TO E-FBW629-EXIST-PARTITION    
T34097                                      E-FCS629-EXIST-PARTITION.   
T34097     MOVE UT-READ-ROUTE            TO E-FBW629-EXIST-ROUTE        
T34097                                      E-FCS629-EXIST-ROUTE.       
T34097     MOVE MN-REGISTER-RD-SEQ       TO E-FBW629-EXIST-SEQUENCE     
T34097                                      E-FCS629-EXIST-SEQUENCE.    
T34097     MOVE AT-LOCAL-OFFICE          TO E-FBW629-REGION             
T34097                                      E-FCS629-REGION.            
T34097     MOVE MN-REMOTE-READ-IND       TO E-FBW629-SERVICE-TYPE       
T34097                                      E-FCS629-SERVICE-TYPE.      
T34097     MOVE SPACES                   TO E-FBW629-SERVICE-MODE       
T34097                                      E-FCS629-SERVICE-MODE.      
T34097     MOVE UT-READ-CYCLE            TO E-FBW629-FREQUENCY-CODE     
T34097                                      E-FCS629-FREQUENCY-CODE.    
T34097     MOVE SPACES                   TO E-FBW629-PRODUCT-CODE       
T34097                                      E-FCS629-PRODUCT-CODE.      
      *                                                                 07090000
           MOVE AT-LOCAL-OFFICE          TO O2-LOCAL-OFFICE             
           MOVE UT-READ-CYCLE            TO O2-READ-CYCLE               
           MOVE UT-READ-ROUTE            TO O2-READ-ROUTE               
      *                                                                 07130000
           PERFORM 7300-GET-POINT-ID          THRU 7300-EXIT.           
      *                                                                 07150000
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
              MOVE O2-ITRON-PC-ID        TO E-FBW629-START-POINT-ID     
T34097                                      E-FCS629-START-POINT-ID     
                                            E-FBW629-END-POINT-ID       
T34097                                      E-FCS629-END-POINT-ID       
           ELSE                                                         
              MOVE SPACES                TO E-FBW629-START-POINT-ID     
T34097                                      E-FCS629-START-POINT-ID     
                                            E-FBW629-END-POINT-ID       
T34097                                      E-FCS629-END-POINT-ID       
           END-IF.                                                      
      *                                                                 07270000
T34097     MOVE AT-COMPANY-NO            TO E-FBW629-COMPANY-NO         
T34097                                      E-FCS629-COMPANY-NO.        
      *                                                                 07300000
           IF WS-PGM-RUN-TYPE EQUAL 'A'                                 
              PERFORM 8000-WRITE-FIOBW629   THRU 8000-EXIT              
T34097        PERFORM 8100-WRITE-FIOCS629   THRU 8100-EXIT              
           ELSE                                                         
              IF MN-CODE-METER-STATUS NOT EQUAL 'K'                     
                 PERFORM 8000-WRITE-FIOBW629   THRU 8000-EXIT           
T34097           PERFORM 8100-WRITE-FIOCS629   THRU 8100-EXIT           
              END-IF                                                    
           END-IF.                                                      
      *                                                                 07400000
           PERFORM 7210-FETCH-METER-CURSOR THRU 7210-EXIT.              
      *                                                                 07420000
       1100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  07450000
      * THIS INCLUDES 6010-REDUCE-EMBEDDED-SPACES                    *  07460000
      ****************************************************************  07470000
           EXEC SQL                                                     07480000
               INCLUDE CPD00004                                         07490000
           END-EXEC.                                                    07500000
      *                                                                 07510000
      ****************************************************************  07520000
      * THIS INCLUDES 4000-MAIL-NAME-ADDRESS                         *  07530000
      ****************************************************************  07540000
           EXEC SQL                                                     07550000
               INCLUDE CPD00074                                         07560000
           END-EXEC.                                                    07570000
      *                                                                 07580000
      ******************************************************************07590000
      * 6990-FETCH-CUR-ACCOUNT                                         *07600000
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *07610000
      ******************************************************************07620000
           EXEC SQL                                                     07630000
               INCLUDE CPDCA099                                         07640000
           END-EXEC.                                                    07650000
      *                                                                 07660000
      ******************************************************************07670000
      * 6995-CPD99-ERROR-ROUTINE                                       *07680000
      ******************************************************************07690000
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                 07710000
           DISPLAY '*************PCSBW121************'.                 
           DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
           DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1.                
           DISPLAY '* SQL CODE IS  ', WS-CPD99-RETURN-CODE.             
           DISPLAY '* PROGRAM ABENDING...           *'.                 
           DISPLAY '*************PCSBW121************'.                 
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                 07790000
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07820000
      *                                                                 07830000
      ***************************************************************** 07840000
      * OPEN PARM CURSOR                                                07850000
      ***************************************************************** 07860000
       7100-OPEN-PARM-CUR.                                              
      *                                                                 07880000
           EXEC SQL                                                     
                OPEN PARM_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07920000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 07940000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSCA627 PROCESSING ERROR      **'       
               DISPLAY '**     7100-OPEN-PARM-CUR             **'       
               DISPLAY '**     OPEN ERROR FOR PARM_CUR CURSOR **'       
               DISPLAY '**     RETURNCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '**     PROCESSING TERMINATED          **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08070000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08100000
      ***************************************************************** 08110000
      * FETCH PARM CURSOR                                               08120000
      ***************************************************************** 08130000
       7110-FETCH-PARM-CUR.                                             
      *                                                                 08150000
           EXEC SQL                                                     
                FETCH PARM_CUR                                          
                 INTO :G6-PARM-DATA                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08200000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 08220000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
                                           NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**   PCSCA627 PROCESSING ERROR        **'       
               DISPLAY '**   7110-FETCH-PARM-CUR              **'       
               DISPLAY '**   FETCH ERROR FOR PARM_CUR CURSOR  **'       
               DISPLAY '**   RETURNCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**   PROCESSING TERMINATED            **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08360000
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08390000
      ***************************************************************** 08400000
      * CLOSE PARM CURSOR                                               08410000
      ***************************************************************** 08420000
       7120-CLOSE-PARM-CUR.                                             
      *                                                                 08440000
           EXEC SQL                                                     
                CLOSE PARM_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08480000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 08500000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**   PCSCA627 PROCESSING ERROR        **'       
               DISPLAY '**   7120-CLOSE-PARM-CUR              **'       
               DISPLAY '**   CLOSE ERROR FOR PARM_CUR CURSOR  **'       
               DISPLAY '**   RETURNCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '**   PROCESSING TERMINATED            **'       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08630000
       7120-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 08660000
      **    7200-OPEN-METER-CURSOR                                   ** 08670000
      **        THE DRIVING CURSOR IS OPENED.                        ** 08680000
      ***************************************************************** 08690000
      *                                                                 08700000
       7200-OPEN-METER-CURSOR.                                          
      *                                                                 08720000
           EXEC SQL                                                     
               OPEN ROUTE_METER_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08760000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 08780000
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSBW629 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE     
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 08890000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08920000
      ***************************************************************** 08930000
      **    7210-FETCH-METER-CURSOR                                  ** 08940000
      **        THE NEXT RECORD MATCHING THE CRITERIA IS RETRIEVED.  ** 08950000
      ***************************************************************** 08960000
      *                                                                 08970000
       7210-FETCH-METER-CURSOR.                                         
      *                                                                 08990000
           EXEC SQL                                                     
             FETCH  ROUTE_METER_CSR                                     
              INTO  :AT-ACCOUNT-NO                                      
                   ,:AT-PREMISE-NO                                      
                   ,:AT-COMPANY-NO                                      
                   ,:UT-CODE-UTIL-TYPE                                  
                   ,:UT-READ-ROUTE                                      
                   ,:UT-READ-CYCLE                                      
                   ,:UT-COMPANY-NO                                      
                   ,:AT-LOCAL-OFFICE                                    
                   ,:MN-CODE-METER-STATUS                               
                   ,:MN-REGISTER-RD-SEQ                                 
                   ,:MN-CODE-UTIL-TYPE                                  
                   ,:MN-MTR-REF-NO                                      
                   ,:MN-IC-NO                                           
                   ,:MN-REMOTE-READ-IND                                 
A#5470             ,:PR-PREM-REF-LATITUDE                               
A#5470             ,:PR-PREM-REF-LONGITUDE                              
                   ,:MN-GIS-POINT-ID                                    
                   ,:PR-ADDRESS-ID                                      
                   ,:PR-SPCL-READ-INSTR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09220000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 09240000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   MOVE WS-Y               TO WS-NO-MORE-DATA           
               ELSE                                                     
                   DISPLAY '****************************************'   
                   DISPLAY '**     PCSBW629 PROCESSING ERROR      **'   
                   DISPLAY '**      ABEND IN PARAGRAPH 7210       **'   
                   DISPLAY '**        SQLCODE = ' WS-ACTIVE-RETURN-CODE 
                   DISPLAY '****************************************'   
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               END-IF                                                   
           END-IF.                                                      
      *                                                                 09390000
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09420000
      ***************************************************************** 09430000
      **    7220-CLOSE-METER-CURSOR                                  ** 09440000
      **        THE DRIVING CURSOR IS CLOSED.                        ** 09450000
      ***************************************************************** 09460000
      *                                                                 09470000
       7220-CLOSE-METER-CURSOR.                                         
      *                                                                 09490000
           EXEC SQL                                                     
               CLOSE  ROUTE_METER_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09530000
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                 09550000
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSBW629 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7220       **'       
               DISPLAY '**      SQLCODE = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '****************************************'       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 09660000
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09690000
      ****************************************************************  09700000
      **                                                            **  09710000
      **  7300-GET-POINT-ID.                                        **  09720000
      **  GETS THE ITRON PC ID                                      **  09730000
      ****************************************************************  09740000
       7300-GET-POINT-ID.                                               
      *                                                                 09760000
           EXEC SQL                                                     
               SELECT O2.ITRON_PC_ID                                    
                 INTO :O2-ITRON-PC-ID                                   
                 FROM CSS_LOC_OFF_CYC_RT O2 WITH(READUNCOMMITTED)               
                WHERE LOCAL_OFFICE = :O2-LOCAL-OFFICE                   
                  AND READ_CYCLE   = :O2-READ-CYCLE                     
                  AND READ_ROUTE   = :O2-READ-ROUTE                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09770000
MFA-TR*        SELECT O2.ITRON_PC_ID                                    09780000
MFA-TR*          INTO :O2-ITRON-PC-ID                                   09790000
MFA-TR*          FROM CSS_LOC_OFF_CYC_RT O2                             09800000
MFA-TR*         WHERE LOCAL_OFFICE = :O2-LOCAL-OFFICE                   09810000
MFA-TR*           AND READ_CYCLE   = :O2-READ-CYCLE                     09820000
MFA-TR*           AND READ_ROUTE   = :O2-READ-ROUTE                     09830000
MFA-TR*         WITH UR                                                 09840000
MFA-TR*    END-EXEC.                                                    09850000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09860000
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSBW629 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7300       **'       
               DISPLAY '** LOCAL OFFICE = ' O2-LOCAL-OFFICE             
               DISPLAY '** READ CYCLE   = ' O2-READ-CYCLE               
               DISPLAY '** READ ROUTN   = ' O2-READ-ROUTE               
               DISPLAY '*****************************************'      
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                 09990000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10020000
      ***************************************************************** 10030000
      **      COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING        ** 10040000
      ***************************************************************** 10050000
      *                                                                 10060000
           EXEC SQL                                                     10070000
             INCLUDE CPD00038                                           10080000
           END-EXEC.                                                    10090000
      *                                                                 10100000
      ***************************************************************** 10110000
      ** WRITE INTO THE FILE FCSBW629                                ** 10120000
      ***************************************************************** 10130000
       8000-WRITE-FIOBW629.                                             
      *                                                                 10150000
           WRITE FIOBW629.                                              
      *                                                                 10170000
           IF  FBW629-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '**     PCSBW629 PROCESSING ERROR         **'    
               DISPLAY '**      ABEND IN PARAGRAPH 8000          **'    
               DISPLAY '**      ERROR ON FCSBW629 WRITE          **'    
               DISPLAY '**      STATUS IS ' WS-FBW629-STATUS            
               DISPLAY '*******************************************'    
           END-IF.                                                      
      *                                                                 10280000
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10310000
      ***************************************************************** 10320000
T34097** WRITE INTO THE FILE FCSCS629                                ** 10330000
T34097***************************************************************** 10340000
T34097 8100-WRITE-FIOCS629.                                             
T34097*                                                                 10360000
T34097     WRITE FCSCS629-REC FROM FIOCS629.                            
T34097*                                                                 10380000
T34097     IF  FCS629-CSV-SUCCESSFUL                                    
T34097         CONTINUE                                                 
T34097     ELSE                                                         
T34097         DISPLAY '*******************************************'    
T34097         DISPLAY '**     PCSBW629 PROCESSING ERROR         **'    
T34097         DISPLAY '**      ABEND IN PARAGRAPH 8100          **'    
T34097         DISPLAY '**      ERROR ON FCSCS629 WRITE          **'    
T34097         DISPLAY '**      STATUS IS ' WS-FCS629-CSV-STATUS        
T34097         DISPLAY '*******************************************'    
T34097     END-IF.                                                      
T34097*                                                                 10490000
T34097 8100-EXIT.                                                       
T34097     EXIT.                                                        
T34097*                                                                 10520000
      ***************************************************************** 10530000
      **    9000-TERMINATE                                           ** 10540000
      ***************************************************************** 10550000
       9000-TERMINATE.                                                  
      *                                                                 10570000
T34097     CLOSE FCSBW629-FILE                                          
T34097           FCSCS629-FILE.                                         
      *                                                                 10600000
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10630000
      **************************************************************    10640000
      * THIS INCLUDES 9700-PROCESS-ABEND                           *    10650000
      **************************************************************    10660000
       COPY CPD0023B.                                                   10670000
      *                                                                 10680000
      **************************************************************    10690000
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *    10700000
      **************************************************************    10710000
      *                                                                 10720000
           EXEC SQL                                                     10730000
             INCLUDE CPD09900                                           10740000
           END-EXEC.                                                    10750000
      *                                                                 10760000
