       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    PCSBW621.                                         
       DATE-WRITTEN.  01/19/07.                                         
       DATE-COMPILED.                                                   
      ***************************************************************** 00050001
      ***************************************************************** 00060067
      **               SOUTH CAROLINA ELECTRIC & GAS                 ** 00070001
      **                        COVANSYS                             ** 00080001
      **                                                             ** 00090001
      ********            CUSTOMER SERVICE SYSTEM             ********* 00100001
      ********                      DB2                       ********* 00110001
      ***************************************************************** 00120001
      **                                                             ** 00130001
      **            PROGRAM    MODIFICATION  LOG                     ** 00140001
      **    DATE    INITIALS     REASON                              ** 00150001
      **    ____    ________     ______                              ** 00160080
      **  09/08/06  AD94658      ORIGINAL VERSION                    **         
      **                                                             ** 00130001
C37029**  21 FEB 2008 RF10597    CORRECT CREATION OF OUTPUT FILE     **         
A01391**  06/09     BED          WRITE CA625 FILE WHEN WE HAVE       ** 00130001
A01391**                         NON-ZERO LAT/LON                    ** 00130001
A00633**  07/28     BED          NO NEED NOT INITALIZE CPD0099       ** 00130001
A00633**                         COPYBOOK                            ** 00130001
A00633**                         FIX ERROR MESSAGE TO SHOW CORRECT   ** 00130001
A00633**                         PROGRAM NAME                        ** 00130001
A04880**  09/08/15  SS7F226      REMOVE WRITE LOGIC OF FCSCA625 DD   ** 00130001
A04880**            ACT315       (POST GIS CO-ORDINATES)             ** 00130001
A#5470** 11/10/16   SS95855      REMOVED LAT/LONG FROM MN            **         
      ***************************************************************** 00170001
           REMARKS.                                                     
                              PCSBW621 NARRATIVE                        
            THIS PROGRAM GETS THE INPUT FILE FROM ROUTE SMART AND       
            CREATES TWO FILES. THE FIRST FILE FCSCA44 WILL BE USED      
            TO POST THE RESEQUENCING CHANGES USING PCSBW121 AND THE     
            SECOND FILE FCSCA625 WILL BE USED TO POST THE GIS           
            CO-ORDINATES INTO THE CIS USING PCSCA625.                   
      *                                                                 00240001
                   ---- BASIC BATCH SEQUENCE STRUCTURE ----             
                                                                        
                  0000 - 0000     MAIN CONTROL PATH                     
                  1000 - 1999     INITIALIZATION                        
                  2000 - 4999     MAJOR PROCESSING LOOP                 
                  7000 - 7999     SQL MODULES                           
                  8000 - 8999     OUTPUT MODULES                        
                  9000 - 9799     TERMINATION MODULES                   
                  9900 - 9999     ABEND/ABORT MODULES                   
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
       COPY CSSBW621.                                                           
       COPY CSSCA44.                                                            
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
       COPY CFDCA44.                                                            
       COPY FIOCA44.                                                            
       COPY CFDBW621.                                                           
       COPY FIOBW621.                                                           
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'PCSBW621'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                        PIC X(40)  VALUE             
           'WORKING STORAGE FOR PCSBW621 STARTS HERE'.                  
      *                                                                         
       01  WS-GIS-SOURCE-CODE.                                          
           05  WS-GIS-TEXT                 PIC X(16).                   
           05  WS-GIS-CODE                 PIC X(01).                   
           05  WS-FILLER                   PIC X(63).                   
      *                                                                         
       01  WS-MISC.                                                     
           05  RS-RETURN-CODE              PIC S9(04)   COMP.           
           05  RS-RETURN-CODE-DISP         PIC +Z(04).                  
           05  WS-CURRENT-DATE             PIC X(26).                   
           05  PROGRAM-NAME                PIC X(08)  VALUE             
               'PCSBW621'.                                              
           05  WS-PGRMNAME                 PIC X(08)  VALUE             
               'PCSBW621'.                                              
           05  WS-FBW621-STATUS            PIC X(02).                   
               88 FBW621-SUCCESSFUL                   VALUE '00'.       
               88 END-OF-FCBW621                      VALUE '10'.       
           05  WS-FCA44-STATUS             PIC X(02).                   
               88 FCA44-SUCCESSFUL                   VALUE '00'.        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-A                        PIC X(01)  VALUE 'A'.        
           05  WS-K                        PIC X(01)  VALUE 'K'.        
           05  WS-N                        PIC X(01)  VALUE 'N'.        
           05  WS-Y                        PIC X(01)  VALUE 'Y'.        
           05  WS-U                        PIC X(01)  VALUE 'U'.        
      *                                                                         
      *****************************************************************         
      **                   NECESSARY COPYBOOKS                       **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWS00099                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  ABEND SWITCH COPYBOOK                                      **         
      *****************************************************************         
      *                                                                         
           COPY CWS00010.                                                       
           COPY CWS09900.                                                       
           COPY CWS00038.                                                       
           COPY FIOJC01.                                                        
      *                                                                         
      *****************************************************************         
      **  DB2 AND SQL ERROR CHECKING                                 **         
      *****************************************************************         
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      *****************************************************************         
      **                 COMMON ABEND FUNCTIONALITY                  **         
      *****************************************************************         
      *                                                                         
       01  ABEND-FUNCTIONS.                                             
           05  WS-ABEND-SPACE              PIC X(02)  VALUE SPACE.      
           05  FILLER REDEFINES WS-ABEND-SPACE.                         
               10  WS-ABEND-NUMERIC        PIC 99.                      
      *                                                                         
      *****************************************************************         
      **             TABLE DEFINITIONS AND DB2 INTERACTIONS          **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CSS_JOB_PARM                                               **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBJBPARM                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CSS_UTIL_ENVRNMT                                           **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBUTLENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CSS_MTRD_ENVRNMT                                           **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBMTRENV                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CSS_PREMISE                                                **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBPREM                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      **  CSS_ACCOUNT                                                **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
      *                                                                         
       01  WS-WORKING-STORAGE-END          PIC X(40)    VALUE           
           'WORKING STORAGE FOR PCSBW621 ENDS HERE  '.                  
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      *****************************************************************         
      **    0000-MAIN                                                **         
      *****************************************************************         
      *                                                                         
       0000-MAIN.                                                       
      *                                                                         
           PERFORM 0100-INITIALIZATION                                  
              THRU 0100-EXIT.                                           
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE                                 
              THRU 7000-EXIT.                                           
      *                                                                         
           PERFORM 1000-PROCESS-MAIN                                    
              THRU 1000-EXIT UNTIL END-OF-FCBW621.                      
      *                                                                         
           PERFORM 9000-TERMINATE                                       
              THRU 9000-EXIT.                                           
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    0100-INITIALIZATION.                                     **         
      **       OPEN OUTPUT FILES.                                    **         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZATION.                                             
      *                                                                         
           OPEN INPUT FCSBW621-FILE.                                    
      *                                                                         
           IF  FBW621-SUCCESSFUL                                        
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '**     PCSBW621 PROCESSING ERROR          **'   
               DISPLAY '**     OPEN ERROR ON FCSBW621 FILE        **'   
               DISPLAY '**     FBW621 FILE STATUS =' WS-FBW621-STATUS   
               DISPLAY '**     PROCESSING TERMINATED....          **'   
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           OPEN OUTPUT FCSCA44-FILE.                                    
      *                                                                         
           IF  FCA44-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '********************************************'   
               DISPLAY '**     PCSBW621 PROCESSING ERROR          **'   
               DISPLAY '**     OPEN ERROR ON FCSCA44  FILE        **'   
               DISPLAY '**     FB6211 FILE STATUS =' WS-FCA44-STATUS    
               DISPLAY '**     PROCESSING TERMINATED....          **'   
               DISPLAY '********************************************'   
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
           PERFORM 0200-GET-RUN-TYPE THRU 0200-EXIT.                    
A01391     PERFORM 7200-GET-CURR-DATE     THRU 7200-EXIT.               
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * MODULE TO GET RUN TYPE FOR CURSOR PROCESSING                   *        
      ******************************************************************        
       0200-GET-RUN-TYPE.                                               
      *                                                                         
           MOVE SPACES                     TO WS-SYSIPT.                
           MOVE WS-PGRMNAME                TO WS-PROGRAM.               
           MOVE WS-OPTN                    TO WS-COMMAND.               
           MOVE ZEROS                      TO WS-SEQUENCE.              
           MOVE WS-KEY-AREA                TO E-FJC01-KEY.              
           PERFORM 7600-START-FCSJC01            THRU 7600-EXIT.        
           PERFORM 7610-READ-FCSJC01             THRU 7610-EXIT         
               UNTIL (WS-INPUT-DATA-BREAKDOWN(1:16) =                   
                     'GIS SOURCE CODE=' AND INPUT-ACTIVE)               
                  OR  END-OF-SYSIPT.                                    
                                                                        
           IF  END-OF-SYSIPT                                            
               CONTINUE                                                 
           ELSE                                                         
               MOVE G6-PARM-DATA           TO WS-GIS-SOURCE-CODE        
               PERFORM 7611-CLOSE THRU 7611-EXIT                        
           END-IF.                                                      
      *                                                                         
       0200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *  MAIN MODULE TO EXTRACT CUSTOMER DATA FROM DB2                 *        
      ******************************************************************        
       1000-PROCESS-MAIN.                                               
      *                                                                         
           PERFORM 1100-FORMAT-OUTPUT   THRU 1100-EXIT.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1100-FORMAT-OUTPUT                                             *        
      ******************************************************************        
       1100-FORMAT-OUTPUT.                                              
                                                                        
A01391     IF E-FBW621-PREMISE-NO NOT = WS-CPD99-PREMISE-NO             
A01391         MOVE E-FBW621-PREMISE-NO       TO  WS-CPD99-PREMISE-NO   
A01391         PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT            
A01391     END-IF.                                                      
                                                                        
ACT315     MOVE E-FBW621-PREMISE-NO       TO  E-FCA44-PREMISE-NO.       
                                                                        
           MOVE WS-CPD99-ACCOUNT-NO       TO MN-ACCOUNT-NO              
                                            ,E-FCA44-ACCT-NO.           
                                                                        
           MOVE E-FBW621-UTIL-TYPE        TO MN-CODE-UTIL-TYPE          
                                            ,E-FCA44-CODE-UTIL-TYPE.    
                                                                        
           MOVE E-FBW621-IC-NO            TO MN-IC-NO                   
                                            ,E-FCA44-IC-NO.             
                                                                        
           MOVE E-FBW621-MTR-REF-NO       TO MN-MTR-REF-NO              
                                            ,E-FCA44-MTR-REF-NO.        
                                                                        
      *                                                                         
      *                                                                         
      *                                                                         
           MOVE E-FBW621-SERVICE-DAY(9:2) TO E-FCA44-READ-CYCLE.        
      *                                                                         
           MOVE E-FBW621-REGION(8:3)      TO E-FCA44-LOCAL-OFFICE.      
      *                                                                         
ACT315     MOVE E-FBW621-ROUTE(6:5)       TO E-FCA44-READ-ROUTE.        
                                                                        
           MOVE E-FBW621-SEQUENCE(2:9)    TO E-FCA44-REGISTER-RD-SEQ.   
                                                                        
           MOVE E-FBW621-PREMISE-NO       TO E-FCA44-PREMISE-NO         
      *                                                                         
      *                                                                         
           PERFORM 7100-GET-METER-DET     THRU 7100-EXIT.               
           MOVE MN-METER-NO               TO E-FCA44-METER-NO.          
      *                                                                         
           PERFORM 8000-WRITE-FIOCA44     THRU 8000-EXIT.               
      *                                                                         
           PERFORM 7000-READ-INPUT-FILE   THRU 7000-EXIT.               
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6990-FETCH-CUR-ACCOUNT                                         *        
      *  TO FETCH THE MOST CURRENT ACCOUNT AT THE PREMISE.             *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPDCA099                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 6995-CPD99-ERROR-ROUTINE                                       *        
      ******************************************************************        
       6995-CPD99-ERROR-ROUTINE.                                        
      *                                                                         
A00633     DISPLAY '*************PCSBW621************'.                 
           DISPLAY '* ERROR IN PARA ' ACTIVE-PARAGRAPH.                 
           DISPLAY '* PREMISE-NO = ', HOSTVAR-ELEMENT-1.                
           DISPLAY '* SQL CODE IS  ', WS-CPD99-RETURN-CODE.             
           DISPLAY '* PROGRAM ABENDING...           *'.                 
A00633     DISPLAY '*************PCSBW621************'.                 
           PERFORM 9900-ABEND THRU 9900-EXIT.                           
      *                                                                         
       6995-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7000-READ-INPUT-FILE                                      **          
      ****************************************************************          
      *--------------------------------------------------------------*          
      *   READ INPUT FILE                                            *          
      *--------------------------------------------------------------*          
       7000-READ-INPUT-FILE.                                            
      *                                                                         
           READ FCSBW621-FILE AT END                                    
                GO TO 7000-EXIT.                                        
                                                                        
           IF FBW621-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '******************************************'     
               DISPLAY '**  7000-READ-INPUT-FILE                  '     
               DISPLAY '** ERROR READING FCSBW621'                      
               DISPLAY '** FILE STATUS = ' WS-FBW621-STATUS             
               DISPLAY '******************************************'     
               PERFORM 9000-TERMINATE  THRU 9000-EXIT                   
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **                                                            **          
      **  7100-GET-METER-DET.                                       **          
      **                                                            **          
      ****************************************************************          
      *--------------------------------------------------------------*          
      *   GETS THE METER DETAILS                                     *          
      *--------------------------------------------------------------*          
       7100-GET-METER-DET.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT MN.METER_NO                                       
                 INTO :MN-METER-NO                                      
                 FROM CSS_MTRD_ENVRNMT   MN WITH(READUNCOMMITTED)               
                WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                
                  AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE            
                  AND MN.IC_NO          = :MN-IC-NO                     
                  AND MN.MTR_REF_NO     = :MN-MTR-REF-NO                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MN.METER_NO                                               
MFA-TR*          INTO :MN-METER-NO                                              
MFA-TR*          FROM CSS_MTRD_ENVRNMT   MN                                     
MFA-TR*         WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                        
MFA-TR*           AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                    
MFA-TR*           AND MN.IC_NO          = :MN-IC-NO                             
MFA-TR*           AND MN.MTR_REF_NO     = :MN-MTR-REF-NO                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND                
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSBW621 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7100       **'       
               DISPLAY '** ACCOUNT NO   = ' MN-ACCOUNT-NO               
               DISPLAY '** UTIL TYPE    = ' MN-CODE-UTIL-TYPE           
               DISPLAY '** IC NO        = ' MN-IC-NO                    
               DISPLAY '** MTR REF NO   = ' MN-MTR-REF-NO               
               DISPLAY '** SQLCODE      = ' WS-ACTIVE-RETURN-CODE       
               DISPLAY '*****************************************'      
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      ** 7200-GET-CURR-DATE.                                         **         
      *****************************************************************         
      *--------------------------------------------------------------*          
      *   GETS THE CURRENT DATE                                      *          
      *--------------------------------------------------------------*          
       7200-GET-CURR-DATE.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE =                                           
MFA-TR*             CURRENT DATE                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '****************************************'       
               DISPLAY '**     PCSBW621 PROCESSING ERROR      **'       
               DISPLAY '**      ABEND IN PARAGRAPH 7200       **'       
               DISPLAY '** DATE         = ' WS-CURRENT-DATE             
               DISPLAY '** SQLCODE      = ' WS-ACTIVE-RETURN-CODE       
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **      COPYBOOKS NECESSARY FOR CSS_JOB_PARM PROCESSING        **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD00038                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      ** WRITE INTO THE FILE FCSCA44                                            
      *****************************************************************         
       8000-WRITE-FIOCA44.                                              
      *                                                                         
           WRITE FIOCA44.                                               
      *                                                                         
           IF  FCA44-SUCCESSFUL                                         
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '*******************************************'    
               DISPLAY '**     PCSBW621 PROCESSING ERROR         **'    
               DISPLAY '**      ABEND IN PARAGRAPH 8000          **'    
               DISPLAY '**      ERROR ON FCSCA44 WRITE           **'    
               DISPLAY '**      STATUS IS ' WS-FCA44-STATUS             
               DISPLAY '*******************************************'    
               PERFORM 9000-TERMINATE  THRU 9000-EXIT                   
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    9000-TERMINATE                                           **         
      *****************************************************************         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE FCSBW621-FILE.                                         
           CLOSE FCSCA44-FILE.                                          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * THIS INCLUDES 9700-PROCESS-ABEND                           *            
      **************************************************************            
       COPY CPD0023B.                                                           
      *                                                                         
      **************************************************************            
      *     THIS INCLUDES THE DB2 SQL SYSTEM ABEND MODULE          *            
      **************************************************************            
      *                                                                         
           EXEC SQL                                                             
             INCLUDE CPD09900                                                   
           END-EXEC.                                                            
      *                                                                         
