       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  PCSBW303.                                           
       DATE-WRITTEN.  APR 99.                                           
       DATE-COMPILED.                                                   
       AUTHOR.         CBSIMDS                                          
      *****************************************************************         
      **              SOUTH CAROLINA ELECTRICITY  & GAS              **         
      **                                                             **         
      ********            CUSTOMER SERVICE SYSTEM             *********         
      ********                   DB2                          *********         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE       INITIALS       REASON                            **         
      **                                                             **         
      ** 04/13/99   CBSI, MDS      DEVELOPMENT OF NEW PROGRAM        **         
      **                                                             **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **                                                             **         
      ** DATE    INITIALS       REASON                               **         
      **________  ________   ______________                          **         
T30928** 04/19/06     JC91900    CHANGES FOR TRANSFORMER DEMAND LOAD **         
T30928**                         ING PROJECT.                        **         
      **                                                             **         
A00633**  1/19/08   VIJAY          INCREASE SIZE OF WS-ACCUM-TABLE   **         
A00633**                           FR0M 75 TO 100.  ADD WS-100.      **         
A00633**                           ACTIVITY ACT00000005.             **         
A02778**  9/20/10   MC95456        ADD KWH FIELDS  TO THE FILES      **         
ACT003**  8/23/11   MC95456        ADD NO OF DAYS TO THE END OF FILE **         
ACT003**          A02778-ACT003                                      **         
A05744**  8/23/11   SM93554        CHANGE THE OCCURS LIMIT TO 999    **         
A05744**            ACT050                                           **         
      *****************************************************************         
      *                   PCSBW303   NARRATIVE                        *         
      *                                                               *         
      * THIS PROGRAM READS THE INPUT FROM PCSBW302 AND WRITES         *         
      * SUMMARISED RECORD TO THE OUTPUT.                              *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
                    ---- BASIC SEQUENCE STRUCTURE ----                  
                0000 - 0999     MAIN CONTROL PATH AND INITIALIZATION    
                1000 - 1999     INPUT PROCESSING CONTROL PATH           
                7000 - 7999     DATABASE ACCESS / INPUT MODULES         
                8000 - 8999     OUTPUT MODULES                          
                9000 - 9799     TERMINATION MODULES                     
HPCCDM*EJECT                                                                    
       ENVIRONMENT DIVISION.                                            
       INPUT-OUTPUT SECTION.                                            
       FILE-CONTROL.                                                    
      *                                                                         
       COPY CSSBW302.                                                           
      *                                                                         
           SELECT BW303O ASSIGN TO DA-BW303O                            
              ORGANIZATION IS SEQUENTIAL                                
              ACCESS MODE IS SEQUENTIAL                                 
              FILE STATUS IS WS-BW303-OUTFILE-STATUS.                   
      *                                                                         
       DATA DIVISION.                                                   
       FILE SECTION.                                                    
      *                                                                         
       COPY CFDBW302.                                                           
      *                                                                         
       COPY FIOBW302.                                                           
      *                                                                         
       FD BW303O                                                        
            BLOCK CONTAINS 0 RECORDS                                    
            RECORDING MODE IS F                                         
            LABEL RECORDS ARE STANDARD.                                 
      *                                                                         
       01 E-FBW303-DATA-REC.                                            
          05 E-FBW303-DISTRICT-NO              PIC X(03).               
          05 E-FBW303-LOCAL-OFFICE             PIC X(03).               
          05 E-FBW303-POINT-ID                 PIC X(10).               
          05 E-FBW303-ACCOUNT-NO               PIC X(13).               
          05 E-FBW303-RATE-PLAN-NO             PIC X(03).               
          05 E-FBW303-USED-85-PF-FLAG          PIC X(01).               
          05 E-FBW303-METER-NO                 PIC X(09).               
          05 E-FBW303-TOTAL-KW                 PIC S9(10) COMP-3.       
          05 E-FBW303-TOTAL-KVA                PIC S9(10) COMP-3.       
          05 E-FBW303-PCT-LOAD-ON-XFORMER      PIC S9(05) COMP-3.       
          05 E-FBW303-TOT-PCT-LD-ON-XFMR       PIC S9(06) COMP-3.       
T30928    05 E-FBW303-KVA-NUM                  PIC X(09).               
A02778    05 E-FBW303-TOTAL-KWH                PIC S9(10) COMP-3.       
ACT003    05 E-FBW303-NO-OF-DAYS               PIC S9(04) COMP.         
ACT003    05 FILLER                            PIC X(10).               
      *                                                                         
       WORKING-STORAGE SECTION.                                         
      *                                                                         
       01 WS-TABLE-RECORD.                                              
ACT050    05 WS-ACCUM-TABLE  OCCURS 999 TIMES INDEXED BY WS-INDEX.      
             10 WS-DISTRICT-NO                 PIC X(03).               
             10 WS-LOCAL-OFFICE                PIC X(03).               
             10 WS-POINT-ID                    PIC X(10).               
             10 WS-ACCOUNT-NO                  PIC X(13).               
             10 WS-RATE-PLAN-NO                PIC X(03).               
             10 WS-USED-85-PF-FLAG             PIC X(01).               
             10 WS-METER-NO                    PIC X(09).               
COB305       10 WS-TOTAL-KW        PIC S9(10) COMP-3 VALUE 0.       
COB305       10 WS-TOTAL-KVA        PIC S9(10) COMP-3 VALUE 0.       
COB305       10 WS-PCT-LOAD-ON-XFORMER        PIC S9(05) COMP-3 VALUE 0.       
T30928       10 WS-KVA-NUM                     PIC X(09).               
COB305       10 WS-TOTAL-KWH        PIC S9(10) COMP-3 VALUE 0.       
ACT003       10 WS-NO-OF-DAYS                  PIC S9(04) COMP.         
ACT003       10 FILLER                         PIC X(10).               
      *                                                                         
        01 WS-INPUT-RECORD.                                             
ACT003     05 FILLER                           PIC X(88).               
      *                                                                         
       01 WS-FLAGS.                                                     
          05 WS-READ-STATUS                    PIC X(01)  VALUE 'Y'.    
             88 FIRST-READ                                VALUE 'Y'.    
             88 NOT-FIRST-READ                            VALUE 'N'.    
          05 WS-FBW302-STATUS                  PIC X(02).               
             88 BW303-INFILE-GOOD-OPEN                    VALUE '00'    
                                                                '04'.   
             88 BW303-GOOD-READ                           VALUE '00'.   
             88 BW303-INFILE-GOOD-CLOSE                   VALUE '00'.   
          05 WS-BW303-OUTFILE-STATUS           PIC X(02).               
             88 BW303-OUTFILE-GOOD-OPEN                   VALUE '00'    
                                                                '04'.   
          05 NOT-END-OF-FILE                   PIC X(01)  VALUE 'N'.    
             88 END-OF-FILE                               VALUE 'Y'.    
          05 WS-RESET-CNTR                     PIC X(01)  VALUE 'N'.    
             88 RESET-CNTR                                VALUE 'Y'.    
      *                                                                         
       01 WS-VARIABLES.                                                 
          05 WS-POINT-ID-PREV                  PIC X(10)  VALUE SPACES. 
          05 WS-LOCAL-OFFICE-PREV              PIC X(03)  VALUE SPACES. 
          05 WS-DISTRICT-NO-PREV               PIC X(03)  VALUE SPACES. 
          05 WS-ONE                            PIC 9(01)  VALUE 1.      
ACT050    05 WS-999                            PIC 9(03)  VALUE 999.    
          05 WS-END                            USAGE IS INDEX.          
          05 WS-TOT-PCT-LD-ON-XFMR             PIC S9(06) COMP-3        
                                                          VALUE ZEROS.  
      *                                                                         
      ******************************************************************        
       PROCEDURE DIVISION.                                              
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALISATION         THRU 0100-EXIT.          
      *                                                                         
           PERFORM 2000-READ-INFILE            THRU 2000-EXIT           
                                            UNTIL END-OF-FILE.          
      *                                                                         
           PERFORM 9000-TERMINATE              THRU 9000-EXIT.          
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   OPEN ALL THE FILES                                           *        
      ******************************************************************        
      *                                                                         
       0100-INITIALISATION.                                             
      *                                                                         
           OPEN INPUT  FCSBW302-FILE                                    
                OUTPUT BW303O.                                          
      *                                                                         
           IF  BW303-INFILE-GOOD-OPEN                                   
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'ERROR IN OPENING BW303-INFILE'                  
               DISPLAY 'ERROR STATUS ' WS-FBW302-STATUS                 
               PERFORM 9000-TERMINATE          THRU 9000-EXIT           
           END-IF.                                                      
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  READS THE INPUT FILE AND PROCESSES THE INPUT RECORD          **        
      ******************************************************************        
      *                                                                         
       2000-READ-INFILE.                                                
      *                                                                         
           READ FCSBW302-FILE                                           
               AT END                                                   
                  SET END-OF-FILE              TO TRUE                  
                  GO TO 2000-EXIT.                                      
      *                                                                         
           IF  BW303-GOOD-READ                                          
               EVALUATE TRUE                                            
                  WHEN E-FBW302-KEY-BREC = LOW-VALUES                   
                       MOVE E-FBW302-DATA-REC       TO E-FBW303-DATA-REC
                       WRITE E-FBW303-DATA-REC                          
                  WHEN E-FBW302-KEY-EREC = HIGH-VALUES                  
                       PERFORM 2100-PROCESS-INPUT THRU 2100-EXIT        
                       MOVE E-FBW302-DATA-REC       TO E-FBW303-DATA-REC
                       WRITE E-FBW303-DATA-REC                          
                  WHEN OTHER                                            
                       PERFORM 2100-PROCESS-INPUT THRU 2100-EXIT        
               END-EVALUATE                                             
           ELSE                                                         
               DISPLAY 'ERROR IN READING BW303-INFILE'                  
               DISPLAY 'ERROR STATUS ' WS-FBW302-STATUS                 
               DISPLAY '  PROCESSING TERMINATED  '                      
               PERFORM 9000-TERMINATE          THRU 9000-EXIT           
           END-IF.                                                      
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * THIS PARA CHECKS THE POINT-ID CHANGE FOR ACCUMULATING THE TOTALS        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-INPUT.                                              
           IF FIRST-READ                                                
              INITIALIZE WS-TABLE-RECORD                                
              MOVE E-FBW302-POINT-ID           TO WS-POINT-ID-PREV      
              MOVE E-FBW302-LOCAL-OFFICE       TO WS-LOCAL-OFFICE-PREV  
              MOVE E-FBW302-DISTRICT-NO        TO WS-DISTRICT-NO-PREV   
              SET NOT-FIRST-READ               TO TRUE                  
              SET WS-INDEX                     TO WS-ONE                
           END-IF.                                                      
           MOVE E-FBW302-DISTRICT-NO           TO                       
                                              WS-DISTRICT-NO(WS-INDEX). 
           MOVE E-FBW302-LOCAL-OFFICE          TO                       
                                              WS-LOCAL-OFFICE(WS-INDEX).
           MOVE E-FBW302-POINT-ID              TO WS-POINT-ID(WS-INDEX).
           MOVE E-FBW302-DATA-REC              TO WS-INPUT-RECORD.      
           MOVE 'N'                            TO WS-RESET-CNTR.        
           IF WS-DISTRICT-NO(WS-INDEX) = WS-DISTRICT-NO-PREV            
              IF WS-LOCAL-OFFICE(WS-INDEX) = WS-LOCAL-OFFICE-PREV       
                 IF WS-POINT-ID(WS-INDEX)  = WS-POINT-ID-PREV           
                    PERFORM 2200-ACCUM-TOTALS  THRU 2200-EXIT           
                 ELSE                                                   
                    SET RESET-CNTR             TO TRUE                  
                 END-IF                                                 
              ELSE                                                      
                 SET RESET-CNTR                TO TRUE                  
              END-IF                                                    
           ELSE                                                         
              SET RESET-CNTR                   TO TRUE                  
           END-IF.                                                      
      *                                                                         
           IF RESET-CNTR                                                
              MOVE 'N'                         TO WS-RESET-CNTR         
              SET WS-END                       TO WS-INDEX              
              PERFORM 2500-POPULATE-OUTPUT     THRU 2500-EXIT           
ACT050        VARYING WS-INDEX FROM 1 BY 1 UNTIL                        
SCA006                               WS-INDEX = WS-END OR 
SCA006                               WS-INDEX = WS-999 OR 
                                     WS-DISTRICT-NO(WS-INDEX) = SPACES          
                                                                        
              IF  E-FBW302-KEY-EREC = HIGH-VALUES                       
                  GO TO 2100-EXIT                                       
              END-IF                                                    
              INITIALIZE WS-TABLE-RECORD                                
                         WS-TOT-PCT-LD-ON-XFMR                          
              SET WS-INDEX                     TO WS-ONE                
              MOVE E-FBW302-POINT-ID           TO WS-POINT-ID-PREV      
              MOVE E-FBW302-LOCAL-OFFICE       TO WS-LOCAL-OFFICE-PREV  
              MOVE E-FBW302-DISTRICT-NO        TO WS-DISTRICT-NO-PREV   
              PERFORM 2200-ACCUM-TOTALS        THRU 2200-EXIT           
           END-IF.                                                      
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * THIS PARA POPULATES THE RECORD VARIABLES TO THE WORKING-STORAGE         
      * ARRAY                                                         **        
      ******************************************************************        
      *                                                                         
       2200-ACCUM-TOTALS.                                               
      *                                                                         
           MOVE E-FBW302-POINT-ID              TO WS-POINT-ID(WS-INDEX).
           MOVE E-FBW302-DISTRICT-NO           TO                       
                                              WS-DISTRICT-NO(WS-INDEX). 
           MOVE E-FBW302-LOCAL-OFFICE          TO                       
                                              WS-LOCAL-OFFICE(WS-INDEX).
           MOVE E-FBW302-ACCOUNT-NO            TO                       
                                              WS-ACCOUNT-NO(WS-INDEX).  
           MOVE E-FBW302-RATE-PLAN-NO          TO                       
                                              WS-RATE-PLAN-NO(WS-INDEX).
           MOVE E-FBW302-USED-85-PF-FLAG       TO                       
                                          WS-USED-85-PF-FLAG(WS-INDEX). 
           MOVE E-FBW302-METER-NO              TO                       
                                               WS-METER-NO(WS-INDEX).   
           MOVE E-FBW302-TOTAL-KVA             TO                       
                                               WS-TOTAL-KVA(WS-INDEX).  
           MOVE E-FBW302-TOTAL-KW              TO                       
                                               WS-TOTAL-KW(WS-INDEX).   
A02778     MOVE E-FBW302-TOTAL-KWH             TO                       
A02778                                         WS-TOTAL-KWH(WS-INDEX).  
           MOVE E-FBW302-PCT-LOAD-ON-XFORMER   TO                       
                                       WS-PCT-LOAD-ON-XFORMER(WS-INDEX).
           ADD WS-PCT-LOAD-ON-XFORMER(WS-INDEX) TO                      
                                                 WS-TOT-PCT-LD-ON-XFMR. 
T30928     MOVE E-FBW302-KVA-CAPACITY          TO WS-KVA-NUM(WS-INDEX). 
ACT003     MOVE E-FBW302-NO-OF-DAYS            TO                       
ACT003                                         WS-NO-OF-DAYS(WS-INDEX). 
           SET WS-INDEX  UP BY WS-ONE.                                  
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * THIS PARA POPULATES THE WORKING-STORAGE ARRAY TO THE OUTPUT             
      * RECORD VARIABLES                                                        
      ******************************************************************        
      *                                                                         
       2500-POPULATE-OUTPUT.                                            
      *                                                                         
           MOVE WS-DISTRICT-NO(WS-INDEX)       TO E-FBW303-DISTRICT-NO. 
           MOVE WS-LOCAL-OFFICE(WS-INDEX)      TO E-FBW303-LOCAL-OFFICE.
           MOVE WS-POINT-ID(WS-INDEX)          TO E-FBW303-POINT-ID.    
           MOVE WS-ACCOUNT-NO(WS-INDEX)        TO E-FBW303-ACCOUNT-NO.  
           MOVE WS-RATE-PLAN-NO(WS-INDEX)      TO E-FBW303-RATE-PLAN-NO.
           MOVE WS-USED-85-PF-FLAG(WS-INDEX)   TO                       
                                               E-FBW303-USED-85-PF-FLAG.
           MOVE WS-METER-NO(WS-INDEX)          TO E-FBW303-METER-NO.    
           MOVE WS-TOTAL-KVA(WS-INDEX)         TO E-FBW303-TOTAL-KVA.   
           MOVE WS-TOTAL-KW(WS-INDEX)          TO E-FBW303-TOTAL-KW.    
A02778     MOVE WS-TOTAL-KWH(WS-INDEX)         TO E-FBW303-TOTAL-KWH.   
           MOVE WS-PCT-LOAD-ON-XFORMER(WS-INDEX)                        
                                        TO E-FBW303-PCT-LOAD-ON-XFORMER.
           MOVE WS-TOT-PCT-LD-ON-XFMR          TO                       
                                            E-FBW303-TOT-PCT-LD-ON-XFMR.
T30928     MOVE WS-KVA-NUM(WS-INDEX)            TO  E-FBW303-KVA-NUM.   
ACT003     MOVE WS-NO-OF-DAYS(WS-INDEX)         TO  E-FBW303-NO-OF-DAYS.
           WRITE E-FBW303-DATA-REC.                                     
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  CLOSES   INPUT FILE AND OUTPUT FILE                         *          
      ****************************************************************          
      *                                                                         
       9000-TERMINATE.                                                  
      *                                                                         
           CLOSE   FCSBW302-FILE                                        
                   BW303O.                                              
      *                                                                         
           IF  BW303-INFILE-GOOD-CLOSE                                  
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY 'ERROR IN CLOSING BW303-INFILE'                  
               DISPLAY 'ERROR STATUS ' WS-FBW302-STATUS                 
           END-IF.                                                      
      *                                                                         
           STOP RUN.                                                    
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *             ***** END OF THE PROGRAM *****                    **        
      ******************************************************************        
